/*
SQLyog Community Edition- MySQL GUI v7.11 
MySQL - 5.0.67-community-nt : Database - eve_evemu_static
*********************************************************************
*/


/*!40101 SET NAMES utf8 */;

/*!40101 SET SQL_MODE=''*/;

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

/*Table structure for table `agtMissionGroups` */

DROP TABLE IF EXISTS `agtMissionGroups`;

CREATE TABLE `agtMissionGroups` (
  `corporationID` int(10) unsigned NOT NULL default '0',
  `divisionID` int(10) unsigned NOT NULL default '0',
  `level` int(10) unsigned NOT NULL default '0',
  `missionID` int(10) unsigned default NULL,
  PRIMARY KEY  (`corporationID`,`divisionID`,`level`),
  KEY `divisionID` (`divisionID`),
  KEY `missionID` (`missionID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `agtMissionGroups` */

/*Table structure for table `agtMissions` */

DROP TABLE IF EXISTS `agtMissions`;

CREATE TABLE `agtMissions` (
  `missionID` int(10) unsigned NOT NULL auto_increment,
  `missionName` varchar(255) NOT NULL default '',
  `missionLevel` tinyint(3) unsigned NOT NULL default '0',
  `missionTypeID` int(10) unsigned NOT NULL default '0',
  `importantMission` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`missionID`),
  KEY `missionLevel` (`missionLevel`),
  KEY `missionTypeID` (`missionTypeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `agtMissions` */

/*Table structure for table `agtMissionTypes` */

DROP TABLE IF EXISTS `agtMissionTypes`;

CREATE TABLE `agtMissionTypes` (
  `missionTypeID` int(10) unsigned NOT NULL auto_increment,
  `missionTypeName` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`missionTypeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `agtMissionTypes` */

/*Table structure for table `agtOfferGroups` */

DROP TABLE IF EXISTS `agtOfferGroups`;

CREATE TABLE `agtOfferGroups` (
  `corporationID` int(10) unsigned NOT NULL default '0',
  `divisionID` int(10) unsigned NOT NULL default '0',
  `level` int(10) unsigned NOT NULL default '0',
  `offerID` int(10) unsigned default NULL,
  PRIMARY KEY  (`corporationID`,`divisionID`,`level`),
  KEY `divisionID` (`divisionID`),
  KEY `offerID` (`offerID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `agtOfferGroups` */

/*Table structure for table `agtOfferRequired` */

DROP TABLE IF EXISTS `agtOfferRequired`;

CREATE TABLE `agtOfferRequired` (
  `offerID` int(10) unsigned NOT NULL default '0',
  `typeID` int(10) unsigned NOT NULL default '0',
  `quantity` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`offerID`,`typeID`),
  KEY `typeID` (`typeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `agtOfferRequired` */

/*Table structure for table `agtOfferReward` */

DROP TABLE IF EXISTS `agtOfferReward`;

CREATE TABLE `agtOfferReward` (
  `offerID` int(10) unsigned NOT NULL default '0',
  `typeID` int(10) unsigned NOT NULL default '0',
  `quantity` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`offerID`,`typeID`),
  KEY `typeID` (`typeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `agtOfferReward` */

/*Table structure for table `agtOffers` */

DROP TABLE IF EXISTS `agtOffers`;

CREATE TABLE `agtOffers` (
  `offerID` int(10) unsigned NOT NULL auto_increment,
  `offerName` varchar(255) NOT NULL default '',
  `offerLevel` tinyint(3) unsigned NOT NULL default '0',
  `loyaltyPoints` int(10) unsigned NOT NULL default '0',
  `requiredISK` int(10) unsigned NOT NULL default '0',
  `rewardISK` int(10) unsigned NOT NULL default '0',
  `offerText` mediumtext NOT NULL,
  `offerAcceptedText` mediumtext NOT NULL,
  PRIMARY KEY  (`offerID`),
  KEY `offerLevel` (`offerLevel`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `agtOffers` */

/*Table structure for table `billTypes` */

DROP TABLE IF EXISTS `billTypes`;

CREATE TABLE `billTypes` (
  `billTypeID` int(10) unsigned NOT NULL default '0',
  `billTypeName` varchar(100) NOT NULL default '',
  `description` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`billTypeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `billTypes` */

insert  into `billTypes`(`billTypeID`,`billTypeName`,`description`) values (1,'Market Fine',''),(2,'Rental Bill',''),(3,'Broker Bill',''),(4,'War Bill',''),(5,'Alliance Maintainance Bill','');

/*Table structure for table `bloodlineTypes` */

DROP TABLE IF EXISTS `bloodlineTypes`;

CREATE TABLE `bloodlineTypes` (
  `bloodlineID` int(10) unsigned NOT NULL default '0',
  `typeID` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`bloodlineID`),
  KEY `typeID` (`typeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `bloodlineTypes` */

insert  into `bloodlineTypes`(`bloodlineID`,`typeID`) values (5,1373),(6,1374),(2,1375),(1,1376),(7,1377),(8,1378),(3,1379),(4,1380),(9,1381),(10,1382),(11,1383),(12,1384),(13,1385),(14,1386);

/*Table structure for table `channels` */

DROP TABLE IF EXISTS `channels`;

CREATE TABLE `channels` (
  `channelID` int(10) unsigned NOT NULL auto_increment,
  `ownerID` int(10) unsigned NOT NULL default '0',
  `displayName` varchar(85) default NULL,
  `motd` text,
  `comparisonKey` varchar(11) default NULL,
  `memberless` tinyint(4) NOT NULL default '0',
  `password` varchar(100) default NULL,
  `mailingList` tinyint(4) NOT NULL default '0',
  `cspa` tinyint(4) NOT NULL default '0',
  `temporary` tinyint(4) NOT NULL default '0',
  `mode` tinyint(4) NOT NULL default '0',
  `subscribed` tinyint(4) NOT NULL default '0',
  `estimatedMemberCount` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`channelID`)
) ENGINE=InnoDB AUTO_INCREMENT=30001408 DEFAULT CHARSET=utf8;

/*Data for the table `channels` */

insert  into `channels`(`channelID`,`ownerID`,`displayName`,`motd`,`comparisonKey`,`memberless`,`password`,`mailingList`,`cspa`,`temporary`,`mode`,`subscribed`,`estimatedMemberCount`) values (1,1,'Help\\Rookie Help','rookie MOTD','rookiehelp',1,NULL,0,100,0,3,0,7777),(2,1,'Help\\Help','help MOTD','help',1,NULL,0,100,0,3,0,6666),(1000044,1000044,NULL,NULL,NULL,1,NULL,1,127,0,1,1,1252),(1000115,1000115,NULL,NULL,NULL,1,NULL,1,127,0,1,1,1252),(30001407,30001407,NULL,NULL,NULL,1,NULL,1,127,0,1,1,1252);

/*Table structure for table `channelTypes` */

DROP TABLE IF EXISTS `channelTypes`;

CREATE TABLE `channelTypes` (
  `channelTypeID` int(10) unsigned NOT NULL default '0',
  `channelTypeName` varchar(100) NOT NULL default '',
  `defaultName` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`channelTypeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `channelTypes` */

/*Table structure for table `characterStatic` */

DROP TABLE IF EXISTS `characterStatic`;

CREATE TABLE `characterStatic` (
  `characterID` int(10) unsigned NOT NULL default '0',
  `characterName` varchar(43) NOT NULL default '',
  `accountID` int(10) unsigned default NULL,
  `title` varchar(85) NOT NULL default '',
  `description` text NOT NULL,
  `bounty` double NOT NULL default '0',
  `balance` double NOT NULL default '0',
  `securityRating` double NOT NULL default '0',
  `petitionMessage` varchar(85) NOT NULL default '',
  `logonMinutes` int(10) unsigned NOT NULL default '0',
  `corporationID` int(10) unsigned NOT NULL default '0',
  `corporationDateTime` bigint(20) unsigned NOT NULL default '0',
  `startDateTime` bigint(20) unsigned NOT NULL default '0',
  `createDateTime` bigint(20) unsigned NOT NULL default '0',
  `typeID` int(10) unsigned NOT NULL default '0',
  `raceID` int(10) unsigned NOT NULL default '0',
  `bloodlineID` int(10) unsigned NOT NULL default '0',
  `ancestryID` int(10) unsigned NOT NULL default '0',
  `careerID` int(10) unsigned NOT NULL default '0',
  `schoolID` int(10) unsigned NOT NULL default '0',
  `careerSpecialityID` int(10) unsigned NOT NULL default '0',
  `gender` tinyint(4) NOT NULL default '0',
  `accessoryID` int(10) unsigned default NULL,
  `beardID` int(10) unsigned default NULL,
  `costumeID` int(10) unsigned NOT NULL default '0',
  `decoID` int(10) unsigned default NULL,
  `eyebrowsID` int(10) unsigned NOT NULL default '0',
  `eyesID` int(10) unsigned NOT NULL default '0',
  `hairID` int(10) unsigned NOT NULL default '0',
  `lipstickID` int(10) unsigned default NULL,
  `makeupID` int(10) unsigned default NULL,
  `skinID` int(10) unsigned NOT NULL default '0',
  `backgroundID` int(10) unsigned NOT NULL default '0',
  `lightID` int(10) unsigned NOT NULL default '0',
  `headRotation1` double NOT NULL default '0',
  `headRotation2` double NOT NULL default '0',
  `headRotation3` double NOT NULL default '0',
  `eyeRotation1` double NOT NULL default '0',
  `eyeRotation2` double NOT NULL default '0',
  `eyeRotation3` double NOT NULL default '0',
  `camPos1` double NOT NULL default '0',
  `camPos2` double NOT NULL default '0',
  `camPos3` double NOT NULL default '0',
  `morph1e` double default NULL,
  `morph1n` double default NULL,
  `morph1s` double default NULL,
  `morph1w` double default NULL,
  `morph2e` double default NULL,
  `morph2n` double default NULL,
  `morph2s` double default NULL,
  `morph2w` double default NULL,
  `morph3e` double default NULL,
  `morph3n` double default NULL,
  `morph3s` double default NULL,
  `morph3w` double default NULL,
  `morph4e` double default NULL,
  `morph4n` double default NULL,
  `morph4s` double default NULL,
  `morph4w` double default NULL,
  `stationID` int(10) unsigned NOT NULL default '0',
  `solarSystemID` int(10) unsigned NOT NULL default '0',
  `constellationID` int(10) unsigned NOT NULL default '0',
  `regionID` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`characterID`),
  UNIQUE KEY `characterName` (`characterName`),
  KEY `accountID` (`accountID`),
  KEY `typeID` (`typeID`),
  KEY `accessoryID` (`accessoryID`),
  KEY `ancestryID` (`ancestryID`),
  KEY `beardID` (`beardID`),
  KEY `careerID` (`careerID`),
  KEY `careerSpecialityID` (`careerSpecialityID`),
  KEY `costumeID` (`costumeID`),
  KEY `decoID` (`decoID`),
  KEY `eyebrowsID` (`eyebrowsID`),
  KEY `eyesID` (`eyesID`),
  KEY `hairID` (`hairID`),
  KEY `lipstickID` (`lipstickID`),
  KEY `makeupID` (`makeupID`),
  KEY `schoolID` (`schoolID`),
  KEY `skinID` (`skinID`),
  KEY `backgroundID` (`backgroundID`),
  KEY `lightID` (`lightID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `characterStatic` */

insert  into `characterStatic`(`characterID`,`characterName`,`accountID`,`title`,`description`,`bounty`,`balance`,`securityRating`,`petitionMessage`,`logonMinutes`,`corporationID`,`corporationDateTime`,`startDateTime`,`createDateTime`,`typeID`,`raceID`,`bloodlineID`,`ancestryID`,`careerID`,`schoolID`,`careerSpecialityID`,`gender`,`accessoryID`,`beardID`,`costumeID`,`decoID`,`eyebrowsID`,`eyesID`,`hairID`,`lipstickID`,`makeupID`,`skinID`,`backgroundID`,`lightID`,`headRotation1`,`headRotation2`,`headRotation3`,`eyeRotation1`,`eyeRotation2`,`eyeRotation3`,`camPos1`,`camPos2`,`camPos3`,`morph1e`,`morph1n`,`morph1s`,`morph1w`,`morph2e`,`morph2n`,`morph2s`,`morph2w`,`morph3e`,`morph3n`,`morph3s`,`morph3w`,`morph4e`,`morph4n`,`morph4s`,`morph4w`,`stationID`,`solarSystemID`,`constellationID`,`regionID`) values (3008416,'Antaken Kamola',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000004,30002780,20000407,10000033),(3008417,'Ansalakko Hosiwa',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000259,30001401,20000205,10000016),(3008418,'Ansanaisen Eskonainen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000262,30001401,20000205,10000016),(3008419,'Apas Atshatairos',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000268,30001401,20000205,10000016),(3008420,'Appi Intaa',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000265,30001403,20000205,10000016),(3008421,'Aoken Molehanen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000196,30001669,20000247,10000020),(3008422,'Unsen Ikunola',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000184,30001673,20000247,10000020),(3008423,'Vakkebando Obanmaka',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000187,30001674,20000247,10000020),(3008424,'Tennolen Okogairos',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000190,30001674,20000247,10000020),(3008425,'Iesa Pauljala',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000193,30001674,20000247,10000020),(3008426,'Eskajus Tasabeshi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000199,30001674,20000247,10000020),(3008427,'Inta Iwalarto',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000220,30001729,20000256,10000020),(3008428,'Saksen Hakin',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000232,30001729,20000256,10000020),(3008429,'Visika Tuonerainen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000226,30001731,20000256,10000020),(3008430,'Aratano Sabachi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000235,30001731,20000256,10000020),(3008431,'Raunio Halisa',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000223,30001732,20000256,10000020),(3008432,'Jamon Outo',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000229,30001733,20000256,10000020),(3008433,'Vikuken Ursainio',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000076,30002414,20000355,10000028),(3008434,'Ailma Saimunen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000082,30002414,20000355,10000028),(3008435,'Ruumi Pivas',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000088,30002414,20000355,10000028),(3008436,'Toshanakka Tuimoras',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000091,30002414,20000355,10000028),(3008437,'Vappola Obaken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000079,30002415,20000355,10000028),(3008438,'Suksisto Handagemi',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000085,30002420,20000355,10000028),(3008439,'Unenailen Okiri',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000160,30002512,20000368,10000030),(3008440,'Umunmaa Kovanen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000163,30002512,20000368,10000030),(3008441,'Ishaturi Nimmoda',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000148,30002513,20000368,10000030),(3008442,'Okamainen Nikkoshin',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000154,30002515,20000368,10000030),(3008443,'Shisminen Uusunen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000151,30002517,20000368,10000030),(3008444,'Kain Marrishi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000157,30002517,20000368,10000030),(3008445,'Paarubei To',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000025,30002648,20000388,10000032),(3008446,'Arken Paara',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000034,30002648,20000388,10000032),(3008447,'Nagunitimo Sakehama',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000022,30002650,20000388,10000032),(3008448,'Akavera Okamaa',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000037,30002650,20000388,10000032),(3008449,'Edashi Ylikuro',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000028,30002654,20000388,10000032),(3008450,'Sukkenen Shiriken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000031,30002654,20000388,10000032),(3008451,'Ichino Iesemi',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000010,30002776,20000407,10000033),(3008452,'Kirlilen Aina',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000016,30002778,20000407,10000033),(3008453,'Watalenen Tokaala',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000019,30002778,20000407,10000033),(3008454,'Kigora Ylomainen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000007,30002779,20000407,10000033),(3008455,'Piertalen Tano',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000013,30002779,20000407,10000033),(3008456,'Yanumano Jaterjutti',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000067,30003081,20000450,10000038),(3008457,'Murikomo Narekoso',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000058,30003082,20000450,10000038),(3008458,'Arjus Ohbesa',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000064,30003082,20000450,10000038),(3008459,'Oravas Rappalen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000070,30003082,20000450,10000038),(3008460,'Wara Odanas',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000073,30003083,20000450,10000038),(3008461,'Ihumakka Kottanen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000061,30003084,20000450,10000038),(3008462,'Oksilo Oganda',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000040,30003393,20000495,10000042),(3008463,'Kentanen Shinagimi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000043,30003393,20000495,10000042),(3008464,'Kakkiken Ahtamainen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000055,30003394,20000495,10000042),(3008465,'Tintoh Hino',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000052,30003395,20000495,10000042),(3008466,'Mamonaitoh Oichidomon',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000049,30003397,20000495,10000042),(3008467,'Okkamon Ohmamon',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000046,30003399,20000495,10000042),(3008468,'Uppila Vuokiken',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000094,30003429,20000500,10000042),(3008469,'Haan Okaras',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000109,30003429,20000500,10000042),(3008470,'Inikas Taskaila',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000100,30003430,20000500,10000042),(3008471,'Iwachida Otamon',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000106,30003430,20000500,10000042),(3008472,'Ogishaima Onaneri',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000097,30003432,20000500,10000042),(3008473,'Onesutsu Morikka',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000103,30003432,20000500,10000042),(3008474,'Ichosima Kakkaho',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000241,30004099,20000599,10000052),(3008475,'Ausmunen Poikka',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000247,30004099,20000599,10000052),(3008476,'Isosemi Aokinen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000253,30004101,20000599,10000052),(3008477,'Ausmanas Ari',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000238,30004102,20000599,10000052),(3008478,'Aurogas Inoras',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000244,30004102,20000599,10000052),(3008479,'Aurovuo Hitimo',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000250,30004103,20000599,10000052),(3008480,'Vikuken Imata',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000139,30004248,20000622,10000054),(3008481,'Iesaken Ohti',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000145,30004248,20000622,10000054),(3008482,'Ijinen Nakikonto',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000136,30004249,20000622,10000054),(3008483,'Haakamon Ponusiemi',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000130,30004250,20000622,10000054),(3008484,'Banninaisen Virjekaita',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000142,30004250,20000622,10000054),(3008485,'Bastaras Enahtila',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000133,30004253,20000622,10000054),(3008486,'Edononi Tanskamon',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000178,30004289,20000627,10000054),(3008487,'Kaurelen Hakkomogas',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000172,30004292,20000627,10000054),(3008488,'Pyysaro Avvas',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000169,30004293,20000627,10000054),(3008489,'Roikkaraitoh Kakkola',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000175,30004293,20000627,10000054),(3008490,'Isaila Motsen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000166,30004295,20000627,10000054),(3008491,'Vila Irkas',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000181,30004295,20000627,10000054),(3008492,'Isudakken Reima',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000112,30005001,20000732,10000064),(3008493,'Oijila Haanjuro',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000124,30005001,20000732,10000064),(3008494,'Ullen Murikomo',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000127,30005001,20000732,10000064),(3008495,'Uetamiras Auritoh',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000115,30005003,20000732,10000064),(3008496,'Orseken Aandu',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000118,30005004,20000732,10000064),(3008497,'Ijoluori Kaishoyoemon',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000121,30005007,20000732,10000064),(3008498,'Nomillala Asenen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000214,30005030,20000736,10000065),(3008499,'Naida Nuukka',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000205,30005031,20000736,10000065),(3008500,'Kavukato Kasmon',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000202,30005032,20000736,10000065),(3008501,'Imaka Paalvalen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000208,30005035,20000736,10000065),(3008502,'Hadunomi Sikopala',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000211,30005035,20000736,10000065),(3008503,'Pieras Rallolen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000217,30005035,20000736,10000065),(3008504,'Ahanada Nutsu',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000256,30001399,20000205,10000016),(3008505,'Shinulaito Ontaa',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000271,30001399,20000205,10000016),(3008506,'Asetarmon Okelela',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000274,30000149,20000021,10000002),(3008507,'Asha Nama',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000283,30000120,20000017,10000002),(3008508,'Asenemi Urawarras',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000286,30000121,20000017,10000002),(3008509,'Asata Doisoro',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000289,30000121,20000017,10000002),(3008510,'Aariwa Isera',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000292,30000126,20000018,10000002),(3008511,'Airada Ikagonji',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000298,30000129,20000018,10000002),(3008512,'Pikken Sasiyobei',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000295,30000130,20000018,10000002),(3008513,'Isunmaa Hyyhenda',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000277,30000148,20000021,10000002),(3008514,'Korakila Mashin',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000280,30000149,20000021,10000002),(3008515,'Itanala Oila',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000301,30000188,20000027,10000002),(3008516,'Inkozaitoh Niruda',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000304,30000188,20000027,10000002),(3008517,'Eskajus Ayuki',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000307,30000189,20000027,10000002),(3008518,'Marelar Umian',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007732,30002198,20000323,10000043),(3008519,'Igu Hudi',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007738,30002197,20000323,10000043),(3008520,'Atudad Morni',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007735,30002202,20000323,10000043),(3008521,'Bona Sasfal',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007762,30002226,20000327,10000043),(3008522,'Artimielia Neraza',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007765,30002226,20000327,10000043),(3008523,'Zach Dormondan',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007759,30002232,20000327,10000043),(3008524,'Samak Nardaz',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007750,30002263,20000332,10000043),(3008525,'Artamya Sane',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007756,30002265,20000332,10000043),(3008526,'Goram Lizta',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007753,30002266,20000332,10000043),(3008527,'Nenshikih Rinreh',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007747,30002276,20000334,10000043),(3008528,'Danera Hirnun',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007741,30002278,20000334,10000043),(3008529,'Seyvami Amol',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007744,30002281,20000334,10000043),(3008530,'Ahni Fahama',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007768,30002201,20000323,10000043),(3008531,'Rima Temira',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007771,30002197,20000323,10000043),(3008532,'Honis Nimedaz',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007777,30002198,20000323,10000043),(3008533,'Yanoyal Irahir',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007774,30002203,20000323,10000043),(3008534,'Hareydar Hesal',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007849,30002989,20000438,10000036),(3008535,'Ebneloum Anes',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007840,30002993,20000438,10000036),(3008536,'Lalmesras Todana',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007843,30002993,20000438,10000036),(3008537,'Shanyi Urkham',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007846,30002993,20000438,10000036),(3008538,'Choga Bahyahi',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007864,30003001,20000440,10000036),(3008539,'Nardir Linakin',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007870,30003003,20000440,10000036),(3008540,'Gousar Sihtata',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007873,30003003,20000440,10000036),(3008541,'Fareer Malkila',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007867,30003004,20000440,10000036),(3008542,'Kahtin Khahsel',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007828,30003474,20000507,10000043),(3008543,'Sharroon Rarala',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007831,30003474,20000507,10000043),(3008544,'Tamata Iareb',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007834,30003479,20000507,10000043),(3008545,'Shabrapa Dubahar',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007837,30003479,20000507,10000043),(3008546,'Chozal Yodurios',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007852,30003514,20000513,10000043),(3008547,'Cankihma Azhgabid',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007858,30003514,20000513,10000043),(3008548,'Sezeni Bezbode',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007855,30003517,20000513,10000043),(3008549,'Diam Sabidag',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007861,30003517,20000513,10000043),(3008550,'Batehran Kemdiya',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007804,30004079,20000596,10000052),(3008551,'Ezal Araz',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007807,30004080,20000596,10000052),(3008552,'Puhtesh Niusa',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007813,30004081,20000596,10000052),(3008553,'Shabiri Arul',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007810,30004082,20000596,10000052),(3008554,'Zoke Eredlis',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007819,30005038,20000737,10000065),(3008555,'Malabapt Ove',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007825,30005040,20000737,10000065),(3008556,'Sanzuch Rah',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007816,30005043,20000737,10000065),(3008557,'Ladisa Mobit',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007822,30005043,20000737,10000065),(3008558,'Shelata Nayab',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007780,30005045,20000738,10000065),(3008559,'Yapan Aka',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007786,30005045,20000738,10000065),(3008560,'Ozaya Barimam',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007783,30005046,20000738,10000065),(3008561,'Yomada Atour',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007789,30005048,20000738,10000065),(3008562,'Machal Asesamy',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007885,30005222,20000764,10000067),(3008563,'Kaym Amemih',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007879,30005224,20000764,10000067),(3008564,'Barmass Belasiad',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007882,30005225,20000764,10000067),(3008565,'Nirkun Mese',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007876,30005227,20000764,10000067),(3008566,'Imomara Gib',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007795,30005261,20000770,10000067),(3008567,'Talane Zierer',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007801,30005261,20000770,10000067),(3008568,'Bela Nureles',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007792,30005262,20000770,10000067),(3008569,'Dekrata Abes',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007798,30005262,20000770,10000067),(3008570,'Pooner Kielish',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007888,30002197,20000323,10000043),(3008571,'Absoom Masel',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007999,30001701,20000252,10000020),(3008572,'Subomous Arraz',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008002,30001701,20000252,10000020),(3008573,'Sigathim Alurva',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008005,30001702,20000252,10000020),(3008574,'Apharud Sragu',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007996,30001703,20000252,10000020),(3008575,'Pijil Pedfi',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007897,30002198,20000323,10000043),(3008576,'Atoram Shukonren',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007894,30002200,20000323,10000043),(3008577,'Namai Manir',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007891,30002203,20000323,10000043),(3008578,'Sanopi Ilik',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007966,30004084,20000597,10000052),(3008579,'Shizemteh Rasabe',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007960,30004088,20000597,10000052),(3008580,'Pintat Panai',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007969,30004088,20000597,10000052),(3008581,'Kourim Mooh',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007963,30004090,20000597,10000052),(3008582,'Mulu Batnu',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007984,30004155,20000608,10000052),(3008583,'Nada Samahi',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007990,30004155,20000608,10000052),(3008584,'Gith Pamar',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007993,30004156,20000608,10000052),(3008585,'Phasas Mynuma',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007987,30004160,20000608,10000052),(3008586,'Athasho Manad',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007924,30004242,20000621,10000054),(3008587,'Jafshi Nihans',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007933,30004242,20000621,10000054),(3008588,'Pahranat Mehatoor',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007927,30004246,20000621,10000054),(3008589,'Landhya Yural',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007930,30004246,20000621,10000054),(3008590,'Loranan Selobnub',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007945,30004280,20000626,10000054),(3008591,'Orri Jalet',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007936,30004287,20000626,10000054),(3008592,'Sanasna Adiam',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007939,30004287,20000626,10000054),(3008593,'Goun Ghoohka',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007942,30004287,20000626,10000054),(3008594,'Jissi Rahmogheb',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007954,30004304,20000629,10000054),(3008595,'Shobhena Yoonareyd',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007951,30004308,20000629,10000054),(3008596,'Baala Memiru',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007948,30004309,20000629,10000054),(3008597,'Sarahav Ahmach',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007957,30004309,20000629,10000054),(3008598,'Mood Elhim',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007900,30005046,20000738,10000065),(3008599,'Hecala Jiradal',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007903,30005046,20000738,10000065),(3008600,'Mulata Siminu',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007906,30005049,20000738,10000065),(3008601,'Gakeli Zailkamirat',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007909,30005049,20000738,10000065),(3008602,'Tehi Norersi',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007978,30005230,20000765,10000067),(3008603,'Zulih Yesten',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007981,30005231,20000765,10000067),(3008604,'Bierohr Rarrodaka',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007972,30005232,20000765,10000067),(3008605,'Borvah Goumis',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007975,30005232,20000765,10000067),(3008606,'Netzang Noredjol',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007921,30005243,20000767,10000067),(3008607,'Yalka Mamdaya',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007915,30005245,20000767,10000067),(3008608,'Osas Ovan',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007918,30005246,20000767,10000067),(3008609,'Naz Murviro',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60007912,30005248,20000767,10000067),(3008610,'Arat Samas',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008008,30004098,20000599,10000052),(3008611,'Chamag Darami',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008026,30001687,20000250,10000020),(3008612,'Norma Uredaz',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008020,30001690,20000250,10000020),(3008613,'Mafsizan Lebai',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008029,30001690,20000250,10000020),(3008614,'Yasheri Mida',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008023,30001692,20000250,10000020),(3008615,'Manalud Khnin',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008047,30001730,20000256,10000020),(3008616,'Naheha Soza',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008050,30001731,20000256,10000020),(3008617,'Petashih Rark',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008053,30001732,20000256,10000020),(3008618,'Bittanshal Anagh',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008044,30001733,20000256,10000020),(3008619,'Arthal Arisi',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008041,30002220,20000326,10000043),(3008620,'Arion Erbamait',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008032,30002224,20000326,10000043),(3008621,'Maeemlie Kebeyatiri',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008035,30002224,20000326,10000043),(3008622,'Irabam Tobi',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008038,30002224,20000326,10000043),(3008623,'Psen Mardon',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008089,30002252,20000330,10000043),(3008624,'Pakefarit Kotiston',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008080,30002254,20000330,10000043),(3008625,'Khahran Sragu',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008086,30002254,20000330,10000043),(3008626,'Ohrof Hunis',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008083,30002256,20000330,10000043),(3008627,'Rarmesu Chomyah',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008074,30002982,20000437,10000036),(3008628,'Keneka Aremyi',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008068,30002983,20000437,10000036),(3008629,'Arerar Hajaphron',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008077,30002984,20000437,10000036),(3008630,'Nidebora Lahnara',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008071,30002986,20000437,10000036),(3008631,'Sibahbam Mehnih',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008107,30003072,20000449,10000038),(3008632,'Binada Chutsya',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008113,30003073,20000449,10000038),(3008633,'Huro Itmu',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008104,30003076,20000449,10000038),(3008634,'Ahvasa Aulin',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008110,30003077,20000449,10000038),(3008635,'Brara Yastet',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008056,30003502,20000511,10000043),(3008636,'Drirshoran Eltis',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008059,30003502,20000511,10000043),(3008637,'Rova Amareh',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008065,30003502,20000511,10000043),(3008638,'Horshandas Seitam',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008062,30003505,20000511,10000043),(3008639,'Bishos Narzash',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008014,30004100,20000599,10000052),(3008640,'Ravya Drakiereh',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008011,30004102,20000599,10000052),(3008641,'Aslech Chedo',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008017,30004103,20000599,10000052),(3008642,'Hahin Abnum',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008116,30004242,20000621,10000054),(3008643,'Kebamoum Ahvar',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008125,30004242,20000621,10000054),(3008644,'Paraden Chidah',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008119,30004247,20000621,10000054),(3008645,'Mishriji Adamil',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008122,30004247,20000621,10000054),(3008646,'Opoud Innan',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008098,30005194,20000760,10000067),(3008647,'Natehrnund Pelarne',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008101,30005194,20000760,10000067),(3008648,'Talidal Aurad',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008092,30005195,20000760,10000067),(3008649,'Loun Uphret',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008095,30005195,20000760,10000067),(3008650,'Fislir Maddam',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008128,30002199,20000323,10000043),(3008651,'Ataru Sehshi',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008230,30001670,20000247,10000020),(3008652,'Ordize Riraba',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008224,30001674,20000247,10000020),(3008653,'Arheh Aman',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008227,30001674,20000247,10000020),(3008654,'Hessiehan Chemilip',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008233,30001674,20000247,10000020),(3008655,'Hepeta Bis',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008134,30002197,20000323,10000043),(3008656,'Babenir Takaso',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008131,30002201,20000323,10000043),(3008657,'Alkarnour Raa',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008137,30002201,20000323,10000043),(3008658,'Shasha Hifa',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008212,30002971,20000435,10000036),(3008659,'Anayoud Hehyoorath',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008215,30002972,20000435,10000036),(3008660,'Koored Maires',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008218,30002973,20000435,10000036),(3008661,'Dakiribi Yamaden',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008221,30002974,20000435,10000036),(3008662,'Barva Barishena',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008188,30003092,20000452,10000038),(3008663,'Habi Ghamri',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008191,30003092,20000452,10000038),(3008664,'Galiahervan Hiasan',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008197,30003095,20000452,10000038),(3008665,'Onpi Safaner',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008194,30003096,20000452,10000038),(3008666,'Shakah Yah',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008164,30003488,20000509,10000043),(3008667,'Falian Khivad',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008167,30003488,20000509,10000043),(3008668,'Chana Andichouz',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008173,30003488,20000509,10000043),(3008669,'Ahayen Mulya',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008170,30003492,20000509,10000043),(3008670,'Abendebi Noama',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008152,30004248,20000622,10000054),(3008671,'Ahroun Sinkhevir',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008161,30004248,20000622,10000054),(3008672,'Nazed Dirva',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008155,30004251,20000622,10000054),(3008673,'Maheesab Vatiu',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008158,30004252,20000622,10000054),(3008674,'Zaruh Pirusafa',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008200,30005045,20000738,10000065),(3008675,'Ghosh Sadmiahas',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008209,30005045,20000738,10000065),(3008676,'Kasote Kana',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008206,30005047,20000738,10000065),(3008677,'Abian Serira',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008203,30005048,20000738,10000065),(3008678,'Tokodan Yoti',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008149,30005237,20000766,10000067),(3008679,'Oshu Ghaty',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008140,30005238,20000766,10000067),(3008680,'Ayoo Posar',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008143,30005239,20000766,10000067),(3008681,'Biru Gasavak',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008146,30005239,20000766,10000067),(3008682,'Care Naskad',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008176,30005261,20000770,10000067),(3008683,'Ikhtaz Zaiden',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008179,30005261,20000770,10000067),(3008684,'Armanad Hokaba',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008182,30005261,20000770,10000067),(3008685,'Ihrda Goram',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008185,30005263,20000770,10000067),(3008686,'Bushid Shahni',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008245,30005275,20000772,10000067),(3008687,'Gamis Pena',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008239,30005276,20000772,10000067),(3008688,'Madekhti Ahayen',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008242,30005279,20000772,10000067),(3008689,'Edel Roh',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008236,30005280,20000772,10000067),(3008690,'Bingavam Ashkal',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008248,30002200,20000323,10000043),(3008691,'Sohich Alave',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008332,30001700,20000252,10000020),(3008692,'Lahnina Aslech',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008335,30001700,20000252,10000020),(3008693,'Gyakager Aresh',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008338,30001700,20000252,10000020),(3008694,'Shimu Chamemi',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008341,30001700,20000252,10000020),(3008695,'Aulem Ason',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008254,30002198,20000323,10000043),(3008696,'Thanabi Mona',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008257,30002198,20000323,10000043),(3008697,'Imafa Snamshasan',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008251,30002200,20000323,10000043),(3008698,'Bayuka Iasah',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008302,30002972,20000435,10000036),(3008699,'Zigh Taheenen',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008296,30002973,20000435,10000036),(3008700,'Shochu Nabah',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008299,30002973,20000435,10000036),(3008701,'Mekashtad Fambun',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008305,30002974,20000435,10000036),(3008702,'Arpah Tarel',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008344,30003092,20000452,10000038),(3008703,'Nag Payah',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008347,30003092,20000452,10000038),(3008704,'Gardasstar Yishinoon',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008353,30003094,20000452,10000038),(3008705,'Meni Siparne',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008350,30003097,20000452,10000038),(3008706,'Laran Semottoriku',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008284,30003473,20000507,10000043),(3008707,'Sirita Komosa',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008290,30003473,20000507,10000043),(3008708,'Navare Akand',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008287,30003474,20000507,10000043),(3008709,'Kainkan Shobrafa',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008293,30003480,20000507,10000043),(3008710,'Dethahal Naavar',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008314,30004136,20000605,10000052),(3008711,'Arira Barahan',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008308,30004137,20000605,10000052),(3008712,'Raniyoun Kormen',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008311,30004137,20000605,10000052),(3008713,'Gada Kati',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008317,30004137,20000605,10000052),(3008714,'Mozat Kartan',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008323,30004268,20000624,10000054),(3008715,'Sannisu Thoji',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008320,30004269,20000624,10000054),(3008716,'Samin Chisara',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008326,30004269,20000624,10000054),(3008717,'Dayera Ezras',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008329,30004269,20000624,10000054),(3008718,'Mebhiyen Ranaka',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008260,30005237,20000766,10000067),(3008719,'Ehal Darmazaf',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008269,30005237,20000766,10000067),(3008720,'Kazem Chomyah',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008266,30005240,20000766,10000067),(3008721,'Ebira Manera',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008263,30005242,20000766,10000067),(3008722,'Nada Phalind',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008278,30005256,20000769,10000067),(3008723,'Shanna Laban',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008272,30005257,20000769,10000067),(3008724,'Chaiga Sumy',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008275,30005259,20000769,10000067),(3008725,'Harda Nedada',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008281,30005260,20000769,10000067),(3008726,'Shika Ginanis',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008356,30005289,20000774,10000067),(3008727,'Khash Youn',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008365,30005289,20000774,10000067),(3008728,'Bomana Elchen',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008359,30005290,20000774,10000067),(3008729,'Adodi Jares',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008362,30005293,20000774,10000067),(3008730,'Bahda Berdih',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008368,30002279,20000334,10000043),(3008731,'Zanes Ilayai',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008422,30001658,20000245,10000020),(3008732,'Yapera Fissi',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008419,30001660,20000245,10000020),(3008733,'Mides Hathah',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008416,30001661,20000245,10000020),(3008734,'Nayeri Shushi',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008425,30001661,20000245,10000020),(3008735,'Avenid Voohah',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008371,30002277,20000334,10000043),(3008736,'Ananya Mahir',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008377,30002277,20000334,10000043),(3008737,'Atair Dinelu',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008374,30002282,20000334,10000043),(3008738,'Alaz Chaktaren',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008431,30003493,20000510,10000043),(3008739,'Orda Sand',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008428,30003496,20000510,10000043),(3008740,'Bognan Andrarad',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008437,30003497,20000510,10000043),(3008741,'Hounatad Mezan',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008434,30003498,20000510,10000043),(3008742,'Kiskin Nonon',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008413,30003530,20000515,10000043),(3008743,'Kirul Butaroob',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008404,30003531,20000515,10000043),(3008744,'Goum Mimian',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008407,30003532,20000515,10000043),(3008745,'Obron Chajma',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008410,30003537,20000515,10000043),(3008746,'Omdan Jehasar',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008464,30004110,20000601,10000052),(3008747,'Partod Darmete',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008470,30004111,20000601,10000052),(3008748,'Ghaisa Manot',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008473,30004111,20000601,10000052),(3008749,'Sathepadi Nahyeen',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008467,30004112,20000601,10000052),(3008750,'Majamar Abouloun',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008380,30004237,20000620,10000054),(3008751,'Kasonia Lahror',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008383,30004237,20000620,10000054),(3008752,'Gornoon Mezankhenij',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008389,30004237,20000620,10000054),(3008753,'Ajayi Ahih',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008386,30004239,20000620,10000054),(3008754,'Esala Azen',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008446,30004280,20000626,10000054),(3008755,'Yahrneaz Nelamou',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008443,30004283,20000626,10000054),(3008756,'Kahiaresh Neziel',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008440,30004284,20000626,10000054),(3008757,'Baphio Babeta',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008449,30004286,20000626,10000054),(3008758,'Yithmi Magnu',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008479,30004288,20000627,10000054),(3008759,'Akenul Moutid',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008485,30004288,20000627,10000054),(3008760,'Zalemad Nouhevoh',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008476,30004296,20000627,10000054),(3008761,'Tim Barma',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008482,30004296,20000627,10000054),(3008762,'Onil Aviakil',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008455,30005057,20000740,10000065),(3008763,'Sahindem Shefan',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008461,30005059,20000740,10000065),(3008764,'Hokshmi Aramin',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008452,30005060,20000740,10000065),(3008765,'Djabak Lahtami',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008458,30005060,20000740,10000065),(3008766,'Mirose Sahalondri',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008392,30005229,20000765,10000067),(3008767,'Sapi Nayhah',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008398,30005229,20000765,10000067),(3008768,'Nabobeh Sarwed',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008401,30005231,20000765,10000067),(3008769,'Shartimih Khalabnar',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008395,30005234,20000765,10000067),(3008770,'Bavadon Gali',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008491,30002192,20000322,10000043),(3008771,'Nehrnah Gorouyar',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008494,30002187,20000322,10000043),(3008772,'Hilala Yasalek',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008521,30001676,20000248,10000020),(3008773,'Niadek Emanad',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008527,30001676,20000248,10000020),(3008774,'Bamara Garisas',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008518,30001677,20000248,10000020),(3008775,'Diada Hundron',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008524,30001679,20000248,10000020),(3008776,'Sarviyi Sou',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008500,30002190,20000322,10000043),(3008777,'Sibih Akhmoh',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008503,30002191,20000322,10000043),(3008778,'Natousha Mithier',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008497,30002193,20000322,10000043),(3008779,'Zooh Ouder',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008551,30002975,20000436,10000036),(3008780,'Eboum Ermicha',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008542,30002977,20000436,10000036),(3008781,'Dep Fata',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008545,30002980,20000436,10000036),(3008782,'Kukhra Naeellie',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008548,30002980,20000436,10000036),(3008783,'Akath Sihrzim',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008536,30002988,20000438,10000036),(3008784,'Sehrbi Hepoud',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008530,30002992,20000438,10000036),(3008785,'Hooran Pinihr',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008533,30002993,20000438,10000036),(3008786,'Taridor Bovi',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008539,30002993,20000438,10000036),(3008787,'Pazoo Arayya',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008509,30004077,20000596,10000052),(3008788,'Dahyaron Lahara',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008515,30004078,20000596,10000052),(3008789,'Hemtalasi Hemotri',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008506,30004079,20000596,10000052),(3008790,'Afodir Jarver',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008512,30004083,20000596,10000052),(3008791,'Azhdan Bovamih',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008566,30004239,20000620,10000054),(3008792,'Lomdor Ayas',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008569,30004240,20000620,10000054),(3008793,'Mayir Ajonar',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008572,30004240,20000620,10000054),(3008794,'Maires Shahyanikh',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008575,30004241,20000620,10000054),(3008795,'Yerora Absaned',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008578,30005030,20000736,10000065),(3008796,'Ansan Yoosstet',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008584,30005031,20000736,10000065),(3008797,'Teni Garea',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008581,30005034,20000736,10000065),(3008798,'Elnotyan Pem',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008587,30005035,20000736,10000065),(3008799,'Zia Mesghoh',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008602,30005039,20000737,10000065),(3008800,'Pireash Khavesa',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008611,30005039,20000737,10000065),(3008801,'Ubardu Nuhafshen',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008608,30005040,20000737,10000065),(3008802,'Heena Kinulia',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008605,30005043,20000737,10000065),(3008803,'Eba Nodra',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008554,30005052,20000739,10000065),(3008804,'Mankoor Safilouz',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008557,30005052,20000739,10000065),(3008805,'Thanikhtid Farorad',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008563,30005052,20000739,10000065),(3008806,'Tizeli Ebthad',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008560,30005054,20000739,10000065),(3008807,'Gai Charil',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008596,30005275,20000772,10000067),(3008808,'Lobrup Simeka',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008590,30005276,20000772,10000067),(3008809,'Vanel Kheed',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008593,30005276,20000772,10000067),(3008810,'Kherarabadi Ubigh',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008599,30005276,20000772,10000067),(3008811,'Fosha Dyrer',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008614,30004095,20000598,10000052),(3008812,'Yimla Bashakru',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008623,30004084,20000597,10000052),(3008813,'Pevalir Kereka',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008626,30004087,20000597,10000052),(3008814,'Pamih Unnirgous',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008629,30004087,20000597,10000052),(3008815,'Bouras Gakeli',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008620,30004095,20000598,10000052),(3008816,'Molnahr Fehyagh',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008617,30004096,20000598,10000052),(3008817,'Bamtusha Ahrdia',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008641,30004142,20000606,10000052),(3008818,'Krafeus Ghivaz',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008644,30004146,20000606,10000052),(3008819,'Banseran Nelda',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008647,30004147,20000606,10000052),(3008820,'Harza Jibutas',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008632,30004155,20000608,10000052),(3008821,'Pivoon Thagayom',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008635,30004157,20000608,10000052),(3008822,'Mormie Efaki',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008638,30004160,20000608,10000052),(3008823,'Semilbaz Chibi',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008650,30003522,20000514,10000043),(3008824,'Khema Soyyelab',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008668,30003494,20000510,10000043),(3008825,'Avel Sounilier',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008671,30003496,20000510,10000043),(3008826,'Hemigh Amalah',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008674,30003498,20000510,10000043),(3008827,'Zefaramen Sadiri',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008659,30003508,20000512,10000043),(3008828,'Kazama Dima',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008665,30003509,20000512,10000043),(3008829,'Gasuk Oshat',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008662,30003512,20000512,10000043),(3008830,'Samas Nirla',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008656,30003521,20000514,10000043),(3008831,'Gakhireh Aboh',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008653,30003525,20000514,10000043),(3008832,'Pareh Mere',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008677,30003541,20000516,10000043),(3008833,'Zamon Assaus',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008680,30003541,20000516,10000043),(3008834,'Garbiran Vardali',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008683,30003543,20000516,10000043),(3008835,'Apra Alahma',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008686,30005038,20000737,10000065),(3008836,'Gahta Nakan',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008716,30005031,20000736,10000065),(3008837,'Chankoh Mizzerba',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008719,30005032,20000736,10000065),(3008838,'Lenau Ganeme',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008713,30005035,20000736,10000065),(3008839,'Nurveh Mermazgab',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008692,30005038,20000737,10000065),(3008840,'Arasat Boulhera',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008689,30005040,20000737,10000065),(3008841,'Ahnuni Mirder',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008698,30005044,20000738,10000065),(3008842,'Akart Zaltu',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008695,30005045,20000738,10000065),(3008843,'Makaser Amorih',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008701,30005045,20000738,10000065),(3008844,'Nussend Mahle',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008704,30005082,20000744,10000065),(3008845,'Ahan Hemirin',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008707,30005085,20000744,10000065),(3008846,'Sorpen Bonorahel',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008710,30005085,20000744,10000065),(3008847,'Bairshir Umam',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008722,30002231,20000327,10000043),(3008848,'Abben Jafshi',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008752,30002199,20000323,10000043),(3008849,'Odesatu Yatichar',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008755,30002201,20000323,10000043),(3008850,'Samsem Shila',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008749,30002202,20000323,10000043),(3008851,'Bidelcher Natirbek',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008740,30002210,20000325,10000043),(3008852,'Tagana Moshu',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008743,30002215,20000325,10000043),(3008853,'Fuli Eloriel',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008746,30002216,20000325,10000043),(3008854,'Sufala Srasrararz',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008725,30002233,20000327,10000043),(3008855,'Hoorazood Bikan',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008728,30002233,20000327,10000043),(3008856,'Nardir Sanima',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008731,30002259,20000331,10000043),(3008857,'Arshos Hul',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008734,30002262,20000331,10000043),(3008858,'Orri Ormot',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008737,30002262,20000331,10000043),(3008859,'Ohtar Defsunun',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008758,30001671,20000247,10000020),(3008860,'Ramah Fesrar',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008767,30001651,20000244,10000020),(3008861,'Tegi Jesalout',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008773,30001651,20000244,10000020),(3008862,'Fakah Assad',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008770,30001654,20000244,10000020),(3008863,'Farela Laresh',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008764,30001671,20000247,10000020),(3008864,'Yootolk Sudhi',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008761,30001674,20000247,10000020),(3008865,'Jafi Asa',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008779,30001688,20000250,10000020),(3008866,'Sakitsidendri Rafsadah',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008776,30001689,20000250,10000020),(3008867,'Tzati Khodja',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008782,30001690,20000250,10000020),(3008868,'Ires Orva',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008785,30001699,20000251,10000020),(3008869,'Siktinu Verk',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008788,30001699,20000251,10000020),(3008870,'Shagit Louh',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008791,30001699,20000251,10000020),(3008871,'Avenoz Sadna',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008794,30004078,20000596,10000052),(3008872,'Opoumouh Bemarah',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008881,30001662,20000246,10000020),(3008873,'Segemarali Assehion',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008878,30001664,20000246,10000020),(3008874,'Sahnora Zhanya',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008884,30001664,20000246,10000020),(3008875,'Rosht Abrikoum',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008887,30001668,20000246,10000020),(3008876,'Rorekoo Kehrati',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008905,30002982,20000437,10000036),(3008877,'Joshoun Niser',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008911,30002982,20000437,10000036),(3008878,'Jariz Ohrzel',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008902,30002984,20000437,10000036),(3008879,'Tishama Mafe',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008908,30002987,20000437,10000036),(3008880,'Yarohrat Adehzala',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008872,30003487,20000509,10000043),(3008881,'Ked Adodanes',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008869,30003488,20000509,10000043),(3008882,'Dassad Khuhrdat',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008866,30003490,20000509,10000043),(3008883,'Lig Uaneyad',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008875,30003491,20000509,10000043),(3008884,'Sharir Baibenoh',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008803,30004077,20000596,10000052),(3008885,'Almerak Yemous',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008797,30004078,20000596,10000052),(3008886,'Barah Numrarat',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008800,30004079,20000596,10000052),(3008887,'Chilela Armaiah',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008854,30004111,20000601,10000052),(3008888,'Emah Gubala',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008860,30004113,20000601,10000052),(3008889,'Hefsa Niyibal',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008863,30004113,20000601,10000052),(3008890,'Kerumela Bordan',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008857,30004115,20000601,10000052),(3008891,'Folika Fiyotis',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008815,30004142,20000606,10000052),(3008892,'Yiranasa Chonna',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008812,30004146,20000606,10000052),(3008893,'Itmu Jarmak',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008806,30004147,20000606,10000052),(3008894,'Khoor Nerdeh',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008809,30004147,20000606,10000052),(3008895,'Kiventar Iris',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008830,30004273,20000625,10000054),(3008896,'Galarsia Mararq',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008836,30004273,20000625,10000054),(3008897,'Yoob Hiveda',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008839,30004276,20000625,10000054),(3008898,'Chelodera Hurmumi',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008833,30004277,20000625,10000054),(3008899,'Chodha Tapa',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008851,30004288,20000627,10000054),(3008900,'Efil Kheba',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008842,30004289,20000627,10000054),(3008901,'Esme Messa',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008845,30004293,20000627,10000054),(3008902,'Sindrah Osaeed',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008848,30004296,20000627,10000054),(3008903,'Kehalin Yairar',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008899,30004303,20000629,10000054),(3008904,'Hessiehan Pasrit',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008893,30004304,20000629,10000054),(3008905,'Asseen Arah',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008890,30004309,20000629,10000054),(3008906,'Chaph Piviasen',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008896,30004309,20000629,10000054),(3008907,'Lonenria Fina',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008821,30005231,20000765,10000067),(3008908,'Peshi Khiznor',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008818,30005232,20000765,10000067),(3008909,'Yurzif Houb',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008827,30005232,20000765,10000067),(3008910,'Jarhisi Joah',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008824,30005233,20000765,10000067),(3008911,'Ahtoud Umor',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008914,30002270,20000333,10000043),(3008912,'Masta Nemarz',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008974,30001688,20000250,10000020),(3008913,'Urotak Jibila',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008980,30001688,20000250,10000020),(3008914,'Kohaskhach Rales',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008977,30001690,20000250,10000020),(3008915,'Sahmon Yabiani',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008983,30001690,20000250,10000020),(3008916,'Almananeg Erafeke',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008950,30002187,20000322,10000043),(3008917,'Monoth Khianasha',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008956,30002188,20000322,10000043),(3008918,'Narshandyn Pehibiz',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008953,30002191,20000322,10000043),(3008919,'Angohmateh Jibila',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008959,30002191,20000322,10000043),(3008920,'Damaini Sahrazed',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008932,30002252,20000330,10000043),(3008921,'Gashozoo Hefaka',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008935,30002253,20000330,10000043),(3008922,'Abiam Chahrnian',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008926,30002254,20000330,10000043),(3008923,'Lerje Hamiar',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008929,30002254,20000330,10000043),(3008924,'Hoz Onsula',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008998,30002263,20000332,10000043),(3008925,'Badhul Khon',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009004,30002263,20000332,10000043),(3008926,'Mankoor Bat',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009007,30002265,20000332,10000043),(3008927,'Oshih Lalmesras',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009001,30002268,20000332,10000043),(3008928,'Aphashat Bier',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008920,30002269,20000333,10000043),(3008929,'Habthen Humadi',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008917,30002272,20000333,10000043),(3008930,'Ashzal Khianasha',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008923,30002275,20000333,10000043),(3008931,'Moorve Alat',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008995,30002969,20000435,10000036),(3008932,'Amis Arvadan',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008989,30002971,20000435,10000036),(3008933,'Saame Marver',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008986,30002972,20000435,10000036),(3008934,'Afeus Sasrame',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008992,30002973,20000435,10000036),(3008935,'Tuzilo Zhada',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008941,30003487,20000509,10000043),(3008936,'Ja Urka',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008944,30003488,20000509,10000043),(3008937,'Chemaz Sesmas',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008947,30003488,20000509,10000043),(3008938,'Toumzie Fusi',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008938,30003491,20000509,10000043),(3008939,'Rasazih Arja',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008965,30004102,20000599,10000052),(3008940,'Madisa Tadabram',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008968,30004102,20000599,10000052),(3008941,'Sahmotir Makshmi',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008971,30004102,20000599,10000052),(3008942,'Datna Jesebal',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60008962,30004103,20000599,10000052),(3008943,'Dufidiah Shach',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009010,30004130,20000604,10000052),(3008944,'Salir Qeshal',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009019,30004133,20000604,10000052),(3008945,'Avair Ayaidi',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009013,30004134,20000604,10000052),(3008946,'Fori Mossas',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009016,30004134,20000604,10000052),(3008947,'Arody Tinja',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009031,30005221,20000764,10000067),(3008948,'Aroum Yarunas',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009028,30005224,20000764,10000067),(3008949,'Nirges Omshin',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009022,30005225,20000764,10000067),(3008950,'Feknisa Kamyeka',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009025,30005225,20000764,10000067),(3008951,'Joolille Ekanckbrault',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009034,30002706,20000396,10000032),(3008952,'Groothese Larloolis',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009298,30001650,20000244,10000020),(3008953,'Baernoudts Isirrare',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009292,30001652,20000244,10000020),(3008954,'Odumeria Amattens',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009091,30002089,20000307,10000042),(3008955,'Oleritte Allebin',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009121,30002507,20000367,10000030),(3008956,'Yvosenne Avarter',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009118,30002508,20000367,10000030),(3008957,'Ilivel Esmecet',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009115,30002509,20000367,10000030),(3008958,'Ossel Cymerouf',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009112,30002509,20000367,10000030),(3008959,'Ayst Alaenzaner',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009115,30002509,20000367,10000030),(3008960,'Conardier Nimestre',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009106,30002510,20000367,10000030),(3008961,'Rhovolle Odaelloles',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009049,30002706,20000396,10000032),(3008962,'Esseraulin Amere',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009043,30002709,20000396,10000032),(3008963,'Olmart Yolelle',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009040,30002710,20000396,10000032),(3008964,'Yrens Dallot',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009037,30002711,20000396,10000032),(3008965,'Asserens Allomieves',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009046,30002711,20000396,10000032),(3008966,'Ancenare Jeanglia',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009178,30003001,20000440,10000036),(3008967,'Sirillaute Zottyn',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009193,30003001,20000440,10000036),(3008968,'Ambetter Teille',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009181,30003003,20000440,10000036),(3008969,'Sarante Destroodt',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009187,30003003,20000440,10000036),(3008970,'Blune Odoulreles',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009184,30003004,20000440,10000036),(3008971,'Nitiron Allone',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009190,30003004,20000440,10000036),(3008972,'Coverie Ygymet',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009250,30003361,20000490,10000041),(3008973,'Mesteur Urres',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009259,30003361,20000490,10000041),(3008974,'Cirgnard Girles',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009265,30003361,20000490,10000041),(3008975,'Ariot Baelazaenber',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009253,30003362,20000490,10000041),(3008976,'Yolerard Posperot',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009262,30003362,20000490,10000041),(3008977,'Viscebins Reditteau',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009256,30003364,20000490,10000041),(3008978,'Gaudent Slasschevret',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009220,30003448,20000503,10000042),(3008979,'Alline Henebene',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009229,30003449,20000503,10000042),(3008980,'Losavale Giralle',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009214,30003451,20000503,10000042),(3008981,'Orviddore Anchallarie',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009217,30003451,20000503,10000042),(3008982,'Fanalabbe Vaydaerer',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009226,30003451,20000503,10000042),(3008983,'Callere Maittintes',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009223,30003452,20000503,10000042),(3008984,'Beunsteste Molon',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009232,30003453,20000504,10000042),(3008985,'Mitresigier Ellienne',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009235,30003453,20000504,10000042),(3008986,'Arlier Othyn',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009238,30003453,20000504,10000042),(3008987,'Joyssetta Garin',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009241,30003453,20000504,10000042),(3008988,'Yrton Araunet',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009244,30003453,20000504,10000042),(3008989,'Ekorecke Amattens',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009247,30003453,20000504,10000042),(3008990,'Ergre Pielevieve',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009271,30003507,20000512,10000043),(3008991,'Yveure Arnelelle',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009283,30003507,20000512,10000043),(3008992,'Outtel Arrion',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009280,30003508,20000512,10000043),(3008993,'Blarlerrier Odrel',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009274,30003510,20000512,10000043),(3008994,'Foun Augne',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009277,30003511,20000512,10000043),(3008995,'Moerrasarzay Lassin',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009268,30003512,20000512,10000043),(3008996,'Karcard Loict',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009124,30003810,20000556,10000048),(3008997,'Eule Averasin',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009127,30003810,20000556,10000048),(3008998,'Grinault Cique',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009130,30003810,20000556,10000048),(3008999,'Brurphenber Allmon',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009136,30003810,20000556,10000048),(3009000,'Solles Alagne',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009139,30003810,20000556,10000048),(3009001,'Auntes Alselbosier',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009133,30003811,20000556,10000048),(3009002,'Anvent Folnempanne',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009052,30003824,20000559,10000048),(3009003,'Atsy Eloittechon',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009067,30003824,20000559,10000048),(3009004,'Vralle Ysone',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009055,30003826,20000559,10000048),(3009005,'Guyotghen Hercheem',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009058,30003826,20000559,10000048),(3009006,'Pormaines Fleunove',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009061,30003826,20000559,10000048),(3009007,'Agrite Vysscheles',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009064,30003828,20000559,10000048),(3009008,'Doritte Sybbolia',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009148,30004094,20000598,10000052),(3009009,'Estie Rolle',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009142,30004095,20000598,10000052),(3009010,'Bildecaina Riveau',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009145,30004095,20000598,10000052),(3009011,'Ossel Oryerchiron',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009151,30004095,20000598,10000052),(3009012,'Aucier Prayl',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009157,30004095,20000598,10000052),(3009013,'Crens Ekare',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009154,30004096,20000598,10000052),(3009014,'Adedaire Elerouc',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009163,30004974,20000728,10000064),(3009015,'Yveche Amanckbraert',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009160,30004975,20000728,10000064),(3009016,'Deremeur Falloullon',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009175,30004975,20000728,10000064),(3009017,'Dact Anzalolie',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009169,30004976,20000728,10000064),(3009018,'Erdacan Folacadie',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009172,30004976,20000728,10000064),(3009019,'Mollin Arnancere',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009166,30004977,20000728,10000064),(3009020,'Rougnyes Drye',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009202,30005231,20000765,10000067),(3009021,'Ansiraire Ecier',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009208,30005232,20000765,10000067),(3009022,'Vancent Olediart',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009211,30005234,20000765,10000067),(3009023,'Meurch Cletrullier',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009196,30005235,20000765,10000067),(3009024,'Rodochon Walulle',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009199,30005235,20000765,10000067),(3009025,'Breeraere Ahresiere',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009205,30005235,20000765,10000067),(3009026,'Agou Derwycx',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009289,30001653,20000244,10000020),(3009027,'Pocriere Orvanne',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009295,30001653,20000244,10000020),(3009028,'Aubalyu Lola',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009301,30001653,20000244,10000020),(3009029,'Pingeron Oenync',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009286,30001654,20000244,10000020),(3009030,'Tameroy Bengot',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009079,30001716,20000254,10000020),(3009031,'Lausalle Alsenoge',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009073,30001718,20000254,10000020),(3009032,'Emmette Orvavaerer',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009076,30001718,20000254,10000020),(3009033,'Got Sansalard',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009085,30001718,20000254,10000020),(3009034,'Joysbin Edmezette',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009082,30001719,20000254,10000020),(3009035,'Aunier Houvare',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009070,30001721,20000254,10000020),(3009036,'Assye Fenere',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009088,30002082,20000307,10000042),(3009037,'Adrey Aunnoi',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009097,30002082,20000307,10000042),(3009038,'Mobber Gooneeter',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009100,30002083,20000307,10000042),(3009039,'Vos Attare',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009094,30002084,20000307,10000042),(3009040,'Chamames Evetille',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009103,30002088,20000307,10000042),(3009041,'Isaine Mandie',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009304,30003039,20000445,10000037),(3009042,'Baspament Dorompiere',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009391,30002643,20000387,10000032),(3009043,'Saonellieu Municlune',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009394,30002643,20000387,10000032),(3009044,'Riselgale Vemere',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009397,30002646,20000387,10000032),(3009045,'Zonelle Sazenoinnon',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009388,30002647,20000387,10000032),(3009046,'Avovence Deusserunes',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009367,30002672,20000391,10000032),(3009047,'Brelette Thilpanorcer',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009370,30002673,20000391,10000032),(3009048,'Melever Algindole',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009373,30002673,20000391,10000032),(3009049,'Emmette Geoneymene',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009364,30002674,20000391,10000032),(3009050,'Guire Letta',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009415,30002699,20000395,10000032),(3009051,'Ekerussche Olarault',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009421,30002699,20000395,10000032),(3009052,'Marisselle Memana',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009418,30002700,20000395,10000032),(3009053,'Herrent Gaudent',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009412,30002703,20000395,10000032),(3009054,'Algoze Meminave',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009340,30002718,20000398,10000032),(3009055,'Pesier Deugghoteren',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009343,30002718,20000398,10000032),(3009056,'Dedotte Emmalaute',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009346,30002719,20000398,10000032),(3009057,'Raynsins Bruffreglin',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009349,30002721,20000398,10000032),(3009058,'Auralle Rorcires',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009361,30003026,20000443,10000037),(3009059,'Afresouret Isiene',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009352,30003028,20000443,10000037),(3009060,'Odairgilen Algesoire',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009358,30003028,20000443,10000037),(3009061,'Charante Dastrecal',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009355,30003029,20000443,10000037),(3009062,'Ardaggherier Essytace',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009313,30003041,20000445,10000037),(3009063,'Fouinotere Elastault',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009307,30003042,20000445,10000037),(3009064,'Bloir Abolia',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009310,30003043,20000445,10000037),(3009065,'Graget Duvence',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009325,30003584,20000522,10000044),(3009066,'Assens Deona',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009316,30003586,20000522,10000044),(3009067,'Challelle Eloede',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009319,30003586,20000522,10000044),(3009068,'Hootant Thilpanorcer',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009322,30003586,20000522,10000044),(3009069,'Charie Onckee',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009376,30003787,20000553,10000048),(3009070,'Seinnault Heirleux',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009385,30003788,20000553,10000048),(3009071,'Amailly Echilemy',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009382,30003789,20000553,10000048),(3009072,'Armouttaine Olelie',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009379,30003792,20000553,10000048),(3009073,'Manoede Egier',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009328,30003800,20000555,10000048),(3009074,'Fayetesore Alemens',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009337,30003801,20000555,10000048),(3009075,'Eustron Fayet',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009334,30003802,20000555,10000048),(3009076,'Aladet Merlenciene',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009331,30003804,20000555,10000048),(3009077,'Lurts Asly',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009403,30005320,20000778,10000068),(3009078,'Cournouts Ophene',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009409,30005320,20000778,10000068),(3009079,'Ghele Motheluse',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009400,30005321,20000778,10000068),(3009080,'Elalan Vroering',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009406,30005321,20000778,10000068),(3009081,'Lympia Vanisson',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009427,30003835,20000560,10000048),(3009082,'Obalyu Juvone',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009430,30003570,20000520,10000044),(3009083,'Gollelle Veselleque',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009523,30003011,20000441,10000037),(3009084,'Cavauvon Haatephaeslan',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009517,30003013,20000441,10000037),(3009085,'Bereque Uce',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009514,30003014,20000441,10000037),(3009086,'Gille Miroodt',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009520,30003014,20000441,10000037),(3009087,'Juttarnard Apouttemes',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009433,30003566,20000520,10000044),(3009088,'Iliete Janydens',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009439,30003569,20000520,10000044),(3009089,'Venelles Ardt',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009436,30003572,20000520,10000044),(3009090,'Warts Aboleur',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009496,30003573,20000521,10000044),(3009091,'Slavraert Ashtibouton',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009490,30003574,20000521,10000044),(3009092,'Wasteronne Echibaver',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009493,30003577,20000521,10000044),(3009093,'Yvanckbraert Chensene',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009499,30003578,20000521,10000044),(3009094,'Ollmue Adulyn',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009532,30003588,20000523,10000044),(3009095,'Rodille Distel',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009535,30003588,20000523,10000044),(3009096,'Votane Essoule',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009526,30003589,20000523,10000044),(3009097,'Archerlaert Oguere',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009529,30003593,20000523,10000044),(3009098,'Boinget Orloges',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009541,30003594,20000524,10000044),(3009099,'Dau Rolloure',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009547,30003595,20000524,10000044),(3009100,'Durrac Macresiaen',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009538,30003600,20000524,10000044),(3009101,'Couvette Olair',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009544,30003601,20000524,10000044),(3009102,'Fonseric Auldier',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009448,30003604,20000525,10000044),(3009103,'Audasueur Diere',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009442,30003607,20000525,10000044),(3009104,'Boodacievres Nobeges',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009445,30003607,20000525,10000044),(3009105,'Jare Searavrette',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009451,30003607,20000525,10000044),(3009106,'Heillaert Audarne',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009508,30003794,20000554,10000048),(3009107,'Mottin Muelsouranne',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009505,30003796,20000554,10000048),(3009108,'Rellin Cachtenaude',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009502,30003799,20000554,10000048),(3009109,'Angher Azyne',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009511,30003799,20000554,10000048),(3009110,'Buratour Apaury',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009475,30003812,20000557,10000048),(3009111,'Albalyu Purlieu',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009469,30003814,20000557,10000048),(3009112,'Poltelle Muebles',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009472,30003816,20000557,10000048),(3009113,'Vleyzine Espodolf',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009466,30003817,20000557,10000048),(3009114,'Fleusc Amolezer',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009487,30005011,20000733,10000064),(3009115,'Elelot Preaux',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009478,30005014,20000733,10000064),(3009116,'Elerie Vlordt',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009481,30005014,20000733,10000064),(3009117,'Panpere Orpaert',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009484,30005014,20000733,10000064),(3009118,'Gaerooman Dhooris',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009454,30005026,20000735,10000064),(3009119,'Wenarielves Daustraert',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009457,30005027,20000735,10000064),(3009120,'Andrarde Ybier',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009460,30005027,20000735,10000064),(3009121,'Trormare Ondree',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009463,30005029,20000735,10000064),(3009122,'Oust Breeriest',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009550,30005304,20000776,10000068),(3009123,'Creltenier Eyghelet',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009661,30003792,20000553,10000048),(3009124,'Ossches Oslie',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009568,30003806,20000556,10000048),(3009125,'Rouland Dullaerdt',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009571,30003806,20000556,10000048),(3009126,'Laglotes Chrinard',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009580,30003806,20000556,10000048),(3009127,'Labaerdt Ararezer',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009574,30003807,20000556,10000048),(3009128,'Stie Dire',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009577,30003809,20000556,10000048),(3009129,'Vaysseyrcer Antrye',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009583,30003810,20000556,10000048),(3009130,'Genchivare Zertavenne',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009646,30004968,20000727,10000064),(3009131,'Nanimout Jucieves',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009640,30004969,20000727,10000064),(3009132,'Bruune Stienne',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009643,30004969,20000727,10000064),(3009133,'Adier Issie',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009649,30004969,20000727,10000064),(3009134,'Afraustin Enore',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009652,30004969,20000727,10000064),(3009135,'Thessordin Haude',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009655,30004969,20000727,10000064),(3009136,'Basteeles Encke',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009712,30004989,20000730,10000064),(3009137,'Rayle Andomel',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009724,30004989,20000730,10000064),(3009138,'Helle Roon',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009715,30004991,20000730,10000064),(3009139,'Weyllaenalle Airblou',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009727,30004991,20000730,10000064),(3009140,'Aernelaert Pinssier',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009718,30004992,20000730,10000064),(3009141,'Peselien Ennel',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009721,30004992,20000730,10000064),(3009142,'Fette Aleartener',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009559,30005302,20000776,10000068),(3009143,'Saissore Evavarin',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009562,30005302,20000776,10000068),(3009144,'Comparaert Ancbeu',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009553,30005303,20000776,10000068),(3009145,'Ostes Zoenceliris',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009556,30005304,20000776,10000068),(3009146,'Acharanza Moorne',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009565,30005306,20000776,10000068),(3009147,'Cocier Riesves',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009607,30005330,20000780,10000068),(3009148,'Aisnellina Alottins',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009610,30005330,20000780,10000068),(3009149,'Auls Baslitte',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009604,30005333,20000780,10000068),(3009150,'Vriessche Anzete',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009613,30005333,20000780,10000068),(3009151,'Auntoi Mantenault',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009616,30005333,20000780,10000068),(3009152,'Jaen Oursinault',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009619,30005333,20000780,10000068),(3009153,'Waldrell Losschyve',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009598,30002637,20000386,10000032),(3009154,'Oraveval Bempiery',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009601,30002639,20000386,10000032),(3009155,'Albrey Audanolle',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009586,30002641,20000386,10000032),(3009156,'Ahrirlyne Bous',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009589,30002641,20000386,10000032),(3009157,'Covette Chestebene',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009592,30002641,20000386,10000032),(3009158,'Attelle Avere',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009595,30002641,20000386,10000032),(3009159,'Apamoote Dovrin',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009682,30002655,20000389,10000032),(3009160,'Dra Cren',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009685,30002655,20000389,10000032),(3009161,'Abuette Ciraden',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009676,30002658,20000389,10000032),(3009162,'Annins Codirgnard',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009679,30002660,20000389,10000032),(3009163,'Olcard Dehette',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009688,30002660,20000389,10000032),(3009164,'Celync Layn',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009691,30002660,20000389,10000032),(3009165,'Abuette Yoladent',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009703,30003031,20000444,10000037),(3009166,'Allesmarie Pour',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009700,30003033,20000444,10000037),(3009167,'Anguraere Ambetyn',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009706,30003034,20000444,10000037),(3009168,'Errye Aurapes',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009697,30003036,20000444,10000037),(3009169,'Aisnirault Heiles',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009694,30003037,20000444,10000037),(3009170,'Schellan Arnon',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009709,30003037,20000444,10000037),(3009171,'Berlimaute Ekaeroose',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009622,30003594,20000524,10000044),(3009172,'Audere Esmoreures',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009628,30003594,20000524,10000044),(3009173,'Sadereron Ombre',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009637,30003594,20000524,10000044),(3009174,'Emmare Edmiculle',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009625,30003595,20000524,10000044),(3009175,'Columiarset Trayn',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009631,30003598,20000524,10000044),(3009176,'Baus Balenne',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009634,30003600,20000524,10000044),(3009177,'Grinarel Toubaison',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009667,30003788,20000553,10000048),(3009178,'Ameron Yvorin',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009670,30003790,20000553,10000048),(3009179,'Mordiene Etins',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009673,30003790,20000553,10000048),(3009180,'Quiratain Quiratain',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009658,30003791,20000553,10000048),(3009181,'Masnese Ormazyne',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009664,30003791,20000553,10000048),(3009182,'Beber Cloesmant',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009730,30003574,20000521,10000044),(3009183,'Tragenire Neylloullon',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009757,30002706,20000396,10000032),(3009184,'Charmes Palinard',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009754,30002709,20000396,10000032),(3009185,'Oullaerdt Besserilier',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009760,30002710,20000396,10000032),(3009186,'Orvecel Aubenouel',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009763,30002711,20000396,10000032),(3009187,'Scane Orsanere',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009769,30003040,20000445,10000037),(3009188,'Mavoserer Asschel',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009766,30003041,20000445,10000037),(3009189,'Dhoorcare Viridette',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009772,30003042,20000445,10000037),(3009190,'Reschard Groelande',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009775,30003042,20000445,10000037),(3009191,'Stetille Amimolie',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009778,30003057,20000447,10000037),(3009192,'Mayeninc Tinpant',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009781,30003057,20000447,10000037),(3009193,'Aloret Relisiertan',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009787,30003058,20000447,10000037),(3009194,'Aydoteaux Essyn',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009784,30003059,20000447,10000037),(3009195,'Lirmarne Besches',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009733,30003574,20000521,10000044),(3009196,'Comante Cliette',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009736,30003578,20000521,10000044),(3009197,'Ainuregt Joghorare',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009739,30003578,20000521,10000044),(3009198,'Ivoncane Viuep',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009847,30003808,20000556,10000048),(3009199,'Bles Porelotta',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009841,30003810,20000556,10000048),(3009200,'Coommarecque Lalolles',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009838,30003811,20000556,10000048),(3009201,'Egloennan Pelbelion',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009844,30003811,20000556,10000048),(3009202,'Asselagne Chevre',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009745,30003826,20000559,10000048),(3009203,'Vallalorges Sauntrene',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009751,30003826,20000559,10000048),(3009204,'Aurrier Sormoure',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009748,30003827,20000559,10000048),(3009205,'Cooctenuton Lellevoire',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009742,30003829,20000559,10000048),(3009206,'Ardelins Jafavel',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009829,30003831,20000560,10000048),(3009207,'Candsosene Loot',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009826,30003834,20000560,10000048),(3009208,'Adalyler Parnella',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009832,30003834,20000560,10000048),(3009209,'Avymel Brevier',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009835,30003834,20000560,10000048),(3009210,'Languvier Tardenes',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009820,30003843,20000562,10000048),(3009211,'Andolelle Callimarne',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009814,30003845,20000562,10000048),(3009212,'Chamamere Meere',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009823,30003845,20000562,10000048),(3009213,'Archeralle Brullaert',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009817,30003848,20000562,10000048),(3009214,'Deort Heytlique',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009811,30004973,20000728,10000064),(3009215,'Zalloronde Aymynouel',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009808,30004975,20000728,10000064),(3009216,'Algette Ansotte',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009802,30004976,20000728,10000064),(3009217,'Dauteau Fouil',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009805,30004976,20000728,10000064),(3009218,'Aidesins Aerchirault',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009799,30005330,20000780,10000068),(3009219,'Rhin Ottin',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009790,30005332,20000780,10000068),(3009220,'Claulanghe Meniger',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009793,30005333,20000780,10000068),(3009221,'Audaille Pron',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009796,30005333,20000780,10000068),(3009222,'Vionnoreau Trillicon',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009850,30003025,20000443,10000037),(3009223,'Yvokin Fou',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009886,30001437,20000211,10000016),(3009224,'Afour Albyne',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009889,30001437,20000211,10000016),(3009225,'Defone Scorcier',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009979,30001695,20000251,10000020),(3009226,'Orlaetter Eulo',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009985,30001695,20000251,10000020),(3009227,'Ommore Aymevins',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009988,30001695,20000251,10000020),(3009228,'Ofstilotte Attella',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009976,30001696,20000251,10000020),(3009229,'Andoulonne Vyrrelanpin',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009982,30001696,20000251,10000020),(3009230,'Farmes Albuerges',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009991,30001697,20000251,10000020),(3009231,'Arouckesin Doi',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010078,30002512,20000368,10000030),(3009232,'Dorne Bengot',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010066,30002513,20000368,10000030),(3009233,'Olmel Nabeter',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010072,30002513,20000368,10000030),(3009234,'Ivenckbrault Gremmichel',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010069,30002514,20000368,10000030),(3009235,'Alins Pitendthompin',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010081,30002515,20000368,10000030),(3009236,'Ashtounelle Gaenloovitte',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010075,30002516,20000368,10000030),(3009237,'Ardoroule Ophone',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010048,30002543,20000373,10000030),(3009238,'Maenedier Gallot',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010057,30002543,20000373,10000030),(3009239,'Deanaiton Durrac',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010051,30002544,20000373,10000030),(3009240,'Scourt Allougles',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010054,30002545,20000373,10000030),(3009241,'Serdenoella Duster',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010060,30002545,20000373,10000030),(3009242,'Cryrcier Yrca',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010063,30002548,20000373,10000030),(3009243,'Aussent Ekingare',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009958,30002562,20000376,10000030),(3009244,'Mouttolouis Houvers',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009961,30002562,20000376,10000030),(3009245,'Ygemette Ellettilier',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009964,30002562,20000376,10000030),(3009246,'Garavitte Assattyn',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009973,30002562,20000376,10000030),(3009247,'Cherbanye Baine',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009967,30002566,20000376,10000030),(3009248,'Tria Asant',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009970,30002566,20000376,10000030),(3009249,'Chore Denvonne',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010102,30002776,20000407,10000033),(3009250,'Evaux Tourtli',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010108,30002776,20000407,10000033),(3009251,'Tespithou Etlain',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010114,30002776,20000407,10000033),(3009252,'Duria Zarraert',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010117,30002776,20000407,10000033),(3009253,'Bessoteaux Trayn',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010105,30002777,20000407,10000033),(3009254,'Osmarbon Timestre',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010111,30002777,20000407,10000033),(3009255,'Orole Amaret',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009862,30003024,20000443,10000037),(3009256,'Armahieu Dalogne',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009865,30003026,20000443,10000037),(3009257,'Derdianne Aineveu',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009859,30003027,20000443,10000037),(3009258,'Bruysene Apilles',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009853,30003029,20000443,10000037),(3009259,'Delennotte Deloettan',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009856,30003030,20000443,10000037),(3009260,'Lefroxalier Odainnelet',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010030,30003293,20000481,10000041),(3009261,'Aloles Ronssant',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010045,30003293,20000481,10000041),(3009262,'Vynardieu Fulle',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010033,30003294,20000481,10000041),(3009263,'Essures Mect',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010036,30003295,20000481,10000041),(3009264,'Doolleernes Enalalon',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010039,30003298,20000481,10000041),(3009265,'Mermene Wirtnard',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010042,30003300,20000481,10000041),(3009266,'Adrebelle Jaredaille',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009952,30003328,20000485,10000041),(3009267,'Durastrand Lartalle',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009955,30003328,20000485,10000041),(3009268,'Soeilenuse Aerer',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009943,30003332,20000485,10000041),(3009269,'Echane Dunvier',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009946,30003332,20000485,10000041),(3009270,'Caramel Async',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009949,30003332,20000485,10000041),(3009271,'Espumer Bunanet',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009940,30003334,20000485,10000041),(3009272,'Rebbois Hanzirier',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010099,30003487,20000509,10000043),(3009273,'Audasueur Arnustene',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010084,30003488,20000509,10000043),(3009274,'Bloutte Colockes',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010087,30003488,20000509,10000043),(3009275,'Heuron Patecaere',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010090,30003488,20000509,10000043),(3009276,'Monave Groo',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010093,30003488,20000509,10000043),(3009277,'Manbier Ommenne',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010096,30003490,20000509,10000043),(3009278,'Vavanique Ivident',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009883,30003507,20000512,10000043),(3009279,'Mollarync Alecarel',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009871,30003509,20000512,10000043),(3009280,'Bivecon Anste',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009874,30003509,20000512,10000043),(3009281,'Astre Daensavette',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009868,30003510,20000512,10000043),(3009282,'Sarluhevier Dustalon',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009880,30003511,20000512,10000043),(3009283,'Jeocanet Dalleauda',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009877,30003512,20000512,10000043),(3009284,'Deltes Maleterel',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009910,30003573,20000521,10000044),(3009285,'Aurerie Antene',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009919,30003573,20000521,10000044),(3009286,'Pagemevel Riggheriene',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009913,30003575,20000521,10000044),(3009287,'Lolledanier Junnevendon',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009904,30003576,20000521,10000044),(3009288,'Bauwinon Biels',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009907,30003577,20000521,10000044),(3009289,'Debese Roghewer',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009916,30003577,20000521,10000044),(3009290,'Buene Stontroller',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010024,30004242,20000621,10000054),(3009291,'Failanard Lefanivel',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010021,30004244,20000621,10000054),(3009292,'Beel Bulle',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010012,30004245,20000621,10000054),(3009293,'Kaspant Cavalnaert',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010015,30004245,20000621,10000054),(3009294,'Traude Seinaesen',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010018,30004245,20000621,10000054),(3009295,'Ayle Varkoliette',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010027,30004245,20000621,10000054),(3009296,'Fruynghermant Boin',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009928,30004993,20000731,10000064),(3009297,'Alpielanda Plampsen',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009922,30004994,20000731,10000064),(3009298,'Brere Bette',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009925,30004995,20000731,10000064),(3009299,'Comergheem Pamovais',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009931,30004998,20000731,10000064),(3009300,'Janninck Claynins',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009934,30004998,20000731,10000064),(3009301,'Aymirot Compsier',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009937,30005000,20000731,10000064),(3009302,'Grateldale Jayet',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009994,30005250,20000768,10000067),(3009303,'Riesves Boricon',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010009,30005250,20000768,10000067),(3009304,'Rirsturiere Hordane',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010000,30005251,20000768,10000067),(3009305,'Thormonnie Ivonis',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009997,30005252,20000768,10000067),(3009306,'Guy Jeartlait',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010006,30005253,20000768,10000067),(3009307,'Odeure Estibane',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010003,30005254,20000768,10000067),(3009308,'Estorand Aurlaerdt',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009901,30001437,20000211,10000016),(3009309,'Clel Elaert',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009895,30001440,20000211,10000016),(3009310,'Ains Apant',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009892,30001442,20000211,10000016),(3009311,'Pallysseult Genereau',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60009898,30001442,20000211,10000016),(3009312,'Irrie Ambettin',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010120,30003048,20000446,10000037),(3009313,'Bardoen Alariese',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010195,30000159,20000023,10000002),(3009314,'Veur Venbaert',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010192,30000160,20000023,10000002),(3009315,'Buillaerdt Violebins',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010282,30004112,20000601,10000052),(3009316,'Ageina Amoullever',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010285,30004114,20000601,10000052),(3009317,'Gasschies Ordt',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010267,30004288,20000627,10000054),(3009318,'Loiceloittin Arier',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010273,30004288,20000627,10000054),(3009319,'Gheretins Artave',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010270,30004291,20000627,10000054),(3009320,'Emmire Esmoote',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010264,30004296,20000627,10000054),(3009321,'Rhinier Gheretins',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010159,30005009,20000733,10000064),(3009322,'Ganouel Chatanede',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010162,30005010,20000733,10000064),(3009323,'Orsetta Lexmoreau',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010165,30005010,20000733,10000064),(3009324,'Jobise Esmallon',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010156,30005011,20000733,10000064),(3009325,'Dunlavonnis Oelant',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010207,30005017,20000734,10000064),(3009326,'Aderon Arde',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010210,30005018,20000734,10000064),(3009327,'Wedrel Allillare',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010213,30005018,20000734,10000064),(3009328,'Hefer Rye',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010204,30005020,20000734,10000064),(3009329,'Clel Syctonerier',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010198,30000163,20000023,10000002),(3009330,'Tyl Amiette',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010201,30000164,20000023,10000002),(3009331,'Bresnync Speedele',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010240,30002252,20000330,10000043),(3009332,'Yvaviene Sladams',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010243,30002252,20000330,10000043),(3009333,'Darolevre Verac',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010246,30002252,20000330,10000043),(3009334,'Pocriere Bappitler',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010249,30002252,20000330,10000043),(3009335,'Anserguria Clue',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010183,30002414,20000355,10000028),(3009336,'Plandolis Lylouron',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010180,30002415,20000355,10000028),(3009337,'Lacriveau Besches',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010186,30002418,20000355,10000028),(3009338,'Vloert Osel',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010189,30002418,20000355,10000028),(3009339,'Saurtier Blagnardel',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010168,30002558,20000375,10000030),(3009340,'Audemoy Anchave',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010171,30002558,20000375,10000030),(3009341,'Autes Gelloure',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010174,30002559,20000375,10000030),(3009342,'Boillemamas Beenwalelle',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010177,30002560,20000375,10000030),(3009343,'Flonaige Munda',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010291,30002568,20000377,10000030),(3009344,'Nelesse Nerrene',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010297,30002568,20000377,10000030),(3009345,'Meltevaine Orlafrer',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010294,30002569,20000377,10000030),(3009346,'Clie Bempiery',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010288,30002571,20000377,10000030),(3009347,'Ansotte Melania',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010252,30003017,20000442,10000037),(3009348,'Calloux Thyneger',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010258,30003017,20000442,10000037),(3009349,'Dhoyesechare Granughe',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010255,30003018,20000442,10000037),(3009350,'Beet Wireruet',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010261,30003018,20000442,10000037),(3009351,'Maylilore Pepin',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010219,30003024,20000443,10000037),(3009352,'Wemire Ghynosseil',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010216,30003025,20000443,10000037),(3009353,'Hoys Claywire',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010222,30003029,20000443,10000037),(3009354,'Ebrens Set',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010225,30003030,20000443,10000037),(3009355,'Iville Pimmoraine',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010126,30003053,20000446,10000037),(3009356,'Isaugnedan Presetin',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010123,30003055,20000446,10000037),(3009357,'Masalle Ambrette',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010129,30003055,20000446,10000037),(3009358,'Aunes Isolette',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010144,30003447,20000503,10000042),(3009359,'Sonnon Amberel',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010150,30003447,20000503,10000042),(3009360,'Auzue Amailly',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010153,30003447,20000503,10000042),(3009361,'Emmare Walulle',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010147,30003449,20000503,10000042),(3009362,'Auret Yvaldier',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010141,30003553,20000518,10000043),(3009363,'Muync Diololle',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010132,30003554,20000518,10000043),(3009364,'Abins Apere',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010138,30003555,20000518,10000043),(3009365,'Pelbelion Durpel',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010135,30003556,20000518,10000043),(3009366,'Aube Wedrel',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010228,30004084,20000597,10000052),(3009367,'Akins Demeria',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010231,30004084,20000597,10000052),(3009368,'Orlevreze Charloller',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010234,30004084,20000597,10000052),(3009369,'Hurell Barcier',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010237,30004084,20000597,10000052),(3009370,'Avocones Roella',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010279,30004111,20000601,10000052),(3009371,'Yvandele Benic',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010276,30004112,20000601,10000052),(3009372,'Pauren Aubyrasse',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010300,30005304,20000776,10000068),(3009373,'Harcarin Angamuere',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010387,30002642,20000387,10000032),(3009374,'Bamon Enoit',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010384,30002643,20000387,10000032),(3009375,'Aid Hieur',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010381,30002645,20000387,10000032),(3009376,'Diles Ilatove',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010348,30002692,20000394,10000032),(3009377,'Afrincon Hueset',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010351,30002692,20000394,10000032),(3009378,'Houvire Takaerne',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010345,30002693,20000394,10000032),(3009379,'Garlilis Arle',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010321,30002718,20000398,10000032),(3009380,'Pant Arbone',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010324,30002718,20000398,10000032),(3009381,'Arnerore Rylerave',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010318,30002719,20000398,10000032),(3009382,'Humilehan Roi',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010309,30003010,20000441,10000037),(3009383,'Veve Caramel',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010315,30003014,20000441,10000037),(3009384,'Albencyers Yvese',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010312,30003016,20000441,10000037),(3009385,'Maillede Aurot',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010357,30003594,20000524,10000044),(3009386,'Adeset Elfin',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010360,30003594,20000524,10000044),(3009387,'Violebins Galapon',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010354,30003598,20000524,10000044),(3009388,'Rilune Larlelie',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010327,30003836,20000561,10000048),(3009389,'Jouey Nobariene',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010330,30003836,20000561,10000048),(3009390,'Mastance Seillaerdt',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010333,30003836,20000561,10000048),(3009391,'Buvesone Balluemene',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010375,30005019,20000734,10000064),(3009392,'Allawille Bunchousse',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010372,30005020,20000734,10000064),(3009393,'Junnader Crucarne',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010378,30005022,20000734,10000064),(3009394,'Lean Fene',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010369,30005296,20000775,10000068),(3009395,'Tirlan Meuvrezaryn',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010363,30005300,20000775,10000068),(3009396,'Apouttemes Lonraires',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010366,30005300,20000775,10000068),(3009397,'Vlan Peloelus',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010303,30005302,20000776,10000068),(3009398,'Espidoure Malenut',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010306,30005302,20000776,10000068),(3009399,'Ornargot Annins',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010339,30005308,20000777,10000068),(3009400,'Zobydene Manc',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010342,30005310,20000777,10000068),(3009401,'Bourgyes Jootan',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010336,30005312,20000777,10000068),(3009402,'Ilcke Aylle',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010393,30003571,20000520,10000044),(3009403,'Jamaert Stroure',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010396,30005304,20000776,10000068),(3009404,'Ogne Angenaules',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010456,30000196,20000028,10000002),(3009405,'Etlain Ommasterye',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010459,30000196,20000028,10000002),(3009406,'Fealige Mogotte',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010438,30001413,20000207,10000016),(3009407,'Boubbuenelle Aette',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010441,30001413,20000207,10000016),(3009408,'Gramaert Rulaert',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010414,30002082,20000307,10000042),(3009409,'Arnasent Aurmont',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010417,30002082,20000307,10000042),(3009410,'Deuverin Ogorard',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010474,30002097,20000309,10000042),(3009411,'Honnolia Waungvande',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010477,30002098,20000309,10000042),(3009412,'Ekare Amie',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010408,30002516,20000368,10000030),(3009413,'Bietinievres Patsectiers',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010411,30002517,20000368,10000030),(3009414,'Coella Chetirgrullin',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010450,30002680,20000392,10000032),(3009415,'Cohemitte Grinarel',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010453,30002684,20000392,10000032),(3009416,'Steine Bourynes',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010432,30003391,20000494,10000042),(3009417,'Prollenget Audodart',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010435,30003391,20000494,10000042),(3009418,'Ghele Wousterier',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010480,30003588,20000523,10000044),(3009419,'Sansallelle Varaert',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010483,30003593,20000523,10000044),(3009420,'Enauweyle Lermenlieu',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010471,30003795,20000554,10000048),(3009421,'Auretins Ovaert',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010468,30003796,20000554,10000048),(3009422,'Taenive Achtens',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010447,30005004,20000732,10000064),(3009423,'Valt Frarel',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010444,30005007,20000732,10000064),(3009424,'Claynese Hoyessot',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010462,30005053,20000739,10000065),(3009425,'Stranders Achtan',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010465,30005054,20000739,10000065),(3009426,'Pienordanne Dellerite',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010405,30005062,20000741,10000065),(3009427,'Blala Vancent',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010402,30005065,20000741,10000065),(3009428,'Alleline Annins',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010423,30005069,20000742,10000065),(3009429,'Esseraimer Amoen',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010420,30005075,20000742,10000065),(3009430,'Wifrerante Vaydaerer',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010426,30005269,20000771,10000067),(3009431,'Fobvraert Leckerot',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010429,30005273,20000771,10000067),(3009432,'Amaeroure Atlaurjaere',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010399,30005301,20000776,10000068),(3009433,'Vingaire Malalle',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010486,30003038,20000445,10000037),(3009434,'Doullenne Alleron',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010492,30001644,20000243,10000020),(3009435,'Pessoen Ladistier',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010495,30001646,20000243,10000020),(3009436,'Omoen Bonnare',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010504,30001703,20000252,10000020),(3009437,'Euroque Meribene',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010507,30001705,20000252,10000020),(3009438,'Coene Wagnere',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010522,30002090,20000308,10000042),(3009439,'Rosostrard Slassulle',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010525,30002091,20000308,10000042),(3009440,'Lanninck Scoullard',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010558,30002190,20000322,10000043),(3009441,'Rairthie Choutte',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010561,30002190,20000322,10000043),(3009442,'Froil Vellan',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010537,30002531,20000371,10000030),(3009443,'Galotyne Adent',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010534,30002535,20000371,10000030),(3009444,'Octanneve Ametens',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010510,30002711,20000396,10000032),(3009445,'Abber Defurman',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010513,30002711,20000396,10000032),(3009446,'Arnanbane Ravacesel',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010570,30002740,20000401,10000033),(3009447,'Vertorinc Jarverwel',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010573,30002740,20000401,10000033),(3009448,'Lauvrende Heyfriroler',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010540,30002750,20000403,10000033),(3009449,'Mattebaert Vyne',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010543,30002750,20000403,10000033),(3009450,'Masoutte Crecetins',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010489,30003040,20000445,10000037),(3009451,'Aiges Blayme',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010546,30003309,20000483,10000041),(3009452,'Pecsins Ivier',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010549,30003314,20000483,10000041),(3009453,'Abake Scech',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010552,30003381,20000493,10000042),(3009454,'Bakkarault Brevier',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010555,30003385,20000493,10000042),(3009455,'Asnia Atleraetan',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010519,30003573,20000521,10000044),(3009456,'Arevync Olemina',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010516,30003576,20000521,10000044),(3009457,'Hornelirlis Alonon',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010531,30004268,20000624,10000054),(3009458,'Achoure Ahreres',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010528,30004272,20000624,10000054),(3009459,'Lanvale Thilotte',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010501,30005031,20000736,10000065),(3009460,'Guilin Bouil',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010498,30005034,20000736,10000065),(3009461,'Ganoure Deria',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010564,30005082,20000744,10000065),(3009462,'Saussay Raouschilard',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010567,30005085,20000744,10000065),(3009463,'Jorredel Mautene',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010576,30003043,20000445,10000037),(3009464,'Annon Adeladie',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010582,30002662,20000390,10000032),(3009465,'Fauselynck Aernonnire',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010585,30002664,20000390,10000032),(3009466,'Ophaghener Auroulde',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010606,30002676,20000392,10000032),(3009467,'Hammianne Aurmeersch',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010609,30002676,20000392,10000032),(3009468,'Aulleem Monatave',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010600,30002709,20000396,10000032),(3009469,'Stalocline Assye',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010603,30002711,20000396,10000032),(3009470,'Ellosant Ongve',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010624,30002718,20000398,10000032),(3009471,'Allilieres Merrore',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010627,30002723,20000398,10000032),(3009472,'Aboy Ophilamon',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010618,30003025,20000443,10000037),(3009473,'Lauvrende Cesattene',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010621,30003026,20000443,10000037),(3009474,'Moveval Polirine',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010594,30003033,20000444,10000037),(3009475,'Bunbaviette Marittine',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010597,30003033,20000444,10000037),(3009476,'Arnetraert Brelerc',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010579,30003040,20000445,10000037),(3009477,'Antree Essoennan',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010588,30003057,20000447,10000037),(3009478,'Aymaloyal Carlery',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010591,30003060,20000447,10000037),(3009479,'Alpicard Pernaeneve',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010630,30003602,20000525,10000044),(3009480,'Rueminck Dusselitte',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010633,30003602,20000525,10000044),(3009481,'Ameron Symnes',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010612,30005296,20000775,10000068),(3009482,'Arnoux Obesync',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010615,30005297,20000775,10000068),(3009483,'Ognye Sancenard',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010636,30003830,20000560,10000048),(3009484,'Anzattune Symanche',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010714,30002190,20000322,10000043),(3009485,'Vleys Atrync',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010717,30002191,20000322,10000043),(3009486,'Maursey Ardaelter',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010702,30002533,20000371,10000030),(3009487,'Allalleniel Avaneel',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010705,30002534,20000371,10000030),(3009488,'Lagemorne Lallerordon',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010666,30002685,20000393,10000032),(3009489,'Aldrawitte Clear',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010669,30002687,20000393,10000032),(3009490,'Aurme Aernanaert',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010675,30002978,20000436,10000036),(3009491,'Jabbepin Burlaert',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010672,30002979,20000436,10000036),(3009492,'Kergagoncer Houfriellan',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010696,30003541,20000516,10000043),(3009493,'Coligent Laler',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010699,30003541,20000516,10000043),(3009494,'Ciloroial Evacone',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010663,30003574,20000521,10000044),(3009495,'Devalon Nobreler',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010660,30003578,20000521,10000044),(3009496,'Racie Audaden',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010639,30003832,20000560,10000048),(3009497,'Ormendedier Upheve',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010642,30004122,20000603,10000052),(3009498,'Mavrotta Lasnovins',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010645,30004126,20000603,10000052),(3009499,'Gallusiene Heylmetomet',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010690,30004254,20000623,10000054),(3009500,'Wyrocque Grelibert',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010693,30004260,20000623,10000054),(3009501,'Flogedine Erdia',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010678,30004987,20000730,10000064),(3009502,'Euvon Allelluc',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010681,30004991,20000730,10000064),(3009503,'Ornel Ambramotte',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010723,30005024,20000735,10000064),(3009504,'Gifrelebier Dermier',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010720,30005025,20000735,10000064),(3009505,'Aymaloyal Saggherwey',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010708,30005056,20000740,10000065),(3009506,'Blolilan Odire',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010711,30005058,20000740,10000065),(3009507,'Housevel Aliguet',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010654,30005207,20000762,10000067),(3009508,'Yvevet Reyfritenne',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010657,30005207,20000762,10000067),(3009509,'Tameroy Crerite',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010684,30005290,20000774,10000067),(3009510,'Estime Hovrelaert',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010687,30005290,20000774,10000067),(3009511,'Gaunia Octeyncaere',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010648,30005312,20000777,10000068),(3009512,'Harc Ambertin',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010651,30005312,20000777,10000068),(3009513,'Docararde Edmerent',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010726,30002706,20000396,10000032),(3009514,'Alisson Vioncheriler',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010822,30000189,20000027,10000002),(3009515,'Eburch Esalion',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010819,30000190,20000027,10000002),(3009516,'Dovaille Auters',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010816,30000193,20000027,10000002),(3009517,'Achalle Ryhedier',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010807,30001430,20000210,10000016),(3009518,'Arbra Esmecet',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010810,30001430,20000210,10000016),(3009519,'Reysetouttes Lornache',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010813,30001430,20000210,10000016),(3009520,'Avapanne Alelyncke',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010843,30001681,20000249,10000020),(3009521,'Alpetane Jolloge',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010846,30001681,20000249,10000020),(3009522,'Malayme Eldiart',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010849,30001683,20000249,10000020),(3009523,'Vientes Zuler',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010792,30002228,20000327,10000043),(3009524,'Afdier Couster',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010789,30002230,20000327,10000043),(3009525,'Kuerne Amungher',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010795,30002234,20000327,10000043),(3009526,'Saluvon Ekeneron',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010852,30002575,20000378,10000030),(3009527,'Artenne Preldent',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010855,30002575,20000378,10000030),(3009528,'Beddery Ghyllenne',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010858,30002578,20000378,10000030),(3009529,'Brens Tilpourel',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010804,30002693,20000394,10000032),(3009530,'Valeppaert Daoullon',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010798,30002697,20000394,10000032),(3009531,'Aussa Than',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010801,30002697,20000394,10000032),(3009532,'Hedoubel Crens',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010732,30002706,20000396,10000032),(3009533,'Losietes Cronart',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010729,30002707,20000396,10000032),(3009534,'Cooleemina Wiranstoure',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010744,30002996,20000439,10000036),(3009535,'Chostins Gaenloovitte',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010747,30002996,20000439,10000036),(3009536,'Adrel Tevatier',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010750,30002997,20000439,10000036),(3009537,'Bedepant Flor',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010771,30003073,20000449,10000038),(3009538,'Pongheronne Camena',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010774,30003075,20000449,10000038),(3009539,'Froyer Jaec',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010777,30003078,20000449,10000038),(3009540,'Orollede Praylt',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010741,30003374,20000492,10000042),(3009541,'Alemel Agerin',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010738,30003375,20000492,10000042),(3009542,'Coleron Dosevale',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010735,30003380,20000492,10000042),(3009543,'Lalie Cussal',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010753,30003423,20000499,10000042),(3009544,'Ytee Ponebins',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010759,30003426,20000499,10000042),(3009545,'Arcent Eullaerdt',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010756,30003427,20000499,10000042),(3009546,'Ophaestores Omain',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010828,30004502,20000657,10000057),(3009547,'Madoure Ysoron',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010825,30004504,20000657,10000057),(3009548,'Estre Ignoure',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010831,30004504,20000657,10000057),(3009549,'Menges Mellencourt',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010780,30004968,20000727,10000064),(3009550,'Mammon Denvonne',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010783,30004969,20000727,10000064),(3009551,'Chrirentine Erdocoure',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010768,30005024,20000735,10000064),(3009552,'Avagher Crerant',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010768,30005024,20000735,10000064),(3009553,'Carpon Onck',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010765,30005025,20000735,10000064),(3009554,'Albenide Rost',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010762,30005029,20000735,10000064),(3009555,'Herirlier Auvrolaert',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010834,30005310,20000777,10000068),(3009556,'Alhot Fomtelot',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010837,30005310,20000777,10000068),(3009557,'Buinie Feritte',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010840,30005312,20000777,10000068),(3009558,'Obalanes Ardarette',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010861,30003048,20000446,10000037),(3009559,'Ancevence Achelasse',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010894,30002668,20000391,10000032),(3009560,'Gryncelbois Erris',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010888,30002670,20000391,10000032),(3009561,'Brorsch Ilerie',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010891,30002672,20000391,10000032),(3009562,'Ambelane Lean',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010948,30002692,20000394,10000032),(3009563,'Cylelle Sloure',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010945,30002694,20000394,10000032),(3009564,'Arnanon Eynie',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010942,30002696,20000394,10000032),(3009565,'Afria Edmiette',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010930,30002732,20000400,10000032),(3009566,'Avagher Xarasier',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010924,30002734,20000400,10000032),(3009567,'Freder Aernelaert',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010927,30002736,20000400,10000032),(3009568,'Brens Devalon',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010867,30003054,20000446,10000037),(3009569,'Melie Gheyr',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010864,30003055,20000446,10000037),(3009570,'Alserore Allelery',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010915,30003576,20000521,10000044),(3009571,'Rayle Amerique',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010921,30003577,20000521,10000044),(3009572,'Audamia Bourgaredyn',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010918,30003578,20000521,10000044),(3009573,'Havrylallin Eurt',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010879,30003795,20000554,10000048),(3009574,'Rilz Annaschaert',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010882,30003798,20000554,10000048),(3009575,'Nayette Rorena',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010885,30003799,20000554,10000048),(3009576,'Lenia Geditte',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010903,30003806,20000556,10000048),(3009577,'Oirlair Arroy',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010897,30003808,20000556,10000048),(3009578,'Ollon Dumes',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010900,30003810,20000556,10000048),(3009579,'Porchomette Chandrard',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010906,30004967,20000727,10000064),(3009580,'Eussa Arlon',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010912,30004968,20000727,10000064),(3009581,'Aynstie Wentisagnel',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010909,30004969,20000727,10000064),(3009582,'Aleyvriman Elgent',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010933,30004979,20000729,10000064),(3009583,'Arberner Gouc',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010939,30004979,20000729,10000064),(3009584,'Agrelieres Argre',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010936,30004981,20000729,10000064),(3009585,'Bostiers Oderyncke',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010870,30005302,20000776,10000068),(3009586,'Ruborraude Eyghelet',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010873,30005304,20000776,10000068),(3009587,'Lugerer Ameurthe',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010876,30005306,20000776,10000068),(3009588,'Bautamps Yolalotte',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010951,30003792,20000553,10000048),(3009589,'Delmoler Motmonnie',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011029,30002692,20000394,10000032),(3009590,'Jamaert Wey',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011038,30002692,20000394,10000032),(3009591,'Arble Entel',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011026,30002693,20000394,10000032),(3009592,'Gaenloovitte Demette',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011023,30002695,20000394,10000032),(3009593,'Aufay Hurrimoult',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011032,30002696,20000394,10000032),(3009594,'Mobrault Adratins',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011035,30002696,20000394,10000032),(3009595,'Elelere Albunel',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011101,30003017,20000442,10000037),(3009596,'Wyrocque Badeneque',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011107,30003018,20000442,10000037),(3009597,'Erdocoure Botane',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011095,30003023,20000442,10000037),(3009598,'Amaungheron Agorante',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011098,30003023,20000442,10000037),(3009599,'Lyfdevos Armaviere',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011104,30003023,20000442,10000037),(3009600,'Arbame Vimereau',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011110,30003023,20000442,10000037),(3009601,'Brubelle Hessieuwe',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011113,30003028,20000443,10000037),(3009602,'Antfe Ratillose',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011128,30003028,20000443,10000037),(3009603,'Poriguier Vainste',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011122,30003029,20000443,10000037),(3009604,'Crillottain Betton',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011125,30003029,20000443,10000037),(3009605,'Lympia Oisiree',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011116,30003030,20000443,10000037),(3009606,'Abue Bruttande',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011119,30003030,20000443,10000037),(3009607,'Arnastere Aurgier',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011059,30003579,20000522,10000044),(3009608,'Ivalier Paen',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011065,30003579,20000522,10000044),(3009609,'Vevennitte Allottes',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011062,30003582,20000522,10000044),(3009610,'Araverie Annacel',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011068,30003584,20000522,10000044),(3009611,'Piedie Chaffryriene',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011074,30003584,20000522,10000044),(3009612,'Ponelalie Sabenaret',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011071,30003586,20000522,10000044),(3009613,'Horbomais Jonenor',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011041,30003588,20000523,10000044),(3009614,'Hos Inier',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011044,30003588,20000523,10000044),(3009615,'Pier Vesevecer',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011047,30003588,20000523,10000044),(3009616,'Anzires Alate',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011056,30003588,20000523,10000044),(3009617,'Locherghen Kersolis',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011053,30003590,20000523,10000044),(3009618,'Fofstalle Camenlieu',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011050,30003591,20000523,10000044),(3009619,'Eys Osmagne',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010954,30003787,20000553,10000048),(3009620,'Riselgale Inault',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010963,30003788,20000553,10000048),(3009621,'Afromanne Therckosiere',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010960,30003789,20000553,10000048),(3009622,'Vitte Vilinnon',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010957,30003790,20000553,10000048),(3009623,'Irlier Mounch',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010966,30003793,20000553,10000048),(3009624,'Eura Meure',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010999,30003824,20000559,10000048),(3009625,'Amoderia Alamel',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010987,30003825,20000559,10000048),(3009626,'Orone Algana',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010993,30003826,20000559,10000048),(3009627,'Orasse Vidotere',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011002,30003826,20000559,10000048),(3009628,'Rorralachies Leonavor',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010990,30003828,20000559,10000048),(3009629,'Iverie Henoiltet',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010996,30003829,20000559,10000048),(3009630,'Gie Alloviene',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011008,30003836,20000561,10000048),(3009631,'Marjamette Alanault',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011017,30003836,20000561,10000048),(3009632,'Mahieu Blie',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011014,30003837,20000561,10000048),(3009633,'Aminghere Cotlamaert',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011011,30003838,20000561,10000048),(3009634,'Paen Vediere',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011020,30003839,20000561,10000048),(3009635,'Gaecoudel Afriraurer',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011005,30003840,20000561,10000048),(3009636,'Albroralle Onfranotte',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010969,30005009,20000733,10000064),(3009637,'Illadie Elemite',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010975,30005009,20000733,10000064),(3009638,'Chanarana Yvatus',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010984,30005010,20000733,10000064),(3009639,'Abake Paunssy',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010972,30005014,20000733,10000064),(3009640,'Parts Claucanins',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010978,30005014,20000733,10000064),(3009641,'Beborres Apamoote',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60010981,30005014,20000733,10000064),(3009642,'Canisere Houviron',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011092,30005016,20000734,10000064),(3009643,'Tivianne Brere',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011080,30005019,20000734,10000064),(3009644,'Loillaintes Thoun',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011086,30005019,20000734,10000064),(3009645,'Breye Albryralle',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011077,30005022,20000734,10000064),(3009646,'Tranard Arnoche',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011089,30005022,20000734,10000064),(3009647,'Grolt Aulle',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011083,30005023,20000734,10000064),(3009648,'Rebbois Vreau',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011131,30002712,20000397,10000032),(3009649,'Sorgard Caullon',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011152,30001356,20000198,10000016),(3009650,'Rosane Ynck',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011149,30001357,20000198,10000016),(3009651,'Bouscain Bougnisarin',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011257,30005268,20000771,10000067),(3009652,'Cadegier Aubrottore',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011260,30005269,20000771,10000067),(3009653,'Orsognave Abene',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011251,30005270,20000771,10000067),(3009654,'Tean Vayle',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011254,30005272,20000771,10000067),(3009655,'Anwyns Caroivrin',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011212,30005308,20000777,10000068),(3009656,'Dewnellin Biels',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011203,30005311,20000777,10000068),(3009657,'Janyrance Aques',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011209,30005311,20000777,10000068),(3009658,'Tirfer Bappenalle',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011206,30005313,20000777,10000068),(3009659,'Tulet Anselon',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011143,30001358,20000198,10000016),(3009660,'Aernerault Reyrlouttes',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011146,30001359,20000198,10000016),(3009661,'Orviddore Dawerckhengot',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011176,30001411,20000207,10000016),(3009662,'Avoler Parmedent',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011170,30001413,20000207,10000016),(3009663,'Widier Ancellare',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011173,30001413,20000207,10000016),(3009664,'Reditteau Oursagnire',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011167,30001414,20000207,10000016),(3009665,'Mousore Ambiertes',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011302,30001698,20000251,10000020),(3009666,'Agalle Auralle',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011299,30001699,20000251,10000020),(3009667,'Chentchraert Falollone',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011305,30001699,20000251,10000020),(3009668,'Albootella Ekare',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011308,30001699,20000251,10000020),(3009669,'Anzalolie Erme',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011161,30001724,20000255,10000020),(3009670,'Ophalire Abins',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011164,30001724,20000255,10000020),(3009671,'Calsesirier Asselle',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011158,30001726,20000255,10000020),(3009672,'Wyrocque Gouey',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011155,30001727,20000255,10000020),(3009673,'Myennitte Alpymer',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011290,30002051,20000302,10000042),(3009674,'Janninck Aydet',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011293,30002052,20000302,10000042),(3009675,'Chrare Aydet',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011296,30002052,20000302,10000042),(3009676,'Buedoupon Arique',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011287,30002053,20000302,10000042),(3009677,'Ongve Essarette',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011185,30002551,20000374,10000030),(3009678,'Neyrtetolle Exaserin',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011188,30002552,20000374,10000030),(3009679,'Ysorancke Azuritte',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011182,30002553,20000374,10000030),(3009680,'Bourens Boingaroix',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011179,30002554,20000374,10000030),(3009681,'Halmante Kelaeys',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011263,30002692,20000394,10000032),(3009682,'Ancirris Cololoisa',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011266,30002695,20000394,10000032),(3009683,'Adames Astre',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011269,30002698,20000394,10000032),(3009684,'Olelie Tralidmel',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011272,30002698,20000394,10000032),(3009685,'Gollelle Thormonnie',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011137,30002716,20000397,10000032),(3009686,'Arrion Lastegghem',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011134,30002717,20000397,10000032),(3009687,'Oune Aires',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011140,30002717,20000397,10000032),(3009688,'Olarault Rollorotte',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011275,30003322,20000484,10000041),(3009689,'Mitendrittan Eglerique',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011278,30003323,20000484,10000041),(3009690,'Allync Fliet',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011281,30003326,20000484,10000041),(3009691,'Vivarie Ainou',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011284,30003326,20000484,10000041),(3009692,'Goivin Amanan',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011215,30003349,20000488,10000041),(3009693,'Evotes Fiert',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011218,30003349,20000488,10000041),(3009694,'Leoroilete Ashtucer',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011221,30003351,20000488,10000041),(3009695,'Blour Nitte',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011224,30003351,20000488,10000041),(3009696,'Racrot Releminck',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011200,30003473,20000507,10000043),(3009697,'Lalx Soil',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011197,30003474,20000507,10000043),(3009698,'Govrercard Veffort',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011194,30003476,20000507,10000043),(3009699,'Boulainose Porolbier',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011191,30003479,20000507,10000043),(3009700,'Crucarne Odeune',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011242,30003818,20000558,10000048),(3009701,'Mavrenelois Aeghe',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011245,30003820,20000558,10000048),(3009702,'Brouneva Foldette',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011248,30003821,20000558,10000048),(3009703,'Memanoutte Fircal',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011239,30003822,20000558,10000048),(3009704,'Ogoure Hare',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011227,30005255,20000769,10000067),(3009705,'Echibaver Noise',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011233,30005256,20000769,10000067),(3009706,'Clos Avanevon',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011236,30005256,20000769,10000067),(3009707,'Almie Ardonsele',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011230,30005258,20000769,10000067),(3009708,'Ausmaert Baver',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011311,30004972,20000727,10000064),(3009709,'Asmier Rurmonlieu',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011320,30003051,20000446,10000037),(3009710,'Andrie Delleliot',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011317,30003055,20000446,10000037),(3009711,'Wire Cherere',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011347,30003060,20000447,10000037),(3009712,'Alurel Aciane',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011350,30003060,20000447,10000037),(3009713,'Aurriest Olain',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011365,30003584,20000522,10000044),(3009714,'Avynes Gelluire',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011368,30003584,20000522,10000044),(3009715,'Roubuenet Kole',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011344,30003595,20000524,10000044),(3009716,'Pallinoncher Harere',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011341,30003600,20000524,10000044),(3009717,'Altre Lollina',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011329,30003603,20000525,10000044),(3009718,'Aessen Ancille',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011332,30003603,20000525,10000044),(3009719,'Mivent Gastomitte',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011356,30003839,20000561,10000048),(3009720,'Ostailitte Ashtolairer',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011353,30003842,20000561,10000048),(3009721,'Agrastyn Kues',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011326,30003845,20000562,10000048),(3009722,'Fengaralle Groelande',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011323,30003848,20000562,10000048),(3009723,'Romene Belagers',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011332,30003603,20000525,10000044),(3009724,'Dalle Audre',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011335,30004980,20000729,10000064),(3009725,'Orsovrin Slie',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011338,30004981,20000729,10000064),(3009726,'Lachorier Woucompeau',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011359,30004988,20000730,10000064),(3009727,'Gayle Alenille',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011362,30004992,20000730,10000064),(3009728,'Ysannync Yvoorlalin',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011371,30003792,20000553,10000048),(3009729,'Dhoorcare Atlulle',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011374,30003788,20000553,10000048),(3009730,'Sanghe Carrenner',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011377,30003788,20000553,10000048),(3009731,'Dealake Eulasen',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011470,30004111,20000601,10000052),(3009732,'Florvaert Bleverie',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011473,30004111,20000601,10000052),(3009733,'Quesne Ogoure',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011476,30004114,20000601,10000052),(3009734,'Lalie Braire',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011491,30004139,20000605,10000052),(3009735,'Odoirouve Orviene',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011494,30004139,20000605,10000052),(3009736,'Delet Yvevet',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011488,30004141,20000605,10000052),(3009737,'Alonaert Adyttier',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011464,30004232,20000619,10000054),(3009738,'Cholle Eppied',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011461,30004235,20000619,10000054),(3009739,'Durlanveyne Indritte',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011467,30004235,20000619,10000054),(3009740,'Abin Turavanon',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011395,30004289,20000627,10000054),(3009741,'Artanbine Pecourt',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011389,30004293,20000627,10000054),(3009742,'Elinore Saluvon',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011392,30004295,20000627,10000054),(3009743,'Challet Ardelooris',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011446,30005083,20000744,10000065),(3009744,'Ermon Ararezer',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011443,30005085,20000744,10000065),(3009745,'Cloic Atlolas',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011449,30005086,20000744,10000065),(3009746,'Misouvon Iques',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011479,30005250,20000768,10000067),(3009747,'Rarie Rollose',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011482,30005250,20000768,10000067),(3009748,'Charballe Allare',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011485,30005253,20000768,10000067),(3009749,'Vyne Fartlois',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011398,30005302,20000776,10000068),(3009750,'Possare Demman',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011401,30005302,20000776,10000068),(3009751,'Vampoudel Armattin',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011404,30005302,20000776,10000068),(3009752,'Xarasier Proun',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011497,30001365,20000199,10000016),(3009753,'Allilieres Ley',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011503,30001365,20000199,10000016),(3009754,'Amivel Jans',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011500,30001366,20000199,10000016),(3009755,'Zuen Carlune',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011386,30001725,20000255,10000020),(3009756,'Sacuttaere Chasmiot',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011380,30001728,20000255,10000020),(3009757,'Comeniennan Charteau',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011383,30001728,20000255,10000020),(3009758,'Aestou Croubs',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011434,30002078,20000306,10000042),(3009759,'Baust Alanckbrault',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011440,30002078,20000306,10000042),(3009760,'Covais Audadet',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011437,30002081,20000306,10000042),(3009761,'Bresent Aussier',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011410,30002543,20000373,10000030),(3009762,'Elaille Rounon',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011407,30002546,20000373,10000030),(3009763,'Egheyns Vrierbins',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011413,30002546,20000373,10000030),(3009764,'Blies Atte',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011431,30002677,20000392,10000032),(3009765,'Presetin Phinenes',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011425,30002679,20000392,10000032),(3009766,'Ayse Marnelelle',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011428,30002680,20000392,10000032),(3009767,'Armaine Herene',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011455,30003397,20000495,10000042),(3009768,'Yndt Marirscard',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011458,30003397,20000495,10000042),(3009769,'Atlycet Gillahuene',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011452,30003398,20000495,10000042),(3009770,'Cacottet Daruelet',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011416,30003430,20000500,10000042),(3009771,'Varsters Aleyde',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011422,30003430,20000500,10000042),(3009772,'Mort Harner',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011419,30003432,20000500,10000042),(3009773,'Ophelame Aubalin',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011506,30003025,20000443,10000037),(3009774,'Jayenne Orvere',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011542,30002696,20000394,10000032),(3009775,'Aubulle Maimanne',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011545,30002696,20000394,10000032),(3009776,'Andt Ossche',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011554,30002733,20000400,10000032),(3009777,'Olotiers Karroux',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011557,30002733,20000400,10000032),(3009778,'Assoi Ekelane',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011509,30003028,20000443,10000037),(3009779,'Vydreris Henneque',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011548,30003058,20000447,10000037),(3009780,'Cauvers Bris',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011551,30003058,20000447,10000037),(3009781,'Albatoulon Blaerd',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011512,30003590,20000523,10000044),(3009782,'Coleeres Avocort',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011515,30003592,20000523,10000044),(3009783,'Boulbrens Keirevardt',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011536,30003796,20000554,10000048),(3009784,'Hompserain Avais',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011539,30003796,20000554,10000048),(3009785,'Groun Sintchrottier',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011524,30003801,20000555,10000048),(3009786,'Nulia Holle',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011527,30003804,20000555,10000048),(3009787,'Echarbins Lelaert',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011530,30005311,20000777,10000068),(3009788,'Agrenienes Zumpbaerse',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011533,30005311,20000777,10000068),(3009789,'Garecque Lyndroutte',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011521,30005316,20000778,10000068),(3009790,'Gictes Archeralle',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011518,30005319,20000778,10000068),(3009791,'Lexmoreau Oloure',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011560,30005329,20000780,10000068),(3009792,'Trititel Elarerie',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011563,30005333,20000780,10000068),(3009793,'Austant Lange',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011566,30002715,20000397,10000032),(3009794,'Auzue Estisen',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011584,30002650,20000388,10000032),(3009795,'Megnyve Charis',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011593,30002672,20000391,10000032),(3009796,'Ancye Egghonelle',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011578,30002693,20000394,10000032),(3009797,'Huvertet Cherore',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011569,30003040,20000445,10000037),(3009798,'Baider Austret',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011572,30003831,20000560,10000048),(3009799,'Muvinare Enins',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011590,30005019,20000734,10000064),(3009800,'Afretleroy Olarault',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011575,30005302,20000776,10000068),(3009801,'Plose Oraneles',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011581,30005315,20000778,10000068),(3009802,'Rirvelan Cyrynier',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011587,30005322,20000779,10000068),(3009803,'Wadis Chene',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011599,30004998,20000731,10000064),(3009804,'Aydefroy Brechalle',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011605,30005000,20000731,10000064),(3009805,'Noettirekel Ysorancke',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011611,30004998,20000731,10000064),(3009806,'Olanne Grasternes',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011614,30004972,20000727,10000064),(3009807,'Duhotolie Wicilla',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011716,30002663,20000390,10000032),(3009808,'Arnadelau Auvergne',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011713,30002664,20000390,10000032),(3009809,'Alarancke Vesnync',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011710,30002666,20000390,10000032),(3009810,'Bay Baul',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011719,30002667,20000390,10000032),(3009811,'Hampuere Ambrea',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011677,30002699,20000395,10000032),(3009812,'Dellerite Auffrel',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011680,30002699,20000395,10000032),(3009813,'Arsant Acke',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011683,30002699,20000395,10000032),(3009814,'Rattinck Elelleem',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011674,30002701,20000395,10000032),(3009815,'Astoirron Carrenner',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011626,30003010,20000441,10000037),(3009816,'Ayne Prerie',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011629,30003011,20000441,10000037),(3009817,'Patier Eyron',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011632,30003013,20000441,10000037),(3009818,'Vlalesette Vocque',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011635,30003015,20000441,10000037),(3009819,'Launsier Laye',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011689,30003024,20000443,10000037),(3009820,'Eglournel Tevore',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011686,30003025,20000443,10000037),(3009821,'Alomas Acent',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011695,30003025,20000443,10000037),(3009822,'Mervelaert Pattasel',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011692,30003028,20000443,10000037),(3009823,'Loot Astyroure',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011659,30003049,20000446,10000037),(3009824,'Arnollin Bribert',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011656,30003050,20000446,10000037),(3009825,'Jorerout Aunon',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011650,30003052,20000446,10000037),(3009826,'Zanisale Virrelina',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011653,30003054,20000446,10000037),(3009827,'Pocrel Ornargot',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011701,30003794,20000554,10000048),(3009828,'Maulckaert Reysetouttes',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011707,30003797,20000554,10000048),(3009829,'Madelanda Parblagas',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011704,30003798,20000554,10000048),(3009830,'Larsch Braut',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011698,30003799,20000554,10000048),(3009831,'Lame Hetymmon',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011641,30003818,20000558,10000048),(3009832,'Egliller Dasbrulier',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011644,30003819,20000558,10000048),(3009833,'Osmarbon Impsie',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011638,30003823,20000558,10000048),(3009834,'Awel Emmalaute',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011647,30003823,20000558,10000048),(3009835,'Assalurie Voilidier',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011731,30003830,20000560,10000048),(3009836,'Starella Alakaert',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011722,30003831,20000560,10000048),(3009837,'Amanckbrault Octienne',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011725,30003832,20000560,10000048),(3009838,'Vysena Cavin',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011728,30003832,20000560,10000048),(3009839,'Eloede Ambekel',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011617,30004967,20000727,10000064),(3009840,'Anchave Vienlomandie',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011623,30004967,20000727,10000064),(3009841,'Pausent Ansin',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011620,30004968,20000727,10000064),(3009842,'Lorchaert Schend',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011662,30004976,20000728,10000064),(3009843,'Aurelie Orvinelle',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011665,30004976,20000728,10000064),(3009844,'Alocenet Arnelon',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011668,30004976,20000728,10000064),(3009845,'Atlay Arand',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011671,30004976,20000728,10000064),(3009846,'Charie Octienne',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011734,30004972,20000727,10000064),(3009847,'Amieu Eynie',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011788,30002692,20000394,10000032),(3009848,'Houruene Mocaraille',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011797,30002692,20000394,10000032),(3009849,'Yhou Ekarnard',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011800,30002692,20000394,10000032),(3009850,'Paiesint Juritte',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011794,30002693,20000394,10000032),(3009851,'Blalt Appoi',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011791,30002695,20000394,10000032),(3009852,'Omune Rilleririan',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011803,30002697,20000394,10000032),(3009853,'Erocque Fintere',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011848,30002731,20000400,10000032),(3009854,'Amarulyn Carnoirese',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011854,30002732,20000400,10000032),(3009855,'Befstey Bourd',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011857,30002733,20000400,10000032),(3009856,'Javenins Angelle',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011851,30002734,20000400,10000032),(3009857,'Poucke Ourd',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011842,30002735,20000400,10000032),(3009858,'Brinalle Noutte',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011887,30003799,20000554,10000048),(3009859,'Alync Oraveval',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011752,30003580,20000522,10000044),(3009860,'Omesere Gaunellieu',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011755,30003584,20000522,10000044),(3009861,'Stans Callor',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011761,30003584,20000522,10000044),(3009862,'Asly Tarmas',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011764,30003584,20000522,10000044),(3009863,'Indt Aimeguier',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011758,30003585,20000522,10000044),(3009864,'Ansonelle Parts',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011767,30003586,20000522,10000044),(3009865,'Houre Hazaerdt',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011812,30003602,20000525,10000044),(3009866,'Buroghe Vanaillot',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011818,30003602,20000525,10000044),(3009867,'Dusene Alirener',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011809,30003604,20000525,10000044),(3009868,'Iluelle Oloque',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011815,30003606,20000525,10000044),(3009869,'Pontryvel Borgier',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011806,30003607,20000525,10000044),(3009870,'Afruvin Angenger',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011821,30003607,20000525,10000044),(3009871,'Hoo Ghes',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011893,30003794,20000554,10000048),(3009872,'Helbrorand Segengiere',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011878,30003796,20000554,10000048),(3009873,'Aidarard Achatin',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011890,30003796,20000554,10000048),(3009874,'Maison Orinonet',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011881,30003799,20000554,10000048),(3009875,'Baesen Gre',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011884,30003799,20000554,10000048),(3009876,'Destaseke Zertavenne',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011887,30003799,20000554,10000048),(3009877,'Wimpes Airou',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011770,30003818,20000558,10000048),(3009878,'Tostrere Allelare',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011782,30003818,20000558,10000048),(3009879,'Ruerrotta Cins',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011779,30003819,20000558,10000048),(3009880,'Ivalier Agattault',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011785,30003819,20000558,10000048),(3009881,'Saralle Mammon',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011773,30003820,20000558,10000048),(3009882,'Gererique Opheles',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011776,30003820,20000558,10000048),(3009883,'Pillius Douls',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011824,30003830,20000560,10000048),(3009884,'Acanitte Archeralle',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011830,30003831,20000560,10000048),(3009885,'Cavanard Bolle',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011833,30003831,20000560,10000048),(3009886,'Dingue Farressent',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011836,30003833,20000560,10000048),(3009887,'Clanac Aitree',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011839,30003833,20000560,10000048),(3009888,'Anges Vyrier',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011827,30003834,20000560,10000048),(3009889,'Ardorele Minaeghe',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011749,30004967,20000727,10000064),(3009890,'Dillesse Cloesmant',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011746,30004968,20000727,10000064),(3009891,'Railbeuse Soeillindre',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011737,30004969,20000727,10000064),(3009892,'Zwendt Brinalle',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011740,30004969,20000727,10000064),(3009893,'Pomouber Eyl',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011743,30004969,20000727,10000064),(3009894,'Saonellieu Baerse',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011866,30002659,20000389,10000032),(3009895,'Thirtirare Allettine',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011908,30005323,20000779,10000068),(3009896,'Chabaine Orladet',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011905,30005325,20000779,10000068),(3009897,'Stasylace Ambesene',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011896,30005328,20000779,10000068),(3009898,'Anteson Ranchel',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011902,30005328,20000779,10000068),(3009899,'Sunnac Mostetaux',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011911,30005328,20000779,10000068),(3009900,'Bunarolie Vetanailles',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011875,30002655,20000389,10000032),(3009901,'Eladette Gelarbese',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011872,30002657,20000389,10000032),(3009902,'Lausesamme Haratel',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011866,30002659,20000389,10000032),(3009903,'Oribelon Grinacanne',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011860,30002660,20000389,10000032),(3009904,'Aide Lerrilla',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011863,30002660,20000389,10000032),(3009905,'Esate Binck',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011869,30002660,20000389,10000032),(3009906,'Carane Poi',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011914,30004970,20000727,10000064),(3009907,'Setiges Hustiquier',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011923,30002636,20000386,10000032),(3009908,'Molilier Daneque',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011926,30002635,20000386,10000032),(3009909,'Ormalon Gien',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011929,30002641,20000386,10000032),(3009910,'Amerique Jostalie',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011983,30002656,20000389,10000032),(3009911,'Lalie Thilriegitte',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011977,30002660,20000389,10000032),(3009912,'Sye Bruelle',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011980,30002660,20000389,10000032),(3009913,'Sois Orsane',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011998,30003010,20000441,10000037),(3009914,'Harquier Foutte',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011995,30003014,20000441,10000037),(3009915,'Menivare Aleau',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012001,30003016,20000441,10000037),(3009916,'Annaire Oflia',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011953,30003573,20000521,10000044),(3009917,'Chammegestin Allote',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011950,30003574,20000521,10000044),(3009918,'Guynnier Densseurthe',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011956,30003576,20000521,10000044),(3009919,'Zanere Aertan',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011992,30003588,20000523,10000044),(3009920,'Reynon Aret',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011989,30003589,20000523,10000044),(3009921,'Farcon Fitte',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011986,30003590,20000523,10000044),(3009922,'Emmeget Athonise',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011917,30004969,20000727,10000064),(3009923,'Rerlerante Aute',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011920,30004969,20000727,10000064),(3009924,'Bustene Detere',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011935,30004993,20000731,10000064),(3009925,'Essongeria Dhaserulle',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011932,30004994,20000731,10000064),(3009926,'Ophollise Eura',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011938,30004998,20000731,10000064),(3009927,'Bique Darelimes',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011968,30005005,20000732,10000064),(3009928,'Essinan Corlobault',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011974,30005005,20000732,10000064),(3009929,'Bolbaert Ervier',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011971,30005008,20000732,10000064),(3009930,'Azotte Lornache',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011941,30005012,20000733,10000064),(3009931,'Rarcannync Hualeritte',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011944,30005012,20000733,10000064),(3009932,'Essana Crue',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011947,30005014,20000733,10000064),(3009933,'Ennard Famparault',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011965,30005026,20000735,10000064),(3009934,'Ghonvet Edmelles',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011959,30005027,20000735,10000064),(3009935,'Etoure Chaere',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011962,30005027,20000735,10000064),(3009936,'Brune Fallakin',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012004,30004967,20000727,10000064),(3009937,'Asent Arresel',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012034,30002645,20000387,10000032),(3009938,'Municlune Enault',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012031,30002646,20000387,10000032),(3009939,'Aynstie Aulleem',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012037,30002646,20000387,10000032),(3009940,'Esourdaris Adodoure',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012028,30002647,20000387,10000032),(3009941,'Flelirrere Lhuillorelle',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012043,30002663,20000390,10000032),(3009942,'Girmilaere Enault',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012046,30002663,20000390,10000032),(3009943,'Omeres Ralielan',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012040,30002665,20000390,10000032),(3009944,'Kaspette Octiren',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012049,30002666,20000390,10000032),(3009945,'Alebeke Searbene',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012112,30002720,20000398,10000032),(3009946,'Alubbin Achasse',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012118,30002721,20000398,10000032),(3009947,'Gerner Ahrasire',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012121,30002721,20000398,10000032),(3009948,'Olain Bambelard',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012115,30002722,20000398,10000032),(3009949,'Fanason Xalotte',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012061,30003018,20000442,10000037),(3009950,'Autet Therckosiere',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012055,30003020,20000442,10000037),(3009951,'Gitille Agraton',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012058,30003022,20000442,10000037),(3009952,'Tarthelois Davreche',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012052,30003023,20000442,10000037),(3009953,'Odencia Oustrain',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012076,30003578,20000521,10000044),(3009954,'Fomidoorne Esseron',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012079,30003578,20000521,10000044),(3009955,'Miere Inghetoirin',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012082,30003578,20000521,10000044),(3009956,'Galapon Jumarckonchel',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012085,30003578,20000521,10000044),(3009957,'Arnanthyn Balelle',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012016,30003801,20000555,10000048),(3009958,'Yvarie Bubadairpes',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012019,30003801,20000555,10000048),(3009959,'Stie Quellirance',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012025,30003801,20000555,10000048),(3009960,'Amenckbraert Gettenonier',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012022,30003803,20000555,10000048),(3009961,'Mallon Charteau',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012091,30003806,20000556,10000048),(3009962,'Goins Mide',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012088,30003808,20000556,10000048),(3009963,'Fleullare Losschyve',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012094,30003810,20000556,10000048),(3009964,'Sirmiene Claussesnard',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012097,30003810,20000556,10000048),(3009965,'Lancis Aurtin',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012007,30004967,20000727,10000064),(3009966,'Bram Vynneve',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60011920,30004969,20000727,10000064),(3009967,'Acia Coul',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012010,30004970,20000727,10000064),(3009968,'Argnie Masnet',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012067,30005295,20000775,10000068),(3009969,'Aelleem Ferettain',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012070,30005296,20000775,10000068),(3009970,'Ageins Bonailles',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012073,30005296,20000775,10000068),(3009971,'Maullidybel Metlirene',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012064,30005298,20000775,10000068),(3009972,'Auvy Aurch',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012109,30005315,20000778,10000068),(3009973,'Alene Guirmeranes',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012103,30005316,20000778,10000068),(3009974,'Ghyrlelle Aydeguier',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012100,30005317,20000778,10000068),(3009975,'Syrrole Wrumps',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012106,30005317,20000778,10000068),(3009976,'Kobernulf Monnur',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,21,14,21,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012124,30000005,20000001,10000001),(3009977,'Blartulla Eksmon',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,21,14,21,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012127,30000007,20000001,10000001),(3009978,'Ary Olmeke',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,24,16,24,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012154,30000033,20000005,10000001),(3009979,'Siddalard Odhidik',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,24,16,25,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012157,30000034,20000005,10000001),(3009980,'Ilulf Worg',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,27,15,28,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012172,30000040,20000006,10000001),(3009981,'Halbriden Hettad',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,21,14,21,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012175,30000040,20000006,10000001),(3009982,'Ornur Roszurald',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,21,14,21,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012163,30000044,20000007,10000001),(3009983,'Ons Gubeber',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,27,15,28,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012160,30000049,20000007,10000001),(3009984,'Hegnedan Aldelrind',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,24,16,24,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012148,30000059,20000009,10000001),(3009985,'Ealdrekard Tiatesulf',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,21,14,21,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012151,30000069,20000009,10000001),(3009986,'Tarine Jatur',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,21,14,22,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012169,30000072,20000010,10000001),(3009987,'Amukur Wahn',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,21,14,21,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012166,30000075,20000010,10000001),(3009988,'Navittus Sildbena',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,24,16,25,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012145,30000082,20000012,10000001),(3009989,'Ilsur Elda',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,24,16,25,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012142,30000087,20000012,10000001),(3009990,'Notena Jodilur',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,24,16,25,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012178,30000092,20000013,10000001),(3009991,'Oddirsolf Arnur',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,27,15,27,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012181,30000093,20000013,10000001),(3009992,'Ladweisur Aldorim',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,21,14,22,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012136,30000102,20000014,10000001),(3009993,'Sildebetur Aredeborg',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,21,14,22,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012139,30000103,20000014,10000001),(3009994,'Orward Eolmulf',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,21,14,22,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012133,30000107,20000015,10000001),(3009995,'Orkar Arnadi',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,27,15,28,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012130,30000111,20000015,10000001),(3009996,'Tashotsu Verhinila',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012211,30001025,20000150,10000012),(3009997,'Hageken Saasokainen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012187,30001001,20000147,10000012),(3009998,'Wins Allever',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012184,30001006,20000147,10000012),(3009999,'Eitasena Annidhar',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,21,14,21,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012247,30004623,20000674,10000058),(3010000,'Ardarvet Odinier',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012190,30001006,20000147,10000012),(3010001,'Reikka Akatervo',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012196,30001010,20000148,10000012),(3010002,'Menarten Rashagh',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012250,30004618,20000674,10000058),(3010003,'Moiras Olkkena',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012253,30004618,20000674,10000058),(3010004,'Ospold Hjorpauren',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,27,15,27,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012193,30001012,20000148,10000012),(3010005,'Gorn Erpidik',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,27,15,28,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012199,30001015,20000148,10000012),(3010006,'Ardarette Mesbiles',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012202,30001016,20000149,10000012),(3010007,'Ienola Uokio',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012205,30001016,20000149,10000012),(3010008,'Skiadore Kerane',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,27,15,27,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012208,30001018,20000149,10000012),(3010009,'Tourtli Hanoure',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012217,30001022,20000150,10000012),(3010010,'Ria Anbell',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,21,14,21,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012214,30001026,20000150,10000012),(3010011,'Plachotte Ayls',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012220,30001029,20000151,10000012),(3010012,'Pavisailen Kokkumioka',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012226,30001030,20000151,10000012),(3010013,'Salmediad Kanira',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012223,30001031,20000151,10000012),(3010014,'Adens Falet',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012232,30001037,20000152,10000012),(3010015,'Edilkam Silera',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012235,30001041,20000152,10000012),(3010016,'Sirdalada Hantundad',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,27,15,27,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012229,30001042,20000152,10000012),(3010017,'Haca Reliari',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012241,30001044,20000153,10000012),(3010018,'Haderold Vigraluin',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,24,16,25,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012244,30001046,20000153,10000012),(3010019,'Emfant Handriveau',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012238,30001047,20000153,10000012),(3010020,'Songilo Kytitta',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,27,15,28,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012256,30005204,20000761,10000067),(3010021,'Hutnen Iksoi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012295,30000009,20000002,10000001),(3010022,'Uvret Adrallegier',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012304,30000010,20000002,10000001),(3010023,'Itrauan Edeirik',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,27,15,27,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012328,30001380,20000202,10000016),(3010024,'Taitunainen Raun',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012337,30001381,20000202,10000016),(3010025,'Gothan Anas',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012331,30001384,20000202,10000016),(3010026,'Kashokada Shintushairos',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012340,30001384,20000202,10000016),(3010027,'Ambeldere Mittant',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012343,30001384,20000202,10000016),(3010028,'Uuko Pielen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012334,30001385,20000202,10000016),(3010029,'Geld Odling',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,24,16,25,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012457,30002402,20000353,10000028),(3010030,'Nalenzo Kreust',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,24,16,24,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012460,30002402,20000353,10000028),(3010031,'Manzan Ajonar',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012454,30002404,20000353,10000028),(3010032,'Eastig Gurodur',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,24,16,24,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012469,30002404,20000353,10000028),(3010033,'Frirbensdarken Eadwune',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,21,14,21,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012463,30002406,20000353,10000028),(3010034,'Igmulf Herenbeier',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,21,14,21,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012418,30002414,20000355,10000028),(3010035,'Erosund Eurwadur',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,24,16,24,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012430,30002414,20000355,10000028),(3010036,'Pyrvanen Orpiainen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012433,30002414,20000355,10000028),(3010037,'Kaukera Livala',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012421,30002419,20000355,10000028),(3010038,'Valganzo Geittikulf',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,21,14,21,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012424,30002420,20000355,10000028),(3010039,'Martoyou Ioanad',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012427,30002420,20000355,10000028),(3010040,'Wara Totama',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012502,30002724,20000399,10000032),(3010041,'Kilkkuken Mallen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012490,30002725,20000399,10000032),(3010042,'Sau Sefon',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012499,30002725,20000399,10000032),(3010043,'Sisutulf Arvolard',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,27,15,27,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012505,30002726,20000399,10000032),(3010044,'Gatinover Etrinn',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,21,14,22,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012496,30002728,20000399,10000032),(3010045,'Tiet Ebunden',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,27,15,27,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012511,30002762,20000405,10000033),(3010046,'Tera Orpela',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012514,30002762,20000405,10000033),(3010047,'Todgert Soduin',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,24,16,25,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012523,30002763,20000405,10000033),(3010048,'Ariki Ternamaa',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012508,30002764,20000405,10000033),(3010049,'Borjer Hiehti',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012517,30002764,20000405,10000033),(3010050,'Skiatena Lartigen',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,27,15,28,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012520,30002766,20000405,10000033),(3010051,'Skolokuin Honulf',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,24,16,24,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012373,30003057,20000447,10000037),(3010052,'Kivas Odaka',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012367,30003058,20000447,10000037),(3010053,'Jodemund Astuin',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,21,14,22,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012370,30003058,20000447,10000037),(3010054,'Gutanilfur Vengjengit',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,24,16,25,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012379,30003058,20000447,10000037),(3010055,'Aranaga Koshi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012364,30003059,20000447,10000037),(3010056,'Vohi Mafe',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012376,30003061,20000447,10000037),(3010057,'Jomiru Nobina',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012466,30002407,20000353,10000028),(3010058,'Foni Yeeramoun',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012493,30002730,20000399,10000032),(3010059,'Boruet Lhuilon',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012355,30003374,20000492,10000042),(3010060,'Metienan Otou',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012358,30003374,20000492,10000042),(3010061,'Okogairos Jaarashin',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012361,30003374,20000492,10000042),(3010062,'Gabadem Zhikrah',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012346,30003375,20000492,10000042),(3010063,'Moorve Miradama',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012349,30003376,20000492,10000042),(3010064,'Carcanaques Bytaninck',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012352,30003378,20000492,10000042),(3010065,'Eydre Arnanotte',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012286,30003428,20000500,10000042),(3010066,'Kuonamaiken Matsatoh',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012277,30003429,20000500,10000042),(3010067,'Batjunsur Eurtrik',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,27,15,28,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012289,30003430,20000500,10000042),(3010068,'Bish Ponahyai',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012274,30003432,20000500,10000042),(3010069,'Anzillaques Azomiese',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012283,30003432,20000500,10000042),(3010070,'Kagumada Uemiras',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012439,30003818,20000558,10000048),(3010071,'Bemmneke Olilmod',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,27,15,27,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012442,30003818,20000558,10000048),(3010072,'Lola Perame',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012445,30003818,20000558,10000048),(3010073,'Aedalard Armin',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,21,14,21,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012448,30003818,20000558,10000048),(3010074,'Obara Yoemoro',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012451,30003818,20000558,10000048),(3010075,'Mizzerba Jeket',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012436,30003819,20000558,10000048),(3010076,'Ende Ingvalara',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,27,15,28,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012406,30003860,20000564,10000049),(3010077,'Pekkakaanen Teromaki',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012409,30003860,20000564,10000049),(3010078,'Eunon Hey',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012400,30003861,20000564,10000049),(3010079,'Feik Trirtulfruldin',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,24,16,25,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012415,30003861,20000564,10000049),(3010080,'Ohaa Venichino',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012280,30003431,20000500,10000042),(3010081,'Modaze Ganidil',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012403,30003859,20000564,10000049),(3010082,'Bavash Nargika',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012412,30003862,20000564,10000049),(3010083,'Tenemel Mosteve',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012382,30004248,20000622,10000054),(3010084,'Eilbavik Ornhar',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,21,14,22,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012394,30004249,20000622,10000054),(3010085,'Iemola Ueshagi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012391,30004250,20000622,10000054),(3010086,'Hongalar Audurleinn',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,21,14,22,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012385,30004251,20000622,10000054),(3010087,'Sveruvard Smilfdolt',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,27,15,28,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012397,30004251,20000622,10000054),(3010088,'Allain Chrisnelleur',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012388,30004253,20000622,10000054),(3010089,'Gefa Joamma',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012484,30005078,20000743,10000065),(3010090,'Aroshi Tammesaiken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012475,30005080,20000743,10000065),(3010091,'Nerid Thasinaz',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012487,30005080,20000743,10000065),(3010092,'Alakgur Arnmalber',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,24,16,25,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012271,30005204,20000761,10000067),(3010093,'Atad Sosteinn',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,21,14,22,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012472,30005079,20000743,10000065),(3010094,'Emiron Odigron',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,27,15,28,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012478,30005079,20000743,10000065),(3010095,'Iijanairos Oishansen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012481,30005079,20000743,10000065),(3010096,'Shahshin Bourz',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012265,30005198,20000761,10000067),(3010097,'Shikuras Wikevas',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012268,30005200,20000761,10000067),(3010098,'Ventfin Allerdirier',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012259,30005200,20000761,10000067),(3010099,'Henelain Aradoh',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012262,30005206,20000761,10000067),(3010100,'Erazako Steltbulfer',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,27,15,27,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012307,30000010,20000002,10000001),(3010101,'Joshoun Harafa',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012292,30000012,20000002,10000001),(3010102,'Armulf Ozelbreinn',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,24,16,25,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012298,30000014,20000002,10000001),(3010103,'Darwaedur Abeildefder',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,24,16,24,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012301,30000015,20000002,10000001),(3010104,'Arasat Afuan',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012313,30000201,20000029,10000002),(3010105,'Palkiba Jakri',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012322,30000201,20000029,10000002),(3010106,'Onga Adosede',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,27,15,28,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012310,30000202,20000029,10000002),(3010107,'Nievaken Onula',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012316,30000202,20000029,10000002),(3010108,'Agattault Gerleset',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012319,30000202,20000029,10000002),(3010109,'Purodagas Ponto',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012325,30000202,20000029,10000002),(3010110,'Alfroren Agitta',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,21,14,22,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012526,30000001,20000001,10000001),(3010111,'Olgard Krur',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,24,16,25,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012547,30000010,20000002,10000001),(3010112,'Lulmuna Eilirmuald',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,21,14,22,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012541,30000023,20000004,10000001),(3010113,'Ellinald Afagnus',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,24,16,24,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012544,30000032,20000005,10000001),(3010114,'Hendik Golmuald',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,24,16,25,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012535,30000039,20000006,10000001),(3010115,'Imulia Aeduin',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,27,15,27,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012529,30000056,20000008,10000001),(3010116,'Adamegod Krizokil',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,21,14,21,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012532,30000082,20000012,10000001),(3010117,'Baud Alradulf',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,24,16,25,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012538,30000098,20000014,10000001),(3010118,'Beomilar Brettirdur',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,24,16,24,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012553,30000076,20000011,10000001),(3010119,'Avren Atune',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,27,15,28,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012550,30000109,20000015,10000001),(3010120,'Orvyllerier Allerande',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012556,30001290,20000188,10000015),(3010121,'Penchareel Orlede',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012559,30001291,20000188,10000015),(3010122,'Alsinnave Fanason',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012577,30001324,20000193,10000015),(3010123,'Kaikka Peunato',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012574,30001329,20000193,10000015),(3010124,'Olonashi Kommeras',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012568,30001269,20000185,10000015),(3010125,'Assa Ponto',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012571,30001269,20000185,10000015),(3010126,'Jannanette Brunalle',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012565,30001274,20000186,10000015),(3010127,'Vepas Minimala',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012562,30001277,20000186,10000015),(3010128,'Paere Ambelbique',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012583,30004504,20000657,10000057),(3010129,'Dyettilda Isoulphinan',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012586,30004504,20000657,10000057),(3010130,'Bougale Baille',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012589,30004518,20000659,10000057),(3010131,'Arberine Artenne',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012592,30004518,20000659,10000057),(3010132,'Xarcampeau Afroconte',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012595,30001978,20000291,10000023),(3010133,'Toraruni Hroitintur',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,24,16,25,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012715,30000175,20000025,10000002),(3010134,'Onnaja Piri',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012712,30000178,20000025,10000002),(3010135,'Lozdod Pousel',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012667,30000180,20000026,10000002),(3010136,'Ignaman Angidina',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012670,30000185,20000026,10000002),(3010137,'Balmires Agrelins',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012673,30000185,20000026,10000002),(3010138,'Dozales Julake',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012622,30002069,20000305,10000042),(3010139,'Toukareen Anoosh',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012628,30002072,20000305,10000042),(3010140,'Inesmir Jimud',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012652,30003035,20000444,10000037),(3010141,'Jorredel Xalotte',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012724,30002510,20000367,10000030),(3010142,'Ozadol Narionen',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012727,30002510,20000367,10000030),(3010143,'Wettin Adhar',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,21,14,22,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012649,30003031,20000444,10000037),(3010144,'Tuivaseiken Sapala',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012652,30003035,20000444,10000037),(3010145,'Dosson Amailly',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012655,30003037,20000444,10000037),(3010146,'Seintah Panaded',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012631,30003470,20000506,10000042),(3010147,'Evertfage Hefreidik',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,24,16,25,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012634,30003472,20000506,10000042),(3010148,'Arechar Amranin',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012637,30003472,20000506,10000042),(3010149,'Atligner Villousse',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012709,30003473,20000507,10000043),(3010150,'Obanari Yloken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012703,30003475,20000507,10000043),(3010151,'Bimener Manissan',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012706,30003480,20000507,10000043),(3010152,'Essarette Ekay',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012688,30003574,20000521,10000044),(3010153,'Derraucet Espire',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012685,30003575,20000521,10000044),(3010154,'Oijelvas Hahjenavas',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012691,30003578,20000521,10000044),(3010155,'Oishenen Nalvola',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012658,30003604,20000525,10000044),(3010156,'Puon Olkkenen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012661,30003604,20000525,10000044),(3010157,'Verk Favasb',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012664,30003606,20000525,10000044),(3010158,'Espetorre Doussiegnes',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012682,30003807,20000556,10000048),(3010159,'Julckeerame Dalledaury',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012676,30003810,20000556,10000048),(3010160,'Lauld Reinerakin',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,27,15,27,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012679,30003810,20000556,10000048),(3010161,'Junkka Aivuken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012694,30004297,20000628,10000054),(3010162,'Bielaki Siveenna',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012700,30004297,20000628,10000054),(3010163,'Annida Ruokajainen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012697,30004298,20000628,10000054),(3010164,'Uadez Gothan',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012607,30005001,20000732,10000064),(3010165,'Maalna Garkan',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012604,30005007,20000732,10000064),(3010166,'Ishemi Valvas',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012610,30005008,20000732,10000064),(3010167,'Mekamireki Fedas',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012613,30005216,20000763,10000067),(3010168,'Fliet Duleleur',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012616,30005217,20000763,10000067),(3010169,'Eglerin Lina',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012619,30005219,20000763,10000067),(3010170,'Kappas Runjalen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012646,30005269,20000771,10000067),(3010171,'Honoliri Irhi',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012643,30005271,20000771,10000067),(3010172,'Riavo Neliker',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012640,30005272,20000771,10000067),(3010173,'Auranaras Oitvio',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012718,30000173,20000025,10000002),(3010174,'Vove Apyson',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012598,30001977,20000291,10000023),(3010175,'Abnum Josianta',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012601,30001983,20000291,10000023),(3010176,'Kiljavas Yaskasen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012625,30002074,20000305,10000042),(3010177,'Audodart Brunckennac',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012733,30002423,20000356,10000029),(3010178,'Mersinier Attailly',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012739,30005199,20000761,10000067),(3010179,'Atterin Barrie',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012778,30001048,20000153,10000012),(3010180,'Ardia Skolf',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,27,15,27,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012742,30001001,20000147,10000012),(3010181,'Motain Tesschye',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012745,30001002,20000147,10000012),(3010182,'Estur Agdald',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,21,14,22,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012748,30001008,20000148,10000012),(3010183,'Mante Juttotier',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012751,30001014,20000148,10000012),(3010184,'Kuun Vakaara',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012757,30001016,20000149,10000012),(3010185,'Eitu Somo',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012754,30001021,20000149,10000012),(3010186,'Ayng Pawel',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012763,30001026,20000150,10000012),(3010187,'Harlania Armand',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012760,30001027,20000150,10000012),(3010188,'Yomrousi Esarsin',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012766,30001032,20000151,10000012),(3010189,'Eramaid Yomsion',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012769,30001033,20000151,10000012),(3010190,'Sutratger Lurbasgi',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,21,14,22,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012772,30001038,20000152,10000012),(3010191,'Itkeri Shasai',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012775,30001042,20000152,10000012),(3010192,'Sassainen Namon',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012781,30001047,20000153,10000012),(3010193,'Tamabehe Hakesan',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012784,30004619,20000674,10000058),(3010194,'Otsusen Isseras',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012787,30004621,20000674,10000058),(3010195,'Ahremen Arkah',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014943,30004709,20000688,10000060),(3010196,'Hut Itola',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012859,30004623,20000674,10000058),(3010197,'Anen Onilola',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012796,30001002,20000147,10000012),(3010198,'Ashanala Akkipas',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012802,30001002,20000147,10000012),(3010199,'Koshitaija Itonpaa',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012799,30001005,20000147,10000012),(3010200,'Okawari Oisi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012805,30001012,20000148,10000012),(3010201,'Tuihtamon Iwamela',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012808,30001012,20000148,10000012),(3010202,'Tokkitainen Ansoken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012811,30001012,20000148,10000012),(3010203,'Rohmunji Arhu',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012814,30001016,20000149,10000012),(3010204,'Arma Nornen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012817,30001016,20000149,10000012),(3010205,'Fukkuliala Aako',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012820,30001016,20000149,10000012),(3010206,'Saura Torochi',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012829,30001025,20000150,10000012),(3010207,'Matsatoh Okamaa',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012823,30001026,20000150,10000012),(3010208,'Kakkiainen Okokka',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012826,30001026,20000150,10000012),(3010209,'Plotola Auki',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012835,30001030,20000151,10000012),(3010210,'Kurmanen Ienola',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012832,30001033,20000151,10000012),(3010211,'Paatsosen Hara',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012838,30001034,20000151,10000012),(3010212,'Shin Koikas',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012841,30001038,20000152,10000012),(3010213,'Kuumenaakko Liksen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012844,30001042,20000152,10000012),(3010214,'Paukonsuo Ihoya',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012847,30001042,20000152,10000012),(3010215,'Raikanen Uehiro',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012850,30001045,20000153,10000012),(3010216,'Solula Sizawa',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012853,30001045,20000153,10000012),(3010217,'Haakari Renta',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012856,30001046,20000153,10000012),(3010218,'Uesi Irei',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012862,30004619,20000674,10000058),(3010219,'Asine Hitama',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012865,30004621,20000674,10000058),(3010220,'Amuene Mollalier',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012910,30004617,20000674,10000058),(3010221,'Ochirel Tadhqin',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012868,30001001,20000147,10000012),(3010222,'Aloongeves Ambelane',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012871,30001003,20000147,10000012),(3010223,'Brynn Jerdola',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012874,30001010,20000148,10000012),(3010224,'Gezmi Ribnirk',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012877,30001012,20000148,10000012),(3010225,'Ogmer Uttold',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,24,16,24,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012880,30001016,20000149,10000012),(3010226,'Ancholer Cochargeins',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012883,30001018,20000149,10000012),(3010227,'Eleldgrilfur Erada',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,27,15,27,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012886,30001024,20000150,10000012),(3010228,'Uetuka Vekasmukka',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012889,30001025,20000150,10000012),(3010229,'Orartault Uphanel',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012892,30001033,20000151,10000012),(3010230,'Cormack Vaaja',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012895,30001033,20000151,10000012),(3010231,'Unenailen Aaranen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012898,30001041,20000152,10000012),(3010232,'Agasid Aulin',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012901,30001043,20000152,10000012),(3010233,'Setele Schellan',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012907,30001044,20000153,10000012),(3010234,'Tzira Chankinu',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012904,30001048,20000153,10000012),(3010235,'Kangegod Eindrerold',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,24,16,24,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012913,30004617,20000674,10000058),(3010236,'Dihyat Jabounahr',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012916,30005204,20000761,10000067),(3010237,'Euralfage Todsildus',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,24,16,24,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013027,30000024,20000004,10000001),(3010238,'Aveau Datchenese',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013030,30000025,20000004,10000001),(3010239,'Harvingur Gerremur',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,21,14,22,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013024,30000030,20000004,10000001),(3010240,'Sart Ollgur',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,24,16,25,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012949,30000051,20000008,10000001),(3010241,'Irpara Sigathim',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012943,30000052,20000008,10000001),(3010242,'Eigar Okirsder',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,27,15,28,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012946,30000052,20000008,10000001),(3010243,'Ferbhy Nara',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013012,30000084,20000012,10000001),(3010244,'Kenare Jurrechant',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013006,30000087,20000012,10000001),(3010245,'Hajokka Ati',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013009,30000087,20000012,10000001),(3010246,'Adarald Ugge',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,24,16,25,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013042,30000202,20000029,10000002),(3010247,'Imota Sanoya',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013048,30000202,20000029,10000002),(3010248,'Jeman Khegbakish',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013045,30000205,20000029,10000002),(3010249,'Jumaisha Sicongabafa',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013033,30001644,20000243,10000020),(3010250,'Mouraya Ankadan',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013036,30001644,20000243,10000020),(3010251,'Asinar Nazta',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013039,30001646,20000243,10000020),(3010252,'Maekima Tsujeri',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012982,30001669,20000247,10000020),(3010253,'Eves Obarmant',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012985,30001671,20000247,10000020),(3010254,'Julgerting Hvagasand',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,21,14,21,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012979,30001674,20000247,10000020),(3010255,'Takanen Tuoranen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012964,30001689,20000250,10000020),(3010256,'End Baltera',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,21,14,22,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012967,30001690,20000250,10000020),(3010257,'Rahadalon Nokimur',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012961,30001693,20000250,10000020),(3010258,'Hadakan Sisi',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012970,30002060,20000304,10000042),(3010259,'Fegh Aviantal',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012976,30002062,20000304,10000042),(3010260,'Charan Shebula',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012973,30002065,20000304,10000042),(3010261,'Ikalainen Onnola',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012937,30002242,20000329,10000043),(3010262,'Redmereau Jaelaerdt',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012940,30002246,20000329,10000043),(3010263,'Birt Estenieves',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012934,30002249,20000329,10000043),(3010264,'Irosa Neriadams',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012958,30002259,20000331,10000043),(3010265,'Yomsion Azen',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012952,30002260,20000331,10000043),(3010266,'Ohamon Inkinen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012955,30002262,20000331,10000043),(3010267,'Kentz Ekonori',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,27,15,28,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013003,30004280,20000626,10000054),(3010268,'Haram Goskaktar',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,27,15,28,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013000,30004281,20000626,10000054),(3010269,'Knutedder Aborin',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,21,14,21,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012997,30004284,20000626,10000054),(3010270,'Ishiras Kiniruta',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013015,30005069,20000742,10000065),(3010271,'Petsiken Ichosira',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013018,30005069,20000742,10000065),(3010272,'Jaasinen Ohinila',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013021,30005069,20000742,10000065),(3010273,'Etamala Handa',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012922,30005204,20000761,10000067),(3010274,'Omilfgasi Anninar',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,27,15,28,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012919,30005205,20000761,10000067),(3010275,'Anchel Lanenier',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012994,30005315,20000778,10000068),(3010276,'Tantoseisen Kakkichi',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012988,30005319,20000778,10000068),(3010277,'Hamunala Rairos',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012991,30005319,20000778,10000068),(3010278,'Octiclene Sinille',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012931,30005322,20000779,10000068),(3010279,'Ikansur Haenobiber',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,27,15,27,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012925,30005323,20000779,10000068),(3010280,'Zomili Mabahian',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60012928,30005328,20000779,10000068),(3010281,'Afrire Arbattolie',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013069,30001045,20000153,10000012),(3010282,'Tobias Kruzhor',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013051,30001002,20000147,10000012),(3010283,'Gotan Kreiss',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013054,30001013,20000148,10000012),(3010284,'Wedrel Strollant',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013057,30001021,20000149,10000012),(3010285,'Meild Sond',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,27,15,28,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013060,30001026,20000150,10000012),(3010286,'Dankar Efnart',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,24,16,24,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013063,30001032,20000151,10000012),(3010287,'Mizuro Cybon',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013066,30001038,20000152,10000012),(3010288,'Rilesen Duihlin',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,21,14,21,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013072,30004621,20000674,10000058),(3010289,'Arenur Hroitintur',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,27,15,28,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013078,30001983,20000291,10000023),(3010290,'Stold Gidmuger',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013081,30001484,20000218,10000017),(3010291,'Tolavudar Rurlufini',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013147,30000189,20000027,10000002),(3010292,'Evoom Ostosh',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013222,30003811,20000556,10000048),(3010293,'Oilja Aljus',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013162,30004297,20000628,10000054),(3010294,'Clans Sunnac',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013153,30004298,20000628,10000054),(3010295,'Amuelloris Ronchelin',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,24,16,24,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013159,30004299,20000628,10000054),(3010296,'Ettold Arga',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013156,30004300,20000628,10000054),(3010297,'Brastame Aroche',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013117,30005208,20000762,10000067),(3010298,'Uimomaitoh Sahtogas',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013123,30005209,20000762,10000067),(3010299,'Thonielan Gallusiene',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,21,14,21,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013126,30005211,20000762,10000067),(3010300,'Riltulla Reswora',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013120,30005212,20000762,10000067),(3010301,'Gunesulf Ateken',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013150,30000190,20000027,10000002),(3010302,'Funaila Asomato',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013144,30000193,20000027,10000002),(3010303,'Clout Kuers',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,27,15,27,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013141,30000194,20000027,10000002),(3010304,'Ieras Peittaakko',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013105,30001368,20000200,10000016),(3010305,'Yifan Sabiva',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013108,30001369,20000200,10000016),(3010306,'Shoranes Heeraz',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,21,14,22,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013111,30001371,20000200,10000016),(3010307,'Mataria Ekta',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013114,30001373,20000200,10000016),(3010308,'Molleur Delmeranten',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013180,30001418,20000208,10000016),(3010309,'Ohmantumaa Punkyoemon',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,24,16,24,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013186,30001419,20000208,10000016),(3010310,'Oluchilan Vlecht',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013177,30001422,20000208,10000016),(3010311,'Tuulonen Haikenaras',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013183,30001423,20000208,10000016),(3010312,'Skjor Rormodik',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,24,16,25,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013204,30001437,20000211,10000016),(3010313,'Shinsema Cherislam',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013210,30001437,20000211,10000016),(3010314,'Uldizo Agmur',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013207,30001438,20000211,10000016),(3010315,'Waretta Agand',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,24,16,24,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013201,30001441,20000211,10000016),(3010316,'Pon Ruumi',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,21,14,21,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013084,30001484,20000218,10000017),(3010317,'Furmint Akaza',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013087,30001485,20000218,10000017),(3010318,'Pourdiac Abbaert',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013090,30001485,20000218,10000017),(3010319,'Annakku Kuola',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013129,30001682,20000249,10000020),(3010320,'Kalbilur Wamimber',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013132,30001682,20000249,10000020),(3010321,'Snahna Rifa',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013138,30001685,20000249,10000020),(3010322,'Haltz Uistard',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013135,30001686,20000249,10000020),(3010323,'Nilinaiken Korika',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013168,30001708,20000253,10000020),(3010324,'Sasento Jovvakko',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,21,14,22,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013171,30001708,20000253,10000020),(3010325,'Hayabier Akezen',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013174,30001712,20000253,10000020),(3010326,'Komora Uniainenin',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013165,30001713,20000253,10000020),(3010327,'Nein Moradur',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013237,30002090,20000308,10000042),(3010328,'Winako Akold',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013246,30002093,20000308,10000042),(3010329,'Oksanas Ieyoshadan',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013240,30002093,20000308,10000042),(3010330,'Polarala Opiai',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013243,30002095,20000308,10000042),(3010331,'Jammalgen Rekurdan',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013234,30002571,20000377,10000030),(3010332,'Alasore Gesevieve',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013231,30002572,20000377,10000030),(3010333,'Ardalainer Gemarche',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013225,30002573,20000377,10000030),(3010334,'Witolf Ellulf',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,24,16,24,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013228,30002573,20000377,10000030),(3010335,'Dagiker Warhemmo',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013195,30002762,20000405,10000033),(3010336,'Eitar Karkirdard',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013192,30002763,20000405,10000033),(3010337,'Absaned Upat',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013189,30002766,20000405,10000033),(3010338,'Wimander Geridal',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013198,30002766,20000405,10000033),(3010339,'Atens Karson',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013252,30002769,20000406,10000033),(3010340,'Hedelbert Aldrat',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013258,30002771,20000406,10000033),(3010341,'Sini Hadonoo',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,24,16,25,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013255,30002772,20000406,10000033),(3010342,'Attek Eurkulf',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013249,30002774,20000406,10000033),(3010343,'Autinen Ahitoh',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,21,14,22,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013102,30003071,20000449,10000038),(3010344,'Inolala Uchinuda',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,24,16,25,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013096,30003074,20000449,10000038),(3010345,'Armotte Begninck',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013099,30003077,20000449,10000038),(3010346,'Palark Bashkive',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013093,30003078,20000449,10000038),(3010347,'Pesteya Ziraze',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,21,14,21,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013213,30003808,20000556,10000048),(3010348,'Obavette Locherghen',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013219,30003808,20000556,10000048),(3010349,'Hyononeki Armon',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,21,14,21,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013216,30003810,20000556,10000048),(3010350,'Ichinita Kuunkumala',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013261,30001290,20000188,10000015),(3010351,'Deta Nithi',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013264,30001481,20000218,10000017),(3010352,'Kykeshi Shais',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,24,16,25,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013291,30000182,20000026,10000002),(3010353,'Erkamainen Ravuo',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013288,30000185,20000026,10000002),(3010354,'Paaralen Sotiro',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013267,30001485,20000218,10000017),(3010355,'Dasiosa Toumi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013345,30001681,20000249,10000020),(3010356,'Barma Eltis',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013342,30001685,20000249,10000020),(3010357,'Fanere Voespant',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,24,16,24,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013294,30002270,20000333,10000043),(3010358,'Anttiken Itila',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013297,30002275,20000333,10000043),(3010359,'Sanumo Sumomada',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,27,15,27,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013321,30002412,20000354,10000028),(3010360,'Kanin Yedaph',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013318,30002413,20000354,10000028),(3010361,'Oguras Eskanen',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013309,30002574,20000378,10000030),(3010362,'Yinuru Enolachah',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,27,15,27,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013306,30002578,20000378,10000030),(3010363,'Asahal Eradana',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,21,14,22,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013324,30002672,20000391,10000032),(3010364,'Eurmana Engerstar',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013327,30002672,20000391,10000032),(3010365,'Tacalu Myri',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013303,30002724,20000399,10000032),(3010366,'Kinkyonen Hashinouras',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,24,16,25,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013300,30002725,20000399,10000032),(3010367,'Uhis Houb',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013282,30003048,20000446,10000037),(3010368,'Leigukelm Iddold',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013285,30003052,20000446,10000037),(3010369,'Siliker Svagnegnot',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,21,14,21,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013273,30003423,20000499,10000042),(3010370,'Halfgar Orsur',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013270,30003427,20000499,10000042),(3010371,'Manarainen Rotta',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,21,14,22,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013351,30003568,20000520,10000044),(3010372,'Hihrin Afazin',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,24,16,24,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013348,30003572,20000520,10000044),(3010373,'Alenour Akosmoud',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013330,30003794,20000554,10000048),(3010374,'Achoghu Choosha',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,27,15,27,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013333,30003794,20000554,10000048),(3010375,'Kuharah Abral',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013336,30003818,20000558,10000048),(3010376,'Jabhi Tehnud',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,27,15,28,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013339,30003818,20000558,10000048),(3010377,'Kemini Astastez',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013312,30004273,20000625,10000054),(3010378,'Avonon Lasire',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,27,15,27,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013315,30004275,20000625,10000054),(3010379,'Aetrald Ravensdad',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,21,14,22,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013276,30005084,20000744,10000065),(3010380,'Amirker Analven',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,21,14,21,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013279,30005084,20000744,10000065),(3010381,'Hoostemiron Allane',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013357,30003274,20000478,10000041),(3010382,'Muteltaine Autrou',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013360,30003276,20000478,10000041),(3010383,'Fusbenne Attens',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013363,30003289,20000480,10000041),(3010384,'Mesybier Echard',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013366,30003289,20000480,10000041),(3010385,'Chattinck Lalycer',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013369,30003323,20000484,10000041),(3010386,'Aranza Seyron',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013372,30003323,20000484,10000041),(3010387,'Benvodis Androy',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013375,30003344,20000487,10000041),(3010388,'Vepithou Bekkyere',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013378,30003345,20000487,10000041),(3010389,'Anais Montvlyrtier',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013381,30003269,20000478,10000041),(3010390,'Aspant Sairuttire',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013384,30003278,20000478,10000041),(3010391,'Venere Tolle',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013387,30003286,20000480,10000041),(3010392,'Fluekele Arrodet',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013390,30003286,20000480,10000041),(3010393,'Daeritte Yvegot',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013393,30003314,20000483,10000041),(3010394,'Soeilenuse Cempescain',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013396,30003318,20000483,10000041),(3010395,'Sadereron Tande',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013399,30003369,20000491,10000041),(3010396,'Buin Archyrseult',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013402,30003373,20000491,10000041),(3010397,'Elacan Artalin',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013405,30003271,20000478,10000041),(3010398,'Avoralie Cente',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013408,30003276,20000478,10000041),(3010399,'Ivorchaert Brawette',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013417,30003287,20000480,10000041),(3010400,'Sogeria Ronchelin',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013420,30003289,20000480,10000041),(3010401,'Janeille Esteller',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013441,30003294,20000481,10000041),(3010402,'Planeris Balyu',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013444,30003297,20000481,10000041),(3010403,'Autlue Dissel',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013411,30003311,20000483,10000041),(3010404,'Allolins Odalanne',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013414,30003317,20000483,10000041),(3010405,'Aubulle Sougnieurck',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013462,30003327,20000485,10000041),(3010406,'Pasitte Essarette',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013459,30003330,20000485,10000041),(3010407,'Geripiette Ergiers',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013435,30003338,20000486,10000041),(3010408,'Gidrine Slassulle',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013438,30003339,20000486,10000041),(3010409,'Railloux Saonellympe',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013453,30003342,20000487,10000041),(3010410,'Ailer Heydieles',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013456,30003343,20000487,10000041),(3010411,'Brouneva Daria',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013426,30003350,20000488,10000041),(3010412,'Ancaunnouge Alillon',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013423,30003353,20000488,10000041),(3010413,'Timsieuwe Weyllaenalle',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013429,30003355,20000489,10000041),(3010414,'Doufecteau Pettinck',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013432,30003360,20000489,10000041),(3010415,'Cosson Amarancke',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013447,30003368,20000491,10000041),(3010416,'Moledune Hevinivis',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013450,30003373,20000491,10000041),(3010417,'Espirose Andreditte',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013465,30003271,20000478,10000041),(3010418,'Dursatsins Thirsier',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013468,30003275,20000478,10000041),(3010419,'Fre Soulobert',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013471,30003279,20000478,10000041),(3010420,'Arnanare Anchel',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013549,30003280,20000479,10000041),(3010421,'Vediere Baider',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013552,30003281,20000479,10000041),(3010422,'Rourts Lanercheve',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013546,30003284,20000479,10000041),(3010423,'Edmanan Vattaux',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013519,30003287,20000480,10000041),(3010424,'Bemps Latault',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013522,30003287,20000480,10000041),(3010425,'Aurmia Cariot',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013525,30003287,20000480,10000041),(3010426,'Rhoun Attens',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013492,30003305,20000482,10000041),(3010427,'Emeersch Georreroron',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013495,30003305,20000482,10000041),(3010428,'Wissier Isschau',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013498,30003307,20000482,10000041),(3010429,'Indregulle Mabenere',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013540,30003312,20000483,10000041),(3010430,'Ertlie Gere',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013537,30003317,20000483,10000041),(3010431,'Biessche Cienc',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013543,30003318,20000483,10000041),(3010432,'Chamaert Oillard',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013534,30003321,20000484,10000041),(3010433,'Hedarilot Faurent',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013531,30003322,20000484,10000041),(3010434,'Agrelins Odene',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013528,30003324,20000484,10000041),(3010435,'Ancemel Baliaerdt',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013489,30003329,20000485,10000041),(3010436,'Gilalis Vastinck',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013483,30003333,20000485,10000041),(3010437,'Noutte Cauvers',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013486,30003335,20000485,10000041),(3010438,'Rhin Dovaille',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013474,30003338,20000486,10000041),(3010439,'Heneque Mornodire',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013480,30003338,20000486,10000041),(3010440,'Prerebot Husel',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013477,30003339,20000486,10000041),(3010441,'Mavalle Annennire',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013510,30003342,20000487,10000041),(3010442,'Ahroillaine Erion',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013513,30003344,20000487,10000041),(3010443,'Antonede Alst',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013516,30003344,20000487,10000041),(3010444,'Amytier Lallateblan',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013504,30003361,20000490,10000041),(3010445,'Karontrunger Yvavenis',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013501,30003363,20000490,10000041),(3010446,'Dhanders Failanard',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013507,30003363,20000490,10000041),(3010447,'Malirscoure Antgy',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,27,15,27,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013555,30001480,20000218,10000017),(3010448,'Peydeh Ebneloum',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,24,16,25,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013600,30001453,20000213,10000017),(3010449,'Outa Jusen',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013603,30001453,20000213,10000017),(3010450,'Skiasten Bonerand',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,27,15,27,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013558,30001480,20000218,10000017),(3010451,'Tzotrek Paraden',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013561,30001480,20000218,10000017),(3010452,'Tjor Pidgur',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,24,16,24,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013579,30001499,20000220,10000017),(3010453,'Penille Amalene',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013630,30001507,20000222,10000017),(3010454,'Ornljer Vannokard',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013627,30001508,20000222,10000017),(3010455,'Tona Arativim',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013633,30001508,20000222,10000017),(3010456,'Suisonakka Okilen',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013591,30001524,20000224,10000017),(3010457,'Litaka Hagas',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013609,30001603,20000236,10000019),(3010458,'Cobelle Onet',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013612,30001603,20000236,10000019),(3010459,'Huren Juld',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013588,30001628,20000240,10000019),(3010460,'Yonkkamon Kuro',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,24,16,25,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013564,30001631,20000241,10000019),(3010461,'Osmaystaere Tattonaert',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013570,30001632,20000241,10000019),(3010462,'Palmaa Rinkalen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013567,30001633,20000241,10000019),(3010463,'Jepa Rerana',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,27,15,27,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013636,30001643,20000242,10000019),(3010464,'Hayls Cantchrefrier',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013606,30001449,20000213,10000017),(3010465,'Riruna Anrus',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013573,30001492,20000220,10000017),(3010466,'Enkold Knilf',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013576,30001496,20000220,10000017),(3010467,'Annitidwik Engvi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013621,30001513,20000223,10000017),(3010468,'Dach Jarathofa',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013618,30001514,20000223,10000017),(3010469,'Eidard Vakulur',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013624,30001515,20000223,10000017),(3010470,'Arondsur Bakolinzo',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013597,30001518,20000224,10000017),(3010471,'Nuo Lien',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,21,14,21,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013594,30001519,20000224,10000017),(3010472,'Tantaiken Elonen',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,21,14,22,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013615,30001600,20000236,10000019),(3010473,'Yatarder Siharkhail',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013582,30001624,20000240,10000019),(3010474,'Visatoh Iepi',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013585,30001629,20000240,10000019),(3010475,'Areru Areh',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,27,15,27,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013639,30001637,20000242,10000019),(3010476,'Dubesune Egheyns',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,24,16,24,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013642,30001638,20000242,10000019),(3010477,'Okolen Rauranmaa',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,27,15,28,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013645,30001480,20000218,10000017),(3010478,'Chaere Jeart',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013654,30001480,20000218,10000017),(3010479,'Totrana Muttokon',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013660,30001480,20000218,10000017),(3010480,'Lugannald Ameinko',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013657,30001481,20000218,10000017),(3010481,'Abazeluc Cameruet',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013648,30001483,20000218,10000017),(3010482,'Hiemalen Ahorakka',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,21,14,21,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013651,30001483,20000218,10000017),(3010483,'Yvevet Atlertolier',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013699,30001487,20000219,10000017),(3010484,'Fernur Heteder',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013702,30001487,20000219,10000017),(3010485,'Luveinodi Elbaud',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013708,30001487,20000219,10000017),(3010486,'Jonagulf Eslan',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013711,30001488,20000219,10000017),(3010487,'Konjus Okolen',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013714,30001489,20000219,10000017),(3010488,'Tean Dennesene',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,27,15,27,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013705,30001490,20000219,10000017),(3010489,'Ualdiran Fedetrist',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013789,30001496,20000220,10000017),(3010490,'Sonyaken Ukechi',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013801,30001496,20000220,10000017),(3010491,'Wlfharn Erorbert',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,21,14,22,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013795,30001497,20000220,10000017),(3010492,'Armah Bagharoo',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013792,30001499,20000220,10000017),(3010493,'Immarenen Aiga',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013798,30001499,20000220,10000017),(3010494,'Zenki Hangond',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,21,14,21,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013804,30001499,20000220,10000017),(3010495,'Hakatiz Gantalan',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013807,30001500,20000221,10000017),(3010496,'Ingirden Geik',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013813,30001501,20000221,10000017),(3010497,'Aghirya Erul',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013816,30001502,20000221,10000017),(3010498,'Geltokur Kolldur',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,27,15,28,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013819,30001502,20000221,10000017),(3010499,'Olanzo Gogefren',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013810,30001503,20000221,10000017),(3010500,'Haisuras Tonkiainen',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,24,16,24,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013822,30001503,20000221,10000017),(3010501,'Myennitte Laldellins',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013717,30001518,20000224,10000017),(3010502,'Aikelwalo Sodalrat',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013723,30001518,20000224,10000017),(3010503,'Muellairault Ivaere',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013729,30001521,20000224,10000017),(3010504,'Melnih Masara',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,27,15,27,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013720,30001524,20000224,10000017),(3010505,'Alikatsen Kunkkenen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013726,30001524,20000224,10000017),(3010506,'Brulle Heluene',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013732,30001525,20000224,10000017),(3010507,'Mitte Archone',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013780,30001604,20000237,10000019),(3010508,'Urid Aetar',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,21,14,21,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013774,30001607,20000237,10000019),(3010509,'Vlandsontal Caunnie',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013783,30001607,20000237,10000019),(3010510,'Yobnasa Sehrnaz',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013771,30001608,20000237,10000019),(3010511,'Nadsa Zimse',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,21,14,22,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013777,30001608,20000237,10000019),(3010512,'Annel Kjaend',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013786,30001609,20000237,10000019),(3010513,'Kera Ashida',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013738,30001611,20000238,10000019),(3010514,'Muyumuja Ishabara',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013750,30001611,20000238,10000019),(3010515,'Gosha Pouna',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013735,30001613,20000238,10000019),(3010516,'Aranakka Ruukin',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013747,30001615,20000238,10000019),(3010517,'Otuo Mivora',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,21,14,22,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013741,30001616,20000238,10000019),(3010518,'Inaari Tasvas',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,24,16,24,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013744,30001616,20000238,10000019),(3010519,'Uviai Iralen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013759,30001624,20000240,10000019),(3010520,'Ladonssund Ohtagur',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013762,30001624,20000240,10000019),(3010521,'Hamoushekh Khass',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013765,30001626,20000240,10000019),(3010522,'Sisala Thouni',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013756,30001627,20000240,10000019),(3010523,'Zake Zesia',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013753,30001629,20000240,10000019),(3010524,'Ruolanen Pietela',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013768,30001630,20000240,10000019),(3010525,'Ittoh Okonda',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,24,16,25,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013681,30001631,20000241,10000019),(3010526,'Borgind Pom',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013687,30001631,20000241,10000019),(3010527,'Harnhandar Suid',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,27,15,28,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013693,30001631,20000241,10000019),(3010528,'Ludbiko Godetur',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013696,30001631,20000241,10000019),(3010529,'Kalmaran Dophar',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,21,14,21,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013684,30001632,20000241,10000019),(3010530,'Benencel Crielere',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013690,30001633,20000241,10000019),(3010531,'Bunya Hatsu',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013666,30001637,20000242,10000019),(3010532,'Romene Iseladie',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013672,30001637,20000242,10000019),(3010533,'Hallur Ingabert',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013678,30001638,20000242,10000019),(3010534,'Eldgrekis Atren',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013663,30001639,20000242,10000019),(3010535,'Tadakeh Souredan',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013675,30001639,20000242,10000019),(3010536,'Ornenel Encbe',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013669,30001643,20000242,10000019),(3010537,'Shes Saal',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013828,30003863,20000564,10000049),(3010538,'Navai Nayot',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013837,30003873,20000565,10000049),(3010539,'Khudiga Omas',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013840,30003879,20000566,10000049),(3010540,'Tona Hasal',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013855,30003890,20000568,10000049),(3010541,'Kiusa Temasi',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013843,30003908,20000570,10000049),(3010542,'Eqi Arataragh',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013849,30003912,20000571,10000049),(3010543,'Araniad Ashwan',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013846,30003928,20000573,10000049),(3010544,'Oyu Hielia',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013831,30003922,20000572,10000049),(3010545,'Anuf Buse',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013852,30003933,20000574,10000049),(3010546,'Kekah Votchehmal',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013834,30003939,20000575,10000049),(3010547,'Winsako Estram',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,27,15,27,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013861,30000007,20000001,10000001),(3010548,'Wirurad Ankgur',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,21,14,21,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013867,30000019,20000003,10000001),(3010549,'Trangvatold Notelm',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,24,16,24,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013870,30000037,20000005,10000001),(3010550,'Aelar Angils',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,27,15,27,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013864,30000098,20000014,10000001),(3010551,'Bomerin Anteres',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013873,30001480,20000218,10000017),(3010552,'Saranami Aarnanen',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013891,30001462,20000215,10000017),(3010553,'Kakur Evollolf',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013894,30001463,20000215,10000017),(3010554,'Boutte Isolette',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013921,30001473,20000217,10000017),(3010555,'Ladooda Oshnu',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,21,14,21,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013924,30001478,20000217,10000017),(3010556,'Iivanamon Okagairos',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,27,15,28,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013876,30001480,20000218,10000017),(3010557,'Shiraski Pie',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013909,30001505,20000221,10000017),(3010558,'Muvolailen Uchono',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013912,30001505,20000221,10000017),(3010559,'Valen Kingato',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,21,14,21,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013888,30001519,20000224,10000017),(3010560,'Idomon Otnen',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013885,30001521,20000224,10000017),(3010561,'Setamana Helvas',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013897,30001599,20000236,10000019),(3010562,'Borokle Teodasen',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013900,30001603,20000236,10000019),(3010563,'Wlfreier Ongrold',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013879,30001607,20000237,10000019),(3010564,'Nipoukandeh Chirire',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013882,30001608,20000237,10000019),(3010565,'Aertelm Gudelbod',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013927,30001611,20000238,10000019),(3010566,'Ohtrik Energur',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013930,30001617,20000238,10000019),(3010567,'Bavilen Kheen',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013918,30001625,20000240,10000019),(3010568,'Oirtio Sabaneushi',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,21,14,21,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013915,30001628,20000240,10000019),(3010569,'Gufrolf Wibrahard',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013906,30001640,20000242,10000019),(3010570,'Norazan Ifsan',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013903,30001642,20000242,10000019),(3010571,'Namater Abereta',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013933,30003860,20000564,10000049),(3010572,'Umid Ashain',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013936,30003860,20000564,10000049),(3010573,'Momabah Pindan',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013975,30003878,20000566,10000049),(3010574,'Errava Mareyi',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013978,30003878,20000566,10000049),(3010575,'Sineru Yamedar',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013981,30003888,20000568,10000049),(3010576,'Toyosha Garana',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013984,30003888,20000568,10000049),(3010577,'Uhria Sigis',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013990,30003897,20000569,10000049),(3010578,'Aphah Jadata',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013987,30003899,20000569,10000049),(3010579,'Abrikoum Aman',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013960,30003905,20000570,10000049),(3010580,'Merades Rothen',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013957,30003909,20000570,10000049),(3010581,'Baid Bammohy',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013951,30003912,20000571,10000049),(3010582,'Naladon Falie',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013954,30003912,20000571,10000049),(3010583,'Mengol Taral',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013969,30003920,20000572,10000049),(3010584,'Khifomek Cheshamah',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013972,30003921,20000572,10000049),(3010585,'Hohli Bokarrad',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013966,30003923,20000573,10000049),(3010586,'Rarami Asaphasa',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013963,30003926,20000573,10000049),(3010587,'Shimag Ralnamun',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013948,30003930,20000574,10000049),(3010588,'Okarema Nefra',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013945,30003935,20000574,10000049),(3010589,'Demen Khooznan',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013939,30003939,20000575,10000049),(3010590,'Meor Varuna',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013942,30003939,20000575,10000049),(3010591,'Voura Situnen',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,21,14,22,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013996,30001481,20000218,10000017),(3010592,'Kojosiya Inaya',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014023,30001449,20000213,10000017),(3010593,'Agiddlellur Askandsolhar',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,24,16,24,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014020,30001452,20000213,10000017),(3010594,'Elason Bulnellieu',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014029,30001469,20000216,10000017),(3010595,'Ortur Abbaber',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014026,30001470,20000216,10000017),(3010596,'Osskur Kilfdag',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60013999,30001480,20000218,10000017),(3010597,'Dommund Sogfelur',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014014,30001500,20000221,10000017),(3010598,'Abail Pohla',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014017,30001501,20000221,10000017),(3010599,'Kaveidur Gebroled',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014038,30001507,20000222,10000017),(3010600,'Koikoriki Omae',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014041,30001507,20000222,10000017),(3010601,'Karras Ikerino',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014002,30001513,20000223,10000017),(3010602,'Kezine Bassi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014005,30001515,20000223,10000017),(3010603,'Thayafu Adarya',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,27,15,28,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014032,30001599,20000236,10000019),(3010604,'Maeed Azzed',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014035,30001602,20000236,10000019),(3010605,'Jesahek Psaken',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014044,30001611,20000238,10000019),(3010606,'Khnos Osas',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014047,30001611,20000238,10000019),(3010607,'Feryi Jennim',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014008,30001628,20000240,10000019),(3010608,'Yoomah Yenthera',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,21,14,21,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014011,30001628,20000240,10000019),(3010609,'Aurore Beyne',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014050,30001640,20000242,10000019),(3010610,'Vavene Orlodalle',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014053,30001641,20000242,10000019),(3010611,'Teurodedik Eodlan',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,24,16,25,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014059,30000905,20000132,10000011),(3010612,'Saerdald Oblikkur',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,24,16,24,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014071,30000017,20000003,10000001),(3010613,'Riluko Esbjavik',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,21,14,21,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014074,30000017,20000003,10000001),(3010614,'Alfrulf Adinagitta',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,27,15,28,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014095,30000040,20000006,10000001),(3010615,'Kidakaestur Isangrede',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,24,16,25,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014098,30000041,20000006,10000001),(3010616,'Freakmikar Fomanko',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,24,16,24,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014137,30000053,20000008,10000001),(3010617,'Anondik Sorogur',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,24,16,25,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014140,30000055,20000008,10000001),(3010618,'Askilhar Hreurn',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,21,14,22,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014068,30000072,20000010,10000001),(3010619,'Hog Hakeonari',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,24,16,24,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014065,30000074,20000010,10000001),(3010620,'Mannekar Daleder',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,24,16,24,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014062,30000903,20000132,10000011),(3010621,'Matilhelm Bodadur',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,24,16,24,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014134,30002058,20000303,10000042),(3010622,'Onabemur Attar',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,27,15,27,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014131,30002059,20000303,10000042),(3010623,'Alfrald Enstulf',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,21,14,22,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014143,30002065,20000304,10000042),(3010624,'Eladizo Ansfriken',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,27,15,28,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014146,30002067,20000304,10000042),(3010625,'Knuginzo Jeritta',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,27,15,27,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014110,30002571,20000377,10000030),(3010626,'Adela Eskavert',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,24,16,24,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014107,30002572,20000377,10000030),(3010627,'Eadled Edo',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,21,14,22,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014092,30003281,20000479,10000041),(3010628,'Elmwo Askelef',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,24,16,25,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014089,30003283,20000479,10000041),(3010629,'Aruko Villakard',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,24,16,24,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014122,30003329,20000485,10000041),(3010630,'Friss Asreva',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,21,14,21,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014119,30003333,20000485,10000041),(3010631,'Vudobrauan Hralm',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,24,16,25,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014077,30003389,20000494,10000042),(3010632,'Sigmakidi Tottalfill',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,21,14,22,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014080,30003389,20000494,10000042),(3010633,'Odilulf Isalolf',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,24,16,25,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014125,30003394,20000495,10000042),(3010634,'Edrei Hemolifer',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,24,16,24,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014128,30003394,20000495,10000042),(3010635,'Rirokton Togmur',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,24,16,25,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014083,30003402,20000496,10000042),(3010636,'Endit Irolf',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,24,16,25,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014086,30003404,20000496,10000042),(3010637,'Amlusming Wyrd',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,27,15,27,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014101,30003409,20000497,10000042),(3010638,'Ebiluard Stylera',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,27,15,27,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014104,30003412,20000497,10000042),(3010639,'Ebasger Arsvald',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,27,15,28,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014116,30003467,20000506,10000042),(3010640,'Rildboko Ereid',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,24,16,25,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014113,30003469,20000506,10000042),(3010641,'Afsur Omblur',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,21,14,21,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014149,30001868,20000276,10000022),(3010642,'Nabania Psankan',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014221,30001840,20000272,10000022),(3010643,'Ikaine Juuronaiken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014224,30001842,20000272,10000022),(3010644,'Eding Tjek',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,27,15,27,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014227,30001842,20000272,10000022),(3010645,'Achtes Rille',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014230,30001847,20000273,10000022),(3010646,'Jalshinden Agis',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014233,30001847,20000273,10000022),(3010647,'Oessync Molder',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014236,30001848,20000273,10000022),(3010648,'Blolilan Assochaere',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014182,30001852,20000274,10000022),(3010649,'Mashi Zadanu',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014176,30001854,20000274,10000022),(3010650,'Utrisen Hono',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014179,30001855,20000274,10000022),(3010651,'Itanala Airelen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014266,30001858,20000275,10000022),(3010652,'Ajai Akio',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014269,30001858,20000275,10000022),(3010653,'Groelande Erckee',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014272,30001866,20000275,10000022),(3010654,'Egand Gerremur',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,27,15,27,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014152,30001868,20000276,10000022),(3010655,'Lird Herako',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,27,15,28,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014155,30001868,20000276,10000022),(3010656,'Pierramitte Desebvrillot',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014164,30001873,20000277,10000022),(3010657,'Mendia Natrair',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014158,30001874,20000277,10000022),(3010658,'Anchauttes Cleyn',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014161,30001874,20000277,10000022),(3010659,'Hyykiala Futtari',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014206,30001881,20000278,10000022),(3010660,'Asunula Aarikken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014203,30001883,20000278,10000022),(3010661,'Meugenlieu Lede',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014209,30001883,20000278,10000022),(3010662,'Ukkegas Otatoh',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014185,30001894,20000280,10000022),(3010663,'Woligabet Gungvidi',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,21,14,21,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014188,30001896,20000280,10000022),(3010664,'Redolund Modrold',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,21,14,21,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014191,30001897,20000280,10000022),(3010665,'Mouh Matyed',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014257,30001901,20000281,10000022),(3010666,'Jedira Mesar',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014263,30001901,20000281,10000022),(3010667,'Etymet Aesen',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014260,30001902,20000281,10000022),(3010668,'Daduner Tayllanch',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014167,30001907,20000282,10000022),(3010669,'Geinekur Arvekar',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,24,16,24,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014170,30001907,20000282,10000022),(3010670,'Pazi Jimiruh',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014173,30001907,20000282,10000022),(3010671,'Oren Aesbad',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,21,14,22,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014245,30001914,20000283,10000022),(3010672,'Edusen Friens',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,24,16,25,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014242,30001918,20000283,10000022),(3010673,'Udman Gunonbjer',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,27,15,27,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014239,30001922,20000283,10000022),(3010674,'Erdur Hjedt',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,21,14,21,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014218,30001931,20000285,10000022),(3010675,'Oddeldaktar Sorsdaltur',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,21,14,21,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014212,30001932,20000285,10000022),(3010676,'Apiencaron Athellaert',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014215,30001932,20000285,10000022),(3010677,'Geidulf Virmako',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,21,14,22,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014278,30001938,20000286,10000022),(3010678,'Detere Zanisale',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014275,30001939,20000286,10000022),(3010679,'Aecht Beel',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014281,30001946,20000286,10000022),(3010680,'Vinolfid Harmirkar',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,27,15,28,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014248,30001951,20000287,10000022),(3010681,'Okenieto Aulinken',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014254,30001951,20000287,10000022),(3010682,'Agala Ilques',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014251,30001952,20000287,10000022),(3010683,'Ainoutte Oursinault',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014194,30001958,20000288,10000022),(3010684,'Taintanen Kisovas',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014197,30001959,20000288,10000022),(3010685,'Athet Artehan',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014200,30001961,20000288,10000022),(3010686,'Sirlorette Ouellelle',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014284,30001868,20000276,10000022),(3010687,'Orsegnel Virault',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014326,30001831,20000271,10000022),(3010688,'Ardaelloure Loon',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014329,30001833,20000271,10000022),(3010689,'Brokara Ryver',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,21,14,22,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014350,30001842,20000272,10000022),(3010690,'Damaini Jusemet',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014353,30001842,20000272,10000022),(3010691,'Odgund Wimfren',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,24,16,24,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014305,30001847,20000273,10000022),(3010692,'Rochah Mafah',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014302,30001848,20000273,10000022),(3010693,'Chelm Soran',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,47,13,48,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014356,30001854,20000274,10000022),(3010694,'Fotine Anilla',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,24,16,24,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014359,30001855,20000274,10000022),(3010695,'Oishonen Sano',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014287,30001868,20000276,10000022),(3010696,'Selynne Mardakar',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,24,16,25,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014293,30001874,20000277,10000022),(3010697,'Luratene Edmoure',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014290,30001878,20000277,10000022),(3010698,'Eystana Auspur',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,27,15,28,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014296,30001884,20000278,10000022),(3010699,'Armirrot Ingheroule',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014299,30001886,20000278,10000022),(3010700,'Situnen Nanmaa',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014341,30001888,20000279,10000022),(3010701,'Amidier Ponchiette',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014338,30001889,20000279,10000022),(3010702,'Mifra Savsousi',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014317,30001900,20000281,10000022),(3010703,'Ohinen Uvi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014314,30001901,20000281,10000022),(3010704,'Aubier Pelfin',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014371,30001907,20000282,10000022),(3010705,'Wrezere Mivellaers',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014368,30001910,20000282,10000022),(3010706,'Roire Aubonard',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014311,30001911,20000283,10000022),(3010707,'Irsti Gotlenur',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,27,15,27,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014308,30001920,20000283,10000022),(3010708,'Micoreullon Ramme',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014335,30001924,20000284,10000022),(3010709,'Avagnel Vifrobahnel',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014332,30001930,20000284,10000022),(3010710,'Dardicent Herirlier',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014344,30001939,20000286,10000022),(3010711,'Adwe Stulf',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,21,14,21,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014347,30001945,20000286,10000022),(3010712,'Neliker Shahoun',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014362,30001950,20000287,10000022),(3010713,'Pilbralie Aloutte',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014365,30001952,20000287,10000022),(3010714,'Shittari Inakawa',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014320,30001961,20000288,10000022),(3010715,'Nokane Tuotela',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014323,30001962,20000288,10000022),(3010716,'Askuldur Kafruger',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,27,15,27,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014374,30000905,20000132,10000011),(3010717,'Gotreda Hrein',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,21,14,21,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014437,30000001,20000001,10000001),(3010718,'Ondanold Olsar',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,27,15,27,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014434,30000007,20000001,10000001),(3010719,'Ikostur Itur',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,21,14,22,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014461,30000023,20000004,10000001),(3010720,'Meirlar Hogstossen',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,24,16,24,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014458,30000030,20000004,10000001),(3010721,'Wlbrok Olvika',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,21,14,22,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014407,30000057,20000009,10000001),(3010722,'Tobekarulf Fadvamund',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,21,14,22,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014404,30000061,20000009,10000001),(3010723,'Ulotta Relm',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,24,16,24,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014422,30000075,20000010,10000001),(3010724,'Apset Odiber',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,27,15,28,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014452,30000112,20000016,10000001),(3010725,'Odmo Engisi',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,21,14,22,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014425,30000073,20000010,10000001),(3010726,'Elaef Armelur',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,27,15,28,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014455,30000118,20000016,10000001),(3010727,'Grewlf Audari',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,24,16,25,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014377,30000904,20000132,10000011),(3010728,'Uanslironel Egding',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,24,16,24,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014383,30002385,20000350,10000028),(3010729,'Hronjedrik Algat',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,27,15,28,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014380,30002386,20000350,10000028),(3010730,'Harven Taven',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,21,14,22,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014428,30002399,20000352,10000028),(3010731,'Asbran Tolgaven',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,21,14,21,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014431,30002399,20000352,10000028),(3010732,'Atgand Reud',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,24,16,25,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014395,30002402,20000353,10000028),(3010733,'Odurstur Atana',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,24,16,24,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014392,30002406,20000353,10000028),(3010734,'Ivinlen Aetakur',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,21,14,21,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014401,30002527,20000370,10000030),(3010735,'Fondedmini Serg',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,24,16,25,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014398,30002529,20000370,10000030),(3010736,'Odboko Vir',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,27,15,28,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014389,30002557,20000375,10000030),(3010737,'Stelur Aremold',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,24,16,25,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014386,30002560,20000375,10000030),(3010738,'Engader Wlfhorl',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,27,15,28,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014443,30002575,20000378,10000030),(3010739,'Gei Kadlotta',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,21,14,22,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014440,30002580,20000378,10000030),(3010740,'Lavamogar Einur',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,27,15,28,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014446,30003287,20000480,10000041),(3010741,'Zeir Gumonot',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,27,15,27,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014449,30003287,20000480,10000041),(3010742,'Fenugur Askold',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,24,16,24,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014416,30003317,20000483,10000041),(3010743,'Hurgtur Arike',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,27,15,28,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014419,30003317,20000483,10000041),(3010744,'Agirtad Metardror',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,24,16,25,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014410,30003322,20000484,10000041),(3010745,'Sydweine Ardreas',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,24,16,25,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014413,30003323,20000484,10000041),(3010746,'Lialuala Pentuter',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,24,16,25,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014464,30001484,20000218,10000017),(3010747,'Andiksdagber Kademulf',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014527,30001386,20000203,10000016),(3010748,'Meksenulf Ekgaker',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014533,30001386,20000203,10000016),(3010749,'Chigas Pomari',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014530,30001390,20000203,10000016),(3010750,'Niviler Astaran',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014470,30001480,20000218,10000017),(3010751,'Gerskur Hrinz',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014467,30001485,20000218,10000017),(3010752,'Ukbashe Multamod',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014548,30002672,20000391,10000032),(3010753,'Ormalban Euruilat',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014551,30002672,20000391,10000032),(3010754,'Tantami Sakulito',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014545,30002675,20000391,10000032),(3010755,'Tashiken Hunttanen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014509,30002711,20000396,10000032),(3010756,'Tekomozu Taikio',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014512,30002711,20000396,10000032),(3010757,'Ogena Out',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014515,30002711,20000396,10000032),(3010758,'Angireque Vippiron',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014521,30002995,20000439,10000036),(3010759,'Deemos Komoubi',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014518,30003000,20000439,10000036),(3010760,'Honaldur Amangrald',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014524,30003000,20000439,10000036),(3010761,'Baldrelner Beraert',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014485,30003010,20000441,10000037),(3010762,'Poillin Ignerotta',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014482,30003013,20000441,10000037),(3010763,'Shadakhbos Irieh',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,27,15,28,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014488,30003013,20000441,10000037),(3010764,'Kahken Uura',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014554,30003057,20000447,10000037),(3010765,'Shuhola Oritie',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014560,30003058,20000447,10000037),(3010766,'Habiela Darali',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014557,30003059,20000447,10000037),(3010767,'Vernazi Attem',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014563,30003068,20000448,10000038),(3010768,'Snahian Hihsa',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014566,30003068,20000448,10000038),(3010769,'Karodan Nietira',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014569,30003068,20000448,10000038),(3010770,'Olbran Arneka',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,21,14,22,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014572,30003831,20000560,10000048),(3010771,'Ahrairbaine Boullotames',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014578,30003831,20000560,10000048),(3010772,'Poure Thoure',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014575,30003834,20000560,10000048),(3010773,'Gillon Bryngete',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014581,30004084,20000597,10000052),(3010774,'Cle Vaufer',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,27,15,28,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014584,30004084,20000597,10000052),(3010775,'Ivoldart Rolt',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014587,30004084,20000597,10000052),(3010776,'Ittant Bottorellon',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014590,30004099,20000599,10000052),(3010777,'Herbomur Antikelm',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,27,15,27,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014593,30004099,20000599,10000052),(3010778,'Atonder Oldbias',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014596,30004099,20000599,10000052),(3010779,'Hasi Matshi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014539,30004976,20000728,10000064),(3010780,'Goggert Innolf',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,27,15,28,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014542,30004976,20000728,10000064),(3010781,'Engata Lirfur',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014536,30004977,20000728,10000064),(3010782,'Krirden Audulden',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014500,30005217,20000763,10000067),(3010783,'Okseroila Risku',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014503,30005217,20000763,10000067),(3010784,'Blelle Aegheem',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014506,30005217,20000763,10000067),(3010785,'Auslay Dermesbeyne',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,27,15,27,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014479,30005311,20000777,10000068),(3010786,'Toilen Korvas',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014473,30005313,20000777,10000068),(3010787,'Araqi Ildir',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014476,30005313,20000777,10000068),(3010788,'Ongjer Odida',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,27,15,27,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014494,30005322,20000779,10000068),(3010789,'Liatter Eldrek',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014497,30005322,20000779,10000068),(3010790,'Keltz Sotana',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014491,30005325,20000779,10000068),(3010791,'Houla Seiradih',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014599,30005042,20000737,10000065),(3010792,'Jaynara Nozu',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014620,30001715,20000253,10000020),(3010793,'Yotana Mahir',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,47,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014605,30001724,20000255,10000020),(3010794,'Rabhaneh Ojer',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014608,30002270,20000333,10000043),(3010795,'Dotath Saal',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014611,30002993,20000438,10000036),(3010796,'Neasa Tabier',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,45,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014614,30003092,20000452,10000038),(3010797,'Nekhaz Corelot',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,48,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014617,30003482,20000508,10000043),(3010798,'Giran Soldi',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014623,30004267,20000624,10000054),(3010799,'Kavavsaf Gari',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,44,12,44,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014626,30005258,20000769,10000067),(3010800,'Somarkia Ubar',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,41,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014602,30005275,20000772,10000067),(3010801,'Lidafa Maga',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014629,30003489,20000509,10000043),(3010802,'Ehan Handi',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014635,30001685,20000249,10000020),(3010803,'Apunar Atoosh',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014644,30001718,20000254,10000020),(3010804,'Khadonevedu Nibainkier',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,41,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014653,30001733,20000256,10000020),(3010805,'Semah Sheila',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,44,12,45,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014638,30003473,20000507,10000043),(3010806,'Delabet Adiam',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,5,41,11,42,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014632,30003522,20000514,10000043),(3010807,'Eredlis Kheen',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014641,30004142,20000606,10000052),(3010808,'Cardohzon Aneri',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,2,41,11,42,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014647,30004277,20000625,10000054),(3010809,'Narol Holhana',NULL,'','',0,0,0,'',0,0,0,0,0,1374,4,6,4,47,13,47,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014656,30005063,20000741,10000065),(3010810,'Bridi Tenegh',NULL,'','',0,0,0,'',0,0,0,0,0,1373,4,5,1,44,12,44,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014650,30005275,20000772,10000067),(3010811,'Toiniainen Omu',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014659,30000141,20000020,10000002),(3010812,'Aibi Okseroila',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014686,30000165,20000024,10000002),(3010813,'Kokitaira Tsutara',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014671,30001366,20000199,10000016),(3010814,'Uunse Has',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014662,30001391,20000203,10000016),(3010815,'Kamaala Uehashi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014680,30001411,20000207,10000016),(3010816,'Asaken Pietkane',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014674,30001432,20000210,10000016),(3010817,'Utrigas Oikilen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014665,30002740,20000401,10000033),(3010818,'Katusen Nukanata',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014677,30002755,20000404,10000033),(3010819,'Isaken Sarkeda',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014683,30002776,20000407,10000033),(3010820,'Osie Ohmahailen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014668,30002792,20000409,10000033),(3010821,'Apenette Cadelanne',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014689,30004971,20000727,10000064),(3010822,'Aunia Assie',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,84,21,85,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014692,30002685,20000393,10000032),(3010823,'Bouey Sadereron',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,88,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014716,30002718,20000398,10000032),(3010824,'Andarane Ringilaille',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014698,30003017,20000442,10000037),(3010825,'Contaire Ossins',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,87,22,88,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014701,30003570,20000520,10000044);
insert  into `characterStatic`(`characterID`,`characterName`,`accountID`,`title`,`description`,`bounty`,`balance`,`securityRating`,`petitionMessage`,`logonMinutes`,`corporationID`,`corporationDateTime`,`startDateTime`,`createDateTime`,`typeID`,`raceID`,`bloodlineID`,`ancestryID`,`careerID`,`schoolID`,`careerSpecialityID`,`gender`,`accessoryID`,`beardID`,`costumeID`,`decoID`,`eyebrowsID`,`eyesID`,`hairID`,`lipstickID`,`makeupID`,`skinID`,`backgroundID`,`lightID`,`headRotation1`,`headRotation2`,`headRotation3`,`eyeRotation1`,`eyeRotation2`,`eyeRotation3`,`camPos1`,`camPos2`,`camPos3`,`morph1e`,`morph1n`,`morph1s`,`morph1w`,`morph2e`,`morph2n`,`morph2s`,`morph2w`,`morph3e`,`morph3n`,`morph3s`,`morph3w`,`morph4e`,`morph4n`,`morph4s`,`morph4w`,`stationID`,`solarSystemID`,`constellationID`,`regionID`) values (3010826,'Enoittinon Givelle',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014707,30003850,20000563,10000048),(3010827,'Yvesque Gronssyn',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014710,30004991,20000730,10000064),(3010828,'Bureneque Heyssinodis',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014713,30005009,20000733,10000064),(3010829,'Yvelle Adraille',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014704,30005297,20000775,10000068),(3010830,'Guyotghen Adoudel',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,17,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014695,30005322,20000779,10000068),(3010831,'Nedastier Lerveine',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014719,30005305,20000776,10000068),(3010832,'Gian Rouppon',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014740,30002634,20000386,10000032),(3010833,'Esalion Lay',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014743,30002648,20000388,10000032),(3010834,'Anseneque Ermagne',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014734,30002663,20000390,10000032),(3010835,'Trodovine Rieres',NULL,'','',0,0,0,'',0,0,0,0,0,1378,8,8,16,84,21,85,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014725,30003039,20000445,10000037),(3010836,'Armailitte Alonckbraert',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,84,21,84,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014746,30003058,20000447,10000037),(3010837,'Ekorecke Anchauttes',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,81,20,82,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014737,30003787,20000553,10000048),(3010838,'Ivonalle Galelare',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014731,30003798,20000554,10000048),(3010839,'Pilotte Hourille',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,14,87,22,87,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014722,30003819,20000558,10000048),(3010840,'Bedavardt Cadie',NULL,'','',0,0,0,'',0,0,0,0,0,1377,8,7,13,81,20,81,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014728,30005007,20000732,10000064),(3010841,'Jonnora Osagard',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,21,14,22,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014749,30002547,20000373,10000030),(3010842,'Adatter Aedin',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,27,15,27,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014770,30002051,20000302,10000042),(3010843,'Afgit Agiko',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,24,16,24,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014758,30002076,20000306,10000042),(3010844,'Idungel Austrenald',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,24,16,25,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014767,30002090,20000308,10000042),(3010845,'Oppur Aulrand',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,27,15,28,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014752,30002386,20000350,10000028),(3010846,'Aunirad Fegill',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,24,16,24,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014761,30002393,20000351,10000028),(3010847,'Egtrik Libold',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,21,14,22,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014755,30002520,20000369,10000030),(3010848,'Hraderiko Wlfrurd',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,21,14,21,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014773,30002533,20000371,10000030),(3010849,'Argi Yngvigur',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,24,16,25,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014764,30002562,20000376,10000030),(3010850,'Arnake Tadiko',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,27,15,28,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014776,30003408,20000496,10000042),(3010851,'Gukarla Beldad',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,27,15,27,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014779,30002505,20000367,10000030),(3010852,'Fider Tolelskorsur',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,24,16,24,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014806,30002068,20000305,10000042),(3010853,'Guvera Lovedia',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,27,15,27,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014800,30002082,20000307,10000042),(3010854,'Stunringsmur Sveruvard',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,21,14,21,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014788,30002092,20000308,10000042),(3010855,'Haen Astrarald',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,24,16,24,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014791,30002531,20000371,10000030),(3010856,'Filbrofur Admur',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,21,14,22,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014797,30002560,20000375,10000030),(3010857,'Gadulman Wulenbjon',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,27,15,28,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014782,30003377,20000492,10000042),(3010858,'Fasskeflur Orba',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,27,15,28,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014803,30003441,20000502,10000042),(3010859,'Krigasand Eytteinn',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,24,16,25,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014785,30003456,20000504,10000042),(3010860,'Getonsur Irkold',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,24,16,24,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014794,30003468,20000506,10000042),(3010861,'Orber Letava',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,24,16,25,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014809,30003410,20000497,10000042),(3010862,'Sel Habresia',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,24,16,24,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014836,30002062,20000304,10000042),(3010863,'Stoss Odatrik',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,24,16,24,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014821,30002087,20000307,10000042),(3010864,'Burtuli Oltolf',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,27,15,28,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014815,30002390,20000351,10000028),(3010865,'Lirlurad Wlfhod',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,24,16,25,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014824,30002404,20000353,10000028),(3010866,'Aikarla Renatikkin',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,27,15,28,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014833,30002527,20000370,10000030),(3010867,'Rogimer Gufrolf',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,24,16,25,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014827,30002537,20000372,10000030),(3010868,'Kagnelar Arstin',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,27,15,27,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014818,30003416,20000498,10000042),(3010869,'Wedeiken Oddeldaktar',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,27,15,27,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014812,30003453,20000504,10000042),(3010870,'Egbindur Treodeskar',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,27,15,27,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60014830,30003467,20000506,10000042),(3010871,'Aikaras Heyntonen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000310,30001399,20000205,10000016),(3010872,'Ozanami Suroma',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000400,30000133,20000019,10000002),(3010873,'Eratoh Vistoya',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000397,30000136,20000019,10000002),(3010874,'Samivesti Iivonas',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000394,30000138,20000019,10000002),(3010875,'Santera Nami',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000403,30000138,20000019,10000002),(3010876,'Nitaka Aoki',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000367,30000139,20000020,10000002),(3010877,'Isamila Aurila',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000421,30002816,20000413,10000033),(3010878,'Iemuken Aakuwa',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000364,30000142,20000020,10000002),(3010879,'Okamainen Niuranto',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000358,30000144,20000020,10000002),(3010880,'Pajus Kormilen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000382,30000192,20000027,10000002),(3010881,'Oinalen Riukka',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000391,30000192,20000027,10000002),(3010882,'Lihken Ogemi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000385,30000193,20000027,10000002),(3010883,'Oyonela Oguken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000388,30000193,20000027,10000002),(3010884,'Ruonio Sutenela',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000352,30001368,20000200,10000016),(3010885,'Oikeras Siyoniki',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000346,30001370,20000200,10000016),(3010886,'Tamusama Tosashaida',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000355,30001372,20000200,10000016),(3010887,'Ylojus Onereki',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000349,30001373,20000200,10000016),(3010888,'Ochoras Ueha',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000373,30001374,20000201,10000016),(3010889,'Ushinokka Nindenen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000379,30001375,20000201,10000016),(3010890,'Ylarita Ryeki',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000376,30001376,20000201,10000016),(3010891,'Iji Kiyura',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000370,30001379,20000201,10000016),(3010892,'Vautemi Huunashin',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000334,30001386,20000203,10000016),(3010893,'Kauniainen Oho',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000337,30001387,20000203,10000016),(3010894,'Olkkosen Iras',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000343,30001387,20000203,10000016),(3010895,'Kakiainen Okanata',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000340,30001391,20000203,10000016),(3010896,'Ahtamon Varhila',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000319,30001398,20000205,10000016),(3010897,'Ihikano Kuppas',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000313,30001403,20000205,10000016),(3010898,'Tatkashin Shunawairos',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000316,30001403,20000205,10000016),(3010899,'Ouranienen Ikkoini',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000322,30002744,20000402,10000033),(3010900,'Uoyera Miltoh',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000325,30002746,20000402,10000033),(3010901,'Erinen Veikoyera',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000328,30002748,20000402,10000033),(3010902,'Kuotanen Kabara',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000331,30002748,20000402,10000033),(3010903,'Oyami Kapumara',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000409,30002764,20000405,10000033),(3010904,'Nigirada Antu',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000412,30002764,20000405,10000033),(3010905,'Haras Sichono',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000406,30002766,20000405,10000033),(3010906,'Ourohuras Auttavas',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000415,30002766,20000405,10000033),(3010907,'Nabatanen Ourakiken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000427,30002815,20000413,10000033),(3010908,'Notaraka Ysen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000421,30002816,20000413,10000033),(3010909,'Yanedoinen Kie',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000424,30002817,20000413,10000033),(3010910,'Nela Huska',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000418,30002818,20000413,10000033),(3010911,'Shishai Samanuni',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000430,30002801,20000411,10000033),(3010912,'Suisonakka Teiroma',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000532,30000184,20000026,10000002),(3010913,'Hirento Raikkanen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000529,30000185,20000026,10000002),(3010914,'Hohala Surkkinas',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000526,30000187,20000026,10000002),(3010915,'Tika Avu',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000577,30000189,20000027,10000002),(3010916,'Hannonas Alineri',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000583,30000192,20000027,10000002),(3010917,'Maken Isamila',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000586,30000192,20000027,10000002),(3010918,'Oinokjus Airkio',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000574,30000193,20000027,10000002),(3010919,'Rakkadan Haukono',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000580,30000193,20000027,10000002),(3010920,'Nannaras Arma',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000589,30000193,20000027,10000002),(3010921,'Ishi Paalokoiras',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000496,30000201,20000029,10000002),(3010922,'Akichiya Reussilen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000493,30000203,20000029,10000002),(3010923,'Oppa Raiskatoh',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000499,30000203,20000029,10000002),(3010924,'Vankanen Utrasen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000484,30000204,20000029,10000002),(3010925,'Akasa Inkavas',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000487,30000206,20000029,10000002),(3010926,'Munatoh Sajatoma',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000490,30000206,20000029,10000002),(3010927,'Okasvio Uittigas',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000592,30001356,20000198,10000016),(3010928,'Kommiluola Punori',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000601,30001356,20000198,10000016),(3010929,'Aiga Paunashin',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000607,30001357,20000198,10000016),(3010930,'Oraa Gohtiras',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000598,30001358,20000198,10000016),(3010931,'Sichono Onama',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000595,30001360,20000198,10000016),(3010932,'Vitamala Ylila',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000604,30001360,20000198,10000016),(3010933,'Piervapio Suehuma',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000475,30001404,20000206,10000016),(3010934,'Ichinita Musalula',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000481,30001404,20000206,10000016),(3010935,'Arjus Kemashuka',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000472,30001408,20000206,10000016),(3010936,'Hovoila Iesasen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000466,30001409,20000206,10000016),(3010937,'Onuori Orala',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000469,30001409,20000206,10000016),(3010938,'Eskalen Elmaa',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000478,30001409,20000206,10000016),(3010939,'Totavuo Ahupittoh',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000547,30002763,20000405,10000033),(3010940,'Atnen Shotisto',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000550,30002763,20000405,10000033),(3010941,'Honuken Damogainen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000538,30002764,20000405,10000033),(3010942,'Sebando Neri',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000541,30002764,20000405,10000033),(3010943,'Ayua Vasala',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000544,30002766,20000405,10000033),(3010944,'Yutukio Isalen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000553,30002766,20000405,10000033),(3010945,'Ylalairos Igenobe',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000556,30002797,20000410,10000033),(3010946,'Shihiken Komanula',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000559,30002797,20000410,10000033),(3010947,'Auro Pussinieras',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000565,30002798,20000410,10000033),(3010948,'Eskaari Okikko',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000568,30002798,20000410,10000033),(3010949,'Niya Akesma',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000571,30002798,20000410,10000033),(3010950,'Kehtuainen Uehunen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000562,30002799,20000410,10000033),(3010951,'Ontaa Itarino',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000433,30002802,20000411,10000033),(3010952,'Heitalvaari Hodanomi',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000436,30002802,20000411,10000033),(3010953,'Kobakori Otsiainen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000445,30002802,20000411,10000033),(3010954,'Risalo Ottaa',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000439,30002804,20000411,10000033),(3010955,'Itamo Ake',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000442,30002804,20000411,10000033),(3010956,'Takiloma Ohvari',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000448,30000139,20000020,10000002),(3010957,'Autiras Yuatoh',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000451,30000142,20000020,10000002),(3010958,'Ylandoki Ishinila',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000475,30001404,20000206,10000016),(3010959,'Ohvola Manjus',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000454,30000143,20000020,10000002),(3010960,'Oikara Salkkaa',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000472,30001408,20000206,10000016),(3010961,'Oksoinio Niromochi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000460,30000143,20000020,10000002),(3010962,'Putkamon Kibayasu',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000502,30000147,20000021,10000002),(3010963,'Pintama Soribainen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000505,30000148,20000021,10000002),(3010964,'Pomanoue Kuski',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000517,30000148,20000021,10000002),(3010965,'Sakkanaka Haakkigo',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000508,30000149,20000021,10000002),(3010966,'Ailen Saakuka',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000511,30000149,20000021,10000002),(3010967,'Aatoh Ahtushin',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000514,30000152,20000021,10000002),(3010968,'Iitima Kisodairos',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000535,30000180,20000026,10000002),(3010969,'Gu Ueshuda',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000523,30000183,20000026,10000002),(3010970,'Viesimi Toilumioya',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000520,30000184,20000026,10000002),(3010971,'Ronen Vuorisainen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000610,30002775,20000407,10000033),(3010972,'Taginami Osiri',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000637,30002773,20000406,10000033),(3010973,'Heisanne Issanen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000640,30002773,20000406,10000033),(3010974,'Aivolen Lisika',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000643,30002773,20000406,10000033),(3010975,'Shikkanda Kaukala',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000613,30002779,20000407,10000033),(3010976,'Hilen Ekomuta',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000616,30002779,20000407,10000033),(3010977,'Norkiras Isaziwa',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000631,30002794,20000410,10000033),(3010978,'Ukaras Ebiken',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000628,30002797,20000410,10000033),(3010979,'Tsushizoma Vaskinen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000634,30002797,20000410,10000033),(3010980,'Ora Aarawaiki',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000622,30002800,20000411,10000033),(3010981,'Avu Olunatsu',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000619,30002802,20000411,10000033),(3010982,'Sakutima Yara',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000625,30002802,20000411,10000033),(3010983,'Tomakuma Tsukaya',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000646,30000152,20000021,10000002),(3010984,'Oijeshonen Isotiomaa',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000691,30000143,20000020,10000002),(3010985,'Otuvas Ylitoh',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000685,30000144,20000020,10000002),(3010986,'Inikko Samanuni',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000682,30000145,20000020,10000002),(3010987,'Han Taltanen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000688,30000145,20000020,10000002),(3010988,'Tolen Rainakaaja',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000649,30000146,20000021,10000002),(3010989,'Sori Tuotuninen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000652,30000149,20000021,10000002),(3010990,'Aluri Yanaguno',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000655,30000152,20000021,10000002),(3010991,'Ylamaa Soljaken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000754,30001362,20000199,10000016),(3010992,'Ke Kakuruka',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000757,30001362,20000199,10000016),(3010993,'Vasala Akochi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000763,30001363,20000199,10000016),(3010994,'Panen Konihela',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000760,30001364,20000199,10000016),(3010995,'Jukinoue Jurechi',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000709,30001369,20000200,10000016),(3010996,'Kolkka Ovolen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000706,30001372,20000200,10000016),(3010997,'Husiras Hostamon',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000712,30001372,20000200,10000016),(3010998,'Hetsen Bukken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000715,30001373,20000200,10000016),(3010999,'Okichoshi Ekura',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000733,30001400,20000205,10000016),(3011000,'Rakonainen Antalen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000730,30001401,20000205,10000016),(3011001,'Aizagenen Arozainen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000736,30001403,20000205,10000016),(3011002,'Alavuo Suukkunen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000739,30001403,20000205,10000016),(3011003,'Aranoisen Orpoila',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000751,30002769,20000406,10000033),(3011004,'Hoshoda Uminishi',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000742,30002773,20000406,10000033),(3011005,'Itima Ikaala',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000745,30002773,20000406,10000033),(3011006,'Suokko Mitalen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000748,30002774,20000406,10000033),(3011007,'Asenemi Nama',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000664,30002784,20000408,10000033),(3011008,'Huukka Aarnosen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000658,30002786,20000408,10000033),(3011009,'Otuniki Tekken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000667,30002786,20000408,10000033),(3011010,'Aihakagas Korkukka',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000661,30002787,20000408,10000033),(3011011,'Nisen Nirputsairos',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000679,30002801,20000411,10000033),(3011012,'Rainela Inaro',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000670,30002802,20000411,10000033),(3011013,'Tenpaa Hyynita',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000673,30002805,20000411,10000033),(3011014,'Nuulkata Junkka',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000676,30002805,20000411,10000033),(3011015,'Undai Kankadoishi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000703,30002806,20000412,10000033),(3011016,'Kaipia Reppola',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000697,30002808,20000412,10000033),(3011017,'Ikai Uosarodan',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000700,30002810,20000412,10000033),(3011018,'Wabe Vitie',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000694,30002812,20000412,10000033),(3011019,'Ichinita Nous',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000718,30002815,20000413,10000033),(3011020,'Naras Sawalola',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000724,30002817,20000413,10000033),(3011021,'Okio Odai',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000727,30002817,20000413,10000033),(3011022,'Saatoma Kien',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000721,30002819,20000413,10000033),(3011023,'Karokainen Irawa',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000766,30001394,20000204,10000016),(3011024,'Rutilo Omieto',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000784,30000188,20000027,10000002),(3011025,'Satsu Mikakka',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000790,30000188,20000027,10000002),(3011026,'Ishogachi Kazorose',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000787,30000190,20000027,10000002),(3011027,'Okuro Petsiken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000844,30001363,20000199,10000016),(3011028,'Arise Alana',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000841,30001365,20000199,10000016),(3011029,'Vesuroma Nautio',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000838,30001367,20000199,10000016),(3011030,'Iijanairos Kous',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000772,30001396,20000204,10000016),(3011031,'Poitekkoda Hutsinius',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000769,30001397,20000204,10000016),(3011032,'Isela Irki',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000811,30001404,20000206,10000016),(3011033,'Kusen Raunuta',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000814,30001404,20000206,10000016),(3011034,'Tokaka Sakinukka',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000817,30001409,20000206,10000016),(3011035,'Vion Ekken',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000775,30001418,20000208,10000016),(3011036,'Pakuras Ishatsu',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000778,30001418,20000208,10000016),(3011037,'Ramara Huotoras',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000781,30001418,20000208,10000016),(3011038,'Abagairos Otukuya',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000802,30001432,20000210,10000016),(3011039,'Uuhatoh Yokoni',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000808,30001433,20000210,10000016),(3011040,'Juunigaishi Okumi',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000805,30001436,20000210,10000016),(3011041,'Rasavas Funuruoto',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000823,30001443,20000212,10000016),(3011042,'Minatiken Savalenta',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000826,30001447,20000212,10000016),(3011043,'Etsen Ihinota',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000820,30001448,20000212,10000016),(3011044,'Turmesen Taksaken',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000793,30002802,20000411,10000033),(3011045,'Multola Nikkaken',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000796,30002802,20000411,10000033),(3011046,'Jenus Totsitoh',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000799,30002803,20000411,10000033),(3011047,'Egaruopas Umunmaa',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000850,30002806,20000412,10000033),(3011048,'Ohio Aivolen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000847,30002808,20000412,10000033),(3011049,'Okkalen Erakko',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000853,30002812,20000412,10000033),(3011050,'Saskitanen Kusuta',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000832,30002817,20000413,10000033),(3011051,'Kaitalen Ronken',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000835,30002817,20000413,10000033),(3011052,'Kantsatoh Mittitoh',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000829,30002819,20000413,10000033),(3011053,'Takashi Shioken',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000856,30002800,20000411,10000033),(3011054,'Antugaira Furiainen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000919,30000159,20000023,10000002),(3011055,'Yloruga Ouranienen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000916,30000162,20000023,10000002),(3011056,'Hamiras Uona',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000925,30000162,20000023,10000002),(3011057,'Iivaskuras Tausonen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000922,30000163,20000023,10000002),(3011058,'Ushota Mullanpaa',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000913,30000174,20000025,10000002),(3011059,'Tsusata Marvonen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000907,30000175,20000025,10000002),(3011060,'Uoyunaras Jokkalaila',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000904,30000177,20000025,10000002),(3011061,'Okinala Kahtaras',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000910,30000177,20000025,10000002),(3011062,'Ansoro Viritie',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000874,30000181,20000026,10000002),(3011063,'Arochi Syn',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000877,30000183,20000026,10000002),(3011064,'Numo Humo',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000868,30000184,20000026,10000002),(3011065,'Nistoya Papala',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000871,30000184,20000026,10000002),(3011066,'Ykken Alanama',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000973,30000201,20000029,10000002),(3011067,'Ijenen Nusasaisen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000964,30000205,20000029,10000002),(3011068,'Huortara Hyatira',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000970,30000206,20000029,10000002),(3011069,'Yatsiainen Hankkama',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000967,30000207,20000029,10000002),(3011070,'Urpanen Aranuri',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000937,30002789,20000409,10000033),(3011071,'Gotibera Kanamola',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000895,30001363,20000199,10000016),(3011072,'Iberato Inama',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000901,30001364,20000199,10000016),(3011073,'Puisinen Kojaken',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000898,30001367,20000199,10000016),(3011074,'Outoras Saisima',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000955,30001369,20000200,10000016),(3011075,'Uittalen Tima',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000958,30001369,20000200,10000016),(3011076,'Akano Asakiomaa',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000952,30001372,20000200,10000016),(3011077,'Ernaras Tatsoras',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000961,30001372,20000200,10000016),(3011078,'Kayagainen Arinichi',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000940,30001424,20000209,10000016),(3011079,'Tuimmamon Onalila',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000943,30001424,20000209,10000016),(3011080,'Kaanashin Hikaruta',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000949,30001426,20000209,10000016),(3011081,'Rashoyemi Okiainepas',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000946,30001429,20000209,10000016),(3011082,'Nuun Surula',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000880,30002781,20000408,10000033),(3011083,'Ohmanin Natuneni',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000883,30002783,20000408,10000033),(3011084,'Hen Vierishairos',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000886,30002787,20000408,10000033),(3011085,'Yoschoya Veskamon',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000889,30002787,20000408,10000033),(3011086,'Inainshatsu Onelari',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000931,30002789,20000409,10000033),(3011087,'Andan Kuumi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000937,30002789,20000409,10000033),(3011088,'Yuasa Veinalen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000928,30002792,20000409,10000033),(3011089,'Ketsen Tuulola',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000934,30002793,20000409,10000033),(3011090,'Pusuoya Kini',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000862,30002801,20000411,10000033),(3011091,'Inaida Futtari',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000859,30002802,20000411,10000033),(3011092,'Aviai Penen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000865,30002803,20000411,10000033),(3011093,'Uuris Oinen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000976,30001401,20000205,10000016),(3011094,'Igase Kairatoh',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000994,30004157,20000608,10000052),(3011095,'Eerala Airimainas',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001000,30004157,20000608,10000052),(3011096,'Nalvola Nimmoda',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001003,30004157,20000608,10000052),(3011097,'Noi Kugisa',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001123,30004280,20000626,10000054),(3011098,'Tasimuri Saskalen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001129,30004280,20000626,10000054),(3011099,'Iena Pahalo',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001132,30004281,20000626,10000054),(3011100,'Kituola Asunomo',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001126,30004282,20000626,10000054),(3011101,'Uotaji Oksen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001120,30004283,20000626,10000054),(3011102,'Airata Hagas',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001135,30004284,20000626,10000054),(3011103,'Hiekilen Iltaa',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001057,30005289,20000774,10000067),(3011104,'Sauleken Matsatoh',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001060,30005290,20000774,10000067),(3011105,'Marttatoh Tiukiski',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001063,30005290,20000774,10000067),(3011106,'Uopa Etsilen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001054,30005291,20000774,10000067),(3011107,'Pia Ashutahtoh',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001051,30005292,20000774,10000067),(3011108,'Urpa Sorkakaiken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001048,30005294,20000774,10000067),(3011109,'Pesabato Hirri',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000982,30001401,20000205,10000016),(3011110,'Urpaken Sylinaimon',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000985,30001401,20000205,10000016),(3011111,'Hamimaitoh Asanishi',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000988,30001401,20000205,10000016),(3011112,'Artaja Ininerva',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000991,30001401,20000205,10000016),(3011113,'Hakkonnonmaa Kunken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000979,30001403,20000205,10000016),(3011114,'Miit Oijertojus',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001078,30001644,20000243,10000020),(3011115,'Kibayasu Jimmulen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001081,30001644,20000243,10000020),(3011116,'Notsu Keikira',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001069,30001645,20000243,10000020),(3011117,'Sirkkari Kapumara',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001066,30001646,20000243,10000020),(3011118,'Uotaja Aalma',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001075,30001646,20000243,10000020),(3011119,'Josameto Abagawa',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001072,30001649,20000243,10000020),(3011120,'Koluoto Kintevas',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001084,30001669,20000247,10000020),(3011121,'Naras Makkolen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001087,30001670,20000247,10000020),(3011122,'Me Ohmitoh',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001090,30001670,20000247,10000020),(3011123,'Manamuwa Kurrisen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001099,30001670,20000247,10000020),(3011124,'Suresen Uotenen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001096,30001671,20000247,10000020),(3011125,'Sakama Arikaiken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001093,30001674,20000247,10000020),(3011126,'Ohvenen Toitaris',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001141,30002060,20000304,10000042),(3011127,'Kayekali Alikibo',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001147,30002060,20000304,10000042),(3011128,'Sinyonen Nilteras',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001150,30002060,20000304,10000042),(3011129,'Vo Kannomon',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001144,30002065,20000304,10000042),(3011130,'Vuohtara Akarichi',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001153,30002065,20000304,10000042),(3011131,'Saira Kubiseri',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001138,30002067,20000304,10000042),(3011132,'Ansamon Ohbanamon',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001024,30002200,20000323,10000043),(3011133,'Aakiwa Idakara',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001012,30002203,20000323,10000043),(3011134,'Sikoda Aivappas',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001015,30002203,20000323,10000043),(3011135,'Makkanen Allanen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001018,30002203,20000323,10000043),(3011136,'Alanti Erkkami',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001021,30002203,20000323,10000043),(3011137,'Yanelius Obaintukka',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001027,30002203,20000323,10000043),(3011138,'Okanori Oinasen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001108,30002531,20000371,10000030),(3011139,'Pannevas Uumi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001102,30002532,20000371,10000030),(3011140,'Tokka Tadamanoi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001105,30002532,20000371,10000030),(3011141,'Asken Kuusamon',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001117,30002534,20000371,10000030),(3011142,'Iesada Issune',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001111,30002535,20000371,10000030),(3011143,'Shimano Uusasheken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001114,30002536,20000371,10000030),(3011144,'Ansenen Ekarailen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001216,30002670,20000391,10000032),(3011145,'Kaivonpaa Tuikakino',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001222,30002670,20000391,10000032),(3011146,'Heitunen Vaalonen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001213,30002671,20000391,10000032),(3011147,'Rairuken Sokukoma',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001225,30002671,20000391,10000032),(3011148,'Soukesen Akkadan',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001219,30002672,20000391,10000032),(3011149,'Itras Ezikori',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001210,30002673,20000391,10000032),(3011150,'Sutagaitoh Sanda',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001192,30002790,20000409,10000033),(3011151,'Homokoilen Kattanen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001207,30002790,20000409,10000033),(3011152,'Vanochi Sawa',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001195,30002791,20000409,10000033),(3011153,'Ienonanen Sitsigainen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001201,30002791,20000409,10000033),(3011154,'Vasti Sashobaira',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001204,30002791,20000409,10000033),(3011155,'Aarumamon Kichi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001198,30002792,20000409,10000033),(3011156,'Utilusa Nurose',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001189,30002969,20000435,10000036),(3011157,'Asilato Kalolula',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001180,30002970,20000435,10000036),(3011158,'Sainori Uura',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001186,30002970,20000435,10000036),(3011159,'Najus Funtari',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001174,30002973,20000435,10000036),(3011160,'Anzaki Uesimaanen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001177,30002973,20000435,10000036),(3011161,'Garnen Knaakaras',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001183,30002973,20000435,10000036),(3011162,'Skidochi Huorola',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001033,30003467,20000506,10000042),(3011163,'Shitonata Makeraka',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001036,30003467,20000506,10000042),(3011164,'Penakka Ichinada',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001042,30003467,20000506,10000042),(3011165,'Nakelaiken Obanmaka',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001045,30003469,20000506,10000042),(3011166,'Mimetsoma Ichidama',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001030,30003470,20000506,10000042),(3011167,'Angai Poltela',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001039,30003471,20000506,10000042),(3011168,'Muutaras Huomaila',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001156,30004092,20000598,10000052),(3011169,'Tamppoiras Auni',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001162,30004093,20000598,10000052),(3011170,'Utraki Oksikka',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001168,30004095,20000598,10000052),(3011171,'Erkkonen Rakka',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001159,30004096,20000598,10000052),(3011172,'Tsukaya Tertakko',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001171,30004096,20000598,10000052),(3011173,'Aanai Walvalin',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001165,30004097,20000598,10000052),(3011174,'Vuorio Sarmaras',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001228,30004104,20000600,10000052),(3011175,'Isavaisen Ogyonin',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001234,30004104,20000600,10000052),(3011176,'Paakadan Uotadan',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001240,30004104,20000600,10000052),(3011177,'Onaila Valen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001231,30004106,20000600,10000052),(3011178,'Tsuka Otsami',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001237,30004106,20000600,10000052),(3011179,'Isitei Tannonaisen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001243,30004106,20000600,10000052),(3011180,'Asitei Adunen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001006,30004155,20000608,10000052),(3011181,'Oba Uetamiras',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60000997,30004156,20000608,10000052),(3011182,'Kikkutakka Orji',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001009,30004156,20000608,10000052),(3011183,'Kinakka Vie',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001246,30001356,20000198,10000016),(3011184,'Shirvala Nakkatoh',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001252,30001356,20000198,10000016),(3011185,'Asiai Anzatoh',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001414,30004104,20000600,10000052),(3011186,'Tsutachoda Saigomon',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001420,30004104,20000600,10000052),(3011187,'Sastigas Kuhtataiken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001423,30004104,20000600,10000052),(3011188,'Erninen Ranttika',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001417,30004106,20000600,10000052),(3011189,'Otasira Elanugi',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001387,30004248,20000622,10000054),(3011190,'Alirila Kiomi',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001378,30004249,20000622,10000054),(3011191,'Pasmelen Reppola',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001381,30004249,20000622,10000054),(3011192,'Kolvas Atso',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001384,30004249,20000622,10000054),(3011193,'Kileliri Kuramoichi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001294,30004254,20000623,10000054),(3011194,'Ishadan Korvenin',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001297,30004254,20000623,10000054),(3011195,'Kukakka Utriken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001300,30004254,20000623,10000054),(3011196,'Harskaken Kolandainen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001303,30004254,20000623,10000054),(3011197,'Eyo Ansoro',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001408,30004973,20000728,10000064),(3011198,'Musokka Ishisomo',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001402,30004976,20000728,10000064),(3011199,'Kaikka Mavolava',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001405,30004978,20000728,10000064),(3011200,'Hierada Onti',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001411,30004978,20000728,10000064),(3011201,'Nala Tukken',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001330,30005244,20000767,10000067),(3011202,'Sohomaa Lyyrimila',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001336,30005245,20000767,10000067),(3011203,'Itino Odushioka',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001333,30005247,20000767,10000067),(3011204,'Kokitaira Vaakko',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001339,30005248,20000767,10000067),(3011205,'Alijula Inaari',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001255,30001356,20000198,10000016),(3011206,'Isurada Visolala',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001249,30001357,20000198,10000016),(3011207,'Hakkasen Sen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001318,30002670,20000391,10000032),(3011208,'Turegasa Unonikko',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001321,30002671,20000391,10000032),(3011209,'Suzakainen Inokakka',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001327,30002671,20000391,10000032),(3011210,'Saakanen Nakkomo',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001324,30002672,20000391,10000032),(3011211,'Saakkatoh Oja',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001264,30002676,20000392,10000032),(3011212,'Uokaa Saikamon',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001261,30002677,20000392,10000032),(3011213,'Ukelula Itama',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001267,30002679,20000392,10000032),(3011214,'Tius Mirtoh',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001258,30002680,20000392,10000032),(3011215,'Akatervo Pemmiya',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001309,30002776,20000407,10000033),(3011216,'Ekietola Oite',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001312,30002776,20000407,10000033),(3011217,'Hamunala Ozino',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001315,30002776,20000407,10000033),(3011218,'Osunen Karjiras',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001306,30002780,20000407,10000033),(3011219,'Ahtaara Arubera',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001348,30002815,20000413,10000033),(3011220,'Utranuolen Jesone',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001351,30002815,20000413,10000033),(3011221,'Ogas Akuras',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001345,30002816,20000413,10000033),(3011222,'Kotatainen Toksen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001342,30002818,20000413,10000033),(3011223,'Hastanen Huukka',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001366,30003057,20000447,10000037),(3011224,'Mikasa Satmoras',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001372,30003057,20000447,10000037),(3011225,'Tashoken Heynojus',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001369,30003058,20000447,10000037),(3011226,'Ikkawa Kaarokin',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001375,30003060,20000447,10000037),(3011227,'Saakkimuka Ishaken',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001282,30003092,20000452,10000038),(3011228,'Hakkomon Mikolala',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001288,30003092,20000452,10000038),(3011229,'Oijelvas Iesipiras',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001291,30003092,20000452,10000038),(3011230,'Uusamon Haanen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001285,30003094,20000452,10000038),(3011231,'Enari Onuomi',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001354,30003394,20000495,10000042),(3011232,'Iltoh Uppuken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001363,30003394,20000495,10000042),(3011233,'Reilen Oshomi',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001357,30003396,20000495,10000042),(3011234,'Jamara Tuopio',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001360,30003397,20000495,10000042),(3011235,'Inkura Uusolanen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001270,30003428,20000500,10000042),(3011236,'Ketsanen Arvanen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001279,30003429,20000500,10000042),(3011237,'Arenmaa Kasoki',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001273,30003430,20000500,10000042),(3011238,'Orma Risarenta',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001276,30003430,20000500,10000042),(3011239,'Alalen Paakayuatoh',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001390,30003836,20000561,10000048),(3011240,'Kasarala Ippojus',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001393,30003836,20000561,10000048),(3011241,'Alloras Erone',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001396,30003836,20000561,10000048),(3011242,'Assa Vikken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001399,30003836,20000561,10000048),(3011243,'Suras Kuikka',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001426,30001409,20000206,10000016),(3011244,'Nabatanen Kokatoiken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001429,30001404,20000206,10000016),(3011245,'Karaka Yansen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001432,30001404,20000206,10000016),(3011246,'Uloken Isamoto',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001435,30002775,20000407,10000033),(3011247,'Astenaisen Seras',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001483,30000119,20000017,10000002),(3011248,'Airatomon Ishomada',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001486,30000119,20000017,10000002),(3011249,'Yaras Notsen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001480,30000120,20000017,10000002),(3011250,'Nansinen Tuon',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001462,30001389,20000203,10000016),(3011251,'Ago Andataila',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001468,30001389,20000203,10000016),(3011252,'Kusken Otiai',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001465,30001391,20000203,10000016),(3011253,'Inuken Hakodan',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001516,30001401,20000205,10000016),(3011254,'Kuhata Susilakko',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001501,30001444,20000212,10000016),(3011255,'Nanmaa Haraila',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001522,30001403,20000205,10000016),(3011256,'Tasira Vaken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001498,30001443,20000212,10000016),(3011257,'Asanas Sanoya',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001504,30001443,20000212,10000016),(3011258,'Vilukki Ihora',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001501,30001444,20000212,10000016),(3011259,'Arichi Asakai',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001492,30002764,20000405,10000033),(3011260,'Sirkkari Isikida',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001489,30002766,20000405,10000033),(3011261,'Adan Inuleri',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001495,30002766,20000405,10000033),(3011262,'Talila Koluoto',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001474,30002767,20000406,10000033),(3011263,'Ishamon Sodamana',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001471,30002770,20000406,10000033),(3011264,'Raulilainen Umunainen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001477,30002772,20000406,10000033),(3011265,'Amuniemi Furanen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001441,30002775,20000407,10000033),(3011266,'Kuurtalen Yatolila',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001438,30002780,20000407,10000033),(3011267,'Yorpas Soukkonen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001507,30002791,20000409,10000033),(3011268,'Rinteras Jimigata',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001513,30002791,20000409,10000033),(3011269,'Anttagas Usena',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001510,30002792,20000409,10000033),(3011270,'Akimo Oksen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001453,30002800,20000411,10000033),(3011271,'Tokaka Junsen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001459,30002804,20000411,10000033),(3011272,'Ruotilaito Semmenen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001456,30002805,20000411,10000033),(3011273,'Sirkkari Aano',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001447,30002815,20000413,10000033),(3011274,'Aakalen Naniro',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001444,30002816,20000413,10000033),(3011275,'Nai Isa',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001450,30002819,20000413,10000033),(3011276,'Kouyonen Kaimienen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001525,30002805,20000411,10000033),(3011277,'Higawiri Uokkio',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001534,30002805,20000411,10000033),(3011278,'Amio Naki',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001537,30000119,20000017,10000002),(3011279,'Kakka Kosama',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001540,30000119,20000017,10000002),(3011280,'Kunkkasen Maekanaiki',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001543,30000119,20000017,10000002),(3011281,'Hivas Aummi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001546,30000119,20000017,10000002),(3011282,'Veinalen Yamatumi',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001642,30000146,20000021,10000002),(3011283,'Otsio Suko',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001636,30000150,20000021,10000002),(3011284,'Auvonen Tavosen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001639,30000150,20000021,10000002),(3011285,'Aakko Tasiwa',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001633,30000151,20000021,10000002),(3011286,'Kan Kuukila',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001591,30000188,20000027,10000002),(3011287,'Aikolen Rautatsakka',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001594,30000188,20000027,10000002),(3011288,'Hirpula Asagas',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001585,30000190,20000027,10000002),(3011289,'Ruumi Oni',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001588,30000193,20000027,10000002),(3011290,'Aukkaa Livonochi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001621,30000195,20000028,10000002),(3011291,'Vetabaisen Iivinonen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001627,30000195,20000028,10000002),(3011292,'Visvas Ekunori',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001630,30000195,20000028,10000002),(3011293,'Endekaras Etsekin',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001624,30000197,20000028,10000002),(3011294,'Isunen Oralukka',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001576,30001394,20000204,10000016),(3011295,'Rossiainen Aanai',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001582,30001394,20000204,10000016),(3011296,'Reilamon Asoinamo',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001573,30001397,20000204,10000016),(3011297,'Ruokalonto Ooki',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001579,30001397,20000204,10000016),(3011298,'Pukegainen Kalolula',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001549,30001410,20000207,10000016),(3011299,'Porveken Maramuri',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001558,30001410,20000207,10000016),(3011300,'Retroken Tari',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001552,30001412,20000207,10000016),(3011301,'Upparas Dan',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001555,30001414,20000207,10000016),(3011302,'Tihitie Masasailen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001561,30002739,20000401,10000033),(3011303,'Orano Dantumi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001564,30002739,20000401,10000033),(3011304,'Kouvo Hagas',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001567,30002739,20000401,10000033),(3011305,'Kasoki Uma',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001570,30002739,20000401,10000033),(3011306,'Inagomo Ibirula',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001597,30002755,20000404,10000033),(3011307,'Oji Haulieras',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001606,30002755,20000404,10000033),(3011308,'Erkkeras Kiyura',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001600,30002756,20000404,10000033),(3011309,'Rashanuoto Haukono',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001603,30002756,20000404,10000033),(3011310,'Parttamon Okoniuras',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001618,30002770,20000406,10000033),(3011311,'Mumken Haanapas',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001612,30002771,20000406,10000033),(3011312,'Mimala Raiskatoh',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001615,30002771,20000406,10000033),(3011313,'Katokka Kollen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001609,30002772,20000406,10000033),(3011314,'Enna Knaatanen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001528,30002803,20000411,10000033),(3011315,'Edanata Aribusa',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001531,30002804,20000411,10000033),(3011316,'Ebunero Nila',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001645,30000147,20000021,10000002),(3011317,'Saaluken Kankiainen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001648,30000148,20000021,10000002),(3011318,'Tobirida Eistoken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001651,30000148,20000021,10000002),(3011319,'Lyyrakemi Mormon',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001654,30000148,20000021,10000002),(3011320,'Airata Mion',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001717,30001362,20000199,10000016),(3011321,'Aoken Pieppatoh',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001720,30001362,20000199,10000016),(3011322,'Shotsayuata Aharas',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001723,30001367,20000199,10000016),(3011323,'Kukkiainen Endateinen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001726,30001367,20000199,10000016),(3011324,'Fuwalama Kokoliri',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001663,30001374,20000201,10000016),(3011325,'Sakama Ruurlamon',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001657,30001375,20000201,10000016),(3011326,'Memaja Aritie',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001660,30001376,20000201,10000016),(3011327,'Ichoda Fukikaga',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001666,30001377,20000201,10000016),(3011328,'Ipas Ueshuskatoh',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001711,30001380,20000202,10000016),(3011329,'Tarovila Ebai',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001708,30001383,20000202,10000016),(3011330,'Taljus Kanaari',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001705,30001384,20000202,10000016),(3011331,'Banninaisen Fuji',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001714,30001385,20000202,10000016),(3011332,'Hayeda Anen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001738,30001421,20000208,10000016),(3011333,'Uuhaken Ineshi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001732,30001422,20000208,10000016),(3011334,'Asola Huoma',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001729,30001423,20000208,10000016),(3011335,'Yanoda Akinen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001735,30001423,20000208,10000016),(3011336,'Nirputsairos Koniras',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001672,30001437,20000211,10000016),(3011337,'Surila Knaatanen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001669,30001438,20000211,10000016),(3011338,'Mutanen Otsaras',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001675,30001439,20000211,10000016),(3011339,'Tykigi Haimulen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001678,30001439,20000211,10000016),(3011340,'Autanen Rauraluola',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001756,30002749,20000403,10000033),(3011341,'Hoishi Aununen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001753,30002751,20000403,10000033),(3011342,'Sumilima Hamunala',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001759,30002751,20000403,10000033),(3011343,'Mahtista Osala',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001762,30002753,20000403,10000033),(3011344,'Itala Aibi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001702,30002767,20000406,10000033),(3011345,'Marukaiken Mamareki',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001696,30002768,20000406,10000033),(3011346,'Hyononeki Taskiraki',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001699,30002772,20000406,10000033),(3011347,'Funaila Hisonamo',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001693,30002774,20000406,10000033),(3011348,'Erunumaa Hotta',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001681,30002775,20000407,10000033),(3011349,'Takomaa Helanevas',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001687,30002775,20000407,10000033),(3011350,'Kos Ogyaras',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001690,30002777,20000407,10000033),(3011351,'Kintura Massiken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001684,30002780,20000407,10000033),(3011352,'Sassainen Aizakonen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001744,30002788,20000409,10000033),(3011353,'Ekulela Alasa',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001750,30002788,20000409,10000033),(3011354,'Aokamon Tsutara',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001741,30002791,20000409,10000033),(3011355,'Aralusa Isugas',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001747,30002792,20000409,10000033),(3011356,'Koyata Mibitei',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001765,30001397,20000204,10000016),(3011357,'Elaruka Ikra',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001807,30000133,20000019,10000002),(3011358,'Ihoura Tahken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001810,30000133,20000019,10000002),(3011359,'Hagaira Inzi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001801,30000162,20000023,10000002),(3011360,'Vira Kortsegas',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001804,30000162,20000023,10000002),(3011361,'Ankai Kankadoishi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001783,30000181,20000026,10000002),(3011362,'Halkkoiken Jakanerva',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001786,30000187,20000026,10000002),(3011363,'Askamon Amamala',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001798,30000196,20000028,10000002),(3011364,'Hameki Joshin',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001795,30000197,20000028,10000002),(3011365,'Raultalainen Aiko',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001780,30001359,20000198,10000016),(3011366,'Tanamailen Areinoki',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001777,30001361,20000198,10000016),(3011367,'Auvenen Saarnio',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001816,30001390,20000203,10000016),(3011368,'Kokukaiken Antisen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001813,30001391,20000203,10000016),(3011369,'Knaatanen Mulanta',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001768,30001395,20000204,10000016),(3011370,'Oijertojus Noki',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001819,30002769,20000406,10000033),(3011371,'Suras Haasoshainen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001822,30002771,20000406,10000033),(3011372,'Akarichi Kogamala',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001789,30002800,20000411,10000033),(3011373,'Onnomon Aarlunen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001792,30002800,20000411,10000033),(3011374,'Noksawa Heimune',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001774,30002815,20000413,10000033),(3011375,'Paahainen Aasti',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001771,30002816,20000413,10000033),(3011376,'Tuikakino Katashainen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001825,30000156,20000022,10000002),(3011377,'Kaparas Saikanen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001831,30000153,20000022,10000002),(3011378,'Tantima Kiukko',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001930,30005309,20000777,10000068),(3011379,'Ma Kassen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001921,30005310,20000777,10000068),(3011380,'Kaskovuo Kuri',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001924,30005310,20000777,10000068),(3011381,'Rekuloho Moirutami',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001927,30005313,20000777,10000068),(3011382,'Soravuo Assen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001951,30005322,20000779,10000068),(3011383,'Kashuken Eralen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001954,30005322,20000779,10000068),(3011384,'Umadara Oturomi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001945,30005324,20000779,10000068),(3011385,'Pakimato Kein',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001948,30005328,20000779,10000068),(3011386,'Nakkelen Vaupero',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001828,30000156,20000022,10000002),(3011387,'Oharaga Tarkko',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001834,30000156,20000022,10000002),(3011388,'Aarakaarto Harskaken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001873,30000165,20000024,10000002),(3011389,'Navala Izora',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001879,30000167,20000024,10000002),(3011390,'Niurihokka Okanini',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001882,30000168,20000024,10000002),(3011391,'Sukakki Vaanen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001876,30000169,20000024,10000002),(3011392,'Ooki Uchonen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001900,30001703,20000252,10000020),(3011393,'Hitodan Setsepailen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001903,30001703,20000252,10000020),(3011394,'Kovas Yartenaima',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001906,30001703,20000252,10000020),(3011395,'Kossitoh Atshonen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001897,30001705,20000252,10000020),(3011396,'Hokkiras Paaseraisen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001996,30002077,20000306,10000042),(3011397,'Kiainti Sutkamaa',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001999,30002077,20000306,10000042),(3011398,'Satoh Endekaras',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002002,30002079,20000306,10000042),(3011399,'Tetarumi Ahakka',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001993,30002080,20000306,10000042),(3011400,'Pira Kaltonen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001840,30002562,20000376,10000030),(3011401,'Ursarinen Aakiwa',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001843,30002562,20000376,10000030),(3011402,'Adashami Hankkama',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001846,30002562,20000376,10000030),(3011403,'Kakamada Susiya',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001837,30002566,20000376,10000030),(3011404,'Kulkkinen Alti',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001864,30002659,20000389,10000032),(3011405,'Okila Kavas',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001867,30002659,20000389,10000032),(3011406,'Saisima Anokai',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001861,30002660,20000389,10000032),(3011407,'Nukanata Amatura',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001870,30002660,20000389,10000032),(3011408,'Manekila Uisen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001885,30003342,20000487,10000041),(3011409,'Abuta Hiekilen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001891,30003342,20000487,10000041),(3011410,'Varvala Osa',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001894,30003342,20000487,10000041),(3011411,'Arvalo Ho',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001888,30003343,20000487,10000041),(3011412,'Kolmon Chiskanen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001939,30003434,20000501,10000042),(3011413,'Miniviras Ilkke',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001933,30003436,20000501,10000042),(3011414,'Oinu Nunetago',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001936,30003436,20000501,10000042),(3011415,'Ruunamon Ieyarai',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001942,30003436,20000501,10000042),(3011416,'Kogas Uoken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001852,30003796,20000554,10000048),(3011417,'Erkkilen Era',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001858,30003796,20000554,10000048),(3011418,'Eratsaka Osha',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001849,30003799,20000554,10000048),(3011419,'Akeri Inisoho',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001855,30003799,20000554,10000048),(3011420,'Yanaguno Asine',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001984,30005025,20000735,10000064),(3011421,'Penolaanen Ihamada',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001981,30005026,20000735,10000064),(3011422,'Saskiken Ookaka',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001987,30005026,20000735,10000064),(3011423,'Rijokka Rairtomaa',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001990,30005026,20000735,10000064),(3011424,'Orsanakka Hun',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001909,30005050,20000739,10000065),(3011425,'Urpara Nashirai',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001912,30005050,20000739,10000065),(3011426,'Hien Kaparas',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001918,30005050,20000739,10000065),(3011427,'Immuri Outabe',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001915,30005051,20000739,10000065),(3011428,'Tahtiainen Kalato',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001975,30005069,20000742,10000065),(3011429,'Sannas Ozinaro',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001972,30005070,20000742,10000065),(3011430,'Hike Tugora',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001978,30005070,20000742,10000065),(3011431,'Onereki Uoyaki',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001969,30005072,20000742,10000065),(3011432,'Joukka Ourajanen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001966,30005076,20000743,10000065),(3011433,'Oriaineras Ohvari',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001957,30005078,20000743,10000065),(3011434,'Herpalen Pikoila',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001963,30005078,20000743,10000065),(3011435,'Rishenen Oijanen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60001960,30005080,20000743,10000065),(3011436,'Annomainen Verupas',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002005,30001402,20000205,10000016),(3011437,'Ake Sainen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002047,30000133,20000019,10000002),(3011438,'Tadaniki Pokka',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002050,30000133,20000019,10000002),(3011439,'Oksylaanen Orenen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002059,30000148,20000021,10000002),(3011440,'Hyastilen Tetvolen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002062,30000148,20000021,10000002),(3011441,'Maskiainen Olkkunen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002014,30001365,20000199,10000016),(3011442,'Ylama Saziras',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002011,30001366,20000199,10000016),(3011443,'Sanlalaila Alerela',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002038,30001380,20000202,10000016),(3011444,'Koivarairos Orma',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002035,30001384,20000202,10000016),(3011445,'Taneri Ohkanen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002008,30001398,20000205,10000016),(3011446,'Saila Sunmaa',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002017,30001411,20000207,10000016),(3011447,'Moineri Kortilailen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002020,30001412,20000207,10000016),(3011448,'Aiga Ylala',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002053,30001430,20000210,10000016),(3011449,'Akiai Tayukainen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002056,30001432,20000210,10000016),(3011450,'Nonniainen Hanaida',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002026,30002751,20000403,10000033),(3011451,'Peranida Purtomoki',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002023,30002754,20000403,10000033),(3011452,'Jatate Hiravo',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002029,30002755,20000404,10000033),(3011453,'Etsatei Yada',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002032,30002755,20000404,10000033),(3011454,'Immonairos Iros',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002041,30002815,20000413,10000033),(3011455,'Torimanoi Vittoh',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002044,30002816,20000413,10000033),(3011456,'Eronpaa Aaromon',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002065,30001393,20000204,10000016),(3011457,'Orulen Arala',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002116,30003482,20000508,10000043),(3011458,'Pokireda Kummitoimon',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002122,30003485,20000508,10000043),(3011459,'Ekulela Siakkawai',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002113,30003486,20000508,10000043),(3011460,'Olkkenen Osa',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002119,30003486,20000508,10000043),(3011461,'Sakehama Kannainen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002173,30003488,20000509,10000043),(3011462,'Kannanen Harpas',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002176,30003488,20000509,10000043),(3011463,'Ohmolen Uoro',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002179,30003488,20000509,10000043),(3011464,'Kangas Suori',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002182,30003488,20000509,10000043),(3011465,'Ikkari Yakin',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002152,30003800,20000555,10000048),(3011466,'Ichomala Nakilola',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002149,30003801,20000555,10000048),(3011467,'Ariken Kutsu',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002158,30003801,20000555,10000048),(3011468,'Itkonen Ato',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002155,30003805,20000555,10000048),(3011469,'Kukayaki Ukkila',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002227,30005009,20000733,10000064),(3011470,'Ya Alhunaya',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002230,30005009,20000733,10000064),(3011471,'Uminami Ozanen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002224,30005010,20000733,10000064),(3011472,'Kinachi Hepimeki',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002221,30005012,20000733,10000064),(3011473,'Karnuras Ulalima',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002215,30005037,20000737,10000065),(3011474,'Heinulaila Suola',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002209,30005038,20000737,10000065),(3011475,'Nittara Hikkoken',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002212,30005038,20000737,10000065),(3011476,'Areneni Utalola',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002218,30005041,20000737,10000065),(3011477,'Shuhola Aularoila',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002236,30000188,20000027,10000002),(3011478,'Ahudoki Imola',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002233,30000190,20000027,10000002),(3011479,'Artovas Sodamana',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002242,30000192,20000027,10000002),(3011480,'Maaltula Akora',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002239,30000194,20000027,10000002),(3011481,'Kaseshita Vuorila',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002068,30001394,20000204,10000016),(3011482,'Aikawa Ren',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002071,30001394,20000204,10000016),(3011483,'Ekise Koruda',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002074,30001394,20000204,10000016),(3011484,'Toma Iwahira',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002164,30001443,20000212,10000016),(3011485,'Arunmaa Limmamon',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002170,30001443,20000212,10000016),(3011486,'Nuosiken Raulmanen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002167,30001444,20000212,10000016),(3011487,'Kabe Haunanen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002161,30001448,20000212,10000016),(3011488,'Aumi Amachi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002185,30001670,20000247,10000020),(3011489,'Tuotoh Kanaari',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002188,30001670,20000247,10000020),(3011490,'Huunashin Varnen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002191,30001670,20000247,10000020),(3011491,'Poirmavas Isoya',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002194,30001673,20000247,10000020),(3011492,'Lonpaa Aivoli',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002083,30001695,20000251,10000020),(3011493,'Ippas Tojawara',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002077,30001696,20000251,10000020),(3011494,'Viritie Arata',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002086,30001696,20000251,10000020),(3011495,'Maksesen Ruulula',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002080,30001698,20000251,10000020),(3011496,'Ila Pavira',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002125,30002090,20000308,10000042),(3011497,'Tasuda Iwataya',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002134,30002090,20000308,10000042),(3011498,'Versanen Osoni',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002128,30002093,20000308,10000042),(3011499,'Tetsome Vatsivas',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002131,30002095,20000308,10000042),(3011500,'Sarulailen Oinokjus',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002095,30002670,20000391,10000032),(3011501,'Kotsiainen Unenailen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002098,30002672,20000391,10000032),(3011502,'Kemiloto Kiwa',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002089,30002672,20000391,10000032),(3011503,'Puukkoraka Runjalen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002092,30002672,20000391,10000032),(3011504,'Raussinen Hastoh',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002197,30003066,20000448,10000038),(3011505,'Saakkatoh Okanami',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002203,30003067,20000448,10000038),(3011506,'Arpoken Okakola',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002200,30003068,20000448,10000038),(3011507,'Hyononeki Maan',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002206,30003068,20000448,10000038),(3011508,'Ruunuken Vulli',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002101,30003368,20000491,10000041),(3011509,'Tsilo Ralttilo',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002104,30003368,20000491,10000041),(3011510,'Aulamon Ahtulen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002107,30003371,20000491,10000041),(3011511,'Marrada Itonula',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002110,30003373,20000491,10000041),(3011512,'Inkojus Kassugaiki',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002137,30003389,20000494,10000042),(3011513,'Isantani Igas',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002140,30003389,20000494,10000042),(3011514,'Ylomaa Isen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002143,30003390,20000494,10000042),(3011515,'Hosoras Ieyahomon',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002146,30003392,20000494,10000042),(3011516,'Suonio Erkola',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002245,30001404,20000206,10000016),(3011517,'Erokura Mikata',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002284,30000167,20000024,10000002),(3011518,'Yantiken Olkkushin',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002281,30000168,20000024,10000002),(3011519,'Ozomawa Fursira',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002287,30000168,20000024,10000002),(3011520,'Okila Tsurvalen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002290,30000171,20000024,10000002),(3011521,'Urishainen Ati',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002278,30000175,20000025,10000002),(3011522,'Arameki Kulmonuola',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002272,30000176,20000025,10000002),(3011523,'Moikkoshin Ebashin',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002269,30000178,20000025,10000002),(3011524,'Sakkatokka Limsen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002275,30000179,20000025,10000002),(3011525,'Anttanen Aksen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002359,30000180,20000026,10000002),(3011526,'Elanoda Popas',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002353,30000181,20000026,10000002),(3011527,'Ahtamon Pavanakka',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002356,30000183,20000026,10000002),(3011528,'Ure Kasenumi',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002362,30000185,20000026,10000002),(3011529,'Tatsari Vaheda',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002305,30001399,20000205,10000016),(3011530,'Mislolen Issazainen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002308,30001401,20000205,10000016),(3011531,'Kokanogi Hayeda',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002311,30001401,20000205,10000016),(3011532,'Itila Varavola',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002314,30001402,20000205,10000016),(3011533,'Umunmaa Korakela',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002248,30001405,20000206,10000016),(3011534,'Panakiya Nakkilen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002251,30001406,20000206,10000016),(3011535,'Tattilen Ylandoki',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002254,30001406,20000206,10000016),(3011536,'Olonashi Nokka',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002317,30001424,20000209,10000016),(3011537,'Karas Tsurvalen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002323,30001424,20000209,10000016),(3011538,'Kantoh Putolen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002320,30001425,20000209,10000016),(3011539,'Arila Okanen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002326,30001429,20000209,10000016),(3011540,'Korsosen Etsalen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002341,30001437,20000211,10000016),(3011541,'Paara Nikkaken',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002344,30001437,20000211,10000016),(3011542,'Ojai Arokarri',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002347,30001437,20000211,10000016),(3011543,'Pyynola Isamioken',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002350,30001438,20000211,10000016),(3011544,'Isoila Okitoh',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002293,30002737,20000401,10000033),(3011545,'Mervas Erjus',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002296,30002738,20000401,10000033),(3011546,'Harroken Shinunula',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002299,30002739,20000401,10000033),(3011547,'Mulanta Kikuyaki',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002302,30002741,20000401,10000033),(3011548,'Eistenen Arveras',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002338,30002767,20000406,10000033),(3011549,'Uusamon Egoshi',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002332,30002768,20000406,10000033),(3011550,'Armie Hinashushi',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002329,30002771,20000406,10000033),(3011551,'Hielukka Kajanainen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002335,30002773,20000406,10000033),(3011552,'Itirikko Innishi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002263,30002788,20000409,10000033),(3011553,'Kariwa Eistaken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002266,30002788,20000409,10000033),(3011554,'Kotkamatsu Millomon',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002260,30002790,20000409,10000033),(3011555,'Aivira Ogimo',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002257,30002792,20000409,10000033),(3011556,'Teis Shusiainen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002368,30001358,20000198,10000016),(3011557,'Ikra Egara',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002422,30000165,20000024,10000002),(3011558,'Isoma Juhenius',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002425,30000165,20000024,10000002),(3011559,'Atshurai Sasiekko',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002377,30000202,20000029,10000002),(3011560,'Paakadan Konken',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002374,30000203,20000029,10000002),(3011561,'Hotutani Akukiri',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002371,30001361,20000198,10000016),(3011562,'Ootoh Litiura',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002416,30001362,20000199,10000016),(3011563,'Ueshisen Orane',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002377,30000202,20000029,10000002),(3011564,'Ranttika Mirmiken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002407,30001380,20000202,10000016),(3011565,'Tsupamon Aloto',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002404,30001382,20000202,10000016),(3011566,'Olkkosen Mitokka',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002386,30001386,20000203,10000016),(3011567,'Semmenen Isokava',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002389,30001386,20000203,10000016),(3011568,'Konkomatsu Pahula',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002392,30001397,20000204,10000016),(3011569,'Ibaras Suomo',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002395,30001397,20000204,10000016),(3011570,'Tykigi Okanula',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002398,30001437,20000211,10000016),(3011571,'Oyeneki Shittoh',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002401,30001437,20000211,10000016),(3011572,'Roikunen Tsuvarachi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002383,30002744,20000402,10000033),(3011573,'Hakin Ookirai',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002380,30002745,20000402,10000033),(3011574,'Tubara Inaken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002413,30002800,20000411,10000033),(3011575,'Iseto Airasen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002410,30002801,20000411,10000033),(3011576,'Pukkala Janmaa',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002428,30000154,20000022,10000002),(3011577,'Jais Watiken',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002437,30000153,20000022,10000002),(3011578,'Yomon Narika',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002440,30000153,20000022,10000002),(3011579,'Arochi Aivula',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002482,30001674,20000247,10000020),(3011580,'Yahutola Oissio',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002488,30001674,20000247,10000020),(3011581,'Tokinala Sela',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002446,30001729,20000256,10000020),(3011582,'Otetula Kilkkuken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002452,30001729,20000256,10000020),(3011583,'Alonaga Saisio',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002455,30001730,20000256,10000020),(3011584,'Joukoras Rimaremi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002458,30001732,20000256,10000020),(3011585,'Hoiksanen Shitsu',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002461,30001732,20000256,10000020),(3011586,'Hintanen Tasiwa',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002449,30001733,20000256,10000020),(3011587,'Jakka Imaka',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002545,30002049,20000302,10000042),(3011588,'Paranaki Vandenen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002536,30002051,20000302,10000042),(3011589,'Ogomi Eroken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002539,30002051,20000302,10000042),(3011590,'Paatsomaito Ogikito',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002548,30002051,20000302,10000042),(3011591,'Ylomainen Asairtakka',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002542,30002052,20000302,10000042),(3011592,'Raishumailen Nelula',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002551,30002052,20000302,10000042),(3011593,'Horolaala Tyken',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002569,30002187,20000322,10000043),(3011594,'Penoksa Upposen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002557,30002188,20000322,10000043),(3011595,'Ieyashionen Ahteri',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002563,30002188,20000322,10000043),(3011596,'Kara Ueshano',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002554,30002190,20000322,10000043),(3011597,'Asetila Ikishano',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002560,30002195,20000322,10000043),(3011598,'Kanikko Kora',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002566,30002195,20000322,10000043),(3011599,'Ukras Kawiki',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002668,30002277,20000334,10000043),(3011600,'Auras Umenen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002671,30002278,20000334,10000043),(3011601,'Hissaras Aragas',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002665,30002281,20000334,10000043),(3011602,'Kikera Hetulato',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002674,30002281,20000334,10000043),(3011603,'Hoken Isikesu',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002677,30002281,20000334,10000043),(3011604,'Nimala Puori',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002662,30002282,20000334,10000043),(3011605,'Santera Mimiraila',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002686,30002396,20000352,10000028),(3011606,'Pakko Sakanin',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002680,30002397,20000352,10000028),(3011607,'Kurrisen Arinuomo',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002689,30002397,20000352,10000028),(3011608,'Suokakko Niwazino',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002683,30002399,20000352,10000028),(3011609,'Vannanen Iijata',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002692,30002399,20000352,10000028),(3011610,'Otvas Linachi',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002695,30002399,20000352,10000028),(3011611,'Yoemmono Tatimala',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002590,30002537,20000372,10000030),(3011612,'Nikkizaiki Nukka',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002596,30002537,20000372,10000030),(3011613,'Naninen Hiraken',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002599,30002537,20000372,10000030),(3011614,'Tavanula Saari',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002593,30002539,20000372,10000030),(3011615,'Otsulen Sapala',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002602,30002539,20000372,10000030),(3011616,'Oikanda Rokila',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002605,30002540,20000372,10000030),(3011617,'Ohki Okki',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002626,30002686,20000393,10000032),(3011618,'Huomaila Kebashi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002629,30002686,20000393,10000032),(3011619,'Varppavas Hirmaken',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002632,30002686,20000393,10000032),(3011620,'Vistoya Taranogas',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002635,30002686,20000393,10000032),(3011621,'Patsaka Valmodan',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002641,30002687,20000393,10000032),(3011622,'Huovinni Jama',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002638,30002689,20000393,10000032),(3011623,'Sohokka Aketiya',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002476,30002731,20000400,10000032),(3011624,'Muras Ohvalainen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002479,30002732,20000400,10000032),(3011625,'Povula Valelin',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002464,30002733,20000400,10000032),(3011626,'Rilmivaira Uusuwaiken',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002470,30002733,20000400,10000032),(3011627,'Fukkenukka Kola',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002473,30002733,20000400,10000032),(3011628,'Koinas Ha',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002467,30002735,20000400,10000032),(3011629,'Iivonen Ametera',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002614,30002794,20000410,10000033),(3011630,'Moi Senota',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002608,30002796,20000410,10000033),(3011631,'Ilken Akakiomaa',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002611,30002796,20000410,10000033),(3011632,'Satimi Pukrukela',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002617,30002798,20000410,10000033),(3011633,'Tira Paakkodan',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002620,30002798,20000410,10000033),(3011634,'Ichinumi Toilinala',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002623,30002798,20000410,10000033),(3011635,'Oilari Oineshin',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002500,30002995,20000439,10000036),(3011636,'Olkkanen Umikka',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002503,30002995,20000439,10000036),(3011637,'Seda Kushanula',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002509,30002996,20000439,10000036),(3011638,'Vassen Rusken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002506,30003000,20000439,10000036),(3011639,'Vaisen Kyskasakka',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002512,30003000,20000439,10000036),(3011640,'Isawara Erkkeras',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002515,30003000,20000439,10000036),(3011641,'Koshotela Gemppiras',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002650,30003038,20000445,10000037),(3011642,'Asabe Otukuya',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002659,30003040,20000445,10000037),(3011643,'Honiomi Supasen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002647,30003041,20000445,10000037),(3011644,'Yorkkaitoh Ochiriemi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002653,30003041,20000445,10000037),(3011645,'Hirtamon Onirvura',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002644,30003042,20000445,10000037),(3011646,'Ikita Jusken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002656,30003042,20000445,10000037),(3011647,'Puskiainen Chirunava',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002518,30003368,20000491,10000041),(3011648,'Narmaken Kovaras',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002533,30003369,20000491,10000041),(3011649,'Karras Ikkola',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002527,30003370,20000491,10000041),(3011650,'Astanen Saskava',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002530,30003370,20000491,10000041),(3011651,'Egino Erashin',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002524,30003371,20000491,10000041),(3011652,'Mugora Akatervo',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002521,30003372,20000491,10000041),(3011653,'Sikupula Iivasunen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002584,30005050,20000739,10000065),(3011654,'Airivas Ichomala',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002587,30005051,20000739,10000065),(3011655,'Tarawa Elola',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002572,30005053,20000739,10000065),(3011656,'Okadoma Shikkashin',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002578,30005053,20000739,10000065),(3011657,'Iju Elarola',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002581,30005053,20000739,10000065),(3011658,'Haima Toilotainen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002575,30005054,20000739,10000065),(3011659,'Abata Kojelainen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002431,30000156,20000022,10000002),(3011660,'Astobainen Kia',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002434,30000157,20000022,10000002),(3011661,'Sautitara Munevailen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002443,30000158,20000022,10000002),(3011662,'Kahala Okilen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002485,30001671,20000247,10000020),(3011663,'Niuchi Sobaseki',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002491,30001671,20000247,10000020),(3011664,'Alaoutitoh Hevulainen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002497,30001671,20000247,10000020),(3011665,'Ourinainen Ebata',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002494,30001673,20000247,10000020),(3011666,'Kaka Rachi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002698,30002778,20000407,10000033),(3011667,'Tatsoras Eerolilen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002716,30002764,20000405,10000033),(3011668,'Selen Iwalula',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002719,30002764,20000405,10000033),(3011669,'Tokkitoh Saasanmaa',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002722,30002766,20000405,10000033),(3011670,'Nemeri Iwara',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002701,30002776,20000407,10000033),(3011671,'Kaimon Ininerva',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002704,30002778,20000407,10000033),(3011672,'Sakila Etanen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002710,30002788,20000409,10000033),(3011673,'Vakkibasen Pinuta',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002707,30002789,20000409,10000033),(3011674,'Askalaisen Oni',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002713,30002792,20000409,10000033),(3011675,'Kirase Nupiroda',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002731,30002802,20000411,10000033),(3011676,'Ihukio Hinpas',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002725,30002804,20000411,10000033),(3011677,'Ohminen Saskora',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002728,30002804,20000411,10000033),(3011678,'Kauliken Uusazoken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002734,30000146,20000021,10000002),(3011679,'Tuunani Tamarri',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002887,30001384,20000202,10000016),(3011680,'Wuompelen Nosara',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002803,30001404,20000206,10000016),(3011681,'Kantonen Haarsanen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002797,30001405,20000206,10000016),(3011682,'Paranen Haskallio',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002800,30001406,20000206,10000016),(3011683,'Niemi Terpala',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002788,30001408,20000206,10000016),(3011684,'Vienari Puumon',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002791,30001409,20000206,10000016),(3011685,'Juma Roikikasvio',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002794,30001409,20000206,10000016),(3011686,'Batoh Ichiraiken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002866,30002762,20000405,10000033),(3011687,'Ozisami Mahoken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002872,30002762,20000405,10000033),(3011688,'Netsalakka Arilen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002875,30002762,20000405,10000033),(3011689,'Tartoken Nosen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002869,30002764,20000405,10000033),(3011690,'Aakonoshin Piertalen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002860,30002765,20000405,10000033),(3011691,'Hotvas Velenamo',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002863,30002766,20000405,10000033),(3011692,'Aula Koitonen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002752,30002775,20000407,10000033),(3011693,'Ilta Majala',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002758,30002776,20000407,10000033),(3011694,'Igase Visola',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002764,30002776,20000407,10000033),(3011695,'Sanagechi Kuikara',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002755,30002779,20000407,10000033),(3011696,'Inavala Egaruopas',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002761,30002779,20000407,10000033),(3011697,'Oinorolen Ocho',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002767,30002780,20000407,10000033),(3011698,'Palumola Kaarvonen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002773,30002782,20000408,10000033),(3011699,'Rammeki Jushin',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002776,30002784,20000408,10000033),(3011700,'Tanashaiken Aurila',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002782,30002784,20000408,10000033),(3011701,'Illen Hasunmaa',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002770,30002786,20000408,10000033),(3011702,'Sirvula Isinen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002779,30002786,20000408,10000033),(3011703,'Eskauchi Koiltawailen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002785,30002786,20000408,10000033),(3011704,'Parttamon Anha',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002836,30002800,20000411,10000033),(3011705,'Vaittanen Uesharas',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002827,30002801,20000411,10000033),(3011706,'Kasata Kuulemonmaa',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002824,30002802,20000411,10000033),(3011707,'Honen Alti',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002833,30002802,20000411,10000033),(3011708,'Shitula Akama',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002830,30002804,20000411,10000033),(3011709,'Hietoken Tuken',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002839,30002804,20000411,10000033),(3011710,'Oilenen Inuki',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002746,30000147,20000021,10000002),(3011711,'Keikira Pakkashin',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002737,30000148,20000021,10000002),(3011712,'Ichinita Huovatero',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002743,30000148,20000021,10000002),(3011713,'Suskeino Pomari',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002749,30000148,20000021,10000002),(3011714,'Akkaras Shigakarri',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002740,30000149,20000021,10000002),(3011715,'Sorkakaala Viura',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002806,30000153,20000022,10000002),(3011716,'Arajailen Korinen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002809,30000153,20000022,10000002),(3011717,'Tonneki Villasen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002818,30000153,20000022,10000002),(3011718,'Irsen Otinada',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002812,30000154,20000022,10000002),(3011719,'Mikolala Paarosen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002821,30000156,20000022,10000002),(3011720,'Kukkoluoma Joksimo',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002815,30000158,20000022,10000002),(3011721,'Keilen Watashama',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002854,30000175,20000025,10000002),(3011722,'Koikiainen Okijerva',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002857,30000175,20000025,10000002),(3011723,'Uranen Surtilen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002845,30000176,20000025,10000002),(3011724,'Akitamo Funtari',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002842,30000177,20000025,10000002),(3011725,'Kotsiliola Panshin',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002848,30000177,20000025,10000002),(3011726,'Kokken Tankitainen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002851,30000179,20000025,10000002),(3011727,'Kollamon Okichoshi',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002911,30001362,20000199,10000016),(3011728,'Nannanshainen Ibotela',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002896,30001364,20000199,10000016),(3011729,'Sienatsu Arenpaa',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002908,30001364,20000199,10000016),(3011730,'Kamaala Ononala',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002902,30001365,20000199,10000016),(3011731,'Omae Adora',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002905,30001365,20000199,10000016),(3011732,'Sirotova Uesi',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002899,30001367,20000199,10000016),(3011733,'Ichiestokka Ronken',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002884,30001381,20000202,10000016),(3011734,'Mislolen Paukukaiken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002893,30001382,20000202,10000016),(3011735,'Hisailvorri Heisatailen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002878,30001383,20000202,10000016),(3011736,'Kiras Vintoh',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002890,30001383,20000202,10000016),(3011737,'Miskavas Ichonen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002881,30001384,20000202,10000016),(3011738,'Tuoralen Kaavala',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002914,30001403,20000205,10000016),(3011739,'Sawalola Hevulainen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002998,30000132,20000019,10000002),(3011740,'Tsultinumi Takoshada',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003001,30000132,20000019,10000002),(3011741,'Hoshikila Yarela',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003004,30000137,20000019,10000002),(3011742,'Immuri Nistoya',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003007,30000137,20000019,10000002),(3011743,'Haapio Aarnalen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002953,30000142,20000020,10000002),(3011744,'Ralken Aikinen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002959,30000142,20000020,10000002),(3011745,'Tarovila Tarpas',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002950,30000143,20000020,10000002),(3011746,'Katken Shitaluma',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002956,30000144,20000020,10000002),(3011747,'Hageken Ieri',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002977,30001356,20000198,10000016),(3011748,'Tokken Ga',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002980,30001357,20000198,10000016),(3011749,'Harkkiainen Airai',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002974,30001358,20000198,10000016),(3011750,'Torvas Kojaken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002983,30001360,20000198,10000016),(3011751,'Haakamaitoh Manekila',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002971,30001374,20000201,10000016),(3011752,'Mori Eroda',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002965,30001375,20000201,10000016),(3011753,'Akashi Iivalen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002962,30001376,20000201,10000016),(3011754,'Keuchi Adomago',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002968,30001378,20000201,10000016),(3011755,'Ossen Unonen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002926,30001390,20000203,10000016),(3011756,'Sundan Ebenoshi',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002929,30001390,20000203,10000016),(3011757,'Hunttanen Amasen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002932,30001390,20000203,10000016),(3011758,'Uesa Kurtsunen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002935,30001390,20000203,10000016),(3011759,'Kariemi Tankitainen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002920,30001400,20000205,10000016),(3011760,'Asosainen Umachi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002923,30001400,20000205,10000016),(3011761,'Haitnanmaa Jishadan',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002917,30001401,20000205,10000016),(3011762,'Tuuraleto Ibubota',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003013,30001418,20000208,10000016),(3011763,'Veiriya Santo',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003019,30001418,20000208,10000016),(3011764,'Tamo Heinulaila',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003010,30001419,20000208,10000016),(3011765,'Ippara Orsaisio',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003016,30001419,20000208,10000016),(3011766,'Fu Alameya',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002941,30001439,20000211,10000016),(3011767,'Veinepas Mattila',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002938,30001441,20000211,10000016),(3011768,'Tsusonda Kolkkoken',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002944,30001441,20000211,10000016),(3011769,'Nilen Koinahaila',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002947,30001441,20000211,10000016),(3011770,'Hirtalen Umonoi',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003031,30002800,20000411,10000033),(3011771,'Kihtukainen Onegas',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003022,30002802,20000411,10000033),(3011772,'Syhken Ylina',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003025,30002802,20000411,10000033),(3011773,'Ahvaken Tommii',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003028,30002804,20000411,10000033),(3011774,'Tananola Naninen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002986,30002815,20000413,10000033),(3011775,'Kamela Ittaunio',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002992,30002817,20000413,10000033),(3011776,'Paatonen Aromiwa',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002995,30002818,20000413,10000033),(3011777,'Raurisen Ohmanin',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60002989,30002819,20000413,10000033),(3011778,'Otanida Tara',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003034,30000157,20000022,10000002),(3011779,'Nenmaa Hemara',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003067,30000119,20000017,10000002),(3011780,'Wahmiras Edamon',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003061,30000120,20000017,10000002),(3011781,'Halmaganda Aaho',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003064,30000123,20000017,10000002),(3011782,'Tashatsu Arula',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003082,30000128,20000018,10000002),(3011783,'Geshozura Manoi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003079,30000131,20000018,10000002),(3011784,'Wakkinen Puramaya',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003085,30000131,20000018,10000002),(3011785,'Atshonen Soiken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003106,30000133,20000019,10000002),(3011786,'Tormalaiken Machiro',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003109,30000134,20000019,10000002),(3011787,'Isila Imazaiken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003112,30000136,20000019,10000002),(3011788,'Kiomi Inanumaa',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003109,30000134,20000019,10000002),(3011789,'Tukumo Tuukka',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003106,30000133,20000019,10000002),(3011790,'Itima Ohmoganen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003058,30000143,20000020,10000002),(3011791,'Vinen Kasenumi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003037,30000157,20000022,10000002),(3011792,'Arkono Ishegas',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003040,30000158,20000022,10000002),(3011793,'Kalakaaras Alamola',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003049,30000161,20000023,10000002),(3011794,'Erkkenen Uchinala',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003046,30000162,20000023,10000002),(3011795,'Kaila Ietsio',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003043,30000163,20000023,10000002),(3011796,'Okakko Nantomon',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003073,30000180,20000026,10000002),(3011797,'Matkuwa Moras',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003070,30000181,20000026,10000002),(3011798,'Vin Vattoh',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003076,30000185,20000026,10000002),(3011799,'Asinoro Hanaruwa',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003118,30002785,20000408,10000033),(3011800,'Shi Ochiya',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003088,30001365,20000199,10000016),(3011801,'Rotsuda Kekkomsa',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003091,30001367,20000199,10000016),(3011802,'Adomago Karjus',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003115,30002783,20000408,10000033),(3011803,'Maltoras Hiskatoh',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003121,30002783,20000408,10000033),(3011804,'Kahmaken Wamonen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003118,30002785,20000408,10000033),(3011805,'Inanen Hakkonus',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003100,30002806,20000412,10000033),(3011806,'Ninkkakas Alari',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003103,30002810,20000412,10000033),(3011807,'Renen Kirtikko',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003097,30002811,20000412,10000033),(3011808,'Valtoh Pa',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003124,30001400,20000205,10000016),(3011809,'Shihanen Sagudora',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003151,30000132,20000019,10000002),(3011810,'Ishimieto Vairosen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003148,30000134,20000019,10000002),(3011811,'Ajeleto Ulen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003139,30000154,20000022,10000002),(3011812,'Kontomon Morppanen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003136,30000156,20000022,10000002),(3011813,'Olosen Kistigas',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003145,30000161,20000023,10000002),(3011814,'Ponkenen Magutatoh',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003142,30000162,20000023,10000002),(3011815,'Arino Autinen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003175,30000195,20000028,10000002),(3011816,'Olakokka Ieyoshadan',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003172,30000200,20000028,10000002),(3011817,'Eramoda Sosusuro',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003178,30000202,20000029,10000002),(3011818,'Hikka Silvas',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003181,30000202,20000029,10000002),(3011819,'Sula Kate',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003154,30001393,20000204,10000016),(3011820,'Oiras Varas',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003157,30001395,20000204,10000016),(3011821,'Alurila Hitsunen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003127,30001401,20000205,10000016),(3011822,'Anzaima Raganula',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003160,30002751,20000403,10000033),(3011823,'Tanokairos Haila',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003163,30002751,20000403,10000033),(3011824,'Dagi Pahtami',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003166,30002764,20000405,10000033),(3011825,'Reisen Ienakkamon',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003169,30002765,20000405,10000033),(3011826,'Elalen Heinnonen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003130,30002783,20000408,10000033),(3011827,'Autinen Shioksagai',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003133,30002785,20000408,10000033),(3011828,'Josachoya Isheda',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003184,30001357,20000198,10000016),(3011829,'Vikumaa Palken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003226,30000128,20000018,10000002),(3011830,'Arai Suosaken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003229,30000128,20000018,10000002),(3011831,'Kakalin Ursaasio',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003238,30000161,20000023,10000002),(3011832,'Onodora Veiriya',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003241,30000163,20000023,10000002),(3011833,'Taya Sorila',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003208,30000169,20000024,10000002),(3011834,'Kukkankasvio Kalmon',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003211,30000170,20000024,10000002),(3011835,'Kilori Otnen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003190,30000181,20000026,10000002),(3011836,'Edara Tolaskita',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003193,30000182,20000026,10000002),(3011837,'Ritsakanen Arichi',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003187,30001360,20000198,10000016),(3011838,'Bakkata Jouragainen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003220,30001376,20000201,10000016),(3011839,'Techono Pesin',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003223,30001376,20000201,10000016),(3011840,'Yabanuta Anashi',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003199,30001408,20000206,10000016),(3011841,'Kakukainen Urho',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003196,30001409,20000206,10000016),(3011842,'Hishanimo Kidurouchi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003232,30001440,20000211,10000016),(3011843,'Aurunen Ijaris',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003235,30001441,20000211,10000016),(3011844,'Anniainen Aizaris',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003217,30002740,20000401,10000033),(3011845,'Takinta Hut',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003214,30002741,20000401,10000033),(3011846,'Nasuwari Litoh',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003202,30002764,20000405,10000033),(3011847,'Arameki Ulalari',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003205,30002764,20000405,10000033),(3011848,'Shunkoken Pojus',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003244,30000126,20000018,10000002),(3011849,'Kompiras Ylontai',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003247,30000128,20000018,10000002),(3011850,'Okanaka Ahvoken',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003298,30001376,20000201,10000016),(3011851,'Ursinen Tovari',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003301,30001376,20000201,10000016),(3011852,'Huutokonen Huoya',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003322,30001395,20000204,10000016),(3011853,'Josasaya Nagas',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003325,30001395,20000204,10000016),(3011854,'Peunolakka Heimune',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003307,30001644,20000243,10000020),(3011855,'Eromo Outikenen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003304,30001648,20000243,10000020),(3011856,'Nupiroda Upi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003259,30002683,20000392,10000032),(3011857,'Olkkogas Aranato',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003256,30002684,20000392,10000032),(3011858,'Hysinala Uimuken',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003328,30002696,20000394,10000032),(3011859,'Nelvanen Horitzawa',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003331,30002696,20000394,10000032),(3011860,'Aruwira Kaskovuo',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003292,30002699,20000395,10000032),(3011861,'Huukoshin Salulen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003295,30002700,20000395,10000032),(3011862,'Uuhigoken Isato',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003286,30002740,20000401,10000033),(3011863,'Ruutakin Isaala',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003289,30002740,20000401,10000033),(3011864,'Outonen Molken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003274,30003060,20000447,10000037),(3011865,'Paatakko Noyata',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003277,30003060,20000447,10000037),(3011866,'Yutukio Bara',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003319,30003298,20000481,10000041),(3011867,'Akiras Issota',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003316,30003299,20000481,10000041),(3011868,'Osio Nama',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003313,30003468,20000506,10000042),(3011869,'Iesakko Ihira',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003310,30003472,20000506,10000042),(3011870,'Pumenen Mokuwa',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003268,30003488,20000509,10000043),(3011871,'Uehuma Ulvas',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003271,30003488,20000509,10000043),(3011872,'Vainela Vuorlusin',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003262,30004969,20000727,10000064),(3011873,'Aarunpanen Arta',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003265,30004969,20000727,10000064),(3011874,'Atei Kojelainen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003280,30005002,20000732,10000064),(3011875,'Erkinen Yoembora',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003283,30005003,20000732,10000064),(3011876,'Petayemi Kainokai',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003253,30005302,20000776,10000068),(3011877,'Alanala Okselen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003250,30005306,20000776,10000068),(3011878,'Nashokoda Pekumatken',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003334,30000145,20000020,10000002),(3011879,'Sumpiras Notarula',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003337,30000139,20000020,10000002),(3011880,'Isava Haakkurava',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003349,30000165,20000024,10000002),(3011881,'Hien Karnuras',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003346,30000171,20000024,10000002),(3011882,'Ika Uuhikken',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003364,30000173,20000025,10000002),(3011883,'Sitsen Ahtamon',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003367,30000179,20000025,10000002),(3011884,'Sironius Okasono',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003361,30001374,20000201,10000016),(3011885,'Shaita Etsoro',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003358,30001375,20000201,10000016),(3011886,'Julila Imaa',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003388,30001412,20000207,10000016),(3011887,'Mayaki Okoneda',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003391,30001414,20000207,10000016),(3011888,'Imeri Ahtaa',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003352,30002739,20000401,10000033),(3011889,'Narakala Saariken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003355,30002739,20000401,10000033),(3011890,'Enitouvo Erkonoi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003370,30002753,20000403,10000033),(3011891,'Aivoras Ahtainio',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003373,30002754,20000403,10000033),(3011892,'Palimoila Obachi',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003385,30002756,20000404,10000033),(3011893,'Alikara Nuori',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003382,30002759,20000404,10000033),(3011894,'Uemuda Watalenen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003343,30002778,20000407,10000033),(3011895,'Itunala Unonen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003340,30002779,20000407,10000033),(3011896,'Oksitei Uminami',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003379,30002814,20000413,10000033),(3011897,'Gorttalen Tandoiras',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003376,30002819,20000413,10000033),(3011898,'Surjinen Hakomairos',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003394,30000127,20000018,10000002),(3011899,'Sanoras Shia',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003397,30000129,20000018,10000002),(3011900,'Iidayamon Sattaya',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003442,30001356,20000198,10000016),(3011901,'Venonaila Sukkajus',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003445,30001361,20000198,10000016),(3011902,'Salen Kuokka',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003415,30001383,20000202,10000016),(3011903,'Tukken Oilamo',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003412,30001385,20000202,10000016),(3011904,'Peuvalolen Ubito',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003424,30001393,20000204,10000016),(3011905,'Moikallio Garnen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003427,30001395,20000204,10000016),(3011906,'Ogyuma Ebenailen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003430,30001404,20000206,10000016),(3011907,'Aaho Ruus',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003433,30001406,20000206,10000016),(3011908,'Airusen Ueshuneva',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003409,30001418,20000208,10000016),(3011909,'Yuhama Yuas',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003406,30001423,20000208,10000016),(3011910,'Puola Wirashoda',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003403,30002751,20000403,10000033),(3011911,'Sukki Tano',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003400,30002752,20000403,10000033),(3011912,'Ris Suokko',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003439,30002756,20000404,10000033),(3011913,'Jama Ranta',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003436,30002759,20000404,10000033),(3011914,'Tsunaras Rautataitoh',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003418,30002781,20000408,10000033),(3011915,'Korjiki Porkala',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003421,30002783,20000408,10000033),(3011916,'Gakoho Jiksokainen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003451,30002814,20000413,10000033),(3011917,'Hakin Aritate',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003448,30002815,20000413,10000033),(3011918,'Kai Etashanko',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003454,30000140,20000020,10000002),(3011919,'Rauskajus Taskiainen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003592,30003803,20000555,10000048),(3011920,'Itela Vepas',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003580,30003805,20000555,10000048),(3011921,'Onaa Nomon',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003586,30003805,20000555,10000048),(3011922,'Abora Poikka',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003589,30003805,20000555,10000048),(3011923,'Kokoreto Kosinaki',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003484,30005050,20000739,10000065),(3011924,'Auvulatoh Vaira',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003475,30005051,20000739,10000065),(3011925,'Hatoh Yoma',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003487,30005052,20000739,10000065),(3011926,'Fusinela Ihara',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003472,30005053,20000739,10000065),(3011927,'Ylamaa Knala',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003481,30005054,20000739,10000065),(3011928,'Toranota Onelari',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003478,30005055,20000739,10000065),(3011929,'Paaltomo Onin',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003460,30000142,20000020,10000002),(3011930,'Poloteinen Intaa',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003463,30000142,20000020,10000002),(3011931,'Yaskisen Peeratoh',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003466,30000142,20000020,10000002),(3011932,'Sulkkenas Aizara',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003469,30000142,20000020,10000002),(3011933,'Uutuo Ohmata',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003457,30000143,20000020,10000002),(3011934,'Herras Soirikinen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003682,30000148,20000021,10000002),(3011935,'Sarmaras Uimuken',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003685,30000148,20000021,10000002),(3011936,'Ishasina Suokka',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003676,30000149,20000021,10000002),(3011937,'Orpas Rewira',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003679,30000149,20000021,10000002),(3011938,'Vappulen Aurogas',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003670,30000152,20000021,10000002),(3011939,'Vastakku Shiken',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003673,30000152,20000021,10000002),(3011940,'Isaala Alta',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003601,30001443,20000212,10000016),(3011941,'Tuolovas Koliraya',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003613,30001443,20000212,10000016),(3011942,'Okenada Ansala',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003598,30001444,20000212,10000016),(3011943,'Shitunen Vajus',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003604,30001446,20000212,10000016),(3011944,'Inamo Imaala',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003607,30001446,20000212,10000016),(3011945,'Otinada Isi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003610,30001448,20000212,10000016),(3011946,'Oinola Pilakanta',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003628,30001657,20000245,10000020),(3011947,'Orsanakka Immivas',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003631,30001659,20000245,10000020),(3011948,'Uittigas Isonola',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003616,30001660,20000245,10000020),(3011949,'Userala Yakela',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003619,30001660,20000245,10000020),(3011950,'Oima Iziwaitoh',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003622,30001660,20000245,10000020),(3011951,'Shionkanainen Aiti',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003625,30001661,20000245,10000020),(3011952,'Rula Hotvas',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003715,30002390,20000351,10000028),(3011953,'Haraila Aruta',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003718,30002390,20000351,10000028),(3011954,'Onnola Kalakune',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003709,30002392,20000351,10000028),(3011955,'Hitalula Ibechi',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003706,30002393,20000351,10000028),(3011956,'Ahvaho Iidonen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003712,30002393,20000351,10000028),(3011957,'Shishanen Ishinoki',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003721,30002393,20000351,10000028),(3011958,'Yantoh Pilo',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003565,30002708,20000396,10000032),(3011959,'Karo Shotisto',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003577,30002708,20000396,10000032),(3011960,'Kunkkoja Hotvas',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003562,30002711,20000396,10000032),(3011961,'Kurniainen Eratsaka',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003568,30002711,20000396,10000032),(3011962,'Aroki Uetu',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003571,30002711,20000396,10000032),(3011963,'Tuivatoh Isonasken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003574,30002711,20000396,10000032),(3011964,'Olkkosen Saisima',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003559,30002712,20000397,10000032),(3011965,'Suorasin Ukanata',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003544,30002714,20000397,10000032),(3011966,'Sikoda Elaoutiras',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003547,30002714,20000397,10000032),(3011967,'Karunani Haura',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003550,30002714,20000397,10000032),(3011968,'Tanibu Kittavas',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003553,30002714,20000397,10000032),(3011969,'Kuori Miromaa',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003556,30002714,20000397,10000032),(3011970,'Yoemmono Ahtaa',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003523,30002744,20000402,10000033),(3011971,'Aokigenen Ugata',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003514,30002745,20000402,10000033),(3011972,'Fukkuseilen Toin',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003508,30002746,20000402,10000033),(3011973,'Aunaken Okakaita',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003511,30002746,20000402,10000033),(3011974,'Vi Saariski',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003520,30002747,20000402,10000033),(3011975,'Suon Autio',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003517,30002748,20000402,10000033),(3011976,'Olkkalin Haatilieto',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003634,30002988,20000438,10000036),(3011977,'Koirusen Hi',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003640,30002988,20000438,10000036),(3011978,'Kesheda Soravuo',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003646,30002988,20000438,10000036),(3011979,'Haitoh Askuo',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003643,30002990,20000438,10000036),(3011980,'Santasen Korturas',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003637,30002992,20000438,10000036),(3011981,'Akiainavas Uunko',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003649,30002993,20000438,10000036),(3011982,'Vuonolailen Onnuro',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003652,30003010,20000441,10000037),(3011983,'Sornen Shi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003655,30003011,20000441,10000037),(3011984,'Marsuras Jurvala',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003661,30003011,20000441,10000037),(3011985,'Kuskitoh Asinoro',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003664,30003011,20000441,10000037),(3011986,'Tulala Sirikka',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003658,30003012,20000441,10000037),(3011987,'Huovalve Heikkulainen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003667,30003015,20000441,10000037),(3011988,'Natrunen Umanairos',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003535,30003046,20000446,10000037),(3011989,'Okikko Rohmunji',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003538,30003047,20000446,10000037),(3011990,'Asunmaa Tutiri',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003541,30003048,20000446,10000037),(3011991,'Kenkkaken Vapas',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003532,30003051,20000446,10000037),(3011992,'Etsuonio Kattolen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003529,30003052,20000446,10000037),(3011993,'Okenama Nieltaken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003526,30003053,20000446,10000037),(3011994,'Abanen Artaya',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003493,30003416,20000498,10000042),(3011995,'Hela Tashotsu',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003502,30003417,20000498,10000042),(3011996,'Tantoyoemon Amateri',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003499,30003419,20000498,10000042),(3011997,'Suvinila Tashin',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003496,30003420,20000498,10000042),(3011998,'Ausmuras Nai',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003505,30003420,20000498,10000042),(3011999,'Dahtoh Atshonen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003490,30003421,20000498,10000042),(3012000,'Mintano Kannainen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003691,30003528,20000515,10000043),(3012001,'Enovirta Akras',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003697,30003529,20000515,10000043),(3012002,'Ranttika Irjuta',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003688,30003530,20000515,10000043),(3012003,'Mitila Vikayara',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003700,30003532,20000515,10000043),(3012004,'Tashemochi Veilamaa',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003694,30003534,20000515,10000043),(3012005,'Ieyata Oijari',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003703,30003534,20000515,10000043),(3012006,'Sainnugas Kaitalen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003595,30003801,20000555,10000048),(3012007,'Umizainen Oshomi',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003583,30003802,20000555,10000048),(3012008,'Aivuken Kirvira',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003724,30000145,20000020,10000002),(3012009,'Ausmilen Ukkenen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003751,30000121,20000017,10000002),(3012010,'Peramaki Uotiri',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003730,30000132,20000019,10000002),(3012011,'Itken Hodan',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003736,30001384,20000202,10000016),(3012012,'Paarinela Siakkawai',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003739,30001387,20000203,10000016),(3012013,'Shas Erhi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003733,30001394,20000204,10000016),(3012014,'Narmon Riki',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003742,30001403,20000205,10000016),(3012015,'Ibatei Askawa',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003745,30001410,20000207,10000016),(3012016,'Isikano Pyyrvonami',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003727,30002750,20000403,10000033),(3012017,'Sikakainen Arishi',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003748,30002798,20000410,10000033),(3012018,'Ogyura Unao',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003754,30000144,20000020,10000002),(3012019,'Arugas Ungi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003772,30002815,20000413,10000033),(3012020,'Uedamon Ahvinen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003802,30002802,20000411,10000033),(3012021,'Outaka Okiembunya',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003919,30001364,20000199,10000016),(3012022,'Kaavala Kehtolen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003931,30001364,20000199,10000016),(3012023,'Kiripas Oyurakka',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003928,30001365,20000199,10000016),(3012024,'Ikomari Kobara',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003922,30001367,20000199,10000016),(3012025,'Ozanero Voiras',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003829,30001375,20000201,10000016),(3012026,'Manttaken Hakaira',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003832,30001376,20000201,10000016),(3012027,'Missomon Riki',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003835,30001376,20000201,10000016),(3012028,'Okaseilen Fukashi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003841,30001376,20000201,10000016),(3012029,'Hakadura Otora',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003838,30001377,20000201,10000016),(3012030,'Orayuata Paanenen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003826,30001379,20000201,10000016),(3012031,'Inuki Onilola',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003868,30001398,20000205,10000016),(3012032,'Joutalen Ohorala',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003877,30001400,20000205,10000016),(3012033,'Ahiras Kartavo',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003862,30001401,20000205,10000016),(3012034,'Otsasen Saunorainen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003871,30001401,20000205,10000016),(3012035,'Keitunen Sakkunen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003874,30001401,20000205,10000016),(3012036,'Yahutola Sokka',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003865,30001403,20000205,10000016),(3012037,'Upi Inimita',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003880,30001405,20000206,10000016),(3012038,'Kakkagainen Jakamaa',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003889,30001405,20000206,10000016),(3012039,'Kazara Kankiainen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003892,30001405,20000206,10000016),(3012040,'Kiken Yuatakkeimo',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003895,30001405,20000206,10000016),(3012041,'Santenpaa Fusura',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003883,30001409,20000206,10000016),(3012042,'Vitaima Ishashi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003886,30001409,20000206,10000016),(3012043,'Pukka Shotsu',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003814,30001443,20000212,10000016),(3012044,'Harkima Partoh',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003817,30001444,20000212,10000016),(3012045,'Mastakomon Hamon',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003820,30001444,20000212,10000016),(3012046,'Shikibato Kiruola',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003811,30001446,20000212,10000016),(3012047,'Uittaras Jakawaki',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003823,30001446,20000212,10000016),(3012048,'Pemigas Hekken',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003808,30001448,20000212,10000016),(3012049,'Motsu Ititeimo',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003820,30001444,20000212,10000016),(3012050,'Velmudainen Tykigi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003910,30002738,20000401,10000033),(3012051,'Sanashi Naun',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003904,30002739,20000401,10000033),(3012052,'Olama Rammeki',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003799,30002804,20000411,10000033),(3012053,'Orsiainen Iiva',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003913,30002740,20000401,10000033),(3012054,'Asaken Mormon',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003901,30002741,20000401,10000033),(3012055,'Okatuya Ekala',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003847,30002797,20000410,10000033),(3012056,'Mitakada Mihaikka',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003850,30002797,20000410,10000033),(3012057,'Otamon Heiminen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003853,30002798,20000410,10000033),(3012058,'Ohmora Rautolen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003844,30002799,20000410,10000033),(3012059,'Sutono Hatanata',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003856,30002799,20000410,10000033),(3012060,'Uusuras Sokuvera',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003859,30002799,20000410,10000033),(3012061,'Tiukiski Elulen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003805,30002800,20000411,10000033),(3012062,'Osoi Isento',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003790,30002801,20000411,10000033),(3012063,'Nachi Havahori',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003793,30002801,20000411,10000033),(3012064,'Shistalen Kenda',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003802,30002802,20000411,10000033),(3012065,'Kimuruola Sitsudan',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003796,30002803,20000411,10000033),(3012066,'Kilimeya Otireya',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003799,30002804,20000411,10000033),(3012067,'Mivola Kovotie',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003772,30002815,20000413,10000033),(3012068,'Natakko Saijimo',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003775,30002815,20000413,10000033),(3012069,'Kakogonda Uemuda',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003784,30002816,20000413,10000033),(3012070,'Tormalaiken Auho',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003781,30002817,20000413,10000033),(3012071,'Onami Oinistosen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003778,30002818,20000413,10000033),(3012072,'Sius Tarjuras',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003787,30002819,20000413,10000033),(3012073,'Vintteken Napas',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003763,30000140,20000020,10000002),(3012074,'Konolana Tsunibaka',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003757,30000142,20000020,10000002),(3012075,'Tevarula Nisuwa',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003760,30000142,20000020,10000002),(3012076,'Koikaski Uika',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003766,30000143,20000020,10000002),(3012077,'Roki Kaurinen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003769,30000143,20000020,10000002),(3012078,'Hahtodan Onuoto',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003937,30000153,20000022,10000002),(3012079,'Kuga Aitsai',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003940,30001404,20000206,10000016),(3012080,'Iska Arjo',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003946,30001376,20000201,10000016),(3012081,'Itkiras Reppola',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003949,30001376,20000201,10000016),(3012082,'Aizagenen Pemmiya',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003943,30001404,20000206,10000016),(3012083,'Uusori Vapalmaa',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003955,30001430,20000210,10000016),(3012084,'Tattiainen Siraski',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003952,30001432,20000210,10000016),(3012085,'Menji Arviri',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003958,30001437,20000211,10000016),(3012086,'Ohmihtavuo Haskatoh',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003961,30001439,20000211,10000016),(3012087,'Pontimawa Ozugas',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003964,30001393,20000204,10000016),(3012088,'Amateri Likkuni',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003967,30001394,20000204,10000016),(3012089,'Okotomi Arvoras',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003970,30001394,20000204,10000016),(3012090,'Okuhori Anttulen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003991,30001420,20000208,10000016),(3012091,'Jurken Nihanailen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003994,30001421,20000208,10000016),(3012092,'Tastoh Kaaserinen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003997,30001423,20000208,10000016),(3012093,'Eborimi Shiskala',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003982,30001424,20000209,10000016),(3012094,'Vankanen Yuken',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003985,30001425,20000209,10000016),(3012095,'Aletola Ochinokka',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003988,30001426,20000209,10000016),(3012096,'Kauntora Itkaku',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003973,30001437,20000211,10000016),(3012097,'Sakkin Vesomaiken',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003976,30001438,20000211,10000016),(3012098,'Kakynen Voitamo',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60003979,30001442,20000211,10000016),(3012099,'Kynnen Elomon',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004000,30001401,20000205,10000016),(3012100,'Tormalaiken Malarainen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004012,30001363,20000199,10000016),(3012101,'Ishena Pierigas',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004039,30001424,20000209,10000016),(3012102,'Okalen Okima',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004015,30001365,20000199,10000016),(3012103,'Ruosen Kalanen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004021,30001365,20000199,10000016),(3012104,'Kogas Mieroshi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004027,30001368,20000200,10000016),(3012105,'Kitkontailen Pahumaa',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004030,30001369,20000200,10000016),(3012106,'Aittio Otesawa',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004033,30001371,20000200,10000016),(3012107,'Asiaineras Isuki',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004024,30001372,20000200,10000016),(3012108,'Ylitula Shonisen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004009,30001398,20000205,10000016),(3012109,'Iesalinen Kuotalaisen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004003,30001399,20000205,10000016),(3012110,'Airuta Heimune',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004030,30001369,20000200,10000016),(3012111,'Millanpaa Nisuwa',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004039,30001424,20000209,10000016),(3012112,'Molehanen Piertalen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004036,30001429,20000209,10000016),(3012113,'Osala Iskio',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004042,30001429,20000209,10000016),(3012114,'Koskanaiken Vilima',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004045,30001429,20000209,10000016),(3012115,'Astitoh Ake',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004048,30000146,20000021,10000002),(3012116,'Samalela Kikera',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004066,30000132,20000019,10000002),(3012117,'Peunolakka Konkomatsu',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004069,30000137,20000019,10000002),(3012118,'Oilja Okui',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004072,30000137,20000019,10000002),(3012119,'Hirtoh Sawa',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004054,30000147,20000021,10000002),(3012120,'Innamon Sula',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004051,30000150,20000021,10000002),(3012121,'Jukkizaras Varppavas',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004075,30000159,20000023,10000002),(3012122,'Midamawa Raunomailen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004081,30000162,20000023,10000002),(3012123,'Ekasvio Oshomi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004078,30000163,20000023,10000002),(3012124,'Onalila Asela',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004057,30000173,20000025,10000002),(3012125,'Inala Igunen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004063,30000173,20000025,10000002),(3012126,'Hindamainen Milkina',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004060,30000174,20000025,10000002),(3012127,'Iivinonen Konkinen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004084,30002780,20000407,10000033),(3012128,'Ohviken Ininaga',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004234,30000127,20000018,10000002),(3012129,'Arvasaras Tuumi',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004240,30000128,20000018,10000002),(3012130,'Auvilen Oshukata',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004087,30002775,20000407,10000033),(3012131,'Kadan Aino',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004090,30002778,20000407,10000033),(3012132,'Uiski Sakkatokka',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004096,30002778,20000407,10000033),(3012133,'Yankanutsu Huurama',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004099,30002779,20000407,10000033),(3012134,'Haattiekko Oshukata',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004093,30002780,20000407,10000033),(3012135,'Ieyodan Ahomon',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004162,30002783,20000408,10000033),(3012136,'Viken Antilen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004165,30002783,20000408,10000033),(3012137,'Vas Enken',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004168,30002783,20000408,10000033),(3012138,'Visvas Uoyera',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004159,30002784,20000408,10000033),(3012139,'Ubarastoh Haarkela',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004156,30002785,20000408,10000033),(3012140,'Onulisa Aboraala',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004171,30002786,20000408,10000033),(3012141,'Kuolen Runashatsu',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004120,30002801,20000411,10000033),(3012142,'Kitoh Erishi',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004126,30002801,20000411,10000033),(3012143,'Itakairos Ohbesa',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004123,30002803,20000411,10000033),(3012144,'Wasken Talo',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004132,30002804,20000411,10000033),(3012145,'Obanari Kachomala',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004129,30002805,20000411,10000033),(3012146,'Veis Kingato',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004135,30002805,20000411,10000033),(3012147,'Yo Varas',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004228,30000129,20000018,10000002),(3012148,'Mandan Oittiken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004237,30000129,20000018,10000002),(3012149,'Panase Aruwira',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004243,30000130,20000018,10000002),(3012150,'Arishi Huulanen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004231,30000131,20000018,10000002),(3012151,'Iekka Katiken',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004213,30000153,20000022,10000002),(3012152,'Shigakarri Niromochi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004222,30000153,20000022,10000002),(3012153,'Aronuta Ichimusa',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004216,30000154,20000022,10000002),(3012154,'Tsunala Hitama',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004219,30000156,20000022,10000002),(3012155,'Ahtairo Vilima',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004225,30000156,20000022,10000002),(3012156,'Akaras Iidanen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004210,30000158,20000022,10000002),(3012157,'Ekinen Pakken',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004246,30001386,20000203,10000016),(3012158,'Hakkasen Ekami',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004252,30001386,20000203,10000016),(3012159,'Ippas Jokiwa',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004255,30001387,20000203,10000016),(3012160,'Hotisku Sogas',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004249,30001390,20000203,10000016),(3012161,'Asukaila Sirigainen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004258,30001391,20000203,10000016),(3012162,'Jas Uittatoh',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004261,30001391,20000203,10000016),(3012163,'Vakin Gan',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004207,30001424,20000209,10000016),(3012164,'Haalonen Outila',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004198,30001425,20000209,10000016),(3012165,'Kakukainen Kittavas',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004192,30001426,20000209,10000016),(3012166,'Heikaremi Otio',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004195,30001426,20000209,10000016),(3012167,'Auvahanen Akuras',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004204,30001428,20000209,10000016),(3012168,'Mastoh Ahtulen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004201,30001429,20000209,10000016),(3012169,'Orkko Arasmaa',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004138,30001443,20000212,10000016),(3012170,'Korasen Poipirtaka',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004144,30001443,20000212,10000016),(3012171,'Auluras Toila',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004147,30001443,20000212,10000016),(3012172,'Solanato Eeroya',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004141,30001444,20000212,10000016),(3012173,'Heimunka Itakainen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004150,30001445,20000212,10000016),(3012174,'Aikuta Sosala',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004153,30001446,20000212,10000016),(3012175,'Yara Aokannitoh',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004114,30002743,20000402,10000033),(3012176,'Huorone Itka',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004102,30002744,20000402,10000033),(3012177,'Kuutseki Hartenen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004105,30002744,20000402,10000033),(3012178,'Elaruka Kanda',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004111,30002744,20000402,10000033),(3012179,'Rautakka Aureken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004117,30002744,20000402,10000033),(3012180,'Yotera Siras',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004108,30002746,20000402,10000033),(3012181,'Iksi Kykeshi',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004180,30002767,20000406,10000033),(3012182,'Koyara Uemintoh',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004189,30002768,20000406,10000033),(3012183,'Kakaga Alaoutanen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004174,30002769,20000406,10000033),(3012184,'Arvaras Abera',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004177,30002769,20000406,10000033),(3012185,'Kuonnaken Momon',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004183,30002769,20000406,10000033),(3012186,'Oikuken Ozinola',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004186,30002769,20000406,10000033),(3012187,'Halunoto Siakramon',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004264,30001356,20000198,10000016),(3012188,'Ariken Kahtoh',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004267,30001358,20000198,10000016),(3012189,'Uvas Noma',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004270,30001359,20000198,10000016),(3012190,'Oyurakka Jirtaras',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004291,30001368,20000200,10000016),(3012191,'Kaimon Aheras',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004294,30001368,20000200,10000016),(3012192,'Otanida Iivaskuras',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004297,30001371,20000200,10000016),(3012193,'Tatsari Vanajala',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004282,30001381,20000202,10000016),(3012194,'Papas Yatshinen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004285,30001382,20000202,10000016),(3012195,'Vesuri Varvailen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004288,30001382,20000202,10000016),(3012196,'Helvokuola Kunikuwa',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004273,30001386,20000203,10000016),(3012197,'Hittanpaa Vaankalen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004279,30001387,20000203,10000016),(3012198,'Tonen Erkinen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004276,30001391,20000203,10000016),(3012199,'Tiga Kaitivas',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004300,30002801,20000411,10000033),(3012200,'Aokasa Dahtoh',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004366,30000132,20000019,10000002),(3012201,'Amonen Tekkaniras',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004363,30000133,20000019,10000002),(3012202,'Saira Sontemko',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004360,30000136,20000019,10000002),(3012203,'Ayanen Tsutuomi',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004369,30000136,20000019,10000002),(3012204,'Karsoneshi Outusen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004372,30000201,20000029,10000002),(3012205,'Tokkanen Hisken',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004381,30000201,20000029,10000002),(3012206,'Oite Pie',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004378,30000203,20000029,10000002),(3012207,'Iitoh Honnamaiken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004375,30000204,20000029,10000002),(3012208,'Matoh Aketiya',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004402,30001405,20000206,10000016),(3012209,'Kekanato Heiraitoh',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004405,30001405,20000206,10000016),(3012210,'Ichiainegas Uppe',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004399,30001408,20000206,10000016),(3012211,'Umuvari Abeinima',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004396,30001409,20000206,10000016),(3012212,'Okokka Aunki',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004342,30001424,20000209,10000016),(3012213,'Akkoneken Ruoken',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004339,30001425,20000209,10000016),(3012214,'Isvi Ernuori',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004345,30001425,20000209,10000016),(3012215,'Atshodan Keirsaa',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004336,30001428,20000209,10000016),(3012216,'Sakkikainen Akada',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004309,30002803,20000411,10000033),(3012217,'Kilori Alateima',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004393,30002739,20000401,10000033),(3012218,'Kakugi Antalen',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004384,30002740,20000401,10000033),(3012219,'Puuri Mokken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004390,30002740,20000401,10000033),(3012220,'Nakuri Onugas',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004324,30002751,20000403,10000033),(3012221,'Arushin Kanda',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004327,30002751,20000403,10000033),(3012222,'Kuga Masamon',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004330,30002751,20000403,10000033),(3012223,'Heiljahailen Ueni',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004333,30002751,20000403,10000033),(3012224,'Tuonerainen Ahvonin',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004312,30002755,20000404,10000033),(3012225,'Vainen Nuonilen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004321,30002756,20000404,10000033),(3012226,'Savataltoh Parnazaisen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004318,30002757,20000404,10000033),(3012227,'Kehtolen Katsuken',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004315,30002760,20000404,10000033),(3012228,'Ebura Hyotani',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004354,30002788,20000409,10000033),(3012229,'Vasala Utradan',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004351,30002790,20000409,10000033),(3012230,'Eratsaka Ogyonin',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004357,30002792,20000409,10000033),(3012231,'Saurio Huomaila',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004348,30002793,20000409,10000033),(3012232,'Kusen Abiken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004411,30002794,20000410,10000033),(3012233,'Ohmala Valen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004414,30002795,20000410,10000033),(3012234,'Ogas Kalmamon',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004408,30002796,20000410,10000033),(3012235,'Oisma Pukuwakai',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004417,30002799,20000410,10000033),(3012236,'Paanenen Ondo',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,14,18,15,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004306,30002802,20000411,10000033),(3012237,'Ranatoh Tesen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004309,30002803,20000411,10000033),(3012238,'Muyeroiken Issegairos',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004303,30002805,20000411,10000033),(3012239,'Ylora Rukila',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004420,30001407,20000206,10000016),(3012240,'Paaseraisen Nosidoma',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,14,18,14,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004441,30002771,20000406,10000033),(3012241,'Natima Iijala',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004435,30000167,20000024,10000002),(3012242,'Kamanoi Onnajus',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,18,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004444,30000181,20000026,10000002),(3012243,'Naninen Heisatailen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,11,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004426,30000201,20000029,10000002),(3012244,'Olkkuras Tarkko',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004432,30001389,20000203,10000016),(3012245,'Varppavas Kamekera',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004429,30001432,20000210,10000016),(3012246,'Vairosen Ikkola',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,17,19,17,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004447,30001443,20000212,10000016),(3012247,'Nisto Asalova',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004441,30002771,20000406,10000033),(3012248,'Iidoras Tammesaiken',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,14,18,15,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004438,30002775,20000407,10000033),(3012249,'Ukkolen Heimunka',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004450,30001392,20000204,10000016),(3012250,'Korkahienen Keino',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,17,19,18,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004462,30000119,20000017,10000002),(3012251,'Poiken Onegas',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004459,30000180,20000026,10000002),(3012252,'Misikullen Kanatonen',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,11,17,12,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004474,30000188,20000027,10000002),(3012253,'Dain Alasunda',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,11,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004468,30000195,20000028,10000002),(3012254,'Uusonen Liuttijairos',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004465,30000201,20000029,10000002),(3012255,'Mohitie Amon',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,8,17,19,17,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004471,30001356,20000198,10000016),(3012256,'Toikka Hanomaa',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,10,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004477,30001445,20000212,10000016),(3012257,'Iriganda Tiga',NULL,'','',0,0,0,'',0,0,0,0,0,1375,1,2,7,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004468,30000195,20000028,10000002),(3012258,'Senda Korpi',NULL,'','',0,0,0,'',0,0,0,0,0,1376,1,1,11,11,17,12,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004456,30002783,20000408,10000033),(3012259,'Ludik Heska',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,27,15,27,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004480,30003413,20000497,10000042),(3012260,'Tunn Finskakar',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,21,14,21,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004507,30003394,20000495,10000042),(3012261,'Surefgen Dalanard',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,27,15,28,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004513,30003394,20000495,10000042),(3012262,'Noboring Aptogaban',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,24,16,25,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004510,30003396,20000495,10000042),(3012263,'Ewlang Eode',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,27,15,28,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004483,30003413,20000497,10000042),(3012264,'Klolf Eldsund',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,27,15,27,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004486,30003413,20000497,10000042),(3012265,'Kvarl Indald',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,24,16,25,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004504,30003447,20000503,10000042),(3012266,'Loldrir Asdur',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,24,16,24,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004498,30003449,20000503,10000042),(3012267,'Ofylur Woligabet',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,27,15,28,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004501,30003449,20000503,10000042),(3012268,'Frololard Reiddeider',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,24,16,25,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004495,30003464,20000505,10000042),(3012269,'Arbias Allfran',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,21,14,21,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004489,30003466,20000505,10000042),(3012270,'Egyrlen Agattolf',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,21,14,22,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004492,30003466,20000505,10000042),(3012271,'Rinsutidur Rildboko',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,27,15,27,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004516,30002053,20000302,10000042),(3012272,'Arnriger Anner',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,27,15,28,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004519,30002051,20000302,10000042),(3012273,'Eatellef Edar',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,27,15,27,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004522,30002051,20000302,10000042),(3012274,'Austrene Aedald',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,24,16,24,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004543,30002068,20000305,10000042),(3012275,'Odor Bonnvekin',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,27,15,27,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004546,30002068,20000305,10000042),(3012276,'Rudoko Salkur',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,24,16,25,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004549,30002068,20000305,10000042),(3012277,'Rerd Oloniden',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,27,15,28,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004525,30002076,20000306,10000042),(3012278,'Attar Gekilard',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,21,14,22,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004531,30002076,20000306,10000042),(3012279,'Herveiker Eurten',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,23,24,16,25,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004528,30002080,20000306,10000042),(3012280,'Arher Ellovik',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,21,14,21,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004540,30002090,20000308,10000042),(3012281,'Alfudar Otolf',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,21,14,22,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004534,30002091,20000308,10000042),(3012282,'Tatkeker Rignering',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,21,14,21,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004537,30002094,20000308,10000042),(3012283,'Varulard Reit',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,21,14,21,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004552,30002385,20000350,10000028),(3012284,'Hettere Guvera',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,27,15,27,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004555,30002386,20000350,10000028),(3012285,'Arbjan Tolangranner',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,21,14,21,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004558,30002386,20000350,10000028),(3012286,'Hordelena Ingaudur',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,21,14,21,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004582,30002390,20000351,10000028),(3012287,'Eumlard Afran',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,21,14,22,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004585,30002391,20000351,10000028),(3012288,'Mikunnur Kyndeflar',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,24,16,24,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004579,30002393,20000351,10000028),(3012289,'Ambell Fjell',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,27,15,27,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004570,30002398,20000352,10000028),(3012290,'Ernard Tontolt',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,21,14,22,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004573,30002398,20000352,10000028),(3012291,'Alrinror Eornren',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,21,14,21,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004576,30002398,20000352,10000028),(3012292,'Kolmeter Ealdjer',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,21,14,21,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004567,30002414,20000355,10000028),(3012293,'Letava Aldastmelden',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,19,24,16,24,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004564,30002419,20000355,10000028),(3012294,'Annes Rilesen',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,21,14,21,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004561,30002420,20000355,10000028),(3012295,'Bjerd Erand',NULL,'','',0,0,0,'',0,0,0,0,0,1380,2,4,22,21,14,22,0,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60004588,30002510,20000367,10000030),(3012296,'Vodber Svaken',NULL,'','',0,0,0,'',0,0,0,0,0,1379,2,3,20,21,14,22,1,NULL,NULL,73,82,11,10,75,37,37,11,10,19,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NUL