/*Table structure for table `chrCareers` */

DROP TABLE IF EXISTS `chrCareers`;

CREATE TABLE `chrCareers` (
  `raceID` tinyint(3) unsigned default NULL,
  `careerID` tinyint(3) unsigned NOT NULL,
  `careerName` varchar(100) default NULL,
  `description` varchar(2000) default NULL,
  `shortDescription` varchar(500) default NULL,
  `graphicID` smallint(6) default NULL,
  `schoolID` tinyint(3) unsigned default NULL,
  PRIMARY KEY  (`careerID`),
  KEY `raceID` (`raceID`),
  KEY `schoolID` (`schoolID`),
  KEY `graphicID` (`graphicID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `chrCareers` */

insert  into `chrCareers`(`raceID`,`careerID`,`careerName`,`description`,`shortDescription`,`graphicID`,`schoolID`) values (1,11,'Military','A career in the military means learning what you need to know about how to dispose of enemy vessels as fast and securely as possible, without them disposing of you. Military academies educate enlist cadets thoroughly in combat related skills.','Focuses mainly on combat training.',3178,17),(1,14,'Business','Business is all about dealing with people, solving problems or finding compromises in quarrels and servicing trade routes. And of course, all in the name of financial success. Business careers can be roughly divided into two categories. One revolves entirely around buying and selling, dealing with business contacts and playing the market with the sole purpose of maximizing the profit margin. The other catergory is all about preparing the pilot to lead a group or a crowd of people, form and run a corporation and to supply leadership.','Focuses mainly on practical studies.',3175,18),(1,17,'Industry','A career in industry is a career that spells not only wealth for those that choose to follow that path, but it also opens the door to potential popularity. In the war torn reaches of space, everyone loves a provider. Serious industrialists need to learn how to harvest precious ore, refine it and either produce something from it or haul it around and sell where prices are high. Eventually, a successful industrialist often ends up with a lot of cash on his hands to spend on some other line of work.','Focuses mainly on technical studies.',3172,19),(2,21,'Military','A career in the military means learning what you need to know about how to dispose of enemy vessels as fast and securely as possible, without them disposing of you. Military academies educate enlist cadets thoroughly in combat related skills.','An up-and-coming military training institution.',3178,14),(2,24,'Business','Business is all about dealing with people, solving problems or finding compromises in quarrels and servicing trade routes. And of course, all in the name of financial success. Business careers can be roughly divided into two categories. One revolves entirely around buying and selling, dealing with business contacts and playing the market with the sole purpose of maximizing the profit margin. The other catergory is all about preparing the pilot to lead a group or a crowd of people, form and run a corporation and to supply leadership.','Founded to help gifted children reach their potential.',3175,16),(2,27,'Industry','A career in industry is a career that spells not only wealth for those that choose to follow that path, but it also opens the door to potential popularity. In the war torn reaches of space, everyone loves a provider. Serious industrialists need to learn how to harvest precious ore, refine it and either produce something from it or haul it around and sell where prices are high. Eventually, a successful industrialist often ends up with a lot of cash on his hands to spend on some other line of work.','A forward-thinking house of higher learning.',3172,15),(4,41,'Military','A career in the military means learning what you need to know about how to dispose of enemy vessels as fast and securely as possible, without them disposing of you. Military academies educate enlist cadets thoroughly in combat related skills.','The Empire\'s breeding grounds for military might.',3178,11),(4,44,'Business','Business is all about dealing with people, solving problems or finding compromises in quarrels and servicing trade routes. And of course, all in the name of financial success. Business careers can be roughly divided into two categories. One revolves entirely around buying and selling, dealing with business contacts and playing the market with the sole purpose of maximizing the profit margin. The other catergory is all about preparing the pilot to lead a group or a crowd of people, form and run a corporation and to supply leadership.','A bastion of liberalism and free thought.',3175,12),(4,47,'Industry','A career in industry is a career that spells not only wealth for those that choose to follow that path, but it also opens the door to potential popularity. In the war torn reaches of space, everyone loves a provider. Serious industrialists need to learn how to harvest precious ore, refine it and either produce something from it or haul it around and sell where prices are high. Eventually, a successful industrialist often ends up with a lot of cash on his hands to spend on some other line of work.','One of the most venerable educational facilities in the universe.',3172,13),(8,81,'Military','A career in the military means learning what you need to know how about to dispose of enemy vessels as fast and securely as possible, without them disposing of you. Military academies educate enlist cadets thoroughly in combat related skills.','An extremely strict but effective military academy.',3178,20),(8,84,'Business','Business is all about dealing with people, solving problems or finding compromises in quarrels and servicing trade routes. And of course, all in the name of financial success. Business careers can be roughly divided into two categories. One revolves entirely around buying and selling, dealing with business contacts and playing the market with the sole purpose of maximizing the profit margin. The other catergory is all about preparing the pilot to lead a group or a crowd of people, form and run a corporation and to supply leadership.','The largest school in the universe.',3175,21),(8,87,'Industry','A career in industry is a career that spells not only wealth for those that choose to follow that path, but it also opens the door to potential popularity. In the war torn reaches of space, everyone loves a provider. Serious industrialists need to learn how to harvest precious ore, refine it and either produce something from it or haul it around and sell where prices are high. Eventually, a successful industrialist often ends up with a lot of cash on his hands to spend on some other line of work.','One of the very best technical schools in the universe.',3172,22),(16,161,'Business','','',3175,23),(16,164,'Industry','','',3172,24),(16,167,'Military','','',3178,25);

/*Table structure for table `chrCareerSpecialities` */

DROP TABLE IF EXISTS `chrCareerSpecialities`;

CREATE TABLE `chrCareerSpecialities` (
  `specialityID` tinyint(3) unsigned NOT NULL,
  `careerID` tinyint(3) unsigned default NULL,
  `specialityName` varchar(100) default NULL,
  `description` varchar(2000) default NULL,
  `shortDescription` varchar(500) default NULL,
  `graphicID` smallint(6) default NULL,
  PRIMARY KEY  (`specialityID`),
  KEY `careerID` (`careerID`),
  KEY `graphicID` (`graphicID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `chrCareerSpecialities` */

insert  into `chrCareerSpecialities`(`specialityID`,`careerID`,`specialityName`,`description`,`shortDescription`,`graphicID`) values (11,11,'Soldier','A pilot that specializes in soldiering in general becomes very well versed in gunnery and manouvering skills. Training will focus entirely on efficiency in combat, training of combat-relevant attributes and to learn better to sustain damage. After training, a soldier can turn to anything he wants – There are no preset paths. But if a soldier keeps on advancing the skills alotted in the beginning, corporations, alliances, agents and the like are always looking for people with an accurate targeting eye and sensitive trigger fingers to do their bidding.\n\nThere are always wars to be fought somewhere for those willing! Also, there is good cash to be made from hunting pirates that infest asteroid belts throughout space.','The technology and science behind space ship weaponry.',3179),(12,11,'Special Forces','Pilots that enlist in Special Forces are discharged from military academies well versed in basic combat skills, such as gunnery. Upon graduating, they do not match the brute force and tanking potentials of someone who has specialized in soldiering, but on the other hand they are experts in strategic, electronic warfare using warp disruptors, system scanners and range boosters.\n\nA Special Forces pilot is by no means confined to any profession – like everyone else, he can decide to do whatever he likes, but the skills granted in training make these pilots excellent bounty hunters, chasing after other people’s enemies, supporting heavily tanked fleets or taking their chances as privateers or pirates.','The intriciacies of capsular interfacing.',3180),(14,14,'Entrepreneur','True EVE entrepreneurs wheel and deal in goods and practice skills that maximize the business potential which space has to offer. For example, hauling goods around takes time and the more you can carry, the more money is to be made. Appropriate skills and equipment can enlarge the capacity of cargo bays which in turn increases the revenue available from various trade routs. Working the market also requires specialized skills. For example, the range at which buying and selling can take place is entirely reliant upon the trading skills.\n\nBusiness schools imprint into their students the fact that moving cargo around can be risky. Therefore they are also taught how to equip their ships with modules that make them better withstand attacks and ensure a speedy getaway. Might makes right and in this day and age money is where the might lies.\n\nAcute businessmen abound and the only way to beat them is at their own game. Once you understand what drives the market you\'re halfway home to earning your first million.','The art of the market, the pursuit of wealth.',3177),(15,14,'Executive Commander','An executive commander is a broad term for someone trained in leadership. The basic studies revolve about training organization and influence skills. How to use them with success will be for the pilots to figure out when they graduate from the universities.\n\nTraditionally, corporation executives and commanders strive to insure the collective success of a group of people. Some leaders act in the open and command the respect of the masses, but that is by no means the only way to govern, nor necessarily the best one. A truly talented executive commander needs to be able to form a hidden power structure and make it work for his own benefit. The really good ones do it so that noone realizes that fact. And the elite few make their grip on power known but treat their powers so that noone really cares they are being manipulated.\n\nSomeone who has trained the skills is academically better equipped to lead than others, but the magical element is personal charisma and that can not be learnt the easy way. Of all the careers, this is the one closest to being a directly political one. ','The laws that drive the universe.',3176),(17,17,'Prospector','A prospector is someone that scours the world searching for unexploited natural riches and upon finding them, exploits them. The direct route for someone that specializes in prospecting is to become a miner and gather riches from EVE’s numerous asteroid fields, refine them and sell to the highest bidder.\n\nLearning about prospecting does not limit the pilot in any way, but rather opens up a path to easy money. Prospectors that strike it rich are usually quick at making enough money to be able to expand into whatever branch strikes their fancy. Moneymen can gab all they want, but their stocks and bonds are worth nothing without the hard-working individuals that actually create something through their labor.\n\nMoney may grease the wheels of the economy, but it\'s the miners and manufacturers that keep them turning.','The grassroots of wealth creation.',3173),(18,17,'Engineer','While a prospector concentrates on finding raw materials in the vastness of space, engineers study how to make something out of them. They also take a number of science courses that allow them to study and copy blueprints (which are a necessity in all production), produce goods and use cybernetic implants to increase their capabilities.\n\nBeing a successful manufacturer takes a considerable effort in the beginning, as the more complex products take a while to produce. Engineering is an excellent foundation to build a successful space ship career on. Being tech-savvy allows a captain to be more than just the driver of his ship - he becomes the ship\'s master.\n\nIn the hi-tech world of EVE, being comfortable around complex machines can mean the difference between life and death.','The coordination and manipulation of complex machines.',3174),(21,21,'Soldier','A pilot that specializes in soldiering in general becomes very well versed in gunnery and manouvering skills. Training will focus entirely on efficiency in combat, training of combat-relevant attributes and to learn better to sustain damage. After training, a soldier can turn to anything he wants – There are no preset paths. But if a soldier keeps on advancing the skills alotted in the beginning, corporations, alliances, agents and the like are always looking for people with an accurate targeting eye and sensitive trigger fingers to do their bidding.\n\nThere are always wars to be fought somewhere for those willing! Also, there is good cash to be made from hunting pirates that infest asteroid belts throughout space.','The technology and science behind space ship weaponry.',3179),(22,21,'Special Forces','Pilots that enlist in Special Forces are discharged from military academies well versed in basic combat skills, such as gunnery. Upon graduating, they do not match the brute force and tanking potentials of someone who has specialized in soldiering, but on the other hand they are experts in strategic, electronic warfare using warp disruptors, system scanners and range boosters.\n\nA Special Forces pilot is by no means confined to any profession – like everyone else, he can decide to do whatever he likes, but the skills granted in training make these pilots excellent bounty hunters, chasing after other people’s enemies, supporting heavily tanked fleets or taking their chances as privateers or pirates.','The intriciacies of capsular interfacing.',3180),(24,24,'Entrepreneur','True EVE entrepreneurs wheel and deal in goods and practice skills that maximize the business potential which space has to offer. For example, hauling goods around takes time and the more you can carry, the more money is to be made. Appropriate skills and equipment can enlarge the capacity of cargo bays which in turn increases the revenue available from various trade routs. Working the market also requires specialized skills. For example, the range at which buying and selling can take place is entirely reliant upon the trading skills.\n\nBusiness schools imprint into their students the fact that moving cargo around can be risky. Therefore they are also taught how to equip their ships with modules that make them better withstand attacks and ensure a speedy getaway. Might makes right and in this day and age money is where the might lies.\n\nAcute businessmen abound and the only way to beat them is at their own game. Once you understand what drives the market you\'re halfway home to earning your first million.','The art of the market, the pursuit of wealth.',3177),(25,24,'Executive Commander','An executive commander is a broad term for someone trained in leadership. The basic studies revolve about training organization and influence skills. How to use them with success will be for the pilots to figure out when they graduate from the universities.\n\nTraditionally, corporation executives and commanders strive to insure the collective success of a group of people. Some leaders act in the open and command the respect of the masses, but that is by no means the only way to govern, nor necessarily the best one. A truly talented executive commander needs to be able to form a hidden power structure and make it work for his own benefit. The really good ones do it so that noone realizes that fact. And the elite few make their grip on power known but treat their powers so that noone really cares they are being manipulated.\n\nSomeone who has trained the skills is academically better equipped to lead than others, but the magical element is personal charisma and that can not be learnt the easy way. Of all the careers, this is the one closest to being a directly political one. ','The laws that drive the universe.',3176),(27,27,'Prospector','A prospector is someone that scours the world searching for unexploited natural riches and upon finding them, exploits them. The direct route for someone that specializes in prospecting is to become a miner and gather riches from EVE’s numerous asteroid fields, refine them and sell to the highest bidder.\n\nLearning about prospecting does not limit the pilot in any way, but rather opens up a path to easy money. Prospectors that strike it rich are usually quick at making enough money to be able to expand into whatever branch strikes their fancy. Moneymen can gab all they want, but their stocks and bonds are worth nothing without the hard-working individuals that actually create something through their labor.\n\nMoney may grease the wheels of the economy, but it\'s the miners and manufacturers that keep them turning.','The grassroots of wealth creation.',3173),(28,27,'Engineer','While a prospector concentrates on finding raw materials in the vastness of space, engineers study how to make something out of them. They also take a number of science courses that allow them to study and copy blueprints (which are a necessity in all production), produce goods and use cybernetic implants to increase their capabilities.\n\nBeing a successful manufacturer takes a considerable effort in the beginning, as the more complex products take a while to produce. Engineering is an excellent foundation to build a successful space ship career on. Being tech-savvy allows a captain to be more than just the driver of his ship - he becomes the ship\'s master.\n\nIn the hi-tech world of EVE, being comfortable around complex machines can mean the difference between life and death.','The coordination and manipulation of complex machines.',3174),(41,41,'Soldier','A pilot that specializes in soldiering in general becomes very well versed in gunnery and manouvering skills. Training will focus entirely on efficiency in combat, training of combat-relevant attributes and to learn how better to sustain damage. After training, a soldier can turn to anything he wants – There are no preset paths. But if a soldier keeps on advancing the skills alotted in the beginning, corporations, alliances, agents and the like are always looking for people with an accurate targeting eye and sensitive trigger fingers to do their bidding.\n\nThere are always wars to be fought somewhere for those willing! Also, there is good cash to be made from hunting pirates that infest asteroid belts throughout space.','The technology and science behind space ship weaponry.',3179),(42,41,'Special Forces','Pilots that enlist in Special Forces are discharged from military academies well versed in basic combat skills, such as gunnery. Upon graduating, they do not match the brute force and tanking potentials of someone who has specialized in soldiering, but on the other hand they are experts in strategic, electronic warfare using warp disruptors, system scanners and range boosters.\n\nA Special Forces pilot is by no means confined to any profession – like everyone else, he can decide to do whatever he likes, but the skills granted in training make these pilots excellent bounty hunters, chasing after other people’s enemies, supporting heavily tanked fleets or taking their chances as privateers or pirates.','The intriciacies of capsular interfacing.',3180),(44,44,'Entrepreneur','True EVE entrepreneurs wheel and deal in goods and practice skills that maximize the business potential which space has to offer. For example, hauling goods around takes time and the more you can carry, the more money is to be made. Appropriate skills and equipment can enlarge the capacity of cargo bays which in turn increases the revenue available from various trade routs. Working the market also requires specialized skills. For example, the range at which buying and selling can take place is entirely reliant upon the trading skills.\n\nBusiness schools imprint into their students the fact that moving cargo around can be risky. Therefore they are also taught how to equip their ships with modules that make them better withstand attacks and ensure a speedy getaway. Might makes right and in this day and age money is where the might lies.\n\nAcute businessmen abound and the only way to beat them is at their own game. Once you understand what drives the market you\'re halfway home to earning your first million.','The art of the market, the pursuit of wealth.',3177),(45,44,'Executive Commander','An executive commander is a broad term for someone trained in leadership. The basic studies revolve about training organization and influence skills. How to use them with success will be for the pilots to figure out when they graduate from the universities.\n\nTraditionally, corporation executives and commanders strive to insure the collective success of a group of people. Some leaders act in the open and command the respect of the masses, but that is by no means the only way to govern, nor necessarily the best one. A truly talented executive commander needs to be able to form a hidden power structure and make it work for his own benefit. The really good ones do it so that noone realizes that fact. And the elite few make their grip on power known but treat their powers so that noone really cares they are being manipulated.\n\nSomeone who has trained the skills is academically better equipped to lead than others, but the magical element is personal charisma and that can not be learnt the easy way. Of all the careers, this is the one closest to being a directly political one. ','The laws that drive the universe.',3176),(47,47,'Prospector','A prospector is someone that scours the world searching for unexploited natural riches and upon finding them, exploits them. The direct route for someone that specializes in prospecting is to become a miner and gather riches from EVE’s numerous asteroid fields, refine them and sell to the highest bidder.\n\nLearning about prospecting does not limit the pilot in any way, but rather opens up a path to easy money. Prospectors that strike it rich are usually quick at making enough money to be able to expand into whatever branch strikes their fancy. Moneymen can gab all they want, but their stocks and bonds are worth nothing without the hard-working individuals that actually create something through their labor.\n\nMoney may grease the wheels of the economy, but it\'s the miners and manufacturers that keep them turning.','The grassroots of wealth creation.',3173),(48,47,'Engineer','While a prospector concentrates on finding raw materials in the vastness of space, engineers study how to make something out of them. They also take a number of science courses that allow them to study and copy blueprints (which are a necessity in all production), produce goods and use cybernetic implants to increase their capabilities.\n\nBeing a successful manufacturer takes a considerable effort in the beginning, as the more complex products take a while to produce. Engineering is an excellent foundation to build a successful space ship career on. Being tech-savvy allows a captain to be more than just the driver of his ship - he becomes the ship\'s master.\n\nIn the hi-tech world of EVE, being comfortable around complex machines can mean the difference between life and death.','The coordination and manipulation of complex machines.',3174),(81,81,'Soldier','A pilot that specializes in soldiering in general becomes very well versed in gunnery and manouvering skills. Training will focus entirely on efficiency in combat, training of combat-relevant attributes and to learn how better to sustain damage. After training, a soldier can turn to anything he wants – There are no preset paths. But if a soldier keeps on advancing the skills alotted in the beginning, corporations, alliances, agents and the like are always looking for people with an accurate targeting eye and sensitive trigger fingers to do their bidding.\n\nThere are always wars to be fought somewhere for those willing! Also, there is good cash to be made from hunting pirates that infest asteroid belts throughout space.','The technology and science behind space ship weaponry.',3179),(82,81,'Special Forces','Pilots that enlist in Special Forces are discharged from military academies well versed in basic combat skills, such as gunnery. Upon graduating, they do not match the brute force and tanking potentials of someone who has specialized in soldiering, but on the other hand they are experts in strategic, electronic warfare using warp disruptors, system scanners and range boosters.\n\nA Special Forces pilot is by no means confined to any profession – like everyone else, he can decide to do whatever he likes, but the skills granted in training make these pilots excellent bounty hunters, chasing after other people’s enemies, supporting heavily tanked fleets or taking their chances as privateers or pirates.','The intriciacies of capsular interfacing.',3180),(84,84,'Entrepreneur','True EVE entrepreneurs wheel and deal in goods and practice skills that maximize the business potential which space has to offer. For example, hauling goods around takes time and the more you can carry, the more money is to be made. Appropriate skills and equipment can enlarge the capacity of cargo bays which in turn increases the revenue available from various trade routs. Working the market also requires specialized skills. For example, the range at which buying and selling can take place is entirely reliant upon the trading skills.\n\nBusiness schools imprint into their students the fact that moving cargo around can be risky. Therefore they are also taught how to equip their ships with modules that make them better withstand attacks and ensure a speedy getaway. Might makes right and in this day and age money is where the might lies.\n\nAcute businessmen abound and the only way to beat them is at their own game. Once you understand what drives the market you\'re halfway home to earning your first million.','The art of the market, the pursuit of wealth.',3177),(85,84,'Executive Commander','An executive commander is a broad term for someone trained in leadership. The basic studies revolve about training organization and influence skills. How to use them with success will be for the pilots to figure out when they graduate from the universities.\n\nTraditionally, corporation executives and commanders strive to ensure the collective success of a group of people. Some leaders act in the open and command the respect of the masses, but that is by no means the only way to govern, nor necessarily the best one. A truly talented executive commander needs to be able to form a hidden power structure and make it work for his own benefit. The really good ones do it so that noone realizes that fact. And the elite few make their grip on power known but treat their powers so that noone really cares they are being manipulated.\n\nSomeone who has trained the skills is academically better equipped to lead than others, but the magical element is personal charisma and that can not be learnt the easy way. Of all the careers, this is the one closest to being a directly political one. ','The laws that drive the universe.',3176),(87,87,'Prospector','A prospector is someone that scours the world searching for unexploited natural riches and upon finding them, exploits them. The direct route for someone that specializes in prospecting is to become a miner and gather riches from EVE’s numerous asteroid fields, refine them and sell to the highest bidder.\n\nLearning about prospecting does not limit the pilot in any way, but rather opens up a path to easy money. Prospectors that strike it rich are usually quick at making enough money to be able to expand into whatever branch strikes their fancy. Moneymen can gab all they want, but their stocks and bonds are worth nothing without the hard-working individuals that actually create something through their labor.\n\nMoney may grease the wheels of the economy, but it\'s the miners and manufacturers that keep them turning.','The grassroots of wealth creation.',3173),(88,87,'Engineer','While a prospector concentrates on finding raw materials in the vastness of space, engineers study how to make something out of them. They also take a number of science courses that allow them to study and copy blueprints (which are a necessity in all production), produce goods and use cybernetic implants to increase their capabilities.\n\nBeing a successful manufacturer takes a considerable effort in the beginning, as the more complex products take a while to produce. Engineering is an excellent foundation to build a successful space ship career on. Being tech-savvy allows a captain to be more than just the driver of his ship - he becomes the ship\'s master.\n\nIn the hi-tech world of EVE, being comfortable around complex machines can mean the difference between life and death.','The coordination and manipulation of complex machines.',3174),(161,161,'Entrepreneur','','',3177),(162,161,'Executive Commander','','',3176),(164,164,'Engineer','','',3174),(165,164,'Prospector','','',3173),(167,167,'Soldier','','',3179),(168,167,'Special Forces','','',3180);

/*Table structure for table `chrRaceSkills` */

DROP TABLE IF EXISTS `chrRaceSkills`;

CREATE TABLE `chrRaceSkills` (
  `raceID` tinyint(3) unsigned NOT NULL,
  `skillTypeID` smallint(6) NOT NULL,
  `levels` tinyint(4) default NULL,
  PRIMARY KEY  (`raceID`,`skillTypeID`),
  KEY `skillTypeID` (`skillTypeID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `chrRaceSkills` */

insert  into `chrRaceSkills`(`raceID`,`skillTypeID`,`levels`) values (1,3300,2),(1,3301,3),(1,3327,3),(1,3330,2),(1,3386,2),(1,3392,2),(1,3402,3),(1,3413,3),(1,3416,2),(1,3426,3),(1,3449,3),(2,3300,2),(2,3302,3),(2,3327,3),(2,3329,2),(2,3386,2),(2,3392,2),(2,3402,3),(2,3413,3),(2,3416,2),(2,3426,3),(2,3449,3),(4,3300,2),(4,3303,3),(4,3327,3),(4,3331,2),(4,3386,2),(4,3392,2),(4,3402,3),(4,3413,3),(4,3416,2),(4,3426,3),(4,3449,3),(8,3300,2),(8,3301,3),(8,3327,3),(8,3328,2),(8,3386,2),(8,3392,2),(8,3402,3),(8,3413,3),(8,3416,2),(8,3426,3),(8,3449,3);

/*Table structure for table `chrSchoolAgents` */

DROP TABLE IF EXISTS `chrSchoolAgents`;

CREATE TABLE `chrSchoolAgents` (
  `schoolID` tinyint(3) unsigned NOT NULL,
  `agentIndex` tinyint(4) NOT NULL,
  `agentID` int(11) default NULL,
  PRIMARY KEY  (`schoolID`,`agentIndex`),
  KEY `agentID` (`agentID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `chrSchoolAgents` */

insert  into `chrSchoolAgents`(`schoolID`,`agentIndex`,`agentID`) values (11,1,3018681),(11,2,3018821),(11,3,3018822),(11,4,3018823),(11,5,3018824),(12,1,3018680),(12,2,3018817),(12,3,3018818),(12,4,3018819),(12,5,3018820),(13,1,3018682),(13,2,3018809),(13,3,3018810),(13,4,3018811),(13,5,3018812),(14,1,3018678),(14,2,3018837),(14,3,3018838),(14,4,3018839),(14,5,3018840),(15,1,3018679),(15,2,3018841),(15,3,3018842),(15,4,3018843),(15,5,3018844),(16,1,3018677),(16,2,3018845),(16,3,3018846),(16,4,3018847),(16,5,3018848),(17,1,3018676),(17,2,3018825),(17,3,3018826),(17,4,3018827),(17,5,3018828),(18,1,3018675),(18,2,3018805),(18,3,3018806),(18,4,3018807),(18,5,3018808),(19,1,3018672),(19,2,3018801),(19,3,3018802),(19,4,3018803),(19,5,3018804),(20,1,3018684),(20,2,3018829),(20,3,3018830),(20,4,3018831),(20,5,3018832),(21,1,3018685),(21,2,3018813),(21,3,3018814),(21,4,3018815),(21,5,3018816),(22,1,3018683),(22,2,3018833),(22,3,3018834),(22,4,3018835),(22,5,3018836);

/*Table structure for table `chrSchools` */

DROP TABLE IF EXISTS `chrSchools`;

CREATE TABLE `chrSchools` (
  `raceID` tinyint(3) unsigned default NULL,
  `schoolID` tinyint(3) unsigned NOT NULL,
  `schoolName` varchar(100) default NULL,
  `description` varchar(1000) default NULL,
  `graphicID` smallint(6) default NULL,
  `corporationID` int(11) default NULL,
  `newAgentID` int(11) default NULL,
  `careerID` tinyint(3) unsigned default NULL,
  PRIMARY KEY  (`schoolID`),
  KEY `raceID` (`raceID`),
  KEY `graphicID` (`graphicID`),
  KEY `corporationID` (`corporationID`),
  KEY `careerID` (`careerID`),
  KEY `newAgentID` (`newAgentID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `chrSchools` */

insert  into `chrSchools`(`raceID`,`schoolID`,`schoolName`,`description`,`graphicID`,`corporationID`,`newAgentID`,`careerID`) values (4,11,'Imperial Academy','The Imperial Academy (from which all Amarr enlists graduate) is rooted in tradition and generally considered sub-par to the more modern military institutes found in the other empires. However, it is the only one of its kind within the Amarr Empire, thus serving a vital function.\n',1447,1000166,3018681,41),(4,12,'Hedion University','Hedion University (graduating the best Business students in the Empire) is located in the Hedion system - the first solar system colonized by the Amarrians after their own. The university was founded by spirited and liberal scholars, free from the scrutinizing eye of the Emperor and his theologians.',1448,1000165,3018680,44),(4,13,'Royal Amarr Institute','One of the oldest educational facilities in the universe (the breeding grounds for future Amarrian industrialists), the Royal Amarr Institute dates from an era when the Amarrians were still confined to their continent on Amarr Prime, before the Empire and the Great Reclaiming.',1449,1000077,3018682,47),(2,14,'Republic Military School','The Republic Military School (from which all Minmatar enlists graduate) was for a long time the bastard child of the Minmatar education system - it existed because it was perceived as needed, but it had no support; most military personnel were Gallente trained. In recent years, however, as the Republic tries to ascertain its total independence, efforts are being made to transform the RMS into a top-notch military school.',1450,1000170,3018678,21),(2,15,'Republic University','The Republic University (from where future Minmatar industrialists graduate) was founded by Minmatar emigrates as a show of support for the fledgling republic shortly after its inception. The school is modeled after the University of Caille and based on the Gallentean education system.',1451,1000171,3018679,27),(2,16,'Pator Tech School','Pator Tech School (from where Minmatar business people are commonly educated) was founded on the principle of helping gifted Minmatar children be better qualified for high-level positions; something the Republic was in dire need of when assembling a new government and administration virtually from scratch. This principle has held intact to this day, even if the foundations of the Republic were firmly set a long time ago.',1458,1000172,3018677,24),(1,17,'State War Academy','The State War Academy (from which all Caldari enlists graduate) was founded shortly after the Caldari State came into being, while the war with the Gallente Federation was still in full swing. Due to this, the academy has always had a very combat oriented slant, as opposed to the broader scope of ship handling.\n',1452,1000167,3018676,11),(1,18,'Science and Trade Institute','Like all Caldari schools, the Science & Trade Institute (from which all Caldari Business Students graduate) has a very formal curriculum that focuses primarily on the practical side of education. This results in a very dull and tedious learning process, but one that is remarkably efficient.',1453,1000045,3018675,14),(1,19,'School of Applied Knowledge','The School of Applied Knowledge (from where future Caldari industrialists graduate) focuses mainly on technical studies and is considered the best school for aspiring engineers. The school collaborates with many leading Caldari corporations, an arrangement which benefits the school, the companies and not the least the students.',1455,1000044,3018672,17),(8,20,'Federal Navy Academy','The Federation Navy (where all Gallente cadets are enlisted) has recently begun upholding extremely strict standards of professionalism for its cadets. The result of these standards, draconian even for a military school, is a leaner, meaner academy with much stricter entry requirements than before and more effective tutoring.',1454,1000168,3018684,81),(8,21,'University of Caille','The largest school in the universe at almost half a million students, the University of Caille has long acted as a melting pot for cultures and ideas from all over. As befits its status, it offers a wide range of studies, but is best known for its extensive anthropology department.',1456,1000115,3018685,84),(8,22,'Center for Advanced Studies','Originally conceived as a think-tank for researchers at Chemal Tech, the Center for Advanced Studies (the breeding grounds for future Gallente industrialists) evolved into an independent educational facility that today is considered one of the very best technical schools in the universe.',1457,1000169,3018683,87),(16,23,'Society of Conscious Thought','The Society of Conscious Thought was founded some 300 years ago. Since then it has seen many guises, including spiritual healing-house and political power-block. Today, it is one of the finest and most respected educational facilities in the world of EVE. As it is only loosely connected to the Jove state the Society admits non-Jovian students. For them, being admitted to a Society school is a great honor and an almost certain ticket to a prestigious position later in life.',NULL,1000131,NULL,161),(16,24,'Material Institute','The Jovians, with all their power and resources, are not always very pragmatic. The Material Institute was founded precisely to combat this. Most Jovians are already well schooled in the technical aspects, but they need some tutoring on the practical application for use in industry and manufacturing.',NULL,1000177,NULL,164),(16,25,'Academy of Aggressive Behaviour','Most Jovians have had their aggressive instincts curbed or even removed through genetic engineering. The Academy for Aggressive Behaviour, responsible for training space cadets, uses the latest in gene therapies to re-introuduce the base instincts to their students to ensure the animalistic nature of humans, so important for fighting, is alive and fresh in them.',NULL,1000178,NULL,167);

/*Table structure for table `crpNPCCorporations` */

DROP TABLE IF EXISTS `crpNPCCorporations`;

CREATE TABLE `crpNPCCorporations` (
  `corporationID` int(11) NOT NULL default '0',
  `mainActivityID` int(11) default NULL,
  `secondaryActivityID` int(11) default NULL,
  `size` varchar(1) default NULL,
  `extent` varchar(1) default NULL,
  `solarSystemID` int(11) default NULL,
  `investorID1` int(11) default NULL,
  `investorShares1` int(11) default NULL,
  `investorID2` int(11) default NULL,
  `investorShares2` int(11) default NULL,
  `investorID3` int(11) default NULL,
  `investorShares3` int(11) default NULL,
  `investorID4` int(11) default NULL,
  `investorShares4` int(11) default NULL,
  `friendID` int(11) default NULL,
  `enemyID` int(11) default NULL,
  `publicShares` int(11) default NULL,
  `initialPrice` int(11) default NULL,
  `minSecurity` double default NULL,
  `scattered` int(11) default NULL,
  `fringe` int(11) default NULL,
  `corridor` int(11) default NULL,
  `hub` int(11) default NULL,
  `border` int(11) default NULL,
  `factionID` int(11) default NULL,
  `sizeFactor` double default NULL,
  `stationCount` int(11) default NULL,
  `stationSystemCount` int(11) default NULL,
  PRIMARY KEY  (`corporationID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `crpNPCCorporations` */

insert  into `crpNPCCorporations`(`corporationID`,`mainActivityID`,`secondaryActivityID`,`size`,`extent`,`solarSystemID`,`investorID1`,`investorShares1`,`investorID2`,`investorShares2`,`investorID3`,`investorShares3`,`investorID4`,`investorShares4`,`friendID`,`enemyID`,`publicShares`,`initialPrice`,`minSecurity`,`scattered`,`fringe`,`corridor`,`hub`,`border`,`factionID`,`sizeFactor`,`stationCount`,`stationSystemCount`) values (1000002,10,NULL,'H','G',30002780,1000002,42,NULL,35,1000013,14,1000006,9,1000006,1000005,0,47,0,1,4,3,2,4,500001,1.75,90,56),(1000003,10,NULL,'M','R',30000149,1000025,70,NULL,20,NULL,8,1000023,2,1000040,1000009,0,5,-1,1,3,3,3,4,500001,1.25,12,9),(1000004,10,NULL,'L','N',30001399,1000010,55,NULL,26,1000012,15,1000052,4,1000039,1000007,0,40,0,0,2,3,4,4,500001,1.5,40,31),(1000005,3,NULL,'H','N',30002801,NULL,34,NULL,28,1000005,25,1000009,12,1000019,1000002,0,23,0,0,4,3,2,3,500001,1.75,60,35),(1000006,3,NULL,'M','R',30002775,1000002,55,1000013,25,NULL,15,NULL,5,1000013,1000021,0,51,-1,1,5,1,1,3,500001,1.5,12,7),(1000007,3,NULL,'L','N',30000152,1000025,67,NULL,17,1000003,15,NULL,1,1000003,1000008,0,20,-1,1,4,2,2,4,500001,1.75,40,31),(1000008,3,NULL,'M','N',30001394,1000019,51,1000030,25,NULL,20,NULL,4,1000035,1000012,0,65,-1,1,3,3,3,4,500001,1.5,30,24),(1000009,1,NULL,'L','N',30002800,1000005,75,NULL,18,1000029,5,NULL,2,1000043,1000024,0,38,0,0,4,2,4,2,500001,1.75,43,31),(1000010,19,7,'H','G',30001401,1000010,39,1000028,28,NULL,25,1000029,8,1000028,1000017,0,81,0,0,3,3,3,3,500001,2,93,54),(1000011,19,NULL,'L','G',30001356,1000011,76,1000029,24,NULL,0,NULL,0,1000014,1000025,0,67,0,0,2,4,3,3,500001,1.75,61,38),(1000012,19,NULL,'M','C',30001409,1000020,51,NULL,30,1000028,10,1000009,9,1000009,1000027,0,36,0,0,2,3,3,2,500001,1.25,3,2),(1000013,19,NULL,'M','N',30002775,1000002,55,NULL,35,1000024,6,NULL,4,1000002,NULL,0,29,0,0,3,3,3,1,500001,1.25,30,23),(1000014,19,NULL,'L','N',30002805,1000005,65,1000011,20,1000008,9,1000050,6,1000033,1000013,0,77,0,0,2,3,4,2,500001,1.5,40,23),(1000015,19,NULL,'L','N',30000147,1000025,70,NULL,15,1000007,9,NULL,6,1000034,1000014,0,12,0,0,3,4,3,3,500001,1.75,40,31),(1000016,6,NULL,'S','N',30001397,1000019,66,NULL,22,1000030,7,1000029,5,1000038,1000004,0,95,1,0,4,2,2,4,500001,1,20,17),(1000017,8,NULL,'L','G',30000156,NULL,38,1000017,28,1000030,20,NULL,14,1000025,1000010,0,70,-1,0,2,3,4,3,500001,2,60,37),(1000018,8,NULL,'S','N',30001402,1000010,54,NULL,19,NULL,15,1000029,12,1000031,1000034,0,58,0,0,1,2,4,2,500001,1,20,17),(1000019,7,NULL,'L','G',30001393,1000019,31,NULL,26,NULL,23,1000016,20,1000005,1000020,0,78,0,0,4,3,3,4,500001,2,61,42),(1000020,7,NULL,'L','N',30001404,NULL,35,NULL,33,1000020,17,1000028,15,1000037,1000019,0,59,0,0,4,3,2,3,500001,1.75,41,33),(1000021,7,NULL,'T','C',30001398,1000010,60,NULL,25,1000028,10,1000016,5,1000004,1000023,0,4,0,0,5,1,1,1,500001,1,1,1),(1000022,7,NULL,'S','N',30001358,1000010,51,1000011,33,1000029,12,1000014,4,1000128,1000012,0,75,0,0,3,3,3,2,500001,1,20,16),(1000023,11,NULL,'H','G',30000154,1000017,51,NULL,24,1000015,15,NULL,10,1000036,1000018,0,69,0,1,2,4,4,4,500001,1.75,90,55),(1000024,11,NULL,'M','R',30002778,1000002,80,NULL,11,1000003,6,NULL,3,1000041,1000030,0,37,0,1,2,3,4,3,500001,1.25,12,9),(1000025,2,19,'H','N',30000146,1000025,51,NULL,28,NULL,15,NULL,5,1000015,1000011,0,37,0,0,3,3,3,3,500001,2,60,40),(1000026,2,NULL,'L','N',30001403,1000010,65,1000028,17,NULL,14,1000011,4,1000011,1000015,0,61,0,0,3,2,3,4,500001,1.75,42,28),(1000027,2,NULL,'M','N',30000157,1000017,55,NULL,20,1000030,15,NULL,10,1000032,1000026,0,45,0,0,2,3,3,2,500001,1.5,30,26),(1000028,17,NULL,'S','N',30001400,1000010,70,NULL,22,1000029,5,1000020,3,1000021,1000016,0,62,0,0,2,3,4,2,500001,1,20,18),(1000029,17,NULL,'S','N',30001357,1000011,75,NULL,20,NULL,5,NULL,0,1000018,1000003,0,24,1,0,3,3,3,3,500001,1,20,17),(1000030,17,NULL,'S','G',30000126,1000017,55,NULL,25,NULL,15,NULL,5,1000027,1000028,0,64,0,1,2,3,3,4,500001,1,30,23),(1000031,14,NULL,'S','N',30000145,1000017,25,1000010,25,1000025,25,1000019,25,1000010,1000035,0,20,1,0,1,2,4,1,500001,1,20,19),(1000032,14,NULL,'S','N',30000127,1000017,40,1000025,30,1000010,30,NULL,0,1000017,1000033,0,101,2,0,2,2,4,2,500001,1,20,20),(1000033,15,13,'H','G',30000140,1000031,100,NULL,0,NULL,0,NULL,0,1000030,1000031,0,20,1,0,3,3,3,4,500001,1.75,90,60),(1000034,13,NULL,'T','N',30000145,1000031,100,NULL,0,NULL,0,NULL,0,NULL,1000029,0,20,0,0,2,2,3,2,500001,1,11,10),(1000035,5,NULL,'H','N',30000144,1000031,100,NULL,0,NULL,0,NULL,0,1000031,1000120,0,20,0,0,3,3,3,4,500001,1.75,71,39),(1000036,5,NULL,'S','C',30000153,1000017,100,NULL,0,NULL,0,NULL,0,1000023,1000039,0,20,0,0,3,2,3,1,500001,1,2,1),(1000037,5,NULL,'S','R',30001404,1000020,100,NULL,0,NULL,0,NULL,0,1000012,1000038,0,20,0,0,4,3,2,3,500001,1.25,12,6),(1000038,5,NULL,'M','R',30001393,1000019,100,NULL,0,NULL,0,NULL,0,1000008,1000037,0,20,0,0,4,3,3,4,500001,1.25,12,11),(1000039,5,NULL,'L','R',30001401,1000010,100,NULL,0,NULL,0,NULL,0,1000026,1000036,0,20,0,0,3,3,3,3,500001,1.25,21,11),(1000040,5,NULL,'M','R',30000146,1000025,100,NULL,0,NULL,0,NULL,0,1000007,1000042,0,20,0,0,3,3,3,3,500001,1.25,12,10),(1000041,5,NULL,'H','N',30002780,1000002,100,NULL,0,NULL,0,NULL,0,1000024,1000043,0,20,0,1,2,3,4,4,500001,1.25,60,40),(1000042,5,NULL,'M','R',30001356,1000011,100,NULL,0,NULL,0,NULL,0,1000022,1000040,0,20,0,0,2,4,3,3,500001,1.25,14,10),(1000043,5,NULL,'L','N',30002801,NULL,100,NULL,0,NULL,0,NULL,0,1000014,1000041,0,20,0,0,2,3,4,3,500001,1.25,40,31),(1000044,18,NULL,'T','N',30001407,1000020,60,1000021,20,1000028,15,NULL,5,1000020,NULL,0,200,1,1,4,2,2,2,500001,1.75,11,10),(1000045,18,NULL,'T','N',30001392,1000019,70,1000030,12,1000016,10,1000022,8,1000016,1000022,0,200,1,1,2,3,3,2,500001,1.75,14,10),(1000046,14,NULL,'M','R',30003413,1000046,100,NULL,0,NULL,0,NULL,0,1000056,1000061,0,20,-1,0,2,3,4,4,500002,1.5,12,7),(1000047,14,NULL,'M','R',30002053,1000047,100,NULL,0,NULL,0,NULL,0,1000061,1000046,0,20,-3,0,4,2,2,2,500002,1.5,12,8),(1000048,14,NULL,'M','R',30002385,1000048,100,NULL,0,NULL,0,NULL,0,1000060,1000055,0,20,-4,0,2,4,4,3,500002,1.5,12,9),(1000049,14,NULL,'M','R',30002510,1000049,100,NULL,0,NULL,0,NULL,0,1000057,1000052,0,20,-1,0,3,3,3,3,500002,1.5,12,9),(1000050,14,NULL,'L','N',30003377,1000046,35,1000047,30,1000048,15,1000049,20,1000046,1000054,0,20,0,0,2,3,4,2,500002,1.5,40,33),(1000051,5,NULL,'H','N',30002544,1000046,20,1000047,30,1000048,15,1000049,35,1000049,1000123,0,20,-1,0,3,3,3,4,500002,1.75,60,40),(1000052,15,NULL,'L','N',30003374,1000046,35,1000047,20,1000048,30,1000049,15,1000050,1000058,0,20,0,0,2,2,4,2,500002,1.5,40,31),(1000053,13,NULL,'M','C',30002507,1000046,20,1000047,15,1000048,35,1000049,30,1000048,1000059,0,20,0,0,3,3,4,3,500002,1.25,4,3),(1000054,5,NULL,'L','G',30002544,1000046,20,1000047,35,1000048,30,1000049,15,1000047,1000051,0,20,-2,0,3,3,3,3,500002,1.75,60,51),(1000055,3,NULL,'H','N',30002050,NULL,40,1000057,30,NULL,25,1000056,5,1000057,1000062,0,22,-1,1,4,3,2,4,500002,2,60,32),(1000056,19,10,'H','G',30003415,NULL,40,1000046,40,1000112,20,NULL,0,1000108,1000160,0,95,0,0,2,3,3,3,500002,2,90,55),(1000057,19,NULL,'M','R',30002050,1000061,45,1000047,25,1000049,18,NULL,12,1000051,1000160,0,54,0,0,3,3,2,2,500002,1.25,12,9),(1000058,6,NULL,'S','L',30003412,NULL,51,1000047,22,NULL,21,1000048,6,1000054,1000049,0,78,-1,0,4,2,2,4,500002,1,2,2),(1000059,2,NULL,'M','R',30002510,1000049,67,NULL,25,NULL,8,NULL,0,1000055,1000053,0,26,0,0,3,3,3,3,500002,1.5,12,8),(1000060,1,NULL,'M','L',30002386,NULL,30,1000048,30,NULL,25,1000018,15,1000053,1000057,0,19,0,0,4,3,3,2,500002,1.5,4,2),(1000061,10,11,'H','G',30002048,1000047,40,NULL,33,NULL,20,1000049,7,1000051,1000048,0,91,-2,1,2,3,4,4,500002,2,90,61),(1000062,8,NULL,'S','N',30003414,1000062,40,1000056,25,1000028,20,1000057,15,1000058,1000106,0,40,-1,0,2,3,3,3,500002,1,20,18),(1000063,2,NULL,'L','N',30002228,1000063,55,NULL,30,1000078,15,NULL,0,1000079,1000065,0,10,0,0,2,3,4,3,500003,1.75,40,27),(1000064,7,2,'H','N',30001669,NULL,45,1000088,35,1000069,20,NULL,0,1000088,1000151,0,99,0,0,4,3,2,2,500003,2,60,33),(1000065,19,NULL,'L','G',30003488,NULL,51,NULL,25,1000078,15,NULL,9,1000077,1000079,0,61,1,0,3,4,2,3,500003,1.75,60,41),(1000066,19,NULL,'M','R',30001670,1000066,51,1000090,30,1000072,19,NULL,0,1000087,1000151,0,44,0,0,2,4,3,2,500003,1.25,12,10),(1000067,19,NULL,'L','N',30002988,1000067,60,1000151,35,NULL,5,NULL,0,1000151,1000083,0,51,0,0,3,3,3,3,500003,1.75,40,29),(1000068,19,NULL,'M','R',30004094,NULL,55,1000078,25,1000077,20,NULL,0,1000078,1000071,0,20,0,0,2,3,4,1,500003,1.25,12,8),(1000069,3,NULL,'M','G',30002989,1000067,80,NULL,20,NULL,0,NULL,0,1000067,1000064,0,78,0,0,4,3,1,4,500003,1.25,45,38),(1000070,3,NULL,'M','R',30003525,NULL,51,1000154,35,1000088,14,NULL,0,1000123,1000081,0,25,0,0,4,2,2,4,500003,1.25,12,8),(1000071,6,NULL,'S','N',30004093,NULL,70,1000085,18,NULL,12,NULL,0,NULL,1000066,0,11,0,0,4,2,4,3,500003,1.5,20,16),(1000072,10,NULL,'H','N',30005039,NULL,51,NULL,40,1000065,9,NULL,0,1000074,1000070,0,9,-1,0,3,3,4,4,500003,2,60,43),(1000073,8,NULL,'S','N',30005043,1000073,45,NULL,45,1000082,10,NULL,0,NULL,NULL,0,36,0,0,3,3,3,3,500003,1,20,20),(1000074,1,3,'H','G',30005036,NULL,80,NULL,20,NULL,0,NULL,0,1000073,1000075,0,41,0,0,4,3,3,2,500003,2,90,51),(1000075,1,NULL,'L','G',30001673,NULL,51,NULL,33,NULL,16,NULL,0,1000083,1000076,0,58,0,0,2,4,2,3,500003,1.25,60,42),(1000076,1,NULL,'M','L',30002231,NULL,67,NULL,33,NULL,0,NULL,0,1000063,1000074,0,13,0,0,3,3,2,1,500003,1.25,3,3),(1000077,18,NULL,'T','N',30001672,1000064,45,1000085,35,1000093,20,NULL,0,1000064,NULL,0,200,1,0,4,3,3,2,500003,1.75,15,10),(1000078,13,NULL,'M','R',30002198,1000078,60,NULL,30,NULL,10,NULL,0,NULL,1000080,0,20,1,0,1,2,4,2,500003,1,12,11),(1000079,13,NULL,'L','N',30002201,1000079,60,NULL,25,1000078,15,NULL,0,1000081,1000084,0,20,0,0,3,3,3,3,500003,1.5,40,29),(1000080,13,NULL,'L','N',30002197,NULL,55,1000080,30,1000084,15,NULL,0,1000084,1000082,0,20,1,0,5,1,1,4,500003,1.5,40,29),(1000081,13,NULL,'L','N',30004098,NULL,65,1000081,20,1000079,15,NULL,0,1000070,1000069,0,20,0,0,4,3,2,4,500003,1.5,40,30),(1000082,5,NULL,'L','N',30002199,NULL,70,1000082,20,1000093,10,NULL,0,1000093,1000078,0,20,-1,0,1,1,5,3,500003,1.5,40,29),(1000083,13,NULL,'L','N',30002200,1000083,55,1000091,30,1000079,15,NULL,0,1000069,1000072,0,20,0,1,2,3,4,3,500003,1.75,40,26),(1000084,5,NULL,'L','N',30002279,1000086,100,NULL,0,NULL,0,NULL,0,1000086,1000051,0,20,0,0,4,3,3,4,500003,1.75,42,31),(1000085,14,NULL,'S','L',30002189,1000085,70,NULL,20,NULL,10,NULL,0,1000065,1000063,0,20,1,0,1,1,5,1,500003,1,2,2),(1000086,14,NULL,'L','N',30002187,NULL,80,NULL,20,NULL,0,NULL,0,NULL,1000093,0,20,2,0,1,2,4,1,500003,1.5,40,31),(1000087,14,NULL,'M','R',30004095,NULL,70,NULL,30,NULL,0,NULL,0,1000071,1000092,0,20,1,0,2,3,4,2,500003,1.25,12,10),(1000088,5,NULL,'M','R',30003522,NULL,90,NULL,10,NULL,0,NULL,0,1000080,NULL,0,20,0,0,4,3,2,3,500003,1.25,12,11),(1000089,14,NULL,'M','R',30005038,NULL,90,NULL,10,NULL,0,NULL,0,1000085,NULL,0,20,1,0,3,4,3,3,500003,1.25,12,9),(1000090,14,NULL,'M','R',30002231,NULL,90,NULL,10,NULL,0,NULL,0,1000068,1000077,0,20,1,0,2,4,3,1,500003,1.25,12,10),(1000091,14,NULL,'M','R',30001671,1000091,100,NULL,0,NULL,0,NULL,0,1000092,1000085,0,20,0,0,4,3,2,4,500003,1.25,12,8),(1000092,15,NULL,'L','N',30004078,NULL,75,1000092,20,1000093,5,NULL,0,1000082,1000067,0,20,1,0,2,3,3,2,500003,1,40,32),(1000093,15,NULL,'L','N',30002270,1000086,55,1000093,25,NULL,20,NULL,0,NULL,1000073,0,20,2,0,1,3,4,1,500003,1.75,40,30),(1000094,10,NULL,'H','G',30002706,1000094,60,1000111,25,1000133,10,NULL,5,1000111,1000099,0,37,-2,1,3,3,4,4,500004,2,89,53),(1000095,10,NULL,'L','N',30003039,NULL,65,1000100,20,1000113,15,NULL,0,1000097,1000110,0,7,0,1,2,4,4,3,500004,1.75,40,31),(1000096,10,NULL,'S','C',30003830,1000112,33,1000098,28,1000101,21,NULL,18,1000099,1000114,0,11,0,0,3,3,3,1,500004,1,2,2),(1000097,3,NULL,'L','N',30003570,1000100,67,1000102,20,1000111,13,NULL,0,1000102,1000098,0,25,0,1,4,2,2,2,500004,1.5,40,32),(1000098,3,NULL,'H','N',30005304,NULL,52,1000112,23,NULL,15,NULL,10,1000101,1000094,0,29,-1,0,4,3,2,3,500004,2,60,34),(1000099,1,NULL,'L','N',30003574,NULL,48,1000112,27,NULL,13,NULL,12,1000117,1000111,0,8,0,0,4,3,3,2,500004,1.75,40,29),(1000100,19,11,'H','G',30003025,NULL,46,NULL,41,1000114,8,NULL,5,1000119,1000105,0,71,-1,0,3,3,3,3,500004,2,91,58),(1000101,19,NULL,'L','G',30003048,1000108,35,1000002,35,1000111,20,1000114,10,1000109,1000115,0,58,0,0,2,3,3,3,500004,1.5,60,42),(1000102,19,NULL,'M','N',30005304,NULL,85,1000114,15,NULL,0,NULL,0,1000103,1000100,0,18,0,0,3,4,3,2,500004,1.25,30,23),(1000103,19,NULL,'S','C',30003570,1000103,51,1000102,49,NULL,0,NULL,0,1000056,1000109,0,5,0,0,2,3,4,3,500004,1,2,2),(1000104,6,NULL,'S','G',30005304,NULL,60,1000108,20,1000135,15,NULL,5,1000107,1000122,0,21,0,0,3,3,3,4,500004,1,30,26),(1000105,8,NULL,'S','G',30003038,NULL,95,1000114,5,NULL,0,NULL,0,1000114,1000116,0,42,0,0,2,3,4,4,500004,1,30,26),(1000106,8,NULL,'S','N',30003043,NULL,55,1000100,40,NULL,5,NULL,0,1000121,1000118,0,105,0,0,1,4,4,4,500004,1,20,17),(1000107,8,NULL,'S','G',30003830,1000107,73,1000104,14,1000064,8,NULL,5,1000094,1000120,0,47,-1,0,3,3,3,3,500004,1,30,26),(1000108,7,19,'M','G',30002706,NULL,67,1000112,15,1000111,11,NULL,7,1000101,1000102,0,68,0,0,3,4,3,4,500004,1.5,45,36),(1000109,7,NULL,'M','N',30003048,1000100,55,1000112,30,1000114,15,NULL,4,1000101,1000020,0,33,0,0,4,3,2,2,500004,1.5,31,30),(1000110,11,10,'H','N',30003792,NULL,59,1000096,28,1000112,13,NULL,0,1000096,1000102,0,25,0,1,2,4,4,3,500004,1.75,60,40),(1000111,11,NULL,'L','G',30002712,1000111,60,1000112,20,1000110,20,NULL,10,1000120,1000100,0,85,0,1,2,3,4,4,500004,1.75,60,48),(1000112,17,NULL,'S','N',30004972,NULL,57,1000117,33,NULL,10,NULL,0,1000113,1000121,0,12,1,0,2,3,3,2,500004,1,20,17),(1000113,17,NULL,'M','G',30003792,NULL,66,NULL,34,NULL,0,NULL,0,1000110,1000101,0,90,-1,1,3,3,3,3,500004,1.5,45,32),(1000114,17,NULL,'S','N',30003025,1000100,67,NULL,20,NULL,13,NULL,0,1000115,1000109,0,39,0,0,2,3,4,2,500004,1,20,15),(1000115,18,NULL,'T','N',30002715,1000108,40,1000113,30,1000100,30,NULL,0,1000108,1000117,0,200,1,0,3,3,4,4,500004,1.75,13,10),(1000116,14,NULL,'S','L',30004999,1000116,60,NULL,20,1000117,20,NULL,0,1000105,1000100,0,20,2,0,1,2,4,1,500004,1,2,2),(1000117,14,NULL,'S','C',30004993,1000117,55,NULL,35,1000119,10,NULL,0,1000104,1000107,0,20,2,0,1,3,4,2,500004,1,2,2),(1000118,15,NULL,'S','L',30004993,1000118,60,1000116,40,NULL,0,NULL,0,1000100,1000095,0,20,2,0,1,1,5,1,500004,1,2,2),(1000119,13,NULL,'L','N',30004972,NULL,55,NULL,25,1000117,20,NULL,0,1000106,1000103,0,20,0,0,3,3,3,3,500004,1.75,40,31),(1000120,5,NULL,'H','N',30004972,1000116,55,NULL,35,1000119,10,NULL,0,1000118,1000106,0,20,0,0,3,3,3,4,500004,1.75,60,39),(1000121,5,NULL,'M','N',30004970,1000116,40,NULL,35,1000120,20,NULL,5,1000116,1000097,0,20,-2,0,3,3,3,3,500004,1.25,30,25),(1000122,5,NULL,'L','N',30004967,1000120,55,1000119,40,NULL,5,NULL,0,1000112,1000108,0,20,-1,0,2,3,4,5,500004,1.75,40,28),(1000123,5,NULL,'S','N',30000005,1000126,90,1000084,10,NULL,0,NULL,0,1000126,1000051,0,20,-2,0,3,3,3,4,500007,1.25,20,19),(1000124,5,NULL,'M','G',30001025,1000138,70,NULL,30,NULL,0,NULL,0,1000138,1000121,0,38,-10,1,3,3,3,4,500011,1.5,24,21),(1000125,14,5,'H','G',30005204,NULL,100,NULL,0,NULL,0,NULL,0,1000149,1000138,0,20,0,1,3,3,3,3,500006,2,90,58),(1000126,14,NULL,'T','N',30000001,NULL,80,1000078,10,NULL,10,NULL,0,1000078,1000050,0,20,0,0,2,3,4,2,500007,1,10,10),(1000127,5,NULL,'S','R',30001290,NULL,100,NULL,0,NULL,0,NULL,0,1000157,1000035,0,51,-10,0,2,3,3,4,500010,1.25,8,7),(1000128,5,NULL,'T','L',30002005,1000035,35,NULL,30,1000031,25,NULL,0,1000039,1000136,0,21,0,0,3,3,2,3,500018,1,1,1),(1000129,3,NULL,'S','R',30004504,NULL,60,NULL,40,NULL,0,NULL,0,1000103,1000141,0,93,-1,0,4,2,2,3,500014,1.25,4,2),(1000130,14,NULL,'M','G',30001978,NULL,100,NULL,0,NULL,0,NULL,0,1000115,1000161,0,80,1,1,2,3,4,3,500016,1.5,45,38),(1000131,18,NULL,'S','R',30002423,1000150,60,NULL,35,NULL,5,NULL,0,1000150,1000159,0,115,1,0,5,1,1,2,500017,1,2,1),(1000132,17,NULL,'S','L',30005204,1000125,100,NULL,0,NULL,0,NULL,0,1000032,1000144,0,20,1,0,2,3,4,3,500006,1.25,3,2),(1000133,12,4,'S','G',30001048,1000138,80,1000124,20,NULL,0,NULL,0,1000145,1000139,0,24,-8,1,3,3,3,2,500011,1.25,16,16),(1000134,5,NULL,'S','R',30004709,NULL,100,NULL,0,NULL,0,NULL,0,1000160,1000084,0,7,-10,0,4,3,2,3,500012,1.25,13,12),(1000135,4,NULL,'M','G',30004623,NULL,75,NULL,25,NULL,0,NULL,0,1000136,1000120,0,77,-10,1,4,2,2,2,500020,1.25,78,16),(1000136,5,NULL,'S','G',30004617,1000138,60,1000124,40,NULL,0,NULL,0,1000135,1000149,0,18,-10,1,4,2,2,2,500011,1,16,14),(1000137,5,NULL,'M','G',30005204,1000125,100,NULL,0,NULL,0,NULL,0,1000125,1000138,0,20,-4,1,3,3,3,4,500006,1.25,45,37),(1000138,5,NULL,'T','G',30001045,NULL,90,1000124,10,NULL,0,NULL,0,1000124,1000137,0,45,-10,1,3,3,4,3,500011,1,8,8),(1000139,1,NULL,'S','C',30001978,NULL,100,NULL,0,NULL,0,NULL,0,1000075,1000133,0,31,1,0,2,3,3,2,500016,1.25,2,2),(1000140,6,NULL,'L','G',30001484,1000150,100,NULL,0,NULL,0,NULL,0,1000074,1000104,0,90,0,0,4,2,2,4,500005,1.75,60,51),(1000141,7,9,'T','C',30001291,1000127,90,1000160,10,NULL,0,NULL,0,1000160,1000120,0,63,-10,0,3,3,3,2,500010,1,1,1),(1000142,7,NULL,'S','G',30001481,1000150,100,NULL,0,NULL,0,NULL,0,1000064,1000016,0,104,1,0,2,3,4,4,500005,1,30,26),(1000143,15,NULL,'T','L',30005204,1000125,100,NULL,0,NULL,0,NULL,0,1000130,1000134,0,20,2,0,2,3,3,2,500006,1,1,1),(1000144,17,NULL,'S','R',30003274,1000147,80,NULL,20,NULL,0,NULL,0,1000113,1000119,0,55,-1,0,2,3,4,2,500009,1,8,6),(1000145,12,NULL,'S','R',30003269,1000147,51,1000144,25,NULL,24,NULL,0,1000133,1000033,0,29,-2,0,3,3,4,4,500009,1,8,7),(1000146,5,NULL,'S','N',30003271,1000147,100,NULL,0,NULL,0,NULL,0,1000147,1000127,0,20,-2,0,3,3,3,4,500009,1,20,20),(1000147,14,NULL,'M','N',30003271,NULL,100,NULL,0,NULL,0,NULL,0,1000116,1000130,0,87,-2,0,3,3,3,3,500009,1.25,30,24),(1000148,11,NULL,'L','G',30005203,NULL,100,NULL,0,NULL,0,NULL,0,1000125,1000162,0,32,-10,1,3,3,3,3,500013,1.75,0,0),(1000149,5,NULL,'M','N',30001480,1000150,100,NULL,0,NULL,0,NULL,0,1000137,1000135,0,20,0,0,3,3,3,4,500005,1.75,30,25),(1000150,14,NULL,'H','N',30001480,NULL,100,NULL,0,NULL,0,NULL,0,1000131,NULL,0,20,1,0,3,3,3,2,500005,2,60,38),(1000151,7,NULL,'T','C',30003863,1000156,51,1000020,30,1000067,15,NULL,4,1000022,1000157,0,60,0,0,2,4,3,2,500008,1,1,1),(1000152,10,NULL,'T','N',30003863,1000156,55,1000010,25,1000004,20,NULL,0,1000072,1000124,0,52,-1,0,2,3,3,4,500008,1,10,10),(1000153,9,NULL,'T','C',30003863,1000156,60,1000014,25,NULL,15,NULL,0,1000014,1000064,0,38,0,0,2,3,3,3,500008,1,1,1),(1000154,3,NULL,'T','R',30000007,1000126,55,1000069,30,NULL,15,NULL,0,1000069,1000055,0,25,-3,0,4,3,2,4,500007,1,4,4),(1000155,17,NULL,'S','N',30001480,1000150,100,NULL,0,NULL,0,NULL,0,1000034,1000083,0,54,1,0,2,2,4,2,500005,1.25,20,18),(1000156,5,NULL,'S','N',30003860,NULL,100,NULL,0,NULL,0,NULL,0,1000035,1000084,0,20,0,0,3,3,3,4,500008,1.25,20,15),(1000157,6,NULL,'T','C',30004623,1000135,80,1000138,20,NULL,0,NULL,0,1000058,1000021,0,81,-10,1,4,2,2,2,500020,1,1,1),(1000158,9,NULL,'S','N',30001481,1000150,100,NULL,0,NULL,0,NULL,0,1000008,1000019,0,101,1,0,2,4,3,2,500005,1,20,17),(1000159,18,NULL,'T','L',30001978,1000130,100,NULL,0,NULL,0,NULL,0,1000118,1000093,0,20,2,0,5,1,1,1,500016,1,1,1),(1000160,7,NULL,'S','G',30000905,NULL,100,NULL,10,NULL,0,NULL,0,1000047,1000046,0,11,-5,1,3,3,4,4,500015,1,30,27),(1000161,9,5,'M','G',30001868,NULL,60,1000162,40,NULL,0,NULL,0,1000144,1000125,0,71,-10,1,3,3,3,3,500019,1.25,45,33),(1000162,3,5,'S','G',30001868,1000162,60,1000161,40,NULL,0,NULL,0,1000134,1000125,0,58,-10,1,3,3,3,3,500019,1,30,28),(1000163,12,NULL,'S','G',30000905,1000163,75,1000062,15,1000160,10,NULL,0,1000049,1000051,0,10,-5,1,2,4,4,4,500015,1.25,30,27),(1000164,4,NULL,'M','G',30001484,1000150,100,NULL,0,NULL,0,NULL,0,1000108,1000135,0,85,0,1,4,3,3,4,500005,1.5,45,27),(1000165,18,NULL,'T','N',30005042,NULL,0,NULL,0,NULL,0,NULL,0,NULL,NULL,0,200,0,0,0,0,0,0,500003,1.75,14,10),(1000166,18,NULL,'T','N',30003489,NULL,0,NULL,0,NULL,0,NULL,0,NULL,NULL,0,200,0,0,0,0,0,0,500003,1.75,15,10),(1000167,18,NULL,'T','N',30000141,NULL,0,NULL,0,NULL,0,NULL,0,NULL,NULL,0,200,0,0,0,0,0,0,500001,1.75,14,10),(1000168,18,NULL,'T','N',30004971,NULL,0,NULL,0,NULL,0,NULL,0,NULL,NULL,0,200,0,0,0,0,0,0,500004,1.75,15,10),(1000169,18,NULL,'T','N',30005305,NULL,0,NULL,0,NULL,0,NULL,0,NULL,NULL,0,200,0,0,0,0,0,0,500004,1.75,14,10),(1000170,18,NULL,'T','N',30002547,NULL,0,NULL,0,NULL,0,NULL,0,NULL,NULL,0,200,0,0,0,0,0,0,500002,1.75,16,10),(1000171,18,NULL,'T','N',30002505,NULL,0,NULL,0,NULL,0,NULL,0,NULL,NULL,0,200,0,0,0,0,0,0,500002,1.75,15,10),(1000172,18,NULL,'T','N',30003410,NULL,0,NULL,0,NULL,0,NULL,0,NULL,NULL,0,200,0,0,0,0,0,0,500002,1.75,15,10),(1000177,18,NULL,'T','N',30001479,NULL,0,NULL,0,NULL,0,NULL,0,NULL,NULL,0,0,0,0,0,0,0,0,500005,1.25,1,1),(1000178,18,NULL,'T','N',30001482,NULL,0,NULL,0,NULL,0,NULL,0,NULL,NULL,0,0,0,0,0,0,0,0,500005,1.25,1,1),(1000179,5,NULL,'S','N',30003072,1000084,80,1000080,20,NULL,0,NULL,0,1000180,1000182,0,20,0,0,3,3,3,4,500003,1,17,17),(1000180,5,NULL,'S','N',30000142,1000035,100,NULL,0,NULL,0,NULL,0,1000179,1000181,0,20,0,0,3,3,3,4,500001,1,16,16),(1000181,5,NULL,'S','N',30003847,1000120,70,1000121,15,1000122,15,NULL,0,1000182,1000180,0,20,0,0,3,3,3,4,500004,1,17,17),(1000182,5,NULL,'S','N',30002094,1000051,70,1000054,30,NULL,0,NULL,0,1000181,1000179,0,20,0,0,3,3,3,4,500002,1,15,15);

/*Table structure for table `crpNPCCorporationTrades` */

DROP TABLE IF EXISTS `crpNPCCorporationTrades`;

CREATE TABLE `crpNPCCorporationTrades` (
  `corporationID` int(11) default NULL,
  `typeID` int(11) default NULL,
  `supplyDemand` double default NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `crpNPCCorporationTrades` */

insert  into `crpNPCCorporationTrades`(`corporationID`,`typeID`,`supplyDemand`) values (1000002,41,0.424301651309783),(1000002,43,-0.671140504149387),(1000002,421,0.300114315804562),(1000002,518,0.775008232537086),(1000002,672,0.0697351979874206),(1000002,786,0.194506157555047),(1000002,967,0.0697351979874206),(1000002,1010,0.203714265385797),(1000002,1026,0.250433366002142),(1000002,1032,0.145367158457187),(1000002,1072,0.366952571787724),(1000002,1102,0.266450627061955),(1000002,1105,0.312579484016383),(1000002,1109,0.282533822130327),(1000002,1116,0.263228573138788),(1000002,1130,0.108646600322822),(1000002,1133,0.153125955405783),(1000002,3243,0.505488198166489),(1000002,3293,0.433332630988336),(1000002,3297,0.433332630988336),(1000002,3567,0.281967431286982),(1000002,3699,-0.27914122434379),(1000002,9852,0.566390429763373),(1000002,11562,0.145367158457187),(1000002,11614,0.334671699123577),(1000002,12057,0.366952571787724),(1000002,12067,0.366952571787724),(1000002,12237,0.199849958741562),(1000002,12238,0.173793914716357),(1000002,12239,0.173793914716357),(1000002,12266,0.166666),(1000002,12270,0.166666),(1000002,13780,0.199849958741562),(1000002,14343,0.173793914716357),(1000002,16216,0.199849958741562),(1000002,16220,0.199849958741562),(1000002,16221,0.199849958741562),(1000002,16279,0.199849958741562),(1000002,16869,0.199849958741562),(1000002,17366,0.017914012738853),(1000002,17367,0.017914012738853),(1000002,17368,0.017914012738853),(1000002,17482,0.199849958741562),(1000002,17483,0.199849958741562),(1000002,17621,0.199849958741562),(1000002,17982,0.199849958741562),(1000002,18626,0.199849958741562),(1000002,18635,0.199849958741562),(1000002,18637,0.199849958741562),(1000002,19470,0.173793914716357),(1000002,20175,0.199849958741562),(1000002,22543,0.199849958741562),(1000002,22577,0.199849958741562),(1000002,22779,0.166666),(1000002,22783,0.505488198166489),(1000002,24445,0.017914012738853),(1000002,24574,0.199849958741562),(1000002,24575,0.199849958741562),(1000002,24646,0.199849958741562),(1000002,24653,0.199849958741562),(1000002,24654,0.199849958741562),(1000002,24655,0.199849958741562),(1000002,24656,0.199849958741562),(1000002,24657,0.199849958741562),(1000002,24658,0.199849958741562),(1000002,24659,0.199849958741562),(1000002,24660,0.199849958741562),(1000002,27309,0.017914012738853),(1000002,27656,0.28549993876403),(1000002,27658,0.28549993876403),(1000002,27660,0.28549993876403),(1000002,27673,0.199849958741562),(1000002,27674,0.199849958741562),(1000002,27675,0.199849958741562),(1000002,27897,0.199849958741562),(1000002,27915,0.126372049541622),(1000002,28351,0.199849958741562),(1000002,28368,0.199849958741562),(1000002,28386,0.199849958741562),(1000002,28448,0.199849958741562),(1000002,28449,0.199849958741562),(1000002,28450,0.199849958741562),(1000002,28451,0.199849958741562),(1000002,28452,0.199849958741562),(1000002,28453,0.199849958741562),(1000002,28454,0.199849958741562),(1000002,28455,0.199849958741562),(1000002,28456,0.199849958741562),(1000002,28457,0.199849958741562),(1000002,28458,0.199849958741562),(1000002,28459,0.199849958741562),(1000002,28460,0.199849958741562),(1000002,28461,0.199849958741562),(1000002,28462,0.199849958741562),(1000002,28463,0.199849958741562),(1000002,28464,0.199849958741562),(1000002,28465,0.199849958741562),(1000002,28466,0.199849958741562),(1000002,28467,0.199849958741562),(1000002,28468,0.199849958741562),(1000002,28469,0.199849958741562),(1000002,28470,0.199849958741562),(1000002,28471,0.199849958741562),(1000002,28472,0.199849958741562),(1000002,28473,0.199849958741562),(1000002,28474,0.199849958741562),(1000002,28475,0.199849958741562),(1000002,28476,0.199849958741562),(1000002,28477,0.199849958741562),(1000002,28478,0.199849958741562),(1000002,28479,0.199849958741562),(1000002,28480,0.199849958741562),(1000002,28481,0.199849958741562),(1000002,28482,0.199849958741562),(1000002,28483,0.199849958741562),(1000002,28484,0.199849958741562),(1000002,28485,0.199849958741562),(1000002,28486,0.199849958741562),(1000002,28487,0.199849958741562),(1000002,28488,0.199849958741562),(1000002,28489,0.199849958741562),(1000002,28490,0.199849958741562),(1000002,28491,0.199849958741562),(1000002,28492,0.199849958741562),(1000002,28493,0.199849958741562),(1000002,28494,0.199849958741562),(1000002,28495,0.199849958741562),(1000002,28496,0.199849958741562),(1000002,28497,0.199849958741562),(1000002,28498,0.199849958741562),(1000002,28499,0.199849958741562),(1000002,28500,0.199849958741562),(1000002,28501,0.199849958741562),(1000002,28502,0.199849958741562),(1000002,28503,0.199849958741562),(1000002,28504,0.199849958741562),(1000002,28505,0.199849958741562),(1000002,28655,0.505488198166489),(1000003,672,0.00234777173673816),(1000003,967,0.00234777173673816),(1000003,3673,0.225987176566593),(1000003,3693,-0.053082750868942),(1000003,3717,-0.0326544742270115),(1000003,9842,0.218719552075987),(1000003,17366,0.002388535031847),(1000003,17367,0.002388535031847),(1000003,17368,0.002388535031847),(1000003,24445,0.002388535031847),(1000003,27309,0.002388535031847),(1000004,672,0.00679812185742736),(1000004,967,0.00679812185742736),(1000004,3587,0.25),(1000004,3597,0.25),(1000004,3607,0.25),(1000004,3617,0.25),(1000004,3673,-0.563009706718332),(1000004,3685,0.265715797787226),(1000004,9828,0.0318489334777035),(1000004,9848,-0.0342502133455584),(1000004,17366,0.00796178343949),(1000004,17367,0.00796178343949),(1000004,17368,0.00796178343949),(1000004,24445,0.00796178343949),(1000004,27309,0.00796178343949),(1000005,521,0.303343262040024),(1000005,672,0.0608619639092801),(1000005,785,0.195820395078564),(1000005,814,0.23504306710322),(1000005,967,0.0608619639092801),(1000005,1010,0.177793289838402),(1000005,1026,0.218567766682922),(1000005,1032,0.126870375462501),(1000005,1079,0.348391627500376),(1000005,1100,0.2),(1000005,1102,0.23254696216357),(1000005,1109,0.24658370208899),(1000005,1130,0.0948222082757455),(1000005,1131,0.146181862151698),(1000005,1132,0.145841220681184),(1000005,1133,0.133641928903133),(1000005,1134,0.151210740728268),(1000005,1137,0.293813530162176),(1000005,1951,0.959933094328484),(1000005,2047,0.303343262040024),(1000005,3243,0.441168955724848),(1000005,3567,0.246089379851999),(1000005,3643,-0.537980983219912),(1000005,3689,0.295366870632532),(1000005,3691,-0.464582625060139),(1000005,9826,0.267904193015701),(1000005,11562,0.126870375462501),(1000005,11616,0.5),(1000005,12109,0.195820395078564),(1000005,12266,0.166666),(1000005,12270,0.166666),(1000005,17366,0.011942675159235),(1000005,17367,0.011942675159235),(1000005,17368,0.011942675159235),(1000005,18037,0.195820395078564),(1000005,18039,0.195820395078564),(1000005,18041,0.195820395078564),(1000005,18043,0.195820395078564),(1000005,18045,0.195820395078564),(1000005,18047,0.195820395078564),(1000005,18049,0.195820395078564),(1000005,18051,0.195820395078564),(1000005,18053,0.195820395078564),(1000005,18055,0.195820395078564),(1000005,18057,0.195820395078564),(1000005,18059,0.195820395078564),(1000005,18061,0.195820395078564),(1000005,18063,0.195820395078564),(1000005,18065,0.195820395078564),(1000005,18067,0.195820395078564),(1000005,22779,0.166666),(1000005,22783,0.441168955724848),(1000005,24445,0.011942675159235),(1000005,27309,0.011942675159235),(1000005,27915,0.110292238931212),(1000005,28655,0.441168955724848),(1000006,672,0.00327318891462556),(1000006,785,0.0105313254002805),(1000006,967,0.00327318891462556),(1000006,3683,0.0474210090274131),(1000006,3685,-0.10574897810478),(1000006,3717,-0.0455258325927707),(1000006,12109,0.0105313254002805),(1000006,17366,0.002388535031847),(1000006,17367,0.002388535031847),(1000006,17368,0.002388535031847),(1000006,18037,0.0105313254002805),(1000006,18039,0.0105313254002805),(1000006,18041,0.0105313254002805),(1000006,18043,0.0105313254002805),(1000006,18045,0.0105313254002805),(1000006,18047,0.0105313254002805),(1000006,18049,0.0105313254002805),(1000006,18051,0.0105313254002805),(1000006,18053,0.0105313254002805),(1000006,18055,0.0105313254002805),(1000006,18057,0.0105313254002805),(1000006,18059,0.0105313254002805),(1000006,18061,0.0105313254002805),(1000006,18063,0.0105313254002805),(1000006,18065,0.0105313254002805),(1000006,18067,0.0105313254002805),(1000006,24445,0.002388535031847),(1000006,27309,0.002388535031847),(1000007,672,0.0186263248374669),(1000007,785,0.0599292900566145),(1000007,967,0.0186263248374669),(1000007,3695,-0.142312283822291),(1000007,3715,-0.0903608935850442),(1000007,9828,0.0872635991416424),(1000007,12109,0.0599292900566145),(1000007,17366,0.00796178343949),(1000007,17367,0.00796178343949),(1000007,17368,0.00796178343949),(1000007,18037,0.0599292900566145),(1000007,18039,0.0599292900566145),(1000007,18041,0.0599292900566145),(1000007,18043,0.0599292900566145),(1000007,18045,0.0599292900566145),(1000007,18047,0.0599292900566145),(1000007,18049,0.0599292900566145),(1000007,18051,0.0599292900566145),(1000007,18053,0.0599292900566145),(1000007,18055,0.0599292900566145),(1000007,18057,0.0599292900566145),(1000007,18059,0.0599292900566145),(1000007,18061,0.0599292900566145),(1000007,18063,0.0599292900566145),(1000007,18065,0.0599292900566145),(1000007,18067,0.0599292900566145),(1000007,24445,0.00796178343949),(1000007,27309,0.00796178343949),(1000008,672,0.0247884479730163),(1000008,785,0.0797556201554048),(1000008,967,0.0247884479730163),(1000008,1202,0.0518396401163757),(1000008,1218,0.0518396401163757),(1000008,3645,0.11074842942684),(1000008,3773,0.758179416024557),(1000008,3828,-0.193327103376206),(1000008,9848,-0.124888851566185),(1000008,10247,0.0518396401163757),(1000008,12109,0.0797556201554048),(1000008,17366,0.005971337579617),(1000008,17367,0.005971337579617),(1000008,17368,0.005971337579617),(1000008,18037,0.0797556201554048),(1000008,18039,0.0797556201554048),(1000008,18041,0.0797556201554048),(1000008,18043,0.0797556201554048),(1000008,18045,0.0797556201554048),(1000008,18047,0.0797556201554048),(1000008,18049,0.0797556201554048),(1000008,18051,0.0797556201554048),(1000008,18053,0.0797556201554048),(1000008,18055,0.0797556201554048),(1000008,18057,0.0797556201554048),(1000008,18059,0.0797556201554048),(1000008,18061,0.0797556201554048),(1000008,18063,0.0797556201554048),(1000008,18065,0.0797556201554048),(1000008,18067,0.0797556201554048),(1000008,24445,0.005971337579617),(1000008,27309,0.005971337579617),(1000009,672,0.00508199567807482),(1000009,967,0.00508199567807482),(1000009,1130,0.00791768818635463),(1000009,1131,0.0122062375899536),(1000009,1132,0.0121777939057587),(1000009,1133,0.0111591486943744),(1000009,1134,0.0126261507434264),(1000009,1135,0.0325697149789735),(1000009,1136,0.0325494291507561),(1000009,1137,0.0245335344858369),(1000009,3645,0.0227050535924411),(1000009,3673,-0.420882849154974),(1000009,3715,0.0229587625785188),(1000009,3725,-0.0334441181743506),(1000009,17366,0.00796178343949),(1000009,17367,0.00796178343949),(1000009,17368,0.00796178343949),(1000009,24445,0.00796178343949),(1000009,27309,0.00796178343949),(1000010,421,0.596628123399254),(1000010,672,0.13863377426222),(1000010,812,0.506512488441038),(1000010,813,0.499666308455915),(1000010,967,0.13863377426222),(1000010,1032,0.288990329307294),(1000010,1075,0.889423455423028),(1000010,1112,0.523519767078912),(1000010,1130,0.215989754072666),(1000010,1131,0.332978792944921),(1000010,1132,0.33220286641061),(1000010,1134,0.344433770283731),(1000010,1186,0.746944110683188),(1000010,1202,0.289922345019402),(1000010,1218,0.289922345019402),(1000010,2294,0.9160978831502),(1000010,3556,0.746552955238363),(1000010,3587,0.25),(1000010,3597,0.25),(1000010,3607,0.25),(1000010,3617,0.25),(1000010,3687,-0.399839086966724),(1000010,3697,-0.755755458361291),(1000010,3715,0.626301183683025),(1000010,3828,0.392370749870711),(1000010,10247,0.289922345019402),(1000010,11562,0.288990329307294),(1000010,11614,0.665328300876423),(1000010,11620,1),(1000010,11798,1),(1000010,11803,1),(1000010,11859,0.0832511989198493),(1000010,11860,0.0832511989198493),(1000010,11870,0.0832511989198493),(1000010,11872,0.0832511989198493),(1000010,11873,0.0832511989198493),(1000010,11881,1),(1000010,11887,0.0832511989198493),(1000010,11889,0.0832511989198493),(1000010,11890,0.0832511989198493),(1000010,11891,0.0832511989198493),(1000010,12092,0.125),(1000010,12275,0.188100674416827),(1000010,12345,0.0903153377755342),(1000010,12355,0.0903153377755342),(1000010,13321,0.201061375951537),(1000010,17327,0.333333),(1000010,17328,0.333333),(1000010,17332,0.333333),(1000010,17340,0.333333),(1000010,17351,0.333333),(1000010,17352,0.333333),(1000010,17353,0.333333),(1000010,17354,0.333333),(1000010,17356,0.333333),(1000010,17366,0.01811305732484),(1000010,17367,0.01811305732484),(1000010,17368,0.01811305732484),(1000010,21944,0.333333),(1000010,24445,0.01811305732484),(1000010,25907,0.333333),(1000010,25929,0.0832511989198493),(1000010,25931,0.0832511989198493),(1000010,25933,0.0832511989198493),(1000010,25935,0.0832511989198493),(1000010,25937,0.0832511989198493),(1000010,25949,0.0832511989198493),(1000010,25951,0.0832511989198493),(1000010,25953,0.0832511989198493),(1000010,25955,0.0832511989198493),(1000010,25957,0.0832511989198493),(1000010,26017,0.333333),(1000010,26021,0.333333),(1000010,26023,0.333333),(1000010,26027,0.333333),(1000010,26029,0.333333),(1000010,26031,0.333333),(1000010,26077,0.333333),(1000010,26079,0.333333),(1000010,26081,0.333333),(1000010,26083,0.333333),(1000010,26085,0.333333),(1000010,26087,0.333333),(1000010,26089,0.333333),(1000010,26091,0.333333),(1000010,26107,0.333333),(1000010,26109,0.333333),(1000010,26111,0.333333),(1000010,26113,0.333333),(1000010,27309,0.01811305732484),(1000010,27937,0.333333),(1000010,27957,0.333333),(1000010,27959,0.333333),(1000010,27993,0.333333),(1000010,27995,0.333333),(1000010,27997,0.333333),(1000010,27999,0.333333),(1000010,28001,0.333333),(1000010,28003,0.333333),(1000010,28023,0.333333),(1000010,28025,0.333333),(1000010,28027,0.333333),(1000010,28047,0.333333),(1000010,28049,0.333333),(1000010,28051,0.333333),(1000010,28091,0.333333),(1000010,28092,0.333333),(1000010,28093,0.333333),(1000010,28094,0.333333),(1000010,28095,0.333333),(1000010,28096,0.333333),(1000010,28097,0.333333),(1000010,28098,0.333333),(1000010,28099,0.333333),(1000010,28100,0.333333),(1000010,28101,0.333333),(1000010,28102,0.333333),(1000010,28103,0.333333),(1000010,28104,0.333333),(1000010,28105,0.333333),(1000010,28668,0.0305104110903435),(1000010,29000,0.0426940756421886),(1000010,29002,0.0426940756421886),(1000010,29004,0.0426940756421886),(1000010,29006,0.0426940756421886),(1000010,29008,0.0426940756421886),(1000010,29010,0.0426940756421886),(1000010,29012,0.0426940756421886),(1000010,29014,0.0426940756421886),(1000010,29016,0.0426940756421886),(1000011,672,0.089234952299702),(1000011,967,0.089234952299702),(1000011,1129,0.541862491170021),(1000011,1983,1),(1000011,2290,0.541862491170021),(1000011,2292,0.541862491170021),(1000011,2296,0.541862491170021),(1000011,3645,0.398678885742616),(1000011,3725,-0.587246522634653),(1000011,9826,-0.508545489951845),(1000011,9850,0.652767719101624),(1000011,11634,0.333333333333),(1000011,11820,0.333333),(1000011,11824,0.333333),(1000011,11828,0.333333),(1000011,11832,0.333333),(1000011,11836,0.333333),(1000011,17366,0.011942675159235),(1000011,17367,0.011942675159235),(1000011,17368,0.011942675159235),(1000011,24445,0.011942675159235),(1000011,27309,0.011942675159235),(1000012,509,1),(1000012,672,0.00265114373932117),(1000012,967,0.00265114373932117),(1000012,3687,0.0325260020270893),(1000012,3697,0.00893415727473404),(1000012,9830,-0.0665991256973966),(1000012,9840,-0.931652831166936),(1000012,17366,0.000597133757961),(1000012,17367,0.000597133757961),(1000012,17368,0.000597133757961),(1000012,17941,0.25),(1000012,17942,0.25),(1000012,17943,0.25),(1000012,17944,0.25),(1000012,17945,0.25),(1000012,17946,0.25),(1000012,17947,0.25),(1000012,17948,0.25),(1000012,17949,0.25),(1000012,17950,0.25),(1000012,17951,0.25),(1000012,17952,0.25),(1000012,17953,0.25),(1000012,17954,0.25),(1000012,17955,0.25),(1000012,17956,0.25),(1000012,17957,0.25),(1000012,17958,0.25),(1000012,17961,0.25),(1000012,17962,0.25),(1000012,17963,0.25),(1000012,17964,0.25),(1000012,17965,0.25),(1000012,17966,0.25),(1000012,17967,0.25),(1000012,17968,0.25),(1000012,17969,0.25),(1000012,17970,0.25),(1000012,17971,0.25),(1000012,17972,0.25),(1000012,24445,0.000597133757961),(1000012,27309,0.000597133757961),(1000013,421,0.0349677814555005),(1000013,672,0.00812518775201699),(1000013,967,0.00812518775201699),(1000013,1026,0.0291792118881494),(1000013,1215,0.0614288861326025),(1000013,3687,-0.0234341715753535),(1000013,3689,0.039432038098414),(1000013,3691,-0.0620226626364741),(1000013,9832,0.225388088428135),(1000013,17366,0.005971337579617),(1000013,17367,0.005971337579617),(1000013,17368,0.005971337579617),(1000013,24445,0.005971337579617),(1000013,27309,0.005971337579617),(1000014,672,0.0294352345611814),(1000014,967,0.0294352345611814),(1000014,1178,0.296764812529579),(1000014,1179,0.296764812529579),(1000014,3647,0.144851417975813),(1000014,3697,0.099194551803373),(1000014,9828,-0.250226616611908),(1000014,9846,-0.415853922445285),(1000014,11629,0.166666),(1000014,11630,0.338344982897214),(1000014,17366,0.00796178343949),(1000014,17367,0.00796178343949),(1000014,17368,0.00796178343949),(1000014,24445,0.00796178343949),(1000014,25562,0.166666),(1000014,27309,0.00796178343949),(1000015,672,0.00533799690222999),(1000015,786,0.0148887978590208),(1000015,811,0.0348984866029912),(1000015,812,0.0195029105182191),(1000015,813,0.0192393031271113),(1000015,814,0.0206148320477762),(1000015,967,0.00533799690222999),(1000015,1010,0.0155936478127674),(1000015,1026,0.0191698391990743),(1000015,1032,0.011127371312123),(1000015,1112,0.020157763934477),(1000015,1113,0.0684348083336349),(1000015,1114,0.0684348083336349),(1000015,1115,0.332338163528737),(1000015,1116,0.0201492696449608),(1000015,1117,0.964845638313105),(1000015,1118,0.964845638313105),(1000015,1119,0.964845638313105),(1000015,1120,0.964845638313105),(1000015,1121,0.0389916185403871),(1000015,1122,0.964845638313105),(1000015,1123,0.964845638313105),(1000015,1125,0.964845638313105),(1000015,1126,0.964845638313105),(1000015,1558,0.845897668025611),(1000015,1809,0.0848641948490502),(1000015,2294,0.0352737108141177),(1000015,2530,0.0848641948490502),(1000015,2538,0.0848641948490502),(1000015,2546,0.0848641948490502),(1000015,3689,0.0259056287241729),(1000015,3691,-0.0407469699317863),(1000015,3897,0.0848641948490502),(1000015,3907,0.0848641948490502),(1000015,9826,-0.030420974966051),(1000015,9832,0.148072998993809),(1000015,11562,0.011127371312123),(1000015,17366,0.00796178343949),(1000015,17367,0.00796178343949),(1000015,17368,0.00796178343949),(1000015,24445,0.00796178343949),(1000015,27309,0.00796178343949),(1000016,43,0.114440981963478),(1000016,672,0.0230927196484042),(1000016,967,0.0230927196484042),(1000016,3771,-0.386237866009961),(1000016,3773,-0.549265800744521),(1000016,17366,0.003980891719745),(1000016,17367,0.003980891719745),(1000016,17368,0.003980891719745),(1000016,22634,0.250062515628907),(1000016,24445,0.003980891719745),(1000016,24684,0.250062515628907),(1000016,25270,0.250062515628907),(1000016,25271,0.250062515628907),(1000016,25280,0.250062515628907),(1000016,25305,0.250062515628907),(1000016,25821,0.250062515628907),(1000016,27309,0.003980891719745),(1000017,672,0.091822327547928),(1000017,967,0.091822327547928),(1000017,3647,0.451859635074814),(1000017,3812,-0.509655571546804),(1000017,9828,0.430183992457671),(1000017,9850,-0.541615418205288),(1000017,17366,0.011942675159235),(1000017,17367,0.011942675159235),(1000017,17368,0.011942675159235),(1000017,24445,0.011942675159235),(1000017,27309,0.011942675159235),(1000018,672,0.00384080031392405),(1000018,967,0.00384080031392405),(1000018,3647,0.0189006603795693),(1000018,3683,0.0556443978974918),(1000018,3697,-0.020937941112629),(1000018,9836,-0.379210196711232),(1000018,17366,0.003980891719745),(1000018,17367,0.003980891719745),(1000018,17368,0.003980891719745),(1000018,24445,0.003980891719745),(1000018,27309,0.003980891719745),(1000019,672,0.0754469619383931),(1000019,967,0.0754469619383931),(1000019,1010,0.220399781895541),(1000019,1032,0.157273669362639),(1000019,1129,0.458137508829979),(1000019,2290,0.458137508829979),(1000019,2292,0.458137508829979),(1000019,2296,0.458137508829979),(1000019,3587,0.25),(1000019,3597,0.25),(1000019,3607,0.25),(1000019,3617,0.25),(1000019,3687,-0.21759953183415),(1000019,3695,0.264441489480707),(1000019,3697,0.254250651845483),(1000019,3715,-0.36601181169764),(1000019,11562,0.157273669362639),(1000019,11855,-0.944569850879558),(1000019,11859,0.0833211481347803),(1000019,11860,0.0833211481347803),(1000019,11870,0.0833211481347803),(1000019,11872,0.0833211481347803),(1000019,11873,0.0833211481347803),(1000019,11885,1),(1000019,11887,0.0833211481347803),(1000019,11889,0.0833211481347803),(1000019,11890,0.0833211481347803),(1000019,11891,0.0833211481347803),(1000019,12095,0.124969308325265),(1000019,12275,0.181034460539696),(1000019,12345,0.0773910353611259),(1000019,12355,0.0773910353611259),(1000019,12836,1),(1000019,13000,0.5),(1000019,13321,0.155002428591205),(1000019,16591,0.124979922311364),(1000019,17136,-1),(1000019,17327,0.333333),(1000019,17328,0.333333),(1000019,17332,0.333333),(1000019,17340,0.333333),(1000019,17351,0.333333),(1000019,17352,0.333333),(1000019,17353,0.333333),(1000019,17354,0.333333),(1000019,17356,0.333333),(1000019,17366,0.012141719745222),(1000019,17367,0.012141719745222),(1000019,17368,0.012141719745222),(1000019,19719,0.124979922311364),(1000019,21944,0.333333),(1000019,21951,0.170785495876243),(1000019,21953,0.345405969695159),(1000019,21961,0.0922224928507705),(1000019,21965,0.204304952977159),(1000019,21967,0.204304952977159),(1000019,24445,0.012141719745222),(1000019,25907,0.333333),(1000019,25929,0.0833211481347803),(1000019,25931,0.0833211481347803),(1000019,25933,0.0833211481347803),(1000019,25935,0.0833211481347803),(1000019,25937,0.0833211481347803),(1000019,25949,0.0833211481347803),(1000019,25951,0.0833211481347803),(1000019,25953,0.0833211481347803),(1000019,25955,0.0833211481347803),(1000019,25957,0.0833211481347803),(1000019,26017,0.333333),(1000019,26021,0.333333),(1000019,26023,0.333333),(1000019,26027,0.333333),(1000019,26029,0.333333),(1000019,26031,0.333333),(1000019,26077,0.333333),(1000019,26079,0.333333),(1000019,26081,0.333333),(1000019,26083,0.333333),(1000019,26085,0.333333),(1000019,26087,0.333333),(1000019,26089,0.333333),(1000019,26091,0.333333),(1000019,26107,0.333333),(1000019,26109,0.333333),(1000019,26111,0.333333),(1000019,26113,0.333333),(1000019,27309,0.012141719745222),(1000019,27937,0.333333),(1000019,27957,0.333333),(1000019,27959,0.333333),(1000019,27993,0.333333),(1000019,27995,0.333333),(1000019,27997,0.333333),(1000019,27999,0.333333),(1000019,28001,0.333333),(1000019,28003,0.333333),(1000019,28023,0.333333),(1000019,28025,0.333333),(1000019,28027,0.333333),(1000019,28047,0.333333),(1000019,28049,0.333333),(1000019,28051,0.333333),(1000019,28091,0.333333),(1000019,28092,0.333333),(1000019,28093,0.333333),(1000019,28094,0.333333),(1000019,28095,0.333333),(1000019,28096,0.333333),(1000019,28097,0.333333),(1000019,28098,0.333333),(1000019,28099,0.333333),(1000019,28100,0.333333),(1000019,28101,0.333333),(1000019,28102,0.333333),(1000019,28103,0.333333),(1000019,28104,0.333333),(1000019,28105,0.333333),(1000020,672,0.0582862652435249),(1000020,684,0.998334366321338),(1000020,685,0.998334366321338),(1000020,811,0.381061001719537),(1000020,814,0.225095965901636),(1000020,967,0.0582862652435249),(1000020,1105,0.261261045223526),(1000020,1116,0.220012430973661),(1000020,1130,0.0908093007116083),(1000020,1131,0.139995396860125),(1000020,1132,0.139669171450559),(1000020,1133,0.127986157780173),(1000020,1134,0.144811451613605),(1000020,1135,0.373547552265846),(1000020,1136,0.373314890681881),(1000020,1137,0.28137924331025),(1000020,1798,0.78601410535943),(1000020,2515,0.620950883986315),(1000020,3687,-0.168105695756293),(1000020,9836,0.462709739982156),(1000020,9838,-0.699050345017861),(1000020,9848,0.731736596257164),(1000020,11622,0.5),(1000020,11626,0.5),(1000020,11859,0.0833211481347803),(1000020,11860,0.0833211481347803),(1000020,11870,0.0833211481347803),(1000020,11872,0.0833211481347803),(1000020,11873,0.0833211481347803),(1000020,11886,1),(1000020,11887,0.0833211481347803),(1000020,11889,0.0833211481347803),(1000020,11890,0.0833211481347803),(1000020,11891,0.0833211481347803),(1000020,12092,0.125),(1000020,12095,0.125031792979427),(1000020,12096,0.250062515628907),(1000020,12275,0.19554838124446),(1000020,12345,0.105397999184),(1000020,12355,0.105397999184),(1000020,13321,0.164527792825602),(1000020,16591,0.124979922311364),(1000020,17327,0.333333),(1000020,17328,0.333333),(1000020,17332,0.333333),(1000020,17340,0.333333),(1000020,17351,0.333333),(1000020,17352,0.333333),(1000020,17353,0.333333),(1000020,17354,0.333333),(1000020,17356,0.333333),(1000020,17366,0.00796178343949),(1000020,17367,0.00796178343949),(1000020,17368,0.00796178343949),(1000020,19719,0.124854942389053),(1000020,21944,0.333333),(1000020,21951,0.170614710380366),(1000020,21953,0.345060563725464),(1000020,21961,0.0921302703579198),(1000020,21965,0.204100648024181),(1000020,21967,0.204100648024181),(1000020,24445,0.00796178343949),(1000020,25907,0.333333),(1000020,25929,0.0833211481347803),(1000020,25931,0.0833211481347803),(1000020,25933,0.0833211481347803),(1000020,25935,0.0833211481347803),(1000020,25937,0.0833211481347803),(1000020,25949,0.0833211481347803),(1000020,25951,0.0833211481347803),(1000020,25953,0.0833211481347803),(1000020,25955,0.0833211481347803),(1000020,25957,0.0833211481347803),(1000020,26017,0.333333),(1000020,26021,0.333333),(1000020,26023,0.333333),(1000020,26027,0.333333),(1000020,26029,0.333333),(1000020,26031,0.333333),(1000020,26077,0.333333),(1000020,26079,0.333333),(1000020,26081,0.333333),(1000020,26083,0.333333),(1000020,26085,0.333333),(1000020,26087,0.333333),(1000020,26089,0.333333),(1000020,26091,0.333333),(1000020,26107,0.333333),(1000020,26109,0.333333),(1000020,26111,0.333333),(1000020,26113,0.333333),(1000020,27309,0.00796178343949),(1000020,27937,0.333333),(1000020,27957,0.333333),(1000020,27959,0.333333),(1000020,27993,0.333333),(1000020,27995,0.333333),(1000020,27997,0.333333),(1000020,27999,0.333333),(1000020,28001,0.333333),(1000020,28003,0.333333),(1000020,28023,0.333333),(1000020,28025,0.333333),(1000020,28027,0.333333),(1000020,28047,0.333333),(1000020,28049,0.333333),(1000020,28051,0.333333),(1000020,28091,0.333333),(1000020,28092,0.333333),(1000020,28093,0.333333),(1000020,28094,0.333333),(1000020,28095,0.333333),(1000020,28096,0.333333),(1000020,28097,0.333333),(1000020,28098,0.333333),(1000020,28099,0.333333),(1000020,28100,0.333333),(1000020,28101,0.333333),(1000020,28102,0.333333),(1000020,28103,0.333333),(1000020,28104,0.333333),(1000020,28105,0.333333),(1000021,672,0.000354914992457571),(1000021,967,0.000354914992457571),(1000021,1800,1),(1000021,3587,0.25),(1000021,3597,0.25),(1000021,3607,0.25),(1000021,3617,0.25),(1000021,3775,-0.548850389585735),(1000021,9830,0.0201138115855159),(1000021,17366,0.000199044585987),(1000021,17367,0.000199044585987),(1000021,17368,0.000199044585987),(1000021,24445,0.000199044585987),(1000021,27309,0.000199044585987),(1000022,672,0.0340302027778932),(1000022,967,0.0340302027778932),(1000022,1802,0.681993131992215),(1000022,3645,0.152038220175426),(1000022,3699,-0.136218620470571),(1000022,9830,-0.854869435669724),(1000022,9834,0.926127974689365),(1000022,17366,0.003980891719745),(1000022,17367,0.003980891719745),(1000022,17368,0.003980891719745),(1000022,24445,0.003980891719745),(1000022,27309,0.003980891719745),(1000023,43,0.0786371070240444),(1000023,223,0.0567074239577689),(1000023,224,0.0798209855395176),(1000023,225,0.203298878004524),(1000023,231,0.141659429076474),(1000023,232,0.203298878004524),(1000023,233,0.203298878004524),(1000023,234,0.203298878004524),(1000023,405,1),(1000023,421,0.0682897793406841),(1000023,518,0.176349938673491),(1000023,672,0.0158679577482771),(1000023,785,0.0510543787247687),(1000023,786,0.0442590768928478),(1000023,967,0.0158679577482771),(1000023,1026,0.0569850833605957),(1000023,1032,0.0330776995686144),(1000023,1102,0.0606297452971128),(1000023,1105,0.0711261771457928),(1000023,1130,0.0247220874561433),(1000023,1131,0.0381125987923291),(1000023,1132,0.0380237865997178),(1000023,1133,0.0348431819320542),(1000023,1134,0.0394237302059189),(1000023,1135,0.101695257906154),(1000023,1136,0.101631917697812),(1000023,1137,0.0766031915998468),(1000023,1138,0.0567074239577689),(1000023,1139,0.0798209855395176),(1000023,1140,0.203298878004524),(1000023,1141,0.0645408732133399),(1000023,1142,0.203298878004524),(1000023,1143,0.203298878004524),(1000023,1144,0.203298878004524),(1000023,1145,0.203298878004524),(1000023,1146,0.141659429076474),(1000023,1147,0.203298878004524),(1000023,1148,0.203298878004524),(1000023,1149,0.203298878004524),(1000023,1150,0.203298878004524),(1000023,1151,0.203298878004524),(1000023,1152,0.203298878004524),(1000023,1153,0.203298878004524),(1000023,1202,0.0331843776563977),(1000023,1218,0.0331843776563977),(1000023,1220,0.170007457830181),(1000023,1221,0.170007457830181),(1000023,1798,0.21398589464057),(1000023,1802,0.318006868007785),(1000023,2507,0.170007457830181),(1000023,2509,0.170007457830181),(1000023,2511,0.11309670953032),(1000023,2513,0.170007457830181),(1000023,2515,0.169048786188008),(1000023,2517,0.11309670953032),(1000023,3687,0.194678703470971),(1000023,3695,-0.121237298632876),(1000023,3697,-0.0865034205779022),(1000023,10247,0.0331843776563977),(1000023,10630,0.224687439159029),(1000023,11562,0.0330776995686144),(1000023,12109,0.0510543787247687),(1000023,17366,0.017914012738853),(1000023,17367,0.017914012738853),(1000023,17368,0.017914012738853),(1000023,17858,0.170007457830181),(1000023,17860,0.170007457830181),(1000023,17862,0.170007457830181),(1000023,17864,0.170007457830181),(1000023,18037,0.0510543787247687),(1000023,18039,0.0510543787247687),(1000023,18041,0.0510543787247687),(1000023,18043,0.0510543787247687),(1000023,18045,0.0510543787247687),(1000023,18047,0.0510543787247687),(1000023,18049,0.0510543787247687),(1000023,18051,0.0510543787247687),(1000023,18053,0.0510543787247687),(1000023,18055,0.0510543787247687),(1000023,18057,0.0510543787247687),(1000023,18059,0.0510543787247687),(1000023,18061,0.0510543787247687),(1000023,18063,0.0510543787247687),(1000023,18065,0.0510543787247687),(1000023,18067,0.0510543787247687),(1000023,24445,0.017914012738853),(1000023,27309,0.017914012738853),(1000024,45,-0.317572273932517),(1000024,672,0.00289126357197782),(1000024,967,0.00289126357197782),(1000024,3645,0.0129174242777982),(1000024,3693,0.0797955074135455),(1000024,9842,-0.0667581668533506),(1000024,12238,0.130378030544904),(1000024,12239,0.130378030544904),(1000024,14343,0.130378030544904),(1000024,17366,0.002388535031847),(1000024,17367,0.002388535031847),(1000024,17368,0.002388535031847),(1000024,19470,0.130378030544904),(1000024,24445,0.002388535031847),(1000024,27309,0.002388535031847),(1000025,223,0.43149628394291),(1000025,224,0.607371244135733),(1000025,672,0.120741947425503),(1000025,786,0.336774726784092),(1000025,967,0.120741947425503),(1000025,1010,0.35271796497192),(1000025,1112,0.455955242719521),(1000025,1116,0.455763107527808),(1000025,1121,0.881964535024726),(1000025,1130,0.18811450290145),(1000025,1133,0.265127605437072),(1000025,1138,0.43149628394291),(1000025,1139,0.607371244135733),(1000025,1141,0.491102310955378),(1000025,1876,0.860251156871001),(1000025,3689,-0.586651068635294),(1000025,3697,0.406891385011561),(1000025,3828,0.341732082995777),(1000025,3830,0.998391790877234),(1000025,9848,-0.608320584098309),(1000025,11855,1),(1000025,16213,0.5),(1000025,16696,1),(1000025,16697,1),(1000025,17174,1),(1000025,17175,1),(1000025,17176,1),(1000025,17177,1),(1000025,17184,1),(1000025,17185,1),(1000025,17186,1),(1000025,17187,1),(1000025,17366,0.011942675159235),(1000025,17367,0.011942675159235),(1000025,17368,0.011942675159235),(1000025,17773,1),(1000025,20061,0.5),(1000025,20062,0.5),(1000025,24445,0.011942675159235),(1000025,27309,0.011942675159235),(1000025,28668,0.0320359316448607),(1000026,672,0.0287708692284911),(1000026,967,0.0287708692284911),(1000026,3693,0.794042484077554),(1000026,3697,0.0969556900313382),(1000026,3828,-0.22438632768032),(1000026,9848,-0.144953037012181),(1000026,17366,0.00796178343949),(1000026,17367,0.00796178343949),(1000026,17368,0.00796178343949),(1000026,21951,0.153048387168023),(1000026,21953,0.309533466579377),(1000026,21961,0.0826446280991736),(1000026,21965,0.183086645520831),(1000026,21967,0.183086645520831),(1000026,24445,0.00796178343949),(1000026,27309,0.00796178343949),(1000027,672,0.00713691872928511),(1000027,967,0.00713691872928511),(1000027,3697,-0.0389065746369717),(1000027,3828,0.0201993934629467),(1000027,9826,0.0314155234234272),(1000027,9828,-0.060670385450854),(1000027,17366,0.005971337579617),(1000027,17367,0.005971337579617),(1000027,17368,0.005971337579617),(1000027,24445,0.005971337579617),(1000027,27309,0.005971337579617),(1000028,43,0.147064077652287),(1000028,672,0.0296756411672456),(1000028,967,0.0296756411672456),(1000028,3717,-0.41274986171023),(1000028,3814,-0.860827689310063),(1000028,9828,0.139029211488932),(1000028,9836,0.235582227664267),(1000028,17366,0.003980891719745),(1000028,17367,0.003980891719745),(1000028,17368,0.003980891719745),(1000028,24445,0.003980891719745),(1000028,27309,0.003980891719745),(1000029,672,0.0113002618796731),(1000029,967,0.0113002618796731),(1000029,3777,-0.518894854256349),(1000029,3812,0.0756407882536101),(1000029,9836,0.0897079477339593),(1000029,9852,-0.0637428868252354),(1000029,17366,0.003980891719745),(1000029,17367,0.003980891719745),(1000029,17368,0.003980891719745),(1000029,24445,0.003980891719745),(1000029,27309,0.003980891719745),(1000030,672,0.0278935663536632),(1000030,967,0.0278935663536632),(1000030,3647,-0.268709890555576),(1000030,3812,-0.154821946710451),(1000030,9826,0.122782817121164),(1000030,9852,0.226552006599799),(1000030,17366,0.005971337579617),(1000030,17367,0.005971337579617),(1000030,17368,0.005971337579617),(1000030,24445,0.005971337579617),(1000030,27309,0.005971337579617),(1000031,672,9.72455418426332e-005),(1000031,967,9.72455418426332e-005),(1000031,3777,-0.00446540193482423),(1000031,3814,0.00343467000427627),(1000031,9852,-0.000548545833179662),(1000031,17366,0.003980891719745),(1000031,17367,0.003980891719745),(1000031,17368,0.003980891719745),(1000031,24445,0.003980891719745),(1000031,27309,0.003980891719745),(1000032,42,-0.000432415711727795),(1000032,672,2.62573489318786e-005),(1000032,967,2.62573489318786e-005),(1000032,3777,-0.00120570685814579),(1000032,3814,0.000927398079740053),(1000032,9852,0.000213262621677166),(1000032,17366,0.003980891719745),(1000032,17367,0.003980891719745),(1000032,17368,0.003980891719745),(1000032,24445,0.003980891719745),(1000032,27309,0.003980891719745),(1000033,672,9.72455418426332e-005),(1000033,967,9.72455418426332e-005),(1000033,3645,0.00043446814578941),(1000033,3683,0.00140886512751823),(1000033,3812,-0.000539756871032445),(1000033,9852,-0.000548545833179662),(1000033,17366,0.017914012738853),(1000033,17367,0.017914012738853),(1000033,17368,0.017914012738853),(1000033,24445,0.017914012738853),(1000033,27309,0.017914012738853),(1000034,672,9.72455418426332e-005),(1000034,967,9.72455418426332e-005),(1000034,3643,0.000667765843346727),(1000034,3647,-0.000936805232225887),(1000034,3814,-0.00282088783215561),(1000034,9834,0.00264652600814927),(1000034,17366,0.001990445859872),(1000034,17367,0.001990445859872),(1000034,17368,0.001990445859872),(1000034,24445,0.001990445859872),(1000034,27309,0.001990445859872),(1000035,44,0.000997005990014979),(1000035,223,0.000347527026272295),(1000035,224,0.000489176686271816),(1000035,225,0.00124590132272667),(1000035,231,0.000868148765971825),(1000035,232,0.00124590132272667),(1000035,233,0.00124590132272667),(1000035,234,0.00124590132272667),(1000035,672,9.72455418426332e-005),(1000035,683,0.5),(1000035,684,0.00166563367866198),(1000035,685,0.00166563367866198),(1000035,686,1),(1000035,687,1),(1000035,688,1),(1000035,786,0.000271238301877068),(1000035,790,0.25),(1000035,803,0.333333333333333),(1000035,804,0.333333333333333),(1000035,805,0.333333333333333),(1000035,806,0.333333333333333),(1000035,807,0.5),(1000035,808,0.5),(1000035,809,0.5),(1000035,810,0.5),(1000035,811,0.00063576699300406),(1000035,812,0.000355296403424345),(1000035,813,0.000350494106972787),(1000035,814,0.000375552955387329),(1000035,949,1),(1000035,950,1),(1000035,952,1),(1000035,967,9.72455418426332e-005),(1000035,968,1),(1000035,977,1),(1000035,983,1),(1000035,984,1),(1000035,994,1),(1000035,1112,0.000367226267090037),(1000035,1116,0.000367071521442617),(1000035,1117,0.0175771808434475),(1000035,1118,0.0175771808434475),(1000035,1119,0.0175771808434475),(1000035,1120,0.0175771808434475),(1000035,1121,0.000710334071324988),(1000035,1122,0.0175771808434475),(1000035,1123,0.0175771808434475),(1000035,1124,0.5),(1000035,1125,0.0175771808434475),(1000035,1126,0.0175771808434475),(1000035,1130,0.000151507385404694),(1000035,1131,0.000233570090076233),(1000035,1132,0.000233025811478461),(1000035,1133,0.000213533723763032),(1000035,1134,0.000241605256716078),(1000035,1135,0.000623231458943357),(1000035,1136,0.000622843283415141),(1000035,1138,0.000347527026272295),(1000035,1139,0.000489176686271816),(1000035,1140,0.00124590132272667),(1000035,1141,0.00039553370926447),(1000035,1142,0.00124590132272667),(1000035,1143,0.00124590132272667),(1000035,1144,0.00124590132272667),(1000035,1145,0.00124590132272667),(1000035,1146,0.000868148765971825),(1000035,1147,0.00124590132272667),(1000035,1148,0.00124590132272667),(1000035,1149,0.00124590132272667),(1000035,1150,0.00124590132272667),(1000035,1151,0.00124590132272667),(1000035,1152,0.00124590132272667),(1000035,1153,0.00124590132272667),(1000035,1210,1),(1000035,1214,0.25),(1000035,1215,0.000735205819123558),(1000035,1216,0.00124126207272337),(1000035,1220,0.00104187744990559),(1000035,1221,0.00104187744990559),(1000035,1247,1),(1000035,1255,1),(1000035,1354,1),(1000035,1446,1),(1000035,1540,1),(1000035,1811,0.004679400908036),(1000035,1815,0.000776029975055001),(1000035,1817,0.00124126207272337),(1000035,1819,0.0769230769230769),(1000035,1821,0.0769230769230769),(1000035,1823,0.0769230769230769),(1000035,1825,0.0769230769230769),(1000035,1827,0.0769230769230769),(1000035,1829,0.0769230769230769),(1000035,1831,0.0769230769230769),(1000035,1833,0.0769230769230769),(1000035,1876,0.000692846120626696),(1000035,2019,0.00205347926444682),(1000035,2194,0.25),(1000035,2332,1),(1000035,2445,0.25),(1000035,2477,0.25),(1000035,2507,0.00104187744990559),(1000035,2509,0.00104187744990559),(1000035,2511,0.000693104366255889),(1000035,2513,0.00104187744990559),(1000035,2515,0.00103600230549374),(1000035,2517,0.000693104366255889),(1000035,3293,0.000604281162378804),(1000035,3296,0.25),(1000035,3297,0.000604281162378804),(1000035,3465,0.25),(1000035,3466,0.25),(1000035,3467,0.25),(1000035,3529,0.00164836942295552),(1000035,3539,0.25),(1000035,3687,0.00119307325520901),(1000035,3765,1),(1000035,3830,0.000804104561382833),(1000035,3840,0.5),(1000035,3978,0.25),(1000035,3982,0.25),(1000035,3988,0.25),(1000035,3994,0.25),(1000035,9840,-0.0341735844165319),(1000035,9846,0.00351370086554458),(1000035,9852,-0.000548545833179662),(1000035,9945,0.25),(1000035,10679,1),(1000035,10837,0.25),(1000035,10839,0.25),(1000035,10841,0.25),(1000035,11488,0.25),(1000035,11489,0.25),(1000035,11613,0.25),(1000035,12274,1),(1000035,12275,0.218527868570894),(1000035,12345,0.154473223437126),(1000035,12355,0.154473223437126),(1000035,13320,1),(1000035,13321,0.24911699238077),(1000035,15587,-0.090909090909),(1000035,15588,-0.090909090909),(1000035,15589,-0.090909090909),(1000035,15590,-0.090909090909),(1000035,15591,-0.090909090909),(1000035,15592,-0.090909090909),(1000035,15593,-0.090909090909),(1000035,15594,-0.090909090909),(1000035,15625,-0.090909090909),(1000035,15626,-0.090909090909),(1000035,15627,-0.090909090909),(1000035,15628,-0.090909090909),(1000035,15629,-0.090909090909),(1000035,15630,-0.090909090909),(1000035,15631,-0.090909090909),(1000035,15632,-0.090909090909),(1000035,15646,-0.090909090909),(1000035,15647,-0.090909090909),(1000035,15648,-0.090909090909),(1000035,15649,-0.090909090909),(1000035,15650,-0.090909090909),(1000035,15660,-0.090909090909),(1000035,15661,-0.090909090909),(1000035,15662,-0.090909090909),(1000035,15663,-0.090909090909),(1000035,15664,-0.090909090909),(1000035,15666,-0.090909090909),(1000035,15673,-0.090909090909),(1000035,15674,-0.2),(1000035,15994,-0.090909090909),(1000035,15997,-0.090909090909),(1000035,15998,-0.090909090909),(1000035,16002,-0.090909090909),(1000035,16228,1),(1000035,16239,1),(1000035,17363,0.25),(1000035,17364,0.25),(1000035,17365,0.25),(1000035,17366,0.011942675159235),(1000035,17367,0.011942675159235),(1000035,17368,0.011942675159235),(1000035,17858,0.00104187744990559),(1000035,17860,0.00104187744990559),(1000035,17862,0.00104187744990559),(1000035,17864,0.00104187744990559),(1000035,19727,1),(1000035,20186,1),(1000035,20281,0.25),(1000035,20449,1),(1000035,20540,1),(1000035,20704,0.5),(1000035,21014,0.5),(1000035,21024,1),(1000035,21026,0.25),(1000035,21028,0.25),(1000035,21036,1),(1000035,21040,0.25),(1000035,21042,0.5),(1000035,21604,0.25),(1000035,21868,0.5),(1000035,22302,0.25),(1000035,22303,0.5),(1000035,22304,0.5),(1000035,22305,0.5),(1000035,22306,0.5),(1000035,22307,0.5),(1000035,22308,0.5),(1000035,23736,0.25),(1000035,23916,1),(1000035,23918,1),(1000035,23954,0.25),(1000035,24349,0.25),(1000035,24445,0.011942675159235),(1000035,24546,0.25),(1000035,24548,0.25),(1000035,24553,1),(1000035,24557,0.25),(1000035,24559,0.25),(1000035,24561,0.25),(1000035,24645,0.25),(1000035,24689,1),(1000035,24699,1),(1000035,26760,0.5),(1000035,26761,0.5),(1000035,26762,0.5),(1000035,27309,0.011942675159235),(1000035,27679,1),(1000035,27913,1),(1000035,27923,1),(1000035,27952,0.25),(1000035,28231,-0.090909090909),(1000035,28236,-0.090909090909),(1000035,28584,0.25),(1000035,28668,0.0554734747097155),(1000035,29000,0.0776255920767066),(1000035,29002,0.0776255920767066),(1000035,29004,0.0776255920767066),(1000035,29006,0.0776255920767066),(1000035,29008,0.0776255920767066),(1000035,29010,0.0776255920767066),(1000035,29012,0.0776255920767066),(1000035,29014,0.0776255920767066),(1000035,29016,0.0776255920767066),(1000036,672,9.72455418426332e-005),(1000036,967,9.72455418426332e-005),(1000036,9830,-0.00244289585986284),(1000036,9834,0.00264652600814927),(1000036,9846,-0.00137386165316677),(1000036,17366,0.000398089171974),(1000036,17367,0.000398089171974),(1000036,17368,0.000398089171974),(1000036,24445,0.000398089171974),(1000036,27309,0.000398089171974),(1000037,41,0.00059168748604954),(1000037,672,9.72455418426332e-005),(1000037,967,9.72455418426332e-005),(1000037,3717,-0.00135255995721452),(1000037,3828,-0.00075842581758854),(1000037,17366,0.001592356687898),(1000037,17367,0.001592356687898),(1000037,17368,0.001592356687898),(1000037,24445,0.001592356687898),(1000037,27309,0.001592356687898),(1000038,3687,0.00119307325520901),(1000038,9828,-0.000826676711724402),(1000038,9834,0.00264652600814927),(1000038,9842,-0.00224536225994577),(1000038,17366,0.002388535031847),(1000038,17367,0.002388535031847),(1000038,17368,0.002388535031847),(1000038,24445,0.002388535031847),(1000038,27309,0.002388535031847),(1000039,672,9.72455418426332e-005),(1000039,967,9.72455418426332e-005),(1000039,3685,0.00380100228767376),(1000039,3689,-0.000472488660804462),(1000039,3814,-0.00282088783215561),(1000039,9846,0.00351370086554458),(1000039,17366,0.003184713375796),(1000039,17367,0.003184713375796),(1000039,17368,0.003184713375796),(1000039,24445,0.003184713375796),(1000039,27309,0.003184713375796),(1000040,672,9.72455418426332e-005),(1000040,967,9.72455418426332e-005),(1000040,3695,-0.000742993331852756),(1000040,3773,0.00297435193221851),(1000040,9830,-0.00244289585986284),(1000040,9852,0.000789829896901656),(1000040,17366,0.002388535031847),(1000040,17367,0.002388535031847),(1000040,17368,0.002388535031847),(1000040,24445,0.002388535031847),(1000040,27309,0.002388535031847),(1000041,41,0.00059168748604954),(1000041,43,0.000481921379096225),(1000041,223,0.000347527026272295),(1000041,672,9.72455418426332e-005),(1000041,683,0.5),(1000041,967,9.72455418426332e-005),(1000041,1130,0.000151507385404694),(1000041,1133,0.000213533723763032),(1000041,1138,0.000347527026272295),(1000041,1141,0.00039553370926447),(1000041,3695,-0.000742993331852756),(1000041,17366,0.011942675159235),(1000041,17367,0.011942675159235),(1000041,17368,0.011942675159235),(1000041,24445,0.011942675159235),(1000041,27309,0.011942675159235),(1000042,3812,0.000650934422356853),(1000042,9828,-0.000826676711724402),(1000042,9844,-0.0151537338556737),(1000042,9846,0.00351370086554458),(1000042,17366,0.002388535031847),(1000042,17367,0.002388535031847),(1000042,17368,0.002388535031847),(1000042,24445,0.002388535031847),(1000042,27309,0.002388535031847),(1000043,672,9.72455418426332e-005),(1000043,967,9.72455418426332e-005),(1000043,3647,0.000478547388452215),(1000043,3814,0.00343467000427627),(1000043,9842,-0.00224536225994577),(1000043,9844,-0.0151537338556737),(1000043,17366,0.00796178343949),(1000043,17367,0.00796178343949),(1000043,17368,0.00796178343949),(1000043,24445,0.00796178343949),(1000043,27309,0.00796178343949),(1000044,672,0.000972455418426332),(1000044,811,0.0063576699300406),(1000044,812,0.00355296403424345),(1000044,813,0.00350494106972787),(1000044,814,0.00375552955387329),(1000044,967,0.000972455418426332),(1000044,1130,0.00151507385404694),(1000044,1131,0.00233570090076233),(1000044,1132,0.00233025811478461),(1000044,1133,0.00213533723763032),(1000044,3300,0.0140463431166794),(1000044,3301,0.0140463431166794),(1000044,3302,0.0833333333333333),(1000044,3303,0.0833333333333333),(1000044,3304,0.0833333333333333),(1000044,3305,0.0833333333333333),(1000044,3306,0.0833333333333333),(1000044,3307,0.0833333333333333),(1000044,3308,0.0833333333333333),(1000044,3309,0.0833333333333333),(1000044,3310,0.0833333333333333),(1000044,3311,0.0140463431166794),(1000044,3312,0.0833333333333333),(1000044,3315,0.0833333333333333),(1000044,3316,0.0833333333333333),(1000044,3317,0.0833333333333333),(1000044,3318,0.0833333333333333),(1000044,3319,0.0833333333333333),(1000044,3320,0.0833333333333333),(1000044,3321,0.0833333333333333),(1000044,3322,0.0833333333333333),(1000044,3323,0.0833333333333333),(1000044,3324,0.0833333333333333),(1000044,3325,0.0833333333333333),(1000044,3326,0.0833333333333333),(1000044,3327,0.0833333333333333),(1000044,3328,0.0140463431166794),(1000044,3329,0.0833333333333333),(1000044,3330,0.0833333333333333),(1000044,3331,0.0833333333333333),(1000044,3332,0.0833333333333333),(1000044,3333,0.0833333333333333),(1000044,3334,0.0833333333333333),(1000044,3335,0.0833333333333333),(1000044,3336,0.0833333333333333),(1000044,3337,0.0833333333333333),(1000044,3338,0.0833333333333333),(1000044,3339,0.0833333333333333),(1000044,3340,0.0833333333333333),(1000044,3341,0.0833333333333333),(1000044,3342,0.0833333333333333),(1000044,3343,0.0833333333333333),(1000044,3344,0.0833333333333333),(1000044,3345,0.0833333333333333),(1000044,3346,0.0833333333333333),(1000044,3347,0.0833333333333333),(1000044,3348,0.0833333333333333),(1000044,3349,0.083333333333),(1000044,3350,0.083333333333),(1000044,3351,0.0833333333333333),(1000044,3352,0.0833333333333333),(1000044,3354,0.0833333333333333),(1000044,3355,0.0833333333333333),(1000044,3356,0.0086413667660438),(1000044,3357,0.0751314800901578),(1000044,3358,0.0086413667660438),(1000044,3359,0.0086413667660438),(1000044,3361,0.0833333333333333),(1000044,3363,0.0833333333333333),(1000044,3368,0.0833333333333333),(1000044,3373,0.0833333333333333),(1000044,3374,0.0176898701327485),(1000044,3375,0.0833333333333333),(1000044,3376,0.0833333333333333),(1000044,3377,0.0833333333333333),(1000044,3378,0.0833333333333333),(1000044,3379,0.0833333333333333),(1000044,3380,0.0833333333333333),(1000044,3385,0.0833333333333333),(1000044,3386,0.0769426043712937),(1000044,3387,0.0833333333333333),(1000044,3388,0.0833333333333333),(1000044,3389,0.0833333333333333),(1000044,3392,0.0833333333333333),(1000044,3393,0.0833333333333333),(1000044,3394,0.0833333333333333),(1000044,3395,0.083333),(1000044,3396,0.0833005072564828),(1000044,3397,0.0833005072564828),(1000044,3398,0.0833005072564828),(1000044,3400,0.0833333333333333),(1000044,3402,0.0833333333333333),(1000044,3403,0.0833333333333333),(1000044,3405,0.0833333333333333),(1000044,3406,0.0833333333333333),(1000044,3409,0.0833333333333333),(1000044,3410,0.0833333333333333),(1000044,3411,0.0833333333333333),(1000044,3412,0.0833333333333333),(1000044,3413,0.0140463431166794),(1000044,3416,0.0140463431166794),(1000044,3417,0.0833333333333333),(1000044,3418,0.0833333333333333),(1000044,3419,0.0833333333333333),(1000044,3420,0.0833333333333333),(1000044,3421,0.0833333333333333),(1000044,3422,0.0833333333333333),(1000044,3423,0.0833333333333333),(1000044,3424,0.0833333333333333),(1000044,3425,0.0833333333333333),(1000044,3426,0.0140463431166794),(1000044,3427,0.0833333333333333),(1000044,3428,0.0833333333333333),(1000044,3429,0.0833333333333333),(1000044,3430,0.0833005072564827),(1000044,3431,0.0833333333333333),(1000044,3432,0.0833333333333333),(1000044,3433,0.0833333333333333),(1000044,3434,0.0833333333333333),(1000044,3435,0.0833333333333333),(1000044,3436,0.0140463431166794),(1000044,3437,0.0833333333333333),(1000044,3438,0.0833333333333333),(1000044,3439,0.0833333333333333),(1000044,3441,0.0833333333333333),(1000044,3442,0.0833333333333333),(1000044,3443,0.0832380162532896),(1000044,3444,0.0832380162532896),(1000044,3446,0.0832380162532896),(1000044,3447,0.0832380162532896),(1000044,3449,0.0140463431166794),(1000044,3450,0.0833333333333333),(1000044,3451,0.0833333333333333),(1000044,3452,0.0833333333333333),(1000044,3453,0.0833333333333333),(1000044,3454,0.0833333333333333),(1000044,3455,0.0140463431166794),(1000044,3456,0.0833333333333333),(1000044,3551,0.0833333333333333),(1000044,3683,0.0140886512751823),(1000044,3725,-0.00639963431559987),(1000044,3731,0.0833333333333333),(1000044,3732,0.0833333333333333),(1000044,3812,0.00650934422356853),(1000044,3828,-0.0075842581758854),(1000044,10039,0.0833333333333333),(1000044,10040,0.0833333333333333),(1000044,11082,0.166637483725898),(1000044,11207,0.0833333333333333),(1000044,11395,0.0086413667660438),(1000044,11433,0.0833333333333333),(1000044,11441,0.0833333333333333),(1000044,11442,0.0833333333333333),(1000044,11443,0.0833333333333333),(1000044,11444,0.0833333333333333),(1000044,11445,0.0833333333333333),(1000044,11446,0.0833333333333333),(1000044,11447,0.0833333333333333),(1000044,11448,0.0833333333333333),(1000044,11449,0.0833333333333333),(1000044,11450,0.0833333333333333),(1000044,11451,0.0833333333333333),(1000044,11452,0.0833333333333333),(1000044,11453,0.0833333333333333),(1000044,11454,0.0833333333333333),(1000044,11455,0.0833333333333333),(1000044,11487,0.0833333333333333),(1000044,11529,0.0833333333333333),(1000044,11566,0.0833333333333333),(1000044,11569,0.0833333333333333),(1000044,11572,0.0833333333333333),(1000044,11574,0.0833333333333333),(1000044,11579,0.0893245652277785),(1000044,11584,0.0833333333333333),(1000044,12093,0.0710408070392554),(1000044,12097,0.0833333333333333),(1000044,12098,0.0833333333333333),(1000044,12099,0.0833333333333333),(1000044,12179,0.0833333333333333),(1000044,12196,0.0587980184844922),(1000044,12206,0.166637483725898),(1000044,12207,0.166667988588085),(1000044,12241,0.0833333333333333),(1000044,12305,0.0833333333333333),(1000044,12365,0.0833333333333333),(1000044,12366,0.0833333333333333),(1000044,12367,0.0833333333333333),(1000044,12376,0.0832380162532896),(1000044,12383,0.0832380162532896),(1000044,12385,0.0832380162532896),(1000044,12386,0.0832380162532896),(1000044,12387,0.0832380162532896),(1000044,12441,0.166666666666667),(1000044,12442,0.166666666666667),(1000044,12487,0.333333333333333),(1000044,13278,0.0833333333333333),(1000044,16069,0.0833005072564828),(1000044,16281,0.0140463431166794),(1000044,16594,0.0832380162532896),(1000044,16595,0.0832380162532896),(1000044,16596,0.0832380162532896),(1000044,16597,0.0832380162532896),(1000044,16598,0.0832380162532896),(1000044,16622,0.0832380162532896),(1000044,17366,0.001990445859872),(1000044,17367,0.001990445859872),(1000044,17368,0.001990445859872),(1000044,17940,0.0833333333333333),(1000044,18580,0.0832380162532896),(1000044,19400,-0.0714969513351828),(1000044,19759,0.0833333333333333),(1000044,19760,0.0833333333333333),(1000044,19761,0.0833333333333333),(1000044,19766,0.0833333333333333),(1000044,19767,0.0833333333333333),(1000044,19921,0.0833333333333333),(1000044,19922,0.0833333333333333),(1000044,20209,0.166666666666667),(1000044,20210,0.166666666666667),(1000044,20211,0.166666666666667),(1000044,20212,0.166666666666667),(1000044,20213,0.166666666666667),(1000044,20312,0.166666666666667),(1000044,20314,0.166666666666667),(1000044,20315,0.166666666666667),(1000044,20342,0.0833333333333333),(1000044,20494,0.0833333333333333),(1000044,20495,0.0833333333333333),(1000044,20526,0.333333333333333),(1000044,20530,0.333333333333333),(1000044,20533,0.0833333333333333),(1000044,21059,0.0833333333333333),(1000044,21071,0.166666666666667),(1000044,21603,0.0833333333333333),(1000044,21610,0.0833333333333333),(1000044,21611,0.0833333333333333),(1000044,21666,0.166667988588085),(1000044,21668,0.166666666666667),(1000044,21718,0.0833333333333333),(1000044,21802,0.166666666666667),(1000044,21803,0.0833333333333333),(1000044,21853,0.0833333333333333),(1000044,21855,0.0833333333333333),(1000044,21857,0.0833333333333333),(1000044,22043,0.0833333333333333),(1000044,22176,0.0833333333333333),(1000044,22178,0.0833333333333333),(1000044,22242,0.0833333333333333),(1000044,22551,0.0833333333333333),(1000044,22578,0.0769426043712937),(1000044,22761,0.0833333333333333),(1000044,22806,0.0833333333333333),(1000044,22807,0.0833333333333333),(1000044,22808,0.0833333333333333),(1000044,22809,0.0833333333333333),(1000044,23069,0.0833333333333333),(1000044,23566,0.0833333333333333),(1000044,23594,0.0833333333333333),(1000044,23606,0.0833333333333333),(1000044,23618,0.0833333333333333),(1000044,23950,0.0833333333333333),(1000044,24241,0.0833333333333333),(1000044,24242,0.0832380162532896),(1000044,24268,0.0832380162532896),(1000044,24270,0.0832380162532896),(1000044,24311,0.0833333333333333),(1000044,24312,0.0833333333333333),(1000044,24313,0.0833333333333333),(1000044,24314,0.0833333333333333),(1000044,24445,0.001990445859872),(1000044,24562,0.0833333333333333),(1000044,24563,0.0833333333333333),(1000044,24568,0.0833005072564828),(1000044,24571,0.0833333333333333),(1000044,24572,0.0833333333333333),(1000044,24606,0.0833333333333333),(1000044,24613,0.0833333333333333),(1000044,24624,0.0833333333333333),(1000044,24625,0.0833333333333333),(1000044,24764,0.0833333333333333),(1000044,25233,0.0832380162532896),(1000044,25235,0.0832380162532896),(1000044,25718,0.166666666666667),(1000044,25719,0.166666666666667),(1000044,25739,0.0833333333333333),(1000044,25810,0.0833333333333333),(1000044,25811,0.0833333333333333),(1000044,25862,0.0833333333333333),(1000044,25863,0.0833333333333333),(1000044,26252,0.0833333333333333),(1000044,26253,0.0833333333333333),(1000044,26254,0.0833333333333333),(1000044,26255,0.0833333333333333),(1000044,26256,0.0833333333333333),(1000044,26257,0.0833333333333333),(1000044,26258,0.0833333333333333),(1000044,26259,0.0833333333333333),(1000044,26260,0.0833333333333333),(1000044,26261,0.0833333333333333),(1000044,27309,0.001990445859872),(1000044,27902,0.0833005072564828),(1000044,27906,0.0833333333333333),(1000044,27911,0.0833333333333333),(1000044,27936,0.0833005072564828),(1000044,28073,0.166666666666667),(1000044,28164,0.0833333333333333),(1000044,28374,0.0833333333333333),(1000044,28585,0.0833333333333333),(1000044,28609,0.0710408070392554),(1000044,28615,0.0710408070392554),(1000044,28656,0.0710408070392554),(1000044,28667,0.0710408070392554),(1000044,28879,0.0833333333333333),(1000044,28880,0.0833333333333333),(1000045,43,-0.00935903587601748),(1000045,672,0.000972455418426332),(1000045,811,0.0063576699300406),(1000045,812,0.00355296403424345),(1000045,813,0.00350494106972787),(1000045,814,0.00375552955387329),(1000045,967,0.000972455418426332),(1000045,1130,0.00151507385404694),(1000045,1132,0.00233025811478461),(1000045,1135,0.00623231458943357),(1000045,1136,0.00622843283415141),(1000045,1137,0.00469456687002521),(1000045,3300,0.0140463431166794),(1000045,3301,0.0140463431166794),(1000045,3302,0.0833333333333333),(1000045,3303,0.0833333333333333),(1000045,3304,0.0833333333333333),(1000045,3305,0.0833333333333333),(1000045,3306,0.0833333333333333),(1000045,3307,0.0833333333333333),(1000045,3308,0.0833333333333333),(1000045,3309,0.0833333333333333),(1000045,3310,0.0833333333333333),(1000045,3311,0.0140463431166794),(1000045,3312,0.0833333333333333),(1000045,3315,0.0833333333333333),(1000045,3316,0.0833333333333333),(1000045,3317,0.0833333333333333),(1000045,3318,0.0833333333333333),(1000045,3319,0.0833333333333333),(1000045,3320,0.0833333333333333),(1000045,3321,0.0833333333333333),(1000045,3322,0.0833333333333333),(1000045,3323,0.0833333333333333),(1000045,3324,0.0833333333333333),(1000045,3325,0.0833333333333333),(1000045,3326,0.0833333333333333),(1000045,3327,0.0833333333333333),(1000045,3328,0.0140463431166794),(1000045,3329,0.0833333333333333),(1000045,3330,0.0833333333333333),(1000045,3331,0.0833333333333333),(1000045,3332,0.0833333333333333),(1000045,3333,0.0833333333333333),(1000045,3334,0.0833333333333333),(1000045,3335,0.0833333333333333),(1000045,3336,0.0833333333333333),(1000045,3337,0.0833333333333333),(1000045,3338,0.0833333333333333),(1000045,3339,0.0833333333333333),(1000045,3340,0.0833333333333333),(1000045,3341,0.0833333333333333),(1000045,3342,0.0833333333333333),(1000045,3343,0.0833333333333333),(1000045,3344,0.0833333333333333),(1000045,3345,0.0833333333333333),(1000045,3346,0.0833333333333333),(1000045,3347,0.0833333333333333),(1000045,3348,0.0833333333333333),(1000045,3349,0.083333333333),(1000045,3350,0.083333333333),(1000045,3351,0.0833333333333333),(1000045,3352,0.0833333333333333),(1000045,3354,0.0833333333333333),(1000045,3355,0.0833333333333333),(1000045,3356,0.0086413667660438),(1000045,3357,0.0826446280991736),(1000045,3358,0.0086413667660438),(1000045,3359,0.0086413667660438),(1000045,3361,0.0833333333333333),(1000045,3363,0.0833333333333333),(1000045,3368,0.0833333333333333),(1000045,3373,0.0833333333333333),(1000045,3374,0.0176898701327485),(1000045,3375,0.0833333333333333),(1000045,3376,0.0833333333333333),(1000045,3377,0.0833333333333333),(1000045,3378,0.0833333333333333),(1000045,3379,0.0833333333333333),(1000045,3380,0.0833333333333333),(1000045,3385,0.0833333333333333),(1000045,3386,0.0769426043712937),(1000045,3387,0.0833333333333333),(1000045,3388,0.0833333333333333),(1000045,3389,0.0833333333333333),(1000045,3392,0.0833333333333333),(1000045,3393,0.0833333333333333),(1000045,3394,0.0833333333333333),(1000045,3395,0.083333),(1000045,3396,0.0833005072564828),(1000045,3397,0.0833005072564828),(1000045,3398,0.0833005072564828),(1000045,3400,0.0833333333333333),(1000045,3402,0.0833333333333333),(1000045,3403,0.0833333333333333),(1000045,3405,0.0833333333333333),(1000045,3406,0.0833333333333333),(1000045,3409,0.0833333333333333),(1000045,3410,0.0833333333333333),(1000045,3411,0.0833333333333333),(1000045,3412,0.0833333333333333),(1000045,3413,0.0140463431166794),(1000045,3416,0.0140463431166794),(1000045,3417,0.0833333333333333),(1000045,3418,0.0833333333333333),(1000045,3419,0.0833333333333333),(1000045,3420,0.0833333333333333),(1000045,3421,0.0833333333333333),(1000045,3422,0.0833333333333333),(1000045,3423,0.0833333333333333),(1000045,3424,0.0833333333333333),(1000045,3425,0.0833333333333333),(1000045,3426,0.0140463431166794),(1000045,3427,0.0833333333333333),(1000045,3428,0.0833333333333333),(1000045,3429,0.0833333333333333),(1000045,3430,0.0833005072564827),(1000045,3431,0.0833333333333333),(1000045,3432,0.0833333333333333),(1000045,3433,0.0833333333333333),(1000045,3434,0.0833333333333333),(1000045,3435,0.0833333333333333),(1000045,3436,0.0140463431166794),(1000045,3437,0.0833333333333333),(1000045,3438,0.0833333333333333),(1000045,3439,0.0833333333333333),(1000045,3441,0.0833333333333333),(1000045,3442,0.0833333333333333),(1000045,3443,0.0833005072564828),(1000045,3444,0.0833005072564828),(1000045,3446,0.0833005072564828),(1000045,3447,0.0833005072564828),(1000045,3449,0.0140463431166794),(1000045,3450,0.0833333333333333),(1000045,3451,0.0833333333333333),(1000045,3452,0.0833333333333333),(1000045,3453,0.0833333333333333),(1000045,3454,0.0833333333333333),(1000045,3455,0.0140463431166794),(1000045,3456,0.0833333333333333),(1000045,3551,0.0833333333333333),(1000045,3645,-0.00670419204782632),(1000045,3731,0.0833333333333333),(1000045,3732,0.0833333333333333),(1000045,9828,0.00455591538090099),(1000045,9850,0.00711366442245851),(1000045,10039,0.0833333333333333),(1000045,10040,0.0833333333333333),(1000045,11082,0.166429186871241),(1000045,11207,0.0833333333333333),(1000045,11395,0.0086413667660438),(1000045,11433,0.0833333333333333),(1000045,11441,0.0833333333333333),(1000045,11442,0.0833333333333333),(1000045,11443,0.0833333333333333),(1000045,11444,0.0833333333333333),(1000045,11445,0.0833333333333333),(1000045,11446,0.0833333333333333),(1000045,11447,0.0833333333333333),(1000045,11448,0.0833333333333333),(1000045,11449,0.0833333333333333),(1000045,11450,0.0833333333333333),(1000045,11451,0.0833333333333333),(1000045,11452,0.0833333333333333),(1000045,11453,0.0833333333333333),(1000045,11454,0.0833333333333333),(1000045,11455,0.0833333333333333),(1000045,11487,0.0833333333333333),(1000045,11529,0.0833333333333333),(1000045,11566,0.0833333333333333),(1000045,11569,0.0833333333333333),(1000045,11572,0.0833333333333333),(1000045,11574,0.0833333333333333),(1000045,11579,0.0778461937379695),(1000045,11584,0.0833333333333333),(1000045,12093,0.0794430181351515),(1000045,12097,0.0833333333333333),(1000045,12098,0.0833333333333333),(1000045,12099,0.0833333333333333),(1000045,12179,0.0833333333333333),(1000045,12196,0.0711456023662356),(1000045,12206,0.166429186871241),(1000045,12207,0.166419111051902),(1000045,12241,0.0833333333333333),(1000045,12305,0.0833333333333333),(1000045,12365,0.0833333333333333),(1000045,12366,0.0833333333333333),(1000045,12367,0.0833333333333333),(1000045,12376,0.0833005072564828),(1000045,12383,0.0833005072564828),(1000045,12385,0.0833005072564828),(1000045,12386,0.0833005072564828),(1000045,12387,0.0833005072564828),(1000045,12441,0.166666666666667),(1000045,12442,0.166666666666667),(1000045,12487,0.333333333333333),(1000045,13278,0.0833333333333333),(1000045,16069,0.0833005072564828),(1000045,16281,0.0140463431166794),(1000045,16594,0.0833005072564828),(1000045,16595,0.0833005072564828),(1000045,16596,0.0833005072564828),(1000045,16597,0.0833005072564828),(1000045,16598,0.0833005072564828),(1000045,16622,0.0833005072564828),(1000045,17366,0.001990445859872),(1000045,17367,0.001990445859872),(1000045,17368,0.001990445859872),(1000045,17940,0.0833333333333333),(1000045,18580,0.0833005072564828),(1000045,19400,-0.0714826307124141),(1000045,19759,0.0833333333333333),(1000045,19760,0.0833333333333333),(1000045,19761,0.0833333333333333),(1000045,19766,0.0833333333333333),(1000045,19767,0.0833333333333333),(1000045,19921,0.0833333333333333),(1000045,19922,0.0833333333333333),(1000045,20209,0.166666666666667),(1000045,20210,0.166666666666667),(1000045,20211,0.166666666666667),(1000045,20212,0.166666666666667),(1000045,20213,0.166666666666667),(1000045,20312,0.166666666666667),(1000045,20314,0.166666666666667),(1000045,20315,0.166666666666667),(1000045,20342,0.0833333333333333),(1000045,20494,0.0833333333333333),(1000045,20495,0.0833333333333333),(1000045,20526,0.333333333333333),(1000045,20530,0.333333333333333),(1000045,20533,0.0833333333333333),(1000045,21059,0.0833333333333333),(1000045,21071,0.166666666666667),(1000045,21603,0.0833333333333333),(1000045,21610,0.0833333333333333),(1000045,21611,0.0833333333333333),(1000045,21666,0.166419111051902),(1000045,21668,0.166666666666667),(1000045,21718,0.0833333333333333),(1000045,21802,0.166666666666667),(1000045,21803,0.0833333333333333),(1000045,21853,0.0833333333333333),(1000045,21855,0.0833333333333333),(1000045,21857,0.0833333333333333),(1000045,22043,0.0833333333333333),(1000045,22176,0.0833333333333333),(1000045,22178,0.0833333333333333),(1000045,22242,0.0833333333333333),(1000045,22551,0.0833333333333333),(1000045,22578,0.0769426043712937),(1000045,22761,0.0833333333333333),(1000045,22806,0.0833333333333333),(1000045,22807,0.0833333333333333),(1000045,22808,0.0833333333333333),(1000045,22809,0.0833333333333333),(1000045,23069,0.0833333333333333),(1000045,23566,0.0833333333333333),(1000045,23594,0.0833333333333333),(1000045,23606,0.0833333333333333),(1000045,23618,0.0833333333333333),(1000045,23950,0.0833333333333333),(1000045,24241,0.0833333333333333),(1000045,24242,0.0833005072564828),(1000045,24268,0.0833005072564828),(1000045,24270,0.0833005072564828),(1000045,24311,0.0833333333333333),(1000045,24312,0.0833333333333333),(1000045,24313,0.0833333333333333),(1000045,24314,0.0833333333333333),(1000045,24445,0.001990445859872),(1000045,24562,0.0833333333333333),(1000045,24563,0.0833333333333333),(1000045,24568,0.0833005072564828),(1000045,24571,0.0833333333333333),(1000045,24572,0.0833333333333333),(1000045,24606,0.0833333333333333),(1000045,24613,0.0833333333333333),(1000045,24624,0.0833333333333333),(1000045,24625,0.0833333333333333),(1000045,24764,0.0833333333333333),(1000045,25233,0.0833005072564828),(1000045,25235,0.0833005072564828),(1000045,25718,0.166666666666667),(1000045,25719,0.166666666666667),(1000045,25739,0.0833333333333333),(1000045,25810,0.0833333333333333),(1000045,25811,0.0833333333333333),(1000045,25862,0.0833333333333333),(1000045,25863,0.0833333333333333),(1000045,26252,0.0833333333333333),(1000045,26253,0.0833333333333333),(1000045,26254,0.0833333333333333),(1000045,26255,0.0833333333333333),(1000045,26256,0.0833333333333333),(1000045,26257,0.0833333333333333),(1000045,26258,0.0833333333333333),(1000045,26259,0.0833333333333333),(1000045,26260,0.0833333333333333),(1000045,26261,0.0833333333333333),(1000045,27309,0.001990445859872),(1000045,27902,0.0833005072564828),(1000045,27906,0.0833333333333333),(1000045,27911,0.0833333333333333),(1000045,27936,0.0833005072564828),(1000045,28073,0.166666666666667),(1000045,28164,0.0833333333333333),(1000045,28374,0.0833333333333333),(1000045,28585,0.0833333333333333),(1000045,28609,0.0794430181351515),(1000045,28615,0.0794430181351515),(1000045,28656,0.0794430181351515),(1000045,28667,0.0794430181351515),(1000045,28879,0.0833333333333333),(1000045,28880,0.0833333333333333),(1000046,43,0.000481921379096225),(1000046,3773,-0.0023130082217371),(1000046,9838,-0.00116630443368635),(1000046,9842,0.00905944177637893),(1000046,11132,0.00103998399734633),(1000046,11133,0.00103998399734633),(1000046,17366,0.002388535031847),(1000046,17367,0.002388535031847),(1000046,17368,0.002388535031847),(1000046,24445,0.002388535031847),(1000046,27309,0.002388535031847),(1000047,945,0.00140227877045328),(1000047,3691,-0.000742312377102859),(1000047,9852,0.000789829896901656),(1000047,11132,0.00103998399734633),(1000047,11133,0.00103998399734633),(1000047,12478,1),(1000047,17366,0.002388535031847),(1000047,17367,0.002388535031847),(1000047,17368,0.002388535031847),(1000047,24445,0.002388535031847),(1000047,27309,0.002388535031847),(1000048,690,0.5),(1000048,3699,-0.000389261669792987),(1000048,3715,0.000439322944845598),(1000048,3717,0.0970575584880456),(1000048,3725,-0.000639963431559987),(1000048,11132,0.00103998399734633),(1000048,11133,0.00103998399734633),(1000048,17366,0.002388535031847),(1000048,17367,0.002388535031847),(1000048,17368,0.002388535031847),(1000048,24445,0.002388535031847),(1000048,27309,0.002388535031847),(1000049,41,-0.000838149063805408),(1000049,3693,0.00268386370244684),(1000049,3729,0.0464323655138879),(1000049,9846,-0.00137386165316677),(1000049,11132,0.00103998399734633),(1000049,11133,0.00103998399734633),(1000049,12478,-1),(1000049,17366,0.002388535031847),(1000049,17367,0.002388535031847),(1000049,17368,0.002388535031847),(1000049,24445,0.002388535031847),(1000049,27309,0.002388535031847),(1000050,43,-0.000935903587601748),(1000050,3695,0.000340845479652617),(1000050,3697,-0.000530129468378037),(1000050,3812,0.000650934422356853),(1000050,11132,0.00103998399734633),(1000050,11133,0.00103998399734633),(1000050,17366,0.00796178343949),(1000050,17367,0.00796178343949),(1000050,17368,0.00796178343949),(1000050,24445,0.00796178343949),(1000050,27309,0.00796178343949),(1000051,44,0.000999000999000999),(1000051,187,1),(1000051,188,0.00195533087419784),(1000051,189,0.5),(1000051,195,1),(1000051,196,1),(1000051,197,1),(1000051,489,0.00495779503510555),(1000051,490,0.00140622260265776),(1000051,492,1),(1000051,494,1),(1000051,495,1),(1000051,496,0.00495779503510555),(1000051,518,0.00108074684923337),(1000051,689,0.00140424791749644),(1000051,690,0.5),(1000051,691,1),(1000051,692,0.0130422067216992),(1000051,693,1),(1000051,786,0.000271238301877068),(1000051,788,0.5),(1000051,790,0.25),(1000051,803,0.333333333333333),(1000051,804,0.333333333333333),(1000051,805,0.333333333333333),(1000051,806,0.333333333333333),(1000051,807,0.5),(1000051,808,0.5),(1000051,809,0.5),(1000051,810,0.5),(1000051,813,0.000350494106972787),(1000051,814,0.000375552955387329),(1000051,819,0.00140424791749644),(1000051,820,0.00135455863801296),(1000051,821,0.00140424791749644),(1000051,822,1),(1000051,823,1),(1000051,824,0.00495779503510555),(1000051,825,0.00140622260265776),(1000051,826,1),(1000051,827,1),(1000051,828,1),(1000051,829,1),(1000051,830,1),(1000051,831,0.00495779503510555),(1000051,832,1),(1000051,833,1),(1000051,879,0.000534474439183068),(1000051,880,0.00140424791749644),(1000051,881,0.00134566869131638),(1000051,882,0.00140227877045328),(1000051,883,0.00136588703695291),(1000051,884,0.00134748195559614),(1000051,885,0.00138288684185062),(1000051,886,0.00136588703695291),(1000051,887,0.00140424791749644),(1000051,888,1),(1000051,889,0.00195533087419784),(1000051,890,0.5),(1000051,891,0.00140424791749644),(1000051,892,0.5),(1000051,893,0.00195533087419784),(1000051,894,1),(1000051,895,1),(1000051,896,1),(1000051,897,1),(1000051,898,1),(1000051,899,1),(1000051,900,1),(1000051,901,1),(1000051,902,1),(1000051,945,0.00140227877045328),(1000051,946,0.00493333656358411),(1000051,974,1),(1000051,975,1),(1000051,976,1),(1000051,986,1),(1000051,987,1),(1000051,988,1),(1000051,998,1),(1000051,1096,0.5),(1000051,1099,0.000846839933931841),(1000051,1214,0.25),(1000051,1216,0.00124126207272337),(1000051,1220,0.00104187744990559),(1000051,1221,0.00104187744990559),(1000051,1548,0.5),(1000051,1811,0.004679400908036),(1000051,1815,0.000776029975055001),(1000051,1817,0.00124126207272337),(1000051,1819,0.0769230769230769),(1000051,1821,0.0769230769230769),(1000051,1823,0.0769230769230769),(1000051,1825,0.0769230769230769),(1000051,1827,0.0769230769230769),(1000051,1829,0.0769230769230769),(1000051,1831,0.0769230769230769),(1000051,1833,0.0769230769230769),(1000051,2019,0.00205347926444682),(1000051,2162,0.00936034252862661),(1000051,2194,0.25),(1000051,2445,0.25),(1000051,2477,0.25),(1000051,2507,0.00104187744990559),(1000051,2509,0.00104187744990559),(1000051,2511,0.000693104366255889),(1000051,2513,0.00104187744990559),(1000051,2515,0.00103600230549374),(1000051,2517,0.000693104366255889),(1000051,3293,0.000604281162378804),(1000051,3296,0.25),(1000051,3297,0.000604281162378804),(1000051,3465,0.25),(1000051,3466,0.25),(1000051,3467,0.25),(1000051,3529,0.00164836942295552),(1000051,3539,0.25),(1000051,3689,-0.000472488660804462),(1000051,3767,0.00493333656358411),(1000051,3830,0.000804104561382833),(1000051,3978,0.25),(1000051,3982,0.25),(1000051,3988,0.25),(1000051,3994,0.25),(1000051,9844,0.00116117670171694),(1000051,9846,-0.00137386165316677),(1000051,9850,0.000711366442245851),(1000051,9945,0.25),(1000051,10630,0.00137697945210535),(1000051,10837,0.25),(1000051,10839,0.25),(1000051,10841,0.25),(1000051,11132,0.00103998399734633),(1000051,11133,0.00103998399734633),(1000051,11488,0.25),(1000051,11489,0.25),(1000051,11613,0.25),(1000051,12275,0.104757183633626),(1000051,12710,1),(1000051,13321,0.117028312109649),(1000051,15596,-0.090909090909),(1000051,15597,-0.090909090909),(1000051,15598,-0.090909090909),(1000051,15599,-0.090909090909),(1000051,15600,-0.090909090909),(1000051,15601,-0.090909090909),(1000051,15602,-0.090909090909),(1000051,15604,-0.090909090909),(1000051,15605,-0.090909090909),(1000051,15607,-0.090909090909),(1000051,15608,-0.090909090909),(1000051,15609,-0.090909090909),(1000051,15610,-0.090909090909),(1000051,15611,-0.090909090909),(1000051,15612,-0.090909090909),(1000051,15613,-0.090909090909),(1000051,15614,-0.090909090909),(1000051,15615,-0.090909090909),(1000051,15617,-0.090909090909),(1000051,15618,-0.090909090909),(1000051,15619,-0.090909090909),(1000051,15620,-0.090909090909),(1000051,15621,-0.090909090909),(1000051,15622,-0.090909090909),(1000051,15623,-0.090909090909),(1000051,15634,-0.090909090909),(1000051,15635,-0.090909090909),(1000051,15636,-0.090909090909),(1000051,15640,-0.090909090909),(1000051,15641,-0.090909090909),(1000051,15642,-0.090909090909),(1000051,15643,-0.090909090909),(1000051,15653,-0.090909090909),(1000051,15654,-0.090909090909),(1000051,15655,-0.090909090909),(1000051,15656,-0.090909090909),(1000051,15657,-0.090909090909),(1000051,15669,-0.090909090909),(1000051,15670,-0.090909090909),(1000051,15671,-0.090909090909),(1000051,15672,-0.090909090909),(1000051,15992,-0.090909090909),(1000051,15993,-0.090909090909),(1000051,15996,-0.090909090909),(1000051,15999,-0.090909090909),(1000051,16000,-0.090909090909),(1000051,16001,-0.090909090909),(1000051,16179,-0.090909090909),(1000051,16180,-0.090909090909),(1000051,16181,-0.090909090909),(1000051,16182,-0.090909090909),(1000051,16183,-0.090909090909),(1000051,16184,-0.090909090909),(1000051,16185,-0.090909090909),(1000051,16186,-0.090909090909),(1000051,16187,-0.090909090909),(1000051,16188,-0.090909090909),(1000051,16189,-0.090909090909),(1000051,16232,1),(1000051,16243,1),(1000051,17363,0.25),(1000051,17364,0.25),(1000051,17365,0.25),(1000051,17366,0.011942675159235),(1000051,17367,0.011942675159235),(1000051,17368,0.011942675159235),(1000051,17665,1),(1000051,17667,1),(1000051,17669,1),(1000051,17671,1),(1000051,17673,1),(1000051,17675,1),(1000051,17677,1),(1000051,17679,1),(1000051,17858,0.00104187744990559),(1000051,17860,0.00104187744990559),(1000051,17862,0.00104187744990559),(1000051,17864,0.00104187744990559),(1000051,17999,-0.090909090909),(1000051,19723,1),(1000051,20190,1),(1000051,20281,0.25),(1000051,20453,1),(1000051,20455,1),(1000051,20704,0.5),(1000051,21010,1),(1000051,21012,0.333333333333333),(1000051,21022,0.5),(1000051,21026,0.25),(1000051,21028,0.25),(1000051,21040,0.25),(1000051,21042,0.5),(1000051,21604,0.25),(1000051,21868,0.5),(1000051,22302,0.25),(1000051,22306,0.5),(1000051,22307,0.5),(1000051,22308,0.5),(1000051,22309,0.5),(1000051,22310,0.5),(1000051,22311,0.5),(1000051,22853,1),(1000051,23736,0.25),(1000051,23774,1),(1000051,23954,0.25),(1000051,24349,0.25),(1000051,24445,0.011942675159235),(1000051,24484,1),(1000051,24546,0.25),(1000051,24548,0.25),(1000051,24549,1),(1000051,24557,0.25),(1000051,24559,0.25),(1000051,24561,0.25),(1000051,24645,0.25),(1000051,24695,1),(1000051,24703,1),(1000051,26759,0.5),(1000051,26760,0.5),(1000051,26761,0.5),(1000051,26762,0.5),(1000051,27309,0.011942675159235),(1000051,27915,0.25),(1000051,27919,1),(1000051,27952,0.25),(1000051,28237,-0.090909090909),(1000051,28238,-0.090909090909),(1000051,28584,0.25),(1000051,28668,0.0815883098148401),(1000051,29000,0.0909090909090909),(1000051,29002,0.0909090909090909),(1000051,29004,0.0909090909090909),(1000051,29006,0.0909090909090909),(1000051,29008,0.0909090909090909),(1000051,29010,0.0909090909090909),(1000051,29012,0.0909090909090909),(1000051,29014,0.0909090909090909),(1000051,29016,0.0909090909090909),(1000052,3715,0.000439322944845598),(1000052,3717,-0.00135255995721452),(1000052,3814,0.00343467000427627),(1000052,11132,0.00103998399734633),(1000052,11133,0.00103998399734633),(1000052,17366,0.00796178343949),(1000052,17367,0.00796178343949),(1000052,17368,0.00796178343949),(1000052,24445,0.00796178343949),(1000052,27309,0.00796178343949),(1000053,43,0.000481921379096225),(1000053,3727,-0.0462674739391337),(1000053,3814,0.00343467000427627),(1000053,9832,0.0482943072888091),(1000053,11132,0.00103998399734633),(1000053,11133,0.00103998399734633),(1000053,17366,0.000597133757961),(1000053,17367,0.000597133757961),(1000053,17368,0.000597133757961),(1000053,24445,0.000597133757961),(1000053,27309,0.000597133757961),(1000054,188,0.00195533087419784),(1000054,189,0.5),(1000054,689,0.00140424791749644),(1000054,819,0.00140424791749644),(1000054,820,0.00135455863801296),(1000054,821,0.00140424791749644),(1000054,879,0.000534474439183068),(1000054,880,0.00140424791749644),(1000054,881,0.00134566869131638),(1000054,882,0.00140227877045328),(1000054,883,0.00136588703695291),(1000054,884,0.00134748195559614),(1000054,885,0.00138288684185062),(1000054,886,0.00136588703695291),(1000054,887,0.00140424791749644),(1000054,889,0.00195533087419784),(1000054,890,0.5),(1000054,891,0.00140424791749644),(1000054,892,0.5),(1000054,893,0.00195533087419784),(1000054,945,0.00140227877045328),(1000054,946,0.00493333656358411),(1000054,1096,0.5),(1000054,3767,0.00493333656358411),(1000054,11132,0.00103998399734633),(1000054,11133,0.00103998399734633),(1000054,17366,0.011942675159235),(1000054,17367,0.011942675159235),(1000054,17368,0.011942675159235),(1000054,24445,0.011942675159235),(1000054,27309,0.011942675159235),(1000055,41,-0.0360106145870717),(1000055,785,0.0134428369174951),(1000055,879,0.0229634009834452),(1000055,1202,0.0087375889822963),(1000055,1218,0.0087375889822963),(1000055,3651,0.0348112525129089),(1000055,3685,-0.134984554443305),(1000055,3691,0.0888725054122448),(1000055,9828,0.019574240425451),(1000055,10247,0.0087375889822963),(1000055,11132,0.0446823417485266),(1000055,11133,0.0446823417485266),(1000055,12109,0.0134428369174951),(1000055,12237,0.150075025319064),(1000055,12238,0.130508539083988),(1000055,12239,0.130508539083988),(1000055,13780,0.150075025319064),(1000055,14343,0.130508539083988),(1000055,16216,0.150075025319064),(1000055,16220,0.150075025319064),(1000055,16221,0.150075025319064),(1000055,16279,0.150075025319064),(1000055,16869,0.150075025319064),(1000055,17366,0.011942675159235),(1000055,17367,0.011942675159235),(1000055,17368,0.011942675159235),(1000055,17482,0.150075025319064),(1000055,17483,0.150075025319064),(1000055,17621,0.150075025319064),(1000055,17982,0.150075025319064),(1000055,18037,0.0134428369174951),(1000055,18039,0.0134428369174951),(1000055,18041,0.0134428369174951),(1000055,18043,0.0134428369174951),(1000055,18045,0.0134428369174951),(1000055,18047,0.0134428369174951),(1000055,18049,0.0134428369174951),(1000055,18051,0.0134428369174951),(1000055,18053,0.0134428369174951),(1000055,18055,0.0134428369174951),(1000055,18057,0.0134428369174951),(1000055,18059,0.0134428369174951),(1000055,18061,0.0134428369174951),(1000055,18063,0.0134428369174951),(1000055,18065,0.0134428369174951),(1000055,18067,0.0134428369174951),(1000055,18626,0.150075025319064),(1000055,18635,0.150075025319064),(1000055,18637,0.150075025319064),(1000055,19470,0.130508539083988),(1000055,20175,0.150075025319064),(1000055,22543,0.150075025319064),(1000055,22577,0.150075025319064),(1000055,24445,0.011942675159235),(1000055,24574,0.150075025319064),(1000055,24575,0.150075025319064),(1000055,24646,0.150075025319064),(1000055,24653,0.150075025319064),(1000055,24654,0.150075025319064),(1000055,24655,0.150075025319064),(1000055,24656,0.150075025319064),(1000055,24657,0.150075025319064),(1000055,24658,0.150075025319064),(1000055,24659,0.150075025319064),(1000055,24660,0.150075025319064),(1000055,27309,0.011942675159235),(1000055,27656,0.214392891589286),(1000055,27658,0.214392891589286),(1000055,27660,0.214392891589286),(1000055,27673,0.150075025319064),(1000055,27674,0.150075025319064),(1000055,27675,0.150075025319064),(1000055,27897,0.150075025319064),(1000055,28351,0.150075025319064),(1000055,28368,0.150075025319064),(1000055,28386,0.150075025319064),(1000055,28448,0.150075025319064),(1000055,28449,0.150075025319064),(1000055,28450,0.150075025319064),(1000055,28451,0.150075025319064),(1000055,28452,0.150075025319064),(1000055,28453,0.150075025319064),(1000055,28454,0.150075025319064),(1000055,28455,0.150075025319064),(1000055,28456,0.150075025319064),(1000055,28457,0.150075025319064),(1000055,28458,0.150075025319064),(1000055,28459,0.150075025319064),(1000055,28460,0.150075025319064),(1000055,28461,0.150075025319064),(1000055,28462,0.150075025319064),(1000055,28463,0.150075025319064),(1000055,28464,0.150075025319064),(1000055,28465,0.150075025319064),(1000055,28466,0.150075025319064),(1000055,28467,0.150075025319064),(1000055,28468,0.150075025319064),(1000055,28469,0.150075025319064),(1000055,28470,0.150075025319064),(1000055,28471,0.150075025319064),(1000055,28472,0.150075025319064),(1000055,28473,0.150075025319064),(1000055,28474,0.150075025319064),(1000055,28475,0.150075025319064),(1000055,28476,0.150075025319064),(1000055,28477,0.150075025319064),(1000055,28478,0.150075025319064),(1000055,28479,0.150075025319064),(1000055,28480,0.150075025319064),(1000055,28481,0.150075025319064),(1000055,28482,0.150075025319064),(1000055,28483,0.150075025319064),(1000055,28484,0.150075025319064),(1000055,28485,0.150075025319064),(1000055,28486,0.150075025319064),(1000055,28487,0.150075025319064),(1000055,28488,0.150075025319064),(1000055,28489,0.150075025319064),(1000055,28490,0.150075025319064),(1000055,28491,0.150075025319064),(1000055,28492,0.150075025319064),(1000055,28493,0.150075025319064),(1000055,28494,0.150075025319064),(1000055,28495,0.150075025319064),(1000055,28496,0.150075025319064),(1000055,28497,0.150075025319064),(1000055,28498,0.150075025319064),(1000055,28499,0.150075025319064),(1000055,28500,0.150075025319064),(1000055,28501,0.150075025319064),(1000055,28502,0.150075025319064),(1000055,28503,0.150075025319064),(1000055,28504,0.150075025319064),(1000055,28505,0.150075025319064),(1000056,43,0.24550154346138),(1000056,188,0.996089338251604),(1000056,490,0.716361287084185),(1000056,521,0.24690854765669),(1000056,689,0.715355338238622),(1000056,786,0.138174865538323),(1000056,812,0.180995945003588),(1000056,819,0.715355338238622),(1000056,820,0.69004250644528),(1000056,821,0.715355338238622),(1000056,825,0.716361287084185),(1000056,879,0.272273249230346),(1000056,880,0.715355338238622),(1000056,881,0.685513768501776),(1000056,882,0.71435221063448),(1000056,883,0.695813446572318),(1000056,884,0.686437485935145),(1000056,885,0.704473527909146),(1000056,886,0.695813446572318),(1000056,887,0.715355338238622),(1000056,889,0.996089338251604),(1000056,891,0.715355338238622),(1000056,893,0.996089338251604),(1000056,945,0.71435221063448),(1000056,1067,0.426972565857458),(1000056,1072,0.260678751269665),(1000056,1106,0.808992984457213),(1000056,1109,0.200708673563909),(1000056,1192,1),(1000056,1202,0.103600148094969),(1000056,1208,0.717370069089809),(1000056,1218,0.103600148094969),(1000056,1245,0.166666),(1000056,1318,0.166666),(1000056,1334,0.166666),(1000056,1401,1),(1000056,1404,0.166666),(1000056,2047,0.24690854765669),(1000056,2464,0.457968916414619),(1000056,2465,0.457968916414619),(1000056,2604,0.166666),(1000056,3469,0.662843743048388),(1000056,3689,-0.240696305511557),(1000056,3695,0.173634320796222),(1000056,9828,-0.421127630927109),(1000056,10247,0.103600148094969),(1000056,11132,0.52979113938143),(1000056,11133,0.52979113938143),(1000056,11619,0.25),(1000056,11621,1),(1000056,11623,0.8),(1000056,11629,0.166666),(1000056,11632,1),(1000056,11859,0.0834095261999572),(1000056,11860,0.0834095261999572),(1000056,11870,0.0834095261999572),(1000056,11872,0.0834095261999572),(1000056,11873,0.0834095261999572),(1000056,11877,1),(1000056,11887,0.0834095261999572),(1000056,11889,0.0834095261999572),(1000056,11890,0.0834095261999572),(1000056,11891,0.0834095261999572),(1000056,12053,0.426972565857458),(1000056,12055,0.426972565857458),(1000056,12057,0.260678751269665),(1000056,12067,0.260678751269665),(1000056,12092,0.125),(1000056,12096,0.249812453113278),(1000056,12258,0.333333),(1000056,12262,0.333333),(1000056,12266,0.166666),(1000056,12270,0.166666),(1000056,17322,0.333333),(1000056,17324,0.333333),(1000056,17325,0.333333),(1000056,17326,0.333333),(1000056,17333,0.333333),(1000056,17342,0.333333),(1000056,17346,0.333333),(1000056,17347,0.333333),(1000056,17355,0.333333),(1000056,17366,0.017914012738853),(1000056,17367,0.017914012738853),(1000056,17368,0.017914012738853),(1000056,17941,0.25),(1000056,17942,0.25),(1000056,17943,0.25),(1000056,17944,0.25),(1000056,17945,0.25),(1000056,17946,0.25),(1000056,17947,0.25),(1000056,17948,0.25),(1000056,17949,0.25),(1000056,17950,0.25),(1000056,17951,0.25),(1000056,17952,0.25),(1000056,17953,0.25),(1000056,17954,0.25),(1000056,17955,0.25),(1000056,17956,0.25),(1000056,17957,0.25),(1000056,17958,0.25),(1000056,17961,0.25),(1000056,17962,0.25),(1000056,17963,0.25),(1000056,17964,0.25),(1000056,17965,0.25),(1000056,17966,0.25),(1000056,17967,0.25),(1000056,17968,0.25),(1000056,17969,0.25),(1000056,17970,0.25),(1000056,17971,0.25),(1000056,17972,0.25),(1000056,19719,0.125109361329834),(1000056,21946,0.5),(1000056,21949,0.168278121242148),(1000056,21957,0.168278121242148),(1000056,21959,0.334957705757328),(1000056,21961,0.0923180057038325),(1000056,21969,0.334957705757328),(1000056,22779,0.166666),(1000056,24445,0.017914012738853),(1000056,25562,0.166666),(1000056,25929,0.0834095261999572),(1000056,25931,0.0834095261999572),(1000056,25933,0.0834095261999572),(1000056,25935,0.0834095261999572),(1000056,25937,0.0834095261999572),(1000056,25949,0.0834095261999572),(1000056,25951,0.0834095261999572),(1000056,25953,0.0834095261999572),(1000056,25955,0.0834095261999572),(1000056,25957,0.0834095261999572),(1000056,26039,0.333333),(1000056,26041,0.333333),(1000056,26043,0.333333),(1000056,26047,0.333333),(1000056,26049,0.333333),(1000056,26057,0.333333),(1000056,26059,0.333333),(1000056,26061,0.333333),(1000056,26063,0.333333),(1000056,26067,0.333333),(1000056,26069,0.333333),(1000056,26071,0.333333),(1000056,26073,0.333333),(1000056,27309,0.017914012738853),(1000056,27941,0.5),(1000056,27971,0.5),(1000056,27973,0.5),(1000056,27979,0.5),(1000056,27981,0.5),(1000056,27985,0.5),(1000056,28011,0.5),(1000056,28013,0.5),(1000056,28015,0.5),(1000056,28035,0.5),(1000056,28037,0.5),(1000056,28039,0.5),(1000056,28059,0.5),(1000056,28061,0.5),(1000056,28063,0.5),(1000056,28121,0.5),(1000056,28122,0.5),(1000056,28123,0.5),(1000056,28124,0.5),(1000056,28125,0.5),(1000056,28126,0.5),(1000056,28127,0.5),(1000056,28128,0.5),(1000056,28129,0.5),(1000056,28130,0.5),(1000056,28131,0.5),(1000056,28132,0.5),(1000056,28133,0.5),(1000056,28134,0.5),(1000056,28135,0.5),(1000056,28668,0.0448735703981621),(1000056,29000,0.0727142285193161),(1000056,29002,0.0727142285193161),(1000056,29004,0.0727142285193161),(1000056,29006,0.0727142285193161),(1000056,29008,0.0727142285193161),(1000056,29010,0.0727142285193161),(1000056,29012,0.0727142285193161),(1000056,29014,0.0727142285193161),(1000056,29016,0.0727142285193161),(1000057,41,-0.0218948696998572),(1000057,820,0.0353849764449482),(1000057,1212,1),(1000057,1946,1),(1000057,1951,0.0400669056715164),(1000057,3683,-0.0233929742264881),(1000057,9836,0.0201666246160067),(1000057,9848,0.0318918232736612),(1000057,11132,0.0271673799985549),(1000057,11133,0.0271673799985549),(1000057,11616,0.5),(1000057,11634,0.333333333333),(1000057,11820,0.333333),(1000057,11824,0.333333),(1000057,11828,0.333333),(1000057,11832,0.333333),(1000057,11836,0.333333),(1000057,11859,0.0834669184834421),(1000057,11860,0.0834669184834421),(1000057,11870,0.0834669184834421),(1000057,11872,0.0834669184834421),(1000057,11873,0.0834669184834421),(1000057,11876,1),(1000057,11887,0.0834669184834421),(1000057,11889,0.0834669184834421),(1000057,11890,0.0834669184834421),(1000057,11891,0.0834669184834421),(1000057,12092,0.125),(1000057,12095,0.124956590252653),(1000057,12275,0.112031431594498),(1000057,13321,0.113263098141238),(1000057,16591,0.125198574685448),(1000057,17322,0.333333),(1000057,17324,0.333333),(1000057,17325,0.333333),(1000057,17326,0.333333),(1000057,17333,0.333333),(1000057,17342,0.333333),(1000057,17346,0.333333),(1000057,17347,0.333333),(1000057,17355,0.333333),(1000057,17366,0.002388535031847),(1000057,17367,0.002388535031847),(1000057,17368,0.002388535031847),(1000057,19719,0.125198574685448),(1000057,21946,0.5),(1000057,21949,0.16839811750552),(1000057,21957,0.16839811750552),(1000057,21959,0.335196558394747),(1000057,21961,0.092383836102013),(1000057,21969,0.335196558394747),(1000057,24445,0.002388535031847),(1000057,25929,0.0834669184834421),(1000057,25931,0.0834669184834421),(1000057,25933,0.0834669184834421),(1000057,25935,0.0834669184834421),(1000057,25937,0.0834669184834421),(1000057,25949,0.0834669184834421),(1000057,25951,0.0834669184834421),(1000057,25953,0.0834669184834421),(1000057,25955,0.0834669184834421),(1000057,25957,0.0834669184834421),(1000057,26039,0.333333),(1000057,26041,0.333333),(1000057,26043,0.333333),(1000057,26047,0.333333),(1000057,26049,0.333333),(1000057,26057,0.333333),(1000057,26059,0.333333),(1000057,26061,0.333333),(1000057,26063,0.333333),(1000057,26067,0.333333),(1000057,26069,0.333333),(1000057,26071,0.333333),(1000057,26073,0.333333),(1000057,27309,0.002388535031847),(1000057,27941,0.5),(1000057,27971,0.5),(1000057,27973,0.5),(1000057,27979,0.5),(1000057,27981,0.5),(1000057,27985,0.5),(1000057,28011,0.5),(1000057,28013,0.5),(1000057,28015,0.5),(1000057,28035,0.5),(1000057,28037,0.5),(1000057,28039,0.5),(1000057,28059,0.5),(1000057,28061,0.5),(1000057,28063,0.5),(1000057,28121,0.5),(1000057,28122,0.5),(1000057,28123,0.5),(1000057,28124,0.5),(1000057,28125,0.5),(1000057,28126,0.5),(1000057,28127,0.5),(1000057,28128,0.5),(1000057,28129,0.5),(1000057,28130,0.5),(1000057,28131,0.5),(1000057,28132,0.5),(1000057,28133,0.5),(1000057,28134,0.5),(1000057,28135,0.5),(1000057,28668,0.0235586244590351),(1000058,3729,0.3663254843149),(1000058,3771,-0.0128320424966396),(1000058,11132,0.00820489409254179),(1000058,11133,0.00820489409254179),(1000058,17366,0.000398089171974),(1000058,17367,0.000398089171974),(1000058,17368,0.000398089171974),(1000058,22634,0.250062515628907),(1000058,24445,0.000398089171974),(1000058,24684,0.250062515628907),(1000058,25270,0.250062515628907),(1000058,25271,0.250062515628907),(1000058,25280,0.250062515628907),(1000058,25305,0.250062515628907),(1000058,25821,0.250062515628907),(1000058,27309,0.000398089171974),(1000059,41,-0.0191805371659526),(1000059,3691,0.0473366648316764),(1000059,3828,0.00629849486430725),(1000059,9826,-0.0126824749534843),(1000059,11132,0.0237994082132966),(1000059,11133,0.0237994082132966),(1000059,17366,0.002388535031847),(1000059,17367,0.002388535031847),(1000059,17368,0.002388535031847),(1000059,21949,0.165709938222576),(1000059,21957,0.165709938222576),(1000059,21959,0.329845735847924),(1000059,21961,0.0909090909090909),(1000059,21969,0.329845735847924),(1000059,24445,0.002388535031847),(1000059,27309,0.002388535031847),(1000060,3673,0.0396950524944175),(1000060,3715,-0.00200060706855816),(1000060,3725,0.00630609117377277),(1000060,9838,-0.00494596092125916),(1000060,11132,0.00441027236203847),(1000060,11133,0.00441027236203847),(1000060,17366,0.000597133757961),(1000060,17367,0.000597133757961),(1000060,17368,0.000597133757961),(1000060,24445,0.000597133757961),(1000060,27309,0.000597133757961),(1000061,489,0.995042204964894),(1000061,490,0.282232490313157),(1000061,496,0.995042204964894),(1000061,521,0.0972771917483072),(1000061,689,0.281836165926385),(1000061,786,0.054438224262925),(1000061,811,0.127600069402464),(1000061,812,0.071308901270851),(1000061,813,0.0703450680312319),(1000061,814,0.0753744433086945),(1000061,819,0.281836165926385),(1000061,820,0.271863399833745),(1000061,821,0.281836165926385),(1000061,824,0.995042204964894),(1000061,825,0.282232490313157),(1000061,831,0.995042204964894),(1000061,879,0.107270393531058),(1000061,880,0.281836165926385),(1000061,881,0.270079164684784),(1000061,882,0.281440953054161),(1000061,883,0.274137038614718),(1000061,884,0.270443091485779),(1000061,885,0.277548943146796),(1000061,886,0.274137038614718),(1000061,887,0.281836165926385),(1000061,891,0.281836165926385),(1000061,945,0.281440953054161),(1000061,946,0.990133326872832),(1000061,1067,0.168218931885396),(1000061,1072,0.102702385610511),(1000061,1099,0.169962951099273),(1000061,1202,0.0408164543797004),(1000061,1208,0.282629930910191),(1000061,1215,0.147557697360144),(1000061,1216,0.249124488010558),(1000061,1218,0.0408164543797004),(1000061,1220,0.209107481797135),(1000061,1221,0.209107481797135),(1000061,1811,0.939167788195532),(1000061,1815,0.155751210372726),(1000061,1817,0.249124488010558),(1000061,1876,0.139055997008372),(1000061,2047,0.0972771917483072),(1000061,2204,0.141070513302399),(1000061,2507,0.209107481797135),(1000061,2509,0.209107481797135),(1000061,2511,0.139107827569837),(1000061,2513,0.209107481797135),(1000061,2515,0.20792832521469),(1000061,2517,0.139107827569837),(1000061,3293,0.121280782278115),(1000061,3297,0.121280782278115),(1000061,3689,0.0947192942984414),(1000061,3715,-0.0946838652138282),(1000061,3767,0.990133326872832),(1000061,9850,0.142773073154138),(1000061,9852,-0.110094558469333),(1000061,10247,0.0408164543797004),(1000061,10630,0.276363314843065),(1000061,11132,0.208727461002362),(1000061,11133,0.208727461002362),(1000061,12053,0.168218931885396),(1000061,12055,0.168218931885396),(1000061,12057,0.102702385610511),(1000061,12067,0.102702385610511),(1000061,16214,0.5),(1000061,16631,1),(1000061,16688,1),(1000061,16689,1),(1000061,17178,1),(1000061,17181,1),(1000061,17182,1),(1000061,17366,0.017914012738853),(1000061,17367,0.017914012738853),(1000061,17368,0.017914012738853),(1000061,17770,1),(1000061,17771,1),(1000061,17772,1),(1000061,17858,0.209107481797135),(1000061,17860,0.209107481797135),(1000061,17862,0.209107481797135),(1000061,17864,0.209107481797135),(1000061,20065,0.5),(1000061,20066,0.5),(1000061,24445,0.017914012738853),(1000061,27309,0.017914012738853),(1000062,41,-0.0405400888619251),(1000062,3647,0.0231466626764605),(1000062,9836,-0.464399144287951),(1000062,9852,0.03820295886369),(1000062,11132,0.0503025601149973),(1000062,11133,0.0503025601149973),(1000062,17366,0.003980891719745),(1000062,17367,0.003980891719745),(1000062,17368,0.003980891719745),(1000062,24445,0.003980891719745),(1000062,27309,0.003980891719745),(1000063,456,0.627055397550709),(1000063,457,0.986957793278301),(1000063,462,0.986957793278301),(1000063,692,0.986957793278301),(1000063,786,0.0205257255605183),(1000063,834,0.108496572163103),(1000063,835,0.108496572163103),(1000063,836,0.108496572163103),(1000063,837,0.627055397550709),(1000063,838,0.627055397550709),(1000063,840,0.627055397550709),(1000063,841,0.986957793278301),(1000063,842,0.986957793278301),(1000063,843,0.63229475451292),(1000063,846,0.986957793278301),(1000063,847,0.986957793278301),(1000063,969,0.986957793278301),(1000063,970,0.986957793278301),(1000063,973,0.986957793278301),(1000063,1032,0.0153402156389839),(1000063,1079,0.0421249064108898),(1000063,1099,0.0640838847510936),(1000063,1204,0.986957793278301),(1000063,1265,0.333333333333),(1000063,1275,0.986957793278301),(1000063,1285,0.986957793278301),(1000063,1295,0.986957793278301),(1000063,1305,0.25),(1000063,2021,0.25),(1000063,2294,0.0486284060356826),(1000063,3243,0.053342846108663),(1000063,3529,0.124738940495466),(1000063,3685,-0.237750976439806),(1000063,3691,0.156532908728367),(1000063,3828,0.0208278662053298),(1000063,9826,-0.0419384149982425),(1000063,11134,0.0379604569142878),(1000063,11135,0.0379604569142878),(1000063,11218,0.250062515628907),(1000063,11228,0.250062515628907),(1000063,11238,0.250062515628907),(1000063,11248,0.250062515628907),(1000063,11258,0.25),(1000063,11562,0.0153402156389839),(1000063,17366,0.00796178343949),(1000063,17367,0.00796178343949),(1000063,17368,0.00796178343949),(1000063,17796,-1),(1000063,21949,0.161405783983028),(1000063,21951,0.163980414822882),(1000063,21957,0.161405783983028),(1000063,21961,0.0885478158205431),(1000063,22783,0.053342846108663),(1000063,24445,0.00796178343949),(1000063,27309,0.00796178343949),(1000063,27915,0.0133357115271657),(1000063,28655,0.053342846108663),(1000064,521,0.050811146422789),(1000064,834,0.150303612529545),(1000064,835,0.150303612529545),(1000064,836,0.150303612529545),(1000064,936,1),(1000064,937,0.990551213594135),(1000064,938,1),(1000064,944,1),(1000064,1010,0.0297810500955728),(1000064,1026,0.0366109295507036),(1000064,1099,0.0887773612657232),(1000064,1100,0.2),(1000064,1128,0.146155416321214),(1000064,1154,0.168595664173984),(1000064,1155,0.168595664173984),(1000064,1156,0.168595664173984),(1000064,1157,0.168595664173984),(1000064,1158,0.168595664173984),(1000064,1160,0.107959119447276),(1000064,1165,0.168595664173984),(1000064,1173,0.168595664173984),(1000064,1178,0.102781631596466),(1000064,1179,0.102781631596466),(1000064,1193,0.302552091792972),(1000064,1196,0.5),(1000064,1262,0.199201161706567),(1000064,1265,0.333333333333),(1000064,1272,0.487347664432379),(1000064,1282,0.417473135199971),(1000064,1292,0.184957837349426),(1000064,1302,0.252008012304236),(1000064,1305,0.25),(1000064,1548,0.5),(1000064,1552,0.150458236438732),(1000064,1564,0.146056192885076),(1000064,2021,0.25),(1000064,2047,0.050811146422789),(1000064,2162,0.981279314942747),(1000064,3469,0.136406174687361),(1000064,3553,0.146155416321214),(1000064,3555,0.146155416321214),(1000064,3567,0.0412209040961109),(1000064,3577,0.146155416321214),(1000064,3729,-0.665976915539421),(1000064,3773,-0.242481203689043),(1000064,9840,0.192515641162764),(1000064,9848,0.127985022996725),(1000064,11134,0.0525877794453486),(1000064,11135,0.0525877794453486),(1000064,11218,0.250062515628907),(1000064,11228,0.250062515628907),(1000064,11238,0.250062515628907),(1000064,11248,0.250062515628907),(1000064,11258,0.25),(1000064,11268,0.333333333333333),(1000064,11280,0.250062515628907),(1000064,11284,0.146155416321214),(1000064,11286,0.146155416321214),(1000064,11288,0.146155416321214),(1000064,11290,0.146155416321214),(1000064,11292,0.250062515628907),(1000064,11294,0.250062515628907),(1000064,11296,0.250062515628907),(1000064,11298,0.250062515628907),(1000064,11300,0.250062515628907),(1000064,11356,0.5),(1000064,11358,0.5),(1000064,11360,0.5),(1000064,11564,0.17495883628175),(1000064,11585,0.126345347332679),(1000064,11612,0.333333),(1000064,11619,0.25),(1000064,11625,0.333333),(1000064,11859,0.0833345334533026),(1000064,11860,0.0833345334533026),(1000064,11870,0.0833345334533026),(1000064,11872,0.0833345334533026),(1000064,11873,0.0833345334533026),(1000064,11880,1),(1000064,11887,0.0833345334533026),(1000064,11889,0.0833345334533026),(1000064,11890,0.0833345334533026),(1000064,11891,0.0833345334533026),(1000064,12092,0.125),(1000064,12095,0.124969308325265),(1000064,12096,0.250062515628907),(1000064,12218,0.5),(1000064,12220,0.5),(1000064,12226,0.5),(1000064,12235,0.5),(1000064,16694,1),(1000064,17167,1),(1000064,17168,1),(1000064,17330,0.333333),(1000064,17334,0.333333),(1000064,17335,0.333333),(1000064,17336,0.333333),(1000064,17338,0.333333),(1000064,17348,0.333333),(1000064,17349,0.333333),(1000064,17350,0.333333),(1000064,17359,0.333333),(1000064,17366,0.011942675159235),(1000064,17367,0.011942675159235),(1000064,17368,0.011942675159235),(1000064,17406,1),(1000064,17407,1),(1000064,17408,1),(1000064,19719,0.124979922311364),(1000064,20059,0.5),(1000064,20060,0.5),(1000064,21943,0.333333),(1000064,21949,0.168104019523364),(1000064,21951,0.170785495876243),(1000064,21957,0.168104019523364),(1000064,21961,0.0922224928507705),(1000064,24445,0.011942675159235),(1000064,24570,0.5),(1000064,25737,0.333333),(1000064,25889,0.333333),(1000064,25891,0.333333),(1000064,25893,0.333333),(1000064,25895,0.333333),(1000064,25897,0.333333),(1000064,25899,0.333333),(1000064,25901,0.333333),(1000064,25903,0.333333),(1000064,25929,0.0833345334533026),(1000064,25931,0.0833345334533026),(1000064,25933,0.0833345334533026),(1000064,25935,0.0833345334533026),(1000064,25937,0.0833345334533026),(1000064,25949,0.0833345334533026),(1000064,25951,0.0833345334533026),(1000064,25953,0.0833345334533026),(1000064,25955,0.0833345334533026),(1000064,25957,0.0833345334533026),(1000064,25969,0.333333),(1000064,25971,0.333333),(1000064,25973,0.333333),(1000064,25975,0.333333),(1000064,25977,0.333333),(1000064,25979,0.333333),(1000064,25981,0.333333),(1000064,27309,0.011942675159235),(1000064,27662,0.333333),(1000064,27664,0.333333),(1000064,27666,0.333333),(1000064,27905,0.5),(1000064,27931,0.5),(1000064,27933,0.5),(1000064,27935,0.5),(1000064,27961,0.333333),(1000064,27963,0.333333),(1000064,27965,0.333333),(1000064,27987,0.333333),(1000064,27989,0.333333),(1000064,27991,0.333333),(1000064,28017,0.333333),(1000064,28019,0.333333),(1000064,28021,0.333333),(1000064,28041,0.333333),(1000064,28043,0.333333),(1000064,28045,0.333333),(1000064,28080,0.333333),(1000064,28081,0.333333),(1000064,28082,0.333333),(1000064,28083,0.333333),(1000064,28084,0.333333),(1000064,28085,0.333333),(1000064,28086,0.333333),(1000064,28087,0.333333),(1000064,28088,0.333333),(1000064,28089,0.333333),(1000064,28090,0.333333),(1000064,28668,0.0257716491102047),(1000064,29000,0.0149638129071673),(1000064,29002,0.0149638129071673),(1000064,29004,0.0149638129071673),(1000064,29006,0.0149638129071673),(1000064,29008,0.0149638129071673),(1000064,29010,0.0149638129071673),(1000064,29012,0.0149638129071673),(1000064,29014,0.0149638129071673),(1000064,29016,0.0149638129071673),(1000065,41,0.273338384870799),(1000065,834,0.662333552153498),(1000065,835,0.662333552153498),(1000065,836,0.662333552153498),(1000065,1128,0.644053954720977),(1000065,1154,0.742939994925823),(1000065,1155,0.742939994925823),(1000065,1156,0.742939994925823),(1000065,1157,0.742939994925823),(1000065,1158,0.742939994925823),(1000065,1160,0.475736716286992),(1000065,1165,0.742939994925823),(1000065,1173,0.742939994925823),(1000065,1178,0.452921403589273),(1000065,1179,0.452921403589273),(1000065,1265,0.333333333333),(1000065,1292,0.815042162650574),(1000065,1305,0.25),(1000065,3553,0.644053954720977),(1000065,3555,0.644053954720977),(1000065,3567,0.181645586379962),(1000065,3577,0.644053954720977),(1000065,3689,0.218018707046715),(1000065,3828,-0.350365510361005),(1000065,9852,-0.253408489454485),(1000065,11134,0.231735286821904),(1000065,11135,0.231735286821904),(1000065,11218,0.249812453113278),(1000065,11228,0.249812453113278),(1000065,11238,0.249812453113278),(1000065,11248,0.249812453113278),(1000065,11258,0.25),(1000065,11268,0.333333333333333),(1000065,11278,0.92398690388898),(1000065,11280,0.250062515628907),(1000065,11284,0.644053954720977),(1000065,11286,0.644053954720977),(1000065,11288,0.644053954720977),(1000065,11290,0.644053954720977),(1000065,11292,0.250062515628907),(1000065,11294,0.250062515628907),(1000065,11296,0.250062515628907),(1000065,11298,0.250062515628907),(1000065,11300,0.250062515628907),(1000065,11302,0.92398690388898),(1000065,11304,0.92398690388898),(1000065,11306,0.92398690388898),(1000065,11564,0.7709801884659),(1000065,17366,0.011942675159235),(1000065,17367,0.011942675159235),(1000065,17368,0.011942675159235),(1000065,24445,0.011942675159235),(1000065,27309,0.011942675159235),(1000066,1282,0.143377170615544),(1000066,1537,1),(1000066,1804,1),(1000066,3645,0.0156426495456714),(1000066,9832,0.0290175673082681),(1000066,9842,0.326177359976121),(1000066,9846,-0.0494646997092882),(1000066,11134,0.0180607717960503),(1000066,11135,0.0180607717960503),(1000066,11217,1),(1000066,11227,1),(1000066,11237,1),(1000066,11247,1),(1000066,11257,1),(1000066,11267,1),(1000066,11278,0.0720128420774479),(1000066,11302,0.0720128420774479),(1000066,11304,0.0720128420774479),(1000066,11306,0.0720128420774479),(1000066,11859,0.0833211481347803),(1000066,11860,0.0833211481347803),(1000066,11870,0.0833211481347803),(1000066,11872,0.0833211481347803),(1000066,11873,0.0833211481347803),(1000066,11884,1),(1000066,11887,0.0833211481347803),(1000066,11889,0.0833211481347803),(1000066,11890,0.0833211481347803),(1000066,11891,0.0833211481347803),(1000066,16591,0.124979922311364),(1000066,17330,0.333333),(1000066,17334,0.333333),(1000066,17335,0.333333),(1000066,17336,0.333333),(1000066,17338,0.333333),(1000066,17348,0.333333),(1000066,17349,0.333333),(1000066,17350,0.333333),(1000066,17359,0.333333),(1000066,17366,0.002388535031847),(1000066,17367,0.002388535031847),(1000066,17368,0.002388535031847),(1000066,17941,0.25),(1000066,17942,0.25),(1000066,17943,0.25),(1000066,17944,0.25),(1000066,17945,0.25),(1000066,17946,0.25),(1000066,17947,0.25),(1000066,17948,0.25),(1000066,17949,0.25),(1000066,17950,0.25),(1000066,17951,0.25),(1000066,17952,0.25),(1000066,17953,0.25),(1000066,17954,0.25),(1000066,17955,0.25),(1000066,17956,0.25),(1000066,17957,0.25),(1000066,17958,0.25),(1000066,17961,0.25),(1000066,17962,0.25),(1000066,17963,0.25),(1000066,17964,0.25),(1000066,17965,0.25),(1000066,17966,0.25),(1000066,17967,0.25),(1000066,17968,0.25),(1000066,17969,0.25),(1000066,17970,0.25),(1000066,17971,0.25),(1000066,17972,0.25),(1000066,19719,0.124979922311364),(1000066,21943,0.333333),(1000066,21949,0.168104019523364),(1000066,21951,0.170785495876243),(1000066,21957,0.168104019523364),(1000066,21961,0.0922224928507705),(1000066,24445,0.002388535031847),(1000066,25737,0.333333),(1000066,25889,0.333333),(1000066,25891,0.333333),(1000066,25893,0.333333),(1000066,25895,0.333333),(1000066,25897,0.333333),(1000066,25899,0.333333),(1000066,25901,0.333333),(1000066,25903,0.333333),(1000066,25929,0.0833211481347803),(1000066,25931,0.0833211481347803),(1000066,25933,0.0833211481347803),(1000066,25935,0.0833211481347803),(1000066,25937,0.0833211481347803),(1000066,25949,0.0833211481347803),(1000066,25951,0.0833211481347803),(1000066,25953,0.0833211481347803),(1000066,25955,0.0833211481347803),(1000066,25957,0.0833211481347803),(1000066,25969,0.333333),(1000066,25971,0.333333),(1000066,25973,0.333333),(1000066,25975,0.333333),(1000066,25977,0.333333),(1000066,25979,0.333333),(1000066,25981,0.333333),(1000066,27309,0.002388535031847),(1000066,27662,0.333333),(1000066,27664,0.333333),(1000066,27666,0.333333),(1000066,27672,1),(1000066,27961,0.333333),(1000066,27963,0.333333),(1000066,27965,0.333333),(1000066,27987,0.333333),(1000066,27989,0.333333),(1000066,27991,0.333333),(1000066,28017,0.333333),(1000066,28019,0.333333),(1000066,28021,0.333333),(1000066,28041,0.333333),(1000066,28043,0.333333),(1000066,28045,0.333333),(1000066,28080,0.333333),(1000066,28081,0.333333),(1000066,28082,0.333333),(1000066,28083,0.333333),(1000066,28084,0.333333),(1000066,28085,0.333333),(1000066,28086,0.333333),(1000066,28087,0.333333),(1000066,28088,0.333333),(1000066,28089,0.333333),(1000066,28090,0.333333),(1000066,28668,0.0135301157828574),(1000067,1074,0.192206120333244),(1000067,1099,0.0999989622670172),(1000067,1128,0.164629695605384),(1000067,1130,0.017890726109142),(1000067,1131,0.0275810878636681),(1000067,1132,0.0275168168098592),(1000067,1178,0.115773394852251),(1000067,1179,0.115773394852251),(1000067,1193,0.340795161960889),(1000067,1242,0.89875381676799),(1000067,1245,0.166666),(1000067,1318,0.166666),(1000067,1334,0.166666),(1000067,1404,0.166666),(1000067,2604,0.166666),(1000067,3553,0.164629695605384),(1000067,3555,0.164629695605384),(1000067,3567,0.0464312925564599),(1000067,3577,0.164629695605384),(1000067,3685,0.448840765665317),(1000067,3717,-0.159716832787269),(1000067,9836,0.0911604115567739),(1000067,9848,-0.0578546405981132),(1000067,11134,0.0592349592000322),(1000067,11135,0.0592349592000322),(1000067,11284,0.164629695605384),(1000067,11286,0.164629695605384),(1000067,11288,0.164629695605384),(1000067,11290,0.164629695605384),(1000067,17366,0.00796178343949),(1000067,17367,0.00796178343949),(1000067,17368,0.00796178343949),(1000067,24445,0.00796178343949),(1000067,27309,0.00796178343949),(1000068,521,0.00927202028843007),(1000068,1026,0.00668076407384818),(1000068,1240,0.147828547477632),(1000068,1245,0.166666),(1000068,1318,0.166666),(1000068,1334,0.166666),(1000068,1404,0.166666),(1000068,2047,0.00927202028843007),(1000068,2604,0.166666),(1000068,3687,-0.00536540096288889),(1000068,3689,0.00902821311611527),(1000068,9836,0.0147682282463376),(1000068,9838,-0.0223114712288161),(1000068,11134,0.00959622036242957),(1000068,11135,0.00959622036242957),(1000068,11585,0.0230555046735164),(1000068,17366,0.002388535031847),(1000068,17367,0.002388535031847),(1000068,17368,0.002388535031847),(1000068,24445,0.002388535031847),(1000068,27309,0.002388535031847),(1000069,785,0.0759936258886076),(1000069,3643,0.162188369042187),(1000069,3683,-0.217500293505581),(1000069,9826,0.103967776236261),(1000069,9850,-0.139318223498766),(1000069,11134,0.121837067059703),(1000069,11135,0.121837067059703),(1000069,12109,0.0759936258886076),(1000069,12237,0.150075025319064),(1000069,12238,0.130508539083988),(1000069,12239,0.130508539083988),(1000069,13780,0.150075025319064),(1000069,14343,0.130508539083988),(1000069,16216,0.150075025319064),(1000069,16220,0.150075025319064),(1000069,16221,0.150075025319064),(1000069,16279,0.150075025319064),(1000069,16869,0.150075025319064),(1000069,17366,0.008957006369426),(1000069,17367,0.008957006369426),(1000069,17368,0.008957006369426),(1000069,17482,0.150075025319064),(1000069,17483,0.150075025319064),(1000069,17621,0.150075025319064),(1000069,17982,0.150075025319064),(1000069,18037,0.0759936258886076),(1000069,18039,0.0759936258886076),(1000069,18041,0.0759936258886076),(1000069,18043,0.0759936258886076),(1000069,18045,0.0759936258886076),(1000069,18047,0.0759936258886076),(1000069,18049,0.0759936258886076),(1000069,18051,0.0759936258886076),(1000069,18053,0.0759936258886076),(1000069,18055,0.0759936258886076),(1000069,18057,0.0759936258886076),(1000069,18059,0.0759936258886076),(1000069,18061,0.0759936258886076),(1000069,18063,0.0759936258886076),(1000069,18065,0.0759936258886076),(1000069,18067,0.0759936258886076),(1000069,18626,0.150075025319064),(1000069,18635,0.150075025319064),(1000069,18637,0.150075025319064),(1000069,19470,0.130508539083988),(1000069,20175,0.150075025319064),(1000069,22543,0.150075025319064),(1000069,22577,0.150075025319064),(1000069,24445,0.008957006369426),(1000069,24574,0.150075025319064),(1000069,24575,0.150075025319064),(1000069,24646,0.150075025319064),(1000069,24653,0.150075025319064),(1000069,24654,0.150075025319064),(1000069,24655,0.150075025319064),(1000069,24656,0.150075025319064),(1000069,24657,0.150075025319064),(1000069,24658,0.150075025319064),(1000069,24659,0.150075025319064),(1000069,24660,0.150075025319064),(1000069,27309,0.008957006369426),(1000069,27656,0.214392891589286),(1000069,27658,0.214392891589286),(1000069,27660,0.214392891589286),(1000069,27673,0.150075025319064),(1000069,27674,0.150075025319064),(1000069,27675,0.150075025319064),(1000069,27897,0.150075025319064),(1000069,28351,0.150075025319064),(1000069,28368,0.150075025319064),(1000069,28386,0.150075025319064),(1000069,28448,0.150075025319064),(1000069,28449,0.150075025319064),(1000069,28450,0.150075025319064),(1000069,28451,0.150075025319064),(1000069,28452,0.150075025319064),(1000069,28453,0.150075025319064),(1000069,28454,0.150075025319064),(1000069,28455,0.150075025319064),(1000069,28456,0.150075025319064),(1000069,28457,0.150075025319064),(1000069,28458,0.150075025319064),(1000069,28459,0.150075025319064),(1000069,28460,0.150075025319064),(1000069,28461,0.150075025319064),(1000069,28462,0.150075025319064),(1000069,28463,0.150075025319064),(1000069,28464,0.150075025319064),(1000069,28465,0.150075025319064),(1000069,28466,0.150075025319064),(1000069,28467,0.150075025319064),(1000069,28468,0.150075025319064),(1000069,28469,0.150075025319064),(1000069,28470,0.150075025319064),(1000069,28471,0.150075025319064),(1000069,28472,0.150075025319064),(1000069,28473,0.150075025319064),(1000069,28474,0.150075025319064),(1000069,28475,0.150075025319064),(1000069,28476,0.150075025319064),(1000069,28477,0.150075025319064),(1000069,28478,0.150075025319064),(1000069,28479,0.150075025319064),(1000069,28480,0.150075025319064),(1000069,28481,0.150075025319064),(1000069,28482,0.150075025319064),(1000069,28483,0.150075025319064),(1000069,28484,0.150075025319064),(1000069,28485,0.150075025319064),(1000069,28486,0.150075025319064),(1000069,28487,0.150075025319064),(1000069,28488,0.150075025319064),(1000069,28489,0.150075025319064),(1000069,28490,0.150075025319064),(1000069,28491,0.150075025319064),(1000069,28492,0.150075025319064),(1000069,28493,0.150075025319064),(1000069,28494,0.150075025319064),(1000069,28495,0.150075025319064),(1000069,28496,0.150075025319064),(1000069,28497,0.150075025319064),(1000069,28498,0.150075025319064),(1000069,28499,0.150075025319064),(1000069,28500,0.150075025319064),(1000069,28501,0.150075025319064),(1000069,28502,0.150075025319064),(1000069,28503,0.150075025319064),(1000069,28504,0.150075025319064),(1000069,28505,0.150075025319064),(1000070,785,0.0105671055990769),(1000070,3691,-0.0250703899179511),(1000070,3773,0.100453885714473),(1000070,9828,0.0153868611861434),(1000070,9848,-0.0165469678509908),(1000070,11134,0.0169417518699382),(1000070,11135,0.0169417518699382),(1000070,12109,0.0105671055990769),(1000070,17366,0.002388535031847),(1000070,17367,0.002388535031847),(1000070,17368,0.002388535031847),(1000070,18037,0.0105671055990769),(1000070,18039,0.0105671055990769),(1000070,18041,0.0105671055990769),(1000070,18043,0.0105671055990769),(1000070,18045,0.0105671055990769),(1000070,18047,0.0105671055990769),(1000070,18049,0.0105671055990769),(1000070,18051,0.0105671055990769),(1000070,18053,0.0105671055990769),(1000070,18055,0.0105671055990769),(1000070,18057,0.0105671055990769),(1000070,18059,0.0105671055990769),(1000070,18061,0.0105671055990769),(1000070,18063,0.0105671055990769),(1000070,18065,0.0105671055990769),(1000070,18067,0.0105671055990769),(1000070,24445,0.002388535031847),(1000070,27309,0.002388535031847),(1000071,45,-0.650383790517561),(1000071,3689,0.0287362857813803),(1000071,3771,-0.0990363395736552),(1000071,9828,0.0277409138158893),(1000071,11134,0.0305442203467316),(1000071,11135,0.0305442203467316),(1000071,17366,0.003980891719745),(1000071,17367,0.003980891719745),(1000071,17368,0.003980891719745),(1000071,22634,0.250062515628907),(1000071,24445,0.003980891719745),(1000071,24684,0.250062515628907),(1000071,25270,0.250062515628907),(1000071,25271,0.250062515628907),(1000071,25280,0.250062515628907),(1000071,25305,0.250062515628907),(1000071,25821,0.250062515628907),(1000071,27309,0.003980891719745),(1000072,455,0.977781533381237),(1000072,456,0.364658345249123),(1000072,518,0.0475610819401894),(1000072,811,0.0279785835791083),(1000072,813,0.0154244066990443),(1000072,814,0.0165271866364701),(1000072,834,0.0630951916285827),(1000072,835,0.0630951916285827),(1000072,836,0.0630951916285827),(1000072,837,0.364658345249123),(1000072,838,0.364658345249123),(1000072,839,0.977781533381237),(1000072,840,0.364658345249123),(1000072,843,0.36770524548708),(1000072,1072,0.0225193237984398),(1000072,1099,0.0372673984814548),(1000072,1100,0.2),(1000072,1105,0.0191825297177265),(1000072,1113,0.0548651013571102),(1000072,1114,0.0548651013571102),(1000072,1154,0.0707739192676735),(1000072,1155,0.0707739192676735),(1000072,1156,0.0707739192676735),(1000072,1157,0.0707739192676735),(1000072,1158,0.0707739192676735),(1000072,1160,0.0453196115179199),(1000072,1165,0.0707739192676735),(1000072,1173,0.0707739192676735),(1000072,2021,0.25),(1000072,3469,0.0572612566416474),(1000072,3529,0.0725407927383753),(1000072,3643,0.0293867763896809),(1000072,3654,0.285236528901012),(1000072,3664,0.497666606756614),(1000072,3691,-0.0326673909044005),(1000072,3693,0.11811041740156),(1000072,3697,-0.0233297289761446),(1000072,11134,0.0220755573707431),(1000072,11135,0.0220755573707431),(1000072,11612,0.333333),(1000072,11619,0.25),(1000072,12057,0.0225193237984398),(1000072,12067,0.0225193237984398),(1000072,17366,0.011942675159235),(1000072,17367,0.011942675159235),(1000072,17368,0.011942675159235),(1000072,24445,0.011942675159235),(1000072,27309,0.011942675159235),(1000073,43,-0.0377639425638761),(1000073,3647,0.0193095061617526),(1000073,3812,0.0262653658607347),(1000073,3814,-0.113823525717685),(1000073,11134,0.0202409152503792),(1000073,11135,0.0202409152503792),(1000073,11585,0.0486300333387945),(1000073,17366,0.003980891719745),(1000073,17367,0.003980891719745),(1000073,17368,0.003980891719745),(1000073,24445,0.003980891719745),(1000073,27309,0.003980891719745),(1000074,785,0.0782437028954078),(1000074,1202,0.0508569225788371),(1000074,1218,0.0508569225788371),(1000074,3293,0.151114726851102),(1000074,3297,0.151114726851102),(1000074,3643,0.166990565485441),(1000074,3645,-0.167654100961288),(1000074,3651,0.202618042289291),(1000074,3683,-0.223940207428185),(1000074,3725,0.371868357897161),(1000074,10247,0.0508569225788371),(1000074,10630,0.344346120215543),(1000074,11134,0.125444511499436),(1000074,11135,0.125444511499436),(1000074,11585,0.30138808946755),(1000074,12109,0.0782437028954078),(1000074,17366,0.017914012738853),(1000074,17367,0.017914012738853),(1000074,17368,0.017914012738853),(1000074,18037,0.0782437028954078),(1000074,18039,0.0782437028954078),(1000074,18041,0.0782437028954078),(1000074,18043,0.0782437028954078),(1000074,18045,0.0782437028954078),(1000074,18047,0.0782437028954078),(1000074,18049,0.0782437028954078),(1000074,18051,0.0782437028954078),(1000074,18053,0.0782437028954078),(1000074,18055,0.0782437028954078),(1000074,18057,0.0782437028954078),(1000074,18059,0.0782437028954078),(1000074,18061,0.0782437028954078),(1000074,18063,0.0782437028954078),(1000074,18065,0.0782437028954078),(1000074,18067,0.0782437028954078),(1000074,24445,0.017914012738853),(1000074,27309,0.017914012738853),(1000075,3645,-0.248961337140708),(1000075,3715,0.163143339279512),(1000075,3725,0.552213414951145),(1000075,9826,-0.205802181081997),(1000075,11134,0.186281356321096),(1000075,11135,0.186281356321096),(1000075,11585,0.447552319459519),(1000075,17366,0.011942675159235),(1000075,17367,0.011942675159235),(1000075,17368,0.011942675159235),(1000075,24445,0.011942675159235),(1000075,27309,0.011942675159235),(1000076,3673,0.0591306736293591),(1000076,3717,0.613118700142377),(1000076,3723,-1),(1000076,3725,-0.00404268923934494),(1000076,11134,0.00316883138005973),(1000076,11135,0.00316883138005973),(1000076,17366,0.000597133757961),(1000076,17367,0.000597133757961),(1000076,17368,0.000597133757961),(1000076,24445,0.000597133757961),(1000076,27309,0.000597133757961),(1000077,786,0.00271238301877068),(1000077,811,0.0063576699300406),(1000077,1032,0.00202714102752574),(1000077,1099,0.00846839933931841),(1000077,1106,0.015880593223648),(1000077,1202,0.0020336787109591),(1000077,1218,0.0020336787109591),(1000077,3300,0.0140463431166794),(1000077,3301,0.0140463431166794),(1000077,3302,0.0833333333333333),(1000077,3303,0.0833333333333333),(1000077,3304,0.0833333333333333),(1000077,3305,0.0833333333333333),(1000077,3306,0.0833333333333333),(1000077,3307,0.0833333333333333),(1000077,3308,0.0833333333333333),(1000077,3309,0.0833333333333333),(1000077,3310,0.0833333333333333),(1000077,3311,0.0140463431166794),(1000077,3312,0.0833333333333333),(1000077,3315,0.0833333333333333),(1000077,3316,0.0833333333333333),(1000077,3317,0.0833333333333333),(1000077,3318,0.0833333333333333),(1000077,3319,0.0833333333333333),(1000077,3320,0.0833333333333333),(1000077,3321,0.0833333333333333),(1000077,3322,0.0833333333333333),(1000077,3323,0.0833333333333333),(1000077,3324,0.0833333333333333),(1000077,3325,0.0833333333333333),(1000077,3326,0.0833333333333333),(1000077,3327,0.0833333333333333),(1000077,3328,0.0140463431166794),(1000077,3329,0.0833333333333333),(1000077,3330,0.0833333333333333),(1000077,3331,0.0833333333333333),(1000077,3332,0.0833333333333333),(1000077,3333,0.0833333333333333),(1000077,3334,0.0833333333333333),(1000077,3335,0.0833333333333333),(1000077,3336,0.0833333333333333),(1000077,3337,0.0833333333333333),(1000077,3338,0.0833333333333333),(1000077,3339,0.0833333333333333),(1000077,3340,0.0833333333333333),(1000077,3341,0.0833333333333333),(1000077,3342,0.0833333333333333),(1000077,3343,0.0833333333333333),(1000077,3344,0.0833333333333333),(1000077,3345,0.0833333333333333),(1000077,3346,0.0833333333333333),(1000077,3347,0.0833333333333333),(1000077,3348,0.0833333333333333),(1000077,3349,0.083333333333),(1000077,3350,0.083333333333),(1000077,3351,0.0833333333333333),(1000077,3352,0.0833333333333333),(1000077,3354,0.0833333333333333),(1000077,3355,0.0833333333333333),(1000077,3356,0.0086413667660438),(1000077,3357,0.066223598680128),(1000077,3358,0.0086413667660438),(1000077,3359,0.0086413667660438),(1000077,3361,0.0833333333333333),(1000077,3363,0.0833333333333333),(1000077,3368,0.0833333333333333),(1000077,3373,0.0833333333333333),(1000077,3374,0.0176898701327485),(1000077,3375,0.0833333333333333),(1000077,3376,0.0833333333333333),(1000077,3377,0.0833333333333333),(1000077,3378,0.0833333333333333),(1000077,3379,0.0833333333333333),(1000077,3380,0.0833333333333333),(1000077,3385,0.0833333333333333),(1000077,3386,0.0769426043712937),(1000077,3387,0.0833333333333333),(1000077,3388,0.0833333333333333),(1000077,3389,0.0833333333333333),(1000077,3392,0.0833333333333333),(1000077,3393,0.0833333333333333),(1000077,3394,0.0833333333333333),(1000077,3395,0.083333),(1000077,3396,0.0833213375908805),(1000077,3397,0.0833213375908805),(1000077,3398,0.0833213375908805),(1000077,3400,0.0833333333333333),(1000077,3402,0.0833333333333333),(1000077,3403,0.0833333333333333),(1000077,3405,0.0833333333333333),(1000077,3406,0.0833333333333333),(1000077,3409,0.0833333333333333),(1000077,3410,0.0833333333333333),(1000077,3411,0.0833333333333333),(1000077,3412,0.0833333333333333),(1000077,3413,0.0140463431166794),(1000077,3416,0.0140463431166794),(1000077,3417,0.0833333333333333),(1000077,3418,0.0833333333333333),(1000077,3419,0.0833333333333333),(1000077,3420,0.0833333333333333),(1000077,3421,0.0833333333333333),(1000077,3422,0.0833333333333333),(1000077,3423,0.0833333333333333),(1000077,3424,0.0833333333333333),(1000077,3425,0.0833333333333333),(1000077,3426,0.0140463431166794),(1000077,3427,0.0833333333333333),(1000077,3428,0.0833333333333333),(1000077,3429,0.0833333333333333),(1000077,3430,0.0833213375908805),(1000077,3431,0.0833333333333333),(1000077,3432,0.0833333333333333),(1000077,3433,0.0833333333333333),(1000077,3434,0.0833333333333333),(1000077,3435,0.0833333333333333),(1000077,3436,0.0140463431166794),(1000077,3437,0.0833333333333333),(1000077,3438,0.0833333333333333),(1000077,3439,0.0833333333333333),(1000077,3441,0.0833333333333333),(1000077,3442,0.0833333333333333),(1000077,3443,0.0833213375908805),(1000077,3444,0.0833213375908805),(1000077,3446,0.0833213375908805),(1000077,3447,0.0833213375908805),(1000077,3449,0.0140463431166794),(1000077,3450,0.0833333333333333),(1000077,3451,0.0833333333333333),(1000077,3452,0.0833333333333333),(1000077,3453,0.0833333333333333),(1000077,3454,0.0833333333333333),(1000077,3455,0.0140463431166794),(1000077,3456,0.0833333333333333),(1000077,3551,0.0833333333333333),(1000077,3647,-0.00936805232225887),(1000077,3689,0.00471938621958334),(1000077,3695,-0.00742993331852756),(1000077,3731,0.0833333333333333),(1000077,3732,0.0833333333333333),(1000077,9826,0.00428058622139743),(1000077,10039,0.0833333333333333),(1000077,10040,0.0833333333333333),(1000077,10247,0.0020336787109591),(1000077,11083,0.333333333333333),(1000077,11134,0.00501630494939203),(1000077,11135,0.00501630494939203),(1000077,11207,0.0833333333333333),(1000077,11395,0.0086413667660438),(1000077,11433,0.0833333333333333),(1000077,11441,0.0833333333333333),(1000077,11442,0.0833333333333333),(1000077,11443,0.0833333333333333),(1000077,11444,0.0833333333333333),(1000077,11445,0.0833333333333333),(1000077,11446,0.0833333333333333),(1000077,11447,0.0833333333333333),(1000077,11448,0.0833333333333333),(1000077,11449,0.0833333333333333),(1000077,11450,0.0833333333333333),(1000077,11451,0.0833333333333333),(1000077,11452,0.0833333333333333),(1000077,11453,0.0833333333333333),(1000077,11454,0.0833333333333333),(1000077,11455,0.0833333333333333),(1000077,11487,0.0833333333333333),(1000077,11529,0.0833333333333333),(1000077,11562,0.00202714102752574),(1000077,11566,0.0833333333333333),(1000077,11569,0.0833333333333333),(1000077,11572,0.0833333333333333),(1000077,11574,0.0833333333333333),(1000077,11579,0.0883273199177677),(1000077,11584,0.0833333333333333),(1000077,11585,0.0120519785745323),(1000077,12093,0.0635764228632056),(1000077,12097,0.0833333333333333),(1000077,12098,0.0833333333333333),(1000077,12099,0.0833333333333333),(1000077,12179,0.0833333333333333),(1000077,12196,0.0534527440768111),(1000077,12204,0.333333333333333),(1000077,12205,0.332955341958079),(1000077,12213,0.333333333333333),(1000077,12214,0.333333333333333),(1000077,12215,0.333333333333333),(1000077,12241,0.0833333333333333),(1000077,12258,0.333333),(1000077,12262,0.333333),(1000077,12305,0.0833333333333333),(1000077,12365,0.0833333333333333),(1000077,12366,0.0833333333333333),(1000077,12367,0.0833333333333333),(1000077,12376,0.0833213375908805),(1000077,12383,0.0833213375908805),(1000077,12385,0.0833213375908805),(1000077,12386,0.0833213375908805),(1000077,12387,0.0833213375908805),(1000077,12484,0.332955341958079),(1000077,13278,0.0833333333333333),(1000077,16069,0.0833213375908805),(1000077,16281,0.0140463431166794),(1000077,16594,0.0833213375908805),(1000077,16595,0.0833213375908805),(1000077,16596,0.0833213375908805),(1000077,16597,0.0833213375908805),(1000077,16598,0.0833213375908805),(1000077,16622,0.0833213375908805),(1000077,17366,0.001990445859872),(1000077,17367,0.001990445859872),(1000077,17368,0.001990445859872),(1000077,17940,0.0833333333333333),(1000077,18580,0.0833213375908805),(1000077,19400,-0.0711025228999906),(1000077,19759,0.0833333333333333),(1000077,19760,0.0833333333333333),(1000077,19761,0.0833333333333333),(1000077,19766,0.0833333333333333),(1000077,19767,0.0833333333333333),(1000077,19921,0.0833333333333333),(1000077,19922,0.0833333333333333),(1000077,20327,0.332955341958079),(1000077,20342,0.0833333333333333),(1000077,20494,0.0833333333333333),(1000077,20495,0.0833333333333333),(1000077,20524,0.332955341958079),(1000077,20525,0.332955341958079),(1000077,20533,0.0833333333333333),(1000077,21059,0.0833333333333333),(1000077,21603,0.0833333333333333),(1000077,21610,0.0833333333333333),(1000077,21611,0.0833333333333333),(1000077,21718,0.0833333333333333),(1000077,21803,0.0833333333333333),(1000077,21853,0.0833333333333333),(1000077,21855,0.0833333333333333),(1000077,21857,0.0833333333333333),(1000077,22043,0.0833333333333333),(1000077,22176,0.0833333333333333),(1000077,22178,0.0833333333333333),(1000077,22242,0.0833333333333333),(1000077,22551,0.0833333333333333),(1000077,22578,0.0769426043712937),(1000077,22761,0.0833333333333333),(1000077,22806,0.0833333333333333),(1000077,22807,0.0833333333333333),(1000077,22808,0.0833333333333333),(1000077,22809,0.0833333333333333),(1000077,23069,0.0833333333333333),(1000077,23566,0.0833333333333333),(1000077,23594,0.0833333333333333),(1000077,23606,0.0833333333333333),(1000077,23618,0.0833333333333333),(1000077,23950,0.0833333333333333),(1000077,24241,0.0833333333333333),(1000077,24242,0.0833213375908805),(1000077,24268,0.0833213375908805),(1000077,24270,0.0833213375908805),(1000077,24311,0.0833333333333333),(1000077,24312,0.0833333333333333),(1000077,24313,0.0833333333333333),(1000077,24314,0.0833333333333333),(1000077,24445,0.001990445859872),(1000077,24562,0.0833333333333333),(1000077,24563,0.0833333333333333),(1000077,24568,0.0833213375908805),(1000077,24571,0.0833333333333333),(1000077,24572,0.0833333333333333),(1000077,24606,0.0833333333333333),(1000077,24613,0.0833333333333333),(1000077,24624,0.0833333333333333),(1000077,24625,0.0833333333333333),(1000077,24764,0.0833333333333333),(1000077,25233,0.0833213375908805),(1000077,25235,0.0833213375908805),(1000077,25739,0.0833333333333333),(1000077,25810,0.0833333333333333),(1000077,25811,0.0833333333333333),(1000077,25862,0.0833333333333333),(1000077,25863,0.0833333333333333),(1000077,26252,0.0833333333333333),(1000077,26253,0.0833333333333333),(1000077,26254,0.0833333333333333),(1000077,26255,0.0833333333333333),(1000077,26256,0.0833333333333333),(1000077,26257,0.0833333333333333),(1000077,26258,0.0833333333333333),(1000077,26259,0.0833333333333333),(1000077,26260,0.0833333333333333),(1000077,26261,0.0833333333333333),(1000077,27309,0.001990445859872),(1000077,27902,0.0833213375908805),(1000077,27906,0.0833333333333333),(1000077,27911,0.0833333333333333),(1000077,27936,0.0833213375908805),(1000077,28164,0.0833333333333333),(1000077,28374,0.0833333333333333),(1000077,28585,0.0833333333333333),(1000077,28609,0.0635764228632056),(1000077,28615,0.0635764228632056),(1000077,28656,0.0635764228632056),(1000077,28667,0.0635764228632056),(1000077,28879,0.0833333333333333),(1000077,28880,0.0833333333333333),(1000078,3717,0.0970575584880456),(1000078,3725,-0.000639963431559987),(1000078,3814,0.00343467000427627),(1000078,9836,-0.00960125443589111),(1000078,11134,0.000501630494939203),(1000078,11135,0.000501630494939203),(1000078,11585,0.00120519785745323),(1000078,17366,0.002388535031847),(1000078,17367,0.002388535031847),(1000078,17368,0.002388535031847),(1000078,24445,0.002388535031847),(1000078,27309,0.002388535031847),(1000079,3713,0.5),(1000079,3721,-0.00324089848119871),(1000079,3812,-0.000539756871032445),(1000079,3814,0.00343467000427627),(1000079,11134,0.000501630494939203),(1000079,11135,0.000501630494939203),(1000079,11585,0.00120519785745323),(1000079,17366,0.00796178343949),(1000079,17367,0.00796178343949),(1000079,17368,0.00796178343949),(1000079,24445,0.00796178343949),(1000079,27309,0.00796178343949),(1000080,3812,0.000650934422356853),(1000080,9826,0.000428058622139743),(1000080,9834,-0.00627716203702263),(1000080,9842,-0.00224536225994577),(1000080,11134,0.000501630494939203),(1000080,11135,0.000501630494939203),(1000080,11585,0.00120519785745323),(1000080,17366,0.00796178343949),(1000080,17367,0.00796178343949),(1000080,17368,0.00796178343949),(1000080,24445,0.00796178343949),(1000080,27309,0.00796178343949),(1000081,3683,0.00140886512751823),(1000081,3695,0.000340845479652617),(1000081,3717,-0.00135255995721452),(1000081,3828,-0.00075842581758854),(1000081,11134,0.000501630494939203),(1000081,11135,0.000501630494939203),(1000081,11585,0.00120519785745323),(1000081,17366,0.00796178343949),(1000081,17367,0.00796178343949),(1000081,17368,0.00796178343949),(1000081,24445,0.00796178343949),(1000081,27309,0.00796178343949),(1000082,3647,-0.000936805232225887),(1000082,3713,0.5),(1000082,3775,-0.150383203471422),(1000082,9844,-0.27536231884058),(1000082,11134,0.000501630494939203),(1000082,11135,0.000501630494939203),(1000082,11585,0.00120519785745323),(1000082,17366,0.00796178343949),(1000082,17367,0.00796178343949),(1000082,17368,0.00796178343949),(1000082,24445,0.00796178343949),(1000082,27309,0.00796178343949),(1000083,45,0.0267959442890426),(1000083,3812,0.000650934422356853),(1000083,3814,-0.00282088783215561),(1000083,9836,-0.00960125443589111),(1000083,11134,0.000501630494939203),(1000083,11135,0.000501630494939203),(1000083,11585,0.00120519785745323),(1000083,17366,0.00796178343949),(1000083,17367,0.00796178343949),(1000083,17368,0.00796178343949),(1000083,21955,0.660377358490566),(1000083,24445,0.00796178343949),(1000083,27309,0.00796178343949),(1000084,41,0.00059168748604954),(1000084,44,0.000996009980034944),(1000084,248,1),(1000084,249,1),(1000084,251,1),(1000084,252,1),(1000084,256,1),(1000084,257,1),(1000084,259,1),(1000084,260,1),(1000084,455,0.022218466618763),(1000084,456,0.0082862572001674),(1000084,457,0.0130422067216992),(1000084,460,1),(1000084,461,1),(1000084,462,0.0130422067216992),(1000084,790,0.25),(1000084,803,0.333333333333333),(1000084,804,0.333333333333333),(1000084,805,0.333333333333333),(1000084,806,0.333333333333333),(1000084,834,0.0014337337750247),(1000084,835,0.0014337337750247),(1000084,836,0.0014337337750247),(1000084,837,0.0082862572001674),(1000084,838,0.0082862572001674),(1000084,839,0.022218466618763),(1000084,840,0.0082862572001674),(1000084,841,0.0130422067216992),(1000084,842,0.0130422067216992),(1000084,844,1),(1000084,845,1),(1000084,846,0.0130422067216992),(1000084,847,0.0130422067216992),(1000084,848,1),(1000084,879,0.000534474439183068),(1000084,881,0.00134566869131638),(1000084,882,0.00140227877045328),(1000084,885,0.00138288684185062),(1000084,937,0.00944878640586534),(1000084,969,0.0130422067216992),(1000084,970,0.0130422067216992),(1000084,973,0.0130422067216992),(1000084,996,1),(1000084,997,1),(1000084,1130,0.000151507385404694),(1000084,1131,0.000233570090076233),(1000084,1132,0.000233025811478461),(1000084,1136,0.000622843283415141),(1000084,1137,0.000469456687002521),(1000084,1154,0.00160822014841092),(1000084,1155,0.00160822014841092),(1000084,1156,0.00160822014841092),(1000084,1157,0.00160822014841092),(1000084,1158,0.00160822014841092),(1000084,1159,1),(1000084,1160,0.0010298131446645),(1000084,1161,1),(1000084,1162,1),(1000084,1163,1),(1000084,1164,1),(1000084,1165,0.00160822014841092),(1000084,1166,1),(1000084,1167,1),(1000084,1168,1),(1000084,1169,1),(1000084,1170,1),(1000084,1171,1),(1000084,1172,1),(1000084,1173,0.00160822014841092),(1000084,1174,1),(1000084,1175,1),(1000084,1176,1),(1000084,1177,1),(1000084,1196,0.5),(1000084,1214,0.25),(1000084,1216,0.00124126207272337),(1000084,1220,0.00104187744990559),(1000084,1221,0.00104187744990559),(1000084,1305,0.25),(1000084,1564,0.00139321798902001),(1000084,1811,0.004679400908036),(1000084,1815,0.000776029975055001),(1000084,1817,0.00124126207272337),(1000084,1819,0.0769230769230769),(1000084,1821,0.0769230769230769),(1000084,1823,0.0769230769230769),(1000084,1825,0.0769230769230769),(1000084,1827,0.0769230769230769),(1000084,1829,0.0769230769230769),(1000084,1831,0.0769230769230769),(1000084,1833,0.0769230769230769),(1000084,1945,1),(1000084,2007,1),(1000084,2019,0.00205347926444682),(1000084,2021,0.25),(1000084,2162,0.00936034252862661),(1000084,2194,0.25),(1000084,2445,0.25),(1000084,2477,0.25),(1000084,2507,0.00104187744990559),(1000084,2509,0.00104187744990559),(1000084,2511,0.000693104366255889),(1000084,2513,0.00104187744990559),(1000084,2517,0.000693104366255889),(1000084,3293,0.000604281162378804),(1000084,3296,0.25),(1000084,3297,0.000604281162378804),(1000084,3465,0.25),(1000084,3466,0.25),(1000084,3467,0.25),(1000084,3529,0.00164836942295552),(1000084,3539,0.25),(1000084,3685,-0.00314177303642755),(1000084,3773,-0.0023130082217371),(1000084,3840,0.5),(1000084,3938,1),(1000084,3942,1),(1000084,3948,0.5),(1000084,3954,1),(1000084,3978,0.25),(1000084,3982,0.25),(1000084,3988,0.25),(1000084,3994,0.25),(1000084,9846,0.00351370086554458),(1000084,9945,0.25),(1000084,10837,0.25),(1000084,10839,0.25),(1000084,10841,0.25),(1000084,11134,0.000501630494939203),(1000084,11135,0.000501630494939203),(1000084,11218,0.250062515628907),(1000084,11228,0.250062515628907),(1000084,11238,0.250062515628907),(1000084,11248,0.250062515628907),(1000084,11258,0.25),(1000084,11268,0.333333333333333),(1000084,11278,0.00200012701678612),(1000084,11280,0.250062515628907),(1000084,11292,0.250062515628907),(1000084,11294,0.250062515628907),(1000084,11296,0.250062515628907),(1000084,11298,0.250062515628907),(1000084,11300,0.250062515628907),(1000084,11302,0.00200012701678612),(1000084,11304,0.00200012701678612),(1000084,11306,0.00200012701678612),(1000084,11488,0.25),(1000084,11489,0.25),(1000084,11568,1),(1000084,11613,0.25),(1000084,12218,0.5),(1000084,12220,0.5),(1000084,12226,0.5),(1000084,15587,-0.090909090909),(1000084,15588,-0.090909090909),(1000084,15589,-0.090909090909),(1000084,15590,-0.090909090909),(1000084,15591,-0.090909090909),(1000084,15592,-0.090909090909),(1000084,15593,-0.090909090909),(1000084,15594,-0.090909090909),(1000084,15625,-0.090909090909),(1000084,15626,-0.090909090909),(1000084,15627,-0.090909090909),(1000084,15628,-0.090909090909),(1000084,15629,-0.090909090909),(1000084,15630,-0.090909090909),(1000084,15631,-0.090909090909),(1000084,15632,-0.090909090909),(1000084,15646,-0.090909090909),(1000084,15647,-0.090909090909),(1000084,15648,-0.090909090909),(1000084,15649,-0.090909090909),(1000084,15650,-0.090909090909),(1000084,15660,-0.090909090909),(1000084,15661,-0.090909090909),(1000084,15662,-0.090909090909),(1000084,15663,-0.090909090909),(1000084,15664,-0.090909090909),(1000084,15666,-0.090909090909),(1000084,15673,-0.090909090909),(1000084,15674,-0.2),(1000084,15994,-0.090909090909),(1000084,15997,-0.090909090909),(1000084,15998,-0.090909090909),(1000084,16002,-0.090909090909),(1000084,16234,1),(1000084,16237,1),(1000084,17363,0.25),(1000084,17364,0.25),(1000084,17365,0.25),(1000084,17366,0.00796178343949),(1000084,17367,0.00796178343949),(1000084,17368,0.00796178343949),(1000084,17681,1),(1000084,17683,1),(1000084,17685,1),(1000084,17687,1),(1000084,17689,1),(1000084,17691,1),(1000084,17693,1),(1000084,17695,1),(1000084,17767,-1),(1000084,17858,0.00104187744990559),(1000084,17860,0.00104187744990559),(1000084,17862,0.00104187744990559),(1000084,17864,0.00104187744990559),(1000084,19721,1),(1000084,19745,1),(1000084,20184,1),(1000084,20281,0.25),(1000084,20445,1),(1000084,20447,1),(1000084,20702,0.5),(1000084,21012,0.333333333333333),(1000084,21018,1),(1000084,21020,1),(1000084,21022,0.5),(1000084,21026,0.25),(1000084,21028,0.25),(1000084,21040,0.25),(1000084,21604,0.25),(1000084,22299,0.5),(1000084,22300,0.5),(1000084,22301,0.5),(1000084,22302,0.25),(1000084,22309,0.5),(1000084,22310,0.5),(1000084,22311,0.5),(1000084,23736,0.25),(1000084,23758,1),(1000084,23920,1),(1000084,23954,0.25),(1000084,24349,0.25),(1000084,24445,0.00796178343949),(1000084,24546,0.25),(1000084,24548,0.25),(1000084,24551,1),(1000084,24557,0.25),(1000084,24559,0.25),(1000084,24561,0.25),(1000084,24645,0.25),(1000084,24693,1),(1000084,24697,1),(1000084,27309,0.00796178343949),(1000084,27921,1),(1000084,27952,0.25),(1000084,28231,-0.090909090909),(1000084,28236,-0.090909090909),(1000084,28584,0.25),(1000084,28668,0.515432982204093),(1000084,29000,0.0786900086583849),(1000084,29002,0.0786900086583849),(1000084,29004,0.0786900086583849),(1000084,29006,0.0786900086583849),(1000084,29008,0.0786900086583849),(1000084,29010,0.0786900086583849),(1000084,29012,0.0786900086583849),(1000084,29014,0.0786900086583849),(1000084,29016,0.0786900086583849),(1000085,42,0.0146554842275331),(1000085,3673,-0.00805372206334728),(1000085,3723,0.5),(1000085,9840,-0.0341735844165319),(1000085,11134,0.000501630494939203),(1000085,11135,0.000501630494939203),(1000085,11585,0.00120519785745323),(1000085,17366,0.000398089171974),(1000085,17367,0.000398089171974),(1000085,17368,0.000398089171974),(1000085,24445,0.000398089171974),(1000085,27309,0.000398089171974),(1000086,42,-0.00160147546872809),(1000086,3683,0.00140886512751823),(1000086,3777,-0.00446540193482423),(1000086,3812,0.000650934422356853),(1000086,11134,0.000501630494939203),(1000086,11135,0.000501630494939203),(1000086,11585,0.00120519785745323),(1000086,17366,0.00796178343949),(1000086,17367,0.00796178343949),(1000086,17368,0.00796178343949),(1000086,24445,0.00796178343949),(1000086,27309,0.00796178343949),(1000087,42,-0.00160147546872809),(1000087,43,0.000481921379096225),(1000087,3673,0.00936046937222164),(1000087,9848,-0.000489941284499872),(1000087,11134,0.000501630494939203),(1000087,11135,0.000501630494939203),(1000087,11585,0.00120519785745323),(1000087,17366,0.002388535031847),(1000087,17367,0.002388535031847),(1000087,17368,0.002388535031847),(1000087,17424,-1),(1000087,24445,0.002388535031847),(1000087,27309,0.002388535031847),(1000088,3775,-0.150383203471422),(1000088,9844,-0.0151537338556737),(1000088,11134,0.000501630494939203),(1000088,11135,0.000501630494939203),(1000088,17366,0.002388535031847),(1000088,17367,0.002388535031847),(1000088,17368,0.002388535031847),(1000088,24445,0.002388535031847),(1000088,27309,0.002388535031847),(1000089,45,-0.0106813118499739),(1000089,3695,0.000340845479652617),(1000089,3777,-0.00446540193482423),(1000089,9840,0.00183639083792037),(1000089,11134,0.000501630494939203),(1000089,11135,0.000501630494939203),(1000089,11585,0.00120519785745323),(1000089,17366,0.002388535031847),(1000089,17367,0.002388535031847),(1000089,17368,0.002388535031847),(1000089,24445,0.002388535031847),(1000089,27309,0.002388535031847),(1000090,3695,0.000340845479652617),(1000090,3717,0.0970575584880456),(1000090,3721,-0.00324089848119871),(1000090,9850,-0.000573604331541323),(1000090,11134,0.000501630494939203),(1000090,11135,0.000501630494939203),(1000090,17366,0.002388535031847),(1000090,17367,0.002388535031847),(1000090,17368,0.002388535031847),(1000090,24445,0.002388535031847),(1000090,27309,0.002388535031847),(1000091,45,0.0267959442890426),(1000091,3673,-0.00805372206334728),(1000091,3693,0.00268386370244684),(1000091,3721,-0.00324089848119871),(1000091,11134,0.000501630494939203),(1000091,11135,0.000501630494939203),(1000091,11585,0.00120519785745323),(1000091,17366,0.002388535031847),(1000091,17367,0.002388535031847),(1000091,17368,0.002388535031847),(1000091,21955,0.339622641509434),(1000091,24445,0.002388535031847),(1000091,27309,0.002388535031847),(1000092,45,-0.0106813118499739),(1000092,3695,0.000340845479652617),(1000092,3715,-0.000471762096642204),(1000092,3721,0.0136481079125986),(1000092,11134,0.000501630494939203),(1000092,11135,0.000501630494939203),(1000092,11585,0.00120519785745323),(1000092,17366,0.00796178343949),(1000092,17367,0.00796178343949),(1000092,17368,0.00796178343949),(1000092,24445,0.00796178343949),(1000092,27309,0.00796178343949),(1000093,42,-0.00160147546872809),(1000093,3723,0.5),(1000093,3814,-0.00282088783215561),(1000093,9850,0.000711366442245851),(1000093,11134,0.000501630494939203),(1000093,11135,0.000501630494939203),(1000093,11585,0.00120519785745323),(1000093,17366,0.00796178343949),(1000093,17367,0.00796178343949),(1000093,17368,0.00796178343949),(1000093,24445,0.00796178343949),(1000093,27309,0.00796178343949),(1000094,223,0.167848039213586),(1000094,521,0.234091572536208),(1000094,522,0.608179261661032),(1000094,813,0.1692810750356),(1000094,814,0.181383956979624),(1000094,879,0.258139597339888),(1000094,1026,0.168669881982681),(1000094,1032,0.0979065284013378),(1000094,1067,0.404808502257147),(1000094,1072,0.24714696753366),(1000094,1074,0.78614152535737),(1000094,1099,0.409005377115195),(1000094,1102,0.179457699819308),(1000094,1105,0.210526039404827),(1000094,1109,0.190289925003165),(1000094,1130,0.0731747911502856),(1000094,1131,0.112809303088615),(1000094,1132,0.112546428294669),(1000094,1133,0.103132171399867),(1000094,1134,0.116690114833586),(1000094,1138,0.167848039213586),(1000094,1141,0.191034229064246),(1000094,1186,0.253055889316812),(1000094,1202,0.0982222843749262),(1000094,1215,0.355088513494829),(1000094,1218,0.0982222843749262),(1000094,1815,0.374805698080852),(1000094,2019,0.991786082942213),(1000094,2020,0.997933791989637),(1000094,2047,0.234091572536208),(1000094,2204,0.339477504479084),(1000094,2487,0.405180339509695),(1000094,2511,0.33475442210723),(1000094,2517,0.33475442210723),(1000094,3293,0.291854735232932),(1000094,3297,0.291854735232932),(1000094,3529,0.796126789074336),(1000094,3556,0.252923370447548),(1000094,3567,0.189908453962672),(1000094,3683,0.680451393109928),(1000094,3687,-0.135460785203114),(1000094,3699,-0.188004969618007),(1000094,3828,0.132930600335841),(1000094,10247,0.0982222843749262),(1000094,11129,0.0690480169272338),(1000094,11130,0.0690480169272338),(1000094,11562,0.0979065284013378),(1000094,12053,0.404808502257147),(1000094,12055,0.404808502257147),(1000094,12057,0.24714696753366),(1000094,12067,0.24714696753366),(1000094,12266,0.166666),(1000094,12270,0.166666),(1000094,17366,0.017914012738853),(1000094,17367,0.017914012738853),(1000094,17368,0.017914012738853),(1000094,22779,0.166666),(1000094,24445,0.017914012738853),(1000094,27309,0.017914012738853),(1000095,223,0.0158224090386248),(1000095,224,0.0222715157015941),(1000095,225,0.0567241073633778),(1000095,231,0.0395255731012442),(1000095,232,0.0567241073633778),(1000095,233,0.0567241073633778),(1000095,234,0.0567241073633778),(1000095,954,0.290350465252432),(1000095,1130,0.00689791481819139),(1000095,1131,0.0106341125293634),(1000095,1132,0.0106093323023483),(1000095,1133,0.00972188539452525),(1000095,1134,0.0109999421876574),(1000095,1135,0.0283748379943676),(1000095,1136,0.0283571649171049),(1000095,1137,0.0213736923063118),(1000095,1138,0.0158224090386248),(1000095,1139,0.0222715157015941),(1000095,1140,0.0567241073633778),(1000095,1141,0.0180080847342315),(1000095,1142,0.0567241073633778),(1000095,1143,0.0567241073633778),(1000095,1144,0.0567241073633778),(1000095,1145,0.0567241073633778),(1000095,1146,0.0395255731012442),(1000095,1147,0.0567241073633778),(1000095,1148,0.0567241073633778),(1000095,1149,0.0567241073633778),(1000095,1150,0.0567241073633778),(1000095,1151,0.0567241073633778),(1000095,1152,0.0567241073633778),(1000095,1153,0.0567241073633778),(1000095,1202,0.00925904864524875),(1000095,1218,0.00925904864524875),(1000095,3687,-0.012769383319692),(1000095,3691,0.0941764201205136),(1000095,3725,-0.0291366208047669),(1000095,3773,0.135417994396533),(1000095,10247,0.00925904864524875),(1000095,11129,0.00650889919386175),(1000095,11130,0.00650889919386175),(1000095,11855,-0.0554301491204424),(1000095,17366,0.00796178343949),(1000095,17367,0.00796178343949),(1000095,17368,0.00796178343949),(1000095,24445,0.00796178343949),(1000095,27309,0.00796178343949),(1000096,42,0.150861618934541),(1000096,3693,-0.0226331938341342),(1000096,3777,1),(1000096,9832,0.0107392174877294),(1000096,11129,0.00147164179551838),(1000096,11130,0.00147164179551838),(1000096,17366,0.000398089171974),(1000096,17367,0.000398089171974),(1000096,17368,0.000398089171974),(1000096,24445,0.000398089171974),(1000096,27309,0.000398089171974),(1000097,785,0.0778589474162623),(1000097,1202,0.0506068388163029),(1000097,1218,0.0506068388163029),(1000097,3643,0.166169406303826),(1000097,3691,-0.184719850864125),(1000097,9826,0.106519744627402),(1000097,9832,0.16202198427111),(1000097,10247,0.0506068388163029),(1000097,11129,0.0355754489468368),(1000097,11130,0.0355754489468368),(1000097,12109,0.0778589474162623),(1000097,12237,0.199999996248124),(1000097,12238,0.173924390628306),(1000097,12239,0.173924390628306),(1000097,13780,0.199999996248124),(1000097,14343,0.173924390628306),(1000097,16216,0.199999996248124),(1000097,16220,0.199999996248124),(1000097,16221,0.199999996248124),(1000097,16279,0.199999996248124),(1000097,16869,0.199999996248124),(1000097,17366,0.00796178343949),(1000097,17367,0.00796178343949),(1000097,17368,0.00796178343949),(1000097,17482,0.199999996248124),(1000097,17483,0.199999996248124),(1000097,17621,0.199999996248124),(1000097,17982,0.199999996248124),(1000097,18037,0.0778589474162623),(1000097,18039,0.0778589474162623),(1000097,18041,0.0778589474162623),(1000097,18043,0.0778589474162623),(1000097,18045,0.0778589474162623),(1000097,18047,0.0778589474162623),(1000097,18049,0.0778589474162623),(1000097,18051,0.0778589474162623),(1000097,18053,0.0778589474162623),(1000097,18055,0.0778589474162623),(1000097,18057,0.0778589474162623),(1000097,18059,0.0778589474162623),(1000097,18061,0.0778589474162623),(1000097,18063,0.0778589474162623),(1000097,18065,0.0778589474162623),(1000097,18067,0.0778589474162623),(1000097,18626,0.199999996248124),(1000097,18635,0.199999996248124),(1000097,18637,0.199999996248124),(1000097,19470,0.173924390628306),(1000097,20175,0.199999996248124),(1000097,22543,0.199999996248124),(1000097,22577,0.199999996248124),(1000097,24445,0.00796178343949),(1000097,24574,0.199999996248124),(1000097,24575,0.199999996248124),(1000097,24646,0.199999996248124),(1000097,24653,0.199999996248124),(1000097,24654,0.199999996248124),(1000097,24655,0.199999996248124),(1000097,24656,0.199999996248124),(1000097,24657,0.199999996248124),(1000097,24658,0.199999996248124),(1000097,24659,0.199999996248124),(1000097,24660,0.199999996248124),(1000097,27309,0.00796178343949),(1000097,27656,0.285714278057397),(1000097,27658,0.285714278057397),(1000097,27660,0.285714278057397),(1000097,27673,0.199999996248124),(1000097,27674,0.199999996248124),(1000097,27675,0.199999996248124),(1000097,27897,0.199999996248124),(1000097,28351,0.199999996248124),(1000097,28368,0.199999996248124),(1000097,28386,0.199999996248124),(1000097,28448,0.199999996248124),(1000097,28449,0.199999996248124),(1000097,28450,0.199999996248124),(1000097,28451,0.199999996248124),(1000097,28452,0.199999996248124),(1000097,28453,0.199999996248124),(1000097,28454,0.199999996248124),(1000097,28455,0.199999996248124),(1000097,28456,0.199999996248124),(1000097,28457,0.199999996248124),(1000097,28458,0.199999996248124),(1000097,28459,0.199999996248124),(1000097,28460,0.199999996248124),(1000097,28461,0.199999996248124),(1000097,28462,0.199999996248124),(1000097,28463,0.199999996248124),(1000097,28464,0.199999996248124),(1000097,28465,0.199999996248124),(1000097,28466,0.199999996248124),(1000097,28467,0.199999996248124),(1000097,28468,0.199999996248124),(1000097,28469,0.199999996248124),(1000097,28470,0.199999996248124),(1000097,28471,0.199999996248124),(1000097,28472,0.199999996248124),(1000097,28473,0.199999996248124),(1000097,28474,0.199999996248124),(1000097,28475,0.199999996248124),(1000097,28476,0.199999996248124),(1000097,28477,0.199999996248124),(1000097,28478,0.199999996248124),(1000097,28479,0.199999996248124),(1000097,28480,0.199999996248124),(1000097,28481,0.199999996248124),(1000097,28482,0.199999996248124),(1000097,28483,0.199999996248124),(1000097,28484,0.199999996248124),(1000097,28485,0.199999996248124),(1000097,28486,0.199999996248124),(1000097,28487,0.199999996248124),(1000097,28488,0.199999996248124),(1000097,28489,0.199999996248124),(1000097,28490,0.199999996248124),(1000097,28491,0.199999996248124),(1000097,28492,0.199999996248124),(1000097,28493,0.199999996248124),(1000097,28494,0.199999996248124),(1000097,28495,0.199999996248124),(1000097,28496,0.199999996248124),(1000097,28497,0.199999996248124),(1000097,28498,0.199999996248124),(1000097,28499,0.199999996248124),(1000097,28500,0.199999996248124),(1000097,28501,0.199999996248124),(1000097,28502,0.199999996248124),(1000097,28503,0.199999996248124),(1000097,28504,0.199999996248124),(1000097,28505,0.199999996248124),(1000098,223,0.12137191310811),(1000098,231,0.303196208129973),(1000098,785,0.109272599351116),(1000098,1130,0.0529131256749151),(1000098,1138,0.12137191310811),(1000098,1146,0.303196208129973),(1000098,1160,0.359656608156502),(1000098,1202,0.0710251166488971),(1000098,1218,0.0710251166488971),(1000098,3645,0.151735623570401),(1000098,3651,0.282969738612468),(1000098,3683,-0.31274757788006),(1000098,3693,-0.767886203216612),(1000098,9828,0.159112852795903),(1000098,10247,0.0710251166488971),(1000098,11129,0.0499290307473618),(1000098,11130,0.0499290307473618),(1000098,12109,0.109272599351116),(1000098,17366,0.011942675159235),(1000098,17367,0.011942675159235),(1000098,17368,0.011942675159235),(1000098,18037,0.109272599351116),(1000098,18039,0.109272599351116),(1000098,18041,0.109272599351116),(1000098,18043,0.109272599351116),(1000098,18045,0.109272599351116),(1000098,18047,0.109272599351116),(1000098,18049,0.109272599351116),(1000098,18051,0.109272599351116),(1000098,18053,0.109272599351116),(1000098,18055,0.109272599351116),(1000098,18057,0.109272599351116),(1000098,18059,0.109272599351116),(1000098,18061,0.109272599351116),(1000098,18063,0.109272599351116),(1000098,18065,0.109272599351116),(1000098,18067,0.109272599351116),(1000098,24445,0.011942675159235),(1000098,27309,0.011942675159235),(1000099,3643,-0.0316437578008164),(1000099,3673,0.344583926731705),(1000099,3693,-0.0809402684437309),(1000099,3725,0.0547417756732369),(1000099,11129,0.00526284901968314),(1000099,11130,0.00526284901968314),(1000099,17366,0.00796178343949),(1000099,17367,0.00796178343949),(1000099,17368,0.00796178343949),(1000099,24445,0.00796178343949),(1000099,27309,0.00796178343949),(1000100,41,-0.82525244399351),(1000100,506,1),(1000100,1076,1),(1000100,1079,0.54809646721693),(1000100,3695,0.335600882055949),(1000100,3699,0.78779209054975),(1000100,9852,-0.540105345245691),(1000100,11129,0.14076318242397),(1000100,11130,0.14076318242397),(1000100,12865,1),(1000100,17366,0.017914012738853),(1000100,17367,0.017914012738853),(1000100,17368,0.017914012738853),(1000100,24445,0.017914012738853),(1000100,27309,0.017914012738853),(1000101,522,0.391820738338968),(1000101,1262,0.591254506290536),(1000101,1302,0.747991987695764),(1000101,3643,-0.267469436239245),(1000101,3828,0.0856408122650869),(1000101,9826,0.133194640158402),(1000101,9828,-0.257228569757711),(1000101,11129,0.0444843267088398),(1000101,11130,0.0444843267088398),(1000101,11280,0.249812453113278),(1000101,11292,0.249812453113278),(1000101,11294,0.249812453113278),(1000101,11296,0.249812453113278),(1000101,11298,0.249812453113278),(1000101,11300,0.249812453113278),(1000101,11622,0.5),(1000101,11623,0.2),(1000101,11624,1),(1000101,11625,0.333333),(1000101,11626,0.5),(1000101,11629,0.166666),(1000101,11770,1),(1000101,11859,0.0832378269866455),(1000101,11860,0.0832378269866455),(1000101,11870,0.0832378269866455),(1000101,11872,0.0832378269866455),(1000101,11873,0.0832378269866455),(1000101,11878,1),(1000101,11887,0.0832378269866455),(1000101,11889,0.0832378269866455),(1000101,11890,0.0832378269866455),(1000101,11891,0.0832378269866455),(1000101,12095,0.125049038743976),(1000101,12345,0.122999465042867),(1000101,12355,0.122999465042867),(1000101,16591,0.124854942389053),(1000101,17323,0.333333),(1000101,17329,0.333333),(1000101,17331,0.333333),(1000101,17337,0.333333),(1000101,17339,0.333333),(1000101,17341,0.333333),(1000101,17344,0.333333),(1000101,17345,0.333333),(1000101,17357,0.333333),(1000101,17366,0.011942675159235),(1000101,17367,0.011942675159235),(1000101,17368,0.011942675159235),(1000101,21945,0.333333),(1000101,21947,0.333333),(1000101,22573,1),(1000101,22766,1),(1000101,23056,1),(1000101,23058,1),(1000101,23060,1),(1000101,23062,1),(1000101,23474,1),(1000101,23507,1),(1000101,23511,1),(1000101,23513,1),(1000101,23524,1),(1000101,23526,1),(1000101,23528,1),(1000101,23534,1),(1000101,23537,1),(1000101,23560,1),(1000101,23562,1),(1000101,23564,1),(1000101,23660,1),(1000101,23703,1),(1000101,23706,1),(1000101,23708,1),(1000101,23710,1),(1000101,23712,1),(1000101,23714,1),(1000101,23716,1),(1000101,23718,1),(1000101,23720,1),(1000101,23722,1),(1000101,23724,1),(1000101,23726,1),(1000101,23728,1),(1000101,24284,1),(1000101,24396,1),(1000101,24445,0.011942675159235),(1000101,25562,0.166666),(1000101,25909,0.333333),(1000101,25911,0.333333),(1000101,25913,0.333333),(1000101,25915,0.333333),(1000101,25917,0.333333),(1000101,25919,0.333333),(1000101,25921,0.333333),(1000101,25925,0.333333),(1000101,25929,0.0832378269866455),(1000101,25931,0.0832378269866455),(1000101,25933,0.0832378269866455),(1000101,25935,0.0832378269866455),(1000101,25937,0.0832378269866455),(1000101,25949,0.0832378269866455),(1000101,25951,0.0832378269866455),(1000101,25953,0.0832378269866455),(1000101,25955,0.0832378269866455),(1000101,25957,0.0832378269866455),(1000101,25997,0.333333),(1000101,25999,0.333333),(1000101,26001,0.333333),(1000101,26003,0.333333),(1000101,26005,0.333333),(1000101,26007,0.333333),(1000101,26009,0.333333),(1000101,26097,0.333333),(1000101,26101,0.333333),(1000101,26103,0.333333),(1000101,26105,0.333333),(1000101,27309,0.011942675159235),(1000101,27939,0.333333),(1000101,27967,0.333333),(1000101,27969,0.333333),(1000101,27975,0.333333),(1000101,27977,0.333333),(1000101,27983,0.333333),(1000101,28005,0.333333),(1000101,28007,0.333333),(1000101,28009,0.333333),(1000101,28029,0.333333),(1000101,28031,0.333333),(1000101,28033,0.333333),(1000101,28053,0.333333),(1000101,28055,0.333333),(1000101,28057,0.333333),(1000101,28106,0.333333),(1000101,28107,0.333333),(1000101,28108,0.333333),(1000101,28109,0.333333),(1000101,28110,0.333333),(1000101,28111,0.333333),(1000101,28112,0.333333),(1000101,28113,0.333333),(1000101,28114,0.333333),(1000101,28115,0.333333),(1000101,28116,0.333333),(1000101,28117,0.333333),(1000101,28118,0.333333),(1000101,28119,0.333333),(1000101,28120,0.333333),(1000101,28668,0.0336377282271037),(1000102,1202,0.0236112080257838),(1000102,1218,0.0236112080257838),(1000102,1245,0.166666),(1000102,1315,0.512863379706972),(1000102,1318,0.166666),(1000102,1334,0.166666),(1000102,1404,0.166666),(1000102,2204,0.0816054526662564),(1000102,2454,0.161468877879372),(1000102,2455,0.161468877879372),(1000102,2487,0.0973994582288834),(1000102,2604,0.166666),(1000102,3828,-0.0880539765436348),(1000102,9834,-0.728784629887758),(1000102,9846,0.407944094756364),(1000102,10247,0.0236112080257838),(1000102,11129,0.0165981386180521),(1000102,11130,0.0165981386180521),(1000102,11857,1),(1000102,11859,0.0833003178477466),(1000102,11860,0.0833003178477466),(1000102,11870,0.0833003178477466),(1000102,11872,0.0833003178477466),(1000102,11873,0.0833003178477466),(1000102,11887,0.0833003178477466),(1000102,11889,0.0833003178477466),(1000102,11890,0.0833003178477466),(1000102,11891,0.0833003178477466),(1000102,12092,0.125),(1000102,12095,0.125029458677717),(1000102,12096,0.250062515628907),(1000102,12345,0.143535368036721),(1000102,12355,0.143535368036721),(1000102,16591,0.124948677330786),(1000102,17323,0.333333),(1000102,17329,0.333333),(1000102,17331,0.333333),(1000102,17337,0.333333),(1000102,17339,0.333333),(1000102,17341,0.333333),(1000102,17344,0.333333),(1000102,17345,0.333333),(1000102,17357,0.333333),(1000102,17366,0.005971337579617),(1000102,17367,0.005971337579617),(1000102,17368,0.005971337579617),(1000102,19719,0.124948677330786),(1000102,21945,0.333333),(1000102,21947,0.333333),(1000102,21961,0.0921994372275578),(1000102,21963,0.5),(1000102,21965,0.204253876738914),(1000102,21967,0.204253876738914),(1000102,24445,0.005971337579617),(1000102,25909,0.333333),(1000102,25911,0.333333),(1000102,25913,0.333333),(1000102,25915,0.333333),(1000102,25917,0.333333),(1000102,25919,0.333333),(1000102,25921,0.333333),(1000102,25925,0.333333),(1000102,25929,0.0833003178477466),(1000102,25931,0.0833003178477466),(1000102,25933,0.0833003178477466),(1000102,25935,0.0833003178477466),(1000102,25937,0.0833003178477466),(1000102,25949,0.0833003178477466),(1000102,25951,0.0833003178477466),(1000102,25953,0.0833003178477466),(1000102,25955,0.0833003178477466),(1000102,25957,0.0833003178477466),(1000102,25997,0.333333),(1000102,25999,0.333333),(1000102,26001,0.333333),(1000102,26003,0.333333),(1000102,26005,0.333333),(1000102,26007,0.333333),(1000102,26009,0.333333),(1000102,26097,0.333333),(1000102,26101,0.333333),(1000102,26103,0.333333),(1000102,26105,0.333333),(1000102,27309,0.005971337579617),(1000102,27939,0.333333),(1000102,27967,0.333333),(1000102,27969,0.333333),(1000102,27975,0.333333),(1000102,27977,0.333333),(1000102,27983,0.333333),(1000102,28005,0.333333),(1000102,28007,0.333333),(1000102,28009,0.333333),(1000102,28029,0.333333),(1000102,28031,0.333333),(1000102,28033,0.333333),(1000102,28053,0.333333),(1000102,28055,0.333333),(1000102,28057,0.333333),(1000102,28106,0.333333),(1000102,28107,0.333333),(1000102,28108,0.333333),(1000102,28109,0.333333),(1000102,28110,0.333333),(1000102,28111,0.333333),(1000102,28112,0.333333),(1000102,28113,0.333333),(1000102,28114,0.333333),(1000102,28115,0.333333),(1000102,28116,0.333333),(1000102,28117,0.333333),(1000102,28118,0.333333),(1000102,28119,0.333333),(1000102,28120,0.333333),(1000103,1074,0.0216523543093858),(1000103,1099,0.0112650573135878),(1000103,1130,0.00201542146470515),(1000103,1131,0.00310705759851472),(1000103,1132,0.00309981735233268),(1000103,1193,0.0383911687146489),(1000103,1242,0.10124618323201),(1000103,1245,0.166666),(1000103,1318,0.166666),(1000103,1334,0.166666),(1000103,1404,0.166666),(1000103,2604,0.166666),(1000103,9830,0.0733114499041634),(1000103,9834,-0.083501718896772),(1000103,9836,-0.127720336711658),(1000103,9840,0.0244285220977611),(1000103,11129,0.0019017595161244),(1000103,11130,0.0019017595161244),(1000103,17366,0.000398089171974),(1000103,17367,0.000398089171974),(1000103,17368,0.000398089171974),(1000103,24445,0.000398089171974),(1000103,27309,0.000398089171974),(1000104,43,0.0913318254338778),(1000104,3643,-0.162905822740026),(1000104,3725,-0.121283327427629),(1000104,9852,0.149685424625821),(1000104,11129,0.0270937716975544),(1000104,11130,0.0270937716975544),(1000104,17366,0.005971337579617),(1000104,17367,0.005971337579617),(1000104,17368,0.005971337579617),(1000104,22634,0.249812453113278),(1000104,24445,0.005971337579617),(1000104,24684,0.249812453113278),(1000104,25270,0.249812453113278),(1000104,25271,0.249812453113278),(1000104,25280,0.249812453113278),(1000104,25305,0.249812453113278),(1000104,25821,0.249812453113278),(1000104,27309,0.005971337579617),(1000105,43,-0.238866591932092),(1000105,3645,-0.171108170471502),(1000105,3647,0.122137563389943),(1000105,3699,0.204206876457577),(1000105,11129,0.0364878121370421),(1000105,11130,0.0364878121370421),(1000105,17366,0.005971337579617),(1000105,17367,0.005971337579617),(1000105,17368,0.005971337579617),(1000105,24445,0.005971337579617),(1000105,27309,0.005971337579617),(1000106,3647,-0.384681132334487),(1000106,3695,0.139961670316808),(1000106,9840,0.754078737649011),(1000106,9842,-0.922015021846921),(1000106,11129,0.0587050010431256),(1000106,11130,0.0587050010431256),(1000106,17366,0.003980891719745),(1000106,17367,0.003980891719745),(1000106,17368,0.003980891719745),(1000106,24445,0.003980891719745),(1000106,27309,0.003980891719745),(1000107,3356,0.384795978977435),(1000107,3358,0.384795978977435),(1000107,3359,0.384795978977435),(1000107,3374,0.787721558407018),(1000107,3645,-0.298534504105665),(1000107,3647,0.213094890903316),(1000107,3715,-0.210073432521362),(1000107,3812,0.289858022558612),(1000107,11129,0.0636607291879538),(1000107,11130,0.0636607291879538),(1000107,11395,0.384795978977435),(1000107,12180,0.402172582939575),(1000107,12181,0.402172582939575),(1000107,12182,0.402172582939575),(1000107,12183,0.402172582939575),(1000107,12184,0.402172582939575),(1000107,12185,0.402172582939575),(1000107,12186,0.402172582939575),(1000107,12187,0.402172582939575),(1000107,12188,0.402172582939575),(1000107,12189,0.402172582939575),(1000107,12190,0.402172582939575),(1000107,12191,0.402172582939575),(1000107,12192,0.402172582939575),(1000107,12193,0.402172582939575),(1000107,12194,0.402172582939575),(1000107,12195,0.402172582939575),(1000107,17366,0.005971337579617),(1000107,17367,0.005971337579617),(1000107,17368,0.005971337579617),(1000107,18025,0.26811505529305),(1000107,24445,0.005971337579617),(1000107,27309,0.005971337579617),(1000108,43,0.0854141799494118),(1000108,44,0.00790484111138844),(1000108,1075,0.110576544576972),(1000108,1105,0.0772559459999835),(1000108,1949,1),(1000108,1982,1),(1000108,3689,-0.0837423555968676),(1000108,9826,-0.0982241534347036),(1000108,9828,0.0807475644488623),(1000108,11129,0.0253382901336907),(1000108,11130,0.0253382901336907),(1000108,11617,1),(1000108,11634,0.333333333333),(1000108,11820,0.333333),(1000108,11824,0.333333),(1000108,11828,0.333333),(1000108,11832,0.333333),(1000108,11836,0.333333),(1000108,12236,0.5),(1000108,16690,1),(1000108,16691,1),(1000108,16692,1),(1000108,17180,1),(1000108,17366,0.008957006369426),(1000108,17367,0.008957006369426),(1000108,17368,0.008957006369426),(1000108,17402,1),(1000108,17403,1),(1000108,17404,1),(1000108,17649,1),(1000108,17651,1),(1000108,17653,1),(1000108,17655,1),(1000108,17657,1),(1000108,17659,1),(1000108,17661,1),(1000108,17663,1),(1000108,17941,0.25),(1000108,17942,0.25),(1000108,17943,0.25),(1000108,17944,0.25),(1000108,17945,0.25),(1000108,17946,0.25),(1000108,17947,0.25),(1000108,17948,0.25),(1000108,17949,0.25),(1000108,17950,0.25),(1000108,17951,0.25),(1000108,17952,0.25),(1000108,17953,0.25),(1000108,17954,0.25),(1000108,17955,0.25),(1000108,17956,0.25),(1000108,17957,0.25),(1000108,17958,0.25),(1000108,17961,0.25),(1000108,17962,0.25),(1000108,17963,0.25),(1000108,17964,0.25),(1000108,17965,0.25),(1000108,17966,0.25),(1000108,17967,0.25),(1000108,17968,0.25),(1000108,17969,0.25),(1000108,17970,0.25),(1000108,17971,0.25),(1000108,17972,0.25),(1000108,20063,0.5),(1000108,20064,0.5),(1000108,24445,0.008957006369426),(1000108,27309,0.008957006369426),(1000109,1109,0.028799635060722),(1000109,3685,0.277841431972109),(1000109,3687,-0.0205014594378743),(1000109,9838,-0.0852532225570308),(1000109,9848,0.0892394994701594),(1000109,11129,0.0104501470014128),(1000109,11130,0.0104501470014128),(1000109,11628,0.36051874377244),(1000109,11629,0.166666),(1000109,11631,0.0919823516803695),(1000109,11859,0.0833261999999572),(1000109,11860,0.0833261999999572),(1000109,11870,0.0833261999999572),(1000109,11872,0.0833261999999572),(1000109,11873,0.0833261999999572),(1000109,11879,1),(1000109,11887,0.0833261999999572),(1000109,11889,0.0833261999999572),(1000109,11890,0.0833261999999572),(1000109,11891,0.0833261999999572),(1000109,12092,0.125),(1000109,12266,0.166666),(1000109,12270,0.166666),(1000109,13000,0.5),(1000109,17323,0.333333),(1000109,17329,0.333333),(1000109,17331,0.333333),(1000109,17337,0.333333),(1000109,17339,0.333333),(1000109,17341,0.333333),(1000109,17344,0.333333),(1000109,17345,0.333333),(1000109,17357,0.333333),(1000109,17366,0.006170382165605),(1000109,17367,0.006170382165605),(1000109,17368,0.006170382165605),(1000109,19719,0.124948677330786),(1000109,21945,0.333333),(1000109,21947,0.333333),(1000109,21961,0.0921994372275578),(1000109,21963,0.5),(1000109,21965,0.204253876738914),(1000109,21967,0.204253876738914),(1000109,22779,0.166666),(1000109,24445,0.006170382165605),(1000109,25562,0.166666),(1000109,25909,0.333333),(1000109,25911,0.333333),(1000109,25913,0.333333),(1000109,25915,0.333333),(1000109,25917,0.333333),(1000109,25919,0.333333),(1000109,25921,0.333333),(1000109,25925,0.333333),(1000109,25929,0.0833261999999572),(1000109,25931,0.0833261999999572),(1000109,25933,0.0833261999999572),(1000109,25935,0.0833261999999572),(1000109,25937,0.0833261999999572),(1000109,25949,0.0833261999999572),(1000109,25951,0.0833261999999572),(1000109,25953,0.0833261999999572),(1000109,25955,0.0833261999999572),(1000109,25957,0.0833261999999572),(1000109,25997,0.333333),(1000109,25999,0.333333),(1000109,26001,0.333333),(1000109,26003,0.333333),(1000109,26005,0.333333),(1000109,26007,0.333333),(1000109,26009,0.333333),(1000109,26097,0.333333),(1000109,26101,0.333333),(1000109,26103,0.333333),(1000109,26105,0.333333),(1000109,27309,0.006170382165605),(1000109,27939,0.333333),(1000109,27967,0.333333),(1000109,27969,0.333333),(1000109,27975,0.333333),(1000109,27977,0.333333),(1000109,27983,0.333333),(1000109,28005,0.333333),(1000109,28007,0.333333),(1000109,28009,0.333333),(1000109,28029,0.333333),(1000109,28031,0.333333),(1000109,28033,0.333333),(1000109,28053,0.333333),(1000109,28055,0.333333),(1000109,28057,0.333333),(1000109,28106,0.333333),(1000109,28107,0.333333),(1000109,28108,0.333333),(1000109,28109,0.333333),(1000109,28110,0.333333),(1000109,28111,0.333333),(1000109,28112,0.333333),(1000109,28113,0.333333),(1000109,28114,0.333333),(1000109,28115,0.333333),(1000109,28116,0.333333),(1000109,28117,0.333333),(1000109,28118,0.333333),(1000109,28119,0.333333),(1000109,28120,0.333333),(1000109,28668,0.0388515761023048),(1000109,29000,0.0446542337425572),(1000109,29002,0.0446542337425572),(1000109,29004,0.0446542337425572),(1000109,29006,0.0446542337425572),(1000109,29008,0.0446542337425572),(1000109,29010,0.0446542337425572),(1000109,29012,0.0446542337425572),(1000109,29014,0.0446542337425572),(1000109,29016,0.0446542337425572),(1000110,521,0.053449425918251),(1000110,786,0.0299113469721742),(1000110,941,0.991013417193581),(1000110,954,0.703272210440022),(1000110,955,0.991013417193581),(1000110,1079,0.061386998871804),(1000110,1099,0.093386969754768),(1000110,1102,0.0409750377941017),(1000110,1105,0.0480687784917615),(1000110,1106,0.175126422319139),(1000110,1113,0.13748439037349),(1000110,1114,0.13748439037349),(1000110,1115,0.667661836471263),(1000110,1116,0.0404795471933393),(1000110,1121,0.0783335123635619),(1000110,1130,0.0167077803626003),(1000110,1131,0.0257574094744133),(1000110,1132,0.0256973880619697),(1000110,1133,0.0235478590506411),(1000110,1134,0.0266435035683536),(1000110,1135,0.0687280973351542),(1000110,1136,0.0686852905013471),(1000110,1193,0.31826157753149),(1000110,1240,0.852171452522368),(1000110,1245,0.166666),(1000110,1262,0.209544332002897),(1000110,1272,0.512652335567621),(1000110,1282,0.439149694184485),(1000110,1315,0.487136620293028),(1000110,1318,0.166666),(1000110,1334,0.166666),(1000110,1404,0.166666),(1000110,2047,0.053449425918251),(1000110,2604,0.166666),(1000110,3469,0.143488825622603),(1000110,3654,0.714763471098988),(1000110,3664,0.502333393243386),(1000110,3699,-0.0429266102448281),(1000110,3715,0.0484472176133507),(1000110,3725,-0.0705732491260387),(1000110,9836,0.0851328294202965),(1000110,10630,0.151849166878152),(1000110,11129,0.0157655263945202),(1000110,11130,0.0157655263945202),(1000110,11612,0.333333),(1000110,11619,0.25),(1000110,12258,0.333333),(1000110,12262,0.333333),(1000110,17366,0.011942675159235),(1000110,17367,0.011942675159235),(1000110,17368,0.011942675159235),(1000110,24445,0.011942675159235),(1000110,27309,0.011942675159235),(1000111,223,0.205711349660184),(1000111,224,0.289557901250612),(1000111,225,0.737485211986645),(1000111,231,0.513882492160365),(1000111,232,0.737485211986645),(1000111,233,0.737485211986645),(1000111,234,0.737485211986645),(1000111,785,0.185204412765351),(1000111,786,0.160553835933756),(1000111,811,0.376328965269567),(1000111,812,0.210310269856724),(1000111,813,0.20746765098154),(1000111,814,0.222300711833177),(1000111,879,0.316370958030392),(1000111,1026,0.206718584454413),(1000111,1032,0.119992370434269),(1000111,1100,0.2),(1000111,1102,0.219939927863953),(1000111,1113,0.737968981337161),(1000111,1114,0.737968981337161),(1000111,1130,0.0896816258274702),(1000111,1131,0.138256926332359),(1000111,1132,0.137934752007848),(1000111,1133,0.126396818642936),(1000111,1134,0.143013175053378),(1000111,1135,0.368908818243884),(1000111,1136,0.368679045864248),(1000111,1137,0.277885060411447),(1000111,1138,0.205711349660184),(1000111,1139,0.289557901250612),(1000111,1140,0.737485211986645),(1000111,1141,0.234127900905011),(1000111,1142,0.737485211986645),(1000111,1143,0.737485211986645),(1000111,1144,0.737485211986645),(1000111,1145,0.737485211986645),(1000111,1146,0.513882492160365),(1000111,1147,0.737485211986645),(1000111,1148,0.737485211986645),(1000111,1149,0.737485211986645),(1000111,1150,0.737485211986645),(1000111,1151,0.737485211986645),(1000111,1152,0.737485211986645),(1000111,1153,0.737485211986645),(1000111,1202,0.12037935492211),(1000111,1215,0.435189697193301),(1000111,1216,0.734739105044038),(1000111,1218,0.12037935492211),(1000111,1220,0.616717550573062),(1000111,1221,0.616717550573062),(1000111,1552,0.849541763561268),(1000111,1564,0.824686229345504),(1000111,1809,0.91513580515095),(1000111,1815,0.459354701870707),(1000111,1817,0.734739105044038),(1000111,2173,0.998313457629874),(1000111,2174,0.998313457629874),(1000111,2184,0.981755731251182),(1000111,2204,0.416057142835012),(1000111,2454,0.823232734974411),(1000111,2455,0.823232734974411),(1000111,2464,0.532142122826237),(1000111,2465,0.532142122826237),(1000111,2487,0.496581282014551),(1000111,2507,0.616717550573062),(1000111,2509,0.616717550573062),(1000111,2511,0.41026862332759),(1000111,2513,0.616717550573062),(1000111,2517,0.41026862332759),(1000111,2530,0.91513580515095),(1000111,2538,0.91513580515095),(1000111,2546,0.91513580515095),(1000111,3300,0.831443882599847),(1000111,3301,0.831443882599847),(1000111,3311,0.831443882599847),(1000111,3328,0.831443882599847),(1000111,3356,0.51150761983004),(1000111,3358,0.51150761983004),(1000111,3359,0.51150761983004),(1000111,3386,0.0766887475444758),(1000111,3413,0.831443882599847),(1000111,3416,0.831443882599847),(1000111,3426,0.831443882599847),(1000111,3436,0.831443882599847),(1000111,3449,0.831443882599847),(1000111,3455,0.831443882599847),(1000111,3651,0.479600966585332),(1000111,3687,0.706214743080774),(1000111,3689,0.279354189863063),(1000111,3695,-0.439799352365167),(1000111,3699,-0.230415298410062),(1000111,3897,0.91513580515095),(1000111,3907,0.91513580515095),(1000111,10247,0.12037935492211),(1000111,11129,0.0846239301931078),(1000111,11130,0.0846239301931078),(1000111,11395,0.51150761983004),(1000111,11562,0.119992370434269),(1000111,11629,0.166666),(1000111,11630,0.661655017102786),(1000111,11631,0.744861111192519),(1000111,12109,0.185204412765351),(1000111,12180,0.534606263836205),(1000111,12181,0.534606263836205),(1000111,12182,0.534606263836205),(1000111,12183,0.534606263836205),(1000111,12184,0.534606263836205),(1000111,12185,0.534606263836205),(1000111,12186,0.534606263836205),(1000111,12187,0.534606263836205),(1000111,12188,0.534606263836205),(1000111,12189,0.534606263836205),(1000111,12190,0.534606263836205),(1000111,12191,0.534606263836205),(1000111,12192,0.534606263836205),(1000111,12193,0.534606263836205),(1000111,12194,0.534606263836205),(1000111,12195,0.534606263836205),(1000111,15509,0.25),(1000111,15511,0.25),(1000111,16281,0.831443882599847),(1000111,17366,0.011942675159235),(1000111,17367,0.011942675159235),(1000111,17368,0.011942675159235),(1000111,17858,0.616717550573062),(1000111,17860,0.616717550573062),(1000111,17862,0.616717550573062),(1000111,17864,0.616717550573062),(1000111,18025,0.356404175890803),(1000111,18037,0.185204412765351),(1000111,18039,0.185204412765351),(1000111,18041,0.185204412765351),(1000111,18043,0.185204412765351),(1000111,18045,0.185204412765351),(1000111,18047,0.185204412765351),(1000111,18049,0.185204412765351),(1000111,18051,0.185204412765351),(1000111,18053,0.185204412765351),(1000111,18055,0.185204412765351),(1000111,18057,0.185204412765351),(1000111,18059,0.185204412765351),(1000111,18061,0.185204412765351),(1000111,18063,0.185204412765351),(1000111,18065,0.185204412765351),(1000111,18067,0.185204412765351),(1000111,22578,0.0766887475444758),(1000111,24445,0.011942675159235),(1000111,25562,0.166666),(1000111,27309,0.011942675159235),(1000112,42,-0.784875119846291),(1000112,3715,-0.231208244753861),(1000112,3812,0.319019705724982),(1000112,9844,0.569086895627965),(1000112,11129,0.0700654303527933),(1000112,11130,0.0700654303527933),(1000112,17366,0.003980891719745),(1000112,17367,0.003980891719745),(1000112,17368,0.003980891719745),(1000112,24445,0.003980891719745),(1000112,27309,0.003980891719745),(1000113,41,0.190427838655233),(1000113,3647,-0.301500031384394),(1000113,3812,0.209495786336995),(1000113,9850,-0.184607982548322),(1000113,11129,0.0460109898021543),(1000113,11130,0.0460109898021543),(1000113,17366,0.008957006369426),(1000113,17367,0.008957006369426),(1000113,17368,0.008957006369426),(1000113,24445,0.008957006369426),(1000113,27309,0.008957006369426),(1000114,3645,0.110915465235688),(1000114,3717,-0.345295318811076),(1000114,3812,-0.137794646270203),(1000114,3814,0.87683763504268),(1000114,11129,0.0364970436328761),(1000114,11130,0.0364970436328761),(1000114,17366,0.003980891719745),(1000114,17367,0.003980891719745),(1000114,17368,0.003980891719745),(1000114,24445,0.003980891719745),(1000114,27309,0.003980891719745),(1000115,1130,0.00151507385404694),(1000115,1131,0.00233570090076233),(1000115,1132,0.00233025811478461),(1000115,1133,0.00213533723763032),(1000115,1134,0.00241605256716078),(1000115,1135,0.00623231458943357),(1000115,1136,0.00622843283415141),(1000115,1137,0.00469456687002521),(1000115,1202,0.0020336787109591),(1000115,1218,0.0020336787109591),(1000115,2204,0.00702883442491871),(1000115,2464,0.00898996432649542),(1000115,2465,0.00898996432649542),(1000115,3300,0.0140463431166794),(1000115,3301,0.0140463431166794),(1000115,3302,0.0833333333333333),(1000115,3303,0.0833333333333333),(1000115,3304,0.0833333333333333),(1000115,3305,0.0833333333333333),(1000115,3306,0.0833333333333333),(1000115,3307,0.0833333333333333),(1000115,3308,0.0833333333333333),(1000115,3309,0.0833333333333333),(1000115,3310,0.0833333333333333),(1000115,3311,0.0140463431166794),(1000115,3312,0.0833333333333333),(1000115,3315,0.0833333333333333),(1000115,3316,0.0833333333333333),(1000115,3317,0.0833333333333333),(1000115,3318,0.0833333333333333),(1000115,3319,0.0833333333333333),(1000115,3320,0.0833333333333333),(1000115,3321,0.0833333333333333),(1000115,3322,0.0833333333333333),(1000115,3323,0.0833333333333333),(1000115,3324,0.0833333333333333),(1000115,3325,0.0833333333333333),(1000115,3326,0.0833333333333333),(1000115,3327,0.0833333333333333),(1000115,3328,0.0140463431166794),(1000115,3329,0.0833333333333333),(1000115,3330,0.0833333333333333),(1000115,3331,0.0833333333333333),(1000115,3332,0.0833333333333333),(1000115,3333,0.0833333333333333),(1000115,3334,0.0833333333333333),(1000115,3335,0.0833333333333333),(1000115,3336,0.0833333333333333),(1000115,3337,0.0833333333333333),(1000115,3338,0.0833333333333333),(1000115,3339,0.0833333333333333),(1000115,3340,0.0833333333333333),(1000115,3341,0.0833333333333333),(1000115,3342,0.0833333333333333),(1000115,3343,0.0833333333333333),(1000115,3344,0.0833333333333333),(1000115,3345,0.0833333333333333),(1000115,3346,0.0833333333333333),(1000115,3347,0.0833333333333333),(1000115,3348,0.0833333333333333),(1000115,3349,0.083333333333),(1000115,3350,0.083333333333),(1000115,3351,0.0833333333333333),(1000115,3352,0.0833333333333333),(1000115,3354,0.0833333333333333),(1000115,3355,0.0833333333333333),(1000115,3356,0.0086413667660438),(1000115,3357,0.141653025100043),(1000115,3358,0.0086413667660438),(1000115,3359,0.0086413667660438),(1000115,3361,0.0833333333333333),(1000115,3363,0.0833333333333333),(1000115,3368,0.0833333333333333),(1000115,3373,0.0833333333333333),(1000115,3374,0.0176898701327485),(1000115,3375,0.0833333333333333),(1000115,3376,0.0833333333333333),(1000115,3377,0.0833333333333333),(1000115,3378,0.0833333333333333),(1000115,3379,0.0833333333333333),(1000115,3380,0.0833333333333333),(1000115,3385,0.0833333333333333),(1000115,3386,0.0769426043712937),(1000115,3387,0.0833333333333333),(1000115,3388,0.0833333333333333),(1000115,3389,0.0833333333333333),(1000115,3392,0.0833333333333333),(1000115,3393,0.0833333333333333),(1000115,3394,0.0833333333333333),(1000115,3395,0.083333),(1000115,3396,0.0834671082709957),(1000115,3397,0.0834671082709957),(1000115,3398,0.0834671082709957),(1000115,3400,0.0833333333333333),(1000115,3402,0.0833333333333333),(1000115,3403,0.0833333333333333),(1000115,3405,0.0833333333333333),(1000115,3406,0.0833333333333333),(1000115,3409,0.0833333333333333),(1000115,3410,0.0833333333333333),(1000115,3411,0.0833333333333333),(1000115,3412,0.0833333333333333),(1000115,3413,0.0140463431166794),(1000115,3416,0.0140463431166794),(1000115,3417,0.0833333333333333),(1000115,3418,0.0833333333333333),(1000115,3419,0.0833333333333333),(1000115,3420,0.0833333333333333),(1000115,3421,0.0833333333333333),(1000115,3422,0.0833333333333333),(1000115,3423,0.0833333333333333),(1000115,3424,0.0833333333333333),(1000115,3425,0.0833333333333333),(1000115,3426,0.0140463431166794),(1000115,3427,0.0833333333333333),(1000115,3428,0.0833333333333333),(1000115,3429,0.0833333333333333),(1000115,3430,0.0833347229398383),(1000115,3431,0.0833333333333333),(1000115,3432,0.0833333333333333),(1000115,3433,0.0833333333333333),(1000115,3434,0.0833333333333333),(1000115,3435,0.0833333333333333),(1000115,3436,0.0140463431166794),(1000115,3437,0.0833333333333333),(1000115,3438,0.0833333333333333),(1000115,3439,0.0833333333333333),(1000115,3441,0.0833333333333333),(1000115,3442,0.0833333333333333),(1000115,3443,0.0833347229398383),(1000115,3444,0.0833347229398383),(1000115,3446,0.0833347229398383),(1000115,3447,0.0833347229398383),(1000115,3449,0.0140463431166794),(1000115,3450,0.0833333333333333),(1000115,3451,0.0833333333333333),(1000115,3452,0.0833333333333333),(1000115,3453,0.0833333333333333),(1000115,3454,0.0833333333333333),(1000115,3455,0.0140463431166794),(1000115,3456,0.0833333333333333),(1000115,3551,0.0833333333333333),(1000115,3687,-0.00280469668151702),(1000115,3697,-0.00530129468378037),(1000115,3699,0.00800103299267261),(1000115,3731,0.0833333333333333),(1000115,3732,0.0833333333333333),(1000115,9850,0.00711366442245851),(1000115,10039,0.0833333333333333),(1000115,10040,0.0833333333333333),(1000115,10247,0.0020336787109591),(1000115,11082,0.16680542387399),(1000115,11129,0.00142962956881407),(1000115,11130,0.00142962956881407),(1000115,11207,0.0833333333333333),(1000115,11395,0.0086413667660438),(1000115,11433,0.0833333333333333),(1000115,11441,0.0833333333333333),(1000115,11442,0.0833333333333333),(1000115,11443,0.0833333333333333),(1000115,11444,0.0833333333333333),(1000115,11445,0.0833333333333333),(1000115,11446,0.0833333333333333),(1000115,11447,0.0833333333333333),(1000115,11448,0.0833333333333333),(1000115,11449,0.0833333333333333),(1000115,11450,0.0833333333333333),(1000115,11451,0.0833333333333333),(1000115,11452,0.0833333333333333),(1000115,11453,0.0833333333333333),(1000115,11454,0.0833333333333333),(1000115,11455,0.0833333333333333),(1000115,11487,0.0833333333333333),(1000115,11529,0.0833333333333333),(1000115,11566,0.0833333333333333),(1000115,11569,0.0833333333333333),(1000115,11572,0.0833333333333333),(1000115,11574,0.0833333333333333),(1000115,11579,0.0794109022321027),(1000115,11584,0.0833333333333333),(1000115,12093,0.0854957859524303),(1000115,12097,0.0833333333333333),(1000115,12098,0.0833333333333333),(1000115,12099,0.0833333333333333),(1000115,12179,0.0833333333333333),(1000115,12180,0.00903159331774576),(1000115,12181,0.00903159331774576),(1000115,12182,0.00903159331774576),(1000115,12183,0.00903159331774576),(1000115,12184,0.00903159331774576),(1000115,12185,0.00903159331774576),(1000115,12186,0.00903159331774576),(1000115,12187,0.00903159331774576),(1000115,12188,0.00903159331774576),(1000115,12189,0.00903159331774576),(1000115,12190,0.00903159331774576),(1000115,12191,0.00903159331774576),(1000115,12192,0.00903159331774576),(1000115,12193,0.00903159331774576),(1000115,12194,0.00903159331774576),(1000115,12195,0.00903159331774576),(1000115,12196,0.0860861788631451),(1000115,12206,0.16680542387399),(1000115,12207,0.166801359862806),(1000115,12210,0.333333333333333),(1000115,12211,0.333333333333333),(1000115,12212,0.333333333333333),(1000115,12241,0.0833333333333333),(1000115,12305,0.0833333333333333),(1000115,12365,0.0833333333333333),(1000115,12366,0.0833333333333333),(1000115,12367,0.0833333333333333),(1000115,12376,0.0833347229398383),(1000115,12383,0.0833347229398383),(1000115,12385,0.0833347229398383),(1000115,12386,0.0833347229398383),(1000115,12387,0.0833347229398383),(1000115,12486,0.333333333333333),(1000115,12836,-0.0476190476190476),(1000115,13278,0.0833333333333333),(1000115,16069,0.0834076317088146),(1000115,16281,0.0140463431166794),(1000115,16594,0.0833347229398383),(1000115,16595,0.0833347229398383),(1000115,16596,0.0833347229398383),(1000115,16597,0.0833347229398383),(1000115,16598,0.0833347229398383),(1000115,16622,0.0833347229398383),(1000115,17366,0.001990445859872),(1000115,17367,0.001990445859872),(1000115,17368,0.001990445859872),(1000115,17940,0.0833333333333333),(1000115,18025,0.0060210622118305),(1000115,18580,0.0833347229398383),(1000115,19400,-0.0712880734155818),(1000115,19759,0.0833333333333333),(1000115,19760,0.0833333333333333),(1000115,19761,0.0833333333333333),(1000115,19766,0.0833333333333333),(1000115,19767,0.0833333333333333),(1000115,19921,0.0833333333333333),(1000115,19922,0.0833333333333333),(1000115,20342,0.0833333333333333),(1000115,20494,0.0833333333333333),(1000115,20495,0.0833333333333333),(1000115,20527,0.333333333333333),(1000115,20531,0.333333333333333),(1000115,20533,0.0833333333333333),(1000115,21059,0.0833333333333333),(1000115,21603,0.0833333333333333),(1000115,21610,0.0833333333333333),(1000115,21611,0.0833333333333333),(1000115,21666,0.166801359862806),(1000115,21718,0.0833333333333333),(1000115,21803,0.0833333333333333),(1000115,21853,0.0833333333333333),(1000115,21855,0.0833333333333333),(1000115,21857,0.0833333333333333),(1000115,22043,0.0833333333333333),(1000115,22176,0.0833333333333333),(1000115,22178,0.0833333333333333),(1000115,22242,0.0833333333333333),(1000115,22551,0.0833333333333333),(1000115,22578,0.0769426043712937),(1000115,22761,0.0833333333333333),(1000115,22806,0.0833333333333333),(1000115,22807,0.0833333333333333),(1000115,22808,0.0833333333333333),(1000115,22809,0.0833333333333333),(1000115,23069,0.0833333333333333),(1000115,23566,0.0833333333333333),(1000115,23594,0.0833333333333333),(1000115,23606,0.0833333333333333),(1000115,23618,0.0833333333333333),(1000115,23950,0.0833333333333333),(1000115,24241,0.0833333333333333),(1000115,24242,0.0833347229398383),(1000115,24268,0.0833347229398383),(1000115,24270,0.0833347229398383),(1000115,24311,0.0833333333333333),(1000115,24312,0.0833333333333333),(1000115,24313,0.0833333333333333),(1000115,24314,0.0833333333333333),(1000115,24445,0.001990445859872),(1000115,24562,0.0833333333333333),(1000115,24563,0.0833333333333333),(1000115,24568,0.0834076317088146),(1000115,24571,0.0833333333333333),(1000115,24572,0.0833333333333333),(1000115,24606,0.0833333333333333),(1000115,24613,0.0833333333333333),(1000115,24624,0.0833333333333333),(1000115,24625,0.0833333333333333),(1000115,24764,0.0833333333333333),(1000115,25233,0.0833347229398383),(1000115,25235,0.0833347229398383),(1000115,25739,0.0833333333333333),(1000115,25810,0.0833333333333333),(1000115,25811,0.0833333333333333),(1000115,25862,0.0833333333333333),(1000115,25863,0.0833333333333333),(1000115,26252,0.0833333333333333),(1000115,26253,0.0833333333333333),(1000115,26254,0.0833333333333333),(1000115,26255,0.0833333333333333),(1000115,26256,0.0833333333333333),(1000115,26257,0.0833333333333333),(1000115,26258,0.0833333333333333),(1000115,26259,0.0833333333333333),(1000115,26260,0.0833333333333333),(1000115,26261,0.0833333333333333),(1000115,27309,0.001990445859872),(1000115,27902,0.0834076317088146),(1000115,27906,0.0833333333333333),(1000115,27911,0.0833333333333333),(1000115,27936,0.0834076317088146),(1000115,28164,0.0833333333333333),(1000115,28374,0.0833333333333333),(1000115,28585,0.0833333333333333),(1000115,28609,0.0854957859524303),(1000115,28615,0.0854957859524303),(1000115,28656,0.0854957859524303),(1000115,28667,0.0854957859524303),(1000115,28879,0.0833333333333333),(1000115,28880,0.0833333333333333),(1000116,42,-0.00160147546872809),(1000116,44,0.00784210427717108),(1000116,3699,-0.000389261669792987),(1000116,3812,0.000650934422356853),(1000116,11129,0.000142962956881407),(1000116,11130,0.000142962956881407),(1000116,17366,0.000398089171974),(1000116,17367,0.000398089171974),(1000116,17368,0.000398089171974),(1000116,24445,0.000398089171974),(1000116,27309,0.000398089171974),(1000117,42,-0.00160147546872809),(1000117,3647,0.000478547388452215),(1000117,3812,0.000650934422356853),(1000117,3814,-0.00282088783215561),(1000117,11129,0.000142962956881407),(1000117,11130,0.000142962956881407),(1000117,12836,-0.0801667468334135),(1000117,17366,0.000398089171974),(1000117,17367,0.000398089171974),(1000117,17368,0.000398089171974),(1000117,24445,0.000398089171974),(1000117,27309,0.000398089171974),(1000118,3683,0.00140886512751823),(1000118,3695,0.000340845479652617),(1000118,3715,-0.000471762096642204),(1000118,3777,-0.00446540193482423),(1000118,11129,0.000142962956881407),(1000118,11130,0.000142962956881407),(1000118,17366,0.000398089171974),(1000118,17367,0.000398089171974),(1000118,17368,0.000398089171974),(1000118,24445,0.000398089171974),(1000118,27309,0.000398089171974),(1000119,42,-0.00160147546872809),(1000119,45,0.0267959442890426),(1000119,3812,-0.000539756871032445),(1000119,3814,0.00343467000427627),(1000119,11129,0.000142962956881407),(1000119,11130,0.000142962956881407),(1000119,17366,0.00796178343949),(1000119,17367,0.00796178343949),(1000119,17368,0.00796178343949),(1000119,24445,0.00796178343949),(1000119,27309,0.00796178343949),(1000120,43,-0.000935903587601748),(1000120,44,0.000998002996004994),(1000120,223,0.000347527026272295),(1000120,224,0.000489176686271816),(1000120,225,0.00124590132272667),(1000120,231,0.000868148765971825),(1000120,232,0.00124590132272667),(1000120,233,0.00124590132272667),(1000120,234,0.00124590132272667),(1000120,788,0.5),(1000120,790,0.25),(1000120,811,0.00063576699300406),(1000120,812,0.000355296403424345),(1000120,813,0.000350494106972787),(1000120,814,0.000375552955387329),(1000120,939,1),(1000120,940,1),(1000120,941,0.00898658280641912),(1000120,954,0.00637732430754582),(1000120,955,0.00898658280641912),(1000120,956,1),(1000120,971,1),(1000120,972,1),(1000120,978,1),(1000120,979,1),(1000120,985,1),(1000120,989,1),(1000120,990,1),(1000120,991,1),(1000120,992,1),(1000120,995,1),(1000120,999,1),(1000120,1002,1),(1000120,1113,0.00124671859860408),(1000120,1114,0.00124671859860408),(1000120,1117,0.0175771808434475),(1000120,1118,0.0175771808434475),(1000120,1119,0.0175771808434475),(1000120,1120,0.0175771808434475),(1000120,1122,0.0175771808434475),(1000120,1123,0.0175771808434475),(1000120,1124,0.5),(1000120,1125,0.0175771808434475),(1000120,1126,0.0175771808434475),(1000120,1130,0.000151507385404694),(1000120,1131,0.000233570090076233),(1000120,1132,0.000233025811478461),(1000120,1133,0.000213533723763032),(1000120,1134,0.000241605256716078),(1000120,1135,0.000623231458943357),(1000120,1136,0.000622843283415141),(1000120,1137,0.000469456687002521),(1000120,1138,0.000347527026272295),(1000120,1139,0.000489176686271816),(1000120,1140,0.00124590132272667),(1000120,1141,0.00039553370926447),(1000120,1142,0.00124590132272667),(1000120,1143,0.00124590132272667),(1000120,1144,0.00124590132272667),(1000120,1145,0.00124590132272667),(1000120,1146,0.000868148765971825),(1000120,1147,0.00124590132272667),(1000120,1148,0.00124590132272667),(1000120,1149,0.00124590132272667),(1000120,1150,0.00124590132272667),(1000120,1151,0.00124590132272667),(1000120,1152,0.00124590132272667),(1000120,1153,0.00124590132272667),(1000120,1204,0.0130422067216992),(1000120,1214,0.25),(1000120,1220,0.00104187744990559),(1000120,1221,0.00104187744990559),(1000120,1275,0.0130422067216992),(1000120,1285,0.0130422067216992),(1000120,1295,0.0130422067216992),(1000120,2019,0.00205347926444682),(1000120,2020,0.00206620801036276),(1000120,2173,0.00168654237012608),(1000120,2174,0.00168654237012608),(1000120,2184,0.00165856988625622),(1000120,2194,0.25),(1000120,2204,0.000702883442491871),(1000120,2445,0.25),(1000120,2454,0.00139076246783791),(1000120,2455,0.00139076246783791),(1000120,2464,0.000898996432649542),(1000120,2465,0.000898996432649542),(1000120,2477,0.25),(1000120,2487,0.000838920246870573),(1000120,2507,0.00104187744990559),(1000120,2509,0.00104187744990559),(1000120,2511,0.000693104366255889),(1000120,2513,0.00104187744990559),(1000120,2517,0.000693104366255889),(1000120,3293,0.000604281162378804),(1000120,3296,0.25),(1000120,3297,0.000604281162378804),(1000120,3465,0.25),(1000120,3466,0.25),(1000120,3467,0.25),(1000120,3529,0.00164836942295552),(1000120,3539,0.25),(1000120,3556,0.000523674314089263),(1000120,3948,0.5),(1000120,3978,0.25),(1000120,3982,0.25),(1000120,3988,0.25),(1000120,3994,0.25),(1000120,9842,-0.00224536225994577),(1000120,9846,0.00351370086554458),(1000120,9852,0.000789829896901656),(1000120,9945,0.25),(1000120,10630,0.00137697945210535),(1000120,10837,0.25),(1000120,10839,0.25),(1000120,10841,0.25),(1000120,11129,0.000142962956881407),(1000120,11130,0.000142962956881407),(1000120,11356,0.5),(1000120,11358,0.5),(1000120,11360,0.5),(1000120,11488,0.25),(1000120,11489,0.25),(1000120,11613,0.25),(1000120,12344,1),(1000120,12345,0.305887571162626),(1000120,12354,1),(1000120,12355,0.305887571162626),(1000120,15509,0.5),(1000120,15511,0.5),(1000120,15596,-0.090909090909),(1000120,15597,-0.090909090909),(1000120,15598,-0.090909090909),(1000120,15599,-0.090909090909),(1000120,15600,-0.090909090909),(1000120,15601,-0.090909090909),(1000120,15602,-0.090909090909),(1000120,15604,-0.090909090909),(1000120,15605,-0.090909090909),(1000120,15607,-0.090909090909),(1000120,15608,-0.090909090909),(1000120,15609,-0.090909090909),(1000120,15610,-0.090909090909),(1000120,15611,-0.090909090909),(1000120,15612,-0.090909090909),(1000120,15613,-0.090909090909),(1000120,15614,-0.090909090909),(1000120,15615,-0.090909090909),(1000120,15617,-0.090909090909),(1000120,15618,-0.090909090909),(1000120,15619,-0.090909090909),(1000120,15620,-0.090909090909),(1000120,15621,-0.090909090909),(1000120,15622,-0.090909090909),(1000120,15623,-0.090909090909),(1000120,15634,-0.090909090909),(1000120,15635,-0.090909090909),(1000120,15636,-0.090909090909),(1000120,15640,-0.090909090909),(1000120,15641,-0.090909090909),(1000120,15642,-0.090909090909),(1000120,15643,-0.090909090909),(1000120,15653,-0.090909090909),(1000120,15654,-0.090909090909),(1000120,15655,-0.090909090909),(1000120,15656,-0.090909090909),(1000120,15657,-0.090909090909),(1000120,15669,-0.090909090909),(1000120,15670,-0.090909090909),(1000120,15671,-0.090909090909),(1000120,15672,-0.090909090909),(1000120,15992,-0.090909090909),(1000120,15993,-0.090909090909),(1000120,15996,-0.090909090909),(1000120,15999,-0.090909090909),(1000120,16000,-0.090909090909),(1000120,16001,-0.090909090909),(1000120,16179,-0.090909090909),(1000120,16180,-0.090909090909),(1000120,16181,-0.090909090909),(1000120,16182,-0.090909090909),(1000120,16183,-0.090909090909),(1000120,16184,-0.090909090909),(1000120,16185,-0.090909090909),(1000120,16186,-0.090909090909),(1000120,16187,-0.090909090909),(1000120,16188,-0.090909090909),(1000120,16189,-0.090909090909),(1000120,16230,1),(1000120,16241,1),(1000120,17363,0.25),(1000120,17364,0.25),(1000120,17365,0.25),(1000120,17366,0.011942675159235),(1000120,17367,0.011942675159235),(1000120,17368,0.011942675159235),(1000120,17858,0.00104187744990559),(1000120,17860,0.00104187744990559),(1000120,17862,0.00104187744990559),(1000120,17864,0.00104187744990559),(1000120,17999,-0.090909090909),(1000120,19725,1),(1000120,20188,1),(1000120,20281,0.25),(1000120,20451,1),(1000120,20702,0.5),(1000120,21012,0.333333333333333),(1000120,21014,0.5),(1000120,21026,0.25),(1000120,21028,0.25),(1000120,21030,1),(1000120,21038,1),(1000120,21040,0.25),(1000120,21604,0.25),(1000120,22299,0.5),(1000120,22300,0.5),(1000120,22301,0.5),(1000120,22302,0.25),(1000120,22303,0.5),(1000120,22304,0.5),(1000120,22305,0.5),(1000120,23736,0.25),(1000120,23912,1),(1000120,23914,1),(1000120,23954,0.25),(1000120,24349,0.25),(1000120,24445,0.011942675159235),(1000120,24546,0.25),(1000120,24548,0.25),(1000120,24555,1),(1000120,24557,0.25),(1000120,24559,0.25),(1000120,24561,0.25),(1000120,24570,0.5),(1000120,24645,0.25),(1000120,24691,1),(1000120,24701,1),(1000120,26759,0.5),(1000120,27309,0.011942675159235),(1000120,27905,0.5),(1000120,27915,0.5),(1000120,27917,1),(1000120,27931,0.5),(1000120,27933,0.5),(1000120,27935,0.5),(1000120,27952,0.25),(1000120,28237,-0.090909090909),(1000120,28238,-0.090909090909),(1000120,28584,0.25),(1000120,28668,0.0706392292769178),(1000120,29000,0.0811895158955585),(1000120,29002,0.0811895158955585),(1000120,29004,0.0811895158955585),(1000120,29006,0.0811895158955585),(1000120,29008,0.0811895158955585),(1000120,29010,0.0811895158955585),(1000120,29012,0.0811895158955585),(1000120,29014,0.0811895158955585),(1000120,29016,0.0811895158955585),(1000121,3814,-0.00282088783215561),(1000121,9844,0.00116117670171694),(1000121,9852,-0.000548545833179662),(1000121,11129,0.000142962956881407),(1000121,11130,0.000142962956881407),(1000121,17366,0.005971337579617),(1000121,17367,0.005971337579617),(1000121,17368,0.005971337579617),(1000121,24445,0.005971337579617),(1000121,27309,0.005971337579617),(1000122,41,-0.000838149063805408),(1000122,3647,0.000478547388452215),(1000122,3814,-0.00282088783215561),(1000122,9836,0.000771990780202329),(1000122,11129,0.000142962956881407),(1000122,11130,0.000142962956881407),(1000122,17143,-1),(1000122,17366,0.00796178343949),(1000122,17367,0.00796178343949),(1000122,17368,0.00796178343949),(1000122,24445,0.00796178343949),(1000122,27309,0.00796178343949),(1000123,3691,0.00206851252230659),(1000123,9830,0.00551111828950973),(1000123,9844,-0.0151537338556737),(1000123,9846,-0.00137386165316677),(1000123,11134,0.000501630494939203),(1000123,11135,0.000501630494939203),(1000123,11278,0.00200012701678612),(1000123,11302,0.00200012701678612),(1000123,11304,0.00200012701678612),(1000123,11306,0.00200012701678612),(1000123,15587,-0.090909090909),(1000123,15588,-0.090909090909),(1000123,15589,-0.090909090909),(1000123,15590,-0.090909090909),(1000123,15591,-0.090909090909),(1000123,15592,-0.090909090909),(1000123,15593,-0.090909090909),(1000123,15594,-0.090909090909),(1000123,15625,-0.090909090909),(1000123,15626,-0.090909090909),(1000123,15627,-0.090909090909),(1000123,15628,-0.090909090909),(1000123,15629,-0.090909090909),(1000123,15630,-0.090909090909),(1000123,15631,-0.090909090909),(1000123,15632,-0.090909090909),(1000123,15646,-0.090909090909),(1000123,15647,-0.090909090909),(1000123,15648,-0.090909090909),(1000123,15649,-0.090909090909),(1000123,15650,-0.090909090909),(1000123,15660,-0.090909090909),(1000123,15661,-0.090909090909),(1000123,15662,-0.090909090909),(1000123,15663,-0.090909090909),(1000123,15664,-0.090909090909),(1000123,15666,-0.090909090909),(1000123,15673,-0.090909090909),(1000123,15674,-0.2),(1000123,15994,-0.090909090909),(1000123,15997,-0.090909090909),(1000123,15998,-0.090909090909),(1000123,16002,-0.090909090909),(1000123,17366,0.003980891719745),(1000123,17367,0.003980891719745),(1000123,17368,0.003980891719745),(1000123,24445,0.003980891719745),(1000123,27309,0.003980891719745),(1000123,28231,-0.090909090909),(1000123,28236,-0.090909090909),(1000123,28668,0.0193180720564088),(1000124,3703,0.35540138601438),(1000124,3709,0.622941980793766),(1000124,3713,-0.373409819552887),(1000124,15587,-0.090909090909),(1000124,15588,-0.090909090909),(1000124,15589,-0.090909090909),(1000124,15590,-0.090909090909),(1000124,15591,-0.090909090909),(1000124,15592,-0.090909090909),(1000124,15593,-0.090909090909),(1000124,15594,-0.090909090909),(1000124,15596,-0.090909090909),(1000124,15597,-0.090909090909),(1000124,15598,-0.090909090909),(1000124,15599,-0.090909090909),(1000124,15600,-0.090909090909),(1000124,15601,-0.090909090909),(1000124,15602,-0.090909090909),(1000124,15604,-0.090909090909),(1000124,15605,-0.090909090909),(1000124,15607,-0.090909090909),(1000124,15608,-0.090909090909),(1000124,15609,-0.090909090909),(1000124,15610,-0.090909090909),(1000124,15611,-0.090909090909),(1000124,15612,-0.090909090909),(1000124,15613,-0.090909090909),(1000124,15614,-0.090909090909),(1000124,15615,-0.090909090909),(1000124,15617,-0.090909090909),(1000124,15618,-0.090909090909),(1000124,15619,-0.090909090909),(1000124,15620,-0.090909090909),(1000124,15621,-0.090909090909),(1000124,15622,-0.090909090909),(1000124,15623,-0.090909090909),(1000124,15625,-0.090909090909),(1000124,15626,-0.090909090909),(1000124,15627,-0.090909090909),(1000124,15628,-0.090909090909),(1000124,15629,-0.090909090909),(1000124,15630,-0.090909090909),(1000124,15631,-0.090909090909),(1000124,15632,-0.090909090909),(1000124,15634,-0.090909090909),(1000124,15635,-0.090909090909),(1000124,15636,-0.090909090909),(1000124,15640,-0.090909090909),(1000124,15641,-0.090909090909),(1000124,15642,-0.090909090909),(1000124,15643,-0.090909090909),(1000124,15646,-0.090909090909),(1000124,15647,-0.090909090909),(1000124,15648,-0.090909090909),(1000124,15649,-0.090909090909),(1000124,15650,-0.090909090909),(1000124,15653,-0.090909090909),(1000124,15654,-0.090909090909),(1000124,15655,-0.090909090909),(1000124,15656,-0.090909090909),(1000124,15657,-0.090909090909),(1000124,15660,-0.090909090909),(1000124,15661,-0.090909090909),(1000124,15662,-0.090909090909),(1000124,15663,-0.090909090909),(1000124,15664,-0.090909090909),(1000124,15666,-0.090909090909),(1000124,15669,-0.090909090909),(1000124,15670,-0.090909090909),(1000124,15671,-0.090909090909),(1000124,15672,-0.090909090909),(1000124,15673,-0.090909090909),(1000124,15674,-0.2),(1000124,15981,-0.142857142857),(1000124,15992,-0.090909090909),(1000124,15993,-0.090909090909),(1000124,15994,-0.090909090909),(1000124,15996,-0.090909090909),(1000124,15997,-0.090909090909),(1000124,15998,-0.090909090909),(1000124,15999,-0.090909090909),(1000124,16000,-0.090909090909),(1000124,16001,-0.090909090909),(1000124,16002,-0.090909090909),(1000124,16118,-0.142857142857),(1000124,16119,-0.142857142857),(1000124,16120,-0.142857142857),(1000124,16121,-0.142857142857),(1000124,16122,-0.142857142857),(1000124,16123,-0.142857142857),(1000124,16124,-0.142857142857),(1000124,16125,-0.142857142857),(1000124,16179,-0.090909090909),(1000124,16180,-0.090909090909),(1000124,16181,-0.090909090909),(1000124,16182,-0.090909090909),(1000124,16183,-0.090909090909),(1000124,16184,-0.090909090909),(1000124,16185,-0.090909090909),(1000124,16186,-0.090909090909),(1000124,16187,-0.090909090909),(1000124,16188,-0.090909090909),(1000124,16189,-0.090909090909),(1000124,16617,-0.142857142857),(1000124,17366,0.004777070063694),(1000124,17367,0.004777070063694),(1000124,17368,0.004777070063694),(1000124,17999,-0.090909090909),(1000124,24445,0.004777070063694),(1000124,25266,0.0909413769009397),(1000124,25544,0.0909413769009397),(1000124,26224,0.0914931905852948),(1000124,27309,0.004777070063694),(1000124,28231,-0.090909090909),(1000124,28236,-0.090909090909),(1000124,28237,-0.090909090909),(1000124,28238,-0.090909090909),(1000124,29000,0.07362465699286),(1000124,29002,0.07362465699286),(1000124,29004,0.07362465699286),(1000124,29006,0.07362465699286),(1000124,29008,0.07362465699286),(1000124,29010,0.07362465699286),(1000124,29012,0.07362465699286),(1000124,29014,0.07362465699286),(1000124,29016,0.07362465699286),(1000125,3683,-0.000895497425485155),(1000125,3697,0.00032771024528126),(1000125,3812,0.000650934422356853),(1000125,9826,-0.000554197435505995),(1000125,9994,0.250062515628907),(1000125,9995,0.250000625001562),(1000125,10006,0.250000625001562),(1000125,10007,0.250000625001562),(1000125,10008,0.250062515628907),(1000125,10009,0.250000625001562),(1000125,10010,0.250062515628907),(1000125,10011,0.250000625001562),(1000125,11129,0.000142962956881407),(1000125,11130,0.000142962956881407),(1000125,17366,0.017914012738853),(1000125,17367,0.017914012738853),(1000125,17368,0.017914012738853),(1000125,17939,0.250062515628907),(1000125,18588,0.250062515628907),(1000125,18589,0.250000625001562),(1000125,18640,0.250062515628907),(1000125,19400,-0.0714232060346526),(1000125,19401,-0.5),(1000125,19402,-0.5),(1000125,19403,-0.5),(1000125,19404,-0.5),(1000125,19405,-0.5),(1000125,19406,-0.5),(1000125,19407,-0.5),(1000125,19408,-0.5),(1000125,19409,-0.5),(1000125,19410,-0.5),(1000125,19411,-0.5),(1000125,19412,-0.5),(1000125,19413,-0.5),(1000125,19414,-0.5),(1000125,19415,-0.5),(1000125,19416,-0.5),(1000125,19417,-0.5),(1000125,19418,-0.5),(1000125,19419,-0.5),(1000125,19420,-0.5),(1000125,19421,-0.5),(1000125,19422,-0.5),(1000125,24445,0.017914012738853),(1000125,25773,0.250000625001562),(1000125,25774,0.250000625001562),(1000125,25775,0.250000625001562),(1000125,25776,0.250000625001562),(1000125,25777,0.250000625001562),(1000125,25778,0.250000625001562),(1000125,25779,0.250000625001562),(1000125,25780,0.250000625001562),(1000125,25781,0.250000625001562),(1000125,25782,0.250000625001562),(1000125,25783,0.250000625001562),(1000125,25784,0.250000625001562),(1000125,25785,0.250000625001562),(1000125,25786,0.250000625001562),(1000125,25787,0.250000625001562),(1000125,25788,0.250000625001562),(1000125,25789,0.250000625001562),(1000125,25790,0.250000625001562),(1000125,25791,0.250000625001562),(1000125,25792,0.250000625001562),(1000125,25793,0.250000625001562),(1000125,25794,0.250000625001562),(1000125,25795,0.250000625001562),(1000125,25796,0.250000625001562),(1000125,25797,0.250000625001562),(1000125,25798,0.250000625001562),(1000125,25799,0.250000625001562),(1000125,25800,0.250000625001562),(1000125,25801,0.250000625001562),(1000125,25802,0.250000625001562),(1000125,25803,0.250000625001562),(1000125,25804,0.250000625001562),(1000125,26910,0.250000625001562),(1000125,27309,0.017914012738853),(1000126,3713,-0.002292786926788),(1000126,3721,0.0136481079125986),(1000126,3812,-0.000539756871032445),(1000126,3814,0.00343467000427627),(1000126,11134,0.000501630494939203),(1000126,11135,0.000501630494939203),(1000126,11585,0.00120519785745323),(1000126,17366,0.001990445859872),(1000126,17367,0.001990445859872),(1000126,17368,0.001990445859872),(1000126,24445,0.001990445859872),(1000126,27309,0.001990445859872),(1000127,3727,0.687629813633984),(1000127,9844,0.104266426644277),(1000127,9846,-0.123364208967927),(1000127,15587,-0.090909090909),(1000127,15588,-0.090909090909),(1000127,15589,-0.090909090909),(1000127,15590,-0.090909090909),(1000127,15591,-0.090909090909),(1000127,15592,-0.090909090909),(1000127,15593,-0.090909090909),(1000127,15594,-0.090909090909),(1000127,15596,-0.090909090909),(1000127,15597,-0.090909090909),(1000127,15598,-0.090909090909),(1000127,15599,-0.090909090909),(1000127,15600,-0.090909090909),(1000127,15601,-0.090909090909),(1000127,15602,-0.090909090909),(1000127,15604,-0.090909090909),(1000127,15605,-0.090909090909),(1000127,15607,-0.090909090909),(1000127,15608,-0.090909090909),(1000127,15609,-0.090909090909),(1000127,15610,-0.090909090909),(1000127,15611,-0.090909090909),(1000127,15612,-0.090909090909),(1000127,15613,-0.090909090909),(1000127,15614,-0.090909090909),(1000127,15615,-0.090909090909),(1000127,15617,-0.090909090909),(1000127,15618,-0.090909090909),(1000127,15619,-0.090909090909),(1000127,15620,-0.090909090909),(1000127,15621,-0.090909090909),(1000127,15622,-0.090909090909),(1000127,15623,-0.090909090909),(1000127,15625,-0.090909090909),(1000127,15626,-0.090909090909),(1000127,15627,-0.090909090909),(1000127,15628,-0.090909090909),(1000127,15629,-0.090909090909),(1000127,15630,-0.090909090909),(1000127,15631,-0.090909090909),(1000127,15632,-0.090909090909),(1000127,15634,-0.090909090909),(1000127,15635,-0.090909090909),(1000127,15636,-0.090909090909),(1000127,15640,-0.090909090909),(1000127,15641,-0.090909090909),(1000127,15642,-0.090909090909),(1000127,15643,-0.090909090909),(1000127,15646,-0.090909090909),(1000127,15647,-0.090909090909),(1000127,15648,-0.090909090909),(1000127,15649,-0.090909090909),(1000127,15650,-0.090909090909),(1000127,15653,-0.090909090909),(1000127,15654,-0.090909090909),(1000127,15655,-0.090909090909),(1000127,15656,-0.090909090909),(1000127,15657,-0.090909090909),(1000127,15660,-0.090909090909),(1000127,15661,-0.090909090909),(1000127,15662,-0.090909090909),(1000127,15663,-0.090909090909),(1000127,15664,-0.090909090909),(1000127,15666,-0.090909090909),(1000127,15669,-0.090909090909),(1000127,15670,-0.090909090909),(1000127,15671,-0.090909090909),(1000127,15672,-0.090909090909),(1000127,15673,-0.090909090909),(1000127,15981,-0.142857142857),(1000127,15992,-0.090909090909),(1000127,15993,-0.090909090909),(1000127,15994,-0.090909090909),(1000127,15996,-0.090909090909),(1000127,15997,-0.090909090909),(1000127,15998,-0.090909090909),(1000127,15999,-0.090909090909),(1000127,16000,-0.090909090909),(1000127,16001,-0.090909090909),(1000127,16002,-0.090909090909),(1000127,16118,-0.142857142857),(1000127,16119,-0.142857142857),(1000127,16120,-0.142857142857),(1000127,16121,-0.142857142857),(1000127,16122,-0.142857142857),(1000127,16123,-0.142857142857),(1000127,16124,-0.142857142857),(1000127,16125,-0.142857142857),(1000127,16179,-0.090909090909),(1000127,16180,-0.090909090909),(1000127,16181,-0.090909090909),(1000127,16182,-0.090909090909),(1000127,16183,-0.090909090909),(1000127,16184,-0.090909090909),(1000127,16185,-0.090909090909),(1000127,16186,-0.090909090909),(1000127,16187,-0.090909090909),(1000127,16188,-0.090909090909),(1000127,16189,-0.090909090909),(1000127,16617,-0.142857142857),(1000127,17366,0.001592356687898),(1000127,17367,0.001592356687898),(1000127,17368,0.001592356687898),(1000127,17999,-0.090909090909),(1000127,24445,0.001592356687898),(1000127,25266,0.0910556695805554),(1000127,25544,0.0910556695805554),(1000127,26224,0.0915272717987878),(1000127,27309,0.001592356687898),(1000127,28231,-0.090909090909),(1000127,28236,-0.090909090909),(1000127,28237,-0.090909090909),(1000127,28238,-0.090909090909),(1000127,29000,0.0444508866594392),(1000127,29002,0.0444508866594392),(1000127,29004,0.0444508866594392),(1000127,29006,0.0444508866594392),(1000127,29008,0.0444508866594392),(1000127,29010,0.0444508866594392),(1000127,29012,0.0444508866594392),(1000127,29014,0.0444508866594392),(1000127,29016,0.0444508866594392),(1000128,3643,0.010310898334222),(1000128,3727,0.140128372090714),(1000128,9834,-0.0969249628983665),(1000128,9844,-0.23398712396941),(1000128,15596,-0.090909090909),(1000128,15597,-0.090909090909),(1000128,15598,-0.090909090909),(1000128,15599,-0.090909090909),(1000128,15600,-0.090909090909),(1000128,15601,-0.090909090909),(1000128,15602,-0.090909090909),(1000128,15604,-0.090909090909),(1000128,15605,-0.090909090909),(1000128,15607,-0.090909090909),(1000128,15608,-0.090909090909),(1000128,15609,-0.090909090909),(1000128,15610,-0.090909090909),(1000128,15611,-0.090909090909),(1000128,15612,-0.090909090909),(1000128,15613,-0.090909090909),(1000128,15614,-0.090909090909),(1000128,15615,-0.090909090909),(1000128,15617,-0.090909090909),(1000128,15618,-0.090909090909),(1000128,15619,-0.090909090909),(1000128,15620,-0.090909090909),(1000128,15621,-0.090909090909),(1000128,15622,-0.090909090909),(1000128,15623,-0.090909090909),(1000128,15634,-0.090909090909),(1000128,15635,-0.090909090909),(1000128,15636,-0.090909090909),(1000128,15640,-0.090909090909),(1000128,15641,-0.090909090909),(1000128,15642,-0.090909090909),(1000128,15643,-0.090909090909),(1000128,15653,-0.090909090909),(1000128,15654,-0.090909090909),(1000128,15655,-0.090909090909),(1000128,15656,-0.090909090909),(1000128,15657,-0.090909090909),(1000128,15669,-0.090909090909),(1000128,15670,-0.090909090909),(1000128,15671,-0.090909090909),(1000128,15672,-0.090909090909),(1000128,15992,-0.090909090909),(1000128,15993,-0.090909090909),(1000128,15996,-0.090909090909),(1000128,15999,-0.090909090909),(1000128,16000,-0.090909090909),(1000128,16001,-0.090909090909),(1000128,16179,-0.090909090909),(1000128,16180,-0.090909090909),(1000128,16181,-0.090909090909),(1000128,16182,-0.090909090909),(1000128,16183,-0.090909090909),(1000128,16184,-0.090909090909),(1000128,16185,-0.090909090909),(1000128,16186,-0.090909090909),(1000128,16187,-0.090909090909),(1000128,16188,-0.090909090909),(1000128,16189,-0.090909090909),(1000128,17366,0.000199044585987),(1000128,17367,0.000199044585987),(1000128,17368,0.000199044585987),(1000128,17999,-0.090909090909),(1000128,24445,0.000199044585987),(1000128,27309,0.000199044585987),(1000128,28237,-0.090909090909),(1000128,28238,-0.090909090909),(1000129,785,0.0454870705025184),(1000129,1202,0.0295657329252046),(1000129,1218,0.0295657329252046),(1000129,3643,0.0970801654881481),(1000129,3685,-0.456752691593151),(1000129,3729,0.0930356193514088),(1000129,9826,0.0622313978619863),(1000129,9832,0.355882078183726),(1000129,10247,0.0295657329252046),(1000129,12109,0.0454870705025184),(1000129,12235,0.5),(1000129,12236,0.5),(1000129,12237,0.299999994372186),(1000129,12238,0.260886585942459),(1000129,12239,0.260886585942459),(1000129,13780,0.299999994372186),(1000129,14343,0.260886585942459),(1000129,15596,-0.090909090909),(1000129,15597,-0.090909090909),(1000129,15598,-0.090909090909),(1000129,15599,-0.090909090909),(1000129,15600,-0.090909090909),(1000129,15601,-0.090909090909),(1000129,15602,-0.090909090909),(1000129,15604,-0.090909090909),(1000129,15605,-0.090909090909),(1000129,15607,-0.090909090909),(1000129,15608,-0.090909090909),(1000129,15609,-0.090909090909),(1000129,15610,-0.090909090909),(1000129,15611,-0.090909090909),(1000129,15612,-0.090909090909),(1000129,15613,-0.090909090909),(1000129,15614,-0.090909090909),(1000129,15615,-0.090909090909),(1000129,15617,-0.090909090909),(1000129,15618,-0.090909090909),(1000129,15619,-0.090909090909),(1000129,15620,-0.090909090909),(1000129,15621,-0.090909090909),(1000129,15622,-0.090909090909),(1000129,15623,-0.090909090909),(1000129,15634,-0.090909090909),(1000129,15635,-0.090909090909),(1000129,15636,-0.090909090909),(1000129,15640,-0.090909090909),(1000129,15641,-0.090909090909),(1000129,15642,-0.090909090909),(1000129,15643,-0.090909090909),(1000129,15653,-0.090909090909),(1000129,15654,-0.090909090909),(1000129,15655,-0.090909090909),(1000129,15656,-0.090909090909),(1000129,15657,-0.090909090909),(1000129,15669,-0.090909090909),(1000129,15670,-0.090909090909),(1000129,15671,-0.090909090909),(1000129,15672,-0.090909090909),(1000129,15992,-0.090909090909),(1000129,15993,-0.090909090909),(1000129,15996,-0.090909090909),(1000129,15999,-0.090909090909),(1000129,16000,-0.090909090909),(1000129,16001,-0.090909090909),(1000129,16179,-0.090909090909),(1000129,16180,-0.090909090909),(1000129,16181,-0.090909090909),(1000129,16182,-0.090909090909),(1000129,16183,-0.090909090909),(1000129,16184,-0.090909090909),(1000129,16185,-0.090909090909),(1000129,16186,-0.090909090909),(1000129,16187,-0.090909090909),(1000129,16188,-0.090909090909),(1000129,16189,-0.090909090909),(1000129,16213,0.5),(1000129,16214,0.5),(1000129,16216,0.299999994372186),(1000129,16220,0.299999994372186),(1000129,16221,0.299999994372186),(1000129,16279,0.299999994372186),(1000129,16869,0.299999994372186),(1000129,17366,0.000796178343949),(1000129,17367,0.000796178343949),(1000129,17368,0.000796178343949),(1000129,17477,1),(1000129,17479,1),(1000129,17481,1),(1000129,17482,0.299999994372186),(1000129,17483,0.299999994372186),(1000129,17621,0.299999994372186),(1000129,17982,0.299999994372186),(1000129,17999,-0.090909090909),(1000129,18025,0.333333333333333),(1000129,18037,0.0454870705025184),(1000129,18039,0.0454870705025184),(1000129,18041,0.0454870705025184),(1000129,18043,0.0454870705025184),(1000129,18045,0.0454870705025184),(1000129,18047,0.0454870705025184),(1000129,18049,0.0454870705025184),(1000129,18051,0.0454870705025184),(1000129,18053,0.0454870705025184),(1000129,18055,0.0454870705025184),(1000129,18057,0.0454870705025184),(1000129,18059,0.0454870705025184),(1000129,18061,0.0454870705025184),(1000129,18063,0.0454870705025184),(1000129,18065,0.0454870705025184),(1000129,18067,0.0454870705025184),(1000129,18626,0.299999994372186),(1000129,18635,0.299999994372186),(1000129,18637,0.299999994372186),(1000129,19470,0.260886585942459),(1000129,20059,0.5),(1000129,20060,0.5),(1000129,20061,0.5),(1000129,20062,0.5),(1000129,20063,0.5),(1000129,20064,0.5),(1000129,20065,0.5),(1000129,20066,0.5),(1000129,20175,0.299999994372186),(1000129,22536,1),(1000129,22543,0.299999994372186),(1000129,22552,1),(1000129,22554,1),(1000129,22556,1),(1000129,22558,1),(1000129,22577,0.299999994372186),(1000129,24445,0.000796178343949),(1000129,24574,0.299999994372186),(1000129,24575,0.299999994372186),(1000129,24646,0.299999994372186),(1000129,24653,0.299999994372186),(1000129,24654,0.299999994372186),(1000129,24655,0.299999994372186),(1000129,24656,0.299999994372186),(1000129,24657,0.299999994372186),(1000129,24658,0.299999994372186),(1000129,24659,0.299999994372186),(1000129,24660,0.299999994372186),(1000129,27309,0.000796178343949),(1000129,27673,0.299999994372186),(1000129,27674,0.299999994372186),(1000129,27675,0.299999994372186),(1000129,27897,0.299999994372186),(1000129,28237,-0.090909090909),(1000129,28238,-0.090909090909),(1000129,28351,0.299999994372186),(1000129,28353,1),(1000129,28368,0.299999994372186),(1000129,28386,0.299999994372186),(1000129,28448,0.299999994372186),(1000129,28449,0.299999994372186),(1000129,28450,0.299999994372186),(1000129,28451,0.299999994372186),(1000129,28452,0.299999994372186),(1000129,28453,0.299999994372186),(1000129,28454,0.299999994372186),(1000129,28455,0.299999994372186),(1000129,28456,0.299999994372186),(1000129,28457,0.299999994372186),(1000129,28458,0.299999994372186),(1000129,28459,0.299999994372186),(1000129,28460,0.299999994372186),(1000129,28461,0.299999994372186),(1000129,28462,0.299999994372186),(1000129,28463,0.299999994372186),(1000129,28464,0.299999994372186),(1000129,28465,0.299999994372186),(1000129,28466,0.299999994372186),(1000129,28467,0.299999994372186),(1000129,28468,0.299999994372186),(1000129,28469,0.299999994372186),(1000129,28470,0.299999994372186),(1000129,28471,0.299999994372186),(1000129,28472,0.299999994372186),(1000129,28473,0.299999994372186),(1000129,28474,0.299999994372186),(1000129,28475,0.299999994372186),(1000129,28476,0.299999994372186),(1000129,28477,0.299999994372186),(1000129,28478,0.299999994372186),(1000129,28479,0.299999994372186),(1000129,28480,0.299999994372186),(1000129,28481,0.299999994372186),(1000129,28482,0.299999994372186),(1000129,28483,0.299999994372186),(1000129,28484,0.299999994372186),(1000129,28485,0.299999994372186),(1000129,28486,0.299999994372186),(1000129,28487,0.299999994372186),(1000129,28488,0.299999994372186),(1000129,28489,0.299999994372186),(1000129,28490,0.299999994372186),(1000129,28491,0.299999994372186),(1000129,28492,0.299999994372186),(1000129,28493,0.299999994372186),(1000129,28494,0.299999994372186),(1000129,28495,0.299999994372186),(1000129,28496,0.299999994372186),(1000129,28497,0.299999994372186),(1000129,28498,0.299999994372186),(1000129,28499,0.299999994372186),(1000129,28500,0.299999994372186),(1000129,28501,0.299999994372186),(1000129,28502,0.299999994372186),(1000129,28503,0.299999994372186),(1000129,28504,0.299999994372186),(1000129,28505,0.299999994372186),(1000130,43,0.119215179478419),(1000130,3683,-0.2215234495342),(1000130,3695,0.0843165644723994),(1000130,3713,-0.567177587131337),(1000130,11129,0.0353654253632508),(1000130,11130,0.0353654253632508),(1000130,17366,0.008957006369426),(1000130,17367,0.008957006369426),(1000130,17368,0.008957006369426),(1000130,24445,0.008957006369426),(1000130,27309,0.008957006369426),(1000131,42,-0.0409794545472343),(1000131,3695,-0.0190121310417199),(1000131,3771,0.421745181561301),(1000131,3814,0.0878882668348173),(1000131,17366,0.000398089171974),(1000131,17367,0.000398089171974),(1000131,17368,0.000398089171974),(1000131,24445,0.000398089171974),(1000131,27309,0.000398089171974),(1000132,3685,0.00380100228767376),(1000132,3814,0.00343467000427627),(1000132,9838,-0.00116630443368635),(1000132,9848,-0.000489941284499872),(1000132,9994,0.249812453113278),(1000132,9995,0.250000625001562),(1000132,10006,0.250000625001562),(1000132,10007,0.250000625001562),(1000132,10008,0.249812453113278),(1000132,10009,0.250000625001562),(1000132,10010,0.249812453113278),(1000132,10011,0.250000625001562),(1000132,11129,0.000142962956881407),(1000132,11130,0.000142962956881407),(1000132,17366,0.000398089171974),(1000132,17367,0.000398089171974),(1000132,17368,0.000398089171974),(1000132,17939,0.249812453113278),(1000132,18588,0.249812453113278),(1000132,18589,0.250000625001562),(1000132,18640,0.249812453113278),(1000132,24445,0.000398089171974),(1000132,25773,0.250000625001562),(1000132,25774,0.250000625001562),(1000132,25775,0.250000625001562),(1000132,25776,0.250000625001562),(1000132,25777,0.250000625001562),(1000132,25778,0.250000625001562),(1000132,25779,0.250000625001562),(1000132,25780,0.250000625001562),(1000132,25781,0.250000625001562),(1000132,25782,0.250000625001562),(1000132,25783,0.250000625001562),(1000132,25784,0.250000625001562),(1000132,25785,0.250000625001562),(1000132,25786,0.250000625001562),(1000132,25787,0.250000625001562),(1000132,25788,0.250000625001562),(1000132,25789,0.250000625001562),(1000132,25790,0.250000625001562),(1000132,25791,0.250000625001562),(1000132,25792,0.250000625001562),(1000132,25793,0.250000625001562),(1000132,25794,0.250000625001562),(1000132,25795,0.250000625001562),(1000132,25796,0.250000625001562),(1000132,25797,0.250000625001562),(1000132,25798,0.250000625001562),(1000132,25799,0.250000625001562),(1000132,25800,0.250000625001562),(1000132,25801,0.250000625001562),(1000132,25802,0.250000625001562),(1000132,25803,0.250000625001562),(1000132,25804,0.250000625001562),(1000132,26910,0.250000625001562),(1000132,27309,0.000398089171974),(1000133,3707,1),(1000133,3729,-0.252839564715059),(1000133,3773,-0.0920585091792001),(1000133,3824,1),(1000133,9844,0.324324324324324),(1000133,17366,0.003184713375796),(1000133,17367,0.003184713375796),(1000133,17368,0.003184713375796),(1000133,24445,0.003184713375796),(1000133,25266,0.0906636199815191),(1000133,25544,0.0906636199815191),(1000133,26224,0.0916295154392668),(1000133,27309,0.003184713375796),(1000134,3721,0.360012458593965),(1000134,3771,0.130741006284003),(1000134,3775,0.358945918488078),(1000134,3822,1),(1000134,9844,-0.399728154055968),(1000134,15587,-0.090909090909),(1000134,15588,-0.090909090909),(1000134,15589,-0.090909090909),(1000134,15590,-0.090909090909),(1000134,15591,-0.090909090909),(1000134,15592,-0.090909090909),(1000134,15593,-0.090909090909),(1000134,15594,-0.090909090909),(1000134,15596,-0.090909090909),(1000134,15597,-0.090909090909),(1000134,15598,-0.090909090909),(1000134,15599,-0.090909090909),(1000134,15600,-0.090909090909),(1000134,15601,-0.090909090909),(1000134,15602,-0.090909090909),(1000134,15604,-0.090909090909),(1000134,15605,-0.090909090909),(1000134,15607,-0.090909090909),(1000134,15608,-0.090909090909),(1000134,15609,-0.090909090909),(1000134,15610,-0.090909090909),(1000134,15611,-0.090909090909),(1000134,15612,-0.090909090909),(1000134,15613,-0.090909090909),(1000134,15614,-0.090909090909),(1000134,15615,-0.090909090909),(1000134,15617,-0.090909090909),(1000134,15618,-0.090909090909),(1000134,15619,-0.090909090909),(1000134,15620,-0.090909090909),(1000134,15621,-0.090909090909),(1000134,15622,-0.090909090909),(1000134,15623,-0.090909090909),(1000134,15625,-0.090909090909),(1000134,15626,-0.090909090909),(1000134,15627,-0.090909090909),(1000134,15628,-0.090909090909),(1000134,15629,-0.090909090909),(1000134,15630,-0.090909090909),(1000134,15631,-0.090909090909),(1000134,15632,-0.090909090909),(1000134,15634,-0.090909090909),(1000134,15635,-0.090909090909),(1000134,15636,-0.090909090909),(1000134,15640,-0.090909090909),(1000134,15641,-0.090909090909),(1000134,15642,-0.090909090909),(1000134,15643,-0.090909090909),(1000134,15646,-0.090909090909),(1000134,15647,-0.090909090909),(1000134,15648,-0.090909090909),(1000134,15649,-0.090909090909),(1000134,15650,-0.090909090909),(1000134,15653,-0.090909090909),(1000134,15654,-0.090909090909),(1000134,15655,-0.090909090909),(1000134,15656,-0.090909090909),(1000134,15657,-0.090909090909),(1000134,15660,-0.090909090909),(1000134,15661,-0.090909090909),(1000134,15662,-0.090909090909),(1000134,15663,-0.090909090909),(1000134,15664,-0.090909090909),(1000134,15666,-0.090909090909),(1000134,15669,-0.090909090909),(1000134,15670,-0.090909090909),(1000134,15671,-0.090909090909),(1000134,15672,-0.090909090909),(1000134,15673,-0.090909090909),(1000134,15981,-0.142857142857),(1000134,15992,-0.090909090909),(1000134,15993,-0.090909090909),(1000134,15994,-0.090909090909),(1000134,15996,-0.090909090909),(1000134,15997,-0.090909090909),(1000134,15998,-0.090909090909),(1000134,15999,-0.090909090909),(1000134,16000,-0.090909090909),(1000134,16001,-0.090909090909),(1000134,16002,-0.090909090909),(1000134,16118,-0.142857142857),(1000134,16119,-0.142857142857),(1000134,16120,-0.142857142857),(1000134,16121,-0.142857142857),(1000134,16122,-0.142857142857),(1000134,16123,-0.142857142857),(1000134,16124,-0.142857142857),(1000134,16125,-0.142857142857),(1000134,16179,-0.090909090909),(1000134,16180,-0.090909090909),(1000134,16181,-0.090909090909),(1000134,16182,-0.090909090909),(1000134,16183,-0.090909090909),(1000134,16184,-0.090909090909),(1000134,16185,-0.090909090909),(1000134,16186,-0.090909090909),(1000134,16187,-0.090909090909),(1000134,16188,-0.090909090909),(1000134,16189,-0.090909090909),(1000134,16617,-0.142857142857),(1000134,17366,0.000398089171974),(1000134,17367,0.000398089171974),(1000134,17368,0.000398089171974),(1000134,17999,-0.090909090909),(1000134,24445,0.000398089171974),(1000134,25266,0.0909173530460698),(1000134,25544,0.0909173530460698),(1000134,26224,0.0892531876138433),(1000134,27309,0.000398089171974),(1000134,28231,-0.090909090909),(1000134,28236,-0.090909090909),(1000134,28237,-0.090909090909),(1000134,28238,-0.090909090909),(1000134,29000,0.0358756494158943),(1000134,29002,0.0358756494158943),(1000134,29004,0.0358756494158943),(1000134,29006,0.0358756494158943),(1000134,29008,0.0358756494158943),(1000134,29010,0.0358756494158943),(1000134,29012,0.0358756494158943),(1000134,29014,0.0358756494158943),(1000134,29016,0.0358756494158943),(1000135,3691,-0.189447798308021),(1000135,3705,1),(1000135,3721,-0.827119553359987),(1000135,3826,1),(1000135,15587,-0.090909090909),(1000135,15588,-0.090909090909),(1000135,15589,-0.090909090909),(1000135,15590,-0.090909090909),(1000135,15591,-0.090909090909),(1000135,15592,-0.090909090909),(1000135,15593,-0.090909090909),(1000135,15594,-0.090909090909),(1000135,15596,-0.090909090909),(1000135,15597,-0.090909090909),(1000135,15598,-0.090909090909),(1000135,15599,-0.090909090909),(1000135,15600,-0.090909090909),(1000135,15601,-0.090909090909),(1000135,15602,-0.090909090909),(1000135,15604,-0.090909090909),(1000135,15605,-0.090909090909),(1000135,15607,-0.090909090909),(1000135,15608,-0.090909090909),(1000135,15609,-0.090909090909),(1000135,15610,-0.090909090909),(1000135,15611,-0.090909090909),(1000135,15612,-0.090909090909),(1000135,15613,-0.090909090909),(1000135,15614,-0.090909090909),(1000135,15615,-0.090909090909),(1000135,15617,-0.090909090909),(1000135,15618,-0.090909090909),(1000135,15619,-0.090909090909),(1000135,15620,-0.090909090909),(1000135,15621,-0.090909090909),(1000135,15622,-0.090909090909),(1000135,15623,-0.090909090909),(1000135,15625,-0.090909090909),(1000135,15626,-0.090909090909),(1000135,15627,-0.090909090909),(1000135,15628,-0.090909090909),(1000135,15629,-0.090909090909),(1000135,15630,-0.090909090909),(1000135,15631,-0.090909090909),(1000135,15632,-0.090909090909),(1000135,15634,-0.090909090909),(1000135,15635,-0.090909090909),(1000135,15636,-0.090909090909),(1000135,15640,-0.090909090909),(1000135,15641,-0.090909090909),(1000135,15642,-0.090909090909),(1000135,15643,-0.090909090909),(1000135,15646,-0.090909090909),(1000135,15647,-0.090909090909),(1000135,15648,-0.090909090909),(1000135,15649,-0.090909090909),(1000135,15650,-0.090909090909),(1000135,15653,-0.090909090909),(1000135,15654,-0.090909090909),(1000135,15655,-0.090909090909),(1000135,15656,-0.090909090909),(1000135,15657,-0.090909090909),(1000135,15660,-0.090909090909),(1000135,15661,-0.090909090909),(1000135,15662,-0.090909090909),(1000135,15663,-0.090909090909),(1000135,15664,-0.090909090909),(1000135,15666,-0.090909090909),(1000135,15669,-0.090909090909),(1000135,15670,-0.090909090909),(1000135,15671,-0.090909090909),(1000135,15672,-0.090909090909),(1000135,15673,-0.090909090909),(1000135,15981,-0.142857142857),(1000135,15992,-0.090909090909),(1000135,15993,-0.090909090909),(1000135,15994,-0.090909090909),(1000135,15996,-0.090909090909),(1000135,15997,-0.090909090909),(1000135,15998,-0.090909090909),(1000135,15999,-0.090909090909),(1000135,16000,-0.090909090909),(1000135,16001,-0.090909090909),(1000135,16002,-0.090909090909),(1000135,16118,-0.142857142857),(1000135,16119,-0.142857142857),(1000135,16120,-0.142857142857),(1000135,16121,-0.142857142857),(1000135,16122,-0.142857142857),(1000135,16123,-0.142857142857),(1000135,16124,-0.142857142857),(1000135,16125,-0.142857142857),(1000135,16179,-0.090909090909),(1000135,16180,-0.090909090909),(1000135,16181,-0.090909090909),(1000135,16182,-0.090909090909),(1000135,16183,-0.090909090909),(1000135,16184,-0.090909090909),(1000135,16185,-0.090909090909),(1000135,16186,-0.090909090909),(1000135,16187,-0.090909090909),(1000135,16188,-0.090909090909),(1000135,16189,-0.090909090909),(1000135,16617,-0.142857142857),(1000135,17366,0.018710191082802),(1000135,17367,0.018710191082802),(1000135,17368,0.018710191082802),(1000135,17999,-0.090909090909),(1000135,24445,0.018710191082802),(1000135,25266,0.0909925267809106),(1000135,25544,0.0909925267809106),(1000135,26224,0.0890393011996194),(1000135,27309,0.018710191082802),(1000135,28231,-0.090909090909),(1000135,28236,-0.090909090909),(1000135,28237,-0.090909090909),(1000135,28238,-0.090909090909),(1000135,29000,0.0592985940758584),(1000135,29002,0.0592985940758584),(1000135,29004,0.0592985940758584),(1000135,29006,0.0592985940758584),(1000135,29008,0.0592985940758584),(1000135,29010,0.0592985940758584),(1000135,29012,0.0592985940758584),(1000135,29014,0.0592985940758584),(1000135,29016,0.0592985940758584),(1000136,3820,0.693694240442504),(1000136,9850,0.0252667919606512),(1000136,9852,-0.019483620008944),(1000136,17366,0.003184713375796),(1000136,17367,0.003184713375796),(1000136,17368,0.003184713375796),(1000136,24445,0.003184713375796),(1000136,25266,0.0909173530460698),(1000136,25544,0.0909173530460698),(1000136,26224,0.0914931905852948),(1000136,27309,0.003184713375796),(1000136,29000,0.055218492744645),(1000136,29002,0.055218492744645),(1000136,29004,0.055218492744645),(1000136,29006,0.055218492744645),(1000136,29008,0.055218492744645),(1000136,29010,0.055218492744645),(1000136,29012,0.055218492744645),(1000136,29014,0.055218492744645),(1000136,29016,0.055218492744645),(1000137,41,0.00059168748604954),(1000137,3689,-0.000472488660804462),(1000137,3812,0.000650934422356853),(1000137,9828,-0.000826676711724402),(1000137,9994,0.250062515628907),(1000137,9995,0.250000625001562),(1000137,10006,0.250000625001562),(1000137,10007,0.250000625001562),(1000137,10008,0.250062515628907),(1000137,10009,0.250000625001562),(1000137,10010,0.250062515628907),(1000137,10011,0.250000625001562),(1000137,11129,0.000142962956881407),(1000137,11130,0.000142962956881407),(1000137,17366,0.008957006369426),(1000137,17367,0.008957006369426),(1000137,17368,0.008957006369426),(1000137,17939,0.250062515628907),(1000137,18588,0.250062515628907),(1000137,18589,0.250000625001562),(1000137,18640,0.250062515628907),(1000137,19400,-0.0714948932219127),(1000137,19401,-0.5),(1000137,19402,-0.5),(1000137,19403,-0.5),(1000137,19404,-0.5),(1000137,19405,-0.5),(1000137,19406,-0.5),(1000137,19407,-0.5),(1000137,19408,-0.5),(1000137,19409,-0.5),(1000137,19410,-0.5),(1000137,19411,-0.5),(1000137,19412,-0.5),(1000137,19413,-0.5),(1000137,19414,-0.5),(1000137,19415,-0.5),(1000137,19416,-0.5),(1000137,19417,-0.5),(1000137,19418,-0.5),(1000137,19419,-0.5),(1000137,19420,-0.5),(1000137,19421,-0.5),(1000137,19422,-0.5),(1000137,24445,0.008957006369426),(1000137,25773,0.250000625001562),(1000137,25774,0.250000625001562),(1000137,25775,0.250000625001562),(1000137,25776,0.250000625001562),(1000137,25777,0.250000625001562),(1000137,25778,0.250000625001562),(1000137,25779,0.250000625001562),(1000137,25780,0.250000625001562),(1000137,25781,0.250000625001562),(1000137,25782,0.250000625001562),(1000137,25783,0.250000625001562),(1000137,25784,0.250000625001562),(1000137,25785,0.250000625001562),(1000137,25786,0.250000625001562),(1000137,25787,0.250000625001562),(1000137,25788,0.250000625001562),(1000137,25789,0.250000625001562),(1000137,25790,0.250000625001562),(1000137,25791,0.250000625001562),(1000137,25792,0.250000625001562),(1000137,25793,0.250000625001562),(1000137,25794,0.250000625001562),(1000137,25795,0.250000625001562),(1000137,25796,0.250000625001562),(1000137,25797,0.250000625001562),(1000137,25798,0.250000625001562),(1000137,25799,0.250000625001562),(1000137,25800,0.250000625001562),(1000137,25801,0.250000625001562),(1000137,25802,0.250000625001562),(1000137,25803,0.250000625001562),(1000137,25804,0.250000625001562),(1000137,26910,0.250000625001562),(1000137,27309,0.008957006369426),(1000138,3711,1),(1000138,3721,0.272678360383164),(1000138,3727,0.172241814275302),(1000138,3775,0.14707942288836),(1000138,17366,0.001592356687898),(1000138,17367,0.001592356687898),(1000138,17368,0.001592356687898),(1000138,24445,0.001592356687898),(1000138,25266,0.0911433824738268),(1000138,25544,0.0911433824738268),(1000138,26224,0.0914931905852948),(1000138,27309,0.001592356687898),(1000138,29000,0.0211670888854472),(1000138,29002,0.0211670888854472),(1000138,29004,0.0211670888854472),(1000138,29006,0.0211670888854472),(1000138,29008,0.0211670888854472),(1000138,29010,0.0211670888854472),(1000138,29012,0.0211670888854472),(1000138,29014,0.0211670888854472),(1000138,29016,0.0211670888854472),(1000139,45,0.919612167132872),(1000139,3673,0.321242701205704),(1000139,3693,-0.0754575836365804),(1000139,3725,-0.0219629564770861),(1000139,11129,0.0049063572150803),(1000139,11130,0.0049063572150803),(1000139,17366,0.000398089171974),(1000139,17367,0.000398089171974),(1000139,17368,0.000398089171974),(1000139,24445,0.000398089171974),(1000139,27309,0.000398089171974),(1000140,3643,0.206056597242096),(1000140,3771,-0.501893751919744),(1000140,9826,0.13208867146632),(1000140,17366,0.011942675159235),(1000140,17367,0.011942675159235),(1000140,17368,0.011942675159235),(1000140,24445,0.011942675159235),(1000140,27309,0.011942675159235),(1000141,3820,0.306305759557496),(1000141,9830,-0.0383132292530505),(1000141,9838,-0.0182917699771218),(1000141,9848,0.0191470580022904),(1000141,17366,0.000199044585987),(1000141,17367,0.000199044585987),(1000141,17368,0.000199044585987),(1000141,24445,0.000199044585987),(1000141,25266,0.0906413185893787),(1000141,25544,0.0906413185893787),(1000141,26224,0.0915272717987878),(1000141,27309,0.000199044585987),(1000141,29000,0.0244479876626916),(1000141,29002,0.0244479876626916),(1000141,29004,0.0244479876626916),(1000141,29006,0.0244479876626916),(1000141,29008,0.0244479876626916),(1000141,29010,0.0244479876626916),(1000141,29012,0.0244479876626916),(1000141,29014,0.0244479876626916),(1000141,29016,0.0244479876626916),(1000142,44,0.67604347216992),(1000142,1109,0.0510842421528865),(1000142,3645,-0.0869251191295318),(1000142,3683,0.18267043690473),(1000142,3697,-0.0687354521829026),(1000142,11628,0.63948125622756),(1000142,11629,0.166666),(1000142,11631,0.163156537127112),(1000142,12266,0.166666),(1000142,12270,0.166666),(1000142,17366,0.005971337579617),(1000142,17367,0.005971337579617),(1000142,17368,0.005971337579617),(1000142,22779,0.166666),(1000142,24445,0.005971337579617),(1000142,25562,0.166666),(1000142,27309,0.005971337579617),(1000143,3647,0.000478547388452215),(1000143,3777,-0.00446540193482423),(1000143,3812,0.000650934422356853),(1000143,9842,-0.00224536225994577),(1000143,9994,0.250062515628907),(1000143,9995,0.249998124995312),(1000143,10006,0.249998124995312),(1000143,10007,0.249998124995312),(1000143,10008,0.250062515628907),(1000143,10009,0.249998124995312),(1000143,10010,0.250062515628907),(1000143,10011,0.249998124995312),(1000143,11129,0.000142962956881407),(1000143,11130,0.000142962956881407),(1000143,17366,0.000199044585987),(1000143,17367,0.000199044585987),(1000143,17368,0.000199044585987),(1000143,17939,0.250062515628907),(1000143,18588,0.250062515628907),(1000143,18589,0.249998124995312),(1000143,18640,0.250062515628907),(1000143,24445,0.000199044585987),(1000143,25773,0.249998124995312),(1000143,25774,0.249998124995312),(1000143,25775,0.249998124995312),(1000143,25776,0.249998124995312),(1000143,25777,0.249998124995312),(1000143,25778,0.249998124995312),(1000143,25779,0.249998124995312),(1000143,25780,0.249998124995312),(1000143,25781,0.249998124995312),(1000143,25782,0.249998124995312),(1000143,25783,0.249998124995312),(1000143,25784,0.249998124995312),(1000143,25785,0.249998124995312),(1000143,25786,0.249998124995312),(1000143,25787,0.249998124995312),(1000143,25788,0.249998124995312),(1000143,25789,0.249998124995312),(1000143,25790,0.249998124995312),(1000143,25791,0.249998124995312),(1000143,25792,0.249998124995312),(1000143,25793,0.249998124995312),(1000143,25794,0.249998124995312),(1000143,25795,0.249998124995312),(1000143,25796,0.249998124995312),(1000143,25797,0.249998124995312),(1000143,25798,0.249998124995312),(1000143,25799,0.249998124995312),(1000143,25800,0.249998124995312),(1000143,25801,0.249998124995312),(1000143,25802,0.249998124995312),(1000143,25803,0.249998124995312),(1000143,25804,0.249998124995312),(1000143,26910,0.249998124995312),(1000143,27309,0.000199044585987),(1000144,42,-0.164104157082378),(1000144,3697,0.0335806664661883),(1000144,3777,-0.457572429211384),(1000144,3812,0.0667016428179289),(1000144,11129,0.0146495004083082),(1000144,11130,0.0146495004083082),(1000144,17366,0.001592356687898),(1000144,17367,0.001592356687898),(1000144,17368,0.001592356687898),(1000144,24445,0.001592356687898),(1000144,27309,0.001592356687898),(1000145,44,0.304219562476464),(1000145,3709,0.184497235257317),(1000145,3773,-0.111568469943762),(1000145,9842,0.436984204395134),(1000145,9850,-0.0276679334823624),(1000145,11129,0.00689585026460294),(1000145,11130,0.00689585026460294),(1000145,17366,0.001592356687898),(1000145,17367,0.001592356687898),(1000145,17368,0.001592356687898),(1000145,24445,0.001592356687898),(1000145,27309,0.001592356687898),(1000146,3775,-0.150383203471422),(1000146,3814,0.00343467000427627),(1000146,9840,0.00183639083792037),(1000146,9844,-0.0151537338556737),(1000146,11129,0.000142962956881407),(1000146,11130,0.000142962956881407),(1000146,17366,0.003980891719745),(1000146,17367,0.003980891719745),(1000146,17368,0.003980891719745),(1000146,24445,0.003980891719745),(1000146,27309,0.003980891719745),(1000147,3691,0.611012988384891),(1000147,3703,0.64459861398562),(1000147,3812,-0.159437496855497),(1000147,9846,-0.405821722264833),(1000147,11129,0.0422294874072326),(1000147,11130,0.0422294874072326),(1000147,15587,-0.090909090909),(1000147,15588,-0.090909090909),(1000147,15589,-0.090909090909),(1000147,15590,-0.090909090909),(1000147,15591,-0.090909090909),(1000147,15592,-0.090909090909),(1000147,15593,-0.090909090909),(1000147,15594,-0.090909090909),(1000147,15596,-0.090909090909),(1000147,15597,-0.090909090909),(1000147,15598,-0.090909090909),(1000147,15599,-0.090909090909),(1000147,15600,-0.090909090909),(1000147,15601,-0.090909090909),(1000147,15602,-0.090909090909),(1000147,15604,-0.090909090909),(1000147,15605,-0.090909090909),(1000147,15607,-0.090909090909),(1000147,15608,-0.090909090909),(1000147,15609,-0.090909090909),(1000147,15610,-0.090909090909),(1000147,15611,-0.090909090909),(1000147,15612,-0.090909090909),(1000147,15613,-0.090909090909),(1000147,15614,-0.090909090909),(1000147,15615,-0.090909090909),(1000147,15617,-0.090909090909),(1000147,15618,-0.090909090909),(1000147,15619,-0.090909090909),(1000147,15620,-0.090909090909),(1000147,15621,-0.090909090909),(1000147,15622,-0.090909090909),(1000147,15623,-0.090909090909),(1000147,15625,-0.090909090909),(1000147,15626,-0.090909090909),(1000147,15627,-0.090909090909),(1000147,15628,-0.090909090909),(1000147,15629,-0.090909090909),(1000147,15630,-0.090909090909),(1000147,15631,-0.090909090909),(1000147,15632,-0.090909090909),(1000147,15634,-0.090909090909),(1000147,15635,-0.090909090909),(1000147,15636,-0.090909090909),(1000147,15640,-0.090909090909),(1000147,15641,-0.090909090909),(1000147,15642,-0.090909090909),(1000147,15643,-0.090909090909),(1000147,15646,-0.090909090909),(1000147,15647,-0.090909090909),(1000147,15648,-0.090909090909),(1000147,15649,-0.090909090909),(1000147,15650,-0.090909090909),(1000147,15653,-0.090909090909),(1000147,15654,-0.090909090909),(1000147,15655,-0.090909090909),(1000147,15656,-0.090909090909),(1000147,15657,-0.090909090909),(1000147,15660,-0.090909090909),(1000147,15661,-0.090909090909),(1000147,15662,-0.090909090909),(1000147,15663,-0.090909090909),(1000147,15664,-0.090909090909),(1000147,15666,-0.090909090909),(1000147,15669,-0.090909090909),(1000147,15670,-0.090909090909),(1000147,15671,-0.090909090909),(1000147,15672,-0.090909090909),(1000147,15673,-0.090909090909),(1000147,15981,-0.142857142857),(1000147,15992,-0.090909090909),(1000147,15993,-0.090909090909),(1000147,15994,-0.090909090909),(1000147,15996,-0.090909090909),(1000147,15997,-0.090909090909),(1000147,15998,-0.090909090909),(1000147,15999,-0.090909090909),(1000147,16000,-0.090909090909),(1000147,16001,-0.090909090909),(1000147,16002,-0.090909090909),(1000147,16118,-0.142857142857),(1000147,16119,-0.142857142857),(1000147,16120,-0.142857142857),(1000147,16121,-0.142857142857),(1000147,16122,-0.142857142857),(1000147,16123,-0.142857142857),(1000147,16124,-0.142857142857),(1000147,16125,-0.142857142857),(1000147,16179,-0.090909090909),(1000147,16180,-0.090909090909),(1000147,16181,-0.090909090909),(1000147,16182,-0.090909090909),(1000147,16183,-0.090909090909),(1000147,16184,-0.090909090909),(1000147,16185,-0.090909090909),(1000147,16186,-0.090909090909),(1000147,16187,-0.090909090909),(1000147,16188,-0.090909090909),(1000147,16189,-0.090909090909),(1000147,16617,-0.142857142857),(1000147,17366,0.005971337579617),(1000147,17367,0.005971337579617),(1000147,17368,0.005971337579617),(1000147,17999,-0.090909090909),(1000147,24445,0.005971337579617),(1000147,27309,0.005971337579617),(1000147,28231,-0.090909090909),(1000147,28236,-0.090909090909),(1000147,28237,-0.090909090909),(1000147,28238,-0.090909090909),(1000148,3695,-0.226416992855446),(1000148,3697,0.0998651873220418),(1000148,3699,-0.118622136875226),(1000148,3715,0.133877621507446),(1000148,11129,0.0435659936625459),(1000148,11130,0.0435659936625459),(1000148,17366,0),(1000148,17367,0),(1000148,17368,0),(1000148,24445,0),(1000148,27309,0),(1000149,3725,-0.000639963431559987),(1000149,3727,-0.0462674739391337),(1000149,9842,0.00905944177637893),(1000149,17366,0.005971337579617),(1000149,17367,0.005971337579617),(1000149,17368,0.005971337579617),(1000149,24445,0.005971337579617),(1000149,27309,0.005971337579617),(1000150,45,-0.0106813118499739),(1000150,3693,0.00268386370244684),(1000150,3773,0.00297435193221851),(1000150,3814,-0.00282088783215561),(1000150,17366,0.011942675159235),(1000150,17367,0.011942675159235),(1000150,17368,0.011942675159235),(1000150,24445,0.011942675159235),(1000150,27309,0.011942675159235),(1000151,1128,0.0178165501685855),(1000151,1178,0.0125292249978814),(1000151,1179,0.0125292249978814),(1000151,3553,0.0178165501685855),(1000151,3555,0.0178165501685855),(1000151,3567,0.0050248860036001),(1000151,3577,0.0178165501685855),(1000151,3729,-0.0811835197455199),(1000151,9838,0.486968592029674),(1000151,9840,0.0234679265767035),(1000151,11134,0.00641052404574192),(1000151,11135,0.00641052404574192),(1000151,11284,0.0178165501685855),(1000151,11286,0.0178165501685855),(1000151,11288,0.0178165501685855),(1000151,11290,0.0178165501685855),(1000151,11564,0.0213277274459702),(1000151,11625,0.333333),(1000151,11859,0.0833003178477466),(1000151,11860,0.0833003178477466),(1000151,11870,0.0833003178477466),(1000151,11872,0.0833003178477466),(1000151,11873,0.0833003178477466),(1000151,11882,1),(1000151,11887,0.0833003178477466),(1000151,11889,0.0833003178477466),(1000151,11890,0.0833003178477466),(1000151,11891,0.0833003178477466),(1000151,12092,0.125),(1000151,12095,0.12516564866269),(1000151,12836,-0.801667468334135),(1000151,16591,0.124948677330786),(1000151,17330,0.333333),(1000151,17334,0.333333),(1000151,17335,0.333333),(1000151,17336,0.333333),(1000151,17338,0.333333),(1000151,17348,0.333333),(1000151,17349,0.333333),(1000151,17350,0.333333),(1000151,17359,0.333333),(1000151,17366,0.000199044585987),(1000151,17367,0.000199044585987),(1000151,17368,0.000199044585987),(1000151,21943,0.333333),(1000151,24445,0.000199044585987),(1000151,25737,0.333333),(1000151,25889,0.333333),(1000151,25891,0.333333),(1000151,25893,0.333333),(1000151,25895,0.333333),(1000151,25897,0.333333),(1000151,25899,0.333333),(1000151,25901,0.333333),(1000151,25903,0.333333),(1000151,25929,0.0833003178477466),(1000151,25931,0.0833003178477466),(1000151,25933,0.0833003178477466),(1000151,25935,0.0833003178477466),(1000151,25937,0.0833003178477466),(1000151,25949,0.0833003178477466),(1000151,25951,0.0833003178477466),(1000151,25953,0.0833003178477466),(1000151,25955,0.0833003178477466),(1000151,25957,0.0833003178477466),(1000151,25969,0.333333),(1000151,25971,0.333333),(1000151,25973,0.333333),(1000151,25975,0.333333),(1000151,25977,0.333333),(1000151,25979,0.333333),(1000151,25981,0.333333),(1000151,27309,0.000199044585987),(1000151,27662,0.333333),(1000151,27664,0.333333),(1000151,27666,0.333333),(1000151,27961,0.333333),(1000151,27963,0.333333),(1000151,27965,0.333333),(1000151,27987,0.333333),(1000151,27989,0.333333),(1000151,27991,0.333333),(1000151,28017,0.333333),(1000151,28019,0.333333),(1000151,28021,0.333333),(1000151,28041,0.333333),(1000151,28043,0.333333),(1000151,28045,0.333333),(1000151,28080,0.333333),(1000151,28081,0.333333),(1000151,28082,0.333333),(1000151,28083,0.333333),(1000151,28084,0.333333),(1000151,28085,0.333333),(1000151,28086,0.333333),(1000151,28087,0.333333),(1000151,28088,0.333333),(1000151,28089,0.333333),(1000151,28090,0.333333),(1000152,3713,-0.0571198063889881),(1000152,3721,0.340012965197673),(1000152,9834,0.0659324472861867),(1000152,9848,-0.0122058229596633),(1000152,11134,0.0124970342490046),(1000152,11135,0.0124970342490046),(1000152,17366,0.001990445859872),(1000152,17367,0.001990445859872),(1000152,17368,0.001990445859872),(1000152,24445,0.001990445859872),(1000152,27309,0.001990445859872),(1000153,1128,0.0273443831838394),(1000153,1178,0.0192295324345503),(1000153,1179,0.0192295324345503),(1000153,3553,0.0273443831838394),(1000153,3555,0.0273443831838394),(1000153,3567,0.00771206586221294),(1000153,3577,0.0273443831838394),(1000153,3685,-0.06162102638253),(1000153,3727,-0.907465052121733),(1000153,9830,0.108092074627159),(1000153,9846,0.0689158163959036),(1000153,11134,0.00983870750831784),(1000153,11135,0.00983870750831784),(1000153,11284,0.0273443831838394),(1000153,11286,0.0273443831838394),(1000153,11288,0.0273443831838394),(1000153,11290,0.0273443831838394),(1000153,11564,0.0327332478063792),(1000153,17366,0.000199044585987),(1000153,17367,0.000199044585987),(1000153,17368,0.000199044585987),(1000153,24445,0.000199044585987),(1000153,27309,0.000199044585987),(1000154,785,0.0068386892485327),(1000154,3645,0.00949618462169135),(1000154,9826,0.00935609145144583),(1000154,9832,0.0205837580384133),(1000154,11134,0.010964154306774),(1000154,11135,0.010964154306774),(1000154,12109,0.0068386892485327),(1000154,17366,0.000796178343949),(1000154,17367,0.000796178343949),(1000154,17368,0.000796178343949),(1000154,18037,0.0068386892485327),(1000154,18039,0.0068386892485327),(1000154,18041,0.0068386892485327),(1000154,18043,0.0068386892485327),(1000154,18045,0.0068386892485327),(1000154,18047,0.0068386892485327),(1000154,18049,0.0068386892485327),(1000154,18051,0.0068386892485327),(1000154,18053,0.0068386892485327),(1000154,18055,0.0068386892485327),(1000154,18057,0.0068386892485327),(1000154,18059,0.0068386892485327),(1000154,18061,0.0068386892485327),(1000154,18063,0.0068386892485327),(1000154,18065,0.0068386892485327),(1000154,18067,0.0068386892485327),(1000154,24445,0.000796178343949),(1000154,27309,0.000796178343949),(1000155,42,0.834482896837926),(1000155,43,0.0274405909919252),(1000155,3695,-0.0423060213002676),(1000155,3812,-0.0307337424225898),(1000155,17366,0.003980891719745),(1000155,17367,0.003980891719745),(1000155,17368,0.003980891719745),(1000155,24445,0.003980891719745),(1000155,27309,0.003980891719745),(1000156,9830,-0.00244289585986284),(1000156,9840,0.00183639083792037),(1000156,9844,-0.0151537338556737),(1000156,9852,0.000789829896901656),(1000156,11134,0.000501630494939203),(1000156,11135,0.000501630494939203),(1000156,15587,-0.090909090909),(1000156,15588,-0.090909090909),(1000156,15589,-0.090909090909),(1000156,15590,-0.090909090909),(1000156,15591,-0.090909090909),(1000156,15592,-0.090909090909),(1000156,15593,-0.090909090909),(1000156,15594,-0.090909090909),(1000156,15625,-0.090909090909),(1000156,15626,-0.090909090909),(1000156,15627,-0.090909090909),(1000156,15628,-0.090909090909),(1000156,15629,-0.090909090909),(1000156,15630,-0.090909090909),(1000156,15631,-0.090909090909),(1000156,15632,-0.090909090909),(1000156,15646,-0.090909090909),(1000156,15647,-0.090909090909),(1000156,15648,-0.090909090909),(1000156,15649,-0.090909090909),(1000156,15650,-0.090909090909),(1000156,15660,-0.090909090909),(1000156,15661,-0.090909090909),(1000156,15662,-0.090909090909),(1000156,15663,-0.090909090909),(1000156,15664,-0.090909090909),(1000156,15666,-0.090909090909),(1000156,15673,-0.090909090909),(1000156,15674,-0.2),(1000156,15994,-0.090909090909),(1000156,15997,-0.090909090909),(1000156,15998,-0.090909090909),(1000156,16002,-0.090909090909),(1000156,17366,0.003980891719745),(1000156,17367,0.003980891719745),(1000156,17368,0.003980891719745),(1000156,24445,0.003980891719745),(1000156,27309,0.003980891719745),(1000156,27925,1),(1000156,28231,-0.090909090909),(1000156,28236,-0.090909090909),(1000156,28668,0.0147783251231527),(1000157,3775,0.341432285742207),(1000157,3818,1),(1000157,9830,-0.0328895218002405),(1000157,9834,-0.0845115262800803),(1000157,9838,0.513031407970326),(1000157,17366,0.000199044585987),(1000157,17367,0.000199044585987),(1000157,17368,0.000199044585987),(1000157,24445,0.000199044585987),(1000157,25266,0.0910398783851358),(1000157,25544,0.0910398783851358),(1000157,26224,0.091877173484739),(1000157,27309,0.000199044585987),(1000157,29000,0.0376694318866891),(1000157,29002,0.0376694318866891),(1000157,29004,0.0376694318866891),(1000157,29006,0.0376694318866891),(1000157,29008,0.0376694318866891),(1000157,29010,0.0376694318866891),(1000157,29012,0.0376694318866891),(1000157,29014,0.0376694318866891),(1000157,29016,0.0376694318866891),(1000158,3828,-0.109126689212257),(1000158,9830,0.792971545593652),(1000158,9838,-0.167814621430538),(1000158,9846,0.50557158452001),(1000158,17366,0.003980891719745),(1000158,17367,0.003980891719745),(1000158,17368,0.003980891719745),(1000158,24445,0.003980891719745),(1000158,27309,0.003980891719745),(1000159,43,0.000475223496012346),(1000159,3717,0.0957086243934867),(1000159,3814,-0.00278168231500684),(1000159,9836,-0.00946781341737731),(1000159,11129,0.000140976016247412),(1000159,11130,0.000140976016247412),(1000159,17366,0.000199044585987),(1000159,17367,0.000199044585987),(1000159,17368,0.000199044585987),(1000159,24445,0.000199044585987),(1000159,27309,0.000199044585987),(1000160,43,-0.0316390824274061),(1000160,3645,0.0146875956656369),(1000160,3687,0.0403329398065671),(1000160,3729,0.242424242424242),(1000160,3828,-0.0256392830155146),(1000160,11132,0.0351576165014397),(1000160,11133,0.0351576165014397),(1000160,11859,0.0834097158570119),(1000160,11860,0.0834097158570119),(1000160,11870,0.0834097158570119),(1000160,11872,0.0834097158570119),(1000160,11873,0.0834097158570119),(1000160,11883,1),(1000160,11887,0.0834097158570119),(1000160,11889,0.0834097158570119),(1000160,11890,0.0834097158570119),(1000160,11891,0.0834097158570119),(1000160,12297,1),(1000160,12300,1),(1000160,12301,1),(1000160,15587,-0.090909090909),(1000160,15588,-0.090909090909),(1000160,15589,-0.090909090909),(1000160,15590,-0.090909090909),(1000160,15591,-0.090909090909),(1000160,15592,-0.090909090909),(1000160,15593,-0.090909090909),(1000160,15594,-0.090909090909),(1000160,15596,-0.090909090909),(1000160,15597,-0.090909090909),(1000160,15598,-0.090909090909),(1000160,15599,-0.090909090909),(1000160,15600,-0.090909090909),(1000160,15601,-0.090909090909),(1000160,15602,-0.090909090909),(1000160,15604,-0.090909090909),(1000160,15605,-0.090909090909),(1000160,15607,-0.090909090909),(1000160,15608,-0.090909090909),(1000160,15609,-0.090909090909),(1000160,15610,-0.090909090909),(1000160,15611,-0.090909090909),(1000160,15612,-0.090909090909),(1000160,15613,-0.090909090909),(1000160,15614,-0.090909090909),(1000160,15615,-0.090909090909),(1000160,15617,-0.090909090909),(1000160,15618,-0.090909090909),(1000160,15619,-0.090909090909),(1000160,15620,-0.090909090909),(1000160,15621,-0.090909090909),(1000160,15622,-0.090909090909),(1000160,15623,-0.090909090909),(1000160,15625,-0.090909090909),(1000160,15626,-0.090909090909),(1000160,15627,-0.090909090909),(1000160,15628,-0.090909090909),(1000160,15629,-0.090909090909),(1000160,15630,-0.090909090909),(1000160,15631,-0.090909090909),(1000160,15632,-0.090909090909),(1000160,15634,-0.090909090909),(1000160,15635,-0.090909090909),(1000160,15636,-0.090909090909),(1000160,15640,-0.090909090909),(1000160,15641,-0.090909090909),(1000160,15642,-0.090909090909),(1000160,15643,-0.090909090909),(1000160,15646,-0.090909090909),(1000160,15647,-0.090909090909),(1000160,15648,-0.090909090909),(1000160,15649,-0.090909090909),(1000160,15650,-0.090909090909),(1000160,15653,-0.090909090909),(1000160,15654,-0.090909090909),(1000160,15655,-0.090909090909),(1000160,15656,-0.090909090909),(1000160,15657,-0.090909090909),(1000160,15660,-0.090909090909),(1000160,15661,-0.090909090909),(1000160,15662,-0.090909090909),(1000160,15663,-0.090909090909),(1000160,15664,-0.090909090909),(1000160,15666,-0.090909090909),(1000160,15669,-0.090909090909),(1000160,15670,-0.090909090909),(1000160,15671,-0.090909090909),(1000160,15672,-0.090909090909),(1000160,15673,-0.090909090909),(1000160,15981,-0.142857142857),(1000160,15992,-0.090909090909),(1000160,15993,-0.090909090909),(1000160,15994,-0.090909090909),(1000160,15996,-0.090909090909),(1000160,15997,-0.090909090909),(1000160,15998,-0.090909090909),(1000160,15999,-0.090909090909),(1000160,16000,-0.090909090909),(1000160,16001,-0.090909090909),(1000160,16002,-0.090909090909),(1000160,16118,-0.142857142857),(1000160,16119,-0.142857142857),(1000160,16120,-0.142857142857),(1000160,16121,-0.142857142857),(1000160,16122,-0.142857142857),(1000160,16123,-0.142857142857),(1000160,16124,-0.142857142857),(1000160,16125,-0.142857142857),(1000160,16179,-0.090909090909),(1000160,16180,-0.090909090909),(1000160,16181,-0.090909090909),(1000160,16182,-0.090909090909),(1000160,16183,-0.090909090909),(1000160,16184,-0.090909090909),(1000160,16185,-0.090909090909),(1000160,16186,-0.090909090909),(1000160,16187,-0.090909090909),(1000160,16188,-0.090909090909),(1000160,16189,-0.090909090909),(1000160,16617,-0.142857142857),(1000160,17322,0.333333),(1000160,17324,0.333333),(1000160,17325,0.333333),(1000160,17326,0.333333),(1000160,17333,0.333333),(1000160,17342,0.333333),(1000160,17346,0.333333),(1000160,17347,0.333333),(1000160,17355,0.333333),(1000160,17366,0.005971337579617),(1000160,17367,0.005971337579617),(1000160,17368,0.005971337579617),(1000160,17999,-0.090909090909),(1000160,24445,0.005971337579617),(1000160,25929,0.0834097158570119),(1000160,25931,0.0834097158570119),(1000160,25933,0.0834097158570119),(1000160,25935,0.0834097158570119),(1000160,25937,0.0834097158570119),(1000160,25949,0.0834097158570119),(1000160,25951,0.0834097158570119),(1000160,25953,0.0834097158570119),(1000160,25955,0.0834097158570119),(1000160,25957,0.0834097158570119),(1000160,26039,0.333333),(1000160,26041,0.333333),(1000160,26043,0.333333),(1000160,26047,0.333333),(1000160,26049,0.333333),(1000160,26057,0.333333),(1000160,26059,0.333333),(1000160,26061,0.333333),(1000160,26063,0.333333),(1000160,26067,0.333333),(1000160,26069,0.333333),(1000160,26071,0.333333),(1000160,26073,0.333333),(1000160,27309,0.005971337579617),(1000160,28231,-0.090909090909),(1000160,28236,-0.090909090909),(1000160,28237,-0.090909090909),(1000160,28238,-0.090909090909),(1000160,29000,0.0652284534834442),(1000160,29002,0.0652284534834442),(1000160,29004,0.0652284534834442),(1000160,29006,0.0652284534834442),(1000160,29008,0.0652284534834442),(1000160,29010,0.0652284534834442),(1000160,29012,0.0652284534834442),(1000160,29014,0.0652284534834442),(1000160,29016,0.0652284534834442),(1000161,41,0.103648500359491),(1000161,3643,0.11697548095243),(1000161,3689,-0.0827679176658239),(1000161,3729,0.251782288395561),(1000161,9850,-0.100480794618307),(1000161,17366,0.008957006369426),(1000161,17367,0.008957006369426),(1000161,17368,0.008957006369426),(1000161,24445,0.008957006369426),(1000161,25266,0.0908790852229285),(1000161,25544,0.0908790852229285),(1000161,26224,0.0916004936162268),(1000161,27309,0.008957006369426),(1000161,29000,0.0513407740916523),(1000161,29002,0.0513407740916523),(1000161,29004,0.0513407740916523),(1000161,29006,0.0513407740916523),(1000161,29008,0.0513407740916523),(1000161,29010,0.0513407740916523),(1000161,29012,0.0513407740916523),(1000161,29014,0.0513407740916523),(1000161,29016,0.0513407740916523),(1000162,1202,0.0102382239697118),(1000162,1218,0.0102382239697118),(1000162,3687,-0.014119788262393),(1000162,3709,0.192560783948917),(1000162,3721,-0.163157751196416),(1000162,3771,0.447513812154696),(1000162,9826,0.0215499135729561),(1000162,10247,0.0102382239697118),(1000162,15587,-0.090909090909),(1000162,15588,-0.090909090909),(1000162,15589,-0.090909090909),(1000162,15590,-0.090909090909),(1000162,15591,-0.090909090909),(1000162,15592,-0.090909090909),(1000162,15593,-0.090909090909),(1000162,15594,-0.090909090909),(1000162,15596,-0.090909090909),(1000162,15597,-0.090909090909),(1000162,15598,-0.090909090909),(1000162,15599,-0.090909090909),(1000162,15600,-0.090909090909),(1000162,15601,-0.090909090909),(1000162,15602,-0.090909090909),(1000162,15604,-0.090909090909),(1000162,15605,-0.090909090909),(1000162,15607,-0.090909090909),(1000162,15608,-0.090909090909),(1000162,15609,-0.090909090909),(1000162,15610,-0.090909090909),(1000162,15611,-0.090909090909),(1000162,15612,-0.090909090909),(1000162,15613,-0.090909090909),(1000162,15614,-0.090909090909),(1000162,15615,-0.090909090909),(1000162,15617,-0.090909090909),(1000162,15618,-0.090909090909),(1000162,15619,-0.090909090909),(1000162,15620,-0.090909090909),(1000162,15621,-0.090909090909),(1000162,15622,-0.090909090909),(1000162,15623,-0.090909090909),(1000162,15625,-0.090909090909),(1000162,15626,-0.090909090909),(1000162,15627,-0.090909090909),(1000162,15628,-0.090909090909),(1000162,15629,-0.090909090909),(1000162,15630,-0.090909090909),(1000162,15631,-0.090909090909),(1000162,15632,-0.090909090909),(1000162,15634,-0.090909090909),(1000162,15635,-0.090909090909),(1000162,15636,-0.090909090909),(1000162,15640,-0.090909090909),(1000162,15641,-0.090909090909),(1000162,15642,-0.090909090909),(1000162,15643,-0.090909090909),(1000162,15646,-0.090909090909),(1000162,15647,-0.090909090909),(1000162,15648,-0.090909090909),(1000162,15649,-0.090909090909),(1000162,15650,-0.090909090909),(1000162,15653,-0.090909090909),(1000162,15654,-0.090909090909),(1000162,15655,-0.090909090909),(1000162,15656,-0.090909090909),(1000162,15657,-0.090909090909),(1000162,15660,-0.090909090909),(1000162,15661,-0.090909090909),(1000162,15662,-0.090909090909),(1000162,15663,-0.090909090909),(1000162,15664,-0.090909090909),(1000162,15666,-0.090909090909),(1000162,15669,-0.090909090909),(1000162,15670,-0.090909090909),(1000162,15671,-0.090909090909),(1000162,15672,-0.090909090909),(1000162,15673,-0.090909090909),(1000162,15981,-0.142857142857),(1000162,15992,-0.090909090909),(1000162,15993,-0.090909090909),(1000162,15994,-0.090909090909),(1000162,15996,-0.090909090909),(1000162,15997,-0.090909090909),(1000162,15998,-0.090909090909),(1000162,15999,-0.090909090909),(1000162,16000,-0.090909090909),(1000162,16001,-0.090909090909),(1000162,16002,-0.090909090909),(1000162,16118,-0.142857142857),(1000162,16119,-0.142857142857),(1000162,16120,-0.142857142857),(1000162,16121,-0.142857142857),(1000162,16122,-0.142857142857),(1000162,16123,-0.142857142857),(1000162,16124,-0.142857142857),(1000162,16125,-0.142857142857),(1000162,16179,-0.090909090909),(1000162,16180,-0.090909090909),(1000162,16181,-0.090909090909),(1000162,16182,-0.090909090909),(1000162,16183,-0.090909090909),(1000162,16184,-0.090909090909),(1000162,16185,-0.090909090909),(1000162,16186,-0.090909090909),(1000162,16187,-0.090909090909),(1000162,16188,-0.090909090909),(1000162,16189,-0.090909090909),(1000162,16617,-0.142857142857),(1000162,17366,0.005971337579617),(1000162,17367,0.005971337579617),(1000162,17368,0.005971337579617),(1000162,17999,-0.090909090909),(1000162,24445,0.005971337579617),(1000162,25266,0.0908084359926658),(1000162,25544,0.0908084359926658),(1000162,26224,0.0890662132928445),(1000162,27309,0.005971337579617),(1000162,28231,-0.090909090909),(1000162,28236,-0.090909090909),(1000162,28237,-0.090909090909),(1000162,28238,-0.090909090909),(1000162,29000,0.0282374257504088),(1000162,29002,0.0282374257504088),(1000162,29004,0.0282374257504088),(1000162,29006,0.0282374257504088),(1000162,29008,0.0282374257504088),(1000162,29010,0.0282374257504088),(1000162,29012,0.0282374257504088),(1000162,29014,0.0282374257504088),(1000162,29016,0.0282374257504088),(1000163,41,-0.0303006756499103),(1000163,3643,0.0241409996182203),(1000163,3647,-0.0338672829388328),(1000163,3775,0.152542372881356),(1000163,9850,0.0257172438239776),(1000163,11132,0.0375973906617696),(1000163,11133,0.0375973906617696),(1000163,12095,0.124828854033006),(1000163,16591,0.125109361329834),(1000163,17366,0.005971337579617),(1000163,17367,0.005971337579617),(1000163,17368,0.005971337579617),(1000163,24445,0.005971337579617),(1000163,27309,0.005971337579617),(1000164,43,0.0885516050327802),(1000164,3725,-0.117591357190251),(1000164,9826,-0.10183211317817),(1000164,9850,0.130711445807742),(1000164,17366,0.008957006369426),(1000164,17367,0.008957006369426),(1000164,17368,0.008957006369426),(1000164,24445,0.008957006369426),(1000164,27309,0.008957006369426),(1000165,521,0.00484683338930114),(1000165,834,0.014337337750247),(1000165,835,0.014337337750247),(1000165,836,0.014337337750247),(1000165,1026,0.00349228640273537),(1000165,1032,0.00202714102752574),(1000165,1099,0.00846839933931841),(1000165,1100,0.2),(1000165,1154,0.0160822014841092),(1000165,1155,0.0160822014841092),(1000165,1156,0.0160822014841092),(1000165,1157,0.0160822014841092),(1000165,1158,0.0160822014841092),(1000165,1160,0.010298131446645),(1000165,1165,0.0160822014841092),(1000165,1173,0.0160822014841092),(1000165,1558,0.154102331974389),(1000165,1564,0.0139321798902001),(1000165,2047,0.00484683338930114),(1000165,3300,0.0140463431166794),(1000165,3301,0.0140463431166794),(1000165,3302,0.0833333333333333),(1000165,3303,0.0833333333333333),(1000165,3304,0.0833333333333333),(1000165,3305,0.0833333333333333),(1000165,3306,0.0833333333333333),(1000165,3307,0.0833333333333333),(1000165,3308,0.0833333333333333),(1000165,3309,0.0833333333333333),(1000165,3310,0.0833333333333333),(1000165,3311,0.0140463431166794),(1000165,3312,0.0833333333333333),(1000165,3315,0.0833333333333333),(1000165,3316,0.0833333333333333),(1000165,3317,0.0833333333333333),(1000165,3318,0.0833333333333333),(1000165,3319,0.0833333333333333),(1000165,3320,0.0833333333333333),(1000165,3321,0.0833333333333333),(1000165,3322,0.0833333333333333),(1000165,3323,0.0833333333333333),(1000165,3324,0.0833333333333333),(1000165,3325,0.0833333333333333),(1000165,3326,0.0833333333333333),(1000165,3327,0.0833333333333333),(1000165,3328,0.0140463431166794),(1000165,3329,0.0833333333333333),(1000165,3330,0.0833333333333333),(1000165,3331,0.0833333333333333),(1000165,3332,0.0833333333333333),(1000165,3333,0.0833333333333333),(1000165,3334,0.0833333333333333),(1000165,3335,0.0833333333333333),(1000165,3336,0.0833333333333333),(1000165,3337,0.0833333333333333),(1000165,3338,0.0833333333333333),(1000165,3339,0.0833333333333333),(1000165,3340,0.0833333333333333),(1000165,3341,0.0833333333333333),(1000165,3342,0.0833333333333333),(1000165,3343,0.0833333333333333),(1000165,3344,0.0833333333333333),(1000165,3345,0.0833333333333333),(1000165,3346,0.0833333333333333),(1000165,3347,0.0833333333333333),(1000165,3348,0.0833333333333333),(1000165,3349,0.083333333333),(1000165,3350,0.083333333333),(1000165,3351,0.0833333333333333),(1000165,3352,0.0833333333333333),(1000165,3354,0.0833333333333333),(1000165,3355,0.0833333333333333),(1000165,3356,0.0086413667660438),(1000165,3357,0.0735899427848151),(1000165,3358,0.0086413667660438),(1000165,3359,0.0086413667660438),(1000165,3361,0.0833333333333333),(1000165,3363,0.0833333333333333),(1000165,3368,0.0833333333333333),(1000165,3373,0.0833333333333333),(1000165,3374,0.0176898701327485),(1000165,3375,0.0833333333333333),(1000165,3376,0.0833333333333333),(1000165,3377,0.0833333333333333),(1000165,3378,0.0833333333333333),(1000165,3379,0.0833333333333333),(1000165,3380,0.0833333333333333),(1000165,3385,0.0833333333333333),(1000165,3386,0.0769426043712937),(1000165,3387,0.0833333333333333),(1000165,3388,0.0833333333333333),(1000165,3389,0.0833333333333333),(1000165,3392,0.0833333333333333),(1000165,3393,0.0833333333333333),(1000165,3394,0.0833333333333333),(1000165,3395,0.083333),(1000165,3396,0.0833213375908805),(1000165,3397,0.0833213375908805),(1000165,3398,0.0833213375908805),(1000165,3400,0.0833333333333333),(1000165,3402,0.0833333333333333),(1000165,3403,0.0833333333333333),(1000165,3405,0.0833333333333333),(1000165,3406,0.0833333333333333),(1000165,3409,0.0833333333333333),(1000165,3410,0.0833333333333333),(1000165,3411,0.0833333333333333),(1000165,3412,0.0833333333333333),(1000165,3413,0.0140463431166794),(1000165,3416,0.0140463431166794),(1000165,3417,0.0833333333333333),(1000165,3418,0.0833333333333333),(1000165,3419,0.0833333333333333),(1000165,3420,0.0833333333333333),(1000165,3421,0.0833333333333333),(1000165,3422,0.0833333333333333),(1000165,3423,0.0833333333333333),(1000165,3424,0.0833333333333333),(1000165,3425,0.0833333333333333),(1000165,3426,0.0140463431166794),(1000165,3427,0.0833333333333333),(1000165,3428,0.0833333333333333),(1000165,3429,0.0833333333333333),(1000165,3430,0.0833213375908805),(1000165,3431,0.0833333333333333),(1000165,3432,0.0833333333333333),(1000165,3433,0.0833333333333333),(1000165,3434,0.0833333333333333),(1000165,3435,0.0833333333333333),(1000165,3436,0.0140463431166794),(1000165,3437,0.0833333333333333),(1000165,3438,0.0833333333333333),(1000165,3439,0.0833333333333333),(1000165,3441,0.0833333333333333),(1000165,3442,0.0833333333333333),(1000165,3443,0.0833213375908805),(1000165,3444,0.0833213375908805),(1000165,3446,0.0833213375908805),(1000165,3447,0.0833213375908805),(1000165,3449,0.0140463431166794),(1000165,3450,0.0833333333333333),(1000165,3451,0.0833333333333333),(1000165,3452,0.0833333333333333),(1000165,3453,0.0833333333333333),(1000165,3454,0.0833333333333333),(1000165,3455,0.0140463431166794),(1000165,3456,0.0833333333333333),(1000165,3551,0.0833333333333333),(1000165,3687,0.0119307325520901),(1000165,3731,0.0833333333333333),(1000165,3732,0.0833333333333333),(1000165,9826,0.00428058622139743),(1000165,9850,-0.00573604331541323),(1000165,9852,-0.00548545833179662),(1000165,10039,0.0833333333333333),(1000165,10040,0.0833333333333333),(1000165,11083,0.333333333333333),(1000165,11134,0.00501630494939203),(1000165,11135,0.00501630494939203),(1000165,11207,0.0833333333333333),(1000165,11395,0.0086413667660438),(1000165,11433,0.0833333333333333),(1000165,11441,0.0833333333333333),(1000165,11442,0.0833333333333333),(1000165,11443,0.0833333333333333),(1000165,11444,0.0833333333333333),(1000165,11445,0.0833333333333333),(1000165,11446,0.0833333333333333),(1000165,11447,0.0833333333333333),(1000165,11448,0.0833333333333333),(1000165,11449,0.0833333333333333),(1000165,11450,0.0833333333333333),(1000165,11451,0.0833333333333333),(1000165,11452,0.0833333333333333),(1000165,11453,0.0833333333333333),(1000165,11454,0.0833333333333333),(1000165,11455,0.0833333333333333),(1000165,11487,0.0833333333333333),(1000165,11529,0.0833333333333333),(1000165,11562,0.00202714102752574),(1000165,11566,0.0833333333333333),(1000165,11569,0.0833333333333333),(1000165,11572,0.0833333333333333),(1000165,11574,0.0833333333333333),(1000165,11579,0.0869989562970221),(1000165,11584,0.0833333333333333),(1000165,11585,0.0120519785745323),(1000165,12093,0.0897123708962247),(1000165,12097,0.0833333333333333),(1000165,12098,0.0833333333333333),(1000165,12099,0.0833333333333333),(1000165,12179,0.0833333333333333),(1000165,12180,0.00903159331774576),(1000165,12181,0.00903159331774576),(1000165,12182,0.00903159331774576),(1000165,12183,0.00903159331774576),(1000165,12184,0.00903159331774576),(1000165,12185,0.00903159331774576),(1000165,12186,0.00903159331774576),(1000165,12187,0.00903159331774576),(1000165,12188,0.00903159331774576),(1000165,12189,0.00903159331774576),(1000165,12190,0.00903159331774576),(1000165,12191,0.00903159331774576),(1000165,12192,0.00903159331774576),(1000165,12193,0.00903159331774576),(1000165,12194,0.00903159331774576),(1000165,12195,0.00903159331774576),(1000165,12196,0.0860361965037062),(1000165,12204,0.333333333333333),(1000165,12205,0.333302629313098),(1000165,12213,0.333333333333333),(1000165,12214,0.333333333333333),(1000165,12215,0.333333333333333),(1000165,12241,0.0833333333333333),(1000165,12305,0.0833333333333333),(1000165,12365,0.0833333333333333),(1000165,12366,0.0833333333333333),(1000165,12367,0.0833333333333333),(1000165,12376,0.0833213375908805),(1000165,12383,0.0833213375908805),(1000165,12385,0.0833213375908805),(1000165,12386,0.0833213375908805),(1000165,12387,0.0833213375908805),(1000165,12484,0.333302629313098),(1000165,13278,0.0833333333333333),(1000165,16069,0.0833213375908805),(1000165,16281,0.0140463431166794),(1000165,16594,0.0833213375908805),(1000165,16595,0.0833213375908805),(1000165,16596,0.0833213375908805),(1000165,16597,0.0833213375908805),(1000165,16598,0.0833213375908805),(1000165,16622,0.0833213375908805),(1000165,17366,0.001990445859872),(1000165,17367,0.001990445859872),(1000165,17368,0.001990445859872),(1000165,17940,0.0833333333333333),(1000165,18025,0.0060210622118305),(1000165,18580,0.0833213375908805),(1000165,19400,-0.0715159000362241),(1000165,19759,0.0833333333333333),(1000165,19760,0.0833333333333333),(1000165,19761,0.0833333333333333),(1000165,19766,0.0833333333333333),(1000165,19767,0.0833333333333333),(1000165,19921,0.0833333333333333),(1000165,19922,0.0833333333333333),(1000165,20327,0.333302629313098),(1000165,20342,0.0833333333333333),(1000165,20494,0.0833333333333333),(1000165,20495,0.0833333333333333),(1000165,20524,0.333302629313098),(1000165,20525,0.333302629313098),(1000165,20533,0.0833333333333333),(1000165,21059,0.0833333333333333),(1000165,21603,0.0833333333333333),(1000165,21610,0.0833333333333333),(1000165,21611,0.0833333333333333),(1000165,21718,0.0833333333333333),(1000165,21803,0.0833333333333333),(1000165,21853,0.0833333333333333),(1000165,21855,0.0833333333333333),(1000165,21857,0.0833333333333333),(1000165,22043,0.0833333333333333),(1000165,22176,0.0833333333333333),(1000165,22178,0.0833333333333333),(1000165,22242,0.0833333333333333),(1000165,22551,0.0833333333333333),(1000165,22578,0.0769426043712937),(1000165,22761,0.0833333333333333),(1000165,22806,0.0833333333333333),(1000165,22807,0.0833333333333333),(1000165,22808,0.0833333333333333),(1000165,22809,0.0833333333333333),(1000165,23069,0.0833333333333333),(1000165,23566,0.0833333333333333),(1000165,23594,0.0833333333333333),(1000165,23606,0.0833333333333333),(1000165,23618,0.0833333333333333),(1000165,23950,0.0833333333333333),(1000165,24241,0.0833333333333333),(1000165,24242,0.0833213375908805),(1000165,24268,0.0833213375908805),(1000165,24270,0.0833213375908805),(1000165,24311,0.0833333333333333),(1000165,24312,0.0833333333333333),(1000165,24313,0.0833333333333333),(1000165,24314,0.0833333333333333),(1000165,24445,0.001990445859872),(1000165,24562,0.0833333333333333),(1000165,24563,0.0833333333333333),(1000165,24568,0.0833213375908805),(1000165,24571,0.0833333333333333),(1000165,24572,0.0833333333333333),(1000165,24606,0.0833333333333333),(1000165,24613,0.0833333333333333),(1000165,24624,0.0833333333333333),(1000165,24625,0.0833333333333333),(1000165,24764,0.0833333333333333),(1000165,25233,0.0833213375908805),(1000165,25235,0.0833213375908805),(1000165,25739,0.0833333333333333),(1000165,25810,0.0833333333333333),(1000165,25811,0.0833333333333333),(1000165,25862,0.0833333333333333),(1000165,25863,0.0833333333333333),(1000165,26252,0.0833333333333333),(1000165,26253,0.0833333333333333),(1000165,26254,0.0833333333333333),(1000165,26255,0.0833333333333333),(1000165,26256,0.0833333333333333),(1000165,26257,0.0833333333333333),(1000165,26258,0.0833333333333333),(1000165,26259,0.0833333333333333),(1000165,26260,0.0833333333333333),(1000165,26261,0.0833333333333333),(1000165,27309,0.001990445859872),(1000165,27902,0.0833213375908805),(1000165,27906,0.0833333333333333),(1000165,27911,0.0833333333333333),(1000165,27936,0.0833213375908805),(1000165,28164,0.0833333333333333),(1000165,28374,0.0833333333333333),(1000165,28585,0.0833333333333333),(1000165,28609,0.0897123708962247),(1000165,28615,0.0897123708962247),(1000165,28656,0.0897123708962247),(1000165,28667,0.0897123708962247),(1000165,28879,0.0833333333333333),(1000165,28880,0.0833333333333333),(1000166,41,-0.00838149063805407),(1000166,786,0.00271238301877068),(1000166,811,0.0063576699300406),(1000166,1026,0.00349228640273537),(1000166,1099,0.00846839933931841),(1000166,1564,0.0139321798902001),(1000166,3300,0.0140463431166794),(1000166,3301,0.0140463431166794),(1000166,3302,0.0833333333333333),(1000166,3303,0.0833333333333333),(1000166,3304,0.0833333333333333),(1000166,3305,0.0833333333333333),(1000166,3306,0.0833333333333333),(1000166,3307,0.0833333333333333),(1000166,3308,0.0833333333333333),(1000166,3309,0.0833333333333333),(1000166,3310,0.0833333333333333),(1000166,3311,0.0140463431166794),(1000166,3312,0.0833333333333333),(1000166,3315,0.0833333333333333),(1000166,3316,0.0833333333333333),(1000166,3317,0.0833333333333333),(1000166,3318,0.0833333333333333),(1000166,3319,0.0833333333333333),(1000166,3320,0.0833333333333333),(1000166,3321,0.0833333333333333),(1000166,3322,0.0833333333333333),(1000166,3323,0.0833333333333333),(1000166,3324,0.0833333333333333),(1000166,3325,0.0833333333333333),(1000166,3326,0.0833333333333333),(1000166,3327,0.0833333333333333),(1000166,3328,0.0140463431166794),(1000166,3329,0.0833333333333333),(1000166,3330,0.0833333333333333),(1000166,3331,0.0833333333333333),(1000166,3332,0.0833333333333333),(1000166,3333,0.0833333333333333),(1000166,3334,0.0833333333333333),(1000166,3335,0.0833333333333333),(1000166,3336,0.0833333333333333),(1000166,3337,0.0833333333333333),(1000166,3338,0.0833333333333333),(1000166,3339,0.0833333333333333),(1000166,3340,0.0833333333333333),(1000166,3341,0.0833333333333333),(1000166,3342,0.0833333333333333),(1000166,3343,0.0833333333333333),(1000166,3344,0.0833333333333333),(1000166,3345,0.0833333333333333),(1000166,3346,0.0833333333333333),(1000166,3347,0.0833333333333333),(1000166,3348,0.0833333333333333),(1000166,3349,0.083333333333),(1000166,3350,0.083333333333),(1000166,3351,0.0833333333333333),(1000166,3352,0.0833333333333333),(1000166,3354,0.0833333333333333),(1000166,3355,0.0833333333333333),(1000166,3356,0.0086413667660438),(1000166,3357,0.0688710012111498),(1000166,3358,0.0086413667660438),(1000166,3359,0.0086413667660438),(1000166,3361,0.0833333333333333),(1000166,3363,0.0833333333333333),(1000166,3368,0.0833333333333333),(1000166,3373,0.0833333333333333),(1000166,3374,0.0176898701327485),(1000166,3375,0.0833333333333333),(1000166,3376,0.0833333333333333),(1000166,3377,0.0833333333333333),(1000166,3378,0.0833333333333333),(1000166,3379,0.0833333333333333),(1000166,3380,0.0833333333333333),(1000166,3385,0.0833333333333333),(1000166,3386,0.0769426043712937),(1000166,3387,0.0833333333333333),(1000166,3388,0.0833333333333333),(1000166,3389,0.0833333333333333),(1000166,3392,0.0833333333333333),(1000166,3393,0.0833333333333333),(1000166,3394,0.0833333333333333),(1000166,3395,0.083333),(1000166,3396,0.0833213375908805),(1000166,3397,0.0833213375908805),(1000166,3398,0.0833213375908805),(1000166,3400,0.0833333333333333),(1000166,3402,0.0833333333333333),(1000166,3403,0.0833333333333333),(1000166,3405,0.0833333333333333),(1000166,3406,0.0833333333333333),(1000166,3409,0.0833333333333333),(1000166,3410,0.0833333333333333),(1000166,3411,0.0833333333333333),(1000166,3412,0.0833333333333333),(1000166,3413,0.0140463431166794),(1000166,3416,0.0140463431166794),(1000166,3417,0.0833333333333333),(1000166,3418,0.0833333333333333),(1000166,3419,0.0833333333333333),(1000166,3420,0.0833333333333333),(1000166,3421,0.0833333333333333),(1000166,3422,0.0833333333333333),(1000166,3423,0.0833333333333333),(1000166,3424,0.0833333333333333),(1000166,3425,0.0833333333333333),(1000166,3426,0.0140463431166794),(1000166,3427,0.0833333333333333),(1000166,3428,0.0833333333333333),(1000166,3429,0.0833333333333333),(1000166,3430,0.0833213375908805),(1000166,3431,0.0833333333333333),(1000166,3432,0.0833333333333333),(1000166,3433,0.0833333333333333),(1000166,3434,0.0833333333333333),(1000166,3435,0.0833333333333333),(1000166,3436,0.0140463431166794),(1000166,3437,0.0833333333333333),(1000166,3438,0.0833333333333333),(1000166,3439,0.0833333333333333),(1000166,3441,0.0833333333333333),(1000166,3442,0.0833333333333333),(1000166,3443,0.0833213375908805),(1000166,3444,0.0833213375908805),(1000166,3446,0.0833213375908805),(1000166,3447,0.0833213375908805),(1000166,3449,0.0140463431166794),(1000166,3450,0.0833333333333333),(1000166,3451,0.0833333333333333),(1000166,3452,0.0833333333333333),(1000166,3453,0.0833333333333333),(1000166,3454,0.0833333333333333),(1000166,3455,0.0140463431166794),(1000166,3456,0.0833333333333333),(1000166,3551,0.0833333333333333),(1000166,3643,0.00667765843346727),(1000166,3683,0.0140886512751823),(1000166,3725,-0.00639963431559987),(1000166,3731,0.0833333333333333),(1000166,3732,0.0833333333333333);
insert  into `crpNPCCorporationTrades`(`corporationID`,`typeID`,`supplyDemand`) values (1000166,10039,0.0833333333333333),(1000166,10040,0.0833333333333333),(1000166,11083,0.333333333333333),(1000166,11134,0.00501630494939203),(1000166,11135,0.00501630494939203),(1000166,11207,0.0833333333333333),(1000166,11395,0.0086413667660438),(1000166,11433,0.0833333333333333),(1000166,11441,0.0833333333333333),(1000166,11442,0.0833333333333333),(1000166,11443,0.0833333333333333),(1000166,11444,0.0833333333333333),(1000166,11445,0.0833333333333333),(1000166,11446,0.0833333333333333),(1000166,11447,0.0833333333333333),(1000166,11448,0.0833333333333333),(1000166,11449,0.0833333333333333),(1000166,11450,0.0833333333333333),(1000166,11451,0.0833333333333333),(1000166,11452,0.0833333333333333),(1000166,11453,0.0833333333333333),(1000166,11454,0.0833333333333333),(1000166,11455,0.0833333333333333),(1000166,11487,0.0833333333333333),(1000166,11529,0.0833333333333333),(1000166,11566,0.0833333333333333),(1000166,11569,0.0833333333333333),(1000166,11572,0.0833333333333333),(1000166,11574,0.0833333333333333),(1000166,11579,0.0903412426760886),(1000166,11584,0.0833333333333333),(1000166,11585,0.0120519785745323),(1000166,12093,0.0919558099379143),(1000166,12097,0.0833333333333333),(1000166,12098,0.0833333333333333),(1000166,12099,0.0833333333333333),(1000166,12179,0.0833333333333333),(1000166,12180,0.00903159331774576),(1000166,12181,0.00903159331774576),(1000166,12182,0.00903159331774576),(1000166,12183,0.00903159331774576),(1000166,12184,0.00903159331774576),(1000166,12185,0.00903159331774576),(1000166,12186,0.00903159331774576),(1000166,12187,0.00903159331774576),(1000166,12188,0.00903159331774576),(1000166,12189,0.00903159331774576),(1000166,12190,0.00903159331774576),(1000166,12191,0.00903159331774576),(1000166,12192,0.00903159331774576),(1000166,12193,0.00903159331774576),(1000166,12194,0.00903159331774576),(1000166,12195,0.00903159331774576),(1000166,12196,0.0928214795834344),(1000166,12204,0.333333333333333),(1000166,12205,0.333742028728823),(1000166,12213,0.333333333333333),(1000166,12214,0.333333333333333),(1000166,12215,0.333333333333333),(1000166,12241,0.0833333333333333),(1000166,12305,0.0833333333333333),(1000166,12365,0.0833333333333333),(1000166,12366,0.0833333333333333),(1000166,12367,0.0833333333333333),(1000166,12376,0.0833213375908805),(1000166,12383,0.0833213375908805),(1000166,12385,0.0833213375908805),(1000166,12386,0.0833213375908805),(1000166,12387,0.0833213375908805),(1000166,12484,0.333742028728823),(1000166,13278,0.0833333333333333),(1000166,16069,0.0833213375908805),(1000166,16281,0.0140463431166794),(1000166,16594,0.0833213375908805),(1000166,16595,0.0833213375908805),(1000166,16596,0.0833213375908805),(1000166,16597,0.0833213375908805),(1000166,16598,0.0833213375908805),(1000166,16622,0.0833213375908805),(1000166,17366,0.001990445859872),(1000166,17367,0.001990445859872),(1000166,17368,0.001990445859872),(1000166,17940,0.0833333333333333),(1000166,18025,0.0060210622118305),(1000166,18580,0.0833213375908805),(1000166,19400,-0.071514081343453),(1000166,19759,0.0833333333333333),(1000166,19760,0.0833333333333333),(1000166,19761,0.0833333333333333),(1000166,19766,0.0833333333333333),(1000166,19767,0.0833333333333333),(1000166,19921,0.0833333333333333),(1000166,19922,0.0833333333333333),(1000166,20327,0.333742028728823),(1000166,20342,0.0833333333333333),(1000166,20494,0.0833333333333333),(1000166,20495,0.0833333333333333),(1000166,20524,0.333742028728823),(1000166,20525,0.333742028728823),(1000166,20533,0.0833333333333333),(1000166,21059,0.0833333333333333),(1000166,21603,0.0833333333333333),(1000166,21610,0.0833333333333333),(1000166,21611,0.0833333333333333),(1000166,21718,0.0833333333333333),(1000166,21803,0.0833333333333333),(1000166,21853,0.0833333333333333),(1000166,21855,0.0833333333333333),(1000166,21857,0.0833333333333333),(1000166,22043,0.0833333333333333),(1000166,22176,0.0833333333333333),(1000166,22178,0.0833333333333333),(1000166,22242,0.0833333333333333),(1000166,22551,0.0833333333333333),(1000166,22578,0.0769426043712937),(1000166,22761,0.0833333333333333),(1000166,22806,0.0833333333333333),(1000166,22807,0.0833333333333333),(1000166,22808,0.0833333333333333),(1000166,22809,0.0833333333333333),(1000166,23069,0.0833333333333333),(1000166,23566,0.0833333333333333),(1000166,23594,0.0833333333333333),(1000166,23606,0.0833333333333333),(1000166,23618,0.0833333333333333),(1000166,23950,0.0833333333333333),(1000166,24241,0.0833333333333333),(1000166,24242,0.0833213375908805),(1000166,24268,0.0833213375908805),(1000166,24270,0.0833213375908805),(1000166,24311,0.0833333333333333),(1000166,24312,0.0833333333333333),(1000166,24313,0.0833333333333333),(1000166,24314,0.0833333333333333),(1000166,24445,0.001990445859872),(1000166,24562,0.0833333333333333),(1000166,24563,0.0833333333333333),(1000166,24568,0.0833213375908805),(1000166,24571,0.0833333333333333),(1000166,24572,0.0833333333333333),(1000166,24606,0.0833333333333333),(1000166,24613,0.0833333333333333),(1000166,24624,0.0833333333333333),(1000166,24625,0.0833333333333333),(1000166,24764,0.0833333333333333),(1000166,25233,0.0833213375908805),(1000166,25235,0.0833213375908805),(1000166,25739,0.0833333333333333),(1000166,25810,0.0833333333333333),(1000166,25811,0.0833333333333333),(1000166,25862,0.0833333333333333),(1000166,25863,0.0833333333333333),(1000166,26252,0.0833333333333333),(1000166,26253,0.0833333333333333),(1000166,26254,0.0833333333333333),(1000166,26255,0.0833333333333333),(1000166,26256,0.0833333333333333),(1000166,26257,0.0833333333333333),(1000166,26258,0.0833333333333333),(1000166,26259,0.0833333333333333),(1000166,26260,0.0833333333333333),(1000166,26261,0.0833333333333333),(1000166,27309,0.001990445859872),(1000166,27902,0.0833213375908805),(1000166,27906,0.0833333333333333),(1000166,27911,0.0833333333333333),(1000166,27936,0.0833213375908805),(1000166,28164,0.0833333333333333),(1000166,28374,0.0833333333333333),(1000166,28585,0.0833333333333333),(1000166,28609,0.0919558099379143),(1000166,28615,0.0919558099379143),(1000166,28656,0.0919558099379143),(1000166,28667,0.0919558099379143),(1000166,28879,0.0833333333333333),(1000166,28880,0.0833333333333333),(1000167,41,-0.00838149063805407),(1000167,672,0.000972455418426332),(1000167,811,0.0063576699300406),(1000167,812,0.00355296403424345),(1000167,813,0.00350494106972787),(1000167,814,0.00375552955387329),(1000167,879,0.00534474439183068),(1000167,967,0.000972455418426332),(1000167,1130,0.00151507385404694),(1000167,1131,0.00233570090076233),(1000167,1132,0.00233025811478461),(1000167,1133,0.00213533723763032),(1000167,1134,0.00241605256716078),(1000167,1137,0.00469456687002521),(1000167,3300,0.0140463431166794),(1000167,3301,0.0140463431166794),(1000167,3302,0.0833333333333333),(1000167,3303,0.0833333333333333),(1000167,3304,0.0833333333333333),(1000167,3305,0.0833333333333333),(1000167,3306,0.0833333333333333),(1000167,3307,0.0833333333333333),(1000167,3308,0.0833333333333333),(1000167,3309,0.0833333333333333),(1000167,3310,0.0833333333333333),(1000167,3311,0.0140463431166794),(1000167,3312,0.0833333333333333),(1000167,3315,0.0833333333333333),(1000167,3316,0.0833333333333333),(1000167,3317,0.0833333333333333),(1000167,3318,0.0833333333333333),(1000167,3319,0.0833333333333333),(1000167,3320,0.0833333333333333),(1000167,3321,0.0833333333333333),(1000167,3322,0.0833333333333333),(1000167,3323,0.0833333333333333),(1000167,3324,0.0833333333333333),(1000167,3325,0.0833333333333333),(1000167,3326,0.0833333333333333),(1000167,3327,0.0833333333333333),(1000167,3328,0.0140463431166794),(1000167,3329,0.0833333333333333),(1000167,3330,0.0833333333333333),(1000167,3331,0.0833333333333333),(1000167,3332,0.0833333333333333),(1000167,3333,0.0833333333333333),(1000167,3334,0.0833333333333333),(1000167,3335,0.0833333333333333),(1000167,3336,0.0833333333333333),(1000167,3337,0.0833333333333333),(1000167,3338,0.0833333333333333),(1000167,3339,0.0833333333333333),(1000167,3340,0.0833333333333333),(1000167,3341,0.0833333333333333),(1000167,3342,0.0833333333333333),(1000167,3343,0.0833333333333333),(1000167,3344,0.0833333333333333),(1000167,3345,0.0833333333333333),(1000167,3346,0.0833333333333333),(1000167,3347,0.0833333333333333),(1000167,3348,0.0833333333333333),(1000167,3349,0.083333333333),(1000167,3350,0.083333333333),(1000167,3351,0.0833333333333333),(1000167,3352,0.0833333333333333),(1000167,3354,0.0833333333333333),(1000167,3355,0.0833333333333333),(1000167,3356,0.0086413667660438),(1000167,3357,0.0909090909090909),(1000167,3358,0.0086413667660438),(1000167,3359,0.0086413667660438),(1000167,3361,0.0833333333333333),(1000167,3363,0.0833333333333333),(1000167,3368,0.0833333333333333),(1000167,3373,0.0833333333333333),(1000167,3374,0.0176898701327485),(1000167,3375,0.0833333333333333),(1000167,3376,0.0833333333333333),(1000167,3377,0.0833333333333333),(1000167,3378,0.0833333333333333),(1000167,3379,0.0833333333333333),(1000167,3380,0.0833333333333333),(1000167,3385,0.0833333333333333),(1000167,3386,0.0769426043712937),(1000167,3387,0.0833333333333333),(1000167,3388,0.0833333333333333),(1000167,3389,0.0833333333333333),(1000167,3392,0.0833333333333333),(1000167,3393,0.0833333333333333),(1000167,3394,0.0833333333333333),(1000167,3395,0.083333),(1000167,3396,0.0832380162532896),(1000167,3397,0.0832380162532896),(1000167,3398,0.0832380162532896),(1000167,3400,0.0833333333333333),(1000167,3402,0.0833333333333333),(1000167,3403,0.0833333333333333),(1000167,3405,0.0833333333333333),(1000167,3406,0.0833333333333333),(1000167,3409,0.0833333333333333),(1000167,3410,0.0833333333333333),(1000167,3411,0.0833333333333333),(1000167,3412,0.0833333333333333),(1000167,3413,0.0140463431166794),(1000167,3416,0.0140463431166794),(1000167,3417,0.0833333333333333),(1000167,3418,0.0833333333333333),(1000167,3419,0.0833333333333333),(1000167,3420,0.0833333333333333),(1000167,3421,0.0833333333333333),(1000167,3422,0.0833333333333333),(1000167,3423,0.0833333333333333),(1000167,3424,0.0833333333333333),(1000167,3425,0.0833333333333333),(1000167,3426,0.0140463431166794),(1000167,3427,0.0833333333333333),(1000167,3428,0.0833333333333333),(1000167,3429,0.0833333333333333),(1000167,3430,0.0832380162532896),(1000167,3431,0.0833333333333333),(1000167,3432,0.0833333333333333),(1000167,3433,0.0833333333333333),(1000167,3434,0.0833333333333333),(1000167,3435,0.0833333333333333),(1000167,3436,0.0140463431166794),(1000167,3437,0.0833333333333333),(1000167,3438,0.0833333333333333),(1000167,3439,0.0833333333333333),(1000167,3441,0.0833333333333333),(1000167,3442,0.0833333333333333),(1000167,3443,0.0833005072564828),(1000167,3444,0.0833005072564828),(1000167,3446,0.0833005072564828),(1000167,3447,0.0833005072564828),(1000167,3449,0.0140463431166794),(1000167,3450,0.0833333333333333),(1000167,3451,0.0833333333333333),(1000167,3452,0.0833333333333333),(1000167,3453,0.0833333333333333),(1000167,3454,0.0833333333333333),(1000167,3455,0.0140463431166794),(1000167,3456,0.0833333333333333),(1000167,3551,0.0833333333333333),(1000167,3643,0.00667765843346727),(1000167,3689,-0.00472488660804462),(1000167,3715,0.00439322944845598),(1000167,3731,0.0833333333333333),(1000167,3732,0.0833333333333333),(1000167,10039,0.0833333333333333),(1000167,10040,0.0833333333333333),(1000167,11082,0.166542083766465),(1000167,11207,0.0833333333333333),(1000167,11395,0.0086413667660438),(1000167,11433,0.0833333333333333),(1000167,11441,0.0833333333333333),(1000167,11442,0.0833333333333333),(1000167,11443,0.0833333333333333),(1000167,11444,0.0833333333333333),(1000167,11445,0.0833333333333333),(1000167,11446,0.0833333333333333),(1000167,11447,0.0833333333333333),(1000167,11448,0.0833333333333333),(1000167,11449,0.0833333333333333),(1000167,11450,0.0833333333333333),(1000167,11451,0.0833333333333333),(1000167,11452,0.0833333333333333),(1000167,11453,0.0833333333333333),(1000167,11454,0.0833333333333333),(1000167,11455,0.0833333333333333),(1000167,11487,0.0833333333333333),(1000167,11529,0.0833333333333333),(1000167,11566,0.0833333333333333),(1000167,11569,0.0833333333333333),(1000167,11572,0.0833333333333333),(1000167,11574,0.0833333333333333),(1000167,11579,0.0786246556753492),(1000167,11584,0.0833333333333333),(1000167,12093,0.0889002372000545),(1000167,12097,0.0833333333333333),(1000167,12098,0.0833333333333333),(1000167,12099,0.0833333333333333),(1000167,12179,0.0833333333333333),(1000167,12180,0.00903159331774576),(1000167,12181,0.00903159331774576),(1000167,12182,0.00903159331774576),(1000167,12183,0.00903159331774576),(1000167,12184,0.00903159331774576),(1000167,12185,0.00903159331774576),(1000167,12186,0.00903159331774576),(1000167,12187,0.00903159331774576),(1000167,12188,0.00903159331774576),(1000167,12189,0.00903159331774576),(1000167,12190,0.00903159331774576),(1000167,12191,0.00903159331774576),(1000167,12192,0.00903159331774576),(1000167,12193,0.00903159331774576),(1000167,12194,0.00903159331774576),(1000167,12195,0.00903159331774576),(1000167,12196,0.0646778203329414),(1000167,12206,0.166542083766465),(1000167,12207,0.166584696239965),(1000167,12241,0.0833333333333333),(1000167,12305,0.0833333333333333),(1000167,12365,0.0833333333333333),(1000167,12366,0.0833333333333333),(1000167,12367,0.0833333333333333),(1000167,12376,0.0833005072564828),(1000167,12383,0.0833005072564828),(1000167,12385,0.0833005072564828),(1000167,12386,0.0833005072564828),(1000167,12387,0.0833005072564828),(1000167,12441,0.166666666666667),(1000167,12442,0.166666666666667),(1000167,12487,0.333333333333333),(1000167,13278,0.0833333333333333),(1000167,16069,0.0832380162532896),(1000167,16281,0.0140463431166794),(1000167,16594,0.0833005072564828),(1000167,16595,0.0833005072564828),(1000167,16596,0.0833005072564828),(1000167,16597,0.0833005072564828),(1000167,16598,0.0833005072564828),(1000167,16622,0.0833005072564828),(1000167,17366,0.001990445859872),(1000167,17367,0.001990445859872),(1000167,17368,0.001990445859872),(1000167,17940,0.0833333333333333),(1000167,18025,0.0060210622118305),(1000167,18580,0.0833005072564828),(1000167,19400,-0.0715259574563592),(1000167,19759,0.0833333333333333),(1000167,19760,0.0833333333333333),(1000167,19761,0.0833333333333333),(1000167,19766,0.0833333333333333),(1000167,19767,0.0833333333333333),(1000167,19921,0.0833333333333333),(1000167,19922,0.0833333333333333),(1000167,20209,0.166666666666667),(1000167,20210,0.166666666666667),(1000167,20211,0.166666666666667),(1000167,20212,0.166666666666667),(1000167,20213,0.166666666666667),(1000167,20312,0.166666666666667),(1000167,20314,0.166666666666667),(1000167,20315,0.166666666666667),(1000167,20342,0.0833333333333333),(1000167,20494,0.0833333333333333),(1000167,20495,0.0833333333333333),(1000167,20526,0.333333333333333),(1000167,20530,0.333333333333333),(1000167,20533,0.0833333333333333),(1000167,21059,0.0833333333333333),(1000167,21071,0.166666666666667),(1000167,21603,0.0833333333333333),(1000167,21610,0.0833333333333333),(1000167,21611,0.0833333333333333),(1000167,21666,0.166584696239965),(1000167,21668,0.166666666666667),(1000167,21718,0.0833333333333333),(1000167,21802,0.166666666666667),(1000167,21803,0.0833333333333333),(1000167,21853,0.0833333333333333),(1000167,21855,0.0833333333333333),(1000167,21857,0.0833333333333333),(1000167,22043,0.0833333333333333),(1000167,22176,0.0833333333333333),(1000167,22178,0.0833333333333333),(1000167,22242,0.0833333333333333),(1000167,22551,0.0833333333333333),(1000167,22578,0.0769426043712937),(1000167,22761,0.0833333333333333),(1000167,22806,0.0833333333333333),(1000167,22807,0.0833333333333333),(1000167,22808,0.0833333333333333),(1000167,22809,0.0833333333333333),(1000167,23069,0.0833333333333333),(1000167,23566,0.0833333333333333),(1000167,23594,0.0833333333333333),(1000167,23606,0.0833333333333333),(1000167,23618,0.0833333333333333),(1000167,23950,0.0833333333333333),(1000167,24241,0.0833333333333333),(1000167,24242,0.0833005072564828),(1000167,24268,0.0833005072564828),(1000167,24270,0.0833005072564828),(1000167,24311,0.0833333333333333),(1000167,24312,0.0833333333333333),(1000167,24313,0.0833333333333333),(1000167,24314,0.0833333333333333),(1000167,24445,0.001990445859872),(1000167,24562,0.0833333333333333),(1000167,24563,0.0833333333333333),(1000167,24568,0.0832380162532896),(1000167,24571,0.0833333333333333),(1000167,24572,0.0833333333333333),(1000167,24606,0.0833333333333333),(1000167,24613,0.0833333333333333),(1000167,24624,0.0833333333333333),(1000167,24625,0.0833333333333333),(1000167,24764,0.0833333333333333),(1000167,25233,0.0833005072564828),(1000167,25235,0.0833005072564828),(1000167,25718,0.166666666666667),(1000167,25719,0.166666666666667),(1000167,25739,0.0833333333333333),(1000167,25810,0.0833333333333333),(1000167,25811,0.0833333333333333),(1000167,25862,0.0833333333333333),(1000167,25863,0.0833333333333333),(1000167,26252,0.0833333333333333),(1000167,26253,0.0833333333333333),(1000167,26254,0.0833333333333333),(1000167,26255,0.0833333333333333),(1000167,26256,0.0833333333333333),(1000167,26257,0.0833333333333333),(1000167,26258,0.0833333333333333),(1000167,26259,0.0833333333333333),(1000167,26260,0.0833333333333333),(1000167,26261,0.0833333333333333),(1000167,27309,0.001990445859872),(1000167,27902,0.0832380162532896),(1000167,27906,0.0833333333333333),(1000167,27911,0.0833333333333333),(1000167,27936,0.0832380162532896),(1000167,28073,0.166666666666667),(1000167,28164,0.0833333333333333),(1000167,28374,0.0833333333333333),(1000167,28585,0.0833333333333333),(1000167,28609,0.0889002372000545),(1000167,28615,0.0889002372000545),(1000167,28656,0.0889002372000545),(1000167,28667,0.0889002372000545),(1000167,28879,0.0833333333333333),(1000167,28880,0.0833333333333333),(1000168,1130,0.00151507385404694),(1000168,1131,0.00233570090076233),(1000168,1132,0.00233025811478461),(1000168,1133,0.00213533723763032),(1000168,1134,0.00241605256716078),(1000168,1135,0.00623231458943357),(1000168,1136,0.00622843283415141),(1000168,1137,0.00469456687002521),(1000168,1202,0.0020336787109591),(1000168,1216,0.0124126207272337),(1000168,1218,0.0020336787109591),(1000168,1811,0.04679400908036),(1000168,1815,0.00776029975055001),(1000168,1817,0.0124126207272337),(1000168,1819,0.769230769230769),(1000168,1821,0.769230769230769),(1000168,1823,0.769230769230769),(1000168,1825,0.769230769230769),(1000168,1827,0.769230769230769),(1000168,1829,0.769230769230769),(1000168,1831,0.769230769230769),(1000168,1833,0.769230769230769),(1000168,2184,0.0165856988625622),(1000168,2204,0.00702883442491871),(1000168,3300,0.0140463431166794),(1000168,3301,0.0140463431166794),(1000168,3302,0.0833333333333333),(1000168,3303,0.0833333333333333),(1000168,3304,0.0833333333333333),(1000168,3305,0.0833333333333333),(1000168,3306,0.0833333333333333),(1000168,3307,0.0833333333333333),(1000168,3308,0.0833333333333333),(1000168,3309,0.0833333333333333),(1000168,3310,0.0833333333333333),(1000168,3311,0.0140463431166794),(1000168,3312,0.0833333333333333),(1000168,3315,0.0833333333333333),(1000168,3316,0.0833333333333333),(1000168,3317,0.0833333333333333),(1000168,3318,0.0833333333333333),(1000168,3319,0.0833333333333333),(1000168,3320,0.0833333333333333),(1000168,3321,0.0833333333333333),(1000168,3322,0.0833333333333333),(1000168,3323,0.0833333333333333),(1000168,3324,0.0833333333333333),(1000168,3325,0.0833333333333333),(1000168,3326,0.0833333333333333),(1000168,3327,0.0833333333333333),(1000168,3328,0.0140463431166794),(1000168,3329,0.0833333333333333),(1000168,3330,0.0833333333333333),(1000168,3331,0.0833333333333333),(1000168,3332,0.0833333333333333),(1000168,3333,0.0833333333333333),(1000168,3334,0.0833333333333333),(1000168,3335,0.0833333333333333),(1000168,3336,0.0833333333333333),(1000168,3337,0.0833333333333333),(1000168,3338,0.0833333333333333),(1000168,3339,0.0833333333333333),(1000168,3340,0.0833333333333333),(1000168,3341,0.0833333333333333),(1000168,3342,0.0833333333333333),(1000168,3343,0.0833333333333333),(1000168,3344,0.0833333333333333),(1000168,3345,0.0833333333333333),(1000168,3346,0.0833333333333333),(1000168,3347,0.0833333333333333),(1000168,3348,0.0833333333333333),(1000168,3349,0.083333333333),(1000168,3350,0.083333333333),(1000168,3351,0.0833333333333333),(1000168,3352,0.0833333333333333),(1000168,3354,0.0833333333333333),(1000168,3355,0.0833333333333333),(1000168,3356,0.0086413667660438),(1000168,3357,0.0831988924851884),(1000168,3358,0.0086413667660438),(1000168,3359,0.0086413667660438),(1000168,3361,0.0833333333333333),(1000168,3363,0.0833333333333333),(1000168,3368,0.0833333333333333),(1000168,3373,0.0833333333333333),(1000168,3374,0.0176898701327485),(1000168,3375,0.0833333333333333),(1000168,3376,0.0833333333333333),(1000168,3377,0.0833333333333333),(1000168,3378,0.0833333333333333),(1000168,3379,0.0833333333333333),(1000168,3380,0.0833333333333333),(1000168,3385,0.0833333333333333),(1000168,3386,0.0769426043712937),(1000168,3387,0.0833333333333333),(1000168,3388,0.0833333333333333),(1000168,3389,0.0833333333333333),(1000168,3392,0.0833333333333333),(1000168,3393,0.0833333333333333),(1000168,3394,0.0833333333333333),(1000168,3395,0.083333),(1000168,3396,0.0834076317088146),(1000168,3397,0.0834076317088146),(1000168,3398,0.0834076317088146),(1000168,3400,0.0833333333333333),(1000168,3402,0.0833333333333333),(1000168,3403,0.0833333333333333),(1000168,3405,0.0833333333333333),(1000168,3406,0.0833333333333333),(1000168,3409,0.0833333333333333),(1000168,3410,0.0833333333333333),(1000168,3411,0.0833333333333333),(1000168,3412,0.0833333333333333),(1000168,3413,0.0140463431166794),(1000168,3416,0.0140463431166794),(1000168,3417,0.0833333333333333),(1000168,3418,0.0833333333333333),(1000168,3419,0.0833333333333333),(1000168,3420,0.0833333333333333),(1000168,3421,0.0833333333333333),(1000168,3422,0.0833333333333333),(1000168,3423,0.0833333333333333),(1000168,3424,0.0833333333333333),(1000168,3425,0.0833333333333333),(1000168,3426,0.0140463431166794),(1000168,3427,0.0833333333333333),(1000168,3428,0.0833333333333333),(1000168,3429,0.0833333333333333),(1000168,3430,0.0834076317088146),(1000168,3431,0.0833333333333333),(1000168,3432,0.0833333333333333),(1000168,3433,0.0833333333333333),(1000168,3434,0.0833333333333333),(1000168,3435,0.0833333333333333),(1000168,3436,0.0140463431166794),(1000168,3437,0.0833333333333333),(1000168,3438,0.0833333333333333),(1000168,3439,0.0833333333333333),(1000168,3441,0.0833333333333333),(1000168,3442,0.0833333333333333),(1000168,3443,0.0834076317088146),(1000168,3444,0.0834076317088146),(1000168,3446,0.0834076317088146),(1000168,3447,0.0834076317088146),(1000168,3449,0.0140463431166794),(1000168,3450,0.0833333333333333),(1000168,3451,0.0833333333333333),(1000168,3452,0.0833333333333333),(1000168,3453,0.0833333333333333),(1000168,3454,0.0833333333333333),(1000168,3455,0.0140463431166794),(1000168,3456,0.0833333333333333),(1000168,3551,0.0833333333333333),(1000168,3645,-0.00670419204782632),(1000168,3699,-0.00389261669792987),(1000168,3731,0.0833333333333333),(1000168,3732,0.0833333333333333),(1000168,9828,0.00455591538090099),(1000168,9852,0.00789829896901656),(1000168,10039,0.0833333333333333),(1000168,10040,0.0833333333333333),(1000168,10247,0.0020336787109591),(1000168,11082,0.166948338036508),(1000168,11129,0.00142962956881407),(1000168,11130,0.00142962956881407),(1000168,11207,0.0833333333333333),(1000168,11395,0.0086413667660438),(1000168,11433,0.0833333333333333),(1000168,11441,0.0833333333333333),(1000168,11442,0.0833333333333333),(1000168,11443,0.0833333333333333),(1000168,11444,0.0833333333333333),(1000168,11445,0.0833333333333333),(1000168,11446,0.0833333333333333),(1000168,11447,0.0833333333333333),(1000168,11448,0.0833333333333333),(1000168,11449,0.0833333333333333),(1000168,11450,0.0833333333333333),(1000168,11451,0.0833333333333333),(1000168,11452,0.0833333333333333),(1000168,11453,0.0833333333333333),(1000168,11454,0.0833333333333333),(1000168,11455,0.0833333333333333),(1000168,11487,0.0833333333333333),(1000168,11529,0.0833333333333333),(1000168,11566,0.0833333333333333),(1000168,11569,0.0833333333333333),(1000168,11572,0.0833333333333333),(1000168,11574,0.0833333333333333),(1000168,11579,0.0810070613669679),(1000168,11584,0.0833333333333333),(1000168,12093,0.0823350736992171),(1000168,12097,0.0833333333333333),(1000168,12098,0.0833333333333333),(1000168,12099,0.0833333333333333),(1000168,12179,0.0833333333333333),(1000168,12180,0.00903159331774576),(1000168,12181,0.00903159331774576),(1000168,12182,0.00903159331774576),(1000168,12183,0.00903159331774576),(1000168,12184,0.00903159331774576),(1000168,12185,0.00903159331774576),(1000168,12186,0.00903159331774576),(1000168,12187,0.00903159331774576),(1000168,12188,0.00903159331774576),(1000168,12189,0.00903159331774576),(1000168,12190,0.00903159331774576),(1000168,12191,0.00903159331774576),(1000168,12192,0.00903159331774576),(1000168,12193,0.00903159331774576),(1000168,12194,0.00903159331774576),(1000168,12195,0.00903159331774576),(1000168,12196,0.0782601626028592),(1000168,12206,0.166948338036508),(1000168,12207,0.166942148017277),(1000168,12210,0.333333333333333),(1000168,12211,0.333333333333333),(1000168,12212,0.333333333333333),(1000168,12241,0.0833333333333333),(1000168,12305,0.0833333333333333),(1000168,12365,0.0833333333333333),(1000168,12366,0.0833333333333333),(1000168,12367,0.0833333333333333),(1000168,12376,0.0834076317088146),(1000168,12383,0.0834076317088146),(1000168,12385,0.0834076317088146),(1000168,12386,0.0834076317088146),(1000168,12387,0.0834076317088146),(1000168,12486,0.333333333333333),(1000168,12836,-0.0705467372134039),(1000168,13278,0.0833333333333333),(1000168,15509,0.25),(1000168,15511,0.25),(1000168,16069,0.0834671082709957),(1000168,16281,0.0140463431166794),(1000168,16594,0.0834076317088146),(1000168,16595,0.0834076317088146),(1000168,16596,0.0834076317088146),(1000168,16597,0.0834076317088146),(1000168,16598,0.0834076317088146),(1000168,16622,0.0834076317088146),(1000168,17366,0.001990445859872),(1000168,17367,0.001990445859872),(1000168,17368,0.001990445859872),(1000168,17940,0.0833333333333333),(1000168,18025,0.0060210622118305),(1000168,18580,0.0834076317088146),(1000168,19400,-0.0714569193166812),(1000168,19759,0.0833333333333333),(1000168,19760,0.0833333333333333),(1000168,19761,0.0833333333333333),(1000168,19766,0.0833333333333333),(1000168,19767,0.0833333333333333),(1000168,19921,0.0833333333333333),(1000168,19922,0.0833333333333333),(1000168,20342,0.0833333333333333),(1000168,20494,0.0833333333333333),(1000168,20495,0.0833333333333333),(1000168,20527,0.333333333333333),(1000168,20531,0.333333333333333),(1000168,20533,0.0833333333333333),(1000168,21059,0.0833333333333333),(1000168,21603,0.0833333333333333),(1000168,21610,0.0833333333333333),(1000168,21611,0.0833333333333333),(1000168,21666,0.166942148017277),(1000168,21718,0.0833333333333333),(1000168,21803,0.0833333333333333),(1000168,21853,0.0833333333333333),(1000168,21855,0.0833333333333333),(1000168,21857,0.0833333333333333),(1000168,22043,0.0833333333333333),(1000168,22176,0.0833333333333333),(1000168,22178,0.0833333333333333),(1000168,22242,0.0833333333333333),(1000168,22551,0.0833333333333333),(1000168,22578,0.0769426043712937),(1000168,22761,0.0833333333333333),(1000168,22806,0.0833333333333333),(1000168,22807,0.0833333333333333),(1000168,22808,0.0833333333333333),(1000168,22809,0.0833333333333333),(1000168,23069,0.0833333333333333),(1000168,23566,0.0833333333333333),(1000168,23594,0.0833333333333333),(1000168,23606,0.0833333333333333),(1000168,23618,0.0833333333333333),(1000168,23950,0.0833333333333333),(1000168,24241,0.0833333333333333),(1000168,24242,0.0834076317088146),(1000168,24268,0.0834076317088146),(1000168,24270,0.0834076317088146),(1000168,24311,0.0833333333333333),(1000168,24312,0.0833333333333333),(1000168,24313,0.0833333333333333),(1000168,24314,0.0833333333333333),(1000168,24445,0.001990445859872),(1000168,24562,0.0833333333333333),(1000168,24563,0.0833333333333333),(1000168,24568,0.0834671082709957),(1000168,24571,0.0833333333333333),(1000168,24572,0.0833333333333333),(1000168,24606,0.0833333333333333),(1000168,24613,0.0833333333333333),(1000168,24624,0.0833333333333333),(1000168,24625,0.0833333333333333),(1000168,24764,0.0833333333333333),(1000168,25233,0.0834076317088146),(1000168,25235,0.0834076317088146),(1000168,25739,0.0833333333333333),(1000168,25810,0.0833333333333333),(1000168,25811,0.0833333333333333),(1000168,25862,0.0833333333333333),(1000168,25863,0.0833333333333333),(1000168,26252,0.0833333333333333),(1000168,26253,0.0833333333333333),(1000168,26254,0.0833333333333333),(1000168,26255,0.0833333333333333),(1000168,26256,0.0833333333333333),(1000168,26257,0.0833333333333333),(1000168,26258,0.0833333333333333),(1000168,26259,0.0833333333333333),(1000168,26260,0.0833333333333333),(1000168,26261,0.0833333333333333),(1000168,27309,0.001990445859872),(1000168,27902,0.0834671082709957),(1000168,27906,0.0833333333333333),(1000168,27911,0.0833333333333333),(1000168,27936,0.0834671082709957),(1000168,28164,0.0833333333333333),(1000168,28374,0.0833333333333333),(1000168,28585,0.0833333333333333),(1000168,28609,0.0823350736992171),(1000168,28615,0.0823350736992171),(1000168,28656,0.0823350736992171),(1000168,28667,0.0823350736992171),(1000168,28879,0.0833333333333333),(1000168,28880,0.0833333333333333),(1000169,41,0.0059168748604954),(1000169,1130,0.00151507385404694),(1000169,1131,0.00233570090076233),(1000169,1132,0.00233025811478461),(1000169,1133,0.00213533723763032),(1000169,1134,0.00241605256716078),(1000169,1135,0.00623231458943357),(1000169,1136,0.00622843283415141),(1000169,1137,0.00469456687002521),(1000169,1202,0.0020336787109591),(1000169,1218,0.0020336787109591),(1000169,2204,0.00702883442491871),(1000169,2454,0.0139076246783791),(1000169,2455,0.0139076246783791),(1000169,3300,0.0140463431166794),(1000169,3301,0.0140463431166794),(1000169,3302,0.0833333333333333),(1000169,3303,0.0833333333333333),(1000169,3304,0.0833333333333333),(1000169,3305,0.0833333333333333),(1000169,3306,0.0833333333333333),(1000169,3307,0.0833333333333333),(1000169,3308,0.0833333333333333),(1000169,3309,0.0833333333333333),(1000169,3310,0.0833333333333333),(1000169,3311,0.0140463431166794),(1000169,3312,0.0833333333333333),(1000169,3315,0.0833333333333333),(1000169,3316,0.0833333333333333),(1000169,3317,0.0833333333333333),(1000169,3318,0.0833333333333333),(1000169,3319,0.0833333333333333),(1000169,3320,0.0833333333333333),(1000169,3321,0.0833333333333333),(1000169,3322,0.0833333333333333),(1000169,3323,0.0833333333333333),(1000169,3324,0.0833333333333333),(1000169,3325,0.0833333333333333),(1000169,3326,0.0833333333333333),(1000169,3327,0.0833333333333333),(1000169,3328,0.0140463431166794),(1000169,3329,0.0833333333333333),(1000169,3330,0.0833333333333333),(1000169,3331,0.0833333333333333),(1000169,3332,0.0833333333333333),(1000169,3333,0.0833333333333333),(1000169,3334,0.0833333333333333),(1000169,3335,0.0833333333333333),(1000169,3336,0.0833333333333333),(1000169,3337,0.0833333333333333),(1000169,3338,0.0833333333333333),(1000169,3339,0.0833333333333333),(1000169,3340,0.0833333333333333),(1000169,3341,0.0833333333333333),(1000169,3342,0.0833333333333333),(1000169,3343,0.0833333333333333),(1000169,3344,0.0833333333333333),(1000169,3345,0.0833333333333333),(1000169,3346,0.0833333333333333),(1000169,3347,0.0833333333333333),(1000169,3348,0.0833333333333333),(1000169,3349,0.083333333333),(1000169,3350,0.083333333333),(1000169,3351,0.0833333333333333),(1000169,3352,0.0833333333333333),(1000169,3354,0.0833333333333333),(1000169,3355,0.0833333333333333),(1000169,3356,0.0086413667660438),(1000169,3357,0.0966073631182296),(1000169,3358,0.0086413667660438),(1000169,3359,0.0086413667660438),(1000169,3361,0.0833333333333333),(1000169,3363,0.0833333333333333),(1000169,3368,0.0833333333333333),(1000169,3373,0.0833333333333333),(1000169,3374,0.0176898701327485),(1000169,3375,0.0833333333333333),(1000169,3376,0.0833333333333333),(1000169,3377,0.0833333333333333),(1000169,3378,0.0833333333333333),(1000169,3379,0.0833333333333333),(1000169,3380,0.0833333333333333),(1000169,3385,0.0833333333333333),(1000169,3386,0.0769426043712937),(1000169,3387,0.0833333333333333),(1000169,3388,0.0833333333333333),(1000169,3389,0.0833333333333333),(1000169,3392,0.0833333333333333),(1000169,3393,0.0833333333333333),(1000169,3394,0.0833333333333333),(1000169,3395,0.083333),(1000169,3396,0.0833347229398383),(1000169,3397,0.0833347229398383),(1000169,3398,0.0833347229398383),(1000169,3400,0.0833333333333333),(1000169,3402,0.0833333333333333),(1000169,3403,0.0833333333333333),(1000169,3405,0.0833333333333333),(1000169,3406,0.0833333333333333),(1000169,3409,0.0833333333333333),(1000169,3410,0.0833333333333333),(1000169,3411,0.0833333333333333),(1000169,3412,0.0833333333333333),(1000169,3413,0.0140463431166794),(1000169,3416,0.0140463431166794),(1000169,3417,0.0833333333333333),(1000169,3418,0.0833333333333333),(1000169,3419,0.0833333333333333),(1000169,3420,0.0833333333333333),(1000169,3421,0.0833333333333333),(1000169,3422,0.0833333333333333),(1000169,3423,0.0833333333333333),(1000169,3424,0.0833333333333333),(1000169,3425,0.0833333333333333),(1000169,3426,0.0140463431166794),(1000169,3427,0.0833333333333333),(1000169,3428,0.0833333333333333),(1000169,3429,0.0833333333333333),(1000169,3430,0.0834671082709957),(1000169,3431,0.0833333333333333),(1000169,3432,0.0833333333333333),(1000169,3433,0.0833333333333333),(1000169,3434,0.0833333333333333),(1000169,3435,0.0833333333333333),(1000169,3436,0.0140463431166794),(1000169,3437,0.0833333333333333),(1000169,3438,0.0833333333333333),(1000169,3439,0.0833333333333333),(1000169,3441,0.0833333333333333),(1000169,3442,0.0833333333333333),(1000169,3443,0.0834671082709957),(1000169,3444,0.0834671082709957),(1000169,3446,0.0834671082709957),(1000169,3447,0.0834671082709957),(1000169,3449,0.0140463431166794),(1000169,3450,0.0833333333333333),(1000169,3451,0.0833333333333333),(1000169,3452,0.0833333333333333),(1000169,3453,0.0833333333333333),(1000169,3454,0.0833333333333333),(1000169,3455,0.0140463431166794),(1000169,3456,0.0833333333333333),(1000169,3551,0.0833333333333333),(1000169,3645,-0.00670419204782632),(1000169,3731,0.0833333333333333),(1000169,3732,0.0833333333333333),(1000169,3812,-0.00539756871032445),(1000169,9850,0.00711366442245851),(1000169,10039,0.0833333333333333),(1000169,10040,0.0833333333333333),(1000169,10247,0.0020336787109591),(1000169,11082,0.166637483725898),(1000169,11129,0.00142962956881407),(1000169,11130,0.00142962956881407),(1000169,11207,0.0833333333333333),(1000169,11395,0.0086413667660438),(1000169,11433,0.0833333333333333),(1000169,11441,0.0833333333333333),(1000169,11442,0.0833333333333333),(1000169,11443,0.0833333333333333),(1000169,11444,0.0833333333333333),(1000169,11445,0.0833333333333333),(1000169,11446,0.0833333333333333),(1000169,11447,0.0833333333333333),(1000169,11448,0.0833333333333333),(1000169,11449,0.0833333333333333),(1000169,11450,0.0833333333333333),(1000169,11451,0.0833333333333333),(1000169,11452,0.0833333333333333),(1000169,11453,0.0833333333333333),(1000169,11454,0.0833333333333333),(1000169,11455,0.0833333333333333),(1000169,11487,0.0833333333333333),(1000169,11529,0.0833333333333333),(1000169,11566,0.0833333333333333),(1000169,11569,0.0833333333333333),(1000169,11572,0.0833333333333333),(1000169,11574,0.0833333333333333),(1000169,11579,0.0802050112544237),(1000169,11584,0.0833333333333333),(1000169,12093,0.0995442933827436),(1000169,12097,0.0833333333333333),(1000169,12098,0.0833333333333333),(1000169,12099,0.0833333333333333),(1000169,12179,0.0833333333333333),(1000169,12180,0.00903159331774576),(1000169,12181,0.00903159331774576),(1000169,12182,0.00903159331774576),(1000169,12183,0.00903159331774576),(1000169,12184,0.00903159331774576),(1000169,12185,0.00903159331774576),(1000169,12186,0.00903159331774576),(1000169,12187,0.00903159331774576),(1000169,12188,0.00903159331774576),(1000169,12189,0.00903159331774576),(1000169,12190,0.00903159331774576),(1000169,12191,0.00903159331774576),(1000169,12192,0.00903159331774576),(1000169,12193,0.00903159331774576),(1000169,12194,0.00903159331774576),(1000169,12195,0.00903159331774576),(1000169,12196,0.0946947967494596),(1000169,12206,0.166637483725898),(1000169,12207,0.166584696239965),(1000169,12210,0.333333333333333),(1000169,12211,0.333333333333333),(1000169,12212,0.333333333333333),(1000169,12241,0.0833333333333333),(1000169,12305,0.0833333333333333),(1000169,12365,0.0833333333333333),(1000169,12366,0.0833333333333333),(1000169,12367,0.0833333333333333),(1000169,12376,0.0834671082709957),(1000169,12383,0.0834671082709957),(1000169,12385,0.0834671082709957),(1000169,12386,0.0834671082709957),(1000169,12387,0.0834671082709957),(1000169,12486,0.333333333333333),(1000169,13278,0.0833333333333333),(1000169,16069,0.0833347229398383),(1000169,16281,0.0140463431166794),(1000169,16594,0.0834671082709957),(1000169,16595,0.0834671082709957),(1000169,16596,0.0834671082709957),(1000169,16597,0.0834671082709957),(1000169,16598,0.0834671082709957),(1000169,16622,0.0834671082709957),(1000169,17366,0.001990445859872),(1000169,17367,0.001990445859872),(1000169,17368,0.001990445859872),(1000169,17940,0.0833333333333333),(1000169,18025,0.0060210622118305),(1000169,18580,0.0834671082709957),(1000169,19400,-0.0714100487717093),(1000169,19759,0.0833333333333333),(1000169,19760,0.0833333333333333),(1000169,19761,0.0833333333333333),(1000169,19766,0.0833333333333333),(1000169,19767,0.0833333333333333),(1000169,19921,0.0833333333333333),(1000169,19922,0.0833333333333333),(1000169,20342,0.0833333333333333),(1000169,20494,0.0833333333333333),(1000169,20495,0.0833333333333333),(1000169,20527,0.333333333333333),(1000169,20531,0.333333333333333),(1000169,20533,0.0833333333333333),(1000169,21059,0.0833333333333333),(1000169,21603,0.0833333333333333),(1000169,21610,0.0833333333333333),(1000169,21611,0.0833333333333333),(1000169,21666,0.166584696239965),(1000169,21718,0.0833333333333333),(1000169,21803,0.0833333333333333),(1000169,21853,0.0833333333333333),(1000169,21855,0.0833333333333333),(1000169,21857,0.0833333333333333),(1000169,22043,0.0833333333333333),(1000169,22176,0.0833333333333333),(1000169,22178,0.0833333333333333),(1000169,22242,0.0833333333333333),(1000169,22551,0.0833333333333333),(1000169,22578,0.0769426043712937),(1000169,22761,0.0833333333333333),(1000169,22806,0.0833333333333333),(1000169,22807,0.0833333333333333),(1000169,22808,0.0833333333333333),(1000169,22809,0.0833333333333333),(1000169,23069,0.0833333333333333),(1000169,23566,0.0833333333333333),(1000169,23594,0.0833333333333333),(1000169,23606,0.0833333333333333),(1000169,23618,0.0833333333333333),(1000169,23950,0.0833333333333333),(1000169,24241,0.0833333333333333),(1000169,24242,0.0834671082709957),(1000169,24268,0.0834671082709957),(1000169,24270,0.0834671082709957),(1000169,24311,0.0833333333333333),(1000169,24312,0.0833333333333333),(1000169,24313,0.0833333333333333),(1000169,24314,0.0833333333333333),(1000169,24445,0.001990445859872),(1000169,24562,0.0833333333333333),(1000169,24563,0.0833333333333333),(1000169,24568,0.0833347229398383),(1000169,24571,0.0833333333333333),(1000169,24572,0.0833333333333333),(1000169,24606,0.0833333333333333),(1000169,24613,0.0833333333333333),(1000169,24624,0.0833333333333333),(1000169,24625,0.0833333333333333),(1000169,24764,0.0833333333333333),(1000169,25233,0.0834671082709957),(1000169,25235,0.0834671082709957),(1000169,25739,0.0833333333333333),(1000169,25810,0.0833333333333333),(1000169,25811,0.0833333333333333),(1000169,25862,0.0833333333333333),(1000169,25863,0.0833333333333333),(1000169,26252,0.0833333333333333),(1000169,26253,0.0833333333333333),(1000169,26254,0.0833333333333333),(1000169,26255,0.0833333333333333),(1000169,26256,0.0833333333333333),(1000169,26257,0.0833333333333333),(1000169,26258,0.0833333333333333),(1000169,26259,0.0833333333333333),(1000169,26260,0.0833333333333333),(1000169,26261,0.0833333333333333),(1000169,27309,0.001990445859872),(1000169,27902,0.0833347229398383),(1000169,27906,0.0833333333333333),(1000169,27911,0.0833333333333333),(1000169,27936,0.0833347229398383),(1000169,28164,0.0833333333333333),(1000169,28374,0.0833333333333333),(1000169,28585,0.0833333333333333),(1000169,28609,0.0995442933827436),(1000169,28615,0.0995442933827436),(1000169,28656,0.0995442933827436),(1000169,28667,0.0995442933827436),(1000169,28879,0.0833333333333333),(1000169,28880,0.0833333333333333),(1000170,41,-0.00838149063805407),(1000170,811,0.0063576699300406),(1000170,813,0.00350494106972787),(1000170,814,0.00375552955387329),(1000170,879,0.00534474439183068),(1000170,881,0.0134566869131638),(1000170,884,0.0134748195559614),(1000170,886,0.0136588703695291),(1000170,3300,0.0140463431166794),(1000170,3301,0.0140463431166794),(1000170,3302,0.0833333333333333),(1000170,3303,0.0833333333333333),(1000170,3304,0.0833333333333333),(1000170,3305,0.0833333333333333),(1000170,3306,0.0833333333333333),(1000170,3307,0.0833333333333333),(1000170,3308,0.0833333333333333),(1000170,3309,0.0833333333333333),(1000170,3310,0.0833333333333333),(1000170,3311,0.0140463431166794),(1000170,3312,0.0833333333333333),(1000170,3315,0.0833333333333333),(1000170,3316,0.0833333333333333),(1000170,3317,0.0833333333333333),(1000170,3318,0.0833333333333333),(1000170,3319,0.0833333333333333),(1000170,3320,0.0833333333333333),(1000170,3321,0.0833333333333333),(1000170,3322,0.0833333333333333),(1000170,3323,0.0833333333333333),(1000170,3324,0.0833333333333333),(1000170,3325,0.0833333333333333),(1000170,3326,0.0833333333333333),(1000170,3327,0.0833333333333333),(1000170,3328,0.0140463431166794),(1000170,3329,0.0833333333333333),(1000170,3330,0.0833333333333333),(1000170,3331,0.0833333333333333),(1000170,3332,0.0833333333333333),(1000170,3333,0.0833333333333333),(1000170,3334,0.0833333333333333),(1000170,3335,0.0833333333333333),(1000170,3336,0.0833333333333333),(1000170,3337,0.0833333333333333),(1000170,3338,0.0833333333333333),(1000170,3339,0.0833333333333333),(1000170,3340,0.0833333333333333),(1000170,3341,0.0833333333333333),(1000170,3342,0.0833333333333333),(1000170,3343,0.0833333333333333),(1000170,3344,0.0833333333333333),(1000170,3345,0.0833333333333333),(1000170,3346,0.0833333333333333),(1000170,3347,0.0833333333333333),(1000170,3348,0.0833333333333333),(1000170,3349,0.083333333333),(1000170,3350,0.083333333333),(1000170,3351,0.0833333333333333),(1000170,3352,0.0833333333333333),(1000170,3354,0.0833333333333333),(1000170,3355,0.0833333333333333),(1000170,3356,0.0086413667660438),(1000170,3357,0.0650447564234893),(1000170,3358,0.0086413667660438),(1000170,3359,0.0086413667660438),(1000170,3361,0.0833333333333333),(1000170,3363,0.0833333333333333),(1000170,3368,0.0833333333333333),(1000170,3373,0.0833333333333333),(1000170,3374,0.0176898701327485),(1000170,3375,0.0833333333333333),(1000170,3376,0.0833333333333333),(1000170,3377,0.0833333333333333),(1000170,3378,0.0833333333333333),(1000170,3379,0.0833333333333333),(1000170,3380,0.0833333333333333),(1000170,3385,0.0833333333333333),(1000170,3386,0.0769426043712937),(1000170,3387,0.0833333333333333),(1000170,3388,0.0833333333333333),(1000170,3389,0.0833333333333333),(1000170,3392,0.0833333333333333),(1000170,3393,0.0833333333333333),(1000170,3394,0.0833333333333333),(1000170,3395,0.083333),(1000170,3396,0.0832513882168985),(1000170,3397,0.0832513882168985),(1000170,3398,0.0832513882168985),(1000170,3400,0.0833333333333333),(1000170,3402,0.0833333333333333),(1000170,3403,0.0833333333333333),(1000170,3405,0.0833333333333333),(1000170,3406,0.0833333333333333),(1000170,3409,0.0833333333333333),(1000170,3410,0.0833333333333333),(1000170,3411,0.0833333333333333),(1000170,3412,0.0833333333333333),(1000170,3413,0.0140463431166794),(1000170,3416,0.0140463431166794),(1000170,3417,0.0833333333333333),(1000170,3418,0.0833333333333333),(1000170,3419,0.0833333333333333),(1000170,3420,0.0833333333333333),(1000170,3421,0.0833333333333333),(1000170,3422,0.0833333333333333),(1000170,3423,0.0833333333333333),(1000170,3424,0.0833333333333333),(1000170,3425,0.0833333333333333),(1000170,3426,0.0140463431166794),(1000170,3427,0.0833333333333333),(1000170,3428,0.0833333333333333),(1000170,3429,0.0833333333333333),(1000170,3430,0.0833263894675444),(1000170,3431,0.0833333333333333),(1000170,3432,0.0833333333333333),(1000170,3433,0.0833333333333333),(1000170,3434,0.0833333333333333),(1000170,3435,0.0833333333333333),(1000170,3436,0.0140463431166794),(1000170,3437,0.0833333333333333),(1000170,3438,0.0833333333333333),(1000170,3439,0.0833333333333333),(1000170,3441,0.0833333333333333),(1000170,3442,0.0833333333333333),(1000170,3443,0.0833263894675444),(1000170,3444,0.0833263894675444),(1000170,3446,0.0833263894675444),(1000170,3447,0.0833263894675444),(1000170,3449,0.0140463431166794),(1000170,3450,0.0833333333333333),(1000170,3451,0.0833333333333333),(1000170,3452,0.0833333333333333),(1000170,3453,0.0833333333333333),(1000170,3454,0.0833333333333333),(1000170,3455,0.0140463431166794),(1000170,3456,0.0833333333333333),(1000170,3551,0.0833333333333333),(1000170,3643,0.00667765843346727),(1000170,3645,-0.00670419204782632),(1000170,3725,0.014870360304685),(1000170,3731,0.0833333333333333),(1000170,3732,0.0833333333333333),(1000170,10039,0.0833333333333333),(1000170,10040,0.0833333333333333),(1000170,11084,0.333333333333333),(1000170,11132,0.0103998399734633),(1000170,11133,0.0103998399734633),(1000170,11207,0.0833333333333333),(1000170,11395,0.0086413667660438),(1000170,11433,0.0833333333333333),(1000170,11441,0.0833333333333333),(1000170,11442,0.0833333333333333),(1000170,11443,0.0833333333333333),(1000170,11444,0.0833333333333333),(1000170,11445,0.0833333333333333),(1000170,11446,0.0833333333333333),(1000170,11447,0.0833333333333333),(1000170,11448,0.0833333333333333),(1000170,11449,0.0833333333333333),(1000170,11450,0.0833333333333333),(1000170,11451,0.0833333333333333),(1000170,11452,0.0833333333333333),(1000170,11453,0.0833333333333333),(1000170,11454,0.0833333333333333),(1000170,11455,0.0833333333333333),(1000170,11487,0.0833333333333333),(1000170,11529,0.0833333333333333),(1000170,11566,0.0833333333333333),(1000170,11569,0.0833333333333333),(1000170,11572,0.0833333333333333),(1000170,11574,0.0833333333333333),(1000170,11579,0.082635303300444),(1000170,11584,0.0833333333333333),(1000170,12093,0.0738100162901289),(1000170,12097,0.0833333333333333),(1000170,12098,0.0833333333333333),(1000170,12099,0.0833333333333333),(1000170,12179,0.0833333333333333),(1000170,12196,0.0952820199456638),(1000170,12201,0.333333333333333),(1000170,12202,0.333333333333333),(1000170,12203,0.333333333333333),(1000170,12208,0.333333333333333),(1000170,12209,0.333333333333333),(1000170,12241,0.0833333333333333),(1000170,12305,0.0833333333333333),(1000170,12365,0.0833333333333333),(1000170,12366,0.0833333333333333),(1000170,12367,0.0833333333333333),(1000170,12376,0.0833263894675444),(1000170,12383,0.0833263894675444),(1000170,12385,0.0833263894675444),(1000170,12386,0.0833263894675444),(1000170,12387,0.0833263894675444),(1000170,12441,0.166666666666667),(1000170,12442,0.166666666666667),(1000170,12485,0.333333333333333),(1000170,13278,0.0833333333333333),(1000170,16069,0.0834097158570119),(1000170,16281,0.0140463431166794),(1000170,16594,0.0833263894675444),(1000170,16595,0.0833263894675444),(1000170,16596,0.0833263894675444),(1000170,16597,0.0833263894675444),(1000170,16598,0.0833263894675444),(1000170,16622,0.0833263894675444),(1000170,17366,0.001990445859872),(1000170,17367,0.001990445859872),(1000170,17368,0.001990445859872),(1000170,17940,0.0833333333333333),(1000170,18580,0.0833263894675444),(1000170,19400,-0.0713957331577952),(1000170,19759,0.0833333333333333),(1000170,19760,0.0833333333333333),(1000170,19761,0.0833333333333333),(1000170,19766,0.0833333333333333),(1000170,19767,0.0833333333333333),(1000170,19921,0.0833333333333333),(1000170,19922,0.0833333333333333),(1000170,20209,0.166666666666667),(1000170,20210,0.166666666666667),(1000170,20211,0.166666666666667),(1000170,20212,0.166666666666667),(1000170,20213,0.166666666666667),(1000170,20312,0.166666666666667),(1000170,20314,0.166666666666667),(1000170,20315,0.166666666666667),(1000170,20342,0.0833333333333333),(1000170,20494,0.0833333333333333),(1000170,20495,0.0833333333333333),(1000170,20528,0.333333333333333),(1000170,20532,0.333333333333333),(1000170,20533,0.0833333333333333),(1000170,21059,0.0833333333333333),(1000170,21071,0.166666666666667),(1000170,21603,0.0833333333333333),(1000170,21610,0.0833333333333333),(1000170,21611,0.0833333333333333),(1000170,21667,0.333333333333333),(1000170,21668,0.166666666666667),(1000170,21718,0.0833333333333333),(1000170,21802,0.166666666666667),(1000170,21803,0.0833333333333333),(1000170,21853,0.0833333333333333),(1000170,21855,0.0833333333333333),(1000170,21857,0.0833333333333333),(1000170,22043,0.0833333333333333),(1000170,22176,0.0833333333333333),(1000170,22178,0.0833333333333333),(1000170,22242,0.0833333333333333),(1000170,22551,0.0833333333333333),(1000170,22578,0.0769426043712937),(1000170,22761,0.0833333333333333),(1000170,22806,0.0833333333333333),(1000170,22807,0.0833333333333333),(1000170,22808,0.0833333333333333),(1000170,22809,0.0833333333333333),(1000170,23069,0.0833333333333333),(1000170,23566,0.0833333333333333),(1000170,23594,0.0833333333333333),(1000170,23606,0.0833333333333333),(1000170,23618,0.0833333333333333),(1000170,23950,0.0833333333333333),(1000170,24241,0.0833333333333333),(1000170,24242,0.0833263894675444),(1000170,24268,0.0833263894675444),(1000170,24270,0.0833263894675444),(1000170,24311,0.0833333333333333),(1000170,24312,0.0833333333333333),(1000170,24313,0.0833333333333333),(1000170,24314,0.0833333333333333),(1000170,24445,0.001990445859872),(1000170,24562,0.0833333333333333),(1000170,24563,0.0833333333333333),(1000170,24568,0.0834097158570119),(1000170,24571,0.0833333333333333),(1000170,24572,0.0833333333333333),(1000170,24606,0.0833333333333333),(1000170,24613,0.0833333333333333),(1000170,24624,0.0833333333333333),(1000170,24625,0.0833333333333333),(1000170,24764,0.0833333333333333),(1000170,25233,0.0833263894675444),(1000170,25235,0.0833263894675444),(1000170,25718,0.166666666666667),(1000170,25719,0.166666666666667),(1000170,25739,0.0833333333333333),(1000170,25810,0.0833333333333333),(1000170,25811,0.0833333333333333),(1000170,25862,0.0833333333333333),(1000170,25863,0.0833333333333333),(1000170,26252,0.0833333333333333),(1000170,26253,0.0833333333333333),(1000170,26254,0.0833333333333333),(1000170,26255,0.0833333333333333),(1000170,26256,0.0833333333333333),(1000170,26257,0.0833333333333333),(1000170,26258,0.0833333333333333),(1000170,26259,0.0833333333333333),(1000170,26260,0.0833333333333333),(1000170,26261,0.0833333333333333),(1000170,27309,0.001990445859872),(1000170,27902,0.0834097158570119),(1000170,27906,0.0833333333333333),(1000170,27911,0.0833333333333333),(1000170,27936,0.0834097158570119),(1000170,28073,0.166666666666667),(1000170,28164,0.0833333333333333),(1000170,28374,0.0833333333333333),(1000170,28585,0.0833333333333333),(1000170,28609,0.0738100162901289),(1000170,28615,0.0738100162901289),(1000170,28656,0.0738100162901289),(1000170,28667,0.0738100162901289),(1000170,28879,0.0833333333333333),(1000170,28880,0.0833333333333333),(1000171,811,0.0063576699300406),(1000171,814,0.00375552955387329),(1000171,879,0.00534474439183068),(1000171,881,0.0134566869131638),(1000171,883,0.0136588703695291),(1000171,884,0.0134748195559614),(1000171,886,0.0136588703695291),(1000171,3300,0.0140463431166794),(1000171,3301,0.0140463431166794),(1000171,3302,0.0833333333333333),(1000171,3303,0.0833333333333333),(1000171,3304,0.0833333333333333),(1000171,3305,0.0833333333333333),(1000171,3306,0.0833333333333333),(1000171,3307,0.0833333333333333),(1000171,3308,0.0833333333333333),(1000171,3309,0.0833333333333333),(1000171,3310,0.0833333333333333),(1000171,3311,0.0140463431166794),(1000171,3312,0.0833333333333333),(1000171,3315,0.0833333333333333),(1000171,3316,0.0833333333333333),(1000171,3317,0.0833333333333333),(1000171,3318,0.0833333333333333),(1000171,3319,0.0833333333333333),(1000171,3320,0.0833333333333333),(1000171,3321,0.0833333333333333),(1000171,3322,0.0833333333333333),(1000171,3323,0.0833333333333333),(1000171,3324,0.0833333333333333),(1000171,3325,0.0833333333333333),(1000171,3326,0.0833333333333333),(1000171,3327,0.0833333333333333),(1000171,3328,0.0140463431166794),(1000171,3329,0.0833333333333333),(1000171,3330,0.0833333333333333),(1000171,3331,0.0833333333333333),(1000171,3332,0.0833333333333333),(1000171,3333,0.0833333333333333),(1000171,3334,0.0833333333333333),(1000171,3335,0.0833333333333333),(1000171,3336,0.0833333333333333),(1000171,3337,0.0833333333333333),(1000171,3338,0.0833333333333333),(1000171,3339,0.0833333333333333),(1000171,3340,0.0833333333333333),(1000171,3341,0.0833333333333333),(1000171,3342,0.0833333333333333),(1000171,3343,0.0833333333333333),(1000171,3344,0.0833333333333333),(1000171,3345,0.0833333333333333),(1000171,3346,0.0833333333333333),(1000171,3347,0.0833333333333333),(1000171,3348,0.0833333333333333),(1000171,3349,0.083333333333),(1000171,3350,0.083333333333),(1000171,3351,0.0833333333333333),(1000171,3352,0.0833333333333333),(1000171,3354,0.0833333333333333),(1000171,3355,0.0833333333333333),(1000171,3356,0.0086413667660438),(1000171,3357,0.0683013455365071),(1000171,3358,0.0086413667660438),(1000171,3359,0.0086413667660438),(1000171,3361,0.0833333333333333),(1000171,3363,0.0833333333333333),(1000171,3368,0.0833333333333333),(1000171,3373,0.0833333333333333),(1000171,3374,0.0176898701327485),(1000171,3375,0.0833333333333333),(1000171,3376,0.0833333333333333),(1000171,3377,0.0833333333333333),(1000171,3378,0.0833333333333333),(1000171,3379,0.0833333333333333),(1000171,3380,0.0833333333333333),(1000171,3385,0.0833333333333333),(1000171,3386,0.0769426043712937),(1000171,3387,0.0833333333333333),(1000171,3388,0.0833333333333333),(1000171,3389,0.0833333333333333),(1000171,3392,0.0833333333333333),(1000171,3393,0.0833333333333333),(1000171,3394,0.0833333333333333),(1000171,3395,0.083333),(1000171,3396,0.0834097158570119),(1000171,3397,0.0834097158570119),(1000171,3398,0.0834097158570119),(1000171,3400,0.0833333333333333),(1000171,3402,0.0833333333333333),(1000171,3403,0.0833333333333333),(1000171,3405,0.0833333333333333),(1000171,3406,0.0833333333333333),(1000171,3409,0.0833333333333333),(1000171,3410,0.0833333333333333),(1000171,3411,0.0833333333333333),(1000171,3412,0.0833333333333333),(1000171,3413,0.0140463431166794),(1000171,3416,0.0140463431166794),(1000171,3417,0.0833333333333333),(1000171,3418,0.0833333333333333),(1000171,3419,0.0833333333333333),(1000171,3420,0.0833333333333333),(1000171,3421,0.0833333333333333),(1000171,3422,0.0833333333333333),(1000171,3423,0.0833333333333333),(1000171,3424,0.0833333333333333),(1000171,3425,0.0833333333333333),(1000171,3426,0.0140463431166794),(1000171,3427,0.0833333333333333),(1000171,3428,0.0833333333333333),(1000171,3429,0.0833333333333333),(1000171,3430,0.0832513882168985),(1000171,3431,0.0833333333333333),(1000171,3432,0.0833333333333333),(1000171,3433,0.0833333333333333),(1000171,3434,0.0833333333333333),(1000171,3435,0.0833333333333333),(1000171,3436,0.0140463431166794),(1000171,3437,0.0833333333333333),(1000171,3438,0.0833333333333333),(1000171,3439,0.0833333333333333),(1000171,3441,0.0833333333333333),(1000171,3442,0.0833333333333333),(1000171,3443,0.0834097158570119),(1000171,3444,0.0834097158570119),(1000171,3446,0.0834097158570119),(1000171,3447,0.0834097158570119),(1000171,3449,0.0140463431166794),(1000171,3450,0.0833333333333333),(1000171,3451,0.0833333333333333),(1000171,3452,0.0833333333333333),(1000171,3453,0.0833333333333333),(1000171,3454,0.0833333333333333),(1000171,3455,0.0140463431166794),(1000171,3456,0.0833333333333333),(1000171,3551,0.0833333333333333),(1000171,3647,0.00478547388452215),(1000171,3687,0.0119307325520901),(1000171,3731,0.0833333333333333),(1000171,3732,0.0833333333333333),(1000171,9828,-0.00826676711724402),(1000171,9852,-0.00548545833179662),(1000171,10039,0.0833333333333333),(1000171,10040,0.0833333333333333),(1000171,11084,0.333333333333333),(1000171,11207,0.0833333333333333),(1000171,11395,0.0086413667660438),(1000171,11433,0.0833333333333333),(1000171,11441,0.0833333333333333),(1000171,11442,0.0833333333333333),(1000171,11443,0.0833333333333333),(1000171,11444,0.0833333333333333),(1000171,11445,0.0833333333333333),(1000171,11446,0.0833333333333333),(1000171,11447,0.0833333333333333),(1000171,11448,0.0833333333333333),(1000171,11449,0.0833333333333333),(1000171,11450,0.0833333333333333),(1000171,11451,0.0833333333333333),(1000171,11452,0.0833333333333333),(1000171,11453,0.0833333333333333),(1000171,11454,0.0833333333333333),(1000171,11455,0.0833333333333333),(1000171,11487,0.0833333333333333),(1000171,11529,0.0833333333333333),(1000171,11566,0.0833333333333333),(1000171,11569,0.0833333333333333),(1000171,11572,0.0833333333333333),(1000171,11574,0.0833333333333333),(1000171,11579,0.0834616563334484),(1000171,11584,0.0833333333333333),(1000171,12093,0.0947566183253475),(1000171,12097,0.0833333333333333),(1000171,12098,0.0833333333333333),(1000171,12099,0.0833333333333333),(1000171,12179,0.0833333333333333),(1000171,12196,0.114580704066846),(1000171,12201,0.333333333333333),(1000171,12202,0.333333333333333),(1000171,12203,0.333333333333333),(1000171,12208,0.333333333333333),(1000171,12209,0.333333333333333),(1000171,12241,0.0833333333333333),(1000171,12305,0.0833333333333333),(1000171,12365,0.0833333333333333),(1000171,12366,0.0833333333333333),(1000171,12367,0.0833333333333333),(1000171,12376,0.0834097158570119),(1000171,12383,0.0834097158570119),(1000171,12385,0.0834097158570119),(1000171,12386,0.0834097158570119),(1000171,12387,0.0834097158570119),(1000171,12441,0.166666666666667),(1000171,12442,0.166666666666667),(1000171,12485,0.333333333333333),(1000171,13278,0.0833333333333333),(1000171,16069,0.0833263894675444),(1000171,16281,0.0140463431166794),(1000171,16594,0.0834097158570119),(1000171,16595,0.0834097158570119),(1000171,16596,0.0834097158570119),(1000171,16597,0.0834097158570119),(1000171,16598,0.0834097158570119),(1000171,16622,0.0834097158570119),(1000171,17366,0.001990445859872),(1000171,17367,0.001990445859872),(1000171,17368,0.001990445859872),(1000171,17940,0.0833333333333333),(1000171,18580,0.0834097158570119),(1000171,19400,-0.0714352451600011),(1000171,19759,0.0833333333333333),(1000171,19760,0.0833333333333333),(1000171,19761,0.0833333333333333),(1000171,19766,0.0833333333333333),(1000171,19767,0.0833333333333333),(1000171,19921,0.0833333333333333),(1000171,19922,0.0833333333333333),(1000171,20209,0.166666666666667),(1000171,20210,0.166666666666667),(1000171,20211,0.166666666666667),(1000171,20212,0.166666666666667),(1000171,20213,0.166666666666667),(1000171,20312,0.166666666666667),(1000171,20314,0.166666666666667),(1000171,20315,0.166666666666667),(1000171,20342,0.0833333333333333),(1000171,20494,0.0833333333333333),(1000171,20495,0.0833333333333333),(1000171,20528,0.333333333333333),(1000171,20532,0.333333333333333),(1000171,20533,0.0833333333333333),(1000171,21059,0.0833333333333333),(1000171,21071,0.166666666666667),(1000171,21603,0.0833333333333333),(1000171,21610,0.0833333333333333),(1000171,21611,0.0833333333333333),(1000171,21667,0.333333333333333),(1000171,21668,0.166666666666667),(1000171,21718,0.0833333333333333),(1000171,21802,0.166666666666667),(1000171,21803,0.0833333333333333),(1000171,21853,0.0833333333333333),(1000171,21855,0.0833333333333333),(1000171,21857,0.0833333333333333),(1000171,22043,0.0833333333333333),(1000171,22176,0.0833333333333333),(1000171,22178,0.0833333333333333),(1000171,22242,0.0833333333333333),(1000171,22551,0.0833333333333333),(1000171,22578,0.0769426043712937),(1000171,22761,0.0833333333333333),(1000171,22806,0.0833333333333333),(1000171,22807,0.0833333333333333),(1000171,22808,0.0833333333333333),(1000171,22809,0.0833333333333333),(1000171,23069,0.0833333333333333),(1000171,23566,0.0833333333333333),(1000171,23594,0.0833333333333333),(1000171,23606,0.0833333333333333),(1000171,23618,0.0833333333333333),(1000171,23950,0.0833333333333333),(1000171,24241,0.0833333333333333),(1000171,24242,0.0834097158570119),(1000171,24268,0.0834097158570119),(1000171,24270,0.0834097158570119),(1000171,24311,0.0833333333333333),(1000171,24312,0.0833333333333333),(1000171,24313,0.0833333333333333),(1000171,24314,0.0833333333333333),(1000171,24445,0.001990445859872),(1000171,24562,0.0833333333333333),(1000171,24563,0.0833333333333333),(1000171,24568,0.0833263894675444),(1000171,24571,0.0833333333333333),(1000171,24572,0.0833333333333333),(1000171,24606,0.0833333333333333),(1000171,24613,0.0833333333333333),(1000171,24624,0.0833333333333333),(1000171,24625,0.0833333333333333),(1000171,24764,0.0833333333333333),(1000171,25233,0.0834097158570119),(1000171,25235,0.0834097158570119),(1000171,25718,0.166666666666667),(1000171,25719,0.166666666666667),(1000171,25739,0.0833333333333333),(1000171,25810,0.0833333333333333),(1000171,25811,0.0833333333333333),(1000171,25862,0.0833333333333333),(1000171,25863,0.0833333333333333),(1000171,26252,0.0833333333333333),(1000171,26253,0.0833333333333333),(1000171,26254,0.0833333333333333),(1000171,26255,0.0833333333333333),(1000171,26256,0.0833333333333333),(1000171,26257,0.0833333333333333),(1000171,26258,0.0833333333333333),(1000171,26259,0.0833333333333333),(1000171,26260,0.0833333333333333),(1000171,26261,0.0833333333333333),(1000171,27309,0.001990445859872),(1000171,27902,0.0833263894675444),(1000171,27906,0.0833333333333333),(1000171,27911,0.0833333333333333),(1000171,27936,0.0833263894675444),(1000171,28073,0.166666666666667),(1000171,28164,0.0833333333333333),(1000171,28374,0.0833333333333333),(1000171,28585,0.0833333333333333),(1000171,28609,0.0947566183253475),(1000171,28615,0.0947566183253475),(1000171,28656,0.0947566183253475),(1000171,28667,0.0947566183253475),(1000171,28879,0.0833333333333333),(1000171,28880,0.0833333333333333),(1000172,43,-0.00935903587601748),(1000172,811,0.0063576699300406),(1000172,813,0.00350494106972787),(1000172,814,0.00375552955387329),(1000172,879,0.00534474439183068),(1000172,881,0.0134566869131638),(1000172,883,0.0136588703695291),(1000172,884,0.0134748195559614),(1000172,885,0.0138288684185062),(1000172,3300,0.0140463431166794),(1000172,3301,0.0140463431166794),(1000172,3302,0.0833333333333333),(1000172,3303,0.0833333333333333),(1000172,3304,0.0833333333333333),(1000172,3305,0.0833333333333333),(1000172,3306,0.0833333333333333),(1000172,3307,0.0833333333333333),(1000172,3308,0.0833333333333333),(1000172,3309,0.0833333333333333),(1000172,3310,0.0833333333333333),(1000172,3311,0.0140463431166794),(1000172,3312,0.0833333333333333),(1000172,3315,0.0833333333333333),(1000172,3316,0.0833333333333333),(1000172,3317,0.0833333333333333),(1000172,3318,0.0833333333333333),(1000172,3319,0.0833333333333333),(1000172,3320,0.0833333333333333),(1000172,3321,0.0833333333333333),(1000172,3322,0.0833333333333333),(1000172,3323,0.0833333333333333),(1000172,3324,0.0833333333333333),(1000172,3325,0.0833333333333333),(1000172,3326,0.0833333333333333),(1000172,3327,0.0833333333333333),(1000172,3328,0.0140463431166794),(1000172,3329,0.0833333333333333),(1000172,3330,0.0833333333333333),(1000172,3331,0.0833333333333333),(1000172,3332,0.0833333333333333),(1000172,3333,0.0833333333333333),(1000172,3334,0.0833333333333333),(1000172,3335,0.0833333333333333),(1000172,3336,0.0833333333333333),(1000172,3337,0.0833333333333333),(1000172,3338,0.0833333333333333),(1000172,3339,0.0833333333333333),(1000172,3340,0.0833333333333333),(1000172,3341,0.0833333333333333),(1000172,3342,0.0833333333333333),(1000172,3343,0.0833333333333333),(1000172,3344,0.0833333333333333),(1000172,3345,0.0833333333333333),(1000172,3346,0.0833333333333333),(1000172,3347,0.0833333333333333),(1000172,3348,0.0833333333333333),(1000172,3349,0.083333333333),(1000172,3350,0.083333333333),(1000172,3351,0.0833333333333333),(1000172,3352,0.0833333333333333),(1000172,3354,0.0833333333333333),(1000172,3355,0.0833333333333333),(1000172,3356,0.0086413667660438),(1000172,3357,0.0878248755620269),(1000172,3358,0.0086413667660438),(1000172,3359,0.0086413667660438),(1000172,3361,0.0833333333333333),(1000172,3363,0.0833333333333333),(1000172,3368,0.0833333333333333),(1000172,3373,0.0833333333333333),(1000172,3374,0.0176898701327485),(1000172,3375,0.0833333333333333),(1000172,3376,0.0833333333333333),(1000172,3377,0.0833333333333333),(1000172,3378,0.0833333333333333),(1000172,3379,0.0833333333333333),(1000172,3380,0.0833333333333333),(1000172,3385,0.0833333333333333),(1000172,3386,0.0769426043712937),(1000172,3387,0.0833333333333333),(1000172,3388,0.0833333333333333),(1000172,3389,0.0833333333333333),(1000172,3392,0.0833333333333333),(1000172,3393,0.0833333333333333),(1000172,3394,0.0833333333333333),(1000172,3395,0.083333),(1000172,3396,0.0833263894675444),(1000172,3397,0.0833263894675444),(1000172,3398,0.0833263894675444),(1000172,3400,0.0833333333333333),(1000172,3402,0.0833333333333333),(1000172,3403,0.0833333333333333),(1000172,3405,0.0833333333333333),(1000172,3406,0.0833333333333333),(1000172,3409,0.0833333333333333),(1000172,3410,0.0833333333333333),(1000172,3411,0.0833333333333333),(1000172,3412,0.0833333333333333),(1000172,3413,0.0140463431166794),(1000172,3416,0.0140463431166794),(1000172,3417,0.0833333333333333),(1000172,3418,0.0833333333333333),(1000172,3419,0.0833333333333333),(1000172,3420,0.0833333333333333),(1000172,3421,0.0833333333333333),(1000172,3422,0.0833333333333333),(1000172,3423,0.0833333333333333),(1000172,3424,0.0833333333333333),(1000172,3425,0.0833333333333333),(1000172,3426,0.0140463431166794),(1000172,3427,0.0833333333333333),(1000172,3428,0.0833333333333333),(1000172,3429,0.0833333333333333),(1000172,3430,0.0834097158570119),(1000172,3431,0.0833333333333333),(1000172,3432,0.0833333333333333),(1000172,3433,0.0833333333333333),(1000172,3434,0.0833333333333333),(1000172,3435,0.0833333333333333),(1000172,3436,0.0140463431166794),(1000172,3437,0.0833333333333333),(1000172,3438,0.0833333333333333),(1000172,3439,0.0833333333333333),(1000172,3441,0.0833333333333333),(1000172,3442,0.0833333333333333),(1000172,3443,0.0832513882168985),(1000172,3444,0.0832513882168985),(1000172,3446,0.0832513882168985),(1000172,3447,0.0832513882168985),(1000172,3449,0.0140463431166794),(1000172,3450,0.0833333333333333),(1000172,3451,0.0833333333333333),(1000172,3452,0.0833333333333333),(1000172,3453,0.0833333333333333),(1000172,3454,0.0833333333333333),(1000172,3455,0.0140463431166794),(1000172,3456,0.0833333333333333),(1000172,3551,0.0833333333333333),(1000172,3689,0.00471938621958334),(1000172,3715,-0.00471762096642204),(1000172,3731,0.0833333333333333),(1000172,3732,0.0833333333333333),(1000172,9852,0.00789829896901656),(1000172,10039,0.0833333333333333),(1000172,10040,0.0833333333333333),(1000172,11084,0.333333333333333),(1000172,11132,0.0103998399734633),(1000172,11133,0.0103998399734633),(1000172,11207,0.0833333333333333),(1000172,11395,0.0086413667660438),(1000172,11433,0.0833333333333333),(1000172,11441,0.0833333333333333),(1000172,11442,0.0833333333333333),(1000172,11443,0.0833333333333333),(1000172,11444,0.0833333333333333),(1000172,11445,0.0833333333333333),(1000172,11446,0.0833333333333333),(1000172,11447,0.0833333333333333),(1000172,11448,0.0833333333333333),(1000172,11449,0.0833333333333333),(1000172,11450,0.0833333333333333),(1000172,11451,0.0833333333333333),(1000172,11452,0.0833333333333333),(1000172,11453,0.0833333333333333),(1000172,11454,0.0833333333333333),(1000172,11455,0.0833333333333333),(1000172,11487,0.0833333333333333),(1000172,11529,0.0833333333333333),(1000172,11566,0.0833333333333333),(1000172,11569,0.0833333333333333),(1000172,11572,0.0833333333333333),(1000172,11574,0.0833333333333333),(1000172,11579,0.0818171319806376),(1000172,11584,0.0833333333333333),(1000172,12093,0.0794295462783267),(1000172,12097,0.0833333333333333),(1000172,12098,0.0833333333333333),(1000172,12099,0.0833333333333333),(1000172,12179,0.0833333333333333),(1000172,12180,0.00903159331774576),(1000172,12181,0.00903159331774576),(1000172,12182,0.00903159331774576),(1000172,12183,0.00903159331774576),(1000172,12184,0.00903159331774576),(1000172,12185,0.00903159331774576),(1000172,12186,0.00903159331774576),(1000172,12187,0.00903159331774576),(1000172,12188,0.00903159331774576),(1000172,12189,0.00903159331774576),(1000172,12190,0.00903159331774576),(1000172,12191,0.00903159331774576),(1000172,12192,0.00903159331774576),(1000172,12193,0.00903159331774576),(1000172,12194,0.00903159331774576),(1000172,12195,0.00903159331774576),(1000172,12196,0.104164276424406),(1000172,12201,0.333333333333333),(1000172,12202,0.333333333333333),(1000172,12203,0.333333333333333),(1000172,12208,0.333333333333333),(1000172,12209,0.333333333333333),(1000172,12241,0.0833333333333333),(1000172,12305,0.0833333333333333),(1000172,12365,0.0833333333333333),(1000172,12366,0.0833333333333333),(1000172,12367,0.0833333333333333),(1000172,12376,0.0832513882168985),(1000172,12383,0.0832513882168985),(1000172,12385,0.0832513882168985),(1000172,12386,0.0832513882168985),(1000172,12387,0.0832513882168985),(1000172,12441,0.166666666666667),(1000172,12442,0.166666666666667),(1000172,12485,0.333333333333333),(1000172,13278,0.0833333333333333),(1000172,16069,0.0832513882168985),(1000172,16281,0.0140463431166794),(1000172,16594,0.0832513882168985),(1000172,16595,0.0832513882168985),(1000172,16596,0.0832513882168985),(1000172,16597,0.0832513882168985),(1000172,16598,0.0832513882168985),(1000172,16622,0.0832513882168985),(1000172,17366,0.001990445859872),(1000172,17367,0.001990445859872),(1000172,17368,0.001990445859872),(1000172,17940,0.0833333333333333),(1000172,18025,0.0060210622118305),(1000172,18580,0.0832513882168985),(1000172,19400,-0.0714578371380422),(1000172,19759,0.0833333333333333),(1000172,19760,0.0833333333333333),(1000172,19761,0.0833333333333333),(1000172,19766,0.0833333333333333),(1000172,19767,0.0833333333333333),(1000172,19921,0.0833333333333333),(1000172,19922,0.0833333333333333),(1000172,20209,0.166666666666667),(1000172,20210,0.166666666666667),(1000172,20211,0.166666666666667),(1000172,20212,0.166666666666667),(1000172,20213,0.166666666666667),(1000172,20312,0.166666666666667),(1000172,20314,0.166666666666667),(1000172,20315,0.166666666666667),(1000172,20342,0.0833333333333333),(1000172,20494,0.0833333333333333),(1000172,20495,0.0833333333333333),(1000172,20528,0.333333333333333),(1000172,20532,0.333333333333333),(1000172,20533,0.0833333333333333),(1000172,21059,0.0833333333333333),(1000172,21071,0.166666666666667),(1000172,21603,0.0833333333333333),(1000172,21610,0.0833333333333333),(1000172,21611,0.0833333333333333),(1000172,21667,0.333333333333333),(1000172,21668,0.166666666666667),(1000172,21718,0.0833333333333333),(1000172,21802,0.166666666666667),(1000172,21803,0.0833333333333333),(1000172,21853,0.0833333333333333),(1000172,21855,0.0833333333333333),(1000172,21857,0.0833333333333333),(1000172,22043,0.0833333333333333),(1000172,22176,0.0833333333333333),(1000172,22178,0.0833333333333333),(1000172,22242,0.0833333333333333),(1000172,22551,0.0833333333333333),(1000172,22578,0.0769426043712937),(1000172,22761,0.0833333333333333),(1000172,22806,0.0833333333333333),(1000172,22807,0.0833333333333333),(1000172,22808,0.0833333333333333),(1000172,22809,0.0833333333333333),(1000172,23069,0.0833333333333333),(1000172,23566,0.0833333333333333),(1000172,23594,0.0833333333333333),(1000172,23606,0.0833333333333333),(1000172,23618,0.0833333333333333),(1000172,23950,0.0833333333333333),(1000172,24241,0.0833333333333333),(1000172,24242,0.0832513882168985),(1000172,24268,0.0832513882168985),(1000172,24270,0.0832513882168985),(1000172,24311,0.0833333333333333),(1000172,24312,0.0833333333333333),(1000172,24313,0.0833333333333333),(1000172,24314,0.0833333333333333),(1000172,24445,0.001990445859872),(1000172,24562,0.0833333333333333),(1000172,24563,0.0833333333333333),(1000172,24568,0.0832513882168985),(1000172,24571,0.0833333333333333),(1000172,24572,0.0833333333333333),(1000172,24606,0.0833333333333333),(1000172,24613,0.0833333333333333),(1000172,24624,0.0833333333333333),(1000172,24625,0.0833333333333333),(1000172,24764,0.0833333333333333),(1000172,25233,0.0832513882168985),(1000172,25235,0.0832513882168985),(1000172,25718,0.166666666666667),(1000172,25719,0.166666666666667),(1000172,25739,0.0833333333333333),(1000172,25810,0.0833333333333333),(1000172,25811,0.0833333333333333),(1000172,25862,0.0833333333333333),(1000172,25863,0.0833333333333333),(1000172,26252,0.0833333333333333),(1000172,26253,0.0833333333333333),(1000172,26254,0.0833333333333333),(1000172,26255,0.0833333333333333),(1000172,26256,0.0833333333333333),(1000172,26257,0.0833333333333333),(1000172,26258,0.0833333333333333),(1000172,26259,0.0833333333333333),(1000172,26260,0.0833333333333333),(1000172,26261,0.0833333333333333),(1000172,27309,0.001990445859872),(1000172,27902,0.0832513882168985),(1000172,27906,0.0833333333333333),(1000172,27911,0.0833333333333333),(1000172,27936,0.0832513882168985),(1000172,28073,0.166666666666667),(1000172,28164,0.0833333333333333),(1000172,28374,0.0833333333333333),(1000172,28585,0.0833333333333333),(1000172,28609,0.0794295462783267),(1000172,28615,0.0794295462783267),(1000172,28656,0.0794295462783267),(1000172,28667,0.0794295462783267),(1000172,28879,0.0833333333333333),(1000172,28880,0.0833333333333333),(1000177,17366,0.000199044585987),(1000177,17367,0.000199044585987),(1000177,17368,0.000199044585987),(1000177,24445,0.000199044585987),(1000177,27309,0.000199044585987),(1000178,17366,0.000199044585987),(1000178,17367,0.000199044585987),(1000178,17368,0.000199044585987),(1000178,24445,0.000199044585987),(1000178,27309,0.000199044585987);

/*Table structure for table `crpNPCTickerNames` */

DROP TABLE IF EXISTS `crpNPCTickerNames`;

CREATE TABLE `crpNPCTickerNames` (
  `corporationID` int(10) unsigned NOT NULL default '0',
  `tickerName` varchar(64) NOT NULL default '',
  `shape1` int(10) unsigned default NULL,
  `shape2` int(10) unsigned default NULL,
  `shape3` int(10) unsigned default NULL,
  `color1` text,
  `color2` text,
  `color3` text,
  PRIMARY KEY  (`corporationID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `crpNPCTickerNames` */

insert  into `crpNPCTickerNames`(`corporationID`,`tickerName`,`shape1`,`shape2`,`shape3`,`color1`,`color2`,`color3`) values (1000001,'666',NULL,NULL,NULL,NULL,NULL,NULL),(1000002,'CBDC',NULL,NULL,NULL,NULL,NULL,NULL),(1000003,'PD',NULL,NULL,NULL,NULL,NULL,NULL),(1000004,'Y',NULL,NULL,NULL,NULL,NULL,NULL),(1000005,'HC',NULL,NULL,NULL,NULL,NULL,NULL),(1000006,'DCMI',NULL,NULL,NULL,NULL,NULL,NULL),(1000007,'PMG',NULL,NULL,NULL,NULL,NULL,NULL),(1000008,'M',NULL,NULL,NULL,NULL,NULL,NULL),(1000009,'CP',NULL,NULL,NULL,NULL,NULL,NULL),(1000010,'KC',NULL,NULL,NULL,NULL,NULL,NULL),(1000011,'WC',NULL,NULL,NULL,NULL,NULL,NULL),(1000012,'TD',NULL,NULL,NULL,NULL,NULL,NULL),(1000013,'RA',NULL,NULL,NULL,NULL,NULL,NULL),(1000014,'P',NULL,NULL,NULL,NULL,NULL,NULL),(1000015,'CS',NULL,NULL,NULL,NULL,NULL,NULL),(1000016,'ZA',NULL,NULL,NULL,NULL,NULL,NULL),(1000017,'NC',NULL,NULL,NULL,NULL,NULL,NULL),(1000018,'EE',NULL,NULL,NULL,NULL,NULL,NULL),(1000019,'ISH',NULL,NULL,NULL,NULL,NULL,NULL),(1000020,'LDC',NULL,NULL,NULL,NULL,NULL,NULL),(1000021,'ZGRF',NULL,NULL,NULL,NULL,NULL,NULL),(1000022,'PRO',NULL,NULL,NULL,NULL,NULL,NULL),(1000023,'ED',NULL,NULL,NULL,NULL,NULL,NULL),(1000024,'CBDSD',NULL,NULL,NULL,NULL,NULL,NULL),(1000025,'SC',NULL,NULL,NULL,NULL,NULL,NULL),(1000026,'CC',NULL,NULL,NULL,NULL,NULL,NULL),(1000027,'EH',NULL,NULL,NULL,NULL,NULL,NULL),(1000028,'CFU',NULL,NULL,NULL,NULL,NULL,NULL),(1000029,'SRB',NULL,NULL,NULL,NULL,NULL,NULL),(1000030,'MF',NULL,NULL,NULL,NULL,NULL,NULL),(1000031,'CEP',NULL,NULL,NULL,NULL,NULL,NULL),(1000032,'MC',NULL,NULL,NULL,NULL,NULL,NULL),(1000033,'CBT',NULL,NULL,NULL,NULL,NULL,NULL),(1000034,'HR',NULL,NULL,NULL,NULL,NULL,NULL),(1000035,'CN',NULL,NULL,NULL,NULL,NULL,NULL),(1000036,'IN',NULL,NULL,NULL,NULL,NULL,NULL),(1000037,'LDPS',NULL,NULL,NULL,NULL,NULL,NULL),(1000038,'IW',NULL,NULL,NULL,NULL,NULL,NULL),(1000039,'HG',NULL,NULL,NULL,NULL,NULL,NULL),(1000040,'POU',NULL,NULL,NULL,NULL,NULL,NULL),(1000041,'SP',NULL,NULL,NULL,NULL,NULL,NULL),(1000042,'WPC',NULL,NULL,NULL,NULL,NULL,NULL),(1000043,'CPF',NULL,NULL,NULL,NULL,NULL,NULL),(1000044,'SAK',NULL,NULL,NULL,NULL,NULL,NULL),(1000045,'STI',NULL,NULL,NULL,NULL,NULL,NULL),(1000046,'S',NULL,NULL,NULL,NULL,NULL,NULL),(1000047,'K',NULL,NULL,NULL,NULL,NULL,NULL),(1000048,'V',NULL,NULL,NULL,NULL,NULL,NULL),(1000049,'B',NULL,NULL,NULL,NULL,NULL,NULL),(1000050,'RP',NULL,NULL,NULL,NULL,NULL,NULL),(1000051,'RF',NULL,NULL,NULL,NULL,NULL,NULL),(1000052,'RJD',NULL,NULL,NULL,NULL,NULL,NULL),(1000053,'UM',NULL,NULL,NULL,NULL,NULL,NULL),(1000054,'RSS',NULL,NULL,NULL,NULL,NULL,NULL),(1000055,'MMC',NULL,NULL,NULL,NULL,NULL,NULL),(1000056,'CCI',NULL,NULL,NULL,NULL,NULL,NULL),(1000057,'BC',NULL,NULL,NULL,NULL,NULL,NULL),(1000058,'EC',NULL,NULL,NULL,NULL,NULL,NULL),(1000059,'SKD',NULL,NULL,NULL,NULL,NULL,NULL),(1000060,'NF',NULL,NULL,NULL,NULL,NULL,NULL),(1000061,'FE',NULL,NULL,NULL,NULL,NULL,NULL),(1000062,'TLG',NULL,NULL,NULL,NULL,NULL,NULL),(1000063,'AC',NULL,NULL,NULL,NULL,NULL,NULL),(1000064,'C',NULL,NULL,NULL,NULL,NULL,NULL),(1000065,'IA',NULL,NULL,NULL,NULL,NULL,NULL),(1000066,'VI',NULL,NULL,NULL,NULL,NULL,NULL),(1000067,'ZS',NULL,NULL,NULL,NULL,NULL,NULL),(1000068,'NA',NULL,NULL,NULL,NULL,NULL,NULL),(1000069,'DF',NULL,NULL,NULL,NULL,NULL,NULL),(1000070,'HZOR',NULL,NULL,NULL,NULL,NULL,NULL),(1000071,'II',NULL,NULL,NULL,NULL,NULL,NULL),(1000072,'IS',NULL,NULL,NULL,NULL,NULL,NULL),(1000073,'ACN',NULL,NULL,NULL,NULL,NULL,NULL),(1000074,'JH',NULL,NULL,NULL,NULL,NULL,NULL),(1000075,'N',NULL,NULL,NULL,NULL,NULL,NULL),(1000076,'FU',NULL,NULL,NULL,NULL,NULL,NULL),(1000077,'RIN',NULL,NULL,NULL,NULL,NULL,NULL),(1000078,'IC',NULL,NULL,NULL,NULL,NULL,NULL),(1000079,'ACS',NULL,NULL,NULL,NULL,NULL,NULL),(1000080,'MW',NULL,NULL,NULL,NULL,NULL,NULL),(1000081,'MI',NULL,NULL,NULL,NULL,NULL,NULL),(1000082,'MIO',NULL,NULL,NULL,NULL,NULL,NULL),(1000083,'ATR',NULL,NULL,NULL,NULL,NULL,NULL),(1000084,'AN',NULL,NULL,NULL,NULL,NULL,NULL),(1000085,'CO',NULL,NULL,NULL,NULL,NULL,NULL),(1000086,'EF',NULL,NULL,NULL,NULL,NULL,NULL),(1000087,'KF',NULL,NULL,NULL,NULL,NULL,NULL),(1000088,'SF',NULL,NULL,NULL,NULL,NULL,NULL),(1000089,'KAF',NULL,NULL,NULL,NULL,NULL,NULL),(1000090,'AF',NULL,NULL,NULL,NULL,NULL,NULL),(1000091,'TMF',NULL,NULL,NULL,NULL,NULL,NULL),(1000092,'CI',NULL,NULL,NULL,NULL,NULL,NULL),(1000093,'T',NULL,NULL,NULL,NULL,NULL,NULL),(1000094,'TSS',NULL,NULL,NULL,NULL,NULL,NULL),(1000095,'FF',NULL,NULL,NULL,NULL,NULL,NULL),(1000096,'IZS',NULL,NULL,NULL,NULL,NULL,NULL),(1000097,'MA',NULL,NULL,NULL,NULL,NULL,NULL),(1000098,'AMI',NULL,NULL,NULL,NULL,NULL,NULL),(1000099,'CH',NULL,NULL,NULL,NULL,NULL,NULL),(1000100,'QC',NULL,NULL,NULL,NULL,NULL,NULL),(1000101,'CD',NULL,NULL,NULL,NULL,NULL,NULL),(1000102,'RS',NULL,NULL,NULL,NULL,NULL,NULL),(1000103,'AI',NULL,NULL,NULL,NULL,NULL,NULL),(1000104,'PP',NULL,NULL,NULL,NULL,NULL,NULL),(1000105,'I',NULL,NULL,NULL,NULL,NULL,NULL),(1000106,'EI',NULL,NULL,NULL,NULL,NULL,NULL),(1000107,'TS',NULL,NULL,NULL,NULL,NULL,NULL),(1000108,'CT',NULL,NULL,NULL,NULL,NULL,NULL),(1000109,'DL',NULL,NULL,NULL,NULL,NULL,NULL),(1000110,'FM',NULL,NULL,NULL,NULL,NULL,NULL),(1000111,'A',NULL,NULL,NULL,NULL,NULL,NULL),(1000112,'BL',NULL,NULL,NULL,NULL,NULL,NULL),(1000113,'PI',NULL,NULL,NULL,NULL,NULL,NULL),(1000114,'GIB',NULL,NULL,NULL,NULL,NULL,NULL),(1000115,'UC',NULL,NULL,NULL,NULL,NULL,NULL),(1000116,'PR',NULL,NULL,NULL,NULL,NULL,NULL),(1000117,'SE',NULL,NULL,NULL,NULL,NULL,NULL),(1000118,'SU',NULL,NULL,NULL,NULL,NULL,NULL),(1000119,'FA',NULL,NULL,NULL,NULL,NULL,NULL),(1000120,'FN',NULL,NULL,NULL,NULL,NULL,NULL),(1000121,'FIO',NULL,NULL,NULL,NULL,NULL,NULL),(1000122,'FC',NULL,NULL,NULL,NULL,NULL,NULL),(1000123,'ATF',NULL,NULL,NULL,NULL,NULL,NULL),(1000124,'ARCA',NULL,NULL,NULL,NULL,NULL,NULL),(1000125,'CONCO',NULL,NULL,NULL,NULL,NULL,NULL),(1000126,'ATC',NULL,NULL,NULL,NULL,NULL,NULL),(1000127,'G',NULL,NULL,NULL,NULL,NULL,NULL),(1000128,'MLG',NULL,NULL,NULL,NULL,NULL,NULL),(1000129,'ORE',NULL,NULL,NULL,NULL,NULL,NULL),(1000130,'SEVE',NULL,NULL,NULL,NULL,NULL,NULL),(1000131,'SCT',NULL,NULL,NULL,NULL,NULL,NULL),(1000132,'SCC',NULL,NULL,NULL,NULL,NULL,NULL),(1000133,'SAG',NULL,NULL,NULL,NULL,NULL,NULL),(1000134,'TBR',NULL,NULL,NULL,NULL,NULL,NULL),(1000135,'SPC',NULL,NULL,NULL,NULL,NULL,NULL),(1000136,'GA',NULL,NULL,NULL,NULL,NULL,NULL),(1000137,'DED',NULL,NULL,NULL,NULL,NULL,NULL),(1000138,'DOM',NULL,NULL,NULL,NULL,NULL,NULL),(1000139,'FRL',NULL,NULL,NULL,NULL,NULL,NULL),(1000140,'GNL',NULL,NULL,NULL,NULL,NULL,NULL),(1000141,'GUP',NULL,NULL,NULL,NULL,NULL,NULL),(1000142,'IPR',NULL,NULL,NULL,NULL,NULL,NULL),(1000143,'ICR',NULL,NULL,NULL,NULL,NULL,NULL),(1000144,'IBK',NULL,NULL,NULL,NULL,NULL,NULL),(1000145,'ICM',NULL,NULL,NULL,NULL,NULL,NULL),(1000146,'ISP',NULL,NULL,NULL,NULL,NULL,NULL),(1000147,'ISD',NULL,NULL,NULL,NULL,NULL,NULL),(1000148,'INB',NULL,NULL,NULL,NULL,NULL,NULL),(1000149,'JVN',NULL,NULL,NULL,NULL,NULL,NULL),(1000150,'JDR',NULL,NULL,NULL,NULL,NULL,NULL),(1000151,'KIV',NULL,NULL,NULL,NULL,NULL,NULL),(1000152,'KTP',NULL,NULL,NULL,NULL,NULL,NULL),(1000153,'KWK',NULL,NULL,NULL,NULL,NULL,NULL),(1000154,'NMA',NULL,NULL,NULL,NULL,NULL,NULL),(1000155,'PRP',NULL,NULL,NULL,NULL,NULL,NULL),(1000156,'RKN',NULL,NULL,NULL,NULL,NULL,NULL),(1000157,'SPI',NULL,NULL,NULL,NULL,NULL,NULL),(1000158,'SPS',NULL,NULL,NULL,NULL,NULL,NULL),(1000159,'SAN',NULL,NULL,NULL,NULL,NULL,NULL),(1000160,'TMX',NULL,NULL,NULL,NULL,NULL,NULL),(1000161,'TCR',NULL,NULL,NULL,NULL,NULL,NULL),(1000162,'TPW',NULL,NULL,NULL,NULL,NULL,NULL),(1000163,'TPT',NULL,NULL,NULL,NULL,NULL,NULL),(1000164,'XSN',NULL,NULL,NULL,NULL,NULL,NULL),(1000165,'HU',NULL,NULL,NULL,NULL,NULL,NULL),(1000166,'IAC',NULL,NULL,NULL,NULL,NULL,NULL),(1000167,'SWA',NULL,NULL,NULL,NULL,NULL,NULL),(1000168,'FNA',NULL,NULL,NULL,NULL,NULL,NULL),(1000169,'CAS',NULL,NULL,NULL,NULL,NULL,NULL),(1000170,'RMS',NULL,NULL,NULL,NULL,NULL,NULL),(1000171,'RUN',NULL,NULL,NULL,NULL,NULL,NULL),(1000172,'PTS',NULL,NULL,NULL,NULL,NULL,NULL),(1000173,'POLAR',NULL,NULL,NULL,NULL,NULL,NULL),(1000174,'POLBU',NULL,NULL,NULL,NULL,NULL,NULL),(1000175,'POLEV',511,507,450,NULL,NULL,NULL),(1000176,'PANNS',NULL,NULL,NULL,NULL,NULL,NULL),(1000177,'MAI',NULL,NULL,NULL,NULL,NULL,NULL),(1000178,'AAB',NULL,NULL,NULL,NULL,NULL,NULL);

/*Table structure for table `crtRecommendations` */

DROP TABLE IF EXISTS `crtRecommendations`;

CREATE TABLE `crtRecommendations` (
  `shipTypeID` int(10) unsigned NOT NULL,
  `certificateID` int(10) unsigned NOT NULL,
  `recommendationLevel` int(10) unsigned NOT NULL,
  `recommendationID` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`shipTypeID`,`certificateID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `crtRecommendations` */

insert  into `crtRecommendations`(`shipTypeID`,`certificateID`,`recommendationLevel`,`recommendationID`) values (582,15,0,9),(582,53,0,11),(582,239,0,10),(583,15,0,12),(583,139,0,13),(583,195,0,15),(583,200,0,14),(584,15,0,16),(584,53,0,18),(584,139,0,17),(584,186,0,19),(585,15,0,20),(585,114,0,21),(585,195,0,23),(585,200,0,22),(586,15,0,24),(586,46,0,557),(586,114,0,25),(586,204,0,27),(587,15,0,28),(587,46,0,30),(587,114,0,29),(589,15,0,31),(589,72,0,32),(589,195,0,34),(589,200,0,33),(590,15,0,35),(590,46,0,37),(590,139,0,36),(591,15,0,38),(591,46,0,40),(591,239,0,39),(592,15,0,41),(592,46,0,43),(592,239,0,42),(593,15,0,44),(593,46,0,46),(593,93,0,45),(594,15,0,47),(594,46,0,49),(594,93,0,48),(597,15,0,50),(597,46,0,52),(597,72,0,51),(598,15,0,53),(598,46,0,55),(598,139,0,54),(599,15,0,56),(599,46,0,58),(599,239,0,57),(602,15,0,59),(602,53,0,61),(602,139,0,60),(603,15,0,62),(603,53,0,64),(603,93,0,63),(605,15,0,65),(605,53,0,67),(605,139,0,66),(605,204,0,68),(607,15,0,69),(607,46,0,71),(607,93,0,70),(607,204,0,72),(608,15,0,73),(608,93,0,74),(608,195,0,76),(608,200,0,75),(609,15,0,77),(609,46,0,79),(609,93,0,78),(609,189,0,80),(620,15,0,81),(620,53,0,83),(620,65,0,84),(620,239,0,82),(621,15,0,85),(621,53,0,87),(621,146,0,86),(622,15,0,88),(622,46,0,90),(622,121,0,89),(622,201,0,91),(623,15,0,92),(623,53,0,94),(623,100,0,93),(624,15,0,95),(624,46,0,97),(624,79,0,96),(625,15,0,98),(625,46,0,100),(625,65,0,101),(625,79,0,99),(626,15,0,102),(626,46,0,104),(626,166,0,103),(627,15,0,105),(627,46,0,107),(627,100,0,106),(627,201,0,108),(628,15,0,109),(628,46,0,111),(628,166,0,110),(628,192,0,112),(629,15,0,113),(629,46,0,115),(629,121,0,114),(630,15,0,116),(630,46,0,118),(630,121,0,117),(630,183,0,119),(631,15,0,120),(631,46,0,122),(631,65,0,123),(631,239,0,121),(632,15,0,124),(632,53,0,126),(632,146,0,125),(632,186,0,127),(633,15,0,128),(633,46,0,130),(633,100,0,129),(633,189,0,131),(634,15,0,132),(634,46,0,134),(634,65,0,623),(634,100,0,133),(638,16,0,555),(638,54,0,137),(638,153,0,136),(639,16,0,138),(639,54,0,140),(639,128,0,139),(640,16,0,141),(640,54,0,143),(640,107,0,142),(640,187,0,144),(641,16,0,145),(641,47,0,147),(641,107,0,146),(642,16,0,148),(642,47,0,150),(642,86,0,4),(643,16,0,151),(643,47,0,153),(643,86,0,152),(644,16,0,154),(644,47,0,156),(644,128,0,155),(644,153,0,625),(645,16,0,157),(645,47,0,159),(645,170,0,158),(648,15,0,160),(648,53,0,161),(649,15,0,162),(649,53,0,163),(650,15,0,164),(650,53,0,165),(651,15,0,166),(651,53,0,167),(652,15,0,168),(652,53,0,169),(653,15,0,170),(653,53,0,171),(654,15,0,172),(654,53,0,173),(655,15,0,174),(655,53,0,175),(656,15,0,176),(656,53,0,177),(657,15,0,178),(657,53,0,179),(1944,15,0,180),(1944,46,0,181),(2006,15,0,182),(2006,46,0,184),(2006,79,0,183),(2161,15,0,185),(2161,46,0,187),(2161,72,0,186),(2161,192,0,188),(3766,15,0,189),(3766,46,0,191),(3766,114,0,190),(3766,183,0,192),(11172,16,0,193),(11172,167,0,194),(11172,181,0,195),(11172,205,0,196),(11174,16,0,197),(11174,47,0,199),(11174,98,0,198),(11174,190,0,200),(11176,16,0,201),(11176,142,0,202),(11176,196,0,204),(11176,202,0,203),(11178,16,0,205),(11178,98,0,206),(11178,196,0,208),(11178,202,0,207),(11182,16,0,209),(11182,115,0,210),(11182,181,0,211),(11182,205,0,212),(11184,16,0,213),(11184,75,0,214),(11184,196,0,216),(11184,202,0,215),(11186,16,0,217),(11186,144,0,218),(11186,196,0,220),(11186,202,0,219),(11188,16,0,221),(11188,73,0,222),(11188,181,0,223),(11188,205,0,224),(11190,16,0,225),(11190,47,0,227),(11190,167,0,226),(11190,193,0,228),(11192,16,0,229),(11192,140,0,230),(11192,181,0,231),(11192,205,0,232),(11194,16,0,233),(11194,54,0,235),(11194,142,0,234),(11194,187,0,236),(11196,16,0,237),(11196,117,0,238),(11196,196,0,240),(11196,202,0,239),(11198,16,0,241),(11198,119,0,242),(11198,196,0,244),(11198,202,0,243),(11200,16,0,245),(11200,96,0,246),(11200,196,0,248),(11200,202,0,247),(11202,16,0,249),(11202,96,0,250),(11202,196,0,252),(11202,202,0,251),(11365,16,0,253),(11365,47,0,255),(11365,144,0,254),(11371,16,0,256),(11371,47,0,258),(11371,117,0,257),(11377,16,0,259),(11377,154,0,260),(11377,160,0,262),(11377,181,0,261),(11379,16,0,263),(11379,54,0,265),(11379,142,0,264),(11381,16,0,266),(11381,54,0,268),(11381,98,0,267),(11387,16,0,269),(11387,47,0,271),(11387,119,0,270),(11387,184,0,272),(11393,16,0,273),(11393,47,0,558),(11393,75,0,274),(11400,16,0,276),(11400,58,0,278),(11400,119,0,277),(11400,201,0,279),(11957,16,0,280),(11957,149,0,281),(11957,181,0,282),(11957,187,0,283),(11959,16,0,284),(11959,54,0,286),(11959,149,0,285),(11959,187,0,287),(11961,16,0,288),(11961,47,0,290),(11961,149,0,289),(11961,184,0,291),(11963,16,0,292),(11963,126,0,293),(11963,181,0,294),(11963,183,0,295),(11965,16,0,296),(11965,167,0,297),(11965,181,0,298),(11965,193,0,299),(11969,16,0,300),(11969,105,0,624),(11969,181,0,302),(11969,190,0,303),(11971,16,0,304),(11971,47,0,306),(11971,105,0,305),(11971,190,0,307),(11978,16,0,308),(11978,54,0,310),(11978,66,0,309),(11985,16,0,311),(11985,54,0,561),(11985,66,0,312),(11987,16,0,314),(11987,47,0,316),(11987,66,0,315),(11989,16,0,317),(11989,47,0,319),(11989,66,0,318),(11993,16,0,320),(11993,54,0,322),(11993,149,0,321),(11995,16,0,323),(11995,54,0,325),(11995,149,0,324),(11995,199,0,326),(11999,16,0,327),(11999,58,0,564),(11999,124,0,328),(11999,202,0,330),(12003,16,0,331),(12003,47,0,333),(12003,82,0,332),(12005,16,0,334),(12005,47,0,336),(12005,171,0,335),(12011,16,0,337),(12011,54,0,339),(12011,105,0,338),(12013,16,0,340),(12013,54,0,342),(12013,124,0,341),(12013,199,0,343),(12015,16,0,344),(12015,47,0,346),(12015,126,0,345),(12017,16,0,347),(12017,47,0,349),(12017,82,0,348),(12017,199,0,350),(12019,16,0,351),(12019,47,0,353),(12019,151,0,352),(12021,16,0,354),(12021,47,0,356),(12021,103,0,355),(12021,199,0,357),(12023,16,0,358),(12023,47,0,360),(12023,103,0,359),(12023,202,0,361),(12032,16,0,362),(12032,154,0,363),(12032,160,0,365),(12032,181,0,364),(12034,16,0,366),(12034,154,0,367),(12034,160,0,369),(12034,181,0,368),(12038,16,0,370),(12038,154,0,371),(12038,160,0,373),(12038,181,0,372),(12042,16,0,374),(12042,47,0,376),(12042,167,0,375),(12044,16,0,377),(12044,47,0,379),(12044,96,0,378),(12729,16,0,380),(12729,54,0,381),(12731,16,0,382),(12731,54,0,383),(12733,16,0,384),(12733,47,0,385),(12735,16,0,386),(12735,54,0,387),(12743,16,0,388),(12743,47,0,389),(12745,16,0,390),(12745,47,0,391),(12747,16,0,556),(12747,54,0,393),(12753,16,0,394),(12753,47,0,395),(16227,16,0,396),(16227,54,0,398),(16227,101,0,397),(16229,16,0,399),(16229,47,0,401),(16229,101,0,400),(16231,16,0,402),(16231,54,0,404),(16231,122,0,403),(16233,16,0,405),(16233,47,0,407),(16233,80,0,559),(16236,15,0,408),(16236,46,0,410),(16236,72,0,409),(16238,15,0,411),(16238,53,0,413),(16238,93,0,412),(16240,15,0,414),(16240,46,0,416),(16240,93,0,415),(16242,15,0,417),(16242,53,0,419),(16242,114,0,418),(17476,15,0,420),(17476,53,0,422),(17476,241,0,421),(17478,15,0,424),(17478,53,0,426),(17478,241,0,425),(17480,15,0,428),(17480,53,0,430),(17480,241,0,429),(19744,15,0,432),(19744,46,0,433),(20125,16,0,434),(20125,47,0,436),(20125,167,0,435),(20125,193,0,437),(22428,18,0,438),(22428,48,0,440),(22428,91,0,439),(22428,208,0,441),(22430,18,0,442),(22430,48,0,444),(22430,171,0,443),(22430,208,0,445),(22436,18,0,446),(22436,156,0,447),(22436,187,0,449),(22436,208,0,560),(22440,18,0,450),(22440,48,0,452),(22440,133,0,451),(22440,208,0,453),(22442,18,0,454),(22442,48,0,456),(22442,167,0,455),(22442,225,0,457),(22444,18,0,458),(22444,55,0,460),(22444,124,0,459),(22446,18,0,461),(22446,59,0,463),(22446,105,0,563),(22446,228,0,464),(22448,18,0,465),(22448,48,0,467),(22448,82,0,466),(22452,16,0,5),(22452,47,0,470),(22452,144,0,6),(22452,198,0,471),(22456,16,0,472),(22456,54,0,474),(22456,119,0,473),(22456,198,0,475),(22460,16,0,476),(22460,47,0,478),(22460,96,0,477),(22460,198,0,479),(22464,16,0,480),(22464,54,0,482),(22464,142,0,622),(22464,198,0,483),(22466,18,0,484),(22466,48,0,486),(22466,103,0,485),(22468,18,0,487),(22468,55,0,489),(22468,124,0,488),(22468,231,0,490),(22470,18,0,491),(22470,59,0,493),(22470,149,0,492),(22474,18,0,494),(22474,48,0,496),(22474,149,0,495),(22474,221,0,497),(22544,16,0,498),(22544,54,0,500),(22544,242,0,499),(22546,16,0,502),(22546,54,0,504),(22546,244,0,566),(22548,16,0,506),(22548,54,0,508),(22548,251,0,565),(24688,16,0,510),(24688,54,0,512),(24688,107,0,511),(24690,16,0,513),(24690,47,0,515),(24690,107,0,514),(24690,201,0,516),(24692,16,0,517),(24692,47,0,519),(24692,86,0,518),(24694,16,0,520),(24694,54,0,522),(24694,128,0,521),(24696,16,0,523),(24696,47,0,525),(24696,80,0,524),(24698,16,0,526),(24698,58,0,528),(24698,147,0,527),(24700,16,0,529),(24700,47,0,531),(24700,166,0,562),(24702,16,0,532),(24702,47,0,534),(24702,122,0,533),(28659,18,0,535),(28659,48,0,537),(28659,91,0,536),(28659,196,0,538),(28661,18,0,539),(28661,48,0,541),(28661,112,0,540),(28661,196,0,542),(28665,18,0,543),(28665,55,0,545),(28665,131,0,544),(28665,184,0,546),(28710,18,0,547),(28710,55,0,549),(28710,156,0,548),(28710,184,0,550),(29248,15,0,551),(29248,46,0,553),(29248,72,0,552),(29248,204,0,554),(29984,16,0,578),(29984,54,0,577),(29984,147,0,579),(29986,16,0,568),(29986,47,0,567),(29986,80,0,569),(29988,16,0,574),(29988,47,0,573),(29988,101,0,575),(29988,166,0,576),(29990,16,0,571),(29990,47,0,570),(29990,122,0,572);

/*Table structure for table `crtRelationships` */

DROP TABLE IF EXISTS `crtRelationships`;

CREATE TABLE `crtRelationships` (
  `relationshipID` int(10) unsigned NOT NULL,
  `parentID` int(10) unsigned NOT NULL,
  `parentTypeID` int(10) unsigned NOT NULL,
  `parentLevel` int(10) unsigned NOT NULL,
  `childID` int(10) unsigned NOT NULL,
  `childTypeID` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`relationshipID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `crtRelationships` */

insert  into `crtRelationships`(`relationshipID`,`parentID`,`parentTypeID`,`parentLevel`,`childID`,`childTypeID`) values (1441,1,0,1,2,0),(1442,1,0,1,15,0),(1443,2,0,1,4,0),(1444,2,0,1,16,0),(1445,3,0,1,14,0),(1446,4,0,1,18,0),(1447,5,0,1,6,0),(1448,5,0,1,15,0),(1449,6,0,1,7,0),(1450,6,0,1,16,0),(1451,7,0,1,8,0),(1452,8,0,1,18,0),(1453,9,0,1,10,0),(1454,9,0,1,15,0),(1455,10,0,1,11,0),(1456,10,0,1,16,0),(1457,10,0,1,178,0),(1458,11,0,1,18,0),(1459,11,0,1,179,0),(1460,12,0,1,15,0),(1461,12,0,1,201,0),(1462,13,0,1,3,0),(1463,13,0,1,16,0),(1464,14,0,1,18,0),(1465,14,0,1,203,0),(1466,15,0,1,16,0),(1467,15,0,1,294,0),(1468,15,0,1,305,0),(1469,15,0,1,309,0),(1470,15,0,1,312,0),(1471,15,0,1,315,0),(1472,15,0,1,321,0),(1473,15,0,1,323,0),(1474,15,0,1,327,0),(1475,15,0,1,330,0),(1476,15,0,1,339,0),(1477,15,0,1,341,0),(1478,15,0,1,345,0),(1479,15,0,1,348,0),(1480,15,0,1,351,0),(1481,15,0,1,357,0),(1482,15,0,1,359,0),(1483,16,0,1,18,0),(1484,16,0,1,295,0),(1485,16,0,1,298,0),(1486,16,0,1,306,0),(1487,16,0,1,313,0),(1488,16,0,1,324,0),(1489,16,0,1,331,0),(1490,16,0,1,342,0),(1491,16,0,1,349,0),(1492,16,0,1,352,0),(1493,16,0,1,360,0),(1494,19,0,1,15,0),(1495,19,0,1,20,0),(1496,20,0,1,16,0),(1497,20,0,1,21,0),(1498,21,0,1,18,0),(1502,21,0,1,64,0),(1503,22,0,1,299,0),(1504,23,0,1,305,0),(1505,24,0,1,308,0),(1506,25,0,1,302,0),(1507,26,0,1,293,0),(1508,27,0,1,296,0),(1509,28,0,1,317,0),(1510,29,0,1,323,0),(1511,30,0,1,326,0),(1512,31,0,1,320,0),(1513,32,0,1,311,0),(1514,33,0,1,314,0),(1515,34,0,1,335,0),(1516,35,0,1,341,0),(1517,36,0,1,344,0),(1518,37,0,1,338,0),(1519,38,0,1,329,0),(1520,39,0,1,332,0),(1521,40,0,1,353,0),(1522,41,0,1,359,0),(1523,43,0,1,356,0),(1524,44,0,1,347,0),(1525,45,0,1,350,0),(1526,46,0,1,47,0),(1527,46,0,1,296,0),(1528,46,0,1,302,0),(1529,46,0,1,332,0),(1530,46,0,1,338,0),(1531,47,0,1,48,0),(1532,47,0,1,293,0),(1533,47,0,1,297,0),(1534,47,0,1,304,0),(1535,47,0,1,308,0),(1536,47,0,1,329,0),(1537,47,0,1,333,0),(1538,47,0,1,340,0),(1539,47,0,1,344,0),(1540,48,0,1,49,0),(1541,50,0,1,51,0),(1542,51,0,1,48,0),(1543,51,0,1,52,0),(1544,52,0,1,49,0),(1545,53,0,1,54,0),(1546,53,0,1,320,0),(1547,53,0,1,356,0),(1548,54,0,1,55,0),(1552,54,0,1,322,0),(1556,54,0,1,358,0),(1557,55,0,1,56,0),(1558,57,0,1,58,0),(1559,58,0,1,59,0),(1560,59,0,1,60,0),(1561,61,0,1,62,0),(1562,62,0,1,55,0),(1563,62,0,1,58,0),(1564,62,0,1,63,0),(1565,63,0,1,56,0),(1566,63,0,1,60,0),(1567,65,0,1,66,0),(1568,66,0,1,67,0),(1569,68,0,1,69,0),(1570,68,0,1,72,0),(1571,68,0,1,79,0),(1572,68,0,1,86,0),(1573,68,0,1,93,0),(1574,68,0,1,100,0),(1575,68,0,1,107,0),(1576,68,0,1,114,0),(1577,68,0,1,121,0),(1578,68,0,1,128,0),(1579,69,0,1,70,0),(1580,69,0,1,73,0),(1581,69,0,1,80,0),(1582,69,0,1,87,0),(1583,69,0,1,94,0),(1584,69,0,1,101,0),(1585,69,0,1,108,0),(1586,69,0,1,115,0),(1587,69,0,1,122,0),(1588,69,0,1,129,0),(1589,70,0,1,71,0),(1590,71,0,1,74,0),(1591,71,0,1,81,0),(1592,71,0,1,88,0),(1593,71,0,1,95,0),(1594,71,0,1,102,0),(1595,71,0,1,109,0),(1596,71,0,1,116,0),(1597,71,0,1,123,0),(1598,71,0,1,130,0),(1599,72,0,1,73,0),(1600,72,0,1,293,0),(1601,72,0,1,296,0),(1602,72,0,1,308,0),(1603,73,0,1,74,0),(1604,73,0,1,75,0),(1605,73,0,1,77,0),(1606,73,0,1,294,0),(1607,73,0,1,297,0),(1608,75,0,1,76,0),(1609,76,0,1,74,0),(1610,77,0,1,78,0),(1611,78,0,1,74,0),(1612,79,0,1,80,0),(1613,79,0,1,295,0),(1614,79,0,1,310,0),(1615,80,0,1,81,0),(1616,80,0,1,82,0),(1617,80,0,1,84,0),(1618,82,0,1,83,0),(1619,83,0,1,81,0),(1621,84,0,1,85,0),(1622,85,0,1,81,0),(1624,86,0,1,87,0),(1625,87,0,1,88,0),(1626,87,0,1,89,0),(1627,87,0,1,91,0),(1628,89,0,1,90,0),(1629,91,0,1,92,0),(1630,93,0,1,94,0),(1631,93,0,1,329,0),(1632,93,0,1,332,0),(1633,93,0,1,344,0),(1634,94,0,1,95,0),(1635,94,0,1,96,0),(1636,94,0,1,98,0),(1637,94,0,1,330,0),(1638,96,0,1,97,0),(1639,97,0,1,95,0),(1640,98,0,1,99,0),(1641,99,0,1,95,0),(1642,100,0,1,101,0),(1643,100,0,1,331,0),(1644,100,0,1,334,0),(1645,100,0,1,346,0),(1646,101,0,1,102,0),(1647,101,0,1,103,0),(1648,101,0,1,105,0),(1649,103,0,1,104,0),(1650,104,0,1,102,0),(1651,105,0,1,106,0),(1652,106,0,1,102,0),(1653,107,0,1,108,0),(1654,108,0,1,109,0),(1655,108,0,1,110,0),(1656,108,0,1,112,0),(1657,110,0,1,111,0),(1658,111,0,1,109,0),(1659,112,0,1,113,0),(1660,113,0,1,109,0),(1661,114,0,1,115,0),(1662,114,0,1,347,0),(1663,114,0,1,350,0),(1664,115,0,1,116,0),(1665,115,0,1,117,0),(1666,115,0,1,119,0),(1667,115,0,1,348,0),(1668,115,0,1,351,0),(1669,117,0,1,118,0),(1670,118,0,1,116,0),(1671,119,0,1,120,0),(1672,120,0,1,116,0),(1673,121,0,1,122,0),(1674,121,0,1,349,0),(1675,121,0,1,352,0),(1676,122,0,1,123,0),(1677,122,0,1,124,0),(1678,122,0,1,126,0),(1679,124,0,1,125,0),(1680,125,0,1,123,0),(1681,126,0,1,127,0),(1682,127,0,1,123,0),(1683,128,0,1,129,0),(1684,129,0,1,130,0),(1685,129,0,1,131,0),(1686,129,0,1,133,0),(1687,131,0,1,132,0),(1688,132,0,1,130,0),(1689,133,0,1,134,0),(1690,134,0,1,130,0),(1691,135,0,1,136,0),(1692,135,0,1,139,0),(1693,135,0,1,146,0),(1694,135,0,1,153,0),(1695,136,0,1,137,0),(1696,136,0,1,140,0),(1697,136,0,1,147,0),(1698,136,0,1,154,0),(1699,137,0,1,138,0),(1700,138,0,1,141,0),(1701,138,0,1,148,0),(1702,138,0,1,155,0),(1703,139,0,1,140,0),(1704,139,0,1,311,0),(1705,139,0,1,314,0),(1706,139,0,1,326,0),(1707,140,0,1,141,0),(1708,140,0,1,142,0),(1709,140,0,1,144,0),(1710,140,0,1,312,0),(1711,140,0,1,315,0),(1712,142,0,1,143,0),(1713,143,0,1,141,0),(1714,144,0,1,145,0),(1715,145,0,1,141,0),(1716,146,0,1,147,0),(1717,146,0,1,313,0),(1718,146,0,1,316,0),(1719,146,0,1,328,0),(1720,147,0,1,148,0),(1721,147,0,1,149,0),(1722,147,0,1,151,0),(1723,149,0,1,150,0),(1724,150,0,1,148,0),(1725,151,0,1,152,0),(1726,152,0,1,148,0),(1727,153,0,1,154,0),(1728,154,0,1,155,0),(1729,154,0,1,156,0),(1730,154,0,1,158,0),(1731,156,0,1,157,0),(1732,157,0,1,155,0),(1733,158,0,1,159,0),(1734,159,0,1,155,0),(1735,161,0,1,162,0),(1736,161,0,1,166,0),(1737,161,0,1,170,0),(1739,162,0,1,163,0),(1740,162,0,1,167,0),(1741,162,0,1,171,0),(1743,162,0,1,298,0),(1745,163,0,1,164,0),(1746,163,0,1,176,0),(1748,164,0,1,168,0),(1749,164,0,1,172,0),(1750,165,0,1,166,0),(1751,166,0,1,167,0),(1752,167,0,1,168,0),(1753,168,0,1,176,0),(1754,169,0,1,170,0),(1755,170,0,1,171,0),(1756,171,0,1,172,0),(1757,172,0,1,176,0),(1758,173,0,1,167,0),(1759,173,0,1,174,0),(1760,174,0,1,171,0),(1761,174,0,1,175,0),(1763,177,0,1,178,0),(1764,177,0,1,187,0),(1765,177,0,1,190,0),(1766,177,0,1,193,0),(1769,179,0,1,185,0),(1770,179,0,1,188,0),(1771,179,0,1,191,0),(1772,179,0,1,194,0),(1773,180,0,1,181,0),(1774,181,0,1,182,0),(1775,183,0,1,184,0),(1776,184,0,1,185,0),(1777,186,0,1,187,0),(1778,186,0,1,316,0),(1779,187,0,1,188,0),(1780,189,0,1,190,0),(1781,190,0,1,191,0),(1782,192,0,1,193,0),(1783,193,0,1,194,0),(1784,195,0,1,196,0),(1785,196,0,1,197,0),(1786,198,0,1,199,0),(1787,200,0,1,201,0),(1788,201,0,1,331,0),(1789,202,0,1,203,0),(1790,204,0,1,205,0),(1791,205,0,1,207,0),(1792,209,0,1,210,0),(1793,210,0,1,211,0),(1794,210,0,1,309,0),(1795,210,0,1,327,0),(1796,210,0,1,345,0),(1797,211,0,1,234,0),(1798,212,0,1,209,0),(1799,212,0,1,213,0),(1800,212,0,1,220,0),(1801,212,0,1,224,0),(1802,212,0,1,227,0),(1803,212,0,1,230,0),(1804,212,0,1,235,0),(1805,213,0,1,214,0),(1806,213,0,1,221,0),(1807,213,0,1,225,0),(1808,213,0,1,228,0),(1809,213,0,1,231,0),(1811,214,0,1,215,0),(1812,214,0,1,222,0),(1813,214,0,1,226,0),(1814,214,0,1,229,0),(1815,214,0,1,232,0),(1817,215,0,1,234,0),(1818,215,0,1,238,0),(1819,216,0,1,217,0),(1820,216,0,1,221,0),(1821,216,0,1,225,0),(1822,216,0,1,228,0),(1823,216,0,1,231,0),(1824,217,0,1,218,0),(1825,217,0,1,222,0),(1826,217,0,1,226,0),(1827,217,0,1,229,0),(1828,217,0,1,232,0),(1829,217,0,1,237,0),(1830,219,0,1,234,0),(1831,220,0,1,221,0),(1832,220,0,1,310,0),(1833,221,0,1,222,0),(1834,221,0,1,233,0),(1835,222,0,1,234,0),(1836,224,0,1,225,0),(1837,224,0,1,346,0),(1838,225,0,1,226,0),(1839,225,0,1,233,0),(1840,226,0,1,234,0),(1841,227,0,1,228,0),(1842,227,0,1,328,0),(1843,228,0,1,229,0),(1844,228,0,1,233,0),(1845,229,0,1,234,0),(1846,230,0,1,231,0),(1847,231,0,1,232,0),(1848,231,0,1,233,0),(1849,232,0,1,234,0),(1850,235,0,1,236,0),(1851,236,0,1,237,0),(1852,237,0,1,238,0),(1853,239,0,1,240,0),(1854,240,0,1,241,0),(1856,240,0,1,302,0),(1857,240,0,1,320,0),(1858,240,0,1,338,0),(1859,240,0,1,356,0),(1860,241,0,1,242,0),(1861,241,0,1,303,0),(1862,241,0,1,321,0),(1863,241,0,1,339,0),(1864,241,0,1,357,0),(1867,243,0,1,244,0),(1868,244,0,1,245,0),(1873,250,0,1,251,0),(1884,258,0,1,259,0),(1885,259,0,1,260,0),(1886,259,0,1,262,0),(1887,260,0,1,261,0),(1889,262,0,1,263,0),(1891,263,0,1,264,0),(1892,264,0,1,265,0),(1894,266,0,1,267,0),(1896,267,0,1,268,0),(1897,268,0,1,269,0),(1899,270,0,1,271,0),(1900,270,0,1,299,0),(1901,270,0,1,317,0),(1902,270,0,1,335,0),(1903,270,0,1,353,0),(1904,271,0,1,272,0),(1905,271,0,1,300,0),(1906,271,0,1,318,0),(1907,271,0,1,336,0),(1908,271,0,1,354,0),(1909,272,0,1,273,0),(1910,272,0,1,301,0),(1911,272,0,1,319,0),(1912,272,0,1,337,0),(1913,272,0,1,355,0),(1918,278,0,1,279,0),(1919,278,0,1,299,0),(1920,278,0,1,317,0),(1921,278,0,1,335,0),(1922,278,0,1,353,0),(1923,279,0,1,280,0),(1924,279,0,1,300,0),(1925,279,0,1,318,0),(1926,279,0,1,336,0),(1927,279,0,1,354,0),(1928,280,0,1,281,0),(1929,280,0,1,301,0),(1930,280,0,1,319,0),(1931,280,0,1,337,0),(1932,280,0,1,355,0),(1933,282,0,1,283,0),(1934,283,0,1,205,0),(1935,283,0,1,284,0),(1936,284,0,1,207,0),(1937,285,0,1,286,0),(1938,286,0,1,287,0),(1939,286,0,1,305,0),(1940,286,0,1,323,0),(1941,286,0,1,341,0),(1942,286,0,1,359,0),(1943,287,0,1,288,0),(1944,287,0,1,306,0),(1945,287,0,1,324,0),(1946,287,0,1,342,0),(1947,287,0,1,360,0),(1949,288,0,1,307,0),(1950,288,0,1,325,0),(1951,288,0,1,343,0),(1952,289,0,1,290,0),(1953,290,0,1,291,0),(1954,291,0,1,292,0),(1955,293,0,1,294,0),(1956,294,0,1,295,0),(1957,296,0,1,297,0),(1958,297,0,1,298,0),(1959,299,0,1,300,0),(1960,300,0,1,301,0),(1961,302,0,1,303,0),(1962,303,0,1,304,0),(1963,305,0,1,306,0),(1964,306,0,1,307,0),(1965,308,0,1,309,0),(1966,309,0,1,310,0),(1967,311,0,1,312,0),(1968,312,0,1,313,0),(1969,314,0,1,315,0),(1970,315,0,1,316,0),(1971,317,0,1,318,0),(1972,318,0,1,319,0),(1973,320,0,1,321,0),(1974,321,0,1,322,0),(1975,323,0,1,324,0),(1976,324,0,1,325,0),(1977,326,0,1,327,0),(1978,327,0,1,328,0),(1979,329,0,1,330,0),(1980,330,0,1,331,0),(1981,332,0,1,333,0),(1982,333,0,1,334,0),(1983,335,0,1,336,0),(1984,336,0,1,337,0),(1985,338,0,1,339,0),(1986,339,0,1,340,0),(1987,341,0,1,342,0),(1988,342,0,1,343,0),(1989,344,0,1,345,0),(1990,345,0,1,346,0),(1991,347,0,1,348,0),(1992,348,0,1,349,0),(1993,350,0,1,351,0),(1994,351,0,1,352,0),(1995,353,0,1,354,0),(1996,354,0,1,355,0),(1997,356,0,1,357,0),(1998,357,0,1,358,0),(1999,359,0,1,360,0),(2000,0,3300,5,26,0),(2001,0,3300,3,27,0),(2002,0,3300,5,38,0),(2003,0,3300,5,44,0),(2004,0,3300,3,45,0),(2005,0,3300,3,68,0),(2006,0,3300,5,69,0),(2007,0,3300,3,79,0),(2008,0,3300,5,86,0),(2009,0,3300,3,100,0),(2010,0,3300,5,107,0),(2011,0,3300,3,121,0),(2012,0,3300,5,128,0),(2013,0,3301,5,38,0),(2014,0,3301,3,39,0),(2015,0,3301,3,93,0),(2016,0,3301,4,94,0),(2017,0,3302,5,44,0),(2018,0,3302,3,114,0),(2019,0,3302,4,115,0),(2020,0,3303,5,26,0),(2021,0,3303,3,72,0),(2022,0,3303,4,73,0),(2023,0,3304,3,100,0),(2024,0,3304,4,101,0),(2025,0,3305,3,121,0),(2026,0,3305,4,122,0),(2027,0,3306,3,79,0),(2028,0,3306,4,80,0),(2029,0,3307,3,107,0),(2030,0,3307,4,108,0),(2031,0,3308,3,128,0),(2032,0,3308,4,129,0),(2033,0,3309,3,86,0),(2034,0,3309,4,87,0),(2035,0,3310,2,68,0),(2036,0,3310,4,69,0),(2037,0,3310,5,70,0),(2038,0,3311,1,68,0),(2039,0,3311,3,69,0),(2040,0,3311,4,70,0),(2041,0,3311,5,71,0),(2042,0,3311,2,72,0),(2043,0,3311,4,73,0),(2044,0,3311,2,79,0),(2045,0,3311,4,80,0),(2046,0,3311,2,86,0),(2047,0,3311,4,87,0),(2048,0,3312,2,68,0),(2049,0,3312,4,69,0),(2050,0,3312,5,70,0),(2051,0,3312,3,93,0),(2052,0,3312,4,94,0),(2053,0,3312,3,100,0),(2054,0,3312,4,101,0),(2055,0,3312,3,107,0),(2056,0,3312,4,108,0),(2057,0,3312,3,114,0),(2058,0,3312,4,115,0),(2059,0,3312,3,121,0),(2060,0,3312,4,122,0),(2061,0,3312,3,128,0),(2062,0,3312,4,129,0),(2063,0,3315,3,70,0),(2064,0,3315,5,71,0),(2069,0,3316,3,72,0),(2070,0,3316,4,73,0),(2071,0,3316,3,79,0),(2072,0,3316,4,80,0),(2073,0,3316,3,86,0),(2074,0,3316,4,87,0),(2075,0,3316,2,93,0),(2076,0,3316,4,94,0),(2077,0,3316,2,100,0),(2078,0,3316,4,101,0),(2079,0,3316,2,107,0),(2080,0,3316,4,108,0),(2082,0,3317,4,70,0),(2083,0,3317,5,71,0),(2084,0,3317,2,114,0),(2085,0,3317,4,115,0),(2086,0,3317,2,121,0),(2087,0,3317,4,122,0),(2088,0,3317,2,128,0),(2089,0,3317,4,129,0),(2090,0,3318,4,6,0),(2091,0,3319,4,32,0),(2092,0,3319,3,135,0),(2093,0,3319,5,136,0),(2094,0,3320,2,139,0),(2095,0,3320,4,140,0),(2096,0,3321,3,32,0),(2097,0,3321,2,139,0),(2098,0,3321,4,140,0),(2099,0,3324,2,146,0),(2100,0,3324,4,147,0),(2101,0,3325,2,153,0),(2102,0,3325,4,154,0),(2103,0,3326,2,153,0),(2104,0,3326,4,154,0),(2105,0,3327,5,3,0),(2106,0,3327,3,12,0),(2107,0,3328,1,34,0),(2108,0,3328,2,35,0),(2109,0,3328,2,36,0),(2110,0,3328,1,37,0),(2111,0,3328,3,38,0),(2112,0,3328,4,39,0),(2113,0,3328,4,329,0),(2114,0,3328,3,338,0),(2115,0,3328,4,344,0),(2116,0,3329,1,40,0),(2117,0,3329,2,41,0),(2118,0,3329,2,42,0),(2119,0,3329,1,43,0),(2120,0,3329,3,44,0),(2121,0,3329,4,45,0),(2122,0,3329,4,347,0),(2123,0,3329,3,353,0),(2124,0,3329,3,356,0),(2125,0,3330,1,28,0),(2126,0,3330,2,29,0),(2127,0,3330,2,30,0),(2128,0,3330,1,31,0),(2129,0,3330,3,32,0),(2130,0,3330,4,33,0),(2131,0,3330,4,311,0),(2132,0,3330,3,317,0),(2133,0,3330,3,320,0),(2134,0,3330,4,326,0),(2135,0,3331,1,22,0),(2136,0,3331,2,23,0),(2137,0,3331,2,24,0),(2138,0,3331,1,25,0),(2139,0,3331,3,26,0),(2140,0,3331,4,27,0),(2141,0,3331,4,293,0),(2142,0,3331,3,299,0),(2143,0,3331,3,302,0),(2144,0,3331,4,308,0),(2145,0,3332,3,331,0),(2146,0,3332,3,334,0),(2147,0,3332,3,340,0),(2148,0,3332,3,346,0),(2149,0,3333,3,349,0),(2150,0,3333,3,352,0),(2151,0,3333,3,358,0),(2152,0,3334,3,313,0),(2153,0,3334,3,316,0),(2154,0,3334,3,322,0),(2155,0,3334,3,328,0),(2156,0,3335,3,295,0),(2157,0,3335,3,298,0),(2158,0,3335,3,310,0),(2159,0,3340,1,336,0),(2160,0,3340,3,337,0),(2161,0,3340,1,339,0),(2162,0,3340,1,341,0),(2163,0,3340,3,342,0),(2164,0,3340,4,343,0),(2165,0,3341,1,354,0),(2166,0,3341,3,355,0),(2167,0,3341,1,357,0),(2168,0,3341,1,359,0),(2169,0,3341,3,360,0),(2170,0,3342,1,318,0),(2171,0,3342,3,319,0),(2172,0,3342,1,321,0),(2173,0,3342,1,323,0),(2174,0,3342,3,324,0),(2175,0,3342,4,325,0),(2176,0,3343,1,305,0),(2177,0,3343,3,306,0),(2178,0,3343,4,307,0),(2179,0,3348,5,24,0),(2180,0,3348,5,30,0),(2181,0,3348,5,36,0),(2182,0,3348,5,42,0),(2183,0,3348,5,212,0),(2185,0,3349,2,209,0),(2186,0,3349,4,210,0),(2187,0,3349,5,211,0),(2188,0,3349,5,230,0),(2190,0,3350,2,209,0),(2191,0,3350,4,210,0),(2192,0,3350,5,211,0),(2193,0,3350,5,227,0),(2194,0,3351,4,228,0),(2195,0,3351,5,229,0),(2196,0,3352,4,225,0),(2197,0,3352,5,226,0),(2198,0,3354,1,216,0),(2199,0,3354,3,217,0),(2200,0,3354,4,218,0),(2201,0,3354,5,238,0),(2202,0,3380,3,22,0),(2203,0,3380,4,25,0),(2204,0,3380,3,28,0),(2205,0,3380,3,31,0),(2206,0,3380,4,34,0),(2207,0,3380,3,37,0),(2208,0,3380,5,40,0),(2209,0,3380,3,43,0),(2212,0,3380,3,270,0),(2213,0,3380,5,271,0),(2214,0,3385,5,25,0),(2215,0,3385,5,31,0),(2216,0,3385,5,37,0),(2217,0,3385,5,43,0),(2218,0,3385,3,258,0),(2219,0,3385,5,259,0),(2220,0,3386,5,25,0),(2221,0,3386,5,31,0),(2222,0,3386,5,37,0),(2223,0,3386,5,43,0),(2224,0,3386,4,239,0),(2225,0,3386,5,240,0),(2227,0,3387,3,22,0),(2228,0,3387,1,28,0),(2229,0,3387,3,34,0),(2230,0,3387,3,40,0),(2231,0,3387,1,270,0),(2234,0,3388,2,270,0),(2235,0,3388,5,271,0),(2238,0,3389,1,259,0),(2239,0,3389,4,260,0),(2240,0,3389,5,261,0),(2241,0,3392,3,19,0),(2242,0,3392,4,20,0),(2243,0,3392,5,21,0),(2244,0,3392,3,46,0),(2245,0,3392,5,47,0),(2246,0,3392,5,64,0),(2247,0,3392,1,201,0),(2248,0,3393,4,24,0),(2249,0,3393,4,26,0),(2250,0,3393,4,38,0),(2251,0,3393,3,46,0),(2252,0,3393,4,47,0),(2253,0,3393,5,48,0),(2254,0,3393,5,64,0),(2255,0,3394,3,19,0),(2256,0,3394,4,20,0),(2257,0,3394,5,21,0),(2258,0,3394,3,46,0),(2259,0,3394,4,47,0),(2260,0,3394,5,48,0),(2261,0,3394,1,57,0),(2262,0,3394,4,59,0),(2263,0,3394,4,64,0),(2264,0,3394,2,201,0),(2265,0,3402,5,280,0),(2266,0,3403,1,278,0),(2267,0,3403,4,279,0),(2268,0,3406,3,22,0),(2269,0,3406,5,28,0),(2270,0,3406,3,34,0),(2271,0,3406,3,40,0),(2272,0,3406,1,278,0),(2273,0,3406,4,279,0),(2275,0,3409,4,260,0),(2276,0,3409,5,261,0),(2277,0,3409,1,278,0),(2278,0,3409,4,279,0),(2279,0,3409,5,280,0),(2280,0,3410,3,241,0),(2281,0,3410,5,242,0),(2282,0,3411,5,222,0),(2283,0,3411,5,226,0),(2284,0,3411,5,229,0),(2285,0,3411,5,232,0),(2286,0,3411,5,237,0),(2287,0,3412,3,198,0),(2288,0,3412,4,204,0),(2289,0,3412,5,205,0),(2290,0,3413,3,5,0),(2291,0,3413,5,6,0),(2292,0,3416,4,30,0),(2293,0,3416,3,32,0),(2294,0,3416,3,33,0),(2295,0,3416,4,42,0),(2296,0,3416,3,44,0),(2297,0,3416,3,53,0),(2298,0,3416,5,54,0),(2299,0,3417,3,1,0),(2300,0,3417,5,2,0),(2301,0,3417,5,27,0),(2302,0,3418,3,1,0),(2303,0,3418,4,2,0),(2304,0,3418,5,4,0),(2306,0,3418,4,6,0),(2307,0,3419,3,19,0),(2308,0,3419,4,20,0),(2309,0,3419,5,21,0),(2310,0,3419,3,54,0),(2311,0,3419,4,55,0),(2312,0,3419,5,56,0),(2313,0,3419,4,57,0),(2314,0,3419,5,58,0),(2315,0,3420,2,54,0),(2316,0,3420,4,55,0),(2317,0,3420,5,56,0),(2318,0,3420,4,59,0),(2319,0,3420,5,60,0),(2320,0,3422,2,65,0),(2321,0,3422,4,66,0),(2322,0,3422,5,67,0),(2323,0,3423,2,65,0),(2324,0,3423,4,66,0),(2325,0,3423,5,67,0),(2326,0,3424,2,1,0),(2327,0,3424,4,2,0),(2328,0,3424,2,5,0),(2329,0,3424,5,7,0),(2330,0,3424,2,58,0),(2331,0,3424,4,59,0),(2332,0,3425,3,53,0),(2333,0,3425,4,54,0),(2334,0,3425,5,56,0),(2335,0,3426,3,5,0),(2336,0,3426,5,6,0),(2337,0,3427,2,33,0),(2338,0,3427,2,186,0),(2340,0,3428,2,9,0),(2341,0,3428,4,10,0),(2342,0,3428,5,11,0),(2343,0,3429,4,9,0),(2344,0,3430,1,10,0),(2345,0,3430,3,11,0),(2346,0,3431,3,9,0),(2347,0,3431,4,10,0),(2348,0,3431,5,11,0),(2349,0,3431,3,181,0),(2350,0,3431,5,182,0),(2351,0,3432,1,5,0),(2352,0,3432,4,6,0),(2353,0,3432,5,7,0),(2354,0,3432,1,9,0),(2355,0,3432,5,10,0),(2356,0,3433,2,189,0),(2358,0,3434,2,192,0),(2360,0,3435,2,195,0),(2361,0,3435,4,196,0),(2362,0,3435,5,197,0),(2363,0,3435,5,198,0),(2364,0,3436,3,27,0),(2365,0,3436,5,39,0),(2366,0,3436,3,161,0),(2367,0,3436,5,162,0),(2368,0,3436,1,165,0),(2369,0,3436,5,166,0),(2370,0,3436,1,169,0),(2371,0,3437,4,39,0),(2372,0,3437,3,161,0),(2373,0,3437,5,162,0),(2378,0,3441,2,169,0),(2379,0,3441,4,170,0),(2380,0,3441,5,171,0),(2381,0,3442,3,162,0),(2382,0,3442,5,163,0),(2385,0,3443,5,23,0),(2386,0,3443,5,29,0),(2387,0,3443,5,35,0),(2388,0,3443,5,41,0),(2389,0,3443,2,285,0),(2390,0,3443,4,287,0),(2391,0,3443,5,288,0),(2392,0,3444,3,23,0),(2393,0,3444,4,29,0),(2394,0,3444,4,41,0),(2395,0,3444,2,285,0),(2396,0,3444,4,286,0),(2397,0,3444,5,287,0),(2398,0,3446,4,23,0),(2399,0,3446,4,35,0),(2400,0,3446,2,285,0),(2401,0,3446,4,287,0),(2402,0,3446,5,288,0),(2403,0,3449,5,3,0),(2404,0,3449,3,12,0),(2405,0,3449,5,45,0),(2406,0,3450,5,45,0),(2407,0,3450,2,200,0),(2408,0,3450,5,203,0),(2409,0,3451,2,200,0),(2410,0,3451,4,201,0),(2411,0,3451,5,203,0),(2412,0,3452,2,201,0),(2413,0,3452,5,203,0),(2414,0,3453,4,3,0),(2415,0,3453,2,12,0),(2416,0,3453,5,14,0),(2417,0,3454,2,201,0),(2418,0,3454,5,203,0),(2419,0,3455,4,3,0),(2420,0,3455,2,12,0),(2421,0,3455,5,14,0),(2422,0,11082,4,98,0),(2423,0,11082,5,99,0),(2424,0,11083,4,77,0),(2425,0,11083,5,78,0),(2426,0,11084,4,117,0),(2427,0,11084,5,118,0),(2428,0,11207,4,7,0),(2429,0,11207,5,8,0),(2430,0,11395,1,243,0),(2431,0,11395,4,244,0),(2432,0,11395,5,245,0),(2433,0,11446,1,198,0),(2434,0,11446,4,199,0),(2435,0,11566,1,61,0),(2436,0,11569,4,221,0),(2437,0,11569,5,222,0),(2438,0,11572,4,231,0),(2439,0,11572,5,232,0),(2440,0,11574,4,213,0),(2441,0,11579,2,180,0),(2442,0,11579,4,181,0),(2443,0,11579,5,182,0),(2444,0,12093,4,205,0),(2445,0,12093,5,207,0),(2446,0,12099,2,216,0),(2447,0,12179,3,280,0),(2448,0,12179,5,281,0),(2450,0,12180,5,269,0),(2452,0,12181,5,269,0),(2453,0,12182,3,266,0),(2454,0,12182,5,268,0),(2455,0,12183,3,266,0),(2456,0,12183,5,268,0),(2457,0,12184,3,266,0),(2458,0,12184,4,267,0),(2459,0,12185,4,266,0),(2461,0,12186,4,266,0),(2464,0,12187,3,265,0),(2465,0,12188,3,262,0),(2466,0,12188,5,265,0),(2468,0,12189,5,269,0),(2469,0,12190,3,262,0),(2470,0,12190,5,265,0),(2471,0,12191,3,262,0),(2472,0,12191,5,264,0),(2473,0,12192,3,262,0),(2474,0,12192,5,264,0),(2475,0,12193,3,262,0),(2476,0,12193,4,263,0),(2477,0,12195,3,262,0),(2478,0,12195,4,263,0),(2482,0,12201,4,119,0),(2483,0,12201,5,120,0),(2484,0,12202,4,126,0),(2485,0,12202,5,127,0),(2486,0,12203,4,133,0),(2487,0,12203,5,134,0),(2488,0,12204,4,84,0),(2489,0,12204,5,85,0),(2490,0,12205,4,91,0),(2491,0,12205,5,92,0),(2492,0,12206,4,105,0),(2493,0,12206,5,106,0),(2494,0,12207,4,112,0),(2495,0,12207,5,113,0),(2496,0,12208,4,124,0),(2497,0,12208,5,125,0),(2498,0,12209,4,131,0),(2499,0,12209,5,132,0),(2500,0,12210,4,96,0),(2501,0,12210,5,97,0),(2502,0,12211,4,103,0),(2503,0,12211,5,104,0),(2504,0,12212,4,110,0),(2505,0,12212,5,111,0),(2506,0,12213,4,75,0),(2507,0,12213,5,76,0),(2508,0,12214,4,82,0),(2509,0,12214,5,83,0),(2510,0,12215,4,89,0),(2511,0,12215,5,90,0),(2512,0,12305,2,161,0),(2513,0,12305,4,162,0),(2514,0,12365,1,61,0),(2515,0,12365,3,62,0),(2516,0,12365,5,63,0),(2517,0,12366,1,61,0),(2518,0,12366,3,62,0),(2519,0,12366,5,63,0),(2520,0,12367,1,61,0),(2521,0,12367,3,62,0),(2522,0,12367,5,63,0),(2523,0,12441,5,33,0),(2524,0,12441,2,135,0),(2525,0,12441,4,136,0),(2526,0,12441,5,137,0),(2527,0,12442,2,136,0),(2528,0,12442,4,137,0),(2529,0,12442,5,138,0),(2530,0,12484,2,173,0),(2531,0,12484,4,174,0),(2532,0,12484,5,175,0),(2533,0,12485,2,173,0),(2534,0,12485,4,174,0),(2535,0,12485,5,175,0),(2536,0,12486,2,173,0),(2537,0,12486,4,174,0),(2538,0,12486,5,175,0),(2539,0,12487,2,173,0),(2540,0,12487,4,174,0),(2541,0,12487,5,175,0),(2542,0,13278,1,283,0),(2543,0,13278,5,284,0),(2544,0,16069,2,65,0),(2545,0,16069,4,66,0),(2546,0,16069,5,67,0),(2547,0,16281,1,250,0),(2548,0,16281,4,251,0),(2550,0,16281,5,253,0),(2551,0,16594,2,289,0),(2552,0,16594,3,290,0),(2553,0,16594,4,291,0),(2554,0,16595,4,29,0),(2555,0,16595,4,35,0),(2556,0,16595,5,41,0),(2557,0,16595,3,289,0),(2558,0,16595,3,290,0),(2560,0,16596,4,290,0),(2561,0,16595,4,291,0),(2562,0,16597,3,290,0),(2563,0,16597,4,291,0),(2564,0,16598,2,286,0),(2565,0,16598,3,287,0),(2566,0,16598,5,288,0),(2567,0,16622,3,289,0),(2568,0,16622,3,290,0),(2572,0,18580,3,291,0),(2573,0,18580,5,292,0),(2574,0,19759,2,177,0),(2575,0,19759,4,178,0),(2576,0,19759,5,179,0),(2577,0,19760,2,177,0),(2578,0,19760,4,178,0),(2579,0,19760,5,179,0),(2580,0,19761,3,187,0),(2581,0,19761,5,188,0),(2582,0,19766,3,190,0),(2583,0,19766,5,191,0),(2584,0,19767,3,193,0),(2585,0,19767,5,194,0),(2586,0,19921,2,183,0),(2588,0,19922,3,184,0),(2589,0,19922,5,185,0),(2590,0,20209,4,144,0),(2591,0,20209,5,145,0),(2592,0,20210,4,142,0),(2593,0,20210,5,143,0),(2594,0,20211,4,149,0),(2595,0,20211,5,150,0),(2596,0,20212,4,156,0),(2597,0,20212,5,157,0),(2598,0,20213,4,158,0),(2599,0,20213,5,159,0),(2600,0,20314,2,135,0),(2601,0,20314,4,136,0),(2602,0,20314,5,137,0),(2603,0,20315,3,137,0),(2604,0,20315,5,138,0),(2607,0,20494,2,209,0),(2608,0,20494,4,210,0),(2609,0,20494,5,211,0),(2610,0,20494,5,220,0),(2612,0,20495,2,209,0),(2613,0,20495,4,210,0),(2614,0,20495,5,211,0),(2615,0,20495,5,224,0),(2616,0,21059,3,54,0),(2617,0,21059,4,55,0),(2618,0,21059,5,56,0),(2619,0,21071,2,135,0),(2620,0,21071,4,136,0),(2621,0,21071,5,137,0),(2622,0,21718,1,283,0),(2623,0,21718,5,284,0),(2624,0,22536,5,235,0),(2629,0,22552,4,236,0),(2630,0,22552,5,237,0),(2631,0,22578,2,240,0),(2632,0,22578,4,241,0),(2633,0,22578,5,242,0),(2634,0,22806,1,50,0),(2635,0,22806,3,51,0),(2636,0,22806,5,52,0),(2637,0,22807,1,50,0),(2638,0,22807,3,51,0),(2639,0,22807,5,52,0),(2640,0,22808,1,50,0),(2641,0,22808,3,51,0),(2642,0,22808,5,52,0),(2643,0,22809,1,50,0),(2644,0,22809,3,51,0),(2645,0,22809,5,52,0),(2646,0,23566,4,163,0),(2647,0,23566,5,164,0),(2648,0,23606,4,163,0),(2649,0,23606,5,164,0),(2650,0,23618,1,161,0),(2651,0,23618,3,162,0),(2652,0,23618,4,163,0),(2653,0,23618,5,164,0),(2654,0,23950,2,217,0),(2655,0,23950,4,218,0),(2656,0,24241,2,165,0),(2657,0,24241,4,166,0),(2658,0,24241,5,167,0),(2662,0,24270,3,279,0),(2663,0,24270,5,281,0),(2664,0,24562,1,208,0),(2665,0,24624,3,280,0),(2666,0,24624,5,281,0),(2671,0,24764,4,214,0),(2672,0,24764,5,215,0),(2673,0,25718,4,151,0),(2674,0,25718,5,152,0),(2675,0,25719,2,146,0),(2676,0,25719,4,147,0),(2677,0,25739,1,204,0),(2678,0,25739,4,205,0),(2679,0,25739,5,207,0),(2680,0,25810,4,205,0),(2681,0,25810,5,207,0),(2682,0,25811,4,205,0),(2683,0,25811,5,207,0),(2684,0,25863,1,282,0),(2685,0,25863,3,283,0),(2686,0,25863,5,284,0),(2689,0,28073,1,160,0),(2690,12,0,1,13,0),(2691,0,3449,4,13,0),(2692,0,3455,3,13,0),(2693,0,3453,3,13,0),(2694,0,3327,4,13,0),(2695,177,0,1,184,0),(2696,201,0,1,202,0),(2697,13,0,1,202,0),(2698,0,3454,4,202,0),(2699,0,3452,4,202,0),(2700,218,0,1,219,0),(2701,0,23950,5,219,0),(2702,0,3354,5,219,0),(2703,360,0,1,361,0),(2704,288,0,1,361,0),(2705,0,3341,4,361,0),(2706,42,0,1,362,0),(2707,47,0,1,362,0),(2708,114,0,1,362,0),(2709,0,3329,4,362,0),(2710,362,0,1,363,0),(2711,210,0,1,363,0),(2712,15,0,1,363,0),(2713,363,0,1,364,0),(2715,230,0,1,364,0),(2716,121,0,1,364,0),(2717,0,3333,3,364,0),(2718,0,12305,5,164,0),(2719,0,11566,3,62,0),(2720,0,11566,5,63,0),(2721,178,0,1,179,0),(2722,90,0,1,88,0),(2723,92,0,1,88,0),(2724,0,3416,5,57,0),(2725,0,3425,4,57,0),(2726,0,3420,2,57,0),(2728,213,0,1,237,0),(2729,0,3316,5,74,0),(2730,0,3316,5,81,0),(2731,0,3316,5,88,0),(2732,0,3316,5,95,0),(2733,0,3316,5,102,0),(2734,0,3316,5,109,0),(2735,0,16594,5,292,0),(2736,0,16597,5,292,0),(2737,0,16595,5,292,0),(2738,0,19921,5,185,0),(2739,0,3427,5,188,0),(2740,0,3433,5,191,0),(2741,0,3434,5,194,0),(2742,0,3387,3,271,0),(2743,0,24625,3,272,0),(2744,0,24268,3,272,0),(2745,0,24625,5,273,0),(2746,0,24268,5,273,0),(2747,0,3438,3,240,0),(2748,0,3438,5,241,0),(2749,266,0,1,241,0),(2750,262,0,1,241,0),(2751,267,0,1,242,0),(2752,263,0,1,242,0),(2753,240,0,1,243,0),(2754,0,3410,3,243,0),(2755,0,22578,4,244,0),(2756,0,12189,4,244,0),(2757,0,3410,4,244,0),(2758,0,22578,5,245,0),(2759,0,3410,5,245,0),(2761,0,3410,3,250,0),(2762,0,22578,4,251,0),(2763,0,3410,4,251,0),(2764,251,0,1,253,0),(2765,0,22578,5,253,0),(2766,0,3410,5,253,0),(2767,0,12196,2,259,0),(2768,0,12196,4,260,0),(2769,263,0,1,260,0),(2770,0,12196,5,261,0),(2771,265,0,1,261,0),(2772,269,0,1,261,0),(2774,0,12191,4,263,0),(2775,0,12190,4,263,0),(2776,0,12188,4,263,0),(2778,0,12195,5,264,0),(2779,0,12193,5,264,0),(2780,260,0,1,266,0),(2781,0,12183,4,267,0),(2782,0,12182,4,267,0),(2784,0,12186,5,268,0),(2785,0,12185,5,268,0),(2786,0,12184,5,268,0),(2789,15,0,1,303,0),(2790,0,3343,1,303,0),(2791,259,0,1,304,0),(2792,0,3335,3,304,0),(2794,259,0,1,322,0),(2795,259,0,1,340,0),(2796,259,0,1,358,0),(2797,16,0,1,334,0),(2798,186,0,1,313,0),(2799,177,0,1,314,0),(2800,286,0,1,289,0),(2801,53,0,1,314,0),(2802,54,0,1,315,0),(2803,54,0,1,312,0),(2804,53,0,1,311,0),(2805,53,0,1,347,0),(2806,54,0,1,348,0),(2807,53,0,1,350,0),(2808,54,0,1,351,0),(2809,53,0,1,326,0),(2810,54,0,1,327,0),(2811,0,12192,4,263,0),(2813,0,12187,4,266,0),(2815,0,12186,3,265,0),(2816,0,12185,3,265,0),(2817,0,12194,4,267,0),(2818,0,12181,4,267,0),(2819,0,12187,5,268,0),(3051,0,3393,4,36,0),(3052,0,3386,5,250,0),(3053,0,22578,2,250,0),(3054,0,3328,3,335,0),(3055,233,0,1,234,0),(3056,161,0,1,333,0),(3057,162,0,1,334,0);

/*Table structure for table `dgmAttributeTypes` */

DROP TABLE IF EXISTS `dgmAttributeTypes`;

CREATE TABLE `dgmAttributeTypes` (
  `attributeID` int(10) unsigned NOT NULL default '0',
  `attributeName` varchar(100) default NULL,
  `attributeCategory` int(10) unsigned default NULL,
  `description` varchar(1000) default NULL,
  `maxAttributeID` int(10) unsigned default NULL,
  `attributeIdx` int(10) unsigned default NULL,
  `graphicID` int(10) unsigned default NULL,
  `chargeRechargeTimeID` int(10) unsigned default NULL,
  `defaultValue` double default NULL,
  `published` int(10) unsigned default NULL,
  `displayName` varchar(100) default NULL,
  `unitID` int(10) unsigned default NULL,
  `stackable` int(10) unsigned default NULL,
  `highIsGood` int(10) unsigned default NULL,
  `categoryID` int(10) unsigned default NULL,
  PRIMARY KEY  (`attributeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `dgmAttributeTypes` */

insert  into `dgmAttributeTypes`(`attributeID`,`attributeName`,`attributeCategory`,`description`,`maxAttributeID`,`attributeIdx`,`graphicID`,`chargeRechargeTimeID`,`defaultValue`,`published`,`displayName`,`unitID`,`stackable`,`highIsGood`,`categoryID`) values (2,'isOnline',0,'Boolean to store status of online effect',NULL,1,NULL,NULL,0,0,'isOnline',NULL,1,1,9),(3,'damage',1,'current damage dealt to module',9,2,NULL,NULL,0,1,'Damage',NULL,1,1,7),(4,'mass',9,'Integer that describes the types mass',NULL,NULL,409,NULL,0,1,'Mass',2,0,1,4),(6,'capacitorNeed',5,'The amount of charge used from the capacitor for a module activation.',NULL,NULL,1400,NULL,0,1,'activation cost',114,1,1,5),(8,'minRange',4,'tbd',NULL,NULL,1391,NULL,0,0,'minRange',NULL,1,1,9),(9,'hp',4,'The maximum hitpoints of an object.',NULL,NULL,408,NULL,0,0,'hp',113,1,1,4),(11,'powerOutput',4,'power output of power core',NULL,NULL,1400,NULL,0,1,'powergrid Output',107,1,1,1),(12,'lowSlots',4,'The number of low power slots on the ship.',NULL,NULL,295,NULL,0,1,'Low Slots',122,1,1,1),(13,'medSlots',4,'tbd',NULL,NULL,294,NULL,0,1,'Med Slots',122,1,1,1),(14,'hiSlots',4,'tbd',NULL,NULL,293,NULL,0,1,'High Slots',122,1,1,1),(15,'powerLoad',4,'Current load of power core',NULL,NULL,1400,NULL,0,1,'Powerload',107,1,1,7),(18,'charge',6,'charge of module',482,3,1668,55,0,0,'charge',114,1,1,9),(19,'powerToSpeed',4,'tbd',NULL,NULL,NULL,NULL,0,0,'powerToSpeed',NULL,1,1,9),(20,'speedFactor',5,'Factor by which topspeed increases.',NULL,NULL,1389,NULL,1,1,'Max Velocity Bonus',124,0,1,7),(21,'warpFactor',5,'tbd instance param',NULL,NULL,NULL,NULL,0,0,'warpFactor',NULL,1,1,7),(29,'warpInhibitor',4,'tbd',NULL,NULL,NULL,NULL,0,0,'warpInhibitor',NULL,1,1,9),(30,'power',4,'current power need',NULL,NULL,1400,NULL,0,1,'powergrid usage',107,1,1,1),(31,'maxArmor',4,'The number of hit points this module can take  ',NULL,NULL,1383,NULL,0,0,'maxArmor',NULL,1,1,9),(32,'breakPoint',4,'The number of hit points when this module goes offline  ',NULL,NULL,NULL,NULL,0,0,'breakPoint',NULL,1,1,9),(37,'maxVelocity',4,'Maximum velocity of ship',NULL,NULL,1389,NULL,0,1,'Max Velocity',11,0,1,4),(38,'capacity',9,'The cargo space allowed',NULL,NULL,71,NULL,0,1,'Capacity',9,1,1,4),(39,'damageHP',4,'The damage this weapon deals',NULL,NULL,NULL,NULL,0,1,'Damage Repaired Bonus',105,1,1,7),(47,'slots',4,'The number of slots this module requires.  Only used for launchers, bays and turrets.',NULL,NULL,NULL,NULL,1,0,'slots occupied',NULL,1,1,9),(48,'cpuOutput',4,'CPU output of ship',NULL,NULL,1405,NULL,0,1,'CPU Output',106,1,1,1),(49,'cpuLoad',4,'CPU load of ship',NULL,NULL,1405,NULL,0,1,'CPU Load',106,1,1,9),(50,'cpu',4,'CPU need of module',NULL,NULL,1405,NULL,0,1,'CPU usage',106,1,1,1),(51,'speed',4,'Time in milliseconds between possible activations',NULL,NULL,1397,NULL,0,1,'Rate of fire',101,0,0,7),(52,'damageResistance',5,'Substracted before damage application.',NULL,NULL,NULL,NULL,0,0,'damageResistance',NULL,1,1,9),(54,'maxRange',4,'Distance below which range does not affect the to-hit equation.',NULL,NULL,1391,NULL,0,1,'Optimal Range',1,0,1,6),(55,'rechargeRate',5,'Amount of time taken to fully recharge the capacitor.',NULL,NULL,1392,NULL,0,1,'Recharge time',101,1,1,5),(56,'chargeRate',4,'Number of charges consumed per activation',NULL,NULL,1397,NULL,1,1,'Charge Rate',NULL,1,1,7),(61,'targetModule',4,'GroupID of module targeted by this weapon',NULL,NULL,NULL,NULL,0,0,'targetModule',NULL,1,1,9),(63,'accuracyBonus',5,'Something to do with accuracy.',NULL,NULL,1399,NULL,0,0,'accuracyBonus',NULL,1,1,9),(64,'damageMultiplier',5,'Damage multiplier.',NULL,NULL,1432,NULL,1,1,'Damage Modifier',104,0,1,7),(65,'armorBonus',4,'HP bonus to armor.',NULL,NULL,1383,NULL,0,0,'armorBonus',NULL,1,1,9),(66,'durationBonus',5,'Bonus to duration.',NULL,NULL,1392,NULL,0,1,'Duration Bonus',105,1,1,7),(67,'capacitorBonus',4,'Extra batteries to add capacitor.',NULL,NULL,1400,NULL,0,1,'Capacitor Bonus',114,1,1,5),(68,'shieldBonus',5,'Bonus to shield.',NULL,NULL,1384,NULL,0,1,'shield Bonus',113,0,1,2),(69,'rateBonus',5,'Bonus to rate/conversion ratio.',NULL,NULL,1397,NULL,0,0,'rateBonus',NULL,1,1,9),(70,'agility',5,'The agility of the object.',NULL,NULL,1401,NULL,0,1,'Inertia Modifier',NULL,0,1,4),(72,'capacityBonus',4,'Bonus to capacity (shield at least).',NULL,NULL,69,NULL,0,1,'Shield HP bonus',113,1,1,2),(73,'duration',5,'Length of activation time.',NULL,NULL,1392,NULL,0,1,'Activation time / duration',101,1,1,7),(75,'hpToCapacity',5,'DO NOT MESS WITH. How many hp are in one capacity unit',NULL,NULL,NULL,NULL,1,0,'hpToCapacity',NULL,1,1,9),(76,'maxTargetRange',5,'Maximum range at which the scanner can lock a target.',797,NULL,1391,NULL,0,1,'Maximum Targeting Range',1,0,1,6),(77,'miningAmount',4,'How much ore gets mined',NULL,NULL,NULL,NULL,0,1,'Mining amount',9,1,1,7),(79,'scanSpeed',4,'scanning speed in milliseconds',NULL,NULL,74,NULL,0,0,'Targeting Speed',101,0,0,9),(80,'speedBonus',4,'Amount to increase the maximum speed by.',NULL,NULL,1389,NULL,0,1,'Speed Bonus',11,1,1,7),(81,'hpFactor',5,'Factor to modify the hp by.',NULL,NULL,NULL,NULL,0,0,'hpFactor',NULL,1,1,9),(82,'structureBonus',4,'Modifier for the maximum structural strength.',NULL,NULL,NULL,NULL,0,0,'structureBonus',NULL,1,1,9),(83,'structureDamageAmount',4,'An amount to modify the structural damage by.',NULL,NULL,80,NULL,0,1,'Structure hp Repaired',113,1,1,7),(84,'armorDamageAmount',4,'An amount to modify the armor damage by.',NULL,NULL,80,NULL,0,1,'Armor hp Repaired',113,0,1,7),(87,'shieldTransferRange',4,'Maximum range for use of a shield transfer.',NULL,NULL,1391,NULL,0,1,'shield Transfer Range',1,1,1,2),(88,'shieldDrainAmount',4,'Amount to drain from shield.',NULL,NULL,1384,NULL,0,0,'shieldDrainAmount',NULL,1,1,9),(89,'shieldDrainRange',4,'Maximum range shield can be drained at.',NULL,NULL,NULL,NULL,0,0,'shieldDrainRange',NULL,1,1,9),(90,'powerTransferAmount',5,'Amount of power to transfer.',NULL,NULL,1033,NULL,0,1,'Energy transfer amount',120,1,1,7),(91,'powerTransferRange',5,'Maximum range to transfer power from.',NULL,NULL,1391,NULL,0,1,'Transfer range',1,1,1,7),(92,'kineticDampeningFieldStrength',4,'The strength of the kinetic dampening field.  If high may nullify projectiles.',NULL,NULL,NULL,NULL,0,0,'kineticDampeningFieldStrength',NULL,1,1,9),(93,'kineticDampeningFieldBonus',4,'Amount to adjust a kinetic dampening field by.',NULL,NULL,NULL,NULL,0,0,'kineticDampeningFieldBonus',NULL,1,1,9),(95,'energyReflectionStrength',4,'The strength of the energy reflection field. If high may reflect energy at shooter.',NULL,NULL,NULL,NULL,0,0,'energyReflectionStrength',NULL,1,1,9),(96,'energyReflectionBonus',4,'Amount to adjust a energy reflection strength by.',NULL,NULL,NULL,NULL,0,0,'energyReflectionBonus',NULL,1,1,9),(97,'energyDestabilizationAmount',4,'An amount to modify the power of the target by.',NULL,NULL,1400,NULL,0,1,'Energy neutralized',114,1,1,7),(98,'energyDestabilizationRange',4,'Range of energy destabilizer.',NULL,NULL,1391,NULL,0,1,'Max Neutralization Range',1,1,1,7),(99,'empFieldRange',4,'Range of broadcasted EMP field.',NULL,NULL,1391,NULL,0,1,'Area of effect',1,1,1,7),(101,'launcherSlotsLeft',4,'The number of remaining unused launcher slots.',NULL,NULL,412,NULL,0,1,'Launcher hardpoints',NULL,1,1,1),(102,'turretSlotsLeft',4,'Remaining number of unused turret slots on the ship.',NULL,NULL,414,NULL,0,1,'Turret hardpoints',NULL,1,1,1),(103,'warpScrambleRange',4,'Maximum range objects can be warp scrambled from.',NULL,NULL,1391,NULL,0,1,'Warp Scramble Range',1,1,1,7),(104,'warpScrambleStatus',4,'Warp ability of a ship.  If greater than zero than the ship cannot warp.',NULL,NULL,NULL,NULL,0,1,'Warp Scramble Status',NULL,1,1,7),(105,'warpScrambleStrength',4,'Amount to modify ships warp scramble status by.',NULL,NULL,111,NULL,0,1,'Warp Scramble Strength',NULL,1,1,7),(106,'droneBaySlotsLeft',4,'The remaining amount of unused drone bay slots on the ship.',NULL,NULL,139,NULL,0,1,'Dronebay hardpoints',NULL,1,1,10),(107,'explosionRange',4,'Range in meters of explosion effect area.',NULL,NULL,1390,NULL,0,0,'Explosion radius',1,1,1,9),(108,'detonationRange',4,'the range in meters for an object to trigger detonation of missile. (own ship excluded)',NULL,NULL,NULL,NULL,0,0,'Detonation proximity',1,1,1,9),(109,'kineticDamageResonance',5,'damage multiplier vs. kinetic damagers.',NULL,NULL,1393,NULL,1,1,'Kinetic dmg resistance',108,1,1,7),(110,'thermalDamageResonance',5,'damage multiplier vs. thermal.',NULL,NULL,1394,NULL,1,1,'Thermal dmg resistance',108,1,1,7),(111,'explosiveDamageResonance',5,'damage multiplier vs. explosive damagers.',NULL,NULL,1395,NULL,1,1,'Explosive dmg resistance',108,1,1,7),(112,'energyDamageAbsorptionFactor',5,'Percentage of energy damage that is absorbed as available power.',NULL,NULL,1400,NULL,0,0,'energyDamageAbsorptionFactor',NULL,1,1,9),(113,'emDamageResonance',5,'Electro magnetic damage multiplier for shield and armor. Represented as \"% Resistance\" in the UI.',NULL,NULL,1396,NULL,1,1,'EM dmg resistance',108,1,1,7),(114,'emDamage',8,'EM damage done.',NULL,NULL,1388,113,0,1,'EM damage',113,1,1,7),(116,'explosiveDamage',8,'Explosive damage done.',NULL,NULL,1387,111,0,1,'explosive damage',113,1,1,7),(117,'kineticDamage',8,'Kinetic damage done.',NULL,NULL,1385,109,0,1,'Kinetic damage',113,1,1,7),(118,'thermalDamage',8,'Thermal damage done.',NULL,NULL,1386,110,0,1,'Thermal damage',113,1,1,7),(120,'weaponRangeMultiplier',5,'Multiplier of range the relevant weapon.',NULL,NULL,1391,NULL,1,1,'Range bonus',109,1,1,7),(121,'powerOutputBonus',4,'Bonus to output of power core.',NULL,NULL,1384,NULL,0,1,'Power Output Bonus',107,1,1,7),(122,'armorPiercingChance',5,'Chance of piercing the armor.',NULL,NULL,1383,NULL,0,0,'armorPiercingChance',NULL,1,1,9),(123,'shieldPiercingChance',5,'Chance of piercing the shield.',NULL,NULL,NULL,NULL,0,0,'shieldPiercingChance',NULL,1,1,9),(124,'mainColor',7,'The main color of a ship type.',NULL,NULL,NULL,NULL,0,0,'mainColor',NULL,1,1,9),(125,'shipScanRange',4,'Maximum range that something can be ship scanned from.',NULL,NULL,1391,NULL,0,1,'Ship scanning range',1,1,1,7),(126,'cargoScanRange',4,'Maximum range the cargo of a ship can be scanned from.',NULL,NULL,1391,NULL,0,1,'Cargoscan range',1,1,1,7),(127,'ammoLoaded',11,'A temporary attribute for projectile/hybrid weapons to indicate which charges they have loaded when created in newbie ships ala ammo.',NULL,NULL,NULL,NULL,0,0,'Default ammo loaded',NULL,1,1,7),(128,'chargeSize',4,'The size of the charges that can fit in the turret/whatever.',NULL,NULL,1666,NULL,0,1,'Charge size',117,1,1,7),(129,'maxPassengers',4,'Specifies the maximum numbers of passengers that the ship can have',NULL,NULL,413,NULL,0,0,'maxPassengers',NULL,1,1,9),(130,'thermalDamageResonanceMultiplier',5,'Multipler to adjust the thermal damage resonance of an object.',NULL,NULL,1394,NULL,1,1,'Thermal dmg resistance bonus',111,1,1,7),(131,'kineticDamageResonanceMultiplier',5,'Multiplier to the kinetic damage resonance of something.',NULL,NULL,1393,NULL,1,1,'Kinetic dmg resistance bonus',111,1,1,7),(132,'explosiveDamageResonanceMultiplier',5,'Multiplier to the explosive damage resistance of something.',NULL,NULL,1395,NULL,1,1,'Explosive dmg resistance bonus',111,1,1,7),(133,'emDamageResonanceMultiplier',5,'Multiplier to the EM damage resonance of something.',NULL,NULL,1396,NULL,1,1,'EM dmg resistance bonus',111,0,0,7),(134,'shieldRechargeRateMultiplier',5,'Multiplier to a recharge rate time.',NULL,NULL,1392,NULL,1,1,'Shield recharge rate bonus',111,1,1,2),(135,'moduleSize',4,'The size of the module, 1 = small, 2 = medium, 3 = large.  Used for turrets and projectile weapons but will work for any module that defines it.',NULL,NULL,NULL,NULL,0,0,'moduleSize',NULL,1,1,9),(136,'uniformity',5,'This number is deducted from the %chance of the seeping to armor, to slow seep of damage through shield.',NULL,NULL,NULL,NULL,0,0,'uniformity',NULL,1,1,9),(137,'launcherGroup',12,'One of the groups of launcher this charge can be loaded into.',NULL,NULL,NULL,NULL,0,1,'Used with (launchergroup)',115,1,1,7),(138,'emDamageBonus',4,'+/- amount to the EM damage done.',NULL,NULL,1388,NULL,0,1,'EM dmg bonus',113,1,1,7),(139,'explosiveDamageBonus',4,'+/- amount to the explosive damage done.',NULL,NULL,1387,NULL,0,1,'Explosive dmg bonus',113,1,1,7),(140,'kineticDamageBonus',4,'+/- amount to the kinetic damage done.',NULL,NULL,1385,NULL,0,1,'Kinetic dmg bonus',113,1,1,7),(141,'thermalDamageBonus',4,'+/- bonus to the thermal damage done.',NULL,NULL,1386,NULL,0,1,'Thermal dmg bonus',113,1,1,7),(142,'ecmBurstRange',4,'Range that an ECM burst has an effect within.',NULL,NULL,1390,NULL,0,1,'ECM Burst Radius',1,1,1,7),(143,'targetHostileRange',4,'Range of the automated targeting systems hostile targeting area.',NULL,NULL,NULL,NULL,0,1,'Targeting range',1,1,1,7),(144,'capacitorRechargeRateMultiplier',5,'Multiplier to the capacitors recharge rate.',NULL,NULL,1400,NULL,1,1,'Capacitor recharge rate bonus',111,1,1,5),(145,'powerOutputMultiplier',5,'Multipier to power core output.',NULL,NULL,70,NULL,1,1,'Powergrid bonus',109,1,1,7),(146,'shieldCapacityMultiplier',5,'Multiplier to the capacity of a shield.',NULL,NULL,1384,NULL,1,1,'Shield HP bonus',109,1,1,2),(147,'capacitorCapacityMultiplier',5,'',NULL,NULL,1400,NULL,1,1,'Capacitor bonus',109,1,1,5),(148,'armorHPMultiplier',5,'Multiplier to the HP of a ships armor module.',NULL,NULL,1383,NULL,1,1,'Armor HP bonus',109,1,1,3),(149,'cargoCapacityMultiplier',5,'Multiplier to the amount of cargo capacity for a ship.',NULL,NULL,71,NULL,1,1,'Cargo capacity bonus',109,1,1,4),(150,'structureHPMultiplier',5,'Multiplier to the ships structural HP.',NULL,NULL,67,NULL,1,1,'Structure HP bonus',109,1,1,7),(151,'agilityBonus',5,'Bonus to the agility for a ship.',NULL,NULL,1401,NULL,0,1,'Agility bonus',105,1,1,7),(152,'maxPassengersBonus',4,'+/- a number to the max passengers.',NULL,NULL,NULL,NULL,0,1,'Max Passengers Bonus',NULL,1,1,7),(153,'warpCapacitorNeed',5,'The power cost to warp per one kg per AU (floats do not have the resolution for meters).',NULL,NULL,NULL,NULL,0,0,'warpCapacitorNeed',NULL,1,1,9),(154,'proximityRange',4,'The distance at which to react when relevant objects come within range.',NULL,NULL,1390,NULL,0,1,'Activation proximity',1,1,1,7),(156,'incapacitationRatio',5,'The hull damage proportion at which an entity becomes incapacitated.',NULL,NULL,NULL,NULL,0,0,'incapacitationRatio',NULL,1,1,9),(157,'orbitRange',4,'The range at which this thing does it thing.',NULL,NULL,NULL,NULL,0,0,'orbitRange',NULL,1,1,9),(158,'falloff',5,'distance from maximum range at which accuracy has fallen by half',NULL,NULL,1399,NULL,1,1,'Accuracy falloff ',1,1,1,7),(160,'trackingSpeed',5,'Angular speed of turret rotation in radians/seconds',NULL,NULL,1398,NULL,0,1,'Trackingspeed / Accuracy',112,0,1,6),(161,'volume',9,'Volume of things in cubic meters',NULL,NULL,67,NULL,0,1,'Volume',9,1,1,4),(162,'radius',9,'Radius of an object in meters',NULL,NULL,1390,NULL,0,0,'radius',NULL,1,1,9),(163,'dummyDuration',4,'Where you want an effect to finish instantly.',NULL,NULL,NULL,NULL,0,0,'dummyDuration',NULL,1,1,9),(164,'charisma',4,'The charisma of a character.',NULL,4,1378,NULL,0,1,'Charisma',120,1,1,7),(165,'intelligence',4,'The intelligence of a character.',NULL,8,1380,NULL,0,1,'Intelligence',120,1,1,7),(166,'memory',4,'The memory of a character.',NULL,7,1381,NULL,0,1,'Memory',120,1,1,7),(167,'perception',4,'The perception of a character.',NULL,6,1382,NULL,0,1,'Perception',120,1,1,9),(168,'willpower',4,'The willpower of a character.',NULL,5,1379,NULL,0,1,'Willpower',120,1,1,7),(169,'agilityMultiplier',5,'Multiplier to the agility of an object.',NULL,NULL,1401,NULL,0,1,'Inertia Modifier',121,1,1,7),(170,'customCharismaBonus',4,'Bonus to the charisma of a character specified by the player in character creation.',NULL,NULL,1378,NULL,0,0,'customCharismaBonus',NULL,1,1,9),(171,'customWillpowerBonus',4,'Bonus to the willpower of a character specified by the player in character creation.',NULL,NULL,1379,NULL,0,0,'customWillpowerBonus',NULL,1,1,9),(172,'customPerceptionBonus',4,'Bonus to the perception of a character specified by the player in character creation.',NULL,NULL,1382,NULL,0,0,'customPerceptionBonus',NULL,1,1,9),(173,'customMemoryBonus',4,'Bonus to the memory of a character specified by the player in character creation.',NULL,NULL,1381,NULL,0,0,'customMemoryBonus',NULL,1,1,9),(174,'customIntelligenceBonus',4,'Bonus to the intelligence of a character specified by the player in character creation.',NULL,NULL,1380,NULL,0,0,'customIntelligenceBonus',NULL,1,1,9),(175,'charismaBonus',4,'+/- bonus to the charisma of a character.',NULL,NULL,1378,NULL,0,1,'Charisma Modifier',120,1,1,7),(176,'intelligenceBonus',4,'+/- bonus to the intelligence of a character.',NULL,NULL,1380,NULL,0,1,'Intelligence Modifier',120,1,1,7),(177,'memoryBonus',4,'+/- bonus to the memory of a character.',NULL,NULL,1381,NULL,0,1,'Memory Modifier',120,1,1,7),(178,'perceptionBonus',4,'+/- bonus to the perception of a character.',NULL,NULL,1382,NULL,0,1,'Perception Modifier',120,1,1,7),(179,'willpowerBonus',4,'+/- bonus to the willpower of a character.',NULL,NULL,1379,NULL,0,1,'Willpower Modifier',120,1,1,7),(180,'primaryAttribute',10,'Only refers to another dogma attribute.',NULL,NULL,NULL,NULL,0,1,'Primary attribute',119,1,1,7),(181,'secondaryAttribute',10,'Only refers to another dogma attribute.',NULL,NULL,NULL,NULL,0,1,'Secondary attribute',119,1,1,7),(182,'requiredSkill1',11,'The type ID of the skill that is required.',NULL,NULL,NULL,NULL,0,1,'Primary Skill required',116,1,1,8),(183,'requiredSkill2',11,'The type ID of the skill that is required.',NULL,NULL,NULL,NULL,0,1,'Secondary Skill required',116,1,1,8),(184,'requiredSkill3',11,'The type ID of the skill that is required.',NULL,NULL,NULL,NULL,0,1,'Tertiary Skill required',116,1,1,8),(185,'attributePoints',4,'The number of attribute points needed to be accrued to learn this skill.',NULL,NULL,NULL,NULL,0,0,'attributePoints',NULL,1,1,9),(186,'warpCapacitorNeedMultiplier',5,'Multiplier to the warping power cost.',NULL,NULL,NULL,NULL,0,0,'warpCapacitorNeedMultiplier',NULL,1,1,9),(187,'repairCostMultiplier',5,'Multiplier to adjust the cost of repairs.',NULL,NULL,NULL,NULL,1,0,'repairCostMultiplier',NULL,1,1,9),(188,'cargoScanResistance',5,'Chance of being able to resist a cargo scan.',NULL,NULL,NULL,NULL,0,0,'cargoScanResistance',NULL,1,1,9),(189,'targetGroup',12,'Restrict activation to this one module group.',NULL,NULL,NULL,NULL,0,0,'targetGroup',NULL,1,1,9),(190,'corporationMemberLimit',4,'The maximum number of members that a CEO can manage within their corporation.',NULL,NULL,NULL,NULL,0,0,'corporationMemberLimit',NULL,1,1,9),(191,'corporationMemberBonus',4,'+/- modifier to the number of members that a CEO can manage within their corporation.',NULL,NULL,NULL,NULL,0,1,'corporation Member Bonus',NULL,1,1,7),(192,'maxLockedTargets',4,'Maximum number of locked targets that the character or their ships electronics can handle at any given time.  Both have individual limits which apply separately.',NULL,NULL,109,NULL,0,1,'Max  Locked Targets',NULL,1,1,6),(193,'maxAttackTargets',4,'The maximum number of their targets that the character can attack at a given time.',NULL,NULL,NULL,NULL,0,0,'maxAttackTargets',NULL,1,1,9),(194,'jammingResistance',5,'The resistance to target jamming.',NULL,NULL,NULL,NULL,0,0,'jammingResistance',NULL,1,1,7),(195,'raceID',9,'The race ID of the type.',NULL,NULL,NULL,NULL,0,0,'raceID',NULL,1,1,9),(196,'manufactureSlotLimit',4,'The maximum amount of manufacture slots that can be used at a time.',NULL,NULL,NULL,NULL,0,0,'manufactureSlotLimit',NULL,1,1,9),(197,'surveyScanRange',4,'Distance from thing to survey.',NULL,NULL,NULL,NULL,0,1,'Surveyscan range',1,1,1,7),(202,'cpuMultiplier',5,'Factor to adjust module cpu need by.',NULL,NULL,1405,NULL,1,1,'CPU Output bonus',109,1,1,1),(203,'miningDurationMultiplier',5,'Factor to scale mining laser durations by.',NULL,NULL,NULL,NULL,0,0,'miningDurationMultiplier',NULL,1,1,9),(204,'speedMultiplier',5,'Typically scales the firing speed of a weapon.  Reducing speed means faster, strangely..',NULL,NULL,1389,NULL,1,1,'rate of fire bonus',111,1,1,7),(205,'accuracyMultiplier',5,'Scales the accuracy of some targeted weapon.',NULL,NULL,1399,NULL,1,0,'accuracyMultiplier',NULL,1,1,9),(207,'miningAmountMultiplier',5,'The factor by which the amount mined by a mining laser is scaled.',NULL,NULL,NULL,NULL,1,1,'Mining Amount Multiplier',NULL,0,1,7),(208,'scanRadarStrength',5,'Radar strength.',NULL,NULL,2031,NULL,0,1,'RADAR Sensor Strength',120,0,1,6),(209,'scanLadarStrength',5,'Ladar strength.',NULL,NULL,2030,NULL,0,1,'LADAR Sensor Strength',120,0,1,6),(210,'scanMagnetometricStrength',5,'Magnetometric strength.',NULL,NULL,2029,NULL,0,1,'Magnetometric Sensor Strength',120,0,1,6),(211,'scanGravimetricStrength',5,'Gravimetric strength.',NULL,NULL,2028,NULL,0,1,'Gravimetric Sensor Strength',120,0,1,6),(212,'missileDamageMultiplier',5,'The characters missile use efficiency, scales the damage missiles do.',NULL,NULL,NULL,NULL,1,1,'Missile Damage Bonus',104,0,1,7),(213,'missileDamageMultiplierBonus',5,'Additional percentage to the characters missile damage multiplier.',NULL,NULL,NULL,NULL,0,1,'Missile Damage Bonus',109,1,1,7),(216,'capacitorNeedMultiplier',5,'Scales the capacitor need for fitted modules.',NULL,NULL,1400,NULL,0,1,'Capacitor Need Multiplier',105,1,1,5),(217,'propulsionGraphicID',4,'The graphicID of the propulsion system.',NULL,NULL,NULL,NULL,0,0,'propulsionGraphicID',NULL,1,1,9),(218,'blueprintResearchTimeMultiplier',5,'Scales the time it takes a character to research a blueprint.',NULL,NULL,1392,NULL,1,0,'blueprintResearchTimeMultiplier',NULL,1,1,9),(219,'manufactureTimeMultiplier',5,'Scales the time it takes to manufacture something.',NULL,NULL,NULL,NULL,1,0,'manufactureTimeMultiplier',NULL,1,1,9),(220,'blueprintResearchTimeMultiplierBonus',5,'Bonus or penalty to the percentage time it takes to research a blueprint.',NULL,NULL,1392,NULL,0,0,'blueprintResearchTimeMultiplierBonus',NULL,1,1,9),(221,'blueprintManufactureTimeMultiplier',5,'Scales the time it takes a character to manufacture a blueprint.',NULL,NULL,1392,NULL,1,0,'blueprintManufactureTimeMultiplier',NULL,1,1,9),(222,'blueprintManufactureTimeMultiplierBonus',5,'Bonus or penalty to the percentage time it takes to manufacture from a blueprint.',NULL,NULL,1392,NULL,0,0,'blueprintManufactureTimeMultiplierBonus',NULL,1,1,9),(223,'charismaSkillTrainingTimeMultiplier',5,'Scales the time it takes to train skills with Charisma as the primary attribute.',NULL,NULL,NULL,NULL,1,0,'charismaSkillTrainingTimeMultiplier',NULL,1,1,9),(224,'intelligenceSkillTrainingTimeMultiplier',5,'Scales the time it takes to train skills with Intelligence as the primary attribute. ',NULL,NULL,NULL,NULL,1,0,'intelligenceSkillTrainingTimeMultiplier',NULL,1,1,9),(225,'memorySkillTrainingTimeMultiplier',5,'Scales the time it takes to train skills with Memory as the primary attribute.',NULL,NULL,NULL,NULL,1,0,'memorySkillTrainingTimeMultiplier',NULL,1,1,9),(226,'perceptionSkillTrainingTimeMultiplier',5,'Scales the time it takes to train skills with Perception as the primary attribute.',NULL,NULL,NULL,NULL,1,0,'perceptionSkillTrainingTimeMultiplier',NULL,1,1,9),(227,'willpowerSkillTrainingTimeMultiplier',5,'Scales the time it takes to train skills with Willpower as the primary attribute.',NULL,NULL,NULL,NULL,1,0,'willpowerSkillTrainingTimeMultiplier',NULL,1,1,9),(228,'charismaSkillTrainingTimeMultiplierBonus',5,'Bonus or penalty to the percentage time it takes to train skills with Charisma as the primary attribute.',NULL,NULL,NULL,NULL,0,0,'charismaSkillTrainingTimeMultiplierBonus',NULL,1,1,9),(229,'intelligenceSkillTrainingTimeMultiplierBonus',5,'Bonus or penalty to the percentage time it takes to train skills with Intelligence as the primary attribute.',NULL,NULL,NULL,NULL,0,0,'intelligenceSkillTrainingTimeMultiplierBonus',NULL,1,1,9),(230,'memorySkillTrainingTimeMultiplierBonus',5,'Bonus or penalty to the percentage time it takes to train skills with Memory as the primary attribute.',NULL,NULL,NULL,NULL,0,0,'memorySkillTrainingTimeMultiplierBonus',NULL,1,1,9),(231,'perceptionSkillTrainingTimeMultiplierBonus',5,'Bonus or penalty to the percentage time it takes to train skills with Perception as the primary attribute.',NULL,NULL,NULL,NULL,0,0,'perceptionSkillTrainingTimeMultiplierBonus',NULL,1,1,9),(232,'willpowerSkillTrainingTimeMultiplierBonus',5,'Bonus or penalty to the percentage time it takes to train skills with Willpower as the primary attribute.',NULL,NULL,NULL,NULL,0,0,'willpowerSkillTrainingTimeMultiplierBonus',NULL,1,1,9),(235,'maxLockedTargetsBonus',4,'Additional amount of locked targets that can be handled.',NULL,NULL,NULL,NULL,0,1,'Max Locked Targets Bonus',NULL,1,1,6),(236,'maxAttackTargetsBonus',4,'Additional amount of attack targets that can be handled.',NULL,NULL,NULL,NULL,0,0,'maxAttackTargetsBonus',NULL,1,1,9),(237,'maxTargetRangeMultiplier',5,'Scales the max target range of a ships electronics.',NULL,NULL,1391,NULL,1,1,'Targeting Range Bonus',109,1,1,6),(238,'scanGravimetricStrengthBonus',5,'+/- modifier to the gravimetric strength of an electronic system.',NULL,NULL,109,NULL,0,1,'Gravimetric Strength',NULL,0,1,7),(239,'scanLadarStrengthBonus',5,'+/- modifier to the ladar strength of an electronic system.',NULL,NULL,109,NULL,0,1,'LADAR Strength',NULL,0,1,7),(240,'scanMagnetometricStrengthBonus',5,'+/- modifier to the magnetometric strength of an electronic system.',NULL,NULL,109,NULL,0,1,'Magnetometric Strength',NULL,0,1,7),(241,'scanRadarStrengthBonus',5,'+/- modifier to the radar strength of an electronic system.',NULL,NULL,109,NULL,0,1,'RADAR Strength',NULL,0,1,7),(242,'scanSpeedMultiplier',5,'Scales the time it takes to lock a target.',NULL,NULL,104,NULL,1,0,'Targeting speed bonus',111,1,1,7),(243,'maxRangeMultiplier',5,'Scales the range at which something can reach.',NULL,NULL,1391,NULL,1,1,'Max Range Multiplier',104,1,1,6),(244,'trackingSpeedMultiplier',5,'Scale the tracking speed of a weapon.',NULL,NULL,1398,NULL,1,1,'Tracking Speed Multiplier',104,1,1,7),(245,'gfxTurretID',4,'Graphic ID of the turrets for drone type ships.',NULL,NULL,NULL,NULL,0,0,'gfxTurretID',NULL,1,1,9),(246,'gfxBoosterID',4,'Graphic ID of the boosters for drone type ships.',NULL,NULL,NULL,NULL,0,0,'gfxBoosterID',NULL,1,1,9),(247,'entityAttackRange',4,'The distance from a target an entity starts using its weapons.',NULL,NULL,1391,NULL,15000,0,'entityAttackRange',NULL,1,1,9),(248,'entityLootValueMin',4,'The minimum value of any given unit of loot dropped by this entity.  Not the minimum value of all the loot, but of any given item dropped.',NULL,NULL,NULL,NULL,0,0,'entityLootValueMin',NULL,1,1,9),(249,'entityLootValueMax',4,'The maximum value of any loot dropped by this entity.  Thats for each unit of any given item of loot, not for the total value of all items of loot dropped.',NULL,NULL,NULL,NULL,0,0,'entityLootValueMax',NULL,1,1,9),(250,'entityLootCountMin',4,'Deprecated. The minimum number of pieces of loot dropped by this entity.',NULL,NULL,NULL,NULL,0,0,'entityLootCountMin',NULL,1,1,9),(251,'entityLootCountMax',4,'The maximum number of pieces of loot dropped by this entity.',NULL,NULL,NULL,NULL,0,0,'entityLootCountMax',NULL,1,1,9),(252,'entitySecurityStatusKillBonus',5,'How much security status is modified by for killing this entity.  Depending on the entity, this may be a positive or negative amount.',NULL,NULL,NULL,NULL,0,1,'Security Status Kill Amount',NULL,1,1,7),(253,'entitySecurityStatusAggressionBonus',5,'The amount of security status lost of aggressing agaisnt this entity first.',NULL,NULL,NULL,NULL,0,0,'entitySecurityStatusAggressionBonus',NULL,1,1,9),(254,'minLootCount',4,'Minimum loot count that an entity can take from the NPC corp loot resource',NULL,NULL,NULL,NULL,1,0,'minLootCount',NULL,1,1,9),(256,'maxLootCount',4,'Maximum loot count that an entity can take from the NPC corp loot resource',NULL,NULL,NULL,NULL,0,0,'maxLootCount',NULL,1,1,9),(257,'entityFollowRange',4,'The range in m that the entity follows it\'s target.',NULL,NULL,NULL,NULL,0,0,'followRange',NULL,1,1,9),(258,'minLootValue',4,'Minimum value of each resource the entity is able to take as loot.',NULL,NULL,NULL,NULL,0,0,'minLootValue',NULL,1,1,9),(259,'maxLootValue',4,'Maximum value of each resource the entity is able to take as loot.',NULL,NULL,NULL,NULL,0,0,'maxLootValue',NULL,1,1,9),(260,'attackRange',4,'The range in m when the entity starts attacking it\'s target.',NULL,NULL,1391,NULL,0,0,'attackRange',NULL,1,1,9),(261,'killStatusModifier',5,'How much the security status changes when this entity is killed.',NULL,NULL,NULL,NULL,0,0,'killStatusModifier',NULL,1,1,9),(262,'attackStatusModifier',5,'How much the security status changes when this entity is attacked.',NULL,NULL,NULL,NULL,0,0,'attackStatusModifier',NULL,1,1,9),(263,'shieldCapacity',5,'Amount of maximum shield HP on the item.',NULL,NULL,1384,NULL,0,1,'Shield Capacity',113,1,1,2),(264,'shieldCharge',6,'DO NOT MESS WITH. Helper attribute for entities, stands in for the shield charge.',263,11,0,479,0,0,'shieldCharge',NULL,1,1,9),(265,'armorHP',4,'The number of hit points on the entities armor.',NULL,NULL,1383,NULL,0,1,'Armor Hitpoints',113,1,1,3),(266,'armorDamage',1,'DO NOT MESS WITH. The amount of damage done to the entities armor hit points.',265,10,0,NULL,0,1,'Armor Damage',NULL,1,1,9),(267,'armorEmDamageResonance',5,'Multiplies EM damage taken by Armor. ',1527,NULL,1396,NULL,1,1,'Armor Em Damage Resistance',108,0,0,3),(268,'armorExplosiveDamageResonance',5,'Multiplies EXPLOSIVE damage taken by Armor. ',1527,NULL,1395,NULL,1,1,'Armor Explosive Damage Resistance',108,0,0,3),(269,'armorKineticDamageResonance',5,'Multiplies KINETIC damage taken by Armor. ',1527,NULL,1393,NULL,1,1,'Armor Kinetic Damage Resistance',108,0,0,3),(270,'armorThermalDamageResonance',5,'Multiplies THERMAL damage taken by Armor. ',1527,NULL,1394,NULL,1,1,'Armor Thermal Damage Resistance',108,0,0,3),(271,'shieldEmDamageResonance',5,'Multiplies EM damage taken by shield',1528,NULL,1396,NULL,1,1,'Shield Em Damage Resistance',108,0,0,2),(272,'shieldExplosiveDamageResonance',5,'Multiplies EXPLOSIVE damage taken by Armor. ',1528,NULL,1395,NULL,1,1,'Shield Explosive Damage Resistance',108,0,0,2),(273,'shieldKineticDamageResonance',5,'Multiplies KINETIC damage taken by Armor. ',1528,NULL,1393,NULL,1,1,'Shield Kinetic Damage Resistance',108,0,0,2),(274,'shieldThermalDamageResonance',5,'Multiplies THERMAL damage taken by Shield. ',1528,NULL,1394,NULL,1,1,'Shield Thermal Damage Resistance',108,0,0,2),(275,'skillTimeConstant',5,'Time constant for skill training',NULL,NULL,1392,NULL,0,1,'Training time multiplier ',104,1,1,7),(276,'skillPoints',1,'Total accumulated points for skill',NULL,9,33,NULL,0,1,'Skillpoints',NULL,1,1,7),(277,'requiredSkill1Level',4,'Required skill level for skill 1',NULL,NULL,NULL,NULL,0,0,'requiredSkill1Level',NULL,1,1,8),(278,'requiredSkill2Level',4,'Required skill level for skill 2',NULL,NULL,NULL,NULL,0,0,'requiredSkill2Level',NULL,1,1,8),(279,'requiredSkill3Level',4,'Required skill level for skill 3',NULL,NULL,NULL,NULL,0,0,'requiredSkill3Level',NULL,1,1,8),(280,'skillLevel',4,'Level of skill',NULL,NULL,33,NULL,0,1,'level',NULL,1,1,7),(281,'explosionDelay',4,'The amount of milliseconds before the object explodes.',NULL,NULL,1392,NULL,60000,1,'Max Flight Time',101,0,1,7),(282,'launcherCapacityMultiplier',5,'Multiplier to the amount of charge storage space in a launcher.',NULL,NULL,0,NULL,1,0,'launcherCapacityMultiplier',104,1,1,9),(283,'droneCapacity',5,'This defines the total capacity of drones allowed in the drone bay of the ship',NULL,NULL,76,NULL,0,1,'Drone Capacity',9,1,1,10),(284,'excludeGangMembers',3,'Indicates whether the modules ranged effects exlude  members of the users gang.',NULL,NULL,0,NULL,0,0,'excludeGangMembers',NULL,1,1,9),(285,'excludeCorporationMembers',3,'Indicates whether the modules ranged effects exlude  members of the users corporation.',NULL,NULL,0,NULL,0,0,'excludeCorporationMembers',NULL,1,1,9),(286,'excludeHostiles',3,'Indicates whether the modules ranged effects exclude ships hostile to the user.',NULL,NULL,0,NULL,0,0,'excludeHostiles',NULL,1,1,9),(287,'kDmgBonus',4,'Autogenerated skill attribute, kDmgBonus',NULL,NULL,0,NULL,0,0,'kDmgBonus',NULL,1,1,9),(288,'shipCPUBonus',4,'Autogenerated skill attribute, shipCPUBonus',NULL,NULL,0,NULL,0,0,'shipCPUBonus',NULL,1,1,9),(289,'turretDamageBonus',4,'Autogenerated skill attribute, turretDamageBonus',NULL,NULL,0,NULL,0,0,'turretDamageBonus',NULL,1,1,9),(290,'skillTurretDmgBonus',4,'Autogenerated skill attribute, skillTurretDmgBonus',NULL,NULL,0,NULL,0,0,'skillTurretDmgBonus',NULL,1,1,9),(291,'cpuskillBonus',4,'Autogenerated skill attribute, CpuskillBonus',NULL,NULL,0,NULL,0,1,'CpuskillBonus',NULL,1,1,7),(292,'damageMultiplierBonus',4,'Autogenerated skill attribute, damageMultiplierBonus',NULL,NULL,1432,NULL,0,1,'Damage Multiplier Bonus',105,1,1,7),(293,'rofBonus',4,'Autogenerated skill attribute, rofBonus',NULL,NULL,1397,NULL,0,1,'Rate Of Fire Bonus',105,1,1,7),(294,'rangeSkillBonus',4,'Autogenerated skill attribute, rangeSkillBonus',NULL,NULL,0,NULL,0,1,'Optimal Range Modifier',121,1,1,7),(295,'abPowerBonus',4,'Autogenerated skill attribute, abPowerBonus',NULL,NULL,1400,NULL,0,0,'abPowerBonus',NULL,1,1,9),(296,'acPowerBonus',4,'Autogenerated skill attribute, acPowerBonus',NULL,NULL,1400,NULL,0,0,'acPowerBonus',NULL,1,1,9),(297,'afPowerBonus',4,'Autogenerated skill attribute, afPowerBonus',NULL,NULL,1400,NULL,0,0,'afPowerBonus',NULL,1,1,9),(298,'atPowerBonus',4,'Autogenerated skill attribute, atPowerBonus',NULL,NULL,0,NULL,0,0,'atPowerBonus',NULL,1,1,9),(299,'cbTRangeBonus',4,'Autogenerated skill attribute, cbTRangeBonus',NULL,NULL,0,NULL,0,0,'cbTRangeBonus',NULL,1,1,9),(300,'ccTRangeBonus',4,'Autogenerated skill attribute, ccTRangeBonus',NULL,NULL,0,NULL,0,0,'ccTRangeBonus',NULL,1,1,9),(301,'cfTRangeBonus',4,'Autogenerated skill attribute, cfTRangeBonus',NULL,NULL,0,NULL,0,0,'cfTRangeBonus',NULL,1,1,9),(302,'ciTRangeBonus',4,'Autogenerated skill attribute, ciTRangeBonus',NULL,NULL,0,NULL,0,0,'ciTRangeBonus',NULL,1,1,9),(303,'aiPowerBonus',4,'Autogenerated skill attribute, aiPowerBonus',NULL,NULL,0,NULL,0,0,'aiPowerBonus',NULL,1,1,9),(304,'ctTRangeBonus',4,'Autogenerated skill attribute, ctTRangeBonus',NULL,NULL,0,NULL,0,0,'ctTRangeBonus',NULL,1,1,9),(305,'gbCpuBonus',4,'Autogenerated skill attribute, gbCpuBonus',NULL,NULL,0,NULL,0,0,'gbCpuBonus',NULL,1,1,9),(306,'maxVelocityBonus',5,'Autogenerated skill attribute, mMaxVelocityBonus',NULL,NULL,1389,NULL,0,1,'Maximum Velocity Penalty',109,1,1,7),(307,'scannerDurationBonus',4,'Autogenerated skill attribute, scannerDurationBonus',NULL,NULL,1392,NULL,0,0,'scannerDurationBonus',NULL,1,1,9),(308,'scanspeedBonus',4,'Autogenerated skill attribute, scanspeedBonus',NULL,NULL,0,NULL,0,1,'Scan Speed Bonus',105,1,1,7),(309,'maxTargetRangeBonus',5,'Bonus to Max Targeting Range',NULL,NULL,1391,NULL,0,1,'Max Targeting Range Bonus',105,1,1,6),(310,'cpuNeedBonus',4,'Autogenerated skill attribute, cpuNeedBonus',NULL,NULL,0,NULL,0,1,'CPU Need Bonus',105,1,1,1),(311,'maxTargetBonus',4,'Autogenerated skill attribute, maxTarget Bonus',NULL,NULL,0,NULL,0,1,'Max Target Bonus',NULL,1,1,6),(312,'durationSkillBonus',4,'Autogenerated skill attribute, DurationBonus',NULL,NULL,1392,NULL,0,1,'Duration Bonus',121,1,1,7),(313,'powerEngineeringOutputBonus',4,'Autogenerated skill attribute, PowerOutputBonus',NULL,NULL,1400,NULL,0,1,'Power Output Bonus',105,1,1,7),(314,'capRechargeBonus',4,'Autogenerated skill attribute, CapRechargeBonus',NULL,NULL,1400,NULL,0,1,'Cap Recharge Time Reduction',105,1,1,5),(315,'velocityBonus',5,'Autogenerated skill attribute, velocityBonus',NULL,NULL,1389,NULL,0,1,'Velocity Modifier',121,1,1,7),(316,'corpMemberBonus',4,'Autogenerated skill attribute, corpMemberBonus',NULL,NULL,0,NULL,0,0,'corpMemberBonus',NULL,1,1,9),(317,'capNeedBonus',4,'Autogenerated skill attribute, capNeedBonus',NULL,NULL,1400,NULL,0,1,'Capacitor Need Bonus',105,1,1,5),(318,'speedFBonus',4,'Autogenerated skill attribute, speedFBonus',NULL,NULL,1389,NULL,0,1,'speed Bonus',105,1,1,7),(319,'warpCapacitorNeedBonus',4,'Autogenerated skill attribute, warpCapacitorNeedBonus',NULL,NULL,0,NULL,0,1,'Warp Capacitor Need Bonus',124,1,1,7),(320,'powerUseBonus',4,'Autogenerated skill attribute, powerUseBonus',NULL,NULL,0,NULL,0,0,'powerUseBonus',NULL,1,1,9),(321,'burstSpeed',4,'',NULL,NULL,1397,NULL,0,1,'Burst Rate Of Fire',3,1,1,7),(322,'burstSpeedMutator',4,'',NULL,NULL,0,NULL,0,1,'Burst Speed Mutator',NULL,1,1,7),(323,'powerNeedBonus',5,'Autogenerated skill attribute, PowerNeedBonus',NULL,NULL,1400,NULL,0,1,'Power Need Bonus',105,1,1,7),(324,'barrageDmgMutator',4,'',NULL,NULL,0,NULL,0,0,'Barrage Damage Bonus',NULL,1,1,9),(325,'barrageFalloffMutator',4,'',NULL,NULL,0,NULL,0,0,'Barrage falloff Penalty',NULL,1,1,9),(326,'barrageDmgMultiplier',4,'',NULL,NULL,0,NULL,0,0,'Barrage damage multiplier',NULL,1,1,9),(327,'hullHpBonus',4,'Autogenerated skill attribute, hullHpBonus',NULL,NULL,408,NULL,0,1,'Hull Hp Bonus',105,1,1,4),(328,'barrageFalloff',4,'',NULL,NULL,0,NULL,75,0,'Barrage Falloff ',NULL,1,1,9),(329,'gangRofBonus',4,'Autogenerated skill attribute, GangRofBonus',NULL,NULL,0,NULL,0,1,'GangRofBonus',NULL,1,1,7),(330,'boosterDuration',4,'Duration of booster, after this duration the booster is destroyed',NULL,NULL,1392,NULL,0,1,'Booster Duration',3,1,1,7),(331,'implantness',4,'Whether an item is an implant or not',NULL,NULL,2224,NULL,0,1,'Implant Slot',NULL,1,1,7),(332,'burstDmg',4,'',NULL,NULL,0,NULL,0,0,'burstDmg',NULL,1,1,9),(333,'burstDmgMutator',3,'',NULL,NULL,0,NULL,0,0,'burstDmgMutator',NULL,1,1,9),(334,'shipPowerBonus',4,'Autogenerated skill attribute, shipPowerBonus',NULL,NULL,0,NULL,0,0,'shipPowerBonus',NULL,1,1,9),(335,'armorHpBonus',4,'Autogenerated skill attribute, armorHpBonus',NULL,NULL,1383,NULL,0,1,'Armor Hp Bonus',105,1,1,3),(336,'uniformityBonus',5,'Autogenerated skill attribute, uniformityBonus',NULL,NULL,0,NULL,0,1,'Uniformity Bonus',104,1,1,7),(337,'shieldCapacityBonus',4,'Autogenerated skill attribute, shieldCapacityBonus',NULL,NULL,1384,NULL,0,1,'Shield Capacity Bonus',121,1,1,2),(338,'rechargeratebonus',4,'Autogenerated skill attribute, rechargeratebonus',NULL,NULL,1392,NULL,0,1,'Rechargerate Bonus',105,1,1,7),(349,'falloffBonus',5,'Autogenerated skill attribute, falloffBonus',NULL,NULL,1399,NULL,0,1,'Falloff Bonus',105,1,1,7),(350,'skillTrainingTimeBonus',4,'Autogenerated skill attribute, skillTrainingTimeBonus',NULL,NULL,0,NULL,0,0,'skillTrainingTimeBonus',NULL,1,1,9),(351,'maxRangeBonus',5,'Autogenerated skill attribute, maxRangeBonus',NULL,NULL,1391,NULL,0,1,'Optimal Range Bonus',105,1,1,6),(352,'maxActiveDrones',4,'The maximum amount of drones that a character can control at a given time.',NULL,NULL,0,NULL,0,0,'maxActiveDrones',NULL,1,1,9),(353,'maxActiveDroneBonus',4,'Autogenerated skill attribute, maxActiveDroneBonus',NULL,NULL,0,NULL,0,1,'Max Active Drone Bonus',NULL,1,1,10),(354,'maxDroneBonus',4,'Autogenerated skill attribute, maxDroneBonus',NULL,NULL,0,NULL,0,0,'maxDroneBonus',NULL,1,1,9),(355,'negotiationPercentage',5,'Percentage of pay from agent ',NULL,NULL,0,NULL,1,1,'Negotiation Multiplyer',NULL,1,1,7),(356,'diplomacyBonus',5,'Bonus to Effective Standing towards Hostile NPC',NULL,NULL,0,NULL,0,1,'Diplomacy Bonus',NULL,1,1,7),(359,'fastTalkPercentage',5,'a percentage multiplyer to sec status recovery',NULL,NULL,0,NULL,100,1,'Fast Talk Percentage',NULL,1,1,7),(360,'connectionsBonus',5,'Bonus to standing towards Friendly npcs',NULL,NULL,0,NULL,0,1,'Connections Bonus',NULL,1,1,9),(361,'criminalConnectionsBonus',5,'a bonus to standing towards npc with negativa security status',NULL,NULL,0,NULL,0,1,'Criminal Connections Bonus',NULL,1,1,7),(362,'socialBonus',5,'Bonus To standing gain towards non CONCORD npcs  ',NULL,NULL,0,NULL,100,1,'Social Bonus',105,1,1,7),(363,'amarrTechTimePercent',4,'Production time multiplier when manufacturing amarr tech   ',NULL,NULL,0,NULL,100,1,'Amarr Tech ',NULL,1,1,9),(364,'minmatarTechTimePercent',4,'Production time multiplier when manufacturing Minmatar tech   ',NULL,NULL,0,NULL,100,1,'Minmatar Tech ',NULL,1,1,7),(365,'gallenteTechTimePercent',4,'Production time multiplier when manufacturing Gallente tech   ',NULL,NULL,0,NULL,0,1,'GallenteTech ',NULL,1,1,7),(366,'caldariTechTimePercent',4,'Production time multiplier when manufacturing caldari tech   ',NULL,NULL,0,NULL,0,1,'Caldari Tech ',NULL,1,1,7),(367,'productionTimePercent',4,'Production time percentage',NULL,NULL,0,NULL,100,1,'Production time percent',NULL,1,1,7),(368,'refiningTimePercentage',4,'Refining speed percentage',NULL,NULL,0,NULL,100,1,'refining pime percentage',NULL,1,1,7),(369,'manufactureCostMultiplier',5,'Manufacturing cost multiplyer',NULL,NULL,0,NULL,1,1,'manufacture cost Multiplyer',NULL,1,1,7),(370,'amarrTechMutator',4,'Autogenerated skill attribute, amarrTechMutator',NULL,NULL,0,NULL,0,0,'amarrTechMutator',NULL,1,1,9),(371,'caldariTechMutator',4,'Autogenerated skill attribute, caldariTechMutator',NULL,NULL,0,NULL,0,0,'caldariTechMutator',NULL,1,1,9),(372,'gallenteTechMutator',4,'Autogenerated skill attribute, gallenteTechMutator',NULL,NULL,0,NULL,0,0,'gallenteTechMutator',NULL,1,1,9),(373,'productionTimeMutator',4,'Autogenerated skill attribute, productionTimeMutator',NULL,NULL,0,NULL,0,0,'productionTimeMutator',NULL,1,1,9),(374,'minmatarTechMutator',4,'Autogenerated skill attribute, minmatarTechMutator',NULL,NULL,0,NULL,0,0,'minmatarTechMutator',NULL,1,1,9),(375,'productionCostMutator',4,'Autogenerated skill attribute, productionCostMutator',NULL,NULL,0,NULL,0,0,'productionCostMutator',NULL,1,1,9),(376,'refiningTimePercent',4,'Refining time Multiplier',NULL,NULL,0,NULL,100,1,'Refining time Multiplier',NULL,1,1,7),(377,'refiningTimeMutator',4,'Autogenerated skill attribute, refiningTimeMutator',NULL,NULL,0,NULL,0,0,'refiningTimeMutator',NULL,1,1,9),(378,'refiningYieldPercentage',5,'Refining yield percentage',NULL,NULL,0,NULL,0,1,'Refining yield percentage',NULL,1,1,7),(379,'refiningYieldMutator',4,'Autogenerated skill attribute, refiningYieldMutator',NULL,NULL,0,NULL,0,1,'Refining Yield Mutator',105,1,1,7),(380,'maxActiveFactory',4,'Max active factories that a player can operate ',NULL,NULL,0,NULL,0,1,'Max active factory',NULL,1,1,7),(383,'maxActiveFactories',4,'Max active factories',NULL,NULL,0,NULL,0,1,'Max active factories',NULL,1,1,7),(384,'maxResearchGangSize',4,'The max numbers of scientists that can work on CSO´s research project.',NULL,NULL,0,NULL,0,1,'Max research gang size',NULL,1,1,7),(385,'manufacturingTimeResearchSpeed',5,'Research speed ',NULL,NULL,0,NULL,1,1,'Production time research speed',NULL,1,1,7),(386,'researchCostPercent',4,'Research cost percent',NULL,NULL,0,NULL,100,1,'Research cost percent',NULL,1,1,7),(387,'copySpeedPercent',5,'Blueprint copying speed',NULL,NULL,0,NULL,1,1,'Blueprint copying speed',NULL,1,1,7),(388,'frigateConstructionCost',4,'The % of Frigate assembly cost a player has to pay to assemble a frigate',NULL,NULL,0,NULL,100,1,'Frigate construction cost',NULL,1,1,7),(389,'cruiserConstructionCost',4,'The % of cruiser assembly cost a player has to pay to assemble a cruiser',NULL,NULL,0,NULL,0,1,'Cruiser construction cost',NULL,1,1,7),(392,'industrialConstructionCost',4,'The % of industrial assembly cost a player has to pay to assemble a industrial',NULL,NULL,0,NULL,0,1,'Industrial construction cost',NULL,1,1,7),(393,'battleshipConstructionCost',4,'The % of battleship assembly cost a player has to pay to assemble a battleship',NULL,NULL,1392,NULL,0,1,'Battleship construction cost',NULL,1,1,7),(394,'titanConstructionTime',4,'Titan construction time',NULL,NULL,0,NULL,100,1,'Titan construction time',NULL,1,1,7),(395,'stationConstructionTime',4,'Station construction time',NULL,NULL,0,NULL,100,1,'Station construction time',NULL,1,1,7),(396,'repairCostPercent',4,'Repair cost percent',NULL,NULL,0,NULL,100,1,'Repair cost percent',NULL,1,1,7),(397,'reverseEngineeringChance',4,'Chance of making a research breakthrough when researching a higher tech level of a blueprint',NULL,NULL,0,NULL,0,1,'Breakthrough percent',NULL,1,1,7),(398,'mineralNeedResearchSpeed',5,'speed bonus when researching blueprint mineral need',NULL,NULL,0,NULL,1,1,'Mineral need research speed',NULL,1,1,7),(399,'duplicatingChance',4,'Chance of upgrading a module to next tech level ',NULL,NULL,0,NULL,0,1,'prototypingChance',105,1,1,7),(400,'missileStandardVelocityPecent',4,'Missiles velocity multiplier',NULL,NULL,0,NULL,100,0,'missileVelocityPecent',NULL,1,1,9),(401,'cruiseMissileVelocityPercent',5,'Damage Bonus for Cruise Missiles',NULL,NULL,0,NULL,0,0,'Cruise missile Velocity percent',NULL,1,1,9),(402,'heavyMissileSpeedPercent',5,'Heavy missile speed percent',NULL,NULL,0,NULL,0,0,'Heavy missile speed  percent',NULL,1,1,9),(403,'rocketDmgPercent',4,'Rocket Dmg Percent',NULL,NULL,0,NULL,0,1,'Rocket Dmg Percent',105,1,1,7),(404,'torpedoVelocityPercent',5,'Torpedo velocity percent',NULL,NULL,0,NULL,0,0,'Torpedo velocity percent',NULL,1,1,9),(405,'defenderVelocityPercent',4,'Defender velocity percent',NULL,NULL,0,NULL,100,1,'Defender velocity percent',105,1,1,7),(406,'missileFOFVelocityPercent',5,'Missile FOF velocity percent',NULL,NULL,0,NULL,100,0,'Missile FOF velocity percent',NULL,1,1,9),(407,'researchGangSizeBonus',4,'Max research gang size bonus',NULL,NULL,0,NULL,0,0,'Research gang size bonus',NULL,1,1,9),(408,'battleshipConstructionTimeBonus',4,'Autogenerated skill attribute, battleshipConstructionTimeBonus',NULL,NULL,1392,NULL,0,0,'battleshipConstructionTimeBonus',NULL,1,1,9),(409,'cruiserConstructionTimeBonus',4,'Autogenerated skill attribute, cruiserConstructionTimeBonus',NULL,NULL,0,NULL,0,0,'cruiserConstructionTimeBonus',NULL,1,1,9),(410,'frigateConstructionTimeBonus',4,'Autogenerated skill attribute, frigateConstructionTimeBonus',NULL,NULL,0,NULL,0,0,'frigateConstructionTimeBonus',NULL,1,1,9),(411,'industrialConstructionTimeBonus',4,'Autogenerated skill attribute, industrialConstructionTimeBonus',NULL,NULL,0,NULL,0,0,'industrialConstructionTimeBonus',NULL,1,1,9),(412,'connectionBonusMutator',5,'Autogenerated skill attribute, connectionBonusMutator',NULL,NULL,0,NULL,0,0,'connectionBonusMutator',NULL,1,1,9),(413,'criminalConnectionsMutator',5,'Autogenerated skill attribute, criminalConnectionsMutator',NULL,NULL,0,NULL,0,1,'Criminal Connections Mutator',NULL,1,1,7),(414,'diplomacyMutator',5,'Autogenerated skill attribute, diplomacyMutator',NULL,NULL,0,NULL,0,1,'Diplomacy Mutator',NULL,1,1,7),(415,'fastTalkMutator',4,'Autogenerated skill attribute, fastTalkMutator',NULL,NULL,0,NULL,0,0,'fastTalkMutator',NULL,1,1,9),(416,'entityFlyRange',4,'The distance at which the entity orbits, follows.. and more.',NULL,NULL,0,NULL,500,0,'entityFlyRange',NULL,1,1,9),(417,'maxNonRaceCorporationMembers',4,'Max non  race corporationMembers',NULL,NULL,0,NULL,0,1,'Max non  race corporationMembers',NULL,1,1,7),(418,'nonRaceCorporationMembersBonus',4,'Autogenerated skill attribute, nonRaceCorporationMembersBonus',NULL,NULL,0,NULL,0,1,'Non Race Corporation Members Bonus',105,1,1,7),(419,'skillPointsSaved',4,'Amount of skill points saved by clone',NULL,NULL,33,NULL,10000,1,'Skill Points Saved',NULL,1,1,7),(420,'trackingBonus',4,'Autogenerated skill attribute, trackingBonus',NULL,NULL,0,NULL,0,0,'trackingBonus',121,1,1,9),(421,'shieldRechargerateBonus',4,'Autogenerated skill attribute, shieldRechargerateBonus',NULL,NULL,0,NULL,0,0,'shieldRechargerateBonus',NULL,1,1,9),(422,'techLevel',4,'Tech level of an item',NULL,NULL,1446,NULL,1,1,'Tech Level',NULL,1,1,7),(423,'entityDroneCount',4,'',NULL,NULL,0,NULL,0,0,'entityDroneCount',NULL,1,1,9),(424,'cpuOutputBonus2',4,'Autogenerated skill attribute, cpu OutputBonus',NULL,NULL,0,NULL,0,1,'cpu Output Bonus',105,1,1,1),(425,'cpuOutputBonus',4,'Autogenerated skill attribute, cpuOutputBonus',NULL,NULL,0,NULL,0,0,'cpuOutputBonus',NULL,1,1,9),(426,'heavyDroneDamagePercent',5,'',NULL,NULL,0,NULL,1,1,'droneDamagePercent',109,1,1,7),(427,'heavyDroneDamageBonus',4,'Autogenerated skill attribute, heavyDroneDamageBonus',NULL,NULL,0,NULL,0,0,'heavyDroneDamageBonus',NULL,1,1,9),(428,'miningDroneAmountPercent',4,'Mining drone speed percent',NULL,NULL,0,NULL,100,1,'miningDroneSpeedPercent',NULL,1,1,7),(429,'miningDroneSpeedBonus',4,'Autogenerated skill attribute, miningDroneSpeedBonus',NULL,NULL,0,NULL,0,0,'miningDroneSpeedBonus',NULL,1,1,9),(430,'scoutDroneVelocityPercent',4,'',NULL,NULL,0,NULL,100,0,'scoutDroneVelocityPercent',NULL,1,1,9),(431,'scoutDroneVelocityBonus',4,'Autogenerated skill attribute, scoutDroneVelocityBonus',NULL,NULL,0,NULL,0,0,'scoutDroneVelocityBonus',NULL,1,1,9),(432,'defenderVelocityBonus',4,'Autogenerated skill attribute, defenderVelocityBonus',NULL,NULL,0,NULL,0,1,'Drone Velocity Bonus',105,1,1,7),(433,'heavyMissileDamageBonus',4,'Autogenerated skill attribute, heavyMissileDamageBonus',NULL,NULL,0,NULL,0,0,'heavyMissileDamageBonus',NULL,1,1,9),(434,'miningAmountBonus',4,'Autogenerated skill attribute, miningAmountBonus',NULL,NULL,0,NULL,0,1,'Mining Amount Bonus',105,1,1,7),(435,'maxGangModules',4,'',NULL,NULL,0,NULL,3,1,'max Active Command Relays Bonus',NULL,1,1,7),(436,'standingIncreasePercent',4,'',NULL,NULL,0,NULL,100,0,'standingIncreasePercent',105,1,1,9),(437,'negotiationBonus',4,'Autogenerated skill attribute, NegotiationBonus',NULL,NULL,0,NULL,0,1,'NegotiationBonus',105,1,1,7),(438,'socialMutator',4,'Autogenerated skill attribute, socialMutator',NULL,NULL,0,NULL,0,1,'Social Mutator',105,1,1,7),(439,'targetingSpeedBonus',4,'Autogenerated skill attribute, targetingSpeedBonus',NULL,NULL,0,NULL,0,0,'targetingSpeedBonus',NULL,1,1,9),(440,'manufacturingTimeBonus',4,'Autogenerated skill attribute, manufacturingTimeBonus',NULL,NULL,0,NULL,0,1,'Manufacturing Time Bonus',105,1,1,7),(441,'turretSpeeBonus',4,'Autogenerated skill attribute, TurretSpeeBonus',NULL,NULL,0,NULL,0,1,'rate of fire bonus',121,1,1,7),(442,'barterDiscount',5,'skill discount when selling to npc corps',NULL,NULL,0,NULL,0,0,'barterDiscount',NULL,1,1,9),(443,'tradePremium',5,'price bonus when selling to npc corps\n',NULL,NULL,0,NULL,0,1,'Trade premium',NULL,1,1,7),(444,'contrabandFencingChance',5,'Chance of being caught selling contraband on market. ',NULL,NULL,0,NULL,0,1,'Contraband fencing chance',105,1,1,7),(445,'smugglingChance',5,'Chance of being caught Transporting contraband. ',NULL,NULL,0,NULL,0,0,'smugglingChance',NULL,1,1,9),(446,'tradePremiumBonus',4,'Autogenerated skill attribute, tradePremiumBonus',NULL,NULL,0,NULL,0,0,'tradePremiumBonus',NULL,1,1,9),(447,'smugglingChanceBonus',5,'Autogenerated skill attribute, smugglingChanceBonus',NULL,NULL,1196,NULL,0,1,'Smuggling Chance Bonus',105,1,1,7),(448,'fencingChanceBonus',4,'Autogenerated skill attribute, fencingChanceBonus',NULL,NULL,0,NULL,0,0,'fencingChanceBonus',NULL,1,1,9),(449,'barterDiscountBonus',4,'Autogenerated skill attribute, BarterDiscountBonus',NULL,NULL,0,NULL,0,1,'BarterDiscountBonus',NULL,1,1,7),(450,'manufacturingSlotBonus',4,'Autogenerated skill attribute, manufacturingSlotBonus',NULL,NULL,0,NULL,0,1,'Manufacturing Slot Bonus',NULL,1,1,7),(451,'manufactureCostBonus',4,'Autogenerated skill attribute, manufactureCostBonus',NULL,NULL,0,NULL,0,1,'Manufacture Cost Bonus',105,1,1,7),(452,'copySpeedBonus',4,'Autogenerated skill attribute, CopySpeedBonus',NULL,NULL,0,NULL,0,1,'Copy Speed Bonus',105,1,1,7),(453,'blueprintmanufactureTimeBonus',4,'Autogenerated skill attribute, blueprintmanufactureTimeBonus',NULL,NULL,0,NULL,0,1,'Blueprint Manufacture Time Bonus',105,1,1,7),(454,'mutaton',4,'',NULL,NULL,0,NULL,0,0,'Mutaton',NULL,1,1,9),(455,'learningBonus',4,'Autogenerated skill attribute, learningBonus',NULL,NULL,0,NULL,0,1,'Learning Bonus',105,1,1,7),(456,'entityEquipmentMin',4,'',NULL,NULL,0,NULL,0,0,'entityEquipmentMin',NULL,1,1,9),(457,'entityEquipmentMax',4,'',NULL,NULL,0,NULL,0,0,'entityEquipmentMax',NULL,1,1,9),(458,'droneControlDistance',4,'',NULL,NULL,0,NULL,20000,1,'Max drone control distance',1,1,1,10),(459,'droneRangeBonus',4,'Autogenerated skill attribute, droneRangeBonus',NULL,NULL,0,NULL,0,1,'Drone Control Range Bonus',1,1,1,10),(460,'shipBonusMF',5,'',NULL,NULL,0,NULL,0,1,'Special Ability Bonus',105,1,1,7),(461,'specialAbilityBonus',4,'Autogenerated skill attribute, specialAbilityBonus',NULL,NULL,0,NULL,0,0,'specialAbilityBonus',NULL,1,1,9),(462,'shipBonusGF',5,'',NULL,NULL,0,NULL,0,0,'shipBonusGF',NULL,1,1,9),(463,'shipBonusCF',5,'',NULL,NULL,0,NULL,0,0,'shipBonusCF',NULL,1,1,9),(464,'shipBonusAF',5,'',NULL,NULL,0,NULL,0,0,'shipBonusAF',NULL,1,1,9),(465,'entityEquipmentGroupMax',4,'The maximum drops of same group (example: entity can only drop 1 of group: energy laser)',NULL,NULL,0,NULL,1,0,'entityEquipmentGroupMax',NULL,1,1,9),(466,'entityReactionFactor',5,'The chance of an entity attacking the same person as its group members.  Scales delay in joining in on fights too.',NULL,NULL,0,NULL,1,0,'entityReactionFactor',NULL,1,1,9),(467,'maxLaborotorySlots',4,'',NULL,NULL,0,NULL,1,1,'Max Active Laboratories',NULL,1,1,7),(468,'mineralNeedResearchBonus',4,'Autogenerated skill attribute, mineralNeedResearchBonus',NULL,NULL,0,NULL,0,1,'Mineral Need Research Bonus',105,1,1,7),(469,'entityBluePrintDropChance',5,'',NULL,NULL,0,NULL,0,0,'entityBluePrintDropChance',NULL,1,1,9),(470,'lootRespawnTime',4,'The number of milliseconds before the container replenishes the loot inside itself.',NULL,NULL,0,NULL,600000,0,'lootRespawnTime',101,1,1,9),(471,'laboratorySlotsBonus',4,'Autogenerated skill attribute, laboratorySlotsBonus',NULL,NULL,0,NULL,0,0,'laboratorySlotsBonus',NULL,1,1,9),(472,'stationTypeID',11,'The type of station this platform can be used to build.',NULL,NULL,0,NULL,0,1,'Station Type',116,1,1,7),(473,'prototypingBonus',4,'Autogenerated skill attribute, prototypingBonus',NULL,NULL,0,NULL,0,0,'prototypingBonus',NULL,1,1,9),(474,'inventionBonus',4,'Autogenerated skill attribute, inventionBonus',NULL,NULL,0,NULL,0,0,'inventionBonus',NULL,1,1,9),(475,'entityAttackDelayMin',4,'Minimum attack delay time for entity.',NULL,NULL,0,NULL,0,0,'entityAttackDelayMin',NULL,1,1,9),(476,'entityAttackDelayMax',4,'Maximum attack delay time for entity.',NULL,NULL,0,NULL,0,0,'entityAttackDelayMax',NULL,1,1,9),(478,'shipBonusAC',5,'',NULL,NULL,0,NULL,0,0,'shipBonusAC',NULL,1,1,9),(479,'shieldRechargeRate',5,'Amount of time taken to fully recharge the shield.',NULL,NULL,1392,NULL,0,1,'Shield recharge time',101,1,1,2),(480,'maxEffectiveRange',5,'',NULL,NULL,0,NULL,0,0,'maxEffectiveRange',1,1,1,9),(481,'entityKillBounty',4,'Reward for destroying this entity.',NULL,NULL,0,NULL,0,1,'Bounty',NULL,1,1,7),(482,'capacitorCapacity',5,'Capacitor capacity',NULL,NULL,0,NULL,0,1,'Capacitor Capacity',114,1,1,5),(484,'shieldUniformity',5,'DO NOT MESS WITH This number is deducted from the %chance of the seeping to armor, to slow seep of damage through shield.',NULL,NULL,NULL,NULL,0,0,'Shield Uniformity',NULL,1,1,9),(485,'shipBonus2AF',5,'',NULL,NULL,0,NULL,5,0,'shipBonus2AF',NULL,1,1,9),(486,'shipBonusGC',5,'',NULL,NULL,0,NULL,5,0,'shipBonusGC',NULL,1,1,9),(487,'shipBonusCC',5,'',NULL,NULL,0,NULL,5,0,'shipBonusCC',NULL,1,1,9),(488,'shipVelocityBonusMC',4,'',NULL,NULL,0,NULL,5,0,'shipVelocityBonusMC',NULL,1,1,9),(489,'shipBonusMC',5,'',NULL,NULL,0,NULL,0,0,'shipBonusMC',NULL,1,1,9),(490,'shipBonusMB',5,'',NULL,NULL,0,NULL,5,0,'shipBonusMB',NULL,1,1,9),(491,'shipBonusCB',5,'',NULL,NULL,0,NULL,5,0,'shipBonusCB',NULL,1,1,9),(492,'shipBonusAB',5,'',NULL,NULL,0,NULL,5,0,'shipBonusAB',NULL,1,1,9),(493,'shipBonusMI',5,'',NULL,NULL,0,NULL,5,0,'shipBonusMI',NULL,1,1,9),(494,'shipBonusAI',5,'',NULL,NULL,0,NULL,5,0,'shipBonusAI',NULL,1,1,9),(495,'shipBonusCI',5,'',NULL,NULL,0,NULL,5,0,'shipBonusCI',NULL,1,1,9),(496,'shipBonusGI',5,'',NULL,NULL,0,NULL,5,0,'shipBonusGI',NULL,1,1,9),(497,'entityDefenderChance',5,'% chance of entity to shoot defender at incoming missile',NULL,NULL,0,NULL,0,0,'entityDefenderChance',NULL,1,1,9),(499,'droneCapacityBonus',4,'',NULL,NULL,0,NULL,0,0,'droneCapacityBonus',NULL,1,1,9),(500,'shipBonusGB',5,'',NULL,NULL,0,NULL,0,0,'shipBonusGB',NULL,1,1,9),(501,'shipBonus2CB',5,'',NULL,NULL,0,NULL,0,0,'shipBonus2CB',NULL,1,1,9),(502,'entityConvoyDroneMin',4,'Minimum number of drones the convoy can have for protection.',NULL,NULL,0,NULL,1,0,'entityConvoyDroneMin',NULL,1,1,9),(503,'entityConvoyDroneMax',4,'Maximum number of convoy drones a convoy can have for proetcion.',NULL,NULL,0,NULL,1,0,'entityConvoyDroneMax',NULL,1,1,9),(504,'entityWarpScrambleChance',5,'Chance of entity warp scrambling it\'s target.',NULL,NULL,0,NULL,0,0,'entityWarpScrambleChance',NULL,1,1,9),(505,'warpScrambleDuration',5,'',NULL,NULL,1392,NULL,8000,1,'Duration',3,1,1,7),(506,'missileLaunchDuration',5,'Cycle time for a missile launch, in milliseconds.',NULL,NULL,0,NULL,20000,1,'Rate of fire',3,1,1,7),(507,'entityMissileTypeID',11,'The type of missiles the entity launches.',NULL,NULL,0,NULL,0,0,'Missile Type',116,1,1,9),(508,'entityCruiseSpeed',4,'The speed that entities fly at when not chasing a target.',NULL,NULL,0,NULL,0,1,'Orbit Velocity',10,1,1,9),(509,'cargoScanFalloff',5,'Distance from maximum range at which accuracy has fallen by half.',NULL,NULL,0,NULL,0,0,'cargoScanFalloff',1,1,1,9),(510,'shipScanFalloff',5,'Distance from maximum range at which accuracy has fallen by half.',NULL,NULL,0,NULL,0,1,'Ship Scan Falloff',1,1,1,7),(511,'shipScanResistance',5,'Chance of being able to resist a ship scan.',NULL,NULL,0,NULL,0,0,'shipScanResistance',121,1,1,9),(512,'modifyTargetSpeedChance',5,'Chance that  an entity will use a Stasis Web on a target.',NULL,NULL,0,NULL,0,0,'modifyTargetSpeedChance',NULL,1,1,9),(513,'modifyTargetSpeedDuration',5,'Duration of entities Stasis Web ',NULL,NULL,0,NULL,5000,0,'modifyTargetSpeedDuration',3,1,1,9),(514,'modifyTargetSpeedRange',4,'Range of entities Stasis Web',NULL,NULL,0,NULL,20000,0,'modifyTargetSpeedRange',1,1,1,9),(515,'modifyTargetSpeedCapacitorNeed',4,'',NULL,NULL,0,NULL,0,0,'modifyTargetSpeedCapacitorNeed',NULL,1,1,9),(516,'chassisType',11,'',NULL,NULL,0,NULL,0,1,'Required chassis Type',116,1,1,9),(517,'fallofMultiplier',5,'',NULL,NULL,1399,NULL,1,1,'Falloff Modifier',104,1,1,7),(518,'shipBonusMB2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusMB2',NULL,1,1,9),(519,'cloakingCapacitorNeedRatio',5,'The percentage of capacitor capacity required to engage cloaking.',NULL,NULL,0,NULL,1,0,'cloakingCapacitorNeedRatio',NULL,1,1,9),(522,'damageCloudChance',5,'%chance of new asteroid releasing damage cloud each mining turn.',NULL,NULL,0,NULL,0,0,'damageCloudChance',NULL,1,1,9),(524,'armorUniformity',5,'DO NOT MESS WITH',NULL,NULL,0,NULL,0,0,'armorUniformity',NULL,1,1,9),(525,'structureUniformity',5,'DO NOT MESS WITH',NULL,NULL,0,NULL,0,0,'structureUniformity',NULL,1,1,9),(526,'reqResearchSkill',11,'',NULL,NULL,0,NULL,0,1,'Research Skill Required ',NULL,1,1,7),(527,'reqManufacturingSkill',11,'',NULL,NULL,0,NULL,0,1,'Required Manufacturing Skill ',NULL,1,1,7),(528,'reqManufacturingSkillLevel',4,'',NULL,NULL,0,NULL,0,1,'requiredManufacturingSkillLevel',NULL,1,1,7),(529,'reqResearchSkillLevel',4,'',NULL,NULL,0,NULL,0,1,'Required Research Skill Level',NULL,1,1,7),(530,'reqManufacturingTool',11,'',NULL,NULL,0,NULL,0,1,'req Manufacturing Tool',NULL,1,1,7),(531,'reqResearchTool',11,'',NULL,NULL,0,NULL,0,1,'req Research Tool',NULL,1,1,7),(532,'reqResearchComponent',11,'',NULL,NULL,0,NULL,0,0,'reqResearchComponent',NULL,1,1,9),(534,'Manufacturer_ID',11,'',NULL,NULL,0,NULL,0,1,'Manufacturer Bonus',NULL,1,1,7),(535,'installedMod',11,'',NULL,NULL,0,NULL,0,1,'Modification Type',NULL,1,1,7),(536,'reqResearchComponetAmount',4,'',NULL,NULL,0,NULL,0,0,'reqResearchComponetAmount',NULL,1,1,9),(537,'reqManufacturingComponent1Amount',4,'',NULL,NULL,0,NULL,0,1,'Primary Manufacture Componet A',NULL,1,1,7),(538,'reqManufacturingComponent2Amount',4,'',NULL,NULL,0,NULL,0,1,'Secondary Manufacture Componet',NULL,1,1,7),(542,'entityStrength',4,'A relative strength that indicates how powerful this NPC entity is in combat.',NULL,NULL,0,NULL,0,0,'entityStrength',NULL,1,1,9),(543,'damageCloudChanceReduction',4,'Autogenerated skill attribute, damageCloudChanceReduction',NULL,NULL,0,NULL,0,0,'damageCloudChanceReduction',NULL,1,1,9),(544,'cloudEffectDelay',4,'The amount of time before applications of the cloud\'s effect.',NULL,NULL,0,NULL,0,0,'cloudEffectDelay',101,1,1,9),(545,'cloudDuration',4,'Number of milliseconds a temporary cloud hangs around.',NULL,NULL,0,NULL,0,0,'cloudDuration',101,1,1,9),(546,'damageCloudType',11,'The type of damage cloud generated by the asteroid.',NULL,NULL,0,NULL,0,0,'damageCloudType',116,1,1,9),(547,'missileVelocityBonus',4,'Autogenerated skill attribute, missileVelocityBonus ',NULL,NULL,0,NULL,0,1,'Missile Velocity Bonus',105,1,1,7),(548,'shieldBoostMultiplier',5,'',NULL,NULL,2104,NULL,1,1,'Shield Boost Bonus',121,1,1,2),(549,'powerIncrease',4,'',NULL,NULL,0,NULL,0,1,'Power Bonus',107,1,1,7),(550,'resistanceBonus',4,'Autogenerated skill attribute, resistanceBonus',NULL,NULL,0,NULL,0,1,'Resistance Bonus',121,1,1,7),(551,'rocketVelocityPercent',5,'',NULL,NULL,0,NULL,1,0,'rocketVelocityPercent',NULL,1,1,9),(552,'signatureRadius',5,'Signature Radius is used for turret tracking and scanning.',NULL,NULL,1390,NULL,100,1,'Signature Radius',1,0,1,6),(553,'maxGangSizeBonus',4,'Autogenerated skill attribute, maxGangSizeBonus',NULL,NULL,0,NULL,0,0,'maxGangSizeBonus',NULL,1,1,9),(554,'signatureRadiusBonus',5,'Autogenerated skill attribute, signatureRadiusBonus',NULL,NULL,1390,NULL,0,1,'Signature Radius Bonus',124,1,1,7),(555,'cloakVelocityBonus',4,'Autogenerated skill attribute, cloakVelocityBonus',NULL,NULL,0,NULL,0,0,'Cloak Velocity Bonus',105,1,1,9),(556,'anchoringDelay',4,'How long it takes to anchor or unanchor this object.',NULL,NULL,1392,NULL,60000,1,'Anchoring Delay',101,1,1,7),(557,'maxFlightTimeBonus',4,'Autogenerated skill attribute, max flightTimeBonus',NULL,NULL,0,NULL,0,1,'Flight Time Bonus',121,1,1,7),(558,'explosionRangeBonus',4,'Autogenerated skill attribute, explosionRangeBonus',NULL,NULL,0,NULL,0,0,'explosionRangeBonus',NULL,1,1,9),(559,'Inertia',5,'Inertia is a basic multiplier of agility and the mass of the ship, it determines how fast the ship can accelerate and how fast it can fly when orbiting.',NULL,NULL,1401,NULL,0,0,'Inertia',2,1,1,9),(560,'cloakingTargetingDelay',4,'The time targeting systems take to recalibrate after cloaking.',NULL,NULL,0,NULL,0,1,'Sensor Recalibration Time',3,1,1,6),(561,'shipBonusGB2',5,'skill bonus attribute2 for gallente battleship',NULL,NULL,0,NULL,0,0,'shipBonusGB2',NULL,1,1,9),(562,'entityFactionLoss',5,'',NULL,NULL,0,NULL,0,0,'entityFactionLoss',NULL,1,1,9),(563,'entitySecurityMaxGain',5,'',NULL,NULL,0,NULL,0,0,'entitySecurityMaxGain',NULL,1,1,9),(564,'scanResolution',5,'The resolution that the vessel can target other objects at.',NULL,NULL,74,NULL,0,1,'Scan Resolution',102,0,1,6),(565,'scanResolutionMultiplier',5,'Improves the targeting time of ships by boosting the Scan Resolution.',NULL,NULL,74,NULL,0,1,'Scan Resolution Bonus',109,1,1,7),(566,'scanResolutionBonus',5,'Bonus for scan resolution',NULL,NULL,74,NULL,0,1,'Scan Resolution Bonus',105,1,1,7),(567,'speedBoostFactor',4,'Used to divide with mass to give a factor for speed boost modules',NULL,NULL,96,NULL,0,1,'Thrust',125,1,1,7),(568,'eliteBonusInterceptor',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusInterceptor',NULL,1,1,9),(569,'eliteBonusCoverOps1',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusCoverOps1',NULL,1,1,9),(570,'eliteBonusBombers',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusBombers',NULL,1,1,9),(571,'eliteBonusGunships',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusGunships',NULL,1,1,9),(573,'eliteBonusdestroyers',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusdestroyers',NULL,1,1,9),(575,'eliteBonusBattlecruiser',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusBattlecruiser',NULL,1,1,9),(576,'speedBoostFactorCalc',5,'Hidden attribute that is used for speedBoostFactor calculation because Dogma cant handle it.',NULL,NULL,0,NULL,1,0,'speedBoostFactorCalc',NULL,1,1,9),(578,'speedBoostFactorCalc2',5,'Second hidden attribute.',NULL,NULL,0,NULL,1,0,'speedBoostFactorCalc2',NULL,1,1,9),(579,'testForEggert',4,'',NULL,NULL,0,NULL,0,0,'testForEggert',NULL,1,1,9),(580,'entityChaseMaxDelay',4,'The maximum amount of time stalled before entity chase speed kicks in.',NULL,NULL,0,NULL,5000,0,'entityChaseMaxDelay',NULL,1,1,9),(581,'entityChaseMaxDelayChance',5,'Chance that the max delay is waited before chase is engaged.',NULL,NULL,0,NULL,1,0,'entityChaseMaxDelayChance',NULL,1,1,9),(582,'entityChaseMaxDuration',4,'The maximum amount of time chase is ever engaged for.',NULL,NULL,0,NULL,5000,0,'entityChaseMaxDuration',101,1,1,9),(583,'entityChaseMaxDurationChance',5,'The chance of engaging chase for the maximum duration.',NULL,NULL,0,NULL,1,0,'entityChaseMaxDurationChance',NULL,1,1,9),(584,'entityMaxWanderRange',4,'The maximum distance an entity of this type can be led from its point of placement.',NULL,NULL,0,NULL,100000,0,'entityMaxWanderRange',1,1,1,9),(585,'shipBonusAB2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusAB2',NULL,1,1,9),(586,'shipBonusGF2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusGF2',NULL,1,1,9),(587,'shipBonusMF2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusMF2',NULL,1,1,9),(588,'shipBonusCF2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusCF2',NULL,1,1,9),(589,'isPlayerOwnable',3,'Whether a station type is player ownable.',NULL,NULL,0,NULL,0,0,'isPlayerOwnable',NULL,1,1,9),(590,'gestaltBonus1',5,'',NULL,NULL,0,NULL,0,0,'gestaltBonus1',NULL,1,1,9),(591,'droneMaxVelocityBonus',4,'Increases max velocity of all drone types.',NULL,NULL,0,NULL,0,1,'Drone Velocity Bonus',105,1,1,10),(592,'cloakCapacitorBonus',4,'Autogenerated skill attribute, cloakCapacitorBonus',NULL,NULL,0,NULL,0,0,'cloakCapacitorBonus',NULL,1,1,9),(594,'Die',4,'Autogenerated skill attribute, cloakCapacitor Bonus',NULL,NULL,0,NULL,0,0,'Die',NULL,1,1,9),(595,'capBoostMultipler',5,'',NULL,NULL,0,NULL,0,0,'CapBoostMultipler',NULL,1,1,9),(596,'explosionDelayBonus',4,'Autogenerated skill attribute, explosionDelayBonus',NULL,NULL,0,NULL,0,0,'explosionDelayBonus',NULL,1,1,9),(597,'eliteBonusEscorts',4,'bonus for escort class frigates',NULL,NULL,0,NULL,10,0,'eliteBonusEscorts',NULL,1,1,9),(598,'shipBonusCB3',5,'',NULL,NULL,0,NULL,0,0,'shipBonusCB3',NULL,1,1,9),(600,'warpSpeedMultiplier',5,'',NULL,NULL,0,NULL,1,1,'Warp Speed Multiplier',104,1,1,7),(601,'warpSpeedBonus',4,'Autogenerated skill attribute, warpSpeedBonus',NULL,NULL,0,NULL,0,1,'Warp Speed Bonus',105,1,1,7),(602,'launcherGroup2',12,'One of the groups of launcher this charge can be loaded into.',NULL,NULL,0,NULL,0,1,'Used with (launchergroup)',115,1,1,7),(603,'launcherGroup3',12,'One of the groups of launcher this charge can be loaded into.',NULL,NULL,0,NULL,0,1,'Used with (launchergroup)',115,1,1,7),(604,'chargeGroup1',12,'One of the groups of charge this launcher can be loaded with.',NULL,NULL,0,NULL,0,1,'Used with (chargegroup)',115,1,1,7),(605,'chargeGroup2',12,'One of the groups of charge this launcher can be loaded with.',NULL,NULL,0,NULL,0,1,'Used with (chargegroup)',115,1,1,7),(606,'chargeGroup3',12,'One of the groups of charge this launcher can be loaded with.',NULL,NULL,0,NULL,0,1,'Used with (chargegroup)',115,1,1,7),(608,'powerNeedMultiplier',5,'',NULL,NULL,0,NULL,1,1,'Turret Power Need',109,1,1,7),(609,'chargeGroup4',12,'One of the groups of charge this launcher can be loaded with.',NULL,NULL,0,NULL,0,1,'Used with (chargegroup)',115,1,1,7),(610,'chargeGroup5',12,'One of the groups of charge this launcher can be loaded with.',NULL,NULL,0,NULL,0,1,'Used with (chargegroup)',115,1,1,7),(611,'durationMultiplier',5,'',NULL,NULL,0,NULL,0,1,'Duration Bonus',111,1,1,7),(612,'baseShieldDamage',5,'Just for the UI to display base damage on shield.',NULL,NULL,69,NULL,0,1,'Base Shield Damage',NULL,1,1,7),(613,'baseArmorDamage',5,'Just for the UI to display base damage on armor.',NULL,NULL,68,NULL,0,1,'Base Armor Damage',NULL,1,1,7),(614,'cargoCapacityBonus',4,'Autogenerated skill attribute, cargoCapacityBonus',NULL,NULL,0,NULL,0,1,'Cargo Capacity Bonus',121,1,1,4),(616,'boosterShieldBoostAmountPenalty',5,'Multiplier applied to the ship\'s maximum velocity.',NULL,NULL,0,NULL,1,1,'Shield Booster Penalty',105,1,1,7),(619,'cloakingTargetingDelayBonus',4,'Skill bonus for cloaking targeting delay.',NULL,NULL,0,NULL,0,1,'Cloaking Targeting Delay Bonus',105,1,1,6),(620,'optimalSigRadius',5,'Prefered target signature. The base signature radius at which the turret\'s tracking speed is rated. ',NULL,NULL,0,NULL,1000,1,'Signature Resolution',1,1,1,7),(621,'trackingSpeedAtOptimal',4,'Rated target transverse velocity at optimal range.',NULL,NULL,0,NULL,1,1,'Tracking Speed at Optimal Range',10,1,1,7),(622,'massLimit',5,'Determines the maximum weight of a ship that, ships that are to heavy get denied of service by this attribute',NULL,NULL,0,NULL,0,0,'capacityLimit',2,1,1,7),(623,'cloakingSlotsLeftSuper',4,'hot-fix for not allowing warpable cloaking modules on anything but covert-ops frigs',NULL,NULL,0,NULL,0,0,'cloakingSlotsLeftSuper',NULL,1,1,9),(624,'WarpSBonus',4,'Autogenerated skill attribute, WarpSBonus',NULL,NULL,0,NULL,0,1,'Warp Speed Bonus',105,1,1,7),(625,'bountyBonus',5,'Flat Bonus To NPC Bountys',NULL,NULL,0,NULL,0,0,'bountyBonus',NULL,1,1,9),(626,'bountyMultiplier',5,'Npc Bounty Multiplier',NULL,NULL,0,NULL,1,0,'bountyMultiplier',NULL,1,1,9),(627,'bountySkillBonus',4,'Autogenerated skill attribute, bountySkillBonus',NULL,NULL,0,NULL,0,0,'bountySkillBonus',NULL,1,1,9),(628,'bountySkillMultiplyer',4,'Autogenerated skill attribute, bountySkillMultiplyer',NULL,NULL,0,NULL,0,0,'bountySkillMultiplyer',NULL,1,1,9),(629,'cargoGroup',12,'The cargo group that can be loaded into this container',NULL,NULL,0,NULL,0,0,'cargoGroup',NULL,1,1,9),(630,'entityArmorRepairDuration',4,'Duration between armor repair actions for entities.',NULL,NULL,0,NULL,0,0,'entityArmorRepairDuration',NULL,1,1,9),(631,'entityArmorRepairAmount',5,'Amount of armor repaired per cycle for entities.',NULL,NULL,0,NULL,0,0,'entityArmorRepairAmount',NULL,1,1,9),(632,'interceptorGF',4,'',NULL,NULL,0,NULL,0,0,'interceptorGF',NULL,1,1,9),(633,'metaLevel',4,'The ranking of the module within its tech level',NULL,NULL,0,NULL,0,1,'Meta Level',NULL,1,1,7),(634,'newAgility',5,'Maximum \"Thrust angle\" for an object in Radians, 0 to pi (3.14).',NULL,NULL,0,NULL,3,0,'newAgility',NULL,1,1,9),(635,'turnAngle',5,'Maximum turn angle of a ship in Radians, 0 to pi (3.14).',NULL,NULL,0,NULL,3,0,'turnAngle',NULL,1,1,9),(636,'entityShieldBoostDuration',4,'How long between repeats.',NULL,NULL,0,NULL,10000,0,'entityShieldBoostDuration',NULL,1,1,9),(637,'entityShieldBoostAmount',5,'How much the shield is boosted each duration.',NULL,NULL,0,NULL,0,0,'entityShieldBoostAmount',NULL,1,1,9),(638,'entityArmorRepairDelayChance',5,'Chance that an entity will delay employing armor repair.',NULL,NULL,0,NULL,0,0,'entityArmorRepairDelayChance',NULL,1,1,9),(639,'entityShieldBoostDelayChance',5,'The chance an entity will delay repeating use of its shield boosting effect if it has one.',NULL,NULL,0,NULL,1,0,'entityShieldBoostDelayChance',NULL,1,1,9),(640,'entityGroupRespawnChance',5,'The chance an entity will respawn into his group if destroyed.',NULL,NULL,0,NULL,1,0,'entityGroupRespawnChance',NULL,1,1,9),(641,'prereqimplant',4,'typeID of an implant that the character must have to use this implant. ',NULL,NULL,0,NULL,0,0,'Prerequisite Implant Type',NULL,1,1,9),(643,'armingTime',4,'Delay after launch until a missile will do damage on impact.',NULL,NULL,0,NULL,0,1,'Arming Time',3,1,1,7),(644,'aimedLaunch',4,'Determines wether a missile launches aligned with the ship (0) or directly at the target (1).',NULL,NULL,0,NULL,0,0,'aimedLaunch',NULL,1,1,9),(645,'missileEntityVelocityMultiplier',5,'Multiplier for the missile\'s speed.',NULL,NULL,0,NULL,1,1,'Missile Velocity Bonus',104,1,1,7),(646,'missileEntityFlightTimeMultiplier',5,'Multiplier for the missile\'s flight time.',NULL,NULL,0,NULL,1,1,'Missile Flight Time Bonus',104,1,1,7),(647,'missileEntityArmingTimeMultiplier',5,'',NULL,NULL,0,NULL,1,0,'missileEntityArmingTimeMultiplier',NULL,1,1,9),(648,'shieldTUNEBonus',5,'',NULL,NULL,0,NULL,0,1,'Shield tuneup bonus',113,1,1,2),(649,'cloakingCpuNeedBonus',5,'',NULL,NULL,0,NULL,0,0,'cloakingCpuNeedBonus',NULL,1,1,9),(650,'maxStructureDistance',4,'The distance that structures have to be from a control tower in order to work with it.',NULL,NULL,0,NULL,0,1,'Maximum Structure Distance',1,1,1,7),(651,'decloakFieldRange',4,'Range of broadcasted decloaking field.',NULL,NULL,0,NULL,0,1,'Area of effect',1,1,1,7),(652,'signatureRadiusMultiplier',5,'',NULL,NULL,0,NULL,0,1,'Signature Penalty',109,1,1,7),(653,'aoeVelocity',4,'Velocity of the damage cloud created on impact.',NULL,NULL,0,NULL,0,1,'Explosion Velocity',10,1,1,7),(654,'aoeCloudSize',4,'Size of the damage cloud caused by impact.',NULL,NULL,1390,NULL,0,1,'Explosion Radius',1,1,1,7),(655,'aoeFalloff',5,'',NULL,NULL,0,NULL,0,0,'aoeFalloff',NULL,1,1,9),(656,'shipBonusAC2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusAC2',NULL,1,1,9),(657,'shipBonusCC2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusCC2',NULL,1,1,9),(658,'shipBonusGC2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusGC2',NULL,1,1,9),(659,'shipBonusMC2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusMC2',NULL,1,1,9),(660,'impactDamage',4,'The amount of kinetic damage that might be inflicted on collision.',NULL,NULL,0,NULL,0,0,'Kinetic Damage',113,1,1,9),(661,'maxDirectionalVelocity',5,'Deprecated.',NULL,NULL,0,NULL,1,0,'maxDirectionalVelocity',NULL,1,1,9),(662,'minTargetVelDmgMultiplier',5,'Deprecated.',NULL,NULL,0,NULL,1,0,'minTargetVelDmgMultiplier',NULL,1,1,9),(663,'minMissileVelDmgMultiplier',5,'',NULL,NULL,0,NULL,1,0,'minMissileVelDmgMultiplier',NULL,1,1,9),(664,'maxMissileVelocity',5,'A multiplier used for the missile impact damage calculations.',NULL,NULL,0,NULL,1,0,'maxMissileVelocity',NULL,1,1,9),(665,'entityChaseMaxDistance',4,'The distance outside of which the entity activates their MWD equivalent.',NULL,NULL,0,NULL,2500,0,'entityChaseMaxDistance',1,1,1,9),(666,'moduleShipGroup2',12,'This module only fits on specific ship groups.  This is one of them.',NULL,NULL,0,NULL,0,1,'Restricted Ship Type',115,1,1,7),(667,'moduleShipGroup3',12,'This module only fits on specific ship groups.  This is one of them.',NULL,NULL,0,NULL,0,1,'Restricted Ship Type',115,1,1,1),(668,'moduleShipGroup1',12,'This module only fits on specific ship groups.  This is one of them.',NULL,NULL,0,NULL,0,1,'Restricted Ship Type',115,1,1,7),(669,'moduleReactivationDelay',4,'Amount of time that has to be waited after the deactivation of this module until it can be reactivated.',NULL,NULL,0,NULL,0,1,'Reactivation Delay',101,1,1,7),(670,'areaOfEffectBonus',5,'',NULL,NULL,1390,NULL,0,1,'Area Of Effect Bonus',1,1,1,7),(672,'entityCruiseSpeedMultiplier',5,'',NULL,NULL,0,NULL,1,1,'Orbit Velocity Bonus',109,1,1,7),(673,'eliteBonusGunship1',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusGunship1',NULL,1,1,9),(675,'eliteBonusGunship2',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusGunship2',NULL,1,1,9),(676,'unanchoringDelay',4,'How long it takes to unanchor this object.',NULL,NULL,1392,NULL,60000,1,'Unanchoring Delay',101,1,1,7),(677,'onliningDelay',4,'How long it takes to bring this object online.',NULL,NULL,1392,NULL,60000,1,'Onlining Delay',101,1,1,7),(678,'eliteBonusLogistics1',5,'first bonus for support cruisers',NULL,NULL,0,NULL,0,0,'eliteBonusLogistics1',NULL,1,1,9),(679,'eliteBonusLogistics2',5,'second bonus for support cruisers',NULL,NULL,0,NULL,0,0,'eliteBonusLogistics2',NULL,1,1,9),(680,'shieldRadius',4,'Radius of the force shield that this structure generates.',NULL,NULL,0,NULL,0,1,'Shield Radius',1,1,1,2),(681,'typeContainerType1',11,'A type allowed to be placed in this container.',NULL,NULL,0,NULL,0,1,'Stored Type 1',116,1,1,7),(682,'typeContainerType2',11,'A type allowed to be placed in this container.',NULL,NULL,0,NULL,0,1,'Stored Type 2',116,1,1,7),(683,'typeContainerType3',11,'A type allowed to be placed in this container.',NULL,NULL,0,NULL,0,1,'Stored Type 3',116,1,1,7),(684,'typeContainerCapacity1',4,'The amount of storage type 1 that can be fitted inside this structure.',NULL,NULL,0,NULL,0,1,'Storage Capacity 1',9,1,1,7),(685,'typeContainerCapacity2',4,'The amount of storage type 2 that can be fitted inside this structure.',NULL,NULL,0,NULL,0,1,'Storage Capacity 2',9,1,1,7),(686,'typeContainerCapacity3',4,'The amount of storage type 3 that can be fitted inside this structure.',NULL,NULL,0,NULL,0,1,'Storage Capacity 3',9,1,1,7),(687,'operationConsumptionRate',4,'The number of units of a resource consumed per minute of operation.',NULL,NULL,0,NULL,0,1,'Operation Consumption Rate',NULL,1,1,7),(688,'reinforcedConsumptionRate',4,'The number of units of a resource consumed per minute of reinforced mode.',NULL,NULL,0,NULL,0,1,'Resinforced Consumption Rate',NULL,1,1,7),(689,'packageGraphicID',4,'The graphicID used for the structure when it is in package form.',NULL,NULL,2391,NULL,2391,0,'packageGraphicID',NULL,1,1,9),(690,'packageRadius',5,'The radius of the structure when it is in package form.',NULL,NULL,0,NULL,250,0,'packageRadius',NULL,1,1,9),(691,'targetSwitchDelay',4,'The amount of time after attacking a target that an entity will wait before switching to a new one.',NULL,NULL,0,NULL,0,0,'Target Cycling Speed',101,1,1,9),(692,'eliteBonusHeavyGunship1',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusHeavyGunship1',NULL,1,1,9),(693,'eliteBonusHeavyGunship2',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusHeavyGunship2',NULL,1,1,9),(694,'resourceReinforced1Type',11,'',NULL,NULL,0,NULL,0,1,'Reinforced Mode Type',116,1,1,7),(695,'resourceReinforced2Type',11,'',NULL,NULL,0,NULL,0,1,'Reinforced Mode Type',116,1,1,7),(696,'resourceReinforced3Type',11,'',NULL,NULL,0,NULL,0,1,'Reinforced Mode Type',116,1,1,7),(697,'resourceReinforced4Type',11,'',NULL,NULL,0,NULL,0,1,'Reinforced Mode Type',116,1,1,7),(698,'resourceReinforced5Type',11,'',NULL,NULL,0,NULL,0,1,'Reinforced Mode Type',116,1,1,7),(699,'resourceReinforced1Quantity',4,'',NULL,NULL,0,NULL,0,1,'Reinforced Mode Quantity',9,1,1,7),(700,'resourceReinforced2Quantity',4,'',NULL,NULL,0,NULL,0,1,'Reinforced Mode Quantity',9,1,1,7),(701,'resourceReinforced3Quantity',4,'',NULL,NULL,0,NULL,0,1,'Reinforced Mode Quantity',9,1,1,7),(703,'resourceReinforced4Quantity',4,'',NULL,NULL,0,NULL,0,1,'Reinforced Mode Quantity',9,1,1,7),(704,'resourceReinforced5Quantity',4,'',NULL,NULL,0,NULL,0,1,'Reinforced Mode Quantity',9,1,1,7),(705,'resourceOnline1Type',11,'',NULL,NULL,NULL,NULL,0,1,'Online Mode Type',116,1,1,7),(706,'resourceOnline2Type',11,'',NULL,NULL,0,NULL,0,1,'Online Mode Type',116,1,1,7),(707,'resourceOnline3Type',11,'',NULL,NULL,0,NULL,0,1,'Online Mode Type',116,1,1,7),(708,'resourceOnline4Type',11,'',NULL,NULL,0,NULL,0,1,'Online Mode Type',NULL,1,1,7),(709,'harvesterType',11,'The type of material harvested.',NULL,NULL,0,NULL,0,1,'Harvested Type',116,1,1,7),(710,'harvesterQuality',4,'The quality of the material harvested.',NULL,NULL,0,NULL,0,1,'Harvester Quality',NULL,1,1,7),(711,'moonAnchorDistance',4,'How many meters from the standard warp-in distance a moon can be anchored from.',NULL,NULL,0,NULL,0,1,'Moon Anchor Distance',1,1,1,7),(712,'usageDamagePercent',4,'How much a charge used by this object is damaged each time the object operates.',NULL,NULL,0,NULL,0,1,'Charge Usage Damage',105,1,1,7),(713,'consumptionType',11,'The type of resource needed to be consumed for each activation cycle of this structure.',NULL,NULL,0,NULL,0,1,'Consumption Type',116,1,1,7),(714,'consumptionQuantity',4,'The amount of the given resource type needed to be consumed for each activation cycle of this structure.',NULL,NULL,0,NULL,0,1,'Consumption Quantity',NULL,1,1,7),(715,'maxOperationalDistance',4,'The maximum distance at which the object can be used.',NULL,NULL,0,NULL,0,1,'Maximum Operational Distance',1,1,1,7),(716,'maxOperationalUsers',4,'The maximum number of users that can be present within the operational range of the structure for it to be capable of operation.',NULL,NULL,0,NULL,0,1,'Maximum Concurrent Operational Users',NULL,1,1,7),(717,'refiningYieldMultiplier',5,'The factor by which the structure modifies the using pilot\'s refining yield rate.',NULL,NULL,0,NULL,1,1,'Refining Yield Multiplier',104,1,1,7),(719,'operationalDuration',4,'The amount of time that is taken to refine the ore into the end product.  The structure is busy for the length of this process.',NULL,NULL,0,NULL,0,1,'Operational Duration',101,1,1,7),(720,'refineryCapacity',4,'The capacity of the refinery container.',NULL,NULL,0,NULL,0,1,'Refinery Capacity',9,1,1,1),(721,'refiningDelayMultiplier',5,'The factor by which the character can effect the amount of time that the Refining Delay takes.',NULL,NULL,0,NULL,1,0,'refiningDelayMultiplier',NULL,1,1,9),(722,'posControlTowerPeriod',4,'The interval for fuel consumption of a control tower',NULL,NULL,0,NULL,10000,1,'Starbase Control Tower Period',101,1,1,7),(723,'contrabandDetectionChance',5,'The chance that the customs official has of detecting contraband on board a scanned vessel',NULL,NULL,0,NULL,0,0,'contrabandDetectionChance',NULL,1,1,9),(724,'contrabandDetectionResistance',5,'A modifier to the chance of contraband detection success of police who scan the pilot\'s vessel.',NULL,NULL,0,NULL,0,0,'contrabandDetectionResistance',NULL,1,1,9),(725,'contrabandScanChance',5,'The chance that a passer by will be chosen as a target of a scan for contraband.',NULL,NULL,0,NULL,0,0,'contrabandScanChance',NULL,1,1,9),(726,'moonMiningAmount',4,'',NULL,NULL,0,NULL,1,1,'Moon Mining Amount',9,1,1,9),(727,'destroyerROFpenality',5,'',NULL,NULL,0,NULL,0,0,'destroyerROFpenality',NULL,1,1,9),(728,'controlTowerLaserDamageBonus',5,'',NULL,NULL,0,NULL,0,0,'Laser Sentry Damage Bonus',105,1,1,9),(729,'shipBonusMD1',5,'',NULL,NULL,0,NULL,0,0,'shipBonusMD1',NULL,1,1,9),(732,'shipBonusD1',5,'',NULL,NULL,0,NULL,0,0,'shipBonusD1',NULL,1,1,9),(733,'shipBonusD2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusD2',NULL,1,1,9),(734,'shipBonusCD1',5,'',NULL,NULL,0,NULL,0,0,'shipBonusCD1',NULL,1,1,9),(735,'shipBonusCD2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusCD2',NULL,1,1,9),(738,'shipBonusGD1',5,'',NULL,NULL,0,NULL,0,0,'shipBonusGD1',NULL,1,1,9),(739,'shipBonusGD2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusGD2',NULL,1,1,9),(740,'shipBonusMD2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusMD2',NULL,1,1,9),(741,'shipBonusBC1',5,'',NULL,NULL,0,NULL,0,0,'shipBonusBC1',NULL,1,1,9),(742,'shipBonusBC2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusBC2',NULL,1,1,9),(743,'shipBonusCBC1',5,'',NULL,NULL,0,NULL,0,0,'shipBonusCBC1',NULL,1,1,7),(745,'shipBonusCBC2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusCBC2',NULL,1,1,9),(746,'shipBonusGBC2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusGBC2',NULL,1,1,9),(747,'shipBonusGBC1',5,'',NULL,NULL,0,NULL,0,0,'shipBonusGBC1',NULL,1,1,9),(748,'shipBonusMBC1',5,'',NULL,NULL,0,NULL,0,0,'shipBonusMBC1',NULL,1,1,9),(749,'shipBonusMBC2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusMBC2',NULL,1,1,9),(750,'controlTowerLaserOptimalBonus',5,'',NULL,NULL,0,NULL,0,0,'Laser Sentry Optimal Bonus',105,1,1,9),(751,'controlTowerHybridOptimalBonus',5,'',NULL,NULL,0,NULL,0,1,'Hybrid Sentry Optimal Bonus',105,1,1,7),(752,'controlTowerProjectileOptimalBonus',5,'',NULL,NULL,0,NULL,0,0,'Projectile Sentry Optimal Bonus',105,1,1,9),(753,'controlTowerProjectileFallOffBonus',5,'',NULL,NULL,0,NULL,0,0,'Projectile Sentry Fall Off Bonus',105,1,1,9),(754,'controlTowerProjectileROFBonus',5,'',NULL,NULL,0,NULL,0,0,'Projectile Sentry Rate of Fire Bonus',105,1,1,9),(755,'controlTowerMissileROFBonus',5,'',NULL,NULL,0,NULL,0,0,'Missile Bay Rate of Fire Bonus',105,1,1,9),(756,'controlTowerMoonHarvesterCPUBonus',5,'',NULL,NULL,0,NULL,0,0,'Moon Harvester CPU Bonus',105,1,1,9),(757,'controlTowerSiloCapacityBonus',5,'',NULL,NULL,0,NULL,0,0,'Silo Capacity Bonus',105,1,1,9),(758,'shipBonusDF1',5,'destroyers attribute 1',NULL,NULL,0,NULL,0,0,'shipBonusDF1',NULL,1,1,9),(759,'shipBonusDF2',5,'destroyer attribute 2',NULL,NULL,0,NULL,0,0,'shipBonusDF2',NULL,1,1,9),(760,'controlTowerLaserProximityRangeBonus',5,'',NULL,NULL,0,NULL,0,1,'Laser Sentry Proximity Bonus',105,1,1,7),(761,'controlTowerProjectileProximityRangeBonus',5,'',NULL,NULL,0,NULL,0,1,'Projectile Sentry Proximity Bonus',105,1,1,7),(762,'controlTowerHybridProximityRangeBonus',5,'',NULL,NULL,0,NULL,0,1,'Hybrid Sentry Proximity Bonus',105,1,1,7),(763,'maxGroupActive',4,'Maximum modules of same group that can be activated at same time, 0 = no limit, 1 = 1',NULL,NULL,0,NULL,0,0,'maxGroupActive',NULL,1,1,9),(764,'controlTowerEwRofBonus',5,'',NULL,NULL,0,NULL,0,1,'Target Jamming Duration Bonus',105,1,1,6),(765,'scanRange',5,'Effective range of scanner in multiples of AUs',NULL,NULL,0,NULL,10,1,'Scan Range',NULL,1,1,7),(766,'controlTowerHybridDamageBonus',5,'',NULL,NULL,0,NULL,0,0,'Hybrid Sentry Damage Bonus',105,1,1,9),(767,'trackingSpeedBonus',5,'Tracking Speed Bonus',NULL,NULL,1398,NULL,0,1,'Tracking Speed Bonus',105,1,1,7),(769,'maxRangeBonus2',5,'',NULL,NULL,0,NULL,0,1,'Optimal Range Bonus',105,1,1,6),(770,'controlTowerEwTargetSwitchDelayBonus',5,'Bonus attribute to entity Target Switch Delay',NULL,NULL,0,NULL,0,0,'EW Target Switch Delay Bonus',105,1,1,9),(771,'ammoCapacity',5,'',NULL,NULL,0,NULL,0,0,'Ammo Capacity',NULL,1,1,7),(772,'entityFlyRangeFactor',5,'',NULL,NULL,0,NULL,1,0,'entityFlyRangeFactor',NULL,1,1,9),(773,'shipBonusORE1',5,'ORE mining barge bonus',NULL,NULL,0,NULL,0,0,'shipBonusORE1',NULL,1,1,9),(774,'shipBonusORE2',5,'ORE Mining barge bonus 2',NULL,NULL,0,NULL,0,0,'shipBonusORE2',NULL,1,1,9),(775,'miningCPUNeedBonus',5,'funky stuff for mining barges',NULL,NULL,0,NULL,0,0,'miningCPUNeedBonus',NULL,1,1,9),(776,'structureMissileVelocityBonus',5,'Velocity %bonus for given missile group for missile batteries.',NULL,NULL,0,NULL,0,1,'Missile Velocity Bonus',105,1,1,7),(777,'structureMissileDamageBonus',5,'Damage %bonus for given missile group for missile batteries.',NULL,NULL,0,NULL,0,1,'Missile Damage Bonus',105,1,1,7),(778,'structureMissileExplosionDelayBonus',5,'Exploision Delay (range) bonus for missile batteries',NULL,NULL,0,NULL,0,1,'Missile Explosion Delay Bonus',105,1,1,7),(779,'entityFlyRangeMultiplier',5,'For charges, hidden attribute used by sentry guns to modify target pick range.',NULL,NULL,0,NULL,1,0,'entityFlyRangeMultiplier',NULL,1,1,9),(780,'iceHarvestCycleBonus',5,'',NULL,NULL,0,NULL,0,1,'Cycle Time bonus',105,1,1,7),(781,'specialisationAsteroidGroup',12,'The group at which the mining crystal is tuned to mine.',NULL,NULL,0,NULL,0,1,'Asteroid Specialization Group',115,1,1,7),(782,'specialisationAsteroidYieldMultiplier',5,'The amount the yield is modified when mining the asteroid group this crystal is tuned for.',NULL,NULL,0,NULL,0,1,'Asteroid Specialization Yield Modifier',104,1,1,7),(783,'crystalVolatilityChance',5,'The chance of damage to the crystal each time it is used.',NULL,NULL,0,NULL,0,1,'Volatility',105,1,1,7),(784,'crystalVolatilityDamage',5,'The amount of damage done if the crystal is damaged in the process of using it.',NULL,NULL,0,NULL,0,1,'Volatility Damage',113,1,1,7),(785,'unfitCapCost',5,'The capacitor charge required to disengage this crystal from the unit it is installed in.',NULL,NULL,0,NULL,0,1,'Unfitting Capacitor Cost',114,1,1,7),(786,'crystalsGetDamaged',3,'Whether this tool causes damage to crystals with each use of them.',NULL,NULL,0,NULL,0,1,'Crystals Damage',NULL,1,1,7),(787,'minScanDeviation',5,'Minimum scanning error',NULL,NULL,0,NULL,0,1,'Minimum Scan Deviation',1,1,1,7),(788,'maxScanDeviation',5,'Maximum scan error',NULL,NULL,0,NULL,0,1,'Maximum Scan Deviation',1,1,1,7),(789,'specialtyMiningAmount',5,'',NULL,NULL,0,NULL,0,1,'Specialty Crystal Mining Amount',9,1,1,7),(790,'reprocessingSkillType',11,'The skill required to reprocess this ore type.',NULL,NULL,0,NULL,0,1,'Reprocessing Skill',116,1,1,7),(791,'scanAnalyzeCount',4,'Number of probes needed for an analyzis',NULL,NULL,0,NULL,3,1,'Probes to Analyze',NULL,1,1,7),(792,'controlTowerMissileVelocityBonus',5,'',NULL,NULL,0,NULL,0,0,'Missile Velocity Bonus',105,1,1,9),(793,'shipBonusPirateFaction',5,'Stock Bonus on Pirate Faction Ships.',NULL,NULL,0,NULL,0,0,'shipBonusPirateFaction',NULL,1,1,9),(794,'probesInGroup',4,'Number of probes to analyze',NULL,NULL,0,NULL,3,0,'Probes To Analyze',NULL,1,1,9),(795,'shipBonusABC1',5,'',NULL,NULL,0,NULL,0,0,'shipBonusABC1',NULL,1,1,9),(796,'massAddition',5,'Attribute for adding mass to a ship via an afterburner or MWD.',NULL,NULL,0,NULL,0,1,'Mass Addition',2,1,1,7),(797,'maximumRangeCap',5,'The maximum possible target range.',NULL,NULL,1391,NULL,249999,1,'Theoretical Maximum Targetting Range',1,1,1,7),(798,'entityBracketColour',4,'so far: 0 = white, 1 = red',NULL,NULL,0,NULL,0,0,'entityBracketColour',NULL,1,1,9),(799,'implantSetBloodraider',5,'',NULL,NULL,0,NULL,2,1,'Talisman Set Bonus',104,1,1,7),(800,'contrabandDetectionChanceBonus',5,'Autogenerated skill attribute, contrabandDetectionChanceBonus',NULL,NULL,0,NULL,0,1,'Contraband Detection Modifier',127,1,0,7),(801,'deadspaceUnsafe',5,'Modules with this attribute set to 1 can not be used in deadspace. Modules with this attribute set to 2 can not be used in deadspace even where \"disableModuleBlocking\" is selected',NULL,NULL,0,NULL,0,0,'deadspaceUnsafe',NULL,1,1,9),(802,'implantSetSerpentis',5,'',NULL,NULL,0,NULL,0,1,'Snake Set Bonus',104,1,1,7),(803,'implantSetSerpentis2',5,'',NULL,NULL,0,NULL,0,0,'implantSetSerpentis2',NULL,1,1,9),(804,'eliteBonusInterceptor2',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusInterceptor2',NULL,1,1,9),(805,'quantity',1,'Quantity contained.',NULL,NULL,0,NULL,0,1,'Quantity',NULL,1,1,7),(806,'repairBonus',4,'Autogenerated skill attribute, repairBonus',NULL,NULL,0,NULL,0,1,'Repair Bonus',105,1,1,7),(807,'eliteBonusIndustrial1',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusIndustrial1',NULL,1,1,9),(808,'eliteBonusIndustrial2',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusIndustrial2',NULL,1,1,9),(809,'shipBonusAI2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusAI2',NULL,1,1,9),(811,'shipBonusCI2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusCI2',NULL,1,1,9),(813,'shipBonusGI2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusGI2',NULL,1,1,9),(814,'shipBonusMI2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusMI2',NULL,1,1,9),(815,'propulsionFusionStrengthBonus',5,'Amarr Propulsion Attack Strength for Warp Scramblers etc.',NULL,NULL,0,NULL,0,1,'Fusion Strength',120,1,1,7),(816,'propulsionIonStrengthBonus',5,'Caldari Propulsion Attack Strength for Warp Scramblers etc.',NULL,NULL,0,NULL,0,1,'Ion Strength',120,1,1,7),(817,'propulsionMagpulseStrengthBonus',5,'Gallente Propulsion Attack Strength for Warp Scramblers etc.',NULL,NULL,0,NULL,0,1,'Magpulse Strength',120,1,1,7),(818,'propulsionPlasmaStrengthBonus',5,'Minmatar Propulsion Attack Strength for Warp Scramblers etc.',NULL,NULL,0,NULL,0,1,'Plasma Strength',120,1,1,7),(819,'propulsionFusionStrength',5,'Amarr propulsion strength for ship.',NULL,NULL,2736,NULL,0,1,'Fusion Propulsion Strength',120,1,1,7),(820,'propulsionIonStrength',5,'Caldari propulsion strength for ship.',NULL,NULL,2733,NULL,0,1,'Ion Propulsion Strength',120,1,1,7),(821,'propulsionMagpulseStrength',5,'Gallente propulsion strength for ship.',NULL,NULL,2734,NULL,0,1,'Magpulse Propulsion Strength',120,1,1,7),(822,'propulsionPlasmaStrength',5,'Minmatar propulsion strength for ship.',NULL,NULL,2735,NULL,0,1,'Plasma Propulsion Strength',120,1,1,7),(823,'hitsMissilesOnly',4,'Effect for smartbombs, used to hit missiles only.',NULL,NULL,0,NULL,0,0,'hitsMissilesOnly',NULL,1,1,9),(828,'scanSkillEwStrengthBonus',5,'Skill attribute for increasing strength of EW modules.',NULL,NULL,0,NULL,0,1,'EW Strength Modifier',105,1,1,7),(829,'propulsionSkillPropulsionStrengthBonus',5,'Skill attribute for increasing strength of Propulsion modules.',NULL,NULL,0,NULL,0,0,'propulsionSkillPropulsionStrengthBonus',NULL,1,1,9),(830,'bonusComplexAngel10',5,'Bonus used on Unique Loot in level 10 Angel cartel Deadspace Complexes.',NULL,NULL,0,NULL,5,0,'bonusComplexAngel10',NULL,1,1,9),(831,'ewTargetJam',4,'Used for target jam effects to reduce max locked targets of victem to a negative value to ensure the victem looses its targets, use extreme value',NULL,NULL,0,NULL,0,0,'ewTargetJam',NULL,1,1,9),(832,'scanSkillTargetPaintStrengthBonus',5,'Skill attribute for increasing effectiveness on Target Painters',NULL,NULL,0,NULL,0,1,'Target Painting Bonus',105,1,1,7),(833,'commandBonus',5,'',NULL,NULL,0,NULL,0,1,'Command Bonus',121,1,1,7),(834,'wingCommandBonus',5,'',NULL,NULL,0,NULL,0,0,'WingCommandBonus',NULL,1,1,9),(837,'stealthBomberLauncherPower',5,'Used for stealth bombers to decrease power need on cruise launchers.',NULL,NULL,0,NULL,1,0,'stealthBomberLauncherPower',NULL,1,1,9),(838,'implantSetGuristas',5,'',NULL,NULL,0,NULL,1,1,'Crystal Set Bonus',104,1,1,7),(839,'eliteBonusCoverOps2',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusCoverOps2',NULL,1,1,9),(840,'agentID',4,'agentID to use when initiating NPC communications with this type.',NULL,NULL,0,NULL,0,1,'Agent ID',NULL,1,1,9),(841,'agentCommRange',4,'The range of the agent\'s communication sphere',NULL,NULL,0,NULL,100000,1,'Agent Comm Range',1,1,1,9),(842,'reactionGroup1',12,'',NULL,NULL,0,NULL,0,1,'Reaction Type 1',115,1,1,7),(843,'reactionGroup2',12,'',NULL,NULL,0,NULL,0,1,'Reaction Type 2',115,1,1,7),(844,'agentAutoPopupRange',4,'If the player comes within this range of this agent-in-space, an automatic communication window popup will occur.',NULL,NULL,0,NULL,5000,1,'Agent Auto Popup Range',1,1,1,9),(845,'hiddenLauncherDamageBonus',5,'Hidden Attribute for tech 2 launcher damage bonus.',NULL,NULL,0,NULL,1,0,'hiddenLauncherDamageBonus',NULL,1,1,9),(846,'scanStrengthBonus',5,'',NULL,NULL,0,NULL,0,1,'Scan Strength Bonus',105,1,1,7),(847,'aoeVelocityBonus',5,'Increases velocity of missile explosion',NULL,NULL,1389,NULL,0,1,'Explosion Velocity Bonus',105,1,1,7),(848,'aoeCloudSizeBonus',5,'Booster attribute to explosion radius of missiles vs. signature radius.',NULL,NULL,1390,NULL,0,1,'Explosion Radius Bonus',105,1,1,7),(849,'canUseCargoInSpace',5,'Can use cargo in space or not, 0 = no, 1 = yes',NULL,NULL,0,NULL,1,0,'canUseCargoInSpace',NULL,1,1,9),(850,'squadronCommandBonus',4,'Autogenerated skill attribute, relayCPUBonus',NULL,NULL,0,NULL,0,1,'Squadron Command Bonus',121,1,1,7),(851,'shieldBoostCapacitorBonus',4,'Bonus to capacitor need for shield boosters.',NULL,NULL,0,NULL,0,1,'Capacitor Need Bonus',124,1,1,2),(852,'siegeModeWarpStatus',4,'',NULL,NULL,0,NULL,0,0,'siegeModeWarpStatus',NULL,1,1,9),(853,'advancedAgility',5,'Attribute on ship to make advanced command affect only ships that we want.',NULL,NULL,0,NULL,1,0,'Agility Bonus',NULL,1,1,7),(854,'disallowAssistance',4,'If this module is in use and this attribute is 1, then assistance modules cannot be used on the ship.',NULL,NULL,0,NULL,0,0,'Disallows Assistance',NULL,1,1,9),(855,'activationTargetLoss',4,'Activating this module results in the temporary loss of all targets currently held or being locked.',NULL,NULL,0,NULL,0,0,'Activation Target Loss',NULL,1,1,6),(857,'aoeFalloffBonus',5,'',NULL,NULL,0,NULL,0,0,'Velocity Falloff Bonus',105,1,1,7),(858,'missileEntityAoeCloudSizeMultiplier',5,'Affects the signature radius of the target in missile impact calculations.',NULL,NULL,0,NULL,1,1,'Explosion Radius Bonus',109,1,1,7),(859,'missileEntityAoeVelocityMultiplier',5,'Affects the velocity of the target in missile impact calculations.',NULL,NULL,0,NULL,1,1,'Explosion Velocity Bonus',109,1,1,7),(860,'missileEntityAoeFalloffMultiplier',5,'',NULL,NULL,0,NULL,1,0,'missileEntityAoeFalloffMultiplier',NULL,1,1,9),(861,'canJump',4,'1 = ship can use jump drive',NULL,NULL,0,NULL,0,1,'Onboard Jump Drive',NULL,1,1,7),(862,'usageWeighting',5,'The weighting given to this type and its chance of being picked for a grouping.',NULL,NULL,0,NULL,0,0,'usageWeighting',NULL,1,1,9),(863,'implantSetAngel',5,'',NULL,NULL,0,NULL,1,1,'Halo Set Bonus',104,1,1,7),(864,'implantSetSansha',5,'',NULL,NULL,0,NULL,0,1,'Slave Set Bonus',104,1,1,7),(865,'planetAnchorDistance',4,'How many meters from the standard warp-in distance a planet can be anchored from.',NULL,NULL,0,NULL,100000,0,'planetAnchorDistance',1,1,1,9),(866,'jumpDriveConsumptionType',11,'Type that is used for consumption from cargo hold when activating jump drive operation.',NULL,NULL,0,NULL,0,1,'Jump Drive Fuel Need',116,1,1,7),(867,'jumpDriveRange',5,'Range in light years the ship can maximum jump to.',NULL,NULL,1391,NULL,0,1,'Maximum Jump Range',126,1,1,7),(868,'jumpDriveConsumptionAmount',5,'Number of units it consumes per light year.',NULL,NULL,0,NULL,0,1,'Jump Drive Consumption Amount',NULL,1,1,7),(869,'jumpDriveDuration',4,'The amount of time before the ship actually jumps.',NULL,NULL,0,NULL,300000,0,'jumpDriveDuration',NULL,1,1,9),(870,'jumpDriveRangeBonus',4,'Jump range bonus for jump drive operation.',NULL,NULL,0,NULL,0,1,'Jump Drive Range Bonus',105,1,1,7),(871,'jumpDriveDurationBonus',4,'Skill bonus attribute that decreases the duration before iniating a jump.',NULL,NULL,0,NULL,0,0,'Jump Drive Duration Bonus',105,1,1,9),(872,'disallowOffensiveModifiers',4,'(Buffer)',NULL,NULL,0,NULL,0,0,'Disallows Offensive Modifiers',NULL,1,1,9),(874,'advancedCapitalAgility',5,'',NULL,NULL,0,NULL,1,0,'advancedCapitalAgility',NULL,1,1,9),(875,'dreadnoughtShipBonusA1',5,'',NULL,NULL,0,NULL,0,0,'dreadnoughtShipBonusA1',NULL,1,1,9),(876,'dreadnoughtShipBonusA2',5,'',NULL,NULL,0,NULL,0,0,'dreadnoughtShipBonusA2',NULL,1,1,9),(877,'dreadnoughtShipBonusC1',5,'',NULL,NULL,0,NULL,0,0,'dreadnoughtShipBonusC1',NULL,1,1,9),(878,'dreadnoughtShipBonusC2',5,'',NULL,NULL,0,NULL,0,0,'dreadnoughtShipBonusC2',NULL,1,1,9),(879,'dreadnoughtShipBonusG1',5,'',NULL,NULL,0,NULL,0,0,'dreadnoughtShipBonusG1',NULL,1,1,9),(880,'dreadnoughtShipBonusG2',5,'',NULL,NULL,0,NULL,0,0,'dreadnoughtShipBonusG2',NULL,1,1,9),(881,'dreadnoughtShipBonusM1',5,'',NULL,NULL,0,NULL,0,0,'dreadnoughtShipBonusM1',NULL,1,1,9),(882,'dreadnoughtShipBonusM2',5,'',NULL,NULL,0,NULL,0,0,'dreadnoughtShipBonusM2',NULL,1,1,9),(884,'mindlinkBonus',5,'',NULL,NULL,0,NULL,0,1,'Mindlink Bonus',105,1,1,7),(885,'consumptionQuantityBonus',4,'',NULL,NULL,0,NULL,0,1,'Consumption Quantity Bonus',NULL,1,1,7),(886,'freighterBonusA1',5,'',NULL,NULL,0,NULL,0,0,'freighterBonusA1',NULL,1,1,9),(887,'freighterBonusA2',5,'',NULL,NULL,0,NULL,0,0,'freighterBonusA2',NULL,1,1,9),(888,'freighterBonusC1',5,'',NULL,NULL,0,NULL,0,0,'freighterBonusC1',NULL,1,1,9),(889,'freighterBonusC2',5,'',NULL,NULL,0,NULL,0,0,'freighterBonusC2',NULL,1,1,9),(890,'freighterBonusG2',5,'',NULL,NULL,0,NULL,0,0,'freighterBonusG2',NULL,1,1,9),(891,'freighterBonusG1',5,'',NULL,NULL,0,NULL,0,0,'freighterBonusG1',NULL,1,1,9),(892,'freighterBonusM1',5,'',NULL,NULL,0,NULL,0,0,'freighterBonusM1',NULL,1,1,9),(893,'freighterBonusM2',5,'',NULL,NULL,0,NULL,0,0,'freighterBonusM2',NULL,1,1,9),(894,'speedBoostBonus',5,'Testing for fuels for speed boosters.',NULL,NULL,0,NULL,0,1,'Speed Boost Bonus',105,1,1,7),(895,'armorDamageAmountBonus',5,'Bonus attribute for armor repair amount.',NULL,NULL,80,NULL,0,1,'Armor Repair Bonus',105,1,1,7),(896,'armorDamageDurationBonus',5,'',NULL,NULL,1392,NULL,0,1,'Armor Repair Duration Bonus',105,1,1,7),(897,'shieldBonusDurationBonus',5,'',NULL,NULL,1392,NULL,0,1,'Shield Boost Duration Bonus',105,1,1,2),(898,'jumpDriveCapacitorNeed',5,'Minimum capacitor need for jump drive operation from full capacitor in modifier%.',NULL,NULL,1032,NULL,1,1,'Jump Drive Capacitor Need',127,1,1,7),(899,'jumpDriveCapacitorNeedBonus',5,'',NULL,NULL,1032,NULL,0,1,'Jump Drive Capacitor Need Bonus',105,1,1,7),(901,'accessDifficulty',5,'The difficulty in opening this object.',NULL,NULL,0,NULL,0,1,'Access Difficulty',NULL,1,1,7),(902,'accessDifficultyBonus',5,'Bonus to chance of opening a container.',NULL,NULL,0,NULL,0,1,'Access Difficulty Bonus',121,1,1,7),(903,'spawnWithoutGuardsToo',5,'Whether a spawn container should refill itself when there are no guards assigned to it.',NULL,NULL,0,NULL,0,0,'spawnWithoutGuardsToo',NULL,1,1,9),(904,'warcruiserCPUBonus',5,'',NULL,NULL,0,NULL,0,0,'warcruiserCPUBonus',NULL,1,1,9),(905,'tacklerBonus',4,'',NULL,NULL,0,NULL,10,0,'tacklerBonus',NULL,1,1,9),(906,'disallowEarlyDeactivation',3,'Signifies that this module if activated, will prevent ejection from the ship it is fitted to and extend the log out ship removal timer.',NULL,NULL,0,NULL,0,0,'disallowEarlyDeactivation',NULL,1,1,9),(907,'hasShipMaintenanceBay',3,'Indicates whether a ship type has a ship maintenance bay.',NULL,NULL,0,NULL,0,0,'hasShipMaintenanceBay',NULL,1,1,9),(908,'shipMaintenanceBayCapacity',5,'The capacity of the hangar in a ship.',NULL,NULL,71,NULL,0,1,'Ship Maintenance Bay Capacity',9,1,1,7),(909,'maxShipGroupActiveID',12,'Which group of modules that this ship limits the number of concurrent activations of.',NULL,NULL,0,NULL,0,0,'maxShipGroupActiveID',NULL,1,1,9),(910,'maxShipGroupActive',4,'The amount of modules belonging to the same group that can be active at the same time.',NULL,NULL,0,NULL,0,1,'Max Group Active',NULL,1,1,7),(911,'hasCorporateHangars',3,'Whether this ship has corporate hangars.',NULL,NULL,0,NULL,0,0,'hasCorporateHangars',NULL,1,1,9),(912,'corporateHangarCapacity',5,'The capacity of each hangar.',NULL,NULL,71,NULL,0,1,'Corporate Hangar Capacity',9,1,1,4),(913,'gallenteNavyBonus',5,'',NULL,NULL,0,NULL,0,0,'gallenteNavyBonus',NULL,1,1,9),(914,'gallenteNavyBonusMultiplier',5,'',NULL,NULL,0,NULL,0,0,'gallenteNavyBonusMultiplier',NULL,1,1,9),(915,'caldariNavyBonus',5,'',NULL,NULL,0,NULL,0,0,'caldariNavyBonus',NULL,1,1,9),(916,'caldariNavyBonusMultiplier',5,'',NULL,NULL,0,NULL,0,0,'caldariNavyBonusMultiplier',NULL,1,1,9),(917,'amarrNavyBonus',5,'',NULL,NULL,0,NULL,0,0,'amarrNavyBonus',NULL,1,1,9),(918,'amarrNavyBonusMulitplier',5,'',NULL,NULL,0,NULL,0,0,'amarrNavyBonusMulitplier',NULL,1,1,9),(919,'republicFleetBonus',5,'',NULL,NULL,0,NULL,0,0,'republicFleetBonus',NULL,1,1,9),(920,'republicFleetBonusMultiplier',5,'',NULL,NULL,0,NULL,0,0,'republicFleetBonusMultiplier',NULL,1,1,9),(921,'oreCompression',3,'',NULL,NULL,0,NULL,0,0,'oreCompression',NULL,1,1,9),(924,'eliteBonusBarge1',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusBarge1',NULL,1,1,9),(925,'eliteBonusBarge2',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusBarge2',NULL,1,1,9),(926,'shipBonusORE3',5,'ORE Mining Barge bonus 3',NULL,NULL,0,NULL,0,0,'shipBonusORE3',NULL,1,1,9),(927,'miningUpgradeCPUReductionBonus',5,'',NULL,NULL,0,NULL,0,0,'miningUpgradeCPUReductionBonus',NULL,1,1,9),(928,'entityTargetJam',5,'Target Jam multiplier on max locked targets for NPCs',NULL,NULL,0,NULL,1,0,'entityTargetJam',NULL,1,1,9),(929,'entityTargetJamDuration',4,'Duration of NPC effect',NULL,NULL,0,NULL,30000,0,'entityTargetJamDuration',NULL,1,1,9),(930,'entityTargetJamDurationChance',5,'Chance of NPC effect to be activated each duration',NULL,NULL,0,NULL,0,0,'entityTargetJamDurationChance',NULL,1,1,9),(931,'entityCapacitorDrainDurationChance',5,'Chance of NPC effect to be activated each duration',NULL,NULL,0,NULL,0,0,'entityCapacitorDrainDurationChance',NULL,1,1,9),(932,'entitySensorDampenDurationChance',5,'Chance of NPC effect to be activated each duration',NULL,NULL,0,NULL,0,0,'entitySensorDampenDurationChance',NULL,1,1,9),(933,'entityTrackingDisruptDurationChance',5,'Chance of NPC effect to be activated each duration',NULL,NULL,0,NULL,0,0,'entityTrackingDisruptDurationChance',NULL,1,1,9),(935,'entityTargetPaintDurationChance',5,'Chance of NPC effect to be activated each duration',NULL,NULL,0,NULL,0,0,'entityTargetPaintDurationChance',NULL,1,1,9),(936,'entityTargetJamMaxRange',4,'Max Range for NPC Target Jam',NULL,NULL,0,NULL,0,0,'entityTargetJamActivationRange',NULL,1,1,9),(937,'entityCapacitorDrainMaxRange',4,'Range for NPC capacitor drain',NULL,NULL,0,NULL,0,0,'entityCapacitorDrainActivationRange',NULL,1,1,9),(938,'entitySensorDampenMaxRange',4,'Range from target for when the NPC activates the effect',NULL,NULL,0,NULL,0,0,'entitySensorDampenActivationRange',NULL,1,1,9),(940,'entityTrackingDisruptMaxRange',4,'Max range from for NPC tracking disrupt',NULL,NULL,0,NULL,0,0,'entityTrackingDisruptActivationRange',NULL,1,1,9),(941,'entityTargetPaintMaxRange',4,'Max Range for NPC Target Paint',NULL,NULL,0,NULL,0,0,'entityTargetPaintActivationRange',NULL,1,1,9),(942,'entityCapacitorDrainDuration',4,'Duration of NPC effect',NULL,NULL,0,NULL,30000,0,'entityCapacitorDrainDuration',NULL,1,1,9),(943,'entitySensorDampenDuration',4,'Duration of NPC effect',NULL,NULL,0,NULL,30000,0,'entitySensorDampenDuration',NULL,1,1,9),(944,'entityTrackingDisruptDuration',4,'Duration of NPC effect',NULL,NULL,0,NULL,30000,0,'entityTrackingDisruptDuration',NULL,1,1,9),(945,'entityTargetPaintDuration',4,'Duration of NPC effect',NULL,NULL,0,NULL,30000,0,'entityTargetPaintDuration',NULL,1,1,9),(946,'entityCapacitorDrainAmount',4,'Amount of capacitor drained by NPC from target',NULL,NULL,0,NULL,0,0,'entityCapacitorDrainAmount',NULL,1,1,9),(947,'entitySensorDampenMultiplier',5,'Multiplier on max target range and scan resolution of target ship done by NPC',NULL,NULL,0,NULL,1,0,'entitySensorDampenMultiplier',NULL,1,1,9),(948,'entityTrackingDisruptMultiplier',5,'Multiplier on tracking speed and optimal range of player turrets done by NPC',NULL,NULL,0,NULL,1,0,'entityTrackingDisruptMultiplier',NULL,1,1,9),(949,'entityTargetPaintMultiplier',5,'Multiplier on signature radius of player ship done by NPC',NULL,NULL,0,NULL,1,0,'entityTargetPaintMultiplier',NULL,1,1,9),(950,'entitySensorDampenFallOff',4,'Fall Off for NPC sensor dampen',NULL,NULL,0,NULL,0,0,'entitySensorDampenFallOff',NULL,1,1,9),(951,'entityTrackingDisruptFallOff',4,'Fall Off for NPC Tracking Disrupt',NULL,NULL,0,NULL,0,0,'entityTrackingDisruptFallOff',NULL,1,1,9),(952,'entityCapacitorFallOff',4,'Fall Off for NPC Capacitor Drain',NULL,NULL,0,NULL,0,0,'entityCapacitorFallOff',NULL,1,1,9),(953,'entityTargetJamFallOff',4,'Fall Off for NPC Target Jam',NULL,NULL,0,NULL,0,0,'entityTargetJamFallOff',NULL,1,1,9),(954,'entityTargetPaintFallOff',4,'Fall Off for NPC Target Paint',NULL,NULL,0,NULL,0,0,'entityTargetPaintFallOff',NULL,1,1,9),(955,'isCaldariNavy',5,'',NULL,NULL,0,NULL,0,0,'isCaldariNavy',NULL,1,1,9),(956,'damageModifierMultiplierBonus',5,'',NULL,NULL,0,NULL,0,0,'damageModifierMultiplierBonus',NULL,1,1,9),(957,'cNavyModOncNavyShip',5,'',NULL,NULL,0,NULL,0,0,'cNavyModOncNavyShip',NULL,1,1,9),(958,'hardeningBonus',5,'Autogenerated skill attribute, hardeningBonus',NULL,NULL,0,NULL,0,1,'Hardening Bonus',105,1,1,7),(959,'entityShieldBoostLargeDelayChance',5,'',NULL,NULL,0,NULL,0,0,'entityShieldBoostLargeDelayChance',NULL,1,1,9),(960,'caldariNavyBonusMultiplier2',5,'',NULL,NULL,0,NULL,0,0,'caldariNavyBonusMultiplier2',NULL,1,1,9),(961,'caldarNavyBonus2',5,'',NULL,NULL,0,NULL,0,0,'caldarNavyBonus2',NULL,1,1,9),(962,'eliteBonusReconShip1',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusReconShip1',NULL,1,1,9),(963,'eliteBonusReconShip2',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusReconShip2',NULL,1,1,9),(964,'passiveEmDamageResonanceMultiplier',5,'',NULL,NULL,1396,NULL,1,0,'Passive EM damage resistance bonus',111,0,0,9),(965,'passiveThermalDamageResonanceMultiplier',5,'',NULL,NULL,1394,NULL,1,0,'Passive Thermal dmg resistance bonus',111,0,0,9),(966,'passiveKineticDamageResonanceMultiplier',5,'',NULL,NULL,1393,NULL,1,0,'Passive Kinetic dmg resistance bonus',111,0,0,9),(967,'passiveExplosiveDamageResonanceMultiplier',5,'',NULL,NULL,1395,NULL,1,0,'Passive Explosive dmg resistance bonus',111,0,0,9),(968,'hasStasisWeb',4,'Used for Probes.',NULL,NULL,0,NULL,0,0,'hasStasisWeb',NULL,1,1,9),(969,'activeEmDamageResonance',5,'',NULL,NULL,1396,NULL,1,0,'Active EM dmg resistance bonus',111,0,0,7),(970,'activeThermalDamageResonance',5,'',NULL,NULL,1394,NULL,1,0,'Active Thermal dmg resistance bonus',111,0,0,7),(971,'activeKineticDamageResonance',5,'',NULL,NULL,1393,NULL,1,0,'Active Kinetic dmg resistance bonus',111,0,0,7),(972,'activeExplosiveDamageResonance',5,'',NULL,NULL,1395,NULL,1,0,'Active Explosive dmg resistance bonus',111,0,0,7),(973,'signatureRadiusBonusPercent',5,'',NULL,NULL,0,NULL,0,1,'Signature radius bonus',105,0,1,7),(974,'hullEmDamageResonance',5,'',1529,NULL,0,NULL,1,1,'Hull Em Damage Resistance',108,1,1,4),(975,'hullExplosiveDamageResonance',5,'',1529,NULL,0,NULL,1,1,'Hull Explosive Damage Resistance',108,1,1,4),(976,'hullKineticDamageResonance',5,'',1529,NULL,0,NULL,1,1,'Hull Kinetic Damage Resistance',108,1,1,4),(977,'hullThermalDamageResonance',5,'',1529,NULL,0,NULL,1,1,'Hull Thermal Damage Resistance',108,1,1,4),(978,'maxGroupOnline',4,'Maximum modules of same group that can be onlined at same time, 0 = no limit, 1 = 1',NULL,NULL,0,NULL,0,0,'maxGroupOnline',NULL,1,1,9),(979,'maxJumpClones',4,'The maximum amount of jump clones that the character may have in existence or ship may have stored.',NULL,NULL,0,NULL,0,1,'Maximum Jump Clones',NULL,1,1,7),(980,'hasCloneJumpSlots',4,'The number of clone jump slots that the ship offers.',NULL,NULL,0,NULL,0,0,'hasCloneJumpSlots',NULL,1,1,9),(981,'allowsCloneJumpsWhenActive',4,'If this module is active and the ship supports it, the ship can serve as a destination for clone jumps.',NULL,NULL,0,NULL,0,0,'allowsCloneJumpsWhenActive',NULL,1,1,9),(982,'canReceiveCloneJumps',4,'Defines whether a ship has the functionality to allow it to receive clone jumps and host jump clones.',NULL,NULL,0,NULL,0,0,'canReceiveCloneJumps',NULL,1,1,9),(983,'signatureRadiusAdd',5,'',NULL,NULL,0,NULL,0,1,'Signature radius bonus',1,1,1,7),(984,'emDamageResistanceBonus',5,'',NULL,NULL,1396,NULL,0,1,'EM dmg resistance bonus',124,0,0,7),(985,'explosiveDamageResistanceBonus',5,'',NULL,NULL,1395,NULL,0,1,'Explosive dmg resistance bonus',124,0,0,7),(986,'kineticDamageResistanceBonus',5,'',NULL,NULL,1393,NULL,0,1,'Kinetic dmg resistance bonus',105,0,0,7),(987,'thermalDamageResistanceBonus',5,'',NULL,NULL,1394,NULL,0,1,'Thermal dmg resistance bonus',124,0,0,7),(988,'hardeningbonus2',5,'',NULL,NULL,0,NULL,0,0,'hardeningbonus2',NULL,1,1,9),(989,'volumePostPercent',5,'',NULL,NULL,0,NULL,0,0,'volumePostPercent',NULL,1,1,9),(990,'activeEmResistanceBonus',5,'',NULL,NULL,0,NULL,0,0,'activeEmResistanceBonus',NULL,1,1,7),(991,'activeExplosiveResistanceBonus',5,'',NULL,NULL,0,NULL,0,0,'activeExplosiveResistanceBonus',NULL,1,1,7),(992,'activeThermicResistanceBonus',5,'',NULL,NULL,0,NULL,0,0,'activeThermicResistanceBonus',NULL,1,1,7),(993,'activeKineticResistanceBonus',5,'',NULL,NULL,0,NULL,0,0,'activeKineticResistanceBonus',NULL,1,1,7),(994,'passiveEmDamageResistanceBonus',5,'',NULL,NULL,1396,NULL,0,1,'Passive EM dmg resistance bonus',105,0,0,7),(995,'passiveExplosiveDamageResistanceBonus',5,'',NULL,NULL,1395,NULL,0,1,'Passive Explosive dmg resistance bonus',105,0,0,7),(996,'passiveKineticDamageResistanceBonus',5,'',NULL,NULL,1393,NULL,0,1,'Passive kinetic dmg resistance bonus',105,0,0,7),(997,'passiveThermicDamageResistanceBonus',5,'',NULL,NULL,1394,NULL,0,1,'Passive thermal dmg resistance bonus',105,0,0,7),(998,'isRAMcompatible',3,'Can have research and manufacturing functionality',NULL,NULL,0,NULL,0,0,'Research and Manufacturing Compatible',NULL,1,1,9),(999,'eliteBonusCommandShips2',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusCommandShips2',NULL,1,1,9),(1000,'eliteBonusCommandShips1',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusCommandShips1',NULL,1,1,9),(1001,'jumpPortalConsumptionMassFactor',5,'Multiplier used to calculate amount of quantity used for jumping via portals based on mass of ship.',NULL,NULL,0,NULL,0,0,'jumpPortalConsumptionMassFactor',NULL,1,1,9),(1002,'jumpPortalDuration',4,'',NULL,NULL,0,NULL,300000,0,'Jump Portal Activation Time / Duration',101,1,1,9),(1003,'eliteBonusCommandShip1DONOTUSE',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusCommandShip1',NULL,1,1,9),(1004,'eliteBonusCommandShip2DONOTUSE',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusCommandShip2',NULL,1,1,9),(1005,'jumpPortalCapacitorNeed',5,'',NULL,NULL,1032,NULL,0,1,'Jump portal activation cost',114,1,1,7),(1006,'entityShieldBoostDelayChanceSmall',5,'',NULL,NULL,0,NULL,0,0,'entityShieldBoostDelayChanceSmall',NULL,1,1,9),(1007,'entityShieldBoostDelayChanceMedium',5,'',NULL,NULL,0,NULL,0,0,'entityShieldBoostDelayChanceMedium',NULL,1,1,9),(1008,'entityShieldBoostDelayChanceLarge',5,'',NULL,NULL,0,NULL,0,0,'entityShieldBoostDelayChanceLarge',NULL,1,1,9),(1009,'entityArmorRepairDelayChanceSmall',5,'',NULL,NULL,0,NULL,0,0,'entityArmorRepairDelayChanceSmall',NULL,1,1,9),(1010,'entityArmorRepairDelayChanceMedium',5,'',NULL,NULL,0,NULL,0,0,'entityArmorRepairDelayChanceMedium',NULL,1,1,9),(1011,'entityArmorRepairDelayChanceLarge',5,'',NULL,NULL,0,NULL,0,0,'entityArmorRepairDelayChanceLarge',NULL,1,1,9),(1012,'eliteBonusInterdictors1',5,'eliteBonusInterdictors1',NULL,NULL,0,NULL,0,0,'eliteBonusInterdictors1',NULL,1,1,9),(1013,'eliteBonusInterdictors2',5,'eliteBonusInterdictors2',NULL,NULL,0,NULL,0,0,'eliteBonusInterdictors2',NULL,1,1,9),(1014,'disallowRepeatingActivation',4,'If set, this module cannot be activated and made to autorepeat.',NULL,NULL,0,NULL,0,1,'Can Not Auto Repeat',NULL,1,1,7),(1015,'entityShieldBoostDelayChanceSmallMultiplier',5,'',NULL,NULL,0,NULL,1,0,'entityShieldBoostDelayChanceSmallMultiplier',NULL,1,1,9),(1016,'entityShieldBoostDelayChanceMediumMultiplier',5,'',NULL,NULL,0,NULL,1,0,'entityShieldBoostDelayChanceMediumMultiplier',NULL,1,1,9),(1017,'entityShieldBoostDelayChanceLargeMultiplier',5,'',NULL,NULL,0,NULL,1,0,'entityShieldBoostDelayChanceLargeMultiplier',NULL,1,1,9),(1018,'entityArmorRepairDelayChanceSmallMultiplier',5,'',NULL,NULL,0,NULL,1,0,'entityArmorRepairDelayChanceSmallMultiplier',NULL,1,1,9),(1019,'entityArmorRepairDelayChanceMediumMultiplier',5,'',NULL,NULL,0,NULL,1,0,'entityArmorRepairDelayChanceMediumMultiplier',NULL,1,1,9),(1020,'entityArmorRepairDelayChanceLargeMultiplier',5,'',NULL,NULL,0,NULL,1,0,'entityArmorRepairDelayChanceLargeMultiplier',NULL,1,1,9),(1021,'warpAccuracyMaxRange',5,'',NULL,NULL,0,NULL,15000,0,'warpAccuracyMaxRange',NULL,1,1,9),(1022,'warpAccuracyFactor',5,'',NULL,NULL,0,NULL,1,0,'warpAccuracyFactor',NULL,1,1,9),(1023,'warpAccuracyFactorMultiplier',5,'',NULL,NULL,0,NULL,1,0,'warpAccuracyFactorMultiplier',NULL,1,1,9),(1024,'warpAccuracyMaxRangeMultiplier',5,'',NULL,NULL,0,NULL,1,0,'warpAccuracyMaxRangeMultiplier',NULL,1,1,9),(1025,'warpAccuracyFactorPercentage',5,'',NULL,NULL,0,NULL,0,0,'warpAccuracyFactorPercentage',NULL,1,1,9),(1026,'warpAccuracyMaxRangePercentage',5,'',NULL,NULL,0,NULL,0,0,'warpAccuracyMaxRangePercentage',NULL,1,1,9),(1027,'scanGravimetricStrengthPercent',5,'',NULL,NULL,0,NULL,0,1,'Gravimetric Strength',105,1,1,7),(1028,'scanLadarStrengthPercent',5,'',NULL,NULL,0,NULL,0,1,'Ladar Strength',105,1,1,7),(1029,'scanMagnetometricStrengthPercent',5,'',NULL,NULL,0,NULL,0,1,'Magnetometric Strength',105,1,1,7),(1030,'scanRadarStrengthPercent',5,'',NULL,NULL,0,NULL,0,1,'Radar Strength',105,1,1,7),(1031,'controlTowerSize',3,'numeric classification for tower size\n',NULL,NULL,0,NULL,1,1,'Control Tower Size',117,1,1,7),(1032,'anchoringSecurityLevelMax',5,'The maximum security level at which the structure can be anchored.',NULL,NULL,0,NULL,1,1,'Restricted Security Level',NULL,1,1,7),(1033,'anchoringRequiresSovereignty',4,'Whether the structure requires the anchorers alliance to hold sovereignty in the system for it to be anchorable.  Only enforced if the security level is 0.4 or less.',NULL,NULL,0,NULL,0,0,'anchoringRequiresSovereignty',NULL,1,1,9),(1034,'covertOpsAndReconOpsCloakModuleDelay',5,'',NULL,NULL,0,NULL,30000,1,'covertOpsStealthBomberCloakModuleDelay',101,0,1,7),(1035,'covertOpsStealthBomberTargettingDelay',5,'',NULL,NULL,0,NULL,20000,0,'covertOpsStealthBomberTargettingDelay',101,1,1,9),(1036,'titanAmarrBonus1',5,'',NULL,NULL,0,NULL,0,0,'titanAmarrBonus1',NULL,1,1,9),(1038,'titanAmarrBonus2',5,'',NULL,NULL,0,NULL,0,0,'titanAmarrBonus2',NULL,1,1,7),(1039,'titanCaldariBonus1',5,'',NULL,NULL,0,NULL,0,0,'titanCaldariBonus1',NULL,1,1,9),(1040,'titanCaldariBonus2',5,'',NULL,NULL,0,NULL,0,0,'titanCaldariBonus2',NULL,1,1,9),(1041,'titanGallenteBonus1',5,'',NULL,NULL,0,NULL,0,0,'titanGallenteBonus1',NULL,1,1,9),(1042,'titanGallenteBonus2',5,'',NULL,NULL,0,NULL,0,0,'titanGallenteBonus2',NULL,1,1,9),(1043,'titanMinmatarBonus1',5,'',NULL,NULL,0,NULL,0,0,'titanMinmatarBonus1',NULL,1,1,9),(1044,'titanMinmatarBonus2',5,'',NULL,NULL,0,NULL,0,0,'titanMinmatarBonus2',NULL,1,1,9),(1045,'maxTractorVelocity',5,'The maximum speed that the tractor beam draws objects closer at.',NULL,NULL,0,NULL,0,1,'Max Tractor Velocity',10,1,1,7),(1047,'canNotBeTrainedOnTrial',4,'If set to 1 on a skill then this skill can not be trained on accounts that are marked as Trial.',NULL,NULL,0,NULL,0,0,'canNotBeTrainedOnTrial',NULL,1,1,9),(1048,'disallowOffensiveModifierBonus',5,'',NULL,NULL,0,NULL,0,0,'disallowOffensiveModifierBonus',NULL,1,1,9),(1049,'carrierAmarrBonus1',5,'',NULL,NULL,0,NULL,0,0,'carrierAmarrBonus1',NULL,1,1,9),(1050,'carrierAmarrBonus2',5,'',NULL,NULL,0,NULL,0,0,'carrierAmarrBonus2',NULL,1,1,9),(1051,'carrierAmarrBonus3',5,'',NULL,NULL,0,NULL,0,0,'carrierAmarrBonus3',NULL,1,1,9),(1052,'carrierCaldariBonus1',5,'',NULL,NULL,0,NULL,0,0,'carrierCaldariBonus1',NULL,1,1,9),(1053,'carrierCaldariBonus2',5,'',NULL,NULL,0,NULL,0,0,'carrierCaldariBonus2',NULL,1,1,9),(1054,'carrierCaldariBonus3',5,'',NULL,NULL,0,NULL,0,0,'carrierCaldariBonus3',NULL,1,1,9),(1055,'carrierGallenteBonus1',5,'',NULL,NULL,0,NULL,0,0,'carrierGallenteBonus1',NULL,1,1,9),(1056,'carrierGallenteBonus2',5,'',NULL,NULL,0,NULL,0,0,'carrierGallenteBonus2',NULL,1,1,9),(1057,'carrierGallenteBonus3',5,'',NULL,NULL,0,NULL,0,0,'carrierGallenteBonus3',NULL,1,1,9),(1058,'carrierMinmatarBonus1',5,'',NULL,NULL,0,NULL,0,0,'carrierMinmatarBonus1',NULL,1,1,9),(1059,'carrierMinmatarBonus2',5,'',NULL,NULL,0,NULL,0,0,'carrierMinmatarBonus2',NULL,1,1,9),(1060,'carrierMinmatarBonus3',5,'',NULL,NULL,0,NULL,0,0,'carrierMinmatarBonus3',NULL,1,1,9),(1061,'titanAmarrBonus3',5,'',NULL,NULL,0,NULL,0,0,'titanAmarrBonus3',NULL,1,1,9),(1062,'titanAmarrBonus4',5,'',NULL,NULL,0,NULL,0,0,'titanAmarrBonus4',NULL,1,1,9),(1063,'titanCaldariBonus3',5,'',NULL,NULL,0,NULL,0,0,'titanCaldariBonus3',NULL,1,1,9),(1064,'titanCaldariBonus4',5,'',NULL,NULL,0,NULL,0,0,'titanCaldariBonus4',NULL,1,1,9),(1065,'titanGallenteBonus3',5,'',NULL,NULL,0,NULL,0,0,'titanGallenteBonus3',NULL,1,1,9),(1066,'titanGallenteBonus4',5,'',NULL,NULL,0,NULL,0,0,'titanGallenteBonus4',NULL,1,1,9),(1067,'titanMinmatarBonus4',5,'',NULL,NULL,0,NULL,0,0,'titanMinmatarBonus4',NULL,1,1,9),(1068,'titanMinmatarBonus3',5,'',NULL,NULL,0,NULL,0,0,'titanMinmatarBonus3',NULL,1,1,9),(1069,'carrierAmarrBonus4',5,'',NULL,NULL,0,NULL,0,0,'carrierAmarrBonus4',NULL,1,1,9),(1070,'carrierCaldariBonus4',5,'',NULL,NULL,0,NULL,0,0,'carrierCaldariBonus4',NULL,1,1,9),(1071,'carrierGallenteBonus4',5,'',NULL,NULL,0,NULL,0,0,'carrierGallenteBonus4',NULL,1,1,9),(1072,'carrierMinmatarBonus4',5,'',NULL,NULL,0,NULL,0,0,'carrierMinmatarBonus4',NULL,1,1,9),(1073,'maxJumpClonesBonus',4,'',NULL,NULL,0,NULL,0,1,'Clone Bay Bonus',NULL,1,1,7),(1074,'disallowInEmpireSpace',4,'If set on a charge or module type, will prevent it from being activated in empire space.',NULL,NULL,0,NULL,0,0,'disallowInEmpireSpace',NULL,1,1,9),(1075,'missileNeverDoesDamage',4,'If present on a type which is used like a missile, signifies that it should never do damage (whether it has any to do or not).',NULL,NULL,0,NULL,0,0,'missileNeverDoesDamage',NULL,1,1,9),(1076,'implantBonusVelocity',5,'',NULL,NULL,1389,NULL,0,1,'Velocity Modifier',121,1,1,7),(1077,'maxDCUModules',5,'',NULL,NULL,0,NULL,0,1,'Drone Modules',NULL,1,1,10),(1079,'capacitorCapacityBonus',4,'Autogenerated skill attribute, CapacitorCapacityBonus',NULL,NULL,0,NULL,0,1,'Capacitor Modifier',105,1,1,5),(1080,'cpuPenaltySuperWeapon',5,'',NULL,NULL,0,NULL,0,0,'cpuPenaltySuperWeapon',NULL,1,1,9),(1081,'cpuBonusSuperWeapon',5,'',NULL,NULL,0,NULL,0,0,'cpuBonusSuperWeapon',NULL,1,1,9),(1082,'cpuPenaltyPercent',5,'',NULL,NULL,0,NULL,0,1,'Cpu Penalty',105,1,1,1),(1083,'armorHpBonus2',4,'',NULL,NULL,1383,NULL,0,1,'Armor Hp Bonus',121,1,1,3),(1084,'velocityBonus2',5,'',NULL,NULL,1389,NULL,0,1,'Velocity Modifier',121,1,1,7),(1085,'hasFuelCargo',4,'Module consumption mechanic uses fuel cargo. Ships that have this with value of 1 can have fuel cargo. Need fuelCargoCapacity set as well.',NULL,NULL,0,NULL,0,0,'hasFuelCargo',NULL,1,1,9),(1086,'fuelCargoCapacity',5,'Used for ships that are supposed to be able to use fuel.',NULL,NULL,0,NULL,0,1,'Fuel Cargo Capacity',NULL,1,1,7),(1087,'boosterness',4,'Whether an item is a booster or not.',NULL,NULL,0,NULL,0,1,'Booster Slot',NULL,1,1,7),(1088,'expiryTime',4,'Internally set expiry time for objects which expire, so that the client knows when.',NULL,NULL,0,NULL,0,0,'Expiry Timestamp',NULL,1,1,9),(1089,'boosterEffectChance1',5,'',NULL,NULL,0,NULL,0,1,'Chance of Side Effect',127,1,1,7),(1090,'boosterEffectChance2',5,'',NULL,NULL,0,NULL,0,0,'boosterEffectChance2',127,1,1,9),(1091,'boosterEffectChance3',5,'',NULL,NULL,0,NULL,0,0,'boosterEffectChance3',127,1,1,9),(1092,'boosterEffectChance4',5,'',NULL,NULL,0,NULL,0,0,'boosterEffectChance4',127,1,1,9),(1093,'boosterEffectChance5',5,'',NULL,NULL,0,NULL,0,0,'boosterEffectChance5',127,1,1,9),(1094,'displayCapacitorCapacityBonus',5,'',NULL,NULL,0,NULL,0,1,'Capacitor Capacity Bonus',105,1,1,5),(1095,'displayShieldBoostMultiplier',5,'',NULL,NULL,0,NULL,0,1,'Shield Boost Bonus',105,1,1,2),(1096,'displayShieldCapacityBonus',5,'',NULL,NULL,0,NULL,0,1,'Shield Capacity Bonus',105,1,1,2),(1097,'displayAoeVelocityBonus',5,'',NULL,NULL,0,NULL,0,1,'Explosion Velocity',105,1,1,7),(1098,'displayRangeSkillBonus',5,'',NULL,NULL,0,NULL,0,1,'Optimal Range Bonus',105,1,1,7),(1099,'boosterAttribute1',5,'',NULL,NULL,0,NULL,0,1,'Side Effect Penalty',105,1,1,7),(1100,'boosterAttribute2',5,'',NULL,NULL,0,NULL,0,0,'boosterAttribute2',NULL,1,1,9),(1101,'boosterAttribute3',5,'',NULL,NULL,0,NULL,0,0,'boosterAttribute3',NULL,1,1,9),(1102,'boosterAttribute4',5,'',NULL,NULL,0,NULL,0,0,'boosterAttribute4',NULL,1,1,9),(1103,'boosterAttribute5',5,'',NULL,NULL,0,NULL,0,0,'boosterAttribute5',NULL,1,1,9),(1104,'displayMaxVelocityBonus',5,'',NULL,NULL,0,NULL,0,1,'Max Velocity Bonus',105,1,1,7),(1105,'displayArmorHpBonus',5,'',NULL,NULL,0,NULL,0,1,'Armor HP Penalty',105,1,1,3),(1106,'displayMissileMaxVelocityBonus',5,'',NULL,NULL,0,NULL,0,1,'Missile Max Velocity Bonus',105,1,1,7),(1107,'displayArmorDamageAmountBonus',5,'',NULL,NULL,0,NULL,0,1,'Armor Repaired Bonus',105,1,1,3),(1108,'displayFalloffModifier',5,'',NULL,NULL,0,NULL,0,1,'falloff bonus',105,1,1,7),(1109,'displayTrackingSpeedModifier',5,'',NULL,NULL,0,NULL,0,1,'Tracking Speed bonus',105,1,1,6),(1110,'displayAoeCloudsizeModifier',5,'',NULL,NULL,0,NULL,0,1,'Explosion Cloud Bonus',105,1,1,7),(1111,'displayMaxRangeModifier',5,'',NULL,NULL,0,NULL,0,1,'Optimal Range Bonus',105,1,1,7),(1112,'inventionPropabilityMultiplier',5,'Modifies base chance of successful reverse engineering',NULL,NULL,0,NULL,0,0,'Probability Multiplier',104,1,1,9),(1113,'inventionMEModifier',5,'Modifies the mineral efficiency of invented BPCs',NULL,NULL,0,NULL,0,0,'ME Modifier',120,1,1,9),(1114,'inventionPEModifier',5,'Modifies the production efficiency of reverse engineered BPCS',NULL,NULL,0,NULL,0,0,'PE Modifier',NULL,1,1,9),(1115,'decryptorID',12,'Used to show usable decryptors when starting reverse engineering based on data interface',NULL,NULL,0,NULL,0,0,'decryptorID',NULL,1,1,9),(1116,'scanProbeStrength',5,'The strength of the probe.',NULL,NULL,0,NULL,0,1,'scanProbeStrength',NULL,1,1,7),(1117,'scanStrengthSignatures',5,'',NULL,NULL,0,NULL,0,1,'scanStrengthSignatures',NULL,1,1,7),(1118,'scanStrengthDronesProbes',5,'',NULL,NULL,0,NULL,0,1,'scanStrengthDronesProbes',NULL,1,1,7),(1119,'scanStrengthScrap',5,'',NULL,NULL,0,NULL,0,1,'scanStrengthScrap',NULL,1,1,7),(1120,'scanStrengthShips',5,'',NULL,NULL,0,NULL,0,1,'scanStrengthShips',NULL,1,1,7),(1121,'scanStrengthStructures',5,'',NULL,NULL,0,NULL,0,1,'scanStrengthStructures',NULL,1,1,7),(1122,'maxScanGroups',4,'Max groups that a character can scan for with probes. Default is 0 and max groups will be 5 with a single skill adding 1 per skill level.',NULL,NULL,0,NULL,0,0,'maxScanGroups',NULL,1,1,9),(1123,'scanDuration',4,'How long this probe has to scan until it can obtain results.',NULL,NULL,0,NULL,60000,1,'scanDuration',101,1,1,7),(1124,'inventionMaxRunModifier',5,'Modifies the max runs in a blueprint created through invention',NULL,NULL,0,NULL,0,0,'Max Run Modifier',NULL,1,1,9),(1125,'boosterChanceBonus',5,'',NULL,NULL,0,NULL,0,1,'Negative Side Effect Chance Bonus',105,1,1,7),(1126,'boosterAttributeModifier',5,'',NULL,NULL,0,NULL,0,1,'Side effect Modifier',105,1,1,7),(1127,'interfaceID',11,'Links blueprints to the data interface required to reverse engineer it',NULL,NULL,0,NULL,0,0,'InterfaceID',NULL,1,1,9),(1128,'datacore1ID',11,'Datacore required to reverse engineer this blueprint',NULL,NULL,0,NULL,0,0,'datacore1ID',NULL,1,1,9),(1129,'datacore2ID',11,'Datacore required to reverse engineer this blueprint',NULL,NULL,0,NULL,0,1,'datacore2ID',NULL,1,1,7),(1130,'ecmStrengthBonusPercent',5,'',NULL,NULL,0,NULL,0,1,'Jam Strength Bonus',105,1,1,7),(1131,'massBonusPercentage',5,'',NULL,NULL,409,NULL,0,1,'Mass Reduction',105,1,1,7),(1132,'upgradeCapacity',5,'Attribute on ships used for ship upgrades',NULL,NULL,0,NULL,0,1,'Calibration',120,1,1,7),(1133,'entityMaxVelocitySignatureRadiusMultiplier',5,'Used to increase signature radius of entity when it activates Max Velocity. Used to fake MWD sig radius increase.',NULL,NULL,0,NULL,6,0,'entityMaxVelocitySignatureRadiusMultiplier',NULL,1,1,9),(1134,'maxTargetRangeMultiplierSet',5,'',NULL,NULL,0,NULL,0,0,'maxTargetRangeMultiplierSet',NULL,1,1,9),(1135,'scanResolutionMultiplierSet',5,'',NULL,NULL,0,NULL,0,0,'scanResolutionMultiplierSet',NULL,1,1,9),(1136,'scanAllStrength',5,'Helper attribute for distribution dungeons.',NULL,NULL,0,NULL,0,0,'scanAllStrength',120,1,1,9),(1137,'rigSlots',4,'The number of rig slots on the ship.',NULL,NULL,3266,NULL,0,1,'Rig Slots',122,1,1,1),(1138,'drawback',5,'used on rigs',NULL,NULL,0,NULL,10,1,'Drawback',105,1,1,7),(1139,'rigDrawbackBonus',5,'',NULL,NULL,0,NULL,10,1,'Rig Drawback Reduction',105,1,1,7),(1141,'boosterArmorHPPenalty',5,'',NULL,NULL,0,NULL,0,1,'Armor Hitpoint Penalty',105,1,1,7),(1142,'boosterArmorRepairAmountPenalty',5,'',NULL,NULL,0,NULL,0,1,'Armor Repair Amount Penalty',105,1,1,7),(1143,'boosterShieldCapacityPenalty',5,'',NULL,NULL,0,NULL,0,1,'Shield Capacity Penalty',105,1,1,7),(1144,'boosterTurretOptimalRange',5,'',NULL,NULL,0,NULL,0,1,'Turret Optimal Range Penalty',105,1,1,7),(1145,'boosterTurretTrackingPenalty',3,'',NULL,NULL,0,NULL,0,1,'Turret Tracking Penalty',105,1,1,7),(1146,'boosterTurretFalloffPenalty',5,'',NULL,NULL,0,NULL,0,1,'Turret Falloff Penalty',105,1,1,7),(1147,'boosterAOEVelocityPenalty',5,'',NULL,NULL,0,NULL,0,1,'Explosion Velocity Penalty',105,1,1,7),(1148,'boosterMissileVelocityPenalty',5,'',NULL,NULL,0,NULL,0,1,'Missile Velocity Penalty',105,1,1,7),(1149,'boosterMissileAOECloudPenalty',5,'',NULL,NULL,0,NULL,0,1,'Missile Explosion Cloud Penalty',105,1,1,7),(1150,'boosterCapacitorCapacityPenalty',3,'',NULL,NULL,0,NULL,0,1,'Capacitor Capacity Penalty',105,1,1,7),(1151,'boosterMaxVelocityPenalty',5,'',NULL,NULL,0,NULL,0,1,'Velocity Penalty',105,1,1,7),(1152,'upgradeLoad',5,'How much the upgrades installed on this ship are using of its upgrade capacity.',NULL,NULL,0,NULL,0,1,'upgradeLoad',NULL,1,1,7),(1153,'upgradeCost',5,'How much of the upgrade capacity is used when this is fitted to a ship.',NULL,NULL,0,NULL,0,1,'Calibration cost',NULL,1,1,1),(1154,'upgradeSlotsLeft',4,'How many upgrades can by fitted to this ship.',NULL,NULL,3266,NULL,0,1,'Upgrade Hardpoints',NULL,1,1,7),(1155,'researchPointCost',4,'How much the datacore costs in RPs when being bought from research agents',NULL,NULL,0,NULL,0,1,'RP Cost',120,1,1,7),(1156,'maxScanDeviationModifier',5,'',NULL,NULL,0,NULL,0,1,'Maximum Scan Deviation Modifier',105,1,1,7),(1157,'commandBonus2',5,'',NULL,NULL,0,NULL,0,0,'commandBonus2',NULL,1,1,9),(1158,'untargetable',3,'Attribute to disallow targetting.',NULL,NULL,0,NULL,0,1,'Untargetable',NULL,1,1,7),(1159,'armorHPBonusAdd',5,'',NULL,NULL,0,NULL,0,1,'Armor Hp Bonus',113,1,1,3),(1160,'accessDifficultyBonusModifier',5,'',NULL,NULL,0,NULL,0,1,'Access Difficulty Bonus Modifier',105,1,1,7),(1161,'scanFrequencyResult',4,'Used for the scan frequency probe to give results on scan strength types instead of location. 0 = false, 1 = true',NULL,NULL,0,NULL,0,0,'scanFrequencyResult',NULL,1,1,9),(1162,'explosionDelayWreck',4,'The amount of milliseconds before the wreck dissapears. Note: this only applies to NPC wrecks or empty player wrecks.',NULL,NULL,0,NULL,7200000,0,'explosionDelayWreck',NULL,1,1,9),(1163,'canCloak',4,'',NULL,NULL,0,NULL,1,0,'canCloak',NULL,1,1,9),(1164,'speedFactorBonus',5,'Afterburner and Microwarpdrive Max Velocity Bonus',NULL,NULL,1389,NULL,0,1,'Afterburner and Microwarpdrive Max Velocity Bonus',105,1,1,7),(1165,'controlTowerMinimumDistance',4,'Minimum distance where a starbase structure can be anchored at from the control tower shield extremity in meters.',NULL,1391,0,NULL,0,1,'Minimum Anchoring Distance From Starbase Shield',1,1,1,7),(1167,'posPlayerControlStructure',4,'If a starbase structure has this attribute = 1 then it can be controlled by owners with infrastructure tactical officer skill and corp role.',NULL,NULL,413,NULL,0,1,'Player Controllable',NULL,1,1,7),(1168,'isIncapacitated',0,'Whether an object is incapacitated or not. Boolean.',NULL,NULL,NULL,NULL,0,0,'isIncapacitated',NULL,1,1,9),(1169,'scanGenericStrength',5,'Sensor strength all types',NULL,NULL,0,NULL,0,1,'Generic Sensor Strength',120,0,1,7),(1170,'structureArmorRepairAmount',4,'Amount of armor healed by structure repair effects',NULL,NULL,0,NULL,0,1,'Armor Repair Amount',NULL,1,1,7),(1171,'structureShieldRepairAmount',4,'Amount of shield healed by structure repair effects',NULL,NULL,0,NULL,0,1,'Shield Repair Amount',NULL,1,1,7),(1172,'structureArmorBoostValue',4,'Value modified by remote starbase structure repair effects (should be 0 unless the structure repairs itself)',NULL,NULL,0,NULL,0,0,'Armor Boost Value',NULL,1,1,7),(1173,'structureShieldBoostValue',4,'Value modified by remote starbase structure repair effects (should be 0 unless the structure repairs itself)',NULL,NULL,0,NULL,0,0,'Shield Boost Value',NULL,1,1,9),(1174,'posStructureControlAmount',4,'How many starbase structures a character control.',NULL,NULL,0,NULL,0,1,'posStructureControlAmount',NULL,1,1,7),(1175,'heatHi',5,'',NULL,NULL,0,NULL,0,1,'heatHi',NULL,1,1,7),(1176,'heatMed',5,'',NULL,NULL,0,NULL,0,1,'heatMed',NULL,1,1,7),(1177,'heatLow',5,'',NULL,NULL,0,NULL,0,1,'heatLow',NULL,1,1,7),(1178,'heatCapacityHi',5,'',NULL,NULL,0,NULL,0,0,'heatCapacityHi',NULL,1,1,9),(1179,'heatDissipationRateHi',5,'',NULL,NULL,0,NULL,0,0,'heatDissipationRate',NULL,1,1,9),(1180,'heatAbsorbtionRateModifier',5,'',NULL,NULL,0,NULL,0,0,'heatDissipationRateModifier',NULL,1,1,9),(1181,'overloadDurationBonus',5,'',NULL,NULL,1386,NULL,0,1,'Overload Duration Modifier',105,1,1,7),(1182,'heatAbsorbtionRateHi',5,'',NULL,NULL,0,NULL,0,0,'heatAbsorbtionRateHi',NULL,1,1,9),(1183,'heatAbsorbtionRateMed',5,'',NULL,NULL,0,NULL,0,0,'heatAbsorbtionRateMed',NULL,1,1,9),(1184,'heatAbsorbtionRateLow',5,'',NULL,NULL,0,NULL,0,0,'heatAbsorbtionRateLow',NULL,1,1,9),(1185,'onliningRequiresSovereigntyLevel',4,'Whether the structure requires the onliner\'s alliance to hold sovereignty in the system for it to be onlineable.',NULL,NULL,0,NULL,0,1,'Required Sovereignty Level',NULL,1,1,7),(1186,'remoteArmorDamageAmountBonus',5,'Bonus attribute for remote armor repair amount.',NULL,NULL,80,NULL,0,1,'Remote Armor Repair Bonus',105,1,1,7),(1187,'remoteArmorDamageDurationBonus',5,'Bonus attribute for remote armor repair duration.',NULL,NULL,1392,NULL,0,1,'Remote Armor Repair Duration Bonus',105,1,1,7),(1188,'shieldTransportDurationBonus',5,'Bonus attribute for shield transport duration.',NULL,NULL,1392,NULL,0,1,'Shield Transport Duration Bonus',105,1,1,2),(1189,'shieldTransportAmountBonus',5,'Bonus attribute for shield transport amount.',NULL,NULL,2104,NULL,0,1,'Shield Transport Amount Bonus',105,1,1,2),(1190,'ewCapacitorNeedBonus',5,'Bonus attribute for capacitor need of EW and propulsion jamming.',NULL,NULL,1400,NULL,0,1,'EW Capacitor Need Bonus',105,1,1,7),(1191,'maxDronePercentageBonus',5,'',NULL,NULL,0,NULL,0,1,'Max Active Drone Modifier',105,1,1,7),(1192,'triageCpuNeedBonus',5,'Bonus for CPU requirement of Triage Modules.',NULL,NULL,0,NULL,0,1,'Triage CPU Need Bonus',105,1,1,7),(1193,'projECMDurationBonus',5,'Bonus to duration of modules requiring projected ECM.',NULL,NULL,0,NULL,0,1,'Projected ECM Duration Bonus',105,1,1,7),(1194,'projECMCpuNeedBonus',5,'Bonus for CPU requirement of projected electronic counter measures.',NULL,NULL,0,NULL,0,1,'Projected ECM CPU Need Bonus',105,1,1,7),(1195,'posAnchoredPerSolarSystemAmount',4,'How many structures in this group can be anchored for the same alliance per solar system.  0 means there is no limit.',NULL,NULL,0,NULL,0,1,'Max anchoring amount per solar system',NULL,1,1,7),(1196,'heatDissipationRateMed',5,'',NULL,NULL,0,NULL,0,0,'heatDissipationRateHi',NULL,1,1,9),(1198,'heatDissipationRateLow',5,'',NULL,NULL,0,NULL,0,0,'heatDissipationRateLow',NULL,1,1,9),(1199,'heatCapacityMed',5,'',NULL,NULL,0,NULL,0,0,'heatCapacityMed',NULL,1,1,9),(1200,'heatCapacityLow',5,'',NULL,NULL,0,NULL,0,0,'heatCapacityLow',NULL,1,1,9),(1201,'remoteHullDamageAmountBonus',5,'Bonus attribute for remote hull repair amount.',NULL,NULL,80,NULL,0,1,'Remote Hull Repair Bonus',105,1,1,7),(1202,'remoteHullDamageDurationBonus',5,'Bonus attribute for remote hull repair duration.',NULL,NULL,1392,NULL,0,1,'Remote Hull Repair Duration Bonus',105,1,1,7),(1203,'powerTransferAmountBonus',5,'Bonus attribute for energy transfer amount.',NULL,NULL,1033,NULL,0,1,'Energy Transfer Bonus',105,1,1,7),(1204,'powerTransferDurationBonus',5,'Bonus attribute for energy transfer duration.',NULL,NULL,1392,NULL,0,1,'Energy Transfer Duration Bonus',105,1,1,7),(1205,'overloadRofBonus',5,'',NULL,NULL,1386,NULL,0,1,'Overload rate of fire bonus',105,1,1,7),(1206,'overloadSelfDurationBonus',5,'',NULL,NULL,1386,NULL,0,1,'Overload duration bonus',105,1,1,7),(1207,'isGlobal',4,'',NULL,NULL,0,NULL,0,0,'isGlobal',NULL,1,1,9),(1208,'overloadHardeningBonus',5,'',NULL,NULL,1386,NULL,0,1,'Overload hardening bonus',105,1,1,7),(1209,'bombDeploymentCpuNeedMultiplier',5,'Multiplier to CPU need of modules requireing Bomb Deployment',NULL,NULL,0,NULL,0,1,'Bomb Deployment CPU Bonus',104,1,1,7),(1210,'overloadDamageModifier',5,'',NULL,NULL,1386,NULL,0,1,'Overload damage bonus',105,1,1,7),(1211,'heatDamage',5,'',NULL,NULL,1386,NULL,0,1,'Heat Damage',113,1,1,7),(1212,'requiredThermoDynamicsSkill',4,'',NULL,NULL,0,NULL,0,1,'Required Thermodynamics Level',NULL,1,1,7),(1213,'heatDamageBonus',5,'',NULL,NULL,1386,NULL,0,1,'Heat damage penalty',105,1,1,7),(1214,'posStructureControlDistanceMax',5,'The maximum distance from the control tower, at which structures can be controlled.',NULL,NULL,0,NULL,15000,1,'Maximum Control Distance',1,1,1,7),(1215,'anchoringRequiresSovereigntyLevel',5,'The sovereignty level required for anchoring',NULL,NULL,0,NULL,0,1,'Required Sovereignty Level',NULL,1,1,7),(1216,'shieldTransportCpuNeedBonus',5,'Reduction of CPU need of shield transporters.',NULL,NULL,0,NULL,0,1,'Shield Transport Cpu Need Bonus',105,1,1,2),(1217,'remoteArmorPowerNeedBonus',5,'Reduction of power grid needs of remote armor repair systems.',NULL,NULL,0,NULL,0,1,'Remote Armor Repair Power Need Bonus',105,1,1,7),(1218,'powerTransferPowerNeedBonus',5,'Reduction of power grid needs of energy transfer arrays',NULL,NULL,0,NULL,0,1,'Energy Transfer Array Power Need',105,1,1,7),(1219,'droneArmorDamageAmountBonus',5,'Bonus to drone armor repair amount',NULL,NULL,0,NULL,0,1,'Drone Armor Damage Amount Bonus',105,1,1,10),(1220,'droneShieldBonusBonus',5,'Bonus to drone shield transport amount',NULL,NULL,0,NULL,0,1,'Drone Shield Transport Amount Bonus',105,1,1,10),(1221,'jumpDelayDuration',4,'Delay in seconds; until you can jump again.',NULL,NULL,0,NULL,0,1,'Jump Delay Duration',123,1,1,7),(1222,'overloadRangeBonus',5,'',NULL,NULL,1386,NULL,0,1,'Overload optimal range bonus',105,1,1,7),(1223,'overloadSpeedFactorBonus',5,'',NULL,NULL,1386,NULL,0,1,'Overload Speed Bonus',105,1,1,7),(1224,'heatGenerationMultiplier',5,'',NULL,NULL,0,NULL,1,0,'heatGenerationMultiplier',NULL,1,1,9),(1225,'overloadECMStrengthBonus',5,'',NULL,NULL,1386,NULL,0,1,'Overload ECM Bonus',105,1,1,7),(1226,'overloadECCMStrenghtBonus',5,'',NULL,NULL,1386,NULL,0,1,'Overload ECCM Bonus',105,1,1,7),(1227,'signatureRadiusBonusBonus',5,'Bonus to signatureRadiusBonus',NULL,NULL,1390,NULL,0,1,'Modification of Signature Radius Bonus',105,1,1,7),(1228,'signatureRadiusMultiplierMultiplier',5,'Multiplier affecting signatureRadiusMultiplier',NULL,NULL,0,NULL,0,1,'Signature Radius Multiplier',105,1,1,7),(1229,'thermodynamicsHeatDamage',5,'',NULL,NULL,1386,NULL,0,1,'Heat damage modifier',105,1,1,7),(1230,'overloadArmorDamageAmount',5,'',NULL,NULL,1386,NULL,0,1,'Overload Repair Bonus',105,1,1,7),(1231,'overloadShieldBonus',5,'',NULL,NULL,1386,NULL,0,1,'Overload Shield Boost Bonus',105,1,1,7),(1232,'leechBalanceFactor',5,'',NULL,NULL,0,NULL,1,1,'leechBalanceFactor',NULL,1,1,7),(1233,'capacitySecondary',5,'Secondary cargo space allowed, meant to supplement capacity',NULL,NULL,0,NULL,10000,1,'capacity2',9,1,1,4),(1234,'surveyScannerRangeBonus',5,'Survey Scanner Range Bonus',NULL,NULL,0,NULL,0,1,'surveyScannerRangeBonus',105,1,1,7),(1235,'cargoScannerRangeBonus',5,'Cargo Scanner Range Bonus',NULL,NULL,0,NULL,0,1,'cargoScannerRangeBonus',105,1,1,9),(1236,'commandBonusEffective',5,'commandBonusEffective',NULL,NULL,0,NULL,0,1,'commandBonusEffective',105,1,1,7),(1237,'commandBonusAdd',5,'commandBonusAdd',NULL,NULL,0,NULL,0,1,'commandBonusAdd',NULL,1,1,7),(1238,'commandBonusEffectiveAdd',5,'commandBonusEffectiveAdd',NULL,NULL,0,NULL,0,0,'commandBonusEffectiveAdd',NULL,1,1,9),(1239,'shipBonusORECapital1',5,'shipBonusORECapital1',NULL,NULL,0,NULL,0,1,'shipBonusORECapital1',NULL,1,1,9),(1240,'shipBonusORECapital2',5,'shipBonusORECapital2',NULL,NULL,0,NULL,0,1,'shipBonusORECapital2',NULL,1,1,7),(1241,'1239',4,'Autogenerated skill attribute, 1239',NULL,NULL,0,NULL,0,1,'1239',NULL,1,1,9),(1243,'shipBonusORECapital3',5,'shipBonusORECapital3',NULL,NULL,0,NULL,0,1,'shipBonusORECapital3',NULL,1,1,7),(1244,'shipBonusORECapital4',5,'shipBonusORECapital4',NULL,NULL,0,NULL,0,1,'shipBonusORECapital4',NULL,1,1,7),(1245,'disallowActivateOnWarp',4,'Stops the module from being activated if the ship is aligning to warp.',NULL,NULL,0,NULL,0,1,'Disallow Activation In Warp',NULL,1,1,7),(1246,'eliteBonusHeavyInterdictors1',5,'eliteBonusHeavyInterdictors1',NULL,NULL,0,NULL,0,1,'eliteBonusHeavyInterdictors1',NULL,1,1,7),(1247,'eliteBonusHeavyInterdictors2',5,'eliteBonusHeavyInterdictors2',NULL,NULL,0,NULL,0,1,'eliteBonusHeavyInterdictors2',NULL,1,1,7),(1248,'1246',4,'Autogenerated skill attribute, 1246',NULL,NULL,0,NULL,0,1,'1246',NULL,1,1,9),(1249,'eliteBonusElectronicAttackShip1',5,'eliteBonusElectronicAttackShip1',NULL,NULL,0,NULL,0,1,'eliteBonusElectronicAttackShip1',NULL,1,1,7),(1250,'eliteBonusElectronicAttackShip2',5,'eliteBonusElectronicAttackShip2',NULL,NULL,0,NULL,0,1,'eliteBonusElectronicAttackShip2',NULL,1,1,7),(1251,'securityClearance',5,'Security Clearance Level',NULL,NULL,0,NULL,0,1,'securityClearance',NULL,1,1,7),(1252,'isCovert',5,'',NULL,NULL,0,NULL,0,1,'isCovert',NULL,1,1,7),(1253,'jumpHarmonics',5,'',NULL,NULL,0,NULL,0,1,'Jump Harmonics',NULL,1,1,7),(1254,'canNotUseStargates',4,'',NULL,NULL,0,NULL,0,1,'cantUseStargates',NULL,1,1,7),(1255,'droneDamageBonus',5,'droneDamageBonus',NULL,NULL,0,NULL,0,1,'droneDamageBonus',105,1,1,10),(1256,'droneHPBonus',5,'droneHPBonus',NULL,NULL,0,NULL,0,1,'droneHPBonus',105,1,1,10),(1257,'eliteBonusBlackOps1',5,'eliteBonusBlackOps1',NULL,NULL,0,NULL,0,1,'eliteBonusBlackOps1',NULL,1,1,7),(1258,'eliteBonusBlackOps2',5,'eliteBonusBlackOps2',NULL,NULL,0,NULL,0,1,'eliteBonusBlackOps2',NULL,1,1,7),(1259,'heatAttenuationHi',5,'',NULL,NULL,0,NULL,1,1,'heatAttenuation',NULL,1,1,7),(1261,'heatAttenuationMed',5,'',NULL,NULL,0,NULL,1,1,'heatAttenuationMed',NULL,1,1,7),(1262,'heatAttenuationLow',5,'',NULL,NULL,0,NULL,1,1,'heatAttenuationMed',NULL,1,1,7),(1263,'towerHPOnlineMutator',5,'',NULL,NULL,0,NULL,0,1,'towerHPOnlineMutator',127,1,1,7),(1264,'brokenRepairCostMultiplier',5,'',NULL,NULL,0,NULL,10,0,'brokenRepairCostMultiplier',NULL,1,1,9),(1265,'eliteBonusViolators1',5,'',NULL,NULL,0,NULL,0,1,'eliteBonusViolators1',NULL,1,1,9),(1266,'eliteBonusViolators2',5,'',NULL,NULL,0,NULL,0,1,'eliteBonusViolators2',NULL,1,1,9),(1267,'moduleRepairRate',5,'dictates how many hitpoints you can repair per minute',NULL,NULL,0,NULL,10,1,'moduleRepairRate',NULL,1,1,7),(1268,'eliteBonusViolatorsRole1',5,'',NULL,NULL,0,NULL,0,1,'eliteBonusViolatorsRole1',NULL,1,1,9),(1269,'eliteBonusViolatorsRole2',5,'eliteBonusViolatorsRole2',NULL,NULL,0,NULL,0,1,'eliteBonusViolatorsRole2',NULL,1,1,9),(1270,'speedBoostFactorBonus',5,'Afterburner and Microwarpdrive Thrust Bonus',NULL,NULL,96,NULL,0,1,'Afterburner and Microwarpdrive Thrust Bonus',105,1,1,7),(1271,'droneBandwidth',5,'',NULL,NULL,2987,NULL,0,1,'Drone Bandwidth',128,1,1,10),(1272,'droneBandwidthUsed',5,'',NULL,NULL,2987,NULL,0,1,'Bandwidth Needed',128,1,1,10),(1273,'droneBandwidthLoad',5,'',NULL,NULL,0,NULL,0,1,'droneBandwidthLoad',NULL,1,1,10),(1274,'miningTargetMultiplier',5,'',NULL,NULL,0,NULL,0,1,'Assisted Mining Bonus',111,1,1,7),(1275,'droneIsAgressive',3,'',NULL,NULL,0,NULL,1,1,'droneIsAgressive',NULL,1,1,10),(1276,'nonBrokenModuleRepairCostMultiplier',5,'',NULL,NULL,0,NULL,5,0,'nonBrokenModuleRepairCostMultiplier',NULL,1,1,9),(1277,'shipBrokenModuleRepairCostMultiplier',5,'',NULL,NULL,0,NULL,0.5,1,'shipBrokenModuleRepairCostMultiplier',NULL,1,1,7),(1278,'droneIsChaotic',5,'',NULL,NULL,0,NULL,0,0,'droneIsChaotic',NULL,1,1,10),(1279,'eliteBonusViolatorsRole3',5,'eliteBonusViolatorsRole3',NULL,NULL,0,NULL,0,1,'eliteBonusViolatorsRole3',NULL,1,1,9),(1280,'eliteBonusInterceptorRole',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusInterceptorRole',NULL,1,1,9),(1281,'baseWarpSpeed',5,'Just for the UI to display the ship warp speed.',NULL,NULL,3759,NULL,0,1,'Ship Warp Speed',NULL,1,1,7),(1282,'implantSetThukker',5,'Nomad set bonus attribute',NULL,NULL,0,NULL,1,1,'Nomad Set Bonus',104,1,1,7),(1283,'fightersAttackAndFollow',5,'',NULL,NULL,0,NULL,1,1,'fightersAttackAndFollow',NULL,1,1,7),(1284,'implantSetSisters',5,'Virtue set bonus attribute',NULL,NULL,0,NULL,1,1,'Virtue Set Bonus',104,1,1,7),(1285,'requiredSkill4',11,'The type ID of the skill that is required.',NULL,NULL,0,NULL,0,1,'Quaternary Skill required',116,1,1,8),(1286,'requiredSkill4Level',4,'Required skill level for skill 4',NULL,NULL,0,NULL,0,1,'requiredSkill5Level',NULL,1,1,8),(1287,'requiredSkill5Level',4,'Required skill level for skill 5',NULL,NULL,0,NULL,0,1,'requiredSkill5Level',NULL,1,1,8),(1288,'requiredSkill6Level',4,'Required skill level for skill 6',NULL,NULL,0,NULL,0,1,'requiredSkill6Level',NULL,1,1,8),(1289,'requiredSkill5',11,'The type ID of the skill that is required.',NULL,NULL,0,NULL,0,1,'Quinary Skill required',116,1,1,8),(1290,'requiredSkill6',11,'The type ID of the skill that is required.',NULL,NULL,0,NULL,0,1,'Senary Skill required',116,1,1,8),(1291,'implantSetSyndicate',5,'Edge set bonus attribute',NULL,NULL,0,NULL,1,1,'Edge Set Bonus',104,1,1,7),(1292,'implantSetORE',5,'Harvest set bonus attribute',NULL,NULL,0,NULL,1,1,'Harvest Set Bonus',104,1,1,7),(1293,'implantSetMordus',5,'Centurion set bonus attribute',NULL,NULL,0,NULL,1,1,'Centurion Set Bonus',104,1,1,7),(1294,'shipBrokenRepairCostMultiplierBonus',5,'',NULL,NULL,0,NULL,0,1,'Module Repair Rate Bonus',121,1,1,7),(1295,'moduleRepairRateBonus',5,'',NULL,NULL,0,NULL,0,1,'Module Repair Rate Bonus',105,1,1,7),(1296,'consumptionQuantityBonusPercentage',5,'',NULL,NULL,0,NULL,0,1,'Consumption Quantity Bonus',105,1,1,7),(1297,'droneFocusFire',5,'',NULL,NULL,0,NULL,0,1,'droneFocusFire',NULL,1,1,10),(1298,'canFitShipGroup1',12,'',NULL,NULL,0,NULL,0,1,'Can be fitted to',115,1,1,1),(1299,'canFitShipGroup2',12,'',NULL,NULL,0,NULL,0,1,'Can be fitted to',115,1,1,1),(1300,'canFitShipGroup3',12,'',NULL,NULL,0,NULL,0,1,'Can be fitted to',115,1,1,1),(1301,'canFitShipGroup4',12,'',NULL,NULL,0,NULL,0,1,'Can be fitted to',115,1,1,1),(1302,'canFitShipType1',11,'',NULL,NULL,0,NULL,0,1,'Can be fitted to',116,1,1,1),(1303,'canFitShipType2',11,'',NULL,NULL,0,NULL,0,1,'Can be fitted to',116,1,1,1),(1304,'canFitShipType3',11,'',NULL,NULL,0,NULL,0,1,'Can be fitted to',116,1,1,1),(1305,'canFitShipType4',11,'',NULL,NULL,0,NULL,0,1,'Can be fitted to',116,1,1,1),(1306,'maxRangeMultiplierBonusAdditive',5,'Additive bonus to maxRangeMultiplier',NULL,NULL,0,NULL,0,1,'Max Range Multiplier Bonus',104,1,1,7),(1307,'trackingSpeedMultiplierBonusAdditive',5,'Additive bonus to trackingSpeedMultiplier',NULL,NULL,0,NULL,0,1,'Tracking Speed Multiplier Bonus',104,1,1,7),(1308,'maxTargetRangeMultiplierBonusAdditive',5,'Additive bonus to maxTargetRangeMultiplier',NULL,NULL,0,NULL,0,1,'Max Targeting Range Bonus',104,1,1,6),(1309,'scanResolutionMultiplierBonusAdditive',5,'Additive bonus to scanResolutionMultiplier',NULL,NULL,0,NULL,0,1,'Scan Resolution Bonus',104,1,1,7),(1310,'commandBonusHidden',5,'commandBonusHidden',NULL,NULL,0,NULL,0,0,'Command Bonus Hidden',105,1,1,9),(1311,'eliteBonusJumpFreighter1',5,'eliteBonusJumpFreighter1',NULL,NULL,0,NULL,0,1,'eliteBonusJumpFreighter1',NULL,1,1,9),(1312,'eliteBonusJumpFreighter2',5,'eliteBonusJumpFreighter2',NULL,NULL,0,NULL,0,1,'eliteBonusJumpFreighter2',NULL,1,1,9),(1313,'maxTargetRangeBonusBonus',5,'Bonus to maxTargetRangeBonus',NULL,NULL,1391,NULL,0,1,'Modification of Max Targeting Range Bonus',105,1,1,6),(1314,'scanResolutionBonusBonus',5,'Bonus to scanResolutionBonus',NULL,NULL,74,NULL,0,1,'Modification of Scan Resolution Bonus',105,1,1,7),(1315,'maxRangeBonusBonus',5,'Bonus to maxRangeBonus',NULL,NULL,1391,NULL,0,1,'Modification of Optimal Range Bonus',105,1,1,6),(1316,'trackingSpeedBonusBonus',5,'Bonus to trackingSpeedBonus',NULL,NULL,1398,NULL,0,1,'Modification of Tracking Speed Bonus',105,1,1,7),(1317,'maxRangeHidden',5,'maxRangeHidden',NULL,NULL,0,NULL,0,0,'maxRangeHidden',1,1,1,9),(1318,'warpScrambleStrengthHidden',5,'warpScrambleStrengthHidden',NULL,NULL,0,NULL,0,0,'warpScrambleStrengthHidden',NULL,1,1,9),(1319,'capacitorNeedHidden',5,'capacitorNeedHidden',NULL,NULL,0,NULL,0,0,'capacitorNeedHidden',NULL,1,1,9),(1320,'commandBonusECM',5,'',NULL,NULL,0,NULL,0,1,'ECM Command Bonus',105,1,1,7),(1321,'commandBonusRSD',5,'Remote Sensor Dampening Command Bonus',NULL,NULL,0,NULL,0,1,'Remote Sensor Dampening Command Bonus',105,1,1,7),(1322,'commandBonusTD',5,'Tracking Disruption Command Bonus',NULL,NULL,0,NULL,0,1,'Tracking Disruption Command Bonus',105,1,1,7),(1323,'commandBonusTP',5,'Target Painting Command Bonus',NULL,NULL,0,NULL,0,1,'Target Painting Command Bonus',105,1,1,7),(1324,'massBonusPercentageBonus',5,'Bonus to massBonusPercentage',NULL,NULL,409,NULL,0,1,'Modification of Mass Reduction',105,1,1,7),(1325,'speedBoostFactorBonusBonus',5,'Modification of Afterburner and Microwarpdrive Thrust Bonus',NULL,NULL,96,NULL,0,1,'Modification of Afterburner and Microwarpdrive Thrust Bonus',105,1,1,7),(1326,'speedFactorBonusBonus',5,'Modification of Afterburner and Microwarpdrive Max Velocity Bonus',NULL,NULL,1389,NULL,0,1,'Modification of Afterburner and Microwarpdrive Max Velocity Bonus',105,1,1,7),(1327,'warpScrambleRangeBonus',5,'Warp Scramble Range Bonus',NULL,NULL,1391,NULL,0,1,'Warp Scramble Range Bonus',105,1,1,7),(1328,'droneBandwidthMultiplier',5,'Multiplier on droneBandwidth. The default value should be 0 to ensure that CONCORD NPCs can set the bandwidth of a target ship to 0.',NULL,NULL,2987,NULL,0,1,'droneBandwidthMultiplier',104,1,1,10),(1329,'droneBandwidthBonusAdd',5,'Drone Bandwidth Bonus (additive)',NULL,NULL,0,NULL,0,1,'Drone Bandwidth Bonus',128,1,1,10),(1330,'isHacking',4,'',NULL,NULL,0,NULL,0,0,'isHacking',NULL,1,1,9),(1331,'isArcheology',4,'',NULL,NULL,0,NULL,0,0,'isArcheology',NULL,1,1,9),(1332,'falloffBonusBonus',5,'',NULL,NULL,NULL,NULL,1399,1,'Modification of Falloff Bonus',105,1,1,7),(1333,'maxVelocityLimited',4,'',NULL,NULL,NULL,NULL,0,0,'maxVelocityLimited',NULL,1,1,9),(1334,'maxVelocityActivationLimit',5,'',NULL,NULL,NULL,NULL,0,1,'Max Velocity Limitation',10,1,1,7),(1335,'defenderRaceID',5,'',NULL,NULL,NULL,NULL,0,1,'defenderRaceID',NULL,1,1,9),(1336,'jumpClonesLeft',4,'The remaining number of unused clone vats on the ship that are available for installation of jump clones.',NULL,NULL,NULL,NULL,0,1,'Unused Clone Vats',NULL,1,1,7),(1337,'captureProximityRange',5,'',NULL,NULL,NULL,NULL,0,0,'captureProximityRange',NULL,1,1,9),(1339,'factionDefenderID',4,'',NULL,NULL,NULL,NULL,0,0,'factionDefenderID',NULL,1,1,9),(1340,'factionOffenderID',4,'',NULL,NULL,NULL,NULL,0,0,'factionOffenderID',NULL,1,1,9),(1341,'factionID',4,'',NULL,NULL,NULL,NULL,0,0,'factionID',NULL,1,1,9),(1349,'activationBlocked',4,'Used for blocking activation of modules',NULL,NULL,NULL,NULL,0,0,'activationBlocked',NULL,1,1,7),(1350,'activationBlockedStrenght',4,'',NULL,NULL,NULL,NULL,0,0,'activationBlockedStrenght',NULL,1,1,7),(1351,'posCargobayAcceptType',11,'cargo typeID allowed in structures',NULL,NULL,NULL,NULL,0,1,'Allowed Cargo Type',116,1,1,4),(1352,'posCargobayAcceptGroup',12,'cargo bay container group ID',NULL,NULL,NULL,NULL,0,1,'Allowed Cargo Group',115,1,1,4),(1353,'aoeDamageReductionFactor',5,'',NULL,NULL,NULL,NULL,100,0,'Damage Reduction Factor',NULL,1,1,7),(1354,'aoeDamageReductionSensitivity',5,'',NULL,NULL,NULL,NULL,100,0,'aoeDamageReductionSensitivity',NULL,1,1,7),(1355,'shipOrcaTractorBeamRangeBonus1',5,'bonus to range of tractor beams',NULL,NULL,NULL,NULL,0,1,'Tractor Beam Range Bonus',105,1,1,7),(1356,'shipOrcaCargoBonusOrca1',5,'bonus to ship cargo capacity',NULL,NULL,NULL,NULL,0,1,'shipOrcaCargoBonusOrca1',105,1,1,9),(1357,'shipOrcaTractorBeamVelocityBonus2',5,'',NULL,NULL,NULL,NULL,0,1,'shipOrcaTractorBeamVelocityBonus2',105,1,1,9),(1358,'shipOrcaForemanBonus',5,'',NULL,NULL,NULL,NULL,0,1,'shipOrcaForemanBonus',105,1,1,9),(1359,'shipOrcaSurveyScannerBonus',5,'',NULL,NULL,NULL,NULL,0,1,'shipOrcaSurveyScannerBonus',105,1,1,9),(1360,'shipBonusHPExtender1',5,'',NULL,NULL,NULL,NULL,0,1,'shipBonusHPExtender1',105,1,1,9),(1361,'eliteIndustrialCovertCloakBonus',5,'',NULL,NULL,NULL,NULL,0,1,'eliteIndustrialCovertCloakBonus',105,1,1,9),(1366,'subSystemSlot',4,'',NULL,NULL,NULL,NULL,0,1,'subSystemSlot',NULL,1,1,NULL),(1367,'maxSubSystems',4,'',NULL,NULL,3756,NULL,0,1,'Sub System Slots',NULL,1,1,NULL),(1368,'turretHardPointModifier',4,'',NULL,NULL,361,NULL,0,1,'Turret Hardpoint Modifier',NULL,1,1,NULL),(1369,'launcherHardPointModifier',4,'',NULL,NULL,169,NULL,0,1,'Launcher Hardpoint Modifier',NULL,1,1,NULL),(1370,'baseScanRange',5,'This is the lowest scan range value in AUs for probes under the revised probing system',NULL,NULL,NULL,NULL,0,1,'Base Scan Range (AU)',NULL,1,1,7),(1371,'baseSensorStrength',4,'This is the highest sensor strength in points for probes under the revised probing system',NULL,NULL,NULL,NULL,0,1,'Base Sensor Strength',120,1,1,7),(1372,'baseMaxScanDeviation',5,'This is the lowest maximum scan deviation in AU for probes under the revised probing system',NULL,NULL,NULL,NULL,0,1,'Base Maximum Deviation (AU)',NULL,1,1,7),(1373,'rangeFactor',5,'This is the multiplier/divisor for probe range increases and associated values under the revised probing system',NULL,NULL,NULL,NULL,0,1,'Scan Range Increment Factor',104,1,1,7),(1374,'hiSlotModifier',4,'',NULL,NULL,293,NULL,0,1,'Hi Slot Modifier',NULL,1,1,NULL),(1375,'medSlotModifier',4,'',NULL,NULL,294,NULL,0,1,'Med Slot Modifier',NULL,1,1,NULL),(1376,'lowSlotModifier',4,'',NULL,NULL,295,NULL,0,1,'Low Slot Modifier',NULL,1,1,NULL),(1377,'cpuOutputAdd',4,'CPU output of ship',NULL,NULL,1405,NULL,0,1,'CPU Output',106,1,1,1),(1378,'powerOutputAdd',4,'power output of power core',NULL,NULL,1400,NULL,0,1,'powergrid Output',107,1,1,1),(1379,'maxVelocityAdd',4,'Maximum velocity of ship',NULL,NULL,1389,NULL,0,1,'Max Velocity',11,0,1,4),(1380,'fitsToShipType',11,'',NULL,NULL,1443,NULL,0,1,'Restricted to Ship Type',116,1,1,NULL),(1381,'wormholeTargetSystemClass',4,'Target System Class for wormholes',NULL,NULL,NULL,NULL,0,0,'Target System Class',NULL,1,1,7),(1382,'wormholeMaxStableTime',5,'The maximum amount of time a wormhole will stay open',NULL,NULL,NULL,NULL,0,0,'Maximum Stability Window',3,1,1,7),(1383,'wormholeMaxStableMass',5,'The maximum amount of mass a wormhole can transit before collapsing',NULL,NULL,NULL,NULL,0,0,'Maximum Mass Capacity',2,1,1,7),(1384,'wormholeMassRegeneration',5,'The amount of mass a wormhole regenerates per cycle',NULL,NULL,NULL,NULL,0,0,'Mass Regeneration',2,1,1,7),(1385,'wormholeMaxJumpMass',5,'The maximum amount of mass that can transit a wormhole in one go',NULL,NULL,NULL,NULL,0,0,'Maximum Jumpable Mass',2,1,1,7),(1386,'wormholeTargetRegion1',4,'Specific target region 1 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target Region 1',NULL,1,1,7),(1387,'wormholeTargetRegion2',4,'Specific target region 2 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target Region 2',NULL,1,1,7),(1388,'wormholeTargetRegion3',4,'Specific target region 3 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target Region 3',NULL,1,1,7),(1389,'wormholeTargetRegion4',4,'Specific target region 4 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target Region 4',NULL,1,1,7),(1390,'wormholeTargetRegion5',4,'Specific target region 5 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target Region 5',NULL,1,1,7),(1391,'wormholeTargetRegion6',4,'Specific target region 6 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target Region 6',NULL,1,1,7),(1392,'wormholeTargetRegion7',4,'Specific target region 7 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target Region 7',NULL,1,1,7),(1393,'wormholeTargetRegion8',4,'Specific target region 8 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target Region 8',NULL,1,1,7),(1394,'wormholeTargetRegion9',4,'Specific target region 9 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target Region 9',NULL,1,1,7),(1395,'wormholeTargetConstellation1',5,'Specific target constellation 1 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target Constellation 1',NULL,1,1,7),(1396,'wormholeTargetConstellation2',4,'Specific target constellation 2 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target Constellation 2',NULL,1,1,7),(1397,'wormholeTargetConstellation3',4,'Specific target constellation 3 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target Constellation 3',NULL,1,1,7),(1398,'wormholeTargetConstellation4',4,'Specific target constellation 4 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target Constellation 4',NULL,1,1,7),(1399,'wormholeTargetConstellation5',4,'Specific target constellation 5 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target Constellation 5',NULL,1,1,7),(1400,'wormholeTargetConstellation6',4,'Specific target constellation 6 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target Constellation 6',NULL,1,1,7),(1401,'wormholeTargetConstellation7',4,'Specific target constellation 7 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target Constellation 7',NULL,1,1,7),(1402,'wormholeTargetConstellation8',4,'Specific target constellation 8 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target Constellation 8',NULL,1,1,7),(1403,'wormholeTargetConstellation9',4,'Specific target constellation 9 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target Constellation 9',NULL,1,1,7),(1404,'wormholeTargetSystem1',4,'Specific target system 1 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target System 1',NULL,1,1,7),(1405,'wormholeTargetSystem2',4,'Specific target system 2 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target System 2',NULL,1,1,7),(1406,'wormholeTargetSystem3',4,'Specific target system 3 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target System 3',NULL,1,1,7),(1407,'wormholeTargetSystem4',4,'Specific target system 4 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target System 4',NULL,1,1,7),(1408,'wormholeTargetSystem5',4,'Specific target system 5 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target System 5',NULL,1,1,7),(1409,'wormholeTargetSystem6',4,'Specific target system 6 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target system 6',NULL,1,1,7),(1410,'wormholeTargetSystem7',4,'Specific target system 7 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target System 7',NULL,1,1,7),(1411,'wormholeTargetSystem8',4,'Specific target system 8 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target System 8',NULL,1,1,7),(1412,'wormholeTargetSystem9',4,'Specific target system 9 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target System 9',NULL,1,1,7),(1413,'probeCanScanShips',4,'If this is 1 then the probe can scan for ships, otherwise it can\'t.',NULL,NULL,NULL,NULL,0,0,'Calibrated for starships',NULL,1,1,7),(1414,'evasiveManeuverLevel',4,'The evasive manever level of the type. this will controll what types of evasive manevers a NPC ship will use.',NULL,NULL,NULL,NULL,0,0,'Evasive Maneuver Level',NULL,1,1,7),(1416,'targetSwitchTimer',5,'This controlls the time that must pass between one target switch and another!',NULL,NULL,NULL,NULL,60000,0,'Target Switch Timer',101,1,1,6),(1417,'color',4,'',NULL,NULL,NULL,NULL,0,0,'color',NULL,1,1,NULL),(1418,'passiveArmorEmDamageResonance',5,'',NULL,NULL,1396,NULL,0,1,'Armor Em Damage Resistance',108,1,1,3),(1419,'passiveArmorThermalDamageResonance',5,'',NULL,NULL,1394,NULL,0,1,'Armor Thermic Damage Resistance',108,1,1,3),(1420,'passiveArmorKineticDamageResonance',5,'',NULL,NULL,1393,NULL,0,1,'Armor Kinetic Damage Resistance',108,1,1,3),(1421,'passiveArmorExplosiveDamageResonance',5,'',NULL,NULL,1395,NULL,0,1,'Armor Explosive Damage Resistance',108,1,1,3),(1422,'passiveShieldExplosiveDamageResonance',5,'',NULL,NULL,1395,NULL,0,1,'Shield Explosive Damage Resistance',108,1,1,2),(1423,'passiveShieldEmDamageResonance',5,'',NULL,NULL,1396,NULL,0,1,'Shield Em Damage Resistance',108,1,1,2),(1424,'passiveShieldKineticDamageResonance',5,'',NULL,NULL,1393,NULL,0,1,'Shield Kinetic Damage Resistance',108,1,1,2),(1425,'passiveShieldThermalDamageResonance',5,'',NULL,NULL,1394,NULL,0,1,'Shield Thermal Damage Resistance',108,1,1,2),(1426,'passiveHullEmDamageResonance',5,'',NULL,NULL,NULL,NULL,0,1,'Hull Em Damage Resistance',127,1,1,4),(1427,'passiveHullExplosiveDamageResonance',5,'',NULL,NULL,NULL,NULL,0,1,'Hull Explosive Damage Resistance',127,1,1,4),(1428,'passiveHullKineticDamageResonance',5,'',NULL,NULL,NULL,NULL,0,1,'Hull Kinetic Damage Resistance',127,1,1,4),(1429,'passiveHullThermalDamageResonance',5,'',NULL,NULL,NULL,NULL,0,1,'Hull Thermal Damage Resistance',127,1,1,4),(1430,'lightColor',4,'',NULL,NULL,NULL,NULL,0,0,'Determines color',NULL,1,1,7),(1431,'subsystemBonusAmarrEngineering',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusAmarrEngineering',NULL,1,1,7),(1432,'subsystemBonusAmarrElectronic',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusAmarrElectronic',NULL,1,1,7),(1433,'subsystemBonusAmarrDefensive',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusAmarrDefensive',NULL,1,1,7),(1434,'subsystemBonusAmarrOffensive',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusAmarrOffensive',NULL,1,1,7),(1435,'subsystemBonusAmarrPropulsion',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusAmarrPropulsion',NULL,1,1,7),(1436,'subsystemBonusGallenteEngineering',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusGallenteEngineering',NULL,1,1,7),(1437,'subsystemBonusGallenteElectronic',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusGallenteElectronic',NULL,1,1,7),(1438,'subsystemBonusGallenteDefensive',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusGallenteDefensive',NULL,1,1,7),(1439,'subsystemBonusGallenteOffensive',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusGallenteOffensive',NULL,1,1,7),(1440,'subsystemBonusGallentePropulsion',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusGallentePropulsion',NULL,1,1,7),(1441,'subsystemBonusCaldariEngineering',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusCaldariEngineering',NULL,1,1,7),(1442,'subsystemBonusCaldariElectronic',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusCaldariElectronic',NULL,1,1,7),(1443,'subsystemBonusCaldariDefensive',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusCaldariDefensive',NULL,1,1,7),(1444,'subsystemBonusCaldariOffensive',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusCaldariOffensive',NULL,1,1,7),(1445,'subsystemBonusCaldariPropulsion',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusCaldariPropulsion',NULL,1,1,7),(1446,'subsystemBonusMinmatarEngineering',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusMinmatarEngineering',NULL,1,1,7),(1447,'subsystemBonusMinmatarElectronic',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusMinmatarElectronic',NULL,1,1,7),(1448,'subsystemBonusMinmatarDefensive',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusMinmatarDefensive',NULL,1,1,7),(1449,'subsystemBonusMinmatarOffensive',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusMinmatarOffensive',NULL,1,1,7),(1450,'subsystemBonusMinmatarPropulsion',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusMinmatarPropulsion',NULL,1,1,7),(1451,'npcAssistanceProirity',4,'This tis the priority for assisting this npc, higher the number the mor priority this npc has to be repaired and boosted.',NULL,NULL,NULL,NULL,0,0,'Assistance priority',NULL,1,1,7),(1453,'npcRemoteArmorRepairChance',5,'the chance of the NPC remote reapiring it\'s comrads.',NULL,NULL,NULL,NULL,1,0,'Remote Armor reapir chance',105,1,1,3),(1454,'npcRemoteArmorRepairDuration',5,'How long NPC take to remote repair ther comerad in MS.',NULL,NULL,NULL,NULL,10000,0,'NPC Remote Rapair Duration',101,1,1,3),(1455,'npcRemoteArmorRepairAmount',5,'the amount of armor that is repaired per cycle to each target',NULL,NULL,NULL,NULL,0,0,'Remote Reapir amount',NULL,1,1,3),(1456,'npcRemoteArmorRepairThreshold',5,'the amount of damage tot he total armor HPO that has been done before they begin remote repairing that target.',NULL,NULL,NULL,NULL,0.25,0,'repair threshold',105,1,1,3),(1457,'wormholeTargetDistribution',4,'This is the distribution ID of the target wormhole distribution',NULL,NULL,NULL,NULL,0,0,'Target Distribution ID',NULL,1,1,7),(1458,'npcRemoteShieldBoostDuration',5,'Duration of shield boost effect',NULL,NULL,NULL,NULL,20000,0,'npcRemoteShieldBoostDuration',101,1,1,2),(1459,'npcRemoteShieldBoostChance',5,'Chance of the remote shield boosting effect being used',NULL,NULL,NULL,NULL,1,0,'npcRemoteShieldBoostChance',109,1,1,2),(1460,'npcRemoteShieldBoostAmount',4,'How many shields points does the activation of the effect bestow upon the target',NULL,NULL,NULL,NULL,50,0,'npcRemoteShieldBoostAmount',120,1,1,2),(1462,'npcRemoteShieldBoostThreshold',5,'How damaged does a teammates shield need to be before it\'ll be repaired',NULL,NULL,NULL,NULL,0.75,0,'npcRemoteShieldBoostThreshold',109,1,1,2),(1464,'npcAssistanceRange',4,'Maximum distance to a friendly NPC so that remote repairs may be performed on it.',NULL,NULL,NULL,NULL,5000,0,'npcAssistanceRange',1,0,1,7),(1465,'armorEmDamageResistanceBonus',5,'EM damage resistance bonus for armor',NULL,NULL,NULL,NULL,0,1,'Armor EM resistance bonus',124,1,1,3),(1466,'armorKineticDamageResistanceBonus',5,'Kinetic damage resistance bonus for armor',NULL,NULL,NULL,NULL,0,1,'Armor kinetic resistance bonus',124,1,1,3),(1467,'armorThermalDamageResistanceBonus',5,'Thermal damage resistance bonus for armor',NULL,NULL,NULL,NULL,0,1,'Armor thermal resistance bonus',124,1,1,3),(1468,'armorExplosiveDamageResistanceBonus',5,'Explosive damage resistance bonus for armor',NULL,NULL,NULL,NULL,0,1,'Armor explosive resistance bonus',124,1,1,3),(1469,'missileVelocityMultiplier',5,'Velocity multiplier for missiles',NULL,NULL,NULL,NULL,0,1,'Missile velocity multiplier',104,1,1,7),(1470,'maxVelocityMultiplier',5,'Maximum velocity multiplier',NULL,NULL,NULL,NULL,0,1,'Maximum velocity multiplier',104,1,1,4),(1471,'massMultiplier',5,'Mass multiplier',NULL,NULL,NULL,NULL,0,1,'Mass multiplier',104,1,1,4),(1472,'droneRangeMultiplier',5,'Drone control range multiplier',NULL,NULL,NULL,NULL,0,1,'Control range multiplier',104,1,1,10),(1473,'scanGravimetricStrengthMultiplier',5,'Grav ECM strength multiplier',NULL,NULL,NULL,NULL,0,1,'Gravimetric strength multiplier',104,1,1,6),(1474,'scanLadarStrengthMultiplier',5,'Ladar ECM strength multiplier',NULL,NULL,NULL,NULL,0,1,'Ladar strength multiplier',104,1,1,6),(1475,'scanMagnetometricStrengthMultiplier',5,'Magnetometric ECM strength multiplier',NULL,NULL,NULL,NULL,0,1,'Magnetometric strength multiplier',104,1,1,6),(1476,'scanRadarStrengthMultiplier',5,'Radar ECM strength multiplier',NULL,NULL,NULL,NULL,0,1,'Radar strength multiplier',104,1,1,6),(1477,'signatureRadiusBonusMultiplier',5,'Target painter effectiveness multiplier',NULL,NULL,NULL,NULL,0,1,'Target painter multiplier',104,1,1,6),(1478,'maxTargetRangeBonusMultiplier',5,'Sensor dampener range reduction multiplier',NULL,NULL,NULL,NULL,0,1,'Dampening range reduction multiplier',104,1,1,6),(1479,'scanResolutionBonusMultiplier',5,'Sensor dampener scan resolution amount multiplier',NULL,NULL,NULL,NULL,0,1,'Scan resolution reduction multiplier',104,1,1,6),(1480,'trackingSpeedBonusMultiplier',5,'Tracking disruptor tracking amount multiplier',NULL,NULL,NULL,NULL,0,1,'Tracking penalty multiplier',104,1,1,6),(1481,'maxRangeBonusMultiplier',5,'Tracking disruptor optimal range penalty multiplier',NULL,NULL,NULL,NULL,0,1,'Optimal range penalty multiplier',104,1,1,6),(1482,'damageMultiplierMultiplier',5,'Multiplys the damage multiplier',NULL,NULL,NULL,NULL,0,1,'Damage multiplier multiplier',104,1,1,1),(1483,'aoeVelocityMultiplier',5,'Multiplier to missiles ability to hit fast targets',NULL,NULL,NULL,NULL,0,1,'AOE velocity multiplier',104,1,1,1),(1484,'maxDroneVelocityMultiplier',5,'Maximum drone velocity multiplier',NULL,NULL,NULL,NULL,0,1,'Drone velocity multiplier',104,1,1,10),(1485,'heatDamageMultiplier',5,'Damage multiplier for heat',NULL,NULL,NULL,NULL,0,1,'Heat damage multiplier',104,1,1,4),(1486,'overloadBonusMultiplier',5,'Multiplier to all overload bonuses',NULL,NULL,NULL,NULL,0,1,'Overload bonus multiplier',104,1,1,4),(1487,'empFieldRangeMultiplier',5,'Smart bomb range multiplier',NULL,NULL,NULL,NULL,0,1,'Smart bomb range multiplier',104,1,1,7),(1488,'smartbombDamageMultiplier',5,'Damage multiplier for smart bombs',NULL,NULL,NULL,NULL,0,1,'Smart bomb damage multiplier',104,1,1,7),(1489,'shieldEmDamageResistanceBonus',5,'EM resistance bonus for shields',NULL,NULL,NULL,NULL,0,1,'Shield EM Resistance',105,1,1,2),(1490,'shieldExplosiveDamageResistanceBonus',5,'Explosive resistance bonus for shields',NULL,NULL,NULL,NULL,0,1,'Shield Explosive Resistance',105,1,1,2),(1491,'shieldKineticDamageResistanceBonus',5,'Kinetic resistance bonus for shields',NULL,NULL,NULL,NULL,0,1,'Shield Kinetic Resistance',105,1,1,2),(1492,'shieldThermalDamageResistanceBonus',5,'Thermal resistance bonus for shields',NULL,NULL,NULL,NULL,0,1,'Shield Thermal Resistance',105,1,1,2),(1493,'smallWeaponDamageMultiplier',5,'Damage multiplier for small weapons',NULL,NULL,NULL,NULL,0,1,'Small weapon damage multiplier',104,1,1,7),(1494,'mediumWeaponDamageMultiplier',5,'Damage multiplier for medium weapons',NULL,NULL,NULL,NULL,0,1,'Medium weapon damage multiplier',104,1,1,7),(1495,'armorDamageAmountMultiplier',5,'Armor repair amount multiplier',NULL,NULL,NULL,NULL,0,1,'Repair amount multiplier',104,1,1,3),(1496,'shieldBonusMultiplier',5,'Shield transfer amount multiplier',NULL,NULL,NULL,NULL,0,1,'Shield transfer amount multiplier',104,1,1,2),(1497,'shieldBonusMultiplierRemote',5,'Shield repair multiplier for remote repair',NULL,NULL,NULL,NULL,0,1,'Shield repair multiplier',104,1,1,2),(1498,'armorDamageAmountMultiplierRemote',5,'Repair amount multiplier for remote repairers',NULL,NULL,NULL,NULL,0,1,'Remote repair amount multiplier',104,1,1,3),(1499,'capacitorCapacityMultiplierSystem',5,'Capacitor capacity multiplier',NULL,NULL,NULL,NULL,0,1,'Capacitor capacity multiplier',104,1,1,5),(1500,'rechargeRateMultiplier',5,'Capacitor recharge rate multiplier',NULL,NULL,NULL,NULL,0,1,'Capacitor recharge multiplier',104,1,1,5),(1501,'npcRemoteArmorRepairMaxTargets',4,'The maximum number of targets that can be repaired at once.',NULL,NULL,NULL,NULL,1,0,'NPC Remote Armor Repair Max Targets',NULL,1,1,3),(1502,'npcRemoteShieldBoostMaxTargets',4,'The maximum number of targets that can be shield boosted at once',NULL,NULL,NULL,NULL,1,0,'NPC Remote Shield Boost Max Targets',NULL,1,1,2),(1503,'shipBonusStrategicCruiserAmarr',5,'',NULL,NULL,NULL,NULL,0,1,'shipBonusStrategicCruiserAmarr',NULL,1,1,9),(1504,'shipBonusStrategicCruiserCaldari',5,'',NULL,NULL,NULL,NULL,0,1,'shipBonusStrategicCruiserCaldari',NULL,1,1,9),(1505,'shipBonusStrategicCruiserGallente',5,'',NULL,NULL,NULL,NULL,0,1,'shipBonusStrategicCruiserGallente',NULL,1,1,9),(1506,'shipBonusStrategicCruiserMinmatar',5,'',NULL,NULL,NULL,NULL,0,1,'shipBonusStrategicCruiserMinmatar',NULL,1,1,9),(1507,'subsystemBonusAmarrDefensive2',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusAmarrDefensive2',NULL,1,1,7),(1508,'subsystemBonusAmarrElectronic2',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusAmarrElectronic2',NULL,1,1,7),(1509,'subsystemBonusAmarrEngineering2',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusAmarrEngineering2',NULL,1,1,7),(1510,'subsystemBonusCaldariOffensive2',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusCaldariOffensive2',NULL,1,1,7),(1511,'subsystemBonusAmarrOffensive2',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusAmarrOffensive2',NULL,1,1,7),(1512,'subsystemBonusAmarrPropulsion2',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusAmarrPropulsion2',NULL,1,1,7),(1513,'subsystemBonusCaldariPropulsion2',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusCaldariPropulsion2',NULL,1,1,7),(1514,'subsystemBonusCaldariElectronic2',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusCaldariElectronic2',NULL,1,1,7),(1515,'subsystemBonusCaldariEngineering2',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusCaldariEngineering2',NULL,1,1,7),(1516,'subsystemBonusCaldariDefensive2',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusCaldariDefensive2',NULL,1,1,7),(1517,'subsystemBonusGallenteDefensive2',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusGallenteDefensive2',NULL,1,1,7),(1518,'subsystemBonusGallenteElectronic2',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusGallenteElectronic2',NULL,1,1,7),(1519,'subsystemBonusGallenteEngineering2',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusGallenteEngineering2',NULL,1,1,7),(1520,'subsystemBonusGallentePropulsion2',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusGallentePropulsion2',NULL,1,1,7),(1521,'subsystemBonusGallenteOffensive2',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusGallenteOffensive2',NULL,1,1,7),(1522,'subsystemBonusMinmatarOffensive2',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusMinmatarOffensive2',NULL,1,1,7),(1523,'subsystemBonusMinmatarPropulsion2',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusMinmatarPropulsion2',NULL,1,1,7),(1524,'subsystemBonusMinmatarElectronic2',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusMinmatarElectronic2',NULL,1,1,7),(1525,'subsystemBonusMinmatarEngineering2',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusMinmatarEngineering2',NULL,1,1,7),(1526,'subsystemBonusMinmatarDefensive2',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusMinmatarDefensive2',NULL,1,1,7),(1527,'armorMaxDamageResonance',5,'Maximum value for armor resonances. Default = 1.',NULL,NULL,NULL,NULL,1,1,'Maximum Armor Resonance',NULL,1,1,3),(1528,'shieldMaxDamageResonance',5,'Maximum value for shield resonances. Default = 1.',NULL,NULL,NULL,NULL,1,1,'Maximum Shield Resonance',NULL,1,1,2),(1529,'hullMaxDamageResonance',5,'Maximum value for hull resonances. Default = 1.',NULL,NULL,NULL,NULL,1,1,'Maximum Hull Resonance',NULL,1,1,4),(1530,'hullMaxDamageResonance',5,'Maximum value for hull resonances. Default = 1.',NULL,NULL,NULL,NULL,1,1,'Maximum Hull Resonance',NULL,1,1,4),(1531,'subsystemBonusAmarrOffensive3',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusAmarrOffensive3',NULL,1,1,7),(1532,'subsystemBonusGallenteOffensive3',5,'',NULL,NULL,NULL,NULL,0,1,'subsystemBonusGallenteOffensive3',NULL,1,1,7),(1533,'subsystemBonusCaldariOffensive3',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusCaldariOffensive3',NULL,1,1,7),(1534,'subsystemBonusMinmatarOffensive3',5,'',NULL,NULL,NULL,NULL,0,1,'subsystemBonusMinmatarOffensive3',NULL,1,1,7),(1535,'shipBonusCR3',5,'',NULL,NULL,NULL,NULL,0,0,'shipBonusCR3',NULL,1,1,7),(1536,'ecmRangeBonus',5,'',NULL,NULL,NULL,NULL,0,1,'ECM Range Bonus',105,1,1,7),(1537,'eliteBonusReconShips3',5,'',NULL,NULL,NULL,NULL,0,0,'eliteBonusReconShips3',NULL,1,1,7),(1538,'warpBubbleImmune',4,'',NULL,NULL,NULL,NULL,0,1,'warpBubbleImmune',NULL,1,1,7),(1539,'warpBubbleImmuneModifier',4,'',NULL,NULL,NULL,NULL,0,1,'warpBubbleImmuneModifier',NULL,1,1,7),(1540,'stealthBomberLauncherPower2',5,'',NULL,NULL,NULL,NULL,0,1,'stealthBomberLauncherPower2',NULL,1,1,7),(1541,'jumpHarmonicsModifier',4,'',NULL,NULL,NULL,NULL,0,0,'jumpHarmonicsModifier',NULL,1,1,7),(1544,'maxGroupFitted',4,'',NULL,NULL,NULL,NULL,0,1,'Max Group Fitted',NULL,1,1,7),(1545,'dreadnoughtShipBonusM3',5,'',NULL,NULL,NULL,NULL,0,0,'dreadnoughtShipBonusM3',NULL,1,1,7),(1547,'rigSize',4,'',NULL,NULL,NULL,NULL,0,1,'Rig Size',117,1,1,1),(1549,'specialFuelBayCapacity',5,'special fuel bay capacity',NULL,NULL,71,NULL,0,1,'Fuel Bay Capacity',9,0,1,7),(1550,'implantSetImperialNavy',5,'',NULL,NULL,NULL,NULL,1,0,'Imperial Navy Set Bonus',NULL,1,1,9),(1552,'implantSetCaldariNavy',5,'',NULL,NULL,NULL,NULL,1,0,'Caldari Navy Set Bonus',NULL,1,1,9),(1553,'implantSetFederationNavy',5,'',NULL,NULL,NULL,NULL,1,0,'Federation Navy Set Bonus',NULL,1,1,9),(1554,'implantSetRepublicFleet',5,'',NULL,NULL,NULL,NULL,1,0,'Republic Fleet Set Bonus',NULL,1,1,9),(1555,'fwLpKill',5,'',NULL,NULL,NULL,NULL,0,0,'fwLpKill',NULL,1,1,9),(1556,'specialOreHoldCapacity',5,'Capacity of ore-only hold',NULL,NULL,71,NULL,0,1,'Ore Hold Capacity',9,1,1,7),(1557,'specialGasHoldCapacity',5,'Capacity of gas-only hold',NULL,NULL,71,NULL,0,1,'Gas Hold Capacity',9,1,1,7),(1558,'specialMineralHoldCapacity',5,'Capacity of mineral-only hold',NULL,NULL,71,NULL,0,1,'Mineral Hold Capacity',9,1,1,7),(1559,'specialSalvageHoldCapacity',5,'Capacity of special salvage-only hold',NULL,NULL,71,NULL,0,1,'Salvage Hold Capacity',9,1,1,7),(1560,'specialShipHoldCapacity',5,'Capacity of ship-only hold',NULL,NULL,71,NULL,0,1,'Ship Hold Capacity',9,1,1,7),(1561,'specialSmallShipHoldCapacity',5,'Capacity of frigate/destroyer hold',NULL,NULL,71,NULL,0,1,'Small Ship Hold Capacity',9,1,1,7),(1562,'specialMediumShipHoldCapacity',5,'Capacity of cruiser/battlecruiser ship hold',NULL,NULL,71,NULL,0,1,'Medium Ship Hold Capacity',9,1,1,7),(1563,'specialLargeShipHoldCapacity',5,'Capacity of battleship hold',NULL,NULL,71,NULL,0,1,'Large Ship Hold Capacity',9,1,1,7),(1564,'specialIndustrialShipHoldCapacity',5,'Capacity of industrial ship hold',NULL,NULL,71,NULL,0,1,'Industrial Ship Hold Capacity',9,1,1,7),(1565,'scanRadarStrengthModifier',5,'+ / - modifier to a ship radar strength',NULL,NULL,NULL,NULL,0,1,'RADAR strength bonus',NULL,1,1,7),(1566,'scanLadarStrengthModifier',5,'+ / - modifier to a ship ladar strength',NULL,NULL,NULL,NULL,0,1,'LADAR strength bonus',NULL,1,1,7),(1567,'scanGravimetricStrengthModifier',5,'+ / - modifier to a ship gravimetric strength',NULL,NULL,NULL,NULL,0,1,'Gravimetric strength bonus',NULL,1,1,7),(1568,'scanMagnetometricStrengthModifier',5,'+ / - modifier to a ship magnetometric strength',NULL,NULL,NULL,NULL,0,1,'Magnetometric strength bonus',NULL,1,1,7),(1569,'implantSetLGImperialNavy',5,'',NULL,NULL,NULL,NULL,1,0,'Imperial Navy Set LG Bonus',NULL,1,1,9),(1570,'implantSetLGFederationNavy',5,'',NULL,NULL,NULL,NULL,1,0,'Federation Navy Set LG Bonus',NULL,1,1,9),(1571,'implantSetLGCaldariNavy',5,'',NULL,NULL,NULL,NULL,1,0,'Caldari Navy Set LG Bonus',NULL,1,1,9),(1572,'implantSetLGRepublicFleet',5,'',NULL,NULL,NULL,NULL,1,0,'Republic Fleet Set LG Bonus',NULL,1,1,9),(1573,'specialAmmoHoldCapacity',5,'special ammo hold capacity',NULL,NULL,71,NULL,0,1,'Ammo Hold Capacity',9,0,1,7),(1574,'shipBonusATC1',5,'Alliance Tournament Ship Bonus',NULL,NULL,NULL,NULL,0,1,'Special Ability Bonus',105,1,1,9),(1575,'shipBonusATC2',5,'Alliance Tournament Ship Bonus',NULL,NULL,NULL,NULL,0,1,'Special Ability Bonus',105,1,1,9),(1576,'shipBonusATF1',5,'Alliance Tournament Frigate Bonus',NULL,NULL,NULL,NULL,0,1,'Special Ability Bonus',105,1,1,9),(1577,'shipBonusATF2',5,'Alliance Tournament Frigate Bonus',NULL,NULL,NULL,NULL,0,1,'Special Ability Bonus',105,1,1,9);

/*Table structure for table `dgmTypeAttributes` */

DROP TABLE IF EXISTS `dgmTypeAttributes`;

CREATE TABLE `dgmTypeAttributes` (
  `typeID` smallint(6) NOT NULL,
  `attributeID` smallint(6) NOT NULL,
  `valueInt` int(11) default NULL,
  `valueFloat` double default NULL,
  PRIMARY KEY  (`typeID`,`attributeID`),
  KEY `attributeID` (`attributeID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `dgmTypeAttributes` */

insert  into `dgmTypeAttributes`(`typeID`,`attributeID`,`valueInt`,`valueFloat`) values (18,182,3386,NULL),(18,790,12191,NULL),(19,182,3386,NULL),(19,790,12194,NULL),(20,182,3386,NULL),(20,790,12188,NULL),(21,182,3386,NULL),(21,790,12185,NULL),(22,182,3386,NULL),(22,790,12180,NULL),(23,9,500,NULL),(23,525,NULL,0.75),(23,552,5000,NULL),(25,9,10,NULL),(25,552,50,NULL),(50,37,3750,NULL),(50,70,1000,NULL),(50,108,35,NULL),(50,114,0,NULL),(50,116,240,NULL),(50,117,0,NULL),(50,118,0,NULL),(50,137,506,NULL),(50,144,NULL,1.125),(50,182,3326,NULL),(50,183,3319,NULL),(50,277,4,NULL),(50,278,1,NULL),(50,281,20000,NULL),(50,525,NULL,0.75),(50,653,1000,NULL),(50,654,150,NULL),(50,655,1500,NULL),(54,9,100000000,NULL),(56,9,100000000,NULL),(57,9,100000000,NULL),(164,419,900000,NULL),(165,419,1380000,NULL),(166,419,2050000,NULL),(178,114,0,NULL),(178,116,3,NULL),(178,117,3,NULL),(178,118,0,NULL),(178,120,NULL,1.6),(178,124,4082279,NULL),(178,128,1,NULL),(178,137,55,NULL),(178,422,1,NULL),(178,612,0,NULL),(178,613,0,NULL),(178,779,NULL,1.6),(179,114,0,NULL),(179,116,5,NULL),(179,117,2,NULL),(179,118,0,NULL),(179,120,NULL,1.4),(179,124,4084071,NULL),(179,128,1,NULL),(179,137,55,NULL),(179,422,1,NULL),(179,612,0,NULL),(179,613,0,NULL),(179,779,NULL,1.4),(180,114,3,NULL),(180,116,0,NULL),(180,117,4,NULL),(180,118,0,NULL),(180,120,NULL,1.2),(180,124,2772304,NULL),(180,128,1,NULL),(180,137,55,NULL),(180,422,1,NULL),(180,612,0,NULL),(180,613,0,NULL),(180,779,NULL,1.2),(181,114,0,NULL),(181,116,3,NULL),(181,117,3,NULL),(181,118,2,NULL),(181,120,1,NULL),(181,124,3957853,NULL),(181,128,1,NULL),(181,137,55,NULL),(181,422,1,NULL),(181,612,0,NULL),(181,613,0,NULL),(181,779,1,NULL),(182,114,0,NULL),(182,116,3,NULL),(182,117,6,NULL),(182,118,0,NULL),(182,120,NULL,0.875),(182,124,6380350,NULL),(182,128,1,NULL),(182,137,55,NULL),(182,422,1,NULL),(182,612,0,NULL),(182,613,0,NULL),(182,779,NULL,0.875),(183,114,0,NULL),(183,116,8,NULL),(183,117,2,NULL),(183,118,0,NULL),(183,120,NULL,0.75),(183,124,12021089,NULL),(183,128,1,NULL),(183,137,55,NULL),(183,422,1,NULL),(183,612,0,NULL),(183,613,0,NULL),(183,779,NULL,0.75),(184,114,0,NULL),(184,116,0,NULL),(184,117,2,NULL),(184,118,8,NULL),(184,120,NULL,0.625),(184,124,3304021,NULL),(184,128,1,NULL),(184,137,55,NULL),(184,422,1,NULL),(184,612,0,NULL),(184,613,0,NULL),(184,779,NULL,0.625),(185,114,5,NULL),(185,116,4,NULL),(185,117,2,NULL),(185,118,0,NULL),(185,120,NULL,0.5),(185,124,16763512,NULL),(185,128,1,NULL),(185,137,55,NULL),(185,422,1,NULL),(185,612,0,NULL),(185,613,0,NULL),(185,779,NULL,0.5),(186,114,0,NULL),(186,116,6,NULL),(186,117,6,NULL),(186,118,0,NULL),(186,120,NULL,1.6),(186,124,4082279,NULL),(186,128,2,NULL),(186,137,55,NULL),(186,422,1,NULL),(186,612,0,NULL),(186,613,0,NULL),(186,779,NULL,1.6),(187,114,0,NULL),(187,116,10,NULL),(187,117,4,NULL),(187,118,0,NULL),(187,120,NULL,1.4),(187,124,4084071,NULL),(187,128,2,NULL),(187,137,55,NULL),(187,422,1,NULL),(187,612,0,NULL),(187,613,0,NULL),(187,779,NULL,1.4),(188,114,6,NULL),(188,116,0,NULL),(188,117,8,NULL),(188,118,0,NULL),(188,120,NULL,1.2),(188,124,2772304,NULL),(188,128,2,NULL),(188,137,55,NULL),(188,422,1,NULL),(188,612,0,NULL),(188,613,0,NULL),(188,779,NULL,1.2),(189,114,0,NULL),(189,116,6,NULL),(189,117,6,NULL),(189,118,4,NULL),(189,120,1,NULL),(189,124,4612441,NULL),(189,128,2,NULL),(189,137,55,NULL),(189,422,1,NULL),(189,612,0,NULL),(189,613,0,NULL),(189,779,1,NULL),(190,114,0,NULL),(190,116,6,NULL),(190,117,12,NULL),(190,118,0,NULL),(190,120,NULL,0.875),(190,124,6380350,NULL),(190,128,2,NULL),(190,137,55,NULL),(190,422,1,NULL),(190,612,0,NULL),(190,613,0,NULL),(190,779,NULL,0.875),(191,114,0,NULL),(191,116,16,NULL),(191,117,4,NULL),(191,118,0,NULL),(191,120,NULL,0.75),(191,124,12021089,NULL),(191,128,2,NULL),(191,137,55,NULL),(191,422,1,NULL),(191,612,0,NULL),(191,613,0,NULL),(191,779,NULL,0.75),(192,114,0,NULL),(192,116,0,NULL),(192,117,4,NULL),(192,118,16,NULL),(192,120,NULL,0.625),(192,124,3304021,NULL),(192,128,2,NULL),(192,137,55,NULL),(192,422,1,NULL),(192,612,0,NULL),(192,613,0,NULL),(192,779,NULL,0.625),(193,114,10,NULL),(193,116,8,NULL),(193,117,4,NULL),(193,118,0,NULL),(193,120,NULL,0.5),(193,124,16763512,NULL),(193,128,2,NULL),(193,137,55,NULL),(193,422,1,NULL),(193,612,0,NULL),(193,613,0,NULL),(193,779,NULL,0.5),(194,114,0,NULL),(194,116,12,NULL),(194,117,12,NULL),(194,118,0,NULL),(194,120,NULL,1.6),(194,124,4082279,NULL),(194,128,3,NULL),(194,137,55,NULL),(194,422,1,NULL),(194,612,0,NULL),(194,613,0,NULL),(194,779,NULL,1.6),(195,114,0,NULL),(195,116,20,NULL),(195,117,8,NULL),(195,118,0,NULL),(195,120,NULL,1.4),(195,124,4084071,NULL),(195,128,3,NULL),(195,137,55,NULL),(195,422,1,NULL),(195,612,0,NULL),(195,613,0,NULL),(195,779,NULL,1.4),(196,114,12,NULL),(196,116,0,NULL),(196,117,16,NULL),(196,118,0,NULL),(196,120,NULL,1.2),(196,124,4086631,NULL),(196,128,3,NULL),(196,137,55,NULL),(196,422,1,NULL),(196,612,0,NULL),(196,613,0,NULL),(196,779,NULL,1.2),(197,114,0,NULL),(197,116,12,NULL),(197,117,12,NULL),(197,118,8,NULL),(197,120,1,NULL),(197,124,4612441,NULL),(197,128,3,NULL),(197,137,55,NULL),(197,422,1,NULL),(197,612,0,NULL),(197,613,0,NULL),(197,779,1,NULL),(198,114,0,NULL),(198,116,12,NULL),(198,117,24,NULL),(198,118,0,NULL),(198,120,NULL,0.875),(198,124,6380350,NULL),(198,128,3,NULL),(198,137,55,NULL),(198,422,1,NULL),(198,612,0,NULL),(198,613,0,NULL),(198,779,NULL,0.875),(199,114,0,NULL),(199,116,32,NULL),(199,117,8,NULL),(199,118,0,NULL),(199,120,NULL,0.75),(199,124,12021089,NULL),(199,128,3,NULL),(199,137,55,NULL),(199,422,1,NULL),(199,612,0,NULL),(199,613,0,NULL),(199,779,NULL,0.75),(200,114,0,NULL),(200,116,0,NULL),(200,117,8,NULL),(200,118,32,NULL),(200,120,NULL,0.625),(200,124,3304021,NULL),(200,128,3,NULL),(200,137,55,NULL),(200,422,1,NULL),(200,612,0,NULL),(200,613,0,NULL),(200,779,NULL,0.625),(201,114,20,NULL),(201,116,16,NULL),(201,117,8,NULL),(201,118,0,NULL),(201,120,NULL,0.5),(201,124,16763512,NULL),(201,128,3,NULL),(201,137,55,NULL),(201,422,1,NULL),(201,612,0,NULL),(201,613,0,NULL),(201,779,NULL,0.5),(202,9,70,NULL),(202,37,3750,NULL),(202,70,1000,NULL),(202,107,0,NULL),(202,108,35,NULL),(202,114,300,NULL),(202,116,0,NULL),(202,117,0,NULL),(202,118,0,NULL),(202,137,506,NULL),(202,182,3326,NULL),(202,183,3319,NULL),(202,277,1,NULL),(202,278,1,NULL),(202,281,20000,NULL),(202,422,1,NULL),(202,525,NULL,0.75),(202,633,0,NULL),(202,644,1,NULL),(202,653,69,NULL),(202,654,300,NULL),(202,655,1500,NULL),(202,1353,NULL,4.5),(202,1354,NULL,5.5),(203,9,70,NULL),(203,37,3750,NULL),(203,70,1000,NULL),(203,107,0,NULL),(203,108,35,NULL),(203,114,0,NULL),(203,116,0,NULL),(203,117,300,NULL),(203,118,0,NULL),(203,137,506,NULL),(203,182,3326,NULL),(203,183,3319,NULL),(203,277,1,NULL),(203,278,1,NULL),(203,281,20000,NULL),(203,422,1,NULL),(203,525,NULL,0.75),(203,633,0,NULL),(203,644,1,NULL),(203,653,69,NULL),(203,654,300,NULL),(203,655,1500,NULL),(203,1353,NULL,4.5),(203,1354,NULL,5.5),(204,9,70,NULL),(204,37,3750,NULL),(204,70,1000,NULL),(204,107,0,NULL),(204,108,35,NULL),(204,114,0,NULL),(204,116,0,NULL),(204,117,0,NULL),(204,118,300,NULL),(204,137,506,NULL),(204,182,3326,NULL),(204,183,3319,NULL),(204,277,1,NULL),(204,278,1,NULL),(204,281,20000,NULL),(204,422,1,NULL),(204,525,NULL,0.75),(204,633,0,NULL),(204,644,1,NULL),(204,653,69,NULL),(204,654,300,NULL),(204,655,1500,NULL),(204,1353,NULL,4.5),(204,1354,NULL,5.5),(205,9,70,NULL),(205,37,3750,NULL),(205,70,1000,NULL),(205,107,0,NULL),(205,108,35,NULL),(205,114,0,NULL),(205,116,300,NULL),(205,117,0,NULL),(205,118,0,NULL),(205,137,506,NULL),(205,182,3326,NULL),(205,183,3319,NULL),(205,277,1,NULL),(205,278,1,NULL),(205,281,20000,NULL),(205,422,1,NULL),(205,525,NULL,0.75),(205,633,0,NULL),(205,644,1,NULL),(205,653,69,NULL),(205,654,300,NULL),(205,655,1500,NULL),(205,1353,NULL,4.5),(205,1354,NULL,5.5),(206,9,70,NULL),(206,37,3750,NULL),(206,70,1000,NULL),(206,107,0,NULL),(206,108,35,NULL),(206,114,0,NULL),(206,116,150,NULL),(206,117,0,NULL),(206,118,0,NULL),(206,137,510,NULL),(206,182,3324,NULL),(206,183,3319,NULL),(206,277,1,NULL),(206,278,1,NULL),(206,281,10000,NULL),(206,422,1,NULL),(206,525,NULL,0.75),(206,633,0,NULL),(206,644,1,NULL),(206,653,81,NULL),(206,654,125,NULL),(206,655,1500,NULL),(206,1353,NULL,3.2),(206,1354,NULL,5.5),(207,9,70,NULL),(207,37,3750,NULL),(207,70,1000,NULL),(207,107,0,NULL),(207,108,35,NULL),(207,114,150,NULL),(207,116,0,NULL),(207,117,0,NULL),(207,118,0,NULL),(207,137,510,NULL),(207,182,3324,NULL),(207,183,3319,NULL),(207,277,1,NULL),(207,278,1,NULL),(207,281,10000,NULL),(207,422,1,NULL),(207,525,NULL,0.75),(207,633,0,NULL),(207,644,1,NULL),(207,653,81,NULL),(207,654,125,NULL),(207,655,1500,NULL),(207,1353,NULL,3.2),(207,1354,NULL,5.5),(208,9,70,NULL),(208,37,3750,NULL),(208,70,1000,NULL),(208,107,0,NULL),(208,108,35,NULL),(208,114,0,NULL),(208,116,0,NULL),(208,117,0,NULL),(208,118,150,NULL),(208,137,510,NULL),(208,182,3324,NULL),(208,183,3319,NULL),(208,277,1,NULL),(208,278,1,NULL),(208,281,10000,NULL),(208,422,1,NULL),(208,525,NULL,0.75),(208,633,0,NULL),(208,644,1,NULL),(208,653,81,NULL),(208,654,125,NULL),(208,655,1500,NULL),(208,1353,NULL,3.2),(208,1354,NULL,5.5),(209,9,70,NULL),(209,37,3750,NULL),(209,70,1000,NULL),(209,107,0,NULL),(209,108,35,NULL),(209,114,0,NULL),(209,116,0,NULL),(209,117,150,NULL),(209,118,0,NULL),(209,137,510,NULL),(209,182,3324,NULL),(209,183,3319,NULL),(209,277,1,NULL),(209,278,1,NULL),(209,281,10000,NULL),(209,422,1,NULL),(209,525,NULL,0.75),(209,633,0,NULL),(209,644,1,NULL),(209,653,81,NULL),(209,654,125,NULL),(209,655,1500,NULL),(209,1353,NULL,3.2),(209,1354,NULL,5.5),(210,9,70,NULL),(210,37,3750,NULL),(210,70,1000,NULL),(210,107,0,NULL),(210,108,35,NULL),(210,114,0,NULL),(210,116,0,NULL),(210,117,75,NULL),(210,118,0,NULL),(210,137,509,NULL),(210,182,3321,NULL),(210,183,3319,NULL),(210,277,1,NULL),(210,278,1,NULL),(210,281,5000,NULL),(210,422,1,NULL),(210,525,NULL,0.75),(210,633,0,NULL),(210,644,1,NULL),(210,653,170,NULL),(210,654,50,NULL),(210,655,1500,NULL),(210,1353,NULL,2.8),(210,1354,NULL,5.5),(211,9,70,NULL),(211,37,3750,NULL),(211,70,1000,NULL),(211,107,0,NULL),(211,108,35,NULL),(211,114,0,NULL),(211,116,0,NULL),(211,117,0,NULL),(211,118,75,NULL),(211,137,509,NULL),(211,182,3321,NULL),(211,183,3319,NULL),(211,277,1,NULL),(211,278,1,NULL),(211,281,5000,NULL),(211,422,1,NULL),(211,525,NULL,0.75),(211,633,0,NULL),(211,644,1,NULL),(211,653,170,NULL),(211,654,50,NULL),(211,655,1500,NULL),(211,1353,NULL,2.8),(211,1354,NULL,5.5),(212,9,70,NULL),(212,37,3750,NULL),(212,70,1000,NULL),(212,107,0,NULL),(212,108,35,NULL),(212,114,75,NULL),(212,116,0,NULL),(212,117,0,NULL),(212,118,0,NULL),(212,137,509,NULL),(212,182,3321,NULL),(212,183,3319,NULL),(212,277,1,NULL),(212,278,1,NULL),(212,281,5000,NULL),(212,422,1,NULL),(212,525,NULL,0.75),(212,633,0,NULL),(212,644,1,NULL),(212,653,170,NULL),(212,654,50,NULL),(212,655,1500,NULL),(212,1353,NULL,2.8),(212,1354,NULL,5.5),(213,9,70,NULL),(213,37,3750,NULL),(213,70,1000,NULL),(213,107,0,NULL),(213,108,35,NULL),(213,114,0,NULL),(213,116,75,NULL),(213,117,0,NULL),(213,118,0,NULL),(213,137,509,NULL),(213,182,3321,NULL),(213,183,3319,NULL),(213,277,1,NULL),(213,278,1,NULL),(213,281,5000,NULL),(213,422,1,NULL),(213,525,NULL,0.75),(213,633,0,NULL),(213,644,1,NULL),(213,653,170,NULL),(213,654,50,NULL),(213,655,1500,NULL),(213,1353,NULL,2.8),(213,1354,NULL,5.5),(215,114,0,NULL),(215,116,0,NULL),(215,117,3,NULL),(215,118,2,NULL),(215,120,NULL,1.6),(215,124,5202838,NULL),(215,128,1,NULL),(215,137,74,NULL),(215,317,-30,NULL),(215,422,1,NULL),(215,612,0,NULL),(215,613,0,NULL),(215,779,NULL,1.6),(216,114,0,NULL),(216,116,0,NULL),(216,117,4,NULL),(216,118,2,NULL),(216,120,NULL,1.4),(216,124,5801883,NULL),(216,128,1,NULL),(216,137,74,NULL),(216,317,-27,NULL),(216,422,1,NULL),(216,612,0,NULL),(216,613,0,NULL),(216,779,NULL,1.4),(217,114,0,NULL),(217,116,0,NULL),(217,117,4,NULL),(217,118,3,NULL),(217,120,NULL,1.2),(217,124,6201492,NULL),(217,128,1,NULL),(217,137,74,NULL),(217,317,-24,NULL),(217,422,1,NULL),(217,612,0,NULL),(217,613,0,NULL),(217,779,NULL,1.2),(218,114,0,NULL),(218,116,0,NULL),(218,117,5,NULL),(218,118,3,NULL),(218,120,1,NULL),(218,124,8301159,NULL),(218,128,1,NULL),(218,137,74,NULL),(218,317,-50,NULL),(218,422,1,NULL),(218,612,0,NULL),(218,613,0,NULL),(218,779,1,NULL),(219,114,0,NULL),(219,116,0,NULL),(219,117,5,NULL),(219,118,4,NULL),(219,120,NULL,0.875),(219,124,10727277,NULL),(219,128,1,NULL),(219,137,74,NULL),(219,317,-40,NULL),(219,422,1,NULL),(219,612,0,NULL),(219,613,0,NULL),(219,779,NULL,0.875),(220,114,0,NULL),(220,116,0,NULL),(220,117,6,NULL),(220,118,4,NULL),(220,120,NULL,0.75),(220,124,11835778,NULL),(220,128,1,NULL),(220,137,74,NULL),(220,317,-8,NULL),(220,422,1,NULL),(220,612,0,NULL),(220,613,0,NULL),(220,779,NULL,0.75),(221,114,0,NULL),(221,116,0,NULL),(221,117,6,NULL),(221,118,5,NULL),(221,120,NULL,0.625),(221,124,12487062,NULL),(221,128,1,NULL),(221,137,74,NULL),(221,317,-5,NULL),(221,422,1,NULL),(221,612,0,NULL),(221,613,0,NULL),(221,779,NULL,0.625),(222,114,0,NULL),(222,116,0,NULL),(222,117,7,NULL),(222,118,5,NULL),(222,120,NULL,0.5),(222,124,16764120,NULL),(222,128,1,NULL),(222,137,74,NULL),(222,317,0,NULL),(222,422,1,NULL),(222,612,0,NULL),(222,613,0,NULL),(222,779,NULL,0.5),(223,114,0,NULL),(223,116,0,NULL),(223,117,6,NULL),(223,118,4,NULL),(223,120,NULL,1.6),(223,124,5202838,NULL),(223,128,2,NULL),(223,137,74,NULL),(223,317,-30,NULL),(223,422,1,NULL),(223,612,0,NULL),(223,613,0,NULL),(223,779,NULL,1.6),(224,114,0,NULL),(224,116,0,NULL),(224,117,8,NULL),(224,118,4,NULL),(224,120,NULL,1.4),(224,124,5801883,NULL),(224,128,2,NULL),(224,137,74,NULL),(224,317,-27,NULL),(224,422,1,NULL),(224,612,0,NULL),(224,613,0,NULL),(224,779,NULL,1.4),(225,114,0,NULL),(225,116,0,NULL),(225,117,8,NULL),(225,118,6,NULL),(225,120,NULL,1.2),(225,124,6201492,NULL),(225,128,2,NULL),(225,137,74,NULL),(225,317,-24,NULL),(225,422,1,NULL),(225,612,0,NULL),(225,613,0,NULL),(225,779,NULL,1.2),(226,114,0,NULL),(226,116,0,NULL),(226,117,10,NULL),(226,118,6,NULL),(226,120,1,NULL),(226,124,8301159,NULL),(226,128,2,NULL),(226,137,74,NULL),(226,317,-50,NULL),(226,422,1,NULL),(226,612,0,NULL),(226,613,0,NULL),(226,779,1,NULL),(227,114,0,NULL),(227,116,0,NULL),(227,117,10,NULL),(227,118,8,NULL),(227,120,NULL,0.875),(227,124,10727277,NULL),(227,128,2,NULL),(227,137,74,NULL),(227,317,-40,NULL),(227,422,1,NULL),(227,612,0,NULL),(227,613,0,NULL),(227,779,NULL,0.875),(228,114,0,NULL),(228,116,0,NULL),(228,117,12,NULL),(228,118,8,NULL),(228,120,NULL,0.75),(228,124,11835778,NULL),(228,128,2,NULL),(228,137,74,NULL),(228,317,-8,NULL),(228,422,1,NULL),(228,612,0,NULL),(228,613,0,NULL),(228,779,NULL,0.75),(229,114,0,NULL),(229,116,0,NULL),(229,117,12,NULL),(229,118,10,NULL),(229,120,NULL,0.625),(229,124,12487062,NULL),(229,128,2,NULL),(229,137,74,NULL),(229,317,-5,NULL),(229,422,1,NULL),(229,612,0,NULL),(229,613,0,NULL),(229,779,NULL,0.625),(230,114,0,NULL),(230,116,0,NULL),(230,117,14,NULL),(230,118,10,NULL),(230,120,NULL,0.5),(230,124,16764120,NULL),(230,128,2,NULL),(230,137,74,NULL),(230,317,0,NULL),(230,422,1,NULL),(230,612,0,NULL),(230,613,0,NULL),(230,779,NULL,0.5),(231,114,0,NULL),(231,116,0,NULL),(231,117,12,NULL),(231,118,8,NULL),(231,120,NULL,1.6),(231,124,5202838,NULL),(231,128,3,NULL),(231,137,74,NULL),(231,317,-30,NULL),(231,422,1,NULL),(231,612,0,NULL),(231,613,0,NULL),(231,779,NULL,1.6),(232,114,0,NULL),(232,116,0,NULL),(232,117,16,NULL),(232,118,8,NULL),(232,120,NULL,1.4),(232,124,5801883,NULL),(232,128,3,NULL),(232,137,74,NULL),(232,317,-27,NULL),(232,422,1,NULL),(232,612,0,NULL),(232,613,0,NULL),(232,779,NULL,1.4),(233,114,0,NULL),(233,116,0,NULL),(233,117,16,NULL),(233,118,12,NULL),(233,120,NULL,1.2),(233,124,6201492,NULL),(233,128,3,NULL),(233,137,74,NULL),(233,317,-24,NULL),(233,422,1,NULL),(233,612,0,NULL),(233,613,0,NULL),(233,779,NULL,1.2),(234,114,0,NULL),(234,116,0,NULL),(234,117,20,NULL),(234,118,12,NULL),(234,120,1,NULL),(234,124,8301159,NULL),(234,128,3,NULL),(234,137,74,NULL),(234,317,-50,NULL),(234,422,1,NULL),(234,612,0,NULL),(234,613,0,NULL),(234,779,1,NULL),(235,114,0,NULL),(235,116,0,NULL),(235,117,20,NULL),(235,118,16,NULL),(235,120,NULL,0.875),(235,124,10727277,NULL),(235,128,3,NULL),(235,137,74,NULL),(235,317,-40,NULL),(235,422,1,NULL),(235,612,0,NULL),(235,613,0,NULL),(235,779,NULL,0.875),(236,114,0,NULL),(236,116,0,NULL),(236,117,24,NULL),(236,118,16,NULL),(236,120,NULL,0.75),(236,124,11835778,NULL),(236,128,3,NULL),(236,137,74,NULL),(236,317,-8,NULL),(236,422,1,NULL),(236,612,0,NULL),(236,613,0,NULL),(236,779,NULL,0.75),(237,114,0,NULL),(237,116,0,NULL),(237,117,24,NULL),(237,118,20,NULL),(237,120,NULL,0.625),(237,124,12487062,NULL),(237,128,3,NULL),(237,137,74,NULL),(237,317,-5,NULL),(237,422,1,NULL),(237,612,0,NULL),(237,613,0,NULL),(237,779,NULL,0.625),(238,114,0,NULL),(238,116,0,NULL),(238,117,28,NULL),(238,118,20,NULL),(238,120,NULL,0.5),(238,124,16764120,NULL),(238,128,3,NULL),(238,137,74,NULL),(238,317,0,NULL),(238,422,1,NULL),(238,612,0,NULL),(238,613,0,NULL),(238,779,NULL,0.5),(239,3,0,NULL),(239,9,1,NULL),(239,114,5,NULL),(239,116,0,NULL),(239,117,0,NULL),(239,118,0,NULL),(239,120,NULL,1.6),(239,124,2833864,NULL),(239,128,1,NULL),(239,137,53,NULL),(239,317,-15,NULL),(239,422,1,NULL),(239,612,0,NULL),(239,613,0,NULL),(239,779,NULL,1.6),(239,783,1,NULL),(239,784,NULL,0.00025),(239,786,0,NULL),(240,3,0,NULL),(240,9,1,NULL),(240,114,4,NULL),(240,116,0,NULL),(240,117,0,NULL),(240,118,2,NULL),(240,120,NULL,1.4),(240,124,3105952,NULL),(240,128,1,NULL),(240,137,53,NULL),(240,317,-25,NULL),(240,422,1,NULL),(240,612,0,NULL),(240,613,0,NULL),(240,779,NULL,1.4),(240,783,1,NULL),(240,784,NULL,0.00025),(240,786,0,NULL),(241,3,0,NULL),(241,9,1,NULL),(241,114,5,NULL),(241,116,0,NULL),(241,117,0,NULL),(241,118,2,NULL),(241,120,NULL,1.2),(241,124,5209238,NULL),(241,128,1,NULL),(241,137,53,NULL),(241,317,-35,NULL),(241,422,1,NULL),(241,612,0,NULL),(241,613,0,NULL),(241,779,NULL,1.2),(241,783,1,NULL),(241,784,NULL,0.00025),(241,786,0,NULL),(242,3,0,NULL),(242,9,1,NULL),(242,114,5,NULL),(242,116,0,NULL),(242,117,0,NULL),(242,118,3,NULL),(242,120,1,NULL),(242,124,5215864,NULL),(242,128,1,NULL),(242,137,53,NULL),(242,317,-45,NULL),(242,422,1,NULL),(242,612,0,NULL),(242,613,0,NULL),(242,779,1,NULL),(242,783,1,NULL),(242,784,NULL,0.00025),(242,786,0,NULL),(243,3,0,NULL),(243,9,1,NULL),(243,114,6,NULL),(243,116,0,NULL),(243,117,0,NULL),(243,118,3,NULL),(243,120,NULL,0.875),(243,124,8039008,NULL),(243,128,1,NULL),(243,137,53,NULL),(243,317,-35,NULL),(243,422,1,NULL),(243,612,0,NULL),(243,613,0,NULL),(243,779,NULL,0.875),(243,783,1,NULL),(243,784,NULL,0.00025),(243,786,0,NULL),(244,3,0,NULL),(244,9,1,NULL),(244,114,6,NULL),(244,116,0,NULL),(244,117,0,NULL),(244,118,4,NULL),(244,120,NULL,0.75),(244,124,9202277,NULL),(244,128,1,NULL),(244,137,53,NULL),(244,317,-25,NULL),(244,422,1,NULL),(244,612,0,NULL),(244,613,0,NULL),(244,779,NULL,0.75),(244,783,1,NULL),(244,784,NULL,0.00025),(244,786,0,NULL),(245,3,0,NULL),(245,9,1,NULL),(245,114,7,NULL),(245,116,0,NULL),(245,117,0,NULL),(245,118,4,NULL),(245,120,NULL,0.625),(245,124,16746403,NULL),(245,128,1,NULL),(245,137,53,NULL),(245,317,-15,NULL),(245,422,1,NULL),(245,612,0,NULL),(245,613,0,NULL),(245,779,NULL,0.625),(245,783,1,NULL),(245,784,NULL,0.00025),(245,786,0,NULL),(246,3,0,NULL),(246,9,1,NULL),(246,114,7,NULL),(246,116,0,NULL),(246,117,0,NULL),(246,118,5,NULL),(246,120,NULL,0.5),(246,124,11646664,NULL),(246,128,1,NULL),(246,137,53,NULL),(246,317,0,NULL),(246,422,1,NULL),(246,612,0,NULL),(246,613,0,NULL),(246,779,NULL,0.5),(246,783,1,NULL),(246,784,NULL,0.00025),(246,786,0,NULL),(247,3,0,NULL),(247,9,1,NULL),(247,114,10,NULL),(247,116,0,NULL),(247,117,0,NULL),(247,118,0,NULL),(247,120,NULL,1.6),(247,124,2833864,NULL),(247,128,2,NULL),(247,137,53,NULL),(247,317,-15,NULL),(247,422,1,NULL),(247,612,0,NULL),(247,613,0,NULL),(247,779,NULL,1.6),(247,783,1,NULL),(247,784,NULL,0.00025),(247,786,0,NULL),(248,3,0,NULL),(248,9,1,NULL),(248,114,8,NULL),(248,116,0,NULL),(248,117,0,NULL),(248,118,4,NULL),(248,120,NULL,1.4),(248,124,3105952,NULL),(248,128,2,NULL),(248,137,53,NULL),(248,317,-25,NULL),(248,422,1,NULL),(248,612,0,NULL),(248,613,0,NULL),(248,779,NULL,1.4),(248,783,1,NULL),(248,784,NULL,0.00025),(248,786,0,NULL),(249,3,0,NULL),(249,9,1,NULL),(249,114,10,NULL),(249,116,0,NULL),(249,117,0,NULL),(249,118,4,NULL),(249,120,NULL,1.2),(249,124,5209238,NULL),(249,128,2,NULL),(249,137,53,NULL),(249,317,-35,NULL),(249,422,1,NULL),(249,612,0,NULL),(249,613,0,NULL),(249,779,NULL,1.2),(249,783,1,NULL),(249,784,NULL,0.00025),(249,786,0,NULL),(250,3,0,NULL),(250,9,1,NULL),(250,114,10,NULL),(250,116,0,NULL),(250,117,0,NULL),(250,118,6,NULL),(250,120,1,NULL),(250,124,5215864,NULL),(250,128,2,NULL),(250,137,53,NULL),(250,317,-45,NULL),(250,422,1,NULL),(250,612,0,NULL),(250,613,0,NULL),(250,779,1,NULL),(250,783,1,NULL),(250,784,NULL,0.00025),(250,786,0,NULL),(251,3,0,NULL),(251,9,1,NULL),(251,114,12,NULL),(251,116,0,NULL),(251,117,0,NULL),(251,118,6,NULL),(251,120,NULL,0.875),(251,124,8039008,NULL),(251,128,2,NULL),(251,137,53,NULL),(251,317,-35,NULL),(251,422,1,NULL),(251,612,0,NULL),(251,613,0,NULL),(251,779,NULL,0.875),(251,783,1,NULL),(251,784,NULL,0.00025),(251,786,0,NULL),(252,3,0,NULL),(252,9,1,NULL),(252,114,12,NULL),(252,116,0,NULL),(252,117,0,NULL),(252,118,8,NULL),(252,120,NULL,0.75),(252,124,9202277,NULL),(252,128,2,NULL),(252,137,53,NULL),(252,317,-25,NULL),(252,422,1,NULL),(252,612,0,NULL),(252,613,0,NULL),(252,779,NULL,0.75),(252,783,1,NULL),(252,784,NULL,0.00025),(252,786,0,NULL),(253,3,0,NULL),(253,9,1,NULL),(253,114,14,NULL),(253,116,0,NULL),(253,117,0,NULL),(253,118,8,NULL),(253,120,NULL,0.625),(253,124,16746403,NULL),(253,128,2,NULL),(253,137,53,NULL),(253,317,-15,NULL),(253,422,1,NULL),(253,612,0,NULL),(253,613,0,NULL),(253,779,NULL,0.625),(253,783,1,NULL),(253,784,NULL,0.00025),(253,786,0,NULL),(254,3,0,NULL),(254,9,1,NULL),(254,114,14,NULL),(254,116,0,NULL),(254,117,0,NULL),(254,118,10,NULL),(254,120,NULL,0.5),(254,124,11646664,NULL),(254,128,2,NULL),(254,137,53,NULL),(254,317,0,NULL),(254,422,1,NULL),(254,612,0,NULL),(254,613,0,NULL),(254,779,NULL,0.5),(254,783,1,NULL),(254,784,NULL,0.00025),(254,786,0,NULL),(255,3,0,NULL),(255,9,1,NULL),(255,114,20,NULL),(255,116,0,NULL),(255,117,0,NULL),(255,118,0,NULL),(255,120,NULL,1.6),(255,124,2833864,NULL),(255,128,3,NULL),(255,137,53,NULL),(255,317,-15,NULL),(255,422,1,NULL),(255,612,0,NULL),(255,613,0,NULL),(255,779,NULL,1.6),(255,783,1,NULL),(255,784,NULL,0.00025),(255,786,0,NULL),(256,3,0,NULL),(256,9,1,NULL),(256,114,16,NULL),(256,116,0,NULL),(256,117,0,NULL),(256,118,8,NULL),(256,120,NULL,1.4),(256,124,3105952,NULL),(256,128,3,NULL),(256,137,53,NULL),(256,317,-25,NULL),(256,422,1,NULL),(256,612,0,NULL),(256,613,0,NULL),(256,779,NULL,1.4),(256,783,1,NULL),(256,784,NULL,0.00025),(256,786,0,NULL),(257,3,0,NULL),(257,9,1,NULL),(257,114,20,NULL),(257,116,0,NULL),(257,117,0,NULL),(257,118,8,NULL),(257,120,NULL,1.2),(257,124,5209238,NULL),(257,128,3,NULL),(257,137,53,NULL),(257,317,-35,NULL),(257,422,1,NULL),(257,612,0,NULL),(257,613,0,NULL),(257,779,NULL,1.2),(257,783,1,NULL),(257,784,NULL,0.00025),(257,786,0,NULL),(258,3,0,NULL),(258,9,1,NULL),(258,114,20,NULL),(258,116,0,NULL),(258,117,0,NULL),(258,118,12,NULL),(258,120,1,NULL),(258,124,5215864,NULL),(258,128,3,NULL),(258,137,53,NULL),(258,317,-45,NULL),(258,422,1,NULL),(258,612,0,NULL),(258,613,0,NULL),(258,779,1,NULL),(258,783,1,NULL),(258,784,NULL,0.00025),(258,786,0,NULL),(259,3,0,NULL),(259,9,1,NULL),(259,114,24,NULL),(259,116,0,NULL),(259,117,0,NULL),(259,118,12,NULL),(259,120,NULL,0.875),(259,124,8039008,NULL),(259,128,3,NULL),(259,137,53,NULL),(259,317,-35,NULL),(259,422,1,NULL),(259,612,0,NULL),(259,613,0,NULL),(259,779,NULL,0.875),(259,783,1,NULL),(259,784,NULL,0.00025),(259,786,0,NULL),(260,3,0,NULL),(260,9,1,NULL),(260,114,24,NULL),(260,116,0,NULL),(260,117,0,NULL),(260,118,16,NULL),(260,120,NULL,0.75),(260,124,9202277,NULL),(260,128,3,NULL),(260,137,53,NULL),(260,317,-25,NULL),(260,422,1,NULL),(260,612,0,NULL),(260,613,0,NULL),(260,779,NULL,0.75),(260,783,1,NULL),(260,784,NULL,0.00025),(260,786,0,NULL),(261,3,0,NULL),(261,9,1,NULL),(261,114,28,NULL),(261,116,0,NULL),(261,117,0,NULL),(261,118,16,NULL),(261,120,NULL,0.625),(261,124,16746403,NULL),(261,128,3,NULL),(261,137,53,NULL),(261,317,-15,NULL),(261,422,1,NULL),(261,612,0,NULL),(261,613,0,NULL),(261,779,NULL,0.625),(261,783,1,NULL),(261,784,NULL,0.00025),(261,786,0,NULL),(262,3,0,NULL),(262,9,1,NULL),(262,114,28,NULL),(262,116,0,NULL),(262,117,0,NULL),(262,118,20,NULL),(262,120,NULL,0.5),(262,124,11646664,NULL),(262,128,3,NULL),(262,137,53,NULL),(262,317,0,NULL),(262,422,1,NULL),(262,612,0,NULL),(262,613,0,NULL),(262,779,NULL,0.5),(262,783,1,NULL),(262,784,NULL,0.00025),(262,786,0,NULL),(263,67,25,NULL),(263,137,76,NULL),(264,67,50,NULL),(264,137,76,NULL),(265,9,5,NULL),(265,37,7500,NULL),(265,70,700,NULL),(265,107,500,NULL),(265,114,0,NULL),(265,116,70,NULL),(265,117,0,NULL),(265,118,0,NULL),(265,122,1,NULL),(265,123,1,NULL),(265,137,56,NULL),(265,182,3319,NULL),(265,183,3323,NULL),(265,277,1,NULL),(265,278,1,NULL),(265,281,10000,NULL),(265,422,1,NULL),(265,525,NULL,0.75),(265,612,0,NULL),(265,613,0,NULL),(265,644,1,NULL),(266,9,70,NULL),(266,37,2250,NULL),(266,70,1000,NULL),(266,107,0,NULL),(266,108,35,NULL),(266,114,0,NULL),(266,116,0,NULL),(266,117,25,NULL),(266,118,0,NULL),(266,122,1,NULL),(266,137,507,NULL),(266,182,3320,NULL),(266,183,3319,NULL),(266,277,1,NULL),(266,278,1,NULL),(266,281,2000,NULL),(266,422,1,NULL),(266,525,NULL,0.75),(266,612,0,NULL),(266,613,0,NULL),(266,633,0,NULL),(266,644,1,NULL),(266,653,85,NULL),(266,654,20,NULL),(266,655,1500,NULL),(266,1353,3,NULL),(266,1354,NULL,5.5),(267,9,280,NULL),(267,37,1500,NULL),(267,70,1000,NULL),(267,107,500,NULL),(267,108,35,NULL),(267,114,0,NULL),(267,116,0,NULL),(267,117,450,NULL),(267,118,0,NULL),(267,137,508,NULL),(267,182,3325,NULL),(267,183,3319,NULL),(267,277,1,NULL),(267,278,1,NULL),(267,281,6000,NULL),(267,422,1,NULL),(267,525,NULL,0.75),(267,612,0,NULL),(267,613,0,NULL),(267,633,0,NULL),(267,644,1,NULL),(267,653,71,NULL),(267,654,450,NULL),(267,655,1500,NULL),(267,1353,5,NULL),(267,1354,NULL,5.5),(268,9,20,NULL),(268,114,5,NULL),(268,116,5,NULL),(268,117,5,NULL),(268,118,5,NULL),(268,122,1,NULL),(268,123,1,NULL),(268,137,56,NULL),(268,265,200,NULL),(268,525,NULL,0.75),(268,612,0,NULL),(268,613,0,NULL),(269,9,70,NULL),(269,37,3750,NULL),(269,70,1000,NULL),(269,107,0,NULL),(269,108,35,NULL),(269,114,56,NULL),(269,116,0,NULL),(269,117,0,NULL),(269,118,0,NULL),(269,137,509,NULL),(269,182,3322,NULL),(269,183,3321,NULL),(269,184,3319,NULL),(269,277,1,NULL),(269,278,1,NULL),(269,279,1,NULL),(269,281,5000,NULL),(269,422,1,NULL),(269,525,NULL,0.75),(269,612,0,NULL),(269,613,0,NULL),(269,644,1,NULL),(269,653,170,NULL),(269,654,50,NULL),(269,655,1500,NULL),(269,1353,NULL,2.8),(269,1354,NULL,5.5),(270,9,100,NULL),(270,107,500,NULL),(270,114,30,NULL),(270,116,0,NULL),(270,117,0,NULL),(270,118,0,NULL),(270,154,500,NULL),(270,156,NULL,0.75),(270,182,3319,NULL),(270,277,1,NULL),(270,525,NULL,0.75),(270,612,0,NULL),(270,613,0,NULL),(377,9,40,NULL),(377,30,2,NULL),(377,50,20,NULL),(377,72,188,NULL),(377,182,3425,NULL),(377,277,1,NULL),(377,422,1,NULL),(377,633,0,NULL),(377,983,2,NULL),(380,9,40,NULL),(380,30,3,NULL),(380,50,23,NULL),(380,72,263,NULL),(380,182,3425,NULL),(380,277,3,NULL),(380,422,2,NULL),(380,633,5,NULL),(380,983,2,NULL),(393,9,40,NULL),(393,30,1,NULL),(393,50,25,NULL),(393,134,NULL,0.9),(393,182,3425,NULL),(393,277,3,NULL),(393,422,1,NULL),(393,633,0,NULL),(394,9,40,NULL),(394,30,1,NULL),(394,50,30,NULL),(394,134,NULL,0.85),(394,182,3425,NULL),(394,277,4,NULL),(394,422,2,NULL),(394,633,5,NULL),(399,6,20,NULL),(399,9,40,NULL),(399,30,2,NULL),(399,50,25,NULL),(399,68,23,NULL),(399,73,2000,NULL),(399,182,3416,NULL),(399,277,1,NULL),(399,422,1,NULL),(399,633,0,NULL),(399,1180,NULL,0.01),(399,1206,-15,NULL),(399,1211,NULL,0.8),(399,1212,1,NULL),(399,1231,10,NULL),(400,6,20,NULL),(400,9,40,NULL),(400,30,3,NULL),(400,50,29,NULL),(400,68,30,NULL),(400,73,2000,NULL),(400,182,3416,NULL),(400,277,3,NULL),(400,422,2,NULL),(400,633,5,NULL),(400,1180,NULL,0.02),(400,1206,-15,NULL),(400,1211,NULL,0.8),(400,1212,1,NULL),(400,1231,10,NULL),(405,6,33,NULL),(405,9,40,NULL),(405,30,4,NULL),(405,50,35,NULL),(405,68,40,NULL),(405,73,5000,NULL),(405,87,3000,NULL),(405,182,3422,NULL),(405,277,1,NULL),(405,422,1,NULL),(405,633,0,NULL),(405,1180,NULL,0.01),(405,1206,-15,NULL),(405,1211,NULL,2.2),(405,1212,1,NULL),(406,6,30,NULL),(406,9,40,NULL),(406,30,5,NULL),(406,50,42,NULL),(406,68,48,NULL),(406,73,4500,NULL),(406,87,3600,NULL),(406,182,3422,NULL),(406,277,2,NULL),(406,422,2,NULL),(406,633,5,NULL),(406,1180,NULL,0.02),(406,1206,-15,NULL),(406,1211,2,NULL),(406,1212,1,NULL),(421,9,40,NULL),(421,30,1,NULL),(421,50,5,NULL),(421,144,NULL,0.9),(421,182,3424,NULL),(421,277,2,NULL),(421,422,1,NULL),(421,633,0,NULL),(434,6,45,NULL),(434,9,40,NULL),(434,20,500,NULL),(434,30,15,NULL),(434,50,25,NULL),(434,73,10000,NULL),(434,147,NULL,0.75),(434,182,3454,NULL),(434,277,1,NULL),(434,422,1,NULL),(434,554,500,NULL),(434,567,1500000,NULL),(434,576,NULL,0.01),(434,578,1,NULL),(434,633,0,NULL),(434,669,0,NULL),(434,763,1,NULL),(434,796,500000,NULL),(434,801,1,NULL),(434,914,0,NULL),(434,920,0,NULL),(434,1180,NULL,0.04),(434,1211,19,NULL),(434,1212,1,NULL),(434,1223,50,NULL),(438,6,22,NULL),(438,9,40,NULL),(438,20,135,NULL),(438,30,11,NULL),(438,50,15,NULL),(438,73,10000,NULL),(438,147,1,NULL),(438,182,3450,NULL),(438,277,4,NULL),(438,422,2,NULL),(438,567,1500000,NULL),(438,576,NULL,0.01),(438,578,1,NULL),(438,633,5,NULL),(438,763,1,NULL),(438,796,500000,NULL),(438,801,0,NULL),(438,914,0,NULL),(438,920,0,NULL),(438,1180,NULL,0.04),(438,1211,NULL,9.6),(438,1212,1,NULL),(438,1223,50,NULL),(439,6,20,NULL),(439,9,40,NULL),(439,20,NULL,112.5),(439,30,10,NULL),(439,50,15,NULL),(439,73,10000,NULL),(439,147,1,NULL),(439,182,3450,NULL),(439,277,1,NULL),(439,422,1,NULL),(439,567,1500000,NULL),(439,576,NULL,0.01),(439,578,1,NULL),(439,633,0,NULL),(439,763,1,NULL),(439,796,500000,NULL),(439,801,0,NULL),(439,914,0,NULL),(439,920,0,NULL),(439,1180,NULL,0.04),(439,1211,NULL,9.6),(439,1212,1,NULL),(439,1223,50,NULL),(440,6,50,NULL),(440,9,40,NULL),(440,20,500,NULL),(440,30,17,NULL),(440,50,25,NULL),(440,73,10000,NULL),(440,147,NULL,0.83),(440,182,3454,NULL),(440,277,3,NULL),(440,422,2,NULL),(440,554,500,NULL),(440,567,1500000,NULL),(440,576,NULL,0.01),(440,578,1,NULL),(440,633,5,NULL),(440,669,0,NULL),(440,763,1,NULL),(440,796,500000,NULL),(440,801,1,NULL),(440,914,0,NULL),(440,920,0,NULL),(440,1180,NULL,0.04),(440,1211,19,NULL),(440,1212,1,NULL),(440,1223,50,NULL),(442,6,4,NULL),(442,9,40,NULL),(442,30,1,NULL),(442,50,5,NULL),(442,73,5000,NULL),(442,126,50000,NULL),(442,158,30000,NULL),(442,182,3426,NULL),(442,277,1,NULL),(442,422,1,NULL),(442,633,0,NULL),(442,1014,1,NULL),(443,6,5,NULL),(443,9,40,NULL),(443,30,1,NULL),(443,47,1,NULL),(443,50,15,NULL),(443,73,2000,NULL),(443,125,50000,NULL),(443,182,3426,NULL),(443,277,1,NULL),(443,422,1,NULL),(443,510,30000,NULL),(443,633,0,NULL),(443,1014,1,NULL),(444,6,5,NULL),(444,9,40,NULL),(444,30,1,NULL),(444,50,5,NULL),(444,73,5000,NULL),(444,182,3426,NULL),(444,189,11,NULL),(444,197,15000,NULL),(444,277,1,NULL),(444,422,1,NULL),(444,633,0,NULL),(444,1014,1,NULL),(447,6,5,NULL),(447,9,40,NULL),(447,30,1,NULL),(447,50,30,NULL),(447,54,7500,NULL),(447,73,5000,NULL),(447,103,0,NULL),(447,105,2,NULL),(447,158,0,NULL),(447,182,3435,NULL),(447,277,1,NULL),(447,422,1,NULL),(447,633,0,NULL),(447,815,0,NULL),(447,816,0,NULL),(447,817,0,NULL),(447,818,0,NULL),(447,1180,NULL,0.01),(447,1211,5,NULL),(447,1212,1,NULL),(447,1222,20,NULL),(447,1350,1,NULL),(448,6,5,NULL),(448,9,40,NULL),(448,30,1,NULL),(448,50,36,NULL),(448,54,9000,NULL),(448,73,5000,NULL),(448,103,0,NULL),(448,105,2,NULL),(448,158,0,NULL),(448,182,3435,NULL),(448,277,2,NULL),(448,422,2,NULL),(448,633,5,NULL),(448,815,0,NULL),(448,816,0,NULL),(448,817,0,NULL),(448,818,0,NULL),(448,1180,NULL,0.02),(448,1211,5,NULL),(448,1212,1,NULL),(448,1222,20,NULL),(448,1350,1,NULL),(450,6,NULL,1.82),(450,9,40,NULL),(450,30,5,NULL),(450,47,1,NULL),(450,50,4,NULL),(450,51,2100,NULL),(450,54,4000,NULL),(450,61,0,NULL),(450,64,NULL,1.5),(450,128,1,NULL),(450,158,500,NULL),(450,160,NULL,0.308125),(450,182,3303,NULL),(450,183,3300,NULL),(450,277,1,NULL),(450,278,1,NULL),(450,422,1,NULL),(450,604,86,NULL),(450,620,40,NULL),(450,633,0,NULL),(450,1180,NULL,0.01),(450,1210,15,NULL),(450,1211,NULL,0.6),(450,1212,1,NULL),(451,6,NULL,2.67),(451,9,40,NULL),(451,30,6,NULL),(451,47,1,NULL),(451,50,8,NULL),(451,51,2700,NULL),(451,54,4500,NULL),(451,61,0,NULL),(451,64,2,NULL),(451,128,1,NULL),(451,158,1500,NULL),(451,160,NULL,0.27375),(451,182,3303,NULL),(451,183,3300,NULL),(451,277,1,NULL),(451,278,1,NULL),(451,422,1,NULL),(451,604,86,NULL),(451,620,40,NULL),(451,633,0,NULL),(451,1180,NULL,0.01),(451,1210,15,NULL),(451,1211,NULL,0.6),(451,1212,1,NULL),(452,6,NULL,3.89),(452,9,40,NULL),(452,30,7,NULL),(452,47,1,NULL),(452,50,12,NULL),(452,51,3200,NULL),(452,54,8750,NULL),(452,61,0,NULL),(452,64,2,NULL),(452,128,1,NULL),(452,158,3000,NULL),(452,160,NULL,0.13),(452,182,3303,NULL),(452,183,3300,NULL),(452,277,1,NULL),(452,278,1,NULL),(452,422,1,NULL),(452,604,86,NULL),(452,620,40,NULL),(452,633,0,NULL),(452,1180,NULL,0.01),(452,1205,-15,NULL),(452,1211,NULL,0.8),(452,1212,1,NULL),(453,6,NULL,4.44),(453,9,40,NULL),(453,30,11,NULL),(453,47,1,NULL),(453,50,16,NULL),(453,51,3500,NULL),(453,54,5000,NULL),(453,61,0,NULL),(453,64,3,NULL),(453,128,1,NULL),(453,158,2000,NULL),(453,160,NULL,0.24625),(453,182,3303,NULL),(453,183,3300,NULL),(453,277,1,NULL),(453,278,1,NULL),(453,422,1,NULL),(453,604,86,NULL),(453,620,40,NULL),(453,633,0,NULL),(453,1180,NULL,0.01),(453,1210,15,NULL),(453,1211,NULL,0.8),(453,1212,1,NULL),(454,6,NULL,7.22),(454,9,40,NULL),(454,30,13,NULL),(454,47,1,NULL),(454,50,20,NULL),(454,51,4000,NULL),(454,54,10000,NULL),(454,61,0,NULL),(454,64,3,NULL),(454,128,1,NULL),(454,158,4000,NULL),(454,160,NULL,0.1),(454,182,3303,NULL),(454,183,3300,NULL),(454,277,1,NULL),(454,278,1,NULL),(454,422,1,NULL),(454,604,86,NULL),(454,620,40,NULL),(454,633,0,NULL),(454,1180,NULL,0.01),(454,1205,-15,NULL),(454,1211,1,NULL),(454,1212,1,NULL),(455,6,NULL,5.45),(455,9,40,NULL),(455,30,90,NULL),(455,47,1,NULL),(455,50,25,NULL),(455,51,3150,NULL),(455,54,8000,NULL),(455,61,0,NULL),(455,64,NULL,1.5),(455,128,2,NULL),(455,158,1000,NULL),(455,160,NULL,0.081),(455,182,3306,NULL),(455,183,3300,NULL),(455,277,1,NULL),(455,278,3,NULL),(455,422,1,NULL),(455,604,86,NULL),(455,620,125,NULL),(455,633,0,NULL),(455,1180,NULL,0.01),(455,1205,-15,NULL),(455,1211,NULL,0.5),(455,1212,1,NULL),(456,6,8,NULL),(456,9,40,NULL),(456,30,120,NULL),(456,47,1,NULL),(456,50,28,NULL),(456,51,4050,NULL),(456,54,9000,NULL),(456,61,0,NULL),(456,64,2,NULL),(456,128,2,NULL),(456,158,3000,NULL),(456,160,NULL,0.09),(456,182,3306,NULL),(456,183,3300,NULL),(456,277,1,NULL),(456,278,3,NULL),(456,422,1,NULL),(456,604,86,NULL),(456,620,125,NULL),(456,633,0,NULL),(456,1180,NULL,0.01),(456,1210,15,NULL),(456,1211,NULL,0.6),(456,1212,1,NULL),(457,6,NULL,11.67),(457,9,40,NULL),(457,30,150,NULL),(457,47,1,NULL),(457,50,30,NULL),(457,51,4800,NULL),(457,54,17500,NULL),(457,61,0,NULL),(457,64,2,NULL),(457,128,2,NULL),(457,158,6000,NULL),(457,160,NULL,0.042),(457,182,3306,NULL),(457,183,3300,NULL),(457,277,1,NULL),(457,278,3,NULL),(457,422,1,NULL),(457,604,86,NULL),(457,620,125,NULL),(457,633,0,NULL),(457,1180,NULL,0.01),(457,1205,-15,NULL),(457,1211,NULL,0.7),(457,1212,1,NULL),(458,6,NULL,13.33),(458,9,40,NULL),(458,30,210,NULL),(458,47,1,NULL),(458,50,33,NULL),(458,51,5250,NULL),(458,54,10000,NULL),(458,61,0,NULL),(458,64,3,NULL),(458,128,2,NULL),(458,158,4000,NULL),(458,160,NULL,0.08125),(458,182,3306,NULL),(458,183,3300,NULL),(458,277,1,NULL),(458,278,3,NULL),(458,422,1,NULL),(458,604,86,NULL),(458,620,125,NULL),(458,633,0,NULL),(458,1180,NULL,0.01),(458,1210,15,NULL),(458,1211,NULL,0.8),(458,1212,1,NULL),(459,6,NULL,21.67),(459,9,40,NULL),(459,30,250,NULL),(459,47,1,NULL),(459,50,35,NULL),(459,51,6000,NULL),(459,54,20000,NULL),(459,61,0,NULL),(459,64,3,NULL),(459,128,2,NULL),(459,158,8000,NULL),(459,160,NULL,0.033),(459,182,3306,NULL),(459,183,3300,NULL),(459,277,1,NULL),(459,278,3,NULL),(459,422,1,NULL),(459,604,86,NULL),(459,620,125,NULL),(459,633,0,NULL),(459,1180,NULL,0.01),(459,1205,-15,NULL),(459,1211,NULL,0.9),(459,1212,1,NULL),(460,6,25,NULL),(460,9,40,NULL),(460,30,1500,NULL),(460,47,1,NULL),(460,50,40,NULL),(460,51,6075,NULL),(460,54,18000,NULL),(460,61,0,NULL),(460,64,2,NULL),(460,128,3,NULL),(460,158,6000,NULL),(460,160,NULL,0.0375),(460,182,3309,NULL),(460,183,3300,NULL),(460,277,1,NULL),(460,278,5,NULL),(460,422,1,NULL),(460,604,86,NULL),(460,620,400,NULL),(460,633,0,NULL),(460,1180,NULL,0.01),(460,1210,15,NULL),(460,1211,NULL,0.7),(460,1212,1,NULL),(461,6,35,NULL),(461,9,40,NULL),(461,30,1750,NULL),(461,47,1,NULL),(461,50,45,NULL),(461,51,7200,NULL),(461,54,35000,NULL),(461,61,0,NULL),(461,64,2,NULL),(461,128,3,NULL),(461,158,12000,NULL),(461,160,NULL,0.0175),(461,182,3309,NULL),(461,183,3300,NULL),(461,277,1,NULL),(461,278,5,NULL),(461,422,1,NULL),(461,604,86,NULL),(461,620,400,NULL),(461,633,0,NULL),(461,1180,NULL,0.01),(461,1205,-15,NULL),(461,1211,NULL,0.8),(461,1212,1,NULL),(462,6,40,NULL),(462,9,40,NULL),(462,30,2500,NULL),(462,47,1,NULL),(462,50,50,NULL),(462,51,7875,NULL),(462,54,20000,NULL),(462,61,0,NULL),(462,64,3,NULL),(462,128,3,NULL),(462,158,8000,NULL),(462,160,NULL,0.03375),(462,182,3309,NULL),(462,183,3300,NULL),(462,277,1,NULL),(462,278,5,NULL),(462,422,1,NULL),(462,604,86,NULL),(462,620,400,NULL),(462,633,0,NULL),(462,1180,NULL,0.01),(462,1210,15,NULL),(462,1211,NULL,0.9),(462,1212,1,NULL),(463,6,65,NULL),(463,9,40,NULL),(463,30,3250,NULL),(463,47,1,NULL),(463,50,55,NULL),(463,51,9000,NULL),(463,54,40000,NULL),(463,61,0,NULL),(463,64,3,NULL),(463,128,3,NULL),(463,158,16000,NULL),(463,160,NULL,0.0153125),(463,182,3309,NULL),(463,183,3300,NULL),(463,277,1,NULL),(463,278,5,NULL),(463,422,1,NULL),(463,604,86,NULL),(463,620,400,NULL),(463,633,0,NULL),(463,1180,NULL,0.01),(463,1205,-15,NULL),(463,1211,1,NULL),(463,1212,1,NULL),(464,6,95,NULL),(464,9,40,NULL),(464,30,3750,NULL),(464,47,1,NULL),(464,50,60,NULL),(464,51,12500,NULL),(464,54,44000,NULL),(464,61,0,NULL),(464,64,NULL,4.5),(464,128,3,NULL),(464,158,20000,NULL),(464,160,NULL,0.0139205),(464,182,3309,NULL),(464,183,3300,NULL),(464,277,1,NULL),(464,278,5,NULL),(464,422,1,NULL),(464,604,86,NULL),(464,620,400,NULL),(464,633,0,NULL),(464,1180,NULL,0.01),(464,1205,-15,NULL),(464,1211,NULL,1.4),(464,1212,1,NULL),(482,6,90,NULL),(482,9,40,NULL),(482,30,4,NULL),(482,47,1,NULL),(482,50,80,NULL),(482,54,12000,NULL),(482,73,60000,NULL),(482,77,60,NULL),(482,182,3386,NULL),(482,189,11,NULL),(482,277,4,NULL),(482,422,2,NULL),(482,633,5,NULL),(482,786,1,NULL),(483,6,10,NULL),(483,9,40,NULL),(483,30,2,NULL),(483,47,1,NULL),(483,50,60,NULL),(483,54,10000,NULL),(483,73,60000,NULL),(483,77,40,NULL),(483,182,3386,NULL),(483,189,11,NULL),(483,277,1,NULL),(483,422,1,NULL),(483,633,0,NULL),(483,786,1,NULL),(484,6,0,NULL),(484,9,40,NULL),(484,30,1,NULL),(484,47,1,NULL),(484,50,3,NULL),(484,51,3000,NULL),(484,54,800,NULL),(484,56,1,NULL),(484,63,0,NULL),(484,64,NULL,2.0625),(484,128,1,NULL),(484,158,4000,NULL),(484,160,NULL,0.395),(484,182,3302,NULL),(484,183,3300,NULL),(484,277,1,NULL),(484,278,1,NULL),(484,422,1,NULL),(484,604,83,NULL),(484,620,40,NULL),(484,633,0,NULL),(484,920,0,NULL),(484,1180,NULL,0.01),(484,1210,15,NULL),(484,1211,NULL,0.8),(484,1212,1,NULL),(485,6,0,NULL),(485,9,40,NULL),(485,30,2,NULL),(485,47,1,NULL),(485,50,6,NULL),(485,51,3375,NULL),(485,54,900,NULL),(485,56,1,NULL),(485,63,0,NULL),(485,64,NULL,2.475),(485,128,1,NULL),(485,158,4000,NULL),(485,160,NULL,0.35),(485,182,3302,NULL),(485,183,3300,NULL),(485,277,1,NULL),(485,278,1,NULL),(485,422,1,NULL),(485,604,83,NULL),(485,620,40,NULL),(485,633,0,NULL),(485,920,0,NULL),(485,1180,NULL,0.01),(485,1210,15,NULL),(485,1211,NULL,0.8),(485,1212,1,NULL),(486,6,0,NULL),(486,9,40,NULL),(486,30,4,NULL),(486,47,1,NULL),(486,50,9,NULL),(486,51,3750,NULL),(486,54,1000,NULL),(486,56,1,NULL),(486,63,0,NULL),(486,64,NULL,2.8875),(486,128,1,NULL),(486,158,4000,NULL),(486,160,NULL,0.315),(486,182,3302,NULL),(486,183,3300,NULL),(486,277,1,NULL),(486,278,1,NULL),(486,422,1,NULL),(486,604,83,NULL),(486,620,40,NULL),(486,633,0,NULL),(486,920,0,NULL),(486,1180,NULL,0.01),(486,1210,15,NULL),(486,1211,1,NULL),(486,1212,1,NULL),(487,6,0,NULL),(487,9,40,NULL),(487,30,8,NULL),(487,47,1,NULL),(487,50,12,NULL),(487,51,8500,NULL),(487,54,8050,NULL),(487,56,1,NULL),(487,63,0,NULL),(487,64,NULL,4.62),(487,128,1,NULL),(487,158,8750,NULL),(487,160,NULL,0.082),(487,182,3302,NULL),(487,183,3300,NULL),(487,277,1,NULL),(487,278,1,NULL),(487,422,1,NULL),(487,604,83,NULL),(487,620,40,NULL),(487,633,0,NULL),(487,920,0,NULL),(487,1180,NULL,0.01),(487,1205,-15,NULL),(487,1211,NULL,2.2),(487,1212,1,NULL),(488,6,0,NULL),(488,9,40,NULL),(488,30,12,NULL),(488,47,1,NULL),(488,50,15,NULL),(488,51,10500,NULL),(488,54,10000,NULL),(488,56,1,NULL),(488,63,0,NULL),(488,64,NULL,6.0375),(488,128,1,NULL),(488,158,8750,NULL),(488,160,NULL,0.066),(488,182,3302,NULL),(488,183,3300,NULL),(488,277,1,NULL),(488,278,1,NULL),(488,422,1,NULL),(488,604,83,NULL),(488,620,40,NULL),(488,633,0,NULL),(488,920,0,NULL),(488,1180,NULL,0.01),(488,1205,-15,NULL),(488,1211,NULL,2.6),(488,1212,1,NULL),(489,6,0,NULL),(489,9,40,NULL),(489,30,80,NULL),(489,47,1,NULL),(489,50,18,NULL),(489,51,4500,NULL),(489,54,1600,NULL),(489,56,1,NULL),(489,63,0,NULL),(489,64,NULL,2.0625),(489,128,2,NULL),(489,158,8000,NULL),(489,160,NULL,0.132),(489,182,3305,NULL),(489,183,3300,NULL),(489,277,1,NULL),(489,278,3,NULL),(489,422,1,NULL),(489,604,83,NULL),(489,620,125,NULL),(489,633,0,NULL),(489,920,0,NULL),(489,1180,NULL,0.01),(489,1210,15,NULL),(489,1211,NULL,0.7),(489,1212,1,NULL),(490,6,0,NULL),(490,9,40,NULL),(490,30,100,NULL),(490,47,1,NULL),(490,50,21,NULL),(490,51,4725,NULL),(490,54,1800,NULL),(490,56,1,NULL),(490,63,0,NULL),(490,64,NULL,2.31),(490,128,2,NULL),(490,158,8000,NULL),(490,160,NULL,0.1175),(490,182,3305,NULL),(490,183,3300,NULL),(490,277,1,NULL),(490,278,3,NULL),(490,422,1,NULL),(490,604,83,NULL),(490,620,125,NULL),(490,633,0,NULL),(490,920,0,NULL),(490,1180,NULL,0.01),(490,1210,15,NULL),(490,1211,NULL,0.7),(490,1212,1,NULL),(491,6,0,NULL),(491,9,40,NULL),(491,30,140,NULL),(491,47,1,NULL),(491,50,24,NULL),(491,51,5625,NULL),(491,54,2000,NULL),(491,56,1,NULL),(491,63,0,NULL),(491,64,NULL,2.8875),(491,128,2,NULL),(491,158,8000,NULL),(491,160,NULL,0.1056),(491,182,3305,NULL),(491,183,3300,NULL),(491,277,1,NULL),(491,278,3,NULL),(491,422,1,NULL),(491,604,83,NULL),(491,620,125,NULL),(491,633,0,NULL),(491,920,0,NULL),(491,1180,NULL,0.01),(491,1210,15,NULL),(491,1211,NULL,0.8),(491,1212,1,NULL),(492,6,0,NULL),(492,9,40,NULL),(492,30,200,NULL),(492,47,1,NULL),(492,50,27,NULL),(492,51,12750,NULL),(492,54,16100,NULL),(492,56,1,NULL),(492,63,0,NULL),(492,64,NULL,4.62),(492,128,2,NULL),(492,158,17500,NULL),(492,160,NULL,0.027),(492,182,3305,NULL),(492,183,3300,NULL),(492,277,1,NULL),(492,278,3,NULL),(492,422,1,NULL),(492,604,83,NULL),(492,620,125,NULL),(492,633,0,NULL),(492,920,0,NULL),(492,1180,NULL,0.01),(492,1205,-15,NULL),(492,1211,NULL,1.9),(492,1212,1,NULL),(493,6,0,NULL),(493,9,40,NULL),(493,30,250,NULL),(493,47,1,NULL),(493,50,30,NULL),(493,51,15750,NULL),(493,54,20000,NULL),(493,56,1,NULL),(493,63,0,NULL),(493,64,NULL,6.0375),(493,128,2,NULL),(493,158,17500,NULL),(493,160,NULL,0.022),(493,182,3305,NULL),(493,183,3300,NULL),(493,277,1,NULL),(493,278,3,NULL),(493,422,1,NULL),(493,604,83,NULL),(493,620,125,NULL),(493,633,0,NULL),(493,920,0,NULL),(493,1180,NULL,0.01),(493,1205,-15,NULL),(493,1211,NULL,2.4),(493,1212,1,NULL),(494,6,0,NULL),(494,9,40,NULL),(494,30,1250,NULL),(494,47,1,NULL),(494,50,33,NULL),(494,51,6750,NULL),(494,54,3200,NULL),(494,56,1,NULL),(494,63,0,NULL),(494,64,NULL,2.0625),(494,128,3,NULL),(494,158,16000,NULL),(494,160,NULL,0.054),(494,182,3308,NULL),(494,183,3300,NULL),(494,277,1,NULL),(494,278,5,NULL),(494,422,1,NULL),(494,604,83,NULL),(494,620,400,NULL),(494,633,0,NULL),(494,920,0,NULL),(494,1180,NULL,0.01),(494,1210,15,NULL),(494,1211,NULL,0.7),(494,1212,1,NULL),(495,6,0,NULL),(495,9,40,NULL),(495,30,1500,NULL),(495,47,1,NULL),(495,50,36,NULL),(495,51,7500,NULL),(495,54,3600,NULL),(495,56,1,NULL),(495,63,0,NULL),(495,64,NULL,2.444203042),(495,128,3,NULL),(495,158,16000,NULL),(495,160,NULL,0.048),(495,182,3308,NULL),(495,183,3300,NULL),(495,277,1,NULL),(495,278,5,NULL),(495,422,1,NULL),(495,604,83,NULL),(495,620,400,NULL),(495,633,0,NULL),(495,920,0,NULL),(495,1180,NULL,0.01),(495,1210,15,NULL),(495,1211,NULL,0.8),(495,1212,1,NULL),(496,6,0,NULL),(496,9,40,NULL),(496,30,2000,NULL),(496,47,1,NULL),(496,50,39,NULL),(496,51,7875,NULL),(496,54,4000,NULL),(496,56,1,NULL),(496,63,0,NULL),(496,64,NULL,2.695),(496,128,3,NULL),(496,158,16000,NULL),(496,160,NULL,0.0432),(496,182,3308,NULL),(496,183,3300,NULL),(496,277,1,NULL),(496,278,5,NULL),(496,422,1,NULL),(496,604,83,NULL),(496,620,400,NULL),(496,633,0,NULL),(496,920,0,NULL),(496,1180,NULL,0.01),(496,1210,15,NULL),(496,1211,NULL,0.9),(496,1212,1,NULL),(497,6,0,NULL),(497,9,40,NULL),(497,30,2750,NULL),(497,47,1,NULL),(497,50,42,NULL),(497,51,19125,NULL),(497,54,32200,NULL),(497,56,1,NULL),(497,63,0,NULL),(497,64,NULL,4.62),(497,128,3,NULL),(497,158,35000,NULL),(497,160,NULL,0.01125),(497,182,3308,NULL),(497,183,3300,NULL),(497,277,1,NULL),(497,278,5,NULL),(497,422,1,NULL),(497,604,83,NULL),(497,620,400,NULL),(497,633,0,NULL),(497,920,0,NULL),(497,1180,NULL,0.01),(497,1205,-15,NULL),(497,1211,NULL,2.1),(497,1212,1,NULL),(498,6,0,NULL),(498,9,40,NULL),(498,30,3250,NULL),(498,47,1,NULL),(498,50,45,NULL),(498,51,23625,NULL),(498,54,40000,NULL),(498,56,1,NULL),(498,63,0,NULL),(498,64,NULL,6.0375),(498,128,3,NULL),(498,158,35000,NULL),(498,160,NULL,0.009),(498,182,3308,NULL),(498,183,3300,NULL),(498,277,1,NULL),(498,278,5,NULL),(498,422,1,NULL),(498,604,83,NULL),(498,620,400,NULL),(498,633,0,NULL),(498,920,0,NULL),(498,1180,NULL,0.01),(498,1205,-15,NULL),(498,1211,NULL,2.6),(498,1212,1,NULL),(499,9,40,NULL),(499,30,8,NULL),(499,47,1,NULL),(499,50,25,NULL),(499,51,15000,NULL),(499,56,1,NULL),(499,182,3319,NULL),(499,277,1,NULL),(499,422,1,NULL),(499,604,384,NULL),(499,605,394,NULL),(499,606,88,NULL),(499,633,0,NULL),(499,1180,NULL,0.01),(499,1205,-15,NULL),(499,1211,NULL,3.8),(499,1212,1,NULL),(501,9,40,NULL),(501,30,100,NULL),(501,47,1,NULL),(501,50,50,NULL),(501,51,15000,NULL),(501,56,1,NULL),(501,182,3319,NULL),(501,277,1,NULL),(501,422,1,NULL),(501,604,385,NULL),(501,605,395,NULL),(501,606,88,NULL),(501,633,0,NULL),(501,1180,NULL,0.01),(501,1205,-15,NULL),(501,1211,NULL,2.3),(501,1212,1,NULL),(503,9,40,NULL),(503,30,1750,NULL),(503,47,1,NULL),(503,50,80,NULL),(503,51,18000,NULL),(503,56,1,NULL),(503,182,3319,NULL),(503,277,1,NULL),(503,422,1,NULL),(503,606,89,NULL),(503,609,88,NULL),(503,633,0,NULL),(503,1180,NULL,0.01),(503,1205,-15,NULL),(503,1211,NULL,2.6),(503,1212,1,NULL),(506,9,40,NULL),(506,30,0,NULL),(506,50,2,NULL),(506,144,NULL,0.9),(506,145,1,NULL),(506,146,1,NULL),(506,147,1,NULL),(506,182,3424,NULL),(506,277,1,NULL),(506,422,1,NULL),(506,548,-5,NULL),(506,633,0,NULL),(508,9,40,NULL),(508,30,0,NULL),(508,50,10,NULL),(508,134,NULL,0.8),(508,144,1,NULL),(508,145,1,NULL),(508,146,NULL,0.9),(508,147,1,NULL),(508,182,3424,NULL),(508,277,1,NULL),(508,422,1,NULL),(508,633,0,NULL),(509,9,40,NULL),(509,30,0,NULL),(509,50,10,NULL),(509,134,1,NULL),(509,144,NULL,0.8),(509,145,1,NULL),(509,146,1,NULL),(509,147,NULL,0.9),(509,182,3424,NULL),(509,277,1,NULL),(509,422,1,NULL),(509,633,0,NULL),(518,9,40,NULL),(518,30,1,NULL),(518,50,20,NULL),(518,64,NULL,1.05),(518,182,3318,NULL),(518,204,NULL,0.95),(518,277,1,NULL),(518,422,1,NULL),(518,633,0,NULL),(519,9,40,NULL),(519,30,1,NULL),(519,50,30,NULL),(519,64,NULL,1.1),(519,182,3318,NULL),(519,204,NULL,0.895),(519,277,4,NULL),(519,422,2,NULL),(519,633,5,NULL),(520,9,40,NULL),(520,30,1,NULL),(520,50,30,NULL),(520,64,NULL,1.07),(520,182,3318,NULL),(520,204,NULL,0.925),(520,277,1,NULL),(520,422,1,NULL),(520,633,0,NULL),(521,6,1,NULL),(521,9,40,NULL),(521,30,1,NULL),(521,50,25,NULL),(521,73,30000,NULL),(521,182,3392,NULL),(521,267,NULL,0.925),(521,268,NULL,0.925),(521,269,NULL,0.925),(521,270,NULL,0.925),(521,271,NULL,0.95),(521,272,NULL,0.95),(521,273,NULL,0.95),(521,274,NULL,0.95),(521,277,1,NULL),(521,422,1,NULL),(521,633,0,NULL),(521,763,1,NULL),(521,974,NULL,0.55),(521,975,NULL,0.55),(521,976,NULL,0.55),(521,977,NULL,0.55),(521,1544,1,NULL),(522,9,40,NULL),(522,30,5,NULL),(522,50,25,NULL),(522,67,38,NULL),(522,182,3413,NULL),(522,277,1,NULL),(522,422,1,NULL),(522,633,0,NULL),(523,6,40,NULL),(523,9,40,NULL),(523,30,5,NULL),(523,50,5,NULL),(523,73,6000,NULL),(523,84,60,NULL),(523,182,3393,NULL),(523,183,3392,NULL),(523,277,1,NULL),(523,278,1,NULL),(523,422,1,NULL),(523,633,0,NULL),(523,1180,NULL,0.01),(523,1206,-15,NULL),(523,1211,NULL,5.4),(523,1212,1,NULL),(523,1230,10,NULL),(524,6,30,NULL),(524,9,40,NULL),(524,30,10,NULL),(524,50,30,NULL),(524,73,30000,NULL),(524,83,25,NULL),(524,182,3393,NULL),(524,183,3392,NULL),(524,277,1,NULL),(524,278,1,NULL),(524,422,1,NULL),(524,633,0,NULL),(524,1180,NULL,0.01),(524,1206,-15,NULL),(524,1211,NULL,13.3),(524,1212,1,NULL),(526,6,5,NULL),(526,9,40,NULL),(526,20,-50,NULL),(526,30,1,NULL),(526,50,25,NULL),(526,54,10000,NULL),(526,73,5000,NULL),(526,158,0,NULL),(526,182,3435,NULL),(526,277,1,NULL),(526,422,1,NULL),(526,633,0,NULL),(526,1180,NULL,0.01),(526,1211,5,NULL),(526,1212,1,NULL),(526,1222,30,NULL),(527,6,6,NULL),(527,9,40,NULL),(527,20,-60,NULL),(527,30,1,NULL),(527,50,30,NULL),(527,54,10000,NULL),(527,73,5000,NULL),(527,158,0,NULL),(527,182,3435,NULL),(527,277,4,NULL),(527,422,2,NULL),(527,633,5,NULL),(527,1180,NULL,0.02),(527,1211,5,NULL),(527,1212,1,NULL),(527,1222,30,NULL),(529,6,38,NULL),(529,9,40,NULL),(529,30,4,NULL),(529,50,30,NULL),(529,73,5000,NULL),(529,90,30,NULL),(529,91,3500,NULL),(529,182,3423,NULL),(529,277,1,NULL),(529,422,1,NULL),(529,633,0,NULL),(529,1180,NULL,0.01),(529,1206,-15,NULL),(529,1211,NULL,2.2),(529,1212,1,NULL),(530,6,0,NULL),(530,9,40,NULL),(530,30,8,NULL),(530,50,15,NULL),(530,73,3000,NULL),(530,90,8,NULL),(530,91,5500,NULL),(530,182,3423,NULL),(530,277,1,NULL),(530,422,1,NULL),(530,633,0,NULL),(530,918,0,NULL),(530,1015,NULL,0.976470588),(530,1016,NULL,0.993333333),(530,1017,NULL,0.998333333),(530,1018,NULL,0.976470588),(530,1019,NULL,0.993333333),(530,1020,NULL,0.998333333),(530,1180,NULL,0.01),(530,1206,-15,NULL),(530,1211,NULL,1.4),(530,1212,1,NULL),(533,6,45,NULL),(533,9,40,NULL),(533,30,8,NULL),(533,50,10,NULL),(533,73,6000,NULL),(533,97,45,NULL),(533,98,5250,NULL),(533,182,3423,NULL),(533,277,1,NULL),(533,422,1,NULL),(533,633,0,NULL),(533,918,0,NULL),(533,1015,NULL,0.882352941),(533,1016,NULL,0.966666667),(533,1017,NULL,0.991666667),(533,1018,NULL,0.882352941),(533,1019,NULL,0.966666667),(533,1020,NULL,0.991666667),(533,1180,NULL,0.01),(533,1206,-15,NULL),(533,1211,NULL,2.6),(533,1212,1,NULL),(561,6,NULL,1.67),(561,9,40,NULL),(561,30,2,NULL),(561,47,1,NULL),(561,50,5,NULL),(561,51,2600,NULL),(561,54,6000,NULL),(561,56,1,NULL),(561,61,0,NULL),(561,63,0,NULL),(561,64,NULL,1.5),(561,124,8627698,NULL),(561,128,1,NULL),(561,158,3000,NULL),(561,160,NULL,0.13),(561,182,3301,NULL),(561,183,3300,NULL),(561,277,1,NULL),(561,278,1,NULL),(561,422,1,NULL),(561,604,85,NULL),(561,620,40,NULL),(561,633,0,NULL),(561,1180,NULL,0.01),(561,1205,-15,NULL),(561,1211,NULL,0.6),(561,1212,1,NULL),(562,6,NULL,0.938),(562,9,40,NULL),(562,30,4,NULL),(562,47,1,NULL),(562,50,9,NULL),(562,51,2000,NULL),(562,54,1000,NULL),(562,56,1,NULL),(562,61,0,NULL),(562,63,0,NULL),(562,64,NULL,1.75),(562,124,8627698,NULL),(562,128,1,NULL),(562,158,1500,NULL),(562,160,NULL,0.365),(562,182,3301,NULL),(562,183,3300,NULL),(562,277,1,NULL),(562,278,1,NULL),(562,422,1,NULL),(562,604,85,NULL),(562,620,40,NULL),(562,633,0,NULL),(562,1180,NULL,0.01),(562,1210,15,NULL),(562,1211,NULL,0.6),(562,1212,1,NULL),(563,6,NULL,1.561),(563,9,40,NULL),(563,30,7,NULL),(563,47,1,NULL),(563,50,13,NULL),(563,51,3000,NULL),(563,54,1250,NULL),(563,56,1,NULL),(563,61,0,NULL),(563,63,0,NULL),(563,64,NULL,2.8125),(563,124,8627698,NULL),(563,128,1,NULL),(563,158,2000,NULL),(563,160,NULL,0.336),(563,182,3301,NULL),(563,183,3300,NULL),(563,277,1,NULL),(563,278,1,NULL),(563,422,1,NULL),(563,604,85,NULL),(563,620,40,NULL),(563,633,0,NULL),(563,1180,NULL,0.01),(563,1210,15,NULL),(563,1211,NULL,0.8),(563,1212,1,NULL),(564,6,NULL,2.023),(564,9,40,NULL),(564,30,9,NULL),(564,47,1,NULL),(564,50,17,NULL),(564,51,3500,NULL),(564,54,1500,NULL),(564,56,1,NULL),(564,61,0,NULL),(564,63,0,NULL),(564,64,NULL,3.5),(564,124,8627698,NULL),(564,128,1,NULL),(564,158,2500,NULL),(564,160,NULL,0.3165),(564,182,3301,NULL),(564,183,3300,NULL),(564,277,1,NULL),(564,278,1,NULL),(564,422,1,NULL),(564,604,85,NULL),(564,620,40,NULL),(564,633,0,NULL),(564,1180,NULL,0.01),(564,1210,15,NULL),(564,1211,NULL,0.8),(564,1212,1,NULL),(565,6,NULL,3.34),(565,9,40,NULL),(565,30,10,NULL),(565,47,1,NULL),(565,50,25,NULL),(565,51,4250,NULL),(565,54,12000,NULL),(565,56,1,NULL),(565,61,0,NULL),(565,63,0,NULL),(565,64,NULL,2.75),(565,124,8627698,NULL),(565,128,1,NULL),(565,158,6000,NULL),(565,160,NULL,0.07),(565,182,3301,NULL),(565,183,3300,NULL),(565,277,1,NULL),(565,278,1,NULL),(565,422,1,NULL),(565,604,85,NULL),(565,620,40,NULL),(565,633,0,NULL),(565,1180,NULL,0.01),(565,1205,-15,NULL),(565,1211,1,NULL),(565,1212,1,NULL),(566,6,NULL,2.8),(566,9,40,NULL),(566,30,100,NULL),(566,47,1,NULL),(566,50,26,NULL),(566,51,3000,NULL),(566,54,2000,NULL),(566,56,1,NULL),(566,61,0,NULL),(566,63,0,NULL),(566,64,NULL,1.75),(566,124,8627698,NULL),(566,128,2,NULL),(566,158,3000,NULL),(566,160,NULL,0.12),(566,182,3304,NULL),(566,183,3300,NULL),(566,277,1,NULL),(566,278,3,NULL),(566,422,1,NULL),(566,604,85,NULL),(566,620,125,NULL),(566,633,0,NULL),(566,1180,NULL,0.01),(566,1210,15,NULL),(566,1211,NULL,0.5),(566,1212,1,NULL),(567,6,5,NULL),(567,9,40,NULL),(567,30,80,NULL),(567,47,1,NULL),(567,50,32,NULL),(567,51,3900,NULL),(567,54,12000,NULL),(567,56,1,NULL),(567,61,0,NULL),(567,63,0,NULL),(567,64,NULL,1.5),(567,124,8627698,NULL),(567,128,2,NULL),(567,158,6000,NULL),(567,160,NULL,0.042),(567,182,3304,NULL),(567,183,3300,NULL),(567,277,1,NULL),(567,278,3,NULL),(567,422,1,NULL),(567,604,85,NULL),(567,620,125,NULL),(567,633,0,NULL),(567,1180,NULL,0.01),(567,1205,-15,NULL),(567,1211,NULL,0.6),(567,1212,1,NULL),(568,6,NULL,6.069),(568,9,40,NULL),(568,30,203,NULL),(568,47,1,NULL),(568,50,31,NULL),(568,51,5250,NULL),(568,54,3000,NULL),(568,56,1,NULL),(568,61,0,NULL),(568,63,0,NULL),(568,64,NULL,3.5),(568,124,8627698,NULL),(568,128,2,NULL),(568,158,5000,NULL),(568,160,NULL,0.1),(568,182,3304,NULL),(568,183,3300,NULL),(568,277,1,NULL),(568,278,3,NULL),(568,422,1,NULL),(568,604,85,NULL),(568,620,125,NULL),(568,633,0,NULL),(568,1180,NULL,0.01),(568,1210,15,NULL),(568,1211,NULL,0.8),(568,1212,1,NULL),(569,6,NULL,4.669),(569,9,40,NULL),(569,30,150,NULL),(569,47,1,NULL),(569,50,30,NULL),(569,51,4500,NULL),(569,54,2500,NULL),(569,56,1,NULL),(569,61,0,NULL),(569,63,0,NULL),(569,64,NULL,2.8125),(569,124,8627698,NULL),(569,128,2,NULL),(569,158,4000,NULL),(569,160,NULL,0.11),(569,182,3304,NULL),(569,183,3300,NULL),(569,277,1,NULL),(569,278,3,NULL),(569,422,1,NULL),(569,604,85,NULL),(569,620,125,NULL),(569,633,0,NULL),(569,1180,NULL,0.01),(569,1210,15,NULL),(569,1211,NULL,0.7),(569,1212,1,NULL),(570,6,10,NULL),(570,9,40,NULL),(570,30,225,NULL),(570,47,1,NULL),(570,50,40,NULL),(570,51,6375,NULL),(570,54,24000,NULL),(570,56,1,NULL),(570,61,0,NULL),(570,63,0,NULL),(570,64,NULL,2.75),(570,124,8627698,NULL),(570,128,2,NULL),(570,158,12000,NULL),(570,160,NULL,0.023),(570,182,3304,NULL),(570,183,3300,NULL),(570,277,1,NULL),(570,278,3,NULL),(570,422,1,NULL),(570,604,85,NULL),(570,620,125,NULL),(570,633,0,NULL),(570,1180,NULL,0.01),(570,1205,-15,NULL),(570,1211,1,NULL),(570,1212,1,NULL),(571,6,NULL,8.4),(571,9,40,NULL),(571,30,1250,NULL),(571,47,1,NULL),(571,50,43,NULL),(571,51,4500,NULL),(571,54,4000,NULL),(571,56,1,NULL),(571,61,0,NULL),(571,63,0,NULL),(571,64,NULL,1.75),(571,124,8627698,NULL),(571,128,3,NULL),(571,158,6000,NULL),(571,160,NULL,0.05),(571,182,3307,NULL),(571,183,3300,NULL),(571,277,1,NULL),(571,278,5,NULL),(571,422,1,NULL),(571,604,85,NULL),(571,620,400,NULL),(571,633,0,NULL),(571,1180,NULL,0.01),(571,1210,15,NULL),(571,1211,NULL,0.5),(571,1212,1,NULL),(572,6,15,NULL),(572,9,40,NULL),(572,30,1250,NULL),(572,47,1,NULL),(572,50,55,NULL),(572,51,5850,NULL),(572,54,24000,NULL),(572,56,1,NULL),(572,61,0,NULL),(572,63,0,NULL),(572,64,NULL,1.5),(572,124,8627698,NULL),(572,128,3,NULL),(572,158,12000,NULL),(572,160,NULL,0.0175),(572,182,3307,NULL),(572,183,3300,NULL),(572,277,1,NULL),(572,278,5,NULL),(572,422,1,NULL),(572,604,85,NULL),(572,620,400,NULL),(572,633,0,NULL),(572,1180,NULL,0.01),(572,1205,-15,NULL),(572,1211,NULL,0.7),(572,1212,1,NULL),(573,6,NULL,18.2),(573,9,40,NULL),(573,30,2250,NULL),(573,47,1,NULL),(573,50,55,NULL),(573,51,7875,NULL),(573,54,6000,NULL),(573,56,1,NULL),(573,61,0,NULL),(573,63,0,NULL),(573,64,NULL,3.5),(573,124,8627698,NULL),(573,128,3,NULL),(573,158,10000,NULL),(573,160,NULL,0.0433),(573,182,3307,NULL),(573,183,3300,NULL),(573,277,1,NULL),(573,278,5,NULL),(573,422,1,NULL),(573,604,85,NULL),(573,620,400,NULL),(573,633,0,NULL),(573,1180,NULL,0.01),(573,1210,15,NULL),(573,1211,NULL,0.9),(573,1212,1,NULL),(574,6,30,NULL),(574,9,40,NULL),(574,30,2500,NULL),(574,47,1,NULL),(574,50,70,NULL),(574,51,9563,NULL),(574,54,48000,NULL),(574,56,1,NULL),(574,61,0,NULL),(574,63,0,NULL),(574,64,NULL,2.75),(574,124,8627698,NULL),(574,128,3,NULL),(574,158,24000,NULL),(574,160,NULL,0.009625),(574,182,3307,NULL),(574,183,3300,NULL),(574,277,1,NULL),(574,278,5,NULL),(574,422,1,NULL),(574,604,85,NULL),(574,620,400,NULL),(574,633,0,NULL),(574,1180,NULL,0.01),(574,1205,-15,NULL),(574,1211,1,NULL),(574,1212,1,NULL),(575,6,14,NULL),(575,9,40,NULL),(575,30,1750,NULL),(575,47,1,NULL),(575,50,47,NULL),(575,51,6750,NULL),(575,54,5000,NULL),(575,56,1,NULL),(575,61,0,NULL),(575,63,0,NULL),(575,64,NULL,2.8125),(575,124,8627698,NULL),(575,128,3,NULL),(575,158,8000,NULL),(575,160,NULL,0.046),(575,182,3307,NULL),(575,183,3300,NULL),(575,277,1,NULL),(575,278,5,NULL),(575,422,1,NULL),(575,604,85,NULL),(575,620,400,NULL),(575,633,0,NULL),(575,1180,NULL,0.01),(575,1210,15,NULL),(575,1211,NULL,0.7),(575,1212,1,NULL),(577,9,40,NULL),(577,30,150,NULL),(577,50,25,NULL),(577,56,1,NULL),(577,73,15000,NULL),(577,182,3417,NULL),(577,277,1,NULL),(577,422,1,NULL),(577,604,87,NULL),(577,633,0,NULL),(577,918,0,NULL),(577,1180,NULL,0.01),(577,1206,-20,NULL),(577,1211,5,NULL),(577,1212,1,NULL),(578,6,40,NULL),(578,9,40,NULL),(578,30,1,NULL),(578,50,40,NULL),(578,73,10000,NULL),(578,182,3420,NULL),(578,277,1,NULL),(578,422,1,NULL),(578,633,0,NULL),(578,967,1,NULL),(578,984,-25,NULL),(578,985,-25,NULL),(578,986,-25,NULL),(578,987,-25,NULL),(578,994,-1,NULL),(578,995,-1,NULL),(578,996,-1,NULL),(578,997,-1,NULL),(578,1180,NULL,0.01),(578,1208,20,NULL),(578,1211,NULL,3.4),(578,1212,1,NULL),(580,6,240,NULL),(580,9,40,NULL),(580,30,1,NULL),(580,50,30,NULL),(580,73,30000,NULL),(580,142,5000,NULL),(580,158,5000,NULL),(580,182,3427,NULL),(580,238,6,NULL),(580,239,6,NULL),(580,240,6,NULL),(580,241,6,NULL),(580,277,1,NULL),(580,422,1,NULL),(580,633,0,NULL),(580,763,1,NULL),(581,6,5,NULL),(581,9,40,NULL),(581,30,1,NULL),(581,50,20,NULL),(581,73,5000,NULL),(581,182,3429,NULL),(581,277,1,NULL),(581,422,1,NULL),(581,633,0,NULL),(582,3,0,NULL),(582,9,188,NULL),(582,11,15,NULL),(582,12,2,NULL),(582,13,2,NULL),(582,14,2,NULL),(582,15,0,NULL),(582,19,1,NULL),(582,21,0,NULL),(582,37,296,NULL),(582,48,150,NULL),(582,49,0,NULL),(582,55,93750,NULL),(582,70,NULL,3.62),(582,76,30000,NULL),(582,79,6000,NULL),(582,101,0,NULL),(582,102,2,NULL),(582,109,1,NULL),(582,110,1,NULL),(582,111,1,NULL),(582,113,1,NULL),(582,124,16777215,NULL),(582,129,3,NULL),(582,136,1,NULL),(582,153,NULL,2.68e-006),(582,182,3330,NULL),(582,192,3,NULL),(582,208,0,NULL),(582,209,0,NULL),(582,210,0,NULL),(582,211,7,NULL),(582,216,NULL,0.4),(582,217,395,NULL),(582,246,395,NULL),(582,263,156,NULL),(582,265,188,NULL),(582,267,NULL,0.5),(582,268,NULL,0.9),(582,269,NULL,0.75),(582,270,NULL,0.55),(582,271,1,NULL),(582,272,NULL,0.5),(582,273,NULL,0.6),(582,274,NULL,0.8),(582,277,2,NULL),(582,283,5,NULL),(582,422,1,NULL),(582,463,5,NULL),(582,479,625000,NULL),(582,482,125,NULL),(582,484,NULL,0.75),(582,511,0,NULL),(582,524,NULL,0.75),(582,525,NULL,0.75),(582,552,44,NULL),(582,564,480,NULL),(582,588,20,NULL),(582,600,2,NULL),(582,633,0,NULL),(582,661,3000,NULL),(582,662,NULL,0.05),(582,819,0,NULL),(582,820,0,NULL),(582,821,3,NULL),(582,822,0,NULL),(582,1132,400,NULL),(582,1137,3,NULL),(582,1154,3,NULL),(582,1178,100,NULL),(582,1179,NULL,0.01),(582,1196,NULL,0.01),(582,1198,NULL,0.01),(582,1199,100,NULL),(582,1200,100,NULL),(582,1224,1,NULL),(582,1259,NULL,0.25),(582,1261,NULL,0.25),(582,1262,NULL,0.25),(582,1271,5,NULL),(582,1281,1,NULL),(582,1547,1,NULL),(582,1555,25,NULL),(583,3,0,NULL),(583,9,195,NULL),(583,11,25,NULL),(583,12,1,NULL),(583,13,2,NULL),(583,14,3,NULL),(583,15,0,NULL),(583,19,1,NULL),(583,21,0,NULL),(583,37,404,NULL),(583,48,100,NULL),(583,49,0,NULL),(583,55,NULL,117187.5),(583,70,NULL,2.62),(583,76,25000,NULL),(583,79,3000,NULL),(583,101,2,NULL),(583,102,1,NULL),(583,109,1,NULL),(583,110,1,NULL),(583,111,1,NULL),(583,113,1,NULL),(583,124,16777215,NULL),(583,129,8,NULL),(583,136,1,NULL),(583,153,NULL,2.68e-006),(583,182,3330,NULL),(583,192,4,NULL),(583,208,0,NULL),(583,209,0,NULL),(583,210,0,NULL),(583,211,8,NULL),(583,217,395,NULL),(583,246,395,NULL),(583,263,274,NULL),(583,265,226,NULL),(583,267,NULL,0.5),(583,268,NULL,0.9),(583,269,NULL,0.75),(583,270,NULL,0.55),(583,271,1,NULL),(583,272,NULL,0.5),(583,273,NULL,0.6),(583,274,NULL,0.8),(583,277,2,NULL),(583,283,0,NULL),(583,422,1,NULL),(583,463,5,NULL),(583,479,625000,NULL),(583,482,NULL,156.25),(583,484,NULL,0.75),(583,511,0,NULL),(583,524,NULL,0.75),(583,525,NULL,0.75),(583,552,37,NULL),(583,564,635,NULL),(583,588,10,NULL),(583,600,2,NULL),(583,633,0,NULL),(583,661,3000,NULL),(583,662,NULL,0.05),(583,819,0,NULL),(583,820,0,NULL),(583,821,3,NULL),(583,822,0,NULL),(583,1132,400,NULL),(583,1137,3,NULL),(583,1154,3,NULL),(583,1178,100,NULL),(583,1179,NULL,0.01),(583,1196,NULL,0.01),(583,1198,NULL,0.01),(583,1199,100,NULL),(583,1200,100,NULL),(583,1224,1,NULL),(583,1259,NULL,0.5),(583,1261,NULL,0.25),(583,1262,0,NULL),(583,1271,0,NULL),(583,1281,1,NULL),(583,1547,1,NULL),(583,1555,25,NULL),(584,3,0,NULL),(584,9,250,NULL),(584,11,25,NULL),(584,12,1,NULL),(584,13,4,NULL),(584,14,3,NULL),(584,15,0,NULL),(584,19,1,NULL),(584,21,0,NULL),(584,37,287,NULL),(584,48,225,NULL),(584,49,0,NULL),(584,55,187500,NULL),(584,70,NULL,3.36),(584,76,60000,NULL),(584,79,2500,NULL),(584,101,2,NULL),(584,102,1,NULL),(584,109,1,NULL),(584,110,1,NULL),(584,111,1,NULL),(584,113,1,NULL),(584,124,16777215,NULL),(584,129,6,NULL),(584,136,1,NULL),(584,153,NULL,2.68e-006),(584,182,3330,NULL),(584,192,5,NULL),(584,208,0,NULL),(584,209,0,NULL),(584,210,0,NULL),(584,211,17,NULL),(584,217,395,NULL),(584,246,395,NULL),(584,263,391,NULL),(584,265,250,NULL),(584,267,NULL,0.5),(584,268,NULL,0.9),(584,269,NULL,0.75),(584,270,NULL,0.55),(584,271,1,NULL),(584,272,NULL,0.5),(584,273,NULL,0.6),(584,274,NULL,0.8),(584,277,2,NULL),(584,283,5,NULL),(584,422,1,NULL),(584,463,15,NULL),(584,479,625000,NULL),(584,482,250,NULL),(584,484,NULL,0.75),(584,511,0,NULL),(584,524,NULL,0.75),(584,525,NULL,0.75),(584,552,50,NULL),(584,564,400,NULL),(584,588,-10,NULL),(584,600,2,NULL),(584,633,0,NULL),(584,661,3000,NULL),(584,662,NULL,0.05),(584,819,0,NULL),(584,820,0,NULL),(584,821,4,NULL),(584,822,0,NULL),(584,1132,400,NULL),(584,1137,3,NULL),(584,1154,3,NULL),(584,1178,100,NULL),(584,1179,NULL,0.01),(584,1196,NULL,0.01),(584,1198,NULL,0.01),(584,1199,100,NULL),(584,1200,100,NULL),(584,1224,1,NULL),(584,1259,NULL,0.5),(584,1261,NULL,0.63),(584,1262,0,NULL),(584,1271,5,NULL),(584,1281,1,NULL),(584,1547,1,NULL),(584,1555,25,NULL),(585,3,0,NULL),(585,9,188,NULL),(585,11,20,NULL),(585,12,1,NULL),(585,13,2,NULL),(585,14,3,NULL),(585,15,0,NULL),(585,19,1,NULL),(585,21,0,NULL),(585,37,419,NULL),(585,48,100,NULL),(585,49,0,NULL),(585,55,NULL,117187.5),(585,70,NULL,2.83),(585,76,17500,NULL),(585,79,1500,NULL),(585,101,1,NULL),(585,102,2,NULL),(585,109,1,NULL),(585,110,1,NULL),(585,111,1,NULL),(585,113,1,NULL),(585,124,16777215,NULL),(585,129,2,NULL),(585,136,1,NULL),(585,153,NULL,2.24e-006),(585,182,3329,NULL),(585,192,4,NULL),(585,208,0,NULL),(585,209,5,NULL),(585,210,0,NULL),(585,211,0,NULL),(585,217,397,NULL),(585,246,397,NULL),(585,263,235,NULL),(585,265,243,NULL),(585,267,NULL,0.4),(585,268,NULL,0.9),(585,269,NULL,0.75),(585,270,NULL,0.65),(585,271,1,NULL),(585,272,NULL,0.5),(585,273,NULL,0.6),(585,274,NULL,0.8),(585,277,2,NULL),(585,283,0,NULL),(585,422,1,NULL),(585,460,5,NULL),(585,479,625000,NULL),(585,482,NULL,156.25),(585,484,NULL,0.75),(585,511,0,NULL),(585,524,NULL,0.75),(585,525,NULL,0.75),(585,552,30,NULL),(585,564,750,NULL),(585,587,NULL,7.5),(585,600,2,NULL),(585,633,0,NULL),(585,661,3000,NULL),(585,662,NULL,0.05),(585,819,0,NULL),(585,820,0,NULL),(585,821,0,NULL),(585,822,5,NULL),(585,1132,400,NULL),(585,1137,3,NULL),(585,1154,3,NULL),(585,1178,100,NULL),(585,1179,NULL,0.01),(585,1196,NULL,0.01),(585,1198,NULL,0.01),(585,1199,100,NULL),(585,1200,100,NULL),(585,1224,1,NULL),(585,1259,NULL,0.5),(585,1261,NULL,0.25),(585,1262,0,NULL),(585,1271,0,NULL),(585,1281,1,NULL),(585,1547,1,NULL),(585,1555,25,NULL),(586,3,0,NULL),(586,9,274,NULL),(586,11,20,NULL),(586,12,2,NULL),(586,13,2,NULL),(586,14,2,NULL),(586,15,0,NULL),(586,19,1,NULL),(586,21,0,NULL),(586,37,334,NULL),(586,48,220,NULL),(586,49,0,NULL),(586,55,NULL,117187.5),(586,70,NULL,3.58),(586,76,32500,NULL),(586,79,4500,NULL),(586,101,0,NULL),(586,102,2,NULL),(586,109,1,NULL),(586,110,1,NULL),(586,111,1,NULL),(586,113,1,NULL),(586,124,16777215,NULL),(586,129,10,NULL),(586,136,1,NULL),(586,153,NULL,2.24e-006),(586,182,3329,NULL),(586,192,3,NULL),(586,208,0,NULL),(586,209,7,NULL),(586,210,0,NULL),(586,211,0,NULL),(586,216,NULL,0.4),(586,217,397,NULL),(586,246,397,NULL),(586,263,195,NULL),(586,265,274,NULL),(586,267,NULL,0.4),(586,268,NULL,0.9),(586,269,NULL,0.75),(586,270,NULL,0.65),(586,271,1,NULL),(586,272,NULL,0.5),(586,273,NULL,0.6),(586,274,NULL,0.8),(586,277,2,NULL),(586,283,10,NULL),(586,422,1,NULL),(586,460,5,NULL),(586,479,625000,NULL),(586,482,NULL,156.25),(586,484,NULL,0.75),(586,511,0,NULL),(586,524,NULL,0.75),(586,525,NULL,0.75),(586,552,41,NULL),(586,564,465,NULL),(586,587,5,NULL),(586,600,2,NULL),(586,633,0,NULL),(586,661,3000,NULL),(586,662,NULL,0.05),(586,819,0,NULL),(586,820,0,NULL),(586,821,0,NULL),(586,822,5,NULL),(586,1132,400,NULL),(586,1137,3,NULL),(586,1154,3,NULL),(586,1178,100,NULL),(586,1179,NULL,0.01),(586,1196,NULL,0.01),(586,1198,NULL,0.01),(586,1199,100,NULL),(586,1200,100,NULL),(586,1224,1,NULL),(586,1259,NULL,0.25),(586,1261,NULL,0.25),(586,1262,NULL,0.25),(586,1271,10,NULL),(586,1281,1,NULL),(586,1547,1,NULL),(586,1555,25,NULL),(587,3,0,NULL),(587,9,336,NULL),(587,11,37,NULL),(587,12,3,NULL),(587,13,3,NULL),(587,14,4,NULL),(587,15,0,NULL),(587,19,1,NULL),(587,21,0,NULL),(587,37,353,NULL),(587,48,125,NULL),(587,49,0,NULL),(587,55,187500,NULL),(587,70,NULL,3.19),(587,76,22500,NULL),(587,79,1500,NULL),(587,101,2,NULL),(587,102,3,NULL),(587,109,1,NULL),(587,110,1,NULL),(587,111,1,NULL),(587,113,1,NULL),(587,124,16777215,NULL),(587,129,2,NULL),(587,136,1,NULL),(587,153,NULL,2.24e-006),(587,182,3329,NULL),(587,192,4,NULL),(587,208,0,NULL),(587,209,8,NULL),(587,210,0,NULL),(587,211,0,NULL),(587,217,397,NULL),(587,246,397,NULL),(587,263,391,NULL),(587,265,351,NULL),(587,267,NULL,0.4),(587,268,NULL,0.9),(587,269,NULL,0.75),(587,270,NULL,0.65),(587,271,1,NULL),(587,272,NULL,0.5),(587,273,NULL,0.6),(587,274,NULL,0.8),(587,277,3,NULL),(587,283,0,NULL),(587,422,1,NULL),(587,460,5,NULL),(587,479,625000,NULL),(587,482,250,NULL),(587,484,NULL,0.75),(587,511,0,NULL),(587,524,NULL,0.75),(587,525,NULL,0.75),(587,552,35,NULL),(587,564,660,NULL),(587,587,NULL,7.5),(587,600,2,NULL),(587,633,0,NULL),(587,661,3000,NULL),(587,662,NULL,0.05),(587,819,0,NULL),(587,820,0,NULL),(587,821,0,NULL),(587,822,6,NULL),(587,974,1,NULL),(587,975,1,NULL),(587,976,1,NULL),(587,977,1,NULL),(587,1132,400,NULL),(587,1137,3,NULL),(587,1154,3,NULL),(587,1178,100,NULL),(587,1179,NULL,0.01),(587,1196,NULL,0.01),(587,1198,NULL,0.01),(587,1199,100,NULL),(587,1200,100,NULL),(587,1224,1,NULL),(587,1259,NULL,0.63),(587,1261,NULL,0.5),(587,1262,NULL,0.5),(587,1271,0,NULL),(587,1281,1,NULL),(587,1547,1,NULL),(587,1555,25,NULL),(588,3,0,NULL),(588,9,133,NULL),(588,11,11,NULL),(588,12,1,NULL),(588,13,1,NULL),(588,14,2,NULL),(588,15,0,NULL),(588,19,1,NULL),(588,21,0,NULL),(588,37,310,NULL),(588,48,80,NULL),(588,49,0,NULL),(588,55,93750,NULL),(588,70,NULL,3.83),(588,76,15000,NULL),(588,79,4500,NULL),(588,101,0,NULL),(588,102,2,NULL),(588,109,1,NULL),(588,110,1,NULL),(588,111,1,NULL),(588,113,1,NULL),(588,124,16777215,NULL),(588,129,1,NULL),(588,136,1,NULL),(588,153,NULL,8.65800865801e-007),(588,182,3329,NULL),(588,192,2,NULL),(588,208,0,NULL),(588,209,4,NULL),(588,210,0,NULL),(588,211,0,NULL),(588,217,397,NULL),(588,246,397,NULL),(588,263,79,NULL),(588,265,173,NULL),(588,267,NULL,0.4),(588,268,NULL,0.9),(588,269,NULL,0.75),(588,270,NULL,0.65),(588,271,1,NULL),(588,272,NULL,0.5),(588,273,NULL,0.6),(588,274,NULL,0.8),(588,277,1,NULL),(588,283,5,NULL),(588,460,5,NULL),(588,479,625000,NULL),(588,482,125,NULL),(588,484,NULL,0.75),(588,524,NULL,0.75),(588,525,NULL,0.75),(588,552,45,NULL),(588,564,475,NULL),(588,600,1,NULL),(588,819,0,NULL),(588,820,0,NULL),(588,821,0,NULL),(588,822,4,NULL),(588,1132,0,NULL),(588,1137,0,NULL),(588,1154,0,NULL),(588,1178,100,NULL),(588,1179,NULL,0.01),(588,1196,NULL,0.01),(588,1198,NULL,0.01),(588,1199,100,NULL),(588,1200,100,NULL),(588,1224,1,NULL),(588,1259,NULL,0.25),(588,1261,0,NULL),(588,1262,0,NULL),(588,1271,5,NULL),(588,1281,1,NULL),(589,3,0,NULL),(589,9,274,NULL),(589,11,25,NULL),(589,12,2,NULL),(589,13,2,NULL),(589,14,2,NULL),(589,15,0,NULL),(589,19,1,NULL),(589,21,0,NULL),(589,37,404,NULL),(589,48,100,NULL),(589,49,0,NULL),(589,55,140625,NULL),(589,70,NULL,2.89),(589,76,20000,NULL),(589,79,2000,NULL),(589,101,0,NULL),(589,102,2,NULL),(589,109,1,NULL),(589,110,1,NULL),(589,111,1,NULL),(589,113,1,NULL),(589,124,16777215,NULL),(589,129,8,NULL),(589,136,1,NULL),(589,153,NULL,1.67e-006),(589,182,3331,NULL),(589,192,4,NULL),(589,208,6,NULL),(589,209,0,NULL),(589,210,0,NULL),(589,211,0,NULL),(589,217,394,NULL),(589,246,394,NULL),(589,263,235,NULL),(589,265,305,NULL),(589,267,NULL,0.5),(589,268,NULL,0.8),(589,269,NULL,0.75),(589,270,NULL,0.65),(589,271,1,NULL),(589,272,NULL,0.5),(589,273,NULL,0.6),(589,274,NULL,0.8),(589,277,2,NULL),(589,283,0,NULL),(589,422,1,NULL),(589,464,5,NULL),(589,479,625000,NULL),(589,482,NULL,187.5),(589,484,NULL,0.75),(589,485,-10,NULL),(589,511,0,NULL),(589,524,NULL,0.75),(589,525,NULL,0.75),(589,552,33,NULL),(589,564,700,NULL),(589,600,2,NULL),(589,633,0,NULL),(589,661,3000,NULL),(589,662,NULL,0.05),(589,819,4,NULL),(589,820,0,NULL),(589,821,0,NULL),(589,822,0,NULL),(589,1132,400,NULL),(589,1137,3,NULL),(589,1154,3,NULL),(589,1178,100,NULL),(589,1179,NULL,0.01),(589,1196,NULL,0.01),(589,1198,NULL,0.01),(589,1199,100,NULL),(589,1200,100,NULL),(589,1224,1,NULL),(589,1259,NULL,0.25),(589,1261,NULL,0.25),(589,1262,NULL,0.25),(589,1271,0,NULL),(589,1281,1,NULL),(589,1547,1,NULL),(589,1555,25,NULL),(590,3,0,NULL),(590,9,368,NULL),(590,11,32,NULL),(590,12,3,NULL),(590,13,2,NULL),(590,14,4,NULL),(590,15,0,NULL),(590,19,1,NULL),(590,21,0,NULL),(590,37,306,NULL),(590,48,125,NULL),(590,49,0,NULL),(590,55,187500,NULL),(590,70,NULL,4.11),(590,76,35000,NULL),(590,79,3000,NULL),(590,101,3,NULL),(590,102,1,NULL),(590,109,1,NULL),(590,110,1,NULL),(590,111,1,NULL),(590,113,1,NULL),(590,124,16777215,NULL),(590,129,14,NULL),(590,136,1,NULL),(590,153,NULL,1.67e-006),(590,182,3331,NULL),(590,192,3,NULL),(590,208,8,NULL),(590,209,0,NULL),(590,210,0,NULL),(590,211,0,NULL),(590,217,394,NULL),(590,246,394,NULL),(590,263,274,NULL),(590,265,423,NULL),(590,267,NULL,0.5),(590,268,NULL,0.8),(590,269,NULL,0.75),(590,270,NULL,0.65),(590,271,1,NULL),(590,272,NULL,0.5),(590,273,NULL,0.6),(590,274,NULL,0.8),(590,277,3,NULL),(590,283,0,NULL),(590,422,1,NULL),(590,464,5,NULL),(590,479,625000,NULL),(590,482,250,NULL),(590,484,NULL,0.75),(590,485,10,NULL),(590,511,0,NULL),(590,524,NULL,0.75),(590,525,NULL,0.75),(590,552,43,NULL),(590,564,525,NULL),(590,600,2,NULL),(590,633,0,NULL),(590,661,3000,NULL),(590,662,NULL,0.05),(590,819,5,NULL),(590,820,0,NULL),(590,821,0,NULL),(590,822,0,NULL),(590,1132,400,NULL),(590,1137,3,NULL),(590,1154,3,NULL),(590,1178,100,NULL),(590,1179,NULL,0.01),(590,1196,NULL,0.01),(590,1198,NULL,0.01),(590,1199,100,NULL),(590,1200,100,NULL),(590,1224,1,NULL),(590,1259,NULL,0.63),(590,1261,NULL,0.25),(590,1262,NULL,0.5),(590,1271,0,NULL),(590,1281,1,NULL),(590,1547,1,NULL),(590,1555,25,NULL),(591,3,0,NULL),(591,9,235,NULL),(591,11,15,NULL),(591,12,3,NULL),(591,13,1,NULL),(591,14,2,NULL),(591,15,0,NULL),(591,19,1,NULL),(591,21,0,NULL),(591,37,301,NULL),(591,48,140,NULL),(591,49,0,NULL),(591,55,93750,NULL),(591,70,NULL,4.46),(591,76,25000,NULL),(591,79,5000,NULL),(591,101,0,NULL),(591,102,2,NULL),(591,109,1,NULL),(591,110,1,NULL),(591,111,1,NULL),(591,113,1,NULL),(591,124,16777215,NULL),(591,129,10,NULL),(591,136,1,NULL),(591,153,NULL,1.67e-006),(591,182,3331,NULL),(591,192,3,NULL),(591,208,5,NULL),(591,209,0,NULL),(591,210,0,NULL),(591,211,0,NULL),(591,216,NULL,0.4),(591,217,394,NULL),(591,246,394,NULL),(591,263,118,NULL),(591,265,243,NULL),(591,267,NULL,0.5),(591,268,NULL,0.8),(591,269,NULL,0.75),(591,270,NULL,0.65),(591,271,1,NULL),(591,272,NULL,0.5),(591,273,NULL,0.6),(591,274,NULL,0.8),(591,277,2,NULL),(591,283,5,NULL),(591,422,1,NULL),(591,464,5,NULL),(591,479,625000,NULL),(591,482,125,NULL),(591,484,NULL,0.75),(591,485,20,NULL),(591,511,0,NULL),(591,524,NULL,0.75),(591,525,NULL,0.75),(591,552,45,NULL),(591,564,510,NULL),(591,600,2,NULL),(591,633,0,NULL),(591,661,3000,NULL),(591,662,NULL,0.05),(591,819,4,NULL),(591,820,0,NULL),(591,821,0,NULL),(591,822,0,NULL),(591,1132,400,NULL),(591,1137,3,NULL),(591,1154,3,NULL),(591,1178,100,NULL),(591,1179,NULL,0.01),(591,1196,NULL,0.01),(591,1198,NULL,0.01),(591,1199,100,NULL),(591,1200,100,NULL),(591,1224,1,NULL),(591,1259,NULL,0.25),(591,1261,0,NULL),(591,1262,NULL,0.5),(591,1271,5,NULL),(591,1281,1,NULL),(591,1547,1,NULL),(591,1555,25,NULL),(592,3,0,NULL),(592,9,219,NULL),(592,11,20,NULL),(592,12,2,NULL),(592,13,2,NULL),(592,14,2,NULL),(592,15,0,NULL),(592,19,1,NULL),(592,21,0,NULL),(592,37,325,NULL),(592,48,150,NULL),(592,49,0,NULL),(592,55,93750,NULL),(592,70,NULL,4.06),(592,76,45000,NULL),(592,79,5500,NULL),(592,101,0,NULL),(592,102,2,NULL),(592,109,1,NULL),(592,110,1,NULL),(592,111,1,NULL),(592,113,1,NULL),(592,124,16777215,NULL),(592,129,6,NULL),(592,136,1,NULL),(592,153,NULL,1.67e-006),(592,182,3328,NULL),(592,192,3,NULL),(592,208,0,NULL),(592,209,0,NULL),(592,210,6,NULL),(592,211,0,NULL),(592,216,NULL,0.4),(592,217,394,NULL),(592,246,394,NULL),(592,263,118,NULL),(592,265,188,NULL),(592,267,NULL,0.5),(592,268,NULL,0.9),(592,269,NULL,0.65),(592,270,NULL,0.65),(592,271,1,NULL),(592,272,NULL,0.5),(592,273,NULL,0.6),(592,274,NULL,0.8),(592,277,2,NULL),(592,283,5,NULL),(592,422,1,NULL),(592,462,20,NULL),(592,479,625000,NULL),(592,482,125,NULL),(592,484,NULL,0.75),(592,511,0,NULL),(592,524,NULL,0.75),(592,525,NULL,0.75),(592,552,46,NULL),(592,564,495,NULL),(592,586,5,NULL),(592,600,2,NULL),(592,633,0,NULL),(592,661,3000,NULL),(592,662,NULL,0.05),(592,819,0,NULL),(592,820,4,NULL),(592,821,0,NULL),(592,822,0,NULL),(592,1132,400,NULL),(592,1137,3,NULL),(592,1154,3,NULL),(592,1178,100,NULL),(592,1179,NULL,0.01),(592,1196,NULL,0.01),(592,1198,NULL,0.01),(592,1199,100,NULL),(592,1200,100,NULL),(592,1224,1,NULL),(592,1259,NULL,0.25),(592,1261,NULL,0.25),(592,1262,NULL,0.25),(592,1271,5,NULL),(592,1281,1,NULL),(592,1547,1,NULL),(592,1555,25,NULL),(593,3,0,NULL),(593,9,383,NULL),(593,11,38,NULL),(593,12,3,NULL),(593,13,3,NULL),(593,14,4,NULL),(593,15,0,NULL),(593,19,1,NULL),(593,21,0,NULL),(593,37,296,NULL),(593,48,125,NULL),(593,49,0,NULL),(593,55,234375,NULL),(593,70,NULL,3.85),(593,76,27500,NULL),(593,79,2500,NULL),(593,101,2,NULL),(593,102,2,NULL),(593,109,1,NULL),(593,110,1,NULL),(593,111,1,NULL),(593,113,1,NULL),(593,124,16777215,NULL),(593,129,3,NULL),(593,136,1,NULL),(593,153,NULL,1.67e-006),(593,182,3328,NULL),(593,192,5,NULL),(593,208,0,NULL),(593,209,0,NULL),(593,210,10,NULL),(593,211,0,NULL),(593,217,394,NULL),(593,246,394,NULL),(593,263,391,NULL),(593,265,430,NULL),(593,267,NULL,0.5),(593,268,NULL,0.9),(593,269,NULL,0.65),(593,270,NULL,0.65),(593,271,1,NULL),(593,272,NULL,0.5),(593,273,NULL,0.6),(593,274,NULL,0.8),(593,277,3,NULL),(593,283,5,NULL),(593,422,1,NULL),(593,462,5,NULL),(593,479,625000,NULL),(593,482,350,NULL),(593,484,NULL,0.75),(593,511,0,NULL),(593,524,NULL,0.75),(593,525,NULL,0.75),(593,552,42,NULL),(593,564,590,NULL),(593,586,7,NULL),(593,600,2,NULL),(593,633,0,NULL),(593,661,3000,NULL),(593,662,NULL,0.05),(593,819,0,NULL),(593,820,5,NULL),(593,821,0,NULL),(593,822,0,NULL),(593,974,1,NULL),(593,975,1,NULL),(593,976,1,NULL),(593,977,1,NULL),(593,1132,400,NULL),(593,1137,3,NULL),(593,1154,3,NULL),(593,1178,100,NULL),(593,1179,NULL,0.01),(593,1196,NULL,0.01),(593,1198,NULL,0.01),(593,1199,100,NULL),(593,1200,100,NULL),(593,1224,1,NULL),(593,1259,NULL,0.63),(593,1261,NULL,0.5),(593,1262,NULL,0.5),(593,1271,5,NULL),(593,1281,1,NULL),(593,1547,1,NULL),(593,1555,25,NULL),(594,3,0,NULL),(594,9,368,NULL),(594,11,34,NULL),(594,12,2,NULL),(594,13,3,NULL),(594,14,3,NULL),(594,15,0,NULL),(594,19,1,NULL),(594,21,0,NULL),(594,37,334,NULL),(594,48,110,NULL),(594,49,0,NULL),(594,55,234375,NULL),(594,70,NULL,3.31),(594,76,37500,NULL),(594,79,3500,NULL),(594,101,0,NULL),(594,102,3,NULL),(594,109,1,NULL),(594,110,1,NULL),(594,111,1,NULL),(594,113,1,NULL),(594,124,16777215,NULL),(594,129,2,NULL),(594,136,1,NULL),(594,153,NULL,1.67e-006),(594,182,3328,NULL),(594,192,3,NULL),(594,208,0,NULL),(594,209,0,NULL),(594,210,9,NULL),(594,211,0,NULL),(594,217,394,NULL),(594,246,394,NULL),(594,263,313,NULL),(594,265,368,NULL),(594,267,NULL,0.5),(594,268,NULL,0.9),(594,269,NULL,0.65),(594,270,NULL,0.65),(594,271,1,NULL),(594,272,NULL,0.5),(594,273,NULL,0.6),(594,274,NULL,0.8),(594,277,3,NULL),(594,283,5,NULL),(594,422,1,NULL),(594,462,5,NULL),(594,479,625000,NULL),(594,482,325,NULL),(594,484,NULL,0.75),(594,511,0,NULL),(594,524,NULL,0.75),(594,525,NULL,0.75),(594,552,44,NULL),(594,564,620,NULL),(594,586,10,NULL),(594,600,2,NULL),(594,633,0,NULL),(594,661,3000,NULL),(594,662,NULL,0.05),(594,819,0,NULL),(594,820,5,NULL),(594,821,0,NULL),(594,822,0,NULL),(594,1132,400,NULL),(594,1137,3,NULL),(594,1154,3,NULL),(594,1178,100,NULL),(594,1179,NULL,0.01),(594,1196,NULL,0.01),(594,1198,NULL,0.01),(594,1199,100,NULL),(594,1200,100,NULL),(594,1224,1,NULL),(594,1259,NULL,0.5),(594,1261,NULL,0.5),(594,1262,NULL,0.25),(594,1271,5,NULL),(594,1281,1,NULL),(594,1547,1,NULL),(594,1555,25,NULL),(595,3,0,NULL),(595,9,75,NULL),(595,11,35,NULL),(595,12,3,NULL),(595,13,2,NULL),(595,14,2,NULL),(595,15,0,NULL),(595,19,1,NULL),(595,21,0,NULL),(595,37,275,NULL),(595,48,100,NULL),(595,49,0,NULL),(595,55,93750,NULL),(595,70,NULL,3.1),(595,76,15000,NULL),(595,79,2500,NULL),(595,101,1,NULL),(595,102,2,NULL),(595,109,1,NULL),(595,110,1,NULL),(595,111,1,NULL),(595,113,1,NULL),(595,124,16777215,NULL),(595,129,3,NULL),(595,136,1,NULL),(595,153,NULL,1.67e-006),(595,182,3328,NULL),(595,192,3,NULL),(595,208,0,NULL),(595,209,3,NULL),(595,210,0,NULL),(595,211,0,NULL),(595,217,394,NULL),(595,246,394,NULL),(595,263,94,NULL),(595,265,325,NULL),(595,267,NULL,0.5),(595,268,NULL,0.9),(595,269,NULL,0.75),(595,270,NULL,0.55),(595,271,1,NULL),(595,272,NULL,0.5),(595,273,NULL,0.6),(595,274,NULL,0.8),(595,277,3,NULL),(595,283,20,NULL),(595,422,1,NULL),(595,479,625000,NULL),(595,482,NULL,187.5),(595,484,NULL,0.75),(595,511,0,NULL),(595,524,NULL,0.75),(595,525,NULL,0.75),(595,552,30,NULL),(595,564,750,NULL),(595,600,2,NULL),(595,633,0,NULL),(595,661,3000,NULL),(595,662,NULL,0.05),(595,1132,400,NULL),(595,1137,3,NULL),(595,1154,3,NULL),(595,1178,100,NULL),(595,1179,NULL,0.01),(595,1196,NULL,0.01),(595,1198,NULL,0.01),(595,1199,100,NULL),(595,1200,100,NULL),(595,1224,1,NULL),(595,1259,NULL,0.25),(595,1261,NULL,0.25),(595,1262,NULL,0.5),(595,1271,20,NULL),(595,1281,1,NULL),(595,1547,1,NULL),(596,3,0,NULL),(596,9,156,NULL),(596,11,11,NULL),(596,12,1,NULL),(596,13,1,NULL),(596,14,2,NULL),(596,15,0,NULL),(596,19,1,NULL),(596,21,0,NULL),(596,37,296,NULL),(596,48,80,NULL),(596,49,0,NULL),(596,55,93750,NULL),(596,70,NULL,4.04),(596,76,20000,NULL),(596,79,5000,NULL),(596,101,0,NULL),(596,102,2,NULL),(596,109,1,NULL),(596,110,1,NULL),(596,111,1,NULL),(596,113,1,NULL),(596,124,16777215,NULL),(596,129,10,NULL),(596,136,1,NULL),(596,153,NULL,8.65800865801e-007),(596,182,3331,NULL),(596,192,2,NULL),(596,208,4,NULL),(596,209,0,NULL),(596,210,0,NULL),(596,211,0,NULL),(596,217,395,NULL),(596,246,395,NULL),(596,263,79,NULL),(596,265,188,NULL),(596,267,NULL,0.5),(596,268,NULL,0.8),(596,269,NULL,0.75),(596,270,NULL,0.65),(596,271,1,NULL),(596,272,NULL,0.5),(596,273,NULL,0.6),(596,274,NULL,0.8),(596,277,1,NULL),(596,283,5,NULL),(596,479,625000,NULL),(596,482,125,NULL),(596,484,NULL,0.75),(596,485,-10,NULL),(596,524,NULL,0.75),(596,525,NULL,0.75),(596,552,45,NULL),(596,564,475,NULL),(596,600,1,NULL),(596,819,4,NULL),(596,820,0,NULL),(596,821,0,NULL),(596,822,0,NULL),(596,1132,0,NULL),(596,1137,0,NULL),(596,1154,0,NULL),(596,1178,100,NULL),(596,1179,NULL,0.01),(596,1196,NULL,0.01),(596,1198,NULL,0.01),(596,1199,100,NULL),(596,1200,100,NULL),(596,1224,1,NULL),(596,1259,NULL,0.25),(596,1261,0,NULL),(596,1262,0,NULL),(596,1271,5,NULL),(596,1281,1,NULL),(597,3,0,NULL),(597,9,391,NULL),(597,11,45,NULL),(597,12,4,NULL),(597,13,2,NULL),(597,14,4,NULL),(597,15,0,NULL),(597,19,1,NULL),(597,21,0,NULL),(597,37,287,NULL),(597,48,115,NULL),(597,49,0,NULL),(597,55,281250,NULL),(597,70,NULL,4.21),(597,76,25000,NULL),(597,79,2000,NULL),(597,101,0,NULL),(597,102,3,NULL),(597,109,1,NULL),(597,110,1,NULL),(597,111,1,NULL),(597,113,1,NULL),(597,124,16777215,NULL),(597,129,12,NULL),(597,136,1,NULL),(597,153,NULL,1.67e-006),(597,182,3331,NULL),(597,192,5,NULL),(597,208,9,NULL),(597,209,0,NULL),(597,210,0,NULL),(597,211,0,NULL),(597,217,394,NULL),(597,246,394,NULL),(597,263,391,NULL),(597,265,469,NULL),(597,267,NULL,0.5),(597,268,NULL,0.8),(597,269,NULL,0.75),(597,270,NULL,0.65),(597,271,1,NULL),(597,272,NULL,0.5),(597,273,NULL,0.6),(597,274,NULL,0.8),(597,277,3,NULL),(597,283,0,NULL),(597,422,1,NULL),(597,464,-5,NULL),(597,479,625000,NULL),(597,482,425,NULL),(597,484,NULL,0.75),(597,485,-10,NULL),(597,511,0,NULL),(597,524,NULL,0.75),(597,525,NULL,0.75),(597,552,38,NULL),(597,564,610,NULL),(597,600,2,NULL),(597,633,0,NULL),(597,661,3000,NULL),(597,662,NULL,0.05),(597,819,5,NULL),(597,820,0,NULL),(597,821,0,NULL),(597,822,0,NULL),(597,1132,400,NULL),(597,1137,3,NULL),(597,1154,3,NULL),(597,1178,100,NULL),(597,1179,NULL,0.01),(597,1196,NULL,0.01),(597,1198,NULL,0.01),(597,1199,100,NULL),(597,1200,100,NULL),(597,1224,1,NULL),(597,1259,NULL,0.63),(597,1261,NULL,0.25),(597,1262,NULL,0.63),(597,1271,0,NULL),(597,1281,1,NULL),(597,1547,1,NULL),(597,1555,25,NULL),(598,3,0,NULL),(598,9,250,NULL),(598,11,31,NULL),(598,12,2,NULL),(598,13,2,NULL),(598,14,4,NULL),(598,15,0,NULL),(598,19,1,NULL),(598,21,0,NULL),(598,37,334,NULL),(598,48,135,NULL),(598,49,0,NULL),(598,55,140625,NULL),(598,70,NULL,3.78),(598,76,32500,NULL),(598,79,2500,NULL),(598,101,3,NULL),(598,102,1,NULL),(598,109,1,NULL),(598,110,1,NULL),(598,111,1,NULL),(598,113,1,NULL),(598,129,8,NULL),(598,136,1,NULL),(598,153,NULL,2.24e-006),(598,182,3329,NULL),(598,192,3,NULL),(598,208,0,NULL),(598,209,8,NULL),(598,210,0,NULL),(598,211,0,NULL),(598,217,397,NULL),(598,246,397,NULL),(598,263,351,NULL),(598,265,313,NULL),(598,267,NULL,0.4),(598,268,NULL,0.9),(598,269,NULL,0.75),(598,270,NULL,0.65),(598,271,1,NULL),(598,272,NULL,0.5),(598,273,NULL,0.6),(598,274,NULL,0.8),(598,277,3,NULL),(598,283,0,NULL),(598,422,1,NULL),(598,460,10,NULL),(598,479,625000,NULL),(598,482,NULL,187.5),(598,484,NULL,0.75),(598,511,0,NULL),(598,524,NULL,0.75),(598,525,NULL,0.75),(598,552,41,NULL),(598,564,575,NULL),(598,587,5,NULL),(598,600,2,NULL),(598,633,0,NULL),(598,661,3000,NULL),(598,662,NULL,0.05),(598,819,0,NULL),(598,820,0,NULL),(598,821,0,NULL),(598,822,6,NULL),(598,1132,400,NULL),(598,1137,3,NULL),(598,1154,3,NULL),(598,1178,100,NULL),(598,1179,NULL,0.01),(598,1196,NULL,0.01),(598,1198,NULL,0.01),(598,1199,100,NULL),(598,1200,100,NULL),(598,1224,1,NULL),(598,1259,NULL,0.63),(598,1261,NULL,0.25),(598,1262,NULL,0.25),(598,1271,0,NULL),(598,1281,1,NULL),(598,1547,1,NULL),(598,1555,25,NULL),(599,3,0,NULL),(599,9,188,NULL),(599,11,15,NULL),(599,12,1,NULL),(599,13,3,NULL),(599,14,2,NULL),(599,15,0,NULL),(599,19,1,NULL),(599,21,0,NULL),(599,37,315,NULL),(599,48,140,NULL),(599,49,0,NULL),(599,55,93750,NULL),(599,70,NULL,3.81),(599,76,22500,NULL),(599,79,4500,NULL),(599,101,0,NULL),(599,102,2,NULL),(599,109,1,NULL),(599,110,1,NULL),(599,111,1,NULL),(599,113,1,NULL),(599,124,16777215,NULL),(599,129,9,NULL),(599,136,1,NULL),(599,153,NULL,2.24e-006),(599,182,3329,NULL),(599,192,3,NULL),(599,208,0,NULL),(599,209,4,NULL),(599,210,0,NULL),(599,211,0,NULL),(599,216,NULL,0.4),(599,217,397,NULL),(599,246,397,NULL),(599,263,118,NULL),(599,265,188,NULL),(599,267,NULL,0.4),(599,268,NULL,0.9),(599,269,NULL,0.75),(599,270,NULL,0.65),(599,271,1,NULL),(599,272,NULL,0.5),(599,273,NULL,0.6),(599,274,NULL,0.8),(599,277,2,NULL),(599,283,0,NULL),(599,422,1,NULL),(599,460,20,NULL),(599,479,625000,NULL),(599,482,125,NULL),(599,484,NULL,0.75),(599,511,0,NULL),(599,524,NULL,0.75),(599,525,NULL,0.75),(599,552,43,NULL),(599,564,565,NULL),(599,587,5,NULL),(599,600,2,NULL),(599,633,0,NULL),(599,661,3000,NULL),(599,662,NULL,0.05),(599,819,0,NULL),(599,820,0,NULL),(599,821,0,NULL),(599,822,4,NULL),(599,1132,400,NULL),(599,1137,3,NULL),(599,1154,3,NULL),(599,1178,100,NULL),(599,1179,NULL,0.01),(599,1196,NULL,0.01),(599,1198,NULL,0.01),(599,1199,100,NULL),(599,1200,100,NULL),(599,1224,1,NULL),(599,1259,NULL,0.25),(599,1261,NULL,0.5),(599,1262,0,NULL),(599,1271,0,NULL),(599,1281,1,NULL),(599,1547,1,NULL),(599,1555,25,NULL),(600,3,0,NULL),(600,9,31,NULL),(600,11,25,NULL),(600,12,2,NULL),(600,13,2,NULL),(600,14,2,NULL),(600,15,0,NULL),(600,19,1,NULL),(600,21,0,NULL),(600,37,300,NULL),(600,48,100,NULL),(600,49,0,NULL),(600,55,62500,NULL),(600,70,NULL,3.1),(600,76,15000,NULL),(600,79,2500,NULL),(600,101,2,NULL),(600,102,2,NULL),(600,109,1,NULL),(600,110,1,NULL),(600,111,1,NULL),(600,113,1,NULL),(600,124,16777215,NULL),(600,129,10,NULL),(600,136,1,NULL),(600,153,NULL,2.24e-006),(600,182,3329,NULL),(600,192,3,NULL),(600,208,0,NULL),(600,209,3,NULL),(600,210,0,NULL),(600,211,0,NULL),(600,217,397,NULL),(600,246,397,NULL),(600,263,63,NULL),(600,265,163,NULL),(600,267,NULL,0.4),(600,268,NULL,0.9),(600,269,NULL,0.75),(600,270,NULL,0.55),(600,271,1,NULL),(600,272,NULL,0.5),(600,273,NULL,0.6),(600,274,NULL,0.8),(600,277,3,NULL),(600,283,10,NULL),(600,422,1,NULL),(600,479,625000,NULL),(600,482,125,NULL),(600,484,NULL,0.75),(600,511,0,NULL),(600,524,NULL,0.75),(600,525,NULL,0.75),(600,552,30,NULL),(600,564,750,NULL),(600,600,2,NULL),(600,633,0,NULL),(600,661,3000,NULL),(600,662,NULL,0.05),(600,1132,400,NULL),(600,1137,3,NULL),(600,1154,3,NULL),(600,1178,100,NULL),(600,1179,NULL,0.01),(600,1196,NULL,0.01),(600,1198,NULL,0.01),(600,1199,100,NULL),(600,1200,100,NULL),(600,1224,1,NULL),(600,1259,NULL,0.25),(600,1261,NULL,0.25),(600,1262,NULL,0.25),(600,1271,10,NULL),(600,1281,1,NULL),(600,1547,1,NULL),(601,3,0,NULL),(601,9,118,NULL),(601,11,11,NULL),(601,12,1,NULL),(601,13,1,NULL),(601,14,2,NULL),(601,15,0,NULL),(601,19,1,NULL),(601,21,0,NULL),(601,37,296,NULL),(601,48,80,NULL),(601,49,0,NULL),(601,55,93750,NULL),(601,70,NULL,3.77),(601,76,30000,NULL),(601,79,6000,NULL),(601,101,0,NULL),(601,102,2,NULL),(601,109,1,NULL),(601,110,1,NULL),(601,111,1,NULL),(601,113,1,NULL),(601,124,16777215,NULL),(601,129,9,NULL),(601,136,1,NULL),(601,153,NULL,8.65800865801e-007),(601,182,3330,NULL),(601,192,2,NULL),(601,208,0,NULL),(601,209,0,NULL),(601,210,0,NULL),(601,211,4,NULL),(601,217,395,NULL),(601,246,395,NULL),(601,263,118,NULL),(601,265,149,NULL),(601,267,NULL,0.5),(601,268,NULL,0.9),(601,269,NULL,0.75),(601,270,NULL,0.55),(601,271,1,NULL),(601,272,NULL,0.5),(601,273,NULL,0.6),(601,274,NULL,0.8),(601,277,1,NULL),(601,283,5,NULL),(601,463,5,NULL),(601,479,625000,NULL),(601,482,125,NULL),(601,484,NULL,0.75),(601,524,NULL,0.75),(601,525,NULL,0.75),(601,552,45,NULL),(601,564,475,NULL),(601,600,1,NULL),(601,819,0,NULL),(601,820,0,NULL),(601,821,3,NULL),(601,822,0,NULL),(601,1132,0,NULL),(601,1137,0,NULL),(601,1154,0,NULL),(601,1178,100,NULL),(601,1179,NULL,0.01),(601,1196,NULL,0.01),(601,1198,NULL,0.01),(601,1199,100,NULL),(601,1200,100,NULL),(601,1224,1,NULL),(601,1259,NULL,0.25),(601,1261,0,NULL),(601,1262,0,NULL),(601,1271,5,NULL),(601,1281,1,NULL),(602,3,0,NULL),(602,9,266,NULL),(602,11,30,NULL),(602,12,2,NULL),(602,13,3,NULL),(602,14,4,NULL),(602,15,0,NULL),(602,19,1,NULL),(602,21,0,NULL),(602,37,296,NULL),(602,48,150,NULL),(602,49,0,NULL),(602,55,187500,NULL),(602,70,NULL,3.87),(602,76,40000,NULL),(602,79,4000,NULL),(602,101,4,NULL),(602,102,0,NULL),(602,109,1,NULL),(602,110,1,NULL),(602,111,1,NULL),(602,113,1,NULL),(602,124,16777215,NULL),(602,129,6,NULL),(602,136,1,NULL),(602,153,NULL,2.68e-006),(602,182,3330,NULL),(602,192,3,NULL),(602,208,0,NULL),(602,209,0,NULL),(602,210,0,NULL),(602,211,10,NULL),(602,217,395,NULL),(602,246,395,NULL),(602,263,391,NULL),(602,265,313,NULL),(602,267,NULL,0.5),(602,268,NULL,0.9),(602,269,NULL,0.75),(602,270,NULL,0.55),(602,271,1,NULL),(602,272,NULL,0.5),(602,273,NULL,0.6),(602,274,NULL,0.8),(602,277,3,NULL),(602,283,0,NULL),(602,422,1,NULL),(602,463,10,NULL),(602,479,625000,NULL),(602,482,250,NULL),(602,484,NULL,0.75),(602,511,0,NULL),(602,524,NULL,0.75),(602,525,NULL,0.75),(602,552,47,NULL),(602,564,465,NULL),(602,588,5,NULL),(602,600,2,NULL),(602,633,0,NULL),(602,661,3000,NULL),(602,662,NULL,0.05),(602,819,0,NULL),(602,820,0,NULL),(602,821,4,NULL),(602,822,0,NULL),(602,1132,400,NULL),(602,1137,3,NULL),(602,1154,3,NULL),(602,1178,100,NULL),(602,1179,NULL,0.01),(602,1196,NULL,0.01),(602,1198,NULL,0.01),(602,1199,100,NULL),(602,1200,100,NULL),(602,1224,1,NULL),(602,1259,NULL,0.63),(602,1261,NULL,0.5),(602,1262,NULL,0.25),(602,1271,0,NULL),(602,1281,1,NULL),(602,1547,1,NULL),(602,1555,25,NULL),(603,3,0,NULL),(603,9,313,NULL),(603,11,35,NULL),(603,12,2,NULL),(603,13,4,NULL),(603,14,4,NULL),(603,15,0,NULL),(603,19,1,NULL),(603,21,0,NULL),(603,37,268,NULL),(603,48,175,NULL),(603,49,0,NULL),(603,55,234375,NULL),(603,70,NULL,3.49),(603,76,30000,NULL),(603,79,3000,NULL),(603,101,2,NULL),(603,102,2,NULL),(603,109,1,NULL),(603,110,1,NULL),(603,111,1,NULL),(603,113,1,NULL),(603,124,16777215,NULL),(603,129,5,NULL),(603,136,1,NULL),(603,153,NULL,2.68e-006),(603,182,3330,NULL),(603,192,4,NULL),(603,208,0,NULL),(603,209,0,NULL),(603,210,0,NULL),(603,211,11,NULL),(603,217,395,NULL),(603,246,395,NULL),(603,263,469,NULL),(603,265,351,NULL),(603,267,NULL,0.5),(603,268,NULL,0.9),(603,269,NULL,0.75),(603,270,NULL,0.55),(603,271,1,NULL),(603,272,NULL,0.5),(603,273,NULL,0.6),(603,274,NULL,0.8),(603,277,3,NULL),(603,283,0,NULL),(603,422,1,NULL),(603,463,-5,NULL),(603,479,625000,NULL),(603,482,350,NULL),(603,484,NULL,0.75),(603,511,0,NULL),(603,524,NULL,0.75),(603,525,NULL,0.75),(603,552,40,NULL),(603,564,550,NULL),(603,588,10,NULL),(603,600,2,NULL),(603,633,0,NULL),(603,661,3000,NULL),(603,662,NULL,0.05),(603,819,0,NULL),(603,820,0,NULL),(603,821,5,NULL),(603,822,0,NULL),(603,1132,400,NULL),(603,1137,3,NULL),(603,1154,3,NULL),(603,1178,100,NULL),(603,1179,NULL,0.01),(603,1196,NULL,0.01),(603,1198,NULL,0.01),(603,1199,100,NULL),(603,1200,100,NULL),(603,1224,1,NULL),(603,1259,NULL,0.63),(603,1261,NULL,0.63),(603,1262,NULL,0.25),(603,1271,0,NULL),(603,1281,1,NULL),(603,1547,1,NULL),(603,1555,25,NULL),(604,3,0,NULL),(604,9,50,NULL),(604,11,25,NULL),(604,12,1,NULL),(604,13,2,NULL),(604,14,3,NULL),(604,15,0,NULL),(604,19,1,NULL),(604,21,0,NULL),(604,37,300,NULL),(604,48,100,NULL),(604,49,0,NULL),(604,55,62500,NULL),(604,70,NULL,3.1),(604,76,15000,NULL),(604,79,2500,NULL),(604,101,2,NULL),(604,102,2,NULL),(604,109,1,NULL),(604,110,1,NULL),(604,111,1,NULL),(604,113,1,NULL),(604,124,16777215,NULL),(604,129,6,NULL),(604,136,1,NULL),(604,153,NULL,2.68e-006),(604,182,3330,NULL),(604,192,3,NULL),(604,208,0,NULL),(604,209,3,NULL),(604,210,0,NULL),(604,211,0,NULL),(604,217,395,NULL),(604,246,395,NULL),(604,263,63,NULL),(604,265,144,NULL),(604,267,NULL,0.5),(604,268,NULL,0.9),(604,269,NULL,0.75),(604,270,NULL,0.65),(604,271,1,NULL),(604,272,NULL,0.5),(604,273,NULL,0.6),(604,274,NULL,0.8),(604,277,3,NULL),(604,283,10,NULL),(604,422,1,NULL),(604,479,625000,NULL),(604,482,125,NULL),(604,484,NULL,0.75),(604,511,0,NULL),(604,524,NULL,0.75),(604,525,NULL,0.75),(604,552,30,NULL),(604,564,750,NULL),(604,600,2,NULL),(604,633,0,NULL),(604,661,3000,NULL),(604,662,NULL,0.05),(604,1132,400,NULL),(604,1137,3,NULL),(604,1154,3,NULL),(604,1178,100,NULL),(604,1179,NULL,0.01),(604,1196,NULL,0.01),(604,1198,NULL,0.01),(604,1199,100,NULL),(604,1200,100,NULL),(604,1224,1,NULL),(604,1259,NULL,0.5),(604,1261,NULL,0.25),(604,1262,0,NULL),(604,1271,10,NULL),(604,1281,1,NULL),(604,1547,1,NULL),(605,3,0,NULL),(605,9,226,NULL),(605,11,20,NULL),(605,12,1,NULL),(605,13,3,NULL),(605,14,2,NULL),(605,15,0,NULL),(605,19,1,NULL),(605,21,0,NULL),(605,37,320,NULL),(605,48,250,NULL),(605,49,0,NULL),(605,55,NULL,117187.5),(605,70,NULL,3.53),(605,76,37500,NULL),(605,79,6000,NULL),(605,101,2,NULL),(605,102,1,NULL),(605,109,1,NULL),(605,110,1,NULL),(605,111,1,NULL),(605,113,1,NULL),(605,124,16777215,NULL),(605,129,2,NULL),(605,136,1,NULL),(605,153,NULL,2.68e-006),(605,182,3330,NULL),(605,192,3,NULL),(605,208,0,NULL),(605,209,0,NULL),(605,210,0,NULL),(605,211,10,NULL),(605,216,NULL,0.4),(605,217,395,NULL),(605,246,395,NULL),(605,263,274,NULL),(605,265,258,NULL),(605,267,NULL,0.5),(605,268,NULL,0.9),(605,269,NULL,0.75),(605,270,NULL,0.55),(605,271,1,NULL),(605,272,NULL,0.5),(605,273,NULL,0.6),(605,274,NULL,0.8),(605,277,2,NULL),(605,283,5,NULL),(605,422,1,NULL),(605,463,5,NULL),(605,479,625000,NULL),(605,482,NULL,156.25),(605,484,NULL,0.75),(605,511,0,NULL),(605,524,NULL,0.75),(605,525,NULL,0.75),(605,552,48,NULL),(605,564,430,NULL),(605,588,5,NULL),(605,600,2,NULL),(605,633,0,NULL),(605,661,3000,NULL),(605,662,NULL,0.05),(605,819,0,NULL),(605,820,0,NULL),(605,821,4,NULL),(605,822,0,NULL),(605,1132,400,NULL),(605,1137,3,NULL),(605,1154,3,NULL),(605,1178,100,NULL),(605,1179,NULL,0.01),(605,1196,NULL,0.01),(605,1198,NULL,0.01),(605,1199,100,NULL),(605,1200,100,NULL),(605,1224,1,NULL),(605,1259,NULL,0.25),(605,1261,NULL,0.5),(605,1262,0,NULL),(605,1271,5,NULL),(605,1281,1,NULL),(605,1547,1,NULL),(605,1555,25,NULL),(606,3,0,NULL),(606,9,149,NULL),(606,11,11,NULL),(606,12,1,NULL),(606,13,1,NULL),(606,14,2,NULL),(606,15,0,NULL),(606,19,1,NULL),(606,21,0,NULL),(606,37,296,NULL),(606,48,80,NULL),(606,49,0,NULL),(606,55,93750,NULL),(606,70,NULL,4.04),(606,76,25000,NULL),(606,79,5500,NULL),(606,101,0,NULL),(606,102,2,NULL),(606,109,1,NULL),(606,110,1,NULL),(606,111,1,NULL),(606,113,1,NULL),(606,124,16777215,NULL),(606,129,2,NULL),(606,136,1,NULL),(606,153,NULL,8.65800865801e-007),(606,182,3328,NULL),(606,192,2,NULL),(606,208,0,NULL),(606,209,0,NULL),(606,210,4,NULL),(606,211,0,NULL),(606,217,395,NULL),(606,246,395,NULL),(606,263,79,NULL),(606,265,188,NULL),(606,267,NULL,0.5),(606,268,NULL,0.9),(606,269,NULL,0.65),(606,270,NULL,0.65),(606,271,1,NULL),(606,272,NULL,0.5),(606,273,NULL,0.6),(606,274,NULL,0.8),(606,277,1,NULL),(606,283,10,NULL),(606,462,5,NULL),(606,479,625000,NULL),(606,482,125,NULL),(606,484,NULL,0.75),(606,524,NULL,0.75),(606,525,NULL,0.75),(606,552,45,NULL),(606,564,475,NULL),(606,600,1,NULL),(606,819,0,NULL),(606,820,4,NULL),(606,821,0,NULL),(606,822,0,NULL),(606,1132,0,NULL),(606,1137,0,NULL),(606,1154,0,NULL),(606,1178,100,NULL),(606,1179,NULL,0.01),(606,1196,NULL,0.01),(606,1198,NULL,0.01),(606,1199,100,NULL),(606,1200,100,NULL),(606,1224,1,NULL),(606,1259,NULL,0.25),(606,1261,0,NULL),(606,1262,0,NULL),(606,1271,10,NULL),(606,1281,1,NULL),(607,3,0,NULL),(607,9,289,NULL),(607,11,20,NULL),(607,12,2,NULL),(607,13,2,NULL),(607,14,2,NULL),(607,15,0,NULL),(607,19,1,NULL),(607,21,0,NULL),(607,37,278,NULL),(607,48,230,NULL),(607,49,0,NULL),(607,55,NULL,117187.5),(607,70,NULL,4.19),(607,76,35000,NULL),(607,79,5500,NULL),(607,101,0,NULL),(607,102,2,NULL),(607,109,1,NULL),(607,110,1,NULL),(607,111,1,NULL),(607,113,1,NULL),(607,124,16777215,NULL),(607,129,10,NULL),(607,136,1,NULL),(607,153,NULL,1.67e-006),(607,182,3328,NULL),(607,192,3,NULL),(607,208,0,NULL),(607,209,0,NULL),(607,210,9,NULL),(607,211,0,NULL),(607,216,NULL,0.4),(607,217,394,NULL),(607,246,394,NULL),(607,263,195,NULL),(607,265,344,NULL),(607,267,NULL,0.5),(607,268,NULL,0.9),(607,269,NULL,0.65),(607,270,NULL,0.65),(607,271,1,NULL),(607,272,NULL,0.5),(607,273,NULL,0.6),(607,274,NULL,0.8),(607,277,2,NULL),(607,283,15,NULL),(607,422,1,NULL),(607,462,5,NULL),(607,479,625000,NULL),(607,482,NULL,156.25),(607,484,NULL,0.75),(607,511,0,NULL),(607,524,NULL,0.75),(607,525,NULL,0.75),(607,552,45,NULL),(607,564,450,NULL),(607,586,5,NULL),(607,600,2,NULL),(607,633,0,NULL),(607,661,3000,NULL),(607,662,NULL,0.05),(607,819,0,NULL),(607,820,4,NULL),(607,821,0,NULL),(607,822,0,NULL),(607,1132,400,NULL),(607,1137,3,NULL),(607,1154,3,NULL),(607,1178,100,NULL),(607,1179,NULL,0.01),(607,1196,NULL,0.01),(607,1198,NULL,0.01),(607,1199,100,NULL),(607,1200,100,NULL),(607,1224,1,NULL),(607,1259,NULL,0.25),(607,1261,NULL,0.25),(607,1262,NULL,0.25),(607,1271,15,NULL),(607,1281,1,NULL),(607,1547,1,NULL),(607,1555,25,NULL),(608,3,0,NULL),(608,9,250,NULL),(608,11,20,NULL),(608,12,2,NULL),(608,13,2,NULL),(608,14,2,NULL),(608,15,0,NULL),(608,19,1,NULL),(608,21,0,NULL),(608,37,409,NULL),(608,48,100,NULL),(608,49,0,NULL),(608,55,NULL,117187.5),(608,70,NULL,2.92),(608,76,22500,NULL),(608,79,2500,NULL),(608,101,0,NULL),(608,102,2,NULL),(608,109,1,NULL),(608,110,1,NULL),(608,111,1,NULL),(608,113,1,NULL),(608,124,16777215,NULL),(608,129,3,NULL),(608,136,1,NULL),(608,153,NULL,1.67e-006),(608,182,3328,NULL),(608,192,4,NULL),(608,208,0,NULL),(608,209,0,NULL),(608,210,7,NULL),(608,211,0,NULL),(608,217,394,NULL),(608,246,394,NULL),(608,263,235,NULL),(608,265,274,NULL),(608,267,NULL,0.5),(608,268,NULL,0.9),(608,269,NULL,0.65),(608,270,NULL,0.65),(608,271,1,NULL),(608,272,NULL,0.5),(608,273,NULL,0.6),(608,274,NULL,0.8),(608,277,2,NULL),(608,283,5,NULL),(608,422,1,NULL),(608,462,5,NULL),(608,479,625000,NULL),(608,482,NULL,156.25),(608,484,NULL,0.75),(608,511,0,NULL),(608,524,NULL,0.75),(608,525,NULL,0.75),(608,552,36,NULL),(608,564,675,NULL),(608,586,10,NULL),(608,600,2,NULL),(608,633,0,NULL),(608,661,3000,NULL),(608,662,NULL,0.05),(608,819,0,NULL),(608,820,4,NULL),(608,821,0,NULL),(608,822,0,NULL),(608,1132,400,NULL),(608,1137,3,NULL),(608,1154,3,NULL),(608,1178,100,NULL),(608,1179,NULL,0.01),(608,1196,NULL,0.01),(608,1198,NULL,0.01),(608,1199,100,NULL),(608,1200,100,NULL),(608,1224,1,NULL),(608,1259,NULL,0.25),(608,1261,NULL,0.25),(608,1262,NULL,0.25),(608,1271,5,NULL),(608,1281,1,NULL),(608,1547,1,NULL),(608,1555,25,NULL),(609,3,0,NULL),(609,9,329,NULL),(609,11,25,NULL),(609,12,2,NULL),(609,13,3,NULL),(609,14,3,NULL),(609,15,0,NULL),(609,19,1,NULL),(609,21,0,NULL),(609,37,296,NULL),(609,48,220,NULL),(609,49,0,NULL),(609,55,187500,NULL),(609,70,NULL,4.08),(609,76,50000,NULL),(609,79,3000,NULL),(609,101,0,NULL),(609,102,2,NULL),(609,109,1,NULL),(609,110,1,NULL),(609,111,1,NULL),(609,113,1,NULL),(609,124,16777215,NULL),(609,129,12,NULL),(609,136,1,NULL),(609,153,NULL,1.67e-006),(609,182,3328,NULL),(609,192,6,NULL),(609,208,0,NULL),(609,209,0,NULL),(609,210,16,NULL),(609,211,0,NULL),(609,217,394,NULL),(609,246,394,NULL),(609,263,313,NULL),(609,265,351,NULL),(609,267,NULL,0.5),(609,268,NULL,0.9),(609,269,NULL,0.65),(609,270,NULL,0.65),(609,271,1,NULL),(609,272,NULL,0.5),(609,273,NULL,0.6),(609,274,NULL,0.8),(609,277,2,NULL),(609,283,10,NULL),(609,422,1,NULL),(609,462,5,NULL),(609,479,625000,NULL),(609,482,250,NULL),(609,484,NULL,0.75),(609,511,0,NULL),(609,524,NULL,0.75),(609,525,NULL,0.75),(609,552,48,NULL),(609,564,420,NULL),(609,586,5,NULL),(609,600,2,NULL),(609,633,0,NULL),(609,661,3000,NULL),(609,662,NULL,0.05),(609,819,0,NULL),(609,820,5,NULL),(609,821,0,NULL),(609,822,0,NULL),(609,1132,400,NULL),(609,1137,3,NULL),(609,1154,3,NULL),(609,1178,100,NULL),(609,1179,NULL,0.01),(609,1196,NULL,0.01),(609,1198,NULL,0.01),(609,1199,100,NULL),(609,1200,100,NULL),(609,1224,1,NULL),(609,1259,NULL,0.5),(609,1261,NULL,0.5),(609,1262,NULL,0.25),(609,1271,10,NULL),(609,1281,1,NULL),(609,1547,1,NULL),(609,1555,25,NULL),(610,3,0,NULL),(610,9,250,NULL),(610,11,55,NULL),(610,12,2,NULL),(610,13,5,NULL),(610,14,4,NULL),(610,15,0,NULL),(610,19,1,NULL),(610,21,0,NULL),(610,37,325,NULL),(610,48,250,NULL),(610,49,0,NULL),(610,55,281250,NULL),(610,70,NULL,3.1),(610,76,35000,NULL),(610,79,1000,NULL),(610,101,1,NULL),(610,102,2,NULL),(610,109,1,NULL),(610,110,1,NULL),(610,111,1,NULL),(610,124,16777215,NULL),(610,129,4,NULL),(610,136,1,NULL),(610,153,NULL,1.67e-006),(610,182,3755,NULL),(610,192,4,NULL),(610,208,10,NULL),(610,209,10,NULL),(610,210,10,NULL),(610,211,10,NULL),(610,217,396,NULL),(610,246,396,NULL),(610,263,563,NULL),(610,265,344,NULL),(610,267,NULL,0.4),(610,268,NULL,0.8),(610,269,NULL,0.65),(610,270,NULL,0.55),(610,271,1,NULL),(610,272,NULL,0.5),(610,273,NULL,0.6),(610,274,NULL,0.8),(610,277,3,NULL),(610,283,15,NULL),(610,422,1,NULL),(610,479,625000,NULL),(610,482,500,NULL),(610,484,NULL,0.75),(610,511,0,NULL),(610,524,NULL,0.75),(610,525,NULL,0.75),(610,552,30,NULL),(610,564,750,NULL),(610,600,2,NULL),(610,633,0,NULL),(610,661,3000,NULL),(610,662,NULL,0.05),(610,1132,400,NULL),(610,1137,3,NULL),(610,1154,3,NULL),(610,1178,100,NULL),(610,1179,NULL,0.01),(610,1196,NULL,0.01),(610,1198,NULL,0.01),(610,1199,100,NULL),(610,1200,100,NULL),(610,1224,1,NULL),(610,1259,NULL,0.63),(610,1261,NULL,0.71),(610,1262,NULL,0.25),(610,1271,15,NULL),(610,1281,1,NULL),(610,1547,1,NULL),(611,3,0,NULL),(611,9,25,NULL),(611,11,25,NULL),(611,12,2,NULL),(611,13,2,NULL),(611,14,4,NULL),(611,15,0,NULL),(611,19,1,NULL),(611,21,0,NULL),(611,37,300,NULL),(611,48,150,NULL),(611,49,0,NULL),(611,55,125000,NULL),(611,70,NULL,3.1),(611,76,15000,NULL),(611,79,2500,NULL),(611,101,1,NULL),(611,102,2,NULL),(611,109,1,NULL),(611,110,1,NULL),(611,111,1,NULL),(611,113,1,NULL),(611,124,16777215,NULL),(611,129,4,NULL),(611,136,1,NULL),(611,153,NULL,2.24e-006),(611,182,3755,NULL),(611,192,3,NULL),(611,208,12,NULL),(611,209,12,NULL),(611,210,12,NULL),(611,211,12,NULL),(611,217,396,NULL),(611,246,396,NULL),(611,263,63,NULL),(611,265,313,NULL),(611,267,NULL,0.5),(611,268,NULL,0.9),(611,269,NULL,0.75),(611,270,NULL,0.65),(611,271,1,NULL),(611,272,NULL,0.5),(611,273,NULL,0.6),(611,274,NULL,0.8),(611,277,2,NULL),(611,283,20,NULL),(611,422,1,NULL),(611,479,625000,NULL),(611,482,125,NULL),(611,484,NULL,0.75),(611,511,0,NULL),(611,524,NULL,0.75),(611,525,NULL,0.75),(611,552,30,NULL),(611,564,750,NULL),(611,600,2,NULL),(611,633,0,NULL),(611,661,3000,NULL),(611,662,NULL,0.05),(611,1132,400,NULL),(611,1137,3,NULL),(611,1154,3,NULL),(611,1178,100,NULL),(611,1179,NULL,0.01),(611,1196,NULL,0.01),(611,1198,NULL,0.01),(611,1199,100,NULL),(611,1200,100,NULL),(611,1224,1,NULL),(611,1259,NULL,0.63),(611,1261,NULL,0.25),(611,1262,NULL,0.25),(611,1271,20,NULL),(611,1281,1,NULL),(611,1547,1,NULL),(612,3,0,NULL),(612,9,269,NULL),(612,11,35,NULL),(612,12,2,NULL),(612,13,2,NULL),(612,14,4,NULL),(612,15,0,NULL),(612,19,1,NULL),(612,21,0,NULL),(612,37,300,NULL),(612,48,125,NULL),(612,49,0,NULL),(612,55,187500,NULL),(612,70,NULL,3.1),(612,76,20000,NULL),(612,79,1500,NULL),(612,101,2,NULL),(612,102,2,NULL),(612,109,1,NULL),(612,110,1,NULL),(612,111,1,NULL),(612,113,1,NULL),(612,124,16777215,NULL),(612,129,2,NULL),(612,136,1,NULL),(612,153,NULL,2.24e-006),(612,182,3329,NULL),(612,192,4,NULL),(612,208,0,NULL),(612,209,7,NULL),(612,210,0,NULL),(612,211,0,NULL),(612,217,397,NULL),(612,246,397,NULL),(612,263,313,NULL),(612,265,281,NULL),(612,267,NULL,0.4),(612,268,NULL,0.9),(612,269,NULL,0.75),(612,270,NULL,0.65),(612,271,1,NULL),(612,272,NULL,0.5),(612,273,NULL,0.6),(612,274,NULL,0.8),(612,277,3,NULL),(612,283,0,NULL),(612,422,1,NULL),(612,460,5,NULL),(612,479,625000,NULL),(612,482,250,NULL),(612,484,NULL,0.75),(612,511,0,NULL),(612,524,NULL,0.75),(612,525,NULL,0.75),(612,552,30,NULL),(612,564,750,NULL),(612,600,2,NULL),(612,633,0,NULL),(612,661,3000,NULL),(612,662,NULL,0.05),(612,1132,400,NULL),(612,1137,3,NULL),(612,1154,3,NULL),(612,1178,100,NULL),(612,1179,NULL,0.01),(612,1196,NULL,0.01),(612,1198,NULL,0.01),(612,1199,100,NULL),(612,1200,100,NULL),(612,1224,1,NULL),(612,1259,NULL,0.63),(612,1261,NULL,0.25),(612,1262,NULL,0.25),(612,1271,0,NULL),(612,1281,1,NULL),(612,1547,1,NULL),(613,3,0,NULL),(613,9,31,NULL),(613,11,25,NULL),(613,12,3,NULL),(613,13,2,NULL),(613,14,3,NULL),(613,15,0,NULL),(613,19,1,NULL),(613,21,0,NULL),(613,37,250,NULL),(613,48,100,NULL),(613,49,0,NULL),(613,55,125000,NULL),(613,70,NULL,3.1),(613,76,15000,NULL),(613,79,2500,NULL),(613,101,1,NULL),(613,102,2,NULL),(613,109,1,NULL),(613,110,1,NULL),(613,111,1,NULL),(613,113,1,NULL),(613,124,16777215,NULL),(613,129,3,NULL),(613,136,1,NULL),(613,153,NULL,2.24e-006),(613,182,3755,NULL),(613,192,3,NULL),(613,208,0,NULL),(613,209,3,NULL),(613,210,0,NULL),(613,211,0,NULL),(613,217,394,NULL),(613,246,394,NULL),(613,263,63,NULL),(613,265,144,NULL),(613,267,NULL,0.5),(613,268,NULL,0.9),(613,269,NULL,0.75),(613,270,NULL,0.65),(613,271,1,NULL),(613,272,NULL,0.5),(613,273,NULL,0.6),(613,274,NULL,0.8),(613,277,4,NULL),(613,283,10,NULL),(613,422,1,NULL),(613,479,625000,NULL),(613,482,125,NULL),(613,484,NULL,0.75),(613,511,0,NULL),(613,524,NULL,0.75),(613,525,NULL,0.75),(613,552,30,NULL),(613,564,750,NULL),(613,600,2,NULL),(613,633,0,NULL),(613,661,3000,NULL),(613,662,NULL,0.05),(613,1132,400,NULL),(613,1137,3,NULL),(613,1154,3,NULL),(613,1178,100,NULL),(613,1179,NULL,0.01),(613,1196,NULL,0.01),(613,1198,NULL,0.01),(613,1199,100,NULL),(613,1200,100,NULL),(613,1224,1,NULL),(613,1259,NULL,0.5),(613,1261,NULL,0.25),(613,1262,NULL,0.5),(613,1271,10,NULL),(613,1281,1,NULL),(613,1547,1,NULL),(614,3,0,NULL),(614,9,44,NULL),(614,11,25,NULL),(614,12,1,NULL),(614,13,3,NULL),(614,14,3,NULL),(614,15,0,NULL),(614,19,1,NULL),(614,21,0,NULL),(614,37,250,NULL),(614,48,100,NULL),(614,49,0,NULL),(614,55,125000,NULL),(614,70,NULL,3.1),(614,76,15000,NULL),(614,79,2500,NULL),(614,101,3,NULL),(614,102,1,NULL),(614,109,1,NULL),(614,110,1,NULL),(614,111,1,NULL),(614,113,1,NULL),(614,124,16777215,NULL),(614,129,9,NULL),(614,136,1,NULL),(614,153,NULL,2.24e-006),(614,182,3755,NULL),(614,192,3,NULL),(614,208,0,NULL),(614,209,3,NULL),(614,210,0,NULL),(614,211,0,NULL),(614,217,397,NULL),(614,246,397,NULL),(614,263,63,NULL),(614,265,169,NULL),(614,267,NULL,0.5),(614,268,NULL,0.8),(614,269,NULL,0.75),(614,270,NULL,0.65),(614,271,1,NULL),(614,272,NULL,0.5),(614,273,NULL,0.6),(614,274,NULL,0.8),(614,277,1,NULL),(614,283,10,NULL),(614,422,1,NULL),(614,479,625000,NULL),(614,482,125,NULL),(614,484,NULL,0.75),(614,511,0,NULL),(614,524,NULL,0.75),(614,525,NULL,0.75),(614,552,30,NULL),(614,564,750,NULL),(614,600,2,NULL),(614,633,0,NULL),(614,661,3000,NULL),(614,662,NULL,0.05),(614,1132,400,NULL),(614,1137,3,NULL),(614,1154,3,NULL),(614,1178,100,NULL),(614,1179,NULL,0.01),(614,1196,NULL,0.01),(614,1198,NULL,0.01),(614,1199,100,NULL),(614,1200,100,NULL),(614,1224,1,NULL),(614,1259,NULL,0.5),(614,1261,NULL,0.5),(614,1262,0,NULL),(614,1271,10,NULL),(614,1281,1,NULL),(614,1547,1,NULL),(615,3,0,NULL),(615,9,25,NULL),(615,11,25,NULL),(615,12,3,NULL),(615,13,3,NULL),(615,14,4,NULL),(615,15,0,NULL),(615,19,1,NULL),(615,21,0,NULL),(615,37,300,NULL),(615,48,100,NULL),(615,49,0,NULL),(615,55,125000,NULL),(615,70,NULL,3.1),(615,76,15000,NULL),(615,79,2500,NULL),(615,101,1,NULL),(615,102,1,NULL),(615,109,1,NULL),(615,110,1,NULL),(615,111,1,NULL),(615,113,1,NULL),(615,124,16777215,NULL),(615,129,4,NULL),(615,136,1,NULL),(615,153,NULL,2.24e-006),(615,182,3755,NULL),(615,192,3,NULL),(615,208,0,NULL),(615,209,3,NULL),(615,210,0,NULL),(615,211,0,NULL),(615,217,395,NULL),(615,246,395,NULL),(615,263,63,NULL),(615,265,156,NULL),(615,267,NULL,0.5),(615,268,NULL,0.9),(615,269,NULL,0.75),(615,270,NULL,0.65),(615,271,1,NULL),(615,272,NULL,0.5),(615,273,NULL,0.6),(615,274,NULL,0.8),(615,277,1,NULL),(615,283,5,NULL),(615,422,1,NULL),(615,479,625000,NULL),(615,482,125,NULL),(615,484,NULL,0.75),(615,511,0,NULL),(615,524,NULL,0.75),(615,525,NULL,0.75),(615,552,30,NULL),(615,564,750,NULL),(615,600,2,NULL),(615,633,0,NULL),(615,661,3000,NULL),(615,662,NULL,0.05),(615,1132,400,NULL),(615,1137,3,NULL),(615,1154,3,NULL),(615,1178,100,NULL),(615,1179,NULL,0.01),(615,1196,NULL,0.01),(615,1198,NULL,0.01),(615,1199,100,NULL),(615,1200,100,NULL),(615,1224,1,NULL),(615,1259,NULL,0.63),(615,1261,NULL,0.5),(615,1262,NULL,0.5),(615,1271,5,NULL),(615,1281,1,NULL),(615,1547,1,NULL),(616,3,0,NULL),(616,9,45,NULL),(616,11,25,NULL),(616,12,1,NULL),(616,13,3,NULL),(616,14,2,NULL),(616,15,0,NULL),(616,19,1,NULL),(616,21,0,NULL),(616,37,40,NULL),(616,48,100,NULL),(616,49,0,NULL),(616,55,125000,NULL),(616,70,NULL,3.1),(616,76,15000,NULL),(616,79,2500,NULL),(616,101,2,NULL),(616,102,1,NULL),(616,109,1,NULL),(616,110,1,NULL),(616,111,1,NULL),(616,113,1,NULL),(616,124,16777215,NULL),(616,129,3,NULL),(616,136,1,NULL),(616,153,NULL,2.24e-006),(616,182,3755,NULL),(616,192,3,NULL),(616,208,0,NULL),(616,209,3,NULL),(616,210,0,NULL),(616,211,0,NULL),(616,217,397,NULL),(616,246,397,NULL),(616,263,63,NULL),(616,265,144,NULL),(616,267,NULL,0.5),(616,268,NULL,0.9),(616,269,NULL,0.75),(616,270,NULL,0.65),(616,271,1,NULL),(616,272,NULL,0.5),(616,273,NULL,0.6),(616,274,NULL,0.8),(616,277,1,NULL),(616,283,10,NULL),(616,422,1,NULL),(616,479,625000,NULL),(616,482,125,NULL),(616,484,NULL,0.75),(616,511,0,NULL),(616,524,NULL,0.75),(616,525,NULL,0.75),(616,552,30,NULL),(616,564,750,NULL),(616,600,2,NULL),(616,633,0,NULL),(616,661,3000,NULL),(616,662,NULL,0.05),(616,1132,400,NULL),(616,1137,3,NULL),(616,1154,3,NULL),(616,1178,100,NULL),(616,1179,NULL,0.01),(616,1196,NULL,0.01),(616,1198,NULL,0.01),(616,1199,100,NULL),(616,1200,100,NULL),(616,1224,1,NULL),(616,1259,NULL,0.25),(616,1261,NULL,0.5),(616,1262,0,NULL),(616,1271,10,NULL),(616,1281,1,NULL),(616,1547,1,NULL),(617,3,0,NULL),(617,9,36,NULL),(617,11,25,NULL),(617,12,3,NULL),(617,13,1,NULL),(617,14,4,NULL),(617,15,0,NULL),(617,19,1,NULL),(617,21,0,NULL),(617,37,275,NULL),(617,48,100,NULL),(617,49,0,NULL),(617,55,125000,NULL),(617,70,NULL,3.1),(617,76,15000,NULL),(617,79,2500,NULL),(617,101,2,NULL),(617,102,2,NULL),(617,109,1,NULL),(617,110,1,NULL),(617,111,1,NULL),(617,113,1,NULL),(617,124,16777215,NULL),(617,129,3,NULL),(617,136,1,NULL),(617,153,NULL,2.24e-006),(617,182,3755,NULL),(617,192,3,NULL),(617,208,0,NULL),(617,209,3,NULL),(617,210,0,NULL),(617,211,0,NULL),(617,217,395,NULL),(617,246,395,NULL),(617,263,63,NULL),(617,265,625,NULL),(617,267,NULL,0.5),(617,268,NULL,0.9),(617,269,NULL,0.75),(617,270,NULL,0.65),(617,271,1,NULL),(617,272,NULL,0.5),(617,273,NULL,0.6),(617,274,NULL,0.8),(617,277,5,NULL),(617,283,0,NULL),(617,422,1,NULL),(617,479,625000,NULL),(617,482,125,NULL),(617,484,NULL,0.75),(617,511,0,NULL),(617,524,NULL,0.75),(617,525,NULL,0.75),(617,552,30,NULL),(617,564,750,NULL),(617,600,2,NULL),(617,633,0,NULL),(617,661,3000,NULL),(617,662,NULL,0.05),(617,1132,400,NULL),(617,1137,3,NULL),(617,1154,3,NULL),(617,1178,100,NULL),(617,1179,NULL,0.01),(617,1196,NULL,0.01),(617,1198,NULL,0.01),(617,1199,100,NULL),(617,1200,100,NULL),(617,1224,1,NULL),(617,1259,NULL,0.63),(617,1261,0,NULL),(617,1262,NULL,0.5),(617,1271,0,NULL),(617,1281,1,NULL),(617,1547,1,NULL),(618,3,0,NULL),(618,9,44,NULL),(618,11,25,NULL),(618,12,3,NULL),(618,13,1,NULL),(618,14,2,NULL),(618,15,0,NULL),(618,19,1,NULL),(618,21,0,NULL),(618,37,275,NULL),(618,48,100,NULL),(618,49,0,NULL),(618,55,125000,NULL),(618,70,NULL,3.1),(618,76,15000,NULL),(618,79,2500,NULL),(618,101,0,NULL),(618,102,2,NULL),(618,109,1,NULL),(618,110,1,NULL),(618,111,1,NULL),(618,113,1,NULL),(618,124,16777215,NULL),(618,129,8,NULL),(618,136,1,NULL),(618,153,NULL,2.24e-006),(618,182,3755,NULL),(618,192,3,NULL),(618,208,0,NULL),(618,209,3,NULL),(618,210,0,NULL),(618,211,0,NULL),(618,217,397,NULL),(618,246,397,NULL),(618,263,63,NULL),(618,265,144,NULL),(618,267,NULL,0.5),(618,268,NULL,0.9),(618,269,NULL,0.75),(618,270,NULL,0.65),(618,271,1,NULL),(618,272,NULL,0.5),(618,273,NULL,0.6),(618,274,NULL,0.8),(618,277,1,NULL),(618,283,15,NULL),(618,422,1,NULL),(618,479,625000,NULL),(618,482,125,NULL),(618,484,NULL,0.75),(618,511,0,NULL),(618,524,NULL,0.75),(618,525,NULL,0.75),(618,552,30,NULL),(618,564,750,NULL),(618,600,2,NULL),(618,633,0,NULL),(618,661,3000,NULL),(618,662,NULL,0.05),(618,1132,400,NULL),(618,1137,3,NULL),(618,1154,3,NULL),(618,1178,100,NULL),(618,1179,NULL,0.01),(618,1196,NULL,0.01),(618,1198,NULL,0.01),(618,1199,100,NULL),(618,1200,100,NULL),(618,1224,1,NULL),(618,1259,NULL,0.25),(618,1261,0,NULL),(618,1262,NULL,0.5),(618,1271,15,NULL),(618,1281,1,NULL),(618,1547,1,NULL),(619,3,0,NULL),(619,9,38,NULL),(619,11,25,NULL),(619,12,4,NULL),(619,13,3,NULL),(619,14,2,NULL),(619,15,0,NULL),(619,19,1,NULL),(619,21,0,NULL),(619,37,287,NULL),(619,48,100,NULL),(619,49,0,NULL),(619,55,125000,NULL),(619,70,NULL,4.21),(619,76,15000,NULL),(619,79,2500,NULL),(619,101,0,NULL),(619,102,2,NULL),(619,109,1,NULL),(619,110,1,NULL),(619,111,1,NULL),(619,113,1,NULL),(619,124,16777215,NULL),(619,129,5,NULL),(619,136,1,NULL),(619,153,NULL,2.24e-006),(619,182,3755,NULL),(619,192,3,NULL),(619,208,0,NULL),(619,209,3,NULL),(619,210,0,NULL),(619,211,0,NULL),(619,217,395,NULL),(619,246,395,NULL),(619,263,63,NULL),(619,265,163,NULL),(619,267,NULL,0.5),(619,268,NULL,0.9),(619,269,NULL,0.75),(619,270,NULL,0.55),(619,271,1,NULL),(619,272,NULL,0.5),(619,273,NULL,0.6),(619,274,NULL,0.8),(619,277,4,NULL),(619,283,5,NULL),(619,422,1,NULL),(619,479,625000,NULL),(619,482,125,NULL),(619,484,NULL,0.75),(619,511,0,NULL),(619,524,NULL,0.75),(619,525,NULL,0.75),(619,552,30,NULL),(619,564,750,NULL),(619,600,2,NULL),(619,633,0,NULL),(619,661,3000,NULL),(619,662,NULL,0.05),(619,1132,400,NULL),(619,1137,3,NULL),(619,1154,3,NULL),(619,1178,100,NULL),(619,1179,NULL,0.01),(619,1196,NULL,0.01),(619,1198,NULL,0.01),(619,1199,100,NULL),(619,1200,100,NULL),(619,1224,1,NULL),(619,1259,NULL,0.25),(619,1261,NULL,0.5),(619,1262,NULL,0.63),(619,1271,5,NULL),(619,1281,1,NULL),(619,1547,1,NULL),(620,3,0,NULL),(620,9,1094,NULL),(620,11,475,NULL),(620,12,3,NULL),(620,13,4,NULL),(620,14,4,NULL),(620,15,0,NULL),(620,19,1,NULL),(620,21,0,NULL),(620,37,153,NULL),(620,48,275,NULL),(620,49,0,NULL),(620,55,301250,NULL),(620,70,NULL,0.505),(620,76,52500,NULL),(620,79,6000,NULL),(620,101,2,NULL),(620,102,3,NULL),(620,109,1,NULL),(620,110,1,NULL),(620,111,1,NULL),(620,113,1,NULL),(620,124,16777215,NULL),(620,129,500,NULL),(620,136,1,NULL),(620,153,NULL,8.13e-007),(620,182,3334,NULL),(620,192,5,NULL),(620,208,0,NULL),(620,209,0,NULL),(620,210,0,NULL),(620,211,14,NULL),(620,217,395,NULL),(620,246,395,NULL),(620,263,1173,NULL),(620,265,976,NULL),(620,267,NULL,0.5),(620,268,NULL,0.9),(620,269,NULL,0.75),(620,270,NULL,0.55),(620,271,1,NULL),(620,272,NULL,0.5),(620,273,NULL,0.6),(620,274,NULL,0.8),(620,277,1,NULL),(620,283,20,NULL),(620,351,500,NULL),(620,422,1,NULL),(620,479,1250000,NULL),(620,482,NULL,843.75),(620,484,NULL,0.75),(620,487,-10,NULL),(620,524,NULL,0.75),(620,525,NULL,0.75),(620,552,125,NULL),(620,564,311,NULL),(620,633,0,NULL),(620,657,20,NULL),(620,661,2000,NULL),(620,662,NULL,0.25),(620,819,0,NULL),(620,820,0,NULL),(620,821,5,NULL),(620,822,0,NULL),(620,1132,400,NULL),(620,1137,3,NULL),(620,1154,3,NULL),(620,1178,100,NULL),(620,1179,NULL,0.01),(620,1196,NULL,0.01),(620,1198,NULL,0.01),(620,1199,100,NULL),(620,1200,100,NULL),(620,1224,NULL,0.75),(620,1259,NULL,0.63),(620,1261,NULL,0.63),(620,1262,NULL,0.5),(620,1271,20,NULL),(620,1281,1,NULL),(620,1547,2,NULL),(620,1555,100,NULL),(621,3,0,NULL),(621,9,1329,NULL),(621,11,530,NULL),(621,12,2,NULL),(621,13,5,NULL),(621,14,5,NULL),(621,15,0,NULL),(621,19,1,NULL),(621,21,0,NULL),(621,37,178,NULL),(621,48,350,NULL),(621,49,0,NULL),(621,55,381250,NULL),(621,70,NULL,0.425),(621,76,57500,NULL),(621,79,6000,NULL),(621,101,5,NULL),(621,102,2,NULL),(621,109,1,NULL),(621,110,1,NULL),(621,111,1,NULL),(621,113,1,NULL),(621,124,16777215,NULL),(621,129,510,NULL),(621,136,1,NULL),(621,153,NULL,8.13e-007),(621,182,3334,NULL),(621,192,6,NULL),(621,208,0,NULL),(621,209,0,NULL),(621,210,0,NULL),(621,211,15,NULL),(621,217,395,NULL),(621,246,395,NULL),(621,263,1563,NULL),(621,265,1055,NULL),(621,267,NULL,0.5),(621,268,NULL,0.9),(621,269,NULL,0.75),(621,270,NULL,0.55),(621,271,1,NULL),(621,272,NULL,0.5),(621,273,NULL,0.6),(621,274,NULL,0.8),(621,277,2,NULL),(621,283,10,NULL),(621,422,1,NULL),(621,479,1250000,NULL),(621,482,NULL,1062.5),(621,484,NULL,0.75),(621,487,5,NULL),(621,524,NULL,0.75),(621,525,NULL,0.75),(621,552,145,NULL),(621,564,242,NULL),(621,633,0,NULL),(621,657,10,NULL),(621,661,2000,NULL),(621,662,NULL,0.25),(621,819,0,NULL),(621,820,0,NULL),(621,821,6,NULL),(621,822,0,NULL),(621,974,1,NULL),(621,975,1,NULL),(621,976,1,NULL),(621,977,1,NULL),(621,1132,400,NULL),(621,1137,3,NULL),(621,1154,3,NULL),(621,1178,100,NULL),(621,1179,NULL,0.01),(621,1196,NULL,0.01),(621,1198,NULL,0.01),(621,1199,100,NULL),(621,1200,100,NULL),(621,1224,NULL,0.75),(621,1259,NULL,0.71),(621,1261,NULL,0.71),(621,1262,NULL,0.25),(621,1271,10,NULL),(621,1281,1,NULL),(621,1547,2,NULL),(621,1555,100,NULL),(622,3,0,NULL),(622,9,1289,NULL),(622,11,700,NULL),(622,12,3,NULL),(622,13,3,NULL),(622,14,6,NULL),(622,15,0,NULL),(622,19,1,NULL),(622,21,0,NULL),(622,37,231,NULL),(622,48,300,NULL),(622,49,0,NULL),(622,55,381250,NULL),(622,70,NULL,0.48),(622,76,40000,NULL),(622,79,4500,NULL),(622,101,2,NULL),(622,102,4,NULL),(622,109,1,NULL),(622,110,1,NULL),(622,111,1,NULL),(622,113,1,NULL),(622,124,16777215,NULL),(622,129,450,NULL),(622,136,1,NULL),(622,153,NULL,8.13e-007),(622,182,3333,NULL),(622,192,5,NULL),(622,208,0,NULL),(622,209,13,NULL),(622,210,0,NULL),(622,211,0,NULL),(622,217,397,NULL),(622,246,397,NULL),(622,263,1485,NULL),(622,265,1250,NULL),(622,267,NULL,0.4),(622,268,NULL,0.9),(622,269,NULL,0.75),(622,270,NULL,0.65),(622,271,1,NULL),(622,272,NULL,0.5),(622,273,NULL,0.6),(622,274,NULL,0.8),(622,277,2,NULL),(622,283,5,NULL),(622,422,1,NULL),(622,479,1250000,NULL),(622,482,NULL,1062.5),(622,484,NULL,0.75),(622,489,-5,NULL),(622,524,NULL,0.75),(622,525,NULL,0.75),(622,552,105,NULL),(622,564,305,NULL),(622,633,0,NULL),(622,659,5,NULL),(622,661,2000,NULL),(622,662,NULL,0.25),(622,819,0,NULL),(622,820,0,NULL),(622,821,0,NULL),(622,822,9,NULL),(622,1132,400,NULL),(622,1137,3,NULL),(622,1154,3,NULL),(622,1178,100,NULL),(622,1179,NULL,0.01),(622,1196,NULL,0.01),(622,1198,NULL,0.01),(622,1199,100,NULL),(622,1200,100,NULL),(622,1224,NULL,0.75),(622,1259,NULL,0.76),(622,1261,NULL,0.5),(622,1262,NULL,0.5),(622,1271,5,NULL),(622,1281,1,NULL),(622,1547,2,NULL),(622,1555,100,NULL),(623,3,0,NULL),(623,9,1524,NULL),(623,11,780,NULL),(623,12,4,NULL),(623,13,4,NULL),(623,14,6,NULL),(623,15,0,NULL),(623,19,1,NULL),(623,21,0,NULL),(623,37,164,NULL),(623,48,360,NULL),(623,49,0,NULL),(623,55,491250,NULL),(623,70,NULL,0.54),(623,76,55000,NULL),(623,79,6000,NULL),(623,101,2,NULL),(623,102,5,NULL),(623,109,1,NULL),(623,110,1,NULL),(623,111,1,NULL),(623,113,1,NULL),(623,124,16777215,NULL),(623,129,500,NULL),(623,136,1,NULL),(623,153,NULL,8.13e-007),(623,182,3334,NULL),(623,192,7,NULL),(623,208,0,NULL),(623,209,0,NULL),(623,210,0,NULL),(623,211,16,NULL),(623,217,395,NULL),(623,246,395,NULL),(623,263,1875,NULL),(623,265,1329,NULL),(623,267,NULL,0.5),(623,268,NULL,0.9),(623,269,NULL,0.75),(623,270,NULL,0.55),(623,271,1,NULL),(623,272,NULL,0.5),(623,273,NULL,0.6),(623,274,NULL,0.8),(623,277,3,NULL),(623,283,15,NULL),(623,422,1,NULL),(623,479,1250000,NULL),(623,482,1375,NULL),(623,484,NULL,0.75),(623,487,10,NULL),(623,524,NULL,0.75),(623,525,NULL,0.75),(623,552,135,NULL),(623,564,253,NULL),(623,633,0,NULL),(623,657,-5,NULL),(623,661,2000,NULL),(623,662,NULL,0.25),(623,819,0,NULL),(623,820,0,NULL),(623,821,6,NULL),(623,822,0,NULL),(623,1132,400,NULL),(623,1137,3,NULL),(623,1154,3,NULL),(623,1178,100,NULL),(623,1179,NULL,0.01),(623,1196,NULL,0.01),(623,1198,NULL,0.01),(623,1199,100,NULL),(623,1200,100,NULL),(623,1224,NULL,0.75),(623,1259,NULL,0.76),(623,1261,NULL,0.63),(623,1262,NULL,0.63),(623,1271,15,NULL),(623,1281,1,NULL),(623,1547,2,NULL),(623,1555,100,NULL),(624,3,0,NULL),(624,9,1719,NULL),(624,11,900,NULL),(624,12,6,NULL),(624,13,3,NULL),(624,14,6,NULL),(624,15,0,NULL),(624,19,1,NULL),(624,21,0,NULL),(624,37,164,NULL),(624,48,280,NULL),(624,49,0,NULL),(624,55,537500,NULL),(624,70,NULL,0.605),(624,76,47500,NULL),(624,79,5000,NULL),(624,101,0,NULL),(624,102,5,NULL),(624,109,1,NULL),(624,110,1,NULL),(624,111,1,NULL),(624,113,1,NULL),(624,124,16777215,NULL),(624,129,500,NULL),(624,136,1,NULL),(624,153,NULL,8.13e-007),(624,182,3335,NULL),(624,192,6,NULL),(624,208,14,NULL),(624,209,0,NULL),(624,210,0,NULL),(624,211,0,NULL),(624,217,394,NULL),(624,246,394,NULL),(624,263,1368,NULL),(624,265,1875,NULL),(624,267,NULL,0.5),(624,268,NULL,0.8),(624,269,NULL,0.75),(624,270,NULL,0.65),(624,271,1,NULL),(624,272,NULL,0.5),(624,273,NULL,0.6),(624,274,NULL,0.8),(624,277,3,NULL),(624,283,0,NULL),(624,422,1,NULL),(624,478,-10,NULL),(624,479,1250000,NULL),(624,482,1500,NULL),(624,484,NULL,0.75),(624,524,NULL,0.75),(624,525,NULL,0.75),(624,552,130,NULL),(624,564,270,NULL),(624,633,0,NULL),(624,656,-5,NULL),(624,661,2000,NULL),(624,662,NULL,0.25),(624,819,7,NULL),(624,820,0,NULL),(624,821,0,NULL),(624,822,0,NULL),(624,1132,400,NULL),(624,1137,3,NULL),(624,1154,3,NULL),(624,1178,100,NULL),(624,1179,NULL,0.01),(624,1196,NULL,0.01),(624,1198,NULL,0.01),(624,1199,100,NULL),(624,1200,100,NULL),(624,1224,NULL,0.75),(624,1259,NULL,0.76),(624,1261,NULL,0.5),(624,1262,NULL,0.76),(624,1271,0,NULL),(624,1281,1,NULL),(624,1547,2,NULL),(624,1555,100,NULL),(625,3,0,NULL),(625,9,1329,NULL),(625,11,475,NULL),(625,12,5,NULL),(625,13,2,NULL),(625,14,4,NULL),(625,15,0,NULL),(625,19,1,NULL),(625,21,0,NULL),(625,37,153,NULL),(625,48,225,NULL),(625,49,0,NULL),(625,55,335000,NULL),(625,70,NULL,0.625),(625,76,42500,NULL),(625,79,5000,NULL),(625,101,0,NULL),(625,102,3,NULL),(625,109,1,NULL),(625,110,1,NULL),(625,111,1,NULL),(625,113,1,NULL),(625,124,16777215,NULL),(625,129,320,NULL),(625,136,1,NULL),(625,153,NULL,8.13e-007),(625,182,3335,NULL),(625,192,5,NULL),(625,208,11,NULL),(625,209,0,NULL),(625,210,0,NULL),(625,211,0,NULL),(625,217,394,NULL),(625,246,394,NULL),(625,263,860,NULL),(625,265,1329,NULL),(625,267,NULL,0.5),(625,268,NULL,0.8),(625,269,NULL,0.75),(625,270,NULL,0.65),(625,271,1,NULL),(625,272,NULL,0.5),(625,273,NULL,0.6),(625,274,NULL,0.8),(625,277,1,NULL),(625,283,5,NULL),(625,351,500,NULL),(625,422,1,NULL),(625,478,-10,NULL),(625,479,1250000,NULL),(625,482,NULL,937.5),(625,484,NULL,0.75),(625,524,NULL,0.75),(625,525,NULL,0.75),(625,552,110,NULL),(625,564,328,NULL),(625,633,0,NULL),(625,656,10,NULL),(625,661,2000,NULL),(625,662,NULL,0.25),(625,819,6,NULL),(625,820,0,NULL),(625,821,0,NULL),(625,822,0,NULL),(625,1132,400,NULL),(625,1137,3,NULL),(625,1154,3,NULL),(625,1178,100,NULL),(625,1179,NULL,0.01),(625,1196,NULL,0.01),(625,1198,NULL,0.01),(625,1199,100,NULL),(625,1200,100,NULL),(625,1224,NULL,0.75),(625,1259,NULL,0.63),(625,1261,NULL,0.25),(625,1262,NULL,0.71),(625,1271,5,NULL),(625,1281,1,NULL),(625,1547,2,NULL),(625,1555,100,NULL),(626,3,0,NULL),(626,9,1485,NULL),(626,11,675,NULL),(626,12,4,NULL),(626,13,3,NULL),(626,14,5,NULL),(626,15,0,NULL),(626,19,1,NULL),(626,21,0,NULL),(626,37,159,NULL),(626,48,270,NULL),(626,49,0,NULL),(626,55,446250,NULL),(626,70,NULL,0.6),(626,76,52500,NULL),(626,79,5500,NULL),(626,101,0,NULL),(626,102,4,NULL),(626,109,1,NULL),(626,110,1,NULL),(626,111,1,NULL),(626,113,1,NULL),(626,124,16777215,NULL),(626,129,670,NULL),(626,136,1,NULL),(626,153,NULL,8.13e-007),(626,182,3332,NULL),(626,192,5,NULL),(626,208,0,NULL),(626,209,0,NULL),(626,210,14,NULL),(626,211,0,NULL),(626,217,394,NULL),(626,246,394,NULL),(626,263,1173,NULL),(626,265,1485,NULL),(626,267,NULL,0.5),(626,268,NULL,0.9),(626,269,NULL,0.65),(626,270,NULL,0.65),(626,271,1,NULL),(626,272,NULL,0.5),(626,273,NULL,0.6),(626,274,NULL,0.8),(626,277,2,NULL),(626,283,100,NULL),(626,422,1,NULL),(626,479,1250000,NULL),(626,482,1250,NULL),(626,484,NULL,0.75),(626,486,5,NULL),(626,524,NULL,0.75),(626,525,NULL,0.75),(626,552,150,NULL),(626,564,276,NULL),(626,633,0,NULL),(626,658,10,NULL),(626,661,2000,NULL),(626,662,NULL,0.25),(626,819,0,NULL),(626,820,6,NULL),(626,821,0,NULL),(626,822,0,NULL),(626,1132,400,NULL),(626,1137,3,NULL),(626,1154,3,NULL),(626,1178,100,NULL),(626,1179,NULL,0.01),(626,1196,NULL,0.01),(626,1198,NULL,0.01),(626,1199,100,NULL),(626,1200,100,NULL),(626,1224,NULL,0.75),(626,1259,NULL,0.71),(626,1261,NULL,0.5),(626,1262,NULL,0.63),(626,1271,75,NULL),(626,1281,1,NULL),(626,1547,2,NULL),(626,1555,100,NULL),(627,3,0,NULL),(627,9,1875,NULL),(627,11,820,NULL),(627,12,5,NULL),(627,13,3,NULL),(627,14,5,NULL),(627,15,0,NULL),(627,19,1,NULL),(627,21,0,NULL),(627,37,170,NULL),(627,48,300,NULL),(627,49,0,NULL),(627,55,491250,NULL),(627,70,NULL,0.585),(627,76,55000,NULL),(627,79,5500,NULL),(627,101,0,NULL),(627,102,5,NULL),(627,109,1,NULL),(627,110,1,NULL),(627,111,1,NULL),(627,113,1,NULL),(627,124,16777215,NULL),(627,129,760,NULL),(627,136,1,NULL),(627,153,NULL,8.13e-007),(627,182,3332,NULL),(627,192,6,NULL),(627,208,0,NULL),(627,209,0,NULL),(627,210,15,NULL),(627,211,0,NULL),(627,217,394,NULL),(627,246,394,NULL),(627,263,1524,NULL),(627,265,1641,NULL),(627,267,NULL,0.5),(627,268,NULL,0.9),(627,269,NULL,0.65),(627,270,NULL,0.65),(627,271,1,NULL),(627,272,NULL,0.5),(627,273,NULL,0.6),(627,274,NULL,0.8),(627,277,3,NULL),(627,283,50,NULL),(627,422,1,NULL),(627,479,1250000,NULL),(627,482,1375,NULL),(627,484,NULL,0.75),(627,486,5,NULL),(627,524,NULL,0.75),(627,525,NULL,0.75),(627,552,140,NULL),(627,564,259,NULL),(627,633,0,NULL),(627,658,NULL,0.05),(627,661,2000,NULL),(627,662,NULL,0.25),(627,819,0,NULL),(627,820,7,NULL),(627,821,0,NULL),(627,822,0,NULL),(627,1132,400,NULL),(627,1137,3,NULL),(627,1154,3,NULL),(627,1178,100,NULL),(627,1179,NULL,0.01),(627,1196,NULL,0.01),(627,1198,NULL,0.01),(627,1199,100,NULL),(627,1200,100,NULL),(627,1224,NULL,0.75),(627,1259,NULL,0.71),(627,1261,NULL,0.5),(627,1262,NULL,0.71),(627,1271,50,NULL),(627,1281,1,NULL),(627,1547,2,NULL),(627,1555,100,NULL),(628,3,0,NULL),(628,9,1368,NULL),(628,11,575,NULL),(628,12,4,NULL),(628,13,4,NULL),(628,14,4,NULL),(628,15,0,NULL),(628,19,1,NULL),(628,21,0,NULL),(628,37,159,NULL),(628,48,300,NULL),(628,49,0,NULL),(628,55,381250,NULL),(628,70,NULL,0.61),(628,76,50000,NULL),(628,79,5000,NULL),(628,101,1,NULL),(628,102,2,NULL),(628,109,1,NULL),(628,110,1,NULL),(628,111,1,NULL),(628,113,1,NULL),(628,124,16777215,NULL),(628,129,450,NULL),(628,136,1,NULL),(628,153,NULL,8.13e-007),(628,182,3335,NULL),(628,192,6,NULL),(628,208,12,NULL),(628,209,0,NULL),(628,210,0,NULL),(628,211,0,NULL),(628,217,394,NULL),(628,246,394,NULL),(628,263,1016,NULL),(628,265,1368,NULL),(628,267,NULL,0.5),(628,268,NULL,0.8),(628,269,NULL,0.75),(628,270,NULL,0.65),(628,271,1,NULL),(628,272,NULL,0.5),(628,273,NULL,0.6),(628,274,NULL,0.8),(628,277,2,NULL),(628,283,150,NULL),(628,422,1,NULL),(628,478,5,NULL),(628,479,1250000,NULL),(628,482,NULL,1062.5),(628,484,NULL,0.75),(628,524,NULL,0.75),(628,525,NULL,0.75),(628,552,130,NULL),(628,564,282,NULL),(628,633,0,NULL),(628,656,10,NULL),(628,661,2000,NULL),(628,662,NULL,0.25),(628,819,6,NULL),(628,820,0,NULL),(628,821,0,NULL),(628,822,0,NULL),(628,1132,400,NULL),(628,1137,3,NULL),(628,1154,3,NULL),(628,1178,100,NULL),(628,1179,NULL,0.01),(628,1196,NULL,0.01),(628,1198,NULL,0.01),(628,1199,100,NULL),(628,1200,100,NULL),(628,1224,NULL,0.75),(628,1259,NULL,0.63),(628,1261,NULL,0.63),(628,1262,NULL,0.63),(628,1271,50,NULL),(628,1281,1,NULL),(628,1547,2,NULL),(628,1555,100,NULL),(629,3,0,NULL),(629,9,1563,NULL),(629,11,860,NULL),(629,12,5,NULL),(629,13,3,NULL),(629,14,6,NULL),(629,15,0,NULL),(629,19,1,NULL),(629,21,0,NULL),(629,37,192,NULL),(629,48,325,NULL),(629,49,0,NULL),(629,55,446250,NULL),(629,70,NULL,0.54),(629,76,45000,NULL),(629,79,4500,NULL),(629,101,3,NULL),(629,102,4,NULL),(629,109,1,NULL),(629,110,1,NULL),(629,111,1,NULL),(629,113,1,NULL),(629,124,16777215,NULL),(629,129,690,NULL),(629,136,1,NULL),(629,153,NULL,8.13e-007),(629,182,3333,NULL),(629,192,5,NULL),(629,208,0,NULL),(629,209,12,NULL),(629,210,0,NULL),(629,211,0,NULL),(629,217,397,NULL),(629,246,397,NULL),(629,263,1563,NULL),(629,265,1641,NULL),(629,267,NULL,0.4),(629,268,NULL,0.9),(629,269,NULL,0.75),(629,270,NULL,0.65),(629,271,1,NULL),(629,272,NULL,0.5),(629,273,NULL,0.6),(629,274,NULL,0.8),(629,277,3,NULL),(629,283,30,NULL),(629,422,1,NULL),(629,479,1250000,NULL),(629,482,1250,NULL),(629,484,NULL,0.75),(629,489,-5,NULL),(629,524,NULL,0.75),(629,525,NULL,0.75),(629,552,130,NULL),(629,564,282,NULL),(629,633,0,NULL),(629,659,5,NULL),(629,661,2000,NULL),(629,662,NULL,0.25),(629,819,0,NULL),(629,820,0,NULL),(629,821,0,NULL),(629,822,8,NULL),(629,1132,400,NULL),(629,1137,3,NULL),(629,1154,3,NULL),(629,1178,100,NULL),(629,1179,NULL,0.01),(629,1196,NULL,0.01),(629,1198,NULL,0.01),(629,1199,100,NULL),(629,1200,100,NULL),(629,1224,NULL,0.75),(629,1259,NULL,0.76),(629,1261,NULL,0.5),(629,1262,NULL,0.71),(629,1271,30,NULL),(629,1281,1,NULL),(629,1547,2,NULL),(629,1555,100,NULL),(630,3,0,NULL),(630,9,1211,NULL),(630,11,575,NULL),(630,12,3,NULL),(630,13,4,NULL),(630,14,5,NULL),(630,15,0,NULL),(630,19,1,NULL),(630,21,0,NULL),(630,37,209,NULL),(630,48,250,NULL),(630,49,0,NULL),(630,55,335000,NULL),(630,70,NULL,0.51),(630,76,42500,NULL),(630,79,4500,NULL),(630,101,3,NULL),(630,102,3,NULL),(630,109,1,NULL),(630,110,1,NULL),(630,111,1,NULL),(630,113,1,NULL),(630,124,16777215,NULL),(630,129,580,NULL),(630,136,1,NULL),(630,153,NULL,8.13e-007),(630,182,3333,NULL),(630,192,7,NULL),(630,208,0,NULL),(630,209,11,NULL),(630,210,0,NULL),(630,211,0,NULL),(630,217,397,NULL),(630,246,397,NULL),(630,263,1250,NULL),(630,265,1211,NULL),(630,267,NULL,0.4),(630,268,NULL,0.9),(630,269,NULL,0.75),(630,270,NULL,0.65),(630,271,1,NULL),(630,272,NULL,0.5),(630,273,NULL,0.6),(630,274,NULL,0.8),(630,277,2,NULL),(630,283,40,NULL),(630,422,1,NULL),(630,479,1250000,NULL),(630,482,NULL,937.5),(630,484,NULL,0.75),(630,489,-5,NULL),(630,524,NULL,0.75),(630,525,NULL,0.75),(630,552,110,NULL),(630,564,293,NULL),(630,633,0,NULL),(630,659,NULL,7.5),(630,661,2000,NULL),(630,662,NULL,0.25),(630,819,0,NULL),(630,820,0,NULL),(630,821,0,NULL),(630,822,7,NULL),(630,974,1,NULL),(630,975,1,NULL),(630,976,1,NULL),(630,977,1,NULL),(630,1132,400,NULL),(630,1137,3,NULL),(630,1154,3,NULL),(630,1178,100,NULL),(630,1179,NULL,0.01),(630,1196,NULL,0.01),(630,1198,NULL,0.01),(630,1199,100,NULL),(630,1200,100,NULL),(630,1224,NULL,0.75),(630,1259,NULL,0.71),(630,1261,NULL,0.63),(630,1262,NULL,0.5),(630,1271,40,NULL),(630,1281,1,NULL),(630,1547,2,NULL),(630,1555,100,NULL),(631,3,0,NULL),(631,9,976,NULL),(631,11,425,NULL),(631,12,3,NULL),(631,13,3,NULL),(631,14,5,NULL),(631,15,0,NULL),(631,19,1,NULL),(631,21,0,NULL),(631,37,209,NULL),(631,48,225,NULL),(631,49,0,NULL),(631,55,278750,NULL),(631,70,NULL,0.505),(631,76,37500,NULL),(631,79,4500,NULL),(631,101,2,NULL),(631,102,3,NULL),(631,109,1,NULL),(631,110,1,NULL),(631,111,1,NULL),(631,113,1,NULL),(631,124,16777215,NULL),(631,129,630,NULL),(631,136,1,NULL),(631,153,NULL,8.13e-007),(631,182,3333,NULL),(631,192,6,NULL),(631,208,0,NULL),(631,209,11,NULL),(631,210,0,NULL),(631,211,0,NULL),(631,217,397,NULL),(631,246,397,NULL),(631,263,976,NULL),(631,265,976,NULL),(631,267,NULL,0.4),(631,268,NULL,0.9),(631,269,NULL,0.75),(631,270,NULL,0.65),(631,271,1,NULL),(631,272,NULL,0.5),(631,273,NULL,0.6),(631,274,NULL,0.8),(631,277,1,NULL),(631,283,5,NULL),(631,351,500,NULL),(631,422,1,NULL),(631,479,1250000,NULL),(631,482,NULL,781.25),(631,484,NULL,0.75),(631,489,NULL,3.5),(631,524,NULL,0.75),(631,525,NULL,0.75),(631,552,100,NULL),(631,564,345,NULL),(631,633,0,NULL),(631,659,20,NULL),(631,661,2000,NULL),(631,662,NULL,0.25),(631,819,0,NULL),(631,820,0,NULL),(631,821,0,NULL),(631,822,7,NULL),(631,1132,400,NULL),(631,1137,3,NULL),(631,1154,3,NULL),(631,1178,100,NULL),(631,1179,NULL,0.01),(631,1196,NULL,0.01),(631,1198,NULL,0.01),(631,1199,100,NULL),(631,1200,100,NULL),(631,1224,NULL,0.75),(631,1259,NULL,0.71),(631,1261,NULL,0.5),(631,1262,NULL,0.5),(631,1271,5,NULL),(631,1281,1,NULL),(631,1547,2,NULL),(631,1555,100,NULL),(632,3,0,NULL),(632,9,1133,NULL),(632,11,525,NULL),(632,12,2,NULL),(632,13,6,NULL),(632,14,4,NULL),(632,15,0,NULL),(632,19,1,NULL),(632,21,0,NULL),(632,37,181,NULL),(632,48,400,NULL),(632,49,0,NULL),(632,55,381250,NULL),(632,70,NULL,0.455),(632,76,75000,NULL),(632,79,6000,NULL),(632,101,3,NULL),(632,102,3,NULL),(632,109,1,NULL),(632,110,1,NULL),(632,111,1,NULL),(632,113,1,NULL),(632,124,16777215,NULL),(632,129,400,NULL),(632,136,1,NULL),(632,153,NULL,8.13e-007),(632,182,3334,NULL),(632,192,8,NULL),(632,208,0,NULL),(632,209,0,NULL),(632,210,0,NULL),(632,211,20,NULL),(632,217,395,NULL),(632,246,395,NULL),(632,263,1406,NULL),(632,265,1055,NULL),(632,267,NULL,0.5),(632,268,NULL,0.9),(632,269,NULL,0.75),(632,270,NULL,0.55),(632,271,1,NULL),(632,272,NULL,0.5),(632,273,NULL,0.6),(632,274,NULL,0.8),(632,277,2,NULL),(632,283,0,NULL),(632,422,1,NULL),(632,479,1250000,NULL),(632,482,NULL,1062.5),(632,484,NULL,0.75),(632,487,15,NULL),(632,524,NULL,0.75),(632,525,NULL,0.75),(632,552,150,NULL),(632,564,230,NULL),(632,633,0,NULL),(632,657,10,NULL),(632,661,2000,NULL),(632,662,NULL,0.25),(632,819,0,NULL),(632,820,0,NULL),(632,821,5,NULL),(632,822,0,NULL),(632,1132,400,NULL),(632,1137,3,NULL),(632,1154,3,NULL),(632,1178,100,NULL),(632,1179,NULL,0.01),(632,1196,NULL,0.01),(632,1198,NULL,0.01),(632,1199,100,NULL),(632,1200,100,NULL),(632,1224,NULL,0.75),(632,1259,NULL,0.63),(632,1261,NULL,0.76),(632,1262,NULL,0.25),(632,1271,0,NULL),(632,1281,1,NULL),(632,1547,2,NULL),(632,1555,100,NULL),(633,3,0,NULL),(633,9,1289,NULL),(633,11,575,NULL),(633,12,3,NULL),(633,13,5,NULL),(633,14,4,NULL),(633,15,0,NULL),(633,19,1,NULL),(633,21,0,NULL),(633,37,181,NULL),(633,48,325,NULL),(633,49,0,NULL),(633,55,400000,NULL),(633,70,NULL,0.565),(633,76,65000,NULL),(633,79,5500,NULL),(633,101,2,NULL),(633,102,3,NULL),(633,109,1,NULL),(633,110,1,NULL),(633,111,1,NULL),(633,113,1,NULL),(633,124,16777215,NULL),(633,129,670,NULL),(633,136,1,NULL),(633,153,NULL,8.13e-007),(633,182,3332,NULL),(633,192,6,NULL),(633,208,0,NULL),(633,209,0,NULL),(633,210,18,NULL),(633,211,0,NULL),(633,217,394,NULL),(633,246,394,NULL),(633,263,1173,NULL),(633,265,1289,NULL),(633,267,NULL,0.5),(633,268,NULL,0.9),(633,269,NULL,0.65),(633,270,NULL,0.65),(633,271,1,NULL),(633,272,NULL,0.5),(633,273,NULL,0.6),(633,274,NULL,0.8),(633,277,2,NULL),(633,283,40,NULL),(633,422,1,NULL),(633,479,1250000,NULL),(633,482,1125,NULL),(633,484,NULL,0.75),(633,486,5,NULL),(633,524,NULL,0.75),(633,525,NULL,0.75),(633,552,135,NULL),(633,564,288,NULL),(633,633,0,NULL),(633,658,5,NULL),(633,661,2000,NULL),(633,662,NULL,0.25),(633,819,0,NULL),(633,820,6,NULL),(633,821,0,NULL),(633,822,0,NULL),(633,1132,400,NULL),(633,1137,3,NULL),(633,1154,3,NULL),(633,1178,100,NULL),(633,1179,NULL,0.01),(633,1196,NULL,0.01),(633,1198,NULL,0.01),(633,1199,100,NULL),(633,1200,100,NULL),(633,1224,NULL,0.75),(633,1259,NULL,0.63),(633,1261,NULL,0.71),(633,1262,NULL,0.5),(633,1271,40,NULL),(633,1281,1,NULL),(633,1547,2,NULL),(633,1555,100,NULL),(634,3,0,NULL),(634,9,1094,NULL),(634,11,500,NULL),(634,12,3,NULL),(634,13,4,NULL),(634,14,4,NULL),(634,15,0,NULL),(634,19,1,NULL),(634,21,0,NULL),(634,37,159,NULL),(634,48,250,NULL),(634,49,0,NULL),(634,55,356250,NULL),(634,70,NULL,0.61),(634,76,47500,NULL),(634,79,5500,NULL),(634,101,0,NULL),(634,102,4,NULL),(634,109,1,NULL),(634,110,1,NULL),(634,111,1,NULL),(634,113,1,NULL),(634,124,16777215,NULL),(634,129,750,NULL),(634,136,1,NULL),(634,153,NULL,8.13e-007),(634,182,3332,NULL),(634,192,5,NULL),(634,208,0,NULL),(634,209,0,NULL),(634,210,13,NULL),(634,211,0,NULL),(634,217,395,NULL),(634,246,395,NULL),(634,263,899,NULL),(634,265,1173,NULL),(634,267,NULL,0.5),(634,268,NULL,0.9),(634,269,NULL,0.65),(634,270,NULL,0.65),(634,271,1,NULL),(634,272,NULL,0.5),(634,273,NULL,0.6),(634,274,NULL,0.8),(634,277,1,NULL),(634,283,40,NULL),(634,351,500,NULL),(634,422,1,NULL),(634,479,1250000,NULL),(634,482,1000,NULL),(634,484,NULL,0.75),(634,486,-10,NULL),(634,524,NULL,0.75),(634,525,NULL,0.75),(634,552,120,NULL),(634,564,322,NULL),(634,633,0,NULL),(634,658,10,NULL),(634,661,2000,NULL),(634,662,NULL,0.25),(634,819,0,NULL),(634,820,6,NULL),(634,821,0,NULL),(634,822,0,NULL),(634,1132,400,NULL),(634,1137,3,NULL),(634,1154,3,NULL),(634,1178,100,NULL),(634,1179,NULL,0.01),(634,1196,NULL,0.01),(634,1198,NULL,0.01),(634,1199,100,NULL),(634,1200,100,NULL),(634,1224,NULL,0.75),(634,1259,NULL,0.63),(634,1261,NULL,0.63),(634,1262,NULL,0.5),(634,1271,40,NULL),(634,1281,1,NULL),(634,1547,2,NULL),(634,1555,100,NULL),(635,3,0,NULL),(635,9,1250,NULL),(635,11,600,NULL),(635,12,6,NULL),(635,13,3,NULL),(635,14,5,NULL),(635,15,0,NULL),(635,19,1,NULL),(635,21,0,NULL),(635,37,250,NULL),(635,48,400,NULL),(635,49,0,NULL),(635,55,375000,NULL),(635,70,NULL,0.65),(635,76,20000,NULL),(635,79,3000,NULL),(635,101,2,NULL),(635,102,2,NULL),(635,109,1,NULL),(635,110,1,NULL),(635,111,1,NULL),(635,113,1,NULL),(635,124,16777215,NULL),(635,129,500,NULL),(635,136,1,NULL),(635,153,NULL,8.13e-007),(635,182,3332,NULL),(635,192,5,NULL),(635,208,19,NULL),(635,209,0,NULL),(635,210,0,NULL),(635,211,0,NULL),(635,217,394,NULL),(635,246,394,NULL),(635,263,900,NULL),(635,265,1250,NULL),(635,267,NULL,0.5),(635,268,NULL,0.9),(635,269,NULL,0.75),(635,270,NULL,0.65),(635,271,1,NULL),(635,272,NULL,0.5),(635,273,NULL,0.6),(635,274,NULL,0.8),(635,277,1,NULL),(635,283,50,NULL),(635,422,1,NULL),(635,479,625000,NULL),(635,482,800,NULL),(635,484,NULL,0.75),(635,524,NULL,0.75),(635,525,NULL,0.75),(635,552,100,NULL),(635,564,300,NULL),(635,633,0,NULL),(635,661,2000,NULL),(635,662,NULL,0.25),(635,1132,300,NULL),(635,1137,3,NULL),(635,1154,3,NULL),(635,1178,100,NULL),(635,1179,NULL,0.01),(635,1196,NULL,0.01),(635,1198,NULL,0.01),(635,1199,100,NULL),(635,1200,100,NULL),(635,1224,NULL,0.75),(635,1259,NULL,0.71),(635,1261,NULL,0.5),(635,1262,NULL,0.76),(635,1271,50,NULL),(635,1281,1,NULL),(635,1547,2,NULL),(636,3,0,NULL),(636,9,144,NULL),(636,11,300,NULL),(636,12,1,NULL),(636,13,5,NULL),(636,14,4,NULL),(636,15,0,NULL),(636,19,1,NULL),(636,21,0,NULL),(636,37,220,NULL),(636,48,100,NULL),(636,49,0,NULL),(636,55,375000,NULL),(636,70,NULL,0.65),(636,76,20000,NULL),(636,79,3000,NULL),(636,101,2,NULL),(636,102,2,NULL),(636,109,1,NULL),(636,110,1,NULL),(636,111,1,NULL),(636,113,1,NULL),(636,124,16777215,NULL),(636,129,500,NULL),(636,136,1,NULL),(636,153,NULL,8.13e-007),(636,182,3335,NULL),(636,192,2,NULL),(636,208,3,NULL),(636,209,0,NULL),(636,210,0,NULL),(636,211,0,NULL),(636,217,395,NULL),(636,246,395,NULL),(636,263,625,NULL),(636,265,500,NULL),(636,267,NULL,0.5),(636,268,NULL,0.9),(636,269,NULL,0.65),(636,270,NULL,0.65),(636,271,1,NULL),(636,272,NULL,0.5),(636,273,NULL,0.6),(636,274,NULL,0.8),(636,277,1,NULL),(636,283,10,NULL),(636,422,1,NULL),(636,479,1250000,NULL),(636,482,250,NULL),(636,484,NULL,0.75),(636,524,NULL,0.75),(636,525,NULL,0.75),(636,552,100,NULL),(636,564,300,NULL),(636,633,0,NULL),(636,661,2000,NULL),(636,662,NULL,0.25),(636,1132,300,NULL),(636,1137,3,NULL),(636,1154,3,NULL),(636,1178,100,NULL),(636,1179,NULL,0.01),(636,1196,NULL,0.01),(636,1198,NULL,0.01),(636,1199,100,NULL),(636,1200,100,NULL),(636,1224,NULL,0.75),(636,1259,NULL,0.63),(636,1261,NULL,0.71),(636,1262,0,NULL),(636,1271,10,NULL),(636,1281,1,NULL),(636,1547,2,NULL),(637,3,0,NULL),(637,9,1250,NULL),(637,11,700,NULL),(637,12,5,NULL),(637,13,2,NULL),(637,14,6,NULL),(637,15,0,NULL),(637,19,1,NULL),(637,21,0,NULL),(637,37,165,NULL),(637,48,275,NULL),(637,49,0,NULL),(637,55,468750,NULL),(637,70,NULL,0.65),(637,76,45000,NULL),(637,79,4500,NULL),(637,101,3,NULL),(637,102,4,NULL),(637,109,1,NULL),(637,110,1,NULL),(637,111,1,NULL),(637,113,1,NULL),(637,124,16777215,NULL),(637,129,690,NULL),(637,136,1,NULL),(637,153,NULL,8.13e-007),(637,182,3333,NULL),(637,192,5,NULL),(637,208,0,NULL),(637,209,11,NULL),(637,210,0,NULL),(637,211,0,NULL),(637,217,395,NULL),(637,246,395,NULL),(637,263,1250,NULL),(637,265,1313,NULL),(637,267,NULL,0.4),(637,268,NULL,0.9),(637,269,NULL,0.75),(637,270,NULL,0.65),(637,271,1,NULL),(637,272,NULL,0.5),(637,273,NULL,0.6),(637,274,NULL,0.8),(637,277,3,NULL),(637,283,30,NULL),(637,422,1,NULL),(637,479,1250000,NULL),(637,482,1250,NULL),(637,484,NULL,0.75),(637,524,NULL,0.75),(637,525,NULL,0.75),(637,552,100,NULL),(637,564,300,NULL),(637,633,0,NULL),(637,661,2000,NULL),(637,662,NULL,0.25),(637,1132,300,NULL),(637,1137,3,NULL),(637,1154,3,NULL),(637,1178,100,NULL),(637,1179,NULL,0.01),(637,1196,NULL,0.01),(637,1198,NULL,0.01),(637,1199,100,NULL),(637,1200,100,NULL),(637,1224,NULL,0.75),(637,1259,NULL,0.76),(637,1261,NULL,0.25),(637,1262,NULL,0.71),(637,1271,30,NULL),(637,1281,1,NULL),(637,1547,2,NULL),(638,3,0,NULL),(638,9,6641,NULL),(638,11,9500,NULL),(638,12,5,NULL),(638,13,6,NULL),(638,14,8,NULL),(638,15,0,NULL),(638,19,1,NULL),(638,21,0,NULL),(638,37,94,NULL),(638,48,700,NULL),(638,49,0,NULL),(638,55,1154875,NULL),(638,70,NULL,0.128),(638,76,75000,NULL),(638,79,9000,NULL),(638,101,6,NULL),(638,102,4,NULL),(638,109,1,NULL),(638,110,1,NULL),(638,111,1,NULL),(638,113,1,NULL),(638,124,16777215,NULL),(638,129,1000,NULL),(638,136,1,NULL),(638,153,NULL,1.38e-007),(638,182,3338,NULL),(638,192,7,NULL),(638,208,0,NULL),(638,209,0,NULL),(638,210,0,NULL),(638,211,22,NULL),(638,217,395,NULL),(638,246,395,NULL),(638,263,7500,NULL),(638,265,6641,NULL),(638,267,NULL,0.5),(638,268,NULL,0.9),(638,269,NULL,0.75),(638,270,NULL,0.55),(638,271,1,NULL),(638,272,NULL,0.5),(638,273,NULL,0.6),(638,274,NULL,0.8),(638,277,2,NULL),(638,283,75,NULL),(638,479,2500000,NULL),(638,482,NULL,5312.5),(638,484,NULL,0.75),(638,491,10,NULL),(638,501,-5,NULL),(638,524,NULL,0.75),(638,525,NULL,0.75),(638,552,460,NULL),(638,564,85,NULL),(638,598,10,NULL),(638,600,1,NULL),(638,633,0,NULL),(638,661,1000,NULL),(638,662,NULL,0.5),(638,819,0,NULL),(638,820,0,NULL),(638,821,7,NULL),(638,822,0,NULL),(638,1132,400,NULL),(638,1137,3,NULL),(638,1154,3,NULL),(638,1178,100,NULL),(638,1179,NULL,0.01),(638,1196,NULL,0.01),(638,1198,NULL,0.01),(638,1199,100,NULL),(638,1200,100,NULL),(638,1224,NULL,0.5),(638,1259,NULL,0.82),(638,1261,NULL,0.76),(638,1262,NULL,0.71),(638,1271,75,NULL),(638,1281,1,NULL),(638,1547,3,NULL),(638,1555,500,NULL),(639,3,0,NULL),(639,9,6641,NULL),(639,11,15500,NULL),(639,12,6,NULL),(639,13,5,NULL),(639,14,8,NULL),(639,15,0,NULL),(639,19,1,NULL),(639,21,0,NULL),(639,37,120,NULL),(639,48,550,NULL),(639,49,0,NULL),(639,55,1154875,NULL),(639,70,NULL,0.12),(639,76,62500,NULL),(639,79,6750,NULL),(639,101,4,NULL),(639,102,6,NULL),(639,109,1,NULL),(639,110,1,NULL),(639,111,1,NULL),(639,113,1,NULL),(639,124,16777215,NULL),(639,129,1000,NULL),(639,136,1,NULL),(639,153,NULL,1.38e-007),(639,182,3337,NULL),(639,192,7,NULL),(639,208,0,NULL),(639,209,19,NULL),(639,210,0,NULL),(639,211,0,NULL),(639,217,397,NULL),(639,246,397,NULL),(639,263,6954,NULL),(639,265,6211,NULL),(639,267,NULL,0.4),(639,268,NULL,0.9),(639,269,NULL,0.75),(639,270,NULL,0.65),(639,271,1,NULL),(639,272,NULL,0.5),(639,273,NULL,0.6),(639,274,NULL,0.8),(639,277,2,NULL),(639,283,75,NULL),(639,479,2500000,NULL),(639,482,NULL,5312.5),(639,484,NULL,0.75),(639,490,5,NULL),(639,518,-5,NULL),(639,524,NULL,0.75),(639,525,NULL,0.75),(639,552,340,NULL),(639,564,100,NULL),(639,600,1,NULL),(639,633,0,NULL),(639,661,1000,NULL),(639,662,NULL,0.5),(639,819,0,NULL),(639,820,0,NULL),(639,821,0,NULL),(639,822,9,NULL),(639,1132,400,NULL),(639,1137,3,NULL),(639,1154,3,NULL),(639,1178,100,NULL),(639,1179,NULL,0.01),(639,1196,NULL,0.01),(639,1198,NULL,0.01),(639,1199,100,NULL),(639,1200,100,NULL),(639,1224,NULL,0.5),(639,1259,NULL,0.82),(639,1261,NULL,0.71),(639,1262,NULL,0.76),(639,1271,75,NULL),(639,1281,1,NULL),(639,1547,3,NULL),(639,1555,500,NULL),(640,3,0,NULL),(640,9,5469,NULL),(640,11,9000,NULL),(640,12,4,NULL),(640,13,8,NULL),(640,14,6,NULL),(640,15,0,NULL),(640,19,1,NULL),(640,21,0,NULL),(640,37,94,NULL),(640,48,750,NULL),(640,49,0,NULL),(640,55,1087500,NULL),(640,70,NULL,0.116),(640,76,90000,NULL),(640,79,9000,NULL),(640,101,4,NULL),(640,102,4,NULL),(640,109,1,NULL),(640,110,1,NULL),(640,111,1,NULL),(640,113,1,NULL),(640,124,16777215,NULL),(640,129,1000,NULL),(640,136,1,NULL),(640,153,NULL,1.38e-007),(640,182,3338,NULL),(640,192,7,NULL),(640,208,0,NULL),(640,209,0,NULL),(640,210,0,NULL),(640,211,24,NULL),(640,217,395,NULL),(640,246,395,NULL),(640,263,6641,NULL),(640,265,5469,NULL),(640,267,NULL,0.5),(640,268,NULL,0.9),(640,269,NULL,0.75),(640,270,NULL,0.55),(640,271,1,NULL),(640,272,NULL,0.5),(640,273,NULL,0.6),(640,274,NULL,0.8),(640,277,1,NULL),(640,283,75,NULL),(640,479,2500000,NULL),(640,482,NULL,5312.5),(640,484,NULL,0.75),(640,491,15,NULL),(640,524,NULL,0.75),(640,525,NULL,0.75),(640,552,480,NULL),(640,564,75,NULL),(640,598,20,NULL),(640,600,1,NULL),(640,633,0,NULL),(640,661,1000,NULL),(640,662,NULL,0.5),(640,797,249999,NULL),(640,819,0,NULL),(640,820,0,NULL),(640,821,7,NULL),(640,822,0,NULL),(640,1132,400,NULL),(640,1137,3,NULL),(640,1154,3,NULL),(640,1178,100,NULL),(640,1179,NULL,0.01),(640,1196,NULL,0.01),(640,1198,NULL,0.01),(640,1199,100,NULL),(640,1200,100,NULL),(640,1224,NULL,0.5),(640,1259,NULL,0.76),(640,1261,NULL,0.82),(640,1262,NULL,0.63),(640,1271,75,NULL),(640,1281,1,NULL),(640,1547,3,NULL),(640,1555,500,NULL),(641,3,0,NULL),(641,9,7500,NULL),(641,11,15500,NULL),(641,12,7,NULL),(641,13,4,NULL),(641,14,8,NULL),(641,15,0,NULL),(641,19,1,NULL),(641,21,0,NULL),(641,37,105,NULL),(641,48,550,NULL),(641,49,0,NULL),(641,55,1154875,NULL),(641,70,NULL,0.128),(641,76,72500,NULL),(641,79,8250,NULL),(641,101,2,NULL),(641,102,7,NULL),(641,109,1,NULL),(641,110,1,NULL),(641,111,1,NULL),(641,113,1,NULL),(641,124,16777215,NULL),(641,129,1000,NULL),(641,136,1,NULL),(641,153,NULL,1.38e-007),(641,182,3336,NULL),(641,192,7,NULL),(641,208,0,NULL),(641,209,0,NULL),(641,210,21,NULL),(641,211,0,NULL),(641,217,395,NULL),(641,246,395,NULL),(641,263,6211,NULL),(641,265,6641,NULL),(641,267,NULL,0.5),(641,268,NULL,0.9),(641,269,NULL,0.65),(641,270,NULL,0.65),(641,271,1,NULL),(641,272,NULL,0.5),(641,273,NULL,0.6),(641,274,NULL,0.8),(641,277,2,NULL),(641,283,125,NULL),(641,479,2500000,NULL),(641,482,5625,NULL),(641,484,NULL,0.75),(641,500,5,NULL),(641,524,NULL,0.75),(641,525,NULL,0.75),(641,552,400,NULL),(641,561,NULL,7.5),(641,564,95,NULL),(641,600,1,NULL),(641,633,0,NULL),(641,661,1000,NULL),(641,662,NULL,0.5),(641,819,0,NULL),(641,820,8,NULL),(641,821,0,NULL),(641,822,0,NULL),(641,1132,400,NULL),(641,1137,3,NULL),(641,1154,3,NULL),(641,1178,100,NULL),(641,1179,NULL,0.01),(641,1196,NULL,0.01),(641,1198,NULL,0.01),(641,1199,100,NULL),(641,1200,100,NULL),(641,1224,NULL,0.5),(641,1259,NULL,0.82),(641,1261,NULL,0.63),(641,1262,NULL,0.79),(641,1271,125,NULL),(641,1281,1,NULL),(641,1547,3,NULL),(641,1555,500,NULL),(642,3,0,NULL),(642,9,6641,NULL),(642,11,20500,NULL),(642,12,7,NULL),(642,13,4,NULL),(642,14,8,NULL),(642,15,0,NULL),(642,19,1,NULL),(642,21,0,NULL),(642,37,94,NULL),(642,48,505,NULL),(642,49,0,NULL),(642,55,1154875,NULL),(642,70,NULL,0.136),(642,76,67500,NULL),(642,79,7500,NULL),(642,101,2,NULL),(642,102,8,NULL),(642,109,1,NULL),(642,110,1,NULL),(642,111,1,NULL),(642,113,1,NULL),(642,124,16777215,NULL),(642,129,999,NULL),(642,136,1,NULL),(642,153,NULL,1.38e-007),(642,182,3339,NULL),(642,192,7,NULL),(642,208,20,NULL),(642,209,0,NULL),(642,210,0,NULL),(642,211,0,NULL),(642,217,394,NULL),(642,246,394,NULL),(642,263,6211,NULL),(642,265,7500,NULL),(642,267,NULL,0.5),(642,268,NULL,0.8),(642,269,NULL,0.75),(642,270,NULL,0.65),(642,271,1,NULL),(642,272,NULL,0.5),(642,273,NULL,0.6),(642,274,NULL,0.8),(642,277,2,NULL),(642,283,75,NULL),(642,479,2500000,NULL),(642,482,7500,NULL),(642,484,NULL,0.75),(642,492,-10,NULL),(642,524,NULL,0.75),(642,525,NULL,0.75),(642,552,400,NULL),(642,564,95,NULL),(642,585,NULL,7.5),(642,600,1,NULL),(642,633,0,NULL),(642,661,1000,NULL),(642,662,NULL,0.5),(642,819,8,NULL),(642,820,0,NULL),(642,821,0,NULL),(642,822,0,NULL),(642,1132,400,NULL),(642,1137,3,NULL),(642,1154,3,NULL),(642,1178,100,NULL),(642,1179,NULL,0.01),(642,1196,NULL,0.01),(642,1198,NULL,0.01),(642,1199,100,NULL),(642,1200,100,NULL),(642,1224,NULL,0.5),(642,1259,NULL,0.82),(642,1261,NULL,0.63),(642,1262,NULL,0.79),(642,1271,75,NULL),(642,1281,1,NULL),(642,1547,3,NULL),(642,1555,500,NULL),(643,3,0,NULL),(643,9,6211,NULL),(643,11,16500,NULL),(643,12,8,NULL),(643,13,3,NULL),(643,14,8,NULL),(643,15,0,NULL),(643,19,1,NULL),(643,21,0,NULL),(643,37,105,NULL),(643,48,485,NULL),(643,49,0,NULL),(643,55,1087500,NULL),(643,70,NULL,0.128),(643,76,65000,NULL),(643,79,7500,NULL),(643,101,0,NULL),(643,102,7,NULL),(643,109,1,NULL),(643,110,1,NULL),(643,111,1,NULL),(643,113,1,NULL),(643,124,16777215,NULL),(643,129,1000,NULL),(643,136,1,NULL),(643,153,NULL,1.38e-007),(643,182,3339,NULL),(643,192,7,NULL),(643,208,17,NULL),(643,209,0,NULL),(643,210,0,NULL),(643,211,0,NULL),(643,217,394,NULL),(643,246,394,NULL),(643,263,5469,NULL),(643,265,6641,NULL),(643,267,NULL,0.5),(643,268,NULL,0.8),(643,269,NULL,0.75),(643,270,NULL,0.65),(643,271,1,NULL),(643,272,NULL,0.5),(643,273,NULL,0.6),(643,274,NULL,0.8),(643,277,1,NULL),(643,283,125,NULL),(643,479,2500000,NULL),(643,482,NULL,5312.5),(643,484,NULL,0.75),(643,492,-10,NULL),(643,524,NULL,0.75),(643,525,NULL,0.75),(643,552,370,NULL),(643,564,110,NULL),(643,585,-5,NULL),(643,600,1,NULL),(643,633,0,NULL),(643,661,1000,NULL),(643,662,NULL,0.5),(643,819,8,NULL),(643,820,0,NULL),(643,821,0,NULL),(643,822,0,NULL),(643,1132,400,NULL),(643,1137,3,NULL),(643,1154,3,NULL),(643,1178,100,NULL),(643,1179,NULL,0.01),(643,1196,NULL,0.01),(643,1198,NULL,0.01),(643,1199,100,NULL),(643,1200,100,NULL),(643,1224,NULL,0.5),(643,1259,NULL,0.82),(643,1261,NULL,0.5),(643,1262,NULL,0.82),(643,1271,125,NULL),(643,1281,1,NULL),(643,1547,3,NULL),(643,1555,500,NULL),(644,3,0,NULL),(644,9,6211,NULL),(644,11,12500,NULL),(644,12,7,NULL),(644,13,4,NULL),(644,14,8,NULL),(644,15,0,NULL),(644,19,1,NULL),(644,21,0,NULL),(644,37,130,NULL),(644,48,600,NULL),(644,49,0,NULL),(644,55,1087500,NULL),(644,70,NULL,0.116),(644,76,60000,NULL),(644,79,6750,NULL),(644,101,4,NULL),(644,102,4,NULL),(644,109,1,NULL),(644,110,1,NULL),(644,111,1,NULL),(644,113,1,NULL),(644,124,16777215,NULL),(644,129,1000,NULL),(644,136,1,NULL),(644,153,NULL,1.38e-007),(644,182,3337,NULL),(644,192,7,NULL),(644,208,0,NULL),(644,209,18,NULL),(644,210,0,NULL),(644,211,0,NULL),(644,217,397,NULL),(644,246,397,NULL),(644,263,6211,NULL),(644,265,5469,NULL),(644,267,NULL,0.4),(644,268,NULL,0.9),(644,269,NULL,0.75),(644,270,NULL,0.65),(644,271,1,NULL),(644,272,NULL,0.5),(644,273,NULL,0.6),(644,274,NULL,0.8),(644,277,1,NULL),(644,283,175,NULL),(644,479,2500000,NULL),(644,482,5000,NULL),(644,484,NULL,0.75),(644,490,-5,NULL),(644,518,-5,NULL),(644,524,NULL,0.75),(644,525,NULL,0.75),(644,552,320,NULL),(644,564,115,NULL),(644,600,1,NULL),(644,633,0,NULL),(644,661,1000,NULL),(644,662,NULL,0.5),(644,819,0,NULL),(644,820,0,NULL),(644,821,0,NULL),(644,822,10,NULL),(644,1132,400,NULL),(644,1137,3,NULL),(644,1154,3,NULL),(644,1178,100,NULL),(644,1179,NULL,0.01),(644,1196,NULL,0.01),(644,1198,NULL,0.01),(644,1199,100,NULL),(644,1200,100,NULL),(644,1224,NULL,0.5),(644,1259,NULL,0.82),(644,1261,NULL,0.63),(644,1262,NULL,0.79),(644,1271,125,NULL),(644,1281,1,NULL),(644,1547,3,NULL),(644,1555,500,NULL),(645,3,0,NULL),(645,9,6641,NULL),(645,11,9000,NULL),(645,12,7,NULL),(645,13,5,NULL),(645,14,6,NULL),(645,15,0,NULL),(645,19,1,NULL),(645,21,0,NULL),(645,37,99,NULL),(645,48,600,NULL),(645,49,0,NULL),(645,55,1087500,NULL),(645,70,NULL,0.132),(645,76,70000,NULL),(645,79,8250,NULL),(645,101,0,NULL),(645,102,6,NULL),(645,109,1,NULL),(645,110,1,NULL),(645,111,1,NULL),(645,113,1,NULL),(645,124,16777215,NULL),(645,129,1000,NULL),(645,136,1,NULL),(645,153,NULL,1.38e-007),(645,182,3336,NULL),(645,192,7,NULL),(645,208,0,NULL),(645,209,0,NULL),(645,210,22,NULL),(645,211,0,NULL),(645,217,395,NULL),(645,246,395,NULL),(645,263,5469,NULL),(645,265,6211,NULL),(645,267,NULL,0.5),(645,268,NULL,0.9),(645,269,NULL,0.65),(645,270,NULL,0.65),(645,271,1,NULL),(645,272,NULL,0.5),(645,273,NULL,0.6),(645,274,NULL,0.8),(645,277,1,NULL),(645,283,375,NULL),(645,479,2500000,NULL),(645,482,5000,NULL),(645,484,NULL,0.75),(645,500,5,NULL),(645,524,NULL,0.75),(645,525,NULL,0.75),(645,552,420,NULL),(645,561,10,NULL),(645,564,90,NULL),(645,600,1,NULL),(645,633,0,NULL),(645,661,1000,NULL),(645,662,NULL,0.5),(645,819,0,NULL),(645,820,7,NULL),(645,821,0,NULL),(645,822,0,NULL),(645,1132,400,NULL),(645,1137,3,NULL),(645,1154,3,NULL),(645,1178,100,NULL),(645,1179,NULL,0.01),(645,1196,NULL,0.01),(645,1198,NULL,0.01),(645,1199,100,NULL),(645,1200,100,NULL),(645,1224,NULL,0.5),(645,1259,NULL,0.76),(645,1261,NULL,0.71),(645,1262,NULL,0.79),(645,1271,125,NULL),(645,1281,1,NULL),(645,1547,3,NULL),(645,1555,500,NULL),(647,3,0,NULL),(647,9,6563,NULL),(647,11,28000,NULL),(647,12,8,NULL),(647,13,8,NULL),(647,14,8,NULL),(647,15,0,NULL),(647,19,1,NULL),(647,21,0,NULL),(647,37,250,NULL),(647,48,1500,NULL),(647,49,0,NULL),(647,55,468750,NULL),(647,70,NULL,0.155),(647,76,100000,NULL),(647,79,2500,NULL),(647,101,8,NULL),(647,102,8,NULL),(647,109,1,NULL),(647,110,1,NULL),(647,111,1,NULL),(647,113,1,NULL),(647,124,16777215,NULL),(647,129,1000,NULL),(647,136,1,NULL),(647,153,NULL,1.38e-007),(647,182,11078,NULL),(647,192,7,NULL),(647,208,15,NULL),(647,209,15,NULL),(647,210,15,NULL),(647,211,15,NULL),(647,217,395,NULL),(647,246,395,NULL),(647,263,14844,NULL),(647,265,7813,NULL),(647,267,NULL,0.4),(647,268,NULL,0.8),(647,269,NULL,0.65),(647,270,NULL,0.55),(647,271,1,NULL),(647,272,NULL,0.5),(647,273,NULL,0.6),(647,274,NULL,0.8),(647,277,1,NULL),(647,283,375,NULL),(647,479,2500000,NULL),(647,482,9375,NULL),(647,484,NULL,0.5),(647,524,NULL,0.75),(647,525,NULL,0.75),(647,552,400,NULL),(647,564,115,NULL),(647,600,1,NULL),(647,633,0,NULL),(647,661,1000,NULL),(647,662,NULL,0.5),(647,1132,400,NULL),(647,1137,3,NULL),(647,1154,3,NULL),(647,1178,100,NULL),(647,1179,NULL,0.01),(647,1196,NULL,0.01),(647,1198,NULL,0.01),(647,1199,100,NULL),(647,1200,100,NULL),(647,1224,NULL,0.5),(647,1259,NULL,0.82),(647,1261,NULL,0.82),(647,1262,NULL,0.82),(647,1271,125,NULL),(647,1281,1,NULL),(647,1547,3,NULL),(648,3,0,NULL),(648,9,860,NULL),(648,11,50,NULL),(648,12,2,NULL),(648,13,4,NULL),(648,14,1,NULL),(648,15,0,NULL),(648,19,1,NULL),(648,21,0,NULL),(648,37,120,NULL),(648,48,750,NULL),(648,49,0,NULL),(648,55,242500,NULL),(648,70,NULL,0.79),(648,76,42500,NULL),(648,79,9000,NULL),(648,101,0,NULL),(648,102,1,NULL),(648,109,1,NULL),(648,110,1,NULL),(648,111,1,NULL),(648,113,1,NULL),(648,124,16777215,NULL),(648,129,100,NULL),(648,136,1,NULL),(648,153,NULL,1.08911e-007),(648,182,3342,NULL),(648,192,2,NULL),(648,208,0,NULL),(648,209,0,NULL),(648,210,0,NULL),(648,211,11,NULL),(648,217,395,NULL),(648,246,395,NULL),(648,263,274,NULL),(648,265,743,NULL),(648,267,NULL,0.5),(648,268,NULL,0.9),(648,269,NULL,0.75),(648,270,NULL,0.55),(648,271,1,NULL),(648,272,NULL,0.5),(648,273,NULL,0.6),(648,274,NULL,0.8),(648,277,1,NULL),(648,283,0,NULL),(648,479,625000,NULL),(648,482,NULL,437.5),(648,484,NULL,0.75),(648,495,5,NULL),(648,524,NULL,0.75),(648,525,NULL,0.75),(648,552,220,NULL),(648,564,60,NULL),(648,600,NULL,1.5),(648,819,0,NULL),(648,820,0,NULL),(648,821,4,NULL),(648,822,0,NULL),(648,1132,400,NULL),(648,1137,3,NULL),(648,1154,3,NULL),(648,1178,100,NULL),(648,1179,NULL,0.01),(648,1196,NULL,0.01),(648,1198,NULL,0.01),(648,1199,100,NULL),(648,1200,100,NULL),(648,1224,NULL,0.75),(648,1259,0,NULL),(648,1261,NULL,0.63),(648,1262,NULL,0.25),(648,1271,0,NULL),(648,1281,1,NULL),(648,1547,2,NULL),(648,1555,50,NULL),(649,3,0,NULL),(649,9,1016,NULL),(649,11,80,NULL),(649,12,3,NULL),(649,13,6,NULL),(649,14,2,NULL),(649,15,0,NULL),(649,19,1,NULL),(649,21,0,NULL),(649,37,115,NULL),(649,48,1000,NULL),(649,49,0,NULL),(649,55,346250,NULL),(649,70,NULL,0.93),(649,76,45000,NULL),(649,79,9000,NULL),(649,101,0,NULL),(649,102,1,NULL),(649,109,1,NULL),(649,110,1,NULL),(649,111,1,NULL),(649,113,1,NULL),(649,124,16777215,NULL),(649,129,130,NULL),(649,136,1,NULL),(649,153,NULL,1.08911e-007),(649,182,3342,NULL),(649,192,2,NULL),(649,208,0,NULL),(649,209,0,NULL),(649,210,0,NULL),(649,211,13,NULL),(649,217,395,NULL),(649,246,395,NULL),(649,263,548,NULL),(649,265,1016,NULL),(649,267,NULL,0.5),(649,268,NULL,0.9),(649,269,NULL,0.75),(649,270,NULL,0.55),(649,271,1,NULL),(649,272,NULL,0.5),(649,273,NULL,0.6),(649,274,NULL,0.8),(649,277,3,NULL),(649,283,0,NULL),(649,479,625000,NULL),(649,482,625,NULL),(649,484,NULL,0.75),(649,495,5,NULL),(649,524,NULL,0.75),(649,525,NULL,0.75),(649,552,250,NULL),(649,564,50,NULL),(649,600,NULL,1.5),(649,819,0,NULL),(649,820,0,NULL),(649,821,5,NULL),(649,822,0,NULL),(649,1132,400,NULL),(649,1137,3,NULL),(649,1154,3,NULL),(649,1178,100,NULL),(649,1179,NULL,0.01),(649,1196,NULL,0.01),(649,1198,NULL,0.01),(649,1199,100,NULL),(649,1200,100,NULL),(649,1224,NULL,0.75),(649,1259,NULL,0.25),(649,1261,NULL,0.76),(649,1262,NULL,0.5),(649,1271,0,NULL),(649,1281,1,NULL),(649,1547,2,NULL),(649,1555,50,NULL),(650,3,0,NULL),(650,9,781,NULL),(650,11,45,NULL),(650,12,2,NULL),(650,13,2,NULL),(650,14,1,NULL),(650,15,0,NULL),(650,19,1,NULL),(650,21,0,NULL),(650,37,125,NULL),(650,48,600,NULL),(650,49,0,NULL),(650,55,207500,NULL),(650,70,1,NULL),(650,76,37500,NULL),(650,79,8250,NULL),(650,101,0,NULL),(650,102,1,NULL),(650,109,1,NULL),(650,110,1,NULL),(650,111,1,NULL),(650,113,1,NULL),(650,124,16777215,NULL),(650,129,80,NULL),(650,136,1,NULL),(650,153,NULL,1.08911e-007),(650,182,3340,NULL),(650,192,2,NULL),(650,208,0,NULL),(650,209,0,NULL),(650,210,10,NULL),(650,211,0,NULL),(650,217,395,NULL),(650,246,395,NULL),(650,263,79,NULL),(650,265,781,NULL),(650,267,NULL,0.5),(650,268,NULL,0.9),(650,269,NULL,0.65),(650,270,NULL,0.65),(650,271,1,NULL),(650,272,NULL,0.5),(650,273,NULL,0.6),(650,274,NULL,0.8),(650,277,1,NULL),(650,283,0,NULL),(650,479,625000,NULL),(650,482,375,NULL),(650,484,NULL,0.75),(650,496,5,NULL),(650,524,NULL,0.75),(650,525,NULL,0.75),(650,552,190,NULL),(650,564,85,NULL),(650,600,NULL,1.5),(650,819,0,NULL),(650,820,4,NULL),(650,821,0,NULL),(650,822,0,NULL),(650,1132,400,NULL),(650,1137,3,NULL),(650,1154,3,NULL),(650,1178,100,NULL),(650,1179,NULL,0.01),(650,1196,NULL,0.01),(650,1198,NULL,0.01),(650,1199,100,NULL),(650,1200,100,NULL),(650,1224,NULL,0.75),(650,1259,0,NULL),(650,1261,NULL,0.25),(650,1262,NULL,0.25),(650,1271,0,NULL),(650,1281,1,NULL),(650,1547,2,NULL),(650,1555,50,NULL),(651,3,0,NULL),(651,9,1016,NULL),(651,11,60,NULL),(651,12,3,NULL),(651,13,3,NULL),(651,14,1,NULL),(651,15,0,NULL),(651,19,1,NULL),(651,21,0,NULL),(651,37,120,NULL),(651,48,650,NULL),(651,49,0,NULL),(651,55,277500,NULL),(651,70,1,NULL),(651,76,40000,NULL),(651,79,6750,NULL),(651,101,0,NULL),(651,102,1,NULL),(651,109,1,NULL),(651,110,1,NULL),(651,111,1,NULL),(651,113,1,NULL),(651,124,16777215,NULL),(651,129,100,NULL),(651,136,1,NULL),(651,153,NULL,1.08911e-007),(651,182,3341,NULL),(651,192,2,NULL),(651,208,0,NULL),(651,209,7,NULL),(651,210,0,NULL),(651,211,0,NULL),(651,217,397,NULL),(651,246,397,NULL),(651,263,274,NULL),(651,265,1016,NULL),(651,267,NULL,0.4),(651,268,NULL,0.9),(651,269,NULL,0.75),(651,270,NULL,0.65),(651,271,1,NULL),(651,272,NULL,0.5),(651,273,NULL,0.6),(651,274,NULL,0.8),(651,277,2,NULL),(651,283,0,NULL),(651,479,625000,NULL),(651,482,500,NULL),(651,484,NULL,0.75),(651,493,5,NULL),(651,524,NULL,0.75),(651,525,NULL,0.75),(651,552,180,NULL),(651,564,90,NULL),(651,600,NULL,1.5),(651,819,0,NULL),(651,820,0,NULL),(651,821,0,NULL),(651,822,5,NULL),(651,1132,400,NULL),(651,1137,3,NULL),(651,1154,3,NULL),(651,1178,100,NULL),(651,1179,NULL,0.01),(651,1196,NULL,0.01),(651,1198,NULL,0.01),(651,1199,100,NULL),(651,1200,100,NULL),(651,1224,NULL,0.75),(651,1259,0,NULL),(651,1261,NULL,0.5),(651,1262,NULL,0.5),(651,1271,0,NULL),(651,1281,1,NULL),(651,1547,2,NULL),(651,1555,50,NULL),(652,3,0,NULL),(652,9,1173,NULL),(652,11,80,NULL),(652,12,4,NULL),(652,13,5,NULL),(652,14,2,NULL),(652,15,0,NULL),(652,19,1,NULL),(652,21,0,NULL),(652,37,110,NULL),(652,48,750,NULL),(652,49,0,NULL),(652,55,312500,NULL),(652,70,1,NULL),(652,76,45000,NULL),(652,79,6750,NULL),(652,101,0,NULL),(652,102,1,NULL),(652,109,1,NULL),(652,110,1,NULL),(652,111,1,NULL),(652,113,1,NULL),(652,124,16777215,NULL),(652,129,150,NULL),(652,136,1,NULL),(652,153,NULL,1.08911e-007),(652,182,3341,NULL),(652,192,2,NULL),(652,208,0,NULL),(652,209,8,NULL),(652,210,0,NULL),(652,211,0,NULL),(652,217,397,NULL),(652,246,397,NULL),(652,263,391,NULL),(652,265,1094,NULL),(652,267,NULL,0.4),(652,268,NULL,0.9),(652,269,NULL,0.75),(652,270,NULL,0.65),(652,271,1,NULL),(652,272,NULL,0.5),(652,273,NULL,0.6),(652,274,NULL,0.8),(652,277,4,NULL),(652,283,0,NULL),(652,479,625000,NULL),(652,482,NULL,562.5),(652,484,NULL,0.75),(652,493,5,NULL),(652,524,NULL,0.75),(652,525,NULL,0.75),(652,552,200,NULL),(652,564,85,NULL),(652,600,NULL,1.5),(652,819,0,NULL),(652,820,0,NULL),(652,821,0,NULL),(652,822,6,NULL),(652,1132,400,NULL),(652,1137,3,NULL),(652,1154,3,NULL),(652,1178,100,NULL),(652,1179,NULL,0.01),(652,1196,NULL,0.01),(652,1198,NULL,0.01),(652,1199,100,NULL),(652,1200,100,NULL),(652,1224,NULL,0.75),(652,1259,NULL,0.25),(652,1261,NULL,0.71),(652,1262,NULL,0.63),(652,1271,0,NULL),(652,1281,1,NULL),(652,1547,2,NULL),(652,1555,50,NULL),(653,3,0,NULL),(653,9,781,NULL),(653,11,45,NULL),(653,12,2,NULL),(653,13,2,NULL),(653,14,1,NULL),(653,15,0,NULL),(653,19,1,NULL),(653,21,0,NULL),(653,37,125,NULL),(653,48,600,NULL),(653,49,0,NULL),(653,55,207500,NULL),(653,70,1,NULL),(653,76,35000,NULL),(653,79,6750,NULL),(653,101,0,NULL),(653,102,1,NULL),(653,109,1,NULL),(653,110,1,NULL),(653,111,1,NULL),(653,113,1,NULL),(653,124,16777215,NULL),(653,129,80,NULL),(653,136,1,NULL),(653,153,NULL,1.08911e-007),(653,182,3341,NULL),(653,192,2,NULL),(653,208,0,NULL),(653,209,7,NULL),(653,210,0,NULL),(653,211,0,NULL),(653,217,397,NULL),(653,246,397,NULL),(653,263,79,NULL),(653,265,743,NULL),(653,267,NULL,0.4),(653,268,NULL,0.9),(653,269,NULL,0.75),(653,270,NULL,0.65),(653,271,1,NULL),(653,272,NULL,0.5),(653,273,NULL,0.6),(653,274,NULL,0.8),(653,277,1,NULL),(653,283,0,NULL),(653,479,625000,NULL),(653,482,375,NULL),(653,484,NULL,0.75),(653,493,5,NULL),(653,524,NULL,0.75),(653,525,NULL,0.75),(653,552,160,NULL),(653,564,95,NULL),(653,600,NULL,1.5),(653,819,0,NULL),(653,820,0,NULL),(653,821,0,NULL),(653,822,4,NULL),(653,1132,400,NULL),(653,1137,3,NULL),(653,1154,3,NULL),(653,1178,100,NULL),(653,1179,NULL,0.01),(653,1196,NULL,0.01),(653,1198,NULL,0.01),(653,1199,100,NULL),(653,1200,100,NULL),(653,1224,NULL,0.75),(653,1259,0,NULL),(653,1261,NULL,0.25),(653,1262,NULL,0.25),(653,1271,0,NULL),(653,1281,1,NULL),(653,1547,2,NULL),(653,1555,50,NULL),(654,3,0,NULL),(654,9,899,NULL),(654,11,55,NULL),(654,12,2,NULL),(654,13,4,NULL),(654,14,1,NULL),(654,15,0,NULL),(654,19,1,NULL),(654,21,0,NULL),(654,37,120,NULL),(654,48,750,NULL),(654,49,0,NULL),(654,55,242500,NULL),(654,70,1,NULL),(654,76,40000,NULL),(654,79,8250,NULL),(654,101,0,NULL),(654,102,1,NULL),(654,109,1,NULL),(654,110,1,NULL),(654,111,1,NULL),(654,113,1,NULL),(654,124,16777215,NULL),(654,129,100,NULL),(654,136,1,NULL),(654,153,NULL,1.08911e-007),(654,182,3340,NULL),(654,192,2,NULL),(654,208,0,NULL),(654,209,0,NULL),(654,210,10,NULL),(654,211,0,NULL),(654,217,395,NULL),(654,246,395,NULL),(654,263,156,NULL),(654,265,860,NULL),(654,267,NULL,0.5),(654,268,NULL,0.9),(654,269,NULL,0.65),(654,270,NULL,0.65),(654,271,1,NULL),(654,272,NULL,0.5),(654,273,NULL,0.6),(654,274,NULL,0.8),(654,277,2,NULL),(654,283,0,NULL),(654,479,625000,NULL),(654,482,NULL,437.5),(654,484,NULL,0.75),(654,496,5,NULL),(654,524,NULL,0.75),(654,525,NULL,0.75),(654,552,210,NULL),(654,564,65,NULL),(654,600,NULL,1.5),(654,819,0,NULL),(654,820,4,NULL),(654,821,0,NULL),(654,822,0,NULL),(654,1132,400,NULL),(654,1137,3,NULL),(654,1154,3,NULL),(654,1178,100,NULL),(654,1179,NULL,0.01),(654,1196,NULL,0.01),(654,1198,NULL,0.01),(654,1199,100,NULL),(654,1200,100,NULL),(654,1224,NULL,0.75),(654,1259,0,NULL),(654,1261,NULL,0.63),(654,1262,NULL,0.25),(654,1271,0,NULL),(654,1281,1,NULL),(654,1547,2,NULL),(654,1555,50,NULL),(655,3,0,NULL),(655,9,1329,NULL),(655,11,75,NULL),(655,12,3,NULL),(655,13,3,NULL),(655,14,2,NULL),(655,15,0,NULL),(655,19,1,NULL),(655,21,0,NULL),(655,37,115,NULL),(655,48,750,NULL),(655,49,0,NULL),(655,55,381250,NULL),(655,70,1,NULL),(655,76,50000,NULL),(655,79,8250,NULL),(655,101,0,NULL),(655,102,1,NULL),(655,109,1,NULL),(655,110,1,NULL),(655,111,1,NULL),(655,113,1,NULL),(655,124,16777215,NULL),(655,129,150,NULL),(655,136,1,NULL),(655,153,NULL,1.08911e-007),(655,182,3340,NULL),(655,192,2,NULL),(655,208,0,NULL),(655,209,0,NULL),(655,210,11,NULL),(655,211,0,NULL),(655,217,395,NULL),(655,246,395,NULL),(655,263,274,NULL),(655,265,1094,NULL),(655,267,NULL,0.5),(655,268,NULL,0.9),(655,269,NULL,0.65),(655,270,NULL,0.65),(655,271,1,NULL),(655,272,NULL,0.5),(655,273,NULL,0.6),(655,274,NULL,0.8),(655,277,3,NULL),(655,283,0,NULL),(655,479,625000,NULL),(655,482,NULL,687.5),(655,484,NULL,0.75),(655,496,5,NULL),(655,524,NULL,0.75),(655,525,NULL,0.75),(655,552,200,NULL),(655,564,70,NULL),(655,600,NULL,1.5),(655,819,0,NULL),(655,820,5,NULL),(655,821,0,NULL),(655,822,0,NULL),(655,1132,400,NULL),(655,1137,3,NULL),(655,1154,3,NULL),(655,1178,100,NULL),(655,1179,NULL,0.01),(655,1196,NULL,0.01),(655,1198,NULL,0.01),(655,1199,100,NULL),(655,1200,100,NULL),(655,1224,NULL,0.75),(655,1259,NULL,0.25),(655,1261,NULL,0.5),(655,1262,NULL,0.5),(655,1271,0,NULL),(655,1281,1,NULL),(655,1547,2,NULL),(655,1555,50,NULL),(656,3,0,NULL),(656,9,1173,NULL),(656,11,70,NULL),(656,12,3,NULL),(656,13,4,NULL),(656,14,1,NULL),(656,15,0,NULL),(656,19,1,NULL),(656,21,0,NULL),(656,37,120,NULL),(656,48,750,NULL),(656,49,0,NULL),(656,55,277500,NULL),(656,70,1,NULL),(656,76,47500,NULL),(656,79,8250,NULL),(656,101,0,NULL),(656,102,1,NULL),(656,109,1,NULL),(656,110,1,NULL),(656,111,1,NULL),(656,113,1,NULL),(656,124,16777215,NULL),(656,129,120,NULL),(656,136,1,NULL),(656,153,NULL,1.08911e-007),(656,182,3340,NULL),(656,192,2,NULL),(656,208,0,NULL),(656,209,0,NULL),(656,210,11,NULL),(656,211,0,NULL),(656,217,395,NULL),(656,246,395,NULL),(656,263,235,NULL),(656,265,1016,NULL),(656,267,NULL,0.5),(656,268,NULL,0.9),(656,269,NULL,0.65),(656,270,NULL,0.65),(656,271,1,NULL),(656,272,NULL,0.5),(656,273,NULL,0.6),(656,274,NULL,0.8),(656,277,4,NULL),(656,283,0,NULL),(656,479,625000,NULL),(656,482,500,NULL),(656,484,NULL,0.75),(656,496,5,NULL),(656,524,NULL,0.75),(656,525,NULL,0.75),(656,552,220,NULL),(656,564,65,NULL),(656,600,NULL,1.5),(656,819,0,NULL),(656,820,5,NULL),(656,821,0,NULL),(656,822,0,NULL),(656,1132,400,NULL),(656,1137,3,NULL),(656,1154,3,NULL),(656,1178,100,NULL),(656,1179,NULL,0.01),(656,1196,NULL,0.01),(656,1198,NULL,0.01),(656,1199,100,NULL),(656,1200,100,NULL),(656,1224,NULL,0.75),(656,1259,0,NULL),(656,1261,NULL,0.63),(656,1262,NULL,0.5),(656,1271,0,NULL),(656,1281,1,NULL),(656,1547,2,NULL),(656,1555,50,NULL),(657,3,0,NULL),(657,9,1485,NULL),(657,11,85,NULL),(657,12,5,NULL),(657,13,5,NULL),(657,14,2,NULL),(657,15,0,NULL),(657,19,1,NULL),(657,21,0,NULL),(657,37,110,NULL),(657,48,850,NULL),(657,49,0,NULL),(657,55,416250,NULL),(657,70,1,NULL),(657,76,52500,NULL),(657,79,8250,NULL),(657,101,0,NULL),(657,102,1,NULL),(657,109,1,NULL),(657,110,1,NULL),(657,111,1,NULL),(657,113,1,NULL),(657,124,16777215,NULL),(657,129,200,NULL),(657,136,1,NULL),(657,153,NULL,1.08911e-007),(657,182,3340,NULL),(657,192,2,NULL),(657,208,0,NULL),(657,209,0,NULL),(657,210,12,NULL),(657,211,0,NULL),(657,217,395,NULL),(657,246,395,NULL),(657,263,469,NULL),(657,265,1368,NULL),(657,267,NULL,0.5),(657,268,NULL,0.9),(657,269,NULL,0.65),(657,270,NULL,0.65),(657,271,1,NULL),(657,272,NULL,0.5),(657,273,NULL,0.6),(657,274,NULL,0.8),(657,277,5,NULL),(657,283,0,NULL),(657,479,625000,NULL),(657,482,750,NULL),(657,484,NULL,0.75),(657,496,5,NULL),(657,524,NULL,0.75),(657,525,NULL,0.75),(657,552,230,NULL),(657,564,55,NULL),(657,600,NULL,1.5),(657,819,0,NULL),(657,820,6,NULL),(657,821,0,NULL),(657,822,0,NULL),(657,1132,400,NULL),(657,1137,3,NULL),(657,1154,3,NULL),(657,1178,100,NULL),(657,1179,NULL,0.01),(657,1196,NULL,0.01),(657,1198,NULL,0.01),(657,1199,100,NULL),(657,1200,100,NULL),(657,1224,NULL,0.75),(657,1259,NULL,0.25),(657,1261,NULL,0.71),(657,1262,NULL,0.71),(657,1271,0,NULL),(657,1281,1,NULL),(657,1547,2,NULL),(657,1555,50,NULL),(658,3,0,NULL),(658,9,625,NULL),(658,11,150,NULL),(658,12,3,NULL),(658,13,5,NULL),(658,14,2,NULL),(658,15,0,NULL),(658,19,1,NULL),(658,21,0,NULL),(658,37,220,NULL),(658,48,800,NULL),(658,49,0,NULL),(658,55,187500,NULL),(658,70,1,NULL),(658,76,60000,NULL),(658,79,2500,NULL),(658,101,0,NULL),(658,102,1,NULL),(658,109,1,NULL),(658,110,1,NULL),(658,111,1,NULL),(658,113,1,NULL),(658,124,16777215,NULL),(658,129,100,NULL),(658,136,1,NULL),(658,153,NULL,1.08911e-007),(658,182,11075,NULL),(658,192,2,NULL),(658,208,10,NULL),(658,209,10,NULL),(658,210,10,NULL),(658,211,10,NULL),(658,217,396,NULL),(658,246,396,NULL),(658,263,1173,NULL),(658,265,1173,NULL),(658,267,NULL,0.4),(658,268,NULL,0.8),(658,269,NULL,0.65),(658,270,NULL,0.55),(658,271,1,NULL),(658,272,NULL,0.5),(658,273,NULL,0.6),(658,274,NULL,0.8),(658,277,5,NULL),(658,283,0,NULL),(658,479,625000,NULL),(658,482,1250,NULL),(658,484,NULL,0.75),(658,524,NULL,0.75),(658,525,NULL,0.75),(658,552,160,NULL),(658,564,95,NULL),(658,600,NULL,1.5),(658,1132,400,NULL),(658,1137,3,NULL),(658,1154,3,NULL),(658,1178,100,NULL),(658,1179,NULL,0.01),(658,1196,NULL,0.01),(658,1198,NULL,0.01),(658,1199,100,NULL),(658,1200,100,NULL),(658,1224,NULL,0.75),(658,1259,NULL,0.25),(658,1261,NULL,0.71),(658,1262,NULL,0.5),(658,1271,0,NULL),(658,1281,1,NULL),(658,1547,2,NULL),(659,3,0,NULL),(659,9,13,NULL),(659,11,35,NULL),(659,15,0,NULL),(659,19,1,NULL),(659,21,0,NULL),(659,37,50,NULL),(659,48,100,NULL),(659,49,0,NULL),(659,55,281250,NULL),(659,70,2,NULL),(659,76,15000,NULL),(659,79,2500,NULL),(659,101,0,NULL),(659,102,0,NULL),(659,109,1,NULL),(659,110,1,NULL),(659,111,1,NULL),(659,113,1,NULL),(659,129,1,NULL),(659,136,1,NULL),(659,153,NULL,2.1645e-006),(659,192,2,NULL),(659,208,0,NULL),(659,209,3,NULL),(659,210,0,NULL),(659,211,0,NULL),(659,217,395,NULL),(659,246,395,NULL),(659,263,63,NULL),(659,265,156,NULL),(659,267,NULL,0.4),(659,268,NULL,0.9),(659,269,NULL,0.75),(659,270,NULL,0.65),(659,271,1,NULL),(659,272,NULL,0.5),(659,273,NULL,0.6),(659,274,NULL,0.8),(659,283,0,NULL),(659,479,625000,NULL),(659,482,NULL,187.5),(659,484,NULL,0.5),(659,524,NULL,0.75),(659,525,NULL,0.75),(659,552,50,NULL),(659,1178,100,NULL),(659,1179,NULL,0.01),(659,1196,NULL,0.01),(659,1198,NULL,0.01),(659,1199,100,NULL),(659,1200,100,NULL),(659,1224,1,NULL),(659,1271,0,NULL),(659,1281,1,NULL),(660,3,0,NULL),(660,9,13,NULL),(660,11,35,NULL),(660,15,0,NULL),(660,19,1,NULL),(660,21,0,NULL),(660,37,50,NULL),(660,48,100,NULL),(660,49,0,NULL),(660,55,281250,NULL),(660,70,2,NULL),(660,76,15000,NULL),(660,79,2500,NULL),(660,101,0,NULL),(660,102,0,NULL),(660,109,1,NULL),(660,110,1,NULL),(660,111,1,NULL),(660,113,1,NULL),(660,129,1,NULL),(660,136,1,NULL),(660,153,NULL,2.1645e-006),(660,192,2,NULL),(660,208,0,NULL),(660,209,3,NULL),(660,210,0,NULL),(660,211,0,NULL),(660,217,395,NULL),(660,246,395,NULL),(660,263,63,NULL),(660,265,156,NULL),(660,267,NULL,0.4),(660,268,NULL,0.9),(660,269,NULL,0.75),(660,270,NULL,0.65),(660,271,1,NULL),(660,272,NULL,0.5),(660,273,NULL,0.6),(660,274,NULL,0.8),(660,283,0,NULL),(660,479,625000,NULL),(660,482,NULL,187.5),(660,484,NULL,0.5),(660,524,NULL,0.75),(660,525,NULL,0.75),(660,552,50,NULL),(660,1178,100,NULL),(660,1179,NULL,0.01),(660,1196,NULL,0.01),(660,1198,NULL,0.01),(660,1199,100,NULL),(660,1200,100,NULL),(660,1224,1,NULL),(660,1271,0,NULL),(660,1281,1,NULL),(661,3,0,NULL),(661,9,13,NULL),(661,11,35,NULL),(661,15,0,NULL),(661,19,1,NULL),(661,21,0,NULL),(661,37,50,NULL),(661,48,100,NULL),(661,49,0,NULL),(661,55,281250,NULL),(661,70,2,NULL),(661,76,15000,NULL),(661,79,2500,NULL),(661,101,0,NULL),(661,102,0,NULL),(661,109,1,NULL),(661,110,1,NULL),(661,111,1,NULL),(661,113,1,NULL),(661,129,1,NULL),(661,136,1,NULL),(661,153,NULL,2.1645e-006),(661,192,2,NULL),(661,208,0,NULL),(661,209,3,NULL),(661,210,0,NULL),(661,211,0,NULL),(661,217,395,NULL),(661,246,395,NULL),(661,263,63,NULL),(661,265,156,NULL),(661,267,NULL,0.4),(661,268,NULL,0.9),(661,269,NULL,0.75),(661,270,NULL,0.65),(661,271,1,NULL),(661,272,NULL,0.5),(661,273,NULL,0.6),(661,274,NULL,0.8),(661,283,0,NULL),(661,479,625000,NULL),(661,482,NULL,187.5),(661,484,NULL,0.5),(661,524,NULL,0.75),(661,525,NULL,0.75),(661,552,50,NULL),(661,1178,100,NULL),(661,1179,NULL,0.01),(661,1196,NULL,0.01),(661,1198,NULL,0.01),(661,1199,100,NULL),(661,1200,100,NULL),(661,1224,1,NULL),(661,1271,0,NULL),(661,1281,1,NULL),(662,3,0,NULL),(662,9,13,NULL),(662,11,35,NULL),(662,15,0,NULL),(662,19,1,NULL),(662,21,0,NULL),(662,37,50,NULL),(662,48,100,NULL),(662,49,0,NULL),(662,55,281250,NULL),(662,70,2,NULL),(662,76,15000,NULL),(662,79,2500,NULL),(662,101,0,NULL),(662,102,0,NULL),(662,109,1,NULL),(662,110,1,NULL),(662,111,1,NULL),(662,113,1,NULL),(662,129,1,NULL),(662,136,1,NULL),(662,153,NULL,2.1645e-006),(662,192,2,NULL),(662,208,0,NULL),(662,209,3,NULL),(662,210,0,NULL),(662,211,0,NULL),(662,217,395,NULL),(662,246,395,NULL),(662,263,63,NULL),(662,265,156,NULL),(662,267,NULL,0.4),(662,268,NULL,0.9),(662,269,NULL,0.75),(662,270,NULL,0.65),(662,271,1,NULL),(662,272,NULL,0.5),(662,273,NULL,0.6),(662,274,NULL,0.8),(662,283,0,NULL),(662,479,625000,NULL),(662,482,NULL,187.5),(662,484,NULL,0.5),(662,524,NULL,0.75),(662,525,NULL,0.75),(662,552,50,NULL),(662,1178,100,NULL),(662,1179,NULL,0.01),(662,1196,NULL,0.01),(662,1198,NULL,0.01),(662,1199,100,NULL),(662,1200,100,NULL),(662,1224,1,NULL),(662,1271,0,NULL),(662,1281,1,NULL),(663,3,0,NULL),(663,9,13,NULL),(663,11,35,NULL),(663,15,0,NULL),(663,19,1,NULL),(663,21,0,NULL),(663,37,50,NULL),(663,48,100,NULL),(663,49,0,NULL),(663,55,281250,NULL),(663,70,2,NULL),(663,76,15000,NULL),(663,79,2500,NULL),(663,101,0,NULL),(663,102,0,NULL),(663,109,1,NULL),(663,110,1,NULL),(663,111,1,NULL),(663,113,1,NULL),(663,129,1,NULL),(663,136,1,NULL),(663,153,NULL,2.1645e-006),(663,192,2,NULL),(663,208,0,NULL),(663,209,3,NULL),(663,210,0,NULL),(663,211,0,NULL),(663,217,395,NULL),(663,246,395,NULL),(663,263,63,NULL),(663,265,156,NULL),(663,267,NULL,0.4),(663,268,NULL,0.9),(663,269,NULL,0.75),(663,270,NULL,0.65),(663,271,1,NULL),(663,272,NULL,0.5),(663,273,NULL,0.6),(663,274,NULL,0.8),(663,283,0,NULL),(663,479,625000,NULL),(663,482,NULL,187.5),(663,484,NULL,0.5),(663,524,NULL,0.75),(663,525,NULL,0.75),(663,552,50,NULL),(663,1178,100,NULL),(663,1179,NULL,0.01),(663,1196,NULL,0.01),(663,1198,NULL,0.01),(663,1199,100,NULL),(663,1200,100,NULL),(663,1224,1,NULL),(663,1271,0,NULL),(663,1281,1,NULL),(664,3,0,NULL),(664,9,13,NULL),(664,11,35,NULL),(664,15,0,NULL),(664,19,1,NULL),(664,21,0,NULL),(664,37,50,NULL),(664,48,100,NULL),(664,49,0,NULL),(664,55,281250,NULL),(664,70,2,NULL),(664,76,15000,NULL),(664,79,2500,NULL),(664,101,0,NULL),(664,102,0,NULL),(664,109,1,NULL),(664,110,1,NULL),(664,111,1,NULL),(664,113,1,NULL),(664,129,1,NULL),(664,136,1,NULL),(664,153,NULL,2.1645e-006),(664,192,2,NULL),(664,208,0,NULL),(664,209,3,NULL),(664,210,0,NULL),(664,211,0,NULL),(664,217,395,NULL),(664,246,395,NULL),(664,263,63,NULL),(664,265,156,NULL),(664,267,NULL,0.4),(664,268,NULL,0.9),(664,269,NULL,0.75),(664,270,NULL,0.65),(664,271,1,NULL),(664,272,NULL,0.5),(664,273,NULL,0.6),(664,274,NULL,0.8),(664,283,0,NULL),(664,479,625000,NULL),(664,482,NULL,187.5),(664,484,NULL,0.5),(664,524,NULL,0.75),(664,525,NULL,0.75),(664,552,50,NULL),(664,1178,100,NULL),(664,1179,NULL,0.01),(664,1196,NULL,0.01),(664,1198,NULL,0.01),(664,1199,100,NULL),(664,1200,100,NULL),(664,1224,1,NULL),(664,1271,0,NULL),(664,1281,1,NULL),(665,3,0,NULL),(665,9,13,NULL),(665,11,15,NULL),(665,15,0,NULL),(665,19,1,NULL),(665,21,0,NULL),(665,37,50,NULL),(665,48,100,NULL),(665,49,0,NULL),(665,55,187500,NULL),(665,70,2,NULL),(665,76,15000,NULL),(665,79,2500,NULL),(665,101,0,NULL),(665,102,0,NULL),(665,109,1,NULL),(665,110,1,NULL),(665,111,1,NULL),(665,113,1,NULL),(665,129,1,NULL),(665,136,1,NULL),(665,153,NULL,2.1645e-006),(665,192,2,NULL),(665,208,0,NULL),(665,209,3,NULL),(665,210,0,NULL),(665,211,0,NULL),(665,217,395,NULL),(665,246,395,NULL),(665,263,63,NULL),(665,265,156,NULL),(665,267,NULL,0.4),(665,268,NULL,0.9),(665,269,NULL,0.75),(665,270,NULL,0.65),(665,271,1,NULL),(665,272,NULL,0.5),(665,273,NULL,0.6),(665,274,NULL,0.8),(665,283,0,NULL),(665,479,625000,NULL),(665,482,125,NULL),(665,484,NULL,0.5),(665,524,NULL,0.75),(665,525,NULL,0.75),(665,552,50,NULL),(665,1178,100,NULL),(665,1179,NULL,0.01),(665,1196,NULL,0.01),(665,1198,NULL,0.01),(665,1199,100,NULL),(665,1200,100,NULL),(665,1224,1,NULL),(665,1271,0,NULL),(665,1281,1,NULL),(666,3,0,NULL),(666,9,13,NULL),(666,11,15,NULL),(666,15,0,NULL),(666,19,1,NULL),(666,21,0,NULL),(666,37,50,NULL),(666,48,100,NULL),(666,49,0,NULL),(666,55,281250,NULL),(666,70,2,NULL),(666,76,15000,NULL),(666,79,2500,NULL),(666,101,0,NULL),(666,102,0,NULL),(666,109,1,NULL),(666,110,1,NULL),(666,111,1,NULL),(666,113,1,NULL),(666,129,1,NULL),(666,136,1,NULL),(666,153,NULL,2.1645e-006),(666,192,2,NULL),(666,208,0,NULL),(666,209,3,NULL),(666,210,0,NULL),(666,211,0,NULL),(666,217,395,NULL),(666,246,395,NULL),(666,263,63,NULL),(666,265,156,NULL),(666,267,NULL,0.4),(666,268,NULL,0.9),(666,269,NULL,0.75),(666,270,NULL,0.65),(666,271,1,NULL),(666,272,NULL,0.5),(666,273,NULL,0.6),(666,274,NULL,0.8),(666,283,0,NULL),(666,479,625000,NULL),(666,482,NULL,187.5),(666,484,NULL,0.5),(666,524,NULL,0.75),(666,525,NULL,0.75),(666,552,50,NULL),(666,1178,100,NULL),(666,1179,NULL,0.01),(666,1196,NULL,0.01),(666,1198,NULL,0.01),(666,1199,100,NULL),(666,1200,100,NULL),(666,1224,1,NULL),(666,1271,0,NULL),(666,1281,1,NULL),(667,3,0,NULL),(667,9,13,NULL),(667,11,20,NULL),(667,15,0,NULL),(667,19,1,NULL),(667,21,0,NULL),(667,37,50,NULL),(667,48,100,NULL),(667,49,0,NULL),(667,55,281250,NULL),(667,70,2,NULL),(667,76,15000,NULL),(667,79,2500,NULL),(667,101,0,NULL),(667,102,0,NULL),(667,109,1,NULL),(667,110,1,NULL),(667,111,1,NULL),(667,113,1,NULL),(667,129,1,NULL),(667,136,1,NULL),(667,153,NULL,2.1645e-006),(667,192,2,NULL),(667,208,0,NULL),(667,209,3,NULL),(667,210,0,NULL),(667,211,0,NULL),(667,217,395,NULL),(667,246,395,NULL),(667,263,63,NULL),(667,265,156,NULL),(667,267,NULL,0.4),(667,268,NULL,0.9),(667,269,NULL,0.75),(667,270,NULL,0.65),(667,271,1,NULL),(667,272,NULL,0.5),(667,273,NULL,0.6),(667,274,NULL,0.8),(667,283,0,NULL),(667,479,625000,NULL),(667,482,NULL,187.5),(667,484,NULL,0.5),(667,524,NULL,0.75),(667,525,NULL,0.75),(667,552,50,NULL),(667,1178,100,NULL),(667,1179,NULL,0.01),(667,1196,NULL,0.01),(667,1198,NULL,0.01),(667,1199,100,NULL),(667,1200,100,NULL),(667,1224,1,NULL),(667,1271,0,NULL),(667,1281,1,NULL),(668,3,0,NULL),(668,9,13,NULL),(668,11,35,NULL),(668,15,0,NULL),(668,19,1,NULL),(668,21,0,NULL),(668,37,50,NULL),(668,48,100,NULL),(668,49,0,NULL),(668,55,281250,NULL),(668,70,2,NULL),(668,76,15000,NULL),(668,79,2500,NULL),(668,101,0,NULL),(668,102,0,NULL),(668,109,1,NULL),(668,110,1,NULL),(668,111,1,NULL),(668,113,1,NULL),(668,129,1,NULL),(668,136,1,NULL),(668,153,NULL,2.1645e-006),(668,192,2,NULL),(668,208,0,NULL),(668,209,3,NULL),(668,210,0,NULL),(668,211,0,NULL),(668,217,395,NULL),(668,246,395,NULL),(668,263,63,NULL),(668,265,156,NULL),(668,267,NULL,0.4),(668,268,NULL,0.9),(668,269,NULL,0.75),(668,270,NULL,0.65),(668,271,1,NULL),(668,272,NULL,0.5),(668,273,NULL,0.6),(668,274,NULL,0.8),(668,283,0,NULL),(668,479,625000,NULL),(668,482,NULL,187.5),(668,484,NULL,0.5),(668,524,NULL,0.75),(668,525,NULL,0.75),(668,552,50,NULL),(668,1178,100,NULL),(668,1179,NULL,0.01),(668,1196,NULL,0.01),(668,1198,NULL,0.01),(668,1199,100,NULL),(668,1200,100,NULL),(668,1224,1,NULL),(668,1271,0,NULL),(668,1281,1,NULL),(669,3,0,NULL),(669,9,13,NULL),(669,11,35,NULL),(669,15,0,NULL),(669,19,1,NULL),(669,21,0,NULL),(669,37,50,NULL),(669,48,100,NULL),(669,49,0,NULL),(669,55,281250,NULL),(669,70,2,NULL),(669,76,15000,NULL),(669,79,2500,NULL),(669,101,0,NULL),(669,102,0,NULL),(669,109,1,NULL),(669,110,1,NULL),(669,111,1,NULL),(669,113,1,NULL),(669,129,1,NULL),(669,136,1,NULL),(669,153,NULL,2.1645e-006),(669,192,2,NULL),(669,208,0,NULL),(669,209,3,NULL),(669,210,0,NULL),(669,211,0,NULL),(669,217,395,NULL),(669,246,395,NULL),(669,263,63,NULL),(669,265,156,NULL),(669,267,NULL,0.4),(669,268,NULL,0.9),(669,269,NULL,0.75),(669,270,NULL,0.65),(669,271,1,NULL),(669,272,NULL,0.5),(669,273,NULL,0.6),(669,274,NULL,0.8),(669,283,0,NULL),(669,479,625000,NULL),(669,482,NULL,187.5),(669,484,NULL,0.5),(669,524,NULL,0.75),(669,525,NULL,0.75),(669,552,50,NULL),(669,1178,100,NULL),(669,1179,NULL,0.01),(669,1196,NULL,0.01),(669,1198,NULL,0.01),(669,1199,100,NULL),(669,1200,100,NULL),(669,1224,1,NULL),(669,1271,0,NULL),(669,1281,1,NULL),(670,3,0,NULL),(670,9,150,NULL),(670,11,1,NULL),(670,15,0,NULL),(670,19,1,NULL),(670,21,0,NULL),(670,37,150,NULL),(670,48,1,NULL),(670,49,0,NULL),(670,55,187500,NULL),(670,70,2,NULL),(670,76,0,NULL),(670,79,2500,NULL),(670,101,0,NULL),(670,102,0,NULL),(670,109,1,NULL),(670,110,1,NULL),(670,111,1,NULL),(670,113,1,NULL),(670,129,1,NULL),(670,136,1,NULL),(670,153,NULL,2.1645e-006),(670,192,2,NULL),(670,208,0,NULL),(670,209,3,NULL),(670,210,0,NULL),(670,211,0,NULL),(670,217,395,NULL),(670,246,396,NULL),(670,263,63,NULL),(670,265,156,NULL),(670,267,NULL,0.4),(670,268,NULL,0.9),(670,269,NULL,0.75),(670,270,NULL,0.65),(670,271,1,NULL),(670,272,NULL,0.5),(670,273,NULL,0.6),(670,274,NULL,0.8),(670,283,0,NULL),(670,479,625000,NULL),(670,482,125,NULL),(670,484,NULL,0.75),(670,524,NULL,0.75),(670,525,NULL,0.75),(670,552,25,NULL),(670,1178,100,NULL),(670,1179,NULL,0.01),(670,1196,NULL,0.01),(670,1198,NULL,0.01),(670,1199,100,NULL),(670,1200,100,NULL),(670,1224,1,NULL),(670,1271,0,NULL),(670,1281,1,NULL),(671,3,0,NULL),(671,9,400000,NULL),(671,11,1050000,NULL),(671,12,7,NULL),(671,13,6,NULL),(671,14,8,NULL),(671,15,0,NULL),(671,19,1,NULL),(671,21,0,NULL),(671,37,70,NULL),(671,48,950,NULL),(671,49,0,NULL),(671,55,6480000,NULL),(671,63,1,NULL),(671,70,NULL,0.037),(671,76,212500,NULL),(671,101,0,NULL),(671,102,6,NULL),(671,109,1,NULL),(671,110,1,NULL),(671,111,1,NULL),(671,113,1,NULL),(671,129,1500,NULL),(671,136,1,NULL),(671,153,NULL,1.38e-008),(671,182,20533,NULL),(671,183,3344,NULL),(671,184,3456,NULL),(671,192,8,NULL),(671,208,0,NULL),(671,209,0,NULL),(671,210,200,NULL),(671,211,0,NULL),(671,217,394,NULL),(671,246,394,NULL),(671,263,275000,NULL),(671,265,325000,NULL),(671,267,NULL,0.5),(671,268,NULL,0.9),(671,269,NULL,0.65),(671,270,NULL,0.65),(671,271,1,NULL),(671,272,NULL,0.5),(671,273,NULL,0.6),(671,274,NULL,0.8),(671,277,5,NULL),(671,278,1,NULL),(671,279,1,NULL),(671,283,475,NULL),(671,310,-99,NULL),(671,479,NULL,40615384.62),(671,482,108000,NULL),(671,484,NULL,0.75),(671,524,NULL,0.75),(671,525,NULL,0.75),(671,552,16205,NULL),(671,564,40,NULL),(671,600,NULL,0.5),(671,715,5000,NULL),(671,716,2,NULL),(671,853,1,NULL),(671,861,1,NULL),(671,866,17887,NULL),(671,867,NULL,3.5),(671,868,1000,NULL),(671,869,300000,NULL),(671,872,1,NULL),(671,874,1,NULL),(671,898,NULL,0.95),(671,907,1,NULL),(671,908,5000000,NULL),(671,911,1,NULL),(671,912,100000,NULL),(671,979,75,NULL),(671,982,1,NULL),(671,1001,0,NULL),(671,1002,300000,NULL),(671,1005,25000,NULL),(671,1041,10,NULL),(671,1042,NULL,7.5),(671,1066,1,NULL),(671,1132,400,NULL),(671,1137,3,NULL),(671,1154,3,NULL),(671,1178,100,NULL),(671,1179,NULL,0.01),(671,1196,NULL,0.01),(671,1198,NULL,0.01),(671,1199,100,NULL),(671,1200,100,NULL),(671,1224,NULL,0.25),(671,1254,1,NULL),(671,1259,NULL,0.82),(671,1261,NULL,0.76),(671,1262,NULL,0.79),(671,1271,125,NULL),(671,1281,1,NULL),(671,1336,0,NULL),(671,1547,3,NULL),(671,1549,60000,NULL),(671,1555,14000,NULL),(672,3,0,NULL),(672,9,16,NULL),(672,11,25,NULL),(672,12,0,NULL),(672,13,0,NULL),(672,14,0,NULL),(672,15,0,NULL),(672,19,1,NULL),(672,21,0,NULL),(672,37,500,NULL),(672,48,150,NULL),(672,49,0,NULL),(672,55,375000,NULL),(672,70,1,NULL),(672,76,35000,NULL),(672,79,5000,NULL),(672,101,0,NULL),(672,102,0,NULL),(672,109,1,NULL),(672,110,1,NULL),(672,111,1,NULL),(672,113,1,NULL),(672,124,16777215,NULL),(672,129,1,NULL),(672,136,1,NULL),(672,153,NULL,1.34771e-006),(672,192,2,NULL),(672,208,0,NULL),(672,209,0,NULL),(672,210,0,NULL),(672,211,7,NULL),(672,217,394,NULL),(672,246,394,NULL),(672,263,235,NULL),(672,265,195,NULL),(672,267,NULL,0.5),(672,268,NULL,0.9),(672,269,NULL,0.75),(672,270,NULL,0.55),(672,271,1,NULL),(672,272,NULL,0.5),(672,273,NULL,0.6),(672,274,NULL,0.8),(672,283,0,NULL),(672,479,625000,NULL),(672,482,250,NULL),(672,484,NULL,0.5),(672,524,NULL,0.75),(672,525,NULL,0.75),(672,552,25,NULL),(672,600,2,NULL),(672,1132,1,NULL),(672,1178,100,NULL),(672,1179,NULL,0.01),(672,1196,NULL,0.01),(672,1198,NULL,0.01),(672,1199,100,NULL),(672,1200,100,NULL),(672,1224,1,NULL),(672,1271,0,NULL),(672,1281,1,NULL),(683,422,1,NULL),(684,422,1,NULL),(685,422,1,NULL),(686,422,1,NULL),(687,422,1,NULL),(689,422,1,NULL),(690,422,1,NULL),(691,422,1,NULL),(692,422,1,NULL),(784,422,2,NULL),(785,422,1,NULL),(786,422,1,NULL),(788,422,1,NULL),(790,422,1,NULL),(803,422,1,NULL),(804,422,1,NULL),(805,422,1,NULL),(806,422,1,NULL),(807,422,1,NULL),(808,422,1,NULL),(809,422,1,NULL),(810,422,1,NULL),(811,422,1,NULL),(812,422,1,NULL),(813,422,1,NULL),(814,422,1,NULL),(819,422,1,NULL),(820,422,1,NULL),(821,422,1,NULL),(822,422,1,NULL),(823,422,1,NULL),(824,422,1,NULL),(825,422,1,NULL),(826,422,1,NULL),(827,422,1,NULL),(828,422,1,NULL),(829,422,1,NULL),(830,422,1,NULL),(831,422,1,NULL),(832,422,1,NULL),(833,422,1,NULL),(834,422,1,NULL),(835,422,1,NULL),(836,422,1,NULL),(837,422,1,NULL),(838,422,1,NULL),(839,422,1,NULL),(840,422,1,NULL),(841,422,1,NULL),(842,422,1,NULL),(843,422,1,NULL),(844,422,1,NULL),(845,422,1,NULL),(846,422,1,NULL),(847,422,1,NULL),(848,422,1,NULL),(935,422,1,NULL),(936,422,1,NULL),(937,422,1,NULL),(938,422,1,NULL),(939,422,1,NULL),(940,422,1,NULL),(941,422,1,NULL),(943,422,1,NULL),(944,422,1,NULL),(945,422,1,NULL),(946,422,1,NULL),(947,422,1,NULL),(948,422,1,NULL),(949,422,1,NULL),(950,422,1,NULL),(951,422,1,NULL),(952,422,1,NULL),(953,422,1,NULL),(954,422,1,NULL),(955,422,1,NULL),(956,422,1,NULL),(957,422,1,NULL),(958,422,1,NULL),(959,422,1,NULL),(960,422,1,NULL),(961,422,1,NULL),(962,422,1,NULL),(963,422,1,NULL),(964,422,1,NULL),(965,422,1,NULL),(966,422,1,NULL),(968,422,1,NULL),(969,422,1,NULL),(970,422,1,NULL),(971,422,1,NULL),(972,422,1,NULL),(973,422,1,NULL),(974,422,1,NULL),(975,422,1,NULL),(976,422,1,NULL),(977,422,1,NULL),(978,422,1,NULL),(979,422,1,NULL),(981,422,1,NULL),(982,422,1,NULL),(1010,422,1,NULL),(1013,422,2,NULL),(1026,422,1,NULL),(1027,422,2,NULL),(1032,422,1,NULL),(1033,422,2,NULL),(1067,422,1,NULL),(1071,422,2,NULL),(1072,422,1,NULL),(1073,422,2,NULL),(1074,422,1,NULL),(1075,422,1,NULL),(1076,422,1,NULL),(1079,422,1,NULL),(1080,422,2,NULL),(1095,422,2,NULL),(1096,422,1,NULL),(1099,422,1,NULL),(1100,422,1,NULL),(1102,422,1,NULL),(1103,422,2,NULL),(1105,422,1,NULL),(1106,422,1,NULL),(1109,422,1,NULL),(1112,422,1,NULL),(1113,422,1,NULL),(1114,422,1,NULL),(1115,422,1,NULL),(1116,422,1,NULL),(1117,422,1,NULL),(1118,422,1,NULL),(1119,422,1,NULL),(1120,422,1,NULL),(1121,422,1,NULL),(1122,422,1,NULL),(1123,422,1,NULL),(1124,422,1,NULL),(1125,422,1,NULL),(1126,422,1,NULL),(1128,422,1,NULL),(1129,422,1,NULL),(1182,6,8,NULL),(1182,9,40,NULL),(1182,30,1,NULL),(1182,50,1,NULL),(1182,73,5000,NULL),(1182,143,50000,NULL),(1182,182,3429,NULL),(1182,235,2,NULL),(1182,277,1,NULL),(1182,422,1,NULL),(1182,633,0,NULL),(1183,6,40,NULL),(1183,9,40,NULL),(1183,30,6,NULL),(1183,50,6,NULL),(1183,73,6000,NULL),(1183,84,80,NULL),(1183,182,3393,NULL),(1183,183,3392,NULL),(1183,277,3,NULL),(1183,278,3,NULL),(1183,422,2,NULL),(1183,633,5,NULL),(1183,1180,NULL,0.02),(1183,1206,-15,NULL),(1183,1211,NULL,5.4),(1183,1212,1,NULL),(1183,1230,10,NULL),(1184,422,2,NULL),(1185,9,40,NULL),(1185,30,10,NULL),(1185,50,50,NULL),(1185,67,75,NULL),(1185,182,3424,NULL),(1185,277,1,NULL),(1185,422,1,NULL),(1185,633,0,NULL),(1186,422,1,NULL),(1187,9,20,NULL),(1187,37,800,NULL),(1187,54,3000,NULL),(1187,70,100,NULL),(1187,154,4000,NULL),(1187,156,NULL,0.75),(1187,482,0,NULL),(1187,525,NULL,0.75),(1187,1272,1,NULL),(1188,6,0,NULL),(1188,9,40,NULL),(1188,30,10,NULL),(1188,50,15,NULL),(1188,73,3000,NULL),(1188,90,-100,NULL),(1188,91,6500,NULL),(1188,182,3423,NULL),(1188,277,3,NULL),(1188,422,2,NULL),(1188,633,1,NULL),(1188,918,0,NULL),(1188,1015,NULL,0.970588235),(1188,1016,NULL,0.991666667),(1188,1017,NULL,0.997916667),(1188,1018,NULL,0.970588235),(1188,1019,NULL,0.991666667),(1188,1020,NULL,0.997916667),(1188,1180,NULL,0.02),(1188,1206,-15,NULL),(1188,1211,NULL,1.4),(1188,1212,1,NULL),(1190,6,41,NULL),(1190,9,40,NULL),(1190,30,5,NULL),(1190,50,32,NULL),(1190,73,5000,NULL),(1190,90,39,NULL),(1190,91,4550,NULL),(1190,182,3423,NULL),(1190,277,4,NULL),(1190,422,2,NULL),(1190,633,5,NULL),(1190,1180,NULL,0.02),(1190,1206,-15,NULL),(1190,1211,NULL,2.2),(1190,1212,1,NULL),(1191,422,2,NULL),(1192,9,40,NULL),(1192,149,NULL,0.9),(1192,182,3392,NULL),(1192,277,1,NULL),(1192,422,1,NULL),(1192,633,0,NULL),(1192,1076,NULL,6.9),(1193,9,40,NULL),(1193,30,1,NULL),(1193,50,0,NULL),(1193,148,1,NULL),(1193,182,3392,NULL),(1193,277,2,NULL),(1193,422,1,NULL),(1193,633,0,NULL),(1193,984,-15,NULL),(1193,985,0,NULL),(1193,986,0,NULL),(1193,987,0,NULL),(1194,245,364,NULL),(1195,9,40,NULL),(1195,30,1,NULL),(1195,50,10,NULL),(1195,144,NULL,0.85),(1195,182,3424,NULL),(1195,277,2,NULL),(1195,422,1,NULL),(1195,633,0,NULL),(1196,422,1,NULL),(1197,9,40,NULL),(1197,30,1,NULL),(1197,50,0,NULL),(1197,148,1,NULL),(1197,182,3394,NULL),(1197,277,1,NULL),(1197,422,1,NULL),(1197,633,0,NULL),(1197,984,-20,NULL),(1197,985,0,NULL),(1197,986,0,NULL),(1197,987,0,NULL),(1198,9,40,NULL),(1198,30,1,NULL),(1198,50,0,NULL),(1198,148,1,NULL),(1198,182,3394,NULL),(1198,277,4,NULL),(1198,422,2,NULL),(1198,633,5,NULL),(1198,984,NULL,-26.4),(1198,985,0,NULL),(1198,986,0,NULL),(1198,987,0,NULL),(1201,9,544,NULL),(1201,37,800,NULL),(1201,51,4000,NULL),(1201,54,1000,NULL),(1201,55,2500000,NULL),(1201,64,NULL,1.45),(1201,70,100,NULL),(1201,79,2000,NULL),(1201,109,1,NULL),(1201,110,1,NULL),(1201,111,1,NULL),(1201,113,1,NULL),(1201,114,0,NULL),(1201,116,0,NULL),(1201,117,48,NULL),(1201,118,0,NULL),(1201,136,NULL,0.75),(1201,154,4000,NULL),(1201,156,NULL,0.75),(1201,158,4000,NULL),(1201,160,NULL,0.3575),(1201,182,3441,NULL),(1201,184,3436,NULL),(1201,192,8,NULL),(1201,193,1,NULL),(1201,208,NULL,22.5),(1201,209,NULL,22.5),(1201,210,NULL,22.5),(1201,211,NULL,22.5),(1201,247,5000,NULL),(1201,263,416,NULL),(1201,265,352,NULL),(1201,267,NULL,0.4),(1201,268,NULL,0.9),(1201,269,NULL,0.75),(1201,270,NULL,0.55),(1201,271,1,NULL),(1201,272,NULL,0.4),(1201,273,NULL,0.6),(1201,274,NULL,0.8),(1201,277,1,NULL),(1201,279,1,NULL),(1201,416,1000,NULL),(1201,422,1,NULL),(1201,479,250000,NULL),(1201,482,1,NULL),(1201,484,NULL,0.75),(1201,508,275,NULL),(1201,524,NULL,0.75),(1201,525,NULL,0.75),(1201,552,100,NULL),(1201,580,1,NULL),(1201,581,1,NULL),(1201,582,2500,NULL),(1201,583,1,NULL),(1201,620,125,NULL),(1201,633,0,NULL),(1201,665,5000,NULL),(1201,1272,25,NULL),(1202,9,40,NULL),(1202,37,300,NULL),(1202,54,5000,NULL),(1202,55,2500000,NULL),(1202,64,1,NULL),(1202,73,60000,NULL),(1202,77,10,NULL),(1202,109,1,NULL),(1202,110,1,NULL),(1202,111,1,NULL),(1202,113,1,NULL),(1202,136,NULL,0.75),(1202,154,250,NULL),(1202,156,NULL,0.75),(1202,157,200,NULL),(1202,182,3438,NULL),(1202,183,3386,NULL),(1202,192,8,NULL),(1202,208,1,NULL),(1202,209,1,NULL),(1202,210,1,NULL),(1202,211,1,NULL),(1202,263,20,NULL),(1202,265,10,NULL),(1202,277,1,NULL),(1202,278,2,NULL),(1202,422,1,NULL),(1202,479,250000,NULL),(1202,482,1,NULL),(1202,484,NULL,0.75),(1202,524,NULL,0.75),(1202,525,NULL,0.75),(1202,552,25,NULL),(1202,1272,5,NULL),(1204,422,1,NULL),(1205,422,2,NULL),(1208,422,1,NULL),(1210,422,1,NULL),(1212,422,1,NULL),(1214,422,1,NULL),(1216,422,1,NULL),(1218,422,1,NULL),(1220,422,1,NULL),(1221,422,1,NULL),(1223,182,3386,NULL),(1223,790,12181,NULL),(1224,182,3386,NULL),(1224,790,12192,NULL),(1225,182,3386,NULL),(1225,790,12182,NULL),(1226,182,3386,NULL),(1226,790,12187,NULL),(1227,182,3386,NULL),(1227,790,12190,NULL),(1228,182,3386,NULL),(1228,790,12193,NULL),(1229,182,3386,NULL),(1229,790,12184,NULL),(1230,182,3386,NULL),(1230,790,12195,NULL),(1231,182,3386,NULL),(1231,790,12186,NULL),(1232,182,3386,NULL),(1232,790,12183,NULL),(1233,3,0,NULL),(1233,9,375,NULL),(1233,11,250000,NULL),(1233,12,7,NULL),(1233,13,8,NULL),(1233,14,7,NULL),(1233,15,0,NULL),(1233,19,1,NULL),(1233,21,0,NULL),(1233,37,400,NULL),(1233,48,600,NULL),(1233,49,0,NULL),(1233,55,250000,NULL),(1233,70,NULL,3.1),(1233,76,45000,NULL),(1233,79,6000,NULL),(1233,101,7,NULL),(1233,102,2,NULL),(1233,109,1,NULL),(1233,110,1,NULL),(1233,111,1,NULL),(1233,113,1,NULL),(1233,124,16777215,NULL),(1233,129,3,NULL),(1233,136,1,NULL),(1233,153,NULL,1.67e-006),(1233,182,3755,NULL),(1233,192,3,NULL),(1233,208,0,NULL),(1233,209,0,NULL),(1233,210,0,NULL),(1233,211,6,NULL),(1233,217,397,NULL),(1233,246,397,NULL),(1233,263,3000,NULL),(1233,265,1250,NULL),(1233,267,NULL,0.5),(1233,268,NULL,0.9),(1233,269,NULL,0.75),(1233,270,NULL,0.65),(1233,271,1,NULL),(1233,272,NULL,0.5),(1233,273,NULL,0.6),(1233,274,NULL,0.8),(1233,277,5,NULL),(1233,283,50,NULL),(1233,422,1,NULL),(1233,479,625000,NULL),(1233,482,2500,NULL),(1233,484,NULL,0.75),(1233,511,0,NULL),(1233,524,NULL,0.75),(1233,525,NULL,0.75),(1233,552,30,NULL),(1233,564,750,NULL),(1233,600,2,NULL),(1233,633,0,NULL),(1233,661,3000,NULL),(1233,662,NULL,0.05),(1233,1132,350,NULL),(1233,1137,3,NULL),(1233,1154,3,NULL),(1233,1178,100,NULL),(1233,1179,NULL,0.01),(1233,1196,NULL,0.01),(1233,1198,NULL,0.01),(1233,1199,100,NULL),(1233,1200,100,NULL),(1233,1224,1,NULL),(1233,1259,NULL,0.79),(1233,1261,NULL,0.82),(1233,1262,NULL,0.79),(1233,1271,25,NULL),(1233,1281,1,NULL),(1233,1547,1,NULL),(1236,9,40,NULL),(1236,149,NULL,0.8),(1236,182,3394,NULL),(1236,277,2,NULL),(1236,422,2,NULL),(1236,633,5,NULL),(1236,1076,NULL,12.5),(1237,9,1,NULL),(1237,422,2,NULL),(1240,9,40,NULL),(1240,30,1,NULL),(1240,50,20,NULL),(1240,150,NULL,1.05),(1240,169,5,NULL),(1240,182,3392,NULL),(1240,277,1,NULL),(1240,306,NULL,0.95),(1240,422,1,NULL),(1240,633,0,NULL),(1242,9,40,NULL),(1242,150,NULL,0.9),(1242,169,NULL,-10.4),(1242,182,3394,NULL),(1242,277,1,NULL),(1242,422,1,NULL),(1242,633,0,NULL),(1242,1076,NULL,5.3),(1244,9,40,NULL),(1244,149,NULL,0.85),(1244,182,3394,NULL),(1244,277,1,NULL),(1244,422,1,NULL),(1244,633,0,NULL),(1244,1076,NULL,10.4),(1245,9,1,NULL),(1245,422,1,NULL),(1246,9,40,NULL),(1246,30,0,NULL),(1246,50,20,NULL),(1246,134,1,NULL),(1246,144,NULL,0.79),(1246,145,1,NULL),(1246,146,1,NULL),(1246,147,NULL,0.9),(1246,182,3424,NULL),(1246,277,3,NULL),(1246,422,1,NULL),(1246,633,0,NULL),(1247,422,1,NULL),(1248,9,40,NULL),(1248,30,0,NULL),(1248,50,22,NULL),(1248,134,1,NULL),(1248,144,NULL,0.74),(1248,145,1,NULL),(1248,146,1,NULL),(1248,147,NULL,0.9),(1248,182,3424,NULL),(1248,277,4,NULL),(1248,422,2,NULL),(1248,633,5,NULL),(1249,422,2,NULL),(1254,9,40,NULL),(1254,30,0,NULL),(1254,50,20,NULL),(1254,134,NULL,0.75),(1254,144,1,NULL),(1254,145,1,NULL),(1254,146,NULL,0.85),(1254,147,1,NULL),(1254,182,3424,NULL),(1254,277,2,NULL),(1254,422,1,NULL),(1254,633,0,NULL),(1255,422,1,NULL),(1256,9,40,NULL),(1256,30,0,NULL),(1256,50,22,NULL),(1256,134,NULL,0.7),(1256,144,1,NULL),(1256,145,1,NULL),(1256,146,NULL,0.85),(1256,147,1,NULL),(1256,182,3424,NULL),(1256,277,4,NULL),(1256,422,2,NULL),(1256,633,5,NULL),(1257,422,2,NULL),(1262,9,40,NULL),(1262,30,1,NULL),(1262,50,0,NULL),(1262,148,1,NULL),(1262,182,3392,NULL),(1262,277,2,NULL),(1262,422,1,NULL),(1262,633,0,NULL),(1262,984,0,NULL),(1262,985,-15,NULL),(1262,986,0,NULL),(1262,987,0,NULL),(1264,9,40,NULL),(1264,30,1,NULL),(1264,50,0,NULL),(1264,148,1,NULL),(1264,182,3394,NULL),(1264,277,1,NULL),(1264,422,1,NULL),(1264,633,0,NULL),(1264,984,0,NULL),(1264,985,-20,NULL),(1264,986,0,NULL),(1264,987,0,NULL),(1265,422,1,NULL),(1266,9,40,NULL),(1266,30,1,NULL),(1266,50,0,NULL),(1266,148,1,NULL),(1266,182,3394,NULL),(1266,277,4,NULL),(1266,422,2,NULL),(1266,633,5,NULL),(1266,984,0,NULL),(1266,985,NULL,-26.4),(1266,986,0,NULL),(1266,987,0,NULL),(1267,422,2,NULL),(1272,9,40,NULL),(1272,30,1,NULL),(1272,50,0,NULL),(1272,148,NULL,1.05),(1272,182,3392,NULL),(1272,277,2,NULL),(1272,422,1,NULL),(1272,633,0,NULL),(1272,984,0,NULL),(1272,985,0,NULL),(1272,986,0,NULL),(1272,987,0,NULL),(1274,9,40,NULL),(1274,30,1,NULL),(1274,50,0,NULL),(1274,148,NULL,1.06),(1274,182,3394,NULL),(1274,277,1,NULL),(1274,422,1,NULL),(1274,633,0,NULL),(1274,984,0,NULL),(1274,985,0,NULL),(1274,986,0,NULL),(1274,987,0,NULL),(1275,422,1,NULL),(1276,9,40,NULL),(1276,30,1,NULL),(1276,50,0,NULL),(1276,148,NULL,1.08),(1276,182,3394,NULL),(1276,277,4,NULL),(1276,422,2,NULL),(1276,633,5,NULL),(1276,984,0,NULL),(1276,985,0,NULL),(1276,986,0,NULL),(1276,987,0,NULL),(1277,422,2,NULL),(1282,9,40,NULL),(1282,30,1,NULL),(1282,50,0,NULL),(1282,148,1,NULL),(1282,182,3392,NULL),(1282,277,2,NULL),(1282,422,1,NULL),(1282,633,0,NULL),(1282,984,0,NULL),(1282,985,0,NULL),(1282,986,-15,NULL),(1282,987,0,NULL),(1284,9,40,NULL),(1284,30,1,NULL),(1284,50,0,NULL),(1284,148,1,NULL),(1284,182,3394,NULL),(1284,277,1,NULL),(1284,422,1,NULL),(1284,633,0,NULL),(1284,984,0,NULL),(1284,985,0,NULL),(1284,986,-20,NULL),(1284,987,0,NULL),(1285,422,1,NULL),(1286,9,40,NULL),(1286,30,1,NULL),(1286,50,0,NULL),(1286,148,1,NULL),(1286,182,3394,NULL),(1286,277,4,NULL),(1286,422,2,NULL),(1286,633,5,NULL),(1286,984,0,NULL),(1286,985,0,NULL),(1286,986,NULL,-26.4),(1286,987,0,NULL),(1287,422,2,NULL),(1292,9,40,NULL),(1292,30,1,NULL),(1292,50,0,NULL),(1292,148,1,NULL),(1292,182,3392,NULL),(1292,277,1,NULL),(1292,422,1,NULL),(1292,633,0,NULL),(1292,984,0,NULL),(1292,985,0,NULL),(1292,986,0,NULL),(1292,987,-15,NULL),(1294,9,40,NULL),(1294,30,1,NULL),(1294,50,0,NULL),(1294,148,1,NULL),(1294,182,3394,NULL),(1294,277,1,NULL),(1294,422,1,NULL),(1294,633,0,NULL),(1294,984,0,NULL),(1294,985,0,NULL),(1294,986,0,NULL),(1294,987,-20,NULL),(1295,422,1,NULL),(1296,9,40,NULL),(1296,30,1,NULL),(1296,50,0,NULL),(1296,148,1,NULL),(1296,182,3394,NULL),(1296,277,4,NULL),(1296,422,2,NULL),(1296,633,5,NULL),(1296,984,0,NULL),(1296,985,0,NULL),(1296,986,0,NULL),(1296,987,NULL,-26.4),(1297,422,2,NULL),(1302,9,40,NULL),(1302,30,1,NULL),(1302,50,0,NULL),(1302,148,1,NULL),(1302,182,3392,NULL),(1302,277,2,NULL),(1302,422,1,NULL),(1302,633,0,NULL),(1302,984,-7,NULL),(1302,985,-7,NULL),(1302,986,-7,NULL),(1302,987,-7,NULL),(1304,9,40,NULL),(1304,30,1,NULL),(1304,50,0,NULL),(1304,148,1,NULL),(1304,182,3394,NULL),(1304,277,1,NULL),(1304,422,1,NULL),(1304,633,0,NULL),(1304,984,-8,NULL),(1304,985,-8,NULL),(1304,986,-8,NULL),(1304,987,-8,NULL),(1305,422,1,NULL),(1306,9,40,NULL),(1306,30,1,NULL),(1306,50,0,NULL),(1306,148,1,NULL),(1306,182,3394,NULL),(1306,277,4,NULL),(1306,422,2,NULL),(1306,633,5,NULL),(1306,984,NULL,-15.36),(1306,985,NULL,-15.36),(1306,986,NULL,-15.36),(1306,987,NULL,-15.36),(1307,422,2,NULL),(1315,9,40,NULL),(1315,149,NULL,1.15),(1315,150,NULL,0.9),(1315,182,3392,NULL),(1315,277,1,NULL),(1315,306,NULL,0.8),(1315,422,1,NULL),(1315,633,0,NULL),(1317,9,40,NULL),(1317,149,NULL,1.175),(1317,150,NULL,0.75),(1317,182,3394,NULL),(1317,277,1,NULL),(1317,306,NULL,0.85),(1317,422,1,NULL),(1317,633,0,NULL),(1318,9,1,NULL),(1318,422,1,NULL),(1319,9,40,NULL),(1319,149,NULL,1.275),(1319,150,NULL,0.8),(1319,182,3394,NULL),(1319,277,2,NULL),(1319,306,NULL,0.9),(1319,422,2,NULL),(1319,633,5,NULL),(1320,9,1,NULL),(1320,422,2,NULL),(1333,9,40,NULL),(1333,30,1,NULL),(1333,50,35,NULL),(1333,150,NULL,1.15),(1333,169,1,NULL),(1333,182,3394,NULL),(1333,277,1,NULL),(1333,306,NULL,0.9),(1333,422,1,NULL),(1333,633,0,NULL),(1334,9,1,NULL),(1334,422,1,NULL),(1335,9,40,NULL),(1335,30,1,NULL),(1335,50,40,NULL),(1335,150,NULL,1.25),(1335,169,1,NULL),(1335,182,3394,NULL),(1335,277,2,NULL),(1335,306,NULL,0.89),(1335,422,2,NULL),(1335,633,5,NULL),(1336,9,1,NULL),(1336,422,2,NULL),(1351,9,40,NULL),(1351,30,0,NULL),(1351,50,10,NULL),(1351,134,1,NULL),(1351,144,1,NULL),(1351,145,NULL,1.05),(1351,146,1,NULL),(1351,147,1,NULL),(1351,182,3424,NULL),(1351,277,1,NULL),(1351,422,1,NULL),(1351,633,0,NULL),(1353,9,40,NULL),(1353,30,0,NULL),(1353,50,20,NULL),(1353,134,1,NULL),(1353,144,1,NULL),(1353,145,NULL,1.1),(1353,146,1,NULL),(1353,147,1,NULL),(1353,182,3424,NULL),(1353,277,2,NULL),(1353,422,1,NULL),(1353,633,0,NULL),(1354,422,1,NULL),(1355,9,40,NULL),(1355,30,0,NULL),(1355,50,20,NULL),(1355,134,1,NULL),(1355,144,1,NULL),(1355,145,NULL,1.15),(1355,146,1,NULL),(1355,147,1,NULL),(1355,182,3424,NULL),(1355,277,5,NULL),(1355,422,2,NULL),(1355,633,5,NULL),(1356,422,2,NULL),(1373,164,0,NULL),(1373,165,0,NULL),(1373,166,0,NULL),(1373,167,0,NULL),(1373,168,0,NULL),(1373,170,0,NULL),(1373,171,0,NULL),(1373,172,0,NULL),(1373,173,0,NULL),(1373,174,0,NULL),(1373,187,NULL,0.1),(1373,192,2,NULL),(1373,196,1,NULL),(1373,219,1,NULL),(1373,355,1,NULL),(1373,356,0,NULL),(1373,359,1,NULL),(1373,360,0,NULL),(1373,361,0,NULL),(1373,362,1,NULL),(1373,363,1,NULL),(1373,364,1,NULL),(1373,365,0,NULL),(1373,366,1,NULL),(1373,368,1,NULL),(1373,369,NULL,1.25),(1373,378,NULL,0.75),(1373,385,1,NULL),(1373,387,2,NULL),(1373,388,100,NULL),(1373,389,100,NULL),(1373,392,100,NULL),(1373,393,100,NULL),(1373,394,100,NULL),(1373,395,100,NULL),(1373,396,1,NULL),(1373,397,0,NULL),(1373,398,1,NULL),(1373,399,0,NULL),(1373,400,1,NULL),(1373,401,1,NULL),(1373,402,1,NULL),(1373,404,1,NULL),(1373,406,1,NULL),(1373,417,0,NULL),(1373,426,1,NULL),(1373,428,100,NULL),(1373,435,1,NULL),(1373,442,1,NULL),(1373,443,1,NULL),(1373,444,NULL,0.45),(1373,445,NULL,0.1),(1373,458,20000,NULL),(1373,467,1,NULL),(1373,522,2,NULL),(1373,551,1,NULL),(1373,625,0,NULL),(1373,626,1,NULL),(1373,723,NULL,0.9),(1373,1021,15000,NULL),(1373,1022,1,NULL),(1373,1267,10,NULL),(1373,1277,NULL,0.5),(1374,164,0,NULL),(1374,165,0,NULL),(1374,166,0,NULL),(1374,167,0,NULL),(1374,168,0,NULL),(1374,170,0,NULL),(1374,171,0,NULL),(1374,172,0,NULL),(1374,173,0,NULL),(1374,174,0,NULL),(1374,187,NULL,0.1),(1374,192,2,NULL),(1374,196,1,NULL),(1374,219,1,NULL),(1374,355,1,NULL),(1374,356,0,NULL),(1374,359,1,NULL),(1374,360,0,NULL),(1374,361,0,NULL),(1374,362,1,NULL),(1374,363,1,NULL),(1374,364,1,NULL),(1374,365,0,NULL),(1374,366,1,NULL),(1374,368,1,NULL),(1374,369,NULL,1.25),(1374,378,NULL,0.75),(1374,385,1,NULL),(1374,387,2,NULL),(1374,388,100,NULL),(1374,389,100,NULL),(1374,392,100,NULL),(1374,393,100,NULL),(1374,394,100,NULL),(1374,395,100,NULL),(1374,396,1,NULL),(1374,397,0,NULL),(1374,398,1,NULL),(1374,399,0,NULL),(1374,400,1,NULL),(1374,401,1,NULL),(1374,402,1,NULL),(1374,404,1,NULL),(1374,406,1,NULL),(1374,417,0,NULL),(1374,426,1,NULL),(1374,428,100,NULL),(1374,435,1,NULL),(1374,442,1,NULL),(1374,443,1,NULL),(1374,444,NULL,0.45),(1374,445,NULL,0.1),(1374,458,20000,NULL),(1374,467,1,NULL),(1374,522,2,NULL),(1374,551,1,NULL),(1374,625,0,NULL),(1374,626,1,NULL),(1374,723,NULL,0.9),(1374,1021,15000,NULL),(1374,1022,1,NULL),(1374,1267,10,NULL),(1374,1277,NULL,0.5),(1375,164,0,NULL),(1375,165,0,NULL),(1375,166,0,NULL),(1375,167,0,NULL),(1375,168,0,NULL),(1375,170,0,NULL),(1375,171,0,NULL),(1375,172,0,NULL),(1375,173,0,NULL),(1375,174,0,NULL),(1375,187,NULL,0.1),(1375,192,2,NULL),(1375,196,1,NULL),(1375,219,1,NULL),(1375,355,1,NULL),(1375,356,0,NULL),(1375,359,1,NULL),(1375,360,0,NULL),(1375,361,0,NULL),(1375,362,1,NULL),(1375,363,1,NULL),(1375,364,1,NULL),(1375,365,0,NULL),(1375,366,1,NULL),(1375,368,1,NULL),(1375,369,NULL,1.25),(1375,378,NULL,0.75),(1375,385,1,NULL),(1375,387,2,NULL),(1375,388,100,NULL),(1375,389,100,NULL),(1375,392,100,NULL),(1375,393,100,NULL),(1375,394,100,NULL),(1375,395,100,NULL),(1375,396,1,NULL),(1375,397,0,NULL),(1375,398,1,NULL),(1375,399,0,NULL),(1375,400,1,NULL),(1375,401,1,NULL),(1375,402,1,NULL),(1375,404,1,NULL),(1375,406,1,NULL),(1375,417,0,NULL),(1375,426,1,NULL),(1375,428,100,NULL),(1375,435,1,NULL),(1375,442,1,NULL),(1375,443,1,NULL),(1375,444,NULL,0.45),(1375,445,NULL,0.1),(1375,458,20000,NULL),(1375,467,1,NULL),(1375,522,2,NULL),(1375,551,1,NULL),(1375,625,0,NULL),(1375,626,1,NULL),(1375,723,NULL,0.9),(1375,1021,15000,NULL),(1375,1022,1,NULL),(1375,1267,10,NULL),(1375,1277,NULL,0.5),(1376,164,0,NULL),(1376,165,0,NULL),(1376,166,0,NULL),(1376,167,0,NULL),(1376,168,0,NULL),(1376,170,0,NULL),(1376,171,0,NULL),(1376,172,0,NULL),(1376,173,0,NULL),(1376,174,0,NULL),(1376,187,NULL,0.1),(1376,192,2,NULL),(1376,196,1,NULL),(1376,219,1,NULL),(1376,355,1,NULL),(1376,356,0,NULL),(1376,359,1,NULL),(1376,360,0,NULL),(1376,361,0,NULL),(1376,362,1,NULL),(1376,363,1,NULL),(1376,364,1,NULL),(1376,365,0,NULL),(1376,366,1,NULL),(1376,368,1,NULL),(1376,369,NULL,1.25),(1376,378,NULL,0.75),(1376,385,1,NULL),(1376,387,2,NULL),(1376,388,100,NULL),(1376,389,100,NULL),(1376,392,100,NULL),(1376,393,100,NULL),(1376,394,100,NULL),(1376,395,100,NULL),(1376,396,1,NULL),(1376,397,0,NULL),(1376,398,1,NULL),(1376,399,0,NULL),(1376,400,1,NULL),(1376,401,1,NULL),(1376,402,1,NULL),(1376,404,1,NULL),(1376,406,1,NULL),(1376,417,0,NULL),(1376,426,1,NULL),(1376,428,100,NULL),(1376,435,1,NULL),(1376,442,1,NULL),(1376,443,1,NULL),(1376,444,NULL,0.45),(1376,445,NULL,0.1),(1376,458,20000,NULL),(1376,467,1,NULL),(1376,522,2,NULL),(1376,551,1,NULL),(1376,625,0,NULL),(1376,626,1,NULL),(1376,723,NULL,0.9),(1376,1021,15000,NULL),(1376,1022,1,NULL),(1376,1267,10,NULL),(1376,1277,NULL,0.5),(1377,164,0,NULL),(1377,165,0,NULL),(1377,166,0,NULL),(1377,167,0,NULL),(1377,168,0,NULL),(1377,170,0,NULL),(1377,171,0,NULL),(1377,172,0,NULL),(1377,173,0,NULL),(1377,174,0,NULL),(1377,187,NULL,0.1),(1377,192,2,NULL),(1377,196,1,NULL),(1377,219,1,NULL),(1377,355,1,NULL),(1377,356,0,NULL),(1377,359,1,NULL),(1377,360,0,NULL),(1377,361,0,NULL),(1377,362,1,NULL),(1377,363,1,NULL),(1377,364,1,NULL),(1377,365,0,NULL),(1377,366,1,NULL),(1377,368,1,NULL),(1377,369,NULL,1.25),(1377,378,NULL,0.75),(1377,385,1,NULL),(1377,387,2,NULL),(1377,388,100,NULL),(1377,389,100,NULL),(1377,392,100,NULL),(1377,393,100,NULL),(1377,394,100,NULL),(1377,395,100,NULL),(1377,396,1,NULL),(1377,397,0,NULL),(1377,398,1,NULL),(1377,399,0,NULL),(1377,400,1,NULL),(1377,401,1,NULL),(1377,402,1,NULL),(1377,404,1,NULL),(1377,406,1,NULL),(1377,417,0,NULL),(1377,426,1,NULL),(1377,428,100,NULL),(1377,435,1,NULL),(1377,442,1,NULL),(1377,443,1,NULL),(1377,444,NULL,0.45),(1377,445,NULL,0.1),(1377,458,20000,NULL),(1377,467,1,NULL),(1377,522,2,NULL),(1377,551,1,NULL),(1377,625,0,NULL),(1377,626,1,NULL),(1377,723,NULL,0.9),(1377,1021,15000,NULL),(1377,1022,1,NULL),(1377,1267,10,NULL),(1377,1277,NULL,0.5),(1378,164,0,NULL),(1378,165,0,NULL),(1378,166,0,NULL),(1378,167,0,NULL),(1378,168,0,NULL),(1378,170,0,NULL),(1378,171,0,NULL),(1378,172,0,NULL),(1378,173,0,NULL),(1378,174,0,NULL),(1378,187,NULL,0.1),(1378,192,2,NULL),(1378,196,1,NULL),(1378,219,1,NULL),(1378,355,1,NULL),(1378,356,0,NULL),(1378,359,1,NULL),(1378,360,0,NULL),(1378,361,0,NULL),(1378,362,1,NULL),(1378,363,1,NULL),(1378,364,1,NULL),(1378,365,0,NULL),(1378,366,1,NULL),(1378,368,1,NULL),(1378,369,NULL,1.25),(1378,378,NULL,0.75),(1378,385,1,NULL),(1378,387,2,NULL),(1378,388,100,NULL),(1378,389,100,NULL),(1378,392,100,NULL),(1378,393,100,NULL),(1378,394,100,NULL),(1378,395,100,NULL),(1378,396,1,NULL),(1378,397,0,NULL),(1378,398,1,NULL),(1378,399,0,NULL),(1378,400,1,NULL),(1378,401,1,NULL),(1378,402,1,NULL),(1378,404,1,NULL),(1378,406,1,NULL),(1378,417,0,NULL),(1378,426,1,NULL),(1378,428,100,NULL),(1378,435,1,NULL),(1378,442,1,NULL),(1378,443,1,NULL),(1378,444,NULL,0.45),(1378,445,NULL,0.1),(1378,458,20000,NULL),(1378,467,1,NULL),(1378,522,2,NULL),(1378,551,1,NULL),(1378,625,0,NULL),(1378,626,1,NULL),(1378,723,NULL,0.9),(1378,1021,15000,NULL),(1378,1022,1,NULL),(1378,1267,10,NULL),(1378,1277,NULL,0.5),(1379,164,0,NULL),(1379,165,0,NULL),(1379,166,0,NULL),(1379,167,0,NULL),(1379,168,0,NULL),(1379,170,0,NULL),(1379,171,0,NULL),(1379,172,0,NULL),(1379,173,0,NULL),(1379,174,0,NULL),(1379,187,NULL,0.1),(1379,192,2,NULL),(1379,196,1,NULL),(1379,219,1,NULL),(1379,355,1,NULL),(1379,356,0,NULL),(1379,359,1,NULL),(1379,360,0,NULL),(1379,361,0,NULL),(1379,362,1,NULL),(1379,363,1,NULL),(1379,364,1,NULL),(1379,365,0,NULL),(1379,366,1,NULL),(1379,368,1,NULL),(1379,369,NULL,1.25),(1379,378,NULL,0.75),(1379,385,1,NULL),(1379,387,2,NULL),(1379,388,100,NULL),(1379,389,100,NULL),(1379,392,100,NULL),(1379,393,100,NULL),(1379,394,100,NULL),(1379,395,100,NULL),(1379,396,1,NULL),(1379,397,0,NULL),(1379,398,1,NULL),(1379,399,0,NULL),(1379,400,1,NULL),(1379,401,1,NULL),(1379,402,1,NULL),(1379,404,1,NULL),(1379,406,1,NULL),(1379,417,0,NULL),(1379,426,1,NULL),(1379,428,100,NULL),(1379,435,1,NULL),(1379,442,1,NULL),(1379,443,1,NULL),(1379,444,NULL,0.45),(1379,445,NULL,0.1),(1379,458,20000,NULL),(1379,467,1,NULL),(1379,522,2,NULL),(1379,551,1,NULL),(1379,625,0,NULL),(1379,626,1,NULL),(1379,723,NULL,0.9),(1379,1021,15000,NULL),(1379,1022,1,NULL),(1379,1267,10,NULL),(1379,1277,NULL,0.5),(1380,164,0,NULL),(1380,165,0,NULL),(1380,166,0,NULL),(1380,167,0,NULL),(1380,168,0,NULL),(1380,170,0,NULL),(1380,171,0,NULL),(1380,172,0,NULL),(1380,173,0,NULL),(1380,174,0,NULL),(1380,187,NULL,0.1),(1380,192,2,NULL),(1380,196,1,NULL),(1380,219,1,NULL),(1380,355,1,NULL),(1380,356,0,NULL),(1380,359,1,NULL),(1380,360,0,NULL),(1380,361,0,NULL),(1380,362,1,NULL),(1380,363,1,NULL),(1380,364,1,NULL),(1380,365,0,NULL),(1380,366,1,NULL),(1380,368,1,NULL),(1380,369,NULL,1.25),(1380,378,NULL,0.75),(1380,385,1,NULL),(1380,387,2,NULL),(1380,388,100,NULL),(1380,389,100,NULL),(1380,392,100,NULL),(1380,393,100,NULL),(1380,394,100,NULL),(1380,395,100,NULL),(1380,396,1,NULL),(1380,397,0,NULL),(1380,398,1,NULL),(1380,399,0,NULL),(1380,400,1,NULL),(1380,401,1,NULL),(1380,402,1,NULL),(1380,404,1,NULL),(1380,406,1,NULL),(1380,417,0,NULL),(1380,426,1,NULL),(1380,428,100,NULL),(1380,435,1,NULL),(1380,442,1,NULL),(1380,443,1,NULL),(1380,444,NULL,0.45),(1380,445,NULL,0.1),(1380,458,20000,NULL),(1380,467,1,NULL),(1380,522,2,NULL),(1380,551,1,NULL),(1380,625,0,NULL),(1380,626,1,NULL),(1380,723,NULL,0.9),(1380,1021,15000,NULL),(1380,1022,1,NULL),(1380,1267,10,NULL),(1380,1277,NULL,0.5),(1381,164,0,NULL),(1381,165,0,NULL),(1381,166,0,NULL),(1381,167,0,NULL),(1381,168,0,NULL),(1381,170,0,NULL),(1381,171,0,NULL),(1381,172,0,NULL),(1381,173,0,NULL),(1381,174,0,NULL),(1381,187,NULL,0.1),(1381,192,2,NULL),(1381,196,1,NULL),(1381,219,1,NULL),(1381,355,1,NULL),(1381,356,0,NULL),(1381,359,1,NULL),(1381,360,0,NULL),(1381,361,0,NULL),(1381,362,1,NULL),(1381,363,1,NULL),(1381,364,1,NULL),(1381,365,0,NULL),(1381,366,1,NULL),(1381,368,1,NULL),(1381,369,NULL,1.25),(1381,378,NULL,0.75),(1381,385,1,NULL),(1381,387,2,NULL),(1381,388,100,NULL),(1381,389,100,NULL),(1381,392,100,NULL),(1381,393,100,NULL),(1381,394,100,NULL),(1381,395,100,NULL),(1381,396,1,NULL),(1381,397,0,NULL),(1381,398,1,NULL),(1381,399,0,NULL),(1381,400,1,NULL),(1381,401,1,NULL),(1381,402,1,NULL),(1381,404,1,NULL),(1381,406,1,NULL),(1381,417,0,NULL),(1381,426,1,NULL),(1381,428,100,NULL),(1381,435,1,NULL),(1381,442,1,NULL),(1381,443,1,NULL),(1381,444,NULL,0.45),(1381,445,NULL,0.1),(1381,458,20000,NULL),(1381,467,1,NULL),(1381,522,2,NULL),(1381,551,1,NULL),(1381,625,0,NULL),(1381,626,1,NULL),(1381,723,NULL,0.9),(1381,1021,15000,NULL),(1381,1022,1,NULL),(1381,1267,10,NULL),(1381,1277,NULL,0.5),(1382,164,0,NULL),(1382,165,0,NULL),(1382,166,0,NULL),(1382,167,0,NULL),(1382,168,0,NULL),(1382,170,0,NULL),(1382,171,0,NULL),(1382,172,0,NULL),(1382,173,0,NULL),(1382,174,0,NULL),(1382,187,NULL,0.1),(1382,192,1,NULL),(1382,196,1,NULL),(1382,219,1,NULL),(1382,355,1,NULL),(1382,356,0,NULL),(1382,359,1,NULL),(1382,360,0,NULL),(1382,361,0,NULL),(1382,362,1,NULL),(1382,363,1,NULL),(1382,364,1,NULL),(1382,365,0,NULL),(1382,366,1,NULL),(1382,368,1,NULL),(1382,369,NULL,1.25),(1382,378,NULL,0.75),(1382,385,1,NULL),(1382,387,2,NULL),(1382,388,100,NULL),(1382,389,100,NULL),(1382,392,100,NULL),(1382,393,100,NULL),(1382,394,100,NULL),(1382,395,100,NULL),(1382,396,1,NULL),(1382,397,0,NULL),(1382,398,1,NULL),(1382,399,0,NULL),(1382,400,1,NULL),(1382,401,1,NULL),(1382,402,1,NULL),(1382,404,1,NULL),(1382,406,1,NULL),(1382,417,0,NULL),(1382,426,1,NULL),(1382,428,100,NULL),(1382,435,1,NULL),(1382,442,1,NULL),(1382,443,1,NULL),(1382,444,NULL,0.45),(1382,445,NULL,0.1),(1382,458,20000,NULL),(1382,467,1,NULL),(1382,522,2,NULL),(1382,551,1,NULL),(1382,625,0,NULL),(1382,626,1,NULL),(1382,723,NULL,0.9),(1382,1021,15000,NULL),(1382,1022,1,NULL),(1382,1267,10,NULL),(1382,1277,NULL,0.5),(1383,164,0,NULL),(1383,165,0,NULL),(1383,166,0,NULL),(1383,167,0,NULL),(1383,168,0,NULL),(1383,170,0,NULL),(1383,171,0,NULL),(1383,172,0,NULL),(1383,173,0,NULL),(1383,174,0,NULL),(1383,187,NULL,0.1),(1383,192,2,NULL),(1383,196,1,NULL),(1383,219,1,NULL),(1383,355,1,NULL),(1383,356,0,NULL),(1383,359,1,NULL),(1383,360,0,NULL),(1383,361,0,NULL),(1383,362,1,NULL),(1383,363,1,NULL),(1383,364,1,NULL),(1383,365,0,NULL),(1383,366,1,NULL),(1383,368,1,NULL),(1383,369,NULL,1.25),(1383,378,NULL,0.75),(1383,385,1,NULL),(1383,387,2,NULL),(1383,388,100,NULL),(1383,389,100,NULL),(1383,392,100,NULL),(1383,393,100,NULL),(1383,394,100,NULL),(1383,395,100,NULL),(1383,396,1,NULL),(1383,397,0,NULL),(1383,398,1,NULL),(1383,399,0,NULL),(1383,400,1,NULL),(1383,401,1,NULL),(1383,402,1,NULL),(1383,404,1,NULL),(1383,406,1,NULL),(1383,417,0,NULL),(1383,426,1,NULL),(1383,428,100,NULL),(1383,435,1,NULL),(1383,442,1,NULL),(1383,443,1,NULL),(1383,444,NULL,0.45),(1383,445,NULL,0.1),(1383,458,20000,NULL),(1383,467,1,NULL),(1383,522,2,NULL),(1383,551,1,NULL),(1383,625,0,NULL),(1383,626,1,NULL),(1383,723,NULL,0.9),(1383,1021,15000,NULL),(1383,1022,1,NULL),(1383,1267,10,NULL),(1383,1277,NULL,0.5),(1384,164,0,NULL),(1384,165,0,NULL),(1384,166,0,NULL),(1384,167,0,NULL),(1384,168,0,NULL),(1384,170,0,NULL),(1384,171,0,NULL),(1384,172,0,NULL),(1384,173,0,NULL),(1384,174,0,NULL),(1384,187,NULL,0.1),(1384,192,2,NULL),(1384,196,1,NULL),(1384,219,1,NULL),(1384,355,1,NULL),(1384,356,0,NULL),(1384,359,1,NULL),(1384,360,0,NULL),(1384,361,0,NULL),(1384,362,1,NULL),(1384,363,1,NULL),(1384,364,1,NULL),(1384,365,0,NULL),(1384,366,1,NULL),(1384,368,1,NULL),(1384,369,NULL,1.25),(1384,378,NULL,0.75),(1384,385,1,NULL),(1384,387,2,NULL),(1384,388,100,NULL),(1384,389,100,NULL),(1384,392,100,NULL),(1384,393,100,NULL),(1384,394,100,NULL),(1384,395,100,NULL),(1384,396,1,NULL),(1384,397,0,NULL),(1384,398,1,NULL),(1384,399,0,NULL),(1384,400,1,NULL),(1384,401,1,NULL),(1384,402,1,NULL),(1384,404,1,NULL),(1384,406,1,NULL),(1384,417,0,NULL),(1384,426,1,NULL),(1384,428,100,NULL),(1384,435,1,NULL),(1384,442,1,NULL),(1384,443,1,NULL),(1384,444,NULL,0.45),(1384,445,NULL,0.1),(1384,458,20000,NULL),(1384,467,1,NULL),(1384,522,2,NULL),(1384,551,1,NULL),(1384,625,0,NULL),(1384,626,1,NULL),(1384,723,NULL,0.9),(1384,1021,15000,NULL),(1384,1022,1,NULL),(1384,1267,10,NULL),(1384,1277,NULL,0.5),(1385,164,0,NULL),(1385,165,0,NULL),(1385,166,0,NULL),(1385,167,0,NULL),(1385,168,0,NULL),(1385,170,0,NULL),(1385,171,0,NULL),(1385,172,0,NULL),(1385,173,0,NULL),(1385,174,0,NULL),(1385,187,NULL,0.1),(1385,192,2,NULL),(1385,196,1,NULL),(1385,219,1,NULL),(1385,355,1,NULL),(1385,356,0,NULL),(1385,359,1,NULL),(1385,360,0,NULL),(1385,361,0,NULL),(1385,362,1,NULL),(1385,363,1,NULL),(1385,364,1,NULL),(1385,365,0,NULL),(1385,366,1,NULL),(1385,368,1,NULL),(1385,369,NULL,1.25),(1385,378,NULL,0.75),(1385,385,1,NULL),(1385,387,2,NULL),(1385,388,100,NULL),(1385,389,100,NULL),(1385,392,100,NULL),(1385,393,100,NULL),(1385,394,100,NULL),(1385,395,100,NULL),(1385,396,1,NULL),(1385,397,0,NULL),(1385,398,1,NULL),(1385,399,0,NULL),(1385,400,1,NULL),(1385,401,1,NULL),(1385,402,1,NULL),(1385,404,1,NULL),(1385,406,1,NULL),(1385,417,0,NULL),(1385,426,1,NULL),(1385,428,100,NULL),(1385,435,1,NULL),(1385,442,1,NULL),(1385,443,1,NULL),(1385,444,NULL,0.45),(1385,445,NULL,0.1),(1385,458,20000,NULL),(1385,467,1,NULL),(1385,522,2,NULL),(1385,551,1,NULL),(1385,625,0,NULL),(1385,626,1,NULL),(1385,723,NULL,0.9),(1385,1021,15000,NULL),(1385,1022,1,NULL),(1385,1267,10,NULL),(1385,1277,NULL,0.5),(1386,164,0,NULL),(1386,165,0,NULL),(1386,166,0,NULL),(1386,167,0,NULL),(1386,168,0,NULL),(1386,170,0,NULL),(1386,171,0,NULL),(1386,172,0,NULL),(1386,173,0,NULL),(1386,174,0,NULL),(1386,187,NULL,0.1),(1386,192,2,NULL),(1386,196,1,NULL),(1386,219,1,NULL),(1386,355,1,NULL),(1386,356,0,NULL),(1386,359,1,NULL),(1386,360,0,NULL),(1386,361,0,NULL),(1386,362,1,NULL),(1386,363,1,NULL),(1386,364,1,NULL),(1386,365,0,NULL),(1386,366,1,NULL),(1386,368,1,NULL),(1386,369,NULL,1.25),(1386,378,NULL,0.75),(1386,385,1,NULL),(1386,387,2,NULL),(1386,388,100,NULL),(1386,389,100,NULL),(1386,392,100,NULL),(1386,393,100,NULL),(1386,394,100,NULL),(1386,395,100,NULL),(1386,396,1,NULL),(1386,397,0,NULL),(1386,398,1,NULL),(1386,399,0,NULL),(1386,400,1,NULL),(1386,401,1,NULL),(1386,402,1,NULL),(1386,404,1,NULL),(1386,406,1,NULL),(1386,417,0,NULL),(1386,426,1,NULL),(1386,428,100,NULL),(1386,435,1,NULL),(1386,442,1,NULL),(1386,443,1,NULL),(1386,444,NULL,0.45),(1386,445,NULL,0.1),(1386,458,20000,NULL),(1386,467,1,NULL),(1386,522,2,NULL),(1386,551,1,NULL),(1386,625,0,NULL),(1386,626,1,NULL),(1386,723,NULL,0.9),(1386,1021,15000,NULL),(1386,1022,1,NULL),(1386,1267,10,NULL),(1386,1277,NULL,0.5),(1401,9,40,NULL),(1401,169,NULL,-13.3),(1401,182,3392,NULL),(1401,277,1,NULL),(1401,422,1,NULL),(1401,554,10,NULL),(1401,633,0,NULL),(1403,9,40,NULL),(1403,169,NULL,-16.7),(1403,182,3394,NULL),(1403,277,1,NULL),(1403,422,1,NULL),(1403,554,10,NULL),(1403,633,0,NULL),(1404,9,1,NULL),(1404,422,1,NULL),(1405,9,40,NULL),(1405,169,-20,NULL),(1405,182,3394,NULL),(1405,277,2,NULL),(1405,422,2,NULL),(1405,554,11,NULL),(1405,633,5,NULL),(1406,9,1,NULL),(1406,422,2,NULL),(1419,9,40,NULL),(1419,30,0,NULL),(1419,50,10,NULL),(1419,134,NULL,0.9),(1419,144,NULL,1.2),(1419,145,1,NULL),(1419,146,1,NULL),(1419,147,1,NULL),(1419,182,3424,NULL),(1419,277,1,NULL),(1419,422,1,NULL),(1419,633,0,NULL),(1422,9,40,NULL),(1422,30,0,NULL),(1422,50,22,NULL),(1422,134,NULL,0.76),(1422,144,NULL,1.35),(1422,145,1,NULL),(1422,146,1,NULL),(1422,147,1,NULL),(1422,182,3424,NULL),(1422,277,4,NULL),(1422,422,2,NULL),(1422,633,5,NULL),(1423,422,2,NULL),(1436,6,10,NULL),(1436,9,40,NULL),(1436,30,1,NULL),(1436,50,35,NULL),(1436,73,5000,NULL),(1436,143,60000,NULL),(1436,182,3429,NULL),(1436,235,3,NULL),(1436,277,4,NULL),(1436,422,2,NULL),(1436,633,5,NULL),(1437,422,2,NULL),(1445,9,40,NULL),(1445,30,0,NULL),(1445,50,4,NULL),(1445,144,NULL,0.8),(1445,145,1,NULL),(1445,146,1,NULL),(1445,147,1,NULL),(1445,182,3424,NULL),(1445,277,2,NULL),(1445,422,1,NULL),(1445,548,-10,NULL),(1445,633,0,NULL),(1446,422,1,NULL),(1447,9,40,NULL),(1447,30,0,NULL),(1447,50,8,NULL),(1447,144,NULL,0.76),(1447,145,1,NULL),(1447,146,1,NULL),(1447,147,1,NULL),(1447,182,3424,NULL),(1447,277,4,NULL),(1447,422,2,NULL),(1447,548,-11,NULL),(1447,633,5,NULL),(1448,422,2,NULL),(1529,9,100000000,NULL),(1530,9,100000000,NULL),(1531,9,100000000,NULL),(1537,9,40,NULL),(1537,30,0,NULL),(1537,50,10,NULL),(1537,134,NULL,0.95),(1537,144,NULL,0.95),(1537,145,NULL,1.025),(1537,146,NULL,1.02),(1537,147,NULL,1.02),(1537,182,3424,NULL),(1537,277,1,NULL),(1537,422,1,NULL),(1537,633,0,NULL),(1539,9,40,NULL),(1539,30,0,NULL),(1539,50,20,NULL),(1539,134,NULL,0.925),(1539,144,NULL,0.925),(1539,145,NULL,1.05),(1539,146,NULL,1.04),(1539,147,NULL,1.04),(1539,182,3424,NULL),(1539,277,2,NULL),(1539,422,1,NULL),(1539,633,0,NULL),(1540,422,1,NULL),(1541,9,40,NULL),(1541,30,0,NULL),(1541,50,20,NULL),(1541,134,NULL,0.915),(1541,144,NULL,0.915),(1541,145,NULL,1.05),(1541,146,NULL,1.05),(1541,147,NULL,1.05),(1541,182,3424,NULL),(1541,277,4,NULL),(1541,422,2,NULL),(1541,633,5,NULL),(1542,422,2,NULL),(1547,6,30,NULL),(1547,9,40,NULL),(1547,30,8,NULL),(1547,50,30,NULL),(1547,73,10000,NULL),(1547,99,3000,NULL),(1547,116,50,NULL),(1547,182,3421,NULL),(1547,277,1,NULL),(1547,422,1,NULL),(1547,633,0,NULL),(1547,916,0,NULL),(1548,422,1,NULL),(1549,6,30,NULL),(1549,9,40,NULL),(1549,30,8,NULL),(1549,50,30,NULL),(1549,73,10000,NULL),(1549,99,3000,NULL),(1549,116,70,NULL),(1549,182,3421,NULL),(1549,277,3,NULL),(1549,422,2,NULL),(1549,633,5,NULL),(1549,916,0,NULL),(1550,422,2,NULL),(1551,6,30,NULL),(1551,9,40,NULL),(1551,30,8,NULL),(1551,50,30,NULL),(1551,73,10000,NULL),(1551,99,3000,NULL),(1551,117,50,NULL),(1551,182,3421,NULL),(1551,277,1,NULL),(1551,422,1,NULL),(1551,633,0,NULL),(1551,916,0,NULL),(1552,422,1,NULL),(1553,6,30,NULL),(1553,9,40,NULL),(1553,30,8,NULL),(1553,50,30,NULL),(1553,73,10000,NULL),(1553,99,3000,NULL),(1553,117,70,NULL),(1553,182,3421,NULL),(1553,277,3,NULL),(1553,422,2,NULL),(1553,633,5,NULL),(1553,916,0,NULL),(1554,422,2,NULL),(1557,6,30,NULL),(1557,9,40,NULL),(1557,30,8,NULL),(1557,50,30,NULL),(1557,73,10000,NULL),(1557,99,3000,NULL),(1557,118,50,NULL),(1557,182,3421,NULL),(1557,277,1,NULL),(1557,422,1,NULL),(1557,633,0,NULL),(1557,916,0,NULL),(1558,422,1,NULL),(1559,6,30,NULL),(1559,9,40,NULL),(1559,30,8,NULL),(1559,50,30,NULL),(1559,73,10000,NULL),(1559,99,3000,NULL),(1559,118,70,NULL),(1559,182,3421,NULL),(1559,277,3,NULL),(1559,422,2,NULL),(1559,633,5,NULL),(1559,916,0,NULL),(1560,422,2,NULL),(1563,6,30,NULL),(1563,9,40,NULL),(1563,30,8,NULL),(1563,50,30,NULL),(1563,73,10000,NULL),(1563,99,3000,NULL),(1563,114,50,NULL),(1563,182,3421,NULL),(1563,277,1,NULL),(1563,422,1,NULL),(1563,633,0,NULL),(1563,916,0,NULL),(1564,422,1,NULL),(1565,6,30,NULL),(1565,9,40,NULL),(1565,30,8,NULL),(1565,50,30,NULL),(1565,73,10000,NULL),(1565,99,3000,NULL),(1565,114,70,NULL),(1565,182,3421,NULL),(1565,277,3,NULL),(1565,422,2,NULL),(1565,633,5,NULL),(1565,916,0,NULL),(1566,422,2,NULL),(1603,205,NULL,1.03),(1605,203,NULL,0.9),(1607,187,NULL,0.8),(1608,204,NULL,0.9),(1611,202,NULL,0.8),(1616,222,NULL,-0.05),(1617,220,NULL,-0.05),(1620,205,NULL,1.02),(1621,169,NULL,1.05),(1623,207,NULL,1.1),(1625,213,NULL,0.05),(1640,216,NULL,1.05),(1642,205,NULL,0.95),(1650,231,NULL,-0.05),(1651,216,NULL,0.95),(1652,230,NULL,-0.05),(1653,202,NULL,0.95),(1654,228,NULL,-0.05),(1657,231,NULL,-0.05),(1658,216,NULL,0.95),(1659,230,NULL,-0.05),(1660,202,NULL,0.95),(1661,228,NULL,-0.05),(1663,231,NULL,-0.05),(1664,216,NULL,0.95),(1665,230,NULL,-0.05),(1666,202,NULL,0.95),(1667,228,NULL,-0.05),(1669,231,NULL,-0.05),(1670,216,NULL,0.95),(1671,230,NULL,-0.05),(1672,202,NULL,0.95),(1673,228,NULL,-0.05),(1675,230,NULL,0.05),(1676,231,NULL,0.05),(1677,231,NULL,0.05),(1678,232,NULL,0.05),(1679,229,NULL,0.05),(1680,228,NULL,0.05),(1798,9,40,NULL),(1798,30,0,NULL),(1798,50,10,NULL),(1798,72,0,NULL),(1798,182,3413,NULL),(1798,277,1,NULL),(1798,422,1,NULL),(1798,633,0,NULL),(1798,984,-25,NULL),(1798,985,0,NULL),(1798,986,0,NULL),(1798,987,0,NULL),(1800,9,40,NULL),(1800,30,0,NULL),(1800,50,10,NULL),(1800,72,0,NULL),(1800,182,3413,NULL),(1800,277,1,NULL),(1800,422,1,NULL),(1800,633,0,NULL),(1800,984,0,NULL),(1800,985,0,NULL),(1800,986,0,NULL),(1800,987,-25,NULL),(1802,9,40,NULL),(1802,30,0,NULL),(1802,50,10,NULL),(1802,72,0,NULL),(1802,182,3413,NULL),(1802,277,1,NULL),(1802,422,1,NULL),(1802,633,0,NULL),(1802,984,0,NULL),(1802,985,0,NULL),(1802,986,-25,NULL),(1802,987,0,NULL),(1804,9,40,NULL),(1804,30,0,NULL),(1804,50,10,NULL),(1804,72,0,NULL),(1804,182,3413,NULL),(1804,277,1,NULL),(1804,422,1,NULL),(1804,633,0,NULL),(1804,984,0,NULL),(1804,985,-25,NULL),(1804,986,0,NULL),(1804,987,0,NULL),(1808,9,40,NULL),(1808,30,1,NULL),(1808,50,25,NULL),(1808,72,0,NULL),(1808,182,3425,NULL),(1808,277,1,NULL),(1808,422,1,NULL),(1808,633,0,NULL),(1808,984,NULL,-32.5),(1808,985,0,NULL),(1808,986,0,NULL),(1808,987,0,NULL),(1809,422,1,NULL),(1810,9,70,NULL),(1810,37,3750,NULL),(1810,70,1000,NULL),(1810,107,0,NULL),(1810,108,35,NULL),(1810,114,0,NULL),(1810,116,0,NULL),(1810,117,56,NULL),(1810,118,0,NULL),(1810,137,509,NULL),(1810,182,3322,NULL),(1810,183,3321,NULL),(1810,184,3319,NULL),(1810,277,1,NULL),(1810,278,1,NULL),(1810,279,1,NULL),(1810,281,5000,NULL),(1810,422,1,NULL),(1810,525,NULL,0.75),(1810,612,0,NULL),(1810,613,0,NULL),(1810,644,1,NULL),(1810,653,170,NULL),(1810,654,50,NULL),(1810,655,1500,NULL),(1810,1353,NULL,2.8),(1810,1354,NULL,5.5),(1811,422,1,NULL),(1814,9,70,NULL),(1814,37,3750,NULL),(1814,70,1000,NULL),(1814,107,0,NULL),(1814,108,35,NULL),(1814,114,0,NULL),(1814,116,56,NULL),(1814,117,0,NULL),(1814,118,0,NULL),(1814,137,509,NULL),(1814,182,3322,NULL),(1814,183,3321,NULL),(1814,184,3319,NULL),(1814,277,1,NULL),(1814,278,1,NULL),(1814,279,1,NULL),(1814,281,5000,NULL),(1814,422,1,NULL),(1814,525,NULL,0.75),(1814,612,0,NULL),(1814,613,0,NULL),(1814,644,1,NULL),(1814,653,170,NULL),(1814,654,50,NULL),(1814,655,1500,NULL),(1814,1353,NULL,2.8),(1814,1354,NULL,5.5),(1815,422,1,NULL),(1816,9,70,NULL),(1816,37,3750,NULL),(1816,70,1000,NULL),(1816,107,0,NULL),(1816,108,35,NULL),(1816,114,0,NULL),(1816,116,0,NULL),(1816,117,0,NULL),(1816,118,56,NULL),(1816,137,509,NULL),(1816,182,3322,NULL),(1816,183,3321,NULL),(1816,184,3319,NULL),(1816,277,1,NULL),(1816,278,1,NULL),(1816,279,1,NULL),(1816,281,5000,NULL),(1816,422,1,NULL),(1816,525,NULL,0.75),(1816,612,0,NULL),(1816,613,0,NULL),(1816,644,1,NULL),(1816,653,170,NULL),(1816,654,50,NULL),(1816,655,1500,NULL),(1816,1353,NULL,2.8),(1816,1354,NULL,5.5),(1817,422,1,NULL),(1818,9,70,NULL),(1818,37,3750,NULL),(1818,70,1000,NULL),(1818,107,0,NULL),(1818,108,35,NULL),(1818,114,0,NULL),(1818,116,0,NULL),(1818,117,113,NULL),(1818,118,0,NULL),(1818,137,510,NULL),(1818,182,3322,NULL),(1818,183,3324,NULL),(1818,184,3319,NULL),(1818,277,1,NULL),(1818,278,1,NULL),(1818,279,1,NULL),(1818,281,10000,NULL),(1818,422,1,NULL),(1818,525,NULL,0.75),(1818,612,0,NULL),(1818,613,0,NULL),(1818,644,1,NULL),(1818,653,81,NULL),(1818,654,125,NULL),(1818,655,1500,NULL),(1818,1353,NULL,3.2),(1818,1354,NULL,5.5),(1819,422,1,NULL),(1820,9,70,NULL),(1820,37,3750,NULL),(1820,70,1000,NULL),(1820,107,0,NULL),(1820,108,35,NULL),(1820,114,113,NULL),(1820,116,0,NULL),(1820,117,0,NULL),(1820,118,0,NULL),(1820,137,510,NULL),(1820,182,3322,NULL),(1820,183,3324,NULL),(1820,184,3319,NULL),(1820,277,1,NULL),(1820,278,1,NULL),(1820,279,1,NULL),(1820,281,10000,NULL),(1820,422,1,NULL),(1820,525,NULL,0.75),(1820,612,0,NULL),(1820,613,0,NULL),(1820,644,1,NULL),(1820,653,81,NULL),(1820,654,125,NULL),(1820,655,1500,NULL),(1820,1353,NULL,3.2),(1820,1354,NULL,5.5),(1821,422,1,NULL),(1822,9,70,NULL),(1822,37,3750,NULL),(1822,70,1000,NULL),(1822,107,0,NULL),(1822,108,35,NULL),(1822,114,0,NULL),(1822,116,113,NULL),(1822,117,0,NULL),(1822,118,0,NULL),(1822,137,510,NULL),(1822,182,3322,NULL),(1822,183,3324,NULL),(1822,184,3319,NULL),(1822,277,1,NULL),(1822,278,1,NULL),(1822,279,1,NULL),(1822,281,10000,NULL),(1822,422,1,NULL),(1822,525,NULL,0.75),(1822,612,0,NULL),(1822,613,0,NULL),(1822,644,1,NULL),(1822,653,81,NULL),(1822,654,125,NULL),(1822,655,1500,NULL),(1822,1353,NULL,3.2),(1822,1354,NULL,5.5),(1823,422,1,NULL),(1824,9,70,NULL),(1824,37,3750,NULL),(1824,70,1000,NULL),(1824,107,0,NULL),(1824,108,35,NULL),(1824,114,0,NULL),(1824,116,0,NULL),(1824,117,0,NULL),(1824,118,113,NULL),(1824,137,510,NULL),(1824,182,3322,NULL),(1824,183,3324,NULL),(1824,184,3319,NULL),(1824,277,1,NULL),(1824,278,1,NULL),(1824,279,1,NULL),(1824,281,10000,NULL),(1824,422,1,NULL),(1824,525,NULL,0.75),(1824,612,0,NULL),(1824,613,0,NULL),(1824,644,1,NULL),(1824,653,81,NULL),(1824,654,125,NULL),(1824,655,1500,NULL),(1824,1353,NULL,3.2),(1824,1354,NULL,5.5),(1825,422,1,NULL),(1826,9,70,NULL),(1826,37,3750,NULL),(1826,70,1000,NULL),(1826,107,0,NULL),(1826,108,35,NULL),(1826,114,0,NULL),(1826,116,0,NULL),(1826,117,225,NULL),(1826,118,0,NULL),(1826,137,506,NULL),(1826,182,3322,NULL),(1826,183,3326,NULL),(1826,184,3319,NULL),(1826,277,1,NULL),(1826,278,1,NULL),(1826,279,1,NULL),(1826,281,20000,NULL),(1826,422,1,NULL),(1826,525,NULL,0.75),(1826,612,0,NULL),(1826,613,0,NULL),(1826,644,1,NULL),(1826,653,69,NULL),(1826,654,300,NULL),(1826,655,1500,NULL),(1826,1353,NULL,4.5),(1826,1354,NULL,5.5),(1827,422,1,NULL),(1828,9,70,NULL),(1828,37,3750,NULL),(1828,70,1000,NULL),(1828,107,0,NULL),(1828,108,35,NULL),(1828,114,225,NULL),(1828,116,0,NULL),(1828,117,0,NULL),(1828,118,0,NULL),(1828,137,506,NULL),(1828,182,3322,NULL),(1828,183,3326,NULL),(1828,184,3319,NULL),(1828,277,1,NULL),(1828,278,1,NULL),(1828,279,1,NULL),(1828,281,20000,NULL),(1828,422,1,NULL),(1828,525,NULL,0.75),(1828,612,0,NULL),(1828,613,0,NULL),(1828,644,1,NULL),(1828,653,69,NULL),(1828,654,300,NULL),(1828,655,1500,NULL),(1828,1353,NULL,4.5),(1828,1354,NULL,5.5),(1829,422,1,NULL),(1830,9,70,NULL),(1830,37,3750,NULL),(1830,70,1000,NULL),(1830,107,0,NULL),(1830,108,35,NULL),(1830,114,0,NULL),(1830,116,225,NULL),(1830,117,0,NULL),(1830,118,0,NULL),(1830,137,506,NULL),(1830,182,3322,NULL),(1830,183,3326,NULL),(1830,184,3319,NULL),(1830,277,1,NULL),(1830,278,1,NULL),(1830,279,1,NULL),(1830,281,20000,NULL),(1830,422,1,NULL),(1830,525,NULL,0.75),(1830,612,0,NULL),(1830,613,0,NULL),(1830,644,1,NULL),(1830,653,69,NULL),(1830,654,300,NULL),(1830,655,1500,NULL),(1830,1353,NULL,4.5),(1830,1354,NULL,5.5),(1831,422,1,NULL),(1832,9,70,NULL),(1832,37,3750,NULL),(1832,70,1000,NULL),(1832,107,0,NULL),(1832,108,35,NULL),(1832,114,0,NULL),(1832,116,0,NULL),(1832,117,0,NULL),(1832,118,225,NULL),(1832,137,506,NULL),(1832,182,3322,NULL),(1832,183,3326,NULL),(1832,184,3319,NULL),(1832,277,1,NULL),(1832,278,1,NULL),(1832,279,1,NULL),(1832,281,20000,NULL),(1832,422,1,NULL),(1832,525,NULL,0.75),(1832,612,0,NULL),(1832,613,0,NULL),(1832,644,1,NULL),(1832,653,69,NULL),(1832,654,300,NULL),(1832,655,1500,NULL),(1832,1353,NULL,4.5),(1832,1354,NULL,5.5),(1833,422,1,NULL),(1855,6,5,NULL),(1855,9,40,NULL),(1855,30,1,NULL),(1855,47,1,NULL),(1855,50,17,NULL),(1855,73,1500,NULL),(1855,125,60000,NULL),(1855,182,3426,NULL),(1855,277,2,NULL),(1855,422,2,NULL),(1855,510,36000,NULL),(1855,633,5,NULL),(1855,1014,1,NULL),(1856,422,2,NULL),(1875,9,40,NULL),(1875,30,50,NULL),(1875,47,1,NULL),(1875,50,35,NULL),(1875,51,12000,NULL),(1875,56,1,NULL),(1875,182,3319,NULL),(1875,277,1,NULL),(1875,422,1,NULL),(1875,604,384,NULL),(1875,605,394,NULL),(1875,606,88,NULL),(1875,633,0,NULL),(1875,1180,NULL,0.01),(1875,1205,-15,NULL),(1875,1211,NULL,1.8),(1875,1212,1,NULL),(1876,422,1,NULL),(1877,9,40,NULL),(1877,30,53,NULL),(1877,47,1,NULL),(1877,50,39,NULL),(1877,51,9600,NULL),(1877,56,1,NULL),(1877,182,3319,NULL),(1877,183,20210,NULL),(1877,277,3,NULL),(1877,278,1,NULL),(1877,422,2,NULL),(1877,604,384,NULL),(1877,605,394,NULL),(1877,606,88,NULL),(1877,609,653,NULL),(1877,633,5,NULL),(1877,1180,NULL,0.02),(1877,1205,-15,NULL),(1877,1211,NULL,1.4),(1877,1212,1,NULL),(1878,422,2,NULL),(1893,9,40,NULL),(1893,30,1,NULL),(1893,50,20,NULL),(1893,64,NULL,1.05),(1893,182,3318,NULL),(1893,204,NULL,0.95),(1893,277,1,NULL),(1893,422,1,NULL),(1893,633,0,NULL),(1894,6,50,NULL),(1894,9,40,NULL),(1894,30,10,NULL),(1894,50,10,NULL),(1894,73,6000,NULL),(1894,97,50,NULL),(1894,98,6500,NULL),(1894,182,3423,NULL),(1894,277,3,NULL),(1894,422,2,NULL),(1894,633,5,NULL),(1894,918,0,NULL),(1894,1015,NULL,0.852941176),(1894,1016,NULL,0.958333333),(1894,1017,NULL,0.989583333),(1894,1018,NULL,0.852941176),(1894,1019,NULL,0.958333333),(1894,1020,NULL,0.989583333),(1894,1180,NULL,0.02),(1894,1206,-15,NULL),(1894,1211,NULL,2.6),(1894,1212,1,NULL),(1896,3,0,NULL),(1896,9,438,NULL),(1896,11,50,NULL),(1896,12,3,NULL),(1896,13,3,NULL),(1896,14,4,NULL),(1896,15,0,NULL),(1896,19,1,NULL),(1896,21,0,NULL),(1896,37,525,NULL),(1896,48,500,NULL),(1896,49,0,NULL),(1896,55,187500,NULL),(1896,70,NULL,3.1),(1896,76,15000,NULL),(1896,79,2500,NULL),(1896,101,2,NULL),(1896,102,2,NULL),(1896,109,1,NULL),(1896,110,1,NULL),(1896,111,1,NULL),(1896,113,1,NULL),(1896,124,16777215,NULL),(1896,129,3,NULL),(1896,136,1,NULL),(1896,153,NULL,1.67e-006),(1896,182,3755,NULL),(1896,192,4,NULL),(1896,208,100,NULL),(1896,209,100,NULL),(1896,210,100,NULL),(1896,211,100,NULL),(1896,217,395,NULL),(1896,246,395,NULL),(1896,263,438,NULL),(1896,265,438,NULL),(1896,267,NULL,0.4),(1896,268,NULL,0.675),(1896,269,NULL,0.5625),(1896,270,NULL,0.4875),(1896,271,NULL,0.75),(1896,272,NULL,0.4),(1896,273,NULL,0.45),(1896,274,NULL,0.6),(1896,277,5,NULL),(1896,283,20,NULL),(1896,422,1,NULL),(1896,479,625000,NULL),(1896,482,NULL,312.5),(1896,484,NULL,0.75),(1896,511,0,NULL),(1896,524,NULL,0.75),(1896,525,NULL,0.75),(1896,552,18,NULL),(1896,564,1500,NULL),(1896,600,NULL,4.5),(1896,633,0,NULL),(1896,661,3000,NULL),(1896,662,NULL,0.05),(1896,1132,400,NULL),(1896,1137,3,NULL),(1896,1154,3,NULL),(1896,1178,100,NULL),(1896,1179,NULL,0.01),(1896,1196,NULL,0.01),(1896,1198,NULL,0.01),(1896,1199,100,NULL),(1896,1200,100,NULL),(1896,1224,1,NULL),(1896,1259,NULL,0.63),(1896,1261,NULL,0.5),(1896,1262,NULL,0.5),(1896,1271,20,NULL),(1896,1281,1,NULL),(1898,3,0,NULL),(1898,9,500,NULL),(1898,11,50,NULL),(1898,12,3,NULL),(1898,13,3,NULL),(1898,14,4,NULL),(1898,15,0,NULL),(1898,19,1,NULL),(1898,21,0,NULL),(1898,37,475,NULL),(1898,48,500,NULL),(1898,49,0,NULL),(1898,55,187500,NULL),(1898,70,NULL,3.1),(1898,76,15000,NULL),(1898,79,2500,NULL),(1898,101,2,NULL),(1898,102,2,NULL),(1898,109,1,NULL),(1898,110,1,NULL),(1898,111,1,NULL),(1898,113,1,NULL),(1898,124,16777215,NULL),(1898,129,3,NULL),(1898,136,1,NULL),(1898,153,NULL,1.67e-006),(1898,182,3755,NULL),(1898,192,4,NULL),(1898,208,100,NULL),(1898,209,100,NULL),(1898,210,100,NULL),(1898,211,100,NULL),(1898,217,395,NULL),(1898,246,395,NULL),(1898,263,500,NULL),(1898,265,500,NULL),(1898,267,NULL,0.4),(1898,268,NULL,0.675),(1898,269,NULL,0.5625),(1898,270,NULL,0.4875),(1898,271,1,NULL),(1898,272,NULL,0.5),(1898,273,NULL,0.6),(1898,274,NULL,0.8),(1898,277,5,NULL),(1898,283,20,NULL),(1898,422,1,NULL),(1898,479,625000,NULL),(1898,482,375,NULL),(1898,484,NULL,0.75),(1898,511,0,NULL),(1898,524,NULL,0.75),(1898,525,NULL,0.75),(1898,552,20,NULL),(1898,564,1250,NULL),(1898,600,4,NULL),(1898,633,0,NULL),(1898,661,3000,NULL),(1898,662,NULL,0.05),(1898,1132,400,NULL),(1898,1137,3,NULL),(1898,1154,3,NULL),(1898,1178,100,NULL),(1898,1179,NULL,0.01),(1898,1196,NULL,0.01),(1898,1198,NULL,0.01),(1898,1199,100,NULL),(1898,1200,100,NULL),(1898,1224,1,NULL),(1898,1259,NULL,0.63),(1898,1261,NULL,0.5),(1898,1262,NULL,0.5),(1898,1271,20,NULL),(1898,1281,1,NULL),(1900,3,0,NULL),(1900,9,563,NULL),(1900,11,50,NULL),(1900,12,3,NULL),(1900,13,3,NULL),(1900,14,4,NULL),(1900,15,0,NULL),(1900,19,1,NULL),(1900,21,0,NULL),(1900,37,375,NULL),(1900,48,500,NULL),(1900,49,0,NULL),(1900,55,187500,NULL),(1900,70,NULL,3.1),(1900,76,15000,NULL),(1900,79,2500,NULL),(1900,101,2,NULL),(1900,102,2,NULL),(1900,109,1,NULL),(1900,110,1,NULL),(1900,111,1,NULL),(1900,113,1,NULL),(1900,124,16777215,NULL),(1900,129,3,NULL),(1900,136,1,NULL),(1900,153,NULL,1.67e-006),(1900,182,3755,NULL),(1900,192,4,NULL),(1900,208,100,NULL),(1900,209,100,NULL),(1900,210,100,NULL),(1900,211,100,NULL),(1900,217,395,NULL),(1900,246,395,NULL),(1900,263,563,NULL),(1900,265,563,NULL),(1900,267,NULL,0.3),(1900,268,NULL,0.45),(1900,269,NULL,0.375),(1900,270,NULL,0.325),(1900,271,NULL,0.5),(1900,272,NULL,0.3),(1900,273,NULL,0.3),(1900,274,NULL,0.4),(1900,277,5,NULL),(1900,283,25,NULL),(1900,422,1,NULL),(1900,479,625000,NULL),(1900,482,NULL,437.5),(1900,484,NULL,0.75),(1900,511,0,NULL),(1900,524,NULL,0.75),(1900,525,NULL,0.75),(1900,552,30,NULL),(1900,564,1000,NULL),(1900,600,NULL,2.5),(1900,633,0,NULL),(1900,661,3000,NULL),(1900,662,NULL,0.05),(1900,1132,400,NULL),(1900,1137,3,NULL),(1900,1154,3,NULL),(1900,1178,100,NULL),(1900,1179,NULL,0.01),(1900,1196,NULL,0.01),(1900,1198,NULL,0.01),(1900,1199,100,NULL),(1900,1200,100,NULL),(1900,1224,1,NULL),(1900,1259,NULL,0.63),(1900,1261,NULL,0.5),(1900,1262,NULL,0.5),(1900,1271,25,NULL),(1900,1281,1,NULL),(1902,3,0,NULL),(1902,9,625,NULL),(1902,11,50,NULL),(1902,12,3,NULL),(1902,13,3,NULL),(1902,14,4,NULL),(1902,15,0,NULL),(1902,19,1,NULL),(1902,21,0,NULL),(1902,37,325,NULL),(1902,48,500,NULL),(1902,49,0,NULL),(1902,55,187500,NULL),(1902,70,NULL,3.1),(1902,76,15000,NULL),(1902,79,2500,NULL),(1902,101,2,NULL),(1902,102,2,NULL),(1902,109,1,NULL),(1902,110,1,NULL),(1902,111,1,NULL),(1902,113,1,NULL),(1902,124,16777215,NULL),(1902,129,3,NULL),(1902,136,1,NULL),(1902,153,NULL,1.67e-006),(1902,182,3755,NULL),(1902,192,4,NULL),(1902,208,100,NULL),(1902,209,100,NULL),(1902,210,100,NULL),(1902,211,100,NULL),(1902,217,395,NULL),(1902,246,395,NULL),(1902,263,625,NULL),(1902,265,625,NULL),(1902,267,NULL,0.3),(1902,268,NULL,0.45),(1902,269,NULL,0.375),(1902,270,NULL,0.325),(1902,271,NULL,0.5),(1902,272,NULL,0.3),(1902,273,NULL,0.3),(1902,274,NULL,0.4),(1902,277,5,NULL),(1902,283,25,NULL),(1902,422,1,NULL),(1902,479,625000,NULL),(1902,482,500,NULL),(1902,484,NULL,0.75),(1902,511,0,NULL),(1902,524,NULL,0.75),(1902,525,NULL,0.75),(1902,552,35,NULL),(1902,564,750,NULL),(1902,600,2,NULL),(1902,633,0,NULL),(1902,661,3000,NULL),(1902,662,NULL,0.05),(1902,1132,400,NULL),(1902,1137,3,NULL),(1902,1154,3,NULL),(1902,1178,100,NULL),(1902,1179,NULL,0.01),(1902,1196,NULL,0.01),(1902,1198,NULL,0.01),(1902,1199,100,NULL),(1902,1200,100,NULL),(1902,1224,1,NULL),(1902,1259,NULL,0.63),(1902,1261,NULL,0.5),(1902,1262,NULL,0.5),(1902,1271,25,NULL),(1902,1281,1,NULL),(1904,3,0,NULL),(1904,9,1750,NULL),(1904,11,1500,NULL),(1904,12,4,NULL),(1904,13,4,NULL),(1904,14,6,NULL),(1904,15,0,NULL),(1904,19,1,NULL),(1904,21,0,NULL),(1904,37,300,NULL),(1904,48,750,NULL),(1904,49,0,NULL),(1904,55,328125,NULL),(1904,70,NULL,0.65),(1904,76,50000,NULL),(1904,79,4500,NULL),(1904,101,4,NULL),(1904,102,4,NULL),(1904,109,1,NULL),(1904,110,1,NULL),(1904,111,1,NULL),(1904,113,1,NULL),(1904,124,16777215,NULL),(1904,129,500,NULL),(1904,136,1,NULL),(1904,153,NULL,8.13e-007),(1904,182,3335,NULL),(1904,192,6,NULL),(1904,208,100,NULL),(1904,209,100,NULL),(1904,210,100,NULL),(1904,211,100,NULL),(1904,217,395,NULL),(1904,246,395,NULL),(1904,263,1750,NULL),(1904,265,1750,NULL),(1904,267,NULL,0.4),(1904,268,NULL,0.675),(1904,269,NULL,0.5625),(1904,270,NULL,0.4875),(1904,271,NULL,0.75),(1904,272,NULL,0.4),(1904,273,NULL,0.45),(1904,274,NULL,0.6),(1904,277,1,NULL),(1904,283,45,NULL),(1904,422,1,NULL),(1904,479,1250000,NULL),(1904,482,1500,NULL),(1904,484,NULL,0.75),(1904,524,NULL,0.75),(1904,525,NULL,0.75),(1904,552,100,NULL),(1904,564,400,NULL),(1904,600,NULL,1.75),(1904,633,0,NULL),(1904,661,2000,NULL),(1904,662,NULL,0.25),(1904,1132,300,NULL),(1904,1137,3,NULL),(1904,1154,3,NULL),(1904,1178,100,NULL),(1904,1179,NULL,0.01),(1904,1196,NULL,0.01),(1904,1198,NULL,0.01),(1904,1199,100,NULL),(1904,1200,100,NULL),(1904,1224,NULL,0.75),(1904,1259,NULL,0.76),(1904,1261,NULL,0.63),(1904,1262,NULL,0.63),(1904,1271,45,NULL),(1904,1281,1,NULL),(1906,3,0,NULL),(1906,9,2000,NULL),(1906,11,1500,NULL),(1906,12,4,NULL),(1906,13,4,NULL),(1906,14,6,NULL),(1906,15,0,NULL),(1906,19,1,NULL),(1906,21,0,NULL),(1906,37,275,NULL),(1906,48,750,NULL),(1906,49,0,NULL),(1906,55,328125,NULL),(1906,70,NULL,0.65),(1906,76,50000,NULL),(1906,79,4500,NULL),(1906,101,4,NULL),(1906,102,4,NULL),(1906,109,1,NULL),(1906,110,1,NULL),(1906,111,1,NULL),(1906,113,1,NULL),(1906,124,16777215,NULL),(1906,129,500,NULL),(1906,136,1,NULL),(1906,153,NULL,8.13e-007),(1906,182,3335,NULL),(1906,192,6,NULL),(1906,208,100,NULL),(1906,209,100,NULL),(1906,210,100,NULL),(1906,211,100,NULL),(1906,217,395,NULL),(1906,246,395,NULL),(1906,263,2000,NULL),(1906,265,2000,NULL),(1906,267,NULL,0.4),(1906,268,NULL,0.675),(1906,269,NULL,0.5625),(1906,270,NULL,0.4875),(1906,271,1,NULL),(1906,272,NULL,0.5),(1906,273,NULL,0.6),(1906,274,NULL,0.8),(1906,277,1,NULL),(1906,283,55,NULL),(1906,422,1,NULL),(1906,479,1250000,NULL),(1906,482,1625,NULL),(1906,484,NULL,0.75),(1906,524,NULL,0.75),(1906,525,NULL,0.75),(1906,552,110,NULL),(1906,564,350,NULL),(1906,600,NULL,1.5),(1906,633,0,NULL),(1906,661,2000,NULL),(1906,662,NULL,0.25),(1906,1132,300,NULL),(1906,1137,3,NULL),(1906,1154,3,NULL),(1906,1178,100,NULL),(1906,1179,NULL,0.01),(1906,1196,NULL,0.01),(1906,1198,NULL,0.01),(1906,1199,100,NULL),(1906,1200,100,NULL),(1906,1224,NULL,0.75),(1906,1259,NULL,0.76),(1906,1261,NULL,0.63),(1906,1262,NULL,0.63),(1906,1271,50,NULL),(1906,1281,1,NULL),(1908,3,0,NULL),(1908,9,2250,NULL),(1908,11,1500,NULL),(1908,12,4,NULL),(1908,13,4,NULL),(1908,14,6,NULL),(1908,15,0,NULL),(1908,19,1,NULL),(1908,21,0,NULL),(1908,37,245,NULL),(1908,48,750,NULL),(1908,49,0,NULL),(1908,55,328125,NULL),(1908,70,NULL,0.65),(1908,76,50000,NULL),(1908,79,4500,NULL),(1908,101,4,NULL),(1908,102,4,NULL),(1908,109,1,NULL),(1908,110,1,NULL),(1908,111,1,NULL),(1908,113,1,NULL),(1908,124,16777215,NULL),(1908,129,500,NULL),(1908,136,1,NULL),(1908,153,NULL,8.13e-007),(1908,182,3335,NULL),(1908,192,6,NULL),(1908,208,100,NULL),(1908,209,100,NULL),(1908,210,100,NULL),(1908,211,100,NULL),(1908,217,395,NULL),(1908,246,395,NULL),(1908,263,2250,NULL),(1908,265,2250,NULL),(1908,267,NULL,0.3),(1908,268,NULL,0.45),(1908,269,NULL,0.375),(1908,270,NULL,0.325),(1908,271,NULL,0.5),(1908,272,NULL,0.3),(1908,273,NULL,0.3),(1908,274,NULL,0.4),(1908,277,1,NULL),(1908,283,65,NULL),(1908,422,1,NULL),(1908,479,1250000,NULL),(1908,482,1750,NULL),(1908,484,NULL,0.75),(1908,524,NULL,0.75),(1908,525,NULL,0.75),(1908,552,140,NULL),(1908,564,300,NULL),(1908,600,NULL,1.25),(1908,633,0,NULL),(1908,661,2000,NULL),(1908,662,NULL,0.25),(1908,1132,300,NULL),(1908,1137,3,NULL),(1908,1154,3,NULL),(1908,1178,100,NULL),(1908,1179,NULL,0.01),(1908,1196,NULL,0.01),(1908,1198,NULL,0.01),(1908,1199,100,NULL),(1908,1200,100,NULL),(1908,1224,NULL,0.75),(1908,1259,NULL,0.76),(1908,1261,NULL,0.63),(1908,1262,NULL,0.63),(1908,1271,50,NULL),(1908,1281,1,NULL),(1910,3,0,NULL),(1910,9,2500,NULL),(1910,11,1500,NULL),(1910,12,4,NULL),(1910,13,4,NULL),(1910,14,6,NULL),(1910,15,0,NULL),(1910,19,1,NULL),(1910,21,0,NULL),(1910,37,220,NULL),(1910,48,750,NULL),(1910,49,0,NULL),(1910,55,328125,NULL),(1910,70,NULL,0.65),(1910,76,50000,NULL),(1910,79,4500,NULL),(1910,101,4,NULL),(1910,102,4,NULL),(1910,109,1,NULL),(1910,110,1,NULL),(1910,111,1,NULL),(1910,113,1,NULL),(1910,124,16777215,NULL),(1910,129,500,NULL),(1910,136,1,NULL),(1910,153,NULL,8.13e-007),(1910,182,3335,NULL),(1910,192,6,NULL),(1910,208,100,NULL),(1910,209,100,NULL),(1910,210,100,NULL),(1910,211,100,NULL),(1910,217,395,NULL),(1910,246,395,NULL),(1910,263,2500,NULL),(1910,265,2500,NULL),(1910,267,NULL,0.3),(1910,268,NULL,0.45),(1910,269,NULL,0.375),(1910,270,NULL,0.325),(1910,271,NULL,0.5),(1910,272,NULL,0.3),(1910,273,NULL,0.3),(1910,274,NULL,0.4),(1910,277,1,NULL),(1910,283,75,NULL),(1910,422,1,NULL),(1910,479,1250000,NULL),(1910,482,1875,NULL),(1910,484,NULL,0.75),(1910,524,NULL,0.75),(1910,525,NULL,0.75),(1910,552,150,NULL),(1910,564,250,NULL),(1910,600,1,NULL),(1910,633,0,NULL),(1910,661,2000,NULL),(1910,662,NULL,0.25),(1910,1132,300,NULL),(1910,1137,3,NULL),(1910,1154,3,NULL),(1910,1178,100,NULL),(1910,1179,NULL,0.01),(1910,1196,NULL,0.01),(1910,1198,NULL,0.01),(1910,1199,100,NULL),(1910,1200,100,NULL),(1910,1224,NULL,0.75),(1910,1259,NULL,0.76),(1910,1261,NULL,0.63),(1910,1262,NULL,0.63),(1910,1271,50,NULL),(1910,1281,1,NULL),(1912,3,0,NULL),(1912,9,6875,NULL),(1912,11,25000,NULL),(1912,12,6,NULL),(1912,13,6,NULL),(1912,14,8,NULL),(1912,15,0,NULL),(1912,19,1,NULL),(1912,21,0,NULL),(1912,37,160,NULL),(1912,48,1000,NULL),(1912,49,0,NULL),(1912,55,703125,NULL),(1912,70,NULL,0.155),(1912,76,100000,NULL),(1912,79,2000,NULL),(1912,101,5,NULL),(1912,102,5,NULL),(1912,109,1,NULL),(1912,110,1,NULL),(1912,111,1,NULL),(1912,113,1,NULL),(1912,124,16777215,NULL),(1912,129,1000,NULL),(1912,136,1,NULL),(1912,153,NULL,1.38e-007),(1912,182,10264,NULL),(1912,192,8,NULL),(1912,208,100,NULL),(1912,209,100,NULL),(1912,210,100,NULL),(1912,211,100,NULL),(1912,217,395,NULL),(1912,246,395,NULL),(1912,263,6875,NULL),(1912,265,6875,NULL),(1912,267,NULL,0.4),(1912,268,NULL,0.675),(1912,269,NULL,0.5625),(1912,270,NULL,0.4875),(1912,271,NULL,0.75),(1912,272,NULL,0.4),(1912,273,NULL,0.45),(1912,274,NULL,0.6),(1912,277,3,NULL),(1912,283,200,NULL),(1912,479,2500000,NULL),(1912,482,5625,NULL),(1912,484,NULL,0.5),(1912,524,NULL,0.75),(1912,525,NULL,0.75),(1912,552,400,NULL),(1912,564,150,NULL),(1912,600,1,NULL),(1912,633,0,NULL),(1912,661,1000,NULL),(1912,662,NULL,0.5),(1912,1132,400,NULL),(1912,1137,3,NULL),(1912,1154,3,NULL),(1912,1178,100,NULL),(1912,1179,NULL,0.01),(1912,1196,NULL,0.01),(1912,1198,NULL,0.01),(1912,1199,100,NULL),(1912,1200,100,NULL),(1912,1224,NULL,0.5),(1912,1259,NULL,0.82),(1912,1261,NULL,0.76),(1912,1262,NULL,0.76),(1912,1271,125,NULL),(1912,1281,1,NULL),(1914,3,0,NULL),(1914,9,8750,NULL),(1914,11,25000,NULL),(1914,12,6,NULL),(1914,13,6,NULL),(1914,14,8,NULL),(1914,15,0,NULL),(1914,19,1,NULL),(1914,21,0,NULL),(1914,37,100,NULL),(1914,48,1000,NULL),(1914,49,0,NULL),(1914,55,703125,NULL),(1914,70,NULL,0.155),(1914,76,100000,NULL),(1914,79,2000,NULL),(1914,101,5,NULL),(1914,102,5,NULL),(1914,109,1,NULL),(1914,110,1,NULL),(1914,111,1,NULL),(1914,113,1,NULL),(1914,124,16777215,NULL),(1914,129,1000,NULL),(1914,136,1,NULL),(1914,153,NULL,1.38e-007),(1914,182,10264,NULL),(1914,192,8,NULL),(1914,208,100,NULL),(1914,209,100,NULL),(1914,210,100,NULL),(1914,211,100,NULL),(1914,217,395,NULL),(1914,246,395,NULL),(1914,263,8750,NULL),(1914,265,8750,NULL),(1914,267,NULL,0.3),(1914,268,NULL,0.45),(1914,269,NULL,0.375),(1914,270,NULL,0.325),(1914,271,NULL,0.5),(1914,272,NULL,0.3),(1914,273,NULL,0.3),(1914,274,NULL,0.4),(1914,277,3,NULL),(1914,283,500,NULL),(1914,479,2500000,NULL),(1914,482,7500,NULL),(1914,484,NULL,0.5),(1914,524,NULL,0.75),(1914,525,NULL,0.75),(1914,552,400,NULL),(1914,564,100,NULL),(1914,600,1,NULL),(1914,633,0,NULL),(1914,661,1000,NULL),(1914,662,NULL,0.5),(1914,1132,400,NULL),(1914,1137,3,NULL),(1914,1154,3,NULL),(1914,1178,100,NULL),(1914,1179,NULL,0.01),(1914,1196,NULL,0.01),(1914,1198,NULL,0.01),(1914,1199,100,NULL),(1914,1200,100,NULL),(1914,1224,NULL,0.5),(1914,1259,NULL,0.82),(1914,1261,NULL,0.76),(1914,1262,NULL,0.76),(1914,1271,125,NULL),(1914,1281,1,NULL),(1916,3,0,NULL),(1916,9,7500,NULL),(1916,11,25000,NULL),(1916,12,6,NULL),(1916,13,6,NULL),(1916,14,8,NULL),(1916,15,0,NULL),(1916,19,1,NULL),(1916,21,0,NULL),(1916,37,140,NULL),(1916,48,1000,NULL),(1916,49,0,NULL),(1916,55,703125,NULL),(1916,70,NULL,0.155),(1916,76,100000,NULL),(1916,79,2000,NULL),(1916,101,5,NULL),(1916,102,5,NULL),(1916,109,1,NULL),(1916,110,1,NULL),(1916,111,1,NULL),(1916,113,1,NULL),(1916,124,16777215,NULL),(1916,129,1000,NULL),(1916,136,1,NULL),(1916,153,NULL,1.38e-007),(1916,182,10264,NULL),(1916,192,8,NULL),(1916,208,100,NULL),(1916,209,100,NULL),(1916,210,100,NULL),(1916,211,100,NULL),(1916,217,395,NULL),(1916,246,395,NULL),(1916,263,7500,NULL),(1916,265,7500,NULL),(1916,267,NULL,0.4),(1916,268,NULL,0.675),(1916,269,NULL,0.5625),(1916,270,NULL,0.4875),(1916,271,1,NULL),(1916,272,NULL,0.5),(1916,273,NULL,0.6),(1916,274,NULL,0.8),(1916,277,3,NULL),(1916,283,250,NULL),(1916,479,2500000,NULL),(1916,482,6250,NULL),(1916,484,NULL,0.5),(1916,524,NULL,0.75),(1916,525,NULL,0.75),(1916,552,400,NULL),(1916,564,140,NULL),(1916,600,1,NULL),(1916,633,0,NULL),(1916,661,1000,NULL),(1916,662,NULL,0.5),(1916,1132,400,NULL),(1916,1137,3,NULL),(1916,1154,3,NULL),(1916,1178,100,NULL),(1916,1179,NULL,0.01),(1916,1196,NULL,0.01),(1916,1198,NULL,0.01),(1916,1199,100,NULL),(1916,1200,100,NULL),(1916,1224,NULL,0.5),(1916,1259,NULL,0.82),(1916,1261,NULL,0.76),(1916,1262,NULL,0.76),(1916,1271,125,NULL),(1916,1281,1,NULL),(1918,3,0,NULL),(1918,9,8125,NULL),(1918,11,25000,NULL),(1918,12,6,NULL),(1918,13,6,NULL),(1918,14,8,NULL),(1918,15,0,NULL),(1918,19,1,NULL),(1918,21,0,NULL),(1918,37,120,NULL),(1918,48,1000,NULL),(1918,49,0,NULL),(1918,55,703125,NULL),(1918,70,NULL,0.155),(1918,76,100000,NULL),(1918,79,2000,NULL),(1918,101,5,NULL),(1918,102,5,NULL),(1918,109,1,NULL),(1918,110,1,NULL),(1918,111,1,NULL),(1918,113,1,NULL),(1918,124,16777215,NULL),(1918,129,1000,NULL),(1918,136,1,NULL),(1918,153,NULL,1.38e-007),(1918,182,10264,NULL),(1918,192,8,NULL),(1918,208,100,NULL),(1918,209,100,NULL),(1918,210,100,NULL),(1918,211,100,NULL),(1918,217,395,NULL),(1918,246,395,NULL),(1918,263,8125,NULL),(1918,265,8125,NULL),(1918,267,NULL,0.3),(1918,268,NULL,0.45),(1918,269,NULL,0.375),(1918,270,NULL,0.325),(1918,271,NULL,0.5),(1918,272,NULL,0.3),(1918,273,NULL,0.3),(1918,274,NULL,0.4),(1918,277,3,NULL),(1918,283,400,NULL),(1918,479,2500000,NULL),(1918,482,6875,NULL),(1918,484,NULL,0.5),(1918,524,NULL,0.75),(1918,525,NULL,0.75),(1918,552,400,NULL),(1918,564,110,NULL),(1918,600,1,NULL),(1918,633,0,NULL),(1918,661,1000,NULL),(1918,662,NULL,0.5),(1918,1132,400,NULL),(1918,1137,3,NULL),(1918,1154,3,NULL),(1918,1178,100,NULL),(1918,1179,NULL,0.01),(1918,1196,NULL,0.01),(1918,1198,NULL,0.01),(1918,1199,100,NULL),(1918,1200,100,NULL),(1918,1224,NULL,0.5),(1918,1259,NULL,0.82),(1918,1261,NULL,0.76),(1918,1262,NULL,0.76),(1918,1271,125,NULL),(1918,1281,1,NULL),(1944,3,0,NULL),(1944,9,1173,NULL),(1944,11,70,NULL),(1944,12,4,NULL),(1944,13,4,NULL),(1944,14,2,NULL),(1944,15,0,NULL),(1944,19,1,NULL),(1944,21,0,NULL),(1944,37,125,NULL),(1944,48,750,NULL),(1944,49,0,NULL),(1944,55,381250,NULL),(1944,70,1,NULL),(1944,76,45000,NULL),(1944,79,7500,NULL),(1944,101,0,NULL),(1944,102,1,NULL),(1944,109,1,NULL),(1944,110,1,NULL),(1944,111,1,NULL),(1944,113,1,NULL),(1944,124,16777215,NULL),(1944,129,300,NULL),(1944,136,1,NULL),(1944,153,NULL,1.08911e-007),(1944,182,3343,NULL),(1944,192,2,NULL),(1944,208,9,NULL),(1944,209,0,NULL),(1944,210,0,NULL),(1944,211,0,NULL),(1944,217,395,NULL),(1944,246,395,NULL),(1944,263,195,NULL),(1944,265,1173,NULL),(1944,267,NULL,0.5),(1944,268,NULL,0.8),(1944,269,NULL,0.75),(1944,270,NULL,0.65),(1944,271,1,NULL),(1944,272,NULL,0.5),(1944,273,NULL,0.6),(1944,274,NULL,0.8),(1944,277,1,NULL),(1944,283,0,NULL),(1944,479,625000,NULL),(1944,482,NULL,687.5),(1944,484,NULL,0.75),(1944,494,5,NULL),(1944,524,NULL,0.75),(1944,525,NULL,0.75),(1944,552,210,NULL),(1944,564,85,NULL),(1944,600,NULL,1.5),(1944,819,5,NULL),(1944,820,0,NULL),(1944,821,0,NULL),(1944,822,0,NULL),(1944,1132,400,NULL),(1944,1137,3,NULL),(1944,1154,3,NULL),(1944,1178,100,NULL),(1944,1179,NULL,0.01),(1944,1196,NULL,0.01),(1944,1198,NULL,0.01),(1944,1199,100,NULL),(1944,1200,100,NULL),(1944,1224,NULL,0.75),(1944,1259,NULL,0.25),(1944,1261,NULL,0.63),(1944,1262,NULL,0.63),(1944,1271,0,NULL),(1944,1281,1,NULL),(1944,1547,2,NULL),(1944,1555,50,NULL),(1946,9,40,NULL),(1946,30,1,NULL),(1946,50,15,NULL),(1946,182,3426,NULL),(1946,277,1,NULL),(1946,422,1,NULL),(1946,633,0,NULL),(1946,1027,0,NULL),(1946,1028,0,NULL),(1946,1029,0,NULL),(1946,1030,40,NULL),(1947,6,10,NULL),(1947,9,40,NULL),(1947,30,1,NULL),(1947,50,20,NULL),(1947,73,10000,NULL),(1947,182,3427,NULL),(1947,277,1,NULL),(1947,422,1,NULL),(1947,633,0,NULL),(1947,1027,0,NULL),(1947,1028,0,NULL),(1947,1029,0,NULL),(1947,1030,80,NULL),(1947,1180,NULL,0.01),(1947,1211,NULL,3.4),(1947,1212,1,NULL),(1947,1226,30,NULL),(1948,6,48,NULL),(1948,9,40,NULL),(1948,30,1,NULL),(1948,50,40,NULL),(1948,54,26730,NULL),(1948,73,20000,NULL),(1948,158,29700,NULL),(1948,182,3427,NULL),(1948,238,1,NULL),(1948,239,1,NULL),(1948,240,3,NULL),(1948,241,1,NULL),(1948,277,1,NULL),(1948,422,1,NULL),(1948,633,0,NULL),(1948,831,0,NULL),(1948,1180,NULL,0.01),(1948,1211,NULL,6.6),(1948,1212,1,NULL),(1948,1225,20,NULL),(1949,9,40,NULL),(1949,30,1,NULL),(1949,50,10,NULL),(1949,182,3426,NULL),(1949,235,1,NULL),(1949,277,1,NULL),(1949,309,20,NULL),(1949,422,1,NULL),(1949,566,5,NULL),(1949,633,0,NULL),(1951,9,40,NULL),(1951,30,1,NULL),(1951,50,5,NULL),(1951,182,3318,NULL),(1951,277,1,NULL),(1951,351,5,NULL),(1951,422,1,NULL),(1951,633,0,NULL),(1951,767,5,NULL),(1952,6,5,NULL),(1952,9,40,NULL),(1952,30,1,NULL),(1952,50,10,NULL),(1952,73,10000,NULL),(1952,128,1,NULL),(1952,182,3428,NULL),(1952,277,4,NULL),(1952,309,30,NULL),(1952,422,2,NULL),(1952,566,30,NULL),(1952,604,910,NULL),(1952,633,5,NULL),(1955,6,48,NULL),(1955,9,40,NULL),(1955,30,1,NULL),(1955,50,40,NULL),(1955,54,26730,NULL),(1955,73,20000,NULL),(1955,158,29700,NULL),(1955,182,3427,NULL),(1955,238,3,NULL),(1955,239,1,NULL),(1955,240,1,NULL),(1955,241,1,NULL),(1955,277,1,NULL),(1955,422,1,NULL),(1955,633,0,NULL),(1955,831,0,NULL),(1955,1180,NULL,0.01),(1955,1211,NULL,6.6),(1955,1212,1,NULL),(1955,1225,20,NULL),(1956,6,48,NULL),(1956,9,40,NULL),(1956,30,1,NULL),(1956,50,40,NULL),(1956,54,26730,NULL),(1956,73,20000,NULL),(1956,158,29700,NULL),(1956,182,3427,NULL),(1956,238,1,NULL),(1956,239,1,NULL),(1956,240,1,NULL),(1956,241,3,NULL),(1956,277,1,NULL),(1956,422,1,NULL),(1956,633,0,NULL),(1956,831,0,NULL),(1956,1180,NULL,0.01),(1956,1211,NULL,6.6),(1956,1212,1,NULL),(1956,1225,20,NULL),(1957,6,72,NULL),(1957,9,40,NULL),(1957,30,1,NULL),(1957,50,50,NULL),(1957,54,17820,NULL),(1957,73,20000,NULL),(1957,158,19800,NULL),(1957,182,3427,NULL),(1957,238,2,NULL),(1957,239,2,NULL),(1957,240,2,NULL),(1957,241,2,NULL),(1957,277,1,NULL),(1957,422,1,NULL),(1957,633,0,NULL),(1957,831,0,NULL),(1957,1180,NULL,0.01),(1957,1211,NULL,6.6),(1957,1212,1,NULL),(1957,1225,20,NULL),(1958,6,48,NULL),(1958,9,40,NULL),(1958,30,1,NULL),(1958,50,40,NULL),(1958,54,26730,NULL),(1958,73,20000,NULL),(1958,158,29700,NULL),(1958,182,3427,NULL),(1958,238,1,NULL),(1958,239,3,NULL),(1958,240,1,NULL),(1958,241,1,NULL),(1958,277,1,NULL),(1958,422,1,NULL),(1958,633,0,NULL),(1958,831,0,NULL),(1958,1180,NULL,0.01),(1958,1211,NULL,6.6),(1958,1212,1,NULL),(1958,1225,20,NULL),(1959,6,20,NULL),(1959,9,40,NULL),(1959,30,1,NULL),(1959,50,50,NULL),(1959,54,20000,NULL),(1959,73,10000,NULL),(1959,158,40000,NULL),(1959,182,3427,NULL),(1959,277,1,NULL),(1959,422,1,NULL),(1959,633,0,NULL),(1959,1027,100,NULL),(1959,1028,100,NULL),(1959,1029,100,NULL),(1959,1030,100,NULL),(1960,6,22,NULL),(1960,9,40,NULL),(1960,30,1,NULL),(1960,50,55,NULL),(1960,54,24000,NULL),(1960,73,10000,NULL),(1960,158,48000,NULL),(1960,182,3427,NULL),(1960,277,4,NULL),(1960,422,2,NULL),(1960,633,5,NULL),(1960,1027,120,NULL),(1960,1028,120,NULL),(1960,1029,120,NULL),(1960,1030,120,NULL),(1963,6,1,NULL),(1963,9,40,NULL),(1963,30,1,NULL),(1963,50,20,NULL),(1963,54,25000,NULL),(1963,73,10000,NULL),(1963,128,1,NULL),(1963,158,50000,NULL),(1963,182,3433,NULL),(1963,277,1,NULL),(1963,309,NULL,33.8),(1963,422,1,NULL),(1963,566,NULL,33.8),(1963,604,910,NULL),(1963,633,0,NULL),(1964,6,2,NULL),(1964,9,40,NULL),(1964,30,1,NULL),(1964,50,22,NULL),(1964,54,30000,NULL),(1964,73,10000,NULL),(1964,128,1,NULL),(1964,158,60000,NULL),(1964,182,3433,NULL),(1964,277,4,NULL),(1964,309,NULL,40.5),(1964,422,2,NULL),(1964,566,NULL,40.5),(1964,604,910,NULL),(1964,633,5,NULL),(1968,6,30,NULL),(1968,9,40,NULL),(1968,30,1,NULL),(1968,50,35,NULL),(1968,54,25000,NULL),(1968,73,10000,NULL),(1968,128,1,NULL),(1968,158,50000,NULL),(1968,182,3433,NULL),(1968,277,1,NULL),(1968,309,NULL,-15.2),(1968,422,1,NULL),(1968,566,NULL,-15.2),(1968,604,911,NULL),(1968,633,0,NULL),(1969,6,36,NULL),(1969,9,40,NULL),(1969,30,1,NULL),(1969,50,42,NULL),(1969,54,30000,NULL),(1969,73,10000,NULL),(1969,128,1,NULL),(1969,158,60000,NULL),(1969,182,3433,NULL),(1969,277,4,NULL),(1969,309,-17,NULL),(1969,422,2,NULL),(1969,566,-17,NULL),(1969,604,911,NULL),(1969,633,5,NULL),(1973,6,10,NULL),(1973,9,40,NULL),(1973,30,1,NULL),(1973,50,10,NULL),(1973,73,10000,NULL),(1973,128,1,NULL),(1973,182,3428,NULL),(1973,277,1,NULL),(1973,309,25,NULL),(1973,422,1,NULL),(1973,566,25,NULL),(1973,604,910,NULL),(1973,633,0,NULL),(1977,6,7,NULL),(1977,9,40,NULL),(1977,30,1,NULL),(1977,50,35,NULL),(1977,73,10000,NULL),(1977,128,1,NULL),(1977,182,3317,NULL),(1977,277,1,NULL),(1977,351,5,NULL),(1977,422,1,NULL),(1977,604,907,NULL),(1977,633,0,NULL),(1977,767,10,NULL),(1978,6,7,NULL),(1978,9,40,NULL),(1978,30,1,NULL),(1978,50,35,NULL),(1978,73,10000,NULL),(1978,128,1,NULL),(1978,182,3317,NULL),(1978,277,4,NULL),(1978,351,NULL,7.5),(1978,422,2,NULL),(1978,604,907,NULL),(1978,633,5,NULL),(1978,767,15,NULL),(1982,9,40,NULL),(1982,30,1,NULL),(1982,50,15,NULL),(1982,182,3426,NULL),(1982,277,1,NULL),(1982,422,1,NULL),(1982,633,0,NULL),(1982,1027,0,NULL),(1982,1028,40,NULL),(1982,1029,0,NULL),(1982,1030,0,NULL),(1983,9,40,NULL),(1983,30,1,NULL),(1983,50,15,NULL),(1983,182,3426,NULL),(1983,277,1,NULL),(1983,422,1,NULL),(1983,633,0,NULL),(1983,1027,40,NULL),(1983,1028,0,NULL),(1983,1029,0,NULL),(1983,1030,0,NULL),(1984,9,40,NULL),(1984,30,1,NULL),(1984,50,15,NULL),(1984,182,3426,NULL),(1984,277,1,NULL),(1984,422,1,NULL),(1984,633,0,NULL),(1984,1027,0,NULL),(1984,1028,0,NULL),(1984,1029,40,NULL),(1984,1030,0,NULL),(1985,9,40,NULL),(1985,30,1,NULL),(1985,50,15,NULL),(1985,182,3426,NULL),(1985,277,1,NULL),(1985,422,1,NULL),(1985,633,0,NULL),(1985,1027,40,NULL),(1985,1028,40,NULL),(1985,1029,40,NULL),(1985,1030,40,NULL),(1986,9,40,NULL),(1986,30,1,NULL),(1986,50,20,NULL),(1986,182,3432,NULL),(1986,235,1,NULL),(1986,277,1,NULL),(1986,309,25,NULL),(1986,422,1,NULL),(1986,566,10,NULL),(1986,633,0,NULL),(1987,9,40,NULL),(1987,30,1,NULL),(1987,50,25,NULL),(1987,182,3432,NULL),(1987,235,2,NULL),(1987,277,5,NULL),(1987,309,30,NULL),(1987,422,2,NULL),(1987,566,15,NULL),(1987,633,5,NULL),(1998,9,40,NULL),(1998,30,1,NULL),(1998,50,10,NULL),(1998,182,3318,NULL),(1998,277,1,NULL),(1998,351,10,NULL),(1998,422,1,NULL),(1998,633,0,NULL),(1998,767,7,NULL),(1999,9,40,NULL),(1999,30,1,NULL),(1999,50,15,NULL),(1999,182,3318,NULL),(1999,277,4,NULL),(1999,351,15,NULL),(1999,422,2,NULL),(1999,633,5,NULL),(1999,767,NULL,9.5),(2002,6,10,NULL),(2002,9,40,NULL),(2002,30,1,NULL),(2002,50,20,NULL),(2002,73,10000,NULL),(2002,182,3427,NULL),(2002,277,1,NULL),(2002,422,1,NULL),(2002,633,0,NULL),(2002,1027,0,NULL),(2002,1028,80,NULL),(2002,1029,0,NULL),(2002,1030,0,NULL),(2002,1180,NULL,0.01),(2002,1211,NULL,3.4),(2002,1212,1,NULL),(2002,1226,30,NULL),(2003,6,10,NULL),(2003,9,40,NULL),(2003,30,1,NULL),(2003,50,20,NULL),(2003,73,10000,NULL),(2003,182,3427,NULL),(2003,277,1,NULL),(2003,422,1,NULL),(2003,633,0,NULL),(2003,1027,0,NULL),(2003,1028,0,NULL),(2003,1029,80,NULL),(2003,1030,0,NULL),(2003,1180,NULL,0.01),(2003,1211,NULL,3.4),(2003,1212,1,NULL),(2003,1226,30,NULL),(2004,6,10,NULL),(2004,9,40,NULL),(2004,30,1,NULL),(2004,50,20,NULL),(2004,73,10000,NULL),(2004,182,3427,NULL),(2004,277,1,NULL),(2004,422,1,NULL),(2004,633,0,NULL),(2004,1027,80,NULL),(2004,1028,0,NULL),(2004,1029,0,NULL),(2004,1030,0,NULL),(2004,1180,NULL,0.01),(2004,1211,NULL,3.4),(2004,1212,1,NULL),(2004,1226,30,NULL),(2005,6,20,NULL),(2005,9,40,NULL),(2005,30,1,NULL),(2005,50,20,NULL),(2005,73,10000,NULL),(2005,182,3427,NULL),(2005,277,1,NULL),(2005,422,1,NULL),(2005,633,0,NULL),(2005,1027,80,NULL),(2005,1028,80,NULL),(2005,1029,80,NULL),(2005,1030,80,NULL),(2005,1180,NULL,0.01),(2005,1211,NULL,3.4),(2005,1212,1,NULL),(2005,1226,30,NULL),(2006,3,0,NULL),(2006,9,1563,NULL),(2006,11,730,NULL),(2006,12,5,NULL),(2006,13,3,NULL),(2006,14,5,NULL),(2006,15,0,NULL),(2006,19,1,NULL),(2006,21,0,NULL),(2006,37,181,NULL),(2006,48,250,NULL),(2006,49,0,NULL),(2006,55,446250,NULL),(2006,70,NULL,0.56),(2006,76,45000,NULL),(2006,79,5000,NULL),(2006,101,1,NULL),(2006,102,5,NULL),(2006,109,1,NULL),(2006,110,1,NULL),(2006,111,1,NULL),(2006,113,1,NULL),(2006,124,16777215,NULL),(2006,129,800,NULL),(2006,136,1,NULL),(2006,153,NULL,8.13e-007),(2006,182,3335,NULL),(2006,192,7,NULL),(2006,208,13,NULL),(2006,209,0,NULL),(2006,210,0,NULL),(2006,211,0,NULL),(2006,217,394,NULL),(2006,246,394,NULL),(2006,263,1173,NULL),(2006,265,1563,NULL),(2006,267,NULL,0.5),(2006,268,NULL,0.8),(2006,269,NULL,0.75),(2006,270,NULL,0.65),(2006,271,1,NULL),(2006,272,NULL,0.5),(2006,273,NULL,0.6),(2006,274,NULL,0.8),(2006,277,2,NULL),(2006,283,15,NULL),(2006,422,1,NULL),(2006,478,-10,NULL),(2006,479,1250000,NULL),(2006,482,1250,NULL),(2006,484,NULL,0.75),(2006,524,NULL,0.75),(2006,525,NULL,0.75),(2006,552,125,NULL),(2006,564,293,NULL),(2006,633,0,NULL),(2006,656,-5,NULL),(2006,661,2000,NULL),(2006,662,NULL,0.25),(2006,819,7,NULL),(2006,820,0,NULL),(2006,821,0,NULL),(2006,822,0,NULL),(2006,1132,400,NULL),(2006,1137,3,NULL),(2006,1154,3,NULL),(2006,1178,100,NULL),(2006,1179,NULL,0.01),(2006,1196,NULL,0.01),(2006,1198,NULL,0.01),(2006,1199,100,NULL),(2006,1200,100,NULL),(2006,1224,NULL,0.75),(2006,1259,NULL,0.71),(2006,1261,NULL,0.5),(2006,1262,NULL,0.71),(2006,1271,15,NULL),(2006,1281,1,NULL),(2006,1547,2,NULL),(2006,1555,100,NULL),(2007,422,1,NULL),(2018,9,40,NULL),(2018,30,75,NULL),(2018,50,75,NULL),(2018,67,300,NULL),(2018,182,3424,NULL),(2018,277,1,NULL),(2018,422,1,NULL),(2018,633,0,NULL),(2019,422,1,NULL),(2020,9,40,NULL),(2020,30,250,NULL),(2020,50,100,NULL),(2020,67,500,NULL),(2020,182,3424,NULL),(2020,277,1,NULL),(2020,422,1,NULL),(2020,633,0,NULL),(2021,422,1,NULL),(2022,9,40,NULL),(2022,30,1250,NULL),(2022,50,125,NULL),(2022,67,1250,NULL),(2022,182,3424,NULL),(2022,277,1,NULL),(2022,422,1,NULL),(2022,633,0,NULL),(2023,422,1,NULL),(2024,9,40,NULL),(2024,30,165,NULL),(2024,50,25,NULL),(2024,56,1,NULL),(2024,73,12000,NULL),(2024,182,3417,NULL),(2024,277,4,NULL),(2024,422,2,NULL),(2024,604,87,NULL),(2024,633,5,NULL),(2024,918,0,NULL),(2024,1180,NULL,0.02),(2024,1206,-20,NULL),(2024,1211,4,NULL),(2024,1212,1,NULL),(2025,422,2,NULL),(2032,9,40,NULL),(2032,30,1,NULL),(2032,50,15,NULL),(2032,144,NULL,0.8),(2032,182,3424,NULL),(2032,277,3,NULL),(2032,422,2,NULL),(2032,633,5,NULL),(2033,422,2,NULL),(2038,6,4,NULL),(2038,9,40,NULL),(2038,30,1,NULL),(2038,50,5,NULL),(2038,73,3000,NULL),(2038,126,70000,NULL),(2038,158,30000,NULL),(2038,182,3426,NULL),(2038,277,2,NULL),(2038,422,2,NULL),(2038,633,5,NULL),(2038,1014,1,NULL),(2039,422,2,NULL),(2046,6,1,NULL),(2046,9,40,NULL),(2046,30,1,NULL),(2046,50,25,NULL),(2046,73,30000,NULL),(2046,182,3394,NULL),(2046,267,NULL,0.9),(2046,268,NULL,0.9),(2046,269,NULL,0.9),(2046,270,NULL,0.9),(2046,271,NULL,0.925),(2046,272,NULL,0.925),(2046,273,NULL,0.925),(2046,274,NULL,0.925),(2046,277,1,NULL),(2046,422,1,NULL),(2046,633,0,NULL),(2046,763,1,NULL),(2046,974,NULL,0.5),(2046,975,NULL,0.5),(2046,976,NULL,0.5),(2046,977,NULL,0.5),(2046,1544,1,NULL),(2047,422,1,NULL),(2048,6,1,NULL),(2048,9,40,NULL),(2048,30,1,NULL),(2048,50,30,NULL),(2048,73,30000,NULL),(2048,182,3394,NULL),(2048,267,NULL,0.85),(2048,268,NULL,0.85),(2048,269,NULL,0.85),(2048,270,NULL,0.85),(2048,271,NULL,0.875),(2048,272,NULL,0.875),(2048,273,NULL,0.875),(2048,274,NULL,0.875),(2048,277,4,NULL),(2048,422,2,NULL),(2048,633,5,NULL),(2048,763,1,NULL),(2048,974,NULL,0.4),(2048,975,NULL,0.4),(2048,976,NULL,0.4),(2048,977,NULL,0.4),(2048,1544,1,NULL),(2049,422,2,NULL),(2103,6,20,NULL),(2103,9,40,NULL),(2103,30,1,NULL),(2103,50,30,NULL),(2103,54,5000,NULL),(2103,73,10000,NULL),(2103,128,1,NULL),(2103,182,3433,NULL),(2103,277,1,NULL),(2103,351,5,NULL),(2103,422,1,NULL),(2103,604,907,NULL),(2103,633,0,NULL),(2103,767,10,NULL),(2104,6,20,NULL),(2104,9,40,NULL),(2104,30,1,NULL),(2104,50,30,NULL),(2104,54,6500,NULL),(2104,73,15000,NULL),(2104,128,1,NULL),(2104,182,3433,NULL),(2104,277,4,NULL),(2104,351,NULL,7.5),(2104,422,2,NULL),(2104,604,907,NULL),(2104,633,5,NULL),(2104,767,15,NULL),(2108,6,15,NULL),(2108,9,40,NULL),(2108,30,1,NULL),(2108,50,40,NULL),(2108,54,40000,NULL),(2108,73,10000,NULL),(2108,128,1,NULL),(2108,158,20000,NULL),(2108,182,3434,NULL),(2108,277,1,NULL),(2108,349,NULL,-17.9),(2108,351,NULL,-17.9),(2108,422,1,NULL),(2108,604,909,NULL),(2108,633,0,NULL),(2108,767,NULL,-17.9),(2109,6,18,NULL),(2109,9,40,NULL),(2109,30,1,NULL),(2109,50,48,NULL),(2109,54,48000,NULL),(2109,73,10000,NULL),(2109,128,1,NULL),(2109,158,24000,NULL),(2109,182,3434,NULL),(2109,277,4,NULL),(2109,349,NULL,-20.1),(2109,351,NULL,-20.1),(2109,422,2,NULL),(2109,604,909,NULL),(2109,633,5,NULL),(2109,767,NULL,-20.1),(2117,6,288,NULL),(2117,9,40,NULL),(2117,30,1,NULL),(2117,50,30,NULL),(2117,73,30000,NULL),(2117,142,6000,NULL),(2117,158,6000,NULL),(2117,182,3427,NULL),(2117,238,NULL,7.2),(2117,239,NULL,7.2),(2117,240,NULL,7.2),(2117,241,NULL,7.2),(2117,277,4,NULL),(2117,422,2,NULL),(2117,633,5,NULL),(2117,763,1,NULL),(2118,422,2,NULL),(2161,3,0,NULL),(2161,9,329,NULL),(2161,11,25,NULL),(2161,12,3,NULL),(2161,13,3,NULL),(2161,14,2,NULL),(2161,15,0,NULL),(2161,19,1,NULL),(2161,21,0,NULL),(2161,37,282,NULL),(2161,48,215,NULL),(2161,49,0,NULL),(2161,55,187500,NULL),(2161,70,NULL,4.44),(2161,76,47500,NULL),(2161,79,2000,NULL),(2161,101,0,NULL),(2161,102,2,NULL),(2161,109,1,NULL),(2161,110,1,NULL),(2161,111,1,NULL),(2161,113,1,NULL),(2161,124,16777215,NULL),(2161,129,15,NULL),(2161,136,1,NULL),(2161,153,NULL,1.67e-006),(2161,182,3331,NULL),(2161,192,6,NULL),(2161,208,14,NULL),(2161,209,0,NULL),(2161,210,0,NULL),(2161,211,0,NULL),(2161,217,394,NULL),(2161,246,394,NULL),(2161,263,274,NULL),(2161,265,375,NULL),(2161,267,NULL,0.5),(2161,268,NULL,0.8),(2161,269,NULL,0.75),(2161,270,NULL,0.65),(2161,271,1,NULL),(2161,272,NULL,0.5),(2161,273,NULL,0.6),(2161,274,NULL,0.8),(2161,277,2,NULL),(2161,283,5,NULL),(2161,422,1,NULL),(2161,464,5,NULL),(2161,479,625000,NULL),(2161,482,250,NULL),(2161,484,NULL,0.75),(2161,485,-10,NULL),(2161,511,0,NULL),(2161,524,NULL,0.75),(2161,525,NULL,0.75),(2161,552,46,NULL),(2161,564,440,NULL),(2161,600,2,NULL),(2161,633,0,NULL),(2161,661,3000,NULL),(2161,662,NULL,0.05),(2161,819,5,NULL),(2161,820,0,NULL),(2161,821,0,NULL),(2161,822,0,NULL),(2161,1132,400,NULL),(2161,1137,3,NULL),(2161,1154,3,NULL),(2161,1178,100,NULL),(2161,1179,NULL,0.01),(2161,1196,NULL,0.01),(2161,1198,NULL,0.01),(2161,1199,100,NULL),(2161,1200,100,NULL),(2161,1224,1,NULL),(2161,1259,NULL,0.25),(2161,1261,NULL,0.5),(2161,1262,NULL,0.5),(2161,1271,5,NULL),(2161,1281,1,NULL),(2161,1547,1,NULL),(2161,1555,25,NULL),(2162,422,1,NULL),(2164,3,0,NULL),(2164,9,215,NULL),(2164,11,350,NULL),(2164,12,5,NULL),(2164,13,3,NULL),(2164,14,4,NULL),(2164,15,0,NULL),(2164,19,1,NULL),(2164,21,0,NULL),(2164,37,185,NULL),(2164,48,250,NULL),(2164,49,0,NULL),(2164,55,328125,NULL),(2164,70,NULL,0.65),(2164,76,40000,NULL),(2164,79,5500,NULL),(2164,101,1,NULL),(2164,102,2,NULL),(2164,109,1,NULL),(2164,110,1,NULL),(2164,111,1,NULL),(2164,113,1,NULL),(2164,124,16777215,NULL),(2164,129,450,NULL),(2164,136,1,NULL),(2164,153,NULL,8.13e-007),(2164,182,3335,NULL),(2164,192,2,NULL),(2164,208,7,NULL),(2164,209,0,NULL),(2164,210,6,NULL),(2164,211,0,NULL),(2164,217,394,NULL),(2164,246,394,NULL),(2164,263,469,NULL),(2164,265,688,NULL),(2164,267,NULL,0.5),(2164,268,NULL,0.9),(2164,269,NULL,0.75),(2164,270,NULL,0.55),(2164,271,1,NULL),(2164,272,NULL,0.5),(2164,273,NULL,0.6),(2164,274,NULL,0.8),(2164,277,1,NULL),(2164,283,35,NULL),(2164,422,1,NULL),(2164,479,1250000,NULL),(2164,482,NULL,437.5),(2164,484,NULL,0.75),(2164,524,NULL,0.75),(2164,525,NULL,0.75),(2164,552,100,NULL),(2164,564,300,NULL),(2164,633,0,NULL),(2164,661,2000,NULL),(2164,662,NULL,0.25),(2164,1132,300,NULL),(2164,1137,3,NULL),(2164,1154,3,NULL),(2164,1178,100,NULL),(2164,1179,NULL,0.01),(2164,1196,NULL,0.01),(2164,1198,NULL,0.01),(2164,1199,100,NULL),(2164,1200,100,NULL),(2164,1224,NULL,0.75),(2164,1259,NULL,0.63),(2164,1261,NULL,0.5),(2164,1262,NULL,0.71),(2164,1271,35,NULL),(2164,1281,1,NULL),(2164,1547,2,NULL),(2166,3,0,NULL),(2166,9,219,NULL),(2166,11,400,NULL),(2166,12,5,NULL),(2166,13,2,NULL),(2166,14,4,NULL),(2166,15,0,NULL),(2166,19,1,NULL),(2166,21,0,NULL),(2166,37,220,NULL),(2166,48,300,NULL),(2166,49,0,NULL),(2166,55,468750,NULL),(2166,70,NULL,0.65),(2166,76,20000,NULL),(2166,79,1500,NULL),(2166,101,1,NULL),(2166,102,2,NULL),(2166,109,1,NULL),(2166,110,1,NULL),(2166,111,1,NULL),(2166,113,1,NULL),(2166,124,16777215,NULL),(2166,129,500,NULL),(2166,136,1,NULL),(2166,153,NULL,8.13e-007),(2166,182,3335,NULL),(2166,192,4,NULL),(2166,208,7,NULL),(2166,209,0,NULL),(2166,210,0,NULL),(2166,211,0,NULL),(2166,217,394,NULL),(2166,246,394,NULL),(2166,263,469,NULL),(2166,265,750,NULL),(2166,267,NULL,0.5),(2166,268,NULL,0.8),(2166,269,NULL,0.75),(2166,270,NULL,0.65),(2166,271,1,NULL),(2166,272,NULL,0.5),(2166,273,NULL,0.6),(2166,274,NULL,0.8),(2166,277,1,NULL),(2166,283,35,NULL),(2166,422,1,NULL),(2166,479,1250000,NULL),(2166,482,NULL,312.5),(2166,484,NULL,0.75),(2166,524,NULL,0.75),(2166,525,NULL,0.75),(2166,552,100,NULL),(2166,564,300,NULL),(2166,633,0,NULL),(2166,661,2000,NULL),(2166,662,NULL,0.25),(2166,1132,300,NULL),(2166,1137,3,NULL),(2166,1154,3,NULL),(2166,1178,100,NULL),(2166,1179,NULL,0.01),(2166,1196,NULL,0.01),(2166,1198,NULL,0.01),(2166,1199,100,NULL),(2166,1200,100,NULL),(2166,1224,NULL,0.75),(2166,1259,NULL,0.63),(2166,1261,NULL,0.25),(2166,1262,NULL,0.71),(2166,1271,35,NULL),(2166,1281,1,NULL),(2166,1547,2,NULL),(2168,3,0,NULL),(2168,9,223,NULL),(2168,11,400,NULL),(2168,12,5,NULL),(2168,13,2,NULL),(2168,14,4,NULL),(2168,15,0,NULL),(2168,19,1,NULL),(2168,21,0,NULL),(2168,37,220,NULL),(2168,48,300,NULL),(2168,49,0,NULL),(2168,55,468750,NULL),(2168,70,NULL,0.65),(2168,76,20000,NULL),(2168,79,1500,NULL),(2168,101,1,NULL),(2168,102,2,NULL),(2168,109,1,NULL),(2168,110,1,NULL),(2168,111,1,NULL),(2168,113,1,NULL),(2168,124,16777215,NULL),(2168,129,500,NULL),(2168,136,1,NULL),(2168,153,NULL,8.13e-007),(2168,182,3335,NULL),(2168,192,4,NULL),(2168,208,7,NULL),(2168,209,0,NULL),(2168,210,0,NULL),(2168,211,0,NULL),(2168,217,394,NULL),(2168,246,394,NULL),(2168,263,469,NULL),(2168,265,750,NULL),(2168,267,NULL,0.5),(2168,268,NULL,0.8),(2168,269,NULL,0.75),(2168,270,NULL,0.65),(2168,271,1,NULL),(2168,272,NULL,0.5),(2168,273,NULL,0.6),(2168,274,NULL,0.8),(2168,277,1,NULL),(2168,283,35,NULL),(2168,422,1,NULL),(2168,479,1250000,NULL),(2168,482,NULL,312.5),(2168,484,NULL,0.75),(2168,524,NULL,0.75),(2168,525,NULL,0.75),(2168,552,100,NULL),(2168,564,300,NULL),(2168,633,0,NULL),(2168,661,2000,NULL),(2168,662,NULL,0.25),(2168,1132,300,NULL),(2168,1137,3,NULL),(2168,1154,3,NULL),(2168,1178,100,NULL),(2168,1179,NULL,0.01),(2168,1196,NULL,0.01),(2168,1198,NULL,0.01),(2168,1199,100,NULL),(2168,1200,100,NULL),(2168,1224,NULL,0.75),(2168,1259,NULL,0.63),(2168,1261,NULL,0.25),(2168,1262,NULL,0.71),(2168,1271,35,NULL),(2168,1281,1,NULL),(2168,1547,2,NULL),(2173,9,336,NULL),(2173,37,1900,NULL),(2173,51,4000,NULL),(2173,54,1000,NULL),(2173,55,2500000,NULL),(2173,64,NULL,1.15),(2173,70,100,NULL),(2173,79,2000,NULL),(2173,109,1,NULL),(2173,110,1,NULL),(2173,111,1,NULL),(2173,113,1,NULL),(2173,114,24,NULL),(2173,116,0,NULL),(2173,117,0,NULL),(2173,118,0,NULL),(2173,136,NULL,0.75),(2173,154,2000,NULL),(2173,156,NULL,0.75),(2173,158,3000,NULL),(2173,160,NULL,1.08),(2173,182,3437,NULL),(2173,184,3436,NULL),(2173,192,8,NULL),(2173,193,1,NULL),(2173,208,NULL,12.5),(2173,209,NULL,12.5),(2173,210,NULL,12.5),(2173,211,NULL,12.5),(2173,247,4000,NULL),(2173,263,80,NULL),(2173,265,240,NULL),(2173,267,NULL,0.4),(2173,268,NULL,0.9),(2173,269,NULL,0.75),(2173,270,NULL,0.55),(2173,271,1,NULL),(2173,272,NULL,0.4),(2173,273,NULL,0.6),(2173,274,NULL,0.8),(2173,277,1,NULL),(2173,279,1,NULL),(2173,416,900,NULL),(2173,422,1,NULL),(2173,479,250000,NULL),(2173,482,1,NULL),(2173,484,NULL,0.75),(2173,508,450,NULL),(2173,524,NULL,0.75),(2173,525,NULL,0.75),(2173,552,50,NULL),(2173,580,1,NULL),(2173,581,1,NULL),(2173,582,2500,NULL),(2173,583,1,NULL),(2173,620,125,NULL),(2173,633,0,NULL),(2173,665,3000,NULL),(2173,1272,10,NULL),(2174,422,1,NULL),(2175,9,403,NULL),(2175,37,2280,NULL),(2175,51,4000,NULL),(2175,54,1000,NULL),(2175,55,2500000,NULL),(2175,64,NULL,1.38),(2175,70,100,NULL),(2175,79,2000,NULL),(2175,109,1,NULL),(2175,110,1,NULL),(2175,111,1,NULL),(2175,113,1,NULL),(2175,114,24,NULL),(2175,116,0,NULL),(2175,117,0,NULL),(2175,118,0,NULL),(2175,136,NULL,0.75),(2175,154,2000,NULL),(2175,156,NULL,0.75),(2175,158,3000,NULL),(2175,160,NULL,1.188),(2175,182,3437,NULL),(2175,183,12484,NULL),(2175,184,3436,NULL),(2175,192,8,NULL),(2175,193,1,NULL),(2175,208,NULL,12.5),(2175,209,NULL,12.5),(2175,210,NULL,12.5),(2175,211,NULL,12.5),(2175,247,4000,NULL),(2175,263,96,NULL),(2175,265,288,NULL),(2175,267,NULL,0.4),(2175,268,NULL,0.9),(2175,269,NULL,0.75),(2175,270,NULL,0.55),(2175,271,1,NULL),(2175,272,NULL,0.4),(2175,273,NULL,0.6),(2175,274,NULL,0.8),(2175,277,5,NULL),(2175,278,2,NULL),(2175,279,1,NULL),(2175,416,900,NULL),(2175,422,2,NULL),(2175,479,250000,NULL),(2175,482,1,NULL),(2175,484,NULL,0.75),(2175,508,450,NULL),(2175,524,NULL,0.75),(2175,525,NULL,0.75),(2175,552,50,NULL),(2175,580,1,NULL),(2175,581,1,NULL),(2175,582,2500,NULL),(2175,583,1,NULL),(2175,620,125,NULL),(2175,633,5,NULL),(2175,665,3000,NULL),(2175,1272,10,NULL),(2176,422,2,NULL),(2183,9,592,NULL),(2183,37,1400,NULL),(2183,51,4000,NULL),(2183,54,1000,NULL),(2183,55,2500000,NULL),(2183,64,NULL,1.6),(2183,70,100,NULL),(2183,79,2000,NULL),(2183,109,1,NULL),(2183,110,1,NULL),(2183,111,1,NULL),(2183,113,1,NULL),(2183,114,0,NULL),(2183,116,0,NULL),(2183,117,0,NULL),(2183,118,24,NULL),(2183,136,NULL,0.75),(2183,154,2000,NULL),(2183,156,NULL,0.75),(2183,158,3000,NULL),(2183,160,NULL,0.72),(2183,182,3437,NULL),(2183,184,3436,NULL),(2183,192,8,NULL),(2183,193,1,NULL),(2183,208,NULL,12.5),(2183,209,NULL,12.5),(2183,210,NULL,12.5),(2183,211,NULL,12.5),(2183,247,4000,NULL),(2183,263,112,NULL),(2183,265,240,NULL),(2183,267,NULL,0.4),(2183,268,NULL,0.9),(2183,269,NULL,0.75),(2183,270,NULL,0.55),(2183,271,1,NULL),(2183,272,NULL,0.4),(2183,273,NULL,0.6),(2183,274,NULL,0.8),(2183,277,1,NULL),(2183,279,1,NULL),(2183,416,900,NULL),(2183,422,1,NULL),(2183,479,250000,NULL),(2183,482,1,NULL),(2183,484,NULL,0.75),(2183,508,400,NULL),(2183,524,NULL,0.75),(2183,525,NULL,0.75),(2183,552,50,NULL),(2183,580,1,NULL),(2183,581,1,NULL),(2183,582,2500,NULL),(2183,583,1,NULL),(2183,620,125,NULL),(2183,633,0,NULL),(2183,665,3000,NULL),(2183,1272,10,NULL),(2184,422,1,NULL),(2185,9,710,NULL),(2185,37,1680,NULL),(2185,51,4000,NULL),(2185,54,1000,NULL),(2185,55,2500000,NULL),(2185,64,NULL,1.92),(2185,70,100,NULL),(2185,79,2000,NULL),(2185,109,1,NULL),(2185,110,1,NULL),(2185,111,1,NULL),(2185,113,1,NULL),(2185,114,0,NULL),(2185,116,0,NULL),(2185,117,0,NULL),(2185,118,24,NULL),(2185,136,NULL,0.75),(2185,154,2000,NULL),(2185,156,NULL,0.75),(2185,158,3000,NULL),(2185,160,NULL,0.922),(2185,182,3437,NULL),(2185,183,12486,NULL),(2185,184,3436,NULL),(2185,192,8,NULL),(2185,193,1,NULL),(2185,208,NULL,12.5),(2185,209,NULL,12.5),(2185,210,NULL,12.5),(2185,211,NULL,12.5),(2185,247,4000,NULL),(2185,263,134,NULL),(2185,265,288,NULL),(2185,267,NULL,0.4),(2185,268,NULL,0.9),(2185,269,NULL,0.75),(2185,270,NULL,0.55),(2185,271,1,NULL),(2185,272,NULL,0.4),(2185,273,NULL,0.6),(2185,274,NULL,0.8),(2185,277,5,NULL),(2185,278,2,NULL),(2185,279,1,NULL),(2185,416,900,NULL),(2185,422,2,NULL),(2185,479,250000,NULL),(2185,482,1,NULL),(2185,484,NULL,0.75),(2185,508,480,NULL),(2185,524,NULL,0.75),(2185,525,NULL,0.75),(2185,552,50,NULL),(2185,580,1,NULL),(2185,581,1,NULL),(2185,582,2500,NULL),(2185,583,1,NULL),(2185,620,125,NULL),(2185,633,5,NULL),(2185,665,3000,NULL),(2185,1272,10,NULL),(2186,422,2,NULL),(2193,9,672,NULL),(2193,37,950,NULL),(2193,51,4000,NULL),(2193,54,1000,NULL),(2193,55,2500000,NULL),(2193,64,NULL,1.15),(2193,70,100,NULL),(2193,79,2000,NULL),(2193,109,1,NULL),(2193,110,1,NULL),(2193,111,1,NULL),(2193,113,1,NULL),(2193,114,48,NULL),(2193,116,0,NULL),(2193,117,0,NULL),(2193,118,0,NULL),(2193,136,NULL,0.75),(2193,154,4000,NULL),(2193,156,NULL,0.75),(2193,158,4000,NULL),(2193,160,NULL,0.42),(2193,182,3441,NULL),(2193,184,3436,NULL),(2193,192,8,NULL),(2193,193,1,NULL),(2193,208,NULL,22.5),(2193,209,NULL,22.5),(2193,210,NULL,22.5),(2193,211,NULL,22.5),(2193,247,5000,NULL),(2193,263,160,NULL),(2193,265,480,NULL),(2193,267,NULL,0.4),(2193,268,NULL,0.9),(2193,269,NULL,0.75),(2193,270,NULL,0.55),(2193,271,1,NULL),(2193,272,NULL,0.4),(2193,273,NULL,0.6),(2193,274,NULL,0.8),(2193,277,1,NULL),(2193,279,1,NULL),(2193,416,1000,NULL),(2193,422,1,NULL),(2193,479,250000,NULL),(2193,482,1,NULL),(2193,484,NULL,0.75),(2193,508,300,NULL),(2193,524,NULL,0.75),(2193,525,NULL,0.75),(2193,552,100,NULL),(2193,580,1,NULL),(2193,581,1,NULL),(2193,582,2500,NULL),(2193,583,1,NULL),(2193,620,125,NULL),(2193,633,0,NULL),(2193,665,5000,NULL),(2193,1272,25,NULL),(2194,422,1,NULL),(2195,9,806,NULL),(2195,37,1140,NULL),(2195,51,4000,NULL),(2195,54,1000,NULL),(2195,55,2500000,NULL),(2195,64,NULL,1.38),(2195,70,100,NULL),(2195,79,2000,NULL),(2195,109,1,NULL),(2195,110,1,NULL),(2195,111,1,NULL),(2195,113,1,NULL),(2195,114,48,NULL),(2195,116,0,NULL),(2195,117,0,NULL),(2195,118,0,NULL),(2195,136,NULL,0.75),(2195,154,4000,NULL),(2195,156,NULL,0.75),(2195,158,4000,NULL),(2195,160,NULL,0.504),(2195,182,3441,NULL),(2195,183,12484,NULL),(2195,184,3436,NULL),(2195,192,8,NULL),(2195,193,1,NULL),(2195,208,NULL,22.5),(2195,209,NULL,22.5),(2195,210,NULL,22.5),(2195,211,NULL,22.5),(2195,247,5000,NULL),(2195,263,192,NULL),(2195,265,576,NULL),(2195,267,NULL,0.4),(2195,268,NULL,0.9),(2195,269,NULL,0.75),(2195,270,NULL,0.55),(2195,271,1,NULL),(2195,272,NULL,0.4),(2195,273,NULL,0.6),(2195,274,NULL,0.8),(2195,277,5,NULL),(2195,278,4,NULL),(2195,279,1,NULL),(2195,416,1000,NULL),(2195,422,2,NULL),(2195,479,250000,NULL),(2195,482,1,NULL),(2195,484,NULL,0.75),(2195,508,360,NULL),(2195,524,NULL,0.75),(2195,525,NULL,0.75),(2195,552,100,NULL),(2195,580,1,NULL),(2195,581,1,NULL),(2195,582,2500,NULL),(2195,583,1,NULL),(2195,620,125,NULL),(2195,633,5,NULL),(2195,665,5000,NULL),(2195,1272,25,NULL),(2196,422,2,NULL),(2203,9,168,NULL),(2203,37,3800,NULL),(2203,51,4000,NULL),(2203,54,1000,NULL),(2203,55,2500000,NULL),(2203,64,NULL,1.15),(2203,70,100,NULL),(2203,79,2000,NULL),(2203,109,1,NULL),(2203,110,1,NULL),(2203,111,1,NULL),(2203,113,1,NULL),(2203,114,15,NULL),(2203,116,0,NULL),(2203,117,0,NULL),(2203,118,0,NULL),(2203,136,NULL,0.75),(2203,154,1000,NULL),(2203,156,NULL,0.75),(2203,158,2000,NULL),(2203,160,NULL,2.47),(2203,182,3437,NULL),(2203,184,3436,NULL),(2203,192,8,NULL),(2203,193,1,NULL),(2203,208,NULL,7.5),(2203,209,NULL,7.5),(2203,210,NULL,7.5),(2203,211,NULL,7.5),(2203,247,3000,NULL),(2203,263,40,NULL),(2203,265,120,NULL),(2203,267,NULL,0.4),(2203,268,NULL,0.9),(2203,269,NULL,0.75),(2203,270,NULL,0.55),(2203,271,1,NULL),(2203,272,NULL,0.4),(2203,273,NULL,0.6),(2203,274,NULL,0.8),(2203,277,1,NULL),(2203,279,1,NULL),(2203,416,500,NULL),(2203,422,1,NULL),(2203,479,250000,NULL),(2203,482,1,NULL),(2203,484,NULL,0.75),(2203,508,650,NULL),(2203,524,NULL,0.75),(2203,525,NULL,0.75),(2203,552,25,NULL),(2203,580,1,NULL),(2203,581,1,NULL),(2203,582,2500,NULL),(2203,583,1,NULL),(2203,620,25,NULL),(2203,633,0,NULL),(2203,665,3000,NULL),(2203,1272,5,NULL),(2204,422,1,NULL),(2205,9,202,NULL),(2205,37,4560,NULL),(2205,51,4000,NULL),(2205,54,1000,NULL),(2205,55,2500000,NULL),(2205,64,NULL,1.38),(2205,70,100,NULL),(2205,79,2000,NULL),(2205,109,1,NULL),(2205,110,1,NULL),(2205,111,1,NULL),(2205,113,1,NULL),(2205,114,15,NULL),(2205,116,0,NULL),(2205,117,0,NULL),(2205,118,0,NULL),(2205,136,NULL,0.75),(2205,154,1000,NULL),(2205,156,NULL,0.75),(2205,158,2000,NULL),(2205,160,NULL,2.964),(2205,182,3437,NULL),(2205,183,12484,NULL),(2205,184,3436,NULL),(2205,192,8,NULL),(2205,193,1,NULL),(2205,208,NULL,7.5),(2205,209,NULL,7.5),(2205,210,NULL,7.5),(2205,211,NULL,7.5),(2205,247,3000,NULL),(2205,263,48,NULL),(2205,265,144,NULL),(2205,267,NULL,0.4),(2205,268,NULL,0.9),(2205,269,NULL,0.75),(2205,270,NULL,0.55),(2205,271,1,NULL),(2205,272,NULL,0.4),(2205,273,NULL,0.6),(2205,274,NULL,0.8),(2205,277,5,NULL),(2205,278,1,NULL),(2205,279,1,NULL),(2205,416,500,NULL),(2205,422,2,NULL),(2205,479,250000,NULL),(2205,482,1,NULL),(2205,484,NULL,0.75),(2205,508,780,NULL),(2205,524,NULL,0.75),(2205,525,NULL,0.75),(2205,552,25,NULL),(2205,580,1,NULL),(2205,581,1,NULL),(2205,582,2500,NULL),(2205,583,1,NULL),(2205,620,25,NULL),(2205,633,5,NULL),(2205,665,3000,NULL),(2205,1272,5,NULL),(2206,422,2,NULL),(2258,6,24,NULL),(2258,9,40,NULL),(2258,30,1,NULL),(2258,50,24,NULL),(2258,73,10000,NULL),(2258,182,3427,NULL),(2258,277,4,NULL),(2258,422,2,NULL),(2258,633,5,NULL),(2258,1027,96,NULL),(2258,1028,96,NULL),(2258,1029,96,NULL),(2258,1030,96,NULL),(2258,1180,NULL,0.02),(2258,1211,NULL,3.4),(2258,1212,1,NULL),(2258,1226,30,NULL),(2259,6,12,NULL),(2259,9,40,NULL),(2259,30,1,NULL),(2259,50,24,NULL),(2259,73,10000,NULL),(2259,182,3427,NULL),(2259,277,4,NULL),(2259,422,2,NULL),(2259,633,5,NULL),(2259,1027,96,NULL),(2259,1028,0,NULL),(2259,1029,0,NULL),(2259,1030,0,NULL),(2259,1180,NULL,0.02),(2259,1211,NULL,3.4),(2259,1212,1,NULL),(2259,1226,30,NULL),(2260,6,12,NULL),(2260,9,40,NULL),(2260,30,1,NULL),(2260,50,24,NULL),(2260,73,10000,NULL),(2260,182,3427,NULL),(2260,277,4,NULL),(2260,422,2,NULL),(2260,633,5,NULL),(2260,1027,0,NULL),(2260,1028,96,NULL),(2260,1029,0,NULL),(2260,1030,0,NULL),(2260,1180,NULL,0.02),(2260,1211,NULL,3.4),(2260,1212,1,NULL),(2260,1226,30,NULL),(2261,6,12,NULL),(2261,9,40,NULL),(2261,30,1,NULL),(2261,50,24,NULL),(2261,73,10000,NULL),(2261,182,3427,NULL),(2261,277,4,NULL),(2261,422,2,NULL),(2261,633,5,NULL),(2261,1027,0,NULL),(2261,1028,0,NULL),(2261,1029,96,NULL),(2261,1030,0,NULL),(2261,1180,NULL,0.02),(2261,1211,NULL,3.4),(2261,1212,1,NULL),(2261,1226,30,NULL),(2262,6,12,NULL),(2262,9,40,NULL),(2262,30,1,NULL),(2262,50,24,NULL),(2262,73,10000,NULL),(2262,182,3427,NULL),(2262,277,4,NULL),(2262,422,2,NULL),(2262,633,5,NULL),(2262,1027,0,NULL),(2262,1028,0,NULL),(2262,1029,0,NULL),(2262,1030,96,NULL),(2262,1180,NULL,0.02),(2262,1211,NULL,3.4),(2262,1212,1,NULL),(2262,1226,30,NULL),(2281,6,32,NULL),(2281,9,40,NULL),(2281,30,1,NULL),(2281,50,44,NULL),(2281,73,10000,NULL),(2281,182,3420,NULL),(2281,277,4,NULL),(2281,422,2,NULL),(2281,633,5,NULL),(2281,967,1,NULL),(2281,984,-30,NULL),(2281,985,-30,NULL),(2281,986,-30,NULL),(2281,987,-30,NULL),(2281,994,-1,NULL),(2281,995,-1,NULL),(2281,996,-1,NULL),(2281,997,-1,NULL),(2281,1180,NULL,0.02),(2281,1208,20,NULL),(2281,1211,NULL,3.4),(2281,1212,1,NULL),(2282,422,2,NULL),(2289,6,20,NULL),(2289,9,40,NULL),(2289,30,1,NULL),(2289,50,40,NULL),(2289,73,10000,NULL),(2289,182,3420,NULL),(2289,277,1,NULL),(2289,422,1,NULL),(2289,633,0,NULL),(2289,967,1,NULL),(2289,984,0,NULL),(2289,985,-50,NULL),(2289,986,0,NULL),(2289,987,0,NULL),(2289,994,0,NULL),(2289,995,-1,NULL),(2289,996,0,NULL),(2289,997,0,NULL),(2289,1180,NULL,0.01),(2289,1208,20,NULL),(2289,1211,NULL,3.4),(2289,1212,1,NULL),(2290,422,1,NULL),(2291,6,20,NULL),(2291,9,40,NULL),(2291,30,1,NULL),(2291,50,40,NULL),(2291,73,10000,NULL),(2291,182,3420,NULL),(2291,277,1,NULL),(2291,422,1,NULL),(2291,633,0,NULL),(2291,967,1,NULL),(2291,984,0,NULL),(2291,985,0,NULL),(2291,986,-50,NULL),(2291,987,0,NULL),(2291,994,0,NULL),(2291,995,0,NULL),(2291,996,-1,NULL),(2291,997,0,NULL),(2291,1180,NULL,0.01),(2291,1208,20,NULL),(2291,1211,NULL,3.4),(2291,1212,1,NULL),(2292,422,1,NULL),(2293,6,20,NULL),(2293,9,40,NULL),(2293,30,1,NULL),(2293,50,40,NULL),(2293,73,10000,NULL),(2293,182,3420,NULL),(2293,277,1,NULL),(2293,422,1,NULL),(2293,633,0,NULL),(2293,984,-50,NULL),(2293,985,0,NULL),(2293,986,0,NULL),(2293,987,0,NULL),(2293,994,-1,NULL),(2293,995,0,NULL),(2293,996,0,NULL),(2293,997,0,NULL),(2293,1180,NULL,0.01),(2293,1208,20,NULL),(2293,1211,NULL,3.4),(2293,1212,1,NULL),(2294,422,1,NULL),(2295,6,20,NULL),(2295,9,40,NULL),(2295,30,1,NULL),(2295,50,40,NULL),(2295,73,10000,NULL),(2295,182,3420,NULL),(2295,277,1,NULL),(2295,422,1,NULL),(2295,633,0,NULL),(2295,967,1,NULL),(2295,984,0,NULL),(2295,985,0,NULL),(2295,986,0,NULL),(2295,987,-50,NULL),(2295,994,0,NULL),(2295,995,0,NULL),(2295,996,0,NULL),(2295,997,-1,NULL),(2295,1180,NULL,0.01),(2295,1208,20,NULL),(2295,1211,NULL,3.4),(2295,1212,1,NULL),(2296,422,1,NULL),(2297,6,20,NULL),(2297,9,40,NULL),(2297,30,1,NULL),(2297,50,44,NULL),(2297,73,10000,NULL),(2297,182,3420,NULL),(2297,277,4,NULL),(2297,422,2,NULL),(2297,633,5,NULL),(2297,967,1,NULL),(2297,984,0,NULL),(2297,985,-55,NULL),(2297,986,0,NULL),(2297,987,0,NULL),(2297,994,0,NULL),(2297,995,-1,NULL),(2297,996,0,NULL),(2297,997,0,NULL),(2297,1180,NULL,0.02),(2297,1208,20,NULL),(2297,1211,NULL,3.4),(2297,1212,1,NULL),(2298,422,2,NULL),(2299,6,20,NULL),(2299,9,40,NULL),(2299,30,1,NULL),(2299,50,44,NULL),(2299,73,10000,NULL),(2299,182,3420,NULL),(2299,277,4,NULL),(2299,422,2,NULL),(2299,633,5,NULL),(2299,967,1,NULL),(2299,984,0,NULL),(2299,985,0,NULL),(2299,986,-55,NULL),(2299,987,0,NULL),(2299,994,0,NULL),(2299,995,0,NULL),(2299,996,-1,NULL),(2299,997,0,NULL),(2299,1180,NULL,0.02),(2299,1208,20,NULL),(2299,1211,NULL,3.4),(2299,1212,1,NULL),(2300,422,2,NULL),(2301,6,20,NULL),(2301,9,40,NULL),(2301,30,1,NULL),(2301,50,44,NULL),(2301,73,10000,NULL),(2301,182,3420,NULL),(2301,277,4,NULL),(2301,422,2,NULL),(2301,633,5,NULL),(2301,967,1,NULL),(2301,984,-55,NULL),(2301,985,0,NULL),(2301,986,0,NULL),(2301,987,0,NULL),(2301,994,-1,NULL),(2301,995,0,NULL),(2301,996,0,NULL),(2301,997,0,NULL),(2301,1180,NULL,0.02),(2301,1208,20,NULL),(2301,1211,NULL,3.4),(2301,1212,1,NULL),(2302,422,2,NULL),(2303,6,20,NULL),(2303,9,40,NULL),(2303,30,1,NULL),(2303,50,44,NULL),(2303,73,10000,NULL),(2303,182,3420,NULL),(2303,277,4,NULL),(2303,422,2,NULL),(2303,633,5,NULL),(2303,967,1,NULL),(2303,984,0,NULL),(2303,985,0,NULL),(2303,986,0,NULL),(2303,987,-55,NULL),(2303,994,0,NULL),(2303,995,0,NULL),(2303,996,0,NULL),(2303,997,-1,NULL),(2303,1180,NULL,0.02),(2303,1208,20,NULL),(2303,1211,NULL,3.4),(2303,1212,1,NULL),(2304,422,2,NULL),(2331,9,40,NULL),(2331,30,0,NULL),(2331,50,20,NULL),(2331,134,NULL,0.8),(2331,144,NULL,1.35),(2331,145,1,NULL),(2331,146,1,NULL),(2331,147,1,NULL),(2331,182,3424,NULL),(2331,277,2,NULL),(2331,422,1,NULL),(2331,633,0,NULL),(2332,422,1,NULL),(2333,6,6,NULL),(2333,9,40,NULL),(2333,30,1,NULL),(2333,50,6,NULL),(2333,73,4000,NULL),(2333,182,3426,NULL),(2333,189,11,NULL),(2333,197,22500,NULL),(2333,277,2,NULL),(2333,422,2,NULL),(2333,633,5,NULL),(2333,1014,1,NULL),(2334,422,2,NULL),(2341,6,7,NULL),(2341,9,40,NULL),(2341,30,1,NULL),(2341,50,25,NULL),(2341,73,10000,NULL),(2341,182,3429,NULL),(2341,277,2,NULL),(2341,422,2,NULL),(2341,633,5,NULL),(2342,422,2,NULL),(2355,6,30,NULL),(2355,9,40,NULL),(2355,30,10,NULL),(2355,50,33,NULL),(2355,73,24000,NULL),(2355,83,30,NULL),(2355,182,3393,NULL),(2355,183,3392,NULL),(2355,277,2,NULL),(2355,278,1,NULL),(2355,422,2,NULL),(2355,633,5,NULL),(2355,1180,NULL,0.02),(2355,1206,-15,NULL),(2355,1211,NULL,13.3),(2355,1212,1,NULL),(2356,422,2,NULL),(2363,9,40,NULL),(2363,30,1,NULL),(2363,50,30,NULL),(2363,64,NULL,1.07),(2363,182,3318,NULL),(2363,204,NULL,0.925),(2363,277,1,NULL),(2363,422,1,NULL),(2363,633,0,NULL),(2364,9,40,NULL),(2364,30,1,NULL),(2364,50,30,NULL),(2364,64,NULL,1.1),(2364,182,3318,NULL),(2364,204,NULL,0.895),(2364,277,4,NULL),(2364,422,2,NULL),(2364,633,5,NULL),(2370,37,1760,NULL),(2370,245,378,NULL),(2370,246,394,NULL),(2370,252,NULL,0.001),(2370,481,4000,NULL),(2370,508,220,NULL),(2370,552,32,NULL),(2370,798,1,NULL),(2372,37,2200,NULL),(2372,245,393,NULL),(2372,246,397,NULL),(2372,252,NULL,0.00125),(2372,481,5000,NULL),(2372,508,275,NULL),(2372,552,30,NULL),(2372,798,1,NULL),(2379,37,1760,NULL),(2379,245,378,NULL),(2379,246,394,NULL),(2379,252,NULL,0.0015),(2379,481,6000,NULL),(2379,508,220,NULL),(2379,552,32,NULL),(2379,798,1,NULL),(2381,37,1440,NULL),(2381,245,374,NULL),(2381,246,394,NULL),(2381,252,NULL,0.0105),(2381,481,57500,NULL),(2381,508,180,NULL),(2381,552,110,NULL),(2381,798,1,NULL),(2382,37,1760,NULL),(2382,245,349,NULL),(2382,246,395,NULL),(2382,252,NULL,0.001),(2382,481,4000,NULL),(2382,508,220,NULL),(2382,552,33,NULL),(2382,798,1,NULL),(2383,37,1760,NULL),(2383,245,378,NULL),(2383,246,395,NULL),(2383,252,NULL,0.00175),(2383,481,7000,NULL),(2383,508,220,NULL),(2383,552,33,NULL),(2383,798,1,NULL),(2384,37,1760,NULL),(2384,245,349,NULL),(2384,246,395,NULL),(2384,252,NULL,0.00125),(2384,481,5000,NULL),(2384,508,220,NULL),(2384,552,33,NULL),(2384,798,1,NULL),(2385,37,1760,NULL),(2385,245,375,NULL),(2385,246,395,NULL),(2385,252,NULL,0.002),(2385,481,8000,NULL),(2385,508,220,NULL),(2385,552,50,NULL),(2385,798,1,NULL),(2386,37,1760,NULL),(2386,246,395,NULL),(2386,252,NULL,0.0025),(2386,481,10000,NULL),(2386,508,220,NULL),(2386,552,38,NULL),(2386,798,1,NULL),(2387,37,1440,NULL),(2387,245,374,NULL),(2387,246,395,NULL),(2387,252,NULL,0.01),(2387,481,50000,NULL),(2387,508,180,NULL),(2387,552,115,NULL),(2387,798,1,NULL),(2404,9,40,NULL),(2404,30,9,NULL),(2404,47,1,NULL),(2404,50,28,NULL),(2404,51,12000,NULL),(2404,56,1,NULL),(2404,182,3319,NULL),(2404,183,20210,NULL),(2404,277,3,NULL),(2404,278,1,NULL),(2404,422,2,NULL),(2404,604,384,NULL),(2404,605,394,NULL),(2404,606,88,NULL),(2404,609,653,NULL),(2404,633,5,NULL),(2404,1180,NULL,0.02),(2404,1205,-15,NULL),(2404,1211,3,NULL),(2404,1212,1,NULL),(2405,422,2,NULL),(2410,9,40,NULL),(2410,30,105,NULL),(2410,47,1,NULL),(2410,50,55,NULL),(2410,51,12000,NULL),(2410,56,1,NULL),(2410,182,3319,NULL),(2410,183,20211,NULL),(2410,277,4,NULL),(2410,278,1,NULL),(2410,422,2,NULL),(2410,604,385,NULL),(2410,605,395,NULL),(2410,606,88,NULL),(2410,609,655,NULL),(2410,633,5,NULL),(2410,1180,NULL,0.02),(2410,1205,-15,NULL),(2410,1211,NULL,1.8),(2410,1212,1,NULL),(2411,422,2,NULL),(2420,9,40,NULL),(2420,30,1838,NULL),(2420,47,1,NULL),(2420,50,88,NULL),(2420,51,14400,NULL),(2420,56,1,NULL),(2420,182,3319,NULL),(2420,183,20213,NULL),(2420,277,4,NULL),(2420,278,1,NULL),(2420,422,2,NULL),(2420,604,657,NULL),(2420,606,89,NULL),(2420,609,88,NULL),(2420,633,5,NULL),(2420,845,50,NULL),(2420,1180,NULL,0.02),(2420,1205,-15,NULL),(2420,1211,NULL,2.1),(2420,1212,1,NULL),(2421,422,2,NULL),(2436,9,653,NULL),(2436,37,960,NULL),(2436,51,4000,NULL),(2436,54,1000,NULL),(2436,55,2500000,NULL),(2436,64,NULL,1.74),(2436,70,100,NULL),(2436,79,2000,NULL),(2436,109,1,NULL),(2436,110,1,NULL),(2436,111,1,NULL),(2436,113,1,NULL),(2436,114,0,NULL),(2436,116,0,NULL),(2436,117,48,NULL),(2436,118,0,NULL),(2436,136,NULL,0.75),(2436,154,4000,NULL),(2436,156,NULL,0.75),(2436,158,4000,NULL),(2436,160,NULL,0.429),(2436,182,3441,NULL),(2436,183,12487,NULL),(2436,184,3436,NULL),(2436,192,8,NULL),(2436,193,1,NULL),(2436,208,NULL,22.5),(2436,209,NULL,22.5),(2436,210,NULL,22.5),(2436,211,NULL,22.5),(2436,247,5000,NULL),(2436,263,499,NULL),(2436,265,422,NULL),(2436,267,NULL,0.4),(2436,268,NULL,0.9),(2436,269,NULL,0.75),(2436,270,NULL,0.55),(2436,271,1,NULL),(2436,272,NULL,0.4),(2436,273,NULL,0.6),(2436,274,NULL,0.8),(2436,277,5,NULL),(2436,278,4,NULL),(2436,279,1,NULL),(2436,416,1000,NULL),(2436,422,2,NULL),(2436,479,250000,NULL),(2436,482,1,NULL),(2436,484,NULL,0.75),(2436,508,330,NULL),(2436,524,NULL,0.75),(2436,525,NULL,0.75),(2436,552,100,NULL),(2436,580,1,NULL),(2436,581,1,NULL),(2436,582,2500,NULL),(2436,583,1,NULL),(2436,620,125,NULL),(2436,633,5,NULL),(2436,665,5000,NULL),(2436,1272,25,NULL),(2437,422,2,NULL),(2444,9,1184,NULL),(2444,37,700,NULL),(2444,51,4000,NULL),(2444,54,1000,NULL),(2444,55,2500000,NULL),(2444,64,NULL,1.6),(2444,70,100,NULL),(2444,79,2000,NULL),(2444,109,1,NULL),(2444,110,1,NULL),(2444,111,1,NULL),(2444,113,1,NULL),(2444,114,0,NULL),(2444,116,0,NULL),(2444,117,0,NULL),(2444,118,48,NULL),(2444,136,NULL,0.75),(2444,154,4000,NULL),(2444,156,NULL,0.75),(2444,158,4000,NULL),(2444,160,NULL,0.3),(2444,182,3441,NULL),(2444,184,3436,NULL),(2444,192,8,NULL),(2444,193,1,NULL),(2444,208,NULL,22.5),(2444,209,NULL,22.5),(2444,210,NULL,22.5),(2444,211,NULL,22.5),(2444,247,5000,NULL),(2444,263,224,NULL),(2444,265,480,NULL),(2444,267,NULL,0.4),(2444,268,NULL,0.9),(2444,269,NULL,0.75),(2444,270,NULL,0.55),(2444,271,1,NULL),(2444,272,NULL,0.4),(2444,273,NULL,0.6),(2444,274,NULL,0.8),(2444,277,1,NULL),(2444,279,1,NULL),(2444,416,1000,NULL),(2444,422,1,NULL),(2444,479,250000,NULL),(2444,482,1,NULL),(2444,484,NULL,0.75),(2444,508,250,NULL),(2444,524,NULL,0.75),(2444,525,NULL,0.75),(2444,552,100,NULL),(2444,580,1,NULL),(2444,581,1,NULL),(2444,582,2500,NULL),(2444,583,1,NULL),(2444,620,125,NULL),(2444,633,0,NULL),(2444,665,5000,NULL),(2444,1272,25,NULL),(2445,422,1,NULL),(2446,9,1421,NULL),(2446,37,840,NULL),(2446,51,4000,NULL),(2446,54,1000,NULL),(2446,55,2500000,NULL),(2446,64,NULL,1.92),(2446,70,100,NULL),(2446,79,2000,NULL),(2446,109,1,NULL),(2446,110,1,NULL),(2446,111,1,NULL),(2446,113,1,NULL),(2446,114,0,NULL),(2446,116,0,NULL),(2446,117,0,NULL),(2446,118,48,NULL),(2446,136,NULL,0.75),(2446,154,4000,NULL),(2446,156,NULL,0.75),(2446,158,4000,NULL),(2446,160,NULL,0.36),(2446,182,3441,NULL),(2446,183,12486,NULL),(2446,184,3436,NULL),(2446,192,8,NULL),(2446,193,1,NULL),(2446,208,NULL,22.5),(2446,209,NULL,22.5),(2446,210,NULL,22.5),(2446,211,NULL,22.5),(2446,247,5000,NULL),(2446,263,269,NULL),(2446,265,576,NULL),(2446,267,NULL,0.4),(2446,268,NULL,0.9),(2446,269,NULL,0.75),(2446,270,NULL,0.55),(2446,271,1,NULL),(2446,272,NULL,0.4),(2446,273,NULL,0.6),(2446,274,NULL,0.8),(2446,277,5,NULL),(2446,278,4,NULL),(2446,279,1,NULL),(2446,416,1000,NULL),(2446,422,2,NULL),(2446,479,250000,NULL),(2446,482,1,NULL),(2446,484,NULL,0.75),(2446,508,300,NULL),(2446,524,NULL,0.75),(2446,525,NULL,0.75),(2446,552,100,NULL),(2446,580,1,NULL),(2446,581,1,NULL),(2446,582,2500,NULL),(2446,583,1,NULL),(2446,620,125,NULL),(2446,633,5,NULL),(2446,665,5000,NULL),(2446,1272,25,NULL),(2447,422,2,NULL),(2454,9,296,NULL),(2454,37,2800,NULL),(2454,51,4000,NULL),(2454,54,1000,NULL),(2454,55,2500000,NULL),(2454,64,NULL,1.6),(2454,70,100,NULL),(2454,79,2000,NULL),(2454,109,1,NULL),(2454,110,1,NULL),(2454,111,1,NULL),(2454,113,1,NULL),(2454,114,0,NULL),(2454,116,0,NULL),(2454,117,0,NULL),(2454,118,15,NULL),(2454,136,NULL,0.75),(2454,154,1000,NULL),(2454,156,NULL,0.75),(2454,158,2000,NULL),(2454,160,NULL,1.815),(2454,182,3437,NULL),(2454,184,3436,NULL),(2454,192,8,NULL),(2454,193,1,NULL),(2454,208,NULL,7.5),(2454,209,NULL,7.5),(2454,210,NULL,7.5),(2454,211,NULL,7.5),(2454,247,3000,NULL),(2454,263,56,NULL),(2454,265,120,NULL),(2454,267,NULL,0.4),(2454,268,NULL,0.9),(2454,269,NULL,0.75),(2454,270,NULL,0.55),(2454,271,1,NULL),(2454,272,NULL,0.4),(2454,273,NULL,0.6),(2454,274,NULL,0.8),(2454,277,1,NULL),(2454,279,1,NULL),(2454,416,500,NULL),(2454,422,1,NULL),(2454,479,250000,NULL),(2454,482,1,NULL),(2454,484,NULL,0.75),(2454,508,550,NULL),(2454,524,NULL,0.75),(2454,525,NULL,0.75),(2454,552,25,NULL),(2454,580,1,NULL),(2454,581,1,NULL),(2454,582,2500,NULL),(2454,583,1,NULL),(2454,620,25,NULL),(2454,633,0,NULL),(2454,665,3000,NULL),(2454,1272,5,NULL),(2455,422,1,NULL),(2456,9,355,NULL),(2456,37,3360,NULL),(2456,51,4000,NULL),(2456,54,1000,NULL),(2456,55,2500000,NULL),(2456,64,NULL,1.92),(2456,70,100,NULL),(2456,79,2000,NULL),(2456,109,1,NULL),(2456,110,1,NULL),(2456,111,1,NULL),(2456,113,1,NULL),(2456,114,0,NULL),(2456,116,0,NULL),(2456,117,0,NULL),(2456,118,15,NULL),(2456,136,NULL,0.75),(2456,154,1000,NULL),(2456,156,NULL,0.75),(2456,158,2000,NULL),(2456,160,NULL,2.178),(2456,182,3437,NULL),(2456,183,12486,NULL),(2456,184,3436,NULL),(2456,192,8,NULL),(2456,193,1,NULL),(2456,208,NULL,7.5),(2456,209,NULL,7.5),(2456,210,NULL,7.5),(2456,211,NULL,7.5),(2456,247,3000,NULL),(2456,263,67,NULL),(2456,265,144,NULL),(2456,267,NULL,0.4),(2456,268,NULL,0.9),(2456,269,NULL,0.75),(2456,270,NULL,0.55),(2456,271,1,NULL),(2456,272,NULL,0.4),(2456,273,NULL,0.6),(2456,274,NULL,0.8),(2456,277,5,NULL),(2456,278,1,NULL),(2456,279,1,NULL),(2456,416,500,NULL),(2456,422,2,NULL),(2456,479,250000,NULL),(2456,482,1,NULL),(2456,484,NULL,0.75),(2456,508,660,NULL),(2456,524,NULL,0.75),(2456,525,NULL,0.75),(2456,552,25,NULL),(2456,580,1,NULL),(2456,581,1,NULL),(2456,582,2500,NULL),(2456,583,1,NULL),(2456,620,25,NULL),(2456,633,5,NULL),(2456,665,3000,NULL),(2456,1272,5,NULL),(2457,422,2,NULL),(2464,9,136,NULL),(2464,37,3200,NULL),(2464,51,4000,NULL),(2464,54,1000,NULL),(2464,55,2500000,NULL),(2464,64,NULL,1.45),(2464,70,100,NULL),(2464,79,2000,NULL),(2464,109,1,NULL),(2464,110,1,NULL),(2464,111,1,NULL),(2464,113,1,NULL),(2464,114,0,NULL),(2464,116,0,NULL),(2464,117,15,NULL),(2464,118,0,NULL),(2464,136,NULL,0.75),(2464,154,1000,NULL),(2464,156,NULL,0.75),(2464,158,2000,NULL),(2464,160,NULL,2.1),(2464,182,3437,NULL),(2464,184,3436,NULL),(2464,192,8,NULL),(2464,193,1,NULL),(2464,208,NULL,7.5),(2464,209,NULL,7.5),(2464,210,NULL,7.5),(2464,211,NULL,7.5),(2464,247,3000,NULL),(2464,263,104,NULL),(2464,265,88,NULL),(2464,267,NULL,0.4),(2464,268,NULL,0.9),(2464,269,NULL,0.75),(2464,270,NULL,0.55),(2464,271,1,NULL),(2464,272,NULL,0.4),(2464,273,NULL,0.6),(2464,274,NULL,0.8),(2464,277,1,NULL),(2464,279,1,NULL),(2464,416,500,NULL),(2464,422,1,NULL),(2464,479,250000,NULL),(2464,482,1,NULL),(2464,484,NULL,0.75),(2464,508,600,NULL),(2464,524,NULL,0.75),(2464,525,NULL,0.75),(2464,552,25,NULL),(2464,580,1,NULL),(2464,581,1,NULL),(2464,582,2500,NULL),(2464,583,1,NULL),(2464,620,25,NULL),(2464,633,0,NULL),(2464,665,3000,NULL),(2464,1272,5,NULL),(2465,422,1,NULL),(2466,9,163,NULL),(2466,37,3840,NULL),(2466,51,4000,NULL),(2466,54,1000,NULL),(2466,55,2500000,NULL),(2466,64,NULL,1.74),(2466,70,100,NULL),(2466,79,2000,NULL),(2466,109,1,NULL),(2466,110,1,NULL),(2466,111,1,NULL),(2466,113,1,NULL),(2466,114,0,NULL),(2466,116,0,NULL),(2466,117,15,NULL),(2466,118,0,NULL),(2466,136,NULL,0.75),(2466,154,1000,NULL),(2466,156,NULL,0.75),(2466,158,2000,NULL),(2466,160,NULL,2.52),(2466,182,3437,NULL),(2466,183,12487,NULL),(2466,184,3436,NULL),(2466,192,8,NULL),(2466,193,1,NULL),(2466,208,NULL,7.5),(2466,209,NULL,7.5),(2466,210,NULL,7.5),(2466,211,NULL,7.5),(2466,247,3000,NULL),(2466,263,125,NULL),(2466,265,106,NULL),(2466,267,NULL,0.4),(2466,268,NULL,0.9),(2466,269,NULL,0.75),(2466,270,NULL,0.55),(2466,271,1,NULL),(2466,272,NULL,0.4),(2466,273,NULL,0.6),(2466,274,NULL,0.8),(2466,277,5,NULL),(2466,278,1,NULL),(2466,279,1,NULL),(2466,416,500,NULL),(2466,422,2,NULL),(2466,479,250000,NULL),(2466,482,1,NULL),(2466,484,NULL,0.75),(2466,508,720,NULL),(2466,524,NULL,0.75),(2466,525,NULL,0.75),(2466,552,25,NULL),(2466,580,1,NULL),(2466,581,1,NULL),(2466,582,2500,NULL),(2466,583,1,NULL),(2466,620,25,NULL),(2466,633,5,NULL),(2466,665,3000,NULL),(2466,1272,5,NULL),(2467,422,2,NULL),(2476,9,576,NULL),(2476,37,1050,NULL),(2476,51,4000,NULL),(2476,54,1000,NULL),(2476,55,2500000,NULL),(2476,64,NULL,1.3),(2476,70,100,NULL),(2476,79,2000,NULL),(2476,109,1,NULL),(2476,110,1,NULL),(2476,111,1,NULL),(2476,113,1,NULL),(2476,114,0,NULL),(2476,116,48,NULL),(2476,117,0,NULL),(2476,118,0,NULL),(2476,136,NULL,0.75),(2476,154,4000,NULL),(2476,156,NULL,0.75),(2476,158,4000,NULL),(2476,160,NULL,0.4725),(2476,182,3441,NULL),(2476,184,3436,NULL),(2476,192,8,NULL),(2476,193,1,NULL),(2476,208,NULL,22.5),(2476,209,NULL,22.5),(2476,210,NULL,22.5),(2476,211,NULL,22.5),(2476,247,5000,NULL),(2476,263,256,NULL),(2476,265,384,NULL),(2476,267,NULL,0.4),(2476,268,NULL,0.9),(2476,269,NULL,0.75),(2476,270,NULL,0.55),(2476,271,1,NULL),(2476,272,NULL,0.4),(2476,273,NULL,0.6),(2476,274,NULL,0.8),(2476,277,1,NULL),(2476,279,1,NULL),(2476,416,1000,NULL),(2476,422,1,NULL),(2476,479,250000,NULL),(2476,482,1,NULL),(2476,484,NULL,0.75),(2476,508,350,NULL),(2476,524,NULL,0.75),(2476,525,NULL,0.75),(2476,552,100,NULL),(2476,580,1,NULL),(2476,581,1,NULL),(2476,582,2500,NULL),(2476,583,1,NULL),(2476,620,125,NULL),(2476,633,0,NULL),(2476,665,5000,NULL),(2476,1272,25,NULL),(2477,422,1,NULL),(2478,9,691,NULL),(2478,37,1260,NULL),(2478,51,4000,NULL),(2478,54,1000,NULL),(2478,55,2500000,NULL),(2478,64,NULL,1.56),(2478,70,100,NULL),(2478,79,2000,NULL),(2478,109,1,NULL),(2478,110,1,NULL),(2478,111,1,NULL),(2478,113,1,NULL),(2478,114,0,NULL),(2478,116,48,NULL),(2478,117,0,NULL),(2478,118,0,NULL),(2478,136,NULL,0.75),(2478,154,4000,NULL),(2478,156,NULL,0.75),(2478,158,4000,NULL),(2478,160,NULL,0.567),(2478,182,3441,NULL),(2478,183,12485,NULL),(2478,184,3436,NULL),(2478,192,8,NULL),(2478,193,1,NULL),(2478,208,NULL,22.5),(2478,209,NULL,22.5),(2478,210,NULL,22.5),(2478,211,NULL,22.5),(2478,247,5000,NULL),(2478,263,307,NULL),(2478,265,461,NULL),(2478,267,NULL,0.4),(2478,268,NULL,0.9),(2478,269,NULL,0.75),(2478,270,NULL,0.55),(2478,271,1,NULL),(2478,272,NULL,0.4),(2478,273,NULL,0.6),(2478,274,NULL,0.8),(2478,277,5,NULL),(2478,278,4,NULL),(2478,279,1,NULL),(2478,416,1000,NULL),(2478,422,2,NULL),(2478,479,250000,NULL),(2478,482,1,NULL),(2478,484,NULL,0.75),(2478,508,420,NULL),(2478,524,NULL,0.75),(2478,525,NULL,0.75),(2478,552,100,NULL),(2478,580,1,NULL),(2478,581,1,NULL),(2478,582,2500,NULL),(2478,583,1,NULL),(2478,620,125,NULL),(2478,633,5,NULL),(2478,665,5000,NULL),(2478,1272,25,NULL),(2479,422,2,NULL),(2486,9,144,NULL),(2486,37,4200,NULL),(2486,51,4000,NULL),(2486,54,1000,NULL),(2486,55,2500000,NULL),(2486,64,NULL,1.3),(2486,70,100,NULL),(2486,79,2000,NULL),(2486,109,1,NULL),(2486,110,1,NULL),(2486,111,1,NULL),(2486,113,1,NULL),(2486,114,0,NULL),(2486,116,15,NULL),(2486,117,0,NULL),(2486,118,0,NULL),(2486,136,NULL,0.75),(2486,154,1000,NULL),(2486,156,NULL,0.75),(2486,158,2000,NULL),(2486,160,NULL,2.7),(2486,182,3437,NULL),(2486,184,3436,NULL),(2486,192,8,NULL),(2486,193,1,NULL),(2486,208,NULL,7.5),(2486,209,NULL,7.5),(2486,210,NULL,7.5),(2486,211,NULL,7.5),(2486,247,3000,NULL),(2486,263,64,NULL),(2486,265,96,NULL),(2486,267,NULL,0.4),(2486,268,NULL,0.9),(2486,269,NULL,0.75),(2486,270,NULL,0.55),(2486,271,1,NULL),(2486,272,NULL,0.4),(2486,273,NULL,0.6),(2486,274,NULL,0.8),(2486,277,1,NULL),(2486,279,1,NULL),(2486,416,500,NULL),(2486,422,1,NULL),(2486,479,250000,NULL),(2486,482,1,NULL),(2486,484,NULL,0.75),(2486,508,750,NULL),(2486,524,NULL,0.75),(2486,525,NULL,0.75),(2486,552,25,NULL),(2486,580,1,NULL),(2486,581,1,NULL),(2486,582,2500,NULL),(2486,583,1,NULL),(2486,620,25,NULL),(2486,633,0,NULL),(2486,665,3000,NULL),(2486,1272,5,NULL),(2487,422,1,NULL),(2488,9,173,NULL),(2488,37,5040,NULL),(2488,51,4000,NULL),(2488,54,1000,NULL),(2488,55,2500000,NULL),(2488,64,NULL,1.56),(2488,70,100,NULL),(2488,79,2000,NULL),(2488,109,1,NULL),(2488,110,1,NULL),(2488,111,1,NULL),(2488,113,1,NULL),(2488,114,0,NULL),(2488,116,15,NULL),(2488,117,0,NULL),(2488,118,0,NULL),(2488,136,NULL,0.75),(2488,154,1000,NULL),(2488,156,NULL,0.75),(2488,158,2000,NULL),(2488,160,NULL,3.24),(2488,182,3437,NULL),(2488,183,12485,NULL),(2488,184,3436,NULL),(2488,192,8,NULL),(2488,193,1,NULL),(2488,208,NULL,7.5),(2488,209,NULL,7.5),(2488,210,NULL,7.5),(2488,211,NULL,7.5),(2488,247,3000,NULL),(2488,263,77,NULL),(2488,265,115,NULL),(2488,267,NULL,0.4),(2488,268,NULL,0.9),(2488,269,NULL,0.75),(2488,270,NULL,0.55),(2488,271,1,NULL),(2488,272,NULL,0.4),(2488,273,NULL,0.6),(2488,274,NULL,0.8),(2488,277,5,NULL),(2488,278,1,NULL),(2488,279,1,NULL),(2488,416,500,NULL),(2488,422,2,NULL),(2488,479,250000,NULL),(2488,482,1,NULL),(2488,484,NULL,0.75),(2488,508,900,NULL),(2488,524,NULL,0.75),(2488,525,NULL,0.75),(2488,552,25,NULL),(2488,580,1,NULL),(2488,581,1,NULL),(2488,582,2500,NULL),(2488,583,1,NULL),(2488,620,25,NULL),(2488,633,5,NULL),(2488,665,3000,NULL),(2488,1272,5,NULL),(2489,422,2,NULL),(2496,9,100000000,NULL),(2497,9,100000000,NULL),(2498,9,100000000,NULL),(2499,9,100000000,NULL),(2500,9,100000000,NULL),(2501,9,100000000,NULL),(2502,9,100000000,NULL),(2506,9,280,NULL),(2506,37,1500,NULL),(2506,70,1000,NULL),(2506,107,500,NULL),(2506,108,35,NULL),(2506,114,450,NULL),(2506,116,0,NULL),(2506,117,0,NULL),(2506,118,0,NULL),(2506,137,508,NULL),(2506,182,3325,NULL),(2506,183,3319,NULL),(2506,277,1,NULL),(2506,278,1,NULL),(2506,281,6000,NULL),(2506,422,1,NULL),(2506,525,NULL,0.75),(2506,612,0,NULL),(2506,613,0,NULL),(2506,633,0,NULL),(2506,644,1,NULL),(2506,653,71,NULL),(2506,654,450,NULL),(2506,655,1500,NULL),(2506,1353,5,NULL),(2506,1354,NULL,5.5),(2507,422,1,NULL),(2508,9,280,NULL),(2508,37,1500,NULL),(2508,70,1000,NULL),(2508,107,500,NULL),(2508,108,35,NULL),(2508,114,0,NULL),(2508,116,450,NULL),(2508,117,0,NULL),(2508,118,0,NULL),(2508,137,508,NULL),(2508,182,3325,NULL),(2508,183,3319,NULL),(2508,277,1,NULL),(2508,278,1,NULL),(2508,281,6000,NULL),(2508,422,1,NULL),(2508,525,NULL,0.75),(2508,612,0,NULL),(2508,613,0,NULL),(2508,633,0,NULL),(2508,644,1,NULL),(2508,653,71,NULL),(2508,654,450,NULL),(2508,655,1500,NULL),(2508,1353,5,NULL),(2508,1354,NULL,5.5),(2509,422,1,NULL),(2510,9,280,NULL),(2510,37,1500,NULL),(2510,70,1000,NULL),(2510,107,500,NULL),(2510,108,35,NULL),(2510,114,0,NULL),(2510,116,0,NULL),(2510,117,0,NULL),(2510,118,450,NULL),(2510,137,508,NULL),(2510,182,3325,NULL),(2510,183,3319,NULL),(2510,277,1,NULL),(2510,278,1,NULL),(2510,281,6000,NULL),(2510,422,1,NULL),(2510,525,NULL,0.75),(2510,612,0,NULL),(2510,613,0,NULL),(2510,633,0,NULL),(2510,644,1,NULL),(2510,653,71,NULL),(2510,654,450,NULL),(2510,655,1500,NULL),(2510,1353,5,NULL),(2510,1354,NULL,5.5),(2511,422,1,NULL),(2512,9,70,NULL),(2512,37,2250,NULL),(2512,70,1000,NULL),(2512,107,0,NULL),(2512,108,35,NULL),(2512,114,25,NULL),(2512,116,0,NULL),(2512,117,0,NULL),(2512,118,0,NULL),(2512,122,1,NULL),(2512,137,507,NULL),(2512,182,3320,NULL),(2512,183,3319,NULL),(2512,277,1,NULL),(2512,278,1,NULL),(2512,281,2000,NULL),(2512,422,1,NULL),(2512,525,NULL,0.75),(2512,612,0,NULL),(2512,613,0,NULL),(2512,633,0,NULL),(2512,644,1,NULL),(2512,653,85,NULL),(2512,654,20,NULL),(2512,655,1500,NULL),(2512,1353,3,NULL),(2512,1354,NULL,5.5),(2513,422,1,NULL),(2514,9,70,NULL),(2514,37,2250,NULL),(2514,70,1000,NULL),(2514,107,0,NULL),(2514,108,35,NULL),(2514,114,0,NULL),(2514,116,0,NULL),(2514,117,0,NULL),(2514,118,25,NULL),(2514,122,1,NULL),(2514,137,507,NULL),(2514,182,3320,NULL),(2514,183,3319,NULL),(2514,277,1,NULL),(2514,278,1,NULL),(2514,281,2000,NULL),(2514,422,1,NULL),(2514,525,NULL,0.75),(2514,612,0,NULL),(2514,613,0,NULL),(2514,633,0,NULL),(2514,644,1,NULL),(2514,653,85,NULL),(2514,654,20,NULL),(2514,655,1500,NULL),(2514,1353,3,NULL),(2514,1354,NULL,5.5),(2515,422,1,NULL),(2516,9,70,NULL),(2516,37,2250,NULL),(2516,70,1000,NULL),(2516,107,0,NULL),(2516,108,35,NULL),(2516,114,0,NULL),(2516,116,25,NULL),(2516,117,0,NULL),(2516,118,0,NULL),(2516,122,1,NULL),(2516,137,507,NULL),(2516,182,3320,NULL),(2516,183,3319,NULL),(2516,277,1,NULL),(2516,278,1,NULL),(2516,281,2000,NULL),(2516,422,1,NULL),(2516,525,NULL,0.75),(2516,612,0,NULL),(2516,613,0,NULL),(2516,633,0,NULL),(2516,644,1,NULL),(2516,653,85,NULL),(2516,654,20,NULL),(2516,655,1500,NULL),(2516,1353,3,NULL),(2516,1354,NULL,5.5),(2517,422,1,NULL),(2526,9,99999,NULL),(2526,182,9955,NULL),(2526,277,1,NULL),(2526,633,20,NULL),(2527,9,99999,NULL),(2527,182,9955,NULL),(2527,277,1,NULL),(2527,633,20,NULL),(2528,9,99999,NULL),(2528,182,9955,NULL),(2528,277,1,NULL),(2528,633,20,NULL),(2529,9,40,NULL),(2529,30,1,NULL),(2529,50,25,NULL),(2529,72,0,NULL),(2529,182,3425,NULL),(2529,277,1,NULL),(2529,422,1,NULL),(2529,633,0,NULL),(2529,984,0,NULL),(2529,985,NULL,-32.5),(2529,986,0,NULL),(2529,987,0,NULL),(2530,422,1,NULL),(2531,9,40,NULL),(2531,30,1,NULL),(2531,50,30,NULL),(2531,72,0,NULL),(2531,182,3425,NULL),(2531,277,4,NULL),(2531,422,2,NULL),(2531,633,5,NULL),(2531,984,0,NULL),(2531,985,NULL,-37.5),(2531,986,0,NULL),(2531,987,0,NULL),(2532,422,2,NULL),(2537,9,40,NULL),(2537,30,1,NULL),(2537,50,25,NULL),(2537,72,0,NULL),(2537,182,3425,NULL),(2537,277,1,NULL),(2537,422,1,NULL),(2537,633,0,NULL),(2537,984,0,NULL),(2537,985,0,NULL),(2537,986,0,NULL),(2537,987,NULL,-32.5),(2538,422,1,NULL),(2539,9,40,NULL),(2539,30,1,NULL),(2539,50,30,NULL),(2539,72,0,NULL),(2539,182,3425,NULL),(2539,277,4,NULL),(2539,422,2,NULL),(2539,633,5,NULL),(2539,984,0,NULL),(2539,985,0,NULL),(2539,986,0,NULL),(2539,987,NULL,-37.5),(2540,422,2,NULL),(2545,9,40,NULL),(2545,30,1,NULL),(2545,50,25,NULL),(2545,72,0,NULL),(2545,182,3425,NULL),(2545,277,1,NULL),(2545,422,1,NULL),(2545,633,0,NULL),(2545,984,0,NULL),(2545,985,0,NULL),(2545,986,NULL,-32.5),(2545,987,0,NULL),(2546,422,1,NULL),(2547,9,40,NULL),(2547,30,1,NULL),(2547,50,30,NULL),(2547,72,0,NULL),(2547,182,3425,NULL),(2547,277,4,NULL),(2547,422,2,NULL),(2547,633,5,NULL),(2547,984,0,NULL),(2547,985,0,NULL),(2547,986,NULL,-37.5),(2547,987,0,NULL),(2548,422,2,NULL),(2553,9,40,NULL),(2553,30,1,NULL),(2553,50,30,NULL),(2553,72,0,NULL),(2553,182,3425,NULL),(2553,277,4,NULL),(2553,422,2,NULL),(2553,633,5,NULL),(2553,984,NULL,-37.5),(2553,985,0,NULL),(2553,986,0,NULL),(2553,987,0,NULL),(2554,422,2,NULL),(2559,6,57,NULL),(2559,9,40,NULL),(2559,30,1,NULL),(2559,50,48,NULL),(2559,54,32076,NULL),(2559,73,20000,NULL),(2559,158,35640,NULL),(2559,182,3427,NULL),(2559,238,NULL,1.2),(2559,239,NULL,3.6),(2559,240,NULL,1.2),(2559,241,NULL,1.2),(2559,277,4,NULL),(2559,422,2,NULL),(2559,633,5,NULL),(2559,831,0,NULL),(2559,1180,NULL,0.02),(2559,1211,NULL,6.6),(2559,1212,1,NULL),(2559,1225,20,NULL),(2563,6,57,NULL),(2563,9,40,NULL),(2563,30,1,NULL),(2563,50,48,NULL),(2563,54,32076,NULL),(2563,73,20000,NULL),(2563,158,35640,NULL),(2563,182,3427,NULL),(2563,238,NULL,1.2),(2563,239,NULL,1.2),(2563,240,NULL,3.6),(2563,241,NULL,1.2),(2563,277,4,NULL),(2563,422,2,NULL),(2563,633,5,NULL),(2563,831,0,NULL),(2563,1180,NULL,0.02),(2563,1211,NULL,6.6),(2563,1212,1,NULL),(2563,1225,20,NULL),(2567,6,79,NULL),(2567,9,40,NULL),(2567,30,1,NULL),(2567,50,55,NULL),(2567,54,21384,NULL),(2567,73,20000,NULL),(2567,158,23760,NULL),(2567,182,3427,NULL),(2567,238,NULL,2.4),(2567,239,NULL,2.4),(2567,240,NULL,2.4),(2567,241,NULL,2.4),(2567,277,4,NULL),(2567,422,2,NULL),(2567,633,5,NULL),(2567,831,0,NULL),(2567,1180,NULL,0.02),(2567,1211,NULL,6.6),(2567,1212,1,NULL),(2567,1225,20,NULL),(2571,6,57,NULL),(2571,9,40,NULL),(2571,30,1,NULL),(2571,50,48,NULL),(2571,54,32076,NULL),(2571,73,20000,NULL),(2571,158,35640,NULL),(2571,182,3427,NULL),(2571,238,NULL,3.6),(2571,239,NULL,1.2),(2571,240,NULL,1.2),(2571,241,NULL,1.2),(2571,277,4,NULL),(2571,422,2,NULL),(2571,633,5,NULL),(2571,831,0,NULL),(2571,1180,NULL,0.02),(2571,1211,NULL,6.6),(2571,1212,1,NULL),(2571,1225,20,NULL),(2575,6,57,NULL),(2575,9,40,NULL),(2575,30,1,NULL),(2575,50,48,NULL),(2575,54,32076,NULL),(2575,73,20000,NULL),(2575,158,35640,NULL),(2575,182,3427,NULL),(2575,238,NULL,1.2),(2575,239,NULL,1.2),(2575,240,NULL,1.2),(2575,241,NULL,3.6),(2575,277,4,NULL),(2575,422,2,NULL),(2575,633,5,NULL),(2575,831,0,NULL),(2575,1180,NULL,0.02),(2575,1211,NULL,6.6),(2575,1212,1,NULL),(2575,1225,20,NULL),(2579,9,40,NULL),(2579,30,1,NULL),(2579,50,15,NULL),(2579,182,3432,NULL),(2579,277,1,NULL),(2579,422,1,NULL),(2579,633,0,NULL),(2579,1027,40,NULL),(2579,1028,0,NULL),(2579,1029,0,NULL),(2579,1030,0,NULL),(2580,9,40,NULL),(2580,30,1,NULL),(2580,50,18,NULL),(2580,182,3432,NULL),(2580,277,3,NULL),(2580,422,2,NULL),(2580,633,5,NULL),(2580,1027,48,NULL),(2580,1028,0,NULL),(2580,1029,0,NULL),(2580,1030,0,NULL),(2583,9,40,NULL),(2583,30,1,NULL),(2583,50,15,NULL),(2583,182,3432,NULL),(2583,277,1,NULL),(2583,422,1,NULL),(2583,633,0,NULL),(2583,1027,0,NULL),(2583,1028,40,NULL),(2583,1029,0,NULL),(2583,1030,0,NULL),(2584,9,40,NULL),(2584,30,1,NULL),(2584,50,18,NULL),(2584,182,3432,NULL),(2584,277,3,NULL),(2584,422,2,NULL),(2584,633,5,NULL),(2584,1027,0,NULL),(2584,1028,48,NULL),(2584,1029,0,NULL),(2584,1030,0,NULL),(2587,9,40,NULL),(2587,30,1,NULL),(2587,50,15,NULL),(2587,182,3432,NULL),(2587,277,1,NULL),(2587,422,1,NULL),(2587,633,0,NULL),(2587,1027,0,NULL),(2587,1028,0,NULL),(2587,1029,40,NULL),(2587,1030,0,NULL),(2588,9,40,NULL),(2588,30,1,NULL),(2588,50,18,NULL),(2588,182,3432,NULL),(2588,277,3,NULL),(2588,422,2,NULL),(2588,633,5,NULL),(2588,1027,0,NULL),(2588,1028,0,NULL),(2588,1029,48,NULL),(2588,1030,0,NULL),(2591,9,40,NULL),(2591,30,1,NULL),(2591,50,15,NULL),(2591,182,3432,NULL),(2591,277,1,NULL),(2591,422,1,NULL),(2591,633,0,NULL),(2591,1027,40,NULL),(2591,1028,40,NULL),(2591,1029,40,NULL),(2591,1030,40,NULL),(2592,9,40,NULL),(2592,30,1,NULL),(2592,50,18,NULL),(2592,182,3432,NULL),(2592,277,3,NULL),(2592,422,2,NULL),(2592,633,5,NULL),(2592,1027,48,NULL),(2592,1028,48,NULL),(2592,1029,48,NULL),(2592,1030,48,NULL),(2603,9,40,NULL),(2603,150,NULL,0.85),(2603,169,NULL,-13.1),(2603,182,3394,NULL),(2603,277,1,NULL),(2603,422,1,NULL),(2603,633,0,NULL),(2603,1076,NULL,7.85),(2604,9,1,NULL),(2604,422,1,NULL),(2605,9,40,NULL),(2605,150,NULL,0.8),(2605,169,NULL,-15.8),(2605,182,3394,NULL),(2605,277,2,NULL),(2605,422,2,NULL),(2605,633,5,NULL),(2605,1076,NULL,9.4),(2606,9,1,NULL),(2606,422,2,NULL),(2612,9,100000000,NULL),(2613,9,70,NULL),(2613,37,3750,NULL),(2613,70,1000,NULL),(2613,107,0,NULL),(2613,108,35,NULL),(2613,114,96,NULL),(2613,116,0,NULL),(2613,117,0,NULL),(2613,118,0,NULL),(2613,137,509,NULL),(2613,182,20210,NULL),(2613,183,3321,NULL),(2613,184,3319,NULL),(2613,277,1,NULL),(2613,278,5,NULL),(2613,279,5,NULL),(2613,281,4500,NULL),(2613,422,2,NULL),(2613,525,NULL,0.75),(2613,554,7,NULL),(2613,633,5,NULL),(2613,644,1,NULL),(2613,653,174,NULL),(2613,654,85,NULL),(2613,655,1500,NULL),(2613,1353,NULL,3.2),(2613,1354,NULL,5.5),(2614,422,2,NULL),(2621,9,70,NULL),(2621,37,3750,NULL),(2621,70,1000,NULL),(2621,107,0,NULL),(2621,108,35,NULL),(2621,114,0,NULL),(2621,116,0,NULL),(2621,117,0,NULL),(2621,118,384,NULL),(2621,137,506,NULL),(2621,182,20212,NULL),(2621,183,3326,NULL),(2621,184,3319,NULL),(2621,277,1,NULL),(2621,278,5,NULL),(2621,279,5,NULL),(2621,281,18000,NULL),(2621,422,2,NULL),(2621,525,NULL,0.75),(2621,554,NULL,4.5),(2621,633,5,NULL),(2621,644,1,NULL),(2621,653,58,NULL),(2621,654,550,NULL),(2621,655,1500,NULL),(2621,1353,NULL,4.7),(2621,1354,NULL,5.5),(2622,422,2,NULL),(2629,9,70,NULL),(2629,37,3750,NULL),(2629,70,1000,NULL),(2629,107,0,NULL),(2629,108,300,NULL),(2629,114,0,NULL),(2629,116,0,NULL),(2629,117,192,NULL),(2629,118,0,NULL),(2629,137,510,NULL),(2629,182,20211,NULL),(2629,183,3324,NULL),(2629,184,3319,NULL),(2629,277,1,NULL),(2629,278,5,NULL),(2629,279,5,NULL),(2629,281,9000,NULL),(2629,422,2,NULL),(2629,525,NULL,0.75),(2629,554,NULL,5.4),(2629,633,5,NULL),(2629,644,1,NULL),(2629,653,97,NULL),(2629,654,215,NULL),(2629,655,1500,NULL),(2629,1353,NULL,4.5),(2629,1354,NULL,5.5),(2630,422,2,NULL),(2637,9,70,NULL),(2637,37,3750,NULL),(2637,70,1000,NULL),(2637,107,0,NULL),(2637,108,35,NULL),(2637,114,0,NULL),(2637,116,0,NULL),(2637,117,0,NULL),(2637,118,260,NULL),(2637,137,506,NULL),(2637,182,20212,NULL),(2637,183,3326,NULL),(2637,184,3319,NULL),(2637,277,1,NULL),(2637,278,5,NULL),(2637,279,5,NULL),(2637,281,10000,NULL),(2637,306,NULL,0.96),(2637,422,2,NULL),(2637,525,NULL,0.75),(2637,633,5,NULL),(2637,644,1,NULL),(2637,653,71,NULL),(2637,654,270,NULL),(2637,655,1500,NULL),(2637,1353,NULL,3.5),(2637,1354,NULL,5.5),(2638,422,2,NULL),(2647,9,70,NULL),(2647,37,3750,NULL),(2647,70,1000,NULL),(2647,107,0,NULL),(2647,108,35,NULL),(2647,114,0,NULL),(2647,116,0,NULL),(2647,117,0,NULL),(2647,118,65,NULL),(2647,137,509,NULL),(2647,182,20210,NULL),(2647,183,3321,NULL),(2647,184,3319,NULL),(2647,277,1,NULL),(2647,278,5,NULL),(2647,279,5,NULL),(2647,281,2500,NULL),(2647,306,NULL,0.925),(2647,422,2,NULL),(2647,525,NULL,0.75),(2647,633,5,NULL),(2647,644,1,NULL),(2647,653,179,NULL),(2647,654,35,NULL),(2647,655,1500,NULL),(2647,1353,NULL,2.6),(2647,1354,NULL,5.5),(2648,422,2,NULL),(2655,9,70,NULL),(2655,37,3750,NULL),(2655,70,1000,NULL),(2655,107,0,NULL),(2655,108,35,NULL),(2655,114,0,NULL),(2655,116,130,NULL),(2655,117,0,NULL),(2655,118,0,NULL),(2655,137,510,NULL),(2655,182,20211,NULL),(2655,183,3324,NULL),(2655,184,3319,NULL),(2655,277,1,NULL),(2655,278,5,NULL),(2655,279,5,NULL),(2655,281,5000,NULL),(2655,306,NULL,0.95),(2655,422,2,NULL),(2655,525,NULL,0.75),(2655,633,5,NULL),(2655,644,1,NULL),(2655,653,87,NULL),(2655,654,112,NULL),(2655,655,1500,NULL),(2655,1353,NULL,2.7),(2655,1354,NULL,5.5),(2656,422,2,NULL),(2679,9,70,NULL),(2679,37,1875,NULL),(2679,70,1000,NULL),(2679,107,0,NULL),(2679,108,35,NULL),(2679,114,0,NULL),(2679,116,0,NULL),(2679,117,128,NULL),(2679,118,0,NULL),(2679,137,771,NULL),(2679,182,25718,NULL),(2679,183,25719,NULL),(2679,184,3319,NULL),(2679,277,1,NULL),(2679,278,5,NULL),(2679,279,5,NULL),(2679,281,4300,NULL),(2679,422,2,NULL),(2679,525,NULL,0.75),(2679,554,NULL,5.4),(2679,633,5,NULL),(2679,644,1,NULL),(2679,653,93,NULL),(2679,654,180,NULL),(2679,655,1500,NULL),(2679,1353,NULL,4.8),(2679,1354,NULL,5.5),(2680,422,2,NULL),(2801,9,280,NULL),(2801,37,2250,NULL),(2801,70,1000,NULL),(2801,107,800,NULL),(2801,108,35,NULL),(2801,114,0,NULL),(2801,116,405,NULL),(2801,117,0,NULL),(2801,118,0,NULL),(2801,137,508,NULL),(2801,182,20213,NULL),(2801,183,3325,NULL),(2801,184,3319,NULL),(2801,277,1,NULL),(2801,278,5,NULL),(2801,279,5,NULL),(2801,281,6000,NULL),(2801,306,NULL,0.96),(2801,422,2,NULL),(2801,525,NULL,0.75),(2801,612,0,NULL),(2801,613,0,NULL),(2801,633,5,NULL),(2801,644,1,NULL),(2801,653,71,NULL),(2801,654,450,NULL),(2801,655,1500,NULL),(2801,1353,NULL,5.2),(2801,1354,NULL,5.5),(2802,422,2,NULL),(2809,9,70,NULL),(2809,37,1750,NULL),(2809,70,1000,NULL),(2809,107,0,NULL),(2809,108,35,NULL),(2809,114,0,NULL),(2809,116,0,NULL),(2809,117,0,NULL),(2809,118,30,NULL),(2809,122,1,NULL),(2809,137,507,NULL),(2809,182,3320,NULL),(2809,183,3319,NULL),(2809,277,4,NULL),(2809,278,1,NULL),(2809,281,2500,NULL),(2809,422,2,NULL),(2809,525,NULL,0.75),(2809,612,0,NULL),(2809,613,0,NULL),(2809,633,0,NULL),(2809,644,1,NULL),(2809,653,500,NULL),(2809,654,50,NULL),(2809,655,3000,NULL),(2811,9,280,NULL),(2811,37,1250,NULL),(2811,70,1000,NULL),(2811,107,0,NULL),(2811,108,35,NULL),(2811,114,0,NULL),(2811,116,0,NULL),(2811,117,0,NULL),(2811,118,576,NULL),(2811,137,508,NULL),(2811,182,20213,NULL),(2811,183,3325,NULL),(2811,184,3319,NULL),(2811,277,1,NULL),(2811,278,5,NULL),(2811,279,5,NULL),(2811,281,6400,NULL),(2811,422,2,NULL),(2811,525,NULL,0.75),(2811,554,NULL,4.5),(2811,612,0,NULL),(2811,613,0,NULL),(2811,633,5,NULL),(2811,644,0,NULL),(2811,653,61,NULL),(2811,654,650,NULL),(2811,655,750,NULL),(2811,1353,NULL,5.2),(2811,1354,NULL,5.5),(2812,422,2,NULL),(2817,9,70,NULL),(2817,37,2250,NULL),(2817,70,1000,NULL),(2817,107,0,NULL),(2817,108,35,NULL),(2817,114,32,NULL),(2817,116,0,NULL),(2817,117,0,NULL),(2817,118,0,NULL),(2817,122,1,NULL),(2817,137,507,NULL),(2817,182,20209,NULL),(2817,183,3320,NULL),(2817,184,3319,NULL),(2817,277,1,NULL),(2817,278,5,NULL),(2817,279,5,NULL),(2817,281,1800,NULL),(2817,422,2,NULL),(2817,525,NULL,0.75),(2817,554,7,NULL),(2817,612,0,NULL),(2817,613,0,NULL),(2817,633,5,NULL),(2817,644,1,NULL),(2817,653,82,NULL),(2817,654,30,NULL),(2817,655,1000,NULL),(2817,1353,NULL,4.5),(2817,1354,NULL,5.5),(2818,422,2,NULL),(2849,9,70,NULL),(2849,37,3250,NULL),(2849,70,1000,NULL),(2849,107,0,NULL),(2849,108,35,NULL),(2849,114,0,NULL),(2849,116,25,NULL),(2849,117,0,NULL),(2849,118,0,NULL),(2849,122,1,NULL),(2849,137,507,NULL),(2849,182,3320,NULL),(2849,183,3319,NULL),(2849,277,4,NULL),(2849,278,1,NULL),(2849,281,4000,NULL),(2849,422,2,NULL),(2849,525,NULL,0.75),(2849,612,0,NULL),(2849,613,0,NULL),(2849,633,0,NULL),(2849,644,1,NULL),(2849,653,1500,NULL),(2849,654,25,NULL),(2849,655,1250,NULL),(2857,9,70,NULL),(2857,37,3250,NULL),(2857,70,1000,NULL),(2857,107,0,NULL),(2857,108,35,NULL),(2857,114,0,NULL),(2857,116,0,NULL),(2857,117,25,NULL),(2857,118,0,NULL),(2857,122,1,NULL),(2857,137,507,NULL),(2857,182,3320,NULL),(2857,183,3319,NULL),(2857,277,4,NULL),(2857,278,1,NULL),(2857,281,4000,NULL),(2857,422,2,NULL),(2857,525,NULL,0.75),(2857,612,0,NULL),(2857,613,0,NULL),(2857,633,0,NULL),(2857,644,1,NULL),(2857,653,1500,NULL),(2857,654,25,NULL),(2857,655,1250,NULL),(2865,6,0,NULL),(2865,9,40,NULL),(2865,30,3025,NULL),(2865,47,1,NULL),(2865,50,44,NULL),(2865,51,19125,NULL),(2865,54,38640,NULL),(2865,56,1,NULL),(2865,63,0,NULL),(2865,64,NULL,5.544),(2865,128,3,NULL),(2865,158,35000,NULL),(2865,160,NULL,0.01125),(2865,182,3308,NULL),(2865,183,3300,NULL),(2865,184,12203,NULL),(2865,277,4,NULL),(2865,278,5,NULL),(2865,279,1,NULL),(2865,422,2,NULL),(2865,604,83,NULL),(2865,605,376,NULL),(2865,620,400,NULL),(2865,633,5,NULL),(2865,920,0,NULL),(2865,1180,NULL,0.02),(2865,1205,-15,NULL),(2865,1211,NULL,2.1),(2865,1212,1,NULL),(2866,422,2,NULL),(2873,6,0,NULL),(2873,9,40,NULL),(2873,30,1,NULL),(2873,47,1,NULL),(2873,50,3,NULL),(2873,51,3000,NULL),(2873,54,960,NULL),(2873,56,1,NULL),(2873,63,0,NULL),(2873,64,NULL,2.475),(2873,128,1,NULL),(2873,158,4000,NULL),(2873,160,NULL,0.395),(2873,182,3302,NULL),(2873,183,3300,NULL),(2873,184,11084,NULL),(2873,277,4,NULL),(2873,278,2,NULL),(2873,279,1,NULL),(2873,422,2,NULL),(2873,604,83,NULL),(2873,605,372,NULL),(2873,620,40,NULL),(2873,633,5,NULL),(2873,920,0,NULL),(2873,1180,NULL,0.02),(2873,1210,15,NULL),(2873,1211,NULL,0.8),(2873,1212,1,NULL),(2874,422,2,NULL),(2881,6,0,NULL),(2881,9,40,NULL),(2881,30,2,NULL),(2881,47,1,NULL),(2881,50,6,NULL),(2881,51,3375,NULL),(2881,54,1080,NULL),(2881,56,1,NULL),(2881,63,0,NULL),(2881,64,NULL,2.97),(2881,128,1,NULL),(2881,158,4000,NULL),(2881,160,NULL,0.35),(2881,182,3302,NULL),(2881,183,3300,NULL),(2881,184,11084,NULL),(2881,277,4,NULL),(2881,278,2,NULL),(2881,279,1,NULL),(2881,422,2,NULL),(2881,604,83,NULL),(2881,605,372,NULL),(2881,620,40,NULL),(2881,633,5,NULL),(2881,920,0,NULL),(2881,1180,NULL,0.02),(2881,1210,15,NULL),(2881,1211,NULL,0.8),(2881,1212,1,NULL),(2889,6,0,NULL),(2889,9,40,NULL),(2889,30,4,NULL),(2889,47,1,NULL),(2889,50,9,NULL),(2889,51,3750,NULL),(2889,54,1200,NULL),(2889,56,1,NULL),(2889,63,0,NULL),(2889,64,NULL,3.465),(2889,128,1,NULL),(2889,158,4000,NULL),(2889,160,NULL,0.315),(2889,182,3302,NULL),(2889,183,3300,NULL),(2889,184,11084,NULL),(2889,277,4,NULL),(2889,278,2,NULL),(2889,279,1,NULL),(2889,422,2,NULL),(2889,604,83,NULL),(2889,605,372,NULL),(2889,620,40,NULL),(2889,633,5,NULL),(2889,920,0,NULL),(2889,1180,NULL,0.02),(2889,1210,15,NULL),(2889,1211,1,NULL),(2889,1212,1,NULL),(2890,422,2,NULL),(2897,6,0,NULL),(2897,9,40,NULL),(2897,30,110,NULL),(2897,47,1,NULL),(2897,50,22,NULL),(2897,51,4725,NULL),(2897,54,2160,NULL),(2897,56,1,NULL),(2897,63,0,NULL),(2897,64,NULL,2.772),(2897,128,2,NULL),(2897,158,8000,NULL),(2897,160,NULL,0.1175),(2897,182,3305,NULL),(2897,183,3300,NULL),(2897,184,12208,NULL),(2897,277,4,NULL),(2897,278,3,NULL),(2897,279,1,NULL),(2897,422,2,NULL),(2897,604,83,NULL),(2897,605,372,NULL),(2897,620,125,NULL),(2897,633,5,NULL),(2897,920,0,NULL),(2897,1180,NULL,0.02),(2897,1210,15,NULL),(2897,1211,NULL,0.7),(2897,1212,1,NULL),(2898,422,2,NULL),(2905,6,0,NULL),(2905,9,40,NULL),(2905,30,9,NULL),(2905,47,1,NULL),(2905,50,13,NULL),(2905,51,8500,NULL),(2905,54,9660,NULL),(2905,56,1,NULL),(2905,63,0,NULL),(2905,64,NULL,5.544),(2905,128,1,NULL),(2905,158,8750,NULL),(2905,160,NULL,0.082),(2905,182,3302,NULL),(2905,183,3300,NULL),(2905,184,12201,NULL),(2905,277,4,NULL),(2905,278,2,NULL),(2905,279,1,NULL),(2905,422,2,NULL),(2905,604,83,NULL),(2905,605,376,NULL),(2905,620,40,NULL),(2905,633,5,NULL),(2905,920,0,NULL),(2905,1180,NULL,0.02),(2905,1205,-15,NULL),(2905,1211,NULL,2.2),(2905,1212,1,NULL),(2906,422,2,NULL),(2913,6,0,NULL),(2913,9,40,NULL),(2913,30,154,NULL),(2913,47,1,NULL),(2913,50,25,NULL),(2913,51,5625,NULL),(2913,54,2400,NULL),(2913,56,1,NULL),(2913,63,0,NULL),(2913,64,NULL,3.465),(2913,128,2,NULL),(2913,158,8000,NULL),(2913,160,NULL,0.1056),(2913,182,3305,NULL),(2913,183,3300,NULL),(2913,184,12208,NULL),(2913,277,4,NULL),(2913,278,3,NULL),(2913,279,1,NULL),(2913,422,2,NULL),(2913,604,83,NULL),(2913,605,372,NULL),(2913,620,125,NULL),(2913,633,5,NULL),(2913,920,0,NULL),(2913,1180,NULL,0.02),(2913,1210,15,NULL),(2913,1211,NULL,0.8),(2913,1212,1,NULL),(2914,422,2,NULL),(2921,6,0,NULL),(2921,9,40,NULL),(2921,30,220,NULL),(2921,47,1,NULL),(2921,50,28,NULL),(2921,51,12750,NULL),(2921,54,19320,NULL),(2921,56,1,NULL),(2921,63,0,NULL),(2921,64,NULL,5.544),(2921,128,2,NULL),(2921,158,17500,NULL),(2921,160,NULL,0.027),(2921,182,3305,NULL),(2921,183,3300,NULL),(2921,184,12202,NULL),(2921,277,4,NULL),(2921,278,3,NULL),(2921,279,1,NULL),(2921,422,2,NULL),(2921,604,83,NULL),(2921,605,376,NULL),(2921,620,125,NULL),(2921,633,5,NULL),(2921,920,0,NULL),(2921,1180,NULL,0.02),(2921,1205,-15,NULL),(2921,1211,NULL,1.9),(2921,1212,1,NULL),(2922,422,2,NULL),(2929,6,0,NULL),(2929,9,40,NULL),(2929,30,2200,NULL),(2929,47,1,NULL),(2929,50,41,NULL),(2929,51,7875,NULL),(2929,54,4800,NULL),(2929,56,1,NULL),(2929,63,0,NULL),(2929,64,NULL,3.234),(2929,128,3,NULL),(2929,158,16000,NULL),(2929,160,NULL,0.0432),(2929,182,3308,NULL),(2929,183,3300,NULL),(2929,184,12209,NULL),(2929,277,4,NULL),(2929,278,5,NULL),(2929,279,1,NULL),(2929,422,2,NULL),(2929,604,83,NULL),(2929,605,372,NULL),(2929,620,400,NULL),(2929,633,5,NULL),(2929,920,0,NULL),(2929,1180,NULL,0.02),(2929,1210,15,NULL),(2929,1211,NULL,0.9),(2929,1212,1,NULL),(2937,6,0,NULL),(2937,9,40,NULL),(2937,30,88,NULL),(2937,47,1,NULL),(2937,50,19,NULL),(2937,51,4500,NULL),(2937,54,1920,NULL),(2937,56,1,NULL),(2937,63,0,NULL),(2937,64,NULL,2.475),(2937,128,2,NULL),(2937,158,8000,NULL),(2937,160,NULL,0.132),(2937,182,3305,NULL),(2937,183,3300,NULL),(2937,184,12208,NULL),(2937,277,4,NULL),(2937,278,3,NULL),(2937,279,1,NULL),(2937,422,2,NULL),(2937,604,83,NULL),(2937,605,372,NULL),(2937,620,125,NULL),(2937,633,5,NULL),(2937,920,0,NULL),(2937,1180,NULL,0.02),(2937,1210,15,NULL),(2937,1211,NULL,0.7),(2937,1212,1,NULL),(2938,422,2,NULL),(2945,6,0,NULL),(2945,9,40,NULL),(2945,30,1375,NULL),(2945,47,1,NULL),(2945,50,35,NULL),(2945,51,6750,NULL),(2945,54,3840,NULL),(2945,56,1,NULL),(2945,63,0,NULL),(2945,64,NULL,2.475),(2945,128,3,NULL),(2945,158,16000,NULL),(2945,160,NULL,0.054),(2945,182,3308,NULL),(2945,183,3300,NULL),(2945,184,12209,NULL),(2945,277,4,NULL),(2945,278,5,NULL),(2945,279,1,NULL),(2945,422,2,NULL),(2945,604,83,NULL),(2945,605,372,NULL),(2945,620,400,NULL),(2945,633,5,NULL),(2945,920,0,NULL),(2945,1180,NULL,0.02),(2945,1210,15,NULL),(2945,1211,NULL,0.7),(2945,1212,1,NULL),(2946,422,2,NULL),(2953,6,0,NULL),(2953,9,40,NULL),(2953,30,1650,NULL),(2953,47,1,NULL),(2953,50,38,NULL),(2953,51,7500,NULL),(2953,54,4320,NULL),(2953,56,1,NULL),(2953,63,0,NULL),(2953,64,NULL,2.93304365),(2953,128,3,NULL),(2953,158,16000,NULL),(2953,160,NULL,0.048),(2953,182,3308,NULL),(2953,183,3300,NULL),(2953,184,12209,NULL),(2953,277,4,NULL),(2953,278,5,NULL),(2953,279,1,NULL),(2953,422,2,NULL),(2953,604,83,NULL),(2953,605,372,NULL),(2953,620,400,NULL),(2953,633,5,NULL),(2953,920,0,NULL),(2953,1180,NULL,0.02),(2953,1210,15,NULL),(2953,1211,NULL,0.8),(2953,1212,1,NULL),(2954,422,2,NULL),(2961,6,0,NULL),(2961,9,40,NULL),(2961,30,3575,NULL),(2961,47,1,NULL),(2961,50,47,NULL),(2961,51,23625,NULL),(2961,54,48000,NULL),(2961,56,1,NULL),(2961,63,0,NULL),(2961,64,NULL,7.245),(2961,128,3,NULL),(2961,158,35000,NULL),(2961,160,NULL,0.009),(2961,182,3308,NULL),(2961,183,3300,NULL),(2961,184,12203,NULL),(2961,277,4,NULL),(2961,278,5,NULL),(2961,279,1,NULL),(2961,422,2,NULL),(2961,604,83,NULL),(2961,605,376,NULL),(2961,620,400,NULL),(2961,633,5,NULL),(2961,920,0,NULL),(2961,1180,NULL,0.02),(2961,1205,-15,NULL),(2961,1211,NULL,2.6),(2961,1212,1,NULL),(2962,422,2,NULL),(2969,6,0,NULL),(2969,9,40,NULL),(2969,30,275,NULL),(2969,47,1,NULL),(2969,50,32,NULL),(2969,51,15750,NULL),(2969,54,24000,NULL),(2969,56,1,NULL),(2969,63,0,NULL),(2969,64,NULL,7.245),(2969,128,2,NULL),(2969,158,17500,NULL),(2969,160,NULL,0.022),(2969,182,3305,NULL),(2969,183,3300,NULL),(2969,184,12202,NULL),(2969,277,4,NULL),(2969,278,3,NULL),(2969,279,1,NULL),(2969,422,2,NULL),(2969,604,83,NULL),(2969,605,376,NULL),(2969,620,125,NULL),(2969,633,5,NULL),(2969,920,0,NULL),(2969,1180,NULL,0.02),(2969,1205,-15,NULL),(2969,1211,NULL,2.4),(2969,1212,1,NULL),(2970,422,2,NULL),(2977,6,0,NULL),(2977,9,40,NULL),(2977,30,13,NULL),(2977,47,1,NULL),(2977,50,16,NULL),(2977,51,10500,NULL),(2977,54,12000,NULL),(2977,56,1,NULL),(2977,63,0,NULL),(2977,64,NULL,7.245),(2977,128,1,NULL),(2977,158,8750,NULL),(2977,160,NULL,0.066),(2977,182,3302,NULL),(2977,183,3300,NULL),(2977,184,12201,NULL),(2977,277,4,NULL),(2977,278,2,NULL),(2977,279,1,NULL),(2977,422,2,NULL),(2977,604,83,NULL),(2977,605,376,NULL),(2977,620,40,NULL),(2977,633,5,NULL),(2977,920,0,NULL),(2977,1180,NULL,0.02),(2977,1205,-15,NULL),(2977,1211,NULL,2.6),(2977,1212,1,NULL),(2978,422,2,NULL),(2985,6,35,NULL),(2985,9,40,NULL),(2985,30,1925,NULL),(2985,47,1,NULL),(2985,50,47,NULL),(2985,51,7200,NULL),(2985,54,42000,NULL),(2985,61,0,NULL),(2985,64,NULL,2.4),(2985,128,3,NULL),(2985,158,12000,NULL),(2985,160,NULL,0.0175),(2985,182,3309,NULL),(2985,183,3300,NULL),(2985,184,12205,NULL),(2985,277,5,NULL),(2985,278,5,NULL),(2985,279,1,NULL),(2985,422,2,NULL),(2985,604,86,NULL),(2985,605,374,NULL),(2985,620,400,NULL),(2985,633,5,NULL),(2985,1180,NULL,0.02),(2985,1205,-15,NULL),(2985,1211,NULL,0.8),(2985,1212,1,NULL),(2986,422,2,NULL),(2993,6,NULL,3.89),(2993,9,40,NULL),(2993,30,8,NULL),(2993,47,1,NULL),(2993,50,13,NULL),(2993,51,3200,NULL),(2993,54,10500,NULL),(2993,61,0,NULL),(2993,64,NULL,2.4),(2993,128,1,NULL),(2993,158,3000,NULL),(2993,160,NULL,0.13),(2993,182,3303,NULL),(2993,183,3300,NULL),(2993,184,11083,NULL),(2993,277,5,NULL),(2993,278,1,NULL),(2993,279,1,NULL),(2993,422,2,NULL),(2993,604,86,NULL),(2993,605,374,NULL),(2993,620,40,NULL),(2993,633,5,NULL),(2993,1180,NULL,0.02),(2993,1205,-15,NULL),(2993,1211,NULL,0.8),(2993,1212,1,NULL),(2994,422,2,NULL),(3001,6,NULL,2.67),(3001,9,40,NULL),(3001,30,7,NULL),(3001,47,1,NULL),(3001,50,8,NULL),(3001,51,2700,NULL),(3001,54,5400,NULL),(3001,61,0,NULL),(3001,64,NULL,2.4),(3001,128,1,NULL),(3001,158,1500,NULL),(3001,160,NULL,0.27375),(3001,182,3303,NULL),(3001,183,3300,NULL),(3001,184,12213,NULL),(3001,277,5,NULL),(3001,278,1,NULL),(3001,279,1,NULL),(3001,422,2,NULL),(3001,604,86,NULL),(3001,605,375,NULL),(3001,620,40,NULL),(3001,633,5,NULL),(3001,1180,NULL,0.02),(3001,1210,15,NULL),(3001,1211,NULL,0.6),(3001,1212,1,NULL),(3002,422,2,NULL),(3009,6,NULL,11.67),(3009,9,40,NULL),(3009,30,165,NULL),(3009,47,1,NULL),(3009,50,32,NULL),(3009,51,4800,NULL),(3009,54,21000,NULL),(3009,61,0,NULL),(3009,64,NULL,2.4),(3009,128,2,NULL),(3009,158,6000,NULL),(3009,160,NULL,0.042),(3009,182,3306,NULL),(3009,183,3300,NULL),(3009,184,12204,NULL),(3009,277,5,NULL),(3009,278,3,NULL),(3009,279,1,NULL),(3009,422,2,NULL),(3009,604,86,NULL),(3009,605,374,NULL),(3009,620,125,NULL),(3009,633,5,NULL),(3009,1180,NULL,0.02),(3009,1205,-15,NULL),(3009,1211,NULL,0.7),(3009,1212,1,NULL),(3010,422,2,NULL),(3017,6,NULL,1.82),(3017,9,40,NULL),(3017,30,6,NULL),(3017,47,1,NULL),(3017,50,4,NULL),(3017,51,2100,NULL),(3017,54,4800,NULL),(3017,61,0,NULL),(3017,64,NULL,1.8),(3017,128,1,NULL),(3017,158,500,NULL),(3017,160,NULL,0.308125),(3017,182,3303,NULL),(3017,183,3300,NULL),(3017,184,12213,NULL),(3017,277,5,NULL),(3017,278,1,NULL),(3017,279,1,NULL),(3017,422,2,NULL),(3017,604,86,NULL),(3017,605,375,NULL),(3017,620,40,NULL),(3017,633,5,NULL),(3017,1180,NULL,0.02),(3017,1210,15,NULL),(3017,1211,NULL,0.6),(3017,1212,1,NULL),(3018,422,2,NULL),(3025,6,NULL,21.67),(3025,9,40,NULL),(3025,30,275,NULL),(3025,47,1,NULL),(3025,50,37,NULL),(3025,51,6000,NULL),(3025,54,24000,NULL),(3025,61,0,NULL),(3025,64,NULL,3.6),(3025,128,2,NULL),(3025,158,8000,NULL),(3025,160,NULL,0.033),(3025,182,3306,NULL),(3025,183,3300,NULL),(3025,184,12204,NULL),(3025,277,5,NULL),(3025,278,3,NULL),(3025,279,1,NULL),(3025,422,2,NULL),(3025,604,86,NULL),(3025,605,374,NULL),(3025,620,125,NULL),(3025,633,5,NULL),(3025,1180,NULL,0.02),(3025,1205,-15,NULL),(3025,1211,NULL,0.9),(3025,1212,1,NULL),(3026,422,2,NULL),(3033,6,NULL,7.22),(3033,9,40,NULL),(3033,30,14,NULL),(3033,47,1,NULL),(3033,50,21,NULL),(3033,51,4000,NULL),(3033,54,12000,NULL),(3033,61,0,NULL),(3033,64,NULL,3.6),(3033,128,1,NULL),(3033,158,4000,NULL),(3033,160,NULL,0.1),(3033,182,3303,NULL),(3033,183,3300,NULL),(3033,184,11083,NULL),(3033,277,5,NULL),(3033,278,1,NULL),(3033,279,1,NULL),(3033,422,2,NULL),(3033,604,86,NULL),(3033,605,374,NULL),(3033,620,40,NULL),(3033,633,5,NULL),(3033,1180,NULL,0.02),(3033,1205,-15,NULL),(3033,1211,1,NULL),(3033,1212,1,NULL),(3034,422,2,NULL),(3041,6,NULL,4.44),(3041,9,40,NULL),(3041,30,12,NULL),(3041,47,1,NULL),(3041,50,17,NULL),(3041,51,3500,NULL),(3041,54,6000,NULL),(3041,61,0,NULL),(3041,64,NULL,3.6),(3041,128,1,NULL),(3041,158,2000,NULL),(3041,160,NULL,0.24625),(3041,182,3303,NULL),(3041,183,3300,NULL),(3041,184,12213,NULL),(3041,277,5,NULL),(3041,278,1,NULL),(3041,279,1,NULL),(3041,422,2,NULL),(3041,604,86,NULL),(3041,605,375,NULL),(3041,620,40,NULL),(3041,633,5,NULL),(3041,1180,NULL,0.02),(3041,1210,15,NULL),(3041,1211,NULL,0.8),(3041,1212,1,NULL),(3042,422,2,NULL),(3049,6,65,NULL),(3049,9,40,NULL),(3049,30,3575,NULL),(3049,47,1,NULL),(3049,50,58,NULL),(3049,51,9000,NULL),(3049,54,48000,NULL),(3049,61,0,NULL),(3049,64,NULL,3.6),(3049,128,3,NULL),(3049,158,16000,NULL),(3049,160,NULL,0.0153125),(3049,182,3309,NULL),(3049,183,3300,NULL),(3049,184,12205,NULL),(3049,277,5,NULL),(3049,278,5,NULL),(3049,279,1,NULL),(3049,422,2,NULL),(3049,604,86,NULL),(3049,605,374,NULL),(3049,620,400,NULL),(3049,633,5,NULL),(3049,1180,NULL,0.02),(3049,1205,-15,NULL),(3049,1211,1,NULL),(3049,1212,1,NULL),(3050,422,2,NULL),(3057,6,40,NULL),(3057,9,40,NULL),(3057,30,2750,NULL),(3057,47,1,NULL),(3057,50,53,NULL),(3057,51,7875,NULL),(3057,54,24000,NULL),(3057,61,0,NULL),(3057,64,NULL,3.6),(3057,128,3,NULL),(3057,158,8000,NULL),(3057,160,NULL,0.03375),(3057,182,3309,NULL),(3057,183,3300,NULL),(3057,184,12215,NULL),(3057,277,5,NULL),(3057,278,5,NULL),(3057,279,1,NULL),(3057,422,2,NULL),(3057,604,86,NULL),(3057,605,375,NULL),(3057,620,400,NULL),(3057,633,5,NULL),(3057,1180,NULL,0.02),(3057,1210,15,NULL),(3057,1211,NULL,0.9),(3057,1212,1,NULL),(3058,422,2,NULL),(3065,6,95,NULL),(3065,9,40,NULL),(3065,30,4125,NULL),(3065,47,1,NULL),(3065,50,63,NULL),(3065,51,12500,NULL),(3065,54,52800,NULL),(3065,61,0,NULL),(3065,64,NULL,5.4),(3065,128,3,NULL),(3065,158,20000,NULL),(3065,160,NULL,0.0139205),(3065,182,3309,NULL),(3065,183,3300,NULL),(3065,184,12205,NULL),(3065,277,5,NULL),(3065,278,5,NULL),(3065,279,1,NULL),(3065,422,2,NULL),(3065,604,86,NULL),(3065,605,374,NULL),(3065,620,400,NULL),(3065,633,5,NULL),(3065,1180,NULL,0.02),(3065,1205,-15,NULL),(3065,1211,NULL,1.4),(3065,1212,1,NULL),(3066,422,2,NULL),(3074,6,NULL,3.34),(3074,9,40,NULL),(3074,30,11,NULL),(3074,47,1,NULL),(3074,50,28,NULL),(3074,51,4250,NULL),(3074,54,14400,NULL),(3074,56,1,NULL),(3074,61,0,NULL),(3074,63,0,NULL),(3074,64,NULL,3.3),(3074,124,8627698,NULL),(3074,128,1,NULL),(3074,158,6000,NULL),(3074,160,NULL,0.07),(3074,182,3301,NULL),(3074,183,3300,NULL),(3074,184,11082,NULL),(3074,277,4,NULL),(3074,278,1,NULL),(3074,279,1,NULL),(3074,422,2,NULL),(3074,604,85,NULL),(3074,605,373,NULL),(3074,620,40,NULL),(3074,633,5,NULL),(3074,1180,NULL,0.02),(3074,1205,-15,NULL),(3074,1211,1,NULL),(3074,1212,1,NULL),(3075,422,2,NULL),(3082,6,10,NULL),(3082,9,40,NULL),(3082,30,236,NULL),(3082,47,1,NULL),(3082,50,44,NULL),(3082,51,6375,NULL),(3082,54,28800,NULL),(3082,56,1,NULL),(3082,61,0,NULL),(3082,63,0,NULL),(3082,64,NULL,3.3),(3082,124,8627698,NULL),(3082,128,2,NULL),(3082,158,12000,NULL),(3082,160,NULL,0.023),(3082,182,3304,NULL),(3082,183,3300,NULL),(3082,184,12206,NULL),(3082,277,4,NULL),(3082,278,3,NULL),(3082,279,1,NULL),(3082,422,2,NULL),(3082,604,85,NULL),(3082,605,373,NULL),(3082,620,125,NULL),(3082,633,5,NULL),(3082,1180,NULL,0.02),(3082,1205,-15,NULL),(3082,1211,1,NULL),(3082,1212,1,NULL),(3083,422,2,NULL),(3090,6,30,NULL),(3090,9,40,NULL),(3090,30,2625,NULL),(3090,47,1,NULL),(3090,50,77,NULL),(3090,51,9563,NULL),(3090,54,57600,NULL),(3090,56,1,NULL),(3090,61,0,NULL),(3090,63,0,NULL),(3090,64,NULL,3.3),(3090,124,8627698,NULL),(3090,128,3,NULL),(3090,158,24000,NULL),(3090,160,NULL,0.009625),(3090,182,3307,NULL),(3090,183,3300,NULL),(3090,184,12207,NULL),(3090,277,4,NULL),(3090,278,5,NULL),(3090,279,1,NULL),(3090,422,2,NULL),(3090,604,85,NULL),(3090,605,373,NULL),(3090,620,400,NULL),(3090,633,5,NULL),(3090,1180,NULL,0.02),(3090,1205,-15,NULL),(3090,1211,1,NULL),(3090,1212,1,NULL),(3091,422,2,NULL),(3098,6,NULL,1.67),(3098,9,40,NULL),(3098,30,2,NULL),(3098,47,1,NULL),(3098,50,6,NULL),(3098,51,2600,NULL),(3098,54,7200,NULL),(3098,56,1,NULL),(3098,61,0,NULL),(3098,63,0,NULL),(3098,64,NULL,1.8),(3098,124,8627698,NULL),(3098,128,1,NULL),(3098,158,3000,NULL),(3098,160,NULL,0.13),(3098,182,3301,NULL),(3098,183,3300,NULL),(3098,184,11082,NULL),(3098,277,4,NULL),(3098,278,1,NULL),(3098,279,1,NULL),(3098,422,2,NULL),(3098,604,85,NULL),(3098,605,373,NULL),(3098,620,40,NULL),(3098,633,5,NULL),(3098,1180,NULL,0.02),(3098,1205,-15,NULL),(3098,1211,NULL,0.6),(3098,1212,1,NULL),(3099,422,2,NULL),(3106,6,5,NULL),(3106,9,40,NULL),(3106,30,84,NULL),(3106,47,1,NULL),(3106,50,35,NULL),(3106,51,3900,NULL),(3106,54,14400,NULL),(3106,56,1,NULL),(3106,61,0,NULL),(3106,63,0,NULL),(3106,64,NULL,1.8),(3106,124,8627698,NULL),(3106,128,2,NULL),(3106,158,6000,NULL),(3106,160,NULL,0.042),(3106,182,3304,NULL),(3106,183,3300,NULL),(3106,184,12206,NULL),(3106,277,4,NULL),(3106,278,3,NULL),(3106,279,1,NULL),(3106,422,2,NULL),(3106,604,85,NULL),(3106,605,373,NULL),(3106,620,125,NULL),(3106,633,5,NULL),(3106,1180,NULL,0.02),(3106,1205,-15,NULL),(3106,1211,NULL,0.6),(3106,1212,1,NULL),(3107,422,2,NULL),(3114,6,15,NULL),(3114,9,40,NULL),(3114,30,1313,NULL),(3114,47,1,NULL),(3114,50,61,NULL),(3114,51,5850,NULL),(3114,54,28800,NULL),(3114,56,1,NULL),(3114,61,0,NULL),(3114,63,0,NULL),(3114,64,NULL,1.8),(3114,124,8627698,NULL),(3114,128,3,NULL),(3114,158,12000,NULL),(3114,160,NULL,0.0175),(3114,182,3307,NULL),(3114,183,3300,NULL),(3114,184,12207,NULL),(3114,277,4,NULL),(3114,278,5,NULL),(3114,279,1,NULL),(3114,422,2,NULL),(3114,604,85,NULL),(3114,605,373,NULL),(3114,620,400,NULL),(3114,633,5,NULL),(3114,1180,NULL,0.02),(3114,1205,-15,NULL),(3114,1211,NULL,0.7),(3114,1212,1,NULL),(3115,422,2,NULL),(3122,6,NULL,8.4),(3122,9,40,NULL),(3122,30,1313,NULL),(3122,47,1,NULL),(3122,50,47,NULL),(3122,51,4500,NULL),(3122,54,4800,NULL),(3122,56,1,NULL),(3122,61,0,NULL),(3122,63,0,NULL),(3122,64,NULL,2.1),(3122,124,8627698,NULL),(3122,128,3,NULL),(3122,158,6000,NULL),(3122,160,NULL,0.05),(3122,182,3307,NULL),(3122,183,3300,NULL),(3122,184,12212,NULL),(3122,277,4,NULL),(3122,278,5,NULL),(3122,279,1,NULL),(3122,422,2,NULL),(3122,604,85,NULL),(3122,605,377,NULL),(3122,620,400,NULL),(3122,633,5,NULL),(3122,1180,NULL,0.02),(3122,1210,15,NULL),(3122,1211,NULL,0.5),(3122,1212,1,NULL),(3123,422,2,NULL),(3130,6,NULL,2.8),(3130,9,40,NULL),(3130,30,105,NULL),(3130,47,1,NULL),(3130,50,28,NULL),(3130,51,3000,NULL),(3130,54,2400,NULL),(3130,56,1,NULL),(3130,61,0,NULL),(3130,63,0,NULL),(3130,64,NULL,2.1),(3130,124,8627698,NULL),(3130,128,2,NULL),(3130,158,3000,NULL),(3130,160,NULL,0.12),(3130,182,3304,NULL),(3130,183,3300,NULL),(3130,184,12211,NULL),(3130,277,4,NULL),(3130,278,3,NULL),(3130,279,1,NULL),(3130,422,2,NULL),(3130,604,85,NULL),(3130,605,377,NULL),(3130,620,125,NULL),(3130,633,5,NULL),(3130,1180,NULL,0.02),(3130,1210,15,NULL),(3130,1211,NULL,0.5),(3130,1212,1,NULL),(3131,422,2,NULL),(3138,6,NULL,4.669),(3138,9,40,NULL),(3138,30,158,NULL),(3138,47,1,NULL),(3138,50,33,NULL),(3138,51,4500,NULL),(3138,54,3000,NULL),(3138,56,1,NULL),(3138,61,0,NULL),(3138,63,0,NULL),(3138,64,NULL,3.375),(3138,124,8627698,NULL),(3138,128,2,NULL),(3138,158,4000,NULL),(3138,160,NULL,0.11),(3138,182,3304,NULL),(3138,183,3300,NULL),(3138,184,12211,NULL),(3138,277,4,NULL),(3138,278,3,NULL),(3138,279,1,NULL),(3138,422,2,NULL),(3138,604,85,NULL),(3138,605,377,NULL),(3138,620,125,NULL),(3138,633,5,NULL),(3138,1180,NULL,0.02),(3138,1210,15,NULL),(3138,1211,NULL,0.7),(3138,1212,1,NULL),(3139,422,2,NULL),(3146,6,NULL,6.069),(3146,9,40,NULL),(3146,30,212,NULL),(3146,47,1,NULL),(3146,50,35,NULL),(3146,51,5250,NULL),(3146,54,3600,NULL),(3146,56,1,NULL),(3146,61,0,NULL),(3146,63,0,NULL),(3146,64,NULL,4.2),(3146,124,8627698,NULL),(3146,128,2,NULL),(3146,158,5000,NULL),(3146,160,NULL,0.1),(3146,182,3304,NULL),(3146,183,3300,NULL),(3146,184,12211,NULL),(3146,277,4,NULL),(3146,278,3,NULL),(3146,279,1,NULL),(3146,422,2,NULL),(3146,604,85,NULL),(3146,605,377,NULL),(3146,620,125,NULL),(3146,633,5,NULL),(3146,1180,NULL,0.02),(3146,1210,15,NULL),(3146,1211,NULL,0.8),(3146,1212,1,NULL),(3147,422,2,NULL),(3154,6,14,NULL),(3154,9,40,NULL),(3154,30,1838,NULL),(3154,47,1,NULL),(3154,50,56,NULL),(3154,51,6750,NULL),(3154,54,6000,NULL),(3154,56,1,NULL),(3154,61,0,NULL),(3154,63,0,NULL),(3154,64,NULL,3.375),(3154,124,8627698,NULL),(3154,128,3,NULL),(3154,158,8000,NULL),(3154,160,NULL,0.046),(3154,182,3307,NULL),(3154,183,3300,NULL),(3154,184,12212,NULL),(3154,277,4,NULL),(3154,278,5,NULL),(3154,279,1,NULL),(3154,422,2,NULL),(3154,604,85,NULL),(3154,605,377,NULL),(3154,620,400,NULL),(3154,633,5,NULL),(3154,1180,NULL,0.02),(3154,1210,15,NULL),(3154,1211,NULL,0.7),(3154,1212,1,NULL),(3155,422,2,NULL),(3162,6,NULL,0.938),(3162,9,40,NULL),(3162,30,4,NULL),(3162,47,1,NULL),(3162,50,9,NULL),(3162,51,2000,NULL),(3162,54,1200,NULL),(3162,56,1,NULL),(3162,61,0,NULL),(3162,63,0,NULL),(3162,64,NULL,2.1),(3162,124,8627698,NULL),(3162,128,1,NULL),(3162,158,1500,NULL),(3162,160,NULL,0.365),(3162,182,3301,NULL),(3162,183,3300,NULL),(3162,184,12210,NULL),(3162,277,4,NULL),(3162,278,1,NULL),(3162,279,1,NULL),(3162,422,2,NULL),(3162,604,85,NULL),(3162,605,377,NULL),(3162,620,40,NULL),(3162,633,5,NULL),(3162,1180,NULL,0.02),(3162,1210,15,NULL),(3162,1211,NULL,0.6),(3162,1212,1,NULL),(3163,422,2,NULL),(3170,6,NULL,1.33),(3170,9,40,NULL),(3170,30,7,NULL),(3170,47,1,NULL),(3170,50,13,NULL),(3170,51,3000,NULL),(3170,54,1500,NULL),(3170,56,1,NULL),(3170,61,0,NULL),(3170,63,0,NULL),(3170,64,NULL,3.375),(3170,124,8627698,NULL),(3170,128,1,NULL),(3170,158,2000,NULL),(3170,160,NULL,0.336),(3170,182,3301,NULL),(3170,183,3300,NULL),(3170,184,12210,NULL),(3170,277,4,NULL),(3170,278,1,NULL),(3170,279,1,NULL),(3170,422,2,NULL),(3170,604,85,NULL),(3170,605,377,NULL),(3170,620,40,NULL),(3170,633,5,NULL),(3170,1180,NULL,0.02),(3170,1210,15,NULL),(3170,1211,NULL,0.8),(3170,1212,1,NULL),(3171,422,2,NULL),(3178,6,NULL,2.023),(3178,9,40,NULL),(3178,30,10,NULL),(3178,47,1,NULL),(3178,50,19,NULL),(3178,51,3500,NULL),(3178,54,1800,NULL),(3178,56,1,NULL),(3178,61,0,NULL),(3178,63,0,NULL),(3178,64,NULL,4.2),(3178,124,8627698,NULL),(3178,128,1,NULL),(3178,158,2500,NULL),(3178,160,NULL,0.3165),(3178,182,3301,NULL),(3178,183,3300,NULL),(3178,184,12210,NULL),(3178,277,4,NULL),(3178,278,1,NULL),(3178,279,1,NULL),(3178,422,2,NULL),(3178,604,85,NULL),(3178,605,377,NULL),(3178,620,40,NULL),(3178,633,5,NULL),(3178,1180,NULL,0.02),(3178,1210,15,NULL),(3178,1211,NULL,0.8),(3178,1212,1,NULL),(3179,422,2,NULL),(3186,6,NULL,18.2),(3186,9,40,NULL),(3186,30,2363,NULL),(3186,47,1,NULL),(3186,50,61,NULL),(3186,51,7875,NULL),(3186,54,7200,NULL),(3186,56,1,NULL),(3186,61,0,NULL),(3186,63,0,NULL),(3186,64,NULL,4.2),(3186,124,8627698,NULL),(3186,128,3,NULL),(3186,158,10000,NULL),(3186,160,NULL,0.0433),(3186,182,3307,NULL),(3186,183,3300,NULL),(3186,184,12212,NULL),(3186,277,4,NULL),(3186,278,5,NULL),(3186,279,1,NULL),(3186,422,2,NULL),(3186,604,85,NULL),(3186,605,377,NULL),(3186,620,400,NULL),(3186,633,5,NULL),(3186,1180,NULL,0.02),(3186,1210,15,NULL),(3186,1211,NULL,0.9),(3186,1212,1,NULL),(3187,422,2,NULL),(3218,9,60,NULL),(3218,37,250,NULL),(3218,54,5000,NULL),(3218,55,2500000,NULL),(3218,64,1,NULL),(3218,73,60000,NULL),(3218,77,30,NULL),(3218,109,1,NULL),(3218,110,1,NULL),(3218,111,1,NULL),(3218,113,1,NULL),(3218,136,NULL,0.75),(3218,154,250,NULL),(3218,156,NULL,0.75),(3218,157,200,NULL),(3218,182,3438,NULL),(3218,183,3386,NULL),(3218,192,8,NULL),(3218,208,1,NULL),(3218,209,1,NULL),(3218,210,1,NULL),(3218,211,1,NULL),(3218,263,60,NULL),(3218,265,40,NULL),(3218,277,1,NULL),(3218,278,2,NULL),(3218,422,1,NULL),(3218,479,250000,NULL),(3218,482,1,NULL),(3218,484,NULL,0.75),(3218,524,NULL,0.75),(3218,525,NULL,0.75),(3218,552,25,NULL),(3218,1272,10,NULL),(3219,422,1,NULL),(3242,6,25,NULL),(3242,9,40,NULL),(3242,30,1,NULL),(3242,50,40,NULL),(3242,54,20000,NULL),(3242,73,5000,NULL),(3242,103,0,NULL),(3242,105,1,NULL),(3242,158,0,NULL),(3242,182,3435,NULL),(3242,277,1,NULL),(3242,422,1,NULL),(3242,633,0,NULL),(3242,815,0,NULL),(3242,816,0,NULL),(3242,817,0,NULL),(3242,818,0,NULL),(3242,1180,NULL,0.01),(3242,1211,5,NULL),(3242,1212,1,NULL),(3242,1222,20,NULL),(3243,422,1,NULL),(3244,6,25,NULL),(3244,9,40,NULL),(3244,30,1,NULL),(3244,50,44,NULL),(3244,54,24000,NULL),(3244,73,5000,NULL),(3244,103,0,NULL),(3244,105,1,NULL),(3244,158,0,NULL),(3244,182,3435,NULL),(3244,277,2,NULL),(3244,422,2,NULL),(3244,633,5,NULL),(3244,815,0,NULL),(3244,816,0,NULL),(3244,817,0,NULL),(3244,818,0,NULL),(3244,1180,NULL,0.02),(3244,1211,5,NULL),(3244,1212,1,NULL),(3244,1222,20,NULL),(3245,422,2,NULL),(3285,6,NULL,5.45),(3285,9,40,NULL),(3285,30,99,NULL),(3285,47,1,NULL),(3285,50,26,NULL),(3285,51,3150,NULL),(3285,54,9600,NULL),(3285,61,0,NULL),(3285,64,NULL,1.8),(3285,128,2,NULL),(3285,158,1000,NULL),(3285,160,NULL,0.081),(3285,182,3306,NULL),(3285,183,3300,NULL),(3285,184,12204,NULL),(3285,277,5,NULL),(3285,278,3,NULL),(3285,279,1,NULL),(3285,422,2,NULL),(3285,604,86,NULL),(3285,605,374,NULL),(3285,620,125,NULL),(3285,633,5,NULL),(3285,1180,NULL,0.02),(3285,1205,-15,NULL),(3285,1211,NULL,0.5),(3285,1212,1,NULL),(3286,422,2,NULL),(3293,9,10,NULL),(3293,525,NULL,0.75),(3294,9,10,NULL),(3294,525,NULL,0.75),(3295,9,10,NULL),(3295,525,NULL,0.75),(3296,9,10,NULL),(3296,525,NULL,0.75),(3297,9,10,NULL),(3297,525,NULL,0.75),(3298,9,10,NULL),(3298,525,NULL,0.75),(3300,180,167,NULL),(3300,181,168,NULL),(3300,275,1,NULL),(3300,441,-2,NULL),(3301,180,167,NULL),(3301,181,168,NULL),(3301,182,3300,NULL),(3301,275,1,NULL),(3301,277,1,NULL),(3301,292,5,NULL),(3302,180,167,NULL),(3302,181,168,NULL),(3302,182,3300,NULL),(3302,275,1,NULL),(3302,277,1,NULL),(3302,292,5,NULL),(3303,180,167,NULL),(3303,181,168,NULL),(3303,182,3300,NULL),(3303,275,1,NULL),(3303,277,1,NULL),(3303,292,5,NULL),(3304,180,167,NULL),(3304,181,168,NULL),(3304,182,3300,NULL),(3304,183,3301,NULL),(3304,275,3,NULL),(3304,277,3,NULL),(3304,278,3,NULL),(3304,292,5,NULL),(3305,180,167,NULL),(3305,181,168,NULL),(3305,182,3300,NULL),(3305,183,3302,NULL),(3305,275,3,NULL),(3305,277,3,NULL),(3305,278,3,NULL),(3305,292,5,NULL),(3306,180,167,NULL),(3306,181,168,NULL),(3306,182,3300,NULL),(3306,183,3303,NULL),(3306,275,3,NULL),(3306,277,3,NULL),(3306,278,3,NULL),(3306,292,5,NULL),(3307,180,167,NULL),(3307,181,168,NULL),(3307,182,3300,NULL),(3307,183,3304,NULL),(3307,275,5,NULL),(3307,277,5,NULL),(3307,278,3,NULL),(3307,292,5,NULL),(3308,180,167,NULL),(3308,181,168,NULL),(3308,182,3300,NULL),(3308,183,3305,NULL),(3308,275,5,NULL),(3308,277,5,NULL),(3308,278,3,NULL),(3308,292,5,NULL),(3309,180,167,NULL),(3309,181,168,NULL),(3309,182,3300,NULL),(3309,183,3306,NULL),(3309,275,5,NULL),(3309,277,5,NULL),(3309,278,3,NULL),(3309,292,5,NULL),(3310,180,167,NULL),(3310,181,168,NULL),(3310,182,3300,NULL),(3310,275,2,NULL),(3310,277,2,NULL),(3310,293,-4,NULL),(3311,180,167,NULL),(3311,181,168,NULL),(3311,182,3300,NULL),(3311,275,2,NULL),(3311,277,2,NULL),(3311,294,5,NULL),(3312,180,167,NULL),(3312,181,168,NULL),(3312,182,3300,NULL),(3312,275,2,NULL),(3312,277,2,NULL),(3312,767,5,NULL),(3313,180,167,NULL),(3313,181,168,NULL),(3313,182,3300,NULL),(3313,275,3,NULL),(3313,277,3,NULL),(3314,180,167,NULL),(3314,181,168,NULL),(3314,182,3300,NULL),(3314,275,3,NULL),(3314,277,3,NULL),(3315,180,167,NULL),(3315,181,168,NULL),(3315,182,3300,NULL),(3315,275,4,NULL),(3315,277,4,NULL),(3315,292,3,NULL),(3316,180,167,NULL),(3316,181,168,NULL),(3316,182,3300,NULL),(3316,275,2,NULL),(3316,277,2,NULL),(3316,317,-5,NULL),(3317,180,167,NULL),(3317,181,168,NULL),(3317,182,3300,NULL),(3317,275,5,NULL),(3317,277,5,NULL),(3317,349,5,NULL),(3318,180,167,NULL),(3318,181,166,NULL),(3318,182,3300,NULL),(3318,275,2,NULL),(3318,277,2,NULL),(3318,310,-5,NULL),(3319,180,167,NULL),(3319,181,168,NULL),(3319,275,1,NULL),(3319,280,0,NULL),(3319,293,-2,NULL),(3320,180,167,NULL),(3320,181,168,NULL),(3320,182,3319,NULL),(3320,275,1,NULL),(3320,277,1,NULL),(3320,280,0,NULL),(3320,292,5,NULL),(3321,180,167,NULL),(3321,181,168,NULL),(3321,182,3319,NULL),(3321,275,2,NULL),(3321,277,2,NULL),(3321,280,0,NULL),(3321,292,5,NULL),(3322,180,167,NULL),(3322,181,168,NULL),(3322,182,3319,NULL),(3322,275,3,NULL),(3322,277,2,NULL),(3322,280,0,NULL),(3322,292,5,NULL),(3323,180,167,NULL),(3323,181,168,NULL),(3323,182,3319,NULL),(3323,275,2,NULL),(3323,277,2,NULL),(3323,280,0,NULL),(3323,547,5,NULL),(3324,180,167,NULL),(3324,181,168,NULL),(3324,182,3319,NULL),(3324,183,3321,NULL),(3324,275,3,NULL),(3324,277,3,NULL),(3324,278,3,NULL),(3324,280,0,NULL),(3324,292,5,NULL),(3325,180,167,NULL),(3325,181,168,NULL),(3325,182,3319,NULL),(3325,183,3324,NULL),(3325,275,4,NULL),(3325,277,4,NULL),(3325,278,3,NULL),(3325,280,0,NULL),(3325,292,5,NULL),(3326,180,167,NULL),(3326,181,168,NULL),(3326,182,3319,NULL),(3326,183,3324,NULL),(3326,275,5,NULL),(3326,277,5,NULL),(3326,278,3,NULL),(3326,280,0,NULL),(3326,292,5,NULL),(3327,151,-2,NULL),(3327,180,167,NULL),(3327,181,168,NULL),(3327,193,1,NULL),(3327,275,1,NULL),(3327,280,0,NULL),(3328,180,167,NULL),(3328,181,168,NULL),(3328,182,3327,NULL),(3328,275,2,NULL),(3328,277,1,NULL),(3328,280,0,NULL),(3329,180,167,NULL),(3329,181,168,NULL),(3329,182,3327,NULL),(3329,275,2,NULL),(3329,277,1,NULL),(3329,280,0,NULL),(3330,180,167,NULL),(3330,181,168,NULL),(3330,182,3327,NULL),(3330,275,2,NULL),(3330,277,1,NULL),(3330,280,0,NULL),(3331,180,167,NULL),(3331,181,168,NULL),(3331,182,3327,NULL),(3331,275,2,NULL),(3331,277,1,NULL),(3331,280,0,NULL),(3332,180,167,NULL),(3332,181,168,NULL),(3332,182,3327,NULL),(3332,183,3328,NULL),(3332,275,5,NULL),(3332,277,3,NULL),(3332,278,4,NULL),(3332,280,0,NULL),(3333,180,167,NULL),(3333,181,168,NULL),(3333,182,3327,NULL),(3333,183,3329,NULL),(3333,275,5,NULL),(3333,277,3,NULL),(3333,278,4,NULL),(3333,280,0,NULL),(3334,180,167,NULL),(3334,181,168,NULL),(3334,182,3327,NULL),(3334,183,3330,NULL),(3334,275,5,NULL),(3334,277,3,NULL),(3334,278,4,NULL),(3334,280,0,NULL),(3335,180,167,NULL),(3335,181,168,NULL),(3335,182,3327,NULL),(3335,183,3331,NULL),(3335,275,5,NULL),(3335,277,3,NULL),(3335,278,4,NULL),(3335,280,0,NULL),(3335,334,2,NULL),(3336,180,167,NULL),(3336,181,168,NULL),(3336,182,3327,NULL),(3336,183,3332,NULL),(3336,275,8,NULL),(3336,277,4,NULL),(3336,278,4,NULL),(3336,280,0,NULL),(3336,1047,1,NULL),(3337,180,167,NULL),(3337,181,168,NULL),(3337,182,3327,NULL),(3337,183,3333,NULL),(3337,275,8,NULL),(3337,277,4,NULL),(3337,278,4,NULL),(3337,280,0,NULL),(3337,1047,1,NULL),(3338,180,167,NULL),(3338,181,168,NULL),(3338,182,3327,NULL),(3338,183,3334,NULL),(3338,275,8,NULL),(3338,277,4,NULL),(3338,278,4,NULL),(3338,280,0,NULL),(3338,1047,1,NULL),(3339,180,167,NULL),(3339,181,168,NULL),(3339,182,3327,NULL),(3339,183,3335,NULL),(3339,275,8,NULL),(3339,277,4,NULL),(3339,278,4,NULL),(3339,280,0,NULL),(3339,1047,1,NULL),(3340,180,167,NULL),(3340,181,168,NULL),(3340,182,3327,NULL),(3340,183,3328,NULL),(3340,275,4,NULL),(3340,277,3,NULL),(3340,278,3,NULL),(3340,280,0,NULL),(3340,1047,1,NULL),(3341,180,167,NULL),(3341,181,168,NULL),(3341,182,3327,NULL),(3341,183,3329,NULL),(3341,275,4,NULL),(3341,277,3,NULL),(3341,278,3,NULL),(3341,280,0,NULL),(3341,1047,1,NULL),(3342,180,167,NULL),(3342,181,168,NULL),(3342,182,3327,NULL),(3342,183,3330,NULL),(3342,275,4,NULL),(3342,277,3,NULL),(3342,278,3,NULL),(3342,280,0,NULL),(3342,421,5,NULL),(3342,1047,1,NULL),(3343,180,167,NULL),(3343,181,168,NULL),(3343,182,3327,NULL),(3343,183,3331,NULL),(3343,275,4,NULL),(3343,277,3,NULL),(3343,278,3,NULL),(3343,280,0,NULL),(3343,1047,1,NULL),(3344,180,167,NULL),(3344,181,168,NULL),(3344,182,20533,NULL),(3344,183,3336,NULL),(3344,184,3348,NULL),(3344,275,16,NULL),(3344,277,5,NULL),(3344,278,5,NULL),(3344,279,5,NULL),(3344,280,0,NULL),(3344,1047,1,NULL),(3345,180,167,NULL),(3345,181,168,NULL),(3345,182,20533,NULL),(3345,183,3337,NULL),(3345,184,3348,NULL),(3345,275,16,NULL),(3345,277,5,NULL),(3345,278,5,NULL),(3345,279,5,NULL),(3345,280,0,NULL),(3345,1047,1,NULL),(3346,180,167,NULL),(3346,181,168,NULL),(3346,182,20533,NULL),(3346,183,3338,NULL),(3346,184,3348,NULL),(3346,275,16,NULL),(3346,277,5,NULL),(3346,278,5,NULL),(3346,279,5,NULL),(3346,280,0,NULL),(3346,1047,1,NULL),(3347,180,167,NULL),(3347,181,168,NULL),(3347,182,20533,NULL),(3347,183,3339,NULL),(3347,184,3348,NULL),(3347,275,16,NULL),(3347,277,5,NULL),(3347,278,5,NULL),(3347,279,5,NULL),(3347,280,0,NULL),(3347,1047,1,NULL),(3348,180,164,NULL),(3348,181,168,NULL),(3348,275,1,NULL),(3348,280,0,NULL),(3348,566,2,NULL),(3349,151,-2,NULL),(3349,180,164,NULL),(3349,181,168,NULL),(3349,182,3348,NULL),(3349,275,2,NULL),(3349,277,1,NULL),(3349,280,0,NULL),(3350,180,164,NULL),(3350,181,168,NULL),(3350,182,3348,NULL),(3350,275,2,NULL),(3350,277,1,NULL),(3350,280,0,NULL),(3350,337,2,NULL),(3351,180,164,NULL),(3351,181,168,NULL),(3351,182,3348,NULL),(3351,183,3350,NULL),(3351,275,5,NULL),(3351,277,1,NULL),(3351,278,5,NULL),(3351,280,0,NULL),(3352,180,164,NULL),(3352,181,168,NULL),(3352,182,3348,NULL),(3352,183,20495,NULL),(3352,275,5,NULL),(3352,277,1,NULL),(3352,278,5,NULL),(3352,280,0,NULL),(3353,180,164,NULL),(3353,181,168,NULL),(3353,182,3348,NULL),(3353,183,3351,NULL),(3353,184,3352,NULL),(3353,275,6,NULL),(3353,277,3,NULL),(3353,278,4,NULL),(3353,279,2,NULL),(3353,280,0,NULL),(3354,180,164,NULL),(3354,181,168,NULL),(3354,182,3348,NULL),(3354,275,6,NULL),(3354,277,5,NULL),(3354,280,0,NULL),(3354,850,10,NULL),(3355,180,164,NULL),(3355,181,165,NULL),(3355,275,1,NULL),(3355,277,0,NULL),(3355,280,0,NULL),(3355,362,10,NULL),(3355,438,5,NULL),(3356,180,164,NULL),(3356,181,165,NULL),(3356,182,3355,NULL),(3356,275,2,NULL),(3356,277,1,NULL),(3356,280,0,NULL),(3356,437,5,NULL),(3357,180,164,NULL),(3357,181,165,NULL),(3357,182,3355,NULL),(3357,275,1,NULL),(3357,277,2,NULL),(3357,280,0,NULL),(3357,414,NULL,0.4),(3358,180,164,NULL),(3358,181,165,NULL),(3358,182,3355,NULL),(3358,275,4,NULL),(3358,277,4,NULL),(3358,280,0,NULL),(3358,415,5,NULL),(3359,180,164,NULL),(3359,181,165,NULL),(3359,182,3355,NULL),(3359,275,3,NULL),(3359,277,3,NULL),(3359,280,0,NULL),(3359,412,NULL,0.4),(3360,180,164,NULL),(3360,181,165,NULL),(3360,182,3355,NULL),(3360,275,2,NULL),(3360,277,2,NULL),(3360,280,0,NULL),(3361,180,164,NULL),(3361,181,165,NULL),(3361,182,3355,NULL),(3361,275,3,NULL),(3361,277,3,NULL),(3361,280,0,NULL),(3361,413,NULL,0.4),(3362,180,164,NULL),(3362,181,165,NULL),(3362,182,3355,NULL),(3362,275,1,NULL),(3362,277,5,NULL),(3362,280,0,NULL),(3362,627,1500,NULL),(3363,180,166,NULL),(3363,181,164,NULL),(3363,191,10,NULL),(3363,275,1,NULL),(3363,280,0,NULL),(3364,180,166,NULL),(3364,181,164,NULL),(3364,182,3363,NULL),(3364,183,3348,NULL),(3364,275,4,NULL),(3364,277,4,NULL),(3364,278,2,NULL),(3364,280,0,NULL),(3365,180,166,NULL),(3365,181,164,NULL),(3365,182,3363,NULL),(3365,183,3392,NULL),(3365,275,4,NULL),(3365,277,4,NULL),(3365,278,3,NULL),(3365,280,0,NULL),(3366,180,166,NULL),(3366,181,164,NULL),(3366,182,3363,NULL),(3366,183,3380,NULL),(3366,275,5,NULL),(3366,277,5,NULL),(3366,278,3,NULL),(3366,280,0,NULL),(3367,180,166,NULL),(3367,181,164,NULL),(3367,182,3363,NULL),(3367,183,3385,NULL),(3367,275,3,NULL),(3367,277,3,NULL),(3367,278,3,NULL),(3367,280,0,NULL),(3368,180,166,NULL),(3368,181,164,NULL),(3368,182,3363,NULL),(3368,183,3355,NULL),(3368,275,2,NULL),(3368,277,2,NULL),(3368,278,3,NULL),(3368,280,0,NULL),(3368,418,20,NULL),(3369,180,166,NULL),(3369,181,164,NULL),(3369,182,3363,NULL),(3369,183,3444,NULL),(3369,275,3,NULL),(3369,277,2,NULL),(3369,278,3,NULL),(3369,280,0,NULL),(3370,180,166,NULL),(3370,181,164,NULL),(3370,182,3363,NULL),(3370,183,3403,NULL),(3370,184,3402,NULL),(3370,193,1,NULL),(3370,275,6,NULL),(3370,277,5,NULL),(3370,278,5,NULL),(3370,280,0,NULL),(3370,312,1,NULL),(3370,407,1,NULL),(3371,180,166,NULL),(3371,181,164,NULL),(3371,182,3363,NULL),(3371,183,3359,NULL),(3371,275,3,NULL),(3371,277,3,NULL),(3371,278,2,NULL),(3371,280,0,NULL),(3372,180,166,NULL),(3372,181,164,NULL),(3372,182,3363,NULL),(3372,183,3412,NULL),(3372,275,4,NULL),(3372,277,3,NULL),(3372,278,4,NULL),(3372,280,0,NULL),(3373,180,166,NULL),(3373,181,164,NULL),(3373,182,11584,NULL),(3373,275,7,NULL),(3373,277,5,NULL),(3373,280,0,NULL),(3373,1047,1,NULL),(3373,1174,0,NULL),(3374,180,166,NULL),(3374,181,165,NULL),(3374,275,1,NULL),(3374,280,0,NULL),(3374,455,2,NULL),(3375,179,1,NULL),(3375,180,166,NULL),(3375,181,165,NULL),(3375,275,1,NULL),(3375,277,0,NULL),(3375,280,0,NULL),(3376,175,1,NULL),(3376,180,166,NULL),(3376,181,165,NULL),(3376,275,1,NULL),(3376,277,0,NULL),(3376,280,0,NULL),(3377,176,1,NULL),(3377,180,166,NULL),(3377,181,165,NULL),(3377,275,1,NULL),(3377,280,0,NULL),(3378,177,1,NULL),(3378,180,166,NULL),(3378,181,165,NULL),(3378,275,1,NULL),(3378,277,0,NULL),(3378,280,0,NULL),(3379,178,1,NULL),(3379,180,166,NULL),(3379,181,165,NULL),(3379,275,1,NULL),(3379,280,0,NULL),(3380,180,166,NULL),(3380,181,165,NULL),(3380,275,1,NULL),(3380,280,0,NULL),(3380,312,1,NULL),(3380,440,-4,NULL),(3381,180,166,NULL),(3381,181,165,NULL),(3381,182,3380,NULL),(3381,275,2,NULL),(3381,277,3,NULL),(3381,280,0,NULL),(3381,370,-5,NULL),(3382,180,166,NULL),(3382,181,165,NULL),(3382,182,3380,NULL),(3382,275,2,NULL),(3382,277,3,NULL),(3382,280,0,NULL),(3382,371,-5,NULL),(3383,180,166,NULL),(3383,181,165,NULL),(3383,182,3380,NULL),(3383,275,2,NULL),(3383,277,3,NULL),(3383,280,0,NULL),(3383,372,-5,NULL),(3384,180,166,NULL),(3384,181,165,NULL),(3384,182,3380,NULL),(3384,275,2,NULL),(3384,277,3,NULL),(3384,280,0,NULL),(3384,374,-5,NULL),(3385,180,166,NULL),(3385,181,165,NULL),(3385,182,3380,NULL),(3385,275,1,NULL),(3385,277,1,NULL),(3385,280,0,NULL),(3385,379,2,NULL),(3386,180,166,NULL),(3386,181,165,NULL),(3386,275,1,NULL),(3386,280,0,NULL),(3386,434,5,NULL),(3387,180,166,NULL),(3387,181,165,NULL),(3387,182,3380,NULL),(3387,275,2,NULL),(3387,277,3,NULL),(3387,280,0,NULL),(3387,450,1,NULL),(3388,180,166,NULL),(3388,181,165,NULL),(3388,182,3380,NULL),(3388,275,3,NULL),(3388,277,3,NULL),(3388,280,0,NULL),(3388,451,-4,NULL),(3389,180,166,NULL),(3389,181,165,NULL),(3389,182,3385,NULL),(3389,275,3,NULL),(3389,277,5,NULL),(3389,280,0,NULL),(3389,379,4,NULL),(3390,180,166,NULL),(3390,181,165,NULL),(3390,182,3380,NULL),(3390,183,3385,NULL),(3390,275,4,NULL),(3390,277,4,NULL),(3390,278,4,NULL),(3390,280,0,NULL),(3391,180,166,NULL),(3391,181,165,NULL),(3391,182,3380,NULL),(3391,275,5,NULL),(3391,277,5,NULL),(3391,280,0,NULL),(3392,180,165,NULL),(3392,181,166,NULL),(3392,275,1,NULL),(3392,280,0,NULL),(3392,327,5,NULL),(3393,180,165,NULL),(3393,181,166,NULL),(3393,182,3392,NULL),(3393,275,1,NULL),(3393,277,1,NULL),(3393,280,0,NULL),(3393,312,-5,NULL),(3394,180,165,NULL),(3394,181,166,NULL),(3394,182,3392,NULL),(3394,275,2,NULL),(3394,277,1,NULL),(3394,280,0,NULL),(3394,335,5,NULL),(3395,180,165,NULL),(3395,181,166,NULL),(3395,182,3392,NULL),(3395,183,3380,NULL),(3395,275,2,NULL),(3395,277,1,NULL),(3395,278,2,NULL),(3395,280,0,NULL),(3396,180,165,NULL),(3396,181,166,NULL),(3396,182,3392,NULL),(3396,183,3380,NULL),(3396,275,3,NULL),(3396,277,2,NULL),(3396,278,3,NULL),(3396,280,0,NULL),(3397,180,165,NULL),(3397,181,166,NULL),(3397,182,3392,NULL),(3397,183,3395,NULL),(3397,275,5,NULL),(3397,277,3,NULL),(3397,278,4,NULL),(3397,280,0,NULL),(3398,180,165,NULL),(3398,181,166,NULL),(3398,182,3397,NULL),(3398,183,3395,NULL),(3398,275,8,NULL),(3398,277,4,NULL),(3398,278,4,NULL),(3398,280,0,NULL),(3399,180,165,NULL),(3399,181,166,NULL),(3399,182,3392,NULL),(3399,183,3400,NULL),(3399,184,3363,NULL),(3399,275,5,NULL),(3399,277,5,NULL),(3399,278,5,NULL),(3399,279,5,NULL),(3399,280,0,NULL),(3400,180,165,NULL),(3400,181,166,NULL),(3400,182,3392,NULL),(3400,183,3380,NULL),(3400,184,11584,NULL),(3400,275,16,NULL),(3400,277,5,NULL),(3400,278,5,NULL),(3400,279,5,NULL),(3400,280,0,NULL),(3401,180,165,NULL),(3401,181,166,NULL),(3401,182,3380,NULL),(3401,183,3392,NULL),(3401,275,4,NULL),(3401,277,4,NULL),(3401,278,5,NULL),(3401,280,0,NULL),(3402,180,165,NULL),(3402,181,166,NULL),(3402,275,1,NULL),(3402,280,0,NULL),(3402,452,-5,NULL),(3403,180,165,NULL),(3403,181,166,NULL),(3403,182,3402,NULL),(3403,275,1,NULL),(3403,277,3,NULL),(3403,280,0,NULL),(3403,453,-5,NUL