/*Table structure for table `dgmAttributeTypes` */

DROP TABLE IF EXISTS `dgmAttributeTypes`;

CREATE TABLE `dgmAttributeTypes` (
  `attributeID` int(10) unsigned NOT NULL default '0',
  `attributeName` varchar(100) default NULL,
  `attributeCategory` int(10) unsigned default NULL,
  `description` varchar(1000) default NULL,
  `maxAttributeID` int(10) unsigned default NULL,
  `attributeIdx` int(10) unsigned default NULL,
  `graphicID` int(10) unsigned default NULL,
  `chargeRechargeTimeID` int(10) unsigned default NULL,
  `defaultValue` double default NULL,
  `published` int(10) unsigned default NULL,
  `displayName` varchar(100) default NULL,
  `unitID` int(10) unsigned default NULL,
  `stackable` int(10) unsigned default NULL,
  `highIsGood` int(10) unsigned default NULL,
  `categoryID` int(10) unsigned default NULL,
  PRIMARY KEY  (`attributeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `dgmAttributeTypes` */

insert  into `dgmAttributeTypes`(`attributeID`,`attributeName`,`attributeCategory`,`description`,`maxAttributeID`,`attributeIdx`,`graphicID`,`chargeRechargeTimeID`,`defaultValue`,`published`,`displayName`,`unitID`,`stackable`,`highIsGood`,`categoryID`) values (2,'isOnline',0,'Boolean to store status of online effect',NULL,1,NULL,NULL,0,0,'isOnline',NULL,1,1,9),(3,'damage',1,'current damage dealt to module',9,2,NULL,NULL,0,1,'Damage',NULL,1,1,7),(4,'mass',9,'Integer that describes the types mass',NULL,NULL,409,NULL,0,1,'Mass',2,0,1,4),(6,'capacitorNeed',5,'The amount of charge used from the capacitor for a module activation.',NULL,NULL,1400,NULL,0,1,'activation cost',114,1,1,5),(8,'minRange',4,'tbd',NULL,NULL,1391,NULL,0,0,'minRange',NULL,1,1,9),(9,'hp',4,'The maximum hitpoints of an object.',NULL,NULL,408,NULL,0,0,'hp',113,1,1,4),(11,'powerOutput',4,'power output of power core',NULL,NULL,1400,NULL,0,1,'powergrid Output',107,1,1,1),(12,'lowSlots',4,'The number of low power slots on the ship.',NULL,NULL,295,NULL,0,1,'Low Slots',122,1,1,1),(13,'medSlots',4,'tbd',NULL,NULL,294,NULL,0,1,'Med Slots',122,1,1,1),(14,'hiSlots',4,'tbd',NULL,NULL,293,NULL,0,1,'High Slots',122,1,1,1),(15,'powerLoad',4,'Current load of power core',NULL,NULL,1400,NULL,0,1,'Powerload',107,1,1,7),(18,'charge',6,'charge of module',482,3,1668,55,0,0,'charge',114,1,1,9),(19,'powerToSpeed',4,'tbd',NULL,NULL,NULL,NULL,0,0,'powerToSpeed',NULL,1,1,9),(20,'speedFactor',5,'Factor by which topspeed increases.',NULL,NULL,1389,NULL,1,1,'Max Velocity Bonus',124,0,1,7),(21,'warpFactor',5,'tbd instance param',NULL,NULL,NULL,NULL,0,0,'warpFactor',NULL,1,1,7),(29,'warpInhibitor',4,'tbd',NULL,NULL,NULL,NULL,0,0,'warpInhibitor',NULL,1,1,9),(30,'power',4,'current power need',NULL,NULL,1400,NULL,0,1,'powergrid usage',107,1,1,1),(31,'maxArmor',4,'The number of hit points this module can take  ',NULL,NULL,1383,NULL,0,0,'maxArmor',NULL,1,1,9),(32,'breakPoint',4,'The number of hit points when this module goes offline  ',NULL,NULL,NULL,NULL,0,0,'breakPoint',NULL,1,1,9),(37,'maxVelocity',4,'Maximum velocity of ship',NULL,NULL,1389,NULL,0,1,'Max Velocity',11,0,1,4),(38,'capacity',9,'The cargo space allowed',NULL,NULL,71,NULL,0,1,'Capacity',9,1,1,4),(39,'damageHP',4,'The damage this weapon deals',NULL,NULL,NULL,NULL,0,1,'Damage Repaired Bonus',105,1,1,7),(47,'slots',4,'The number of slots this module requires.  Only used for launchers, bays and turrets.',NULL,NULL,NULL,NULL,1,0,'slots occupied',NULL,1,1,9),(48,'cpuOutput',4,'CPU output of ship',NULL,NULL,1405,NULL,0,1,'CPU Output',106,1,1,1),(49,'cpuLoad',4,'CPU load of ship',NULL,NULL,1405,NULL,0,1,'CPU Load',106,1,1,9),(50,'cpu',4,'CPU need of module',NULL,NULL,1405,NULL,0,1,'CPU usage',106,1,1,1),(51,'speed',4,'Time in milliseconds between possible activations',NULL,NULL,1397,NULL,0,1,'Rate of fire',101,0,0,7),(52,'damageResistance',5,'Substracted before damage application.',NULL,NULL,NULL,NULL,0,0,'damageResistance',NULL,1,1,9),(54,'maxRange',4,'Distance below which range does not affect the to-hit equation.',NULL,NULL,1391,NULL,0,1,'Optimal Range',1,0,1,6),(55,'rechargeRate',5,'Amount of time taken to fully recharge the capacitor.',NULL,NULL,1392,NULL,0,1,'Recharge time',101,1,1,5),(56,'chargeRate',4,'Number of charges consumed per activation',NULL,NULL,1397,NULL,1,1,'Charge Rate',NULL,1,1,7),(61,'targetModule',4,'GroupID of module targeted by this weapon',NULL,NULL,NULL,NULL,0,0,'targetModule',NULL,1,1,9),(63,'accuracyBonus',5,'Something to do with accuracy.',NULL,NULL,1399,NULL,0,0,'accuracyBonus',NULL,1,1,9),(64,'damageMultiplier',5,'Damage multiplier.',NULL,NULL,1432,NULL,1,1,'Damage Modifier',104,0,1,7),(65,'armorBonus',4,'HP bonus to armor.',NULL,NULL,1383,NULL,0,0,'armorBonus',NULL,1,1,9),(66,'durationBonus',5,'Bonus to duration.',NULL,NULL,1392,NULL,0,1,'Duration Bonus',105,1,1,7),(67,'capacitorBonus',4,'Extra batteries to add capacitor.',NULL,NULL,1400,NULL,0,1,'Capacitor Bonus',114,1,1,5),(68,'shieldBonus',5,'Bonus to shield.',NULL,NULL,1384,NULL,0,1,'shield Bonus',113,0,1,2),(69,'rateBonus',5,'Bonus to rate/conversion ratio.',NULL,NULL,1397,NULL,0,0,'rateBonus',NULL,1,1,9),(70,'agility',5,'The agility of the object.',NULL,NULL,1401,NULL,0,1,'Inertia Modifier',NULL,0,1,4),(72,'capacityBonus',4,'Bonus to capacity (shield at least).',NULL,NULL,69,NULL,0,1,'Shield HP bonus',113,1,1,2),(73,'duration',5,'Length of activation time.',NULL,NULL,1392,NULL,0,1,'Activation time / duration',101,1,1,7),(75,'hpToCapacity',5,'DO NOT MESS WITH. How many hp are in one capacity unit',NULL,NULL,NULL,NULL,1,0,'hpToCapacity',NULL,1,1,9),(76,'maxTargetRange',5,'Maximum range at which the scanner can lock a target.',797,NULL,1391,NULL,0,1,'Maximum Targeting Range',1,0,1,6),(77,'miningAmount',4,'How much ore gets mined',NULL,NULL,NULL,NULL,0,1,'Mining amount',9,1,1,7),(79,'scanSpeed',4,'scanning speed in milliseconds',NULL,NULL,74,NULL,0,0,'Targeting Speed',101,0,0,9),(80,'speedBonus',4,'Amount to increase the maximum speed by.',NULL,NULL,1389,NULL,0,1,'Speed Bonus',11,1,1,7),(81,'hpFactor',5,'Factor to modify the hp by.',NULL,NULL,NULL,NULL,0,0,'hpFactor',NULL,1,1,9),(82,'structureBonus',4,'Modifier for the maximum structural strength.',NULL,NULL,NULL,NULL,0,0,'structureBonus',NULL,1,1,9),(83,'structureDamageAmount',4,'An amount to modify the structural damage by.',NULL,NULL,80,NULL,0,1,'Structure hp Repaired',113,1,1,7),(84,'armorDamageAmount',4,'An amount to modify the armor damage by.',NULL,NULL,80,NULL,0,1,'Armor hp Repaired',113,0,1,7),(87,'shieldTransferRange',4,'Maximum range for use of a shield transfer.',NULL,NULL,1391,NULL,0,1,'shield Transfer Range',1,1,1,2),(88,'shieldDrainAmount',4,'Amount to drain from shield.',NULL,NULL,1384,NULL,0,0,'shieldDrainAmount',NULL,1,1,9),(89,'shieldDrainRange',4,'Maximum range shield can be drained at.',NULL,NULL,NULL,NULL,0,0,'shieldDrainRange',NULL,1,1,9),(90,'powerTransferAmount',5,'Amount of power to transfer.',NULL,NULL,1033,NULL,0,1,'Energy transfer amount',120,1,1,7),(91,'powerTransferRange',5,'Maximum range to transfer power from.',NULL,NULL,1391,NULL,0,1,'Transfer range',1,1,1,7),(92,'kineticDampeningFieldStrength',4,'The strength of the kinetic dampening field.  If high may nullify projectiles.',NULL,NULL,NULL,NULL,0,0,'kineticDampeningFieldStrength',NULL,1,1,9),(93,'kineticDampeningFieldBonus',4,'Amount to adjust a kinetic dampening field by.',NULL,NULL,NULL,NULL,0,0,'kineticDampeningFieldBonus',NULL,1,1,9),(95,'energyReflectionStrength',4,'The strength of the energy reflection field. If high may reflect energy at shooter.',NULL,NULL,NULL,NULL,0,0,'energyReflectionStrength',NULL,1,1,9),(96,'energyReflectionBonus',4,'Amount to adjust a energy reflection strength by.',NULL,NULL,NULL,NULL,0,0,'energyReflectionBonus',NULL,1,1,9),(97,'energyDestabilizationAmount',4,'An amount to modify the power of the target by.',NULL,NULL,1400,NULL,0,1,'Energy neutralized',114,1,1,7),(98,'energyDestabilizationRange',4,'Range of energy destabilizer.',NULL,NULL,1391,NULL,0,1,'Max Neutralization Range',1,1,1,7),(99,'empFieldRange',4,'Range of broadcasted EMP field.',NULL,NULL,1391,NULL,0,1,'Area of effect',1,1,1,7),(101,'launcherSlotsLeft',4,'The number of remaining unused launcher slots.',NULL,NULL,412,NULL,0,1,'Launcher hardpoints',NULL,1,1,1),(102,'turretSlotsLeft',4,'Remaining number of unused turret slots on the ship.',NULL,NULL,414,NULL,0,1,'Turret hardpoints',NULL,1,1,1),(103,'warpScrambleRange',4,'Maximum range objects can be warp scrambled from.',NULL,NULL,1391,NULL,0,1,'Warp Scramble Range',1,1,1,7),(104,'warpScrambleStatus',4,'Warp ability of a ship.  If greater than zero than the ship cannot warp.',NULL,NULL,NULL,NULL,0,1,'Warp Scramble Status',NULL,1,1,7),(105,'warpScrambleStrength',4,'Amount to modify ships warp scramble status by.',NULL,NULL,111,NULL,0,1,'Warp Scramble Strength',NULL,1,1,7),(106,'droneBaySlotsLeft',4,'The remaining amount of unused drone bay slots on the ship.',NULL,NULL,139,NULL,0,1,'Dronebay hardpoints',NULL,1,1,10),(107,'explosionRange',4,'Range in meters of explosion effect area.',NULL,NULL,1390,NULL,0,0,'Explosion radius',1,1,1,9),(108,'detonationRange',4,'the range in meters for an object to trigger detonation of missile. (own ship excluded)',NULL,NULL,NULL,NULL,0,0,'Detonation proximity',1,1,1,9),(109,'kineticDamageResonance',5,'damage multiplier vs. kinetic damagers.',NULL,NULL,1393,NULL,1,1,'Kinetic dmg resistance',108,1,1,7),(110,'thermalDamageResonance',5,'damage multiplier vs. thermal.',NULL,NULL,1394,NULL,1,1,'Thermal dmg resistance',108,1,1,7),(111,'explosiveDamageResonance',5,'damage multiplier vs. explosive damagers.',NULL,NULL,1395,NULL,1,1,'Explosive dmg resistance',108,1,1,7),(112,'energyDamageAbsorptionFactor',5,'Percentage of energy damage that is absorbed as available power.',NULL,NULL,1400,NULL,0,0,'energyDamageAbsorptionFactor',NULL,1,1,9),(113,'emDamageResonance',5,'Electro magnetic damage multiplier for shield and armor. Represented as \"% Resistance\" in the UI.',NULL,NULL,1396,NULL,1,1,'EM dmg resistance',108,1,1,7),(114,'emDamage',8,'EM damage done.',NULL,NULL,1388,113,0,1,'EM damage',113,1,1,7),(116,'explosiveDamage',8,'Explosive damage done.',NULL,NULL,1387,111,0,1,'explosive damage',113,1,1,7),(117,'kineticDamage',8,'Kinetic damage done.',NULL,NULL,1385,109,0,1,'Kinetic damage',113,1,1,7),(118,'thermalDamage',8,'Thermal damage done.',NULL,NULL,1386,110,0,1,'Thermal damage',113,1,1,7),(120,'weaponRangeMultiplier',5,'Multiplier of range the relevant weapon.',NULL,NULL,1391,NULL,1,1,'Range bonus',109,1,1,7),(121,'powerOutputBonus',4,'Bonus to output of power core.',NULL,NULL,1384,NULL,0,1,'Power Output Bonus',107,1,1,7),(122,'armorPiercingChance',5,'Chance of piercing the armor.',NULL,NULL,1383,NULL,0,0,'armorPiercingChance',NULL,1,1,9),(123,'shieldPiercingChance',5,'Chance of piercing the shield.',NULL,NULL,NULL,NULL,0,0,'shieldPiercingChance',NULL,1,1,9),(124,'mainColor',7,'The main color of a ship type.',NULL,NULL,NULL,NULL,0,0,'mainColor',NULL,1,1,9),(125,'shipScanRange',4,'Maximum range that something can be ship scanned from.',NULL,NULL,1391,NULL,0,1,'Ship scanning range',1,1,1,7),(126,'cargoScanRange',4,'Maximum range the cargo of a ship can be scanned from.',NULL,NULL,1391,NULL,0,1,'Cargoscan range',1,1,1,7),(127,'ammoLoaded',11,'A temporary attribute for projectile/hybrid weapons to indicate which charges they have loaded when created in newbie ships ala ammo.',NULL,NULL,NULL,NULL,0,0,'Default ammo loaded',NULL,1,1,7),(128,'chargeSize',4,'The size of the charges that can fit in the turret/whatever.',NULL,NULL,1666,NULL,0,1,'Charge size',117,1,1,7),(129,'maxPassengers',4,'Specifies the maximum numbers of passengers that the ship can have',NULL,NULL,413,NULL,0,0,'maxPassengers',NULL,1,1,9),(130,'thermalDamageResonanceMultiplier',5,'Multipler to adjust the thermal damage resonance of an object.',NULL,NULL,1394,NULL,1,1,'Thermal dmg resistance bonus',111,1,1,7),(131,'kineticDamageResonanceMultiplier',5,'Multiplier to the kinetic damage resonance of something.',NULL,NULL,1393,NULL,1,1,'Kinetic dmg resistance bonus',111,1,1,7),(132,'explosiveDamageResonanceMultiplier',5,'Multiplier to the explosive damage resistance of something.',NULL,NULL,1395,NULL,1,1,'Explosive dmg resistance bonus',111,1,1,7),(133,'emDamageResonanceMultiplier',5,'Multiplier to the EM damage resonance of something.',NULL,NULL,1396,NULL,1,1,'EM dmg resistance bonus',111,0,0,7),(134,'shieldRechargeRateMultiplier',5,'Multiplier to a recharge rate time.',NULL,NULL,1392,NULL,1,1,'Shield recharge rate bonus',111,1,1,2),(135,'moduleSize',4,'The size of the module, 1 = small, 2 = medium, 3 = large.  Used for turrets and projectile weapons but will work for any module that defines it.',NULL,NULL,NULL,NULL,0,0,'moduleSize',NULL,1,1,9),(136,'uniformity',5,'This number is deducted from the %chance of the seeping to armor, to slow seep of damage through shield.',NULL,NULL,NULL,NULL,0,0,'uniformity',NULL,1,1,9),(137,'launcherGroup',12,'One of the groups of launcher this charge can be loaded into.',NULL,NULL,NULL,NULL,0,1,'Used with (launchergroup)',115,1,1,7),(138,'emDamageBonus',4,'+/- amount to the EM damage done.',NULL,NULL,1388,NULL,0,1,'EM dmg bonus',113,1,1,7),(139,'explosiveDamageBonus',4,'+/- amount to the explosive damage done.',NULL,NULL,1387,NULL,0,1,'Explosive dmg bonus',113,1,1,7),(140,'kineticDamageBonus',4,'+/- amount to the kinetic damage done.',NULL,NULL,1385,NULL,0,1,'Kinetic dmg bonus',113,1,1,7),(141,'thermalDamageBonus',4,'+/- bonus to the thermal damage done.',NULL,NULL,1386,NULL,0,1,'Thermal dmg bonus',113,1,1,7),(142,'ecmBurstRange',4,'Range that an ECM burst has an effect within.',NULL,NULL,1390,NULL,0,1,'ECM Burst Radius',1,1,1,7),(143,'targetHostileRange',4,'Range of the automated targeting systems hostile targeting area.',NULL,NULL,NULL,NULL,0,1,'Targeting range',1,1,1,7),(144,'capacitorRechargeRateMultiplier',5,'Multiplier to the capacitors recharge rate.',NULL,NULL,1400,NULL,1,1,'Capacitor recharge rate bonus',111,1,1,5),(145,'powerOutputMultiplier',5,'Multipier to power core output.',NULL,NULL,70,NULL,1,1,'Powergrid bonus',109,1,1,7),(146,'shieldCapacityMultiplier',5,'Multiplier to the capacity of a shield.',NULL,NULL,1384,NULL,1,1,'Shield HP bonus',109,1,1,2),(147,'capacitorCapacityMultiplier',5,'',NULL,NULL,1400,NULL,1,1,'Capacitor bonus',109,1,1,5),(148,'armorHPMultiplier',5,'Multiplier to the HP of a ships armor module.',NULL,NULL,1383,NULL,1,1,'Armor HP bonus',109,1,1,3),(149,'cargoCapacityMultiplier',5,'Multiplier to the amount of cargo capacity for a ship.',NULL,NULL,71,NULL,1,1,'Cargo capacity bonus',109,1,1,4),(150,'structureHPMultiplier',5,'Multiplier to the ships structural HP.',NULL,NULL,67,NULL,1,1,'Structure HP bonus',109,1,1,7),(151,'agilityBonus',5,'Bonus to the agility for a ship.',NULL,NULL,1401,NULL,0,1,'Agility bonus',105,1,1,7),(152,'maxPassengersBonus',4,'+/- a number to the max passengers.',NULL,NULL,NULL,NULL,0,1,'Max Passengers Bonus',NULL,1,1,7),(153,'warpCapacitorNeed',5,'The power cost to warp per one kg per AU (floats do not have the resolution for meters).',NULL,NULL,NULL,NULL,0,0,'warpCapacitorNeed',NULL,1,1,9),(154,'proximityRange',4,'The distance at which to react when relevant objects come within range.',NULL,NULL,1390,NULL,0,1,'Activation proximity',1,1,1,7),(156,'incapacitationRatio',5,'The hull damage proportion at which an entity becomes incapacitated.',NULL,NULL,NULL,NULL,0,0,'incapacitationRatio',NULL,1,1,9),(157,'orbitRange',4,'The range at which this thing does it thing.',NULL,NULL,NULL,NULL,0,0,'orbitRange',NULL,1,1,9),(158,'falloff',5,'distance from maximum range at which accuracy has fallen by half',NULL,NULL,1399,NULL,1,1,'Accuracy falloff ',1,1,1,7),(160,'trackingSpeed',5,'Angular speed of turret rotation in radians/seconds',NULL,NULL,1398,NULL,0,1,'Trackingspeed / Accuracy',112,0,1,6),(161,'volume',9,'Volume of things in cubic meters',NULL,NULL,67,NULL,0,1,'Volume',9,1,1,4),(162,'radius',9,'Radius of an object in meters',NULL,NULL,1390,NULL,0,0,'radius',NULL,1,1,9),(163,'dummyDuration',4,'Where you want an effect to finish instantly.',NULL,NULL,NULL,NULL,0,0,'dummyDuration',NULL,1,1,9),(164,'charisma',4,'The charisma of a character.',NULL,4,1378,NULL,0,1,'Charisma',120,1,1,7),(165,'intelligence',4,'The intelligence of a character.',NULL,8,1380,NULL,0,1,'Intelligence',120,1,1,7),(166,'memory',4,'The memory of a character.',NULL,7,1381,NULL,0,1,'Memory',120,1,1,7),(167,'perception',4,'The perception of a character.',NULL,6,1382,NULL,0,1,'Perception',120,1,1,9),(168,'willpower',4,'The willpower of a character.',NULL,5,1379,NULL,0,1,'Willpower',120,1,1,7),(169,'agilityMultiplier',5,'Multiplier to the agility of an object.',NULL,NULL,1401,NULL,0,1,'Inertia Modifier',121,1,1,7),(170,'customCharismaBonus',4,'Bonus to the charisma of a character specified by the player in character creation.',NULL,NULL,1378,NULL,0,0,'customCharismaBonus',NULL,1,1,9),(171,'customWillpowerBonus',4,'Bonus to the willpower of a character specified by the player in character creation.',NULL,NULL,1379,NULL,0,0,'customWillpowerBonus',NULL,1,1,9),(172,'customPerceptionBonus',4,'Bonus to the perception of a character specified by the player in character creation.',NULL,NULL,1382,NULL,0,0,'customPerceptionBonus',NULL,1,1,9),(173,'customMemoryBonus',4,'Bonus to the memory of a character specified by the player in character creation.',NULL,NULL,1381,NULL,0,0,'customMemoryBonus',NULL,1,1,9),(174,'customIntelligenceBonus',4,'Bonus to the intelligence of a character specified by the player in character creation.',NULL,NULL,1380,NULL,0,0,'customIntelligenceBonus',NULL,1,1,9),(175,'charismaBonus',4,'+/- bonus to the charisma of a character.',NULL,NULL,1378,NULL,0,1,'Charisma Modifier',120,1,1,7),(176,'intelligenceBonus',4,'+/- bonus to the intelligence of a character.',NULL,NULL,1380,NULL,0,1,'Intelligence Modifier',120,1,1,7),(177,'memoryBonus',4,'+/- bonus to the memory of a character.',NULL,NULL,1381,NULL,0,1,'Memory Modifier',120,1,1,7),(178,'perceptionBonus',4,'+/- bonus to the perception of a character.',NULL,NULL,1382,NULL,0,1,'Perception Modifier',120,1,1,7),(179,'willpowerBonus',4,'+/- bonus to the willpower of a character.',NULL,NULL,1379,NULL,0,1,'Willpower Modifier',120,1,1,7),(180,'primaryAttribute',10,'Only refers to another dogma attribute.',NULL,NULL,NULL,NULL,0,1,'Primary attribute',119,1,1,7),(181,'secondaryAttribute',10,'Only refers to another dogma attribute.',NULL,NULL,NULL,NULL,0,1,'Secondary attribute',119,1,1,7),(182,'requiredSkill1',11,'The type ID of the skill that is required.',NULL,NULL,NULL,NULL,0,1,'Primary Skill required',116,1,1,8),(183,'requiredSkill2',11,'The type ID of the skill that is required.',NULL,NULL,NULL,NULL,0,1,'Secondary Skill required',116,1,1,8),(184,'requiredSkill3',11,'The type ID of the skill that is required.',NULL,NULL,NULL,NULL,0,1,'Tertiary Skill required',116,1,1,8),(185,'attributePoints',4,'The number of attribute points needed to be accrued to learn this skill.',NULL,NULL,NULL,NULL,0,0,'attributePoints',NULL,1,1,9),(186,'warpCapacitorNeedMultiplier',5,'Multiplier to the warping power cost.',NULL,NULL,NULL,NULL,0,0,'warpCapacitorNeedMultiplier',NULL,1,1,9),(187,'repairCostMultiplier',5,'Multiplier to adjust the cost of repairs.',NULL,NULL,NULL,NULL,1,0,'repairCostMultiplier',NULL,1,1,9),(188,'cargoScanResistance',5,'Chance of being able to resist a cargo scan.',NULL,NULL,NULL,NULL,0,0,'cargoScanResistance',NULL,1,1,9),(189,'targetGroup',12,'Restrict activation to this one module group.',NULL,NULL,NULL,NULL,0,0,'targetGroup',NULL,1,1,9),(190,'corporationMemberLimit',4,'The maximum number of members that a CEO can manage within their corporation.',NULL,NULL,NULL,NULL,0,0,'corporationMemberLimit',NULL,1,1,9),(191,'corporationMemberBonus',4,'+/- modifier to the number of members that a CEO can manage within their corporation.',NULL,NULL,NULL,NULL,0,1,'corporation Member Bonus',NULL,1,1,7),(192,'maxLockedTargets',4,'Maximum number of locked targets that the character or their ships electronics can handle at any given time.  Both have individual limits which apply separately.',NULL,NULL,109,NULL,0,1,'Max  Locked Targets',NULL,1,1,6),(193,'maxAttackTargets',4,'The maximum number of their targets that the character can attack at a given time.',NULL,NULL,NULL,NULL,0,0,'maxAttackTargets',NULL,1,1,9),(194,'jammingResistance',5,'The resistance to target jamming.',NULL,NULL,NULL,NULL,0,0,'jammingResistance',NULL,1,1,7),(195,'raceID',9,'The race ID of the type.',NULL,NULL,NULL,NULL,0,0,'raceID',NULL,1,1,9),(196,'manufactureSlotLimit',4,'The maximum amount of manufacture slots that can be used at a time.',NULL,NULL,NULL,NULL,0,0,'manufactureSlotLimit',NULL,1,1,9),(197,'surveyScanRange',4,'Distance from thing to survey.',NULL,NULL,NULL,NULL,0,1,'Surveyscan range',1,1,1,7),(202,'cpuMultiplier',5,'Factor to adjust module cpu need by.',NULL,NULL,1405,NULL,1,1,'CPU Output bonus',109,1,1,1),(203,'miningDurationMultiplier',5,'Factor to scale mining laser durations by.',NULL,NULL,NULL,NULL,0,0,'miningDurationMultiplier',NULL,1,1,9),(204,'speedMultiplier',5,'Typically scales the firing speed of a weapon.  Reducing speed means faster, strangely..',NULL,NULL,1389,NULL,1,1,'rate of fire bonus',111,1,1,7),(205,'accuracyMultiplier',5,'Scales the accuracy of some targeted weapon.',NULL,NULL,1399,NULL,1,0,'accuracyMultiplier',NULL,1,1,9),(207,'miningAmountMultiplier',5,'The factor by which the amount mined by a mining laser is scaled.',NULL,NULL,NULL,NULL,1,1,'Mining Amount Multiplier',NULL,0,1,7),(208,'scanRadarStrength',5,'Radar strength.',NULL,NULL,2031,NULL,0,1,'RADAR Sensor Strength',120,0,1,6),(209,'scanLadarStrength',5,'Ladar strength.',NULL,NULL,2030,NULL,0,1,'LADAR Sensor Strength',120,0,1,6),(210,'scanMagnetometricStrength',5,'Magnetometric strength.',NULL,NULL,2029,NULL,0,1,'Magnetometric Sensor Strength',120,0,1,6),(211,'scanGravimetricStrength',5,'Gravimetric strength.',NULL,NULL,2028,NULL,0,1,'Gravimetric Sensor Strength',120,0,1,6),(212,'missileDamageMultiplier',5,'The characters missile use efficiency, scales the damage missiles do.',NULL,NULL,NULL,NULL,1,1,'Missile Damage Bonus',104,0,1,7),(213,'missileDamageMultiplierBonus',5,'Additional percentage to the characters missile damage multiplier.',NULL,NULL,NULL,NULL,0,1,'Missile Damage Bonus',109,1,1,7),(216,'capacitorNeedMultiplier',5,'Scales the capacitor need for fitted modules.',NULL,NULL,1400,NULL,0,1,'Capacitor Need Multiplier',105,1,1,5),(217,'propulsionGraphicID',4,'The graphicID of the propulsion system.',NULL,NULL,NULL,NULL,0,0,'propulsionGraphicID',NULL,1,1,9),(218,'blueprintResearchTimeMultiplier',5,'Scales the time it takes a character to research a blueprint.',NULL,NULL,1392,NULL,1,0,'blueprintResearchTimeMultiplier',NULL,1,1,9),(219,'manufactureTimeMultiplier',5,'Scales the time it takes to manufacture something.',NULL,NULL,NULL,NULL,1,0,'manufactureTimeMultiplier',NULL,1,1,9),(220,'blueprintResearchTimeMultiplierBonus',5,'Bonus or penalty to the percentage time it takes to research a blueprint.',NULL,NULL,1392,NULL,0,0,'blueprintResearchTimeMultiplierBonus',NULL,1,1,9),(221,'blueprintManufactureTimeMultiplier',5,'Scales the time it takes a character to manufacture a blueprint.',NULL,NULL,1392,NULL,1,0,'blueprintManufactureTimeMultiplier',NULL,1,1,9),(222,'blueprintManufactureTimeMultiplierBonus',5,'Bonus or penalty to the percentage time it takes to manufacture from a blueprint.',NULL,NULL,1392,NULL,0,0,'blueprintManufactureTimeMultiplierBonus',NULL,1,1,9),(223,'charismaSkillTrainingTimeMultiplier',5,'Scales the time it takes to train skills with Charisma as the primary attribute.',NULL,NULL,NULL,NULL,1,0,'charismaSkillTrainingTimeMultiplier',NULL,1,1,9),(224,'intelligenceSkillTrainingTimeMultiplier',5,'Scales the time it takes to train skills with Intelligence as the primary attribute. ',NULL,NULL,NULL,NULL,1,0,'intelligenceSkillTrainingTimeMultiplier',NULL,1,1,9),(225,'memorySkillTrainingTimeMultiplier',5,'Scales the time it takes to train skills with Memory as the primary attribute.',NULL,NULL,NULL,NULL,1,0,'memorySkillTrainingTimeMultiplier',NULL,1,1,9),(226,'perceptionSkillTrainingTimeMultiplier',5,'Scales the time it takes to train skills with Perception as the primary attribute.',NULL,NULL,NULL,NULL,1,0,'perceptionSkillTrainingTimeMultiplier',NULL,1,1,9),(227,'willpowerSkillTrainingTimeMultiplier',5,'Scales the time it takes to train skills with Willpower as the primary attribute.',NULL,NULL,NULL,NULL,1,0,'willpowerSkillTrainingTimeMultiplier',NULL,1,1,9),(228,'charismaSkillTrainingTimeMultiplierBonus',5,'Bonus or penalty to the percentage time it takes to train skills with Charisma as the primary attribute.',NULL,NULL,NULL,NULL,0,0,'charismaSkillTrainingTimeMultiplierBonus',NULL,1,1,9),(229,'intelligenceSkillTrainingTimeMultiplierBonus',5,'Bonus or penalty to the percentage time it takes to train skills with Intelligence as the primary attribute.',NULL,NULL,NULL,NULL,0,0,'intelligenceSkillTrainingTimeMultiplierBonus',NULL,1,1,9),(230,'memorySkillTrainingTimeMultiplierBonus',5,'Bonus or penalty to the percentage time it takes to train skills with Memory as the primary attribute.',NULL,NULL,NULL,NULL,0,0,'memorySkillTrainingTimeMultiplierBonus',NULL,1,1,9),(231,'perceptionSkillTrainingTimeMultiplierBonus',5,'Bonus or penalty to the percentage time it takes to train skills with Perception as the primary attribute.',NULL,NULL,NULL,NULL,0,0,'perceptionSkillTrainingTimeMultiplierBonus',NULL,1,1,9),(232,'willpowerSkillTrainingTimeMultiplierBonus',5,'Bonus or penalty to the percentage time it takes to train skills with Willpower as the primary attribute.',NULL,NULL,NULL,NULL,0,0,'willpowerSkillTrainingTimeMultiplierBonus',NULL,1,1,9),(235,'maxLockedTargetsBonus',4,'Additional amount of locked targets that can be handled.',NULL,NULL,NULL,NULL,0,1,'Max Locked Targets Bonus',NULL,1,1,6),(236,'maxAttackTargetsBonus',4,'Additional amount of attack targets that can be handled.',NULL,NULL,NULL,NULL,0,0,'maxAttackTargetsBonus',NULL,1,1,9),(237,'maxTargetRangeMultiplier',5,'Scales the max target range of a ships electronics.',NULL,NULL,1391,NULL,1,1,'Targeting Range Bonus',109,1,1,6),(238,'scanGravimetricStrengthBonus',5,'+/- modifier to the gravimetric strength of an electronic system.',NULL,NULL,109,NULL,0,1,'Gravimetric Strength',NULL,0,1,7),(239,'scanLadarStrengthBonus',5,'+/- modifier to the ladar strength of an electronic system.',NULL,NULL,109,NULL,0,1,'LADAR Strength',NULL,0,1,7),(240,'scanMagnetometricStrengthBonus',5,'+/- modifier to the magnetometric strength of an electronic system.',NULL,NULL,109,NULL,0,1,'Magnetometric Strength',NULL,0,1,7),(241,'scanRadarStrengthBonus',5,'+/- modifier to the radar strength of an electronic system.',NULL,NULL,109,NULL,0,1,'RADAR Strength',NULL,0,1,7),(242,'scanSpeedMultiplier',5,'Scales the time it takes to lock a target.',NULL,NULL,104,NULL,1,0,'Targeting speed bonus',111,1,1,7),(243,'maxRangeMultiplier',5,'Scales the range at which something can reach.',NULL,NULL,1391,NULL,1,1,'Max Range Multiplier',104,1,1,6),(244,'trackingSpeedMultiplier',5,'Scale the tracking speed of a weapon.',NULL,NULL,1398,NULL,1,1,'Tracking Speed Multiplier',104,1,1,7),(245,'gfxTurretID',4,'Graphic ID of the turrets for drone type ships.',NULL,NULL,NULL,NULL,0,0,'gfxTurretID',NULL,1,1,9),(246,'gfxBoosterID',4,'Graphic ID of the boosters for drone type ships.',NULL,NULL,NULL,NULL,0,0,'gfxBoosterID',NULL,1,1,9),(247,'entityAttackRange',4,'The distance from a target an entity starts using its weapons.',NULL,NULL,1391,NULL,15000,0,'entityAttackRange',NULL,1,1,9),(248,'entityLootValueMin',4,'The minimum value of any given unit of loot dropped by this entity.  Not the minimum value of all the loot, but of any given item dropped.',NULL,NULL,NULL,NULL,0,0,'entityLootValueMin',NULL,1,1,9),(249,'entityLootValueMax',4,'The maximum value of any loot dropped by this entity.  Thats for each unit of any given item of loot, not for the total value of all items of loot dropped.',NULL,NULL,NULL,NULL,0,0,'entityLootValueMax',NULL,1,1,9),(250,'entityLootCountMin',4,'Deprecated. The minimum number of pieces of loot dropped by this entity.',NULL,NULL,NULL,NULL,0,0,'entityLootCountMin',NULL,1,1,9),(251,'entityLootCountMax',4,'The maximum number of pieces of loot dropped by this entity.',NULL,NULL,NULL,NULL,0,0,'entityLootCountMax',NULL,1,1,9),(252,'entitySecurityStatusKillBonus',5,'How much security status is modified by for killing this entity.  Depending on the entity, this may be a positive or negative amount.',NULL,NULL,NULL,NULL,0,1,'Security Status Kill Amount',NULL,1,1,7),(253,'entitySecurityStatusAggressionBonus',5,'The amount of security status lost of aggressing agaisnt this entity first.',NULL,NULL,NULL,NULL,0,0,'entitySecurityStatusAggressionBonus',NULL,1,1,9),(254,'minLootCount',4,'Minimum loot count that an entity can take from the NPC corp loot resource',NULL,NULL,NULL,NULL,1,0,'minLootCount',NULL,1,1,9),(256,'maxLootCount',4,'Maximum loot count that an entity can take from the NPC corp loot resource',NULL,NULL,NULL,NULL,0,0,'maxLootCount',NULL,1,1,9),(257,'entityFollowRange',4,'The range in m that the entity follows it\'s target.',NULL,NULL,NULL,NULL,0,0,'followRange',NULL,1,1,9),(258,'minLootValue',4,'Minimum value of each resource the entity is able to take as loot.',NULL,NULL,NULL,NULL,0,0,'minLootValue',NULL,1,1,9),(259,'maxLootValue',4,'Maximum value of each resource the entity is able to take as loot.',NULL,NULL,NULL,NULL,0,0,'maxLootValue',NULL,1,1,9),(260,'attackRange',4,'The range in m when the entity starts attacking it\'s target.',NULL,NULL,1391,NULL,0,0,'attackRange',NULL,1,1,9),(261,'killStatusModifier',5,'How much the security status changes when this entity is killed.',NULL,NULL,NULL,NULL,0,0,'killStatusModifier',NULL,1,1,9),(262,'attackStatusModifier',5,'How much the security status changes when this entity is attacked.',NULL,NULL,NULL,NULL,0,0,'attackStatusModifier',NULL,1,1,9),(263,'shieldCapacity',5,'Amount of maximum shield HP on the item.',NULL,NULL,1384,NULL,0,1,'Shield Capacity',113,1,1,2),(264,'shieldCharge',6,'DO NOT MESS WITH. Helper attribute for entities, stands in for the shield charge.',263,11,0,479,0,0,'shieldCharge',NULL,1,1,9),(265,'armorHP',4,'The number of hit points on the entities armor.',NULL,NULL,1383,NULL,0,1,'Armor Hitpoints',113,1,1,3),(266,'armorDamage',1,'DO NOT MESS WITH. The amount of damage done to the entities armor hit points.',265,10,0,NULL,0,1,'Armor Damage',NULL,1,1,9),(267,'armorEmDamageResonance',5,'Multiplies EM damage taken by Armor. ',1527,NULL,1396,NULL,1,1,'Armor Em Damage Resistance',108,0,0,3),(268,'armorExplosiveDamageResonance',5,'Multiplies EXPLOSIVE damage taken by Armor. ',1527,NULL,1395,NULL,1,1,'Armor Explosive Damage Resistance',108,0,0,3),(269,'armorKineticDamageResonance',5,'Multiplies KINETIC damage taken by Armor. ',1527,NULL,1393,NULL,1,1,'Armor Kinetic Damage Resistance',108,0,0,3),(270,'armorThermalDamageResonance',5,'Multiplies THERMAL damage taken by Armor. ',1527,NULL,1394,NULL,1,1,'Armor Thermal Damage Resistance',108,0,0,3),(271,'shieldEmDamageResonance',5,'Multiplies EM damage taken by shield',1528,NULL,1396,NULL,1,1,'Shield Em Damage Resistance',108,0,0,2),(272,'shieldExplosiveDamageResonance',5,'Multiplies EXPLOSIVE damage taken by Armor. ',1528,NULL,1395,NULL,1,1,'Shield Explosive Damage Resistance',108,0,0,2),(273,'shieldKineticDamageResonance',5,'Multiplies KINETIC damage taken by Armor. ',1528,NULL,1393,NULL,1,1,'Shield Kinetic Damage Resistance',108,0,0,2),(274,'shieldThermalDamageResonance',5,'Multiplies THERMAL damage taken by Shield. ',1528,NULL,1394,NULL,1,1,'Shield Thermal Damage Resistance',108,0,0,2),(275,'skillTimeConstant',5,'Time constant for skill training',NULL,NULL,1392,NULL,0,1,'Training time multiplier ',104,1,1,7),(276,'skillPoints',1,'Total accumulated points for skill',NULL,9,33,NULL,0,1,'Skillpoints',NULL,1,1,7),(277,'requiredSkill1Level',4,'Required skill level for skill 1',NULL,NULL,NULL,NULL,0,0,'requiredSkill1Level',NULL,1,1,8),(278,'requiredSkill2Level',4,'Required skill level for skill 2',NULL,NULL,NULL,NULL,0,0,'requiredSkill2Level',NULL,1,1,8),(279,'requiredSkill3Level',4,'Required skill level for skill 3',NULL,NULL,NULL,NULL,0,0,'requiredSkill3Level',NULL,1,1,8),(280,'skillLevel',4,'Level of skill',NULL,NULL,33,NULL,0,1,'level',NULL,1,1,7),(281,'explosionDelay',4,'The amount of milliseconds before the object explodes.',NULL,NULL,1392,NULL,60000,1,'Max Flight Time',101,0,1,7),(282,'launcherCapacityMultiplier',5,'Multiplier to the amount of charge storage space in a launcher.',NULL,NULL,0,NULL,1,0,'launcherCapacityMultiplier',104,1,1,9),(283,'droneCapacity',5,'This defines the total capacity of drones allowed in the drone bay of the ship',NULL,NULL,76,NULL,0,1,'Drone Capacity',9,1,1,10),(284,'excludeGangMembers',3,'Indicates whether the modules ranged effects exlude  members of the users gang.',NULL,NULL,0,NULL,0,0,'excludeGangMembers',NULL,1,1,9),(285,'excludeCorporationMembers',3,'Indicates whether the modules ranged effects exlude  members of the users corporation.',NULL,NULL,0,NULL,0,0,'excludeCorporationMembers',NULL,1,1,9),(286,'excludeHostiles',3,'Indicates whether the modules ranged effects exclude ships hostile to the user.',NULL,NULL,0,NULL,0,0,'excludeHostiles',NULL,1,1,9),(287,'kDmgBonus',4,'Autogenerated skill attribute, kDmgBonus',NULL,NULL,0,NULL,0,0,'kDmgBonus',NULL,1,1,9),(288,'shipCPUBonus',4,'Autogenerated skill attribute, shipCPUBonus',NULL,NULL,0,NULL,0,0,'shipCPUBonus',NULL,1,1,9),(289,'turretDamageBonus',4,'Autogenerated skill attribute, turretDamageBonus',NULL,NULL,0,NULL,0,0,'turretDamageBonus',NULL,1,1,9),(290,'skillTurretDmgBonus',4,'Autogenerated skill attribute, skillTurretDmgBonus',NULL,NULL,0,NULL,0,0,'skillTurretDmgBonus',NULL,1,1,9),(291,'cpuskillBonus',4,'Autogenerated skill attribute, CpuskillBonus',NULL,NULL,0,NULL,0,1,'CpuskillBonus',NULL,1,1,7),(292,'damageMultiplierBonus',4,'Autogenerated skill attribute, damageMultiplierBonus',NULL,NULL,1432,NULL,0,1,'Damage Multiplier Bonus',105,1,1,7),(293,'rofBonus',4,'Autogenerated skill attribute, rofBonus',NULL,NULL,1397,NULL,0,1,'Rate Of Fire Bonus',105,1,1,7),(294,'rangeSkillBonus',4,'Autogenerated skill attribute, rangeSkillBonus',NULL,NULL,0,NULL,0,1,'Optimal Range Modifier',121,1,1,7),(295,'abPowerBonus',4,'Autogenerated skill attribute, abPowerBonus',NULL,NULL,1400,NULL,0,0,'abPowerBonus',NULL,1,1,9),(296,'acPowerBonus',4,'Autogenerated skill attribute, acPowerBonus',NULL,NULL,1400,NULL,0,0,'acPowerBonus',NULL,1,1,9),(297,'afPowerBonus',4,'Autogenerated skill attribute, afPowerBonus',NULL,NULL,1400,NULL,0,0,'afPowerBonus',NULL,1,1,9),(298,'atPowerBonus',4,'Autogenerated skill attribute, atPowerBonus',NULL,NULL,0,NULL,0,0,'atPowerBonus',NULL,1,1,9),(299,'cbTRangeBonus',4,'Autogenerated skill attribute, cbTRangeBonus',NULL,NULL,0,NULL,0,0,'cbTRangeBonus',NULL,1,1,9),(300,'ccTRangeBonus',4,'Autogenerated skill attribute, ccTRangeBonus',NULL,NULL,0,NULL,0,0,'ccTRangeBonus',NULL,1,1,9),(301,'cfTRangeBonus',4,'Autogenerated skill attribute, cfTRangeBonus',NULL,NULL,0,NULL,0,0,'cfTRangeBonus',NULL,1,1,9),(302,'ciTRangeBonus',4,'Autogenerated skill attribute, ciTRangeBonus',NULL,NULL,0,NULL,0,0,'ciTRangeBonus',NULL,1,1,9),(303,'aiPowerBonus',4,'Autogenerated skill attribute, aiPowerBonus',NULL,NULL,0,NULL,0,0,'aiPowerBonus',NULL,1,1,9),(304,'ctTRangeBonus',4,'Autogenerated skill attribute, ctTRangeBonus',NULL,NULL,0,NULL,0,0,'ctTRangeBonus',NULL,1,1,9),(305,'gbCpuBonus',4,'Autogenerated skill attribute, gbCpuBonus',NULL,NULL,0,NULL,0,0,'gbCpuBonus',NULL,1,1,9),(306,'maxVelocityBonus',5,'Autogenerated skill attribute, mMaxVelocityBonus',NULL,NULL,1389,NULL,0,1,'Maximum Velocity Penalty',109,1,1,7),(307,'scannerDurationBonus',4,'Autogenerated skill attribute, scannerDurationBonus',NULL,NULL,1392,NULL,0,0,'scannerDurationBonus',NULL,1,1,9),(308,'scanspeedBonus',4,'Autogenerated skill attribute, scanspeedBonus',NULL,NULL,0,NULL,0,1,'Scan Speed Bonus',105,1,1,7),(309,'maxTargetRangeBonus',5,'Bonus to Max Targeting Range',NULL,NULL,1391,NULL,0,1,'Max Targeting Range Bonus',105,1,1,6),(310,'cpuNeedBonus',4,'Autogenerated skill attribute, cpuNeedBonus',NULL,NULL,0,NULL,0,1,'CPU Need Bonus',105,1,1,1),(311,'maxTargetBonus',4,'Autogenerated skill attribute, maxTarget Bonus',NULL,NULL,0,NULL,0,1,'Max Target Bonus',NULL,1,1,6),(312,'durationSkillBonus',4,'Autogenerated skill attribute, DurationBonus',NULL,NULL,1392,NULL,0,1,'Duration Bonus',121,1,1,7),(313,'powerEngineeringOutputBonus',4,'Autogenerated skill attribute, PowerOutputBonus',NULL,NULL,1400,NULL,0,1,'Power Output Bonus',105,1,1,7),(314,'capRechargeBonus',4,'Autogenerated skill attribute, CapRechargeBonus',NULL,NULL,1400,NULL,0,1,'Cap Recharge Time Reduction',105,1,1,5),(315,'velocityBonus',5,'Autogenerated skill attribute, velocityBonus',NULL,NULL,1389,NULL,0,1,'Velocity Modifier',121,1,1,7),(316,'corpMemberBonus',4,'Autogenerated skill attribute, corpMemberBonus',NULL,NULL,0,NULL,0,0,'corpMemberBonus',NULL,1,1,9),(317,'capNeedBonus',4,'Autogenerated skill attribute, capNeedBonus',NULL,NULL,1400,NULL,0,1,'Capacitor Need Bonus',105,1,1,5),(318,'speedFBonus',4,'Autogenerated skill attribute, speedFBonus',NULL,NULL,1389,NULL,0,1,'speed Bonus',105,1,1,7),(319,'warpCapacitorNeedBonus',4,'Autogenerated skill attribute, warpCapacitorNeedBonus',NULL,NULL,0,NULL,0,1,'Warp Capacitor Need Bonus',124,1,1,7),(320,'powerUseBonus',4,'Autogenerated skill attribute, powerUseBonus',NULL,NULL,0,NULL,0,0,'powerUseBonus',NULL,1,1,9),(321,'burstSpeed',4,'',NULL,NULL,1397,NULL,0,1,'Burst Rate Of Fire',3,1,1,7),(322,'burstSpeedMutator',4,'',NULL,NULL,0,NULL,0,1,'Burst Speed Mutator',NULL,1,1,7),(323,'powerNeedBonus',5,'Autogenerated skill attribute, PowerNeedBonus',NULL,NULL,1400,NULL,0,1,'Power Need Bonus',105,1,1,7),(324,'barrageDmgMutator',4,'',NULL,NULL,0,NULL,0,0,'Barrage Damage Bonus',NULL,1,1,9),(325,'barrageFalloffMutator',4,'',NULL,NULL,0,NULL,0,0,'Barrage falloff Penalty',NULL,1,1,9),(326,'barrageDmgMultiplier',4,'',NULL,NULL,0,NULL,0,0,'Barrage damage multiplier',NULL,1,1,9),(327,'hullHpBonus',4,'Autogenerated skill attribute, hullHpBonus',NULL,NULL,408,NULL,0,1,'Hull Hp Bonus',105,1,1,4),(328,'barrageFalloff',4,'',NULL,NULL,0,NULL,75,0,'Barrage Falloff ',NULL,1,1,9),(329,'gangRofBonus',4,'Autogenerated skill attribute, GangRofBonus',NULL,NULL,0,NULL,0,1,'GangRofBonus',NULL,1,1,7),(330,'boosterDuration',4,'Duration of booster, after this duration the booster is destroyed',NULL,NULL,1392,NULL,0,1,'Booster Duration',3,1,1,7),(331,'implantness',4,'Whether an item is an implant or not',NULL,NULL,2224,NULL,0,1,'Implant Slot',NULL,1,1,7),(332,'burstDmg',4,'',NULL,NULL,0,NULL,0,0,'burstDmg',NULL,1,1,9),(333,'burstDmgMutator',3,'',NULL,NULL,0,NULL,0,0,'burstDmgMutator',NULL,1,1,9),(334,'shipPowerBonus',4,'Autogenerated skill attribute, shipPowerBonus',NULL,NULL,0,NULL,0,0,'shipPowerBonus',NULL,1,1,9),(335,'armorHpBonus',4,'Autogenerated skill attribute, armorHpBonus',NULL,NULL,1383,NULL,0,1,'Armor Hp Bonus',105,1,1,3),(336,'uniformityBonus',5,'Autogenerated skill attribute, uniformityBonus',NULL,NULL,0,NULL,0,1,'Uniformity Bonus',104,1,1,7),(337,'shieldCapacityBonus',4,'Autogenerated skill attribute, shieldCapacityBonus',NULL,NULL,1384,NULL,0,1,'Shield Capacity Bonus',121,1,1,2),(338,'rechargeratebonus',4,'Autogenerated skill attribute, rechargeratebonus',NULL,NULL,1392,NULL,0,1,'Rechargerate Bonus',105,1,1,7),(349,'falloffBonus',5,'Autogenerated skill attribute, falloffBonus',NULL,NULL,1399,NULL,0,1,'Falloff Bonus',105,1,1,7),(350,'skillTrainingTimeBonus',4,'Autogenerated skill attribute, skillTrainingTimeBonus',NULL,NULL,0,NULL,0,0,'skillTrainingTimeBonus',NULL,1,1,9),(351,'maxRangeBonus',5,'Autogenerated skill attribute, maxRangeBonus',NULL,NULL,1391,NULL,0,1,'Optimal Range Bonus',105,1,1,6),(352,'maxActiveDrones',4,'The maximum amount of drones that a character can control at a given time.',NULL,NULL,0,NULL,0,0,'maxActiveDrones',NULL,1,1,9),(353,'maxActiveDroneBonus',4,'Autogenerated skill attribute, maxActiveDroneBonus',NULL,NULL,0,NULL,0,1,'Max Active Drone Bonus',NULL,1,1,10),(354,'maxDroneBonus',4,'Autogenerated skill attribute, maxDroneBonus',NULL,NULL,0,NULL,0,0,'maxDroneBonus',NULL,1,1,9),(355,'negotiationPercentage',5,'Percentage of pay from agent ',NULL,NULL,0,NULL,1,1,'Negotiation Multiplyer',NULL,1,1,7),(356,'diplomacyBonus',5,'Bonus to Effective Standing towards Hostile NPC',NULL,NULL,0,NULL,0,1,'Diplomacy Bonus',NULL,1,1,7),(359,'fastTalkPercentage',5,'a percentage multiplyer to sec status recovery',NULL,NULL,0,NULL,100,1,'Fast Talk Percentage',NULL,1,1,7),(360,'connectionsBonus',5,'Bonus to standing towards Friendly npcs',NULL,NULL,0,NULL,0,1,'Connections Bonus',NULL,1,1,9),(361,'criminalConnectionsBonus',5,'a bonus to standing towards npc with negativa security status',NULL,NULL,0,NULL,0,1,'Criminal Connections Bonus',NULL,1,1,7),(362,'socialBonus',5,'Bonus To standing gain towards non CONCORD npcs  ',NULL,NULL,0,NULL,100,1,'Social Bonus',105,1,1,7),(363,'amarrTechTimePercent',4,'Production time multiplier when manufacturing amarr tech   ',NULL,NULL,0,NULL,100,1,'Amarr Tech ',NULL,1,1,9),(364,'minmatarTechTimePercent',4,'Production time multiplier when manufacturing Minmatar tech   ',NULL,NULL,0,NULL,100,1,'Minmatar Tech ',NULL,1,1,7),(365,'gallenteTechTimePercent',4,'Production time multiplier when manufacturing Gallente tech   ',NULL,NULL,0,NULL,0,1,'GallenteTech ',NULL,1,1,7),(366,'caldariTechTimePercent',4,'Production time multiplier when manufacturing caldari tech   ',NULL,NULL,0,NULL,0,1,'Caldari Tech ',NULL,1,1,7),(367,'productionTimePercent',4,'Production time percentage',NULL,NULL,0,NULL,100,1,'Production time percent',NULL,1,1,7),(368,'refiningTimePercentage',4,'Refining speed percentage',NULL,NULL,0,NULL,100,1,'refining pime percentage',NULL,1,1,7),(369,'manufactureCostMultiplier',5,'Manufacturing cost multiplyer',NULL,NULL,0,NULL,1,1,'manufacture cost Multiplyer',NULL,1,1,7),(370,'amarrTechMutator',4,'Autogenerated skill attribute, amarrTechMutator',NULL,NULL,0,NULL,0,0,'amarrTechMutator',NULL,1,1,9),(371,'caldariTechMutator',4,'Autogenerated skill attribute, caldariTechMutator',NULL,NULL,0,NULL,0,0,'caldariTechMutator',NULL,1,1,9),(372,'gallenteTechMutator',4,'Autogenerated skill attribute, gallenteTechMutator',NULL,NULL,0,NULL,0,0,'gallenteTechMutator',NULL,1,1,9),(373,'productionTimeMutator',4,'Autogenerated skill attribute, productionTimeMutator',NULL,NULL,0,NULL,0,0,'productionTimeMutator',NULL,1,1,9),(374,'minmatarTechMutator',4,'Autogenerated skill attribute, minmatarTechMutator',NULL,NULL,0,NULL,0,0,'minmatarTechMutator',NULL,1,1,9),(375,'productionCostMutator',4,'Autogenerated skill attribute, productionCostMutator',NULL,NULL,0,NULL,0,0,'productionCostMutator',NULL,1,1,9),(376,'refiningTimePercent',4,'Refining time Multiplier',NULL,NULL,0,NULL,100,1,'Refining time Multiplier',NULL,1,1,7),(377,'refiningTimeMutator',4,'Autogenerated skill attribute, refiningTimeMutator',NULL,NULL,0,NULL,0,0,'refiningTimeMutator',NULL,1,1,9),(378,'refiningYieldPercentage',5,'Refining yield percentage',NULL,NULL,0,NULL,0,1,'Refining yield percentage',NULL,1,1,7),(379,'refiningYieldMutator',4,'Autogenerated skill attribute, refiningYieldMutator',NULL,NULL,0,NULL,0,1,'Refining Yield Mutator',105,1,1,7),(380,'maxActiveFactory',4,'Max active factories that a player can operate ',NULL,NULL,0,NULL,0,1,'Max active factory',NULL,1,1,7),(383,'maxActiveFactories',4,'Max active factories',NULL,NULL,0,NULL,0,1,'Max active factories',NULL,1,1,7),(384,'maxResearchGangSize',4,'The max numbers of scientists that can work on CSO´s research project.',NULL,NULL,0,NULL,0,1,'Max research gang size',NULL,1,1,7),(385,'manufacturingTimeResearchSpeed',5,'Research speed ',NULL,NULL,0,NULL,1,1,'Production time research speed',NULL,1,1,7),(386,'researchCostPercent',4,'Research cost percent',NULL,NULL,0,NULL,100,1,'Research cost percent',NULL,1,1,7),(387,'copySpeedPercent',5,'Blueprint copying speed',NULL,NULL,0,NULL,1,1,'Blueprint copying speed',NULL,1,1,7),(388,'frigateConstructionCost',4,'The % of Frigate assembly cost a player has to pay to assemble a frigate',NULL,NULL,0,NULL,100,1,'Frigate construction cost',NULL,1,1,7),(389,'cruiserConstructionCost',4,'The % of cruiser assembly cost a player has to pay to assemble a cruiser',NULL,NULL,0,NULL,0,1,'Cruiser construction cost',NULL,1,1,7),(392,'industrialConstructionCost',4,'The % of industrial assembly cost a player has to pay to assemble a industrial',NULL,NULL,0,NULL,0,1,'Industrial construction cost',NULL,1,1,7),(393,'battleshipConstructionCost',4,'The % of battleship assembly cost a player has to pay to assemble a battleship',NULL,NULL,1392,NULL,0,1,'Battleship construction cost',NULL,1,1,7),(394,'titanConstructionTime',4,'Titan construction time',NULL,NULL,0,NULL,100,1,'Titan construction time',NULL,1,1,7),(395,'stationConstructionTime',4,'Station construction time',NULL,NULL,0,NULL,100,1,'Station construction time',NULL,1,1,7),(396,'repairCostPercent',4,'Repair cost percent',NULL,NULL,0,NULL,100,1,'Repair cost percent',NULL,1,1,7),(397,'reverseEngineeringChance',4,'Chance of making a research breakthrough when researching a higher tech level of a blueprint',NULL,NULL,0,NULL,0,1,'Breakthrough percent',NULL,1,1,7),(398,'mineralNeedResearchSpeed',5,'speed bonus when researching blueprint mineral need',NULL,NULL,0,NULL,1,1,'Mineral need research speed',NULL,1,1,7),(399,'duplicatingChance',4,'Chance of upgrading a module to next tech level ',NULL,NULL,0,NULL,0,1,'prototypingChance',105,1,1,7),(400,'missileStandardVelocityPecent',4,'Missiles velocity multiplier',NULL,NULL,0,NULL,100,0,'missileVelocityPecent',NULL,1,1,9),(401,'cruiseMissileVelocityPercent',5,'Damage Bonus for Cruise Missiles',NULL,NULL,0,NULL,0,0,'Cruise missile Velocity percent',NULL,1,1,9),(402,'heavyMissileSpeedPercent',5,'Heavy missile speed percent',NULL,NULL,0,NULL,0,0,'Heavy missile speed  percent',NULL,1,1,9),(403,'rocketDmgPercent',4,'Rocket Dmg Percent',NULL,NULL,0,NULL,0,1,'Rocket Dmg Percent',105,1,1,7),(404,'torpedoVelocityPercent',5,'Torpedo velocity percent',NULL,NULL,0,NULL,0,0,'Torpedo velocity percent',NULL,1,1,9),(405,'defenderVelocityPercent',4,'Defender velocity percent',NULL,NULL,0,NULL,100,1,'Defender velocity percent',105,1,1,7),(406,'missileFOFVelocityPercent',5,'Missile FOF velocity percent',NULL,NULL,0,NULL,100,0,'Missile FOF velocity percent',NULL,1,1,9),(407,'researchGangSizeBonus',4,'Max research gang size bonus',NULL,NULL,0,NULL,0,0,'Research gang size bonus',NULL,1,1,9),(408,'battleshipConstructionTimeBonus',4,'Autogenerated skill attribute, battleshipConstructionTimeBonus',NULL,NULL,1392,NULL,0,0,'battleshipConstructionTimeBonus',NULL,1,1,9),(409,'cruiserConstructionTimeBonus',4,'Autogenerated skill attribute, cruiserConstructionTimeBonus',NULL,NULL,0,NULL,0,0,'cruiserConstructionTimeBonus',NULL,1,1,9),(410,'frigateConstructionTimeBonus',4,'Autogenerated skill attribute, frigateConstructionTimeBonus',NULL,NULL,0,NULL,0,0,'frigateConstructionTimeBonus',NULL,1,1,9),(411,'industrialConstructionTimeBonus',4,'Autogenerated skill attribute, industrialConstructionTimeBonus',NULL,NULL,0,NULL,0,0,'industrialConstructionTimeBonus',NULL,1,1,9),(412,'connectionBonusMutator',5,'Autogenerated skill attribute, connectionBonusMutator',NULL,NULL,0,NULL,0,0,'connectionBonusMutator',NULL,1,1,9),(413,'criminalConnectionsMutator',5,'Autogenerated skill attribute, criminalConnectionsMutator',NULL,NULL,0,NULL,0,1,'Criminal Connections Mutator',NULL,1,1,7),(414,'diplomacyMutator',5,'Autogenerated skill attribute, diplomacyMutator',NULL,NULL,0,NULL,0,1,'Diplomacy Mutator',NULL,1,1,7),(415,'fastTalkMutator',4,'Autogenerated skill attribute, fastTalkMutator',NULL,NULL,0,NULL,0,0,'fastTalkMutator',NULL,1,1,9),(416,'entityFlyRange',4,'The distance at which the entity orbits, follows.. and more.',NULL,NULL,0,NULL,500,0,'entityFlyRange',NULL,1,1,9),(417,'maxNonRaceCorporationMembers',4,'Max non  race corporationMembers',NULL,NULL,0,NULL,0,1,'Max non  race corporationMembers',NULL,1,1,7),(418,'nonRaceCorporationMembersBonus',4,'Autogenerated skill attribute, nonRaceCorporationMembersBonus',NULL,NULL,0,NULL,0,1,'Non Race Corporation Members Bonus',105,1,1,7),(419,'skillPointsSaved',4,'Amount of skill points saved by clone',NULL,NULL,33,NULL,10000,1,'Skill Points Saved',NULL,1,1,7),(420,'trackingBonus',4,'Autogenerated skill attribute, trackingBonus',NULL,NULL,0,NULL,0,0,'trackingBonus',121,1,1,9),(421,'shieldRechargerateBonus',4,'Autogenerated skill attribute, shieldRechargerateBonus',NULL,NULL,0,NULL,0,0,'shieldRechargerateBonus',NULL,1,1,9),(422,'techLevel',4,'Tech level of an item',NULL,NULL,1446,NULL,1,1,'Tech Level',NULL,1,1,7),(423,'entityDroneCount',4,'',NULL,NULL,0,NULL,0,0,'entityDroneCount',NULL,1,1,9),(424,'cpuOutputBonus2',4,'Autogenerated skill attribute, cpu OutputBonus',NULL,NULL,0,NULL,0,1,'cpu Output Bonus',105,1,1,1),(425,'cpuOutputBonus',4,'Autogenerated skill attribute, cpuOutputBonus',NULL,NULL,0,NULL,0,0,'cpuOutputBonus',NULL,1,1,9),(426,'heavyDroneDamagePercent',5,'',NULL,NULL,0,NULL,1,1,'droneDamagePercent',109,1,1,7),(427,'heavyDroneDamageBonus',4,'Autogenerated skill attribute, heavyDroneDamageBonus',NULL,NULL,0,NULL,0,0,'heavyDroneDamageBonus',NULL,1,1,9),(428,'miningDroneAmountPercent',4,'Mining drone speed percent',NULL,NULL,0,NULL,100,1,'miningDroneSpeedPercent',NULL,1,1,7),(429,'miningDroneSpeedBonus',4,'Autogenerated skill attribute, miningDroneSpeedBonus',NULL,NULL,0,NULL,0,0,'miningDroneSpeedBonus',NULL,1,1,9),(430,'scoutDroneVelocityPercent',4,'',NULL,NULL,0,NULL,100,0,'scoutDroneVelocityPercent',NULL,1,1,9),(431,'scoutDroneVelocityBonus',4,'Autogenerated skill attribute, scoutDroneVelocityBonus',NULL,NULL,0,NULL,0,0,'scoutDroneVelocityBonus',NULL,1,1,9),(432,'defenderVelocityBonus',4,'Autogenerated skill attribute, defenderVelocityBonus',NULL,NULL,0,NULL,0,1,'Drone Velocity Bonus',105,1,1,7),(433,'heavyMissileDamageBonus',4,'Autogenerated skill attribute, heavyMissileDamageBonus',NULL,NULL,0,NULL,0,0,'heavyMissileDamageBonus',NULL,1,1,9),(434,'miningAmountBonus',4,'Autogenerated skill attribute, miningAmountBonus',NULL,NULL,0,NULL,0,1,'Mining Amount Bonus',105,1,1,7),(435,'maxGangModules',4,'',NULL,NULL,0,NULL,3,1,'max Active Command Relays Bonus',NULL,1,1,7),(436,'standingIncreasePercent',4,'',NULL,NULL,0,NULL,100,0,'standingIncreasePercent',105,1,1,9),(437,'negotiationBonus',4,'Autogenerated skill attribute, NegotiationBonus',NULL,NULL,0,NULL,0,1,'NegotiationBonus',105,1,1,7),(438,'socialMutator',4,'Autogenerated skill attribute, socialMutator',NULL,NULL,0,NULL,0,1,'Social Mutator',105,1,1,7),(439,'targetingSpeedBonus',4,'Autogenerated skill attribute, targetingSpeedBonus',NULL,NULL,0,NULL,0,0,'targetingSpeedBonus',NULL,1,1,9),(440,'manufacturingTimeBonus',4,'Autogenerated skill attribute, manufacturingTimeBonus',NULL,NULL,0,NULL,0,1,'Manufacturing Time Bonus',105,1,1,7),(441,'turretSpeeBonus',4,'Autogenerated skill attribute, TurretSpeeBonus',NULL,NULL,0,NULL,0,1,'rate of fire bonus',121,1,1,7),(442,'barterDiscount',5,'skill discount when selling to npc corps',NULL,NULL,0,NULL,0,0,'barterDiscount',NULL,1,1,9),(443,'tradePremium',5,'price bonus when selling to npc corps\n',NULL,NULL,0,NULL,0,1,'Trade premium',NULL,1,1,7),(444,'contrabandFencingChance',5,'Chance of being caught selling contraband on market. ',NULL,NULL,0,NULL,0,1,'Contraband fencing chance',105,1,1,7),(445,'smugglingChance',5,'Chance of being caught Transporting contraband. ',NULL,NULL,0,NULL,0,0,'smugglingChance',NULL,1,1,9),(446,'tradePremiumBonus',4,'Autogenerated skill attribute, tradePremiumBonus',NULL,NULL,0,NULL,0,0,'tradePremiumBonus',NULL,1,1,9),(447,'smugglingChanceBonus',5,'Autogenerated skill attribute, smugglingChanceBonus',NULL,NULL,1196,NULL,0,1,'Smuggling Chance Bonus',105,1,1,7),(448,'fencingChanceBonus',4,'Autogenerated skill attribute, fencingChanceBonus',NULL,NULL,0,NULL,0,0,'fencingChanceBonus',NULL,1,1,9),(449,'barterDiscountBonus',4,'Autogenerated skill attribute, BarterDiscountBonus',NULL,NULL,0,NULL,0,1,'BarterDiscountBonus',NULL,1,1,7),(450,'manufacturingSlotBonus',4,'Autogenerated skill attribute, manufacturingSlotBonus',NULL,NULL,0,NULL,0,1,'Manufacturing Slot Bonus',NULL,1,1,7),(451,'manufactureCostBonus',4,'Autogenerated skill attribute, manufactureCostBonus',NULL,NULL,0,NULL,0,1,'Manufacture Cost Bonus',105,1,1,7),(452,'copySpeedBonus',4,'Autogenerated skill attribute, CopySpeedBonus',NULL,NULL,0,NULL,0,1,'Copy Speed Bonus',105,1,1,7),(453,'blueprintmanufactureTimeBonus',4,'Autogenerated skill attribute, blueprintmanufactureTimeBonus',NULL,NULL,0,NULL,0,1,'Blueprint Manufacture Time Bonus',105,1,1,7),(454,'mutaton',4,'',NULL,NULL,0,NULL,0,0,'Mutaton',NULL,1,1,9),(455,'learningBonus',4,'Autogenerated skill attribute, learningBonus',NULL,NULL,0,NULL,0,1,'Learning Bonus',105,1,1,7),(456,'entityEquipmentMin',4,'',NULL,NULL,0,NULL,0,0,'entityEquipmentMin',NULL,1,1,9),(457,'entityEquipmentMax',4,'',NULL,NULL,0,NULL,0,0,'entityEquipmentMax',NULL,1,1,9),(458,'droneControlDistance',4,'',NULL,NULL,0,NULL,20000,1,'Max drone control distance',1,1,1,10),(459,'droneRangeBonus',4,'Autogenerated skill attribute, droneRangeBonus',NULL,NULL,0,NULL,0,1,'Drone Control Range Bonus',1,1,1,10),(460,'shipBonusMF',5,'',NULL,NULL,0,NULL,0,1,'Special Ability Bonus',105,1,1,7),(461,'specialAbilityBonus',4,'Autogenerated skill attribute, specialAbilityBonus',NULL,NULL,0,NULL,0,0,'specialAbilityBonus',NULL,1,1,9),(462,'shipBonusGF',5,'',NULL,NULL,0,NULL,0,0,'shipBonusGF',NULL,1,1,9),(463,'shipBonusCF',5,'',NULL,NULL,0,NULL,0,0,'shipBonusCF',NULL,1,1,9),(464,'shipBonusAF',5,'',NULL,NULL,0,NULL,0,0,'shipBonusAF',NULL,1,1,9),(465,'entityEquipmentGroupMax',4,'The maximum drops of same group (example: entity can only drop 1 of group: energy laser)',NULL,NULL,0,NULL,1,0,'entityEquipmentGroupMax',NULL,1,1,9),(466,'entityReactionFactor',5,'The chance of an entity attacking the same person as its group members.  Scales delay in joining in on fights too.',NULL,NULL,0,NULL,1,0,'entityReactionFactor',NULL,1,1,9),(467,'maxLaborotorySlots',4,'',NULL,NULL,0,NULL,1,1,'Max Active Laboratories',NULL,1,1,7),(468,'mineralNeedResearchBonus',4,'Autogenerated skill attribute, mineralNeedResearchBonus',NULL,NULL,0,NULL,0,1,'Mineral Need Research Bonus',105,1,1,7),(469,'entityBluePrintDropChance',5,'',NULL,NULL,0,NULL,0,0,'entityBluePrintDropChance',NULL,1,1,9),(470,'lootRespawnTime',4,'The number of milliseconds before the container replenishes the loot inside itself.',NULL,NULL,0,NULL,600000,0,'lootRespawnTime',101,1,1,9),(471,'laboratorySlotsBonus',4,'Autogenerated skill attribute, laboratorySlotsBonus',NULL,NULL,0,NULL,0,0,'laboratorySlotsBonus',NULL,1,1,9),(472,'stationTypeID',11,'The type of station this platform can be used to build.',NULL,NULL,0,NULL,0,1,'Station Type',116,1,1,7),(473,'prototypingBonus',4,'Autogenerated skill attribute, prototypingBonus',NULL,NULL,0,NULL,0,0,'prototypingBonus',NULL,1,1,9),(474,'inventionBonus',4,'Autogenerated skill attribute, inventionBonus',NULL,NULL,0,NULL,0,0,'inventionBonus',NULL,1,1,9),(475,'entityAttackDelayMin',4,'Minimum attack delay time for entity.',NULL,NULL,0,NULL,0,0,'entityAttackDelayMin',NULL,1,1,9),(476,'entityAttackDelayMax',4,'Maximum attack delay time for entity.',NULL,NULL,0,NULL,0,0,'entityAttackDelayMax',NULL,1,1,9),(478,'shipBonusAC',5,'',NULL,NULL,0,NULL,0,0,'shipBonusAC',NULL,1,1,9),(479,'shieldRechargeRate',5,'Amount of time taken to fully recharge the shield.',NULL,NULL,1392,NULL,0,1,'Shield recharge time',101,1,1,2),(480,'maxEffectiveRange',5,'',NULL,NULL,0,NULL,0,0,'maxEffectiveRange',1,1,1,9),(481,'entityKillBounty',4,'Reward for destroying this entity.',NULL,NULL,0,NULL,0,1,'Bounty',NULL,1,1,7),(482,'capacitorCapacity',5,'Capacitor capacity',NULL,NULL,0,NULL,0,1,'Capacitor Capacity',114,1,1,5),(484,'shieldUniformity',5,'DO NOT MESS WITH This number is deducted from the %chance of the seeping to armor, to slow seep of damage through shield.',NULL,NULL,NULL,NULL,0,0,'Shield Uniformity',NULL,1,1,9),(485,'shipBonus2AF',5,'',NULL,NULL,0,NULL,5,0,'shipBonus2AF',NULL,1,1,9),(486,'shipBonusGC',5,'',NULL,NULL,0,NULL,5,0,'shipBonusGC',NULL,1,1,9),(487,'shipBonusCC',5,'',NULL,NULL,0,NULL,5,0,'shipBonusCC',NULL,1,1,9),(488,'shipVelocityBonusMC',4,'',NULL,NULL,0,NULL,5,0,'shipVelocityBonusMC',NULL,1,1,9),(489,'shipBonusMC',5,'',NULL,NULL,0,NULL,0,0,'shipBonusMC',NULL,1,1,9),(490,'shipBonusMB',5,'',NULL,NULL,0,NULL,5,0,'shipBonusMB',NULL,1,1,9),(491,'shipBonusCB',5,'',NULL,NULL,0,NULL,5,0,'shipBonusCB',NULL,1,1,9),(492,'shipBonusAB',5,'',NULL,NULL,0,NULL,5,0,'shipBonusAB',NULL,1,1,9),(493,'shipBonusMI',5,'',NULL,NULL,0,NULL,5,0,'shipBonusMI',NULL,1,1,9),(494,'shipBonusAI',5,'',NULL,NULL,0,NULL,5,0,'shipBonusAI',NULL,1,1,9),(495,'shipBonusCI',5,'',NULL,NULL,0,NULL,5,0,'shipBonusCI',NULL,1,1,9),(496,'shipBonusGI',5,'',NULL,NULL,0,NULL,5,0,'shipBonusGI',NULL,1,1,9),(497,'entityDefenderChance',5,'% chance of entity to shoot defender at incoming missile',NULL,NULL,0,NULL,0,0,'entityDefenderChance',NULL,1,1,9),(499,'droneCapacityBonus',4,'',NULL,NULL,0,NULL,0,0,'droneCapacityBonus',NULL,1,1,9),(500,'shipBonusGB',5,'',NULL,NULL,0,NULL,0,0,'shipBonusGB',NULL,1,1,9),(501,'shipBonus2CB',5,'',NULL,NULL,0,NULL,0,0,'shipBonus2CB',NULL,1,1,9),(502,'entityConvoyDroneMin',4,'Minimum number of drones the convoy can have for protection.',NULL,NULL,0,NULL,1,0,'entityConvoyDroneMin',NULL,1,1,9),(503,'entityConvoyDroneMax',4,'Maximum number of convoy drones a convoy can have for proetcion.',NULL,NULL,0,NULL,1,0,'entityConvoyDroneMax',NULL,1,1,9),(504,'entityWarpScrambleChance',5,'Chance of entity warp scrambling it\'s target.',NULL,NULL,0,NULL,0,0,'entityWarpScrambleChance',NULL,1,1,9),(505,'warpScrambleDuration',5,'',NULL,NULL,1392,NULL,8000,1,'Duration',3,1,1,7),(506,'missileLaunchDuration',5,'Cycle time for a missile launch, in milliseconds.',NULL,NULL,0,NULL,20000,1,'Rate of fire',3,1,1,7),(507,'entityMissileTypeID',11,'The type of missiles the entity launches.',NULL,NULL,0,NULL,0,0,'Missile Type',116,1,1,9),(508,'entityCruiseSpeed',4,'The speed that entities fly at when not chasing a target.',NULL,NULL,0,NULL,0,1,'Orbit Velocity',10,1,1,9),(509,'cargoScanFalloff',5,'Distance from maximum range at which accuracy has fallen by half.',NULL,NULL,0,NULL,0,0,'cargoScanFalloff',1,1,1,9),(510,'shipScanFalloff',5,'Distance from maximum range at which accuracy has fallen by half.',NULL,NULL,0,NULL,0,1,'Ship Scan Falloff',1,1,1,7),(511,'shipScanResistance',5,'Chance of being able to resist a ship scan.',NULL,NULL,0,NULL,0,0,'shipScanResistance',121,1,1,9),(512,'modifyTargetSpeedChance',5,'Chance that  an entity will use a Stasis Web on a target.',NULL,NULL,0,NULL,0,0,'modifyTargetSpeedChance',NULL,1,1,9),(513,'modifyTargetSpeedDuration',5,'Duration of entities Stasis Web ',NULL,NULL,0,NULL,5000,0,'modifyTargetSpeedDuration',3,1,1,9),(514,'modifyTargetSpeedRange',4,'Range of entities Stasis Web',NULL,NULL,0,NULL,20000,0,'modifyTargetSpeedRange',1,1,1,9),(515,'modifyTargetSpeedCapacitorNeed',4,'',NULL,NULL,0,NULL,0,0,'modifyTargetSpeedCapacitorNeed',NULL,1,1,9),(516,'chassisType',11,'',NULL,NULL,0,NULL,0,1,'Required chassis Type',116,1,1,9),(517,'fallofMultiplier',5,'',NULL,NULL,1399,NULL,1,1,'Falloff Modifier',104,1,1,7),(518,'shipBonusMB2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusMB2',NULL,1,1,9),(519,'cloakingCapacitorNeedRatio',5,'The percentage of capacitor capacity required to engage cloaking.',NULL,NULL,0,NULL,1,0,'cloakingCapacitorNeedRatio',NULL,1,1,9),(522,'damageCloudChance',5,'%chance of new asteroid releasing damage cloud each mining turn.',NULL,NULL,0,NULL,0,0,'damageCloudChance',NULL,1,1,9),(524,'armorUniformity',5,'DO NOT MESS WITH',NULL,NULL,0,NULL,0,0,'armorUniformity',NULL,1,1,9),(525,'structureUniformity',5,'DO NOT MESS WITH',NULL,NULL,0,NULL,0,0,'structureUniformity',NULL,1,1,9),(526,'reqResearchSkill',11,'',NULL,NULL,0,NULL,0,1,'Research Skill Required ',NULL,1,1,7),(527,'reqManufacturingSkill',11,'',NULL,NULL,0,NULL,0,1,'Required Manufacturing Skill ',NULL,1,1,7),(528,'reqManufacturingSkillLevel',4,'',NULL,NULL,0,NULL,0,1,'requiredManufacturingSkillLevel',NULL,1,1,7),(529,'reqResearchSkillLevel',4,'',NULL,NULL,0,NULL,0,1,'Required Research Skill Level',NULL,1,1,7),(530,'reqManufacturingTool',11,'',NULL,NULL,0,NULL,0,1,'req Manufacturing Tool',NULL,1,1,7),(531,'reqResearchTool',11,'',NULL,NULL,0,NULL,0,1,'req Research Tool',NULL,1,1,7),(532,'reqResearchComponent',11,'',NULL,NULL,0,NULL,0,0,'reqResearchComponent',NULL,1,1,9),(534,'Manufacturer_ID',11,'',NULL,NULL,0,NULL,0,1,'Manufacturer Bonus',NULL,1,1,7),(535,'installedMod',11,'',NULL,NULL,0,NULL,0,1,'Modification Type',NULL,1,1,7),(536,'reqResearchComponetAmount',4,'',NULL,NULL,0,NULL,0,0,'reqResearchComponetAmount',NULL,1,1,9),(537,'reqManufacturingComponent1Amount',4,'',NULL,NULL,0,NULL,0,1,'Primary Manufacture Componet A',NULL,1,1,7),(538,'reqManufacturingComponent2Amount',4,'',NULL,NULL,0,NULL,0,1,'Secondary Manufacture Componet',NULL,1,1,7),(542,'entityStrength',4,'A relative strength that indicates how powerful this NPC entity is in combat.',NULL,NULL,0,NULL,0,0,'entityStrength',NULL,1,1,9),(543,'damageCloudChanceReduction',4,'Autogenerated skill attribute, damageCloudChanceReduction',NULL,NULL,0,NULL,0,0,'damageCloudChanceReduction',NULL,1,1,9),(544,'cloudEffectDelay',4,'The amount of time before applications of the cloud\'s effect.',NULL,NULL,0,NULL,0,0,'cloudEffectDelay',101,1,1,9),(545,'cloudDuration',4,'Number of milliseconds a temporary cloud hangs around.',NULL,NULL,0,NULL,0,0,'cloudDuration',101,1,1,9),(546,'damageCloudType',11,'The type of damage cloud generated by the asteroid.',NULL,NULL,0,NULL,0,0,'damageCloudType',116,1,1,9),(547,'missileVelocityBonus',4,'Autogenerated skill attribute, missileVelocityBonus ',NULL,NULL,0,NULL,0,1,'Missile Velocity Bonus',105,1,1,7),(548,'shieldBoostMultiplier',5,'',NULL,NULL,2104,NULL,1,1,'Shield Boost Bonus',121,1,1,2),(549,'powerIncrease',4,'',NULL,NULL,0,NULL,0,1,'Power Bonus',107,1,1,7),(550,'resistanceBonus',4,'Autogenerated skill attribute, resistanceBonus',NULL,NULL,0,NULL,0,1,'Resistance Bonus',121,1,1,7),(551,'rocketVelocityPercent',5,'',NULL,NULL,0,NULL,1,0,'rocketVelocityPercent',NULL,1,1,9),(552,'signatureRadius',5,'Signature Radius is used for turret tracking and scanning.',NULL,NULL,1390,NULL,100,1,'Signature Radius',1,0,1,6),(553,'maxGangSizeBonus',4,'Autogenerated skill attribute, maxGangSizeBonus',NULL,NULL,0,NULL,0,0,'maxGangSizeBonus',NULL,1,1,9),(554,'signatureRadiusBonus',5,'Autogenerated skill attribute, signatureRadiusBonus',NULL,NULL,1390,NULL,0,1,'Signature Radius Bonus',124,1,1,7),(555,'cloakVelocityBonus',4,'Autogenerated skill attribute, cloakVelocityBonus',NULL,NULL,0,NULL,0,0,'Cloak Velocity Bonus',105,1,1,9),(556,'anchoringDelay',4,'How long it takes to anchor or unanchor this object.',NULL,NULL,1392,NULL,60000,1,'Anchoring Delay',101,1,1,7),(557,'maxFlightTimeBonus',4,'Autogenerated skill attribute, max flightTimeBonus',NULL,NULL,0,NULL,0,1,'Flight Time Bonus',121,1,1,7),(558,'explosionRangeBonus',4,'Autogenerated skill attribute, explosionRangeBonus',NULL,NULL,0,NULL,0,0,'explosionRangeBonus',NULL,1,1,9),(559,'Inertia',5,'Inertia is a basic multiplier of agility and the mass of the ship, it determines how fast the ship can accelerate and how fast it can fly when orbiting.',NULL,NULL,1401,NULL,0,0,'Inertia',2,1,1,9),(560,'cloakingTargetingDelay',4,'The time targeting systems take to recalibrate after cloaking.',NULL,NULL,0,NULL,0,1,'Sensor Recalibration Time',3,1,1,6),(561,'shipBonusGB2',5,'skill bonus attribute2 for gallente battleship',NULL,NULL,0,NULL,0,0,'shipBonusGB2',NULL,1,1,9),(562,'entityFactionLoss',5,'',NULL,NULL,0,NULL,0,0,'entityFactionLoss',NULL,1,1,9),(563,'entitySecurityMaxGain',5,'',NULL,NULL,0,NULL,0,0,'entitySecurityMaxGain',NULL,1,1,9),(564,'scanResolution',5,'The resolution that the vessel can target other objects at.',NULL,NULL,74,NULL,0,1,'Scan Resolution',102,0,1,6),(565,'scanResolutionMultiplier',5,'Improves the targeting time of ships by boosting the Scan Resolution.',NULL,NULL,74,NULL,0,1,'Scan Resolution Bonus',109,1,1,7),(566,'scanResolutionBonus',5,'Bonus for scan resolution',NULL,NULL,74,NULL,0,1,'Scan Resolution Bonus',105,1,1,7),(567,'speedBoostFactor',4,'Used to divide with mass to give a factor for speed boost modules',NULL,NULL,96,NULL,0,1,'Thrust',125,1,1,7),(568,'eliteBonusInterceptor',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusInterceptor',NULL,1,1,9),(569,'eliteBonusCoverOps1',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusCoverOps1',NULL,1,1,9),(570,'eliteBonusBombers',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusBombers',NULL,1,1,9),(571,'eliteBonusGunships',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusGunships',NULL,1,1,9),(573,'eliteBonusdestroyers',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusdestroyers',NULL,1,1,9),(575,'eliteBonusBattlecruiser',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusBattlecruiser',NULL,1,1,9),(576,'speedBoostFactorCalc',5,'Hidden attribute that is used for speedBoostFactor calculation because Dogma cant handle it.',NULL,NULL,0,NULL,1,0,'speedBoostFactorCalc',NULL,1,1,9),(578,'speedBoostFactorCalc2',5,'Second hidden attribute.',NULL,NULL,0,NULL,1,0,'speedBoostFactorCalc2',NULL,1,1,9),(579,'testForEggert',4,'',NULL,NULL,0,NULL,0,0,'testForEggert',NULL,1,1,9),(580,'entityChaseMaxDelay',4,'The maximum amount of time stalled before entity chase speed kicks in.',NULL,NULL,0,NULL,5000,0,'entityChaseMaxDelay',NULL,1,1,9),(581,'entityChaseMaxDelayChance',5,'Chance that the max delay is waited before chase is engaged.',NULL,NULL,0,NULL,1,0,'entityChaseMaxDelayChance',NULL,1,1,9),(582,'entityChaseMaxDuration',4,'The maximum amount of time chase is ever engaged for.',NULL,NULL,0,NULL,5000,0,'entityChaseMaxDuration',101,1,1,9),(583,'entityChaseMaxDurationChance',5,'The chance of engaging chase for the maximum duration.',NULL,NULL,0,NULL,1,0,'entityChaseMaxDurationChance',NULL,1,1,9),(584,'entityMaxWanderRange',4,'The maximum distance an entity of this type can be led from its point of placement.',NULL,NULL,0,NULL,100000,0,'entityMaxWanderRange',1,1,1,9),(585,'shipBonusAB2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusAB2',NULL,1,1,9),(586,'shipBonusGF2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusGF2',NULL,1,1,9),(587,'shipBonusMF2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusMF2',NULL,1,1,9),(588,'shipBonusCF2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusCF2',NULL,1,1,9),(589,'isPlayerOwnable',3,'Whether a station type is player ownable.',NULL,NULL,0,NULL,0,0,'isPlayerOwnable',NULL,1,1,9),(590,'gestaltBonus1',5,'',NULL,NULL,0,NULL,0,0,'gestaltBonus1',NULL,1,1,9),(591,'droneMaxVelocityBonus',4,'Increases max velocity of all drone types.',NULL,NULL,0,NULL,0,1,'Drone Velocity Bonus',105,1,1,10),(592,'cloakCapacitorBonus',4,'Autogenerated skill attribute, cloakCapacitorBonus',NULL,NULL,0,NULL,0,0,'cloakCapacitorBonus',NULL,1,1,9),(594,'Die',4,'Autogenerated skill attribute, cloakCapacitor Bonus',NULL,NULL,0,NULL,0,0,'Die',NULL,1,1,9),(595,'capBoostMultipler',5,'',NULL,NULL,0,NULL,0,0,'CapBoostMultipler',NULL,1,1,9),(596,'explosionDelayBonus',4,'Autogenerated skill attribute, explosionDelayBonus',NULL,NULL,0,NULL,0,0,'explosionDelayBonus',NULL,1,1,9),(597,'eliteBonusEscorts',4,'bonus for escort class frigates',NULL,NULL,0,NULL,10,0,'eliteBonusEscorts',NULL,1,1,9),(598,'shipBonusCB3',5,'',NULL,NULL,0,NULL,0,0,'shipBonusCB3',NULL,1,1,9),(600,'warpSpeedMultiplier',5,'',NULL,NULL,0,NULL,1,1,'Warp Speed Multiplier',104,1,1,7),(601,'warpSpeedBonus',4,'Autogenerated skill attribute, warpSpeedBonus',NULL,NULL,0,NULL,0,1,'Warp Speed Bonus',105,1,1,7),(602,'launcherGroup2',12,'One of the groups of launcher this charge can be loaded into.',NULL,NULL,0,NULL,0,1,'Used with (launchergroup)',115,1,1,7),(603,'launcherGroup3',12,'One of the groups of launcher this charge can be loaded into.',NULL,NULL,0,NULL,0,1,'Used with (launchergroup)',115,1,1,7),(604,'chargeGroup1',12,'One of the groups of charge this launcher can be loaded with.',NULL,NULL,0,NULL,0,1,'Used with (chargegroup)',115,1,1,7),(605,'chargeGroup2',12,'One of the groups of charge this launcher can be loaded with.',NULL,NULL,0,NULL,0,1,'Used with (chargegroup)',115,1,1,7),(606,'chargeGroup3',12,'One of the groups of charge this launcher can be loaded with.',NULL,NULL,0,NULL,0,1,'Used with (chargegroup)',115,1,1,7),(608,'powerNeedMultiplier',5,'',NULL,NULL,0,NULL,1,1,'Turret Power Need',109,1,1,7),(609,'chargeGroup4',12,'One of the groups of charge this launcher can be loaded with.',NULL,NULL,0,NULL,0,1,'Used with (chargegroup)',115,1,1,7),(610,'chargeGroup5',12,'One of the groups of charge this launcher can be loaded with.',NULL,NULL,0,NULL,0,1,'Used with (chargegroup)',115,1,1,7),(611,'durationMultiplier',5,'',NULL,NULL,0,NULL,0,1,'Duration Bonus',111,1,1,7),(612,'baseShieldDamage',5,'Just for the UI to display base damage on shield.',NULL,NULL,69,NULL,0,1,'Base Shield Damage',NULL,1,1,7),(613,'baseArmorDamage',5,'Just for the UI to display base damage on armor.',NULL,NULL,68,NULL,0,1,'Base Armor Damage',NULL,1,1,7),(614,'cargoCapacityBonus',4,'Autogenerated skill attribute, cargoCapacityBonus',NULL,NULL,0,NULL,0,1,'Cargo Capacity Bonus',121,1,1,4),(616,'boosterShieldBoostAmountPenalty',5,'Multiplier applied to the ship\'s maximum velocity.',NULL,NULL,0,NULL,1,1,'Shield Booster Penalty',105,1,1,7),(619,'cloakingTargetingDelayBonus',4,'Skill bonus for cloaking targeting delay.',NULL,NULL,0,NULL,0,1,'Cloaking Targeting Delay Bonus',105,1,1,6),(620,'optimalSigRadius',5,'Prefered target signature. The base signature radius at which the turret\'s tracking speed is rated. ',NULL,NULL,0,NULL,1000,1,'Signature Resolution',1,1,1,7),(621,'trackingSpeedAtOptimal',4,'Rated target transverse velocity at optimal range.',NULL,NULL,0,NULL,1,1,'Tracking Speed at Optimal Range',10,1,1,7),(622,'massLimit',5,'Determines the maximum weight of a ship that, ships that are to heavy get denied of service by this attribute',NULL,NULL,0,NULL,0,0,'capacityLimit',2,1,1,7),(623,'cloakingSlotsLeftSuper',4,'hot-fix for not allowing warpable cloaking modules on anything but covert-ops frigs',NULL,NULL,0,NULL,0,0,'cloakingSlotsLeftSuper',NULL,1,1,9),(624,'WarpSBonus',4,'Autogenerated skill attribute, WarpSBonus',NULL,NULL,0,NULL,0,1,'Warp Speed Bonus',105,1,1,7),(625,'bountyBonus',5,'Flat Bonus To NPC Bountys',NULL,NULL,0,NULL,0,0,'bountyBonus',NULL,1,1,9),(626,'bountyMultiplier',5,'Npc Bounty Multiplier',NULL,NULL,0,NULL,1,0,'bountyMultiplier',NULL,1,1,9),(627,'bountySkillBonus',4,'Autogenerated skill attribute, bountySkillBonus',NULL,NULL,0,NULL,0,0,'bountySkillBonus',NULL,1,1,9),(628,'bountySkillMultiplyer',4,'Autogenerated skill attribute, bountySkillMultiplyer',NULL,NULL,0,NULL,0,0,'bountySkillMultiplyer',NULL,1,1,9),(629,'cargoGroup',12,'The cargo group that can be loaded into this container',NULL,NULL,0,NULL,0,0,'cargoGroup',NULL,1,1,9),(630,'entityArmorRepairDuration',4,'Duration between armor repair actions for entities.',NULL,NULL,0,NULL,0,0,'entityArmorRepairDuration',NULL,1,1,9),(631,'entityArmorRepairAmount',5,'Amount of armor repaired per cycle for entities.',NULL,NULL,0,NULL,0,0,'entityArmorRepairAmount',NULL,1,1,9),(632,'interceptorGF',4,'',NULL,NULL,0,NULL,0,0,'interceptorGF',NULL,1,1,9),(633,'metaLevel',4,'The ranking of the module within its tech level',NULL,NULL,0,NULL,0,1,'Meta Level',NULL,1,1,7),(634,'newAgility',5,'Maximum \"Thrust angle\" for an object in Radians, 0 to pi (3.14).',NULL,NULL,0,NULL,3,0,'newAgility',NULL,1,1,9),(635,'turnAngle',5,'Maximum turn angle of a ship in Radians, 0 to pi (3.14).',NULL,NULL,0,NULL,3,0,'turnAngle',NULL,1,1,9),(636,'entityShieldBoostDuration',4,'How long between repeats.',NULL,NULL,0,NULL,10000,0,'entityShieldBoostDuration',NULL,1,1,9),(637,'entityShieldBoostAmount',5,'How much the shield is boosted each duration.',NULL,NULL,0,NULL,0,0,'entityShieldBoostAmount',NULL,1,1,9),(638,'entityArmorRepairDelayChance',5,'Chance that an entity will delay employing armor repair.',NULL,NULL,0,NULL,0,0,'entityArmorRepairDelayChance',NULL,1,1,9),(639,'entityShieldBoostDelayChance',5,'The chance an entity will delay repeating use of its shield boosting effect if it has one.',NULL,NULL,0,NULL,1,0,'entityShieldBoostDelayChance',NULL,1,1,9),(640,'entityGroupRespawnChance',5,'The chance an entity will respawn into his group if destroyed.',NULL,NULL,0,NULL,1,0,'entityGroupRespawnChance',NULL,1,1,9),(641,'prereqimplant',4,'typeID of an implant that the character must have to use this implant. ',NULL,NULL,0,NULL,0,0,'Prerequisite Implant Type',NULL,1,1,9),(643,'armingTime',4,'Delay after launch until a missile will do damage on impact.',NULL,NULL,0,NULL,0,1,'Arming Time',3,1,1,7),(644,'aimedLaunch',4,'Determines wether a missile launches aligned with the ship (0) or directly at the target (1).',NULL,NULL,0,NULL,0,0,'aimedLaunch',NULL,1,1,9),(645,'missileEntityVelocityMultiplier',5,'Multiplier for the missile\'s speed.',NULL,NULL,0,NULL,1,1,'Missile Velocity Bonus',104,1,1,7),(646,'missileEntityFlightTimeMultiplier',5,'Multiplier for the missile\'s flight time.',NULL,NULL,0,NULL,1,1,'Missile Flight Time Bonus',104,1,1,7),(647,'missileEntityArmingTimeMultiplier',5,'',NULL,NULL,0,NULL,1,0,'missileEntityArmingTimeMultiplier',NULL,1,1,9),(648,'shieldTUNEBonus',5,'',NULL,NULL,0,NULL,0,1,'Shield tuneup bonus',113,1,1,2),(649,'cloakingCpuNeedBonus',5,'',NULL,NULL,0,NULL,0,0,'cloakingCpuNeedBonus',NULL,1,1,9),(650,'maxStructureDistance',4,'The distance that structures have to be from a control tower in order to work with it.',NULL,NULL,0,NULL,0,1,'Maximum Structure Distance',1,1,1,7),(651,'decloakFieldRange',4,'Range of broadcasted decloaking field.',NULL,NULL,0,NULL,0,1,'Area of effect',1,1,1,7),(652,'signatureRadiusMultiplier',5,'',NULL,NULL,0,NULL,0,1,'Signature Penalty',109,1,1,7),(653,'aoeVelocity',4,'Velocity of the damage cloud created on impact.',NULL,NULL,0,NULL,0,1,'Explosion Velocity',10,1,1,7),(654,'aoeCloudSize',4,'Size of the damage cloud caused by impact.',NULL,NULL,1390,NULL,0,1,'Explosion Radius',1,1,1,7),(655,'aoeFalloff',5,'',NULL,NULL,0,NULL,0,0,'aoeFalloff',NULL,1,1,9),(656,'shipBonusAC2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusAC2',NULL,1,1,9),(657,'shipBonusCC2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusCC2',NULL,1,1,9),(658,'shipBonusGC2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusGC2',NULL,1,1,9),(659,'shipBonusMC2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusMC2',NULL,1,1,9),(660,'impactDamage',4,'The amount of kinetic damage that might be inflicted on collision.',NULL,NULL,0,NULL,0,0,'Kinetic Damage',113,1,1,9),(661,'maxDirectionalVelocity',5,'Deprecated.',NULL,NULL,0,NULL,1,0,'maxDirectionalVelocity',NULL,1,1,9),(662,'minTargetVelDmgMultiplier',5,'Deprecated.',NULL,NULL,0,NULL,1,0,'minTargetVelDmgMultiplier',NULL,1,1,9),(663,'minMissileVelDmgMultiplier',5,'',NULL,NULL,0,NULL,1,0,'minMissileVelDmgMultiplier',NULL,1,1,9),(664,'maxMissileVelocity',5,'A multiplier used for the missile impact damage calculations.',NULL,NULL,0,NULL,1,0,'maxMissileVelocity',NULL,1,1,9),(665,'entityChaseMaxDistance',4,'The distance outside of which the entity activates their MWD equivalent.',NULL,NULL,0,NULL,2500,0,'entityChaseMaxDistance',1,1,1,9),(666,'moduleShipGroup2',12,'This module only fits on specific ship groups.  This is one of them.',NULL,NULL,0,NULL,0,1,'Restricted Ship Type',115,1,1,7),(667,'moduleShipGroup3',12,'This module only fits on specific ship groups.  This is one of them.',NULL,NULL,0,NULL,0,1,'Restricted Ship Type',115,1,1,1),(668,'moduleShipGroup1',12,'This module only fits on specific ship groups.  This is one of them.',NULL,NULL,0,NULL,0,1,'Restricted Ship Type',115,1,1,7),(669,'moduleReactivationDelay',4,'Amount of time that has to be waited after the deactivation of this module until it can be reactivated.',NULL,NULL,0,NULL,0,1,'Reactivation Delay',101,1,1,7),(670,'areaOfEffectBonus',5,'',NULL,NULL,1390,NULL,0,1,'Area Of Effect Bonus',1,1,1,7),(672,'entityCruiseSpeedMultiplier',5,'',NULL,NULL,0,NULL,1,1,'Orbit Velocity Bonus',109,1,1,7),(673,'eliteBonusGunship1',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusGunship1',NULL,1,1,9),(675,'eliteBonusGunship2',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusGunship2',NULL,1,1,9),(676,'unanchoringDelay',4,'How long it takes to unanchor this object.',NULL,NULL,1392,NULL,60000,1,'Unanchoring Delay',101,1,1,7),(677,'onliningDelay',4,'How long it takes to bring this object online.',NULL,NULL,1392,NULL,60000,1,'Onlining Delay',101,1,1,7),(678,'eliteBonusLogistics1',5,'first bonus for support cruisers',NULL,NULL,0,NULL,0,0,'eliteBonusLogistics1',NULL,1,1,9),(679,'eliteBonusLogistics2',5,'second bonus for support cruisers',NULL,NULL,0,NULL,0,0,'eliteBonusLogistics2',NULL,1,1,9),(680,'shieldRadius',4,'Radius of the force shield that this structure generates.',NULL,NULL,0,NULL,0,1,'Shield Radius',1,1,1,2),(681,'typeContainerType1',11,'A type allowed to be placed in this container.',NULL,NULL,0,NULL,0,1,'Stored Type 1',116,1,1,7),(682,'typeContainerType2',11,'A type allowed to be placed in this container.',NULL,NULL,0,NULL,0,1,'Stored Type 2',116,1,1,7),(683,'typeContainerType3',11,'A type allowed to be placed in this container.',NULL,NULL,0,NULL,0,1,'Stored Type 3',116,1,1,7),(684,'typeContainerCapacity1',4,'The amount of storage type 1 that can be fitted inside this structure.',NULL,NULL,0,NULL,0,1,'Storage Capacity 1',9,1,1,7),(685,'typeContainerCapacity2',4,'The amount of storage type 2 that can be fitted inside this structure.',NULL,NULL,0,NULL,0,1,'Storage Capacity 2',9,1,1,7),(686,'typeContainerCapacity3',4,'The amount of storage type 3 that can be fitted inside this structure.',NULL,NULL,0,NULL,0,1,'Storage Capacity 3',9,1,1,7),(687,'operationConsumptionRate',4,'The number of units of a resource consumed per minute of operation.',NULL,NULL,0,NULL,0,1,'Operation Consumption Rate',NULL,1,1,7),(688,'reinforcedConsumptionRate',4,'The number of units of a resource consumed per minute of reinforced mode.',NULL,NULL,0,NULL,0,1,'Resinforced Consumption Rate',NULL,1,1,7),(689,'packageGraphicID',4,'The graphicID used for the structure when it is in package form.',NULL,NULL,2391,NULL,2391,0,'packageGraphicID',NULL,1,1,9),(690,'packageRadius',5,'The radius of the structure when it is in package form.',NULL,NULL,0,NULL,250,0,'packageRadius',NULL,1,1,9),(691,'targetSwitchDelay',4,'The amount of time after attacking a target that an entity will wait before switching to a new one.',NULL,NULL,0,NULL,0,0,'Target Cycling Speed',101,1,1,9),(692,'eliteBonusHeavyGunship1',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusHeavyGunship1',NULL,1,1,9),(693,'eliteBonusHeavyGunship2',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusHeavyGunship2',NULL,1,1,9),(694,'resourceReinforced1Type',11,'',NULL,NULL,0,NULL,0,1,'Reinforced Mode Type',116,1,1,7),(695,'resourceReinforced2Type',11,'',NULL,NULL,0,NULL,0,1,'Reinforced Mode Type',116,1,1,7),(696,'resourceReinforced3Type',11,'',NULL,NULL,0,NULL,0,1,'Reinforced Mode Type',116,1,1,7),(697,'resourceReinforced4Type',11,'',NULL,NULL,0,NULL,0,1,'Reinforced Mode Type',116,1,1,7),(698,'resourceReinforced5Type',11,'',NULL,NULL,0,NULL,0,1,'Reinforced Mode Type',116,1,1,7),(699,'resourceReinforced1Quantity',4,'',NULL,NULL,0,NULL,0,1,'Reinforced Mode Quantity',9,1,1,7),(700,'resourceReinforced2Quantity',4,'',NULL,NULL,0,NULL,0,1,'Reinforced Mode Quantity',9,1,1,7),(701,'resourceReinforced3Quantity',4,'',NULL,NULL,0,NULL,0,1,'Reinforced Mode Quantity',9,1,1,7),(703,'resourceReinforced4Quantity',4,'',NULL,NULL,0,NULL,0,1,'Reinforced Mode Quantity',9,1,1,7),(704,'resourceReinforced5Quantity',4,'',NULL,NULL,0,NULL,0,1,'Reinforced Mode Quantity',9,1,1,7),(705,'resourceOnline1Type',11,'',NULL,NULL,NULL,NULL,0,1,'Online Mode Type',116,1,1,7),(706,'resourceOnline2Type',11,'',NULL,NULL,0,NULL,0,1,'Online Mode Type',116,1,1,7),(707,'resourceOnline3Type',11,'',NULL,NULL,0,NULL,0,1,'Online Mode Type',116,1,1,7),(708,'resourceOnline4Type',11,'',NULL,NULL,0,NULL,0,1,'Online Mode Type',NULL,1,1,7),(709,'harvesterType',11,'The type of material harvested.',NULL,NULL,0,NULL,0,1,'Harvested Type',116,1,1,7),(710,'harvesterQuality',4,'The quality of the material harvested.',NULL,NULL,0,NULL,0,1,'Harvester Quality',NULL,1,1,7),(711,'moonAnchorDistance',4,'How many meters from the standard warp-in distance a moon can be anchored from.',NULL,NULL,0,NULL,0,1,'Moon Anchor Distance',1,1,1,7),(712,'usageDamagePercent',4,'How much a charge used by this object is damaged each time the object operates.',NULL,NULL,0,NULL,0,1,'Charge Usage Damage',105,1,1,7),(713,'consumptionType',11,'The type of resource needed to be consumed for each activation cycle of this structure.',NULL,NULL,0,NULL,0,1,'Consumption Type',116,1,1,7),(714,'consumptionQuantity',4,'The amount of the given resource type needed to be consumed for each activation cycle of this structure.',NULL,NULL,0,NULL,0,1,'Consumption Quantity',NULL,1,1,7),(715,'maxOperationalDistance',4,'The maximum distance at which the object can be used.',NULL,NULL,0,NULL,0,1,'Maximum Operational Distance',1,1,1,7),(716,'maxOperationalUsers',4,'The maximum number of users that can be present within the operational range of the structure for it to be capable of operation.',NULL,NULL,0,NULL,0,1,'Maximum Concurrent Operational Users',NULL,1,1,7),(717,'refiningYieldMultiplier',5,'The factor by which the structure modifies the using pilot\'s refining yield rate.',NULL,NULL,0,NULL,1,1,'Refining Yield Multiplier',104,1,1,7),(719,'operationalDuration',4,'The amount of time that is taken to refine the ore into the end product.  The structure is busy for the length of this process.',NULL,NULL,0,NULL,0,1,'Operational Duration',101,1,1,7),(720,'refineryCapacity',4,'The capacity of the refinery container.',NULL,NULL,0,NULL,0,1,'Refinery Capacity',9,1,1,1),(721,'refiningDelayMultiplier',5,'The factor by which the character can effect the amount of time that the Refining Delay takes.',NULL,NULL,0,NULL,1,0,'refiningDelayMultiplier',NULL,1,1,9),(722,'posControlTowerPeriod',4,'The interval for fuel consumption of a control tower',NULL,NULL,0,NULL,10000,1,'Starbase Control Tower Period',101,1,1,7),(723,'contrabandDetectionChance',5,'The chance that the customs official has of detecting contraband on board a scanned vessel',NULL,NULL,0,NULL,0,0,'contrabandDetectionChance',NULL,1,1,9),(724,'contrabandDetectionResistance',5,'A modifier to the chance of contraband detection success of police who scan the pilot\'s vessel.',NULL,NULL,0,NULL,0,0,'contrabandDetectionResistance',NULL,1,1,9),(725,'contrabandScanChance',5,'The chance that a passer by will be chosen as a target of a scan for contraband.',NULL,NULL,0,NULL,0,0,'contrabandScanChance',NULL,1,1,9),(726,'moonMiningAmount',4,'',NULL,NULL,0,NULL,1,1,'Moon Mining Amount',9,1,1,9),(727,'destroyerROFpenality',5,'',NULL,NULL,0,NULL,0,0,'destroyerROFpenality',NULL,1,1,9),(728,'controlTowerLaserDamageBonus',5,'',NULL,NULL,0,NULL,0,0,'Laser Sentry Damage Bonus',105,1,1,9),(729,'shipBonusMD1',5,'',NULL,NULL,0,NULL,0,0,'shipBonusMD1',NULL,1,1,9),(732,'shipBonusD1',5,'',NULL,NULL,0,NULL,0,0,'shipBonusD1',NULL,1,1,9),(733,'shipBonusD2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusD2',NULL,1,1,9),(734,'shipBonusCD1',5,'',NULL,NULL,0,NULL,0,0,'shipBonusCD1',NULL,1,1,9),(735,'shipBonusCD2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusCD2',NULL,1,1,9),(738,'shipBonusGD1',5,'',NULL,NULL,0,NULL,0,0,'shipBonusGD1',NULL,1,1,9),(739,'shipBonusGD2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusGD2',NULL,1,1,9),(740,'shipBonusMD2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusMD2',NULL,1,1,9),(741,'shipBonusBC1',5,'',NULL,NULL,0,NULL,0,0,'shipBonusBC1',NULL,1,1,9),(742,'shipBonusBC2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusBC2',NULL,1,1,9),(743,'shipBonusCBC1',5,'',NULL,NULL,0,NULL,0,0,'shipBonusCBC1',NULL,1,1,7),(745,'shipBonusCBC2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusCBC2',NULL,1,1,9),(746,'shipBonusGBC2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusGBC2',NULL,1,1,9),(747,'shipBonusGBC1',5,'',NULL,NULL,0,NULL,0,0,'shipBonusGBC1',NULL,1,1,9),(748,'shipBonusMBC1',5,'',NULL,NULL,0,NULL,0,0,'shipBonusMBC1',NULL,1,1,9),(749,'shipBonusMBC2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusMBC2',NULL,1,1,9),(750,'controlTowerLaserOptimalBonus',5,'',NULL,NULL,0,NULL,0,0,'Laser Sentry Optimal Bonus',105,1,1,9),(751,'controlTowerHybridOptimalBonus',5,'',NULL,NULL,0,NULL,0,1,'Hybrid Sentry Optimal Bonus',105,1,1,7),(752,'controlTowerProjectileOptimalBonus',5,'',NULL,NULL,0,NULL,0,0,'Projectile Sentry Optimal Bonus',105,1,1,9),(753,'controlTowerProjectileFallOffBonus',5,'',NULL,NULL,0,NULL,0,0,'Projectile Sentry Fall Off Bonus',105,1,1,9),(754,'controlTowerProjectileROFBonus',5,'',NULL,NULL,0,NULL,0,0,'Projectile Sentry Rate of Fire Bonus',105,1,1,9),(755,'controlTowerMissileROFBonus',5,'',NULL,NULL,0,NULL,0,0,'Missile Bay Rate of Fire Bonus',105,1,1,9),(756,'controlTowerMoonHarvesterCPUBonus',5,'',NULL,NULL,0,NULL,0,0,'Moon Harvester CPU Bonus',105,1,1,9),(757,'controlTowerSiloCapacityBonus',5,'',NULL,NULL,0,NULL,0,0,'Silo Capacity Bonus',105,1,1,9),(758,'shipBonusDF1',5,'destroyers attribute 1',NULL,NULL,0,NULL,0,0,'shipBonusDF1',NULL,1,1,9),(759,'shipBonusDF2',5,'destroyer attribute 2',NULL,NULL,0,NULL,0,0,'shipBonusDF2',NULL,1,1,9),(760,'controlTowerLaserProximityRangeBonus',5,'',NULL,NULL,0,NULL,0,1,'Laser Sentry Proximity Bonus',105,1,1,7),(761,'controlTowerProjectileProximityRangeBonus',5,'',NULL,NULL,0,NULL,0,1,'Projectile Sentry Proximity Bonus',105,1,1,7),(762,'controlTowerHybridProximityRangeBonus',5,'',NULL,NULL,0,NULL,0,1,'Hybrid Sentry Proximity Bonus',105,1,1,7),(763,'maxGroupActive',4,'Maximum modules of same group that can be activated at same time, 0 = no limit, 1 = 1',NULL,NULL,0,NULL,0,0,'maxGroupActive',NULL,1,1,9),(764,'controlTowerEwRofBonus',5,'',NULL,NULL,0,NULL,0,1,'Target Jamming Duration Bonus',105,1,1,6),(765,'scanRange',5,'Effective range of scanner in multiples of AUs',NULL,NULL,0,NULL,10,1,'Scan Range',NULL,1,1,7),(766,'controlTowerHybridDamageBonus',5,'',NULL,NULL,0,NULL,0,0,'Hybrid Sentry Damage Bonus',105,1,1,9),(767,'trackingSpeedBonus',5,'Tracking Speed Bonus',NULL,NULL,1398,NULL,0,1,'Tracking Speed Bonus',105,1,1,7),(769,'maxRangeBonus2',5,'',NULL,NULL,0,NULL,0,1,'Optimal Range Bonus',105,1,1,6),(770,'controlTowerEwTargetSwitchDelayBonus',5,'Bonus attribute to entity Target Switch Delay',NULL,NULL,0,NULL,0,0,'EW Target Switch Delay Bonus',105,1,1,9),(771,'ammoCapacity',5,'',NULL,NULL,0,NULL,0,0,'Ammo Capacity',NULL,1,1,7),(772,'entityFlyRangeFactor',5,'',NULL,NULL,0,NULL,1,0,'entityFlyRangeFactor',NULL,1,1,9),(773,'shipBonusORE1',5,'ORE mining barge bonus',NULL,NULL,0,NULL,0,0,'shipBonusORE1',NULL,1,1,9),(774,'shipBonusORE2',5,'ORE Mining barge bonus 2',NULL,NULL,0,NULL,0,0,'shipBonusORE2',NULL,1,1,9),(775,'miningCPUNeedBonus',5,'funky stuff for mining barges',NULL,NULL,0,NULL,0,0,'miningCPUNeedBonus',NULL,1,1,9),(776,'structureMissileVelocityBonus',5,'Velocity %bonus for given missile group for missile batteries.',NULL,NULL,0,NULL,0,1,'Missile Velocity Bonus',105,1,1,7),(777,'structureMissileDamageBonus',5,'Damage %bonus for given missile group for missile batteries.',NULL,NULL,0,NULL,0,1,'Missile Damage Bonus',105,1,1,7),(778,'structureMissileExplosionDelayBonus',5,'Exploision Delay (range) bonus for missile batteries',NULL,NULL,0,NULL,0,1,'Missile Explosion Delay Bonus',105,1,1,7),(779,'entityFlyRangeMultiplier',5,'For charges, hidden attribute used by sentry guns to modify target pick range.',NULL,NULL,0,NULL,1,0,'entityFlyRangeMultiplier',NULL,1,1,9),(780,'iceHarvestCycleBonus',5,'',NULL,NULL,0,NULL,0,1,'Cycle Time bonus',105,1,1,7),(781,'specialisationAsteroidGroup',12,'The group at which the mining crystal is tuned to mine.',NULL,NULL,0,NULL,0,1,'Asteroid Specialization Group',115,1,1,7),(782,'specialisationAsteroidYieldMultiplier',5,'The amount the yield is modified when mining the asteroid group this crystal is tuned for.',NULL,NULL,0,NULL,0,1,'Asteroid Specialization Yield Modifier',104,1,1,7),(783,'crystalVolatilityChance',5,'The chance of damage to the crystal each time it is used.',NULL,NULL,0,NULL,0,1,'Volatility',105,1,1,7),(784,'crystalVolatilityDamage',5,'The amount of damage done if the crystal is damaged in the process of using it.',NULL,NULL,0,NULL,0,1,'Volatility Damage',113,1,1,7),(785,'unfitCapCost',5,'The capacitor charge required to disengage this crystal from the unit it is installed in.',NULL,NULL,0,NULL,0,1,'Unfitting Capacitor Cost',114,1,1,7),(786,'crystalsGetDamaged',3,'Whether this tool causes damage to crystals with each use of them.',NULL,NULL,0,NULL,0,1,'Crystals Damage',NULL,1,1,7),(787,'minScanDeviation',5,'Minimum scanning error',NULL,NULL,0,NULL,0,1,'Minimum Scan Deviation',1,1,1,7),(788,'maxScanDeviation',5,'Maximum scan error',NULL,NULL,0,NULL,0,1,'Maximum Scan Deviation',1,1,1,7),(789,'specialtyMiningAmount',5,'',NULL,NULL,0,NULL,0,1,'Specialty Crystal Mining Amount',9,1,1,7),(790,'reprocessingSkillType',11,'The skill required to reprocess this ore type.',NULL,NULL,0,NULL,0,1,'Reprocessing Skill',116,1,1,7),(791,'scanAnalyzeCount',4,'Number of probes needed for an analyzis',NULL,NULL,0,NULL,3,1,'Probes to Analyze',NULL,1,1,7),(792,'controlTowerMissileVelocityBonus',5,'',NULL,NULL,0,NULL,0,0,'Missile Velocity Bonus',105,1,1,9),(793,'shipBonusPirateFaction',5,'Stock Bonus on Pirate Faction Ships.',NULL,NULL,0,NULL,0,0,'shipBonusPirateFaction',NULL,1,1,9),(794,'probesInGroup',4,'Number of probes to analyze',NULL,NULL,0,NULL,3,0,'Probes To Analyze',NULL,1,1,9),(795,'shipBonusABC1',5,'',NULL,NULL,0,NULL,0,0,'shipBonusABC1',NULL,1,1,9),(796,'massAddition',5,'Attribute for adding mass to a ship via an afterburner or MWD.',NULL,NULL,0,NULL,0,1,'Mass Addition',2,1,1,7),(797,'maximumRangeCap',5,'The maximum possible target range.',NULL,NULL,1391,NULL,249999,1,'Theoretical Maximum Targetting Range',1,1,1,7),(798,'entityBracketColour',4,'so far: 0 = white, 1 = red',NULL,NULL,0,NULL,0,0,'entityBracketColour',NULL,1,1,9),(799,'implantSetBloodraider',5,'',NULL,NULL,0,NULL,2,1,'Talisman Set Bonus',104,1,1,7),(800,'contrabandDetectionChanceBonus',5,'Autogenerated skill attribute, contrabandDetectionChanceBonus',NULL,NULL,0,NULL,0,1,'Contraband Detection Modifier',127,1,0,7),(801,'deadspaceUnsafe',5,'Modules with this attribute set to 1 can not be used in deadspace. Modules with this attribute set to 2 can not be used in deadspace even where \"disableModuleBlocking\" is selected',NULL,NULL,0,NULL,0,0,'deadspaceUnsafe',NULL,1,1,9),(802,'implantSetSerpentis',5,'',NULL,NULL,0,NULL,0,1,'Snake Set Bonus',104,1,1,7),(803,'implantSetSerpentis2',5,'',NULL,NULL,0,NULL,0,0,'implantSetSerpentis2',NULL,1,1,9),(804,'eliteBonusInterceptor2',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusInterceptor2',NULL,1,1,9),(805,'quantity',1,'Quantity contained.',NULL,NULL,0,NULL,0,1,'Quantity',NULL,1,1,7),(806,'repairBonus',4,'Autogenerated skill attribute, repairBonus',NULL,NULL,0,NULL,0,1,'Repair Bonus',105,1,1,7),(807,'eliteBonusIndustrial1',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusIndustrial1',NULL,1,1,9),(808,'eliteBonusIndustrial2',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusIndustrial2',NULL,1,1,9),(809,'shipBonusAI2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusAI2',NULL,1,1,9),(811,'shipBonusCI2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusCI2',NULL,1,1,9),(813,'shipBonusGI2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusGI2',NULL,1,1,9),(814,'shipBonusMI2',5,'',NULL,NULL,0,NULL,0,0,'shipBonusMI2',NULL,1,1,9),(815,'propulsionFusionStrengthBonus',5,'Amarr Propulsion Attack Strength for Warp Scramblers etc.',NULL,NULL,0,NULL,0,1,'Fusion Strength',120,1,1,7),(816,'propulsionIonStrengthBonus',5,'Caldari Propulsion Attack Strength for Warp Scramblers etc.',NULL,NULL,0,NULL,0,1,'Ion Strength',120,1,1,7),(817,'propulsionMagpulseStrengthBonus',5,'Gallente Propulsion Attack Strength for Warp Scramblers etc.',NULL,NULL,0,NULL,0,1,'Magpulse Strength',120,1,1,7),(818,'propulsionPlasmaStrengthBonus',5,'Minmatar Propulsion Attack Strength for Warp Scramblers etc.',NULL,NULL,0,NULL,0,1,'Plasma Strength',120,1,1,7),(819,'propulsionFusionStrength',5,'Amarr propulsion strength for ship.',NULL,NULL,2736,NULL,0,1,'Fusion Propulsion Strength',120,1,1,7),(820,'propulsionIonStrength',5,'Caldari propulsion strength for ship.',NULL,NULL,2733,NULL,0,1,'Ion Propulsion Strength',120,1,1,7),(821,'propulsionMagpulseStrength',5,'Gallente propulsion strength for ship.',NULL,NULL,2734,NULL,0,1,'Magpulse Propulsion Strength',120,1,1,7),(822,'propulsionPlasmaStrength',5,'Minmatar propulsion strength for ship.',NULL,NULL,2735,NULL,0,1,'Plasma Propulsion Strength',120,1,1,7),(823,'hitsMissilesOnly',4,'Effect for smartbombs, used to hit missiles only.',NULL,NULL,0,NULL,0,0,'hitsMissilesOnly',NULL,1,1,9),(828,'scanSkillEwStrengthBonus',5,'Skill attribute for increasing strength of EW modules.',NULL,NULL,0,NULL,0,1,'EW Strength Modifier',105,1,1,7),(829,'propulsionSkillPropulsionStrengthBonus',5,'Skill attribute for increasing strength of Propulsion modules.',NULL,NULL,0,NULL,0,0,'propulsionSkillPropulsionStrengthBonus',NULL,1,1,9),(830,'bonusComplexAngel10',5,'Bonus used on Unique Loot in level 10 Angel cartel Deadspace Complexes.',NULL,NULL,0,NULL,5,0,'bonusComplexAngel10',NULL,1,1,9),(831,'ewTargetJam',4,'Used for target jam effects to reduce max locked targets of victem to a negative value to ensure the victem looses its targets, use extreme value',NULL,NULL,0,NULL,0,0,'ewTargetJam',NULL,1,1,9),(832,'scanSkillTargetPaintStrengthBonus',5,'Skill attribute for increasing effectiveness on Target Painters',NULL,NULL,0,NULL,0,1,'Target Painting Bonus',105,1,1,7),(833,'commandBonus',5,'',NULL,NULL,0,NULL,0,1,'Command Bonus',121,1,1,7),(834,'wingCommandBonus',5,'',NULL,NULL,0,NULL,0,0,'WingCommandBonus',NULL,1,1,9),(837,'stealthBomberLauncherPower',5,'Used for stealth bombers to decrease power need on cruise launchers.',NULL,NULL,0,NULL,1,0,'stealthBomberLauncherPower',NULL,1,1,9),(838,'implantSetGuristas',5,'',NULL,NULL,0,NULL,1,1,'Crystal Set Bonus',104,1,1,7),(839,'eliteBonusCoverOps2',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusCoverOps2',NULL,1,1,9),(840,'agentID',4,'agentID to use when initiating NPC communications with this type.',NULL,NULL,0,NULL,0,1,'Agent ID',NULL,1,1,9),(841,'agentCommRange',4,'The range of the agent\'s communication sphere',NULL,NULL,0,NULL,100000,1,'Agent Comm Range',1,1,1,9),(842,'reactionGroup1',12,'',NULL,NULL,0,NULL,0,1,'Reaction Type 1',115,1,1,7),(843,'reactionGroup2',12,'',NULL,NULL,0,NULL,0,1,'Reaction Type 2',115,1,1,7),(844,'agentAutoPopupRange',4,'If the player comes within this range of this agent-in-space, an automatic communication window popup will occur.',NULL,NULL,0,NULL,5000,1,'Agent Auto Popup Range',1,1,1,9),(845,'hiddenLauncherDamageBonus',5,'Hidden Attribute for tech 2 launcher damage bonus.',NULL,NULL,0,NULL,1,0,'hiddenLauncherDamageBonus',NULL,1,1,9),(846,'scanStrengthBonus',5,'',NULL,NULL,0,NULL,0,1,'Scan Strength Bonus',105,1,1,7),(847,'aoeVelocityBonus',5,'Increases velocity of missile explosion',NULL,NULL,1389,NULL,0,1,'Explosion Velocity Bonus',105,1,1,7),(848,'aoeCloudSizeBonus',5,'Booster attribute to explosion radius of missiles vs. signature radius.',NULL,NULL,1390,NULL,0,1,'Explosion Radius Bonus',105,1,1,7),(849,'canUseCargoInSpace',5,'Can use cargo in space or not, 0 = no, 1 = yes',NULL,NULL,0,NULL,1,0,'canUseCargoInSpace',NULL,1,1,9),(850,'squadronCommandBonus',4,'Autogenerated skill attribute, relayCPUBonus',NULL,NULL,0,NULL,0,1,'Squadron Command Bonus',121,1,1,7),(851,'shieldBoostCapacitorBonus',4,'Bonus to capacitor need for shield boosters.',NULL,NULL,0,NULL,0,1,'Capacitor Need Bonus',124,1,1,2),(852,'siegeModeWarpStatus',4,'',NULL,NULL,0,NULL,0,0,'siegeModeWarpStatus',NULL,1,1,9),(853,'advancedAgility',5,'Attribute on ship to make advanced command affect only ships that we want.',NULL,NULL,0,NULL,1,0,'Agility Bonus',NULL,1,1,7),(854,'disallowAssistance',4,'If this module is in use and this attribute is 1, then assistance modules cannot be used on the ship.',NULL,NULL,0,NULL,0,0,'Disallows Assistance',NULL,1,1,9),(855,'activationTargetLoss',4,'Activating this module results in the temporary loss of all targets currently held or being locked.',NULL,NULL,0,NULL,0,0,'Activation Target Loss',NULL,1,1,6),(857,'aoeFalloffBonus',5,'',NULL,NULL,0,NULL,0,0,'Velocity Falloff Bonus',105,1,1,7),(858,'missileEntityAoeCloudSizeMultiplier',5,'Affects the signature radius of the target in missile impact calculations.',NULL,NULL,0,NULL,1,1,'Explosion Radius Bonus',109,1,1,7),(859,'missileEntityAoeVelocityMultiplier',5,'Affects the velocity of the target in missile impact calculations.',NULL,NULL,0,NULL,1,1,'Explosion Velocity Bonus',109,1,1,7),(860,'missileEntityAoeFalloffMultiplier',5,'',NULL,NULL,0,NULL,1,0,'missileEntityAoeFalloffMultiplier',NULL,1,1,9),(861,'canJump',4,'1 = ship can use jump drive',NULL,NULL,0,NULL,0,1,'Onboard Jump Drive',NULL,1,1,7),(862,'usageWeighting',5,'The weighting given to this type and its chance of being picked for a grouping.',NULL,NULL,0,NULL,0,0,'usageWeighting',NULL,1,1,9),(863,'implantSetAngel',5,'',NULL,NULL,0,NULL,1,1,'Halo Set Bonus',104,1,1,7),(864,'implantSetSansha',5,'',NULL,NULL,0,NULL,0,1,'Slave Set Bonus',104,1,1,7),(865,'planetAnchorDistance',4,'How many meters from the standard warp-in distance a planet can be anchored from.',NULL,NULL,0,NULL,100000,0,'planetAnchorDistance',1,1,1,9),(866,'jumpDriveConsumptionType',11,'Type that is used for consumption from cargo hold when activating jump drive operation.',NULL,NULL,0,NULL,0,1,'Jump Drive Fuel Need',116,1,1,7),(867,'jumpDriveRange',5,'Range in light years the ship can maximum jump to.',NULL,NULL,1391,NULL,0,1,'Maximum Jump Range',126,1,1,7),(868,'jumpDriveConsumptionAmount',5,'Number of units it consumes per light year.',NULL,NULL,0,NULL,0,1,'Jump Drive Consumption Amount',NULL,1,1,7),(869,'jumpDriveDuration',4,'The amount of time before the ship actually jumps.',NULL,NULL,0,NULL,300000,0,'jumpDriveDuration',NULL,1,1,9),(870,'jumpDriveRangeBonus',4,'Jump range bonus for jump drive operation.',NULL,NULL,0,NULL,0,1,'Jump Drive Range Bonus',105,1,1,7),(871,'jumpDriveDurationBonus',4,'Skill bonus attribute that decreases the duration before iniating a jump.',NULL,NULL,0,NULL,0,0,'Jump Drive Duration Bonus',105,1,1,9),(872,'disallowOffensiveModifiers',4,'(Buffer)',NULL,NULL,0,NULL,0,0,'Disallows Offensive Modifiers',NULL,1,1,9),(874,'advancedCapitalAgility',5,'',NULL,NULL,0,NULL,1,0,'advancedCapitalAgility',NULL,1,1,9),(875,'dreadnoughtShipBonusA1',5,'',NULL,NULL,0,NULL,0,0,'dreadnoughtShipBonusA1',NULL,1,1,9),(876,'dreadnoughtShipBonusA2',5,'',NULL,NULL,0,NULL,0,0,'dreadnoughtShipBonusA2',NULL,1,1,9),(877,'dreadnoughtShipBonusC1',5,'',NULL,NULL,0,NULL,0,0,'dreadnoughtShipBonusC1',NULL,1,1,9),(878,'dreadnoughtShipBonusC2',5,'',NULL,NULL,0,NULL,0,0,'dreadnoughtShipBonusC2',NULL,1,1,9),(879,'dreadnoughtShipBonusG1',5,'',NULL,NULL,0,NULL,0,0,'dreadnoughtShipBonusG1',NULL,1,1,9),(880,'dreadnoughtShipBonusG2',5,'',NULL,NULL,0,NULL,0,0,'dreadnoughtShipBonusG2',NULL,1,1,9),(881,'dreadnoughtShipBonusM1',5,'',NULL,NULL,0,NULL,0,0,'dreadnoughtShipBonusM1',NULL,1,1,9),(882,'dreadnoughtShipBonusM2',5,'',NULL,NULL,0,NULL,0,0,'dreadnoughtShipBonusM2',NULL,1,1,9),(884,'mindlinkBonus',5,'',NULL,NULL,0,NULL,0,1,'Mindlink Bonus',105,1,1,7),(885,'consumptionQuantityBonus',4,'',NULL,NULL,0,NULL,0,1,'Consumption Quantity Bonus',NULL,1,1,7),(886,'freighterBonusA1',5,'',NULL,NULL,0,NULL,0,0,'freighterBonusA1',NULL,1,1,9),(887,'freighterBonusA2',5,'',NULL,NULL,0,NULL,0,0,'freighterBonusA2',NULL,1,1,9),(888,'freighterBonusC1',5,'',NULL,NULL,0,NULL,0,0,'freighterBonusC1',NULL,1,1,9),(889,'freighterBonusC2',5,'',NULL,NULL,0,NULL,0,0,'freighterBonusC2',NULL,1,1,9),(890,'freighterBonusG2',5,'',NULL,NULL,0,NULL,0,0,'freighterBonusG2',NULL,1,1,9),(891,'freighterBonusG1',5,'',NULL,NULL,0,NULL,0,0,'freighterBonusG1',NULL,1,1,9),(892,'freighterBonusM1',5,'',NULL,NULL,0,NULL,0,0,'freighterBonusM1',NULL,1,1,9),(893,'freighterBonusM2',5,'',NULL,NULL,0,NULL,0,0,'freighterBonusM2',NULL,1,1,9),(894,'speedBoostBonus',5,'Testing for fuels for speed boosters.',NULL,NULL,0,NULL,0,1,'Speed Boost Bonus',105,1,1,7),(895,'armorDamageAmountBonus',5,'Bonus attribute for armor repair amount.',NULL,NULL,80,NULL,0,1,'Armor Repair Bonus',105,1,1,7),(896,'armorDamageDurationBonus',5,'',NULL,NULL,1392,NULL,0,1,'Armor Repair Duration Bonus',105,1,1,7),(897,'shieldBonusDurationBonus',5,'',NULL,NULL,1392,NULL,0,1,'Shield Boost Duration Bonus',105,1,1,2),(898,'jumpDriveCapacitorNeed',5,'Minimum capacitor need for jump drive operation from full capacitor in modifier%.',NULL,NULL,1032,NULL,1,1,'Jump Drive Capacitor Need',127,1,1,7),(899,'jumpDriveCapacitorNeedBonus',5,'',NULL,NULL,1032,NULL,0,1,'Jump Drive Capacitor Need Bonus',105,1,1,7),(901,'accessDifficulty',5,'The difficulty in opening this object.',NULL,NULL,0,NULL,0,1,'Access Difficulty',NULL,1,1,7),(902,'accessDifficultyBonus',5,'Bonus to chance of opening a container.',NULL,NULL,0,NULL,0,1,'Access Difficulty Bonus',121,1,1,7),(903,'spawnWithoutGuardsToo',5,'Whether a spawn container should refill itself when there are no guards assigned to it.',NULL,NULL,0,NULL,0,0,'spawnWithoutGuardsToo',NULL,1,1,9),(904,'warcruiserCPUBonus',5,'',NULL,NULL,0,NULL,0,0,'warcruiserCPUBonus',NULL,1,1,9),(905,'tacklerBonus',4,'',NULL,NULL,0,NULL,10,0,'tacklerBonus',NULL,1,1,9),(906,'disallowEarlyDeactivation',3,'Signifies that this module if activated, will prevent ejection from the ship it is fitted to and extend the log out ship removal timer.',NULL,NULL,0,NULL,0,0,'disallowEarlyDeactivation',NULL,1,1,9),(907,'hasShipMaintenanceBay',3,'Indicates whether a ship type has a ship maintenance bay.',NULL,NULL,0,NULL,0,0,'hasShipMaintenanceBay',NULL,1,1,9),(908,'shipMaintenanceBayCapacity',5,'The capacity of the hangar in a ship.',NULL,NULL,71,NULL,0,1,'Ship Maintenance Bay Capacity',9,1,1,7),(909,'maxShipGroupActiveID',12,'Which group of modules that this ship limits the number of concurrent activations of.',NULL,NULL,0,NULL,0,0,'maxShipGroupActiveID',NULL,1,1,9),(910,'maxShipGroupActive',4,'The amount of modules belonging to the same group that can be active at the same time.',NULL,NULL,0,NULL,0,1,'Max Group Active',NULL,1,1,7),(911,'hasCorporateHangars',3,'Whether this ship has corporate hangars.',NULL,NULL,0,NULL,0,0,'hasCorporateHangars',NULL,1,1,9),(912,'corporateHangarCapacity',5,'The capacity of each hangar.',NULL,NULL,71,NULL,0,1,'Corporate Hangar Capacity',9,1,1,4),(913,'gallenteNavyBonus',5,'',NULL,NULL,0,NULL,0,0,'gallenteNavyBonus',NULL,1,1,9),(914,'gallenteNavyBonusMultiplier',5,'',NULL,NULL,0,NULL,0,0,'gallenteNavyBonusMultiplier',NULL,1,1,9),(915,'caldariNavyBonus',5,'',NULL,NULL,0,NULL,0,0,'caldariNavyBonus',NULL,1,1,9),(916,'caldariNavyBonusMultiplier',5,'',NULL,NULL,0,NULL,0,0,'caldariNavyBonusMultiplier',NULL,1,1,9),(917,'amarrNavyBonus',5,'',NULL,NULL,0,NULL,0,0,'amarrNavyBonus',NULL,1,1,9),(918,'amarrNavyBonusMulitplier',5,'',NULL,NULL,0,NULL,0,0,'amarrNavyBonusMulitplier',NULL,1,1,9),(919,'republicFleetBonus',5,'',NULL,NULL,0,NULL,0,0,'republicFleetBonus',NULL,1,1,9),(920,'republicFleetBonusMultiplier',5,'',NULL,NULL,0,NULL,0,0,'republicFleetBonusMultiplier',NULL,1,1,9),(921,'oreCompression',3,'',NULL,NULL,0,NULL,0,0,'oreCompression',NULL,1,1,9),(924,'eliteBonusBarge1',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusBarge1',NULL,1,1,9),(925,'eliteBonusBarge2',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusBarge2',NULL,1,1,9),(926,'shipBonusORE3',5,'ORE Mining Barge bonus 3',NULL,NULL,0,NULL,0,0,'shipBonusORE3',NULL,1,1,9),(927,'miningUpgradeCPUReductionBonus',5,'',NULL,NULL,0,NULL,0,0,'miningUpgradeCPUReductionBonus',NULL,1,1,9),(928,'entityTargetJam',5,'Target Jam multiplier on max locked targets for NPCs',NULL,NULL,0,NULL,1,0,'entityTargetJam',NULL,1,1,9),(929,'entityTargetJamDuration',4,'Duration of NPC effect',NULL,NULL,0,NULL,30000,0,'entityTargetJamDuration',NULL,1,1,9),(930,'entityTargetJamDurationChance',5,'Chance of NPC effect to be activated each duration',NULL,NULL,0,NULL,0,0,'entityTargetJamDurationChance',NULL,1,1,9),(931,'entityCapacitorDrainDurationChance',5,'Chance of NPC effect to be activated each duration',NULL,NULL,0,NULL,0,0,'entityCapacitorDrainDurationChance',NULL,1,1,9),(932,'entitySensorDampenDurationChance',5,'Chance of NPC effect to be activated each duration',NULL,NULL,0,NULL,0,0,'entitySensorDampenDurationChance',NULL,1,1,9),(933,'entityTrackingDisruptDurationChance',5,'Chance of NPC effect to be activated each duration',NULL,NULL,0,NULL,0,0,'entityTrackingDisruptDurationChance',NULL,1,1,9),(935,'entityTargetPaintDurationChance',5,'Chance of NPC effect to be activated each duration',NULL,NULL,0,NULL,0,0,'entityTargetPaintDurationChance',NULL,1,1,9),(936,'entityTargetJamMaxRange',4,'Max Range for NPC Target Jam',NULL,NULL,0,NULL,0,0,'entityTargetJamActivationRange',NULL,1,1,9),(937,'entityCapacitorDrainMaxRange',4,'Range for NPC capacitor drain',NULL,NULL,0,NULL,0,0,'entityCapacitorDrainActivationRange',NULL,1,1,9),(938,'entitySensorDampenMaxRange',4,'Range from target for when the NPC activates the effect',NULL,NULL,0,NULL,0,0,'entitySensorDampenActivationRange',NULL,1,1,9),(940,'entityTrackingDisruptMaxRange',4,'Max range from for NPC tracking disrupt',NULL,NULL,0,NULL,0,0,'entityTrackingDisruptActivationRange',NULL,1,1,9),(941,'entityTargetPaintMaxRange',4,'Max Range for NPC Target Paint',NULL,NULL,0,NULL,0,0,'entityTargetPaintActivationRange',NULL,1,1,9),(942,'entityCapacitorDrainDuration',4,'Duration of NPC effect',NULL,NULL,0,NULL,30000,0,'entityCapacitorDrainDuration',NULL,1,1,9),(943,'entitySensorDampenDuration',4,'Duration of NPC effect',NULL,NULL,0,NULL,30000,0,'entitySensorDampenDuration',NULL,1,1,9),(944,'entityTrackingDisruptDuration',4,'Duration of NPC effect',NULL,NULL,0,NULL,30000,0,'entityTrackingDisruptDuration',NULL,1,1,9),(945,'entityTargetPaintDuration',4,'Duration of NPC effect',NULL,NULL,0,NULL,30000,0,'entityTargetPaintDuration',NULL,1,1,9),(946,'entityCapacitorDrainAmount',4,'Amount of capacitor drained by NPC from target',NULL,NULL,0,NULL,0,0,'entityCapacitorDrainAmount',NULL,1,1,9),(947,'entitySensorDampenMultiplier',5,'Multiplier on max target range and scan resolution of target ship done by NPC',NULL,NULL,0,NULL,1,0,'entitySensorDampenMultiplier',NULL,1,1,9),(948,'entityTrackingDisruptMultiplier',5,'Multiplier on tracking speed and optimal range of player turrets done by NPC',NULL,NULL,0,NULL,1,0,'entityTrackingDisruptMultiplier',NULL,1,1,9),(949,'entityTargetPaintMultiplier',5,'Multiplier on signature radius of player ship done by NPC',NULL,NULL,0,NULL,1,0,'entityTargetPaintMultiplier',NULL,1,1,9),(950,'entitySensorDampenFallOff',4,'Fall Off for NPC sensor dampen',NULL,NULL,0,NULL,0,0,'entitySensorDampenFallOff',NULL,1,1,9),(951,'entityTrackingDisruptFallOff',4,'Fall Off for NPC Tracking Disrupt',NULL,NULL,0,NULL,0,0,'entityTrackingDisruptFallOff',NULL,1,1,9),(952,'entityCapacitorFallOff',4,'Fall Off for NPC Capacitor Drain',NULL,NULL,0,NULL,0,0,'entityCapacitorFallOff',NULL,1,1,9),(953,'entityTargetJamFallOff',4,'Fall Off for NPC Target Jam',NULL,NULL,0,NULL,0,0,'entityTargetJamFallOff',NULL,1,1,9),(954,'entityTargetPaintFallOff',4,'Fall Off for NPC Target Paint',NULL,NULL,0,NULL,0,0,'entityTargetPaintFallOff',NULL,1,1,9),(955,'isCaldariNavy',5,'',NULL,NULL,0,NULL,0,0,'isCaldariNavy',NULL,1,1,9),(956,'damageModifierMultiplierBonus',5,'',NULL,NULL,0,NULL,0,0,'damageModifierMultiplierBonus',NULL,1,1,9),(957,'cNavyModOncNavyShip',5,'',NULL,NULL,0,NULL,0,0,'cNavyModOncNavyShip',NULL,1,1,9),(958,'hardeningBonus',5,'Autogenerated skill attribute, hardeningBonus',NULL,NULL,0,NULL,0,1,'Hardening Bonus',105,1,1,7),(959,'entityShieldBoostLargeDelayChance',5,'',NULL,NULL,0,NULL,0,0,'entityShieldBoostLargeDelayChance',NULL,1,1,9),(960,'caldariNavyBonusMultiplier2',5,'',NULL,NULL,0,NULL,0,0,'caldariNavyBonusMultiplier2',NULL,1,1,9),(961,'caldarNavyBonus2',5,'',NULL,NULL,0,NULL,0,0,'caldarNavyBonus2',NULL,1,1,9),(962,'eliteBonusReconShip1',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusReconShip1',NULL,1,1,9),(963,'eliteBonusReconShip2',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusReconShip2',NULL,1,1,9),(964,'passiveEmDamageResonanceMultiplier',5,'',NULL,NULL,1396,NULL,1,0,'Passive EM damage resistance bonus',111,0,0,9),(965,'passiveThermalDamageResonanceMultiplier',5,'',NULL,NULL,1394,NULL,1,0,'Passive Thermal dmg resistance bonus',111,0,0,9),(966,'passiveKineticDamageResonanceMultiplier',5,'',NULL,NULL,1393,NULL,1,0,'Passive Kinetic dmg resistance bonus',111,0,0,9),(967,'passiveExplosiveDamageResonanceMultiplier',5,'',NULL,NULL,1395,NULL,1,0,'Passive Explosive dmg resistance bonus',111,0,0,9),(968,'hasStasisWeb',4,'Used for Probes.',NULL,NULL,0,NULL,0,0,'hasStasisWeb',NULL,1,1,9),(969,'activeEmDamageResonance',5,'',NULL,NULL,1396,NULL,1,0,'Active EM dmg resistance bonus',111,0,0,7),(970,'activeThermalDamageResonance',5,'',NULL,NULL,1394,NULL,1,0,'Active Thermal dmg resistance bonus',111,0,0,7),(971,'activeKineticDamageResonance',5,'',NULL,NULL,1393,NULL,1,0,'Active Kinetic dmg resistance bonus',111,0,0,7),(972,'activeExplosiveDamageResonance',5,'',NULL,NULL,1395,NULL,1,0,'Active Explosive dmg resistance bonus',111,0,0,7),(973,'signatureRadiusBonusPercent',5,'',NULL,NULL,0,NULL,0,1,'Signature radius bonus',105,0,1,7),(974,'hullEmDamageResonance',5,'',1529,NULL,0,NULL,1,1,'Hull Em Damage Resistance',108,1,1,4),(975,'hullExplosiveDamageResonance',5,'',1529,NULL,0,NULL,1,1,'Hull Explosive Damage Resistance',108,1,1,4),(976,'hullKineticDamageResonance',5,'',1529,NULL,0,NULL,1,1,'Hull Kinetic Damage Resistance',108,1,1,4),(977,'hullThermalDamageResonance',5,'',1529,NULL,0,NULL,1,1,'Hull Thermal Damage Resistance',108,1,1,4),(978,'maxGroupOnline',4,'Maximum modules of same group that can be onlined at same time, 0 = no limit, 1 = 1',NULL,NULL,0,NULL,0,0,'maxGroupOnline',NULL,1,1,9),(979,'maxJumpClones',4,'The maximum amount of jump clones that the character may have in existence or ship may have stored.',NULL,NULL,0,NULL,0,1,'Maximum Jump Clones',NULL,1,1,7),(980,'hasCloneJumpSlots',4,'The number of clone jump slots that the ship offers.',NULL,NULL,0,NULL,0,0,'hasCloneJumpSlots',NULL,1,1,9),(981,'allowsCloneJumpsWhenActive',4,'If this module is active and the ship supports it, the ship can serve as a destination for clone jumps.',NULL,NULL,0,NULL,0,0,'allowsCloneJumpsWhenActive',NULL,1,1,9),(982,'canReceiveCloneJumps',4,'Defines whether a ship has the functionality to allow it to receive clone jumps and host jump clones.',NULL,NULL,0,NULL,0,0,'canReceiveCloneJumps',NULL,1,1,9),(983,'signatureRadiusAdd',5,'',NULL,NULL,0,NULL,0,1,'Signature radius bonus',1,1,1,7),(984,'emDamageResistanceBonus',5,'',NULL,NULL,1396,NULL,0,1,'EM dmg resistance bonus',124,0,0,7),(985,'explosiveDamageResistanceBonus',5,'',NULL,NULL,1395,NULL,0,1,'Explosive dmg resistance bonus',124,0,0,7),(986,'kineticDamageResistanceBonus',5,'',NULL,NULL,1393,NULL,0,1,'Kinetic dmg resistance bonus',105,0,0,7),(987,'thermalDamageResistanceBonus',5,'',NULL,NULL,1394,NULL,0,1,'Thermal dmg resistance bonus',124,0,0,7),(988,'hardeningbonus2',5,'',NULL,NULL,0,NULL,0,0,'hardeningbonus2',NULL,1,1,9),(989,'volumePostPercent',5,'',NULL,NULL,0,NULL,0,0,'volumePostPercent',NULL,1,1,9),(990,'activeEmResistanceBonus',5,'',NULL,NULL,0,NULL,0,0,'activeEmResistanceBonus',NULL,1,1,7),(991,'activeExplosiveResistanceBonus',5,'',NULL,NULL,0,NULL,0,0,'activeExplosiveResistanceBonus',NULL,1,1,7),(992,'activeThermicResistanceBonus',5,'',NULL,NULL,0,NULL,0,0,'activeThermicResistanceBonus',NULL,1,1,7),(993,'activeKineticResistanceBonus',5,'',NULL,NULL,0,NULL,0,0,'activeKineticResistanceBonus',NULL,1,1,7),(994,'passiveEmDamageResistanceBonus',5,'',NULL,NULL,1396,NULL,0,1,'Passive EM dmg resistance bonus',105,0,0,7),(995,'passiveExplosiveDamageResistanceBonus',5,'',NULL,NULL,1395,NULL,0,1,'Passive Explosive dmg resistance bonus',105,0,0,7),(996,'passiveKineticDamageResistanceBonus',5,'',NULL,NULL,1393,NULL,0,1,'Passive kinetic dmg resistance bonus',105,0,0,7),(997,'passiveThermicDamageResistanceBonus',5,'',NULL,NULL,1394,NULL,0,1,'Passive thermal dmg resistance bonus',105,0,0,7),(998,'isRAMcompatible',3,'Can have research and manufacturing functionality',NULL,NULL,0,NULL,0,0,'Research and Manufacturing Compatible',NULL,1,1,9),(999,'eliteBonusCommandShips2',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusCommandShips2',NULL,1,1,9),(1000,'eliteBonusCommandShips1',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusCommandShips1',NULL,1,1,9),(1001,'jumpPortalConsumptionMassFactor',5,'Multiplier used to calculate amount of quantity used for jumping via portals based on mass of ship.',NULL,NULL,0,NULL,0,0,'jumpPortalConsumptionMassFactor',NULL,1,1,9),(1002,'jumpPortalDuration',4,'',NULL,NULL,0,NULL,300000,0,'Jump Portal Activation Time / Duration',101,1,1,9),(1003,'eliteBonusCommandShip1DONOTUSE',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusCommandShip1',NULL,1,1,9),(1004,'eliteBonusCommandShip2DONOTUSE',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusCommandShip2',NULL,1,1,9),(1005,'jumpPortalCapacitorNeed',5,'',NULL,NULL,1032,NULL,0,1,'Jump portal activation cost',114,1,1,7),(1006,'entityShieldBoostDelayChanceSmall',5,'',NULL,NULL,0,NULL,0,0,'entityShieldBoostDelayChanceSmall',NULL,1,1,9),(1007,'entityShieldBoostDelayChanceMedium',5,'',NULL,NULL,0,NULL,0,0,'entityShieldBoostDelayChanceMedium',NULL,1,1,9),(1008,'entityShieldBoostDelayChanceLarge',5,'',NULL,NULL,0,NULL,0,0,'entityShieldBoostDelayChanceLarge',NULL,1,1,9),(1009,'entityArmorRepairDelayChanceSmall',5,'',NULL,NULL,0,NULL,0,0,'entityArmorRepairDelayChanceSmall',NULL,1,1,9),(1010,'entityArmorRepairDelayChanceMedium',5,'',NULL,NULL,0,NULL,0,0,'entityArmorRepairDelayChanceMedium',NULL,1,1,9),(1011,'entityArmorRepairDelayChanceLarge',5,'',NULL,NULL,0,NULL,0,0,'entityArmorRepairDelayChanceLarge',NULL,1,1,9),(1012,'eliteBonusInterdictors1',5,'eliteBonusInterdictors1',NULL,NULL,0,NULL,0,0,'eliteBonusInterdictors1',NULL,1,1,9),(1013,'eliteBonusInterdictors2',5,'eliteBonusInterdictors2',NULL,NULL,0,NULL,0,0,'eliteBonusInterdictors2',NULL,1,1,9),(1014,'disallowRepeatingActivation',4,'If set, this module cannot be activated and made to autorepeat.',NULL,NULL,0,NULL,0,1,'Can Not Auto Repeat',NULL,1,1,7),(1015,'entityShieldBoostDelayChanceSmallMultiplier',5,'',NULL,NULL,0,NULL,1,0,'entityShieldBoostDelayChanceSmallMultiplier',NULL,1,1,9),(1016,'entityShieldBoostDelayChanceMediumMultiplier',5,'',NULL,NULL,0,NULL,1,0,'entityShieldBoostDelayChanceMediumMultiplier',NULL,1,1,9),(1017,'entityShieldBoostDelayChanceLargeMultiplier',5,'',NULL,NULL,0,NULL,1,0,'entityShieldBoostDelayChanceLargeMultiplier',NULL,1,1,9),(1018,'entityArmorRepairDelayChanceSmallMultiplier',5,'',NULL,NULL,0,NULL,1,0,'entityArmorRepairDelayChanceSmallMultiplier',NULL,1,1,9),(1019,'entityArmorRepairDelayChanceMediumMultiplier',5,'',NULL,NULL,0,NULL,1,0,'entityArmorRepairDelayChanceMediumMultiplier',NULL,1,1,9),(1020,'entityArmorRepairDelayChanceLargeMultiplier',5,'',NULL,NULL,0,NULL,1,0,'entityArmorRepairDelayChanceLargeMultiplier',NULL,1,1,9),(1021,'warpAccuracyMaxRange',5,'',NULL,NULL,0,NULL,15000,0,'warpAccuracyMaxRange',NULL,1,1,9),(1022,'warpAccuracyFactor',5,'',NULL,NULL,0,NULL,1,0,'warpAccuracyFactor',NULL,1,1,9),(1023,'warpAccuracyFactorMultiplier',5,'',NULL,NULL,0,NULL,1,0,'warpAccuracyFactorMultiplier',NULL,1,1,9),(1024,'warpAccuracyMaxRangeMultiplier',5,'',NULL,NULL,0,NULL,1,0,'warpAccuracyMaxRangeMultiplier',NULL,1,1,9),(1025,'warpAccuracyFactorPercentage',5,'',NULL,NULL,0,NULL,0,0,'warpAccuracyFactorPercentage',NULL,1,1,9),(1026,'warpAccuracyMaxRangePercentage',5,'',NULL,NULL,0,NULL,0,0,'warpAccuracyMaxRangePercentage',NULL,1,1,9),(1027,'scanGravimetricStrengthPercent',5,'',NULL,NULL,0,NULL,0,1,'Gravimetric Strength',105,1,1,7),(1028,'scanLadarStrengthPercent',5,'',NULL,NULL,0,NULL,0,1,'Ladar Strength',105,1,1,7),(1029,'scanMagnetometricStrengthPercent',5,'',NULL,NULL,0,NULL,0,1,'Magnetometric Strength',105,1,1,7),(1030,'scanRadarStrengthPercent',5,'',NULL,NULL,0,NULL,0,1,'Radar Strength',105,1,1,7),(1031,'controlTowerSize',3,'numeric classification for tower size\n',NULL,NULL,0,NULL,1,1,'Control Tower Size',117,1,1,7),(1032,'anchoringSecurityLevelMax',5,'The maximum security level at which the structure can be anchored.',NULL,NULL,0,NULL,1,1,'Restricted Security Level',NULL,1,1,7),(1033,'anchoringRequiresSovereignty',4,'Whether the structure requires the anchorers alliance to hold sovereignty in the system for it to be anchorable.  Only enforced if the security level is 0.4 or less.',NULL,NULL,0,NULL,0,0,'anchoringRequiresSovereignty',NULL,1,1,9),(1034,'covertOpsAndReconOpsCloakModuleDelay',5,'',NULL,NULL,0,NULL,30000,1,'covertOpsStealthBomberCloakModuleDelay',101,0,1,7),(1035,'covertOpsStealthBomberTargettingDelay',5,'',NULL,NULL,0,NULL,20000,0,'covertOpsStealthBomberTargettingDelay',101,1,1,9),(1036,'titanAmarrBonus1',5,'',NULL,NULL,0,NULL,0,0,'titanAmarrBonus1',NULL,1,1,9),(1038,'titanAmarrBonus2',5,'',NULL,NULL,0,NULL,0,0,'titanAmarrBonus2',NULL,1,1,7),(1039,'titanCaldariBonus1',5,'',NULL,NULL,0,NULL,0,0,'titanCaldariBonus1',NULL,1,1,9),(1040,'titanCaldariBonus2',5,'',NULL,NULL,0,NULL,0,0,'titanCaldariBonus2',NULL,1,1,9),(1041,'titanGallenteBonus1',5,'',NULL,NULL,0,NULL,0,0,'titanGallenteBonus1',NULL,1,1,9),(1042,'titanGallenteBonus2',5,'',NULL,NULL,0,NULL,0,0,'titanGallenteBonus2',NULL,1,1,9),(1043,'titanMinmatarBonus1',5,'',NULL,NULL,0,NULL,0,0,'titanMinmatarBonus1',NULL,1,1,9),(1044,'titanMinmatarBonus2',5,'',NULL,NULL,0,NULL,0,0,'titanMinmatarBonus2',NULL,1,1,9),(1045,'maxTractorVelocity',5,'The maximum speed that the tractor beam draws objects closer at.',NULL,NULL,0,NULL,0,1,'Max Tractor Velocity',10,1,1,7),(1047,'canNotBeTrainedOnTrial',4,'If set to 1 on a skill then this skill can not be trained on accounts that are marked as Trial.',NULL,NULL,0,NULL,0,0,'canNotBeTrainedOnTrial',NULL,1,1,9),(1048,'disallowOffensiveModifierBonus',5,'',NULL,NULL,0,NULL,0,0,'disallowOffensiveModifierBonus',NULL,1,1,9),(1049,'carrierAmarrBonus1',5,'',NULL,NULL,0,NULL,0,0,'carrierAmarrBonus1',NULL,1,1,9),(1050,'carrierAmarrBonus2',5,'',NULL,NULL,0,NULL,0,0,'carrierAmarrBonus2',NULL,1,1,9),(1051,'carrierAmarrBonus3',5,'',NULL,NULL,0,NULL,0,0,'carrierAmarrBonus3',NULL,1,1,9),(1052,'carrierCaldariBonus1',5,'',NULL,NULL,0,NULL,0,0,'carrierCaldariBonus1',NULL,1,1,9),(1053,'carrierCaldariBonus2',5,'',NULL,NULL,0,NULL,0,0,'carrierCaldariBonus2',NULL,1,1,9),(1054,'carrierCaldariBonus3',5,'',NULL,NULL,0,NULL,0,0,'carrierCaldariBonus3',NULL,1,1,9),(1055,'carrierGallenteBonus1',5,'',NULL,NULL,0,NULL,0,0,'carrierGallenteBonus1',NULL,1,1,9),(1056,'carrierGallenteBonus2',5,'',NULL,NULL,0,NULL,0,0,'carrierGallenteBonus2',NULL,1,1,9),(1057,'carrierGallenteBonus3',5,'',NULL,NULL,0,NULL,0,0,'carrierGallenteBonus3',NULL,1,1,9),(1058,'carrierMinmatarBonus1',5,'',NULL,NULL,0,NULL,0,0,'carrierMinmatarBonus1',NULL,1,1,9),(1059,'carrierMinmatarBonus2',5,'',NULL,NULL,0,NULL,0,0,'carrierMinmatarBonus2',NULL,1,1,9),(1060,'carrierMinmatarBonus3',5,'',NULL,NULL,0,NULL,0,0,'carrierMinmatarBonus3',NULL,1,1,9),(1061,'titanAmarrBonus3',5,'',NULL,NULL,0,NULL,0,0,'titanAmarrBonus3',NULL,1,1,9),(1062,'titanAmarrBonus4',5,'',NULL,NULL,0,NULL,0,0,'titanAmarrBonus4',NULL,1,1,9),(1063,'titanCaldariBonus3',5,'',NULL,NULL,0,NULL,0,0,'titanCaldariBonus3',NULL,1,1,9),(1064,'titanCaldariBonus4',5,'',NULL,NULL,0,NULL,0,0,'titanCaldariBonus4',NULL,1,1,9),(1065,'titanGallenteBonus3',5,'',NULL,NULL,0,NULL,0,0,'titanGallenteBonus3',NULL,1,1,9),(1066,'titanGallenteBonus4',5,'',NULL,NULL,0,NULL,0,0,'titanGallenteBonus4',NULL,1,1,9),(1067,'titanMinmatarBonus4',5,'',NULL,NULL,0,NULL,0,0,'titanMinmatarBonus4',NULL,1,1,9),(1068,'titanMinmatarBonus3',5,'',NULL,NULL,0,NULL,0,0,'titanMinmatarBonus3',NULL,1,1,9),(1069,'carrierAmarrBonus4',5,'',NULL,NULL,0,NULL,0,0,'carrierAmarrBonus4',NULL,1,1,9),(1070,'carrierCaldariBonus4',5,'',NULL,NULL,0,NULL,0,0,'carrierCaldariBonus4',NULL,1,1,9),(1071,'carrierGallenteBonus4',5,'',NULL,NULL,0,NULL,0,0,'carrierGallenteBonus4',NULL,1,1,9),(1072,'carrierMinmatarBonus4',5,'',NULL,NULL,0,NULL,0,0,'carrierMinmatarBonus4',NULL,1,1,9),(1073,'maxJumpClonesBonus',4,'',NULL,NULL,0,NULL,0,1,'Clone Bay Bonus',NULL,1,1,7),(1074,'disallowInEmpireSpace',4,'If set on a charge or module type, will prevent it from being activated in empire space.',NULL,NULL,0,NULL,0,0,'disallowInEmpireSpace',NULL,1,1,9),(1075,'missileNeverDoesDamage',4,'If present on a type which is used like a missile, signifies that it should never do damage (whether it has any to do or not).',NULL,NULL,0,NULL,0,0,'missileNeverDoesDamage',NULL,1,1,9),(1076,'implantBonusVelocity',5,'',NULL,NULL,1389,NULL,0,1,'Velocity Modifier',121,1,1,7),(1077,'maxDCUModules',5,'',NULL,NULL,0,NULL,0,1,'Drone Modules',NULL,1,1,10),(1079,'capacitorCapacityBonus',4,'Autogenerated skill attribute, CapacitorCapacityBonus',NULL,NULL,0,NULL,0,1,'Capacitor Modifier',105,1,1,5),(1080,'cpuPenaltySuperWeapon',5,'',NULL,NULL,0,NULL,0,0,'cpuPenaltySuperWeapon',NULL,1,1,9),(1081,'cpuBonusSuperWeapon',5,'',NULL,NULL,0,NULL,0,0,'cpuBonusSuperWeapon',NULL,1,1,9),(1082,'cpuPenaltyPercent',5,'',NULL,NULL,0,NULL,0,1,'Cpu Penalty',105,1,1,1),(1083,'armorHpBonus2',4,'',NULL,NULL,1383,NULL,0,1,'Armor Hp Bonus',121,1,1,3),(1084,'velocityBonus2',5,'',NULL,NULL,1389,NULL,0,1,'Velocity Modifier',121,1,1,7),(1085,'hasFuelCargo',4,'Module consumption mechanic uses fuel cargo. Ships that have this with value of 1 can have fuel cargo. Need fuelCargoCapacity set as well.',NULL,NULL,0,NULL,0,0,'hasFuelCargo',NULL,1,1,9),(1086,'fuelCargoCapacity',5,'Used for ships that are supposed to be able to use fuel.',NULL,NULL,0,NULL,0,1,'Fuel Cargo Capacity',NULL,1,1,7),(1087,'boosterness',4,'Whether an item is a booster or not.',NULL,NULL,0,NULL,0,1,'Booster Slot',NULL,1,1,7),(1088,'expiryTime',4,'Internally set expiry time for objects which expire, so that the client knows when.',NULL,NULL,0,NULL,0,0,'Expiry Timestamp',NULL,1,1,9),(1089,'boosterEffectChance1',5,'',NULL,NULL,0,NULL,0,1,'Chance of Side Effect',127,1,1,7),(1090,'boosterEffectChance2',5,'',NULL,NULL,0,NULL,0,0,'boosterEffectChance2',127,1,1,9),(1091,'boosterEffectChance3',5,'',NULL,NULL,0,NULL,0,0,'boosterEffectChance3',127,1,1,9),(1092,'boosterEffectChance4',5,'',NULL,NULL,0,NULL,0,0,'boosterEffectChance4',127,1,1,9),(1093,'boosterEffectChance5',5,'',NULL,NULL,0,NULL,0,0,'boosterEffectChance5',127,1,1,9),(1094,'displayCapacitorCapacityBonus',5,'',NULL,NULL,0,NULL,0,1,'Capacitor Capacity Bonus',105,1,1,5),(1095,'displayShieldBoostMultiplier',5,'',NULL,NULL,0,NULL,0,1,'Shield Boost Bonus',105,1,1,2),(1096,'displayShieldCapacityBonus',5,'',NULL,NULL,0,NULL,0,1,'Shield Capacity Bonus',105,1,1,2),(1097,'displayAoeVelocityBonus',5,'',NULL,NULL,0,NULL,0,1,'Explosion Velocity',105,1,1,7),(1098,'displayRangeSkillBonus',5,'',NULL,NULL,0,NULL,0,1,'Optimal Range Bonus',105,1,1,7),(1099,'boosterAttribute1',5,'',NULL,NULL,0,NULL,0,1,'Side Effect Penalty',105,1,1,7),(1100,'boosterAttribute2',5,'',NULL,NULL,0,NULL,0,0,'boosterAttribute2',NULL,1,1,9),(1101,'boosterAttribute3',5,'',NULL,NULL,0,NULL,0,0,'boosterAttribute3',NULL,1,1,9),(1102,'boosterAttribute4',5,'',NULL,NULL,0,NULL,0,0,'boosterAttribute4',NULL,1,1,9),(1103,'boosterAttribute5',5,'',NULL,NULL,0,NULL,0,0,'boosterAttribute5',NULL,1,1,9),(1104,'displayMaxVelocityBonus',5,'',NULL,NULL,0,NULL,0,1,'Max Velocity Bonus',105,1,1,7),(1105,'displayArmorHpBonus',5,'',NULL,NULL,0,NULL,0,1,'Armor HP Penalty',105,1,1,3),(1106,'displayMissileMaxVelocityBonus',5,'',NULL,NULL,0,NULL,0,1,'Missile Max Velocity Bonus',105,1,1,7),(1107,'displayArmorDamageAmountBonus',5,'',NULL,NULL,0,NULL,0,1,'Armor Repaired Bonus',105,1,1,3),(1108,'displayFalloffModifier',5,'',NULL,NULL,0,NULL,0,1,'falloff bonus',105,1,1,7),(1109,'displayTrackingSpeedModifier',5,'',NULL,NULL,0,NULL,0,1,'Tracking Speed bonus',105,1,1,6),(1110,'displayAoeCloudsizeModifier',5,'',NULL,NULL,0,NULL,0,1,'Explosion Cloud Bonus',105,1,1,7),(1111,'displayMaxRangeModifier',5,'',NULL,NULL,0,NULL,0,1,'Optimal Range Bonus',105,1,1,7),(1112,'inventionPropabilityMultiplier',5,'Modifies base chance of successful reverse engineering',NULL,NULL,0,NULL,0,0,'Probability Multiplier',104,1,1,9),(1113,'inventionMEModifier',5,'Modifies the mineral efficiency of invented BPCs',NULL,NULL,0,NULL,0,0,'ME Modifier',120,1,1,9),(1114,'inventionPEModifier',5,'Modifies the production efficiency of reverse engineered BPCS',NULL,NULL,0,NULL,0,0,'PE Modifier',NULL,1,1,9),(1115,'decryptorID',12,'Used to show usable decryptors when starting reverse engineering based on data interface',NULL,NULL,0,NULL,0,0,'decryptorID',NULL,1,1,9),(1116,'scanProbeStrength',5,'The strength of the probe.',NULL,NULL,0,NULL,0,1,'scanProbeStrength',NULL,1,1,7),(1117,'scanStrengthSignatures',5,'',NULL,NULL,0,NULL,0,1,'scanStrengthSignatures',NULL,1,1,7),(1118,'scanStrengthDronesProbes',5,'',NULL,NULL,0,NULL,0,1,'scanStrengthDronesProbes',NULL,1,1,7),(1119,'scanStrengthScrap',5,'',NULL,NULL,0,NULL,0,1,'scanStrengthScrap',NULL,1,1,7),(1120,'scanStrengthShips',5,'',NULL,NULL,0,NULL,0,1,'scanStrengthShips',NULL,1,1,7),(1121,'scanStrengthStructures',5,'',NULL,NULL,0,NULL,0,1,'scanStrengthStructures',NULL,1,1,7),(1122,'maxScanGroups',4,'Max groups that a character can scan for with probes. Default is 0 and max groups will be 5 with a single skill adding 1 per skill level.',NULL,NULL,0,NULL,0,0,'maxScanGroups',NULL,1,1,9),(1123,'scanDuration',4,'How long this probe has to scan until it can obtain results.',NULL,NULL,0,NULL,60000,1,'scanDuration',101,1,1,7),(1124,'inventionMaxRunModifier',5,'Modifies the max runs in a blueprint created through invention',NULL,NULL,0,NULL,0,0,'Max Run Modifier',NULL,1,1,9),(1125,'boosterChanceBonus',5,'',NULL,NULL,0,NULL,0,1,'Negative Side Effect Chance Bonus',105,1,1,7),(1126,'boosterAttributeModifier',5,'',NULL,NULL,0,NULL,0,1,'Side effect Modifier',105,1,1,7),(1127,'interfaceID',11,'Links blueprints to the data interface required to reverse engineer it',NULL,NULL,0,NULL,0,0,'InterfaceID',NULL,1,1,9),(1128,'datacore1ID',11,'Datacore required to reverse engineer this blueprint',NULL,NULL,0,NULL,0,0,'datacore1ID',NULL,1,1,9),(1129,'datacore2ID',11,'Datacore required to reverse engineer this blueprint',NULL,NULL,0,NULL,0,1,'datacore2ID',NULL,1,1,7),(1130,'ecmStrengthBonusPercent',5,'',NULL,NULL,0,NULL,0,1,'Jam Strength Bonus',105,1,1,7),(1131,'massBonusPercentage',5,'',NULL,NULL,409,NULL,0,1,'Mass Reduction',105,1,1,7),(1132,'upgradeCapacity',5,'Attribute on ships used for ship upgrades',NULL,NULL,0,NULL,0,1,'Calibration',120,1,1,7),(1133,'entityMaxVelocitySignatureRadiusMultiplier',5,'Used to increase signature radius of entity when it activates Max Velocity. Used to fake MWD sig radius increase.',NULL,NULL,0,NULL,6,0,'entityMaxVelocitySignatureRadiusMultiplier',NULL,1,1,9),(1134,'maxTargetRangeMultiplierSet',5,'',NULL,NULL,0,NULL,0,0,'maxTargetRangeMultiplierSet',NULL,1,1,9),(1135,'scanResolutionMultiplierSet',5,'',NULL,NULL,0,NULL,0,0,'scanResolutionMultiplierSet',NULL,1,1,9),(1136,'scanAllStrength',5,'Helper attribute for distribution dungeons.',NULL,NULL,0,NULL,0,0,'scanAllStrength',120,1,1,9),(1137,'rigSlots',4,'The number of rig slots on the ship.',NULL,NULL,3266,NULL,0,1,'Rig Slots',122,1,1,1),(1138,'drawback',5,'used on rigs',NULL,NULL,0,NULL,10,1,'Drawback',105,1,1,7),(1139,'rigDrawbackBonus',5,'',NULL,NULL,0,NULL,10,1,'Rig Drawback Reduction',105,1,1,7),(1141,'boosterArmorHPPenalty',5,'',NULL,NULL,0,NULL,0,1,'Armor Hitpoint Penalty',105,1,1,7),(1142,'boosterArmorRepairAmountPenalty',5,'',NULL,NULL,0,NULL,0,1,'Armor Repair Amount Penalty',105,1,1,7),(1143,'boosterShieldCapacityPenalty',5,'',NULL,NULL,0,NULL,0,1,'Shield Capacity Penalty',105,1,1,7),(1144,'boosterTurretOptimalRange',5,'',NULL,NULL,0,NULL,0,1,'Turret Optimal Range Penalty',105,1,1,7),(1145,'boosterTurretTrackingPenalty',3,'',NULL,NULL,0,NULL,0,1,'Turret Tracking Penalty',105,1,1,7),(1146,'boosterTurretFalloffPenalty',5,'',NULL,NULL,0,NULL,0,1,'Turret Falloff Penalty',105,1,1,7),(1147,'boosterAOEVelocityPenalty',5,'',NULL,NULL,0,NULL,0,1,'Explosion Velocity Penalty',105,1,1,7),(1148,'boosterMissileVelocityPenalty',5,'',NULL,NULL,0,NULL,0,1,'Missile Velocity Penalty',105,1,1,7),(1149,'boosterMissileAOECloudPenalty',5,'',NULL,NULL,0,NULL,0,1,'Missile Explosion Cloud Penalty',105,1,1,7),(1150,'boosterCapacitorCapacityPenalty',3,'',NULL,NULL,0,NULL,0,1,'Capacitor Capacity Penalty',105,1,1,7),(1151,'boosterMaxVelocityPenalty',5,'',NULL,NULL,0,NULL,0,1,'Velocity Penalty',105,1,1,7),(1152,'upgradeLoad',5,'How much the upgrades installed on this ship are using of its upgrade capacity.',NULL,NULL,0,NULL,0,1,'upgradeLoad',NULL,1,1,7),(1153,'upgradeCost',5,'How much of the upgrade capacity is used when this is fitted to a ship.',NULL,NULL,0,NULL,0,1,'Calibration cost',NULL,1,1,1),(1154,'upgradeSlotsLeft',4,'How many upgrades can by fitted to this ship.',NULL,NULL,3266,NULL,0,1,'Upgrade Hardpoints',NULL,1,1,7),(1155,'researchPointCost',4,'How much the datacore costs in RPs when being bought from research agents',NULL,NULL,0,NULL,0,1,'RP Cost',120,1,1,7),(1156,'maxScanDeviationModifier',5,'',NULL,NULL,0,NULL,0,1,'Maximum Scan Deviation Modifier',105,1,1,7),(1157,'commandBonus2',5,'',NULL,NULL,0,NULL,0,0,'commandBonus2',NULL,1,1,9),(1158,'untargetable',3,'Attribute to disallow targetting.',NULL,NULL,0,NULL,0,1,'Untargetable',NULL,1,1,7),(1159,'armorHPBonusAdd',5,'',NULL,NULL,0,NULL,0,1,'Armor Hp Bonus',113,1,1,3),(1160,'accessDifficultyBonusModifier',5,'',NULL,NULL,0,NULL,0,1,'Access Difficulty Bonus Modifier',105,1,1,7),(1161,'scanFrequencyResult',4,'Used for the scan frequency probe to give results on scan strength types instead of location. 0 = false, 1 = true',NULL,NULL,0,NULL,0,0,'scanFrequencyResult',NULL,1,1,9),(1162,'explosionDelayWreck',4,'The amount of milliseconds before the wreck dissapears. Note: this only applies to NPC wrecks or empty player wrecks.',NULL,NULL,0,NULL,7200000,0,'explosionDelayWreck',NULL,1,1,9),(1163,'canCloak',4,'',NULL,NULL,0,NULL,1,0,'canCloak',NULL,1,1,9),(1164,'speedFactorBonus',5,'Afterburner and Microwarpdrive Max Velocity Bonus',NULL,NULL,1389,NULL,0,1,'Afterburner and Microwarpdrive Max Velocity Bonus',105,1,1,7),(1165,'controlTowerMinimumDistance',4,'Minimum distance where a starbase structure can be anchored at from the control tower shield extremity in meters.',NULL,1391,0,NULL,0,1,'Minimum Anchoring Distance From Starbase Shield',1,1,1,7),(1167,'posPlayerControlStructure',4,'If a starbase structure has this attribute = 1 then it can be controlled by owners with infrastructure tactical officer skill and corp role.',NULL,NULL,413,NULL,0,1,'Player Controllable',NULL,1,1,7),(1168,'isIncapacitated',0,'Whether an object is incapacitated or not. Boolean.',NULL,NULL,NULL,NULL,0,0,'isIncapacitated',NULL,1,1,9),(1169,'scanGenericStrength',5,'Sensor strength all types',NULL,NULL,0,NULL,0,1,'Generic Sensor Strength',120,0,1,7),(1170,'structureArmorRepairAmount',4,'Amount of armor healed by structure repair effects',NULL,NULL,0,NULL,0,1,'Armor Repair Amount',NULL,1,1,7),(1171,'structureShieldRepairAmount',4,'Amount of shield healed by structure repair effects',NULL,NULL,0,NULL,0,1,'Shield Repair Amount',NULL,1,1,7),(1172,'structureArmorBoostValue',4,'Value modified by remote starbase structure repair effects (should be 0 unless the structure repairs itself)',NULL,NULL,0,NULL,0,0,'Armor Boost Value',NULL,1,1,7),(1173,'structureShieldBoostValue',4,'Value modified by remote starbase structure repair effects (should be 0 unless the structure repairs itself)',NULL,NULL,0,NULL,0,0,'Shield Boost Value',NULL,1,1,9),(1174,'posStructureControlAmount',4,'How many starbase structures a character control.',NULL,NULL,0,NULL,0,1,'posStructureControlAmount',NULL,1,1,7),(1175,'heatHi',5,'',NULL,NULL,0,NULL,0,1,'heatHi',NULL,1,1,7),(1176,'heatMed',5,'',NULL,NULL,0,NULL,0,1,'heatMed',NULL,1,1,7),(1177,'heatLow',5,'',NULL,NULL,0,NULL,0,1,'heatLow',NULL,1,1,7),(1178,'heatCapacityHi',5,'',NULL,NULL,0,NULL,0,0,'heatCapacityHi',NULL,1,1,9),(1179,'heatDissipationRateHi',5,'',NULL,NULL,0,NULL,0,0,'heatDissipationRate',NULL,1,1,9),(1180,'heatAbsorbtionRateModifier',5,'',NULL,NULL,0,NULL,0,0,'heatDissipationRateModifier',NULL,1,1,9),(1181,'overloadDurationBonus',5,'',NULL,NULL,1386,NULL,0,1,'Overload Duration Modifier',105,1,1,7),(1182,'heatAbsorbtionRateHi',5,'',NULL,NULL,0,NULL,0,0,'heatAbsorbtionRateHi',NULL,1,1,9),(1183,'heatAbsorbtionRateMed',5,'',NULL,NULL,0,NULL,0,0,'heatAbsorbtionRateMed',NULL,1,1,9),(1184,'heatAbsorbtionRateLow',5,'',NULL,NULL,0,NULL,0,0,'heatAbsorbtionRateLow',NULL,1,1,9),(1185,'onliningRequiresSovereigntyLevel',4,'Whether the structure requires the onliner\'s alliance to hold sovereignty in the system for it to be onlineable.',NULL,NULL,0,NULL,0,1,'Required Sovereignty Level',NULL,1,1,7),(1186,'remoteArmorDamageAmountBonus',5,'Bonus attribute for remote armor repair amount.',NULL,NULL,80,NULL,0,1,'Remote Armor Repair Bonus',105,1,1,7),(1187,'remoteArmorDamageDurationBonus',5,'Bonus attribute for remote armor repair duration.',NULL,NULL,1392,NULL,0,1,'Remote Armor Repair Duration Bonus',105,1,1,7),(1188,'shieldTransportDurationBonus',5,'Bonus attribute for shield transport duration.',NULL,NULL,1392,NULL,0,1,'Shield Transport Duration Bonus',105,1,1,2),(1189,'shieldTransportAmountBonus',5,'Bonus attribute for shield transport amount.',NULL,NULL,2104,NULL,0,1,'Shield Transport Amount Bonus',105,1,1,2),(1190,'ewCapacitorNeedBonus',5,'Bonus attribute for capacitor need of EW and propulsion jamming.',NULL,NULL,1400,NULL,0,1,'EW Capacitor Need Bonus',105,1,1,7),(1191,'maxDronePercentageBonus',5,'',NULL,NULL,0,NULL,0,1,'Max Active Drone Modifier',105,1,1,7),(1192,'triageCpuNeedBonus',5,'Bonus for CPU requirement of Triage Modules.',NULL,NULL,0,NULL,0,1,'Triage CPU Need Bonus',105,1,1,7),(1193,'projECMDurationBonus',5,'Bonus to duration of modules requiring projected ECM.',NULL,NULL,0,NULL,0,1,'Projected ECM Duration Bonus',105,1,1,7),(1194,'projECMCpuNeedBonus',5,'Bonus for CPU requirement of projected electronic counter measures.',NULL,NULL,0,NULL,0,1,'Projected ECM CPU Need Bonus',105,1,1,7),(1195,'posAnchoredPerSolarSystemAmount',4,'How many structures in this group can be anchored for the same alliance per solar system.  0 means there is no limit.',NULL,NULL,0,NULL,0,1,'Max anchoring amount per solar system',NULL,1,1,7),(1196,'heatDissipationRateMed',5,'',NULL,NULL,0,NULL,0,0,'heatDissipationRateHi',NULL,1,1,9),(1198,'heatDissipationRateLow',5,'',NULL,NULL,0,NULL,0,0,'heatDissipationRateLow',NULL,1,1,9),(1199,'heatCapacityMed',5,'',NULL,NULL,0,NULL,0,0,'heatCapacityMed',NULL,1,1,9),(1200,'heatCapacityLow',5,'',NULL,NULL,0,NULL,0,0,'heatCapacityLow',NULL,1,1,9),(1201,'remoteHullDamageAmountBonus',5,'Bonus attribute for remote hull repair amount.',NULL,NULL,80,NULL,0,1,'Remote Hull Repair Bonus',105,1,1,7),(1202,'remoteHullDamageDurationBonus',5,'Bonus attribute for remote hull repair duration.',NULL,NULL,1392,NULL,0,1,'Remote Hull Repair Duration Bonus',105,1,1,7),(1203,'powerTransferAmountBonus',5,'Bonus attribute for energy transfer amount.',NULL,NULL,1033,NULL,0,1,'Energy Transfer Bonus',105,1,1,7),(1204,'powerTransferDurationBonus',5,'Bonus attribute for energy transfer duration.',NULL,NULL,1392,NULL,0,1,'Energy Transfer Duration Bonus',105,1,1,7),(1205,'overloadRofBonus',5,'',NULL,NULL,1386,NULL,0,1,'Overload rate of fire bonus',105,1,1,7),(1206,'overloadSelfDurationBonus',5,'',NULL,NULL,1386,NULL,0,1,'Overload duration bonus',105,1,1,7),(1207,'isGlobal',4,'',NULL,NULL,0,NULL,0,0,'isGlobal',NULL,1,1,9),(1208,'overloadHardeningBonus',5,'',NULL,NULL,1386,NULL,0,1,'Overload hardening bonus',105,1,1,7),(1209,'bombDeploymentCpuNeedMultiplier',5,'Multiplier to CPU need of modules requireing Bomb Deployment',NULL,NULL,0,NULL,0,1,'Bomb Deployment CPU Bonus',104,1,1,7),(1210,'overloadDamageModifier',5,'',NULL,NULL,1386,NULL,0,1,'Overload damage bonus',105,1,1,7),(1211,'heatDamage',5,'',NULL,NULL,1386,NULL,0,1,'Heat Damage',113,1,1,7),(1212,'requiredThermoDynamicsSkill',4,'',NULL,NULL,0,NULL,0,1,'Required Thermodynamics Level',NULL,1,1,7),(1213,'heatDamageBonus',5,'',NULL,NULL,1386,NULL,0,1,'Heat damage penalty',105,1,1,7),(1214,'posStructureControlDistanceMax',5,'The maximum distance from the control tower, at which structures can be controlled.',NULL,NULL,0,NULL,15000,1,'Maximum Control Distance',1,1,1,7),(1215,'anchoringRequiresSovereigntyLevel',5,'The sovereignty level required for anchoring',NULL,NULL,0,NULL,0,1,'Required Sovereignty Level',NULL,1,1,7),(1216,'shieldTransportCpuNeedBonus',5,'Reduction of CPU need of shield transporters.',NULL,NULL,0,NULL,0,1,'Shield Transport Cpu Need Bonus',105,1,1,2),(1217,'remoteArmorPowerNeedBonus',5,'Reduction of power grid needs of remote armor repair systems.',NULL,NULL,0,NULL,0,1,'Remote Armor Repair Power Need Bonus',105,1,1,7),(1218,'powerTransferPowerNeedBonus',5,'Reduction of power grid needs of energy transfer arrays',NULL,NULL,0,NULL,0,1,'Energy Transfer Array Power Need',105,1,1,7),(1219,'droneArmorDamageAmountBonus',5,'Bonus to drone armor repair amount',NULL,NULL,0,NULL,0,1,'Drone Armor Damage Amount Bonus',105,1,1,10),(1220,'droneShieldBonusBonus',5,'Bonus to drone shield transport amount',NULL,NULL,0,NULL,0,1,'Drone Shield Transport Amount Bonus',105,1,1,10),(1221,'jumpDelayDuration',4,'Delay in seconds; until you can jump again.',NULL,NULL,0,NULL,0,1,'Jump Delay Duration',123,1,1,7),(1222,'overloadRangeBonus',5,'',NULL,NULL,1386,NULL,0,1,'Overload optimal range bonus',105,1,1,7),(1223,'overloadSpeedFactorBonus',5,'',NULL,NULL,1386,NULL,0,1,'Overload Speed Bonus',105,1,1,7),(1224,'heatGenerationMultiplier',5,'',NULL,NULL,0,NULL,1,0,'heatGenerationMultiplier',NULL,1,1,9),(1225,'overloadECMStrengthBonus',5,'',NULL,NULL,1386,NULL,0,1,'Overload ECM Bonus',105,1,1,7),(1226,'overloadECCMStrenghtBonus',5,'',NULL,NULL,1386,NULL,0,1,'Overload ECCM Bonus',105,1,1,7),(1227,'signatureRadiusBonusBonus',5,'Bonus to signatureRadiusBonus',NULL,NULL,1390,NULL,0,1,'Modification of Signature Radius Bonus',105,1,1,7),(1228,'signatureRadiusMultiplierMultiplier',5,'Multiplier affecting signatureRadiusMultiplier',NULL,NULL,0,NULL,0,1,'Signature Radius Multiplier',105,1,1,7),(1229,'thermodynamicsHeatDamage',5,'',NULL,NULL,1386,NULL,0,1,'Heat damage modifier',105,1,1,7),(1230,'overloadArmorDamageAmount',5,'',NULL,NULL,1386,NULL,0,1,'Overload Repair Bonus',105,1,1,7),(1231,'overloadShieldBonus',5,'',NULL,NULL,1386,NULL,0,1,'Overload Shield Boost Bonus',105,1,1,7),(1232,'leechBalanceFactor',5,'',NULL,NULL,0,NULL,1,1,'leechBalanceFactor',NULL,1,1,7),(1233,'capacitySecondary',5,'Secondary cargo space allowed, meant to supplement capacity',NULL,NULL,0,NULL,10000,1,'capacity2',9,1,1,4),(1234,'surveyScannerRangeBonus',5,'Survey Scanner Range Bonus',NULL,NULL,0,NULL,0,1,'surveyScannerRangeBonus',105,1,1,7),(1235,'cargoScannerRangeBonus',5,'Cargo Scanner Range Bonus',NULL,NULL,0,NULL,0,1,'cargoScannerRangeBonus',105,1,1,9),(1236,'commandBonusEffective',5,'commandBonusEffective',NULL,NULL,0,NULL,0,1,'commandBonusEffective',105,1,1,7),(1237,'commandBonusAdd',5,'commandBonusAdd',NULL,NULL,0,NULL,0,1,'commandBonusAdd',NULL,1,1,7),(1238,'commandBonusEffectiveAdd',5,'commandBonusEffectiveAdd',NULL,NULL,0,NULL,0,0,'commandBonusEffectiveAdd',NULL,1,1,9),(1239,'shipBonusORECapital1',5,'shipBonusORECapital1',NULL,NULL,0,NULL,0,1,'shipBonusORECapital1',NULL,1,1,9),(1240,'shipBonusORECapital2',5,'shipBonusORECapital2',NULL,NULL,0,NULL,0,1,'shipBonusORECapital2',NULL,1,1,7),(1241,'1239',4,'Autogenerated skill attribute, 1239',NULL,NULL,0,NULL,0,1,'1239',NULL,1,1,9),(1243,'shipBonusORECapital3',5,'shipBonusORECapital3',NULL,NULL,0,NULL,0,1,'shipBonusORECapital3',NULL,1,1,7),(1244,'shipBonusORECapital4',5,'shipBonusORECapital4',NULL,NULL,0,NULL,0,1,'shipBonusORECapital4',NULL,1,1,7),(1245,'disallowActivateOnWarp',4,'Stops the module from being activated if the ship is aligning to warp.',NULL,NULL,0,NULL,0,1,'Disallow Activation In Warp',NULL,1,1,7),(1246,'eliteBonusHeavyInterdictors1',5,'eliteBonusHeavyInterdictors1',NULL,NULL,0,NULL,0,1,'eliteBonusHeavyInterdictors1',NULL,1,1,7),(1247,'eliteBonusHeavyInterdictors2',5,'eliteBonusHeavyInterdictors2',NULL,NULL,0,NULL,0,1,'eliteBonusHeavyInterdictors2',NULL,1,1,7),(1248,'1246',4,'Autogenerated skill attribute, 1246',NULL,NULL,0,NULL,0,1,'1246',NULL,1,1,9),(1249,'eliteBonusElectronicAttackShip1',5,'eliteBonusElectronicAttackShip1',NULL,NULL,0,NULL,0,1,'eliteBonusElectronicAttackShip1',NULL,1,1,7),(1250,'eliteBonusElectronicAttackShip2',5,'eliteBonusElectronicAttackShip2',NULL,NULL,0,NULL,0,1,'eliteBonusElectronicAttackShip2',NULL,1,1,7),(1251,'securityClearance',5,'Security Clearance Level',NULL,NULL,0,NULL,0,1,'securityClearance',NULL,1,1,7),(1252,'isCovert',5,'',NULL,NULL,0,NULL,0,1,'isCovert',NULL,1,1,7),(1253,'jumpHarmonics',5,'',NULL,NULL,0,NULL,0,1,'Jump Harmonics',NULL,1,1,7),(1254,'canNotUseStargates',4,'',NULL,NULL,0,NULL,0,1,'cantUseStargates',NULL,1,1,7),(1255,'droneDamageBonus',5,'droneDamageBonus',NULL,NULL,0,NULL,0,1,'droneDamageBonus',105,1,1,10),(1256,'droneHPBonus',5,'droneHPBonus',NULL,NULL,0,NULL,0,1,'droneHPBonus',105,1,1,10),(1257,'eliteBonusBlackOps1',5,'eliteBonusBlackOps1',NULL,NULL,0,NULL,0,1,'eliteBonusBlackOps1',NULL,1,1,7),(1258,'eliteBonusBlackOps2',5,'eliteBonusBlackOps2',NULL,NULL,0,NULL,0,1,'eliteBonusBlackOps2',NULL,1,1,7),(1259,'heatAttenuationHi',5,'',NULL,NULL,0,NULL,1,1,'heatAttenuation',NULL,1,1,7),(1261,'heatAttenuationMed',5,'',NULL,NULL,0,NULL,1,1,'heatAttenuationMed',NULL,1,1,7),(1262,'heatAttenuationLow',5,'',NULL,NULL,0,NULL,1,1,'heatAttenuationMed',NULL,1,1,7),(1263,'towerHPOnlineMutator',5,'',NULL,NULL,0,NULL,0,1,'towerHPOnlineMutator',127,1,1,7),(1264,'brokenRepairCostMultiplier',5,'',NULL,NULL,0,NULL,10,0,'brokenRepairCostMultiplier',NULL,1,1,9),(1265,'eliteBonusViolators1',5,'',NULL,NULL,0,NULL,0,1,'eliteBonusViolators1',NULL,1,1,9),(1266,'eliteBonusViolators2',5,'',NULL,NULL,0,NULL,0,1,'eliteBonusViolators2',NULL,1,1,9),(1267,'moduleRepairRate',5,'dictates how many hitpoints you can repair per minute',NULL,NULL,0,NULL,10,1,'moduleRepairRate',NULL,1,1,7),(1268,'eliteBonusViolatorsRole1',5,'',NULL,NULL,0,NULL,0,1,'eliteBonusViolatorsRole1',NULL,1,1,9),(1269,'eliteBonusViolatorsRole2',5,'eliteBonusViolatorsRole2',NULL,NULL,0,NULL,0,1,'eliteBonusViolatorsRole2',NULL,1,1,9),(1270,'speedBoostFactorBonus',5,'Afterburner and Microwarpdrive Thrust Bonus',NULL,NULL,96,NULL,0,1,'Afterburner and Microwarpdrive Thrust Bonus',105,1,1,7),(1271,'droneBandwidth',5,'',NULL,NULL,2987,NULL,0,1,'Drone Bandwidth',128,1,1,10),(1272,'droneBandwidthUsed',5,'',NULL,NULL,2987,NULL,0,1,'Bandwidth Needed',128,1,1,10),(1273,'droneBandwidthLoad',5,'',NULL,NULL,0,NULL,0,1,'droneBandwidthLoad',NULL,1,1,10),(1274,'miningTargetMultiplier',5,'',NULL,NULL,0,NULL,0,1,'Assisted Mining Bonus',111,1,1,7),(1275,'droneIsAgressive',3,'',NULL,NULL,0,NULL,1,1,'droneIsAgressive',NULL,1,1,10),(1276,'nonBrokenModuleRepairCostMultiplier',5,'',NULL,NULL,0,NULL,5,0,'nonBrokenModuleRepairCostMultiplier',NULL,1,1,9),(1277,'shipBrokenModuleRepairCostMultiplier',5,'',NULL,NULL,0,NULL,0.5,1,'shipBrokenModuleRepairCostMultiplier',NULL,1,1,7),(1278,'droneIsChaotic',5,'',NULL,NULL,0,NULL,0,0,'droneIsChaotic',NULL,1,1,10),(1279,'eliteBonusViolatorsRole3',5,'eliteBonusViolatorsRole3',NULL,NULL,0,NULL,0,1,'eliteBonusViolatorsRole3',NULL,1,1,9),(1280,'eliteBonusInterceptorRole',5,'',NULL,NULL,0,NULL,0,0,'eliteBonusInterceptorRole',NULL,1,1,9),(1281,'baseWarpSpeed',5,'Just for the UI to display the ship warp speed.',NULL,NULL,3759,NULL,0,1,'Ship Warp Speed',NULL,1,1,7),(1282,'implantSetThukker',5,'Nomad set bonus attribute',NULL,NULL,0,NULL,1,1,'Nomad Set Bonus',104,1,1,7),(1283,'fightersAttackAndFollow',5,'',NULL,NULL,0,NULL,1,1,'fightersAttackAndFollow',NULL,1,1,7),(1284,'implantSetSisters',5,'Virtue set bonus attribute',NULL,NULL,0,NULL,1,1,'Virtue Set Bonus',104,1,1,7),(1285,'requiredSkill4',11,'The type ID of the skill that is required.',NULL,NULL,0,NULL,0,1,'Quaternary Skill required',116,1,1,8),(1286,'requiredSkill4Level',4,'Required skill level for skill 4',NULL,NULL,0,NULL,0,1,'requiredSkill5Level',NULL,1,1,8),(1287,'requiredSkill5Level',4,'Required skill level for skill 5',NULL,NULL,0,NULL,0,1,'requiredSkill5Level',NULL,1,1,8),(1288,'requiredSkill6Level',4,'Required skill level for skill 6',NULL,NULL,0,NULL,0,1,'requiredSkill6Level',NULL,1,1,8),(1289,'requiredSkill5',11,'The type ID of the skill that is required.',NULL,NULL,0,NULL,0,1,'Quinary Skill required',116,1,1,8),(1290,'requiredSkill6',11,'The type ID of the skill that is required.',NULL,NULL,0,NULL,0,1,'Senary Skill required',116,1,1,8),(1291,'implantSetSyndicate',5,'Edge set bonus attribute',NULL,NULL,0,NULL,1,1,'Edge Set Bonus',104,1,1,7),(1292,'implantSetORE',5,'Harvest set bonus attribute',NULL,NULL,0,NULL,1,1,'Harvest Set Bonus',104,1,1,7),(1293,'implantSetMordus',5,'Centurion set bonus attribute',NULL,NULL,0,NULL,1,1,'Centurion Set Bonus',104,1,1,7),(1294,'shipBrokenRepairCostMultiplierBonus',5,'',NULL,NULL,0,NULL,0,1,'Module Repair Rate Bonus',121,1,1,7),(1295,'moduleRepairRateBonus',5,'',NULL,NULL,0,NULL,0,1,'Module Repair Rate Bonus',105,1,1,7),(1296,'consumptionQuantityBonusPercentage',5,'',NULL,NULL,0,NULL,0,1,'Consumption Quantity Bonus',105,1,1,7),(1297,'droneFocusFire',5,'',NULL,NULL,0,NULL,0,1,'droneFocusFire',NULL,1,1,10),(1298,'canFitShipGroup1',12,'',NULL,NULL,0,NULL,0,1,'Can be fitted to',115,1,1,1),(1299,'canFitShipGroup2',12,'',NULL,NULL,0,NULL,0,1,'Can be fitted to',115,1,1,1),(1300,'canFitShipGroup3',12,'',NULL,NULL,0,NULL,0,1,'Can be fitted to',115,1,1,1),(1301,'canFitShipGroup4',12,'',NULL,NULL,0,NULL,0,1,'Can be fitted to',115,1,1,1),(1302,'canFitShipType1',11,'',NULL,NULL,0,NULL,0,1,'Can be fitted to',116,1,1,1),(1303,'canFitShipType2',11,'',NULL,NULL,0,NULL,0,1,'Can be fitted to',116,1,1,1),(1304,'canFitShipType3',11,'',NULL,NULL,0,NULL,0,1,'Can be fitted to',116,1,1,1),(1305,'canFitShipType4',11,'',NULL,NULL,0,NULL,0,1,'Can be fitted to',116,1,1,1),(1306,'maxRangeMultiplierBonusAdditive',5,'Additive bonus to maxRangeMultiplier',NULL,NULL,0,NULL,0,1,'Max Range Multiplier Bonus',104,1,1,7),(1307,'trackingSpeedMultiplierBonusAdditive',5,'Additive bonus to trackingSpeedMultiplier',NULL,NULL,0,NULL,0,1,'Tracking Speed Multiplier Bonus',104,1,1,7),(1308,'maxTargetRangeMultiplierBonusAdditive',5,'Additive bonus to maxTargetRangeMultiplier',NULL,NULL,0,NULL,0,1,'Max Targeting Range Bonus',104,1,1,6),(1309,'scanResolutionMultiplierBonusAdditive',5,'Additive bonus to scanResolutionMultiplier',NULL,NULL,0,NULL,0,1,'Scan Resolution Bonus',104,1,1,7),(1310,'commandBonusHidden',5,'commandBonusHidden',NULL,NULL,0,NULL,0,0,'Command Bonus Hidden',105,1,1,9),(1311,'eliteBonusJumpFreighter1',5,'eliteBonusJumpFreighter1',NULL,NULL,0,NULL,0,1,'eliteBonusJumpFreighter1',NULL,1,1,9),(1312,'eliteBonusJumpFreighter2',5,'eliteBonusJumpFreighter2',NULL,NULL,0,NULL,0,1,'eliteBonusJumpFreighter2',NULL,1,1,9),(1313,'maxTargetRangeBonusBonus',5,'Bonus to maxTargetRangeBonus',NULL,NULL,1391,NULL,0,1,'Modification of Max Targeting Range Bonus',105,1,1,6),(1314,'scanResolutionBonusBonus',5,'Bonus to scanResolutionBonus',NULL,NULL,74,NULL,0,1,'Modification of Scan Resolution Bonus',105,1,1,7),(1315,'maxRangeBonusBonus',5,'Bonus to maxRangeBonus',NULL,NULL,1391,NULL,0,1,'Modification of Optimal Range Bonus',105,1,1,6),(1316,'trackingSpeedBonusBonus',5,'Bonus to trackingSpeedBonus',NULL,NULL,1398,NULL,0,1,'Modification of Tracking Speed Bonus',105,1,1,7),(1317,'maxRangeHidden',5,'maxRangeHidden',NULL,NULL,0,NULL,0,0,'maxRangeHidden',1,1,1,9),(1318,'warpScrambleStrengthHidden',5,'warpScrambleStrengthHidden',NULL,NULL,0,NULL,0,0,'warpScrambleStrengthHidden',NULL,1,1,9),(1319,'capacitorNeedHidden',5,'capacitorNeedHidden',NULL,NULL,0,NULL,0,0,'capacitorNeedHidden',NULL,1,1,9),(1320,'commandBonusECM',5,'',NULL,NULL,0,NULL,0,1,'ECM Command Bonus',105,1,1,7),(1321,'commandBonusRSD',5,'Remote Sensor Dampening Command Bonus',NULL,NULL,0,NULL,0,1,'Remote Sensor Dampening Command Bonus',105,1,1,7),(1322,'commandBonusTD',5,'Tracking Disruption Command Bonus',NULL,NULL,0,NULL,0,1,'Tracking Disruption Command Bonus',105,1,1,7),(1323,'commandBonusTP',5,'Target Painting Command Bonus',NULL,NULL,0,NULL,0,1,'Target Painting Command Bonus',105,1,1,7),(1324,'massBonusPercentageBonus',5,'Bonus to massBonusPercentage',NULL,NULL,409,NULL,0,1,'Modification of Mass Reduction',105,1,1,7),(1325,'speedBoostFactorBonusBonus',5,'Modification of Afterburner and Microwarpdrive Thrust Bonus',NULL,NULL,96,NULL,0,1,'Modification of Afterburner and Microwarpdrive Thrust Bonus',105,1,1,7),(1326,'speedFactorBonusBonus',5,'Modification of Afterburner and Microwarpdrive Max Velocity Bonus',NULL,NULL,1389,NULL,0,1,'Modification of Afterburner and Microwarpdrive Max Velocity Bonus',105,1,1,7),(1327,'warpScrambleRangeBonus',5,'Warp Scramble Range Bonus',NULL,NULL,1391,NULL,0,1,'Warp Scramble Range Bonus',105,1,1,7),(1328,'droneBandwidthMultiplier',5,'Multiplier on droneBandwidth. The default value should be 0 to ensure that CONCORD NPCs can set the bandwidth of a target ship to 0.',NULL,NULL,2987,NULL,0,1,'droneBandwidthMultiplier',104,1,1,10),(1329,'droneBandwidthBonusAdd',5,'Drone Bandwidth Bonus (additive)',NULL,NULL,0,NULL,0,1,'Drone Bandwidth Bonus',128,1,1,10),(1330,'isHacking',4,'',NULL,NULL,0,NULL,0,0,'isHacking',NULL,1,1,9),(1331,'isArcheology',4,'',NULL,NULL,0,NULL,0,0,'isArcheology',NULL,1,1,9),(1332,'falloffBonusBonus',5,'',NULL,NULL,NULL,NULL,1399,1,'Modification of Falloff Bonus',105,1,1,7),(1333,'maxVelocityLimited',4,'',NULL,NULL,NULL,NULL,0,0,'maxVelocityLimited',NULL,1,1,9),(1334,'maxVelocityActivationLimit',5,'',NULL,NULL,NULL,NULL,0,1,'Max Velocity Limitation',10,1,1,7),(1335,'defenderRaceID',5,'',NULL,NULL,NULL,NULL,0,1,'defenderRaceID',NULL,1,1,9),(1336,'jumpClonesLeft',4,'The remaining number of unused clone vats on the ship that are available for installation of jump clones.',NULL,NULL,NULL,NULL,0,1,'Unused Clone Vats',NULL,1,1,7),(1337,'captureProximityRange',5,'',NULL,NULL,NULL,NULL,0,0,'captureProximityRange',NULL,1,1,9),(1339,'factionDefenderID',4,'',NULL,NULL,NULL,NULL,0,0,'factionDefenderID',NULL,1,1,9),(1340,'factionOffenderID',4,'',NULL,NULL,NULL,NULL,0,0,'factionOffenderID',NULL,1,1,9),(1341,'factionID',4,'',NULL,NULL,NULL,NULL,0,0,'factionID',NULL,1,1,9),(1349,'activationBlocked',4,'Used for blocking activation of modules',NULL,NULL,NULL,NULL,0,0,'activationBlocked',NULL,1,1,7),(1350,'activationBlockedStrenght',4,'',NULL,NULL,NULL,NULL,0,0,'activationBlockedStrenght',NULL,1,1,7),(1351,'posCargobayAcceptType',11,'cargo typeID allowed in structures',NULL,NULL,NULL,NULL,0,1,'Allowed Cargo Type',116,1,1,4),(1352,'posCargobayAcceptGroup',12,'cargo bay container group ID',NULL,NULL,NULL,NULL,0,1,'Allowed Cargo Group',115,1,1,4),(1353,'aoeDamageReductionFactor',5,'',NULL,NULL,NULL,NULL,100,0,'Damage Reduction Factor',NULL,1,1,7),(1354,'aoeDamageReductionSensitivity',5,'',NULL,NULL,NULL,NULL,100,0,'aoeDamageReductionSensitivity',NULL,1,1,7),(1355,'shipOrcaTractorBeamRangeBonus1',5,'bonus to range of tractor beams',NULL,NULL,NULL,NULL,0,1,'Tractor Beam Range Bonus',105,1,1,7),(1356,'shipOrcaCargoBonusOrca1',5,'bonus to ship cargo capacity',NULL,NULL,NULL,NULL,0,1,'shipOrcaCargoBonusOrca1',105,1,1,9),(1357,'shipOrcaTractorBeamVelocityBonus2',5,'',NULL,NULL,NULL,NULL,0,1,'shipOrcaTractorBeamVelocityBonus2',105,1,1,9),(1358,'shipOrcaForemanBonus',5,'',NULL,NULL,NULL,NULL,0,1,'shipOrcaForemanBonus',105,1,1,9),(1359,'shipOrcaSurveyScannerBonus',5,'',NULL,NULL,NULL,NULL,0,1,'shipOrcaSurveyScannerBonus',105,1,1,9),(1360,'shipBonusHPExtender1',5,'',NULL,NULL,NULL,NULL,0,1,'shipBonusHPExtender1',105,1,1,9),(1361,'eliteIndustrialCovertCloakBonus',5,'',NULL,NULL,NULL,NULL,0,1,'eliteIndustrialCovertCloakBonus',105,1,1,9),(1366,'subSystemSlot',4,'',NULL,NULL,NULL,NULL,0,1,'subSystemSlot',NULL,1,1,NULL),(1367,'maxSubSystems',4,'',NULL,NULL,3756,NULL,0,1,'Sub System Slots',NULL,1,1,NULL),(1368,'turretHardPointModifier',4,'',NULL,NULL,361,NULL,0,1,'Turret Hardpoint Modifier',NULL,1,1,NULL),(1369,'launcherHardPointModifier',4,'',NULL,NULL,169,NULL,0,1,'Launcher Hardpoint Modifier',NULL,1,1,NULL),(1370,'baseScanRange',5,'This is the lowest scan range value in AUs for probes under the revised probing system',NULL,NULL,NULL,NULL,0,1,'Base Scan Range (AU)',NULL,1,1,7),(1371,'baseSensorStrength',4,'This is the highest sensor strength in points for probes under the revised probing system',NULL,NULL,NULL,NULL,0,1,'Base Sensor Strength',120,1,1,7),(1372,'baseMaxScanDeviation',5,'This is the lowest maximum scan deviation in AU for probes under the revised probing system',NULL,NULL,NULL,NULL,0,1,'Base Maximum Deviation (AU)',NULL,1,1,7),(1373,'rangeFactor',5,'This is the multiplier/divisor for probe range increases and associated values under the revised probing system',NULL,NULL,NULL,NULL,0,1,'Scan Range Increment Factor',104,1,1,7),(1374,'hiSlotModifier',4,'',NULL,NULL,293,NULL,0,1,'Hi Slot Modifier',NULL,1,1,NULL),(1375,'medSlotModifier',4,'',NULL,NULL,294,NULL,0,1,'Med Slot Modifier',NULL,1,1,NULL),(1376,'lowSlotModifier',4,'',NULL,NULL,295,NULL,0,1,'Low Slot Modifier',NULL,1,1,NULL),(1377,'cpuOutputAdd',4,'CPU output of ship',NULL,NULL,1405,NULL,0,1,'CPU Output',106,1,1,1),(1378,'powerOutputAdd',4,'power output of power core',NULL,NULL,1400,NULL,0,1,'powergrid Output',107,1,1,1),(1379,'maxVelocityAdd',4,'Maximum velocity of ship',NULL,NULL,1389,NULL,0,1,'Max Velocity',11,0,1,4),(1380,'fitsToShipType',11,'',NULL,NULL,1443,NULL,0,1,'Restricted to Ship Type',116,1,1,NULL),(1381,'wormholeTargetSystemClass',4,'Target System Class for wormholes',NULL,NULL,NULL,NULL,0,0,'Target System Class',NULL,1,1,7),(1382,'wormholeMaxStableTime',5,'The maximum amount of time a wormhole will stay open',NULL,NULL,NULL,NULL,0,0,'Maximum Stability Window',3,1,1,7),(1383,'wormholeMaxStableMass',5,'The maximum amount of mass a wormhole can transit before collapsing',NULL,NULL,NULL,NULL,0,0,'Maximum Mass Capacity',2,1,1,7),(1384,'wormholeMassRegeneration',5,'The amount of mass a wormhole regenerates per cycle',NULL,NULL,NULL,NULL,0,0,'Mass Regeneration',2,1,1,7),(1385,'wormholeMaxJumpMass',5,'The maximum amount of mass that can transit a wormhole in one go',NULL,NULL,NULL,NULL,0,0,'Maximum Jumpable Mass',2,1,1,7),(1386,'wormholeTargetRegion1',4,'Specific target region 1 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target Region 1',NULL,1,1,7),(1387,'wormholeTargetRegion2',4,'Specific target region 2 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target Region 2',NULL,1,1,7),(1388,'wormholeTargetRegion3',4,'Specific target region 3 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target Region 3',NULL,1,1,7),(1389,'wormholeTargetRegion4',4,'Specific target region 4 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target Region 4',NULL,1,1,7),(1390,'wormholeTargetRegion5',4,'Specific target region 5 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target Region 5',NULL,1,1,7),(1391,'wormholeTargetRegion6',4,'Specific target region 6 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target Region 6',NULL,1,1,7),(1392,'wormholeTargetRegion7',4,'Specific target region 7 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target Region 7',NULL,1,1,7),(1393,'wormholeTargetRegion8',4,'Specific target region 8 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target Region 8',NULL,1,1,7),(1394,'wormholeTargetRegion9',4,'Specific target region 9 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target Region 9',NULL,1,1,7),(1395,'wormholeTargetConstellation1',5,'Specific target constellation 1 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target Constellation 1',NULL,1,1,7),(1396,'wormholeTargetConstellation2',4,'Specific target constellation 2 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target Constellation 2',NULL,1,1,7),(1397,'wormholeTargetConstellation3',4,'Specific target constellation 3 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target Constellation 3',NULL,1,1,7),(1398,'wormholeTargetConstellation4',4,'Specific target constellation 4 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target Constellation 4',NULL,1,1,7),(1399,'wormholeTargetConstellation5',4,'Specific target constellation 5 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target Constellation 5',NULL,1,1,7),(1400,'wormholeTargetConstellation6',4,'Specific target constellation 6 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target Constellation 6',NULL,1,1,7),(1401,'wormholeTargetConstellation7',4,'Specific target constellation 7 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target Constellation 7',NULL,1,1,7),(1402,'wormholeTargetConstellation8',4,'Specific target constellation 8 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target Constellation 8',NULL,1,1,7),(1403,'wormholeTargetConstellation9',4,'Specific target constellation 9 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target Constellation 9',NULL,1,1,7),(1404,'wormholeTargetSystem1',4,'Specific target system 1 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target System 1',NULL,1,1,7),(1405,'wormholeTargetSystem2',4,'Specific target system 2 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target System 2',NULL,1,1,7),(1406,'wormholeTargetSystem3',4,'Specific target system 3 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target System 3',NULL,1,1,7),(1407,'wormholeTargetSystem4',4,'Specific target system 4 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target System 4',NULL,1,1,7),(1408,'wormholeTargetSystem5',4,'Specific target system 5 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target System 5',NULL,1,1,7),(1409,'wormholeTargetSystem6',4,'Specific target system 6 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target system 6',NULL,1,1,7),(1410,'wormholeTargetSystem7',4,'Specific target system 7 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target System 7',NULL,1,1,7),(1411,'wormholeTargetSystem8',4,'Specific target system 8 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target System 8',NULL,1,1,7),(1412,'wormholeTargetSystem9',4,'Specific target system 9 for wormholes',NULL,NULL,NULL,NULL,0,0,'Target System 9',NULL,1,1,7),(1413,'probeCanScanShips',4,'If this is 1 then the probe can scan for ships, otherwise it can\'t.',NULL,NULL,NULL,NULL,0,0,'Calibrated for starships',NULL,1,1,7),(1414,'evasiveManeuverLevel',4,'The evasive manever level of the type. this will controll what types of evasive manevers a NPC ship will use.',NULL,NULL,NULL,NULL,0,0,'Evasive Maneuver Level',NULL,1,1,7),(1416,'targetSwitchTimer',5,'This controlls the time that must pass between one target switch and another!',NULL,NULL,NULL,NULL,60000,0,'Target Switch Timer',101,1,1,6),(1417,'color',4,'',NULL,NULL,NULL,NULL,0,0,'color',NULL,1,1,NULL),(1418,'passiveArmorEmDamageResonance',5,'',NULL,NULL,1396,NULL,0,1,'Armor Em Damage Resistance',108,1,1,3),(1419,'passiveArmorThermalDamageResonance',5,'',NULL,NULL,1394,NULL,0,1,'Armor Thermic Damage Resistance',108,1,1,3),(1420,'passiveArmorKineticDamageResonance',5,'',NULL,NULL,1393,NULL,0,1,'Armor Kinetic Damage Resistance',108,1,1,3),(1421,'passiveArmorExplosiveDamageResonance',5,'',NULL,NULL,1395,NULL,0,1,'Armor Explosive Damage Resistance',108,1,1,3),(1422,'passiveShieldExplosiveDamageResonance',5,'',NULL,NULL,1395,NULL,0,1,'Shield Explosive Damage Resistance',108,1,1,2),(1423,'passiveShieldEmDamageResonance',5,'',NULL,NULL,1396,NULL,0,1,'Shield Em Damage Resistance',108,1,1,2),(1424,'passiveShieldKineticDamageResonance',5,'',NULL,NULL,1393,NULL,0,1,'Shield Kinetic Damage Resistance',108,1,1,2),(1425,'passiveShieldThermalDamageResonance',5,'',NULL,NULL,1394,NULL,0,1,'Shield Thermal Damage Resistance',108,1,1,2),(1426,'passiveHullEmDamageResonance',5,'',NULL,NULL,NULL,NULL,0,1,'Hull Em Damage Resistance',127,1,1,4),(1427,'passiveHullExplosiveDamageResonance',5,'',NULL,NULL,NULL,NULL,0,1,'Hull Explosive Damage Resistance',127,1,1,4),(1428,'passiveHullKineticDamageResonance',5,'',NULL,NULL,NULL,NULL,0,1,'Hull Kinetic Damage Resistance',127,1,1,4),(1429,'passiveHullThermalDamageResonance',5,'',NULL,NULL,NULL,NULL,0,1,'Hull Thermal Damage Resistance',127,1,1,4),(1430,'lightColor',4,'',NULL,NULL,NULL,NULL,0,0,'Determines color',NULL,1,1,7),(1431,'subsystemBonusAmarrEngineering',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusAmarrEngineering',NULL,1,1,7),(1432,'subsystemBonusAmarrElectronic',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusAmarrElectronic',NULL,1,1,7),(1433,'subsystemBonusAmarrDefensive',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusAmarrDefensive',NULL,1,1,7),(1434,'subsystemBonusAmarrOffensive',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusAmarrOffensive',NULL,1,1,7),(1435,'subsystemBonusAmarrPropulsion',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusAmarrPropulsion',NULL,1,1,7),(1436,'subsystemBonusGallenteEngineering',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusGallenteEngineering',NULL,1,1,7),(1437,'subsystemBonusGallenteElectronic',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusGallenteElectronic',NULL,1,1,7),(1438,'subsystemBonusGallenteDefensive',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusGallenteDefensive',NULL,1,1,7),(1439,'subsystemBonusGallenteOffensive',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusGallenteOffensive',NULL,1,1,7),(1440,'subsystemBonusGallentePropulsion',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusGallentePropulsion',NULL,1,1,7),(1441,'subsystemBonusCaldariEngineering',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusCaldariEngineering',NULL,1,1,7),(1442,'subsystemBonusCaldariElectronic',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusCaldariElectronic',NULL,1,1,7),(1443,'subsystemBonusCaldariDefensive',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusCaldariDefensive',NULL,1,1,7),(1444,'subsystemBonusCaldariOffensive',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusCaldariOffensive',NULL,1,1,7),(1445,'subsystemBonusCaldariPropulsion',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusCaldariPropulsion',NULL,1,1,7),(1446,'subsystemBonusMinmatarEngineering',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusMinmatarEngineering',NULL,1,1,7),(1447,'subsystemBonusMinmatarElectronic',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusMinmatarElectronic',NULL,1,1,7),(1448,'subsystemBonusMinmatarDefensive',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusMinmatarDefensive',NULL,1,1,7),(1449,'subsystemBonusMinmatarOffensive',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusMinmatarOffensive',NULL,1,1,7),(1450,'subsystemBonusMinmatarPropulsion',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusMinmatarPropulsion',NULL,1,1,7),(1451,'npcAssistanceProirity',4,'This tis the priority for assisting this npc, higher the number the mor priority this npc has to be repaired and boosted.',NULL,NULL,NULL,NULL,0,0,'Assistance priority',NULL,1,1,7),(1453,'npcRemoteArmorRepairChance',5,'the chance of the NPC remote reapiring it\'s comrads.',NULL,NULL,NULL,NULL,1,0,'Remote Armor reapir chance',105,1,1,3),(1454,'npcRemoteArmorRepairDuration',5,'How long NPC take to remote repair ther comerad in MS.',NULL,NULL,NULL,NULL,10000,0,'NPC Remote Rapair Duration',101,1,1,3),(1455,'npcRemoteArmorRepairAmount',5,'the amount of armor that is repaired per cycle to each target',NULL,NULL,NULL,NULL,0,0,'Remote Reapir amount',NULL,1,1,3),(1456,'npcRemoteArmorRepairThreshold',5,'the amount of damage tot he total armor HPO that has been done before they begin remote repairing that target.',NULL,NULL,NULL,NULL,0.25,0,'repair threshold',105,1,1,3),(1457,'wormholeTargetDistribution',4,'This is the distribution ID of the target wormhole distribution',NULL,NULL,NULL,NULL,0,0,'Target Distribution ID',NULL,1,1,7),(1458,'npcRemoteShieldBoostDuration',5,'Duration of shield boost effect',NULL,NULL,NULL,NULL,20000,0,'npcRemoteShieldBoostDuration',101,1,1,2),(1459,'npcRemoteShieldBoostChance',5,'Chance of the remote shield boosting effect being used',NULL,NULL,NULL,NULL,1,0,'npcRemoteShieldBoostChance',109,1,1,2),(1460,'npcRemoteShieldBoostAmount',4,'How many shields points does the activation of the effect bestow upon the target',NULL,NULL,NULL,NULL,50,0,'npcRemoteShieldBoostAmount',120,1,1,2),(1462,'npcRemoteShieldBoostThreshold',5,'How damaged does a teammates shield need to be before it\'ll be repaired',NULL,NULL,NULL,NULL,0.75,0,'npcRemoteShieldBoostThreshold',109,1,1,2),(1464,'npcAssistanceRange',4,'Maximum distance to a friendly NPC so that remote repairs may be performed on it.',NULL,NULL,NULL,NULL,5000,0,'npcAssistanceRange',1,0,1,7),(1465,'armorEmDamageResistanceBonus',5,'EM damage resistance bonus for armor',NULL,NULL,NULL,NULL,0,1,'Armor EM resistance bonus',124,1,1,3),(1466,'armorKineticDamageResistanceBonus',5,'Kinetic damage resistance bonus for armor',NULL,NULL,NULL,NULL,0,1,'Armor kinetic resistance bonus',124,1,1,3),(1467,'armorThermalDamageResistanceBonus',5,'Thermal damage resistance bonus for armor',NULL,NULL,NULL,NULL,0,1,'Armor thermal resistance bonus',124,1,1,3),(1468,'armorExplosiveDamageResistanceBonus',5,'Explosive damage resistance bonus for armor',NULL,NULL,NULL,NULL,0,1,'Armor explosive resistance bonus',124,1,1,3),(1469,'missileVelocityMultiplier',5,'Velocity multiplier for missiles',NULL,NULL,NULL,NULL,0,1,'Missile velocity multiplier',104,1,1,7),(1470,'maxVelocityMultiplier',5,'Maximum velocity multiplier',NULL,NULL,NULL,NULL,0,1,'Maximum velocity multiplier',104,1,1,4),(1471,'massMultiplier',5,'Mass multiplier',NULL,NULL,NULL,NULL,0,1,'Mass multiplier',104,1,1,4),(1472,'droneRangeMultiplier',5,'Drone control range multiplier',NULL,NULL,NULL,NULL,0,1,'Control range multiplier',104,1,1,10),(1473,'scanGravimetricStrengthMultiplier',5,'Grav ECM strength multiplier',NULL,NULL,NULL,NULL,0,1,'Gravimetric strength multiplier',104,1,1,6),(1474,'scanLadarStrengthMultiplier',5,'Ladar ECM strength multiplier',NULL,NULL,NULL,NULL,0,1,'Ladar strength multiplier',104,1,1,6),(1475,'scanMagnetometricStrengthMultiplier',5,'Magnetometric ECM strength multiplier',NULL,NULL,NULL,NULL,0,1,'Magnetometric strength multiplier',104,1,1,6),(1476,'scanRadarStrengthMultiplier',5,'Radar ECM strength multiplier',NULL,NULL,NULL,NULL,0,1,'Radar strength multiplier',104,1,1,6),(1477,'signatureRadiusBonusMultiplier',5,'Target painter effectiveness multiplier',NULL,NULL,NULL,NULL,0,1,'Target painter multiplier',104,1,1,6),(1478,'maxTargetRangeBonusMultiplier',5,'Sensor dampener range reduction multiplier',NULL,NULL,NULL,NULL,0,1,'Dampening range reduction multiplier',104,1,1,6),(1479,'scanResolutionBonusMultiplier',5,'Sensor dampener scan resolution amount multiplier',NULL,NULL,NULL,NULL,0,1,'Scan resolution reduction multiplier',104,1,1,6),(1480,'trackingSpeedBonusMultiplier',5,'Tracking disruptor tracking amount multiplier',NULL,NULL,NULL,NULL,0,1,'Tracking penalty multiplier',104,1,1,6),(1481,'maxRangeBonusMultiplier',5,'Tracking disruptor optimal range penalty multiplier',NULL,NULL,NULL,NULL,0,1,'Optimal range penalty multiplier',104,1,1,6),(1482,'damageMultiplierMultiplier',5,'Multiplys the damage multiplier',NULL,NULL,NULL,NULL,0,1,'Damage multiplier multiplier',104,1,1,1),(1483,'aoeVelocityMultiplier',5,'Multiplier to missiles ability to hit fast targets',NULL,NULL,NULL,NULL,0,1,'AOE velocity multiplier',104,1,1,1),(1484,'maxDroneVelocityMultiplier',5,'Maximum drone velocity multiplier',NULL,NULL,NULL,NULL,0,1,'Drone velocity multiplier',104,1,1,10),(1485,'heatDamageMultiplier',5,'Damage multiplier for heat',NULL,NULL,NULL,NULL,0,1,'Heat damage multiplier',104,1,1,4),(1486,'overloadBonusMultiplier',5,'Multiplier to all overload bonuses',NULL,NULL,NULL,NULL,0,1,'Overload bonus multiplier',104,1,1,4),(1487,'empFieldRangeMultiplier',5,'Smart bomb range multiplier',NULL,NULL,NULL,NULL,0,1,'Smart bomb range multiplier',104,1,1,7),(1488,'smartbombDamageMultiplier',5,'Damage multiplier for smart bombs',NULL,NULL,NULL,NULL,0,1,'Smart bomb damage multiplier',104,1,1,7),(1489,'shieldEmDamageResistanceBonus',5,'EM resistance bonus for shields',NULL,NULL,NULL,NULL,0,1,'Shield EM Resistance',105,1,1,2),(1490,'shieldExplosiveDamageResistanceBonus',5,'Explosive resistance bonus for shields',NULL,NULL,NULL,NULL,0,1,'Shield Explosive Resistance',105,1,1,2),(1491,'shieldKineticDamageResistanceBonus',5,'Kinetic resistance bonus for shields',NULL,NULL,NULL,NULL,0,1,'Shield Kinetic Resistance',105,1,1,2),(1492,'shieldThermalDamageResistanceBonus',5,'Thermal resistance bonus for shields',NULL,NULL,NULL,NULL,0,1,'Shield Thermal Resistance',105,1,1,2),(1493,'smallWeaponDamageMultiplier',5,'Damage multiplier for small weapons',NULL,NULL,NULL,NULL,0,1,'Small weapon damage multiplier',104,1,1,7),(1494,'mediumWeaponDamageMultiplier',5,'Damage multiplier for medium weapons',NULL,NULL,NULL,NULL,0,1,'Medium weapon damage multiplier',104,1,1,7),(1495,'armorDamageAmountMultiplier',5,'Armor repair amount multiplier',NULL,NULL,NULL,NULL,0,1,'Repair amount multiplier',104,1,1,3),(1496,'shieldBonusMultiplier',5,'Shield transfer amount multiplier',NULL,NULL,NULL,NULL,0,1,'Shield transfer amount multiplier',104,1,1,2),(1497,'shieldBonusMultiplierRemote',5,'Shield repair multiplier for remote repair',NULL,NULL,NULL,NULL,0,1,'Shield repair multiplier',104,1,1,2),(1498,'armorDamageAmountMultiplierRemote',5,'Repair amount multiplier for remote repairers',NULL,NULL,NULL,NULL,0,1,'Remote repair amount multiplier',104,1,1,3),(1499,'capacitorCapacityMultiplierSystem',5,'Capacitor capacity multiplier',NULL,NULL,NULL,NULL,0,1,'Capacitor capacity multiplier',104,1,1,5),(1500,'rechargeRateMultiplier',5,'Capacitor recharge rate multiplier',NULL,NULL,NULL,NULL,0,1,'Capacitor recharge multiplier',104,1,1,5),(1501,'npcRemoteArmorRepairMaxTargets',4,'The maximum number of targets that can be repaired at once.',NULL,NULL,NULL,NULL,1,0,'NPC Remote Armor Repair Max Targets',NULL,1,1,3),(1502,'npcRemoteShieldBoostMaxTargets',4,'The maximum number of targets that can be shield boosted at once',NULL,NULL,NULL,NULL,1,0,'NPC Remote Shield Boost Max Targets',NULL,1,1,2),(1503,'shipBonusStrategicCruiserAmarr',5,'',NULL,NULL,NULL,NULL,0,1,'shipBonusStrategicCruiserAmarr',NULL,1,1,9),(1504,'shipBonusStrategicCruiserCaldari',5,'',NULL,NULL,NULL,NULL,0,1,'shipBonusStrategicCruiserCaldari',NULL,1,1,9),(1505,'shipBonusStrategicCruiserGallente',5,'',NULL,NULL,NULL,NULL,0,1,'shipBonusStrategicCruiserGallente',NULL,1,1,9),(1506,'shipBonusStrategicCruiserMinmatar',5,'',NULL,NULL,NULL,NULL,0,1,'shipBonusStrategicCruiserMinmatar',NULL,1,1,9),(1507,'subsystemBonusAmarrDefensive2',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusAmarrDefensive2',NULL,1,1,7),(1508,'subsystemBonusAmarrElectronic2',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusAmarrElectronic2',NULL,1,1,7),(1509,'subsystemBonusAmarrEngineering2',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusAmarrEngineering2',NULL,1,1,7),(1510,'subsystemBonusCaldariOffensive2',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusCaldariOffensive2',NULL,1,1,7),(1511,'subsystemBonusAmarrOffensive2',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusAmarrOffensive2',NULL,1,1,7),(1512,'subsystemBonusAmarrPropulsion2',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusAmarrPropulsion2',NULL,1,1,7),(1513,'subsystemBonusCaldariPropulsion2',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusCaldariPropulsion2',NULL,1,1,7),(1514,'subsystemBonusCaldariElectronic2',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusCaldariElectronic2',NULL,1,1,7),(1515,'subsystemBonusCaldariEngineering2',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusCaldariEngineering2',NULL,1,1,7),(1516,'subsystemBonusCaldariDefensive2',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusCaldariDefensive2',NULL,1,1,7),(1517,'subsystemBonusGallenteDefensive2',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusGallenteDefensive2',NULL,1,1,7),(1518,'subsystemBonusGallenteElectronic2',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusGallenteElectronic2',NULL,1,1,7),(1519,'subsystemBonusGallenteEngineering2',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusGallenteEngineering2',NULL,1,1,7),(1520,'subsystemBonusGallentePropulsion2',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusGallentePropulsion2',NULL,1,1,7),(1521,'subsystemBonusGallenteOffensive2',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusGallenteOffensive2',NULL,1,1,7),(1522,'subsystemBonusMinmatarOffensive2',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusMinmatarOffensive2',NULL,1,1,7),(1523,'subsystemBonusMinmatarPropulsion2',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusMinmatarPropulsion2',NULL,1,1,7),(1524,'subsystemBonusMinmatarElectronic2',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusMinmatarElectronic2',NULL,1,1,7),(1525,'subsystemBonusMinmatarEngineering2',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusMinmatarEngineering2',NULL,1,1,7),(1526,'subsystemBonusMinmatarDefensive2',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusMinmatarDefensive2',NULL,1,1,7),(1527,'armorMaxDamageResonance',5,'Maximum value for armor resonances. Default = 1.',NULL,NULL,NULL,NULL,1,1,'Maximum Armor Resonance',NULL,1,1,3),(1528,'shieldMaxDamageResonance',5,'Maximum value for shield resonances. Default = 1.',NULL,NULL,NULL,NULL,1,1,'Maximum Shield Resonance',NULL,1,1,2),(1529,'hullMaxDamageResonance',5,'Maximum value for hull resonances. Default = 1.',NULL,NULL,NULL,NULL,1,1,'Maximum Hull Resonance',NULL,1,1,4),(1530,'hullMaxDamageResonance',5,'Maximum value for hull resonances. Default = 1.',NULL,NULL,NULL,NULL,1,1,'Maximum Hull Resonance',NULL,1,1,4),(1531,'subsystemBonusAmarrOffensive3',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusAmarrOffensive3',NULL,1,1,7),(1532,'subsystemBonusGallenteOffensive3',5,'',NULL,NULL,NULL,NULL,0,1,'subsystemBonusGallenteOffensive3',NULL,1,1,7),(1533,'subsystemBonusCaldariOffensive3',5,'',NULL,NULL,NULL,NULL,0,0,'subsystemBonusCaldariOffensive3',NULL,1,1,7),(1534,'subsystemBonusMinmatarOffensive3',5,'',NULL,NULL,NULL,NULL,0,1,'subsystemBonusMinmatarOffensive3',NULL,1,1,7),(1535,'shipBonusCR3',5,'',NULL,NULL,NULL,NULL,0,0,'shipBonusCR3',NULL,1,1,7),(1536,'ecmRangeBonus',5,'',NULL,NULL,NULL,NULL,0,1,'ECM Range Bonus',105,1,1,7),(1537,'eliteBonusReconShips3',5,'',NULL,NULL,NULL,NULL,0,0,'eliteBonusReconShips3',NULL,1,1,7),(1538,'warpBubbleImmune',4,'',NULL,NULL,NULL,NULL,0,1,'warpBubbleImmune',NULL,1,1,7),(1539,'warpBubbleImmuneModifier',4,'',NULL,NULL,NULL,NULL,0,1,'warpBubbleImmuneModifier',NULL,1,1,7),(1540,'stealthBomberLauncherPower2',5,'',NULL,NULL,NULL,NULL,0,1,'stealthBomberLauncherPower2',NULL,1,1,7),(1541,'jumpHarmonicsModifier',4,'',NULL,NULL,NULL,NULL,0,0,'jumpHarmonicsModifier',NULL,1,1,7),(1544,'maxGroupFitted',4,'',NULL,NULL,NULL,NULL,0,1,'Max Group Fitted',NULL,1,1,7),(1545,'dreadnoughtShipBonusM3',5,'',NULL,NULL,NULL,NULL,0,0,'dreadnoughtShipBonusM3',NULL,1,1,7),(1547,'rigSize',4,'',NULL,NULL,NULL,NULL,0,1,'Rig Size',117,1,1,1),(1549,'specialFuelBayCapacity',5,'special fuel bay capacity',NULL,NULL,71,NULL,0,1,'Fuel Bay Capacity',9,0,1,7),(1550,'implantSetImperialNavy',5,'',NULL,NULL,NULL,NULL,1,0,'Imperial Navy Set Bonus',NULL,1,1,9),(1552,'implantSetCaldariNavy',5,'',NULL,NULL,NULL,NULL,1,0,'Caldari Navy Set Bonus',NULL,1,1,9),(1553,'implantSetFederationNavy',5,'',NULL,NULL,NULL,NULL,1,0,'Federation Navy Set Bonus',NULL,1,1,9),(1554,'implantSetRepublicFleet',5,'',NULL,NULL,NULL,NULL,1,0,'Republic Fleet Set Bonus',NULL,1,1,9),(1555,'fwLpKill',5,'',NULL,NULL,NULL,NULL,0,0,'fwLpKill',NULL,1,1,9),(1556,'specialOreHoldCapacity',5,'Capacity of ore-only hold',NULL,NULL,71,NULL,0,1,'Ore Hold Capacity',9,1,1,7),(1557,'specialGasHoldCapacity',5,'Capacity of gas-only hold',NULL,NULL,71,NULL,0,1,'Gas Hold Capacity',9,1,1,7),(1558,'specialMineralHoldCapacity',5,'Capacity of mineral-only hold',NULL,NULL,71,NULL,0,1,'Mineral Hold Capacity',9,1,1,7),(1559,'specialSalvageHoldCapacity',5,'Capacity of special salvage-only hold',NULL,NULL,71,NULL,0,1,'Salvage Hold Capacity',9,1,1,7),(1560,'specialShipHoldCapacity',5,'Capacity of ship-only hold',NULL,NULL,71,NULL,0,1,'Ship Hold Capacity',9,1,1,7),(1561,'specialSmallShipHoldCapacity',5,'Capacity of frigate/destroyer hold',NULL,NULL,71,NULL,0,1,'Small Ship Hold Capacity',9,1,1,7),(1562,'specialMediumShipHoldCapacity',5,'Capacity of cruiser/battlecruiser ship hold',NULL,NULL,71,NULL,0,1,'Medium Ship Hold Capacity',9,1,1,7),(1563,'specialLargeShipHoldCapacity',5,'Capacity of battleship hold',NULL,NULL,71,NULL,0,1,'Large Ship Hold Capacity',9,1,1,7),(1564,'specialIndustrialShipHoldCapacity',5,'Capacity of industrial ship hold',NULL,NULL,71,NULL,0,1,'Industrial Ship Hold Capacity',9,1,1,7),(1565,'scanRadarStrengthModifier',5,'+ / - modifier to a ship radar strength',NULL,NULL,NULL,NULL,0,1,'RADAR strength bonus',NULL,1,1,7),(1566,'scanLadarStrengthModifier',5,'+ / - modifier to a ship ladar strength',NULL,NULL,NULL,NULL,0,1,'LADAR strength bonus',NULL,1,1,7),(1567,'scanGravimetricStrengthModifier',5,'+ / - modifier to a ship gravimetric strength',NULL,NULL,NULL,NULL,0,1,'Gravimetric strength bonus',NULL,1,1,7),(1568,'scanMagnetometricStrengthModifier',5,'+ / - modifier to a ship magnetometric strength',NULL,NULL,NULL,NULL,0,1,'Magnetometric strength bonus',NULL,1,1,7),(1569,'implantSetLGImperialNavy',5,'',NULL,NULL,NULL,NULL,1,0,'Imperial Navy Set LG Bonus',NULL,1,1,9),(1570,'implantSetLGFederationNavy',5,'',NULL,NULL,NULL,NULL,1,0,'Federation Navy Set LG Bonus',NULL,1,1,9),(1571,'implantSetLGCaldariNavy',5,'',NULL,NULL,NULL,NULL,1,0,'Caldari Navy Set LG Bonus',NULL,1,1,9),(1572,'implantSetLGRepublicFleet',5,'',NULL,NULL,NULL,NULL,1,0,'Republic Fleet Set LG Bonus',NULL,1,1,9),(1573,'specialAmmoHoldCapacity',5,'special ammo hold capacity',NULL,NULL,71,NULL,0,1,'Ammo Hold Capacity',9,0,1,7),(1574,'shipBonusATC1',5,'Alliance Tournament Ship Bonus',NULL,NULL,NULL,NULL,0,1,'Special Ability Bonus',105,1,1,9),(1575,'shipBonusATC2',5,'Alliance Tournament Ship Bonus',NULL,NULL,NULL,NULL,0,1,'Special Ability Bonus',105,1,1,9),(1576,'shipBonusATF1',5,'Alliance Tournament Frigate Bonus',NULL,NULL,NULL,NULL,0,1,'Special Ability Bonus',105,1,1,9),(1577,'shipBonusATF2',5,'Alliance Tournament Frigate Bonus',NULL,NULL,NULL,NULL,0,1,'Special Ability Bonus',105,1,1,9);

