/*Table structure for table `eveMessages` */

DROP TABLE IF EXISTS `eveMessages`;

CREATE TABLE `eveMessages` (
  `messageID` varchar(128) NOT NULL default '',
  `messageType` varchar(100) NOT NULL default '',
  `messageText` mediumtext NOT NULL,
  `urlAudio` mediumtext NOT NULL,
  `urlIcon` mediumtext NOT NULL,
  PRIMARY KEY  (`messageID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `eveMessages` */

insert  into `eveMessages`(`messageID`,`messageType`,`messageText`,`urlAudio`,`urlIcon`) values ('AcceptedApplicationsTake24HoursToBecomeEffective','info','Application Accepted:s:Please note that it takes at least 24 hours for an accepted application to become effective.','',''),('AcceptFeeCanNotBeNegative','info','Accept Fee::The accept fee specified is invalid. The accept fee cannot be negative.','',''),('AcceptQuoteNotQuote','info','Information::%(Verb)s %(typeName)s is not possible. The item can not be %(descriptor)s as it contains no materials.','',''),('ActivateInBiomassQueue','question','Undo recycle request?::%(charname)s can not be activated because %(heshe)s has been put in biomass processing queue. Do you want to get %(himher)s back?','',''),('AdminMsg','admin','%(text)s','res:/sound/ui/error07.wav',''),('AdminNotify','notify','%(text)s','',''),('AdminReportItemLocked','info','%(title)s::%(text)s <br><br>ADMIN LOCK TRACE<br>itemID: %(itemID)s<br>Invoker: %(co_name)s<br>Filename: %(co_filename)s<br>Line: %(co_lineno)s<br>Locked: %(lockTime)s','',''),('agentsBtnEnter','audio','','res:/sound/ui/uihme02.wav',''),('agentsHeader','audio','','res:/sound/ui/uihaotxt.wav',''),('AgtAgentInteractionError','info','%(title)s::%(message)s','',''),('AgtBlackMarketMissingCredits','info','Missing Credits::You must provide %(missing.typeandquantity)s when you accept the offer.  You just don\'t have that much.','',''),('AgtBlackMarketMissingItems','info','Missing Items::You must place the requested items in your hangar or your ship prior to accepting the offer.  You don\'t have %(missing.typeandquantity)s.','',''),('AgtBlackMarketNothingOffered','info','Nothing To Offer::The agent has nothing to offer at the moment.','',''),('AgtCompleteMissionMissingCollateral','info','Missing Collateral::You must place the mission collateral in your hangar prior to accepting the mission.  You don\'t have %(missing)s.','',''),('AgtCompleteMissionMissingCollateralCredits','info','Missing Collateral::You must supply %(missing)s as collateral prior to accepting the mission, which you just don\'t have.','',''),('AgtCompleteMissionUnfetchedItem','info','Mission Not Completed::The objectives for this mission have not been met.  Please check your mission journal for further information.','',''),('AgtCompleteMissionUnkilledNPC','info','Mission Not Completed::Please check your mission journal.  I expected a head on a silver platter.','',''),('AgtConfirmDeclineMission','question','Decline Mission::Are you sure that you want to decline the mission.  %(agent)s will not think highly of you if you do so.','',''),('AgtInteractLocked','info','Already processing::The agent is already considering your previous request(s).  Please wait for him/her to finish.','',''),('AgtMissionNoMissionDone','info','No Mission In Progress::You are not currently performing a mission for the agent, or have just completed, quit, or declined one','',''),('AgtMissionNoneOffered','info','No Mission Offered::The agent doesn\'t have a mission to offer you at the moment.','',''),('AgtMissionOfferWarning','warning','Important Information:s:If you ask your agent for a mission, he/she will be disappointed if you let him/her down and lower his/her standings towards you, no matter whether you do so by ignoring or declining his/her mission.  You have 24 hours to accept or decline the mission once it has been offered.  If you lose enough standings, you will no longer be able to talk to your agent.\n','',''),('AgtNotAnAgent','info','Not an Agent::The selected character, %(char)s, is not an Agent.','',''),('AgtNotAnAgent4','info','Not an Agent::The selected character, %(agent.name)s, is not an Agent.','',''),('AgtYouHaveAlreadyAcceptedTheMission','info','Already Accepted::You have already accepted this mission.','',''),('AidGlobalCriminalEmpire','question','Warning - You are about to commit a crime:s:Proceeding with this action will aid your criminal flagged target and will result in a security status penalty for you and might bring CONCORD to enforce the law by destroying your ship. Are you sure you want to activate this module on your target?','',''),('AidGlobalCriminalEmpire2','question','Warning - You are about to commit a crime:s:Proceeding with this action will aid your criminal flagged target and will result in a security status penalty for you and might bring CONCORD to enforce the law by destroying your ship. Are you sure you want to activate this module on %(target)s?','',''),('AidGlobalCriminalSecure','warning','Warning - You are about to commit a crime::Proceeding with this action will aid your criminal flagged target and will result in an immediate CONCORD attack as well as reduce your security rating.\nAre you sure you want to activate this module on %(target)s?','',''),('AidOutlawEmpire','question','Warning - You are about to commit a crime:s:Proceeding with this action will aid your outlawed target and will result in a security status penalty for you and might bring CONCORD to enforce the law by destroying your ship. Are you sure you want to activate this module on your target?','',''),('AidOutlawEmpire2','question','Warning - You are about to commit a crime:s:Proceeding with this action will aid your outlawed target and will result in a security status penalty for you and might bring CONCORD to enforce the law by destroying your ship. Are you sure you want to activate this module on %(target)s?','',''),('AidOutlawSecure','warning','Warning - You are about to commit a crime::Proceeding with this action will aid your outlawed target and will result in an immediate attack by CONCORD as well as a reduced security status. \nAre you sure you want to activate this module on %(target)s?','',''),('AidWithEnemiesEmpire','question','Warning - You are about to aid someone at war:s:Proceeding with this action will aid your target who has enemies present, the activation will be considered an aggression towards your targets enemies. You will be flagged as a criminal towards his enemies for up to 15 minutes from your last aiding activation. Are you sure you want to activate this module on your target?','',''),('AidWithEnemiesEmpire2','question','Warning - You are about to aid someone at war:s:Proceeding with this action will aid your target who has enemies present, the activation will be considered an aggression towards your targets enemies. You will be flagged as a criminal towards his enemies for up to 15 minutes from your last aiding activation. Are you sure you want to activate this module on %(target)s?','',''),('AidWithEnemiesEmpire2_OwnFaction','question','Warning - You are about to aid someone at war:s:Proceeding with this action will aid your target who is at war with members of your own Militia! The activation will be considered an aggression towards the enemies of your target some of whom will be marked friendly as \"In your militia\" in your overview. You will be flagged as a criminal towards all his enemies for up to 15 minutes from your last aiding activation. Are you sure you want to activate this module on %(target)s?','',''),('AllApplyFailDuplicate','info','Application Ignored::Your application to join the alliance has been ignored as you have already applied.','',''),('AllApplyFailInWarFaction','info','Application Ignored::Your application to join the alliance has been ignored as your corporation is engaged in factional warfare.','',''),('AllApplyFailIsMember','info','Application Ignored::Your application to join the alliance has been ignored as your corporation is already a member.','',''),('AllComfirmKickMember','question','Confirm Corporation Expulsion?::If you throw this corporation out of the alliance they will still be in all wars that are currently ongoing for the alliance for the next 24 hours. The wars will be copied over to the corporation being kicked out and they will be automatically surrendered or retracted. Are you sure you want to throw them out?','',''),('AllComfirmKickSelf','question','Are you sure?::If you leave your alliance you will still be at war with everyone the alliance is at war with for the next 24 hours. The wars will be copied over to your corporation and they will be automatically surrendered or retracted. Are you sure you want to leave?','',''),('AllianceCreateDeniedInWarFaction','info','Can\'t Create Alliance::You can\'t create an alliance while engaged in factional warfare','',''),('AllianceCreateFailCorpInAlliance','notify','You must leave the alliance you are currently in first.','',''),('AllianceExecutorInOtherAlliance','notify','The executor can not be a member of another alliance','',''),('AllianceJoinFailCorpInAlliance','notify','Failed to join alliance as already in one.','',''),('AllianceNameInvalidBannedWord','notify','Alliance name contains a banned word.','',''),('AllianceNameInvalidFirstChar','notify','First character in alliance name is illegal.','',''),('AllianceNameInvalidLastChar','notify','Last character in alliance name is illegal.','',''),('AllianceNameInvalidMaxLength','notify','Maximum length for a alliance name is 24 characters.','',''),('AllianceNameInvalidMinLength','notify','Minimum length for a alliance name is 4 characters.','',''),('AllianceNameInvalidSomeChar','notify','Alliance name contains an illegal character.','',''),('AllianceNameInvalidTaken','notify','Alliance name is already taken.','',''),('AllianceNotFound','notify','The specified alliance could not be found','',''),('AllianceShortNameInvalid','notify','Alliance ticker name is not valid.','',''),('AllianceShortNameInvalidTaken','notify','Alliance ticker name is taken.','',''),('AllianceWithMembersCanNotBeDeleted','notify','An alliance with members can not be deleted.','',''),('AlreadyAnchoring','notify','The %(group)s is already being anchored. Wait until it is finished before trying to do something else with it.','',''),('AlreadyAnchoring2','notify','%(group)s is already being anchored. Wait <b>%(time)s</b> until it is finished.','',''),('AlreadyAtWarWithThem','info','Can Not Declare War::You can not declare war on them as you are already at war with them.','',''),('AlreadyBeingReloaded','notify','%(item)s is currently being reloaded.  Please wait until it is finished and try again.','',''),('AlreadyCloaking','notify','You are already trying to cloak.','res:/Sound/ui/voc/AlreadyCloaking.ogg',''),('AlreadyConnecting','info','Connection in Progress::The client is already connecting to the server (whether or not the login progress bar is showing).  Please wait.','',''),('AlreadyHaveLabel','question','Are you sure?::You already have preset with this label, do you want to overwrite it?','',''),('AlreadyInBiomassQueue','info','You have already submitted %(charname)s to the biomass processing queue, %(heshe)s can be terminated in %(time)s','',''),('AlreadyInMarket','notify','That item is already offered on the market.','',''),('AlreadyInPod','notify','You are already in a pod and leaving it would be rather uncomfortable.','',''),('AlreadyTrainingSkill','notify','Do you want to terminate training?','',''),('AlreadyUnanchoring','notify','The %(group)s is already being unanchored. Wait until it is finished before trying to do something else with it.','',''),('AlreadyUnanchoring2','notify','%(group)s is already being unanchored. Wait <b>%(time)s</b> until it is finished.','',''),('AmmoHasSkillPrerequisites','info','Skill Required::You do not have the required skills to do that. To load and use that charge requires having learned the following skills: %(requiredSkills)s.','',''),('AmmoLoadFailedInTransit','notify','The fitting operation you were doing is aborted due to your ship being in transit.','',''),('AmountMustBeInteger','info','Invalid Amount::The specified amount %(amount)s is not an integer.','',''),('AncestryMissing','info','Wrong Ancestry::%(name)s requires some of the ancestries that enable it.','',''),('AnchorDeniedOtherPlatformsAnchored','notify','A station only has the facilities to have one upgrade or improvement platform anchored around it at one time, build the existing one and then try again.','',''),('AnchoringObject','notify','Anchoring the selected object, it will take around %(delay)0.1f seconds to do so.','',''),('AnchorLocationUnsuitable','notify','You cannot safely anchor %(item)s within %(distance)s of large objects in space.','',''),('AnchorMaxTowersPerDayAlliance','info','Too many towers::Your alliance can anchor a total of <b>%(num)s</b> control towers in this solar system each day and you cannot anchor any more.<br><br>\nPlease try again tomorrow when the space-time continuum has finished realigning itself.','',''),('AnchorMaxTowersPerDayCorp','info','Too many towers::Your corporation can anchor a total of <b>%(num)s</b> control towers in this solar system each day and you cannot anchor any more.<br><br>\nPlease try again tomorrow when the space-time continuum has finished realigning itself.','',''),('AnchorNearbyOutpostRequired','notify','You cannot anchor %(item)s unless it is within %(distance)s of an outpost owned by your corporation.','',''),('AnchorOutpostRacialIncompatibility','notify','You cannot anchor %(item)s beside the %(station)s.  Each was manufactured to a different race\'s specifications.','',''),('AnchorProximityUnsuitable','notify','You cannot anchor %(anchoritem)s within %(distance)s of %(items)s in space.','',''),('AntiAddictionTimeExceeded','info','Maximum time exceeded::You have exceeded the playing time allowed by the Anti Addiction Law, and thus you will be disconnected now.<br><br>Please do suitable exercises, and schedule your life practices in a reasonable manner.<br><br>You can log in again after %(waitTime)s.','',''),('AntiAddictionTimeNotify','notify','Accrued Time Warning::Your accrued online time has reached %(accruedTime)s.','',''),('AntiAddictionTimeWarning','info','Accrued Time Warning::Your accrued online time has reached %(accruedTime)s.<br><br>Due to government regulations, you will be disconnected in %(timeLeft)s.  Make sure you leave your char in safety.','',''),('ApplyStructureConnections','question','Apply Structure Connections::You have changed the connections between your structures.<br>Do you want to apply these changes now?','',''),('AreaModuleDeactivatedCloakHit','notify','Your %(item)s deactivates due to interference from a nearby cloaked target.  The target should have been decloaked by your action.  Be careful not to reactivate the module until you know whether the target can be attacked freely.','',''),('AskAcceptCloneContractCost','question','Accept Cost?::The cost for the clone contract you are applying for is %(cost)s ISK. Do you accept the cost?','',''),('AskAcceptCloneTypeCost','question','Accept Payment?::Do you authorize payment for the change of clone type selected? The payment required is %(cost)s ISK.','',''),('AskAcceptJumpCloneCost','question','Accept Payment?::Do you authorize payment for installing a jump clone on this station? The payment required is %(cost)s.','',''),('AskAcceptLogoChangeCost','question','Accept Fee For Changing Logo?::Changing your corporations logo will cost the corporation %(cost)s ISK. Do you wish to authorize this transaction?','',''),('AskAcceptMission','question','Warning::Are you sure you want to accept this mission? It would appear that you might not be able to complete it. %(warning)s','',''),('AskAcceptProductionJobRisk','question','Proceed With Job?::You have a %(chance)s%% chance of %(activityName)s a %(typeName)s. Do you want to continue?','',''),('AskActivateShip','question','Activate Ship?:s:Your escape pod has no cargo hold. Do you wish to activate a ship?','',''),('AskApplyStandingOfZero','question','Set Standings::You are setting a standing that indicates no preference, either good or bad. This standing is the same as that against a complete stranger. As you have specified no notes for this standing the entry serves no purpose, and will disappear if it is set. Do you want to set this standing?','',''),('AskApproveOffense','question','Accept the Consequences?:s:You are about to make an act of aggression towards something.  This may result in security status penalties and/or changes in the standings various factions and corporations have towards you.  Are you sure you wish to go through with this action?','',''),('AskAreYouSure','question','Are you sure?::%(cons)s','',''),('AskCancelCharCreation','question','Trash Changes::All your choices will be lost. Are you sure you want to cancel this character creation session?','',''),('AskCancelContinuation','question','Discard Selections?:s:These changes will discard your former selections for this and the following steps. Are you sure?<br><br>Click OK to activate new changes and discard old choices.<br>Select Cancel to discard new changes and keep old choices.','',''),('AskCancelRentOfFactorySlot','question','Cancel Rental Agreement?::Do you want to cancel the rental agreement on the selected factory slot? No refund will be made in respect to the remaining rental period, or any other circumstance.','',''),('AskCancelRentOfResearchFacilitySlot','question','Cancel Rental Agreement?::Do you want to cancel the rental agreement on the selected research facility slot? No refund will be made in respect to the remaining rental period, or any other circumstance.','',''),('AskCancelSkill','question','Cancel Training?::You are already training %(skillName)s. If you start training this skill now, you will lose the time spent training as well as the skill kit. Are you sure you want to do this?','',''),('AskClearCacheReboot','question','Restart now?::To clear the cache the client needs to be restarted, would you like to clear your cache and restart the client now?<br>\nNote: Your In Game Browser\'s bookmarks will also be cleared.','',''),('AskCloseWindowsInStack','question','Close All?:s:Do you want to close all the windows which are in this stack of windows','',''),('AskDeleteCharacter','question','Recycle character::Are you sure you want to recycle %(name)s into biomass? The body will be shredded and donated to the Empire\'s biomass bank.','',''),('AskEditionChangeReboot','question','Restart now?::To change the edition the client needs to be restarted, would you like to do it now? (If you choose not to do it now the edition will change next time the client starts up)','',''),('AskGraphicsChangeReboot','question','Restart now?::To change the graphics settings the client needs to be restarted, would you like to do it now? (If you choose not to do it now the changes will take effect next time the client starts up)','',''),('AskHasBogusQuantity','info','Quantity not valid::You are trying to sell %(enteredNum)s item(s) when you only have %(actualNum)s','',''),('AskJoinGang','question','Join Fleet?::%(name)s wants you to join their fleet, do you accept?\n<br><br>\nNOTE: Attacking members of your fleet is not a CONCORD sanctioned activity and may result in security status loss and police response.\n','',''),('AskLoadMarketGroupProceed','question','Proceed Loading?:s:%(groupname)s contains %(lenitem)s different types, are you sure you want to load them all?','',''),('AskLogoffGame','question','Log off:s:Do you really want to log off and return to the login screen now?','',''),('AskPartialCargoLoad','question','Not Enough Space:s:This operation would require %(volume)s units of space; destination container only has %(available)s. Do you want to try a partial move?','',''),('AskPayDockingFee','question','Docking Fee::You have been quoted a docking fee of <b>%(cost)s ISK</b>. In order to dock at this station, you must accept the fee. Do you want to proceed?','',''),('AskPayOfficeRentalFee','question','Office Rental Fee::You have been quoted an office rental fee of %(cost)s ISK. The rental period is for %(days)s day(s). The corporation renting you the office can end the contract at the end of a rental period. The contract might be automatically extended if the office has not been vacated at the end of a rental period. This is done at the discretion of the corporation renting you the office. If the contract is automatically extended then you will receive a bill for the extension of the contract. If you do not pay the bill by the end of the extension, then the office will be repossessed. In order to rent an office at this station, you must accept the fee. Do you accept?','',''),('AskPayShareholders','question','Shareholders or Members?::Click YES to pay a dividend to the shareholders. Click NO to pay the members. Click CANCEL to cancel this operation.','',''),('AskProceedBookmarking','question','Proceed?::You already have the location \"%(locationname)s\" stored in you location list under \"%(caption)s\", do you want to proceed with this one?','',''),('AskQuitGame','question','Quit the Game:s:Do you really want to quit now?','',''),('AskRecycle','question','Destroy Item?::The item will be destroyed. Are you sure you want to recycle it?','',''),('AskRentFactorySlot','question','Rental Quote::The cost for renting a factory slot is %(cost)s. This will be charged to the owner of the hangar used with the factory slot. Do you want to authorize payment?','',''),('AskRentFactorySlotForCorporateUse','question','Use the Corporation Hangar?::A factory slot uses blueprints and minerals from a hangar. The hangar can be either your corporation\'s hangar or your personal hangar but not both. Do you want to use the corporation\'s hangar?','',''),('AskRentResearchFacilitySlot','question','Rental Quote::The cost for renting a research facility slot is %(cost)s. This will be charged to the owner of the hangar used with the research facility slot. Do you want to authorize payment?','',''),('AskRentResearchFacilitySlotForCorporateUse','question','Use the Corporation Hangar?::A research facility slot uses blueprints and minerals from a hangar. The hangar can be either your corporation\'s hangar or your personal hangar but not both. Do you want to use the corporation\'s hangar?','',''),('AskResignAsCEO','question','Resign From CEO Position?::Tired of being at the top of the corporate ladder and looking for a way out?<br>If you choose \'yes\' you will be given the option of naming your successor from your corporation\'s roster of %(memberCount)s members.<br><br>Are you sure that you want to resign from the position of CEO?','',''),('AskSetHomeStationAtPOS','question','Territorial Dispute::SEC regards the location you have selected as being part of a territorial dispute. There is a chance that your clone contract may be revoked by the owner of the station and moved to another station. Are you sure that you want to place your clone contract there?','',''),('AskSetHomeStationWithoutMedical','warning','Warning - Dangerous Location:s:In the event that you should need to be reanimated, you will not be able to update your clone at the location you have selected prior to venturing back into the void. \nAre you sure you want to do this?','',''),('AskShowList','question','Display %(numberOfEntries)s %(pluralTypeName)s?:s:The requested listing contains %(numberOfEntries)s entries, or thereabouts. Do you want to display the list?','',''),('AskSkipPartOfTutorial','question','Skip this tutorial?:s:By skipping this tutorial, you may lack useful information later on. Would you like to do that now?','',''),('AskStripShip','question','Strip Ship::Do you really want to remove all modules from your ship?','',''),('AskSubmitToBiomassQueue','question','Recycle character?::Are you sure you want to submit %(charname)s to the biomass processing queue?','',''),('AskTryNewName','question','Try for new name?:s:The name: %(name)s is not valid. The name must have between 4 and 16 characters, no more than two words, no punctuation, not already be in use by some other player, and no offensive words. Would you like to try for new one? If you choose No you will be taken back to the character selection screen.','',''),('AssembleCCFirst','info','The cargo container is unassembled::Items can not be put inside unassembled cargo containers.','',''),('AssembledShipsDontFitInCargo','info','Not enough space::Assembled ships don\'t fit in cargo.<br><br>Try repackaging them first.','',''),('AssembleOwnShipsOnly','notify','Only ships that you own can be assembled, this is owned by %(owner)s.','',''),('AssembleShipInSpace','notify','You can only assemble ships in space if they are inside your cargo hold.','',''),('AssembleShipInStation','info','Can\'t assemble ship::Ships can only be assembled in station hangars','',''),('AssembleShipsOnly','notify','Only ships can be assembled, this is a %(group)s.','',''),('AssNoCriteria','info','No Search Conditions::You must specify either a category, group or exact item type to search for. ','',''),('AttackAreaEmpire','question','Warning - You are about to activate an area of effect module:s:This module activates an effect in the area around you and will be considered as an attack to all targets with in the field of the effect, if there any innocent targets within the area effect you will receive a security status penalty and might bring CONCORD to enforce the law by destroying your ship. Are you sure you want to activate this module?','',''),('AttackAreaEmpire2','question','Warning - You are about to activate an area of effect module:s:This module activates an effect in the area around you and will be considered as an attack to all targets with in the field of the effect, if there any innocent targets within the area effect you will receive a security status penalty and might bring CONCORD to enforce the law by destroying your ship. Are you sure you want to activate this module?','',''),('AttackAreaEmpire3','question','Warning - You are about to activate an area of effect module:s:Use of offensive area of effect weapons in Empire space can result in criminal flagging resulting in a CONCORD response, even when hitting cloaked ships. Use with extreme caution. Are you sure you want to activate this module?','',''),('AttackAreaEmpireAbort1','question','Proceed with this dangerous act?:s:Use of offensive area of effect weapons in Empire space can result in criminal flagging resulting in a CONCORD response, even when hitting cloaked ships. Use with extreme caution.<br><br>Do you wish to proceed with this dangerous action?','',''),('AttackAreaNonEmpireAbort1','question','Proceed with this dangerous act?:s:Use of offensive area of effect weapons can result in criminal flagging, even when hitting cloaked ships. Use with extreme caution.<br><br>Do you wish to proceed with this dangerous action?','',''),('AttackCanceledByAura','info','I can\'t let you do that, dear::Aura denies you this action for your own good. You can try again when the tutorial is over.','res:/Tutorial2/_criterias/AttackCanceledByAura.ogg',''),('AttackGoodNPC','question','Warning - Attacking a peaceful civilian:s:Activating this module on your target will result in faction status penalty for you towards the corporation of your target and will also cause your target to attack back. Are you sure you want to activate this module on your target?','',''),('AttackGoodNPC2','question','Warning - Attacking a peaceful civilian:s:Activating this module on your target will result in faction status penalty for you towards the corporation of your target and will also cause your target to attack back. Are you sure you want to activate this module on %(target)s?','',''),('AttackGoodNPCAbort1','question','Proceed with this dangerous act?:s:Continuing this action on that peaceful civilian will result in faction status penalty for you towards the corporation of your target and will also cause your target to attack back.<br><br>Do you wish to proceed with this dangerous action?','',''),('AttackHit1','notify','<color=0xffbbbb00>Your %(weapon)s barely scratches %(target)s, causing %(damage)0.1f damage.','',''),('AttackHit1R','notify','<color=0xffbb6600>%(source)s barely scratches you, causing %(damage)0.1f damage.','',''),('AttackHit1RD','notify','<color=0xffbb6600>%(weapon)s belonging to %(owner)s barely scratches you, causing %(damage)0.1f damage.','',''),('AttackHit1RD_Simple','notify','<color=0xffbb6600>%(owner)s (%(weapon)s) hits you for <b>%(damage)0.0f</b> damage.','',''),('AttackHit1R_Simple','notify','<color=0xffbb6600>%(source)s hits you for <b>%(damage)0.0f</b> damage.','',''),('AttackHit1_Simple','notify','<color=0xff99bb00>%(weapon)s hits %(target)s for <b>%(damage)0.0f</b> damage.','',''),('AttackHit2','notify','<color=0xffbbbb00>Your %(weapon)s lightly hits %(target)s, doing %(damage)0.1f damage.','',''),('AttackHit2R','notify','<color=0xffbb6600>%(source)s lightly hits you, doing %(damage)0.1f damage.','',''),('AttackHit2RD','notify','<color=0xffbb6600>%(weapon)s belonging to %(owner)s lightly hits you, doing %(damage)0.1f damage.','',''),('AttackHit2RD_Simple','notify','<color=0xffbb6600>%(owner)s (%(weapon)s) hits you for <b>%(damage)0.0f</b> damage.','',''),('AttackHit2R_Simple','notify','<color=0xffbb6600>%(source)s hits you for <b>%(damage)0.0f</b> damage.','',''),('AttackHit2_Simple','notify','<color=0xff66bb00>%(weapon)s hits %(target)s for <b>%(damage)0.0f</b> damage.','',''),('AttackHit3','notify','<color=0xffbbbb00>Your %(weapon)s hits %(target)s, doing %(damage)0.1f damage.','',''),('AttackHit3R','notify','<color=0xffbb6600>%(source)s hits you, doing %(damage)0.1f damage.','',''),('AttackHit3RD','notify','<color=0xffbb6600>%(weapon)s belonging to %(owner)s hits you, doing %(damage)0.1f damage.','',''),('AttackHit3RD_Simple','notify','<color=0xffbb6600>%(owner)s (%(weapon)s) hits you for <b>%(damage)0.0f</b> damage.','',''),('AttackHit3R_Simple','notify','<color=0xffbb6600>%(source)s hits you for <b>%(damage)0.0f</b> damage.','',''),('AttackHit3_Simple','notify','<color=0xff99bb00>%(weapon)s hits %(target)s for <b>%(damage)0.0f</b> damage.','',''),('AttackHit4','notify','<color=0xffbbbb00>Your %(weapon)s is well aimed at %(target)s, inflicting %(damage)0.1f damage.','',''),('AttackHit4R','notify','<color=0xffbb6600>%(source)s aims well at you, inflicting %(damage)0.1f damage.','',''),('AttackHit4RD','notify','<color=0xffbb6600>%(weapon)s belonging to %(owner)s heavily hits you, inflicting %(damage)0.1f damage.','',''),('AttackHit4RD_Simple','notify','<color=0xffbb6600>%(owner)s (%(weapon)s) hits you for <b>%(damage)0.0f</b> damage.','',''),('AttackHit4R_Simple','notify','<color=0xffbb6600>%(source)s hits you for <b>%(damage)0.0f</b> damage.','',''),('AttackHit4_Simple','notify','<color=0xff99bb00>%(weapon)s hits %(target)s for <b>%(damage)0.0f</b> damage.','',''),('AttackHit5','notify','<color=0xffbbbb00>Your %(weapon)s places an excellent hit on %(target)s, inflicting %(damage)0.1f damage.','',''),('AttackHit5R','notify','<color=0xffbb6600>%(source)s places an excellent hit on you, inflicting %(damage)0.1f damage.','',''),('AttackHit5RD','notify','<color=0xffbb6600>%(weapon)s belonging to %(owner)s places an excellent hit on you, inflicting %(damage)0.1f damage.','',''),('AttackHit5RD_Simple','notify','<color=0xffbb6600>%(owner)s (%(weapon)s) hits you for <b>%(damage)0.0f</b> damage.','',''),('AttackHit5R_Simple','notify','<color=0xffbb6600>%(source)s hits you for <b>%(damage)0.0f</b> damage.','',''),('AttackHit5_Simple','notify','<color=0xff99bb00>%(weapon)s hits %(target)s for <b>%(damage)0.0f</b> damage.','',''),('AttackHit6','notify','<color=0xffbbbb00>Your %(weapon)s perfectly strikes %(target)s, wrecking for %(damage)0.1f damage.','',''),('AttackHit6R','notify','<color=0xffbb6600>%(source)s strikes you  perfectly, wrecking for %(damage)0.1f damage.','',''),('AttackHit6RD','notify','<color=0xffbb6600>%(weapon)s belonging to %(owner)s strikes you perfectly, wrecking for %(damage)0.1f damage.','',''),('AttackHit6RD_Simple','notify','<color=0xffbb6600>%(owner)s (%(weapon)s) hits you for <b>%(damage)0.0f</b> damage (Wrecking!).','',''),('AttackHit6R_Simple','notify','<color=0xffbb6600>%(source)s hits you for <b>%(damage)0.0f</b> damage (Wrecking!)','',''),('AttackHit6_Simple','notify','<color=0xff99bb00>%(weapon)s hits %(target)s for <b>%(damage)0.0f</b> damage (Wrecking!).','',''),('AttackInnocentEmpire','question','Warning - You are about to commit a crime:s:This module activates an attack on your target and will result in a security status penalty for you and might bring CONCORD to enforce the law by destroying your ship. Are you sure you want to activate this module on your target?','',''),('AttackInnocentEmpire2','question','Warning - You are about to commit a crime:s:This module activates an attack on your target and will result in a security status penalty for you and might bring CONCORD to enforce the law by destroying your ship. Are you sure you want to activate this module on %(target)s?','',''),('AttackInnocentEmpireAbort1','question','Proceed with this dangerous act?:s:This action is an attack on your target. Attacking this target is a crime, will result in a security status penalty for you and will bring CONCORD to enforce the law by destroying your ship should you enter high-security space soon.<br><br>Do you wish to proceed with this dangerous action?','',''),('AttackInnocentEmpireAbort1_HighSec','warning','Proceed with this dangerous act?::This action is an attack on your target. Attacking this target is a crime, will result in a security status penalty for you and will bring CONCORD to enforce the law by destroying your ship. <b>CONCORD will kill you!</b><br><br>Do you wish to proceed with this dangerous action?','',''),('AttackInnocentEmpireAbort1_HighSec_OwnFaction','warning','Proceed with this dangerous act?::This action is an attack on your target who is a member of your own militia. Attacking this target is a serious crime, will result in a security status penalty for you and will bring CONCORD to enforce the law by destroying your ship in addition to causing you a severe standing hit towards your faction! <b>CONCORD will kill you!</b><br><br>Do you wish to proceed with this dangerous action?','',''),('AttackInnocentEmpireAbort1_OwnFaction','warning','Proceed with this dangerous act?::This action is an attack on your target who is a member of your own militia. Attacking this target is a serious crime, will result in a security status penalty for you and will bring CONCORD to enforce the law by destroying your ship should you enter high-security space soon. In addition this action will cause a severe standing hit towards your faction!<br><br>Do you wish to proceed with this dangerous action?','',''),('AttackMiss1','notify','Your %(weapon)s misses %(target)s completely.','',''),('AttackMiss1R','notify','%(source)s misses you completely.','',''),('AttackMiss1RD','notify','%(weapon)s belonging to %(owner)s misses you completely.','',''),('AttackMiss1RD_Simple','notify','%(owner)s (%(weapon)s) misses you.','',''),('AttackMiss1R_Simple','notify','%(source)s misses you.','',''),('AttackMiss1_Simple','notify','%(weapon)s misses %(target)s','',''),('AttackMiss2','notify','Your %(weapon)s barely misses %(target)s.','',''),('AttackMiss2R','notify','%(source)s barely misses you.','',''),('AttackMiss2RD','notify','%(weapon)s belonging to %(owner)s barely misses you.','',''),('AttackMiss2RD_Simple','notify','%(owner)s (%(weapon)s) misses you.','',''),('AttackMiss2R_Simple','notify','%(source)s misses you.','',''),('AttackMiss2_Simple','notify','%(weapon)s misses %(target)s.','',''),('AttackMiss3','notify','Your %(weapon)s glances off %(target)s, causing no real damage.','',''),('AttackMiss3R','notify','%(source)s lands a hit on you which glances off, causing no real damage.','',''),('AttackMiss3RD','notify','%(weapon)s belonging to %(owner)s lands a hit on you which glances off, causing no real damage.','',''),('AttackMiss3RD_Simple','notify','%(owner)s (%(weapon)s) misses you.','',''),('AttackMiss3R_Simple','notify','%(source)s misses you.','',''),('AttackMiss3_Simple','notify','%(weapon)s misses %(target)s.','',''),('AttackNonEmpire','question','Warning - You are about to attack another player:s:Activating this module on your target is an aggression towards a player and might result in destruction of his ship. Are you sure you want to activate this module on your target?','',''),('AttackNonEmpire2','question','Warning - You are about to attack another player:s:Activating this module on your target is an aggression towards a player and might result in destruction of his ship. Are you sure you want to activate this module on %(target)s?','',''),('AttackNonEmpireAbort1','question','Proceed with this dangerous act?:s:Continuing this action on your target is an aggression towards a player and might result in destruction of his ship.<br><br>Do you wish to proceed with this dangerous action?','',''),('AttributeValueTooLow','info','Attribute Too Low::%(name)s needs a %(attributeName)s of %(needed)s or higher. Your current %(attributeName)s is %(current)s.','',''),('autActive','notify','Authenticated as: %(user)s<br><t>Last Login: %(lastLogin)s<br><t>Number of Visits: %(logonCount)d','res:/sound/ui/info.wav',''),('autBanned','info','Banned::User %(user)s is banned<br><t>Last login: %(lastLogin)s<br><t>Number of visits: %(logonCount)d<br>Reason: %(messageText)s<br>Until: %(lift)s\n','res:/sound/ui/error09.wav',''),('AutClusterStarting','info','Cluster Starting::The cluster is still starting up.','',''),('autDeleted','info','user %(user)s has been deleted <br><t>Last Login: %(lastLogin)s<br><t>Number of Visits: %(logonCount)d','res:/sound/ui/error09.wav',''),('autDisabled','info','Account %(user)s has been disabled  <br><t>Last Login: %(lastLogin)s<br><t>Number of Visits: %(logonCount)d<br>reason: Account subscription expired!','res:/sound/ui/error09.wav',''),('autExpired','info','account  %(user)s is expired  <br><t>Last Login: %(lastLogin)s<br><t>Number of Visits: %(logonCount)d','res:/sound/ui/error09.wav',''),('AutHeadOfLogonQueue','audio','','res:/sound/ui/OnLogin04.wav?vol=2.0',''),('autLoginFailed','info','Incorrect username or password','res:/sound/ui/error09.wav',''),('autLoginFailedPaymentPending','info','Payment Pending::Payment for your account has not been received or confirmed, so regretfully, the server must reject your login.  If you have confirmation that payment has indeed been made, please contact customer support.','',''),('AutLogonFailureInsufficientGameTime','info','Insufficient Game Time::Your account does not have more Game Time available.  Please purchase more time on the EVE web site.','',''),('AutLogonFailureTooManyTrialsPerHost','info','Connection Refused::While we appreciate your enthusiasm to try EVE, we would also appreciate if you could limit yourself to using a single trial or subscription accounts only.','',''),('AutLogonFailureTotalUsers','info','Connection not allowed::The EVE cluster has reached its maximum user limit.  Please try logging in again later.  You are #%(position)d in line for logon.','',''),('AutLogonFailureTotalUsers_Throttled','info','Connection not allowed::The EVE cluster is currently starting and cannot accept all connections, please try logging in again later.  You are #%(position)d in line for logon.','',''),('AutoPilotApproaching','notify','Autopilot approaching stargate','res:/Sound/ui/voc/ApproachingStargate.ogg',''),('AutoPilotDisabled','notify','Autopilot disabled','res:/Sound/ui/voc/AutoPilotDisabled.ogg',''),('AutoPilotDisabledNoPathSet','notify','Autopilot disabled - No waypoints set','res:/Sound/ui/voc/AutoPilotDisabledNoWayp.ogg',''),('AutoPilotDisabledStuckSystem','notify','Autopilot disabled - Destination unreachable, check Traffic Advisories in Map','res:/Sound/ui/voc/AutoPilotDisabled.ogg',''),('AutoPilotDisabledUnreachable','notify','Autopilot disabled - Destination unreachable','res:/Sound/ui/voc/AutoPilotDisabled.ogg',''),('AutoPilotEnabled','notify','Autopilot engaged','res:/Sound/ui/voc/AutoPilotEngaged.ogg',''),('AutoPilotJumping','notify','Autopilot jumping to %(what)s','res:/Sound/ui/voc/AutoPilotJumping.ogg',''),('AutopilotMovingAwayFromStargate','notify','Moving you to warp range away from stargate','',''),('AutopilotNoRouteFoundAvoidance','info','Waypoint is in Avoidance List:s:Autopilot cannot calculate route to %(name)s because that waypoint is in your Avoidance List.<br><br>You must uncheck \"Avoid systems in your Avoidance List\" in your autopilot settings to be able to set a route to this waypoint.','',''),('AutoPilotWarpingTo','notify','Autopilot warping to %(what)s stargate','res:/Sound/ui/voc/AutoPilotWarpToStargate.ogg',''),('AutoPilotWaypointReached','notify','Autopilot disabled - Waypoint reached','res:/Sound/ui/voc/AutoPilotDisabledWaypReac.ogg',''),('autPendBanned','info','Banned::User %(user)s is banned pending investigation<br><t>Last login: %(lastLogin)s<br><t>Number of visits: %(logonCount)d<br>Reason: %(messageText)s','res:/sound/ui/error09.wav',''),('autPermBanned','info','Banned::User %(user)s is permanently banned<br><t>Last login: %(lastLogin)s<br><t>Number of visits: %(logonCount)d<br>Reason: %(messageText)s','res:/sound/ui/error09.wav',''),('BadAmmoSize','info','Wrong Ammo Size::The %(ammo)s is size %(sizeGot)d, %(gun)s requires size %(sizeWant)d.','',''),('BadCharactersInName','info','Bad Characters in Name::The following illegal characters were found in your name: %(badChars)s. The list of all illegal characters is %(allBad)s','',''),('BadDroneTarget','info','Bad Drone Target::%(launcherGroup)s cannot launch drones at a %(targetGroup)s.','',''),('BadParameter','info','This is not possible::%(reason)s','',''),('BallJustLeftPark','notify','%(item)s has just left %(solsys)s as of %(time)s ago','',''),('BannedBloodline','info','%(name)s is not allowed for characters of bloodline %(bloodlineName)s.','',''),('BannedRace','info','%(name)s is banned for characters of race %(raceName)s.','',''),('BillMgrAllianceMaintainanceBillMessage','info','This is an automatic message. A bill of %(amount)s ISK, due %(dueDate)s owed by %(allianceName)s to %(creditorsName)s was issued %(currentDate)s. This bill is for the maintainance of %(allianceName)s','',''),('BillMgrAllianceMaintainanceBillWalletMessage','info','%(amount)s ISK due: %(dueDate)s owed by: %(allianceName)s to: %(creditorsName)s, interest: %(interest)s %%. This bill is for the maintainance of %(allianceName)s','',''),('BillMgrBrokerBillMessage','info','This is an automatic message. A bill of %(amount)s ISK, due %(dueDate)s owed by you to your broker %(creditorsName)s was issued %(currentDate)s. This bill is for services rendered, in relation to broker order: %(orderID)s at %(locationName)s.','',''),('BillMgrBrokerBillWalletMessage','info','%(amount)s ISK due: %(dueDate)s owed by: %(debtorsName)s to: %(creditorsName)s, interest: %(interest)s %%. This bill is for brokerage services rendered by %(creditorsName)s at %(locationName)s, in reference to orderID: %(orderID)s','',''),('BillMgrMarketFineMessage','info','This is an automatic message. A bill of %(amount)s ISK, due %(dueDate)s owed by you to %(creditorsName)s was issued %(currentDate)s. This fine is for attempting a purchase that you could not afford. Namely %(itemType)s at %(locationName)s','',''),('BillMgrMarketFineWalletMessage','info','%(amount)s ISK due: %(dueDate)s owed by: %(debtorsName)s to: %(creditorsName)s, interest: %(interest)s %%. This fine is for attempting to purchase %(itemType)s at %(locationName)s.','',''),('BillMgrRentalBillMessage','info','This is an automatic message. A bill of %(amount)s ISK, due %(dueDate)s owed by you to %(creditorsName)s was issued %(currentDate)s. This bill is for extending the lease on your %(itemType)s at %(locationName)s','',''),('BillMgrRentalBillWalletMessage','info','%(amount)s ISK due: %(dueDate)s owed by: %(debtorsName)s to: %(creditorsName)s, interest: %(interest)s %%. This bill is for extending the lease on a %(itemType)s at %(locationName)s.','',''),('BillMgrWarBillMessage','info','This is an automatic message. A bill of %(amount)s ISK, due %(dueDate)s owed by you to %(creditorsName)s was issued %(currentDate)s. This bill is for continuing the war against %(against)s','',''),('BillMgrWarBillWalletMessage','info','%(amount)s ISK due: %(dueDate)s owed by: %(debtorsName)s to: %(creditorsName)s, interest: %(interest)s %%. This bill is for continuing the war against %(against)s','',''),('BitsCompleteError','info','Download failure::Download of content patch failed.<br><br>Further information: %(error)s','',''),('BitsHashError','info','File Corrupt::Content Upgrade File is corrupt. You will have to download the file again.','',''),('BitsNoDownload','info','Nothing downloaded::There are no files in the download queue. The content upgrade cannot complete.','',''),('BkmGetCloser','notify','Please get closer so accurate position can be scanned.','',''),('BkmMustBeInFlight','info','Can\'t Bookmark This::You can\'t bookmark this from where you are','',''),('BkmNotOwner','info','Not owner::This bookmark does not belong to you','',''),('BkmWrongSolarsystem','info','Wrong solar system::This bookmark refers to another solar system','',''),('blackmarketHeader','audio','','res:/sound/ui/uihblackmrktxt.wav',''),('BloodlineBrutor','notify','The Brutors are strong willed and have a great sense of individuality. They are a swarthy people, a bit larger and burlier than the other Minmatar tribes. They favor physical prowess over anything else.','',''),('BloodlineCaldariCivire','notify','Civire provide the backbone of the Caldari Empire. They\'re cool, level-headed and relentless in their approach to either trading or fighting. Civire can handle pressure extremely well.','',''),('BloodlineCivire','notify','Civire provide the backbone of the Caldari Empire. They\'re cool, level-headed and relentless in their approach to either trading or fighting. Civire can handle pressure extremely well, an invaluable attribute.','',''),('BloodlineDeteis','notify','The Deteis symbolize Caldari in every way. They\'re efficient, hard working and duty-bound. The Deteis are commonly found in positions of authority, both in administration and the military.','',''),('BloodlineSebiestor','notify','The Sebiestors are ambitious and driven. They are innovative thinkers and are always willing to try something new and different. The Sebiestors are of slight build, but are lithe and often graceful.','',''),('BlueprintCanNotBeReseached','info','Research Not Currently Possible::The %(blueprintTypeName)s cannot be technologically researched. ','',''),('BlueprintCopiesCannotBeTradedOnMarket','info','You cannot trade blueprint copies on the market.','',''),('BookmarkDeleted','notify','This bookmark has been deleted.','',''),('BrowseHtml','','%(url)s','',''),('BrowseIGB','','%(url)s','',''),('BrutorFemale','notify','Brutor females are in some ways opposites of male Brutors. They are dominant, persistent and egocentric. Their grace and beauty serve to aid them in these matters.','',''),('BrutorMale','notify','Male Brutors are patient, alert and determined. Their thoughtful, deliberate manner gives them great situational awareness.','',''),('BuildDeniedAlreadyBuilding','notify','You cannot start the %(group)s building, because it is already building.','',''),('BuildDeniedConqStnPresent','notify','You cannot build the %(group)s in this solar system as there is already a conquerable station present.','',''),('BuildDeniedConqStnPresentWhere','notify','You cannot build the %(group)s in this solar system as there is already an outpost present at %(loc)s.','',''),('BuildDeniedOtherPlatformsBuilding','notify','It is only possible for one platform to be engaged in upgrade or improvement operations at a time for a given station.','',''),('BuildDeniedPlaformPresent','notify','You cannot build the %(group)s in this solar system as there is already another construction platform building.','',''),('BuildingHasSkillPrerequisites','notify','You do not have the required skills to do that. To construct that item requires having learned the following skills: %(requiredSkills)s.','',''),('BuildOwnerDeniesPermission','notify','You cannot build the %(group)s on behalf of %(owner)s as they do not allow this.','',''),('BuildRequiresCorpOwner','notify','You cannot build the %(group)s on behalf of %(owner)s as it can only be build on behalf of a corporation.','',''),('BuildRequiresResources','info','More Minerals Required::Before this platform can construct %(item)s, the following mineral quantities need to be placed within it:<br><br>%(info)s','',''),('BuildRequiresSystemSovereigntyNone','notify','You cannot build the %(group)s in a solar system where no alliance holds sovereignty.  Have your corporation join an alliance and work to acquire sovereignty of this solar system.','',''),('BuildRequiresSystemSovereigntyOther','notify','You cannot build the %(group)s in this solar system because the sovereignty is held by an alliance your corporation is not in.','',''),('Busy','audio','','res:/sound/ui/GlassyBeep25.wav',''),('BusyItems','info','Information::All items are busy','',''),('CallGroupLocked','info','Call group locked::You are already performing a %(othermethod)s call, or another call within the same locking group (%(group)s) and scope (%(scope)s) as %(thismethod)s.','',''),('CannotAbort','notify','Cannot Abort','',''),('CannotAcceptOwnMission','notify','You cannot accept a mission that you have issued.','',''),('CannotAccessActiveStructure','notify','You cannot take items from this structure because it is active.','',''),('CannotAccessChargeWhileInUse','notify','You cannot remove that while the module is still active.','',''),('CannotAccessShipHangar','notify','You cannot do that because you are not a fellow corporation member of the pilot, or in their fleet (if they have allowed fleet members access).','',''),('CannotAccessShipWhileNotPiloting','notify','You cannot do that because you are not piloting the ship and do not have access to it.','',''),('CanNotActivateModuleWhileBeingRepaired','notify','You can not activate %(moduleName)s while it is being repaired.','',''),('CannotActivateOnThat','notify','You cannot activate %(tool)s on %(target)s.','',''),('CannotAddNonAsteroidsInPlatform','notify','You can only refine ore in this refinery.','',''),('CannotAddNonIngredientsInPlatform','notify','You can only put things in a construction platform that will be used in the process of constructing whatever it makes.  %(type)s is not used in this process.','',''),('CannotAddNonMineralsInPlatform','notify','You can only put minerals in a construction platform.','',''),('CannotAddShipTypeToMaintainanceBay','notify','Only ships of the following classes can fit inside the ship maintenance bay: Mining Barges, Exhumers, Industrials and Transports ','',''),('CannotAddToThatLocation','notify','You cannot move items into that location.','',''),('CanNotAddTypeToCargoContainerOfType','info','Not A Good Idea::It\'s not a good idea to place a %(itemTypeName)s in a %(containerTypeName)s. The %(itemTypeName)s will not survive intact, if transported in such a container.','',''),('CanNotAdoptWarsAsCorpHasDesclaredWarsInProgress','info','Failed to Adopt Wars::The wars of the corporation could not be adopted as the corporation has wars they declared which are still in progress.','',''),('CannotApplyBounty','info','Cannot place bounty::CONCORD only accepts bounties on people with security rating %(seclevel)s or lower.','',''),('CannotBoardAsPilot','notify','Whoa there! You are not allowed in the cockpit. Please take a seat in the passenger area.','',''),('CanNotChangeEndedWar','info','Request denied::You cannot change the mutual state of this war as it is either ending or has ended.','',''),('CanNotChangeMutualWarWrongParty','info','Request denied::You cannot change the mutual state of this war as you are a member of the declaring side.','',''),('CannotChangeWhileActive','info','Can\'t change while active::Can\'t change that setting while structure is active. <br>Please offline the structure and try again.','',''),('CanNotChooseExecutorAsDictatorial','info','Disallowed::This alliance is dictatorial, you can not declare support for any other corporation in it than the current executor.','',''),('CannotCramPhysicalStuffIntoComputer','info','This doesn\'t fit::A %(typename)s cannot fit inside a wallet or NeoCom.','',''),('CanNotCreateCorpAtPlayerOwnedStation','info','Not Here::SEC regards the location you are in as being part of a territorial dispute. You can not create a corporation at this station as the HQ of the corporation would be set as being at this station. This would be a blatant breach of SEC rules. Due to this you can not create a corporation here.','',''),('CannotCreateCorporation','info','Cannot Create Corporation::You cannot create a corporation. Perhaps you do not have required skills or you lack sufficient funds to create a corporation. Creating a corporation requires %(cost)s ISK.','',''),('CanNotDeclareExecutorInFirstWeek','info','Declare Support::You can only choose an executor after your corporation has been a member for a week.','',''),('CanNotDeclareWarAgainstSelf','notify','Cannot declare war on self::You know, there are easier ways to kill yourself than declaring war.<br><br>\nWhy not find a nice airlock to jump out of or something?','',''),('CanNotDeclareWarAgainstThem','info','Can Not Declare War Against Them::You can not declare war against them. It might be that they have just dispanded or if it is a corporation, that they have just joined an alliance.','',''),('CanNotDeleteCEO','info','They\'re Still Alive!::You can\'t delete a character that is the CEO of a corporation. If the corporation still has other members, you need to promote one of them to CEO. If the corporation has no other members, the character may leave the corporation.','',''),('CanNotDeleteCharacterForUnknownReason','info','Termination Not Possible::The character cannot be terminated at the moment due to an unknown technical reason.','',''),('CannotDeleteObjectNPCAttached','info','Information::Cant delete object. Perhaps there are NPCs attached. Use ESP to remove','',''),('CanNotDeletePilotShipHasPassengers','info','Termination Not Possible::You cannot terminate this character at the moment as they are piloting a ship that has passengers. Get rid of the passengers and then try again.','',''),('CanNotDeleteUnlessInAStation','info','Still Alive!::You can only terminate a character that is in a station.','',''),('CannotDeliverNonCorp','info','Does not belong to corp::You cannot deliver this item as it does not belong to your corporation. Make sure the items you are delivering are in a corporation hangar.','',''),('CanNotDestroyCorpInAlliance','info','Can Not Destroy Corporation::Your corporation can not be destroyed as it is a member of an alliance. To continue please leave the alliance and then try again.','',''),('CanNotDestroyCorpOutstandingContracts','info','Cannot close corp::This corporation has outstanding contracts. Finish them before closing the corporation.','',''),('CannotDestroyFittedItem','notify','You cannot destroy that type of fitted item.','',''),('CannotFitBroken','info','The %(typename)s cannot be fitted. It\'s damaged beyond repair.','',''),('CannotFitDamaged','info','The %(typename)s cannot be fitted because it\'s damaged.','',''),('CannotJettisonItem','notify','The %(item)s cannot be jettisoned. Only items in the cargo hold can be jettisoned.','',''),('CanNotJoinCorpAlreadyAMember','info','No Need For That::You are currently a member of %(corporation)s, so applying for membership doesn\'t make much sense.','',''),('CanNotJoinNonNPCCorp','info','Request Denied::%You must submit an application to join (corporationName)s ','',''),('CanNotJoinNPCCorp','info','Request Denied::%(corporationName)s are not accepting applications currently','',''),('CannotLoadActiveLauncher','notify','You cannot load or unload %(item)s while it is active.','',''),('CanNotManageStationAsItIsNotYours','info','Not Your Station::You cannot manage this station as it does not belong to your corporation.','',''),('CannotMergeDifferentVouchers','info','Can\'t Merge Those Items::Those items cannot be merged because they are not of the same type.','',''),('CannotMergeSingletonItems','notify','Those items are not stackable.','res:/Sound/ui/voc/CannotMergeSingletonItems.ogg',''),('CannotMixDrones','info','You can not mix different types of drones in the same group','',''),('CanNotOverloadModuleOnShipThatHasModuleRepair','notify','You can not overload %(moduleName)s while modules on the ship are being repaired.','',''),('CannotPerformOnMultipleItems','info','Need single stack::You cannot perform this action on multiple item stacks.','',''),('CanNotPlaceActiveShipInAnotherHangar','info','Flying Between Hangars!::You can\'t fly your active ship into someone elses hangar. If you have another ship then activate the other ship, and try again. If you do not have another ship then get one and activate that ship and try again.','',''),('CannotPlaceInLowShieldTower','notify','You cannot put %(item)s into the %(type)s while it is reinforced or has a shield level lower than %(level)d%%.','',''),('CannotPlaceInOfflineStructure','notify','You cannot put %(item)s into the %(type)s while it is offline and it\'s control tower is reinforced or could become reinforced due to the current shield level.','',''),('CannotPlaceInOperatingStructure','notify','You cannot put %(item)s in the %(type)s while it is active.','',''),('CannotPlaceInReinforcedStructure','notify','You cannot put %(item)s into the %(type)s while it is reinforced.','',''),('CannotPlaceInUnanchoredStructure','notify','You cannot put %(item)s into the %(type)s while it is unanchored.','',''),('CannotPlacePilotedShipInStructure','notify','This %(container)s cannot accept the %(type)s as it still has a pilot inside it.','',''),('CannotPlaceTypeInFuelBay','notify','Incorrect Fuel Type::You cannot place %(type)s in this fuel bay. ','',''),('CannotPlaceTypeInStructure','notify','This %(container)s can only contain one or more specific types of which the %(type)s you gave was not one.','',''),('CannotPlaceUnassembledShipInSMA','notify','%(container)s cannot accept the %(type)s unless it has been assembled.','',''),('CannotPostPetition','info','You Are Not Allowed To Petition::%(text)s','',''),('CannotRemoveActivatedModule','notify','You cannot remove a module while it is still activated.','',''),('CannotRemoveFromLowShieldTower','notify','You cannot remove %(item)s from the %(type)s while it is reinforced or has a shield level lower than %(level)d%%.','',''),('CannotRemoveFromOfflineStructure','notify','You cannot remove %(item)s from the %(type)s while it is offline and it\'s control tower is reinforced or could become reinforced due to the current shield level.','',''),('CannotRemoveFromReinforcedStructure','notify','You cannot remove %(item)s from the %(type)s while it is reinforced.','',''),('CannotRemoveFromThatLocation','notify','You cannot remove items from that location.','res:/Sound/ui/voc/CannotRemoveFromThatLocat.ogg',''),('CannotRemoveFromUnanchoredStructure','notify','You cannot remove %(item)s from the %(type)s while it is unanchored.','',''),('CannotRemoveItem','error','Ooops::You can not remove the item as it is not yours.','',''),('CannotRemoveModuleReactivationDelayed','notify','You cannot remove %(item)s as it is still recovering from its last period of operation and will be for the next %(delay)0.1f seconds.','',''),('CannotRemoveModuleReactivationDelayed2','notify','You cannot remove this module as it is still recovering from its last period of operation and will be for the next <b>%(t)s</b>.','',''),('CannotRemoveModuleWithLoadedCharges','notify','You cannot remove a module while it is still loaded with charges.','',''),('CannotRemoveUpgradeManually','info','Cannot unfit::You cannot unfit an upgrade without destroying it. <br>\nYou can destroy it by right clicking on the upgrade and selecting \"Destroy\".<br><br>\nYou can also destroy all your ship\'s upgrades by reprocessing or repackaging the ship.','',''),('CanNotRepackageALSC','info','Cannot Repackage::The Audit Log Secure Container can not be repackaged as it has a log entry that is less than three weeks old.','',''),('CanNotRepairWhileModuleIsActive','notify','You can not repair %(moduleName)s while it is active','',''),('CanNotRepairWhileModuleIsOnline','notify','You can not repair %(moduleName)s while it is active','',''),('CanNotRepairWhileModulesOverloaded','notify','You can not repair module while one or more modules on your ship are overloaded','',''),('CanNotReprocessALSC','info','Cannot Reprocess::The Audit Log Secure Container can not be reprocessed as it has a log entry that is less than three weeks old.','',''),('CanNotRetractRetractedWar','info','Can Not Retract War::The war can not be retracted because it has been already retracted.','',''),('CanNotRetractWarYouDidNotDeclare','info','Can Not Retract War::The war can not be retracted because you did not declare it.','',''),('CannotSelfDestruct','notify','You can only self-destruct your own ships.','',''),('CannotSellActiveShip','notify','You can\'t sell your active ship.','res:/Sound/ui/voc/CannotSellActiveShip.ogg',''),('CannotSendMsgToMarket','info','Market does not accept any messages at this time','',''),('CanNotSetHQAtPlayerOwnedStation','info','HQ not moved::SEC regards the location you are in as being part of a territorial dispute. SEC rules forbid HQs of corporations being created in or relocated to disputed territories. Due to this you can not move your HQ here.','',''),('CannotSplitStackNotInHangar','info','Not in Hangar::You cannot split this stack as it is not in your corporation hangar.','',''),('CannotStoreCapsule','notify','You cannot store your capsule there because it is not practical.','',''),('CannotStoreCargoNotEmpty','notify','You cannot store your %(ship)s while there are assembled containers in its cargo hold (because of graviton harmonics).','',''),('CannotStoreContainsCargo','info','Cannot store ship::You cannot store a ship that contains cargo other than charges inside a Ship Maintenance Bay.<br>\nPlease remove cargo from the ship and try again.','',''),('CannotStoreDestinationUnsuitable','notify','You cannot store your %(ship)s in the %(dest)s as it has no capacity to store that inside it.','',''),('CanNotSupportCorpNotMember','info','Declare Support::The selected corporation can not be picked as they are not a member.','',''),('CanNotSurenderWarYouAreNotIn','info','Can Not Surrender::You can not surrender because you are not involved in this war.','',''),('CanNotSurrenderAsWarIsOver','info','blah.','Can Not Surrender::You can not surrender because the war is over.',''),('CanNotSurrenderToAllianceInTurmoil','info','Can Not Surrender::You cannot surrender as the alliance you are fighting is in a state of turmoil and currently has no executor.','',''),('CannotTakeNotInCorp','notify','You cannot remove items from that container because it is owned by %(owner)s and you have not been granted permission.','',''),('CannotTalkToMarket','info','There is no agent available at the market','',''),('CannotTrashLockedItem','info','Item is locked::You cannot trash this item because it is locked.','',''),('CanNotUnassebleDamagedItem','info','Damaged Item::The item in question can not be unassembled as it is damaged. Please repair the item completely first and then try again.','',''),('CanNotUnassembleInThisItemLoc','info','Fitted Item::The item in question can not be unassembled as it is installed in a ship. Please remove the item first and then try again.','',''),('CanNotUnassembleThisItemType','info','Not Possible::It is not possible to unassemble the requested type of item.','',''),('CanOnlyAcceptNewApplications','notify','You can only accept new applications.','',''),('CanOnlyCreateCorpInStation','info','Cannot Create Corporation Here::A corporation can only be created in a station. The station where the corporation is created is its headquarters. Please try again when you are docked at a station.','',''),('CanOnlyCreateVoucherInPersonalHangar','info','Cannot Create Voucher::Bookmark Vouchers can only be created in your personal hangar or in containers belonging to you.','',''),('CanOnlyDoInStations','info','Can only do in stations::The action you are trying to perform can only be accomplished in a station.','',''),('CanOnlyDoToTrial','info','Can only do to Trial Users::The action you are trying to perform can only be done to Trial User Accounts.','',''),('CanOnlyRejecteNewOrAcceptedApplications','notify','You can only reject new or accepted applications.','',''),('CanOnlyScoopIdlers','notify','Your %(targetGroupName)s is currently busy, you need to wait until it is idle before you can scoop it.','',''),('CanOnlyScoopIfUnanchored','notify','You cannot scoop that %(group)s because it is anchored.','',''),('CanOnlyScoopIncapacitateds','notify','You can only scoop %(targetGroupName)s that you do not own when they have been incapacitated, this one is not.','',''),('CantActivateReloadingModule','notify','You cannot activate the %(module)s while it is being loading with charges.','',''),('CantActivateWithActiveSystems','notify','Your ship has active systems which prevent the activation of this module. They are: %(moduleNames)s. The last system will deactivate in %(time)d seconds, try again then.','',''),('CantAddChargeQuantityChanged','notify','You cannot fit the charges as they have been touched since the request was made to do so.','',''),('CantAddStructureLimitedTo','notify','You cannot place the %(actual)s inside the %(structure)s as it can only hold %(desired)s.','',''),('CantAddStructureLimitedToReactionGroup','notify','You cannot place this type of reaction in this reactor.','',''),('CantAddWhileBuilding','notify','You cannot add items into the %(group)s because it is in the process of constructing %(type)s.','',''),('CantAnchorConcordRestriction','notify','In compliance with the CONCORD \'clean spacelanes\' resolution, anchoring software upgrades forbid anchoring in solarsystems with 0.8 security level or higher. This solar system has the security level of %(security)0.1f, so anchoring is not possible.','',''),('CantAnchorConcordRestriction01','notify','In compliance with the CONCORD \'public resource consent\' resolution, anchoring software upgrades forbid anchoring of objects of the given type in solarsystems with 0.1 security level or higher. This solar system has the security level of %(security)0.1f, so anchoring is not possible.','',''),('CantAnchorConcordRestrictionSpecific','notify','In compliance with the CONCORD \'public resource consent\' resolution, anchoring software upgrades forbid anchoring of objects of the given type in solarsystems with %(high)0.1f security level or higher. This solar system has the security level of %(actual)0.1f, so anchoring is not possible.','',''),('CantAnchorGlobalNearby','notify','You cannot anchor the %(direct)s because it would be closer than %(dist)skm from %(indirect)s.','',''),('CantAnchorMoonAlreadyHasControlTower','notify','You are unable to anchor the %(tower)s at %(moon)s as there is already a control tower anchored there.','',''),('CantAnchorMultipleStructures','notify','Your corporation cannot have more than one %(type)s anchored in the same solar system.','',''),('CantAnchorNoMoonNearby','notify','You cannot anchor the control tower there as there is no moon nearby and this model is designed for use in orbit of a moon.','res:/Sound/ui/voc/CantAnchorNoMoonNearby.ogg',''),('CantAnchorPositionObstructed','notify','You cannot anchor the %(item)s there as something is in the way: %(obstruct)s','',''),('CantAnchorRequiresAlignment','notify','You cannot anchor that structure there because that position is not in alignment.','',''),('CantAnchorRequireTower','notify','The %(item)s cannot be anchored unless it is within a given distance of a nearby control tower.  If a control tower is nearby, please check its maximum control distance and ensure this object is within it.','',''),('CantAnchorStandingLow','notify','You cannot anchor that structure because %(owner)s, who hold sovereignty, require your corporation to have a standing of %(want)0.1f from them.  Your corporation\'s standing is too low at %(have)0.1f.','',''),('CantAnchorStarbasePositionObstructed','notify','You cannot anchor the %(item)s there as something is in the way: %(obstruct)s.  The presence of this object renders this moon unsuitable as a starbase location.','',''),('CantAnchorStructureGroupLimit','notify','You are unable to anchor the %(type)s as only %(limit)s structures of that kind can be anchored for your alliance in this solar system at the same time, and there are already that many anchored.','',''),('CantAnchorStructureOwnerBad','notify','You cannot anchor the %(what)s because the control tower will not accept it due to ownership differences.  The control tower requires all structures to be owned by %(whom)s.','',''),('CantAnchorStructureRequiresSovereignty','notify','You cannot anchor the %(structure)s here because it can only be anchored in solar systems where your alliance holds sovereignty.','',''),('CantAnchorStructureRequiresSovereigntyLevel','notify','You cannot anchor the %(structure)s here because it can only be anchored in solar systems where your alliance holds sovereignty at level %(level)s.','',''),('CantAnchorStructureRestrictionSpecific','notify','In compliance with the CONCORD \'public resource consent\' resolution, anchoring software upgrades forbid anchoring of objects of type %(type)s in solarsystems with %(high)0.1f security level or higher. This solar system has the security level of %(actual)0.1f, so anchoring is not possible.','',''),('CantAnchorStructureTypeForSelf','notify','You cannot anchor the %(structure)s for yourself, you can only anchor the %(structure)s for yourself.','',''),('CantAnchorTooDistant','notify','You cannot anchor the %(structure)s at a position more than %(limit)sm from your ship, the selected position is %(actual)sm distant.','',''),('CantAnchorTooManyMoonsNearby','notify','You cannot anchor the control tower there as there are too many moons within range which will interfere with its operation: %(moons)s','',''),('CantAnchorTowerInvalidStructures','notify','You cannot anchor the control tower because there are one or more structures present in states that interfere, one of which is: %(item)s.','',''),('CantAnchorTowerObstruction','notify','You cannot anchor the control tower because there are one or more objects anchored within %(distance)d of the position you are trying to anchor at, one of which is: %(item)s.','',''),('CantAnchorTowerProximity','notify','You cannot anchor the %(structure)s here because it cannot be anchored within %(limit)d meters from the control tower and it is %(actual)d meters away from it.','',''),('CantAnchorTowerRequiresResources','notify','The %(what)s cannot be anchored because it requires the following resources to be present in your cargo hold: %(resources)s.','',''),('CantApplyToAllianceHaveDeclaredWars','info','Can Not Make Application::You can not file an application with an alliance at the moment as you have one or more wars which you have declared.','',''),('CantApplyToAllianceYouAreAtWarWith','info','Can Not Apply to Join Alliance::You can not apply to join the alliance as you are at war with them.','',''),('CantApplyTwiceToAlliance','info','Already Applied::You have already applied to join that alliance.','',''),('CantAssembleInSpaceWithoutFacilities','info','Action Failed::You cannot assemble ships in space while there are no usable facilities nearby.','',''),('CantAssembleShipContainerSpace','info','Action Failed::You cannot assemble using the facilities of the %(type)s because  it does not belong to you, a fellow corporation member or a fellow fleet member (if the ship is configured to allow that).','',''),('CantAssistPods','notify','You can not set your drones to assist an escape pod','',''),('CantBoardTargeted','notify','You cannot board a ship that does not belong to you while it is being targeted.','',''),('CantbookmarkEveSystem','info','Information::Sorry, but EVE System doesn\'t like to be bookmarked.','',''),('CantBridgeAttemptInProgress','notify','You cannot link those two structures at this time.  There is already an attempt to link one or more of them active.  Please try again in a minute or so.','',''),('CantBridgeDifferentTypes','info','Bridge to different structure type:: The bridging to different structure types is not allowed, you are bridging a %(sourceTypeName)s to a %(destTypeName)s whilst you need to bridge it to a %(sourceTypeName)s.','',''),('CantBridgeInvalidJumpPortal','info','Invalid Structure::The %(structure)s in %(system)s cannot be used to form a jump bridge, because it is the wrong type of structure.','',''),('CantBridgeJumpPortalGone','info','Invalid Structure::The %(structure)s in %(system)s cannot be used to form a jump bridge, because it is no longer present.','',''),('CantBridgeJumpPortalLinked','info','Portal Already Linked::The %(structure)s in %(system)s is already linked to another and cannot be linked again unless the preexisting link is removed.','',''),('CantBridgeJumpPortalNotAnchored','info','Portal Unsuitable::The %(structure)s in %(system)s needs to be anchored and offline, in order to be able to be linked.','',''),('CantBridgeTooFar','info','Bridge Too Far:: The bridging distance would be %(dist)s lightyears but the %(structure)s can only bridge over %(range)s lightyears.','',''),('CantBuildNoPlanetNearby','notify','You cannot starting building using the construction platform there as there is no planet nearby and this model is designed for use in the orbit of a planet.','res:/Sound/ui/voc/CantBuildNoPlanetNearby.ogg',''),('CantBuildTooManyPlanetsNearby','notify','You cannot build the control tower there as there are too many planets within range which will interfere with its operation: %(planets)s','',''),('CantChangePasswordToSame','notify','Your password is already set to that.','',''),('CantChangeShipHarmonicWithinForceField','notify','You cannot change your ship harmonic while your ship is inside of a force field or the resulting forces would tear it apart (your ship that is).','',''),('CantCloakModuleActive','notify','You can\'t cloak because the module %(module)s is active','',''),('CantCloakNoDevice','notify','You cannot cloak your ship without a cloaking device.','',''),('CantCloakPolicePursuit','notify','Your cloaking systems are being jammed by police who are currently in pursuit of you.','',''),('CantCloakProximity','notify','Your cloaking systems are unable to activate due to your ship being within %(dist)d meters of the nearby %(item)s.','',''),('CantCloakTargeted','notify','You cannot cloak your ship as you are being targeted by someone.','res:/Sound/ui/voc/CantCloakTargeted.ogg',''),('CantCloakTargeting','notify','You cannot cloak your ship while you have targets locked.','res:/Sound/ui/voc/CantCloakTargeting.ogg',''),('CantCloakTooManyDevices','notify','You cannot cloak your ship with more than one cloaking device installed.  The interference from one device being installed prevents any other from working.','',''),('CantCloakTooShipUnsuitable','notify','One or more module is making this ship unable to cloak','',''),('CantConfigureCorpInfrastructureRoleLacking','notify','You cannot perform that action on that object as you do not have the required role in your corporation, Starbase Defense Operator','',''),('CantConfigureCorpRoleLacking','notify','You cannot perform that action on that object as you do not have the required role in your corporation, Equipment Config.','',''),('CantConfigureCorpStarbaseOrCaretakerRoleLacking','notify','You cannot perform that action on that object as you do not have either of the required role in your corporation, <b>Config Starbase Equipment</b> or <b>Starbase Fuel Technician</b>.','',''),('CantConfigureCorpStarbaseRoleLacking','notify','You cannot perform that action on that object as you do not have the required role in your corporation, <b>Config Starbase Equipment</b>.','',''),('CantConfigureDistant','notify','You cannot perform that action on that object as it is too far away.','res:/Sound/ui/voc/CantConfigureDistant.ogg',''),('CantConfigureDistant2','notify','You cannot perform that action on that object as it is %(actual)dm away and you need to be within %(needed)dm of it.','',''),('CantConfigureNotInAlliance','notify','You cannot perform that action on that object as you do not belong to the %(alliance)s alliance, who the owning corporation is allied with.','',''),('CantConfigureNotInCorp','notify','You cannot perform that action on that object as you do not belong to the %(corp)s corporation, who own it.','',''),('CantConfigureNotOwner','notify','You cannot perform that action on that object as you are not the owner.','res:/Sound/ui/voc/CantConfigureNotOwner.ogg',''),('CantConfigureThat','notify','That type of object cannot be operated in that way.','res:/Sound/ui/voc/CantConfigureThat.ogg',''),('CantConfigureTooDistant','notify','You cannot do that because you need to be within %(distance)d meters of the control tower, you are instead %(actual)0.0f meters away from it.','',''),('CantDockAfterAggression','notify','The station denies you permission to dock for the moment due to your recent acts of aggression.','res:/Sound/ui/voc/DockingDenied.ogg',''),('CantDockGlobalCriminalFlag','info','Cannot Dock::You are a criminal and this station will not allow you to dock. The criminal timer will run out %(time)s.','',''),('CantDockWhileCloaked','notify','You fail to dock because you are cloaked.','res:/Sound/ui/voc/CantDockWhileCloaked.ogg',''),('CantDockWhileModuleActive','notify','You are unable to dock because while %(moduleType)s is active your docking systems are unusable.','',''),('CantDoThatInCapsule','notify','In order to perform that action, you need to be piloting a proper ship and not a pod.','',''),('CantDoThatNoOutpostNearby','notify','You cannot do that action because in order to do so, an outpost is required to be within %(distance)s meters, and this is not the case.','',''),('CantDoThatNoShip','notify','In order to do that action, you need to be inside a ship or even a pod.  Please find one and board it.','',''),('CantDoThatTransit','notify','An operation failed because your ship is in transit.','',''),('CantDoThatWithSomeoneElsesStuff','notify','You can only perfrom the selected action from your own hangar. Drag the item into your hangar and then try again.','',''),('CantDoWhileNotAnchored','notify','You cannot do that while the %(item)s is unanchored or in the process of being unanchored.','',''),('CantFindChargeToAdd','notify','Unable to locate the charge you are trying to move.','',''),('CantFindItemToAdd','notify','You fail to move that because it is no longer within your reach.','',''),('CantFitModuleToThatShip','notify','You can\'t fit %(item)s to %(ship)s','',''),('CantFitShipContainerSpace','info','Action Failed::You cannot fit using the facilities of the %(type)s because  it does not belong to you, a fellow corporation member or a fellow fleet member (if the ship is configured to allow that).','',''),('CantFitToCapsule','notify','You cannot fit modules to a capsule.  It is a survival craft that does not have the space or facilities to take advantage of fittings.','',''),('CantGuardPods','notify','You can not set your drones to guard an escape pod','',''),('CantInEmpireSpace','notify','You cannot do that because it is currently against empire policy to launch, anchor or control objects of that type within their jurisdictions.','res:/Sound/ui/voc/CantInEmpireSpace.ogg',''),('CantInEmpireSpace2','notify','You cannot do that because it is currently against empire policy to control objects of that type within their jurisdictions.\n','res:/Sound/ui/voc/CantInEmpireSpace.ogg',''),('CantJoinCorpWrongRaceAndCEOWithoutSkill','info','Request Denied::You cannot join this corporation as you are %(charRaceName)s and this corporation only accepts the following races: %(races)s. If the CEO has the skill %(skillName)s, this would not be a problem.  <br><br>Notice: The CEO must update his corporation through the corporation user interface before the skill takes effect.','',''),('CantJumpAfterAggression','notify','The stargate denies you permission to jump for the moment due to your recent acts of aggression.','res:/Sound/ui/voc/CantJumpAfterAgression.ogg',''),('CantJumpGlobalCriminalFlag','info','Cannot Jump::You are a criminal and this stargate will not allow you to jump. The criminal timer will run out %(time)s.','',''),('CantJumpJumpPortalAccessRestricted','notify','You are unable to jump through the jump portal, as you do not have access to do so.  Either join the corporation or obtain the starbase force field password.','',''),('CantJumpJumpPortalObservesTowerSettings','notify','You cannot jump through the jump portal because the tower is set to consider you someone who should be attacked on sight.','',''),('CantJumpJumpPortalOffline','notify','You cannot jump because the %(structure)s in %(system)s is offline.','',''),('CantJumpWhileCloaked','notify','You fail to jump because you are cloaked.','res:/Sound/ui/voc/CantJumpWhileCloaked.ogg',''),('CantJumpWhileModuleActive','notify','Your jump drive is unusable while <b>%(moduleType)s</b> is active.','',''),('CantJumpWithJumpDrive','notify','This class of ship is too large to use stargates','',''),('CantLaunchContainerIncompatible','notify','You cannot launch items from the %(structure)s.','',''),('CantLaunchContainerNotPresent','notify','The object you are trying to launch from is not present.','',''),('CantLaunchCorpDoesntAllow','notify','You can\'t launch that on behalf of the %(corp)s corporation because they do not allow it.','',''),('CantLaunchInsideForcefield','notify','You cannot launch that while you are inside a force field.','',''),('CantLaunchItemNonSingleton','notify','You cannot launch %(what)s because it cannot be assembled in the %(where)s.','',''),('CantLaunchItemNotPresent','notify','You cannot launch %(what)s because it is not in the %(where)s.','',''),('CantLaunchItemUnlaunchable','notify','You cannot launch %(what)s because the %(where)s does not support it.','',''),('CantLaunchNotInCorp','notify','You can\'t launch that on behalf of the %(corp)s corporation because you are not a member.','',''),('CantLaunchNotOwner','notify','You can\'t launch that on behalf of that owner as you are not them.','',''),('CantLootThat','notify','Your ship is not capable of looting from a %(targetGroupName)s.','',''),('CantMoveActiveShip','info','Can\'t Move Active Ship::You can\'t move your active ship out of your ship hangar.','',''),('CantMoveDBLessDirectly','notify','You cannot move the selected item there.  This item needs to be moved out of the ship before it can be moved to the desired destination.','',''),('CantObjectInsideForceField','notify','You cannot do that as the %(ob)s is not within your reach, inside a force field you are unable to penetrate.','',''),('CantOnlineDamagedGoods','notify','You cannot bring a damaged structure online, it has to be in pristine condition to ensure it can link to the control tower.  The %(what)s is %(damage)d%% damaged.','',''),('CantOnlineNotLinked','notify','You cannot online the %(structure)s as it needs to be bridged first.  Bridge it to another %(structure)s in another solar system.','',''),('CantOnlineRequireTower','notify','The %(item)s cannot be brought online without a control tower close enough to provide the necessary resources. If a control tower is nearby, please check its maximum control distance and ensure this object is within it.','',''),('CantOnlineStructureGroupLimit','notify','You are unable to online the %(type)s as only %(limit)s structures of that kind can be online for your alliance in this solar system at the same time, and there are already that many online or onlining.','',''),('CantOnlineStructureOwnerBad','notify','You cannot bring online the %(what)s because the control tower will not accept it due to ownership differences.  The control tower requires all structures to be owned by %(whom)s.','',''),('CantOnlineStructureRequiresSovereigntyLevel','notify','You cannot online the %(structure)s here because it can only be onlined in solar systems where your alliance holds sovereignty at level %(level)s.','',''),('CantOnlineTowerLacksCpuResources','notify','The %(what)s cannot be brought online because it requires cpu from the %(tower)s, and you have not provided any of the relevant resources for the control tower to consume.','',''),('CantOnlineTowerLacksPowerResources','notify','The %(what)s cannot be brought online because it requires power from the %(tower)s, and you have not provided any of the relevant resources for the control tower to consume.','',''),('CantOnlineTowerLacksResources','notify','The %(tower)s cannot be brought online because the resources required, %(resource)s, are not present in sufficient quantities to power it.','',''),('CantPasteThatMuch','info','Text Too Long::The text in the clipboard is %(len)s characters long, while maximum paste allowed is %(max)s. The text will be clipped.','',''),('CantPerformTowerReinforced','notify','You cannot do that at this time as the %(tower)s is locked down in reinforced mode.','',''),('CantPerformTowerShieldFluctuations','notify','You cannot do that at this time as the %(tower)s is either reinforced or the shield level is below 50%%.','',''),('CantPilotAShipInCorpHangar','notify','The piloting of ships within corporation hangars is strictly forbidden.','',''),('CantPilotWithActivateSystems','notify','The ship you are trying to board has active systems which prevent the connection of a pilot. They are: %(moduleNames)s. The last system will deactivate in %(time)d seconds, try again then.','',''),('CantRemoveHandicap','notify','Removing this handicap would leave you with negative points. Remove some of your benefits first.','',''),('CantRemoveStuffFromCharacter','fatal','It requires a qualified physician to remove anything plugged into yourself.','',''),('CantRepackageDamagedItem','info','Item Is Damaged::The item can not be repackaged as it is damaged. Please take the item to a repair shop and have it fixed before trying again.','',''),('CantRunForCEOAtTheMoment','info','You Cannot Run For CEO At The Moment::You cannot run for CEO. This might be because you lack the skills required, because you don\'t have sufficient number of shares or because there was a vote for a new CEO recently.','',''),('CantScoopAnchoring','notify','You cannot scoop the %(group)s while it is being anchored.','',''),('CantScoopNotInCorp','notify','You cannot scoop that as you are not a member of %(corp)s, who own it.','',''),('CantScoopOwnerNpc','notify','You cannot scoop the %(group)s because it belongs to EVE System or an NPC corporation.  You should not be seeing this message, but if you are and you put that object there, fix it.','',''),('CantScoopThat','notify','Your ship is not capable of scooping up a %(targetGroupName)s.','',''),('CantSellRemote','info','Cannot Sell That::You can only offer items that are located in the same station as you.','',''),('CantSetPasswordTooLong','notify','You cannot set that password as it is too long, at most this password can only be %(count)d characters.','',''),('CantShipDestroyed','notify','You cannot do that as %(item)s no longer exists.','',''),('CantShipNotPresent','notify','Your ship is no longer in the same location, so whatever it was you were trying to fails.','',''),('CantStructureIncapacitated','notify','The %(item)s cannot do that at this time as it is current incapacitated.','',''),('CantSurrenderCEONotAtStationPageInstead','question','Can\'t Negotiate::You cannot negotiate a surrender as %(name)s is not at this station. Do you want to page them instead?','',''),('CantTakeCharSecurityStatusTooHigh','info','Security Status::You can\'t take that as you are far too trust worthy and sensible. Your security status is so high you can\'t take things from here.','',''),('CantTakeCharSecurityStatusTooLow','info','Security Status::If you were nicer to %(from)s you might get away with that. Unfortunately with a security status like yours we can\'t let you take that.','',''),('CantTakeCharStandingTooLow','info','Security Status::If you were nicer to %(from)s you might get away with that.','',''),('CantTakeCorpSecurityStatusTooHigh','info','Security Status::Your corporation\'s security status is too low for you to do that. You might want to have a word with you Station Manager about this.','',''),('CantTakeCorpSecurityStatusTooLow','info','Security Status::Your Station Manager has prevented anyone from taking stuff from here. Ask your Station Manager to drop the minimum corporation security level for borrowing.','',''),('CantTakeInSpaceCapsule','notify','You are in a capsule, which does not have the facilities to allow you to move items.','',''),('CantTakeShipAsSomeoneElseIsPilot','notify','You cannot take that ship as the pilot\'s seat is taken by %(pilotName)s','',''),('CantTakeThatWithoutCorpRole','notify','Can\'t Take That::You can\'t take that unless you have the role %(roles)s.','',''),('CantTargetWhileCloaked','notify','Your targeting attempt fails because your ship is cloaked.','',''),('CantTargetWhileJumping','notify','Your targeting attempt fails because your ship is jumping.','',''),('CantTowerIncapacitated','notify','The %(item)s cannot do that at this time as the nearby tower is incapacitated.','',''),('CantTowerIsAlreadyActive','notify','You cannot do that at this time as the %(tower)s is already occupied with another task, %(action)s %(structure)s.','',''),('CantTowerNotAnchored','notify','You cannot do that because it requires the nearby tower to be fully anchored.','',''),('CantTowerNotOnline','notify','You cannot do that because it requires the nearby tower to be online.','',''),('CantTradeMissionBookmarks','info','Information::You cannot trade or copy mission bookmarks.','',''),('CantUnanchorBuilding','notify','You cannot unanchor the %(group)s because it is in the process of constructing %(type)s.','',''),('CantUnanchorBuilding2','notify','You cannot unanchor the %(group)s because it is in the middle of the construction process.','',''),('CantUnanchorContainerNotEmpty','notify','%(structure)s cannot be unanchored while it has items still inside it.','',''),('CantUnanchorTowerStructuresPresent','notify','The %(tower)s cannot be unanchored while it still has structures that are anchored around it.','',''),('CantUnbridgeJumpPortalNotAnchored','info','Structure Unready::The %(structure)s in %(system)s needs to be anchored and offline, in order to be able to be unlinked.','',''),('CantUpdateApplicationToStateNew','notify','You can not update an application to state new.','',''),('CantUpdateRejectedApplicationsState','notify','You can not update a rejected application.','',''),('CantUseContainerWhileGuarded','notify','You cannot access the %(item)s while it is being guarded.','',''),('CantUseOfflineStructure','notify','You cannot use the %(structure)s as it needs to be online and is currently not.','',''),('CantUseTooDistant','notify','You cannot do that because you need to be within %(desired)d meters of the %(structure)s, you are instead %(actual)d meters away.','',''),('CantUseTooManyUsersPresent','notify','You cannot do that because the %(structure)s can only operate when at most %(limit)d piloted ships are present and there are currently %(actual)d within operational range of it.','',''),('CantViewShipContainer','info','Action Failed::You cannot view that because you do not own the %(type)s or do not have access to it.','',''),('CantViewShipContainerSpace','info','Action Failed::You cannot view the contents of the %(type)s because it does not belong to you, a fellow corporation member or a fellow fleet member (if the ship is configured to allow that).','',''),('CantWarpAfterShip','notify','Your ship does not have the equipment to warp after another ship.','',''),('CantWarpAfterThat','notify','You are unable to align or warp to the selected object because your warp drive is unable to lock onto it.','',''),('CantWarpWhileCloaked','notify','You cannot warp while you are cloaked.','',''),('CantWarpWithActivatedEffects','notify','You have activated modules which interfere with your warp drive. They are: %(moduleNames)s.','',''),('CapsuleOnBoard','info','You can only board abandoned ships.','',''),('CapsulesCannotCarryCapsules','notify','Capsule cannot be fitted within another capsule.','',''),('CareerBanned','info','Career Banned::Career %(career)s is not allowed for people with %(reason)s.','',''),('CargoContainerImploding','notify','You are unable to put anything in the cargo container because it is imploding.','',''),('CargoContainerNotFound','notify','The %(item)s is not in space nearby and its not in your cargo hold.  Because of this you cannot do whatever it is you were trying.','',''),('CargoContainerSealedInSpace','info','Freight Containers containing valuables must be sealed during transport.','',''),('CargoContainerUnsuitableForItem','notify','You cannot put %(itemGroup)s into a Cargo Container.','',''),('casinoHeader','audio','','res:/sound/ui/uihcasinotxt.wav',''),('CCAncestryDeselect','audio','','res:/sound/ui/CCDeselect.wav',''),('CCAncestryEnter','audio','','',''),('CCAncestrySelect','audio','','res:/sound/ui/Menter.wav',''),('CCAppCloseMenu','audio','','res:/sound/ui/CCAppCloseMenu.wav',''),('CCAppMenuEnter','audio','','res:/sound/ui/CCAppMenuEnter.wav',''),('CCAppMorphing','notify','','',''),('CCAppOpenMenu','audio','','res:/sound/ui/CCAppOpenMenu.wav',''),('CCAppRandom','audio','','res:/sound/ui/CCApprandom.wav',''),('CCAppRandomMorph','audio','','',''),('CCAppSelect','audio','','res:/sound/ui/CCAppSelect.wav',''),('CCAttrMinus','audio','','res:/sound/ui/CCAttrMinus.wav',''),('CCAttrPlus','audio','','res:/sound/ui/CCAttrPlus.wav',''),('CCBloodlineEnter','audio','','res:/sound/ui/CCBloodlineEnter.wav',''),('CCCancel','audio','','res:/sound/ui/CCCancel.wav',''),('CCCellEnter','audio','','res:/sound/ui/CCMenter.wav',''),('CCDepartmentEnter','audio','','res:/sound/ui/CCMenter.wav',''),('CCFieldEnter','audio','','res:/sound/ui/CCMenter.wav',''),('CCFormationDeselect','audio','','res:/sound/ui/CCDeselect.wav',''),('CCFormationEnter','audio','','res:/sound/ui/CCMenter.wav',''),('CCFormationSelect','audio','','res:/sound/ui/CCSelect.wav',''),('CCGenderEnter','audio','','res:/sound/ui/CharSelSlotEnter2.wav',''),('CCNewChar','audio','','res:/sound/ui/CCNewChar.wav',''),('CCNext','audio','','res:/sound/ui/CCNext.wav',''),('CCOptionDeselect','audio','','res:/sound/ui/CCOptionDeselect.wav',''),('CCOptionEnter','audio','','res:/sound/ui/CCOptionEnter.wav',''),('CCOptionSelect','audio','','res:/sound/ui/CCOptionSelect.wav',''),('CCPhysicalDeselect','audio','','res:/sound/ui/CCDeselect.wav',''),('CCPhysicalEnter','audio','','res:/sound/ui/CCMenter.wav',''),('CCPhysicalSelect','audio','','res:/sound/ui/CCSelect.wav',''),('CCPlusMinusEnter','audio','','res:/sound/ui/CCRaceEnter.wav',''),('CCPrevious','audio','','res:/sound/ui/CCPrevious.wav',''),('CCRaceEnter','audio','','res:/sound/ui/CCRaceEnter.wav',''),('CCRowEnter','audio','','res:/sound/ui/CCSelect.wav',''),('CCSchoolDeselect','audio','','',''),('CCSchoolEnter','audio','','res:/sound/ui/CCMenter.wav',''),('CCSchoolSelect','audio','','res:/sound/ui/CCSelect.wav',''),('CCSpecialityEnter','audio','','res:/sound/ui/CCMenter.wav',''),('CCTabEnter','audio','','res:/sound/ui/CCTabEnter.wav',''),('CCTabSelect','audio','','res:/sound/ui/ok.wav',''),('CCTerminate','audio','','res:/sound/ui/CCTerminate.wav',''),('CCTerminateForGoodFemale','audio','','res:/sound/ui/CCTerminateForGoodFemale.wav',''),('CCTerminateForGoodFemaleBegin','audio','','',''),('CCTerminateForGoodMale','audio','','res:/sound/ui/CCTerminateForGoodMale.wav',''),('CCTerminateForGoodMaleBegin','audio','','',''),('CellEnter','audio','','res:/sound/ui/CCRaceEnter.wav',''),('CEOCannotCreateCorporation','info','You Cannot Be The CEO Of Two Corporations::You cannot create a new corporation while you are the CEO of another corporation.','',''),('CeoCanNotJoinACorp','info','Not So Fast::You\'re the CEO of %(CEOsCorporation)s so you can\'t join another corporation. If you really want to join %(otherCorporation)s then you will have to find someone else to take over your corporation by means of a shareholder vote.','',''),('CEOCantAddVoteInCEOVotePeriod','info','Access Denied::You cannot propose a vote during a CEO voting period.','',''),('CEOLacksMultiracialManagementSkill','info','Skill Missing::Races other than that of the CEO cannot join this corporation because the CEO lacks the skill: %(skillName)s.','',''),('ChangeDisplay','question','Change display?:s:You changed %(str)s. Do you want to apply the changes?','',''),('ChangeLanguageReboot','question','Switch language?::Changing the language settings will automatically reboot the client for the changes to take effect, do you wish to continue?','',''),('ChangeMapFocus','notify','Changed focus to %(itemname)s','',''),('CharacterAlreadyKnowsSkill','info','You have already trained %(skillName)s and cannot train it a second time.','',''),('CharacterInDifferentRegion','info','%(char)s is located in %(other)s Region. This server here is running %(this)s Region. Sorry \'bout that :)','',''),('CharAlreadyHasSkill','info','You can\'t train this skill because you have already mastered it.','',''),('CharCreateSetName','notify','Please set a name','',''),('CharCreateSetProfession','notify','Please choose a profession','',''),('CharCreationNameError1','info','Information::You have to type some name to be able to proceed.','',''),('CharCreationNameError2','info','Information::%(info)s','',''),('CharCreationNameError3','info','Information::The name contains either illegal characters, is already taken or is not allowed.','',''),('CharCreationNameError_IllegalCharacters','info','Information::The name \'%(name)s\' contains illegal characters.','',''),('CharCreationNameError_MoreThanOneSpace','info','Information::The name \'%(name)s\' contains more than one space.','',''),('CharCreationNameError_NameAlreadyTaken','info','Information::The name \'%(name)s\' is already taken.','',''),('CharCreationNameError_NameBanned','info','Information::The name \'%(name)s\' is banned.','',''),('CharCreationNameError_TooLong','info','Information::The name \'%(name)s\' is too long.','',''),('CharCreationNameError_TooShort','info','Information::The name \'%(name)s\' is too short.','',''),('CharDelNotPrepared','notify','Delete has not been prepared','',''),('CharDelPrepared','notify','Delete has already been prepared','',''),('ChargeLoadingFailedWithRefund','notify','Your %(charge)s failed to load and was returned to your cargo.','',''),('ChargeRequiresLauncher','notify','You cannot load charges into that slot unless a launcher is present.','',''),('CharHammeringSkillTraining','fatal','Your brain, while quite capable of performing many tasks, is still recovering from the ardor of your last skill learning.  <br>Please let your neural receptors rest for up to a minute before training again.','',''),('CharLeaveStation','notify','%(name)s has left the station.','',''),('CharNameInvalid','notify','Character name is not valid.','',''),('CharNameInvalidBannedWord','notify','Character name contains a banned word.','',''),('CharNameInvalidFirstChar','notify','First character in character name is illegal.','',''),('CharNameInvalidLastChar','notify','Last character in character name is illegal.','',''),('CharNameInvalidMaxLength','notify','Maximum length for a character name is 24 characters.','',''),('CharNameInvalidMaxSpaces','notify','Character name can only include 1 space.','',''),('CharNameInvalidMinLength','notify','Minimum length for a character name is 4 characters.','',''),('CharNameInvalidSomeChar','notify','Character name contains an illegal character.','',''),('CharNameInvalidTaken','notify','Character name is already taken.','',''),('CharNameTaken','info','Name %(name)s is already taken. Please choose another one.','',''),('CharNameTooLong','info','Name Too Long::Name may not have more than %(max)s characters.','',''),('CharNameTooShort','info','Name Too Short::The name must be at least 3 characters long.','',''),('CharNotFound','info','Recipient Not Found::There is nobody called %(name)s at the moment.','',''),('CharSecurityStatusTooLow','info','Security Status::You\'re officially too bad to do that.','',''),('CharselSelectBloodline','notify','Please select bloodline.','',''),('CharselSelectGender','notify','Please select gender','',''),('CharselSelectRace','notify','Please select race','',''),('CharSelSlotEnter','audio','','res:/sound/ui/CharSelSlotEnter.wav',''),('CharTerminationBody','info','The untimely death of fellow %(corpName)s member %(charName)s, on %(date)s, is a source of sorrow to me and %(his)s many friends in the corporation. Please accept our deepest sympathies in your bereavement. %(charName)s was being reanimated at the cloning facility at the time when the fatal accident occurred.','',''),('CharTerminationBodyM01','info','%(charName)s was almost a decent %(roleName)s. %(he)s wasn\'t very popular with %(his)s fellow corporation members. %(securityDescription)s This is not a great loss, but a loss none the less.','',''),('CharTerminationBodyM02','info','%(charName)s was a poor %(roleName)s. %(he)s wasn\'t liked much by %(his)s fellow corporation members. %(securityDescription)s This is not a great loss, but a loss none the less. ','',''),('CharTerminationBodyM03','info','%(charName)s was a moderately bad %(roleName)s. %(he)s wasn\'t liked by %(his)s fellow corporation members. %(securityDescription)s This is not that great a loss, but probably for the best.','',''),('CharTerminationBodyM04','info','%(charName)s was a pretty bad %(roleName)s. %(he)s was hated by %(his)s fellow corporation members. %(securityDescription)s This is no great loss, but a loss that is probably for the best.','',''),('CharTerminationBodyM05','info','Lets get this straight %(charName)s was a bad %(roleName)s. %(he)s was hated by %(his)s fellow corporation members. %(securityDescription)s This is not a loss, and probably for the best.','',''),('CharTerminationBodyM06','info','%(charName)s was the worst %(roleName)s that we have known. %(he)s was hated by %(his)s fellow corporation members. %(securityDescription)s This is indeed a time to celebrate. I realize that words can do little to express the jubilation this news brings.','',''),('CharTerminationBodyM07','info','%(charName)s was the worst %(roleName)s that we have known. %(he)s was hated by %(his)s fellow corporation members. %(securityDescription)s This is indeed a time to celebrate. I realize that words can do little to express the jubilation this news brings.','',''),('CharTerminationBodyM08','info','%(charName)s was the worst %(roleName)s that we have known. %(he)s was hated by %(his)s fellow corporation members. %(securityDescription)s This is indeed a time to celebrate. I realize that words can do little to express the jubilation this news brings.','',''),('CharTerminationBodyM09','info','%(charName)s was the worst %(roleName)s that we have known. %(he)s was hated by %(his)s fellow corporation members. %(securityDescription)s This is indeed a time to celebrate. I realize that words can do little to express the jubilation this news brings.','',''),('CharTerminationBodyM10','info','%(charName)s was the worst %(roleName)s that we have known. %(he)s was hated by %(his)s fellow corporation members. %(securityDescription)s This is indeed a time to celebrate. I realize that words can do little to express the jubilation this news brings.','',''),('CharTerminationBodyP00','info','%(charName)s was an OK %(roleName)s and didn\'t aggrevate his fellow corporation members that much. %(securityDescription)s I realize that words can do little to console you at a time like this, but I want you to know that we share your sorrow.','',''),('CharTerminationBodyP01','info','%(charName)s was a fine %(roleName)s and was admired by %(his)s fellow corporation members. %(securityDescription)s We will all miss %(him)s. I realize that words can do little to console you at a time like this, but I want you to know that we share your sorrow.','',''),('CharTerminationBodyP02','info','%(charName)s was a fine %(roleName)s and was admired by %(his)s fellow corporation members. %(securityDescription)s We will all miss %(him)s. I realize that words can do little to console you at a time like this, but I want you to know that we share your sorrow.','',''),('CharTerminationBodyP03','info','%(charName)s was a fine %(roleName)s and was admired by %(his)s fellow corporation members. %(securityDescription)s We will all miss %(him)s. I realize that words can do little to console you at a time like this, but I want you to know that we share your sorrow.','',''),('CharTerminationBodyP04','info','%(charName)s was a fine %(roleName)s and was admired by %(his)s fellow corporation members. %(securityDescription)s We will all miss %(him)s. I realize that words can do little to console you at a time like this, but I want you to know that we share your sorrow.','',''),('CharTerminationBodyP05','info','%(charName)s was a fine %(roleName)s and was admired by %(his)s fellow corporation members. %(securityDescription)s We will all miss %(him)s. I realize that words can do little to console you at a time like this, but I want you to know that we share your sorrow.','',''),('CharTerminationBodyP06','info','%(charName)s was a fine %(roleName)s and was admired by %(his)s fellow corporation members. %(securityDescription)s We will all miss %(him)s. I realize that words can do little to console you at a time like this, but I want you to know that we share your sorrow.','',''),('CharTerminationBodyP07','info','%(charName)s was a fine %(roleName)s and was admired by %(his)s fellow corporation members. %(securityDescription)s We will all miss %(him)s. I realize that words can do little to console you at a time like this, but I want you to know that we share your sorrow.','',''),('CharTerminationBodyP08','info','%(charName)s was a fine %(roleName)s and was admired by %(his)s fellow corporation members. %(securityDescription)s We will all miss %(him)s. I realize that words can do little to console you at a time like this, but I want you to know that we share your sorrow.','',''),('CharTerminationBodyP09','info','%(charName)s was a fine %(roleName)s and was admired by %(his)s fellow corporation members. %(securityDescription)s We will all miss %(him)s. I realize that words can do little to console you at a time like this, but I want you to know that we share your sorrow.','',''),('CharTerminationBodyP10','info','%(charName)s was a fine %(roleName)s and was admired by %(his)s fellow corporation members. %(securityDescription)s We will all miss %(him)s. I realize that words can do little to console you at a time like this, but I want you to know that we share your sorrow.','',''),('CharTerminationSecM01','info','They could of been dangerous if they hadn\'t died so young.','',''),('CharTerminationSecM02','info','They would occasionally scare the odd passer by.','',''),('CharTerminationSecM03','info','Regarded as almost being a dangerous character.','',''),('CharTerminationSecM04','info','Regarded as being a dangerous character.','',''),('CharTerminationSecM05','info','Regarded as being quite a dangerous character.','',''),('CharTerminationSecM06','info','An effective dispatcher of foes, and those that got in the way.','',''),('CharTerminationSecM07','info','An fairly effective dispatcher of foes, and those that got in the way.','',''),('CharTerminationSecM08','info','A highly effective dispatcher of foes, and those that got in the way.','',''),('CharTerminationSecM09','info','An accomplished expeditor of their adversaries, and those that got in the way.','',''),('CharTerminationSecM10','info','%(charName)s deserved their place at the top of CONCORD\'s most wanted list. They were without a doubt extremely evil, a true opponent of CONCORD\'s ideals of society.','',''),('CharTerminationSecP00','info','CONCORD has no record of %(charName)s, %(he)s was probably not seen as a threat to the rest of us.','',''),('CharTerminationSecP01','info','Liked by some, and trusted by close friends occasionally.','',''),('CharTerminationSecP02','info','%(He)s was kind of OK, and almost trustable.','',''),('CharTerminationSecP03','info','You could trust %(him)s with some things.','',''),('CharTerminationSecP04','info','You could trust %(him)s with most things.','',''),('CharTerminationSecP05','info','You could trust %(him)s with almost anything.','',''),('CharTerminationSecP06','info','%(He)s was trustworthy and held in regard by some.','',''),('CharTerminationSecP07','info','%(He)s was trustworthy and held in some regard by many.','',''),('CharTerminationSecP08','info','%(He)s was trustworthy and held in high regard by all.','',''),('CharTerminationSecP09','info','%(He)s was trustworthy and like a deity to some of us.','',''),('CharTerminationSecP10','info','%(He)s was trustworthy and like a deity to all of us.','',''),('CharTerminationTailPiece','info','Sincerely,\n%(corpName)s','',''),('CharTerminationTitle','info','RIP Corporation member %(charName)s','',''),('chatAmarrEmpireMilitaryWarning','notify','%(owner)s, you are an enemy of the Amarr Empire! This is your last voyage into our territory!','',''),('chatAmarrEmpirePoliceWarning','notify','All criminals in the Amarr Empire will be shot on sight! Venturing into our space will be your last mistake, %(owner)s!','',''),('chatCaldariStateMilitaryWarning','notify','You have entered Caldari space %(owner)s. Since you have proven to be an enemy to our people, you will be terminated!','',''),('chatCaldariStatePoliceWarning','notify','You have entered Caldari space %(owner)s, where criminals will not be tolerated!','',''),('ChatCEO','notify','<color=0xffff0000>%(text)s','res:/sound/ui/HardBeep03.wav',''),('ChatChannelExists','info','The specified chat channel (%(chname)s) already exists.','',''),('ChatCiC','notify','<color=0xff0000ff>%(text)s','res:/sound/ui/PrinterBeep02.wav',''),('chatCONCORDPoliceWarning','notify','For attacking an innocent pilot, you leave us no option but to hunt you down and kill you %(owner)s.','',''),('ChatCustomChannelNameNoSeparators','info','Illegal Channel Name::The \'\\\' character is reserved for internal usage.','',''),('ChatCustomChannelNameTooLong','info','Channel name cannot exceed %(max)s letters','',''),('chatDefaultCustomsDiscard','notify','Beware, on behalf of %(faction)s we are detonating containers in space which contain illegal goods, if these containers belong to you, you have been let off with a warning this time.','',''),('chatDefaultCustomsPass','notify','%(owner)s: You have been approved to continue on your way. Please remember to report any of your fellows who may transport illegal goods like the good little citizen you are.','',''),('chatDefaultCustomsReceive','notify','%(owner)s: For your transgression in handling illegal goods, you shall be executed for your crimes!','',''),('chatDefaultCustomsThreat','notify','%(owner)s: For your transgression in transporting illegal goods, you shall be executed for your crimes!','',''),('chatDefaultCustomsWarning','notify','%(owner)s: Please stay where you are, you have been randomly selected to be searched for illegal goods. Aggression, jettisoning any contraband you may have or taking flight will result in appropriate actions.','',''),('chatDefaultGunAttack','notify','%(owner)s: You have foolishly entered the range of the sentry guns and must suffer the consequences for your past crimes.','',''),('chatDefaultGunFactionLoss','notify','%(owner)s: You have foolishly aggressed against %(faction)s within sight of our sentry guns and must suffer the consequences.','',''),('chatDefaultGunSecurityLoss','notify','%(owner)s: You have foolishly engaged in criminal activity within sight of sentry guns and must suffer the consequences.','',''),('chatDefaultMilitaryWarning','notify','%(owner)s, you are an enemy to our nation.  Leave immediately or be fired upon!','',''),('chatDefaultPoliceWarning','notify','%(owner)s, Criminals are not welcome here.  Leave now or be destroyed.','',''),('chatGallenteFederationMilitaryWarning','notify','Enemies of the Gallente Federation are not welcome here - you will have but a few seconds to flee before we destroy your ship %(owner)s!','',''),('chatGallenteFederationPoliceWarning','notify','Criminals are not welcome into Gallente space - leave now %(owner)s, or your vessel will be destroyed!','',''),('chatMinmatarRepublicMilitaryWarning','notify','An enemy of the Minmatar Republic has entered this solar system: %(owner)s - we will seek and destroy all our enemies!','',''),('chatMinmatarRepublicPoliceWarning','notify','Report of a criminal within this solar system: %(owner)s - We will ensure that law will be upheld in Minmatar space!','',''),('ChatTxt','notify','%(text)s','res:/sound/ui/ChatTxt.wav',''),('ChecksumError','info','Checksum error::Checksum verification failed. This indicates that the file was not downloaded correctly. You will have to download the file again.','',''),('ChrAlreadySelected','info','Character Already Selected::You have already selected a character for this session.','',''),('ChtAlreadyInChannel','info','Already in channel::%(char)s is already in the channel','',''),('ChtAlreadyInvited','info','Character Already Invited::%(char)s has already been invited to this channel and has not yet decided whether or not to join.','',''),('ChtBlockedBefore','info','Invitation Blocked::%(char)s has already added you to his/her blocked list, and will not receive invitations to chat with you.','',''),('ChtBlockedNow','info','Invitation Blocked::%(char)s has added you to his/her blocked list, and will not receive future invitations to chat with you.','',''),('ChtCannotInviteSelf','info','Cannot Invite Self::It is much more efficient to talk to yourself in person than via the chat system.','',''),('ChtChannelByInvitationOnly','info','Channel Is For Members Only::The %(channel)s channel is for members only, and can only be joined if you have been invited to it by a member.','',''),('ChtChannelCreatorModified','info','Channel Creator Modified::The %(channel)s channel\'s creator priviledges have been transferred to %(newcreator)s by %(whodunnit)s.','',''),('ChtChannelModerated','info','Channel Moderated::The %(channel)s channel is running in moderated mode, so your message will not be delivered.  Please contact the moderators if you wish to speak on this channel.  The moderators are: %(moderators)s.','',''),('ChtChannelNoLongerCorpBound','info','Channel Made Corp Non-Exclusive::The %(channel)s channel is no longer corp exclusive, and will thus no longer be available only to %(corp)s members.','',''),('ChtChannelNoLongerInviteOnly','info','Channel Made Open::The %(channel)s channel is no longer by invitation only, and will thus accept characters that join it with or without a prior invitation.','',''),('ChtChannelNoLongerModerated','info','Channel Moderation Disabled::The %(channel)s channel is no longer running in moderated mode.','',''),('ChtChannelNoLongerPublic','info','Channel Made Private::The %(channel)s channel is no longer public, and will thus not be listed except for characters that have previously joined it.','',''),('ChtChannelNowCorpBound','info','Channel Made Corp Exclusive::The %(channel)s channel is now corp bound to %(corp)s, and is thus available only to corp members.','',''),('ChtChannelNowInviteOnly','info','Channel Made Invite-Only::The %(channel)s channel is now by invitation only, and can thus no longer be joined by characters that haven\'t been explicitly invited.','',''),('ChtChannelNowModerated','info','Channel Moderation Enabled::The %(channel)s channel is now running in moderated mode.','',''),('ChtChannelNowPublic','info','Channel Made Public::The %(channel)s channel is now public, and is thus to be found on the channel list of all players.','',''),('ChtChannelRoleChange','info','Channel Role Restriction Change::The %(channel)s channel\'s role requirements have been changed.  They were set to: %(roles)s','',''),('ChtCharNotReachable','info','Character Not Reachable::%(char)s is either offline or otherwise unreachable.','',''),('ChtCharNotReachableCSPARefunded','info','Character Not Reachable::%(char)s is either offline or otherwise unreachable.  The CSPA service charge for the communication initiation attempt has been refunded.','',''),('ChtCONCORDSpamPreventionActConfirmation','question','Accept CSPA Service Charge::This chat invitation is subject to a CSPA service charge of %(amount)s ISK, which you must accept to complete the invitation.<br><br>According to the CONCORD Spam Prevention Act, all communication initiations between parties that have not explicitly whitelisted each other through the use of a central address book shall be subject to a nominal service fee which shall be collected by the Fluid comm operator.  %(char)s has not whitelisted you by any such means.','',''),('ChtCustomsConfiscationConfirmation','question','Hand over contraband?::%(empire)s has discovered the contraband which you are transporting.  If you decline to hand it over or fail to respond in %(delay)s seconds, you will be punished for your transgressions.  Do not be alarmed, while we are waiting for your response, one of our number will target, warp scramble and stasis web you - for your safety of course. The contraband discovered was:<br><br>%(contraband)s','',''),('ChtCustomsConfiscationConfirmation2','question','Hand over contraband?::%(empire)s has discovered the contraband which you are transporting.  If you decline to hand it over, your ship will be destroyed.  Do not be alarmed, while we are waiting for your response, one of our number will target, warp scramble and stasis web you - for your safety of course. The contraband discovered was:<br><br>%(contraband)s','',''),('ChtIllegalRole','info','Invalid Role::The role you specified (%(role)s) is not recognized by the server.  Please check your typing and try again.','',''),('ChtIncorrectSetCreatorParams','info','Invalid Params::Please specify either the new creator\'s name, or nothing for EVE System.  Perhaps you forgot to enquote the name?','',''),('ChtInviteException','info','Invite Failure::The invitation for %(char)s to the %(channel)s channel was not delivered because of an error in his or her client.','',''),('ChtInviteRejected','notify','Chat Invitation Rejected::%(char)s\'s invitation to the %(channel)s channel was rejected because another invitation was in progress.','',''),('ChtInvitorNoLongerOnline','info','Invitor Offline::%(invitor)s has gone offline since he/she invited you to the %(channel)s channel.','',''),('ChtMissingGagParams','info','Missing Parameters::Please specify who to gag, why you are gagging him/her, and optionally a duration (in minutes) for the gag.','',''),('ChtMissingInviteParams','info','Missing Parameters::Please specify the name of the channel you would like to join.','',''),('ChtMissingKickParams','info','Missing Parameters::Please specify who to kick and why you are kicking him/her.','',''),('ChtMissingPrivParams','info','Missing Parameters::Please specify who you would like to send a private message to, and a message to send.','',''),('ChtMissingUnInviteParams','info','Missing Parameters::Please specify who to un-invite and why you are revoking their invitation.','',''),('ChtNewPasswordInvalid','info','Invalid Password::The password must contain at least 3 characters, and not have leading/trailing whitespace.','',''),('ChtNPC','info','Not a Player::%(char)s is not a real player so he/she cannot accept the invitation.','',''),('ChtOtherInvitePending','info','Other Invite Pending::Your chat invitation has been rejected, because the recipient was already considering another invite.','',''),('ChtPasswordMismatch','info','Password Mismatch::The new and confirmed password you specified do not match, so the password wasn\'t changed.','',''),('ChtRejected','info','Invitation Cancelled::%(char)s has rejected the invitation.','',''),('ChtWrongCorp','info','Corp Exclusive::The %(channel)s channel is intended exclusively for %(corp)s corporation members.','',''),('ChtWrongPassword','info','Wrong Password::The%(passwordType)s password you specified is not correct for the %(channel)s channel.','',''),('ChtWrongRole','info','Insufficient Priviledges::The %(channel)s channel is access controlled, requiring one of the following roles:  %(missingroles)s.','',''),('ChtYouHaveBeenGagged','info','Gagged::You have been gagged by %(gagger)s from talking on the %(channel)s channel until %(untilwhen)s.  The reason specified was %(reason)s.','',''),('ChtYouHaveBeenKicked','info','Kicked::You have been kicked by %(kicker)s from the %(channel)s channel.  The reason specified was %(reason)s.','',''),('ChtYouHaveBeenUnInvited','info','Invitation Revoked::Your invitation to the %(channel)s has been revoked by %(uninviter)s.  The reason specified was %(reason)s.','',''),('CivireFemale','notify','Female Civire are not all that tall, but lithe and supple. They are ardent and committed workers, never willing to give up.','',''),('CivireMale','notify','Civire males are big-boned and masculine, preferring a clean shaven chin and closely cropped head.','',''),('click','audio','','res:/sound/ui/GlassyBeep25.wav',''),('ClickFactorySlot','audio','','res:/sound/ui/uiFctBtn.wav',''),('ClickOffllineModule','notify','You can\'t activate this module because it is offline. You can try and turn it online by right clicking on it and choosing \"Put Online\" in the contextual menu.','res:/Sound/ui/error07.wav',''),('CloakingDisengagedPolicePursuit','notify','Your cloaking systems cannot be engaged due to jamming by police who are pursuing you.','',''),('CloneActivatedMsg','notify','So you died? Well you have a %(cloneTypeName)s at %(stationname)s station. Enjoy your afterlife. %(cloningServiceMessage)s','',''),('CloneActivatedSPLostMsg','notify','So you died? Well you have a %(cloneTypeName)s at %(stationname)s station. Enjoy your afterlife. Note that %(spLost)s skill points were lost from the skill %(skillDecreased)s. %(cloningServiceMessage)s','',''),('CloneReanimated','info','Clone %(name)s has been reanimated.','',''),('close','audio','','res:/sound/ui/GlassyBeep25.wav',''),('CloseEscrowInfo','info','You cannot close escrow which is assigned to someone, you simply have to wait for the timeout.','',''),('CluShutdownCancelled','info','Shutdown Cancelled::%(explanation)s','',''),('CluShutdownInitiated','info','Shutdown In Progress::%(explanation)s','',''),('CodePatchApplied','info','Optional Update Installed::The optional update has been installed. The client will now restart.<br><br>Press \'OK\' to continue.','',''),('CodePatchRemoved','info','Optional Update Removed::An optional update has been removed. The client will now restart.<br><br>Press \'OK\' to continue.','',''),('CollateralCanNotBeNegative','info','Collateral::The collateral specified is invalid. The collateral cannot be negative.','',''),('ComboEntryEnter','audio','','res:/sound/ui/mentersmall.wav',''),('ComboEntrySelect','audio','','res:/sound/ui/smallselect.wav',''),('ComboExpand','audio','','res:/sound/ui/HangarSmallMenu.wav',''),('Command','notify','%(command)s','',''),('CompiledCodeAskToRemove','question','Remove Optional Update?::Are you sure you want to remove this optional update?','',''),('CompiledCodeDownloadFailed','info','Optional Update Failed::Unable to apply the optional update.<br><br>Press \'OK\' to continue.','',''),('CompiledCodeMachoNetVersionMismatch','warning','Unable to Connect to Server::There was a problem connecting to the server, possibly because:<br> • You have not established an internet connection<br> • A firewall is blocking the network connection<br> • The server isn\'t running at this time (downtime)<br>The optional update the client is using could also be incompatible with the server. Would you like to remove the optional update and restart the client?','',''),('CompiledCodeManualDownload','question','Optional Update Download Failed::The automatic download of the optional update failed. Would you like to manually download it now?','',''),('CompiledCodeUpgradeAvailable','question','Optional Client Update Available::An optional client update is available. Do you want to install it?<br><br>%(description)s<br>Click <a href=\"shellexec:%(url)s\">here</a> for details about this update.','',''),('CompiledCodeUpgradeDescriptionError','error','Optional Update Description Failure::There was an error retrieving the optional update description.','',''),('CompiledCodeUpgradeNoLongerValid','info','Optional Update Not Valid::You are using an old optional update that is no longer valid. The client needs to be restarted now to remove the old update.<br><br>Press \'OK\' to continue.','',''),('ComplexReqMissing','info','Requirement Failed: %(name)s requires %(required)s.','',''),('ConAreYouSureYouWantToCancel','question','Cancel Create Contract?::Are you sure you want to cancel?','',''),('ConAuctionAlreadyClaimed','info','Auction has been claimed::This auction has already been claimed.','',''),('ConAuctionHasBids','info','Bidding has started::You cannot cancel this auction as bidding has already started.','',''),('ConBasePrice','question','Use Base Price?:s:Do you want to use the BasePrice for your items which is <b>%(price)s</b>?<br>\nThis price is automatically calculated from the mineral worth of your items and might not give an accurate representation of their actual worth.<br>\nNote that any items enclosed in containers are not taken into account.','',''),('ConBidTooLow','info','Bid too low::The bid you placed for <b>%(bid)s</b> is too low. The minimum accepted bid for this auction is <b>%(minBid)s</b>.','',''),('ConCannotTradeBlueprintCopy','info','Cannot loan blueprint copy::The item <b>%(example)s</b> in the station <b>%(station)s</b> is a blueprint copy. You cannot put blueprint copies into loan contracts.','',''),('ConCannotTradeContainerInContainer','info','Container in container::You cannot enter an item into a contract which has a populated container inside it. Please remove all items from your container\'s container before continuing.','',''),('ConCannotTradeContraband','info','Contraband::One or more items specified in your contract are illegal in certain areas. Your contract may not include any illegal items.\n<br><br>\nAt least the following item is contraband: <b>%(example)s</b>.','',''),('ConCannotTradeCurrentShip','info','This is your current ship::It\'s not a good idea to enter your current ship into a contract!','',''),('ConCannotTradeDamagedItem','info','Damaged Item::One or more of the items specified in your contract are damaged. Please repair them before entering them into a contract.<br><br>\nAt least the following item is damaged: <b>%(example)s</b>','',''),('ConCannotTradeItemNotInStation','info','Item not found::The item <b>%(example)s</b> was not found in the station <b>%(station)s</b>. Please make sure all items are in the correct hangar before finalizing this contract.','',''),('ConCannotTradeItemSanity','info','Item changed::Failed to create the contract because one or more items have been changed from the time you selected them.<br><br>Please close the wizard and try again.','',''),('ConCannotTradeNonSingletonShip','info','Must assemble ship::The ship <b>%(example)s</b> in the station <b>%(station)s</b> must be assembled before you can enter it into a loan contract.<br>Single unassembled ships cannot be entered into a loan contract.','',''),('ConConfirmAcceptCourier','question','Really Accept Contract?::%(youoryourcorp)s are about to accept the following contract: %(contractname)s.<br>\nYou will have to deliver %(volume)s m^3 of cargo to %(destination)s within %(numdays)s days.<br>%(collateral)s <br> Are you sure you want to do this?','',''),('ConConfirmAcceptFreeform','question','Really Accept Contract?::%(youoryourcorp)s are about to accept the following <b>freeform</b> contract issued by <b>%(issuer)s</b>: \"%(contractname)s\".\n<br> \n%(collateral)s%(reward)s\n<br>\n<b>READ THESE WARNINGS CAREFULLY!:</b>\n<br>\n<br>\n * Because this is a freeform contract the issuer has COMPLETE CONTROL over it and can declare it a failure at his or her own discretion.\n<br>\n<br>\n * Accepting this contract <b>does NOT bind %(issuer)s to give you ANY items</b> whatsoever. Not even if any item types are listed in it. Not even if they appear with info links! There are known scams involving exactly this. \n<br>\n<br>\n<b>Do not accept this contract unless you trust %(issuer)s completely!</b>\n<br>\n<br>\nAre you sure you want to do this?','',''),('ConConfirmAcceptItemExchange','question','Really Accept Contract?::%(youoryourcorp)s are about to accept the following contract: %(contractname)s.<br>\n%(payorgetmoney)s<br>\n%(itemsget)s\n%(itemspay)s\n<br>\nAre you sure you want to do this?','',''),('ConConfirmAcceptItemExchangeGift','warning','Feeling generous?::%(youoryourcorp)s are about to accept the following contract: %(contractname)s.<br>\n%(payorgetmoney)s<br>\n%(itemsget)s\n%(itemspay)s\n<b>Note: You will receive nothing from accepting this contract!</b>\n<br>\nAre you sure you want to do this?','',''),('ConConfirmAcceptLoan','question','Really Accept Contract?::%(youoryourcorp)s are about to accept the following contract: %(contractname)s.%(note)s<br> %(borrowitems)s%(borrowmoney)s%(numdays)s<br>%(amount)s %(collateral)s <br> Are you sure you want to do this?','',''),('ConConfirmComplete','question','Really Complete?:s:Are you sure you want to complete this contract?','',''),('ConConfirmCreateContract','question','Really create contract?:s:Are you sure you want to create this contract? Make sure you have read the information on the confirmation page carefully before clicking \'yes\'. Any fees that are incurred with setting up this contract are non-refundable.','',''),('ConConfirmDeleteContract','question','Delete Contract?::Are you sure you want to delete this contract, <b>%(contractname)s</b>?<br>Any collateral and/or broker\'s fee will be lost!<br><br>\nIf this is a personal contract, any items in this contract will be returned to your hangar. If this is a corporation contract they will be returned to the deliveries hangar.','',''),('ConConfirmFailContractAcceptor','warning','Declare Failure?::Are you sure you want to declare the contract \"<b>%(contractname)s</b>\" a failure?<br>\nThis will have a negative affect on your reputation as contracts are a matter of public record.<br>%(collateral)s<br>If you believe there is no way you can finish the contract click Yes to fail it.','',''),('ConConfirmFailContractIssuerFinishedAcceptor','question','Declare Failure?::Are you sure you want to declare the contract <b>%(contractname)s</b> a failure?<br>\n<b>%(acceptor)s</b> has claimed to have finished this contract and failing it will adversely affect his reputation.<br>\nDo you want to continue and fail this contract?','',''),('ConConfirmFailContractIssuerOverdue','question','Declare Failure?::Are you sure you want to declare the contract <b>%(contractname)s</b> a failure?<br>\nThe contract is <b>%(timeoverdue)s</b> overdue but you can give <b>%(acceptor)s</b> more time by simply not failing the contract yet.<br>\nDo you want to continue and fail this contract?','',''),('ConConfirmNotReachable','warning','Destination not reachable::Either the start point or the destination of this contract is not reachable with your current autopilot settings. This means that you might not be able to complete the contract!<br><br>\nAre you sure you want to continue?','',''),('ConConfirmPlaceBid','question','Confirm Bid:s:%(youoryourcorp)s are about to place a bid of <b>%(amount)s</b> on the following contract: %(contractname)s.<br> %(itemsget)s<br>Are you sure you want to do this?','',''),('ConConfirmRejectContract','question','Reject Contract?:s:Are you sure you want to reject the contract, <b>%(contractname)s</b> issued to you by %(issuer)s?','',''),('ConConfirmRejectContractCorp','question','Reject Corp Contract?:s:Are you sure you want to reject the contract, <b>%(contractname)s</b> issued to your corporation by %(issuer)s?<br><br>\nNote: If you reject this contract on behalf of your corporation then no one within your corporation will be able to accept it.','',''),('ConContractExpired','info','Contract has expired::You cannot perform this action on an expired contract.','',''),('ConContractNotFound','info','Contract Not Found::This contract could not be found.<br>\nEither the contract has been deleted or you do not have access to it.','',''),('ConContractNotInProgress','info','Contract not in progress::You cannot perform this action on a contract that is not In Progress.','',''),('ConContractNotOutstanding','info','Contract is not Outstanding::You cannot perform this action on a contract that is not Outstanding.','',''),('ConContractSameIssuerAndAcceptor','info','This is your contract::You cannot accept contracts issued by yourself and your corporation cannot accept contracts issued by your corporation.','',''),('ConCorpContractRoleMissing','info','Role Missing::You must have the role \"Contract Manager\" in your corporation to complete this operation.','',''),('ConCourierDoesNotFit','question','Does not fit current ship::This courier package requires <b>%(vol)s m^3</b> of space. Your current ship can only carry <b>%(max)s m^3</b>.<br>\nAre you sure you want to continue?','',''),('ConCourierItemsMissing','info','Items missing::One or more items that you were hired to transport are missing from the transport crate. Therefore it is impossible to complete this contract.','',''),('ConCrateNotFound','info','Crate not found::The crate for this contract could not be found in the hangar at the contract\'s end station. If the crate is in your ship you have to move it to your hangar before completing the contract.','',''),('ConDangerousContractFreeform','warning','Dangerous Contract!:s:The freeform contract you are about to view is issued by a person outside your corporation and alliance. It might be dangerous for you to accept it!\n<br><br>\n<b>You will not receive anything from this contract when you accept it.</b>\n<br><br>Are you sure you want to continue and view this contract?','',''),('ConDangerousContractLoan','warning','Dangerous Contract!:s:The loan contract you are about to view is issued by a person outside your corporation and alliance. It might be dangerous for you to accept it!\n<br><br>Are you sure you want to continue and view this contract?','',''),('ConDestinationSame','info','Circular delivery::Hold on there! You can\'t deliver a courier package to the same place where it came from, that would be ridiculous!<br><br>Ahh, you almost had me there. This is a joke, right? Very funny! Now go on and select another destination, you big comedian.','',''),('ConDurationZero','info','No duration::You cannot create a Courier Contract with no duration. Please select a duration of at least 1 day.','',''),('ConExceedsMaxVolume','info','Maximum Volume Exceeded::This Courier contract exceeds the maximum volume requirement.<br>\nThe volume of the items you have entered is <b>%(vol)s</b> m^3 but the maximum amount you can put in a Courier contract is <b>%(max)s</b> m^3.','',''),('Confirm','audio','','res:/sound/ui/ok.wav',''),('ConfirmAbandonDrone','question','Abandon Drone:s:Are you sure about it?','',''),('ConfirmAbortSkillTraining','question','Pause Training?:s:Are you sure you want to pause training this skill?','',''),('ConfirmAcceptLPOffer','question','Accept Offer?::You are about to accept an offer for:<br>\n<b>%(offer)s</b>.<br>\nThis will cost you:<br>\n%(price)s\n<br>\nAre you sure you want to accept this offer?','',''),('ConfirmAddLockedItemToAuditContainer','question','Adding a locked item:s:You are adding a locked item to this audit container. You do not have the <b>equipment config</b> role in your corporation and you will therefore not be able to unlock it or retrieve it.<br><br>\nAre you sure you want to continue?','',''),('ConfirmBanIskSpammer','warning','Ban Isk Spammer?::Do you want to ban the user of the character <b>%(name)s</b> for ISK Spamming? This operation will delete all of the users sent eve-mail and seriously messes him up. <br>Do not do this to annoying players, <b>only do this for real ISK Spamming!!!</b><br><br>\nNote that you are only able to ban trial accounts for ISK Spamming.','',''),('ConfirmBreakMissionPackage','question','Fail mission?::Breaking this mission package will make it impossible to complete a mission. Are you sure you want to do this?','',''),('ConfirmBuyMoreThanCanAfford','question','You Can\'t Afford That:s:This transaction will require %(cost)s ISK; at the moment you have only %(wealth)s. If you don\'t have the required credit by the time of transaction, you will get fined. Are you sure you want to place this order?','',''),('ConfirmCancelCharCreation','question','Are you sure you want to cancel this character creation session?','',''),('ConfirmCancelContentDownload','question','Cancel Download?::Are you sure you want to cancel downloading of the Content Upgrade?','',''),('ConfirmCancelTrade','question','Cancel Session?:s:Are you sure you want to cancel this trade session?','',''),('ConfirmCancelTutorial','question','Abort Tutorial?::Are you sure you want to abort the tutorial?','',''),('ConfirmCharSelection','question','Correct character?:s:Is %(name)s the character you were looking for?','',''),('ConfirmClearText','question','Clear Text?:s:Are you sure you want to remove all the text in the input field?','',''),('ConfirmCorpSelection','question','Correct corporation?:s:Is %(name)s the corporation you were looking for?','',''),('ConfirmDeleteFolder','question','Delete Folder?:s:Are you sure you want to delete this folder and all of its content?','',''),('ConfirmDeleteLPStoreFilterPreset','question','Delete Filter Preset?:s:Are you sure you want to delete this filter preset?','',''),('ConfirmEject','question','Confirm Eject From Ship?::Are you sure want to eject from the ship?<br><br>Be aware that your skills may be having an extensive influence on the ship. They may be all that is holding it together, providing the power needed to keep modules online or extra cargo space which you are using. Ejecting may therefore cause modules to go offline, excess cargo to be ejected or even cause the ship to explode.','',''),('ConfirmGagIskSpammer','warning','Global-Gag Isk Spammer?::Do you want to gag the user of the character <b>%(name)s</b> for ISK Spamming? This operation will cause him not being able to chat, send eve-mails, join corporations or participate in trade. <br>Do not do this to annoying players, <b>only do this for real ISK Spamming!!!</b>\n<br><br>The user will be reviewed by Eve Customer Support before being banned.\n<br><br>Note that you are only able to gag trial accounts for ISK Spamming.\n','',''),('ConfirmGiveAwayOnlyShip','question','Give Away Only Ship:s:This is your only ship at this station. Unless you get a new ship, you may not be able to undock anymore. Are you sure you want to give it away? ','',''),('ConfirmJettison','question','Jettison:s:Are you sure about it?','',''),('ConfirmJumpToUnsafeSS','question','Low Security System:s:The destination system is %(ss).1f security status. This is extremely dangerous and Concord police can not guarantee your safety there. Do you want to proceed?','',''),('ConfirmJumpWithIllicitGoods','warning','Illicit Goods Onboard:s:You are carrying goods that are considered illicit by %(faction)s, which is the controlling faction at your jump destination.<br>The illicit goods include:  %(stuff)s.<br>Are you sure you would like to make this jump?','',''),('ConfirmKickCorpMember','question','Expel Member::Are you sure you want to expel %(name)s from this corporation?','',''),('ConfirmMarketOrder','question','Confirm Order:s:This market order will cost <b>%(isk)s</b> in broker\'s fees to set up. Are you sure you want to continue?','',''),('ConfirmOneWayItemMove','question','One Way Move:s:You may not be able to take this back. Are you sure you want to move it there? ','',''),('ConfirmOrphanStructureUnanchor','question','Unanchor Structure?::This %(item)s is not currently assisted by a control tower. Unanchoring it will forcibly collapse it\'s internal Planck Bubble, destroying all contained items. Are you sure you want to do this?','',''),('ConfirmOverrideQuickBuySell','question','Close current?:s:There is already a Quick %(buySell)s window open.<br><br>Press OK to close that window and start this new operation, or Cancel to keep the current window and cancel this new operation.','',''),('ConfirmOverwriteLPStoreFilterPreset','question','Overwrite Filter Preset?:s:You are about to overwrite this filter preset with your current selections. The old filters in the preset will be lost.<br><br>Are you sure you want to do this?','',''),('ConfirmPatch','question','Check for patch?:s:There is a version mismatch with the server, would you like to check for a patch ?','',''),('ConfirmPlugInImplant','question','Use implant?:s:Implants are lost when unplugged and when you die. Are you sure you want to use this one now?','',''),('ConfirmQuitCorporation','question','Quit Corporation::Are you sure that you want to leave the corporation that you are currently a member of? If you quit, you will automatically become a member of one of the starter NPC corporations.','',''),('ConfirmRemoveAllRoles','question','Remove All Roles::Are you sure that you want to remove all your roles and grantable roles? If you confirm, you will block any new roles in your current corporation. To accept new roles again, you must right-click your character entry and select \'Allow new roles\'.','',''),('ConfirmRepackageItem','question','Repackage Item?::Are you sure that you want to repackage this item?','',''),('ConfirmRepackageSomethingWithUpgrades','question','Repackage upgraded ship?:s:Repackaging a ship which has upgrades fitted will result in the loss of those upgrades.<br><br>Do you wish to proceed with this wasteful action?\n','',''),('ConfirmReprocessSomethingWithUpgrades','question','Reprocess upgraded ship?:s:Reprocessing a ship which has upgrades fitted will result in the loss of those upgrades.<br><br>Do you wish to proceed with this wasteful action?','',''),('ConfirmResetSkillTraining','question','Switch Skill Training?::You are currently training %(name)s to level %(lvl)s. If you start training this skill, your current training process will be paused. Doing this will not cause you to lose any of the skill points you have already gained while training %(name)s to level %(lvl)s.<br>Are you sure you want to continue?','',''),('ConfirmScoopWithIllicitGoods','warning','Illicit Goods inside container:s:This container contains goods that are considered illicit by %(faction)s, which is the controlling faction of the solarsystem you are in.<br>Are you sure you would like to scoop this container?','',''),('ConfirmSelfDestruct','warning','Are you sure?::If you self-destruct your ship you will lose it! Are you sure you want to initiate the <b>2</b> minute self-destruct sequence?\n<br><br>\nTo cancel a self-destruct sequence you should select self-destruct again (if any of your ships is already self destructing this will cancel it).','',''),('ConfirmShowAllClosedVotes','question','Show all votes?:s:This operation may take a long time, are you sure you want to show all closed votes?','',''),('ConfirmShowAllSanctionableActions','question','Show all sanctionable actions?:s:This operation may take a long time, are you sure you want to show all actions that are not in effect, including expired actions?','',''),('ConfirmStealItem','warning','Confirm Steal Item:s:You are about to steal items from %(owner)s. If you continue, %(owner)s and %(owner)s\'s corporation will be free to attack you!\nAre you sure you want to continue?','',''),('ConfirmStoreVesselInShip','question','Store Vessel?:s:Are you sure you wish to eject from your ship and store it in the %(dest)s?','',''),('ConfirmStoreVesselInStructure','question','Store Vessel?:s:Are you sure you wish to eject from your ship and store it in the %(dest)s?','',''),('ConfirmStructureAnchor','question','Anchor structure?:s:Are you sure you wish to anchor this %(item)s?','',''),('ConfirmStructureOffline','question','Offline structure?:s:Are you sure you wish to put this %(item)s offline?  Remember it can take a long time to bring it back online.','',''),('ConfirmStructureUnanchor','question','Unanchor structure?:s:Are you sure you wish to unanchor this %(item)s? Remember it can take a long time to anchor it again.','',''),('ConfirmTowerOffline','question','Offline tower?:s:Are you sure you wish to put this %(item)s offline?  Remember it can take a long time to bring it back online and taking it offline takes all the structures anchored around it offline as well.','',''),('ConfirmTrashAttributePoints','question','Trash Attribute Points?:s:You have not assigned all the available points. The remaining points will be lost.<br><br>Are you sure you want to proceed?','',''),('ConfirmTrashingPlu','warning','Trash Items::You are about to throw away the following items:<br>%(items)s<br><b>Are you absolutely sure you want to do this?</b>','',''),('ConfirmTrashingSin','warning','Trash Item::You are about to throw away %(item)s. <br><br><b>Are you absolutely sure you want to do this?</b>','',''),('ConfirmTrashPhysicalTraitPoints','question','Trash Points?:s:You have not used all of your available points. The remaining points will be lost, and for that you will forever be laughed at. Are you sure you want to proceed?','',''),('ConfirmUnPlugInImplant','question','Discard implant?:s:Implants are lost when unplugged. Are you sure you want to remove this one now?','',''),('ConIgnoreListFull','info','Ignore list full::The contract ignore list accepts a maximum of <b>%(n)s</b> entries.','',''),('ConIllegalType','notify','Illegal Type::One or more of the specified items are not permitted.','',''),('ConInProgressForbidden','info','Not allowed::You are not allowed to view contracts by others than yourself or your corporation that are currently <b>in progress</b> or <b>outstanding</b>.<br><br>\nOnce a contract is <b>finished</b> however, they are generally public.<br>\nAn exception to this is when a contract is issued to a specific character, corporation or alliance. In these cases you will not see the contract in the contract history unless you are one of the persons participating in the contract or a member of the corporation or alliance, respectively.<br>It does not matter in this regard whether the contract was <i>accepted</i> by a character or a corporation, only to which entity it was originally issued to (who was allowed to view it when it was created).','',''),('ConInsuredShip','question','Insured ship::Your ship, <b>%(example)s</b> is insured. If you create this contract the insurance will be voided, whether the ship changes hands or not.<br><br>\nAre you sure you want to continue?','',''),('ConInsuredShipCorp','question','Corp Insured ship::The ship, <b>%(example)s</b> is insured on behalf of your corporation. If your ship is destroyed while in the possession of someone outside your corporation, insurance will <b>not</b> be paid out.\n<br><br> Are you sure you want to continue?','',''),('ConInsuredShipLoanForCorp','question','Insured ship::The ship, <b>%(example)s</b> is insured on behalf of your corporation. If the ship is destroyed while on loan, your corporation will <b>not</b> receive an insurance payout unless the pilot is a member of your corporation.<br><br>\nAre you sure you want to continue?','',''),('ConInsuredShipLoanPersonal','question','Insured ship::Your ship, <b>%(example)s</b> is insured. If your ship is destroyed while on loan you will <i>not</i> receive an insurance payout.<br><br>\nAre you sure you want to continue?','',''),('ConMinMaxPriceError','info','Min/Max invalid::Your minimum and maximum price filters have to be positive and your maximum value must be higher than the minimum value.','',''),('ConnectionLost','info','Connection to server lost, %(what)s','',''),('ConNeedAtLeastOneLetter','info','Nothing Entered::You need to enter something in the search field.','',''),('ConNeedAtLeastThreeLetters','info','Need at least three letters::You must write at least three letters into the search field.','',''),('ConNeedFreighter','question','Contract needs freighter:s:This courier contract has <b>%(vol)s</b> m^3 worth of merchandise. It will require a Freighter-class ship to haul.<br>Are you sure you want to continue?','',''),('ConNoAccessToCorpHangar','info','Access Denied::You do not have access to the requested corporation hangar.','',''),('ConNoBasePrice','info','No BasePrice::There is no BasePrice on your selected items.','',''),('ConNoItems','info','No items::You must include some items in this contract.','',''),('ConNoItemsFound','info','No Items Found::Your query returned no legitimate item types. Please try again.','',''),('ConNonEmptyContainer','question','Non-Empty Container!::You are entering a non-empty container into this contract. The container and all its items will be entered into the contract.<br><br>\nThe container <b>%(container)s</b> contains the following items:<br>\n%(items)s<br><br>\nAre you sure you want to continue?','',''),('ConNonEmptyContainerHidden','warning','Non-empty audit container::The container you are about to place in the contract, <b>%(container)s</b> might have items inside but they cannot be listed out for security reasons.<br><br>\nAre you absolutely sure you want to include the container in the contract?','',''),('ConNotContractManager','info','Not a Contract Manager::You do not have the role <b>Contract Manager</b> or equivalent in your corporation.','',''),('ConNothingLoaned','info','Nothing Loaned::You are not loaning any money or items. Why create a Loan contract then?','',''),('ConNotInAlliance','info','Not in an Alliance::Your corporation is not in an alliance.','',''),('ConNotInStation','info','Not in a station::You may find it helpful to be located in a station when finding contracts in <i>Current Station</l>.','',''),('ConNotYourContract','info','Not Your Contract::You cannot perform this action on a contract that does not belong to you.','',''),('ConNPCNotAllowed','info','NPC not allowed::You cannot create a contract that is issued to an NPC entity. For example, if you are not in a Player owned corporation you cannot put availability as \"My Corporation\" or \"My Alliance\".<br>\nPlease go back to page 1 and select a different availability.','',''),('ConOverrideDescription','question','Override Description?:s:Are you sure you want to load a template and override the text you have already written in the Description field?','',''),('ConPasswordProtectedContainer','notify','Password Protected Container::You cannot enter a password protected container into a contract.','',''),('ConReturnItemMissingShip','info','Ship Missing::The ship you borrowed, <b>%(example)s</b>, is missing, <br> Note that your item manifest must be exactly the same as the items specified in the contract and in the same exact heirarchy.<br> The ship must be in your personal hangar at <b>%(station)s</b><br><br>Even if this is a corporate contract the items must be in your personal hangar at the location specified in the contract.<br><br>If you lost the ship you will be unable to complete this contract, even if you have replaced it, and you will have to \"Fail\".','',''),('ConReturnItemsCurrentShip','info','Cannot return current ship::One of the items you borrowed is your current ship. Please exit the ship before completing this contract.','',''),('ConReturnItemsDamaged','info','Items Damaged::One or more of the items you are trying to return has been damaged. Please repair them before completing this contract.','',''),('ConReturnItemsMissing','info','Return Items Missing::One or more required items are missing. At least the following item is missing: <b>%(example)s</b><br>\nNote that your item manifest must be exactly the same as the items specified in the contract and in the same exact heirarchy.<br>\nThe items must be in your hangar at <b>%(station)s</b><br><br>Even if this is a corporate contract the items must be in your personal hangar at the location specified in the contract.','',''),('ConReturnItemsMissingNonSingleton','info','Required Items Missing::One or more required items are missing. At least the following item is missing: <b>%(example)s</b>. These items must be in your <b>personal</b> hangar at <b>%(station)s</b><br><br>NOTE: The items must be repackaged before finalizing this transaction.','',''),('ConReturnItemsStacked','info','Stacks not correct::Required items cannot be in a stack that does not fit into the contract.<br>Please restack the required items in your personal hangar so that they match the contract and then try again.','',''),('ConReturnItemsWrong','info','Return items Invalid::One or more of the items you are trying to return are invalid.<br>Possible reasons for this is that you have some of your own items contained in ships or containers which you are trying to return.<br><br>Go through each item and make sure it complies exactly with the hierarchy stipulated in the contract. <br>For example: If you borrowed 10 items of a specific type which were in a ship\'s cargo hold then you must put the 10 items into the cargo hold before completing the contract. If there are 11 items of the type in the hold this error will result.','',''),('ConSplitStackIllegalQty','info','Illegal Quantity::There are not enough items in that stack to complete this operation.','',''),('ConStationIsPOS','warning','Station may not be accessible!:s:%(s1)s%(s2)s<br>Are you sure you want to continue?','',''),('ContainerAddFailedContainerChanged','notify','The attempt to move the %(item)s into the %(container)s failed because something happened to the %(container)s to jeopardise the operation.','',''),('ContainerAddFailedItemChanged','notify','The attempt to move the %(item)s into the %(container)s failed because something happened to the %(item)s to jeopardise the operation..','',''),('ContainerAddFailedMergeeChanged','notify','The attempt to move the %(item)s into the %(container)s failed because an attempt to merge the %(item)s with the pre-existing item in the %(container)s failed.','',''),('ContentDownloadCompleteAskApply','question','Content Upgrade Downloaded::The content upgrade has been downloaded.<br>Click Yes to install the upgrade now.<br>\nNote: Selecting Yes will restart your client.','',''),('ContentDownloadError','question','Content Upgrade Error:s:There was a problem downloading the content upgrade.<br>Press Yes if you want further instructions on how to manually download the content upgrade. ','',''),('ContentDownloadErrorStartingDownload','error','Error Starting Content Download::There was a error starting the content upgrade download. \n%(error)s.\n<br>Click <a href=\"shellexec:http://eve-online.com/patches/content.asp\">here</a> if you want further instructions on how to manually download the content upgrade.','',''),('ContentDownloadFailedVerify','error','Failed Verification::Content Download failed verification. Please restart the download.','',''),('ContentDownloadNoQualifyAskGoSysReq','question','Art Content Upgrade:s:Your computer hardware does not qualify for new art content in EVE.<br><br>Press Yes to go to the system requirements page for more information.','',''),('ContentDownloadNotEnoughDiskspace','error','Not enough disk space::Not enough disk space on partition %(partition)s. %(available)s MB available but %(needed)s MB are needed.','',''),('ContentDownloadQualifyAskDownload','question','Art Content Upgrade Available::Your computer hardware qualifies for new art content in EVE.<br><br>Press Yes to start downloading the new art content in the background while you play EVE. ','',''),('ContentDownloadQualifyAskDownloadNoBITS','question','Art Content Upgrade Available:s:Your computer hardware qualifies for new art content in EVE but you are unable to start downloading it in the background.<br><br>Press Yes if you want further instructions on how to manually download the art content upgrade. ','',''),('ContextMenuEnter','audio','','res:/sound/ui/OnMenuEnter04b.wav',''),('ConTooManyContracts','info','Too Many Contracts::With your current skill level you are allowed a maximum of %(max)s concurrent outstanding contracts.','',''),('ConTooManyContractsMax','info','Too Many Contracts::You have exceeded the maximum concurrent outstanding contract limit. <br><br>Any entity can have a maximum of %(max)s outstanding contracts at any one time.','',''),('ConTooManyItems','info','Too Many Items::You have entered too many items into the contract (<b>%(num)s</b> items). The maximum number of items you can enter into a contract is <b>%(max)s</b>.','',''),('ConTypeNotFound','info','Item type not found::The item type <b>%(type)s</b> could not be found. Please check your spelling and try again.','',''),('ConWrongRegion','info','Wrong Region::This contract is the <b>%(region)s</b> region. You can only access outstanding public contracts in the region you are currently in.','',''),('CorpAccountsHint','notify','Corporate Assets Information - Requires Accountant Role','',''),('CorpAdsAreYouSureYouWantToCancel','question','Cancel posting?::Are you sure you want to cancel?','',''),('CorpAdsAreYouSureYouWantToDelete','question','Remove Advert?:s: Are you sure you want to remove this advert? Any fees that are incurred with setting up this advert are non-refundable. The advert will be deleted, and this action is not reversible.','',''),('CorpAdsConfirmCreateAdvert','question','Confirm advert posting?:s:Are you sure you want to create this advert? Any fees that are incurred with setting up this contract are non-refundable.','',''),('CorpAdsConfirmEditAdvert','question','Confirm advert edit?:s:Are you sure you want to change this advert?\n','',''),('CorpApplicationsHint','notify','Used for processing applications made by people wanting to join your corporation.','',''),('CorpCantSetHQAsNoRealEstateHere','info','Relocating HQ::Your corporation\'s HQ cannot be relocated to this station as it owns no real estate here. In order to relocate your corporation\'s HQ here, it must own the station or an office in the station.','',''),('CorpDiv1NameInvalid','notify','The name for Division 1 is not valid.','',''),('CorpDiv1NameInvalidBannedWord','notify','The name for Division 1 contains a banned word.','',''),('CorpDiv1NameInvalidFirstChar','notify','The first character for Division 1s name is illegal.','',''),('CorpDiv1NameInvalidLastChar','notify','The last character in Division 1s name is illegal.','',''),('CorpDiv1NameInvalidMaxLength','notify','The name for Division 1 is invalid. Maximum length for a division name is 24 characters.','',''),('CorpDiv1NameInvalidMinLength','notify','The name for Division 1 is invalid. Minimum length for a division name is 3 characters.','',''),('CorpDiv1NameInvalidSomeChar','notify','The name for Division 1 contains an illegal character.','',''),('CorpDiv1NameInvalidTaken','notify','The name for Division 1 is already taken.','',''),('CorpDiv2NameInvalid','notify','The name for Division 2 is not valid.','',''),('CorpDiv2NameInvalidBannedWord','notify','The name for Division 2 contains a banned word.','',''),('CorpDiv2NameInvalidFirstChar','notify','The first character for Division 2s name is illegal.','',''),('CorpDiv2NameInvalidLastChar','notify','The last character in Division 2s name is illegal.','',''),('CorpDiv2NameInvalidMaxLength','notify','The name for Division 2 is invalid. Maximum length for a division name is 24 characters.','',''),('CorpDiv2NameInvalidMinLength','notify','The name for Division 2 is invalid. Minimum length for a division name is 3 characters.','',''),('CorpDiv2NameInvalidSomeChar','notify','The name for Division 2 contains an illegal character.','',''),('CorpDiv2NameInvalidTaken','notify','The name for Division 2 is already taken.','',''),('CorpDiv3NameInvalid','notify','The name for Division 3 is not valid.','',''),('CorpDiv3NameInvalidBannedWord','notify','The name for Division 3 contains a banned word.','',''),('CorpDiv3NameInvalidFirstChar','notify','The first character for Division 3s name is illegal.','',''),('CorpDiv3NameInvalidLastChar','notify','The last character in Division 3s name is illegal.','',''),('CorpDiv3NameInvalidMaxLength','notify','The name for Division 3 is invalid. Maximum length for a division name is 24 characters.','',''),('CorpDiv3NameInvalidMinLength','notify','The name for Division 3 is invalid. Minimum length for a division name is 3 characters.','',''),('CorpDiv3NameInvalidSomeChar','notify','The name for Division 3 contains an illegal character.','',''),('CorpDiv3NameInvalidTaken','notify','The name for Division 3 is already taken.','',''),('CorpDiv4NameInvalid','notify','The name for Division 4 is not valid.','',''),('CorpDiv4NameInvalidBannedWord','notify','The name for Division 4 contains a banned word.','',''),('CorpDiv4NameInvalidFirstChar','notify','The first character for Division 4s name is illegal.','',''),('CorpDiv4NameInvalidLastChar','notify','The last character in Division 4s name is illegal.','',''),('CorpDiv4NameInvalidMaxLength','notify','The name for Division 4 is invalid. Maximum length for a division name is 24 characters.','',''),('CorpDiv4NameInvalidMinLength','notify','The name for Division 4 is invalid. Minimum length for a division name is 3 characters.','',''),('CorpDiv4NameInvalidSomeChar','notify','The name for Division 4 contains an illegal character.','',''),('CorpDiv4NameInvalidTaken','notify','The name for Division 4 is already taken.','',''),('CorpDiv5NameInvalid','notify','The name for Division 5 is not valid.','',''),('CorpDiv5NameInvalidBannedWord','notify','The name for Division 5 contains a banned word.','',''),('CorpDiv5NameInvalidFirstChar','notify','The first character for Division 5s name is illegal.','',''),('CorpDiv5NameInvalidLastChar','notify','The last character in Division 5s name is illegal.','',''),('CorpDiv5NameInvalidMaxLength','notify','The name for Division 5 is invalid. Maximum length for a division name is 24 characters.','',''),('CorpDiv5NameInvalidMinLength','notify','The name for Division 5 is invalid. Minimum length for a division name is 3 characters.','',''),('CorpDiv5NameInvalidSomeChar','notify','The name for Division 5 contains an illegal character.','',''),('CorpDiv5NameInvalidTaken','notify','The name for Division 5 is already taken.','',''),('CorpDiv6NameInvalid','notify','The name for Division 6 is not valid.','',''),('CorpDiv6NameInvalidBannedWord','notify','The name for Division 6 contains a banned word.','',''),('CorpDiv6NameInvalidFirstChar','notify','The first character for Division 6s name is illegal.','',''),('CorpDiv6NameInvalidLastChar','notify','The last character in Division 6s name is illegal.','',''),('CorpDiv6NameInvalidMaxLength','notify','The name for Division 6 is invalid. Maximum length for a division name is 24 characters.','',''),('CorpDiv6NameInvalidMinLength','notify','The name for Division 6 is invalid. Minimum length for a division name is 3 characters.','',''),('CorpDiv6NameInvalidSomeChar','notify','The name for Division 6 contains an illegal character.','',''),('CorpDiv6NameInvalidTaken','notify','The name for Division 6 is already taken.','',''),('CorpDiv7NameInvalid','notify','The name for Division 7 is not valid.','',''),('CorpDiv7NameInvalidBannedWord','notify','The name for Division 7 contains a banned word.','',''),('CorpDiv7NameInvalidFirstChar','notify','The first character for Division 7s name is illegal.','',''),('CorpDiv7NameInvalidLastChar','notify','The last character in Division 7s name is illegal.','',''),('CorpDiv7NameInvalidMaxLength','notify','The name for Division 7 is invalid. Maximum length for a division name is 24 characters.','',''),('CorpDiv7NameInvalidMinLength','notify','The name for Division 7 is invalid. Minimum length for a division name is 3 characters.','',''),('CorpDiv7NameInvalidSomeChar','notify','The name for Division 7 contains an illegal character.','',''),('CorpDiv7NameInvalidTaken','notify','The name for Division 7 is already taken.','',''),('CorpHasNoMoneyToPayoutDividends','info','No Funds Available::It is not possible to pay out a dividend now as the corporation has no funds available to do so.','',''),('CorpHQIsAtThisStation','info','Relocating HQ::Your corporation\'s HQ is already located at this station.','',''),('CorpMembersHint','notify','Lists the members of the corporation.','',''),('CorpNameInvalid','notify','Corporation name is not valid.','',''),('CorpNameInvalidBannedWord','notify','Corporation name contains a banned word.','',''),('CorpNameInvalidFirstChar','notify','First character in corporation name is illegal.','',''),('CorpNameInvalidLastChar','notify','Last character in corporation name is illegal.','',''),('CorpNameInvalidMaxLength','notify','Maximum length for a corporation name is 24 characters.','',''),('CorpNameInvalidMinLength','notify','Minimum length for a corporation name is 4 characters.','',''),('CorpNameInvalidSomeChar','notify','Corporation name contains an illegal character.','',''),('CorpNameInvalidTaken','notify','Corporation name is already taken.','',''),('CorporationCreationFailed','info','Create Corporation Failed::The corporation %(corporationName)s could not be created due to the following reason: %(reason)s','',''),('CorporationMembershipFull','info','Corporation Membership Full::Unable to accept application. The CEO can only manage %(limit)d members, and there are currently %(count)d members.','',''),('CorporationNameNotUnique','info','Name Taken::%(corporationName)s already exists, please choose another name.','',''),('CorpSanctionableActionsHint','notify','Lists the votes that have closed where there is a mandate to sanction the action that was the subject of the vote.','',''),('CorpSecurityStatusTooLow','info','Security Status::The security status of your corporation is too low for you to do that.','',''),('CorpStandingsHint','notify','How you feel about other corporations and individuals.','',''),('CorpTickerNameInvalid','notify','Corporation ticker name is not valid.','',''),('CorpTickerNameInvalidTaken','notify','Corporation ticker name is taken.','',''),('CorpVoteCaseClosed','info','Voting Period Closed::The voting period for the vote you attempted to vote in has closed. Your vote has not been registered.','',''),('CorpVotesHint','notify','Displays votes, current and old. You can vote here, CEOs can propose votes here, and individuals with the CEO skill can try and take over the corporation here (if they are a shareholder).','',''),('CorpWarsHint','notify','Displays the status of on going wars. This includes the wars you are directly involved in and all other wars.','',''),('CouldNotComply','notify','Could not perform operation, because operation %(currentOp)s is underway.','',''),('CouldNotConnect','info','Couldn\'t connect','',''),('CrpAccessDenied','info','Access Denied::You have been denied access for the following reason: %(reason)s.','',''),('CrpAlreadyVoted','info','Already Voted::You have already cast your vote, you cannot do it again.','',''),('CrpApplicationAlreadyExists','info','Not Possible::You have already submitted an application to this corporation','',''),('CrpCanNotChangeCorpInSpace','info','Not Possible In Space::You can not change your corporation while you are in space.','',''),('CrpCanNotGoToWarAgainst','info','Illegal War::You can not attempt to declare war against that corporation because they have not killed any of you corporations members within the past 48 hours.','',''),('CrpCanNotKickMemberInSpace','info','Not Possible In Space::You can not kick out this member of your corporation as they are currently in space. Please try again later. You may want to consider removing all roles and grantables from them.','',''),('CrpCanNotRelocateClonesAsNoHQ','info','Unable To Comply::The requested clone contract(s) can not be moved. As there is no where to move them to.','',''),('CrpCanNotSanctionWarAgainstOwner','info','Can Not Sanction War::The war can not be sanctioned as it is against a member of an alliance. If you want to go to war with them then you will have to declare war against the whole alliance.','',''),('CrpCanOnlyAcceptOneApplication','info','Not Possible::You can only accept one application at a time.','',''),('CrpCantDeclareWarOnNPCCorp','info','You Cannot Declare War Against Them::You cannot declare war against that corporation.','',''),('CrpCantLockItemNotYours','info','Locking Operation Failed::The item can not be locked as it is not yours.','',''),('CrpCantQuitNotCompletedStasisPeriod','info','Unable To Comply::Member %(charname)s has entries in the role log that are %(hour)s hours old.<br>A member cannot leave a corporation unless they have gone through the mandatory stasis period. The stasis period is defined as having no roles and no grantable roles and no role changes and no grantable role changes for 24 hours. The stasis period begins when all roles and grantable roles have been removed from the member.<br>Please try again in %(hoursleft)s hours.','',''),('CrpCantQuitNotCompletedStasisPeriodIsBlocked','info','Unable To Comply::Member %(charname)s has entries in the role log that are %(hour)s hours old.<br>A member cannot leave a corporation unless they have gone through the mandatory stasis period. The stasis period is defined as having no roles and no grantable roles and no role changes and no grantable role changes for 24 hours. The stasis period begins when all roles and grantable roles have been removed from the member.<br>Please try again in %(hoursleft)s hours.<br>Note that you are now blocked from receiving any new roles. To accept new roles again, right-click your character entry and select \'Allow new roles\'.','',''),('CrpCantQuitNotInStasis','info','Unable To Comply::A member with roles or grantable roles cannot leave a corporation. Member %(charname)s has the following %(rolelist)s<br>A member cannot leave a corporation unless they have gone through the mandatory stasis period. The stasis period is defined as having no roles and no grantable roles and no role changes and no grantable role changes for 24 hours. The stasis period begins when all roles and grantable roles have been removed from the member.<br>Please try again 24 hours after all roles and grantable roles have been removed from this member.','',''),('CrpCantUnlockWhatYouDontKnowAbout','info','Locking Operation Failed::You can unlock the item as you dont know that it is locked.','',''),('CrpCEOQuitBody','notify','%(OldCEOsName)s has resigned from the position of CEO with %(CorporationName)s. As their last move they appointed %(NewCEOsName)s as CEO.','',''),('CrpCEOQuitHeading','notify','%(NewCEOsName)s is the new CEO of %(CorporationName)s','',''),('CrpCharNotInThisCorp','info','Who?::The specified corporation member is not a member of this corporation.','',''),('CrpConfirmMutualWar','question','Mutual War?::Do you want to make this war mutual? Doing so will remove the requirement for bills to be paid by the declarer in order to continue the war.','',''),('CrpConfirmRetractWar','question','Retract War?::Retracting a war can only be performed by the CEO of the corporation that declared the war. Once retracted the war will be considered over after approximately 24 hours. Do you want to retract this war?','',''),('CrpConfirmUnmutualWar','question','No longer mutual?::This war is currently mutual. That means that the declarer does not pay bills for continuing the war. Do you want to end this mutual war state and have the declarer pay bills for continuing the war?','',''),('CrpDataNotOldEnoughForRefresh','info','Please Wait::The corporation member data you currently have is less than 5 minutes old. You may not refresh the data until it is more than 5 minutes old. If you wish to see the up to date roles of a member right click the member and select the option to view or edit their member details.','',''),('CrpDestroyCorpWarning','warning','Close Corporation?::You are the only current member of your corporation. If you resign as CEO you will permanently close the corporation.<br>If you continue then all your corporation\'s assets will be acquired by the local authorities and shipped to the nearest smelting plant to cover the cost of shipping them there. You will receive no money for any item owned by your corporation.<br>It is HIGHLY RECOMMENDED that you check out the Assets section in the corporation window before continuing.<br><br>Are you sure you want to resign as CEO and close your corporation?','',''),('CrpHQChangeStillBeingRegistered','info','HQ Registration In Process::The HQ of your corporation was changed within the last hour. You must wait for the registration to complete before you can change it again.','',''),('CrpItemIsLocked','info','Item Is Locked::The requested operation could not be perfomed on this item as it is locked.','',''),('CrpItemIsNotLocked','info','Item Is Not Locked::The requested operation could not be perfomed on this item as it is not locked.','',''),('CrpJunkAcceptCost','question','Impounded Items Release Fee::The items from your corporate hangar have been impounded due to the none payment of bills for the hangar. If you wish to have the items released to you, you must pay for them. The cost is %(cost)s ISK. Do you accept this fee?','',''),('CrpJunkContainsLockedItem','info','Locked Item Issue::The impounded items contain at least one locked item. You can not retrieve the impounded items until the locks(s) have been removed. If you have a locked item here, you need to propose a vote to unlock the item before getting the impounded items back.','',''),('CrpJunkOnlyAvailableToDirector','info','No Hangar?::The lease on your corporate hangar has expired. Its contents has been impounded. In order to have the contents released either rent another hangar or have a director or your CEO attempt to open the hangar.','',''),('CrpJunkPriceChanged','info','Impounded Items Release Fee::The level of the fee has just been changed. Please enquire about the release of the items again.','',''),('CrpLockedItemNotFound','info','Locking Operation Failed::The requested operation failed as the item could not be located.','',''),('CrpLockFailedIllegalItemType','info','Locking Operation Failed::The item can not be locked as it is of a type that is not supported by the lockdown system.','',''),('CrpLockFailedItemNotFound','info','Locking Operation Failed::The locking operation failed as the item to lock could not be located.','',''),('CrpLockFailedOnlyBlueprintOriginals','info','Locking Operation Failed::Only blueprint originals can be locked down.','',''),('CrpMembersSaveChanges','question','Save Changes?::Do you want to save the changes you made before updating the corporation members information?','',''),('CrpOnlyDirectorCanCancelRent','info','Access Denied::You have to be a Director of the corporation in order to cancel the rental agreement for an office.','',''),('CrpOnlyDirectorsCanProposeVotes','info','Failed to Issue Vote::To issue a vote you must either be the active CEO or a Director.','',''),('CrpRecruitmentRegionAdExists','info','An advertisement currently exists within this region! You can either delete or edit the existing one.','',''),('CrpRolesDenied','info','Roles Denied::%(member)s is not willing to accept new roles.','',''),('CrpStationTransferAllianceMembersOnly','notify','You can only transfer the ownership of the station to a corporation in your alliance.','',''),('CrpTitlesSaveChanges','question','Save Changes?::Do you want to save the changes you made before updating the corporation titles information?','',''),('CrpTooManyWarDeclarations','info','Too Many Wars::You can only be at war with so many other corporations at once. If you really want to go to war with this corporation then finish off one of the other wars you are involved in.','',''),('crpUnrentOffice','question','Are You Sure?::If your corporation has factory or research jobs that are using this office then those jobs may fail if you unrent this office. Are you sure you want to unrent this office now?','',''),('crpUnrentOfficeWithContent','question','Are You Sure?::Are you sure that you want to unrent this office. It would appear that there is content in the office currently. Unrenting the office will cause the content to be impounded. If you want to get the items back you will have to pay for them. Are you sure you want to unrent the office now?','',''),('CrystalDestroyed','notify','%(module)s deactivates due to the destruction of the %(type)s it was fitted with.','',''),('CrystalRequired','notify','%(module)s requires a crystal to be fitted to it, before it can be activated.','',''),('CSPAChatACLCheck','question','Accept CSPA Service Charge::This chat access control operation would result in a notification message being sent, and is thus subject to a CSPA service charge of %(amountISK)s, which you must accept to complete the invitation.<br><br>According to the CONCORD Spam Prevention Act, all communication initiations between parties that have not explicitly whitelisted each other through the use of an access control list shall be subject to a configurable service fee which shall be collected by the Fluid comm operator.','',''),('CSPAChatCheck','question','Accept CSPA Service Charge::This chat invitation is subject to a CSPA service charge of %(amountISK)s, which you must accept to complete the invitation.<br><br>According to the CONCORD Spam Prevention Act, all communication initiations between parties that have not explicitly whitelisted each other through the use of an access control list shall be subject to a configurable service fee which shall be collected by the Fluid comm operator.','',''),('CSPAGangCheck','question','Accept CSPA Service Charge::This fleet invitation is subject to a CSPA service charge of %(amountISK)s, which you must accept to complete the invitation.<br><br>According to the CONCORD Spam Prevention Act, all communication initiations between parties that have not explicitly whitelisted each other through the use of an access control list shall be subject to a configurable service fee which shall be collected by the Fluid comm operator.','',''),('CSPAMailCheck','question','Accept CSPA Service Charge::This evemail message is subject to a CSPA service charge of %(amountISK)s, which you must accept to complete the invitation.<br><br>According to the CONCORD Spam Prevention Act, all communication initiations between parties that have not explicitly whitelisted each other through the use of an access control list shall be subject to a configurable service fee which shall be collected by the Fluid comm operator.','',''),('CurrentLocation','notify','Current location is %(itemname)s','',''),('CustomError','error','%(error)s','',''),('CustomInfo','info','%(info)s','',''),('CustomNotify','notify','%(notify)s','',''),('CustomQuestion','question','%(header)s::%(question)s','',''),('CustomWarning','warning','%(header)s::%(warning)s','',''),('CynoMustBeInGang','info','Cannot start Cynosural Field::You must be in a fleet to activate your Cynosural Field.','',''),('CynosuralGenerationJammed','notify','You are unable to generate a cynosural field while there is a jammer present and active somewhere in this solar system.','',''),('DateToOld','info','The %(datename)s date is too old','',''),('DeadAfterEject','notify','It seems that ejecting without a capsule results in some complications. ','',''),('DeleteEntry','question','Delete Entry?::Do you want to delete the entry?','',''),('DeleteNote','question','Delete Note?::Do you want to delete the note?','',''),('DeniedActivateCloaked','notify','Interference from the cloaking you are doing is preventing your systems from functioning at this time.','',''),('DeniedActivateControlling','notify','You are unable to activate any modules while you are controlling some other objects.','',''),('DeniedActivateFrozen','notify','You are unable to activate any modules because you have been frozen by a GM.','',''),('DeniedActivateInJump','notify','Interference from the jump you are doing is preventing your systems from functioning at this time.','',''),('DeniedActivateInWarp','notify','Interference from the warp you are doing is preventing your systems from functioning at this time.','',''),('DeniedActivateTargetAssistDisallowed','notify','You cannot activate that module on the target as interference prevents assistance from being given to them.','',''),('DeniedActivateTargetModuleDisallowed','notify','You cannot activate that module on the target as interference prevents modules of that type from being used on them.','',''),('DeniedActivateTargetNotPresent','notify','You cannot activate that module as the target is no longer present.','',''),('DeniedActivateTargetOffModDisallowed','notify','You cannot activate that module on the target as interference prevents modules of that type from being used on them.','',''),('DeniedInvulnerable','notify','Your ship is realigning its magnetic field, please wait a moment.','',''),('DeniedStationInvulnerableSovereign','notify','%(modulename)s deactivates as the target %(targetname)s is invulnerable because its owning alliance holds sovereignty in this solarsystem.','',''),('DeniedTargetAfterCloak','notify','You cannot perform that action at this time as your systems are still recalibrating after the use of a cloaking device.','',''),('DeniedTargetEvadesSensors','notify','You are unable to target the %(targetName)s as your sensors are unable to lock onto it.','',''),('DeniedTargetForceField','notify','You failed to target %(target)s, they are within range %(range)s m of a %(item)s and with you being outside of it, it is preventing you from holding a lock on them.','',''),('DeniedTargetingAttemptFailed','notify','Your attempt to target %(target)s failed.','',''),('DeniedTargetingCloaked','notify','You cannot target anything while you are cloaked.','res:/Sound/ui/voc/DeniedTargetingCloaked.ogg',''),('DeniedTargetingInsideField','notify','You cannot target the %(target)s while you are inside a force field.','',''),('DeniedTargetingTargetCloaked','notify','You failed to target nothing.','',''),('DeniedTargetInvulnerable','notify','Target is invulnerable.','',''),('DeniedTargetOtherFrozen','notify','You are unable to target %(targetName)s because they are currently frozen by a GM.','',''),('DeniedTargetOtherWarping','notify','Interference from the warp %(targetName)s is preventing your sensors from getting a target lock on them.','',''),('DeniedTargetReinforcedStructure','notify','You failed to target %(target)s as it is locked down in reinforced mode.','',''),('DeniedTargetSelf','notify','You cannot target your own ship.','',''),('DeniedTargetSelfFrozen','notify','You are unable to target %(targetName)s because you have been frozen by a GM.','',''),('DeniedTargetSelfWarping','notify','Interference from the warp you are doing is preventing your sensors from getting a target lock on %(targetName)s.','',''),('DeniedTargetUntargetable','notify','You are unable to target %(targetName)s as it has been made untargetable by a GM.','',''),('DestinationOverloaded','notify','The move cannot be completed as there is not enough space left in the destination.  In fact, given that the destination is overloaded you are lucky it doesn\'t break.','',''),('DestinationSameAsPackage','info','Information::The destination you selected is the same as the location of the package.<br>Please select another destination.','',''),('DeteisFemale','notify','Female Deteis tend to be neat and composed with a wry sense of humor and a no non-sense look on life.','',''),('DeteisMale','notify','Male Deteis are generally tall, well groomed with a fair complexion. They strike an imposing figure with their haughty and detached demeanor.','',''),('DiodeClick','audio','','res:/sound/ui/uigreenlight01.wav',''),('DiodeDeselect','audio','','res:/sound/ui/DiodeDeselect.wav',''),('DirtySession','info','Local Session Corrupt::The client\'s local session information is corrupt, probably as a result of failed cleanup during a disconnect.  Connecting to the server in this state could lead to a rather unpleasant game experience.  Please restart the client prior to logging in.','',''),('Disabled','audio','','res:/sound/ui/GlassyBeep25.wav',''),('DisabledFunctionality','notify','That functionality is disabled because %(reason)s.','',''),('DisabledMenuEntry','info','This menu entry is disabled.','res:/sound/ui/error07.wav',''),('Docking','audio','','',''),('DockingAborted','notify','The station %(stationname)s is too far away.','',''),('DockingAccepted','notify','Your docking request has been accepted. Your ship will be towed into station.','res:/Sound/ui/voc/DockAccepted.ogg',''),('DockingApproach','notify','Setting course to docking perimeter','',''),('DockingRequestDenied','info','Docking Request Denied::Your docking request has been denied. %(reason)s','res:/Sound/ui/voc/DockingDenied.ogg',''),('DockingRequestDeniedPaymentRequired','info','Docking Request Denied::Your docking request has been denied. You need to pay %(amount)s ISK to dock.','',''),('dockingTooFast','notify','Entry speed too high to dock. Should be less than %(speed)s m/s','',''),('DontHaveThermoDynamicsSkill','notify','You need thermodynamics skill at level %(skilllevel)s to overload this module','',''),('DontHaveType','info','Sorry, but to be able to sell you have to own at least one %(name)s','',''),('DragDropCharge','audio','','',''),('DragDropContainer','audio','','',''),('DragDropDrop','audio','','res:/sound/ui/FittingDrop.wav',''),('DragDropGrab','audio','','res:/sound/ui/FittingGrab.wav',''),('DragDropLoop','audio','','res:/sound/ui/FittingMove.wav',''),('DragDropSlot','audio','','',''),('DraggingItem','audio','','res:/sound/ui/phony.wav',''),('DroneCommandEngageRequiresNoAmbiguity','notify','You are commanding a group of drones to engage a target, but some of the drones offer assistance and some commit aggression.  This is not possible as the conflicting signals cause interference.','',''),('DroneCommandRequiresActiveTarget','notify','To give this command to a drone requires that you have an active target.  Get one and try again.','res:/Sound/ui/voc/DrnCmdRqrsActveTarget.ogg',''),('DroneCommandRequiresShipButNotCapsule','notify','To give this command to a drone requires that the active target be a ship, but not a capsule.','',''),('DroneCommandRequiresShipPilotedGangMember','notify','To give this command to a drone requires that the active target be piloted and piloted by a fleet member.','',''),('DroneHasSkillPrerequisites','notify','Unable to launch %(itemName)s. This action requires having learned the following skills: %(requiredSkills)s.','',''),('DronesDroppedBecauseOfBandwidthModification','notify','The drone control bandwidth of your ship has been modified causing you to lose the ability to control some drones.','',''),('DronesNotLoadableInSpace','notify','You cannot load to or unload from the drone bay while in space.','',''),('DroneTargetJammed','notify','The drone is target jammed and cannot be commanded to do that.','',''),('DropItemNotAssembled','notify','You cannot launch %(item)s that has not been assembled.','',''),('DropItemNotInDroneBay','notify','%(item)s cannot be dropped because it is not in your drone bay.','',''),('DropItemNotSuitable','notify','%(item)s cannot be dropped into space.','',''),('DropLocationUnsuitable','notify','You cannot safely launch %(dropitem)s within %(distance)s of %(items)s in space. ','',''),('DropNeedsPlayerCorp','notify','In order to launch %(item)s you need to be a member of a independent corporation.','',''),('DunAuthoringError','warning','This is an authoring bug: %(text)s','',''),('DunBlacklistCannotWarp','info','Can\'t Activate::This acceleration gate is not configured to handle your %(ship)s.<br>These ship groups are not handled:<br>%(list)s','',''),('DunCantAnchor','notify','You cannot anchor the %(type)s at this location because of interference from natural phenomena.','',''),('DunCantUseMWD','notify','You cannot activate this module here because natural phenomena are disrupting its operation.','',''),('DunGateLocked_ManyKeys','info','Can\'t Activate::This gate is locked! You need a number of %(key)s to activate this acceleration gate, but the manual doesn\'t say exactly how many or where to get them.','',''),('DunGateLocked_OneKey','info','Can\'t Activate::This gate is locked! The %(key)s must be retrieved and stored in your cargo hold when you activate it for it to be unlocked. The question that remains is, who (or what) is the gatekeeper?','',''),('DunGateLocked_ZeroKey','info','Can\'t Activate::This gate is locked! To activate it, you need to have %(key)s in your cargo hold. By all signs it will not be consumed upon use, so the only problem is to locate the thing!','',''),('DunGateNoSkill','info','Can\'t Activate::You need more know-how in %(skill)s to operate this particular jump gate.','',''),('DunGateNPCsAround','info','Can\'t Activate::This gate is locked! There are synchronized gate scramblers on all hostile entities in this deadspace pocket. Unless you are physically inside one of them to unscramble the signal, you must simply clear the vicinity of enemy ships. So grab your guns.','',''),('DunGateTooFarAway','info','Can\'t Activate::You are too far away from the acceleration gate to activate it! The sensors indicate that the minimum distance is %(maxdist)s meters.','',''),('DunPodsCannotWarp','info','Can\'t Activate::You can not go through an acceleration gate in an escape pod! It would be squished like an egg falling out of orbit.','',''),('DunShipCannotWarp','info','Can\'t Activate::This acceleration gate is not configured to handle your %(ship)s.<br>It handles:<br>%(whitelist)s','',''),('EducationFamilyTermMissing','info','%(name)s requires a Term 1 in some %(familyName)s.','',''),('EducationTerm1Missing','info','%(name)s requires an Education Term 1.','',''),('EducationTermMissing','info','Required Education Term Missing: %(name)s requires %(termName)s.','',''),('EffectAlreadyActive','notify','%(modulename)s is already %(effectname)s.','',''),('EffectCantHaveNegativeDuration','notify','%(modulename)s has somehow come to have a negative duration of %(duration)s and cannot operate.  If you know how, obtain a breakdown of its modifiers and report it, otherwise submit a detailed bug report.','',''),('EffectCrowdedOut','notify','The %(moduleName)s cannot be activated as it requires access to resources which %(count)d modules of the same purpose are already using up.','',''),('EffectDeactivationCloaking','notify','As certain activated effects interfere with the warping process, these are automatically being deactivated before the warp proceeds.','',''),('EffectDeactivationWarping','notify','As certain activated effects interfere with the warping process, these are automatically being deactivated before the warp proceeds.','',''),('EffectNotActivatible','notify','You do not have the ability to engage the %(moduleName)s in that action.','',''),('EffectNotDeactivatible','notify','The %(moduleName)s cannot be interrupted in that action.','',''),('EffectStillActivating','notify','The %(moduleName)s cannot be manually deactivated while it is still being activated.','',''),('EffectStillActive','notify','The %(moduleName)s cannot be manually deactivated in the middle of an operation, it will deactivate without repeating in %(timeLeft)0.1f seconds (its activation duration is %(duration)0.1f seconds).','',''),('EmailCONCORDSpamPreventionActConfirmation','question','Accept CSPA Service Charge::This email is subject to a CSPA service charge of %(amount)s ISK, which you must accept to complete the invitation.<br><br>According to the CONCORD Spam Prevention Act, all communication initiations between parties that have not explicitly whitelisted each other through the use of a central address book shall be subject to a nominal service fee which shall be collected by the Fluid comm operator.  %(char)s has not whitelisted you by any such means.','',''),('EndDragItem','audio','','res:/sound/ui/phony.wav',''),('EnergyWeaponWithFrequencies','info','%(moduleName)s has %(got)d frequencies loaded but can only function with %(want)d loaded.','',''),('EnergyWeaponWithoutFrequency','info','%(moduleName)s fails to function without a frequency loaded.','',''),('EnterCorporationName','info','What Corporation?::Please enter a name for your corporation.','',''),('EnterTickerName','info','No Ticker?::Please select a ticker for your corporation.','',''),('EntityActionSecurityLevelRestrictions','notify','You cannot do that.  That drone command requires you to be in a solar system with a security level less than %(needed)0.1f.','',''),('EntityBrokenCommand','notify','%(targetTypeName)s seems to be defective and does not respond to the command you are giving it.','',''),('EntityCurrentlyMining','notify','%(targetTypeName)s is currently mining an asteroid and cannot take commands until it has finished.  It will return home and await further orders when it is finished.','',''),('EntityDelegateInsideField','notify','The drone cannot be delegated while you are inside an active force field.','',''),('EntityDistantCommand','notify','%(targetTypeName)s is too far away and will not respond to the command you are giving it (must be within %(distance)s meters from it).','',''),('EntityHasSkillPrerequisites','notify','Skill Required::You do not have the required skills to do that. To command that drone requires having learned the following skills: %(requiredSkills)s.','',''),('EntityIncapacitated','notify','%(target)s is incapacitated due to damage or abandonment and will not respond to the command you are giving it.','',''),('EntityIncapacitatedCommand','notify','%(targetTypeName)s is incapacitated due to damage or abandonment and will not respond to the command you are giving it (try scooping it).','',''),('EntityInvalidTarget','notify','%(targetTypeName)s can only perform that action on %(desiredTarget)s.','',''),('EntityNoTargetDroneManagementAbilities','notify','Control of the %(item)s cannot be delegated to %(whom)s because they do not have the skill to control any drones.','',''),('EntityNoTargetDroneManagementAbilitiesLeft','notify','Control of the %(item)s cannot be delegated to %(whom)s because they only have the skill to control %(limit)s drones and they are already controlling that many.','',''),('EntityNotPresent','notify','%(targetTypeName)s cannot be commanded as it is not actually present.','',''),('EntityNotYoursToCommand','notify','%(targetTypeName)s does not respond to your commands.','',''),('EntityTargetAlreadyHasControl','notify','Control of the %(item)s cannot be delegated to %(whom)s because they already have control of it.','',''),('EntityTargetCharInCapsule','notify','The drone cannot be commanded with respect to %(targetChar)s because the pilot is in a capsule.','',''),('EntityTargetCharNotPresent','notify','The drone cannot be commanded with respect to %(targetChar)s because they are not present in this solarsystem.','',''),('EntityTargetMustBeGangMember','notify','Drones can only accept that command if %(targetOwner)s is a member of your fleet, which they are not.','',''),('EntityTargetMustBeTargeted','notify','%(targetTypeName)s requires the target be locked onto by you, which it is not.','',''),('EntityTargetNotPresent','notify','%(targetTypeName)s cannot be commanded to work on a target that is no longer present.','',''),('EntityTargetTooDistant','notify','The drones fail to execute your commands as the target %(targetTypeName)s is not within your %(distance)s m drone command range.','',''),('EntityTargetWarpDisrupted','notify','Control of the %(item)s cannot be delegated to someone who the drones cannot warp to.','',''),('EntityToolRequirements','notify','You cannot do that.  The drone you use on the %(tGroup)s needs to have the following in its skill requirements: %(skills)s.','',''),('EntityUnknownCommand','notify','%(targetTypeName)s does not recognize the command you are trying to give it.','',''),('EpiExpired','info','Path Stale::So much time has passed since this lead was given, that it is no longer accurate enough to be followed. You should delete it.','',''),('EpiWrongSolarSystem','info','Wrong solar system::This refers to another solar system','',''),('Err','error','%(text)s','',''),('ErrMessageDictMissing','fatal','Message arguments missing::Message: \'%(msgid)s\'<br>Text: %(text)s','',''),('ErrMessageKeyError','fatal','Message formatting error::Message: \'%(msgid)s\'<br>Text: %(text)s<br>Args: %(args)s<br>Error: %(err)s','',''),('ErrMessageNotFound','fatal','Message not found::Message: \'%(msgid)s\'<br>Args: %(args)s','',''),('error','audio','','res:/sound/ui/error07.wav',''),('ErrorItemNotAtStation','info','Where\'s the %(item)s::The %(item)s cannot be located. If the %(item)s is in your cargo hold, try moving it to your hangar and then try completing the objective again.','',''),('ErrSystemError','fatal','System Error::%(text)s','',''),('ESPERROR','error','%(error)s','',''),('event','audio','','res:/sound/ui/PrinterBeep02.wav',''),('ExpiryDatePassed','info','Passed Expiry Date::The expiry date has already been and gone. Please choose an expiry date that is in the future.','',''),('facAcceptEjectMaterialLoss','question','Accept Loss?:s:By ejecting this job you will loose the time spent on the current batch. If the job requires materials then you will loose some of the materials that are required for the batch. You can check if the job requires materials by looking at the bill of materials for the job. Are you sure that you want to eject this job?','',''),('FacSlotNotUsed','notify','The slot requested is not in use','',''),('FacSlotUsed','notify','The slot requested is in use','',''),('FactionCharJoinDenied','info','Faction Join Denied::You can not join the faction for the following reason: %(reason)s.','',''),('FactionCorpJoinDenied','info','Faction Join Denied::Your corporation can not join the faction for the following reason: %(reason)s','',''),('FactionCorpLeaveDenied','info','Faction Leave Denied::Your corporation can not leave the faction for the following reason: %(reason)s.','',''),('FactionCorpStayDenied','info','Faction Leave Withdraw Denied::Your corporation can not withdraw it\'s request to leave the faction for the following reason: %(reason)s.','',''),('FactionCorpWithdrawDenied','info','Faction Join Withdraw Denied::Your corporation can not withdraw it\'s request to join the faction for the following reason: %(reason)s.','',''),('FactionNotValid','info','Request Denied::Invalid faction request','',''),('factoriesBtnEnter','audio','','res:/sound/ui/uihme01.wav',''),('factoriesHeader','audio','','res:/sound/ui/uihfcttxt02.wav',''),('FactoryEnter','audio','','res:/sound/ui/mentersmall.wav',''),('FactorySelect','audio','','res:/sound/ui/smallselect.wav',''),('FactorySlotLoaded','audio','','res:/sound/ui/uiFctMenu.wav',''),('FacWarBunkerNonVulnerable','notify','The Control Bunker in this system is no longer vulnerable to attacks by <b>%(faction)s</b>.','',''),('FacWarBunkerVulnerable','notify','The Control Bunker in this system has become vulnerable to attacks by <b>%(faction)s</b>.','',''),('FacWarDungeonConquered','notify','You have conquered a Tactical Site for %(faction)s','',''),('FacWarDungeonDefended','notify','You have defended a Tactical Site for %(faction)s','',''),('FacWarNoRewardForCapturedSystem','hint','This system is in a state of transition. In the resulting chaos, nobody has noticed your victory here.','',''),('FacWarNoRewardForUncontestedSystem','hint','While recognizing your dedication to the cause, the %(factionname)s declines to reward you for defending this uncontested system','',''),('FacWarSystemWon','notify','This solar system has been won by <b>%(faction)s</b>!','',''),('FacWarWarningUndock','question','Undock Confirmation:s:Undocking from this station will result in you being immediately attacked by the faction Navy of our enemy.  Are you sure you wish to undock?\n','',''),('FailedPlugInImplant','info','Skill In Training::You cannot plug in an implant while a skill is being trained.  Cancel your skill training first, or wait until it completes.','',''),('FailedToAuthenticate','info','Failed to Authenticate','',''),('FakeItemNotFound','notify','The item is no longer within your reach.','',''),('fatal','audio','','res:/sound/ui/error09.wav',''),('fittingBtnEnter','audio','','res:/sound/ui/uihme02.wav',''),('FittingHasSkillPrerequisites','notify','You do not have the required skills to do that. To fit and use that item requires having learned the following skills: %(requiredSkills)s.','',''),('fittingHeader','audio','','res:/sound/ui/uihftxt02.wav',''),('FittingLauncher','notify','Loading %(qty)d %(ammotype)ss into %(launchertype)s. This will take approx. %(sec)d seconds.','res:/sound/ui/GlassyBeep18.wav',''),('fittingSlotHi','audio','','res:/sound/ui/fittingsHi.wav',''),('fittingSlotLo','audio','','res:/sound/ui/fittingsLo.wav',''),('fittingSlotMed','audio','','res:/sound/ui/fittingsMed.wav',''),('FullComtool','info','The channel manager can only hold ten items','',''),('GangAlreadyBooster','notify','This fleet member is already a Booster.','',''),('gangAlreadyLeader','info','There is already a leader in this fleet.','',''),('GangAlreadyMoving','notify','One or more of your fleet members are already being shuffled around. Please try again in a few moments.','',''),('GangBoosterIllegal','info','Cannot be a Booster::This fleet member cannot be converted to the requested Booster role.','',''),('GangBoosterRoleFull','notify','This Booster role is already taken.','',''),('GangCandidateDodgy1','question','Fleet Candidate Dodgy:s:The pilot that you wish to add to your fleet is at war with the corporation <b>%(corpName)s</b>. Confirming that you want him to join your fleet might make all your fleet members vulnerable to this corporation, however they will not be vulnerable to other members of your fleet that are not at war with this corporation unless they decide to attack you. Are you sure you want to add this pilot to your fleet?','',''),('GangCandidateDodgyN','question','Fleet Candidate Dodgy:s:The pilot that you wish to add to your fleet is at war with these corporations <b>%(corpNames)s</b>. Confirming that you want him to join your fleet might make all your fleet members vulnerable to these corporations, however they will not be vulnerable to other members of your fleet that are not associated with war with these corporations unless they decide to attack you. Are you sure you want to add this pilot to your fleet?','',''),('gangCandidateNotInvited','info','There is no invitation to join the fleet standing.','',''),('GangCandidateOffline','info','Invitee Offline::%(invitee)s is offline and thus of no value to your fleet.','',''),('GangCannotDeleteNonEmptySquad','info','Squad not empty::The squad you are trying to remove contains members. You cannot remove the squad unless it is empty. Please move all the squad members to another squad before trying again.','',''),('GangCannotDeleteNonEmptyWing','info','Wing not empty::The wing you are trying to remove contains members. You cannot remove the wing unless it is empty. Please move all the wing members to another wing before trying again.','',''),('GangCannotDoInStation','info','You must be in space::You cannot perform this Fleet action in a station. You must be in space to do that.','',''),('GangCannotSendBroadcastToSelectedGroup','info','Cannot broadcast to group::Your fleet role prohibits you from sending that broadcast to the selected group of fleet members.','',''),('GangCantKickBoss','info','Cannot kick Boss::You cannot kick the Boss in your fleet. It wouldn\'t be right!','',''),('GangCONCORDSpamPreventionActConfirmation','question','Accept CSPA Service Charge::This fleet invitation is subject to a CSPA service charge of %(amount)s ISK, which you must accept to complete the invitation.<br><br>According to the CONCORD Spam Prevention Act, all communication initiations between parties that have not explicitly whitelisted each other through the use of a central address book shall be subject to a nominal service fee which shall be collected by the Fluid comm operator.  %(char)s has not whitelisted you by any such means.','',''),('GangConfirmAutoJoinVoice','question','Join Fleet Voice?::The Fleet Leader wishes the fleet to be voice enabled through Eve-Voice. Would you like to automatically join relevant voice channels in this fleet?<br>\n<br>\nIf you choose \'no\' you will not be asked again but you will still be able to join voice manually.','',''),('GangConfirmDemoteSelf','question','Demote yourself?::Are you sure you want to demote yourself? You will lose command doing so!','',''),('GangConfirmVoiceEnable','question','Voice Enable Fleet?:s:Do you want to request that all the current and future members of this fleet join the fleet audio channels for voice communication?\n<br><br>Note that each fleet member can choose not to join audio if you select this option. Additionally, even though this option is not selected each member can manually join audio channels in the fleet.','',''),('GangError','notify','There was an error communicating with your fleet.','',''),('gangMemberAlreadyInGroup','info','This person is already in your fleet.','',''),('gangMemberAlreadyInvited','info','This person already has an invitation to your fleet.','',''),('GangMemberNotFound','info','Member not found::The requested member was not found in your fleet. It is possible he or she has left the fleet.','',''),('GangMembersDodgy1','question','Join Warring Fleet?:s:%(name)s wants you to join their fleet, do you accept?<br><br>This fleet has members that are at war with the corporation %(corpName)s. Confirming that you will join this fleet will make you vulnerable to this corporation, however they will not be vulnerable to you unless they decide to attack you. Are you sure you want to join this fleet?<br><br>NOTE: Attacking members of your fleet is not a CONCORD sanctioned activity and may result in security status loss and a police response.','',''),('GangMembersDodgyN','question','Join Warring Fleet?:s:%(name)s wants you to join their fleet, do you accept?<br><br>This fleet has members that are associated with war with these corporations %(corpNames)s. Confirming that you will join this fleet will make you vulnerable to these corporations, however they will not be vulnerable to you unless they decide to attack you. Are you sure you want to join this fleet?<br><br>NOTE: Attacking members of your gang is not a CONCORD sanctioned activity and may result in security status loss and a police response.','',''),('gangMustBeLeader','info','You must be the fleet\'s leader to perform this operation.','',''),('GangMustBeLeaderAndBoss','info','Must be Leader and Boss::You must have the role Fleet Commander <b>and</b> be the Fleet Boss in order to complete this operation.','',''),('gangMustBeMember','info','You must be a member of a fleet.','',''),('gangNoInviteInStation','notify','You cannot invite someone to fleet with you while you are in station.','',''),('GangNoPositionFound','info','No Position found::No position found for the invitee. You might have to create an additional squad to fit this member.','',''),('gangNoSuchGang','info','This fleet does not exist.','',''),('GangNotAllowed','info','Not allowed::You do not have permission to execute this command in your fleet.','',''),('gangNotAMember','info','This person is either not a member of your fleet or not present in this solarsystem.','',''),('GangNotCreator','info','Not boss::You are not the fleet boss. Only the creator of the fleet or his successor may do that.','',''),('GangNotFleet','info','Not a fleet::Your gang is required to be in a <b>Fleet</b> configuration to perform this action.','',''),('GangNotInGang','info','Not in a fleet::You do not appear to be in a fleet.','',''),('GangNotInvited','info','Not invited::You do not have an outstanding invitation to this fleet. It might have expired in which case you should contact the fleet leader to get a new invitation.','',''),('GangNotLeader','info','Not fleet leader::You are not the leader of your fleet. You must have fleet leader role to execute that command.','',''),('gangNotMemberOfAnyGang','notify','You are not member of any fleet','',''),('GangNotNPCCorp','info','Not in an NPC Corp::You cannot set your fleet to \"Self-Invite\"  if you are in an NPC corporation.','',''),('GangNotSelfInvite','info','No Self Invites::This fleet does not allow self-invites.','',''),('GangNotWingCommander','info','You are not Wing Commander::You are not this wing\'s Wing Commander and can therefore not execute this command.','',''),('GangNotYourAlliance','info','Not your alliance::You need to be in the same alliance as the boss in order to join this fleet.','',''),('GangNotYourCorp','info','Not your corporation::You need to be in the same corporation as the boss in order to join this fleet.','',''),('GangPositionFilled','info','Position filled::<b>%(owner)s</b> is already in that fleet position. You will have to remove the member from the position before you can place this member there.','',''),('GangPositionFilledInvite','info','Position filled::There is an outstanding invitation to <b>%(owner)s</b> for this fleet position.<br>\nYou will have to wait to see if the pending invitation is rejected or times out if you wish to place someone else into this position.','',''),('GangPositionFilledMove','info','Position filled::<b>%(owner)s</b> is being moved into this fleet position.<br><br>\nYou cannot move another person into this position unless the pending move operation does not succeed.','',''),('GangRegroup','notify','Regrouping to %(leader)s','',''),('GangsterNotInSystem','info','Gangster not in system','',''),('GangTooManyFavorites','info','Too many members on watch list:: Watch lists can support at most <b>%(num)s</b> members and you cannot add any more.','',''),('GangTooManyMembers','info','Too many members::Your fleet can support at most <b>%(num)s</b> members in the current configuration and you cannot invite any more.','',''),('GangTooManyMembersConvert','info','Too many members::Your gang can support at most <b>%(num)s</b> members in the configuration you are converting to. You currently have <b>%(curr)s</b> members in your gang and will have to kick some of them in order to complete this operation.','',''),('GangTooManyMembersInSquad','info','Too many members in squad::Squads can support at most <b>%(num)s</b> members and you cannot add any more.','',''),('GangTooManySquads','info','Too many squads::You cannot create a new squad in this wing because it already contains the maximum of <b>%(num)s</b> squads.','',''),('GangTooManyWings','info','Too many wings::You cannot create a new wing because your fleet already contains the maximum of <b>%(num)s</b> wings.','',''),('GangWarp','notify','Following %(leader)s in warp','',''),('GangYouAreAlreadyInGang','info','Already in a fleet::You appear to be already in a fleet.','',''),('GiveSharesSelectOwner','info','Please select recipient::You have to select a character or a corporation to give the shares to.','',''),('GPSTransportClosed','info','Connection Lost::%(what)s','',''),('GroupNameExists','info','A group named %(name)s already exists.','',''),('HangarNotFoundForInstalledItem','info','Hangar Not Found::The hangar you are trying to install an item from could not be found. If you are installing from a corporation hangar please check that it is still rented.','',''),('HarvestOnline','info','Select material to harvest::You need to choose a material to harvest before onlining the harvester.','',''),('HaveNoMoney','info','You don\'t have any money','',''),('HavetobeatstationOrinShip','info','Information::You either have to be located at a station or inside of a ship to be able to bookmark location','',''),('hint','audio','','res:/sound/ui/info.wav',''),('HitAverage','notify','You hit %(target)s with your %(weapon)s.','',''),('HitExcellent','notify','You place an excellent hit on %(target)s with your %(weapon)s.','',''),('HitGood','notify','You place a good hit on %(target)s with your %(weapon)s.','',''),('HitMiss','notify','You miss %(target)s with your %(weapon)s.','',''),('HitMissBad','notify','You miss %(target)s badly with your %(weapon)s.','',''),('HitMissClose','notify','You narrowly miss %(target)s with your %(weapon)s.','',''),('HorribleFittingProblems','info','Your ship has horrible hardware problems.  Some lunatic has tried some cowboy fitting maneuvers and somehow fitted more things that should be possible in dangerous ways.  Through a bizarre combination of luck they have been removed. %(extra)s. If possible, the excess were placed in your cargo hold, if not, then jettisoned into space or the hangar, or otherwise destroyed accidently.','',''),('HostNotFound','info','Host not found','',''),('ImplantHasSkillPrerequisites','info','The implant %(itemName)s requires the skill %(requiredSkills)s, which you don\'t have.','',''),('IncompatibleChargeGroup','notify','You cannot load %(ammoGroup)s into a %(moduleName)s, this ammo needs to be loaded into a %(launcherGroup)s.','',''),('IncompatibleChargeGroup1','notify','You cannot load %(ammoGroup)s into a %(moduleName)s, this module needs to be loaded with %(group1)s.','',''),('IncompatibleChargeGroup2','notify','You cannot load %(ammoGroup)s into a %(moduleName)s, this module needs to be loaded with %(group1)s or  %(group2)s.','',''),('IncompatibleChargeGroup3','notify','You cannot load %(ammoGroup)s into a %(moduleName)s, this module needs to be loaded with %(group1)s, %(group2)s or %(group3)s.','',''),('IncompatibleConsumptionType','notify','You cannot load %(offer)s into a %(moduleName)s, this object needs to be loaded with %(need)s.','',''),('IncompatibleModuleGroup','notify','You cannot fit %(moduleGroup)s onto a %(shipType)s, this module can only be fitted onto these ship groups: %(groups)s.','',''),('IncompatibleTypes','info','%(moduleName)s is currently loaded with another type of charge - %(existing)s, they need to be unloaded before %(new)s can be loaded.','',''),('IncorrectCompletionOrder','notify','You must complete the objectives in the correct order.','',''),('IncorrectDateFormat','info','Incorrect Date format, should be: YYYY-MM-DD','',''),('IncorrectTimeFormat','info','Incorrect Time format, should be: HH:MM:SS or HH:MM','',''),('InflightMenuActivate','audio','','',''),('InflightMenuEnter','audio','','res:/sound/ui/OnMenuEnter03.wav',''),('info','audio','','res:/sound/ui/info.wav',''),('infomodal','audio','','res:/sound/ui/info.wav',''),('InfoNoCorpWithID','info','Bad Corporation ID::You are trying to view information on a corporation that doesn\'t exist (e.g., a broken show-info link).','',''),('IngredientsMissingForBlueprint','info','The job failed to install because you need the following:','',''),('InsAskAcceptTerms','question','Insurance Terms::The selected item will be insured while in your possession for the duration of the contract. Repackaging the item will void the contract. The contract will be considered void if the item or ship is destroyed while being in the possession of somebody else. Do you accept the above terms and still want to insure the selected item?','',''),('InsAskAcceptTermsCorp','question','Insurance Terms::This ship will be <b>corporation</b> insured from your corporation\'s master wallet.\n<br>The selected item will be insured while in your possession for the duration of the contract. Repackaging the item will void the contract. The contract will be considered void if the item or ship is destroyed while being in the possession of somebody not in your corporation. \n<br>Should the ship be destroyed within the insurance period the payout will be made to your corporations master wallet.\n<br>Do you accept the above terms and still want to insure the selected item?','',''),('InsAskUnInsure','question','Cancel Insurance?::Are you sure you want to cancel the insurance on this ship?<br>\nYou will not get any money back and your ship will become uninsured!','',''),('InsCanNotInsureUnassembledShip','info','Uninsurable::It is not possible to insure an unassembled ship. Please assemble the ship and then try again.','',''),('InsCouldNotFindItem','info','Can Not Find Item::The item to be insuread can not be located. Please make sure that the item is present in your hangar or your corporate hangar.','',''),('InsPaymentTooSmall','info','Insurance Costs More::The insurace costs more than was estimated. You should only see this message if the base price of an item has changed while the server is running. To fix this you will have to restart.','',''),('InstallAsianFont','info','Recommended font not found!:s:The typeface recommend for East Asian languages is not found on your computer. To install files for East Asian languages click <b>OK</b> and check \"Install files for East Asian languages\".\nWould you like to do it now?','',''),('InstallAsianFontModal','warning','Recommended font not found!:s:The typeface recommend for East Asian languages is not found on your computer. To install files for East Asian languages click <b>OK</b> and check \"Install files for East Asian languages\".\nWould you like to do it now?','',''),('InstallFailedNoIndustrialCoreEffectOrNotInSpace','notify','You must be in space with your Industrial Core module active in order to install a job in this ship.','',''),('InstallFailedShipAssemblyLineBusy','notify','The assembly line is in use and no new jobs can be installed until the current job is delivered.\n','',''),('InstallingUpgradeRequiresRestart','question','Client Restart::Installing the client upgrade requires a client restart. Click OK to continue with upgrading the client.','',''),('InsufficientPrivileges','info','Insufficient privileges:s:Please run EVE with administrator rights to complete data migration.','',''),('insuranceHeader','audio','','res:/sound/ui/uihac.wav',''),('InsureShipAlreadyInsured','question','Ship already insured::The ship is already insured by <b>%(ownerName)s</b>.<br>If the insurance owner is not yourself or your corporation this insurance is worthless while the ship is in your possession.\n<br>\n<br>Would you like to void the old insurance and insure the ship again?','',''),('InsureShipFailed','info','Could Not Insure Ship::The ship could not be insured because of the following reason: %(reason)s.','',''),('InsureShipFailedMultipleContracts','info','Could Not Insure Ship::The ship could not be insured because of the following reason: The ship has multiple insurance contracts on it. Please wait for them to void, or repackage the ship.','',''),('InsureShipFailedSingleContract','info','Could Not Insure Ship::The ship could not be insured because of the following reason: The ship is currently insured by %(ownerName)s. Please wait for the contract to void, or repackage the ship.','',''),('Intro_3PlanetPic1','notify','On a handful of planets, small populations adapted and survived …and so began the Second Genesis.','',''),('Intro_3PlanetPic2','notify','Time itself became lost as history passed into legend.','',''),('Intro_3PlanetPic3','notify','Suns became gods and stars mythical spirits in the sky.','',''),('Intro_AmarrPic1','notify','The first to emerge from these Dark Ages were the Amarrians, a religious and self-righteous race.','',''),('Intro_AmarrPic2','notify','Only 12.000 years after EVE collapsed, they had reinvented space flight.','',''),('Intro_BombardPic1','notify','Space proved to be too small for both nations and a war of annihilation broke out.','',''),('Intro_BombardPic2','notify','After years of conflict the Amarrians reached the region and joined the fray.','',''),('Intro_BombardPic3','notify','Chaos reigned supreme.','',''),('Intro_BombardPic4','notify','Eventually, the Minmatar rebelled against their masters and with heavy losses on all sides, a universal truce was called and the Crystal Peace Accord signed.','',''),('Intro_CaldariPic1','notify','On a neighboring planet, the mighty Caldari had built a capitalistic and militaristic society.','',''),('Intro_CaldariPic2','notify','They joined the federation but peace was short-lived.','',''),('Intro_CorpMeetingPic1','notify','The great, newfound wealth fell to gluttonous corporations that soon controlled whatever they desired.','',''),('Intro_CorpMeetingPic2','notify','Corporate loyalty competed with national identity.','',''),('Intro_CorpMeetingPic3','notify','When all planets within jump range had been colonized, wars that would last for centuries broke out.','',''),('Intro_EarthPic1','notify','It was in the 21st century that mankind set out to colonize the planets of its solar system in an attempt to escape overpopulation and ceaseless wars on Earth.','',''),('Intro_EarthPic2','notify','Space is not kind to living things and millions of lives were lost.','',''),('Intro_EarthPic3','notify','After an era of colonization, room eventually became scarce.','',''),('Intro_EveCollapsePic1','notify','In the year 8061 the wormhole collapsed with devastating consequences.','',''),('Intro_EveCollapsePic2','notify','The  EVE gate was destroyed in the cataclysm and scientists argued the causes.','',''),('Intro_EveCollapsePic3','notify','Some even blamed factions on the other side.','',''),('Intro_FlightAcademy1','notify','Wealth and its acquisition fuel peoples desires and have become the means to all ends.','',''),('Intro_FlightAcademy2','notify','By enrolling into the flight academies, pilots no longer aim to fight in wars, but to make their fortune.','',''),('Intro_FlightAcademy3','notify','The year is 23,341 by the old world calendar…','',''),('Intro_FlightAcademy4','notify','… it is the year you graduate as an elite pilot in the world of EVE.','',''),('Intro_GallenPic1','notify','In another region of space, a sophisticated and fiercely independent race - the Gallente - formed a federation of independent states.','',''),('Intro_JumpGatePic1','notify','But with the discovery of jump gates an exhilarating sense of urgency and optimism enveloped the world.','',''),('Intro_JumpGatePic2','notify','It was a new beginning.','',''),('Intro_MinmPic1','notify','They soon found the Minmatar and viewing them as mere barbarians they subdued and enslaved them.','',''),('Intro_NetworkPic1','notify','The galactic gold rush was on yet again.','',''),('Intro_NetworkPic2','notify','Mankind spread thin across the vastness of space and was unprepared for what would follow.','',''),('Intro_SpcStationPic1','notify','Since then, a century has passed.','',''),('Intro_SpcStationPic2','notify','During a time of an increasingly uneasy peace, commerce and intergalactic trade has flourished.','',''),('Intro_WinterPic1','notify','Life proved fragile.','',''),('Intro_WinterPic2','notify','The colonies were far from self-sufficient and as their terraforming machines came to a screeching halt, life was mercilessly extinguished.','',''),('Intro_WinterPic4','notify','There would be no quick recovery.','',''),('Intro_WormPic1','notify','A natural wormhole was then discovered leading to a family of stars in a pristine sky.','',''),('Intro_WormPic2','notify','It was unstable and so, gigantic gateways were built at both ends to allow colonization vessels to pass through unharmed.','',''),('Intro_WormPic3','notify','The far gateway was christened EVE and over the next 72 years, colonists poured through, discovering valuable worlds every day.','',''),('InvalidBloodline','info','Invalid Bloodline: %(name)s requires %(required)s.','',''),('InvalidDate','info','Invalid Date::%(date)s is not a proper date.','',''),('InvalidDropLocation','info','Courier Mission::You need to go to %(location)s to complete this objective.','',''),('InvalidHomeStation','info','Invalid Home Station::The station specified is not a valid choice for your home station. Please pick another one.','',''),('InvalidItemForSlot','notify','That is not the right type of item to fit to this slot.','res:/Sound/ui/voc/InvalidItemForSlot.ogg',''),('InvalidJoveCode','info','%(code)s is not a valid Jove code','',''),('InvalidLoginName','info','\'%(login)s\' is not a valid login name.','',''),('InvalidPortNumber','info','%(port)s is not valid port number. Port number has to range from 2000 to 65000.','',''),('InvalidTargetCanAlreadyTractored','notify','The %(module)s cannot engage a tractor beam on that object as it is already being tractor beamed by something else.','',''),('InvalidTargetCanOwner','notify','The %(module)s cannot engage a tractor beam on that object as it is not owned by you, a fellow fleet member or another member of a player corporation you belong to.','',''),('InvalidTargetGroup','info','Invalid target, can only activate this on %(groupName)s.','',''),('InvalidTargetType','notify','Invalid target, the %(module)s can only be activated on a %(target)s.','',''),('InvalidTargetType2','notify','Invalid target, the %(module)s can only be activated on a %(target1)s or a %(target2)s.','',''),('InvalidTime','info','Invalid Time::%(time)s is not a proper time.','',''),('InvalidVersion','info','Invalid version of client for selected server','',''),('InvCantHaveCCInsideCC','notify','You cannot place a Planck generator container within another Planck generator, as it will cause a graviton harmonics chain reaction whose end cannot be determined.','',''),('InviteClone1','info','Your ship does not have a Clone Receiving Bay installed.','',''),('InviteClone2','info','There is no other pilot in operational distance.','',''),('ItemCannotBeInCargo','info','This item cannot be put into cargo containers.','',''),('ItemCannotBeInDroneBay','info','Only drones may be placed in the ship\'s drone bay.','',''),('ItemCannotBeMovedToFakeLocation','info','Item cannot be moved back to a loot container.','',''),('ItemDoesntFitPower','notify','%(item)s does not fit in this slot. The slot takes %(slotpower)s items, but the item is %(itempower)s','',''),('ItemExchangeAlreadyTrading','info','You are already participating in a trade session with %(who)s','',''),('ItemExchangeFailed','error','Trade Failed::Trade failed for some peculiar reason. Please try again.','',''),('ItemExchangeSameChar','info','Trading with yourself again?::It\'s generally not a good idea to trade with yourself. You\'re pretty sure that you\'ll end up stealing all your stuff.','',''),('ItemInsideItself','info','Unable to Comply::You cannot place the %(destname)s inside the %(sourcename)s','',''),('ItemIsLocked','notify','Item Is Locked::The item is locked. It was locked at %(lockTime)s. %(reason)s','',''),('ItemIsNotLauncherLoadable','info','That is not the type of item that can be loaded into a launcher.','',''),('ItemIsReward','info','Can\'t Take A Mission Reward::You cannot do anything with a %(itemType)s that has been offered as the reward for a mission.','',''),('ItemIsTrashed','info','Item trashed::The specified item is in the trash.','',''),('ItemLocked','info','Item %(item)s locked.','res:/sound/ui/error07.wav',''),('ItemMerge','audio','','',''),('ItemMoveGoesThroughFullCargoHold','notify','You fail to move the %(itemType)s as it gets invisibly moved to your cargo hold before it gets moved elsewhere and your cargo hold is full.','',''),('ItemNotASkill','info','You cannot train a %(skillName)s, it is not a skill.','',''),('ItemNotAtStation','notify','The %(item)s is not here.','',''),('ItemNotAvailable','info','Sorry, but to able to buy %(name)s someone has to be selling it; but no one is','',''),('ItemNotContainer','info','Item %(itemid)d is not a container.','res:/sound/ui/error07.wav',''),('ItemNotHardware','notify','%(itemname)s cannot be fitted onto a ship. Only hardware modules can be fitted.','',''),('ItemOnMarket','info','You cannot do anything with a %(itemType)s  while it is on the market.','',''),('ItemsMustBeInSameHangar','info','Items not in same hangar::All your selected items must be in the same hangar to perform this operation on them.','',''),('JumpAlreadyHaveStationClone','notify','You already have a jump clone installed at this station.','',''),('JumpAttemptTooSoon','notify','You have only recently engaged in a clone jump and need to wait for %(hours)d hours and %(minutes)d minutes before you can do so again.','',''),('JumpCantAcceptOwnInstall','notify','You cannot accept the offer to install a ship clone which you extended to %(other)s.','',''),('JumpCantDestroyCloneInOthersShip','notify','You cannot do that as the given clone is not inside a ship you are currently piloting.','',''),('JumpCantDestroyCloneNoRight','notify','You cannot do that as the given clone does not belong to you and you do not have the corporate right needed to get around that.','',''),('JumpCantDestroyNonLocalClone','notify','You cannot do that as the given clone is not located at this station, but in %(where)s.','',''),('JumpCantUseCFG','info','Activation Not Allowed::CONCORD regulations forbid activation of this kind of module in this system','',''),('JumpCharStoringMaxClones','info','Cannot install Clone::You cannot install any more Jump Clones as you have <b>%(have)d</b> installed and your <b>Infomorph Psychology</b> skill level only allows for a maximum of <b>%(max)d</b> clones at a time.','',''),('JumpCharStoringMaxClonesNone','info','Cannot install Clone::You will need the skill <b>Infomorph Psychology</b> in order to install Jump Clones.','',''),('JumpCheckIntoShip','question','Jump to ship?::Are you sure you want to proceed with the clone jump to a ship? Your consciousness will be transported to the system where the ship is located and ejected into a pod in space. <br>Is this what you want to do?','',''),('JumpCheckWillLoseExistingClone','warning','Are you sure?::Clone jumping will result in the destruction of the existing clone you have installed here given that your current body must replace it before jumping. \n<br>\n<br>\n<b>You will lose a Jump Clone!</b> Are you absolutely sure you want to do this?','',''),('JumpCheckWillLoseExistingCloneAndImplants','warning','Destroy Implants?::Clone jumping will result in the destruction of the existing clone you have installed here (and its implants!) given that your current body must replace it before jumping.\n<br>\n<br>\n<b>You will lose a Jump Clone!</b> Are you absolutely sure you want to do this?','',''),('JumpCloneInstallationCanceled','info','Clone Installation Aborted::%(offerer)s has canceled the offer to install a jump clone for you in his ship.','',''),('JumpCloneInstallationOffered','question','Install Jump Clone?::%(offerer)s has offered you to install a jump clone at his ship %(shipname)s. The clone installation costs are %(costs)s.\n','',''),('JumpCloneNotFound','notify','You cannot do that as the given clone does not exist.','',''),('JumpCriminalConfirm','warning','You are a criminal!::Warning! You are currently flagged for your criminal actions and you are about to enter an area with police officers who are on the look out for you. If you continue they will use all means necessary to kill you and the stargate will probably not let you return.<br><br> Are you sure you want to continue?','',''),('JumpDestinationInvalid','info','Invalid Jump Destination::This jump destination is no longer valid','',''),('JumpDestinationNotWilling','notify','The destination ship is not currently prepared to recieve your clone jump attempt.  It might not be in space or not currently have the appropriate systems activated.','',''),('JumpDriveActive','audio','','',''),('JumpHarmonicsDoNotMatch','notify','Your ship does not have the technology to utilize that jump portal','',''),('JumpInstalleeNotPresent','notify','The attempt at jump clone installation cannot proceed because the pilot whose clone is to be installed cannot be found.','',''),('JumpInstalleeTooDistant','notify','The attempt at jump clone installation has failed because the pilot whose clone is to be installed, is too distant and not within the %(distance)dm required.','',''),('JumpInstallerNotPresent','notify','The attempt at jump clone installation cannot proceed because the ship the clone is to be installed into cannot be found.','',''),('JumpNoBridge','info','No portal active::No portal active on this ship','',''),('JumpNoCloneAtDestination','notify','You cannot do that as you do not have a clone at the destination to be received in.','',''),('JumpNoDrive','info','No Jump Drive::Your ship is not equipped with jump drive technology','',''),('JumpNoPortal','info','No Portal Generator::Your ship is not fitted with a jump portal generator','',''),('JumpNoShipCloneForAbsentChar','notify','You need to be in the same station as %(other)s in order to install a clone in your ship for them. They are currently not located here.','',''),('JumpNoShipCloneForBusyChar','notify','You cannot install a clone in your ship for %(other)s at the same time they are involved in a ship clone installation with someone else.','',''),('JumpNoShipCloneWhenDoingShipOne','notify','You cannot install a clone in your ship for %(other)s at the same time as you are installing one for someone else.','',''),('JumpNoStationCloneWhenDoingShipOne','notify','You cannot install a clone in station while you are installing one in a ship.','',''),('JumpNotEnoughCap','info','Not Enough Capacitor::Jumping requires %(need).1f units of charge. The capacitor has only %(got).1f units.','',''),('JumpNotEnoughCharge','info','Not Enough Charges::This jump destination requires %(required)s unit(s) of %(typeName)s, but you only have %(available)s in your cargo hold.','',''),('JumpNotEnoughCharge2','info','Not Enough Charges::This jump destination requires %(required)s unit(s) of %(typeName)s, but the servicing ship only has %(available)s in its cargo hold.','',''),('JumpNotEnoughCharge3','info','Not Enough Charges::This jump destination requires %(required)s unit(s) of %(typeName)s, but the Jump Bridge only has %(available)s in its cargo hold.','',''),('JumpOtherAlreadyHasShipClone','notify','%(other)s already has a jump clone installed in this ship.','',''),('JumpShipCloneInstallAcceptTooLate','notify','You cannot accept the offer to install a ship clone as you have already accepted it and it is in the process of being installed.','',''),('JumpShipCloneInstallAcceptWTF','notify','You cannot accept the installation of a ship clone as you are not involved in one.','',''),('JumpShipCloneInstallCancelTooLate','notify','You cannot cancel the ongoing installation of the ship clone as it is already in the process of being installed.','',''),('JumpShipCloneInstallCancelWTF','notify','You cannot cancel the installation of a ship clone as you are not involved in one.','',''),('JumpShipLacksActiveCloneVatBay','notify','You cannot install a clone in your ship as the required systems are not online and active.','',''),('JumpShipLacksCloneSupport','notify','You cannot install a clone in your ship as it lacks the required systems.','',''),('JumpShipNotOwnedByCharacter','notify','You cannot install ship clones in a ship that is not owned by a character.','',''),('JumpShipStoringMaxClones','notify','You cannot install a clone in your ship as it is currently storing %(have)d and can only hold %(max)0.1f.','',''),('JumpSkillInTraining','notify','You cannot clone jump while you have a skill in training.  Consider stopping the skill training, or in lieu of that, not jumping.','',''),('JumpSuperweaponActive','info','Cannot jump yet::Your Super Weapon has recently been fired. You will not be able to activate your jump engines for another <b>%(t)s</b>.','',''),('JumpTooFar','info','Jump Too Far:: Jump distance would be %(dist)s lightyears but your jump drive only allows for jumps within %(range)s lightyears','',''),('KeepOldPassword','question','Change Password::The password field is empty.<br>Do you want to keep the old password?','',''),('laboratoryHeader','audio','','res:/sound/ui/uihac.wav',''),('LastClonedAt','notify','You were last cloned at %s','',''),('LastClonePurchase','notify','Your last clone purchase was for a %(cloneName)s at %(date)s','',''),('LaunchCPWarning','question','Are you sure?::If you launch a construction platform, you may not be able to scoop it up again because of its size.<br><br>Before launching it ensure that you can anchor and build it in this location.  You need to be at the warp in point of a planet, in a corporation that is in an alliance that holds sovereignty over the solarsystem, there needs to be no pre-existing outpost already built in the system, no pre-existing construction platforms already building and you need to have the equipment config role in your corporation.','',''),('LauncherLoadDelay','notify','Loading the %(ammo)s into the %(launcher)s; this will take approximately %(time)s seconds.','',''),('LaunchUpgradePlatformWarning','question','Are you sure?::If you launch %(item)s, you may not be able to scoop it up again because of its size.<br><br>Before launching it ensure that you can anchor and build it in this location. You need to be within %(distance)s of an outpost your corporation owns and you need to have the equipment config role in your corporation.','',''),('LienPageBody','notify','Your friendly insurance company has transferred %(amount)s ISK into your account for the recent loss of your ship.','',''),('LienPageHeading','notify','Insurance','',''),('ListEntryClick','audio','','res:/sound/ui/CCSelect.wav',''),('ListEntryEnter','audio','','res:/sound/ui/CCMenter.wav',''),('Loading','audio','','',''),('LoadingChargeAlready','notify','Some or all of %(item)s is already being loaded into a module. If you wish to load what remains, you will have to wait until this is finished.','',''),('LoadingChargeSlotAlready','notify','You cannot load the %(item)s because the module is already involved in another loading operation.','',''),('LoadSvc_agentsIn','audio','','res:/sound/ui/uihao.wav',''),('LoadSvc_agentsOut','audio','','res:/sound/ui/uihac.wav',''),('LoadSvc_blackmarketIn','audio','','res:/sound/ui/uihblackmrkto.wav',''),('LoadSvc_blackmarketOut','audio','','res:/sound/ui/uihblackmrktclose.wav',''),('LoadSvc_casinoIn','audio','','res:/sound/ui/uihcasinopen.wav',''),('LoadSvc_casinoOut','audio','','res:/sound/ui/uihcasinclose.wav',''),('LoadSvc_factoriesIn','audio','','res:/sound/ui/uihfcto.wav',''),('LoadSvc_factoriesOut','audio','','res:/sound/ui/uihclose01.wav',''),('LoadSvc_factorisOut','audio','','res:/sound/ui/phony.wav',''),('LoadSvc_fittingIn','audio','','res:/sound/ui/uihfo.wav',''),('LoadSvc_fittingOut','audio','','res:/sound/ui/uihfc01.wav',''),('LoadSvc_insuranceIn','audio','','res:/sound/ui/uihac.wav',''),('LoadSvc_insuranceOut','audio','','res:/sound/ui/uihclose01.wav',''),('LoadSvc_laboratoryIn','audio','','res:/sound/ui/uihac.wav',''),('LoadSvc_laboratoryOut','audio','','res:/sound/ui/uihclose01.wav',''),('LoadSvc_lobbyIn','audio','','res:/sound/ui/uihlo02.wav',''),('LoadSvc_lobbyOut','audio','','res:/sound/ui/uihlc01.wav',''),('LoadSvc_marketIn','audio','','res:/sound/ui/uihmrkto02.wav',''),('LoadSvc_marketOut','audio','','res:/sound/ui/uihmrktc01.wav',''),('LoadSvc_medicalIn','audio','','res:/sound/ui/uihmedo.ogg',''),('LoadSvc_medicalOut','audio','','res:/sound/ui/uihmedc.wav',''),('LoadSvc_missionsIn','audio','','res:/sound/ui/uihmo02.wav',''),('LoadSvc_missionsOut','audio','','res:/sound/ui/uihmc01.wav',''),('LoadSvc_newsIn','audio','','res:/sound/ui/uihno02.wav',''),('LoadSvc_newsOut','audio','','res:/sound/ui/uihnc01.wav',''),('LoadSvc_paintshopIn','audio','','res:/sound/ui/uihpo02.wav',''),('LoadSvc_paintshopOut','audio','','res:/sound/ui/uihpc01.wav',''),('LoadSvc_refineryIn','audio','','res:/sound/ui/uihrefineopen.wav',''),('LoadSvc_refineryOut','audio','','res:/sound/ui/uihrefineclose.wav',''),('LoadSvc_repairshopIn','audio','','res:/sound/ui/uihro02.wav',''),('LoadSvc_repairshopOut','audio','','res:/sound/ui/uihclose04.wav',''),('LoadSvc_reprocessingplantIn','audio','','res:/sound/ui/uihrpo02.wav',''),('LoadSvc_reprocessingplantOut','audio','','res:/sound/ui/uihrpclose01.wav',''),('LoadSvc_researchfacilityIn','audio','','res:/sound/ui/uihresearchopen.wav',''),('LoadSvc_researchfacilityOut','audio','','res:/sound/ui/uihresearchclose.wav',''),('LoadSvc_storageIn','audio','','res:/sound/ui/uihstoropen.wav',''),('LoadSvc_storageOut','audio','','res:/sound/ui/uihstorclose.wav',''),('LoadSvc_transportIn','audio','','res:/sound/ui/uihtransopen.wav',''),('LoadSvc_transportOut','audio','','res:/sound/ui/uihtransclose.wav',''),('lobbyBtnEnter','audio','','res:/sound/ui/uihme01.wav',''),('lobbyHeader','audio','','res:/sound/ui/uihltxt02.wav',''),('LocationNameInvalid','notify','Location name is not valid','',''),('LocationNameInvalidBannedWord','notify','Location name contains a banned word.','',''),('LocationNameInvalidFirstChar','notify','First character in location name is illegal.','',''),('LocationNameInvalidLastChar','notify','Last character in location name is illegal.','',''),('LocationNameInvalidMaxLength','notify','Maximum length for a location name is 100 characters.','',''),('LocationNameInvalidMaxSpaces','notify','Location name contains too many spaces.','',''),('LocationNameInvalidMinLength','notify','Minimum length for a location name is 4 characters.','',''),('LocationNameInvalidSomeChar','notify','Location name contains an illegal character.','',''),('LocationNameInvalidTaken','notify','Location name is already taken.','',''),('lockAddItemToContainer','notify','Please Wait::The item is being transferred to the %(containerType)s. Please wait for the transfer to complete.','',''),('LockedContainerInaccessible','notify','You cannot access the %(c)s without specialized equipment','',''),('LockedContainerNotOpened','notify','Your attempt to access the %(c)s failed this time.','',''),('LockedContainerOpened','notify','You successfully access the %(c)s.','',''),('LockedContainerOpenedAlready','notify','No further tools are needed to access the %(c)s.','',''),('LockedContainerTooComplex','notify','The %(c)s is too complex for you to gather anything of value.','',''),('LockedOverloadState','info','Overload State is Locked:s:You have chosen to lock the overload state, please unlock it and try again.','',''),('lockItemContractFunction','info','Item Locked::The item, <b>%(itemType)s</b> is currently locked in a contract that is being created.<br><br>You will have to cancel the contract creation in order to manipulate this item.','',''),('lockItemGodmaActivate','notify','Activation In Progress::An attempt is underway to activate the module. Please wait until that has completed.','',''),('lockItemGodmaDeactivate','notify','Deactivation In Progress::An attempt is underway to deactivate the module. Please wait until that has completed.','',''),('lockItemMarket','notify','Sale In Progress::You are currently trying to sell the %(typeDescription)s. Please complete the sale or cancel it.','',''),('lockItemMenuFunction','notify','Please Wait::The %(itemType)s is being %(action)s.','',''),('lockMergingItem','notify','Please Wait::The item is being merged.','',''),('lockMissionItem','notify','Please Wait::The %(itemType)s is being added to a courier mission.','',''),('lockRefining','notify','Please Wait::The %(itemType)s is in the hands of a refining specialist.','',''),('lockRepairingItem','notify','Please Wait::The item is being repaired.','',''),('lockRepairInspection','notify','Please Wait::The %(itemType)s is in the hands of a repair specialist.','',''),('lockReprocessing','notify','Please Wait::The %(itemType)s is in the hands of a reprocessing specialist.','',''),('lockUnassemblingItem','notify','Please Wait::The item is being repackaged.','',''),('LoginAuthenticating','info','Authenticating %(user)s','',''),('LoginAuthFailed','info','Incorrect login name or password','',''),('LoginCheckAddress','info','Checking address %(host)s','',''),('LoginCheckVersion','info','Matching client version of %(ver)s','',''),('LoginConnectFailed','info','Couldn\'t connect::%(what)s','',''),('LoginConnecting','info','Connecting to %(address)s','',''),('LoginGetStartupInfo','info','Retrieving startup info','',''),('LoginHostNameError','info','Please type in a host name','',''),('LoginLookupFailed','info','Strange Mofo::Lookup failed for %(host)s','',''),('LoginNegotiating','info','Negotiating with server','',''),('LoginParameterIncorrect','info','Login Data Incorrect::Please enter a valid %(invalidFields)s','',''),('LoginPing','info','Server ping %(ms)d ms.','',''),('loginprogress::authenticating','','Authenticating','',''),('loginprogress::connecting','','Establish connection to server','',''),('loginprogress::done','','Login complete, processing bulk data','',''),('loginprogress::gettingbulkdata','','Acquiring bulk data','',''),('loginprogress::lowlevelversioncheck','','Performing pre-authentication handshake','',''),('loginprogress::miscinitdata','','Preparing Data','',''),('loginprogress::processingInitialDataDone','','Done processing bulk data','',''),('LoginSuccess','info','Login successfull','',''),('LoginUserNameError','info','Please type in a user name','',''),('LoginVersionMismatch','info','Invalid client version, server version is %(ver)s','',''),('LookupStringMinimum','notify','Please type in at least %(minimum)s characters.','',''),('LPStoreMissingISK','info','Not enough credits::You do not enough credits to accept this offer','',''),('LPStoreMissingItems','info','Missing required items::You do not seem to have all the items needed to accept this offer.  Please make sure that you have repackaged all the required items.','',''),('LPStoreMissingLP','info','Not enough Loyalty Points::You do not have enough LP to accept this offer','',''),('LPStoreNoLPs','info','No Loyalty Points::You do not have any Loyalty Points with this corporation.<br>\nIn order to use this Loyalty Store you will have to complete missions for the owner of this station.','',''),('LPStoreOfferAccepted','notify','LP Store purchase completed.<br><br>We\'re glad we could repay your loyalty, %(name)s.','',''),('LSCCannotAccessControl','info','Cannot Access Control Channel::%(msg)s','',''),('LSCCannotAcquireMessageDetails','info','Cannot Acquire Message Details::%(msg)s','',''),('LSCCannotCreate','info','Cannot Create Channel::%(msg)s','',''),('LSCCannotDeleteMessage','info','Cannot Delete Message::%(msg)s','',''),('LSCCannotDestroy','info','Cannot Destroy Channel::%(msg)s','',''),('LSCCannotJoin','info','Cannot Join Channel::%(msg)s','',''),('LSCCannotPage','info','Cannot Send Page::%(msg)s','',''),('LSCCannotRename','info','Cannot Rename Channel::%(msg)s','',''),('LSCCannotSendMessage','info','Cannot Send Message::%(msg)s','',''),('LSCCannotSetCreator','info','Cannot Set Creator::%(msg)s','',''),('LSCCannotSetCSPA','info','Cannot Configure CSPA::%(msg)s','',''),('LSCCannotSetLanguageRestriction','info','Cannot Configure Channel Language Restriction::%(msg)s','',''),('LSCCannotSetMemberless','info','Cannot Configure Channel::%(msg)s','',''),('LSCCannotSetMOTD','info','Cannot Set Channel MOTD::%(msg)s','',''),('LSCCannotSetPassword','info','Cannot Set Channel Password::%(msg)s','',''),('LSCChannelDoesNotExistCreate','question','Channel Does Not Exist::The channel %(displayName)s does not exist, do you want to create it?','',''),('LSCConfirmDestroyChannel','question','Confirm Delete::Are you sure you want to delete %(displayName)s?','',''),('LSCJoinInstead','question','Channel Exists::The channel %(displayName)s already exists, do you wish to join it?','',''),('LscLanguageRestrictionViolation','info','Language Restriction Violation::This channel does not support alternative languages.  Stick to the server\'s default language, please.','',''),('LSCTrialRestriction_Channel','info','Cannot post on channel::You cannot post on this channel because of Trial Account restrictions.<br><br>','',''),('LSCTrialRestriction_SendMessage','notify','Trial Account Restriction: You cannot send another message until after <b>%(sec)s</b> seconds.','',''),('LSCWrongPassword','info','Incorrect Password::The password you specified for the %(channel)s Channel was incorrect','',''),('ManufacturingRequestDenied','info','Manufacturing Request Denied::Your manufacturing request has been denied. %(reason)s','',''),('MapAutoPilotAvoidPodkillZones','warning','Avoiding pod killing zones:s:Using this selection may result in the autopilot plotting EXTREMELY long routes between waypoints.','',''),('MapAutoPilotAvoidSystems','info','Avoiding systems on Avoidance List:s:Using this selection may result in the autopilot plotting EXTREMELY long routes between waypoints.','',''),('MapDistance','info','Distance between systems::The distance between %(fromSystem)s and %(toSystem)s is <b>%(dist)s</b> light-years and <b>%(jumps)s</b> jumps.<br><br>','',''),('MarketAddFailed','info','Add Order Failed::Market authorites were unable to process your order. Please try again.','',''),('MarketAskIsTooLow','warning','You are about to place an ask order for %(price)s, which is less than the average price of %(avg)s.  <br>Are you sure?','',''),('marketBtnEnter','audio','','res:/sound/ui/uihme02.wav',''),('MarketExceededOrderCount','info','Too Many Open Orders::You currently have %(curCnt)s open orders and your Trade skill level only allows for a maximum of %(maxCnt)s','',''),('MarketExportInfo','info','Market Export Information:s:%(sell)s sell orders and %(buy)s buy orders for %(typename)s were exported to the file %(filename)s in the directory %(directory)s','',''),('marketHeader','audio','','res:/sound/ui/uihmrkttxt02.wav',''),('MarketItemNonTradeable','notify','Sorry, but SCC categorization of %(typeName)s as a trade commodity is still pending.','',''),('MaxAttributeAssignExceeded','info','Maximum Reached:s:You cannot assign more than %(points)s points to the same attribute.','',''),('MaxAttributeModifiersExceeded','info','You cannot raise any of your attributes more than %(max)s points over the base value determined by your bloodline.','',''),('MaxAttributeValueExceeded','info','Value Too High:s:The maximum total value of an attribute cannot be higher than %(points)s points.','',''),('MaxBandwidthExceeded','notify','You don\'t have enough bandwidth to launch %(droneName)s. You need %(bandwidthNeeded)s Mbit/s but %(droneName)s requires %(droneBandwidthUsed)s Mbit/s.','',''),('MaxBandwidthExceeded2','notify','You don\'t have enough bandwidth to launch %(droneName)s. You need %(droneBandwidthUsed)s Mbit/s but only have %(bandwidthLeft)s Mbit/s available.','',''),('MaxBenefitPointsExceeded','info','You can\'t select this benefit because you don\'t have enough points left.<br><br>You can try and deselect another benefit or take some handicap to obtain extra points.','',''),('MaxFactorySlotUsageReached','info','Too Complicated::You have reached the limit of your abilities for running concurrent factory slots. You are currently running %(current)s slots, and you can at most handle %(max)s.','',''),('MaxGroupsReached','info','Maximum number of groups reached. Please delete some if you want to create a new one.','',''),('MaxHandicapPointsExceeded','info','You can only select handicaps for a total maximum %(points)s points. You can try and deselect another handicap if you want to choose this.','',''),('MaxResearchFacilitySlotUsageReached','info','Too Complicated::You have reached the limit of your abilities for running concurrent research facility slots. You are currently running %(current)s slots, and you can at most handle %(max)s.','',''),('MaxStandingsSet','info','Maximum Reached::You have already set the maximum number of standings allowable (300).  Please delete some obsolete standings and try again.','',''),('MaxTotalTermsExceeded','info','You cannot select careers and education terms for a total amount higher than %(max)s.','',''),('MayNotEjectPassengers','notify','You may not eject passengers, it\'s not a nice thing to do.','',''),('MedicalAlreadyHaveBestCloneType','info','No Better Clones Available::There are currently no better clones available than the one you already have. Therefore it is not possible to upgrade your clone.','',''),('medicalBtnEnter','audio','','res:/sound/ui/uihme02.wav',''),('medicalHeader','audio','','res:/sound/ui/uihmedtxt.wav',''),('MedicalThisCloneIsWorse','info','You do not want that::The clone type that you have selected is worse than the clone you already have selected. No change will be made.','',''),('MedicalYouAlreadyHaveACloneContractAtThatStation','info','Clone Contract::You already have a clone contract at the specified station.','',''),('menu','audio','','res:/sound/ui/info.wav',''),('MenuActivate','audio','','res:/sound/ui/HangarSmallMenu.wav',''),('MessageNotSentPetitionAlreadyClosed','info','The message was not sent, because the petition has already been closed','',''),('Min3Chars','info','Text Too Short::Please enter a search text of at least 3 characters.','',''),('Min3Letters','info','Name must be at least 3 characters long.','res:/sound/ui/error07.wav',''),('MineOnlyAsteroids','info','Your cannot mine the %(groupName)s.','',''),('MiningCrystalDestroyed','notify','%(module)s deactivates due to the destruction of the %(type)s it was fitted with.','',''),('MiningDronesDeactivatedAsteroidEmpty','notify','%(modulename)s deactivates as it finds the resource it was harvesting a pale shadow of its former glory.','res:/Sound/ui/voc/AsteroidDepleted.ogg',''),('MiningDronesDeactivatedCargoHoldFull','notify','%(modulename)s disperses its load of freshly mined ore into space unrecoverably then deactivates.  Your cargo hold is full.','res:/Sound/ui/voc/CargoFull.ogg',''),('MiningDronesDeactivatedCargoHoldNowFull','notify','%(modulename)s deactivates. Your cargo hold is full and cannot hold any more ore, so loading algorithms have deactivated the %(modulename)s before they become overloaded','',''),('MiningDronesDeactivatedOutOfRange','notify','%(modulename)s deactivates without transfering ore to your cargo hold because your ship has strayed to a distance of %(distance)d m, beyond its mining range of %(range)d m.','',''),('MiningItemDepleted','notify','%(modulename)s deactivates as its target has been depleted.','',''),('MinRadiusHigherThenMax','info','Min radius is highter than max radius. Please make min be less or equal to max.','',''),('MinThreeLetters','info','Information::You have to type at least three letters to set a password.','',''),('MisContrabandRejected','info','Cannot create mission::Contraband (like %(example)s) cannot be included in these.','',''),('MisCourierInvolvesPOS','warning','Stations may be inaccessible to you.::The pick-up station is owned by %(pickupOwner)s and the drop station is owned by %(dropOwner)s. Please note that either of those stations may be inaccessible to you.<br>Are you sure you want to accept this courier mission?','',''),('MisIncorrectDropLocation','info','Can\'t deliver package here::The package should be delivered at %(drop)s.','',''),('MisMissionExpired','info','Mission Expired::This mission has already expired.','',''),('MisNoItems','info','No items available::There\'s nothing available at this station.','',''),('MisNoShipsInCourier','info','Cannot create courier mission::Only packaged ships can be couriered.','',''),('MisNoSuchMission','info','Mission not found::This mission is no longer available.','',''),('MisNotAvailable','notify','\"This mission is no longer available\"','',''),('MisPackageNotHere','info','Can\'t deliver package::The package is not on your hangar floor.','',''),('MisPackageTooLarge','info','Cannot create courier mission::The total volume of the items you selected is %(vol)sm³ which exceeds allowed maximum of %(limit)sm³.','',''),('MisPilotOnBoard','notify','Can\'t add ships with people in it in a courier mission.','',''),('MisRewardLessAccept','info','Too unfair::Please make the reward higher than the accept fee.','',''),('MissDroppedOffCredit','info','<br>%(receiver)s has received %(amount)s credit.','',''),('MissDroppedOffCredits','info','<br>%(receiver)s has received %(amount)s credits.','',''),('MissDroppedOffItem','info','<br>%(receiver)s has received %(amount)s %(type)s.','',''),('MissingRequiredField','info','Required Field Missing::The field %(fieldname)s cannot be blank. Please enter valid data.','',''),('MissingRoleStationMgt','info','Information::You do not have the role Station Manager, so you can\'t do station management.','',''),('MissionEnter','audio','','res:/sound/ui/mentersmall.wav',''),('MissionInvalid','info','Invalid Mission::The mission is invalid, sorry for any inconvenience. The ID of the mission is %(missionID)s, you may want to raise this issue in a petition. You can create a petition through the Help button on the NeoComm.','',''),('MissionItemAlreadyThere','question','Create the Mission::The item is already here. Are you sure you want to continue?','',''),('MissionNotActive','notify','The %(name)s mission is not active.','',''),('MissionNotIssued','notify','This mission cannot be accepted.','',''),('missionsBtnEnter','audio','','res:/sound/ui/uihme01.wav',''),('MissionSelect','audio','','res:/sound/ui/smallselect.wav',''),('missionsHeader','audio','','res:/sound/ui/uihmtxt02.wav',''),('MissMissionAcceptedHelp','info','Mission Accepted:s:You have just accepted a mission. In order to complete the mission you will have to perform the objectives requested.<br>In order to complete an objective you need to view the mission and click the appropriate button for the objective.<br>If you are starting a courier mission you might be able to complete the first objective now, if the item you need to transport is located at this station.','',''),('MissMissionCompleted','info','Mission Completed::Congratulations! You have successfully completed this mission.<br>%(completed)s','',''),('MissObjectiveCompleted','info','Objective Completed::Congratulations! You have completed this part of the mission. %(completed)s<br>You still have to do the following:<br>%(todo)s<br>Good Luck','',''),('MissReceivedItemInHangar','info','<br>%(amount)s %(type)s has been placed in your hangar. If you need to transport the item, do not forget to move the item into your ship\'s cargo hold.','',''),('MissReceivedItemInWallet','info','<br>%(amount)s %(type)s has been added to your wallet.','',''),('MissReceivedItemsInHangar','info','<br>%(amount)s %(type)s have been placed in your hangar. If you have to transport the item then do not forget to move the item into your ships cargo hold.','',''),('MissReceivedItemsInWallet','info','<br>%(amount)s %(type)s have been added to your wallet.','',''),('MktAskRangeLimitation','info','Too Far Away::Your current trade skills level only allows you to issue %(range)s','',''),('MktAsksMustSpecifyItems','info','Not a Valid Item::Item specified for sell is not valid','',''),('mktCanNotSellUsedCopiedBlueprint','info','Can Not Sell Blueprint::The specified blueprint can not be sold on the market. The blueprint has %(licensedProductionRunsRemaining)s licensed production runs remaining. It must have %(maxProductionLimit)s licensed productions remaining in order to be sold.','',''),('MktCantSellItem','info','Too Far Away::Your current trade skill do not allow you to sell or buy items that far away from you. This item is in a station %(jumps)s away from you while your skill restrict you to %(limit)s','',''),('MktCantSellItem2','info','Too Far Away::Your current trade skills do not allow you to sell or buy items that far away from you. This item is in a station %(numJumps)s %(jumpText1)s away from you while your skills restrict you to %(numLimit)s %(jumpText2)s.','',''),('MktCantSellItemOutsideStation','info','Too Far Away::Your current trade skills do not allow you to sell or buy items that far away from you. This item is in a station %(numJumps)s %(jumpText)s away from you while your skills restrict you to this station.','',''),('MktConfirmTrade','warning','The price you have chosen is %(amount)s regional average. Are you sure you want to enter this order?','',''),('MktIllegalStuff','info','Illegal Stuff::Can\'t accept this order as these kind of items are considered illegal in that station','',''),('MktInvalidMarketType','info','Selling of item failed::The item <b>%(item)s</b> cannot be sold on the market.','',''),('MktInvalidMarketTypeAsk','info','Selling of item failed::The item <b>%(item)s</b> cannot be sold on the market.','',''),('MktInvalidMarketTypeBid','info','Buy order failed::The item <b>%(item)s</b> cannot be bought on the market.','',''),('MktInvalidRegion','info','Invalid Region::You are not allowed to enter an order in a different region','',''),('MktMarketClosed','info','Market Closed::The %(region)s market region has been closed until further notice by the SCC while officials investigate allegations of insider trading.  Please try again tomorrow, or refer to another market region for your trading needs.','',''),('MktMarketOpening','info','Market not open yet::The %(region)s market region is currently opening up for business and is not yet ready.  Please try again in a few minutes, or refer to another market region for your trading needs.','',''),('MktNonExistingOrder','info','Order Does Not Exist::The specified order could not be found in this region\'s market registry','',''),('MktNotEnoughCash','info','Failed to order item::To place this order you would need the total sum of %(cashAmount)s (of which %(tax)s in tax), while your current balance is only %(balance)s.\n','',''),('MktNotOwner','info','Not Owner::Your are not allowed to perform this operation on this item','',''),('MktOrderChanged','info','Order Changed::The specified order had changed since your client was updated.  Please try again.','',''),('MktOrderDelay','info','Operation Delay::You cannot modify an order within a certain time delay since your last operation on it. Try again in %(delay)s','',''),('MktOrderDidNotMatch','info','No Match:: Broker found no match for your order. Others might have been before you, or your quotes might be outdated.','',''),('MktOrderTooNew','info','Cancelling failed::The order cannot be cancelled, it has been entered too recently.  At least five minutes must have passed in order to be able to cancel an order.','',''),('MktQuickSellExpired','info','Your quick sell order expired because the buyer didn\'t have enough cash.','',''),('MktServiceNotReady','info','Market Not Ready::The Market is not ready at the moment. Please try again later.','',''),('MktTransCompletedAudio','audio','','',''),('MktTransCompletedBuyer','notify','%(amount)d of %(typeName)s bought for %(totalCost)d (%(price)d per item) and waits in your hangar at  %(locationName)s for pickup.','',''),('MktTransCompletedSeller','notify','%(amount)d of %(typeName)s sold for %(totalCost)d (%(price)d per item) at %(locationName)s.','',''),('MktTransFailedNoMoney','notify','Your buy order was matched but insufficient funds were available. <br> Order details: <br> Order ID:<t>%(orderID)s <br> Owner:<t>%(charID)s <br> Regional Market:<t>%(regionID)s <br> Placed at:<t>%(stationID)s <br> Range:<t>%(range)s <br> Buy/Sell:<t>Buy <br> Commodity:<t>%(typeID)s <br> Volume entered:<t>%(volEntered)s <br> Volume remaining:<t>%(volRemaining)s <br> Price:<t>%(price)s <br> Expires:<t>%(expires)s <br> Entered:<t>%(issued)s <br> <br> If this keeps up you will be fined by the SCC.','',''),('MktTransFailedNoMoneyAudio','audio','','',''),('MktTransFailedNoShares','notify','Your sell order was matched but insufficient shares were available. <br> Order details: <br> Order ID:<t>%(orderID)s <br> Owner:<t>%(charID)s <br> Regional Market:<t>%(regionID)s <br> Placed at:<t>%(stationID)s <br> Range:<t>%(range)s <br> Buy/Sell:<t>Buy <br> Commodity:<t>%(typeID)s <br> Volume entered:<t>%(volEntered)s <br> Volume remaining:<t>%(volRemaining)s <br> Price:<t>%(price)s <br> Expires:<t>%(expires)s <br> Entered:<t>%(issued)s <br> <br> If this keeps up you will be fined by the SCC.','MktTransFailedNoMoneyAudio',''),('MlsNotifyCaveats','info','Language Select::Not all text is available in the language you selected.<br>If a translation is not available, English will be used.','',''),('ModuleActFailInterference','notify','%(item)s fails to activate due to the interference that is providing your invulnerability.','',''),('ModuleActivatedDeniedForceField','notify','The %(moduleName)s cannot be activated inside a force field.','',''),('ModuleAlreadyActive','info','Module Already Active::You are already using that module.','',''),('ModuleAlreadyFitting','notify','That module is already involved in some kind of fitting operation. Please wait until it has finished before trying again.','',''),('ModuleEffectActive','notify','The %(modulename)s is still activated.','',''),('ModuleFit','notify','%(item)s fitted onto slot %(slot)s','res:/sound/ui/PrinterBeep02.wav',''),('ModuleFitFailed','info','The %(modulename)s cannot be fitted. %(reason)s','',''),('ModuleGotDamagedWhileBeingRepaired','notify','The module %(moduleName)s got damaged while being repaired which has disrupted the repair process','',''),('ModuleJammedOnBadAmmo','info','%(moduleName)s jammed on the %(ammoName)s within it, which it does not use.','',''),('ModuleNoLongerPresentForCharges','notify','The module you tried to load with charges is no longer present.','',''),('ModuleNotOnline','notify','Unable to activate %(moduleName)s, as it is not online.','',''),('ModuleNotPowered','info','The %(type)s you are trying to fit is not a low, medium or high powered module and cannot be fitted to any of these fitting slots.','',''),('ModuleReactivationDelayed','notify','%(item)s fails to activate as it is still recovering from its last period of operation and will be for the next %(delay)0.1f seconds.','',''),('ModuleReactivationDelayed2','notify','%(item)s fails to activate as it is still recovering from its last period of operation and will be for the next <b>%(delay)s</b>.','',''),('ModuleRequiresCynosuralBeaconTarget','notify','The %(moduleName)s deactivates as the target %(targetName)s is not a cynosural beacon.','',''),('ModuleRequiresFuel','notify','%(fueled)s requires %(fuel)s to be present in the cargo hold, in order to activate.  There is insufficient amounts present to suffice.','',''),('ModuleRequiresLowerSystemSecurity','notify','The %(moduleName)s deactivates as it can not be activated in solar systems above security level %(lessThanSecurity)0.1f, this system has a level of %(actualSecurity)0.1f. ','',''),('ModuleRequiresTargetOwnerGangMembership','notify','The %(moduleName)s deactivates as the target %(targetName)s does not belong to a fellow fleet member.','',''),('ModulesIncorrectlyFitted','hint','Your modules are incorrectly fitted. Possibly your slot layout has changed and a module is in a slot that is no longer valid. Try unfitting your modules and fit them again.','',''),('ModuleSizeIncompatible','info','%(moduleName)s is of size %(haveSize)d, %(shipGroup)s requires it in a different size.','',''),('ModulesNotLoadableInSpace','notify','You can only fit or unfit from a ship while in station.  An exception to this rule is when employing a device like the %(device)s.','',''),('ModuleTooBigForThisShip','notify','%(item)s is too big to be fitted on %(ship)s','',''),('ModuleTooDamagedToBeOnlined','notify','The module is too damaged to be onlined','',''),('ModuleTooDamagedToRepairGoToStation','notify','The %(moduleName)s is too damaged to repair. You need to repair it in a station with repair facilities','',''),('ModuleUnfit','notify','%(item)s unfitted from slot %(slot)s','res:/sound/ui/PrinterBeep02.wav',''),('MonikerSessionCheckFailure','fatal','Moniker Session Check Failure::A moniker used by this client was being used with incorrect session attributes.  It was built for %(attribute)s=%(expected)s, but that attribute is currently %(current)s.  It\'s a %(serviceName)s moniker with bind params %(bindParams)s.','',''),('MoonCannotManageOnline','info','You cannot manage this structure when it is online; Switch this structure offline in order to manage it.','',''),('MoonHarvesterInvalidType','info','This structure can only attempt to harvest resources that appear on moons. Attempting to harvest \'%(type)s\' could lead to unfortunate consequences.','',''),('MoonInvalidSiloType','info','This structure can only be configured for the storage of moon products, intermediates, composites and gas products.','',''),('MoonSilosCannotChangeWithContents','info','You cannot configure this structure to store %(newtype)s while it still contains %(contenttype)s.','',''),('MoreThan1Term1','info','You can only have one education Term 1. i.e. you can\'t have both %(one)s and %(two)s.','',''),('MoreThan1Term2','info','You can only have one education Term 2. i.e. you can\'t have both %(one)s and %(two)s.','',''),('MouseEnter','audio','','res:/sound/ui/mentersmall.wav',''),('MoveHQHere','question','Move HQ Here?::Are you sure that you want to move your corporations headquarters to this station?','',''),('MovementFocusTooDistant','notify','You cannot navigate that way with the selected object as it is too far away.  Try moving in its direction instead.','',''),('MrNothingToRefine','notify','There are no ore, gas or alloys in the refining array.','',''),('MrOnlyAsteroids','notify','You cannot put %(itemGroup)s into the refining array. Only ore can be refined.','',''),('MrOnlyMineable','notify','You cannot put %(itemGroup)s into the refining array. Only mineable resources like ore or harvested clouds can be refined.','',''),('MrTooManyToRefine','notify','There are too many stacks in the refining array, there needs to be just one for operation to proceed.','',''),('MultiDroneCmdResult','notify','Of the %(total)s drones you commanded, %(succeeded)s accepted the command and %(failed)s could not accept it for various reasons.','',''),('MustBeActiveCEOToEndWar','info','Access Denied::You cannot negotiate a surrender unless you are the active CEO of one of the waring corporations.','',''),('MustBeAllianceCEOToEndWar','info','Access Denied::You cannot negotiate a surrender unless you are a director in the executive corporation of your alliance.','',''),('MustBeInStationToNegotiate','info','Negotiate Where?::You cannot negotiate a surrender unless you are in a station.','',''),('MustBoardShipFirst','notify','Please board a ship first.','',''),('MustSelectAncestry','info','You must select an ancestry by clicking one of the rows in the list before you can continue.','',''),('MustSelectBloodlineGender','info','Please select a bloodline and gender by clicking one of the character portraits, or click the Back arrow to cancel character creation.','',''),('MustUndockAsPilot','notify','You must be the captain of the ship to undock it.','',''),('NameBannedWord','notify','Name contains a banned word.','',''),('NameFirstChar','notify','First character in name is illegal.','',''),('NameIllegalChar','notify','Name contains an illegal character.','',''),('NameInvalid','notify','Name is not valid.','',''),('NameLastChar','notify','Last character in name is illegal.','',''),('NameMaxLength','notify','Name is too long.  Maximum length is 24 for character names and 100 for corporation names.','',''),('NameMaxSpaces','notify','Name has too many spaces.  Character names can only have 1 space.','',''),('NameMinLength','notify','Name is too short.  Minimum length is 4 for character and corporation names','',''),('NameTaken','notify','Name is already taken.','',''),('NeedBlueprint','info','Need Blueprint::You must have a blueprint available.','',''),('NeedShipToUndock','info','Need a Ship::You have no ship. Please requisition one by filling out form NSR01B-25. Then there\'s always the possibility of begging money from other people on the station.','',''),('NeedVoucher','info','Need Voucher::You need the correct voucher to complete this objective.','',''),('NeoButtonEnter','audio','','res:/sound/ui/uineomo01a.wav',''),('NeoClose','audio','','res:/sound/ui/uineocomixc01c.wav',''),('NeocomButtonEnter','audio','','res:/sound/ui/NeoMenter.wav',''),('NeocomButtonSelect','audio','','',''),('NeoComIn','audio','','res:/sound/ui/NeoComIn.wav',''),('NeoComOut','audio','','res:/sound/ui/NeoComOut.wav',''),('NeoComTrans','audio','','',''),('NeoListentryEnter','audio','','res:/sound/ui/uineocombtn01.wav',''),('NeoNotify','audio','','res:/sound/ui/uishort02e3.wav',''),('NeoOpen','audio','','res:/sound/ui/uineocomixo01a.wav',''),('NewPasswordMismatch','info','Password Mismatch::The confirm password you have entered doesn\'t match the new password.','',''),('newsBtnEnter','audio','','res:/sound/ui/uihme02.wav',''),('newsHeader','audio','','res:/sound/ui/uihntxt02.wav',''),('NoActionsForModule','notify','%(moduleName)s has no associated actions.','res:/sound/ui/GlassyBeep18.wav',''),('NoActiveBeacon','info','No Active Beacon::You do not have an active Cynosural Field Beacon.','',''),('NoAttributePointsLeft','info','No Points Left:s:You have no attribute points left to distribute.<br><br>You may unassign points by clicking on the Minus (-) button.','',''),('NoAudio','question','Audio System:s:Audio drivers not detected<br>Sound system will not be activated<br><br>Please make sure you have audio drivers installed.','',''),('NoAudioHwAcceleration','question','Audio System:s:Audio hardware acceleration not detected<br>The sound system will use only software channels until you get at least %(minhw)s hardware channels to work on your computer.<br><br>Please make sure you have correct audio drivers installed.','',''),('NoCharacterSelected','info','No character selected.','',''),('NoCharges','notify','%(launcher)s has nothing to fire.','res:/Sound/ui/voc/NoCharges.ogg',''),('NoContrabandInMarket','info','Can\'t offer contraband items in market.','res:/sound/ui/error07.wav',''),('NoCorpTickerNameSuggestions','info','Unlucky::Sadly there are no suggestions for a ticker name, why don\'t you try a more unique corporation name?','',''),('NoCynoInPOSShields','notify','You cannot set up a cynosural field within the force field of a Control Tower','',''),('NoDestinationSelected','info','Information::You have not selected a destination.<br>Please select a destination.','',''),('NoDroneManagementAbilities','notify','You cannot launch the %(item)s because you do not have the skill to control any drones.','',''),('NoDroneManagementAbilitiesLeft','notify','You cannot launch %(item)s because you are already controlling %(limit)s drones, as much as you have skill to.','',''),('NoEnoughEnergy','notify','','',''),('NoFactorySlotsAreAvailableForRenting','info','Nothing Available::No factory slots are available for renting at the moment.','',''),('NoFittingLocations','notify','There are no suitable locations for that item.','res:/sound/ui/GlassyBeep18.wav',''),('NoFreeShipSlots','info','There are no free slots on the ship. Unfit some modules first.','',''),('NoFreeSlots','info','No free slots. You have to delete a character if you want to create a new one.','',''),('NoItemsAvailableForActivity','info','No Item Available For Activity::No items are available for %(activityName)s.','',''),('NoItemToCompleteObjective','notify','You need %(qty)s of %(item)s to complete this objective.','',''),('NoItemTypesFound','info','No Items Found::Your query returned no legitimate item types. Please try again.','',''),('NoMergingDifferentContrabands','notify','Contraband items cannot be merged with non-contraband items.','res:/Sound/ui/voc/NoMrgngDffrntContrabands.ogg',''),('NoMergingDifferentExtraInfos','info','Cannot Merge::You cannot merge these items, because one has extra info on it that would be lost.','',''),('NoMergingDifferentTypes','info','You cannot stack things of different types.','',''),('NoMessage','info','There is no message to send','',''),('NoobieShipCreated','notify','We from the friendly insurance company Pend Insurance regret the recent loss of your spacecraft. According to the agreement between Pend Insurance and SCC, we hereby grant you a brand new %(ship)s, fully fitted. Also included is a gratuity gift of %(gift)s.','',''),('NoOfficeAtStation','info','No Office at Station::This station does not have a corporation office.','',''),('NoOfficesAreAvailableForRenting','info','No Offices Available::Your request to rent an office can not be satisfied as there are currently no offices available for renting.','',''),('NoPartialRepairOfModules','notify','Modules can not be partially repaired. If you want to use this module you have to repair it completely.','',''),('NoPasswordEntered','info','No password entered::Please enter a password','',''),('NoPointsAssignedToAttribute','info','Nothing To Remove:s:You can\'t remove points from this attribute because there are no points assigned to it. ','',''),('NoPointSettingRelationshipToSelfOrMember','notify','No point setting a relationship to a member or this alliance.','',''),('NoPossibleRoute','info','Information::There is no possible route between the pickup location (%(pickup)s) and the drop location (%(drop)s). Please pick another drop location.','',''),('NoPriceHistory','notify','There is no price history available for this item.','res:/sound/ui/GlassyBeep18.wav',''),('NoResearchFacilitySlotsAreAvailableForRenting','info','Nothing Available::No research facility slots are available for renting at the moment.','',''),('NoResults','info','No Matches Found::No %(group)ss were found with a name that starts with this string.','',''),('NoSentryConsumables','notify','%(structure)s does not have enough consumables to continue activation.','',''),('NoSimpleStructureResources','notify','%(structure)s does not have enough consumables to activate.','',''),('NoSpaceForReplacedItem','notify','There is not enough space in the cargo hold for the charges currently in the %(item)s to be moved into.','',''),('NoSpaceForThat','info','Not Enough Space::You can\'t add the %(itemTypeName)s as there simply isn\'t enough room for it to fit. It takes up %(itemVolume)s units of volume, and there are only %(volumeAvailable)s left.','',''),('NoSpaceForThatCountwise','info','Not Enough Shelf Space::You can\'t add the %(itemTypeName)s as there are simply too many items here already.','',''),('NoSpaceForThatOverload','info','Not Enough Space::You can\'t add the %(item)s as there simply isn\'t enough room for it to fit. The container is currently only capable of fitting %(maximum)s units and it is currently jammed full with %(used)s units.','',''),('NoStructureManagementAbilitiesLeft','notify','You cannot assume control of the %(item)s because you are already controlling %(limit)s structures, as many as you have skill to.','',''),('NoSuchWar','info','No Such War::The war can not be found.','',''),('NotAllCareerSkillsChosen','info','You must choose the skills from the career %(name)s.','',''),('NotAllowedInDetention','info','Not yet allowed::You cannot perform this action until your account has been verified.<br><br>\nThis should not take long, thank you for your patience.','',''),('NotAllTermsSelected','info','You must select all your %(terms)s terms before you can proceed.','',''),('NotAPlatform','notify','That item is not a platform and cannot be assembled like one.','',''),('NoTargetsWithinRange','notify','%(moduleName)s has no suitable targets within range.','',''),('NotASentryGun','notify','That item is not a sentry gun and cannot be assembled like one.','',''),('NotCloseEnoughToAdd','notify','You must be within %(maxdist)s meters from the container to place items into it.','',''),('NotCloseEnoughToBoard','notify','You are not close enough to board the ship. Please get within %(maxdist)s meters.','',''),('NotCloseEnoughToDock','notify','Too Far Away!::You need to be within %(maxdist)s meters of the station to dock with it. Current distance is %(currdist)s meters.','',''),('NotCloseEnoughToJump','notify','Too Far Away:/::Please get within %(maxdist)s meters of the stargate to jump.','',''),('NotCloseEnoughToLoot','notify','You must be within %(maxdist)s meters from the container to remove items from it.','',''),('NotCloseEnoughToOpen','notify','You must be within %(maxdist)s meters from the container to open it.','',''),('NotCloseEnoughToSelfDestroy','notify','You have to be within %(maxdist)s meters to self-destruct the ship.','',''),('NotConnected','info','Not Connected::You need to be connected to perform this operation.','',''),('NotCurrentlyControllingStructure','notify','You cannot perform that action as you are not controlling the %(item)s and need to be in order to do so.','',''),('NotDockable','info','You cannot dock with the object you have selected','res:/sound/ui/error07.wav',''),('NotEnoughCapacitorForOnline','notify','You cannot bring %(module)s online.  Without the support of in-station fitting services your ship requires a %(need)d%% capacitor level, you currently have a capacitor level of %(have)d%%.','',''),('NotEnoughCargoSpace','info','Not Enough Cargo Space::%(volume)s cargo units would be required to complete this operation. Destination container only has %(available)s units available.','',''),('NotEnoughCargoSpaceFor1Unit','info','One unit of %(typeName)s would take %(required)s units of space. This container only has %(free)s units free.','',''),('NotEnoughCargoSpaceOverload','info','Not Enough Cargo Space::The cargo bay is overloaded and cannot be made to fit %(item)s.  It is currently only capable of fitting %(maximum)s units and it is currently jammed full with %(used)s units.','',''),('NotEnoughCharges','info','%(launcher)s has %(got)d charges, but needs %(need)d to fire.','res:/sound/ui/voc/NoCharges.ogg',''),('NotEnoughChargeSpace','notify','There is not enough space to add those charges. There is only %(capacity)f units of space, but the charges require %(volume)f units.','',''),('NotEnoughCpu','info','To bring %(moduleName)s online requires %(require)0.1f cpu units, but only %(remaining)0.1f of the %(total)0.1f units that your computer produces are still available.','',''),('NotEnoughDroneBaySpace','notify','Not Enough Drone Bay Space::%(volume)s units would be required to complete this operation. Destination container only has %(available)s units available.','',''),('NotEnoughDroneBaySpaceOverload','info','Not Enough Drone Bay Space::The drone bay is overloaded and cannot be made to fit %(item)s.  It is currently only capable of fitting %(maximum)s units and it is currently jammed full with %(used)s units.','',''),('NotEnoughEnergy','notify','%(effectname)s requires %(need).1f units of charge. The capacitor has only %(got).1f units.','res:/Sound/ui/voc/NotEnoughPow.ogg',''),('NotEnoughLauncherSlots','info','You cannot fit the %(moduleName)s because your ship doesn\'t have any launcher slots left for fitting, possibly because you have already filled your ship with launchers or that the ship simply can not be fitted with launchers.  <br><br>Launcher slots represent how many weapons of a certain type can be fitted on a ship.  The current design is over a hundred years old, and is modular enough to allow for a great leeway in the fitting of various weaponry.','',''),('NotEnoughMineralsAtLocation','notify','There is not enough %(missingMineral)s at %(mineralLocation)s for manufacturing to complete.','',''),('NotEnoughMoney','info','Not Enough Money::Your wallet contains only %(balance)s you require %(amount)s to complete this operation.\n','',''),('NotEnoughMoneyCorp','info','Not Enough Money::%(owner)s would need <b>%(amount)s</b> in division <b>%(division)s</b> to complete this operation, while it only has <b>%(balance)s</b>.','',''),('NotEnoughPower','info','To bring %(moduleName)s online requires %(require)0.1f power units, but only %(remaining)0.1f of the %(total)0.1f units that your power core produces are still available.','res:/Sound/ui/voc/InsufficientPower.ogg',''),('NotEnoughPowerOutput','info','Power Core::To bring %(moduleName)s online requires %(require)0.1f power units. The total power output of your ship is only %(total)0.1f. Fitting a single module that requires more than all the power of your ship will blow your power core\'s fuse.','res:/Sound/ui/voc/InsufficientPower.ogg',''),('NotEnoughQuantity','info','Cannot Complete::Insufficient %(typename)s to complete this transaction.','',''),('NotEnoughRepairMaterialToFinishAllRepairs','notify','There is not enough %(typeName)s to finish all the module repairs you have going and this one.','',''),('NotEnoughShares','info','Not Enough Shares::There are not enough shares to complete the requested transaction. You would need %(amount)s shares to complete this operation, while you only have %(balance)s. ','',''),('NotEnoughSpace','info','Not Enough Space::%(volume)s units of space would be required to complete this operation. Destination container only has %(available)s units available.','',''),('NotEnoughSpaceOverload','info','Not Enough Space::The storage area is overloaded and cannot be made to fit any %(item)s.   It is currently only capable of fitting %(maximum)s units and it is currently jammed full with %(used)s units.','',''),('NotEnoughStorageSpace','info','There is not enough storage space. Currently %(used)s of a maximum %(capacity)s is used and you need %(needed)s.','res:/sound/ui/error07.wav',''),('NotEnoughTurretSlots','info','You cannot fit the %(moduleName)s because your ship doesn\'t have any turret slots left for fitting, possibly because you have already filled your ship with turrets or that the ship simply can not be fitted with turrets.\n<br><br>Turret slots represent how many weapons of a certain type can be fitted on a ship.  The current design is over a hundred years old, and is modular enough to allow for a great leeway in the fitting of various weaponry.','',''),('NotEnoughUpgradeCapacity','info','You cannot fit the %(moduleName)s because your ship cannot handle it.  Your ship can only fit so many upgrades as each interferes with its calibration and past a certain point your ship is rendered unusable.','',''),('NotEnoughUpgradeSlots','info','You cannot fit the %(moduleName)s because your ship doesn\'t have any upgrade slots left for fitting, possibly because you have already filled your ship with upgrades or that the ship simply can not be fitted with upgrades.','',''),('NoteTooLong','question','Your note is too long::The text of the note you entered is too long.<br>It currently contains %(total)s chars.<br>The maximum length is about 3900 chars.<br><br>Click Yes to continue editing the note, otherwise click No and the changes will not be saved.','',''),('NothingToJettison','notify','The cargo hold is empty so there is nothing to jettison.','',''),('NotifyNewCaptureRoot','info','New file location:s:From now on all screenshots and logfiles are stored under %(path)s','',''),('NotifyScreenshotAdapterSelection','info','Taking Screenshots::In windowed mode, taking screenshots is limited to your primary display adapter.<br><br> Move the client window onto your primary display adapter %(adapter)s or select it in Display Setup.','',''),('NotInMissionPackage','info','Can\'t do that::Can\'t do that in a mission package.','',''),('NotPermittedToAddChar','notify','You cannot put items into that container because it belongs to %(owner)s and you are not in their fleet, their corporation or held in the highest personal standing by them.','',''),('NotPermittedToAddCorp','notify','You cannot put items into that container because it belongs to %(owner)s and you are a member of that corporation.','',''),('NotRealPilotInvite','info','Information::He/she is not a real pilot, so he wouldn\'t accept the invitation anyway.','',''),('NotYourMission','notify','This is not your mission.','',''),('NotYourMissionToAbort','notify','You do not have the rights to abort this mission.','',''),('NotYourWarToEnd','info','Not Your War::This ain\'t your war! So you can\'t put a stop to it...','','');
insert  into `eveMessages`(`messageID`,`messageType`,`messageText`,`urlAudio`,`urlIcon`) values ('NoValidItemForMission','info','Information::You haven\'t seleced any valid item. All containers are excluded from %(type)s.','',''),('ObjectAnchoredAlready','notify','That object is already anchored.','',''),('ObjectiveAlreadyCompleted','notify','This objective has already been completed.','',''),('ObjectUnanchoredAlready','notify','That object is already unanchored.','',''),('OffenseManagementFullyUtilized','notify','You are currently managing as many offensive actions as you have the aptitude for.','',''),('OfflineHasSkillPrerequisites','notify','Unable to put %(itemName)s offline. This action requires having learned the following skills: %(requiredSkills)s.','',''),('OnCharCreate','audio','','',''),('OnCharCreate2','audio','','',''),('OnCharSel','audio','','res:/sound/ui/CharSelSlotEnter.wav',''),('OnCharselClick','notify','','',''),('OnConnecting','audio','','res:/Sound/ui/voc/Connecting.ogg',''),('OnConnecting2','audio','','res:/sound/ui/OnLogin04.wav',''),('OnConnectionBadAddress','info','Bad Address::%(what)s','',''),('OnConnectionFailed','info','Connection Failed::%(what)s','',''),('OnConnectionRefused','info','Connection Refused::%(what)s','',''),('OnDockingRequest','audio','','res:/Sound/ui/voc/RequestingDock.ogg',''),('OneCapitalOnly','notify','I\'m terribly sorry sir, but we cannot have two capitals in the same constellation. Rumor has it that it might cause a rift in the space-time continuum!','',''),('OnEnterStation','audio','','',''),('OnGotMessage','audio','You have received a new message.','res:/sound/ui/OnGotMessage.wav',''),('OnlineHasSkillPrerequisites','notify','Unable to bring %(itemName)s online. This action requires having learned the following skills: %(requiredSkills)s.','',''),('OnlineRequiredAnchor','notify','The %(item)s can only be brought online when it is firmly anchored.  It cannot be brought online while unanchored, unanchoring or while anchoring.','',''),('OnLogin','audio','','res:/sound/ui/OnLogin.wav',''),('OnlyAcceptedApplicationsCanBecomeEffective','notify','Only accepted applications can be made effective.','',''),('OnlyActiveCEOCanCreateAlliance','notify','Only an active CEO can create an alliance.','',''),('OnlyCEOCanPayoutDividends','info','Access Denied::You are not the CEO of this corporation, and thus it is not possible for you to payout dividends.','',''),('OnlyCEOCanProposeVote','info','Access Denied::You cannot propose a vote because you are not the CEO of this corporation.','',''),('OnlyCEOCanResign','info','Access Denied::You are not the CEO of this corporation, and thus it is not possible for you to resign as the CEO.','',''),('OnlyCEOOrEquivCanAddStandings','info','Access Denied::You cannot add standings, because you are not the CEO or equivalent of the corporation.','',''),('OnlyCEOOrEquivCanEditCorp','info','Access Denied::You cannot edit the corporation you are a member of, probably because you are neither the CEO or equivalent.','',''),('OnlyOneBoosterActive','notify','You cannot consume the %(typeName)s as you are already using another similar booster %(typeName2)s.','',''),('OnlyOneImplantActive','notify','You cannot install the %(typeName)s as there is already an implant installed in the slot it needs to occupy.','',''),('OnMachoTimeout','info','Communications Timeout::%(what)s','',''),('OnTabClick','audio','','res:/sound/ui/ui05.wav?vol=0.3',''),('OnWndDock','audio','','res:/sound/ui/OnWndDock04.wav',''),('OpenCorpHangarNoHangar','info','No Such Hangar::The corporation you are a member of does not have an office at this station.','',''),('OpenCorpHangarNotAtStation','info','You cannot see that far?::You have to be at the station where the office is in order to see its content.','',''),('OperationNotAllowedOnCopiedBlueprint','info','Blueprint Only a Copy::The operation specified cannot be performed on a copied %(blueprintTypeName)s.','',''),('OptionMaxSelectionsExceeded','info','This option can only be selected a maximum %(max)s times.','',''),('OtherCharNotAtStation','notify','%(name)s is not at this station.','',''),('OwnerPopup','','The message is specified via body, title, and ownerID in the message args.','',''),('OwnerStillInsideShip','notify','You cannot do that with the ship while you are still inside it.','',''),('PackageMustBeInYourHangar','notify','The %(item)s must be in your hangar.','',''),('PackageTooBig','info','Information::This package is too big. Courier mission packages can not be bigger than %(max)s m3, this one is %(size)s m3','',''),('paintshopBtnEnter','audio','','res:/sound/ui/uihme01.wav',''),('paintshopHeader','audio','','res:/sound/ui/uihptxt02.wav',''),('PatchAutomaticUpdate','question','New Build Available::There is a new build available. Would you like to download it now?<br>The build is %(size)s MB in size.','',''),('PatchDownloadCancelled','question','Download Cancelled::You have cancelled the patch download.<br><br>You will not be able to enter the game until you patch. Would you like to manually download the patch file?<br><br>%(text)s','',''),('PatchDownloadFailed','info','There was an error downloading the patch file<br>Please try again.','',''),('PatchLiveServerConnectWrongVersion','question','Incorrect Version::You are currently trying to connect to the EVE server which is running version %(serverVersion)s. Your client version is %(clientVersion)s.<br>Would you like to download a patch for your client now?','',''),('PatchStartPatch','info','Ready to Patch::The patch has been downloaded. The client will now close and the patch process begin.<br><br>Press \'OK\' to continue.','',''),('PatchStatusCheckFailed','question','There was an unexpected error while retrieving patch status:<br><br>%(text)s<br><br><br>Do you want to go to support page?','',''),('PatchTestServerWarning','question','You are currently trying to connect to the EVE test server which is running version %(serverVersion)s.  Your client version is %(clientVersion)s.<br>To upgrade your test client, please visit http://www.eve-online.com/patches/testpatches.asp.','',''),('PatchTooRecent','info','The client version you are running is too recent for the selected server. You are running version %(clientVersion)s but the server is running version %(serverVersion)s.','',''),('PatchVerificationfailed','info','The patch has been downloaded but failed verification<br>Please try again.','',''),('PatchVerified','info','The patch has been downloaded and verified<br>Click OK to apply the patch.','',''),('PatchVerifyFailed','question','Verification Failed::The patch was downloaded but it failed verification indicating that the file is corrupt. Would you like to manually download the patch file?','',''),('PatchVerifyFailedTryAgain','question','Verification Failed::The patch was downloaded but it failed verification indicating that the file is corrupt. Would you like to download the file again? <br><br>You will not be able to enter the game until you download the patch.','',''),('PeopleAboardShip','question','People Aboard Ship::This ship cannot be traded or sold; there are people on board!','',''),('PeopleNotAllowOnScrapHeap','info','Be Humane::Throwing people onto the scrap heap is not a nice thing to do.','',''),('PeopleStillInsideShip','notify','You cannot do that with the ship while there are other people still inside it.','',''),('PerformSessionChangeInProgress','notify','%(reason)s','res:/sound/ui/uiwarning01.wav?vol=0.3',''),('PermissionDenied','info','You can\'t do that::You do not have permission to execute that command.','',''),('PermissionDeniedCorpDoesntAllow','notify','You cannot do that on behalf of the %(corp)s corporation because they do not allow it.','',''),('PermissionDeniedNeedEquipRole','notify','You cannot do that on behalf of the %(corp)s corporation because they have not given you the equipment config role.','',''),('PermissionDeniedNeedStarbaseRole','notify','You cannot do that on behalf of the %(corp)s corporation because they have not given you the starbase config role.','',''),('PermissionDeniedNotInCorp','notify','You cannot do that on behalf of the %(corp)s corporation because you are not a member.','',''),('PermissionDeniedNotOwner','notify','You are unable to do that to the %(item)s as it is owned by %(owner)s and not by you.','',''),('PersonalMarketExportInfo','info','Personal Market Export Information:s:%(sell)s sell orders and %(buy)s buy orders were exported to the file %(filename)s in the directory %(directory)s','',''),('PersonNotOnline','info','The person you where trying to reach in not online, try later','',''),('PetitionClosed','notify','Message was not send becouse petition is closed','',''),('PetitionInfo1','info','Information::The petition no longer exists or has already been claimed by somebody else.','',''),('PetitionQuestion1','question','Confirm Open Petitions?::You have %(messages)s unread messages in your petition box.<br><br>Would you like to open your petitions?','',''),('PetitionQuestion2','question','Are you sure?::Your petition will be permanently deleted!','',''),('PetitionQuestion3','question','Are you sure?::Your petition will be permanently deleted, before anyone has even looked at it','',''),('PetitionSuccess','info','Petition Successfully Filed::%(text)s','',''),('PetPetioneeGotResposne','notify','%(characterName)s just responded to a claimed petition','',''),('PetPetitionResponse','notify','You have just received a response to a petition.','',''),('PhysicalBenefitMissing','info','Physical Benefit Missing: %(name)s requires %(benefitName)s, which you don\'t have.','',''),('PilotAlreadyOnBoard','notify','The pilot seat is already taken.','',''),('PlatformAlreadyAssembled','notify','You cannot assemble that platform as it has already been assembled.','',''),('PlatformNotAssemblableThere','notify','To be able to assemble that platform it needs to be located in your personal hangar or your corporation\'s hangar.','',''),('PlayahCantCreateCorporation','info','You Can\'t Do That!::You cannot create a corporation at the moment as you are either too poor or you are already the CEO of another corporation.','',''),('PlayerCantCreateCorporation','info','Corporation Creation Request Denied::Your request to create a corporation has been turned down. In order to create a corporation you should have the funds to do so. Currently the startup cost is %(cost)s ISK. You should also have the skill Corporation Management. Another skill you may find handy is Ethnic Relations, you will need this if you want to have people in your corporation that are not of your race.','',''),('PleaseSelectInputLocation','info','Information::Please select an input location for the job.','',''),('PleaseSelectOutputLocation','info','Information::Please select an input location for the job.','',''),('PodCannotScan','info','No Scanner::Your Escape Capsule does not appear to be fitted with an on-board scanner.','',''),('PopUp','audio','','',''),('POSAggressionInSecureSpaceNotAllowed','notify','The array cannot fire at the current target. \n%(systemname)s is a CONCORD protected system and falls under treaty 32A which forbids controlled POS agression against civilian targets. ','',''),('POStationWarning','info','Disputed Territory:s:The station you are at is a disputed territory. Members of the corporation that own this station can perform various tasks that may effect what you want to do at this station. This includes, but is not limitted to the following issues.\n<br>\n<br>Clone Contracts<br>Clone contracts can be removed. They will be placed at the HQ station of the owner of the contract.<br>\n<br>Security Monitoring<br>Security monitoring can be performed to check the contents of hangars and offices at the station.<br>\n<br>Rental Agreements (Offices / Factory Slots / Research Facility Slots)<br>Items that are rented from the station, such as the aforementioned, can be marked as being no longer publicly available. This means that when the rental expires no more bills are issued. Thus the rented item will adventually fall back into the possesion of the corporation that owns the station.<br>\n<br>Ejecting Jobs<br>Any job in a factory or research facility can be ejected by the corporation that owns the station. This may result in a loss of materials, as would be expected from ejecting a job.<br>\n<br>Docking Fees<br>The owner of the station may require the payment of a docking fee for any vessel that docks at the station.<br>\n<br>Pricing<br>The owner of the station may place discounts and surcharges for various services offered at the station. This may cause prices to increase or decrease depending upon what they think of you and, or your corporation.<br>\n<br>Service Restrictions<br>may be put in place based upon what the owner of the station thinks of you and, or your corporation.','',''),('PreconditionFailed','info','Are We Forgetting Something?::In order to accept this mission there is a little task you have to complete first. That task being: %(precondition)s When you have done that, it might be possible for you to accept this mission.','',''),('PrereqImplantMissing','notify','Attempting to use this implant without the aid of a %(typeName)s will destroy your cerebral cortex.  Please consider alternate methods of suicide.','',''),('PriceCanNotBeNegative','info','Prices must be strictly positive, you entered %(price)s.','',''),('ProbesInGroup1','info','The %(type)s probe works autonomously without the help of other probes','',''),('ProbesInGroup2','info','The %(type)s probe must be selected with %(count)s other similar probes','',''),('ProdClearLinks','question','Clear structure links::Do you want to remove all links between structures?','',''),('ProductionJobWillFail','info','Production Job Will Fail::It is not possible to %(activityName)s a %(typeName)s, there is no chance of it succeeding.','',''),('ProgressLoop','audio','','res:/sound/ui/loadingLoop.wav',''),('ProgressStart','audio','','res:/sound/ui/loadingIn.wav',''),('ProgressStop','audio','','res:/sound/ui/loadingOut.wav',''),('PutOffline','question','Confirm::Put this module offline?','',''),('QuantityAskedTooHigh','info','Cannot move %(qtyasked)d items, only %(qtyavail)d are available.','res:/sound/ui/error07.wav',''),('QuantityCanNotBeLessThanOne','info','You cannot sell a negative quantity, you have entered %(quantity)s','',''),('QuantityLessThanMinimumPortion','info','Need More %(typename)s::You need at least %(portion)s items of %(typename)s in a single stack to complete this action.','',''),('QuantityMoreThanMaximumVolume','info','Too Much %(typename)s::You cannot refine more than a volume of %(volume)d meters cubed at a time.','',''),('question','audio','','res:/sound/ui/ui02.wav?vol=0.4',''),('QuickJumpSploitPrevention','info','%(system)s Traffic Control cannot authorize your departure, as the paperwork for your jump-in hasn\'t been filed yet.  Please try again in a moment.','',''),('RaceCaldari','notify','The modern Caldari State was forged in war, a fact that shapes its society a great deal. They are determined and military minded, living their lives like they were at a constant brink of armed conflict. The result is a weird combination of aggressiveness and paranoia. The Caldari are widely regarded as fearsome fighters, be it in space or on the ground, and their high quality military hardware is much admired and imitated by the other empires, bar only the Jovians. The Caldari excel in missile manufacturing and very maneuverable and fast ships.','',''),('RaceMinmatar','notify','The Minmatar society is a tribal one, although the widely different status of the race today has blurred this in the minds of some of them. Yet the tribal culture is very strong with most of them and they have managed to retain their customs remarkably well. So much so in fact that a Minmatar of any given tribe can travel the width of the world, visiting fellow tribesmen and always feel at home, whether he visits a wealthy merchant within the Gallente Federation, an unscrupulous pirate in the outer regions or even a slave within the Amarr Empire. The Minmatars are the most populous of the races, but also the most politically fragmented. Only a quarter of them reside in their official empire, the Minmatar Republic.','',''),('RadarZoomIn','audio','','res:/sound/ui/ZoomIn06.ogg',''),('RadarZoomOut','audio','','res:/sound/ui/ZoomOut06.ogg',''),('RamAccessDeniedCorpSecStatusTooHigh','info','Access Denied::Your corporations security status is too high.','',''),('RamAccessDeniedCorpSecStatusTooLow','info','Access Denied::Your corporations security status is too low.','',''),('RamAccessDeniedCorpStandingTooLow','info','Access Denied::Your corporations standing is too low.','',''),('RamAccessDeniedNotPilot','info','Only for Pilots::You can only only use an installation in a ship when you are in the ship.','',''),('RamAccessDeniedSecStatusTooHigh','info','Access Denied::Your security status is too high.','',''),('RamAccessDeniedSecStatusTooLow','info','Access Denied::Your security status is too low.','',''),('RamAccessDeniedStandingTooLow','info','Access Denied::Your standing is too low.','',''),('RamAccessDeniedToBOMHangar','info','Access Denied::You have insufficient rights to take materials from the specified location for this job.','',''),('RamAccessDeniedWrongAlliance','info','Access Denied::You are not a member of the alliance that owns this resource.','',''),('RamAccessDeniedWrongCorp','info','Access Denied::You are not a member of the corporation that owns this resource.','',''),('RamActivityInvalid','info','Invalid Activity::The activity requested is not supported.','',''),('RamActivityRequiresABlueprint','info','Invalid Job::The job cannot be created as the activity specified requires a blueprint and the item you are installing is not a blueprint.','',''),('RamAssemblyLineHasNoActivity','info','Bad Assembly Line::The selected assembly line does not support any activities. Please select a different one and try again.','',''),('RamBadEndProductForActivity','info','Cannot Create Job::This product cannot be manufactured at this facility.','',''),('RamBlueprintAlreadyInstalled','info','Already Installed::This blueprint has already been installed in a Science and Industry job. Installing it again is just greedy.','',''),('RamCancelJobConfirm','question','Cancel Job?::If you cancel this job you will get your blueprint back but your entire bill of materials will be lost.<br>Also, whatever progress which has been made in this production job will also be lost.<br>Note: Cancelling this job will not free up the production slot!<br><br>Are you sure you want to cancel this job?','',''),('RamCannotContactFacility','info','Cannot contact facility::Cannot establish contact with the Science & Industry facility. If it is in a different system you might have to travel closer.','',''),('RamCannotCopyABlueprintCopy','info','Cannot Create Job::The job cannot be created as you cannot copy a blueprint copy.','',''),('RamCannotCopyInPlayerLab','warning','Cannot copy::You cannot install a Blueprint Copy job in this Mobile Laboratory because it is not owned by your corporation.\n<br><br>\nPlease join the corporation or install your job in a different place.','',''),('RamCannotCopyZeroRuns','info','Need runs!::It is not possible to create a blueprint copy with 0 runs. ','',''),('RamCannotGuaranteeStartTime','info','Cannot Create Job::Oops, it looks like someone cut in line. We\'re terribly sorry for the inconvenience.<br><br>Please select an assembly line again.','',''),('RamCannotInstallForCorpByRole','info','Access Denied::You cannot install this job for your corporation as you do not have the correct role to do so.','',''),('RamCannotInstallForCorpByRoleFactoryManager','info','Access Denied::You cannot install this job for your corporation because you do not possess the role \"Factory Manager\"','',''),('RamCannotInstallItemForAnother','info','Access Denied::You cannot install the specified item for yourself as it belongs to someone else.','',''),('RamCannotInstallItemForAnotherCorp','info','Access Denied::You cannot install the specified item for your corporation as it does not belong to them.','',''),('RamCannotInstallWithoutRentFactorySlot','info','Access Denied::You do not posses the role Rent Factory Slot or equivalent, which is needed to rent the type of assembly line you are trying to use.','',''),('RamCannotInstallWithoutRentResearchSlot','info','Access Denied::You do not posses the role Rent Research Slot or equivalent, which is needed to rent the type of assembly line you are trying to use.','',''),('RamCannotInventABlueprintOriginal','info','Cannot Invent from a BPO::You cannot start a Reverse Engineering job with an original Blueprint. You must use a Blueprint Copy for this job.','',''),('RamCannotInventZeroRuns','info','Need runs!:: Cannot invent on a blueprint copy with 0 runs.','',''),('RamCannotResearchABlueprintCopy','info','Cannot Create Job::The job cannot be created as you cannot research a blueprint copy.','',''),('RamCompletionAccessDenied','info','Cannot Complete Job::You have no right to complete this job.','',''),('RamCompletionAccessDeniedByCorpRole','info','Cannot Complete Job::You have insufficient roles to complete this job for your corporation.','',''),('RamCompletionInProduction','info','Cannot Complete Job::The job cannot be completed as it is still in production.','',''),('RamCompletionJobCompleted','info','Cannot Complete Job::The job cannot be completed as it has already completed.','',''),('RamCompletionMustBeInShip','info','Failed to Deliver::You cannot deliver this job unless you are the pilot of the ship that the job is installed in.','',''),('RamCompletionNoSuchJob','info','Cannot Complete Job::The job cannot be completed as there is no such job.','',''),('RamConfigAssemblyLinesAccessDenied','info','Access Denied::You cannot configure these assembly lines as they do not belong to you or your corporation.','',''),('RamConfigAssemblyLinesInsuficientAccess','info','Access Denied::You have insufficient access rights to configure these assembly lines for your corporation.','',''),('RamCorpBOMItemNoSuchOffice','info','Office Not Found::Your corporation does not have an office at %(location)s. When you are installing a job the materials required must be located in an office belonging to your coproration in the same station. Please pick a different installation where your corporation has an office and try again.','',''),('RamCorpInstalledItemNotInCargo','info','Item Warning::The item you are trying to install appears to be in your cargo. Please place the item on your hangar floor or corporate hangar floor and try again.','',''),('RamCorpInstalledItemWrongLocation','info','Failed To Install::The item you are installing must be on your corporations hangar floor at %(location)s.','',''),('RamInstallationBlueprintLocationError','info','Cannot install job::Blueprint location and installation location are not compatible. <br><br>You cannot install this blueprint from its current location into the selected installation.','',''),('RamInstallationHasNoDefaultContent','info','No Assembly Lines::The installation you are trying to use has no assembly lines.','',''),('RamInstallationIDUnexpected','info','Installation Issue::There is something wrong with the installation you are trying to access. Please try the operation again.','',''),('RamInstalledItemBadLocation','info','Item Warning::The item you are trying to install is not in an acceptable location. For example, the item may not be in a container.','',''),('RamInstalledItemBadLocationStructure','info','Failed To Install::The item you are trying to install must be located in the %(type)s or in a corporate hangar in a station in the same solar system.','',''),('RamInstalledItemInStructureNotInContainer','info','Failed To Install::The item you are attempting to install must be either in a station or on the floor of the structure. It may not be in a container.','',''),('RamInstalledItemInStructureUnknownLocation','info','Failed To Install::The item you are attempting to install must be either in a station or on the floor of the structure. It may not be in a container.','',''),('RamInstalledItemMustBeInInstallation','info','Failed To Install::The item you are trying to install must be in the same location as the installation you are trying to use.','',''),('RamInstalledItemMustBeInShip','info','Failed To Install::The item you are attempting to install must be located in your ship. It may not be in a container in your ship.','',''),('RamInstalledItemWrongLocation','info','Failed To Install::The item you are installing must be located at %(location)s.','',''),('RamInstallJob_InstalledItemChanged','warning','Blueprint Outdated::The blueprint you installed has been changed.  Please refresh and try again.','',''),('RamInvalidRegion','info','Invalid Region::You are not allowed to install or complete a job in a different region','',''),('RamInventionJobFailed','info','Nothing of value::Sadly you were unable to produce anything of value in this job.<br><br>%(info)s','',''),('RamInventionJobSucceeded','info','Job Successful::Great news! You were successful in producing a new Tech II blueprint!\n<br><br>%(info)s<br>\n<br><b>Blueprint details:</b><br>\nBlueprint Type: <a href=\"showinfo:%(typeid)s//%(itemid)s\">%(type)s</a><br>\nNumber of Runs: %(runs)s<br>\nMaterial Level: %(me)s<br>\nProductivity Level: %(pe)s<br>','',''),('RamInventionNoOutput','info','No Output::This job cannot result in an output blueprint. The reason might be that the metalevel of your input blueprint is too high or that there are no items in the same metagroup with a higher metalevel.','',''),('RamInventionSourceMetaLevelTooHigh','info','Base item too advanced::The base item, %(item)s is too advanced for this job. We have no idea how it works.<br>You should select an item more similar to your source blueprint.','',''),('RamInventionWrongDecryptor','info','Wrong decryptor type::The Invention job you are trying to install requires a decryptor of the type %(groupName)s.','',''),('RamIsNotAnInstallation','info','What Installation::The location you are trying to use is not an installation.','',''),('RamItemInTrash','info','Item Trashed::The item you are trying to install has been trashed.','',''),('RamLineInUseConfirm','question','Line in use::This assembly line is already in use. It will not be free until after %(time)s. You might want to consider selecting another assembly line.<br><br>Would you like to queue your job up on this assembly line?','',''),('RamMustSelectInstallation','info','Select Installation First::You have to select an installation before Changing the blueprint.','',''),('RamNeedMoreForJob','info','Need More::The job cannot be installed as you do not have enough of the following material: %(item)s.\n<br>Note: Ships have to be repackaged before they can be used in a manufacturing job.','',''),('RamNeedSkillForJob','info','Cannot Create Job::The job cannot be installed as you do not have level %(skillLevel)s in the following skill: %(item)s.','',''),('RamNoCorpAccount','info','No Corporation Wallet::You cannot install a job for your corporation unless you have an active Corporation Wallet Division. Please go to your corporation wallet and select a wallet division.','',''),('RamNoKnownOutputType','info','Pointless Job::The job requested will not produce anything.','',''),('RamNoShip','info','You don\'t have a ship::Only pilots are allowed to manufacture and research. You are just a clump of biomass at the moment.','',''),('RamNotYourItemToInstall','info','Item Warning::It would appear that the item you are trying to install does not belong to you or your corporation. Please pick a different item to install and try again.','',''),('RamPleasePickAnInstalltion','info','Select Installation?::You have not selected an installation. Please select an installation and then try again.','',''),('RamPleasePickAnItemToInstall','info','Nothing to Install::You have not selected an item to install. Please select an item, such as a blueprint to install and try again.','',''),('RamProductionTimeExceedsLimits','info','Production Time Exceeds Limits::The production time of this job exceeds the limits. Please choose a lower batch quantity.<br>\n<br>\nProduction time: %(productionTime)s<br>\nLimit: %(limit)s\n','',''),('RamRangeLimitation','info','Too Far Away::Your skill level only allows you to issue %(range)s','',''),('RamRangeLimitationJumps','info','Too Far Away::You are too many jumps away from the installation. You are %(jumps)s jumps away but you can only remotely manage over %(maxjumps)s jumps.','',''),('RamRangeLimitationJumpsNoSkill','info','Missing Required Skill::You are %(jumps)s jumps away from this installation and you lack the required skill to remotely manage your Science & Industry jobs.','',''),('RamRangeLimitationRegion','info','Too Far Away::You are not located in the same region as the installation.','',''),('RamRemoteInstalledItemImpounded','info','Failed To Install::The remote item you are trying to install is an impounded item. You must unimpound the item before attempting to use it.','',''),('RamRemoteInstalledItemInStationNotHangar','info','Failed To Install::The remote item you are trying to install must be located on your hangar floor. It may not be located in some container on that floor.','',''),('RamRemoteInstalledItemNotInOffice','info','Failed To Install::The remote item you are trying to install must be located on your corporate hangar floor. It may not be located in some container on that floor.','',''),('RamRemoteInstalledItemNotInStation','info','Failed To Install::The remote item you are trying to install must be on a hangar floor or in your corporate hangar. It may not be in a container at either of these locations.','',''),('RamStationIsNotConstructed','info','What station::The station you are trying to access has not been constructed yet.','',''),('RamStructureNotInSpace','info','Failed To Install::The %(type)s you are trying to use is not in space.','',''),('RamStructureNotIsSolarsystem','info','Failed To Install::The structure you are trying to use in is not in a solar system. Thus it cannot be online.','',''),('RamTooManyProductionRuns','info','Cannot Create Job::The job cannot be created as the blueprint does not have enough production runs left.','',''),('RankGained','notify','You have been promoted to the rank of %(rank)s.','res:/sound/messages/YouHaveBeenPromoted.ogg',''),('RankLost','notify','You have been demoted to the rank of %(rank)s.','res:/sound/messages/YouHaveBeenDemoted.ogg',''),('refineryHeader','audio','','res:/sound/ui/uihrefinetxt.wav',''),('RefiningRequiresSkills','notify','Types belonging to the group %(group)s cannot be reprocessed. This is because there is no relevant skill for reprocessing types of that group.','',''),('RegionChatFadeIn','audio','','res:/sound/ui/RegionChatFadeIn.wav',''),('RegionChatFadeOut','audio','','',''),('RegionInputEnter','audio','','',''),('ReleaseSubtitle','audio','Empyrean Age','',''),('ReleaseTitle','','EVE Online','',''),('RemoteObjectSessionCheckFailure','fatal','Remote Object Session Check Failure::A remote object used by this client was being used with incorrect session attributes.  It was built for %(attribute)s=%(expected)s, but that attribute is currently %(current)s.  It\'s objectID is %(objectID)s, and it\'s persistant objectID is %(persistantObjectID)s.','',''),('RentingAnOfficeCostsMore','info','Request Denied::Renting an office costs %(amount)s ISK, which, as you might notice, is more than what you offered.','',''),('RentingASlotCostsMore','info','Request Denied::Your request for renting a slot has been denied. %(reason)s','',''),('RentingOfficeQuotesOnlyGivenToActiveCEOsOrEquivale','info','Quotes for renting offices are only given out to CEOs and Directors.','',''),('RentingOfficeRequestDenied','info','Request Denied::Your request for renting an office has been denied. %(reason)s','',''),('RentingSlotRequestDenied','info','Request Denied::Your request for renting a slot has been denied. %(reason)s','',''),('RentingYouHaveAnOfficeHere','info','Redundant Operation::You already have an office here.','',''),('RepackageBeforeSelling','info','Selling an item failed::You cannot sell the %(item)s on the market without repackaging it. Please repackage it and try again..','',''),('RepairBeforeSelling','info','Repair %(item)s before selling the %(otheritem)s.','',''),('RepairItemRecycled','notify','There must be some mistake, %(item)s cannot be repaired because it no longer exists.','',''),('RepairModuleNotDamaged','info','There must be some mistake, your %(moduleName)s is not damaged.','',''),('RepairNoMoneyForRepair','info','Need More Money::The quantity you entered is not enough to do any repairing on this %(moduleName)%.','',''),('RepairPartiallyFixed','info','Partial Repair::The %(moduleName)s is %(amountFixed)s fixed as that was all you paid for.','',''),('repairshopBtnEnter','audio','','res:/sound/ui/uihme02.wav',''),('repairshopHeader','audio','','res:/sound/ui/uihrotxt02.wav',''),('RepairUnassembleVoidsContract','question','Terminate Insurance Contract::The %(item)s you want to repackage is insured. Repackaging it will void this contract. Do you want to break the contract by repackaging it?','',''),('ReprocessingFailedShipHasJumpClones','notify','You cannot do the reprocessing because the %(what)s has jump clones installed in it.  Please remove them first.','',''),('ReprocessingFailedShipHasUpgrades','notify','You cannot do the reprocessing because the %(what)s has upgrades installed in it. Please remove them first.','',''),('reprocessingplantBtnEnter','audio','','res:/sound/ui/uihme01.wav',''),('reprocessingplantHeader','audio','','res:/sound/ui/uihrptxt02.wav',''),('ReprocessingPleaseSplit','notify','Please split the refining process into smaller chunks.','',''),('RequiredSkillMissing','info','Required Skill Missing: %(name)s requires the %(skillName)s skill.','',''),('researchfacilityHeader','audio','','res:/sound/ui/uihresearchtxt.wav',''),('RestoringFromLimbo','notify','You are being warped back to your last known position.','',''),('RewardCanNotBeNegative','info','Invalid Reward::The reward specified is invalid. The reward cannot be negative.','',''),('RigFittingInfo','question','Are you sure?:s:The only way to remove this rig is by destroying it.','',''),('RigUnFittingInfo','question','Confirm Rig Destruction?:s:Removing this rig from the ship will permanently destroy the rig. Do you want to continue?','',''),('RoleGMHNeeded','notify','Role GMH needed','',''),('RoleGMLNeeded','notify','Role GML needed','',''),('RolesNotAssignedAutomatically','info','Role Assignment:s:Roles and grantable roles will not be automatically assigned when this contract is accepted. Roles and grantable roles have to be assigned to the applicant by a member of the corporation such as a personnel manager, director or the CEO.','',''),('RunProcessCycle','info','Tower Process Info::%(info)s','',''),('SalvageTooMuchLoot','info','Cannot Salvage::You cannot salvage this wreck because it contains too much loot to fit into a single cargo container. <br>\nThe wreck contains <b>%(volume)s m3</b> but can contain no more than <b>%(maxvolume)s m3</b> to be salvageable.','',''),('SalvagingFailure','notify','Your salvaging attempt failed this time.','',''),('SalvagingPointless','notify','You cannot salvage the %(type)s as there is nothing that can be salvaged from it.','',''),('SalvagingPointlessLoot','notify','You fail to salvage from the %(type)s because your salvaging equipment cannot be engaged until all loot has been removed from it.','',''),('SalvagingPointlessOverload','info','You cannot salvage the %(type)s as you do not have the cargo space to store all the resources which might be recovered under ideal circumstances.  Clear out at least %(units)0.1f m3 of cargo space and try again.','',''),('SalvagingSuccess','notify','You successfully salvage from the %(type)s.','',''),('SalvagingSuccessHollow','notify','You successfully salvage from the %(type)s.  Unfortunately there was nothing to be salvaged.','',''),('SalvagingSuccessOverloaded','notify','You successfully salvage from the %(type)s.  However due to your lack of cargo space, some or all of the salvaged resources may have been destroyed in the process.','',''),('SalvagingTooComplex','notify','Salvaging the %(type)s is too difficult for you to be able to do.','',''),('SalvagingTooLate','notify','Your salvaging attempt failed because the %(type)s was already salvaged.','',''),('SCConfigPasswordRequired','info','Configuration Password Required::The requested task requires the configuration password to have been entered.','',''),('SCGeneralPasswordRequired','info','General Password Required::The requested task requires the general password to have been entered.','',''),('ScnAlreadyActive','notify','You ship is already scanning and cannot initiate another until the first is complete.','',''),('ScnAlreadyInProgress','notify','You cannot start a new scan when one is already in progress.','',''),('ScnGrpsNotEnoughSkill','notify','You do not have enough skill to scan that many groups at the same time.','',''),('ScnMixedProbes','notify','You cannot scan using probes together which are intended for different scanning purposes.','',''),('ScnNoLauncher','info','Launcer Not Online::Scan probe launcher must be online in order to analyze results from probe','',''),('ScnNoMaterials','info','No Materials::Probe did not find any material worth exploiting on %(moonName)s','',''),('ScnNoProbes','notify','Communication to probe(s) failed','',''),('ScnNoResults','notify','No scan signatures detected','',''),('ScnProbeForShips','notify','You cannot scan for anything other than ships with the %(probe)s.','',''),('ScnProbeProximity','notify','You cannot deploy that probe because it would either be within the scan range of another probe you already have in space, or would result in another of your probes being within its scan range.','',''),('ScnProbeProximityGive','notify','You cannot give the probe to %(char)s because it would either be within the scan range of another probe they already have in space, or would result in another of their probes being within its scan range.','',''),('ScnProbeUnusable','info','Scan probe interference::The act of launching a probe links it to the launcher that put it into space.  One of the probes you have selected was launched with a launcher you no longer have fitted, and is interfering with the scan.  Retry the scan without it.','',''),('ScnShipIsCapsule','info','Scan Facilities Lacking::You cannot deploy your ship scanner in a capsule as it lacks the ability to do so.','',''),('ScnShipScannerDeadspaceOnly','info','Illegal Scan Group::Your on-board scanner can only be used to scan for cosmic anomalies.','',''),('ScnShipScannerTooManyProbes','info','Too Many Probes::You cannot deploy your ship scanner while you have probes under your control.','',''),('ScoopObjectGone','notify','%(target)s is no longer there.','',''),('ScrapHeapAdd','notify','%(name)s put %(item)s onto the scrap heap.','res:/sound/ui/PrinterBeep02.wav',''),('ScrapHeapRemove','notify','%(name)s took %(item)s from the scrap heap.','res:/sound/ui/PrinterBeep02.wav',''),('SebiestorFemale','notify','Female Sebiestors are kind and considerate, but are notorious for their cruel streaks. Generally loveable, they\'re realistic enough to take the world only on face value.','',''),('SebiestorMale','notify','Sebiestor males are contemplative and curious, charming and passionate. They are great tinkerers, but they\'re inquisitive nature makes them ideal for any profession when they put their mind to it.','',''),('SecurityStatusAggressionChange','notify','For initiating combat your security status has been adjusted by %(penalty)0.4f.','res:/Sound/ui/voc/YourSecStat.ogg',''),('SecurityStatusAssistanceChange','notify','For assisting a criminal your security status has been adjusted by %(penalty)0.4f.','res:/sound/ui/voc/YourSecStat.ogg',''),('SecurityStatusKillChange','notify','For your part in the destruction of %(item)s your security status has been adjusted by %(penalty)0.4f.','',''),('SecurityStatusPodChange','notify','For participating in the podding of %(whom)s your security status has been adjusted by %(penalty)0.4f.','',''),('SecurityStatusPodKillChange','notify','For your part in the destruction of the escape pod of %(targetName)s your security status has been adjusted by %(penalty)0.4f.','res:/sound/ui/voc/YourSecStat.ogg',''),('SecurityStatusPoliceAggressionChange','notify','For initiating combat against an member of the CONCORD police force your security status has been adjusted by %(penalty)0.4f.','res:/sound/ui/voc/YourSecStat.ogg',''),('SecurityStatusPoliceKillChange','notify','For your part in the destruction of a member of the CONCORD police force your security status has been adjusted by %(penalty)0.4f.','res:/sound/ui/voc/YourSecStat.ogg',''),('SelectCharacter','info','Select Character::Please select a character.','res:/sound/ui/error07.wav',''),('SelectCharToRemove','info','Select the character you want to remove.','res:/sound/ui/error07.wav',''),('SelectCommandFromLeft','info','Information::Select command from the list to the left','',''),('SelectCommandFromRight','info','Information::Select command from the list to the right','',''),('SelectDockTarget','notify','Please select something to dock with.','res:/sound/ui/GlassyBeep18.wav',''),('SelectItemFirst','info','Select an item first.','res:/sound/ui/error07.wav',''),('SelectItemToApproach','notify','Please select something to approach','res:/sound/ui/GlassyBeep18.wav',''),('SelectWalletDivision','question','Select Wallet Division::You do not have a corporation wallet division selected. You will not be able to engage in any corporation related transactions without a current wallet division. You can always change your corporation wallet division by clicking \"Change\" in the Corporation Wallet tab.\n<br>\n<br>\nWould you like to select a corporation wallet division now (you will not be asked again)?','',''),('SelfDestructAborted','notify','You have aborted the self-destruct of your %(what)s which was scheduled to explode in %(when)s seconds.','',''),('SelfDestructAborted2','notify','You have aborted the self-destruct of your ship which was scheduled to explode in %(when)s seconds.','',''),('SelfDestructAbortedOther','notify','%(who)s has aborted the self-destruct of their %(what)s which was scheduled to explode in %(when)s seconds.','',''),('SelfDestructAbortedOther2','notify','%(who)s has aborted the self-destruct of their ship which was scheduled to explode in %(when)s seconds.','',''),('SelfDestructCancelledWarp','hint','Self destruction of your %(what)s has been canceled because its warp drive is active.','',''),('SelfDestructImmediate','notify','Your %(what)s self-destructs.','',''),('SelfDestructImmediateOther','notify','%(what)s belonging to %(who)s self-destructs.','',''),('SelfDestructInitiated','notify','You have initiated the self-destruct of your %(what)s.  It will self-destruct in %(when)s seconds.','',''),('SelfDestructInitiatedOther','notify','%(who)s has initiated self-destruct of their %(what)s, it will explode in %(when)s seconds.','',''),('SelfDestructTimer','notify','<color=0xFFFF0000>Your %(what)s will self-destruct in <b>%(time)s</b>','',''),('SelfDestructTooEarly','notify','You cannot self-destruct your %(what)s because your systems require %(when)s seconds more to recover from the last attempt.','',''),('SelHardpoints','audio','','res:/sound/ui/NavSel.wav',''),('SelHull','audio','','res:/sound/ui/NavSel.wav',''),('SelModule','audio','','res:/sound/ui/NavSel.wav',''),('SelSystems','audio','','res:/sound/ui/NavSel.wav',''),('SentryGunAlreadyAssembled','notify','You cannot assemble that sentry gun as it has already been assembled.','',''),('SentryGunNotAssemblableThere','notify','To be able to assemble that sentry gun it needs to be located in your personal hangar or your corporation\'s hangar.','',''),('ServerDPLimitReached','info','The max limit of %(limit)s DirectPlay connections has been reached.<br>Try selecting TCP/IP','',''),('ServerLimitReached','info','Maximum of %(limit)s simultaneous connection requests currently being handled.<br>Please try again after a while.','',''),('ServerMessage','info','%(msg)s','',''),('ServerNotAccepting','info','The server is not accepting incoming connections at this moment','',''),('ServerTCPLimitReached','info','The max limit of %(limit)s TCP/IP connections has been reached.<br>Try selecting DirectPlay','',''),('SessionDump','info','Session Dump::%(dump)s','',''),('SetNameInvalid','notify','You can\'t rename that type of object.','',''),('SetNameNotYourStuff','notify','You can\'t rename objects that you do not have access to.','',''),('SetNameObjectMustBeAnchoredInSpace','notify','You can only rename this type of object if it is anchored in space (and you have a right to do so).','',''),('SetNameShipMustBePilot','notify','You can only rename ships that you are currently piloting.','',''),('ShipAlreadyAssembled','notify','You can only assemble ships that are packaged. This %(type)s has already been assembled.','',''),('ShipAlreadyHasPilot','info','Ship Occupied::This ship already has a pilot.','',''),('ShipCargoOverloaded','notify','You cannot do that because you have somehow overloaded your cargo hold.','',''),('ShipCargoOverloaded2','notify','You cannot do that because you have somehow overloaded your cargo hold.  It fits %(canHave)0.2f units but somehow %(have)0.2f has been squeezed in.','',''),('ShipCloaked','notify','You cannot do that while cloaked.','',''),('ShipContrabandWarningJump','question','Stargate Jump Confirmation:s:Your ship is carrying at least one item (%(item)s was found) which is contraband in this solarsystem, are you sure you wish to jump?','',''),('ShipContrabandWarningUndock','question','Undock Confirmation:s:Your ship is carrying at least one item (%(item)s was found) which is contraband somewhere. Are you sure you wish to undock?','',''),('ShipDocking','notify','You cannot do that while docking.','',''),('ShipDocking2','notify','You cannot do that while your ship is docking.','',''),('ShipDronesOverloaded','notify','You cannot do that because you have somehow overloaded your drone bay.','',''),('ShipDronesOverloaded2','notify','You cannot do that because you have somehow overloaded your drone bay.  It fits %(canHave)0.2f units but somehow %(have)0.2f has been squeezed in.','',''),('ShipEjectFailedSystemsOccupied','notify','You cannot eject at this time.  Certain modules prevent the ejection systems of your ship from working.  Please deactivate these modules: %(types)s.','',''),('ShipExploded','info','Ship Destroyed:s:Your ship has been destroyed by %(doer)s.','',''),('ShipExploding','notify','Ship is out of control','',''),('ShipFrozen','notify','You cannot do much at the moment as %(actor)s (hopefully a GM) has frozen you.','',''),('ShipFrozenByYou','notify','You freeze %(victim)s into some kind of stasis where he is not allowed to do much so that he can get the GM experience you know he wants even if he doesn\'t.','',''),('ShipHasExtraModulesFitted','info','You have fitted non-standard modules to the ship.','',''),('ShipHasSkillPrerequisites','info','Operation of %(itemName)s requires the skills %(requiredSkills)s.','',''),('ShipInTransit','notify','Your ship is currently in transit and you cannot do that at this time.','',''),('ShipInvolvedInPoliceCrime','notify','That ship, or its owner, are currently engaged with local police forces.  CONCORD prohibits you from boarding it until the engagement is over.','',''),('ShipInWarp','notify','You cannot do that while warping.','',''),('ShipJumping','notify','Can\'t navigate while jumping','',''),('ShipJumping2','notify','You cannot do that while your ship is engaging in a stargate jump.','',''),('ShipMissingItemToSell','info','You have taken %(item)s off the %(otheritem)s before trying to sell it.','',''),('ShipNameInvalid','info','Invalid ship name: \'%(shipname)s\'.','',''),('ShipNotBoardable','notify','Only ships at boarding gates can be boarded.','',''),('ShipNotHere','notify','That ship isn\'t here','',''),('ShipNotInHangar','error','Your ship is stuck, having a corrupt invItem.flag field.  Sorry, mate','',''),('ShipNotYours','info','Wrong Key::You don\'t seem to have the right keys for the ship\'s ignition switch.  Perhaps you left them in your other jacket?','',''),('ShipTooDamagedToBoard','notify','That ship is too damaged to board.  Somehow it is still holding together though.','',''),('ShipTooDamagedToUndock','notify','The ship you are piloting is too damaged to be handled in space.  You do not have the skill to manage it in its current state.','',''),('ShipUndocking','notify','Can\'t navigate while undocking','',''),('ShipUnFrozenByYou','notify','You unfreeze %(victim)s.','',''),('ShortcutLocked','info','Information::You can not change this shortcut','',''),('ShotMiss','notify','Shot missed target','',''),('ShpCanOnlyCarryPackagedContainers','notify','The cargo of this class of ship can only carry a container of this type if it is packaged.','',''),('ShpCantAssembleInsideShip','info','Containers cannot be assembled inside a ship.','res:/Sound/ui/voc/ShipCantAssembleInsideShi.ogg',''),('ShpCantLoot','info','Cannot Access Container::Because of restrictions on the ship\'s cargo access hatch, it cannot access containers in space except under the following conditions.<br><br>\nGeneral Freight Containers and Freighter Wrecks in space are accessible.<br>\nIf the ship is close to an online Control Tower or an outpost platform all cargo transfer operations are available.','',''),('ShpCantUseCargoInSpace','notify','The cargo of this class of ship can only be moved while docked at hangar or close to an online Control Tower.','',''),('ShpCantUseCargoInSpaceJettison','notify','A ship of this type doesn\'t have a jettison tube.','',''),('ShpJettisonPending','notify','A new cargo container is being moved into the jettison duct. It will be ready in %(eta)s.','',''),('ShpScoopSecureCC','notify','This is a secure container and will detonate upon scooping unless disarmed with a password.','',''),('SkillHasPrerequisites','info','To learn that skill requires having already learned the following skills: %(requiredSkills)s.','',''),('SkillPrerequisitesForAnchoring','notify','Skill Required::You do not have the required skills to do that. To anchor that item requires having learned the following skills: %(requiredSkills)s.','',''),('SkillPrerequisitesForLaunching','notify','Skill Required::You do not have the required skills to do that. To launch that item requires having learned the following skills: %(requiredSkills)s.','',''),('SkillPrerequisitesForUnanchoring','notify','Skill Required::You do not have the required skills to do that. To unanchor that item requires having learned the following skills: %(requiredSkills)s.','',''),('SkillRequired','info','Skill Required::You need to have the %(skillName)s skill at the necessary level.','res:/sound/ui/error07.wav',''),('SkillTrained','notify','Training of the skill %(name)s lvl %(lvl)s has been completed.','res:/Sound/ui/voc/SkillTrained.ogg',''),('SlashError','notify','Slash error: %(reason)s','',''),('SlotAlreadyChanging','notify','There is already something being added to or removed from that location.  Please wait until it has finished before trying again.','',''),('SlotAlreadyOccupied','notify','There is already something in that location.','res:/Sound/ui/voc/SlotAlreadyOccupied.ogg',''),('SlotNotPresent','notify','The %(ship)s does not have that fitting slot.','',''),('SlotOccupied','info','Factory Slot Occupied::The factory slot requested is currently occupied.','',''),('SlowDown','audio','','res:/sound/ui/info.wav',''),('SmartBombFailsDueToInterference','notify','Your %(item)s deactivates due to interference from a station,  stargate or acceleration gate which falls within %(distance)s m.','',''),('SomethingHorribleHappened','fatal','Something horrible has happened to your character.  It has repeatedly failed loading on our servers.  Please file a petition.<br>Apologies for the inconvenience...<br>The Eve DEV Team.','',''),('SpeedChange','notify','Desired Speed Altered.','res:/sound/ui/info.wav',''),('SpeedUp','audio','','res:/sound/ui/info.wav',''),('SpeedZero','notify','The ship has stopped.','res:/Sound/ui/voc/SpeedZero.ogg',''),('SplashAggression','notify','You have initiated aggression against %(victim)s because of the damage your %(weapon)s did to them.','',''),('StaImprovementAlreadyPresent','notify','The improvement cannot be used as the station already has this improvment. ','',''),('StaImprovementRequiredAssemblyLineNotFound','notify','The station does not have the required assembly line type.','',''),('StaImprovementRequiredImprovementNotFound','notify','The improvement platform cannot be installed as the required improvment is not present.','',''),('StaImprovementsInvalidPlatformType','notify','The improvement platform that you are attempting to use cannot be used to improve a station.','',''),('StaImprovementsRequiredUpgradeLevelNotSatisfied','notify','The improvement platform cannot be installed as the station has not been upgraded enough.','',''),('StaImprovementWrongRace','notify','The improvement platform cannot be installed as it is incompatible with the station.','',''),('StandingsConfirmReset','question','Really reset standings?:s:Are you sure you want to reset the standings from you to <b>%(who)s</b>?','',''),('StandingsConfirmResetCorp','question','Really reset standings?:s:Are you sure you want to reset the standings from your corporation to <b>%(who)s</b>?','',''),('StartDragItem','audio','','res:/sound/ui/phony.wav',''),('StaServiceNoneOperationalCloning','notify','The station has been damaged to such an extent that the Cloning service has been disabled.','',''),('StaServiceNoneOperationalFitting','notify','The station has been damaged to such an extent that the Fitting service has been disabled.','',''),('StaServiceNoneOperationalRepair','notify','The station has been damaged to such an extent that the Repair service has been disabled.','',''),('StaServiceNoneOperationalReprocessing','notify','The station has been damaged to such an extent that the Reprocessing service has been disabled.','',''),('StaServiceNoneOperationalScienceAndIndustry','notify','The station has been damaged to such an extent that the Science And Industry service has been disabled.','',''),('StationConquered','notify','The station %(what)s has been captured by %(who)s corporation!','',''),('StationMgtStartupInfo1','info','Information::You do not have the role Station Manager, so you can\'t do station management.','',''),('StationMgtStartupInfo2','info','Information::You have to be located at a station which you corporation owns to be able to manage it.','',''),('StationMgtStartupInfo3','info','Information::Your corporation does not own this station, so you can\'t manage it.','',''),('StaUpgradesCannotDownGradeStation','notify','The upgrade platform cannot be installed as the station has already been upgraded to the level that the platform gives.','',''),('StaUpgradesInvalidPlatformType','notify','The upgrade platform that you are attempting to use cannot be used to upgrade a station.','',''),('StaUpgradesRequiredUpgradeLevelNotSatisfied','notify','The upgrade platform cannot be installed as the station has not been upgraded enough.','',''),('StaWrongCorpRoleToSetStanding','info','Insufficient Priviledges::You do not have sufficient priviledges to set %(corp)s\'s standings.','',''),('storageHeader','audio','','res:/sound/ui/uihstortxt.wav',''),('StructureNotControllable','notify','You cannot assume control of a %(item)s.','',''),('StructureNotControllableDistant','notify','You are unable to assume control of the %(item)s as you need to be within %(limit)d meters of the control tower to do so and you are %(actual)d meters away.','',''),('StructureNotControllableOffline','notify','You cannot assume control of the %(item)s while it is offline.','',''),('SubmitToBiomassQueueConfirm','info','%(charname)s can be terminated after %(time)s','',''),('SurveyScanResults','notify','Scanned %(count)s asteroids.','',''),('Swoosh250','audio','','res:/sound/ui/SwooshUp08.wav',''),('SwooshDown','audio','','res:/sound/ui/SwooshDown08.wav',''),('SwooshUp','audio','','res:/sound/ui/SwooshUp09.wav',''),('SystemCheck_JumpFailedAtSource_Loading','notify','%(system)s is currently loading.  Bizzarre, seeing that you\'re there already...  Please try again in a minute or two.','',''),('SystemCheck_JumpFailedAtSource_Locked','notify','The stargates in %(system)s are currently experiencing minor technical difficulties.  Please try again in a moment.','',''),('SystemCheck_JumpFailedAtSource_Stuck','info','Jump Prohibited::Officials have closed the stargates in %(system)s due to heavy congestion.  Travellers are advised to enjoy the local scenery.','',''),('SystemCheck_JumpFailed_Full','info','Jump Prohibited::Officials have closed the stargates in %(system)s due to heavy congestion.  Travellers are advised to seek alternate routes.','',''),('SystemCheck_JumpFailed_Loading','notify','%(system)s Traffic Control is currently offline and unable to process your jump request.  Please try again in a moment.','',''),('SystemCheck_JumpFailed_Locked','notify','%(system)s Traffic Control is currently experiencing heavy load and is unable to process your request.  Please try again in a moment.','',''),('SystemCheck_JumpFailed_Queued','notify','%(system)s Traffic Control is currently experiencing heavy load and is unable to process your request.  You are #%(position)d in queue for jump-in.','',''),('SystemCheck_JumpFailed_Stuck','info','Jump Prohibited::Officials have closed the stargates in %(system)s due to heavy congestion.  Travellers are advised to seek alternate routes.','',''),('SystemCheck_SelectFailed_Full','hint','Solar system is full. Please try a different try again later or try a different route','',''),('SystemCheck_SelectFailed_Loading','info','Character Selection Failed::Your character is located within %(system)s, which is currently loading.  Please try again in a moment.','',''),('SystemCheck_SelectFailed_Locked','info','Character Selection Failed::Your character is located within %(system)s, which is currently experiencing heavy load.  Please try again in a moment.','',''),('SystemCheck_SelectFailed_Queued','info','Character Selection Failed::Your character is located within %(system)s, which has reached maximum capacity.  You are #%(position)d in queue for entrance.  Please try again in a moment.','',''),('SystemCheck_SelectFailed_Stuck','info','Character Selection Failed::Your character is located within %(system)s, which is currently stuck.  Please select a different character or try later.','',''),('SystemCheck_TransferFailed_Loading','info','Character Transfer Failed::The character is located within %(system)s, which is currently loading.  Please try again in a moment.','',''),('SystemCheck_TransferFailed_Locked','info','Character Transfer Failed::The character is located within %(system)s, which is currently experiencing heavy load.  Please try again in a moment.','',''),('SystemCheck_TransferFailed_Stuck','info','Character Transfer Failed::The character is located within %(system)s, which is currently stuck.  Please try again later.','',''),('SystemCheck_UndockFailed_Loading','info','Undock Delayed::%(system)s Traffic Control is currently offline and unable to process your undocking request.  Please try again in a moment.','',''),('SystemCheck_UndockFailed_Locked','info','Undock Delayed::%(system)s Traffic Control is currently experiencing heavy load and was unable to process your request.  Please try again in a moment.','',''),('SystemCheck_UndockFailed_Stuck','info','Undock Prohibited::Officials have closed the undocking ramps in %(system)s due to heavy congestion.  Please try again later.','',''),('SystemStuck','notify','Traffic Advisory:  Officials have closed the stargates and undocking ramps in %(system)s due to heavy congestion.  Travellers are advised to seek alternate routes.','',''),('TargetByOther','notify','','',''),('TargetCantValidate','notify','Targeting attempt failed as the designated object is no longer present.','',''),('TargetElectronicsScanStrengthsIncompatible','notify','Unable to modify the scan strengths of the target because one or more is higher than your own preventing the process.','res:/Sound/ui/voc/TrgtElcrtncsScnStrngthInc.ogg',''),('TargetExploding','notify','%(modulename)s deactivates as %(targetname)s begins to explode.','',''),('Targeting','notify','%(name)s targeted','res:/sound/ui/PrinterBeep02.wav','res:/ui/icon/misc/targeting.blue'),('TargetingAptitudeAlreadyFullyUtilized','notify','You are already managing %(limit)d targets, as many as you have skill to.','',''),('TargetingMissileToSelf','notify','It is not a good idea to shoot a missile at yourself. Code %(shipID)s %(targetID)s.','',''),('TargetingSystemsAlreadyFullyUtilized','notify','You are already managing %(limit)d targets, as many as your ship\'s electronics are capable of.','',''),('TargetingSystemsBeingJammed','notify','Unable to target %(targetname)s as your targeting systems are currently being jammed.','',''),('TargetingSystemsNotInstalled','notify','The ship you are piloting does not have targeting systems installed.','',''),('TargetJammedBy','notify','%(jammer)s has started trying to target jam you.','',''),('TargetJammedOtherBy','notify','%(jammer)s has started trying to target jam %(jammed)s.','',''),('TargetJammedSuccess','notify','You have started trying to target jam %(jammed)s.','',''),('TargetJammingFullSuccess','info','Your %(moduleName)s managed to jam all of the objects targeting you: %(jammedNames)s.','',''),('TargetJammingPartialSuccess','info','Of the %(targeterCount)d objects targeting you, your %(moduleName)s jammed these: %(jammedNames)s.','',''),('TargetJammingWithoutTargeters','info','As nothing is targeting you at this time, your %(moduleName)s failed to jam anything.','',''),('TargetLocked','audio','','res:/sound/ui/TargetLocked.wav',''),('TargetLocking','audio','','res:/sound/ui/TargetLockingLoop.wav',''),('TargetLost','notify','Target is lost','res:/Sound/ui/voc/TargetLost.ogg',''),('TargetLostNotWithinRange','notify','The %(targetGroupName)s is too far away, you need to be within %(desiredRange)s meters of it but are actually %(actualDistance)s meters away.','',''),('TargetNoLongerPresent','notify','%(moduleName)s deactivates as the %(targetTypeName)s it was targeted at is no longer present.','',''),('TargetNotLocked','notify','%(modulename)s deactivates because its target, %(targetname)s, is not locked.','',''),('TargetNotShip','info','The target is not a ship.','',''),('TargetNotWithinRange','notify','The %(targetGroupName)s is too far away, you need to be within %(desiredRange)0.0f meters of it but are actually %(actualDistance)0.0f meters away.','',''),('TargetObscured','notify','No line of sight to %(name)s.','',''),('TargetOutOfRangeFar','notify','%(targetname)s is too far away to target.','',''),('TargetTooFar','notify','%(targetname)s is too far away to use your %(modulename)s on, it needs to be closer than %(distance)s meters.','',''),('TestEWEffects','notify','DEBUG: %(item)s ran with %(data)s.','',''),('TestMissileVelocity','notify','Missile of type \'%(item)s\' collided with its target at velocity %(velocity)d, the targets directional velocity is %(dvs)d.','',''),('TestMissileVelocity2','notify','Missile of type \'%(item)s\' collided with its target at velocity %(velocity)d, the targets directional velocity is %(dvs)d. Extra: %(xtra)s.','',''),('text','audio','','res:/sound/ui/TextSound.wav',''),('TextSound','notify','','res:/sound/ui/TextSound.wav',''),('TheFactorySlotIsNotYoursToUse','info','Access Denied::You cannot install a blueprint into a slot that you are not renting.','',''),('TheItemIsJunked','notify','There is no such item.','',''),('TheItemIsNotYoursToTake','notify','The item %(item)s is not yours to take','',''),('ThreatAdd','audio','','res:/sound/ui/ui03.wav',''),('TooBroke','notify','You\'re too broke. You only have %(avail)s ISK but you need %(need)s ISK to create this mission.','',''),('ToolRequirements','notify','You cannot do that.  The module you use on the %(tGroup)s needs to have the following in its skill requirements: %(skills)s.','',''),('TooManyChargesForLauncher','notify','The launcher is currently holding %(excess)f too many excess units.','',''),('TooManyHiSlotsFittedUndock','hint','You cannot undock because your ship has too many hi power slots fitted, it has space for %(have)s modules but there are %(are)s present. <br><br>You need to unfit the excess modules to make your ship flightworthy.','',''),('TooManyLaunchersFittedUndock','info','You cannot undock because your ship has too many launchers fitted, it has space for %(have)s launchers but there are %(are)s present.   <br><br>You need to unfit the excess modules to make your ship flightworthy.','',''),('TooManyLowSlotsFittedUndock','hint','You cannot undock because your ship has too many low power slots fitted, it has space for %(have)s modules but there are %(are)s present. <br><br>You need to unfit the excess modules to make your ship flightworthy.','',''),('TooManyMedSlotsFittedUndock','hint','You cannot undock because your ship has too many med power slots fitted, it has space for %(have)s modules but there are %(are)s present. <br><br>You need to unfit the excess modules to make your ship flightworthy.','',''),('TooManyPassengers','notify','The ship doesn\'t support more passengers.','',''),('TooManyTurretsFittedUndock','info','You cannot undock because your ship has too many turrets fitted, it has space for %(have)s turrets but there are %(are)s present. <br><br>You need to unfit the excess modules to make your ship flightworthy.','',''),('TooManyUpgradesFittedUndock','info','You cannot undock because your ship has too many upgrades fitted, it has space for %(have)s upgrades but there are %(are)s present. <br><br>You need to unfit the excess upgrades to make your ship flightworthy.','',''),('TooMuchCpuUsedUndock','info','CPU::Somehow your ship has come to be consuming more cpu than it has available. Your ship has %(total)0.1f cpu units total, but your online modules are requiring %(require)0.1f cpu units. Please offline enough modules to rectify this situation.','',''),('TooMuchPowerUsageUndock','info','Power Core::For a ship to be in a condition suitable for undocking requires that there are no modules fitted which require more power than the ship can provide, whether they are online or not.  For your safety we limit the amount of power potentially usable by all online or offline modules on your ship to double the total power output of your ship.<br><br>Double the total power output of your ship is only %(total)0.1f but your modules require %(require)0.1f power units. Please unfit enough modules to rectify this situation.','',''),('TooMuchPowerUsedUndock','info','Power Grid::Somehow your ship has come to be consuming more power than it has available.  Your ship has %(total)0.1f power units total, but your online modules are requiring %(require)0.1f power units.  Please offline enough modules to rectify this situation.','',''),('TooShortWarpDistance','notify','Warp destination too close. Must be at least %(mindist)s kilometers.','',''),('TradeCancel','notify','Trade with %(name)s cancelled.','',''),('TradeCancelled','info','Trade session with %(name)s was cancelled.','',''),('TradeComplete','notify','Trade with %(name)s completed.','',''),('TradeShipWarning','question','Trading ship warning:s:You are receiving a ship through this trade session. Keep in mind that even though you may have been told otherwise, this ship <b>does not necessarily contain any modules or rigs</b>.<br><br>\nIf you want to be safe you should accept the ship through an Item Exchange contract instead.\n<br><br>Are you sure you want to continue?','',''),('TrainMoreTheOne','info','Information::You can only train one skill at time, please select the skill you want to train','',''),('transportHeader','audio','','res:/sound/ui/uihtranstxt.wav',''),('TrialAccountRestriction','info','Trial account restriction::The following action can not be made on a trial account:<br>\n%(what)s<br>\n<br>\nBy registering your account, all trial account restrictions will be lifted.\n','',''),('Trigger','audio','','',''),('TrustedSitesHelpOff','info','Untrusted Site::The site you are viewing has requested access to personal data from you (such as your name, location, corporation, and corp role) but such access has NOT been granted by you.<br><br>You can edit the list of sites that have these privileges by clicking in the \'Trusted Sites\' entry under the \'Options\' menu in the browser.<br><br>If you have chosen to ignore further requests from this site, but you have changed your mind, you can edit the list of ignored sites in the option \'Ignored Sites\' in the same menu, then reload this page to receive a new request for trust.','',''),('TrustedSitesHelpOn','info','Trusted Site::The site you are viewing has access to personal data from you, such as your name, location, corporation, and corp role.<br><br>This is so because you have chosen to allow such access at some point. You can edit the list of sites that have these privileges by clicking in the \'Trusted Sites\' entry under the \'Options\' menu in the browser.','',''),('TryNewName','question','Try for new name?::%(question)s','',''),('TurretJammedBy','notify','%(jammer)s has started trying to disrupt your turret tracking speed','',''),('TurretJammedOtherBy','notify','%(jammer)s has started trying to disrupt the turret tracking speed of %(jammed)s.','',''),('TurretJammedSuccess','notify','You have started trying to disrupt the turret tracking speed of %(jammed)s.','',''),('TutNoCapsules','info','No Capsules Allowed::Making your way to the tutorial dungeon requires you be warped there, and capsules just aren\'t fitted with the systems required for this to happen.  Get a real ship and then try again.','',''),('TutNotStartingSystem','info','Unsuitable Location::The tutorial dungeons are only available in starting solar systems.  Return to the solar system you entered the game into and try again there.','',''),('TutorialContinueLater','question','Continue later?::You are about to leave the tutorial. You can restart the tutorial through the Aura button on your Neocom. Do you wish to continue later?','',''),('TutorialNotDoneYet','info','You can not jump forward to this part of the %(sequencename)s before you have gone through it once normally.','',''),('TutorialWarpToQuestion','question','Warp to Tutorial Location?:s:You will be warped to the tutorial, do you wish to proceed? Canceling will close the tutorial.','',''),('TutorialWarpWarning','question','Abort tutorial by warping:s:If you warp now, the tutorial will abort and close itself.','',''),('TutTooExperienced','info','Too Experienced::Only rookies get the opportunity to do the tutorial dungeon.  With your skill and experience you no longer qualify as a rookie, it\'s time to move on!','',''),('TutYouAreNotInANewbieSystem','info','Wrong Location::You are not in a rookie system, go to any of the following solar systems to run this tutorial: <a href=\"showinfo:5//30000141\">Kisogo</a>, <a href=\"showinfo:5//30001392\">Amsen</a>, <a href=\"showinfo:5//30001407\">Todaki</a>, <a href=\"showinfo:5//30001672\">Emrayur</a>, <a href=\"showinfo:5//30002505\">Hulm</a>, <a href=\"showinfo:5//30002547\">Ammold</a>, <a href=\"showinfo:5//30002715\">Bourynes</a>, <a href=\"showinfo:5//30003410\">Ryddinjorn</a>, <a href=\"showinfo:5//30003489\">Chaven</a>, <a href=\"showinfo:5//30004971\">Duripant</a>, <a href=\"showinfo:5//30005042\">Sehmy</a>, <a href=\"showinfo:5//30005305\">Cistuvaert</a>,\n','',''),('Txt','','%(text)s','',''),('TxtSuppress1','','Do not show this message again.','',''),('TxtSuppress2','','Do not ask me again.','',''),('TypeDataNotAvailable','notify','Detailed info not available for %(typeName)s.','',''),('uiwarning01','audio','','res:/sound/ui/uiwarning01.wav',''),('uiwarning03','audio','','res:/sound/ui/uiwarning03.wav',''),('UI_LOAD_PATCHAPPLIEDRESTART','notify','The client needs to be restarted since a code patch was just applied. ','',''),('UI_SYSMENU_TALKDEVICE','notify','Audio Input/Output Device','',''),('UnableToConnectToServer','info','Unable to Connect::Unable to connect to the selected server. Please check the address and try again.','',''),('UnableToTarget','info','Unable to target; the object is too distant.','',''),('UnanchoringObject','notify','Unanchoring the selected object, it will take around %(delay)0.1f seconds to do so.','',''),('UndefinedItem','info','You have to select an item that you want to be transported.','',''),('UndefinedLocation','info','You have to select the location where you want the item to be returned to.','',''),('UndockCriminalConfirm','warning','You are a criminal!::Warning! You are currently flagged for your criminal actions and you are about to enter an area with police officers who are on the look out for you. If you continue they will use all means necessary to kill you and the station will probably not let you back in.<br><br>\nAre you sure you want to continue?','',''),('UnexpectedLackOfLauncher','notify','You cannot do that. There is no launcher in that slot to launch that with.','',''),('UnknownActivity','info','Unknown Activity::The operation can not be completed as the selected activity is either unknown or unsupported at this point in time.','',''),('UnknownKey','info','Unknown key::Unknown key: %(key)s','',''),('UnMachoDestination','info','Invalid Packet Destination::%(what)s','',''),('UserAlreadyHasSkillInTraining','info','It seems that another character owned by this account, %(charName)s, is training the skill %(skillName)s.  Only one character can train a skill per account.  To rectify this, exit the game, log on to %(charName)s, and stop training the skill.','',''),('UserMaxChars','notify','User can only have 3 characters.','',''),('VelocityTooHighToActivate','hint','Your velocity is too high to activate %(moduleName)s. You\'re traveling at %(yourVelocity)s m/s but you need to lower your speed below %(velocityLimit)s m/s.','',''),('VersionMismatch','info','Invalid client version. Server version is %(srv)s but client version is %(cli)s.  Try launching EVE again in order to run the auto-patch program.','',''),('VivoxError10','info','Vivox Voice::Could not contact the UDP Port 3478 Server.','',''),('VivoxError14','info','Vivox Voice::Cannot connect to the echo server.','',''),('VivoxError3','info','Vivox Voice::The network with the best route to the internet does not have a gateway configured.\n','',''),('VivoxError31','info','Vivox Voice::No UDP or TCP reply received from Echo Server.','',''),('VivoxError32','info','Vivox Voice::No UDP reply received for Echo Server.','',''),('VivoxError33','info','Vivox Voice::No TCP reply received for Echo Server.','',''),('VivoxError35','info','Vivox Voice::UDP Data was changed on return from the Echo Server.','',''),('VivoxError36','info','Vivox Voice::UDP Data was changed on return from the Echo Server.','',''),('VivoxError37','info','Vivox Voice::UDP Data was changed en route to the Echo Server.','',''),('VivoxError39','info','Vivox Voice::Login to Echo Server timed out.','',''),('VivoxError4','info','Vivox Voice::The computer does not have a route to the Internet. \n','',''),('VivoxError42','info','Vivox Voice::Unable to resolve Echo Server name.','',''),('VivoxError5','info','Vivox Voice::The computer was able to ping the gateway address.\n','',''),('VivoxError7','info','Vivox Voice::Could not resolve the UDP Port 3478 Server Name.','',''),('VivoxError8','info','Vivox Voice::Could not resolve multiple server names.\n','',''),('VoiceConfirmEcho','question','Leave all voice channels?::To use the echo channel you have to leave all other active voice channels, do you wish to proceed?','',''),('VoiceError38','notify','Vivox Voice::UDP Data was changed en route to the Echo Server.','',''),('VoiceNotEnabled','info','Eve Voice not enabled::Eve Voice was not successfully initialized, please take a look at our <a href=shellexec:http://support.eve-online.com/Pages/KB/Browse.aspx?categoryID=78&language=EN>Knowledge base</a> for possible solutions.','',''),('VoiceNotEnabledInSettings','info','Eve Voice not enabled::Eve Voice is not enabled in your settings.<br> To enjoy the benefits of speaking to your buddies in Eve you should go to the audio settings and enable Eve voice.','',''),('WarDeclareConfirm','warning','Declare War!::Your %(corporalliance)s is declaring war against <b>%(against)s</b>.<br>\nWar declaration price depends upon the number of non-mutual wars declared against the victim or non-mutual wars declared by you.<br>\nYour %(corporalliance)s will be sent weekly bills for keeping the war declaration in effect which are also based on the factors above.<br><br>\nThe initial payment for starting this war will be <b>%(price)s</b>.<br><br>\nWould you like to continue?','',''),('WarnDeleteFromAddressbook','warning','Delete completely?:s:If you proceed with this action %(name)s will be removed from all groups in your %(type)s. Do you want to do that?','',''),('warning','audio','','res:/sound/ui/HardBeep03.wav',''),('WarpDestinationGone','notify','Problems with locking onto warp destination. It might have vanished.','',''),('WarpDisrupted','notify','You are within a warp disruption zone. Get %(range)s meters from %(object)s to warp.','',''),('WarpDriveActive','audio','','res:/Sound/ui/voc/WarpDriveActive.ogg',''),('WarpingWithAvailablePower','warning','There is insufficient power to warp all the way to the target, proceeding to warp as far as power permits.','res:/Sound/ui/voc/WarpingWithAvailablePower.ogg',''),('WarpingWithinGlobalDisruptors','notify','You cannot warp there because natural phenomena are disrupting the warp.','res:/Sound/ui/voc/WarpingWithinGlobalDisrup.ogg',''),('WarpScrambled','notify','External factors are preventing your warp drive from responding to this command.','',''),('WarpScrambledBy','notify','%(scrambler)s has started trying to warp scramble you!','',''),('WarpScrambledByWarpDisruptionFieldGenerator','notify','You are within a warp disruption zone. Get %(range)s meters from %(pilot)s\'s %(ship)s to warp.','',''),('WarpScrambledOtherBy','notify','%(scrambler)s has started trying to warp scramble \"%(scrambled)s\"','',''),('WarpScrambledSuccess','notify','You have started trying to warp scramble %(scrambled)s.','',''),('WarpToStargateWhileFlagged','question','Proceed with this dangerous act?:s:You are warping to a stargate owned by %(owner)s whom you have recently engaged in combat.  Customs police are operating on a low tolerance policy and will attack you if they are present.<br><br>Do you wish to proceed with this dangerous action?','',''),('WaypointAlreadyInConstellation','notify','Can\'t set waypoint to the constellation you are already in','',''),('WaypointAlreadyInRegion','notify','Can\'t set waypoint to the region you are already in','',''),('WaypointAlreadyInSolarSystem','notify','Can\'t set waypoint to the solar system you are already in','',''),('WaypointAlreadySet','notify','Can\'t set waypoint to same location twice','res:/Sound/ui/voc/WaypSameTwice.ogg',''),('WaypointInAvoidanceListDisableAvoidance','question','System in Avoidance List::The system you are adding to waypoints, <b>%(system)s</b>, is in your autopilot avoidance list. You will need to disable all system avoidance to be able to set a path to this system.<br><br>\nWould you like to disable system avoidance and set this waypoint?','',''),('Welcome_Addressbook','windowhelp','People & Places Welcome Page:s:If you are searching for another capsuleer, a system or a corporation then you can use the search functionality here. You can also see your buddy list and your blocked list, a list of your agents and corporation members, and all the locations in space you might have bookmarked.','',''),('Welcome_Assets','windowhelp','Assets Welcome Page:s:All your ships and items throughout the universe can be viewed from within the assets window. Here you can see a categorized list of your items, on a station by station basis. You can also search for items you might have temporarily misplaced. Perhaps some treasure awaits you!','',''),('Welcome_Channels','windowhelp','Chat Channels & Mailing Lists Welcome Page:s:To facilitate easy communicaton with others, you can join various chat channels to discuss all aspects of space faring. Whether it\'s the locations of asteroids or enemy factions, or the latest alliance news, or stock tips, or just plain gossip, there\'s probably a channel out there for you - and if there\'s not, you can make your own! You also have access to mailing lists from here, which are good to keep in contact with specific groups of people when a chat channel just won\'t do the job.','',''),('Welcome_Charactersheet','windowhelp','Character Sheet Welcome Page:s:The character sheet is one of the most important tools in EVE. Here you select skills for training, write your biography, and check on your attributes, clones, standings, employment history and more. It is a valuable source of information on your character development and should not be overlooked.','',''),('Welcome_Contracts','windowhelp','Contracts Welcome Page:s:Some items might generate a better profit when sold through auction. Using the contract system, you can auction off your items, exchange them for other items directly, set up part-exchange deals... the contract system gives you the flexibility to choose the right kind of deal for the situation. Countless deals are closed every day, relying on the contract system\'s rules to prevent swindles and scams. If you have a rare item, others might be willing to fight for it in an auction!','',''),('Welcome_Corporation','windowhelp','Corporation Welcome Page:s:Here within you can find tools to manage your corporation, or to set one up. You can also find the corporate registry, which enables you to either quickly find a corporation for yourself, or to list your own corporation to others. You can also manage all roles to your members, manage wars and take care of alliance needs.','',''),('Welcome_Fitting','windowhelp','Fitting Welcome Page:s:Your ships need to be fitted with weapons, defensive modules, cargo expanders, mining lasers and other equipment to reach their full potential. The fittings window grants you access to the ship\'s hardware, where you can install your equipment and view statistics like resistances, cargo space and more.','',''),('Welcome_Inbox','windowhelp','EVE Mail Welcome Page:s:To stay in contact with your friends, you can use eve mails. These are handy and easy to use - your friend will receive it instantly, thanks to the wonders of fluid router technology. You\'ll also receive communications from all kinds of other entities through this interface, from insurance notifications to offers of work.','',''),('Welcome_Insurance','windowhelp','Insurance Welcome Page:s:If your ship is not insured, you should perhaps consider changing this! Insurance comes in several levels, to minimize your financial loss in case of the destruction of a ship. Be sure to check on your insurance regularly, as standard policies only last for 12 weeks - losing a ship whose insurance expired the previous week is rarely a happy event.','',''),('Welcome_Journal','windowhelp','Journal Welcome Page:s:Here within you can find information regarding your agent missions, your ongoing research as well as a list of all corporations that you have gained loyalty points with and how many. On this page you can find information related to the journal, tutorials, knowledgebase articles on how to operate and make best use of the journal.','','res:/tutorial2/img/FactionInfluence.png'),('Welcome_LPStore','windowhelp','Loyalty Point Store Welcome Page:s:While doing missions for agents, you might notice that you recieve loyalty points as additional payment for finishing the mission successfully. These points can be spent at the corresponding corporation\'s stations. Items vary between corporations and races, and scientists and technicians work hard on bringing new types of equipment to the store as soon as it is available.','',''),('Welcome_Manufacturing','windowhelp','Science & Industry Welcome Page:s:For all your scientific and industry related ventures! You can initiate, monitor and finalize all your manufacturing and researching tasks from within the confines of the science & industry window.','',''),('Welcome_Mapspalette','windowhelp','Map Welcome Page:s:The map can show both your current solar system, and the whole universe. It provides you with information and statistics, and acts as a tool for planning your route around your constellation, region or between regions.','',''),('Welcome_Market','windowhelp','Market Welcome Page:s:The market is a tool that nearly everyone accesses at on a daily basis. Whether it\'s to buy a new ship, acquire the latest in weapons technology or to trade countless other items with your fellow pilots. Here you can find it all, and here you can work the market to gain riches and fortune as a trader.','',''),('Welcome_Medical','windowhelp','Medical Welcome Page:s:It is imperative that you keep an up to date clone. In the event of your death, your body will be rematerialized at your selected station. If your clone doesn\'t support the skill points you have, you could lose some of them in the process. Always ensure that your clone can store more skillpoints than you currently have.','',''),('Welcome_Militia','windowhelp','Militia Welcome Page:s:This is the information hub for the war effort. In this panel you can enlist yourself or your corporation, and once enlisted access data and statistics about the war effort.<p>Individuals may enlist by leaving any current player corporations, ensuring their standing from this faction is above 0.5 and that they\'re not on a trial account; applications are processed immediately.<p>\nDirectors and CEOs may enlist their entire corporation by leaving any current alliance and ensuring their corporate standing from this faction is above 0.5; applications are processed at downtime<p><B>All enlisted players are in a state of permanent war with their enemies and may be attacked by enemy capsuleers at any time. They are also advised to avoid high security space (0.5 security and above) belonging to enemy factions, as those factions\' navies will shoot on sight</B><p>Enlisted players are empowered to take missions from agents in their Militia, and to assist in the capture of strategic locations. Missions are limited by ship type. Locations are exploration sites found using the onboard scanner, are limited by ship type and have proximity sensors on strategic capture sites that trigger a capturing timer<p>For further information on all aspects of the war, please visit the knowledgebase!','',''),('Welcome_Missions','windowhelp','Bounty Office Welcome Page:s:The bounty office holds information on all criminals in the galaxy. You can browse through the most wanted list and see if you spot any friends of yours or perhaps your most sworn enemy. You can also add a bounty to others if you so desire.','',''),('Welcome_Repairshop','windowhelp','Repairshop Welcome Page:s:Your ship can sustain damage in space and might need repairs. Stations often feature repairshops that can patch up your ships for a small fee.','',''),('Welcome_Reprocessing','windowhelp','Reprocessing Plant Welcome Page:s:Ore can be refined into minerals using the reprocessing plant. Each type of ore has its own particular makeup and refines into a unique combination of minerals. Skills can affect how well you refine, and standings from the owner of the station can also have an affect. You can also reprocess modules, ships and other items into their base mineral components.','',''),('Welcome_Wallet','windowhelp','Wallet Welcome Page:s:Your hard-earned ISK is stored in your wallet. It holds the balance sheet on your recent expenditures and earnings with detailed information on every entry. If you have access to the corporation wallet, here you can also look at similar information for your corporation.','',''),('WhatKindOfAmountIsThis','info','What Kind Of Amount Is This::The specifed amount: %(amount)s is of an unknown type.','',''),('WouldBeContraband','notify','You cannot take that because it belongs to %(owner)s.','',''),('YouCanNotSelectYourself','info','Bad Choice::You cannot select yourself.','',''),('YouHaveBeenGagged','info','You\'ve been gagged::You have been gagged by %(gagger)s until %(untilwhen)s.  %(gagger)s\'s reason was:  %(reason)s.','',''),('YouOweMarket','info','Not enough money::You do not have enough money to complete the requested market transaction.','',''),('YouOweStation','info','Bad Debts::Pay the following bills and then we might let you rent it.\n%(bills)s','','');

