/*
	------------------------------------------------------------------------------------
	LICENSE:
	------------------------------------------------------------------------------------
	This file is part of EVEmu: EVE Online Server Emulator
	Copyright 2006 - 2011 The EVEmu Team
	For the latest information visit http://evemu.org
	------------------------------------------------------------------------------------
	This program is free software; you can redistribute it and/or modify it under
	the terms of the GNU Lesser General Public License as published by the Free Software
	Foundation; either version 2 of the License, or (at your option) any later
	version.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
	FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place - Suite 330, Boston, MA 02111-1307, USA, or go to
	http://www.gnu.org/copyleft/lesser.txt.
	------------------------------------------------------------------------------------
	Author:		Aknor Jaden
*/

#ifndef EffectsEnum_h__
#define EffectsEnum_h__

enum EveEffectEnum {
    Effect_shieldBoosting = 4,
    Effect_speedBoost = 7,
    Effect_missileLaunching = 9,
    Effect_targetAttack = 10,
    Effect_loPower = 11,
    Effect_hiPower = 12,
    Effect_medPower = 13,
    Effect_online = 16,
    Effect_mining = 17,
    Effect_shieldTransfer = 18,
    Effect_shieldCapacityBonusOnline = 21,
    Effect_maxVelocityBonus = 22,
    Effect_capacitorCapacityBonus = 25,
    Effect_structureRepair = 26,
    Effect_armorRepair = 27,
    Effect_modifyTargetSpeed = 29,
    Effect_energyTransfer = 31,
    Effect_energyVampire = 32,
    Effect_projectileFired = 34,
    Effect_energyDestabilization = 36,
    Effect_empWave = 38,
    Effect_warpScramble = 39,
    Effect_launcherFitted = 40,
    Effect_turretFitted = 42,
    Effect_shipScan = 46,
    Effect_cargoScan = 47,
    Effect_powerBooster = 48,
    Effect_modifyShieldRechargeRate = 50,
    Effect_modifyPowerRechargeRate = 51,
    Effect_ecmBurst = 53,
    Effect_targetPassively = 54,
    Effect_targetHostiles = 55,
    Effect_powerOutputMultiply = 56,
    Effect_shieldCapacityMultiply = 57,
    Effect_capacitorCapacityMultiply = 58,
    Effect_cargoCapacityMultiply = 59,
    Effect_structureHPMultiply = 60,
    Effect_agilityBonus = 61,
    Effect_maxPassengersBonus = 62,
    Effect_armorHPMultiply = 63,
    Effect_miningLaser = 67,
    Effect_agilityMultiply = 70,
    Effect_repairCostMultiply = 73,
    Effect_surveyScan = 81,
    Effect_corporationMemberLimitBonus = 82,
    Effect_cpuUsageMultiply = 87,
    Effect_miningDurationMultiply = 88,
    Effect_projectileWeaponSpeedMultiply = 89,
    Effect_energyWeaponDamageMultiply = 91,
    Effect_projectileWeaponDamageMultiply = 92,
    Effect_hybridWeaponDamageMultiply = 93,
    Effect_energyWeaponSpeedMultiply = 95,
    Effect_hybridWeaponSpeedMultiply = 96,
    Effect_turretWeaponAccuracyMultiply = 97,
    Effect_hybridWeaponAccuracyMultiply = 100,
    Effect_useMissiles = 101,
    Effect_mineLaying = 102,
    Effect_defenderMissileLaunching = 103,
    Effect_fofMissileLaunching = 104,
    Effect_shieldResonanceMultiplyOnline = 105,
    Effect_miningAmountMultiply = 106,
    Effect_characterMissileDamageMultiply = 107,
    Effect_turretWeaponCapacitorNeedMultiply = 109,
    Effect_characterBlueprintResearchTimeBonus = 110,
    Effect_characterBlueprintManufactureTimeBonus = 111,
    Effect_characterCharismaSkillTrainingTimeBonus = 112,
    Effect_characterIntelligenceSkillTrainingTimeBonus = 113,
    Effect_characterMemorySkillTrainingTimeBonus = 114,
    Effect_characterPerceptionSkillTrainingTimeBonus = 115,
    Effect_characterWillpowerSkillTrainingTimeBonus = 116,
    Effect_electronicAttributeModifyOnline = 118,
    Effect_turretWeaponRangeTrackingSpeedMultiplyOnline = 120,
    Effect_turretWeaponRangeTrackingSpeedMultiplyActivate = 123,
    Effect_scanStrengthBonusTarget = 124,
    Effect_turretWeaponRangeTrackingSpeedMultiplyTarget = 126,
    Effect_torpedoLaunching = 127,
    Effect_cheatTeleDock = 130,
    Effect_cheatTeleGate = 131,
    Effect_skillEffect = 132,
    Effect_damageMultiplierSkillBonus = 146,
    Effect_skillBoostDamageMultiplierBonus = 152,
    Effect_largeHybridTurretDamageMultiplierBonusPostPercentDamageMultiplierLocationShipModulesRequiringLargeHybridTurret = 157,
    Effect_mediumEnergyTurretDamageMultiplierBonusPostPercentDamageMultiplierLocationShipModulesRequiringMediumEnergyTurret = 159,
    Effect_mediumHybridTurretDamageMultiplierBonusPostPercentDamageMultiplierLocationShipModulesRequiringMediumHybridTurret = 160,
    Effect_mediumProjectileTurretDamageMultiplierBonusPostPercentDamageMultiplierLocationShipModulesRequiringMediumProjectileTurret = 161,
    Effect_largeEnergyTurretDamageMultiplierBonusPostPercentDamageMultiplierLocationShipModulesRequiringLargeEnergyTurret = 162,
    Effect_rapidFiringSkillBoostRofBonus = 163,
    Effect_sharpshooterSkillBoostRangeSkillBonus = 167,
    Effect_smallEnergyTurretDamageMultiplierBonusPostPercentDamageMultiplierLocationShipModulesRequiringSmallEnergyTurret = 172,
    Effect_smallHybridTurretDamageMultiplierBonusPostPercentDamageMultiplierLocationShipModulesRequiringSmallHybridTurret = 173,
    Effect_smallProjectileTurretDamageMultiplierBonusPostPercentDamageMultiplierLocationShipModulesRequiringSmallProjectileTurret = 174,
    Effect_caldariCruiserSkillBoostCcTRangeBonus = 187,
    Effect_caldariFrigateSkillBoostCfTRangeBonus = 189,
    Effect_signatureAnalysisSkillBoostScanspeedBonus = 204,
    Effect_signatureAnalysisScanspeedBonusPostPercentScanSpeedLocationShip = 205,
    Effect_longRangeTargetingSkillBoostMaxTargetRangeBonus = 206,
    Effect_propulsionJammingSkillBoostDurationBonus = 208,
    Effect_propulsionJammingDurationBonusPostPercentDurationLocationShipModulesRequiringPropulsionJamming = 209,
    Effect_sensorLinkingDurationBonusPostPercentDurationLocationShipModulesRequiringSensorLinking = 210,
    Effect_sensorUpgradesSkillBoostCpuNeedBonus = 211,
    Effect_sensorUpgradesCpuNeedBonusPostPercentCpuLocationShipModulesRequiringSensorUpgrades = 212,
    Effect_targetingSkillBoostMaxTargetBonus = 213,
    Effect_targetingMaxTargetBonusModAddMaxLockedTargetsLocationChar = 214,
    Effect_weaponDisruptionDurationBonusPostPercentDurationLocationShipModulesRequiringWeaponDisruption = 215,
    Effect_electronicWarfareSkillBoostDurationBonus = 216,
    Effect_engineeringSkillBoostPowerOutputBonus = 218,
    Effect_energyManagementSkillBoostCapRechargeBonus = 220,
    Effect_navigationSkillBoostVelocityBonus = 222,
    Effect_navigationVelocityBonusPostPercentMaxVelocityLocationShip = 223,
    Effect_accerationControlSkillBoostCapNeedBonus = 225,
    Effect_accerationControlCapNeedBonusPostPercentCapacitorNeedLocationShipGroupAfterburner = 227,
    Effect_accerationControlSkillBoostSpeedFBonus = 228,
    Effect_afterburnerDurationBonusPostPercentDurationLocationShipModulesRequiringAfterburner = 230,
    Effect_evasiveManuveringSkillBoostAgilityBonus = 232,
    Effect_warpdriveoperationSkillBoostWarpCapacitorNeedBonus = 234,
    Effect_warpdriveoperationWarpCapacitorNeedBonusPostPercentWarpCapacitorNeedLocationShip = 235,
    Effect_energyEmmisionSystemsCapNeedBonusPostPercentCapacitorNeedLocationShipModulesRequiringEnergyEmmisionSystems = 236,
    Effect_corporationManagementSkillBoostCorporationMemberBonus = 239,
    Effect_accerationControlSpeedFBonusPostPercentSpeedFactorLocationShipGroupAfterburner = 242,
    Effect_highSpeedManuveringSkillBoostCapacitorNeedMultiplier = 243,
    Effect_highSpeedManuveringCapacitorNeedMultiplierPostPercentCapacitorNeedLocationShipModulesRequiringHighSpeedManuvering = 244,
    Effect_sensorUpgradesSkillBoostPowerNeedBonus = 246,
    Effect_hullUpgradesSkillBoostHullHpBonus = 251,
    Effect_shadowBarrageDmgMultiplierWithDamageMultiplierPostPercentBarrageDmgMutator = 253,
    Effect_shadowBarrageFalloffWithFalloffPostPercentBarrageFalloffMutator = 254,
    Effect_barrage = 263,
    Effect_amarrCruiserSkillBoostPowerOutputBonus = 267,
    Effect_hullUpgradesSkillBoostArmorHpBonus = 270,
    Effect_hullUpgradesArmorHpBonusPostPercentHpLocationShip = 271,
    Effect_repairSystemsDurationBonusPostPercentDurationLocationShipModulesRequiringRepairSystems = 272,
    Effect_shieldUpgradesPowerNeedBonusPostPercentPowerLocationShipModulesRequiringShieldUpgrades = 273,
    Effect_energyManagementSkillBoostCapacitorBonus = 274,
    Effect_tacticalshieldManipulationSkillBoostUniformityBonus = 277,
    Effect_shieldEmmisionSystemsCapNeedBonusPostPercentCapacitorNeedLocationShipModulesRequiringShieldEmmisionSystems = 279,
    Effect_shieldManagementSkillBoostShieldCapacityBonus = 280,
    Effect_shieldoperationSkillBoostRechargeratebonus = 283,
    Effect_controlledBurstsCapNeedBonusPostPercentCapacitorNeedLocationShipModulesRequiringGunnery = 287,
    Effect_skillBoostTrackingSpeedMultiplier = 288,
    Effect_motionPredictionTrackingSpeedMultiplierPostPercentTrackingSpeedLocationShipModulesRequiringGunnery = 289,
    Effect_sharpshooterRangeSkillBonusPostPercentMaxRangeLocationShipModulesRequiringGunnery = 290,
    Effect_skillBoostFalloffBonus = 297,
    Effect_surgicalStrikeFalloffBonusPostPercentFalloffLocationShipModulesRequiringGunnery = 298,
    Effect_empathySkillBoostCharismaBonus = 301,
    Effect_empathyCharismaBonusModAddCharismaLocationChar = 302,
    Effect_instantRecallSkillBoostMemoryBonus = 303,
    Effect_instantRecallMemoryBonusModAddMemoryLocationChar = 304,
    Effect_analyticalMindSkillBoostIntelligenceBonus = 305,
    Effect_analyticalMindIntelligenceBonusModAddIntelligenceLocationChar = 306,
    Effect_ironWillSkillBoostWillpowerBonus = 307,
    Effect_ironWillWillpowerBonusModAddWillpowerLocationChar = 308,
    Effect_spatialAwarenessSkillBoostPerceptionBonus = 309,
    Effect_spatialAwarenessPerceptionBonusModAddPerceptionLocationChar = 310,
    Effect_signatureAnalysisMaxTargetRangeBonusPostPercentMaxTargetRangeLocationShip = 312,
    Effect_dronesSkillBoostMaxActiveDroneBonus = 315,
    Effect_dronesMaxActiveDroneBonusModAddMaxActiveLocationChar = 316,
    Effect_amarrTechSkillBoostAmarrTechMutator = 317,
    Effect_amarrTechAmarrTechMutatorPostPercentAmarrTechTimePercentLocationChar = 318,
    Effect_caldariTechSkillBoostCaldariTechMutator = 319,
    Effect_caldariTechCaldariTechMutatorPostPercentCaldariTechTimePercentLocationChar = 320,
    Effect_gallenteTechSkillBoostGallenteTechMutator = 321,
    Effect_gallenteTechGallenteTechMutatorPostPercentGallenteTechTimePercentLocationChar = 322,
    Effect_minmatarTechSkillBoostMinmatarTechMutator = 325,
    Effect_minmatarTechMinmatarTechMutatorPostPercentMinmatarTechTimePercentLocationChar = 326,
    Effect_refineryEfficiencySkillBoostRefiningYieldMutator = 331,
    Effect_cSOTrainingSkillBoostResearchGangSizeBonus = 334,
    Effect_cSOTrainingResearchGangSizeBonusModAddMaxResearchGangSizeShip = 335,
    Effect_battleshipConstructionSkillBoostBattleshipConstructionTimeBonus = 336,
    Effect_battleshipConstructionBattleshipConstructionTimeBonusPostPercentBattleshipConstructionTimeChar = 337,
    Effect_cruiserConstructionSkillBoostCruiserConstructionTimeBonus = 338,
    Effect_cruiserConstructionCruiserConstructionTimeBonusPostPercentCruiserConstructionTimeChar = 339,
    Effect_frigateConstructionSkillBoostFrigateConstructionTimeBonus = 340,
    Effect_frigateConstructionFrigateConstructionTimeBonusPostPercentFrigateConstructionTimeChar = 341,
    Effect_industrialConstructionSkillBoostIndustrialConstructionTimeBonus = 342,
    Effect_industrialConstructionIndustrialConstructionTimeBonusPostPercentIndustrialConstructionTimeChar = 343,
    Effect_connectionsSkillBoostConnectionBonusMutator = 344,
    Effect_criminalConnectionsSkillBoostCriminalConnectionsMutator = 346,
    Effect_diplomacySkillBoostDiplomacyMutator = 348,
    Effect_diplomacyDiplomacyMutatorModAddDiplomacyBonusChar = 349,
    Effect_fasttalkSkillBoostFastTalkMutator = 350,
    Effect_fasttalkFastTalkMutatorPostPercentFastTalkPercentageChar = 352,
    Effect_ethnicRelationsSkillBoostNonRaceCorporationMembersBonus = 353,
    Effect_ethnicRelationsNonRaceCorporationMembersBonusPostPercentMaxNonRaceCorporationMembersChar = 354,
    Effect_ethnicRelationsNonRaceCorporationMembersBonusModAddMaxNonRaceCorporationMembersChar = 355,
    Effect_assaultFormationDamageMultiplierBonusPostPercentDamageMultiplierGangShipModulesRequiringGunnery = 356,
    Effect_gallenteFrigateSkillBoostCpuOutputBonus = 368,
    Effect_astrogeologySkillBoostMiningAmountBonus = 389,
    Effect_astrogeologyMiningAmountBonusPostPercentMiningAmountLocationShipModulesRequiringMining = 391,
    Effect_mechanicHullHpBonusPostPercentHpShip = 392,
    Effect_navigationVelocityBonusPostPercentMaxVelocityShip = 394,
    Effect_evasiveManeuveringAgilityBonusPostPercentAgilityShip = 395,
    Effect_energyGridUpgradesCpuNeedBonusPostPercentCpuLocationShipModulesRequiringEnergyGridUpgrades = 396,
    Effect_electronicsCpuOutputBonusPostPercentCpuOutputLocationShipGroupComputer = 397,
    Effect_connectionsConnectionBonusMutatorModAddConnectionsBonusChar = 399,
    Effect_criminalConnectionsCriminalConnectionsMutatorModAddCriminalConnectionsBonusChar = 402,
    Effect_negotiationSkillBoostNegotiationBonus = 403,
    Effect_negotiationNegotiationBonusPostPercentNegotiationPercentageChar = 404,
    Effect_socialSkillBoostSocialMutator = 406,
    Effect_socialSocialMutatorPostPercentSocialBonusChar = 407,
    Effect_largeProjectileTurretDamageMultiplierBonusPostPercentDamageMultiplierLocationShipModulesRequiringLargeProjectileTurret = 408,
    Effect_industrySkillBoostManufacturingTimeBonus = 412,
    Effect_gunnerySkillBoostTurretSpeeBonus = 413,
    Effect_gunneryTurretSpeeBonusPostPercentSpeedLocationShipModulesRequiringGunnery = 414,
    Effect_tradeSkillBoostTradePremiumBonus = 415,
    Effect_tradeTradePremiumBonusPostPercentTradePremiumChar = 416,
    Effect_smugglingSkillBoostSmugglingChanceBonus = 417,
    Effect_industryManufacturingTimeBonusPostPercentManufactureTimeMultiplierChar = 425,
    Effect_productionEfficiencySkillBoostManufactureCostBonus = 428,
    Effect_productionEfficiencyManufactureCostBonusPostPercentManufactureCostMultiplierChar = 429,
    Effect_scienceSkillBoostCopySpeedBonus = 430,
    Effect_scienceCopySpeedBonusPostPercentCopySpeedPercentChar = 431,
    Effect_researchSkillBoostBlueprintmanufactureTimeBonus = 432,
    Effect_researchBlueprintmanufactureTimeBonusPostPercentProductionTimeResearchSpeedChar = 433,
    Effect_refineryEfficiencyRefiningYieldMutatorPostPercentRefiningYieldPercentageChar = 435,
    Effect_missileLauncherOperationSpeedBonusPostPercentSpeedLocationShipModulesRequiringMissileLauncherOperation = 436,
    Effect_learningSkillBoostLearningBonus = 439,
    Effect_learningLearningBonusPostPercentIntelligenceChar = 440,
    Effect_learningLearningBonusPostPercentWillpowerChar = 441,
    Effect_learningLearningBonusPostPercentPerceptionChar = 442,
    Effect_learningLearningBonusPostPercentCharismaChar = 443,
    Effect_learningLearningBonusPostPercentMemoryChar = 444,
    Effect_energyManagementCapacitorBonusPostPercentCapacityLocationShipGroupCapacitor = 445,
    Effect_shieldManagementShieldCapacityBonusPostPercentCapacityLocationShipGroupShield = 446,
    Effect_scoutDroneOperationSkillBoostDroneRangeBonus = 448,
    Effect_shipVelocityBonusMF = 452,
    Effect_minmatarFrigateSkillLevelPreMulShipBonusMFShip = 453,
    Effect_shipTargetRangeBonusMF = 456,
    Effect_shipCargoBonusMF = 458,
    Effect_shipMiningBonusMF = 459,
    Effect_caldariFrigateSkillLevelPreMulShipBonusCFShip = 460,
    Effect_shipHybridRangeBonusCF = 462,
    Effect_shipShieldCapBonusCF = 464,
    Effect_shipTargetRangeBonusCF = 466,
    Effect_gallenteFrigateSkillLevelPreMulShipBonusGFShip = 468,
    Effect_shipMiningBonusGF = 469,
    Effect_shipHybridTrackingBonusGf = 472,
    Effect_shipTargetRangeBonusGF = 474,
    Effect_amarrFrigateSkillLevelPreMulShipBonusAFShip = 476,
    Effect_shipDroneRangeBonusGF = 479,
    Effect_shipCargoBonusAF = 480,
    Effect_metallurgySkillBoostMineralNeedResearchBonus = 481,
    Effect_shipTargetingRangeBonusAF = 482,
    Effect_energysystemsoperationCapRechargeBonusPostPercentRechargeRateLocationShipGroupCapacitor = 485,
    Effect_shieldOperationRechargeratebonusPostPercentRechargeRateLocationShipGroupShield = 486,
    Effect_engineeringPowerEngineeringOutputBonusPostPercentPowerOutputLocationShipGroupPowerCore = 490,
    Effect_warpDriveOperationWarpCapacitorNeedBonusPostPercentWarpCapacitorNeedLocationShipGroupPropulsion = 494,
    Effect_prototypingSkillBoostPrototypingBonus = 496,
    Effect_prototypingPrototypingBonusModAddPrototypingChanceChar = 497,
    Effect_inventionSkillBoostInventionBonus = 498,
    Effect_amarrCruiserSkillLevelPreMulShipBonusACShip = 500,
    Effect_scoutDroneOperationDroneRangeBonusModAddDroneControlDistanceChar = 504,
    Effect_fuelConservationCapNeedBonusPostPercentCapacitorNeedLocationShipModulesRequiringAfterburner = 506,
    Effect_longRangeTargetingMaxTargetRangeBonusPostPercentMaxTargetRangeLocationShipGroupElectronic = 507,
    Effect_shipPDmgBonusMF = 508,
    Effect_shipCargoBonusCF = 509,
    Effect_amarrFrigateSkillLevelPreMulShipBonus2AFShip = 510,
    Effect_shipEnergyTCapNeedBonusAF = 511,
    Effect_shipSHTDmgBonusGF = 512,
    Effect_shipSETDmgBonusAF = 514,
    Effect_shipTCapNeedBonusAC = 516,
    Effect_gallenteCruiserSkillLevelPreMulShipBonusGCShip = 517,
    Effect_caldariCruiserSkillLevelPreMulShipBonusCCShip = 520,
    Effect_shipHRangeBonusCC = 521,
    Effect_minmatarCruiserSkillLevelPreMulShipBonusMCShip = 524,
    Effect_shipVelocityBonusMC = 525,
    Effect_minmatarIndustrialSkillLevelPreMulShipBonusMIShip = 526,
    Effect_shipVelocityBonusMI = 527,
    Effect_shipCargoBonusAI = 529,
    Effect_caldariIndustrialSkillLevelPreMulShipBonusCIShip = 530,
    Effect_gallenteIndustrialSkillLevelPreMulShipBonusGIShip = 532,
    Effect_shipPTrackingBonus = 533,
    Effect_cpuMultiplierPostMulCpuOutputShip = 536,
    Effect_droneBayBonus = 537,
    Effect_amarrBattleshipSkillLevelPostMulShipBonusABShip = 538,
    Effect_caldariBattleshipSkillLevelPreMulShipBonusCBShip = 541,
    Effect_shipCapNeedBonusAB = 542,
    Effect_minmatarBattleshipSkillLevelPreMulShipBonusMBShip = 548,
    Effect_shipPTDmgBonusMB = 549,
    Effect_shipHTDmgBonusGB = 550,
    Effect_shipPTRangeBonusMB = 551,
    Effect_shipHTTrackingBonusGB = 553,
    Effect_caldariBattleshipSkillLevelPreMulShipBonus2CBShip = 556,
    Effect_metallurgyMineralNeedResearchBonusPostPercentMineralNeedResearchSpeedChar = 558,
    Effect_shipHTDmgBonusfixedGC = 562,
    Effect_warpScrambleForEntity = 563,
    Effect_laboratoryOperationSkillLevelModAddMaxLaborotorySlotsChar = 566,
    Effect_massProductionSkillLevelModAddManufactureSlotLimitChar = 568,
    Effect_missileLaunchingForEntity = 569,
    Effect_reverseEngineeringInventionBonusModAddReverseEngineeringChanceLocationChar = 571,
    Effect_modifyTargetSpeed2 = 575,
    Effect_weaponUpgradesCpuNeedBonusPostPercentCpuLocationShipModulesRequiringGunnery = 581,
    Effect_rapidFiringRofBonusPostPercentSpeedLocationShipModulesRequiringGunnery = 582,
    Effect_amarrIndustrialSkillLevelPreMulShipBonusAI2Ship = 583,
    Effect_surgicalStrikeDamageMultiplierBonusPostPercentDamageMultiplierLocationShipModulesRequiringGunnery = 584,
    Effect_decreaseTargetSpeed = 586,
    Effect_surgicalStrikeDamageMultiplierBonusPostPercentDamageMultiplierLocationShipGroupEnergyWeapon = 587,
    Effect_surgicalStrikeDamageMultiplierBonusPostPercentDamageMultiplierLocationShipGroupProjectileWeapon = 588,
    Effect_surgicalStrikeDamageMultiplierBonusPostPercentDamageMultiplierLocationShipGroupHybridWeapon = 589,
    Effect_energyPulseWeaponsDurationBonusPostPercentDurationLocationShipModulesRequiringEnergyPulseWeapons = 590,
    Effect_targetArmorRepair = 592,
    Effect_armorExtender = 594,
    Effect_ammoInfluenceRange = 596,
    Effect_targetedEMResonanceMultiply = 597,
    Effect_ammoSpeedMultiplier = 598,
    Effect_ammoFallofMultiplier = 599,
    Effect_ammoTrackingMultiplier = 600,
    Effect_shipPTurretSpeedBonusMC = 602,
    Effect_shipPTspeedBonusMB2 = 604,
    Effect_minmatarBattleshipSkillLevelPreMulShipBonusMB2Ship = 605,
    Effect_cloaking = 607,
    Effect_turretWeaponRangeTrackingSpeedMultiplyTargetHostile = 609,
    Effect_gallenteBattleshipSkillLevelPreMulShipBonusGBShip = 611,
    Effect_targetedKineticResonanceMultiply = 615,
    Effect_targetedThermalResonanceMultiply = 616,
    Effect_targetedExplosiveResonanceMultiply = 617,
    Effect_deepCoreMiningSkillBoostDamageCloudChanceReduction = 621,
    Effect_damageCloudChanceReduction = 622,
    Effect_miningDroneOperationMiningAmountBonusPostPercentMiningDroneAmountPercentChar = 623,
    Effect_standardMissilesSkillBoostMissileVelocityBonus = 624,
    Effect_powerIncrease = 627,
    Effect_shieldDefensiveOperationsShieldCapacityBonusPostPercentShieldCapacityGangShips = 638,
    Effect_reconOperationsMaxTargetRangeBonusPostPercentMaxTargetRangeGangShips = 639,
    Effect_chiefFieldEngineerCapacitorBonusPostPercentCapacitorCapacityGangShips = 643,
    Effect_shipSpecialityMining = 648,
    Effect_anchorDrop = 649,
    Effect_anchorLift = 650,
    Effect_cloakingSkillBoostCloakVelocityBonus = 651,
    Effect_shipSpecialityCloak = 653,
    Effect_agilityMultiplierEffect = 657,
    Effect_missileVelocityBonusGeneric = 658,
    Effect_missileEMDmgBonus = 660,
    Effect_missileExplosiveDmgBonus = 661,
    Effect_missileThermalDmgBonus = 662,
    Effect_heavyMissilesSkillBoostMaxflightTimeBonus = 663,
    Effect_missileKineticDmgBonus2 = 668,
    Effect_shipLauncherspeedCB2 = 669,
    Effect_antiWarpScramblingPassive = 670,
    Effect_weaponUpgradesSkillBoostCpu = 672,
    Effect_weaponUpgradesCpuNeedBonusPostPercentCpuLocationShipModulesRequiringEnergyPulseWeapons = 675,
    Effect_weaponUpgradesCpuNeedBonusPostPercentCpuLocationShipModulesRequiringMissileLauncherOperation = 677,
    Effect_gallenteBattleshipSkillLevelPreMulShipBonusGB2Ship = 682,
    Effect_electronic2AttributeModifyOnline = 688,
    Effect_signatureAnalysisSkillLevelPreMulScanResolutionBonusSelf = 698,
    Effect_signatureAnalysisScanResolutionBonusPostPercentScanResolutionShip = 699,
    Effect_interceptorsSkillLevelPreMulEliteBonusInterceptorShip = 703,
    Effect_covertOpsSkillLevelPreMulEliteBonusCoverOpsShip = 704,
    Effect_bombersSkillLevelPreMulEliteBonusBombersShip = 705,
    Effect_covertOpsWarpResistance = 706,
    Effect_bomberRocketRangeBonus = 707,
    Effect_bomberLightsRangeBonus = 708,
    Effect_interceptorSignatoreRadiusBonus = 709,
    Effect_speedBoostFactorCalculator = 710,
    Effect_speedBoostFactorCalculator2 = 712,
    Effect_stealthActive = 713,
    Effect_sensorBoostTargeted = 716,
    Effect_sensorBoosterActive = 720,
    Effect_miningCapBonus = 721,
    Effect_shipBonusCargo2GI = 726,
    Effect_shipBonusCargoCI = 727,
    Effect_shipBonusCargoMI = 728,
    Effect_shipBonusVelocityGI = 729,
    Effect_shipBonusVelocityCI = 730,
    Effect_shipVelocityBonusAI = 732,
    Effect_amarrBattleshipSkillLevelPreMulShipBonusAB2Ship = 734,
    Effect_shipBonusCapCapAB = 736,
    Effect_surveyScanspeedBonusPostPercentDurationLocationShipModulesRequiringElectronics = 744,
    Effect_gallenteFrigateSkillLevelPreMulShipBonusGF2Ship = 751,
    Effect_shipHybridDamageBonusCF = 754,
    Effect_shipETDamageAF = 757,
    Effect_shipMissileSpeedBonusCF = 760,
    Effect_caldariFrigateSkillLevelPreMulShipBonusCF2Ship = 761,
    Effect_minmatarFrigateSkillLevelPreMulShipBonusMF2Ship = 762,
    Effect_missileDMGBonus = 763,
    Effect_leadershipEffect = 765,
    Effect_hypereuclideanNavigationCloakVelocityBonusModAddSpeedFactorLocationShipModulesRequiringCloaking = 768,
    Effect_capBoostAmplifier = 775,
    Effect_missileGuidanceAgilityBonusPostPercentAgilityOwnerCharModulesRequiringMissileLauncherOperation = 782,
    Effect_missileBombardmentMaxFlightTimeBonusPostPercentExplosionDelayOwnerCharModulesRequiringMissileLauncherOperation = 784,
    Effect_escortHullUpgradeCpuBonus = 793,
    Effect_escortShieldUpgradeCpuBonus = 796,
    Effect_caldariBattleshipSkillLevelPreMulShipBonusCB3Ship = 797,
    Effect_shipDronesMaxGB = 802,
    Effect_ammoInfluenceCapNeed = 804,
    Effect_speedBoostPassive = 820,
    Effect_ammoInfluenceCapRecharge = 834,
    Effect_freightSkillBoostCargoCapacityBonus = 835,
    Effect_skillFreightBonus = 836,
    Effect_sensorBoostTargetedHostile = 837,
    Effect_ammoInfluenceShipVelocity = 838,
    Effect_cloakingTargetingDelayBonusPostPercentCloakingTargetingDelayBonusForShipModulesRequiringCloaking = 848,
    Effect_cloakingSkillBoostCloakingTargetingDelayBonus = 850,
    Effect_cloakingScanResolutionMultiplier = 854,
    Effect_warpSkillSpeed = 856,
    Effect_bountyHuntingSkillBoostBountySkillBonus = 857,
    Effect_bountyhunterskill = 858,
    Effect_advancedBountyHuntingSkillBoostBountySkillMultiplyer = 859,
    Effect_advBountyhunterSkill = 860,
    Effect_missileFlightTimeAndDamage = 867,
    Effect_shipProjectileOptimalBonuseMF2 = 874,
    Effect_shipLaserOptimalBonuseAF = 875,
    Effect_shieldBoostingForEntities = 876,
    Effect_armorRepairForEntities = 878,
    Effect_implantEWcpuneed = 881,
    Effect_shipHybridRangeBonusCF2 = 882,
    Effect_suicideBomb = 885,
    Effect_shipETspeedBonusAB2 = 887,
    Effect_missileLauncherSpeedMultiplier = 889,
    Effect_shipCruiseMissileVelocityBonusCB3 = 891,
    Effect_shipTorpedosVelocityBonusCB3 = 892,
    Effect_covertOpsCpuBonus1 = 896,
    Effect_covertOpsCpuMultplier1 = 897,
    Effect_shipMissileKineticDamageCF = 898,
    Effect_shipMissileKineticDamageCC = 899,
    Effect_shipDroneScoutThermalDamageGF2 = 900,
    Effect_onlineForStructures = 901,
    Effect_decloakWave = 902,
    Effect_ammoInfluenceSignatureRadius = 903,
    Effect_ammoInfluenceShieldCapacity = 904,
    Effect_shipLaserRofAC2 = 907,
    Effect_shipArmorHpAC2 = 909,
    Effect_shipMissileLauncherRofCC2 = 912,
    Effect_shipMiningYieldCC2 = 914,
    Effect_shipDronesMaxGC2 = 918,
    Effect_shipHybridTrackingGC2 = 919,
    Effect_shipMiningYieldMC2 = 923,
    Effect_amarrCruiserSkillLevelPreMulShipBonusAC2Ship = 926,
    Effect_caldariCruiserSkillLevelPreMulShipBonusCC2Ship = 927,
    Effect_gallenteCruiserSkillLevelPreMulShipBonusGC2Ship = 928,
    Effect_minmatarCruiserSkillLevelPreMulShipBonusMC2Ship = 929,
    Effect_shipCargoCapacityGC2 = 930,
    Effect_shipMaxVelocityMC2 = 934,
    Effect_shipShieldBoostCC2 = 939,
    Effect_boosterTimeBonus = 952,
    Effect_biologyTimeBonus = 953,
    Effect_shipArmorEmResistanceAC2 = 958,
    Effect_shipArmorExplosiveResistanceAC2 = 959,
    Effect_shipArmorKineticResistanceAC2 = 960,
    Effect_shipArmorThermalResistanceAC2 = 961,
    Effect_shipMwdLessCapNerfGC2 = 967,
    Effect_shipProjectileDmgMC2 = 968,
    Effect_smartbombEMBonus = 969,
    Effect_smartbombKineticBonus = 970,
    Effect_smartbombThermalBonus = 971,
    Effect_smartbombEXBonus = 972,
    Effect_smartbombRangeBonus = 973,
    Effect_cloakingWarpSafe = 980,
    Effect_droneHeavyControlUnitMultiplier = 983,
    Effect_gunshipSkillMultiplier1 = 987,
    Effect_gunshipSkillMultiplier2 = 988,
    Effect_eliteBonusGunshipHybridOptimal1 = 989,
    Effect_eliteBonusGunshipProjectileOptimal1 = 990,
    Effect_eliteBonusGunshipLaserOptimal1 = 991,
    Effect_eliteBonusGunshipHybridTracking2 = 996,
    Effect_eliteBonusGunshipProjectileFalloff2 = 998,
    Effect_eliteBonusGunshipShieldBoost2 = 999,
    Effect_eliteBonusGunshipCapRecharge2 = 1001,
    Effect_eliteBonusGunshipDroneCapacity2 = 1002,
    Effect_selfT2SmallLaserPulseDamageBonus = 1003,
    Effect_selfT2SmallLaserBeamDamageBonus = 1004,
    Effect_selfT2SmallHybridBlasterDamageBonus = 1005,
    Effect_selfT2SmallHybridRailDamageBonus = 1006,
    Effect_selfT2SmallProjectileACDamageBonus = 1007,
    Effect_selfT2SmallProjectileArtyDamageBonus = 1008,
    Effect_selfT2MediumLaserPulseDamageBonus = 1009,
    Effect_selfT2MediumLaserBeamDamageBonus = 1010,
    Effect_selfT2MediumHybridBlasterDamageBonus = 1011,
    Effect_selfT2MediumHybridRailDamageBonus = 1012,
    Effect_selfT2MediumProjectileACDamageBonus = 1013,
    Effect_selfT2MediumProjectileArtyDamageBonus = 1014,
    Effect_selfT2LargeLaserPulseDamageBonus = 1015,
    Effect_selfT2LargeLaserBeamDamageBonus = 1016,
    Effect_selfT2LargeHybridBlasterDamageBonus = 1017,
    Effect_selfT2LargeHybridRailDamageBonus = 1018,
    Effect_selfT2LargeProjectileACDamageBonus = 1019,
    Effect_selfT2LargeProjectileArtyDamageBonus = 1020,
    Effect_eliteBonusGunshipHybridDmg2 = 1021,
    Effect_anchorDropForStructures = 1022,
    Effect_anchorLiftForStructures = 1023,
    Effect_shipMissileHeavyVelocityBonusCC2 = 1024,
    Effect_shipMissileLightVelocityBonusCC2 = 1025,
    Effect_remoteArmorSystemsCapNeedBonusPostPercentCapacitorNeedLocationShipModulesRequiringRemoteArmorSystems = 1030,
    Effect_eliteBonusLogisticRemoteArmorRepairCapNeed1 = 1033,
    Effect_eliteBonusLogisticRemoteArmorRepairCapNeed2 = 1034,
    Effect_eliteBonusLogisticShieldTransferCapNeed2 = 1035,
    Effect_eliteBonusLogisticShieldTransferCapNeed1 = 1036,
    Effect_eliteBonusLogisticTrackingLinkBonus1 = 1042,
    Effect_eliteBonusLogisticTrackingLinkBonus2 = 1045,
    Effect_shipRemoteArmorRange1 = 1046,
    Effect_shipRemoteArmorRange2 = 1047,
    Effect_shipShieldTransferRange1 = 1048,
    Effect_shipShieldTransferRange2 = 1049,
    Effect_logisticSkillMultiplier1 = 1052,
    Effect_logisticSkillMultiplier2 = 1053,
    Effect_shipTrackingLinkRange1 = 1054,
    Effect_shipTrackingLinkRange2 = 1055,
    Effect_eliteBonusHeavyGunshipHybridOptimal1 = 1056,
    Effect_eliteBonusHeavyGunshipProjectileOptimal1 = 1057,
    Effect_eliteBonusHeavyGunshipLaserOptimal1 = 1058,
    Effect_eliteBonusHeavyGunshipProjectileFallOff1 = 1060,
    Effect_eliteBonusHeavyGunshipHybridDmg2 = 1061,
    Effect_eliteBonusHeavyGunshipLaserDmg2 = 1062,
    Effect_eliteBonusHeavyGunshipProjectileTracking2 = 1063,
    Effect_eliteBonusHeavyGunshipDroneCapacity2 = 1066,
    Effect_warshipSkillMultiplier2 = 1077,
    Effect_warshipSkillMultiplier1 = 1079,
    Effect_eliteBonusHeavyGunshipHybridFallOff1 = 1080,
    Effect_eliteBonusHeavyGunshipHeavyMissileFlightTime1 = 1081,
    Effect_eliteBonusHeavyGunshipLightMissileFlightTime1 = 1082,
    Effect_eliteBonusHeavyGunshipDroneControlRange1 = 1084,
    Effect_projectileFiredForEntities = 1086,
    Effect_eliteBonusHeavyGunshipProjectileDmg2 = 1087,
    Effect_destroyerPenalityTurretROF = 1095,
    Effect_shipProjectileTrackingMF2 = 1099,
    Effect_controlTowerAmarrLaserDMGBonus = 1108,
    Effect_battlecruiserSkillLevelPreMulShipBonusBC1Ship = 1109,
    Effect_shipProjectileRofMBC2 = 1110,
    Effect_battlecruiserSkillLevelPreMulShipBonusBC2Ship = 1111,
    Effect_shipArmorThermResistanceABC1 = 1117,
    Effect_shipArmorEMResistanceABC1 = 1118,
    Effect_shipArmorExplosiveResistanceABC1 = 1119,
    Effect_shipArmorKineticResistanceABC1 = 1120,
    Effect_shipShieldEmResistanceCBC2 = 1121,
    Effect_shipShieldExplosiveResistanceCBC2 = 1122,
    Effect_shipShieldKineticResistanceCBC2 = 1123,
    Effect_shipShieldThermalResistanceCBC2 = 1124,
    Effect_shipLaserCapABC2 = 1125,
    Effect_shipHybridDmgGBC1 = 1126,
    Effect_structureUnanchorForced = 1129,
    Effect_controlTowerAmarrLaserOptimalBonus = 1130,
    Effect_controlTowerSiloCapacityBonus = 1131,
    Effect_controlTowerMinmatarProjectileOptimalBonus = 1133,
    Effect_controlTowerMinmatarProjectileFallOffBonus = 1134,
    Effect_controlTowerMinmatarProjectileRofBonus = 1137,
    Effect_controlTowerMoonHarvesterCPUBonus = 1138,
    Effect_destroyerSkillLevelPreMulShipBonusDF2Ship = 1139,
    Effect_destroyerSkillLevelPreMulShipBonusDF1Ship = 1140,
    Effect_shipHybridTrackingGD2 = 1141,
    Effect_shipLaserCapNeedAD1 = 1143,
    Effect_shipLaserTrackingAD2 = 1144,
    Effect_shipHybridRangeCD1 = 1145,
    Effect_shipProjectileTrackingMD2 = 1147,
    Effect_systemScan = 1150,
    Effect_controlTowerGallenteHybridDamageBonus = 1152,
    Effect_controlTowerTrackingArrayHybridOptimalBonus = 1156,
    Effect_controlTowerTrackingArrayLaserOptimalBonus = 1157,
    Effect_controlTowerTrackingArrayProjectileOptimalBonus = 1158,
    Effect_controlTowerTrackingArrayProjectileTrackingBonus = 1159,
    Effect_controlTowerTrackingArrayHybridTrackingBonus = 1160,
    Effect_controlTowerTrackingArrayLaserTrackingBonus = 1161,
    Effect_shipIceHarvesterCPUNeed = 1165,
    Effect_shipMinerCPUNeed = 1166,
    Effect_massFactor = 1171,
    Effect_ammoInfluenceEntityFlyRange = 1173,
    Effect_accerationControlSkillAb_MwdSpeedBoost = 1176,
    Effect_eliteBonusGunshipLaserDamage2 = 1179,
    Effect_eliteBonusLogisticEnergyTransferCapNeed1 = 1181,
    Effect_shipEnergyTransferRange1 = 1182,
    Effect_eliteBonusLogisticEnergyTransferCapNeed2 = 1183,
    Effect_shipEnergyTransferRange2 = 1184,
    Effect_structureStealthEmitterArraySigDecrease = 1185,
    Effect_miningBargeSkillLevelPostMulShipBonusORE2Ship = 1188,
    Effect_iceHarvestCycleTimeModulesRequiringIceHarvesting = 1190,
    Effect_iceHarvestCycleTimeBonus = 1191,
    Effect_controlTowerCaldariEwTargetSwitchDelayBonus = 1192,
    Effect_shipHybridOptimalCBC1 = 1193,
    Effect_shipShieldBoostMBC1 = 1194,
    Effect_shipArmorRepairingGBC2 = 1195,
    Effect_shipMiningBonusORE2 = 1197,
    Effect_shipHybridFallOffGD1 = 1198,
    Effect_targetAttackForStructures = 1199,
    Effect_miningInfoMultiplier = 1200,
    Effect_shipMissileEMDamage2AF = 1202,
    Effect_controlTowerCaldariMissileVelocityBonus = 1203,
    Effect_shipPTurretSpeedBonusGB = 1204,
    Effect_controlTowerCaldariMissileRofBonus = 1210,
    Effect_crystalMiningamountInfo2 = 1212,
    Effect_shipProjectileTrackingGC2 = 1213,
    Effect_shipEnergyDrainAmountAF1 = 1215,
    Effect_shipStasisRangeMF1 = 1217,
    Effect_shipBonusPirateSmallHybridDmg = 1218,
    Effect_shipEnergyVampireTransferAmountBonusAB = 1219,
    Effect_shipEnergyVampireTransferAmountBonusAc = 1220,
    Effect_shipStasisWebRangeBonusMB = 1221,
    Effect_shipStasisWebRangeBonusMC2 = 1222,
    Effect_shipMWDCapBonusMC = 1224,
    Effect_shipMWDCapBonusMB = 1226,
    Effect_shipProjectileTrackingGF = 1228,
    Effect_shipMWDCapBonusMF = 1229,
    Effect_shipMissileVelocityPirateFactionFrigate = 1230,
    Effect_shipBonusLaserCapPirateCruiser = 1231,
    Effect_shipProjectileRofPirateCruiser = 1232,
    Effect_shipHybridDmgPirateCruiser = 1233,
    Effect_shipMissileVelocityPirateFactionLight = 1234,
    Effect_shipMissileVelocityPirateFactionHeavy = 1235,
    Effect_shipMissileVelocityPirateFactionCruise = 1236,
    Effect_shipMissileVelocityPirateFactionTorp = 1237,
    Effect_shipLaserCapPirateBattleship = 1238,
    Effect_shipProjectileRofPirateBattleship = 1239,
    Effect_shipHybridDmgPirateBattleship = 1240,
    Effect_shipMissileExplosiveDamageMF1 = 1243,
    Effect_smugglingModifier = 1244,
    Effect_shipProjectileDamageDF1 = 1252,
    Effect_speedBoostMassAddition = 1253,
    Effect_speedBoostMassSigRad = 1254,
    Effect_setBonusBloodraider = 1255,
    Effect_setBonusBloodraiderNosferatu = 1256,
    Effect_blackMarketTradingSkillBoostContrabandDetectionChanceBonus = 1257,
    Effect_skillBoostContrabandDetectionChanceBonusEffect = 1258,
    Effect_testfuelConsumption = 1259,
    Effect_testmassThrust = 1260,
    Effect_setBonusSerpentis = 1261,
    Effect_setBonusSerpentis2 = 1262,
    Effect_interceptor2HybridTracking = 1264,
    Effect_interceptor2MissileKineticDamage = 1265,
    Effect_interceptor2MissileVelocity = 1266,
    Effect_interceptor2LaserTracking = 1268,
    Effect_interceptor2ProjectileFallOff = 1269,
    Effect_interceptor2ProjectileTracking = 1270,
    Effect_newEwTestscanStrengthBonusTargetHostile = 1271,
    Effect_newEwTestswarpScramble = 1272,
    Effect_newEwTestssensorBoostTargetedHostile = 1273,
    Effect_newEwTeststurretWeaponRangeTrackingSpeedMultiplyTargetHostile = 1274,
    Effect_newEwTestsdecreaseTargetSpeed = 1275,
    Effect_interceptor2MissileEmDamage = 1278,
    Effect_interceptors2SkillLevelPreMulEliteBonusInterceptorShip = 1279,
    Effect_structuralAnalyzisSkillBoostRepairBonus = 1280,
    Effect_structuralAnalysisEffect = 1281,
    Effect_eliteIndustrial1SkillLevelPreMulEliteBonusEliteIndustrialShip = 1282,
    Effect_eliteIndustrial2SkillLevelPreMulEliteBonusEliteIndustrialShip = 1283,
    Effect_amarrIndustrialSkillLevelPreMulShipBonusAI22Ship = 1290,
    Effect_caldariIndustrialSkillLevelPreMulShipBonusCI2Ship = 1291,
    Effect_gallenteIndustrialSkillLevelPreMulShipBonusGI2Ship = 1292,
    Effect_minmatarIndustrialSkillLevelPreMulShipBonusMI2Ship = 1293,
    Effect_eliteIndustrialShieldBoostAmountElite1 = 1304,
    Effect_eliteIndustrialShieldBoostCapNeedElite2 = 1305,
    Effect_eliteIndustrialArmorRepairAmountElite1 = 1306,
    Effect_eliteIndustrialArmorRepairCapNeedElite1 = 1307,
    Effect_eliteIndustrialArmorRepairDurationElite2 = 1308,
    Effect_shipMissileThermDamageGallenteInterceptor2 = 1309,
    Effect_ewSkillScanStrengthBonus = 1318,
    Effect_propulsionSkillFallOffBonus = 1320,
    Effect_ewSkillScanStrengthBonusSkillLevel = 1321,
    Effect_propulsionSkillMaxRangeBonus = 1322,
    Effect_propulsionSkillPropulsionStrengthBonus = 1329,
    Effect_propulsionSkillPropulsionStrengthBonusSkillLevel = 1330,
    Effect_amarrShipEwWeaponDisruptionAF1 = 1335,
    Effect_gallenteShipEwSensorDampenGF2 = 1339,
    Effect_gallenteShipEwSensorDampenGC2 = 1343,
    Effect_ewTestEffectRsd = 1354,
    Effect_ewTestEffectWs = 1355,
    Effect_ewTestEffectJam = 1358,
    Effect_ewSkillRsdCapNeedBonusSkillLevel = 1360,
    Effect_ewSkillTdCapNeedBonusSkillLevel = 1361,
    Effect_propulsionSkillStasisStrengthBonus = 1367,
    Effect_ewSkillTrackingDisruptionBonus = 1369,
    Effect_ewSkillTpCapNeedBonusSkillLevel = 1370,
    Effect_ewSkillEwCapNeedSkillLevel = 1372,
    Effect_ewSkillTargetPaintingStrengthBonusSkillLevel = 1373,
    Effect_ewSkillSignatureDampenBonus = 1376,
    Effect_leadershipCpuBonus = 1387,
    Effect_stealthOnline = 1390,
    Effect_covertOpsStealthBomberCruiseLauncerPowerNeedBonus = 1394,
    Effect_shieldBoostAmplifierPassive = 1395,
    Effect_setBonusGuristas = 1397,
    Effect_eliteBonusCoverOpsCruiseEmDmg1 = 1398,
    Effect_eliteBonusCoverOpsCruiseThermalDmg1 = 1399,
    Effect_eliteBonusCoverOpsCruiseExplosiveDmg1 = 1400,
    Effect_eliteBonusCoverOpsCruiseLauncherPowerNeed1 = 1401,
    Effect_eliteBonusCoverOpsCloakingVelocity2 = 1402,
    Effect_shipMissileCruiseKineticDmgCF2 = 1403,
    Effect_covertOpsSkillLevelPreMulEliteBonusCoverOpsShip2 = 1405,
    Effect_eliteBonusCoverOpsScanProbeDuration2 = 1407,
    Effect_systemScanDurationSkillAstrometrics = 1409,
    Effect_propulsionSkillCapNeedBonusSkillLevel = 1410,
    Effect_gangBonusSignature = 1411,
    Effect_shipBonusHybridOptimalCB = 1412,
    Effect_caldariShipEwStrengthCB = 1434,
    Effect_missileEMdamageOther = 1440,
    Effect_caldariShipEwOptimalRangeCB3 = 1441,
    Effect_caldariShipEwOptimalRangeCC2 = 1442,
    Effect_caldariShipEwCapacitorNeedCC = 1443,
    Effect_ewSkillRsdMaxRangeBonus = 1445,
    Effect_ewSkillTpMaxRangeBonus = 1446,
    Effect_ewSkillTdMaxRangeBonus = 1448,
    Effect_ewSkillRsdFallOffBonus = 1449,
    Effect_ewSkillTpFallOffBonus = 1450,
    Effect_ewSkillTdFallOffBonus = 1451,
    Effect_ewSkillEwMaxRangeBonus = 1452,
    Effect_ewSkillEwFallOffBonus = 1453,
    Effect_missileSkillAoeVelocityBonusSkillLevel = 1467,
    Effect_missileSkillAoeCloudSizeBonus = 1472,
    Effect_missileSkillAoeCloudSizeBonusSkillLevel = 1473,
    Effect_contrabandMasking = 1483,
    Effect_commandMultiplier = 1486,
    Effect_flagshipmultiRelayEffect = 1495,
    Effect_relayActiveMultiplier = 1496,
    Effect_masterAndCommander2 = 1498,
    Effect_shieldOperationSkillBoostCapacitorNeedBonusSkillLevel = 1499,
    Effect_shieldOperationSkillBoostCapacitorNeedBonus = 1500,
    Effect_covertOpsStealthBomberCruiseMissileExplosionRadiusBonus = 1501,
    Effect_armorTankingGang = 1502,
    Effect_gangArmorHardening = 1510,
    Effect_squadronmultiplyer = 1541,
    Effect_squadronCommand = 1542,
    Effect_gangPropulsionJammingBoost = 1546,
    Effect_gangShieldHardening = 1548,
    Effect_ewTargetPaint = 1549,
    Effect_ewSkillTargetPaintingStrengthBonus = 1550,
    Effect_minmatarShipEwTargetPainterMF2 = 1551,
    Effect_angelsetbonus = 1577,
    Effect_setBonusSansha = 1579,
    Effect_jumpDriveSkillsRangeBonus = 1581,
    Effect_jumpDriveSkillsRangeBonusSkillLevel = 1582,
    Effect_capitalTurretSkillLaserDamage = 1585,
    Effect_capitalTurretSkillProjectileDamage = 1586,
    Effect_capitalTurretSkillHybridDamage = 1587,
    Effect_capitalLauncherSkillCitadelKineticDamage = 1588,
    Effect_missileSkillAoeVelocityBonus = 1590,
    Effect_capitalLauncherSkillCitadelEmDamage = 1592,
    Effect_capitalLauncherSkillCitadelExplosiveDamage = 1593,
    Effect_capitalLauncherSkillCitadelThermalDamage = 1594,
    Effect_missileSkillWarheadUpgradesEmDamageBonus = 1595,
    Effect_missileSkillWarheadUpgradesExplosiveDamageBonus = 1596,
    Effect_missileSkillWarheadUpgradesKineticDamageBonus = 1597,
    Effect_skillAdvancedSpaceshipAgilityBonus = 1614,
    Effect_shipAdvancedSpaceshipCommandAgilityBonus = 1615,
    Effect_skillCapitalShipsAdvancedAgility = 1616,
    Effect_shipCapitalAgilityBonus = 1617,
    Effect_dreadnoughtBoostShipBonusA1 = 1618,
    Effect_dreadnoughtBoostShipBonusA2 = 1619,
    Effect_dreadnoughtBoostShipBonusC1 = 1620,
    Effect_dreadnoughtBoostShipBonusC2 = 1621,
    Effect_dreadnoughtBoostShipBonusG1 = 1622,
    Effect_dreadnoughtBoostShipBonusG2 = 1623,
    Effect_dreadnoughtBoostShipBonusM1 = 1624,
    Effect_dreadnoughtBoostShipBonusM2 = 1625,
    Effect_dreadnoughtShipBonusLaserCapNeedA1 = 1626,
    Effect_dreadnoughtShipBonusLaserRofA2 = 1627,
    Effect_dreadnoughtShipBonusLauncherRofC1 = 1628,
    Effect_dreadnoughtShipBonusHybridDmgG1 = 1630,
    Effect_dreadnoughtShipBonusProjectileRofM1 = 1632,
    Effect_dreadnoughtShipBonusLauncherRofM2 = 1633,
    Effect_capitalShieldOperationSkillCapacitorNeedBonus = 1634,
    Effect_capitalRepairSystemsSkillDurationBonus = 1635,
    Effect_skillAdvancedWeaponUpgradesPowerNeedBonus = 1638,
    Effect_armoredWarfareMindlink = 1643,
    Effect_shirmishWarfareMindlink = 1644,
    Effect_siegeWarfareMindlink = 1645,
    Effect_covertWarfareMindlink = 1646,
    Effect_gangECCMfixed = 1648,
    Effect_skillCynosuralTheoryConsumptionQuantityBonus = 1649,
    Effect_skillSiegeModuleConsumptionQuantityBonus = 1650,
    Effect_skillCynosural_SiegeConsumQuantityBonusSkillLevel = 1651,
    Effect_skillJumpDriveConsumptionAmountBonus = 1652,
    Effect_missileSkillWarheadUpgradesThermalDamageBonus = 1657,
    Effect_freighterA1SkillLevel = 1659,
    Effect_freighterA2SkillLevel = 1660,
    Effect_freighterC1SkillLevel = 1661,
    Effect_freighterC2SkillLevel = 1663,
    Effect_freighterG1SkillLevel = 1664,
    Effect_freighterG2SkillLevel = 1665,
    Effect_freighterM1SkillLevel = 1666,
    Effect_freighterM2SkillLevel = 1667,
    Effect_freighterCargoBonusA2 = 1668,
    Effect_freighterCargoBonusC2 = 1669,
    Effect_freighterCargoBonusG2 = 1670,
    Effect_freighterCargoBonusM2 = 1671,
    Effect_freighterMaxVelocityBonusA1 = 1672,
    Effect_freighterMaxVelocityBonusC1 = 1673,
    Effect_freighterMaxVelocityBonusG1 = 1674,
    Effect_freighterMaxVelocityBonusM1 = 1675,
    Effect_testfuelBoostShipSpeedActivation = 1676,
    Effect_shieldBoostAmplifier = 1720,
    Effect_dreadnoughtShipBonusMissileKineticDmgC2 = 1721,
    Effect_jumpDriveSkillsCapacitorNeedBonus = 1722,
    Effect_jumpDriveSkillsCapacitorNeedBonusSkillLevel = 1723,
    Effect_cynosuralGenerationTmp = 1729,
    Effect_droneDmgBonus = 1730,
    Effect_testDroneShieldEffect = 1731,
    Effect_openSpawnContainer = 1738,
    Effect_dataMiningSkillMultiplierFixed = 1740,
    Effect_siegeModeEffectOld = 1745,
    Effect_gangArmorRepairSpeedAmplifier = 1746,
    Effect_gangArmorRepairCapReducer = 1747,
    Effect_entityEwTestEffectJam = 1752,
    Effect_gangAbMwdFactorBoost = 1755,
    Effect_skirmishWarfareVelocityBonus = 1756,
    Effect_missileSkillRapidLauncherRoF = 1763,
    Effect_missileSkillMissileProjectileVelocityBonus = 1764,
    Effect_missileSkillMissileProjectileVelocityBonusSkillLevel = 1765,
    Effect_shipBonusPirateSanshaLaserCap = 1767,
    Effect_shipFalloffBonusGF = 1773,
    Effect_amarrShipEwTrackingDisruptAC1 = 1791,
    Effect_shipMissileLightVelocityBonusCF2 = 1802,
    Effect_shipMissileRocketVelocityBonusCF2 = 1803,
    Effect_shipArmorEMResistanceAF1 = 1804,
    Effect_shipArmorTHResistanceAF1 = 1805,
    Effect_shipArmorKNResistanceAF1 = 1806,
    Effect_shipArmorEXResistanceAF1 = 1807,
    Effect_shipShieldEMResistanceCC2 = 1812,
    Effect_shipShieldThermalResistanceCC2 = 1813,
    Effect_shipShieldKineticResistanceCC2 = 1814,
    Effect_shipShieldExplosiveResistanceCC2 = 1815,
    Effect_shipShieldEMResistanceCF2 = 1816,
    Effect_shipShieldThermalResistanceCF2 = 1817,
    Effect_shipShieldKineticResistanceCF2 = 1819,
    Effect_shipShieldExplosiveResistanceCF2 = 1820,
    Effect_increaseGallenteNavyBonus = 1822,
    Effect_increaseCaldariNavyBonus = 1824,
    Effect_increaseAmarrNavyBonus = 1825,
    Effect_increaseRepublicFleetBonus = 1826,
    Effect_miningYieldGangBonus = 1833,
    Effect_miningYieldMultiply = 1835,
    Effect_eliteBargeSkillMultiplier1 = 1838,
    Effect_eliteBargeSkillMultiplier2 = 1839,
    Effect_eliteBonusBargeMiningYield = 1840,
    Effect_miningForemanMindlink = 1848,
    Effect_miningBargeSkillLevelPostMulShipBonusORE3Ship = 1849,
    Effect_selfRof = 1851,
    Effect_shipMiningBonusAF = 1852,
    Effect_shipMiningBonusCF = 1853,
    Effect_shipCargoBonusGF = 1854,
    Effect_shipBonusScanProbeDurationCF = 1855,
    Effect_shipBonusScanProbeDurationGF = 1856,
    Effect_shipBonusScanProbeDurationMF = 1857,
    Effect_shipMissileEMDamageCF = 1862,
    Effect_shipMissileThermalDamageCF = 1863,
    Effect_shipMissileExplosiveDamageCF = 1864,
    Effect_shipMissileEMDamageMF2 = 1865,
    Effect_shipMissileThermalDamageMF2 = 1866,
    Effect_shipMissileKineticDamageMF2 = 1867,
    Effect_shipMissileThermalDamageAF1 = 1868,
    Effect_shipMissileKineticDamageAF1 = 1869,
    Effect_shipMissileExplosiveDamageAF1 = 1870,
    Effect_entityTargetJam = 1871,
    Effect_entityCapacitorDrain = 1872,
    Effect_entityTrackingDisrupt = 1877,
    Effect_entitySensorDampen = 1878,
    Effect_entityTargetPaint = 1879,
    Effect_miningYieldMultiplyPercent = 1882,
    Effect_shipCruiseLauncherROFBonus2CB = 1885,
    Effect_shipSiegeLauncherROFBonus2CB = 1886,
    Effect_caldariNavyBonusHybridDamage = 1894,
    Effect_miningUpgradeCPUReductionBonus = 1895,
    Effect_eliteBargeBonusIceHarvestingCycleTimeBarge3 = 1896,
    Effect_shieldCompensationSkillBoostHardeningBonus = 1897,
    Effect_caldariNavyBonusCPUEnhancerBonus = 1904,
    Effect_caldariNavyBonusShieldBooster = 1905,
    Effect_reconShipSkillMultiplier1 = 1908,
    Effect_reconShipSkillMultiplier2 = 1909,
    Effect_eliteBonusVampireDrainAmount2 = 1910,
    Effect_eliteReconBonusGravimetricStrength2 = 1911,
    Effect_eliteReconBonusMagnetometricStrength2 = 1912,
    Effect_eliteReconBonusRadarStrength2 = 1913,
    Effect_eliteReconBonusLadarStrength2 = 1914,
    Effect_eliteReconEnergyVampireRangeBonus1 = 1920,
    Effect_eliteReconStasisWebBonus2 = 1921,
    Effect_eliteReconJumpScramblerRangeBonus2 = 1922,
    Effect_setActiveDamageResonanceMultiplier = 1938,
    Effect_ammoEMResistOther = 1943,
    Effect_armorReinforcerMassAdd = 1959,
    Effect_signatureRadiusBonus = 1962,
    Effect_shipCargoBonusMF2 = 1963,
    Effect_shipBonusShieldTransferCapneed1 = 1964,
    Effect_shipBonusEnergyTransferCapNeed1 = 1965,
    Effect_shipBonusTrackingLinkMC1 = 1968,
    Effect_shipBonusRemoteArmorRepairCapNeedGC1 = 1969,
    Effect_caldariShipEwCapacitorNeedCF2 = 1996,
    Effect_droneRangeBonusAdd = 2000,
    Effect_droneDamageMultiplierBonusPercent = 2003,
    Effect_droneTrackingComputerMultiply = 2007,
    Effect_cynosuralDurationBonus = 2008,
    Effect_reconShipCpuMultiplier1 = 2009,
    Effect_propulsionDroneJammingStrength = 2010,
    Effect_droneMaxVelocitySkillBonus = 2011,
    Effect_droneMaxVelocityBonus = 2013,
    Effect_droneMaxRangeBonus = 2014,
    Effect_droneDurabilityShieldCapBonus = 2015,
    Effect_droneDurabilityArmorHPBonus = 2016,
    Effect_droneDurabilityHPBonus = 2017,
    Effect_damageRepairedSkillBonus = 2018,
    Effect_repairDroneShieldBonusBonus = 2019,
    Effect_repairDroneArmorDamageAmountBonus = 2020,
    Effect_addToSignatureRadius2 = 2029,
    Effect_modifyArmorResonancePostPercent = 2041,
    Effect_modifyShieldResonancePostPercent = 2052,
    Effect_emShieldCompensationHardeningBonusGroupShieldAmp = 2053,
    Effect_explosiveShieldCompensationHardeningBonusGroupShieldAmp = 2054,
    Effect_kineticShieldCompensationHardeningBonusGroupShieldAmp = 2055,
    Effect_thermalShieldCompensationHardeningBonusGroupShieldAmp = 2056,
    Effect_shieldCompensationSkillBoostHardeningBonus2 = 2062,
    Effect_empWaveGrid = 2071,
    Effect_modifyArmorResonancePassivePostPercent = 2084,
    Effect_modifyActiveArmorResonanceAndNullifyPassiveResonance = 2098,
    Effect_emArmorCompensationHardeningBonusGroupArmorCoating = 2105,
    Effect_explosiveArmorCompensationHardeningBonusGroupArmorCoating = 2106,
    Effect_kineticArmorCompensationHardeningBonusGroupArmorCoating = 2107,
    Effect_thermicArmorCompensationHardeningBonusGroupArmorCoating = 2108,
    Effect_emArmorCompensationHardeningBonusGroupEnergized = 2109,
    Effect_explosiveArmorCompensationHardeningBonusGroupEnergized = 2110,
    Effect_kineticArmorCompensationHardeningBonusGroupEnergized = 2111,
    Effect_thermicArmorCompensationHardeningBonusGroupEnergized = 2112,
    Effect_passiveEmArmorResonanceBonusGroupArmorHardener2 = 2113,
    Effect_passiveKineticArmorResonanceBonusGroupArmorHardener2 = 2115,
    Effect_passiveThermicArmorResonanceBonusGroupArmorHardener2 = 2116,
    Effect_modifyShieldResonancePassivePostPercent = 2117,
    Effect_modifyActiveShieldResonanceAndNullifyPassiveResonance = 2118,
    Effect_passiveEmShieldResonanceBonusGroupArmorHardener2 = 2126,
    Effect_passiveExplosiveShieldResonanceBonusGroupArmorHardener2 = 2127,
    Effect_passiveKineticShieldResonanceBonusGroupArmorHardener2 = 2128,
    Effect_passiveThermicShieldResonanceBonusGroupArmorHardener2 = 2129,
    Effect_smallHybridMaxRangeBonus = 2130,
    Effect_smallEnergyMaxRangeBonus = 2131,
    Effect_smallProjectileMaxRangeBonus = 2132,
    Effect_energyTransferArrayMaxRangeBonus = 2133,
    Effect_shieldTransporterMaxRangeBonus = 2134,
    Effect_armorRepairProjectorMaxRangeBonus = 2135,
    Effect_trackingLinkMaxRangeBonus = 2136,
    Effect_dreadnoughShipBonusDroneShieldCapG2 = 2140,
    Effect_dreadnoughShipBonusDroneArmorHPG2 = 2141,
    Effect_dreadnoughShipBonusDroneStructureHPG2 = 2142,
    Effect_minmatarShipEwTargetPainterMC2 = 2143,
    Effect_droneDamageBonusRequringDrones = 2148,
    Effect_jumpPortalGeneration = 2152,
    Effect_eliteBonusCommandShipProjectileDamageCS1 = 2155,
    Effect_eliteBonusCommandShipProjectileFalloffCS2 = 2156,
    Effect_eliteBonusCommandShipLaserDamageCS1 = 2157,
    Effect_eliteBonusCommandShipLaserROFCS2 = 2158,
    Effect_eliteBonusCommandShipHybridDamageCS1 = 2159,
    Effect_eliteBonusCommandShipHybridFalloffCS2 = 2160,
    Effect_eliteBonusCommandShipHybridOptimalCS1 = 2161,
    Effect_eliteBonusCommandShipSiegeCS2 = 2162,
    Effect_eliteBonusCommandShipProjectileTrackingCS1 = 2163,
    Effect_eliteBonusCommandShipSkirmishCS2 = 2164,
    Effect_eliteBonusCommandShipArmoredCS2 = 2166,
    Effect_eliteBonusCommandShipInfoCS2 = 2168,
    Effect_shipBonusDroneHitpointsGC2 = 2179,
    Effect_shipBonusDroneHitpointsFixedAC2 = 2181,
    Effect_shipBonusDroneHitpointsGB2 = 2186,
    Effect_shipBonusDroneDamageMultiplierGB2 = 2187,
    Effect_shipBonusDroneDamageMultiplierGC2 = 2188,
    Effect_shipBonusDroneDamageMultiplierAC2 = 2189,
    Effect_dreadnoughtShipBonusDroneDamageMultiplierG2 = 2190,
    Effect_shipMissileVelocityDF1 = 2191,
    Effect_entityShieldBoostingSmall = 2192,
    Effect_entityShieldBoostingMedium = 2193,
    Effect_entityShieldBoostingLarge = 2194,
    Effect_entityArmorRepairingSmall = 2195,
    Effect_entityArmorRepairingMedium = 2196,
    Effect_entityArmorRepairingLarge = 2197,
    Effect_eliteBonusInterdictorsMissileThermalDamage1 = 2199,
    Effect_eliteBonusInterdictorsMissileKineticDamage1 = 2200,
    Effect_eliteBonusInterdictorsProjectileFalloff1 = 2201,
    Effect_droneDmgBonusRequiringScoutDroneOP = 2202,
    Effect_shipBonusPirateFrigateProjDamage = 2215,
    Effect_navigationComputerWarpAccuracyBonus = 2218,
    Effect_warpNavigationWarpAccuracyBonus = 2221,
    Effect_warpNavigationWarpAccuracySkillLevel = 2224,
    Effect_scanStrengthBonusPercentActivate = 2231,
    Effect_scanStrengthBonusPercentOnline = 2232,
    Effect_scanStrengthTargetPercentBonus = 2246,
    Effect_dronesMaxActiveDroneBonusModAddMaxActiveActive = 2247,
    Effect_shipBonusDroneMiningAmountAC2 = 2249,
    Effect_shipBonusDroneMiningAmountGC2 = 2250,
    Effect_commandshipMultiRelayEffect = 2251,
    Effect_covertOpsAndReconOpsCloakModuleDelayBonus = 2252,
    Effect_covertOpsStealthBomberTargettingDelayBonus = 2253,
    Effect_passiveExplosiveArmorResonanceBonusGroupArmorHardener2FIXED = 2254,
    Effect_tractorBeamCan = 2255,
    Effect_shipMissilePrecisionDF2 = 2256,
    Effect_eliteBonusInterdictorsBubbleRoF2 = 2257,
    Effect_eliteBargeMercoxiteCrystalBonus1 = 2258,
    Effect_eliteBargeBonusDamageCloudReduction2 = 2259,
    Effect_titanMinmatarProjectileRoF1 = 2261,
    Effect_titanAmarrEnergyTurretCapNeed1 = 2263,
    Effect_titanAmarrGangCapRecharge2 = 2264,
    Effect_titanCaldariMissileKineticDmg1 = 2265,
    Effect_titanCaldariGangShieldHp2 = 2266,
    Effect_titanGallenteHybridDamage1 = 2267,
    Effect_titanGallenteGangArmorHp2 = 2268,
    Effect_titanAmarrSkillLevel1 = 2287,
    Effect_titanAmarrSkillLevel2 = 2288,
    Effect_titanCaldariSkillLevel1 = 2289,
    Effect_titanCaldariSkillLevel2 = 2290,
    Effect_titanGallenteSkillLevel1 = 2291,
    Effect_titanGallenteSkillLevel2 = 2292,
    Effect_titanMinmatarSkillLevel2 = 2293,
    Effect_titanMinmatarSkillLevel1 = 2294,
    Effect_modifyArmorResonancePassivePostPercentPassive = 2296,
    Effect_modifyShieldResonancePassivePostPercentPassive = 2297,
    Effect_scanStrengthBonusPercentPassive = 2298,
    Effect_damageControl = 2302,
    Effect_energyDestabilizationNew = 2303,
    Effect_energyNosferatu = 2304,
    Effect_eliteReconBonusEnergyNeutAmount2 = 2305,
    Effect_eliteReconBonusEnergyNeutRange1 = 2306,
    Effect_eliteReconBonusAssaultLauncherROF1 = 2308,
    Effect_droneMWDBoostOnline = 2309,
    Effect_skillADDmaxJumpClones = 2311,
    Effect_disallowOffensiveActChar = 2312,
    Effect_carrierAmarrSkillLevel1 = 2313,
    Effect_carrierAmarrSkillLevel2 = 2314,
    Effect_carrierAmarrSkillLevel3 = 2315,
    Effect_carrierCaldariSkillLevel1 = 2316,
    Effect_carrierCaldariSkillLevel2 = 2317,
    Effect_carrierCaldariSkillLevel3 = 2318,
    Effect_carrierGallenteSkillLevel1 = 2319,
    Effect_carrierGallenteSkillLevel2 = 2320,
    Effect_carrierGallenteSkillLevel3 = 2321,
    Effect_carrierMinmatarSkillLevel1 = 2322,
    Effect_carrierMinmatarSkillLevel2 = 2323,
    Effect_carrierMinmatarSkillLevel3 = 2324,
    Effect_carrierAmarrDroneMax1 = 2325,
    Effect_carrierCaldariDroneMax1 = 2326,
    Effect_carrierGallenteDroneMax1 = 2327,
    Effect_carrierMinmatarDroneMax1 = 2328,
    Effect_carrierGallenteDroneOwnDmg2 = 2332,
    Effect_cloneJumpAcceptingTmp = 2334,
    Effect_titanMinmatarGangSigRadius2 = 2335,
    Effect_titanAmarrSkillLevel3 = 2336,
    Effect_titanAmarrSkillLevel4 = 2337,
    Effect_titanCaldariSkillLevel3 = 2338,
    Effect_titanCaldariSkillLevel4 = 2339,
    Effect_titanGallenteSkillLevel3 = 2340,
    Effect_titanGallenteSkillLevel4 = 2341,
    Effect_titanMinmatarSkillLevel3 = 2342,
    Effect_titanMinmatarSkillLevel4 = 2343,
    Effect_carrierAmarrSkillLevel4 = 2344,
    Effect_carrierCaldariSkillLevel4 = 2345,
    Effect_carrierGallenteSkillLevel4 = 2346,
    Effect_titanAmarrLaserDmg3 = 2347,
    Effect_titanAmarrLeadershipModuleAmount4 = 2348,
    Effect_titanCaldariLeadershipModuleAmount4 = 2349,
    Effect_titanGallenteLeadershipModuleAmount4 = 2350,
    Effect_titanMinmatarLeadershipModuleAmount4 = 2351,
    Effect_titanCaldariLauncherRoF3 = 2352,
    Effect_titanMinmatarProjectileDmg3 = 2353,
    Effect_capitalRemoteArmorRepairerCapNeedBonusSkill = 2354,
    Effect_capitalRemoteShieldTransferCapNeedBonusSkill = 2355,
    Effect_capitalRemoteEnergyTransferCapNeedBonusSkill = 2356,
    Effect_carrierMinmatarArmor_ShieldTransferDuration2 = 2359,
    Effect_carrierAmarrLeadershipMaxGroupActive4 = 2360,
    Effect_carrierCaldariLeadershipMaxGroupActive4 = 2361,
    Effect_carrierGallenteLeadershipMaxGroupActive4 = 2362,
    Effect_carrierMinmatarLeadershipMaxGroupActive4 = 2363,
    Effect_carrierMinmatarSkillLevel4 = 2364,
    Effect_carrierAmarrArmorResist2 = 2371,
    Effect_carrierCaldariShieldResist2 = 2378,
    Effect_carrierAmarrArmor_EnergyTransferRange3 = 2381,
    Effect_carrierCaldariShield_EnergyTransferRange3 = 2384,
    Effect_carrierGallenteArmor_ShieldTransferRange3 = 2387,
    Effect_carrierMinmatarArmor_ShieldTransferRange3 = 2390,
    Effect_iceHarvesterMiningAmountBonusMultiplier = 2392,
    Effect_titanJumpPortalCpuNeedBonus = 2393,
    Effect_titanAmarrJudgmentCpuNeedBonus = 2394,
    Effect_jumpPortalConsumptionBonusSkill = 2395,
    Effect_skillSuperWeaponDmgBonus = 2402,
    Effect_dreadnoughtSiegeModeCpuNeedBonus = 2403,
    Effect_carrierFighterControlRangeBonus = 2406,
    Effect_interdictorBubbleProbeLauncherCpuBonus = 2407,
    Effect_eliteBonusCommandShipMissileKineticDamageCS1 = 2408,
    Effect_eliteBonusInterdictorsMissileEMDamage1 = 2409,
    Effect_cloneVatMaxJumpCloneBonusSkill = 2410,
    Effect_cloneVatMaxJumpCloneBonusSkillLevel = 2411,
    Effect_cloneVatCpuNeedBonus = 2412,
    Effect_snowBallLaunching = 2413,
    Effect_gangShieldBoosterAndTransporterSpeed = 2415,
    Effect_gangShieldBoosteAndTransporterCapacitorNeed = 2418,
    Effect_titanCaldariOblivionCpuNeed = 2419,
    Effect_titanGallenteAuroraOminaeCpuNeed = 2420,
    Effect_titanMinmatarFirestormCpuNeed = 2421,
    Effect_implantVelocityBonus = 2422,
    Effect_eliteReconHeavyMissileKineticDamage1 = 2423,
    Effect_eliteReconLightMissileKineticDamage1 = 2424,
    Effect_skillInterdictorEliteBonus1SkillLevel = 2426,
    Effect_skillInterdictorEliteBonus2SkillLevel = 2427,
    Effect_advancedDroneInterfacingMaxGroupDCUSkillLevel = 2429,
    Effect_maxVelocityMultiplier = 2430,
    Effect_energyManagementSkillBoostCapacitorCapacityBonus = 2431,
    Effect_energyManagementCapacitorBonusPostPercentCapacityLocationShipGroupCapacitorCapacityBonus = 2432,
    Effect_fightersDmgBonusSkills = 2434,
    Effect_cpuPenaltyToSuperWeapons = 2435,
    Effect_cpuBonusToSelf = 2436,
    Effect_miningYieldGangBonusFixed = 2437,
    Effect_gangIceHarvestingDurationBonus = 2441,
    Effect_minerCpuUsageMultiplyPercent2 = 2444,
    Effect_iceMinerCpuUsagePercent = 2445,
    Effect_eliteeliteBonusCommandShipDroneBay1 = 2449,
    Effect_commandShipSkillMultiplier1 = 2451,
    Effect_commandShipSkillMultiplier2 = 2452,
    Effect_eliteBonusCommandShipLaserOptimalCS1FIXED = 2453,
    Effect_shipBonusMiningDroneAmountPercentGC2 = 2454,
    Effect_vanHelsing = 2455,
    Effect_miningUpgradeCPUPenaltyReductionModulesRequiringMiningUpgradePercent = 2456,
    Effect_gangMiningDroneYieldBonus = 2458,
    Effect_shipBonusArmorResistAB = 2465,
    Effect_shipLaserDamageBonusBC2 = 2467,
    Effect_shipHeavyLauncherROFBC1 = 2468,
    Effect_shipAssaultLauncherROFBC1 = 2469,
    Effect_shipBonusDroneDamageMultiplierBC1 = 2473,
    Effect_shipBonusDroneHitpointsBC1 = 2478,
    Effect_iceHarvestCycleTimeModulesRequiringIceHarvestingOnline = 2479,
    Effect_decreaseTargetSpeedForStructures = 2480,
    Effect_warpScrambleForStructure = 2481,
    Effect_implantArmorHpBonus2 = 2485,
    Effect_armorTankingGang2 = 2486,
    Effect_skirmishWarfareVelocityBonus2 = 2487,
    Effect_implantVelocityBonus2 = 2488,
    Effect_shipTrackingLinkRange1Fixed = 2489,
    Effect_shipTrackingLinkRange2Group = 2490,
    Effect_ewSkillEcmBurstRangeBonus = 2491,
    Effect_ewSkillEcmBurstCapNeedBonus = 2492,
    Effect_eliteBonusCommandShipsMissilePrecisionCS2 = 2494,
    Effect_eliteReconBonusHeavyLauncherROF1 = 2496,
    Effect_shipLauncherRofBonusMB1 = 2502,
    Effect_shipHTTrackingBonusGB2 = 2503,
    Effect_shipBonusHybridTrackingGF2 = 2504,
    Effect_droneControlUnitCpuNeedBonus = 2507,
    Effect_gangMiningLaserDurationBonus = 2508,
    Effect_armorRepairAmountBonusPassive = 2523,
    Effect_hybridTurretTrackingBonusPassiveTrackingSpeedMultiplier = 2524,
    Effect_shipBonusShieldBoosterMB1 = 2525,
    Effect_shieldCapacityPenaltyPostPercentBoosterAttribute1 = 2537,
    Effect_capacitorCapacityPenaltyBoosterAttribute2 = 2540,
    Effect_turretOptimalRangePenaltyBoosterAttribute4 = 2543,
    Effect_explosionVelocityPenaltyBoosterAttribute5 = 2546,
    Effect_shieldBoostAmpPenaltyBoosterAttribute1 = 2549,
    Effect_maximumVelocityPenaltyBoosterAttribute2 = 2552,
    Effect_armorHpPenaltyBoosterAttribute3 = 2555,
    Effect_missileVelocityPenaltyBoosterAttribute5 = 2558,
    Effect_eliteBonusAssaultShipMissileVelocity1 = 2561,
    Effect_turretFalloffPenaltyBoosterAttribute4 = 2565,
    Effect_turretTrackingPenaltyBoosterAttribute4 = 2568,
    Effect_aoeCloudSizePenaltyBoosterAttribute5 = 2571,
    Effect_torpedoLaunchingIsOffensive = 2576,
    Effect_armorRepairerPenaltyBoosterAttribute3 = 2577,
    Effect_neurotoxinRecoverySkillBoostChanceBonus = 2580,
    Effect_modifyBoosterEffectChanceWithBoosterChanceBonusPostPercent = 2589,
    Effect_naniteControlSkillBoostBoosterAttributeModifier = 2590,
    Effect_modifyBoosterAttributePostPercent = 2599,
    Effect_shieldBoostAmplifierPassiveLocationGroup = 2600,
    Effect_shipBonusEmShieldResistanceCB2 = 2602,
    Effect_shipBonusExplosiveShieldResistanceCB2 = 2603,
    Effect_shipBonusKineticShieldResistanceCB2 = 2604,
    Effect_shipBonusThermicShieldResistanceCB2 = 2605,
    Effect_scanGravimetricStrengthBonus = 2606,
    Effect_scanRadarStrengthBonusPercentageScanStrengthBonus = 2607,
    Effect_scanLadarStrengthBonusPercentageScanStrengthBonus = 2608,
    Effect_scanMagnetometricStrengthBonusPercentageScanStrengthBonus = 2609,
    Effect_eliteBonusGunshipProjectileDamage1 = 2611,
    Effect_eliteBonusGunshipProjectileDamage2 = 2612,
    Effect_eliteBonusGunshipLaserDamage1 = 2613,
    Effect_gangInformationWarStrengthBonus = 2641,
    Effect_gangInformationWarfareRangeBonus = 2642,
    Effect_massReductionBonus = 2643,
    Effect_increaseSignatureRadiusOnline = 2644,
    Effect_scanResolutionMultiplierOnline = 2645,
    Effect_maxTargetRangeBonus = 2646,
    Effect_eliteBonusHeavyGunshipHeavyMissileLaunhcerRof2 = 2647,
    Effect_eliteBonusHeavyGunshipHeavyAssaultMissileLaunhcerRof2 = 2648,
    Effect_eliteBonusHeavyGunshipAssaultMissileLaunhcerRof2 = 2649,
    Effect_missileProjectionComputerBonus = 2653,
    Effect_skillAstrometricsMaxGroupScanningBonusSkillLevel = 2654,
    Effect_scanStrengthBonusSkillLevelIncrease = 2656,
    Effect_scanGravimetricStrengthBonusRequringAstrometrics = 2657,
    Effect_scanProbeSpeedBonusRequiringAstrometrics = 2658,
    Effect_scanMagnetometricStrengthBonusRequringAstrometrics = 2659,
    Effect_scanLadarStrengthBonusRequringAstrometrics = 2660,
    Effect_scanRadarStrengthBonusRequringAstrometrics = 2661,
    Effect_entityEnvironmentalEffectDamageTest = 2662,
    Effect_rigSlot = 2663,
    Effect_ewCapNeedPercentageModifier = 2664,
    Effect_sensorBoosterActivePercentage = 2670,
    Effect_maxTargetRangePremulModifier = 2671,
    Effect_scanResolutionPremulModifier = 2672,
    Effect_shipBonusProjectileDamageBC1 = 2674,
    Effect_shipHeavyAssaultLaunhcerROFBC1 = 2675,
    Effect_shipCruiserSizedLauncherROFBC1 = 2682,
    Effect_addMedSlot = 2683,
    Effect_shipBonusArmorRepairAmountGB2 = 2687,
    Effect_capNeedBonusEffectLasers = 2688,
    Effect_capNeedBonusEffectHybrids = 2689,
    Effect_cpuNeedBonusEffectLasers = 2690,
    Effect_cpuNeedBonusEffectHybrid = 2691,
    Effect_cpuNeedBonusEffectProjectile = 2692,
    Effect_falloffBonusEffectLasers = 2693,
    Effect_falloffBonusEffectHybrids = 2694,
    Effect_falloffBonusEffectProjectiles = 2695,
    Effect_maxRangeBonusEffectLasers = 2696,
    Effect_maxRangeBonusEffectHybrids = 2697,
    Effect_maxRangeBonusEffectProjectiles = 2698,
    Effect_trackingSpeedMultiplierEffectLasers = 2699,
    Effect_trackingSpeedMultiplierEffectHybrids = 2700,
    Effect_trackingSpeedMultiplierEffectProjectiles = 2701,
    Effect_salvagingAccessDifficultyBonusEffect = 2702,
    Effect_drawbackPowerNeedLasers = 2706,
    Effect_drawbackPowerNeedHybrids = 2707,
    Effect_drawbackPowerNeedProjectiles = 2708,
    Effect_drawbackPowerNeedLaunchers = 2709,
    Effect_drawbackPowerNeedGunnery = 2710,
    Effect_drawbackArmorHP = 2712,
    Effect_drawbackCPUOutput = 2713,
    Effect_drawbackCPUNeedLaunchers = 2714,
    Effect_drawbackCPUNeedGunnery = 2715,
    Effect_drawbackSigRad = 2716,
    Effect_drawbackMaxVelocity = 2717,
    Effect_drawbackShieldCapacity = 2718,
    Effect_drawbackShieldUniformity = 2719,
    Effect_drawbackCapacitorCapacity = 2720,
    Effect_drawbackPowerOutput = 2721,
    Effect_drawbackROFGunnery = 2722,
    Effect_drawbackROFLaunchers = 2723,
    Effect_rigDrawbackBonusEffect = 2724,
    Effect_rigDrawbackSkillEffect = 2725,
    Effect_miningClouds = 2726,
    Effect_gasCloudHarvestingMaxGroupSkillLevel = 2727,
    Effect_shipECMScanStrengthBonusCF = 2734,
    Effect_boosterArmorHpPenalty = 2735,
    Effect_boosterArmorRepairAmountPenalty = 2736,
    Effect_boosterShieldCapacityPenalty = 2737,
    Effect_boosterShieldBoostAmountPenalty = 2738,
    Effect_boosterTurretOptimalRangePenalty = 2739,
    Effect_boosterTurretFalloffPenalty = 2741,
    Effect_boosterMissileExplosionCloudPenalty = 2743,
    Effect_boosterCapacitorCapacityPenalty = 2745,
    Effect_boosterMaxVelocityPenalty = 2746,
    Effect_boosterTurretTrackingPenalty = 2747,
    Effect_boosterMissileVelocityPenalty = 2748,
    Effect_boosterMissileExplosionVelocityPenalty = 2749,
    Effect_shipBonusECMGravimetricStrengthBonusCC = 2750,
    Effect_shipBonusECMMagnetometricStrengthBonusCC = 2751,
    Effect_shipBonusECMRadarBonusCC = 2752,
    Effect_shipBonusECMLadarBonusCC = 2753,
    Effect_shipBonusECMRadarLadarBonusCC = 2754,
    Effect_shipBonusECMGraviMagnetoMetricBonusCC = 2755,
    Effect_shipBonusECMStrengthBonusCC = 2756,
    Effect_salvaging = 2757,
    Effect_boosterModifyBoosterArmorHPPenalty = 2758,
    Effect_boosterModifyBoosterArmorRepairAmountPenalty = 2759,
    Effect_boosterModifyBoosterArmorPenalties = 2760,
    Effect_boosterModifyBoosterShieldCapacityPenalty = 2761,
    Effect_boosterModifyBoosterShieldBoostAmountPenalty = 2762,
    Effect_boosterModifyBoosterShieldPenalty = 2763,
    Effect_boosterModifyBoosterCapacitorCapacitorPenalty = 2764,
    Effect_boosterModifyBoosterMaxVelocityPenalty = 2765,
    Effect_boosterModifyBoosterMaxVelocityAndCapacitorPenalty = 2766,
    Effect_boosterModifyBoosterAOEVelocityPenalty = 2767,
    Effect_boosterModifyBoosterMissileAOECloudPenalty = 2768,
    Effect_boosterModifyBoosterMissileVelocity = 2769,
    Effect_boosterModifyBoosterTurretFalloffPenalty = 2770,
    Effect_boosterModifyBoosterTurretOptimalPenalty = 2771,
    Effect_boosterModifyBoosterTurretTrackingPenalty = 2772,
    Effect_boosterModifyBoosterMissileAOEPenalty = 2775,
    Effect_boosterModifyBoosterMissilePenalty = 2776,
    Effect_boosterModifyBoosterTurretTrackingOptimalPenalty = 2777,
    Effect_boosterModifyBoosterTurretPenalty = 2778,
    Effect_shipLaserCapABC = 2779,
    Effect_maxVelocityBonusModifier = 2780,
    Effect_shipBonusMiningDroneAmountPercentAC2 = 2783,
    Effect_bcsEmDamageBonus = 2784,
    Effect_bcuExDamageBonus = 2785,
    Effect_bcuThDamageBonus = 2786,
    Effect_bcuKnDamageBonus = 2787,
    Effect_bcuKnThDamageBonus = 2788,
    Effect_bcuEmExDamageBonus = 2789,
    Effect_bcuDamageBonus = 2790,
    Effect_boosterMissileExplosionCloudPenaltyFixed = 2791,
    Effect_modifyArmorResonancePostPercentPassive = 2792,
    Effect_salvagingAccessDifficultyBonusEffectPassive = 2794,
    Effect_modifyShieldResonancePostPercentPassive = 2795,
    Effect_massReductionBonusPassive = 2796,
    Effect_projectileWeaponSpeedMultiplyPassive = 2797,
    Effect_projectileWeaponDamageMultiplyPassive = 2798,
    Effect_missileLauncherSpeedMultiplierPassive = 2799,
    Effect_energyWeaponSpeedMultiplyPassive = 2801,
    Effect_hybridWeaponDamageMultiplyPassive = 2802,
    Effect_energyWeaponDamageMultiplyPassive = 2803,
    Effect_hybridWeaponSpeedMultiplyPassive = 2804,
    Effect_shipBonusLargeEnergyWeaponDamageAB2 = 2805,
    Effect_maxRangeBonusEffectHybridsMultiplier = 2806,
    Effect_maxRangeBonusEffectLasersMultiplier = 2807,
    Effect_maxRangeBonusEffectProjectilesMultiplier = 2808,
    Effect_shipMissileAssaultMissileVelocityBonusCC2 = 2809,
    Effect_eliteBonusHeavyGunshipAssaultMissileFlightTime1 = 2810,
    Effect_cpuPenaltyToScanProbeLaunchers = 2811,
    Effect_caldariShipECMBurstOptimalRangeCB3 = 2812,
    Effect_shipBonusSurveyProbeExplosionDelaySkillSurveyCF = 2814,
    Effect_shipBonusSurveyProbeExplosionDelaySkillSurveyMF2 = 2817,
    Effect_shipBonusSurveyProbeExplosionDelaySkillSurveyGF2 = 2818,
    Effect_shipBonusSurveyProbeExplosionDelaySkillSurveyCovertOps2 = 2819,
    Effect_maxScanDeviationSelfSkillModifier = 2820,
    Effect_maxScanDeviationModifierRequireingAstrometrics = 2821,
    Effect_commandBonus2MultiplyWithCommandBonus = 2822,
    Effect_gangInformationSensorDisruptorMaxTargetingRangeStrengthBonus = 2823,
    Effect_gangInformationSensorDisruptorScanResStrengthBonus = 2824,
    Effect_gangInformationSensorDisruptorTrackingDisruptorTrackingSpeedBonus = 2825,
    Effect_gangInformationSensorDisruptorTrackingDisruptorMaxRangeBonus = 2826,
    Effect_gangInformationTargetPainterSigRadBonus = 2827,
    Effect_gangInformationSensorDisruptorBonus = 2828,
    Effect_gangInformationTrackingDisruptorBonus = 2829,
    Effect_gangInformationTrackingSensorDisruptorBonus = 2830,
    Effect_gangInformationTrackingSensorDisruptorTargetPainterBonus = 2831,
    Effect_shieldBoosterDurationBonus = 2832,
    Effect_gangInformationSensorTrackingDisruptorTargetPainter = 2833,
    Effect_gangInformationAllEWARStrengthBonuses = 2834,
    Effect_shipMissileVelocityPirateFactionHeavyAssault = 2835,
    Effect_eliteBonusInterdictorsInterdictionSphereLauncherReactivationDelay2 = 2836,
    Effect_armorHPBonusAdd = 2837,
    Effect_shipShieldEmExplosiveResistanceCBC2 = 2838,
    Effect_shipShieldKineticThermalResistanceCBC2 = 2839,
    Effect_shipShieldResistanceCBC2 = 2840,
    Effect_shipBonusHeavyMissileKineticDamageBC1 = 2841,
    Effect_shipBonusHeavyAssaultMissileKineticDamageBC1 = 2842,
    Effect_shipBonusStandardMissileKineticDamageBC1 = 2843,
    Effect_shipBonusHeavyAssaultStandardMissileKineticDamageBC1 = 2844,
    Effect_shipBonusCruiserSizedMissileKineticDamageBC1 = 2845,
    Effect_skillBoostTrackingSpeedBonus = 2846,
    Effect_trackingSpeedBonusPassiveRequiringGunneryTrackingSpeedBonus = 2847,
    Effect_accessDifficultyBonusModifierRequiringArchaelogy = 2848,
    Effect_accessDifficultyBonusModifierRequiringHacking = 2849,
    Effect_durationBonusForGroupAfterburner = 2850,
    Effect_missileDMGBonusPassive = 2851,
    Effect_maxTargetingRangeBonusPremulPassive = 2852,
    Effect_cloakingTargetingDelayBonusLRSMCloakingPassive = 2853,
    Effect_scanResolutionBonusMultiplierPreMulPassive = 2854,
    Effect_eliteReconBonusHeavyAssaultLauncherROF1 = 2855,
    Effect_setCanCloak = 2856,
    Effect_cynosuralGeneration = 2857,
    Effect_cloneJumpAccepting = 2858,
    Effect_modifyMaxVelocityOfShipOnline = 2859,
    Effect_agilityMultiplierOnTarget = 2861,
    Effect_testStasisWebifierEffect = 2862,
    Effect_agilityBonusOnTargetPercentage = 2863,
    Effect_newTestStasisWebifierEffect = 2864,
    Effect_velocityBonusOnline = 2865,
    Effect_biologyTimeBonusFixed = 2866,
    Effect_sentryDroneDamageBonus = 2867,
    Effect_armorDamageAmountBonusCapitalArmorRepairers = 2868,
    Effect_droneStasisWebifyingBonus = 2869,
    Effect_defenderMissileVelocityBonus = 2870,
    Effect_defenderMissileVelocityBonus2 = 2871,
    Effect_missileVelocityBonusDefender = 2872,
    Effect_missileEMDmgBonusCruise = 2873,
    Effect_missileExplosiveDmgBonusCruise = 2874,
    Effect_missileKineticDmgBonusCruise = 2875,
    Effect_missileThermalDmgBonusCruise = 2876,
    Effect_missileEMDmgBonusCruise2 = 2877,
    Effect_missileExplosiveDmgBonusCruise2 = 2878,
    Effect_missileKineticDmgBonusCruise2 = 2879,
    Effect_missileThermalDmgBonusCruise2 = 2880,
    Effect_missileEMDmgBonusCruise3 = 2881,
    Effect_missileExplosiveDmgBonusCruise3 = 2882,
    Effect_missileKineticDmgBonusCruise3 = 2883,
    Effect_missileThermalDmgBonusCruise3 = 2884,
    Effect_gasHarvestingCycleTimeModulesRequiringGasCloudHarvesting = 2885,
    Effect_setMaxLockedTargets = 2886,
    Effect_missileEMDmgBonusRocket = 2887,
    Effect_missileExplosiveDmgBonusRocket = 2888,
    Effect_missileKineticDmgBonusRocket = 2889,
    Effect_missileThermalDmgBonusRocket = 2890,
    Effect_missileEMDmgBonusStandard = 2891,
    Effect_missileExplosiveDmgBonusStandard = 2892,
    Effect_missileKineticDmgBonusStandard = 2893,
    Effect_missileThermalDmgBonusStandard = 2894,
    Effect_missileEMDmgBonusFOF = 2895,
    Effect_missileExplosiveDmgBonusFOF = 2896,
    Effect_missileKineticDmgBonusFOF = 2897,
    Effect_missileThermalDmgBonusFOF = 2898,
    Effect_missileEMDmgBonusHeavy = 2899,
    Effect_missileExplosiveDmgBonusHeavy = 2900,
    Effect_missileKineticDmgBonusHeavy = 2901,
    Effect_missileThermalDmgBonusHeavy = 2902,
    Effect_missileEMDmgBonusHAM = 2903,
    Effect_missileExplosiveDmgBonusHAM = 2904,
    Effect_missileKineticDmgBonusHAM = 2905,
    Effect_missileThermalDmgBonusHAM = 2906,
    Effect_missileEMDmgBonusTorpedo = 2907,
    Effect_missileExplosiveDmgBonusTorpedo = 2908,
    Effect_missileKineticDmgBonusTorpedo = 2909,
    Effect_missileThermalDmgBonusTorpedo = 2910,
    Effect_dataminerModuleDurationReduction = 2911,
    Effect_energyDestabilizationNewForStructure = 2912,
    Effect_remoteEcmBurst = 2913,
    Effect_warpScrambleSelfSiegeModeWarpStatus = 2915,
    Effect_posStructureControlAmountBonus = 2918,
    Effect_triageModeWarpScrambleSelf = 2919,
    Effect_triageModeMaxVelocityBonus = 2924,
    Effect_triageModeSitDown = 2925,
    Effect_triageModeArmorAmount = 2928,
    Effect_triageModeArmorDuration = 2929,
    Effect_triageModeShieldAmount = 2931,
    Effect_triageModeShieldDuration = 2932,
    Effect_triageModeSiegeTankArmor = 2933,
    Effect_triageModeSiegeTankShield = 2934,
    Effect_triageModeSiegeTank = 2935,
    Effect_triageModeLogisticsArmorAmount = 2936,
    Effect_triageModeLogisticsArmorDuration = 2937,
    Effect_triageModeLogisticsArmor = 2938,
    Effect_triageModeLogisticsShieldAmount = 2939,
    Effect_triageModeLogisticsShieldDuration = 2940,
    Effect_triageModeLogisticsShield = 2941,
    Effect_triageModeSensorEWCapNeedBonusECM = 2943,
    Effect_triageModeSensorEWCapNeedBonusRSD = 2944,
    Effect_triageModeSensorEWCapNeedBonusTD = 2945,
    Effect_triageModeSensorEWCapNeedBonusTP = 2946,
    Effect_triageModeSensorEWCapNeedBonusECMandRSD = 2947,
    Effect_triageModeSensorEWCapNeedBonusTDandTP = 2948,
    Effect_triageModeSensorEWCapNeedBonus = 2949,
    Effect_triageModeSensorPropJamCapNeedBonus = 2950,
    Effect_triageModeSensorCapNeedBonus = 2951,
    Effect_triageModeSensorScanResolutionMultiplier = 2953,
    Effect_triageModeSiegeTankAndSitDown = 2956,
    Effect_triageModeDroneBonus = 2959,
    Effect_skillTriageModuleConsumptionQuantityBonus = 2967,
    Effect_triageModeCpuBonus = 2968,
    Effect_bombLaunching = 2971,
    Effect_skillRemoteECMDurationBonusSkillLevel = 2974,
    Effect_projECMCpuNeedBonusEffect = 2976,
    Effect_skillRemoteHullRepairSystemsCapNeedBonus = 2977,
    Effect_skillRemoteHullRepairSystemsCapNeedBonus2 = 2979,
    Effect_skillCapitalRemoteHullRepairSystemsCapNeedBonus = 2980,
    Effect_skillRemoteECMDurationBonus = 2982,
    Effect_triageModeLogisticsHullAmount = 2983,
    Effect_triageModeLogisticsHullDuration = 2984,
    Effect_triageModeLogisticsEnergyAmount = 2985,
    Effect_triageModeLogisticsEnergyDuration = 2986,
    Effect_triageModeLogisticsEnergy = 2987,
    Effect_triageModeLogisticsHull = 2988,
    Effect_triageModeLogisticsEnergyAndHull = 2989,
    Effect_triageModeLogisticsArmorAndShield = 2990,
    Effect_triageModeLogistics = 2991,
    Effect_triageModeSensorMaxLockedTargetsBonus = 2992,
    Effect_triageModeSensorTargeting = 2994,
    Effect_overloadRofBonus = 3001,
    Effect_overloadSelfDurationBonus = 3002,
    Effect_energyDestabilizationForStructure = 3003,
    Effect_setGlobalPool = 3004,
    Effect_skillBombDeploymentSpeedBonus = 3014,
    Effect_eliteBonusStealhBomberBombDeploymentCpu = 3015,
    Effect_covertOpsAgilityBonus2 = 3016,
    Effect_eliteBonusCoverOpsBombExplosiveDmg1 = 3024,
    Effect_overloadSelfDamageBonus = 3025,
    Effect_eliteBonusCoverOpsBombKineticDmg1 = 3026,
    Effect_eliteBonusCoverOpsBombThermalDmg1 = 3027,
    Effect_eliteBonusCoverOpsBombEmDmg1 = 3028,
    Effect_overloadSelfEmHardeningBonus = 3029,
    Effect_overloadSelfThermalHardeningBonus = 3030,
    Effect_overloadSelfExplosiveHardeningBonus = 3031,
    Effect_overloadSelfKineticHardeningBonus = 3032,
    Effect_overloadSelfHardeningInvulnerabilityBonus = 3035,
    Effect_skillBombDeploymentModuleReactivationDelayBonus = 3036,
    Effect_missileDamageMultiplierCruiseEmBonus = 3037,
    Effect_missileDamageMultiplierCruiseThermalBonus = 3038,
    Effect_missileDamageMultiplierCruiseKineticBonus = 3039,
    Effect_missileDamageMultiplierCruiseExplosiveBonus = 3040,
    Effect_remoteHullRepair = 3041,
    Effect_triageModeSensor = 3042,
    Effect_triageModeLogisticsAndSensor = 3043,
    Effect_triageModeLogisticsAndSensorAndDrone = 3044,
    Effect_triageModeEffectWithoutECMBurst = 3045,
    Effect_modifyMaxVelocityOfShipPassive = 3046,
    Effect_structureHPMultiplyPassive = 3047,
    Effect_carrierMinmatarArmor_ShieldAmount = 3050,
    Effect_cpuPenaltyToBombLaunchers = 3052,
    Effect_cpuPenaltyToProjectedECM = 3053,
    Effect_triageModeSensorEWCapNeedBonusECMBurstECMBurst = 3055,
    Effect_triageModeSensorEWCapNeedBonusECMBurstRemoteECMBurst = 3056,
    Effect_triageModeSensorEWCapNeedBonusECMBurst = 3057,
    Effect_siegeModeEffectMaxTargetPenality = 3060,
    Effect_heatDamageBonus = 3061,
    Effect_siegeModeEffect = 3062,
    Effect_controlTowerGenericOutsideStructureResistanceBonus = 3063,
    Effect_controlTowerGenericHullEmResistanceBonusCynoGenerator = 3064,
    Effect_controlTowerGenericHullExplosiveResistanceBonusCynoGenerator = 3065,
    Effect_controlTowerGenericHullKineticResistanceBonusCynoGenerator = 3066,
    Effect_controlTowerGenericHullThermicResistanceBonusCynoGenerator = 3067,
    Effect_controlTowerGenericHullThermicResistanceBonusCynoJammer = 3068,
    Effect_controlTowerGenericHullKineticResistanceBonusCynoJammer = 3069,
    Effect_controlTowerGenericHullExplosiveResistanceBonusCynoJammer = 3070,
    Effect_controlTowerGenericHullEmResistanceBonusCynoJammer = 3071,
    Effect_controlTowerGenericHullEmResistanceBonusEcm = 3072,
    Effect_controlTowerGenericHullExplosiveResistanceBonusEcm = 3073,
    Effect_controlTowerGenericHullKineticResistanceBonusEcm = 3074,
    Effect_controlTowerGenericHullThermicResistanceBonusEcm = 3075,
    Effect_controlTowerGenericHullThermicResistanceBonusEnergyNeutralizer = 3076,
    Effect_controlTowerGenericHullKineticResistanceBonusEnergyNeutralizer = 3077,
    Effect_controlTowerGenericHullExplosiveResistanceBonusEnergyNeutralizer = 3078,
    Effect_controlTowerGenericHullEmResistanceBonusEnergyNeutralizer = 3079,
    Effect_controlTowerGenericHullEmResistanceBonusJumpPortal = 3080,
    Effect_controlTowerGenericHullExplosiveResistanceBonusJumpPortal = 3081,
    Effect_controlTowerGenericHullKineticResistanceBonusJumpPortal = 3082,
    Effect_controlTowerGenericHullThermicResistanceBonusJumpPortal = 3083,
    Effect_controlTowerGenericHullThermicResistanceBonusHybrid = 3084,
    Effect_controlTowerGenericHullKineticResistanceBonusHybrid = 3085,
    Effect_controlTowerGenericHullExplosiveResistanceBonusHybrid = 3086,
    Effect_controlTowerGenericHullEmResistanceBonusHybrid = 3087,
    Effect_controlTowerGenericHullEmResistanceBonusLaser = 3088,
    Effect_controlTowerGenericHullExplosiveResistanceBonusLaser = 3089,
    Effect_controlTowerGenericHullKineticResistanceBonusLaser = 3090,
    Effect_controlTowerGenericHullThermicResistanceBonusLaser = 3091,
    Effect_controlTowerGenericHullThermicResistanceBonusMissile = 3092,
    Effect_controlTowerGenericHullKineticResistanceBonusMissile = 3093,
    Effect_controlTowerGenericHullExplosiveResistanceBonusMissile = 3094,
    Effect_controlTowerGenericHullEmResistanceBonusMissile = 3095,
    Effect_controlTowerGenericHullEmResistanceBonusProjectile = 3096,
    Effect_controlTowerGenericHullExplosiveResistanceBonusProjectile = 3097,
    Effect_controlTowerGenericHullKineticResistanceBonusProjectile = 3098,
    Effect_controlTowerGenericHullThermicResistanceBonusProjectile = 3099,
    Effect_controlTowerGenericHullThermicResistanceBonusSensorDampener = 3100,
    Effect_controlTowerGenericHullKineticResistanceBonusSensorDampener = 3101,
    Effect_controlTowerGenericHullExplosiveResistanceBonusSensorDampener = 3102,
    Effect_controlTowerGenericHullEmResistanceBonusSensorDampener = 3103,
    Effect_controlTowerGenericHullEmResistanceBonusStasis = 3104,
    Effect_controlTowerGenericHullExplosiveResistanceBonusStasis = 3105,
    Effect_controlTowerGenericHullKineticResistanceBonusStasis = 3106,
    Effect_controlTowerGenericHullThermicResistanceBonusStasis = 3107,
    Effect_controlTowerGenericHullThermicResistanceBonusScrambler = 3108,
    Effect_controlTowerGenericHullKineticResistanceBonusScrambler = 3109,
    Effect_controlTowerGenericHullExplosiveResistanceBonusScrambler = 3110,
    Effect_controlTowerGenericHullEmResistanceBonusScrambler = 3111,
    Effect_controlTowerGenericHullE_EResistanceBonusCynoGenerator = 3112,
    Effect_controlTowerGenericHullE_EResistanceBonusCynoJammer = 3113,
    Effect_controlTowerGenericHullE_EResistanceBonusEcm = 3114,
    Effect_controlTowerGenericHullE_EResistanceBonusEnergyNeutralizer = 3115,
    Effect_controlTowerGenericHullE_EResistanceBonusHybrid = 3116,
    Effect_controlTowerGenericHullE_EResistanceBonusJumpPortal = 3117,
    Effect_controlTowerGenericHullE_EResistanceBonusLaser = 3118,
    Effect_controlTowerGenericHullE_EResistanceBonusMissile = 3119,
    Effect_controlTowerGenericHullE_EResistanceBonusProjectile = 3120,
    Effect_controlTowerGenericHullE_EResistanceBonusScrambler = 3121,
    Effect_controlTowerGenericHullE_EResistanceBonusSensorDampener = 3122,
    Effect_controlTowerGenericHullE_EResistanceBonusStasis = 3123,
    Effect_controlTowerGenericHullK_TResistanceBonusCynoGenerator = 3124,
    Effect_controlTowerGenericHullK_TResistanceBonusCynoJammer = 3125,
    Effect_controlTowerGenericHullK_TResistanceBonusEcm = 3126,
    Effect_controlTowerGenericHullK_TResistanceBonusEnergyNeutralizer = 3127,
    Effect_controlTowerGenericHullK_TResistanceBonusHybrd = 3128,
    Effect_controlTowerGenericHullK_TResistanceBonusJump = 3129,
    Effect_controlTowerGenericHullK_TResistanceBonusLaser = 3130,
    Effect_controlTowerGenericHullK_TResistanceBonusMissile = 3131,
    Effect_controlTowerGenericHullK_TResistanceBonusProjectile = 3133,
    Effect_controlTowerGenericHullK_TResistanceBonusScrambler = 3134,
    Effect_controlTowerGenericHullK_TResistanceBonusSenDamp = 3135,
    Effect_controlTowerGenericHullK_TResistanceBonusStasis = 3136,
    Effect_controlTowerGenericHullResistanceBonusCynoGenerator = 3137,
    Effect_controlTowerGenericHullResistanceBonusCynoJammer = 3138,
    Effect_controlTowerGenericHullResistanceBonusEcm = 3139,
    Effect_controlTowerGenericHullResistanceBonusEnergyNeutralizer = 3140,
    Effect_controlTowerGenericHullResistanceBonusHybrid = 3141,
    Effect_controlTowerGenericHullResistanceBonusJumpPortal = 3142,
    Effect_controlTowerGenericHullResistanceBonusLaser = 3143,
    Effect_controlTowerGenericHullResistanceBonusMissile = 3144,
    Effect_controlTowerGenericHullResistanceBonusProjectile = 3145,
    Effect_controlTowerGenericHullResistanceBonusScrambler = 3146,
    Effect_controlTowerGenericHullResistanceBonusSensorDampener = 3148,
    Effect_controlTowerGenericHullResistanceBonusStasis = 3149,
    Effect_controlTowerGenericHullResistanceBonusCG_CGJ = 3150,
    Effect_controlTowerGenericHullResistanceBonusCG_CGJ_ECM = 3151,
    Effect_controlTowerGenericHullResistanceBonusCG_CGJ_ECM_EN = 3152,
    Effect_controlTowerGenericHullResistanceBonusCG_CGJ_ECM_EN_H = 3153,
    Effect_controlTowerGenericHullResistanceBonusCG_CGJ_ECM_EN_H_JP = 3154,
    Effect_controlTowerGenericHullResistanceBonusCG_CGJ_ECM_EN_H_JP_L = 3155,
    Effect_controlTowerGenericHullResistanceBonusCG_CGJ_ECM_EN_H_JP_L_M = 3156,
    Effect_controlTowerGenericHullResistanceBonusCG_CGJ_ECM_EN_H_JP_L_M_P = 3157,
    Effect_controlTowerGenericHullResistanceBonusCG_CGJ_ECM_EN_H_JP_L_M_P_SC = 3158,
    Effect_controlTowerGenericHullResistanceBonusCG_CGJ_ECM_EN_H_JP_L_M_P_SC_SD = 3159,
    Effect_controlTowerGenericHullResistanceBonus = 3160,
    Effect_sensorBoostTargetedHostileKali2Test = 3161,
    Effect_triageModeEffect = 3162,
    Effect_gangArmorRepairCapReducerProjected = 3164,
    Effect_gangArmorRepairCapReducerSelfAndProjected = 3165,
    Effect_gangArmorRepairSpeedAmplifierProjected = 3166,
    Effect_gangArmorRepairSpeedAmplifierSelfAndProjected = 3167,
    Effect_remoteArmorPowerNeedBonusEffect = 3168,
    Effect_shieldTransportCpuNeedBonusEffect = 3169,
    Effect_energyTransferPowerNeedBonusEffect = 3171,
    Effect_droneArmorDamageBonusEffect = 3172,
    Effect_droneShieldBonusBonusEffect = 3173,
    Effect_overloadSelfRangeBonus = 3174,
    Effect_overloadSelfSpeedBonus = 3175,
    Effect_overloadSelfECMStrenghtBonus = 3182,
    Effect_overloadSelfECCMStrenghtBonus = 3189,
    Effect_increaseSignatureRadiusPassive = 3191,
    Effect_signatureRadiusMultiplierPassive = 3192,
    Effect_cloakingSignatureRadiusMultiplierMultiplierActive = 3193,
    Effect_thermodynamicsSkillLevel = 3195,
    Effect_thermodynamicsSkillDamageBonus = 3196,
    Effect_overloadSelfArmorDamageAmount = 3197,
    Effect_overloadSelfShieldBonus = 3198,
    Effect_overloadSelfArmorDamageAmountDurationBonus = 3200,
    Effect_overloadSelfShieldBonusDurationBonus = 3201,
    Effect_dronesMaxActiveDroneBonusModAddMaxActiveLocationCharOnline = 3202,
    Effect_eliteBonusCoverOpsCruiseKineticDmg1 = 3205,
    Effect_droneDurabilityShieldCapBonus2 = 3209,
    Effect_droneDurabilityArmorHPBonus2 = 3210,
    Effect_missileSkillFoFAoeCloudSizeBonus = 3212,
    Effect_shipHeavyAssaultMissileEmDmgAC1 = 3213,
    Effect_shipHeavyAssaultMissileThermalDmgAC1 = 3214,
    Effect_shipHeavyAssaultMissileKineticDmgAC1 = 3215,
    Effect_shipHeavyAssaultMissileExplosiveDmgAC1 = 3216,
    Effect_eliteBonusHeavyGunshipMissileEmDmg2 = 3219,
    Effect_eliteBonusHeavyGunshipMass1 = 3223,
    Effect_eliteBonusHeavyGunshipCapRecharge1 = 3224,
    Effect_eliteBonusCommandShipCapRecharge1 = 3225,
    Effect_shipHeavyAssaultMissileEmDmgBC2 = 3226,
    Effect_shipHeavyAssaultMissileThermalDmgBC2 = 3227,
    Effect_shipHeavyAssaultMissileKineticDmgBC2 = 3228,
    Effect_shipHeavyAssaultMissileExplosiveDmgBC2 = 3229,
    Effect_shipRocketEmDmgDF1 = 3230,
    Effect_shipRocketThermalDmgDF1 = 3231,
    Effect_shipRocketKineticDmgDF1 = 3232,
    Effect_shipRocketExplosiveDmgDF1 = 3233,
    Effect_shipRocketExplosiveDmgAF = 3234,
    Effect_shipRocketKineticDmgAF = 3235,
    Effect_shipRocketThermalDmgAF = 3236,
    Effect_shipRocketEmDmgAF = 3237,
    Effect_shipMissileVelocityDF2 = 3238,
    Effect_shipMissileAoeVelocityDF2 = 3239,
    Effect_eliteBonusInterdictorsMissileVelocity1 = 3240,
    Effect_eliteBonusGunshipArmorEmResistance1 = 3241,
    Effect_eliteBonusGunshipArmorThermalResistance1 = 3242,
    Effect_eliteBonusGunshipArmorKineticResistance1 = 3243,
    Effect_eliteBonusGunshipArmorExplosiveResistance1 = 3244,
    Effect_shipArmorExplosiveResistance2AF = 3245,
    Effect_shipArmorKineticResistance2AF = 3246,
    Effect_shipArmorThermalResistance2AF = 3247,
    Effect_shipArmorEmResistance2AF = 3248,
    Effect_shipCapRecharge2AF = 3249,
    Effect_leech = 3250,
    Effect_tacticalShieldManipulationBonus = 3253,
    Effect_tacticalShieldManipulationBonus2 = 3254,
    Effect_massBonusTarget = 3255,
    Effect_industrialCoreCommandBonusEffectiveAdd = 3260,
    Effect_shipCommandBonusEffectiveMultiplierOreCapital2 = 3261,
    Effect_oreCapitalShipSkillMultiplier1 = 3262,
    Effect_oreCapitalShipSkillMultiplier2 = 3263,
    Effect_skillIndustrialReconfigurationConsumptionQuantityBonus = 3264,
    Effect_industrialReconfigurationCpuNeedBonus = 3265,
    Effect_shipConsumptionQuantityBonusIndustrialReconfigurationORECapital1 = 3267,
    Effect_miningDirectorBonusCommandBonusEffective = 3268,
    Effect_industrialCoreSurveyScannerBonus = 3278,
    Effect_industrialCoreCargoScannerBonus = 3279,
    Effect_industrialCoreScannerBonus = 3280,
    Effect_industrialCoreScannerAndCommandBonus = 3281,
    Effect_industrialCoreEffectOLD = 3282,
    Effect_tractorBeamCpuNeedBonus = 3283,
    Effect_gangMiningLaserMaxRangeBonus = 3291,
    Effect_gangIceHarvesterMaxRangeBonus = 3292,
    Effect_gangGasCloudHarvestingMaxRangeBonus = 3294,
    Effect_gangMiningLaserAndIceHarvesterMaxRangeBonus = 3295,
    Effect_gangMiningLaserAndIceHarvesterAndGasCloudHarvesterMaxRangeBonus = 3296,
    Effect_shipEnergyNeutralizerTransferAmountBonusAB = 3297,
    Effect_shipEnergyNeutralizerTransferAmountBonusAC = 3298,
    Effect_shipEnergyNeutralizerTransferAmountBonusAF = 3299,
    Effect_gangGasHarvesterDurationBonus = 3300,
    Effect_gangIceHarvesterAndMiningLaserDurationBonus = 3301,
    Effect_gangGasHarvesterAndIceHarvesterAndMiningLaserDurationBonus = 3302,
    Effect_gangGasHarvesterCapNeedBonus = 3303,
    Effect_gangIceHarvesterCapNeedBonus = 3304,
    Effect_gangMiningLaserCapacitorNeed = 3305,
    Effect_gangGasHarvesterAndIceHarvesterCapNeedBonus = 3306,
    Effect_gangGasHarvesterAndIceHarvesterAndMiningLaserCapNeedBonus = 3307,
    Effect_oreCapitalShipShieldTransferRange = 3308,
    Effect_oreCapitalShipSkillMultiplier3 = 3311,
    Effect_cloneVatMaxJumpCloneBonusSkillNew = 3313,
    Effect_shipMissileHeavyVelocityBC2 = 3316,
    Effect_shipMissileHeavyAssaultVelocityBC2 = 3317,
    Effect_shipBonusORECapShipDroneDmgBonus = 3321,
    Effect_shipBonusORECapShipDroneShieldHPBonus = 3322,
    Effect_shipBonusORECapShipDroneArmorHPBonus = 3323,
    Effect_shipBonusORECapShipDroneHPBonus = 3324,
    Effect_shipBonusORECapShipDroneArmorHPAndShieldHPBonus = 3325,
    Effect_shipBonusORECapShipDroneArmorHPAndShieldHPAndHpBonus = 3326,
    Effect_oreCapitalShipSkillMultiplier4 = 3327,
    Effect_eliteBonusCommandShipArmorRepairAmount1 = 3330,
    Effect_eliteBonusCommandShipArmorHP1 = 3331,
    Effect_leechNpc = 3332,
    Effect_leech2 = 3333,
    Effect_shipArmorEmResistanceGC2 = 3334,
    Effect_shipArmorEmResistanceMC2 = 3335,
    Effect_shipArmorExplosiveResistanceMC2 = 3336,
    Effect_shipArmorExplosiveResistanceGC2 = 3337,
    Effect_shipArmorKineticResistanceGC2 = 3338,
    Effect_shipArmorKineticResistanceMC2 = 3339,
    Effect_shipArmorThermalResistanceMC2 = 3340,
    Effect_shipArmorThermalResistanceGC2 = 3341,
    Effect_eliteBonusHeavyInterdictorsHybridFalloff1 = 3342,
    Effect_eliteBonusHeavyInterdictorsProjectileFalloff1 = 3343,
    Effect_heavyInterdictorsSkillMultiplier1 = 3344,
    Effect_heavyInterdictorsSkillMultiplier2 = 3345,
    Effect_eliteBonusHeavyInterdictorLaserRof = 3346,
    Effect_shipShieldEmResistanceMC2 = 3347,
    Effect_shipShieldExplosiveResistanceMC2 = 3348,
    Effect_shipShieldKineticResistanceMC2 = 3349,
    Effect_shipShieldThermalResistanceMC2 = 3350,
    Effect_shipMissileAssaultMissileRofCC = 3351,
    Effect_shipMissileHeavyMissileRofCC = 3352,
    Effect_shipMissileHeavyAssaultMissileRofCC = 3353,
    Effect_eliteBonusHeavyInterdictorHeavyMissileVelocityBonus1 = 3355,
    Effect_eliteBonusHeavyInterdictorHeavyAssaultMissileVelocityBonus = 3356,
    Effect_eliteBonusHeavyInterdictorLightMissileVelocityBonus = 3357,
    Effect_electronicAttackShipsSkillMultiplier1 = 3358,
    Effect_electronicAttackShipsSkillMultiplier2 = 3359,
    Effect_amarrShipEwWeaponDisruptionMaxRangeAF2 = 3360,
    Effect_amarrShipEwWeaponDisruptionTrackingAF2 = 3361,
    Effect_eliteBonusElectronicAttackShipEnergyNeutRange1 = 3362,
    Effect_eliteBonusElectronicAttackShipEnergyVampireRange1 = 3363,
    Effect_eliteBonusElectronicAttackShipEnergyEmissionCapNeed2 = 3364,
    Effect_shipRemoteSensorDampenerCapNeedGF = 3366,
    Effect_eliteBonusElectronicAttackShipWarpScramblerMaxRange1 = 3367,
    Effect_eliteBonusElectronicAttackShipECMOptimalRange1 = 3369,
    Effect_eliteBonusElectronicAttackShipStasisWebMaxRange1 = 3370,
    Effect_eliteBonusElectronicAttackShipWarpScramblerCapNeed2 = 3371,
    Effect_eliteBonusElectronicAttackShipRocketVelocity2 = 3372,
    Effect_eliteBonusElectronicAttackShipStandardMissileVelocity2 = 3373,
    Effect_eliteBonusElectronicAttackShipSignatureRadius2 = 3374,
    Effect_implantHardwiringABcapacitorNeed = 3379,
    Effect_warpDisruptSphere = 3380,
    Effect_droneDamageBonusOnline = 3381,
    Effect_droneArmorHPBonusOnline = 3382,
    Effect_droneShieldHPBonusOnline = 3383,
    Effect_droneHPBonusOnline = 3384,
    Effect_droneDamageAndHPBonusOnline = 3385,
    Effect_cpuPenaltyToOmnipotent = 3386,
    Effect_eliteBonusBlackOpsLargeEnergyTurretTracking1 = 3392,
    Effect_eliteBonusBlackOpsECMGravimetricStrengthBonus1 = 3396,
    Effect_eliteBonusBlackOpsECMLadarStrengthBonus1 = 3397,
    Effect_eliteBonusBlackOpsECMMagnetometricStrengthBonus1 = 3398,
    Effect_eliteBonusBlackOpsECMRadarStrengthBonus1 = 3399,
    Effect_eliteBonusBlackOpsDroneMWDSpeedBonus1 = 3400,
    Effect_eliteBonusBlackOpsCloakVelocity2 = 3403,
    Effect_blackOpsSkillMultiplier1 = 3404,
    Effect_blackOpsSkillMultiplier2 = 3405,
    Effect_eliteBonusBlackOpsMaxVelocity1 = 3406,
    Effect_testTowerHPMutator = 3407,
    Effect_violatorsSkillMultiplier1 = 3408,
    Effect_violatorsSkillMultiplier2 = 3409,
    Effect_eliteBonusViolatorsLargeEnergyTurretDamageRole1 = 3415,
    Effect_eliteBonusViolatorsLargeHybridTurretDamageRole1 = 3416,
    Effect_eliteBonusViolatorsLargeProjectileTurretDamageRole1 = 3417,
    Effect_shipCapNeedBonusAB2 = 3421,
    Effect_eliteBonusViolatorsLargeEnergyTurretTracking1 = 3423,
    Effect_eliteBonusViolatorsLargeHybridTurretTracking1 = 3424,
    Effect_eliteBonusViolatorsLargeProjectileTurretTracking1 = 3425,
    Effect_eliteBonusViolatorsStasisWebSpeedFactor2 = 3426,
    Effect_eliteBonusViolatorsTractorBeamMaxRangeRole2 = 3427,
    Effect_eliteBonusViolatorsCruiseMissileEMDamageRole1 = 3429,
    Effect_eliteBonusViolatorsCruiseMissileThermalDamageRole1 = 3430,
    Effect_eliteBonusViolatorsCruiseMissileKineticDamageRole1 = 3431,
    Effect_eliteBonusViolatorsCruiseMissileExplosiveDamageRole1 = 3432,
    Effect_eliteBonusViolatorsTorpedoExplosiveDamageRole1 = 3433,
    Effect_eliteBonusViolatorsTorpedoKineticDamageRole1 = 3434,
    Effect_eliteBonusViolatorsTorpedoThermalDamageRole1 = 3435,
    Effect_eliteBonusViolatorsTorpedoEMDamageRole1 = 3436,
    Effect_shipBonusTorpedoKineticDamageCB = 3437,
    Effect_shipBonusCruiseMissileKineticDamageCB = 3438,
    Effect_eliteBonusViolatorsEwTargetPainting1 = 3439,
    Effect_eliteBonusViolatorsCruiseMissileAoeVelocity2 = 3440,
    Effect_eliteBonusViolatorsTorpedoAoeVelocity2 = 3441,
    Effect_shipBonusPTFalloffMB1 = 3447,
    Effect_eliteBonusViolatorsArmorDamageAmount2 = 3448,
    Effect_eliteBonusViolatorsShieldBonus2 = 3449,
    Effect_shipBonusStasisWebSpeedFactorGB2 = 3450,
    Effect_shipBonusStasisWebSpeedFactorAB = 3451,
    Effect_shipBonusAoeVelocityCruiseMissileCB2 = 3452,
    Effect_shipBonusAoeVelocityTorpedoCB2 = 3453,
    Effect_warpDisruptionFieldMassBonusPercentageOnline = 3454,
    Effect_warpDisruptionFieldAfterburnerSpeedFactorOnline = 3455,
    Effect_warpDisruptionFieldAfterburnerSpeedBoostFactorOnline = 3456,
    Effect_warpDisruptionFieldAfterburnerOnline = 3458,
    Effect_warpDisruptionFieldAfterburnerAndMassOnline = 3459,
    Effect_warpDisruptionFieldAfterburnerAndMassAndVelocityOnline = 3460,
    Effect_warpDisruptionFieldEffectOnline = 3461,
    Effect_eliteBonusElectronicAttackShipRechargeRate2 = 3466,
    Effect_eliteBonusElectronicAttackShipCapacitorCapacity2 = 3467,
    Effect_eliteBonusHeavyInterdictorsWarpDisruptFieldGeneratorWarpScrambleRange2 = 3468,
    Effect_testMiningTargetDurationBonus = 3469,
    Effect_shipBonusMWDCapNeedGC2 = 3470,
    Effect_shipBonusMWDCapNeedMC = 3472,
    Effect_eliteBonusViolatorsTractorBeamMaxTractorVelocityRole3 = 3473,
    Effect_shipBonusMWDCapNeedMF = 3476,
    Effect_shipBonusMWDCapNeedMB = 3477,
    Effect_shipLaserDamagePirateBattleship = 3478,
    Effect_shipRofBonusCB = 3479,
    Effect_shipTrackingBonusAB = 3480,
    Effect_shipBonusLargeEnergyTurretDamageCB2 = 3481,
    Effect_warpDisruptFieldGeneratorCpuBonus = 3482,
    Effect_shipBonusMediumEnergyTurretDamagePirateFaction = 3483,
    Effect_shipBonusMediumEnergyTurretTrackingAC2 = 3484,
    Effect_shipBonusMediumEnergyTurretDamageCC2 = 3485,
    Effect_shipBonusSmallEnergyTurretDamageCF2 = 3486,
    Effect_shipBonusSmallEnergyTurretDamagePirateFaction = 3487,
    Effect_shipBonusSmallEnergyTurretTracking2AF = 3489,
    Effect_rorqualSpeedFactorIndustrialCore = 3491,
    Effect_industrialCoreEffect = 3492,
    Effect_rorqualCargoScanRangeBonus = 3493,
    Effect_rorqualSurveyScannerRangeBonus = 3494,
    Effect_shipCapPropulsionJamming = 3495,
    Effect_setBonusThukker = 3496,
    Effect_setBonusSisters = 3498,
    Effect_setBonusSyndicate = 3499,
    Effect_miningLaserMaxRangeMultBonus = 3500,
    Effect_stripMinerMaxRangeMultBonus = 3501,
    Effect_frequencyMiningLaserMaxRangeMultBonus = 3507,
    Effect_gasHarvesterMaxRangeMultBonus = 3508,
    Effect_miningLaserAndFrequencyMiningLaserMaxRangeMultBonus = 3509,
    Effect_miningLaserAndFrequencyMiningLaserAndStripMinerMaxRangeMultBonus = 3510,
    Effect_miningLaserAndFrequencyMiningLaserAndStripMinerAndGasHarvesterMaxRangeMultBonus = 3511,
    Effect_setBonusMordus = 3513,
    Effect_Interceptor2WarpScrambleRange = 3514,
    Effect_weaponUpgradesCpuNeedBonusPostPercentCpuLocationShipModulesRequiringBombLauncher = 3519,
    Effect_skillAdvancedWeaponUpgradesPowerNeedBonusBombLaunchers = 3520,
    Effect_skillNaniteOperationRepairCost = 3521,
    Effect_skillNaniteOperationRepairCostLevel = 3522,
    Effect_skillNaniteInterfacingRepairTime = 3523,
    Effect_skillNaniteInterfacingRepairTimeLevel = 3524,
    Effect_cynosuralTheoryConsumptionBonus = 3526,
    Effect_skillConsumptionQuantityBonusPercentageSkillLevel = 3527,
    Effect_drawbackCapacitorRecharge = 3528,
    Effect_testMiningLaserTargetVeldsparDurationBonus = 3529,
    Effect_eliteBonusBlackOpsAgiliy1 = 3530,
    Effect_covertCynosuralFieldGeneratorCpuNeedBonus = 3531,
    Effect_skillJumpDriveConsumptionAmountBonusPercentage = 3532,
    Effect_scriptTrackingMaxRangeMultiplier = 3537,
    Effect_scriptTrackingTrackingSpeedMultiplier = 3538,
    Effect_scriptSensorBoosterMaxTargetRangeMultiplierBonusAdditive = 3539,
    Effect_scriptSensorBoosterScanResolutionMultiplierBonusAdditive = 3540,
    Effect_targetEnergyWeaponMaxRangeBonusHostile = 3541,
    Effect_targetEnergyWeaponTrackingSpeedBonusHostile = 3542,
    Effect_targetHybridWeaponTrackingSpeedBonusHostile = 3543,
    Effect_targetHybridWeaponMaxRangeBonusHostile = 3544,
    Effect_targetProjectileWeaponMaxRangeBonusHostile = 3545,
    Effect_targetProjectileWeaponTrackingSpeedBonusHostile = 3546,
    Effect_targetProjectileWeaponMaxRangeAndTrackingSpeedBonusHostile = 3547,
    Effect_targetHybridWeaponMaxRangeAndTrackingSpeedBonusHostile = 3548,
    Effect_targetEnergyWeaponMaxRangeAndTrackingSpeedBonusHostile = 3549,
    Effect_targetEnergyWeaponAndHybridWeaponMaxRangeAndTrackingSpeedBonusHostile = 3550,
    Effect_targetTurretWeaponMaxRangeAndTrackingSpeedBonusHostile = 3552,
    Effect_targetGunneryMaxRangeBonusHostile = 3553,
    Effect_targetGunneryTrackingSpeedBonusHostile = 3554,
    Effect_targetGunneryMaxRangeAndTrackingSpeedBonusHostile = 3555,
    Effect_targetGunneryMaxRangeAndTrackingSpeedBonusAssistance = 3556,
    Effect_gunneryMaxRangeBonus = 3557,
    Effect_gunneryTrackingSpeedBonus = 3558,
    Effect_gunneryMaxRangeAndTrackingSpeedBonus = 3559,
    Effect_ewSkillTrackingDisruptionMaxRangeBonus = 3560,
    Effect_ewSkillTrackingDisruptionTrackingSpeedBonus = 3561,
    Effect_shipBonusEwWeaponDisruptionMaxRangeBonusAC1 = 3562,
    Effect_shipBonusEwWeaponDisruptionMaxRangeBonusAF2 = 3563,
    Effect_shipBonusEwWeaponDisruptionMaxRangeBonusAF1 = 3564,
    Effect_shipBonusEwWeaponDisruptionTrackingSpeedBonusAF1 = 3565,
    Effect_shipBonusEwWeaponDisruptionTrackingSpeedBonusAF2 = 3566,
    Effect_shipBonusEwWeaponDisruptionTrackingSpeedBonusAC1 = 3567,
    Effect_eliteBonusLogisticsTrackingLinkMaxRangeBonus1 = 3568,
    Effect_eliteBonusLogisticsTrackingLinkMaxRangeBonus2 = 3569,
    Effect_eliteBonusLogisticsTrackingLinkTrackingSpeedBonus2 = 3570,
    Effect_eliteBonusLogisticsTrackingLinkTrackingSpeedBonus1 = 3571,
    Effect_shipBonusTrackingLinkTrackingSpeedBonusMC1 = 3572,
    Effect_shipBonusTrackingLinkMaxRangeBonusMC1 = 3573,
    Effect_sensorBoosterMaxTargetRangeBonusActive = 3574,
    Effect_sensorBoosterScanResolutionBonusActive = 3575,
    Effect_targetScanResolutionRangeBonusAssistance = 3577,
    Effect_targetScanResolutionBonusAssistance = 3580,
    Effect_targetMaxTargetRangeBonusAssistance = 3582,
    Effect_targetMaxTargetRangeAndScanResolutionBonusAssistance = 3583,
    Effect_targetMaxTargetRangeAndScanResolutionBonusHostile = 3584,
    Effect_ewSkillSignalSuppressionScanResolutionBonus = 3586,
    Effect_shipBonusEwRemoteSensorDampenerMaxTargetRangeBonusGC2 = 3587,
    Effect_shipBonusEwRemoteSensorDampenerMaxTargetRangeBonusGF2 = 3588,
    Effect_shipBonusEwRemoteSensorDampenerScanResolutionBonusGF2 = 3589,
    Effect_shipBonusEwRemoteSensorDampenerScanResolutionBonusGC2 = 3590,
    Effect_ewSkillSignalSuppressionMaxTargetRangeBonus = 3591,
    Effect_eliteBonusJumpFreighterHullHP1 = 3592,
    Effect_eliteBonusJumpFreighterJumpDriveConsumptionAmount2 = 3593,
    Effect_jumpFreightersSkillMultiplier1 = 3595,
    Effect_jumpFreightersSkillMultiplier2 = 3596,
    Effect_scriptSensorBoosterScanResolutionBonusBonus = 3597,
    Effect_scriptSensorBoosterMaxTargetRangeBonusBonus = 3598,
    Effect_scriptTrackingComputerTrackingSpeedBonusBonus = 3599,
    Effect_scriptTrackingComputerMaxRangeBonusBonus = 3600,
    Effect_scriptWarpDisruptionFieldGeneratorSetDisallowInEmpireSpace = 3601,
    Effect_scriptDurationBonus = 3602,
    Effect_eliteBonusHeavyInterdictorsWarpDisruptFieldGeneratorWarpScrambleRangeScript2 = 3603,
    Effect_targetSetWarpScrambleStatusHidden = 3604,
    Effect_commandMultiplierInformationWarfareSpecialistHidden = 3607,
    Effect_squadronCommandHidden = 3608,
    Effect_informationWarfareMindlinkHidden = 3609,
    Effect_commandBonusECMMultiplyWithCommandBonusHidden = 3611,
    Effect_commandBonusRSDMultiplyWithCommandBonusHidden = 3612,
    Effect_commandBonusTDMultiplyWithCommandBonusHidden = 3613,
    Effect_commandBonusTPMultiplyWithCommandBonusHidden = 3614,
    Effect_scriptWarpDisruptionFieldGeneratorSetScriptCapacitorNeedHidden = 3615,
    Effect_scriptSignatureRadiusBonusBonus = 3617,
    Effect_scriptMassBonusPercentageBonus = 3618,
    Effect_scriptSpeedBoostFactorBonusBonus = 3619,
    Effect_scriptSpeedFactorBonusBonus = 3620,
    Effect_eliteBonusCommandShipInfoHiddenCS2 = 3621,
    Effect_gangInformationWarfareSuperiorityRSDScanResolutionBonus = 3629,
    Effect_gangInformationWarfareSuperiorityRSDMaxTargetRangeBonus = 3630,
    Effect_gangInformationWarfareSuperiorityRSD = 3631,
    Effect_gangInformationWarfareSuperiorityTDMaxRangeBonus = 3632,
    Effect_gangInformationWarfareSuperiorityTDTrackingSpeedBonus = 3633,
    Effect_gangInformationWarfareSuperiorityTD = 3634,
    Effect_gangInformationWarfareSuperiorityTP = 3635,
    Effect_gangInformationWarfareSuperiorityTDAndTP = 3637,
    Effect_gangInformationWarfareSuperiorityECMGravimetric = 3639,
    Effect_gangInformationWarfareSuperiorityECMLadar = 3640,
    Effect_gangInformationWarfareSuperiorityECMMagnetometric = 3641,
    Effect_gangInformationWarfareSuperiorityECMRadar = 3642,
    Effect_gangInformationWarfareSuperiorityECMGravimetricAndLadar = 3643,
    Effect_gangInformationWarfareSuperiorityECMMagnetometricAndRadar = 3644,
    Effect_gangInformationWarfareSuperiorityECM = 3645,
    Effect_gangInformationWarfareSuperiorityECMAndRSD = 3646,
    Effect_gangInformationWarfareSuperiority = 3647,
    Effect_scriptWarpScrambleRangeBonus = 3648,
    Effect_eliteBonusViolatorsLargeEnergyTurretDamage1 = 3649,
    Effect_ewGroupRsdMaxRangeBonus = 3650,
    Effect_ewGroupTpMaxRangeBonus = 3651,
    Effect_ewGroupTdMaxRangeBonus = 3652,
    Effect_ewGroupEcmBurstMaxRangeBonus = 3653,
    Effect_gunneryMaxRangeBonusOnline = 3655,
    Effect_gunneryTrackingSpeedBonusOnline = 3656,
    Effect_shipScanResolutionBonusOnline = 3657,
    Effect_shipMaxTargetRangeBonusOnline = 3659,
    Effect_shipMaxLockedTargetsBonusAddOnline = 3660,
    Effect_targetDroneBandwidthMultiplier = 3661,
    Effect_scanRadarStrengthBonusScannerProbeGroup = 3662,
    Effect_scanLadarStrengthBonusScannerProbeGroup = 3663,
    Effect_scanGravimetricStrengthBonusScannerProbeGroup = 3664,
    Effect_scanMagnetometricStrengthBonusScannerProbeGroup = 3665,
    Effect_testColinScanner = 3666,
    Effect_droneBandwidthBonusAddOnline = 3667,
    Effect_miningLaserRangeBonus = 3668,
    Effect_frequencyMiningLaserMaxRangeBonus = 3669,
    Effect_stripMinerMaxRangeBonus = 3670,
    Effect_gasHarvesterMaxRangeBonus = 3671,
    Effect_setBonusOre = 3672,
    Effect_jumpPortalGenerationBO = 3674,
    Effect_shipBonusArmorRepairAmountGC2 = 3675,
    Effect_shipBonusLargeEnergyTurretMaxRangeAB2 = 3677,
    Effect_eliteBonusJumpFreighterShieldHP1 = 3678,
    Effect_eliteBonusJumpFreighterArmorHP1 = 3679,
    Effect_freighterAgilityBonusC1 = 3680,
    Effect_freighterAgilityBonusM1 = 3681,
    Effect_freighterAgilityBonusG1 = 3682,
    Effect_freighterAgilityBonusA1 = 3683,
    Effect_scriptTrackingComputerFalloffBonusBonus = 3686,
    Effect_selfCopyMaxRangeBonusToFalloffBonus = 3687,
    Effect_targetGunneryFalloffHostile = 3688,
    Effect_targetGunneryFalloffHostile1 = 3689,
    Effect_targetGunneryMaxRangeAndTrackingSpeedAndFalloffBonusHostile = 3690,
    Effect_turretWeaponFalloffMultiplyTargetHostile2 = 3692,
    Effect_turretWeaponFalloffMultiplyTargetHostile3 = 3693,
    Effect_turretWeaponFalloffMultiplyTargetHostile4 = 3694,
    Effect_turretWeaponFalloffMultiplyTargetHostile5 = 3695,
    Effect_turretWeaponFalloffMultiplyTargetHostile = 3696,
    Effect_turretWeaponRangeFalloffTrackingSpeedMultiplyTargetHostile = 3697,
    Effect_dungeonMaxTargetingRangeShip = 3698,
    Effect_shipMissileLauncherSpeedBonusMC2 = 3703,
    Effect_shipHybridTurretROFBonusGC2 = 3705,
    Effect_shipBonusProjectileTrackingMC2 = 3706,
    Effect_shipBonusSurveyProbeExplosionDelaySkillSurveyAF = 3707,
    Effect_concordTargetJam = 3710,
    Effect_concordWarpScramble = 3713,
    Effect_concordModifyTargetSpeed = 3714,
    Effect_shipBonusScanProbeDurationAF = 3715,
    Effect_skirmishWarfareAgilityBonus = 3719,
    Effect_skillNaniteInterfacingRepairTime2 = 3723,
    Effect_targetMWDBlockActivation = 3724,
    Effect_warpScrambleTargetMWDBlockActivation = 3725,
    Effect_agilityMultiplierEffectPassive = 3726,
    Effect_velocityBonusPassive = 3727,
    Effect_shieldBoostAmplifierPassive2 = 3728,
    Effect_boostersShieldBoostAmountPenalty = 3729,
    Effect_zColinOrcaTractorRangeBonus = 3739,
    Effect_zColinOrcaTractorVelocityBonus = 3740,
    Effect_zColinSkillOrcaCargoBonusLvl = 3741,
    Effect_zColinOrcaCargoBonus = 3742,
    Effect_zColinSkillOrcaForemanBonusLvl = 3743,
    Effect_zColinOrcaForemanModBonus = 3744,
    Effect_zColinOrcaSurveyScannerBonus = 3745,
    Effect_zColinSkillOrcaSurveyScannerBonus = 3746,
    Effect_zColinTransportArmorReinforcerBonus = 3751,
    Effect_zColinTransportShieldExtenderBonus = 3752,
    Effect_eliteIndustrialExtenderSkillBonus = 3753,
    Effect_zColinTransportsCloakCpuBonus = 3754,
    Effect_zColinSkillTransportCovertCloakMod = 3755,
    Effect_shipBonusAF1TorpedoEmDamage = 3761,
    Effect_shipBonusCF1TorpedoKineticDamage = 3762,
    Effect_shipBonusGF1TorpedoThermalDamage = 3763,
    Effect_shipBonusMF1TorpedoExplosiveDamage = 3764,
    Effect_covertOpsStealthBomberSiegeMissileLauncerPowerNeedBonus = 3765,
    Effect_interceptorMWDSignatureRadiusBonus = 3766,
    Effect_eliteBonusCommandShipsHeavyMissileExplosionVelocityCS2 = 3767,
    Effect_shipBonusStandardMissileAoeDamageReductionFactorDF2 = 3768,
    Effect_zColinShieldHPPerLvl = 3769,
    Effect_zColinArmorHPPerLvl = 3770,
    Effect_armorHPBonusAddPassive = 3771,
    Effect_subSystem = 3772,
    Effect_hardPointModifierEffect = 3773,
    Effect_slotModifier = 3774,
    Effect_cpuOutputAdd = 3778,
    Effect_powerOutputAdd = 3779,
    Effect_maxVelocityAdd = 3780,
    Effect_powerOutputAddPassive = 3782,
    Effect_cpuOutputAddCpuOutputPassive = 3783,
    Effect_maxVelocityAddPassive = 3784,
    Effect_modifyHullResonancePostPercentEM = 3785,
    Effect_modifyHullResonancePostPercentThermal = 3786,
    Effect_modifyHullResonancePostPercentKinetic = 3787,
    Effect_modifyHullResonancePostPercentExplosive = 3788,
    Effect_modifyHullResonancePostPercentEMExplosive = 3789,
    Effect_modifyHullResonancePostPercentKineticThermal = 3790,
    Effect_modifyHullResonancePostPercent = 3791,
    Effect_probeLaunching = 3793,
    Effect_dungeonMaxVelocityModifier = 3794,
    Effect_dungeonMiningLaserDurationBonus = 3795,
    Effect_dungeonTurretTrackingBonus = 3796,
    Effect_droneBandwidthAddPassive = 3797,
    Effect_droneCapacityAdddroneCapacityPassive = 3799,
    Effect_scanStrengthAddPassive = 3806,
    Effect_maxTargetRangeAddPassive = 3807,
    Effect_signatureRadiusAddPassive = 3808,
    Effect_scanResolutionAddPassive = 3809,
    Effect_capacityAddPassive = 3810,
    Effect_capacitorCapacityAddPassive = 3811,
    Effect_modifyArmorResonancePassiveSubtract = 3823,
    Effect_modifyShieldResonancePassiveSubtract = 3830,
    Effect_shieldCapacityAddPassive = 3831,
    Effect_subsystemSkillLevelAmarrDefensive = 3832,
    Effect_subsystemSkillLevelCaldariDefensive = 3833,
    Effect_subsystemSkillLevelGallenteDefensive = 3834,
    Effect_subsystemSkillLevelMinmatarDefensive = 3835,
    Effect_subsystemSkillLevelMinmatarElectronic = 3836,
    Effect_subsystemSkillLevelGallenteElectronic = 3837,
    Effect_subsystemSkillLevelCaldariElectronic = 3838,
    Effect_subsystemSkillLevelAmarrElectronic = 3839,
    Effect_subsystemSkillLevelAmarrEngineering = 3840,
    Effect_subsystemSkillLevelCaldariEngineering = 3841,
    Effect_subsystemSkillLevelGallenteEngineering = 3842,
    Effect_subsystemSkillLevelMinmatarEngineering = 3843,
    Effect_subsystemSkillLevelMinmatarOffensive = 3844,
    Effect_subsystemSkillLevelGallenteOffensive = 3845,
    Effect_subsystemSkillLevelCaldariOffensive = 3846,
    Effect_subsystemSkillLevelAmarrOffensive = 3847,
    Effect_subsystemSkillLevelAmarrPropulsion = 3848,
    Effect_subsystemSkillLevelCaldariPropulsion = 3849,
    Effect_subsystemSkillLevelGallentePropulsion = 3850,
    Effect_subsystemSkillLevelMinmatarPropulsion = 3851,
    Effect_NPCRemoteArmorRepair = 3852,
    Effect_rechargeRateAddPassive = 3853,
    Effect_NPCRemoteShieldBoost = 3855,
    Effect_shieldRechargeRateAddPassive = 3856,
    Effect_subsystemBonusAmarrPropulsionMaxVelocity = 3857,
    Effect_subsystemBonusGallentePropulsionMaxVelocity = 3858,
    Effect_subsystemBonusCaldariPropulsionMaxVelocity = 3859,
    Effect_subsystemBonusMinmatarPropulsionMaxVelocity = 3860,
    Effect_subsystemBonusMinmatarPropulsionAfterburnerSpeedFactor = 3861,
    Effect_subsystemBonusGallentePropulsionAfterburnerSpeedFactor = 3862,
    Effect_subsystemBonusCaldariPropulsionAfterburnerSpeedFactor = 3863,
    Effect_subsystemBonusAmarrPropulsionAfterburnerSpeedFactor = 3864,
    Effect_subsystemBonusAmarrPropulsionAgility = 3865,
    Effect_subsystemBonusCaldariPropulsionAgility = 3866,
    Effect_subsystemBonusGallentePropulsionAgility = 3867,
    Effect_subsystemBonusMinmatarPropulsionAgility = 3868,
    Effect_subsystemBonusMinmatarPropulsionMWDPenalty = 3869,
    Effect_subsystemBonusGallentePropulsionMWDPenalty = 3870,
    Effect_subsystemBonusCaldariPropulsionMWDPenalty = 3871,
    Effect_subsystemBonusAmarrPropulsionMWDPenalty = 3872,
    Effect_subsystemBonusAmarrPropulsionABMWDCapNeed = 3873,
    Effect_subsystemBonusCaldariPropulsionABMWDCapNeed = 3874,
    Effect_subsystemBonusGallentePropulsionABMWDCapNeed = 3875,
    Effect_subsystemBonusMinmatarPropulsionABMWDCapNeed = 3876,
    Effect_subsystemBonusMinmatarElectronicSignatureRadius = 3877,
    Effect_subsystemBonusGallenteElectronicSignatureRadius = 3878,
    Effect_subsystemBonusCaldariElectronicSignatureRadius = 3879,
    Effect_subsystemBonusAmarrElectronicSignatureRadius = 3880,
    Effect_subsystemBonusAmarrElectronicMaxTargetRange = 3881,
    Effect_subsystemBonusCaldariElectronicMaxTargetRange = 3882,
    Effect_subsystemBonusGallenteElectronicMaxTargetRange = 3883,
    Effect_subsystemBonusMinmatarElectronicMaxTargetRange = 3884,
    Effect_subsystemBonusMinmatarElectronicCPU = 3885,
    Effect_subsystemBonusGallenteElectronicCPU = 3886,
    Effect_subsystemBonusCaldariElectronicCPU = 3887,
    Effect_subsystemBonusAmarrElectronicCPU = 3888,
    Effect_subsystemBonusAmarrElectronicScanResolution = 3889,
    Effect_subsystemBonusCaldariElectronicScanResolution = 3890,
    Effect_subsystemBonusGallenteElectronicScanResolution = 3891,
    Effect_subsystemBonusMinmatarElectronicScanResolution = 3892,
    Effect_subsystemBonusMinmatarElectronicScanStrengthLADAR = 3893,
    Effect_subsystemBonusMinmatarElectronicScanStrengthMagnetometric = 3894,
    Effect_subsystemBonusGallenteElectronicScanStrengthMagnetometric = 3895,
    Effect_subsystemBonusGallenteElectronicScanStrengthLADAR = 3896,
    Effect_subsystemBonusCaldariElectronicScanStrengthGravimetric = 3897,
    Effect_subsystemBonusCaldariElectronicScanStrengthRADAR = 3899,
    Effect_subsystemBonusAmarrElectronicScanStrengthRADAR = 3900,
    Effect_subsystemBonusAmarrElectronicScanStrengthGravimetric = 3901,
    Effect_subsystemBonusAmarrDefensiveArmorResistance = 3908,
    Effect_subsystemBonusCaldariDefensiveArmorResistance = 3915,
    Effect_subsystemBonusGallenteDefensiveArmorResistance = 3922,
    Effect_subsystemBonusMinmatarDefensiveArmorResistance = 3930,
    Effect_subsystemBonusMinmatarDefensiveShieldResistance = 3949,
    Effect_subsystemBonusGallenteDefensiveShieldResistance = 3952,
    Effect_subsystemBonusCaldariDefensiveShieldResistance = 3955,
    Effect_subsystemBonusAmarrDefensiveShieldResistance = 3958,
    Effect_subsystemBonusAmarrDefensiveArmorRepairAmount = 3959,
    Effect_subsystemBonusCaldariDefensiveArmorRepairAmount = 3960,
    Effect_subsystemBonusGallenteDefensiveArmorRepairAmount = 3961,
    Effect_subsystemBonusMinmatarDefensiveArmorRepairAmount = 3962,
    Effect_subsystemBonusAmarrDefensiveShieldBoostAmount = 3963,
    Effect_subsystemBonusCaldariDefensiveShieldBoostAmount = 3964,
    Effect_subsystemBonusGallenteDefensiveShieldBoostAmount = 3965,
    Effect_subsystemBonusMinmatarDefensiveShieldBoostAmount = 3966,
    Effect_subsystemBonusAmarrDefensiveArmorRepairCapacitor = 3967,
    Effect_subsystemBonusCaldariDefensiveArmorRepairCapacitor = 3968,
    Effect_subsystemBonusGallenteDefensiveArmorRepairCapacitor = 3969,
    Effect_subsystemBonusMinmatarDefensiveArmorRepairCapacitor = 3970,
    Effect_subsystemBonusMinmatarDefensiveShieldBoostCapacitor = 3971,
    Effect_subsystemBonusGallenteDefensiveShieldBoostCapacitor = 3972,
    Effect_subsystemBonusCaldariDefensiveShieldBoostCapacitor = 3973,
    Effect_subsystemBonusAmarrDefensiveShieldBoostCapacitor = 3974,
    Effect_subsystemBonusAmarrDefensiveShieldHP = 3975,
    Effect_subsystemBonusCaldariDefensiveShieldHP = 3976,
    Effect_subsystemBonusGallenteDefensiveShieldHP = 3977,
    Effect_subsystemBonusMinmatarDefensiveShieldHP = 3978,
    Effect_subsystemBonusMinmatarDefensiveArmorHP = 3979,
    Effect_subsystemBonusGallenteDefensiveArmorHP = 3980,
    Effect_subsystemBonusCaldariDefensiveArmorHP = 3981,
    Effect_subsystemBonusAmarrDefensiveArmorHP = 3982,
    Effect_systemShieldHP = 3992,
    Effect_systemTargetingRange = 3993,
    Effect_wrongsystemCapacitorRecharge = 3994,
    Effect_systemSignatureRadius = 3995,
    Effect_systemArmorEmResistance = 3996,
    Effect_systemArmorExplosiveResistance = 3997,
    Effect_systemArmorKineticResistance = 3998,
    Effect_systemArmorThermalResistance = 3999,
    Effect_systemOptimalRangeGunnery = 4000,
    Effect_systemFalloffRangeGunnery = 4001,
    Effect_systemMissileVelocity = 4002,
    Effect_systemMaxVelocity = 4003,
    Effect_systemMass = 4004,
    Effect_systemDroneControlRange = 4005,
    Effect_systemEcmGravStrength = 4006,
    Effect_systemEcmLadarStrength = 4007,
    Effect_systemEcmMagnetometricStrength = 4008,
    Effect_systemEcmRadarStrength = 4009,
    Effect_systemTargetPaintingAmount = 4010,
    Effect_systemSensorDampenerRangeReduction = 4012,
    Effect_systemSensorDampenerScanResolution = 4013,
    Effect_systemTrackingDisruptorTracking = 4014,
    Effect_systemTrackingDisruptorOptimal = 4015,
    Effect_systemDamageMultiplierGunnery = 4016,
    Effect_systemDamageThermalMissiles = 4017,
    Effect_systemDamageEmMissiles = 4018,
    Effect_systemDamageExplosiveMissiles = 4019,
    Effect_systemDamageKineticMissiles = 4020,
    Effect_systemDamageDrones = 4021,
    Effect_systemTracking = 4022,
    Effect_systemAoeVelocity = 4023,
    Effect_systemDroneSpeed = 4024,
    Effect_systemRemoteSensorBoosterRange = 4025,
    Effect_systemRemoteSensorBoosterScanResolution = 4026,
    Effect_systemRemoteEccmGrav = 4027,
    Effect_systemRemoteEccmLadar = 4028,
    Effect_systemRemoteEccmMagnetometric = 4029,
    Effect_systemRemoteEccmRadar = 4030,
    Effect_systemTrackingLinkTracking = 4031,
    Effect_systemTrackingLinkOptimal = 4032,
    Effect_systemHeatDamage = 4033,
    Effect_systemOverloadArmor = 4034,
    Effect_systemOverloadDamageModifier = 4035,
    Effect_systemOverloadDurationBonus = 4036,
    Effect_systemOverloadEccmStrength = 4037,
    Effect_systemOverloadEcmStrength = 4038,
    Effect_systemOverloadHardening = 4039,
    Effect_systemOverloadRange = 4040,
    Effect_systemOverloadRof = 4041,
    Effect_systemOverloadSelfDuration = 4042,
    Effect_systemOverloadShieldBonus = 4043,
    Effect_systemOverloadSpeedFactor = 4044,
    Effect_systemSmartBombRange = 4045,
    Effect_systemSmartBombEmDamage = 4046,
    Effect_systemSmartBombThermalDamage = 4047,
    Effect_systemSmartBombKineticDamage = 4048,
    Effect_systemSmartBombExplosiveDamage = 4049,
    Effect_brokensystemShieldEmResistance = 4050,
    Effect_brokensystemShieldExplosiveResistance = 4051,
    Effect_brokensystemShieldKineticResistance = 4052,
    Effect_brokensystemShieldThermalResistance = 4053,
    Effect_systemSmallEnergyDamage = 4054,
    Effect_systemSmallProjectileDamage = 4055,
    Effect_systemSmallHybridDamage = 4056,
    Effect_systemRocketEmDamage = 4057,
    Effect_systemRocketExplosiveDamage = 4058,
    Effect_systemRocketKineticDamage = 4059,
    Effect_systemRocketThermalDamage = 4060,
    Effect_systemStandardMissileThermalDamage = 4061,
    Effect_systemStandardMissileEmDamage = 4062,
    Effect_systemStandardMissileExplosiveDamage = 4063,
    Effect_subsystemBonusAmarrDefensiveDroneCapacity = 4064,
    Effect_subsystemBonusCaldariDefensiveDroneCapacity = 4065,
    Effect_subsystemBonusGallenteDefensiveDroneCapacity = 4066,
    Effect_systemMediumEnergyDamage = 4067,
    Effect_subsystemBonusMinmatarDefensiveDroneCapacity = 4068,
    Effect_subsystemBonusMinmatarDefensiveCargoCapacity = 4069,
    Effect_subsystemBonusGallenteDefensiveCargoCapacity = 4070,
    Effect_subsystemBonusCaldariDefensiveCargoCapacity = 4071,
    Effect_subsystemBonusAmarrDefensiveCargoCapacity = 4072,
    Effect_systemMediumHybridDamage = 4073,
    Effect_systemHeavyMissileEmDamage = 4074,
    Effect_systemHeavyMissileExplosiveDamage = 4075,
    Effect_systemHeavyMissileKineticDamage = 4076,
    Effect_systemHeavyMissileThermalDamage = 4077,
    Effect_systemHeavyAssaultMissileThermalDamage = 4078,
    Effect_systemHeavyAssaultMissileEmDamage = 4079,
    Effect_systemHeavyAssaultMissileExplosiveDamage = 4080,
    Effect_systemHeavyAssaultMissileKineticDamage = 4081,
    Effect_systemMediumProjectileDamage = 4082,
    Effect_systemStandardMissileKineticDamageOld = 4083,
    Effect_systemRemoteArmorRepairAmount = 4084,
    Effect_systemShieldTransportAmount = 4085,
    Effect_systemArmorRepairAmount = 4086,
    Effect_systemShieldRepairAmount = 4087,
    Effect_systemArmorRemoteRepairAmount = 4088,
    Effect_systemShieldRemoteRepairAmount = 4089,
    Effect_systemCapacitorCapacity = 4090,
    Effect_systemCapacitorRecharge = 4091,
    Effect_subsystemBonusAmarrOffensiveEnergyWeaponROF = 4092,
    Effect_subsystemBonusAmarrOffensiveEnergyWeaponDamageMultiplier = 4093,
    Effect_subsystemBonusAmarrOffensiveEnergyWeaponFalloff = 4095,
    Effect_subsystemBonusAmarrOffensiveEnergyWeaponTracking = 4096,
    Effect_subsystemBonusAmarrOffensiveEnergyWeaponMaxRange = 4097,
    Effect_subsystemBonusAmarrOffensiveDroneBandwidth = 4098,
    Effect_subsystemBonusCaldariOffensiveDroneBandwidth = 4099,
    Effect_subsystemBonusCaldariOffensiveHybridWeaponDamageMultiplier = 4100,
    Effect_subsystemBonusCaldariOffensiveHybridWeaponROF = 4101,
    Effect_subsystemBonusCaldariOffensiveHybridWeaponTracking = 4102,
    Effect_subsystemBonusCaldariOffensiveHybridWeaponFalloff = 4103,
    Effect_subsystemBonusCaldariOffensiveHybridWeaponMaxRange = 4104,
    Effect_subsystemBonusGallenteOffensiveHybridWeaponMaxRange = 4105,
    Effect_subsystemBonusGallenteOffensiveHybridWeaponFalloff = 4106,
    Effect_subsystemBonusGallenteOffensiveHybridWeaponTracking = 4107,
    Effect_subsystemBonusGallenteOffensiveHybridWeaponROF = 4108,
    Effect_subsystemBonusGallenteOffensiveHybridWeaponDamageMultiplier = 4109,
    Effect_subsystemBonusMinmatarOffensiveProjectileWeaponDamageMultiplier = 4110,
    Effect_subsystemBonusMinmatarOffensiveProjectileWeaponROF = 4111,
    Effect_subsystemBonusMinmatarOffensiveProjectileWeaponTracking = 4112,
    Effect_subsystemBonusMinmatarOffensiveProjectileWeaponFalloff = 4114,
    Effect_subsystemBonusMinmatarOffensiveProjectileWeaponMaxRange = 4115,
    Effect_subsystemBonusCaldariOffensiveMissileLauncherKineticDamage = 4116,
    Effect_subsystemBonusCaldariOffensiveHeavyAssaultMissileVelocity = 4117,
    Effect_subsystemBonusCaldariOffensiveHeavyMissileVelocity = 4118,
    Effect_subsystemBonusCaldariOffensiveLightMissileVelocity = 4119,
    Effect_subsystemBonusCaldariOffensiveHeavyMissileLauncherROF = 4120,
    Effect_subsystemBonusCaldariOffensiveHeavyAssaultMissileLauncherROF = 4121,
    Effect_subsystemBonusCaldariOffensiveAssaultMissileLauncherROF = 4122,
    Effect_subsystemBonusCaldariOffensiveHeavyAssaultMissileFlightTime = 4123,
    Effect_subsystemBonusCaldariOffensiveHeavyMissileFlightTime = 4124,
    Effect_subsystemBonusCaldariOffensiveStandardMissileFlightTime = 4125,
    Effect_subsystemBonusGallenteOffensiveDroneBandwidth = 4127,
    Effect_subsystemBonusGallenteOffensiveDroneHPShields = 4128,
    Effect_subsystemBonusGallenteOffensiveDroneHPArmor = 4129,
    Effect_subsystemBonusGallenteOffensiveDroneHPHull = 4130,
    Effect_subsystemBonusGallenteDefensiveDroneHPHull = 4131,
    Effect_subsystemBonusGallenteDefensiveDroneHPArmor = 4132,
    Effect_subsystemBonusGallenteDefensiveDroneHPShield = 4133,
    Effect_subsystemBonusGallenteOffensiveDroneDamageMultiplier = 4134,
    Effect_systemShieldEmResistance = 4135,
    Effect_systemShieldExplosiveResistance = 4136,
    Effect_systemShieldKineticResistance = 4137,
    Effect_systemShieldThermalResistance = 4138,
    Effect_subsystemBonusAmarrEngineeringEnergyDestabilizerAmount = 4139,
    Effect_subsystemBonusAmarrEngineeringEnergyVampireAmount = 4140,
    Effect_subsystemBonusMinmatarEngineeringStasisWebifierRange = 4141,
    Effect_subsystemBonusMinmatarEngineeringTargetPainterStrength = 4142,
    Effect_subsystemBonusCaldariEngineeringRadarECMStrength = 4146,
    Effect_subsystemBonusCaldariEngineeringMagnetometricECMStrength = 4147,
    Effect_subsystemBonusCaldariEngineeringLadarECMStrength = 4148,
    Effect_subsystemBonusCaldariEngineeringGravimetricECMStrength = 4149,
    Effect_subsystemBonusGallenteEngineeringWarpScramblerRange = 4150,
    Effect_subsystemBonusGallenteEngineeringSensorDampenerStrength = 4151,
    Effect_subsystemBonusAmarrEngineeringHeatDamageReduction = 4152,
    Effect_subsystemBonusCaldariEngineeringHeatDamageReduction = 4153,
    Effect_subsystemBonusGallenteEngineeringHeatDamageReduction = 4154,
    Effect_subsystemBonusMinmatarEngineeringHeatDamageReduction = 4155,
    Effect_subsystemBonusMinmatarEngineeringCapacitorCapacity = 4156,
    Effect_subsystemBonusGallenteEngineeringCapacitorCapacity = 4157,
    Effect_subsystemBonusCaldariEngineeringCapacitorCapacity = 4158,
    Effect_subsystemBonusAmarrEngineeringCapacitorCapacity = 4159,
    Effect_massAddPassive = 4160,
    Effect_baseMaxScanDeviationModifierRequiringAstrometrics = 4161,
    Effect_baseSensorStrengthModifierRequiringAstrometrics = 4162,
    Effect_eliteBonusCoverOpsScanProbeStrength = 4163,
    Effect_shipBonusScanProbeStrengthAF = 4164,
    Effect_shipBonusScanProbeStrengthCF = 4165,
    Effect_shipBonusScanProbeStrengthMF = 4166,
    Effect_shipBonusScanProbeStrengthGF = 4167,
    Effect_eliteBonusCoverOpsScanProbeStrength2 = 4168,
    Effect_subsystemBonusMinmatarDefensiveMaxVelocity = 4169,
    Effect_subsystemBonusAmarrEngineeringOffensiveEnergyWeaponROF = 4170,
    Effect_subsystemBonusGallenteEngineeringOffensiveHybridWeaponROF = 4171,
    Effect_subsystemBonusMinmatarEngineeringOffensiveProjectileTurretROF = 4173,
    Effect_subsystemBonusMinmatarEngineeringOffensiveLauncherROF = 4178,
    Effect_subsystemBonusCaldariEngineeringOffensiveHybridTurretROF = 4179,
    Effect_subsystemBonusCaldariEngineeringOffensiveLauncherROF = 4184,
    Effect_subsystemBonusAmarrOffensiveEnergyWeaponCapacitorNeed = 4185,
    Effect_subsystemBonusMinmatarOffensiveDroneBandwidth = 4186,
    Effect_shipBonusStrategicCruiserAmarrHeatDamage = 4187,
    Effect_shipBonusStrategicCruiserCaldariHeatDamage = 4188,
    Effect_shipBonusStrategicCruiserGallenteHeatDamage = 4189,
    Effect_shipBonusStrategicCruiserMinmatarHeatDamage = 4190,
    Effect_strategicCruiserAmarrSkillLevel1 = 4191,
    Effect_strategicCruiserCaldariSkillLevel1 = 4192,
    Effect_strategicCruiserGallenteSkillLevel1 = 4193,
    Effect_strategicCruiserMinmatarSkillLevel1 = 4194,
    Effect_subsystemSkillLevelAmarrDefensive2 = 4195,
    Effect_subsystemSkillLevelCaldariDefensive2 = 4196,
    Effect_subsystemSkillLevelGallenteDefensive2 = 4197,
    Effect_subsystemSkillLevelMinmatarDefensive2 = 4198,
    Effect_subsystemSkillLevelMinmatarElectronic2 = 4199,
    Effect_subsystemSkillLevelGallenteElectronic2 = 4200,
    Effect_subsystemSkillLevelCaldariElectronic2 = 4201,
    Effect_subsystemSkillLevelAmarrElectronic2 = 4202,
    Effect_subsystemSkillLevelAmarrEngineering2 = 4203,
    Effect_subsystemSkillLevelCaldariEngineering2 = 4204,
    Effect_subsystemSkillLevelGallenteEngineering2 = 4205,
    Effect_subsystemSkillLevelMinmatarEngineering2 = 4206,
    Effect_subsystemSkillLevelMinmatarOffensive2 = 4207,
    Effect_subsystemSkillLevelGallenteOffensive2 = 4208,
    Effect_subsystemSkillLevelCaldariOffensive2 = 4209,
    Effect_subsystemSkillLevelAmarrOffensive2 = 4210,
    Effect_subsystemSkillLevelAmarrPropulsion2 = 4211,
    Effect_subsystemSkillLevelCaldariPropulsion2 = 4212,
    Effect_subsystemSkillLevelGallentePropulsion2 = 4213,
    Effect_subsystemSkillLevelMinmatarPropulsion2 = 4214,
    Effect_subsystemBonusAmarrOffensive2EnergyWeaponCapacitorNeed = 4215,
    Effect_subsystemBonusAmarrElectronicEnergyVampireAmount = 4216,
    Effect_subsystemBonusAmarrElectronicEnergyDestabilizerAmount = 4217,
    Effect_subsystemBonusCaldariElectronicGravimetricECMStrength = 4218,
    Effect_subsystemBonusCaldariElectronicLadarECMStrength = 4219,
    Effect_subsystemBonusCaldariElectronicMagnetometricECMStrength = 4220,
    Effect_subsystemBonusCaldariElectronicRadarECMStrength = 4221,
    Effect_subsystemBonusMinmatarElectronic2CPU = 4226,
    Effect_subsystemBonusAmarrEngineering2CapacitorRechargeRate = 4230,
    Effect_subsystemBonusCaldariEngineering2CapacitorRechargeRate = 4231,
    Effect_subsystemBonusGallenteEngineering2CapacitorRechargeRate = 4232,
    Effect_subsystemBonusMinmatarEngineering2CapacitorRechargeRate = 4233,
    Effect_modifyArmorResonanceEmPreAssignment = 4234,
    Effect_modifyArmorResonanceThermalPreAssignment = 4235,
    Effect_modifyArmorResonanceKineticPreAssignment = 4236,
    Effect_modifyArmorResonanceExplosivePreAssignment = 4237,
    Effect_modifyArmorResonanceExplosiveKineticPreAssignment = 4238,
    Effect_modifyArmorResonanceEmThermalPreAssignment = 4239,
    Effect_modifyArmorResonancePassivePreAssignment = 4240,
    Effect_modifyShieldResonanceEMPassivePreAssignment = 4241,
    Effect_modifyShieldResonanceExplosivePassivePreAssignment = 4242,
    Effect_modifyShieldResonanceKineticPassivePreAssignment = 4243,
    Effect_modifyShieldResonanceThermalPassivePreAssignment = 4244,
    Effect_modifyShieldResonanceEMExplosivePassivePreAssignment = 4245,
    Effect_modifyShieldResonanceKineticThermalPassivePreAssignment = 4246,
    Effect_modifyShieldResonancePassivePreAssignment = 4247,
    Effect_subsystemBonusCaldariOffensive2MissileLauncherKineticDamage = 4248,
    Effect_subsystemBonusGallenteOffensiveDroneHP2 = 4249,
    Effect_subsystemBonusGallenteOffensiveDroneHP = 4250,
    Effect_subsystemBonusMinmatarOffensive2ProjectileWeaponDamageMultiplier = 4251,
    Effect_subsystemBonusMinmatarOffensive2ProjectileWeaponROF = 4253,
    Effect_subsystemBonusMinmatarOffensive2HeavyMissileLauncherROF = 4254,
    Effect_subsystemBonusMinmatarOffensive2HeavyAssaultMissileLauncherROF = 4255,
    Effect_subsystemBonusMinmatarOffensive2AssaultMissileLauncherROF = 4256,
    Effect_subsystemBonusMinmatarOffensiveAssaultMissileLauncherROF = 4257,
    Effect_subsystemBonusMinmatarOffensiveHeavyMissileLauncherROF = 4258,
    Effect_subsystemBonusMinmatarOffensiveHeavyAssaultMissileLauncherROF = 4259,
    Effect_subsystemBonusAmarrEngineeringPowerOutput = 4260,
    Effect_subsystemBonusCaldariEngineeringPowerOutput = 4261,
    Effect_subsystemBonusGallenteEngineeringPowerOutput = 4262,
    Effect_subsystemBonusMinmatarEngineeringPowerOutput = 4263,
    Effect_subsystemBonusMinmatarEngineeringCapacitorRecharge = 4264,
    Effect_subsystemBonusGallenteEngineeringCapacitorRecharge = 4265,
    Effect_subsystemBonusCaldariEngineeringCapacitorRecharge = 4266,
    Effect_subsystemBonusAmarrEngineeringCapacitorRecharge = 4267,
    Effect_subsystemBonusAmarrElectronic2ScanResolution = 4269,
    Effect_subsystemBonusMinmatarElectronic2ScanResolution = 4270,
    Effect_subsystemBonusCaldariElectronic2MaxTargetingRange = 4271,
    Effect_subsystemBonusGallenteElectronic2MaxTargetingRange = 4272,
    Effect_subsystemBonusGallenteElectronicWarpScrambleRange = 4273,
    Effect_subsystemBonusMinmatarElectronicStasisWebifierRange = 4274,
    Effect_subsystemBonusCaldariPropulsionWarpSpeed = 4275,
    Effect_subsystemBonusCaldariPropulsion2WarpCapacitor = 4276,
    Effect_subsystemBonusGallentePropulsion2WarpCapacitor = 4277,
    Effect_subsystemBonusGallentePropulsionWarpSpeed = 4278,
    Effect_brokensystemAgility = 4279,
    Effect_systemAgility = 4280,
    Effect_modifyShipAgilityPassivePreAssignment = 4281,
    Effect_subsystemBonusGallenteOffensive2HybridWeaponDamageMultiplier = 4282,
    Effect_subsystemBonusCaldariOffensive2HybridWeaponDamageMultiplier = 4283,
    Effect_subsystemBonusGallenteDefensiveDroneHPArmorHull = 4284,
    Effect_subsystemBonusGallenteDefensiveDroneHP = 4285,
    Effect_subsystemBonusAmarrDefensive2RemoteArmorRepairAmount = 4286,
    Effect_subsystemBonusCaldariDefensive2RemoteArmorRepairAmount = 4287,
    Effect_subsystemBonusGallenteDefensive2RemoteArmorRepairAmount = 4288,
    Effect_subsystemBonusMinmatarDefensive2RemoteArmorRepairAmount = 4289,
    Effect_subsystemBonusMinmatarDefensive2RemoteShieldTransporterAmount = 4290,
    Effect_subsystemBonusGallenteDefensive2RemoteShieldTransporterAmount = 4291,
    Effect_subsystemBonusCaldariDefensive2RemoteShieldTransporterAmount = 4292,
    Effect_subsystemBonusAmarrDefensive2RemoteShieldTransporterAmount = 4293,
    Effect_subsystemBonusGallenteEngineeringDroneHPShield = 4313,
    Effect_subsystemBonusGallenteEngineeringDroneHPArmor = 4314,
    Effect_subsystemBonusGallenteEngineeringDroneHPHull = 4315,
    Effect_subsystemBonusGallenteEngineeringDroneHPShieldAndArmor = 4316,
    Effect_subsystemBonusGallenteEngineeringDroneHP = 4317,
    Effect_subsystemBonusGallenteEngineering2DroneMWD = 4320,
    Effect_subsystemBonusCaldariElectronicECMRange = 4321,
    Effect_subsystemBonusAmarrOffensiveDroneDamageMultiplier = 4322,
    Effect_subsystemBonusAmarrOffensive3DroneHPShield = 4323,
    Effect_subsystemBonusAmarrOffensive3DroneHPArmor = 4324,
    Effect_subsystemBonusAmarrOffensive3DroneHPHull = 4325,
    Effect_subsystemBonusAmarrOffensive3DroneHPShieldAndArmor = 4326,
    Effect_subsystemBonusAmarrOffensive3DroneHP = 4327,
    Effect_subsystemBonusAmarrOffensive3EnergyWeaponTracking = 4328,
    Effect_subsystemBonusGallenteOffensive3DroneDamageMultiplier = 4329,
    Effect_subsystemBonusAmarrOffensive3EnergyWeaponMaxRange = 4330,
    Effect_subsystemBonusCaldariOffensive3HeavyAssaultMissileVelocity = 4331,
    Effect_subsystemBonusCaldariOffensive3HeavyMissileVelocity = 4332,
    Effect_subsystemBonusGallenteOffensive2HybridWeaponROF = 4333,
    Effect_subsystemBonusCaldariOffensive3EwStrengthGrav = 4334,
    Effect_subsystemBonusCaldariOffensive3EwStrengthLadar = 4335,
    Effect_subsystemBonusCaldariOffensive3EwStrengthMagn = 4336,
    Effect_subsystemBonusCaldariOffensive3EwStrengthRadar = 4337,
    Effect_subsystemSkillLevelAmarrOffensive3 = 4338,
    Effect_subsystemSkillLevelCaldariOffensive3 = 4339,
    Effect_subsystemBonusGallenteOffensive3HybridWeaponROF = 4340,
    Effect_subsystemSkillLevelGallenteOffensive3 = 4341,
    Effect_subsystemBonusMinmatarElectronic2MaxTargetingRange = 4342,
    Effect_subsystemBonusAmarrElectronic2MaxTargetingRange = 4343,
    Effect_subsystemBonusMinmatarDefensiveSignatureRadius = 4344,
    Effect_subsystemBonusMinmatarOffensive2TurretTracking = 4345,
    Effect_subsystemBonusGallenteOffensive2TurretTracking = 4346,
    Effect_subsystemBonusGallenteOffensive3TurretTracking = 4347,
    Effect_subsystemSkillLevelMinmatarOffensive3 = 4350,
    Effect_subsystemBonusMinmatarOffensive3TurretTracking = 4351,
    Effect_shipMissileHeavyVelocityBonusCR3 = 4352,
    Effect_shipMissileHeavyAssaultVelocityBonusCR3 = 4353,
    Effect_shipMissileLightVelocityBonusCR3 = 4354,
    Effect_shipBonusHeavyAndHeavyAssaultMissileVelocityBonusCR3 = 4355,
    Effect_shipBonusLightHeavyAndHeavyAssaultMissileVelocityBonusCR3 = 4356,
    Effect_reconShipMissileVelocitySkillMultiplier = 4357,
    Effect_ecmRangeBonusModuleEffect = 4358,
    Effect_subsystemBonusAmarrOffensiveHeavyMissileLauncherROF = 4359,
    Effect_subsystemBonusAmarrOffensiveAssaultMissileLauncherROF = 4360,
    Effect_subsystemBonusAmarrOffensiveHeavyAssaultMissileLauncherROF = 4361,
    Effect_subsystemBonusAmarrOffensive2HAMEmDamage = 4362,
    Effect_subsystemBonusAmarrOffensive2HAMThermalDamage = 4363,
    Effect_subsystemBonusAmarrOffensive2HAMKineticDamage = 4364,
    Effect_subsystemBonusAmarrOffensive2HAMExplosiveDamage = 4365,
    Effect_shipBonusMediumHybridDmgCC2 = 4366,
    Effect_shipBonusHybridOptimalCC = 4367,
    Effect_shipBonusMedHybridDamageEliteRecon1 = 4368,
    Effect_subsystemBonusWarpBubbleImmune = 4369,
    Effect_caldariShipEwFalloffRangeCC2 = 4370,
    Effect_ecmFalloffRangeBonusModuleEffect = 4371,
    Effect_caldariShipEwFalloffRangeCB3 = 4372,
    Effect_subSystemBonusAmarrDefensiveArmoredWarfare = 4373,
    Effect_subSystemBonusCaldariDefensiveSiegeWarfare = 4374,
    Effect_subSystemBonusGallenteDefensiveInformationWarfare = 4375,
    Effect_subSystemBonusMinmatarDefensiveSkirmishWarfare = 4376,
    Effect_shipBonusTorpedoVelocityGF2 = 4377,
    Effect_shipBonusTorpedoVelocityMF2 = 4378,
    Effect_shipBonusTorpedoVelocity2AF = 4379,
    Effect_shipBonusTorpedoVelocityCF2 = 4380,
    Effect_covertOpsStealthBomberCruiseMissileLauncherPowerNeedBonus = 4381,
    Effect_eliteReconBonusHeavyMissileVelocity = 4384,
    Effect_eliteReconBonusHeavyAssaultMissileVelocity = 4385,
    Effect_shipBonusHeavyLauncherRateOfFireCC2 = 4386,
    Effect_shipBonusHeavyAssaultLauncherRateOfFireCC2 = 4387,
    Effect_shipBonusTorpedoExpVelocityCover2 = 4388,
    Effect_subSystemBonusAmarrElectronicScanProbeStrength = 4389,
    Effect_subSystemBonusCaldariElectronicScanProbeStrength = 4390,
    Effect_subSystemBonusGallenteElectronicScanProbeStrength = 4391,
    Effect_subSystemBonusMinmatarElectronicScanProbeStrength = 4392,
    Effect_shipBonusEliteCover2TorpedoThermalDamage = 4393,
    Effect_shipBonusEliteCover2TorpedoEMDamage = 4394,
    Effect_shipBonusEliteCover2TorpedoExplosiveDamage = 4395,
    Effect_shipBonusEliteCover2TorpedoKineticDamage = 4396,
    Effect_shipBonusGFTorpedoExplosionVelocity = 4397,
    Effect_shipBonusMF1TorpedoExplosionVelocity = 4398,
    Effect_shipBonusCF1TorpedoExplosionVelocity = 4399,
    Effect_shipBonusAF1TorpedoExplosionVelocity = 4400,
    Effect_subSystemBonusAmarrElectronic2TractorBeamVelocity = 4401,
    Effect_subSystemBonusCaldariElectronic2TractorBeamVelocity = 4402,
    Effect_subSystemBonusGallenteElectronic2TractorBeamVelocity = 4403,
    Effect_subSystemBonusMinmatarElectronic2TractorBeamVelocity = 4404,
    Effect_subSystemBonusMinmatarElectronic2TractorBeamRange = 4405,
    Effect_subSystemBonusGallenteElectronic2TractorBeamRange = 4406,
    Effect_subSystemBonusCaldariElectronic2TractorBeamRange = 4407,
    Effect_subSystemBonusAmarrElectronic2TractorBeamRange = 4408,
    Effect_signatureRadiusPreAssignment = 4409,
    Effect_subsystemBonusScanProbeLauncherCPU = 4410,
    Effect_subSystemBonusGallenteDefensiveInformationWarfareHidden = 4411,
    Effect_subsystemBonusOffensiveJumpHarmonics = 4412,
    Effect_shipBonusGF1TorpedoFlightTime = 4413,
    Effect_shipBonusMF1TorpedoFlightTime = 4415,
    Effect_shipBonusCF1TorpedoFlightTime = 4416,
    Effect_shipBonusAF1TorpedoFlightTime = 4417,
    Effect_missileDMGBonus2a = 4420,
    Effect_missileDMGBonus2b = 4421,
    Effect_missileDMGBonus2c = 4422,
    Effect_missileDMGBonus2d = 4423,
    Effect_missileDMGBonusTemp = 4424,
    Effect_missileDMGBonusTemp2 = 4425,
    Effect_missileDMGBonus1 = 4426,
    Effect_shipBonusDreadM2ShieldBoostAmount = 4427,
    Effect_dreadnoughtMD1ProjDmgBonus = 4428,
    Effect_dreadnoughtMD3ProjRoFBonus = 4429,
    Effect_dreadnoughtBoostShipBonusM3 = 4430,
    Effect_missileSkillAoeCloudSizeBonusAll = 4440,
    Effect_imperialsetbonus = 4445,
    Effect_caldarisetbonus = 4446,
    Effect_federationsetbonus = 4447,
    Effect_republicsetbonus = 4448,
    Effect_ScanRadarStrengthModifierEffect = 4451,
    Effect_ScanLadarStrengthModifierEffect = 4452,
    Effect_ScanGravimetricStrengthModifierEffect = 4453,
    Effect_ScanMagnetometricStrengthModifierEffect = 4454,
    Effect_imperialsetbonus2 = 4455,
    Effect_federationsetbonus3 = 4456,
    Effect_imperialsetbonus3 = 4457,
    Effect_republicsetbonus3 = 4458,
    Effect_caldarisetbonus3 = 4459,
    Effect_imperialsetLGbonus = 4460,
    Effect_federationsetLGbonus = 4461,
    Effect_caldarisetLGbonus = 4462,
    Effect_republicsetLGbonus = 4463,
    Effect_shipProjectileRofMF = 4464,
    Effect_shipBonusStasisMF2 = 4471,
    Effect_shipProjectileDmgMC = 4472,
    Effect_shipVelocityBonusATC1 = 4473,
    Effect_shipMTMaxRangeBonusATC = 4474,
    Effect_shipMTFalloffBonusATC = 4475,
    Effect_shipMTFalloffBonusATF = 4476,
    Effect_shipMTMaxRangeBonusATF = 4477,
    Effect_shipBonusAfterburnerCapNeedATF = 4478,
    Effect_shipBonusSurveyProbeExplosionDelaySkillSurveyCovertOps3 = 4479,
    Effect_covertOpsSkillLevelPreMulEliteBonusCoverOpsShip3 = 4480,
    Effect_superWeaponTurret = 4481,
    Effect_shipETOptimalRange2AF = 4482,
    Effect_shipBonusPTFalloffMB2 = 4483,
    Effect_shipPTurretFalloffBonusGB = 4484,
    Effect_shipBonusStasisWebSpeedFactorMB = 4485,
    Effect_shipSkillAssualtShipAfterburnerSpeedBoost = 4487,
    Effect_superWeaponAmarr = 4489,
    Effect_superWeaponCaldari = 4490,
    Effect_superWeaponGallente = 4491,
    Effect_superWeaponMinmatar = 4492,
    Effect_bombersDmgBonusSkills = 4493,
    Effect_carrierMinmatarFighterBomberArmorEm2 = 4494,
    Effect_carrierMinmatarFighterBomberArmorTh2 = 4495,
    Effect_carrierMinmatarFighterBomberArmorKi2 = 4496,
    Effect_carrierMinmatarFighterBomberArmorEx2 = 4497,
    Effect_carrierMinmatarFighterBomberShieldEm2 = 4498,
    Effect_carrierMinmatarFighterBomberShieldTh2 = 4499,
    Effect_carrierMinmatarFighterBomberShieldKi2 = 4500,
    Effect_carrierMinmatarFighterBomberShieldEx2 = 4501,
    Effect_carrierMinmatarFighterArmorEm2 = 4502,
    Effect_carrierMinmatarFighterArmorTh2 = 4503,
    Effect_carrierMinmatarFighterArmorKi2 = 4504,
    Effect_carrierMinmatarFighterArmorEx2 = 4505,
    Effect_carrierMinmatarFighterShieldEm2 = 4506,
    Effect_carrierMinmatarFighterShieldTh2 = 4507,
    Effect_carrierMinmatarFighterShieldKi2 = 4508,
    Effect_carrierMinmatarFighterShieldEx2 = 4509,
    Effect_shipStasisWebStrengthBonusMC2 = 4510,
    Effect_shipPTurretFalloffBonusMC = 4511,
    Effect_shipPTurretFalloffBonusGC = 4512,
    Effect_shipStasisWebStrengthBonusMF2 = 4513,
    Effect_shipBonusDroneCapacityGF = 4514,
    Effect_shipFalloffBonusMF = 4515,
    Effect_shipHTurretFalloffBonusGC = 4516,
    Effect_fighterBomberTorpedoEmDamageBonus = 4517,
    Effect_fighterBomberTorpedoExplosiveDamageBonus = 4518,
    Effect_fighterBomberTorpedoKineticDamageBonus = 4519,
    Effect_fighterBomberTorpedoThermalDamageBonus = 4520,
    Effect_fighterBomberEmDamageBonus2 = 4521,
    Effect_fighterBomberExplosiveDamageBonus2 = 4522,
    Effect_fighterBomberKineticDamageBonus2 = 4523,
    Effect_fighterBomberThermalDamageBonus2 = 4524,
    Effect_carrierGallenteFighterBomberOwnDmg2 = 4525,
    Effect_gunneryFalloffBonus = 4526,
    Effect_gunneryFalloffBonusOnline = 4527,
    Effect_siegeModeEffectDreadnoughtBonus5 = 4531,
    Effect_siegeModeEffect2 = 4532,
    Effect_titanAmarrSkillLevel5 = 4533,
    Effect_titanAmarrXLLaserTracking5 = 4534,
    Effect_titanGallenteXLHybridTracking5 = 4535,
    Effect_titanGallenteSkillLevel5 = 4536,
    Effect_titanMinmatarSkillLevel5 = 4537,
    Effect_titanMinmatarrXLTracking5 = 4538,
    Effect_titanCaldariSkillLevel5 = 4539,
    Effect_titanCaldariMissileVelocity5 = 4540,
    Effect_capitalLauncherSkillCruiseCitadelEmDamage = 4549,
    Effect_capitalLauncherSkillCruiseCitadelThermalDamage = 4550,
    Effect_capitalLauncherSkillCruiseCitadelKineticDamage = 4551,
    Effect_capitalLauncherSkillCruiseCitadelExplosiveDamage = 4552,
    Effect_dreadnoughtShipBonusMissileKineticDmgC3 = 4553,
    Effect_dreadnoughtBoostShipBonusC3 = 4554,
    Effect_capitalLauncherSkillCruiseCitadelEmDamage1 = 4555,
    Effect_capitalLauncherSkillCruiseCitadelExplosiveDamage1 = 4556,
    Effect_capitalLauncherSkillCruiseCitadelKineticDamage1 = 4557,
    Effect_capitalLauncherSkillCruiseCitadelThermalDamage1 = 4558,
    Effect_gunneryMaxRangeFalloffTrackingSpeedBonus = 4559,
    Effect_targetGunneryMaxRangeFalloffTrackingSpeedBonusAssistance = 4560,
    Effect_carrierMinmatarFighterAoeCloudSize = 4563,
    Effect_carrierMinmatarFighterAoeCloudSize2 = 4564,
    Effect_capitalLauncherSkillCruiseCitadelEmExplosive = 4565,
    Effect_capitalLauncherSkillCruiseCitadelKineticThermal = 4566,
    Effect_capitalLauncherSkillCruiseCitadelAll = 4567,
    Effect_siegeModeEffect3 = 4568,
    Effect_titanCaldariMissileKineticDmgCruise = 4569,
    Effect_titanCaldariMissileKineticDmg2 = 4570,
    Effect_siegeModeActivationMassMultiplier = 4572,
    Effect_siegeModeEffect4 = 4573,
    Effect_triageModeEffect2 = 4574,
    Effect_industrialCoreEffect2 = 4575,
    Effect_eliteBonusLogisticsTrackingLinkFalloffBonus1 = 4576,
    Effect_eliteBonusLogisticsTrackingLinkFalloffBonus2 = 4577,
    Effect_droneRigStasisWebSpeedFactorBonus = 4579,
    Effect_shipBonusSurveyProbeExplosionDelay3AF = 4594,
    Effect_shipBonusSurveyProbeExplosionDelay3CF = 4595,
    Effect_shipBonusSurveyProbeExplosionDelay3GF = 4596,
    Effect_shipBonusSurveyProbeExplosionDelay3MF = 4597,
    Effect_amarrFrigateSkillLevelPreMulShipBonus3AFShip = 4598,
    Effect_caldariFrigateSkillLevelPreMulShipBonus3CFShip = 4599,
    Effect_gallenteFrigateSkillLevelPreMulShipBonus3GFShip = 4600,
    Effect_minmatarFrigateSkillLevelPreMulShipBonus3MFShip = 4601,
    Effect_carrierGallente1BomberDroneMissileDamageMultiplierBonus = 4606,
    Effect_shipBonusWarpDisruptorRangeMF2 = 4617,
    Effect_shipBonusDroneDamageMF2 = 4618,
    Effect_shipBonusDroneDamageGF2 = 4619,
    Effect_shipBonusWarpScramblerMaxRangeGF2 = 4620,
    Effect_shipBonusHeatDamageATF1 = 4621,
    Effect_shipBonusSmallHybridMaxRangeATF2 = 4622,
    Effect_shipBonusSmallHybridTrackingSpeedATF2 = 4623,
    Effect_shipBonusHybridTrackingATC2 = 4624,
    Effect_shipBonusHybridFalloffATC2 = 4625,
    Effect_shipBonusWarpScramblerMaxRangeGC2 = 4626,
    Effect_eliteBonusViolatorsCruiseMissileEMAndEXDamageRole = 4629,
    Effect_eliteBonusViolatorsCruiseMissileEMAndEXAndKinDamageRole = 4630,
    Effect_eliteBonusViolatorsCruiseMissileEMAndEXAndKinAndThmDamageRole = 4631,
    Effect_eliteBonusViolatorsTorpMissileEMAndEXDamageRole = 4632,
    Effect_eliteBonusViolatorsTorpMissileEMAndEXDAndKinDamageRole = 4633,
    Effect_eliteBonusViolatorsTorpMissileEMAndEXDAndKinAndThmDamageRole = 4634,
    Effect_eliteBonusMaraudersCruiseAndTorpedoDamageRole1 = 4635,
    Effect_shipBonusAoeVelocityCruiseAndTorpedoCB2 = 4636,
    Effect_shipCruiseAndTorpedoVelocityBonusCB3 = 4637,
    Effect_shipArmorEMAndExpResistanceAC2 = 4638,
    Effect_shipArmorEMAndExpAndkinResistanceAC2 = 4639,
    Effect_shipArmorEMAndExpAndkinAndThmResistanceAC2 = 4640,
    Effect_shipHeavyAssaultMissileEMAndExpDmgAC1 = 4641,
    Effect_shipHeavyAssaultMissileEMAndExpAndKinDmgAC1 = 4642,
    Effect_shipHeavyAssaultMissileEMAndExpAndKinAndThmDmgAC1 = 4643,
    Effect_eliteBonusHeavyGunshipHeavyAssaultAndAssaultMissileLauncherROF = 4644,
    Effect_eliteBonusHeavyGunshipHeavyAndHeavyAssaultAndAssaultMissileLauncherROF = 4645,
    Effect_eliteBonusBlackOpsECMGravAndLadarStrength1 = 4646,
    Effect_eliteBonusBlackOpsECMGravAndLadarAndMagnetometricStrength1 = 4647,
    Effect_eliteBonusBlackOpsECMGravAndLadarAndMagnetometricAndRadarStrength1 = 4648,
    Effect_shipCruiseAndSiegeLauncherROFBonus2CB = 4649,
    Effect_shipBonusArmorEMandExpResistance2AF = 4650,
    Effect_shipBonusArmorEMandExpandKinResistance2AF = 4651,
    Effect_shipBonusArmorEMandExpandKinandThermResistance2AF = 4652,
    Effect_shipRocketEmAndExpDmgAF = 4653,
    Effect_shipRocketEmAndExpAndKinDmgAF = 4654,
    Effect_shipRocketEmAndExpAndKinAndThmDmgAF = 4655,
    Effect_NPCRemoteECM = 4656,
    Effect_skillFighterBombersDmgBonus = 4657,
    Effect_oreIndustrialSkillLevelPostMulShipBonusOreIndustrial1Ship = 4665,
    Effect_oreIndustrialSkillLevelPostMulShipBonusOreIndustrial2Ship = 4666,
    Effect_shipBonusNoctisSalvageCycle = 4667,
    Effect_shipBonusNoctisTractorCycle = 4668,
    Effect_shipBonusNoctisTractorVelocity = 4669,
    Effect_shipBonusNoctisTractorRange = 4670,
    Effect_systemTurretModifier = 4681,
    Effect_systemEMmissileDmg = 4682,
    Effect_systemExplosiveMissileDmgModifier = 4683,
    Effect_systemThermalMissileDmgModifier = 4684,
    Effect_systemKineticMissileDmgModifier = 4685,
    Effect_NPCGroupShieldAssist = 4686,
    Effect_NPCGroupSpeedAssist = 4687,
    Effect_NPCGroupPropJamAssist = 4688,
    Effect_NPCGroupArmorAssist = 4689,
    Effect_systemStandardMissileKineticDamage = 4691,
    Effect_systemDamageEmSmartbombs = 4693,
    Effect_systemDamageKineticSmartbombs = 4694,
    Effect_systemDamageThermalSmartbombs = 4695,
    Effect_systemDamageExplosiveSmartbombs = 4696,
    Effect_systemEffectDamageDrones = 4699,
    Effect_systemEffectDamageGunnery = 4700,
    Effect_systemEffectDamageEmMissiles = 4701,
    Effect_systemEffectDamageExplosiveMissiles = 4702,
    Effect_systemEffectDamageKineticMissiles = 4703,
    Effect_systemEffectDamageThermalMissiles = 4704,
    Effect_systemEffectDamageEmSmartbombs = 4705,
    Effect_systemEffectDamageExplosiveSmartbombs = 4706,
    Effect_systemEffectDamageKineticSmartbombs = 4707,
    Effect_systemEffectDamageThermalSmartbombs = 4708,
    Effect_carrierGallenteBomberDroneOwnDmg2 = 4720,
    Effect_carrierCaldariDroneOwnDmg2 = 4721,
    Effect_carrierCaldariBomberDroneOwnDmg2 = 4722,
    Effect_shipJumpRangePirateSupercarrier = 4723,
    Effect_shipDCUbonusPirateSupercarrier2 = 4724,
    Effect_OffensiveDefensiveReduction = 4728,
    Effect_fighterMissile = 4729,
    Effect_shipBonusAoeVelocityStandardMissilesDF2 = 4730,
    Effect_shipFighterBomberDamagePirateSupercarrier = 4735,
    Effect_shipFighterDamagePirateSupercarrier = 4736,
    Effect_shipFighterBomberStructureHPPirateSupercarrier = 4737,
    Effect_shipFighterBomberArmorHPPirateSupercarrier = 4738,
    Effect_shipFighterBomberShieldCapPirateSupercarrier = 4739,
    Effect_shipFighterStructureHPPirateSupercarrier = 4740,
    Effect_shipFighterArmorHPPirateSupercarrier = 4741,
    Effect_shipFighterShieldCapPirateSupercarrier = 4742,
    Effect_shipFighterArmStrucHPPirateSupercarrier = 4751,
    Effect_shipFighterHitpointsPirateSupercarrier = 4752,
    Effect_shipFighterBomberArmStrucHPPirateSupercarrier = 4753,
    Effect_shipFighterBomberHitpointsPirateSupercarrier = 4754,
    Effect_carrierAmarrFighterMaxVelocity2 = 4755,
    Effect_carrierAmarrFighterBomberMaxVelocity2 = 4756,
    Effect_subsystemBonusCaldariPropulsion2WarpCapacitor2 = 4760,
    Effect_eliteBonusBlackOpsECMBurstGravimetric1 = 4761,
    Effect_eliteBonusBlackOpsECMBurstRadar1 = 4762,
    Effect_eliteBonusBlackOpsECMBurstLadar1 = 4763,
    Effect_eliteBonusBlackOpsECMBurstMagneto1 = 4764,
    Effect_eliteBonusBlackOpsECMGravAndLadarAndMagnetometricAndRadarStrength2 = 4765,
    Effect_eliteBonusBlackOpsECMGravAndLadarAndMagnetometricAndRadarStrength3 = 4766,
    Effect_eliteBonusBlackOpsECMGravAndLadarAndMagnetometricAndRadarStrength4 = 4767,
    Effect_eliteBonusBlackOpsECMGravAndLadarAndMagnetometricAndRadarStrength5 = 4768,
    Effect_eliteBonusBlackOpsECMGravAndLadarAndMagnetometricAndRadarStrength6 = 4772,
    Effect_deployPledge = 4774,
    Effect_shipEnergyNeutralizerTransferAmountBonusAF2 = 4775,
    Effect_shipEnergyNeutralizerRangeBonusAF2 = 4776,
    Effect_shipArmorEMResistanceATF1 = 4777,
    Effect_shipArmorEMResistanceATF1a = 4778,
    Effect_shipArmorEXPResistanceATF1 = 4779,
    Effect_shipArmorKINResistanceATF1 = 4780,
    Effect_shipArmorTHEResistanceATF1 = 4781,
    Effect_shipBonusSmallEnergyWeaponOptimalRangeATF2 = 4782,
    Effect_shipEnergyVampireRangeBonusAF2 = 4783,
    Effect_shipEnergyVampireAmountBonusAF2 = 4784,
    Effect_shipEnergyVampireAmountBonusATC1 = 4785,
    Effect_shipEnergyNeutralizerAmountBonusATC1 = 4786,
    Effect_shipEnergyNeutralizerRangeBonusATC1 = 4787,
    Effect_shipEnergyVampireRangeBonusATC1 = 4788,
    Effect_shipBonusSmallEnergyTurretDamageATF1 = 4789,
    Effect_shipEnergyNeutralizerRangeBonusAC = 4790,
    Effect_shipEnergyVampireRangeBonusAC = 4791,
    Effect_shipEnergyVampireTransferAmountBonusAC = 4792,
    Effect_shipBonusMissileLauncherHeavyROFATC1 = 4793,
    Effect_shipBonusMissileLauncherAssaultROFATC1 = 4794,
    Effect_shipBonusMissileLauncherHeavyAssaultROFATC1 = 4795,
    Effect_shipBonusArmorRepairBonusATC2 = 4796,
    Effect_eliteBonusBlackOpsECMBurstGravAndLadar = 4797,
    Effect_eliteBonusBlackOpsECMBurstGravAndLadarAndMagneto = 4798,
    Effect_eliteBonusBlackOpsECMBurstGravAndLadarAndMagnetoAndRadar = 4799,
    Effect_salvagingAccessDifficultyBonusMultiplier = 4801,
    Effect_hackingAccessDifficultyBonusMultiplier = 4802,
    Effect_archaeologyAccessDifficultyBonusMultiplier = 4803
};
#endif // EffectsEnum_h__