/*
	------------------------------------------------------------------------------------
	LICENSE:
	------------------------------------------------------------------------------------
	This file is part of EVEmu: EVE Online Server Emulator
	Copyright 2006 - 2011 The EVEmu Team
	For the latest information visit http://evemu.org
	------------------------------------------------------------------------------------
	This program is free software; you can redistribute it and/or modify it under
	the terms of the GNU Lesser General Public License as published by the Free Software
	Foundation; either version 2 of the License, or (at your option) any later
	version.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
	FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place - Suite 330, Boston, MA 02111-1307, USA, or go to
	http://www.gnu.org/copyleft/lesser.txt.
	------------------------------------------------------------------------------------
	Author:		Bloody.Rabbit
*/

#ifndef __ITEM_REF__H__INCL__
#define __ITEM_REF__H__INCL__

class InventoryItem;

class Blueprint;
class Ship;
class CelestialObject;
class Skill;
class Certificate;
class Owner;
class Structure;
class CargoContainer;

class Character;
class SolarSystem;
class Station;

/*
 * Typedefs for all item classes we have:
 */
typedef RefPtr<InventoryItem>            InventoryItemRef;
typedef RefPtr<const InventoryItem>      InventoryItemConstRef;

typedef RefPtr<Blueprint>                BlueprintRef;
typedef RefPtr<const Blueprint>          BlueprintConstRef;
typedef RefPtr<Ship>                     ShipRef;
typedef RefPtr<const Ship>               ShipConstRef;
typedef RefPtr<CelestialObject>          CelestialObjectRef;
typedef RefPtr<const CelestialObject>    CelestialObjectConstRef;
typedef RefPtr<Skill>                    SkillRef;
typedef RefPtr<const Skill>              SkillConstRef;
typedef RefPtr<Certificate>			     CertificateRef;
typedef RefPtr<const Certificate>        CertificateConstRef;
typedef RefPtr<Owner>                    OwnerRef;
typedef RefPtr<const Owner>              OwnerConstRef;
typedef RefPtr<Structure>                StructureRef;
typedef RefPtr<const Structure>          StructureConstRef;
typedef RefPtr<CargoContainer>           CargoContainerRef;
typedef RefPtr<const CargoContainer>     CargoContainerConstRef;

typedef RefPtr<Character>                CharacterRef;
typedef RefPtr<const Character>          CharacterConstRef;
typedef RefPtr<SolarSystem>              SolarSystemRef;
typedef RefPtr<const SolarSystem>        SolarSystemConstRef;
typedef RefPtr<Station>                  StationRef;
typedef RefPtr<const Station>            StationConstRef;

#endif /* !__ITEM_REF__H__INCL__ */

