using System;

namespace EVEMon.Common
{
    public sealed class CharacterIdentityChangedEventArgs : EventArgs
    {
        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="identity"></param>
        public CharacterIdentityChangedEventArgs(CharacterIdentity identity)
        {
            CharacterIdentity = identity;
        }

        /// <summary>
        /// Gets or sets the character identity related to this event.
        /// </summary>
        public CharacterIdentity CharacterIdentity { get; private set; }
    }
}
