using System.ComponentModel;

using EVEMon.Common.Attributes;

namespace EVEMon.Common.SettingsObjects
{
    /// <summary>
    /// Represents the available column types
    /// </summary>
    public enum EveMailMessagesColumn
    {
        None = -1,

        [Header("Received")]
        [Description("Received Date")]
        SentDate = 0,

        [Header("From")]
        [Description("From ( Sender )")]
        SenderName = 1,

        [Header("Subject")]
        [Description("Subject")]
        Title = 2,

        [Header("To")]
        [Description("To ( Recipient(s) )")]
        ToCharacters = 3,

        [Header("To Corp Or Alliance")]
        [Description("To Corp Or Alliance")]
        ToCorpOrAlliance = 4,

        [Header("To Mailing List")]
        [Description("To Mailing List(s)")]
        ToMailingList = 5,
    }
}
