using System.ComponentModel;

using EVEMon.Common.Attributes;

namespace EVEMon.Common.SettingsObjects
{
    public enum ResearchColumn
    {
        None = -1,

        [Header("Agent")]
        [Description("Research Agent Name")]
        Agent = 0,

        [Header("Level")]
        [Description("Research Agent Level")]
        Level = 1,

        [Header("Quality")]
        [Description("Research Agent Quality")]
        Quality = 2,

        [Header("Field")]
        [Description("Research Field Skill")]
        Field = 3,

        [Header("Current RP")]
        [Description("Current Research Points")]
        CurrentRP = 4,

        [Header("RP/Day")]
        [Description("Research Points Per Day")]
        PointsPerDay = 5,

        [Header("Start Date")]
        [Description("Research Start Date")]
        StartDate = 6,

        [Header("Location")]
        [Description("Location (Full)")]
        Location = 7,

        [Header("Region")]
        [Description("Location (Region)")]
        Region = 8,

        [Header("System")]
        [Description("Location (Solar System)")]
        SolarSystem = 9,

        [Header("Station")]
        [Description("Location (Station)")]
        Station = 10,
    }
}
