using System;

namespace EVEMon.Common.SettingsObjects
{
    /// <summary>
    /// Represents the behavior of the tool tip notifications (alerts for skills completion, etc)
    /// </summary>
    public enum ToolTipNotificationBehaviour
    {
        /// <summary>
        /// Never notify
        /// </summary>
        Never = 0,
        /// <summary>
        /// Notify only once
        /// </summary>
        Once = 1,
        /// <summary>
        /// Every minute, the warning is repeated until the user clicks the tooltip
        /// </summary>
        RepeatUntilClicked = 2,
        
        // TODO: Deprecate after version 1.3.6
        RepeatUntiClicked = 3
    }
}
