DROP TABLE IF EXISTS `dgmEffects`;

CREATE TABLE `dgmEffects` (
  `effectID` smallint(6) NOT NULL,
  `effectName` varchar(400) DEFAULT NULL,
  `effectCategory` smallint(6) DEFAULT NULL,
  `preExpression` int(11) DEFAULT NULL,
  `postExpression` int(11) DEFAULT NULL,
  `description` varchar(1000) DEFAULT NULL,
  `graphicID` smallint(6) DEFAULT NULL,
  `guid` varchar(60) DEFAULT NULL,
  `iconID` smallint(6) DEFAULT NULL,
  `isOffensive` tinyint(1) DEFAULT NULL,
  `isAssistance` tinyint(1) DEFAULT NULL,
  `durationAttributeID` smallint(6) DEFAULT NULL,
  `trackingSpeedAttributeID` smallint(6) DEFAULT NULL,
  `dischargeAttributeID` smallint(6) DEFAULT NULL,
  `rangeAttributeID` smallint(6) DEFAULT NULL,
  `falloffAttributeID` smallint(6) DEFAULT NULL,
  `disallowAutoRepeat` tinyint(1) DEFAULT NULL,
  `published` tinyint(1) DEFAULT NULL,
  `displayName` varchar(150) DEFAULT NULL,
  `isWarpSafe` tinyint(1) DEFAULT NULL,
  `rangeChance` tinyint(1) DEFAULT NULL,
  `electronicChance` tinyint(1) DEFAULT NULL,
  `propulsionChance` tinyint(1) DEFAULT NULL,
  `distribution` tinyint(4) DEFAULT NULL,
  `sfxName` varchar(20) DEFAULT NULL,
  `npcUsageChanceAttributeID` smallint(6) DEFAULT NULL,
  `npcActivationChanceAttributeID` smallint(6) DEFAULT NULL,
  `fittingUsageChanceAttributeID` smallint(6) DEFAULT NULL,
  `dataID` int(10) DEFAULT NULL,
  PRIMARY KEY (`effectID`),
  KEY `durationAttributeID` (`durationAttributeID`),
  KEY `trackingSpeedAttributeID` (`trackingSpeedAttributeID`),
  KEY `dischargeAttributeID` (`dischargeAttributeID`),
  KEY `rangeAttributeID` (`rangeAttributeID`),
  KEY `falloffAttributeID` (`falloffAttributeID`),
  KEY `npcUsageChanceAttributeID` (`npcUsageChanceAttributeID`),
  KEY `npcActivationChanceAttributeID` (`npcActivationChanceAttributeID`),
  KEY `fittingUsageChanceAttributeID` (`fittingUsageChanceAttributeID`),
  KEY `iconID` (`iconID`),
  KEY `graphicID` (`graphicID`),
  KEY `dataID` (`dataID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (4,"shieldBoosting",1,183,131,"","effects.ShieldBoosting",0,0,1,73,0,6,0,0,1,"shieldBoosting",1,1,1,0,0,"None",0,0,0,0,899422);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (7,"speedBoost",1,3517,3518,"","",0,0,0,73,0,6,0,0,1,"speedBoost",1,1,1,0,0,"None",0,0,0,0,7582954);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (9,"missileLaunching",2,114,89,"Launches a missile","effects.MissileDeployment",0,0,1,0,0,0,0,0,1,"missileLaunching",1,1,1,0,0,"None",0,0,0,0,899428);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (10,"targetAttack",2,115,89,"Combat","effects.Laser",0,1,1,51,160,6,54,158,1,"targetAttack",0,1,1,0,0,"None",0,0,0,0,899431);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (11,"loPower",0,131,131,"Requires a low power slot.","",295,0,1,0,0,0,0,0,0,"Low power",1,1,1,0,0,"None",0,0,0,295,899434);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (12,"hiPower",0,131,131,"Requires a high power slot.","",293,0,1,0,0,0,0,0,0,"High power",1,1,1,0,0,"None",0,0,0,293,899437);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (13,"medPower",0,131,131,"Requires a medium power slot.","",294,0,1,0,0,0,0,0,0,"Medium power",1,1,1,0,0,"None",0,0,0,294,899440);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (16,"online",1,633,400,"this is the online effect","",0,0,0,0,0,0,0,0,1,"online",1,1,1,0,0,"None",0,0,0,0,899443);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (17,"mining",2,3134,184,"mining of ore","effects.Mining",0,1,0,73,0,0,54,0,1,"mining",1,1,1,0,0,"None",0,0,0,0,899446);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (18,"shieldTransfer",2,185,89,"Boosts the shield of the target ship by draining the doers ships shield.","effects.ShieldTransfer",0,1,1,73,0,6,87,0,1,"shieldTransfer",1,1,1,0,0,"None",0,0,0,0,899449);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (21,"shieldCapacityBonusOnline",4,199,201,"Increases maximum shield capacity.","",0,0,0,0,0,0,0,0,1,"shieldCapacityBonusOnline",1,1,1,0,0,"None",0,0,0,0,899452);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (22,"maxVelocityBonus",4,205,206,"Enhances the maximum speed of the ship.","",0,0,0,0,0,0,0,0,1,"maxVelocityBonus",1,1,1,0,0,"None",0,0,0,0,899455);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (25,"capacitorCapacityBonus",4,227,228,"","",0,0,0,0,0,0,0,0,1,"capacitorCapacityBonus",1,1,1,0,0,"None",0,0,0,0,899458);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (26,"structureRepair",1,131,233,"","effects.StructureRepair",0,0,1,73,0,6,0,0,1,"structureRepair",1,1,1,0,0,"None",0,0,0,0,899461);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (27,"armorRepair",1,131,236,"Repair damage to the ships armor.","effects.ArmorRepair",0,0,1,73,0,6,0,0,1,"armorRepair",1,1,1,0,0,"None",0,0,0,0,899464);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (29,"modifyTargetSpeed",2,3489,3491,"","effects.ModifyTargetSpeed",0,0,1,73,0,6,54,0,1,"modifyTargetSpeed",1,1,1,0,0,"None",0,0,0,0,2569169);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (31,"energyTransfer",2,131,258,"","effects.EnergyTransfer",0,0,1,73,0,6,91,0,1,"energyTransfer",1,1,1,0,0,"None",0,0,0,0,899470);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (32,"energyVampire",2,270,131,"Steals power from the target.","effects.EnergyDestabilization",0,0,1,73,0,0,91,0,1,"energyVampire",1,1,1,0,0,"None",0,0,0,0,2602095);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (34,"projectileFired",2,115,131,"","effects.ProjectileFired",0,1,1,51,160,6,54,158,1,"projectileFired",0,1,1,0,0,"None",0,0,0,0,899476);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (36,"energyDestabilization",2,286,131,"Drains power from the target.","effects.EnergyDestabilization",0,1,1,73,0,6,98,0,1,"energyDestabilization",1,1,1,0,0,"None",0,0,0,0,899479);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (38,"empWave",1,288,131,"Triggering of an EMP wave being broadcast into space.","effects.EMPWave",0,1,1,73,0,6,99,0,1,"empWave",1,1,1,0,0,"None",0,0,0,0,899482);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (39,"warpScramble",2,294,295,"Attempts to prevent the target from warping.","effects.WarpScramble",0,1,1,73,0,6,54,0,1,"warpScramble",1,1,1,0,0,"None",0,0,0,0,899485);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (40,"launcherFitted",0,373,319,"","",0,0,0,0,0,0,0,0,1,"launcherFitted",1,1,1,0,0,"None",0,0,0,0,2676870);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (42,"turretFitted",0,379,305,"This is just a test. Ehmm. If your\'e reading this in an error message, your ship probably doesn\'t have any turret slot left.","",0,0,0,0,0,0,0,0,1,"turretFitted",1,1,1,0,0,"None",0,0,0,0,2676869);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (46,"shipScan",2,131,402,"Scans the energy status, cargo and hardware of a given ship.","",0,0,0,73,0,6,125,510,1,"shipScan",1,1,1,0,0,"None",0,0,0,0,2392819);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (47,"cargoScan",2,131,403,"Scan the cargo of a targeted ship.","effects.CargoScan",0,0,0,73,0,6,126,0,1,"cargoScan",1,1,1,0,0,"None",0,0,0,0,899497);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (48,"powerBooster",1,404,131,"Consumes power booster charges to increase the available power in the capacitor.","",0,0,1,73,0,0,0,0,1,"powerBooster",1,1,1,0,0,"None",0,0,0,0,899500);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (50,"modifyShieldRechargeRate",4,439,440,"","",0,0,0,0,0,0,0,0,1,"modifyShieldRechargeRate",1,1,1,0,0,"None",0,0,0,0,899503);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (51,"modifyPowerRechargeRate",4,443,444,"","",0,0,0,0,0,0,0,0,1,"modifyPowerRechargeRate",1,1,1,0,0,"None",0,0,0,0,899506);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (53,"ecmBurst",1,471,131,"","effects.ECMBurst",0,1,1,73,0,6,142,158,1,"ecmBurst",1,1,1,0,0,"None",0,0,0,0,899509);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (54,"targetPassively",2,472,131,"Targets an object without letting it know.","",0,0,0,73,0,6,0,0,1,"targetPassively",1,1,1,0,0,"None",0,0,0,0,899512);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (55,"targetHostiles",1,131,473,"Target all hostile ships within range (if electronics can handle it).","",0,0,0,73,0,6,0,0,1,"targetHostiles",1,1,1,0,0,"None",0,0,0,0,899515);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (56,"powerOutputMultiply",4,477,478,"","",0,0,0,0,0,0,0,0,1,"powerOutputMultiply",1,1,1,0,0,"None",0,0,0,0,899518);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (57,"shieldCapacityMultiply",4,485,486,"","",0,0,0,0,0,0,0,0,1,"shieldCapacityMultiply",1,1,1,0,0,"None",0,0,0,0,899521);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (58,"capacitorCapacityMultiply",4,483,484,"","",0,0,0,0,0,0,0,0,1,"capacitorCapacityMultiply",1,1,1,0,0,"None",0,0,0,0,899524);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (59,"cargoCapacityMultiply",4,490,491,"","",0,0,0,0,0,0,0,0,1,"cargoCapacityMultiply",1,1,1,0,0,"None",0,0,0,0,899527);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (60,"structureHPMultiply",4,494,495,"","",0,0,0,0,0,0,0,0,1,"structureHPMultiply",1,1,1,0,0,"None",0,0,0,0,899530);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (61,"agilityBonus",0,500,501,"","",0,0,0,0,0,0,0,0,1,"agilityBonus",1,1,1,0,0,"None",0,0,0,0,899533);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (62,"maxPassengersBonus",0,506,507,"","",0,0,0,0,0,0,0,0,1,"maxPassengersBonus",1,1,1,0,0,"None",0,0,0,0,899536);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (63,"armorHPMultiply",4,509,510,"","",0,0,0,0,0,0,0,0,1,"armorHPMultiply",1,1,1,0,0,"None",0,0,0,0,899539);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (67,"miningLaser",2,3134,184,"Mining of ore.","effects.Laser",0,1,0,73,0,6,54,0,1,"miningLaser",1,1,1,0,0,"None",0,0,0,0,899542);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (70,"agilityMultiply",0,566,567,"Scale the agility of a ship.","",0,0,0,0,0,0,0,0,1,"agilityMultiply",1,1,1,0,0,"None",0,0,0,0,899545);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (73,"repairCostMultiply",0,578,579,"","",0,0,0,0,0,0,0,0,1,"repairCostMultiply",1,1,1,0,0,"None",0,0,0,0,899548);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (81,"surveyScan",1,131,602,"Scanning an asteroid to determine any helpful information.","effects.SurveyScan",0,0,0,73,0,6,0,0,1,"surveyScan",1,1,1,0,0,"None",0,0,0,0,899551);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (82,"corporationMemberLimitBonus",0,609,610,"Modify the maximum number of members a character is capable of managing in a corporation.","",0,0,0,0,0,0,0,0,1,"corporationMemberLimitBonus",1,1,1,0,0,"None",0,0,0,0,899554);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (87,"cpuUsageMultiply",0,638,639,"Scales amount of CPU used by module(s).","",0,0,0,0,0,0,0,0,1,"cpuUsageMultiply",1,1,1,0,0,"None",0,0,0,0,899557);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (88,"miningDurationMultiply",0,646,647,"Scales the mining duration of a mining laser module.","",0,0,0,0,0,0,0,0,1,"miningDurationMultiply",1,1,1,0,0,"None",0,0,0,0,899560);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (89,"projectileWeaponSpeedMultiply",4,654,655,"Scale the projectile weapon firing speed.","",0,0,0,0,0,0,0,0,1,"projectileWeaponSpeedMultiply",1,1,1,0,0,"None",0,0,0,0,899563);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (91,"energyWeaponDamageMultiply",4,668,671,"Scales the damage done by all fitted energy weapons.","",0,0,0,0,0,0,0,0,1,"energyWeaponDamageMultiply",1,1,1,0,0,"None",0,0,0,0,899566);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (92,"projectileWeaponDamageMultiply",4,667,670,"Scales the damage done by all fitted projectile weapons.","",0,0,0,0,0,0,0,0,1,"projectileWeaponDamageMultiply",1,1,1,0,0,"None",0,0,0,0,899569);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (93,"hybridWeaponDamageMultiply",4,669,672,"Scales the damage done by all fitted hybrid weapons.","",0,0,0,0,0,0,0,0,1,"hybridWeaponDamageMultiply",1,1,1,0,0,"None",0,0,0,0,899572);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (95,"energyWeaponSpeedMultiply",4,681,683,"Scales the rate of fire of all fitted energy weapons.","",0,0,0,0,0,0,0,0,1,"energyWeaponSpeedMultiply",1,1,1,0,0,"None",0,0,0,0,899575);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (96,"hybridWeaponSpeedMultiply",4,682,684,"Scales the rate of fire of all fitted hybrid weapons.","",0,0,0,0,0,0,0,0,1,"hybridWeaponSpeedMultiply",1,1,1,0,0,"None",0,0,0,0,899578);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (97,"turretWeaponAccuracyMultiply",0,703,705,"Scale the accuracy of all fitted turret weapons.","",0,0,0,0,0,0,0,0,1,"turretWeaponAccuracyMultiply",1,1,1,0,0,"None",0,0,0,0,899581);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (100,"hybridWeaponAccuracyMultiply",0,698,701,"Scales the accuracy of all fitted hybrid weapons.","",0,0,0,0,0,0,0,0,1,"hybridWeaponAccuracyMultiply",1,1,1,0,0,"None",0,0,0,0,899584);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (101,"useMissiles",1,131,131,"The ammunition loaded into this item defines its operation.","",0,1,0,51,0,6,0,0,1,"useMissiles",1,1,1,0,0,"None",0,0,0,0,899587);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (102,"mineLaying",1,114,131,"Drops a mine in space.","",0,0,1,0,0,0,0,0,1,"mineLaying",1,1,1,0,0,"None",0,0,0,0,899590);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (103,"defenderMissileLaunching",1,706,131,"Drops a defender missile in space to go do its thing.","",0,1,0,0,0,0,0,0,1,"defenderMissileLaunching",1,1,1,0,0,"None",0,0,0,0,899593);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (104,"fofMissileLaunching",1,707,131,"Launches an FOF missile.  Auto targets at someone hostile to you.","effects.MissileDeployment",0,1,1,0,0,0,0,0,1,"fofMissileLaunching",1,1,1,0,0,"None",0,0,0,0,2638592);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (105,"shieldResonanceMultiplyOnline",4,431,434,"","",0,0,0,0,0,0,0,0,1,"shieldResonanceMultiplyOnline",1,1,1,0,0,"None",0,0,0,0,899599);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (106,"miningAmountMultiply",0,715,716,"Scales the amount mined by all fitted mining lasers.","",0,0,0,0,0,0,0,0,1,"miningAmountMultiply",1,1,1,0,0,"None",0,0,0,0,899602);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (107,"characterMissileDamageMultiply",0,721,722,"Increases the damage scaling done to missiles damage for missiles launched by the character.","",0,0,0,0,0,0,0,0,1,"characterMissileDamageMultiply",1,1,1,0,0,"None",0,0,0,0,899605);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (109,"turretWeaponCapacitorNeedMultiply",0,743,745,"Scales the capacitor need for all the fitted turret weapons.","",0,0,1,0,0,0,0,0,1,"turretWeaponCapacitorMultiply",1,1,1,0,0,"None",0,0,0,0,899608);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (110,"characterBlueprintResearchTimeBonus",0,750,751,"Modifies the aptitude the character has for researching blueprints by a given percentage.","",0,0,0,0,0,0,0,0,1,"characterBlueprintResearchTimeBonus",1,1,1,0,0,"None",0,0,0,0,899611);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (111,"characterBlueprintManufactureTimeBonus",0,756,757,"Modifies the aptitude the character has for manufacturing from blueprints by a given percentage.","",0,0,0,0,0,0,0,0,1,"characterBlueprintManufactureTimeBonus",1,1,1,0,0,"None",0,0,0,0,899614);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (112,"characterCharismaSkillTrainingTimeBonus",0,778,779,"Modifies the speed at which skills with charisma as their primary attribute are trained.","",0,0,0,0,0,0,0,0,1,"characterCharismaSkillTrainingTimeBonus",1,1,1,0,0,"None",0,0,0,0,899617);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (113,"characterIntelligenceSkillTrainingTimeBonus",0,780,781,"Modifies the speed at which skills with intelligence as their primary attribute are trained.","",0,0,0,0,0,0,0,0,1,"characterIntelligenceSkillTrainingTimeBonus",1,1,1,0,0,"None",0,0,0,0,899620);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (114,"characterMemorySkillTrainingTimeBonus",0,782,783,"Modifies the speed at which skills with memory as their primary attribute are trained.","",0,0,0,0,0,0,0,0,1,"characterMemorySkillTrainingTimeBonus",1,1,1,0,0,"None",0,0,0,0,899623);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (115,"characterPerceptionSkillTrainingTimeBonus",0,785,784,"Modifies the speed at which skills with perception as their primary attribute are trained.","",0,0,0,0,0,0,0,0,1,"characterPerceptionSkillTrainingTimeBonus",1,1,1,0,0,"None",0,0,0,0,899626);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (116,"characterWillpowerSkillTrainingTimeBonus",0,786,787,"Modifies the speed at which skills with willpower as their primary attribute are trained.","",0,0,0,0,0,0,0,0,1,"characterWillpowerSkillTrainingTimeBonus",1,1,1,0,0,"None",0,0,0,0,899629);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (118,"electronicAttributeModifyOnline",4,846,847,"Modifies the targeting range of a ship and also the maximum number of targets that its electronics can lock and also how long it takes to lock targets.","",0,0,0,0,0,0,0,0,1,"electronicAttributeModifyOnline",1,1,1,0,0,"None",0,0,0,0,899632);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (120,"turretWeaponRangeTrackingSpeedMultiplyOnline",4,884,885,"Scales the range and tracking speed of turret weapons.","",0,0,0,0,0,0,0,0,1,"turretWeaponRangeTrackingSpeedMultiplyOnline",1,1,1,0,0,"None",0,0,0,0,899635);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (123,"turretWeaponRangeTrackingSpeedMultiplyActivate",1,884,885,"Modifies maximum turret weapon range and tracking speed for the length of the duration.","effects.TurretWeaponRangeTrackingSpeedMultiplyActivate",0,0,1,73,0,6,0,0,1,"turretWeaponRangeTrackingSpeedMultiplyActivate",1,1,1,0,0,"None",0,0,0,0,899638);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (124,"scanStrengthBonusTarget",2,956,903,"Modifies the scanning strengths of a targeted object.","effects.ScanStrengthBonusTarget",0,1,1,73,0,6,0,0,1,"scanStrengthBonusTarget",1,1,1,0,0,"None",0,0,0,0,899641);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (126,"turretWeaponRangeTrackingSpeedMultiplyTarget",2,1013,1014,"Modifies maximum turret weapon range and tracking speed on the active target for the length of the duration.","effects.TurretWeaponRangeTrackingSpeedMultiplyTarget",0,1,1,73,0,6,54,0,1,"turretWeaponRangeTrackingSpeedMultiplyTarget",1,1,1,0,0,"None",0,0,0,0,899644);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (127,"torpedoLaunching",1,114,131,"","effects.TorpedoDeployment",0,0,0,0,0,0,0,0,1,"torpedoLaunching",1,1,1,0,0,"None",0,0,0,0,899647);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (130,"cheatTeleDock",2,1018,131,"Automatically docks at the targeted station.","",0,0,0,73,0,0,0,0,1,"cheatTeleDock",1,1,1,0,0,"None",0,0,0,0,899650);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (131,"cheatTeleGate",2,1019,131,"Automatically invokes the destination of the target stargate.","",0,0,0,73,0,0,0,0,1,"cheatTeleGate",1,1,1,0,0,"None",0,0,0,0,899653);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (132,"skillEffect",0,1071,1070,"masks skill level onto skill modules.","",0,0,0,0,0,0,0,0,1,"skillEffect",1,1,1,0,0,"None",0,0,0,0,899656);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (146,"damageMultiplierSkillBonus",0,1167,1168,"Boost of damageMultiplier by PreMul of skillLevel","",0,0,1,0,0,0,0,0,0,"DamageBonus",1,1,1,0,0,"None",0,0,0,0,899659);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (152,"skillBoostDamageMultiplierBonus",0,1167,1168,"Boost of damageMultiplierBonus by PreMul of skillLevel","",0,0,1,0,0,0,0,0,0,"SkillBoostDamageMultiplierBonus",1,1,1,0,0,"None",0,0,0,0,899662);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (157,"largeHybridTurretDamageMultiplierBonusPostPercentDamageMultiplierLocationShipModulesRequiringLargeHybridTurret",0,1188,1189,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"largeHybridTurretDamageMultiplierBonusPostPercentDamageMultiplierLocationShipModulesRequiringLargeHybridTurret",1,1,1,0,0,"None",0,0,0,0,899665);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (159,"mediumEnergyTurretDamageMultiplierBonusPostPercentDamageMultiplierLocationShipModulesRequiringMediumEnergyTurret",0,1200,1201,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"mediumEnergyTurretDamageMultiplierBonusPostPercentDamageMultiplierLocationShipModulesRequiringMediumEnergyTurret",1,1,1,0,0,"None",0,0,0,0,899668);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (160,"mediumHybridTurretDamageMultiplierBonusPostPercentDamageMultiplierLocationShipModulesRequiringMediumHybridTurret",0,1206,1207,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"mediumHybridTurretDamageMultiplierBonusPostPercentDamageMultiplierLocationShipModulesRequiringMediumHybridTurret",1,1,1,0,0,"None",0,0,0,0,899671);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (161,"mediumProjectileTurretDamageMultiplierBonusPostPercentDamageMultiplierLocationShipModulesRequiringMediumProjectileTurret",0,1212,1213,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"mediumProjectileTurretDamageMultiplierBonusPostPercentDamageMultiplierLocationShipModulesRequiringMediumProjectileTurret",1,1,1,0,0,"None",0,0,0,0,899674);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (162,"largeEnergyTurretDamageMultiplierBonusPostPercentDamageMultiplierLocationShipModulesRequiringLargeEnergyTurret",0,1174,1175,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"largeEnergyTurretDamageMultiplierBonusPostPercentDamageMultiplierLocationShipModulesRequiringLargeEnergyTurret",1,1,1,0,0,"None",0,0,0,0,899677);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (163,"rapidFiringSkillBoostRofBonus",0,1217,1218,"Boost of rofBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"rapidFiringSkillBoostRofBonus",1,1,1,0,0,"None",0,0,0,0,899680);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (167,"sharpshooterSkillBoostRangeSkillBonus",0,1241,1242,"Boost of rangeSkillBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"sharpshooterSkillBoostRangeSkillBonus",1,1,1,0,0,"None",0,0,0,0,899683);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (172,"smallEnergyTurretDamageMultiplierBonusPostPercentDamageMultiplierLocationShipModulesRequiringSmallEnergyTurret",0,1266,1267,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"smallEnergyTurretDamageMultiplierBonusPostPercentDamageMultiplierLocationShipModulesRequiringSmallEnergyTurret",1,1,1,0,0,"None",0,0,0,0,899686);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (173,"smallHybridTurretDamageMultiplierBonusPostPercentDamageMultiplierLocationShipModulesRequiringSmallHybridTurret",0,1272,1273,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"smallHybridTurretDamageMultiplierBonusPostPercentDamageMultiplierLocationShipModulesRequiringSmallHybridTurret",1,1,1,0,0,"None",0,0,0,0,899689);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (174,"smallProjectileTurretDamageMultiplierBonusPostPercentDamageMultiplierLocationShipModulesRequiringSmallProjectileTurret",0,1278,1279,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"smallProjectileTurretDamageMultiplierBonusPostPercentDamageMultiplierLocationShipModulesRequiringSmallProjectileTurret",1,1,1,0,0,"None",0,0,0,0,899692);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (187,"caldariCruiserSkillBoostCcTRangeBonus",0,1331,1332,"Boost of ccTRangeBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"caldariCruiserSkillBoostCcTRangeBonus",1,1,1,0,0,"None",0,0,0,0,899695);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (189,"caldariFrigateSkillBoostCfTRangeBonus",0,1338,1339,"Boost of cfTRangeBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"caldariFrigateSkillBoostCfTRangeBonus",1,1,1,0,0,"None",0,0,0,0,899698);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (204,"signatureAnalysisSkillBoostScanspeedBonus",0,1403,1404,"Boost of scanspeedBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"signatureAnalysisSkillBoostScanspeedBonus",1,1,1,0,0,"None",0,0,0,0,899701);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (205,"signatureAnalysisScanspeedBonusPostPercentScanSpeedLocationShip",0,1407,1408,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"Targeting Speed Bonus",1,1,1,0,0,"None",0,0,0,0,899704);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (206,"longRangeTargetingSkillBoostMaxTargetRangeBonus",0,1412,1413,"Boost of MaxTargetRangeBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"longRangeTargetingSkillBoostMaxTargetRangeBonus",1,1,1,0,0,"None",0,0,0,0,899707);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (208,"propulsionJammingSkillBoostDurationBonus",0,1423,1424,"Boost of durationBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"propulsionJammingSkillBoostDurationBonus",1,1,1,0,0,"None",0,0,0,0,899710);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (209,"propulsionJammingDurationBonusPostPercentDurationLocationShipModulesRequiringPropulsionJamming",0,1429,1430,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"propulsionJammingDurationBonusPostPercentDurationLocationShipModulesRequiringPropulsionJamming",1,1,1,0,0,"None",0,0,0,0,899713);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (210,"sensorLinkingDurationBonusPostPercentDurationLocationShipModulesRequiringSensorLinking",0,1435,1436,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"sensorLinkingDurationBonusPostPercentDurationLocationShipModulesRequiringSensorLinking",1,1,1,0,0,"None",0,0,0,0,899716);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (211,"sensorUpgradesSkillBoostCpuNeedBonus",0,1440,1441,"Boost of cpuNeedBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"sensorUpgradesSkillBoostCpuNeedBonus",1,1,1,0,0,"None",0,0,0,0,899719);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (212,"sensorUpgradesCpuNeedBonusPostPercentCpuLocationShipModulesRequiringSensorUpgrades",0,1446,1447,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"CPU need reduction",1,1,1,0,0,"None",0,0,0,0,899722);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (213,"targetingSkillBoostMaxTargetBonus",0,1451,1452,"Boost of maxTarget Bonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"targetingSkillBoostMaxTargetBonus",1,1,1,0,0,"None",0,0,0,0,899725);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (214,"targetingMaxTargetBonusModAddMaxLockedTargetsLocationChar",0,1453,1454,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"targetingMaxTargetBonusModAddMaxLockedTargetsLocationChar",1,1,1,0,0,"None",0,0,0,0,899728);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (215,"weaponDisruptionDurationBonusPostPercentDurationLocationShipModulesRequiringWeaponDisruption",0,1459,1460,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"Duration Bonus",1,1,1,0,0,"None",0,0,0,0,899731);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (216,"electronicWarfareSkillBoostDurationBonus",0,1464,1465,"Boost of DurationBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"electronicWarfareSkillBoostDurationBonus",1,1,1,0,0,"None",0,0,0,0,899734);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (218,"engineeringSkillBoostPowerOutputBonus",0,1475,1476,"Boost of PowerOutputBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"engineeringSkillBoostPowerOutputBonus",1,1,1,0,0,"None",0,0,0,0,899737);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (220,"energyManagementSkillBoostCapRechargeBonus",0,1482,1483,"Boost of CapRechargeBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"energyManagementSkillBoostCapRechargeBonus",1,1,1,0,0,"None",0,0,0,0,899740);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (222,"navigationSkillBoostVelocityBonus",0,1491,1492,"Boost of velocityBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"navigationSkillBoostVelocityBonus",1,1,1,0,0,"None",0,0,0,0,899743);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (223,"navigationVelocityBonusPostPercentMaxVelocityLocationShip",0,1494,1495,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"Velocity Bonus",1,1,1,0,0,"None",0,0,0,0,899746);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (225,"accerationControlSkillBoostCapNeedBonus",0,1504,1505,"Boost of capNeedBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"accerationControlSkillBoostCapNeedBonus",1,1,1,0,0,"None",0,0,0,0,899749);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (227,"accerationControlCapNeedBonusPostPercentCapacitorNeedLocationShipGroupAfterburner",0,1516,1517,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"Capacitor need reduction",1,1,1,0,0,"None",0,0,0,0,899752);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (228,"accerationControlSkillBoostSpeedFBonus",0,1521,1522,"Boost of speedFBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"accerationControlSkillBoostSpeedFBonus",1,1,1,0,0,"None",0,0,0,0,899755);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (230,"afterburnerDurationBonusPostPercentDurationLocationShipModulesRequiringAfterburner",0,1531,1532,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"afterburnerDurationBonusPostPercentDurationLocationShipModulesRequiringAfterburner",1,1,1,0,0,"None",0,0,0,0,899758);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (232,"evasiveManuveringSkillBoostAgilityBonus",0,1541,1542,"Boost of agilityBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"evasiveManuveringSkillBoostAgilityBonus",1,1,1,0,0,"None",0,0,0,0,899761);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (234,"warpdriveoperationSkillBoostWarpCapacitorNeedBonus",0,1549,1550,"Boost of warpCapacitorNeedBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"warpdriveoperationSkillBoostWarpCapacitorNeedBonus",1,1,1,0,0,"None",0,0,0,0,899764);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (235,"warpdriveoperationWarpCapacitorNeedBonusPostPercentWarpCapacitorNeedLocationShip",0,1553,1554,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"warpdriveoperationWarpCapacitorNeedBonusPostPercentWarpCapacitorNeedLocationShip",1,1,1,0,0,"None",0,0,0,0,899767);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (236,"energyEmmisionSystemsCapNeedBonusPostPercentCapacitorNeedLocationShipModulesRequiringEnergyEmmisionSystems",0,1559,1560,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"Capacitor Need Reduction",1,1,1,0,0,"None",0,0,0,0,899770);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (239,"corporationManagementSkillBoostCorporationMemberBonus",0,1574,1575,"Boost of corporationMemberBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"corporationManagementSkillBoostCorporationMemberBonus",1,1,1,0,0,"None",0,0,0,0,899773);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (242,"accerationControlSpeedFBonusPostPercentSpeedFactorLocationShipGroupAfterburner",0,1587,1588,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"Aterburner Velocity Bonus",1,1,1,0,0,"None",0,0,0,0,899776);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (243,"highSpeedManuveringSkillBoostCapacitorNeedMultiplier",0,1591,1592,"Boost of capacitorNeedMultiplier by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"highSpeedManuveringSkillBoostCapacitorNeedMultiplier",1,1,1,0,0,"None",0,0,0,0,899779);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (244,"highSpeedManuveringCapacitorNeedMultiplierPostPercentCapacitorNeedLocationShipModulesRequiringHighSpeedManuvering",0,1597,1598,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"highSpeedManuveringCapacitorNeedMultiplierPostPercentCapacitorNeedLocationShipModulesRequiringHighSpeedManuvering",1,1,1,0,0,"None",0,0,0,0,899782);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (246,"sensorUpgradesSkillBoostPowerNeedBonus",0,1614,1615,"Boost of PowerNeedBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"sensorUpgradesSkillBoostPowerNeedBonus",1,1,1,0,0,"None",0,0,0,0,899785);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (251,"hullUpgradesSkillBoostHullHpBonus",0,1631,1632,"Boost of hullHpBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"hullUpgradesSkillBoostHullHpBonus",1,1,1,0,0,"None",0,0,0,0,899788);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (253,"shadowBarrageDmgMultiplierWithDamageMultiplierPostPercentBarrageDmgMutator",0,1645,1646,"Set barrageDmgMultiplier to damageMultiplier modified (PostPercent) by BarrageDmgMutator","",0,0,0,0,0,0,0,0,0,"shadowBarrageDmgMultiplierWithDamageMultiplierPostPercentBarrageDmgMutator",1,1,1,0,0,"None",0,0,0,0,899791);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (254,"shadowBarrageFalloffWithFalloffPostPercentBarrageFalloffMutator",0,1657,1658,"Set barrageFalloff to falloff modified (PostPercent) by barrageFalloffMutator","",0,0,0,0,0,0,0,0,0,"shadowBarrageFalloffWithFalloffPostPercentBarrageFalloffMutator",1,1,1,0,0,"None",0,0,0,0,899794);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (263,"barrage",2,1659,1104,"Barrage Attack, Attack with barrageDmgMultiplier as a damage multiplier","effects.Barrage",0,0,1,51,160,6,54,328,1,"Barrage Attack",0,1,1,0,0,"None",0,0,0,0,899797);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (267,"amarrCruiserSkillBoostPowerOutputBonus",0,1676,1677,"Boost of powerOutputBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"amarrCruiserSkillBoostPowerOutputBonus",1,1,1,0,0,"None",0,0,0,0,899800);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (270,"hullUpgradesSkillBoostArmorHpBonus",0,1689,1690,"Boost of armorHpBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"hullUpgradesSkillBoostArmorHpBonus",1,1,1,0,0,"None",0,0,0,0,899803);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (271,"hullUpgradesArmorHpBonusPostPercentHpLocationShip",0,1691,1692,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"Armor Hp Bonus",1,1,1,0,0,"None",0,0,0,0,899806);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (272,"repairSystemsDurationBonusPostPercentDurationLocationShipModulesRequiringRepairSystems",0,1697,1698,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"repairSystemsDurationBonusPostPercentDurationLocationShipModulesRequiringRepairSystems",1,1,1,0,0,"None",0,0,0,0,899809);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (273,"shieldUpgradesPowerNeedBonusPostPercentPowerLocationShipModulesRequiringShieldUpgrades",0,1703,1704,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"Power need reduction",1,1,1,0,0,"None",0,0,0,0,899812);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (274,"energyManagementSkillBoostCapacitorBonus",0,1707,1708,"Boost of capacitorBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"energyManagementSkillBoostCapacitorBonus",1,1,1,0,0,"None",0,0,0,0,899815);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (277,"tacticalshieldManipulationSkillBoostUniformityBonus",0,1721,1722,"Boost of uniformityBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"tacticalshieldManipulationSkillBoostUniformityBonus",1,1,1,0,0,"None",0,0,0,0,899818);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (279,"shieldEmmisionSystemsCapNeedBonusPostPercentCapacitorNeedLocationShipModulesRequiringShieldEmmisionSystems",0,1732,1733,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"Capacitor need Bonus",1,1,1,0,0,"None",0,0,0,0,899821);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (280,"shieldManagementSkillBoostShieldCapacityBonus",0,1737,1738,"Boost of shieldCapacityBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"shieldManagementSkillBoostShieldCapacityBonus",1,1,1,0,0,"None",0,0,0,0,899824);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (283,"shieldoperationSkillBoostRechargeratebonus",0,1751,1752,"Boost of rechargeratebonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"shieldoperationSkillBoostRechargeratebonus",1,1,1,0,0,"None",0,0,0,0,899827);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (287,"controlledBurstsCapNeedBonusPostPercentCapacitorNeedLocationShipModulesRequiringGunnery",0,1774,1775,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"Capacitor Need Reductin",1,1,1,0,0,"None",0,0,0,0,899830);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (288,"skillBoostTrackingSpeedMultiplier",0,1782,1783,"Boost of trackingSpeedMultiplier by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"skillBoostTrackingSpeedMultiplier",1,1,1,0,0,"None",0,0,0,0,899833);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (289,"motionPredictionTrackingSpeedMultiplierPostPercentTrackingSpeedLocationShipModulesRequiringGunnery",0,1786,1787,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"Tracking speed bonus",1,1,1,0,0,"None",0,0,0,0,899836);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (290,"sharpshooterRangeSkillBonusPostPercentMaxRangeLocationShipModulesRequiringGunnery",0,1790,1791,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"Range Bonus",1,1,1,0,0,"None",0,0,0,0,899839);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (297,"skillBoostFalloffBonus",0,1806,1807,"Boost of falloffBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"skillBoostFalloffBonus",1,1,1,0,0,"None",0,0,0,0,899842);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (298,"surgicalStrikeFalloffBonusPostPercentFalloffLocationShipModulesRequiringGunnery",0,1810,1811,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"Falloff Bonus",1,1,1,0,0,"None",0,0,0,0,899845);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (301,"empathySkillBoostCharismaBonus",0,1824,1825,"Boost of charismaBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"empathySkillBoostCharismaBonus",1,1,1,0,0,"None",0,0,0,0,899848);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (302,"empathyCharismaBonusModAddCharismaLocationChar",0,1826,1827,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"Charisma Bonus",1,1,1,0,0,"None",0,0,0,0,899851);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (303,"instantRecallSkillBoostMemoryBonus",0,1830,1831,"Boost of memoryBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"instantRecallSkillBoostMemoryBonus",1,1,1,0,0,"None",0,0,0,0,899854);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (304,"instantRecallMemoryBonusModAddMemoryLocationChar",0,1832,1833,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"instantRecallMemoryBonusModAddMemoryLocationChar",1,1,1,0,0,"None",0,0,0,0,899857);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (305,"analyticalMindSkillBoostIntelligenceBonus",0,1836,1837,"Boost of intelligenceBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"analyticalMindSkillBoostIntelligenceBonus",1,1,1,0,0,"None",0,0,0,0,899860);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (306,"analyticalMindIntelligenceBonusModAddIntelligenceLocationChar",0,1838,1839,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"Inteligence bonus",1,1,1,0,0,"None",0,0,0,0,899863);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (307,"ironWillSkillBoostWillpowerBonus",0,1842,1843,"Boost of willpowerBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"ironWillSkillBoostWillpowerBonus",1,1,1,0,0,"None",0,0,0,0,899866);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (308,"ironWillWillpowerBonusModAddWillpowerLocationChar",0,1844,1845,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"Willpower bonus",1,1,1,0,0,"None",0,0,0,0,899869);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (309,"spatialAwarenessSkillBoostPerceptionBonus",0,1848,1849,"Boost of perceptionBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"spatialAwarenessSkillBoostPerceptionBonus",1,1,1,0,0,"None",0,0,0,0,899872);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (310,"spatialAwarenessPerceptionBonusModAddPerceptionLocationChar",0,1850,1851,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"Preception bonus",1,1,1,0,0,"None",0,0,0,0,899875);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (312,"signatureAnalysisMaxTargetRangeBonusPostPercentMaxTargetRangeLocationShip",0,1857,1858,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"signatureAnalysisMaxTargetRangeBonusPostPercentMaxTargetRangeLocationShip",1,1,1,0,0,"None",0,0,0,0,899878);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (315,"dronesSkillBoostMaxActiveDroneBonus",0,1872,1873,"Boost of maxActiveDroneBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"dronesSkillBoostMaxActiveDroneBonus",1,1,1,0,0,"None",0,0,0,0,899881);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (316,"dronesMaxActiveDroneBonusModAddMaxActiveLocationChar",0,1876,1877,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"dronesMaxActiveDroneBonusModAddMaxActiveDronesLocationChar",1,1,1,0,0,"None",0,0,0,0,899884);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (317,"amarrTechSkillBoostAmarrTechMutator",0,1894,1895,"Boost of amarrTechMutator by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"amarrTechSkillBoostAmarrTechMutator",1,1,1,0,0,"None",0,0,0,0,899887);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (318,"amarrTechAmarrTechMutatorPostPercentAmarrTechTimePercentLocationChar",0,1898,1899,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"Amarr tech skill bonus",1,1,1,0,0,"None",0,0,0,0,899890);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (319,"caldariTechSkillBoostCaldariTechMutator",0,1903,1904,"Boost of caldariTechMutator by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"caldariTechSkillBoostCaldariTechMutator",1,1,1,0,0,"None",0,0,0,0,899893);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (320,"caldariTechCaldariTechMutatorPostPercentCaldariTechTimePercentLocationChar",0,1907,1908,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"Caldari tech production bonus",1,1,1,0,0,"None",0,0,0,0,899896);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (321,"gallenteTechSkillBoostGallenteTechMutator",0,1912,1913,"Boost of gallenteTechMutator by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"gallenteTechSkillBoostGallenteTechMutator",1,1,1,0,0,"None",0,0,0,0,899899);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (322,"gallenteTechGallenteTechMutatorPostPercentGallenteTechTimePercentLocationChar",0,1916,1917,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"Gallente Tech time",1,1,1,0,0,"None",0,0,0,0,899902);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (325,"minmatarTechSkillBoostMinmatarTechMutator",0,1930,1931,"Boost of minmatarTechMutator by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"minmatarTechSkillBoostMinmatarTechMutator",1,1,1,0,0,"None",0,0,0,0,899905);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (326,"minmatarTechMinmatarTechMutatorPostPercentMinmatarTechTimePercentLocationChar",0,1934,1935,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"Minmatar tech bonus",1,1,1,0,0,"None",0,0,0,0,899908);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (331,"refineryEfficiencySkillBoostRefiningYieldMutator",0,1959,1960,"Boost of refiningYieldMutator by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"refineryEfficiencySkillBoostRefiningYieldMutator",1,1,1,0,0,"None",0,0,0,0,899911);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (334,"cSOTrainingSkillBoostResearchGangSizeBonus",0,1995,1996,"Boost of researchGangSizeBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"cSOTrainingSkillBoostResearchGangSizeBonus",1,1,1,0,0,"None",0,0,0,0,899914);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (335,"cSOTrainingResearchGangSizeBonusModAddMaxResearchGangSizeShip",0,1999,2000,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"cSOTrainingResearchGangSizeBonusModAddMaxResearchGangSizeShip",1,1,1,0,0,"None",0,0,0,0,899917);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (336,"battleshipConstructionSkillBoostBattleshipConstructionTimeBonus",0,2004,2005,"Boost of battleshipConstructionTimeBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"battleshipConstructionSkillBoostBattleshipConstructionTimeBonus",1,1,1,0,0,"None",0,0,0,0,899920);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (337,"battleshipConstructionBattleshipConstructionTimeBonusPostPercentBattleshipConstructionTimeChar",0,2008,2009,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"Battleship Construction Time",1,1,1,0,0,"None",0,0,0,0,899923);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (338,"cruiserConstructionSkillBoostCruiserConstructionTimeBonus",0,2013,2014,"Boost of cruiserConstructionTimeBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"cruiserConstructionSkillBoostCruiserConstructionTimeBonus",1,1,1,0,0,"None",0,0,0,0,899926);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (339,"cruiserConstructionCruiserConstructionTimeBonusPostPercentCruiserConstructionTimeChar",0,2017,2018,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"cruiserConstructionCruiserConstructionTimeBonusPostPercentCruiserConstructionTimeChar",1,1,1,0,0,"None",0,0,0,0,899929);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (340,"frigateConstructionSkillBoostFrigateConstructionTimeBonus",0,2022,2023,"Boost of frigateConstructionTimeBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"frigateConstructionSkillBoostFrigateConstructionTimeBonus",1,1,1,0,0,"None",0,0,0,0,899932);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (341,"frigateConstructionFrigateConstructionTimeBonusPostPercentFrigateConstructionTimeChar",0,2026,2027,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"frigateConstructionFrigateConstructionTimeBonusPostPercentFrigateConstructionTimeChar",1,1,1,0,0,"None",0,0,0,0,899935);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (342,"industrialConstructionSkillBoostIndustrialConstructionTimeBonus",0,2031,2032,"Boost of industrialConstructionTimeBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"industrialConstructionSkillBoostIndustrialConstructionTimeBonus",1,1,1,0,0,"None",0,0,0,0,899938);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (343,"industrialConstructionIndustrialConstructionTimeBonusPostPercentIndustrialConstructionTimeChar",0,2035,2036,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"industrialConstructionIndustrialConstructionTimeBonusPostPercentIndustrialConstructionTimeChar",1,1,1,0,0,"None",0,0,0,0,899941);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (344,"connectionsSkillBoostConnectionBonusMutator",0,2040,2041,"Boost of connectionBonusMutator by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"connectionsSkillBoostConnectionBonusMutator",1,1,1,0,0,"None",0,0,0,0,899944);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (346,"criminalConnectionsSkillBoostCriminalConnectionsMutator",0,2049,2050,"Boost of criminalConnectionsMutator by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"criminalConnectionsSkillBoostCriminalConnectionsMutator",1,1,1,0,0,"None",0,0,0,0,899947);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (348,"diplomacySkillBoostDiplomacyMutator",0,2058,2059,"Boost of diplomacyMutator by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"diplomacySkillBoostDiplomacyMutator",1,1,1,0,0,"None",0,0,0,0,899950);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (349,"diplomacyDiplomacyMutatorModAddDiplomacyBonusChar",0,2062,2063,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"diplomacyDiplomacyMutatorModAddDiplomacyBonusChar",1,1,1,0,0,"None",0,0,0,0,899953);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (350,"fasttalkSkillBoostFastTalkMutator",0,2067,2068,"Boost of fastTalkMutator by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"fasttalkSkillBoostFastTalkMutator",1,1,1,0,0,"None",0,0,0,0,899956);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (352,"fasttalkFastTalkMutatorPostPercentFastTalkPercentageChar",0,2074,2075,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"fasttalkFastTalkMutatorPostPercentFastTalkPercentageChar",1,1,1,0,0,"None",0,0,0,0,899959);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (353,"ethnicRelationsSkillBoostNonRaceCorporationMembersBonus",0,2081,2082,"Boost of nonRaceCorporationMembersBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"ethnicRelationsSkillBoostNonRaceCorporationMembersBonus",1,1,1,0,0,"None",0,0,0,0,899962);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (354,"ethnicRelationsNonRaceCorporationMembersBonusPostPercentMaxNonRaceCorporationMembersChar",0,2085,2086,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"ethnicRelationsNonRaceCorporationMembersBonusPostPercentMaxNonRaceCorporationMembersChar",1,1,1,0,0,"None",0,0,0,0,899965);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (355,"ethnicRelationsNonRaceCorporationMembersBonusModAddMaxNonRaceCorporationMembersChar",0,2088,2089,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"ethnicRelationsNonRaceCorporationMembersBonusModAddMaxNonRaceCorporationMembersChar",1,1,1,0,0,"None",0,0,0,0,899968);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (356,"assaultFormationDamageMultiplierBonusPostPercentDamageMultiplierGangShipModulesRequiringGunnery",0,2092,2093,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"assaultFormationDamageMultiplierBonusPostPercentDamageMultiplierGangShipModulesRequiringGunnery",1,1,1,0,0,"None",0,0,0,0,899971);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (368,"gallenteFrigateSkillBoostCpuOutputBonus",0,2157,2158,"Boost of cpu OutputBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"gallenteFrigateSkillBoostCpuOutputBonus",1,1,1,0,0,"None",0,0,0,0,899974);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (389,"astrogeologySkillBoostMiningAmountBonus",0,2232,2233,"Boost of miningAmountBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"astrogeologySkillBoostMiningAmountBonus",1,1,1,0,0,"None",0,0,0,0,899977);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (391,"astrogeologyMiningAmountBonusPostPercentMiningAmountLocationShipModulesRequiringMining",0,2240,2241,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"astrogeologyMiningAmountBonusPostPercentMiningAmountLocationShipModulesRequiringMining",1,1,1,0,0,"None",0,0,0,0,899980);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (392,"mechanicHullHpBonusPostPercentHpShip",0,2242,2243,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"mechanicHullHpBonusPostPercentHpShip",1,1,1,0,0,"None",0,0,0,0,899983);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (394,"navigationVelocityBonusPostPercentMaxVelocityShip",0,2248,2249,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"navigationVelocityBonusPostPercentMaxVelocityShip",1,1,1,0,0,"None",0,0,0,0,899986);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (395,"evasiveManeuveringAgilityBonusPostPercentAgilityShip",0,2250,2251,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"evasiveManeuveringAgilityBonusPostPercentAgilityShip",1,1,1,0,0,"None",0,0,0,0,899989);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (396,"energyGridUpgradesCpuNeedBonusPostPercentCpuLocationShipModulesRequiringEnergyGridUpgrades",0,2256,2257,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"energyGridUpgradesCpuNeedBonusPostPercentCpuLocationShipModulesRequiringEnergyGridUpgrades",1,1,1,0,0,"None",0,0,0,0,899992);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (397,"electronicsCpuOutputBonusPostPercentCpuOutputLocationShipGroupComputer",0,2258,2259,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"electronicsCpuOutputBonusPostPercentCpuOutputLocationShipGroupComputer",1,1,1,0,0,"None",0,0,0,0,899995);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (399,"connectionsConnectionBonusMutatorModAddConnectionsBonusChar",0,2269,2270,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"connectionsConnectionBonusMutatorModAddConnectionsBonusChar",1,1,1,0,0,"None",0,0,0,0,899998);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (402,"criminalConnectionsCriminalConnectionsMutatorModAddCriminalConnectionsBonusChar",0,2278,2279,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"criminalConnectionsCriminalConnectionsMutatorModAddCriminalConnectionsBonusChar",1,1,1,0,0,"None",0,0,0,0,900001);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (403,"negotiationSkillBoostNegotiationBonus",0,2283,2284,"Boost of NegotiationBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"negotiationSkillBoostNegotiationBonus",1,1,1,0,0,"None",0,0,0,0,900004);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (404,"negotiationNegotiationBonusPostPercentNegotiationPercentageChar",0,2287,2288,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"negotiationNegotiationBonusPostPercentNegotiationPercentageChar",1,1,1,0,0,"None",0,0,0,0,900007);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (406,"socialSkillBoostSocialMutator",0,2296,2297,"Boost of socialMutator by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"socialSkillBoostSocialMutator",1,1,1,0,0,"None",0,0,0,0,900010);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (407,"socialSocialMutatorPostPercentSocialBonusChar",0,2300,2301,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"socialSocialMutatorPostPercentSocialBonusChar",1,1,1,0,0,"None",0,0,0,0,900013);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (408,"largeProjectileTurretDamageMultiplierBonusPostPercentDamageMultiplierLocationShipModulesRequiringLargeProjectileTurret",0,2306,2307,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"largeProjectileTurretDamageMultiplierBonusPostPercentDamageMultiplierLocationShipModulesRequiringLargeProjectileTurret",1,1,1,0,0,"None",0,0,0,0,900016);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (412,"industrySkillBoostManufacturingTimeBonus",0,2323,2324,"Boost of manufacturingTimeBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"industrySkillBoostManufacturingTimeBonus",1,1,1,0,0,"None",0,0,0,0,900019);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (413,"gunnerySkillBoostTurretSpeeBonus",0,2328,2329,"Boost of TurretSpeeBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"gunnerySkillBoostTurretSpeeBonus",1,1,1,0,0,"None",0,0,0,0,900022);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (414,"gunneryTurretSpeeBonusPostPercentSpeedLocationShipModulesRequiringGunnery",0,2330,2331,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"gunneryTurretSpeeBonusPostPercentSpeedLocationShipModulesRequiringGunnery",1,1,1,0,0,"None",0,0,0,0,900025);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (415,"tradeSkillBoostTradePremiumBonus",0,2339,2340,"Boost of tradePremiumBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"tradeSkillBoostTradePremiumBonus",1,1,1,0,0,"None",0,0,0,0,900028);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (416,"tradeTradePremiumBonusPostPercentTradePremiumChar",0,2343,2344,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"tradeTradePremiumBonusPostPercentTradePremiumChar",1,1,1,0,0,"None",0,0,0,0,900031);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (417,"smugglingSkillBoostSmugglingChanceBonus",0,2348,2349,"Boost of smugglingChanceBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"smugglingSkillBoostSmugglingChanceBonus",1,1,1,0,0,"None",0,0,0,0,900034);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (425,"industryManufacturingTimeBonusPostPercentManufactureTimeMultiplierChar",0,2379,2380,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"industryManufacturingTimeBonusPostPercentManufactureTimeMultiplierChar",1,1,1,0,0,"None",0,0,0,0,900037);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (428,"productionEfficiencySkillBoostManufactureCostBonus",0,2393,2394,"Boost of manufactureCostBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"productionEfficiencySkillBoostManufactureCostBonus",1,1,1,0,0,"None",0,0,0,0,900040);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (429,"productionEfficiencyManufactureCostBonusPostPercentManufactureCostMultiplierChar",0,2395,2396,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"productionEfficiencyManufactureCostBonusPostPercentManufactureCostMultiplierChar",1,1,1,0,0,"None",0,0,0,0,900043);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (430,"scienceSkillBoostCopySpeedBonus",0,2400,2401,"Boost of CopySpeedBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"scienceSkillBoostCopySpeedBonus",1,1,1,0,0,"None",0,0,0,0,900046);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (431,"scienceCopySpeedBonusPostPercentCopySpeedPercentChar",0,2404,2405,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"scienceCopySpeedBonusPostPercentCopySpeedPercentChar",1,1,1,0,0,"None",0,0,0,0,900049);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (432,"researchSkillBoostBlueprintmanufactureTimeBonus",0,2409,2410,"Boost of blueprintmanufactureTimeBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"researchSkillBoostBlueprintmanufactureTimeBonus",1,1,1,0,0,"None",0,0,0,0,900052);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (433,"researchBlueprintmanufactureTimeBonusPostPercentProductionTimeResearchSpeedChar",0,2413,2414,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"researchBlueprintmanufactureTimeBonusPostPercentProductionTimeResearchSpeedChar",1,1,1,0,0,"None",0,0,0,0,900055);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (435,"refineryEfficiencyRefiningYieldMutatorPostPercentRefiningYieldPercentageChar",0,2421,2422,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"refineryEfficiencyRefiningYieldMutatorPostPercentRefiningYieldPercentageChar",1,1,1,0,0,"None",0,0,0,0,900058);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (436,"missileLauncherOperationSpeedBonusPostPercentSpeedLocationShipModulesRequiringMissileLauncherOperation",0,2429,2430,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"missileLauncherOperationSpeedBonusPostPercentSpeedLocationShipModulesRequiringMissileLauncherOperation",1,1,1,0,0,"None",0,0,0,0,900061);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (439,"learningSkillBoostLearningBonus",0,2446,2447,"Boost of learningBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"learningSkillBoostLearningBonus",1,1,1,0,0,"None",0,0,0,0,900064);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (440,"learningLearningBonusPostPercentIntelligenceChar",0,2449,2450,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"learningLearningBonusPostPercentIntelligenceChar",1,1,1,0,0,"None",0,0,0,0,900067);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (441,"learningLearningBonusPostPercentWillpowerChar",0,2452,2453,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"learningLearningBonusPostPercentWillpowerChar",1,1,1,0,0,"None",0,0,0,0,900070);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (442,"learningLearningBonusPostPercentPerceptionChar",0,2455,2456,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"learningLearningBonusPostPercentPerceptionChar",1,1,1,0,0,"None",0,0,0,0,900073);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (443,"learningLearningBonusPostPercentCharismaChar",0,2458,2459,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"learningLearningBonusPostPercentCharismaChar",1,1,1,0,0,"None",0,0,0,0,900076);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (444,"learningLearningBonusPostPercentMemoryChar",0,2461,2462,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"learningLearningBonusPostPercentMemoryChar",1,1,1,0,0,"None",0,0,0,0,900079);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (445,"energyManagementCapacitorBonusPostPercentCapacityLocationShipGroupCapacitor",0,2468,2469,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"energyManagementCapacitorBonusPostPercentCapacityLocationShipGroupCapacitor",1,1,1,0,0,"None",0,0,0,0,900082);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (446,"shieldManagementShieldCapacityBonusPostPercentCapacityLocationShipGroupShield",0,2472,2473,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shieldManagementShieldCapacityBonusPostPercentCapacityLocationShipGroupShield",1,1,1,0,0,"None",0,0,0,0,900085);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (448,"scoutDroneOperationSkillBoostDroneRangeBonus",0,2481,2482,"Boost of droneRangeBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"scoutDroneOperationSkillBoostDroneRangeBonus",1,1,1,0,0,"None",0,0,0,0,900088);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (452,"shipVelocityBonusMF",0,2497,2498,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipVelocityBonusMF",1,1,1,0,0,"None",0,0,0,0,900091);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (453,"minmatarFrigateSkillLevelPreMulShipBonusMFShip",0,2500,2501,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"minmatarFrigateSkillLevelPreMulShipBonusMFShip",1,1,1,0,0,"None",0,0,0,0,900094);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (456,"shipTargetRangeBonusMF",0,2511,2512,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipTargetRangeBonusMF",1,1,1,0,0,"None",0,0,0,0,900097);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (458,"shipCargoBonusMF",0,2515,2516,"Automatically generated effect","",0,0,1,0,0,0,0,0,0,"shipCapacityBonusMF",1,1,1,0,0,"None",0,0,0,0,900100);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (459,"shipMiningBonusMF",0,2517,2518,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipMiningBonusMF",1,1,1,0,0,"None",0,0,0,0,900103);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (460,"caldariFrigateSkillLevelPreMulShipBonusCFShip",0,2524,2525,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"caldariFrigateSkillLevelPreMulShipBonusCFShip",1,1,1,0,0,"None",0,0,0,0,900106);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (462,"shipHybridRangeBonusCF",0,2534,2535,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipHybridRangeBonusCF",1,1,1,0,0,"None",0,0,0,0,900109);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (464,"shipShieldCapBonusCF",0,2538,2539,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipShieldCapBonusCF",1,1,1,0,0,"None",0,0,0,0,900112);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (466,"shipTargetRangeBonusCF",0,2542,2543,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipTargetRangeBonusCF",1,1,1,0,0,"None",0,0,0,0,900115);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (468,"gallenteFrigateSkillLevelPreMulShipBonusGFShip",0,2548,2549,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"gallenteFrigateSkillLevelPreMulShipBonusGFShip",1,1,1,0,0,"None",0,0,0,0,900118);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (469,"shipMiningBonusGF",0,2550,2551,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipMiningBonusGF",1,1,1,0,0,"None",0,0,0,0,900121);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (472,"shipHybridTrackingBonusGf",0,2561,2562,"Automatically generated effect","",0,0,1,0,0,0,0,0,0,"shipHybridTrackingBonus",1,1,1,0,0,"None",0,0,0,0,900124);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (474,"shipTargetRangeBonusGF",0,2566,2567,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipTargetRangeBonusGF",1,1,1,0,0,"None",0,0,0,0,900127);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (476,"amarrFrigateSkillLevelPreMulShipBonusAFShip",0,2573,2574,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"amarrFrigateSkillLevelPreMulShipBonusAFShip",1,1,1,0,0,"None",0,0,0,0,900130);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (479,"shipDroneRangeBonusGF",0,2581,2582,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipDroneRangeBonusGF",1,1,1,0,0,"None",0,0,0,0,900133);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (480,"shipCargoBonusAF",0,2583,2584,"Automatically generated effect","",0,0,1,0,0,0,0,0,0,"shipCargoBonus",1,1,1,0,0,"None",0,0,0,0,900136);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (481,"metallurgySkillBoostMineralNeedResearchBonus",0,2588,2589,"Boost of mineralNeedResearchBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"metallurgySkillBoostMineralNeedResearchBonus",1,1,1,0,0,"None",0,0,0,0,900139);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (482,"shipTargetingRangeBonusAF",0,2590,2591,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipTargetingRangeBonusAF",1,1,1,0,0,"None",0,0,0,0,900142);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (485,"energysystemsoperationCapRechargeBonusPostPercentRechargeRateLocationShipGroupCapacitor",0,2601,2602,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"energysystemsoperationCapRechargeBonusPostPercentRechargeRateLocationShipGroupCapacitor",1,1,1,0,0,"None",0,0,0,0,900145);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (486,"shieldOperationRechargeratebonusPostPercentRechargeRateLocationShipGroupShield",0,2603,2604,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shieldOperationRechargeratebonusPostPercentRechargeRateLocationShipGroupShield",1,1,1,0,0,"None",0,0,0,0,900148);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (490,"engineeringPowerEngineeringOutputBonusPostPercentPowerOutputLocationShipGroupPowerCore",0,2616,2617,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"engineeringPowerEngineeringOutputBonusPostPercentPowerOutputLocationShipGroupPowerCore",1,1,1,0,0,"None",0,0,0,0,900151);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (494,"warpDriveOperationWarpCapacitorNeedBonusPostPercentWarpCapacitorNeedLocationShipGroupPropulsion",0,2636,2637,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"warpDriveOperationWarpCapacitorNeedBonusPostPercentWarpCapacitorNeedLocationShipGroupPropulsion",1,1,1,0,0,"None",0,0,0,0,900154);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (496,"prototypingSkillBoostPrototypingBonus",0,2647,2648,"Boost of prototypingBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"prototypingSkillBoostPrototypingBonus",1,1,1,0,0,"None",0,0,0,0,900157);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (497,"prototypingPrototypingBonusModAddPrototypingChanceChar",0,2654,2656,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"prototypingPrototypingBonusModAddPrototypingChanceChar",1,1,1,0,0,"None",0,0,0,0,900160);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (498,"inventionSkillBoostInventionBonus",0,2655,2657,"Boost of inventionBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"inventionSkillBoostInventionBonus",1,1,1,0,0,"None",0,0,0,0,900163);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (500,"amarrCruiserSkillLevelPreMulShipBonusACShip",0,2668,2669,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"amarrCruiserSkillLevelPreMulShipBonusACShip",1,1,1,0,0,"None",0,0,0,0,900166);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (504,"scoutDroneOperationDroneRangeBonusModAddDroneControlDistanceChar",0,2674,2675,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"scoutDroneOperationDroneRangeBonusModAddDroneControlDistanceChar",1,1,1,0,0,"None",0,0,0,0,900169);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (506,"fuelConservationCapNeedBonusPostPercentCapacitorNeedLocationShipModulesRequiringAfterburner",0,2690,2691,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"fuelConservationCapNeedBonusPostPercentCapacitorNeedLocationShipModulesRequiringAfterburner",1,1,1,0,0,"None",0,0,0,0,900172);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (507,"longRangeTargetingMaxTargetRangeBonusPostPercentMaxTargetRangeLocationShipGroupElectronic",0,2692,2693,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"longRangeTargetingMaxTargetRangeBonusPostPercentMaxTargetRangeLocationShipGroupElectronic",1,1,1,0,0,"None",0,0,0,0,900175);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (508,"shipPDmgBonusMF",0,2736,2737,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipPDmgBonusMF",1,1,1,0,0,"None",0,0,0,0,900178);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (509,"shipCargoBonusCF",0,2738,2739,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipCargoBonusCF",1,1,1,0,0,"None",0,0,0,0,900181);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (510,"amarrFrigateSkillLevelPreMulShipBonus2AFShip",0,2743,2744,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"amarrFrigateSkillLevelPreMulShipBonus2AFShip",1,1,1,0,0,"None",0,0,0,0,900184);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (511,"shipEnergyTCapNeedBonusAF",0,2747,2748,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipEnergyTCapNeedBonusAF",1,1,1,0,0,"None",0,0,0,0,900187);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (512,"shipSHTDmgBonusGF",0,2751,2752,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipSHTDmgBonusGF",1,1,1,0,0,"None",0,0,0,0,900190);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (514,"shipSETDmgBonusAF",0,2753,2754,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipSETDmgBonusAF",1,1,1,0,0,"None",0,0,0,0,900193);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (516,"shipTCapNeedBonusAC",0,2761,2762,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipTCapNeedBonusAC",1,1,1,0,0,"None",0,0,0,0,900196);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (517,"gallenteCruiserSkillLevelPreMulShipBonusGCShip",0,2766,2767,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"gallenteCruiserSkillLevelPreMulShipBonusGCShip",1,1,1,0,0,"None",0,0,0,0,900199);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (520,"caldariCruiserSkillLevelPreMulShipBonusCCShip",0,2777,2778,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"caldariCruiserSkillLevelPreMulShipBonusCCShip",1,1,1,0,0,"None",0,0,0,0,900202);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (521,"shipHRangeBonusCC",0,2783,2784,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipHRangeBonusCC",1,1,1,0,0,"None",0,0,0,0,900205);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (524,"minmatarCruiserSkillLevelPreMulShipBonusMCShip",0,2802,2803,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"minmatarCruiserSkillLevelPreMulShipBonusMCShip",1,1,1,0,0,"None",0,0,0,0,900208);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (525,"shipVelocityBonusMC",0,2804,2805,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipVelocityBonusMC",1,1,1,0,0,"None",0,0,0,0,900211);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (526,"minmatarIndustrialSkillLevelPreMulShipBonusMIShip",0,2809,2810,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"minmatarIndustrialSkillLevelPreMulShipBonusMIShip",1,1,1,0,0,"None",0,0,0,0,900214);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (527,"shipVelocityBonusMI",0,2811,2812,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipVelocityBonusMI",1,1,1,0,0,"None",0,0,0,0,900217);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (529,"shipCargoBonusAI",0,2818,2819,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipCargoBonusAI",1,1,1,0,0,"None",0,0,0,0,900220);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (530,"caldariIndustrialSkillLevelPreMulShipBonusCIShip",0,2823,2824,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"caldariIndustrialSkillLevelPreMulShipBonusCIShip",1,1,1,0,0,"None",0,0,0,0,900223);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (532,"gallenteIndustrialSkillLevelPreMulShipBonusGIShip",0,2830,2831,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"gallenteIndustrialSkillLevelPreMulShipBonusGIShip",1,1,1,0,0,"None",0,0,0,0,900226);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (533,"shipPTrackingBonus",0,2833,2834,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipPTrackingBonus",1,1,1,0,0,"None",0,0,0,0,900229);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (536,"cpuMultiplierPostMulCpuOutputShip",4,2843,2844,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"cpuMultiplierPostMulCpuOutputShip",1,1,1,0,0,"None",0,0,0,0,900232);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (537,"droneBayBonus",4,2849,2850,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"droneBayBonus",1,1,1,0,0,"None",0,0,0,0,900235);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (538,"amarrBattleshipSkillLevelPostMulShipBonusABShip",0,2852,2853,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"amarrBattleshipSkillLevelPostMulShipBonusABShip",1,1,1,0,0,"None",0,0,0,0,900238);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (541,"caldariBattleshipSkillLevelPreMulShipBonusCBShip",0,2859,2860,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"caldariBattleshipSkillLevelPreMulShipBonusCBShip",1,1,1,0,0,"None",0,0,0,0,900241);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (542,"shipCapNeedBonusAB",0,2865,2866,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipCapNeedBonusAB",1,1,1,0,0,"None",0,0,0,0,900244);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (548,"minmatarBattleshipSkillLevelPreMulShipBonusMBShip",0,2886,2887,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"minmatarBattleshipSkillLevelPreMulShipBonusMBShip",1,1,1,0,0,"None",0,0,0,0,900247);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (549,"shipPTDmgBonusMB",0,2889,2890,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipPTDmgBonusMB",1,1,1,0,0,"None",0,0,0,0,900250);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (550,"shipHTDmgBonusGB",0,2893,2894,"Automatically generated effect","",0,0,1,0,0,0,0,0,0,"shipHTDmgBonus",1,1,1,0,0,"None",0,0,0,0,900253);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (551,"shipPTRangeBonusMB",0,2897,2898,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipPTRangeBonusMB",1,1,1,0,0,"None",0,0,0,0,900256);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (553,"shipHTTrackingBonusGB",0,2904,2905,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipHTTrackingBonusGB",1,1,1,0,0,"None",0,0,0,0,900259);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (556,"caldariBattleshipSkillLevelPreMulShipBonus2CBShip",0,2916,2917,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"caldariBattleshipSkillLevelPreMulShipBonus2CBShip",1,1,1,0,0,"None",0,0,0,0,900262);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (558,"metallurgyMineralNeedResearchBonusPostPercentMineralNeedResearchSpeedChar",0,2924,2925,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"metallurgyMineralNeedResearchBonusPostPercentMineralNeedResearchSpeedChar",1,1,1,0,0,"None",0,0,0,0,900265);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (562,"shipHTDmgBonusfixedGC",0,2940,2941,"Automatically generated effect","",0,0,1,0,0,0,0,0,0,"ShipHTDmgBonusfixedGC",1,1,1,0,0,"None",0,0,0,0,900268);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (563,"warpScrambleForEntity",2,294,295,"Attempts to prevent the target from warping.","effects.WarpScramble",0,1,1,505,0,6,103,0,1,"Warp Scramble",1,1,1,0,0,"None",504,0,0,0,2565755);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (566,"laboratoryOperationSkillLevelModAddMaxLaborotorySlotsChar",0,2951,2952,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"laboratoryOperationSkillLevelModAddMaxLaborotorySlotsChar",1,1,1,0,0,"None",0,0,0,0,900274);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (568,"massProductionSkillLevelModAddManufactureSlotLimitChar",0,2958,2959,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"massProductionSkillLevelModAddManufactureSlotLimitChar",1,1,1,0,0,"None",0,0,0,0,900277);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (569,"missileLaunchingForEntity",2,114,89,"","",0,0,1,506,0,0,0,0,1,"missileLaunching",1,1,1,0,0,"None",0,0,0,0,900280);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (571,"reverseEngineeringInventionBonusModAddReverseEngineeringChanceLocationChar",0,2970,2971,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"reverseEngineeringInventionBonusModAddReverseEngineeringChanceLocationChar",1,1,1,0,0,"None",0,0,0,0,900283);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (575,"modifyTargetSpeed2",2,3489,3491,"","effects.ModifyTargetSpeed",0,1,1,513,0,515,514,0,1,"modifyTargetSpeed",1,1,1,0,0,"None",512,0,0,0,2569167);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (581,"weaponUpgradesCpuNeedBonusPostPercentCpuLocationShipModulesRequiringGunnery",0,3009,3010,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"weaponUpgradesCpuNeedBonusPostPercentCpuLocationShipModulesRequiringGunnery",1,1,1,0,0,"None",0,0,0,0,900289);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (582,"rapidFiringRofBonusPostPercentSpeedLocationShipModulesRequiringGunnery",0,3011,3012,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"rapidFiringRofBonusPostPercentSpeedLocationShipModulesRequiringGunnery",1,1,1,0,0,"None",0,0,0,0,900292);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (583,"amarrIndustrialSkillLevelPreMulShipBonusAI2Ship",0,2816,2817,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"amarrIndustrialSkillLevelPreMulShipBonusAI2Ship",1,1,1,0,0,"None",0,0,0,0,900295);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (584,"surgicalStrikeDamageMultiplierBonusPostPercentDamageMultiplierLocationShipModulesRequiringGunnery",0,3015,3016,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"surgicalStrikeDamageMultiplierBonusPostPercentDamageMultiplierLocationShipModulesRequiringGunnery",1,1,1,0,0,"None",0,0,0,0,900298);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (586,"decreaseTargetSpeed",2,3489,3491,"","effects.ModifyTargetSpeed",0,0,1,73,0,6,54,0,1,"Decrease Target Speed",1,1,1,0,0,"None",0,0,0,0,900301);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (587,"surgicalStrikeDamageMultiplierBonusPostPercentDamageMultiplierLocationShipGroupEnergyWeapon",0,2968,2969,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"surgicalStrikeDamageMultiplierBonusPostPercentDamageMultiplierLocationShipGroupEnergyWeapon",1,1,1,0,0,"None",0,0,0,0,900304);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (588,"surgicalStrikeDamageMultiplierBonusPostPercentDamageMultiplierLocationShipGroupProjectileWeapon",0,3023,3024,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"surgicalStrikeDamageMultiplierBonusPostPercentDamageMultiplierLocationShipGroupProjectileWeapon",1,1,1,0,0,"None",0,0,0,0,900307);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (589,"surgicalStrikeDamageMultiplierBonusPostPercentDamageMultiplierLocationShipGroupHybridWeapon",0,3027,3028,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"surgicalStrikeDamageMultiplierBonusPostPercentDamageMultiplierLocationShipGroupHybridWeapon",1,1,1,0,0,"None",0,0,0,0,900310);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (590,"energyPulseWeaponsDurationBonusPostPercentDurationLocationShipModulesRequiringEnergyPulseWeapons",0,3031,3032,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"energyPulseWeaponsDurationBonusPostPercentDurationLocationShipModulesRequiringEnergyPulseWeapons",1,1,1,0,0,"None",0,0,0,0,900313);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (592,"targetArmorRepair",2,131,3038,"","effects.RemoteArmourRepair",0,1,1,73,0,6,54,0,1,"targetArmorRepair",1,1,1,0,0,"None",0,0,0,0,900316);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (594,"armorExtender",4,3041,3042,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"armorExtender",1,1,1,0,0,"None",0,0,0,0,900319);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (596,"ammoInfluenceRange",0,3573,3574,"","",0,0,0,0,0,0,0,0,1,"ammoInfluence",1,1,1,0,0,"None",0,0,0,0,900322);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (597,"targetedEMResonanceMultiply",2,3050,3051,"Automatically generated effect","effects.EnergyDestabilization",0,1,1,73,0,6,54,0,0,"TargetedEMResonanceMultiply",1,1,1,0,0,"None",0,0,0,0,900325);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (598,"ammoSpeedMultiplier",0,3054,3055,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"ammoSpeedMultiplier",1,1,1,0,0,"None",0,0,0,0,900328);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (599,"ammoFallofMultiplier",0,3059,3060,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"ammoFallofMultiplier",1,1,1,0,0,"None",0,0,0,0,900331);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (600,"ammoTrackingMultiplier",0,3063,3064,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"ammoTrackingMultiplier",1,1,1,0,0,"None",0,0,0,0,900334);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (602,"shipPTurretSpeedBonusMC",0,3069,3070,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipPTurretSpeedBonusMC",1,1,1,0,0,"None",0,0,0,0,900337);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (604,"shipPTspeedBonusMB2",0,3076,3077,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipPTspeedBonusMB2",1,1,1,0,0,"None",0,0,0,0,900340);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (605,"minmatarBattleshipSkillLevelPreMulShipBonusMB2Ship",0,3080,3081,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"minmatarBattleshipSkillLevelPreMulShipBonusMB2Ship",1,1,1,0,0,"None",0,0,0,0,900343);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (607,"cloaking",1,3908,3909,"","effects.Cloaking",0,1,1,0,0,0,0,0,1,"Cloaking",1,1,1,0,0,"None",0,0,0,0,900346);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (609,"turretWeaponRangeTrackingSpeedMultiplyTargetHostile",2,1013,1014,"Modifies maximum turret weapon range and tracking speed on the active target for the length of the duration.","effects.ElectronicAttributeModifyTarget",0,1,1,73,0,6,54,158,1,"turretWeaponRangeTrackingSpeedMultiplyTargetHostile",1,1,1,0,0,"None",0,0,0,0,900349);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (611,"gallenteBattleshipSkillLevelPreMulShipBonusGBShip",0,3094,3095,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"gallenteBattleshipSkillLevelPreMulShipBonusGBShip",1,1,1,0,0,"None",0,0,0,0,900352);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (615,"targetedKineticResonanceMultiply",2,3123,3124,"Automatically generated effect","effects.EnergyDestabilization",0,1,0,73,0,6,54,0,0,"targetedKineticResonanceMultiply",1,1,1,0,0,"None",0,0,0,0,900355);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (616,"targetedThermalResonanceMultiply",2,3127,3128,"Automatically generated effect","effects.EnergyDestabilization",0,1,1,73,0,6,54,0,0,"TargetedThermalResonanceMultiply",1,1,1,0,0,"None",0,0,0,0,900358);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (617,"targetedExplosiveResonanceMultiply",2,3131,3132,"Automatically generated effect","effects.EnergyDestabilization",0,1,1,73,0,6,54,0,0,"TargetedExplosiveResonanceMultiply",1,1,1,0,0,"None",0,0,0,0,900361);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (621,"deepCoreMiningSkillBoostDamageCloudChanceReduction",0,3148,3149,"Boost of damageCloudChanceReduction by ModAdd of skillLevel","",0,0,0,0,0,0,0,0,0,"deepCoreMiningSkillBoostDamageCloudChanceReduction",1,1,1,0,0,"None",0,0,0,0,900364);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (622,"damageCloudChanceReduction",0,3151,3152,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"damageCloudChanceReduction",1,1,1,0,0,"None",0,0,0,0,900367);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (623,"miningDroneOperationMiningAmountBonusPostPercentMiningDroneAmountPercentChar",0,3153,3154,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"miningDroneOperationMiningAmountBonusPostPercentMiningDroneAmountPercentChar",1,1,1,0,0,"None",0,0,0,0,900370);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (624,"standardMissilesSkillBoostMissileVelocityBonus",0,3158,3159,"Boost of missileVelocityBonus  by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"standardMissilesSkillBoostMissileVelocityBonus",1,1,1,0,0,"None",0,0,0,0,900373);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (627,"powerIncrease",4,3174,3175,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"powerIncrease",1,1,1,0,0,"None",0,0,0,0,900376);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (638,"shieldDefensiveOperationsShieldCapacityBonusPostPercentShieldCapacityGangShips",0,3218,3219,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shieldDefensiveOperationsShieldCapacityBonusPostPercentShieldCapacityGangShips",1,1,1,0,0,"None",0,0,0,0,900379);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (639,"reconOperationsMaxTargetRangeBonusPostPercentMaxTargetRangeGangShips",0,3222,3223,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"reconOperationsMaxTargetRangeBonusPostPercentMaxTargetRangeGangShips",1,1,1,0,0,"None",0,0,0,0,900382);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (643,"chiefFieldEngineerCapacitorBonusPostPercentCapacitorCapacityGangShips",0,3238,3239,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"chiefFieldEngineerCapacitorBonusPostPercentCapacitorCapacityGangShips",1,1,1,0,0,"None",0,0,0,0,900385);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (648,"shipSpecialityMining",0,3257,3258,"Automatically generated effect","",0,0,1,0,0,0,0,0,0,"deepCoreMiningCPUReduction",1,1,1,0,0,"None",0,0,0,0,900388);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (649,"anchorDrop",1,131,131,"Anchoring this object in space.","effects.AnchorDrop",0,1,1,556,0,0,0,0,1,"anchoring",1,1,1,0,0,"None",0,0,0,0,900391);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (650,"anchorLift",1,131,131,"","effects.AnchorLift",0,1,1,556,0,0,0,0,1,"unanchoring",1,1,1,0,0,"None",0,0,0,0,900394);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (651,"cloakingSkillBoostCloakVelocityBonus",0,3262,3263,"Boost of cloakVelocityBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"cloakingSkillBoostCloakVelocityBonus",1,1,1,0,0,"None",0,0,0,0,900397);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (653,"shipSpecialityCloak",0,3272,3273,"Automatically generated effect","",0,0,1,0,0,0,0,0,0,"ShipSpecialityCloak",1,1,1,0,0,"None",0,0,0,0,900400);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (657,"agilityMultiplierEffect",4,3285,3286,"Automatically generated effect","",0,0,1,0,0,0,0,0,0,"AgilityMultiplierEffect",1,1,1,0,0,"None",0,0,0,0,900403);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (658,"missileVelocityBonusGeneric",0,3290,3291,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"MissileVelocityBonusGeneric",1,1,1,0,0,"None",0,0,0,0,900406);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (660,"missileEMDmgBonus",0,3300,3301,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"missileEMDmgBonus",1,1,1,0,0,"None",0,0,0,0,900409);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (661,"missileExplosiveDmgBonus",0,3305,3306,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"missileExplosiveDmgBonus",1,1,1,0,0,"None",0,0,0,0,900412);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (662,"missileThermalDmgBonus",0,3310,3311,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"missileThermalDmgBonus",1,1,1,0,0,"None",0,0,0,0,900415);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (663,"heavyMissilesSkillBoostMaxflightTimeBonus",0,3315,3316,"Boost of max flightTimeBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"heavyMissilesSkillBoostMaxflightTimeBonus",1,1,1,0,0,"None",0,0,0,0,900418);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (668,"missileKineticDmgBonus2",0,3338,3339,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"missileKineticDmgBonus2",1,1,1,0,0,"None",0,0,0,0,900421);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (669,"shipLauncherspeedCB2",0,3341,3342,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipLauncherspeedCB2",1,1,1,0,0,"None",0,0,0,0,900424);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (670,"antiWarpScramblingPassive",4,2946,2947,"Automatically generated effect","",0,0,1,0,0,0,0,0,0,"antiWarpScrambling",1,1,1,0,0,"None",0,0,0,0,900427);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (672,"weaponUpgradesSkillBoostCpu",0,3350,3351,"Boost of cpu by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"weaponUpgradesSkillBoostCpu",1,1,1,0,0,"None",0,0,0,0,900430);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (675,"weaponUpgradesCpuNeedBonusPostPercentCpuLocationShipModulesRequiringEnergyPulseWeapons",0,3359,3360,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"weaponUpgradesCpuNeedBonusPostPercentCpuLocationShipModulesRequiringEnergyPulseWeapons",1,1,1,0,0,"None",0,0,0,0,900433);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (677,"weaponUpgradesCpuNeedBonusPostPercentCpuLocationShipModulesRequiringMissileLauncherOperation",0,3352,3353,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"weaponUpgradesCpuNeedBonusPostPercentCpuLocationShipModulesRequiringMissileLauncherOperation",1,1,1,0,0,"None",0,0,0,0,900436);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (682,"gallenteBattleshipSkillLevelPreMulShipBonusGB2Ship",0,3380,3381,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"gallenteBattleshipSkillLevelPreMulShipBonusGB2Ship",1,1,1,0,0,"None",0,0,0,0,900439);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (688,"electronic2AttributeModifyOnline",4,3398,3399,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"electronic2AttributeModifyOnline",1,1,1,0,0,"None",0,0,0,0,900442);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (698,"signatureAnalysisSkillLevelPreMulScanResolutionBonusSelf",0,3425,3426,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"signatureAnalysisSkillLevelPreMulScanResolutionBonusSelf",1,1,1,0,0,"None",0,0,0,0,900445);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (699,"signatureAnalysisScanResolutionBonusPostPercentScanResolutionShip",0,3427,3428,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"signatureAnalysisScanResolutionBonusPostPercentScanResolutionShip",1,1,1,0,0,"None",0,0,0,0,900448);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (703,"interceptorsSkillLevelPreMulEliteBonusInterceptorShip",0,3451,3452,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"interceptorsSkillLevelPreMulEliteBonusInterceptorShip",1,1,1,0,0,"None",0,0,0,0,900451);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (704,"covertOpsSkillLevelPreMulEliteBonusCoverOpsShip",0,3455,3456,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"covertOpsSkillLevelPreMulEliteBonusCoverOpsShip",1,1,1,0,0,"None",0,0,0,0,900454);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (705,"bombersSkillLevelPreMulEliteBonusBombersShip",0,3459,3460,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"bombersSkillLevelPreMulEliteBonusBombersShip",1,1,1,0,0,"None",0,0,0,0,900457);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (706,"covertOpsWarpResistance",0,3463,3464,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"covertOpsWarpResistance",1,1,1,0,0,"None",0,0,0,0,900460);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (707,"bomberRocketRangeBonus",0,3469,3470,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"bomberRocketRangeBonus",1,1,1,0,0,"None",0,0,0,0,900463);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (708,"bomberLightsRangeBonus",0,3473,3474,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"bomberLightsRangeBonus",1,1,1,0,0,"None",0,0,0,0,900466);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (709,"interceptorSignatoreRadiusBonus",0,3475,3476,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"interceptorSignatoreRadiusBonus",1,1,1,0,0,"None",0,0,0,0,900469);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (710,"speedBoostFactorCalculator",0,3500,3501,"Aid to auto-calc this.","None",0,0,0,0,0,0,0,0,1,"speedBoostFactorCalculator",1,1,1,0,0,"None",0,0,0,0,900472);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (712,"speedBoostFactorCalculator2",0,3515,3516,"Aid to auto-calc","None",0,0,0,0,0,0,0,0,1,"speedBoostFactorCalculator2",1,1,1,0,0,"None",0,0,0,0,900475);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (713,"stealthActive",1,3520,3521,"Automatically generated effect","effects.ElectronicAttributeModifyActivate",0,0,0,73,0,6,0,0,0,"stealthActive",1,1,1,0,0,"None",0,0,0,0,900478);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (716,"sensorBoostTargeted",2,3525,3526,"","effects.ElectronicAttributeModifyTarget",0,1,1,73,0,6,0,0,1,"sensorBoostTargeted",1,1,1,0,0,"None",0,0,0,0,900481);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (720,"sensorBoosterActive",1,3527,3528,"","effects.ElectronicAttributeModifyActivate",0,0,1,73,0,6,0,0,1,"sensorBoosterActivated",1,1,1,0,0,"None",0,0,0,0,900484);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (721,"miningCapBonus",0,3536,3537,"Automatically generated effect","",0,0,1,0,0,0,0,0,0,"Reduces Mining laser activation power",1,1,1,0,0,"None",0,0,0,0,900487);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (726,"shipBonusCargo2GI",0,3547,3548,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipBonusCargo2GI",1,1,1,0,0,"None",0,0,0,0,900490);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (727,"shipBonusCargoCI",0,3549,3550,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipBonusCargoCI",1,1,1,0,0,"None",0,0,0,0,900493);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (728,"shipBonusCargoMI",0,3551,3552,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipBonusCargoMI",1,1,1,0,0,"None",0,0,0,0,900496);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (729,"shipBonusVelocityGI",0,3553,3554,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipBonusVelocityGI",1,1,1,0,0,"None",0,0,0,0,900499);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (730,"shipBonusVelocityCI",0,3569,3572,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipBonusVelocityCI",1,1,1,0,0,"None",0,0,0,0,900502);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (732,"shipVelocityBonusAI",0,3557,3558,"Automatically generated effect","",0,0,1,0,0,0,0,0,0,"ShipVelocityBonusAI",1,1,1,0,0,"None",0,0,0,0,900505);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (734,"amarrBattleshipSkillLevelPreMulShipBonusAB2Ship",0,3565,3566,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"amarrBattleshipSkillLevelPreMulShipBonusAB2Ship",1,1,1,0,0,"None",0,0,0,0,900508);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (736,"shipBonusCapCapAB",0,3567,3568,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipBonusCapCapAB",1,1,1,0,0,"None",0,0,0,0,900511);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (744,"surveyScanspeedBonusPostPercentDurationLocationShipModulesRequiringElectronics",0,3587,3588,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"surveyScanspeedBonusPostPercentDurationLocationShipModulesRequiringElectronics",1,1,1,0,0,"None",0,0,0,0,900514);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (751,"gallenteFrigateSkillLevelPreMulShipBonusGF2Ship",0,3610,3611,"Automatically generated effect","gallenteFrigateSkillLevelPreMulShipBonusGF2Ship",0,0,0,0,0,0,0,0,0,"gallenteFrigateSkillLevelPreMulShipBonusGF2Ship",1,1,1,0,0,"None",0,0,0,0,900517);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (754,"shipHybridDamageBonusCF",0,3620,3621,"Automatically generated effect","shipHybridDamageBonusCF",0,0,0,0,0,0,0,0,0,"shipHybridDamageBonusCF",1,1,1,0,0,"None",0,0,0,0,900520);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (757,"shipETDamageAF",0,3628,3629,"Automatically generated effect","shipETDamageAF",0,0,0,0,0,0,0,0,0,"shipETDamageAF",1,1,1,0,0,"None",0,0,0,0,900523);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (760,"shipMissileSpeedBonusCF",0,3645,3646,"Automatically generated effect","shipMissileSpeedBonusCF",0,0,0,0,0,0,0,0,0,"shipMissileSpeedBonusCF",1,1,1,0,0,"None",0,0,0,0,900526);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (761,"caldariFrigateSkillLevelPreMulShipBonusCF2Ship",0,3649,3650,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"caldariFrigateSkillLevelPreMulShipBonusCF2Ship",1,1,1,0,0,"None",0,0,0,0,900529);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (762,"minmatarFrigateSkillLevelPreMulShipBonusMF2Ship",0,3653,3654,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"minmatarFrigateSkillLevelPreMulShipBonusMF2Ship",1,1,1,0,0,"None",0,0,0,0,900532);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (763,"missileDMGBonus",4,3657,3658,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"missileDMGBonus",1,1,1,0,0,"None",0,0,0,0,900535);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (765,"leadershipEffect",0,3663,3664,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"leadershipEffect",1,1,1,0,0,"None",0,0,0,0,900538);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (768,"hypereuclideanNavigationCloakVelocityBonusModAddSpeedFactorLocationShipModulesRequiringCloaking",0,3670,3671,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"hypereuclideanNavigationCloakVelocityBonusModAddSpeedFactorLocationShipModulesRequiringCloaking",1,1,1,0,0,"None",0,0,0,0,900541);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (775,"capBoostAmplifier",4,3694,3695,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"capBoostAmplifier",1,1,1,0,0,"None",0,0,0,0,900544);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (782,"missileGuidanceAgilityBonusPostPercentAgilityOwnerCharModulesRequiringMissileLauncherOperation",0,3726,3727,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"missileGuidanceAgilityBonusPostPercentAgilityOwnerCharModulesRequiringMissileLauncherOperation",1,1,1,0,0,"None",0,0,0,0,900547);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (784,"missileBombardmentMaxFlightTimeBonusPostPercentExplosionDelayOwnerCharModulesRequiringMissileLauncherOperation",0,3728,3729,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"missileBombardmentMaxFlightTimeBonusPostPercentExplosionDelayOwnerCharModulesRequiringMissileLauncherOperation",1,1,1,0,0,"None",0,0,0,0,900550);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (793,"escortHullUpgradeCpu Bonus",0,3758,3759,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"escortHullUpgradeCpu Bonus",1,1,1,0,0,"None",0,0,0,0,900553);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (796,"escortShieldUpgradeCpu Bonus",0,3775,3776,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"escortShieldUpgradeCpu Bonus",1,1,1,0,0,"None",0,0,0,0,900556);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (797,"caldariBattleshipSkillLevelPreMulShipBonusCB3Ship",0,3767,3768,"Automatically generated effect","caldariBattleshipSkillLevelPreMulShipBonusCB3Ship",0,0,0,0,0,0,0,0,0,"caldariBattleshipSkillLevelPreMulShipBonusCB3Ship",1,1,1,0,0,"None",0,0,0,0,900559);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (802,"shipDronesMaxGB",0,3785,3786,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipDronesMaxGB",1,1,1,0,0,"None",0,0,0,0,900562);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (804,"ammoInfluenceCapNeed",0,3797,3798,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"ammoInfluenceCapNeed",1,1,1,0,0,"None",0,0,0,0,900565);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (820,"speedBoostPassive",4,3517,3518,"","",0,0,1,0,0,0,0,0,1,"speedBoost",1,1,1,0,0,"None",0,0,0,0,7582951);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (834,"ammoInfluenceCapRecharge",0,443,444,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"ammoInfluenceCapRecharge",1,1,1,0,0,"None",0,0,0,0,900571);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (835,"freightSkillBoostCargoCapacityBonus",0,3904,3905,"Boost of cargoCapacityBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"freightSkillBoostCargoCapacityBonus",1,1,1,0,0,"None",0,0,0,0,900574);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (836,"skillFreightBonus",0,3906,3907,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"skillFreightBonus",1,1,1,0,0,"None",0,0,0,0,900577);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (837,"sensorBoostTargetedHostile",2,3525,3526,"","effects.ElectronicAttributeModifyTarget",0,1,1,73,0,6,54,158,1,"sensorBoostTargetedHostile",1,1,1,0,0,"None",0,0,0,0,900580);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (838,"ammoInfluenceShipVelocity",0,3908,3909,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"ammoInfluenceShipVelocity",1,1,1,0,0,"None",0,0,0,0,900583);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (848,"cloakingTargetingDelayBonusPostPercentCloakingTargetingDelayBonusForShipModulesRequiringCloaking",0,3924,3925,"Applies the cloaking skill\'s reduction bonus to cloakingTargetingDelay time.","",0,0,0,0,0,0,0,0,1,"cloakingTargetingDelayBonusPostPercentCloakingTargetingDelayBonusForShipModulesRequiringCloaking",1,1,1,0,0,"None",0,0,0,0,900586);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (850,"cloakingSkillBoostCloakingTargetingDelayBonus",0,3928,3929,"Applies cloaking skill\'s level to cloakingTargetingDelayBonus.","",0,0,0,0,0,0,0,0,1,"cloakingSkillBoostCloakingTargetingDelayBonus",1,1,1,0,0,"None",0,0,0,0,900589);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (854,"cloakingScanResolutionMultiplier",0,3935,3408,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"cloakingScanResolutionMultiplier",1,1,1,0,0,"None",0,0,0,0,900592);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (856,"warpSkillSpeed",0,3949,3950,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"WarpSkillSpeed",1,1,1,0,0,"None",0,0,0,0,900595);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (857,"bountyHuntingSkillBoostBountySkillBonus",0,3957,3958,"Boost of bountySkillBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"bountyHuntingSkillBoostBountySkillBonus",1,1,1,0,0,"None",0,0,0,0,900598);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (858,"bountyhunterskill",0,3961,3962,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"bountyhunterskill",1,1,1,0,0,"None",0,0,0,0,900601);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (859,"advancedBountyHuntingSkillBoostBountySkillMultiplyer",0,3967,3968,"Boost of bountySkillMultiplyer by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"advancedBountyHuntingSkillBoostBountySkillMultiplyer",1,1,1,0,0,"None",0,0,0,0,900604);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (860,"advBountyhunterSkill",0,3971,3972,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"advBountyhunterSkill",1,1,1,0,0,"None",0,0,0,0,900607);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (867,"missileFlightTimeAndDamage",1,3996,3997,"Adjusts missile flight time and damage.","",0,0,0,73,0,6,0,0,1,"missileFlightTimeAndDamage",1,1,1,0,0,"None",0,0,0,0,900610);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (874,"shipProjectileOptimalBonuseMF2",0,4026,4027,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipProjectileOptimalBonuseMF2",1,1,1,0,0,"None",0,0,0,0,900613);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (875,"shipLaserOptimalBonuseAF",0,4030,4031,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipLaserOptimalBonuseAF",1,1,1,0,0,"None",0,0,0,0,900616);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (876,"shieldBoostingForEntities",1,4037,131,"","effects.ShieldBoosting",0,0,0,636,0,0,0,0,1,"shieldBoostingForEntities",1,1,1,0,0,"None",0,0,0,0,900619);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (878,"armorRepairForEntities",1,4039,131,"Repair damage to the ships armor.","effects.ArmorRepair",0,0,0,630,0,0,0,0,1,"armorRepairForEntities",1,1,1,0,0,"None",0,0,0,0,900622);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (881,"implantEWcpuneed",0,4048,4049,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"implantEWcpuneed",1,1,1,0,0,"None",0,0,0,0,900625);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (882,"shipHybridRangeBonusCF2",0,4052,4053,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipHybridRangeBonusCF2",1,1,1,0,0,"None",0,0,0,0,900628);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (885,"suicideBomb",1,288,233,"Triggering of an EMP wave being broadcast into space.","effects.EMPWave",0,1,1,73,0,6,99,0,1,"empWave",1,1,1,0,0,"None",0,0,0,0,900631);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (887,"shipETspeedBonusAB2",0,4066,4067,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipETspeedBonusAB2",1,1,1,0,0,"None",0,0,0,0,900634);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (889,"missileLauncherSpeedMultiplier",4,4069,4070,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"missileLauncherSpeedMultiplier",1,1,1,0,0,"None",0,0,0,0,900637);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (891,"shipCruiseMissileVelocityBonusCB3",0,4081,4082,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipCruiseMissileVelocityBonusCB3",1,1,1,0,0,"None",0,0,0,0,900640);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (892,"shipTorpedosVelocityBonusCB3",0,4087,4088,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipTorpedosVelocityBonusCB3",1,1,1,0,0,"None",0,0,0,0,900643);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (896,"covertOpsCpuBonus1",0,4111,4112,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"covertOpsCpuBonus1",1,1,1,0,0,"None",0,0,0,0,900646);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (897,"covertOpsCpuMultplier1",0,4115,4116,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"covertOpsCpuMultplier1",1,1,1,0,0,"None",0,0,0,0,900649);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (898,"shipMissileKineticDamageCF",0,4119,4120,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipMissileKineticDamageCF",1,1,1,0,0,"None",0,0,0,0,900652);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (899,"shipMissileKineticDamageCC",0,4121,4122,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipMissileKineticDamageCC",1,1,1,0,0,"None",0,0,0,0,900655);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (900,"shipDroneScoutThermalDamageGF2",0,4125,4126,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipDroneScoutThermalDamageGF2",1,1,1,0,0,"None",0,0,0,0,900658);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (901,"onlineForStructures",1,131,131,"this is the online effect for structures","effects.StructureOnline",0,0,1,0,0,0,0,0,1,"online",1,1,1,0,0,"None",0,0,0,0,900661);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (902,"decloakWave",1,4129,131,"Triggering of an EMP wave being broadcast into space.","effects.DecloakWave",0,1,0,73,0,6,651,0,1,"decloakWave",1,1,1,0,0,"None",0,0,0,0,900664);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (903,"ammoInfluenceSignatureRadius",0,4133,4134,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"ammoInfluenceSignatureRadius",1,1,1,0,0,"None",0,0,0,0,900667);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (904,"ammoInfluenceShieldCapacity",0,4136,4137,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"ammoInfluenceShieldCapacity",1,1,1,0,0,"None",0,0,0,0,900670);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (907,"shipLaserRofAC2",0,4152,4153,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipLaserRofAC2",1,1,1,0,0,"None",0,0,0,0,900673);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (909,"shipArmorHpAC2",0,4158,4159,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipArmorHpAC2",1,1,1,0,0,"None",0,0,0,0,900676);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (912,"shipMissileLauncherRofCC2",0,4164,4165,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipMissileLauncherRofCC2",1,1,1,0,0,"None",0,0,0,0,900679);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (914,"shipMiningYieldCC2",0,4170,4171,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipMiningYieldCC2",1,1,1,0,0,"None",0,0,0,0,900682);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (918,"shipDronesMaxGC2",0,4184,4185,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipDronesMaxGC2",1,1,1,0,0,"None",0,0,0,0,900685);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (919,"shipHybridTrackingGC2",0,4186,4187,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipHybridTrackingGC2",1,1,1,0,0,"None",0,0,0,0,900688);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (923,"shipMiningYieldMC2",0,4196,4197,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipMiningYieldMC2",1,1,1,0,0,"None",0,0,0,0,900691);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (926,"amarrCruiserSkillLevelPreMulShipBonusAC2Ship",0,4214,4215,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"amarrCruiserSkillLevelPreMulShipBonusAC2Ship",1,1,1,0,0,"None",0,0,0,0,900694);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (927,"caldariCruiserSkillLevelPreMulShipBonusCC2Ship",0,4218,4219,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"caldariCruiserSkillLevelPreMulShipBonusCC2Ship",1,1,1,0,0,"None",0,0,0,0,900697);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (928,"gallenteCruiserSkillLevelPreMulShipBonusGC2Ship",0,4222,4223,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"gallenteCruiserSkillLevelPreMulShipBonusGC2Ship",1,1,1,0,0,"None",0,0,0,0,900700);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (929,"minmatarCruiserSkillLevelPreMulShipBonusMC2Ship",0,4226,4227,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"minmatarCruiserSkillLevelPreMulShipBonusMC2Ship",1,1,1,0,0,"None",0,0,0,0,900703);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (930,"shipCargoCapacityGC2",0,4228,4229,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipCargoCapacityGC2",1,1,1,0,0,"None",0,0,0,0,900706);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (934,"shipMaxVelocityMC2",0,4238,4239,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipMaxVelocityMC2",1,1,1,0,0,"None",0,0,0,0,900709);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (939,"shipShieldBoostCC2",0,4253,4254,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipShieldBoostCC2",1,1,1,0,0,"None",0,0,0,0,900712);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (952,"boosterTimeBonus",0,4288,4289,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"boosterTimeBonus",1,1,1,0,0,"None",0,0,0,0,900715);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (953,"biologyTimeBonus",0,4292,4293,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"biologyTimeBonus",1,1,1,0,0,"None",0,0,0,0,900718);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (958,"shipArmorEmResistanceAC2",0,4256,4257,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipArmorEmResistanceAC2",1,1,1,0,0,"None",0,0,0,0,900721);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (959,"shipArmorExplosiveResistanceAC2",0,4259,4260,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipArmorExplosiveResistanceAC2",1,1,1,0,0,"None",0,0,0,0,900724);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (960,"shipArmorKineticResistanceAC2",0,4262,4263,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipArmorKineticResistanceAC2",1,1,1,0,0,"None",0,0,0,0,900727);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (961,"shipArmorThermalResistanceAC2",0,4265,4266,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipArmorThermalResistanceAC2",1,1,1,0,0,"None",0,0,0,0,900730);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (967,"shipMwdLessCapNerfGC2",0,4320,4321,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipMwdLessCapNerfGC2",1,1,1,0,0,"None",0,0,0,0,900733);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (968,"shipProjectileDmgMC2",0,4322,4323,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipProjectileDmgMC2",1,1,1,0,0,"None",0,0,0,0,900736);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (969,"smartbombEMBonus",4,4327,4328,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"smartbombEMBonus",1,1,1,0,0,"None",0,0,0,0,900739);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (970,"smartbombKineticBonus",4,4331,4332,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"smartbombKineticBonus",1,1,1,0,0,"None",0,0,0,0,900742);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (971,"smartbombThermalBonus",4,4335,4336,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"smartbombThermalBonus",1,1,1,0,0,"None",0,0,0,0,900745);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (972,"smartbombEXBonus",4,4339,4340,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"smartbombEXBonus",1,1,1,0,0,"None",0,0,0,0,900748);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (973,"smartbombRangeBonus",4,4345,4346,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"smartbombRangeBonus",1,1,1,0,0,"None",0,0,0,0,900751);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (980,"cloakingWarpSafe",1,3908,3909,"","effects.Cloaking",0,1,1,0,0,0,0,0,1,"Cloaking",1,1,1,0,0,"None",0,0,0,0,900754);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (983,"droneHeavyControlUnitMultiplier",1,4372,4373,"","",0,0,0,73,0,6,0,0,1,"droneHeavyControlUnitMultiplier",1,1,1,0,0,"None",0,0,0,0,900757);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (987,"gunshipSkillMultiplier1",0,4387,4388,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"gunshipSkillMultiplier1",1,1,1,0,0,"None",0,0,0,0,900760);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (988,"gunshipSkillMultiplier2",0,4391,4392,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"gunshipSkillMultiplier2",1,1,1,0,0,"None",0,0,0,0,900763);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (989,"eliteBonusGunshipHybridOptimal1",0,4393,4394,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusGunshipHybridOptimal1",1,1,1,0,0,"None",0,0,0,0,900766);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (990,"eliteBonusGunshipProjectileOptimal1",0,4395,4396,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusGunshipProjectileOptimal1",1,1,1,0,0,"None",0,0,0,0,900769);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (991,"eliteBonusGunshipLaserOptimal1",0,4397,4398,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusGunshipLaserOptimal1",1,1,1,0,0,"None",0,0,0,0,900772);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (996,"eliteBonusGunshipHybridTracking2",0,4415,4416,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusGunshipHybridTracking2",1,1,1,0,0,"None",0,0,0,0,900775);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (998,"eliteBonusGunshipProjectileFalloff2",0,4419,4420,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusGunshipProjectileFalloff2",1,1,1,0,0,"None",0,0,0,0,900778);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (999,"eliteBonusGunshipShieldBoost2",0,4421,4422,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusGunshipShieldBoost2",1,1,1,0,0,"None",0,0,0,0,900781);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1001,"eliteBonusGunshipCapRecharge2",0,4426,4427,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusGunshipCapRecharge2",1,1,1,0,0,"None",0,0,0,0,900784);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1002,"eliteBonusGunshipDroneCapacity2",0,4428,4429,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusGunshipDroneCapacity2",1,1,1,0,0,"None",0,0,0,0,900787);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1003,"selfT2SmallLaserPulseDamageBonus",0,4434,4435,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"selfT2SmallLaserPulseDamageBonus",1,1,1,0,0,"None",0,0,0,0,900790);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1004,"selfT2SmallLaserBeamDamageBonus",0,4440,4441,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"selfT2SmallLaserBeamDamageBonus",1,1,1,0,0,"None",0,0,0,0,900793);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1005,"selfT2SmallHybridBlasterDamageBonus",0,4444,4445,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"selfT2SmallHybridBlasterDamageBonus",1,1,1,0,0,"None",0,0,0,0,900796);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1006,"selfT2SmallHybridRailDamageBonus",0,4450,4451,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"selfT2SmallHybridRailDamageBonus",1,1,1,0,0,"None",0,0,0,0,900799);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1007,"selfT2SmallProjectileACDamageBonus",0,4456,4457,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"selfT2SmallProjectileACDamageBonus",1,1,1,0,0,"None",0,0,0,0,900802);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1008,"selfT2SmallProjectileArtyDamageBonus",0,4462,4463,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"selfT2SmallProjectileArtyDamageBonus",1,1,1,0,0,"None",0,0,0,0,900805);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1009,"selfT2MediumLaserPulseDamageBonus",0,4468,4469,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"selfT2MediumLaserPulseDamageBonus",1,1,1,0,0,"None",0,0,0,0,900808);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1010,"selfT2MediumLaserBeamDamageBonus",0,4474,4475,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"selfT2MediumLaserBeamDamageBonus",1,1,1,0,0,"None",0,0,0,0,900811);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1011,"selfT2MediumHybridBlasterDamageBonus",0,4480,4481,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"selfT2MediumHybridBlasterDamageBonus",1,1,1,0,0,"None",0,0,0,0,900814);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1012,"selfT2MediumHybridRailDamageBonus",0,4486,4487,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"selfT2MediumHybridRailDamageBonus",1,1,1,0,0,"None",0,0,0,0,900817);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1013,"selfT2MediumProjectileACDamageBonus",0,4492,4493,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"selfT2MediumProjectileACDamageBonus",1,1,1,0,0,"None",0,0,0,0,900820);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1014,"selfT2MediumProjectileArtyDamageBonus",0,4498,4499,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"selfT2MediumProjectileArtyDamageBonus",1,1,1,0,0,"None",0,0,0,0,900823);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1015,"selfT2LargeLaserPulseDamageBonus",0,4504,4505,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"selfT2LargeLaserPulseDamageBonus",1,1,1,0,0,"None",0,0,0,0,900826);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1016,"selfT2LargeLaserBeamDamageBonus",0,4510,4511,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"selfT2LargeLaserBeamDamageBonus",1,1,1,0,0,"None",0,0,0,0,900829);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1017,"selfT2LargeHybridBlasterDamageBonus",0,4516,4517,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"selfT2LargeHybridBlasterDamageBonus",1,1,1,0,0,"None",0,0,0,0,900832);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1018,"selfT2LargeHybridRailDamageBonus",0,4522,4523,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"selfT2LargeHybridRailDamageBonus",1,1,1,0,0,"None",0,0,0,0,900835);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1019,"selfT2LargeProjectileACDamageBonus",0,4528,4529,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"selfT2LargeProjectileACDamageBonus",1,1,1,0,0,"None",0,0,0,0,900838);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1020,"selfT2LargeProjectileArtyDamageBonus",0,4534,4535,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"selfT2LargeProjectileArtyDamageBonus",1,1,1,0,0,"None",0,0,0,0,900841);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1021,"eliteBonusGunshipHybridDmg2",0,4536,4537,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusGunshipHybridDmg2",1,1,1,0,0,"None",0,0,0,0,900844);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1022,"anchorDropForStructures",1,131,131,"Anchoring this object in space.","effects.AnchorDrop",0,1,1,0,0,0,0,0,1,"anchoring",1,1,1,0,0,"None",0,0,0,0,900847);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1023,"anchorLiftForStructures",1,131,131,"","effects.AnchorLift",0,1,1,0,0,0,0,0,1,"unanchoring",1,1,1,0,0,"None",0,0,0,0,900850);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1024,"shipMissileHeavyVelocityBonusCC2",0,4542,4543,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipMissileHeavyVelocityBonusCC2",1,1,1,0,0,"None",0,0,0,0,900853);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1025,"shipMissileLightVelocityBonusCC2",0,4546,4547,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipMissileLightVelocityBonusCC2",1,1,1,0,0,"None",0,0,0,0,900856);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1030,"remoteArmorSystemsCapNeedBonusPostPercentCapacitorNeedLocationShipModulesRequiringRemoteArmorSystems",0,4566,4567,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"remoteArmorSystemsCapNeedBonusPostPercentCapacitorNeedLocationShipModulesRequiringRemoteArmorSystems",1,1,1,0,0,"None",0,0,0,0,900859);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1033,"eliteBonusLogisticRemoteArmorRepairCapNeed1",0,4576,4577,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusLogisticRemoteArmorRepairCapNeed1",1,1,1,0,0,"None",0,0,0,0,900862);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1034,"eliteBonusLogisticRemoteArmorRepairCapNeed2",0,4578,4579,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusLogisticRemoteArmorRepairCapNeed2",1,1,1,0,0,"None",0,0,0,0,900865);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1035,"eliteBonusLogisticShieldTransferCapNeed2",0,4584,4585,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusLogisticShieldTransferCapNeed2",1,1,1,0,0,"None",0,0,0,0,900868);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1036,"eliteBonusLogisticShieldTransferCapNeed1",0,4586,4587,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusLogisticShieldTransferCapNeed1",1,1,1,0,0,"None",0,0,0,0,900871);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1042,"eliteBonusLogisticTrackingLinkBonus1",0,4604,4605,"","",0,0,0,0,0,0,0,0,1,"eliteBonusLogisticTrackingLinkBonus1",1,1,1,0,0,"None",0,0,0,0,900874);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1045,"eliteBonusLogisticTrackingLinkBonus2",0,4610,4611,"","",0,0,0,0,0,0,0,0,1,"eliteBonusLogisticTrackingLinkBonus2",1,1,1,0,0,"None",0,0,0,0,900877);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1046,"shipRemoteArmorRange1",0,4614,4615,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipRemoteArmorRange1",1,1,1,0,0,"None",0,0,0,0,900880);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1047,"shipRemoteArmorRange2",0,4616,4617,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipRemoteArmorRange2",1,1,1,0,0,"None",0,0,0,0,900883);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1048,"shipShieldTransferRange1",0,4620,4621,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipShieldTransferRange1",1,1,1,0,0,"None",0,0,0,0,900886);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1049,"shipShieldTransferRange2",0,4622,4623,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipShieldTransferRange2",1,1,1,0,0,"None",0,0,0,0,900889);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1052,"logisticSkillMultiplier1",0,4633,4634,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"logisticSkillMultiplier1",1,1,1,0,0,"None",0,0,0,0,900892);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1053,"logisticSkillMultiplier2",0,4637,4638,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"logisticSkillMultiplier2",1,1,1,0,0,"None",0,0,0,0,900895);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1054,"shipTrackingLinkRange1",0,4640,4641,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipTrackingLinkRange1",1,1,1,0,0,"None",0,0,0,0,900898);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1055,"shipTrackingLinkRange2",0,4642,4643,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipTrackingLinkRange2",1,1,1,0,0,"None",0,0,0,0,900901);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1056,"eliteBonusHeavyGunshipHybridOptimal1",0,4658,4659,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusHeavyGunshipHybridOptimal1",1,1,1,0,0,"None",0,0,0,0,900904);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1057,"eliteBonusHeavyGunshipProjectileOptimal1",0,4660,4661,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusHeavyGunshipProjectileOptimal1",1,1,1,0,0,"None",0,0,0,0,900907);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1058,"eliteBonusHeavyGunshipLaserOptimal1",0,4664,4665,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusHeavyGunshipLaserOptimal1",1,1,1,0,0,"None",0,0,0,0,900910);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1060,"eliteBonusHeavyGunshipProjectileFallOff1",0,4670,4671,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusHeavyGunshipProjectileFallOff1",1,1,1,0,0,"None",0,0,0,0,900913);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1061,"eliteBonusHeavyGunshipHybridDmg2",0,4672,4673,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusHeavyGunshipHybridDmg2",1,1,1,0,0,"None",0,0,0,0,900916);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1062,"eliteBonusHeavyGunshipLaserDmg2",0,4674,4675,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusHeavyGunshipLaserDmg2",1,1,1,0,0,"None",0,0,0,0,900919);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1063,"eliteBonusHeavyGunshipProjectileTracking2",0,4676,4677,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusHeavyGunshipProjectileTracking2",1,1,1,0,0,"None",0,0,0,0,900922);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1066,"eliteBonusHeavyGunshipDroneCapacity2",0,4686,4687,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusHeavyGunshipDroneCapacity2",1,1,1,0,0,"None",0,0,0,0,900925);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1077,"warshipSkillMultiplier2",0,4723,4724,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"warshipSkillMultiplier2",1,1,1,0,0,"None",0,0,0,0,900928);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1079,"warshipSkillMultiplier1",0,4730,4731,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"warshipSkillMultiplier1",1,1,1,0,0,"None",0,0,0,0,900931);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1080,"eliteBonusHeavyGunshipHybridFallOff1",0,4732,4733,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusHeavyGunshipHybridFallOff1",1,1,1,0,0,"None",0,0,0,0,900934);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1081,"eliteBonusHeavyGunshipHeavyMissileFlightTime1",0,4734,4735,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusHeavyGunshipHeavyMissileFlightTime1",1,1,1,0,0,"None",0,0,0,0,900937);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1082,"eliteBonusHeavyGunshipLightMissileFlightTime1",0,4736,4737,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusHeavyGunshipLightMissileFlightTime1",1,1,1,0,0,"None",0,0,0,0,900940);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1084,"eliteBonusHeavyGunshipDroneControlRange1",0,4740,4741,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusHeavyGunshipDroneControlRange1",1,1,1,0,0,"None",0,0,0,0,900943);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1086,"projectileFiredForEntities",2,115,131,"","effects.ProjectileFiredForEntities",0,1,1,51,160,6,54,158,1,"projectileFired",0,1,1,0,0,"None",0,0,0,0,900946);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1087,"eliteBonusHeavyGunshipProjectileDmg2",0,4750,4751,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusHeavyGunshipProjectileDmg2",1,1,1,0,0,"None",0,0,0,0,900949);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1095,"destroyerPenalityTurretROF",0,4789,4790,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"destroyerPenalityTurretROF",1,1,1,0,0,"None",0,0,0,0,900952);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1099,"shipProjectileTrackingMF2",0,4801,4802,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipProjectileTrackingMF2",1,1,1,0,0,"None",0,0,0,0,900955);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1108,"controlTowerAmarrLaserDMGBonus",0,4831,4832,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"controlTowerAmarrLaserDMGBonus",1,1,1,0,0,"None",0,0,0,0,900958);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1109,"battlecruiserSkillLevelPreMulShipBonusBC1Ship",0,4856,4857,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"battlecruiserSkillLevelPreMulShipBonusBC1Ship",1,1,1,0,0,"None",0,0,0,0,900961);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1110,"shipProjectileRofMBC2",0,4858,4859,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipProjectileRofMBC2",1,1,1,0,0,"None",0,0,0,0,900964);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1111,"battlecruiserSkillLevelPreMulShipBonusBC2Ship",0,4862,4863,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"battlecruiserSkillLevelPreMulShipBonusBC2Ship",1,1,1,0,0,"None",0,0,0,0,900967);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1117,"shipArmorThermResistanceABC1",0,4882,4883,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipArmorThermResistanceABC1",1,1,1,0,0,"None",0,0,0,0,900970);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1118,"shipArmorEMResistanceABC1",0,4884,4885,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipArmorEMResistanceABC1",1,1,1,0,0,"None",0,0,0,0,900973);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1119,"shipArmorExplosiveResistanceABC1",0,4886,4887,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipArmorExplosiveResistanceABC1",1,1,1,0,0,"None",0,0,0,0,900976);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1120,"shipArmorKineticResistanceABC1",0,4888,4889,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipArmorKineticResistanceABC1",1,1,1,0,0,"None",0,0,0,0,900979);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1121,"shipShieldEmResistanceCBC2",0,4890,4891,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipShieldEmResistanceCBC2",1,1,1,0,0,"None",0,0,0,0,900982);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1122,"shipShieldExplosiveResistanceCBC2",0,4892,4893,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipShieldExplosiveResistanceCBC2",1,1,1,0,0,"None",0,0,0,0,900985);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1123,"shipShieldKineticResistanceCBC2",0,4894,4895,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipShieldKineticResistanceCBC2",1,1,1,0,0,"None",0,0,0,0,900988);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1124,"shipShieldThermalResistanceCBC2",0,4896,4897,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipShieldThermalResistanceCBC2",1,1,1,0,0,"None",0,0,0,0,900991);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1125,"shipLaserCapABC2",0,4900,4901,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipLaserCapABC2",1,1,1,0,0,"None",0,0,0,0,900994);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1126,"shipHybridDmgGBC1",0,4902,4903,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipHybridDmgGBC1",1,1,1,0,0,"None",0,0,0,0,900997);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1129,"structureUnanchorForced",2,131,131,"","",0,1,1,676,0,0,76,0,1,"Force Unanchor",1,1,1,0,0,"None",0,0,0,0,901000);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1130,"controlTowerAmarrLaserOptimalBonus",0,4922,4923,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"controlTowerAmarrLaserOptimalBonus",1,1,1,0,0,"None",0,0,0,0,901003);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1131,"controlTowerSiloCapacityBonus",0,4928,4929,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"controlTowerSiloCapacityBonus",1,1,1,0,0,"None",0,0,0,0,901006);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1133,"controlTowerMinmatarProjectileOptimalBonus",0,4938,4939,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"controlTowerMinmatarProjectileOptimalBonus",1,1,1,0,0,"None",0,0,0,0,901009);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1134,"controlTowerMinmatarProjectileFallOffBonus",0,4942,4943,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"controlTowerMinmatarProjectileFallOffBonus",1,1,1,0,0,"None",0,0,0,0,901012);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1137,"controlTowerMinmatarProjectileRofBonus",0,4958,4959,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"controlTowerMinmatarProjectileRofBonus",1,1,1,0,0,"None",0,0,0,0,901015);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1138,"controlTowerMoonHarvesterCPUBonus",0,4966,4967,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"controlTowerMoonHarvesterCPUBonus",1,1,1,0,0,"None",0,0,0,0,901018);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1139,"destroyerSkillLevelPreMulShipBonusDF2Ship",0,4973,4974,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"destroyerSkillLevelPreMulShipBonusDF2Ship",1,1,1,0,0,"None",0,0,0,0,901021);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1140,"destroyerSkillLevelPreMulShipBonusDF1Ship",0,4977,4978,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"destroyerSkillLevelPreMulShipBonusDF1Ship",1,1,1,0,0,"None",0,0,0,0,901024);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1141,"shipHybridTrackingGD2",0,4979,4980,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipHybridTrackingGD2",1,1,1,0,0,"None",0,0,0,0,901027);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1143,"shipLaserCapNeedAD1",0,4985,4986,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipLaserCapNeedAD1",1,1,1,0,0,"None",0,0,0,0,901030);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1144,"shipLaserTrackingAD2",0,4987,4988,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipLaserTrackingAD2",1,1,1,0,0,"None",0,0,0,0,901033);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1145,"shipHybridRangeCD1",0,4989,4990,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipHybridRangeCD1",1,1,1,0,0,"None",0,0,0,0,901036);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1147,"shipProjectileTrackingMD2",0,4995,4996,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipProjectileTrackingMD2",1,1,1,0,0,"None",0,0,0,0,901039);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1150,"systemScan",1,131,131,"Scan the solar system.","",0,0,1,73,0,6,0,0,1,"Analyzing Scans",1,1,1,0,0,"None",0,0,0,0,901042);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1152,"controlTowerGallenteHybridDamageBonus",0,5017,5018,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"controlTowerGallenteHybridDamageBonus",1,1,1,0,0,"None",0,0,0,0,901045);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1156,"controlTowerTrackingArrayHybridOptimalBonus",4,5026,5027,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"controlTowerTrackingArrayHybridOptimalBonus",1,1,1,0,0,"None",0,0,0,0,901048);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1157,"controlTowerTrackingArrayLaserOptimalBonus",4,5028,5029,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"controlTowerTrackingArrayLaserOptimalBonus",1,1,1,0,0,"None",0,0,0,0,901051);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1158,"controlTowerTrackingArrayProjectileOptimalBonus",4,5030,5031,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"controlTowerTrackingArrayProjectileOptimalBonus",1,1,1,0,0,"None",0,0,0,0,901054);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1159,"controlTowerTrackingArrayProjectileTrackingBonus",4,5034,5035,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"controlTowerTrackingArrayProjectileTrackingBonus",1,1,1,0,0,"None",0,0,0,0,901057);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1160,"controlTowerTrackingArrayHybridTrackingBonus",4,5038,5039,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"controlTowerTrackingArrayHybridTrackingBonus",1,1,1,0,0,"None",0,0,0,0,901060);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1161,"controlTowerTrackingArrayLaserTrackingBonus",4,5040,5041,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"controlTowerTrackingArrayLaserTrackingBonus",1,1,1,0,0,"None",0,0,0,0,901063);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1165,"shipIceHarvesterCPUNeed",0,5063,5064,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipIceHarvesterCPUNeed",1,1,1,0,0,"None",0,0,0,0,901066);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1166,"shipMinerCPUNeed",0,5067,5068,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipMinerCPUNeed",1,1,1,0,0,"None",0,0,0,0,901069);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1171,"massFactor",0,5089,5090,"Needed for all ships for speed boost of afterburners and microwarpdrives.","",0,0,0,0,0,0,0,0,1,"massFactor",1,1,1,0,0,"None",0,0,0,0,901072);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1173,"ammoInfluenceEntityFlyRange",0,5102,5103,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"ammoInfluenceEntityFlyRange",1,1,1,0,0,"None",0,0,0,0,901075);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1176,"accerationControlSkillAb&MwdSpeedBoost",0,5113,5114,"","",0,0,0,0,0,0,0,0,1,"accerationControlSkillAb",1,1,1,0,0,"None",0,0,0,0,901078);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1179,"eliteBonusGunshipLaserDamage2",0,5121,5122,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusGunshipLaserDamage2",1,1,1,0,0,"None",0,0,0,0,901081);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1181,"eliteBonusLogisticEnergyTransferCapNeed1",0,5133,5134,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusLogisticEnergyTransferCapNeed1",1,1,1,0,0,"None",0,0,0,0,901084);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1182,"shipEnergyTransferRange1",0,5137,5138,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipEnergyTransferRange1",1,1,1,0,0,"None",0,0,0,0,901087);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1183,"eliteBonusLogisticEnergyTransferCapNeed2",0,5139,5140,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusLogisticEnergyTransferCapNeed2",1,1,1,0,0,"None",0,0,0,0,901090);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1184,"shipEnergyTransferRange2",0,5141,5142,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipEnergyTransferRange2",1,1,1,0,0,"None",0,0,0,0,901093);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1185,"structureStealthEmitterArraySigDecrease",0,3277,3278,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"structureStealthEmitterArraySigDecrease",1,1,1,0,0,"None",0,0,0,0,901096);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1188,"miningBargeSkillLevelPostMulShipBonusORE2Ship",0,5159,5160,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"miningBargeSkillLevelPostMulShipBonusORE2Ship",1,1,1,0,0,"None",0,0,0,0,901099);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1190,"iceHarvestCycleTimeModulesRequiringIceHarvesting",0,5165,5166,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"iceHarvestCycleTimeModulesRequiringIceHarvesting",1,1,1,0,0,"None",0,0,0,0,901102);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1191,"iceHarvestCycleTimeBonus",0,5169,5170,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"iceHarvestCycleTimeBonus",1,1,1,0,0,"None",0,0,0,0,901105);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1192,"controlTowerCaldariEwTargetSwitchDelayBonus",0,5048,5049,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"controlTowerCaldariEwTargetSwitchDelayBonus",1,1,1,0,0,"None",0,0,0,0,901108);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1193,"shipHybridOptimalCBC1",0,5171,5172,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipHybridOptimalCBC1",1,1,1,0,0,"None",0,0,0,0,901111);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1194,"shipShieldBoostMBC1",0,5173,5174,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipShieldBoostMBC1",1,1,1,0,0,"None",0,0,0,0,901114);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1195,"shipArmorRepairingGBC2",0,5175,5176,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipArmorRepairingGBC2",1,1,1,0,0,"None",0,0,0,0,901117);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1197,"shipMiningBonusORE2",0,5181,5182,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipMiningBonusORE2",1,1,1,0,0,"None",0,0,0,0,901120);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1198,"shipHybridFallOffGD1",0,5185,5186,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipHybridFallOffGD1",1,1,1,0,0,"None",0,0,0,0,901123);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1199,"targetAttackForStructures",2,115,89,"Combat","effects.ProjectileFiredForEntities",0,1,1,51,160,6,54,158,1,"targetAttack",0,1,1,0,0,"None",0,0,0,0,901126);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1200,"miningInfoMultiplier",0,5190,5191,"Automatically generated effect","",0,0,1,0,0,0,0,0,0,"MiningInfoMultiplier",1,1,1,0,0,"None",0,0,0,0,901129);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1202,"shipMissileEMDamage2AF",0,5194,5195,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipMissileEMDamage2AF",1,1,1,0,0,"None",0,0,0,0,901132);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1203,"controlTowerCaldariMissileVelocityBonus",0,5200,5201,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"controlTowerCaldariMissileVelocityBonus",1,1,1,0,0,"None",0,0,0,0,901135);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1204,"shipPTurretSpeedBonusGB",0,5204,5205,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipPTurretSpeedBonusGB",1,1,1,0,0,"None",0,0,0,0,901138);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1210,"controlTowerCaldariMissileRofBonus",0,5228,5229,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"controlTowerCaldariMissileRofBonus",1,1,1,0,0,"None",0,0,0,0,901141);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1212,"crystalMiningamountInfo2",0,5236,5237,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"crystalMiningamountInfo2",1,1,1,0,0,"None",0,0,0,0,901144);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1213,"shipProjectileTrackingGC2",0,5239,5240,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipProjectileTrackingGC2",1,1,1,0,0,"None",0,0,0,0,901147);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1215,"shipEnergyDrainAmountAF1",0,5247,5248,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipEnergyDrainAmountAF1",1,1,1,0,0,"None",0,0,0,0,901150);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1217,"shipStasisRangeMF1",0,5255,5256,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipStasisRangeMF1",1,1,1,0,0,"None",0,0,0,0,901153);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1218,"shipBonusPirateSmallHybridDmg",0,5257,5258,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipBonusPirateSmallHybridDmg",1,1,1,0,0,"None",0,0,0,0,901156);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1219,"shipEnergyVampireTransferAmountBonusAB",0,5259,5260,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipEnergyVampireTransferAmountBonusAB",1,1,1,0,0,"None",0,0,0,0,901159);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1220,"shipEnergyVampireTransferAmountBonusAc",0,5261,5262,"Automatically generated effect","",0,0,1,0,0,0,0,0,0,"shipEnergyVampireTransferAmountBonusAB",1,1,1,0,0,"None",0,0,0,0,901162);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1221,"shipStasisWebRangeBonusMB",0,5263,5264,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipStasisWebRangeBonusMB",1,1,1,0,0,"None",0,0,0,0,901165);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1222,"shipStasisWebRangeBonusMC2",0,5265,5266,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipStasisWebRangeBonusMC2",1,1,1,0,0,"None",0,0,0,0,901168);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1224,"shipMWDCapBonusMC",0,5267,5268,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipMWDCapBonusMC",1,1,1,0,0,"None",0,0,0,0,901171);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1226,"shipMWDCapBonusMB",0,5269,5270,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipMWDCapBonusMB",1,1,1,0,0,"None",0,0,0,0,901174);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1228,"shipProjectileTrackingGF",0,5275,5276,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipProjectileTrackingGF",1,1,1,0,0,"None",0,0,0,0,901177);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1229,"shipMWDCapBonusMF",0,5277,5278,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipMWDCapBonusMF",1,1,1,0,0,"None",0,0,0,0,901180);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1230,"shipMissileVelocityPirateFactionFrigate",0,5279,5280,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipMissileVelocityPirateFactionFrigate",1,1,1,0,0,"None",0,0,0,0,901183);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1231,"shipBonusLaserCapPirateCruiser",0,5281,5282,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipBonusLaserCapPirateCruiser",1,1,1,0,0,"None",0,0,0,0,901186);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1232,"shipProjectileRofPirateCruiser",0,5283,5284,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipProjectileRofPirateCruiser",1,1,1,0,0,"None",0,0,0,0,901189);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1233,"shipHybridDmgPirateCruiser",0,5285,5286,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipHybridDmgPirateCruiser",1,1,1,0,0,"None",0,0,0,0,901192);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1234,"shipMissileVelocityPirateFactionLight",0,5287,5288,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipMissileVelocityPirateFactionLight",1,1,1,0,0,"None",0,0,0,0,901195);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1235,"shipMissileVelocityPirateFactionHeavy",0,5289,5290,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipMissileVelocityPirateFactionHeavy",1,1,1,0,0,"None",0,0,0,0,901198);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1236,"shipMissileVelocityPirateFactionCruise",0,5291,5292,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipMissileVelocityPirateFactionCruise",1,1,1,0,0,"None",0,0,0,0,901201);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1237,"shipMissileVelocityPirateFactionTorp",0,5293,5294,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipMissileVelocityPirateFactionTorp",1,1,1,0,0,"None",0,0,0,0,901204);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1238,"shipLaserCapPirateBattleship",0,5297,5298,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipLaserCapPirateBattleship",1,1,1,0,0,"None",0,0,0,0,901207);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1239,"shipProjectileRofPirateBattleship",0,5299,5300,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipProjectileRofPirateBattleship",1,1,1,0,0,"None",0,0,0,0,901210);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1240,"shipHybridDmgPirateBattleship",0,5301,5302,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipHybridDmgPirateBattleship",1,1,1,0,0,"None",0,0,0,0,901213);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1243,"shipMissileExplosiveDamageMF1",0,5310,5311,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipMissileExplosiveDamageMF1",1,1,1,0,0,"None",0,0,0,0,901216);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1244,"smugglingModifier",0,5315,5316,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"smugglingModifier",1,1,1,0,0,"None",0,0,0,0,901219);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1252,"shipProjectileDamageDF1",0,5329,5330,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipProjectileDamageDF1",1,1,1,0,0,"None",0,0,0,0,901222);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1253,"speedBoostMassAddition",1,5331,5332,"","",0,0,1,73,0,6,0,0,1,"Speed Boost",1,1,1,0,0,"None",0,0,0,0,7582949);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1254,"speedBoostMassSigRad",1,5333,5334,"","",0,0,1,73,0,6,0,0,1,"Speed Boost",1,1,1,0,0,"None",0,0,0,0,901228);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1255,"setBonusBloodraider",0,5342,5343,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"setBonusBloodraider",1,1,1,0,0,"None",0,0,0,0,901231);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1256,"setBonusBloodraiderNosferatu",0,5346,5347,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"setBonusBloodraiderNosferatu",1,1,1,0,0,"None",0,0,0,0,901234);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1257,"blackMarketTradingSkillBoostContrabandDetectionChanceBonus",0,5352,5353,"Boost of contrabandDetectionChanceBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"blackMarketTradingSkillBoostContrabandDetectionChanceBonus",1,1,1,0,0,"None",0,0,0,0,901237);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1258,"skillBoostContrabandDetectionChanceBonusEffect",0,5356,5357,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"SkillBoostContrabandDetectionChanceBonusEffect",1,1,1,0,0,"None",0,0,0,0,901240);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1259,"testfuelConsumption",1,5360,5361,"Automatically generated effect","",0,0,1,0,0,0,0,0,0,"TESTfuelConsumption",1,1,1,0,0,"None",0,0,0,0,901243);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1260,"testmassThrust",1,5364,5365,"Automatically generated effect","",0,0,1,0,0,0,0,0,0,"TESTmassThrust",1,1,1,0,0,"None",0,0,0,0,901246);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1261,"setBonusSerpentis",0,5370,5371,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"setBonusSerpentis",1,1,1,0,0,"None",0,0,0,0,901249);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1262,"setBonusSerpentis2",0,5376,5377,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"setBonusSerpentis2",1,1,1,0,0,"None",0,0,0,0,901252);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1264,"interceptor2HybridTracking",0,5381,5382,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"interceptor2HybridTracking",1,1,1,0,0,"None",0,0,0,0,901255);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1265,"interceptor2MissileKineticDamage",0,5383,5384,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"interceptor2MissileKineticDamage",1,1,1,0,0,"None",0,0,0,0,901258);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1266,"interceptor2MissileVelocity",0,5385,5386,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"interceptor2MissileVelocity",1,1,1,0,0,"None",0,0,0,0,901261);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1268,"interceptor2LaserTracking",0,5389,5390,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"interceptor2LaserTracking",1,1,1,0,0,"None",0,0,0,0,901264);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1269,"interceptor2ProjectileFallOff",0,5391,5392,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"interceptor2ProjectileFallOff",1,1,1,0,0,"None",0,0,0,0,901267);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1270,"interceptor2ProjectileTracking",0,5393,5394,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"interceptor2ProjectileTracking",1,1,1,0,0,"None",0,0,0,0,901270);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1271,"newEwTestscanStrengthBonusTargetHostile",2,956,903,"Modifies the scanning strengths of a targeted object.","effects.ScanStrengthBonusTarget",0,1,1,73,0,6,54,158,1,"newEwTestscanStrengthBonusTargetHostile",1,1,1,0,0,"None",0,0,0,0,901273);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1272,"newEwTestswarpScramble",2,294,295,"Attempts to prevent the target from warping.","effects.WarpScramble",0,1,1,73,0,6,54,158,1,"newEwTestswarpScramble",1,1,1,0,0,"None",0,0,0,0,901276);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1273,"newEwTestssensorBoostTargetedHostile",2,3525,3526,"","effects.ElectronicAttributeModifyTarget",0,1,1,73,0,6,54,158,1,"newEwTestssensorBoostTargetedHostile",1,1,1,0,0,"None",0,0,0,0,901279);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1274,"newEwTeststurretWeaponRangeTrackingSpeedMultiplyTargetHostile",2,1013,1014,"Modifies maximum turret weapon range and tracking speed on the active target for the length of the duration.","effects.Target_paint",0,1,1,73,0,6,54,158,1,"newEwTeststurretWeaponRangeTrackingSpeedMultiplyTargetHostile",1,1,1,0,0,"None",0,0,0,0,901282);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1275,"newEwTestsdecreaseTargetSpeed",2,3489,3491,"","effects.ModifyTargetSpeed",0,1,1,73,160,6,54,158,1,"newEwTestsDecrease Target Speed",0,1,1,0,0,"None",0,0,0,0,901285);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1278,"interceptor2MissileEmDamage",0,5396,5397,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"interceptor2MissileEmDamage",1,1,1,0,0,"None",0,0,0,0,901288);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1279,"interceptors2SkillLevelPreMulEliteBonusInterceptorShip",0,5400,5401,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"interceptors2SkillLevelPreMulEliteBonusInterceptorShip",1,1,1,0,0,"None",0,0,0,0,901291);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1280,"structuralAnalyzisSkillBoostRepairBonus",0,5406,5407,"Boost of repairBonus by PostPercent of skillLevel","",0,0,0,0,0,0,0,0,0,"structuralAnalyzisSkillBoostRepairBonus",1,1,1,0,0,"None",0,0,0,0,901294);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1281,"structuralAnalysisEffect",0,5408,5409,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"structuralAnalysisEffect",1,1,1,0,0,"None",0,0,0,0,901297);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1282,"eliteIndustrial1SkillLevelPreMulEliteBonusEliteIndustrialShip",0,5415,5416,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteIndustrial1SkillLevelPreMulEliteBonusEliteIndustrialShip",1,1,1,0,0,"None",0,0,0,0,901300);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1283,"eliteIndustrial2SkillLevelPreMulEliteBonusEliteIndustrialShip",0,5419,5420,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteIndustrial2SkillLevelPreMulEliteBonusEliteIndustrialShip",1,1,1,0,0,"None",0,0,0,0,901303);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1290,"amarrIndustrialSkillLevelPreMulShipBonusAI22Ship",0,5442,5443,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"amarrIndustrialSkillLevelPreMulShipBonusAI22Ship",1,1,1,0,0,"None",0,0,0,0,901306);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1291,"caldariIndustrialSkillLevelPreMulShipBonusCI2Ship",0,5446,5447,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"caldariIndustrialSkillLevelPreMulShipBonusCI2Ship",1,1,1,0,0,"None",0,0,0,0,901309);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1292,"gallenteIndustrialSkillLevelPreMulShipBonusGI2Ship",0,5450,5451,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"gallenteIndustrialSkillLevelPreMulShipBonusGI2Ship",1,1,1,0,0,"None",0,0,0,0,901312);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1293,"minmatarIndustrialSkillLevelPreMulShipBonusMI2Ship",0,5454,5455,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"minmatarIndustrialSkillLevelPreMulShipBonusMI2Ship",1,1,1,0,0,"None",0,0,0,0,901315);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1304,"eliteIndustrialShieldBoostAmountElite1",0,5474,5475,"Automatically generated effect","",0,0,1,0,0,0,0,0,0,"eliteIndustrialShieldBoostAmountMI1",1,1,1,0,0,"None",0,0,0,0,901318);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1305,"eliteIndustrialShieldBoostCapNeedElite2",0,5476,5477,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteIndustrialShieldBoostCapNeedElite2",1,1,1,0,0,"None",0,0,0,0,901321);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1306,"eliteIndustrialArmorRepairAmountElite1",0,5478,5479,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteIndustrialArmorRepairAmountElite1",1,1,1,0,0,"None",0,0,0,0,901324);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1307,"eliteIndustrialArmorRepairCapNeedElite1",0,5421,5422,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteIndustrialArmorRepairCapNeedElite1",1,1,1,0,0,"None",0,0,0,0,901327);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1308,"eliteIndustrialArmorRepairDurationElite2",0,5425,5426,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteIndustrialArmorRepairDurationElite2",1,1,1,0,0,"None",0,0,0,0,901330);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1309,"shipMissileThermDamageGallenteInterceptor2",0,5488,5489,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipMissileThermDamageGallenteInterceptor2",1,1,1,0,0,"None",0,0,0,0,901333);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1318,"ewSkillScanStrengthBonus",0,5526,5527,"","",0,0,0,0,0,0,0,0,1,"ewSkillScanStrengthBonus",1,1,1,0,0,"None",0,0,0,0,901336);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1320,"propulsionSkillFallOffBonus",0,5534,5535,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"propulsionSkillFallOffBonus",1,1,1,0,0,"None",0,0,0,0,901339);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1321,"ewSkillScanStrengthBonusSkillLevel",0,5537,5538,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"ewSkillEwStrengthBonusSkillLevel",1,1,1,0,0,"None",0,0,0,0,901342);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1322,"propulsionSkillMaxRangeBonus",0,5539,5540,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"propulsionSkillMaxRangeBonus",1,1,1,0,0,"None",0,0,0,0,901345);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1329,"propulsionSkillPropulsionStrengthBonus",0,5561,5562,"","",0,0,0,0,0,0,0,0,1,"propulsionSkillPropulsionStrengthBonus",1,1,1,0,0,"None",0,0,0,0,901348);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1330,"propulsionSkillPropulsionStrengthBonusSkillLevel",0,5565,5566,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"propulsionSkillPropulsionStrengthBonusSkillLevel",1,1,1,0,0,"None",0,0,0,0,901351);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1335,"amarrShipEwWeaponDisruptionAF1",0,5581,5582,"","",0,0,0,0,0,0,0,0,1,"amarrShipEwWeaponDisruptionAF1",1,1,1,0,0,"None",0,0,0,0,901354);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1339,"gallenteShipEwSensorDampenGF2",0,5595,5596,"","",0,0,0,0,0,0,0,0,1,"gallenteShipEwSensorDampenGF2",1,1,1,0,0,"None",0,0,0,0,901357);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1343,"gallenteShipEwSensorDampenGC2",0,5603,5604,"","",0,0,0,0,0,0,0,0,1,"gallenteShipEwSensorDampenGC2",1,1,1,0,0,"None",0,0,0,0,901360);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1354,"ewTestEffectRsd",2,3525,3526,"","effects.ElectronicAttributeModifyTarget",0,1,1,73,0,6,54,158,1,"ewTestEffectRsd",1,1,1,0,0,"None",0,0,0,0,901363);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1355,"ewTestEffectWs",2,294,295,"Attempts to prevent the target from warping.","effects.WarpScramble",0,1,1,73,0,6,54,158,1,"ewTestEffectWs",1,1,1,0,0,"None",0,0,0,0,901366);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1358,"ewTestEffectJam",2,5643,5644,"Automatically generated effect","",0,1,1,73,0,6,54,158,0,"ewTestEffectJam",1,1,1,0,0,"None",0,0,0,0,901369);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1360,"ewSkillRsdCapNeedBonusSkillLevel",0,5649,5650,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"ewSkillRsdCapNeedBonusSkillLevel",1,1,1,0,0,"None",0,0,0,0,901372);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1361,"ewSkillTdCapNeedBonusSkillLevel",0,5653,5654,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"ewSkillTdCapNeedBonusSkillLevel",1,1,1,0,0,"None",0,0,0,0,901375);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1367,"propulsionSkillStasisStrengthBonus",0,5678,5679,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"propulsionSkillStasisStrengthBonus",1,1,1,0,0,"None",0,0,0,0,901378);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1369,"ewSkillTrackingDisruptionBonus",0,5682,5683,"","",0,0,0,0,0,0,0,0,1,"ewSkillTrackingDisruptionBonus",1,1,1,0,0,"None",0,0,0,0,901381);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1370,"ewSkillTpCapNeedBonusSkillLevel",0,5686,5687,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"ewSkillTpCapNeedBonusSkillLevel",1,1,1,0,0,"None",0,0,0,0,901384);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1372,"ewSkillEwCapNeedSkillLevel",0,5695,5696,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"ewSkillEwCapNeedSkillLevel",1,1,1,0,0,"None",0,0,0,0,901387);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1373,"ewSkillTargetPaintingStrengthBonusSkillLevel",0,5699,5700,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"ewSkillTargetPaintingStrengthBonusSkillLevel",1,1,1,0,0,"None",0,0,0,0,901390);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1376,"ewSkillSignatureDampenBonus",0,5705,5706,"","",0,0,0,0,0,0,0,0,1,"ewSkillSignatureDampenBonus",1,1,1,0,0,"None",0,0,0,0,901393);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1387,"leadershipCpuBonus",0,5743,5744,"Automatically generated effect","",0,0,1,0,0,0,0,0,0,"logisticsCPUReduction",1,1,1,0,0,"None",0,0,0,0,901396);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1390,"stealthOnline",4,3520,3521,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"stealthOnline",1,1,1,0,0,"None",0,0,0,0,901399);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1394,"covertOpsStealthBomberCruiseLauncerPowerNeedBonus",0,5777,5778,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"covertOpsStealthBomberCruiseLauncerPowerNeedBonus",1,1,1,0,0,"None",0,0,0,0,901402);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1395,"shieldBoostAmplifierPassive",0,3171,3172,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shieldBoostAmplifierPassive",1,1,1,0,0,"None",0,0,0,0,901405);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1397,"setBonusGuristas",0,5786,5787,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"setBonusGuristas",1,1,1,0,0,"None",0,0,0,0,901408);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1398,"eliteBonusCoverOpsCruiseEmDmg1",0,5791,5792,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusCoverOpsCruiseEmDmg1",1,1,1,0,0,"None",0,0,0,0,901411);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1399,"eliteBonusCoverOpsCruiseThermalDmg1",0,5795,5796,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusCoverOpsCruiseThermalDmg1",1,1,1,0,0,"None",0,0,0,0,901414);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1400,"eliteBonusCoverOpsCruiseExplosiveDmg1",0,5799,5800,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusCoverOpsCruiseExplosiveDmg1",1,1,1,0,0,"None",0,0,0,0,901417);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1401,"eliteBonusCoverOpsCruiseLauncherPowerNeed1",0,5802,5803,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusCoverOpsCruiseLauncherPowerNeed1",1,1,1,0,0,"None",0,0,0,0,901420);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1402,"eliteBonusCoverOpsCloakingVelocity2",0,5806,5807,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusCoverOpsCloakingVelocity2",1,1,1,0,0,"None",0,0,0,0,901423);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1403,"shipMissileCruiseKineticDmgCF2",0,5810,5811,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipMissileCruiseKineticDmgCF2",1,1,1,0,0,"None",0,0,0,0,901426);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1405,"covertOpsSkillLevelPreMulEliteBonusCoverOpsShip2",0,5814,5815,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"covertOpsSkillLevelPreMulEliteBonusCoverOpsShip2",1,1,1,0,0,"None",0,0,0,0,901429);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1407,"eliteBonusCoverOpsScanProbeDuration2",0,5827,5828,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusCoverOpsScanProbeDuration2",1,1,1,0,0,"None",0,0,0,0,901432);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1409,"systemScanDurationSkillAstrometrics",0,5833,5834,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"systemScanDurationSkillAstrometrics",1,1,1,0,0,"None",0,0,0,0,901435);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1410,"propulsionSkillCapNeedBonusSkillLevel",0,5657,5658,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"propulsionSkillCapNeedBonusSkillLevel",1,1,1,0,0,"None",0,0,0,0,901438);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1411,"gangBonusSignature",1,5835,5836,"Automatically generated effect","effects.ElectronicAttributeModifyActivate",0,0,1,73,0,6,0,0,0,"gangSignatureBoost",1,1,1,0,0,"None",0,0,0,0,901441);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1412,"shipBonusHybridOptimalCB",0,5837,5838,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipBonusHybridOptimalCB",1,1,1,0,0,"None",0,0,0,0,901444);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1434,"caldariShipEwStrengthCB",0,5888,5889,"","",0,0,0,0,0,0,0,0,1,"caldariShipEwStrengthCB",1,1,1,0,0,"None",0,0,0,0,901447);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1440,"missileEMdamageOther",0,5903,5904,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"missileEMdamageOther",1,1,1,0,0,"None",0,0,0,0,901450);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1441,"caldariShipEwOptimalRangeCB3",0,5907,5908,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"caldariShipEwOptimalRangeCB3",1,1,1,0,0,"None",0,0,0,0,901453);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1442,"caldariShipEwOptimalRangeCC2",0,5909,5910,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"caldariShipEwOptimalRangeCC2",1,1,1,0,0,"None",0,0,0,0,901456);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1443,"caldariShipEwCapacitorNeedCC",0,5911,5912,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"caldariShipEwCapacitorNeedCC",1,1,1,0,0,"None",0,0,0,0,901459);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1445,"ewSkillRsdMaxRangeBonus",0,5915,5916,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"ewSkillRsdMaxRangeBonus",1,1,1,0,0,"None",0,0,0,0,901462);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1446,"ewSkillTpMaxRangeBonus",0,5919,5920,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"ewSkillTpMaxRangeBonus",1,1,1,0,0,"None",0,0,0,0,901465);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1448,"ewSkillTdMaxRangeBonus",0,5929,5930,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"ewSkillTdMaxRangeBonus",1,1,1,0,0,"None",0,0,0,0,901468);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1449,"ewSkillRsdFallOffBonus",0,5933,5934,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"ewSkillRsdFallOffBonus",1,1,1,0,0,"None",0,0,0,0,901471);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1450,"ewSkillTpFallOffBonus",0,5937,5938,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"ewSkillTpFallOffBonus",1,1,1,0,0,"None",0,0,0,0,901474);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1451,"ewSkillTdFallOffBonus",0,5941,5942,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"ewSkillTdFallOffBonus",1,1,1,0,0,"None",0,0,0,0,901477);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1452,"ewSkillEwMaxRangeBonus",0,5943,5944,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"ewSkillEwMaxRangeBonus",1,1,1,0,0,"None",0,0,0,0,901480);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1453,"ewSkillEwFallOffBonus",0,5947,5948,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"ewSkillEwFallOffBonus",1,1,1,0,0,"None",0,0,0,0,901483);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1467,"missileSkillAoeVelocityBonusSkillLevel",0,5982,5983,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"missileSkillAoeVelocityBonusSkillLevel",1,1,1,0,0,"None",0,0,0,0,901486);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1472,"missileSkillAoeCloudSizeBonus",0,6000,6001,"","",0,0,0,0,0,0,0,0,0,"missileSkillAoeCloudSizeBonus",1,1,1,0,0,"None",0,0,0,0,901489);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1473,"missileSkillAoeCloudSizeBonusSkillLevel",0,6004,6005,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"missileSkillAoeCloudSizeBonusSkillLevel",1,1,1,0,0,"None",0,0,0,0,901492);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1483,"contrabandMasking",1,6032,6033,"","",0,0,1,73,0,6,0,0,1,"contrabandMasking",1,1,1,0,0,"None",0,0,0,0,901495);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1486,"commandMultiplier",0,6050,6051,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"commandMultiplier",1,1,1,0,0,"None",0,0,0,0,901498);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1495,"flagshipmultiRelayEffect",4,6083,6084,"Automatically generated effect","",0,0,1,0,0,0,0,0,0,"multiRelayEffect",1,1,1,0,0,"None",0,0,0,0,901501);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1496,"relayActiveMultiplier",1,6087,6088,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"relayActiveMultiplier",1,1,1,0,0,"None",0,0,0,0,901504);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1498,"masterAndCommander2",0,6076,6077,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"masterAndCommander2",1,1,1,0,0,"None",0,0,0,0,901507);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1499,"shieldOperationSkillBoostCapacitorNeedBonusSkillLevel",0,6097,6098,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shieldOperationSkillBoostCapacitorNeedBonus",1,1,1,0,0,"None",0,0,0,0,901510);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1500,"shieldOperationSkillBoostCapacitorNeedBonus",0,6099,6100,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shieldOperationSkillBoostCapacitorNeedBonus",1,1,1,0,0,"None",0,0,0,0,901513);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1501,"covertOpsStealthBomberCruiseMissileExplosionRadiusBonus",0,6102,6103,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"covertOpsStealthBomberCruiseMissileExplosionRadiusBonus",1,1,1,0,0,"None",0,0,0,0,901516);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1502,"armorTankingGang",0,6106,6107,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"armorTankingGang",1,1,1,0,0,"None",0,0,0,0,901519);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1510,"gangArmorHardening",1,6128,6129,"","effects.ElectronicAttributeModifyActivate",0,0,0,73,0,6,0,0,1,"gangArmorHardening",1,1,1,0,0,"None",0,0,0,0,2766693);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1541,"squadronmultiplyer",0,6211,6212,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"squadronmultiplyer",1,1,1,0,0,"None",0,0,0,0,901525);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1542,"squadronCommand",0,6219,6220,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"squadronCommand",1,1,1,0,0,"None",0,0,0,0,901528);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1546,"gangPropulsionJammingBoost",1,6235,6236,"Automatically generated effect","effects.ElectronicAttributeModifyActivate",0,0,0,73,0,6,0,0,0,"gangPropulsionJammingBoost",1,1,1,0,0,"None",0,0,0,0,901531);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1548,"gangShieldHardening",1,6239,6240,"","effects.ElectronicAttributeModifyActivate",0,0,0,73,0,6,0,0,1,"gangShieldHardening",1,1,1,0,0,"None",0,0,0,0,901534);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1549,"ewTargetPaint",2,3836,3837,"Automatically generated effect","effects.TargetPaint",0,1,1,73,0,6,54,158,0,"ewTargetPaint",1,1,1,0,0,"None",0,0,0,0,901537);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1550,"ewSkillTargetPaintingStrengthBonus",0,5951,5952,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"ewSkillTargetPaintingStrengthBonus",1,1,1,0,0,"None",0,0,0,0,901540);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1551,"minmatarShipEwTargetPainterMF2",0,5953,5954,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"minmatarShipEwTargetPainterMF2",1,1,1,0,0,"None",0,0,0,0,901543);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1577,"angelsetbonus",0,6304,6305,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"angelsetbonus",1,1,1,0,0,"None",0,0,0,0,901546);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1579,"setBonusSansha",0,6313,6314,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"setBonusSansha",1,1,1,0,0,"None",0,0,0,0,901549);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1581,"jumpDriveSkillsRangeBonus",0,6321,6322,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"jumpDriveSkillsRangeBonus",1,1,1,0,0,"None",0,0,0,0,901552);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1582,"jumpDriveSkillsRangeBonusSkillLevel",0,6325,6326,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"jumpDriveSkillsRangeBonusSkillLevel",1,1,1,0,0,"None",0,0,0,0,901555);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1585,"capitalTurretSkillLaserDamage",0,6338,6339,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"capitalTurretSkillLaserDamage",1,1,1,0,0,"None",0,0,0,0,901558);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1586,"capitalTurretSkillProjectileDamage",0,6344,6345,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"capitalTurretSkillProjectileDamage",1,1,1,0,0,"None",0,0,0,0,901561);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1587,"capitalTurretSkillHybridDamage",0,6350,6351,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"capitalTurretSkillHybridDamage",1,1,1,0,0,"None",0,0,0,0,901564);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1588,"capitalLauncherSkillCitadelKineticDamage",0,6356,6357,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"capitalLauncherSkillCitadelDamage",1,1,1,0,0,"None",0,0,0,0,901567);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1590,"missileSkillAoeVelocityBonus",0,6278,6279,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"missileSkillAoeVelocityBonus",1,1,1,0,0,"None",0,0,0,0,901570);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1592,"capitalLauncherSkillCitadelEmDamage",0,6365,6366,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"capitalLauncherSkillCitadelEmDamage",1,1,1,0,0,"None",0,0,0,0,901573);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1593,"capitalLauncherSkillCitadelExplosiveDamage",0,6369,6370,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"capitalLauncherSkillCitadelExplosiveDamage",1,1,1,0,0,"None",0,0,0,0,901576);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1594,"capitalLauncherSkillCitadelThermalDamage",0,6373,6374,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"capitalLauncherSkillCitadelThermalDamage",1,1,1,0,0,"None",0,0,0,0,901579);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1595,"missileSkillWarheadUpgradesEmDamageBonus",0,6375,6376,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"missileSkillWarheadUpgradesEmDamageBonus",1,1,1,0,0,"None",0,0,0,0,901582);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1596,"missileSkillWarheadUpgradesExplosiveDamageBonus",0,6377,6378,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"missileSkillWarheadUpgradesExplosiveDamageBonus",1,1,1,0,0,"None",0,0,0,0,901585);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1597,"missileSkillWarheadUpgradesKineticDamageBonus",0,6379,6380,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"missileSkillWarheadUpgradesKineticDamageBonus",1,1,1,0,0,"None",0,0,0,0,901588);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1614,"skillAdvancedSpaceshipAgilityBonus",0,6409,6410,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"skillAdvancedSpaceshipAgilityBonus",1,1,1,0,0,"None",0,0,0,0,901591);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1615,"shipAdvancedSpaceshipCommandAgilityBonus",0,6412,6413,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipAdvancedSpaceshipCommandAgilityBonus",1,1,1,0,0,"None",0,0,0,0,901594);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1616,"skillCapitalShipsAdvancedAgility",0,6418,6419,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"skillCapitalShipsAdvancedAgility",1,1,1,0,0,"None",0,0,0,0,901597);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1617,"shipCapitalAgilityBonus",0,6420,6421,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipCapitalAgilityBonus",1,1,1,0,0,"None",0,0,0,0,901600);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1618,"dreadnoughtBoostShipBonusA1",0,6434,6435,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"dreadnoughtBoostShipBonusA",1,1,1,0,0,"None",0,0,0,0,901603);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1619,"dreadnoughtBoostShipBonusA2",0,6438,6439,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"dreadnoughtBoostShipBonus",1,1,1,0,0,"None",0,0,0,0,901606);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1620,"dreadnoughtBoostShipBonusC1",0,6442,6443,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"dreadnoughtBoostShipBonusC1",1,1,1,0,0,"None",0,0,0,0,901609);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1621,"dreadnoughtBoostShipBonusC2",0,6446,6447,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"dreadnoughtBoostShipBonusC2",1,1,1,0,0,"None",0,0,0,0,901612);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1622,"dreadnoughtBoostShipBonusG1",0,6450,6451,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"dreadnoughtBoostShipBonusG1",1,1,1,0,0,"None",0,0,0,0,901615);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1623,"dreadnoughtBoostShipBonusG2",0,6454,6455,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"dreadnoughtBoostShipBonusG2",1,1,1,0,0,"None",0,0,0,0,901618);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1624,"dreadnoughtBoostShipBonusM1",0,6458,6459,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"dreadnoughtBoostShipBonusM1",1,1,1,0,0,"None",0,0,0,0,901621);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1625,"dreadnoughtBoostShipBonusM2",0,6462,6463,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"dreadnoughtBoostShipBonusM2",1,1,1,0,0,"None",0,0,0,0,901624);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1626,"dreadnoughtShipBonusLaserCapNeedA1",0,6466,6467,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"dreadnoughtShipBonusLaserCapNeedA1",1,1,1,0,0,"None",0,0,0,0,901627);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1627,"dreadnoughtShipBonusLaserRofA2",0,6469,6470,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"dreadnoughtShipBonusLaserRofA2",1,1,1,0,0,"None",0,0,0,0,901630);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1628,"dreadnoughtShipBonusLauncherRofC1",0,6471,6472,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"dreadnoughtShipBonusLauncherRofC1",1,1,1,0,0,"None",0,0,0,0,901633);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1630,"dreadnoughtShipBonusHybridDmgG1",0,6475,6476,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"dreadnoughtShipBonusHybridDmgG1",1,1,1,0,0,"None",0,0,0,0,901636);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1632,"dreadnoughtShipBonusProjectileRofM1",0,6481,6482,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"dreadnoughtShipBonusProjectileRofM1",1,1,1,0,0,"None",0,0,0,0,901639);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1633,"dreadnoughtShipBonusLauncherRofM2",0,6483,6484,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"dreadnoughtShipBonusLauncherRofM2",1,1,1,0,0,"None",0,0,0,0,901642);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1634,"capitalShieldOperationSkillCapacitorNeedBonus",0,6489,6490,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"capitalShieldOperationSkillCapacitorNeedBonus",1,1,1,0,0,"None",0,0,0,0,901645);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1635,"capitalRepairSystemsSkillDurationBonus",0,6495,6496,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"capitalRepairSystemsSkillDurationBonus",1,1,1,0,0,"None",0,0,0,0,901648);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1638,"skillAdvancedWeaponUpgradesPowerNeedBonus",0,6505,6506,"","",0,0,0,0,0,0,0,0,1,"skillAdvancedWeaponUpgradesPowerNeedBonus",1,1,1,0,0,"None",0,0,0,0,901651);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1643,"armoredWarfareMindlink",0,6517,6518,"Automatically generated effect","",0,0,1,0,0,0,0,0,0,"ArmoredWarfareMindlink",1,1,1,0,0,"None",0,0,0,0,901654);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1644,"shirmishWarfareMindlink",0,6523,6524,"Automatically generated effect","",0,0,1,0,0,0,0,0,0,"ShirmishWarfareMindlink",1,1,1,0,0,"None",0,0,0,0,901657);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1645,"siegeWarfareMindlink",0,6529,6530,"Automatically generated effect","",0,0,1,0,0,0,0,0,0,"SiegeWarfareMindlink",1,1,1,0,0,"None",0,0,0,0,901660);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1646,"covertWarfareMindlink",0,6535,6536,"Automatically generated effect","",0,0,1,0,0,0,0,0,0,"CovertWarfareMindlink",1,1,1,0,0,"None",0,0,0,0,901663);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1648,"gangECCMfixed",1,6539,6540,"","effects.ElectronicAttributeModifyActivate",0,0,1,73,0,6,0,0,1,"Gang ECCM",1,1,1,0,0,"None",0,0,0,0,901666);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1649,"skillCynosuralTheoryConsumptionQuantityBonus",0,6547,6548,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"skillConsumptionQuantityBonus",1,1,1,0,0,"None",0,0,0,0,901669);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1650,"skillSiegeModuleConsumptionQuantityBonus",0,6553,6554,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"skillSiegeModuleConsumptionQuantityBonus",1,1,1,0,0,"None",0,0,0,0,901672);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1651,"skillCynosural&SiegeConsumQuantityBonusSkillLevel",0,6557,6558,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"skillCynosural&SiegeConsumQuantityBonusSkillLevel",1,1,1,0,0,"None",0,0,0,0,901675);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1652,"skillJumpDriveConsumptionAmountBonus",0,6561,6562,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"skilljumpDriveConsumptionAmountBonus",1,1,1,0,0,"None",0,0,0,0,901678);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1657,"missileSkillWarheadUpgradesThermalDamageBonus",0,6388,6389,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"missileSkillWarheadUpgradesThermalDamageBonus",1,1,1,0,0,"None",0,0,0,0,901681);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1659,"freighterA1SkillLevel",0,6590,6591,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"freighterMaxVelocityBonusA1",1,1,1,0,0,"None",0,0,0,0,901684);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1660,"freighterA2SkillLevel",0,6572,6573,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"freighterCargoBonusA2",1,1,1,0,0,"None",0,0,0,0,901687);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1661,"freighterC1SkillLevel",0,6594,6595,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"freighterMaxVelocityBonusC1",1,1,1,0,0,"None",0,0,0,0,901690);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1663,"freighterC2SkillLevel",0,6601,6602,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"freighterMaxVelocityBonusG1",1,1,1,0,0,"None",0,0,0,0,901693);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1664,"freighterG1SkillLevel",0,6605,6606,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"freighterMaxVelocityBonusG1",1,1,1,0,0,"None",0,0,0,0,901696);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1665,"freighterG2SkillLevel",0,6609,6610,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"freighterCargoBonusG2",1,1,1,0,0,"None",0,0,0,0,901699);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1666,"freighterM1SkillLevel",0,6613,6614,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"freighterMaxVelocityBonusM1",1,1,1,0,0,"None",0,0,0,0,901702);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1667,"freighterM2SkillLevel",0,6617,6618,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"freighterCargoBonusM2",1,1,1,0,0,"None",0,0,0,0,901705);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1668,"freighterCargoBonusA2",0,6576,6577,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"freighterCargoBonusA2",1,1,1,0,0,"None",0,0,0,0,901708);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1669,"freighterCargoBonusC2",0,6619,6620,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"freighterCargoBonusC2",1,1,1,0,0,"None",0,0,0,0,901711);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1670,"freighterCargoBonusG2",0,6621,6622,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"freighterCargoBonusG2",1,1,1,0,0,"None",0,0,0,0,901714);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1671,"freighterCargoBonusM2",0,6623,6624,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"freighterCargoBonusM2",1,1,1,0,0,"None",0,0,0,0,901717);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1672,"freighterMaxVelocityBonusA1",0,6574,6575,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"freighterMaxVelocityBonusA1",1,1,1,0,0,"None",0,0,0,0,901720);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1673,"freighterMaxVelocityBonusC1",0,6625,6626,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"freighterMaxVelocityBonusC1",1,1,1,0,0,"None",0,0,0,0,901723);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1674,"freighterMaxVelocityBonusG1",0,6627,6628,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"freighterMaxVelocityBonusG1",1,1,1,0,0,"None",0,0,0,0,901726);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1675,"freighterMaxVelocityBonusM1",0,6629,6630,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"freighterMaxVelocityBonusM1",1,1,1,0,0,"None",0,0,0,0,901729);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1676,"testfuelBoostShipSpeedActivation",1,6633,6634,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"TESTfuelBoostShipSpeedActivation",1,1,1,0,0,"None",0,0,0,0,901732);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1720,"shieldBoostAmplifier",4,6717,6718,"","",0,0,0,0,0,0,0,0,1,"shieldBoostAmplifier",1,1,1,0,0,"None",0,0,0,0,901735);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1721,"dreadnoughtShipBonusMissileKineticDmgC2",0,6720,6721,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"dreadnoughtShipBonusMissileKineticDmgC2",1,1,1,0,0,"None",0,0,0,0,901738);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1722,"jumpDriveSkillsCapacitorNeedBonus",0,6726,6727,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"jumpDriveSkillsCapacitorNeedBonus",1,1,1,0,0,"None",0,0,0,0,901741);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1723,"jumpDriveSkillsCapacitorNeedBonusSkillLevel",0,6730,6731,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"jumpDriveSkillsCapacitorNeedBonusSkillLevel",1,1,1,0,0,"None",0,0,0,0,901744);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1729,"cynosuralGenerationTmp",1,6742,6743,"","",0,0,0,73,0,0,0,0,1,"cynosuralGenerationTmp",1,1,1,0,0,"None",0,0,0,0,901747);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1730,"droneDmgBonus",0,6744,6745,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"droneDmgBonus",1,1,1,0,0,"None",0,0,0,0,901750);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1731,"testDroneShieldEffect",0,6750,6751,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"TestDroneShieldEffect",1,1,1,0,0,"None",0,0,0,0,901753);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1738,"openSpawnContainer",2,131,131,"","effects.TargetScan",0,0,0,73,0,6,54,0,1,"openSpawnContainer",1,1,1,0,0,"None",0,0,0,0,901756);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1740,"dataMiningSkillMultiplierFixed",0,6782,6783,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"dataMiningSkillMultiplierFixed",1,1,1,0,0,"None",0,0,0,0,901759);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1745,"siegeModeEffectOld",1,6790,6791,"","effects.SiegeMode",0,0,0,73,0,0,0,0,1,"siegeModeEffect",1,1,1,0,0,"None",0,0,0,0,901762);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1746,"gangArmorRepairSpeedAmplifier",1,6794,6795,"Automatically generated effect","effects.ElectronicAttributeModifyActivate",0,0,0,73,0,6,0,0,0,"gangArmorRepairSpeedAmplifier",1,1,1,0,0,"None",0,0,0,0,901765);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1747,"gangArmorRepairCapReducer",1,6798,6799,"Automatically generated effect","effects.ElectronicAttributeModifyActivate",0,0,0,73,0,6,0,0,0,"gangArmorRepairCapReducer",1,1,1,0,0,"None",0,0,0,0,901768);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1752,"entityEwTestEffectJam",2,5643,5644,"Automatically generated effect","",0,1,1,73,0,0,0,0,0,"entityEwTestEffectJam",1,1,1,0,0,"None",0,0,0,0,2565333);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1755,"gangAbMwdFactorBoost",1,6820,6821,"","",0,0,0,73,0,6,0,0,1,"gangAbMwdFactorBoost",1,1,1,0,0,"None",0,0,0,0,901774);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1756,"skirmishWarfareVelocityBonus",0,6823,6824,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"skirmishWarfareVelocityBonus",1,1,1,0,0,"None",0,0,0,0,901777);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1763,"missileSkillRapidLauncherRoF",0,6859,6860,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"missileSkillRapidLauncherRoF",1,1,1,0,0,"None",0,0,0,0,901780);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1764,"missileSkillMissileProjectileVelocityBonus",0,6861,6862,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"missileSkillMissileProjectileVelocityBonus",1,1,1,0,0,"None",0,0,0,0,901783);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1765,"missileSkillMissileProjectileVelocityBonusSkillLevel",0,6864,6865,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"missileSkillMissileProjectileVelocityBonusSkillLevel",1,1,1,0,0,"None",0,0,0,0,901786);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1767,"shipBonusPirateSanshaLaserCap",0,6871,6872,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipBonusPirateSanshaLaserCap",1,1,1,0,0,"None",0,0,0,0,901789);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1773,"shipFalloffBonusGF",0,6892,6893,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipFalloffBonusGF",1,1,1,0,0,"None",0,0,0,0,901792);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1791,"amarrShipEwTrackingDisruptAC1",0,6943,6944,"","",0,0,0,0,0,0,0,0,1,"amarrShipEwTrackingDisruptAC1",1,1,1,0,0,"None",0,0,0,0,901795);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1802,"shipMissileLightVelocityBonusCF2",0,6970,6971,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipMissileLightVelocityBonusCF2",1,1,1,0,0,"None",0,0,0,0,901798);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1803,"shipMissileRocketVelocityBonusCF2",0,6972,6973,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipMissileRocketVelocityBonusCF2",1,1,1,0,0,"None",0,0,0,0,901801);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1804,"shipArmorEMResistanceAF1",0,6978,6979,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipArmorEMResistanceAF1",1,1,1,0,0,"None",0,0,0,0,901804);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1805,"shipArmorTHResistanceAF1",0,6980,6981,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipArmorTHResistanceAF1",1,1,1,0,0,"None",0,0,0,0,901807);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1806,"shipArmorKNResistanceAF1",0,6982,6983,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipArmorKNResistanceAF1",1,1,1,0,0,"None",0,0,0,0,901810);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1807,"shipArmorEXResistanceAF1",0,6984,6985,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipArmorEXResistanceAF1",1,1,1,0,0,"None",0,0,0,0,901813);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1812,"shipShieldEMResistanceCC2",0,6994,6995,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipShieldEMResistanceCC2",1,1,1,0,0,"None",0,0,0,0,901816);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1813,"shipShieldThermalResistanceCC2",0,6996,6997,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipShieldThermalResistanceCC2",1,1,1,0,0,"None",0,0,0,0,901819);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1814,"shipShieldKineticResistanceCC2",0,6998,6999,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipShieldKineticResistanceCC2",1,1,1,0,0,"None",0,0,0,0,901822);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1815,"shipShieldExplosiveResistanceCC2",0,7000,7001,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipShieldExplosiveResistanceCC2",1,1,1,0,0,"None",0,0,0,0,901825);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1816,"shipShieldEMResistanceCF2",0,7002,7003,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipShieldEMResistanceCF2",1,1,1,0,0,"None",0,0,0,0,901828);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1817,"shipShieldThermalResistanceCF2",0,7004,7005,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipShieldThermalResistanceCF2",1,1,1,0,0,"None",0,0,0,0,901831);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1819,"shipShieldKineticResistanceCF2",0,7008,7009,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipShieldKineticResistanceCF2",1,1,1,0,0,"None",0,0,0,0,901834);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1820,"shipShieldExplosiveResistanceCF2",0,7010,7011,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipShieldExplosiveResistanceCF2",1,1,1,0,0,"None",0,0,0,0,901837);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1822,"increaseGallenteNavyBonus",4,7021,7022,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"increaseGallenteNavyBonus",1,1,1,0,0,"None",0,0,0,0,901840);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1824,"increaseCaldariNavyBonus",4,7034,7035,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"increaseCaldariNavyBonus",1,1,1,0,0,"None",0,0,0,0,901843);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1825,"increaseAmarrNavyBonus",4,7038,7039,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"increaseAmarrNavyBonus",1,1,1,0,0,"None",0,0,0,0,901846);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1826,"increaseRepublicFleetBonus",4,7042,7043,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"increaseRepublicFleetBonus",1,1,1,0,0,"None",0,0,0,0,901849);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1833,"miningYieldGangBonus",0,7073,7074,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"miningYieldGangBonus",1,1,1,0,0,"None",0,0,0,0,901852);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1835,"miningYieldMultiply",4,7078,7079,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"miningYieldMultiply",1,1,1,0,0,"None",0,0,0,0,901855);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1838,"eliteBargeSkillMultiplier1",0,7094,7095,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBargeSkillMultiplier1",1,1,1,0,0,"None",0,0,0,0,901858);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1839,"eliteBargeSkillMultiplier2",0,7098,7099,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBargeSkillMultiplier2",1,1,1,0,0,"None",0,0,0,0,901861);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1840,"eliteBonusBargeMiningYield",0,7100,7101,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusBargeMiningYield",1,1,1,0,0,"None",0,0,0,0,901864);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1848,"miningForemanMindlink",0,7130,7131,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"miningForemanMindlink",1,1,1,0,0,"None",0,0,0,0,901867);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1849,"miningBargeSkillLevelPostMulShipBonusORE3Ship",0,7136,7137,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"miningBargeSkillLevelPostMulShipBonusORE3Ship",1,1,1,0,0,"None",0,0,0,0,901870);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1851,"selfRof",0,7140,7141,"Automatically generated effect","",0,0,1,0,0,0,0,0,0,"SelfRof",1,1,1,0,0,"None",0,0,0,0,901873);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1852,"shipMiningBonusAF",0,7142,7143,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipMiningBonusAF",1,1,1,0,0,"None",0,0,0,0,901876);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1853,"shipMiningBonusCF",0,7144,7145,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipMiningBonusCF",1,1,1,0,0,"None",0,0,0,0,901879);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1854,"shipCargoBonusGF",0,7146,7147,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipCargoBonusGF",1,1,1,0,0,"None",0,0,0,0,901882);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1855,"shipBonusScanProbeDurationCF",0,7148,7149,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipBonusScanProbeDurationCF",1,1,1,0,0,"None",0,0,0,0,901885);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1856,"shipBonusScanProbeDurationGF",0,7150,7151,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipBonusScanProbeDurationGF",1,1,1,0,0,"None",0,0,0,0,901888);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1857,"shipBonusScanProbeDurationMF",0,7152,7153,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipBonusScanProbeDurationMF",1,1,1,0,0,"None",0,0,0,0,901891);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1862,"shipMissileEMDamageCF",0,7171,7172,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipMissileEMDamageCF",1,1,1,0,0,"None",0,0,0,0,901894);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1863,"shipMissileThermalDamageCF",0,7173,7174,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipMissileThermalDamageCF",1,1,1,0,0,"None",0,0,0,0,901897);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1864,"shipMissileExplosiveDamageCF",0,7175,7176,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipMissileExplosiveDamageCF",1,1,1,0,0,"None",0,0,0,0,901900);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1865,"shipMissileEMDamageMF2",0,7177,7178,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipMissileEMDamageMF2",1,1,1,0,0,"None",0,0,0,0,901903);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1866,"shipMissileThermalDamageMF2",0,7179,7180,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipMissileThermalDamageMF2",1,1,1,0,0,"None",0,0,0,0,901906);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1867,"shipMissileKineticDamageMF2",0,7181,7182,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipMissileKineticDamageMF2",1,1,1,0,0,"None",0,0,0,0,901909);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1868,"shipMissileThermalDamageAF1",0,7183,7184,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipMissileThermalDamageAF1",1,1,1,0,0,"None",0,0,0,0,901912);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1869,"shipMissileKineticDamageAF1",0,7185,7186,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipMissileKineticDamageAF1",1,1,1,0,0,"None",0,0,0,0,901915);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1870,"shipMissileExplosiveDamageAF1",0,7187,7188,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipMissileExplosiveDamageAF1",1,1,1,0,0,"None",0,0,0,0,901918);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1871,"entityTargetJam",2,7210,7211,"Automatically generated effect","",0,0,1,929,0,0,936,953,0,"entityTargetJam",1,1,1,0,0,"None",0,930,0,0,901921);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1872,"entityCapacitorDrain",2,270,131,"Steals power from the target.","effects.EnergyVampire",0,0,0,942,0,0,937,0,1,"entityCapacitorDrain",1,1,1,0,0,"None",0,931,0,0,901924);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1877,"entityTrackingDisrupt",2,1013,1014,"Modifies maximum turret weapon range and tracking speed on the active target for the length of the duration.","effects.ElectronicAttributeModifyTarget",0,1,1,944,0,0,940,951,1,"entityTrackingDisrupt",1,1,1,0,0,"None",0,933,0,0,2565749);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1878,"entitySensorDampen",2,3525,3526,"","effects.ElectronicAttributeModifyTarget",0,1,1,943,0,0,938,950,1,"entitySensorDampen",1,1,1,0,0,"None",0,932,0,0,901930);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1879,"entityTargetPaint",2,3836,3837,"Automatically generated effect","",0,1,1,945,0,0,941,954,0,"entityTargetPaint",1,1,1,0,0,"None",0,935,0,0,2565748);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1882,"miningYieldMultiplyPercent",4,2240,2241,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"miningYieldMultiplyPercent",1,1,1,0,0,"None",0,0,0,0,901936);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1885,"shipCruiseLauncherROFBonus2CB",0,7234,7235,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipCruiseLauncherROFBonus2CB",1,1,1,0,0,"None",0,0,0,0,901939);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1886,"shipSiegeLauncherROFBonus2CB",0,7236,7237,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipSiegeLauncherROFBonus2CB",1,1,1,0,0,"None",0,0,0,0,901942);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1894,"caldariNavyBonusHybridDamage",0,7265,7266,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"caldariNavyBonusHybridDamage",1,1,1,0,0,"None",0,0,0,0,901945);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1895,"miningUpgradeCPUReductionBonus",0,7269,7270,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"miningUpgradeCPUReductionBonus",1,1,1,0,0,"None",0,0,0,0,901948);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1896,"eliteBargeBonusIceHarvestingCycleTimeBarge3",0,7271,7272,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBargeBonusIceHarvestingCycleTimeBarge3",1,1,1,0,0,"None",0,0,0,0,901951);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1897,"shieldCompensationSkillBoostHardeningBonus",0,7277,7278,"Boost of hardeningBonus by PreMul of skillLevel","",0,0,0,0,0,0,0,0,0,"shieldCompensationSkillBoostHardeningBonus",1,1,1,0,0,"None",0,0,0,0,901954);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1904,"caldariNavyBonusCPUEnhancerBonus",1,7307,7308,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"caldariNavyBonusCPUEnhancerBonus",1,1,1,0,0,"None",0,0,0,0,901957);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1905,"caldariNavyBonusShieldBooster",0,7311,7312,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"caldariNavyBonusShieldBooster",1,1,1,0,0,"None",0,0,0,0,901960);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1908,"reconShipSkillMultiplier1",0,7325,7326,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"reconShipSkillMultiplier1",1,1,1,0,0,"None",0,0,0,0,901963);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1909,"reconShipSkillMultiplier2",0,7329,7330,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"reconShipSkillMultiplier2",1,1,1,0,0,"None",0,0,0,0,901966);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1910,"eliteBonusVampireDrainAmount2",0,7331,7332,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusVampireDrainAmount2",1,1,1,0,0,"None",0,0,0,0,901969);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1911,"eliteReconBonusGravimetricStrength2",0,7335,7336,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteReconBonusGravimetricStrength2",1,1,1,0,0,"None",0,0,0,0,901972);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1912,"eliteReconBonusMagnetometricStrength2",0,7339,7340,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteReconBonusMagnetometricStrength2",1,1,1,0,0,"None",0,0,0,0,901975);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1913,"eliteReconBonusRadarStrength2",0,7343,7344,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteReconBonusRadarStrength2",1,1,1,0,0,"None",0,0,0,0,901978);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1914,"eliteReconBonusLadarStrength2",0,7347,7348,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteReconBonusLadarStrength2",1,1,1,0,0,"None",0,0,0,0,901981);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1920,"eliteReconEnergyVampireRangeBonus1",0,7359,7360,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteReconEnergyVampireRangeBonus1",1,1,1,0,0,"None",0,0,0,0,901984);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1921,"eliteReconStasisWebBonus2",0,7361,7362,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteReconStasisWebBonus2",1,1,1,0,0,"None",0,0,0,0,901987);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1922,"eliteReconJumpScramblerRangeBonus2",0,7367,7368,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteReconJumpScramblerRangeBonus2",1,1,1,0,0,"None",0,0,0,0,901990);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1938,"setActiveDamageResonanceMultiplier",1,7421,7422,"","effects.ModifyShieldResonance",0,1,1,73,0,6,0,0,1,"setActiveDamageResonanceMultiplier",1,1,1,0,0,"None",0,0,0,0,901993);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1943,"ammoEMResistOther",0,7435,7436,"Automatically generated effect","",0,0,1,0,0,0,0,0,0,"EM Resistance Modifier",1,1,1,0,0,"None",0,0,0,0,901996);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1959,"armorReinforcerMassAdd",4,5841,5842,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"armorReinforcerMassAdd",1,1,1,0,0,"None",0,0,0,0,901999);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1962,"signatureRadiusBonus",1,7501,7502,"Automatically generated effect","",0,0,0,73,0,6,0,0,0,"signatureRadiusBonus",1,1,1,0,0,"None",0,0,0,0,902002);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1963,"shipCargoBonusMF2",0,7503,7504,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipCargoBonusMF2",1,1,1,0,0,"None",0,0,0,0,902005);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1964,"shipBonusShieldTransferCapneed1",0,7505,7506,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipBonusShieldTransferCapneed1",1,1,1,0,0,"None",0,0,0,0,902008);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1965,"shipBonusEnergyTransferCapNeed1",0,7507,7508,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipBonusEnergyTransferCapNeed1",1,1,1,0,0,"None",0,0,0,0,902011);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1968,"shipBonusTrackingLinkMC1",0,7513,7514,"","",0,0,0,0,0,0,0,0,1,"shipBonusTrackingLinkMC1",1,1,1,0,0,"None",0,0,0,0,902014);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1969,"shipBonusRemoteArmorRepairCapNeedGC1",0,7515,7516,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipBonusRemoteArmorRepairCapNeedGC1",1,1,1,0,0,"None",0,0,0,0,902017);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (1996,"caldariShipEwCapacitorNeedCF2",0,7577,7578,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"caldariShipEwCapacitorNeedCF2",1,1,1,0,0,"None",0,0,0,0,902020);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2000,"droneRangeBonusAdd",4,2674,2675,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"droneRangeBonusAdd",1,1,1,0,0,"None",0,0,0,0,902023);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2003,"droneDamageMultiplierBonusPercent",4,7602,7603,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"droneDamageMultiplierBonusPercent",1,1,1,0,0,"None",0,0,0,0,902026);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2007,"droneTrackingComputerMultiply",4,7616,7617,"","droneTrackingComputerMultiply",0,0,0,0,0,0,0,0,1,"droneTrackingComputerMultiply",1,1,1,0,0,"None",0,0,0,0,902029);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2008,"cynosuralDurationBonus",0,7618,7619,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"cynosuralDurationBonus",1,1,1,0,0,"None",0,0,0,0,902032);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2009,"reconShipCpuMultiplier1",0,7620,7621,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"reconShipCpuMultiplier1",1,1,1,0,0,"None",0,0,0,0,902035);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2010,"propulsionDroneJammingStrength",0,7626,7627,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"propulsionDroneJammingStrength",1,1,1,0,0,"None",0,0,0,0,902038);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2011,"droneMaxVelocitySkillBonus",0,7630,7631,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"droneMaxVelocitySkillBonus",1,1,1,0,0,"None",0,0,0,0,902041);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2013,"droneMaxVelocityBonus",0,7638,7639,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"droneMaxVelocityBonus",1,1,1,0,0,"None",0,0,0,0,902044);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2014,"droneMaxRangeBonus",0,7641,7642,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"droneMaxRangeBonus",1,1,1,0,0,"None",0,0,0,0,902047);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2015,"droneDurabilityShieldCapBonus",0,7645,7646,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"droneDurabilityShieldCapBonus",1,1,1,0,0,"None",0,0,0,0,902050);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2016,"droneDurabilityArmorHPBonus",0,7649,7650,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"droneDurabilityArmorHPBonus",1,1,1,0,0,"None",0,0,0,0,902053);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2017,"droneDurabilityHPBonus",0,7653,7654,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"droneDurabilityHPBonus",1,1,1,0,0,"None",0,0,0,0,902056);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2018,"damageRepairedSkillBonus",0,7658,7659,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"damageRepairedSkillBonus",1,1,1,0,0,"None",0,0,0,0,902059);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2019,"repairDroneShieldBonusBonus",0,7662,7663,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"repairDroneShieldBonusBonus",1,1,1,0,0,"None",0,0,0,0,902062);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2020,"repairDroneArmorDamageAmountBonus",0,7666,7667,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"repairDroneArmorDamageAmountBonus",1,1,1,0,0,"None",0,0,0,0,902065);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2029,"addToSignatureRadius2",4,7686,7687,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"addToSignatureRadius2",1,1,1,0,0,"None",0,0,0,0,902068);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2041,"modifyArmorResonancePostPercent",4,7725,7726,"","",0,0,0,0,0,0,0,0,1,"modifyArmorResonancePostPercent",1,1,1,0,0,"None",0,0,0,0,902071);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2052,"modifyShieldResonancePostPercent",4,7755,7756,"","",0,0,0,0,0,0,0,0,1,"modifyShieldResonancePostPercent",1,1,1,0,0,"None",0,0,0,0,902074);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2053,"emShieldCompensationHardeningBonusGroupShieldAmp",0,7761,7762,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"emShieldCompensationHardeningBonusGroupShieldAmp",1,1,1,0,0,"None",0,0,0,0,902077);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2054,"explosiveShieldCompensationHardeningBonusGroupShieldAmp",0,7765,7766,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"explosiveShieldCompensationHardeningBonusGroupShieldAmp",1,1,1,0,0,"None",0,0,0,0,902080);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2055,"kineticShieldCompensationHardeningBonusGroupShieldAmp",0,7769,7770,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"kineticShieldCompensationHardeningBonusGroupShieldAmp",1,1,1,0,0,"None",0,0,0,0,902083);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2056,"thermalShieldCompensationHardeningBonusGroupShieldAmp",0,7773,7774,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"thermalShieldCompensationHardeningBonusGroupShieldAmp",1,1,1,0,0,"None",0,0,0,0,902086);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2062,"shieldCompensationSkillBoostHardeningBonus2",0,7793,7794,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shieldCompensationSkillBoostHardeningBonus2",1,1,1,0,0,"None",0,0,0,0,902089);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2071,"empWaveGrid",1,131,131,"Triggering of a grid-wide EMP wave being broadcast into space.","effects.EMPWaveGrid",0,1,1,73,0,6,0,0,1,"empWaveGrid",1,1,1,0,0,"None",0,0,0,0,902092);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2084,"modifyArmorResonancePassivePostPercent",4,7861,7862,"","",0,0,0,0,0,0,0,0,1,"modifyArmorResonancePassivePostPercent",1,1,1,0,0,"None",0,0,0,0,902095);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2098,"modifyActiveArmorResonanceAndNullifyPassiveResonance",1,7906,7907,"","effects.ArmorHardening",0,0,1,73,0,6,0,0,1,"modifyActiveArmorResonanceAndNullifyPassiveResonance",1,1,1,0,0,"None",0,0,0,0,3074918);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2105,"emArmorCompensationHardeningBonusGroupArmorCoating",0,7924,7925,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"emArmorCompensationHardeningBonusGroupArmorCoating",1,1,1,0,0,"None",0,0,0,0,902101);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2106,"explosiveArmorCompensationHardeningBonusGroupArmorCoating",0,7928,7929,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"explosiveArmorCompensationHardeningBonusGroupArmorCoating",1,1,1,0,0,"None",0,0,0,0,902104);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2107,"kineticArmorCompensationHardeningBonusGroupArmorCoating",0,7932,7933,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"kineticArmorCompensationHardeningBonusGroupArmorCoating",1,1,1,0,0,"None",0,0,0,0,902107);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2108,"thermicArmorCompensationHardeningBonusGroupArmorCoating",0,7936,7937,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"thermicArmorCompensationHardeningBonusGroupArmorCoating",1,1,1,0,0,"None",0,0,0,0,902110);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2109,"emArmorCompensationHardeningBonusGroupEnergized",0,7942,7943,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"emArmorCompensationHardeningBonusGroupEnergized",1,1,1,0,0,"None",0,0,0,0,902113);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2110,"explosiveArmorCompensationHardeningBonusGroupEnergized",0,7946,7947,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"explosiveArmorCompensationHardeningBonusGroupEnergized",1,1,1,0,0,"None",0,0,0,0,902116);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2111,"kineticArmorCompensationHardeningBonusGroupEnergized",0,7950,7951,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"kineticArmorCompensationHardeningBonusGroupEnergized",1,1,1,0,0,"None",0,0,0,0,902119);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2112,"thermicArmorCompensationHardeningBonusGroupEnergized",0,7954,7955,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"thermicArmorCompensationHardeningBonusGroupEnergized",1,1,1,0,0,"None",0,0,0,0,902122);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2113,"passiveEmArmorResonanceBonusGroupArmorHardener2",0,7957,7958,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"passiveEmArmorResonanceBonusGroupArmorHardener2",1,1,1,0,0,"None",0,0,0,0,902125);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2115,"passiveKineticArmorResonanceBonusGroupArmorHardener2",0,7963,7964,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"passiveKineticArmorResonanceBonusGroupArmorHardener2",1,1,1,0,0,"None",0,0,0,0,902128);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2116,"passiveThermicArmorResonanceBonusGroupArmorHardener2",0,7966,7967,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"passiveThermicArmorResonanceBonusGroupArmorHardener2",1,1,1,0,0,"None",0,0,0,0,902131);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2117,"modifyShieldResonancePassivePostPercent",4,7982,7983,"","",0,0,1,0,0,0,0,0,1,"modifyShieldResonancePassivePostPercent",1,1,1,0,0,"None",0,0,0,0,902134);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2118,"modifyActiveShieldResonanceAndNullifyPassiveResonance",1,7968,7969,"","effects.ModifyShieldResonance",0,0,1,73,0,6,0,0,1,"modifyActiveShieldResonanceAndNullifyPassiveResonance",1,1,1,0,0,"None",0,0,0,0,902137);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2126,"passiveEmShieldResonanceBonusGroupArmorHardener2",0,7989,7990,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"passiveEmShieldResonanceBonusGroupArmorHardener2",1,1,1,0,0,"None",0,0,0,0,902140);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2127,"passiveExplosiveShieldResonanceBonusGroupArmorHardener2",0,7993,7994,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"passiveExplosiveShieldResonanceBonusGroupArmorHardener2",1,1,1,0,0,"None",0,0,0,0,902143);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2128,"passiveKineticShieldResonanceBonusGroupArmorHardener2",0,7997,7998,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"passiveKineticShieldResonanceBonusGroupArmorHardener2",1,1,1,0,0,"None",0,0,0,0,902146);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2129,"passiveThermicShieldResonanceBonusGroupArmorHardener2",0,8001,8002,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"passiveThermicShieldResonanceBonusGroupArmorHardener2",1,1,1,0,0,"None",0,0,0,0,902149);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2130,"smallHybridMaxRangeBonus",0,8003,8004,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"smallHybridMaxRangeBonus",1,1,1,0,0,"None",0,0,0,0,902152);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2131,"smallEnergyMaxRangeBonus",0,8005,8006,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"smallEnergyMaxRangeBonus",1,1,1,0,0,"None",0,0,0,0,902155);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2132,"smallProjectileMaxRangeBonus",0,8007,8008,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"smallProjectileMaxRangeBonus",1,1,1,0,0,"None",0,0,0,0,902158);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2133,"energyTransferArrayMaxRangeBonus",0,8009,8010,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"energyTransferArrayMaxRangeBonus",1,1,1,0,0,"None",0,0,0,0,902161);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2134,"shieldTransporterMaxRangeBonus",0,8015,8016,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shieldTransporterMaxRangeBonus",1,1,1,0,0,"None",0,0,0,0,902164);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2135,"armorRepairProjectorMaxRangeBonus",0,8021,8022,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"armorRepairProjectorMaxRangeBonus",1,1,1,0,0,"None",0,0,0,0,902167);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2136,"trackingLinkMaxRangeBonus",0,8027,8028,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"trackingLinkMaxRangeBonus",1,1,1,0,0,"None",0,0,0,0,902170);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2140,"dreadnoughShipBonusDroneShieldCapG2",0,8038,8039,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"dreadnoughShipBonusDroneShieldCapG2",1,1,1,0,0,"None",0,0,0,0,902173);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2141,"dreadnoughShipBonusDroneArmorHPG2",0,8040,8041,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"dreadnoughShipBonusDroneArmorHPG2",1,1,1,0,0,"None",0,0,0,0,902176);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2142,"dreadnoughShipBonusDroneStructureHPG2",0,8042,8043,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"dreadnoughShipBonusDroneStructureHPG2",1,1,1,0,0,"None",0,0,0,0,902179);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2143,"minmatarShipEwTargetPainterMC2",0,6949,6950,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"minmatarShipEwTargetPainterMC2",1,1,1,0,0,"None",0,0,0,0,902182);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2148,"droneDamageBonusRequringDrones",0,7602,7603,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"droneDamageBonusRequringDrones",1,1,1,0,0,"None",0,0,0,0,902185);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2152,"jumpPortalGeneration",1,6732,6733,"","effects.JumpPortal",0,0,0,1002,0,0,0,0,1,"jumpPortalGeneration",1,1,1,0,0,"None",0,0,0,0,902188);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2155,"eliteBonusCommandShipProjectileDamageCS1",0,8087,8088,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusCommandShipProjectileDamageCS1",1,1,1,0,0,"None",0,0,0,0,902191);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2156,"eliteBonusCommandShipProjectileFalloffCS2",0,8089,8090,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusCommandShipProjectileFalloffCS2",1,1,1,0,0,"None",0,0,0,0,902194);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2157,"eliteBonusCommandShipLaserDamageCS1",0,8091,8092,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusCommandShipLaserDamageCS1",1,1,1,0,0,"None",0,0,0,0,902197);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2158,"eliteBonusCommandShipLaserROFCS2",0,8093,8094,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusCommandShipLaserROFCS2",1,1,1,0,0,"None",0,0,0,0,902200);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2159,"eliteBonusCommandShipHybridDamageCS1",0,8095,8096,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusCommandShipHybridDamageCS1",1,1,1,0,0,"None",0,0,0,0,902203);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2160,"eliteBonusCommandShipHybridFalloffCS2",0,8097,8098,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusCommandShipHybridFalloffCS2",1,1,1,0,0,"None",0,0,0,0,902206);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2161,"eliteBonusCommandShipHybridOptimalCS1",0,8099,8100,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusCommandShipHybridOptimalCS1",1,1,1,0,0,"None",0,0,0,0,902209);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2162,"eliteBonusCommandShipSiegeCS2",0,8101,8102,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusCommandShipSiegeCS2",1,1,1,0,0,"None",0,0,0,0,902212);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2163,"eliteBonusCommandShipProjectileTrackingCS1",0,8103,8104,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusCommandShipProjectileTrackingCS1",1,1,1,0,0,"None",0,0,0,0,902215);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2164,"eliteBonusCommandShipSkirmishCS2",0,8105,8106,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusCommandShipSkirmishCS2",1,1,1,0,0,"None",0,0,0,0,902218);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2166,"eliteBonusCommandShipArmoredCS2",0,8109,8110,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusCommandShipArmoredCS2",1,1,1,0,0,"None",0,0,0,0,902221);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2168,"eliteBonusCommandShipInfoCS2",0,8113,8114,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusCommandShipInfoCS2",1,1,1,0,0,"None",0,0,0,0,902224);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2179,"shipBonusDroneHitpointsGC2",0,8138,8139,"","",0,0,0,0,0,0,0,0,1,"shipBonusDroneHitpointsGC2",1,1,1,0,0,"None",0,0,0,0,902227);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2181,"shipBonusDroneHitpointsFixedAC2",0,8142,8143,"","",0,0,0,0,0,0,0,0,1,"shipBonusDroneHitpointsFixedAC2",1,1,1,0,0,"None",0,0,0,0,902230);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2186,"shipBonusDroneHitpointsGB2",0,8152,8153,"","",0,0,0,0,0,0,0,0,1,"shipBonusDroneHitpointsGB2",1,1,1,0,0,"None",0,0,0,0,902233);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2187,"shipBonusDroneDamageMultiplierGB2",0,8154,8155,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipBonusDroneDamageMultiplierGB2",1,1,1,0,0,"None",0,0,0,0,902236);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2188,"shipBonusDroneDamageMultiplierGC2",0,8156,8157,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipBonusDroneDamageMultiplierGC2",1,1,1,0,0,"None",0,0,0,0,902239);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2189,"shipBonusDroneDamageMultiplierAC2",0,8158,8159,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipBonusDroneDamageMultiplierAC2",1,1,1,0,0,"None",0,0,0,0,902242);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2190,"dreadnoughtShipBonusDroneDamageMultiplierG2",0,8160,8161,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"dreadnoughtShipBonusDroneDamageMultiplierG2",1,1,1,0,0,"None",0,0,0,0,902245);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2191,"shipMissileVelocityDF1",0,8168,8169,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipMissileVelocityDF1",1,1,1,0,0,"None",0,0,0,0,902248);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2192,"entityShieldBoostingSmall",1,4037,131,"","effects.ShieldBoosting",0,0,0,636,0,0,0,0,1,"entityShieldBoostingSmall",1,1,1,0,0,"None",0,1006,0,0,902251);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2193,"entityShieldBoostingMedium",1,4037,131,"","effects.ShieldBoosting",0,0,0,636,0,0,0,0,1,"entityShieldBoostingMedium",1,1,1,0,0,"None",0,1007,0,0,902254);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2194,"entityShieldBoostingLarge",1,4037,131,"","effects.ShieldBoosting",0,0,0,636,0,0,0,0,1,"entityShieldBoostingLarge",1,1,1,0,0,"None",0,1008,0,0,902257);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2195,"entityArmorRepairingSmall",1,4039,131,"Repair damage to the ships armor.","effects.ArmorRepair",0,0,0,630,0,0,0,0,1,"entityArmorRepairingSmall",1,1,1,0,0,"None",0,1009,0,0,902260);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2196,"entityArmorRepairingMedium",1,4039,131,"Repair damage to the ships armor.","effects.ArmorRepair",0,0,0,630,0,0,0,0,1,"entityArmorRepairingMedium",1,1,1,0,0,"None",0,1010,0,0,902263);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2197,"entityArmorRepairingLarge",1,4039,131,"Repair damage to the ships armor.","effects.ArmorRepair",0,0,0,630,0,0,0,0,1,"entityArmorRepairingLarge",1,1,1,0,0,"None",0,1011,0,0,902266);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2199,"eliteBonusInterdictorsMissileThermalDamage1",0,8177,8178,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusInterdictorsMissileThermalDamage1",1,1,1,0,0,"None",0,0,0,0,902269);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2200,"eliteBonusInterdictorsMissileKineticDamage1",0,8179,8180,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusInterdictorsMissileKineticDamage1",1,1,1,0,0,"None",0,0,0,0,902272);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2201,"eliteBonusInterdictorsProjectileFalloff1",0,8181,8182,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusInterdictorsProjectileFalloff1",1,1,1,0,0,"None",0,0,0,0,902275);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2202,"droneDmgBonusRequiringScoutDroneOP",0,8183,8184,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"droneDmgBonusRequiringScoutDroneOP",1,1,1,0,0,"None",0,0,0,0,902278);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2215,"shipBonusPirateFrigateProjDamage",0,8235,8236,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipBonusPirateFrigateProjDamage",1,1,1,0,0,"None",0,0,0,0,902281);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2218,"navigationComputerWarpAccuracyBonus",1,8250,8251,"","",0,0,1,0,0,0,0,0,1,"navigationComputerWarpAccuracyBonus",1,1,1,0,0,"None",0,0,0,0,902284);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2221,"warpNavigationWarpAccuracyBonus",0,8262,8263,"","",0,0,0,0,0,0,0,0,1,"warpNavigationWarpAccuracyBonus",1,1,1,0,0,"None",0,0,0,0,902287);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2224,"warpNavigationWarpAccuracySkillLevel",0,8272,8273,"","",0,0,0,0,0,0,0,0,1,"warpNavigationWarpAccuracySkillLevel",1,1,1,0,0,"None",0,0,0,0,902290);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2231,"scanStrengthBonusPercentActivate",1,8294,8295,"Boosts some of the scan strengths for the period of activation.","effects.ScanStrengthBonusActivate",0,0,1,73,0,6,0,0,1,"scanStrengthBonusPercentActivate",1,1,1,0,0,"None",0,0,0,0,902293);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2232,"scanStrengthBonusPercentOnline",4,8294,8295,"Modifies the various electronics scan strengths..","",0,0,0,0,0,0,0,0,1,"scanStrengthBonusPercentOnline",1,1,1,0,0,"None",0,0,0,0,902296);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2246,"scanStrengthTargetPercentBonus",2,8321,8322,"","",0,0,1,73,0,6,54,158,1,"scanStrengthTargetPercentBonus",1,1,1,0,0,"None",0,0,0,0,902299);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2247,"dronesMaxActiveDroneBonusModAddMaxActiveActive",1,1876,1877,"Automatically generated effect","",0,0,1,73,0,6,0,0,0,"dronesMaxActiveDroneBonusModAddMaxActiveActive",1,1,1,0,0,"None",0,0,0,0,902302);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2249,"shipBonusDroneMiningAmountAC2",0,8329,8330,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipBonusDroneMiningAmountAC2",1,1,1,0,0,"None",0,0,0,0,902305);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2250,"shipBonusDroneMiningAmountGC2",0,8331,8332,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipBonusDroneMiningAmountGC2",1,1,1,0,0,"None",0,0,0,0,902308);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2251,"commandshipMultiRelayEffect",0,6083,6084,"commandshipMultiRelayEffect","",0,0,0,0,0,0,0,0,0,"commandshipMultiRelayEffect",1,1,1,0,0,"None",0,0,0,0,902311);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2252,"covertOpsAndReconOpsCloakModuleDelayBonus",0,8338,8339,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"covertOpsAndReconOpsCloakModuleDelayBonus",1,1,1,0,0,"None",0,0,0,0,902314);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2253,"covertOpsStealthBomberTargettingDelayBonus",0,8344,8345,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"covertOpsStealthBomberTargettingDelayBonus",1,1,1,0,0,"None",0,0,0,0,902317);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2254,"passiveExplosiveArmorResonanceBonusGroupArmorHardener2FIXED",0,8347,8348,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"passiveExplosiveArmorResonanceBonusGroupArmorHardener2FIXED",1,1,1,0,0,"None",0,0,0,0,902320);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2255,"tractorBeamCan",2,131,131,"","effects.TractorBeam",0,0,0,73,0,6,54,0,1,"tractorBeamCan",1,1,1,0,0,"None",0,0,0,0,902323);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2256,"shipMissilePrecisionDF2",0,8349,8350,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipMissilePrecisionDF2",1,1,1,0,0,"None",0,0,0,0,902326);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2257,"eliteBonusInterdictorsBubbleRoF2",0,8355,8356,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusInterdictorsBubbleRoF2",1,1,1,0,0,"None",0,0,0,0,902329);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2258,"eliteBargeMercoxiteCrystalBonus1",0,8361,8362,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBargeMercoxiteCrystalBonus1",1,1,1,0,0,"None",0,0,0,0,902332);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2259,"eliteBargeBonusDamageCloudReduction2",0,8364,8365,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBargeBonusDamageCloudReduction2",1,1,1,0,0,"None",0,0,0,0,902335);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2261,"titanMinmatarProjectileRoF1",0,8376,8377,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"titanMinmatarProjectileRoF1",1,1,1,0,0,"None",0,0,0,0,902338);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2263,"titanAmarrEnergyTurretCapNeed1",0,8374,8375,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"titanAmarrEnergyTurretCapNeed1",1,1,1,0,0,"None",0,0,0,0,902341);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2264,"titanAmarrGangCapRecharge2",0,8382,8383,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"titanAmarrGangCapRecharge2",1,1,1,0,0,"None",0,0,0,0,902344);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2265,"titanCaldariMissileKineticDmg1",0,8384,8385,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"titanCaldariMissileKineticDmg1",1,1,1,0,0,"None",0,0,0,0,902347);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2266,"titanCaldariGangShieldHp2",0,8386,8387,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"titanCaldariGangShieldHp2",1,1,1,0,0,"None",0,0,0,0,902350);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2267,"titanGallenteHybridDamage1",0,8388,8389,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"titanGallenteHybridDamage1",1,1,1,0,0,"None",0,0,0,0,902353);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2268,"titanGallenteGangArmorHp2",0,8390,8391,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"titanGallenteGangArmorHp2",1,1,1,0,0,"None",0,0,0,0,902356);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2287,"titanAmarrSkillLevel1",0,8463,8464,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"titanAmarrSkillLevel1",1,1,1,0,0,"None",0,0,0,0,902359);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2288,"titanAmarrSkillLevel2",0,8466,8467,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"titanAmarrSkillLevel2",1,1,1,0,0,"None",0,0,0,0,902362);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2289,"titanCaldariSkillLevel1",0,8469,8470,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"titanCaldariSkillLevel1",1,1,1,0,0,"None",0,0,0,0,902365);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2290,"titanCaldariSkillLevel2",0,8472,8473,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"titanCaldariSkillLevel2",1,1,1,0,0,"None",0,0,0,0,902368);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2291,"titanGallenteSkillLevel1",0,8475,8476,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"titanGallenteSkillLevel1",1,1,1,0,0,"None",0,0,0,0,902371);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2292,"titanGallenteSkillLevel2",0,8478,8479,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"titanGallenteSkillLevel2",1,1,1,0,0,"None",0,0,0,0,902374);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2293,"titanMinmatarSkillLevel2",0,8481,8482,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"titanMinmatarSkillLevel2",1,1,1,0,0,"None",0,0,0,0,902377);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2294,"titanMinmatarSkillLevel1",0,8484,8485,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"titanMinmatarSkillLevel1",1,1,1,0,0,"None",0,0,0,0,902380);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2296,"modifyArmorResonancePassivePostPercentPassive",0,7861,7862,"","",0,0,0,0,0,0,0,0,1,"modifyArmorResonancePassivePostPercentPassive",1,1,1,0,0,"None",0,0,0,0,902383);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2297,"modifyShieldResonancePassivePostPercentPassive",0,7982,7983,"","",0,0,0,0,0,0,0,0,1,"modifyShieldResonancePassivePostPercentPassive",1,1,1,0,0,"None",0,0,0,0,902386);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2298,"scanStrengthBonusPercentPassive",0,8294,8295,"Boosts some of the scan strengths for the period of activation.","effects.ScanStrengthBonusActivate",0,0,0,0,0,0,0,0,1,"scanStrengthBonusPercentPassive",1,1,1,0,0,"None",0,0,0,0,902389);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2302,"damageControl",1,8493,8494,"","",0,0,1,73,0,6,0,0,1,"damageControl",1,1,1,0,0,"None",0,0,0,0,902392);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2303,"energyDestabilizationNew",2,8495,8496,"","effects.EnergyDestabilization",0,0,1,73,0,6,98,0,1,"energyDestabilizationTEST",1,1,1,0,0,"None",0,0,0,0,902395);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2304,"energyNosferatu",2,8497,8496,"","effects.EnergyVampire",0,1,1,73,0,0,91,0,1,"energyNosferatu",1,1,1,0,0,"None",0,0,0,0,902398);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2305,"eliteReconBonusEnergyNeutAmount2",0,8502,8503,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteReconBonusEnergyNeutAmount2",1,1,1,0,0,"None",0,0,0,0,902401);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2306,"eliteReconBonusEnergyNeutRange1",0,8507,8508,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteReconBonusEnergyNeutRange1",1,1,1,0,0,"None",0,0,0,0,902404);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2308,"eliteReconBonusAssaultLauncherROF1",0,8515,8516,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteReconBonusAssaultLauncherROF1",1,1,1,0,0,"None",0,0,0,0,902407);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2309,"droneMWDBoostOnline",4,8517,8518,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"droneMWDBoostOnline",1,1,1,0,0,"None",0,0,0,0,902410);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2311,"skillADDmaxJumpClones",0,8527,8528,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"skillADDmaxJumpClones",1,1,1,0,0,"None",0,0,0,0,902413);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2312,"disallowOffensiveActChar",0,8534,8535,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"disallowOffensiveAct",1,1,1,0,0,"None",0,0,0,0,902416);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2313,"carrierAmarrSkillLevel1",0,8551,8552,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"carrierAmarrSkillLevel1",1,1,1,0,0,"None",0,0,0,0,902419);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2314,"carrierAmarrSkillLevel2",0,8555,8556,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"carrierAmarrSkillLevel2",1,1,1,0,0,"None",0,0,0,0,902422);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2315,"carrierAmarrSkillLevel3",0,8559,8560,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"carrierAmarrSkillLevel3",1,1,1,0,0,"None",0,0,0,0,902425);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2316,"carrierCaldariSkillLevel1",0,8563,8564,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"carrierCaldariSkillLevel1",1,1,1,0,0,"None",0,0,0,0,902428);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2317,"carrierCaldariSkillLevel2",0,8567,8568,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"carrierCaldariSkillLevel2",1,1,1,0,0,"None",0,0,0,0,902431);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2318,"carrierCaldariSkillLevel3",0,8571,8572,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"carrierCaldariSkillLevel3",1,1,1,0,0,"None",0,0,0,0,902434);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2319,"carrierGallenteSkillLevel1",0,8575,8576,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"carrierGallenteSkillLevel1",1,1,1,0,0,"None",0,0,0,0,902437);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2320,"carrierGallenteSkillLevel2",0,8579,8580,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"carrierGallenteSkillLevel2",1,1,1,0,0,"None",0,0,0,0,902440);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2321,"carrierGallenteSkillLevel3",0,8583,8584,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"carrierGallenteSkillLevel3",1,1,1,0,0,"None",0,0,0,0,902443);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2322,"carrierMinmatarSkillLevel1",0,8587,8588,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"carrierMinmatarSkillLevel1",1,1,1,0,0,"None",0,0,0,0,902446);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2323,"carrierMinmatarSkillLevel2",0,8591,8592,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"carrierMinmatarSkillLevel2",1,1,1,0,0,"None",0,0,0,0,902449);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2324,"carrierMinmatarSkillLevel3",0,8595,8596,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"carrierMinmatarSkillLevel3",1,1,1,0,0,"None",0,0,0,0,902452);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2325,"carrierAmarrDroneMax1",0,8597,8598,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"carrierAmarrDroneMax1",1,1,1,0,0,"None",0,0,0,0,902455);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2326,"carrierCaldariDroneMax1",0,8599,8600,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"carrierCaldariDroneMax1",1,1,1,0,0,"None",0,0,0,0,902458);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2327,"carrierGallenteDroneMax1",0,8601,8602,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"carrierGallenteDroneMax1",1,1,1,0,0,"None",0,0,0,0,902461);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2328,"carrierMinmatarDroneMax1",0,8603,8604,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"carrierMinmatarDroneMax1",1,1,1,0,0,"None",0,0,0,0,902464);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2332,"carrierGallenteDroneOwnDmg2",0,8615,8616,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"carrierGallenteDroneOwnDmg2",1,1,1,0,0,"None",0,0,0,0,902467);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2334,"cloneJumpAcceptingTmp",1,6742,6743,"","",0,0,0,73,0,0,0,0,1,"cloneJumpAcceptingTmp",1,1,1,0,0,"None",0,0,0,0,902470);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2335,"titanMinmatarGangSigRadius2",0,8619,8620,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"titanMinmatarGangSigRadius2",1,1,1,0,0,"None",0,0,0,0,902473);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2336,"titanAmarrSkillLevel3",0,8632,8633,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"titanAmarrSkillLevel3",1,1,1,0,0,"None",0,0,0,0,902476);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2337,"titanAmarrSkillLevel4",0,8636,8637,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"titanAmarrSkillLevel4",1,1,1,0,0,"None",0,0,0,0,902479);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2338,"titanCaldariSkillLevel3",0,8640,8641,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"titanCaldariSkillLevel3",1,1,1,0,0,"None",0,0,0,0,902482);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2339,"titanCaldariSkillLevel4",0,8644,8645,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"titanCaldariSkillLevel4",1,1,1,0,0,"None",0,0,0,0,902485);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2340,"titanGallenteSkillLevel3",0,8648,8649,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"titanGallenteSkillLevel3",1,1,1,0,0,"None",0,0,0,0,902488);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2341,"titanGallenteSkillLevel4",0,8652,8653,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"titanGallenteSkillLevel4",1,1,1,0,0,"None",0,0,0,0,902491);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2342,"titanMinmatarSkillLevel3",0,8656,8657,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"titanMinmatarSkillLevel3",1,1,1,0,0,"None",0,0,0,0,902494);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2343,"titanMinmatarSkillLevel4",0,8660,8661,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"titanMinmatarSkillLevel4",1,1,1,0,0,"None",0,0,0,0,902497);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2344,"carrierAmarrSkillLevel4",0,8669,8670,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"carrierAmarrSkillLevel4",1,1,1,0,0,"None",0,0,0,0,902500);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2345,"carrierCaldariSkillLevel4",0,8673,8674,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"carrierCaldariSkillLevel4",1,1,1,0,0,"None",0,0,0,0,902503);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2346,"carrierGallenteSkillLevel4",0,8677,8678,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"carrierGallenteSkillLevel4",1,1,1,0,0,"None",0,0,0,0,902506);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2347,"titanAmarrLaserDmg3",0,8679,8680,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"titanAmarrLaserDmg3",1,1,1,0,0,"None",0,0,0,0,902509);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2348,"titanAmarrLeadershipModuleAmount4",0,8685,8686,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"titanAmarrLeadershipModuleAmount4",1,1,1,0,0,"None",0,0,0,0,902512);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2349,"titanCaldariLeadershipModuleAmount4",0,8687,8688,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"titanCaldariLeadershipModuleAmount4",1,1,1,0,0,"None",0,0,0,0,902515);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2350,"titanGallenteLeadershipModuleAmount4",0,8689,8690,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"titanGallenteLeadershipModuleAmount4",1,1,1,0,0,"None",0,0,0,0,902518);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2351,"titanMinmatarLeadershipModuleAmount4",0,8691,8692,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"titanMinmatarLeadershipModuleAmount4",1,1,1,0,0,"None",0,0,0,0,902521);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2352,"titanCaldariLauncherRoF3",0,8693,8694,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"titanCaldariLauncherRoF3",1,1,1,0,0,"None",0,0,0,0,902524);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2353,"titanMinmatarProjectileDmg3",0,8695,8696,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"titanMinmatarProjectileDmg3",1,1,1,0,0,"None",0,0,0,0,902527);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2354,"capitalRemoteArmorRepairerCapNeedBonusSkill",0,8701,8702,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"capitalRemoteArmorRepairerCapNeedBonusSkill",1,1,1,0,0,"None",0,0,0,0,902530);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2355,"capitalRemoteShieldTransferCapNeedBonusSkill",0,8707,8708,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"capitalRemoteShieldTransferCapNeedBonusSkill",1,1,1,0,0,"None",0,0,0,0,902533);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2356,"capitalRemoteEnergyTransferCapNeedBonusSkill",0,8713,8714,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"capitalRemoteEnergyTransferCapNeedBonusSkill",1,1,1,0,0,"None",0,0,0,0,902536);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2359,"carrierMinmatarArmor&ShieldTransferDuration2",0,8723,8724,"","",0,0,0,0,0,0,0,0,1,"carrierMinmatarArmor&ShieldTransferDuration2",1,1,1,0,0,"None",0,0,0,0,902539);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2360,"carrierAmarrLeadershipMaxGroupActive4",0,8725,8726,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"carrierAmarrLeadershipMaxGroupActive4",1,1,1,0,0,"None",0,0,0,0,902542);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2361,"carrierCaldariLeadershipMaxGroupActive4",0,8727,8728,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"carrierCaldariLeadershipMaxGroupActive4",1,1,1,0,0,"None",0,0,0,0,902545);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2362,"carrierGallenteLeadershipMaxGroupActive4",0,8729,8730,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"carrierGallenteLeadershipMaxGroupActive4",1,1,1,0,0,"None",0,0,0,0,902548);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2363,"carrierMinmatarLeadershipMaxGroupActive4",0,8731,8732,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"carrierMinmatarLeadershipMaxGroupActive4",1,1,1,0,0,"None",0,0,0,0,902551);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2364,"carrierMinmatarSkillLevel4",0,8735,8736,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"carrierMinmatarSkillLevel4",1,1,1,0,0,"None",0,0,0,0,902554);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2371,"carrierAmarrArmorResist2",0,8749,8750,"","",0,0,0,0,0,0,0,0,1,"carrierAmarrArmorResist2",1,1,1,0,0,"None",0,0,0,0,902557);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2378,"carrierCaldariShieldResist2",0,8763,8764,"","",0,0,0,0,0,0,0,0,1,"carrierCaldariShieldResist2",1,1,1,0,0,"None",0,0,0,0,902560);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2381,"carrierAmarrArmor&EnergyTransferRange3",0,8773,8774,"","",0,0,0,0,0,0,0,0,1,"carrierAmarrArmor&EnergyTransferRange3",1,1,1,0,0,"None",0,0,0,0,902563);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2384,"carrierCaldariShield&EnergyTransferRange3",0,8781,8782,"","",0,0,0,0,0,0,0,0,1,"carrierCaldariShield&EnergyTransferRange3",1,1,1,0,0,"None",0,0,0,0,902566);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2387,"carrierGallenteArmor&ShieldTransferRange3",0,8787,8788,"","",0,0,0,0,0,0,0,0,1,"carrierGallenteArmor&ShieldTransferRange3",1,1,1,0,0,"None",0,0,0,0,902569);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2390,"carrierMinmatarArmor&ShieldTransferRange3",0,8793,8794,"","",0,0,0,0,0,0,0,0,1,"carrierMinmatarArmor&ShieldTransferRange3",1,1,1,0,0,"None",0,0,0,0,902572);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2392,"iceHarvesterMiningAmountBonusMultiplier",0,8800,8801,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"iceHarvesterMiningAmountBonusMultiplier",1,1,1,0,0,"None",0,0,0,0,902575);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2393,"titanJumpPortalCpuNeedBonus",0,8806,8807,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"titanJumpPortalCpuNeedBonus",1,1,1,0,0,"None",0,0,0,0,902578);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2394,"titanAmarrJudgmentCpuNeedBonus",0,8812,8813,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"titanAmarrJudgmentCpuNeedBonus",1,1,1,0,0,"None",0,0,0,0,902581);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2395,"jumpPortalConsumptionBonusSkill",0,8816,8817,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"jumpPortalConsumptionBonusSkill",1,1,1,0,0,"None",0,0,0,0,902584);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2402,"skillSuperWeaponDmgBonus",0,8840,8841,"","",0,0,0,0,0,0,0,0,1,"skillSuperWeaponDmgBonus",1,1,1,0,0,"None",0,0,0,0,902587);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2403,"dreadnoughtSiegeModeCpuNeedBonus",0,8844,8845,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"dreadnoughtSiegeModeCpuNeedBonus",1,1,1,0,0,"None",0,0,0,0,902590);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2406,"carrierFighterControlRangeBonus",0,8855,8856,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"carrierFighterControlRangeBonus",1,1,1,0,0,"None",0,0,0,0,902593);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2407,"interdictorBubbleProbeLauncherCpuBonus",0,8859,8860,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"interdictorBubbleProbeLauncherCpuBonus",1,1,1,0,0,"None",0,0,0,0,902596);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2408,"eliteBonusCommandShipMissileKineticDamageCS1",0,8861,8862,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusCommandShipMissileKineticDamageCS1",1,1,1,0,0,"None",0,0,0,0,902599);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2409,"eliteBonusInterdictorsMissileEMDamage1",0,8863,8864,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusInterdictorsMissileEMDamage1",1,1,1,0,0,"None",0,0,0,0,902602);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2410,"cloneVatMaxJumpCloneBonusSkill",0,8869,8870,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"cloneVatMaxJumpCloneBonusSkill",1,1,1,0,0,"None",0,0,0,0,902605);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2411,"cloneVatMaxJumpCloneBonusSkillLevel",0,8873,8874,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"cloneVatMaxJumpCloneBonusSkillLevel",1,1,1,0,0,"None",0,0,0,0,902608);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2412,"cloneVatCpuNeedBonus",0,8879,8880,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"cloneVatCpuNeedBonus",1,1,1,0,0,"None",0,0,0,0,902611);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2413,"snowBallLaunching",2,114,89,"Launches a missile","effects.MissileDeployment",0,0,0,0,0,0,0,0,1,"snowBallLaunching",1,1,1,0,0,"None",0,0,0,0,902614);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2415,"gangShieldBoosterAndTransporterSpeed",1,8885,8886,"","",0,0,0,73,0,6,0,0,1,"gangShieldBoosterAndTransporterSpeed",1,1,1,0,0,"None",0,0,0,0,902617);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2418,"gangShieldBoosteAndTransporterCapacitorNeed",1,8893,8894,"","",0,0,0,73,0,6,0,0,1,"gangShieldBoosteAndTransporterCapacitorNeed",1,1,1,0,0,"None",0,0,0,0,902620);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2419,"titanCaldariOblivionCpuNeed",0,8899,8900,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"titanCaldariOblivionCpuNeed",1,1,1,0,0,"None",0,0,0,0,902623);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2420,"titanGallenteAuroraOminaeCpuNeed",0,8905,8906,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"titanGallenteAuroraOminaeCpuNeed",1,1,1,0,0,"None",0,0,0,0,902626);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2421,"titanMinmatarFirestormCpuNeed",0,8911,8912,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"titanMinmatarFirestormCpuNeed",1,1,1,0,0,"None",0,0,0,0,902629);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2422,"implantVelocityBonus",0,8917,8918,"Automatically generated effect","",0,0,1,0,0,0,0,0,0,"Max Velocity Bonus",1,1,1,0,0,"None",0,0,0,0,902632);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2423,"eliteReconHeavyMissileKineticDamage1",0,8921,8922,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteReconHeavyMissileKineticDamage1",1,1,1,0,0,"None",0,0,0,0,902635);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2424,"eliteReconLightMissileKineticDamage1",0,8925,8926,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteReconLightMissileKineticDamage1",1,1,1,0,0,"None",0,0,0,0,902638);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2426,"skillInterdictorEliteBonus1SkillLevel",0,8935,8936,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"skillInterdictorEliteBonus1SkillLevel",1,1,1,0,0,"None",0,0,0,0,902641);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2427,"skillInterdictorEliteBonus2SkillLevel",0,8939,8940,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"skillInterdictorEliteBonus2SkillLevel",1,1,1,0,0,"None",0,0,0,0,902644);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2429,"advancedDroneInterfacingMaxGroupDCUSkillLevel",0,8947,8948,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"advancedDroneInterfacingMaxGroupDCUSkillLevel",1,1,1,0,0,"None",0,0,0,0,902647);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2430,"maxVelocityMultiplier",0,8949,8950,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"maxVelocityMultiplier",1,1,1,0,0,"None",0,0,0,0,902650);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2431,"energyManagementSkillBoostCapacitorCapacityBonus",0,8959,8960,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"energyManagementSkillBoostCapacitorCapacityBonus",1,1,1,0,0,"None",0,0,0,0,902653);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2432,"energyManagementCapacitorBonusPostPercentCapacityLocationShipGroupCapacitorCapacityBonus",0,8961,8962,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"energyManagementCapacitorBonusPostPercentCapacityLocationShipGroupCapacitorCapacityBonus",1,1,1,0,0,"None",0,0,0,0,902656);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2434,"fightersDmgBonusSkills",0,8963,8964,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"fightersDmgBonusSkills",1,1,1,0,0,"None",0,0,0,0,902659);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2435,"cpuPenaltyToSuperWeapons",0,8972,8973,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"cpuPenaltyToSuperWeapons",1,1,1,0,0,"None",0,0,0,0,902662);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2436,"cpuBonusToSelf",0,8974,8975,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"cpuBonusToSelf",1,1,1,0,0,"None",0,0,0,0,902665);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2437,"miningYieldGangBonusFixed",0,8976,8977,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"miningYieldGangBonusFixed",1,1,1,0,0,"None",0,0,0,0,902668);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2441,"gangIceHarvestingDurationBonus",1,8984,8985,"Automatically generated effect","",0,0,0,73,0,6,0,0,0,"gangIceHarvestingDurationBonus",1,1,1,0,0,"None",0,0,0,0,902671);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2444,"minerCpuUsageMultiplyPercent2",0,8996,8997,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"minerCpuUsageMultiplyPercent2",1,1,1,0,0,"None",0,0,0,0,902674);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2445,"iceMinerCpuUsagePercent",4,8998,8999,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"iceMinerCpuUsagePercent",1,1,1,0,0,"None",0,0,0,0,902677);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2449,"eliteeliteBonusCommandShipDroneBay1",0,9006,9007,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteeliteBonusCommandShipDroneBay1",1,1,1,0,0,"None",0,0,0,0,902680);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2451,"commandShipSkillMultiplier1",0,9016,9017,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"commandShipSkillMultiplier1",1,1,1,0,0,"None",0,0,0,0,902683);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2452,"commandShipSkillMultiplier2",0,9019,9020,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"commandShipSkillMultiplier2",1,1,1,0,0,"None",0,0,0,0,902686);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2453,"eliteBonusCommandShipLaserOptimalCS1FIXED",0,9021,9022,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusCommandShipLaserOptimalCS1FIXED",1,1,1,0,0,"None",0,0,0,0,902689);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2454,"shipBonusMiningDroneAmountPercentGC2",0,9023,9024,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipBonusMiningDroneAmountPercentGC2",1,1,1,0,0,"None",0,0,0,0,902692);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2455,"vanHelsing",1,9025,9026,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"Van Helsing",1,1,1,0,0,"None",0,0,0,0,902695);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2456,"miningUpgradeCPUPenaltyReductionModulesRequiringMiningUpgradePercent",0,9029,9030,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"miningUpgradeCPUPenaltyReductionModulesRequiringMiningUpgradePercent",1,1,1,0,0,"None",0,0,0,0,902698);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2458,"gangMiningDroneYieldBonus",1,9035,9036,"Automatically generated effect","",0,0,0,73,0,6,0,0,0,"gangMiningDroneYieldBonus",1,1,1,0,0,"None",0,0,0,0,902701);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2465,"shipBonusArmorResistAB",0,9049,9050,"","",0,0,0,0,0,0,0,0,1,"shipBonusArmorResistAB",1,1,1,0,0,"None",0,0,0,0,902704);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2467,"shipLaserDamageBonusBC2",0,9053,9054,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipLaserDamageBonusBC2",1,1,1,0,0,"None",0,0,0,0,902707);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2468,"shipHeavyLauncherROFBC1",0,9055,9056,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipHeavyLauncherROFBC1",1,1,1,0,0,"None",0,0,0,0,902710);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2469,"shipAssaultLauncherROFBC1",0,9057,9058,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipAssaultLauncherROFBC1",1,1,1,0,0,"None",0,0,0,0,902713);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2473,"shipBonusDroneDamageMultiplierBC1",0,9071,9072,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipBonusDroneDamageMultiplierBC1",1,1,1,0,0,"None",0,0,0,0,902716);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2478,"shipBonusDroneHitpointsBC1",0,9081,9082,"","",0,0,0,0,0,0,0,0,1,"shipBonusDroneHitpointsBC1",1,1,1,0,0,"None",0,0,0,0,902719);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2479,"iceHarvestCycleTimeModulesRequiringIceHarvestingOnline",4,5165,5166,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"iceHarvestCycleTimeModulesRequiringIceHarvestingOnline",1,1,1,0,0,"None",0,0,0,0,902722);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2480,"decreaseTargetSpeedForStructures",2,3489,3491,"","effects.ModifyTargetSpeed",0,0,1,73,0,6,54,0,1,"Decrease Target Speed",1,1,1,0,0,"None",0,0,0,0,902725);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2481,"warpScrambleForStructure",2,294,295,"Attempts to prevent the target from warping.","effects.WarpScramble",0,1,1,505,0,6,103,0,1,"Warp Scramble",1,1,1,0,0,"None",504,0,0,0,902728);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2485,"implantArmorHpBonus2",0,9093,9094,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"implantArmorHpBonus2",1,1,1,0,0,"None",0,0,0,0,902731);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2486,"armorTankingGang2",0,9095,9096,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"armorTankingGang2",1,1,1,0,0,"None",0,0,0,0,902734);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2487,"skirmishWarfareVelocityBonus2",0,9099,9100,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"skirmishWarfareVelocityBonus2",1,1,1,0,0,"None",0,0,0,0,902737);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2488,"implantVelocityBonus2",0,9101,9102,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"implantVelocityBonus2",1,1,1,0,0,"None",0,0,0,0,902740);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2489,"shipTrackingLinkRange1Fixed",0,9103,9104,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipTrackinshipTrackingLinkRange1FixedgLinkRange1",1,1,1,0,0,"None",0,0,0,0,902743);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2490,"shipTrackingLinkRange2Group",0,9105,9106,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipTrackingLinkRange2Group",1,1,1,0,0,"None",0,0,0,0,902746);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2491,"ewSkillEcmBurstRangeBonus",0,9112,9113,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"ewSkillEcmBurstRangeBonus",1,1,1,0,0,"None",0,0,0,0,902749);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2492,"ewSkillEcmBurstCapNeedBonus",0,9116,9117,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"ewSkillEcmBurstCapNeedBonus",1,1,1,0,0,"None",0,0,0,0,902752);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2494,"eliteBonusCommandShipsMissilePrecisionCS2",0,9122,9123,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteBonusCommandShipsMissilePrecisionCS2",1,1,1,0,0,"None",0,0,0,0,902755);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2496,"eliteReconBonusHeavyLauncherROF1",0,8509,8510,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"eliteReconBonusHeavyLauncherROF1",1,1,1,0,0,"None",0,0,0,0,902758);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2502,"shipLauncherRofBonusMB1",0,9139,9140,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipLauncherRofBonusMB1",1,1,1,0,0,"None",0,0,0,0,902761);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2503,"shipHTTrackingBonusGB2",0,9143,9144,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipHTTrackingBonusGB2",1,1,1,0,0,"None",0,0,0,0,902764);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2504,"shipBonusHybridTrackingGF2",0,4766,4767,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"shipBonusHybridTrackingGF2",1,1,1,0,0,"None",0,0,0,0,902767);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2507,"droneControlUnitCpuNeedBonus",0,9151,9152,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"droneControlUnitCpuNeedBonus",1,1,1,0,0,"None",0,0,0,0,902770);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2508,"gangMiningLaserDurationBonus",1,9155,9156,"Automatically generated effect","",0,0,0,73,0,6,0,0,0,"gangMiningLaserDurationBonus",1,1,1,0,0,"None",0,0,0,0,902773);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2523,"armorRepairAmountBonusPassive",0,9164,9165,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"armorRepairAmountBonusPassive",1,1,1,0,0,"None",0,0,0,0,902776);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2524,"hybridTurretTrackingBonusPassiveTrackingSpeedMultiplier",0,9168,9169,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,902779);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2525,"shipBonusShieldBoosterMB1",0,9173,9174,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,902782);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2537,"shieldCapacityPenaltyPostPercentBoosterAttribute1",0,9224,9225,"Automatically generated effect","None",1400,0,1,0,0,0,0,0,0,"Shield Capacity Penalty",1,1,0,0,0,"None",0,0,1089,1400,902785);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2540,"capacitorCapacityPenaltyBoosterAttribute2",0,9234,9235,"Automatically generated effect","None",1400,0,1,0,0,0,0,0,0,"Capacitor Capacity Penalty",1,1,0,0,0,"None",0,0,1090,1400,902788);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2543,"turretOptimalRangePenaltyBoosterAttribute4",0,9244,9245,"Automatically generated effect","None",1391,0,1,0,0,0,0,0,0,"Turret Optimal Range Penalty",1,1,0,0,0,"None",0,0,1092,1391,902791);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2546,"explosionVelocityPenaltyBoosterAttribute5",0,9254,9255,"Automatically generated effect","None",1389,0,1,0,0,0,0,0,0,"Missile Explosion Velocity Penalty",1,1,0,0,0,"None",0,0,1093,1389,902794);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2549,"shieldBoostAmpPenaltyBoosterAttribute1",0,9262,9263,"Automatically generated effect","None",2104,0,1,0,0,0,0,0,0,"Shield Booster Penalty",1,1,0,0,0,"None",0,0,1089,2104,902797);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2552,"maximumVelocityPenaltyBoosterAttribute2",0,9270,9271,"Automatically generated effect","None",1389,0,1,0,0,0,0,0,0,"Maximum Velocity Penalty",1,1,0,0,0,"None",0,0,1090,1389,902800);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2555,"armorHpPenaltyBoosterAttribute3",0,9280,9281,"Automatically generated effect","None",1383,0,1,0,0,0,0,0,0,"Armor Hitpoint Penalty",1,1,0,0,0,"None",0,0,1091,1383,902803);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2558,"missileVelocityPenaltyBoosterAttribute5",0,9290,9291,"Automatically generated effect","None",1389,0,1,0,0,0,0,0,0,"Missile Velocity Penalty",1,1,0,0,0,"None",0,0,1093,1389,902806);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2561,"eliteBonusAssaultShipMissileVelocity1",0,9300,9301,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"eliteBonusAssaultShipMissileVelocity1",1,1,1,0,0,"None",0,0,0,0,902809);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2565,"turretFalloffPenaltyBoosterAttribute4",0,9314,9315,"Automatically generated effect","None",1399,0,1,0,0,0,0,0,0,"Turret Falloff Penalty",1,1,0,0,0,"None",0,0,1092,1399,902812);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2568,"turretTrackingPenaltyBoosterAttribute4",0,9324,9325,"Automatically generated effect","None",1398,0,1,0,0,0,0,0,0,"Turret Tracking Penalty",1,1,0,0,0,"None",0,0,1092,1398,902815);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2571,"aoeCloudSizePenaltyBoosterAttribute5",0,9334,9335,"Automatically generated effect","None",1390,0,1,0,0,0,0,0,0,"Missile Cloud Size Penalty",1,1,0,0,0,"None",0,0,1093,1390,902818);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2576,"torpedoLaunchingIsOffensive",1,114,131,"","effects.TorpedoDeployment",0,0,1,0,0,0,0,0,1,"torpedoLaunching",1,1,1,0,0,"None",0,0,0,0,902821);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2577,"armorRepairerPenaltyBoosterAttribute3",0,9302,9303,"Automatically generated effect","None",80,0,1,0,0,0,0,0,0,"Armor Repair Penalty",1,1,0,0,0,"None",0,0,1091,80,902824);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2580,"neurotoxinRecoverySkillBoostChanceBonus",0,9373,9374,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"neurotoxinRecoverySkillBoostChanceModifier",1,1,1,0,0,"None",0,0,0,0,902827);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2589,"modifyBoosterEffectChanceWithBoosterChanceBonusPostPercent",0,9403,9404,"","",0,0,0,0,0,0,0,0,1,"modifyBoosterEffectChanceWithBoosterChanceBonusPostPercent",1,1,1,0,0,"None",0,0,0,0,902830);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2590,"naniteControlSkillBoostBoosterAttributeModifier",0,9409,9410,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"naniteControlSkillBoostBoosterAttributeModifier",1,1,1,0,0,"None",0,0,0,0,902833);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2599,"modifyBoosterAttributePostPercent",0,9437,9438,"","",0,0,0,0,0,0,0,0,1,"modifyBoosterAttributePostPercent",1,1,1,0,0,"None",0,0,0,0,902836);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2600,"shieldBoostAmplifierPassiveLocationGroup",0,9439,9440,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"shieldBoostAmplifierPassiveLocationGroup",1,1,1,0,0,"None",0,0,0,0,902839);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2602,"shipBonusEmShieldResistanceCB2",0,9450,9451,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"shipBonusEmShieldResistanceCB2",1,1,1,0,0,"None",0,0,0,0,902842);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2603,"shipBonusExplosiveShieldResistanceCB2",0,9452,9453,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"shipBonusExplosiveShieldResistanceCB2",1,1,1,0,0,"None",0,0,0,0,902845);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2604,"shipBonusKineticShieldResistanceCB2",0,9454,9455,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"shipBonusKineticShieldResistanceCB2",1,1,1,0,0,"None",0,0,0,0,902848);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2605,"shipBonusThermicShieldResistanceCB2",0,9456,9457,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"shipBonusThermicShieldResistanceCB2",1,1,1,0,0,"None",0,0,0,0,902851);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2606,"scanGravimetricStrengthBonus",4,9459,9460,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,902854);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2607,"scanRadarStrengthBonusPercentageScanStrengthBonus",4,9461,9462,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"scanRadarStrengthBonusPercentageScanStrengthBonus",1,1,1,0,0,"None",0,0,0,0,902857);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2608,"scanLadarStrengthBonusPercentageScanStrengthBonus",4,9463,9464,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"scanLadarStrengthBonusPercentageScanStrengthBonus",1,1,1,0,0,"None",0,0,0,0,902860);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2609,"scanMagnetometricStrengthBonusPercentageScanStrengthBonus",4,9465,9466,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"scanMagnetometricStrengthBonusPercentageScanStrengthBonus",1,1,1,0,0,"None",0,0,0,0,902863);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2611,"eliteBonusGunshipProjectileDamage1",0,9467,9468,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"eliteBonusGunshipProjectileDamage1",1,1,1,0,0,"None",0,0,0,0,902866);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2612,"eliteBonusGunshipProjectileDamage2",0,9469,9470,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"eliteBonusGunshipProjectileDamage2",1,1,1,0,0,"None",0,0,0,0,902869);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2613,"eliteBonusGunshipLaserDamage1",0,9471,9472,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"eliteBonusGunshipLaserDamage1",1,1,1,0,0,"None",0,0,0,0,902872);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2641,"gangInformationWarStrengthBonus",1,9559,9560,"","",0,0,0,73,0,6,0,0,1,"gangInformationWarStrengthBonus",1,1,1,0,0,"None",0,0,0,0,902875);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2642,"gangInformationWarfareRangeBonus",1,9561,9562,"","",0,0,0,73,0,6,0,0,1,"gangInformationWarfareRangeBonus",1,1,1,0,0,"None",0,0,0,0,902878);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2643,"massReductionBonus",4,9566,9567,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"massReductionBonus",1,1,1,0,0,"None",0,0,0,0,902881);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2644,"increaseSignatureRadiusOnline",4,3277,3278,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"increaseSignatureRadiusOnline",1,1,1,0,0,"None",0,0,0,0,902884);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2645,"scanResolutionMultiplierOnline",4,3935,3408,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"scanResolutionMultiplierOnline",1,1,1,0,0,"None",0,0,0,0,902887);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2646,"maxTargetRangeBonus",4,2692,2693,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"maxTargetRangeBonus",1,1,1,0,0,"None",0,0,0,0,902890);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2647,"eliteBonusHeavyGunshipHeavyMissileLaunhcerRof2",0,9570,9571,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"eliteBonusHeavyGunshipHeavyMissileLaunhcerRof2",1,1,1,0,0,"None",0,0,0,0,902893);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2648,"eliteBonusHeavyGunshipHeavyAssaultMissileLaunhcerRof2",0,9576,9577,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"eliteBonusHeavyGunshipHeavyAssaultMissileLaunhcerRof2",1,1,1,0,0,"None",0,0,0,0,902896);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2649,"eliteBonusHeavyGunshipAssaultMissileLaunhcerRof2",0,9578,9579,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"eliteBonusHeavyGunshipAssaultMissileLaunhcerRof2",1,1,1,0,0,"None",0,0,0,0,902899);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2653,"missileProjectionComputerBonus",1,9580,9581,"","",0,0,0,73,0,6,0,0,1,"missileProjectionComputerBonus",1,1,1,0,0,"None",0,0,0,0,902902);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2654,"skillAstrometricsMaxGroupScanningBonusSkillLevel",0,9584,9585,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"skillAstrometricsMaxGroupScanningBonusSkillLevel",1,1,1,0,0,"None",0,0,0,0,902905);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2656,"scanStrengthBonusSkillLevelIncrease",0,9590,9591,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"scanStrengthBonusSkillLevelIncrease",1,1,1,0,0,"None",0,0,0,0,902908);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2657,"scanGravimetricStrengthBonusRequringAstrometrics",0,9595,9596,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"scanGravimetricStrengthBonusRequringAstrometrics",1,1,1,0,0,"None",0,0,0,0,902911);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2658,"scanProbeSpeedBonusRequiringAstrometrics",0,9599,9600,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"scanProbeSpeedBonusRequiringAstrometrics",1,1,1,0,0,"None",0,0,0,0,902914);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2659,"scanMagnetometricStrengthBonusRequringAstrometrics",0,9603,9604,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"scanMagnetometricStrengthBonusRequringAstrometrics",1,1,1,0,0,"None",0,0,0,0,902917);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2660,"scanLadarStrengthBonusRequringAstrometrics",0,9607,9608,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"scanLadarStrengthBonusRequringAstrometrics",1,1,1,0,0,"None",0,0,0,0,902920);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2661,"scanRadarStrengthBonusRequringAstrometrics",0,9611,9612,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"scanRadarStrengthBonusRequringAstrometrics",1,1,1,0,0,"None",0,0,0,0,902923);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2662,"entityEnvironmentalEffectDamageTest",1,288,131,"Triggering of an EMP wave being broadcast into space.","effects.EMPWave",0,1,0,73,0,0,99,0,1,"entityEnvironmentalEffectDamageTest",1,1,1,0,0,"None",0,930,0,0,902926);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2663,"rigSlot",0,131,131,"Must be installed into an available rig slot on a ship.","",3266,0,1,0,0,0,0,0,0,"Rig Slot",1,1,1,0,0,"None",0,0,0,3266,902929);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2664,"ewCapNeedPercentageModifier",4,5695,5696,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"ewCapNeedPercentageModifier",1,1,1,0,0,"None",0,0,0,0,902932);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2670,"sensorBoosterActivePercentage",1,9629,9630,"","effects.ElectronicAttributeModifyActivate",0,0,1,73,0,6,0,0,1,"sensorBoosterActivePercentage",1,1,1,0,0,"None",0,0,0,0,902935);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2671,"maxTargetRangePremulModifier",0,9633,9634,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"maxTargetRangePremulModifier",1,1,1,0,0,"None",0,0,0,0,902938);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2672,"scanResolutionPremulModifier",0,9637,9638,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"scanResolutionPremulModifier",1,1,1,0,0,"None",0,0,0,0,902941);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2674,"shipBonusProjectileDamageBC1",0,9641,9642,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"shipBonusProjectileDamageBC1",1,1,1,0,0,"None",0,0,0,0,902944);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2675,"shipHeavyAssaultLaunhcerROFBC1",0,9643,9644,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"shipHeavyAssaultLaunhcerROFBC1",1,1,1,0,0,"None",0,0,0,0,902947);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2682,"shipCruiserSizedLauncherROFBC1",0,9664,9665,"","",0,0,0,0,0,0,0,0,1,"shipCruiserSizedLauncherROFBC1",1,1,1,0,0,"None",0,0,0,0,902950);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2683,"addMedSlot",4,9667,9668,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"addMedSlot",1,1,1,0,0,"None",0,0,0,0,902953);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2687,"shipBonusArmorRepairAmountGB2",0,9671,9672,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"shipBonusArmorRepairAmountGB2",1,1,1,0,0,"None",0,0,0,0,902956);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2688,"capNeedBonusEffectLasers",0,9675,9676,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"Capacitor Need Bonus",1,1,1,0,0,"None",0,0,0,0,902959);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2689,"capNeedBonusEffectHybrids",0,9679,9680,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"capNeedBonusEffectHybrids",1,1,1,0,0,"None",0,0,0,0,902962);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2690,"cpuNeedBonusEffectLasers",0,9683,9684,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"cpuNeedBonusEffectLasers",1,1,1,0,0,"None",0,0,0,0,902965);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2691,"cpuNeedBonusEffectHybrid",0,9687,9688,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"cpuNeedBonusEffectHybrid",1,1,1,0,0,"None",0,0,0,0,902968);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2692,"cpuNeedBonusEffectProjectile",0,9691,9692,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"cpuNeedBonusEffectProjectile",1,1,1,0,0,"None",0,0,0,0,902971);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2693,"falloffBonusEffectLasers",0,9695,9696,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"falloffBonusEffectLasers",1,1,1,0,0,"None",0,0,0,0,902974);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2694,"falloffBonusEffectHybrids",0,9699,9700,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"falloffBonusEffectHybrids",1,1,1,0,0,"None",0,0,0,0,902977);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2695,"falloffBonusEffectProjectiles",0,9703,9704,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"falloffBonusEffectProjectiles",1,1,1,0,0,"None",0,0,0,0,902980);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2696,"maxRangeBonusEffectLasers",0,2972,2973,"Automatically generated effect","None",0,0,0,0,0,0,0,0,1,"maxRangeBonusEffectLasers",1,1,1,0,0,"None",0,0,0,0,2724503);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2697,"maxRangeBonusEffectHybrids",0,9705,9706,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"maxRangeBonusEffectHybrids",1,1,1,0,0,"None",0,0,0,0,902986);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2698,"maxRangeBonusEffectProjectiles",0,9707,9708,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"maxRangeBonusEffectProjectiles",1,1,1,0,0,"None",0,0,0,0,902989);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2699,"trackingSpeedMultiplierEffectLasers",0,9709,9710,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"trackingSpeedMultiplierEffectLasers",1,1,1,0,0,"None",0,0,0,0,902992);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2700,"trackingSpeedMultiplierEffectHybrids",0,9712,9713,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"trackingSpeedMultiplierEffectHybrids",1,1,1,0,0,"None",0,0,0,0,902995);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2701,"trackingSpeedMultiplierEffectProjectiles",0,9716,9717,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"trackingSpeedMultiplierEffectProjectiles",1,1,1,0,0,"None",0,0,0,0,902998);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2702,"salvagingAccessDifficultyBonusEffect",4,9722,9723,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"salvagingAccessDifficultyBonusEffect",1,1,1,0,0,"None",0,0,0,0,903001);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2706,"drawbackPowerNeedLasers",0,9738,9739,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"drawbackPowerNeedLasers",1,1,1,0,0,"None",0,0,0,0,903004);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2707,"drawbackPowerNeedHybrids",0,9740,9741,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"drawbackPowerNeedHybrids",1,1,1,0,0,"None",0,0,0,0,903007);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2708,"drawbackPowerNeedProjectiles",0,9742,9743,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"drawbackPowerNeedProjectiles",1,1,1,0,0,"None",0,0,0,0,903010);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2709,"drawbackPowerNeedLaunchers",0,9744,9745,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"drawbackPowerNeedLaunchers",1,1,1,0,0,"None",0,0,0,0,903013);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2710,"drawbackPowerNeedGunnery",0,9746,9747,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"drawbackPowerNeedGunnery",1,1,1,0,0,"None",0,0,0,0,903016);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2712,"drawbackArmorHP",0,9748,9749,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"drawbackArmorHP",1,1,1,0,0,"None",0,0,0,0,903019);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2713,"drawbackCPUOutput",0,9751,9752,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"drawbackCPUOutput",1,1,1,0,0,"None",0,0,0,0,903022);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2714,"drawbackCPUNeedLaunchers",0,9753,9754,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"drawbackCPUNeedLaunchers",1,1,1,0,0,"None",0,0,0,0,903025);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2715,"drawbackCPUNeedGunnery",0,9755,9756,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"drawbackCPUNeedGunnery",1,1,1,0,0,"None",0,0,0,0,903028);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2716,"drawbackSigRad",0,9757,9758,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"drawbackSigRad",1,1,1,0,0,"None",0,0,0,0,903031);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2717,"drawbackMaxVelocity",0,9759,9760,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"drawbackMaxVelocity",1,1,1,0,0,"None",0,0,0,0,903034);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2718,"drawbackShieldCapacity",0,9761,9762,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"drawbackShieldCapacity",1,1,1,0,0,"None",0,0,0,0,903037);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2719,"drawbackShieldUniformity",0,9766,9767,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"drawbackShieldUniformity",1,1,1,0,0,"None",0,0,0,0,903040);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2720,"drawbackCapacitorCapacity",0,9768,9769,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"drawbackCapacitorCapacity",1,1,1,0,0,"None",0,0,0,0,903043);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2721,"drawbackPowerOutput",0,9771,9772,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"drawbackPowerOutput",1,1,1,0,0,"None",0,0,0,0,903046);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2722,"drawbackROFGunnery",0,9773,9774,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"drawbackROFGunnery",1,1,1,0,0,"None",0,0,0,0,903049);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2723,"drawbackROFLaunchers",0,9775,9776,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"drawbackROFLaunchers",1,1,1,0,0,"None",0,0,0,0,903052);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2724,"rigDrawbackBonusEffect",0,9781,9782,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"rigDrawbackBonusEffect",1,1,1,0,0,"None",0,0,0,0,903055);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2725,"rigDrawbackSkillEffect",0,9791,9792,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"rigDrawbackSkillEffect",1,1,1,0,0,"None",0,0,0,0,903058);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2726,"miningClouds",2,3134,184,"Mining of ore.","effects.CloudMining",0,1,0,73,0,6,54,0,1,"miningClouds",1,1,1,0,0,"None",0,0,0,0,903061);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2727,"gasCloudHarvestingMaxGroupSkillLevel",0,9795,9796,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"gasCloudHarvestingMaxGroupSkillLevel",1,1,1,0,0,"None",0,0,0,0,903064);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2734,"shipECMScanStrengthBonusCF",0,9809,9810,"","",0,0,0,0,0,0,0,0,1,"shipECMScanStrengthBonusCF",1,1,1,0,0,"None",0,0,0,0,903067);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2735,"boosterArmorHpPenalty",0,9823,9824,"Automatically generated effect","None",1383,0,1,0,0,0,0,0,0,"Armor Hitpoint Penalty",1,1,0,0,0,"None",0,0,1091,1383,903070);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2736,"boosterArmorRepairAmountPenalty",0,9825,9826,"Automatically generated effect","None",80,0,1,0,0,0,0,0,0,"Armor Repairer Penalty",1,1,0,0,0,"None",0,0,1091,80,903073);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2737,"boosterShieldCapacityPenalty",0,9827,9828,"Automatically generated effect","None",1384,0,1,0,0,0,0,0,0,"Shield Capacity Penalty",1,1,0,0,0,"None",0,0,1089,1384,903076);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2738,"boosterShieldBoostAmountPenalty",0,9829,9830,"Automatically generated effect","None",1384,0,1,0,0,0,0,0,0,"Shield Booster Penalty",1,1,0,0,0,"None",0,0,1089,1384,903079);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2739,"boosterTurretOptimalRangePenalty",0,9831,9832,"Automatically generated effect","None",1391,0,1,0,0,0,0,0,0,"Turret Optimal Range",1,1,0,0,0,"None",0,0,1092,1391,903082);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2741,"boosterTurretFalloffPenalty",0,9835,9836,"Automatically generated effect","None",1399,0,1,0,0,0,0,0,0,"Turret Falloff Penalty",1,1,0,0,0,"None",0,0,1093,1399,903085);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2743,"boosterMissileExplosionCloudPenalty",0,9839,9840,"Automatically generated effect","None",1390,0,1,0,0,0,0,0,0,"Missile Explosion Cloud Penalty",1,1,0,0,0,"None",0,0,1093,1390,903088);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2745,"boosterCapacitorCapacityPenalty",0,9845,9846,"Automatically generated effect","None",1400,0,1,0,0,0,0,0,0,"Capacitor Capacity Penalty",1,1,0,0,0,"None",0,0,1090,1400,903091);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2746,"boosterMaxVelocityPenalty",0,9847,9848,"Automatically generated effect","None",1389,0,1,0,0,0,0,0,0,"Max Velocity Penalty",1,1,0,0,0,"None",0,0,1090,1389,903094);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2747,"boosterTurretTrackingPenalty",0,9849,9850,"Automatically generated effect","None",1398,0,1,0,0,0,0,0,0,"Turret Tracking Penalty",1,1,0,0,0,"None",0,0,1092,1398,903097);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2748,"boosterMissileVelocityPenalty",0,9851,9852,"Automatically generated effect","None",1389,0,1,0,0,0,0,0,0,"Missile Velocity Penalty",1,1,0,0,0,"None",0,0,1093,1389,903100);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2749,"boosterMissileExplosionVelocityPenalty",0,9853,9854,"Automatically generated effect","None",1389,0,1,0,0,0,0,0,0,"Explosion Velocity Penalty",1,1,0,0,0,"None",0,0,1093,1389,903103);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2750,"shipBonusECMGravimetricStrengthBonusCC",0,9855,9856,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"shipBonusECMGravimetricStrengthBonusCC",1,1,1,0,0,"None",0,0,0,0,903106);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2751,"shipBonusECMMagnetometricStrengthBonusCC",0,9857,9858,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"shipBonusECMMagnetometricStrengthBonusCC",1,1,1,0,0,"None",0,0,0,0,903109);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2752,"shipBonusECMRadarBonusCC",0,9859,9860,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"shipBonusECMRadarBonusCC",1,1,1,0,0,"None",0,0,0,0,903112);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2753,"shipBonusECMLadarBonusCC",0,9861,9862,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"shipBonusECMLadarBonusCC",1,1,1,0,0,"None",0,0,0,0,903115);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2754,"shipBonusECMRadarLadarBonusCC",0,9863,9864,"","",0,0,0,0,0,0,0,0,1,"shipBonusECMRadarLadarBonusCC",1,1,1,0,0,"None",0,0,0,0,903118);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2755,"shipBonusECMGraviMagnetoMetricBonusCC",0,9865,9866,"","",0,0,0,0,0,0,0,0,1,"shipBonusECMGraviMagnetoMetricBonusCC",1,1,1,0,0,"None",0,0,0,0,903121);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2756,"shipBonusECMStrengthBonusCC",0,9867,9868,"","",0,0,0,0,0,0,0,0,1,"shipBonusECMStrengthBonusCC",1,1,1,0,0,"None",0,0,0,0,903124);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2757,"salvaging",2,131,131,"","effects.Salvaging",0,0,0,73,0,6,54,0,1,"salvaging",1,1,1,0,0,"None",0,0,0,0,903127);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2758,"boosterModifyBoosterArmorHPPenalty",0,9874,9875,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"boosterModifyBoosterArmorHPPenalty",1,1,1,0,0,"None",0,0,0,0,903130);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2759,"boosterModifyBoosterArmorRepairAmountPenalty",0,9879,9880,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"boosterModifyBoosterArmorRepairAmountPenalty",1,1,1,0,0,"None",0,0,0,0,903133);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2760,"boosterModifyBoosterArmorPenalties",0,9881,9882,"","",0,0,0,0,0,0,0,0,1,"boosterModifyBoosterArmorPenalties",1,1,1,0,0,"None",0,0,0,0,903136);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2761,"boosterModifyBoosterShieldCapacityPenalty",0,9885,9886,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"boosterModifyBoosterShieldCapacityPenalty",1,1,1,0,0,"None",0,0,0,0,903139);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2762,"boosterModifyBoosterShieldBoostAmountPenalty",0,9889,9890,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"boosterModifyBoosterShieldBoostAmountPenalty",1,1,1,0,0,"None",0,0,0,0,903142);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2763,"boosterModifyBoosterShieldPenalty",0,9891,9892,"","",0,0,0,0,0,0,0,0,1,"boosterModifyBoosterShieldPenalty",1,1,1,0,0,"None",0,0,0,0,903145);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2764,"boosterModifyBoosterCapacitorCapacitorPenalty",0,9895,9896,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"boosterModifyBoosterCapacitorCapacitorPenalty",1,1,1,0,0,"None",0,0,0,0,903148);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2765,"boosterModifyBoosterMaxVelocityPenalty",0,9899,9900,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"boosterModifyBoosterMaxVelocityPenalty",1,1,1,0,0,"None",0,0,0,0,903151);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2766,"boosterModifyBoosterMaxVelocityAndCapacitorPenalty",0,9901,9902,"","",0,0,0,0,0,0,0,0,1,"boosterModifyBoosterMaxVelocityAndCapacitorPenalty",1,1,1,0,0,"None",0,0,0,0,903154);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2767,"boosterModifyBoosterAOEVelocityPenalty",0,9905,9906,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"boosterModifyBoosterAOEVelocityPenalty",1,1,1,0,0,"None",0,0,0,0,903157);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2768,"boosterModifyBoosterMissileAOECloudPenalty",0,9909,9910,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"boosterModifyBoosterAOEVelocityPenalty",1,1,1,0,0,"None",0,0,0,0,903160);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2769,"boosterModifyBoosterMissileVelocity",0,9913,9914,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"boosterModifyBoosterMissileVelocity",1,1,1,0,0,"None",0,0,0,0,903163);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2770,"boosterModifyBoosterTurretFalloffPenalty",0,9917,9918,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"boosterModifyBoosterTurretFalloffPenalty",1,1,1,0,0,"None",0,0,0,0,903166);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2771,"boosterModifyBoosterTurretOptimalPenalty",0,9921,9922,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"boosterModifyBoosterTurretOptimalPenalty",1,1,1,0,0,"None",0,0,0,0,903169);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2772,"boosterModifyBoosterTurretTrackingPenalty",0,9925,9926,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"boosterModifyBoosterTurretTrackingPenalty",1,1,1,0,0,"None",0,0,0,0,903172);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2775,"boosterModifyBoosterMissileAOEPenalty",0,9931,9932,"","",0,0,0,0,0,0,0,0,1,"boosterModifyBoosterMissileAOEPenalty",1,1,1,0,0,"None",0,0,0,0,903175);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2776,"boosterModifyBoosterMissilePenalty",0,9933,9934,"","",0,0,0,0,0,0,0,0,1,"boosterModifyBoosterMissilePenalty",1,1,1,0,0,"None",0,0,0,0,903178);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2777,"boosterModifyBoosterTurretTrackingOptimalPenalty",0,9935,9936,"","",0,0,0,0,0,0,0,0,1,"boosterModifyBoosterTurretTrackingOptimalPenalty",1,1,1,0,0,"None",0,0,0,0,903181);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2778,"boosterModifyBoosterTurretPenalty",0,9937,9938,"","",0,0,0,0,0,0,0,0,1,"boosterModifyBoosterTurretPenalty",1,1,1,0,0,"None",0,0,0,0,903184);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2779,"shipLaserCapABC",0,9939,9940,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"shipLaserCapABC",1,1,1,0,0,"None",0,0,0,0,903187);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2780,"maxVelocityBonusModifier",4,3908,3909,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"maxVelocityBonusModifier",1,1,1,0,0,"None",0,0,0,0,903190);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2783,"shipBonusMiningDroneAmountPercentAC2",0,9941,9942,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"shipBonusMiningDroneAmountPercentAC2",1,1,1,0,0,"None",0,0,0,0,903193);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2784,"bcsEmDamageBonus",4,9944,9945,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"bcuEmDamageBonus",1,1,1,0,0,"None",0,0,0,0,903196);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2785,"bcuExDamageBonus",4,9947,9948,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"bcuExDamageBonus",1,1,1,0,0,"None",0,0,0,0,903199);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2786,"bcuThDamageBonus",4,9950,9951,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"bcuThDamageBonus",1,1,1,0,0,"None",0,0,0,0,903202);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2787,"bcuKnDamageBonus",4,9953,9954,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"bcuKnDamageBonus",1,1,1,0,0,"None",0,0,0,0,903205);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2788,"bcuKnThDamageBonus",4,9955,9956,"","",0,0,0,0,0,0,0,0,1,"bcuKnThDamageBonus",1,1,1,0,0,"None",0,0,0,0,903208);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2789,"bcuEmExDamageBonus",4,9957,9958,"","",0,0,0,0,0,0,0,0,1,"bcuEmExDamageBonus",1,1,1,0,0,"None",0,0,0,0,903211);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2790,"bcuDamageBonus",4,9959,9960,"","",0,0,0,0,0,0,0,0,1,"bcuDamageBonus",1,1,1,0,0,"None",0,0,0,0,903214);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2791,"boosterMissileExplosionCloudPenaltyFixed",0,9963,9964,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"boosterMissileExplosionCloudPenaltyFixed",1,1,1,0,0,"None",0,0,0,0,903217);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2792,"modifyArmorResonancePostPercentPassive",0,7725,7726,"","",0,0,0,0,0,0,0,0,1,"Armor Resonance Modifier",1,1,1,0,0,"None",0,0,0,0,903220);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2794,"salvagingAccessDifficultyBonusEffectPassive",0,9722,9723,"Salvaging Access Difficulty Bonus","None",0,0,0,0,0,0,0,0,0,"Salvaging Access Difficulty Bonus",1,1,1,0,0,"None",0,0,0,0,903223);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2795,"modifyShieldResonancePostPercentPassive",0,7755,7756,"","",0,0,0,0,0,0,0,0,1,"modifyShieldResonancePostPercent",1,1,1,0,0,"None",0,0,0,0,903226);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2796,"massReductionBonusPassive",0,9566,9567,"Mass Reduction Bonus (passive)","None",0,0,0,0,0,0,0,0,0,"Mass Reduction Bonus",1,1,1,0,0,"None",0,0,0,0,903229);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2797,"projectileWeaponSpeedMultiplyPassive",0,654,655,"Scale the projectile weapon firing speed.","",0,0,0,0,0,0,0,0,1,"projectileWeaponSpeedMultiplyPassive",1,1,1,0,0,"None",0,0,0,0,903232);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2798,"projectileWeaponDamageMultiplyPassive",0,667,670,"Scales the damage done by all fitted projectile weapons.","",0,0,0,0,0,0,0,0,1,"projectileWeaponDamageMultiplyPassive",1,1,1,0,0,"None",0,0,0,0,903235);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2799,"missileLauncherSpeedMultiplierPassive",0,4069,4070,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"missileLauncherSpeedMultiplierPassive",1,1,1,0,0,"None",0,0,0,0,903238);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2801,"energyWeaponSpeedMultiplyPassive",0,681,683,"Scales the rate of fire of all fitted energy weapons.","",0,0,0,0,0,0,0,0,1,"Energy Weapon Speed Modifier",1,1,1,0,0,"None",0,0,0,0,903241);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2802,"hybridWeaponDamageMultiplyPassive",0,669,672,"Scales the damage done by all fitted hybrid weapons.","",0,0,0,0,0,0,0,0,1,"hybridWeaponDamageMultiplyPassive",1,1,1,0,0,"None",0,0,0,0,903244);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2803,"energyWeaponDamageMultiplyPassive",0,668,671,"Scales the damage done by all fitted energy weapons.","",0,0,0,0,0,0,0,0,1,"Energy Weapon Damage Modifier",1,1,1,0,0,"None",0,0,0,0,903247);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2804,"hybridWeaponSpeedMultiplyPassive",0,682,684,"Scales the rate of fire of all fitted hybrid weapons.","",0,0,0,0,0,0,0,0,1,"hybridWeaponSpeedMultiplyPassive",1,1,1,0,0,"None",0,0,0,0,903250);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2805,"shipBonusLargeEnergyWeaponDamageAB2",0,9965,9966,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"shipBonusLargeEnergyWeaponDamageAB2",1,1,1,0,0,"None",0,0,0,0,903253);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2806,"maxRangeBonusEffectHybridsMultiplier",0,9968,9969,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"maxRangeBonusEffectHybridsMultiplier",1,1,1,0,0,"None",0,0,0,0,903256);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2807,"maxRangeBonusEffectLasersMultiplier",0,9971,9972,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"maxRangeBonusEffectLasersMultiplier",1,1,1,0,0,"None",0,0,0,0,903259);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2808,"maxRangeBonusEffectProjectilesMultiplier",0,9974,9975,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"maxRangeBonusEffectProjectilesMultiplier",1,1,1,0,0,"None",0,0,0,0,903262);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2809,"shipMissileAssaultMissileVelocityBonusCC2",0,9976,9977,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"shipMissileAssaultMissileVelocityBonusCC2",1,1,1,0,0,"None",0,0,0,0,903265);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2810,"eliteBonusHeavyGunshipAssaultMissileFlightTime1",0,9980,9981,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"eliteBonusHeavyGunshipAssaultMissileFlightTime1",1,1,1,0,0,"None",0,0,0,0,903268);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2811,"cpuPenaltyToScanProbeLaunchers",0,9986,9987,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"cpuPenaltyToScanProbeLaunchers",1,1,1,0,0,"None",0,0,0,0,903271);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2812,"caldariShipECMBurstOptimalRangeCB3",0,9988,9989,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"caldariShipECMBurstOptimalRangeCB3",1,1,1,0,0,"None",0,0,0,0,903274);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2814,"shipBonusSurveyProbeExplosionDelaySkillSurveyCF",0,10000,10001,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"shipBonusSurveyProbeExplosionDelaySkillSurveyCF",1,1,1,0,0,"None",0,0,0,0,903277);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2817,"shipBonusSurveyProbeExplosionDelaySkillSurveyMF2",0,10002,10003,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"shipBonusSurveyProbeExplosionDelaySkillSurveyCF",1,1,1,0,0,"None",0,0,0,0,903280);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2818,"shipBonusSurveyProbeExplosionDelaySkillSurveyGF2",0,10004,10005,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"shipBonusSurveyProbeExplosionDelaySkillSurveyCF",1,1,1,0,0,"None",0,0,0,0,903283);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2819,"shipBonusSurveyProbeExplosionDelaySkillSurveyCovertOps2",0,10006,10007,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"shipBonusSurveyProbeExplosionDelaySkillSurveyCovertOps2",1,1,1,0,0,"None",0,0,0,0,903286);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2820,"maxScanDeviationSelfSkillModifier",0,10012,10013,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"maxScanDeviationSelfSkillModifier",1,1,1,0,0,"None",0,0,0,0,903289);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2821,"maxScanDeviationModifierRequireingAstrometrics",0,10016,10017,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"maxScanDeviationModifierRequireingAstrometrics",1,1,1,0,0,"None",0,0,0,0,903292);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2822,"commandBonus2MultiplyWithCommandBonus",0,10022,10023,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"commandBonus2MultiplyWithCommandBonus",1,1,1,0,0,"None",0,0,0,0,903295);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2823,"gangInformationSensorDisruptorMaxTargetingRangeStrengthBonus",0,10026,10027,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"gangInformationSensorDisruptorMaxTargetingRangeStrengthBonus",1,1,1,0,0,"None",0,0,0,0,903298);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2824,"gangInformationSensorDisruptorScanResStrengthBonus",1,10030,10031,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"gangInformationSensorDisruptorScanResStrengthBonus",1,1,1,0,0,"None",0,0,0,0,903301);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2825,"gangInformationSensorDisruptorTrackingDisruptorTrackingSpeedBonus",1,10034,10035,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"gangInformationSensorDisruptorTrackingDisruptorTrackingSpeedBonus",1,1,1,0,0,"None",0,0,0,0,903304);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2826,"gangInformationSensorDisruptorTrackingDisruptorMaxRangeBonus",1,10038,10039,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"gangInformationSensorDisruptorTrackingDisruptorMaxRangeBonus",1,1,1,0,0,"None",0,0,0,0,903307);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2827,"gangInformationTargetPainterSigRadBonus",1,10042,10043,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"gangInformationTargetPainterSigRadBonus",1,1,1,0,0,"None",0,0,0,0,903310);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2828,"gangInformationSensorDisruptorBonus",0,10044,10045,"","",0,0,0,0,0,0,0,0,1,"gangInformationSensorDisruptorBonus",1,1,1,0,0,"None",0,0,0,0,903313);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2829,"gangInformationTrackingDisruptorBonus",1,10046,10047,"","",0,0,0,0,0,0,0,0,1,"gangInformationTrackingDisruptorBonus",1,1,1,0,0,"None",0,0,0,0,903316);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2830,"gangInformationTrackingSensorDisruptorBonus",0,10048,10049,"","",0,0,0,0,0,0,0,0,1,"gangInformationTrackingSensorDisruptorBonus",1,1,1,0,0,"None",0,0,0,0,903319);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2831,"gangInformationTrackingSensorDisruptorTargetPainterBonus",0,10050,10051,"","",0,0,0,0,0,0,0,0,1,"gangInformationTrackingSensorDisruptorTargetPainterBonus",1,1,1,0,0,"None",0,0,0,0,903322);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2832,"shieldBoosterDurationBonus",0,10054,10055,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"shieldBoosterDurationBonus",1,1,1,0,0,"None",0,0,0,0,903325);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2833,"gangInformationSensorTrackingDisruptorTargetPainter",0,10050,10051,"","",0,0,0,0,0,0,0,0,1,"gangInformationSensorTrackingDisruptorTargetPainter",1,1,1,0,0,"None",0,0,0,0,903328);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2834,"gangInformationAllEWARStrengthBonuses",1,10056,10057,"","",0,0,0,73,0,6,0,0,1,"gangInformationAllEWARStrengthBonuses",1,1,1,0,0,"None",0,0,0,0,903331);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2835,"shipMissileVelocityPirateFactionHeavyAssault",0,10058,10059,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"shipMissileVelocityPirateFactionHeavyAssault",1,1,1,0,0,"None",0,0,0,0,903334);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2836,"eliteBonusInterdictorsInterdictionSphereLauncherReactivationDelay2",0,10064,10065,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"eliteBonusInterdictorsInterdictionSphereLauncherReactivationDelay2",1,1,1,0,0,"None",0,0,0,0,903337);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2837,"armorHPBonusAdd",4,10069,10070,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"armorHPBonusAdd",1,1,1,0,0,"None",0,0,0,0,903340);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2838,"shipShieldEmExplosiveResistanceCBC2",0,10071,10072,"","",0,0,0,0,0,0,0,0,1,"shipShieldEmExplosiveResistanceCBC2",1,1,1,0,0,"None",0,0,0,0,903343);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2839,"shipShieldKineticThermalResistanceCBC2",0,10073,10074,"","",0,0,0,0,0,0,0,0,1,"shipShieldKineticThermalResistanceCBC2",1,1,1,0,0,"None",0,0,0,0,903346);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2840,"shipShieldResistanceCBC2",0,10075,10076,"","",0,0,0,0,0,0,0,0,1,"shipShieldResistanceCBC2",1,1,1,0,0,"None",0,0,0,0,903349);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2841,"shipBonusHeavyMissileKineticDamageBC1",0,10077,10078,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"shipBonusHeavyMissileKineticDamageBC1",1,1,1,0,0,"None",0,0,0,0,903352);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2842,"shipBonusHeavyAssaultMissileKineticDamageBC1",0,10081,10082,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"shipBonusHeavyAssaultMissileKineticDamageBC1",1,1,1,0,0,"None",0,0,0,0,903355);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2843,"shipBonusStandardMissileKineticDamageBC1",0,10083,10084,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"shipBonusStandardMissileKineticDamageBC1",1,1,1,0,0,"None",0,0,0,0,903358);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2844,"shipBonusHeavyAssaultStandardMissileKineticDamageBC1",0,10085,10086,"","",0,0,0,0,0,0,0,0,1,"shipBonusHeavyAssaultStandardMissileKineticDamageBC1",1,1,1,0,0,"None",0,0,0,0,903361);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2845,"shipBonusCruiserSizedMissileKineticDamageBC1",0,10087,10088,"","",0,0,0,0,0,0,0,0,1,"shipBonusCruiserSizedMissileKineticDamageBC1",1,1,1,0,0,"None",0,0,0,0,903364);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2846,"skillBoostTrackingSpeedBonus",0,10091,10092,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"skillBoostTrackingSpeedBonus",1,1,1,0,0,"None",0,0,0,0,903367);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2847,"trackingSpeedBonusPassiveRequiringGunneryTrackingSpeedBonus",0,6248,6249,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"trackingSpeedBonusPassiveRequiringGunneryTrackingSpeedBonus",1,1,1,0,0,"None",0,0,0,0,903370);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2848,"accessDifficultyBonusModifierRequiringArchaelogy",0,10099,10100,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"accessDifficultyBonusModifierRequiringArchaelogy",1,1,1,0,0,"None",0,0,0,0,903373);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2849,"accessDifficultyBonusModifierRequiringHacking",0,10105,10106,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"accessDifficultyBonusModifierRequiringHacking",1,1,1,0,0,"None",0,0,0,0,903376);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2850,"durationBonusForGroupAfterburner",0,10109,10110,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"durationBonusForGroupAfterburner",1,1,1,0,0,"None",0,0,0,0,903379);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2851,"missileDMGBonusPassive",0,3657,3658,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"missileDMGBonusPassive",1,1,1,0,0,"None",0,0,0,0,903382);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2852,"maxTargetingRangeBonusPremulPassive",0,840,841,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"maxTargetingRangeBonusPremulPassive",1,1,1,0,0,"None",0,0,0,0,903385);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2853,"cloakingTargetingDelayBonusLRSMCloakingPassive",0,10112,10113,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"cloakingTargetingDelayBonusLRSMCloakingPassive",1,1,1,0,0,"None",0,0,0,0,903388);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2854,"scanResolutionBonusMultiplierPreMulPassive",0,3398,3399,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"scanResolutionBonusMultiplierPreMulPassive",1,1,1,0,0,"None",0,0,0,0,903391);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2855,"eliteReconBonusHeavyAssaultLauncherROF1",0,10115,10116,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"eliteReconBonusHeavyAssaultLauncherROF1",1,1,1,0,0,"None",0,0,0,0,903394);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2856,"setCanCloak",1,10122,10123,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"setCanCloak",1,1,1,0,0,"None",0,0,0,0,903397);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2857,"cynosuralGeneration",1,10124,10125,"","",0,0,0,73,0,0,0,0,1,"cynosuralGeneration",1,1,1,0,0,"None",0,0,0,0,903400);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2858,"cloneJumpAccepting",1,10124,10125,"","",0,0,0,73,0,0,0,0,1,"cloneJumpAccepting",1,1,1,0,0,"None",0,0,0,0,903403);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2859,"modifyMaxVelocityOfShipOnline",4,3908,3909,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"modifyMaxVelocityOfShipOnline",1,1,1,0,0,"None",0,0,0,0,903406);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2861,"agilityMultiplierOnTarget",2,566,567,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"agilityMultiplierOnTarget",1,1,1,0,0,"None",0,0,0,0,903409);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2862,"testStasisWebifierEffect",2,10126,10127,"","",0,0,1,73,0,6,54,0,1,"testStasisWebifierEffect",1,1,1,0,0,"None",0,0,0,0,903412);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2863,"agilityBonusOnTargetPercentage",2,10130,10131,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"agilityBonusOnTarget",1,1,1,0,0,"None",0,0,0,0,903415);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2864,"newTestStasisWebifierEffect",2,10132,10133,"","",0,0,1,73,0,6,54,0,1,"newTestStasisWebifierEffect",1,1,1,0,0,"None",0,0,0,0,903418);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2865,"velocityBonusOnline",4,8917,8918,"Automatically generated effect","",0,0,1,0,0,0,0,0,0,"Max Velocity Bonus",1,1,1,0,0,"None",0,0,0,0,903421);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2866,"biologyTimeBonusFixed",0,10138,10139,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"biologyTimeBonusFixed",1,1,1,0,0,"None",0,0,0,0,903424);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2867,"sentryDroneDamageBonus",0,10144,10145,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"sentryDroneDamageBonus",1,1,1,0,0,"None",0,0,0,0,903427);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2868,"armorDamageAmountBonusCapitalArmorRepairers",0,10146,10147,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"armorDamageAmountBonusCapitalArmorRepairers",1,1,1,0,0,"None",0,0,0,0,903430);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2869,"droneStasisWebifyingBonus",0,10154,10155,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"droneStasisWebifyingBonus",1,1,1,0,0,"None",0,0,0,0,903433);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2870,"defenderMissileVelocityBonus",0,10160,10161,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"defenderMissileVelocity",1,1,1,0,0,"None",0,0,0,0,903436);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2871,"defenderMissileVelocityBonus2",0,2215,2216,"Broken generic defender velocity boost","",0,0,0,0,0,0,0,0,1,"defenderMissileVelocityBonus2",1,1,1,0,0,"None",0,0,0,0,903439);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2872,"missileVelocityBonusDefender",0,10164,10165,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"missileBonusVelocityDefender",1,1,1,0,0,"None",0,0,0,0,903442);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2873,"missileEMDmgBonusCruise",0,10169,10170,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"missileEMDmgBonusCruise",1,1,1,0,0,"None",0,0,0,0,903445);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2874,"missileExplosiveDmgBonusCruise",0,10173,10174,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"missileExplosiveDmgBonusCruise",1,1,1,0,0,"None",0,0,0,0,903448);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2875,"missileKineticDmgBonusCruise",0,10177,10178,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"missileKineticDmgBonusCruise",1,1,1,0,0,"None",0,0,0,0,903451);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2876,"missileThermalDmgBonusCruise",0,10181,10182,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"missileThermalDmgBonusCruise",1,1,1,0,0,"None",0,0,0,0,903454);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2877,"missileEMDmgBonusCruise2",0,10183,10184,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"missileEMDmgBonusCruise2",1,1,1,0,0,"None",0,0,0,0,903457);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2878,"missileExplosiveDmgBonusCruise2",0,10185,10186,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"missileExplosiveDmgBonusCruise2",1,1,1,0,0,"None",0,0,0,0,903460);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2879,"missileKineticDmgBonusCruise2",0,10187,10188,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"missileKineticDmgBonusCruise2",1,1,1,0,0,"None",0,0,0,0,903463);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2880,"missileThermalDmgBonusCruise2",0,10189,10190,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"missileThermalDmgBonusCruise2",1,1,1,0,0,"None",0,0,0,0,903466);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2881,"missileEMDmgBonusCruise3",0,10191,10192,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"missileEMDmgBonusCruise3",1,1,1,0,0,"None",0,0,0,0,903469);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2882,"missileExplosiveDmgBonusCruise3",0,10193,10194,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"missileExplosiveDmgBonusCruise3",1,1,1,0,0,"None",0,0,0,0,903472);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2883,"missileKineticDmgBonusCruise3",0,10195,10196,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"missileKineticDmgBonusCruise3",1,1,1,0,0,"None",0,0,0,0,903475);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2884,"missileThermalDmgBonusCruise3",0,10197,10198,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"missileThermalDmgBonusCruise3",1,1,1,0,0,"None",0,0,0,0,903478);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2885,"gasHarvestingCycleTimeModulesRequiringGasCloudHarvesting",0,10203,10204,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"gasHarvestingCycleTimeModulesRequiringGasCloudHarvesting",1,1,1,0,0,"None",0,0,0,0,903481);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2886,"setMaxLockedTargets",0,9127,9128,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"setMaxLockedTargets",1,1,1,0,0,"None",0,0,0,0,903484);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2887,"missileEMDmgBonusRocket",0,10207,10208,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"missileEMDmgBonusRocket",1,1,1,0,0,"None",0,0,0,0,903487);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2888,"missileExplosiveDmgBonusRocket",0,10211,10212,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"missileExplosiveDmgBonusRocket",1,1,1,0,0,"None",0,0,0,0,903490);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2889,"missileKineticDmgBonusRocket",0,10215,10216,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"missileKineticDmgBonusRocket",1,1,1,0,0,"None",0,0,0,0,903493);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2890,"missileThermalDmgBonusRocket",0,10219,10220,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"missileThermalDmgBonusRocket",1,1,1,0,0,"None",0,0,0,0,903496);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2891,"missileEMDmgBonusStandard",0,10223,10224,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"missileEMDmgBonusStandard",1,1,1,0,0,"None",0,0,0,0,903499);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2892,"missileExplosiveDmgBonusStandard",0,10227,10228,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"missileExplosiveDmgBonusStandard",1,1,1,0,0,"None",0,0,0,0,903502);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2893,"missileKineticDmgBonusStandard",0,10229,10230,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"missileKineticDmgBonusStandard",1,1,1,0,0,"None",0,0,0,0,903505);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2894,"missileThermalDmgBonusStandard",0,10231,10232,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"missileThermalDmgBonusStandard",1,1,1,0,0,"None",0,0,0,0,903508);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2895,"missileEMDmgBonusFOF",0,10237,10238,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"missileEMDmgBonusFOF",1,1,1,0,0,"None",0,0,0,0,903511);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2896,"missileExplosiveDmgBonusFOF",0,10241,10242,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"missileExplosiveDmgBonusFOF",1,1,1,0,0,"None",0,0,0,0,903514);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2897,"missileKineticDmgBonusFOF",0,10245,10246,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"missileKineticDmgBonusFOF",1,1,1,0,0,"None",0,0,0,0,903517);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2898,"missileThermalDmgBonusFOF",0,10249,10250,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"missileThermalDmgBonusFOF",1,1,1,0,0,"None",0,0,0,0,903520);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2899,"missileEMDmgBonusHeavy",0,10253,10254,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"missileEMDmgBonusHeavy",1,1,1,0,0,"None",0,0,0,0,903523);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2900,"missileExplosiveDmgBonusHeavy",0,10255,10256,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"missileExplosiveDmgBonusHeavy",1,1,1,0,0,"None",0,0,0,0,903526);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2901,"missileKineticDmgBonusHeavy",0,10257,10258,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"missileKineticDmgBonusHeavy",1,1,1,0,0,"None",0,0,0,0,903529);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2902,"missileThermalDmgBonusHeavy",0,10261,10262,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"missileThermalDmgBonusHeavy",1,1,1,0,0,"None",0,0,0,0,903532);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2903,"missileEMDmgBonusHAM",0,10265,10266,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"missileEMDmgBonusHAM",1,1,1,0,0,"None",0,0,0,0,903535);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2904,"missileExplosiveDmgBonusHAM",0,10269,10270,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"missileExplosiveDmgBonusHAM",1,1,1,0,0,"None",0,0,0,0,903538);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2905,"missileKineticDmgBonusHAM",0,10271,10272,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"missileKineticDmgBonusHAM",1,1,1,0,0,"None",0,0,0,0,903541);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2906,"missileThermalDmgBonusHAM",0,10275,10276,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"missileThermalDmgBonusHAM",1,1,1,0,0,"None",0,0,0,0,903544);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2907,"missileEMDmgBonusTorpedo",0,10279,10280,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"missileEMDmgBonusTorpedo",1,1,1,0,0,"None",0,0,0,0,903547);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2908,"missileExplosiveDmgBonusTorpedo",0,10283,10284,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"missileExplosiveDmgBonusTorpedo",1,1,1,0,0,"None",0,0,0,0,903550);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2909,"missileKineticDmgBonusTorpedo",0,10287,10288,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"missileKineticDmgBonusTorpedo",1,1,1,0,0,"None",0,0,0,0,903553);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2910,"missileThermalDmgBonusTorpedo",0,10291,10292,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"missileThermalDmgBonusTorpedo",1,1,1,0,0,"None",0,0,0,0,903556);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2911,"dataminerModuleDurationReduction",0,10297,10298,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"dataminerModuleDurationReduction",1,1,1,0,0,"None",0,0,0,0,903559);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2912,"energyDestabilizationNewForStructure",2,8495,8496,"","effects.EnergyDestabilization",0,0,1,73,0,0,98,0,1,"energyDestabilizationTEST",1,1,1,0,0,"None",0,0,0,0,903562);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2913,"remoteEcmBurst",2,131,471,"","effects.RemoteECM",0,0,1,73,0,6,54,0,1,"remoteEcmBurst",1,1,1,0,0,"None",0,0,0,0,903565);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2915,"warpScrambleSelfSiegeModeWarpStatus",4,10309,10310,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"warpScrambleSelf",1,1,1,0,0,"None",0,0,0,0,903568);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2918,"posStructureControlAmountBonus",0,10331,10332,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"posStructureControlAmountBonus",1,1,1,0,0,"None",0,0,0,0,903571);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2919,"triageModeWarpScrambleSelf",1,10309,10310,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"warpScrambleSelf",1,1,1,0,0,"None",0,0,0,0,903574);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2924,"triageModeMaxVelocityBonus",1,3488,3490,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903577);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2925,"triageModeSitDown",1,10348,10349,"TriageMode: WarpScrambleSelf + MaxVelocityBonus","",0,0,0,73,0,6,0,0,1,"triageModeSitDown",1,1,1,0,0,"None",0,0,0,0,903580);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2928,"triageModeArmorAmount",1,10359,10360,"Automatically generated effect","None",0,0,0,73,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903583);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2929,"triageModeArmorDuration",1,6703,6704,"Automatically generated effect","None",0,0,0,73,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903586);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2931,"triageModeShieldAmount",1,6694,6695,"Automatically generated effect","None",0,0,0,73,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903589);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2932,"triageModeShieldDuration",1,10365,10366,"Automatically generated effect","None",0,0,0,73,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903592);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2933,"triageModeSiegeTankArmor",1,10363,10364,"","",0,0,0,73,0,0,0,0,1,"triageModeSiegeTankArmor",1,1,1,0,0,"None",0,0,0,0,903595);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2934,"triageModeSiegeTankShield",1,10367,10368,"","",0,0,0,73,0,0,0,0,1,"triageModeSiegeTankShield",1,1,1,0,0,"None",0,0,0,0,903598);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2935,"triageModeSiegeTank",1,10369,10370,"","",0,0,0,73,0,6,0,0,1,"triageModeSiegeTank",1,1,1,0,0,"None",0,0,0,0,903601);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2936,"triageModeLogisticsArmorAmount",1,10376,10377,"Automatically generated effect","None",0,0,0,73,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903604);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2937,"triageModeLogisticsArmorDuration",1,10378,10379,"Automatically generated effect","None",0,0,0,73,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903607);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2938,"triageModeLogisticsArmor",1,10380,10381,"","",0,0,0,73,0,0,0,0,1,"triageModeLogisticsArmor",1,1,1,0,0,"None",0,0,0,0,903610);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2939,"triageModeLogisticsShieldAmount",1,10387,10388,"Automatically generated effect","None",0,0,0,73,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903613);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2940,"triageModeLogisticsShieldDuration",1,10389,10390,"Automatically generated effect","None",0,0,0,73,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903616);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2941,"triageModeLogisticsShield",1,10391,10392,"","",0,0,0,73,0,0,0,0,1,"triageModeLogisticsShield",1,1,1,0,0,"None",0,0,0,0,903619);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2943,"triageModeSensorEWCapNeedBonusECM",1,10397,10398,"Automatically generated effect","None",0,0,0,73,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903622);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2944,"triageModeSensorEWCapNeedBonusRSD",1,10401,10402,"Automatically generated effect","None",0,0,0,73,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903625);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2945,"triageModeSensorEWCapNeedBonusTD",1,10405,10406,"Automatically generated effect","None",0,0,0,73,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903628);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2946,"triageModeSensorEWCapNeedBonusTP",1,10409,10410,"Automatically generated effect","None",0,0,0,73,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903631);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2947,"triageModeSensorEWCapNeedBonusECMandRSD",1,10411,10412,"","",0,0,0,73,0,0,0,0,1,"triageModeSensorEWCapNeedBonusECMandRSD",1,1,1,0,0,"None",0,0,0,0,903634);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2948,"triageModeSensorEWCapNeedBonusTDandTP",1,10413,10414,"","",0,0,0,73,0,0,0,0,1,"triageModeSensorEWCapNeedBonusTDandTP",1,1,1,0,0,"None",0,0,0,0,903637);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2949,"triageModeSensorEWCapNeedBonus",1,10415,10416,"","",0,0,0,73,0,0,0,0,1,"triageModeSensorEWCapNeedBonus",1,1,1,0,0,"None",0,0,0,0,903640);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2950,"triageModeSensorPropJamCapNeedBonus",1,10417,10418,"Automatically generated effect","None",0,0,0,73,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903643);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2951,"triageModeSensorCapNeedBonus",1,10419,10420,"","",0,0,0,73,0,0,0,0,1,"triageModeSensorCapNeedBonus",1,1,1,0,0,"None",0,0,0,0,903646);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2953,"triageModeSensorScanResolutionMultiplier",1,3398,3399,"Automatically generated effect","None",0,0,0,73,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903649);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2956,"triageModeSiegeTankAndSitDown",1,10425,10426,"","",0,0,0,73,0,6,0,0,1,"triageModeSiegeTankAndSitDown",1,1,1,0,0,"None",0,0,0,0,903652);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2959,"triageModeDroneBonus",1,10434,10435,"Automatically generated effect","None",0,0,0,73,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903655);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2967,"skillTriageModuleConsumptionQuantityBonus",0,10459,10460,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903658);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2968,"triageModeCpuBonus",0,10465,10466,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903661);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2971,"bombLaunching",1,114,89,"Launches a missile","effects.MissileDeployment",0,0,1,0,0,0,0,0,1,"bombLaunching",1,1,1,0,0,"None",0,0,0,0,903664);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2974,"skillRemoteECMDurationBonusSkillLevel",0,10487,10488,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903667);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2976,"projECMCpuNeedBonusEffect",0,10493,10494,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903670);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2977,"skillRemoteHullRepairSystemsCapNeedBonus",0,10499,10500,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903673);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2979,"	skillRemoteHullRepairSystemsCapNeedBonus",0,10508,10509,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"	skillRemoteHullRepairSystemsCapNeedBonus",1,1,1,0,0,"None",0,0,0,0,903676);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2980,"skillCapitalRemoteHullRepairSystemsCapNeedBonus",0,10511,10512,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"skillCapitalRemoteHullRepairSystemsCapNeedBonus",1,1,1,0,0,"None",0,0,0,0,903679);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2982,"skillRemoteECMDurationBonus",0,10480,10481,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903682);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2983,"triageModeLogisticsHullAmount",1,10527,10528,"Automatically generated effect","None",0,0,0,73,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903685);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2984,"triageModeLogisticsHullDuration",1,10531,10532,"Automatically generated effect","None",0,0,0,73,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903688);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2985,"triageModeLogisticsEnergyAmount",1,10535,10536,"Automatically generated effect","None",0,0,0,73,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903691);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2986,"triageModeLogisticsEnergyDuration",1,10539,10540,"Automatically generated effect","None",0,0,0,73,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903694);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2987,"triageModeLogisticsEnergy",1,10541,10542,"","",0,0,0,73,0,0,0,0,1,"triageModeLogisticsEnergy",1,1,1,0,0,"None",0,0,0,0,903697);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2988,"triageModeLogisticsHull",1,10543,10544,"","",0,0,0,73,0,0,0,0,1,"triageModeLogisticsHull",1,1,1,0,0,"None",0,0,0,0,903700);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2989,"triageModeLogisticsEnergyAndHull",1,10545,10546,"","",0,0,0,73,0,0,0,0,1,"triageModeLogisticsEnergyAndHull",1,1,1,0,0,"None",0,0,0,0,903703);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2990,"triageModeLogisticsArmorAndShield",1,10393,10394,"","",0,0,0,73,0,0,0,0,1,"triageModeLogisticsArmorAndShield",1,1,1,0,0,"None",0,0,0,0,903706);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2991,"triageModeLogistics",1,10547,10548,"","",0,0,0,73,0,0,0,0,1,"triageModeLogistics",1,1,1,0,0,"None",0,0,0,0,903709);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2992,"triageModeSensorMaxLockedTargetsBonus",1,798,800,"Automatically generated effect","None",0,0,0,73,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903712);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (2994,"triageModeSensorTargeting",1,10549,10550,"","",0,0,0,73,0,0,0,0,1,"triageModeSensorTargeting",1,1,1,0,0,"None",0,0,0,0,903715);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3001,"overloadRofBonus",5,10567,10568,"Automatically generated effect","None",0,0,1,0,0,0,0,0,0,"overloadRofBonus",1,1,1,0,0,"None",0,0,0,0,903718);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3002,"overloadSelfDurationBonus",5,10571,10572,"Automatically generated effect","None",0,0,1,0,0,0,0,0,0,"overloadSelfDurationBonus",1,1,1,0,0,"None",0,0,0,0,903721);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3003,"energyDestabilizationForStructure",2,286,131,"Drains power from the target.","effects.EnergyDestabilization",0,1,1,73,0,0,98,0,1,"energyDestabilizationForStructure",1,1,1,0,0,"None",0,0,0,0,903724);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3004,"setGlobalPool",0,10577,10578,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"setGlobalPool",1,1,1,0,0,"None",0,0,0,0,903727);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3014,"skillBombDeploymentSpeedBonus",0,10615,10616,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"skillBombDeploymentSpeedBonus",1,1,1,0,0,"None",0,0,0,0,903730);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3015,"eliteBonusStealhBomberBombDeploymentCpu",0,10621,10622,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903733);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3016,"covertOpsAgilityBonus2",0,10623,10624,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903736);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3024,"eliteBonusCoverOpsBombExplosiveDmg1",0,10652,10653,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903739);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3025,"overloadSelfDamageBonus",5,10654,10655,"Automatically generated effect","None",0,0,1,0,0,0,0,0,0,"overloadSelfDamageBonus",1,1,1,0,0,"None",0,0,0,0,903742);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3026,"eliteBonusCoverOpsBombKineticDmg1",0,10656,10657,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903745);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3027,"eliteBonusCoverOpsBombThermalDmg1",0,10658,10659,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903748);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3028,"eliteBonusCoverOpsBombEmDmg1",0,10660,10661,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903751);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3029,"overloadSelfEmHardeningBonus",5,10663,10664,"Automatically generated effect","None",0,0,1,0,0,0,0,0,0,"overloadSelfEmHardeningBonus",1,1,1,0,0,"None",0,0,0,0,903754);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3030,"overloadSelfThermalHardeningBonus",5,10666,10667,"Automatically generated effect","None",0,0,1,0,0,0,0,0,0,"overloadSelfEmHardeningBonus",1,1,1,0,0,"None",0,0,0,0,903757);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3031,"overloadSelfExplosiveHardeningBonus",5,10669,10670,"Automatically generated effect","None",0,0,1,0,0,0,0,0,0,"overloadSelfEmHardeningBonus",1,1,1,0,0,"None",0,0,0,0,903760);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3032,"overloadSelfKineticHardeningBonus",5,10672,10673,"Automatically generated effect","None",0,0,1,0,0,0,0,0,0,"overloadSelfEmHardeningBonus",1,1,1,0,0,"None",0,0,0,0,903763);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3035,"overloadSelfHardeningInvulnerabilityBonus",5,10678,10679,"","",0,0,1,0,0,0,0,0,1,"overloadSelfHardeningInvulnerabilityBonus",1,1,1,0,0,"None",0,0,0,0,903766);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3036,"skillBombDeploymentModuleReactivationDelayBonus",0,10682,10683,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903769);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3037,"missileDamageMultiplierCruiseEmBonus",0,10684,10685,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903772);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3038,"missileDamageMultiplierCruiseThermalBonus",0,10686,10687,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903775);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3039,"missileDamageMultiplierCruiseKineticBonus",0,10688,10689,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903778);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3040,"missileDamageMultiplierCruiseExplosiveBonus",0,10690,10691,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903781);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3041,"remoteHullRepair",2,131,131,"Targeted (remote) Hull Repair effect.","effects.RemoteArmourRepair",0,1,1,73,0,6,54,0,1,"remoteHullRepair",1,1,1,0,0,"None",0,0,0,0,903784);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3042,"triageModeSensor",1,10692,10693,"","",0,0,1,73,0,6,0,0,1,"triageModeSensor",1,1,1,0,0,"None",0,0,0,0,903787);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3043,"triageModeLogisticsAndSensor",1,10694,10695,"","",0,0,1,73,0,6,0,0,1,"triageModeLogisticsAndSensor",1,1,1,0,0,"None",0,0,0,0,903790);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3044,"triageModeLogisticsAndSensorAndDrone",1,10696,10697,"","",0,0,1,73,0,6,0,0,1,"triageModeLogisticsAndSensorAndDrone",1,1,1,0,0,"None",0,0,0,0,903793);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3045,"triageModeEffectWithoutECMBurst",1,10698,10699,"Boost armor/shield logistics and tank, sensor boost, disallow EW, reduce max active drones and force the ship to sit down.","effects.TriageMode",0,0,0,73,0,6,0,0,1,"triageModeEffect",1,1,1,0,0,"None",0,0,0,0,903796);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3046,"modifyMaxVelocityOfShipPassive",0,3908,3909,"Automatically generated effect","",0,0,0,0,0,0,0,0,0,"modifyMaxVelocityOfShipPassive",1,1,1,0,0,"None",0,0,0,0,903799);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3047,"structureHPMultiplyPassive",0,494,495,"","",0,0,0,0,0,0,0,0,1,"structureHPMultiplyPassive",1,1,1,0,0,"None",0,0,0,0,903802);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3050,"carrierMinmatarArmor&ShieldAmount",0,10706,10707,"","",0,0,0,0,0,0,0,0,1,"carrierMinmatarArmor&ShieldAmount",1,1,1,0,0,"None",0,0,0,0,903805);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3052,"cpuPenaltyToBombLaunchers",0,10708,10709,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903808);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3053,"cpuPenaltyToProjectedECM",0,10712,10713,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903811);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3055,"triageModeSensorEWCapNeedBonusECMBurstECMBurst",1,10718,10719,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903814);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3056,"triageModeSensorEWCapNeedBonusECMBurstRemoteECMBurst",1,10724,10725,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903817);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3057,"triageModeSensorEWCapNeedBonusECMBurst",1,10726,10727,"","",0,0,0,0,0,0,0,0,1,"triageModeSensorEWCapNeedBonusECMBurst",1,1,1,0,0,"None",0,0,0,0,903820);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3060,"siegeModeEffectMaxTargetPenality",1,10731,10732,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903823);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3061,"heatDamageBonus",0,10735,10736,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"heatDamageBonus",1,1,1,0,0,"None",0,0,0,0,903826);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3062,"siegeModeEffect",1,10737,10738,"","effects.SiegeMode",0,0,0,73,0,0,0,0,1,"siegeModeEffect",1,1,1,0,0,"None",0,0,0,0,903829);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3063,"controlTowerGenericOutsideStructureResistanceBonus",0,8493,8494,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericOutsideStructureResistanceBonus",1,1,1,0,0,"None",0,0,0,0,903832);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3064,"controlTowerGenericHullEmResistanceBonusCynoGenerator",0,10743,10744,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903835);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3065,"controlTowerGenericHullExplosiveResistanceBonusCynoGenerator",0,10747,10748,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903838);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3066,"controlTowerGenericHullKineticResistanceBonusCynoGenerator",0,10751,10752,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903841);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3067,"controlTowerGenericHullThermicResistanceBonusCynoGenerator",0,10755,10756,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903844);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3068,"controlTowerGenericHullThermicResistanceBonusCynoJammer",0,10761,10762,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903847);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3069,"controlTowerGenericHullKineticResistanceBonusCynoJammer",0,10765,10766,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903850);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3070,"controlTowerGenericHullExplosiveResistanceBonusCynoJammer",0,10769,10770,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903853);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3071,"controlTowerGenericHullEmResistanceBonusCynoJammer",0,10773,10774,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903856);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3072,"controlTowerGenericHullEmResistanceBonusEcm",0,10777,10778,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903859);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3073,"controlTowerGenericHullExplosiveResistanceBonusEcm",0,10781,10782,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903862);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3074,"controlTowerGenericHullKineticResistanceBonusEcm",0,10785,10786,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903865);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3075,"controlTowerGenericHullThermicResistanceBonusEcm",0,10789,10790,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903868);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3076,"controlTowerGenericHullThermicResistanceBonusEnergyNeutralizer",0,10795,10796,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903871);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3077,"controlTowerGenericHullKineticResistanceBonusEnergyNeutralizer",0,10799,10800,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903874);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3078,"controlTowerGenericHullExplosiveResistanceBonusEnergyNeutralizer",0,10803,10804,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903877);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3079,"controlTowerGenericHullEmResistanceBonusEnergyNeutralizer",0,10807,10808,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903880);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3080,"controlTowerGenericHullEmResistanceBonusJumpPortal",0,10813,10814,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903883);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3081,"controlTowerGenericHullExplosiveResistanceBonusJumpPortal",0,10817,10818,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903886);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3082,"controlTowerGenericHullKineticResistanceBonusJumpPortal",0,10821,10822,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903889);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3083,"controlTowerGenericHullThermicResistanceBonusJumpPortal",0,10825,10826,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903892);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3084,"controlTowerGenericHullThermicResistanceBonusHybrid",0,10829,10830,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903895);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3085,"controlTowerGenericHullKineticResistanceBonusHybrid",0,10833,10834,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903898);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3086,"controlTowerGenericHullExplosiveResistanceBonusHybrid",0,10837,10838,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903901);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3087,"controlTowerGenericHullEmResistanceBonusHybrid",0,10841,10842,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903904);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3088,"controlTowerGenericHullEmResistanceBonusLaser",0,10845,10846,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903907);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3089,"controlTowerGenericHullExplosiveResistanceBonusLaser",0,10849,10850,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903910);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3090,"controlTowerGenericHullKineticResistanceBonusLaser",0,10853,10854,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903913);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3091,"controlTowerGenericHullThermicResistanceBonusLaser",0,10857,10858,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903916);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3092,"controlTowerGenericHullThermicResistanceBonusMissile",0,10861,10862,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903919);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3093,"controlTowerGenericHullKineticResistanceBonusMissile",0,10865,10866,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903922);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3094,"controlTowerGenericHullExplosiveResistanceBonusMissile",0,10869,10870,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903925);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3095,"controlTowerGenericHullEmResistanceBonusMissile",0,10873,10874,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903928);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3096,"controlTowerGenericHullEmResistanceBonusProjectile",0,10877,10878,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903931);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3097,"controlTowerGenericHullExplosiveResistanceBonusProjectile",0,10881,10882,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903934);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3098,"controlTowerGenericHullKineticResistanceBonusProjectile",0,10885,10886,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903937);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3099,"controlTowerGenericHullThermicResistanceBonusProjectile",0,10889,10890,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903940);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3100,"controlTowerGenericHullThermicResistanceBonusSensorDampener",0,10895,10896,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903943);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3101,"controlTowerGenericHullKineticResistanceBonusSensorDampener",0,10899,10900,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903946);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3102,"controlTowerGenericHullExplosiveResistanceBonusSensorDampener",0,10903,10904,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903949);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3103,"controlTowerGenericHullEmResistanceBonusSensorDampener",0,10907,10908,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903952);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3104,"controlTowerGenericHullEmResistanceBonusStasis",0,10913,10914,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903955);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3105,"controlTowerGenericHullExplosiveResistanceBonusStasis",0,10917,10918,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903958);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3106,"controlTowerGenericHullKineticResistanceBonusStasis",0,10921,10922,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903961);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3107,"controlTowerGenericHullThermicResistanceBonusStasis",0,10925,10926,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903964);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3108,"controlTowerGenericHullThermicResistanceBonusScrambler",0,10931,10932,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903967);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3109,"controlTowerGenericHullKineticResistanceBonusScrambler",0,10935,10936,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903970);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3110,"controlTowerGenericHullExplosiveResistanceBonusScrambler",0,10939,10940,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903973);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3111,"controlTowerGenericHullEmResistanceBonusScrambler",0,10943,10944,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,903976);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3112,"controlTowerGenericHullE&EResistanceBonusCynoGenerator",0,10945,10946,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullE&EResistanceBonusCynoGenerator",1,1,1,0,0,"None",0,0,0,0,903979);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3113,"controlTowerGenericHullE&EResistanceBonusCynoJammer",0,10947,10948,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullE&EResistanceBonusCynoJammer",1,1,1,0,0,"None",0,0,0,0,903982);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3114,"controlTowerGenericHullE&EResistanceBonusEcm",0,10949,10950,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullE&EResistanceBonusCynoEcm",1,1,1,0,0,"None",0,0,0,0,903985);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3115,"controlTowerGenericHullE&EResistanceBonusEnergyNeutralizer",0,10951,10952,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullE&EResistanceBonusCynoEnergyNeutralizer",1,1,1,0,0,"None",0,0,0,0,903988);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3116,"controlTowerGenericHullE&EResistanceBonusHybrid",0,10953,10954,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullE&EResistanceBonusCynoEnergyHybrid",1,1,1,0,0,"None",0,0,0,0,903991);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3117,"controlTowerGenericHullE&EResistanceBonusJumpPortal",0,10955,10956,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullE&EResistanceBonusCynoEnergyJumpPortal",1,1,1,0,0,"None",0,0,0,0,903994);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3118,"controlTowerGenericHullE&EResistanceBonusLaser",0,10957,10958,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullE&EResistanceBonusCynoEnergyLaser",1,1,1,0,0,"None",0,0,0,0,903997);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3119,"controlTowerGenericHullE&EResistanceBonusMissile",0,10959,10960,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullE&EResistanceBonusMissile",1,1,1,0,0,"None",0,0,0,0,904000);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3120,"controlTowerGenericHullE&EResistanceBonusProjectile",0,10961,10962,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullE&EResistanceBonusProjectile",1,1,1,0,0,"None",0,0,0,0,904003);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3121,"controlTowerGenericHullE&EResistanceBonusScrambler",0,10963,10964,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullE&EResistanceBonusScrambler",1,1,1,0,0,"None",0,0,0,0,904006);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3122,"controlTowerGenericHullE&EResistanceBonusSensorDampener",0,10965,10966,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullE&EResistanceBonusSensorDampener",1,1,1,0,0,"None",0,0,0,0,904009);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3123,"controlTowerGenericHullE&EResistanceBonusStasis",0,10967,10968,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullE&EResistanceBonusStasis",1,1,1,0,0,"None",0,0,0,0,904012);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3124,"controlTowerGenericHullK&TResistanceBonusCynoGenerator",0,10969,10970,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullK&TResistanceBonusCynoGenerator",1,1,1,0,0,"None",0,0,0,0,904015);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3125,"controlTowerGenericHullK&TResistanceBonusCynoJammer",0,10971,10972,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullK&TResistanceBonusCynoJammer",1,1,1,0,0,"None",0,0,0,0,904018);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3126,"controlTowerGenericHullK&TResistanceBonusEcm",0,10973,10974,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullK&TResistanceBonusEcm",1,1,1,0,0,"None",0,0,0,0,904021);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3127,"controlTowerGenericHullK&TResistanceBonusEnergyNeutralizer",0,10975,10976,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullK&TResistanceBonusEnergyNeutralizer",1,1,1,0,0,"None",0,0,0,0,904024);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3128,"controlTowerGenericHullK&TResistanceBonusHybrd",0,10977,10978,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullK&TResistanceBonusHybrd",1,1,1,0,0,"None",0,0,0,0,904027);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3129,"controlTowerGenericHullK&TResistanceBonusJump",0,10979,10980,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullK&TResistanceBonusJump",1,1,1,0,0,"None",0,0,0,0,904030);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3130,"controlTowerGenericHullK&TResistanceBonusLaser",0,10981,10982,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullK&TResistanceBonusLaser",1,1,1,0,0,"None",0,0,0,0,904033);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3131,"controlTowerGenericHullK&TResistanceBonusMissile",0,10983,10984,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullK&TResistanceBonusMissile",1,1,1,0,0,"None",0,0,0,0,904036);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3133,"controlTowerGenericHullK&TResistanceBonusProjectile",0,10985,10986,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullK&TResistanceBonusProjectile",1,1,1,0,0,"None",0,0,0,0,904039);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3134,"controlTowerGenericHullK&TResistanceBonusScrambler",0,10987,10988,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullK&TResistanceBonusScrambler",1,1,1,0,0,"None",0,0,0,0,904042);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3135,"controlTowerGenericHullK&TResistanceBonusSenDamp",0,10989,10990,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullK&TResistanceBonusSenDamp",1,1,1,0,0,"None",0,0,0,0,904045);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3136,"controlTowerGenericHullK&TResistanceBonusStasis",0,10991,10992,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullK&TResistanceBonusStasis",1,1,1,0,0,"None",0,0,0,0,904048);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3137,"controlTowerGenericHullResistanceBonusCynoGenerator",0,10993,10994,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullResistanceBonusCynoGenerator",1,1,1,0,0,"None",0,0,0,0,904051);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3138,"controlTowerGenericHullResistanceBonusCynoJammer",0,10995,10996,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullResistanceBonusCynoJammer",1,1,1,0,0,"None",0,0,0,0,904054);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3139,"controlTowerGenericHullResistanceBonusEcm",0,10997,10998,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullResistanceBonusEcm",1,1,1,0,0,"None",0,0,0,0,904057);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3140,"controlTowerGenericHullResistanceBonusEnergyNeutralizer",0,10999,11000,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullResistanceBonusEnergyNeutralizer",1,1,1,0,0,"None",0,0,0,0,904060);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3141,"controlTowerGenericHullResistanceBonusHybrid",0,11001,11002,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullResistanceBonusHybrid",1,1,1,0,0,"None",0,0,0,0,904063);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3142,"controlTowerGenericHullResistanceBonusJumpPortal",0,11003,11004,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullResistanceBonusJumpPortal",1,1,1,0,0,"None",0,0,0,0,904066);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3143,"controlTowerGenericHullResistanceBonusLaser",0,11005,11006,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullResistanceBonusJLaser",1,1,1,0,0,"None",0,0,0,0,904069);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3144,"controlTowerGenericHullResistanceBonusMissile",0,11007,11008,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullResistanceBonusMissile",1,1,1,0,0,"None",0,0,0,0,904072);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3145,"controlTowerGenericHullResistanceBonusProjectile",0,11009,11010,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullResistanceBonusProjectile",1,1,1,0,0,"None",0,0,0,0,904075);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3146,"controlTowerGenericHullResistanceBonusScrambler",0,11011,11012,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullResistanceBonusScrambler",1,1,1,0,0,"None",0,0,0,0,904078);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3148,"controlTowerGenericHullResistanceBonusSensorDampener",0,11013,11014,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullResistanceBonusSensorDampener",1,1,1,0,0,"None",0,0,0,0,904081);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3149,"controlTowerGenericHullResistanceBonusStasis",0,11015,11016,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullResistanceBonusStasis",1,1,1,0,0,"None",0,0,0,0,904084);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3150,"controlTowerGenericHullResistanceBonusCG&CGJ",0,11017,11018,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullResistanceBonusCG&CGJ",1,1,1,0,0,"None",0,0,0,0,904087);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3151,"controlTowerGenericHullResistanceBonusCG&CGJ&ECM",0,11019,11020,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullResistanceBonusCG&CGJ&ECM",1,1,1,0,0,"None",0,0,0,0,904090);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3152,"controlTowerGenericHullResistanceBonusCG&CGJ&ECM&EN",0,11021,11022,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullResistanceBonusCG&CGJ&ECM&EN",1,1,1,0,0,"None",0,0,0,0,904093);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3153,"controlTowerGenericHullResistanceBonusCG&CGJ&ECM&EN&H",0,11023,11024,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullResistanceBonusCG&CGJ&ECM&EN&H",1,1,1,0,0,"None",0,0,0,0,904096);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3154,"controlTowerGenericHullResistanceBonusCG&CGJ&ECM&EN&H&JP",0,11025,11026,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullResistanceBonusCG&CGJ&ECM&EN&H&JP",1,1,1,0,0,"None",0,0,0,0,904099);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3155,"controlTowerGenericHullResistanceBonusCG&CGJ&ECM&EN&H&JP&L",0,11027,11028,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullResistanceBonusCG&CGJ&ECM&EN&H&JP&L",1,1,1,0,0,"None",0,0,0,0,904102);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3156,"controlTowerGenericHullResistanceBonusCG&CGJ&ECM&EN&H&JP&L&M",0,11029,11030,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullResistanceBonusCG&CGJ&ECM&EN&H&JP&L&M",1,1,1,0,0,"None",0,0,0,0,904105);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3157,"controlTowerGenericHullResistanceBonusCG&CGJ&ECM&EN&H&JP&L&M&P",0,11031,11032,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullResistanceBonusCG&CGJ&ECM&EN&H&JP&L&M&P",1,1,1,0,0,"None",0,0,0,0,904108);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3158,"controlTowerGenericHullResistanceBonusCG&CGJ&ECM&EN&H&JP&L&M&P&SC",0,11033,11034,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullResistanceBonusCG&CGJ&ECM&EN&H&JP&L&M&P&SC",1,1,1,0,0,"None",0,0,0,0,904111);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3159,"controlTowerGenericHullResistanceBonusCG&CGJ&ECM&EN&H&JP&L&M&P&SC&SD",0,11035,11036,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullResistanceBonusCG&CGJ&ECM&EN&H&JP&L&M&P&SC&SD",1,1,1,0,0,"None",0,0,0,0,904114);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3160,"controlTowerGenericHullResistanceBonus",0,11037,11038,"","",0,0,0,0,0,0,0,0,1,"controlTowerGenericHullResistanceBonus",1,1,1,0,0,"None",0,0,0,0,904117);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3161,"sensorBoostTargetedHostileKali2Test",2,3525,3526,"","effects.ElectronicAttributeModifyTarget",0,1,1,73,0,0,54,158,1,"sensorBoostTargetedHostile",1,1,1,0,0,"None",0,0,0,0,904120);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3162,"triageModeEffect",1,11039,11040,"Boost armor/shield logistics and tank, sensor boost, disallow EW, reduce max active drones and force the ship to sit down.","effects.TriageMode",0,0,0,73,0,6,0,0,1,"triageModeEffect",1,1,1,0,0,"None",0,0,0,0,904123);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3164,"gangArmorRepairCapReducerProjected",1,11049,11050,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,904126);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3165,"gangArmorRepairCapReducerSelfAndProjected",1,11051,11052,"","effects.ElectronicAttributeModifyActivate",0,0,0,73,0,6,0,0,1,"gangArmorRepairCapReducerSelfAndProjected",1,1,1,0,0,"None",0,0,0,0,904129);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3166,"gangArmorRepairSpeedAmplifierProjected",1,11055,11056,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,904132);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3167,"gangArmorRepairSpeedAmplifierSelfAndProjected",1,11057,11058,"","effects.ElectronicAttributeModifyActivate",0,0,0,73,0,6,0,0,1,"gangArmorRepairSpeedAmplifierSelfAndProjected",1,1,1,0,0,"None",0,0,0,0,904135);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3168,"remoteArmorPowerNeedBonusEffect",0,11065,11066,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,904138);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3169,"shieldTransportCpuNeedBonusEffect",0,11069,11070,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,904141);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3171,"energyTransferPowerNeedBonusEffect",0,11077,11078,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,904144);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3172,"droneArmorDamageBonusEffect",0,11082,11083,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,904147);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3173,"droneShieldBonusBonusEffect",0,11084,11085,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,904150);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3174,"overloadSelfRangeBonus",5,11090,11091,"Automatically generated effect","None",0,0,1,0,0,0,0,0,0,"overloadSelfRangeBonus",1,1,1,0,0,"None",0,0,0,0,904153);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3175,"overloadSelfSpeedBonus",5,11095,11096,"Automatically generated effect","None",0,0,1,0,0,0,0,0,0,"overloadSelfSpeedBonus",1,1,1,0,0,"None",0,0,0,0,904156);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3182,"overloadSelfECMStrenghtBonus",5,11120,11121,"","",0,0,1,0,0,0,0,0,1,"overloadSelfECMStrenghtBonus",1,1,1,0,0,"None",0,0,0,0,904159);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3189,"overloadSelfECCMStrenghtBonus",5,11144,11145,"","",0,0,1,0,0,0,0,0,1,"overloadSelfECCMStrenghtBonus",1,1,1,0,0,"None",0,0,0,0,904162);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3191,"increaseSignatureRadiusPassive",0,3277,3278,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"increaseSignatureRadiusPassive",1,1,1,0,0,"None",0,0,0,0,904165);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3192,"signatureRadiusMultiplierPassive",0,11152,11153,"Automatically generated effect","None",0,0,0,0,0,0,0,0,0,"None",1,1,1,0,0,"None",0,0,0,0,904168);
INSERT INTO dgmEffects (effectID,effectName,effectCategory,preExpression,postExpression,description,guid,graphicID,isOffensive,isAssistance,durationAttributeID,trackingSpeedAttributeID,dischargeAttributeID,rangeAttributeID,falloffAttributeID,published,displayName,isWarpSafe,rangeChance,electronicChance,propulsionChance,distribution,sfxName,npcUsageChanceAttributeID,npcActivationChanceAttributeID,fittingUsageChanceAttributeID,iconID,dataID) VALUES (3193,"c