DROP TABLE IF EXISTS `invTypes`;
CREATE TABLE `invTypes` (
  `typeID` int(11) NOT NULL,
  `groupID` smallint(6) DEFAULT NULL,
  `typeName` varchar(100) DEFAULT NULL,
  `description` varchar(3000) DEFAULT NULL,
  `graphicID` smallint(6) DEFAULT NULL,
  `radius` double DEFAULT NULL,
  `mass` double DEFAULT NULL,
  `volume` double DEFAULT NULL,
  `capacity` double DEFAULT NULL,
  `portionSize` int(11) DEFAULT NULL,
  `raceID` tinyint(3) unsigned DEFAULT NULL,
  `basePrice` double DEFAULT NULL,
  `published` tinyint(1) DEFAULT NULL,
  `marketGroupID` smallint(6) DEFAULT NULL,
  `chanceOfDuplicating` double DEFAULT NULL,
  `soundID` smallint(6) DEFAULT NULL,
  `categoryID` smallint(6) DEFAULT NULL,
  `iconID` smallint(6) DEFAULT NULL,
  `attributeID` smallint(6) DEFAULT NULL,
  `dataID` int(11) DEFAULT NULL,
  PRIMARY KEY (`typeID`),
  KEY `invTypes_IX_Group` (`groupID`),
  KEY `graphicID` (`graphicID`),
  KEY `raceID` (`raceID`),
  KEY `marketGroupID` (`marketGroupID`),
  KEY `iconID` (`iconID`),
  KEY `soundID` (`soundID`),
  KEY `categoryID` (`categoryID`),
  KEY `attributeID` (`attributeID`),
  KEY `dataID` (`dataID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (0,0,"#System","",0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,726682);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2,2,"Corporation","",0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,9059770);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3,3,"Region","",0,0,0,1,0,1,0,0,1,0,0,0,2,0,0,9059771);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (4,4,"Constellation","",0,0,0,1,0,1,0,0,1,0,0,0,2,0,0,9059772);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (5,5,"Solar System","",6,5e+012,0,1,0,1,0,0,0,0,0,0,2,0,0,726694);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (6,6,"Sun G5 (Yellow)","",1015,10000,99999999999999997000000000000000000.000000,1,0,1,0,0,0,0,0,0,2,0,0,726697);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (7,6,"Sun K7 (Orange)","",1012,10000,99999999999999997000000000000000000.000000,1,0,1,0,0,0,0,0,0,2,0,0,726700);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (8,6,"Sun K5 (Red Giant)","",1013,10000,99999999999999997000000000000000000.000000,1,0,1,0,0,0,0,0,0,2,0,0,726703);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (9,6,"Sun B0 (Blue)","",1011,10000,99999999999999997000000000000000000.000000,1,0,1,0,0,0,0,0,0,2,0,0,726706);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (10,6,"Sun F0 (White)","",1014,10000,99999999999999997000000000000000000.000000,1,0,1,0,0,0,0,0,0,2,0,0,7670600);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (11,7,"Planet (Temperate)","Life-bearing worlds are often referred to as \"temperate\", as their mild temperatures are one of their defining features. Planets with existing, stable ecosystems are prime targets for colonization efforts as they are generally easier to make fully habitable; as a result, the majority of highly populated worlds are of this type. Indeed, it is not altogether uncommon for detailed surveys to reveal signs of previous settlements from various stages of New Eden\'s history.",3832,10000,99999999999999997000000000000000000.000000,1,0,1,0,0,0,0,0,0,2,10136,0,9049099);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (12,7,"Planet (Ice)","The majority of icy planets went through a period of being barren terrestrials, before being surfaced with ice over the course of many millennia. The exact process for this varies from case to case, but the end result is both common and visually uniform - a bright, reflective planet scored by countless fractures and crevasses. A few icy planets are hypothesized to have been warmer, liquid-bearing planets in the past that have subsequently frozen, as a result of either stellar cooling or failed terraforming projects.",3834,10000,99999999999999997000000000000000000.000000,1,0,1,0,0,0,0,0,0,2,10137,0,9049093);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (13,7,"Planet (Gas)","Gas planets are characterized by a deep, opaque upper atmosphere, usually composed primarily of light elements such as hydrogen or helium. Simple chemicals can add a range of hues and shades in the visual spectrum, and the interaction between upwellings and rapidly circulating pressure bands result in a huge variety of visible surface structures. A similar level of diversity can be found beneath the cloud-tops: the inner composition of a given gas planet might belong to any one of a dozen broad groups, with no two planets entirely alike in this regard.",3833,10000,99999999999999997000000000000000000.000000,1,0,1,0,0,0,0,0,0,2,10139,0,9049092);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (14,8,"Moon","",10,10000,99999999999999997000000000000000000.000000,1,0,1,0,0,0,0,0,0,2,10141,0,9049100);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (15,9,"Asteroid Belt","",0,1,99999999999999997000000000000000000.000000,1,0,1,0,0,1,0,0,9,2,15,0,9066622);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (16,10,"Stargate (Caldari System)","",235,3532,99999999999999997000000000000000000.000000,1e+007,0,1,1,0,0,0,0,32,2,0,0,7456548);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (17,10,"Stargate (Amarr Constellation)","",236,2323,99999999999999997000000000000000000.000000,1e+008,0,1,4,0,0,0,0,32,2,0,0,7456538);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (18,458,"Plagioclase","Plagioclase is not amongst the most valuable ore types around, but it has the largest amount of pyerite of any ore and is thus always in constant demand. It also yields some tritanium and mexallon. It requires 333 ore units to refine.",230,1,99999999999999997000000000000000000.000000,0.350000,0,333,0,12800,1,516,0,0,25,230,0,726733);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (19,461,"Spodumain","Spodumain is amongst the most valuable ore types around, as it is one of only three ore types that yields the ultra-rare megacyte. Otherwise very plain, with a bit of tritanium and pyerite. 250 ore units are needed to refine. ",1274,1,99999999999999997000000000000000000.000000,16,0,250,0,1.15654e+006,1,517,0,0,25,1274,0,726736);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (20,457,"Kernite","Kernite is a fairly common ore type that yields the largest amount of mexallon of any ore types in the universe. Besides mexallon the Kernite also has a bit of tritanium and isogen. 400 units of ore are needed for refining.",1270,1,99999999999999997000000000000000000.000000,1.200000,0,400,0,74916,1,523,0,0,25,1270,0,2815623);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (21,454,"Hedbergite","Hedbergite is sought after for its high concentration of isogen, although the high portion size needed for refining makes it a bit less attractive.  Hedbergite also yields some Nocxium, Pyerite and a small amount of Zydrine. 500 ore units are needed to refine it.",1269,1,99999999999999997000000000000000000.000000,3,0,500,0,339728,1,527,0,0,25,1269,0,8836328);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (22,450,"Arkonor","The rarest and most sought-after ore in the known universe. A sizable nugget of this can sweep anyone from rags to riches in no time. Arkonor has the largest amount of megacyte of any ore, and also contains some zydrine and tritanium. The portion size for refining is 200 ore units.",1277,1,99999999999999997000000000000000000.000000,16,0,200,0,3.0685e+006,1,512,0,0,25,1277,0,2815587);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (23,12,"Cargo Container","This cargo container is flimsily constructed and may not survive the rigors of space for more than an hour or so.",16,14,10000,27500,27500,1,0,0,0,0,0,0,2,16,0,726748);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (24,13,"Ring","",0,4.5e+006,99999999999999997000000000000000000.000000,1,0,1,0,0,1,0,0,0,2,0,0,9059773);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (25,14,"Corpse","",398,1,200,2,0,1,0,0,0,0,0,0,2,398,0,726754);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (26,16,"Office Folder","",0,0,0,1,0,1,0,0,1,0,0,0,3,0,0,9059774);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (27,16,"Office","",0,0,0,1,0,1,0,0,1,0,0,0,3,0,0,9059775);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (28,16,"Factory Folder","",0,0,0,1,0,1,0,0,1,0,0,0,3,0,0,9059776);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (29,17,"Credits","",0,0,0,0,0,57344,0,57344,1,0,0,0,4,21,0,9059777);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (30,19,"Faction","",0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,726769);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (34,18,"Tritanium","The main building block in space structures. A very hard, yet bendable metal. Cannot be used in human habitats due to its instability at atmospheric temperatures. Very common throughout the world.",0,0,0,0.010000,0,1,0,2,1,18,0,0,4,22,0,9059778);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (35,18,"Pyerite","A soft crystal-like mineral with a very distinguishing orange glow as if on fire. Used as conduit and in the bio-chemical industry. Commonly found in many asteroid-ore types.",0,0,0,0.010000,0,1,0,8,1,18,0,0,4,400,0,9059779);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (36,18,"Mexallon","Very flexible metallic mineral, dull to bright silvery green in color. Can be mixed with tritanium to make extremely hard alloys or it can be used by itself for various purposes. Fairly common in most regions.",0,0,0,0.010000,0,1,0,32,1,18,0,0,4,401,0,9059780);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (37,18,"Isogen","Light-bluish crystal, formed by intense pressure deep within large asteroids and moons. Used in electronic and weapon manufacturing. Only found in abundance in a few areas. ",0,0,0,0.010000,0,1,0,128,1,18,0,0,4,402,0,9059781);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (38,18,"Nocxium","A highly volatile mineral only formed during supernovas, thus severely limiting the extent of its distribution. Vital ingredient in capsule production, making it very coveted.",0,0,0,0.010000,0,1,0,512,1,18,0,0,4,1201,0,9059782);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (39,18,"Zydrine","Only found in huge geodes; rocks on the outside with crystal-like quartz on the inside. The rarest and most precious of these geodes are those that contain the dark green zydrine within. Very rare and very expensive.",0,0,0,0.010000,0,1,0,2048,1,18,0,0,4,404,0,9059783);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (40,18,"Megacyte","An extremely rare mineral found in comets and very occasionally in asteroids that have traveled through gas clouds. Has unique explosive traits that make it very valuable in the armaments industry. ",0,0,0,0.010000,0,1,0,8192,1,18,0,0,4,405,0,9059784);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (41,280,"Garbage","Production waste can mean garbage to some but valuable resource material to others.",0,0,2500,0.250000,0,1,0,20,1,20,0,0,17,1179,0,9059785);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (42,280,"Spiced Wine","Luxury goods are always solid commodities for inter-stellar trading. Spiced wine is not the rarest of luxury goods, but it can still be sold at small outposts and bases that don\'t manufacture any themselves.",0,0,500,0.500000,0,1,0,1500,1,492,0,0,17,27,0,9059786);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (43,280,"Antibiotics","Antibiotics are in constant demand everywhere and new, more potent versions, are always made available to counter the increased immunity of bacteria against antibiotics.",0,0,5,0.200000,0,1,0,325,1,492,0,0,17,28,0,9059787);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (44,1034,"Enriched Uranium","Enriched Uranium is used in many kinds of manufacturing and as a fuel, making it a steady trade commodity.  Enriched Uranium is generally manufactured by combining standard semiconductor PVD methods with ionic separation by means of mass spectrometry.",0,0,0,1.500000,0,1,0,5000,1,1335,0,0,43,29,0,9068364);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (45,281,"Frozen Plant Seeds","Frozen plant seeds are in high demand in many regions, especially on stations orbiting a non-habitable planet.",0,0,400,0.500000,0,1,0,75,1,492,0,0,17,1200,0,9059788);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (48,20,"Personal Nuclear Methadone","Nuclear Methadone is a potent and popular smart drug, which can boost your abilities for a short while. It is illegal in Caldari space and you\'ll be branded a smuggler if found carrying it therein. You can buy and sell Nuclear Methadone just like any other trade commodity, but you can also buy dosages for personal usage.  This is the personal version.",0,0,0,1,0,1,0,0,1,0,0,0,4,31,0,9059789);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (49,24,"Player Kill","Kill confirmation",0,0,0,0,0,1,0,0,1,0,0,0,5,0,0,9059790);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (50,24,"Company Shares","Shares of a corporation.",0,0,0,0,0,1,0,0,1,0,0,0,5,2243,0,9059791);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (51,24,"Bookmark","",0,0,0,0,0,1,0,0,1,0,0,0,5,1700,0,9064908);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (52,94,"Trading","",0,0,0,0,0,1,0,0,1,0,0,0,10,0,0,9059792);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (53,95,"Trade Session","",0,0,0,0,0,1,0,0,1,0,0,0,10,0,0,9059793);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (54,15,"Station (Caldari 4)","",237,15351,0,1,0,1,1,600000,0,0,0,14,3,0,0,7111847);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (56,15,"Station (Gallente 1)","",239,23836,0,1,0,1,8,600000,0,0,0,27,3,0,0,7111848);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (57,15,"Station (Gallente 2)","",240,27072,0,1,0,1,8,600000,0,0,0,14,3,0,0,7111849);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (58,15,"C-O-1","Caldari Outpost 1",346,1000,0,1,0,1,1,600000,0,0,0,0,3,0,0,726835);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (59,15,"C-O-2","Caldari Outpost 2",347,1000,0,1,0,1,1,600000,0,0,0,0,3,0,0,726838);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (164,23,"Clone Grade Alpha","",0,0,0,1,0,1,0,0,1,0,0,0,5,34,0,9059794);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (165,23,"Clone Grade Beta","",0,0,0,1,0,1,0,40000,1,0,0,0,5,34,0,9064295);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (166,23,"Clone Grade Gamma","",0,0,0,1,0,1,0,65000,1,0,0,0,5,34,0,9064299);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (178,83,"Carbonized Lead S","Small Projectile Ammo. This ammo uses a simple lead slug encased in a hard shell of crystalline carbon. It is fairly cheap and works very well against most armors. Shields, however, are a problem. ",1308,1,0.010000,0.002500,0,100,0,200,1,113,0.070000,0,8,1004,422,7506356);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (179,83,"Nuclear S","Small Projectile Ammo. Nuclear weapons are considered by most races to be crude and primitive. However, the Minmatar still favor them over more sophisticated weapons due to the abundance of materials for plutonium production in Minmatar space.  ",1288,1,0.010000,0.002500,0,100,0,300,1,113,0.070000,0,8,1288,422,7506361);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (180,83,"Proton S","Small Projectile Ammo. Emits a focused, high intensity proton burst upon impact. Fairly effective vs. both shields and armor. ",1290,1,0.010000,0.002500,0,100,0,400,1,113,0.070000,0,8,1290,422,7506366);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (181,83,"Depleted Uranium S","Small projectile Ammo. Very commonly used by Minmatar pilots, this ammo is incendiary and also has great penetration. Just be careful handling it unless you want to wake up with an extra toe on your forehead. ",1285,1,0.010000,0.002500,0,100,0,500,1,113,0.070000,0,8,1285,422,726859);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (182,83,"Titanium Sabot S","Small Projectile Ammo. This is among the most feared ammunition around. It has excellent penetration. Once the ship\'s outer layer is penetrated, the core explodes, spraying the interior with a cloud of fragmentation fletchets that cause considerable damage to the vulnerable interior structure. ",1291,1,0.010000,0.002500,0,100,0,600,1,113,0.070000,0,8,1291,422,7506376);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (183,83,"Fusion S","Small Projectile Ammo. The destructive power of a fusion warhead is superior to most other projectile warheads available, although it has problems penetrating heavy shield systems.",1287,1,0.010000,0.002500,0,100,0,700,1,113,0.070000,0,8,1287,422,13182147);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (184,83,"Phased Plasma S","Small Projectile Ammo. This ammo uses a similar plasma containment core as hybrid charges except that it is mounted in a standard cannon shell. ",1289,1,0.010000,0.002500,0,100,0,800,1,113,0.070000,0,8,1289,422,8695282);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (185,83,"EMP S","Small projectile Ammo. A new technology, this highly advanced ammunition emits a focused EM pulse. Very potent against shields. Small projectile Ammo",1286,1,0.010000,0.002500,0,100,0,1000,1,113,0.070000,0,8,1286,422,7506391);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (186,83,"Carbonized Lead M","Medium Projectile Ammo. This ammo uses a simple lead slug encased in a hard shell of crystalline carbon. It is fairly cheap and works very well against most armors. Shields, however, are a problem.",1292,1,0.050000,0.012500,0,100,0,800,1,112,0.070000,0,8,1292,422,7506516);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (187,83,"Nuclear M","Medium Projectile Ammo. Nuclear weapons are considered by most races to be crude and primitive. However, the Minmatar still favor them over more sophisticated weapons due to the abundance of materials for plutonium production in Minmatar space. Used In Medium Projectile Weapons",1296,1,0.050000,0.012500,0,100,0,1200,1,112,0.070000,0,8,1296,422,7506521);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (188,83,"Proton M","Medium Projectile Ammo. Emits a focused, high intensity proton burst upon impact. Fairly effective vs. both shields and armor. Used In Medium Projectile Weapons",1298,1,1,0.012500,0,100,0,1650,1,112,0.070000,0,8,1298,422,8777951);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (189,83,"Depleted Uranium M","Medium Projectile Ammo. Very commonly used by Minmatar pilots, this ammo is incendiary and also has great penetration. Just be careful handling it unless you want to wake up with an extra toe on your forehead.",1293,1,1,0.012500,0,100,0,2050,1,112,0.070000,0,8,1293,422,726883);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (190,83,"Titanium Sabot M","Medium Projectile Ammo. This is among the most feared ammunition around. It has excellent penetration. Once the ship\'s outer layer is penetrated, the core explodes, spraying the interior with a cloud of fragmentation fletchets that cause considerable damage to the vulnerable interior structure. Used In Medium Projectile Weapons.",1299,1,1,0.012500,0,100,0,2350,1,112,0.070000,0,8,1299,422,7506536);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (191,83,"Fusion M","Medium Projectile Ammo. The destructive power of a fusion warhead is superior to most other projectile warheads available, although it has problems penetrating heavy shield systems.",1295,1,1,0.012500,0,100,0,2750,1,112,0.070000,0,8,1295,422,13182146);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (192,83,"Phased Plasma M","Medium Projectile Ammo. This ammo uses a similar plasma containment core as hybrid charges except that it is mounted in a standard cannon shell.",1297,1,1,0.012500,0,100,0,3250,1,112,0.070000,0,8,1297,422,7506546);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (193,83,"EMP M","Medium Projectile Ammo. A new technology, this highly advanced ammunition emits a focused EM pulse. Very potent against shields.",1294,1,1,0.012500,0,100,0,4000,1,112,0.070000,0,8,1294,422,7506551);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (194,83,"Carbonized Lead L","Large Projectile Ammo. This ammo uses a simple lead slug encased in a hard shell of crystalline carbon. It is fairly cheap and works very well against most armors. Shields, however, are a problem.",1300,10,1,0.025000,0,100,0,2000,1,109,0.070000,0,8,1300,422,7506676);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (195,83,"Nuclear L","Large Projectile Ammo. Nuclear weapons are considered by most races to be crude and primitive. However, the Minmatar still favor them over more sophisticated weapons due to the abundance of materials for plutonium production in Minmatar space. ",1304,10,1,0.025000,0,100,0,3000,1,109,0.070000,0,8,1304,422,7506681);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (196,83,"Proton L","Large Projectile Ammo. Emits a focused, high intensity proton burst upon impact. Fairly effective vs. both shields and armor.",1306,10,1,0.025000,0,100,0,4000,1,109,0.070000,0,8,1306,422,7506686);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (197,83,"Depleted Uranium L","Large Projectile Ammo. Very commonly used by Minmatar pilots, this ammo is incendiary and also has great penetration. Just be careful handling it unless you want to wake up with an extra toe on your forehead.",1301,10,1,0.025000,0,100,0,5000,1,109,0.070000,0,8,1301,422,726907);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (198,83,"Titanium Sabot L","Large Projectile Ammo. This is among the most feared ammunition around. It has excellent penetration. Once the ship\'s outer layer is penetrated, the core explodes, spraying the interior with a cloud of fragmentation fletchets that cause considerable damage to the vulnerable interior structure.",1307,10,1,0.025000,0,100,0,6000,1,109,0.070000,0,8,1307,422,7506696);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (199,83,"Fusion L","Large Projectile Ammo. The destructive power of a fusion warhead is superior to most other projectile warheads available, although it has problems penetrating heavy shield systems.",1303,10,1,0.025000,0,100,0,7000,1,109,0.070000,0,8,1303,422,13182145);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (200,83,"Phased Plasma L","Large Projectile Ammo. This ammo uses a similar plasma containment core as hybrid charges except that it is mounted in a standard cannon shell.  ",1305,10,1,0.025000,0,100,0,8000,1,109,0.070000,0,8,1305,422,7506706);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (201,83,"EMP L","Large Projectile Ammo. A new technology, this highly advanced ammunition emits a focused EM pulse. Very potent against shields.",1302,10,1,0.025000,0,100,0,10000,1,109,0.070000,0,8,1302,422,7506711);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (202,386,"Paradise Cruise Missile","Extra heavy assault missile. The mother of all missiles, the Paradise delivers a tremendous payload, guaranteed to get its victims acquainted with their personal god in a quick, but painful manner.",182,300,1250,0.050000,0,100,0,15000,1,921,0.070000,0,8,182,422,726922);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (203,386,"Wrath Cruise Missile","Extra heavy assault missile. The first and only Minmatar-made large missile. Constructed of reactionary alloys, the Wrath is built to get to the target. Guidance and propulsion systems are of Gallentean origin and were initially used in drones, making Wrath fast and nimble despite its heavy payload. ",183,300,1250,0.050000,0,100,0,10000,1,921,0.070000,0,8,183,422,8695137);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (204,386,"Cataclysm Cruise Missile","Extra heavy assault missile. An Amarrian large missile with good capabilities, the Cataclysm was for a long time confined solely to the Amarr armed forces, but exports began some years ago and the missile is now found throughout the universe.",184,300,1250,0.050000,0,100,0,12500,1,921,0.070000,0,8,184,422,726928);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (205,386,"Devastator Cruise Missile","Extra heavy assault missile. A very basic missile for large launchers with reasonable payload. Utilizes the now sub-standard technology of bulls-eye guidance system.",185,300,1250,0.050000,0,100,0,7500,1,921,0.070000,0,8,185,422,726931);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (206,385,"Havoc Heavy Missile","The be-all-end-all of medium sized missiles, the Havoc is a must for those who want a guaranteed kill no matter the cost.",186,300,1000,0.030000,0,100,0,2000,1,924,0.070000,0,8,186,422,726934);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (207,385,"Thunderbolt Heavy Missile","Recently introduced by the armaments lab of the Wiyrkomi Corporation, the Thunderbolt is a solid investment with a large payload and steady performance.",187,300,1000,0.030000,0,100,0,3500,1,924,0.070000,0,8,187,422,726937);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (208,385,"Widowmaker Heavy Missile","Originally designed as a \'finisher\' - the killing blow to a crippled ship - the Widowmaker has since gone through various technological upgrades. The latest version has a lighter payload than the original, but much improved guidance systems.",188,300,1000,0.030000,0,100,0,3000,1,924,0.070000,0,8,188,422,726940);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (209,385,"Scourge Heavy Missile","The Scourge is an old relic from the Caldari-Gallente War that is still in widespread use because of its low price and versatility.",189,300,1000,0.030000,0,100,0,2500,1,924,0.070000,0,8,189,422,726943);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (210,384,"Bloodclaw Light Missile","Light assault missile. Fresh out of the Minmatar design labs, the Bloodclaw has quickly established itself throughout the galaxy as the ultimate missile for small launchers.",190,300,700,0.015000,0,100,0,500,1,920,0.070000,0,8,190,422,726946);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (211,384,"Flameburst Light Missile","Light assault missile. The explosion the Flameburst missile creates upon impact is stunning enough for any display of fireworks - just ten times more deadly.",191,300,700,0.015000,0,100,0,624,1,920,0.070000,0,8,191,422,8778305);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (212,384,"Sabretooth Light Missile","Light assault missile. An advanced missile with a volatile payload of magnetized plasma, the Sabretooth is a multi-purpose missile specifically engineered to take down shield systems.",192,300,700,0.015000,0,100,0,750,1,920,0.070000,0,8,192,422,726952);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (213,384,"Piranha Light Missile","Light assault missile. The Piranha is a tiny nuclear missile based on a classic Minmatar design that has been in use since the early days of the Minmatar Resistance.     ",193,300,700,0.015000,0,100,0,370,1,920,0.070000,0,8,193,422,726955);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (215,85,"Iron Charge S","Consists of two components: a shell of titanium and a core of iron atoms suspended in a plasma state. Railguns launch the shell directly, while particle blasters pump the plasma into a cyclotron and process the plasma into a bolt that is then fired.     ",1311,1,0.010000,0.005000,0,100,0,200,1,107,0.070000,0,8,1311,422,726958);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (216,85,"Tungsten Charge S","Consists of two components: a shell of titanium and a core of tungsten atoms suspended in plasma state. Railguns launch the shell directly, while particle blasters pump the plasma into a cyclotron and process the plasma into a bolt that is then fired.",1315,1,0.010000,0.005000,0,100,0,300,1,107,0.070000,0,8,1315,422,726961);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (217,85,"Iridium Charge S","Consists of two components: a shell of titanium and a core of iridium atoms suspended in plasma state. Railguns launch the shell directly, while particle blasters pump the plasma into a cyclotron and process the plasma into a bolt that is then fired.   ",1310,1,0.010000,0.005000,0,100,0,400,1,107,0.070000,0,8,1310,422,726964);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (218,85,"Lead Charge S","Consists of two components: a shell of titanium and a core of lead atoms suspended in a plasma state. Railguns launch the shell directly, while particle blasters pump the plasma into a cyclotron and process the plasma into a bolt that is then fired.   ",1312,1,0.010000,0.005000,0,100,0,500,1,107,0.070000,0,8,1312,422,726967);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (219,85,"Thorium Charge S","Consists of two components: a shell of titanium and a core of thorium atoms suspended in plasma state. Railguns launch the shell directly, while particle blasters pump the plasma into a cyclotron and process the plasma into a bolt that is then fired.   ",1314,10,0.010000,0.005000,0,100,0,600,1,107,0.070000,0,8,1314,422,726970);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (220,85,"Uranium Charge S","Consists of two components: a shell of titanium and a core of uranium atoms suspended in plasma state. Railguns launch the shell directly, while particle blasters pump the plasma into a cyclotron and process the plasma into a bolt that is then fired.   ",1316,1,0.010000,0.005000,0,100,0,700,1,107,0.070000,0,8,1316,422,726973);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (221,85,"Plutonium Charge S","Consists of two components: a shell of titanium and a core of plutonium atoms suspended in plasma state. Railguns launch the shell directly, while particle blasters pump the plasma into a cyclotron and process the plasma into a bolt that is then fired.   ",1313,1,0.010000,0.005000,0,100,0,800,1,107,0.070000,0,8,1313,422,726976);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (222,85,"Antimatter Charge S","Consists of two components: a shell of titanium and a core of antimatter atoms suspended in plasma state. Railguns launch the shell directly, while particle blasters pump the plasma into a cyclotron and process the plasma into a bolt that is then fired.   ",1047,1,0.010000,0.005000,0,100,0,1000,1,107,0.070000,0,8,1047,422,726979);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (223,85,"Iron Charge M","Consists of two components: a shell of titanium and a core of iron atoms suspended in a plasma state. Railguns launch the shell directly, while particle blasters pump the plasma into a cyclotron and process the plasma into a bolt that is then fired.     ",1319,1,0.050000,0.025000,0,100,0,800,1,108,0.070000,0,8,1319,422,726982);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (224,85,"Tungsten Charge M","Consists of two components: a shell of titanium and a core of tungsten atoms suspended in plasma state. Railguns launch the shell directly, while particle blasters pump the plasma into a cyclotron and process the plasma into a bolt that is then fired.",1323,1,0.050000,0.025000,0,100,0,1100,1,108,0.070000,0,8,1323,422,726985);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (225,85,"Iridium Charge M","Consists of two components: a shell of titanium and a core of iridium atoms suspended in plasma state. Railguns launch the shell directly, while particle blasters pump the plasma into a cyclotron and process the plasma into a bolt that is then fired.   ",1318,1,0.050000,0.025000,0,100,0,1500,1,108,0.070000,0,8,1318,422,726988);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (226,85,"Lead Charge M","Consists of two components: a shell of titanium and a core of lead atoms suspended in a plasma state. Railguns launch the shell directly, while particle blasters pump the plasma into a cyclotron and process the plasma into a bolt that is then fired.   ",1320,1,0.050000,0.025000,0,100,0,1750,1,108,0.070000,0,8,1320,422,726991);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (227,85,"Thorium Charge M","Consists of two components: a shell of titanium and a core of thorium atoms suspended in plasma state. Railguns launch the shell directly, while particle blasters pump the plasma into a cyclotron and process the plasma into a bolt that is then fired.   ",1322,1,0.050000,0.025000,0,100,0,2250,1,108,0.070000,0,8,1322,422,726994);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (228,85,"Uranium Charge M","Consists of two components: a shell of titanium and a core of uranium atoms suspended in plasma state. Railguns launch the shell directly, while particle blasters pump the plasma into a cyclotron and process the plasma into a bolt that is then fired.   ",1324,1,0.050000,0.025000,0,100,0,2750,1,108,0.070000,0,8,1324,422,726997);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (229,85,"Plutonium Charge M","Consists of two components: a shell of titanium and a core of plutonium atoms suspended in plasma state. Railguns launch the shell directly, while particle blasters pump the plasma into a cyclotron and process the plasma into a bolt that is then fired.   ",1321,1,0.050000,0.025000,0,100,0,3250,1,108,0.070000,0,8,1321,422,727000);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (230,85,"Antimatter Charge M","Consists of two components: a shell of titanium and a core of antimatter atoms suspended in plasma state. Railguns launch the shell directly, while particle blasters pump the plasma into a cyclotron and process the plasma into a bolt that is then fired.   ",1317,1,0.050000,0.025000,0,100,0,4000,1,108,0.070000,0,8,1317,422,727003);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (231,85,"Iron Charge L","Consists of two components: a shell of titanium and a core of iron atoms suspended in a plasma state. Railguns launch the shell directly, while particle blasters pump the plasma into a cyclotron and process the plasma into a bolt that is then fired.     ",1327,10,0.100000,0.050000,0,100,0,2000,1,106,0.070000,0,8,1327,422,727006);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (232,85,"Tungsten Charge L","Consists of two components: a shell of titanium and a core of tungsten atoms suspended in plasma state. Railguns launch the shell directly, while particle blasters pump the plasma into a cyclotron and process the plasma into a bolt that is then fired.",1331,10,0.100000,0.050000,0,100,0,3000,1,106,0.070000,0,8,1331,422,727009);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (233,85,"Iridium Charge L","Consists of two components: a shell of titanium and a core of iridium atoms suspended in plasma state. Railguns launch the shell directly, while particle blasters pump the plasma into a cyclotron and process the plasma into a bolt that is then fired.   ",1326,10,0.100000,0.050000,0,100,0,4000,1,106,0.070000,0,8,1326,422,727012);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (234,85,"Lead Charge L","Consists of two components: a shell of titanium and a core of lead atoms suspended in a plasma state. Railguns launch the shell directly, while particle blasters pump the plasma into a cyclotron and process the plasma into a bolt that is then fired.   ",1328,10,0.100000,0.050000,0,100,0,5000,1,106,0.070000,0,8,1328,422,727015);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (235,85,"Thorium Charge L","Consists of two components: a shell of titanium and a core of thorium atoms suspended in plasma state. Railguns launch the shell directly, while particle blasters pump the plasma into a cyclotron and process the plasma into a bolt that is then fired.   ",1330,1,0.100000,0.050000,0,100,0,6000,1,106,0.070000,0,8,1330,422,727018);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (236,85,"Uranium Charge L","Consists of two components: a shell of titanium and a core of uranium atoms suspended in plasma state. Railguns launch the shell directly, while particle blasters pump the plasma into a cyclotron and process the plasma into a bolt that is then fired.   ",1332,10,0.100000,0.050000,0,100,0,7000,1,106,0.070000,0,8,1332,422,727021);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (237,85,"Plutonium Charge L","Consists of two components: a shell of titanium and a core of plutonium atoms suspended in plasma state. Railguns launch the shell directly, while particle blasters pump the plasma into a cyclotron and process the plasma into a bolt that is then fired.   ",1329,10,0.100000,0.050000,0,100,0,8000,1,106,0.070000,0,8,1329,422,727024);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (238,85,"Antimatter Charge L","Consists of two components: a shell of titanium and a core of antimatter atoms suspended in plasma state. Railguns launch the shell directly, while particle blasters pump the plasma into a cyclotron and process the plasma into a bolt that is then fired.   ",1325,10,0.100000,0.050000,0,100,0,10000,1,106,0.070000,0,8,1325,422,727027);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (239,86,"Radio S","Modulates the beam of a laser weapon into the radio frequencies. Offers greatly improved range but significantly lower damage.


With longer range, EM damage increases although the overall damage output is decreased.",1145,1,1,1,0,1,0,3000,1,102,0.070000,0,8,1145,422,7671295);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (240,86,"Microwave S","Modulates the beam of a laser weapon into the microwave frequencies. Improved range. Increased EM damage.",1143,1,1,1,0,1,0,2000,1,102,0.070000,0,8,1143,422,727033);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (241,86,"Infrared S","Modulates the beam of a laser weapon into the infrared frequencies. Slightly improved range. Slightly increased EM damage.",1144,1,1,1,0,1,0,1000,1,102,0.070000,0,8,1144,422,727036);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (242,86,"Standard S","Modulates the beam of a laser weapon into the visible light spectrum. ",1142,1,1,1,0,1,0,1230,1,102,0.070000,0,8,1142,422,727039);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (243,86,"Ultraviolet S","Modulates the beam of a laser weapon into the ultraviolet frequencies. Slightly reduced range. Slightly increased thermal damage.",1141,1,1,1,0,1,0,1500,1,102,0.070000,0,8,1141,422,727042);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (244,86,"Xray S","Modulates the beam of a laser weapon into the xray frequencies. Reduced range. Increased thermal damage.",1140,1,1,1,0,1,0,2500,1,102,0.070000,0,8,1140,422,727045);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (245,86,"Gamma S","Modulates the beam of a laser weapon into the gamma frequencies. Greatly reduced range. Greatly increased thermal damage.",1139,1,1,1,0,1,0,3500,1,102,0.070000,0,8,1139,422,727048);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (246,86,"Multifrequency S","Randomly cycles the laser through the entire spectrum. The greatly increased damage comes at the cost of a significant reduction in range.


With shorter range, Thermal damage increases and the overall damage output is increased.",1131,1,1,1,0,1,0,4000,1,102,0.070000,0,8,1131,422,8777971);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (247,86,"Radio M","Modulates the beam of a laser weapon into the radio frequencies. Offers greatly improved range but significantly lower damage.


With longer range, EM damage increases although the overall damage output is decreased.",1145,1,1,1,0,1,0,30000,1,103,0.070000,0,8,1145,422,7671294);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (248,86,"Microwave M","Modulates the beam of a laser weapon into the microwave frequencies. Improved range. ",1143,1,1,1,0,1,0,20000,1,103,0.070000,0,8,1143,422,727057);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (249,86,"Infrared M","Modulates the beam of a laser weapon into the infrared frequencies. Slightly improved range.",1144,1,1,1,0,1,0,10000,1,103,0.070000,0,8,1144,422,727060);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (250,86,"Standard M","Modulates the beam of a laser weapon into the visible light spectrum",1142,1,1,1,0,1,0,12256,1,103,0.070000,0,8,1142,422,727063);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (251,86,"Ultraviolet M","Modulates the beam of a laser weapon into the ultraviolet frequencies. Slightly reduced range. Slightly increased damage.",1141,1,1,1,0,1,0,15000,1,103,0.070000,0,8,1141,422,727066);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (252,86,"Xray M","Modulates the beam of a laser weapon into the xray frequencies. Reduced range. Increased damage.",1140,1,1,1,0,1,0,25000,1,103,0.070000,0,8,1140,422,727069);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (253,86,"Gamma M","Modulates the beam of a laser weapon into the gamma frequencies. Greatly reduced range. Greatly increased damage.",1139,1,1,1,0,1,0,35000,1,103,0.070000,0,8,1139,422,727072);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (254,86,"Multifrequency M","Randomly cycles the laser through the entire spectrum. The greatly increased damage comes at the cost of a significant reduction in range.


With shorter range, Thermal damage increases and the overall damage output is increased.",1131,1,1,1,0,1,0,40000,1,103,0.070000,0,8,1131,422,8777970);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (255,86,"Radio L","Modulates the beam of a laser weapon into the radio frequencies. Offers greatly improved range but significantly lower damage.


With longer range, EM damage increases although the overall damage output is decreased.",1145,1,1,1,0,1,0,300000,1,105,0.070000,0,8,1145,422,7671293);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (256,86,"Microwave L","Modulates the beam of a laser weapon into the microwave frequencies. Improved range. ",1143,1,1,1,0,1,0,200000,1,105,0.070000,0,8,1143,422,727081);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (257,86,"Infrared L","Modulates the beam of a laser weapon into the infrared frequencies. Slightly improved range.",1144,1,1,1,0,1,0,100000,1,105,0.070000,0,8,1144,422,727084);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (258,86,"Standard L","Modulates the beam of a laser weapon into the visible light spectrum. ",1142,1,1,1,0,1,0,124728,1,105,0.070000,0,8,1142,422,727087);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (259,86,"Ultraviolet L","Modulates the beam of a laser weapon into the ultraviolet frequencies. Slightly reduced range. Slightly increased damage.",1141,1,1,1,0,1,0,150000,1,105,0.070000,0,8,1141,422,727090);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (260,86,"Xray L","Modulates the beam of a laser weapon into the xray frequencies. Reduced range. Increased damage.",1140,1,1,1,0,1,0,250000,1,105,0.070000,0,8,1140,422,727093);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (261,86,"Gamma L","Modulates the beam of a laser weapon into the gamma frequencies. Greatly reduced range. Greatly increased damage.",1139,1,1,1,0,1,0,350000,1,105,0.070000,0,8,1139,422,727096);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (262,86,"Multifrequency L","Randomly cycles the laser through the entire spectrum. The greatly increased damage comes at the cost of a significant reduction in range.


With shorter range, Thermal damage increases and the overall damage output is increased.",1131,1,1,1,0,1,0,400000,1,105,0.070000,0,8,1131,422,8777969);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (263,87,"Cap Booster 25","Provides a quick injection of power into your capacitor. Good for tight situations!",0,0,2.500000,1,100,10,0,1000,1,139,0.070000,0,8,1033,0,9059795);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (264,87,"Cap Booster 50","Provides a quick injection of power into your capacitor. Good for tight situations!",0,0,5,2,100,10,0,2500,1,139,0.070000,0,8,1033,0,9059796);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (265,88,"Defender I","Defensive missile used to destroy incoming missiles.",192,25,10,0.015000,0,100,0,500,1,116,0.070000,0,8,192,422,727108);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (266,387,"Thorn Rocket","A small rocket with a piercing warhead.",1350,300,100,0.005000,0,100,0,240,1,922,0.070000,0,8,1350,422,727111);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (267,89,"Juggernaut Torpedo","An ultra-heavy piercing missile. Slow and dumb but its sheer damage potential is simply staggering.",1346,300,1500,0.100000,0,100,0,30000,1,923,0.070000,0,8,1346,422,727114);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (268,90,"Bomb","",0,500,10,10,0,2,0,0,1,0,0.070000,0,8,0,0,9059797);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (269,394,"Seeker F.O.F. Light Missile I","An Amarr light missile with an EMP warhead and automatic guidance system.",1336,300,700,0.015000,0,100,4,750,1,914,0.070000,0,8,1336,422,727120);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (270,92,"Python Mine","Standard mine with nuclear payload.",1007,300,1,0.150000,0,10,0,1364,0,0,0.070000,0,8,1007,0,727123);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (377,38,"Small Shield Extender I","Increases the maximum strength of the shield.",0,0,0,5,0,1,0,4992,1,605,0.070000,0,7,1044,422,9059798);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (380,38,"Small Shield Extender II","Increases the maximum strength of the shield.",0,0,0,5,0,1,0,38076,1,605,0.060000,0,7,1044,422,9059799);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (393,39,"Shield Recharger I","Improves the recharge rate of the shield.",0,1000,0,5,1,1,0,8736,1,126,0.070000,0,7,83,422,9059800);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (394,39,"Shield Recharger II","Improves the recharge rate of the shield.",0,1000,0,5,1,1,0,43258,1,126,0.060000,0,7,83,422,9059801);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (399,40,"Small Shield Booster I","Expends energy to provide a quick boost in shield strength.",0,500,0,5,0,1,0,9116,1,609,0.070000,0,7,84,422,9059802);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (400,40,"Small Shield Booster II","Expends energy to provide a quick boost in shield strength.",0,500,0,5,0,1,0,44330,1,609,0.060000,0,7,84,422,9059803);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (405,41,"Micro Shield Transporter I","Transfers shield power over to the target ship, aiding in its defense.",0,0,0,2.500000,0,1,0,1998,1,604,0.070000,0,7,86,422,9059804);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (406,41,"Micro Shield Transporter II","Transfers shield power over to the target ship, aiding in its defense.",0,0,0,2.500000,0,1,0,35736,1,604,0.060000,0,7,86,422,9059805);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (421,43,"Basic Capacitor Recharger","Increases the capacitor recharge rate.",0,0,1,5,0,1,0,9500,1,665,0.070000,0,7,90,422,9059806);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (434,46,"1MN MicroWarpdrive I","Massive boost to speed for a very short time. The thrust that boosts the ship, and the corresponding maximum velocity bonus, are limited by the mass of the ship that uses this module. The sheer amount of energy needed to power this system means that it must permanently reserve a fraction of the capacitor output just to maintain the integrity of its warp containment field, and when activated it substantially increases the ship\'s EM footprint.


Max capacitor reduced.


Frigate class module",0,0,0,10,0,1,0,31604,1,131,0.070000,0,7,10149,422,11945085);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (438,46,"1MN Afterburner II","Gives a boost to the maximum velocity of the ship when activated. The thrust that boosts the ship, and the corresponding maximum velocity bonus, are limited by the mass of the ship that uses this module.


Frigate class module",0,0,0,5,0,1,0,40566,1,542,0.060000,0,7,96,422,9059807);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (439,46,"1MN Afterburner I","Gives a boost to the maximum velocity of the ship when activated. The thrust that boosts the ship, and the corresponding maximum velocity bonus, are limited by the mass of the ship that uses this module.


Frigate class module",0,0,0,5,0,1,0,6450,1,542,0.070000,0,7,96,422,9059808);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (440,46,"1MN MicroWarpdrive II","Massive boost to speed for a very short time. The thrust that boosts the ship, and the corresponding maximum velocity bonus, are limited by the mass of the ship that uses this module. The sheer amount of energy needed to power this system means that it must permanently reserve a fraction of the capacitor output just to maintain the integrity of its warp containment field, and when activated it substantially increases the ship\'s EM footprint.


Max capacitor reduced.


Frigate class module",0,0,0,10,0,1,0,396228,1,131,0.060000,0,7,10149,422,11945086);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (442,47,"Cargo Scanner I","Scans the cargo hold of another ship.",0,0,0,5,0,1,0,1500,1,711,0.070000,0,7,106,422,9059809);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (443,48,"Ship Scanner I","Scans the target ship and provides a tactical analysis of its capabilities. The further it goes beyond scan range, the more inaccurate its results will be.",0,0,0,5,0,1,0,1984,1,713,0.070000,0,7,107,422,9059810);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (444,49,"Survey Scanner I","Scans the composition of asteroids, ice and gas clouds.",0,0,0,5,0,1,0,2000,1,714,0.070000,0,7,2732,422,9066892);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (447,52,"Warp Scrambler I","Disrupts the target ship\'s navigation computer which prevents it from warping or using a microwarpdrive.",0,0,0,5,0,1,0,39424,1,682,0.070000,0,7,3433,422,9064731);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (448,52,"Warp Scrambler II","Disrupts the target ship\'s navigation computer which prevents it from warping or using a microwarpdrive.",0,0,0,5,0,1,0,217172,1,682,0.060000,0,7,3433,422,9064732);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (450,53,"Gatling Pulse Laser I","Rapid fire multi-barreled energy weapon that delivers a steady stream of damage. 


Gamma, Infrared, Microwave, Multifrequency, Radio, Standard, Ultraviolet, Xray.",11118,0,1,5,1,1,0,2000,1,570,0.070000,0,7,350,422,13157589);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (451,53,"Dual Light Pulse Laser I","This light pulse laser uses two separate laser focusing systems to reduce the cool down period between shots. Good skirmish weapon. 


Gamma, Infrared, Microwave, Multifrequency, Radio, Standard, Ultraviolet, Xray.",11117,0,1,5,1,1,0,6000,1,570,0.070000,0,7,350,422,13157588);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (452,53,"Dual Light Beam Laser I","This light beam laser uses two separate laser focusing systems to reduce the cool down period between shots. Good short to medium range weapon. 


Gamma, Infrared, Microwave, Multifrequency, Radio, Standard, Ultraviolet, Xray.",11110,0,1,5,1,1,0,9000,1,567,0.070000,0,7,352,422,13157587);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (453,53,"Medium Pulse Laser I","A high-powered pulse laser. Good for short to medium range encounters. 


Gamma, Infrared, Microwave, Multifrequency, Radio, Standard, Ultraviolet, Xray.",11119,0,1,5,1,1,0,12000,1,570,0.070000,0,7,350,422,13157586);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (454,53,"Medium Beam Laser I","A high-powered beam laser. Good for medium range encounters. 


Gamma, Infrared, Microwave, Multifrequency, Radio, Standard, Ultraviolet, Xray.",11111,0,1,5,1,1,0,15000,1,567,0.070000,0,7,352,422,13157585);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (455,53,"Quad Light Beam Laser I","Uses four light laser focusing systems. Low powered, but makes up for it with a fast firing rate. 


Gamma, Infrared, Microwave, Multifrequency, Radio, Standard, Ultraviolet, Xray.",11109,0,1,10,1,1,0,18528,1,568,0.070000,0,7,355,422,13157584);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (456,53,"Focused Medium Pulse Laser I","A high-energy, concentrated laser designed for short to medium range engagements. 


Gamma, Infrared, Microwave, Multifrequency, Radio, Standard, Ultraviolet, Xray.",11115,0,1,10,1,1,0,60000,1,572,0.070000,0,7,356,422,13157583);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (457,53,"Focused Medium Beam Laser I","A high-energy, concentrated laser designed for medium range engagements. 


Gamma, Infrared, Microwave, Multifrequency, Radio, Standard, Ultraviolet, Xray.",11107,0,1,10,1,1,0,90000,1,568,0.070000,0,7,355,422,13157582);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (458,53,"Heavy Pulse Laser I","A heavy laser designed for short to medium range engagements. Delivers powerful damage. 


Gamma, Infrared, Microwave, Multifrequency, Radio, Standard, Ultraviolet, Xray.",11116,0,1,25,1,1,0,120000,1,572,0.070000,0,7,356,422,13157581);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (459,53,"Heavy Beam Laser I","A high-energy heavy laser designed for medium range engagements. Delivers powerful damage. 


Gamma, Infrared, Microwave, Multifrequency, Radio, Standard, Ultraviolet, Xray.",11108,0,1,25,1,1,0,150000,1,568,0.070000,0,7,355,422,13157580);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (460,53,"Dual Heavy Pulse Laser I","This heavy pulse laser uses two separate laser focusing systems to reduce the cool down period between shots. A great weapon for medium to long range encounters. 


Gamma, Infrared, Microwave, Multifrequency, Radio, Standard, Ultraviolet, Xray.",11113,0,1,20,1,1,0,200000,1,573,0.070000,0,7,360,422,13157579);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (461,53,"Dual Heavy Beam Laser I","This heavy beam laser uses two separate laser focusing systems to reduce the cool down period between shots. A great weapon for medium to long range encounters. 


Gamma, Infrared, Microwave, Multifrequency, Radio, Standard, Ultraviolet, Xray.",11043,0,1,50,1,1,0,600000,1,569,0.070000,0,7,361,422,13157578);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (462,53,"Mega Pulse Laser I","A super-heavy pulse laser designed for medium range engagements. 


Gamma, Infrared, Microwave, Multifrequency, Radio, Standard, Ultraviolet, Xray.",11114,0,1,50,1,1,0,900000,1,573,0.070000,0,7,360,422,13157577);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (463,53,"Mega Beam Laser I","A super-heavy beam laser designed for medium to long range engagements. 


Gamma, Infrared, Microwave, Multifrequency, Radio, Standard, Ultraviolet, Xray.",11105,0,1,50,1,1,0,1.2e+006,1,569,0.070000,0,7,361,422,13157576);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (464,53,"Tachyon Beam Laser I","An ultra-heavy beam laser designed for medium to long range engagements. 


Gamma, Infrared, Microwave, Multifrequency, Radio, Standard, Ultraviolet, Xray.",11106,0,1,50,1,1,0,1.5e+006,1,569,0.070000,0,7,361,422,13157575);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (482,54,"Miner II","Has an improved technology beam, making the extraction process more efficient. Useful for extracting all but the rarest ore.",11273,25,0,5,0,1,0,79128,1,1039,0.060000,0,7,1061,422,13157389);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (483,54,"Miner I","Basic mining laser. Extracts common ore quickly, but has difficulty with the more rare types.",11146,25,0,5,0,1,0,9272,1,1039,0.070000,0,7,1061,422,13157390);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (484,55,"125mm Gatling AutoCannon I","This multi-barrel autocannon is designed for skirmish warfare. 


Carbonized Lead, Depleted Uranium, EMP, Fusion, Nuclear, Phased Plasma, Proton, or Titanium Sabot.",11161,2000,750,5,0.500000,1,0,2000,1,574,0.070000,0,7,387,422,13157401);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (485,55,"150mm Light AutoCannon I","A simple but effective close combat autocannon. 


Carbonized Lead, Depleted Uranium, EMP, Fusion, Nuclear, Phased Plasma, Proton, or Titanium Sabot.",11162,20,20,5,0.400000,1,0,6000,1,574,0.070000,0,7,387,422,13157402);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (486,55,"200mm AutoCannon I","A powerful autocannon that can smash apart most lightly armored frigates with ease. 


Carbonized Lead, Depleted Uranium, EMP, Fusion, Nuclear, Phased Plasma, Proton, or Titanium Sabot.",11163,20,15,5,0.300000,1,0,9000,1,574,0.070000,0,7,387,422,13157403);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (487,55,"250mm Light Artillery Cannon I","This artillery is one of the most powerful weapons that can be mounted on a frigate. 


Carbonized Lead, Depleted Uranium, EMP, Fusion, Nuclear, Phased Plasma, Proton, or Titanium Sabot.",11152,20,4,5,0.100000,1,0,12000,1,577,0.070000,0,7,389,422,13157404);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (488,55,"280mm Howitzer Artillery I","Rocket-assisted artillery projectiles designed for longe-range combat. It is the most powerful projectile weapon able to be fitted onto frigates. 


Carbonized Lead, Depleted Uranium, EMP, Fusion, Nuclear, Phased Plasma, Proton, or Titanium Sabot.",11153,20,5,5,0.050000,1,0,15000,1,577,0.070000,0,7,389,422,13157405);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (489,55,"Dual 180mm AutoCannon I","This dual 180mm autocannon is a simple but effective close combat weapon. 


Carbonized Lead, Depleted Uranium, EMP, Fusion, Nuclear, Phased Plasma, Proton, or Titanium Sabot.",11158,20,12.500000,10,2.500000,1,0,20000,1,575,0.070000,0,7,386,422,13157622);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (490,55,"220mm Vulcan AutoCannon I","The 220mm multi-barrel autocannon is designed for skirmish warfare. 


Carbonized Lead, Depleted Uranium, EMP, Fusion, Nuclear, Phased Plasma, Proton, or Titanium Sabot.",11159,20,12,10,2,1,0,60000,1,575,0.070000,0,7,386,422,13157406);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (491,55,"425mm AutoCannon I","The 425mm is a behemoth that will inflict severe damage on most cruisers and frigates in short-range battles. 


Carbonized Lead, Depleted Uranium, EMP, Fusion, Nuclear, Phased Plasma, Proton, or Titanium Sabot.",11160,20,8,10,1.500000,1,0,90000,1,575,0.070000,0,7,386,422,13157407);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (492,55,"650mm Artillery Cannon I","A powerful long-range cannon. One of the most damaging weapons mountable on a cruiser. 


Carbonized Lead, Depleted Uranium, EMP, Fusion, Nuclear, Phased Plasma, Proton, or Titanium Sabot.",11150,200,125,25,0.500000,1,0,120000,1,578,0.070000,0,7,384,422,13149744);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (493,55,"720mm Howitzer Artillery I","This 720mm rocket-assisted howitzer is designed for long-range bombardment. 


Carbonized Lead, Depleted Uranium, EMP, Fusion, Nuclear, Phased Plasma, Proton, or Titanium Sabot.",11151,200,50,25,0.250000,1,0,150000,1,578,0.070000,0,7,384,422,13157408);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (494,55,"Dual 425mm AutoCannon I","Combines the damage output of two 425mm intermediate-range autocannons. 


Carbonized Lead, Depleted Uranium, EMP, Fusion, Nuclear, Phased Plasma, Proton, or Titanium Sabot.",11155,200,200,20,5,1,0,200000,1,576,0.070000,0,7,381,422,13157610);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (495,55,"Dual 650mm Repeating Artillery I","Powerful, intermediate-range repeating artillery cannon with a decent rate of fire. 


Carbonized Lead, Depleted Uranium, EMP, Fusion, Nuclear, Phased Plasma, Proton, or Titanium Sabot.",11156,2000,2000,50,4,1,0,600000,1,576,0.070000,0,7,381,422,13157596);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (496,55,"800mm Repeating Artillery I","A four-barreled, intermediate-range, powerful cannon capable of causing tremendous damage. 


Carbonized Lead, Depleted Uranium, EMP, Fusion, Nuclear, Phased Plasma, Proton, or Titanium Sabot.",11157,200,75,25,3,1,0,900000,1,576,0.070000,0,7,381,422,13157605);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (497,55,"1200mm Artillery Cannon I","One of the most powerful projectile cannons a battleship can equip. 


Carbonized Lead, Depleted Uranium, EMP, Fusion, Nuclear, Phased Plasma, Proton, or Titanium Sabot.",11148,2000,750,50,1,1,0,1.2e+006,1,579,0.070000,0,7,379,422,13157409);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (498,55,"1400mm Howitzer Artillery I","The ultimate artillery cannon. It hurls death and destruction over incredible distances. 


Carbonized Lead, Depleted Uranium, EMP, Fusion, Nuclear, Phased Plasma, Proton, or Titanium Sabot.",11149,2000,1500,50,0.500000,1,0,1.5e+006,1,579,0.070000,0,7,379,422,13157410);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (499,509,"Standard Missile Launcher I","Favored by many for its average capacity and firing rate. Useful in both fast attack raids and longer battles.


Bloodclaw, Flameburst, Piranha, Sabretooth, or their F.O.F variants; Exterminator, Firefly, Seeker, Serpent.

",168,0,0,5,0.600000,1,0,6000,1,640,0.070000,0,7,168,422,727276);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (501,510,"Heavy Missile Launcher I","Designed for long engagements between medium sized ships. Slow firing rate, but makes up for it with a large missile capacity.


Havoc, Scourge, Thunderbolt, Widowmaker or their F.O.F. variants: Eradicator, Hellhound, Hydra, Stalker.",169,0,0,10,0.900000,1,0,30000,1,642,0.070000,0,7,169,422,727279);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (503,508,"Siege Missile Launcher I","A massive launcher designed for extended bombardments of hard targets like battleships and stations. Contains a huge missile capacity, but has a slow firing rate and trouble targeting small, fast ships.


Bane, Inferno, Juggernaut, Mjolnir.",170,0,0,20,1.500000,1,0,99996,1,644,0.070000,0,7,170,422,727282);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (506,767,"Basic Capacitor Power Relay","Increases capacitor recharge rate at the expense of shield boosting.",0,500,20,5,0,1,0,4864,1,667,0.070000,0,7,90,422,9064619);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (508,770,"Basic Shield Flux Coil","Increases shield recharge rate while lowering the maximum shield capacity.",0,500,20,5,0,1,0,1664,1,687,0.070000,0,7,83,422,9059811);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (509,768,"Basic Capacitor Flux Coil","Increases capacitor recharge rate, but causes a reduction in maximum capacitor storage.  ",0,500,20,5,0,1,0,1664,1,666,0.070000,0,7,90,422,9059812);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (518,59,"Basic Gyrostabilizer","Gives a bonus to the speed and damage of projectile turrets. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,0,1,0,9728,1,646,0.070000,0,7,1046,422,9059813);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (519,59,"Gyrostabilizer II","Gives a bonus to the speed and damage of projectile turrets. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,0,1,0,95108,1,646,0.060000,0,7,1046,422,9059814);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (520,59,"Gyrostabilizer I","Gives a bonus to the speed and damage of projectile turrets. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,0,1,0,24320,1,646,0.070000,0,7,1046,422,9059815);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (521,60,"Basic Damage Control","Utilizes a combination of containment field emitters and redundancy systems to prevent critical system damage. 


Grants a bonus to resistance for shield, armor and hull.

Only one Damage Control can be activated at a given time.",0,0,5000,5,0,1,0,2000,1,615,0.070000,0,7,77,422,9064911);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (522,61,"Micro Capacitor Battery I","Increases capacitor storage.",0,500,0,2.500000,0,1,0,4000,1,702,0.070000,0,7,89,422,9059816);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (523,62,"Small Armor Repairer I","This module uses nano-assemblers to repair damage done to the armor of the ship.",0,0,500,5,0,1,0,20000,1,1049,0.070000,0,7,80,422,9059817);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (524,63,"Small Hull Repairer I","Makes use of nano-assembler technology in order to repair damage done to the structure.",0,0,1000,12.500000,0,1,0,49998,1,1053,0.070000,0,7,80,422,9059818);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (526,65,"Stasis Webifier I","Reduces the maximum speed of a ship by employing micro energy streams which effectively entangle the target temporarily, thereby slowing it down.",0,500,0,5,0,1,0,22488,1,683,0.070000,0,7,1284,422,9059819);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (527,65,"Stasis Webifier II","Reduces the maximum speed of a ship by employing micro energy streams which effectively entangle the target temporarily, thereby slowing it down.",0,500,0,5,0,1,0,190098,1,683,0.060000,0,7,1284,422,9059820);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (529,67,"Small Energy Transfer Array I","Transfers capacitor energy to another ship.",0,1000,1000,25,0,1,0,30000,1,695,0.070000,0,7,1035,422,13175436);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (530,68,"Small Nosferatu I","Drains energy from the target ship and adds it to your own.


a Nosferatu module will not drain your target\'s capacitor below your own capacitor percentage level.",0,0,1000,5,0,1,0,39504,1,692,0.070000,0,7,1029,422,9065493);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (533,71,"Small Energy Neutralizer I","Neutralizes a portion of the energy in the target ship\'s capacitor.",0,0,2000,5,0,1,0,28160,1,689,0.070000,0,7,1283,422,9059822);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (561,74,"75mm Gatling Rail I","A small multi-barreled railgun for frigates. Railguns use magnetic rails to fire solid chunks of matter at hypersonic speed. The accurate range of railguns is very good, but due to technical limitations it cannot use onboard guidance. This results in a fairly rapid drop in accuracy at extreme ranges. 


Antimatter, Iridium, Iron, Lead, Plutonium, Thorium, Tungsten, Uranium.",11140,10,200,5,1,1,0,2000,1,564,0.070000,0,7,349,422,13157699);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (562,74,"Light Electron Blaster I","Particle blasters operate on a similar principle as the railgun except they fire a magnetically contained ball of subatomic particles. No other turret class can match the sheer destructive power of particle blasters, but due to the rapid dispersion of the containment field, it also has the worst range of all turrets. 


Antimatter, Iridium, Iron, Lead, Plutonium, Thorium, Tungsten, Uranium.",11127,10,150,5,1,1,0,6000,1,561,0.070000,0,7,376,422,13157700);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (563,74,"Light Ion Blaster I","Particle blasters operate on a similar principle as the railgun except they fire a magnetically contained ball of subatomic particles. No other turret class can match the sheer destructive power of particle blasters, but due to the rapid dispersion of the containment field, it also has the worst range of all turrets. 


Antimatter, Iridium, Iron, Lead, Plutonium, Thorium, Tungsten, Uranium.",11128,10,175,5,0.600000,1,0,9000,1,561,0.070000,0,7,376,422,13157701);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (564,74,"Light Neutron Blaster I","Particle blasters operate on a similar principle as the railgun except they fire a magnetically contained ball of subatomic particles. No other turret class can match the sheer destructive power of particle blasters, but due to the rapid dispersion of the containment field, it also has the worst range of all turrets. 


Antimatter, Iridium, Iron, Lead, Plutonium, Thorium, Tungsten, Uranium.",11129,10,80,5,0.400000,1,0,12000,1,561,0.070000,0,7,376,422,13157702);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (565,74,"150mm Railgun I","This is a standard long-range railgun designed for frigates. Railguns use magnetic rails to fire solid chunks of matter at hypersonic speed. The accurate range of railguns is very good, but due to technical limitations it cannot use onboard guidance. This results in a fairly rapid drop in accuracy at extreme ranges. 


Antimatter, Iridium, Iron, Lead, Plutonium, Thorium, Tungsten, Uranium.",11139,10,50,5,0.200000,1,0,15000,1,564,0.070000,0,7,349,422,13157703);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (566,74,"Heavy Electron Blaster I","Particle blasters operate on a similar principle as the railgun except they fire a magnetically contained ball of subatomic particles. No other turret class can match the sheer destructive power of particle blasters, but due to the rapid dispersion of the containment field, it also has the worst range of all turrets. 


Antimatter, Iridium, Iron, Lead, Plutonium, Thorium, Tungsten, Uranium.",11124,100,2000,10,5,1,0,60000,1,562,0.070000,0,7,371,422,13157704);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (567,74,"Dual 150mm Railgun I","This cruiser-sized weapon is a double-barreled version of the frigate class 150mm railgun. Railguns use magnetic rails to fire solid chunks of matter at hypersonic speed. The accurate range of railguns is very good, but due to technical limitations it cannot use onboard guidance. This results in a fairly rapid drop in accuracy at extreme ranges. 


Antimatter, Iridium, Iron, Lead, Plutonium, Thorium, Tungsten, Uranium.",11135,100,175,10,4,1,0,20000,1,565,0.070000,0,7,370,422,13157705);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (568,74,"Heavy Neutron Blaster I","Particle blasters operate on a similar principle as the railgun except they fire a magnetically contained ball of subatomic particles. No other turret class can match the sheer destructive power of particle blasters, but due to the rapid dispersion of the containment field, it also has the worst range of all turrets. 


Antimatter, Iridium, Iron, Lead, Plutonium, Thorium, Tungsten, Uranium.",11126,100,100,25,2,1,0,120000,1,562,0.070000,0,7,371,422,13157858);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (569,74,"Heavy Ion Blaster I","Particle blasters operate on a similar principle as the railgun except they fire a magnetically contained ball of subatomic particles. No other turret class can match the sheer destructive power of particle blasters, but due to the rapid dispersion of the containment field, it also has the worst range of all turrets. 


Antimatter, Iridium, Iron, Lead, Plutonium, Thorium, Tungsten, Uranium.",11125,100,125,10,3,1,0,90000,1,562,0.070000,0,7,371,422,13157706);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (570,74,"250mm Railgun I","Cruiser-sized large barrel turret. Railguns use magnetic rails to fire solid chunks of matter at hypersonic speed. The accurate range of railguns is very good, but due to technical limitations it cannot use onboard guidance. This results in a fairly rapid drop in accuracy at extreme ranges. 


Antimatter, Iridium, Iron, Lead, Plutonium, Thorium, Tungsten, Uranium.",11137,100,50,25,1,1,0,150000,1,565,0.070000,0,7,370,422,13157707);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (571,74,"Electron Blaster Cannon I","Particle blasters operate on a similar principle as the railgun except they fire a magnetically contained ball of subatomic particles. No other turret class can match the sheer destructive power of particle blasters, but due to the rapid dispersion of the containment field, it also has the worst range of all turrets. 


Antimatter, Iridium, Iron, Lead, Plutonium, Thorium, Tungsten, Uranium.",11121,1000,400,50,10,1,0,600000,1,563,0.070000,0,7,365,422,13157708);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (572,74,"Dual 250mm Railgun I","This battleship-sized weapon is a double-barreled version of the cruiser class 250mm railgun. Railguns use magnetic rails to fire solid chunks of matter at hypersonic speed. The accurate range of railguns is very good, but due to technical limitations it cannot use onboard guidance. This results in a fairly rapid drop in accuracy at extreme ranges. 


Antimatter, Iridium, Iron, Lead, Plutonium, Thorium, Tungsten, Uranium.",11132,1000,1500,20,8,1,0,199998,1,566,0.070000,0,7,366,422,13157709);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (573,74,"Neutron Blaster Cannon I","Particle blasters operate on a similar principle as the railgun except they fire a magnetically contained ball of subatomic particles. No other turret class can match the sheer destructive power of particle blasters, but due to the rapid dispersion of the containment field, it also has the worst range of all turrets. 


Antimatter, Iridium, Iron, Lead, Plutonium, Thorium, Tungsten, Uranium.",11123,1000,1000,50,4,1,0,1.2e+006,1,563,0.070000,0,7,365,422,13210345);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (574,74,"425mm Railgun I","This large battleship-sized weapon packs quite a punch. Railguns use magnetic rails to fire solid chunks of matter at hypersonic speed. The accurate range of railguns is very good, but due to technical limitations it cannot use onboard guidance. This results in a fairly rapid drop in accuracy at extreme ranges. 


Antimatter, Iridium, Iron, Lead, Plutonium, Thorium, Tungsten, Uranium.",11134,1000,750,50,2,1,0,1.5e+006,1,566,0.070000,0,7,366,422,13157710);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (575,74,"Ion Blaster Cannon I","Particle blasters operate on a similar principle as the railgun except they fire a magnetically contained ball of subatomic particles. No other turret class can match the sheer destructive power of particle blasters, but due to the rapid dispersion of the containment field, it also has the worst range of all turrets. 


Antimatter, Iridium, Iron, Lead, Plutonium, Thorium, Tungsten, Uranium.",11122,1000,500,50,6,1,0,900000,1,563,0.070000,0,7,365,422,13157711);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (577,76,"Medium Capacitor Booster I","Provides a quick injection of power into the capacitor.",0,0,0,10,32,1,0,28124,1,700,0.070000,0,7,1031,422,9059823);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (578,77,"Invulnerability Field I","Boosts shield resistance against all damage types. Penalty: Using more than one type of this module, or similar modules that affect the same resistance type, will result in a penalty to the boost you get on that type of resistance.",0,0,10000,20,0,1,0,75000,1,553,0.070000,0,7,81,422,9064384);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (580,80,"ECM Burst I","Emits random electronic bursts which have a chance of momentarily disrupting target locks on ships within range.


Given the unstable nature of the bursts and the amount of internal shielding needed to ensure they do not affect their own point of origin, only battleship-class vessels can use this module to its fullest extent.

Only one module of this type can be activated at the same time",0,0,5000,5,0,1,0,41664,1,678,0.070000,0,7,109,422,11791575);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (581,82,"Passive Targeter I","Uses advanced acoustical and visual targeting to identify threats. Allows target lock without alerting the ship to a possible threat.",0,0,2000,25,0,1,0,25000,1,672,0.070000,0,7,104,422,9059824);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (582,25,"Bantam","The Bantam is a strong and sturdy craft, and an extremely effective mining frigate. In addition, its large structure makes it ideal for trading and the Bantam is very popular among budding inter-stellar traders.


5% bonus to cargo capacity and 20% bonus to mining laser yield per skill level.


-60% mining laser capacitor use",38,27,1.155e+006,20000,235,1,1,23500,1,61,0.070000,0,6,0,422,11772659);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (583,25,"Condor","The Condor is fast and agile. It has limited cargo space so it\'s not very suitable for trading or mining. It is best used as an assault vessel in a hit-and-run type of operations.


5% bonus to light missile and rocket kinetic damage 10% bonus to light missile and rocket velocity per skill level.",39,33,1.185e+006,18000,150,1,1,28750,1,61,0.070000,0,6,0,422,3257026);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (584,25,"Griffin","The Griffin is much used by the Caldari Navy as a support vessel in combat squadrons, using its impressive array of electronic gadgetry to disrupt the operation of target ships, making them easy prey for traditional combat vessels.


15% bonus to ECM Target Jammer strength and 10% bonus to ECM Target Jammers\' capacitor need per level.",40,41,1.056e+006,19400,160,1,1,160000,1,61,0.070000,0,6,0,422,11772688);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (585,25,"Slasher","The Slasher is cheap, but versatile. It\'s been manufactured en masse, making it one of the most common vessels in Minmatar space. The Slasher is extremely fast, with decent armaments, and is popular amongst budding pirates and smugglers.


5% bonus to Small Projectile Turret damage and 7.5% bonus to Small Projectile Turret tracking speed per skill level.",44,31,1.15e+006,17400,120,1,2,27500,1,64,0.070000,0,6,0,422,11772711);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (586,25,"Probe","The Probe is large compared to most Minmatar frigates and is considered a good scout and cargo-runner.  Uncharacteristically for a Minmatar ship, its hard outer coating makes it difficult to destroy, while the limited weapon hardpoints force it to rely on fighter assistance if engaged in combat.




5% bonus cargo capacity per skill level
5% bonus to scan strength of probes per skill level
5% reduction to survey probe flight time per level",45,19.950000,1.123e+006,19500,320,1,2,108500,1,64,0.070000,0,6,0,422,13175421);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (587,25,"Rifter","The Rifter is a very powerful combat frigate and can easily tackle the best frigates out there. It has gone through many radical design phases since its inauguration during the Minmatar Rebellion. The Rifter has a wide variety of offensive capabilities, making it an unpredictable and deadly adversary.


5% bonus to Small Projectile Turret damage and 7.5% bonus to tracking per level.",46,31,1.067e+006,27289,130,1,2,280000,1,64,0.070000,0,6,0,422,11772709);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (588,237,"Reaper","The Reaper-class is the smallest of the Minmatar frigates, just barely reaching frigate status instead of a manned fighter. The Reaper is very cheap and is used en masse in daring hit-and-run operations by Minmatars either side of the law. Special Ability: 5% bonus to velocity per skill level.",53,38.400000,1.157e+006,15800,120,1,2,0,0,0,0.070000,0,6,0,0,2657214);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (589,25,"Executioner","The Executioner is another newly commissioned ship of the Amarr Imperial Navy. The Executioner was designed specially to counter the small, fast raider frigates of the Minmatar Republic; thus it is different from most Amarr ships in favoring speed over defenses. With the Executioner, the Amarrians have expanded their tactical capabilities on the battlefield.


10% bonus to Small Energy Turret capacitor use and 5% Small Energy Turret damage per skill level.",54,13,1.124e+006,28100,135,1,4,30000,1,72,0.070000,0,6,0,422,3257037);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (590,25,"Inquisitor","The Inquisitor is another example of how the Amarr Imperial Navy has modeled their design to counter specific tactics employed by the other empires. The Inquisitor is a fairly standard Amarr ship in most respects, having good defenses and lacking mobility. It is more Caldari-like than most Amarr ships, however, since its arsenal mostly consists of missile bays.


10% bonus to EM missile damage and 5% bonus to Explosive, Kinetic and Thermal missile damage per skill level.",55,20.500000,1.13e+006,28700,315,1,4,212500,1,72,0.070000,0,6,0,422,3257043);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (591,25,"Tormentor","The Tormentor has been in service for many decades, mainly as a mining ship. It is not big enough to cut it as a battle frigate, but as with most Amarr ships its strong defenses make it a tough opponent to crack. Exactly for this and the way it seems to be curling up on itself has given the Tormentor-class the nickname \'Armadillo\'.


5% bonus to cargo capacity and 20% bonus to mining laser yield per skill level


-60% mining laser capacitor use",56,26,1.18e+006,24398,235,1,4,24250,1,72,0.070000,0,6,0,422,11772718);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (592,25,"Navitas","The Navitas is a solid mining vessel, in wide use by independent excavators. It is also one of the best ships available for budding traders or even scavengers. The long-range scanners and sturdy outer shell of the ship help to protect the ship from harassment.


5% bonus to cargo capacity and 20% bonus to mining laser yield per skill level.


-60% mining laser capacitor use",59,35,1.221e+006,10000,215,1,8,22500,1,77,0.070000,0,6,0,422,11772704);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (593,25,"Tristan","Often nicknamed The Fat Man this nimble little frigate is mainly used by the Federation in escort duties or on short-range patrols. The Tristan has been very popular throughout Gallente space for years because of its versatility. It is rather expensive, but buyers will definitely get their money\'s worth, as the Tristan is one of the more powerful frigates available on the market.


5% bonus to Small Hybrid Turret damage and 7.5% bonus to Small Hybrid Turret tracking speed per skill level.",60,29,1.006e+006,26500,140,1,8,282500,1,77,0.070000,0,6,0,422,11772719);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (594,25,"Incursus","The Incursus is commonly found spearheading Gallentean military operations. Its speed and surprising strength make it excellent for skirmishing duties. Incursus-class ships move together in groups and can quickly and effectively gang up on ships many times their size and overwhelm them. In recent years the Incursus has increasingly found its way into the hands of pirates, who love its aggressive appearance.


10% bonus to Small Hybrid Turret falloff and 5% bonus to Small Hybrid Turret damage per skill level.",61,41,1.028e+006,29500,165,1,8,220000,1,77,0.070000,0,6,0,422,11772693);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (595,25,"Gallente Police Ship","The standard police vessel of the Gallente Federation. Renowned for its high quality equipment and loadout.",66,38,2.04e+006,20400,200,1,8,0,0,0,0.070000,0,6,0,422,727426);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (596,237,"Impairor","The Impairor-class frigate has been mass-produced by the Amarr Empire for decades. It is the most common spacevessel sighted within the Amarrian boundaries, and is used both as a basic trade vessel and as a small-scale slave transport.


10% bonus to energy turret capacitor use per skill level.",299,39,1.148e+006,28100,120,1,4,0,0,0,0.070000,0,6,0,0,2657217);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (597,25,"Punisher","The Amarr Imperial Navy has been upgrading many of its ships in recent years and adding new ones. The Punisher is one of the most recent ones and considered by many to be the best Amarr frigate in existence. As witnessed by its heavy armaments, the Punisher is mainly intended for large-scale military operations, acting in coordination with larger military vessels, but it is more than powerful enough for solo operations.


10% bonus to Small Energy Turret capacitor use and 5% bonus to armor resistances per skill level.",300,34,1.047e+006,28600,135,1,4,287500,1,72,0.070000,0,6,0,422,11772707);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (598,25,"Breacher","The Breacher\'s structure is little more than a fragile scrapheap, but the ship\'s missile launcher hardpoints and superior sensors have placed it among the most valued Minmatar frigates when it comes to long range combat.


10% bonus to Explosive missile damage and 5% bonus to EM, Kinetic and Thermal missile damage per level.",305,47,1.187e+006,20000,175,1,2,222500,1,64,0.070000,0,6,0,422,11772661);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (599,25,"Burst","The Burst is a small and fast cargo vessel. It can easily be used as a small-time miner, but requires some crunching assistance for large-scale mining operations.


5% bonus to cargo capacity and 20% bonus to mining laser yield per skill level.


-60% mining laser capacitor use",306,31,1.096e+006,17100,225,1,2,22500,1,64,0.070000,0,6,0,422,11772662);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (600,25,"Minmatar Peacekeeper Ship","Minmatar Police 1",307,62,1.2e+006,12000,80,1,2,0,0,0,0.070000,0,6,0,422,727441);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (601,237,"Ibis","The Caldari Ibis frigate is a small but stout frigate that fits admirably well as a cargo hauler or small-scale miner. Its reliability makes it a good choice for novice ship captains.


10% bonus hybrid turret optimal range per skill level.",312,47,1.163e+006,15000,120,1,1,0,0,0,0.070000,0,6,0,0,2657220);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (602,25,"Kestrel","The Kestrel is a heavy missile boat with a fairly large cargo space and one of the most sophisticated sensor arrays around. Interestingly enough, it has been used by both the Caldari Navy and several wealthy trade corporations as a cargo-hauling vessel. It is one of few trading vessels with good punching power, making it ideal for solo trade-runs in dangerous areas. The Kestrel was designed so that it could take up to four missile launchers but instead it can not be equipped with turret weapons nor mining lasers.


10% bonus to Kinetic missile damage and 5% bonus to EM, Explosive, and Thermal missile damage per level.",313,45.980000,1.163e+006,19700,305,1,1,225000,1,61,0.070000,0,6,0,422,3257044);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (603,25,"Merlin","The Merlin is the most powerful all-out combat frigate of the Caldari. It is highly valued for its versatility in using both missiles and turrets, while its defenses are exceptionally strong for a Caldari vessel.


5% bonus to shield resistances and 10% bonus to Small Hybrid Turret optimal range per skill level.",314,39,997000,16500,130,1,1,285000,1,61,0.070000,0,6,0,422,3257048);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (604,25,"Caldari Enforcer Ship","Caldari Frigate 8",315,44,1.68e+006,17400,90,1,1,0,0,0,0.070000,0,6,0,422,727453);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (605,25,"Heron","The Heron has good computer and electronic systems, giving it the option of participating in electronic warfare. But it has relatively poor defenses and limited weaponry, so it\'s more commonly used for scouting and exploration.




5% bonus kinetic missile damage per level
5% bonus to scan strength of probes per level
5% reduction to survey probe flight time per level",316,35,1.15e+006,18900,320,1,1,97250,1,61,0.070000,0,6,0,422,13175416);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (606,237,"Velator","The Velator class frigate is one of the older vessel types in the Gallente fleet. It was first deployed on the market as a fast passenger craft but the extra passenger quarters were later modified into weapon hardpoints as the newer models came to be used for small-scale security and military duties. The Velator is still a very solid mining and trading vessel.


5% bonus to hybrid turret damage per skill level.",321,40,1.148e+006,24500,120,1,8,0,0,0,0.070000,0,6,0,0,2657211);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (607,25,"Imicus","The Imicus is a slow but hard-shelled frigate, ideal for any type of scouting activity. Used by merchant, miner and combat groups, the Imicus is usually relied upon as the operation\'s eyes and ears when traversing low security sectors.




5% bonus to drone range per level
5% increase to scan strength of probes per level
5% reduction to survey probe flight time per level",322,33,997000,21500,320,1,8,100250,1,77,0.070000,0,6,0,422,13175417);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (608,25,"Atron","The Atron is a hard nugget with an advanced power conduit system, but little space for cargo. Although it is a good harvester when it comes to mining, its main ability is as a combat vessel.


10% bonus to Small Hybrid Turret falloff and 5% Small Hybrid Turret damage per skill level.",323,24,1.164e+006,22500,125,1,8,29250,1,77,0.070000,0,6,0,422,11772657);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (609,25,"Maulus","The Maulus is a high-tech vessel, specialized for electronic warfare. It is particularly valued in fleet warfare due to its optimization for sensor dampening technology.


5% bonus to Small Hybrid Turret damage and Remote Sensor Dampener effectiveness per skill level.",324,31,1.063e+006,23000,175,1,8,180000,1,77,0.070000,0,6,0,422,11772699);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (610,25,"Wraith","Little is known about Jovian vessels, safe for their technical superiority.",332,60,1e+006,13000,110,1,16,0,0,0,0.070000,0,6,0,422,727471);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (611,25,"Specter","Little is known about Jovian vessels, safe for their technical superiority.",333,38,1e+006,13400,80,1,16,0,0,0,0.070000,0,6,0,422,727474);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (612,25,"Chaos","Pirate Frigate 1",338,50,1.2e+006,16450,130,1,2,0,0,0,0.070000,0,6,0,422,727477);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (613,25,"Devourer","Pirate Frigate 2",339,43.600000,1.2e+006,19100,110,1,2,0,0,0,0.070000,0,6,0,422,727480);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (614,25,"Fury","Pirate Frigate 3",340,29.960000,1.2e+006,26000,180,1,2,0,0,0,0.070000,0,6,0,422,727483);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (615,25,"Styx","Pirate Frigate 4",341,36,1.2e+006,17400,60,1,2,0,0,0,0.070000,0,6,0,422,727486);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (616,25,"Medusa","Pirate Frigate 5",342,66.780000,1.2e+006,17500,30,1,2,0,0,0,0.070000,0,6,0,422,727489);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (617,25,"Echo","The Echo assault frigate was developed and produced by the Indocon Corporation early on in the first era of galactic conquest. Asteroid mining had become increasingly dangerous due to pirate traffic, and the first prototype of the Echo was made.",343,28,1.2e+006,17660,50,1,2,0,0,0,0.070000,0,6,0,422,727492);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (618,25,"Lynx","Pirate Frigate 7",344,64,1.2e+006,22500,200,1,2,0,0,0,0.070000,0,6,0,422,727495);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (619,25,"Swordspine","Pirate Frigate 8",345,39,1.047e+006,21120,220,1,2,0,0,0,0.070000,0,6,0,422,2656132);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (620,26,"Osprey","The Osprey offers excellent versatility and power for its low price. Designed from the top down as a cheap but complete cruiser, the Osprey utilizes the best the Caldari have to offer in state-of-the-art armor alloys, sensor technology and weaponry - all mass manufactured to ensure low price. In the constant struggle to stay ahead of the Gallente, new technology has been implemented in the field of mining laser calibration. A notable improvement in ore yields has been made, especially in the hands of a well trained pilot.


20% bonus to mining laser yield and 10% reduction in Shield Transport capacitor use per level.


500% bonus to range of shield transporters.

",41,174,1.123e+007,107000,485,1,1,2.875e+006,1,75,0.070000,0,6,0,422,11772760);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (621,26,"Caracal","The Caracal is a powerful vessel that specializes in missile deployment. It has excellent shield defenses, but poor armor plating. Its missile arsenal, when fully stocked, is capable of making a piece-meal of almost anyone.


5% bonus Kinetic Missile Damage and 10% bonus to Light, Heavy Assault and Heavy Missile Velocity per level.",42,202,1.291e+007,92000,450,1,1,4.56e+006,1,75,0.070000,0,6,0,422,11772739);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (622,26,"Stabber","The Stabber is the mainstay of the Minmatar fleet. It is light and extremely fast, yet surprisingly powerful, with a wide variety of weapons. It is one of few Minmatar vessels that have reached popularity outside Minmatar space.


5% bonus to Medium Projectile Turret firing speed and 5% bonus to max velocity per level.",47,110,1.14e+007,80000,420,1,2,4.45e+006,1,73,0.070000,0,6,0,422,11772768);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (623,26,"Moa","The Moa was designed as an all-out combat ship, and its heavy armament allows the Moa to tackle almost anything that floats in space. In contrast to its nemesis the Thorax, the Moa is most effective at long range where its railguns and missile batteries can rain death upon foes.


10% bonus to Medium Hybrid Turret optimal range and 5% bonus to shield resistance per level.

",49,166,1.172e+007,101000,250,1,1,8e+006,1,75,0.070000,0,6,0,422,11772754);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (624,26,"Maller","Quite possibly the toughest cruiser in the galaxy, the Maller is a common sight in Amarrian Imperial Navy operations. It is mainly used for military duty, although a few can be found in the private sector acting as escort ships for very important dispatches. 


10% bonus to Medium Energy Turret capacitor use and 5% bonus to all Armor Resistances per level.

",57,110,1.155e+007,118000,280,1,4,8.375e+006,1,74,0.070000,0,6,0,422,11772753);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (625,26,"Augoror","The Augoror-class cruiser is one of the old warhorses of the Amarr Empire, having seen action in both the Jovian War and the Minmatar Rebellion. It is mainly used by the Amarrians for escort and scouting duties where frigates are deemed too weak. Like most Amarrian vessels, the Augoror depends first and foremost on its resilience and heavy armor to escape unscathed from unfriendly encounters.


10% bonus to armor hitpoints per level and 10% bonus to capacitor need of energy transfer arrays per level.


500% bonus to range of energy transfer arrays.",58,80,1.073e+007,115000,465,1,4,2.9075e+006,1,74,0.070000,0,6,0,422,11772735);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (626,26,"Vexor","The Vexor is a strong combat ship that is also geared to operate in a variety of other roles. The Vexor is especially useful for surveying in potentially hostile sectors as it can stay on duty for a very long time before having to return to base. Furthermore, it is well capable of defending itself against even concentrated attacks.


5% bonus to Medium Hybrid Turret damage and 10% bonus to drone hitpoints, damage and mining yield per skill level.


",62,110,1.031e+007,115000,480,1,8,4.3775e+006,1,76,0.070000,0,6,0,422,11772772);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (627,26,"Thorax","The Thorax-class cruiser is the latest combat ship commissioned by the Federation. While the Thorax is a very effective ship at any range, typical of modern Gallente design philosophy it is most effective when working at extreme close range where its blasters and hordes of combat drones tear through even the toughest of enemies.


5% bonus to Medium Hybrid Turret damage per level and 5% increase to MicroWarpdrive capacitor bonus per level.

",63,149,1.128e+007,112000,265,1,8,7.4e+006,1,76,0.070000,0,6,0,422,11772771);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (628,26,"Arbitrator","The Arbitrator is unusual for Amarr ships in that it\'s primarily a drone carrier. While it is not the best carrier around, it has superior armor that gives it greater durability than most ships in its class.


5% bonus to Tracking Disruptor effectiveness per skill level and 10% bonus to drone hitpoints, damage and mining yield per skill level.


",298,172,1.12e+007,120000,345,1,4,3.5375e+006,1,74,0.070000,0,6,0,422,11772730);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (629,26,"Rupture","The Rupture is slow for a Minmatar ship, but it more than makes up for it in power. The Rupture has superior firepower and is used by the Minmatar Republic both to defend space stations and other stationary objects and as part of massive attack formations.


5% bonus to Medium Projectile Turret firing speed and 5% bonus to Medium Projectile Turret damage per level.",302,88,1.165e+007,96000,300,1,2,6.875e+006,1,73,0.070000,0,6,0,422,11772764);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (630,26,"Bellicose","Being a highly versatile class of Minmatar ships, the Bellicose has been used as a combat juggernaut as well as a support ship for wings of frigates. While not quite in the league of newer navy cruisers, the Bellicose is still a very solid ship for most purposes, especially in terms of long range combat.


5% bonus to Medium Projectile Turret Rate of Fire and 7.5% bonus to target painter effectiveness per skill level.


",303,113,1.155e+007,85000,315,1,2,3.5425e+006,1,73,0.070000,0,6,0,422,11772737);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (631,26,"Scythe","The Scythe-class cruiser is the oldest Minmatar ship still in use. It has seen many battles and is an integrated part in Minmatar tales and heritage. Recent firmware upgrades \"borrowed\" from the Caldari have vastly increased the efficiency of its mining output.


20% bonus to mining laser yield and 3.5% bonus to tracking links per level.


500% bonus to range of tracking links.

",304,134,1.111e+007,89000,440,1,2,2.8775e+006,1,73,0.070000,0,6,0,422,3256984);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (632,26,"Blackbird","The Blackbird is a small high-tech cruiser newly employed by the Caldari Navy. Commonly seen in fleet battles or acting as wingman, it is not intended for head-on slugfests, but rather delicate tactical situations. 




15% bonus to ECM Target Jammer strength per level
10% bonus to ECM Target Jammer optimal range and falloff per level.

",311,139,1.319e+007,96000,305,1,1,3.5125e+006,1,75,0.070000,0,6,0,422,11772738);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (633,26,"Celestis","The Celestis cruiser is a versatile ship which can be employed in a myriad of roles, making it handy for small corporations with a limited number of ships. True to Gallente style the Celestis is especially deadly in close quarters combat due to its advanced targeting systems.


5% bonus to Medium Hybrid Turret Damage and Remote Sensor Dampener effectiveness per skill level.


",319,79,1.207e+007,116000,320,1,8,3.4575e+006,1,76,0.070000,0,6,0,422,11772741);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (634,26,"Exequror","The Exequror is a heavy cargo cruiser capable of defending itself against raiding frigates, but lacks prowess in heavier combat situations. It is mainly used in relatively peaceful areas where bulk and strength is needed without too much investment involved. 


10% bonus to Cargo Capacity and 10% bonus to capacitor need of remote armor repair system per level.


500% bonus to range of remote armor repair systems.",320,224,1.102e+007,113000,600,1,8,2.9625e+006,1,76,0.070000,0,6,0,422,11772747);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (635,26,"Opux Luxury Yacht","The Opux Luxury Yachts are normally used by the entertainment industry for pleasure tours for wealthy Gallente citizens. These Opux Luxury Yacht cruisers are rarely seen outside of Gallente controlled space, but are extremely popular within the Federation.",330,287,1.3075e+007,115000,1750,1,8,0,1,0,0.070000,0,6,0,422,9095695);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (636,26,"Ixion","Pirate Cruiser 1",336,101,1.2155e+007,99000,1600,1,2,0,0,0,0.070000,0,6,0,422,727549);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (637,26,"Ghoul","Pirate Cruiser 2",337,187,1.09e+007,109000,300,1,2,0,0,0,0.070000,0,6,0,422,727552);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (638,27,"Raven","The Raven is the powerhouse of the Caldari Navy. With its myriad launcher slots and powerful shields, few ships can rival it in strength or majesty.


5% bonus to Cruise and Siege Launcher Rate Of Fire and 10% bonus to Cruise Missile and Torpedo Velocity per level.",43,250,9.93e+007,486000,665,1,1,1.0875e+008,1,80,0.070000,0,6,0,0,3256435);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (639,27,"Tempest","The Tempest is one of the Republic Fleet\'s key vessels; a versatile gunship proficient at long-range bombardment and capable of dishing out specialized types of damage with great effectiveness.  A well-rounded squadron of Tempests has been proven time and time again to be an invaluable wild card in a fleet battle, one which opponents should ignore at their own peril.







5% bonus to Large Projectile Turret Rate of Fire per level 

5% bonus to Large Projectile Turret damage per level 
",48,250,1.033e+008,450000,600,1,2,1.0375e+008,1,78,0.070000,0,6,0,0,7147355);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (640,27,"Scorpion","The first Scorpion-class battleship was launched only a couple of years ago, and those that have been built are considered to be prototypes. Little is known of its capabilities, but what has been garnered suggests that the Scorpion is crammed to the brink with sophisticated hi-tech equipment that few can match. 




15% bonus to ECM Target Jammer strength per level
20% bonus to ECM Target Jammer optimal and falloff range per level
20% Bonus to ECM Burst Range per level",50,250,1.036e+008,468000,550,1,1,7.125e+007,1,80,0.070000,0,6,0,0,3302282);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (641,27,"Megathron","The Megathron has established itself as one of the most feared and respected battleships around. Since its first appearance almost two decades ago it has seen considerable service in the troublesome regions on the outskirts of the Federation, helping to expand and defend Gallentean influence there.


5% bonus to Large Hybrid Turret damage and 7.5% bonus to Large Hybrid Turret tracking speed per level.",64,250,9.84e+007,486000,675,1,8,1.05e+008,1,81,0.070000,0,6,0,0,3301102);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (642,27,"Apocalypse","In days past, only those in high favor with the Emperor could hope to earn the reward of commanding one of the majestic and powerful Apocalypse class battleships. In latter years, even though now in full market circulation, these golden, metallic monstrosities are still feared and respected as enduring symbols of Amarrian might.


10% bonus to Large Energy Turret capacitor use and 7.5% bonus to Large Energy Turret optimal range per level.",296,400,9.71e+007,495000,675,1,4,1.125e+008,1,79,0.070000,0,6,0,0,3301097);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (643,27,"Armageddon","The mighty Armageddon class is the main warship of the Amarr Empire. Its heavy armaments and strong front are specially designed to crash into any battle like a juggernaut and deliver swift justice in the name of the Emperor.


10% bonus to Large Energy Turret capacitor use and 5% Large Energy Turret rate of fire per level.",297,250,1.052e+008,486000,600,1,4,6.625e+007,1,79,0.070000,0,6,0,0,3301098);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (644,27,"Typhoon","Much praised by its proponents and much maligned by its detractors, the Typhoon-class battleship has always been one of the most hotly debated spacefaring vessels around. Its distinguishing aspect - and the source of most of the controversy - is its sheer versatility, variously seen as either a lack of design focus or a deliberate freedom for pilot modification.

Minmatar Battleship Skill Bonus: 5% bonus to Large Projectile Turret Rate of Fire and 5% bonus to Siege and Cruise missile launcher Rate of Fire per level",301,250,1.036e+008,414000,625,1,2,7.5e+007,1,78,0.070000,0,6,0,0,7454149);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (645,27,"Dominix","The Dominix is one of the old warhorses dating back to the Gallente-Caldari War. While no longer regarded as the king of the hill, it is by no means obsolete. Its formidable hulk and powerful weapons batteries means that anyone not in the largest and latest battleships will regret ever locking horns with it.


5% bonus to Large Hybrid Turret damage and 10% bonus to drone hitpoints and damage per skill level.


",318,250,9.71e+007,454500,600,1,8,6.25e+007,1,81,0.070000,0,6,0,0,3256420);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (647,27,"Eidolon","Little is known about Jovian vessels, safe for their technical superiority.",331,500,1e+008,441000,700,1,16,3e+006,0,0,0.070000,0,6,0,0,727579);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (648,28,"Badger","The Badger-class freighter is the main cargo-carrier for the Caldari State, particularly in long, arduous trade-runs. Its huge size and comfortable armament makes it perfectly equipped for those tasks, although the Caldari seldom let it roam alone. 


5% Bonus Cargo Capacity and Max Velocity per skill level ",51,196,1.275e+007,250000,4125,1,1,348750,1,84,0.070000,0,6,0,0,11772782);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (649,28,"Badger Mark II","The Badger Mark II is the latest version of the famous Badger, it\'s mostly used by the military or the mega corps for transports of goods of great value. The Mark II has stronger defenses and more high-tech equipment, making it one of the best freight carriers available. 


5% Bonus Cargo Capacity and Max Velocity per skill level ",52,279,1.35e+007,270000,5250,1,1,742500,1,84,0.070000,0,6,0,0,11772783);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (650,28,"Iteron","The Iteron-class cargo tugger is fast and reliable and there are many versions of it. It is equally popular among civilians and militaries alike as it\'s cheap and can be fitted in myriad different ways, allowing it to be used to freight almost anything. It is, however, quite vulnerable and needs to be protected while in unfriendly territories. 


5% Bonus Cargo Capacity and Max Velocity per skill level ",65,94.790000,1.025e+007,240000,3000,1,8,310000,1,83,0.070000,0,6,0,0,3257060);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (651,28,"Hoarder","The Hoarder is the second in line of the Minmatar industrial ships, it\'s not as strong as the Mammoth but its cargo space is very large for its price. It\'s perfect for operation in peaceful areas or when it has strong escort. 


5% Bonus Cargo Capacity and Max Velocity per skill level ",308,211,1.15e+007,240000,5100,1,2,452500,1,82,0.070000,0,6,0,0,11772785);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (652,28,"Mammoth","The Mammoth is the biggest and the strongest industrial ship of the Minmatar Republic. It was designed with aid from the Gallente Federation, making the Mammoth both large and powerful yet also nimble and technologically advanced. A very good buy. 


5% Bonus Cargo Capacity and Max Velocity per skill level ",309,617,1.25e+007,255000,5625,1,2,937500,1,82,0.070000,0,6,0,0,11772791);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (653,28,"Wreathe","The Wreathe is an old ship of the Minmatar Republic and one of the oldest ships still in usage. The design of the Wreathe is very plain, which is the main reason for its longevity, but it also makes the ship incapable of handling anything but the most mundane tasks. 


5% Bonus Cargo Capacity and Max Velocity per skill level ",310,205,1e+007,225000,3300,1,2,322500,1,82,0.070000,0,6,0,0,11772796);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (654,28,"Iteron Mark II","The Iteron-class cargo tugger is fast and reliable and there are many versions of it. It is equally popular among civilians and militaries alike as it\'s cheap and can be fitted in myriad different ways, allowing it to be used to freight almost anything. It is, however, quite vulnerable and needs to be protected while in unfriendly territories. 


5% Bonus Cargo Capacity and Max Velocity per skill level ",325,256,1.1e+007,245000,3750,1,8,342500,1,83,0.070000,0,6,0,0,3257061);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (655,28,"Iteron Mark III","The Iteron-class cargo tugger is fast and reliable and there are many versions of it. It is equally popular among civilians and militaries alike as it\'s cheap and can be fitted in myriad different ways, allowing it to be used to freight almost anything. It is, however, quite vulnerable and needs to be protected while in unfriendly territories. 


5% Bonus Cargo Capacity and Max Velocity per skill level ",326,277,1.05e+007,250000,4875,1,8,428750,1,83,0.070000,0,6,0,0,11772788);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (656,28,"Iteron Mark IV","The Iteron-class cargo tugger is fast and reliable and there are many versions of it. It is equally popular among civilians and militaries alike as it\'s cheap and can be fitted in myriad different ways, allowing it to be used to freight almost anything. It is, however, quite vulnerable and needs to be protected while in unfriendly territories. 


5% Bonus Cargo Capacity and Max Velocity per skill level ",327,149,1.125e+007,265000,5250,1,8,600000,1,83,0.070000,0,6,0,0,11772789);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (657,28,"Iteron Mark V","The Iteron-class cargo tugger is fast and reliable and there are many versions of it. It is equally popular among civilians and militaries alike as it\'s cheap and can be fitted in myriad different ways, allowing it to be used to freight almost anything. It is, however, quite vulnerable and needs to be protected while in unfriendly territories. 


5% Bonus Cargo Capacity and Max Velocity per skill level ",328,553,1.175e+007,275000,6000,1,8,1.125e+006,1,83,0.070000,0,6,0,0,3257064);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (658,28,"Visitant","Little is known about Jovian vessels, safe for their technical superiority.",334,506,1.526e+007,240000,10000,1,16,196000,0,0,0.070000,0,6,0,0,727612);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (659,29,"Capsule Home-201","",73,10,32000,1000,0,1,0,0,0,0,0.070000,0,6,73,0,7678285);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (660,29,"Capsule Home-201.7","",73,10,32000,1000,0,1,0,0,0,0,0.070000,0,6,73,0,7678286);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (661,29,"Capsule Home-601.5","",73,10,32000,1000,0,1,0,0,0,0,0.070000,0,6,73,0,7678287);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (662,29,"Capsule Home-1.401","",73,10,32000,1000,0,1,0,0,0,0,0.070000,0,6,73,0,7678282);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (663,29,"Capsule Home-1.501","",73,10,32000,1000,0,1,0,0,0,0,0.070000,0,6,73,0,7678283);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (664,29,"Capsule Home-2.201","",73,10,32000,1000,0,1,0,0,0,0,0.070000,0,6,73,0,7678284);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (665,29,"Capsule CP-100","",73,10,32000,1000,0,1,0,0,0,0,0.070000,0,6,73,0,7678277);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (666,29,"Capsule CP-100B","",73,10,32000,1000,0,1,0,0,0,0,0.070000,0,6,73,0,7678278);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (667,29,"Capsule CP-200","",73,10,32000,1000,0,1,0,0,0,0,0.070000,0,6,73,0,7678279);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (668,29,"Capsule CP-500","",73,10,32000,1000,0,1,0,0,0,0,0.070000,0,6,73,0,7678280);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (669,29,"Capsule CP-900X","",73,10,32000,1000,0,1,0,0,0,0,0.070000,0,6,73,0,7678281);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (670,29,"Capsule","Standard capsule.",73,2,32000,1000,0,1,0,0,0,0,0.070000,0,6,73,0,727648);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (671,30,"Erebus","From the formless void’s gaping maw, there springs an entity.  Not an entity such as any you can conceive of, nor I; an entity more primordial than the elements themselves, yet constantly coming into existence even as it is destroyed.  It is the Child of Chaos, the Pathway to the Next.


The darkness shall swallow the land, and in its wake there will follow a storm, as the appetite of nothing expands over the world.

From the formless void’s gaping maw, there springs an entity.

Dr. Damella Macaper
The Seven Events of the Apocalypse



100% bonus to Capital Hybrid Turret damage per level
7.5% bonus to gang members\' maximum armor HP per level
99% reduction in CPU need for Warfare Link modules
Can fit Aurora Ominae Super Weapon
Can fit Jump Portal Generator
Can fit Clone Vat Bay
Can fit 1 additional Warfare Link module per level
Immune to all forms of Electronic Warfare
",2942,7500,2.37937e+009,1.455e+008,16250,1,8,5.06998e+010,1,815,0.070000,0,6,0,0,7564465);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (672,31,"Caldari Shuttle","Caldari Shuttle",317,49,1.6e+006,5000,10,1,1,5000,1,396,0.070000,0,6,0,0,11772810);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (679,178,"Personal Nuclear Methadone Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,0,0,0,9,31,0,9059825);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (681,104,"Clone Grade Beta Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,0,0,0,9,34,0,9059826);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (682,104,"Clone Grade Gamma Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,0,0,0,9,34,0,9059827);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (683,105,"Bantam Blueprint","",38,0,0,0.010000,0,1,0,235000,1,261,0,0,9,0,422,727666);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (684,105,"Condor Blueprint","",39,0,0,0.010000,0,1,0,287500,1,261,0,0,9,0,422,727669);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (685,105,"Griffin Blueprint","",40,0,0,0.010000,0,1,0,1.6e+006,1,261,0,0,9,0,422,727672);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (686,106,"Osprey Blueprint","",41,0,0,0.010000,0,1,0,2.875e+007,1,275,0,0,9,0,422,727675);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (687,106,"Caracal Blueprint","",42,0,0,0.010000,0,1,0,4.56e+007,1,275,0,0,9,0,422,727678);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (688,107,"Raven Blueprint","",43,0,0,0.010000,0,1,0,1.0875e+009,1,280,0,0,9,0,0,727681);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (689,105,"Slasher Blueprint","",44,0,0,0.010000,0,1,0,275000,1,264,0,0,9,0,422,727684);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (690,105,"Probe Blueprint","",45,0,0,0.010000,0,1,0,1.085e+006,1,264,0,0,9,0,422,727687);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (691,105,"Rifter Blueprint","",46,0,0,0.010000,0,1,0,2.8e+006,1,264,0,0,9,0,422,727690);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (692,106,"Stabber Blueprint","",47,0,0,0.010000,0,1,0,4.45e+007,1,273,0,0,9,0,422,727693);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (693,107,"Tempest Blueprint","",48,0,0,0.010000,0,1,0,1.0375e+009,1,278,0,0,9,0,0,727696);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (745,109,"Capsule Home-201 Blueprint","",73,0,0,0.010000,0,1,0,1e+007,0,0,0,0,9,73,0,727699);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (746,109,"Capsule Home-201.7 Blueprint","",73,0,0,0.010000,0,1,0,1e+007,0,0,0,0,9,73,0,727702);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (747,109,"Capsule Home-601.5 Blueprint","",73,0,0,0.010000,0,1,0,1e+007,0,0,0,0,9,73,0,727705);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (748,109,"Capsule Home-1.401 Blueprint","",73,0,0,0.010000,0,1,0,1e+007,0,0,0,0,9,73,0,727708);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (749,109,"Capsule Home-1.501 Blueprint","",73,0,0,0.010000,0,1,0,1e+007,0,0,0,0,9,73,0,727711);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (750,109,"Capsule Home-2.201 Blueprint","",73,0,0,0.010000,0,1,0,1e+007,0,0,0,0,9,73,0,727714);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (751,109,"Capsule CP-100 Blueprint","",73,0,0,0.010000,0,1,0,1e+007,0,0,0,0,9,73,0,727717);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (752,109,"Capsule CP-100B Blueprint","",73,0,0,0.010000,0,1,0,1e+007,0,0,0,0,9,73,0,727720);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (753,109,"Capsule CP-200 Blueprint","",73,0,0,0.010000,0,1,0,1e+007,0,0,0,0,9,73,0,727723);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (754,109,"Capsule CP-500 Blueprint","",73,0,0,0.010000,0,1,0,1e+007,0,0,0,0,9,73,0,727726);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (755,109,"Capsule CP-900X Blueprint","",73,0,0,0.010000,0,1,0,1e+007,0,0,0,0,9,73,0,727729);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (784,134,"Miner II Blueprint","",1061,0,0,0.010000,0,1,0,463600,1,338,0,0,9,1061,422,727732);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (785,134,"Miner I Blueprint","",1061,0,0,0.010000,0,1,0,92720,1,338,0,0,9,1061,422,727735);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (786,136,"Standard Missile Launcher I Blueprint","",168,0,0,0.010000,0,1,0,60000,1,340,0,0,9,168,422,727738);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (788,136,"Heavy Missile Launcher I Blueprint","",169,0,0,0.010000,0,1,0,300000,1,340,0,0,9,169,422,727741);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (790,136,"Siege Missile Launcher I Blueprint","",170,0,0,0.010000,0,1,0,999960,1,340,0,0,9,170,422,727744);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (803,166,"Paradise Cruise Missile Blueprint","",182,0,1,0.010000,0,1,0,5e+006,1,317,0,0,9,182,422,727747);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (804,166,"Wrath Cruise Missile Blueprint","",183,0,1,0.010000,0,1,0,3e+006,1,317,0,0,9,183,422,727750);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (805,166,"Cataclysm Cruise Missile Blueprint","",184,0,1,0.010000,0,1,0,4e+006,1,317,0,0,9,184,422,727753);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (806,166,"Devastator Cruise Missile Blueprint","",185,0,1,0.010000,0,1,0,2.5e+006,1,317,0,0,9,185,422,727756);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (807,166,"Havoc Heavy Missile Blueprint","",186,0,1,0.010000,0,1,0,700000,1,317,0,0,9,186,422,727759);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (808,166,"Thunderbolt Heavy Missile Blueprint","",187,0,1,0.010000,0,1,0,900000,1,317,0,0,9,187,422,727762);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (809,166,"Widowmaker Heavy Missile Blueprint","",188,0,1,0.010000,0,1,0,800000,1,317,0,0,9,188,422,727765);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (810,166,"Scourge Heavy Missile Blueprint","",189,0,1,0.010000,0,1,0,750000,1,317,0,0,9,189,422,727768);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (811,166,"Bloodclaw Light Missile Blueprint","",190,0,1,0.010000,0,1,0,150000,1,317,0,0,9,190,422,727771);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (812,166,"Flameburst Light Missile Blueprint","",191,0,1,0.010000,0,1,0,160000,1,317,0,0,9,191,422,727774);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (813,166,"Sabretooth Light Missile Blueprint","",192,0,1,0.010000,0,1,0,180000,1,317,0,0,9,192,422,727777);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (814,166,"Piranha Light Missile Blueprint","",193,0,1,0.010000,0,1,0,140000,1,317,0,0,9,193,422,727780);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (817,109,"Capsule Blueprint","",73,0,0,0.010000,0,1,0,1e+007,0,0,0,0,9,73,0,727783);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (819,135,"125mm Gatling AutoCannon I Blueprint","",393,0,0,0.010000,0,1,0,20000,1,296,0,0,9,387,422,727786);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (820,135,"150mm Light AutoCannon I Blueprint","",392,0,0,0.010000,0,1,0,60000,1,296,0,0,9,387,422,727789);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (821,135,"200mm AutoCannon I Blueprint","",391,0,0,0.010000,0,1,0,90000,1,296,0,0,9,387,422,727792);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (822,135,"250mm Light Artillery Cannon I Blueprint","",390,0,0,0.010000,0,1,0,120000,1,296,0,0,9,389,422,727795);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (823,135,"280mm Howitzer Artillery I Blueprint","",390,0,0,0.010000,0,1,0,150000,1,296,0,0,9,389,422,727798);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (824,135,"Dual 180mm AutoCannon I Blueprint","",388,0,0,0.010000,0,1,0,200000,1,297,0,0,9,386,422,727801);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (825,135,"220mm Vulcan AutoCannon I Blueprint","",391,0,0,0.010000,0,1,0,600000,1,297,0,0,9,387,422,727804);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (826,135,"425mm AutoCannon I Blueprint","",386,0,0,0.010000,0,1,0,900000,1,297,0,0,9,386,422,727807);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (827,135,"650mm Artillery Cannon I Blueprint","",385,0,0,0.010000,0,1,0,1.2e+006,1,297,0,0,9,384,422,727810);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (828,135,"720mm Howitzer Artillery I Blueprint","",385,0,0,0.010000,0,1,0,1.5e+006,1,297,0,0,9,384,422,727813);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (829,135,"Dual 425mm AutoCannon I Blueprint","",383,0,0,0.010000,0,1,0,2e+006,1,298,0,0,9,381,422,727816);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (830,135,"Dual 650mm Repeating Artillery I Blueprint","",382,0,0,0.010000,0,1,0,6e+006,1,298,0,0,9,381,422,727819);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (831,135,"800mm Repeating Artillery I Blueprint","",381,0,0,0.010000,0,1,0,9e+006,1,298,0,0,9,381,422,727822);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (832,135,"1200mm Artillery Cannon I Blueprint","",380,0,0,0.010000,0,1,0,1.2e+007,1,298,0,0,9,379,422,727825);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (833,135,"1400mm Howitzer Artillery I Blueprint","",380,0,0,0.010000,0,1,0,1.5e+007,1,298,0,0,9,379,422,727828);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (834,133,"Gatling Pulse Laser I Blueprint","",350,0,0,0.010000,0,1,0,20000,1,292,0,0,9,350,422,727831);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (835,133,"Dual Light Pulse Laser I Blueprint","",351,0,0,0.010000,0,1,0,60000,1,292,0,0,9,350,422,727834);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (836,133,"Dual Light Beam Laser I Blueprint","",352,0,0,0.010000,0,1,0,90000,1,292,0,0,9,352,422,727837);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (837,133,"Medium Pulse Laser I Blueprint","",353,0,0,0.010000,0,1,0,120000,1,292,0,0,9,350,422,727840);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (838,133,"Medium Beam Laser I Blueprint","",354,0,0,0.010000,0,1,0,150000,1,292,0,0,9,352,422,727843);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (839,133,"Quad Light Beam Laser I Blueprint","",355,0,0,0.010000,0,1,0,185280,1,293,0,0,9,355,422,727846);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (840,133,"Focused Medium Pulse Laser I Blueprint","",356,0,0,0.010000,0,1,0,600000,1,293,0,0,9,356,422,727849);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (841,133,"Focused Medium Beam Laser I Blueprint","",357,0,0,0.010000,0,1,0,900000,1,293,0,0,9,355,422,727852);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (842,133,"Heavy Pulse Laser I Blueprint","",358,0,0,0.010000,0,1,0,1.2e+006,1,293,0,0,9,356,422,727855);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (843,133,"Heavy Beam Laser I Blueprint","",359,0,0,0.010000,0,1,0,1.5e+006,1,293,0,0,9,355,422,727858);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (844,133,"Dual Heavy Pulse Laser I Blueprint","",360,0,0,0.010000,0,1,0,2e+006,1,295,0,0,9,360,422,727861);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (845,133,"Dual Heavy Beam Laser I Blueprint","",361,0,0,0.010000,0,1,0,6e+006,1,295,0,0,9,361,422,727864);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (846,133,"Mega Pulse Laser I Blueprint","",362,0,0,0.010000,0,1,0,9e+006,1,295,0,0,9,360,422,727867);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (847,133,"Mega Beam Laser I Blueprint","",363,0,0,0.010000,0,1,0,1.2e+007,1,295,0,0,9,361,422,727870);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (848,133,"Tachyon Beam Laser I Blueprint","",364,0,0,0.010000,0,1,0,1.5e+007,1,295,0,0,9,361,422,727873);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (879,165,"Carbonized Lead S Blueprint","",1308,0,0,0.010000,0,1,0,20000,1,313,0,0,9,1004,0,727876);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (880,165,"Nuclear S Blueprint","",1288,0,0,0.010000,0,1,0,30000,1,313,0,0,9,1288,0,727879);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (881,165,"Proton S Blueprint","",1290,0,0,0.010000,0,1,0,40000,1,313,0,0,9,1290,0,727882);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (882,165,"Depleted Uranium S Blueprint","",1285,0,0,0.010000,0,1,0,50000,1,313,0,0,9,1285,0,727885);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (883,165,"Titanium Sabot S Blueprint","",1291,0,0,0.010000,0,1,0,60000,1,313,0,0,9,1291,0,727888);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (884,165,"Fusion S Blueprint","",1287,0,0,0.010000,0,1,0,70000,1,313,0,0,9,1287,0,727891);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (885,165,"Phased Plasma S Blueprint","",1289,0,0,0.010000,0,1,0,80000,1,313,0,0,9,1289,0,727894);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (886,165,"EMP S Blueprint","",1286,0,0,0.010000,0,1,0,100000,1,313,0,0,9,1286,0,727897);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (887,165,"Carbonized Lead M Blueprint","",1292,0,0,0.010000,0,1,0,80000,1,312,0,0,9,1292,0,727900);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (888,165,"Nuclear M Blueprint","",1296,0,0,0.010000,0,1,0,120000,1,312,0,0,9,1296,0,727903);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (889,165,"Proton M Blueprint","",1298,0,0,0.010000,0,1,0,165000,1,312,0,0,9,1298,0,727906);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (890,165,"Depleted Uranium M Blueprint","",1293,0,0,0.010000,0,1,0,205000,1,312,0,0,9,1293,0,727909);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (891,165,"Titanium Sabot M Blueprint","",1299,0,0,0.010000,0,1,0,235000,1,312,0,0,9,1299,0,727912);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (892,165,"Fusion M Blueprint","",1295,0,0,0.010000,0,1,0,275000,1,312,0,0,9,1295,0,727915);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (893,165,"Phased Plasma M Blueprint","",1297,0,0,0.010000,0,1,0,325000,1,312,0,0,9,1297,0,727918);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (894,165,"EMP M Blueprint","",1294,0,0,0.010000,0,1,0,400000,1,312,0,0,9,1294,0,727921);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (895,165,"Carbonized Lead L Blueprint","",1300,0,0,0.010000,0,1,0,200000,1,309,0,0,9,1300,0,727924);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (896,165,"Nuclear L Blueprint","",1304,0,0,0.010000,0,1,0,300000,1,309,0,0,9,1304,0,727927);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (897,165,"Proton L Blueprint","",1306,0,0,0.010000,0,1,0,400000,1,309,0,0,9,1306,0,727930);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (898,165,"Depleted Uranium L Blueprint","",1301,0,0,0.010000,0,1,0,500000,1,309,0,0,9,1301,0,727933);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (899,165,"Titanium Sabot L Blueprint","",1307,0,0,0.010000,0,1,0,600000,1,309,0,0,9,1307,0,727936);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (900,165,"Fusion L Blueprint","",1303,0,0,0.010000,0,1,0,700000,1,309,0,0,9,1303,0,727939);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (901,165,"Phased Plasma L Blueprint","",1305,0,0,0.010000,0,1,0,800000,1,309,0,0,9,1305,0,727942);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (902,165,"EMP L Blueprint","",1302,0,0,0.010000,0,1,0,1e+006,1,309,0,0,9,1302,0,727945);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (935,105,"Reaper Blueprint","",53,0,0,0.010000,0,1,0,1e+007,0,0,0,0,9,0,422,727948);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (936,105,"Executioner Blueprint","",54,0,0,0.010000,0,1,0,300000,1,272,0,0,9,0,422,727951);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (937,105,"Inquisitor Blueprint","",55,0,0,0.010000,0,1,0,2.125e+006,1,272,0,0,9,0,422,727954);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (938,105,"Tormentor Blueprint","",56,0,0,0.010000,0,1,0,242500,1,272,0,0,9,0,422,727957);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (939,105,"Navitas Blueprint","",59,0,0,0.010000,0,1,0,225000,1,277,0,0,9,0,422,727960);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (940,105,"Tristan Blueprint","",60,0,0,0.010000,0,1,0,2.825e+006,1,277,0,0,9,0,422,727963);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (941,105,"Incursus Blueprint","",61,0,0,0.010000,0,1,0,2.2e+006,1,277,0,0,9,0,422,727966);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (943,105,"Impairor Blueprint","",299,0,0,0.010000,0,1,0,1e+007,0,0,0,0,9,0,422,727969);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (944,105,"Punisher Blueprint","",300,0,0,0.010000,0,1,0,2.875e+006,1,272,0,0,9,0,422,727972);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (945,105,"Breacher Blueprint","",305,0,0,0.010000,0,1,0,2.225e+006,1,264,0,0,9,0,422,727975);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (946,105,"Burst Blueprint","",306,0,0,0.010000,0,1,0,225000,1,264,0,0,9,0,422,727978);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (947,105,"Minmatar Peacekeeper Ship Blueprint","",307,0,0,0.010000,0,1,0,1e+007,0,0,0,0,9,0,422,727981);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (948,105,"Ibis Blueprint","",312,0,0,0.010000,0,1,0,1e+007,0,0,0,0,9,0,422,727984);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (949,105,"Kestrel Blueprint","",313,0,0,0.010000,0,1,0,2.25e+006,1,261,0,0,9,0,422,727987);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (950,105,"Merlin Blueprint","",314,0,0,0.010000,0,1,0,2.85e+006,1,261,0,0,9,0,422,727990);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (951,105,"Caldari Enforcer Ship Blueprint","",315,0,0,0.010000,0,1,0,1e+007,0,0,0,0,9,0,422,727993);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (952,105,"Heron Blueprint","",316,0,0,0.010000,0,1,0,972500,1,261,0,0,9,0,422,727996);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (953,105,"Velator Blueprint","",321,0,0,0.010000,0,1,0,1e+007,0,0,0,0,9,0,422,727999);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (954,105,"Imicus Blueprint","",322,0,0,0.010000,0,1,0,1.0025e+006,1,277,0,0,9,0,422,728002);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (955,105,"Atron Blueprint","",323,0,0,0.010000,0,1,0,292500,1,277,0,0,9,0,422,728005);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (956,105,"Maulus Blueprint","",324,0,0,0.010000,0,1,0,1.8e+006,1,277,0,0,9,0,422,728008);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (957,105,"Wraith Blueprint","",332,0,0,0.010000,0,1,0,1e+007,0,0,0,0,9,0,422,728011);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (958,105,"Specter Blueprint","",333,0,0,0.010000,0,1,0,1e+007,0,0,0,0,9,0,422,728014);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (959,105,"Chaos Blueprint","",338,0,0,0.010000,0,1,2,1e+007,0,0,0,0,9,0,422,728017);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (960,105,"Devourer Blueprint","",339,0,0,0.010000,0,1,2,1e+007,0,0,0,0,9,0,422,728020);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (961,105,"Fury Blueprint","",340,0,0,0.010000,0,1,2,1e+007,0,0,0,0,9,0,422,728023);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (962,105,"Styx Blueprint","",341,0,0,0.010000,0,1,2,1e+007,0,0,0,0,9,0,422,728026);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (963,105,"Medusa Blueprint","",342,0,0,0.010000,0,1,2,1e+007,0,0,0,0,9,0,422,728029);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (964,105,"Echo Blueprint","",343,0,0,0.010000,0,1,2,1e+007,0,0,0,0,9,0,422,728032);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (965,105,"Lynx Blueprint","",344,0,0,0.010000,0,1,2,1e+007,0,0,0,0,9,0,422,728035);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (966,105,"Swordspine Blueprint","",345,0,0,0.010000,0,1,2,1e+007,0,0,0,0,9,0,422,728038);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (967,111,"Caldari Shuttle Blueprint","",317,0,0,0.010000,0,1,0,50000,1,416,0,0,9,0,0,728041);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (968,106,"Moa Blueprint","",49,0,0,0.010000,0,1,0,8e+007,1,275,0,0,9,0,422,728044);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (969,106,"Maller Blueprint","",57,0,0,0.010000,0,1,0,8.375e+007,1,274,0,0,9,0,422,728047);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (970,106,"Augoror Blueprint","",58,0,0,0.010000,0,1,0,2.9075e+007,1,274,0,0,9,0,422,728050);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (971,106,"Vexor Blueprint","",62,0,0,0.010000,0,1,0,4.3775e+007,1,276,0,0,9,0,422,728053);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (972,106,"Thorax Blueprint","",63,0,0,0.010000,0,1,0,7.4e+007,1,276,0,0,9,0,422,728056);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (973,106,"Arbitrator Blueprint","",1748,0,0,0.010000,0,1,0,3.5375e+007,1,274,0,0,9,0,422,728059);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (974,106,"Rupture Blueprint","",302,0,0,0.010000,0,1,0,6.875e+007,1,273,0,0,9,0,422,728062);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (975,106,"Bellicose Blueprint","",303,0,0,0.010000,0,1,0,3.5425e+007,1,273,0,0,9,0,422,728065);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (976,106,"Scythe Blueprint","",304,0,0,0.010000,0,1,0,2.8775e+007,1,273,0,0,9,0,422,728068);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (977,106,"Blackbird Blueprint","",311,0,0,0.010000,0,1,0,3.5125e+007,1,275,0,0,9,0,422,728071);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (978,106,"Celestis Blueprint","",319,0,0,0.010000,0,1,0,3.4575e+007,1,276,0,0,9,0,422,728074);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (979,106,"Exequror Blueprint","",320,0,0,0.010000,0,1,0,2.9625e+007,1,276,0,0,9,0,422,728077);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (981,106,"Ixion Blueprint","",336,0,0,0.010000,0,1,2,1e+007,0,0,0,0,9,0,422,728080);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (982,106,"Ghoul Blueprint","",337,0,0,0.010000,0,1,2,1e+007,0,0,0,0,9,0,422,728083);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (983,108,"Badger Blueprint","",51,0,0,0.010000,0,1,0,3.4875e+006,1,284,0,0,9,0,0,728086);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (984,108,"Badger Mark II Blueprint","",52,0,0,0.010000,0,1,0,7.425e+006,1,284,0,0,9,0,0,728089);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (985,108,"Iteron Blueprint","",65,0,0,0.010000,0,1,0,3.1e+006,1,283,0,0,9,0,0,728092);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (986,108,"Hoarder Blueprint","",308,0,0,0.010000,0,1,0,4.525e+006,1,282,0,0,9,0,0,728095);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (987,108,"Mammoth Blueprint","",309,0,0,0.010000,0,1,0,9.375e+006,1,282,0,0,9,0,0,728098);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (988,108,"Wreathe Blueprint","",310,0,0,0.010000,0,1,0,3.225e+006,1,282,0,0,9,0,0,728101);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (989,108,"Iteron Mark II Blueprint","",325,0,0,0.010000,0,1,0,3.425e+006,1,283,0,0,9,0,0,728104);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (990,108,"Iteron Mark III Blueprint","",326,0,0,0.010000,0,1,0,6e+006,1,283,0,0,9,0,0,728107);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (991,108,"Iteron Mark IV Blueprint","",327,0,0,0.010000,0,1,0,4.2875e+006,1,283,0,0,9,0,0,728110);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (992,108,"Iteron Mark V Blueprint","",328,0,0,0.010000,0,1,0,1.125e+007,1,283,0,0,9,0,0,728113);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (993,108,"Visitant Blueprint","",334,0,0,0.010000,0,1,0,1e+007,0,0,0,0,9,0,0,728116);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (994,107,"Scorpion Blueprint","",50,0,0,0.010000,0,1,0,7.125e+008,1,280,0,0,9,0,0,728119);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (995,107,"Megathron Blueprint","",64,0,0,0.010000,0,1,0,1.05e+009,1,281,0,0,9,0,0,728122);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (996,107,"Apocalypse Blueprint","",296,0,0,0.010000,0,1,0,1.125e+009,1,279,0,0,9,0,0,728125);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (997,107,"Armageddon Blueprint","",297,0,0,0.010000,0,1,0,6.625e+008,1,279,0,0,9,0,0,728128);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (998,107,"Typhoon Blueprint","",301,0,0,0.010000,0,1,0,7.5e+008,1,278,0,0,9,0,0,728131);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (999,107,"Dominix Blueprint","",318,0,0,0.010000,0,1,0,6.25e+008,1,281,0,0,9,0,0,728134);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1001,107,"Eidolon Blueprint","",331,0,0,0.010000,0,1,0,1e+007,0,0,0,0,9,0,0,728137);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1002,110,"Erebus Blueprint","",329,0,0,0.010000,0,1,0,7.25e+010,1,886,0,0,9,0,0,728140);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1010,118,"Small Shield Extender I Blueprint","",0,0,0,0.010000,0,1,0,49920,1,326,0,0,9,1044,422,9059828);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1013,118,"Small Shield Extender II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,326,0,0,9,1044,422,9059829);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1026,119,"Shield Recharger I Blueprint","",0,0,0,0.010000,0,1,0,87360,1,326,0,0,9,83,422,9059830);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1027,119,"Shield Recharger II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,326,0,0,9,83,422,9059831);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1032,120,"Small Shield Booster I Blueprint","",0,0,0,0.010000,0,1,0,91160,1,328,0,0,9,84,422,9059832);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1033,120,"Small Shield Booster II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,0,0,0,9,84,422,9059833);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1067,126,"1MN MicroWarpdrive I Blueprint","",0,0,0,0.010000,0,1,0,316360,1,331,0,0,9,96,422,9059834);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1071,126,"1MN Afterburner II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,331,0,0,9,96,422,9059835);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1072,126,"1MN Afterburner I Blueprint","",0,0,0,0.010000,0,1,0,64500,1,331,0,0,9,96,422,9059836);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1073,126,"1MN MicroWarpdrive II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,331,0,0,9,96,422,9059837);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1074,127,"Cargo Scanner I Blueprint","",0,0,0,0.010000,0,1,0,15000,1,325,0,0,9,106,422,9059838);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1075,128,"Ship Scanner I Blueprint","",0,0,0,0.010000,0,1,0,19840,1,325,0,0,9,107,422,9059839);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1076,129,"Survey Scanner I Blueprint","",0,0,0,0.010000,0,1,0,20000,1,325,0,0,9,107,422,9059840);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1079,132,"Warp Scrambler I Blueprint","",0,0,0,0.010000,0,1,0,394240,1,323,0,0,9,111,422,9059841);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1080,132,"Warp Scrambler II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,0,0,0,9,111,422,9059842);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1095,139,"Gyrostabilizer II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,343,0,0,9,1046,422,9059843);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1096,139,"Gyrostabilizer I Blueprint","",0,0,0,0.010000,0,1,0,243200,1,343,0,0,9,1046,422,9059844);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1099,142,"Small Armor Repairer I Blueprint","",0,0,0,0.010000,0,1,0,200000,1,334,0,0,9,80,422,9059845);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1100,143,"Small Hull Repairer I Blueprint","",0,0,0,0.010000,0,1,0,499980,1,334,0,0,9,21,422,9059846);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1102,145,"Stasis Webifier I Blueprint","",0,0,0,0.010000,0,1,0,224880,1,323,0,0,9,1284,422,9059847);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1103,145,"Stasis Webifier II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,0,0,0,9,1284,422,9059848);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1105,147,"Small Energy Transfer Array I Blueprint","",0,0,0,0.010000,0,1,0,125000,1,329,0,0,9,1035,422,9059849);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1106,148,"Small Nosferatu I Blueprint","",0,0,0,0.010000,0,1,0,395040,1,329,0,0,9,1029,422,9059850);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1109,151,"Small Energy Neutralizer I Blueprint","",0,0,0,0.010000,0,1,0,199680,1,329,0,0,9,1283,422,9059851);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1112,154,"75mm Gatling Rail I Blueprint","",349,0,0,0.010000,0,1,0,20000,1,291,0,0,9,349,422,728215);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1113,154,"Light Electron Blaster I Blueprint","",378,0,0,0.010000,0,1,0,60000,1,291,0,0,9,376,422,728218);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1114,154,"Light Ion Blaster I Blueprint","",377,0,0,0.010000,0,1,0,90000,1,291,0,0,9,376,422,728221);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1115,154,"Light Neutron Blaster I Blueprint","",376,0,0,0.010000,0,1,0,120000,1,291,0,0,9,376,422,728224);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1116,154,"150mm Railgun I Blueprint","",375,0,0,0.010000,0,1,0,150000,1,291,0,0,9,349,422,728227);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1117,154,"Heavy Electron Blaster I Blueprint","",374,0,0,0.010000,0,1,0,600000,1,290,0,0,9,371,422,728230);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1118,154,"Dual 150mm Railgun I Blueprint","",373,0,0,0.010000,0,1,0,200000,1,290,0,0,9,370,422,728233);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1119,154,"Heavy Neutron Blaster I Blueprint","",372,0,0,0.010000,0,1,0,1.2e+006,1,290,0,0,9,371,422,728236);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1120,154,"Heavy Ion Blaster I Blueprint","",371,0,0,0.010000,0,1,0,900000,1,290,0,0,9,371,422,728239);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1121,154,"250mm Railgun I Blueprint","",370,0,0,0.010000,0,1,0,1.5e+006,1,290,0,0,9,370,422,728242);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1122,154,"Electron Blaster Cannon I Blueprint","",369,0,0,0.010000,0,1,0,6e+006,1,289,0,0,9,365,422,728245);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1123,154,"Dual 250mm Railgun I Blueprint","",368,0,0,0.010000,0,1,0,2e+006,1,289,0,0,9,366,422,728248);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1124,154,"Neutron Blaster Cannon I Blueprint","",367,0,0,0.010000,0,1,0,1.2e+007,1,289,0,0,9,365,422,728251);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1125,154,"425mm Railgun I Blueprint","",366,0,0,0.010000,0,1,0,1.5e+007,1,289,0,0,9,366,422,728254);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1126,154,"Ion Blaster Cannon I Blueprint","",365,0,0,0.010000,0,1,0,9e+006,1,289,0,0,9,365,422,728257);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1128,156,"Medium Capacitor Booster I Blueprint","",0,0,0,0.010000,0,1,0,281240,1,329,0,0,9,1031,422,9059852);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1129,157,"Invulnerability Field I Blueprint","",0,0,0,0.010000,0,1,0,750000,1,328,0,0,9,81,422,9059853);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1130,167,"Iron Charge S Blueprint","",1311,0,0,0.010000,0,1,0,20000,1,307,0,0,9,1311,0,728266);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1131,167,"Tungsten Charge S Blueprint","",1315,0,0,0.010000,0,1,0,30000,1,307,0,0,9,1315,0,728269);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1132,167,"Iridium Charge S Blueprint","",1310,0,0,0.010000,0,1,0,40000,1,307,0,0,9,1310,0,728272);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1133,167,"Lead Charge S Blueprint","",1312,0,0,0.010000,0,1,0,50000,1,307,0,0,9,1312,0,728275);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1134,167,"Thorium Charge S Blueprint","",1314,0,0,0.010000,0,1,0,60000,1,307,0,0,9,1314,0,728278);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1135,167,"Uranium Charge S Blueprint","",1316,0,0,0.010000,0,1,0,70000,1,307,0,0,9,1316,0,728281);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1136,167,"Plutonium Charge S Blueprint","",1313,0,0,0.010000,0,1,0,80000,1,307,0,0,9,1313,0,728284);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1137,167,"Antimatter Charge S Blueprint","",1047,0,0,0.010000,0,1,0,100000,1,307,0,0,9,1047,0,728287);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1138,167,"Iron Charge M Blueprint","",1319,0,0,0.010000,0,1,0,80000,1,308,0,0,9,1319,0,728290);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1139,167,"Tungsten Charge M Blueprint","",1323,0,0,0.010000,0,1,0,110000,1,308,0,0,9,1323,0,728293);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1140,167,"Iridium Charge M Blueprint","",1318,0,0,0.010000,0,1,0,150000,1,308,0,0,9,1318,0,728296);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1141,167,"Lead Charge M Blueprint","",1320,0,0,0.010000,0,1,0,175000,1,308,0,0,9,1320,0,728299);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1142,167,"Thorium Charge M Blueprint","",1322,0,0,0.010000,0,1,0,225000,1,308,0,0,9,1322,0,728302);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1143,167,"Uranium Charge M Blueprint","",1324,0,0,0.010000,0,1,0,275000,1,308,0,0,9,1324,0,728305);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1144,167,"Plutonium Charge M Blueprint","",1321,0,0,0.010000,0,1,0,325000,1,308,0,0,9,1321,0,728308);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1145,167,"Antimatter Charge M Blueprint","",1317,0,0,0.010000,0,1,0,400000,1,308,0,0,9,1317,0,728311);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1146,167,"Iron Charge L Blueprint","",1327,0,0,0.010000,0,1,0,200000,1,306,0,0,9,1327,0,728314);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1147,167,"Tungsten Charge L Blueprint","",1331,0,0,0.010000,0,1,0,300000,1,306,0,0,9,1331,0,728317);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1148,167,"Iridium Charge L Blueprint","",1326,0,0,0.010000,0,1,0,400000,1,306,0,0,9,1326,0,728320);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1149,167,"Lead Charge L Blueprint","",1328,0,0,0.010000,0,1,0,500000,1,306,0,0,9,1328,0,728323);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1150,167,"Thorium Charge L Blueprint","",1330,0,0,0.010000,0,1,0,600000,1,306,0,0,9,1330,0,728326);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1151,167,"Uranium Charge L Blueprint","",1332,0,0,0.010000,0,1,0,700000,1,306,0,0,9,1332,0,728329);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1152,167,"Plutonium Charge L Blueprint","",1329,0,0,0.010000,0,1,0,800000,1,306,0,0,9,1329,0,728332);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1153,167,"Antimatter Charge L Blueprint","",1325,0,0,0.010000,0,1,0,1e+006,1,306,0,0,9,1325,0,728335);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1154,168,"Radio S Blueprint","",1145,0,0,0.010000,0,1,0,30000,1,302,0,0,9,1145,0,728338);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1155,168,"Microwave S Blueprint","",1143,0,0,0.010000,0,1,0,20000,1,302,0,0,9,1143,0,728341);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1156,168,"Infrared S Blueprint","",1144,0,0,0.010000,0,1,0,10000,1,302,0,0,9,1144,0,728344);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1157,168,"Standard S Blueprint","",1142,0,0,0.010000,0,1,0,12500,1,302,0,0,9,1142,0,728347);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1158,168,"Ultraviolet S Blueprint","",1141,0,0,0.010000,0,1,0,15000,1,302,0,0,9,1141,0,728350);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1159,168,"Xray S Blueprint","",1140,0,0,0.010000,0,1,0,25000,1,302,0,0,9,1140,0,728353);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1160,168,"Gamma S Blueprint","",1139,0,0,0.010000,0,1,0,35000,1,302,0,0,9,1139,0,728356);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1161,168,"Multifrequency S Blueprint","",1131,0,0,0.010000,0,1,0,40000,1,302,0,0,9,1131,0,728359);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1162,168,"Radio M Blueprint","",1145,0,0,0.010000,0,1,0,300000,1,303,0,0,9,1145,0,728362);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1163,168,"Microwave M Blueprint","",1143,0,0,0.010000,0,1,0,200000,1,303,0,0,9,1143,0,728365);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1164,168,"Infrared M Blueprint","",1144,0,0,0.010000,0,1,0,100000,1,303,0,0,9,1144,0,728368);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1165,168,"Standard M Blueprint","",1142,0,0,0.010000,0,1,0,125000,1,303,0,0,9,1142,0,728371);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1166,168,"Ultraviolet M Blueprint","",1141,0,0,0.010000,0,1,0,150000,1,303,0,0,9,1141,0,728374);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1167,168,"Xray M Blueprint","",1140,0,0,0.010000,0,1,0,250000,1,303,0,0,9,1140,0,728377);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1168,168,"Gamma M Blueprint","",1139,0,0,0.010000,0,1,0,350000,1,303,0,0,9,1139,0,728380);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1169,168,"Multifrequency M Blueprint","",1131,0,0,0.010000,0,1,0,400000,1,303,0,0,9,1131,0,728383);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1170,168,"Radio L Blueprint","",1145,0,0,0.010000,0,1,0,3e+006,1,305,0,0,9,1145,0,728386);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1171,168,"Microwave L Blueprint","",1143,0,0,0.010000,0,1,0,2e+006,1,305,0,0,9,1143,0,728389);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1172,168,"Infrared L Blueprint","",1144,0,0,0.010000,0,1,0,1e+006,1,305,0,0,9,1144,0,728392);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1173,168,"Standard L Blueprint","",1142,0,0,0.010000,0,1,0,1.25e+006,1,305,0,0,9,1142,0,728395);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1174,168,"Ultraviolet L Blueprint","",1141,0,0,0.010000,0,1,0,1.5e+006,1,305,0,0,9,1141,0,728398);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1175,168,"Xray L Blueprint","",1140,0,0,0.010000,0,1,0,2.5e+006,1,305,0,0,9,1140,0,728401);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1176,168,"Gamma L Blueprint","",1139,0,0,0.010000,0,1,0,3.5e+006,1,305,0,0,9,1139,0,728404);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1177,168,"Multifrequency L Blueprint","",1131,0,0,0.010000,0,1,0,4e+006,1,305,0,0,9,1131,0,728407);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1178,169,"Cap Booster 25 Blueprint","",0,0,0,0.010000,0,1,0,100000,1,339,0,0,9,1033,0,9059854);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1179,169,"Cap Booster 50 Blueprint","",0,0,0,0.010000,0,1,0,250000,1,339,0,0,9,1033,0,9059855);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1182,96,"Auto Targeting System I","Targets any hostile ship within range on activation. Grants a +2 bonus to ship\'s max targets when online",0,0,30,5,0,1,0,2944,1,670,0.070000,0,7,104,422,9059856);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1183,62,"Small Armor Repairer II","This module uses nano-assemblers to repair damage done to the armor of the ship.",0,0,500,5,0,1,0,70168,1,1049,0.060000,0,7,80,422,9059857);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1184,142,"Small Armor Repairer II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,0,0,0,9,80,422,9059858);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1185,61,"Small Capacitor Battery I","Increases capacitor storage.",0,500,0,5,0,1,0,10000,1,703,0.070000,0,7,89,422,9059859);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1186,141,"Small Capacitor Battery I Blueprint","",0,0,0,0.010000,0,1,0,100000,1,327,0,0,9,89,422,9059860);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1187,97,"Proximity Drone","",1006,45,100000,1,0,1,4,2,0,0,0.070000,0,18,0,0,728431);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1188,68,"Nosferatu II","Drains energy from the target ship and adds it to your own.


a Nosferatu module will not drain your target\'s capacitor below your own capacitor percentage level.",0,0,1400,5,0,1,0,177746,1,0,0.060000,0,7,1029,422,9065486);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1190,67,"Small Energy Transfer Array II","Transfers capacitor energy to another ship.",0,2000,10000,5,0,1,0,140108,1,695,0.060000,0,7,1035,422,13175437);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1191,147,"Small Energy Transfer Array II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,0,0,0,9,1035,422,9059862);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1192,764,"Basic Overdrive Injector System","This unit increases engine power at the expense of cargo capacity.


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,25,50,5,0,1,0,10000,1,1087,0.070000,0,7,98,422,9059863);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1193,98,"Basic Reflective Plating","An array of microscopic reactive prizms that disperse electromagnetic radiation. Grants a bonus to EM resistance. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,10,1,5,0,1,0,1984,1,540,0.070000,0,7,1030,422,9059864);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1194,99,"Amarr Sentry Gun","Sentry guns are placed around important space facilities and will attack anyone threatening the place they\'ve been assigned to defend. Sentry guns are very powerful compared to their ease of purchase and deployment. ",1006,45,1000,1000,1000,1,4,0,0,0,0,0,11,0,0,728449);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1195,43,"Cap Recharger I","Increases the capacitor recharge rate.",0,0,1,5,0,1,0,23750,1,665,0.060000,0,7,90,422,9059865);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1196,123,"Cap Recharger I Blueprint","",0,0,0,0.010000,0,1,0,237500,1,327,0,0,9,90,422,9059866);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1197,98,"Reflective Plating I","An array of microscopic reactive prisms that disperse electromagnetic radiation. Grants a bonus to EM resistance. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,10,1,5,0,1,0,4974,1,540,0.070000,0,7,1030,422,9059867);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1198,98,"Reflective Plating II","An array of microscopic reactive prisms that disperse electromagnetic radiation. Grants a bonus to EM resistance. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,10,1,5,0,1,0,38748,1,540,0.060000,0,7,1030,422,9059868);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1201,100,"Wasp I","Heavy Attack Drone",1079,35,10000,25,0,1,1,50000,1,839,0.070000,0,18,0,422,9431782);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1202,101,"Civilian Mining Drone","Civilian Mining Drone",1009,5,0,5,0,1,0,14986,1,158,0.070000,0,18,0,422,9431814);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1204,163,"Reflective Plating I Blueprint","",0,0,0,0.010000,0,1,0,49740,1,333,0,0,9,1030,422,9059869);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1205,163,"Reflective Plating II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,333,0,0,9,1030,422,9059870);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1208,162,"Auto Targeting System I Blueprint","",0,0,0,0.010000,0,1,0,29440,1,324,0,0,9,104,422,9059871);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1210,160,"ECM Burst I Blueprint","",0,0,0,0.010000,0,1,0,416640,1,323,0,0,9,109,422,9059872);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1212,161,"Passive Targeter I Blueprint","",0,0,0,0.010000,0,1,0,250000,1,324,0,0,9,104,422,9059873);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1213,172,"Bomb Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,0,0,0,9,21,0,9059874);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1214,176,"Wasp I Blueprint","",1079,0,0,0.010000,0,1,0,5e+006,1,359,0,0,9,0,422,728488);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1215,170,"Defender I Blueprint","",192,0,0,0.010000,0,1,0,150000,1,316,0,0,9,192,0,728491);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1216,166,"Seeker F.O.F. Light Missile I Blueprint","",1336,0,1,0.010000,0,1,0,180000,1,315,0,0,9,1336,422,728494);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1217,174,"Python Mine Blueprint","",1007,0,0,0.010000,0,1,0,136400,0,0,0,0,9,1007,0,728497);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1218,177,"Civilian Mining Drone Blueprint","Civilian Mining Drone Blueprint",1009,0,0,0.010000,0,1,0,1.4986e+006,1,358,0,0,9,0,422,728500);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1219,175,"Proximity Drone Blueprint","",1006,0,0,0.010000,0,1,0,1e+007,0,0,0,0,9,0,0,728503);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1220,166,"Thorn Rocket Blueprint","",1350,0,1,0.010000,0,1,0,45000,1,318,0,0,9,1350,422,728506);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1221,166,"Juggernaut Torpedo Blueprint","",1346,0,1,0.010000,0,1,0,9e+006,1,390,0,0,9,1346,422,728509);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1223,451,"Bistot","Bistot is a very valuable ore as it holds large portions of two of the rarest minerals in the universe, megacyte and zydrine. The portion size for refining is 200 ore units.",1273,1,99999999999999997000000000000000000.000000,16,0,200,0,2.09237e+006,1,514,0,0,25,1273,0,2815588);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1224,459,"Pyroxeres","Pyroxeres is an interesting ore type, as it is very plain in most respects except one - deep core refining yields a little bit of nocxium, increasing its value considerably. It also has a large portion of tritanium and some pyerite and mexallon. 333 ore units are needed to refine.",231,1,99999999999999997000000000000000000.000000,0.300000,0,333,0,11632,1,515,0,0,25,231,0,7533469);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1225,452,"Crokite","Crokite is a very heavy ore that is always in high demand because it has the largest ratio of zydrine for any ore in the universe. It requires 250 ore units to refine. ",1272,1,99999999999999997000000000000000000.000000,16,0,250,0,1.52796e+006,1,521,0,0,25,1272,0,728518);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1226,456,"Jaspet","Jaspet has many mineral types, making it easy to sell. It has a large portion of mexallon plus some tritanium, pyerite, nocxium and zydrine. It has a portion size of 500 ore units for refining.",1279,1,99999999999999997000000000000000000.000000,2,0,500,0,169582,1,529,0,0,25,1279,0,7453410);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1227,469,"Omber","Omber is a common ore that is still an excellent ore for novice miners as it has a sizeable portion of isogen, as well as some tritanium and pyerite. A few trips of mining this and a novice is quick to rise in status. 500 ore units are needed for refining.",1271,1,99999999999999997000000000000000000.000000,0.600000,0,500,0,40894,1,526,0,0,25,1271,0,728524);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1228,460,"Scordite","Scordite is amongst the most common ore types in the known universe. It has a large portion of tritanium plus a fair bit of pyerite. Good choice for those starting their mining careers. 333 ore units are needed for refining.",1356,1,99999999999999997000000000000000000.000000,0.150000,0,333,0,4994,1,519,0,0,25,1356,0,2815631);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1229,467,"Gneiss","Gneiss is a popular ore type because it holds a bit of many minerals, increasing its utility value. It has a little something of tritanium, mexallon, isogen and zydrine. It has a portion size of 400 ore units for refining.",1377,1,99999999999999997000000000000000000.000000,5,0,400,0,399926,1,525,0,0,25,1377,0,728530);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1230,462,"Veldspar","The most common ore type in the known universe, Veldspar can be found almost everywhere. It is still in constant demand as it holds a large portion of the much-used tritanium mineral. It requires 333 ore units to refine.",232,1,4000,0.100000,0,333,0,2000,1,518,0,0,25,232,0,2815639);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1231,455,"Hemorphite","With a large portion of nocxium the Hemorphite is always a good find. It is common enough that even novice miners can expect to run into it. Hemorphite also has a bit of tritanium, pyerite, mexallon and isogen as well as trace amounts of Zydrine. It requires 500 ore units to refine.",1282,1,99999999999999997000000000000000000.000000,3,0,500,0,306868,1,528,0,0,25,1282,0,8836337);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1232,453,"Dark Ochre","Dark Ochre was for years ignored as a worthwhile ore to mine until improved refining techniques managed to extract the huge amount of nocxium inside it, the highest ratio of nocxium found in any ore in the universe. 400 ore units of Dark Ochre are needed to refine it.",1275,1,99999999999999997000000000000000000.000000,8,0,400,0,768500,1,522,0,0,25,1275,0,2815586);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1233,25,"Enigma","The mysterious Enigma.",1010,38,1e+006,20400,600,1,2,0,0,0,0.070000,0,6,0,422,728542);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1236,764,"Overdrive Injector System II","This monster unit vastly increases engine power at the expense of cargo capacity.


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,100,100,5,0,1,0,114688,1,1087,0.060000,0,7,98,422,9059875);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1237,158,"Overdrive Injector System II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,0,0,0,9,98,422,9059876);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1240,78,"Basic Reinforced Bulkheads","Increases structural hit points while reducing agility and overall top speed.",0,100,200,5,0,1,0,5000,1,1195,0.070000,0,7,76,422,9065505);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1242,763,"Basic Nanofiber Internal Structure","Replaces some of the heavier structure components with lighter, but more fragile material. Increases ship\'s velocity and improves maneuverability at the expense of hull strength.


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,50,100,5,0,1,0,1664,1,1196,0.070000,0,7,1042,422,9065516);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1244,764,"Overdrive Injector System I","This monster unit vastly increases engine power at the expense of cargo capacity.


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,50,50,5,0,1,0,24998,1,1087,0.060000,0,7,98,422,9059877);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1245,158,"Overdrive Injector System I Blueprint","",0,0,0,0.010000,0,1,0,249980,1,332,0,0,9,98,422,9059878);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1246,768,"Capacitor Flux Coil I","Increases capacitor recharge rate, but causes a reduction in maximum capacitor storage.  ",0,500,20,5,0,1,0,4160,1,666,0.060000,0,7,90,422,9059879);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1247,137,"Capacitor Flux Coil I Blueprint","",0,0,0,0.010000,0,1,0,41600,1,327,0,0,9,90,422,9059880);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1248,768,"Capacitor Flux Coil II","Increases capacitor recharge rate, but causes a reduction in maximum capacitor storage.  ",0,500,20,5,0,1,0,37672,1,666,0.050000,0,7,90,422,9059881);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1249,137,"Capacitor Flux Coil II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,0,0,0,9,90,422,9059882);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1254,770,"Shield Flux Coil I","Increases shield recharge rate while lowering the maximum shield capacity.",0,500,20,5,0,1,0,4160,1,687,0.060000,0,7,83,422,9059883);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1255,137,"Shield Flux Coil I Blueprint","",0,0,0,0.010000,0,1,0,41600,1,326,0,0,9,83,422,9059884);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1256,770,"Shield Flux Coil II","Increases shield recharge rate while lowering the maximum shield capacity.",0,500,20,5,0,1,0,38056,1,687,0.050000,0,7,83,422,9059885);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1257,137,"Shield Flux Coil II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,0,0,0,9,83,422,9059886);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1262,98,"Basic Reactive Plating","An array of microscopic reactive bombs that are exploded to counter explosive damage. Grants a bonus to explosive resistance. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,10,1,5,0,1,0,1984,1,540,0.070000,0,7,1030,422,9059887);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1264,98,"Reactive Plating I","An array of microscopic reactive bombs that are exploded to counter explosive damage. Grants a bonus to explosive resistance. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,10,1,5,0,1,0,4974,1,540,0.070000,0,7,1030,422,9059888);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1265,163,"Reactive Plating I Blueprint","",0,0,0,0.010000,0,1,0,49740,1,333,0,0,9,1030,422,9059889);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1266,98,"Reactive Plating II","An array of microscopic reactive bombs that are exploded to counter explosive damage. Grants a bonus to explosive resistance. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,10,1,5,0,1,0,38288,1,540,0.060000,0,7,1030,422,9059890);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1267,163,"Reactive Plating II Blueprint","",0,0,0,0.010000,0,1,0,179200,1,333,0,0,9,1030,422,9059891);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1272,98,"Basic Regenerative Plating","This plating attempts to seal holes in the armor thus effectively increasing its hit points. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,10,1,5,0,1,0,1984,1,540,0.070000,0,7,1030,422,9059892);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1274,98,"Regenerative Plating I","This plating attempts to seal holes in the armor thus effectively increasing its hit points. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,10,1,5,0,1,0,4974,1,540,0.070000,0,7,1030,422,9059893);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1275,163,"Regenerative Plating I Blueprint","",0,0,0,0.010000,0,1,0,49740,1,333,0,0,9,1030,422,9059894);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1276,98,"Regenerative Plating II","This plating attempts to seal holes in the armor thus effectively increasing its hit points. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,10,1,5,0,1,0,38978,1,540,0.060000,0,7,1030,422,9059895);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1277,163,"Regenerative Plating II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,333,0,0,9,1030,422,9059896);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1282,98,"Basic Magnetic Plating","This plating utilizes a magnetic field to deflect kinetic attacks. Grants a bonus to kinetic resistance. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,10,1,5,0,1,0,1984,1,540,0.070000,0,7,1030,422,9059897);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1284,98,"Magnetic Plating I","This plating utilizes a magnetic field to deflect kinetic attacks. Grants a bonus to kinetic resistance. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,10,1,5,0,1,0,4974,1,540,0.070000,0,7,1030,422,9059898);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1285,163,"Magnetic Plating I Blueprint","",0,0,0,0.010000,0,1,0,49740,1,333,0,0,9,1030,422,9059899);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1286,98,"Magnetic Plating II","This plating utilizes a magnetic field to deflect kinetic attacks. Grants a bonus to kinetic resistance. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,10,1,5,0,1,0,39200,1,540,0.060000,0,7,1030,422,9059900);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1287,163,"Magnetic Plating II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,333,0,0,9,1030,422,9059901);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1292,98,"Basic Thermic Plating","Attempts to distribute thermal energy over the entire plating. Grants a bonus to thermal resistance. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,10,1,5,0,1,0,1984,1,540,0.070000,0,7,1030,422,9059902);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1294,98,"Thermic Plating I","Attempts to distribute thermal energy over the entire plating. Grants a bonus to thermal resistance. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,10,1,5,0,1,0,4974,1,540,0.070000,0,7,1030,422,9059903);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1295,163,"Thermic Plating I Blueprint","",0,0,0,0.010000,0,1,0,49740,1,333,0,0,9,1030,422,9059904);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1296,98,"Thermic Plating II","Attempts to distribute thermal energy over the entire plating. Grants a bonus to thermal resistance. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,10,1,5,0,1,0,38896,1,540,0.060000,0,7,1030,422,9059905);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1297,163,"Thermic Plating II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,333,0,0,9,1030,422,9059906);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1302,98,"Basic Adaptive Nano Plating","This cutting edge system is the most versatile nano plating around. It has the ability to instantly adapt to any attack. However, it is somewhat less effective than a specialized plating. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,10,1,5,0,1,0,1984,1,540,0.070000,0,7,1030,422,9059907);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1304,98,"Adaptive Nano Plating I","This cutting edge system is the most versatile nano plating around. It has the ability to instantly adapt to any attack. However, it is somewhat less effective than a specialized plating. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,10,1,5,0,1,0,7468,1,540,0.070000,0,7,1030,422,9059908);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1305,163,"Adaptive Nano Plating I Blueprint","",0,0,0,0.010000,0,1,0,74680,1,333,0,0,9,1030,422,9059909);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1306,98,"Adaptive Nano Plating II","This cutting edge system is the most versatile nano plating around. It has the ability to instantly adapt to any attack. However, it is somewhat less effective than a specialized plating. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,10,1,5,0,1,0,42496,1,540,0.060000,0,7,1030,422,9059910);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1307,163,"Adaptive Nano Plating II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,333,0,0,9,1030,422,9059911);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1315,765,"Basic Expanded Cargohold","Increases cargo hold capacity.",0,10,50,5,0,1,0,800,1,1197,0.070000,0,7,92,422,9065527);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1317,765,"Expanded Cargohold I","Increases cargo hold capacity.",0,10,50,5,0,1,0,1664,1,1197,0.070000,0,7,92,422,9065529);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1318,158,"Expanded Cargohold I Blueprint","",0,0,0,0.010000,0,1,0,16640,1,335,0,0,9,92,422,9059912);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1319,765,"Expanded Cargohold II","Increases cargo hold capacity.",0,10,50,5,0,1,0,35328,1,1197,0.060000,0,7,92,422,9065530);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1320,158,"Expanded Cargohold II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,0,0,0,9,92,422,9059913);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1333,78,"Reinforced Bulkheads I","Increases structural hit points while reducing inertia and overall top speed.",0,100,200,25,0,1,0,12500,1,1195,0.070000,0,7,76,422,9065511);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1334,158,"Reinforced Bulkheads I Blueprint","",0,0,0,0.010000,0,1,0,125000,1,335,0,0,9,76,422,9059914);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1335,78,"Reinforced Bulkheads II","Increases structural hit points while reducing inertia and overall top speed.",0,100,200,5,0,1,0,49068,1,1195,0.060000,0,7,76,422,9065512);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1336,158,"Reinforced Bulkheads II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,0,0,0,9,76,422,9059915);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1351,769,"Basic Reactor Control Unit","Boosts power core output.",0,500,20,5,0,1,0,3968,1,659,0.070000,0,7,70,422,9059916);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1353,769,"Reactor Control Unit I","Boosts power core output.",0,500,20,5,0,1,0,9920,1,659,0.060000,0,7,70,422,9059917);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1354,137,"Reactor Control Unit I Blueprint","",0,0,0,0.010000,0,1,0,99200,1,327,0,0,9,70,422,9059918);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1355,769,"Reactor Control Unit II","Boosts power core output.",0,500,20,5,0,1,0,57568,1,659,0.050000,0,7,70,422,9059919);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1356,137,"Reactor Control Unit II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,327,0,0,9,70,422,9059920);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1372,180,"Basic Protective Sentry Gun","",1006,45,100,1,1000,1,4,0,0,0,0,0,11,0,0,728704);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1373,1,"CharacterAmarr","Character type for characters of the Amarrian Amarr bloodline.",0,0,0,1,0,1,4,0,1,0,0,0,1,0,0,9059921);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1374,1,"CharacterNiKunni","Character type for characters of the Amarr Nikunni bloodline.",0,0,0,1,0,1,4,0,1,0,0,0,1,0,0,9059922);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1375,1,"CharacterCivire","Character type for characters of the Caldari Civire bloodline.",0,0,0,1,0,1,1,0,1,0,0,0,1,0,0,9059923);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1376,1,"CharacterDeteis","Character type for characters of the Caldari Deteis bloodline.",0,0,0,1,0,1,1,0,1,0,0,0,1,0,0,9059924);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1377,1,"CharacterGallente","Character type for characters of the Gallente Gallente bloodline.",0,0,0,1,0,1,8,0,1,0,0,0,1,0,0,9059925);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1378,1,"CharacterIntaki","Character type for characters of the Gallente Intaki bloodline.",0,0,0,1,0,1,8,0,1,0,0,0,1,0,0,9059926);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1379,1,"CharacterSebiestor","Character type for characters of the Minmatar Sebiestor bloodline.",0,0,0,1,0,1,2,0,1,0,0,0,1,0,0,9059927);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1380,1,"CharacterBrutor","Character type for characters of the Minmatar Brutor bloodline.",0,0,0,1,0,1,2,0,1,0,0,0,1,0,0,9059928);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1381,1,"CharacterStatic","Character type for characters of the Jove Static bloodline.",0,0,0,1,0,1,16,0,1,0,0,0,1,0,0,9059929);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1382,1,"CharacterModifier","Character type for characters of the Jove Modifier bloodline.",0,0,0,1,0,1,16,0,1,0,0,0,1,0,0,9059930);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1383,1,"CharacterAchura","Character type for characters of the Caldari Achura bloodline.",0,0,0,1,0,1,1,0,1,0,0,0,1,0,0,9059931);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1384,1,"CharacterJinMei","Character type for characters of the Gallente Jin-Mei bloodline.",0,0,0,1,0,1,8,0,1,0,0,0,1,0,0,9059932);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1385,1,"CharacterKhanid","Character type for characters of the Amarr Khanid bloodline.",0,0,0,1,0,1,4,0,1,0,0,0,1,0,0,9059933);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1386,1,"CharacterVherokior","Character type for characters of the Minmatar Vherokior bloodline.",0,0,0,1,0,1,2,0,1,0,0,0,1,0,0,9059934);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1401,762,"Basic Inertia Stabilizers","Improves ship handling and maneuverability.


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,100,200,5,0,1,0,2176,1,1086,0.070000,0,7,1041,422,9059935);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1403,762,"Inertia Stabilizers I","Improves ship handling and maneuverability.


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,100,200,5,0,1,0,5438,1,1086,0.070000,0,7,1041,422,9059936);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1404,158,"Inertia Stabilizers I Blueprint","",0,0,0,0.010000,0,1,0,54380,1,332,0,0,9,1041,422,9059937);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1405,762,"Inertia Stabilizers II","Improves ship handling and maneuverability.


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,100,200,5,0,1,0,39732,1,1086,0.060000,0,7,1041,422,9059938);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1406,158,"Inertia Stabilizers II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,0,0,0,9,1041,422,9059939);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1419,57,"Basic Shield Power Relay","Diverts power from the capacitors to the shields, thereby increasing the shield recharge rate.",0,500,20,5,0,1,0,4864,1,688,0.070000,0,7,83,422,9059940);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1422,57,"Shield Power Relay II","Diverts power from the capacitors to the shields, thereby increasing the shield recharge rate.",0,500,20,5,0,1,0,44858,1,688,0.050000,0,7,83,422,9059941);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1423,137,"Shield Power Relay II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,0,0,0,9,83,422,9059942);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1436,96,"Auto Targeting System II","Targets any hostile ship within range on activation. Grants a +3 bonus to ship\'s max targets when online",0,0,40,5,0,1,0,72896,1,670,0.060000,0,7,104,422,9059943);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1437,162,"Auto Targeting System II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,0,0,0,9,104,422,9059944);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1445,767,"Capacitor Power Relay I","Increases capacitor recharge rate at the expense of shield boosting.",0,500,20,5,0,1,0,9744,1,667,0.060000,0,7,90,422,9059945);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1446,137,"Capacitor Power Relay I Blueprint","",0,0,0,0.010000,0,1,0,97440,1,327,0,0,9,90,422,9059946);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1447,767,"Capacitor Power Relay II","Increases capacitor recharge rate at the expense of shield boosting.",0,500,20,5,0,1,0,44074,1,667,0.050000,0,7,90,422,9059947);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1448,137,"Capacitor Power Relay II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,0,0,0,9,90,422,9059948);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1529,15,"Station (Caldari 1)","",1019,45734,0,1,0,1,1,600000,0,0,0,13,3,0,0,7111850);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1530,15,"Station (Caldari 2)","",1018,26782,0,1,0,1,1,600000,0,0,0,16,3,0,0,7111851);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1531,15,"Station (Caldari 3)","",1017,33413,0,1,0,1,1,600000,0,0,0,23,3,0,0,7111928);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1537,766,"Basic Power Diagnostic System","Monitors and optimizes the power grid. Gives a slight boost to power core output and a minor increase in shield and capacitor recharge rate.",0,500,20,5,0,1,0,3968,1,658,0.070000,0,7,70,422,9059949);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1539,766,"Power Diagnostic System I","Monitors and optimizes the power grid. Gives a slight boost to power core output and a minor increase in shield and capacitor recharge rate.",0,500,20,5,0,1,0,9920,1,658,0.060000,0,7,70,422,9059950);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1540,137,"Power Diagnostic System I Blueprint","",0,0,0,0.010000,0,1,0,99200,1,327,0,0,9,70,422,9059951);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1541,766,"Power Diagnostic System II","Monitors and optimizes the power grid. Gives a slight boost to power core output and a minor increase in shield and capacitor recharge rate.",0,500,20,5,0,1,0,46288,1,658,0.050000,0,7,70,422,9059952);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1542,137,"Power Diagnostic System II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,327,0,0,9,70,422,9059953);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1547,72,"Small Proton Smartbomb I","Radiates an omnidirectional pulse from the ship that causes explosive damage to surrounding vessels.",2034,1000,10,12.500000,0,1,0,50000,1,382,0.070000,0,7,112,422,728815);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1548,152,"Small Proton Smartbomb I Blueprint","",0,0,0,0.010000,0,1,0,500000,1,341,0,0,9,112,422,9059954);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1549,72,"Small Proton Smartbomb II","Radiates an omnidirectional pulse from the ship that causes explosive damage to surrounding vessels.",2034,1000,40,5,0,1,0,121088,1,382,0.060000,0,7,112,422,728821);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1550,152,"Small Proton Smartbomb II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,341,0,0,9,112,422,9059955);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1551,72,"Small Graviton Smartbomb I","Radiates an omnidirectional pulse from the ship that causes kinetic damage to surrounding vessels.",2033,1000,10,12.500000,0,1,0,55000,1,382,0.070000,0,7,112,422,728827);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1552,152,"Small Graviton Smartbomb I Blueprint","",0,0,0,0.010000,0,1,0,550000,1,341,0,0,9,112,422,9059956);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1553,72,"Small Graviton Smartbomb II","Radiates an omnidirectional pulse from the ship that causes kinetic damage to surrounding vessels.",2033,1000,40,5,0,1,0,121088,1,382,0.060000,0,7,112,422,728833);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1554,152,"Small Graviton Smartbomb II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,341,0,0,9,112,422,9059957);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1557,72,"Small Plasma Smartbomb I","Radiates an omnidirectional pulse from the ship that causes thermal damage to surrounding vessels.",2035,1000,10,12.500000,0,1,0,60000,1,382,0.070000,0,7,112,422,728839);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1558,152,"Small Plasma Smartbomb I Blueprint","",0,0,0,0.010000,0,1,0,600000,1,341,0,0,9,112,422,9059958);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1559,72,"Small Plasma Smartbomb II","Radiates an omnidirectional pulse from the ship that causes thermal damage to surrounding vessels.",2035,1000,40,5,0,1,0,121088,1,382,0.060000,0,7,112,422,728845);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1560,152,"Small Plasma Smartbomb II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,341,0,0,9,112,422,9059959);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1563,72,"Small EMP Smartbomb I","Radiates an omnidirectional pulse from the ship that causes EM damage to surrounding vessels.",2032,1000,10,12.500000,0,1,0,65000,1,382,0.070000,0,7,112,422,728851);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1564,152,"Small EMP Smartbomb I Blueprint","",0,0,0,0.010000,0,1,0,650000,1,341,0,0,9,112,422,9059960);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1565,72,"Small EMP Smartbomb II","Radiates an omnidirectional pulse from the ship that causes EM damage to surrounding vessels.",2032,1000,40,5,0,1,0,121188,1,382,0.060000,0,7,112,422,728857);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1566,152,"Small EMP Smartbomb II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,341,0,0,9,112,422,9059961);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1601,190,"Amarr Bonus","-50% cost for using Amarrian stargates.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,9059962);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1602,190,"Ni-Kunni Bonus","+25% max ask/bid value on market.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,9059963);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1603,190,"Civire Bonus","+3% Accuracy bonus for Hybrid Weapons.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,9059964);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1604,190,"Deteis Bonus","-2% production time for all modules.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,9059965);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1605,190,"Gallente Bonus","-10% drill time when mining asteroids with mining lasers.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,9059966);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1606,190,"Intaki Bonus","+20% chance of getting a new agent.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,9059967);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1607,190,"Sebiestor Bonus","-20% ship repair cost.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,9059968);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1608,190,"Brutor Bonus","+10% speed bonus for Projectile Weapons.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,9059969);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1611,191,"Computer Empathy Bonus","Reduces CPU usage 20%.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,9059970);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1612,191,"Ordered Mind Bonus","Lower skill loss severity by 25%.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,728890);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1613,191,"Standard DNA Pattern Bonus","+1 character clone usage advance level.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,728893);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1614,191,"Killer Instinct Bonus","+5% Shield seeping.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,728896);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1615,191,"Deft Hands Bonus","Upgrade time -10%.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,728899);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1616,191,"Structural Understanding Bonus","Manufacture time -5%.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,728902);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1617,191,"Creative Bonus","Research time -5%.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,728905);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1618,191,"Glib Tongue Bonus","NPC dir.trade price -5%.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,728908);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1619,191,"August Demeanor Bonus","Better agent missions.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,728911);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1620,191,"Superior Motion Sense Bonus","Turret wp accuracy +2%.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,728914);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1621,191,"High-G Tolerance Bonus","Ship Agility +5%.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,728917);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1622,191,"Vector Reckoning Bonus","Half acc.penalty for high speed.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,728920);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1623,191,"Stratum Form Feel Bonus","Mining efficiency +10%.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,728923);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1624,191,"Doctrine Ingrained Bonus","+5% damage while in formation.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,728926);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1625,191,"Three Dimensional Thinking Bonus","Missile accuracy +3%.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,728929);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1626,191,"Swift Neural Grafting Bonus","C-Implant install time -50%.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,728932);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1627,191,"Booster Immunity Bonus","Booster resistance +25%.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,728935);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1628,193,"Algiophobia Bonus","PwC +5% when in combat (being shot at).",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,728938);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1629,193,"Barophobia Bonus","+50% warp cost if planet/moon in target bubble.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,728941);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1630,193,"Cenophobia Bonus","+50% warp cost to bubbles with no station/stargate.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,728944);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1631,193,"Claustrophobia Bonus","If floating in capsule in space for 5 mins, he dies.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,728947);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1632,193,"Monophobia Bonus","Dies if he doesn\'t dock at a station every 60 mins.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,728950);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1633,193,"Mysophobia Bonus","Worse agent missions.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,728953);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1634,193,"Taphephobia Bonus","If Structure damage is >25% then he ejects capsule.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,728956);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1635,193,"Xenophobia Bonus","Faction standing modifier -25% vs. factions of other race.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,728959);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1636,192,"Mechanical Inaptitude Bonus","Engineering skills training time +25%.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,728962);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1639,192,"Weak Double-helix Bond Bonus","Clone cost +5%.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,728965);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1640,192,"Short Attention Span Bonus","Equipment duration -20%.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,728968);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1641,192,"Wasteful Bonus","Turret weapon power usage +5%.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,728971);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1642,192,"Trigger-happy Bonus","Turret weapon accuracy	-2%.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,728974);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1643,192,"Epileptic Bonus","Prevents attribute change instigated skill training time adjustments.  Boosters and trained skills which change the primary or secondary attributes would therefore have no effect on an epileptic character.

",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,728977);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1644,192,"Strong Immunity System Bonus","Cyber implant install time +50% AND booster resistance -25%.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,728980);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1645,194,"Bad Reputation Bonus","Security status gains over time	take twice as long.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,728983);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1646,194,"Minmatar Rebel Affiliation Bonus","Faction standing modifier -50% vs. Amarrian corporations.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,728986);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1647,194,"Slave Trade Tie-ins Bonus","Faction standing modifier -50% vs. Minmatar corporations.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,728989);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1648,194,"Democracy Sympathizer Bonus","Faction standing modifier -50% vs. Caldari corporations.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,728992);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1649,194,"Human Atrocities Accusations Bonus","Faction standing modifier -50% vs. Gallentean corporations.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,728995);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1650,195,"Amarr Military Academy Pilot Bonus","-5% training time for all skills that rely on the perception attribute.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,728998);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1651,195,"Amarr Military Academy Gunner Bonus","-5% weapon power consumption.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,729001);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1652,195,"Amarr Technical School Engineering Bonus","-5% training time for all skills that rely on the memory attribute.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,729004);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1653,195,"Amarr Technical School Electronics Bonus","-5% CPU usage.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,729007);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1654,195,"Amarr Business School Commerce Bonus","-5% training time for all skills that rely on the charisma attribute.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,729010);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1655,195,"Amarr Business School Industry Bonus","-5% factory prod.time.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,729013);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1657,196,"Caldari Military Academy Pilot Bonus","-5% training time for all skills that rely on the perception attribute.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,729016);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1658,196,"Caldari Military Academy Gunner Bonus","-5% weapon power consumption.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,729019);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1659,196,"Caldari Technical School Engineering Bonus","-5% training time for all skills that rely on the memory attribute.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,729022);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1660,196,"Caldari Technical School Electronics Bonus","-5% CPU usage.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,729025);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1661,196,"Caldari Business School Commerce Bonus","-5% training time for all skills that rely on the charisma attribute.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,729028);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1662,196,"Caldari Business School Industry Bonus","-5% factory prod.time.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,729031);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1663,197,"Gallente Military Academy Pilot Bonus","-5% training time for all skills that rely on the perception attribute.

",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,729034);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1664,197,"Gallente Military Academy Gunner Bonus","-5% weapon power consumption.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,729037);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1665,197,"Gallente Technical School Engineering Bonus","-5% training time for all skills that rely on the memory attribute.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,729040);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1666,197,"Gallente Technical School Electronics Bonus","-5% CPU usage.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,729043);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1667,197,"Gallente Business School Commerce Bonus","-5% training time for all skills that rely on the charisma attribute.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,729046);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1668,197,"Gallente Business School Industry Bonus","-5% factory prod.time.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,729049);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1669,198,"Minmatar Military Academy Pilot Bonus","-5% training time for all skills that rely on the perception attribute.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,729052);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1670,198,"Minmatar Military Academy Gunner Bonus","-5% weapon power consumption.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,729055);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1671,198,"Minmatar Technical School Engineering Bonus","-5% training time for all skills that rely on the memory attribute.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,729058);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1672,198,"Minmatar Technical School Electronic Bonus","-5% CPU usage.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,729061);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1673,198,"Minmatar Business School Commerce Bonus","-5% training time for all skills that rely on the charisma attribute.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,729064);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1674,198,"Minmatar Business School Industry Bonus","-5% factory prod.time.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,729067);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1675,199,"Bounty Hunter Bonus","+5% skill training time for skills with memory as the primary attribute.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,729070);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1676,199,"Scientist Bonus","+5% skill training time for skills with perception as the primary attribute.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,729073);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1677,199,"Industrialist Bonus","+5% skill training time for skills with perception as the primary attribute.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,729076);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1678,199,"Corporate Magnate Bonus","+5% skill training time for skills with willpower as the primary attribute.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,729079);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1679,199,"Covert-op Bonus","+5% skill training time for skills with intelligence as the primary attribute.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,729082);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1680,199,"Navy Captain Bonus","+5% skill training time for skills with charisma as the primary attribute.",0,0,0,0,0,1,0,0,1,0,0,0,14,0,0,729085);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1798,295,"Basic Magnetic Scattering Amplifier","Boosts the EM resistance of the shield. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,0,1,0,7494,1,550,0.070000,0,7,82,422,9059971);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1800,295,"Basic Heat Dissipation Amplifier","Boosts the thermal resistance of the shield. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,0,1,0,7494,1,550,0.070000,0,7,82,422,9059972);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1802,295,"Basic Kinetic Deflection Amplifier","Boosts the kinetic resistance of the shield. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,0,1,0,7494,1,550,0.070000,0,7,82,422,9059973);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1804,295,"Basic Explosion Dampening Amplifier","Boosts the explosive resistance of the shield. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,0,1,0,7494,1,550,0.070000,0,7,82,422,9059974);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1808,295,"Magnetic Scattering Amplifier I","Boosts the EM resistance of the shield. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,0,1,0,18742,1,550,0.070000,0,7,82,422,9059975);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1809,296,"Magnetic Scattering Amplifier I Blueprint","",0,0,0,0.010000,0,1,0,187420,1,326,0,0,9,82,422,9059976);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1810,394,"Serpent F.O.F. Light Missile I","A Caldarian light missile with a graviton warhead and automatic guidance system.",1333,300,700,0.015000,0,100,0,500,1,914,0.070000,0,8,1333,422,729106);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1811,166,"Serpent F.O.F. Light Missile I Blueprint","",1333,0,1,0.010000,0,1,0,150000,1,315,0,0,9,1333,422,729109);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1814,394,"Exterminator F.O.F. Light Missile I","A Minmatar light missile with a nuclear warhead and automatic guidance system.",1335,300,700,0.015000,0,100,0,370,1,914,0.070000,0,8,1335,422,729112);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1815,166,"Exterminator F.O.F. Light Missile I Blueprint","",1335,0,1,0.010000,0,1,0,140000,1,315,0,0,9,1335,422,729115);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1816,394,"Firefly F.O.F. Light Missile I","A Gallente light missile with a plasma warhead and automatic guidance system.",1334,300,700,0.015000,0,100,8,624,1,914,0.070000,0,8,1334,422,729118);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1817,166,"Firefly F.O.F. Light Missile I Blueprint","",1334,0,1,0.010000,0,1,0,160000,1,315,0,0,9,1334,422,729121);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1818,395,"Hydra F.O.F. Heavy Missile I","A Caldarian heavy missile with a graviton warhead and automatic guidance system.",1340,300,1000,0.030000,0,100,0,2500,1,914,0.070000,0,8,1340,422,729124);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1819,166,"Hydra F.O.F. Heavy Missile I Blueprint","",1340,0,1,0.010000,0,1,0,750000,1,315,0,0,9,1340,422,729127);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1820,395,"Stalker F.O.F. Heavy Missile I","An Amarr heavy missile with an EMP warhead and automatic guidance system.",1339,300,1000,0.030000,0,100,0,3500,1,914,0.070000,0,8,1339,422,729130);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1821,166,"Stalker F.O.F. Heavy Missile I Blueprint","",1339,0,1,0.010000,0,1,0,900000,1,315,0,0,9,1339,422,729133);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1822,395,"Eradicator F.O.F. Heavy Missile I","A Minmatar heavy missile with a nuclear warhead and automatic guidance system.",1338,300,1000,0.030000,0,100,2,2000,1,914,0.070000,0,8,1338,422,729136);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1823,166,"Eradicator F.O.F. Heavy Missile I Blueprint","",1338,0,1,0.010000,0,1,0,700000,1,315,0,0,9,1338,422,729139);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1824,395,"Hellhound F.O.F. Heavy Missile I","A Gallente heavy missile with a plasma warhead and automatic guidance system.",1337,300,1000,0.030000,0,100,0,3000,1,914,0.070000,0,8,1337,422,729142);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1825,166,"Hellhound F.O.F. Heavy Missile I Blueprint","",1337,0,1,0.010000,0,1,0,800000,1,315,0,0,9,1337,422,729145);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1826,396,"Dragon F.O.F. Cruise Missile I","A Caldarian cruise missile with a graviton warhead and automatic guidance system.",1341,300,1250,0.050000,0,100,1,10000,1,914,0.070000,0,8,1341,422,729148);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1827,166,"Dragon F.O.F. Cruise Missile I Blueprint","",1341,0,1,0.010000,0,1,0,3e+006,1,315,0,0,9,1341,422,729151);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1828,396,"Hunter F.O.F. Cruise Missile I","An Amarr cruise missile with an EMP warhead and automatic guidance system.",1344,300,1250,0.050000,0,100,0,15000,1,914,0.070000,0,8,1344,422,729154);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1829,166,"Hunter F.O.F. Cruise Missile I Blueprint","",1344,0,1,0.010000,0,1,0,5e+006,1,315,0,0,9,1344,422,729157);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1830,396,"Obliterator F.O.F. Cruise Missile I","A Minmatar cruise missile with a nuclear warhead and automatic guidance system.",1343,300,1250,0.050000,0,100,0,7500,1,914,0.070000,0,8,1343,422,729160);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1831,166,"Obliterator F.O.F. Cruise Missile I Blueprint","",1343,0,1,0.010000,0,1,0,2.5e+006,1,315,0,0,9,1343,422,729163);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1832,396,"Phoenix F.O.F. Cruise Missile I","A Gallente cruise missile with a plasma warhead and automatic guidance system ",1342,300,1250,0.050000,0,100,0,12500,1,914,0.070000,0,8,1342,422,729166);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1833,166,"Phoenix F.O.F. Cruise Missile I Blueprint","",1342,0,1,0.010000,0,1,0,4e+006,1,315,0,0,9,1342,422,729169);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1855,48,"Ship Scanner II","Scans the target ship and provides a tactical analysis of its capabilities. The further it goes beyond scan range, the more inaccurate its results will be.",0,0,0,5,0,1,0,37728,1,713,0.060000,0,7,107,422,9059977);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1856,128,"Ship Scanner II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,0,0,0,9,107,422,9059978);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1875,511,"Assault Missile Launcher I","Launcher for cruisers intended to counter fast frigates, can only be fitted with regular light missiles: Bloodclaw, Flameburst, Piranha and Sabretooth and their F.O.F. counterparts; Exterminator, Firefly, Seeker and Serpent.",1345,0,0,10,0.900000,1,0,9000,1,641,0.070000,0,7,1345,422,729178);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1876,136,"Assault Missile Launcher I Blueprint","",1345,0,0,0.010000,0,1,0,90000,1,340,0,0,9,1345,422,729181);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1877,511,"Assault Missile Launcher II","Launcher for cruisers intended to counter fast frigates, can only be fitted with regular and advanced light missiles: Bloodclaw, Flameburst, Piranha, Sabretooth (Fury and Precision variants available) and their F.O.F. counterparts; Exterminator, Firefly, Seeker and Serpent.",1345,0,0,10,1.200000,1,0,76908,1,641,0.060000,0,7,1345,422,729184);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1878,136,"Assault Missile Launcher II Blueprint","",1345,0,0,0.010000,0,1,0,1e+007,1,340,0,0,9,1345,422,729187);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1893,205,"Basic Heat Sink","Dissipates energy weapon damage efficiently, thus allowing them to be fired more rapidly. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,1,1,5,0,1,0,9984,1,647,0.070000,0,7,1046,422,9059979);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1894,71,"Energy Neutralizer II","Neutralizes a portion of the energy in the target ship\'s capacitor.",0,0,2000,5,0,1,0,157248,1,0,0.060000,0,7,1283,422,9059980);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1896,25,"Concord Police Frigate","A Concord Patrol Frigate. ",1049,38,1.2e+006,20400,300,1,0,0,0,0,0.070000,0,6,0,422,729196);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1898,25,"Concord SWAT Frigate","A Concord SWAT vessel. .",1054,38,1.2e+006,20400,300,1,0,0,0,0,0.070000,0,6,0,422,729199);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1900,25,"Concord Army Frigate","A Concord millitary vessel. ",1055,38,1.2e+006,20400,300,1,0,0,0,0,0.070000,0,6,0,422,729202);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1902,25,"Concord Special Ops Frigate","A Concord Special Ops Frigate",1053,38,1.2e+006,20400,300,1,0,0,0,0,0.070000,0,6,0,422,729205);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1904,26,"Concord Police Cruiser","Designed by co-operative efforts from all the empires, the Concord cruisers employ many of the finest traditions and technologies enjoyed by the empires, thus making them truly fearsome opponents.",1051,199.860000,1.2155e+007,101000,900,1,0,0,0,0,0.070000,0,6,0,422,729208);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1906,26,"Concord Army Cruiser","Designed by co-operative efforts from all the empires, the Concord cruisers employ many of the finest traditions and technologies enjoyed by the empires, thus making them truly fearsome opponents.",1052,199.860000,1.2155e+007,101000,900,1,0,0,0,0,0.070000,0,6,0,422,729211);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1908,26,"Concord SWAT Cruiser","Designed by co-operative efforts from all the empires, the Concord cruisers employ many of the finest traditions and technologies enjoyed by the empires, thus making them truly fearsome opponents.",1056,199.860000,1.2155e+007,101000,900,1,0,0,0,0,0.070000,0,6,0,422,729214);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1910,26,"Concord Special Ops Cruiser","Designed by co-operative efforts from all the empires, the Concord cruisers employ many of the finest traditions and technologies enjoyed by the empires, thus making them truly fearsome opponents.",1050,199.860000,1.2155e+007,101000,900,1,0,0,0,0,0.070000,0,6,0,422,729217);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1912,27,"Concord Police Battleship","The Concord battleships were built by a joint effort of the empires, each empire investing it with their own special technologies. Although this makes them a bit mismatched, their performance leaves no doubt about their awesome power.",1058,250,1.12903e+008,486000,14000,1,0,2.96e+006,0,0,0.070000,0,6,0,0,729220);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1914,27,"Concord Special Ops Battleship","The Concord battleships were built by a joint effort of the empires, each empire investing it with their own special technologies. Although this makes them a bit mismatched, their performance leaves no doubt about their awesome power.",1059,250,1.12903e+008,486000,14000,1,0,2.96e+006,0,0,0.070000,0,6,0,0,729223);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1916,27,"Concord SWAT Battleship","The Concord battleships were built by a joint effort of the empires, each empire investing it with their own special technologies. Although this makes them a bit mismatched, their performance leaves no doubt about their awesome power.",1057,250,1.12903e+008,486000,14000,1,0,2.96e+006,0,0,0.070000,0,6,0,0,729226);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1918,27,"Concord Army Battleship","The Concord battleships were built by a joint effort of the empires, each empire investing it with their own special technologies. Although this makes them a bit mismatched, their performance leaves no doubt about their awesome power.",1060,250,1.12903e+008,486000,14000,1,0,2.96e+006,0,0,0.070000,0,6,0,0,729229);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1926,15,"Amarr Station Hub","",1068,42489,0,0,0,1,4,600000,0,0,0,27,3,0,0,7111929);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1927,15,"Amarr Station Military","",1069,48492,0,0,0,1,4,600000,0,0,0,26,3,0,0,7111942);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1928,15,"Amarr Industrial Station","",1070,24276,0,0,0,1,4,600000,0,0,0,28,3,0,0,7111944);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1929,15,"Amarr Standard Station","",1071,20081,0,0,0,1,4,600000,0,0,0,28,3,0,0,7111930);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1930,15,"Amarr Mining Station","",1072,22283,0,0,0,1,4,600000,0,0,0,28,3,0,0,7111931);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1931,15,"Amarr Research Station","",1073,29162,0,0,0,1,4,600000,0,0,0,14,3,0,0,7111932);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1932,15,"Amarr Trade Post","",1074,13887,0,0,0,1,4,600000,0,0,0,18,3,0,0,7111933);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1944,28,"Bestower","The Bestower has for decades been used by the Empire as a slave transport, shipping human labor between cultivated planets in Imperial space. As a proof to how reliable this class has been through the years, the Emperor himself has used an upgraded version of this very same class as transports for the Imperial Treasury. The Bestower has very thick armor and large cargo space. 


5% Bonus Cargo Capacity and Max Velocity per skill level ",1064,350,1.35e+007,260000,4800,1,4,497750,1,85,0.070000,0,6,0,0,11772784);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1945,108,"Bestower Blueprint","",1064,0,0,0.010000,0,1,0,4.9775e+006,1,285,0,0,9,0,0,729256);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1946,203,"Basic RADAR Backup Array","A backup system which operates in conjunction with the main array. Reduces the ship\'s vulnerability to jamming.


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,0,1,0,4912,1,722,0.070000,0,7,104,422,9059981);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1947,202,"ECCM - Radar I","A secondary electronic array that provides a significant boost to sensor strength for a short time. 


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,0,1,0,25000,1,729,0.070000,0,7,104,422,9065591);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1948,201,"ECM - Ion Field Projector I","Projects a low intensity field of ionized particles to disrupt the effectivenes of enemy sensors. Very effective against Magnetometric-based sensors. ",0,0,0,5,0,1,0,20000,1,715,0.070000,0,7,3227,422,9059982);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1949,210,"Basic Signal Amplifier","Augments the maximum target acquisition range. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,0,1,0,4736,1,669,0.070000,0,7,104,422,9059983);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1951,211,"Basic Tracking Enhancer","Enhances the range and improves the tracking speed of turrets.    


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,10,5,0,1,0,5760,1,707,0.070000,0,7,1640,422,9064280);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1952,212,"Sensor Booster II","Gives an increase to targeting range and scan resolution.  This module can be loaded with scripts to increase its effectiveness in certain areas.  


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,1,1,0,76244,1,671,0.060000,0,7,74,422,9059984);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1955,201,"ECM - Spatial Destabilizer I","Projects random bursts of gravitons that disrupt accurate targeting. As expected this system works best against Gravimetric targeting systems.",0,0,0,5,0,1,0,20000,1,717,0.070000,0,7,3226,422,9059985);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1956,201,"ECM - White Noise Generator I","Disrupts enemy targeting by generating a field of random sensor noise. Works especially well against Radar systems.",0,0,0,5,0,1,0,20000,1,718,0.070000,0,7,3229,422,9059986);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1957,201,"ECM - Multispectral Jammer I","An advanced multipurpose jamming system designed to offer blanket protection against all forms of targeting. Not as effective as the more specialized systems but is still effective against less advanced targeting systems. ",0,0,0,5,0,1,0,29696,1,719,0.070000,0,7,109,422,9059987);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1958,201,"ECM - Phase Inverter I","Analyzes incoming targeting signals and attempts to counter them by emitting an out-of-phase signal back. Great against Ladar targeting systems.",0,0,0,5,0,1,0,20000,1,716,0.070000,0,7,3228,422,9059988);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1959,289,"ECCM Projector I","ECCM Projectors utilize a sophisticated system of electronics to fortify the sensor strengths of an allied ship allowing it to overcome jamming.


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,20,0,1,0,39968,1,686,0.070000,0,7,110,422,9059989);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1960,289,"ECCM Projector II","ECCM Projectors utilize a sophisticated system of electronics to fortify the sensor strengths of an allied ship allowing it to overcome jamming.


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,0,1,0,209280,1,686,0.060000,0,7,110,422,9059990);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1963,290,"Remote Sensor Booster I","Can only be activated on targets to increase their scan resolutions and boost their targeting range.  This module can be loaded with scripts to increase its effectiveness in certain areas. 


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,25,1,1,0,39968,1,673,0.070000,0,7,74,422,9064595);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1964,290,"Remote Sensor Booster II","Can only be activated on targets to increase their scan resolutions and boost their targeting range.  This module can be loaded with scripts to increase its effectiveness in certain areas. 


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,1,1,0,176196,1,673,0.060000,0,7,74,422,9064596);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1968,208,"Remote Sensor Dampener I","Reduces the range and speed of a targeted ship\'s sensors.  This module can be loaded with scripts to increase its effectiveness in certain areas. 


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,1,1,0,49998,1,679,0.070000,0,7,105,422,9059991);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1969,208,"Remote Sensor Dampener II","Reduces the range and speed of a targeted ship\'s sensors.  This module can be loaded with scripts to increase its effectiveness in certain areas. 


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,1,1,0,223452,1,679,0.060000,0,7,105,422,9059992);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1973,212,"Sensor Booster I","Gives an increase to targeting range and scan resolution.  This module can be loaded with scripts to increase its effectiveness in certain areas.  


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.


",0,0,0,5,1,1,0,9870,1,671,0.070000,0,7,74,422,9059993);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1977,213,"Tracking Computer I","By predicting the trajectory of targets, it helps to boost the tracking speed and range of turrets.  This module can be loaded with scripts to increase its effectiveness in certain areas. 


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,1,1,0,9900,1,706,0.070000,0,7,3346,422,9059994);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1978,213,"Tracking Computer II","By predicting the trajectory of targets, it helps to boost the tracking speed and range of turrets.  This module can be loaded with scripts to increase its effectiveness in certain areas. 


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,1,1,0,83760,1,706,0.060000,0,7,3346,422,9059995);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1982,203,"Basic LADAR Backup Array","A backup system which operates in conjunction with the main array. Reduces the ship\'s vulnerability to jamming.


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,0,1,0,4912,1,721,0.070000,0,7,104,422,9059996);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1983,203,"Basic Gravimetric Backup Array","A backup system which operates in conjunction with the main array. Reduces the ship\'s vulnerability to jamming.


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,0,1,0,4912,1,720,0.070000,0,7,104,422,9059997);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1984,203,"Basic Magnetometric Backup Array","A backup system which operates in conjunction with the main array. Reduces the ship\'s vulnerability to jamming.


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,0,1,0,4912,1,723,0.070000,0,7,104,422,9059998);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1985,203,"Basic Multi Sensor Backup Array","A backup system which operates in conjunction with the main array. Reduces the ship\'s vulnerability to jamming.


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,0,1,0,9986,1,724,0.070000,0,7,104,422,9059999);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1986,210,"Signal Amplifier I","Augments the maximum target acquisition range. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,0,1,0,11840,1,669,0.070000,0,7,104,422,9060000);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1987,210,"Signal Amplifier II","Augments the maximum target acquisition range. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,0,1,0,47650,1,669,0.060000,0,7,104,422,9060001);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1998,211,"Tracking Enhancer I","Enhances the range and improves the tracking speed of turrets.    


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,20,5,0,1,0,14400,1,707,0.070000,0,7,1640,422,9064293);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (1999,211,"Tracking Enhancer II","Enhances the range and improves the tracking speed of turrets.    


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,30,5,0,1,0,16432,1,707,0.060000,0,7,1640,422,9064294);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2001,1016,"Cynosural Suppression","This upgrade allows alliances to anchor Cynosural System Jammers on their starbases in a solar system.",0,0,1000,500000,0,1,0,2e+008,1,1282,0,0,39,3945,0,9431330);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2002,202,"ECCM - Ladar I","A secondary electronic array that provides a significant boost to sensor strength for a short time. 


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,0,1,0,25000,1,726,0.070000,0,7,104,422,9065592);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2003,202,"ECCM - Magnetometric I","A secondary electronic array that provides a significant boost to sensor strength for a short time. 


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,0,1,0,25000,1,727,0.070000,0,7,104,422,9060002);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2004,202,"ECCM - Gravimetric I","A secondary electronic array that provides a significant boost to sensor strength for a short time. 


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,0,1,0,25000,1,725,0.070000,0,7,104,422,9060003);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2005,202,"ECCM - Omni I","A secondary electronic array that provides a significant boost to sensor strength for a short time. 


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,0,1,0,25000,1,728,0.070000,0,7,104,422,9060004);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2006,26,"Omen","The Omen is a stereotypical example of the Amarrian School of thinking when it comes to ship design: thick armor and hard hitting lasers. Advancements in heat dissipation allow the Omen to fire its lasers faster than other ships without this technology.


10% bonus to Medium Energy Turret capacitor use and 5% bonus to Medium Energy Turret rate of fire per level.

",1065,134.430000,1.165e+007,118000,450,1,4,4.5275e+006,1,74,0.070000,0,6,0,422,3256979);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2007,106,"Omen Blueprint","",1065,0,0,0.010000,0,1,0,4.5275e+007,1,274,0,0,9,0,422,729355);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2008,1016,"Cynosural Navigation","This upgrade allows alliances to anchor Cynosural Generator Arrays on their starbases in a solar system.",0,0,1000,400000,0,1,0,1e+008,1,1282,0,0,39,3946,0,9067420);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2009,1016,"Supercapital Construction Facilities","This upgrade allows alliances to anchor Capital Ship Assembly Arrays and Capital Ship Maintenance Arrays at their starbases in a solar system.",0,0,1000,200000,0,1,0,5e+007,1,1282,0,0,39,3950,0,9067419);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2010,286,"Rebel Leader","Terrorist Leader.",1890,38.400000,2.112e+006,21120,100,1,2,0,0,0,0,0,11,0,0,7561532);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2011,306,"Prison Facility","This rat-infested prison is being closely guarded.",2520,416,100000,1e+008,10000,1,0,0,0,0,0,0,11,0,0,7543412);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2012,597,"Terrorist Leader","This highly-wanted criminal has been sought after by DED officials for years since he began bombing innocent civilians on stations as part of an extortion racket. As a capsuleer, he has managed to evade capture this far. CONCORD officials have to be happy with quickly targeted assassination hits that send him back to his black-market cloning facility deep out on the frontiers of 0.0 space. Until they can raid those cloning labs, he will continue to rebuild and strike again.",338,50,1.645e+006,16450,120,1,2,0,0,0,0.070000,31,11,0,0,7537409);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2013,283,"Hostages","These hostages have been waiting for someone to rescue them for quite some time.",0,0,80,1,0,1,0,0,1,0,0,0,17,2545,0,9067378);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2014,7,"Planet (Oceanic)","Oceanic worlds are a class of terrestrial world covered entirely by liquids, usually in the form of mundane water. While the liquid surface is exceptionally smooth, the ocean floor on most worlds of this type exhibits significant topographic variety. It is this subsurface irregularity which causes the formation of complex weather systems, which would otherwise revert to more uniform patterns.",3835,10000,99999999999999997000000000000000000.000000,1,0,1,0,0,0,0,0,0,2,10142,0,9049095);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2015,7,"Planet (Lava)","So-called \"lava planets\" (properly \"magmatic planets\") fall into one of three groups: solar magmatics, which orbit sufficiently close to their star that the surface never cools enough to solidify; gravitational magmatics, which experience gravitational shifts sufficiently strong to regularly and significantly fracture cooling crusts; and magmatoids, which are for largely-unexplained reasons simply incapable of cooling and forming a persistent crust. All three types generally exhibit the same external phenomena - huge red-orange lava fields being a defining feature - but the latter two types are sometimes capable of briefly solidifying for a period measured in years or perhaps decades.",3836,10000,99999999999999997000000000000000000.000000,1,0,1,0,0,0,0,0,0,2,10133,0,9049094);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2016,7,"Planet (Barren)","Barren planets are archetypical \"dead terrestrials\": dry, rocky worlds with a minimal atmosphere and an unremarkable composition. They are commonly etched with flood channels, which are often broad enough to be visible from orbit; most such worlds have accumulated significant quantities of ice over their lifetimes, but cannot retain it on their surface. Generally surface liquid evaporates rapidly, contributing to the thin atmosphere, but occasionally it will seep back into the ground and refreeze, ready for another breakout in future when the local temperature rises.",3837,10000,99999999999999997000000000000000000.000000,1,0,1,0,0,0,0,0,0,2,10135,0,9049091);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2017,7,"Planet (Storm)","Storm worlds are usually considered terrestrial planets, although to a casual eye they may appear more similar to gas planets, given their opaque, high-pressure atmospheres. Geomorphically, however, the distinctions are clear: compared to a gas world, the atmosphere of a storm world is usually considerably shallower, and generally composed primarily of more complex chemicals, while the majority of the planet\'s mass is a rocky terrestrial ball. Their name is derived from the continent-scale electrical storms that invariably flash through their upper atmospheres.",3935,10000,99999999999999997000000000000000000.000000,1,0,1,0,0,0,0,0,0,2,10134,0,9049098);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2018,61,"Medium Capacitor Battery I","Increases capacitor storage.",0,500,0,10,0,1,0,25000,1,704,0.070000,0,7,89,422,9060005);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2019,141,"Medium Capacitor Battery I Blueprint","",0,0,0,0.010000,0,1,0,250000,1,327,0,0,9,89,422,9060006);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2020,61,"Large Capacitor Battery I","Increases capacitor storage.",0,500,0,15,0,1,0,62450,1,705,0.070000,0,7,89,422,9060007);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2021,141,"Large Capacitor Battery I Blueprint","",0,0,0,0.010000,0,1,0,624500,1,327,0,0,9,89,422,9060008);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2022,61,"X-Large Capacitor Battery I","Increases capacitor storage.",0,500,0,20,0,1,0,156250,1,0,0.070000,0,7,89,422,9060009);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2023,141,"X-Large Capacitor Battery I Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,0,0,0,9,89,422,9060010);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2024,76,"Medium Capacitor Booster II","Provides a quick injection of power into the capacitor.",0,0,0,10,40,1,0,98844,1,700,0.060000,0,7,1031,422,9060011);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2025,156,"Medium Capacitor Booster II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,0,0,0,9,1031,422,9060012);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2026,1021,"Pirate Detection Array 1","This upgrade increases the number of active combat sites in the upgraded solar system.",0,0,1000,5000,0,1,0,5e+007,1,1284,0,0,39,3951,0,9067408);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2027,1021,"Pirate Detection Array 2","This upgrade increases the number of active combat sites in the upgraded solar system.",0,0,1000,10000,0,1,0,1e+008,1,1284,0,0,39,3951,0,9067409);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2028,1021,"Pirate Detection Array 3","This upgrade increases the number of active combat sites in the upgraded solar system.",0,0,1000,100000,0,1,0,1.5e+008,1,1284,0,0,39,3951,0,9067410);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2029,1021,"Pirate Detection Array 4","This upgrade increases the number of active combat sites in the upgraded solar system.",0,0,1000,250000,0,1,0,2e+008,1,1284,0,0,39,3951,0,9067417);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2030,1021,"Pirate Detection Array 5","This upgrade increases the number of active combat sites in the upgraded solar system.",0,0,1000,500000,0,1,0,2.5e+008,1,1284,0,0,39,3951,0,9067418);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2031,1021,"Entrapment Array 1","This upgrade increases the chance of finding a complex in the system.",0,0,1000,5000,0,1,0,1e+008,1,1284,0,0,39,3947,0,9067434);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2032,43,"Cap Recharger II","Increases the capacitor recharge rate.",0,0,1,5,0,1,0,99466,1,665,0.050000,0,7,90,422,9060013);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2033,123,"Cap Recharger II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,327,0,0,9,90,422,9060014);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2034,1021,"Entrapment Array 2","This upgrade increases the chance of finding a complex in the system.",0,0,1000,10000,0,1,0,2e+008,1,1284,0,0,39,3947,0,9067435);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2035,1021,"Entrapment Array 3","This upgrade increases the chance of finding a complex in the system.",0,0,1000,100000,0,1,0,3e+008,1,1284,0,0,39,3947,0,9067436);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2036,1021,"Entrapment Array 4","This upgrade increases the chance of finding a complex in the system.",0,0,1000,250000,0,1,0,4e+008,1,1284,0,0,39,3947,0,9067437);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2037,1021,"Entrapment Array 5","This upgrade increases the chance of finding a complex in the system.",0,0,1000,500000,0,1,0,5e+008,1,1284,0,0,39,3947,0,9067438);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2038,47,"Cargo Scanner II","Scans the cargo hold of another ship.",0,0,0,5,0,1,0,36518,1,711,0.060000,0,7,106,422,9060015);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2039,127,"Cargo Scanner II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,0,0,0,9,106,422,9060016);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2040,1020,"Ore Prospecting Array 1","This upgrade increases the ore resources available in a system.",0,0,1000,5000,0,1,0,5e+007,1,1283,0,0,39,3948,0,9067422);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2041,1020,"Ore Prospecting Array 2","This upgrade increases the ore resources available in a system.",0,0,1000,10000,0,1,0,7.5e+007,1,1283,0,0,39,3948,0,9067423);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2042,1020,"Ore Prospecting Array 3","This upgrade increases the ore resources available in a system.",0,0,1000,100000,0,1,0,1e+008,1,1283,0,0,39,3948,0,9067424);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2043,1020,"Ore Prospecting Array 4","This upgrade increases the ore resources available in a system.",0,0,1000,250000,0,1,0,1.25e+008,1,1283,0,0,39,3948,0,9067425);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2044,1020,"Ore Prospecting Array 5","This upgrade increases the ore resources available in a system.",0,0,1000,500000,0,1,0,2.5e+008,1,1283,0,0,39,3948,0,9067426);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2045,693,"SARO Frigate","Special Affairs for Regulations & Order (SARO) is an elite branch of CONCORD\'s DED. They’re called upon for high risk missions, including hostage situations, anti-terrorist ops, and the assault of heavily armed pirate havens.",1053,30,1.65e+006,16500,235,1,0,0,0,0,0.070000,0,11,0,0,7543694);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2046,60,"Damage Control I","Utilizes a combination of containment field emitters and redundancy systems to prevent critical system damage. 


Grants a bonus to resistance for shield, armor and hull.

Only one Damage Control can be activated at a given time.",0,0,5000,5,0,1,0,3464,1,615,0.070000,0,7,77,422,9064913);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2047,140,"Damage Control I Blueprint","",0,0,0,0.010000,0,1,0,50000,1,333,0,0,9,77,422,9060017);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2048,60,"Damage Control II","Utilizes a combination of containment field emitters and redundancy systems to prevent critical system damage. 


Grants a bonus to resistance for shield, armor and hull.

Only one Damage Control can be activated at a given time.",0,0,5000,5,0,1,0,39042,1,615,0.060000,0,7,77,422,9064914);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2049,140,"Damage Control II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,0,0,0,9,77,422,9060018);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2051,1021,"Test Upgrade","",0,0,1000,1000,0,1,0,1e+006,1,0,0,0,39,3954,0,9067416);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2052,286,"Mercenary Trainee","This is a mercenary fighter.  Its faction alignment is unknown.  It may be aggressive, depending on its assignment.  Threat level: Moderate",1830,45.980000,1.97e+006,19700,125,1,1,0,0,0,0,0,11,0,0,7554708);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2053,1020,"Survey Networks 1","This upgrade increases the chance of a mini-profession site being present in the upgraded solar system.",0,0,1000,5000,0,1,0,5e+007,1,1283,0,0,39,3953,0,9067427);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2054,1020,"Survey Networks 2","This upgrade increases the chance of a mini-profession site being present in the upgraded solar system.",0,0,1000,10000,0,1,0,1e+008,1,1283,0,0,39,3953,0,9067428);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2055,1020,"Survey Networks 3","This upgrade increases the chance of a mini-profession site being present in the upgraded solar system.",0,0,1000,100000,0,1,0,1.5e+008,1,1283,0,0,39,3953,0,9067429);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2056,1020,"Survey Networks 4","This upgrade increases the chance of a mini-profession site being present in the upgraded solar system.",0,0,1000,250000,0,1,0,2e+008,1,1283,0,0,39,3953,0,9067430);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2057,1020,"Survey Networks 5","This upgrade increases the chance of a mini-profession site being present in the upgraded solar system.",0,0,1000,500000,0,1,0,2.5e+008,1,1283,0,0,39,3953,0,9067431);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2058,1021,"Quantum Flux Generator 1","This upgrade increases the chance of a wormhole being present in the upgraded solar system.",0,0,1000,5000,0,1,0,5e+007,1,1284,0,0,39,3943,0,9067411);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2059,1021,"Quantum Flux Generator 2","This upgrade increases the chance of a wormhole being present in the upgraded solar system.",0,0,1000,10000,0,1,0,1e+008,1,1284,0,0,39,3943,0,9067412);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2060,1021,"Quantum Flux Generator 3","This upgrade increases the chance of a wormhole being present in the upgraded solar system.",0,0,1000,100000,0,1,0,1.5e+008,1,1284,0,0,39,3943,0,9067413);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2061,1021,"Quantum Flux Generator 4","This upgrade increases the chance of a wormhole being present in the upgraded solar system.",0,0,1000,250000,0,1,0,2e+008,1,1284,0,0,39,3943,0,9067414);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2062,1021,"Quantum Flux Generator 5","This upgrade increases the chance of a wormhole being present in the upgraded solar system.",0,0,1000,500000,0,1,0,2.5e+008,1,1284,0,0,39,3943,0,9067415);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2063,7,"Planet (Plasma)","The aptly-named \"plasma planets\" have captured the imagination of countless artists and inspired innumerable works, yet the physics behind them are surprisingly mundane by cosmological standards. A rocky terrestrial with the right kind of atmosphere and magnetic field will, when bombarded with solar radiation, generate sprawling plasma storms as specific atmospheric elements are stripped of their electrons. Over time these storms will generally scorch the surface rock black, adding to the visual impact.",3941,10000,99999999999999997000000000000000000.000000,1,0,1,0,0,0,0,0,0,2,10138,0,9049096);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2064,995,"EVE Gate","",3944,10000,99999999999999997000000000000000000.000000,1,0,1,0,0,0,0,0,0,2,0,0,7564813);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2072,602,"Anire Scarlet","Anire is everything you could want in a pirate queen – bright green eyes, wild red hair and curves in all the right places. She dresses in a dark brown, form-fitting jumpsuit with gold accents here and there.

Although the most people ever usually get to see is her guns trained on them, as the Crimson Dawn comes bearing down to seal their fate. ",2926,150,1.18e+007,118000,235,1,4,0,0,0,0.070000,31,11,0,0,9237115);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2073,1035,"Micro Organisms","Any life form too small to be detected by the unaided human eye qualifies as a microorganism, yet as a whole, this classification of biology covers an enormous and diverse spectrum. From parasites and viruses to fungi and insects, the study or industrial application of these creatures is just as broad.",0,0,0,0.010000,0,1,0,0,1,1333,0,0,42,10034,0,8980302);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2074,314,"Zazzmatazz","Zazzmatazz’s DNA",0,0,1,0.100000,0,1,0,0,1,0,0,0,17,2302,0,7668108);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2075,314,"Consolidated Holdings Commander Access Key","This Commander key has the information needed to unlock the acceleration gate in the Checkpoint which it was found.",0,0,0.010000,0.010000,0,1,0,0,1,0,0,0,17,2038,0,7668110);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2076,474,"Gate Key","This transponder, set with a unique code built into the device\'s hardware, acts as a key to a specific acceleration gate.",0,0,1,0.100000,0,1,0,0,1,0,0,0,17,2038,0,7668169);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2077,952,"Amarr Frigate Container","Frigate luxury vessel.",1066,39,0,0,500,1,4,0,0,0,0,0,11,0,0,7668335);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2078,1022,"Zephyr","The Zephyr is a unique starship design, relying almost entirely on solar winds for sublight propulsion. Super-light sails allow it to ride the torrents of photons streaming through space, and its barebones construction gives it a tiny sensor footprint and almost negligible mass.


Originally conceived by the ascetic Intaki polymath Valsas en Dilat as a demonstration of minimalist starship design, it was never intended as a commercial venture. The recent discovery of the uncharted Sleeper Territories and their myriad wormholes has brought the Zephyr new attention - its mass makes it an ideal exploration vessel.

Valsas remains adamant that the Zephyr never sees mass production, but at the close of YC111 he authorized the Intaki Syndicate to distribute a single hull to every registered capsuleer.

Can fit Prototype Iris Probe Launcher; will not be targeted by Sleeper drones.",4517,60,5000,5000,10,1,8,5000,1,1395,0.070000,0,6,0,0,11787511);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2080,302,"TEST Damage Mod","Damage x 100

Super locking time
Super reload time",0,0,0,25,0,1,0,0,1,0,0.070000,0,7,1046,0,9067450);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2083,481,"Prototype Iris Probe Launcher","The Iris system is a prototype launcher designed to work exclusively with the Zephyr exploration platform.


Its tight integration allows it to work effectively with the minimal power and CPU capacity the Zephyr can provide, but the non-standard interfaces needed for this optimization make it entirely unusable on other ship types.",0,0,5,5,0.800000,1,0,2,1,0,0.070000,0,7,2677,422,9067480);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2084,314,"The Jovian Charlatan\'s DNA","DNA samples are any of various nucleic acids that are usually the molecular basis of heredity, are localized especially in cell nuclei, and are constructed of a double helix held together by hydrogen bonds between purine and pyrimidine bases which project inward from two chains containing alternate links of deoxyribose and phosphate.


This is a DNA sample taken from a local charlatan claiming to possess Jovian technology and training.",0,0,1,0.100000,0,1,0,0,1,0,0,0,17,2302,0,9067461);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2087,283,"The Fiancee","The son’s fiancée also requires your immediate assistance.",0,0,60,1,0,1,0,0,1,0,0,0,17,2537,0,9067452);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2088,283,"The Son","This is the corporation representative’s son, who is in desperate need of rescuing.",0,0,80,1,0,1,0,0,1,0,0,0,17,2544,0,9067453);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2090,283,"Councilor Aramin","A professional negotiator.",0,0,65,1,0,1,0,0,1,0,0,0,17,2891,0,9067454);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2093,283,"Kidnapped Citizens","These poor people have been through enough already; all they want is to go home.",0,0,5,1,0,1,8,0,1,0,0,0,17,2539,0,9067463);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2096,226,"Caldari Supercarrier Wreckage","This hollowed out husk is all that remains of one of New Eden’s most impressive capital ships.  What was once a battlefield juggernaut has been reduced to nothing but a silent, slowly deteriorating tomb.",3103,1,0,0,0,1,0,0,0,0,0,0,2,0,0,7673163);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2097,226,"Amarr Supercarrier Wreckage","This hollowed out husk is all that remains of one of New Eden’s most impressive capital ships.  What was once a battlefield juggernaut has been reduced to nothing but a silent, slowly deteriorating tomb.",3096,1,0,0,0,1,0,0,0,0,0,0,2,0,0,7672998);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2098,632,"Phenod\'s Broke-Ass Destroyer","This officer of The Seven will engage anyone threatening the gang\'s operations.",2918,50,2.65e+006,26500,235,1,8,0,0,0,0.070000,31,11,0,0,7673030);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2100,314,"Phenod\'s DNA","Identification tags such as these may prove valuable if handed to the proper organization.",0,0,1,0.100000,0,1,0,0,1,0,0,0,17,2302,0,9067464);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2101,226,"Gallente Supercarrier Wreckage","This hollowed out husk is all that remains of one of New Eden’s most impressive capital ships.  What was once a battlefield juggernaut has been reduced to nothing but a silent, slowly deteriorating tomb.",3108,1,0,0,0,1,0,0,0,0,0,0,2,0,0,7673165);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2102,226,"Minmatar Supercarrier Wreckage","This hollowed out husk is all that remains of one of New Eden’s most impressive capital ships.  What was once a battlefield juggernaut has been reduced to nothing but a silent, slowly deteriorating tomb.",3110,1,0,0,0,1,0,0,0,0,0,0,2,0,0,7673167);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2103,209,"Tracking Link I","Establishes a fire control link with another ship, thereby boosting the turret range and tracking speed of that ship. This module can be loaded with scripts to increase its effectiveness in certain areas. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,25,1,1,0,23900,1,708,0.070000,0,7,3346,422,9064276);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2104,209,"Tracking Link II","Establishes a fire control link with another ship, thereby boosting the turret range and tracking speed of that ship. This module can be loaded with scripts to increase its effectiveness in certain areas. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,1,1,0,130220,1,708,0.060000,0,7,3346,422,9064277);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2105,226,"Amarr Carrier Wreckage","This hollowed out husk is all that remains of one of New Eden’s most impressive capital ships.  What was once a battlefield juggernaut has been reduced to nothing but a silent, slowly deteriorating tomb.",3097,1,0,0,0,1,0,0,0,0,0,0,2,0,0,7673169);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2106,226,"Caldari Carrier Wreckage","This hollowed out husk is all that remains of one of New Eden’s most impressive capital ships.  What was once a battlefield juggernaut has been reduced to nothing but a silent, slowly deteriorating tomb.",3101,1,0,0,0,1,0,0,0,0,0,0,2,0,0,7673171);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2107,226,"Gallente Carrier Wreckage","This hollowed out husk is all that remains of one of New Eden’s most impressive capital ships.  What was once a battlefield juggernaut has been reduced to nothing but a silent, slowly deteriorating tomb.",3105,1,0,0,0,1,0,0,0,0,0,0,2,0,0,7673173);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2108,291,"Tracking Disruptor I","Disrupts the turret range and tracking speed of the target ship.  This module can be loaded with scripts to increase its effectiveness in certain areas. 


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,1,1,0,29824,1,680,0.070000,0,7,1639,422,9060019);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2109,291,"Tracking Disruptor II","Disrupts the turret range and tracking speed of the target ship.  This module can be loaded with scripts to increase its effectiveness in certain areas. 


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,1,1,0,205296,1,680,0.060000,0,7,1639,422,9060020);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2110,226,"Minmatar Carrier Wreckage","This hollowed out husk is all that remains of one of New Eden’s most impressive capital ships.  What was once a battlefield juggernaut has been reduced to nothing but a silent, slowly deteriorating tomb.",3111,1,0,0,0,1,0,0,0,0,0,0,2,0,0,7673175);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2111,226,"Amarr Freighter Wreckage","This hollowed out husk is all that remains of one of New Eden’s most impressive capital ships.  What was once a battlefield juggernaut has been reduced to nothing but a silent, slowly deteriorating tomb.",3099,1,0,0,0,1,0,0,0,0,0,0,2,0,0,7673178);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2112,226,"Caldari Freighter Wreckage","This hollowed out husk is all that remains of one of New Eden’s most impressive capital ships.  What was once a battlefield juggernaut has been reduced to nothing but a silent, slowly deteriorating tomb.",3075,1,0,0,0,1,0,0,0,0,0,0,2,0,0,7673180);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2113,226,"Gallente Freighter Wreckage","This hollowed out husk is all that remains of one of New Eden’s most impressive capital ships.  What was once a battlefield juggernaut has been reduced to nothing but a silent, slowly deteriorating tomb.",3087,1,0,0,0,1,0,0,0,0,0,0,2,0,0,7673182);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2114,226,"Minmatar Freighter Wreckage","This hollowed out husk is all that remains of one of New Eden’s most impressive capital ships.  What was once a battlefield juggernaut has been reduced to nothing but a silent, slowly deteriorating tomb.",3113,1,0,0,0,1,0,0,0,0,0,0,2,0,0,7673184);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2115,226,"Amarr Dreadnought Wreckage","This hollowed out husk is all that remains of one of New Eden’s most impressive capital ships.  What was once a battlefield juggernaut has been reduced to nothing but a silent, slowly deteriorating tomb.",3098,1,0,0,0,1,0,0,0,0,0,0,2,0,0,7673186);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2116,226,"Caldari Dreadnought Wreckage","This hollowed out husk is all that remains of one of New Eden’s most impressive capital ships.  What was once a battlefield juggernaut has been reduced to nothing but a silent, slowly deteriorating tomb.",3102,1,0,0,0,1,0,0,0,0,0,0,2,0,0,7673188);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2117,80,"ECM Burst II","Emits random electronic bursts which have a chance of momentarily disrupting target locks on ships within range.


Given the unstable nature of the bursts and the amount of internal shielding needed to ensure they do not affect their own point of origin, only battleship-class vessels can use this module to its fullest extent.

Only one module of this type can be activated at the same time",0,0,5000,5,0,1,0,186874,1,678,0.060000,0,7,109,422,11791576);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2118,160,"ECM Burst II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,0,0,0,9,109,422,9060021);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2119,226,"Gallente Dreadnought Wreckage","This hollowed out husk is all that remains of one of New Eden’s most impressive capital ships.  What was once a battlefield juggernaut has been reduced to nothing but a silent, slowly deteriorating tomb.",3106,1,0,0,0,1,0,0,0,0,0,0,2,0,0,7673190);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2120,226,"Minmatar Dreadnought Wreckage","This hollowed out husk is all that remains of one of New Eden’s most impressive capital ships.  What was once a battlefield juggernaut has been reduced to nothing but a silent, slowly deteriorating tomb.",3112,1,0,0,0,1,0,0,0,0,0,0,2,0,0,7673192);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2121,226,"Amarr Titan Wreckage","This hollowed out husk is all that remains of one of New Eden’s most impressive capital ships.  What was once a battlefield juggernaut has been reduced to nothing but a silent, slowly deteriorating tomb.",3100,1,0,0,0,1,0,0,0,0,0,0,2,0,0,7673194);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2122,226,"Caldari Titan Wreckage","This hollowed out husk is all that remains of one of New Eden’s most impressive capital ships.  What was once a battlefield juggernaut has been reduced to nothing but a silent, slowly deteriorating tomb.",3104,1,0,0,0,1,0,0,0,0,0,0,2,0,0,7673196);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2123,226,"Gallente Titan Wreckage","This hollowed out husk is all that remains of one of New Eden’s most impressive capital ships.  What was once a battlefield juggernaut has been reduced to nothing but a silent, slowly deteriorating tomb.",3109,1,0,0,0,1,0,0,0,0,0,0,2,0,0,7673198);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2124,226,"Minmatar Titan Wreckage","This hollowed out husk is all that remains of one of New Eden’s most impressive capital ships.  What was once a battlefield juggernaut has been reduced to nothing but a silent, slowly deteriorating tomb.",3114,1,0,0,0,1,0,0,0,0,0,0,2,0,0,7673200);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2126,633,"Anakism","This officer of The Seven will engage anyone threatening the gang\'s operations.",1821,50,2.25e+006,22500,235,1,8,0,0,0,0.070000,31,11,0,0,7674431);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2127,306,"Amarr Diplomat Quarters","",2400,2787,100000,1e+008,10000,1,0,0,0,0,0,0,11,0,0,9238956);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2128,632,"Locced\'s Destroyer","This officer of The Seven will engage anyone threatening the gang\'s operations.",2918,50,2.65e+006,26500,235,1,8,0,0,0,0.070000,31,11,0,0,7674830);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2129,1027,"Limited Barren Command Center","The modular design of this administrative structure allows it to be deployed piecemeal from orbit, then manually assembled on the surface by MTACs and engineering personnel. Supported by self-regulating pylons that follow the contours of indigenous terrain, the facility can accommodate almost any severity of incline or other non-critical geological hazard. Once active, it serves as both a central command post to coordinate the activity of all other nodes and a basic transportation site for getting commodities off world using standard, vertically launched rockets.",4566,0,5000,100,500,1,0,670000,0,0,0,0,41,0,0,9274126);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2130,1027,"Standard Barren Command Center","The modular design of this administrative structure allows it to be deployed piecemeal from orbit, then manually assembled on the surface by MTACs and engineering personnel. Supported by self-regulating pylons that follow the contours of indigenous terrain, the facility can accommodate almost any severity of incline or other non-critical geological hazard. Once active, it serves as both a central command post to coordinate the activity of all other nodes and a basic transportation site for getting commodities off world using standard, vertically launched rockets.",4566,0,5000,200,500,1,0,1.6e+006,0,0,0,0,41,0,0,9274127);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2131,1027,"Improved Barren Command Center","The modular design of this administrative structure allows it to be deployed piecemeal from orbit, then manually assembled on the surface by MTACs and engineering personnel. Supported by self-regulating pylons that follow the contours of indigenous terrain, the facility can accommodate almost any severity of incline or other non-critical geological hazard. Once active, it serves as both a central command post to coordinate the activity of all other nodes and a basic transportation site for getting commodities off world using standard, vertically launched rockets.",4566,0,5000,400,500,1,0,2.8e+006,0,0,0,0,41,0,0,9274125);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2132,1027,"Advanced Barren Command Center","The modular design of this administrative structure allows it to be deployed piecemeal from orbit, then manually assembled on the surface by MTACs and engineering personnel. Supported by self-regulating pylons that follow the contours of indigenous terrain, the facility can accommodate almost any severity of incline or other non-critical geological hazard. Once active, it serves as both a central command post to coordinate the activity of all other nodes and a basic transportation site for getting commodities off world using standard, vertically launched rockets.",4566,0,5000,800,500,1,0,3.7e+006,0,0,0,0,41,0,0,9274123);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2133,1027,"Elite Barren Command Center","The modular design of this administrative structure allows it to be deployed piecemeal from orbit, then manually assembled on the surface by MTACs and engineering personnel. Supported by self-regulating pylons that follow the contours of indigenous terrain, the facility can accommodate almost any severity of incline or other non-critical geological hazard. Once active, it serves as both a central command post to coordinate the activity of all other nodes and a basic transportation site for getting commodities off world using standard, vertically launched rockets.",4566,0,5000,1600,500,1,0,6.4e+006,0,0,0,0,41,0,0,9274124);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2134,1027,"Limited Gas Command Center","Maintaining control over a section of “territory” above a gas giant requires a very specific type of command facility, one that is able to maintain its own orbit, house administrative personnel, and easily communicate and interact with other nodes. Suspended with equilibrium technology, these nodes are able to maintain altitude with minimal upkeep. If there is one major advantage to colonizing gas giant planets, it is that these facilities can literally be dropped directly from orbit with almost no concern for their descent or deployment.",4569,0,5000,100,500,1,0,670000,0,0,0,0,41,0,0,9274161);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2135,1027,"Standard Gas Command Center","Maintaining control over a section of “territory” above a gas giant requires a very specific type of command facility, one that is able to maintain its own orbit, house administrative personnel, and easily communicate and interact with other nodes. Suspended with equilibrium technology, these nodes are able to maintain altitude with minimal upkeep. If there is one major advantage to colonizing gas giant planets, it is that these facilities can literally be dropped directly from orbit with almost no concern for their descent or deployment.",4569,0,5000,200,500,1,0,1.6e+006,0,0,0,0,41,0,0,9274162);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2136,1027,"Improved Gas Command Center","Maintaining control over a section of “territory” above a gas giant requires a very specific type of command facility, one that is able to maintain its own orbit, house administrative personnel, and easily communicate and interact with other nodes. Suspended with equilibrium technology, these nodes are able to maintain altitude with minimal upkeep. If there is one major advantage to colonizing gas giant planets, it is that these facilities can literally be dropped directly from orbit with almost no concern for their descent or deployment.",4569,0,5000,400,500,1,0,2.8e+006,0,0,0,0,41,0,0,9274160);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2137,1027,"Advanced Gas Command Center","Maintaining control over a section of “territory” above a gas giant requires a very specific type of command facility, one that is able to maintain its own orbit, house administrative personnel, and easily communicate and interact with other nodes. Suspended with equilibrium technology, these nodes are able to maintain altitude with minimal upkeep. If there is one major advantage to colonizing gas giant planets, it is that these facilities can literally be dropped directly from orbit with almost no concern for their descent or deployment.",4569,0,5000,800,500,1,0,3.7e+006,0,0,0,0,41,0,0,9274158);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2138,1027,"Elite Gas Command Center","Maintaining control over a section of “territory” above a gas giant requires a very specific type of command facility, one that is able to maintain its own orbit, house administrative personnel, and easily communicate and interact with other nodes. Suspended with equilibrium technology, these nodes are able to maintain altitude with minimal upkeep. If there is one major advantage to colonizing gas giant planets, it is that these facilities can literally be dropped directly from orbit with almost no concern for their descent or deployment.",4569,0,5000,1600,500,1,0,6.4e+006,0,0,0,0,41,0,0,9274159);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2139,1027,"Limited Ice Command Center","This command structure is designed to survive in the harshest planetary environments the universe can offer. The superstructure uses a combination of titanium-steel reinforcement, increasing its overall resilience, and counter-harmonic stabilizers, which keep it level and secure regardless of geological conditions or activity. The entire facility is covered by a skin of adaptive plating originally designed for terraforming platforms, a protective barrier that insulates it from the surrounding environment. Visitors can expect a prolonged and immodest decontamination and pressurization process when first arriving at the command structure. Valuable materials are lifted off world by a bulk payload, reusable rocket, the scattered components of which are retrieved by cargo drones.",4568,0,5000,100,500,1,0,670000,0,0,0,0,41,0,0,9274156);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2140,1027,"Standard Ice Command Center","This command structure is designed to survive in the harshest planetary environments the universe can offer. The superstructure uses a combination of titanium-steel reinforcement, increasing its overall resilience, and counter-harmonic stabilizers, which keep it level and secure regardless of geological conditions or activity. The entire facility is covered by a skin of adaptive plating originally designed for terraforming platforms, a protective barrier that insulates it from the surrounding environment. Visitors can expect a prolonged and immodest decontamination and pressurization process when first arriving at the command structure. Valuable materials are lifted off world by a bulk payload, reusable rocket, the scattered components of which are retrieved by cargo drones.",4568,0,5000,200,500,1,0,1.6e+006,0,0,0,0,41,0,0,9274157);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2141,1027,"Improved Ice Command Center","This command structure is designed to survive in the harshest planetary environments the universe can offer. The superstructure uses a combination of titanium-steel reinforcement, increasing its overall resilience, and counter-harmonic stabilizers, which keep it level and secure regardless of geological conditions or activity. The entire facility is covered by a skin of adaptive plating originally designed for terraforming platforms, a protective barrier that insulates it from the surrounding environment. Visitors can expect a prolonged and immodest decontamination and pressurization process when first arriving at the command structure. Valuable materials are lifted off world by a bulk payload, reusable rocket, the scattered components of which are retrieved by cargo drones.",4568,0,5000,400,500,1,0,2.8e+006,0,0,0,0,41,0,0,9274155);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2142,1027,"Advanced Ice Command Center","This command structure is designed to survive in the harshest planetary environments the universe can offer. The superstructure uses a combination of titanium-steel reinforcement, increasing its overall resilience, and counter-harmonic stabilizers, which keep it level and secure regardless of geological conditions or activity. The entire facility is covered by a skin of adaptive plating originally designed for terraforming platforms, a protective barrier that insulates it from the surrounding environment. Visitors can expect a prolonged and immodest decontamination and pressurization process when first arriving at the command structure. Valuable materials are lifted off world by a bulk payload, reusable rocket, the scattered components of which are retrieved by cargo drones.",4568,0,5000,800,500,1,0,3.7e+006,0,0,0,0,41,0,0,9274153);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2143,1027,"Elite Ice Command Center","This command structure is designed to survive in the harshest planetary environments the universe can offer. The superstructure uses a combination of titanium-steel reinforcement, increasing its overall resilience, and counter-harmonic stabilizers, which keep it level and secure regardless of geological conditions or activity. The entire facility is covered by a skin of adaptive plating originally designed for terraforming platforms, a protective barrier that insulates it from the surrounding environment. Visitors can expect a prolonged and immodest decontamination and pressurization process when first arriving at the command structure. Valuable materials are lifted off world by a bulk payload, reusable rocket, the scattered components of which are retrieved by cargo drones.",4568,0,5000,1600,500,1,0,6.4e+006,0,0,0,0,41,0,0,9274154);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2144,1027,"Limited Lava Command Center","This command structure is designed to survive in the harshest planetary environments the universe can offer. The superstructure uses a combination of titanium-steel reinforcement, increasing its overall resilience, and counter-harmonic stabilizers, which keep it level and secure regardless of geological conditions or activity. The entire facility is covered by a skin of adaptive plating originally designed for terraforming platforms, a protective barrier that insulates it from the surrounding environment. Visitors can expect a prolonged and immodest decontamination and pressurization process when first arriving at the command structure. Valuable materials are lifted off world by a bulk payload, reusable rocket, the scattered components of which are retrieved by cargo drones.",4568,0,5000,100,500,1,0,670000,0,0,0,0,41,0,0,9274141);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2145,1027,"Standard Lava Command Center","This command structure is designed to survive in the harshest planetary environments the universe can offer. The superstructure uses a combination of titanium-steel reinforcement, increasing its overall resilience, and counter-harmonic stabilizers, which keep it level and secure regardless of geological conditions or activity. The entire facility is covered by a skin of adaptive plating originally designed for terraforming platforms, a protective barrier that insulates it from the surrounding environment. Visitors can expect a prolonged and immodest decontamination and pressurization process when first arriving at the command structure. Valuable materials are lifted off world by a bulk payload, reusable rocket, the scattered components of which are retrieved by cargo drones.",4568,0,5000,200,500,1,0,1.6e+006,0,0,0,0,41,0,0,9274142);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2146,1027,"Improved Lava Command Center","This command structure is designed to survive in the harshest planetary environments the universe can offer. The superstructure uses a combination of titanium-steel reinforcement, increasing its overall resilience, and counter-harmonic stabilizers, which keep it level and secure regardless of geological conditions or activity. The entire facility is covered by a skin of adaptive plating originally designed for terraforming platforms, a protective barrier that insulates it from the surrounding environment. Visitors can expect a prolonged and immodest decontamination and pressurization process when first arriving at the command structure. Valuable materials are lifted off world by a bulk payload, reusable rocket, the scattered components of which are retrieved by cargo drones.",4568,0,5000,400,500,1,0,2.8e+006,0,0,0,0,41,0,0,9274140);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2147,1027,"Advanced Lava Command Center","This command structure is designed to survive in the harshest planetary environments the universe can offer. The superstructure uses a combination of titanium-steel reinforcement, increasing its overall resilience, and counter-harmonic stabilizers, which keep it level and secure regardless of geological conditions or activity. The entire facility is covered by a skin of adaptive plating originally designed for terraforming platforms, a protective barrier that insulates it from the surrounding environment. Visitors can expect a prolonged and immodest decontamination and pressurization process when first arriving at the command structure. Valuable materials are lifted off world by a bulk payload, reusable rocket, the scattered components of which are retrieved by cargo drones.",4568,0,5000,800,500,1,0,3.7e+006,0,0,0,0,41,0,0,9274138);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2148,1027,"Elite Lava Command Center","This command structure is designed to survive in the harshest planetary environments the universe can offer. The superstructure uses a combination of titanium-steel reinforcement, increasing its overall resilience, and counter-harmonic stabilizers, which keep it level and secure regardless of geological conditions or activity. The entire facility is covered by a skin of adaptive plating originally designed for terraforming platforms, a protective barrier that insulates it from the surrounding environment. Visitors can expect a prolonged and immodest decontamination and pressurization process when first arriving at the command structure. Valuable materials are lifted off world by a bulk payload, reusable rocket, the scattered components of which are retrieved by cargo drones.",4568,0,5000,1600,500,1,0,6.4e+006,0,0,0,0,41,0,0,9274139);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2149,1027,"Limited Oceanic Command Center","Several interconnected underwater buildings comprise the oceanic command center, which serves as the nervous system for node structures built on water worlds. Built on the ocean floor, this facility includes a thick umbilical that connects it to a communications pod floating on the surface, through which all interplanetary transmissions are sent and received. It also houses a basic two-stage pressurized rocket tube for getting people and cargo to the surface and thence off world into orbit.",4567,0,5000,100,500,1,0,670000,0,0,0,0,41,0,0,9274131);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2150,1027,"Standard Oceanic Command Center","Several interconnected underwater buildings comprise the oceanic command center, which serves as the nervous system for node structures built on water worlds. Built on the ocean floor, this facility includes a thick umbilical that connects it to a communications pod floating on the surface, through which all interplanetary transmissions are sent and received. It also houses a basic two-stage pressurized rocket tube for getting people and cargo to the surface and thence off world into orbit.",4567,0,5000,200,500,1,0,1.6e+006,0,0,0,0,41,0,0,9274132);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2151,1027,"Improved Oceanic Command Center","Several interconnected underwater buildings comprise the oceanic command center, which serves as the nervous system for node structures built on water worlds. Built on the ocean floor, this facility includes a thick umbilical that connects it to a communications pod floating on the surface, through which all interplanetary transmissions are sent and received. It also houses a basic two-stage pressurized rocket tube for getting people and cargo to the surface and thence off world into orbit.",4567,0,5000,400,500,1,0,2.8e+006,0,0,0,0,41,0,0,9274130);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2152,1027,"Advanced Oceanic Command Center","Several interconnected underwater buildings comprise the oceanic command center, which serves as the nervous system for node structures built on water worlds. Built on the ocean floor, this facility includes a thick umbilical that connects it to a communications pod floating on the surface, through which all interplanetary transmissions are sent and received. It also houses a basic two-stage pressurized rocket tube for getting people and cargo to the surface and thence off world into orbit.",4567,0,5000,800,500,1,0,3.7e+006,0,0,0,0,41,0,0,9274128);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2153,1027,"Elite Oceanic Command Center","Several interconnected underwater buildings comprise the oceanic command center, which serves as the nervous system for node structures built on water worlds. Built on the ocean floor, this facility includes a thick umbilical that connects it to a communications pod floating on the surface, through which all interplanetary transmissions are sent and received. It also houses a basic two-stage pressurized rocket tube for getting people and cargo to the surface and thence off world into orbit.",4567,0,5000,1600,500,1,0,6.4e+006,0,0,0,0,41,0,0,9274129);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2154,1027,"Limited Plasma Command Center","This command structure is designed to survive in the harshest planetary environments the universe can offer. The superstructure uses a combination of titanium-steel reinforcement, increasing its overall resilience, and counter-harmonic stabilizers, which keep it level and secure regardless of geological conditions or activity. The entire facility is covered by a skin of adaptive plating originally designed for terraforming platforms, a protective barrier that insulates it from the surrounding environment. Visitors can expect a prolonged and immodest decontamination and pressurization process when first arriving at the command structure. Valuable materials are lifted off world by a bulk payload, reusable rocket, the scattered components of which are retrieved by cargo drones.",4568,0,5000,100,500,1,0,670000,0,0,0,0,41,0,0,9274151);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2155,1027,"Standard Plasma Command Center","This command structure is designed to survive in the harshest planetary environments the universe can offer. The superstructure uses a combination of titanium-steel reinforcement, increasing its overall resilience, and counter-harmonic stabilizers, which keep it level and secure regardless of geological conditions or activity. The entire facility is covered by a skin of adaptive plating originally designed for terraforming platforms, a protective barrier that insulates it from the surrounding environment. Visitors can expect a prolonged and immodest decontamination and pressurization process when first arriving at the command structure. Valuable materials are lifted off world by a bulk payload, reusable rocket, the scattered components of which are retrieved by cargo drones.",4568,0,5000,200,500,1,0,1.6e+006,0,0,0,0,41,0,0,9274152);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2156,1027,"Improved Plasma Command Center","This command structure is designed to survive in the harshest planetary environments the universe can offer. The superstructure uses a combination of titanium-steel reinforcement, increasing its overall resilience, and counter-harmonic stabilizers, which keep it level and secure regardless of geological conditions or activity. The entire facility is covered by a skin of adaptive plating originally designed for terraforming platforms, a protective barrier that insulates it from the surrounding environment. Visitors can expect a prolonged and immodest decontamination and pressurization process when first arriving at the command structure. Valuable materials are lifted off world by a bulk payload, reusable rocket, the scattered components of which are retrieved by cargo drones.",4568,0,5000,400,500,1,0,2.8e+006,0,0,0,0,41,0,0,9274150);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2157,1027,"Advanced Plasma Command Center","This command structure is designed to survive in the harshest planetary environments the universe can offer. The superstructure uses a combination of titanium-steel reinforcement, increasing its overall resilience, and counter-harmonic stabilizers, which keep it level and secure regardless of geological conditions or activity. The entire facility is covered by a skin of adaptive plating originally designed for terraforming platforms, a protective barrier that insulates it from the surrounding environment. Visitors can expect a prolonged and immodest decontamination and pressurization process when first arriving at the command structure. Valuable materials are lifted off world by a bulk payload, reusable rocket, the scattered components of which are retrieved by cargo drones.",4568,0,5000,800,500,1,0,3.7e+006,0,0,0,0,41,0,0,9274148);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2158,1027,"Elite Plasma Command Center","This command structure is designed to survive in the harshest planetary environments the universe can offer. The superstructure uses a combination of titanium-steel reinforcement, increasing its overall resilience, and counter-harmonic stabilizers, which keep it level and secure regardless of geological conditions or activity. The entire facility is covered by a skin of adaptive plating originally designed for terraforming platforms, a protective barrier that insulates it from the surrounding environment. Visitors can expect a prolonged and immodest decontamination and pressurization process when first arriving at the command structure. Valuable materials are lifted off world by a bulk payload, reusable rocket, the scattered components of which are retrieved by cargo drones.",4568,0,5000,1600,500,1,0,6.4e+006,0,0,0,0,41,0,0,9274149);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2159,1027,"Limited Storm Command Center","This command structure is designed to survive in the harshest planetary environments the universe can offer. The superstructure uses a combination of titanium-steel reinforcement, increasing its overall resilience, and counter-harmonic stabilizers, which keep it level and secure regardless of geological conditions or activity. The entire facility is covered by a skin of adaptive plating originally designed for terraforming platforms, a protective barrier that insulates it from the surrounding environment. Visitors can expect a prolonged and immodest decontamination and pressurization process when first arriving at the command structure. Valuable materials are lifted off world by a bulk payload, reusable rocket, the scattered components of which are retrieved by cargo drones.",4568,0,5000,100,500,1,0,670000,0,0,0,0,41,0,0,9274136);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2160,1027,"Standard Storm Command Center","This command structure is designed to survive in the harshest planetary environments the universe can offer. The superstructure uses a combination of titanium-steel reinforcement, increasing its overall resilience, and counter-harmonic stabilizers, which keep it level and secure regardless of geological conditions or activity. The entire facility is covered by a skin of adaptive plating originally designed for terraforming platforms, a protective barrier that insulates it from the surrounding environment. Visitors can expect a prolonged and immodest decontamination and pressurization process when first arriving at the command structure. Valuable materials are lifted off world by a bulk payload, reusable rocket, the scattered components of which are retrieved by cargo drones.",4568,0,5000,200,500,1,0,1.6e+006,0,0,0,0,41,0,0,9274137);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2161,25,"Crucifier","The Crucifier was first designed as an explorer/scout, but the current version employs the electronic equipment originally intended for scientific studies for more offensive purposes. The Crucifier\'s electronic and computer systems take up a large portion of the internal space leaving limited room for cargo or traditional weaponry.


10% bonus to Small Energy Turret capacitor use and 5% bonus to Tracking Disruptor effectiveness per skill level.  ",1066,39,1.064e+006,28100,165,1,4,150000,1,72,0.070000,0,6,0,422,3257028);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2162,105,"Crucifier Blueprint","",1066,0,0,0.010000,0,1,0,1.5e+006,1,272,0,0,9,0,422,729427);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2163,952,"CONCORD Collection Vessel","A CONCORD ship.",1053,39,0,0,100,1,0,0,0,0,0,0,11,0,0,7677476);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2164,26,"Arbitrator House Ardishapur","The Arbitrator is unusual for Amarr ships in that its primarily a drone carrier. While it is not the best carrier around, it has superior armor that gives it greater durability than most ships in its class.",1914,192,1.5385e+007,120000,1400,1,4,0,0,0,0.070000,0,6,0,422,729430);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2165,386,"Haunter Cruise Missile","Extra heavy assault missile. The first and only Minmatar-made large missile. Constructed of reactionary alloys, the Wrath is built to get to the target. Guidance and propulsion systems are of Gallentean origin and were initially used in drones, making Wrath fast and nimble despite its heavy payload. ",183,300,1250,0.050000,0,100,0,10000,0,0,0.070000,0,8,183,422,9441605);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2166,26,"Arbitrator House Tash-Murkon","The Arbitrator is unusual for Amarr ships in that its primarily a drone carrier. While it is not the best carrier around, it has superior armor that gives it greater durability than most ships in its class.",298,192,1.5385e+007,120000,1250,1,4,0,0,0,0.070000,0,6,0,422,729433);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2168,26,"Arbitrator House Kor-Azor","The Arbitrator is unusual for Amarr ships in that its primarily a drone carrier. While it is not the best carrier around, it has superior armor that gives it greater durability than most ships in its class.",1864,192,1.5385e+007,120000,1250,1,4,0,0,0,0.070000,0,6,0,422,729436);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2173,100,"Infiltrator I","Medium Scout Drone",2778,20,5000,10,0,1,4,17000,1,838,0.070000,0,18,0,422,9431744);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2174,176,"Infiltrator I Blueprint","",1008,0,0,0.010000,0,1,0,1.7e+006,1,359,0,0,9,0,422,729442);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2175,100,"Infiltrator II","Medium Scout Drone",1109,20,5000,10,0,1,4,78952,1,838,0.060000,0,18,0,422,9431745);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2176,176,"Infiltrator II Blueprint","",1109,0,0,0.010000,0,1,0,1e+007,1,359,0,0,9,0,422,729448);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2178,1019,"Guristas Catastrophe Citadel Cruise Missile","Citadel Cruise Missiles are designed for long range bombardment of capital ships and installations. They are a specialized design usable only by capital ships.


Nocxium atoms captured in morphite matrices form this missile\'s devastating payload. A volley of these is able to completely obliterate almost everything that floats in space, be it vehicle or structure.",185,300,1500,0.300000,0,100,0,250000,1,1317,0.070000,0,8,185,422,13189637);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2179,166,"Sansha Wrath Cruise Missile Blueprint","",183,0,1,0.010000,0,1,0,3e+006,1,0,0,0,9,183,0,9239236);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2180,1019,"Guristas Rajas Citadel Cruise Missile","Citadel Cruise Missiles are designed for long range bombardment of capital ships and installations. They are a specialized design usable only by capital ships.


Fitted with a graviton pulse generator, this weapon causes massive damage as it overwhelms ships\' internal structures, tearing bulkheads and armor plating apart with frightening ease.",183,300,1500,0.300000,0,100,0,300000,1,1317,0.070000,0,8,183,422,7683048);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2181,306,"Minmatar Diplomat Quarters","A small bunker, there for accommodation and increased mobility of troops and other personnel. ",2479,713,100000,1e+008,10000,1,0,0,0,0,0,0,11,0,0,9239369);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2182,1019,"Guristas Sol Citadel Cruise Missile","Citadel Cruise Missiles are designed for long range bombardment of capital ships and installations. They are a specialized design usable only by capital ships.


Plasma suspended in an electromagnetic field gives this torpedo the ability to deliver a flaming inferno of destruction, wreaking almost unimaginable havoc.",184,300,1500,0.300000,0,100,0,325000,1,1317,0.070000,0,8,184,422,7683080);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2183,100,"Hammerhead I","Medium Scout Drone",2774,20,5000,10,0,1,8,18000,1,838,0.070000,0,18,0,422,9431732);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2184,176,"Hammerhead I Blueprint","",2774,0,0,0.010000,0,1,0,1.8e+006,1,359,0,0,9,0,422,3256138);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2185,100,"Hammerhead II","Medium Scout Drone",1095,20,5000,10,0,1,8,83536,1,838,0.060000,0,18,0,422,9431733);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2186,176,"Hammerhead II Blueprint","",1095,0,0,0.010000,0,1,0,1e+007,1,359,0,0,9,0,422,729460);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2187,952,"Orca Container","The Orca was developed as a joint venture between Outer Ring Excavations and Deep Core Mining Inc as a vessel to help meet the demands of New Eden\'s industry and provide a flexible platform from which mining operations can be more easily managed. The Orca uses much of the technology developed by ORE for the Rorqual and integrated with the latest advancements from Deep Core Mining research division has developed a vessel which offers a diverse role to all sizes of operations and needs.",3466,550,0,0,500,1,0,0,0,0,0,0,11,0,0,9240106);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2188,1019,"Guristas Thunar Citadel Cruise Missile","Citadel Cruise Missiles are designed for long range bombardment of capital ships and installations. They are a specialized design usable only by capital ships.


Nothing more than a baby nuclear warhead, this guided missile wreaks havoc with the delicate electronic systems aboard a starship. Specifically designed to damage shield systems, it is able to ravage heavily shielded targets in no time.",182,300,1500,0.300000,0,100,0,350000,1,1317,0.070000,0,8,182,422,7683115);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2189,952,"Drone Infested Dominix","",1718,250,1.05e+008,1.01e+006,600,1,8,0,0,0,0,0,11,0,0,9240192);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2190,1053,"Renyn Meten","Subject:  Prototype Nation Vessel (ID: Renyn Meten)


  Frigate-class vessel. Primary anti-support damage dealer amongst frigate-class prototypes. Significant microwarp velocity. Short range laser systems.


  There were no reported civilian abductions from the Renyn VI invasion. The Renyn identifier suggests a small number of captives may have been initially unaccounted for, as with the Eystur Rhomben variant. The Meten identifier suggests an oversight role amongst the other frigate-class prototypes, or alternatively, that it was created during the first phase of development.


Synopsis from ISHAEKA-0043. DED Special Operations.
Authorized for Capsuleer dissemination.
",1237,31,2e+006,20000,235,1,4,0,0,0,0,31,11,0,0,9269178);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2191,1054,"Antem Neo","Subject: Prototype Nation Vessel (ID:Antem Neo)


 Cruiser-class vessel. Primary role is long-range sniping support. Moderate microwarp velocity. Vessel will attempt to establish orbit ranges in excess of 100km.


 Est. 900,000 civilian abductions from Antem IV. The Neo identifier suggests this variant was designed recently, or alternatively, is an improvement upon other, pre-existing designs. Possible links to the Mara Paleo variant.


Synopsis from ISHAEKA-0059. DED Special Operations.
Authorized for Capsuleer dissemination.
",1236,150,1.001e+007,100100,235,1,4,0,0,0,0.070000,31,11,0,0,9269199);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2192,1052,"The Kundalini Manifest","True power lies within all of us. Coiled beneath our fears and insecurities like a resting serpent, it has waited with infinite patience for those last few layers of our imperfection to be stripped away. It waits, as we strive, for a freedom only this part of ourselves truly deserves.


For as long as human history records, we have ignored what we truly are, and worse, we have ignored everything we could yet become. We must learn, now, to let go. Not everything we have taken with us so far on this journey should remain.

Our flaws and faults, these near-indelible errors pervading throughout human history, they can all be removed. Together, as one, we can overcome the enemy within.

- Sansha Kuvakei
",10038,2840,1.54688e+009,6.2e+007,1337,1,4,0,0,0,0.070000,10002,11,0,0,11802448);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2193,100,"Praetor I","Heavy Attack Drone",1119,35,10000,25,0,1,4,60000,1,839,0.070000,0,18,0,422,9431760);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2194,176,"Praetor I Blueprint","",1119,0,0,0.010000,0,1,0,6e+006,1,359,0,0,9,0,422,729466);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2195,100,"Praetor II","Heavy Attack Drone",1120,35,10000,25,0,1,4,191072,1,839,0.060000,0,18,0,422,9431761);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2196,176,"Praetor II Blueprint","",1120,0,0,0.010000,0,1,0,1e+007,1,359,0,0,9,0,422,729472);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2197,314,"Environmentally-friendly Mining Equipment","The latest generation of environmentally-friendly mining drills reduces airborne pollutants by 75% when compared to the most popular drills on the market. This is accomplished through a revolutionary “dust recapture” system that essentially vacuums the air around the drill head. The collected dust is captured in large, on-site filtration systems which then compacts the dust into blocks. These blocks can either be refined along with the extracted ores, or simply placed back into the mine as backfill once drilling operations are complete. While more than five times as expensive as normal drills, the efficiency of these new models provides an entirely new level of environmental protection. ",0,0,70,32,0,1,0,0,1,0,0,0,17,2852,0,11761654);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2198,314,"Crate of Environmentally-friendly Mining Equipment","The latest generation of environmentally-friendly mining drills reduces airborne pollutants by 75% when compared to the most popular drills on the market. This is accomplished through a revolutionary “dust recapture” system that essentially vacuums the air around the drill head. The collected dust is captured in large, on-site filtration systems which then compacts the dust into blocks. These blocks can either be refined along with the extracted ores, or simply placed back into the mine as backfill once drilling operations are complete. While more than five times as expensive as normal drills, the efficiency of these new models provides an entirely new level of environmental protection. ",0,0,210,450,0,1,0,0,1,0,0,0,17,2852,0,9256039);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2199,314,"Prototype Body Armor Fabric ","This energy and force-absorbing fabric could represent a generational advancement in light body armor technology. What makes this remarkable fabric unique is that it contains microscopically thin layers of an advanced polymer containing nanites programmed for self-repair. In short, when a suit of body armor made form this material is impacted by any significant force, the nanites instantly begin to repair any damage done, which protects the wearer from further harm. Most importantly, during the manufacturing phase, if the fabric is properly pre-stressed, the nanites are forced to bond thus creating stronger and stronger material, without any increase in weight or decrease in flexibility. For these reasons, this prototype body armor fabric will undoubtedly become the most sought-after material for those groups able to afford its exorbitant price. ",0,0,50,20,0,1,0,0,1,0,0,0,17,1189,0,9242139);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2200,314,"Crate of Prototype Body Armor Fabric ","This energy and force-absorbing fabric could represent a generational advancement in light body armor technology. What makes this remarkable fabric unique is that it contains microscopically thin layers of an advanced polymer containing nanites programmed for self-repair. In short, when a suit of body armor made form this material is impacted by any significant force, the nanites instantly begin to repair any damage done, which protects the wearer from further harm. Most importantly, during the manufacturing phase, if the fabric is properly pre-stressed, the nanites are forced to bond thus creating stronger and stronger material, without any increase in weight or decrease in flexibility. For these reasons, this prototype body armor fabric will undoubtedly become the most sought-after material for those groups able to afford its exorbitant price. ",0,0,5000,2000,0,1,0,0,1,0,0,0,17,1189,0,9242140);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2201,314,"Riot Interdiction Team","Riot Interdiction Teams, or RITs, are the primary Amarrian response forces for incidents involving slave riots and uprisings. These forces are equipped with the latest generations of body armor, stun sticks, flash-bang grenades, and other less-lethal technologies. In those cases where less-lethal force is insufficient, the teams are fully trained and equipped to use lethal force to resolve any such threat. For example, the RITs are often called in to resolve hostage situations in which one or more of the captives has been killed, thus eliminating the need for a phased operation and then transitioning to lethal force contingency operations (i.e., shoot to kill). Therefore, it is of little surprise that they are among the most highly trained Amarr ground forces in hostage rescue operations, and are sometimes called on to act in situations unrelated to slave-based scenarios.",0,0,30,30,0,1,0,0,1,0,0,0,17,2549,0,9242141);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2202,314,"Riot Interdiction Teams","Riot Interdiction Teams, or RITs, are the primary Amarrian response forces for incidents involving slave riots and uprisings. These forces are equipped with the latest generations of body armor, stun sticks, flash-bang grenades, and other less-lethal technologies. In those cases where less-lethal force is insufficient, the teams are fully trained and equipped to use lethal force to resolve any such threat. For example, the RITs are often called in to resolve hostage situations in which one or more of the captives has been killed, thus eliminating the need for a phased operation and then transitioning to lethal force contingency operations (i.e., shoot to kill). Therefore, it is of little surprise that they are among the most highly trained Amarr ground forces in hostage rescue operations, and are sometimes called on to act in situations unrelated to slave-based scenarios.",0,0,500,300,0,1,0,0,1,0,0,0,17,2549,0,9242142);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2203,100,"Acolyte I","Light Scout Drone",1084,15,3000,5,0,1,4,2000,1,837,0.070000,0,18,1084,422,9431701);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2204,176,"Acolyte I Blueprint","",1084,0,0,0.010000,0,1,0,200000,1,359,0,0,9,1084,422,729478);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2205,100,"Acolyte II","Light Scout Drone",2764,15,3000,5,0,1,4,34768,1,837,0.060000,0,18,0,422,9431702);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2206,176,"Acolyte II Blueprint","",1085,0,0,0.010000,0,1,0,1e+007,1,359,0,0,9,0,422,729484);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2207,1054,"Vylade Dien","Subject: Prototype Nation Vessel (ID: Vylade Dien)


 Cruiser-class vessel. Primary roles are damage dealing and squad enhancement. Low microwarp velocity.


 Est. 100,000 civilian abductions from Vylade II. The Dien identifier suggests an oversight role amongst other cruiser-class prototypes, or alternatively, that it was created during the first phase of development. The nature of Nation’s squad boosting technology is still not fully understood, although current intelligence from recovered wrecks indicates that the designs deviates from standard warfare links in the same way as Tech III Warfare Processors.


Synopsis from ISHAEKA-0047. DED Special Operations.
Authorized for Capsuleer dissemination.
",1236,150,1.001e+007,100100,235,1,4,0,0,0,0.070000,31,11,0,0,9269180);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2208,1054,"Uitra Telen","Subject: Prototype Nation Vessel (ID: Uitra Telen)


 Cruiser-class vessel. Moderate microwarp velocity. Limited weapons systems.


 Est. 210,000 civilian abductions from VII. The Telen identifier suggests an oversight role amongst other Cruiser-class variants, or that other, more advanced prototypes may have originated from this design.


Synopsis from ISHAEKA-0055. DED Special Operations.
Authorized for Capsuleer dissemination.
",1236,150,1.001e+007,100100,235,1,4,0,0,0,0.070000,31,11,0,0,9439705);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2209,1054,"Arnon Epithalamus","Subject: Prototype Nation Vessel (ID: Arnon Epithalmus)


 Cruiser-class vessel. Primary role is extreme range ECM support. Low microwarp velocity. Long range missile support.


 There were no reported civilian abductions from the invasion of Arnon III, IX and XI. The Arnon identifier suggests a number of captives may have been initially unaccounted for, as with the Eystur Rhomben and Renyn Meten variants. This supports previous conjecture that Nation’s synchronized attacks on multiple planets were at least partly designed to aid in covert abduction. The Epithalmus identifier suggests a unifying role between the cruiser-class prototypes and other hull classes, and perhaps an additional regulatory role in crew emotional response, similar to the suspected behavior of the Tama Cerebellum variant.


Synopsis from ISHAEKA-0049. DED Special Operations.
Authorized for Capsuleer dissemination.
",1236,150,1.001e+007,100100,235,1,4,0,0,0,0.070000,31,11,0,0,9269181);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2210,89,"Banshee Torpedo","An ultra-heavy piercing missile. Slow and dumb but its sheer damage potential is simply staggering.",1346,300,1500,0.100000,0,100,0,30000,0,0,0.070000,0,8,1346,422,9441603);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2211,166,"Sansha Juggernaut Torpedo Blueprint","",1346,0,1,0.010000,0,1,0,9e+006,1,0,0,0,9,1346,0,9237850);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2212,385,"Ghost Heavy Missile","The Scourge is an old relic from the Caldari-Gallente War that is still in widespread use because of its low price and versatility.",189,300,1000,0.030000,0,100,0,2500,1,0,0.070000,0,8,189,422,9441604);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2213,166,"Sansha Scourge Heavy Missile Blueprint","",189,0,1,0.010000,0,1,0,750000,1,0,0,0,9,189,0,9237880);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2214,952,"Guard Post","This inconspicuous guard post is awaiting security clearance before taking any action.",1991,4007,100000,27500,2700,1,0,0,0,0,0,0,11,0,0,9238373);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2215,314,"Amarr TIL-1A Nexus Chips ","The Amarr TIL-1A Nexus Chip was once used to store the key elements of a ship\'s artificial intelligence system, as well as for controlling some of the vessel\'s autonomous functions. In addition, the TIL-1A series chip had been modified by top Viziam scientists for the Amarr Navy, making it far more resilient to damage and harsh environmental conditions than standard chips of its kind. The TIL-1A chip, specifically, was designed for front-line Amarr battleship-class vessels where it saw widespread use for almost a decade before being replaced by newer technologies. As a result, very few examples of this remain outside Amarr military historical archives, where they are often highly valued for the data they contain on early naval operations. ",0,0,1,12,0,1,0,0,1,0,0,0,17,2038,0,9242155);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2216,314,"Crate of Amarr TIL-1A Nexus Chips","The Amarr TIL-1A Nexus Chip was once used to store the key elements of a ship\'s artificial intelligence system, as well as for controlling some of the vessel\'s autonomous functions. In addition, the TIL-1A series chip had been modified by top Viziam scientists for the Amarr Navy, making it far more resilient to damage and harsh environmental conditions than standard chips of its kind. The TIL-1A chip, specifically, was designed for front-line Amarr battleship-class vessels where it saw widespread use for almost a decade before being replaced by newer technologies. As a result, very few examples of this remain outside Amarr military historical archives, where they are often highly valued for the data they contain on early naval operations. ",0,0,10,120,0,1,0,0,1,0,0,0,17,2038,0,9242156);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2217,283,"Preacher","Tolmak\'s preachers serve as his proxies, and are the primary way he spreads his controversial message.",0,0,65,1,0,1,0,0,1,0,0,0,17,3036,0,9238354);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2218,306,"Locced\'s Bribe","This cargo container is filled with all the extra supplies the pirates brought along with them.",16,14,10000,27500,2700,1,0,0,0,0,0,0,11,16,0,8703015);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2219,314,"Large Group of Civilian Workers and Dependents","Civilian workers and their dependents, including men, women, and children.",0,0,110,125,0,1,0,0,1,0,0,0,17,2539,0,9256071);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2220,314,"Civilian Workers and Dependents","Civilian workers and their dependents, including men, women, and children.",0,0,11,12,0,1,0,0,1,0,0,0,17,2539,0,9242158);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2221,314,"Manportable Electromagnetic Pulse Weapons ","These EM beam weapons have been custom fitted to detect and eradicate specific nanotechnologies. Normally, these EMP devices are used by special operations personnel during covert operations. They are placed in proximity to the enemy’s defense grid and used to “short out” any nearby electronics, thus creating a hole in the defense grid such that conventional forces can then move through unimpeded by sentry grids, security bots, and other lethal defensive systems. The devices themselves are approximately the size of a large rucksack and can be both emplaced and operated by a single trained individual. ",0,0,25,25,0,1,0,0,1,0,0,0,17,1362,0,9242159);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2222,673,"Scions of the Superior Gene","The Scions of the Superior Gene are a minor extremist cult. They believe that the Jovians are gods, and their technology is sacred – too pure to be used by the lowly empires. They have a small fleet of well-armed ships used exclusively to \"purify\" those who they feel have offended the Jovians.


",42,150,1.01e+007,101000,235,1,1,0,0,0,0.070000,0,11,0,0,9238364);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2223,306,"Preacher\'s Quarters","The architectural design for the CreoDron Habitation Module started out as a contract deal from the Expert Housing Corporation to standardize the modular drifter homes normally used by miners and deep space explorers. When the project was cancelled due to insufficient funding, CreoDron utilized their design for the open market as high-orbit department buildings for commercial use. The marketing was a tremendous hit, making the Habitation Module a common sight across the universe. Common uses include anything from bars, casinos and brothels, to police stations and interrogation facilities.",2515,379,100000,1e+008,8850,1,0,0,0,0,0,0,11,0,0,9238419);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2224,1006,"Tolmak\'s Zealots","Tolmak has managed to convert a number of people to his religious message. Some of them are so fanatical they\'re willing to fight for him. These zealots form a motley fleet of whatever small ships they have been able to buy with donations from their planetside brethren.",1730,150,1.15e+007,115000,465,1,4,0,0,0,0,0,11,0,0,8705365);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2226,283,"Sisters of Eve Negotiator","An emissary sent by the Sisters of Eve to oversee peace talks.",0,0,1,1,0,1,0,0,1,0,0,0,17,2538,0,8711282);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2232,306,"Life pod","A life pod from a long since destroyed ship.",73,2,10000,1200,1400,1,0,0,0,0,0,0,11,73,0,8712121);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2233,1025,"Customs Office","Orbital Customs Offices are the primary points of contact between planetary and interplanetary economies. These facilities, resembling massive hangars in space, provide high-volume, high-frequency cargo transport services between a planet\'s surface and orbit.








Narcotic substances; handheld firearms; slaver hounds (except as personal property); Mindflood; live insects; ungulates; Class 1 refrigerants and aerosols; forced laborers/personal slaves (or other sapient livestock); animal germ-plasm; biomass of human origin; xenobiotics; walnuts.",4579,15000,5e+009,1e+008,25000,1,0,0,0,0,0,0,41,0,0,9431825);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2234,226,"Sansha\'s Battletower LCO","This gigantic war station is one of the military installations of Sansha\'s slumbering nation.  It is known to be able to hold a massive number of Sansha vessels, but strange whispers hint at darker things than mere warfare going on underneath its jagged exterior.",2364,8960,100000,1e+008,10000,1,8,0,0,0,0,0,2,0,0,8826097);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2239,283,"Oura Madusaari","A half-mad young female Caldari salvager, she was among the few survivors of The Paryi\'s salvaging crew.",0,0,5,3,0,1,0,0,1,0,0,0,17,2537,0,8712311);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2240,283,"Harroken Ikero","A half-mad young male Caldari salvager, he was among the few survivors of The Paryi\'s salvaging crew.",0,0,5,3,0,1,0,0,1,0,0,0,17,2536,0,8712312);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2241,283,"Doctor Untermere","A weaselly man with long hair and a constant scowl on his face.",0,0,65,1,0,1,0,0,1,0,0,0,17,2891,0,9067483);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2244,283,"Fajah Ateshi","A serious middle-aged female Amarr scientist, Dr. Ateshi remained eerily calm while the crew all around her lost their minds. She attributes her survival to God being on her side.",0,0,5,3,0,1,0,0,1,0,0,0,17,2891,0,8712671);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2250,314,"Neurowave Pattern Scanner","This scanner will track the brainwaves of any living creatures within a ship.",0,0,1,0.100000,0,1,0,0,1,0,0,0,17,2037,0,8713890);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2252,226,"Roden Station","This facility bares red color scheme particular to Roden Shipyards.",3798,17876,0,1,0,1,8,600000,0,0,0,14,2,0,0,8720034);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2254,1027,"Temperate Command Center","The modular design of this administrative structure allows it to be deployed piecemeal from orbit, then manually assembled on the surface by MTACs and engineering personnel. Supported by self-regulating pylons that follow the contours of indigenous terrain, the facility can accommodate almost any severity of incline or other non-critical geological hazard. Once active, it serves as both a central command post to coordinate the activity of all other nodes and a basic transportation site for getting commodities off world using standard, vertically launched rockets.",4566,0,5000,1000,500,1,0,90000,1,1322,0,0,41,0,0,9431693);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2256,1030,"Temperate Launchpad","The temperate launchpad is able to send and receive payloads from orbit. Because of the relatively calm atmospheric conditions of most temperate planets, the primary focus of this facility is on interfacing effectively with adjacent facilities, allowing for passengers and commodities to be easily organized, scanned, and transported to the appropriate areas. The obvious importance of a centralized spaceport often leads to its becoming a focal point of local culture, including trade, entertainment, and even illegal activities.",4559,0,0,0,10000,1,0,900000,1,0,0,0,41,0,0,9237603);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2257,1029,"Ice Storage Facility","At some point, it all comes down to more metal.\" The designers of this storage site believed this adage above all else. The outer walls of each container are comprised of almost a meter of titanium alloy around a flexible, lightweight tritanium frame, all sealed with a few layers of active nanite coating to prevent microfractures and thermal warping. This combination allows the building to withstand nearly any environmental challenge. To prevent the tritanium supports from decaying, the interior is kept in a constant vacuum, and workers must wear fully sealed atmosphere suits at all times.",4572,0,0,0,5000,1,0,250000,1,0,0,0,41,0,0,8980366);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2258,202,"ECCM - Omni II","A secondary electronic array that provides a significant boost to sensor strength for a short time. 


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,0,1,0,127920,1,728,0.060000,0,7,104,422,9060022);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2259,202,"ECCM - Gravimetric II","A secondary electronic array that provides a significant boost to sensor strength for a short time. 


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,0,1,0,126656,1,725,0.060000,0,7,104,422,9060023);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2260,202,"ECCM - Ladar II","A secondary electronic array that provides a significant boost to sensor strength for a short time. 


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,0,1,0,126594,1,726,0.060000,0,7,104,422,9065593);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2261,202,"ECCM - Magnetometric II","A secondary electronic array that provides a significant boost to sensor strength for a short time. 


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,0,1,0,126452,1,727,0.060000,0,7,104,422,9060024);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2262,202,"ECCM - Radar II","A secondary electronic array that provides a significant boost to sensor strength for a short time. 


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,0,1,0,126404,1,729,0.060000,0,7,104,422,9065594);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2263,12,"Planetary Launch Container","This container has been launched from the planet surface into low orbit for collection by starships.  These containers will burn up within a few days if not collected.",4578,14,10000,27500,1000,1,0,0,0,0,0,0,2,0,0,8977915);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2267,1032,"Base Metals","Iron and nickel are two widespread, easily recognized examples of base metals, or those metals that oxidize relatively easily. Their tremendous usefulness in numerous applications ensures that base metals are always in high demand. Thankfully, so is their abundance on most planetary surfaces.",0,0,0,0.010000,0,1,0,0,1,1333,0,0,42,10024,0,9068356);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2268,1033,"Aqueous Liquids","The abundance of water on terrestrial planets is often a misconception: What many refer to offhandedly as \"water\" is often an amalgamation of many liquids, microscopic particles, and saturated compounds combined with water and other liquids. Aqueous liquids represent those liquids from which pure water can be separated easily from waste or hazardous particles, but only using the proper equipment.",0,0,0,0.010000,0,1,0,0,1,1333,0,0,42,10012,0,9068355);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2270,1032,"Noble Metals","Highly resistant to corrosion and oxidation, noble metals are somewhat rarer than base metals, yet they are just as sought after for their different electrical, material, and chemical attributes. When painstakingly refined and purified, some noble metal ores can produce \"precious metals.",0,0,0,0.010000,0,1,0,0,1,1333,0,0,42,10025,0,9068358);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2272,1032,"Heavy Metals","In small quantities, heavy metals are vital to life, providing essential minerals for biological processes. In bulk, they are commonly found in most construction materials, forming the most basic components of computer electronics and reinforced structures.",0,0,0,0.010000,0,1,0,0,1,1333,0,0,42,10026,0,9068357);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2280,1036,"Link","",0,0,0,0,1000,1,0,0,1,0,0,0,41,0,0,8836104);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2281,77,"Invulnerability Field II","Boosts shield resistance against all damage types. Penalty: Using more than one type of this module, or similar modules that affect the same resistance type, will result in a penalty to the boost you get on that type of resistance.",0,0,10000,5,0,1,0,362408,1,553,0.060000,0,7,81,422,9064385);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2282,157,"Invulnerability Field II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,328,0,0,9,81,422,9060025);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2284,226,"LCO Megathron (Roden)","The Megathron has established itself as one of the most feared and respected battleships around. Since its first appearance almost two decades ago it has seen considerable service in the troublesome regions on the outskirts of the Federation, helping to expand and defend Gallentean influence there.",3809,250,0,0,0,1,8,0,0,0,0,0,2,0,0,8736049);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2285,226,"LCO Dominix (Roden)","The Dominix is one of the old warhorses dating back to the Gallente-Caldari War. While no longer regarded as the king of the hill, it is by no means obsolete. Its formidable hulk and powerful weapons batteries means that anyone not in the largest and latest battleships will regret ever locking horns with it.",3808,250,0,0,0,1,8,0,0,0,0,0,2,0,0,8736158);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2286,1035,"Planktic Colonies","Harvested in mass quantities, planktic colonies are used for much more than just a bulk food source that flourishes in water-rich environments. Their cumulative biomass has advanced properties that contribute to some of the most advanced material and medical sciences in New Eden.",0,0,0,0.010000,0,1,0,0,1,1333,0,0,42,10035,0,8980303);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2287,1035,"Complex Organisms","Organic flora and fauna growing on worlds across the cluster technically qualify as “alien life,” though none of it has registered as sentient. However, their usefulness as comestibles or building materials in other areas of industry is invaluable.",0,0,0,0.010000,0,1,0,0,1,1333,0,0,42,10036,0,8980301);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2288,1035,"Carbon Compounds","Often referred to as the building blocks of life, carbon compounds form the basis of most organic material; hence, they are ideally suited for use in the early development of advanced, reactive molecules, such as those used in biofuel and supertensile structures.",0,0,0,0.010000,0,1,0,0,1,1333,0,0,42,10037,0,8980300);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2289,77,"Explosion Dampening Field I","Boosts shield resistance against explosive damage. Penalty: Using more than one type of this module, or similar modules that affect the same resistance type, will result in a penalty to the boost you get on that type of resistance.",0,0,10000,20,0,1,0,75000,1,553,0.070000,0,7,81,422,9064363);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2290,157,"Explosion Dampening Field I Blueprint","",0,0,0,0.010000,0,1,0,750000,1,328,0,0,9,81,422,9060026);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2291,77,"Ballistic Deflection Field I","Boosts shield resistance against kinetic damage. Penalty: Using more than one type of this module, or similar modules that affect the same resistance type, will result in a penalty to the boost you get on that type of resistance",0,0,10000,20,0,1,0,75000,1,553,0.070000,0,7,81,422,9064340);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2292,157,"Ballistic Deflection Field I Blueprint","",0,0,0,0.010000,0,1,0,750000,1,328,0,0,9,81,422,9060027);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2293,77,"Photon Scattering Field I","Boosts shield resistance against EM damage. Penalty: Using more than one type of this module, or similar modules that affect the same resistance type, will result in a penalty to the boost you get on that type of resistance.",0,0,10000,20,0,1,0,75000,1,553,0.070000,0,7,81,422,9064394);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2294,157,"Photon Scattering Field I Blueprint","",0,0,0,0.010000,0,1,0,750000,1,328,0,0,9,81,422,9060028);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2295,77,"Heat Dissipation Field I","Boosts shield resistance against thermal damage. Penalty: Using more than one type of this module, or similar modules that affect the same resistance type, will result in a penalty to the boost you get on that type of resistance.",0,0,10000,20,0,1,0,75000,1,553,0.070000,0,7,81,422,9064382);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2296,157,"Heat Dissipation Field I Blueprint","",0,0,0,0.010000,0,1,0,750000,1,328,0,0,9,81,422,9060029);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2297,77,"Explosion Dampening Field II","Boosts shield resistance against explosive damage. Penalty: Using more than one type of this module, or similar modules that affect the same resistance type, will result in a penalty to the boost you get on that type of resistance.",0,0,10000,5,0,1,0,271744,1,553,0.060000,0,7,81,422,9064364);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2298,157,"Explosion Dampening Field II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,328,0,0,9,81,422,9060030);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2299,77,"Ballistic Deflection Field II","Boosts shield resistance against kinetic damage. Penalty: Using more than one type of this module, or similar modules that affect the same resistance type, will result in a penalty to the boost you get on that type of resistance",0,0,10000,5,0,1,0,269248,1,553,0.060000,0,7,81,422,9064341);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2300,157,"Ballistic Deflection Field II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,328,0,0,9,81,422,9060031);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2301,77,"Photon Scattering Field II","Boosts shield resistance against EM damage. Penalty: Using more than one type of this module, or similar modules that affect the same resistance type, will result in a penalty to the boost you get on that type of resistance.",0,0,10000,5,0,1,0,261376,1,553,0.060000,0,7,81,422,9064395);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2302,157,"Photon Scattering Field II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,328,0,0,9,81,422,9060032);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2303,77,"Heat Dissipation Field II","Boosts shield resistance against thermal damage. Penalty: Using more than one type of this module, or similar modules that affect the same resistance type, will result in a penalty to the boost you get on that type of resistance.",0,0,10000,5,0,1,0,273696,1,553,0.060000,0,7,81,422,9064383);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2304,157,"Heat Dissipation Field II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,328,0,0,9,81,422,9060033);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2305,1035,"Autotrophs","At the very bottom of the food chain are autotrophs, those organisms that produce carbohydrates, proteins, and fats for higher life forms to consume. When properly gathered and ordered, they can be plied into industrial fibers, which then go on to contribute to advanced material technologies.",0,0,0,0.010000,0,1,0,0,1,1333,0,0,42,10038,0,8980299);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2306,1032,"Non-CS Crystals","The orderly, compact nature of crystals makes them well suited for a staggering array of manufacturing processes, in which they are just as often the product of the factory as they are incorporated into many of the tools and machinery used therein.",0,0,0,0.010000,0,1,0,0,1,1333,0,0,42,10027,0,8980308);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2307,1032,"Felsic Magma","The churning core of lava planets is rife with felsic magma, or silicate material that is infused with lighter elements, from which basic silicon and other atomic matter may be extracted. Silicon is abundant on many terrestrial planets, but the fastest and easiest way to obtain it, given advances in planetary mining processes, is from felsic magma.",0,0,0,0.010000,0,1,0,0,1,1333,0,0,42,10028,0,8980305);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2308,1033,"Suspended Plasma","When found in harvestable quantities beyond the unapproachable heat of an active star, plasma is said to be in a “suspended” state. Specialized electronic equipment is used to attract the ionized particles into collection tubes, after which it can be stored, transported, or applied to a variety of technologies.",0,0,0,0.010000,0,1,0,0,1,1333,0,0,42,10013,0,8980298);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2309,1033,"Ionic Solutions","An electrolyte found in a raw, natural form is called an ionic solution, especially in terms of planetary astronomy. Only after a lengthy process of extraction and refining can the resulting fluid go on to be used for medical, industrial, or nutritive applications. ",0,0,0,0.010000,0,1,0,0,1,1333,0,0,42,10014,0,8980295);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2310,1033,"Noble Gas","This colorless, odorless, and usually nonflammable substance is one of seven known monoatomic gases, or those that do not easily combine with other atoms. They are thus well suited for a variety of manufacturing implementations.",0,0,0,0.010000,0,1,0,0,1,1333,0,0,42,10015,0,8980296);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2311,1033,"Reactive Gas","Consisting of any number of volatile atomic structures, reactive gases are the most useful when applied to the fields of explosives, molecular restructuring, and electrical conduction. Great care must be taken when storing or transporting any sizeable quantity. ",0,0,0,0.010000,0,1,0,0,1,1333,0,0,42,10016,0,8980297);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2312,1034,"Supertensile Plastics","“Hyperoxidation” was the term given to the process of rapidly fossilizing the carbon structures, readily available in the form of biomass, which forms the basic framework of supertensile plastics. The only amorphous solid known to retain the resilience of other such materials while also adopting conductive properties, supertensile plastic is highly sought after for a wide range of industrial applications.",0,0,0,1.500000,0,1,0,1,1,1335,0,0,43,10057,0,8980342);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2317,1034,"Oxides","Technically, any chemical compound that contains at least one oxygen atom is an oxide, though some are far more valuable than others. Once broken down and separated from waste material, many oxides can be applied to various industrial processes.",0,0,0,1.500000,0,1,0,1,1,1335,0,0,43,10051,0,8980336);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2319,1034,"Test Cultures","When bacteria are allowed to thrive in a water-based environment, they undergo generational transformations that can be monitored and documented, providing research data invaluable to numerous scientific fields.",0,0,0,1.500000,0,1,0,1,1,1335,0,0,43,10056,0,8980344);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2321,1034,"Polyaramids","Polyaramid textiles are produced when industrial fibers are harvested from autotrophic life forms and subjected to intense pressure using reactive gas pistons. Able to absorb a startling amount of kinetic energy, sheets of this miraculous material can be form-fitted to just about any structure, protecting it from anything but weapons-grade impact forces.",0,0,0,1.500000,0,1,0,1,1,1335,0,0,43,10058,0,8980337);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2327,1034,"Microfiber Shielding","Using advanced residual substrate isolation technology, silicon weave is threaded through layers of tough organic fibers. The resulting microfiber shielding is incredibly resilient and retains the microscopic profile required to shield miniaturized electronics.",0,0,0,1.500000,0,1,0,1,1,1335,0,0,43,10055,0,8980333);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2328,1034,"Water-Cooled CPU","Despite how ancient the technology is, there is still no method more cost-effective for cooling computer processing units than ordinary water, which can be heated and cooled rapidly via any number of proven methods. Most often, thermally conductive tubing makes its way through all of the vital components and over heat sinks, helping to regulate operating temperatures.",0,0,0,1.500000,0,1,0,1,1,1335,0,0,43,10052,0,8980347);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2329,1034,"Biocells","Similar to an ancient battery, a biocell instead uses biofuels distilled from organic material and precious metals to produce an electrical current in a self-contained, modular unit. However, modern biocells dwarf the capabilities of ancient batteries by several orders of magnitude.",0,0,0,1.500000,0,1,0,1,1,1335,0,0,43,10054,0,8980324);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2331,57,"Shield Power Relay I","Diverts power from the capacitors to the shields, thereby increasing the shield recharge rate.",0,500,20,5,0,1,0,9744,1,688,0.060000,0,7,83,422,9060034);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2332,137,"Shield Power Relay I Blueprint","",0,0,0,0.010000,0,1,0,97440,1,326,0,0,9,83,422,9060035);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2333,49,"Survey Scanner II","Scans the composition of asteroids, ice and gas clouds.",0,0,0,5,0,1,0,37768,1,714,0.060000,0,7,2732,422,9066893);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2334,129,"Survey Scanner II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,0,0,0,9,107,422,9060036);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2335,226,"Mysterious Probe","Despite its familiar construction, this ancient probe is made from materials and electronics unlike anything you\'ve ever seen in New Eden. It floats silently through space, seemingly dormant.",1211,6,0,0,0,1,0,0,0,0,0,0,2,0,0,8738848);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2341,82,"Passive Targeter II","Uses advanced acoustical and visual targeting to identify threats. Allows target lock without alerting the ship to a possible threat.",0,0,2000,5,0,1,0,37764,1,672,0.060000,0,7,104,422,9060037);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2342,161,"Passive Targeter II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,0,0,0,9,104,422,9060038);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2344,1040,"Condensates","Oxidized coolant is required to produce the temperatures needed to force rare particles to condense out of ordinary matter, which is the most economic way to produce valuable base elements in bulk.",0,0,0,6,0,1,0,1,1,1336,0,0,43,10039,0,8977810);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2345,1040,"Camera Drones","Most visibly used in starship development, especially on capsuleer craft, other types of camera drones are also employed in the fields of nano-medicine, surveillance, and entertainment.",0,0,0,6,0,1,0,1,1,1336,0,0,43,10040,0,8977809);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2346,1040,"Synthetic Synapses","The wide range of uses for synthetic synapses is largely due to the fact that they are able to serve double duty as electrical conduit and as replacements or additions to biological nervous systems. This allows them to be used in computers, cybernetics, and artificial intelligence equipment.",0,0,0,6,0,1,0,1,1,1336,0,0,43,10041,0,8977825);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2348,1040,"Gel-Matrix Biopaste","Gel-matrix biopaste is a highly unstable substance that must be formed from elements that don’t combine under normal circumstances. Forcing them to do so requires enormous amounts of energy, but the end product is invaluable to high-end electronics and cybernetic medicine.",0,0,0,6,0,1,0,1,1,1336,0,0,43,10042,0,8977813);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2349,1040,"Supercomputers","When an individual computer system incorporates a wide range of networked utilities, layered processors, and redundant memory cores, it is said to have evolved into a supercomputer. Such systems can be put to use managing spaceships, starbases, or even entire planetary administrations.",0,0,0,6,0,1,0,1,1,1336,0,0,43,10043,0,8977824);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2351,1040,"Smartfab Units","These tiny cubes form the building blocks of many simple structures, from basic walls and doors to entire homes and even industrial office spaces. Whenever a sufficient number of smartfab units are placed together and have been programmed with the same instructions, they will automatically combine to form some portion of that object and then become inert in their new form. With adequately detailed blueprints, there is theoretically no limit to the complexity of object or structure these clever devices can create. ",0,0,0,6,0,1,0,1,1,1336,0,0,43,10044,0,8977823);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2352,1040,"Nuclear Reactors","This power core is able to convert heavy elements into electricity by way of nuclear fission, splitting atoms to produce thermal energy on a massive scale. If they are properly shielded and cooled, there are few safer, cleaner ways to power buildings or large vehicles. ",0,0,0,6,0,1,0,1,1,1336,0,0,43,10045,0,8977820);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2354,1040,"Neocoms","As an essential component of the navigational and tactical interface of spaceships, Neocoms are a small but essential cornerstone of the interstellar economy.",0,0,0,6,0,1,0,1,1,1336,0,0,43,10046,0,8977819);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2355,63,"Small Hull Repairer II","Makes use of nano-assembler technology in order to repair damage done to the structure.",0,0,1000,5,0,1,0,94618,1,1053,0.060000,0,7,80,422,9060039);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2356,143,"Small Hull Repairer II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,0,0,0,9,21,422,9060040);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2358,1040,"Biotech Research Reports","As the core fundamentals of organic life constantly evolve and develop on micro and macro levels, the constant production and distribution of biotech research is a mandatory part of ongoing advances in countless scientific disciplines.",0,0,0,6,0,1,0,1,1,1336,0,0,43,10132,0,8977808);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2360,1040,"Industrial Explosives","The primary difference between military and industrial explosives is that the latter are effective only when used in bulk, and they are never sold or transported with “ready to use” detonators. As such, they must be carefully installed, primed, and triggered from remote locations before their full destructive force can be applied.",0,0,0,6,0,1,0,1,1,1336,0,0,43,10047,0,8977818);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2361,1040,"Hermetic Membranes","How do you make a sheet of material absolutely impermeable to specific particles? Simple: You make the material want to stop those particles. Such is the case with hermetic membranes, supertensile fabrics instilled with living genetic material that actively hunts down and absorbs or repels whatever they were bred to counteract.",0,0,0,6,0,1,0,1,1,1336,0,0,43,10048,0,8977816);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2363,205,"Heat Sink I","Dissipates energy weapon damage efficiently, thus allowing them to be fired more rapidly. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,1,1,5,0,1,0,24960,1,647,0.070000,0,7,1046,422,9060041);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2364,205,"Heat Sink II","Dissipates energy weapon damage efficiently, thus allowing them to be fired more rapidly. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,1,1,5,0,1,0,104348,1,647,0.060000,0,7,1046,422,9060042);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2366,1040,"Hazmat Detection Systems","A critical component of space stations, starships, or any other isolated environment, these tiny devices are set to trigger alarms when the genetically engineered viruses inside mutate — which means that they’ve encountered a significant dose of radiation, natural contaminant, or airborne pathogen, signifying that the surrounding crew is in danger.",0,0,0,6,0,1,0,1,1,1336,0,0,43,10049,0,8977815);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2367,1040,"Cryoprotectant Solution","The base elements present in certain synthetic oils can, at extreme temperatures, produce habitable environments for genetically engineered extremophile. The byproduct of their rapid life-death cycle is a highly thermal resistant solution ideal for hybrid electronics.",0,0,0,6,0,1,0,1,1,1336,0,0,43,10050,0,9437567);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2368,314,"Broken Organic Mortar Applicators","While nanites are ideal for many forms of construction, sealing joints between large structural bulkheads is a job best left to organic mortar, a thick gel that actively permeates every microscopic gap between two parts. Due to the aggressive nature of the genetically engineered bacteria that intelligently guides into place the hardening condensate material, this paste is extremely hazardous to humans and must be applied by robots.",0,0,0,100,0,1,0,25000,1,20,0,0,17,3250,0,9047206);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2369,314,"Broken Sterile Conduits","Sustaining diverse populations of station inhabitants – many of whom come from different worlds with different ecologies – was a medical nightmare until the development of sterile conduits. Each length of flexible, self-repairing tube is powered by breaking down the chemical energy in the water they convey, which itself is laced with smart vaccines able to identify and destroy almost any known antigen.",0,0,0,100,0,1,0,25000,1,20,0,0,17,3250,0,9047209);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2370,572,"Serpentis Initiate","This is a fighter for the Serpentis Corporation. It is protecting the assets of the Serpentis Corporation and may attack anyone it perceives as a threat or easy pickings. Threat level: Very low",1816,50,2.45e+006,24500,60,1,8,0,0,0,0,31,11,0,0,7174161);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2371,314,"Broken Nano-Factory","Only the highly advanced Ukomi superconductor can be rendered small enough for use in nano-factories, microscopic devices programmed to absorb and recycle ambient material into useful matter. Each factory is built from reactive metals, ensuring that they interact properly – or not at all – with their environment, while a mote of industrial explosive automatically destroys them when they have completed their task.",0,0,0,100,0,1,0,25000,1,20,0,0,17,3250,0,9047205);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2372,550,"Angel Rogue","This is a fighter for the Arch Angels. It is protecting the assets of Arch Angels and may attack anyone it perceives as a threat or easy pickings. Threat level: Low",344,50,2.25e+006,22500,75,1,2,0,0,0,0,31,11,0,0,7190123);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2373,314,"Broken Self-Harmonizing Power Core","With camera drones diligently monitoring the temperature, radioactivity, and electrical output of these advanced nuclear reactors, instant adjustments can be made to a dynamic, adaptive layer of hermetic membranes, which keeps the power core functioning safely at maximum capacity, with no human attention required whatsoever.",0,0,0,100,0,1,0,25000,1,20,0,0,17,3250,0,9047208);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2374,314,"Broken Recursive Computing Module","Not all automated functions are delicate or complicated enough to warrant advanced computer hardware; relatively mundane tasks are best when assigned to an RCM bank. These sturdy, reliable processing units are able to effectively handle most of the day-to-day operations of stations, starships, and stargates.",0,0,0,100,0,1,0,25000,1,20,0,0,17,3250,0,9047207);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2375,314,"Broken Broadcast Node","By integrating transcranial microcontrollers into a circuit made from synthetic synapses, the broadcast node is able to communicate directly with various station functions and with negligible signal loss and latency. The addition of computerized guidance systems, each running independent navigation system software routines, allows a single node to coordinate starship docking procedures, drone operations, and even station defenses.",0,0,0,100,0,1,0,25000,1,20,0,0,17,3250,0,9047203);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2376,314,"Broken Integrity Response Drones","Hull breaches are a constant, serious threat during space travel, as well as a dangerous reality to orbital stations, which are too massive to avoid incoming objects. Integrity response drones help mitigate that threat by providing the automated, immediate application of sealants to any detected impact or pressure fracture in the structure they patrol.",0,0,0,100,0,1,0,25000,1,20,0,0,17,3250,0,9047204);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2377,314,"Broken Wetware Mainframe","So advanced and energy-demanding are wetware mainframes that they require vehicle-scale power cores and the constant attention of maintenance personnel. When operating at peak performance levels, nothing in New Eden can match the raw computing power of these machines, from calculating warp coordinates to administrating the core functions of an entire space station.",0,0,0,100,0,1,0,25000,1,20,0,0,17,3250,0,9047210);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2378,675,"Mysterious Shuttle","The only thing sensors can make out about this ship is that it has some kind of receiver that interacts with the star’s natural magnetic field. There is one faint life sign, similar to a human in cryogenic stasis.",317,50,1.6e+006,5000,10,1,1,0,1,0,0,0,11,0,0,8745821);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2379,572,"Serpentis Spy","This is a fighter for the Serpentis Corporation. It is protecting the assets of the Serpentis Corporation and may attack anyone it perceives as a threat or easy pickings. Threat level: Moderate",1817,50,2.5e+006,25000,60,1,8,0,0,0,0,31,11,0,0,7190124);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2381,571,"Serpentis Chief Spy","This is a fighter for the Serpentis Corporation. It is protecting the assets of the Serpentis Corporation and may attack anyone it perceives as a threat or easy pickings. Threat level: Extreme",1812,150,1.16e+007,116000,900,1,8,0,0,0,0,31,11,0,0,7190125);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2382,562,"Guristas Arrogator","This is a fighter for the Guristas. It is protecting the assets of Guristas and may attack anyone it perceives as a threat or easy pickings. Threat level: Very low",1968,50,1.5001e+006,15001,45,1,1,0,0,0,0,31,11,0,0,7190126);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2383,562,"Guristas Invader","This is a fighter for the Guristas. It is protecting the assets of Guristas and may attack anyone it perceives as a threat or easy pickings. Threat level: Moderate",1832,50,2.025e+006,20250,65,1,1,0,0,0,0,31,11,0,0,7190127);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2384,562,"Guristas Imputor","This is a fighter for the Guristas. It is protecting the assets of Guristas and may attack anyone it perceives as a threat or easy pickings. Threat level: Low",1827,50,1.612e+006,16120,80,1,1,0,0,0,0,31,11,0,0,7190128);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2385,562,"Guristas Despoiler","This is a fighter for the Guristas. It is protecting the assets of Guristas and may attack anyone it perceives as a threat or easy pickings. Threat level: Significant",1828,50,2.04e+006,20400,100,1,1,0,0,0,0,31,11,0,0,7190129);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2386,562,"Guristas Plunderer","This is a fighter for the Guristas. It is protecting the assets of Guristas and may attack anyone it perceives as a threat or easy pickings. Threat level: High",1830,50,1.97e+006,19700,125,1,1,0,0,0,0,31,11,0,0,7190130);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2387,561,"Guristas Silencer","This is a fighter for the Guristas. It is protecting the assets of Guristas and may attack anyone it perceives as a threat or easy pickings. Threat level: Extreme",1823,150,1.07e+007,107000,850,1,1,0,0,0,0,31,11,0,0,7190131);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2389,1042,"Plasmoids","In the early days of humanity’s return to space flight, scientists Planto and Ginch co-discovered a self-sustaining natural structure made entirely from plasma suspended in a planetary magnetic field. Since then, the term has been applied to any such construct, whether occurring under normal conditions or produced artificially using electrical currents.",0,0,0,0.380000,0,1,0,1,1,1334,0,0,43,10017,0,8980316);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2390,1042,"Electrolytes","This conductive liquid is able to carry an electrical current due to its unique ionic properties, making it ideal for use as a reactive coolant, a high-energy fuel, or a transference medium for power plants.",0,0,0,0.380000,0,1,0,1,1,1334,0,0,43,10019,0,8980313);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2392,1042,"Oxidizing Compound","Converting various matter from its basic state to an oxidized form requires an oxidizing compound, the most effective of which is a powerful agent made from pressurized reactive gas. Special containers are required to keep the compound from causing significant damage to common metals and organic life.",0,0,0,0.380000,0,1,0,1,1,1334,0,0,43,10018,0,8980315);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2393,1042,"Bacteria","The term “bacteria” covers a wide, diverse family of unicellular microorganisms, from those found in almost every climate in New Eden to those that thrive in the bodies of other living beings. Though some bacteria are known to convey diseases, others are more helpful than harmful to humans.",0,0,0,0.380000,0,1,0,1,1,1334,0,0,43,10029,0,8980309);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2395,1042,"Proteins","One of the most basic components of biological life, proteins form the core DNA structure and are involved in almost every process that sustains a living being. Harvested at the microscopic level, proteins can be put to use in everything from medical genetics to nanite technology.",0,0,0,0.380000,0,1,0,1,1,1334,0,0,43,10031,0,8980318);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2396,1042,"Biofuels","The most widely used, renewable solid fuel in the cluster, biofuel production is present in some fashion on almost every inhabited world. A steady fuel source can be maintained in a planetary economy by converting living material directly into energy instead of relying on fossil fuels. ",0,0,0,0.380000,0,1,0,1,1,1334,0,0,43,10032,0,8980310);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2397,1042,"Industrial Fibers","The main difference between fibers used in industry and those created for civilian use is the trade-off of comfort for tensile strength and durability. This allows industrial fibers to be used in more severe environments, from electronic component shielding on hostile worlds to solar sails in the frigid void of space. ",0,0,0,0.380000,0,1,0,1,1,1334,0,0,43,10033,0,8980314);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2398,1042,"Reactive Metals","Very dense metals are often called reactive metals, as their ability to conduct electrical currents and absorb heat is unparalleled. Rarely found in a natural solid state, they are instead usually assembled on an atomic level from particulate matter found in other forms.",0,0,0,0.380000,0,1,0,1,1,1334,0,0,43,10020,0,8980319);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2399,1042,"Precious Metals","A cousin of noble metals, precious metals are named as such because of how infrequently they appear on terrestrial worlds where they were first encountered.",0,0,0,0.380000,0,1,0,1,1,1334,0,0,43,10021,0,9437566);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2400,1042,"Toxic Metals","Derived from heavy metals, toxic metals are those that have no biological function and are in fact poisonous to most living creatures.",0,0,0,0.380000,0,1,0,1,1,1334,0,0,43,10022,0,8980321);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2401,1042,"Chiral Structures","A chiral structure is a crystal that is unsymmetrical, which makes it volatile in some situations but ideal for conductivity, especially in micro-circuitry. Using semi-rare chiral structures in electronics has allowed for an unprecedented advancement in the field of miniaturization.",0,0,0,0.380000,0,1,0,1,1,1334,0,0,43,10023,0,8980312);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2403,1044,"Advanced Planetology","The advanced understanding of planet evolution allowing you to interpret data from scans of planets for resources at much higher resolutions.




The skill further increases the resolution of resource data when scanning a planet to allow for very precise surveying.

this skill cannot be trained on trial accounts.",0,0,0,0.010000,0,1,0,7.5e+006,1,1323,0,0,16,33,0,9055261);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2404,509,"Standard Missile Launcher II","Favored by many for its average capacity and firing rate. Useful in both fast attack raids and longer battles.


Bloodclaw, Flameburst, Piranha, Sabretooth, (Fury and Precision variants available) or their F.O.F variants; Exterminator, Firefly, Seeker, Serpent.

",168,0,0,5,0.795000,1,0,72806,1,640,0.060000,0,7,168,422,2644760);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2405,136,"Standard Missile Launcher II Blueprint","",168,0,0,0.010000,0,1,0,1e+007,1,340,0,0,9,168,422,729619);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2406,1044,"Planetology","The understanding of planet evolution allowing you to better interpret data from scans of planets for resources.




The skill increases the resolution of resource data when scanning a planet to allow for more accurate surveying.

this skill cannot be trained on trial accounts.",0,0,0,0.010000,0,1,0,1e+006,1,1323,0,0,16,33,0,9055260);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2407,226,"The Terminus Stream","The material being ejected from this wormhole consists of hydrogen, oxygen, silicon, iron, and other materials usually only found in those states and frequency on terrestrial planets.",2907,1274,1,0,0,1,0,0,0,0,0,0,2,0,0,8748321);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2409,1026,"Barren Aqueous Liquid Extractor","Finding desired liquids on hostile worlds can be almost as challenging a task as extracting it from the unforgiving environment, which often entails drilling kilometers below the surface or condensing fluids from the upper atmosphere. Once the liquids are discovered, the facility itself begins the relatively simple task of separating it from the ambient plasma interference, scalding magma streams, or potentially infectious indigenous bacteria. A surprising amount of valuable liquids can be extracted from hostile worlds, but only if the equipment is properly calibrated and carefully maintained.",4544,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,8973770);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2410,510,"Heavy Missile Launcher II","Designed for long engagements between medium sized ships. Slow firing rate, but makes up for it with a large missile capacity.


Havoc, Scourge, Thunderbolt, Widowmaker (Fury and Precision variant available) or their F.O.F. variants: Eradicator, Hellhound, Hydra, Stalker.",169,0,0,10,1.200000,1,0,167560,1,642,0.060000,0,7,169,422,729622);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2411,136,"Heavy Missile Launcher II Blueprint","",169,0,0,0.010000,0,1,0,1e+007,1,340,0,0,9,169,422,729625);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2412,1026,"Temperate Aqueous Liquid Extractor","Finding desired liquids on hostile worlds can be almost as challenging a task as extracting it from the unforgiving environment, which often entails drilling kilometers below the surface or condensing fluids from the upper atmosphere. Once the liquids are discovered, the facility itself begins the relatively simple task of separating it from the ambient plasma interference, scalding magma streams, or potentially infectious indigenous bacteria. A surprising amount of valuable liquids can be extracted from hostile worlds, but only if the equipment is properly calibrated and carefully maintained.",4544,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,8973805);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2413,1026,"Storm Aqueous Liquid Extractor","Finding desired liquids on hostile worlds can be almost as challenging a task as extracting it from the unforgiving environment, which often entails drilling kilometers below the surface or condensing fluids from the upper atmosphere. Once the liquids are discovered, the facility itself begins the relatively simple task of separating it from the ambient plasma interference, scalding magma streams, or potentially infectious indigenous bacteria. A surprising amount of valuable liquids can be extracted from hostile worlds, but only if the equipment is properly calibrated and carefully maintained.",4553,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,8973800);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2414,1026,"Oceanic Aqueous Liquid Extractor","This underwater platform and extendable extraction arms are capable of scouring the ocean floor for valuable materials and bringing them to the surface for transportation to processing facilities. A small habitation module serves as living and operation quarters for the human administration and maintenance crew, along with emergency surfacing capsules in the case of a seismic event or breach of the building’s integrity.",4548,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,8973790);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2415,1026,"Ice Aqueous Liquid Extractor","Finding desired liquids on hostile worlds can be almost as challenging a task as extracting it from the unforgiving environment, which often entails drilling kilometers below the surface or condensing fluids from the upper atmosphere. Once the liquids are discovered, the facility itself begins the relatively simple task of separating it from the ambient plasma interference, scalding magma streams, or potentially infectious indigenous bacteria. A surprising amount of valuable liquids can be extracted from hostile worlds, but only if the equipment is properly calibrated and carefully maintained.",4553,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,8973780);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2416,1026,"Gas Aqueous Liquid Extractor","Extracting gas from a gas giant requires more effort than simply opening a door into a container. Each specific type of desirable gas requires an ionized filament to be calibrated to attract only the right particles from the atmosphere. Even a fraction of a percent error could spoil an entire batch of product by tainting it with unwanted material. Likewise, once the gas is extracted from the surrounding air, the platform’s equilibrium tanks must be adjusted to compensate for the added weight or buoyancy. Beyond that, it’s a simple matter of supercooling it and transferring the liquid form into a container for transport. As one pioneer of this technology accurately described it, “The extractor itself is much like a living organism, breathing in what it needs and expelling that which becomes cumbersome.”",4555,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,8973775);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2417,1026,"Plasma Suspended Plasma Extractor","Finding desired liquids on hostile worlds can be almost as challenging a task as extracting it from the unforgiving environment, which often entails drilling kilometers below the surface or condensing fluids from the upper atmosphere. Once the liquids are discovered, the facility itself begins the relatively simple task of separating it from the ambient plasma interference, scalding magma streams, or potentially infectious indigenous bacteria. A surprising amount of valuable liquids can be extracted from hostile worlds, but only if the equipment is properly calibrated and carefully maintained.",4551,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,8973799);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2418,1026,"Lava Suspended Plasma Extractor","Finding desired liquids on hostile worlds can be almost as challenging a task as extracting it from the unforgiving environment, which often entails drilling kilometers below the surface or condensing fluids from the upper atmosphere. Once the liquids are discovered, the facility itself begins the relatively simple task of separating it from the ambient plasma interference, scalding magma streams, or potentially infectious indigenous bacteria. A surprising amount of valuable liquids can be extracted from hostile worlds, but only if the equipment is properly calibrated and carefully maintained.",4551,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,8973789);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2419,1026,"Storm Suspended Plasma Extractor","Finding desired liquids on hostile worlds can be almost as challenging a task as extracting it from the unforgiving environment, which often entails drilling kilometers below the surface or condensing fluids from the upper atmosphere. Once the liquids are discovered, the facility itself begins the relatively simple task of separating it from the ambient plasma interference, scalding magma streams, or potentially infectious indigenous bacteria. A surprising amount of valuable liquids can be extracted from hostile worlds, but only if the equipment is properly calibrated and carefully maintained.",4551,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,8973804);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2420,508,"Siege Missile Launcher II","A massive launcher designed for extended bombardments of hard targets like battleships and stations. Contains a huge missile capacity, but has a slow firing rate and trouble targeting small, fast ships.


Bane, Inferno, Juggernaut, Mjolnir or their Rage and Javelin variants.",170,0,0,20,2,1,0,655792,1,644,0.060000,0,7,170,422,729628);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2421,136,"Siege Missile Launcher II Blueprint","",170,0,0,0.010000,0,1,0,1e+007,1,340,0,0,9,170,422,729631);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2422,1026,"Storm Ionic Solutions Extractor","Finding desired liquids on hostile worlds can be almost as challenging a task as extracting it from the unforgiving environment, which often entails drilling kilometers below the surface or condensing fluids from the upper atmosphere. Once the liquids are discovered, the facility itself begins the relatively simple task of separating it from the ambient plasma interference, scalding magma streams, or potentially infectious indigenous bacteria. A surprising amount of valuable liquids can be extracted from hostile worlds, but only if the equipment is properly calibrated and carefully maintained.",4553,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,8973802);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2423,1026,"Ice Noble Gas Extractor","Finding desired liquids on hostile worlds can be almost as challenging a task as extracting it from the unforgiving environment, which often entails drilling kilometers below the surface or condensing fluids from the upper atmosphere. Once the liquids are discovered, the facility itself begins the relatively simple task of separating it from the ambient plasma interference, scalding magma streams, or potentially infectious indigenous bacteria. A surprising amount of valuable liquids can be extracted from hostile worlds, but only if the equipment is properly calibrated and carefully maintained.",4553,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,8973783);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2424,1026,"Gas Ionic Solutions Extractor","Extracting gas from a gas giant requires more effort than simply opening a door into a container. Each specific type of desirable gas requires an ionized filament to be calibrated to attract only the right particles from the atmosphere. Even a fraction of a percent error could spoil an entire batch of product by tainting it with unwanted material. Likewise, once the gas is extracted from the surrounding air, the platform’s equilibrium tanks must be adjusted to compensate for the added weight or buoyancy. Beyond that, it’s a simple matter of supercooling it and transferring the liquid form into a container for transport. As one pioneer of this technology accurately described it, “The extractor itself is much like a living organism, breathing in what it needs and expelling that which becomes cumbersome.”",4555,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,8973777);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2425,1026,"Storm Noble Gas Extractor","Finding desired liquids on hostile worlds can be almost as challenging a task as extracting it from the unforgiving environment, which often entails drilling kilometers below the surface or condensing fluids from the upper atmosphere. Once the liquids are discovered, the facility itself begins the relatively simple task of separating it from the ambient plasma interference, scalding magma streams, or potentially infectious indigenous bacteria. A surprising amount of valuable liquids can be extracted from hostile worlds, but only if the equipment is properly calibrated and carefully maintained.",4551,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,8973803);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2426,1026,"Gas Noble Gas Extractor","Custom-built gas extractors were first developed to take advantage of gas giant settlements and represented the most lucrative long-term development of such unique worlds. These enormous extraction units, when carefully lowered to the proper altitude on gas giant planets, provide a cost-effective way of acquiring rare and high-demand resources, such as noble and reactive gases and suspended plasma. The proliferation of gas giant settlement in recent years has drastically lowered the price of these base materials, which in turn has seen increased productivity in the numerous planetside and spacebound industries built around these valuable commodities.",4555,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,8973778);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2427,1026,"Gas Reactive Gas Extractor","Custom-built gas extractors were first developed to take advantage of gas giant settlements and represented the most lucrative long-term development of such unique worlds. These enormous extraction units, when carefully lowered to the proper altitude on gas giant planets, provide a cost-effective way of acquiring rare and high-demand resources, such as noble and reactive gases and suspended plasma. The proliferation of gas giant settlement in recent years has drastically lowered the price of these base materials, which in turn has seen increased productivity in the numerous planetside and spacebound industries built around these valuable commodities.",4555,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,8973779);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2428,1026,"Lava Base Metals Extractor","This facility consists of seismic insulated platforms and heavy, jointed conveyor belts leading into deep tunnels. Extremophile drones, built to function in even corrosive, intemperate, and high- or low-pressure atmospheres, run a constant circuit along the belts, performing repairs and clearing away rubble. A staff of mining experts and technicians occupy the main building in case any of the automated systems fail.",4552,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,8973785);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2429,1026,"Plasma Base Metals Extractor","This facility consists of seismic insulated platforms and heavy, jointed conveyor belts leading into deep tunnels. Extremophile drones, built to function in even corrosive, intemperate, and high- or low-pressure atmospheres, run a constant circuit along the belts, performing repairs and clearing away rubble. A staff of mining experts and technicians occupy the main building in case any of the automated systems fail.",4552,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,8973795);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2430,1026,"Barren Base Metals Extractor","Surface mining is a common and effective practice that dates back to early planetary settlement. The process involves stripping a planet’s surface layer until the ore buried beneath is exposed. At this point, the ore can be more easily extracted. Surface mines are typically quite shallow and are built in areas where the surface material covering the valuable deposits is relatively thin. For this reason, surface mines are sometimes built on the ocean floor.",4543,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,8973771);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2431,1026,"Storm Base Metals Extractor","This facility consists of seismic insulated platforms and heavy, jointed conveyor belts leading into deep tunnels. Extremophile drones, built to function in even corrosive, intemperate, and high- or low-pressure atmospheres, run a constant circuit along the belts, performing repairs and clearing away rubble. A staff of mining experts and technicians occupy the main building in case any of the automated systems fail.",4552,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,8973801);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2432,1026,"Ice Micro Organisms Extractor","Modular biomass cultivators have been the mainstay of low-cost micro-agriculture for centuries. As a result, these facilities have proliferated across many planetary settlements. These adaptable micro-ponds allow communities to alter their cultivators to take advantage of local environments, benefitting optimally from the unique bacterial makeup of local water supplies.  Although traditional farming methods remain competitive on terrestrial planets, the production of micro-organisms is most efficient when handled by a custom biomass cultivator.",4552,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,8973782);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2433,1026,"Gas Base Metals Extractor","Custom-built gas extractors were first developed to take advantage of gas giant settlements and represented the most lucrative long-term development of such unique worlds. These enormous extraction units, when carefully lowered to the proper altitude on gas giant planets, provide a cost-effective way of acquiring rare and high-demand resources, such as noble and reactive gases and suspended plasma. The proliferation of gas giant settlement in recent years has drastically lowered the price of these base materials, which in turn has seen increased productivity in the numerous planetside and spacebound industries built around these valuable commodities. ",4555,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,8973776);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2434,1026,"Plasma Noble Metals Extractor","This facility consists of seismic insulated platforms and heavy, jointed conveyor belts leading into deep tunnels. Extremophile drones, built to function in even corrosive, intemperate, and high- or low-pressure atmospheres, run a constant circuit along the belts, performing repairs and clearing away rubble. A staff of mining experts and technicians occupy the main building in case any of the automated systems fail.",4552,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,8973797);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2435,1026,"Barren Noble Metals Extractor","Surface mining is a common and effective practice that dates back to early planetary settlement. The process involves stripping a planet’s surface layer until the ore buried beneath is exposed. At this point, the ore can be more easily extracted. Surface mines are typically quite shallow and are built in areas where the surface material covering the valuable deposits is relatively thin. For this reason, surface mines are sometimes built on the ocean floor.",4543,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,8973774);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2436,100,"Wasp II","Heavy Attack Drone",1080,35,10000,25,0,1,1,181072,1,839,0.060000,0,18,0,422,9431783);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2437,176,"Wasp II Blueprint","",1080,0,0,0.010000,0,1,0,1e+007,1,359,0,0,9,0,422,729637);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2438,1026,"Ice Planktic Colonies Extractor","Modular biomass cultivators have been the mainstay of low-cost micro-agriculture for centuries. As a result, these facilities have proliferated across many planetary settlements. These adaptable micro-ponds allow communities to alter their cultivators to take advantage of local environments, benefitting optimally from the unique bacterial makeup of local water supplies.  Although traditional farming methods remain competitive on terrestrial planets, the production of micro-organisms is most efficient when handled by a custom biomass cultivator.",4552,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,8973784);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2439,1026,"Lava Heavy Metals Extractor","This facility consists of seismic insulated platforms and heavy, jointed conveyor belts leading into deep tunnels. Extremophile drones, built to function in even corrosive, intemperate, and high- or low-pressure atmospheres, run a constant circuit along the belts, performing repairs and clearing away rubble. A staff of mining experts and technicians occupy the main building in case any of the automated systems fail.",4552,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,8973787);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2440,1026,"Plasma Heavy Metals Extractor","This facility consists of seismic insulated platforms and heavy, jointed conveyor belts leading into deep tunnels. Extremophile drones, built to function in even corrosive, intemperate, and high- or low-pressure atmospheres, run a constant circuit along the belts, performing repairs and clearing away rubble. A staff of mining experts and technicians occupy the main building in case any of the automated systems fail.",4552,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,8973796);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2441,1026,"Ice Heavy Metals Extractor","This facility consists of seismic insulated platforms and heavy, jointed conveyor belts leading into deep tunnels. Extremophile drones, built to function in even corrosive, intemperate, and high- or low-pressure atmospheres, run a constant circuit along the belts, performing repairs and clearing away rubble. A staff of mining experts and technicians occupy the main building in case any of the automated systems fail.",4552,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,8973781);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2442,1026,"Lava Non-CS Crystals Extractor","This facility consists of seismic insulated platforms and heavy, jointed conveyor belts leading into deep tunnels. Extremophile drones, built to function in even corrosive, intemperate, and high- or low-pressure atmospheres, run a constant circuit along the belts, performing repairs and clearing away rubble. A staff of mining experts and technicians occupy the main building in case any of the automated systems fail.",4552,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,8973788);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2443,1026,"Plasma Non-CS Crystals Extractor","This facility consists of seismic insulated platforms and heavy, jointed conveyor belts leading into deep tunnels. Extremophile drones, built to function in even corrosive, intemperate, and high- or low-pressure atmospheres, run a constant circuit along the belts, performing repairs and clearing away rubble. A staff of mining experts and technicians occupy the main building in case any of the automated systems fail.",4552,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,8973798);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2444,100,"Ogre I","Heavy Attack Drone",1114,35,12000,25,0,1,8,70000,1,839,0.070000,0,18,0,422,9431758);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2445,176,"Ogre I Blueprint","",1114,0,0,0.010000,0,1,0,7e+006,1,359,0,0,9,0,422,729643);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2446,100,"Ogre II","Heavy Attack Drone",1115,35,12000,25,0,1,8,201072,1,839,0.060000,0,18,0,422,9431759);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2447,176,"Ogre II Blueprint","",1115,0,0,0.010000,0,1,0,1e+007,1,359,0,0,9,0,422,729649);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2448,1026,"Lava Felsic Magma Extractor","This facility consists of seismic insulated platforms and heavy, jointed conveyor belts leading into deep tunnels. Extremophile drones, built to function in even corrosive, intemperate, and high- or low-pressure atmospheres, run a constant circuit along the belts, performing repairs and clearing away rubble. A staff of mining experts and technicians occupy the main building in case any of the automated systems fail.",4551,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,8973786);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2449,1026,"Barren Micro Organisms Extractor","Modular biomass cultivators have been the mainstay of low-cost micro-agriculture for centuries. As a result, these facilities have proliferated across many planetary settlements. These adaptable micro-ponds allow communities to alter their cultivators to take advantage of local environments, benefitting optimally from the unique bacterial makeup of local water supplies.  Although traditional farming methods remain competitive on terrestrial planets, the production of micro-organisms is most efficient when handled by a custom biomass cultivator.",4545,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,8973773);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2450,1026,"Temperate Micro Organisms Extractor","Modular biomass cultivators have been the mainstay of low-cost micro-agriculture for centuries. As a result, these facilities have proliferated across many planetary settlements. These adaptable micro-ponds allow communities to alter their cultivators to take advantage of local environments, benefitting optimally from the unique bacterial makeup of local water supplies.  Although traditional farming methods remain competitive on terrestrial planets, the production of micro-organisms is most efficient when handled by a custom biomass cultivator.",4545,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,8973809);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2451,1026,"Oceanic Micro Organisms Extractor","Centuries of aquatic life and plant growth typically blanket ocean worlds’ floors with a thick layer of valuable biomass. When properly cultivated, harvested, and refined, the applications of such material range anywhere from food production and medical application to more esoteric functions, such as genetic enhancements and super-resilient textiles. The facility itself includes both a processing plant, which filters and compresses the material; and a roving collector, which is little more than a series of churning scoops and a powerful pumping mechanism connected to the facility via flexible conduit.",4549,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,8973793);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2452,1026,"Oceanic Planktic Colonies Extractor","Centuries of aquatic life and plant growth typically blanket ocean worlds’ floors with a thick layer of valuable biomass. When properly cultivated, harvested, and refined, the applications of such material range anywhere from food production and medical application to more esoteric functions, such as genetic enhancements and super-resilient textiles. The facility itself includes both a processing plant, which filters and compresses the material; and a roving collector, which is little more than a series of churning scoops and a powerful pumping mechanism connected to the facility via flexible conduit.",4549,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,8973794);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2453,1026,"Temperate Complex Organisms Extractor","Modular biomass cultivators have been the mainstay of low-cost micro-agriculture for centuries. As a result, these facilities have proliferated across many planetary settlements. These adaptable micro-ponds allow communities to alter their cultivators to take advantage of local environments, benefitting optimally from the unique bacterial makeup of local water supplies.  Although traditional farming methods remain competitive on terrestrial planets, the production of micro-organisms is most efficient when handled by a custom biomass cultivator.",4546,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,8973808);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2454,100,"Hobgoblin I","Light Scout Drone",1099,15,3000,5,0,1,8,2500,1,837,0.070000,0,18,0,422,9431735);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2455,176,"Hobgoblin I Blueprint","",1099,0,0,0.010000,0,1,0,250000,1,359,0,0,9,0,422,729655);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2456,100,"Hobgoblin II","Light Scout Drone",1100,15,3000,5,0,1,8,35268,1,837,0.060000,0,18,0,422,9431736);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2457,176,"Hobgoblin II Blueprint","",1100,0,0,0.010000,0,1,0,1e+007,1,359,0,0,9,0,422,729661);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2458,1026,"Oceanic Complex Organisms Extractor","Centuries of aquatic life and plant growth typically blanket ocean worlds’ floors with a thick layer of valuable biomass. When properly cultivated, harvested, and refined, the applications of such material range anywhere from food production and medical application to more esoteric functions, such as genetic enhancements and super-resilient textiles. The facility itself includes both a processing plant, which filters and compresses the material; and a roving collector, which is little more than a series of churning scoops and a powerful pumping mechanism connected to the facility via flexible conduit.",4550,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,8973792);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2459,1026,"Barren Carbon Compounds Extractor","Modular biomass cultivators have been the mainstay of low-cost micro-agriculture for centuries. As a result, these facilities have proliferated across many planetary settlements. These adaptable micro-ponds allow communities to alter their cultivators to take advantage of local environments, benefitting optimally from the unique bacterial makeup of local water supplies.  Although traditional farming methods remain competitive on terrestrial planets, the production of micro-organisms is most efficient when handled by a custom biomass cultivator.",4546,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,8973772);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2460,1026,"Temperate Carbon Compounds Extractor","Modular biomass cultivators have been the mainstay of low-cost micro-agriculture for centuries. As a result, these facilities have proliferated across many planetary settlements. These adaptable micro-ponds allow communities to alter their cultivators to take advantage of local environments, benefitting optimally from the unique bacterial makeup of local water supplies.  Although traditional farming methods remain competitive on terrestrial planets, the production of micro-organisms is most efficient when handled by a custom biomass cultivator.",4546,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,8973807);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2461,1026,"Oceanic Carbon Compounds Extractor","This underwater platform and extendable extraction arms are capable of scouring the ocean floor for valuable materials and bringing them to the surface for transportation to processing facilities. A small habitation module serves as living and operation quarters for the human administration and maintenance crew, along with emergency surfacing capsules in the case of a seismic event or breach of the building’s integrity.",4550,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,8973791);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2462,1026,"Temperate Autotrophs Extractor","Modular biomass cultivators have been the mainstay of low-cost micro-agriculture for centuries. As a result, these facilities have proliferated across many planetary settlements. These adaptable micro-ponds allow communities to alter their cultivators to take advantage of local environments, benefitting optimally from the unique bacterial makeup of local water supplies.  Although traditional farming methods remain competitive on terrestrial planets, the production of micro-organisms is most efficient when handled by a custom biomass cultivator.",4546,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,8973806);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2463,1034,"Nanites","Though they are only simple machines and very small, nanites can be used to achieve miraculous medical results in small amounts or astounding feats of engineering in mass quantities.",0,0,0,1.500000,0,1,0,1,1,1335,0,0,43,10053,0,9068370);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2464,100,"Hornet I","Light Scout Drone",1104,15,3500,5,0,1,1,3000,1,837,0.070000,0,18,0,422,9431737);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2465,176,"Hornet I Blueprint","",1104,0,0,0.010000,0,1,0,300000,1,359,0,0,9,0,422,729667);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2466,100,"Hornet II","Light Scout Drone",1105,15,3500,5,0,1,1,35768,1,837,0.060000,0,18,0,422,9431738);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2467,176,"Hornet II Blueprint","",1105,0,0,0.010000,0,1,0,1e+007,1,359,0,0,9,0,422,729673);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2468,226,"LCO Drone Structure II","This gigantic superstructure was built by the effort of thousands of rogue drones. While the structure appears to be incomplete, its intended shape remains a mystery to clueless carbon-based lifeforms.",2406,39957,100000,1e+008,10000,1,0,0,0,0,0,0,2,0,0,8767175);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2469,1028,"Lava Basic Industry Facility","Instead of laboring to shield the production lines of this industrial facility from the surrounding environment, designers opted instead to use the available heat, interference, and even crushing pressure to help power the structure itself. A plant on an ice planet might have highly advanced extended heat sinks, while a factory on a plasma world might draw most, if not all of its electricity from magnetized coils specially attuned to the planet’s local ion winds. Taking advantage of the indigenous features of each world helps offset the cost of building mass production infrastructure there, which usually involves protective coatings, environmental clothing, and reinforced foundations.",4533,0,0,0,0,1,0,75000,1,0,0,0,41,0,0,8973818);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2470,1028,"Lava Advanced Industry Facility","Instead of laboring to shield the production lines of this industrial facility from the surrounding environment, designers opted instead to use the available heat, interference, and even crushing pressure to help power the structure itself. A plant on an ice planet might have highly advanced extended heat sinks, while a factory on a plasma world might draw most, if not all of its electricity from magnetized coils specially attuned to the planet’s local ion winds. Taking advantage of the indigenous features of each world helps offset the cost of building mass production infrastructure there, which usually involves protective coatings, environmental clothing, and reinforced foundations.",4534,0,0,0,0,1,0,250000,1,0,0,0,41,0,0,8973817);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2471,1028,"Plasma Basic Industry Facility","Instead of laboring to shield the production lines of this industrial facility from the surrounding environment, designers opted instead to use the available heat, interference, and even crushing pressure to help power the structure itself. A plant on an ice planet might have highly advanced extended heat sinks, while a factory on a plasma world might draw most, if not all of its electricity from magnetized coils specially attuned to the planet’s local ion winds. Taking advantage of the indigenous features of each world helps offset the cost of building mass production infrastructure there, which usually involves protective coatings, environmental clothing, and reinforced foundations.",4533,0,0,0,0,1,0,75000,1,0,0,0,41,0,0,8973822);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2472,1028,"Plasma Advanced Industry Facility","Instead of laboring to shield the production lines of this industrial facility from the surrounding environment, designers opted instead to use the available heat, interference, and even crushing pressure to help power the structure itself. A plant on an ice planet might have highly advanced extended heat sinks, while a factory on a plasma world might draw most, if not all of its electricity from magnetized coils specially attuned to the planet’s local ion winds. Taking advantage of the indigenous features of each world helps offset the cost of building mass production infrastructure there, which usually involves protective coatings, environmental clothing, and reinforced foundations.",4534,0,0,0,0,1,0,250000,1,0,0,0,41,0,0,8973821);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2473,1028,"Barren Basic Industry Facility","Populated almost entire by robotic laborers, mass production facilities excel at creating products in bulk with minimal supervision and maintenance. They can be so self-sufficient that rumors abound of Gallente factories operated entirely by androids and governed by a skeleton crew of drones. (Detractors of this method like to note that Sansha facilities work in much the same fashion.) Either way, the results are irrefutable: Raw materials and components go in one end, and polished commodities come out the other side.",4522,0,0,0,0,1,0,75000,1,0,0,0,41,0,0,8973811);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2474,1028,"Barren Advanced Industry Facility","Populated almost entire by robotic laborers, mass production facilities excel at creating products in bulk with minimal supervision and maintenance. They can be so self-sufficient that rumors abound of Gallente factories operated entirely by androids and governed by a skeleton crew of drones. (Detractors of this method like to note that Sansha facilities work in much the same fashion.) Either way, the results are irrefutable: Raw materials and components go in one end, and polished commodities come out the other side.",4523,0,0,0,0,1,0,250000,1,0,0,0,41,0,0,8973810);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2475,1028,"Barren High-Tech Production Plant","Populated almost entire by robotic laborers, mass production facilities excel at creating products in bulk with minimal supervision and maintenance. They can be so self-sufficient that rumors abound of Gallente factories operated entirely by androids and governed by a skeleton crew of drones. (Detractors of this method like to note that Sansha facilities work in much the same fashion.) Either way, the results are irrefutable: Raw materials and components go in one end, and polished commodities come out the other side.",4525,0,0,0,0,1,0,525000,1,0,0,0,41,0,0,13199884);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2476,100,"Berserker I","Heavy Attack Drone",1089,35,10000,25,0,1,2,40000,1,839,0.070000,0,18,0,422,9431715);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2477,176,"Berserker I Blueprint","",1089,0,0,0.010000,0,1,0,4e+006,1,359,0,0,9,0,422,729679);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2478,100,"Berserker II","Heavy Attack Drone",2765,35,10000,25,0,1,2,171072,1,839,0.060000,0,18,0,422,9431716);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2479,176,"Berserker II Blueprint","",1090,0,0,0.010000,0,1,0,1e+007,1,359,0,0,9,0,422,729685);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2480,1028,"Temperate Advanced Industry Facility","Populated almost entire by robotic laborers, mass production facilities excel at creating products in bulk with minimal supervision and maintenance. They can be so self-sufficient that rumors abound of Gallente factories operated entirely by androids and governed by a skeleton crew of drones. (Detractors of this method like to note that Sansha facilities work in much the same fashion.) Either way, the results are irrefutable: Raw materials and components go in one end, and polished commodities come out the other side.",4523,0,0,0,0,1,0,250000,1,0,0,0,41,0,0,8973825);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2481,1028,"Temperate Basic Industry Facility","Populated almost entire by robotic laborers, mass production facilities excel at creating products in bulk with minimal supervision and maintenance. They can be so self-sufficient that rumors abound of Gallente factories operated entirely by androids and governed by a skeleton crew of drones. (Detractors of this method like to note that Sansha facilities work in much the same fashion.) Either way, the results are irrefutable: Raw materials and components go in one end, and polished commodities come out the other side.",4522,0,0,0,0,1,0,75000,1,0,0,0,41,0,0,8973826);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2482,1028,"Temperate High-Tech Production Plant","Populated almost entire by robotic laborers, mass production facilities excel at creating products in bulk with minimal supervision and maintenance. They can be so self-sufficient that rumors abound of Gallente factories operated entirely by androids and governed by a skeleton crew of drones. (Detractors of this method like to note that Sansha facilities work in much the same fashion.) Either way, the results are irrefutable: Raw materials and components go in one end, and polished commodities come out the other side.",4525,0,0,0,0,1,0,525000,1,0,0,0,41,0,0,13199885);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2483,1028,"Storm Basic Industry Facility","Instead of laboring to shield the production lines of this industrial facility from the surrounding environment, designers opted instead to use the available heat, interference, and even crushing pressure to help power the structure itself. A plant on an ice planet might have highly advanced extended heat sinks, while a factory on a plasma world might draw most, if not all of its electricity from magnetized coils specially attuned to the planet’s local ion winds. Taking advantage of the indigenous features of each world helps offset the cost of building mass production infrastructure there, which usually involves protective coatings, environmental clothing, and reinforced foundations.",4533,0,0,0,0,1,0,75000,1,0,0,0,41,0,0,8973824);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2484,1028,"Storm Advanced Industry Facility","Instead of laboring to shield the production lines of this industrial facility from the surrounding environment, designers opted instead to use the available heat, interference, and even crushing pressure to help power the structure itself. A plant on an ice planet might have highly advanced extended heat sinks, while a factory on a plasma world might draw most, if not all of its electricity from magnetized coils specially attuned to the planet’s local ion winds. Taking advantage of the indigenous features of each world helps offset the cost of building mass production infrastructure there, which usually involves protective coatings, environmental clothing, and reinforced foundations.",4534,0,0,0,0,1,0,250000,1,0,0,0,41,0,0,8973823);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2485,1028,"Oceanic Advanced Industry Facility","Because of the difficulties involved in maintaining a habitable environment for human workers, all requirements for such personnel have been eliminated on oceanic mass production facilities. Instead, the building’s focus is centered on maintaining production quotas under extreme circumstances, with reinforced bulkheads occupying almost every space that would normally have been reserved for hallways, offices, and living quarters.",4529,0,0,0,0,1,0,250000,1,0,0,0,41,0,0,8973819);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2486,100,"Warrior I","Light Scout Drone",1124,15,4000,5,0,1,2,4000,1,837,0.070000,0,18,0,422,9431780);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2487,176,"Warrior I Blueprint","",1124,0,0,0.010000,0,1,0,400000,1,359,0,0,9,0,422,729691);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2488,100,"Warrior II","Light Scout Drone",1125,15,4000,5,0,1,2,36768,1,837,0.060000,0,18,0,422,9431781);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2489,176,"Warrior II Blueprint","",1125,0,0,0.010000,0,1,0,1e+007,1,359,0,0,9,0,422,729697);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2490,1028,"Oceanic Basic Industry Facility","Because of the difficulties involved in maintaining a habitable environment for human workers, all requirements for such personnel have been eliminated on oceanic mass production facilities. Instead, the building’s focus is centered on maintaining production quotas under extreme circumstances, with reinforced bulkheads occupying almost every space that would normally have been reserved for hallways, offices, and living quarters.",4528,0,0,0,0,1,0,75000,1,0,0,0,41,0,0,8973820);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2491,1028,"Ice Advanced Industry Facility","Instead of laboring to shield the production lines of this industrial facility from the surrounding environment, designers opted instead to use the available heat, interference, and even crushing pressure to help power the structure itself. A plant on an ice planet might have highly advanced extended heat sinks, while a factory on a plasma world might draw most, if not all of its electricity from magnetized coils specially attuned to the planet’s local ion winds. Taking advantage of the indigenous features of each world helps offset the cost of building mass production infrastructure there, which usually involves protective coatings, environmental clothing, and reinforced foundations.",4534,0,0,0,0,1,0,250000,1,0,0,0,41,0,0,8973815);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2492,1028,"Gas Basic Industry Facility","Hovering eerily among the clouds of a gas giant planet, this mass production industry platform can cast a long shadow, for it requires a massive static attunement system to remain afloat. Inside, the only real difference between it and one of its terrestrial counterparts is in the material composition used in its construction. Anything that would have been made from cheap, sturdy metal is replaced with high-strength, ultra-resistant alloys. Spare parts and raw materials are kept at absolutely minimal levels to maintain the proper weight and balance, while even items as innocuous as staff personal effects are carefully monitored and regulated.",4538,0,0,0,0,1,0,75000,1,0,0,0,41,0,0,8973814);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2493,1028,"Ice Basic Industry Facility","Instead of laboring to shield the production lines of this industrial facility from the surrounding environment, designers opted instead to use the available heat, interference, and even crushing pressure to help power the structure itself. A plant on an ice planet might have highly advanced extended heat sinks, while a factory on a plasma world might draw most, if not all of its electricity from magnetized coils specially attuned to the planet’s local ion winds. Taking advantage of the indigenous features of each world helps offset the cost of building mass production infrastructure there, which usually involves protective coatings, environmental clothing, and reinforced foundations.",4533,0,0,0,0,1,0,75000,1,0,0,0,41,0,0,8973816);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2494,1028,"Gas Advanced Industry Facility","Hovering eerily among the clouds of a gas giant planet, this mass production industry platform can cast a long shadow, for it requires a massive static attunement system to remain afloat. Inside, the only real difference between it and one of its terrestrial counterparts is in the material composition used in its construction. Anything that would have been made from cheap, sturdy metal is replaced with high-strength, ultra-resistant alloys. Spare parts and raw materials are kept at absolutely minimal levels to maintain the proper weight and balance, while even items as innocuous as staff personal effects are carefully monitored and regulated",4539,0,0,0,0,1,0,250000,1,0,0,0,41,0,0,8973813);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2495,1044,"Interplanetary Consolidation","For each level in this skill, you may install a command center on one additional planet, to a maximum of 6 planets. You can have only one command center per planet. Cannot be trained on Trial Accounts.",0,0,0,0.010000,0,1,0,500000,1,1323,0,0,16,33,0,9047701);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2496,15,"Minmatar Hub","",1132,33811,0,1,0,1,2,600000,0,0,0,21,3,0,0,7111922);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2497,15,"Minmatar Industrial Station","",1133,27681,0,1,0,1,2,600000,0,0,0,28,3,0,0,7111923);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2498,15,"Minmatar Military Station","",1134,36902,0,1,0,1,2,600000,0,0,0,28,3,0,0,7111924);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2499,15,"Minmatar Mining Station","",1135,30592,0,1,0,1,2,600000,0,0,0,28,3,0,0,7111925);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2500,15,"Minmatar Research Station","",1136,33481,0,1,0,1,2,600000,0,0,0,14,3,0,0,7111946);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2501,15,"Minmatar Station","",1137,19714,0,1,0,1,2,600000,0,0,0,28,3,0,0,7111926);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2502,15,"Minmatar Trade Post","",1138,15733,0,1,0,1,2,600000,0,0,0,14,3,0,0,7111927);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2505,1044,"Command Center Upgrades","Each level in this skill improves the quality of command facility available to you, in turn allowing for a greater number of connected facilities on that planet. Cannot be trained on Trial Accounts.",0,0,0,0.010000,0,1,0,500000,1,1323,0,0,16,33,0,9047700);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2506,89,"Mjolnir Torpedo","An ultra-heavy unguided EMP missile. Slow and dumb but its sheer damage potential is simply staggering.",1349,300,1500,0.100000,0,100,0,35000,1,923,0.070000,0,8,1349,422,729721);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2507,166,"Mjolnir Torpedo Blueprint","",1349,0,1,0.010000,0,1,0,7e+006,1,390,0,0,9,1349,422,729724);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2508,89,"Bane Torpedo","An ultra-heavy unguided nuclear missile. Slow and dumb but its sheer damage potential is simply staggering.       ",1348,300,1500,0.100000,0,100,0,25000,1,923,0.070000,0,8,1348,422,729727);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2509,166,"Bane Torpedo Blueprint","",1348,0,1,0.010000,0,1,0,1e+007,1,390,0,0,9,1348,422,729730);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2510,89,"Inferno Torpedo","An ultra-heavy unguided plasma missile. Slow and dumb but its sheer damage potential is simply staggering.",1347,300,1500,0.100000,0,100,0,32500,1,923,0.070000,0,8,1347,422,729733);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2511,166,"Inferno Torpedo Blueprint","",1347,0,1,0.010000,0,1,0,8e+006,1,390,0,0,9,1347,422,729736);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2512,387,"Gremlin Rocket","A small rocket with an EMP warhead. ",1352,300,100,0.005000,0,100,0,350,1,922,0.070000,0,8,1352,422,729739);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2513,166,"Gremlin Rocket Blueprint","",1352,0,1,0.010000,0,1,0,35000,1,318,0,0,9,1352,422,729742);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2514,387,"Foxfire Rocket","A small rocket with a plasma warhead.  ",1351,300,100,0.005000,0,100,0,260,1,922,0.070000,0,8,1351,422,729745);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2515,166,"Foxfire Rocket Blueprint","",1351,0,1,0.010000,0,1,0,40000,1,318,0,0,9,1351,422,729748);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2516,387,"Phalanx Rocket","A small rocket with a nuclear warhead.",1353,300,100,0.005000,0,100,0,180,1,922,0.070000,0,8,1353,422,729751);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2517,166,"Phalanx Rocket Blueprint","",1353,0,1,0.010000,0,1,0,50000,1,318,0,0,9,1353,422,729754);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2524,1027,"Barren Command Center","The modular design of this administrative structure allows it to be deployed piecemeal from orbit, then manually assembled on the surface by MTACs and engineering personnel. Supported by self-regulating pylons that follow the contours of indigenous terrain, the facility can accommodate almost any severity of incline or other non-critical geological hazard. Once active, it serves as both a central command post to coordinate the activity of all other nodes and a basic transportation site for getting commodities off world using standard, vertically launched rockets.",4566,0,5000,1000,500,1,0,90000,1,1322,0,0,41,0,0,9431687);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2525,1027,"Oceanic Command Center","Several interconnected underwater buildings comprise the oceanic command center, which serves as the nervous system for node structures built on water worlds. Built on the ocean floor, this facility includes a thick umbilical that connects it to a communications pod floating on the surface, through which all interplanetary transmissions are sent and received. It also houses a basic two-stage pressurized rocket tube for getting people and cargo to the surface and thence off world into orbit.",4567,0,5000,1000,500,1,0,90000,1,1322,0,0,41,0,0,9431691);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2526,225,"TeleDock","Automatically docks with the targeted station when invoked.",0,0,0,0,0,1,0,0,1,0,0.070000,0,7,1041,0,9060043);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2527,225,"TeleGate","Automatically uses destinations on a targeted stargate if invoked.",0,0,0,0,0,1,0,0,1,0,0.070000,0,7,1041,0,9060044);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2528,225,"SpaceAnchor","Prevents the ship from being secured (and avoiding the resulting warp back to your old position).",0,0,0,0,0,1,0,0,1,0,0.070000,0,7,1041,0,9060045);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2529,295,"Explosion Dampening Amplifier I","Boosts the explosive resistance of the shield. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,0,1,0,18742,1,550,0.070000,0,7,82,422,9060046);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2530,296,"Explosion Dampening Amplifier I Blueprint","",0,0,0,0.010000,0,1,0,187420,1,326,0,0,9,82,422,9060047);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2531,295,"Explosion Dampening Amplifier II","Boosts the explosive resistance of the shield. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,0,1,0,118684,1,550,0.060000,0,7,82,422,9060048);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2532,296,"Explosion Dampening Amplifier II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,0,0,0,9,82,422,9060049);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2533,1027,"Ice Command Center","This command structure is designed to survive in the harshest planetary environments the universe can offer. The superstructure uses a combination of titanium-steel reinforcement, increasing its overall resilience, and counter-harmonic stabilizers, which keep it level and secure regardless of geological conditions or activity. The entire facility is covered by a skin of adaptive plating originally designed for terraforming platforms, a protective barrier that insulates it from the surrounding environment. Visitors can expect a prolonged and immodest decontamination and pressurization process when first arriving at the command structure. Valuable materials are lifted off world by a bulk payload, reusable rocket, the scattered components of which are retrieved by cargo drones.",4568,0,5000,1000,500,1,0,90000,1,1322,0,0,41,0,0,9431689);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2534,1027,"Gas Command Center","Maintaining control over a section of “territory” above a gas giant requires a very specific type of command facility, one that is able to maintain its own orbit, house administrative personnel, and easily communicate and interact with other nodes. Suspended with equilibrium technology, these nodes are able to maintain altitude with minimal upkeep. If there is one major advantage to colonizing gas giant planets, it is that these facilities can literally be dropped directly from orbit with almost no concern for their descent or deployment.",4569,0,5000,1000,500,1,0,90000,1,1322,0,0,41,0,0,9431688);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2535,1029,"Oceanic Storage Facility","Goods and commodities are stored on ocean planets in a similar fashion as on more habitable terrestrial planets. Even though most underwater industrial processes conventionally take place inside residential dome habitats, underwater silos, due to their sheer size, must be stored outside these domes and be able to withstand the immense pressures and environmental stresses at the ocean floor.",4571,0,0,0,5000,1,0,250000,1,0,0,0,41,0,0,8980368);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2536,1029,"Gas Storage Facility","The problem of how to safely store mass quantities of harvested materials and assembled commodities until they can be transported to higher orbital facilities was difficult to solve. The issue was alleviated by the invention of the equilibrium cargo silo system, an arrangement of empty canisters suspended in a hollow chamber, which is then carefully filled with a specific type of common material from different strata of the host planet. The result has an effective net mass of zero kilograms, causing the facility to hang eerily at the exact desired altitude.",4573,0,0,0,5000,1,0,250000,1,0,0,0,41,0,0,8980365);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2537,295,"Heat Dissipation Amplifier I","Boosts the thermal resistance of the shield. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,0,1,0,18742,1,550,0.070000,0,7,82,422,9060050);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2538,296,"Heat Dissipation Amplifier I Blueprint","",0,0,0,0.010000,0,1,0,187420,1,326,0,0,9,82,422,9060051);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2539,295,"Heat Dissipation Amplifier II","Boosts the thermal resistance of the shield. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,0,1,0,118684,1,550,0.060000,0,7,82,422,9060052);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2540,296,"Heat Dissipation Amplifier II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,0,0,0,9,82,422,9060053);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2541,1029,"Barren Storage Facility","Barren environment storage units require a great amount of technology to be reliable and effective. The super structure is made from adaptive materials designed to withstand a wide range of extreme weather conditions, as barren planets have little to no atmosphere and are therefore prone to extreme climates. Likewise, each module of the structure is designed to store different states of matter, further compounding preservation and containment concerns.",4570,0,0,0,5000,1,0,250000,1,0,0,0,41,0,0,11914208);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2542,1030,"Oceanic Launchpad","Despite being anchored to the ocean floor, the underwater launch pad is able to deliver and receive payloads from orbit via two separate mechanisms. First, a compressed gyrostabilized gas containment system provides the required pressure to propel a solid fuel rocket to the surface of the water, where it can achieve escape velocity under its own power. Secondly, the structure houses an automated drone bay capable of retrieving splash-down canisters deposited on the surface as well as recovering booster stages of export rockets for reuse.",4561,0,0,0,10000,1,0,900000,1,0,0,0,41,0,0,8973832);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2543,1030,"Gas Launchpad","In order to transport produced commodities from the lower orbit position of the node structure to the higher orbit of spaceports and trade hubs above gas giant planets, an old but reliable technology was revisited. The lack of a solid surface requires a very low recoil launch system, a situation that prohibits the use of solid fuel rockets, but the Hohmann Mass Driver uses a series of triggered electromagnets instead, producing minimal waste force. Essentially an enormous cargo railgun, the device propels a ferrous canister to a waiting deceleration receptacle aboard a high-orbit facility.",4563,0,0,0,10000,1,0,900000,1,0,0,0,41,0,0,8973829);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2544,1030,"Barren Launchpad","The barren launchpad is able to send and receive payloads from orbit. Because of the relatively calm atmospheric conditions of most barren planets, the primary focus of this facility is on interfacing effectively with adjacent facilities, allowing for passengers and commodities to be easily organized, scanned, and transported to the appropriate areas. The obvious importance of a centralized spaceport often leads to its becoming a focal point of local culture, including trade, entertainment, and even illegal activities.",4559,0,0,0,10000,1,0,900000,1,0,0,0,41,0,0,9237602);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2545,295,"Kinetic Deflection Amplifier I","Boosts the kinetic resistance of the shield. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,0,1,0,18742,1,550,0.070000,0,7,82,422,9060054);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2546,296,"Kinetic Deflection Amplifier I Blueprint","",0,0,0,0.010000,0,1,0,187420,1,326,0,0,9,82,422,9060055);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2547,295,"Kinetic Deflection Amplifier II","Boosts the kinetic resistance of the shield. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,0,1,0,118684,1,550,0.060000,0,7,82,422,9060056);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2548,296,"Kinetic Deflection Amplifier II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,0,0,0,9,82,422,9060057);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2549,1027,"Lava Command Center","This command structure is designed to survive in the harshest planetary environments the universe can offer. The superstructure uses a combination of titanium-steel reinforcement, increasing its overall resilience, and counter-harmonic stabilizers, which keep it level and secure regardless of geological conditions or activity. The entire facility is covered by a skin of adaptive plating originally designed for terraforming platforms, a protective barrier that insulates it from the surrounding environment. Visitors can expect a prolonged and immodest decontamination and pressurization process when first arriving at the command structure. Valuable materials are lifted off world by a bulk payload, reusable rocket, the scattered components of which are retrieved by cargo drones.",4568,0,5000,1000,500,1,0,90000,1,1322,0,0,41,0,0,9431690);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2550,1027,"Storm Command Center","This command structure is designed to survive in the harshest planetary environments the universe can offer. The superstructure uses a combination of titanium-steel reinforcement, increasing its overall resilience, and counter-harmonic stabilizers, which keep it level and secure regardless of geological conditions or activity. The entire facility is covered by a skin of adaptive plating originally designed for terraforming platforms, a protective barrier that insulates it from the surrounding environment. Visitors can expect a prolonged and immodest decontamination and pressurization process when first arriving at the command structure. Valuable materials are lifted off world by a bulk payload, reusable rocket, the scattered components of which are retrieved by cargo drones.",4568,0,5000,1000,500,1,0,90000,1,1322,0,0,41,0,0,9431686);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2551,1027,"Plasma Command Center","This command structure is designed to survive in the harshest planetary environments the universe can offer. The superstructure uses a combination of titanium-steel reinforcement, increasing its overall resilience, and counter-harmonic stabilizers, which keep it level and secure regardless of geological conditions or activity. The entire facility is covered by a skin of adaptive plating originally designed for terraforming platforms, a protective barrier that insulates it from the surrounding environment. Visitors can expect a prolonged and immodest decontamination and pressurization process when first arriving at the command structure. Valuable materials are lifted off world by a bulk payload, reusable rocket, the scattered components of which are retrieved by cargo drones.",4568,0,5000,1000,500,1,0,90000,1,1322,0,0,41,0,0,9431692);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2552,1030,"Ice Launchpad","After years of customer complaints about catastrophic failures resulting from punctured fuel pods and corroded launch towers, a new line of hazardous environment launch facility was introduced. In addition to improving the overall structural integrity of the entire facility, each section is heavily compartmentalized. Should any one section fail or collapse, the faulty section is immediately locked down. Redundant systems allow the entire facility to continue functioning for some time. The rockets used by this type of launch pad are also heavily modified, sacrificing some cargo capacity for additional protection.",4564,0,0,0,10000,1,0,900000,1,0,0,0,41,0,0,8973830);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2553,295,"Magnetic Scattering Amplifier II","Boosts the EM resistance of the shield. Penalty: Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,0,1,0,118684,1,550,0.060000,0,7,82,422,9060058);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2554,296,"Magnetic Scattering Amplifier II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,0,0,0,9,82,422,9060059);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2555,1030,"Lava Launchpad","After years of customer complaints about catastrophic failures resulting from punctured fuel pods and corroded launch towers, a new line of hazardous environment launch facility was introduced. In addition to improving the overall structural integrity of the entire facility, each section is heavily compartmentalized. Should any one section fail or collapse, the faulty section is immediately locked down. Redundant systems allow the entire facility to continue functioning for some time. The rockets used by this type of launch pad are also heavily modified, sacrificing some cargo capacity for additional protection.",4564,0,0,0,10000,1,0,900000,1,0,0,0,41,0,0,8973831);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2556,1030,"Plasma Launchpad","After years of customer complaints about catastrophic failures resulting from punctured fuel pods and corroded launch towers, a new line of hazardous environment launch facility was introduced. In addition to improving the overall structural integrity of the entire facility, each section is heavily compartmentalized. Should any one section fail or collapse, the faulty section is immediately locked down. Redundant systems allow the entire facility to continue functioning for some time. The rockets used by this type of launch pad are also heavily modified, sacrificing some cargo capacity for additional protection.",4564,0,0,0,10000,1,0,900000,1,0,0,0,41,0,0,8973833);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2557,1030,"Storm Launchpad","After years of customer complaints about catastrophic failures resulting from punctured fuel pods and corroded launch towers, a new line of hazardous environment launch facility was introduced. In addition to improving the overall structural integrity of the entire facility, each section is heavily compartmentalized. Should any one section fail or collapse, the faulty section is immediately locked down. Redundant systems allow the entire facility to continue functioning for some time. The rockets used by this type of launch pad are also heavily modified, sacrificing some cargo capacity for additional protection.",4564,0,0,0,10000,1,0,900000,1,0,0,0,41,0,0,8973834);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2558,1029,"Lava Storage Facility","At some point, it all comes down to more metal.\" The designers of this storage site believed this adage above all else. The outer walls of each container are comprised of almost a meter of titanium alloy around a flexible, lightweight tritanium frame, all sealed with a few layers of active nanite coating to prevent microfractures and thermal warping. This combination allows the building to withstand nearly any environmental challenge. To prevent the tritanium supports from decaying, the interior is kept in a constant vacuum, and workers must wear fully sealed atmosphere suits at all times.",4572,0,0,0,5000,1,0,250000,1,0,0,0,41,0,0,8980367);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2559,201,"ECM - Phase Inverter II","Analyzes incoming targeting signals and attempts to counter them by emitting an out-of-phase signal back. Great against Ladar targeting systems.",0,0,0,5,0,1,0,193826,1,716,0.060000,0,7,3228,422,9060060);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2560,1029,"Plasma Storage Facility","At some point, it all comes down to more metal.\" The designers of this storage site believed this adage above all else. The outer walls of each container are comprised of almost a meter of titanium alloy around a flexible, lightweight tritanium frame, all sealed with a few layers of active nanite coating to prevent microfractures and thermal warping. This combination allows the building to withstand nearly any environmental challenge. To prevent the tritanium supports from decaying, the interior is kept in a constant vacuum, and workers must wear fully sealed atmosphere suits at all times.",4572,0,0,0,5000,1,0,250000,1,0,0,0,41,0,0,8980369);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2561,1029,"Storm Storage Facility","At some point, it all comes down to more metal.\" The designers of this storage site believed this adage above all else. The outer walls of each container are comprised of almost a meter of titanium alloy around a flexible, lightweight tritanium frame, all sealed with a few layers of active nanite coating to prevent microfractures and thermal warping. This combination allows the building to withstand nearly any environmental challenge. To prevent the tritanium supports from decaying, the interior is kept in a constant vacuum, and workers must wear fully sealed atmosphere suits at all times.",4572,0,0,0,5000,1,0,250000,1,0,0,0,41,0,0,8980370);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2562,1029,"Temperate Storage Facility","Terrestrial storage units require a great amount of technology to be reliable and effective. The super structure is made from adaptive materials designed to withstand a wide range of extreme weather conditions, as temperate planets tend to experience more pronounced seasonal changes. Likewise, each module of the structure is designed to store different states of matter, further compounding preservation and containment concerns.",4570,0,0,0,5000,1,0,250000,1,0,0,0,41,0,0,8980371);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2563,201,"ECM - Ion Field Projector II","Projects a low intensity field of ionized particles to disrupt the effectivenes of enemy sensors. Very effective against Magnetometric-based sensors. ",0,0,0,5,0,1,0,194778,1,715,0.060000,0,7,3227,422,9060061);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2567,201,"ECM - Multispectral Jammer II","An advanced multipurpose jamming system designed to offer blanket protection against all forms of targeting. Not as effective as the more specialized systems but is still effective against less advanced targeting systems. ",0,0,0,5,0,1,0,232064,1,719,0.060000,0,7,109,422,9060062);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2571,201,"ECM - Spatial Destabilizer II","Projects random bursts of gravitons that disrupt accurate targeting. As expected this system works best against Gravimetric targeting systems.",0,0,0,5,0,1,0,184600,1,717,0.060000,0,7,3226,422,9060063);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2573,226,"The Solitaire","A ghost ship of enormous proportions, this Ragnarok-class Titan should be at the core of a Minmatar strike force or planetary defense, yet here it floats in silence. Its hull is airtight, yet all useful technology has been meticulously stripped from it, including weapons systems, propulsion, and electronics. There is no trace of its crew, despite all of its escape pods being present.",3114,1,0,0,0,1,0,0,0,0,0,0,2,0,0,8777942);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2574,1027,"Improved Storm Command Center","This command structure is designed to survive in the harshest planetary environments the universe can offer. The superstructure uses a combination of titanium-steel reinforcement, increasing its overall resilience, and counter-harmonic stabilizers, which keep it level and secure regardless of geological conditions or activity. The entire facility is covered by a skin of adaptive plating originally designed for terraforming platforms, a protective barrier that insulates it from the surrounding environment. Visitors can expect a prolonged and immodest decontamination and pressurization process when first arriving at the command structure. Valuable materials are lifted off world by a bulk payload, reusable rocket, the scattered components of which are retrieved by cargo drones.",4568,0,5000,400,500,1,0,2.8e+006,0,0,0,0,41,0,0,9274135);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2575,201,"ECM - White Noise Generator II","Disrupts enemy targeting by generating a field of random sensor noise. Works especially well against Radar systems.",0,0,0,5,0,1,0,192450,1,718,0.060000,0,7,3229,422,9060064);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2576,1027,"Advanced Storm Command Center","This command structure is designed to survive in the harshest planetary environments the universe can offer. The superstructure uses a combination of titanium-steel reinforcement, increasing its overall resilience, and counter-harmonic stabilizers, which keep it level and secure regardless of geological conditions or activity. The entire facility is covered by a skin of adaptive plating originally designed for terraforming platforms, a protective barrier that insulates it from the surrounding environment. Visitors can expect a prolonged and immodest decontamination and pressurization process when first arriving at the command structure. Valuable materials are lifted off world by a bulk payload, reusable rocket, the scattered components of which are retrieved by cargo drones.",4568,0,5000,800,500,1,0,3.7e+006,0,0,0,0,41,0,0,9274133);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2577,1027,"Elite Storm Command Center","This command structure is designed to survive in the harshest planetary environments the universe can offer. The superstructure uses a combination of titanium-steel reinforcement, increasing its overall resilience, and counter-harmonic stabilizers, which keep it level and secure regardless of geological conditions or activity. The entire facility is covered by a skin of adaptive plating originally designed for terraforming platforms, a protective barrier that insulates it from the surrounding environment. Visitors can expect a prolonged and immodest decontamination and pressurization process when first arriving at the command structure. Valuable materials are lifted off world by a bulk payload, reusable rocket, the scattered components of which are retrieved by cargo drones.",4568,0,5000,1600,500,1,0,6.4e+006,0,0,0,0,41,0,0,9274134);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2578,1027,"Limited Temperate Command Center","The modular design of this administrative structure allows it to be deployed piecemeal from orbit, then manually assembled on the surface by MTACs and engineering personnel. Supported by self-regulating pylons that follow the contours of indigenous terrain, the facility can accommodate almost any severity of incline or other non-critical geological hazard. Once active, it serves as both a central command post to coordinate the activity of all other nodes and a basic transportation site for getting commodities off world using standard, vertically launched rockets.",4566,0,5000,100,500,1,0,670000,0,0,0,0,41,0,0,9274146);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2579,203,"Gravimetric Backup Array I","A backup system which operates in conjunction with the main array. Reduces the ship\'s vulnerability to jamming.


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,0,1,0,12494,1,720,0.070000,0,7,104,422,9060065);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2580,203,"Gravimetric Backup Array II","A backup system which operates in conjunction with the main array. Reduces the ship\'s vulnerability to jamming.


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,0,1,0,48288,1,720,0.060000,0,7,104,422,9060066);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2581,1027,"Standard Temperate Command Center","The modular design of this administrative structure allows it to be deployed piecemeal from orbit, then manually assembled on the surface by MTACs and engineering personnel. Supported by self-regulating pylons that follow the contours of indigenous terrain, the facility can accommodate almost any severity of incline or other non-critical geological hazard. Once active, it serves as both a central command post to coordinate the activity of all other nodes and a basic transportation site for getting commodities off world using standard, vertically launched rockets.",4566,0,5000,200,500,1,0,1.6e+006,0,0,0,0,41,0,0,9274147);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2582,1027,"Improved Temperate Command Center","The modular design of this administrative structure allows it to be deployed piecemeal from orbit, then manually assembled on the surface by MTACs and engineering personnel. Supported by self-regulating pylons that follow the contours of indigenous terrain, the facility can accommodate almost any severity of incline or other non-critical geological hazard. Once active, it serves as both a central command post to coordinate the activity of all other nodes and a basic transportation site for getting commodities off world using standard, vertically launched rockets.",4566,0,5000,400,500,1,0,2.8e+006,0,0,0,0,41,0,0,9274145);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2583,203,"LADAR Backup Array I","A backup system which operates in conjunction with the main array. Reduces the ship\'s vulnerability to jamming.


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,0,1,0,12494,1,721,0.070000,0,7,104,422,9060067);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2584,203,"LADAR Backup Array II","A backup system which operates in conjunction with the main array. Reduces the ship\'s vulnerability to jamming.


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,0,1,0,47420,1,721,0.060000,0,7,104,422,9060068);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2585,1027,"Advanced Temperate Command Center","The modular design of this administrative structure allows it to be deployed piecemeal from orbit, then manually assembled on the surface by MTACs and engineering personnel. Supported by self-regulating pylons that follow the contours of indigenous terrain, the facility can accommodate almost any severity of incline or other non-critical geological hazard. Once active, it serves as both a central command post to coordinate the activity of all other nodes and a basic transportation site for getting commodities off world using standard, vertically launched rockets.",4566,0,5000,800,500,1,0,3.7e+006,0,0,0,0,41,0,0,9274143);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2586,1027,"Elite Temperate Command Center","The modular design of this administrative structure allows it to be deployed piecemeal from orbit, then manually assembled on the surface by MTACs and engineering personnel. Supported by self-regulating pylons that follow the contours of indigenous terrain, the facility can accommodate almost any severity of incline or other non-critical geological hazard. Once active, it serves as both a central command post to coordinate the activity of all other nodes and a basic transportation site for getting commodities off world using standard, vertically launched rockets.",4566,0,5000,1600,500,1,0,6.4e+006,0,0,0,0,41,0,0,9274144);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2587,203,"Magnetometric Backup Array I","A backup system which operates in conjunction with the main array. Reduces the ship\'s vulnerability to jamming.


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,0,1,0,12494,1,723,0.070000,0,7,104,422,9060069);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2588,203,"Magnetometric Backup Array II","A backup system which operates in conjunction with the main array. Reduces the ship\'s vulnerability to jamming.


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,5,0,1,0,47872,1,723,0.060000,0,7,104,422,9060070);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2591,203,"Multi Sensor Backup Array I","A backup system which operates in conjunction with the main array. Reduces the ship\'s vulnerability to jamming.


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,20,0,1,0,24986,1,724,0.070000,0,7,104,422,9060071);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2592,203,"Multi Sensor Backup Array II","A backup system which operates in conjunction with the main array. Reduces the ship\'s vulnerability to jamming.


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,0,0,20,0,1,0,68996,1,724,0.060000,0,7,104,422,9060072);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2595,314,"Encoded Data Chip","This small, portable disk is only about two centimeters in diameter, yet it is capable of holding a vast amount of information. A durable outer casing made from plasteel rotates away to reveal the raw data surface when the device is inserted into a reader.",0,0,10,0.100000,0,1,0,0,1,0,0,0,17,2038,0,9067615);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2596,314,"Crates of Clothing","It’s not the latest fashion, or even the rugged survival gear colonists wear on developing worlds, but this basic, mass-produced clothing is better than nothing.",1209,0,60000,60,0,1,0,0,1,0,0,0,17,1209,0,11970515);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2597,314,"Crates of Command Reports","Despite the fact that these datachips really only contain logistical information, promotion notifications, and other mundane military records, they are nonetheless classified.",0,0,40000,40,0,1,0,0,1,0,0,0,17,1192,0,11970516);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2598,314,"Crates of Coolant","This specially blended fluid is ideal for transferring thermal energy away from sensitive machinery or computer components, rerouting it to heat sinks so it can be eliminated from the system.",0,0,80000,80,0,1,0,0,1,0,0,0,17,1360,0,11970519);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2599,314,"Crates of Corporate Documents","These datadisks are absolutely filled with endless databases of market knowledge, sales figures, salary ranges, production estimates, and all kinds of other corporate information.",0,0,40000,40,0,1,0,0,1,0,0,0,17,1192,0,11970520);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2601,314,"Crates of Data Sheets","These complicated data sheets may mean little to the layman\'s eye, but can prove valuable in the right hands.",0,0,40000,40,0,1,0,0,1,0,0,0,17,1192,0,11970522);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2602,314,"Crates of Drill Parts","These large containers are fitted with a password-protected security lock.  These particular containers are filled with spare parts needed to build a drill used for drilling through rock and ice sheets.",1171,0,90000,90,0,1,0,0,1,0,0,0,17,1171,0,11970523);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2603,763,"Nanofiber Internal Structure I","Replaces some of the heavier structure components with lighter, but more fragile material. Increases ship\'s velocity and improves maneuverability at the expense of hull strength.


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,50,100,5,0,1,0,1664,1,1196,0.070000,0,7,1042,422,9065521);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2604,158,"Nanofiber Internal Structure I Blueprint","",0,0,0,0.010000,0,1,0,16640,1,335,0,0,9,1042,422,9060073);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2605,763,"Nanofiber Internal Structure II","Replaces some of the heavier structure components with lighter, but more fragile material. Increases ship\'s velocity and improves maneuverability at the expense of hull strength.


Using more than one type of this module or similar modules that affect the same attribute on the ship will be penalized.",0,50,100,5,0,1,0,35200,1,1196,0.060000,0,7,1042,422,9065522);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2606,158,"Nanofiber Internal Structure II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,0,0,0,9,1042,422,9060074);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2608,314,"Crates of Fertilizer","Fertilizer is particularly valued on agricultural worlds, where there is constant supply for all commodities that boost export value.",0,0,80000,80,0,1,0,0,1,0,0,0,17,1188,0,11970526);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2610,314,"Crates of Frozen Food","Frozen food is in high demand in many regions, especially on stations orbiting a non-habitable planet and a long way from an agricultural world.",0,0,40000,40,0,1,0,0,1,0,0,0,17,30,0,11970527);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2612,226,"Hollow Asteroid","This massive asteroid\'s surface is covered in gaping holes, giving way to an internal chamber. The work of miners or the winds of space and time.",1146,4805,0,0,0,1,0,0,0,0,0,0,2,0,0,3100890);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2613,653,"Sabretooth Fury Light Missile","Light assault missile. An advanced missile with a volatile payload of magnetized plasma, the Sabretooth is a multi-purpose missile specifically engineered to take down shield systems.


A modified version of Sabretooth Light Missile. Does more damage than the Sabretooth but the volatile nature of the warhead, and its powerful containment system, increase the ship\'s electromagnetic footprint when loaded and armed.",192,300,700,0.015000,0,5000,0,95240,1,927,0.060000,0,8,192,422,8778311);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2614,166,"Sabretooth Fury Light Missile Blueprint","",190,0,1,0.010000,0,1,0,1e+007,1,0,0,0,9,190,422,729865);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2615,314,"Crates of Garbage","Production waste can mean garbage to some but valuable resource material to others.",0,0,90000,90,0,1,0,0,1,0,0,0,17,1179,0,11970529);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2616,314,"Large Crates of Coolant","This specially blended fluid is ideal for transferring thermal energy away from sensitive machinery or computer components, rerouting it to heat sinks so it can be eliminated from the system.",0,0,800000,800,0,1,0,0,1,0,0,0,17,1360,0,11970606);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2617,314,"Crates of Guidance Systems","An electrical device used in targeting systems and tracking computers.",0,0,100000,100,0,1,0,0,1,0,0,0,17,1361,0,11970530);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2618,314,"Crates of Harroule Dryweed","Grown on a terrestrial world in the Harroule system, the Dryweed plant has fragile, yellowish leaves that burn very slowly, giving off a pleasant vapor that is known to have a soothing effect when inhaled.",1209,0,40000,40,0,1,0,0,1,0,0,0,17,1209,0,11970531);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2619,314,"Crates of High-Tech Small Arms","These weapons are of superior quality to those normally found on the public market, although more expensive as well.


They are implemented with a safety net which prevents them from being used illegally in stations where most types of small arms are prohibited.  Therefore many regions do not apply the small arms ban on these weapons.",0,0,80000,80,0,1,0,0,1,0,0,0,17,1366,0,11970532);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2620,314,"Crates of Liparer Cheese","Due to the unique properties of the Liparer system’s terrestrial worlds, animals raised there have very low body fat, resulting in relatively bland but far healthier dairy products.",1209,0,100000,100,0,1,0,0,1,0,0,0,17,1209,0,11970534);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2621,656,"Cataclysm Fury Cruise Missile","Extra heavy assault missile. An Amarrian large missile with good capabilities, the Cataclysm was for a long time confined solely to the Amarr armed forces, but exports began some years ago and the missile is now found throughout the universe.


A modified version of the Cataclysm.  Does more damage than the Cataclysm, but the volatile nature of the warhead, and its powerful containment system, increase the ship\'s electromagnetic footprint when loaded and armed.",184,300,1250,0.050000,0,5000,0,810600,1,925,0.060000,0,8,184,422,2760828);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2622,166,"Cataclysm Fury Cruise Missile Blueprint","",184,0,1,0.010000,0,1,0,1e+007,1,0,0,0,9,184,422,729871);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2623,314,"Crates of Listening Post Recordings","After diligently recording information on astral phenomena or military maneuvers, listening post data is embedded on encrypted chips, which must be carefully transported by hand.",0,0,40000,40,0,1,0,0,1,0,0,0,17,2038,0,11970535);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2624,314,"Crates of Mechanical Parts","These basic elements of all mechanical hardware can come in virtually any shape and size, although composite or modular functionality is highly advantageous in today\'s competitive market. Factories and manufacturers take these parts and assemble them into finished products, which are then sold on the market.",0,0,100000,100,0,1,0,0,1,0,0,0,17,1186,0,11970541);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2626,314,"Crates of Missile Guidance Systems","Guidance systems allow both atmospheric and vacuum launched missiles to find targets using sophisticated electronics and specially calibrated sensors.",0,0,90000,90,0,1,0,0,1,0,0,0,17,1361,0,11970542);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2627,314,"Crates of Mono-Cell Batteries","Although they’re a relatively old design, mono-cell batteries are still a reliable method of storing electricity in bulk, specifically designed for long-term use in stations or planetary vehicles.",0,0,80000,80,0,1,0,0,1,0,0,0,17,1184,0,11970543);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2628,314,"Crates of Odd Data Crystals","Whatever is recorded on these datacrystals, the encryption is far beyond normal methods of deciphering, and requires expert attention to crack.",1209,0,40000,40,0,1,0,0,1,0,0,0,17,1209,0,11970544);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2629,655,"Scourge Fury Heavy Missile","The Scourge is an old relic from the Caldari-Gallente War that is still in widespread use because of its low price and versatility.


A modified version of Scourge Heavy Missile. Does more damage than the Scourge Heavy Missile but the volatile nature of the warhead, and its powerful containment system, increase the ship\'s electromagnetic footprint when loaded and armed.",189,300,1000,0.030000,0,5000,0,574400,1,926,0.060000,0,8,189,422,2760825);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2630,166,"Scourge Fury Heavy Missile Blueprint","",189,0,1,0.010000,0,1,0,1e+007,1,0,0,0,9,189,422,729877);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2631,314,"Crates of OP Insecticide","Organophosphates, similar to nerve gases, have long been used as insecticides, and as bugs evolve, so too must the methods for dealing with them. This particular insecticide is perhaps the most lethal known to humankind, and can kill nearly anything exposed to it. ",0,0,60000,60,0,1,0,0,1,0,0,0,17,1187,0,11970545);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2632,314,"Crates of Oxygen","Oxygen is a commodity in constant demand. While most stations have their own supply units, smaller depots and space crafts rely on imports.",0,0,70000,70,0,1,0,0,1,0,0,0,17,1183,0,11970546);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2633,314,"Crates of Planetary Vehicles","Tracked, wheeled and hover vehicles used within planetary atmosphere for personal and business use.",0,0,40000,40,0,1,0,0,1,0,0,0,17,1367,0,11970547);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2635,314,"Crates of Protein Delicacies","Protein Delicacies are cheap and nutritious food products manufactured by one of the Caldari mega corporations, Sukuuvestaa. It comes in many flavors and tastes delicious. Despite its cheap price and abundance it is favored by many gourmet chefs in some of the finest restaurants around for its rich, earthy flavor and fragrance.",0,0,70000,70,0,1,0,0,1,0,0,0,17,398,0,11970548);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2636,314,"Crates of Raggy Dolls","Known across New Eden for their anatomical correctness and temperature sensitive, dynamic hair coloration, Raggy dolls are always in demand during gift-giving holidays.",0,0,40000,40,0,1,0,0,1,0,0,0,17,2992,0,11970549);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2637,656,"Cataclysm Precision Cruise Missile","Extra heavy assault missile. An Amarrian large missile with good capabilities, the Cataclysm was for a long time confined solely to the Amarr armed forces, but exports began some years ago and the missile is now found throughout the universe.


A modified version of Cataclysm Cruise Missile. Is great for taking down smaller ships but the velocity has to be curbed to get a better launch.",184,300,1250,0.050000,0,5000,0,810600,1,918,0.060000,0,8,184,422,729880);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2638,166,"Cataclysm Precision Cruise Missile Blueprint","",185,0,1,0.010000,0,1,0,1e+007,1,0,0,0,9,185,422,729883);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2639,314,"Crates of Repair Parts","Despite the enormous diversity of size and complexity of machinery across the cluster, there are numerous common elements shared by all people, such as high tension wiring, locking fasteners, and thermal shielding.",0,0,70000,70,0,1,0,0,1,0,0,0,17,1186,0,11970550);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2640,314,"Crates of Replacement Parts","Replacement parts include anything from machined components, such as plastic casings and metal brackets, to more basic pieces like nuts and bolts.",0,0,40000,40,0,1,0,0,1,0,0,0,17,1186,0,11970553);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2641,314,"Crates of Reports","These encoded reports may mean little to the untrained eye, but can prove valuable to the relevant institution.",0,0,40000,40,0,1,0,0,1,0,0,0,17,1192,0,11970554);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2642,314,"Crates of Robotics","These pre-programmed or remote control mechanical tools are commonly used in mass production facilities, hazardous material handling, or dangerous front line military duties such as bomb disarming and disposal.",0,0,70000,70,0,1,0,0,1,0,0,0,17,1368,0,11970555);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2644,314,"Crates of Small Arms","Personal weapons and armaments, used both for warfare and personal security.",0,0,60000,60,0,1,0,0,1,0,0,0,17,1366,0,11970559);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2645,314,"Crates of Soil","Fertile soil rich with nutrients is very sought after by agricultural corporations and colonists on worlds with short biological history.",0,0,50000,50,0,1,0,0,1,0,0,0,17,1181,0,11970560);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2646,314,"Crates of Spiced Wine","Luxury goods are always solid commodities for inter-stellar trading. Spiced wine is not the rarest of luxury goods, but it can still be sold at small outposts and bases that don\'t manufacture any themselves.",0,0,90000,90,0,1,0,0,1,0,0,0,17,27,0,11970565);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2647,653,"Flameburst Precision Light Missile","Light assault missile. The explosion the Flameburst missile creates upon impact is stunning enough for any display of fireworks - just ten times more deadly.


A modified version of Flameburst Light Missile. Is great for taking down smaller ships but the velocity has to be curbed to get a better launch. ",191,300,700,0.015000,0,5000,0,95240,1,917,0.060000,0,8,191,422,8778307);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2648,166,"Flameburst Precision Light Missile Blueprint","",191,0,1,0.010000,0,1,0,1e+007,1,0,0,0,9,191,422,729889);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2652,314,"Crates of Synthetic Oil","Since original oil can be harvested only from a world with a long biological history, synthetic oil has become frequently produced in laboratories all over known space.",0,0,60000,60,0,1,0,0,1,0,0,0,17,1187,0,11970567);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2653,314,"Crates of Vaccine Injectors","These single-use syringes contain a predetermined dose of adaptive vaccines designed to counteract almost any known virus.",0,0,90000,90,0,1,0,0,1,0,0,0,17,28,0,11970570);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2654,314,"Crates of Viral Agent","The causative agent of an infectious disease, the viral agent is a parasite with a noncellular structure composed mainly of nucleic acid within a protein coat.",0,0,80000,80,0,1,0,0,1,0,0,0,17,1199,0,11970571);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2655,655,"Havoc Precision Heavy Missile","The be-all-end-all of medium sized missiles, the Havoc is a must for those who want a guaranteed kill no matter the cost.


A modified version of Havoc Heavy Missile. Is great for taking down smaller ships but the velocity has to be curbed to get a better launch.",186,300,1000,0.030000,0,5000,0,574400,1,919,0.060000,0,8,186,422,729892);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2656,166,"Havoc Precision Heavy Missile Blueprint","",186,0,1,0.010000,0,1,0,1e+007,1,0,0,0,9,186,422,729895);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2657,314,"Crates of Vitoc","The Vitoc booster has become more than a simple strategy by the Amarrians in controling their slaves. With the Vitoc method, slaves are injected with a toxic chemical substance that is fatal unless the recipient receives a constant supply of an antidote. The method first appeared a few centuries ago when the Amarrians started manning some of their space ships with slaves. As space crew the slaves had to be cajoled into doing complex, often independent work, making older methods of slave control undesirable. Although the more conventional ways of subduing slaves with force (actual or threat of) are still widely used in other forced labor areas, the Vitoc method has proven itself admirably for the fleet.",0,0,70000,70,0,1,0,0,1,0,0,0,17,1207,0,11970572);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2659,314,"Crates of Water","Water is one of the basic conditional elements of human survival. Most worlds have this compound in relative short supply and hence must rely on starship freight.",0,0,60000,60,0,1,0,0,1,0,0,0,17,1178,0,11970573);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2660,314,"Crates of Zemnar","Zemnar is an uncommon type of antibiotic specifically used to combat rare bacterial infections.  Originally discovered by the late Gallente biologist, Lameur Zemnar, the drug is now frequently kept in stock in the more wealthy quarters of the galaxy, in case of a bacterial outbreak.",0,0,40000,40,0,1,0,0,1,0,0,0,17,28,0,11970574);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2662,283,"Group of Army Recruits","These fresh-faced young men and women are absolutely full of potential, eagerly anticipating the glory and excitement of battle when not trading stories of their significant others back home or plans for college after the war.",0,0,60000,60,0,1,0,0,1,0,0,0,17,2540,0,11970577);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2663,283,"Group of Cattle","Cattle are domestic animals raised for home use or for profit, whether it be for their meat or dairy products.",0,0,100000,100,0,1,0,0,1,0,0,0,17,2854,0,11970578);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2665,283,"Group of Elite Slaves","Slavery has always been a questionable industry, favored by the Amarr Empire and detested by the Gallente Federation.  These elite slaves are exceptionally well suited for physical labor.",0,0,60000,60,0,1,0,0,1,0,0,0,17,2541,0,11970579);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2666,283,"Group of Exotic Dancers","Exotic dancing is considered an art form, even though not everyone might agree. Exposing the flesh in public places may be perfectly acceptable within the Federation, but in the Amarr Empire it\'s considered a grave sin and a sign of serious deviancy.",0,0,40000,40,0,1,0,0,1,0,0,0,17,2543,0,11970580);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2668,283,"Group of Genetically Enhanced Livestock","Livestock are domestic animals raised for home use or for profit, whether it be for their meat or dairy products.  This particular breed of livestock has been genetically enhanced using the very latest technology.",0,0,100000,100,0,1,0,0,1,0,0,0,17,2551,0,11970581);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2669,283,"Group of Kameiras","An elite type of foot soldier, originally bred from Minmatar slaves by the Amarr Empire.  Raised from birth to become soldiers, they serve the Empire, Khanid Kingdom and Ammatar well, although always kept on a tight leash.",0,0,70000,70,0,1,0,0,1,0,0,0,17,2549,0,11970585);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2670,283,"Group of Marines","When war breaks out, the demand for transporting military personnel on site can exceed the grasp of the military organization. In these cases, the aid from non-military spacecrafts is often needed.",0,0,60000,60,0,1,0,0,1,0,0,0,17,2540,0,11970587);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2671,283,"Group of Militants","A combative character; aggressive, especially in the service of a cause.",0,0,60000,60,0,1,0,0,1,0,0,0,17,2540,0,11970595);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2672,283,"Group of Miners","Covered in a perpetual layer of grime and dust, these grizzled laborers seem out of place anywhere but deep underground on some lonely planet or boring through the core of a wandering asteroid.",0,0,50000,50,0,1,0,0,1,0,0,0,17,2536,0,11970597);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2673,314,"Large Crates of Data Sheets","These complicated data sheets may mean little to the layman\'s eye, but can prove valuable in the right hands.",0,0,400000,400,0,1,0,0,1,0,0,0,17,1192,0,11970608);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2674,283,"Group of Refugees","When wars and epidemics break out, people flee from their homes, forming massive temporary migrations.",0,0,40000,40,0,1,0,0,1,0,0,0,17,2542,0,11970598);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2675,283,"Group of Science Graduates","People that have recently graduated with a degree in science at an acknowledged university.",0,0,50000,50,0,1,0,0,1,0,0,0,17,2891,0,11970599);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2676,283,"Group of Security Personnel","Packing small arms and shortwave communicators, security personnel are the ideal choice for policing small settlements or corporate offices, where mercenaries would be unpredictable and military forces would be overkill.",0,0,60000,60,0,1,0,0,1,0,0,0,17,2540,0,11970600);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2677,283,"Group of Slaves","Slavery has always been a questionable industry, favored by the Amarr Empire and detested by the Gallente Federation.",0,0,50000,50,0,1,0,0,1,0,0,0,17,2541,0,11970601);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2678,283,"Group of Tourists","The need for tasting other cultures and seeing new worlds is unquenchable among the well-off citizens of the universe.",0,0,50000,50,0,1,0,0,1,0,0,0,17,2539,0,11970602);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2679,654,"Terror Rage Assault Missile","An unguided warhead designed for use with heavy assault launchers. Heavy assault missiles can be fired at a greater rate than heavy missiles, at the expense of effective range.


This modified version of the Terror Assault Missile packs a considerably stronger punch, but as a result is heavier and slower. This makes it very effective against larger targets, but markedly less effective against smaller and more agile targets. The volatile nature of the warhead, and its powerful containment system, increase the ship\'s electromagnetic footprint when loaded and armed.",3234,300,700,0.015000,0,5000,0,120240,1,973,0.060000,0,8,3234,422,2941092);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2680,166,"Terror Rage Assault Missile Blueprint","",192,0,1,0.010000,0,1,0,1e+007,1,0,0,0,9,192,422,729901);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2681,283,"Group of VIPs","Very important people. Business executives, politicians, diplomats and game designers.",0,0,50000,50,0,1,0,0,1,0,0,0,17,2538,0,11970603);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2682,314,"Large Crates of Galeptos Medicine","Galeptos is a rare type of medicine developed by the famous Gallentean scientist, Darven Galeptos.  It is produced from a blend of organic and chemical material, used to cure a rare and deadly viral infection which has been creeping up more frequently as of late.  


Rumor has it that Galeptos manufactured the virus himself, then sold the cure for billions of credits.  Of course his corporation, Galeptos Medicines, steadfastly denies any such \"unfounded\" accusations and has threatened legal action to anyone who mentions it in public.",0,0,1e+006,1000,0,1,0,0,1,0,0,0,17,28,0,11970620);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2683,314,"Large Crates of Guidance Systems","An electrical device used in targeting systems and tracking computers.",0,0,1e+006,1000,0,1,0,0,1,0,0,0,17,1361,0,11970622);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2684,314,"Large Crates of Harroule Dryweed","Grown on a terrestrial world in the Harroule system, the Dryweed plant has fragile, yellowish leaves that burn very slowly, giving off a pleasant vapor that is known to have a soothing effect when inhaled.",1171,0,400000,400,0,1,0,0,1,0,0,0,17,1171,0,11970623);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2685,314,"Large Crates of Holoreels","Holo-Vid reels are the most common type of personal entertainment there is. From interactive gaming to erotic motion pictures, these reels can contain hundreds of titles each.",0,0,100000,500,0,1,0,250,1,0,0,0,17,1177,0,11970624);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2686,314,"Large Crates of Liparer Cheese","Due to the unique properties of the Liparer system’s terrestrial worlds, animals raised there have very low body fat, resulting in relatively bland but far healthier dairy products.",1171,0,1e+006,1000,0,1,0,0,1,0,0,0,17,1171,0,11970625);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2687,314,"Large Crates of Mechanical Parts","These basic elements of all mechanical hardware can come in virtually any shape and size, although composite or modular functionality is highly advantageous in today\'s competitive market. Factories and manufacturers take these parts and assemble them into finished products, which are then sold on the market.",0,0,1e+006,1000,0,1,0,0,1,0,0,0,17,1186,0,11970627);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2688,314,"Large Crates of Mono-Cell Batteries","Although they’re a relatively old design, mono-cell batteries are still a reliable method of storing electricity in bulk, specifically designed for long-term use in stations or planetary vehicles.",0,0,800000,800,0,1,0,0,1,0,0,0,17,1184,0,11970628);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2689,314,"Large Crates of Oxygen","Oxygen is a commodity in constant demand. While most stations have their own supply units, smaller depots and space crafts rely on imports.",0,0,700000,700,0,1,0,0,1,0,0,0,17,1183,0,11970629);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2690,314,"Large Crates of Planetary Vehicles","Tracked, wheeled and hover vehicles used within planetary atmosphere for personal and business use.",0,0,400000,400,0,1,0,0,1,0,0,0,17,1367,0,11970630);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2691,314,"Large Crates of Polytextiles","This synthetic fabric is used for clothing as well as makeshift shelters on hard-climate colonies.",0,0,500000,500,0,1,0,0,1,0,0,0,17,1189,0,11970632);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2692,314,"Large Crates of Protein Delicacies","Protein Delicacies are cheap and nutritious food products manufactured by one of the Caldari mega corporations, Sukuuvestaa. It comes in many flavors and tastes delicious. Despite its cheap price and abundance it is favored by many gourmet chefs in some of the finest restaurants around for its rich, earthy flavor and fragrance.",1171,0,700000,700,0,1,0,0,1,0,0,0,17,1171,0,11970635);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2693,314,"Large Crates of Reports","These encoded reports may mean little to the untrained eye, but can prove valuable to the relevant institution.",0,0,400000,400,0,1,0,0,1,0,0,0,17,1192,0,11970638);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2694,314,"Large Crates of Small Arms","Personal weapons and armaments, used both for warfare and personal security.",0,0,600000,600,0,1,0,0,1,0,0,0,17,1366,0,11970640);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2695,314,"Large Crates of Soil","Fertile soil rich with nutrients is very sought after by agricultural corporations and colonists on worlds with short biological history.",0,0,500000,500,0,1,0,0,1,0,0,0,17,1181,0,11970641);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2696,314,"Large Crates of Spirits","Alcoholic beverages made by distilling a fermented mash of grains.",0,0,250000,600,0,1,0,455,1,0,0,0,17,1369,0,11970642);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2697,314,"Large Crates of Synthetic Oil","Since original oil can be harvested only from a world with a long biological history, synthetic oil has become frequently produced in laboratories all over known space.",0,0,600000,600,0,1,0,0,1,0,0,0,17,1187,0,11970643);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2698,314,"Large Crates of Vitoc","The Vitoc booster has become more than a simple strategy by the Amarrians in controling their slaves. With the Vitoc method, slaves are injected with a toxic chemical substance that is fatal unless the recipient receives a constant supply of an antidote. The method first appeared a few centuries ago when the Amarrians started manning some of their space ships with slaves. As space crew the slaves had to be cajoled into doing complex, often independent work, making older methods of slave control undesirable. Although the more conventional ways of subduing slaves with force (actual or threat of) are still widely used in other forced labor areas, the Vitoc method has proven itself admirably for the fleet.",0,0,700000,700,0,1,0,0,1,0,0,0,17,1207,0,11970650);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2699,283,"Large Group of Civilians","A person following the pursuits of civil life.",0,0,500000,500,0,1,0,0,1,0,0,0,17,2536,0,11970655);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2700,283,"Large Group of Exotic Dancers","Exotic dancing is considered an art form, even though not everyone might agree. Exposing the flesh in public places may be perfectly acceptable within the Federation, but in the Amarr Empire it\'s considered a grave sin and a sign of serious deviancy.",0,0,400000,400,0,1,0,0,1,0,0,0,17,2543,0,11970656);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2701,283,"Large Group of Genetically Enhanced Livestock","Livestock are domestic animals raised for home use or for profit, whether it be for their meat or dairy products.  This particular breed of livestock has been genetically enhanced using the very latest technology.",0,0,1e+006,1000,0,1,0,0,1,0,0,0,17,2551,0,11970657);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2702,283,"Large Group of Homeless","In most societies there are those who, for various reasons, live a life considered below the living standards of the normal citizen.  These people are sometimes called tramps, beggars, drifters, vagabonds or homeless.  They are especially common in the ultra-capitalistic Caldari State, but are also found elsewhere in most parts of the galaxy.",0,0,60000,400,0,1,0,0,1,0,0,0,17,2542,0,11970658);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2703,283,"Large Group of Kameiras","An elite type of foot soldier, originally bred from Minmatar slaves by the Amarr Empire.  Raised from birth to become soldiers, they serve the Empire, Khanid Kingdom and Ammatar well, although always kept on a tight leash.",0,0,700000,700,0,1,0,0,1,0,0,0,17,2549,0,11970660);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2704,283,"Large Group of Marines","When war breaks out, the demand for transporting military personnel on site can exceed the grasp of the military organization. In these cases, the aid from non-military spacecrafts is often needed.",0,0,600000,600,0,1,0,0,1,0,0,0,17,2540,0,11970662);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2705,283,"Large Group of Militants","A combative character; aggressive, especially in the service of a cause.",0,0,600000,600,0,1,0,0,1,0,0,0,17,2540,0,11970663);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2706,283,"Large Group of Science Graduates","People that have recently graduated with a degree in science at an acknowledged university.",0,0,500000,500,0,1,0,0,1,0,0,0,17,2891,0,11970666);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2707,283,"Large Group of Slaves","Slavery has always been a questionable industry, favored by the Amarr Empire and detested by the Gallente Federation.",0,0,500000,500,0,1,0,0,1,0,0,0,17,2541,0,11970667);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2708,283,"Large Group of Tourists","The need for tasting other cultures and seeing new worlds is unquenchable among the well-off citizens of the universe.",0,0,500000,500,0,1,0,0,1,0,0,0,17,2539,0,11970670);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2709,283,"Large Group of VIPs","Very important people. Business executives, politicians, diplomats and game designers.",0,0,500000,500,0,1,0,0,1,0,0,0,17,2538,0,11970672);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2710,314,"Large Crates of Construction Blocks","Metal girders, plasteel concrete and fiber blocks are all very common construction material used around the universe.",0,0,1e+007,700,0,1,0,500,1,0,0,0,17,26,0,11970605);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2711,313,"Large Crates of Crystal Eggs","Crystal is a common feel-good booster, used and abused around the universe in abundance.",0,0,500000,500,0,1,0,5000,1,0,0,0,17,1195,0,11970607);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2712,314,"Large Crates of Drill Parts","These large containers are fitted with a password-protected security lock.  These particular containers are filled with spare parts needed to build a drill used for drilling through rock and ice sheets.",1171,0,900000,900,0,1,0,0,1,0,0,0,17,1171,0,11970609);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2713,314,"Large Crates of Electronic Parts","These basic elements of all electronic hardware are sought out by those who require spare parts in their hardware. Factories and manufacturers take these parts and assemble them into finished products, which are then sold on the market.",0,0,400000,400,0,1,0,750,1,0,0,0,17,1185,0,11970610);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2714,314,"Large Crates of Fertilizer","Fertilizer is particularly valued on agricultural worlds, where there is constant supply for all commodities that boost export value.",0,0,800000,800,0,1,0,0,1,0,0,0,17,1188,0,11970616);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2715,314,"Large Crates of Frozen Food","Frozen food is in high demand in many regions, especially on stations orbiting a non-habitable planet and a long way from an agricultural world.",0,0,400000,400,0,1,0,0,1,0,0,0,17,30,0,11970618);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2716,314,"Large Crates of Frozen Plant Seeds","Frozen plant seeds are in high demand in many regions, especially on stations orbiting a non-habitable planet.",0,0,40000,500,0,1,0,75,1,0,0,0,17,1200,0,11970619);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2717,314,"Large Crates of Garbage","Production waste can mean garbage to some but valuable resource material to others.",0,0,900000,900,0,1,0,0,1,0,0,0,17,1179,0,11970621);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2718,314,"Large Crates of Long-limb Roes","The eggs of the Hanging Long-limb are among the most sought after delicacies in fancy restaurants. The main reason why the roe of the Hanging Long-limb is so rare is because no one has succeeded in breeding the species outside their natural habitat.",0,0,400000,1000,0,1,0,2400,1,0,0,0,17,1406,0,11970626);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2719,314,"Large Crates of Raggy Dolls","Known across New Eden for their anatomical correctness and temperature sensitive, dynamic hair coloration, Raggy dolls are always in demand during gift-giving holidays.",0,0,400000,400,0,1,0,0,1,0,0,0,17,2992,0,11970637);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2720,314,"Large Crates of Rocket Fuel","Augmented and concentrated fuel used primarily for missile production.",0,0,50000,400,0,1,0,505,1,0,0,0,17,1359,0,11970639);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2721,314,"Large Crates of Tobacco","Tubular rolls of tobacco designed for smoking. The tube consists of finely shredded tobacco enclosed in a paper wrapper and is generally outfitted with a filter tip at the end.",0,0,2.5e+006,400,0,1,0,48,1,0,0,0,17,1370,0,11970645);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2722,314,"Large Crates of Transmitters","An electronic device that generates and amplifies a carrier wave, modulates it with a meaningful signal derived from speech or other sources, and radiates the resulting signal from an antenna.",0,0,650000,600,0,1,0,313,1,0,0,0,17,1364,0,11970648);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2723,314,"Large Crates of Viral Agent","The causative agent of an infectious disease, the viral agent is a parasite with a noncellular structure composed mainly of nucleic acid within a protein coat.",0,0,800000,800,0,1,0,0,1,0,0,0,17,1199,0,11970649);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2724,314,"Large Crates of Water","Water is one of the basic conditional elements of human survival. Most worlds have this compound in relative short supply and hence must rely on starship freight.",0,0,600000,600,0,1,0,0,1,0,0,0,17,1178,0,11970651);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2725,283,"Large Group of Cattle","TCattle are domestic animals raised for home use or for profit, whether it be for their meat or dairy products.",0,0,1e+006,1000,0,1,0,0,1,0,0,0,17,2854,0,11970653);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2726,283,"Large Group of Janitors","The janitor is the person who is in charge of keeping the premises of a building (as an apartment or office) clean, tends the heating system, and makes minor repairs.",0,0,100000,500,0,1,0,0,1,0,0,0,17,2536,0,11970659);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2727,283,"Large Group of Miners","Covered in a perpetual layer of grime and dust, these grizzled laborers seem out of place anywhere but deep underground on some lonely planet or boring through the core of a wandering asteroid.",0,0,500000,500,0,1,0,0,1,0,0,0,17,2536,0,11970664);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2728,283,"Large Group of Refugees","When wars and epidemics break out, people flee from their homes, forming massive temporary migrations.",0,0,400000,400,0,1,0,0,1,0,0,0,17,2542,0,11970665);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2729,314,"Crates of Consumer Electronics","Consumer electronics encompass a wide variety of individual goods, from entertainment media and personal computers to slave collars and children\'s toys.",0,0,40000,40,0,1,0,750,1,0,0,0,17,1362,0,11970518);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2730,314,"Crates of Enriched Uranium","Enriched Uranium is used in many kinds of manufacturing and as a fuel, making it a steady trade commodity. Enriched Uranium is generally manufactured by combining standard semiconductor PVD methods with ionic separation by means of mass spectrometry.",0,0,1e+006,70,0,1,0,500,1,0,0,0,17,29,0,11970525);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2731,314,"Crates of Silicon","As one of the most common elements in the universe, it’s no surprise that silicon has found its way into almost every aspect of manufacturing, resulting in a steady price and perpetual mining operations on most solid planets.",0,0,1e+006,50,0,1,0,500,1,0,0,0,17,1358,0,11970558);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2732,314,"Crates of Silicate Glass","Silicate glass is a common construction material, in constant demand throughout New Eden, whether in planetary structures or reinforced for use in space vessels.",0,0,1e+006,50,0,1,0,500,1,0,0,0,17,1190,0,11970557);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2733,937,"Schematic","Schematics define a set of machinery and industrial processes with which a planetary manufacturing facility can be configured in order to enable the facility to convert certain commodities into certain other commodities.",0,0,0,0,0,1,0,0,1,0,0,0,29,0,0,8837837);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2734,226,"Gallente Vexor Cruiser","The Vexor is a strong combat ship that is also geared to operate in a variety of other roles. The Vexor is especially useful for surveying in potentially hostile sectors as it can stay on duty for a very long time before having to return to base. Furthermore, it is well capable of defending itself against even concentrated attacks.",62,110,0,0,0,1,1,0,1,0,0,0,2,0,0,11914186);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2735,1045,"Infrastructure Hub Blueprint","",0,0,0,0.010000,0,1,0,5e+008,1,1356,0,0,9,0,0,9032761);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2736,857,"Warp Disruption Battery Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1344,0,0,9,0,0,8841708);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2737,1045,"Territorial Claim Unit Blueprint","",0,0,0,0.010000,0,1,0,2.5e+008,1,1356,0,0,9,0,0,9032763);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2738,1045,"Sovereignty Blockade Unit Blueprint","",0,0,0,0.010000,0,1,0,2.5e+008,1,1356,0,0,9,0,0,9032762);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2739,912,"Nanite Repair Paste Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1358,0,0,9,0,0,8974480);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2740,857,"Warp Scrambling Battery Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1344,0,0,9,0,0,8841709);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2741,858,"Stasis Webification Battery Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1344,0,0,9,0,0,8841703);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2742,1048,"Biochemical Silo Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1355,0,0,9,0,0,8841570);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2743,1048,"Catalyst Silo Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1355,0,0,9,0,0,8841573);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2744,1048,"Coupling Array Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1355,0,0,9,0,0,8841578);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2745,1048,"General Storage Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1355,0,0,9,0,0,8841586);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2746,1048,"Hazardous Chemical Silo Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1355,0,0,9,0,0,8841587);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2747,1048,"Hybrid Polymer Silo Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1355,0,0,9,0,0,8841589);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2748,1048,"Silo Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1355,0,0,9,0,0,8841611);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2749,1048,"Advanced Large Ship Assembly Array Blueprint","",0,0,0,0.010000,0,1,0,2.5e+008,1,1340,0,0,9,0,0,8841564);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2750,1048,"Capital Ship Maintenance Array Blueprint","",0,0,0,0.010000,0,1,0,5e+008,1,1341,0,0,9,0,0,8841572);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2751,1048,"Advanced Medium Ship Assembly Array Blueprint","",0,0,0,0.010000,0,1,0,1.5e+008,1,1340,0,0,9,0,0,8841565);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2752,1048,"Ship Maintenance Array Blueprint","",0,0,0,0.010000,0,1,0,1e+008,1,1341,0,0,9,0,0,8841610);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2753,1048,"Advanced Small Ship Assembly Array Blueprint","",0,0,0,0.010000,0,1,0,7.5e+007,1,1340,0,0,9,0,0,8841566);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2754,1048,"Ammunition Assembly Array Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1340,0,0,9,0,0,8841567);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2755,1048,"Ballistic Deflection Array Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1354,0,0,9,0,0,8841568);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2756,1048,"Capital Ship Assembly Array Blueprint","",0,0,0,0.010000,0,1,0,5e+008,1,1340,0,0,9,0,0,8841571);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2757,1048,"Explosion Dampening Array Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1354,0,0,9,0,0,8841585);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2758,1048,"Component Assembly Array Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1340,0,0,9,0,0,8841576);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2759,1048,"Heat Dissipation Array Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1354,0,0,9,0,0,8841588);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2760,1048,"Drone Assembly Array Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1340,0,0,9,0,0,8841582);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2761,1048,"Photon Scattering Array Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1354,0,0,9,0,0,8841605);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2762,1048,"Drug Lab Blueprint","",0,0,0,0.010000,0,1,0,7.5e+007,1,1340,0,0,9,0,0,8841583);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2763,1048,"Sensor Dampening Battery Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1344,0,0,9,0,0,8841609);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2764,1048,"Equipment Assembly Array Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1340,0,0,9,0,0,8841584);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2765,1048,"Intensive Refining Array Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1353,0,0,9,0,0,8841590);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2766,1048,"Large Ship Assembly Array Blueprint","",0,0,0,0.010000,0,1,0,1e+008,1,1340,0,0,9,0,0,8841596);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2767,1048,"Medium Intensive Refining Array Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1353,0,0,9,0,0,8841601);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2768,1048,"Medium Ship Assembly Array Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1340,0,0,9,0,0,8841603);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2769,1048,"Refining Array Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1353,0,0,9,0,0,8841608);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2770,1048,"Rapid Equipment Assembly Array Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1340,0,0,9,0,0,8841607);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2771,1048,"Small Ship Assembly Array Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1340,0,0,9,0,0,8841617);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2772,1048,"Subsystem Assembly Array Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1340,0,0,9,0,0,8841618);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2773,1048,"X-Large Ship Assembly Array Blueprint","",0,0,0,0.010000,0,1,0,3e+008,1,1340,0,0,9,0,0,8841620);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2774,841,"Amarr Control Tower Blueprint","",0,0,0,0.010000,0,1,0,5e+008,1,1339,0,0,9,0,0,8841520);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2775,841,"Amarr Control Tower Medium Blueprint","",0,0,0,0.010000,0,1,0,2.5e+008,1,1339,0,0,9,0,0,8841521);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2776,841,"Amarr Control Tower Small Blueprint","",0,0,0,0.010000,0,1,0,1.25e+008,1,1339,0,0,9,0,0,8841522);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2777,841,"Caldari Control Tower Blueprint","",0,0,0,0.010000,0,1,0,5e+008,1,1339,0,0,9,0,0,8841529);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2778,841,"Caldari Control Tower Medium Blueprint","",0,0,0,0.010000,0,1,0,2.5e+008,1,1339,0,0,9,0,0,8841530);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2779,841,"Caldari Control Tower Small Blueprint","",0,0,0,0.010000,0,1,0,1.25e+008,1,1339,0,0,9,0,0,8841531);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2780,841,"Gallente Control Tower Blueprint","",0,0,0,0.010000,0,1,0,5e+008,1,1339,0,0,9,0,0,8841541);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2781,841,"Gallente Control Tower Medium Blueprint","",0,0,0,0.010000,0,1,0,2.5e+008,1,1339,0,0,9,0,0,8841542);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2782,841,"Gallente Control Tower Small Blueprint","",0,0,0,0.010000,0,1,0,1.25e+008,1,1339,0,0,9,0,0,8841543);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2783,841,"Minmatar Control Tower Blueprint","",0,0,0,0.010000,0,1,0,5e+008,1,1339,0,0,9,0,0,8841547);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2784,841,"Minmatar Control Tower Medium Blueprint","",0,0,0,0.010000,0,1,0,2.5e+008,1,1339,0,0,9,0,0,8841548);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2785,841,"Minmatar Control Tower Small Blueprint","",0,0,0,0.010000,0,1,0,1.25e+008,1,1339,0,0,9,0,0,8841549);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2786,1048,"Moon Harvesting Array Blueprint","",0,0,0,0.010000,0,1,0,1e+008,1,1352,0,0,9,0,0,8841604);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2787,1048,"Corporate Hangar Array Blueprint","",0,0,0,0.010000,0,1,0,1e+008,1,1341,0,0,9,0,0,8841577);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2788,1048,"Cynosural Generator Array Blueprint","",0,0,0,0.010000,0,1,0,2.5e+008,1,1342,0,0,9,0,0,8841580);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2789,1048,"Cynosural System Jammer Blueprint","",0,0,0,0.010000,0,1,0,2.5e+008,1,1343,0,0,9,0,0,8841581);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2790,1048,"Biochemical Reactor Array Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1351,0,0,9,0,0,8841569);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2791,1048,"Complex Reactor Array Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1351,0,0,9,0,0,8841575);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2792,856,"Ion Field Projection Battery Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1344,0,0,9,0,0,8841629);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2793,1048,"Medium Biochemical Reactor Array Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1351,0,0,9,0,0,8841600);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2794,856,"Phase Inversion Battery Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1344,0,0,9,0,0,8841631);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2795,1048,"Polymer Reactor Array Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1351,0,0,9,0,0,8841606);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2796,856,"Spatial Destabilization Battery Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1344,0,0,9,0,0,8841632);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2797,1048,"Simple Reactor Array Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1351,0,0,9,0,0,8841612);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2798,856,"White Noise Generation Battery Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1344,0,0,9,0,0,8841633);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2799,860,"Energy Neutralizing Battery Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1345,0,0,9,0,0,8841636);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2800,1048,"Jump Bridge Blueprint","",0,0,0,0.010000,0,1,0,2.5e+008,1,1346,0,0,9,0,0,8841591);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2801,657,"Bane Javelin Torpedo","An ultra-heavy unguided nuclear missile. Slow and dumb but its sheer damage potential is simply staggering.


A modified version of the Bane Torpedo. It can reach higher velocity than the Bane Torpedo but needs to reduce the speed of the ship to compensate.     ",1348,300,1500,0.100000,0,5000,0,1.44073e+006,1,929,0.060000,0,8,1348,422,729904);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2802,166,"Bane Javelin Torpedo Blueprint","",1348,0,1,0.010000,0,1,0,1e+007,1,0,0,0,9,1348,422,729907);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2803,855,"Large Blaster Battery Blueprint","",0,0,0,0.010000,0,1,0,7.5e+007,1,1347,0,0,9,0,0,8841639);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2804,855,"Large Railgun Battery Blueprint","",0,0,0,0.010000,0,1,0,7.5e+007,1,1347,0,0,9,0,0,8841640);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2805,854,"Large Artillery Battery Blueprint","",0,0,0,0.010000,0,1,0,1e+008,1,1350,0,0,9,0,0,8841592);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2806,855,"Medium Blaster Battery Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1347,0,0,9,0,0,8841641);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2807,854,"Large AutoCannon Battery Blueprint","",0,0,0,0.010000,0,1,0,1e+008,1,1350,0,0,9,0,0,8841593);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2808,855,"Medium Railgun Battery Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1347,0,0,9,0,0,8841642);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2810,854,"Medium Artillery Battery Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1350,0,0,9,0,0,8841597);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2811,657,"Inferno Rage Torpedo","An ultra-heavy unguided plasma missile. Slow and dumb but its sheer damage potential is simply staggering.


This modified version of the Inferno Torpedo packs a considerably stronger punch, but as a result is heavier and slower. This makes it very effective against larger targets, but markedly less effective against smaller and more agile targets. The volatile nature of the warhead, and its powerful containment system, increase the ship\'s electromagnetic footprint when loaded and armed.",1347,5,1000,0.100000,0,5000,0,1.44073e+006,1,931,0.070000,0,8,1347,422,2941107);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2812,166,"Inferno Rage Torpedo Blueprint","",1351,0,1,0.010000,0,1,0,1e+007,1,0,0,0,9,1351,422,729916);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2813,855,"Small Blaster Battery Blueprint","",0,0,0,0.010000,0,1,0,2.5e+007,1,1347,0,0,9,0,0,8841655);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2814,854,"Medium AutoCannon Battery Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1350,0,0,9,0,0,8841598);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2815,855,"Small Railgun Battery Blueprint","",0,0,0,0.010000,0,1,0,2.5e+007,1,1347,0,0,9,0,0,8841656);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2816,854,"Small Artillery Battery Blueprint","",0,0,0,0.010000,0,1,0,2.5e+007,1,1350,0,0,9,0,0,8841613);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2817,648,"Gremlin Rage Rocket","A small rocket with an EMP warhead.


This modified version of the Gremlin Rocket packs a considerably stronger punch, but as a result is heavier and slower. This makes it very effective against larger targets, but markedly less effective against smaller and more agile targets. The volatile nature of the warhead, and its powerful containment system, increase the ship\'s electromagnetic footprint when loaded and armed.",1352,300,100,0.005000,0,5000,0,57320,1,930,0.060000,0,8,1352,422,2941098);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2818,166,"Gremlin Rage Rocket Blueprint","",1352,0,1,0.010000,0,1,0,1e+007,1,0,0,0,9,1352,422,729922);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2819,854,"Small AutoCannon Battery Blueprint","",0,0,0,0.010000,0,1,0,2.5e+007,1,1350,0,0,9,0,0,8841614);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2820,891,"Experimental Laboratory Blueprint","",0,0,0,0.010000,0,1,0,7.5e+007,1,1359,0,0,9,0,0,8841423);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2821,891,"Mobile Laboratory Blueprint","",0,0,0,0.010000,0,1,0,7.5e+007,1,1359,0,0,9,0,0,8841424);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2822,871,"Citadel Torpedo Battery Blueprint","",0,0,0,0.010000,0,1,0,1e+008,1,1349,0,0,9,0,0,8841574);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2823,871,"Cruise Missile Battery Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1349,0,0,9,0,0,8841579);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2824,871,"Torpedo Battery Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1349,0,0,9,0,0,8841619);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2825,853,"Small Pulse Laser Battery Blueprint","",0,0,0,0.010000,0,1,0,2.5e+007,1,1348,0,0,9,0,0,8841616);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2826,853,"Small Beam Laser Battery Blueprint","",0,0,0,0.010000,0,1,0,2.5e+007,1,1348,0,0,9,0,0,8841615);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2827,853,"Medium Pulse Laser Battery Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1348,0,0,9,0,0,8841602);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2828,853,"Medium Beam Laser Battery Blueprint","",0,0,0,0.010000,0,1,0,5e+007,1,1348,0,0,9,0,0,8841599);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2829,853,"Large Pulse Laser Battery Blueprint","",0,0,0,0.010000,0,1,0,1e+008,1,1348,0,0,9,0,0,8841595);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2830,853,"Large Beam Laser Battery Blueprint","",0,0,0,0.010000,0,1,0,1e+008,1,1348,0,0,9,0,0,8841594);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2831,226,"Serpentis Fortress","This gigantic station is one of the Serpentis military installations and a black jewel of the alliance between The Guardian Angels and The Serpentis Corporation. Even for its size, it has no commercial station services or docking bays to receive guests.",2356,8380,100000,1e+008,10000,1,8,0,0,0,0,0,2,0,0,8936288);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2832,226,"Blood Raider Fortress","This gigantic suprastructure is one of the military installations of the Blood Raiders pirate corporation. Even for its size, it has no commercial station services or docking bay to receive guests.",2359,8516,100000,1e+008,10000,1,4,0,0,0,0,0,2,0,0,8936313);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2834,324,"Utu","The Utu is a highly advanced drone platform specially commissioned for the 8th Alliance Tournament. While based on the Ishkur\'s design, this ship features design elements that go above and beyond the original blueprint.


In addition to revolutionary heat dispersion field projectors, the Utu is equipped with cutting-edge hardwired drone protocols and upgraded warp scrambling capability. Combined with the sturdy armor plating, these qualities make the Utu a powerful ally in any combat encounter.

10% bonus to drone damage per skill level and 10% bonus to Warp Scrambler and Warp Disruptor Range per level.


50% bonus to Small Hybrid Turret Optimal Range and Tracking and 50% reduction in the amount of heat damage absorbed by modules.",10005,39,1.216e+006,29500,165,1,8,220000,1,1366,0.070000,0,6,0,422,11772844);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2835,105,"Utu Blueprint","",0,0,0,0,0,1,0,0,1,0,0,0,9,1,0,9019804);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2836,358,"Adrestia","The Adrestia is a high-powered blaster platform specially commissioned for the 8th Alliance Tournament. While similar to its sister vessel the Deimos (on which its design was based), this ship nonetheless differs in some very important ways. Utilizing lightweight alloys and a prototype form of ion thruster, the Adrestia is capable of reaching truly mind-boggling speeds for a heavy assault vessel. While this makes it less sturdy than its predecessor, the lack of defensive plating is compensated for by state-of-the-art targeting systems, thoroughly optimized weapon hardpoints and upgraded warp scrambling capability. Don\'t let the lack of defense fool you; very few vessels out there can stand against the Adrestia toe to toe.



25% bonus to max velocity and 50% bonus to Medium Hybrid Turret falloff and tracking speed. 


20% Bonus to medium hybrid turret damage per level and 20% Bonus to warp disruptor and warp scrambler range per level.",10006,149,1.11e+007,112000,340,1,8,7.4e+006,1,1370,0.070000,0,6,0,422,11772847);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2837,106,"Adrestia Blueprint","",63,0,0,0.010000,0,1,0,7.4e+007,0,0,0,0,9,0,0,8975633);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2838,303,"Cerebral Accelerator","Cerebral accelerators are military-grade implants that significantly increase a new pilot\'s skill development. This technology is usually available only to naval officers, but CONCORD has authorized the release of a small number to particularly promising freelance capsuleers.

This implant primes the brain\'s neural pathways and hippocampus, making it much more receptive to intensive remapping. This allows new capsuleers to more rapidly absorb information of all kinds, and as a bonus also enhanced spatial processing abilities that are critical for weapons handling.

The only drawback to this implant is that capsuleer training renders it ineffective after a while; as such, it will cease to function for pilots who have been registered for more than 35 days.



+3 to all attributes; +20% Damage to Laser, Projectile and Hybrid weaponry; +20% Rate of Fire to Missile weaponry.",0,1,1,1,0,1,0,32768,1,0,0,0,20,10144,0,9077644);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2839,718,"Cerebral Accelerator Blueprint","",0,0,0,0.010000,0,1,0,0,1,0,0,0,9,21,0,9068346);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2845,1056,"Outuni Mesen","Subject: Prototype Nation Vessel (ID:Outuni Mesen)


 Battleship-class vessel. Primary roles are capacitor warfare and interdiction. Moderate microwarp velocity. Long range energy neutralizers. Long range warp disruption capabilities. Extreme long-range stasis webification support.


 Est. 120,000 civilian abductions from Outuni III and VI. The Mesen identifier suggests an oversight role amongst the other battleship-class prototypes, or alternatively, that it was created during the first phase of development.


Synopsis from ISHAEKA-0061. DED Special Operations.
Authorized for Capsuleer dissemination.
",2295,350,1.001e+007,100100,235,1,4,0,0,0,0.070000,31,11,0,0,9269214);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2848,1063,"Barren Extractor Control Unit","Finding desired liquids on hostile worlds can be almost as challenging a task as extracting it from the unforgiving environment, which often entails drilling kilometers below the surface or condensing fluids from the upper atmosphere. Once the liquids are discovered, the facility itself begins the relatively simple task of separating it from the ambient plasma interference, scalding magma streams, or potentially infectious indigenous bacteria. A surprising amount of valuable liquids can be extracted from hostile worlds, but only if the equipment is properly calibrated and carefully maintained.",4544,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,9274172);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2850,306,"Suspicious Ship Wreck","You surmise that with some salvaging equipment there is still something of value to be had from this wreck.",3115,14,10000,27500,2700,1,0,0,0,0,0,0,11,0,0,9236267);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2851,314,"Incriminating Evidence","This evidence proves beyond the shadow of a doubt that foul play was involved.",0,0,5,1,0,1,0,0,1,0,0,0,17,2886,0,9236285);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2852,226,"Sansha Cynosural Field","A cynosural field, also known colloquially as a \"cyno\", is a cosmic anomaly that acts as a pseudo-gravity well. With the correct calibration information, interstellar jump drives can lock onto the field and create a portal into the destination system.",2742,1274,1,0,0,1,0,0,0,0,0,0,2,0,0,9236453);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2853,314,"Salvaged Electronics","These ship parts are old but functional.",0,0,10,20,0,1,0,0,1,0,0,0,17,3265,0,9236617);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2854,306,"Cloaked Cache","Rigged with a localized cloaking field, this small container is hidden from sensors while activated.",2431,14,10000,27500,2700,1,0,0,0,0,0,0,11,0,0,9236624);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2855,1056,"Intaki Colliculus","Subject: Prototype Nation Vessel (ID:Intaki Colliculus)


 Battleship-class vessel. Primary role is remote logistics support. Medium range shield transfer capabilities. Low microwarp velocity. Defensive systems have been significantly enhanced.


 There were no reported civilian abductions from the invasion of Intaki  IV. The Intaki identifier is yet further evidence supporting the theory that not all abductees were accounted for.  The Colliculus identifier suggests the vessel plays a central role in the integration of various data throughout the Nation’s greater network.


Synopsis from ISHAEKA-0067. DED Special Operations.
Authorized for Capsuleer dissemination.
",2295,350,1.001e+007,100100,235,1,4,0,0,0,0.070000,31,11,0,0,9269236);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2859,1054,"Romi Thalamus","Subject: Prototype Nation Vessel (ID:Romi Thalamus)


  Cruiser-class vessel. Primary role is damage dealing. Moderate microwarp velocity.


 There were no reported civilian abductions from the invasion of Romi III. The Romi identifier is yet further evidence that unreported abductees may have been incorporated into these new vessel prototypes, and into the Nation as a whole. The Thalamus identifier suggests a unifying role between the cruiser-class prototypes and other hull classes, similar to the Arnon Epithalmus. Notable is the higher number of known cruiser-class vessels, and that the identifiers of each belong to the forebrain. This pattern highlights a structural shift away from battleship-led squadrons, or at the least, an equality of function and responsibility between battleship and cruiser variants.


Synopsis from ISHAEKA-0051. DED Special Operations.
Authorized for Capsuleer dissemination.
",1236,150,1.001e+007,100100,235,1,4,0,0,0,0.070000,31,11,0,0,9269183);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2860,306,"The Seven Holding Cells","This temporary structure is made to house The Seven\'s hostages until they are ready to be transported to a more secure location.",2518,416,10000,1200,1000,1,0,0,1,0,0,0,11,0,0,9237579);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2861,314,"Crate of Manportable Electromagnetic Pulse Weapons","These EM beam weapons have been custom fitted to detect and eradicate specific nanotechnologies. Normally, these EMP devices are used by special operations personnel during covert operations. They are placed in proximity to the enemy’s defense grid and used to “short out” any nearby electronics, thus creating a hole in the defense grid such that conventional forces can then move through unimpeded by sentry grids, security bots, and other lethal defensive systems. The devices themselves are approximately the size of a large rucksack and can be both emplaced and operated by a single trained individual. ",0,0,250,250,0,1,0,0,1,0,0,0,17,1362,0,9242160);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2862,314,"Special Forces Weapons and Equipment ","The weapons and equipment containers hold a wide variety of small arms and other equipment currently in use by the Caldari Navy Special Forces, much of it designed specifically for use in maritime environments. Some of the items that can be found in a typical container are long range sniper rifles, target designation lasers, silenced pistols, high tech diving equipment, limpet mines, covert communications gear, and individual diver propulsion devices. This equipment, as you might guess, is extremely valuable and cannot be found outside the armories of the Caldari Navy, with the exception of the very small quantities that have found their way onto the black market. ",0,0,25,25,0,1,0,0,1,0,0,0,17,1366,0,9242161);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2863,28,"Primae","The Primae is a repurposed ORE design intended to ease the task of extracting resources from planetbound environments. Initially devised as a deep space salvage vessel for large-scale ore retrieval from destroyed ORE fleets in pirate-occupied areas, its previous incarnation was made all but obsolete by the arrival of capsuleers on the interstellar scene. Realizing that the ship could, with a few minor modifications, be made into an efficient resource harvesting aid, ORE wasted no time in revamping the design.

A low signature radius (a holdover from its earlier manifestation) adds a layer of defense to the Primae\'s already decent plating. In addition, the ship\'s two large bays have been re-engineered to hold equipment for planetside resource extraction and processed materials, making it an especially useful complement to any planetside harvesting endeavor.",10013,450,1.5e+007,270000,100,1,8,0,1,1390,0.070000,0,6,0,0,11791666);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2864,108,"Primae Blueprint","",334,0,0,0.010000,0,1,0,1e+007,1,0,0,0,9,0,0,9058367);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2865,55,"1200mm Artillery Cannon II","One of the most powerful projectile cannons a battleship can equip. 


Carbonized Lead, Depleted Uranium, EMP, Fusion, Nuclear, Phased Plasma, Proton, Titanium Sabot, Quake, Tremor.",11277,2000,750,20,1,1,0,1.98754e+006,1,579,0.060000,0,7,379,422,13157411);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2866,135,"1200mm Artillery Cannon II Blueprint","",380,0,0,0.010000,0,1,0,1e+007,1,298,0,0,9,379,422,729934);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2867,1041,"Broadcast Node","By integrating transcranial microcontrollers into a circuit made from synthetic synapses, the broadcast node is able to communicate directly with various station functions and with negligible signal loss and latency. The addition of computerized guidance systems, each running independent navigation system software routines, allows a single node to coordinate starship docking procedures, drone operations, and even station defenses.",0,0,0,100,0,1,0,0,1,1337,0,0,43,10073,0,9034952);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2868,1041,"Integrity Response Drones","Hull breaches are a constant, serious threat during space travel, as well as a dangerous reality to orbital stations, which are too massive to avoid incoming objects. Integrity response drones help mitigate that threat by providing the automated, immediate application of sealants to any detected impact or pressure fracture in the structure they patrol.",0,0,0,100,0,1,0,0,1,1337,0,0,43,10074,0,9034955);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2869,1041,"Nano-Factory","Only the highly advanced Ukomi superconductor can be rendered small enough for use in nano-factories, microscopic devices programmed to absorb and recycle ambient material into useful matter. Each factory is built from reactive metals, ensuring that they interact properly – or not at all – with their environment, while a mote of industrial explosive automatically destroys them when they have completed their task.",0,0,0,100,0,1,0,0,1,1337,0,0,43,10075,0,9034958);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2870,1041,"Organic Mortar Applicators","While nanites are ideal for many forms of construction, sealing joints between large structural bulkheads is a job best left to organic mortar, a thick gel that actively permeates every microscopic gap between two parts. Due to the aggressive nature of the genetically engineered bacteria that intelligently guides into place the hardening condensate material, this paste is extremely hazardous to humans and must be applied by robots.",0,0,0,100,0,1,0,0,1,1337,0,0,43,10076,0,9034961);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2871,1041,"Recursive Computing Module","Not all automated functions are delicate or complicated enough to warrant advanced computer hardware; relatively mundane tasks are best when assigned to an RCM bank. These sturdy, reliable processing units are able to effectively handle most of the day-to-day operations of stations, starships, and stargates.",0,0,0,100,0,1,0,0,1,1337,0,0,43,10071,0,9034964);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2872,1041,"Self-Harmonizing Power Core","Camera drones diligently monitor temperature, radioactivity and electrical output of these advanced nuclear reactions. This allows instant adjustments that result in maximum efficiency. With such advanced automation, no human attention is required whatsoever.",0,0,0,100,0,1,0,0,1,1337,0,0,43,10078,0,9437565);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2873,55,"125mm Gatling AutoCannon II","This multi-barrel autocannon is designed for skirmish warfare. 


Carbonized Lead, Depleted Uranium, EMP, Fusion, Nuclear, Phased Plasma, Proton, Titanium Sabot, Barrage, Hail.",11303,2000,750,5,0.500000,1,0,35400,1,574,0.060000,0,7,387,422,13157412);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2874,135,"125mm Gatling AutoCannon II Blueprint","",393,0,0,0.010000,0,1,0,1e+007,1,296,0,0,9,387,422,729940);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2875,1041,"Sterile Conduits","Sustaining diverse populations of station inhabitants – many of whom come from different worlds with different ecologies – was a medical nightmare until the development of sterile conduits. Each length of flexible, self-repairing tube is powered by breaking down the chemical energy in the water they convey, which itself is laced with smart vaccines able to identify and destroy almost any known antigen.",0,0,0,100,0,1,0,0,1,1337,0,0,43,10079,0,9034970);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2876,1041,"Wetware Mainframe","So advanced and energy-demanding are wetware mainframes that they require vehicle-scale power cores and the constant attention of maintenance personnel. When operating at peak performance levels, nothing in New Eden can match the raw computing power of these machines, from calculating warp coordinates to administrating the core functions of an entire space station.",0,0,0,100,0,1,0,0,1,1337,0,0,43,10077,0,9034973);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2877,875,"Federation Freighter Vessel","The large navy forces of the Empires regularly use freighters to transport a wide variety of military items and personnel en masse.  Such vulnerable ships are usually heavily guarded as they traverse the space lanes.",2739,600,1.175e+009,1.755e+007,750000,1,8,0,0,0,0,0,11,0,0,9054288);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2878,927,"Federation Industrial Vessel","Industrials are a common sight in the universe of EVE, connecting supply points to each other. Convoys usually have armed escorts, so attacking them is risky.",328,553,1.175e+007,275000,6000,1,8,0,0,0,0,0,11,0,0,9054330);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2879,875,"Imperial Freighter Vessel","The large navy forces of the Empires regularly use freighters to transport a wide variety of military items and personnel en masse.  Such vulnerable ships are usually heavily guarded as they traverse the space lanes.",2738,900,1.125e+009,1.85e+007,735000,1,4,0,0,0,0,0,11,0,0,9054379);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2880,314,"Unknown Dead","This contingent of Federation pilots and soldier went missing during the first Caldari Gallente war. They’ve been preserved by the cold but they are still in a delicate state, and must be handled with care.",0,0,80,1,0,1,0,0,1,0,0,0,17,2855,0,9055084);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2881,55,"150mm Light AutoCannon II","A simple but effective close combat autocannon. 


Carbonized Lead, Depleted Uranium, EMP, Fusion, Nuclear, Phased Plasma, Proton, Titanium Sabot, Barrage, Hail.",11305,20,20,5,0.400000,1,0,74212,1,574,0.060000,0,7,387,422,13157413);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2882,875,"State Freighter Vessel","The large navy forces of the Empires regularly use freighters to transport a wide variety of military items and personnel en masse.  Such vulnerable ships are usually heavily guarded as they traverse the space lanes.",2740,800,1.2e+009,1.625e+007,785000,1,1,0,0,0,0,0,11,0,0,9054463);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2883,927,"State Industrial Vessel","Industrials are a common sight in the universe of EVE, connecting supply points to each other. Convoys usually have armed escorts, so attacking them is risky.",52,315,1.35e+007,270000,5250,1,1,0,0,0,0,0,11,0,0,9054504);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2884,927,"Republic Industrial Vessel","Industrials are a common sight in the universe of EVE, connecting supply points to each other. Convoys usually have armed escorts, so attacking them is risky.",309,660,1.25e+007,255000,5625,1,2,0,0,0,0,0,11,0,0,9054546);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2885,927,"Imperial Industrial Vessel","Industrials are a common sight in the universe of EVE, connecting supply points to each other. Convoys usually have armed escorts, so attacking them is risky.",1064,400,1.35e+007,260000,5100,1,4,0,0,0,0,0,11,0,0,9054588);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2886,306,"Tomb of the Unknown Soldiers","Years ago this was the site of a major firefight. The dead still litter its halls.",2898,2617,10000,27500,2700,1,0,0,0,0,0,0,11,0,0,9054638);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2887,526,"Gallente Admiral’s Corpse","These are the remains of a Federation admiral. A Mannar in her mid-forties, this woman’s body shows signs of extensive modification typical to capsuleers. This is probably not the first time she has been killed in action.",0,0,80,1,0,1,0,0,1,0,0,0,17,2855,0,9068420);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2888,314,"Acceleration Gate Authentication Matrix","This device handles timestamps and user ID validation for acceleration gates. If this part is missing or otherwise broke, the gate will refuse to activate. ",0,0,50,1,0,1,0,0,1,0,0,0,17,2038,0,9055804);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2889,55,"200mm AutoCannon II","The 200mm is a powerful autocannon that can smash apart most lightly armored frigates with ease. 


Carbonized Lead, Depleted Uranium, EMP, Fusion, Nuclear, Phased Plasma, Proton, Titanium Sabot, Barrage, Hail.",11307,20,15,5,0.300000,1,0,109744,1,574,0.060000,0,7,387,422,13157414);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2890,135,"200mm AutoCannon II Blueprint","",391,0,0,0.010000,0,1,0,1e+007,1,296,0,0,9,387,422,729949);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2891,306,"Amarr Battleship Wreckage","May contain something worthwhile.",3115,14,10000,27500,2700,1,0,0,0,0,0,0,11,3115,0,9058155);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2892,306,"Amarrian Battleship Wreckage","May contain something worthwhile.",3115,14,10000,27500,2700,1,0,0,0,0,0,0,11,3115,0,9058172);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2893,314,"Damning Evidence","This document could get a lot of people into a lot of trouble. ",0,0,1,1,0,1,0,150,1,0,0,0,17,1192,0,9068422);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2894,227,"Invisible Cloud","",10026,1,0,0,0,1,0,0,0,0,0,0,2,0,0,9058251);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2895,306,"Asteroid Pirate Station","This is where the pirates keep their hostages and other evidence while they wait to be disposed of in the acid cloud.",2898,2617,10000,27500,2700,1,0,0,0,0,0,0,11,0,0,9096655);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2896,319,"Patient Zero","All that remains of the mining station is a twisted, nightmarish husk that has been transformed into a rogue drone base.",2410,5858,100000,1e+008,10000,1,0,0,0,0,0,0,11,0,0,9097596);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2897,55,"220mm Vulcan AutoCannon II","The 220mm multi-barrel autocannon is designed for skirmish warfare. 


Carbonized Lead, Depleted Uranium, EMP, Fusion, Nuclear, Phased Plasma, Proton, Titanium Sabot, Barrage, Hail.",11159,20,12,10,2,1,0,305136,1,575,0.060000,0,7,386,422,13157415);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2898,135,"220mm Vulcan AutoCannon II Blueprint","",387,0,0,0.010000,0,1,0,1e+007,1,297,0,0,9,387,422,729955);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2899,314,"Custom Circuitry","While drone AI is easily replicated, certain behaviors require custom programming.  These units seem to have been designed for generally poor   combat performance.",0,0,1,0.100000,0,1,0,8e+006,1,0,0,0,17,3265,0,9223090);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2900,314,"Recovered Data Core","This starship data core contains a detailed log of all the vessel\'s activities.",0,0,1,1,0,1,0,1,1,0,0,0,17,2038,0,9223218);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2901,306,"Science Vessel Wreck","The remnants of a science ship lost recently.",3118,14,10000,27500,2700,1,0,0,0,0,0,0,11,0,0,9223224);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2902,319,"LCS Acceleration Gate","This acceleration gate has been locked down and is not usable by the general public.",2341,4553,100000,1e+008,10000,1,0,0,0,0,0,0,11,0,0,9229172);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2903,952,"Manager\'s Station","This upscale estate probably serves as a swank bachelor pad when the manager isn\'t entertaining clients.",1712,918,10000,27500,2700,1,0,0,0,0,0,14,11,0,0,9223456);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2904,314,"Quantum Entanglement","This heavy metal rock opera band was made famous by their first album\'s cover, which depicted two naked individuals engaging in sexual intercourse while floating in space without spacesuits. Gallente politicians tried to have the album, called \"Unprotected,\" banned. Not because of the adult content, they claimed, but because it promoted unsafe extravehicular activities.",0,0,400,10,0,1,0,0,1,0,0,0,17,1204,0,9223493);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2905,55,"250mm Light Artillery Cannon II","This artillery is one of the most powerful weapons that can be mounted on a frigate. 


Carbonized Lead, Depleted Uranium, EMP, Fusion, Nuclear, Phased Plasma, Proton, Titanium Sabot, Quake, Tremor.",11285,20,4,5,0.100000,1,0,132664,1,577,0.060000,0,7,389,422,13157416);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2906,135,"250mm Light Artillery Cannon II Blueprint","",390,0,0,0.010000,0,1,0,1e+007,1,296,0,0,9,389,422,729961);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2907,1053,"Schmaeel Medulla","Subject: Prototype Nation Vessel (ID: Schmaeel Medulla)


 Frigate-class vessel. Primary roles are interdiction and frigate support. Fastest microwarp velocity of all known Nation frigate prototypes. Long range warp disruption capabilities. Long range stasis webifier support. Limited weapons systems.


 Est. 1,000,000 civilian abductions from Schmaeel VI. The Medulla identifier suggests a limited role in the larger Nation hierarchy, and that the Schmaeel captives are tasked with more basic, mechanical responsibilities.


Synopsis from ISHAEKA-0045. DED Special Operations.
Authorized for Capsuleer dissemination.
",1237,31,2e+006,20000,235,1,4,0,0,0,0,31,11,0,0,9269179);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2909,1053,"Niarja Myelen","Subject: Prototype Nation Vessel (ID: Niarja Myelen)


 Frigate-class vessel. Primary role is long range ECM support and medium-range energy warfare. Moderate microwarp velocity. No known weapons systems.


 Est. 70,000 civilian abductions from Niarja VII. The Myelen   identifier suggests a developmental state. Other, more advanced Nation prototypes may have originated from this design.


Synopsis from ISHAEKA-0039. DED Special Operations.
Authorized for Capsuleer dissemination.
",1238,31,2e+006,20000,235,1,4,0,0,0,0,31,11,0,0,9269166);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2910,226,"Gallente Passenger Liner Wreckage","This ship has seen better days. Parts of it are missing, looking as though the ship was torn apart. There are no signs of life inside, though. ",3087,1,0,0,0,1,0,0,0,0,0,0,2,0,0,9224845);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2911,306,"Gallente Passenger Liner Damaged","This passenger liner has seen better days, but it’s still operational. The ship is anchored to its spot with large, magnetic beacons around the bottom of its hull.",3087,1000,1e+006,1e+008,8850,1,0,0,0,0,0,0,11,0,0,9280817);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2912,526,"Minmatar Pilot\'s Corpse","Some Minmatar feel the Republic\'s status quo is not sufficient to avenge victims of Amarrian enslavement, nor to liberating those still trapped under Imperial rule. This unfortunate figure learned a terminal lesson in the necessities of political balance.",0,0,80,1,0,1,0,0,1,0,0,0,17,2855,0,9224851);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2913,55,"425mm AutoCannon II","The 425mm is a behemoth that will inflict severe damage on most cruisers and frigates in short-range battles. 


Carbonized Lead, Depleted Uranium, EMP, Fusion, Nuclear, Phased Plasma, Proton, Titanium Sabot, Barrage, Hail.",11301,20,8,10,1.500000,1,0,373210,1,575,0.060000,0,7,386,422,13157417);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2914,135,"425mm AutoCannon II Blueprint","",386,0,0,0.010000,0,1,0,1e+007,1,297,0,0,9,386,422,729967);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2915,319,"Auxiliary Academic Campus","A standard, customizable, space-faring  structure designed to be easily moved and deployed.  This one has been configured for early childhood education.",2372,1045,100000,1e+008,10000,1,1,0,0,0,0,0,11,0,0,9224970);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2916,706,"Rogue Minmatar","This loose cannon is piloting an experimental stealth ship and has begun a personal war against the Amarr Empire.",3355,350,1.9e+007,1.9e+007,120,1,2,0,0,0,0.070000,0,11,0,0,9225012);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2917,314,"Survivors","These rattled individuals move with languid motions. It looks like some of them have gone weeks without food.",0,0,50,50,0,1,0,0,1,0,0,0,17,2545,0,9225213);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2918,306,"Cell Block D","A maximum-security prison block and run by the Gallente Federation. ",2458,911,1e+006,1150,8850,1,0,0,0,0,0,0,11,0,0,9225336);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2919,283,"Caldari Operative","An operative of the Caldari State.",0,0,60,0.100000,0,1,0,0,1,0,0,0,17,2538,0,9225452);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2921,55,"650mm Artillery Cannon II","A powerful long-range cannon. One of the most damaging weapons mountable on a cruiser. 


Carbonized Lead, Depleted Uranium, EMP, Fusion, Nuclear, Phased Plasma, Proton, Titanium Sabot, Quake, Tremor.",11281,200,125,10,0.500000,1,0,436976,1,578,0.060000,0,7,384,422,13157418);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2922,135,"650mm Artillery Cannon II Blueprint","",385,0,0,0.010000,0,1,0,1e+007,1,297,0,0,9,384,422,729973);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2926,226,"Serpentis Slave Transport","A Serpentis cargo ship loaded with people.",328,553,100000,1e+008,10000,1,8,0,0,0,0,0,2,0,0,9228327);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2927,226,"LCO Deadspace Particle Accelerator","The science allowed by zero gravity can be as mind-boggling as it is beautiful, as demonstrated by this particle accelerating superstructure.",2069,4553,100000,1e+008,10000,1,0,0,0,0,0,0,2,0,0,9236362);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2928,226,"LCO Asteroid Colony","Highly vulnerable, but economically extremely feasible, asteroid factories are one of the major boons of the expanding space industry.",1991,4007,100000,1e+008,10000,1,0,0,0,0,0,0,2,0,0,9228607);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2929,55,"800mm Repeating Artillery II","A four-barreled, intermediate-range, powerful cannon capable of causing tremendous damage. 


Carbonized Lead, Depleted Uranium, EMP, Fusion, Nuclear, Phased Plasma, Proton, Titanium Sabot, Barrage, Hail.",11295,200,75,20,3,1,0,1.48478e+006,1,576,0.060000,0,7,381,422,13157604);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2930,314,"Crate of Special Forces Weapons and Equipment","The weapons and equipment containers hold a wide variety of small arms and other equipment currently in use by the Caldari Navy Special Forces, much of it designed specifically for use in maritime environments. Some of the items that can be found in a typical container are long range sniper rifles, target designation lasers, silenced pistols, high tech diving equipment, limpet mines, covert communications gear, and individual diver propulsion devices. This equipment, as you might guess, is extremely valuable and cannot be found outside the armories of the Caldari Navy, with the exception of the very small quantities that have found their way onto the black market. ",0,0,250,250,0,1,0,0,1,0,0,0,17,1366,0,9242162);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2931,1054,"Mara Paleo","Subject: Prototype Nation Vessel (ID: Mara Paleo)


 Cruiser-class vessel. Primary role is long range remote shield transfer. Vessel has been enhanced with significant microwarp velocity to aid in this responsibility. Reconfiguring the vessel for a logistics role has notably weakened its defensive systems, however. 


 Est. 15,000 civilian abductions from Mara IV. The Paleo identifier suggests a role that is fundamental in nature, which would be congruent with its function as logistics support. 


Synopsis from ISHAEKA-0057. DED Special Operations.
Authorized for Capsuleer dissemination.
",1236,150,1.001e+007,100100,235,1,4,0,0,0,0.070000,31,11,0,0,9269198);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2932,1056,"Ostingele Tectum","Subject: Prototype Nation Vessel (ID:Ostingele Tectum)


 Battleship-class vessel. The third most powerful vessel amongst the new Nation prototypes in terms of potential damage output. Moderate microwarp velocity. Defensive systems have been significantly enhanced.


 Est. 2,000,000 civilian abductions from Ostingele IV. The Tectum identifier suggests a basic input-response role, with little to no shared computing power required for standard operations. Probable relations to the Deltole Tegmentum prototype.


Synopsis from ISHAEKA-0063. DED Special Operations.
Authorized for Capsuleer dissemination.
",2295,350,1.001e+007,100100,235,1,4,0,0,0,0.070000,31,11,0,0,9269228);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2933,1056,"Deltole Tegmentum","Subject: Prototype Nation Vessel (ID:Deltole Tegmentum)


 Battleship-class vessel. Primary roles are strong offensive power, target painting energy warfare and long range interdiction. The second most powerful vessel amongst the new Nation prototypes in terms of potential damage output. Moderate microwarp velocity. Long range warp disruption capabilities. Long range target painting. Short range capacitor neutralization.


 Est. 450,000 civilian abductions from Deltole I. The Tegmentum identifier suggests that this vessel serves a foundational role for the other battleship-class variants, most likely in terms of design origin. The multitude of tactical capabilities present in this vessel’s design lend support to the theory that it was a test bed for a variety of Nation developments ahead of their applications in other vessel types.


Synopsis from ISHAEKA-0065. DED Special Operations.
Authorized for Capsuleer dissemination.
",2295,350,1.001e+007,100100,235,1,4,0,0,0,0.070000,31,11,0,0,9269233);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2934,314,"Counterfeit Voluval Tattoo Chemicals","A complex chemical formula for use in a traditional Minmatar ceremony. This batch is labeled with Amarr markings.",0,0,20,20,0,1,0,0,1,0,0,0,17,1207,0,9230320);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2935,1056,"Yulai Crus Cerebi","Subject: Prototype Nation Vessel (ID:Yulai Crus Cerebi)


 Battleship-class vessel. Primary role is long-range sniping support. Low microwarp velocity. Vessel will attempt to establish orbit ranges in excess of 100km. 


 Est. 430,000 civilian abductions from Yulai. The Crus Cerebi identifier suggests a connective role between this vessel and others, possibly even non-Nation crafts. Attempts at short-wave information capture have demonstrated the futility of further efforts. Although the data passing through this vessel and other conduit-like variants can be intercepted, the encryption is still years away from being broken.


Synopsis from ISHAEKA-0069. DED Special Operations.
Authorized for Capsuleer dissemination.
",2295,350,1.001e+007,100100,235,1,4,0,0,0,0.070000,31,11,0,0,9269238);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2936,1054,"Auga Hypophysis","Subject: Prototype Nation Vessel (ID: Auga Hypophysis)


 Cruiser-class vessel. Primary damage dealer amongst cruiser prototypes. Limited interdiction. Short range warp scrambling capabilities. Short range stasis webification support.


 Est. 300,000 civilian abductions from Auga II. The Hypophysis identifier suggests either a coordinating role between this vessel and other cruiser-class variants, or perhaps a regulatory role similar to the Tama Cerebellum.


Synopsis from ISHAEKA-0053. DED Special Operations.
Authorized for Capsuleer dissemination.
",1236,150,1.001e+007,100100,235,1,4,0,0,0,0.070000,31,11,0,0,9269189);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2937,55,"Dual 180mm AutoCannon II","This dual 180mm autocannon is a simple but effective close combat weapon. 


Carbonized Lead, Depleted Uranium, EMP, Fusion, Nuclear, Phased Plasma, Proton, Titanium Sabot, Barrage, Hail.",11297,20,12.500000,10,2.500000,1,0,220508,1,575,0.060000,0,7,386,422,13157621);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2938,135,"Dual 180mm AutoCannon II Blueprint","",388,0,0,0.010000,0,1,0,1e+007,1,297,0,0,9,386,422,729982);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2939,1053,"Tama Cerebellum","Subject: Prototype Nation Vessel (ID: Tama Cerebellum)


  Frigate-class vessel. Primary role is to support Nation vessels against larger hulls. Moderate microwarp velocity. Long range torpedo fire support. Prioritizes large vessels as targets.


  Est. 100,000 civilian abductions from Tama V. The Cerebellum identifier suggests a regulatory role amongst other frigate-class variants.


Synopsis from ISHAEKA-0037. DED Special Operations.
Authorized for Capsuleer dissemination.
",1238,31,2e+006,20000,235,1,4,0,0,0,0,31,11,0,0,9269152);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2942,283,"Captured CEO","Life isn\'t always comfortable when you\'re at the top, particularly in the Caldari State. Guristas will ransom you, other corporations will backstab you, and the moment someone can buy the rug out from underneath you, they will. With all the ISK that comes with these responsibilities, most CEOs can buy enough happiness to forget about these troubles. Forgetting, though, isn\'t always the best investment. ",0,0,130,3,0,1,0,1000,1,0,0,0,17,2538,0,9235467);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2943,314,"Hybrid Slaver Hounds","Hybrid slaver hounds have been genetically engineered by Amarr veterinary scientists as variants of the original breed. These animals are designed specifically to live and work in the harshest environments, including deserts, swamps, mountains, frozen tundra, and other extreme locations. These variations are typically easy to differentiate from the original breed, in that they can be much larger and have fur colorations that are genetically tailored to blend in to their environments. ",0,0,28,20,0,1,0,0,1,0,0,0,17,1180,0,9242163);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2944,314,"Kennel of Hybrid Slaver Hounds","Hybrid slaver hounds have been genetically engineered by Amarr veterinary scientists as variants of the original breed. These animals are designed specifically to live and work in the harshest environments, including deserts, swamps, mountains, frozen tundra, and other extreme locations. These variations are typically easy to differentiate from the original breed, in that they can be much larger and have fur colorations that are genetically tailored to blend in to their environments. ",0,0,280,200,0,1,0,0,1,0,0,0,17,1180,0,9242164);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2945,55,"Dual 425mm AutoCannon II","Combines the damage output of two 425mm intermediate-range autocannons. 


Carbonized Lead, Depleted Uranium, EMP, Fusion, Nuclear, Phased Plasma, Proton, Titanium Sabot, Barrage, Hail.",11291,200,200,20,5,1,0,605200,1,576,0.060000,0,7,381,422,13157611);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2946,135,"Dual 425mm AutoCannon II Blueprint","",383,0,0,0.010000,0,1,0,1e+007,1,298,0,0,9,381,422,729988);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2947,1010,"Compact Shade Torpedo","Representing the latest in miniaturization technology, Compact Citadel Torpedoes are designed specifically to be used by Fighter Bombers.


Fitted with a graviton pulse generator, this weapon causes massive damage as it overwhelms ships\' internal structures, tearing bulkheads and armor plating apart with frightening ease.",3940,300,1500,0.300000,0,100,0,300000,0,0,0.070000,0,8,1346,422,9441606);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2948,1023,"Shadow","Subject: Prototype Nation Vessel (ID:Shadow)


 Fighter bomber-class vessel. Moderate microwarp velocity. Enhanced weapons systems. Reverse-engineering has been made possible through salvage of specific Sansha’s Nation vessels.


 At this initial stage conclusions are hard to form, but early indications from the recovery of three individual bomber pilots – all of them heavily augmented – strongly indicates that these crew members are the same planetary abductees found in other Nation prototype vessels. Cross-referencing recovered DNA with missing persons reports has so far revealed little, though even at this stage the origin of these pilots is in little doubt.


Synopsis from ISHAEKA-0107. DED Special Operations.
Authorized for Capsuleer dissemination.
",10039,35,12000,5000,0,1,1,2.54258e+007,1,0,0.070000,0,18,0,422,10683244);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2949,176,"Shadow Blueprint","",1114,0,0,0.010000,0,1,0,3e+008,1,0,0,0,9,0,0,11896423);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2950,1054,"Lirsautton Parichaya","Subject: Prototype Nation Vessel (ID:Lirsautton Parichaya)


 Fighter bomber-class vessel. Moderate microwarp velocity. Enhanced weapons systems. 


 Est. 1,905,000 civilian abductions from Lirsautton V. The Parichaya identifier is unclear: it has no known etymological origins or direct translations.


Synopsis from ISHAEKA-0071. DED Special Operations.
Authorized for Capsuleer dissemination.
",10039,35,12000,5000,1200,1,4,0,0,0,0.070000,31,11,0,0,9275251);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2951,314,"Large Crate of Improved Inertial Compensation Systems","The internal components of smaller Minmatar ships are constructed largely of nanofiber mesh which is low-cost, low-mass, and has a lower heat-conduction threshold than most solid industrial sheeting. Unfortunately, the lightweight structures are also susceptible to stress from the high-velocity maneuvers performed by frigate and interceptor pilots, and require added inertial compensation systems and routine inspections.",0,0,100,100,0,1,0,0,1,0,0,0,17,3196,0,9255459);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2952,314,"Crate of Unidentified Fibrous Compound","These pieces of blue-green compound feel slick and oily to the touch and leave a tingle in your fingers. Fine crystalline filaments within crisscross and refract the light so that each piece seems to glow from within.",0,0,10,10,0,1,0,0,1,0,0,0,17,2210,0,9244190);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2953,55,"Dual 650mm Repeating Artillery II","Powerful, intermediate-range repeating artillery cannon with a decent rate of fire. 


Carbonized Lead, Depleted Uranium, EMP, Fusion, Nuclear, Phased Plasma, Proton, Titanium Sabot, Barrage, Hail.",11293,2000,2000,20,4,1,0,1.10923e+006,1,576,0.060000,0,7,381,422,13157595);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2954,135,"Dual 650mm Repeating Artillery II Blueprint","",382,0,0,0.010000,0,1,0,1e+007,1,298,0,0,9,381,422,729994);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2955,314,"Large Crate of Unidentified Fibrous Compound","These pieces of blue-green compound feel slick and oily to the touch and leave a tingle in your fingers. Fine crystalline filaments within crisscross and refract the light so that each piece seems to glow from within.",0,0,100,100,0,1,0,0,1,0,0,0,17,2210,0,9244199);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2956,314,"Large Crate of Refurbished Mining Drones","There are hints of rusty and damaged surfaces beneath the shiny new paint-job. These may not work as efficiently as the client wishes.",0,0,100,100,0,1,0,0,1,0,0,0,17,1084,0,9244227);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2957,314,"Crate of Refurbished Mining Drones","There are hints of rusty and damaged surfaces beneath the shiny new paint-job. These may not work as efficiently as the client wishes.",0,0,10,10,0,1,0,0,1,0,0,0,17,1084,0,9244225);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2958,283,"Civilian SIGINT Contractors","These contractors, many of whom are former Caldari Navy intelligence operatives, are very well trained, experienced, and possess high level security clearances, making them extremely valuable investments for their employer. Their skill sets are varied, but include translation (primarily Gallente), covert signals interception, military and economic intelligence analysis, and supercomputer systems administration. ",0,0,30,30,0,1,0,0,1,0,0,0,17,2537,0,9244242);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2959,283,"Group of Civilian SIGINT Contractors","These contractors, many of whom are former Caldari Navy intelligence operatives, are very well trained, experienced, and possess high level security clearances, making them extremely valuable investments for their employer. Their skill sets are varied, but include translation (primarily Gallente), covert signals interception, military and economic intelligence analysis, and supercomputer systems administration. ",0,0,300,300,0,1,0,0,1,0,0,0,17,2537,0,9256113);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2960,314,"Spools of Quantrium Wiring","While the universe is full of metals of all shapes, sizes, and compositions, there are some metals that are of such rarity and quality that they command prices far beyond those of the more easily accessible metals, such as tritanium. Amongst these, the very small quantities of a rare metal called quantrium are among the most valuable. This metal can only be found in the polar regions of certain moons, and these only in systems that meet very specific astrogeological conditions. So rare is this metal that, to date, only two known moons have quantities of this metal sufficient to warrant the very expensive mining and refining equipment required to extract it. Both of these moons are in Caldari space, giving the State a monopoly on its production and sale. Currently, all processed quantrium is on long-term contract to Kaalakiota Corporation. While rumors occasionally surface that one or more of the other three races have discovered quantrium, this has not been verified.",0,0,300,300,0,1,0,0,1,0,0,0,17,1363,0,9244244);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2961,55,"1400mm Howitzer Artillery II","The ultimate artillery cannon. It hurls death and destruction over incredible distances. 


Carbonized Lead, Depleted Uranium, EMP, Fusion, Nuclear, Phased Plasma, Proton, Titanium Sabot, Quake, Tremor.",11279,2000,1500,20,0.500000,1,0,2.32089e+006,1,579,0.060000,0,7,379,422,13157419);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2962,135,"1400mm Howitzer Artillery II Blueprint","",380,0,0,0.010000,0,1,0,1e+007,1,298,0,0,9,379,422,730000);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2963,314,"Quantrium Wiring","While the universe is full of metals of all shapes, sizes, and compositions, there are some metals that are of such rarity and quality that they command prices far beyond those of the more easily accessible metals, such as tritanium. Amongst these, the very small quantities of a rare metal called quantrium are among the most valuable. This metal can only be found in the polar regions of certain moons, and these only in systems that meet very specific astrogeological conditions. So rare is this metal that, to date, only two known moons have quantities of this metal sufficient to warrant the very expensive mining and refining equipment required to extract it. Both of these moons are in Caldari space, giving the State a monopoly on its production and sale. Currently, all processed quantrium is on long-term contract to Kaalakiota Corporation. While rumors occasionally surface that one or more of the other three races have discovered quantrium, this has not been verified.",0,0,30,30,0,1,0,0,1,0,0,0,17,1363,0,9244245);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2964,314,"Aerogel Counteragent","Refrigerated secure cargo containers containing aerogel infused with dormant prototype anti-nanites. These containers have been specially modified with the latest security encryption protocols, to better ensure that any Gallente saboteurs will be unable to access and tamper with this critical cargo.",0,0,30,30,0,1,0,0,1,0,0,0,17,1173,0,9244246);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2965,314,"Crate of Aerogel Counteragent","Refrigerated secure cargo containers containing aerogel infused with dormant prototype anti-nanites. These containers have been specially modified with the latest security encryption protocols, to better ensure that any Gallente saboteurs will be unable to access and tamper with this critical cargo.",0,0,300,300,0,1,0,0,1,0,0,0,17,1173,0,9256125);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2966,1053,"Eystur Rhomben","Subject: Prototype Nation Vessel (ID: Eystur Rhomben)


 Frigate-class vessel. Significant microwarp velocity. Enhanced weapons systems.


 There were no reported civilian abductions from the Eystur VI invasion. The Eystur identifier suggests a small number of captives may have been initially unaccounted for. The Rhomben identifier suggests an overarching position within the lowest tier of the new Nation hierarchy, or alternatively, that it was created during the first phase of development.


Synopsis from ISHAEKA-0041. DED Special Operations.
Authorized for Capsuleer dissemination.
",1237,31,2e+006,20000,235,1,4,0,0,0,0,31,11,0,0,9269173);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2967,314,"Crate of Target Painter Deflection Plating","These hull plates are coated with a layer of crystalline structures under a protective transparent enamel. The crystalline layer shimmers reflectively and creates mirage halos around the plate when spot lights are directed at it.",0,0,10,10,0,1,0,0,1,0,0,0,17,2192,0,9254395);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2968,314,"Large Crate of Target Painter Deflection Plating","These hull plates are coated with a layer of crystalline structures under a protective transparent enamel. The crystalline layer shimmers reflectively and creates mirage halos around the plate when spot lights are directed at it.",0,0,100,100,0,1,0,0,1,0,0,0,17,2192,0,9254396);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2969,55,"720mm Howitzer Artillery II","This 720mm rocket-assisted howitzer is designed for long-range bombardment. 


Carbonized Lead, Depleted Uranium, EMP, Fusion, Nuclear, Phased Plasma, Proton, Titanium Sabot, Quake, Tremor.",11283,200,50,10,0.250000,1,0,517456,1,578,0.060000,0,7,384,422,13157420);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2970,135,"720mm Howitzer Artillery II Blueprint","",385,0,0,0.010000,0,1,0,1e+007,1,297,0,0,9,384,422,730006);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2971,314,"Group of Haakar’s Striking Hawks","Haakar is a small, unassuming woman in her 40s who wields discipline like a whip. The men and women who follow her command – her Striking Hawks mercenary group – all served with or under her in the Republic Infantry’s 203rd Tactical Recon before the company was made redundant by policy changes fifteen years ago. Haakar bears a grudge against bureaucracy for cutting short her career, but says her work now gives her professional satisfaction and an autonomy she enjoys.",0,0,10,10,0,1,0,0,1,0,0,0,17,2544,0,9254408);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2972,314,"Ditanium Metal Plates","Refrigerated secure cargo containers containing aerogel infused with dormant prototype anti-nanites. These containers have been specially modified with the latest security encryption protocols, to better ensure that any Gallente saboteurs will be unable to access and tamper with this critical cargo.",0,0,30,30,0,1,0,0,1,0,0,0,17,1173,0,9254409);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2973,314,"Pallet of Ditanium Metal Plates","Refrigerated secure cargo containers containing aerogel infused with dormant prototype anti-nanites. These containers have been specially modified with the latest security encryption protocols, to better ensure that any Gallente saboteurs will be unable to access and tamper with this critical cargo.",0,0,300,300,0,1,0,0,1,0,0,0,17,1173,0,9256092);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2974,314,"Large Group of The Hooded Men","Unlike most pro-Minmatar mercenary companies, members of The Hooded Men come from every empire and any background; they are selected for their convictions and skills rather than any sense of patriotism they might possess. Even Amarr are permitted to join, provided they can prove that the company means more to them than their religion. The Hooded Men’s founder, Jolmiar Maritak, the grandson of former slaves who fled to the Gallente Federation, places emphasis on getting their work done quietly and with a minimum of fuss. ",0,0,100,100,0,1,0,0,1,0,0,0,17,2544,0,9254411);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2975,283,"Arctic Warfare Marines","Arctic Warfare Marines are the Caldari State’s elite foot soldiers for winter warfare. On the case of ice planets, where the weather is comprised of year-round snow and ice, you can find these self-sufficient Marines operating in a wide variety of roles, such as providing security for Caldari corporate facilities, military bases, and even for long-range reconnaissance on planets that have not yet been fully scouted. Their equipment is tailored specifically to harsh, sub-zero weather conditions, to include specialty rifles, thermal grenades, cold-weather speeder bikes, and everything in between. ",0,0,32,32,0,1,0,50000,1,0,0,0,17,2549,0,9254415);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2976,283,"Arctic Warfare Marine Squads","Arctic Warfare Marines are the Caldari State’s elite foot soldiers for winter warfare. On the case of ice planets, where the weather is comprised of year-round snow and ice, you can find these self-sufficient Marines operating in a wide variety of roles, such as providing security for Caldari corporate facilities, military bases, and even for long-range reconnaissance on planets that have not yet been fully scouted. Their equipment is tailored specifically to harsh, sub-zero weather conditions, to include specialty rifles, thermal grenades, cold-weather speeder bikes, and everything in between. ",0,0,320,320,0,1,0,50000,1,0,0,0,17,2549,0,9256170);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2977,55,"280mm Howitzer Artillery II","Rocket-assisted artillery projectiles designed for longe-range combat. It is the most powerful projectile weapon able to be fitted onto frigates. 


Carbonized Lead, Depleted Uranium, EMP, Fusion, Nuclear, Phased Plasma, Proton, Titanium Sabot, Quake, Tremor.",11287,20,5,5,0.050000,1,0,1976,1,577,0.060000,0,7,389,422,13157421);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2978,135,"280mm Howitzer Artillery II Blueprint","",390,0,0,0.010000,0,1,0,1e+007,1,296,0,0,9,389,422,730012);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2979,314,"Crate of Industrial-Grade Tritanium-Alloy Scraps","Not all scrap-metal is of good enough quality to be reused in the shipbuilding industry. These are the highest quality to be found in the scrap-heaps and abandoned battlegrounds of New Eden. Some pieces still bear signs of what they were once a part of: a sheet of tinted plating here, a painted logo there. Some pieces are still recognizable, others are half-slagged and warped. ",0,0,10,10,0,1,0,0,1,0,0,0,17,2529,0,9254425);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2980,314,"Large Crate of Industrial-Grade Tritanium-Alloy Scraps","Not all scrap-metal is of good enough quality to be reused in the shipbuilding industry. These are the highest quality to be found in the scrap-heaps and abandoned battlegrounds of New Eden. Some pieces still bear signs of what they were once a part of: a sheet of tinted plating here, a painted logo there. Some pieces are still recognizable, others are half-slagged and warped. ",0,0,100,100,0,1,0,0,1,0,0,0,17,2529,0,9254426);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2981,314,"Crate of Architectural-Quality Plagioclase Paneling","Minmatar architecture traditionally favors modular geometric structures and open spaces which allow breezes to flow from room to room. There is a traditional preference for working with exposed natural stone and wood, though recent trends have leaned towards natural surfaces bonded to structural reinforced concrete, stretching resources while still allowing for an attractive appearance. Compressed asteroid ore interior panels are becoming more popular for higher-class residences and for buildings constructed on mineral-poor worlds.",0,0,10,10,0,1,0,0,1,0,0,0,17,3320,0,9254438);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2982,314,"Large Crate of Architectural-Quality Plagioclase Paneling","Minmatar architecture traditionally favors modular geometric structures and open spaces which allow breezes to flow from room to room. There is a traditional preference for working with exposed natural stone and wood, though recent trends have leaned towards natural surfaces bonded to structural reinforced concrete, stretching resources while still allowing for an attractive appearance. Compressed asteroid ore interior panels are becoming more popular for higher-class residences and for buildings constructed on mineral-poor worlds.",0,0,100,100,0,1,0,0,1,0,0,0,17,3320,0,11740165);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2983,283,"Corporate Assassin","An elite corporate assassin, whose services are available usually only to the wealthiest and most discreet clientele. His track record of killings reaches far beyond Caldari space, with known “hits” recorded as far away as the Amarr and Gallente homeworlds. His weapon of choice is a highly-modified laser sniper rifle that he has proven effective at ranges up to and including three kilometers. Of course, he also utilizes a variety of other weapons, particularly for close range work. These include untraceable poisons, obscure neurotoxins, and, a variety of small arms and knives all, again, highly customized. He has a unblemished kill record, with no known failures, over a period of at least the last 20 years. When ultra-wealthy corporate executives require a more direct response to individuals who threaten their company’s profitability, this is one of the few contract killers than can actually be trusted not only to accomplish the most difficult missions, but also to keep any such business dealings to himself. In short, he knows how to keep his mouth shut. These factors make him a highly desirable contractor for tasks requiring his unique skill set. ",0,0,200,30,0,1,0,100,1,0,0,0,17,2539,0,9254451);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2984,283,"Deep Cover Corporate Assassin","An elite corporate assassin, whose services are available usually only to the wealthiest and most discreet clientele. His track record of killings reaches far beyond Caldari space, with known “hits” recorded as far away as the Amarr and Gallente homeworlds. His weapon of choice is a highly-modified laser sniper rifle that he has proven effective at ranges up to and including three kilometers. Of course, he also utilizes a variety of other weapons, particularly for close range work. These include untraceable poisons, obscure neurotoxins, and, a variety of small arms and knives all, again, highly customized. He has a unblemished kill record, with no known failures, over a period of at least the last 20 years. When ultra-wealthy corporate executives require a more direct response to individuals who threaten their company’s profitability, this is one of the few contract killers than can actually be trusted not only to accomplish the most difficult missions, but also to keep any such business dealings to himself. In short, he knows how to keep his mouth shut. These factors make him a highly desirable contractor for tasks requiring his unique skill set. ",0,0,200,300,0,1,0,100,1,0,0,0,17,2539,0,9254453);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2985,53,"Dual Heavy Beam Laser II","This heavy beam laser uses two separate laser focusing systems to reduce the cool down period between shots. A great weapon for medium to long range encounters. 


Gamma, Infrared, Microwave, Multifrequency, Radio, Standard, Ultraviolet, Xray, Aurora, Gleam.",11189,0,1,20,1,1,0,1.08184e+006,1,569,0.060000,0,7,361,422,13157574);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2986,133,"Dual Heavy Beam Laser II Blueprint","",361,0,0,0.010000,0,1,0,1e+007,1,295,0,0,9,361,422,730018);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2987,314,"Crate of Harvester Components","Agricultural technology, like everything else, is constantly advancing, with developments in irrigation techniques and automated systems to do the work of several farm-hands at a fraction of the overall cost. Most parts are produced on stations rather than planetside in order to reduce the cost of shipping. It also makes disposing of the more hazardous byproducts much safer, reducing the risk of planetary pollution. ",0,0,10,10,0,1,0,0,1,0,0,0,17,1186,0,9254454);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2988,314,"Large Crate of Harvester Components","Agricultural technology, like everything else, is constantly advancing, with developments in irrigation techniques and automated systems to do the work of several farm-hands at a fraction of the overall cost. Most parts are produced on stations rather than planetside in order to reduce the cost of shipping. It also makes disposing of the more hazardous byproducts much safer, reducing the risk of planetary pollution. ",0,0,100,100,0,1,0,0,1,0,0,0,17,1186,0,9254455);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2989,314,"Decoy Prototype Cloaking Devices","This decoy prototype cloaking device appears to be a working model; however, closer scrutiny reveals that it is nothing more than a useless hunk of metal and wires. ",0,0,60,60,0,1,0,0,1,0,0,0,17,2106,0,9254462);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2990,314,"Crate of Decoy Prototype Cloaking Devices","This decoy prototype cloaking device appears to be a working model; however, closer scrutiny reveals that it is nothing more than a useless hunk of metal and wires. ",0,0,500,500,0,1,0,0,1,0,0,0,17,2106,0,9256158);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2991,314,"Crate of Amarr Scripture Educational Study Packages (Matari translation)","These study materials provide a guide through the structure and meanings of Amarr holy texts in a way that school-age children can easily understand. Education, like every other aspect of daily life in the Empire, is closely tied into religion, and by the time they leave school, Amarr children are expected to have a working and in-depth understanding of their way of life.



These particular copies have been carefully translated by experts into painfully precise Matari for distribution in the Republic.",0,0,10,10,0,1,0,0,1,0,0,0,17,33,0,9254478);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2992,314,"Large Crate of Amarr Scripture Educational Study Packages (Matari translation)","These study materials provide a guide through the structure and meanings of Amarr holy texts in a way that school-age children can easily understand. Education, like every other aspect of daily life in the Empire, is closely tied into religion, and by the time they leave school, Amarr children are expected to have a working and in-depth understanding of their way of life.



These particular copies have been carefully translated by experts into painfully precise Matari for distribution in the Republic.",0,0,100,100,0,1,0,0,1,0,0,0,17,33,0,9254479);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2993,53,"Dual Light Beam Laser II","This light beam laser uses two separate laser focusing systems to reduce the cool down period between shots. Good short to medium range weapon. 


Gamma, Infrared, Microwave, Multifrequency, Radio, Standard, Ultraviolet, Xray, Aurora, Gleam.",11201,0,1,5,1,1,0,110698,1,567,0.060000,0,7,352,422,13157573);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2994,133,"Dual Light Beam Laser II Blueprint","",352,0,0,0.010000,0,1,0,1e+007,1,292,0,0,9,352,422,730024);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2995,314,"Blue Paradise","Blue Paradise, also known as “Beep,” is a mild narcotic engineered by Amarr pharmaceutical scientists specifically for use by slave laborers within the Empire. Users of Blue Paradise report feelings of mild euphoria, contentment, relaxation, and generalize pleasure as the primary effects of this drug. These effects typically last between three to five hours, after which the user can be expected to fall into a sound sleep, if taken prior to that user’s normal sleep cycle. Furthermore, there have been no significant side effects reported from repeat and prolonged use, making Blue Paradise an extremely promising “reward” for slave laborers. Recreational use of Blue Paradise has not yet been reported, given the limited nature of its distribution only to select Amarr slave labor operations, and no evidence yet exists of addiction to this drug, if administered in a controlled environment. ",0,0,60,60,0,1,0,0,1,0,0,0,17,3215,0,9254480);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2996,314,"Crate of Blue Paradise","Blue Paradise, also known as “Beep,” is a mild narcotic engineered by Amarr pharmaceutical scientists specifically for use by slave laborers within the Empire. Users of Blue Paradise report feelings of mild euphoria, contentment, relaxation, and generalize pleasure as the primary effects of this drug. These effects typically last between three to five hours, after which the user can be expected to fall into a sound sleep, if taken prior to that user’s normal sleep cycle. Furthermore, there have been no significant side effects reported from repeat and prolonged use, making Blue Paradise an extremely promising “reward” for slave laborers. Recreational use of Blue Paradise has not yet been reported, given the limited nature of its distribution only to select Amarr slave labor operations, and no evidence yet exists of addiction to this drug, if administered in a controlled environment. ",0,0,500,500,0,1,0,0,1,0,0,0,17,3215,0,9256148);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2997,314,"Crate of Refined C-86 Epoxy Resin","This substance, an improved version of the C-86 epoxy applied to propulsion systems and engine housings, helps to keep the systems’ temperature down, enabling more efficient operation and reduced risk of shipboard fires from overheated systems.",0,0,10,10,0,1,0,0,1,0,0,0,17,3750,0,9254502);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2998,28,"Noctis","The Noctis marks Outer Ring Excavations\' entry into the lucrative bulk salvaging market. Building on their successes integrating Marauder-class tractor technology into the Orca command platform, and innovations in automated salvaging technology, they designed a compact, affordable wreck recovery solution.

A refined version of the successful limited-run Primae design made the perfect hull to house this new equipment, as its salvaging heritage and advanced sensor suites complement and enhance the new technologies. The increased sensor footprint of the new vessel is more than compensated for by its incredible efficiency at retrieving and reclaiming wreckage.

ORE Industrial Skill Bonus: 5% bonus to Tractor Beam and Salvager cycle time and 60% bonus to Tractor Beam range and velocity per level.",10040,450,1.464e+007,270000,1460,1,8,6.21353e+007,1,1390,0.070000,0,6,0,0,11772792);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (2999,283,"Amarr Marine Counter-Boarding Team","Amarr Marine Counter-Boarding Teams are regarded as among the most elite units of their type across all four races. This expertise was developed not long after other states rediscovered warp technology. It occurred to senior Amarr military leaders that wars of the future would include ship-to-ship actions in space, to include the possibility of an enemy ship boarding another, as they had in millennia past when their ancestors sailed warships on the high seas. To that end, boarding and counterboarding training became a mandatory part of every Amarr marine’s advanced infantry training. The development of this capability led to the development of highly-specialized equipment for use in “boarding ops,” to include manportable high-speed welding gear, outer hatchway breaching explosives, and personal weapons for close quarters combat. ",0,0,90,30,0,1,0,50000,1,0,0,0,17,2549,0,9254516);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3000,314,"Group of Angel Cartel VIPs","These thugs and pirates look more like slick businessmen... with lots of armed bodyguards. Despite openly hostile relations, the empires must sometimes shake the hand of the devil in order to get things done. Much of that business is not intended to reach the light of day, or the eyes of the news agencies of New Eden.",0,0,10,10,0,1,0,0,1,0,0,0,17,2538,0,9254517);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3001,53,"Dual Light Pulse Laser II","This light pulse laser uses two separate laser focusing systems to reduce the cool down period between shots. Good skirmish weapon. 


Gamma, Infrared, Microwave, Multifrequency, Radio, Standard, Ultraviolet, Xray, Conflagration, Scorch.",11215,0,1,5,1,1,0,74920,1,570,0.060000,0,7,350,422,13157572);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3002,133,"Dual Light Pulse Laser II Blueprint","",351,0,0,0.010000,0,1,0,1e+007,1,292,0,0,9,350,422,730030);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3003,314,"Large Group of Angel Cartel VIPs","These thugs and pirates look more like slick businessmen... with lots of armed bodyguards. Despite openly hostile relations, the empires must sometimes shake the hand of the devil in order to get things done. Much of that business is not intended to reach the light of day, or the eyes of the news agencies of New Eden.",0,0,100,100,0,1,0,0,1,0,0,0,17,2538,0,11739660);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3004,283,"Amarr Marine Counter-Boarding Company","Amarr Marine Counter-Boarding Teams are regarded as among the most elite units of their type across all four races. This expertise was developed not long after other states rediscovered warp technology. It occurred to senior Amarr military leaders that wars of the future would include ship-to-ship actions in space, to include the possibility of an enemy ship boarding another, as they had in millennia past when their ancestors sailed warships on the high seas. To that end, boarding and counterboarding training became a mandatory part of every Amarr marine’s advanced infantry training. The development of this capability led to the development of highly-specialized equipment for use in “boarding ops,” to include manportable high-speed welding gear, outer hatchway breaching explosives, and personal weapons for close quarters combat. ",0,0,900,300,0,1,0,50000,1,0,0,0,17,2549,0,9256200);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3005,314,"Crate of Feille d’Marnne Champagne","This champagne originates from Egghelende III, the planet’s major product for export. Shipping it out of the pirate-heavy system makes it pricey enough, but the grapes have proven impossible to cultivate anywhere else in the Federation.



Each case is worth a couple hundred thousand ISK. Each bottle would bring enough planetary cred for a civilian to live comfortably for a year or ten. A bottle or three would definitely be missed.",0,0,10,10,0,1,0,0,1,0,0,0,17,27,0,9254531);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3006,283,"Conditioned House Slaves","These highly trained and expensive slaves undergo several years of conditioning and training prior to being sold or transferred into their duties, which most often include butler and maid duties at the homes of senior political or industrial leaders. These slaves are more highly valued than ordinary slaves and in return often receive decent treatment from their masters, as well as better-than-normal housing conditions and food. ",0,0,300,30,0,1,0,4000,1,0,0,0,17,2538,0,9254532);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3007,314,"Large Crate of Feille d’Marnne Champagne","This champagne originates from Egghelende III, the planet’s major product for export. Shipping it out of the pirate-heavy system makes it pricey enough, but the grapes have proven impossible to cultivate anywhere else in the Federation.



Each case is worth a couple hundred thousand ISK. Each bottle would bring enough planetary cred for a civilian to live comfortably for a year or ten. A bottle or three would definitely be missed.",0,0,100,100,0,1,0,0,1,0,0,0,17,27,0,9254533);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3008,283,"Herd of Conditioned House Slaves","These highly trained and expensive slaves undergo several years of conditioning and training prior to being sold or transferred into their duties, which most often include butler and maid duties at the homes of senior political or industrial leaders. These slaves are more highly valued than ordinary slaves and in return often receive decent treatment from their masters, as well as better-than-normal housing conditions and food. ",0,0,3000,300,0,1,0,4000,1,0,0,0,17,2538,0,9256201);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3009,53,"Focused Medium Beam Laser II","A high-energy, concentrated laser designed for medium range engagements. 


Gamma, Infrared, Microwave, Multifrequency, Radio, Standard, Ultraviolet, Xray, Aurora, Gleam.",11195,0,1,10,1,1,0,366626,1,568,0.060000,0,7,355,422,13157571);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3010,133,"Focused Medium Beam Laser II Blueprint","",357,0,0,0.010000,0,1,0,1e+007,1,293,0,0,9,355,422,730036);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3011,314,"Crate of Bootleg Holoreels","There doesn’t appear to be any particular organization here. Dozens of identical copies of everything from period dramas to last week’s boxing finals, in cases with obviously home-printed labels.



When played, the holos’ quality is shabby and rimmed with static, occasionally deteriorating to basic 2-D images. The sound is unreliable and fades at times. Hopefully, the people who buy these copies aren’t paying as much as the supplier did for the originals.",0,0,10,10,0,1,0,0,1,0,0,0,17,1177,0,9254546);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3012,314,"Large Crate of Suspicious Holoreels","There doesn’t appear to be any particular organization here. Dozens of identical copies of everything from period dramas to last week’s boxing finals, in original cases. Nothing that would raise any eyebrows.



The actual contents of the holoreels are far less innocuous. After a token menu page and a few minutes of whatever program the case displays, they switch to more interesting material. Entire corporate internal presentations clearly never intended for the public eye. Snoop footage of important officials talking and even exchanging money with known competitors. A series of compromising stills of a prominent politician.


These will be worth a lot of money to someone.",0,0,100,100,0,1,0,0,1,0,0,0,17,1177,0,9254547);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3013,314,"Amarr Religious Holoreels","These holoreels contain a recent speech by a regional governor, which provides her views on the state of the Empire as well as other important religious discussions.",0,0,100,10,0,1,0,0,1,0,0,0,17,1177,0,9254548);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3014,314,"Crate of Amarr Religious Holoreels","These holoreels contain a recent speech by a regional governor, which provides her views on the state of the Empire as well as other important religious discussions.",0,0,100,100,0,1,0,0,1,0,0,0,17,1177,0,9256190);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3015,314,"Crate of Cryo-Stored Luminaire Skippers","These large, indigo-hued amphibians are commonly used in laboratory work. Each weighs roughly two kilograms, and in their natural environment in the marshlands of Gallente Prime are the dominant aquatic predator. To prevent the stresses of space travel from affecting the frogs\' physiology, it is necessary to transport them in a cold-case which drops their body temperature and induces a state of hibernation.",0,0,10,10,0,1,0,0,1,0,0,0,17,1159,0,9254575);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3016,314,"Large Crate of Cryo-Stored Luminaire Skippers","These large, indigo-hued amphibians are commonly used in laboratory work. Each weighs roughly two kilograms, and in their natural environment in the marshlands of Gallente Prime are the dominant aquatic predator. To prevent the stresses of space travel from affecting the frogs\' physiology, it is necessary to transport them in a cold-case which drops their body temperature and induces a state of hibernation.",0,0,100,100,0,1,0,0,1,0,0,0,17,1159,0,9254576);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3017,53,"Gatling Pulse Laser II","Rapid fire multi-barreled energy weapon that delivers a steady stream of damage. 


Gamma, Infrared, Microwave, Multifrequency, Radio, Standard, Ultraviolet, Xray, Conflagration, Scorch.",11217,0,1,5,1,1,0,35690,1,570,0.060000,0,7,350,422,13157570);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3018,133,"Gatling Pulse Laser II Blueprint","",350,0,0,0.010000,0,1,0,1e+007,1,292,0,0,9,350,422,730042);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3019,314,"Crate of Unidentified Ancient Technology","These pieces appear to all be some form of polyhedral from truncated pyramids that can be gripped in the hand to barrel-sized fullerene-faceted globes. Each is shaped as if in one complete piece from bluish or steely-gray material, all edges beveled and smoothed. When rapped with a knuckle, the pieces ring like a bell, but the material feels more like ceramic.



Every item bears a sort of dim, inner glow that pulses irregularly, like a dying light bulb. A tingle like electricity can be felt just above their surfaces, though preliminary examinations have dismissed the presence of any electrical activity. There is some speculation that the pieces form some sort of modular information annex, with contact between matching faces forming the necessary connections. No amount of fitting has yielded any results, however, so the disparate parts sit in their individually labeled crates like the pieces of several puzzles mixed together.",0,0,10,10,0,1,0,0,1,0,0,0,17,2889,0,9254590);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3020,314,"Large Crate of Talocan Station Life-Support Cores","These pieces appear to all be some form of polyhedral from truncated pyramids that can be gripped in the hand to barrel-sized fullerene-faceted globes. Each is shaped as if in one complete piece from bluish or steely-gray material, all edges beveled and smoothed. When rapped with a knuckle, the pieces ring like a bell, but the material feels more like ceramic.



Every item bears a sort of dim, inner glow that pulses irregularly, like a dying light bulb. A tingle like electricity can be felt just above their surfaces, though preliminary examinations have dismissed the presence of any electrical activity. Each piece fits face to face with another piece; when linked correctly, they form series of twisted fractal-like branches.
",0,0,100,100,0,1,0,0,1,0,0,0,17,2889,0,9254591);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3021,314,"Crate of Portable Emergency Heating Units","These heating units are compact, and light enough to carry in one hand. Each comes with two 10-hour rechargeable batteries, to be used one at a time while the spare charges. The amount of energy one unit puts off would be enough to warm a space of 20 cubic meters, roughly the interior space of a stationside apartment’s main room, to an average of 10 degrees Celsius. Not particularly cosy, but better than freezing.",0,0,10,10,0,1,0,0,1,0,0,0,17,2042,0,9254603);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3022,314,"Large Crate of Portable Emergency Heating Units","These heating units are compact, and light enough to carry in one hand. Each comes with two 10-hour rechargeable batteries, to be used one at a time while the spare charges. The amount of energy one unit puts off would be enough to warm a space of 20 cubic meters, roughly the interior space of a stationside apartment’s main room, to an average of 10 degrees Celsius. Not particularly cosy, but better than freezing.",0,0,100,100,0,1,0,0,1,0,0,0,17,2042,0,9254604);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3023,314,"Crate of Archaeological Lot GV87-426-D Artifacts","This looks like little more than half a starship modified into ground-based living quarters. Several panels are inscribed with decorative symbols. A series of large rectangular cases contain corroded circuit boards with rows of finger-sized crystalline vials anchored to one face; some of the vials are still intact and contain a foggy gaseous substance. A section from what appears to have been a hydroponics lab contains trays of organic matter, fossilised from exposure to the moon\'s arid conditions and thin, nitrogen-argon atmosphere.",0,0,10,10,0,1,0,0,1,0,0,0,17,2529,0,9254616);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3024,314,"Large Crate of Archaeological Lot GV87-426-E Artifacts","This looks like little more than half a starship, perhaps one which was modified into ground-based living quarters. Several panels are inscribed with decorative symbols, possibly writing. The carefully-dismantled panels are accompanied by several crates filled with pieces of what appear to be small-industry mining tools, encrusted with moon-dust. The oxygen-free lunar atmosphere prevented rust from forming on the metal, and writing etched into the flat surfaces is clearly visible. Another crate is filled with core samples and geodes. A note accompanying the find indicates that the minerals have no known industrial property in any part of the present-day Federation, and further research will be needed to determine the purpose of the pre-Federation miners.",0,0,100,100,0,1,0,0,1,0,0,0,17,2529,0,9254617);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3025,53,"Heavy Beam Laser II","A high-energy heavy laser designed for medium range engagements. Delivers powerful damage. 


Gamma, Infrared, Microwave, Multifrequency, Radio, Standard, Ultraviolet, Xray, Aurora, Gleam.",11197,0,1,10,1,1,0,514516,1,568,0.060000,0,7,355,422,13157569);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3026,133,"Heavy Beam Laser II Blueprint","",359,0,0,0.010000,0,1,0,1e+007,1,293,0,0,9,355,422,730048);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3027,314,"Crate of Contained Cerrocentite","A slick-looking, translucent amber mineral with a hexagonal crystalline structure. Its radioactive properties require the material to be stored in special containment units; handling by anyone other than a trained engineer is strongly discouraged.



Cerrocentite is used primarily in stationside security networks, mostly in the systems which detect unbalance in the atmosphere mix.",0,0,10,10,0,1,0,0,1,0,0,0,17,94,0,9254629);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3028,314,"Large Crate of Contained Mesarchonite","A coarse-looking, dark red mineral with a geodic structure containing translucent crystals of the same color. Its radioactive properties require the material to be stored in special containment units; handling by anyone other than a trained engineer is strongly discouraged.



Mesarchonite is used primarily in stationside security networks, mostly in the systems which detect interference or tampering along the audio-visual lines.",0,0,100,100,0,1,0,0,1,0,0,0,17,94,0,9254630);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3029,314,"Group of Coriault Couture Collective Display Employees","Across the broad sweep of New Eden, there is no constellation closer to the forefront of fashion than Coriault. The Crux constellation, which includes Luminaire and Oursulaert, may be the heart of the Federation’s consumer culture, but Coriault is home to the fashion-houses of Auvergne and Vylade, and in particular the Dodixie-based Maison Nephére which has provided finery exclusively for the Federation presidents and their partners for well over a century. 



In order to improve their visibility in the glare of the Federation’s heart, dozens of Coriault houses merged under the Coriault Couture Collective label. Each school operates independently, and the styles can vary wildly, but open competition between institutions only occurs when particular contracts are opened to the highest bidder.. The designers frequently model their own work, operating under the philosophy that if they wouldn’t be seen in public in their own work, nobody else should, either.",0,0,10,10,0,1,0,0,1,0,0,0,17,2543,0,9254642);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3030,314,"Large Group of Mannar Textile Institute International Representatives","Mannar, one of the oldest members of the Federation, has always had a strong influence on Gallente style and trendsetting. Much of the eccentric tailoring favored by society’s elite and decried as immodest and inappropriate by the other empires has its roots in pre-Federation Mannar culture, which included different concepts of modesty and etiquette. Massive hairstyles and elaborate body- and face-painting still feature prominently in addition to semi-opaque fabrics which respond to a variety of programmable stimuli.",0,0,100,100,0,1,0,0,1,0,0,0,17,2537,0,9254643);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3031,314,"Crate of Exclusive Simo Reshar Fitness Holoreels","Fitness guru Simo Reshar is iconic less for the effectiveness of his workout routines than for the questionable nature of the visuals and extremely cheesy rhythmic music. The covers depict the skinny workout instructor with his anthropomorphic cartoon assistants, dressed in worryingly skintight shiny outfits.



Though clearly intended for a younger audience, adults have professed to discover deeper philosophical meanings within the holos’ content if watched whilst under the influence of certain substances. Reshar’s assistants, particularly the feline Leeta and avian Yanis, have gained a cult following among certain fetish scenes across the cluster.",0,0,10,10,0,1,0,0,1,0,0,0,17,1177,0,9254655);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3032,283,"Amarr Forensic Investigative Team","This team of highly-trained forensic investigators always travels with a large quantity of all manner of equipment, from manportable to vehicle-mounted. The team is expected to be self-sustaining for 10 days due to its frequent deployment to harsh environments, from asteroids to ship wrecks. Due to this requirement, it necessarily travels with foodstuffs, drinking water, and myriad other consumables. Coupled with the large volume of investigative equipment, this team requires significant cargo space when transported to and from its typically remote duty locations. ",0,0,65,65,0,1,0,0,1,0,0,0,17,2891,0,9254656);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3033,53,"Medium Beam Laser II","A high-powered beam laser. Good for medium range encounters. 


Gamma, Infrared, Microwave, Multifrequency, Radio, Standard, Ultraviolet, Xray, Aurora, Gleam.",11203,0,1,5,1,1,0,183776,1,567,0.060000,0,7,352,422,13157568);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3034,133,"Medium Beam Laser II Blueprint","",354,0,0,0.010000,0,1,0,1e+007,1,292,0,0,9,352,422,730054);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3035,314,"Large Crate of Exclusive Simo Reshar Fitness Holoreels","Fitness guru Simo Reshar is iconic less for the effectiveness of his workout routines than for the questionable nature of the visuals and extremely cheesy rhythmic music. The covers depict the skinny workout instructor with his anthropomorphic cartoon assistants, dressed in worryingly skintight shiny outfits.



Though clearly intended for a younger audience, adults have professed to discover deeper philosophical meanings within the holos’ content if watched whilst under the influence of certain substances. Reshar’s assistants, particularly the feline Leeta and avian Yanis, have gained a cult following among certain fetish scenes across the cluster.",0,0,100,100,0,1,0,0,1,0,0,0,17,1177,0,9254657);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3036,283,"Amarr Forensic Investigative Deployment","This team of highly-trained forensic investigators always travels with a large quantity of all manner of equipment, from manportable to vehicle-mounted. The team is expected to be self-sustaining for 10 days due to its frequent deployment to harsh environments, from asteroids to ship wrecks. Due to this requirement, it necessarily travels with foodstuffs, drinking water, and myriad other consumables. Coupled with the large volume of investigative equipment, this team requires significant cargo space when transported to and from its typically remote duty locations. ",0,0,400,400,0,1,0,0,1,0,0,0,17,2891,0,9256180);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3037,314,"Crate of Experimental ECM Hybrid Rounds","These modified tungsten hybrid rounds send out an ECM pulse through the hull of any ship they strike, momentarily baffling the ship’s target-locking mechanisms and affording the formerly-targeted ship a few precious moments to gain an advantage or escape. Efforts are being made to develop this into purely friend-or-foe munitions, effectively counteracting the effects of enemy ECM, but adaptation of the missile-based tracking technology to hybrid shell systems has proven difficult.",0,0,10,10,0,1,0,0,1,0,0,0,17,1323,0,9254670);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3038,314,"Large Crate of Experimental ECM Hybrid Rounds","These modified tungsten hybrid rounds send out an ECM pulse through the hull of any ship they strike, momentarily baffling the ship’s target-locking mechanisms and affording the formerly-targeted ship a few precious moments to gain an advantage or escape. Efforts are being made to develop this into purely friend-or-foe munitions, effectively counteracting the effects of enemy ECM, but adaptation of the missile-based tracking technology to hybrid shell systems has proven difficult.",0,0,100,100,0,1,0,0,1,0,0,0,17,1323,0,9254671);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3039,108,"Noctis Blueprint","",10040,0,0,0.010000,0,1,0,3.9e+008,1,1389,0,0,9,0,0,10686643);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3041,53,"Medium Pulse Laser II","A high-powered pulse laser. Good for short to medium range encounters. 


Gamma, Infrared, Microwave, Multifrequency, Radio, Standard, Ultraviolet, Xray, Conflagration, Scorch.",11219,0,1,5,1,1,0,145544,1,570,0.060000,0,7,350,422,13157567);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3042,133,"Medium Pulse Laser II Blueprint","",353,0,0,0.010000,0,1,0,1e+007,1,292,0,0,9,350,422,730060);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3046,306,"Weapon Loading Platform","This control platform stores ammunition and operation supplies for the nearby prototype weapon. Given the size of the contents within, an industrial vessel will likely be needed to retrieve anything of use.",2394,34,10000,27500,10000,1,0,0,0,0,0,0,11,0,0,9279900);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3047,226,"Prototype Weapon Platform","Although obviously an Avatar-class titan in a former life, the hull of this once-magnificent ship has been drastically modified to accommodate a new role. Nearly the entirety of the hull has been stripped and reconfigured in a conversion that is clearly designed to turn the vessel itself into a giant weapon.",2910,6800,0,0,0,1,0,0,1,0,0,0,2,0,0,9279884);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3048,952,"Jammed Prototype Weapon Platform","Although obviously an Avatar-class titan in a former life, the hull of this once-magnificent ship has been drastically modified to accommodate a new role. Nearly the entirety of the hull has been stripped and reconfigured in a conversion that is clearly designed to turn the vessel itself into a giant weapon.",2910,6800,2.27813e+009,1.55e+008,1e+007,1,0,0,1,0,0,0,11,0,0,9279883);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3049,53,"Mega Beam Laser II","A super-heavy beam laser designed for medium to long range engagements. 


Gamma, Infrared, Microwave, Multifrequency, Radio, Standard, Ultraviolet, Xray, Aurora, Gleam.",11191,0,1,20,1,1,0,1.78866e+006,1,569,0.060000,0,7,361,422,13157566);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3050,133,"Mega Beam Laser II Blueprint","",363,0,0,0.010000,0,1,0,1e+007,1,295,0,0,9,361,422,730066);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3051,314,"Modified Isotope Solution","This highly volatile and incredibly dense substance is used as part of Sansha’s experimental weapons program. From the way it can be loaded into their weapon platform, it most likely serves as some kind of ammunition.",0,0,10000,10000,0,1,0,0,1,0,0,0,17,2699,0,9279899);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3052,319,"Reinforced Nation Outpost","This enormous mobile station stands as an example of the engineering excellence found within the Nation’s endless ranks, the upper echelons of which are filled with mechanical geniuses and masters of design. Virtually indestructible in its hardened state, this station has very few weaknesses. It serves frighteningly well in its role as a mobile safe haven for the Nation’s military researchers and technicians.",2364,8960,100000,1e+008,10000,1,8,0,0,0,0,0,11,0,0,9279882);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3054,952,"Sansha Territorial Reclamation Outpost","Containing an inner habitation core surrounded by an outer shell filled with a curious fluid, the purpose of which remains unclear, this outpost is no doubt the brain-child of some nameless True Slave engineer.",3295,1239,100000,1e+008,10000,1,0,0,0,0,0,0,11,0,0,9313242);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3056,226,"LCO Sansha Deadspace Outpost I","Containing an inner habitation core surrounded by an outer shell filled with a curious fluid, the purpose of which remains unclear, this outpost is no doubt the brain-child of some nameless True Slave engineer.",2363,1239,100000,1e+008,10000,1,0,0,0,0,0,0,2,0,0,9272132);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3057,53,"Mega Pulse Laser II","A super-heavy pulse laser designed for medium range engagements. 


Gamma, Infrared, Microwave, Multifrequency, Radio, Standard, Ultraviolet, Xray, Conflagration, Scorch.",11209,0,1,20,1,1,0,1.55139e+006,1,573,0.060000,0,7,360,422,13157565);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3058,133,"Mega Pulse Laser II Blueprint","",362,0,0,0.010000,0,1,0,1e+007,1,295,0,0,9,360,422,730072);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3059,226,"LCO Sansha Starbase Control Tower","The Sansha Control Tower is an enhanced version of the Amarr control tower utilizing the latest frontier design techniques to increase its defences and efficiency.",3295,3394,100000,1e+008,10000,1,4,0,0,0,0,0,2,0,0,9272153);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3060,1063,"Gas Extractor Control Unit","Extracting gas from a gas giant requires more effort than simply opening a door into a container. Each specific type of desirable gas requires an ionized filament to be calibrated to attract only the right particles from the atmosphere. Even a fraction of a percent error could spoil an entire batch of product by tainting it with unwanted material. Likewise, once the gas is extracted from the surrounding air, the platform’s equilibrium tanks must be adjusted to compensate for the added weight or buoyancy. Beyond that, it’s a simple matter of supercooling it and transferring the liquid form into a container for transport. As one pioneer of this technology accurately described it, “The extractor itself is much like a living organism, breathing in what it needs and expelling that which becomes cumbersome.”",4555,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,9274165);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3061,1063,"Ice Extractor Control Unit","Finding desired liquids on hostile worlds can be almost as challenging a task as extracting it from the unforgiving environment, which often entails drilling kilometers below the surface or condensing fluids from the upper atmosphere. Once the liquids are discovered, the facility itself begins the relatively simple task of separating it from the ambient plasma interference, scalding magma streams, or potentially infectious indigenous bacteria. A surprising amount of valuable liquids can be extracted from hostile worlds, but only if the equipment is properly calibrated and carefully maintained.",4553,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,9274166);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3062,1063,"Lava Extractor Control Unit","This facility consists of seismic insulated platforms and heavy, jointed conveyor belts leading into deep tunnels. Extremophile drones, built to function in even corrosive, intemperate, and high- or low-pressure atmospheres, run a constant circuit along the belts, performing repairs and clearing away rubble. A staff of mining experts and technicians occupy the main building in case any of the automated systems fail.",4552,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,9274167);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3063,1063,"Oceanic Extractor Control Unit","This underwater platform and extendable extraction arms are capable of scouring the ocean floor for valuable materials and bringing them to the surface for transportation to processing facilities. A small habitation module serves as living and operation quarters for the human administration and maintenance crew, along with emergency surfacing capsules in the case of a seismic event or breach of the building’s integrity.",4548,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,9274168);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3064,1063,"Plasma Extractor Control Unit","This facility consists of seismic insulated platforms and heavy, jointed conveyor belts leading into deep tunnels. Extremophile drones, built to function in even corrosive, intemperate, and high- or low-pressure atmospheres, run a constant circuit along the belts, performing repairs and clearing away rubble. A staff of mining experts and technicians occupy the main building in case any of the automated systems fail.",4552,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,9274169);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3065,53,"Tachyon Beam Laser II","An ultra-heavy beam laser designed for medium to long range engagements. 


Gamma, Infrared, Microwave, Multifrequency, Radio, Standard, Ultraviolet, Xray, Aurora, Gleam.",11193,0,1,20,1,1,0,2.27368e+006,1,569,0.060000,0,7,361,422,13157564);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3066,133,"Tachyon Beam Laser II Blueprint","",364,0,0,0.010000,0,1,0,1e+007,1,295,0,0,9,361,422,730078);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3067,1063,"Storm Extractor Control Unit","Finding desired liquids on hostile worlds can be almost as challenging a task as extracting it from the unforgiving environment, which often entails drilling kilometers below the surface or condensing fluids from the upper atmosphere. Once the liquids are discovered, the facility itself begins the relatively simple task of separating it from the ambient plasma interference, scalding magma streams, or potentially infectious indigenous bacteria. A surprising amount of valuable liquids can be extracted from hostile worlds, but only if the equipment is properly calibrated and carefully maintained.",4553,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,9274170);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3068,1063,"Temperate Extractor Control Unit","Finding desired liquids on hostile worlds can be almost as challenging a task as extracting it from the unforgiving environment, which often entails drilling kilometers below the surface or condensing fluids from the upper atmosphere. Once the liquids are discovered, the facility itself begins the relatively simple task of separating it from the ambient plasma interference, scalding magma streams, or potentially infectious indigenous bacteria. A surprising amount of valuable liquids can be extracted from hostile worlds, but only if the equipment is properly calibrated and carefully maintained.",4544,0,0,0,0,1,0,45000,1,0,0,0,41,0,0,9274171);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3069,920,"Incursion ship attributes effects Vanguard","",1217,1,1,20,0,250,0,0,1,0,0,0,2,0,0,9412307);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3070,875,"Orca Civilian","The Orca was developed as a joint venture between Outer Ring Excavations and Deep Core Mining Inc as a vessel to help meet the demands of New Eden\'s industry and provide a flexible platform from which mining operations can be more easily managed. The Orca uses much of the technology developed by ORE for the Rorqual and integrated with the latest advancements from Deep Core Mining research division has developed a vessel which offers a diverse role to all sizes of operations and needs.",3466,550,2.5e+008,1.025e+007,30000,1,1,0,0,0,0,0,11,0,0,9429173);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3071,1052,"Uroborus","We are one, birthed from the clash of opposites.
A synthesis 13 billion years in waiting.


The era of false promises is fading from view, and for the first time we can now look ahead on this path and begin to see the totality of our journey.

We are flag bearers for an age without the weakness of humanity.
 The first to glimpse at a life beyond those known by our predecessors.

We are humanity’s first and best hope to become something more.

Flawed and imperfect creatures, our enemies lumber obliviously toward this moment.

Just as we march alongside them, toward the day when everything will change and we will remake the world once more.

They intend to struggle against the approaching dawn, yet there is no war.

There is only inevitability.

 -Sansha Kuvakei",10038,2840,1.54688e+009,6.2e+007,1337,1,4,0,0,0,0.070000,10002,11,0,0,11802453);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3072,920,"Incursion Effect Assault","",1217,1,1,20,0,250,0,0,1,0,0,0,2,0,0,9281453);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3073,227,"Rusty Cloud","",1147,1,0,0,0,1,0,0,0,0,0,0,2,0,0,730081);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3074,74,"150mm Railgun II","This is a standard long-range railgun designed for frigates. Railguns use magnetic rails to fire solid chunks of matter at hypersonic speed. The accurate range of railguns is very good, but due to technical limitations it cannot use onboard guidance. This results in a fairly rapid drop in accuracy at extreme ranges. 


Antimatter, Iridium, Iron, Lead, Plutonium, Thorium, Tungsten, Uranium, Javelin, Spike.",11259,10,50,5,0.200000,1,0,183136,1,564,0.060000,0,7,349,422,13157712);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3075,154,"150mm Railgun II Blueprint","",375,0,0,0.010000,0,1,0,1e+007,1,291,0,0,9,349,422,730087);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3076,920,"Incursion Effect HQ","",1217,1,1,20,0,250,0,0,1,0,0,0,2,0,0,9281471);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3077,749,"Hardwiring - Zainou \'Gnome\' KUA750","A neural Interface upgrade that reduces the shield upgrade module power needs.",0,1,0,1,0,1,0,200000,1,1158,0.050000,0,20,2224,422,10684455);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3078,749,"Hardwiring - Zainou \'Gnome\' KUA1500","A neural Interface upgrade that reduces the shield upgrade module power needs.",0,1,0,1,0,1,0,200000,1,1158,0.050000,0,20,2224,422,10684453);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3079,749,"Hardwiring - Zainou \'Gnome\' KUA3000","A neural Interface upgrade that reduces the shield upgrade module power needs.",0,1,0,1,0,1,0,200000,1,1158,0.050000,0,20,2224,422,10684454);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3080,749,"Hardwiring - Zainou \'Gnome\' KVA750","Improved skill at regulating shield capacity.  2% Bonus to shield capacity.",0,1,0,1,0,1,0,200000,1,1167,0.050000,0,20,2224,422,10684458);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3081,749,"Hardwiring - Zainou \'Gnome\' KVA1500","Improved skill at regulating shield capacity.  4% Bonus to shield capacity.",0,1,0,1,0,1,0,200000,1,1167,0.050000,0,20,2224,422,10684456);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3082,74,"250mm Railgun II","Cruiser-sized large barrel turret. Railguns use magnetic rails to fire solid chunks of matter at hypersonic speed. The accurate range of railguns is very good, but due to technical limitations it cannot use onboard guidance. This results in a fairly rapid drop in accuracy at extreme ranges. 


Antimatter, Iridium, Iron, Lead, Plutonium, Thorium, Tungsten, Uranium, Javelin, Spike.",11255,100,50,10,1,1,0,505832,1,565,0.060000,0,7,370,422,13157713);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3083,154,"250mm Railgun II Blueprint","",370,0,0,0.010000,0,1,0,1e+007,1,290,0,0,9,370,422,730093);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3084,749,"Hardwiring - Zainou \'Gnome\' KVA3000","Improved skill at regulating shield capacity.  6% Bonus to shield capacity.",0,1,0,1,0,1,0,200000,1,1167,0.050000,0,20,2224,422,10684457);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3085,749,"Hardwiring - Zainou \'Gnome\' KXA750","A neural Interface upgrade that reduces the capacitor need for shield emission system modules such as shield transfer array.",0,1,0,1,0,1,0,200000,1,1175,0.050000,0,20,2224,422,10684461);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3086,749,"Hardwiring - Zainou \'Gnome\' KXA1500","A neural Interface upgrade that reduces the capacitor need for shield emission system modules such as shield transfer array.",0,1,0,1,0,1,0,200000,1,1175,0.050000,0,20,2224,422,10684459);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3087,749,"Hardwiring - Zainou \'Gnome\' KXA3000","A neural Interface upgrade that reduces the capacitor need for shield emission system modules such as shield transfer array.",0,1,0,1,0,1,0,200000,1,1175,0.050000,0,20,2224,422,10684460);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3088,749,"Hardwiring - Zainou \'Gnome\' KYA750","A neural Interface upgrade that boosts the recharge rate of the shields of the pilots ship.",0,1,0,1,0,1,0,200000,1,1184,0.050000,0,20,2224,422,10684464);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3089,749,"Hardwiring - Zainou \'Gnome\' KYA1500","A neural Interface upgrade that boosts the recharge rate of the shields of the pilots ship.",0,1,0,1,0,1,0,200000,1,1184,0.050000,0,20,2224,422,10684462);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3090,74,"425mm Railgun II","This large battleship-sized weapon packs quite a punch. Railguns use magnetic rails to fire solid chunks of matter at hypersonic speed. The accurate range of railguns is very good, but due to technical limitations it cannot use onboard guidance. This results in a fairly rapid drop in accuracy at extreme ranges. 


Antimatter, Iridium, Iron, Lead, Plutonium, Thorium, Tungsten, Uranium, Javelin, Spike.",11249,1000,750,20,2,1,0,930592,1,566,0.060000,0,7,366,422,13157714);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3091,154,"425mm Railgun II Blueprint","",366,0,0,0.010000,0,1,0,1e+007,1,289,0,0,9,366,422,730099);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3092,749,"Hardwiring - Zainou \'Gnome\' KYA3000","A neural Interface upgrade that boosts the recharge rate of the shields of the pilots ship.",0,1,0,1,0,1,0,200000,1,1184,0.050000,0,20,2224,422,10684463);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3093,747,"Hardwiring - Eifyr and Co. \'Rogue\' AY-0.5","A Eifyr and Co hardwiring designed to enhance pilot Manuvering skill. Grants a 2% bonus to Ship Agility.",0,1,0,1,0,1,0,200000,1,1165,0.050000,0,20,2224,422,10684406);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3094,747,"Hardwiring - Eifyr and Co. \'Rogue\' AY-1.5","A Eifyr and Co hardwiring designed to enhance pilot Manuvering skill. Grants a 4% bonus to Ship Agility.",0,1,0,1,0,1,0,200000,1,1165,0.050000,0,20,2224,422,10684407);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3095,747,"Hardwiring - Eifyr and Co. \'Rogue\' AY-2.5","A Eifyr and Co hardwiring designed to enhance pilot Manuvering skill. Grants a 6% bonus to Ship Agility.",0,1,0,1,0,1,0,200000,1,1165,0.050000,0,20,2224,422,10684408);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3096,747,"Hardwiring - Eifyr and Co. \'Rogue\' CY-0.5","A Eifyr and Co gunnery hardwiring designed to enhance pilot navigation skill. Grants a 2% bonus to Ship Velocity.",0,1,0,1,0,1,0,200000,1,1157,0.050000,0,20,2224,422,10684391);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3097,747,"Hardwiring - Eifyr and Co. \'Rogue\' CY-1.5","A Eifyr and Co gunnery hardwiring designed to enhance pilot navigation skill. Grants a 4% bonus to Ship Velocity.",0,1,0,1,0,1,0,200000,1,1157,0.050000,0,20,2224,422,10684392);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3098,74,"75mm Gatling Rail II","A small multi-barreled railgun for frigates. Railguns use magnetic rails to fire solid chunks of matter at hypersonic speed. The accurate range of railguns is very good, but due to technical limitations it cannot use onboard guidance. This results in a fairly rapid drop in accuracy at extreme ranges. 


Antimatter, Iridium, Iron, Lead, Plutonium, Thorium, Tungsten, Uranium, Javelin, Spike.",11261,10,200,5,1,1,0,35028,1,564,0.060000,0,7,349,422,13157715);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3099,154,"75mm Gatling Rail II Blueprint","",349,0,0,0.010000,0,1,0,1e+007,1,291,0,0,9,349,422,730105);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3100,747,"Hardwiring - Eifyr and Co. \'Rogue\' CY-2.5","A Eifyr and Co gunnery hardwiring designed to enhance pilot navigation skill. Grants a 6% bonus to Ship Velocity.",0,1,0,1,0,1,0,200000,1,1157,0.050000,0,20,2224,422,10684393);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3101,747,"Hardwiring - Eifyr and Co. \'Rogue\' DY-0.5","Improved control over afterburner energy consumption. 2% reduction in afterburner capacitor needs.",0,1,0,1,0,1,0,200000,1,1176,0.050000,0,20,2224,422,10684409);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3102,747,"Hardwiring - Eifyr and Co. \'Rogue\' DY-1.5","Improved control over afterburner energy consumption. 4% reduction in afterburner capacitor needs.",0,1,0,1,0,1,0,200000,1,1176,0.050000,0,20,2224,422,10684410);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3103,747,"Hardwiring - Eifyr and Co. \'Rogue\' DY-2.5","Improved control over afterburner energy consumption. 6% reduction in afterburner capacitor needs.",0,1,0,1,0,1,0,200000,1,1176,0.050000,0,20,2224,422,10684411);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3104,747,"Hardwiring - Eifyr and Co. \'Rogue\' EY-0.5","A neural interface upgrade that boosts the pilot\'s skill with afterburners.",0,1,0,1,0,1,0,200000,1,1157,0.050000,0,20,2224,422,10684394);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3105,747,"Hardwiring - Eifyr and Co. \'Rogue\' EY-1.5","A neural interface upgrade that boosts the pilot\'s skill with afterburners.",0,1,0,1,0,1,0,200000,1,1157,0.050000,0,20,2224,422,10684395);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3106,74,"Dual 150mm Railgun II","This cruiser-sized weapon is a double-barreled version of the frigate class 150mm railgun. Railguns use magnetic rails to fire solid chunks of matter at hypersonic speed. The accurate range of railguns is very good, but due to technical limitations it cannot use onboard guidance. This results in a fairly rapid drop in accuracy at extreme ranges. 


Antimatter, Iridium, Iron, Lead, Plutonium, Thorium, Tungsten, Uranium, Javelin, Spike.",11251,100,175,10,4,1,0,253296,1,565,0.060000,0,7,370,422,13157716);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3107,154,"Dual 150mm Railgun II Blueprint","",373,0,0,0.010000,0,1,0,1e+007,1,290,0,0,9,370,422,730111);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3108,747,"Hardwiring - Eifyr and Co. \'Rogue\' EY-2.5","A neural interface upgrade that boosts the pilot\'s skill with afterburners.",0,1,0,1,0,1,0,200000,1,1157,0.050000,0,20,2224,422,10684396);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3109,747,"Hardwiring - Eifyr and Co. \'Rogue\' FY-0.5","A neural interface upgrade that boosts the pilot\'s skill at warp drive operation.",0,1,0,1,0,1,0,200000,1,1157,0.050000,0,20,2224,422,10684397);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3110,747,"Hardwiring - Eifyr and Co. \'Rogue\' FY-1.5","A neural interface upgrade that boosts the pilot\'s skill at warp drive operation.",0,1,0,1,0,1,0,200000,1,1157,0.050000,0,20,2224,422,10684398);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3111,747,"Hardwiring - Eifyr and Co. \'Rogue\' FY-2.5","A neural interface upgrade that boosts the pilot\'s skill at warp drive operation.",0,1,0,1,0,1,0,200000,1,1157,0.050000,0,20,2224,422,10684399);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3112,747,"Hardwiring - Eifyr and Co. \'Rogue\' GY-0.5","Improves the performance of micro warpdrives. 2% reduction in capacitor needs.",0,1,0,1,0,1,0,200000,1,1182,0.050000,0,20,2224,422,10684412);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3113,747,"Hardwiring - Eifyr and Co. \'Rogue\' GY-1.5","Improves the performance of micro warpdrives. 4% reduction in capacitor needs.",0,1,0,1,0,1,0,200000,1,1182,0.050000,0,20,2224,422,10684413);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3114,74,"Dual 250mm Railgun II","This battleship-sized weapon is a double-barreled version of the cruiser class 250mm railgun. Railguns use magnetic rails to fire solid chunks of matter at hypersonic speed. The accurate range of railguns is very good, but due to technical limitations it cannot use onboard guidance. This results in a fairly rapid drop in accuracy at extreme ranges. 


Antimatter, Iridium, Iron, Lead, Plutonium, Thorium, Tungsten, Uranium, Javelin, Spike.",11245,1000,1500,20,8,1,0,583032,1,566,0.060000,0,7,366,422,13158274);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3115,154,"Dual 250mm Railgun II Blueprint","",368,0,0,0.010000,0,1,0,1e+007,1,289,0,0,9,366,422,730117);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3116,747,"Hardwiring - Eifyr and Co. \'Rogue\' GY-2.5","Improves the performance of micro warpdrives. 6% reduction in capacitor needs.",0,1,0,1,0,1,0,200000,1,1182,0.050000,0,20,2224,422,10684414);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3117,747,"Hardwiring - Eifyr and Co. \'Rogue\' HY-0.5","A neural interface upgrade that boosts the pilot\'s skill at warp navigation.",0,1,0,1,0,1,0,200000,1,1157,0.050000,0,20,2224,422,10684400);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3118,747,"Hardwiring - Eifyr and Co. \'Rogue\' HY-1.5","A neural interface upgrade that boosts the pilot\'s skill at warp navigation.",0,1,0,1,0,1,0,200000,1,1157,0.050000,0,20,2224,422,10684401);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3119,747,"Hardwiring - Eifyr and Co. \'Rogue\' HY-2.5","A neural interface upgrade that boosts the pilot\'s skill at warp navigation.",0,1,0,1,0,1,0,200000,1,1157,0.050000,0,20,2224,422,10684402);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3120,747,"Hardwiring - Eifyr and Co. \'Rogue\' MY-0.5","Improves speed boosting velocity. 2% Bonus to afterburner and microwarp drive speed increase.",0,1,0,1,0,1,0,0,1,1157,0.050000,0,20,2224,422,10684403);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3121,747,"Hardwiring - Eifyr and Co. \'Rogue\' MY-1.5","Improves speed boosting velocity. 4% Bonus to afterburner and microwarp drive speed increase.",0,1,0,1,0,1,0,0,1,1157,0.050000,0,20,2224,422,10684404);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3122,74,"Electron Blaster Cannon II","Particle blasters operate on a similar principle as the railgun except they fire a magnetically contained ball of subatomic particles. No other turret class can match the sheer destructive power of particle blasters, but due to the rapid dispersion of the containment field, it also has the worst range of all turrets. 


Antimatter, Iridium, Iron, Lead, Plutonium, Thorium, Tungsten, Uranium, Null, Void.",11223,1000,400,20,10,1,0,1.14768e+006,1,563,0.060000,0,7,365,422,13362731);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3123,154,"Electron Blaster Cannon II Blueprint","",369,0,0,0.010000,0,1,0,1e+007,1,289,0,0,9,365,422,730123);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3124,747,"Hardwiring - Eifyr and Co. \'Rogue\' MY-2.5","Improves speed boosting velocity. 6% Bonus to afterburner and microwarp drive speed increase.",0,1,0,1,0,1,0,0,1,1157,0.050000,0,20,2224,422,10684405);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3125,746,"Hardwiring - Zainou \'Deadeye\' ZMA11","A Zainou missile hardwiring designed to enhance skill with missiles. 2% decreased factor of signature radius for light, heavy and cruise missile explosions.",0,1,0,1,0,1,0,200000,1,1173,0.050000,0,20,2224,422,10684368);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3126,746,"Hardwiring - Zainou \'Deadeye\' ZMA110","A Zainou missile hardwiring designed to enhance skill with missiles. 4% decreased factor of signature radius for light, heavy and cruise missile explosions.",0,1,0,1,0,1,0,200000,1,1173,0.050000,0,20,2224,422,10684369);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3127,746,"Hardwiring - Zainou \'Deadeye\' ZMA1100","A Zainou missile hardwiring designed to enhance skill with missiles. 6% decreased factor of signature radius for light, heavy and cruise missile explosions.",0,1,0,1,0,1,0,200000,1,1173,0.050000,0,20,2224,422,10684370);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3128,746,"Hardwiring - Zainou \'Deadeye\' ZMC11","A Zainou missile hardwiring designed to enhance skill with missiles. 2% bonus to all missiles\' maximum flight range.",0,1,0,1,0,1,0,200000,1,1164,0.050000,0,20,2224,422,10684356);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3129,746,"Hardwiring - Zainou \'Deadeye\' ZMC110","A Zainou missile hardwiring designed to enhance skill with missiles. 4% bonus to all missiles\' maximum flight range.",0,1,0,1,0,1,0,200000,1,1164,0.050000,0,20,2224,422,10684357);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3130,74,"Heavy Electron Blaster II","Particle blasters operate on a similar principle as the railgun except they fire a magnetically contained ball of subatomic particles. No other turret class can match the sheer destructive power of particle blasters, but due to the rapid dispersion of the containment field, it also has the worst range of all turrets. 


Antimatter, Iridium, Iron, Lead, Plutonium, Thorium, Tungsten, Uranium, Null, Void.",11229,100,2000,10,5,1,0,262752,1,562,0.060000,0,7,371,422,13157718);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3131,154,"Heavy Electron Blaster II Blueprint","",374,0,0,0.010000,0,1,0,1e+007,1,290,0,0,9,371,422,730129);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3132,746,"Hardwiring - Zainou \'Deadeye\' ZMC1100","A Zainou missile hardwiring designed to enhance skill with missiles. 6% bonus to all missiles\' maximum flight range.",0,1,0,1,0,1,0,200000,1,1164,0.050000,0,20,2224,422,10684358);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3133,746,"Hardwiring - Zainou \'Deadeye\' ZML11","A Zainou missile hardwiring designed to enhance skill with missiles. 2% bonus to all missiles\' maximum velocity.",0,1,0,1,0,1,0,200000,1,1164,0.050000,0,20,2224,422,10684359);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3134,746,"Hardwiring - Zainou \'Deadeye\' ZML110","A Zainou missile hardwiring designed to enhance skill with missiles. 4% bonus to all missiles\' maximum velocity.",0,1,0,1,0,1,0,200000,1,1164,0.050000,0,20,2224,422,10684361);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3135,746,"Hardwiring - Zainou \'Deadeye\' ZML1100","A Zainou missile hardwiring designed to enhance skill with missiles. 6% bonus to all missiles\' maximum velocity.",0,1,0,1,0,1,0,200000,1,1164,0.050000,0,20,2224,422,10684360);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3136,746,"Hardwiring - Zainou \'Deadeye\' ZMM11","A Zainou missile hardwiring designed to enhance skill with missiles. 2% bonus to all missile launcher rate of fire.",0,1,0,1,0,1,0,200000,1,1189,0.050000,0,20,2224,422,10684383);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3137,746,"Hardwiring - Zainou \'Deadeye\' ZMM110","A Zainou missile hardwiring designed to enhance skill with missiles. 4% bonus to all missile launcher rate of fire.",0,1,0,1,0,1,0,200000,1,1189,0.050000,0,20,2224,422,10684384);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3138,74,"Heavy Ion Blaster II","Particle blasters operate on a similar principle as the railgun except they fire a magnetically contained ball of subatomic particles. No other turret class can match the sheer destructive power of particle blasters, but due to the rapid dispersion of the containment field, it also has the worst range of all turrets. 


Antimatter, Iridium, Iron, Lead, Plutonium, Thorium, Tungsten, Uranium, Null, Void.",11231,100,125,10,3,1,0,370268,1,562,0.060000,0,7,371,422,13157719);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3139,154,"Heavy Ion Blaster II Blueprint","",371,0,0,0.010000,0,1,0,1e+007,1,290,0,0,9,371,422,730135);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3140,746,"Hardwiring - Zainou \'Deadeye\' ZMM1100","A Zainou missile hardwiring designed to enhance skill with missiles. 6% bonus to all missile launcher rate of fire.",0,1,0,1,0,1,0,200000,1,1189,0.050000,0,20,2224,422,10684385);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3141,746,"Hardwiring - Zainou \'Deadeye\' ZMS11","A Zainou missile hardwiring designed to enhance skill with missiles. 2% decrease in factor of target\'s velocity for all missiles.",0,1,0,1,0,1,0,200000,1,1181,0.050000,0,20,2224,422,10684374);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3142,746,"Hardwiring - Zainou \'Deadeye\' ZMS110","A Zainou missile hardwiring designed to enhance skill with missiles. 4% decrease in factor of target\'s velocity for all missiles.",0,1,0,1,0,1,0,200000,1,1181,0.050000,0,20,2224,422,10684375);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3143,746,"Hardwiring - Zainou \'Deadeye\' ZMS1100","A Zainou missile hardwiring designed to enhance skill with missiles. 6% decrease in factor of target\'s velocity for all missiles.",0,1,0,1,0,1,0,200000,1,1181,0.050000,0,20,2224,422,10684376);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3144,746,"Hardwiring - Zainou \'Gnome\' KTA11","A neural Interface upgrade that lowers launcher CPU needs by 2%.",0,1,0,1,0,1,0,0,1,1156,0.050000,0,20,2224,422,10684343);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3145,746,"Hardwiring - Zainou \'Gnome\' KTA110","A neural Interface upgrade that lowers launcher CPU needs by 4%.",0,1,0,1,0,1,0,0,1,1156,0.050000,0,20,2224,422,10684346);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3146,74,"Heavy Neutron Blaster II","Particle blasters operate on a similar principle as the railgun except they fire a magnetically contained ball of subatomic particles. No other turret class can match the sheer destructive power of particle blasters, but due to the rapid dispersion of the containment field, it also has the worst range of all turrets. 


Antimatter, Iridium, Iron, Lead, Plutonium, Thorium, Tungsten, Uranium, Null, Void.",11233,100,100,10,2,1,0,443112,1,562,0.060000,0,7,371,422,13157720);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3147,154,"Heavy Neutron Blaster II Blueprint","",372,0,0,0.010000,0,1,0,1e+007,1,290,0,0,9,371,422,730141);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3148,746,"Hardwiring - Zainou \'Gnome\' KTA1100","A neural Interface upgrade that lowers launcher CPU needs by 6%.",0,1,0,1,0,1,0,0,1,1156,0.050000,0,20,2224,422,10684347);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3149,746,"Hardwiring - Zainou \'Sharpshooter\' ZMX11","A Zainou missile hardwiring designed to enhance skill with missiles. 2% bonus to citadel torpedo damage.",0,1,0,1,0,1,0,200000,1,0,0.050000,0,20,2224,422,9277280);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3150,746,"Hardwiring - Zainou \'Sharpshooter\' ZMX110","A Zainou missile hardwiring designed to enhance skill with missiles. 4% bonus to citadel torpedo damage.",0,1,0,1,0,1,0,200000,1,0,0.050000,0,20,2224,422,9277293);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3151,746,"Hardwiring - Zainou \'Sharpshooter\' ZMX1100","A Zainou missile hardwiring designed to enhance skill with missiles. 6% bonus to citadel torpedo damage.",0,1,0,1,0,1,0,200000,1,0,0.050000,0,20,2224,422,9277306);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3152,746,"Hardwiring - Zainou \'Snapshot\' ZMD750","A neural interface upgrade that boosts the pilot\'s skill with defender missiles.",0,1,0,1,0,1,0,200000,1,1173,0.050000,0,20,2224,422,10684373);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3153,746,"Hardwiring - Zainou \'Snapshot\' ZMD1500","A neural interface upgrade that boosts the pilot\'s skill with defender missiles.",0,1,0,1,0,1,0,200000,1,1173,0.050000,0,20,2224,422,10684371);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3154,74,"Ion Blaster Cannon II","Particle blasters operate on a similar principle as the railgun except they fire a magnetically contained ball of subatomic particles. No other turret class can match the sheer destructive power of particle blasters, but due to the rapid dispersion of the containment field, it also has the worst range of all turrets. 


Antimatter, Iridium, Iron, Lead, Plutonium, Thorium, Tungsten, Uranium, Null, Void.",11225,1000,500,20,6,1,0,1.4752e+006,1,563,0.060000,0,7,365,422,13210341);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3155,154,"Ion Blaster Cannon II Blueprint","",365,0,0,0.010000,0,1,0,1e+007,1,289,0,0,9,365,422,730147);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3156,746,"Hardwiring - Zainou \'Snapshot\' ZMD3000","A neural interface upgrade that boosts the pilot\'s skill with defender missiles.",0,1,0,1,0,1,0,200000,1,1173,0.050000,0,20,2224,422,10684372);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3157,746,"Hardwiring - Zainou \'Snapshot\' ZME750","A neural interface upgrade that boosts the pilot\'s skill with heavy assault missiles.",0,1,0,1,0,1,0,200000,1,1164,0.050000,0,20,2224,422,10684364);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3158,746,"Hardwiring - Zainou \'Snapshot\' ZME1500","A neural interface upgrade that boosts the pilot\'s skill with heavy assault missiles.",0,1,0,1,0,1,0,200000,1,1164,0.050000,0,20,2224,422,10684362);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3159,746,"Hardwiring - Zainou \'Snapshot\' ZME3000","A neural interface upgrade that boosts the pilot\'s skill with heavy assault missiles.",0,1,0,1,0,1,0,200000,1,1164,0.050000,0,20,2224,422,10684363);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3160,746,"Hardwiring - Zainou \'Snapshot\' ZMF750","A neural interface upgrade that boosts the pilot\'s skill with friend-or-foe missiles.",0,1,0,1,0,1,0,200000,1,1189,0.050000,0,20,2224,422,10684390);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3161,746,"Hardwiring - Zainou \'Snapshot\' ZMF1500","A neural interface upgrade that boosts the pilot\'s skill with friend-or-foe missiles.",0,1,0,1,0,1,0,200000,1,1189,0.050000,0,20,2224,422,10684388);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3162,74,"Light Electron Blaster II","Particle blasters operate on a similar principle as the railgun except they fire a magnetically contained ball of subatomic particles. No other turret class can match the sheer destructive power of particle blasters, but due to the rapid dispersion of the containment field, it also has the worst range of all turrets. 


Antimatter, Iridium, Iron, Lead, Plutonium, Thorium, Tungsten, Uranium, Null, Void.",11235,10,150,5,1,1,0,74064,1,561,0.060000,0,7,376,422,13157721);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3163,154,"Light Electron Blaster II Blueprint","",378,0,0,0.010000,0,1,0,1e+007,1,291,0,0,9,376,422,730153);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3164,746,"Hardwiring - Zainou \'Snapshot\' ZMF3000","A neural interface upgrade that boosts the pilot\'s skill with friend-or-foe missiles.",0,1,0,1,0,1,0,200000,1,1189,0.050000,0,20,2224,422,10684389);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3165,746,"Hardwiring - Zainou \'Snapshot\' ZMH750","A neural interface upgrade that boosts the pilot\'s skill with heavy missiles.",0,1,0,1,0,1,0,200000,1,1164,0.050000,0,20,2224,422,10684367);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3166,746,"Hardwiring - Zainou \'Snapshot\' ZMH1500","A neural interface upgrade that boosts the pilot\'s skill with heavy missiles.",0,1,0,1,0,1,0,200000,1,1164,0.050000,0,20,2224,422,10684365);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3167,746,"Hardwiring - Zainou \'Snapshot\' ZMH3000","A neural interface upgrade that boosts the pilot\'s skill with heavy missiles.",0,1,0,1,0,1,0,200000,1,1164,0.050000,0,20,2224,422,10684366);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3168,746,"Hardwiring - Zainou \'Snapshot\' ZMN750","A neural interface upgrade that boosts the pilot\'s skill with standard missiles.",0,1,0,1,0,1,0,200000,1,1181,0.050000,0,20,2224,422,10684379);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3169,746,"Hardwiring - Zainou \'Snapshot\' ZMN1500","A neural interface upgrade that boosts the pilot\'s skill with standard missiles.",0,1,0,1,0,1,0,200000,1,1181,0.050000,0,20,2224,422,10684377);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3170,74,"Light Ion Blaster II","Particle blasters operate on a similar principle as the railgun except they fire a magnetically contained ball of subatomic particles. No other turret class can match the sheer destructive power of particle blasters, but due to the rapid dispersion of the containment field, it also has the worst range of all turrets. 


Antimatter, Iridium, Iron, Lead, Plutonium, Thorium, Tungsten, Uranium, Null, Void.",11237,10,175,5,0.600000,1,0,109676,1,561,0.060000,0,7,376,422,13157722);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3171,154,"Light Ion Blaster II Blueprint","",377,0,0,0.010000,0,1,0,1e+007,1,291,0,0,9,376,422,730159);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3172,746,"Hardwiring - Zainou \'Snapshot\' ZMN3000","A neural interface upgrade that boosts the pilot\'s skill with standard missiles.",0,1,0,1,0,1,0,200000,1,1181,0.050000,0,20,2224,422,10684378);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3173,746,"Hardwiring - Zainou \'Snapshot\' ZMR750","A neural interface upgrade that boosts the pilot\'s skill with rockets.",0,1,0,1,0,1,0,200000,1,1181,0.050000,0,20,2224,422,10684382);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3174,746,"Hardwiring - Zainou \'Snapshot\' ZMR1500","A neural interface upgrade that boosts the pilot\'s skill with rockets.",0,1,0,1,0,1,0,200000,1,1181,0.050000,0,20,2224,422,10684380);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3175,746,"Hardwiring - Zainou \'Snapshot\' ZMR3000","A neural interface upgrade that boosts the pilot\'s skill with rockets.",0,1,0,1,0,1,0,200000,1,1181,0.050000,0,20,2224,422,10684381);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3176,746,"Hardwiring - Zainou \'Snapshot\' ZMT750","A neural interface upgrade that boosts the pilot\'s skill with torpedoes.",0,1,0,1,0,1,0,200000,1,1156,0.050000,0,20,2224,422,10684352);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3177,746,"Hardwiring - Zainou \'Snapshot\' ZMT1500","A neural interface upgrade that boosts the pilot\'s skill with torpedoes.",0,1,0,1,0,1,0,200000,1,1156,0.050000,0,20,2224,422,10684348);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3178,74,"Light Neutron Blaster II","Particle blasters operate on a similar principle as the railgun except they fire a magnetically contained ball of subatomic particles. No other turret class can match the sheer destructive power of particle blasters, but due to the rapid dispersion of the containment field, it also has the worst range of all turrets. 


Antimatter, Iridium, Iron, Lead, Plutonium, Thorium, Tungsten, Uranium, Null, Void.",11239,10,80,5,0.400000,1,0,148538,1,561,0.060000,0,7,376,422,13157723);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3179,154,"Light Neutron Blaster II Blueprint","",376,0,0,0.010000,0,1,0,1e+007,1,291,0,0,9,376,422,730165);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3180,746,"Hardwiring - Zainou \'Snapshot\' ZMT3000","A neural interface upgrade that boosts the pilot\'s skill with torpedoes.",0,1,0,1,0,1,0,200000,1,1156,0.050000,0,20,2224,422,10684349);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3181,746,"Hardwiring - Zainou \'Snapshot\' ZMU750","A neural interface upgrade that boosts the pilot\'s skill with cruise missiles.",0,1,0,1,0,1,0,200000,1,1156,0.050000,0,20,2224,422,10684355);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3182,746,"Hardwiring - Zainou \'Snapshot\' ZMU1500","A neural interface upgrade that boosts the pilot\'s skill with cruise missiles.",0,1,0,1,0,1,0,200000,1,1156,0.050000,0,20,2224,422,10684353);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3183,746,"Hardwiring - Zainou \'Snapshot\' ZMU3000","A neural interface upgrade that boosts the pilot\'s skill with cruise missiles.",0,1,0,1,0,1,0,200000,1,1156,0.050000,0,20,2224,422,10684354);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3184,257,"ORE Industrial","Skill at operating ORE industrial ships. Can not be trained on Trial Accounts.",0,0,0,0.010000,0,1,8,1.6e+006,1,377,0,0,16,33,0,11766803);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3185,742,"Hardwiring - Eifyr and Co \'Gunslinger\' MX-0.5","A Eifyr and Co. gunnery hardwiring designed to enhance skill with medium projectile turrets. Grants a 2% bonus to medium projectile turret Damage.",0,1,0,1,0,1,0,0,1,1171,0.050000,0,20,2224,422,10684315);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3186,74,"Neutron Blaster Cannon II","Particle blasters operate on a similar principle as the railgun except they fire a magnetically contained ball of subatomic particles. No other turret class can match the sheer destructive power of particle blasters, but due to the rapid dispersion of the containment field, it also has the worst range of all turrets. 


Antimatter, Iridium, Iron, Lead, Plutonium, Thorium, Tungsten, Uranium, Null, Void.",11227,1000,1000,20,4,1,0,1.44659e+006,1,563,0.060000,0,7,365,422,13157724);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3187,154,"Neutron Blaster Cannon II Blueprint","",367,0,0,0.010000,0,1,0,1e+007,1,289,0,0,9,365,422,730171);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3188,742,"Hardwiring - Eifyr and Co \'Gunslinger\' MX-1.5","A Eifyr and Co. gunnery hardwiring designed to enhance skill with medium projectile turrets. Grants a 4% bonus to medium projectile turret Damage.",0,1,0,1,0,1,0,0,1,1171,0.050000,0,20,2224,422,10684314);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3189,742,"Hardwiring - Eifyr and Co \'Gunslinger\' MX-2.5","A Eifyr and Co. gunnery hardwiring designed to enhance skill with medium projectile turrets. Grants a 6% bonus to medium projectile turret Damage.",0,1,0,1,0,1,0,0,1,1171,0.050000,0,20,2224,422,10684313);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3190,742,"Hardwiring - Eifyr and Co. \'Gunslinger\' AX-0.5","A Eifyr and Co. gunnery hardwiring designed to enhance turret tracking. Grants a 2% bonus to turret tracking speed.",0,1,0,1,0,1,0,200000,1,1163,0.050000,0,20,2224,422,10684304);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3191,742,"Hardwiring - Eifyr and Co. \'Gunslinger\' AX-1.5","A Eifyr and Co. gunnery hardwiring designed to enhance turret tracking. Grants a 4% bonus to turret tracking speed.",0,1,0,1,0,1,0,200000,1,1163,0.050000,0,20,2224,422,10684305);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3192,742,"Hardwiring - Eifyr and Co. \'Gunslinger\' AX-2.5","A Eifyr and Co. gunnery hardwiring designed to enhance turret tracking. Grants a 6% bonus to turret tracking speed.",0,1,0,1,0,1,0,200000,1,1163,0.050000,0,20,2224,422,10684306);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3193,742,"Hardwiring - Eifyr and Co. \'Gunslinger\' CX-0.5","A Eifyr and Co. gunnery hardwiring designed to enhance skill with all turrets. Grants a 2% bonus to all turret Damages.",0,1,0,1,0,1,0,200000,1,1180,0.050000,0,20,2224,422,10684322);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3194,742,"Hardwiring - Eifyr and Co. \'Gunslinger\' CX-1.5","A Eifyr and Co. gunnery hardwiring designed to enhance skill with all turrets. Grants a 4% bonus to all turret Damages.",0,1,0,1,0,1,0,200000,1,1180,0.050000,0,20,2224,422,10684323);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3195,742,"Hardwiring - Eifyr and Co. \'Gunslinger\' CX-2.5","A Eifyr and Co. gunnery hardwiring designed to enhance skill with all turrets. Grants a 6% bonus to all turret Damages.",0,1,0,1,0,1,0,200000,1,1180,0.050000,0,20,2224,422,10684324);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3196,742,"Hardwiring - Eifyr and Co. \'Gunslinger\' LX-0.5","A Eifyr and Co. gunnery hardwiring designed to enhance skill with large projectile turrets. Grants a 2% bonus to large projectile turret Damage.",0,1,0,1,0,1,0,200000,1,1186,0.050000,0,20,2224,422,10684331);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3197,742,"Hardwiring - Eifyr and Co. \'Gunslinger\' LX-1.5","A Eifyr and Co. gunnery hardwiring designed to enhance skill with large projectile turrets. Grants a 4% bonus to large projectile turret Damage.",0,1,0,1,0,1,0,200000,1,1186,0.050000,0,20,2224,422,10684332);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3198,742,"Hardwiring - Eifyr and Co. \'Gunslinger\' LX-2.5","A Eifyr and Co. gunnery hardwiring designed to enhance skill with large projectile turrets. Grants a 6% bonus to large projectile turret Damage.",0,1,0,1,0,1,0,200000,1,1186,0.050000,0,20,2224,422,10684333);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3199,742,"Hardwiring - Eifyr and Co. \'Gunslinger\' SX-0.5","A Eifyr and Co. gunnery hardwiring designed to enhance skill with small projectile turrets. Grants a 2% bonus to small projectile turret Damage.",0,1,0,1,0,1,0,200000,1,1155,0.050000,0,20,2224,422,10684294);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3200,742,"Hardwiring - Eifyr and Co. \'Gunslinger\' SX-1.5","A Eifyr and Co. gunnery hardwiring designed to enhance skill with small projectile turrets. Grants a 4% bonus to small projectile turret Damage.",0,1,0,1,0,1,0,200000,1,1155,0.050000,0,20,2224,422,10684295);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3201,742,"Hardwiring - Eifyr and Co. \'Gunslinger\' SX-2.5","A Eifyr and Co. gunnery hardwiring designed to enhance skill with small projectile turrets. Grants a 6% bonus to small projectile turret Damage.",0,1,0,1,0,1,0,200000,1,1155,0.050000,0,20,2224,422,10684296);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3202,742,"Hardwiring - Inherent Implants \'Lancer\' G0.5-Alpha","A Inherent Implants gunnery hardwiring designed to enhance skill with small energy turrets. Grants a 2% bonus to small energy turret Damage.",0,1,0,1,0,1,0,200000,1,1155,0.050000,0,20,2224,422,10684297);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3203,742,"Hardwiring - Inherent Implants \'Lancer\' G0.5-Beta","A Inherent Implants gunnery hardwiring designed to enhance turret energy mangement. Grants a 2% reduction in all turret capacitor need.",0,1,0,1,0,1,0,200000,1,1163,0.050000,0,20,2224,422,10684307);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3204,742,"Hardwiring - Inherent Implants \'Lancer\' G0.5-Delta","A Inherent Implants gunnery hardwiring designed to enhance turret rate of fire. Grants a 2% bonus to all turret rate of fire.",0,1,0,1,0,1,0,200000,1,1180,0.050000,0,20,2224,422,10684325);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3205,742,"Hardwiring - Inherent Implants \'Lancer\' G0.5-Epsilon","A Inherent Implants gunnery hardwiring designed to enhance skill with large energy turrets. Grants a 2% bonus to large energy turret Damage.",0,1,0,1,0,1,0,200000,1,1186,0.050000,0,20,2224,422,10684334);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3206,742,"Hardwiring - Inherent Implants \'Lancer\' G0.5-Gamma","A Inherent Implants gunnery hardwiring designed to enhance skill with medium energy turrets. Grants a 2% bonus to medium energy turret Damage.",0,1,0,1,0,1,0,200000,1,1171,0.050000,0,20,2224,422,10684316);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3207,742,"Hardwiring - Inherent Implants \'Lancer\' G1.5-Alpha","A Inherent Implants gunnery hardwiring designed to enhance skill with small energy turrets. Grants a 4% bonus to small energy turret Damage.",0,1,0,1,0,1,0,200000,1,1155,0.050000,0,20,2224,422,10684298);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3208,742,"Hardwiring - Inherent Implants \'Lancer\' G1.5-Beta","A Inherent Implants gunnery hardwiring designed to enhance turret energy mangement. Grants a 4% reduction in all turret capacitor need.",0,1,0,1,0,1,0,200000,1,1163,0.050000,0,20,2224,422,10684308);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3209,742,"Hardwiring - Inherent Implants \'Lancer\' G1.5-Delta","A Inherent Implants gunnery hardwiring designed to enhance turret rate of fire. Grants a 4% bonus to all turret rate of fire.",0,1,0,1,0,1,0,200000,1,1180,0.050000,0,20,2224,422,10684326);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3210,742,"Hardwiring - Inherent Implants \'Lancer\' G1.5-Epsilon","A Inherent Implants gunnery hardwiring designed to enhance skill with large energy turrets. Grants a 4% bonus to large energy turret Damage.",0,1,0,1,0,1,0,200000,1,1186,0.050000,0,20,2224,422,10684335);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3211,742,"Hardwiring - Inherent Implants \'Lancer\' G1.5-Gamma","A Inherent Implants gunnery hardwiring designed to enhance skill with medium energy turrets. Grants a 4% bonus to medium energy turret Damage.",0,1,0,1,0,1,0,200000,1,1171,0.050000,0,20,2224,422,10684317);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3212,742,"Hardwiring - Inherent Implants \'Lancer\' G2.5-Alpha","A Inherent Implants gunnery hardwiring designed to enhance skill with small energy turrets. Grants a 6% bonus to small energy turret Damage.",0,1,0,1,0,1,0,0,1,1155,0.050000,0,20,2224,422,10684299);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3213,742,"Hardwiring - Inherent Implants \'Lancer\' G2.5-Beta","A Inherent Implants gunnery hardwiring designed to enhance turret energy mangement. Grants a 6% reduction in all turret capacitor need.",0,1,0,1,0,1,0,0,1,1163,0.050000,0,20,2224,422,10684309);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3214,742,"Hardwiring - Inherent Implants \'Lancer\' G2.5-Delta","A Inherent Implants gunnery hardwiring designed to enhance turret rate of fire. Grants a 6% bonus to all turret rate of fire.",0,1,0,1,0,1,0,0,1,1180,0.050000,0,20,2224,422,10684327);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3215,742,"Hardwiring - Inherent Implants \'Lancer\' G2.5-Epsilon","A Inherent Implants gunnery hardwiring designed to enhance skill with large energy turrets. Grants a 6% bonus to large energy turret Damage.",0,1,0,1,0,1,0,0,1,1186,0.050000,0,20,2224,422,10684336);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3216,742,"Hardwiring - Inherent Implants \'Lancer\' G2.5-Gamma","An Inherent Implants gunnery hardwiring designed to enhance skill with medium energy turrets. Grants a 6% bonus to medium energy turret Damage.",0,1,0,1,0,1,0,0,1,1171,0.050000,0,20,2224,422,10684318);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3217,742,"Hardwiring - Zainou \'Deadeye\' ZGA11","A Zainou gunnery hardwiring designed to enhance optimal range. Grants a 2% bonus to turret optimal range.",0,1,0,1,0,1,0,200000,1,1180,0.050000,0,20,2224,422,10684328);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3218,101,"Harvester Mining Drone","The Harvester is the most efficient mining drone money can buy.",1009,5,0,10,0,1,0,10,1,158,0.070000,0,18,0,422,9431815);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3219,177,"Harvester Mining Drone Blueprint","",1009,0,0,0.010000,0,1,0,1e+007,0,0,0,0,9,0,422,730177);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3220,742,"Hardwiring - Zainou \'Deadeye\' ZGC110","A Zainou gunnery hardwiring designed to enhance falloff range. Grants a 4% bonus to turret falloff.",0,1,0,1,0,1,0,200000,1,1163,0.050000,0,20,2224,422,10684311);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3221,742,"Hardwiring - Zainou \'Deadeye\' ZGC1100","A Zainou gunnery hardwiring designed to enhance falloff range. Grants a 6% bonus to turret falloff.",0,1,0,1,0,1,0,0,1,1163,0.050000,0,20,2224,422,10684312);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3222,742,"Hardwiring - Zainou \'Deadeye\' ZGL11","A Zainou gunnery hardwiring designed to enhance skill with large hybrid turrets. Grants a 2% bonus to large hybrid turret Damage.",0,1,0,1,0,1,0,200000,1,1186,0.050000,0,20,2224,422,10684337);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3223,742,"Hardwiring - Zainou \'Deadeye\' ZGL110","A Zainou gunnery hardwiring designed to enhance skill with large hybrid turrets. Grants a 4% bonus to large hybrid turret Damage.",0,1,0,1,0,1,0,200000,1,1186,0.050000,0,20,2224,422,10684338);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3224,742,"Hardwiring - Zainou \'Deadeye\' ZGL1100","A Zainou gunnery hardwiring designed to enhance skill with large hybrid turrets. Grants a 6% bonus to large hybrid turret Damage.",0,1,0,1,0,1,0,0,1,1186,0.050000,0,20,2224,422,10684339);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3225,742,"Hardwiring - Zainou \'Deadeye\' ZGS11","A Zainou gunnery hardwiring designed to enhance skill with small hybrid turrets. Grants a 2% bonus to small hybrid turret Damage.",0,1,0,1,0,1,0,200000,1,1155,0.050000,0,20,2224,422,10684302);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3226,742,"Hardwiring - Zainou \'Deadeye\' ZGS110","A Zainou gunnery hardwiring designed to enhance skill with small hybrid turrets. Grants a 4% bonus to small hybrid turret Damage.",0,1,0,1,0,1,0,200000,1,1155,0.050000,0,20,2224,422,10684301);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3227,742,"Hardwiring - Zainou \'Deadeye\' ZGS1100","A Zainou gunnery hardwiring designed to enhance skill with small hybrid turrets. Grants a 6% bonus to small hybrid turret Damage.",0,1,0,1,0,1,0,0,1,1155,0.050000,0,20,2224,422,10684303);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3228,742,"Hardwiring - Zainou \'Gnome\' KZA750","A neural Interface upgrade that lowers turret CPU needs.",0,1,0,1,0,1,0,200000,1,1186,0.050000,0,20,2224,422,10684342);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3229,742,"Hardwiring - Zainou \'Gnome\' KZA1500","A neural Interface upgrade that lowers turret CPU needs.",0,1,0,1,0,1,0,200000,1,1186,0.050000,0,20,2224,422,10684340);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3230,742,"Hardwiring - Zainou \'Gnome\' KZA3000","A neural Interface upgrade that lowers turret CPU needs.",0,1,0,1,0,1,0,0,1,1186,0.050000,0,20,2224,422,10684341);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3231,742,"Hardwiring - Zainou \'Deadeye\' ZGM11","A Zainou gunnery hardwiring designed to enhance skill with medium hybrid turrets. Grants a 2% bonus to medium hybrid turret Damage.",0,1,0,1,0,1,0,200000,1,1171,0.050000,0,20,2224,422,10684319);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3232,742,"Hardwiring - Zainou \'Deadeye\' ZGM110","A Zainou gunnery hardwiring designed to enhance skill with medium hybrid turrets. Grants a 4% bonus to medium hybrid turret Damage.",0,1,0,1,0,1,0,200000,1,1171,0.050000,0,20,2224,422,10684320);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3233,742,"Hardwiring - Zainou \'Deadeye\' ZGM1100","A Zainou gunnery hardwiring designed to enhance skill with medium hybrid turrets. Grants a 6% bonus to medium hybrid turret Damage.",0,1,0,1,0,1,0,0,1,1171,0.050000,0,20,2224,422,10684321);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3234,742,"Hardwiring - Zainou \'Deadeye\' ZGA110","A Zainou gunnery hardwiring designed to enhance optimal range. Grants a 4% bonus to turret optimal range.",0,1,0,1,0,1,0,200000,1,1180,0.050000,0,20,2224,422,10684329);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3235,742,"Hardwiring - Zainou \'Deadeye\' ZGA1100","A Zainou gunnery hardwiring designed to enhance optimal range. Grants a 6% bonus to turret optimal range.",0,1,0,1,0,1,0,0,1,1180,0.050000,0,20,2224,422,10684330);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3236,742,"Hardwiring - Zainou \'Deadeye\' ZGC11","A Zainou gunnery hardwiring designed to enhance falloff range. Grants a 2% bonus to turret falloff.",0,1,0,1,0,1,0,200000,1,1163,0.050000,0,20,2224,422,10684310);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3237,741,"Hardwiring - Inherent Implants \'Squire\' CC3","A neural interface upgrade that boosts the pilot\'s skill at energy management.",0,1,0,1,0,1,0,200000,1,1170,0.050000,0,20,2224,422,10684430);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3238,741,"Hardwiring - Inherent Implants \'Squire\' CC6","A neural interface upgrade that boosts the pilot\'s skill at energy management.",0,1,0,1,0,1,0,200000,1,1170,0.050000,0,20,2224,422,10684416);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3239,741,"Hardwiring - Inherent Implants \'Squire\' CC10","A neural interface upgrade that boosts the pilot\'s skill at energy management.",0,1,0,1,0,1,0,200000,1,1170,0.050000,0,20,2224,422,10684431);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3240,741,"Hardwiring - Inherent Implants \'Squire\' CR3","A neural interface upgrade that boosts the pilot\'s skill at energy systems operation.",0,1,0,1,0,1,0,200000,1,1154,0.050000,0,20,2224,422,10684415);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3241,741,"Hardwiring - Inherent Implants \'Squire\' CR6","A neural interface upgrade that boosts the pilot\'s skill at energy systems operation.",0,1,0,1,0,1,0,200000,1,1154,0.050000,0,20,2224,422,10684500);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3242,52,"Warp Disruptor I","Disrupts the target ship\'s navigation computer which prevents it from warping.",0,0,0,5,0,1,0,39424,1,682,0.070000,0,7,111,422,9060075);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3243,132,"Warp Disruptor I Blueprint","",0,0,0,0.010000,0,1,0,394240,1,323,0,0,9,111,422,9060076);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3244,52,"Warp Disruptor II","Disrupts the target ship\'s navigation computer which prevents it from warping.",0,0,0,5,0,1,0,216916,1,682,0.060000,0,7,111,422,9060077);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3245,132,"Warp Disruptor II Blueprint","",0,0,0,0.010000,0,1,0,1e+007,1,0,0,0,9,111,422,9060078);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3246,741,"Hardwiring - Inherent Implants \'Squire\' CR10","A neural interface upgrade that boosts the pilot\'s skill at energy systems operation.",0,1,0,1,0,1,0,200000,1,1154,0.050000,0,20,2224,422,10684417);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3247,741,"Hardwiring - Inherent Implants \'Squire\' EE3","A neural interface upgrade that boosts the pilot\'s skill with energy emission systems.",0,1,0,1,0,1,0,200000,1,1162,0.050000,0,20,2224,422,10684421);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3248,741,"Hardwiring - Inherent Implants \'Squire\' EE6","A neural interface upgrade that boosts the pilot\'s skill with energy emission systems.",0,1,0,1,0,1,0,200000,1,1162,0.050000,0,20,2224,422,10684422);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3249,741,"Hardwiring - Inherent Implants \'Squire\' EE10","A neural interface upgrade that boosts the pilot\'s skill with energy emission systems.",0,1,0,1,0,1,0,200000,1,1162,0.050000,0,20,2224,422,10684423);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3250,741,"Hardwiring - Inherent Implants \'Squire\' EP3","A neural interface upgrade that boosts the pilot\'s skill with energy pulse weapons.",0,1,0,1,0,1,0,200000,1,1162,0.050000,0,20,2224,422,10684425);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3251,741,"Hardwiring - Inherent Implants \'Squire\' EP6","A neural interface upgrade that boosts the pilot\'s skill with energy pulse weapons.",0,1,0,1,0,1,0,200000,1,1162,0.050000,0,20,2224,422,10684426);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3252,741,"Hardwiring - Inherent Implants \'Squire\' EP10","A neural interface upgrade that boosts the pilot\'s skill with energy pulse weapons.",0,1,0,1,0,1,0,200000,1,1162,0.050000,0,20,2224,422,10684424);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3253,741,"Hardwiring - Inherent Implants \'Squire\' GU3","A neural interface upgrade that boosts the pilot\'s skill with energy grid upgrades.",0,1,0,1,0,1,0,200000,1,1162,0.050000,0,20,2224,422,10684428);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3254,741,"Hardwiring - Inherent Implants \'Squire\' GU6","A neural interface upgrade that boosts the pilot\'s skill with energy grid upgrades.",0,1,0,1,0,1,0,200000,1,1162,0.050000,0,20,2224,422,10684429);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3255,741,"Hardwiring - Inherent Implants \'Squire\' GU10","A neural interface upgrade that boosts the pilot\'s skill with energy grid upgrades.",0,1,0,1,0,1,0,200000,1,1162,0.050000,0,20,2224,422,10684427);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3256,741,"Hardwiring - Inherent Implants \'Squire\' PG3","A neural interface upgrade that boosts the pilot\'s skill at engineering.",0,1,0,1,0,1,0,200000,1,1154,0.050000,0,20,2224,422,10684418);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3257,741,"Hardwiring - Inherent Implants \'Squire\' PG6","A neural interface upgrade that boosts the pilot\'s skill at engineering.",0,1,0,1,0,1,0,200000,1,1154,0.050000,0,20,2224,422,10684419);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3258,741,"Hardwiring - Inherent Implants \'Squire\' PG10","A neural interface upgrade that boosts the pilot\'s skill at engineering.",0,1,0,1,0,1,0,200000,1,1154,0.050000,0,20,2224,422,10684420);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3259,1053,"Orkashu Pontine","Subject: Prototype Nation Vessel (ID: Orkashu Pontine)


 Frigate-class vessel. Significant microwarp velocity. Limited weapons systems.


Est. 1,200,000 civilian abductions from Orkashu IV during the chaos caused by four simultaneous invasions, each launched in a different empire’s space.

The Pontine identifier suggests a role in coordinating pre-established orders, and that perhaps this vessel sits at the very lowest rung of the new Nation hierarchy.

Synopsis from ISHAEKA-0040. DED Special Operations.
Authorized for Capsuleer dissemination.   

",1237,31,2e+006,20000,235,1,4,0,0,0,0,31,11,0,0,9393923);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3260,186,"Sanshas Supercarrier Wreck","The remains of a destroyed ship. Perhaps with the proper equipment something of value could be salvaged from it. ",10674,14,10000,27500,27500,1,0,0,0,0,0,0,2,0,0,9632824);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3261,306,"Logistics Control Array","This array is responsible for determining friend or foe status for local remote logistics facilities. Although formidable, a capsuleer should be able to subvert the sophisticated electronics within.",2363,755,10000,27500,2700,1,0,0,0,0,0,0,11,0,0,9384800);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3262,740,"Hardwiring - Zainou \'Gypsy\' KLB-38","A neural interface upgrade that boosts the pilot\'s skill with electronics upgrades.",0,1,0,1,0,1,0,200000,1,1153,0.050000,0,20,2224,422,10684465);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3263,740,"Hardwiring - Zainou \'Gypsy\' KLB-63","A neural interface upgrade that boosts the pilot\'s skill with electronics upgrades.",0,1,0,1,0,1,0,200000,1,1153,0.050000,0,20,2224,422,10684466);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3264,740,"Hardwiring - Zainou \'Gypsy\' KLB-88","A neural interface upgrade that boosts the pilot\'s skill with electronics upgrades.",0,1,0,1,0,1,0,200000,1,1153,0.050000,0,20,2224,422,10684467);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3265,740,"Hardwiring - Zainou \'Gypsy\' KMB-38","A neural interface upgrade that boosts the pilot\'s skill at electronics.",0,1,0,1,0,1,0,200000,1,1153,0.050000,0,20,2224,422,10684468);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3266,740,"Hardwiring - Zainou \'Gypsy\' KMB-63","A neural interface upgrade that boosts the pilot\'s skill at electronics.",0,1,0,1,0,1,0,200000,1,1153,0.050000,0,20,2224,422,10684469);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3267,740,"Hardwiring - Zainou \'Gypsy\' KMB-88","A neural interface upgrade that boosts the pilot\'s skill at electronics.",0,1,0,1,0,1,0,200000,1,1153,0.050000,0,20,2224,422,10684470);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3268,740,"Hardwiring - Zainou \'Gypsy\' KNB-38","A neural interface upgrade that boosts the pilot\'s skill at operating targeting systems.",0,1,0,1,0,1,0,200000,1,1161,0.050000,0,20,2224,422,10684501);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3269,740,"Hardwiring - Zainou \'Gypsy\' KNB-63","A neural interface upgrade that boosts the pilot\'s skill at operating targeting systems.",0,1,0,1,0,1,0,200000,1,1161,0.050000,0,20,2224,422,10684472);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3270,740,"Hardwiring - Zainou \'Gypsy\' KNB-88","A neural interface upgrade that boosts the pilot\'s skill at operating targeting systems.",0,1,0,1,0,1,0,200000,1,1161,0.050000,0,20,2224,422,10684473);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3271,740,"Hardwiring - Zainou \'Gypsy\' KOB-38","A neural interface upgrade that boosts the pilot\'s skill at electronic warfare.",0,1,0,1,0,1,0,200000,1,1179,0.050000,0,20,2224,422,10684488);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3272,740,"Hardwiring - Zainou \'Gypsy\' KOB-63","A neural interface upgrade that boosts the pilot\'s skill at electronic warfare.",0,1,0,1,0,1,0,200000,1,1179,0.050000,0,20,2224,422,10684489);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3273,740,"Hardwiring - Zainou \'Gypsy\' KOB-88","A neural interface upgrade that boosts the pilot\'s skill at electronic warfare.",0,1,0,1,0,1,0,200000,1,1179,0.050000,0,20,2224,422,10684490);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3274,740,"Hardwiring - Zainou \'Gypsy\' KPB-38","A neural interface upgrade that boosts the pilot\'s skill at long range targeting.",0,1,0,1,0,1,0,200000,1,1169,0.050000,0,20,2224,422,10684476);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3275,740,"Hardwiring - Zainou \'Gypsy\' KPB-63","A neural interface upgrade that boosts the pilot\'s skill at long range targeting.",0,1,0,1,0,1,0,200000,1,1169,0.050000,0,20,2224,422,10684477);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3276,740,"Hardwiring - Zainou \'Gypsy\' KPB-88","A neural interface upgrade that boosts the pilot\'s skill at long range targeting.",0,1,0,1,0,1,0,200000,1,1169,0.050000,0,20,2224,422,10684481);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3277,740,"Hardwiring - Zainou \'Gypsy\' KQB-38","A neural interface upgrade that boosts the pilot\'s skill at propulsion jamming.",0,1,0,1,0,1,0,200000,1,1169,0.050000,0,20,2224,422,10684485);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3278,740,"Hardwiring - Zainou \'Gypsy\' KQB-63","A neural interface upgrade that boosts the pilot\'s skill at propulsion jamming.",0,1,0,1,0,1,0,200000,1,1169,0.050000,0,20,2224,422,10684487);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3279,740,"Hardwiring - Zainou \'Gypsy\' KQB-88","A neural interface upgrade that boosts the pilot\'s skill at propulsion jamming.",0,1,0,1,0,1,0,200000,1,1169,0.050000,0,20,2224,422,10684486);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3280,740,"Hardwiring - Zainou \'Gypsy\' KRB-38","A neural interface upgrade that boosts the pilot\'s skill at sensor linking.",0,1,0,1,0,1,0,200000,1,1179,0.050000,0,20,2224,422,10684491);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3281,740,"Hardwiring - Zainou \'Gypsy\' KRB-63","A neural interface upgrade that boosts the pilot\'s skill at sensor linking.",0,1,0,1,0,1,0,200000,1,1179,0.050000,0,20,2224,422,10684492);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3282,740,"Hardwiring - Zainou \'Gypsy\' KRB-88","A neural interface upgrade that boosts the pilot\'s skill at sensor linking.",0,1,0,1,0,1,0,200000,1,1179,0.050000,0,20,2224,422,10684493);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3283,740,"Hardwiring - Zainou \'Gypsy\' KSB-38","A neural interface upgrade that boosts the pilot\'s skill at weapon disruption.",0,1,0,1,0,1,0,200000,1,1179,0.050000,0,20,2224,422,10684494);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3284,740,"Hardwiring - Zainou \'Gypsy\' KSB-63","A neural interface upgrade that boosts the pilot\'s skill at weapon disruption.",0,1,0,1,0,1,0,200000,1,1179,0.050000,0,20,2224,422,10684495);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3285,53,"Quad Light Beam Laser II","Uses four light laser focusing systems. Low powered, but makes up for it with a fast firing rate. 


Gamma, Infrared, Microwave, Multifrequency, Radio, Standard, Ultraviolet, Xray, Aurora, Gleam.",11199,0,1,10,1,1,0,218020,1,568,0.060000,0,7,355,422,13157563);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3286,133,"Quad Light Beam Laser II Blueprint","",355,0,0,0.010000,0,1,0,1e+007,1,293,0,0,9,355,422,730195);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3287,740,"Hardwiring - Zainou \'Gypsy\' KSB-88","A neural interface upgrade that boosts the pilot\'s skill at weapon disruption.",0,1,0,1,0,1,0,200000,1,1179,0.050000,0,20,2224,422,10684496);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3288,740,"Hardwiring - Zainou \'Gypsy\' KTB-38","A neural interface upgrade that boosts the pilot\'s skill at target painting.",0,1,0,1,0,1,0,200000,1,1179,0.050000,0,20,2224,422,10684497);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3289,740,"Hardwiring - Zainou \'Gypsy\' KTB-63","A neural interface upgrade that boosts the pilot\'s skill at target painting.",0,1,0,1,0,1,0,200000,1,1179,0.050000,0,20,2224,422,10684498);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3290,740,"Hardwiring - Zainou \'Gypsy\' KTB-88","A neural interface upgrade that boosts the pilot\'s skill at target painting.",0,1,0,1,0,1,0,200000,1,1179,0.050000,0,20,2224,422,10684499);
INSERT INTO invTypes (typeID,groupID,typeName,description,graphicID,radius,mass,volume,capacity,portionSize,raceID,basePrice,published,marketGroupID,chanceOfDuplicating,soundID,categoryID,iconID,attributeID,dataID) VALUES (3291,738,"Hardwiring - Inherent Implants \'Noble\' ZET11","A neural Interface upgrade that boosts the pilot\'s skill in operating armor/hull repair modules. 2% reduction in repair systems duration.",0,1,0,1,0,1